/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.anttask;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.fjep.anttask.FJFileSourceType;
import net.sf.fjep.anttask.FJJarSourceType;
import net.sf.fjep.anttask.FJManifestType;
import net.sf.fjep.fatjar.builder.ByteArrayFileSystemElement;
import net.sf.fjep.fatjar.builder.FatJarBuilder;
import net.sf.fjep.fatjar.builder.FileSystemSourceFilter;
import net.sf.fjep.fatjar.builder.IFileSystemSource;
import net.sf.fjep.fatjar.builder.JARFileSystemSource;
import net.sf.fjep.fatjar.builder.NativeFileSystemSource;
import net.sf.fjep.fatjar.builder.OneJarBuilder;
import net.sf.fjep.fatjar.builder.VirtualFileSystemSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class FJBuildTask
extends Task {
    private ArrayList sources = new ArrayList();
    private String output;
    private boolean onejar = false;
    private FJManifestType manifestType = null;

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public boolean getOnejar() {
        return this.onejar;
    }

    public void setOnejar(boolean onejar) {
        this.onejar = onejar;
    }

    public void execute() throws BuildException {
        try {
            if (this.onejar) {
                this.doBuildOneJar();
            } else {
                this.doBuildFatJar();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("build '" + this.output + "' error: " + e.getMessage());
        }
    }

    private void doBuildFatJar() throws IOException {
        System.out.println("Build Output='" + this.output + "'");
        FatJarBuilder builder = new FatJarBuilder(String.valueOf(this.output.replace('.', '_')) + "_temp_eraseme");
        if (this.manifestType != null) {
            System.out.println(this.manifestType.toString());
            String manifestText = this.manifestType.getManifestText();
            VirtualFileSystemSource vsource = new VirtualFileSystemSource();
            vsource.add(new ByteArrayFileSystemElement("META-INF", "MANIFEST.MF", manifestText.getBytes()));
            builder.addSource(vsource);
            builder.addConflictResolver(this.manifestType.getConflictResolver());
        }
        Iterator iter = this.sources.iterator();
        while (iter.hasNext()) {
            String relPath;
            Object o = iter.next();
            if (o instanceof FJFileSourceType) {
                FJFileSourceType fjFileSource = (FJFileSourceType)o;
                System.out.println("adding native file system source '" + fjFileSource.getPath() + "'");
                File folder = new File(fjFileSource.getPath());
                relPath = fjFileSource.getRelPath();
                String virtualName = fjFileSource.getVirtualName();
                IFileSystemSource fileSystemSource = new NativeFileSystemSource(folder, relPath, virtualName);
                String[] excludes = fjFileSource.getExcludes();
                String[] excludesRX = fjFileSource.getExcludesRX();
                if (excludes.length + excludesRX.length > 0) {
                    System.out.println("excluding " + excludes.length + " entries and " + excludesRX.length + " patterns");
                    fileSystemSource = new FileSystemSourceFilter(fileSystemSource, excludes, excludesRX);
                }
                builder.addSource(fileSystemSource);
                continue;
            }
            if (!(o instanceof FJJarSourceType)) continue;
            FJJarSourceType fjJarSource = (FJJarSourceType)o;
            System.out.println("adding jar file source '" + fjJarSource.getFile() + "'");
            String jarFilename = fjJarSource.getFile();
            relPath = fjJarSource.getRelPath();
            IFileSystemSource fileSystemSource = new JARFileSystemSource(jarFilename, relPath);
            String[] excludes = fjJarSource.getExcludes();
            String[] excludesRX = fjJarSource.getExcludesRX();
            if (this.manifestType.isRemovesigners()) {
                String[] newExcludesRX = new String[excludesRX.length + 1];
                System.arraycopy(excludesRX, 0, newExcludesRX, 0, excludesRX.length);
                newExcludesRX[excludesRX.length] = "META-INF[/\\\\][^/\\\\]+[.]SF";
                excludesRX = newExcludesRX;
            }
            if (excludes.length + excludesRX.length > 0) {
                System.out.println("excluding " + excludes.length + " entries and " + excludesRX.length + " patterns");
                fileSystemSource = new FileSystemSourceFilter(fileSystemSource, excludes, excludesRX);
            }
            builder.addSource(fileSystemSource);
        }
        builder.build(this.output);
    }

    private void doBuildOneJar() throws IOException {
        System.out.println("Build One-Jar Output='" + this.output + "'");
        OneJarBuilder builder = new OneJarBuilder(String.valueOf(this.output.replace('.', '_')) + "_temp_eraseme");
        if (this.manifestType != null) {
            System.out.println(this.manifestType.toString());
            String manifestText = this.manifestType.getManifestText();
            VirtualFileSystemSource vsource = new VirtualFileSystemSource();
            vsource.add(new ByteArrayFileSystemElement("META-INF", "MANIFEST.MF", manifestText.getBytes()));
            builder.addSource(vsource);
            builder.addConflictResolver(this.manifestType.getConflictResolver());
        }
        Iterator iter = this.sources.iterator();
        while (iter.hasNext()) {
            String relPath;
            Object o = iter.next();
            if (o instanceof FJFileSourceType) {
                FJFileSourceType fjFileSource = (FJFileSourceType)o;
                System.out.println("adding native file system source '" + fjFileSource.getPath() + "'");
                File folder = new File(fjFileSource.getPath());
                relPath = fjFileSource.getRelPath();
                String virtualName = fjFileSource.getVirtualName();
                IFileSystemSource fileSystemSource = new NativeFileSystemSource(folder, relPath, virtualName);
                String[] excludes = fjFileSource.getExcludes();
                String[] excludesRX = fjFileSource.getExcludesRX();
                if (excludes.length + excludesRX.length > 0) {
                    System.out.println("excluding " + excludes.length + " entries and " + excludesRX.length + " patterns");
                    fileSystemSource = new FileSystemSourceFilter(fileSystemSource, excludes, excludesRX);
                }
                builder.addSource(fileSystemSource);
                continue;
            }
            if (!(o instanceof FJJarSourceType)) continue;
            FJJarSourceType fjJarSource = (FJJarSourceType)o;
            System.out.println("adding jar file source '" + fjJarSource.getFile() + "'");
            String jarFilename = fjJarSource.getFile();
            relPath = fjJarSource.getRelPath();
            IFileSystemSource fileSystemSource = new JARFileSystemSource(jarFilename, relPath);
            String[] excludes = fjJarSource.getExcludes();
            String[] excludesRX = fjJarSource.getExcludesRX();
            if (excludes.length + excludesRX.length > 0) {
                System.out.println("excluding " + excludes.length + " entries and " + excludesRX.length + " patterns");
                fileSystemSource = new FileSystemSourceFilter(fileSystemSource, excludes, excludesRX);
            }
            builder.addSource(fileSystemSource);
        }
        builder.build(this.output);
    }

    public void addConfigured(FJFileSourceType source) {
        this.sources.add(source);
    }

    public void addConfigured(FJJarSourceType source) {
        this.sources.add(source);
    }

    public void addConfigured(FJManifestType manifestType) {
        this.manifestType = manifestType;
    }
}

