/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.anttask;

import java.io.File;
import net.sf.fjep.fatjar.builder.IConflictResolver;
import net.sf.fjep.fatjar.builder.ManifestConflictResolver;
import net.sf.fjep.utils.FileUtils;

public class FJManifestType {
    private boolean mergemanifests = true;
    private boolean removesigners = true;
    private String mainclass = "";
    private String classpath = "";
    private String manifestfile = "";

    public boolean isMergemanifests() {
        return this.mergemanifests;
    }

    public void setMergemanifests(boolean mergemanifests) {
        this.mergemanifests = mergemanifests;
    }

    public boolean isRemovesigners() {
        return this.removesigners;
    }

    public void setRemovesigners(boolean removesigners) {
        this.removesigners = removesigners;
    }

    public String getMainclass() {
        return this.mainclass;
    }

    public void setMainclass(String mainClass) {
        this.mainclass = mainClass;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClassPath(String classpath) {
        this.classpath = classpath;
    }

    public String getManifestfile() {
        return this.manifestfile;
    }

    public void setManifestfile(String manifestfile) {
        this.manifestfile = manifestfile;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("manifest[");
        if (this.mergemanifests) {
            result.append("merge,");
        }
        if (this.removesigners) {
            result.append("removesigners,");
        }
        if (!this.manifestfile.equals("")) {
            result.append("file='");
            result.append(this.manifestfile);
            result.append("',");
        } else {
            if (!this.mainclass.equals("")) {
                result.append("main='");
                result.append(this.mainclass);
                result.append("',");
            }
            if (!this.classpath.equals("")) {
                result.append("classpath='");
                result.append(this.classpath);
                result.append("',");
            }
        }
        result.setCharAt(result.length() - 1, ']');
        return result.toString();
    }

    public IConflictResolver getConflictResolver() {
        ManifestConflictResolver resolver = new ManifestConflictResolver(this.mergemanifests);
        return resolver;
    }

    public String getManifestText() {
        String result = "";
        if (!this.manifestfile.equals("")) {
            result = FileUtils.readContent(new File(this.manifestfile));
        } else {
            result = "Manifest-Version: 1.0\r\n";
            result = String.valueOf(result) + "Created-By: Fat Jar Eclipse Plug-In\r\n";
            if (this.mainclass != null && !this.mainclass.trim().equals("")) {
                result = String.valueOf(result) + "Main-Class: " + this.mainclass + "\r\n";
            }
            if (this.classpath != null && !this.classpath.trim().equals("")) {
                result = String.valueOf(result) + "Class-Path: " + this.classpath + "\r\n";
            }
            result = String.valueOf(result) + "\r\n";
        }
        return result;
    }
}

