/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import net.sf.fjep.fatjar.builder.IConflictResolver;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.IFileSystemSource;
import net.sf.fjep.fatjar.builder.JarBuilder;
import net.sf.fjep.fatjar.builder.NativeFileSystemSource;
import net.sf.fjep.utils.FileUtils;

public class FatJarBuilder {
    private String tempBuildDir = null;
    private ArrayList fileSystemSources = null;
    private ArrayList conflictResolvers = null;

    public FatJarBuilder(String tempBuildDir) {
        this.tempBuildDir = tempBuildDir;
        this.fileSystemSources = new ArrayList();
        this.conflictResolvers = new ArrayList();
    }

    public void addSource(IFileSystemSource fileSource) {
        if (!this.fileSystemSources.contains(fileSource)) {
            this.fileSystemSources.add(fileSource);
        }
    }

    public void addConflictResolver(IConflictResolver conflictResolver) {
        if (!this.conflictResolvers.contains(conflictResolver)) {
            this.conflictResolvers.add(conflictResolver);
        }
    }

    public void build(String fatJarFilename) {
        this.clean();
        this.collect();
        this.pack(fatJarFilename);
        this.clean();
    }

    private void collect() {
        Iterator iterator = this.fileSystemSources.iterator();
        while (iterator.hasNext()) {
            IFileSystemSource fileSystemSource = (IFileSystemSource)iterator.next();
            while (fileSystemSource.hasMoreElements()) {
                IFileSystemElement fileSystemElement = fileSystemSource.nextElement();
                String elementFolder = fileSystemElement.getFolder();
                File folder = new File(this.tempBuildDir, elementFolder);
                FileUtils.mkDirs(folder);
                if (fileSystemElement.isFolder()) continue;
                String elementName = fileSystemElement.getName();
                File outputFile = new File(folder, elementName);
                if (outputFile.exists()) {
                    this.resolveConflicts(outputFile, fileSystemElement);
                    continue;
                }
                InputStream fileStream = fileSystemElement.getStream();
                FileUtils.writeToFile(outputFile, fileStream);
            }
        }
    }

    private void resolveConflicts(File conflictOutputFile, IFileSystemElement fileSystemElement) {
        boolean ok = false;
        Iterator iterator = this.conflictResolvers.iterator();
        while (iterator.hasNext()) {
            IConflictResolver conflictResolver = (IConflictResolver)iterator.next();
            ok = conflictResolver.handleConflict(conflictOutputFile, fileSystemElement);
            if (ok) break;
        }
        if (!ok) {
            System.out.println("not resolving conflict in file " + fileSystemElement.getFolder() + File.separator + fileSystemElement.getName());
        }
    }

    private void clean() {
        FileUtils.recursiveRm(new File(this.tempBuildDir));
    }

    private void pack(String jarName) {
        JarBuilder newJar = new JarBuilder(jarName);
        NativeFileSystemSource source = new NativeFileSystemSource(new File(this.tempBuildDir), "");
        while (source.hasMoreElements()) {
            IFileSystemElement element = source.nextElement();
            newJar.add(element);
        }
        newJar.close();
    }

    public static void main(String[] args) {
        String absFilename = "U:/opt/eclipse301/runtime-workbench-workspace/AntExportTest/classes/aet/AETMain.class";
        String relFilename = "aet/AETMain.class";
        NativeFileSystemSource s = new NativeFileSystemSource(new File(absFilename), relFilename);
        while (s.hasMoreElements()) {
            IFileSystemElement e = s.nextElement();
            System.out.println(e);
        }
    }
}

