/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.IFileSystemSource;

public class FileSystemSourceFilter
implements IFileSystemSource {
    private IFileSystemSource source;
    private IFileSystemElement next;
    private String[] excludes = null;
    private String[] excludeFolders = null;
    private String[] rxExcludes = null;

    public FileSystemSourceFilter(IFileSystemSource source, String[] excludes, String[] rxExcludes) {
        this.source = source;
        if (excludes != null && excludes.length > 0) {
            this.excludes = new String[excludes.length];
            this.excludeFolders = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                String exclude;
                this.excludes[i] = exclude = excludes[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
                this.excludeFolders[i] = exclude.endsWith(File.separator) ? exclude : String.valueOf(exclude) + File.separatorChar;
                ++i;
            }
        }
        if (rxExcludes != null && rxExcludes.length > 0) {
            this.rxExcludes = rxExcludes;
        }
        this.next = null;
    }

    public String getDescription() {
        String result = this.source.getDescription();
        if (this.excludes != null) {
            result = String.valueOf(result) + " (filtered " + Integer.toString(this.excludes.length) + " elements)";
        }
        return result;
    }

    public boolean hasMoreElements() {
        if (this.next == null) {
            this.next = this.nextElement();
        }
        return this.next != null;
    }

    public IFileSystemElement nextElement() {
        if (this.next == null) {
            while (this.source.hasMoreElements()) {
                IFileSystemElement element = this.source.nextElement();
                if (!this.checkNotExcluded(element)) continue;
                this.next = element;
                break;
            }
        }
        IFileSystemElement result = this.next;
        this.next = null;
        return result;
    }

    private boolean checkNotExcluded(IFileSystemElement fileSystemElement) {
        int i;
        boolean result = true;
        String path = fileSystemElement.getFullName();
        if (result && this.rxExcludes != null) {
            i = 0;
            while (i < this.rxExcludes.length) {
                String rxExclude = this.rxExcludes[i];
                if (path.matches(rxExclude)) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        if (result && this.excludes != null) {
            i = 0;
            while (i < this.excludes.length) {
                String cfr_ignored_0 = this.excludes[i];
                if (path.equals(this.excludes[i])) {
                    result = false;
                    break;
                }
                if (path.startsWith(this.excludeFolders[i])) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

