/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.fjep.fatjar.builder.AbstractFileSystemElement;

public class JARFileSystemElement
extends AbstractFileSystemElement {
    private JarFile jarFile;
    private JarEntry jarEntry;

    public JARFileSystemElement(JarFile jarFile, JarEntry jarEntry, String relFolder) {
        String dir;
        this.jarFile = jarFile;
        this.jarEntry = jarEntry;
        String entryName = jarEntry.getName();
        entryName = entryName.replace('/', File.separatorChar);
        this.folder = relFolder;
        if (jarEntry.isDirectory()) {
            dir = entryName.substring(0, entryName.length() - 1);
            this.name = null;
        } else {
            int pos = entryName.lastIndexOf(File.separatorChar);
            if (pos == -1) {
                dir = "";
                this.name = entryName;
            } else {
                dir = entryName.substring(0, pos);
                this.name = entryName.substring(pos + 1);
            }
        }
        this.folder = relFolder.equals("") ? dir : (dir.equals("") ? relFolder : String.valueOf(relFolder) + File.separatorChar + dir);
    }

    public boolean isFolder() {
        return this.jarEntry.isDirectory();
    }

    public long getSize() {
        return this.jarEntry.getSize();
    }

    public InputStream getStream() {
        InputStream result = null;
        try {
            result = this.jarFile.getInputStream(this.jarEntry);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public long lastModificationTime() {
        return this.jarEntry.getTime();
    }
}

