/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.fjep.fatjar.builder.AbstractFileSystemSource;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.JARFileSystemElement;

public class JARFileSystemSource
extends AbstractFileSystemSource {
    private String jarFilename;
    private Enumeration jarEntriesEnum;
    private JarFile jarFile;
    private String relFolder;

    public JARFileSystemSource(String jarFilename, String relFolder) throws IOException {
        this.jarFilename = jarFilename;
        this.relFolder = relFolder;
        this.description = "jar " + jarFilename + " " + relFolder;
        this.jarFile = new JarFile(jarFilename);
        this.jarEntriesEnum = this.jarFile.entries();
    }

    public IFileSystemElement nextUnqueuedElement() {
        JarEntry jarEntry;
        JARFileSystemElement result = null;
        if (this.jarEntriesEnum.hasMoreElements() && (jarEntry = (JarEntry)this.jarEntriesEnum.nextElement()) != null) {
            result = new JARFileSystemElement(this.jarFile, jarEntry, this.relFolder);
        }
        return result;
    }

    public String getJarFilename() {
        return this.jarFilename;
    }
}

