/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.IJarBuilder;
import net.sf.fjep.utils.FileUtils;

public class JarBuilder
implements IJarBuilder {
    private JarOutputStream jarro = null;
    byte[] syncBuffer = null;

    public JarBuilder(String jarFileName) {
        try {
            this.syncBuffer = new byte[8192];
            FileUtils.mkParentDirs(jarFileName);
            FileOutputStream out = new FileOutputStream(jarFileName);
            this.jarro = new JarOutputStream(out);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void add(File f, String relName) {
        try {
            if (f.isDirectory()) {
                String dirName = relName.replace(File.separatorChar, '/');
                if (!dirName.endsWith("/")) {
                    dirName = String.valueOf(dirName) + "/";
                }
                JarEntry entry = new JarEntry(dirName);
                this.jarro.putNextEntry(entry);
                this.jarro.closeEntry();
            } else {
                JarEntry entry = new JarEntry(relName.replace(File.separatorChar, '/'));
                entry.setSize(f.length());
                entry.setTime(f.lastModified());
                this.jarro.putNextEntry(entry);
                FileInputStream in = new FileInputStream(f);
                int cnt = in.read(this.syncBuffer);
                while (cnt > 0) {
                    this.jarro.write(this.syncBuffer, 0, cnt);
                    cnt = in.read(this.syncBuffer);
                }
                this.jarro.closeEntry();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void add(IFileSystemElement src) {
        try {
            if (src.isFolder()) {
                String dirName = String.valueOf(src.getFolder().replace(File.separatorChar, '/')) + '/';
                JarEntry entry = new JarEntry(dirName);
                this.jarro.putNextEntry(entry);
                this.jarro.closeEntry();
            } else {
                String relName = src.getFolder().equals("") ? src.getName() : String.valueOf(src.getFolder()) + File.separatorChar + src.getName();
                JarEntry entry = new JarEntry(relName.replace(File.separatorChar, '/'));
                entry.setSize(src.getSize());
                entry.setTime(src.lastModificationTime());
                this.jarro.putNextEntry(entry);
                InputStream in = src.getStream();
                int cnt = in.read(this.syncBuffer);
                while (cnt > 0) {
                    this.jarro.write(this.syncBuffer, 0, cnt);
                    cnt = in.read(this.syncBuffer);
                }
                this.jarro.closeEntry();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void add(JarEntry srcEntry, InputStream in) {
        try {
            JarEntry entry = new JarEntry(srcEntry);
            if (srcEntry.isDirectory()) {
                this.jarro.putNextEntry(entry);
                this.jarro.closeEntry();
            } else {
                this.jarro.putNextEntry(entry);
                int cnt = in.read(this.syncBuffer);
                while (cnt > 0) {
                    this.jarro.write(this.syncBuffer, 0, cnt);
                    cnt = in.read(this.syncBuffer);
                }
                this.jarro.closeEntry();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        try {
            this.jarro.flush();
            this.jarro.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

