/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import net.sf.fjep.fatjar.builder.IConflictResolver;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.utils.FileUtils;

public class ManifestConflictResolver
implements IConflictResolver {
    private boolean mergeManifests;

    public ManifestConflictResolver(boolean mergeManifests) {
        this.mergeManifests = mergeManifests;
    }

    public boolean handleConflict(File conflictOutputFile, IFileSystemElement fileSystemElement) {
        boolean resolved = false;
        if (conflictOutputFile.getName().equalsIgnoreCase("MANIFEST.MF")) {
            String oldManifest = FileUtils.readContent(conflictOutputFile);
            String newManifest = FileUtils.readContent(fileSystemElement.getStream());
            String mergeManifest = this.mergeManifests(oldManifest, newManifest);
            FileUtils.writeToFile(conflictOutputFile, mergeManifest);
            resolved = true;
        }
        return resolved;
    }

    private String mergeManifests(String oldManifest, String newManifest) {
        String result;
        if (!this.mergeManifests) {
            result = oldManifest;
        } else {
            String newIndividualSection = this.getIndividualSection(newManifest);
            result = oldManifest;
            if (!oldManifest.endsWith("\r\n")) {
                result = String.valueOf(result) + "\r\n\r\n";
            } else if (!oldManifest.endsWith("\r\n\r\n")) {
                result = String.valueOf(result) + "\r\n";
            }
            result = String.valueOf(result) + newIndividualSection;
        }
        return result;
    }

    private String getIndividualSection(String manifestText) {
        String result = "";
        int lastpos = 0;
        int pos = manifestText.indexOf(10, lastpos);
        while (pos > 0) {
            String line = manifestText.substring(lastpos, pos);
            if (line.trim().equals("")) {
                result = manifestText.substring(pos + 1);
                break;
            }
            lastpos = pos + 1;
            pos = manifestText.indexOf(10, lastpos);
        }
        return result;
    }
}

