/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import net.sf.fjep.fatjar.builder.AbstractFileSystemElement;

public class NativeFileSystemElement
extends AbstractFileSystemElement {
    private File file;

    public NativeFileSystemElement(File parent, String virtualFolder, String name) {
        this.name = name;
        this.folder = virtualFolder;
        this.file = name == null ? parent : new File(parent, name);
    }

    public NativeFileSystemElement(File parent, String virtualFolder, String name, String virtualName) {
        this.name = virtualName;
        this.folder = virtualFolder;
        this.file = name == null ? parent : new File(parent, name);
    }

    public long getSize() {
        long result = 0L;
        if (!this.isFolder()) {
            result = this.file.length();
        }
        return result;
    }

    public InputStream getStream() {
        FileInputStream result = null;
        if (!this.isFolder()) {
            try {
                result = new FileInputStream(this.file);
            }
            catch (Exception exception) {
                System.err.println("could not get FileInputStream for " + this.file.getPath());
            }
        }
        return result;
    }

    public long lastModificationTime() {
        return this.file.lastModified();
    }
}

