/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.util.Enumeration;
import java.util.Stack;
import net.sf.fjep.fatjar.builder.AbstractFileSystemSource;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.NativeFileSystemElement;

public class NativeFileSystemSource
extends AbstractFileSystemSource {
    private String relFolder;
    private Stack folderEnumStack;
    private FolderEnum currentFolderEnum;
    private Stack relFolderStack;
    private String currentRelFolder;
    private Stack folderStack;
    private File folder;
    private Stack elementStack;
    private String virtualName;

    public NativeFileSystemSource(File folder, String relFolder) {
        this(folder, relFolder, "");
    }

    public NativeFileSystemSource(File folder, String relFolder, String virtualName) {
        this.folder = folder;
        this.relFolder = relFolder;
        this.virtualName = virtualName == null ? "" : virtualName;
        this.description = "native " + relFolder;
        this.folderEnumStack = new Stack();
        this.currentFolderEnum = new FolderEnum(folder);
        this.relFolderStack = new Stack();
        this.currentRelFolder = relFolder;
        this.folderStack = new Stack();
        if (folder.isFile()) {
            System.out.println("SPECIAL handling for file instead of folder!");
            String name = folder.getName();
            if (!this.virtualName.equals("")) {
                this.currentRelFolder = this.relFolder = relFolder.replace('\\', '/');
            } else if (relFolder.equals(name)) {
                this.currentRelFolder = this.relFolder = "";
            } else if (relFolder.replace('\\', '/').endsWith(String.valueOf('/') + name)) {
                this.currentRelFolder = this.relFolder = relFolder.substring(0, relFolder.replace('\\', '/').lastIndexOf(47));
            }
            this.folder = folder.getParentFile();
            this.currentFolderEnum = new FolderEnum(new String[]{name});
        }
    }

    public IFileSystemElement nextUnqueuedElement() {
        IFileSystemElement result = null;
        String name = null;
        if (this.currentFolderEnum.hasMoreElements()) {
            name = (String)this.currentFolderEnum.nextElement();
        }
        while (name == null && !this.folderStack.isEmpty()) {
            this.currentRelFolder = (String)this.relFolderStack.pop();
            this.folder = (File)this.folderStack.pop();
            this.currentFolderEnum = (FolderEnum)this.folderEnumStack.pop();
            if (!this.currentFolderEnum.hasMoreElements()) continue;
            name = (String)this.currentFolderEnum.nextElement();
        }
        if (name != null) {
            File f = new File(this.folder, name);
            if (f.isDirectory()) {
                this.folderEnumStack.push(this.currentFolderEnum);
                this.currentFolderEnum = new FolderEnum(f);
                this.folderStack.push(this.folder);
                this.folder = f;
                this.relFolderStack.push(this.currentRelFolder);
                this.currentRelFolder = this.currentRelFolder.equals("") ? name : String.valueOf(this.currentRelFolder) + File.separatorChar + name;
                result = this.currentFolderEnum.hasMoreElements() ? this.nextUnqueuedElement() : new NativeFileSystemElement(this.folder, this.currentRelFolder, null);
            } else if (!this.virtualName.equals("")) {
                System.err.println("renaming file '" + name + "' in folder '" + this.folder + "' to '" + this.virtualName + "' in relPath '" + this.currentRelFolder + "'");
                result = new NativeFileSystemElement(this.folder, this.currentRelFolder, name, this.virtualName);
            } else {
                result = new NativeFileSystemElement(this.folder, this.currentRelFolder, name);
            }
        }
        return result;
    }

    private class FolderEnum
    implements Enumeration {
        private String[] folderInfo;
        private int index;

        public FolderEnum(File folder) {
            this.folderInfo = folder.list();
            this.index = 0;
        }

        public FolderEnum(String[] folderInfo) {
            this.folderInfo = folderInfo;
            this.index = 0;
        }

        public boolean hasMoreElements() {
            boolean result = false;
            if (this.folderInfo != null) {
                result = this.index < this.folderInfo.length;
            }
            return result;
        }

        public Object nextElement() {
            String result = this.folderInfo[this.index];
            ++this.index;
            return result;
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < this.folderInfo.length) {
                if (i > 0) {
                    result.append(',');
                }
                if (i == this.index) {
                    result.append("(*)");
                }
                result.append(this.folderInfo[i]);
                ++i;
            }
            return result.toString();
        }
    }
}

