/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.fjep.fatjar.builder.IConflictResolver;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.IFileSystemSource;
import net.sf.fjep.fatjar.builder.JARFileSystemSource;
import net.sf.fjep.fatjar.builder.JarBuilder;
import net.sf.fjep.fatjar.builder.NativeFileSystemSource;
import net.sf.fjep.utils.FileUtils;

public class OneJarBuilder {
    public static final String ONE_JAR_BOOT = "one-jar-boot-0.96.jar";
    private String tempBuildDir = null;
    private ArrayList fileSystemSources = null;
    private ArrayList conflictResolvers = null;
    static /* synthetic */ Class class$0;

    public OneJarBuilder(String tempBuildDir) {
        this.tempBuildDir = tempBuildDir;
        this.fileSystemSources = new ArrayList();
        this.conflictResolvers = new ArrayList();
    }

    public void addSource(IFileSystemSource fileSource) {
        if (!this.fileSystemSources.contains(fileSource)) {
            this.fileSystemSources.add(fileSource);
        }
    }

    public void addConflictResolver(IConflictResolver conflictResolver) {
        if (!this.conflictResolvers.contains(conflictResolver)) {
            this.conflictResolvers.add(conflictResolver);
        }
    }

    public void build(String oneJarFilename) {
        this.clean();
        this.collect();
        this.pack(oneJarFilename);
        this.clean();
    }

    private void collect() {
        File fLibFolder = new File(this.tempBuildDir, "lib");
        fLibFolder.mkdirs();
        Iterator iterator = this.fileSystemSources.iterator();
        while (iterator.hasNext()) {
            IFileSystemSource fileSystemSource = (IFileSystemSource)iterator.next();
            if (!(fileSystemSource instanceof JARFileSystemSource)) continue;
            JARFileSystemSource jarSource = (JARFileSystemSource)fileSystemSource;
            String sourceFilename = jarSource.getJarFilename();
            File fSource = new File(sourceFilename);
            File fDest = new File(fLibFolder, fSource.getName());
            FileUtils.copyFile(fSource, fDest);
        }
        File fMainFolder = new File(this.tempBuildDir, "mainjartmp");
        Iterator iterator2 = this.fileSystemSources.iterator();
        while (iterator2.hasNext()) {
            IFileSystemSource fileSystemSource = (IFileSystemSource)iterator2.next();
            if (fileSystemSource instanceof JARFileSystemSource) continue;
            while (fileSystemSource.hasMoreElements()) {
                IFileSystemElement fileSystemElement = fileSystemSource.nextElement();
                String elementFolder = fileSystemElement.getFolder();
                File folder = new File(fMainFolder, elementFolder);
                FileUtils.mkDirs(folder);
                if (fileSystemElement.isFolder()) continue;
                String elementName = fileSystemElement.getName();
                File outputFile = new File(folder, elementName);
                if (outputFile.exists()) {
                    this.resolveConflicts(outputFile, fileSystemElement);
                    continue;
                }
                InputStream fileStream = fileSystemElement.getStream();
                FileUtils.writeToFile(outputFile, fileStream);
            }
        }
        String mainJarName = String.valueOf(this.tempBuildDir) + File.separatorChar + "main" + File.separatorChar + "main.jar";
        JarBuilder jb = new JarBuilder(mainJarName);
        jb.add(new File(fMainFolder, "META-INF/MANIFEST.MF"), "META-INF/MANIFEST.MF");
        NativeFileSystemSource mainSource = new NativeFileSystemSource(fMainFolder, "");
        while (mainSource.hasMoreElements()) {
            IFileSystemElement fse = mainSource.nextElement();
            if (fse.getFullName().replace('\\', '/').equals("META-INF/MANIFEST.MF")) continue;
            jb.add(fse);
        }
        jb.close();
        FileUtils.recursiveRm(fMainFolder);
        this.copyOneJARBootFiles();
        File fMetaInf = new File(this.tempBuildDir, "META-INF");
        fMetaInf.mkdirs();
        FileUtils.writeToFile(new File(fMetaInf, "MANIFEST.MF"), "Manifest-Version: 1.0\r\nCreated-By: Fat Jar/One-JAR Eclipse Plug-In\r\nMain-Class: com.simontuffs.onejar.Boot\r\n\r\n");
    }

    private void copyOneJARBootFiles() {
        JarInputStream jis = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sf.fjep.fatjar.builder.OneJarBuilder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            jis = new JarInputStream(clazz.getResourceAsStream(ONE_JAR_BOOT));
            JarEntry entry = (JarEntry)jis.getNextEntry();
            while (entry != null) {
                File dest = new File(this.tempBuildDir, entry.getName());
                if (dest.getName().endsWith(".class") || entry.getName().startsWith("doc")) {
                    dest.getParentFile().mkdirs();
                    if (!entry.isDirectory()) {
                        FileUtils.writeToFile(dest, jis, false);
                    }
                }
                entry = (JarEntry)jis.getNextEntry();
            }
            jis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void resolveConflicts(File conflictOutputFile, IFileSystemElement fileSystemElement) {
        boolean ok = false;
        Iterator iterator = this.conflictResolvers.iterator();
        while (iterator.hasNext()) {
            IConflictResolver conflictResolver = (IConflictResolver)iterator.next();
            ok = conflictResolver.handleConflict(conflictOutputFile, fileSystemElement);
            if (ok) break;
        }
        if (!ok) {
            System.out.println("not resolving conflict in file " + fileSystemElement.getFolder() + File.separator + fileSystemElement.getName());
        }
    }

    private void clean() {
        FileUtils.recursiveRm(new File(this.tempBuildDir));
    }

    private void pack(String jarName) {
        JarBuilder newJar = new JarBuilder(jarName);
        NativeFileSystemSource source = new NativeFileSystemSource(new File(this.tempBuildDir), "");
        while (source.hasMoreElements()) {
            IFileSystemElement element = source.nextElement();
            newJar.add(element);
        }
        newJar.close();
    }
}

