/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.popup.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import net.sf.fjep.fatjar.FatjarPlugin;
import net.sf.fjep.fatjar.builder.IFileSystemElement;
import net.sf.fjep.fatjar.builder.IFileSystemSource;
import net.sf.fjep.fatjar.extensionpoints.IJarUtilFactory;
import net.sf.fjep.fatjar.popup.actions.FJTree;
import net.sf.fjep.fatjar.popup.actions.ManifestData;
import net.sf.fjep.fatjar.wizard.FJExportWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BuildFatJar
implements IObjectActionDelegate {
    private static final int PROGRESS_CLEAN = 50;
    private static final int PROGRESS_COLLECT = 1000;
    private static final int PROGRESS_PACK = 300;
    private static final char PATH_SEPARATOR = '.';
    public static String absPropertiesFilename = null;
    IStructuredSelection lastSelection = null;
    static /* synthetic */ Class class$0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.lastSelection != null && !this.lastSelection.isEmpty()) {
            Object sel = this.lastSelection.getFirstElement();
            if (sel instanceof IJavaProject) {
                absPropertiesFilename = null;
                IJavaProject jproject = (IJavaProject)sel;
                if (action.getId().equals("net.sf.fjep.fatjar.buildFatJar")) {
                    this.runBuildFatJar(jproject);
                } else {
                    System.err.println("unknown action-id for BuildFatJar: " + action.getId());
                }
            } else if (sel instanceof IFile) {
                IFile settings = (IFile)sel;
                String projectName = settings.getProject().getName();
                IJavaProject jproject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
                absPropertiesFilename = settings.getLocation().toOSString();
                if (action.getId().equals("net.sf.fjep.fatjar.buildFatJarFromSettings")) {
                    this.runBuildFatJar(jproject);
                } else if (action.getId().equals("net.sf.fjep.fatjar.quickBuildFatJarFromSettings")) {
                    this.runQuickBuildFatJarFromSettings(jproject);
                } else {
                    System.err.println("unknown action-id for BuildFatJar: " + action.getId());
                }
            }
        }
    }

    private void runQuickBuildFatJarFromSettings(IJavaProject jproject) {
        try {
            this.doQuickBuildFatJar(jproject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Shell shell = new Shell();
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In ERROR", (String)e.getMessage());
        }
    }

    private void runBuildFatJar(IJavaProject jproject) {
        try {
            this.doBuildFatJar(jproject);
        }
        catch (Exception e) {
            e.printStackTrace();
            Shell shell = new Shell();
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In ERROR", (String)e.getMessage());
        }
    }

    public void runBuildConfiguredFatJar(IJavaProject jproject, Properties props, Set excludes, ArrayList includes) {
        Shell shell = new Shell();
        ProgressMonitorDialog progressmonitordialog = new ProgressMonitorDialog(shell);
        progressmonitordialog.open();
        IProgressMonitor iprogressmonitor = progressmonitordialog.getProgressMonitor();
        iprogressmonitor.beginTask("Build Fat jar", 1400);
        boolean onejar = new Boolean(props.getProperty("onejar.checkbox"));
        String expand = props.getProperty("onejar.expand");
        String jarfile = null;
        try {
            this.saveConfig(jproject, props);
            this.doCleanFatJar(jproject, iprogressmonitor);
            this.doCollectFatJar(jproject, iprogressmonitor, excludes, includes, onejar, expand);
            jarfile = this.doPackFatJar(jproject, iprogressmonitor);
            this.doCleanFatJar(jproject, iprogressmonitor);
            try {
                jproject.getProject().refreshLocal(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In ERROR", (String)e.getMessage());
        }
        progressmonitordialog.close();
        if (jarfile != null) {
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In", (String)("built " + jarfile));
        }
    }

    private boolean doBuildFatJar(IJavaProject jproject) {
        boolean ok = false;
        FJExportWizard wizard = new FJExportWizard(jproject);
        Shell shell = new Shell();
        ok = wizard.execute(shell);
        if (ok) {
            try {
                jproject.getProject().refreshLocal(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return ok;
    }

    public void doQuickBuildFatJar(IJavaProject jproject) {
        Properties props = BuildFatJar.getFatJarProperties(jproject);
        Set excludes = this.getExcludes(jproject, props.getProperty("excludes"));
        ArrayList includes = this.getIncludes(jproject, props.getProperty("includes"));
        Shell shell = new Shell();
        ProgressMonitorDialog progressmonitordialog = new ProgressMonitorDialog(shell);
        progressmonitordialog.open();
        IProgressMonitor iprogressmonitor = progressmonitordialog.getProgressMonitor();
        iprogressmonitor.beginTask("Quick Build Fat jar", 1400);
        boolean onejar = new Boolean(props.getProperty("onejar.checkbox"));
        String expand = props.getProperty("onejar.expand");
        String jarfile = null;
        try {
            this.doCleanFatJar(jproject, iprogressmonitor);
            this.doCollectFatJar(jproject, iprogressmonitor, excludes, includes, onejar, expand);
            jarfile = this.doPackFatJar(jproject, iprogressmonitor);
            this.doCleanFatJar(jproject, iprogressmonitor);
            try {
                jproject.getProject().refreshLocal(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In ERROR", (String)e.getMessage());
        }
        progressmonitordialog.close();
        if (jarfile != null) {
            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In", (String)("built " + jarfile));
        }
    }

    private void testExtensionPoints(String jarfile) {
        try {
            System.out.println("dumping contents in jar using extension net.sf.fjep.fatjar.fatjarJarUtil");
            System.out.println("--- " + jarfile + " ---");
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint exp = reg.getExtensionPoint("net.sf.fjep.fatjar.jarutil");
            IExtension[] extensions = exp.getExtensions();
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            IJarUtilFactory ju = (IJarUtilFactory)elements[0].createExecutableExtension("class");
            IFileSystemSource fss = ju.createJARFileSystemSource(jarfile, "");
            while (fss.hasMoreElements()) {
                IFileSystemElement fse = fss.nextElement();
                System.out.println(fse.getFullName());
            }
            System.out.println("--- finished ---");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getIncludes(IJavaProject jproject, String includeString) {
        ArrayList<String> result = new ArrayList<String>();
        IWorkspaceRoot root = jproject.getProject().getWorkspace().getRoot();
        if (includeString != null && !includeString.trim().equals("")) {
            String[] includes = includeString.split("[;]");
            int i = 0;
            while (i < includes.length) {
                String include = includes[i];
                if (include.startsWith("<inc|")) {
                    include = include.replaceFirst("[<]inc[|](.*)[>]", "/$1|").replaceAll("[~]", "").replace('/', File.separatorChar);
                }
                String absPath = BuildFatJar.absProjectPath(root, include);
                result.add(absPath);
                ++i;
            }
        }
        return result;
    }

    private Set getExcludes(IJavaProject jproject, String excludeString) {
        HashSet<String> result = new HashSet<String>();
        IWorkspaceRoot root = jproject.getProject().getWorkspace().getRoot();
        if (excludeString != null && !excludeString.trim().equals("")) {
            String[] excludes = excludeString.split("[;]");
            int i = 0;
            while (i < excludes.length) {
                String exclude;
                String absPath = exclude = excludes[i];
                if (exclude.startsWith("<po|")) {
                    String javaProjectName = exclude.replaceFirst("[<]po[|](.*)[>](.*)", "$1");
                    exclude = exclude.replaceFirst("[<]po[|](.*)[>](.*)", "$2").replaceAll("[~]", "").replace('/', File.separatorChar);
                    try {
                        IJavaProject javaProject = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(javaProjectName);
                        if (javaProject != null) {
                            String projectOutput = javaProject.getOutputLocation().toOSString();
                            exclude = String.valueOf(projectOutput) + File.separatorChar + exclude;
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                    absPath = BuildFatJar.absProjectPath(root, exclude);
                } else if (exclude.startsWith("<cl|")) {
                    absPath = exclude = exclude.replaceFirst("[<]cl[|](.*)[>]", "$1/").replaceAll("[~]", "").replace('/', File.separatorChar);
                } else if (exclude.startsWith("<jar|")) {
                    absPath = exclude = exclude.replaceFirst("[<]jar[|](.*)[>]", "$1");
                }
                if (absPath.endsWith(File.separator)) {
                    absPath = absPath.substring(0, absPath.length() - 1);
                }
                result.add(absPath);
                ++i;
            }
        }
        return result;
    }

    private void saveConfig(IJavaProject jproject, Properties props) {
        boolean ok = true;
        try {
            String propertiesFile = BuildFatJar.getPropertiesFilename(jproject);
            File f = new File(propertiesFile);
            if (f.exists() && f.canRead()) {
                String projectDir;
                try {
                    FileInputStream in = new FileInputStream(f);
                    Properties oldProps = new Properties();
                    oldProps.load(in);
                    ((InputStream)in).close();
                    if (oldProps.equals(props)) {
                        ok = false;
                    }
                }
                catch (Exception exception) {}
                if (ok && propertiesFile.startsWith(projectDir = BuildFatJar.getProjectDir(jproject))) {
                    String relFile = propertiesFile.substring(projectDir.length() + 1);
                    IFile editFile = jproject.getProject().getFile(relFile);
                    if (editFile != null) {
                        IStatus status = FatjarPlugin.askFileWriteAccess(editFile);
                        boolean bl = ok = status == null || status.isOK();
                        if (!ok) {
                            Shell shell = new Shell();
                            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In Warning", (String)("could not save current settings: " + status.toString()));
                        }
                    }
                }
            }
            if (ok) {
                FileOutputStream out = new FileOutputStream(f);
                props.store(out, "Fat Jar Configuration File");
                out.flush();
                ((OutputStream)out).close();
                try {
                    jproject.getProject().refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Properties getFatJarProperties(IJavaProject jproject) {
        Properties props = new Properties();
        try {
            String propertiesFile = BuildFatJar.getPropertiesFilename(jproject);
            File f = new File(propertiesFile);
            if (!f.exists()) {
                props.setProperty("jarname.isextern", "false");
                props.setProperty("jarname", BuildFatJar.getJarName(jproject));
                props.setProperty("manifest.file", "<createnew>");
                props.setProperty("manifest.mainclass", "");
                props.setProperty("manifest.classpath", "");
                props.setProperty("manifest.mergeall", BuildFatJar.getManifestMergeAll(jproject));
                props.setProperty("manifest.removesigners", BuildFatJar.getManifestRemoveSigners(jproject));
                props.setProperty("includes", "notyetsupported");
                props.setProperty("excludes", "notyetsupported");
            } else {
                FileInputStream in = new FileInputStream(f);
                props.load(in);
                ((InputStream)in).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    private String doCollectFatJar(IJavaProject jproject, IProgressMonitor iprogressmonitor, Set excludes, ArrayList includes, boolean onejar, String onejarexpand) throws IOException {
        String manifestFile;
        new Shell();
        String jartype = onejar ? "One-JAR" : "Fat Jar";
        iprogressmonitor.subTask("Collect " + jartype + " - reading classpath");
        Vector childProjects = new Vector();
        Vector jarFiles = new Vector();
        Vector classesDirs = new Vector();
        Vector libDirs = new Vector();
        Vector<String> libNames = new Vector<String>();
        this.getChildProjects(jproject, childProjects, false);
        int i = childProjects.size() - 1;
        while (i >= 0) {
            IJavaProject jChildProject = (IJavaProject)childProjects.get(i);
            if (onejar) {
                String childProjectName = jChildProject.getElementName();
                int current = libDirs.size();
                this.getClassPathJars(jChildProject, jarFiles, libDirs, false);
                int j = 1;
                while (j <= libDirs.size() - current) {
                    String libDir = (String)libDirs.get(j - 1);
                    int start = libDir.indexOf(childProjectName);
                    if (start >= 0) {
                        String libName = libDir.substring(start += childProjectName.length() + 1).replace(File.separatorChar, '.');
                        libNames.add(libName);
                    } else {
                        libNames.add(String.valueOf(childProjectName) + '.' + Integer.toString(i));
                    }
                    ++j;
                }
                this.getClassesDir(jChildProject, libDirs);
                libNames.add(childProjectName);
            } else {
                this.getClassPathJars(jChildProject, jarFiles, classesDirs, false);
                this.getClassesDir(jChildProject, classesDirs);
            }
            --i;
        }
        if (onejar) {
            int current = libDirs.size();
            String projectName = jproject.getElementName();
            this.getClassPathJars(jproject, jarFiles, libDirs, false);
            int i2 = 1;
            while (i2 <= libDirs.size() - current) {
                String libDir = (String)libDirs.get(i2 - 1);
                int start = libDir.indexOf(projectName);
                if (start >= 0) {
                    String libName = libDir.substring(start += projectName.length() + 1).replace(File.separatorChar, '.');
                    libNames.add(libName);
                } else {
                    libNames.add(String.valueOf(projectName) + '.' + Integer.toString(i2));
                }
                ++i2;
            }
        } else {
            this.getClassPathJars(jproject, jarFiles, classesDirs, false);
        }
        this.getClassesDir(jproject, classesDirs);
        String projectDir = BuildFatJar.getProjectDir(jproject);
        BuildFatJar.getProjectName(jproject);
        String tempdir = this.configGetTempBuildDir(jproject);
        boolean mergeManifests = this.configGetManifestMergeAll(jproject);
        boolean removeSigners = this.configGetManifestRemoveSigners(jproject);
        this.mkdir(tempdir);
        ManifestData manifestData = null;
        if (mergeManifests) {
            manifestData = new ManifestData();
        }
        iprogressmonitor.worked(50);
        int i3 = 0;
        while (i3 < jarFiles.size()) {
            String jarFile = (String)jarFiles.get(i3);
            String jarname = String.valueOf(File.separatorChar) + jarFile;
            jarname = jarname.substring(jarname.lastIndexOf(File.separatorChar) + 1);
            iprogressmonitor.subTask("Collect " + jartype + " - extracting " + jarname);
            if (!this.checkFileInList(jarFile, excludes) && !this.checkFileInList(jarname, excludes)) {
                this.extractJar(jarFile, tempdir, manifestData, onejar, removeSigners);
            }
            iprogressmonitor.worked(750 / jarFiles.size());
            ++i3;
        }
        i3 = 0;
        while (i3 < classesDirs.size()) {
            String classesDir = (String)classesDirs.get(i3);
            iprogressmonitor.subTask("Collect " + jartype + " - copying class files " + classesDir);
            if (!onejar) {
                this.copyFiles(classesDir, tempdir, excludes, jproject);
            } else {
                String mainClass = this.configGetMainClass(jproject);
                if (mainClass == null || mainClass.length() == 0) {
                    throw new IOException("Main-Class manifest entry cannot be missing in a One-JAR application");
                }
                String classPath = this.configGetClassPath(jproject);
                this.copyJar(classesDir, tempdir, excludes, mainClass, classPath, "main/main.jar", jproject);
                this.copyOneJARBootFiles(tempdir);
            }
            iprogressmonitor.worked(100 / classesDirs.size());
            ++i3;
        }
        i3 = 0;
        while (i3 < libDirs.size()) {
            String classesDir = (String)libDirs.get(i3);
            this.copyJar(classesDir, tempdir, excludes, null, null, "lib/" + libNames.get(i3) + ".jar", jproject);
            ++i3;
        }
        i3 = 0;
        while (i3 < includes.size()) {
            String include = (String)includes.get(i3);
            String[] basedir_relpath = include.split("[|]");
            String baseDir = basedir_relpath[0];
            String relPath = "";
            if (basedir_relpath.length > 1) {
                relPath = String.valueOf(File.separatorChar) + basedir_relpath[1];
            }
            iprogressmonitor.subTask("Collect " + jartype + " - including resource files " + relPath);
            String src = String.valueOf(baseDir) + relPath;
            String dest = String.valueOf(tempdir) + relPath;
            File fsrc = new File(src);
            File fdest = new File(dest);
            fdest.getParentFile().mkdirs();
            this.recursiveCopyFiles(fsrc, fdest);
            ++i3;
        }
        iprogressmonitor.worked(50);
        iprogressmonitor.subTask("Collect " + jartype + " creating manifest");
        this.mkdir(String.valueOf(tempdir) + File.separator + "META-INF");
        if (manifestData == null) {
            manifestData = new ManifestData();
        }
        if ((manifestFile = this.configGetManifestFile(jproject)).equals("<createnew>")) {
            manifestData.clearMainSection();
            manifestData.addMainSectionLine("Manifest-Version: 1.0");
            if (onejar) {
                String classPath;
                manifestData.addMainSectionLine("Created-By: Fat Jar/One-JAR Eclipse Plug-In");
                manifestData.addMainSectionLine("Main-Class: com.simontuffs.onejar.Boot");
                if (onejarexpand.length() > 0) {
                    manifestData.addMainSectionLine("One-Jar-Expand: " + onejarexpand);
                }
                if ((classPath = this.configGetClassPath(jproject)) != null && !classPath.equals("")) {
                    manifestData.addMainSectionLine("Class-Path: " + classPath);
                }
            } else {
                String classPath;
                manifestData.addMainSectionLine("Created-By: Fat Jar Eclipse Plug-In");
                String mainClass = this.configGetMainClass(jproject);
                if (mainClass != null && !mainClass.equals("")) {
                    manifestData.addMainSectionLine("Main-Class: " + mainClass);
                }
                if ((classPath = this.configGetClassPath(jproject)) != null && !classPath.equals("")) {
                    manifestData.addMainSectionLine("Class-Path: " + classPath);
                }
            }
        } else {
            manifestData.addFile(String.valueOf(projectDir) + File.separator + manifestFile);
        }
        String manifestText = manifestData.toString();
        this.writeTextToFile(new File(String.valueOf(tempdir) + File.separator + "META-INF" + File.separator + "MANIFEST.MF"), manifestText);
        iprogressmonitor.worked(50);
        return tempdir;
    }

    private boolean checkFileInList(String filename, Set files) {
        boolean result = false;
        if (files != null) {
            if (files.contains(filename)) {
                result = true;
            } else {
                File f = new File(filename);
                try {
                    String abs = f.getCanonicalPath();
                    if (files.contains(abs)) {
                        result = true;
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public FJTree buildTree(IJavaProject jproject) {
        String projectName = jproject.getElementName();
        FJTree rootNode = new FJTree(null, 1, "Fat Jar Tree for Project " + projectName, jproject, 1);
        Vector childProjects = new Vector();
        Vector jarFiles = new Vector();
        Vector classesDirs = new Vector();
        this.getClassPathJars(jproject, jarFiles, classesDirs, false);
        this.getClassesDir(jproject, classesDirs);
        String classesDir = (String)classesDirs.lastElement();
        rootNode.addChild(20, "Project '" + jproject.getElementName() + "' output", new File(classesDir), 1);
        int i = 0;
        while (i < classesDirs.size() - 1) {
            classesDir = (String)classesDirs.get(i);
            rootNode.addChild(36, "Classes '" + classesDir + "'", new File(classesDir), 1);
            ++i;
        }
        this.getChildProjects(jproject, childProjects, false);
        i = 0;
        while (i < childProjects.size()) {
            IJavaProject jChildProject = (IJavaProject)childProjects.get(i);
            String childProjectName = jChildProject.getElementName();
            classesDirs.clear();
            this.getClassPathJars(jChildProject, jarFiles, classesDirs, false);
            this.getClassesDir(jChildProject, classesDirs);
            classesDir = (String)classesDirs.lastElement();
            rootNode.addChild(20, "Project '" + childProjectName + "' output", new File(classesDir), 1);
            int j = 0;
            while (j < classesDirs.size() - 1) {
                classesDir = (String)classesDirs.get(j);
                rootNode.addChild(36, "Classes '" + classesDir + "'", new File(classesDir), 1);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < jarFiles.size()) {
            String jarFile = (String)jarFiles.get(i);
            String jarname = String.valueOf(File.separatorChar) + jarFile;
            jarname = jarname.substring(jarname.lastIndexOf(File.separatorChar) + 1);
            rootNode.addChild(10, jarname, new File(jarFile), 1);
            ++i;
        }
        return rootNode;
    }

    private void getChildProjects(IJavaProject jproject, Vector projects, boolean exportedOnly) {
        IClasspathEntry[] cpes = jproject.readRawClasspath();
        if (cpes != null) {
            int i = 0;
            while (i < cpes.length) {
                IClasspathEntry cpe = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cpes[i]);
                if (cpe == null) {
                    System.err.println("Error: cpes[" + i + "]=" + cpes[i] + " does not resolve");
                } else {
                    int kind = cpe.getEntryKind();
                    String name = this.relPath(cpe.getPath());
                    if (kind == 5) {
                        try {
                            IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jproject);
                            if (container.getKind() == 1 || container.getKind() == 2) {
                                IClasspathEntry[] cpes2 = container.getClasspathEntries();
                                int j = 0;
                                while (j < cpes2.length) {
                                    IClasspathEntry cpe2 = cpes2[j];
                                    int kind2 = cpe2.getEntryKind();
                                    String name2 = this.relPath(cpe2.getPath());
                                    if (name2 == null) {
                                        System.err.println("invalid classpath entry: " + cpe2.toString());
                                    } else if (!(kind2 != 2 || exportedOnly && !cpe2.isExported() || projects.contains(name2))) {
                                        IJavaProject jChildProject2 = jproject.getJavaModel().getJavaProject(name2);
                                        projects.add(jChildProject2);
                                        this.getChildProjects(jChildProject2, projects, false);
                                    }
                                    ++j;
                                }
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                    } else if (kind == 2) {
                        if (name == null) {
                            System.err.println("invalid classpath entry: " + cpe.toString());
                        } else if (!(exportedOnly && !cpe.isExported() || projects.contains(name))) {
                            IJavaProject jChildProject = jproject.getJavaModel().getJavaProject(name);
                            projects.add(jChildProject);
                            this.getChildProjects(jChildProject, projects, false);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private String configGetTempBuildDir(IJavaProject jproject) {
        String projectDir = BuildFatJar.getProjectDir(jproject);
        String absProject = String.valueOf(projectDir) + File.separatorChar;
        String buildDir = "TempFatjarBuildDir_erase_me";
        String result = String.valueOf(absProject) + buildDir;
        return result;
    }

    private boolean configGetJarNameIsExtern(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("jarname.isextern", "false");
        return result.equalsIgnoreCase("true");
    }

    private String configGetJarName(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("jarname", BuildFatJar.getJarName(jproject));
        if (!this.configGetJarNameIsExtern(jproject)) {
            result = String.valueOf(BuildFatJar.getProjectDir(jproject)) + File.separator + result;
        }
        return result;
    }

    private String configGetManifestFile(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("manifest.file", "<createnew>");
        return result;
    }

    private String configGetMainClass(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("manifest.mainclass", "");
        return result;
    }

    private String configGetClassPath(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("manifest.classpath", "");
        return result;
    }

    private boolean configGetManifestMergeAll(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("manifest.mergeall", "true");
        return result.equalsIgnoreCase("true");
    }

    private boolean configGetManifestRemoveSigners(IJavaProject jproject) {
        Properties props = this.getProperties(jproject);
        String result = props.getProperty("manifest.removesigners", "true");
        return result.equalsIgnoreCase("true");
    }

    private Properties getProperties(IJavaProject jproject) {
        Properties props = new Properties();
        try {
            String propertiesFile = BuildFatJar.getPropertiesFilename(jproject);
            File f = new File(propertiesFile);
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                props.load(in);
                ((InputStream)in).close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    private String doPackFatJar(IJavaProject jproject, IProgressMonitor iprogressmonitor) {
        String tempdir = this.configGetTempBuildDir(jproject);
        String jarName = this.configGetJarName(jproject);
        boolean ok = this.checkWritable(jproject, jarName);
        if (!ok) {
            jarName = "(no write access)";
        } else {
            iprogressmonitor.subTask("Pack Fat Jar - " + jarName);
            this.packJar(jarName, tempdir);
            iprogressmonitor.worked(300);
        }
        return jarName;
    }

    private boolean checkWritable(IJavaProject jproject, String filename) {
        boolean result = true;
        String projectDir = String.valueOf(BuildFatJar.getProjectDir(jproject)) + File.separator;
        if (filename.startsWith(projectDir)) {
            String relFilename = filename.substring(projectDir.length());
            IFile editFile = jproject.getProject().getFile(relFilename);
            IStatus status = FatjarPlugin.askFileWriteAccess(editFile);
            if (status != null && !status.isOK()) {
                result = false;
                Shell shell = new Shell();
                MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In ERROR", (String)("no write acces for output jar '" + relFilename + "': " + status.toString()));
            }
        }
        return result;
    }

    private String doCleanFatJar(IJavaProject jproject, IProgressMonitor iprogressMonitor) {
        String tempdir = this.configGetTempBuildDir(jproject);
        iprogressMonitor.subTask("Clean Fat Jar - remove " + tempdir);
        this.recursiveRm(new File(tempdir));
        iprogressMonitor.worked(50);
        return tempdir;
    }

    private static String getJarName(IJavaProject jproject) {
        IPreferenceStore store = FatjarPlugin.getDefault().getPreferenceStore();
        String result = store.getString("jarnamePreference");
        return result.replaceAll("[<]project[>]", BuildFatJar.getProjectName(jproject));
    }

    private static String getManifestMergeAll(IJavaProject jproject) {
        IPreferenceStore store = FatjarPlugin.getDefault().getPreferenceStore();
        boolean result = store.getBoolean("mergemanifestPreference");
        return result ? "true" : "false";
    }

    private static String getManifestRemoveSigners(IJavaProject jproject) {
        IPreferenceStore store = FatjarPlugin.getDefault().getPreferenceStore();
        boolean result = store.getBoolean("removesignersPreference");
        return result ? "true" : "false";
    }

    public static boolean getScmAutoCheckout() {
        IPreferenceStore store = FatjarPlugin.getDefault().getPreferenceStore();
        boolean result = store.getBoolean("scmautocheckoutPreference");
        return result;
    }

    private static String getRelPropertiesFilename(IJavaProject jproject) {
        Preferences prefs = FatjarPlugin.getDefault().getPluginPreferences();
        String result = prefs.getString("configfilePreference");
        return result.replaceAll("[<]project[>]", BuildFatJar.getProjectName(jproject));
    }

    private static String getPropertiesFilename(IJavaProject jproject) {
        String result = absPropertiesFilename;
        if (result == null) {
            result = String.valueOf(BuildFatJar.getProjectDir(jproject)) + File.separator + BuildFatJar.getRelPropertiesFilename(jproject);
        }
        return result;
    }

    private void recursiveJarFilesExclude(JarOutputStream jarro, File rootDir, String filename, Set excludes) {
        try {
            File fsrc = filename == null ? rootDir : new File(rootDir, filename);
            if (!this.checkFileInList(fsrc, excludes)) {
                if (fsrc.isDirectory()) {
                    if (filename == null) {
                        filename = "";
                    } else {
                        filename = String.valueOf(filename) + File.separator;
                        JarEntry entry = new JarEntry(filename.replace('\\', '/'));
                        jarro.putNextEntry(entry);
                        jarro.closeEntry();
                    }
                    String[] filenames = fsrc.list();
                    int i = 0;
                    while (i < filenames.length) {
                        this.recursiveJarFilesExclude(jarro, rootDir, String.valueOf(filename) + filenames[i], excludes);
                        ++i;
                    }
                } else {
                    this.addFileToJar(jarro, fsrc, filename);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void recursiveJarFiles(JarOutputStream jarro, File rootDir, String filename) {
        try {
            File fsrc = filename == null ? rootDir : new File(rootDir, filename);
            if (fsrc.isDirectory()) {
                if (filename == null) {
                    filename = "";
                } else {
                    filename = String.valueOf(filename) + File.separator;
                    JarEntry entry = new JarEntry(filename.replace('\\', '/'));
                    jarro.putNextEntry(entry);
                    jarro.closeEntry();
                }
                String[] filenames = fsrc.list();
                int i = 0;
                while (i < filenames.length) {
                    this.recursiveJarFiles(jarro, rootDir, String.valueOf(filename) + filenames[i]);
                    ++i;
                }
            } else {
                this.addFileToJar(jarro, fsrc, filename);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addFileToJar(JarOutputStream jarro, File file, String jarFilename) throws IOException, FileNotFoundException {
        String jarFilenameNorm = jarFilename.replace('\\', '/');
        if (!jarFilenameNorm.equals("META-INF/MANIFEST.MF")) {
            JarEntry entry = new JarEntry(jarFilenameNorm);
            entry.setSize(file.length());
            entry.setTime(file.lastModified());
            jarro.putNextEntry(entry);
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int cnt = in.read(buffer);
            while (cnt > 0) {
                jarro.write(buffer, 0, cnt);
                cnt = in.read(buffer);
            }
            jarro.closeEntry();
            in.close();
        }
    }

    private void addManifestFileToJar(JarOutputStream jarro, File file) throws IOException, FileNotFoundException {
        JarEntry entry = new JarEntry("META-INF/MANIFEST.MF");
        entry.setSize(file.length());
        entry.setTime(file.lastModified());
        jarro.putNextEntry(entry);
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[4096];
        int cnt = in.read(buffer);
        while (cnt > 0) {
            jarro.write(buffer, 0, cnt);
            cnt = in.read(buffer);
        }
        jarro.closeEntry();
        in.close();
    }

    private void packJar(String jarName, String tempdir) {
        FileOutputStream out = null;
        JarOutputStream jarro = null;
        try {
            out = new FileOutputStream(jarName);
            jarro = new JarOutputStream(out);
            String absManifestPath = String.valueOf(tempdir) + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
            File manifest = new File(absManifestPath);
            if (manifest.exists()) {
                this.addManifestFileToJar(jarro, manifest);
            }
            this.recursiveJarFiles(jarro, new File(tempdir), null);
            jarro.flush();
            jarro.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException("output file '" + jarName + "' could not be created: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("error writing output file '" + jarName + "': " + e.getMessage());
        }
    }

    private static String getProjectName(IJavaProject jproject) {
        IProject project = jproject.getProject();
        String projectName = project.getName();
        return projectName;
    }

    private void extractJar(String jarfilename, String destdir, ManifestData md, boolean onejar, boolean removeSigners) {
        try {
            if (!onejar) {
                JarFile jarFile = new JarFile(jarfilename);
                Enumeration<JarEntry> enumer = jarFile.entries();
                while (enumer.hasMoreElements()) {
                    JarEntry jarEntry = enumer.nextElement();
                    String entryName = jarEntry.getName();
                    if (jarEntry.isDirectory()) {
                        this.mkdir(String.valueOf(destdir) + File.separator + entryName);
                        continue;
                    }
                    if (removeSigners && entryName.endsWith(".SF") && entryName.startsWith("META-INF")) continue;
                    this.mkParentDirs(String.valueOf(destdir) + File.separator + entryName);
                    InputStream in = jarFile.getInputStream(jarEntry);
                    this.writeToFile(in, String.valueOf(destdir) + File.separator + entryName);
                    in.close();
                    if (md == null || !entryName.equalsIgnoreCase("META-INF/MANIFEST.MF")) continue;
                    md.addFile(String.valueOf(destdir) + File.separator + entryName);
                }
                jarFile.close();
            } else {
                FileInputStream input = new FileInputStream(new File(jarfilename));
                String output = String.valueOf(destdir) + "/lib/" + new File(jarfilename).getName();
                this.mkParentDirs(output);
                this.writeToFile((InputStream)input, output);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mkParentDirs(String filename) {
        String normFilename = filename.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        int pos = normFilename.lastIndexOf(File.separatorChar);
        String dir = normFilename.substring(0, pos);
        File f = new File(dir);
        f.mkdirs();
    }

    private void writeTextToFile(File f, String text) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            ((OutputStream)out).write(text.getBytes());
            out.flush();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToFile(InputStream in, String filename) {
        this.writeToFile(in, new File(filename));
    }

    private void writeToFile(InputStream in, File fdest) {
        try {
            FileOutputStream out = new FileOutputStream(fdest);
            byte[] buffer = new byte[4096];
            int cnt = in.read(buffer);
            while (cnt > 0) {
                out.write(buffer, 0, cnt);
                cnt = in.read(buffer);
            }
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyJar(String classesDir, String tempdir, Set excludes, String mainclass, String classpath, String jar, IJavaProject jproject) throws IOException {
        String abs;
        if (this.checkFileInList(classesDir, (Set)excludes)) {
            return;
        }
        if (this.checkSubDir(new File(classesDir), new File(tempdir))) {
            try {
                abs = new File(tempdir).getCanonicalPath();
                if (excludes == null) {
                    excludes = new HashSet<String>();
                }
                excludes.add(abs);
            }
            catch (IOException iOException) {}
        }
        if (this.checkSubDir(new File(classesDir), new File(this.configGetJarName(jproject)))) {
            try {
                abs = new File(this.configGetJarName(jproject)).getCanonicalPath();
                if (excludes == null) {
                    excludes = new HashSet();
                }
                excludes.add(abs);
            }
            catch (IOException iOException) {}
        }
        File maindir = new File(tempdir, jar);
        maindir.getParentFile().mkdirs();
        JarOutputStream output = new JarOutputStream(new FileOutputStream(maindir));
        JarEntry man = new JarEntry("META-INF/MANIFEST.MF");
        output.putNextEntry(man);
        ManifestData manifestData = new ManifestData();
        manifestData.addMainSectionLine("Created-By: Fat Jar/One-JAR Eclipse Plug-In");
        manifestData.addMainSectionLine("Main-Class: " + mainclass);
        if (classpath != null && !classpath.equals("")) {
            manifestData.addMainSectionLine("Class-Path: " + classpath);
        }
        output.write(manifestData.toString().getBytes());
        if (excludes != null || excludes.size() > 0) {
            this.recursiveJarFilesExclude(output, new File(classesDir), null, excludes);
        } else {
            this.recursiveJarFiles(output, new File(classesDir), null);
        }
        output.close();
    }

    private void copyOneJARBootFiles(String tempdir) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.fjep.fatjar.FatjarPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JarInputStream jis = new JarInputStream(clazz.getResourceAsStream("one-jar-boot-0.96.jar"));
        JarEntry entry = (JarEntry)jis.getNextEntry();
        while (entry != null) {
            File dest = new File(tempdir, entry.getName());
            if (dest.getName().endsWith(".class") || entry.getName().startsWith("doc")) {
                dest.getParentFile().mkdirs();
                this.writeToFile((InputStream)jis, dest);
            }
            entry = (JarEntry)jis.getNextEntry();
        }
    }

    private void copyFiles(String srcDir, String destDir, Set excludes, IJavaProject jproject) {
        if (!this.checkFileInList(srcDir, (Set)excludes)) {
            String abs;
            File fsrc = new File(srcDir);
            File fdest = new File(destDir);
            if (this.checkSubDir(fsrc, fdest)) {
                try {
                    abs = fdest.getCanonicalPath();
                    if (excludes == null) {
                        excludes = new HashSet<String>();
                    }
                    excludes.add(abs);
                }
                catch (IOException iOException) {}
            }
            if (this.checkSubDir(fsrc, new File(this.configGetJarName(jproject)))) {
                try {
                    abs = new File(this.configGetJarName(jproject)).getCanonicalPath();
                    if (excludes == null) {
                        excludes = new HashSet();
                    }
                    excludes.add(abs);
                }
                catch (IOException iOException) {}
            }
            if (excludes != null || excludes.size() > 0) {
                this.recursiveCopyFilesExclude(fsrc, fdest, excludes);
            } else {
                this.recursiveCopyFiles(fsrc, fdest);
            }
        }
    }

    private boolean checkSubDir(File fparent, File fchild) {
        boolean result = false;
        try {
            result = fchild.getCanonicalPath().startsWith(fparent.getCanonicalPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void recursiveCopyFiles(File fsrc, File fdest) {
        if (fsrc.isDirectory()) {
            fdest.mkdirs();
            String[] filenames = fsrc.list();
            int i = 0;
            while (i < filenames.length) {
                File fchildsrc = new File(fsrc, filenames[i]);
                File fchilddest = new File(fdest, filenames[i]);
                this.recursiveCopyFiles(fchildsrc, fchilddest);
                ++i;
            }
        } else {
            this.copyFile(fsrc, fdest);
        }
    }

    private void recursiveCopyFilesExclude(File fsrc, File fdest, Set excludes) {
        if (!this.checkFileInList(fsrc, excludes)) {
            if (fsrc.isDirectory()) {
                fdest.mkdirs();
                String[] filenames = fsrc.list();
                int i = 0;
                while (i < filenames.length) {
                    File fchildsrc = new File(fsrc, filenames[i]);
                    File fchilddest = new File(fdest, filenames[i]);
                    this.recursiveCopyFilesExclude(fchildsrc, fchilddest, excludes);
                    ++i;
                }
            } else {
                this.copyFile(fsrc, fdest);
            }
        }
    }

    private boolean checkFileInList(File file, Set files) {
        boolean result = false;
        String abs = null;
        try {
            abs = file.getCanonicalPath();
            if (files.contains(abs)) {
                result = true;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    private void copyFile(String src, String dest) {
        this.copyFile(new File(src), new File(dest));
    }

    private void copyFile(File fsrc, File fdest) {
        try {
            FileInputStream in = new FileInputStream(fsrc);
            this.writeToFile((InputStream)in, fdest);
            in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void mkdir(String dir) {
        File f = new File(dir);
        f.mkdirs();
    }

    private void recursiveRm(File f) {
        if (f.isDirectory()) {
            String[] filenames = f.list();
            int i = 0;
            while (i < filenames.length) {
                this.recursiveRm(new File(f, filenames[i]));
                ++i;
            }
            f.delete();
        } else {
            f.delete();
        }
    }

    private void getClassPathJars(IJavaProject jproject, Vector jarfiles, Vector classesDirs, boolean exportedOnly) {
        IProject project = jproject.getProject();
        IWorkspace workspace = project.getWorkspace();
        IWorkspaceRoot workspaceRoot = workspace.getRoot();
        BuildFatJar.absPath(workspaceRoot.getLocation());
        IClasspathEntry[] cpes = jproject.readRawClasspath();
        if (cpes != null) {
            int i = 0;
            while (i < cpes.length) {
                block22: {
                    IClasspathEntry cpe = JavaCore.getResolvedClasspathEntry((IClasspathEntry)cpes[i]);
                    if (cpe != null && (!exportedOnly || cpe.isExported())) {
                        int kind = cpe.getEntryKind();
                        String dir = this.relPath(cpe.getPath());
                        if (kind == 5) {
                            try {
                                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)cpe.getPath(), (IJavaProject)jproject);
                                if (container.getKind() != 1 && container.getKind() != 2) break block22;
                                IClasspathEntry[] cpes2 = container.getClasspathEntries();
                                int j = 0;
                                while (j < cpes2.length) {
                                    IClasspathEntry cpe2 = cpes2[j];
                                    cpe2.getEntryKind();
                                    String dir2 = this.relPath(cpe2.getPath());
                                    String jar2 = this.absOrProjectPath(workspaceRoot, dir2);
                                    if (jar2 == null) {
                                        System.err.println("invalid classpath entry: " + cpe2.toString());
                                    } else {
                                        File f2 = new File(jar2);
                                        if (f2.isDirectory()) {
                                            if (!classesDirs.contains(jar2)) {
                                                classesDirs.add(jar2);
                                            }
                                        } else if (!jarfiles.contains(jar2)) {
                                            jarfiles.add(jar2);
                                        }
                                    }
                                    ++j;
                                }
                            }
                            catch (JavaModelException javaModelException) {}
                        } else if (kind == 1) {
                            String jar = this.absOrProjectPath(workspaceRoot, dir);
                            if (jar == null) {
                                System.err.println("invalid classpath entry: " + cpe.toString());
                            } else if (!jar.replace(File.separatorChar, '/').toLowerCase().endsWith("/jre/lib/rt.jar")) {
                                File f = new File(jar);
                                if (f.isDirectory()) {
                                    if (!classesDirs.contains(jar)) {
                                        classesDirs.add(jar);
                                    }
                                } else if (!jarfiles.contains(jar)) {
                                    jarfiles.add(jar);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    public String absOrProjectPath(IWorkspaceRoot workspaceRoot, String absOrProjectpath) {
        String result = absOrProjectpath;
        try {
            File f = new File(absOrProjectpath);
            if (!f.exists()) {
                result = BuildFatJar.absProjectPath(workspaceRoot, absOrProjectpath);
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public static String absProjectPath(IWorkspaceRoot workspaceRoot, String projectpath) {
        String jarProjectPath;
        String jarProjectName;
        int n = projectpath.indexOf(File.separatorChar, 1);
        if (n != -1) {
            jarProjectName = projectpath.substring(1, n);
            jarProjectPath = projectpath.substring(n);
        } else {
            jarProjectName = projectpath.substring(1);
            jarProjectPath = "";
        }
        IProject jarProject = workspaceRoot.getProject(jarProjectName);
        String result = null;
        try {
            result = jarProject.getFile(jarProjectPath).getLocation().toOSString();
            return result;
        }
        catch (Exception exception) {
            String jarProjectRoot = BuildFatJar.absPath(jarProject.getLocation());
            if (jarProjectRoot != null) {
                result = String.valueOf(jarProjectRoot) + jarProjectPath;
            }
            return result;
        }
    }

    private void getClassesDir(IJavaProject jproject, Vector classesDirs) {
        IProject project = jproject.getProject();
        IWorkspaceRoot workspaceRoot = project.getWorkspace().getRoot();
        String outputDir = null;
        try {
            outputDir = BuildFatJar.absProjectPath(workspaceRoot, this.relPath(jproject.getOutputLocation()));
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (!classesDirs.contains(outputDir)) {
            classesDirs.add(outputDir);
        }
    }

    public static String getProjectDir(IJavaProject jproject) {
        IProject project = jproject.getProject();
        String projectDir = BuildFatJar.absPath(project.getLocation());
        return projectDir;
    }

    private static String absPath(IPath path) {
        String result = null;
        if (path != null) {
            File f = path.toFile();
            try {
                result = f.getCanonicalPath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String relPath(IPath path) {
        String result = null;
        File f = path.toFile();
        result = f.getPath();
        return result;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.lastSelection = null;
        if (selection != null && !selection.isEmpty()) {
            this.lastSelection = (IStructuredSelection)selection;
        }
    }
}

