/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.popup.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FJTree {
    private FJTree parent;
    private int nodeType;
    private String displayName;
    private Object buildInfo;
    private ArrayList children;
    private int checkState;
    private boolean childrenRead;
    public static final int NT_ROOT = 1;
    public static final int NT_FILE = 2;
    public static final int NT_DIR = 4;
    public static final int NT_JAR = 10;
    public static final int NT_PROJECT_OUTPUT = 20;
    public static final int NT_CLASSES = 36;
    public static final int NT_ADD_DIR = 68;
    public static final int CS_CHECKED = 1;
    public static final int CS_UNCHECKED = 2;
    public static final int CS_GRAYED = 3;

    public FJTree(FJTree parent, int nodeType, String displayName, Object buildInfo, int checkState) {
        this.parent = parent;
        this.nodeType = nodeType;
        this.displayName = displayName;
        this.buildInfo = buildInfo;
        this.checkState = checkState;
        this.children = new ArrayList();
        this.childrenRead = false;
    }

    public void addChild(FJTree fjTree) {
        this.children.add(fjTree);
    }

    public void addChild(int nodeType, String displayName, Object buildInfo, int checkState) {
        this.addChild(new FJTree(this, nodeType, displayName, buildInfo, checkState));
    }

    public boolean hasChildren() {
        boolean result = false;
        if (this.isType(4) || this.isType(1)) {
            result = this.children.size() > 0 || !this.childrenRead;
        }
        return result;
    }

    public boolean isType(int type) {
        return (this.nodeType & type) == type;
    }

    public Object[] getChildren() {
        if (!this.childrenRead) {
            this.readChildren();
        }
        Object[] result = this.children.toArray(new Object[this.children.size()]);
        return result;
    }

    public FJTree getParent() {
        return this.parent;
    }

    private void readChildren() {
        this.childrenRead = true;
        if (this.isType(4)) {
            File fChild;
            String name;
            File f = (File)this.buildInfo;
            String[] filesAndDirs = f.list();
            if (filesAndDirs == null) {
                filesAndDirs = new String[]{};
            }
            int i = 0;
            while (i < filesAndDirs.length) {
                name = filesAndDirs[i];
                fChild = new File(f, name);
                if (fChild.isDirectory()) {
                    this.addChild(4, String.valueOf(name) + "/", fChild, this.checkState);
                }
                ++i;
            }
            i = 0;
            while (i < filesAndDirs.length) {
                name = filesAndDirs[i];
                fChild = new File(f, name);
                if (fChild.isFile()) {
                    this.addChild(2, name, fChild, this.checkState);
                }
                ++i;
            }
        }
    }

    public void setChecked(boolean checked) {
        this.checkState = checked ? 1 : 2;
    }

    public int getCheckState() {
        return this.checkState;
    }

    public String toString() {
        return this.displayName;
    }

    public FJTree[] getReadChildren() {
        return this.children.toArray(new FJTree[this.children.size()]);
    }

    public void setGrayChecked() {
        this.checkState = 3;
    }

    public String getAbsPath() {
        String result = null;
        if (this.isType(2) || this.isType(4)) {
            File f = (File)this.buildInfo;
            try {
                result = f.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public String getDisplayPath() {
        String result = this.isType(1) ? "<root>" : (this.isType(20) ? this.displayName.replaceAll(".*'(.*)'.*", "<po|$1>") : (this.isType(36) ? this.displayName.replaceAll(".*'(.*)'.*", "<cl|$1>") : (this.isType(10) ? "<jar|" + this.displayName + ">" : (this.isType(68) ? this.displayName.replaceAll(".*'(.*)': (.*)", "<inc|$1/$2>") : String.valueOf(this.parent.getDisplayPath()) + "~" + this.displayName))));
        return result;
    }
}

