/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.popup.actions;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class ManifestData {
    private Vector manifestMainSection = new Vector();
    private Vector manifestIndividualSection = new Vector();

    public void addFile(String filename) {
        try {
            this.clearMainSection();
            FileInputStream is = new FileInputStream(filename);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            boolean isMainSection = true;
            String line = br.readLine();
            while (line != null) {
                ManifestLine ml = new ManifestLine(line);
                if (ml.isEmptyLine()) {
                    isMainSection = false;
                }
                if (isMainSection) {
                    this.manifestMainSection.add(ml);
                } else {
                    this.manifestIndividualSection.add(ml);
                }
                line = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        ManifestLine ml;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.manifestMainSection.size()) {
            ml = (ManifestLine)this.manifestMainSection.get(i);
            result.append(ml.toString());
            ++i;
        }
        i = 0;
        while (i < this.manifestIndividualSection.size()) {
            ml = (ManifestLine)this.manifestIndividualSection.get(i);
            result.append(ml.toString());
            ++i;
        }
        result.append("\r\n");
        return result.toString();
    }

    public void clearMainSection() {
        this.manifestMainSection.clear();
    }

    public void addMainSectionLine(String line) {
        this.manifestMainSection.add(new ManifestLine(line));
    }

    public void addIndividualSectionLine(String line) {
        this.manifestIndividualSection.add(new ManifestLine(line));
    }

    class ManifestLine {
        private String key;
        private String value;

        String getKey() {
            return this.key;
        }

        String getValue() {
            return this.value;
        }

        ManifestLine(String key, String value) {
            this.key = key;
            this.value = value;
        }

        ManifestLine(String line) {
            int posColon;
            if (line.endsWith("\u0000")) {
                line = line.substring(0, line.length() - 1);
            }
            if ((posColon = line.indexOf(58)) != -1) {
                this.key = line.substring(0, posColon).trim();
                this.value = line.substring(posColon + 1).trim();
            } else {
                this.key = "#";
                this.value = line;
            }
        }

        public boolean isEmptyLine() {
            return this.key.equals("#") && this.value.trim().equals("");
        }

        public String toString() {
            String result = this.key.equals("#") ? String.valueOf(this.value) + "\r\n" : String.valueOf(this.key) + ": " + this.value + "\r\n";
            return result;
        }
    }
}

