/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.wizard;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import net.sf.fjep.fatjar.popup.actions.BuildFatJar;
import net.sf.fjep.fatjar.wizard.FJExportWizardConfigPage;
import net.sf.fjep.fatjar.wizard.FJExportWizardFilesSelectPage;
import net.sf.fjep.fatjar.wizard.FJExportWizardProjectSeletPage;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class FJExportWizard
extends Wizard
implements IExportWizard {
    String[] selectedJavaProjects;
    FJExportWizardProjectSeletPage fjewProject;
    FJExportWizardFilesSelectPage fjewFiles;
    FJExportWizardConfigPage fjewConfig;
    IJavaProject jproject = null;

    public void addPages() {
        if (this.jproject == null) {
            this.fjewProject = new FJExportWizardProjectSeletPage(this.selectedJavaProjects);
            this.addPage((IWizardPage)this.fjewProject);
        }
        this.fjewConfig = new FJExportWizardConfigPage(null, null);
        this.addPage((IWizardPage)this.fjewConfig);
        this.fjewFiles = new FJExportWizardFilesSelectPage(this);
        this.addPage((IWizardPage)this.fjewFiles);
        super.addPages();
    }

    public FJExportWizard() {
    }

    public FJExportWizard(IJavaProject jproject) {
        this.jproject = jproject;
    }

    public boolean performFinish() {
        try {
            if (this.jproject == null) {
                this.jproject = this.fjewProject.getSelectedJavaProject();
            }
            if (this.jproject != null) {
                Properties props = this.fjewConfig.updateProperties();
                String[][] excludeInfo = this.fjewFiles.getAllUnchecked();
                HashSet<String> excludes = new HashSet<String>();
                StringBuffer excludeProp = new StringBuffer();
                int i = 0;
                while (i < excludeInfo.length) {
                    excludes.add(excludeInfo[i][1]);
                    if (i > 0) {
                        excludeProp.append(';');
                    }
                    excludeProp.append(excludeInfo[i][0]);
                    ++i;
                }
                props.setProperty("excludes", excludeProp.toString());
                String[][] includeInfo = this.fjewFiles.getAllChecked();
                ArrayList<String> includes = new ArrayList<String>();
                StringBuffer includeProp = new StringBuffer();
                int i2 = 0;
                while (i2 < includeInfo.length) {
                    includes.add(includeInfo[i2][1]);
                    if (i2 > 0) {
                        includeProp.append(';');
                    }
                    includeProp.append(includeInfo[i2][0]);
                    ++i2;
                }
                props.setProperty("includes", includeProp.toString());
                BuildFatJar bfj = new BuildFatJar();
                bfj.runBuildConfiguredFatJar(this.jproject, props, excludes, includes);
            }
            return this.jproject != null;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error(x);
        }
    }

    public Properties getProperties() {
        Properties result = null;
        try {
            if (this.jproject == null) {
                this.jproject = this.fjewProject.getSelectedJavaProject();
            }
            if (this.jproject != null) {
                Properties props = this.fjewConfig.updateProperties();
                String[][] excludeInfo = this.fjewFiles.getAllUnchecked();
                StringBuffer excludeProp = new StringBuffer();
                int i = 0;
                while (i < excludeInfo.length) {
                    if (i > 0) {
                        excludeProp.append(';');
                    }
                    excludeProp.append(excludeInfo[i][0]);
                    ++i;
                }
                props.setProperty("excludes", excludeProp.toString());
                String[][] includeInfo = this.fjewFiles.getAllChecked();
                StringBuffer includeProp = new StringBuffer();
                int i2 = 0;
                while (i2 < includeInfo.length) {
                    if (i2 > 0) {
                        includeProp.append(';');
                    }
                    includeProp.append(includeInfo[i2][0]);
                    ++i2;
                }
                props.setProperty("includes", includeProp.toString());
                result = props;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new Error(x);
        }
        return result;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] jprojects = selection.toArray();
        this.selectedJavaProjects = new String[jprojects.length];
        int i = 0;
        while (i < jprojects.length) {
            this.selectedJavaProjects[i] = ((JavaProject)jprojects[i]).getProject().getName();
            ++i;
        }
    }

    public boolean execute(Shell shell) {
        this.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)this);
        return dialog.open() == 0;
    }

    public IWizardPage getStartingPage() {
        if (this.jproject != null) {
            this.setJProject(this.jproject);
        }
        return super.getStartingPage();
    }

    public void setJProject(IJavaProject jproject) {
        this.jproject = jproject;
        Properties props = BuildFatJar.getFatJarProperties(jproject);
        this.fjewFiles.setJProject(jproject, props);
        this.fjewConfig.setJProject(jproject, props);
    }
}

