/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.wizard;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sf.fjep.fatjar.FatjarPlugin;
import net.sf.fjep.fatjar.popup.actions.BuildFatJar;
import net.sf.fjep.fatjar.wizard.compatibility.ResourceSorter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.help.ui.internal.browser.SystemBrowserFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FJExportWizardConfigPage
extends WizardPage {
    private IJavaProject jproject;
    private Properties props;
    private Composite controlParent;
    private Text jarnameText;
    private Button useManifestFileCheckbox;
    private Text manifestfileText;
    private Button browseManifestfileButton;
    private Button browseManifestmainclassButton;
    private Button manifestmergeallCheckbox;
    private Button manifestremovesignersCheckbox;
    private Button oneJarButton;
    private Label oneJarExpandLabel;
    private Text manifestmainclassText;
    private Text oneJarExpandText;
    private Text manifestclasspathText;
    private Button jarnameIsExternCheckbox;
    private Button browseJarnameButton;
    private boolean oneJarLicenseRequired;
    private boolean justCreated = false;
    static /* synthetic */ Class class$0;

    public FJExportWizardConfigPage(IJavaProject jproject, Properties props) {
        super("wizardPage");
        this.setTitle("Configure Fat Jar Plug-In");
        this.props = props;
        this.jproject = jproject;
    }

    public void createControl(Composite parent) {
        this.justCreated = true;
        this.controlParent = parent;
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(comp, 0);
        label.setText("&Jar-Name:");
        this.jarnameText = new Text(comp, 2052);
        GridData gd = new GridData(768);
        this.jarnameText.setLayoutData((Object)gd);
        this.jarnameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        this.browseJarnameButton = new Button(comp, 8);
        this.browseJarnameButton.setText("Browse...");
        this.browseJarnameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FJExportWizardConfigPage.this.handleJarnameBrowse();
            }
        });
        label = new Label(comp, 0);
        label.setVisible(false);
        this.jarnameIsExternCheckbox = new Button(comp, 32);
        gd = new GridData(768);
        this.jarnameIsExternCheckbox.setLayoutData((Object)gd);
        this.jarnameIsExternCheckbox.setText("use extern Jar-Name");
        this.jarnameIsExternCheckbox.setToolTipText("path for Jar-Name is absolute if checked or relative to project root folder when unchecked");
        this.jarnameIsExternCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean jarnameIsExtern = FJExportWizardConfigPage.this.jarnameIsExternCheckbox.getSelection();
                String jarname = FJExportWizardConfigPage.this.jarnameText.getText();
                if (jarnameIsExtern) {
                    jarname = String.valueOf(BuildFatJar.getProjectDir(FJExportWizardConfigPage.this.jproject)) + File.separator + jarname;
                } else {
                    String projectDir = String.valueOf(BuildFatJar.getProjectDir(FJExportWizardConfigPage.this.jproject)) + File.separator;
                    if (jarname.startsWith(projectDir)) {
                        jarname = jarname.substring(projectDir.length());
                    } else {
                        jarname = String.valueOf(File.separatorChar) + jarname;
                        jarname = jarname.substring(jarname.lastIndexOf(File.separatorChar) + 1);
                    }
                }
                FJExportWizardConfigPage.this.jarnameText.setText(jarname);
            }
        });
        label = new Label(comp, 0);
        label.setVisible(false);
        label = new Label(comp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        label = new Label(comp, 0);
        label.setVisible(false);
        this.useManifestFileCheckbox = new Button(comp, 32);
        gd = new GridData(768);
        this.useManifestFileCheckbox.setLayoutData((Object)gd);
        this.useManifestFileCheckbox.setText("select Manifest file");
        this.useManifestFileCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useManifestFile = FJExportWizardConfigPage.this.useManifestFileCheckbox.getSelection();
                FJExportWizardConfigPage.this.manifestfileText.setEnabled(useManifestFile);
                FJExportWizardConfigPage.this.browseManifestfileButton.setEnabled(useManifestFile);
                FJExportWizardConfigPage.this.manifestmainclassText.setEnabled(!useManifestFile);
                FJExportWizardConfigPage.this.manifestclasspathText.setEnabled(!useManifestFile);
            }
        });
        label = new Label(comp, 0);
        label.setVisible(false);
        label = new Label(comp, 0);
        label.setText("&Manifest:");
        this.manifestfileText = new Text(comp, 2052);
        gd = new GridData(768);
        this.manifestfileText.setLayoutData((Object)gd);
        this.manifestfileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        this.browseManifestfileButton = new Button(comp, 8);
        this.browseManifestfileButton.setText("Browse...");
        this.browseManifestfileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FJExportWizardConfigPage.this.handleManifestfileBrowse();
            }
        });
        label = new Label(comp, 0);
        label.setText("&Main-Class:");
        this.manifestmainclassText = new Text(comp, 2052);
        gd = new GridData(768);
        this.manifestmainclassText.setLayoutData((Object)gd);
        this.manifestmainclassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        this.browseManifestmainclassButton = new Button(comp, 8);
        this.browseManifestmainclassButton.setText("Browse...");
        this.browseManifestmainclassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FJExportWizardConfigPage.this.handleManifestmainclassBrowse();
            }
        });
        label = new Label(comp, 0);
        label.setText("&Class-Path:");
        this.manifestclasspathText = new Text(comp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.manifestclasspathText.setLayoutData((Object)gd);
        this.manifestclasspathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        label = new Label(comp, 0);
        label.setVisible(false);
        this.manifestmergeallCheckbox = new Button(comp, 32);
        gd = new GridData(768);
        this.manifestmergeallCheckbox.setLayoutData((Object)gd);
        this.manifestmergeallCheckbox.setText("merge individual-sections of all MANIFEST.MF files");
        this.manifestmergeallCheckbox.setEnabled(true);
        label = new Label(comp, 0);
        label.setVisible(false);
        label = new Label(comp, 0);
        label.setVisible(false);
        this.manifestremovesignersCheckbox = new Button(comp, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.manifestremovesignersCheckbox.setLayoutData((Object)gd);
        this.manifestremovesignersCheckbox.setText("remove signer files (*.SF) in META-INF");
        this.manifestremovesignersCheckbox.setEnabled(true);
        label = new Label(comp, 258);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        Label help = new Label(comp, 0);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)FatjarPlugin.getDefault().getBundle().getEntry("icons/help.gif"));
        gd = new GridData();
        gd.horizontalAlignment = 3;
        help.setLayoutData((Object)gd);
        help.setImage(desc.createImage());
        help.setToolTipText("One-JAR Help");
        help.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                FJExportWizardConfigPage.this.showOneJARHelp();
            }
        });
        this.oneJarButton = new Button(comp, 32);
        this.oneJarButton.setText("One-JAR");
        this.oneJarButton.setToolTipText("Build a One-JAR executable (preserves supporting Jar files)");
        this.oneJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean oneJar = FJExportWizardConfigPage.this.oneJarButton.getSelection();
                if (FJExportWizardConfigPage.this.oneJarLicenseRequired) {
                    int code = FJExportWizardConfigPage.this.showOneJARLicense();
                    if (code == 1) {
                        FJExportWizardConfigPage.this.oneJarButton.setSelection(false);
                        return;
                    }
                    FJExportWizardConfigPage.this.oneJarLicenseRequired = false;
                }
                FJExportWizardConfigPage.this.manifestmergeallCheckbox.setEnabled(!oneJar);
                FJExportWizardConfigPage.this.manifestremovesignersCheckbox.setEnabled(!oneJar);
                FJExportWizardConfigPage.this.oneJarExpandLabel.setEnabled(oneJar);
                FJExportWizardConfigPage.this.oneJarExpandText.setEnabled(oneJar);
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        label = new Label(comp, 16384);
        label.setVisible(true);
        this.oneJarExpandLabel = new Label(comp, 0);
        this.oneJarExpandLabel.setText("&One-Jar-Expand:");
        this.oneJarExpandText = new Text(comp, 2052);
        gd = new GridData(768);
        this.oneJarExpandText.setLayoutData((Object)gd);
        this.oneJarExpandText.setToolTipText("Comma separated list of directories/files to expand at runtime (optional)");
        this.oneJarExpandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FJExportWizardConfigPage.this.dialogChanged();
            }
        });
        label = new Label(comp, 16384);
        label.setVisible(true);
        if (this.jproject != null) {
            this.initialize();
            this.dialogChanged();
        }
        this.setControl((Control)comp);
    }

    private void showOneJARHelp() {
        MessageDialog dialog = new MessageDialog(this.getShell(), "One-JAR", null, "One-JAR Help", 2, new String[]{"OK"}, 0){
            protected Font font;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean close() {
                try {
                    this.font.dispose();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    boolean result = super.close();
                    throw throwable;
                }
                {
                    Object var2_3 = null;
                }
                return super.close();
            }

            protected Control createCustomArea(Composite parent) {
                GridData gd = new GridData(768);
                gd.widthHint = 600;
                gd.heightHint = 300;
                String resource = "one-jar-help.txt";
                StringBuffer help = null;
                try {
                    help = FJExportWizardConfigPage.this.readText(((Object)((Object)this)).getClass().getResourceAsStream(resource));
                }
                catch (IOException iox1) {
                    help = new StringBuffer();
                    help.append("Unable to locate built-in help for One-JAR at: " + resource + ": " + iox1);
                }
                Text text = new Text(parent, 2818);
                this.font = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
                FontData fd = this.font.getFontData()[0];
                fd.setHeight(fd.getHeight() - 2);
                this.font = new Font((Device)text.getDisplay(), fd);
                text.setFont(this.font);
                text.setEditable(false);
                text.setLayoutData((Object)gd);
                text.setText(help.toString());
                Hyperlink href = new Hyperlink(parent, 0);
                href.setText("http://one-jar.sourceforge.net");
                href.setForeground(parent.getDisplay().getSystemColor(9));
                href.setUnderlined(true);
                href.addHyperlinkListener(new IHyperlinkListener(this){
                    final /* synthetic */ 13 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        try {
                            SystemBrowserFactory factory = new SystemBrowserFactory();
                            factory.createBrowser().displayURL(e.getLabel());
                        }
                        catch (Exception x) {
                            MessageDialog.openError((Shell)e.display.getActiveShell(), (String)("Unable to open " + e.getLabel()), (String)("Unable to open browser: \n" + x.getStackTrace()));
                        }
                    }
                });
                return text;
            }
        };
        dialog.open();
    }

    private int showOneJARLicense() {
        String[] buttons = new String[]{"Accept", "Decline"};
        MessageDialog dialog = new MessageDialog(this.getShell(), "One-JAR License", null, "One-JAR is licensed according to the following terms.  Please visit http://one-jar.sourceforge.net for more information.", 2, buttons, 0){

            protected Control createCustomArea(Composite parent) {
                Text text = new Text(parent, 2634);
                text.setEditable(false);
                GridData gd = new GridData(768);
                gd.heightHint = 200;
                text.setLayoutData((Object)gd);
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("net.sf.fjep.fatjar.FatjarPlugin");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    JarInputStream jis = new JarInputStream(clazz.getResourceAsStream("one-jar-boot-0.96.jar"));
                    JarEntry entry = (JarEntry)jis.getNextEntry();
                    StringBuffer license = new StringBuffer();
                    while (entry != null) {
                        if (entry.getName().equals("doc/one-jar-license.txt")) {
                            license = FJExportWizardConfigPage.this.readText(jis);
                            break;
                        }
                        entry = (JarEntry)jis.getNextEntry();
                    }
                    text.setText(license.toString());
                    return text;
                }
                catch (Exception exception) {
                    text.setText("The One-JAR license is available at http://one-jar.sourceforge.net");
                    return text;
                }
            }
        };
        return dialog.open();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer readText(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("input stream is null");
        }
        StringBuffer text = new StringBuffer();
        try {
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = is.read(buf)) > 0) {
                text.append(new String(buf, 0, len));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            is.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        is.close();
        return text;
    }

    private void initialize() {
        boolean jarname_isextern = this.props.getProperty("jarname.isextern", "false").equalsIgnoreCase("true");
        String jarname = this.props.getProperty("jarname", "");
        String manifest_file = this.props.getProperty("manifest.file", "<createnew>");
        String manifest_mainclass = this.props.getProperty("manifest.mainclass", "");
        String manifest_classpath = this.props.getProperty("manifest.classpath", "");
        boolean manifest_mergeall = this.props.getProperty("manifest.mergeall", "true").equalsIgnoreCase("true");
        boolean manifest_removesigners = this.props.getProperty("manifest.removesigners", "true").equalsIgnoreCase("true");
        boolean oneJar = this.props.getProperty("onejar.checkbox", "false").equalsIgnoreCase("true");
        String oneJarExpand = this.props.getProperty("onejar.expand", "");
        this.oneJarLicenseRequired = this.props.getProperty("onejar.license.required", "true").equalsIgnoreCase("true");
        this.jarnameText.setText(jarname);
        this.manifestfileText.setText(manifest_file);
        this.manifestmainclassText.setText(manifest_mainclass);
        this.manifestclasspathText.setText(manifest_classpath);
        if (manifest_file == null || manifest_file.equals("<createnew>")) {
            this.useManifestFileCheckbox.setSelection(false);
            this.manifestfileText.setEnabled(false);
            this.browseManifestfileButton.setEnabled(false);
        } else {
            this.useManifestFileCheckbox.setSelection(true);
            this.manifestmainclassText.setEnabled(false);
            this.manifestclasspathText.setEnabled(false);
        }
        this.oneJarButton.setSelection(oneJar);
        this.oneJarExpandText.setText(oneJarExpand);
        this.oneJarExpandLabel.setEnabled(oneJar);
        this.oneJarExpandText.setEnabled(oneJar);
        this.manifestmergeallCheckbox.setEnabled(!oneJar);
        this.manifestremovesignersCheckbox.setEnabled(!oneJar);
        this.manifestmergeallCheckbox.setSelection(manifest_mergeall);
        this.manifestremovesignersCheckbox.setSelection(manifest_removesigners);
        this.jarnameIsExternCheckbox.setSelection(jarname_isextern);
    }

    private void handleJarnameBrowse() {
        if (this.getJarnameIsExtern()) {
            this.handleExternJarnameBrowse();
        } else {
            this.handleProjectJarnameBrowse();
        }
    }

    private void handleExternJarnameBrowse() {
        String filename = this.getJarname();
        (new String[1])[0] = "*.jar";
        FileDialog fileDialog = new FileDialog(this.getShell(), 8192);
        fileDialog.setFileName(filename);
        fileDialog.setText("Save Output as ...");
        try {
            filename = fileDialog.open();
            if (!filename.toLowerCase().endsWith(".jar")) {
                filename = String.valueOf(filename) + ".jar";
            }
            this.jarnameText.setText(filename);
        }
        catch (Exception exception) {}
    }

    private void handleProjectJarnameBrowse() {
        IPath saveFile;
        String jarname = this.getJarname();
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        String name = jarname;
        if (name == null) {
            name = "fatjar_output.jar";
        }
        IProject project = this.jproject.getProject();
        IFile iFile = project.getFile(name);
        dialog.setOriginalFile(iFile);
        dialog.setTitle("Select Output Jar-Name");
        if (dialog.open() == 0 && (saveFile = dialog.getResult()) != null) {
            String projectName;
            String path = saveFile.toString();
            if (!path.startsWith("/" + (projectName = this.jproject.getElementName()) + "/")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Select Output", (String)("output must be stored in project " + projectName));
            } else {
                if (!"jar".equals(saveFile.getFileExtension().toLowerCase())) {
                    saveFile = saveFile.addFileExtension("jar");
                }
                saveFile = saveFile.removeFirstSegments(1).removeTrailingSeparator();
                this.jarnameText.setText(saveFile.toOSString());
            }
        }
    }

    private void handleManifestfileBrowse() {
        Object[] elements;
        String manifestFilename = this.getManifestfile();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle("Select Manifest File");
        dialog.setInput((Object)this.jproject.getProject());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            manifestFilename = ((IResource)elements[0]).getFullPath().toOSString();
            int n = manifestFilename.indexOf(File.separatorChar, 1);
            if (n != -1) {
                manifestFilename = manifestFilename.substring(n + 1);
            }
            this.manifestfileText.setText(manifestFilename);
        }
    }

    private void handleManifestmainclassBrowse() {
        try {
            Object[] elements;
            String mainClass = this.getManifestmainclass();
            new WorkbenchLabelProvider();
            new WorkbenchContentProvider();
            IResource[] res = new IResource[]{this.jproject.getCorrespondingResource()};
            IJavaSearchScope searchScope = JavaSearchScopeFactory.getInstance().createJavaSearchScope(res, true);
            SelectionDialog dialog = JavaUI.createMainTypeDialog((Shell)this.getShell(), (IRunnableContext)this.getContainer(), (IJavaSearchScope)searchScope, (int)0, (boolean)false);
            dialog.setMessage("Select Main-Class for JAR file");
            dialog.setTitle("Fat Jar Config");
            if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
                SourceType mainElement = (SourceType)elements[0];
                mainClass = mainElement.getFullyQualifiedName();
                this.manifestmainclassText.setText(mainClass);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void dialogChanged() {
        boolean onejar = this.getOneJar();
        String mainclass = this.getManifestmainclass();
        if (onejar && (mainclass == null || mainclass.length() == 0)) {
            this.updateStatus("Main-Class must be specified for One-JAR archives", null);
            return;
        }
        String jarname = this.getJarname();
        if (jarname.length() == 0) {
            this.updateStatus("Jar File must be specified", null);
            return;
        }
        if (!jarname.toLowerCase().endsWith(".jar")) {
            this.updateStatus(null, "Jar File extension should be \"jar\"");
            return;
        }
        this.updateStatus(null, null);
    }

    private void updateStatus(String errorMessage, String warnMessage) {
        if (warnMessage == null) {
            this.setMessage(null);
        } else {
            this.setMessage(warnMessage, 2);
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public String getJarname() {
        return this.jarnameText.getText();
    }

    public String getManifestfile() {
        return this.manifestfileText.getText();
    }

    public String getManifestmainclass() {
        return this.manifestmainclassText.getText();
    }

    public String getManifestclasspath() {
        return this.manifestclasspathText.getText();
    }

    public boolean getManifestmergeall() {
        return this.manifestmergeallCheckbox.getSelection();
    }

    public boolean getManifestremovesigners() {
        return this.manifestremovesignersCheckbox.getSelection();
    }

    public boolean getJarnameIsExtern() {
        return this.jarnameIsExternCheckbox.getSelection();
    }

    public boolean getOneJar() {
        return this.oneJarButton.getSelection();
    }

    public Properties updateProperties() {
        String jarname = this.getJarname();
        String manifest_file = this.getManifestfile();
        String manifest_mainclass = this.getManifestmainclass();
        String manifest_classpath = this.getManifestclasspath();
        boolean manifest_mergeall = this.getManifestmergeall();
        boolean manifest_removesigners = this.getManifestremovesigners();
        boolean useManifestFile = this.useManifestFileCheckbox.getSelection();
        boolean jarnameIsExtern = this.getJarnameIsExtern();
        this.props.setProperty("jarname.isextern", Boolean.toString(jarnameIsExtern));
        this.props.setProperty("jarname", jarname);
        if (useManifestFile) {
            this.props.setProperty("manifest.file", manifest_file);
        } else {
            this.props.setProperty("manifest.file", "<createnew>");
        }
        this.props.setProperty("manifest.mainclass", manifest_mainclass);
        this.props.setProperty("manifest.classpath", manifest_classpath);
        this.props.setProperty("manifest.mergeall", Boolean.toString(manifest_mergeall));
        this.props.setProperty("manifest.removesigners", Boolean.toString(manifest_removesigners));
        this.props.setProperty("onejar.checkbox", "" + this.oneJarButton.getSelection());
        this.props.setProperty("onejar.license.required", "" + this.oneJarLicenseRequired);
        this.props.setProperty("onejar.expand", this.oneJarExpandText.getText());
        return this.props;
    }

    public void setJProject(IJavaProject jproject, Properties props) {
        if (this.jproject != jproject) {
            this.jproject = jproject;
            this.props = props;
            this.setDescription("Config for project " + jproject.getProject().getName());
            this.initialize();
            this.dialogChanged();
        }
    }
}

