/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import net.sf.fjep.fatjar.FatjarPlugin;
import net.sf.fjep.fatjar.popup.actions.BuildFatJar;
import net.sf.fjep.fatjar.popup.actions.FJTree;
import net.sf.fjep.fatjar.wizard.FJExportWizard;
import net.sf.fjep.fatjar.wizard.compatibility.ResourceSorter;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.osgi.framework.Bundle;

public class FJExportWizardFilesSelectPage
extends WizardPage {
    private CheckboxTreeViewer fileTree = null;
    private IJavaProject jproject = null;
    private FJTree rootTree = null;
    private FJExportWizard fjew = null;

    public FJExportWizardFilesSelectPage(FJExportWizard fjew) {
        super("wizardPage");
        this.fjew = fjew;
        this.setTitle("Select files for Fat Jar");
        this.setDescription("define includes / excludes");
    }

    public void createControl(Composite parent) {
        try {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            comp.setLayout((Layout)layout);
            layout.numColumns = 3;
            layout.verticalSpacing = 9;
            Label label = new Label(comp, 0);
            label.setText("File-List:");
            Tree tree = new Tree(comp, 68130);
            GridData gd = new GridData(1808);
            gd.heightHint = tree.getItemHeight() * 10;
            tree.setLayoutData((Object)gd);
            this.fileTree = new CheckboxTreeViewer(tree);
            FileSelectTreeContentProvider cp = new FileSelectTreeContentProvider();
            this.fileTree.setContentProvider((IContentProvider)cp);
            this.fileTree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FJExportWizardFilesSelectPage.this.dialogSelectionChanged(event);
                }
            });
            this.fileTree.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    FJExportWizardFilesSelectPage.this.dialogCheckChanged(event);
                }
            });
            this.fileTree.addTreeListener(new ITreeViewerListener(){

                public void treeCollapsed(TreeExpansionEvent event) {
                }

                public void treeExpanded(TreeExpansionEvent event) {
                    FJExportWizardFilesSelectPage.this.dialogTreeExpanded(event);
                }
            });
            Button addDir = new Button(comp, 8);
            addDir.setText("Add Dir...");
            addDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FJExportWizardFilesSelectPage.this.handleAddDirButton();
                }
            });
            Button saveAsButton = new Button(comp, 8);
            gd = new GridData();
            gd.horizontalAlignment = 2;
            gd.horizontalSpan = 2;
            saveAsButton.setLayoutData((Object)gd);
            saveAsButton.setText("Save Settings...");
            saveAsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FJExportWizardFilesSelectPage.this.handleSaveSettings();
                }
            });
            Button exportAntButton = new Button(comp, 8);
            gd = new GridData();
            gd.horizontalAlignment = 2;
            gd.horizontalSpan = 1;
            exportAntButton.setLayoutData((Object)gd);
            exportAntButton.setText("Export ANT...");
            exportAntButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FJExportWizardFilesSelectPage.this.handleExportANT();
                }
            });
            this.initialize();
            this.fileTree.setCheckedElements(this.rootTree.getChildren());
            this.dialogChanged();
            this.setControl((Control)comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleAddDirButton() {
        String includeDir = this.selectWorkspaceDir();
        if (includeDir != null) {
            this.addProjectInclude(includeDir);
        }
    }

    private void handleSaveSettings() {
        IPath saveFile;
        int pos;
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        String name = BuildFatJar.absPropertiesFilename;
        if (name == null) {
            name = "settings.fatjar";
        }
        if ((pos = name.lastIndexOf(File.separatorChar)) != -1) {
            name = name.substring(pos + 1);
        }
        IProject project = this.jproject.getProject();
        IFile iFile = project.getFile(name);
        dialog.setOriginalFile(iFile);
        dialog.setTitle("Save FatJar Settings");
        if (dialog.open() == 0 && (saveFile = dialog.getResult()) != null) {
            String projectName;
            String path = saveFile.toString();
            if (!path.startsWith("/" + (projectName = this.jproject.getElementName()) + "/")) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Save Settings", (String)("settings must be stored in project " + projectName));
            } else {
                Properties props;
                if (!"fatjar".equals(saveFile.getFileExtension())) {
                    saveFile = saveFile.addFileExtension("fatjar");
                }
                if ((props = this.fjew.getProperties()) != null) {
                    this.saveConfig(saveFile, props);
                }
            }
        }
    }

    private void saveConfig(IPath saveFile, Properties props) {
        boolean ok = true;
        try {
            String prjFilename = saveFile.toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            String propertiesFile = BuildFatJar.absProjectPath(this.jproject.getProject().getWorkspace().getRoot(), prjFilename);
            File f = new File(propertiesFile);
            if (f.exists() && f.canRead()) {
                String projectDir;
                try {
                    FileInputStream in = new FileInputStream(f);
                    Properties oldProps = new Properties();
                    oldProps.load(in);
                    ((InputStream)in).close();
                    if (oldProps.equals(props)) {
                        ok = false;
                    }
                }
                catch (Exception exception) {}
                if (ok && propertiesFile.startsWith(projectDir = BuildFatJar.getProjectDir(this.jproject))) {
                    String relFile = propertiesFile.substring(projectDir.length() + 1);
                    IFile editFile = this.jproject.getProject().getFile(relFile);
                    if (editFile != null) {
                        IStatus status = FatjarPlugin.askFileWriteAccess(editFile);
                        boolean bl = ok = status == null || status.isOK();
                        if (!ok) {
                            Shell shell = new Shell();
                            MessageDialog.openInformation((Shell)shell, (String)"Fat Jar Plug-In Warning", (String)("could not save current settings: " + status.toString()));
                        }
                    }
                }
            }
            if (ok) {
                FileOutputStream out = new FileOutputStream(f);
                props.store(out, "Fat Jar Configuration File");
                out.flush();
                ((OutputStream)out).close();
                BuildFatJar.absPropertiesFilename = propertiesFile;
                try {
                    this.jproject.getProject().refreshLocal(1, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Save Settings", (String)("path='" + saveFile.toString() + "': msg='" + e.getMessage() + "'"));
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Save Settings", (String)("path='" + saveFile.toString() + "': msg='" + e.getMessage() + "'"));
        }
    }

    private void handleExportANT() {
        IPath saveFile;
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        String name = "build.xml";
        IProject project = this.jproject.getProject();
        IFile iFile = project.getFile(name);
        dialog.setOriginalFile(iFile);
        dialog.setTitle("Export ANT build file");
        if (dialog.open() == 0 && (saveFile = dialog.getResult()) != null) {
            IStatus status;
            saveFile.toString();
            this.jproject.getElementName();
            if (!"xml".equals(saveFile.getFileExtension())) {
                saveFile = saveFile.addFileExtension("xml");
            }
            boolean ok = true;
            IFile buildFile = project.getWorkspace().getRoot().getFile(saveFile);
            if (buildFile != null && (status = FatjarPlugin.askFileWriteAccess(buildFile)) != null && !status.isOK()) {
                ok = false;
                Shell shell = new Shell();
                MessageDialog.openError((Shell)shell, (String)"Fat Jar Plug-In Error", (String)("Export ANT, write access denied: " + status.toString()));
            }
            if (ok) {
                SourceInfo[] sourceInfo = this.getANTBuildInfo();
                this.exportANTBuild(saveFile, sourceInfo);
            }
        }
    }

    private void exportANTBuild(IPath saveFile, SourceInfo[] sourceInfo) {
        try {
            String antScript = this.buildANTScript(sourceInfo);
            String prjFilename = saveFile.toString().replace('/', File.separatorChar).replace('\\', File.separatorChar);
            String buildFile = BuildFatJar.absProjectPath(this.jproject.getProject().getWorkspace().getRoot(), prjFilename);
            File f = new File(buildFile);
            FileOutputStream out = new FileOutputStream(f);
            ((OutputStream)out).write(antScript.getBytes());
            out.flush();
            ((OutputStream)out).close();
            try {
                this.jproject.getProject().refreshLocal(1, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Export ANT", (String)("path=" + saveFile.toString() + e.getMessage()));
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Fat Jar Export ANT", (String)("path=" + saveFile.toString() + e.getMessage()));
        }
    }

    private String buildANTScript(SourceInfo[] sourceInfos) {
        String location;
        StringBuffer script = new StringBuffer();
        script.append("<?xml version=\"1.0\"?>\r\n");
        String fatjarPath = "?";
        String output = this.fjew.fjewConfig.getJarname().replace('\\', '/');
        String outputName = output.substring(output.lastIndexOf(47) + 1);
        FatjarPlugin pi = FatjarPlugin.getDefault();
        Bundle bundle = pi.getBundle();
        if (bundle != null && (location = bundle.getLocation()) != null) {
            fatjarPath = String.valueOf(location.replaceFirst("update[@][/]?", "")) + "fatjar.jar";
        }
        script.append("<project name=\"FatJar " + outputName + " (experimental)\" default=\"main\" basedir=\".\">\r\n");
        script.append("    <!-- this file was created by Fat-Jar Eclipse Plug-in -->\r\n");
        script.append("    <!-- the ANT-Export is in a very early stage, so this -->\r\n");
        script.append("    <!-- is only experimental, ANT 1.6 or above is        -->\r\n");
        script.append("    <!-- required, feedback is always welcome:            -->\r\n");
        script.append("    <!--       http://sourceforge.net/projects/fjep       -->\r\n");
        script.append("    <!-- uncomment the following lines if using ANT outside Eclipse -->\r\n");
        script.append("    <!--\r\n");
        script.append("        <property name=\"fjepPath\" value=\"" + fatjarPath + "\"/>\r\n");
        script.append("        <taskdef name=\"fatjar.build\" classname=\"net.sf.fjep.anttask.FJBuildTask\" classpath=\"${fjepPath}\"/>\r\n");
        script.append("        <typedef name=\"fatjar.manifest\" classname=\"net.sf.fjep.anttask.FJManifestType\" classpath=\"${fjepPath}\"/>\r\n");
        script.append("        <typedef name=\"fatjar.exclude\" classname=\"net.sf.fjep.anttask.FJExcludeType\" classpath=\"${fjepPath}\"/>\r\n");
        script.append("        <typedef name=\"fatjar.jarsource\" classname=\"net.sf.fjep.anttask.FJJarSourceType\" classpath=\"${fjepPath}\"/>\r\n");
        script.append("        <typedef name=\"fatjar.filesource\" classname=\"net.sf.fjep.anttask.FJFileSourceType\" classpath=\"${fjepPath}\"/>\r\n");
        script.append("    -->\r\n");
        script.append("    <!-- uncomment the above lines to use ANT outside of Eclipse -->\r\n");
        script.append("    <target name=\"main\">\r\n");
        String attribs = "";
        boolean oneJar = this.fjew.fjewConfig.getOneJar();
        if (oneJar) {
            attribs = String.valueOf(attribs) + " onejar=\"true\"";
        }
        attribs = String.valueOf(attribs) + " output=\"" + outputName + "\"";
        script.append("        <fatjar.build" + attribs + ">\r\n");
        String manifestFile = this.fjew.fjewConfig.getManifestfile();
        String manifestClasspath = this.fjew.fjewConfig.getManifestclasspath();
        String manifestMainclass = this.fjew.fjewConfig.getManifestmainclass();
        boolean manifestMergeall = this.fjew.fjewConfig.getManifestmergeall();
        boolean manifestRemovesigners = this.fjew.fjewConfig.getManifestremovesigners();
        attribs = "";
        if (!manifestMergeall) {
            attribs = String.valueOf(attribs) + " mergemanifests=\"false\"";
        }
        if (!manifestRemovesigners) {
            attribs = String.valueOf(attribs) + " removesigners=\"false\"";
        }
        if (manifestFile != null && !manifestFile.trim().equals("") && !manifestFile.trim().equals("<createnew>")) {
            attribs = String.valueOf(attribs) + " manifestfile=\"" + manifestFile + "\"";
        } else {
            if (manifestMainclass != null && !manifestMainclass.trim().equals("")) {
                attribs = String.valueOf(attribs) + " mainclass=\"" + manifestMainclass + "\"";
            }
            if (manifestClasspath != null && !manifestClasspath.trim().equals("")) {
                attribs = String.valueOf(attribs) + " classpath=\"" + manifestClasspath + "\"";
            }
        }
        script.append("            <fatjar.manifest" + attribs + "/>\r\n");
        int i = 0;
        while (i < sourceInfos.length) {
            SourceInfo info = sourceInfos[i];
            if (info.isJar) {
                script.append("            <fatjar.jarsource file=\"" + info.absPath + "\" relpath=\"" + info.relPath + "\"/>\r\n");
            } else if (info.excludes.size() == 0) {
                script.append("            <fatjar.filesource path=\"" + info.absPath + "\" relpath=\"" + info.relPath + "\"/>\r\n");
            } else {
                script.append("            <fatjar.filesource path=\"" + info.absPath + "\" relpath=\"" + info.relPath + "\">\r\n");
                int j = 0;
                while (j < info.excludes.size()) {
                    String exclude = (String)info.excludes.get(j);
                    script.append("                <fatjar.exclude relpath=\"" + exclude + "\"/>\r\n");
                    ++j;
                }
                script.append("            </fatjar.filesource>\r\n");
            }
            ++i;
        }
        script.append("        </fatjar.build>\r\n");
        script.append("    </target>\r\n");
        script.append("</project>\r\n");
        return script.toString();
    }

    private void addProjectInclude(String projectDir) {
        int pos = projectDir.indexOf(File.separatorChar, 1);
        if (pos != -1) {
            String project = projectDir.substring(1, pos);
            String relPath = projectDir.substring(pos + 1);
            String displayName = "Include from project '" + project + "': " + relPath;
            String absPath = BuildFatJar.absProjectPath(ResourcesPlugin.getWorkspace().getRoot(), projectDir);
            if (absPath != null) {
                this.rootTree.addChild(68, displayName, new File(absPath), 2);
                this.fileTree.refresh((Object)this.rootTree);
            }
        }
    }

    private String selectWorkspaceDir() {
        Object[] elements;
        String result = null;
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator(null);
        dialog.setAllowMultiple(false);
        dialog.setTitle("Select base directory to add");
        dialog.setMessage("msg?");
        ViewerFilter filter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ok = element instanceof Folder || element instanceof Project;
                return ok;
            }
        };
        dialog.addFilter(filter);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            result = ((IResource)elements[0]).getFullPath().toOSString();
        }
        return result;
    }

    private void initialize() {
        BuildFatJar bfj = new BuildFatJar();
        if (this.jproject == null) {
            this.setDescription("no project selected");
            this.rootTree = new FJTree(null, 1, "empty", null, 1);
        } else {
            this.setDescription("Files for project " + this.jproject.getElementName());
            this.rootTree = bfj.buildTree(this.jproject);
        }
        this.fileTree.setInput((Object)this.rootTree);
        this.fileTree.setCheckedElements((Object[])this.rootTree.getReadChildren());
    }

    private void dialogSelectionChanged(SelectionChangedEvent event) {
        this.dialogChanged();
    }

    private void recursiveCheckChildren(FJTree parent, boolean checked) {
        FJTree[] children = parent.getReadChildren();
        int i = 0;
        while (i < children.length) {
            FJTree child = children[i];
            if (checked && child.getCheckState() != 1 || !checked && child.getCheckState() != 2) {
                child.setChecked(checked);
                this.fileTree.setChecked((Object)child, checked);
                this.fileTree.setGrayed((Object)child, false);
                this.recursiveCheckChildren(child, checked);
            }
            ++i;
        }
    }

    private void recursiveGrayParents(FJTree child) {
        FJTree parent = child.getParent();
        if (parent != null) {
            parent.setGrayChecked();
            this.fileTree.setGrayChecked((Object)parent, true);
            this.recursiveGrayParents(parent);
        }
    }

    private void dialogCheckChanged(CheckStateChangedEvent event) {
        FJTree element = (FJTree)event.getElement();
        if (element != null) {
            boolean checked = event.getChecked();
            if (!checked && element.getCheckState() == 3) {
                this.fileTree.setGrayed((Object)element, false);
                this.fileTree.setChecked((Object)element, true);
                checked = true;
            }
            if (checked && element.getCheckState() != 1 || !checked && element.getCheckState() != 2) {
                element.setChecked(checked);
                this.recursiveCheckChildren(element, checked);
                this.recursiveGrayParents(element);
            }
        }
        this.dialogChanged();
    }

    private void dialogTreeExpanded(TreeExpansionEvent event) {
        FJTree parent = (FJTree)event.getElement();
        if (parent != null) {
            Object[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                FJTree child = (FJTree)children[i];
                int checkState = child.getCheckState();
                if (checkState == 1) {
                    this.fileTree.setChecked((Object)child, true);
                    this.fileTree.setGrayed((Object)child, false);
                } else if (checkState == 2) {
                    this.fileTree.setChecked((Object)child, false);
                } else if (checkState == 3) {
                    this.fileTree.setGrayChecked((Object)child, true);
                }
                ++i;
            }
        }
        this.dialogChanged();
    }

    private void dialogChanged() {
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public void setJProject(IJavaProject jproject, Properties props) {
        if (this.jproject != jproject) {
            this.jproject = jproject;
            this.initialize();
            this.setExcludes(props.getProperty("excludes"));
            this.setIncludes(props.getProperty("includes"));
            this.dialogChanged();
        }
    }

    private void setExcludes(String excludeString) {
        if (excludeString != null && !excludeString.trim().equals("")) {
            String[] excludes = excludeString.split("[;]");
            int i = 0;
            while (i < excludes.length) {
                String[] segments = excludes[i].split("[~]");
                FJTree element = this.findBaseElement(segments[0]);
                int j = 1;
                while (j < segments.length) {
                    if (element == null) break;
                    element = this.findChild(element, segments[j]);
                    ++j;
                }
                if (element != null) {
                    element.setChecked(false);
                    this.fileTree.setChecked((Object)element, false);
                    this.fileTree.setGrayed((Object)element, false);
                    this.recursiveCheckChildren(element, false);
                    this.recursiveGrayParents(element);
                }
                ++i;
            }
        }
    }

    private void setIncludes(String includeString) {
        if (includeString != null && !includeString.trim().equals("")) {
            String[] includes = includeString.split("[;]");
            int i = 0;
            while (i < includes.length) {
                String[] segments = includes[i].split("[~]");
                FJTree element = this.findBaseElement(segments[0]);
                if (element == null) {
                    this.addIncludeDir(segments[0]);
                    element = this.findBaseElement(segments[0]);
                }
                int j = 1;
                while (j < segments.length) {
                    if (element == null) break;
                    element = this.findChild(element, segments[j]);
                    ++j;
                }
                if (element != null) {
                    element.setChecked(true);
                    this.fileTree.setChecked((Object)element, true);
                    this.fileTree.setGrayed((Object)element, false);
                    this.recursiveCheckChildren(element, true);
                    this.recursiveGrayParents(element);
                }
                ++i;
            }
        }
    }

    private void addIncludeDir(String incDir) {
        String projectDir = incDir.replaceFirst("[<]inc[|](.*)[>]", "/$1");
        if (!projectDir.equals(incDir)) {
            this.addProjectInclude(projectDir.replace('/', File.separatorChar));
        }
    }

    private FJTree findChild(FJTree parent, String name) {
        FJTree result = null;
        if (parent != null) {
            Object[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].toString().equals(name)) {
                    result = (FJTree)children[i];
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private FJTree findBaseElement(String name) {
        String displayName = name;
        if (name.startsWith("<po|")) {
            displayName = name.replaceFirst("[<]po[|](.*)[>]", "Project '$1' output");
        } else if (name.startsWith("<cl|")) {
            displayName = name.replaceFirst("[<]cl[|](.*)[>]", "Classes '$1'");
        } else if (name.startsWith("<jar|")) {
            displayName = name.replaceFirst("[<]jar[|](.*)[>]", "$1");
        } else if (name.startsWith("<inc|")) {
            displayName = name.replaceFirst("[<]inc[|]([^/]*)/(.*)[>]", "Include from project '$1': $2");
        }
        return this.findChild(this.rootTree, displayName);
    }

    public String[][] getAllUnchecked() {
        Vector result = new Vector();
        FJTree[] children = this.rootTree.getReadChildren();
        int i = 0;
        while (i < children.length) {
            if (!children[i].isType(68)) {
                this.recursiveGetAllUnchecked(children[i], result);
            }
            ++i;
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    private void recursiveGetAllUnchecked(FJTree node, Vector unchecked) {
        if (node.getCheckState() == 2) {
            String[] display_abspath = new String[]{node.getDisplayPath(), node.getAbsPath()};
            unchecked.add(display_abspath);
        } else if (node.getCheckState() != 1) {
            FJTree[] children = node.getReadChildren();
            int i = 0;
            while (i < children.length) {
                this.recursiveGetAllUnchecked(children[i], unchecked);
                ++i;
            }
        }
    }

    public String[][] getAllChecked() {
        Vector result = new Vector();
        FJTree[] children = this.rootTree.getReadChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].isType(68)) {
                this.recursiveGetAllChecked(children[i], result, children[i].getAbsPath());
            }
            ++i;
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    private void recursiveGetAllChecked(FJTree node, Vector checked, String rootAbsPath) {
        if (node.getCheckState() == 1) {
            int len = rootAbsPath.length() + 1;
            String nodeAbsPath = node.getAbsPath();
            String[] display_abspath = nodeAbsPath.equals(rootAbsPath) ? new String[]{node.getDisplayPath(), String.valueOf(rootAbsPath) + "|"} : new String[]{node.getDisplayPath(), String.valueOf(rootAbsPath) + "|" + node.getAbsPath().substring(len)};
            checked.add(display_abspath);
        } else if (node.getCheckState() != 2) {
            FJTree[] children = node.getReadChildren();
            int i = 0;
            while (i < children.length) {
                this.recursiveGetAllChecked(children[i], checked, rootAbsPath);
                ++i;
            }
        }
    }

    public SourceInfo[] getANTBuildInfo() {
        Vector<SourceInfo> result = new Vector<SourceInfo>();
        FJTree[] children = this.rootTree.getReadChildren();
        int i = 0;
        while (i < children.length) {
            String exclude;
            Vector unchecked;
            String[] display_abspath;
            int j;
            FJTree fjTree = children[i];
            SourceInfo sourceInfo = null;
            if (fjTree.isType(68)) {
                Vector checked = new Vector();
                this.recursiveGetAllChecked(fjTree, checked, "");
                j = 0;
                while (j < checked.size()) {
                    display_abspath = (String[])checked.get(j);
                    String include = display_abspath[0];
                    include = include.replaceFirst("[<]inc[|][^>]+[>]", "");
                    include = include.replaceAll("[~]", "");
                    System.out.println("include=" + include);
                    String absPath = String.valueOf(fjTree.getAbsPath()) + "/" + include;
                    absPath = absPath.replace('/', File.separatorChar);
                    sourceInfo = new SourceInfo(false, absPath, include);
                    result.add(sourceInfo);
                    ++j;
                }
            } else if (fjTree.isType(36)) {
                if (fjTree.getCheckState() != 2) {
                    sourceInfo = new SourceInfo(false, fjTree.getAbsPath(), "");
                    unchecked = new Vector();
                    this.recursiveGetAllUnchecked(fjTree, unchecked);
                    j = 0;
                    while (j < unchecked.size()) {
                        display_abspath = (String[])unchecked.get(j);
                        exclude = display_abspath[0];
                        exclude = exclude.replaceFirst("[<]cl[|][^>]+[>]", "");
                        exclude = exclude.replaceAll("[~]", "");
                        System.out.println("exclude=" + exclude);
                        sourceInfo.excludes.add(exclude);
                        ++j;
                    }
                    result.add(sourceInfo);
                }
            } else if (fjTree.isType(10)) {
                if (fjTree.getCheckState() != 2) {
                    sourceInfo = new SourceInfo(true, fjTree.getAbsPath(), "");
                    result.add(sourceInfo);
                }
            } else if (fjTree.isType(20) && fjTree.getCheckState() != 2) {
                sourceInfo = new SourceInfo(false, fjTree.getAbsPath(), "");
                unchecked = new Vector();
                this.recursiveGetAllUnchecked(fjTree, unchecked);
                j = 0;
                while (j < unchecked.size()) {
                    display_abspath = (String[])unchecked.get(j);
                    exclude = display_abspath[0];
                    exclude = exclude.replaceFirst("[<]po[|][^>]+[>]", "");
                    exclude = exclude.replaceAll("[~]", "");
                    System.out.println("exclude=" + exclude);
                    sourceInfo.excludes.add(exclude);
                    ++j;
                }
                result.add(sourceInfo);
            }
            ++i;
        }
        return result.toArray(new SourceInfo[result.size()]);
    }

    public class FileSelectTreeContentProvider
    implements ITreeContentProvider {
        public Object[] getChildren(Object element) {
            FJTree tree = (FJTree)element;
            return tree.getChildren();
        }

        public Object[] getElements(Object element) {
            FJTree tree = (FJTree)element;
            return tree.getChildren();
        }

        public boolean hasChildren(Object element) {
            FJTree tree = (FJTree)element;
            return tree.hasChildren();
        }

        public Object getParent(Object element) {
            FJTree tree = (FJTree)element;
            return tree.getParent();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
        }
    }

    public class SourceInfo {
        public boolean isJar;
        public String absPath;
        public String relPath;
        public ArrayList excludes;

        public SourceInfo(boolean isJar, String absPath, String relPath) {
            this.isJar = isJar;
            this.absPath = absPath;
            this.relPath = relPath;
            this.excludes = new ArrayList();
        }
    }
}

