/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fjep.fatjar.wizard;

import java.util.Vector;
import net.sf.fjep.fatjar.wizard.FJExportWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class FJExportWizardProjectSeletPage
extends WizardPage {
    private String[] currentSelection;
    CheckboxTreeViewer projectTree;

    public FJExportWizardProjectSeletPage(String[] currentSelection) {
        super("wizardPage");
        this.setTitle("Select one Java Project");
        this.setDescription("This project will be deployed as Fat Jar");
        this.currentSelection = currentSelection;
    }

    public void createControl(Composite parent) {
        try {
            Composite comp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            comp.setLayout((Layout)layout);
            layout.numColumns = 3;
            layout.verticalSpacing = 9;
            Label label = new Label(comp, 0);
            label.setText("Java Project:");
            Tree tree = new Tree(comp, 68130);
            GridData gd = new GridData(1808);
            gd.heightHint = tree.getItemHeight() * 10;
            tree.setLayoutData((Object)gd);
            this.projectTree = new CheckboxTreeViewer(tree);
            JavaProjectsTreeContentProvider cp = new JavaProjectsTreeContentProvider();
            this.projectTree.setContentProvider((IContentProvider)cp);
            this.projectTree.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    FJExportWizardProjectSeletPage.this.dialogChanged();
                }
            });
            label = new Label(comp, 0);
            label.setVisible(false);
            this.initialize();
            this.projectTree.setCheckedElements((Object[])this.currentSelection);
            this.dialogChanged();
            this.setControl((Control)comp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[] getJProjectList() {
        Vector<String> result = new Vector<String>();
        IJavaProject[] jprojects = null;
        try {
            jprojects = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProjects();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < jprojects.length) {
            result.add(jprojects[i].getProject().getName());
            ++i;
        }
        String[] resultArray = result.toArray(new String[result.size()]);
        return resultArray;
    }

    private void initialize() {
        String[] projectList = this.getJProjectList();
        this.projectTree.setInput((Object)projectList);
    }

    private void dialogChanged() {
        int cnt = this.projectTree.getCheckedElements().length;
        if (cnt == 0) {
            this.updateStatus("No Java project has been selected");
        } else if (cnt == 1) {
            this.updateStatus(null);
        } else {
            this.updateStatus("Only one Java project can be selected");
        }
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public boolean canFlipToNextPage() {
        boolean ok = false;
        if (this.isPageComplete()) {
            FJExportWizard fjew = (FJExportWizard)this.getWizard();
            fjew.setJProject(this.getSelectedJavaProject());
            ok = true;
        }
        return ok && super.canFlipToNextPage();
    }

    public IJavaProject getSelectedJavaProject() {
        IJavaProject result = null;
        Object[] checked = this.projectTree.getCheckedElements();
        if (checked.length == 1) {
            String projectName = (String)checked[0];
            result = JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(projectName);
        }
        return result;
    }

    public class JavaProjectsTreeContentProvider
    implements ITreeContentProvider {
        private Object[] root;

        public Object[] getChildren(Object element) {
            return element == this.root ? this.root : new Object[]{};
        }

        public Object[] getElements(Object element) {
            return element == this.root ? this.root : new Object[]{};
        }

        public boolean hasChildren(Object element) {
            return element == this.root;
        }

        public Object getParent(Object element) {
            return element == this.root ? null : this.root;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old_input, Object new_input) {
            this.root = (Object[])new_input;
        }
    }
}

