# Copyright 1999-2007, ALTIBASE Corporation or its subsidiaries.
# All rights reserved.

# $Id: rule.mk 11377 2010-06-28 04:37:01Z djin $
#

#
# [1] Description of variables for generate compile rules
#
# DEFINES           : predefined macros
# INCLUDES          : search path for header files
# OBJDIRS           : search path for compiled objects
# LIBDIRS           : search path for compiled libraries
#
# GENERATED_SRCS    : source files generated by external tool
# GENERATED_HDR_DIR : directory path for generated header files
#
#
# [1.1] Compile Objects
#
# OBJ_TARGETS = target
#
# target_SRCS       : source files to be compiled
# target_MSGS       : message files
# target_INCLUDES   : header file search path
# target_DEFINES    : predefined macros for target
# target_CC_FLAGS   : additional compiler flags
#
#
# [1.2] Compile Relocatable Objects
#
# SHOBJ_TARGETS = target
#
# target_SRCS       : source files to be compiled
# target_MSGS       : message files
# target_INCLUDES   : header file search path
# target_DEFINES    : predefined macros for target
# target_CC_FLAGS   : additioanl compiler flags
#
#
# [1.3] Compile Library
#
# LIB_TARGETS = target
#
# target_NAME       : library name
# target_OBJS       : object files to be archived into the library
#
#
# [1.4] Compile Shared Library
#
# SHLIB_TARGETS = target
#
# target_NAME       : library name
# target_OBJS       : object files to be linked into the library
# target_LIBDEF     : library definition file (MSVC; only required for not ACP_EXPORTed functions)
# target_LIBDIRS    : search path for dependent libraries
# target_SHLIBS     : dependent shared libraries
# target_EXTLIBS    : dependent external libraries
#
#
# [1.5] Compile Executable Program
#
# EXEC_TARGETS = target
#
# target_NAME       : executable program name
# target_SRCS       : source files to be compiled and linked into the executable program
# target_OBJS       : object files to be linked into the executable program
# target_LIBDIRS    : search path for dependent libraries
# target_LIBS       : dependent static libraries
# target_SHLIBS     : dependent shared libraries
# target_EXTLIBS    : dependent external libraries
# target_GENMAP     : whether the map file should be generated or not
#
#
# [1.6] Compile & Run Unit Test
#
# UNITTEST_TARGETS = target
#
# target_NAME       : executable program name
# target_SRCS       : source files to be compiled and linked into the executable program
# target_OBJS       : object files to be linked into the executable program
# target_LIBDIRS    : search path for dependent libraries
# target_LIBS       : dependent static libraries
# target_SHLIBS     : dependent shared libraries
# target_EXTLIBS    : dependent external libraries
# target_ARGS       : program arguments
#
#
# [1.7] Compile & Run Performance Test
#
# PERFTEST_TARGETS = target
#
# target_NAME       : executable program name
# target_SRCS       : source files to be compiled and linked into the executable program
# target_OBJS       : object files to be linked into the executable program
# target_LIBDIRS    : search path for dependent libraries
# target_LIBS       : dependent static libraries
# target_SHLIBS     : dependent shared libraries
# target_EXTLIBS    : dependent external libraries
# target_ARGS       : program arguments
#

#
# [2] Default
#
# .DEFAULT_GOAL  = build --> root.mk

#
# [3] Rule Expansion
#

#
# [3.1] Templates
#
define subdir_template
.PHONY: subdir_$(1)_$(2)
subdir_$(1)_$(2):
	@$$(MAKE) $(2) -C $(1)
subdirs: subdir_$(1)_$(2)
endef

# Set LD according to C or C++ using
ifneq ($(LD_USE_CPP),)
LD = $(LD_CXX)
else
LD = $(LD_CC)
endif

define msggen_template
$(addsuffix .mk,$(basename $(1))): $(1) $(GENMSG)
ifneq ($(SILENT_MODE),)
	$(ECHO) "GenMsgFrom $(WORK_DIR)/$$(notdir $$<)"
endif
	$(call exec,$(GENMSG)) $$<
	$(if $(GENERATED_HDR_DIR),$(MV) $$(addsuffix .h,$$(basename $$<)) $(GENERATED_HDR_DIR))
endef

define msglib_template
SHOBJ_TARGETS              += $(1)_msglib_shobj
$(1)_msglib_shobj_SRCS      = $(1).c
$(1)_msglib_shobj_INCLUDES  = $(if $(GENERATED_HDR_DIR),$(if $(filter $(GENERATED_HDR_DIR),$(INCLUDES)),,$(INC_OPT)$(GENERATED_HDR_DIR)))
$(1)_msglib_shobj_DEFINES   = ACP_CFG_DL_EXPORT
$(BUILD_DIR)/$(1).mdl: $(1)$(SHOBJ_SUF)
ifneq ($(SILENT_MODE),)
	$(ECHO) "LinkMdl $(VARIANT)/$(WORK_DIR)/$$(notdir $$@)"
endif
	$(Q) $(LD) $(SO_FLAGS) $(LD_OUT_OPT)$$@ $$^ $(OUTFILE)
ifneq ($(USE_MANIFEST),)
	mt -nologo -manifest $$@.manifest -outputresource:$$@;#2
endif
shlibs: $(BUILD_DIR)/$(1).mdl
endef

define obj_template
.PHONY: $(1)
$(1): $(2)
objs: $(1)
$(2): INCLUDES += $($(1)_INCLUDES)
$(2): DEFINES  += $($(1)_DEFINES)
$(2): CC_FLAGS += $($(1)_CC_FLAGS)
$(2:$(OBJ_SUF)=.d): INCLUDES += $($(1)_INCLUDES)
$(2:$(OBJ_SUF)=.d): DEFINES  += $($(1)_DEFINES)
$(2:$(OBJ_SUF)=.d): CC_FLAGS += $($(1)_CC_FLAGS)
$(addsuffix .p,$(basename $(notdir $(2)))): INCLUDES += $($(1)_INCLUDES)
$(addsuffix .p,$(basename $(notdir $(2)))): DEFINES  += $($(1)_DEFINES)
$(addsuffix .p,$(basename $(notdir $(2)))): CC_FLAGS += $($(1)_CC_FLAGS)
ALL_DEPS += $(2:$(OBJ_SUF)=.d)
endef

define shobj_template
.PHONY: $(1)
$(1): $(2)
shobjs: $(1)
$(2): INCLUDES += $($(1)_INCLUDES)
$(2): DEFINES  += $($(1)_DEFINES) ACP_CFG_PIC
$(2): CC_FLAGS += $($(1)_CC_FLAGS)
$(2:$(SHOBJ_SUF)=.d): INCLUDES += $($(1)_INCLUDES)
$(2:$(SHOBJ_SUF)=.d): DEFINES  += $($(1)_DEFINES)
$(2:$(SHOBJ_SUF)=.d): CC_FLAGS += $($(1)_CC_FLAGS)
$(addsuffix .p,$(basename $(notdir $(2)))): INCLUDES += $($(1)_INCLUDES)
$(addsuffix .p,$(basename $(notdir $(2)))): DEFINES  += $($(1)_DEFINES)
$(addsuffix .p,$(basename $(notdir $(2)))): CC_FLAGS += $($(1)_CC_FLAGS)
ALL_DEPS += $(2:$(SHOBJ_SUF)=.d)
endef

define lib_template
.PHONY: $(1)
$(1): $(2)
libs: $(1)
$(2): $($(1)_OBJS)
ifneq ($(SILENT_MODE),)
	$(ECHO) " AR $$@"
endif
	$(Q) $(AR) $(AR_FLAGS) $(AR_OUT_OPT)$$@ $$^$(OUTFILE)
endef

define shlib_template
.PHONY: $(1)
$(1): $(2)
shlibs: $(1)
$(2): $($(1)_OBJS) $($(1)_LIBDEF) $(patsubst %,$(SHLIB_PRE)%$(SHLIB_SUF),$($(1)_SHLIBS))
ifneq ($(SILENT_MODE),)
	$(ECHO) " SO $$@"
endif
	$(Q) $(LD) $(SO_FLAGS) $(LD_OUT_OPT)$$@ $$(if $(LIBDEF_OPT),$$(if $$(filter %.def,$$^),$(LIBDEF_OPT)$$(filter %.def,$$^))) $$(filter %$(SHOBJ_SUF),$$^) $$(addprefix $(LIBDIR_OPT),$$(LIBDIRS)) $$(patsubst %,$(LIB_OPT)%$(LIB_AFT),$$(SHLIBS) $$(EXTLIBS)) $(SO_LIBS) $(OUTFILE)
ifneq ($(USE_MANIFEST),)
	mt -nologo -manifest $$@.manifest -outputresource:$$@;#2
endif
$(2): LIBDIRS += $($(1)_LIBDIRS)
$(2): SHLIBS  += $($(1)_SHLIBS)
$(2): EXTLIBS += $($(1)_EXTLIBS)
endef

define exec_template
.PHONY: $(1)
$(1): $(2)
execs: $(1)
objs: $(patsubst %,$(BUILD_DIR)/%$(OBJ_SUF),$(basename $($(1)_SRCS)))
$(2): $(patsubst %,$(BUILD_DIR)/%$(OBJ_SUF),$(basename $($(1)_SRCS))) $($(1)_OBJS) $(patsubst %,$(LIB_PRE)%$(LIB_SUF),$($(1)_LIBS)) $(patsubst %,$(SHLIB_PRE)%$(SHLIB_SUF),$($(1)_SHLIBS))
ifneq ($(SILENT_MODE),)
	$(ECHO) "LinkExe $(VARIANT)/$(WORK_DIR)/$$(notdir $$@)"
endif
	$(Q) $(LD_TOOL) $(LD) $(LD_FLAGS) $(LD_OUT_OPT)$$@ $$(if $$(filter $$@,$$(ALL_MAPS)),$$(if $(MAP_OPT),$(MAP_OPT)$$(patsubst %$(EXEC_SUF),%.map,$$@))) $$(filter %$(OBJ_SUF),$$^) $$(filter %$(LIB_SUF),$$^) $$(addprefix $(LIBDIR_OPT),$$(LIBDIRS)) $$(patsubst %,$(LIB_OPT)%$(LIB_AFT),$$(SHLIBS) $$(EXTLIBS)) $(LD_LIBS) $(OUTFILE)
ifneq ($(USE_MANIFEST),)
	mt -nologo -manifest $$@.manifest -outputresource:$$@;#1
endif
	$$(if $$(filter $$@,$$(ALL_MAPS)),$(if $(NM),$(NM) $(NM_FLAGS) $$@ > $$(patsubst %$(EXEC_SUF),%.map,$$@)))
$(2): LIBDIRS += $($(1)_LIBDIRS)
$(2): SHLIBS  += $($(1)_SHLIBS)
$(2): EXTLIBS += $($(1)_EXTLIBS)
ALL_MAPS      += $(if $($(1)_GENMAP),$(2))
ALL_DEPS      += $(addprefix $(BUILD_DIR)/,$(addsuffix .d,$(basename $($(1)_SRCS))))
endef

define unittest_template
ifneq ($(DO_UNITTEST),no)
$(if $(filter $(2),$(ALL_EXECS)),,$(eval $(call exec_template,$(target),$(BUILD_DIR)/$($(target)_NAME)$(EXEC_SUF))))
$(BUILD_DIR)/$(1).unittest: $(2)
ifneq ($(TEST_SHLIB),)
	@$(ECHO) "Testing dynamically linked $(1)"
else
	@$(ECHO) "Testing $(1)"
endif
	-@$(call exec,$(UNIT_GUARDER)) $(TEST_TOOL) $(call exec,$(2)) $(call exec,$($(1)_ARGS)) && $(TOUCH) $$@ || $(ECHO) "        ==> FAILED in $(1)"
unittest_content: $(BUILD_DIR)/$(1).unittest
ALL_EXECS += $(2)
endif
endef

define perftest_template
ifneq ($(DO_UNITTEST),no)
$(if $(filter $(2),$(ALL_EXECS)),,$(eval $(call exec_template,$(target),$(BUILD_DIR)/$($(target)_NAME)$(EXEC_SUF))))
$(BUILD_DIR)/$(1).perftest: $(2)
	@$(ECHO) "Testing $(1)"
	-@$(call exec,$(UNIT_GUARDER)) $(call exec,$(2)) $(call exec,$($(1)_ARGS)) && $(TOUCH) $$@ || $(ECHO) "        ==> FAILED in $(1)"

perftest_content: $(BUILD_DIR)/$(1).perftest
ALL_EXECS += $(2)
endif
endef

#
# [3.2] Expand
#
$(foreach goal, $(if $(strip $(filter-out clean,$(MAKECMDGOALS))),$(filter-out clean,$(MAKECMDGOALS)),$(.DEFAULT_GOAL)), $(foreach subdir, $(SUBDIRS), $(eval $(call subdir_template,$(subdir),$(goal)))))

$(foreach target, $(OBJ_TARGETS) $(SHOBJ_TARGETS), $(foreach msg, $($(target)_MSGS), $(if $(findstring $(msg),$(ALL_MSGS)),,$(eval ALL_MSGS += $(msg)))))

$(foreach msg, $(ALL_MSGS), $(eval $(call msggen_template,$(msg))))

ifneq ($(ALL_MSGS),)
-include $(addsuffix .mk,$(basename $(ALL_MSGS)))
endif

$(foreach target, $(OBJ_TARGETS), $(eval $(call obj_template,$(target),$(patsubst %,$(BUILD_DIR)/%$(OBJ_SUF),$(basename $($(target)_SRCS)) $(basename $($(target)_MSGS))))))

$(foreach target, $(SHOBJ_TARGETS), $(eval $(call shobj_template,$(target),$(patsubst %,$(BUILD_DIR)/%$(SHOBJ_SUF),$(basename $($(target)_SRCS)) $(basename $($(target)_MSGS))))))

$(foreach target, $(LIB_TARGETS), $(eval $(call lib_template,$(target),$(LIBS_DIR)/$(LIB_PRE)$($(target)_NAME)$(LIB_SUF))))

$(foreach target, $(SHLIB_TARGETS), $(eval $(call shlib_template,$(target),$(LIBS_DIR)/$(LIB_PRE)$($(target)_NAME)$(SHLIB_SUF))))

$(foreach target, $(EXEC_TARGETS), $(eval $(call exec_template,$(target),$(BINS_DIR)/$($(target)_NAME)$(EXEC_SUF))))

ifneq ($(DO_UNITTEST),no)
$(foreach target, $(UNITTEST_TARGETS), $(eval $(call unittest_template,$(target),$(BUILD_DIR)/$($(target)_NAME)$(EXEC_SUF))))

$(foreach target, $(PERFTEST_TARGETS), $(eval $(call perftest_template,$(target),$(BUILD_DIR)/$($(target)_NAME)$(EXEC_SUF))))
endif

#
# [3.3] Search path for prerequisites
#
vpath %             $(BUILD_DIR)
vpath %$(OBJ_SUF)   $(OBJDIRS)
vpath %$(SHOBJ_SUF) $(OBJDIRS)
vpath %$(LIB_SUF)   $(LIBDIRS)
vpath %$(SHLIB_SUF) $(LIBDIRS)

#
# [4] Implicit rules
#
ifneq ($(DEP_FLAGS),)

$(BUILD_DIR)/%.d: %.gs
ifneq ($(SILENT_MODE),)
	@$(ECHO) "Building dependency information of $< for $(VARIANT)"
endif
	@$(TOUCH) $@

$(BUILD_DIR)/%.d: %.s
ifneq ($(SILENT_MODE),)
	@$(ECHO) "Building dependency information of $< for $(VARIANT)"
endif
	@$(TOUCH) $@

$(BUILD_DIR)/%.d: %.c
ifneq ($(SILENT_MODE),)
	@$(ECHO) "Building dependency information of $< for $(VARIANT)"
endif
	@-$(DEP_CMD_CC)
	@-$(DEP_POSTPROCS)

$(BUILD_DIR)/%.d: %.cpp
ifneq ($(SILENT_MODE),)
	@$(ECHO) "Building dependency information of $< for $(VARIANT)"
endif
	@-$(DEP_CMD_CXX)
	@-$(DEP_POSTPROCS)

endif

ifneq ($(COV_SUF),)

%$(COV_SUF): %
	$(COV) $(COV_FLAGS) $(COV_DIR_OPT)$(BUILD_DIR) $<

endif

%.p: %.c
	$(Q) $(CC) $(PREP_FLAGS) $(CC_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $< > $@ $(OUTFILE)

%.p: %.cpp
	$(Q) $(CXX) $(PREP_FLAGS) $(CXX_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $< > $@ $(OUTFILE)

%.c: %.ly
ifneq ($(SILENT_MODE),)
	$(ECHO) "GenParser $@"
endif
	$(ALTI_HOME)/bin/alemon -t=$(ALEMON_DIR)/lempar.c $<
	$(if $(GENERATED_HDR_DIR),$(MV) $(patsubst %.c,%.h,$@) $(GENERATED_HDR_DIR))

%.c: %.re
ifneq ($(SILENT_MODE),)
	$(ECHO) "GenLexer $@"
endif
	$(RE2C) -s -o $@ $<

$(BUILD_DIR)/%$(OBJ_SUF): %.c
ifneq ($(SILENT_MODE),)
	$(ECHO) " CC $@"
endif
	$(Q) $(CC_TOOL) $(CC) $(COMP_FLAGS) $(CC_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(OBJ_SUF): %.gs
ifneq ($(SILENT_MODE),)
	$(ECHO) "GAS $@"
endif
	$(Q) $(CC_TOOL) $(GAS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(OBJ_SUF): %.s
ifneq ($(SILENT_MODE),)
	$(ECHO) " AS $@"
endif
	$(Q) $(CC_TOOL) $(AS) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(OBJ_SUF): %.cpp
ifneq ($(SILENT_MODE),)
	$(ECHO) " CC $@"
endif
	$(Q) $(CXX_TOOL) $(CXX) $(COMP_FLAGS) $(CXX_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

ifneq ($(OBJ_SUF),$(SHOBJ_SUF))

$(BUILD_DIR)/%$(SHOBJ_SUF): %.c
ifneq ($(SILENT_MODE),)
	$(ECHO) " CC $@"
endif
	$(Q) $(CC_TOOL) $(CC) $(COMP_FLAGS) $(CC_FLAGS) $(PIC_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(SHOBJ_SUF): %.gs
ifneq ($(SILENT_MODE),)
	$(ECHO) "GAS $@"
endif
	$(Q) $(CC_TOOL) $(GAS) $(PIC_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(SHOBJ_SUF): %.s
ifneq ($(SILENT_MODE),)
	$(ECHO) " AS $@"
endif
	$(Q) $(CC_TOOL) $(AS) $(CC_OUT_OPT)$@ $< $(OUTFILE)

$(BUILD_DIR)/%$(SHOBJ_SUF): %.cpp
ifneq ($(SILENT_MODE),)
	$(ECHO) " CC $@"
endif
	$(Q) $(CXX_TOOL) $(CXX) $(COMP_FLAGS) $(CXX_FLAGS) $(PIC_FLAGS) $(addprefix $(DEF_OPT),$(DEFINES)) $(INCLUDES) $(CC_OUT_OPT)$@ $< $(OUTFILE)

endif

#
# [5] Rules
#
.PHONY: clean all all_content perf subdirs compile objs shobjs libs shlibs execs unittest unittest_content perftest perftest_content deploy_content pre_all post_all pre_compile post_compile pre_unittest post_unittest pre_perftest post_perftest pre_deploy post_deploy
ifneq ($(GENERATED_SRCS),)
.SECONDARY: $(GENERATED_SRCS)
endif

#
# [5.1] Public rules
#
dist: all

all: subdirs pre_all all_content post_all

build: all

perf: all

deploy: subdirs #all

package: deploy

buildclean:
ifneq ($(CONFIG_MK_INCLUDED),)
ifneq ($(SILENT_MODE),)
	$(ECHO) "Cleaning $(VARIANT)/$(WORK_DIR)"
endif
	-$(RMDIR) $(BUILD_DIR)
ifneq ($(filter-out clean,$(MAKECMDGOALS)),)
	@$(MKDIR) $(BUILD_DIR)
endif
endif

clean: buildclean

all_content: compile unittest

ifneq ($(filter perf,$(MAKECMDGOALS)),)
all_content: perftest
endif
ifneq ($(filter deploy,$(MAKECMDGOALS)),)
all_content: deployproduct
endif

#
# [5.2] Private rules
#
compile: pre_compile objs shobjs libs shlibs execs post_compile

unittest: unittest_begin pre_unittest unittest_content post_unittest unittest_end

perftest: perftest_begin pre_perftest perftest_content post_perftest perftest_end

deployproduct: pre_deploy deploy_content post_deploy

unittest_begin:
ifneq ($(UNITTEST_TARGETS),)
	@$(ECHO) "Unit Test Begin in $(WORK_DIR)"
endif

unittest_end:
ifneq ($(UNITTEST_TARGETS),)
	@$(ECHO) "Unit Test End in $(WORK_DIR)"
endif

perftest_begin:
ifneq ($(PERFTEST_TARGETS),)
	@$(ECHO) "Performance Test Begin in $(WORK_DIR)"
endif

perftest_end:
ifneq ($(PERFTEST_TARGETS),)
	@$(ECHO) "Performance Test End in $(WORK_DIR)"
endif

#
# [6] Load automatically generated prerequisites
#
ifneq ($(DEP_FLAGS),)
ifneq ($(strip $(MAKECMDGOALS)),clean)
ifneq ($(ALL_DEPS),)
-include $(sort $(ALL_DEPS))
endif
endif
endif
