/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvBig5.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvBig5.h>
#include <aciConvAscii.h>

static const acp_uint16_t big5_2uni_pagea1[ /*6121*/ ] = {
  /* 0xa1 */
  0x340d, 0xfb01, 0x340c, 0x340f, 0xfb03, 0x242f, 0xfb16, 0xfb17,
  0xfb12, 0xfb0c, 0xfa3d, 0x242b, 0x2428, 0xfa5d, 0xfb69, 0xfa5f,
  0x04ba, 0xfa59, 0xfa58, 0xfa5b, 0xfa5a, 0xfb51, 0x241e, 0xfa3c,
  0x2419, 0xfa3e, 0xfbf0, 0xfa39, 0xfa42, 0xfb05, 0xfb04, 0xfa38,
  0xfa3b, 0xfb56, 0xfb50, 0xfa3a, 0xfa35, 0x3419, 0x3418, 0xfa34,
  0xfa37, 0x341d, 0x341c, 0xfa36, 0xfa31, 0x3407, 0x3406, 0xfa30,
  0xfa33, 0x3405, 0x3404, 0xfa32, 0xfa4d, 0x3401, 0x3400, 0xfa4c,
  0xfa4f, 0x3403, 0x3402, 0xfa4e, 0xfa49, 0xfa54, 0xfa57, 0xfa56,
  0xfa51, 0xfa50, 0xfa53, 0x2415, 0x2414, 0x2411, 0x2410, 0x3410,
  0x3413, 0x2438, 0x243f, 0xfb0e, 0xfb0b, 0xfb07, 0x2436, 0x04aa,
  0x340e, 0x21c6, 0x21c2, 0x21be, 0x21bf, 0x21c3, 0x220b, 0x2208,
  0x21ca, 0x21cb, 0x21ac, 0x21ad, 0x21b0, 0x21b1, 0x36ae, 0x2508,
  0x2433, 0xfbf0, 0xfb32, 0xfbf0, 0xfa44, 0xfa47, 0xfa40, 0xfa43,
  0xfa46, 0xfa41, 0xfa52, 0xfa6d, 0xfa6c, 0xfb06, 0xfb00, 0x04da,
  0x04fa, 0x04bc, 0x2617, 0xfb11, 0xfb13, 0xfb10, 0x266b, 0x266a,
  0x266d, 0x2613, 0x265f, 0x266c, 0xfa6f, 0xfa6e, 0xfa69, 0xfa68,
  0xfa6b, 0x2631, 0x2624, 0x2627, 0x26a8, 0x262d, 0x2612, 0x26b2,
  0x37df, 0x37dc, 0x2626, 0x2623, 0x2638, 0x2639, 0x224d, 0x224f,
  0x224c, 0x2204, 0x259c, 0x259e, 0x259d, 0x259f, 0x259b, 0x259a,
  0x2594, 0x2595, 0x2628, 0x262e, 0xfbf0,
  /* 0xa2 */
  0xfbf0, 0xfb02, 0xfb31, 0xfb09, 0x04a8, 0x341f, 0x04af, 0x04ae,
  0xfb08, 0xfb2d, 0x250e, 0x2504, 0xfa64, 0xfa67, 0xfa66, 0x37d8,
  0x3791, 0x3790, 0x3793, 0x37c3, 0x37ac, 0x3783, 0x3782, 0x37c9,
  0x04bd, 0x5554, 0x5556, 0x5553, 0x5550, 0x556c, 0x556e, 0x51ea,
  0x70e4, 0x78c3, 0x218c, 0x218f, 0x218e, 0x2189, 0x2188, 0x218b,
  0x218a, 0x2185, 0x2182, 0x2183, 0x2180, 0x2181, 0x2186, 0x2187,
  0x2184, 0x2131, 0x2139, 0x2121, 0x2129, 0x2111, 0x2199, 0x210d,
  0x210f, 0x2198, 0x2101, 0x211d, 0x2119, 0x2115, 0x2160, 0x2163,
  0x217d, 0x2162, 0x215d, 0x2153, 0x2167, 0x216c, 0x21ef, 0x21ee,
  0x21e8, 0x21e9, 0x217c, 0x217f, 0x217e, 0xfb1d, 0xfb1c, 0xfb1f,
  0xfb1e, 0xfb19, 0xfb18, 0xfb1b, 0xfb1a, 0xfb15, 0xfb14, 0x256d,
  0x256c, 0x256f, 0x256e, 0x2569, 0x2568, 0x256b, 0x256a, 0x2565,
  0x2564, 0x342c, 0x342f, 0x342e, 0x3429, 0x3428, 0x342b, 0x342a,
  0x3425, 0x3424, 0xfbf0, 0x5749, 0xfbf0, 0xfb2c, 0xfb2f, 0xfb2e,
  0xfb29, 0xfb28, 0xfb2b, 0xfb2a, 0xfb25, 0xfb24, 0xfb27, 0xfb26,
  0xfb21, 0xfb20, 0xfb23, 0xfb22, 0xfb3d, 0xfb3c, 0xfb3f, 0xfb3e,
  0xfb39, 0xfb38, 0xfb3b, 0xfb3a, 0xfb35, 0xfb34, 0xfb37, 0xfb4c,
  0xfb4f, 0xfb4e, 0xfb49, 0xfb48, 0xfb4b, 0xfb4a, 0xfb45, 0xfb44,
  0xfb47, 0xfb46, 0xfb41, 0xfb40, 0xfb43, 0xfb42, 0xfb5d, 0xfb5c,
  0xfb5f, 0xfb5e, 0xfb59, 0xfb58, 0xfb5b,
  /* 0xa3 */
  0xfb5a, 0xfb55, 0xfb54, 0xfb57, 0x079c, 0x079f, 0x079e, 0x0799,
  0x0798, 0x079b, 0x079a, 0x0795, 0x0794, 0x0797, 0x0796, 0x0791,
  0x0790, 0x0793, 0x0792, 0x07ad, 0x07ac, 0x07ae, 0x07a9, 0x07a8,
  0x07ab, 0x07aa, 0x07a5, 0x07a4, 0x07bc, 0x07bf, 0x07be, 0x07b9,
  0x07b8, 0x07bb, 0x07ba, 0x07b5, 0x07b4, 0x07b7, 0x07b6, 0x07b1,
  0x07b0, 0x07b3, 0x07b2, 0x07cd, 0x07cc, 0x07ce, 0x07c9, 0x07c8,
  0x07cb, 0x07ca, 0x07c5, 0x07c4, 0x3508, 0x350b, 0x350a, 0x3505,
  0x3504, 0x3507, 0x3506, 0x3501, 0x3500, 0x3503, 0x3502, 0x351d,
  0x351c, 0x351f, 0x351e, 0x3519, 0x3518, 0x351b, 0x351a, 0x3515,
  0x3514, 0x3517, 0x3516, 0x3511, 0x3510, 0x3513, 0x3512, 0x352d,
  0x352c, 0x352f, 0x352e, 0x3529, 0x3528, 0x352b, 0x352a, 0x3525,
  0x3524, 0x06d4, 0x06c4, 0x06c7, 0x06ca, 0x06c6, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0xa4 */
  0x4a0d, 0x4a54, 0x4a0c, 0x4a0e, 0x4a4e, 0x4a50, 0x4a8b, 0x4a81,
  0x4ab7, 0x5532, 0x5568, 0x5566, 0x55ed, 0x560d, 0x560c, 0x5696,
  0x5718, 0x574c, 0x5751, 0x57c5, 0x4a04, 0x4a06, 0x4a05, 0x4a07,
  0x4a26, 0x4a35, 0x55ec, 0x4a48, 0x4a45, 0x4a52, 0x4a53, 0x4a83,
  0x4aac, 0x554d, 0x560e, 0x56f7, 0x574e, 0x57c4, 0x57ee, 0x5312,
  0x5ce6, 0x5d18, 0x5d2a, 0x5d7e, 0x5f5d, 0x5f5c, 0x5f5e, 0x5ff5,
  0x5802, 0x582f, 0x5835, 0x587c, 0x59d0, 0x59e8, 0x59fc, 0x59ff,
  0x59fe, 0x59f3, 0x5a7f, 0x5af3, 0x5b06, 0x5b1e, 0x6640, 0x4a1c,
  0x4a1d, 0x4a00, 0x4a20, 0x4a3d, 0x4a34, 0x4a46, 0x5834, 0x4a85,
  0x4a9c, 0x4a98, 0x4a9f, 0x4a99, 0x4aaf, 0x4acc, 0x4acd, 0x4ace,
  0x4acb, 0x4aca, 0x4ac0, 0x4ac7, 0x4ac6, 0x4ac9, 0x554e, 0x554c,
  0x556a, 0x5560, 0x5563, 0x5561, 0x559a, 0x55fb, 0x560b, 0x560a,
  0x5605, 0x56f6, 0x56f3, 0x56f2, 0x571b, 0x5734, 0x5745, 0x574a,
  0x5748, 0x5753, 0x5789, 0x57c6, 0x57c7, 0x57c0, 0x5ce1, 0x5d24,
  0x5d26, 0x5d27, 0x5d20, 0x5f59, 0x581c, 0x5829, 0x5837, 0x5862,
  0x59f9, 0x5a76, 0x5af2, 0x5b19, 0x5b18, 0x5bce, 0x6605, 0x663b,
  0x6646, 0x6643, 0x6122, 0x618a, 0x619a, 0x61a9, 0x61b4, 0x61e8,
  0x62fd, 0x6305, 0x6325, 0x6f2d, 0x6f6f, 0x6f74, 0x6fc6, 0x6fd9,
  0x6fd6, 0x6802, 0x6839, 0x7466, 0x7627, 0x763b, 0x7636, 0x764a,
  0x7654, 0x7656, 0x76a1, 0x7786, 0x4a14,
  /* 0xa5 */
  0x4a1b, 0x4a18, 0x4a19, 0x4a15, 0x4a36, 0x4a40, 0x4a42, 0x4a43,
  0x4ae8, 0x4ad5, 0x4ad9, 0x4ad8, 0x4adb, 0x4ada, 0x4aee, 0x4ae9,
  0x4ad4, 0x4ad3, 0x5548, 0x5549, 0x5584, 0x5587, 0x55a1, 0x55f4,
  0x55f7, 0x55f5, 0x5607, 0x56ad, 0x5692, 0x5708, 0x570b, 0x571a,
  0x5710, 0x4ad2, 0x5747, 0x5744, 0x576c, 0x576d, 0x5762, 0x5763,
  0x57b6, 0x57e2, 0x57e9, 0x57fe, 0x57e1, 0x57e3, 0x57e4, 0x57e5,
  0x57f1, 0x57f5, 0x57f8, 0x57e6, 0x57eb, 0x57e7, 0x57ff, 0x57fc,
  0x57fd, 0x57e8, 0x57e0, 0x57f6, 0x52d6, 0x52d7, 0x5d1b, 0x5d23,
  0x5d3c, 0x5d79, 0x5d7b, 0x5f58, 0x5f8e, 0x5831, 0x59e5, 0x59ea,
  0x59eb, 0x5a0f, 0x5a0e, 0x5a7e, 0x5a71, 0x5b0c, 0x5b15, 0x5b1a,
  0x5bc8, 0x6607, 0x665e, 0x6659, 0x665f, 0x665c, 0x61a8, 0x61eb,
  0x6323, 0x6321, 0x6327, 0x6326, 0x6320, 0x6f6e, 0x6fc0, 0x681c,
  0x681d, 0x6835, 0x684c, 0x684d, 0x6833, 0x76a2, 0x7789, 0x7784,
  0x70d1, 0x70eb, 0x7115, 0x7112, 0x7125, 0x7124, 0x713d, 0x713c,
  0x713f, 0x713e, 0x7186, 0x7270, 0x72a3, 0x72b2, 0x72e3, 0x73d6,
  0x73ef, 0x73fe, 0x7d37, 0x7db3, 0x7e79, 0x7ec6, 0x4a13, 0x4a12,
  0x4a5f, 0x4a5e, 0x4a64, 0x4a94, 0x4aa9, 0x4aab, 0x4aa8, 0x4af2,
  0x4b04, 0x4b14, 0x4b07, 0x4b18, 0x4b00, 0x4b1d, 0x4b1c, 0x4b02,
  0x4aff, 0x4afb, 0x4af6, 0x4afd, 0x4afe, 0x4af0, 0x4b0c, 0x4b06,
  0x5544, 0x554a, 0x554b, 0x5545, 0x5565,
  /* 0xa6 */
  0x557c, 0x5580, 0x55bd, 0x561a, 0x561c, 0x561f, 0x5603, 0x561b,
  0x56ae, 0x5705, 0x572c, 0x572d, 0x577d, 0x577c, 0x5004, 0x5002,
  0x5001, 0x5007, 0x501d, 0x500c, 0x5006, 0x5009, 0x501c, 0x5000,
  0x5005, 0x500e, 0x5003, 0x500b, 0x501f, 0x52ed, 0x52d3, 0x52d0,
  0x533e, 0x533d, 0x5325, 0x5320, 0x5321, 0x5322, 0x5324, 0x5d14,
  0x5d17, 0x5d3a, 0x5d35, 0x5d89, 0x5d75, 0x5d8e, 0x5d70, 0x5d74,
  0x5d8f, 0x5d8c, 0x5f5a, 0x5f55, 0x5f8a, 0x5f85, 0x5f88, 0x5f84,
  0x5ff7, 0x581b, 0x5874, 0x59d3, 0x5a0b, 0x5a7b, 0x5a79, 0x5b02,
  0x5b16, 0x5bd4, 0x5bdb, 0x6603, 0x6601, 0x6600, 0x661d, 0x666e,
  0x6656, 0x6655, 0x613b, 0x61e4, 0x61e5, 0x61e1, 0x61e0, 0x62ff,
  0x62fe, 0x6304, 0x6330, 0x6339, 0x633c, 0x6338, 0x6f2c, 0x6f69,
  0x6f76, 0x681b, 0x6850, 0x685a, 0x6854, 0x6852, 0x686d, 0x685d,
  0x6858, 0x686c, 0x6856, 0x6840, 0x6843, 0x747d, 0x7652, 0x7650,
  0x7273, 0x7ef4, 0x787e, 0x78f5, 0x7b3b, 0x7b87, 0x7bb0, 0x840c,
  0x840e, 0x8401, 0x841f, 0x843e, 0x8472, 0x8484, 0x8486, 0x8481,
  0x85ee, 0x85e7, 0x85fe, 0x85f1, 0x8601, 0x8616, 0x8612, 0x8663,
  0x867f, 0x8673, 0x8266, 0x8c4d, 0x8c41, 0x8c6e, 0x8d72, 0x922c,
  0x4a3f, 0x4aa5, 0x4b40, 0x4b42, 0x4b4a, 0x4b5a, 0x4b53, 0x4b39,
  0x4b56, 0x4b58, 0x4b3d, 0x4b5d, 0x4b5c, 0x4b30, 0x4b37, 0x4b35,
  0x4b4e, 0x4b59, 0x4b31, 0x4b4b, 0x4b6e,
  /* 0xa7 */
  0x4b51, 0x4b6d, 0x4b22, 0x4b43, 0x4b3b, 0x4b54, 0x4b50, 0x4b45,
  0x4b57, 0x5541, 0x5546, 0x5540, 0x5578, 0x55bb, 0x55ba, 0x5628,
  0x5629, 0x5624, 0x5627, 0x5625, 0x56a6, 0x56a4, 0x56a7, 0x56a1,
  0x572e, 0x577e, 0x5778, 0x5010, 0x5020, 0x5013, 0x5033, 0x502b,
  0x5043, 0x502a, 0x504b, 0x504e, 0x503e, 0x5045, 0x504f, 0x5016,
  0x5024, 0x5047, 0x5034, 0x5036, 0x5035, 0x5023, 0x5038, 0x503b,
  0x502d, 0x5031, 0x504d, 0x503c, 0x5026, 0x5012, 0x5021, 0x52e7,
  0x52fd, 0x52e9, 0x52e6, 0x5347, 0x535c, 0x534d, 0x5340, 0x534a,
  0x5343, 0x5333, 0x535d, 0x5342, 0x5336, 0x5ce2, 0x5d33, 0x5d90,
  0x5d9f, 0x5da5, 0x5d93, 0x5dae, 0x5d94, 0x5d9b, 0x5d80, 0x5da9,
  0x5d9e, 0x5d87, 0x5da8, 0x5f50, 0x5f51, 0x5f57, 0x5f56, 0x5f81,
  0x5f86, 0x5f82, 0x5821, 0x584d, 0x584c, 0x5832, 0x5833, 0x589d,
  0x589c, 0x5899, 0x5881, 0x59e6, 0x5a01, 0x5a82, 0x5a8a, 0x5a87,
  0x5afa, 0x5b09, 0x5b12, 0x5b69, 0x5b6f, 0x5b7a, 0x5b74, 0x5bd5,
  0x5bc1, 0x5bda, 0x5bc0, 0x5bfc, 0x5be6, 0x5bf5, 0x5be7, 0x661f,
  0x661c, 0x6689, 0x669a, 0x669b, 0x668d, 0x667b, 0x6684, 0x6660,
  0x6687, 0x6671, 0x6673, 0x6674, 0x667e, 0x669f, 0x6662, 0x6695,
  0x6663, 0x6698, 0x669e, 0x669c, 0x668b, 0x6134, 0x6136, 0x6135,
  0x61fc, 0x62f9, 0x6352, 0x6343, 0x6342, 0x635d, 0x635c, 0x6351,
  0x635b, 0x6353, 0x6344, 0x634b, 0x636d,
  /* 0xa8 */
  0x635e, 0x635a, 0x6f68, 0x6fc2, 0x684f, 0x6853, 0x6894, 0x688c,
  0x6885, 0x6884, 0x6888, 0x6896, 0x6867, 0x6877, 0x689d, 0x687d,
  0x6881, 0x6865, 0x689b, 0x689f, 0x6870, 0x688e, 0x687f, 0x6873,
  0x6879, 0x688b, 0x687b, 0x6880, 0x6899, 0x6895, 0x688f, 0x747b,
  0x7471, 0x7470, 0x7475, 0x766f, 0x766c, 0x766d, 0x76c9, 0x76cf,
  0x779b, 0x7121, 0x7126, 0x713a, 0x7135, 0x728f, 0x72e2, 0x73ee,
  0x7dcc, 0x7dcd, 0x7db2, 0x7e7b, 0x78f6, 0x7b58, 0x849b, 0x849e,
  0x8490, 0x8495, 0x8496, 0x8497, 0x84bf, 0x8662, 0x869f, 0x8686,
  0x8680, 0x8d86, 0x8ddf, 0x8e0d, 0x883a, 0x884b, 0x8858, 0x8890,
  0x8969, 0x897d, 0x89be, 0x8aa6, 0x8ac7, 0x8b96, 0x8bbd, 0x8bcf,
  0x8bcb, 0x8bc8, 0x8bc9, 0x59ec, 0x949c, 0x94af, 0x94a7, 0x94ab,
  0x94ae, 0x9544, 0x95cb, 0x95c1, 0x923f, 0x9223, 0x923c, 0x9227,
  0x9221, 0x4a2b, 0x4a5b, 0x4a7e, 0x4a86, 0x4a96, 0x4a93, 0x4aa6,
  0x4aa1, 0x4b62, 0x4b90, 0x4b80, 0x4b7e, 0x4b72, 0x4b61, 0x4b96,
  0x4b86, 0x4b8b, 0x4b8e, 0x4b7d, 0x4b78, 0x4b85, 0x4b64, 0x4b76,
  0x4b9b, 0x4b73, 0x4b82, 0x4b9c, 0x4b77, 0x5559, 0x555f, 0x5558,
  0x5564, 0x557a, 0x557b, 0x5575, 0x55b0, 0x55f0, 0x5636, 0x5635,
  0x563a, 0x5637, 0x563d, 0x5623, 0x563b, 0x564c, 0x56b3, 0x56b6,
  0x575f, 0x5759, 0x575e, 0x575c, 0x576b, 0x577a, 0x5775, 0x5774,
  0x57db, 0x57d9, 0x57da, 0x507e, 0x5078,
  /* 0xa9 */
  0x509b, 0x5075, 0x5098, 0x508d, 0x5076, 0x507a, 0x5089, 0x509f,
  0x508b, 0x5071, 0x509d, 0x507c, 0x507b, 0x5081, 0x5097, 0x506f,
  0x5065, 0x5086, 0x5070, 0x5083, 0x52f7, 0x538e, 0x537a, 0x5367,
  0x5364, 0x536c, 0x536b, 0x5369, 0x5371, 0x5d11, 0x5d44, 0x5d4a,
  0x5d45, 0x5d49, 0x5d59, 0x5db3, 0x5db6, 0x5dd9, 0x5db4, 0x5da3,
  0x5ddc, 0x5dcb, 0x5ddd, 0x5dc0, 0x5dc6, 0x5dde, 0x5dc7, 0x5da2,
  0x5dbe, 0x5ddf, 0x5dc8, 0x5f52, 0x5f69, 0x5f6e, 0x5f9a, 0x5f97,
  0x5f95, 0x5f91, 0x5f94, 0x5f96, 0x5817, 0x5845, 0x5848, 0x584b,
  0x58ba, 0x58ac, 0x58b5, 0x58a4, 0x58a6, 0x58bc, 0x58be, 0x5a15,
  0x5a17, 0x5a1b, 0x5a18, 0x5a16, 0x5a1c, 0x5a75, 0x5a97, 0x5a9a,
  0x5a91, 0x5a98, 0x5a9b, 0x5afb, 0x5b2b, 0x5b2a, 0x5b24, 0x5b8d,
  0x5b8c, 0x5b72, 0x5b71, 0x5bd0, 0x5bed, 0x5bf0, 0x5bf8, 0x5bf2,
  0x6402, 0x6419, 0x6422, 0x6438, 0x641b, 0x6427, 0x6418, 0x642c,
  0x642a, 0x6424, 0x6426, 0x6416, 0x661b, 0x6618, 0x6632, 0x6633,
  0x664d, 0x6672, 0x66c4, 0x66c1, 0x66c9, 0x66b2, 0x66cf, 0x66b4,
  0x66df, 0x66d6, 0x66a6, 0x66de, 0x66d9, 0x66c6, 0x66c5, 0x66a5,
  0x66b0, 0x66b1, 0x66dd, 0x66d4, 0x66ca, 0x66c0, 0x66b8, 0x66d7,
  0x66bc, 0x66d5, 0x66db, 0x66da, 0x66cb, 0x66a1, 0x66c3, 0x6133,
  0x61aa, 0x61b1, 0x61f7, 0x6219, 0x621e, 0x6201, 0x620b, 0x620f,
  0x6203, 0x620d, 0x6202, 0x6218, 0x6207,
  /* 0xaa */
  0x620a, 0x6300, 0x6306, 0x6360, 0x6386, 0x6398, 0x637c, 0x6391,
  0x637e, 0x637a, 0x638a, 0x6390, 0x639a, 0x6362, 0x637d, 0x6372,
  0x6384, 0x6373, 0x639d, 0x6378, 0x6397, 0x639e, 0x6371, 0x6367,
  0x637f, 0x6f2e, 0x6f6b, 0x6f6a, 0x6f72, 0x681e, 0x6816, 0x68ee,
  0x68e5, 0x68fe, 0x68bc, 0x68c1, 0x68e8, 0x68be, 0x68b0, 0x68b3,
  0x68b1, 0x68ef, 0x68a6, 0x68d8, 0x68de, 0x68b5, 0x68c9, 0x68b4,
  0x68cc, 0x68a3, 0x68da, 0x68c8, 0x68fc, 0x68b2, 0x68b6, 0x68ec,
  0x68d6, 0x68c7, 0x68a1, 0x68e2, 0x68d1, 0x68db, 0x68ed, 0x7498,
  0x7483, 0x749f, 0x7487, 0x7494, 0x7621, 0x7620, 0x7635, 0x7645,
  0x766a, 0x7664, 0x76cd, 0x76c3, 0x76d4, 0x76da, 0x76dd, 0x77a4,
  0x77a5, 0x7792, 0x77a6, 0x77a8, 0x7130, 0x7190, 0x7194, 0x7197,
  0x7289, 0x72cf, 0x72ff, 0x72f9, 0x73e8, 0x73f0, 0x7d33, 0x7d4d,
  0x7d4c, 0x7dc4, 0x7dc5, 0x7e77, 0x7e74, 0x7ef7, 0x78f3, 0x7b59,
  0x7b81, 0x7b86, 0x8408, 0x84b7, 0x84a8, 0x84af, 0x84bc, 0x84ac,
  0x84a6, 0x84a4, 0x84b9, 0x84a7, 0x84a2, 0x85e8, 0x85f3, 0x8600,
  0x86be, 0x8690, 0x8694, 0x86a0, 0x86b0, 0x8692, 0x86b4, 0x86bc,
  0x86a1, 0x86a8, 0x86a2, 0x86b5, 0x86ae, 0x86bd, 0x86b3, 0x86ba,
  0x8243, 0x827c, 0x5610, 0x8c65, 0x8ac6, 0x8bc3, 0x8bd9, 0x8bdc,
  0x94b8, 0x94b5, 0x94bc, 0x94bb, 0x95ca, 0x95dc, 0x917a, 0x918d,
  0x9211, 0x924d, 0x9232, 0x9236, 0x9249,
  /* 0xab */
  0x924f, 0x92b4, 0x92e5, 0x935f, 0x9353, 0x4a92, 0x4aa0, 0x4aa3,
  0x4bec, 0x4bb8, 0x4ba2, 0x4bb2, 0x4bed, 0x4bdc, 0x4bc2, 0x4bd0,
  0x4bce, 0x4bbb, 0x4bd5, 0x4bd2, 0x4bc7, 0x4bda, 0x4ba3, 0x4bdd,
  0x4bc9, 0x4bcf, 0x4bd7, 0x4bc3, 0x4bd3, 0x4bba, 0x555a, 0x559f,
  0x559c, 0x55ad, 0x5643, 0x564e, 0x5647, 0x5640, 0x5641, 0x5646,
  0x564a, 0x56ca, 0x56c4, 0x56ce, 0x56cc, 0x5700, 0x575a, 0x5776,
  0x5797, 0x57d6, 0x50a1, 0x50cd, 0x50a5, 0x50c3, 0x50c4, 0x50b5,
  0x50ab, 0x50be, 0x50ca, 0x50cf, 0x50b0, 0x50a7, 0x50cc, 0x50c9,
  0x50c5, 0x50a2, 0x50a6, 0x50bc, 0x50b6, 0x50a4, 0x50aa, 0x50b2,
  0x52f2, 0x538f, 0x5386, 0x53ad, 0x53ae, 0x53af, 0x53c3, 0x53a3,
  0x539e, 0x5d58, 0x5d5c, 0x5d42, 0x5d43, 0x5d5d, 0x5dd1, 0x5dd5,
  0x5df2, 0x5dee, 0x5de5, 0x5e0e, 0x5de8, 0x5de7, 0x5dd7, 0x5deb,
  0x5e0c, 0x5df6, 0x5f64, 0x5fae, 0x5fab, 0x5fa9, 0x5faf, 0x5fa8,
  0x580c, 0x5843, 0x5842, 0x5840, 0x5846, 0x58d4, 0x58df, 0x59fa,
  0x5a10, 0x5a28, 0x5a12, 0x5a70, 0x5aad, 0x5aab, 0x5af7, 0x5b05,
  0x5b20, 0x5b68, 0x5b85, 0x5b88, 0x5b87, 0x5b86, 0x5b8a, 0x5b81,
  0x5b84, 0x641f, 0x6410, 0x642d, 0x6428, 0x6403, 0x6425, 0x6440,
  0x647d, 0x6465, 0x646f, 0x644b, 0x644e, 0x6461, 0x6466, 0x6467,
  0x6469, 0x664c, 0x66d1, 0x671b, 0x6704, 0x66f1, 0x66e0, 0x670c,
  0x66e3, 0x66f0, 0x670a, 0x66fc, 0x66fa,
  /* 0xac */
  0x66e2, 0x66e1, 0x66f3, 0x66f9, 0x671c, 0x670f, 0x6132, 0x6148,
  0x61a6, 0x61b0, 0x61ef, 0x6228, 0x6220, 0x622d, 0x622a, 0x6222,
  0x6212, 0x6225, 0x623c, 0x6229, 0x62fa, 0x63f2, 0x63de, 0x63fc,
  0x63d9, 0x63dd, 0x63e1, 0x63bb, 0x63a2, 0x63f8, 0x63e4, 0x63e2,
  0x63c9, 0x63dc, 0x63b9, 0x63d7, 0x63e8, 0x63b5, 0x63c2, 0x63d3,
  0x63fe, 0x63bd, 0x63d4, 0x63ef, 0x63d0, 0x63df, 0x6f67, 0x6f8e,
  0x6f8b, 0x6fb8, 0x6fdf, 0x6fda, 0x6812, 0x68c4, 0x6906, 0x693f,
  0x6927, 0x694c, 0x6928, 0x6901, 0x693c, 0x6913, 0x691a, 0x6936,
  0x6930, 0x6933, 0x693b, 0x6916, 0x68f8, 0x6934, 0x692a, 0x6935,
  0x6924, 0x6923, 0x6938, 0x6903, 0x6926, 0x74a6, 0x74b7, 0x74be,
  0x74a1, 0x74a2, 0x74a0, 0x74b5, 0x74a3, 0x74a9, 0x763d, 0x767f,
  0x7662, 0x7679, 0x76e4, 0x76ed, 0x76ec, 0x77ba, 0x77c7, 0x77b6,
  0x77bf, 0x77c0, 0x77cd, 0x77be, 0x7117, 0x7120, 0x7142, 0x7141,
  0x7143, 0x7146, 0x71a6, 0x71a9, 0x71a8, 0x71af, 0x71ae, 0x7275,
  0x728b, 0x728a, 0x7285, 0x72c5, 0x72cb, 0x72ce, 0x72c8, 0x730c,
  0x72f4, 0x72f5, 0x7304, 0x7306, 0x72f3, 0x72f1, 0x730a, 0x73d1,
  0x7c0f, 0x7c19, 0x7c01, 0x7c00, 0x7d4b, 0x7d44, 0x7d45, 0x7d4a,
  0x7db4, 0x7db7, 0x7ddc, 0x7ddf, 0x7dc6, 0x7e72, 0x7e8c, 0x7ef2,
  0x7ef0, 0x7870, 0x790f, 0x7908, 0x790d, 0x7904, 0x790a, 0x7909,
  0x790b, 0x7b35, 0x7b83, 0x7bb2, 0x8409,
  /* 0xad */
  0x841d, 0x8400, 0x841c, 0x843b, 0x84db, 0x84e8, 0x84d7, 0x84ce,
  0x84c9, 0x84c1, 0x84ec, 0x84d6, 0x84c3, 0x84d3, 0x84e9, 0x84d0,
  0x85f9, 0x862f, 0x86ea, 0x870e, 0x8708, 0x86ee, 0x86d6, 0x86eb,
  0x8709, 0x86e8, 0x870f, 0x8704, 0x86df, 0x86da, 0x86fc, 0x870c,
  0x86d1, 0x86d9, 0x86dc, 0x86d3, 0x86de, 0x86d2, 0x86e2, 0x870b,
  0x825d, 0x8274, 0x8276, 0x8277, 0x8c40, 0x8c66, 0x8d8c, 0x8dd9,
  0x8e05, 0x8e0f, 0x8e0e, 0x8893, 0x88ad, 0x8979, 0x897e, 0x89b9,
  0x8ac0, 0x8ac1, 0x8bfd, 0x8beb, 0x8bef, 0x8be7, 0x8be8, 0x8be0,
  0x8be6, 0x8be9, 0x8be5, 0x94c7, 0x94c3, 0x94cc, 0x94ce, 0x9546,
  0x9547, 0x95c0, 0x918f, 0x925d, 0x9246, 0x9241, 0x9240, 0x936f,
  0x9364, 0x93c6, 0x93e0, 0x93fe, 0x9c0c, 0x9ca5, 0x9cd6, 0x9cd2,
  0x9d9b, 0x9d94, 0x4a55, 0x4abe, 0x5401, 0x5400, 0x542e, 0x4be2,
  0x542b, 0x5428, 0x4bf5, 0x5424, 0x541b, 0x540b, 0x5431, 0x5412,
  0x5417, 0x541f, 0x541c, 0x4bf7, 0x540d, 0x5419, 0x5425, 0x4bfc,
  0x542c, 0x5406, 0x5414, 0x5415, 0x4bfe, 0x4be3, 0x5420, 0x5427,
  0x4bf3, 0x5426, 0x5404, 0x5571, 0x55a9, 0x55a8, 0x55af, 0x55c0,
  0x55c1, 0x55cb, 0x55c6, 0x565b, 0x5651, 0x5659, 0x5656, 0x5650,
  0x5727, 0x5772, 0x5792, 0x5790, 0x57d2, 0x50e5, 0x511d, 0x510c,
  0x513a, 0x50f1, 0x50e8, 0x50ff, 0x510b, 0x50f7, 0x5119, 0x50e4,
  0x50e0, 0x50ec, 0x5104, 0x50e3, 0x50e7,
  /* 0xae */
  0x50eb, 0x512a, 0x510a, 0x50f0, 0x5102, 0x530e, 0x5309, 0x53cf,
  0x53d9, 0x53c6, 0x53ce, 0x5c04, 0x5d02, 0x5d5a, 0x5d55, 0x5d57,
  0x5e1c, 0x5e15, 0x5e11, 0x5e12, 0x5e16, 0x5e1e, 0x5de1, 0x5e2d,
  0x5e2e, 0x5e24, 0x5e28, 0x5e01, 0x5e04, 0x5f66, 0x5855, 0x5fbd,
  0x5fbe, 0x5fbb, 0x5fb9, 0x5fa3, 0x5fb8, 0x5fb4, 0x5fb5, 0x5809,
  0x585c, 0x5858, 0x585d, 0x58e0, 0x58f0, 0x58f6, 0x58e7, 0x58e5,
  0x58fd, 0x58fb, 0x590c, 0x58f9, 0x59e3, 0x5a20, 0x5a26, 0x5aa6,
  0x5aa0, 0x5aaa, 0x5b3c, 0x5b9f, 0x5b9c, 0x5b9d, 0x6454, 0x646e,
  0x6468, 0x645d, 0x6458, 0x6460, 0x6464, 0x6462, 0x6489, 0x6492,
  0x6497, 0x6480, 0x6499, 0x6481, 0x6488, 0x649b, 0x664a, 0x66fe,
  0x6705, 0x66f2, 0x6743, 0x6733, 0x6722, 0x6758, 0x674f, 0x674b,
  0x6742, 0x6744, 0x6737, 0x675d, 0x6730, 0x6727, 0x6726, 0x6725,
  0x6740, 0x6741, 0x6145, 0x6144, 0x6194, 0x61cc, 0x61c8, 0x624f,
  0x6244, 0x6242, 0x624e, 0x625f, 0x6241, 0x6248, 0x624c, 0x62f5,
  0x6319, 0x6318, 0x631a, 0x6c2c, 0x6c35, 0x6c45, 0x6c4b, 0x6c5e,
  0x6c34, 0x6c4f, 0x6c59, 0x6c24, 0x6cbe, 0x6c1a, 0x6c41, 0x6c5c,
  0x6c30, 0x63f9, 0x6c5d, 0x6c4d, 0x6c31, 0x6c4e, 0x6c27, 0x6c48,
  0x6c1e, 0x6c15, 0x6c4c, 0x6f87, 0x6f84, 0x6fba, 0x682e, 0x682a,
  0x6825, 0x682b, 0x6829, 0x68fd, 0x6967, 0x6998, 0x6985, 0x698a,
  0x696b, 0x6975, 0x697a, 0x6954, 0x699e,
  /* 0xaf */
  0x6961, 0x6984, 0x6963, 0x6957, 0x6979, 0x6964, 0x6981, 0x6987,
  0x6974, 0x6988, 0x6968, 0x6999, 0x74c7, 0x74d5, 0x74e9, 0x74d4,
  0x74c5, 0x74c2, 0x7634, 0x7674, 0x76f1, 0x76f4, 0x76f0, 0x76f5,
  0x76fa, 0x778b, 0x77e0, 0x7004, 0x77e3, 0x77ed, 0x77e7, 0x77d3,
  0x7159, 0x7150, 0x7151, 0x7157, 0x7154, 0x71b3, 0x71c8, 0x71ca,
  0x71bf, 0x71be, 0x71b0, 0x71b1, 0x71b4, 0x71cf, 0x71b5, 0x7286,
  0x72bd, 0x72c7, 0x72c0, 0x72c3, 0x7324, 0x7312, 0x732d, 0x7325,
  0x73e4, 0x7c3d, 0x7c2a, 0x7c35, 0x7c10, 0x7c39, 0x7c3a, 0x7c28,
  0x7c20, 0x7c2d, 0x7c12, 0x7c3f, 0x7d58, 0x7d5d, 0x7d6d, 0x7d52,
  0x7d5b, 0x7d53, 0x7d50, 0x7d5a, 0x7d57, 0x7de9, 0x7dee, 0x7dea,
  0x7dd2, 0x7deb, 0x7de4, 0x7dd5, 0x7e89, 0x7e85, 0x7ed4, 0x7f0b,
  0x7f1c, 0x7884, 0x792c, 0x791a, 0x7906, 0x7907, 0x792d, 0x792f,
  0x7919, 0x791d, 0x7918, 0x7917, 0x7911, 0x7900, 0x7914, 0x7916,
  0x7b37, 0x7b52, 0x7b99, 0x7bc8, 0x7bcc, 0x840b, 0x8415, 0x8418,
  0x8414, 0x841a, 0x8430, 0x8432, 0x84fc, 0x850f, 0x84fd, 0x8508,
  0x84e0, 0x84f9, 0x850b, 0x84f5, 0x84fe, 0x8505, 0x84f0, 0x8507,
  0x84f1, 0x84e2, 0x85e0, 0x85e1, 0x860d, 0x861d, 0x8627, 0x8626,
  0x8625, 0x8621, 0x86b6, 0x8726, 0x875f, 0x8759, 0x8747, 0x8735,
  0x875d, 0x8744, 0x8738, 0x8739, 0x8742, 0x873f, 0x8734, 0x873b,
  0x871a, 0x874d, 0x873c, 0x8725, 0x874e,
  /* 0xb0 */
  0x8259, 0x8287, 0x82a7, 0x829e, 0x82a9, 0x82a4, 0x8281, 0x82ae,
  0x8291, 0x8c7d, 0x8c7a, 0x8c8c, 0x8c8f, 0x8c70, 0x8c74, 0x8e15,
  0x8e1d, 0x8e03, 0x8e01, 0x8e18, 0x8e07, 0x8e1a, 0x8e1e, 0x8e1b,
  0x8e02, 0x8e1c, 0x8845, 0x8877, 0x8874, 0x88ac, 0x88af, 0x897a,
  0x8aa1, 0x8adf, 0x8ad9, 0x8ac2, 0x8bbc, 0x940c, 0x940b, 0x8bfa,
  0x940d, 0x8bf7, 0x8bf9, 0x940e, 0x8bf0, 0x9408, 0x8bf5, 0x9498,
  0x94ec, 0x94d0, 0x94ef, 0x955f, 0x9540, 0x9541, 0x95d5, 0x95d0,
  0x95da, 0x95d1, 0x95d4, 0x918e, 0x926f, 0x926e, 0x926c, 0x9256,
  0x9250, 0x9269, 0x9255, 0x9253, 0x92b6, 0x9cef, 0x9da1, 0x9ea5,
  0x9ed5, 0x9f28, 0x9f3f, 0x9f31, 0x4a73, 0x5477, 0x5470, 0x5451,
  0x544a, 0x544e, 0x5441, 0x5457, 0x5444, 0x5468, 0x547b, 0x5443,
  0x5458, 0x5478, 0x5479, 0x547a, 0x5442, 0x5402, 0x5462, 0x5460,
  0x5551, 0x5598, 0x55fd, 0x5667, 0x5662, 0x56df, 0x56d4, 0x56d5,
  0x56d8, 0x571d, 0x5702, 0x5714, 0x5732, 0x574d, 0x5733, 0x57ce,
  0x62f1, 0x514b, 0x5167, 0x516b, 0x5149, 0x5153, 0x516c, 0x514e,
  0x5147, 0x513c, 0x515b, 0x5142, 0x5158, 0x5122, 0x5169, 0x5135,
  0x5123, 0x5151, 0x5121, 0x516e, 0x513e, 0x514c, 0x515a, 0x5305,
  0x5306, 0x5304, 0x53d2, 0x5c08, 0x5c07, 0x5c0b, 0x53ed, 0x53e9,
  0x53f7, 0x5c0f, 0x5c38, 0x53fa, 0x53f4, 0x5d2d, 0x5d6f, 0x5e3b,
  0x5e4c, 0x5e44, 0x5e6b, 0x5e67, 0x5e4d,
  /* 0xb1 */
  0x5e31, 0x5e6f, 0x5e57, 0x5e4b, 0x5e47, 0x5f7d, 0x5fca, 0x5fc8,
  0x5fc9, 0x5fcf, 0x5fb2, 0x5fcb, 0x5804, 0x5805, 0x580a, 0x586d,
  0x5851, 0x5850, 0x590a, 0x590b, 0x5903, 0x5916, 0x591b, 0x592f,
  0x591c, 0x5924, 0x5919, 0x5914, 0x5929, 0x592a, 0x591a, 0x59ef,
  0x5a35, 0x5a3b, 0x5a3e, 0x5a3a, 0x5aba, 0x5ab5, 0x5abb, 0x5ab8,
  0x5ab3, 0x5b38, 0x5b3a, 0x5b5a, 0x5b61, 0x5b64, 0x5b66, 0x5b9a,
  0x5b94, 0x5b93, 0x5b95, 0x5bac, 0x5bad, 0x5b91, 0x6472, 0x64ae,
  0x6484, 0x64ad, 0x64a5, 0x64c6, 0x64b9, 0x64eb, 0x64b0, 0x64c8,
  0x64b6, 0x64b8, 0x64d1, 0x64b1, 0x64d5, 0x64d8, 0x64cb, 0x64d2,
  0x64b5, 0x64d7, 0x64ca, 0x6617, 0x6616, 0x6645, 0x67ad, 0x67aa,
  0x677f, 0x679b, 0x67af, 0x67a8, 0x677a, 0x676a, 0x6795, 0x67a7,
  0x677c, 0x67a4, 0x6784, 0x678e, 0x6796, 0x6766, 0x67a5, 0x6789,
  0x6785, 0x6794, 0x67ac, 0x67a1, 0x679f, 0x6782, 0x678d, 0x6776,
  0x6764, 0x6765, 0x6777, 0x6150, 0x615b, 0x615c, 0x6154, 0x615a,
  0x5152, 0x6142, 0x6155, 0x6158, 0x6159, 0x6191, 0x6196, 0x61a1,
  0x61c2, 0x61c6, 0x61c1, 0x61c3, 0x6250, 0x6257, 0x6269, 0x6265,
  0x626b, 0x6253, 0x62f4, 0x56da, 0x6316, 0x6c8c, 0x6ca2, 0x6caf,
  0x6c9e, 0x6cb8, 0x6c72, 0x6c7b, 0x6cbc, 0x6caa, 0x6c9a, 0x6cbd,
  0x6c8e, 0x6cc9, 0x6ca0, 0x6c8b, 0x6c88, 0x6c99, 0x6c90, 0x6ca5,
  0x6c92, 0x6cac, 0x6c8f, 0x6f3f, 0x6fb7,
  /* 0xb2 */
  0x6fe6, 0x6fe1, 0x6826, 0x6983, 0x69b1, 0x69fe, 0x69d4, 0x69bf,
  0x69ec, 0x69c1, 0x69e9, 0x69f6, 0x69f7, 0x6a08, 0x69ca, 0x69c6,
  0x69a2, 0x69dc, 0x69a3, 0x69d3, 0x69f4, 0x69b5, 0x69fa, 0x69f8,
  0x69c8, 0x69df, 0x6a17, 0x69b8, 0x69d7, 0x69e6, 0x69d5, 0x69e7,
  0x69fc, 0x69e3, 0x69e5, 0x69cb, 0x69c9, 0x69a7, 0x69e1, 0x69b2,
  0x69eb, 0x74f4, 0x7504, 0x7507, 0x74f0, 0x74e2, 0x7630, 0x7670,
  0x768c, 0x7711, 0x7716, 0x771b, 0x771e, 0x7714, 0x778a, 0x7008,
  0x7007, 0x700e, 0x700b, 0x77f3, 0x7000, 0x70ed, 0x70fb, 0x70fa,
  0x7111, 0x712f, 0x7168, 0x716b, 0x716f, 0x717d, 0x7182, 0x71d9,
  0x71d8, 0x71b8, 0x71c7, 0x71c0, 0x7283, 0x72d9, 0x72df, 0x72d6,
  0x733a, 0x7333, 0x7331, 0x733b, 0x7335, 0x7337, 0x7c66, 0x7c4e,
  0x7c43, 0x7d68, 0x7d65, 0x7d60, 0x7df6, 0x7e9f, 0x7e98, 0x7f2d,
  0x7f25, 0x7f16, 0x7f21, 0x7f2b, 0x7f14, 0x7f13, 0x7f23, 0x789f,
  0x789a, 0x7898, 0x794b, 0x794e, 0x797c, 0x7923, 0x7934, 0x7931,
  0x794d, 0x793d, 0x793e, 0x7949, 0x7922, 0x794f, 0x793f, 0x793c,
  0x7b30, 0x7b93, 0x7b97, 0x7bc1, 0x7bc3, 0x7bdf, 0x8411, 0x8447,
  0x844b, 0x8522, 0x851b, 0x852e, 0x8526, 0x8524, 0x853d, 0x8529,
  0x860f, 0x8638, 0x863a, 0x863b, 0x8634, 0x8783, 0x8793, 0x8795,
  0x8775, 0x87af, 0x879b, 0x87b0, 0x87a6, 0x879f, 0x8787, 0x879e,
  0x8784, 0x87ad, 0x877a, 0x8776, 0x8771,
  /* 0xb3 */
  0x878b, 0x87aa, 0x8258, 0x5b67, 0x82ca, 0x82cd, 0x82bb, 0x82c9,
  0x82b8, 0x82cb, 0x82c6, 0x82bc, 0x82a2, 0x82c4, 0x8c5e, 0x8c93,
  0x8c85, 0x8ca6, 0x8c9f, 0x8c9b, 0x8c80, 0x8c86, 0x8d9e, 0x8d82,
  0x8e27, 0x8e10, 0x8e2e, 0x8e28, 0x8e3c, 0x8e20, 0x8e12, 0x8e16,
  0x8e2f, 0x8844, 0x8857, 0x88a4, 0x88a1, 0x88a6, 0x88a5, 0x88a7,
  0x88aa, 0x896a, 0x896b, 0x89b3, 0x89b7, 0x8ad6, 0x8ad2, 0x9414,
  0x9400, 0x9417, 0x941a, 0x942e, 0x9412, 0x9410, 0x941d, 0x9418,
  0x9413, 0x942d, 0x9402, 0x942f, 0x941b, 0x9416, 0x9419, 0x94e5,
  0x94e0, 0x94f0, 0x955a, 0x95c3, 0x95f8, 0x95eb, 0x95ee, 0x95ea,
  0x95e0, 0x95e4, 0x9184, 0x9267, 0x9278, 0x927e, 0x9275, 0x927d,
  0x9279, 0x927b, 0x927a, 0x9261, 0x92cd, 0x92e7, 0x92e4, 0x7eed,
  0x7ed2, 0x9c0f, 0x9c0e, 0x9f57, 0x98e8, 0x9a78, 0x9a72, 0x9aa8,
  0x9ab6, 0x54af, 0x5480, 0x5488, 0x5494, 0x549c, 0x548d, 0x549b,
  0x5495, 0x5497, 0x630d, 0x55fc, 0x567f, 0x5679, 0x5678, 0x5664,
  0x56d3, 0x56d0, 0x56d6, 0x5757, 0x57a8, 0x5176, 0x518d, 0x51aa,
  0x5171, 0x5187, 0x5190, 0x5195, 0x518f, 0x5191, 0x51a7, 0x5199,
  0x518a, 0x5186, 0x518e, 0x51be, 0x51a3, 0x5192, 0x5133, 0x51bf,
  0x5197, 0x51b6, 0x51a1, 0x51bc, 0x5173, 0x5184, 0x51a6, 0x5194,
  0x5300, 0x5c22, 0x5c27, 0x5c39, 0x5c29, 0x5c3d, 0x5c3c, 0x5c2c,
  0x5c10, 0x5c2d, 0x5cf4, 0x5cf7, 0x5d6d,
  /* 0xb4 */
  0x5e7a, 0x5e97, 0x5e72, 0x5e9f, 0x5e96, 0x5eaa, 0x5f7e, 0x5f7c,
  0x5fdf, 0x5fc1, 0x5fde, 0x5fdd, 0x5807, 0x5806, 0x583c, 0x5941,
  0x595d, 0x5939, 0x594a, 0x59f0, 0x5a48, 0x5a30, 0x5a4d, 0x5a4e,
  0x5a73, 0x5ac7, 0x5acc, 0x5acf, 0x5ac9, 0x5b31, 0x5b60, 0x5ba4,
  0x5ba7, 0x5ba5, 0x64dc, 0x64ec, 0x64bf, 0x64bb, 0x64ed, 0x6511,
  0x652e, 0x64f7, 0x6518, 0x64fd, 0x64f6, 0x64f9, 0x6565, 0x64fc,
  0x6503, 0x64fb, 0x6504, 0x650d, 0x651f, 0x6612, 0x6644, 0x67ae,
  0x6781, 0x67c2, 0x67cd, 0x67e4, 0x67c4, 0x67cb, 0x67c0, 0x67df,
  0x67ee, 0x67dd, 0x67ec, 0x67db, 0x67e0, 0x67e3, 0x677b, 0x67f9,
  0x67e7, 0x67d6, 0x605f, 0x67d7, 0x67f4, 0x6153, 0x616b, 0x616f,
  0x616e, 0x619c, 0x619d, 0x61a2, 0x6263, 0x627d, 0x6279, 0x627b,
  0x6262, 0x629c, 0x6277, 0x6273, 0x627a, 0x62f3, 0x62f2, 0x6312,
  0x6310, 0x6cf7, 0x6cd8, 0x6ced, 0x6cd5, 0x6cda, 0x6d08, 0x6cd2,
  0x6cf8, 0x6ce3, 0x6cea, 0x6cf4, 0x6cdf, 0x6cff, 0x6cee, 0x6cc6,
  0x6cc0, 0x6d00, 0x6d1f, 0x6d03, 0x6cc4, 0x6cd7, 0x6d63, 0x6cf6,
  0x6f33, 0x6f37, 0x6f30, 0x6f95, 0x6f9b, 0x6fb1, 0x6fe2, 0x6823,
  0x6822, 0x6821, 0x6a22, 0x6a35, 0x6a59, 0x6a2c, 0x6a3f, 0x6a6a,
  0x6a47, 0x6a2d, 0x6a28, 0x6a2e, 0x6a16, 0x6a56, 0x6a55, 0x6a29,
  0x6a5b, 0x6a63, 0x6a20, 0x6a2b, 0x6a62, 0x6a39, 0x6a40, 0x6a37,
  0x6a21, 0x6a4e, 0x6a10, 0x6a33, 0x6ac6,
  /* 0xb5 */
  0x6a84, 0x6a14, 0x6a43, 0x6a6e, 0x6a49, 0x6a7f, 0x6a64, 0x6a52,
  0x7514, 0x7517, 0x752b, 0x753d, 0x752c, 0x753b, 0x7563, 0x7511,
  0x7641, 0x7689, 0x768d, 0x773b, 0x7728, 0x7739, 0x7724, 0x7037,
  0x7027, 0x703e, 0x702f, 0x7028, 0x7038, 0x703b, 0x7039, 0x7022,
  0x7016, 0x702b, 0x7025, 0x7128, 0x712b, 0x7166, 0x7167, 0x71ef,
  0x71d6, 0x71ee, 0x71d4, 0x71d5, 0x71d3, 0x71ed, 0x7276, 0x7271,
  0x729b, 0x729e, 0x72b9, 0x72d1, 0x7342, 0x73e0, 0x7c50, 0x7c61,
  0x7c62, 0x7e00, 0x7e05, 0x7e06, 0x7e08, 0x7e0d, 0x7e95, 0x7e9a,
  0x7e9b, 0x7ee8, 0x7eee, 0x7f44, 0x7f5b, 0x7f4b, 0x7f5d, 0x7f5f,
  0x7f59, 0x7f40, 0x7f46, 0x7f42, 0x7f5c, 0x7892, 0x78a8, 0x7953,
  0x795d, 0x7965, 0x7958, 0x7926, 0x7963, 0x797f, 0x796c, 0x796b,
  0x796f, 0x797d, 0x797e, 0x5189, 0x7bd9, 0x7bd8, 0x8406, 0x845f,
  0x8488, 0x8558, 0x8559, 0x8546, 0x855c, 0x8543, 0x8534, 0x854b,
  0x8533, 0x8541, 0x855e, 0x8579, 0x861f, 0x8611, 0x87e4, 0x800e,
  0x87f5, 0x8000, 0x87ed, 0x87c8, 0x8006, 0x87cc, 0x87e2, 0x87fc,
  0x87f9, 0x805a, 0x8007, 0x87fd, 0x8001, 0x87c1, 0x87f0, 0x87ff,
  0x87c7, 0x8035, 0x8003, 0x8009, 0x87d1, 0x800a, 0x87d9, 0x87d2,
  0x8256, 0x82d2, 0x82d4, 0x82e0, 0x82d9, 0x82d6, 0x82e9, 0x82dd,
  0x82d3, 0x8c5a, 0x8ccc, 0x8ccf, 0x8cbc, 0x8d8e, 0x8d9b, 0x8e36,
  0x8e6d, 0x8e58, 0x8e53, 0x8e31, 0x8e4c,
  /* 0xb6 */
  0x8e59, 0x8e56, 0x8e5d, 0x8e4b, 0x8e39, 0x8e37, 0x8e3b, 0x8e5b,
  0x886c, 0x888f, 0x88a2, 0x88b1, 0x88be, 0x88b0, 0x88cc, 0x88b6,
  0x88cd, 0x88b9, 0x88ba, 0x88bb, 0x88b2, 0x88b5, 0x8987, 0x8988,
  0x898c, 0x89c3, 0x89d0, 0x89c6, 0x89d7, 0x89dc, 0x89c1, 0x89d6,
  0x89cb, 0x8af6, 0x8af5, 0x8af1, 0x8b91, 0x9423, 0x9438, 0x943c,
  0x9435, 0x943f, 0x943b, 0x950f, 0x94f8, 0x9504, 0x94f3, 0x956e,
  0x9568, 0x95c2, 0x9619, 0x9618, 0x962e, 0x9604, 0x9613, 0x9600,
  0x961d, 0x960a, 0x961c, 0x9199, 0x9182, 0x9186, 0x919c, 0x919e,
  0x919f, 0x9183, 0x9287, 0x9283, 0x9286, 0x9270, 0x9288, 0x928b,
  0x9280, 0x927f, 0x9289, 0x92cc, 0x92c8, 0x92c9, 0x92cb, 0x92ca,
  0x92e2, 0x92ff, 0x93c1, 0x9c08, 0x9c0b, 0x9c05, 0x9cea, 0x9ce7,
  0x9ce2, 0x9ce4, 0x9cff, 0x9ce0, 0x9da3, 0x9da0, 0x9ace, 0x9ac0,
  0x9adc, 0x4a8f, 0x54a0, 0x54b8, 0x54bf, 0x54be, 0x54c8, 0x54b3,
  0x54a1, 0x54ba, 0x54b6, 0x54a2, 0x54ca, 0x5672, 0x567a, 0x5670,
  0x56d2, 0x56eb, 0x56e9, 0x56ef, 0x56ee, 0x5722, 0x51d2, 0x51e5,
  0x51de, 0x51eb, 0x51c3, 0x51d1, 0x51ca, 0x51dc, 0x51ee, 0x51e9,
  0x51e2, 0x51d7, 0x51ec, 0x51c8, 0x51cb, 0x51e8, 0x51c4, 0x531f,
  0x531e, 0x5c53, 0x5c5c, 0x5c55, 0x5c5a, 0x5c57, 0x5c59, 0x5c66,
  0x5c41, 0x5c60, 0x5c47, 0x5c6f, 0x5c5f, 0x5c46, 0x5d6a, 0x5ecc,
  0x5ec4, 0x5ec1, 0x5eb3, 0x5eb0, 0x5eb1,
  /* 0xb7 */
  0x5ebe, 0x5ecf, 0x5ebf, 0x5964, 0x5962, 0x5a41, 0x5a74, 0x5ac4,
  0x5ac5, 0x5b1f, 0x5b54, 0x5ba1, 0x5ba3, 0x6517, 0x6502, 0x6545,
  0x6512, 0x64fe, 0x6516, 0x64f4, 0x650c, 0x6505, 0x6543, 0x6541,
  0x6549, 0x6540, 0x6533, 0x6539, 0x652a, 0x6500, 0x650b, 0x653a,
  0x662c, 0x662f, 0x601e, 0x6033, 0x6013, 0x6027, 0x6020, 0x6030,
  0x6021, 0x6002, 0x6011, 0x6019, 0x6000, 0x603b, 0x601b, 0x601a,
  0x600b, 0x6161, 0x6192, 0x61bd, 0x629a, 0x6284, 0x628a, 0x6285,
  0x629b, 0x6289, 0x6295, 0x6280, 0x630e, 0x6d99, 0x6d60, 0x6d57,
  0x6d7a, 0x6d6d, 0x6d59, 0x6d78, 0x6d3d, 0x6d8f, 0x6d47, 0x6d65,
  0x6d66, 0x6d53, 0x6d5e, 0x6d74, 0x6d8b, 0x6d50, 0x6d6e, 0x6d56,
  0x6f4a, 0x6f7f, 0x6fcd, 0x6fb2, 0x6fde, 0x6ff0, 0x6aaf, 0x6aa2,
  0x6ade, 0x6abb, 0x6acf, 0x6a9d, 0x6a90, 0x6aca, 0x6ac8, 0x6aa8,
  0x6a95, 0x6ab1, 0x6ab7, 0x6aa6, 0x6adc, 0x6a9b, 0x6a91, 0x6ac9,
  0x6ad9, 0x6aa7, 0x6aaa, 0x6ab9, 0x7543, 0x7554, 0x7564, 0x7569,
  0x7544, 0x756a, 0x7551, 0x7561, 0x756b, 0x7541, 0x7568, 0x7553,
  0x754b, 0x7565, 0x755b, 0x7637, 0x765f, 0x773a, 0x7748, 0x7732,
  0x7733, 0x7062, 0x7057, 0x7058, 0x7052, 0x7053, 0x704c, 0x7032,
  0x7054, 0x7056, 0x7051, 0x717b, 0x7175, 0x720d, 0x71fd, 0x720c,
  0x71ff, 0x71fc, 0x71f7, 0x71f2, 0x71f9, 0x71fe, 0x72d3, 0x72d2,
  0x7356, 0x7366, 0x736b, 0x7353, 0x736e,
  /* 0xb8 */
  0x7374, 0x7367, 0x7361, 0x7351, 0x7368, 0x7365, 0x736f, 0x73e3,
  0x7c83, 0x7cbd, 0x7c9a, 0x7c95, 0x7c81, 0x7c84, 0x7c71, 0x7c9c,
  0x7c9e, 0x7c72, 0x7d77, 0x7d72, 0x7d8c, 0x8021, 0x7db0, 0x7e11,
  0x7e17, 0x7e2d, 0x7e19, 0x7e12, 0x7e13, 0x7e92, 0x7ead, 0x7f7a,
  0x7fcd, 0x7f6d, 0x7f63, 0x7f6a, 0x78bc, 0x78be, 0x78b8, 0x799e,
  0x7974, 0x799c, 0x798c, 0x7982, 0x7956, 0x7b63, 0x7b64, 0x7b67,
  0x7b7f, 0x7ba4, 0x7ba5, 0x7ba9, 0x845b, 0x8455, 0x848b, 0x8489,
  0x857c, 0x857d, 0x8575, 0x8568, 0x8563, 0x857e, 0x8566, 0x8574,
  0x8577, 0x856b, 0x8608, 0x864a, 0x808f, 0x807a, 0x8030, 0x803c,
  0x8078, 0x806b, 0x8066, 0x8044, 0x8061, 0x8056, 0x8031, 0x8038,
  0x806c, 0x806e, 0x8064, 0x8060, 0x804b, 0x8253, 0x8251, 0x8252,
  0x82f4, 0x831e, 0x8305, 0x830a, 0x830d, 0x82f3, 0x82f6, 0x830f,
  0x830e, 0x830b, 0x8307, 0x8c54, 0x8cd2, 0x8cd9, 0x8cd4, 0x8cd1,
  0x8cd5, 0x8cd0, 0x8cec, 0x8cc7, 0x8cd8, 0x8cdf, 0x8d91, 0x8dee,
  0x8e66, 0x8e7f, 0x8e7e, 0x8e6b, 0x8e64, 0x8e7d, 0x8e8a, 0x8e71,
  0x8e6e, 0x8ead, 0x8e7c, 0x8e88, 0x8e60, 0x8e6f, 0x8e63, 0x8e61,
  0x8e74, 0x8e76, 0x8e33, 0x8e65, 0x886f, 0x8887, 0x8884, 0x88c7,
  0x88ca, 0x88c5, 0x88c9, 0x88bf, 0x88ce, 0x88cf, 0x88c8, 0x89ec,
  0x89d2, 0x89e5, 0x89e2, 0x89fe, 0x89f7, 0x89e7, 0x89e9, 0x89eb,
  0x8abf, 0x8b0e, 0x8b04, 0x8af3, 0x8b07,
  /* 0xb9 */
  0x8b92, 0x8bbf, 0x9446, 0x9447, 0x945e, 0x944f, 0x9459, 0x9431,
  0x9458, 0x945d, 0x944a, 0x9442, 0x9443, 0x9440, 0x945c, 0x9433,
  0x944c, 0x951f, 0x951a, 0x9561, 0x9567, 0x9564, 0x95c4, 0x963a,
  0x965a, 0x9635, 0x9630, 0x964d, 0x9633, 0x9656, 0x9646, 0x9669,
  0x965c, 0x9639, 0x9644, 0x9640, 0x9648, 0x9634, 0x9632, 0x9657,
  0x9195, 0x9295, 0x9299, 0x9298, 0x92c0, 0x92c6, 0x92c4, 0x92c7,
  0x92fa, 0x92f6, 0x92f4, 0x92fb, 0x935b, 0x9379, 0x937b, 0x9c1d,
  0x9c1c, 0x9c1e, 0x9c07, 0x9c1f, 0x9c01, 0x9cf1, 0x9cf9, 0x9cf0,
  0x9cf3, 0x9dbe, 0x9dbc, 0x9db9, 0x9eec, 0x98e4, 0x9a8f, 0x9b03,
  0x9b1e, 0x9b2d, 0x54ea, 0x54e3, 0x54e8, 0x54db, 0x54e0, 0x54d7,
  0x54d8, 0x54c2, 0x54dc, 0x54fc, 0x54c3, 0x54e4, 0x556f, 0x55fe,
  0x568e, 0x568f, 0x573c, 0x57a0, 0x51f3, 0x520d, 0x5216, 0x521a,
  0x51f0, 0x5219, 0x520b, 0x5204, 0x5200, 0x5203, 0x51fa, 0x521b,
  0x5212, 0x5205, 0x521d, 0x51fb, 0x5315, 0x531b, 0x5c78, 0x5c73,
  0x5c8e, 0x5c9e, 0x5c87, 0x5c74, 0x5c88, 0x5c70, 0x5cf0, 0x5d28,
  0x5d2f, 0x5d29, 0x5d67, 0x5d64, 0x5eec, 0x5eeb, 0x5ee4, 0x5eda,
  0x5edb, 0x5ed5, 0x5eee, 0x5f78, 0x5fd3, 0x5fea, 0x5fec, 0x5fe8,
  0x5feb, 0x5fe5, 0x5fef, 0x5fe9, 0x5fd2, 0x5800, 0x586f, 0x5989,
  0x598a, 0x5a56, 0x5a6e, 0x5a58, 0x5a5a, 0x5a59, 0x5ade, 0x5adb,
  0x5b07, 0x5b4b, 0x5b7d, 0x5bb4, 0x654a,
  /* 0xba */
  0x6532, 0x6546, 0x657a, 0x656f, 0x656e, 0x6552, 0x6557, 0x6555,
  0x6578, 0x6627, 0x608a, 0x6055, 0x6059, 0x60a9, 0x6075, 0x6052,
  0x6077, 0x605c, 0x606a, 0x6039, 0x6060, 0x6076, 0x617f, 0x61ac,
  0x61da, 0x61db, 0x62af, 0x62a5, 0x6290, 0x6d91, 0x6da5, 0x6d98,
  0x6dcc, 0x6da3, 0x6dde, 0x6dc6, 0x6d96, 0x6dba, 0x6db6, 0x6da6,
  0x6db9, 0x6ddd, 0x6dc0, 0x6da0, 0x6dc1, 0x6dab, 0x6dce, 0x6dae,
  0x6f44, 0x6f41, 0x683e, 0x6b3e, 0x6b19, 0x6af3, 0x6b1e, 0x6af9,
  0x6b24, 0x6b33, 0x6b2d, 0x6b21, 0x6b02, 0x6b0f, 0x6b2f, 0x6af2,
  0x6ae2, 0x6b0b, 0x6b3c, 0x6b35, 0x6b3f, 0x6b2e, 0x6b18, 0x6b26,
  0x6b22, 0x6b85, 0x6b27, 0x6ae1, 0x6b0c, 0x6aff, 0x6ac1, 0x6afa,
  0x7599, 0x7594, 0x7570, 0x7587, 0x7589, 0x759f, 0x7633, 0x769f,
  0x769b, 0x7749, 0x775d, 0x7069, 0x706e, 0x7067, 0x707d, 0x7060,
  0x7109, 0x719c, 0x722a, 0x7200, 0x7206, 0x7204, 0x721e, 0x72ec,
  0x72ee, 0x7389, 0x7370, 0x7372, 0x736c, 0x7ccc, 0x7c92, 0x7caa,
  0x7cbe, 0x7ca4, 0x7cae, 0x7d83, 0x7d82, 0x7d80, 0x7e23, 0x7e3c,
  0x7ea7, 0x7ea4, 0x7ee0, 0x7ee2, 0x7fac, 0x7f98, 0x7f86, 0x7f78,
  0x7f9a, 0x7f90, 0x7f99, 0x7f82, 0x7fb5, 0x7f8a, 0x7f89, 0x78b4,
  0x78b0, 0x78b3, 0x79b6, 0x79bd, 0x7991, 0x79b0, 0x79b3, 0x79ad,
  0x79c7, 0x79b9, 0x79bf, 0x79bc, 0x79b7, 0x79af, 0x79b2, 0x79b8,
  0x79b5, 0x79a0, 0x79df, 0x79ca, 0x79a1,
  /* 0xbb */
  0x7b7d, 0x7bed, 0x7bec, 0x7bd2, 0x8453, 0x8457, 0x848a, 0x855d,
  0x858d, 0x8582, 0x8585, 0x8587, 0x8572, 0x858f, 0x85ea, 0x85f7,
  0x860a, 0x8619, 0x8613, 0x8646, 0x80c4, 0x80b2, 0x80cb, 0x80c9,
  0x8094, 0x8093, 0x80bf, 0x8091, 0x80c6, 0x80b5, 0x80cd, 0x80de,
  0x809d, 0x80b1, 0x80dc, 0x80c7, 0x8332, 0x8311, 0x8336, 0x832f,
  0x8328, 0x8339, 0x8315, 0x8358, 0x833a, 0x8324, 0x8cfe, 0x8d0f,
  0x8cf9, 0x8cf4, 0x8cf5, 0x8cf0, 0x8ce5, 0x8d17, 0x8ce2, 0x8eab,
  0x8e81, 0x8e93, 0x8eae, 0x8e80, 0x8eac, 0x8e9e, 0x8ea9, 0x8ea7,
  0x8ea8, 0x8ea5, 0x8e95, 0x8e9c, 0x8e97, 0x8eaa, 0x8867, 0x8880,
  0x8881, 0x88de, 0x88dc, 0x88df, 0x8966, 0x8994, 0x8998, 0x89f1,
  0x8b19, 0x8b1f, 0x8b18, 0x8b1e, 0x8bae, 0x946d, 0x9455, 0x9451,
  0x946e, 0x9454, 0x9453, 0x946f, 0x9450, 0x9456, 0x9514, 0x9515,
  0x9513, 0x9578, 0x9575, 0x957a, 0x9579, 0x9675, 0x968d, 0x9688,
  0x9695, 0x969b, 0x9676, 0x969e, 0x9691, 0x96a5, 0x9671, 0x969c,
  0x91ac, 0x91a5, 0x91a4, 0x91ae, 0x91a8, 0x91a9, 0x9294, 0x9291,
  0x9296, 0x92c1, 0x92df, 0x930d, 0x9371, 0x9388, 0x93fb, 0x9c1a,
  0x9c15, 0x9ca2, 0x9cbc, 0x9d0e, 0x9d08, 0x9d01, 0x9d04, 0x9dcc,
  0x9ea2, 0x9ebd, 0x9eeb, 0x9f4c, 0x9f4f, 0x98f9, 0x98fb, 0x98fe,
  0x9ab1, 0x9b36, 0x9b47, 0x5509, 0x550d, 0x54f6, 0x54f8, 0x54f4,
  0x550f, 0x5505, 0x5504, 0x5508, 0x55d1,
  /* 0xbc */
  0x568a, 0x5685, 0x5684, 0x5680, 0x5687, 0x56fd, 0x57bf, 0x5223,
  0x5236, 0x5234, 0x523f, 0x5232, 0x5239, 0x5224, 0x525e, 0x5243,
  0x525a, 0x5279, 0x523b, 0x5222, 0x523d, 0x5c8d, 0x5c92, 0x5c93,
  0x5cbe, 0x5c91, 0x5ca3, 0x5ca4, 0x5cab, 0x5d60, 0x5f04, 0x5ef6,
  0x5f06, 0x5ef8, 0x5f01, 0x5f05, 0x5fe3, 0x5fe1, 0x5fe4, 0x5fe6,
  0x5869, 0x5868, 0x5990, 0x5999, 0x5a6f, 0x5a52, 0x5a6c, 0x5aef,
  0x5ad7, 0x5ad2, 0x5ad0, 0x5aee, 0x5aed, 0x5b45, 0x5b7c, 0x5bba,
  0x5bb8, 0x657b, 0x656a, 0x6563, 0x6550, 0x6558, 0x658f, 0x6571,
  0x657d, 0x6566, 0x6573, 0x65aa, 0x659d, 0x65a6, 0x6583, 0x65a1,
  0x6597, 0x65a9, 0x6599, 0x65a3, 0x6623, 0x6064, 0x6062, 0x6074,
  0x6093, 0x60bf, 0x6085, 0x609d, 0x60bd, 0x60a8, 0x609e, 0x6098,
  0x60a4, 0x609f, 0x60a3, 0x60a0, 0x60a6, 0x6097, 0x60a1, 0x6094,
  0x60af, 0x60be, 0x6178, 0x617a, 0x6175, 0x62a3, 0x62a6, 0x62b9,
  0x62bc, 0x6e2e, 0x6e12, 0x6de5, 0x6e0c, 0x6e13, 0x6e14, 0x6df0,
  0x6e2c, 0x6e1e, 0x6e07, 0x6dfe, 0x6e0f, 0x6e08, 0x6de0, 0x6e1c,
  0x6f5d, 0x6f43, 0x6fa9, 0x6fc8, 0x6fcb, 0x6b32, 0x6b71, 0x6b89,
  0x6b5c, 0x6b6b, 0x6b59, 0x6b8b, 0x6b60, 0x6b56, 0x6b75, 0x6b63,
  0x6b83, 0x6b77, 0x6b7d, 0x6b69, 0x6b9a, 0x6b55, 0x6ad8, 0x6b62,
  0x6b6d, 0x6b52, 0x7592, 0x75a1, 0x75bc, 0x75a5, 0x765b, 0x7696,
  0x7743, 0x775a, 0x7064, 0x7086, 0x708e,
  /* 0xbd */
  0x7073, 0x708d, 0x7172, 0x722d, 0x7224, 0x7212, 0x7229, 0x722b,
  0x722c, 0x722f, 0x7297, 0x72b7, 0x72e9, 0x7383, 0x738a, 0x7381,
  0x739c, 0x7386, 0x7cc6, 0x7cc8, 0x7cb7, 0x7cc7, 0x7cb3, 0x7cd8,
  0x7cb1, 0x7cdd, 0x7e32, 0x7e31, 0x7e4d, 0x7e30, 0x7e3a, 0x7e36,
  0x7ea2, 0x7ea3, 0x7fa0, 0x7fbc, 0x7fc9, 0x7fb9, 0x7fcb, 0x7fca,
  0x7fcc, 0x7fad, 0x7fc1, 0x78c7, 0x79ed, 0x79f9, 0x79e2, 0x79f6,
  0x79d5, 0x79e1, 0x79d0, 0x79e5, 0x79ee, 0x79d7, 0x79d3, 0x79e4,
  0x7993, 0x79d4, 0x79ff, 0x79f4, 0x7b78, 0x7b7a, 0x7ba2, 0x7be4,
  0x842b, 0x8596, 0x8591, 0x8590, 0x85ad, 0x8597, 0x8595, 0x811a,
  0x8130, 0x8117, 0x80e3, 0x8121, 0x8120, 0x811e, 0x811c, 0x812e,
  0x812c, 0x8119, 0x80e1, 0x8128, 0x80f2, 0x810b, 0x838f, 0x8379,
  0x837b, 0x836d, 0x836b, 0x8375, 0x8365, 0x8354, 0x835a, 0x8341,
  0x835e, 0x8c56, 0x8c50, 0x8d1d, 0x8d0a, 0x8d1f, 0x8d1e, 0x8d18,
  0x8d07, 0x8eb1, 0x8edf, 0x8eca, 0x8ec9, 0x8e98, 0x8ec6, 0x8ef5,
  0x8ebf, 0x8ec4, 0x8ecf, 0x8eb2, 0x8ebd, 0x8edb, 0x8ec0, 0x8ebb,
  0x8eb4, 0x8ed6, 0x8841, 0x8843, 0x8861, 0x88ed, 0x88d3, 0x88eb,
  0x88e9, 0x88e1, 0x88e0, 0x88ef, 0x88ee, 0x88d1, 0x88e7, 0x88ec,
  0x8960, 0x8992, 0x89ae, 0x8a26, 0x8a1d, 0x8a10, 0x8a2f, 0x8a02,
  0x8a24, 0x8a12, 0x8a2c, 0x8a13, 0x8ab7, 0x8b10, 0x8b16, 0x8b12,
  0x8b24, 0x8b2b, 0x8b27, 0x8b11, 0x8b13,
  /* 0xbe */
  0x8b28, 0x9464, 0x9463, 0x9465, 0x9460, 0x947a, 0x953d, 0x9520,
  0x952a, 0x953c, 0x958a, 0x9584, 0x9586, 0x958e, 0x96c8, 0x96b6,
  0x96ba, 0x96e7, 0x96a1, 0x96e9, 0x96cc, 0x96be, 0x96b1, 0x96df,
  0x96ca, 0x96fd, 0x96bf, 0x91a0, 0x91bc, 0x9309, 0x930b, 0x930a,
  0x9304, 0x936d, 0x9380, 0x9386, 0x9382, 0x9c2c, 0x9c26, 0x9c11,
  0x9cbe, 0x9d07, 0x9d1e, 0x9d1f, 0x9d15, 0x9dd0, 0x9ddd, 0x9dd2,
  0x9dd6, 0x9ddc, 0x9dd8, 0x9ddf, 0x9dd4, 0x9eba, 0x9ee3, 0x9ee2,
  0x9f2a, 0x9f48, 0x9f49, 0x9f7a, 0x9f62, 0x990b, 0x9904, 0x990e,
  0x9aa4, 0x9ab3, 0x9ac3, 0x5ca5, 0x9b5f, 0x551f, 0x5515, 0x5519,
  0x551d, 0x5518, 0x558d, 0x55a7, 0x55d0, 0x569c, 0x569e, 0x56fe,
  0x5254, 0x5266, 0x5274, 0x5264, 0x5269, 0x5275, 0x5267, 0x5265,
  0x5268, 0x527c, 0x5262, 0x5261, 0x526f, 0x527b, 0x5ccc, 0x5cb3,
  0x5cca, 0x5cc8, 0x5d63, 0x5f10, 0x5f39, 0x5f75, 0x5ffd, 0x5803,
  0x5b47, 0x65bf, 0x659c, 0x65a4, 0x6587, 0x65c0, 0x65bb, 0x65b3,
  0x65c7, 0x65c5, 0x663d, 0x60c8, 0x60cc, 0x60c6, 0x60b6, 0x60b1,
  0x60d7, 0x60c9, 0x60ca, 0x60cf, 0x60c0, 0x60b2, 0x60df, 0x60d9,
  0x60b3, 0x6179, 0x62cb, 0x62c4, 0x62b4, 0x62c9, 0x62ca, 0x62b5,
  0x6e30, 0x6e35, 0x6e37, 0x6e54, 0x6e66, 0x6e55, 0x6e34, 0x6e49,
  0x6e6f, 0x6e6c, 0x6e46, 0x6e4a, 0x6e38, 0x6e52, 0x6e45, 0x6f54,
  0x6f7a, 0x6808, 0x6bcf, 0x6bbc, 0x6bac,
  /* 0xbf */
  0x6bce, 0x6ba9, 0x6bcc, 0x6baa, 0x6bbe, 0x6bcd, 0x6bb4, 0x6bbb,
  0x6bab, 0x6bad, 0x6bb9, 0x75b3, 0x75c4, 0x75dd, 0x75df, 0x75c5,
  0x75d8, 0x75b4, 0x75c3, 0x75d4, 0x75d1, 0x75ce, 0x75c9, 0x7765,
  0x7091, 0x70ae, 0x7095, 0x7092, 0x7093, 0x70ef, 0x7101, 0x7100,
  0x7239, 0x7235, 0x7237, 0x72ea, 0x72e8, 0x73ad, 0x7393, 0x7392,
  0x73a8, 0x7ce5, 0x7cd7, 0x7ce1, 0x7cea, 0x7dab, 0x7e40, 0x7e43,
  0x7e4b, 0x7e41, 0x7e46, 0x7eb7, 0x7fd4, 0x781c, 0x7fc4, 0x7fe9,
  0x7fd6, 0x7fec, 0x7fe4, 0x7feb, 0x78d8, 0x78db, 0x7a07, 0x7a1c,
  0x7a05, 0x7a16, 0x7a2e, 0x7a13, 0x7a10, 0x7a04, 0x7a1d, 0x7b74,
  0x7bbf, 0x7bfd, 0x7bfc, 0x7be3, 0x8425, 0x85be, 0x85a4, 0x85a5,
  0x85f6, 0x8605, 0x8655, 0x8654, 0x8147, 0x8154, 0x8145, 0x8165,
  0x8164, 0x814e, 0x8144, 0x8160, 0x8167, 0x8153, 0x838e, 0x8392,
  0x8393, 0x83af, 0x8380, 0x8c6c, 0x8d27, 0x8d3f, 0x8d28, 0x8d26,
  0x8d2c, 0x8da7, 0x8dab, 0x8eeb, 0x8ef7, 0x8ee6, 0x8efc, 0x8f0d,
  0x8ed1, 0x8eea, 0x8ee3, 0x8ef3, 0x8f0c, 0x8f0f, 0x8efa, 0x8ee0,
  0x8efe, 0x8efb, 0x8ef1, 0x8866, 0x8860, 0x889e, 0x88f9, 0x8a49,
  0x8a3c, 0x8a39, 0x8a4f, 0x8a34, 0x8a38, 0x8b36, 0x8b22, 0x8b35,
  0x8b3e, 0x8ba5, 0x8bab, 0x9478, 0x9479, 0x9475, 0x947f, 0x9471,
  0x9477, 0x9539, 0x959f, 0x972d, 0x973b, 0x96f5, 0x973e, 0x9722,
  0x972f, 0x96f1, 0x9726, 0x9709, 0x9717,
  /* 0xc0 */
  0x971d, 0x972b, 0x972c, 0x9718, 0x9723, 0x9714, 0x91b6, 0x92aa,
  0x92a5, 0x92a7, 0x92d8, 0x9303, 0x931c, 0x931b, 0x9300, 0x931e,
  0x9302, 0x9356, 0x9351, 0x936b, 0x9395, 0x9c3d, 0x9c35, 0x9c36,
  0x9c3a, 0x9c20, 0x9c34, 0x9c29, 0x9d1d, 0x9d25, 0x9d13, 0x9d16,
  0x9d2c, 0x9d17, 0x9de0, 0x9def, 0x9dfc, 0x9eb5, 0x9eb1, 0x9ef6,
  0x9ee0, 0x9f25, 0x9f9c, 0x9918, 0x992e, 0x992b, 0x9925, 0x991f,
  0x9916, 0x9ad5, 0x9ad9, 0x9b80, 0x9b91, 0x5527, 0x5512, 0x552c,
  0x553f, 0x56f8, 0x5283, 0x528d, 0x529d, 0x5288, 0x528a, 0x5282,
  0x5cd8, 0x5cde, 0x5cdc, 0x5cc3, 0x5f3d, 0x5f27, 0x5f29, 0x5f77,
  0x583a, 0x5865, 0x59b1, 0x59b7, 0x59b0, 0x59b5, 0x5a66, 0x5b41,
  0x5bb0, 0x65c4, 0x65cf, 0x65ca, 0x65eb, 0x65c6, 0x663f, 0x6639,
  0x60c3, 0x60c7, 0x60d5, 0x60ed, 0x60fd, 0x60eb, 0x60e1, 0x60fc,
  0x60ef, 0x60e0, 0x618f, 0x618e, 0x62d4, 0x62db, 0x6e8d, 0x6e99,
  0x6e89, 0x6eaf, 0x6e91, 0x6ed6, 0x6eae, 0x6e73, 0x6e9a, 0x6e9d,
  0x6ead, 0x6f51, 0x6fa3, 0x6fd7, 0x6805, 0x6bd5, 0x6bfc, 0x6bd2,
  0x6bed, 0x6bd6, 0x6be9, 0x6be6, 0x6be2, 0x6b8d, 0x6be1, 0x6bec,
  0x6be4, 0x6bd8, 0x6be3, 0x6bfd, 0x75ea, 0x75d2, 0x75e3, 0x75eb,
  0x75e8, 0x75e0, 0x75e1, 0x75f9, 0x75ed, 0x7638, 0x764b, 0x777d,
  0x777f, 0x70a4, 0x70bd, 0x70ab, 0x70a5, 0x724b, 0x724f, 0x7241,
  0x72e7, 0x73be, 0x73a7, 0x73bd, 0x73a1,
  /* 0xc1 */
  0x73aa, 0x73a0, 0x73e2, 0x7cfa, 0x7cf7, 0x7cf9, 0x7ce2, 0x7d0c,
  0x7daa, 0x7da7, 0x7e5a, 0x7eb2, 0x780a, 0x7800, 0x7ff3, 0x7ffa,
  0x7801, 0x7fed, 0x78ed, 0x78d1, 0x78d3, 0x78ef, 0x78d2, 0x78d4,
  0x78d0, 0x7a23, 0x7a33, 0x7a4b, 0x7a3a, 0x7a3f, 0x7a4e, 0x7a26,
  0x7a30, 0x7a3c, 0x7a48, 0x7a4c, 0x7a39, 0x7a34, 0x7a45, 0x7a38,
  0x7a32, 0x7a22, 0x7b49, 0x7bfe, 0x7bf1, 0x847c, 0x847f, 0x847d,
  0x8462, 0x847e, 0x85cb, 0x85ce, 0x85b7, 0x85cf, 0x85cd, 0x85b2,
  0x85b0, 0x85c4, 0x85b3, 0x85e5, 0x8604, 0x867c, 0x81a7, 0x8189,
  0x8173, 0x8191, 0x819c, 0x8199, 0x81a2, 0x8196, 0x818a, 0x81a5,
  0x8187, 0x826a, 0x83cd, 0x83dc, 0x83be, 0x83df, 0x83cb, 0x83a6,
  0x83b6, 0x83b7, 0x83c5, 0x83c6, 0x8d36, 0x8d3b, 0x8d49, 0x8d35,
  0x8d30, 0x8da1, 0x8f03, 0x8f1a, 0x8f14, 0x8f16, 0x8f07, 0x8f2d,
  0x8f10, 0x8f09, 0x8f1d, 0x884c, 0x8832, 0x887e, 0x88f7, 0x88f0,
  0x88f1, 0x88f5, 0x88f6, 0x89a5, 0x8a44, 0x8a46, 0x8a45, 0x8a47,
  0x8b49, 0x8b33, 0x8b4f, 0x8b48, 0x8b32, 0x9472, 0x9470, 0x9489,
  0x948c, 0x948f, 0x948d, 0x9534, 0x95ae, 0x9593, 0x9591, 0x9740,
  0x978f, 0x9725, 0x9778, 0x9747, 0x9768, 0x9746, 0x9715, 0x9773,
  0x9761, 0x9756, 0x977d, 0x9757, 0x9759, 0x91c7, 0x91c6, 0x91c1,
  0x91c5, 0x91cb, 0x92bc, 0x92b5, 0x92db, 0x9311, 0x9313, 0x93ad,
  0x93de, 0x9c4b, 0x9cbb, 0x9d38, 0x9e0c,
  /* 0xc2 */
  0x9df2, 0x9fa3, 0x9fa6, 0x9fa7, 0x9fa0, 0x9936, 0x9932, 0x9a86,
  0x9ac2, 0x9ad3, 0x9ad1, 0x9ad0, 0x9ad6, 0x9b33, 0x9b46, 0x57ef,
  0x5298, 0x52a3, 0x5cd4, 0x5cd5, 0x5f35, 0x5b50, 0x65ee, 0x663e,
  0x60f9, 0x60ff, 0x60f3, 0x610b, 0x60f7, 0x60f6, 0x60fa, 0x61ba,
  0x62d1, 0x632b, 0x6ebe, 0x6ea1, 0x6ece, 0x6eb6, 0x6eb5, 0x6ecf,
  0x6ea3, 0x6ea2, 0x6f52, 0x6f75, 0x6fa2, 0x7404, 0x7406, 0x6bf3,
  0x740b, 0x6bf7, 0x741c, 0x7402, 0x75f6, 0x75f1, 0x75f3, 0x75f5,
  0x777a, 0x7778, 0x70aa, 0x70b2, 0x7118, 0x725b, 0x7255, 0x725f,
  0x73b0, 0x73b2, 0x73b6, 0x73b1, 0x7d03, 0x7da3, 0x7e6c, 0x7e6f,
  0x7e6d, 0x7ec9, 0x7ec8, 0x7826, 0x782a, 0x7827, 0x7813, 0x782e,
  0x782c, 0x78ea, 0x7a59, 0x7a58, 0x7a53, 0x7a57, 0x7a6c, 0x7a5f,
  0x7a54, 0x7b45, 0x7bf4, 0x7bf6, 0x847a, 0x847b, 0x85c0, 0x85c2,
  0x8607, 0x81c2, 0x81a4, 0x81c0, 0x81dd, 0x81c4, 0x81bd, 0x81b7,
  0x81b4, 0x81ab, 0x83e2, 0x83e1, 0x83ff, 0x83ed, 0x8d8b, 0x8dbf,
  0x8df9, 0x8f25, 0x8f34, 0x8f21, 0x8f26, 0x885d, 0x8908, 0x8a54,
  0x8a6e, 0x8a6b, 0x8a69, 0x8a52, 0x8a58, 0x8acd, 0x8b44, 0x8b40,
  0x948a, 0x948e, 0x9485, 0x95a6, 0x95a1, 0x95dd, 0x9799, 0x9787,
  0x979b, 0x97af, 0x97be, 0x97a3, 0x97a1, 0x97bd, 0x9795, 0x9797,
  0x979a, 0x91d9, 0x91db, 0x91dd, 0x91d8, 0x92ef, 0x92d1, 0x92d4,
  0x92d6, 0x92d3, 0x9329, 0x93ae, 0x93ab,
  /* 0xc3 */
  0x93a0, 0x93f4, 0x9c40, 0x9c42, 0x9c41, 0x9c43, 0x9c5e, 0x9cb7,
  0x9d33, 0x9d32, 0x9d30, 0x9d23, 0x9da8, 0x9e03, 0x9ecc, 0x9f0e,
  0x9f0b, 0x9f42, 0x9f43, 0x9f40, 0x9fc7, 0x9fc4, 0x9ff0, 0x9fc5,
  0x9fcd, 0x995c, 0x9950, 0x996d, 0x9aed, 0x9b18, 0x9b21, 0x553e,
  0x52a8, 0x5cd3, 0x5cd2, 0x5cef, 0x5ff8, 0x9b9d, 0x5ae1, 0x65ff,
  0x65fa, 0x65fb, 0x65f8, 0x610d, 0x6102, 0x62ed, 0x62d0, 0x6ee8,
  0x6ed0, 0x6ed7, 0x6ede, 0x7416, 0x7412, 0x7425, 0x7417, 0x7410,
  0x7418, 0x7415, 0x760b, 0x7600, 0x7655, 0x76af, 0x7775, 0x7777,
  0x70b0, 0x70c7, 0x70ee, 0x718a, 0x718b, 0x7252, 0x726c, 0x73ca,
  0x7d14, 0x7dbc, 0x7e66, 0x7e64, 0x7833, 0x7832, 0x7835, 0x7830,
  0x783a, 0x784d, 0x7a66, 0x7a60, 0x7a74, 0x7a64, 0x7a67, 0x7b88,
  0x7a7e, 0x7bbb, 0x7bb4, 0x7bb5, 0x85d5, 0x81e4, 0x81d0, 0x81e7,
  0x81d8, 0x81e9, 0x81e8, 0x81fa, 0x83f6, 0x8c08, 0x8c00, 0x83f4,
  0x83f3, 0x8d6d, 0x8d52, 0x8d5b, 0x8d53, 0x8f4c, 0x8f51, 0x8f55,
  0x8f44, 0x8f57, 0x8f43, 0x8f42, 0x8f4b, 0x8f54, 0x8905, 0x8907,
  0x8a71, 0x8a7f, 0x8a8a, 0x8a7b, 0x8a61, 0x8a77, 0x8a79, 0x8b59,
  0x8b43, 0x8ba0, 0x9487, 0x9486, 0x95bc, 0x95a3, 0x97ec, 0x97dc,
  0x97d2, 0x97ce, 0x97c5, 0x97d1, 0x97d0, 0x97db, 0x97ef, 0x97c0,
  0x97d5, 0x97e9, 0x97da, 0x97e5, 0x91d1, 0x92b9, 0x92ee, 0x9327,
  0x932a, 0x936c, 0x93d1, 0x93f6, 0x9c53,
  /* 0xc4 */
  0x9c55, 0x9c56, 0x9cb1, 0x9d48, 0x9d44, 0x9e1b, 0x9e14, 0x9f00,
  0x9fe5, 0x9fea, 0x9fdb, 0x9fd6, 0x9984, 0x996c, 0x997f, 0x9967,
  0x9961, 0x9a9f, 0x9a9a, 0x9a9e, 0x9ab9, 0x56f5, 0x52a5, 0x52ba,
  0x52bb, 0x52b9, 0x52b1, 0x5ce9, 0x5f4d, 0x5f4e, 0x5f70, 0x5ffb,
  0x59c4, 0x65f5, 0x65f7, 0x6115, 0x6119, 0x6114, 0x62eb, 0x632a,
  0x6ee1, 0x7433, 0x743d, 0x743f, 0x761d, 0x7776, 0x70c2, 0x726f,
  0x7268, 0x7d2b, 0x7d27, 0x7d21, 0x7d26, 0x7eca, 0x7efb, 0x7841,
  0x784e, 0x7840, 0x78e2, 0x78fd, 0x8ba3, 0x7a70, 0x7a71, 0x7a8f,
  0x7b41, 0x840d, 0x85d7, 0x866b, 0x81f6, 0x81f4, 0x821c, 0x81f7,
  0x820b, 0x8206, 0x820a, 0x8207, 0x8c19, 0x8c18, 0x8d69, 0x8db7,
  0x8df5, 0x8f7d, 0x8f61, 0x8f6b, 0x8f62, 0x8f52, 0x8f66, 0x8902,
  0x8900, 0x8a84, 0x8a8c, 0x8a88, 0x8a8f, 0x95b9, 0x95c6, 0x9015,
  0x900e, 0x97f0, 0x91ec, 0x933d, 0x9cc9, 0x9d5f, 0x9d5c, 0x9da5,
  0x9e26, 0x9e3d, 0x9e3a, 0x9e38, 0x981e, 0x9800, 0x9a74, 0x9ab8,
  0x9ae5, 0x9b22, 0x9b52, 0x9b6e, 0x9b6c, 0x553a, 0x5535, 0x52cc,
  0x52cd, 0x52cf, 0x5d19, 0x5861, 0x59c0, 0x65f1, 0x65f3, 0x6110,
  0x6111, 0x6198, 0x62e4, 0x6ef6, 0x6f09, 0x6ef7, 0x6fbf, 0x7441,
  0x7616, 0x76aa, 0x70db, 0x70d9, 0x7264, 0x73de, 0x785d, 0x7a82,
  0x7a81, 0x7bb1, 0x821a, 0x8220, 0x8217, 0x8c2e, 0x8c2f, 0x8c2c,
  0x8c12, 0x8d67, 0x8d61, 0x8db0, 0x8f79,
  /* 0xc5 */
  0x8f7a, 0x8f70, 0x891e, 0x8a87, 0x8a80, 0x8a86, 0x8b52, 0x8ba2,
  0x95b7, 0x9023, 0x903e, 0x9038, 0x9037, 0x9035, 0x903f, 0x9026,
  0x91ef, 0x9335, 0x9334, 0x933f, 0x93f2, 0x9c6a, 0x9c68, 0x9d5a,
  0x9e48, 0x9e4e, 0x9e4d, 0x9e33, 0x9ec2, 0x9f59, 0x9f5c, 0x9820,
  0x9828, 0x99a2, 0x99b9, 0x99cf, 0x99b5, 0x9a90, 0x9ae2, 0x9b14,
  0x9b51, 0x9b6b, 0x9b6a, 0x5531, 0x5536, 0x52c5, 0x52c7, 0x52c4,
  0x5f72, 0x59d9, 0x59df, 0x5b43, 0x65f2, 0x6129, 0x6f07, 0x6f6c,
  0x745c, 0x7455, 0x778d, 0x70e9, 0x7187, 0x7263, 0x7261, 0x7dbe,
  0x786d, 0x7852, 0x8473, 0x8470, 0x85d2, 0x8d7f, 0x8d62, 0x8df1,
  0x8f8d, 0x891b, 0x891a, 0x8a9c, 0x8a9e, 0x8b6c, 0x9545, 0x9049,
  0x905c, 0x905f, 0x9330, 0x9333, 0x93ce, 0x93cc, 0x9c66, 0x9d58,
  0x9e58, 0x9e40, 0x9edf, 0x9f17, 0x9844, 0x983c, 0x9833, 0x9836,
  0x99de, 0x99da, 0x9b39, 0x9b61, 0x9b67, 0x9b99, 0x52c1, 0x59db,
  0x660d, 0x612e, 0x6126, 0x6127, 0x62e1, 0x6f1d, 0x70d7, 0x7ec7,
  0x7869, 0x786e, 0x7868, 0x7a9e, 0x7a9b, 0x7a99, 0x85ef, 0x8235,
  0x8232, 0x8c3c, 0x8f87, 0x949d, 0x9482, 0x906e, 0x906d, 0x9069,
  0x9365, 0x9c62, 0x9d51, 0x9e57, 0x9e56, 0x9e5a, 0x9ede, 0x9ed9,
  0x9edc, 0x9859, 0x985a, 0x985b, 0x99e8, 0x9a92, 0x9af9, 0x52dc,
  0x5ce4, 0x6121, 0x7453, 0x727c, 0x727f, 0x73da, 0x7b5d, 0x7b85,
  0x8c3b, 0x8c34, 0x8c6f, 0x8f9e, 0x8f9f,
  /* 0xc6 */
  0x8f9b, 0x867a, 0x8916, 0x95cd, 0x9067, 0x934f, 0x9345, 0x9349,
  0x93cb, 0x9c7d, 0x9e52, 0x9f2f, 0x9f55, 0x9852, 0x99f4, 0x99f7,
  0x9a71, 0x9a70, 0x9b0a, 0x9b7a, 0x9b7f, 0x5afe, 0x6f1b, 0x746e,
  0x7861, 0x7863, 0x8c36, 0x8dcd, 0x8aac, 0x95cc, 0x907f, 0x907d,
  0x9c7c, 0x9d53, 0x9edb, 0x9f2e, 0x9ac1, 0x7469, 0x73d7, 0x8f97,
  0x907a, 0x93c4, 0x9e6f, 0x9e68, 0x7a91, 0x8f91, 0x8aa7, 0x95c8,
  0x9070, 0x9073, 0x9071, 0x987a, 0x9875, 0x9afa, 0x8859, 0x9072,
  0x9a17, 0x7625, 0x9e67, 0x9f3c, 0x9a16, 0x9a13, 0x787f, 0x34f3,
  0x3490, 0x3493, 0x3408, 0x344c, 0x344f, 0x344e, 0x3449, 0x3448,
  0x344b, 0x344a, 0x3445, 0x3444, 0x3447, 0x3446, 0x3441, 0x3440,
  0x3443, 0x3442, 0x345d, 0x345c, 0x345f, 0x345e, 0x3459, 0x3458,
  0x345b, 0x345a, 0x3455, 0x3454, 0x3457, 0x3456, 0x3451, 0x3450,
  0x3453, 0x3452, 0x346d, 0x346c, 0x346f, 0x346e, 0x3469, 0x3468,
  0x346b, 0x346a, 0x3465, 0x3464, 0x3467, 0x3466, 0x3461, 0x3460,
  0x3463, 0x3462, 0x347d, 0x347c, 0x347f, 0x347e, 0x3479, 0x3478,
  0x347b, 0x347a, 0x3475, 0x3474, 0x3477, 0x3476, 0x3471, 0x3470,
  0x3473, 0x3472, 0x348d, 0x348c, 0x348f, 0x348e, 0x3489, 0x3488,
  0x348b, 0x348a, 0x3485, 0x3484, 0x3487, 0x3486, 0x3481, 0x3480,
  0x3483, 0x3482, 0x349d, 0x349c, 0x349f, 0x349e, 0x34ac, 0x34af,
  0x34ae, 0x34a9, 0x34a8, 0x34ab, 0x34aa,
  /* 0xc7 */
  0x34a5, 0x34a4, 0x34a7, 0x34a6, 0x34a1, 0x34a0, 0x34a3, 0x34a2,
  0x34bd, 0x34bc, 0x34bf, 0x34be, 0x34b9, 0x34b8, 0x34bb, 0x34ba,
  0x34b5, 0x34b4, 0x34b7, 0x34b6, 0x34b1, 0x34b0, 0x34b3, 0x34b2,
  0x34cd, 0x34cc, 0x34cf, 0x34ce, 0x34c9, 0x34c8, 0x34cb, 0x34ca,
  0x34c5, 0x34c4, 0x34c7, 0x34c6, 0x34c1, 0x34c0, 0x34c3, 0x34c2,
  0x34dd, 0x34dc, 0x34df, 0x34de, 0x34d9, 0x34d8, 0x34db, 0x34da,
  0x34d5, 0x34d4, 0x34d7, 0x34d6, 0x34d1, 0x34d0, 0x34d3, 0x34d2,
  0x34ed, 0x34ec, 0x34ef, 0x34ee, 0x34e9, 0x34e8, 0x34eb, 0x34ea,
  0x34e5, 0x34e4, 0x34e7, 0x34e6, 0x34e1, 0x34e0, 0x34e3, 0x34e2,
  0x34fd, 0x34fc, 0x34ff, 0x34fe, 0x34f9, 0x34f8, 0x34fb, 0x0019,
  0x0018, 0x000c, 0x001b, 0x001a, 0x0015, 0x0014, 0x0017, 0x0016,
  0x0011, 0x002e, 0x0029, 0x0028, 0x002b, 0x002a, 0x0025, 0x0024,
  0x0027, 0x0026, 0x0021, 0x0020, 0x0023, 0x0022, 0x003d, 0x003c,
  0x003f, 0x003e, 0x0039, 0x0038, 0x005c, 0x003b, 0x003a, 0x0035,
  0x0034, 0x0037, 0x0036, 0x0031, 0x0030, 0x0033, 0x0032, 0x004d,
  0x004c, 0x004f, 0x004e, 0x0049, 0x0048, 0x004b, 0x004a, 0x0045,
  0x0044, 0x0047, 0x0046, 0x0041, 0x0040, 0x0043, 0x0042, 0x206d,
  0x206c, 0x206f, 0x206e, 0x2069, 0x2068, 0x206b, 0x206a, 0x2065,
  0x2064, 0x2079, 0x2078, 0x207b, 0x207a, 0x2075, 0x2074, 0x2077,
  0x2076, 0x2071, 0x2070
};

static const acp_uint16_t big5_2uni_pagec9[ /*7652*/ ] = {
  /* 0xc9 */
  0x4a4f, 0x4a51, 0x55f8, 0x5717, 0x578f, 0x4a0a, 0x4a01, 0x4a4a,
  0x4a80, 0x52da, 0xfe01, 0x5863, 0x5b7e, 0x4a02, 0x558a, 0x4a03,
  0x4a23, 0x4a9e, 0x4acf, 0x4ac4, 0x4ac5, 0x5595, 0x56f1, 0x5761,
  0x57b4, 0x532d, 0x5d0e, 0x5d21, 0x581d, 0x59f2, 0x61ec, 0x6fbe,
  0x6fc1, 0x6819, 0x7632, 0x4a3c, 0x4a31, 0x4ae5, 0x4ad1, 0x4ae4,
  0x4aec, 0x4ad0, 0x4ad7, 0x5601, 0x5711, 0x5741, 0x532f, 0x532e,
  0x5d1a, 0x5d22, 0x5f8c, 0x5f89, 0x581f, 0x5836, 0x5879, 0x587e,
  0x5a09, 0x5a8d, 0x5a8f, 0x5bc4, 0x6604, 0x665d, 0x6818, 0x683b,
  0x684e, 0x6832, 0x6836, 0x76a3, 0x76bd, 0x7787, 0x7db5, 0x8487,
  0x9213, 0x4b03, 0x4b15, 0x4b21, 0x4af8, 0x4b19, 0x4afc, 0x4b0d,
  0x4afa, 0x4b05, 0x4b10, 0x4b0f, 0x4b08, 0x4b2f, 0x4b1e, 0x4b09,
  0x4af9, 0x4b1f, 0x55bc, 0x561e, 0x5604, 0x561d, 0x56ab, 0x572f,
  0x5712, 0x5740, 0x5787, 0x500a, 0x52ec, 0x52d2, 0x5323, 0x5327,
  0x5339, 0x5d31, 0x5d8d, 0x5d71, 0x5d88, 0x5d76, 0x5d73, 0x5d7a,
  0x5d72, 0x5f5b, 0x5818, 0x5828, 0x5871, 0x5877, 0x5876, 0x5873,
  0x59d2, 0x5a78, 0x5a89, 0x5b0f, 0x5b17, 0x5b79, 0x5bd8, 0x5bd9,
  0x5bc2, 0x6651, 0x6653, 0x6669, 0x666c, 0x666b, 0x666f, 0x6654,
  0x666d, 0x6657, 0x6668, 0x61e2, 0x61e3, 0x6333, 0x6334, 0x6335,
  0x6336, 0x6337, 0x6332, 0x6331, 0x633e, 0x6815, 0x684b, 0x685f,
  0x6851, 0x6842, 0x6847, 0x6859, 0x6846,
  /* 0xca */
  0x6841, 0x747c, 0x7653, 0x76b9, 0x76b8, 0x7783, 0x7127, 0x7272,
  0x7e78, 0x7b5c, 0x8675, 0x8671, 0x868d, 0x8670, 0x8672, 0x8240,
  0x8d73, 0x9494, 0x949a, 0x9495, 0x9496, 0x9499, 0x922f, 0x9229,
  0x922d, 0x922e, 0x4b5b, 0x4b36, 0x4b6f, 0x4b44, 0x4b5e, 0x4b69,
  0x4b33, 0x4b6a, 0x4b5f, 0x4b52, 0x4b4c, 0x4b55, 0x4b20, 0x4b3e,
  0x4b32, 0x4b6c, 0x5582, 0x55b4, 0x5611, 0x5613, 0x562c, 0x56a0,
  0x56a3, 0x5704, 0x576e, 0x577f, 0x5783, 0x5782, 0x503d, 0x503a,
  0x5027, 0x5059, 0x5048, 0x5014, 0x5011, 0x5028, 0x5015, 0x5030,
  0x5042, 0x504c, 0x5025, 0x5029, 0x504a, 0x52e3, 0x52ea, 0x52e8,
  0x534c, 0x5348, 0x5341, 0x5344, 0x5346, 0x535f, 0x5d0b, 0x5d4d,
  0x5dab, 0x5d95, 0x5dad, 0x5d9a, 0x5d83, 0x5daf, 0x5d9d, 0x5d82,
  0x5daa, 0x5dac, 0x5f83, 0x5f9f, 0x5825, 0x5827, 0x5880, 0x5882,
  0x5885, 0x5886, 0x5884, 0x589f, 0x5887, 0x588b, 0x589e, 0x5898,
  0x59ed, 0x5a07, 0x5a03, 0x5a86, 0x5a84, 0x5a81, 0x5a85, 0x5a80,
  0x5b08, 0x5b10, 0x5b75, 0x5b7b, 0x5bdf, 0x5bdc, 0x5bdd, 0x5be0,
  0x5be5, 0x5be3, 0x5bfe, 0x5bec, 0x5be9, 0x5bee, 0x5bf7, 0x5be2,
  0x5bfa, 0x5bf6, 0x640d, 0x5bf9, 0x6637, 0x668e, 0x6681, 0x6683,
  0x6682, 0x6699, 0x668a, 0x667c, 0x6676, 0x6677, 0x667d, 0x668c,
  0x6685, 0x667a, 0x6670, 0x667f, 0x6679, 0x613a, 0x61fd, 0x61f9,
  0x61fe, 0x61ff, 0x61f8, 0x6348, 0x634a,
  /* 0xcb */
  0x6354, 0x6358, 0x6341, 0x6345, 0x6350, 0x6340, 0x6357, 0x6346,
  0x6fdd, 0x6814, 0x6817, 0x6875, 0x686a, 0x6866, 0x6889, 0x6886,
  0x6882, 0x687c, 0x6862, 0x6864, 0x6897, 0x6860, 0x688a, 0x6898,
  0x6891, 0x686b, 0x687e, 0x6868, 0x6876, 0x6883, 0x7479, 0x7477,
  0x766e, 0x76b2, 0x76b0, 0x76ce, 0x76cb, 0x76cc, 0x76b7, 0x76c8,
  0x7798, 0x779a, 0x779e, 0x7799, 0x779f, 0x7137, 0x7134, 0x7199,
  0x7198, 0x728c, 0x7d30, 0x8439, 0x8498, 0x8494, 0x849d, 0x849f,
  0x8491, 0x869d, 0x8682, 0x8688, 0x8683, 0x869c, 0x869e, 0x8687,
  0x868e, 0x8689, 0x8875, 0x8bc4, 0x8bb2, 0x9492, 0x94ac, 0x94a8,
  0x9493, 0x94aa, 0x94ad, 0x923d, 0x9225, 0x9222, 0x9220, 0x4a3e,
  0x4b95, 0x4b71, 0x4b88, 0x4b70, 0x4b8d, 0x4b8a, 0x4b7b, 0x4b79,
  0x4b84, 0x4b89, 0x4b7a, 0x4b41, 0x4b9a, 0x4b67, 0x4b97, 0x4b74,
  0x4b8c, 0x4b75, 0x4b9d, 0x4b91, 0x4b99, 0x4b93, 0x4b9f, 0x4b8f,
  0x4b98, 0x4b66, 0x4b63, 0x5593, 0x55b1, 0x55b3, 0x5638, 0x563f,
  0x563e, 0x564b, 0x563c, 0x56b1, 0x5707, 0x5706, 0x5731, 0x579f,
  0x5799, 0x508a, 0x5072, 0x508c, 0x509c, 0x508f, 0x5085, 0x5066,
  0x5077, 0x5073, 0x5068, 0x5061, 0x5079, 0x506b, 0x5080, 0x5062,
  0x506c, 0x506d, 0x5095, 0x506e, 0x506a, 0x5069, 0x52fa, 0x52f4,
  0x5362, 0x537f, 0x5360, 0x5366, 0x537c, 0x537d, 0x537b, 0x538d,
  0x5378, 0x5376, 0x537e, 0x5379, 0x536f,
  /* 0xcc */
  0x5365, 0x5370, 0x5d01, 0x5d48, 0x5db8, 0x5db7, 0x5dc2, 0x5dc3,
  0x5dbf, 0x5dc1, 0x5dcc, 0x5dbb, 0x5db1, 0x5dce, 0x5ddb, 0x5dbc,
  0x5db0, 0x5dcd, 0x5dc5, 0x5db9, 0x5dca, 0x5f6f, 0x5f68, 0x5f9e,
  0x5f98, 0x5849, 0x584a, 0x58a3, 0x58a9, 0x58ad, 0x58b8, 0x58a2,
  0x58a5, 0x58a1, 0x5892, 0x58ae, 0x58a0, 0x58af, 0x58a7, 0x58aa,
  0x5890, 0x58a8, 0x58bb, 0x58bd, 0x58ab, 0x5a1a, 0x5a19, 0x5a14,
  0x5b25, 0x5b2f, 0x5b2e, 0x5b29, 0x5b59, 0x5b8f, 0x5b73, 0x5b70,
  0x5bd3, 0x5be8, 0x6420, 0x642b, 0x6414, 0x643f, 0x6406, 0x6439,
  0x6407, 0x641a, 0x643e, 0x6417, 0x6413, 0x6421, 0x642f, 0x6400,
  0x641d, 0x6423, 0x641e, 0x641c, 0x6401, 0x6404, 0x6411, 0x6619,
  0x6630, 0x66a0, 0x66b9, 0x66dc, 0x66b3, 0x66a7, 0x66bb, 0x66c7,
  0x66a3, 0x66be, 0x66a2, 0x66b6, 0x66a4, 0x66bd, 0x66b5, 0x6130,
  0x61a5, 0x61b6, 0x6204, 0x61f1, 0x6209, 0x621f, 0x6205, 0x61f6,
  0x620e, 0x6206, 0x6200, 0x6208, 0x61f0, 0x621c, 0x621d, 0x62fb,
  0x6307, 0x6388, 0x6361, 0x6383, 0x639f, 0x637b, 0x6376, 0x6395,
  0x638b, 0x6389, 0x6379, 0x6380, 0x6381, 0x6377, 0x6392, 0x639c,
  0x6394, 0x638e, 0x6370, 0x638c, 0x6375, 0x6374, 0x6399, 0x6f28,
  0x6f8d, 0x6f73, 0x6fd3, 0x6810, 0x689e, 0x68e1, 0x68e6, 0x68e3,
  0x68d4, 0x68bb, 0x68d9, 0x68a0, 0x68ea, 0x68ba, 0x68dd, 0x68cf,
  0x68b7, 0x68ce, 0x68cb, 0x68e0, 0x68ff,
  /* 0xcd */
  0x68df, 0x68d0, 0x68b9, 0x6887, 0x6890, 0x688d, 0x68d3, 0x68cd,
  0x693d, 0x68c0, 0x68ca, 0x68bd, 0x68f4, 0x68c2, 0x68e4, 0x68dc,
  0x7499, 0x7495, 0x7488, 0x749e, 0x748b, 0x7489, 0x749c, 0x749b,
  0x748f, 0x7497, 0x748e, 0x7667, 0x76db, 0x76c6, 0x76d5, 0x76c4,
  0x76d1, 0x76df, 0x76d9, 0x76d7, 0x76c1, 0x76dc, 0x77a9, 0x77ac,
  0x77a0, 0x77ab, 0x77af, 0x77ad, 0x77a1, 0x7790, 0x70d0, 0x70e5,
  0x7132, 0x714d, 0x7133, 0x7181, 0x7195, 0x72a2, 0x72fe, 0x72fc,
  0x72fd, 0x72f8, 0x73f5, 0x73f1, 0x73f4, 0x73f6, 0x73f7, 0x73fa,
  0x7d4f, 0x7d32, 0x7dc8, 0x7e75, 0x7e76, 0x7ef6, 0x7878, 0x78f0,
  0x8438, 0x8482, 0x84a3, 0x84ae, 0x84b5, 0x84b8, 0x84a0, 0x862d,
  0x86ad, 0x86cd, 0x86a6, 0x8697, 0x8695, 0x8696, 0x86b8, 0x86aa,
  0x86a3, 0x86b1, 0x8693, 0x86b7, 0x86b9, 0x86a5, 0x86ac, 0x86a4,
  0x86cf, 0x86a9, 0x86ce, 0x86bb, 0x86af, 0x827d, 0x8262, 0x8260,
  0x8263, 0x885b, 0x8bdf, 0x8bc6, 0x8bde, 0x8bc0, 0x8bdb, 0x8bd8,
  0x8bda, 0x94bf, 0x94b9, 0x94a2, 0x94be, 0x94bd, 0x9234, 0x9230,
  0x9231, 0x9237, 0x924e, 0x4bc0, 0x4bc8, 0x4bde, 0x4bbf, 0x4bc4,
  0x4bc6, 0x4bcc, 0x4bd9, 0x4bd1, 0x4bd4, 0x4bb6, 0x4bbe, 0x4bd6,
  0x4bca, 0x4bdb, 0x4bb7, 0x4bcd, 0x4bb4, 0x4be1, 0x5649, 0x5644,
  0x56cd, 0x56cf, 0x5730, 0x5771, 0x579a, 0x579b, 0x5794, 0x5795,
  0x50b7, 0x50ac, 0x50a0, 0x50a8, 0x50c2,
  /* 0xce */
  0x50ce, 0x8700, 0x50ba, 0x50a3, 0x50db, 0x50bb, 0x50c8, 0x50cb,
  0x50ad, 0x507d, 0x50b1, 0x50af, 0x50b3, 0x507f, 0x50d3, 0x50bd,
  0x53b8, 0x5393, 0x5392, 0x53a9, 0x5381, 0x539a, 0x5390, 0x5396,
  0x5399, 0x5395, 0x5382, 0x5394, 0x53a8, 0x5397, 0x5398, 0x5cf9,
  0x5d00, 0x5d5e, 0x5dec, 0x5dd3, 0x5de3, 0x5e0d, 0x5dfc, 0x5dd0,
  0x5df7, 0x5df0, 0x5df1, 0x5dfb, 0x5de9, 0x5dff, 0x5dfa, 0x5dd6,
  0x5de4, 0x5dfe, 0x5df8, 0x5ded, 0x5df3, 0x5df9, 0x5de0, 0x5fa5,
  0x5841, 0x58dd, 0x58d5, 0x58c1, 0x58da, 0x58c6, 0x58d6, 0x58d3,
  0x58d7, 0x58c4, 0x58ca, 0x58c7, 0x58db, 0x58de, 0x58d9, 0x58c2,
  0x58c5, 0x58cb, 0x58c3, 0x58d2, 0x58f5, 0x59f4, 0x5a2c, 0x5a2f,
  0x5a2e, 0x5a2d, 0x5a29, 0x5abd, 0x5aa9, 0x5aaf, 0x5a96, 0x5aae,
  0x5aa8, 0x5b0a, 0x5b23, 0x5b5b, 0x5b8b, 0x643a, 0x6434, 0x6459,
  0x647f, 0x6453, 0x6448, 0x645e, 0x644a, 0x6444, 0x6456, 0x6441,
  0x644d, 0x644f, 0x6452, 0x6429, 0x6449, 0x6455, 0x646b, 0x6463,
  0x664f, 0x664e, 0x66c2, 0x6700, 0x6706, 0x66f8, 0x6703, 0x670e,
  0x66e6, 0x66f4, 0x6702, 0x6701, 0x66f5, 0x66fb, 0x670d, 0x671e,
  0x6719, 0x66f7, 0x6718, 0x66f6, 0x66fd, 0x614c, 0x614e, 0x61a7,
  0x61b2, 0x623b, 0x622c, 0x623f, 0x6238, 0x6211, 0x622b, 0x622f,
  0x623e, 0x6226, 0x6237, 0x6210, 0x6239, 0x6234, 0x6223, 0x6302,
  0x631d, 0x63cc, 0x63ff, 0x63c5, 0x63b7,
  /* 0xcf */
  0x63d1, 0x63b6, 0x63f5, 0x63d5, 0x63cd, 0x63ba, 0x63c8, 0x63e6,
  0x63e9, 0x63d2, 0x63b8, 0x63c0, 0x63be, 0x63fa, 0x63fb, 0x63e3,
  0x63ee, 0x63cf, 0x63b4, 0x63c3, 0x63ea, 0x63fd, 0x63bf, 0x63f1,
  0x63cb, 0x63e0, 0x63c1, 0x63a3, 0x63eb, 0x63d6, 0x63f7, 0x63c4,
  0x63c7, 0x63ce, 0x63e7, 0x63c6, 0x6f25, 0x6f8f, 0x6f89, 0x6fbb,
  0x6fdb, 0x6fd5, 0x6fed, 0x682d, 0x682c, 0x6925, 0x6939, 0x6920,
  0x6912, 0x6931, 0x6932, 0x691f, 0x6907, 0x68d7, 0x693e, 0x6909,
  0x6914, 0x6937, 0x6917, 0x691c, 0x690d, 0x6910, 0x694f, 0x690c,
  0x6915, 0x693a, 0x690e, 0x6902, 0x694d, 0x690a, 0x692d, 0x6921,
  0x6905, 0x692f, 0x6904, 0x691d, 0x74ba, 0x7492, 0x74b3, 0x74bc,
  0x74bd, 0x74ac, 0x74b9, 0x74b8, 0x74a4, 0x764c, 0x7644, 0x7647,
  0x7661, 0x767d, 0x767e, 0x7663, 0x76c7, 0x76e9, 0x76e5, 0x76e6,
  0x76d2, 0x76e7, 0x76eb, 0x76ee, 0x7788, 0x77c1, 0x77cf, 0x77c5,
  0x77c8, 0x77b4, 0x77bb, 0x77b8, 0x77b9, 0x77e6, 0x77b2, 0x77ca,
  0x77b3, 0x77ce, 0x77cb, 0x77b5, 0x77c6, 0x70e1, 0x70e3, 0x7123,
  0x714a, 0x7145, 0x71aa, 0x71a7, 0x7274, 0x72c9, 0x7305, 0x730e,
  0x7309, 0x7308, 0x7307, 0x72fa, 0x72f6, 0x72f7, 0x73ea, 0x73e5,
  0x7c0b, 0x7c1c, 0x7c1f, 0x7c08, 0x7c1d, 0x7c02, 0x7c03, 0x7c04,
  0x7c0e, 0x7c1e, 0x7d47, 0x7d41, 0x7d46, 0x7d48, 0x7d49, 0x7dd8,
  0x7dc0, 0x7dc2, 0x7ddb, 0x7dc3, 0x7e8d,
  /* 0xd0 */
  0x7e73, 0x7edc, 0x7f0d, 0x7f0c, 0x7877, 0x7875, 0x7874, 0x7872,
  0x788d, 0x788c, 0x790e, 0x7905, 0x790c, 0x7b55, 0x7b9c, 0x7b80,
  0x7bb3, 0x840a, 0x8403, 0x8402, 0x8419, 0x843a, 0x84d5, 0x84ca,
  0x84ed, 0x84dc, 0x84c5, 0x84cf, 0x84dd, 0x84c8, 0x84ee, 0x84d4,
  0x84d1, 0x84c7, 0x84d8, 0x84c4, 0x84c2, 0x84da, 0x84eb, 0x84c0,
  0x85f2, 0x862c, 0x8699, 0x86d4, 0x86f3, 0x86f4, 0x870a, 0x86e5,
  0x870d, 0x86d8, 0x8737, 0x86e6, 0x86db, 0x86f9, 0x86e1, 0x86ec,
  0x86ff, 0x86f8, 0x8701, 0x86f6, 0x86fb, 0x86fd, 0x86e7, 0x86e9,
  0x86ed, 0x86f7, 0x86fe, 0x86e0, 0x827a, 0x8279, 0x8271, 0x827e,
  0x8c4c, 0x8c43, 0x8c6a, 0x8c67, 0x8c64, 0x8dde, 0x8e09, 0x8e0a,
  0x897f, 0x8bee, 0x8bec, 0x8be3, 0x8bed, 0x94fc, 0x94b0, 0x94b2,
  0x94d8, 0x94c8, 0x94b3, 0x94ca, 0x94c6, 0x94c5, 0x95d9, 0x95de,
  0x9259, 0x9242, 0x925c, 0x925e, 0x9247, 0x9243, 0x5413, 0x5408,
  0x540a, 0x541e, 0x542f, 0x543d, 0x5416, 0x4bf8, 0x4bf9, 0x543e,
  0x543a, 0x5421, 0x4bfb, 0x4bfa, 0x541a, 0x5411, 0x542d, 0x542a,
  0x5438, 0x5422, 0x543c, 0x5403, 0x5557, 0x5599, 0x559e, 0x55c7,
  0x55c9, 0x55c8, 0x55c5, 0x55c3, 0x566c, 0x5657, 0x565f, 0x5653,
  0x5652, 0x5658, 0x566f, 0x56c0, 0x5703, 0x5793, 0x512b, 0x50ef,
  0x511a, 0x511f, 0x50ea, 0x50fe, 0x50e9, 0x5117, 0x50f2, 0x5109,
  0x5105, 0x50e6, 0x511c, 0x5108, 0x50fc,
  /* 0xd1 */
  0x5107, 0x50f6, 0x50fa, 0x50f5, 0x50ed, 0x5103, 0x510e, 0x5106,
  0x530c, 0x530f, 0x53c1, 0x5c3f, 0x53d8, 0x53df, 0x53b7, 0x53cb,
  0x53b0, 0x53b1, 0x53b5, 0x53bb, 0x53b2, 0x53ca, 0x53dd, 0x53b4,
  0x53cc, 0x5d03, 0x5d47, 0x5e14, 0x5e1b, 0x5e20, 0x5e23, 0x5e18,
  0x5e02, 0x5e1a, 0x5e07, 0x5e13, 0x5e3e, 0x5f61, 0x5faa, 0x5fa0,
  0x5fa1, 0x580e, 0x585b, 0x5859, 0x58e1, 0x58f2, 0x58e3, 0x58fc,
  0x58fa, 0x590d, 0x58f4, 0x5a24, 0x5a25, 0x5aa5, 0x5aa3, 0x5aa7,
  0x5aa1, 0x5b3e, 0x5b3d, 0x5b6a, 0x6450, 0x6457, 0x646a, 0x644c,
  0x64af, 0x6485, 0x648d, 0x649f, 0x648c, 0x6490, 0x648e, 0x6498,
  0x6496, 0x649a, 0x648a, 0x6491, 0x6483, 0x6614, 0x664b, 0x66ff,
  0x671d, 0x675b, 0x6721, 0x6749, 0x6748, 0x673b, 0x674e, 0x67e9,
  0x6734, 0x6746, 0x6747, 0x6731, 0x6724, 0x674c, 0x6739, 0x6755,
  0x6759, 0x6754, 0x6720, 0x674a, 0x673e, 0x6757, 0x675c, 0x6735,
  0x675a, 0x674d, 0x6745, 0x6147, 0x614b, 0x61cb, 0x61ce, 0x61c9,
  0x61cf, 0x6247, 0x6252, 0x624a, 0x625c, 0x631f, 0x631e, 0x6c12,
  0x6c17, 0x6c44, 0x6c3f, 0x6c3e, 0x6c36, 0x6c46, 0x6c42, 0x6c1b,
  0x6c3c, 0x6c11, 0x6c38, 0x6c26, 0x6c20, 0x6c22, 0x6c43, 0x6c49,
  0x6c39, 0x6c10, 0x6c1f, 0x6c19, 0x6c2b, 0x6c25, 0x6c23, 0x6c40,
  0x6c37, 0x6c28, 0x6c2d, 0x6f21, 0x6f22, 0x6f20, 0x6f3c, 0x6f39,
  0x6f60, 0x848f, 0x6f85, 0x6feb, 0x6fe9,
  /* 0xd2 */
  0x6fe5, 0x6fee, 0x6fef, 0x6fea, 0x6828, 0x6977, 0x696e, 0x6969,
  0x697b, 0x6900, 0x696c, 0x699f, 0x6955, 0x696f, 0x6960, 0x6962,
  0x699c, 0x6980, 0x69e2, 0x6972, 0x698b, 0x6953, 0x696a, 0x696d,
  0x699a, 0x697d, 0x6971, 0x6952, 0x698f, 0x6995, 0x6922, 0x6965,
  0x6986, 0x6973, 0x698d, 0x6989, 0x691b, 0x698e, 0x6976, 0x6970,
  0x6978, 0x699d, 0x74d1, 0x74de, 0x74dc, 0x74d0, 0x74c6, 0x7b34,
  0x74ef, 0x74da, 0x74df, 0x74d3, 0x74ed, 0x74d9, 0x74c0, 0x74c8,
  0x74cb, 0x74ca, 0x74d7, 0x74c3, 0x74ec, 0x764f, 0x7675, 0x767a,
  0x767b, 0x770d, 0x76f7, 0x76f9, 0x76f3, 0x76fb, 0x76fe, 0x76f6,
  0x770c, 0x77de, 0x77d4, 0x77e8, 0x77db, 0x77b1, 0x77ea, 0x77ee,
  0x77e4, 0x77d1, 0x77df, 0x77d6, 0x77d9, 0x77d0, 0x77d7, 0x77da,
  0x77d5, 0x77e5, 0x70d3, 0x70d2, 0x70f9, 0x70f8, 0x712c, 0x7156,
  0x7152, 0x71bd, 0x71cc, 0x71b6, 0x71c9, 0x71cd, 0x71b2, 0x71bb,
  0x71b7, 0x7287, 0x72c4, 0x7310, 0x7316, 0x731d, 0x731e, 0x731f,
  0x732e, 0x731c, 0x7318, 0x7314, 0x7317, 0x732f, 0x732a, 0x7c2e,
  0x7c21, 0x7c2f, 0x7c38, 0x7c22, 0x7c25, 0x7c23, 0x7c26, 0x7c2c,
  0x7c24, 0x7c3e, 0x7c27, 0x7c3c, 0x7d59, 0x7d56, 0x7d42, 0x7d51,
  0x7d5e, 0x7d5f, 0x7d5c, 0x7de6, 0x7de1, 0x7ded, 0x7de3, 0x7de0,
  0x7de7, 0x7dd1, 0x7dd3, 0x7dd0, 0x7e8b, 0x7e84, 0x7e88, 0x7e86,
  0x7e81, 0x7e87, 0x7e8a, 0x7ed5, 0x7f1d,
  /* 0xd3 */
  0x7f09, 0x7f1e, 0x7f08, 0x7f02, 0x7f05, 0x7f07, 0x7f03, 0x7f04,
  0x7f1f, 0x7889, 0x789c, 0x7887, 0x7881, 0x7885, 0x7880, 0x7888,
  0x7913, 0x7910, 0x791c, 0x7903, 0x7915, 0x791b, 0x791e, 0x7912,
  0x791f, 0x7902, 0x7901, 0x7b51, 0x7b6c, 0x7b53, 0x7b6d, 0x7b50,
  0x7b56, 0x7b9b, 0x7b9f, 0x7bce, 0x7bcf, 0x7bcd, 0x841b, 0x8433,
  0x8434, 0x84f7, 0x84ff, 0x84f4, 0x84f8, 0x850c, 0x84f6, 0x850d,
  0x860c, 0x8622, 0x8628, 0x873e, 0x8720, 0x8749, 0x8714, 0x875c,
  0x8728, 0x875b, 0x8732, 0x874c, 0x872b, 0x8711, 0x872f, 0x874f,
  0x8743, 0x8716, 0x8727, 0x8705, 0x8731, 0x8740, 0x871b, 0x8729,
  0x872d, 0x873a, 0x8722, 0x8724, 0x874a, 0x8748, 0x8741, 0x875e,
  0x8713, 0x8721, 0x8746, 0x872a, 0x8745, 0x825e, 0x825f, 0x82af,
  0x82a5, 0x829b, 0x8280, 0x829c, 0x8293, 0x828a, 0x829a, 0x828b,
  0x8286, 0x8297, 0x8288, 0x82a8, 0x8294, 0x82ac, 0x82aa, 0x8298,
  0x8295, 0x8283, 0x8290, 0x829d, 0x8299, 0x8c4e, 0x8c49, 0x8c60,
  0x8c78, 0x8c7b, 0x8c7f, 0x8c8d, 0x8c7c, 0x8c72, 0x8c62, 0x8c8e,
  0x8c73, 0x8c79, 0x8c71, 0x8e1f, 0x884a, 0x885a, 0x8876, 0x88a9,
  0x88ae, 0x897b, 0x8975, 0x89b8, 0x89ba, 0x89bb, 0x8adc, 0x8ade,
  0x8bf3, 0x8bf8, 0x940f, 0x8bf2, 0x8bf6, 0x9409, 0x8bf1, 0x8bfb,
  0x94db, 0x94ed, 0x94d4, 0x94d7, 0x94ee, 0x94d2, 0x94e8, 0x94d5,
  0x94d6, 0x94da, 0x94d1, 0x94e9, 0x955d,
  /* 0xd4 */
  0x9543, 0x9542, 0x95d8, 0x95ef, 0x95d7, 0x9251, 0x9252, 0x92b1,
  0x9cee, 0x9ed2, 0x9f22, 0x4a72, 0x547d, 0x5467, 0x546c, 0x5453,
  0x546d, 0x545e, 0x5446, 0x5450, 0x547f, 0x5445, 0x5440, 0x544c,
  0x5456, 0x5447, 0x546f, 0x5418, 0x5448, 0x5452, 0x5464, 0x5466,
  0x546e, 0x5469, 0x544b, 0x544d, 0x5463, 0x547e, 0x545a, 0x545c,
  0x55dd, 0x5666, 0x5660, 0x5661, 0x5663, 0x56db, 0x56de, 0x5720,
  0x5791, 0x5178, 0x517b, 0x5131, 0x5140, 0x515d, 0x5139, 0x5127,
  0x515c, 0x516f, 0x513b, 0x5138, 0x513d, 0x515f, 0x5148, 0x5101,
  0x513f, 0x5168, 0x5143, 0x5134, 0x5145, 0x5120, 0x5136, 0x514d,
  0x5146, 0x5307, 0x530a, 0x53f6, 0x5c19, 0x53ef, 0x53fb, 0x53d1,
  0x53f9, 0x5c0d, 0x53e0, 0x53f0, 0x5c05, 0x53f5, 0x5c06, 0x53fe,
  0x53c2, 0x5c0a, 0x53e3, 0x53ee, 0x53ff, 0x53e8, 0x53e1, 0x53ec,
  0x5c03, 0x53f1, 0x5c1d, 0x53ea, 0x5c0c, 0x5c01, 0x53fc, 0x53e4,
  0x53fd, 0x5c00, 0x5c09, 0x5d51, 0x5e6d, 0x5e55, 0x5e58, 0x5e6a,
  0x5e53, 0x5e35, 0x5e38, 0x5e60, 0x5e5d, 0x5e52, 0x5e68, 0x5e61,
  0x5e5e, 0x5e69, 0x5e5a, 0x5e4e, 0x5e50, 0x5e5f, 0x5e49, 0x5e56,
  0x5e45, 0x5e83, 0x5e33, 0x5e40, 0x5e34, 0x5e41, 0x5e7d, 0x5e64,
  0x5e4a, 0x5e5c, 0x5e5b, 0x5e4f, 0x5e51, 0x5f7f, 0x5f63, 0x5fcc,
  0x5fcd, 0x5854, 0x5913, 0x5906, 0x5910, 0x5917, 0x592d, 0x5901,
  0x5925, 0x5900, 0x592b, 0x5928, 0x5902,
  /* 0xd5 */
  0x593d, 0x591f, 0x592e, 0x5912, 0x5923, 0x5a33, 0x5a39, 0x5abc,
  0x5ab9, 0x5ab4, 0x5abf, 0x5abe, 0x5b3b, 0x5b35, 0x5b96, 0x5b9b,
  0x5b92, 0x6487, 0x649d, 0x648b, 0x64b3, 0x64bd, 0x64b7, 0x64de,
  0x64d9, 0x64c2, 0x64e9, 0x64d4, 0x64d0, 0x64c5, 0x64bc, 0x64d6,
  0x64ba, 0x64c7, 0x64b2, 0x64ce, 0x64c0, 0x64cd, 0x673f, 0x6768,
  0x6787, 0x678f, 0x6770, 0x67b0, 0x6793, 0x67a0, 0x6790, 0x679a,
  0x67a6, 0x6783, 0x6762, 0x678a, 0x679d, 0x6763, 0x67a2, 0x6778,
  0x6791, 0x6760, 0x67a3, 0x6771, 0x67a9, 0x6736, 0x6792, 0x6775,
  0x6788, 0x678c, 0x679c, 0x6780, 0x677d, 0x615e, 0x61c0, 0x6268,
  0x626c, 0x6256, 0x6254, 0x6251, 0x626f, 0x6315, 0x6c74, 0x6c8a,
  0x6c9d, 0x6c91, 0x6c60, 0x6c63, 0x6ca3, 0x6ca6, 0x6d5b, 0x6c62,
  0x6cae, 0x6ca1, 0x6ca4, 0x6c78, 0x6c79, 0x6cbf, 0x6c82, 0x6c7a,
  0x6c9f, 0x6c71, 0x6c66, 0x6c7f, 0x6ca7, 0x6c8d, 0x6c7c, 0x6c73,
  0x6c96, 0x6c9b, 0x6c86, 0x6cad, 0x6c84, 0x6ca9, 0x6c75, 0x6c76,
  0x6c9c, 0x6c81, 0x6c87, 0x6c70, 0x6f3b, 0x6f3e, 0x6f3a, 0x6f35,
  0x6f9c, 0x6f82, 0x6f80, 0x6f83, 0x6f81, 0x6827, 0x69cd, 0x69a6,
  0x69b9, 0x69be, 0x6a79, 0x69a1, 0x69e4, 0x69ef, 0x69ba, 0x69fb,
  0x69d9, 0x6a0d, 0x69c5, 0x69ed, 0x69d2, 0x69db, 0x69b3, 0x69e8,
  0x69d1, 0x69d0, 0x69d6, 0x69f9, 0x69c7, 0x69b0, 0x69e0, 0x69fd,
  0x69b7, 0x69d8, 0x69cf, 0x69c2, 0x69c4,
  /* 0xd6 */
  0x69dd, 0x69ff, 0x69de, 0x69f0, 0x69da, 0x69c0, 0x69ee, 0x69b6,
  0x74f7, 0x7500, 0x74fa, 0x751a, 0x74f9, 0x7501, 0x74fd, 0x7509,
  0x74fe, 0x751d, 0x74f1, 0x74f2, 0x750b, 0x751e, 0x750d, 0x74f5,
  0x74fb, 0x7506, 0x750f, 0x7503, 0x7673, 0x7676, 0x7671, 0x7672,
  0x7710, 0x771a, 0x770a, 0x771c, 0x7715, 0x7707, 0x7705, 0x76f2,
  0x7702, 0x7713, 0x7785, 0x77fb, 0x77f5, 0x77f8, 0x7009, 0x700c,
  0x77f0, 0x700a, 0x700d, 0x77f7, 0x77f1, 0x77f2, 0x7001, 0x7006,
  0x77f9, 0x7005, 0x7169, 0x716e, 0x71c3, 0x71df, 0x71c2, 0x71c6,
  0x71c1, 0x71dc, 0x71dd, 0x7282, 0x7284, 0x72de, 0x7334, 0x7322,
  0x7320, 0x733c, 0x733f, 0x7339, 0x733e, 0x7330, 0x7328, 0x7336,
  0x7338, 0x7c45, 0x7c5f, 0x7c44, 0x7c40, 0x7c47, 0x7c41, 0x7c2b,
  0x7c48, 0x7c5d, 0x7d69, 0x7d6a, 0x7d64, 0x7d67, 0x7d6e, 0x7d66,
  0x7d6c, 0x7db6, 0x7df7, 0x7df5, 0x7dfb, 0x7dfa, 0x7e82, 0x7e99,
  0x7e9d, 0x7f38, 0x7f4a, 0x7f39, 0x7f28, 0x7f3d, 0x7f2f, 0x7f29,
  0x7f3e, 0x7f15, 0x7f27, 0x7f10, 0x7f3c, 0x7f26, 0x7f20, 0x7f22,
  0x7f3f, 0x7f35, 0x7f17, 0x7f2e, 0x7899, 0x7895, 0x789b, 0x78ae,
  0x7938, 0x7930, 0x7935, 0x793b, 0x7937, 0x7948, 0x7921, 0x7924,
  0x794c, 0x794a, 0x7933, 0x7932, 0x7947, 0x7936, 0x7925, 0x7b6e,
  0x7b98, 0x7b91, 0x7b90, 0x7b96, 0x7bc7, 0x7bc6, 0x7bc0, 0x7bdd,
  0x7bdc, 0x7bca, 0x7bc2, 0x7bc4, 0x8412,
  /* 0xd7 */
  0x8413, 0x8416, 0x844a, 0x844e, 0x8445, 0x8515, 0x8528, 0x8514,
  0x8516, 0x8520, 0x8512, 0x8521, 0x8513, 0x852c, 0x8518, 0x852a,
  0x8510, 0x852f, 0x861c, 0x8635, 0x863e, 0x8637, 0x8639, 0x863f,
  0x8679, 0x879d, 0x87ae, 0x87a5, 0x8780, 0x8777, 0x877e, 0x87a9,
  0x8779, 0x8782, 0x878c, 0x8798, 0x8794, 0x8778, 0x8799, 0x87a4,
  0x8770, 0x878e, 0x8781, 0x8790, 0x8796, 0x87a7, 0x8786, 0x8773,
  0x87a8, 0x87a2, 0x8785, 0x879a, 0x87bd, 0x8772, 0x87ab, 0x878a,
  0x87a3, 0x877b, 0x8797, 0x8254, 0x825b, 0x82b2, 0x82ba, 0x82cf,
  0x82cc, 0x82c8, 0x82b7, 0x82bd, 0x82c5, 0x82b4, 0x82be, 0x82b5,
  0x82c1, 0x82b9, 0x82b6, 0x82b1, 0x82ce, 0x82b0, 0x82b3, 0x8c5f,
  0x8c84, 0x8c98, 0x8ca5, 0x8caf, 0x8ca7, 0x8c97, 0x8c9c, 0x8cac,
  0x8c92, 0x8c95, 0x8caa, 0x8c94, 0x8c96, 0x8c9a, 0x8ca9, 0x8ca1,
  0x8c81, 0x8c9e, 0x8c83, 0x8d8f, 0x8ddb, 0x8dd4, 0x8dd8, 0x8e3d,
  0x8e2a, 0x8e21, 0x8e13, 0x8834, 0x8836, 0x8851, 0x8850, 0x8870,
  0x88a8, 0x8970, 0x8976, 0x8974, 0x89b1, 0x89cf, 0x89b4, 0x89b2,
  0x89cc, 0x8ad5, 0x8ad3, 0x8ad0, 0x8ad1, 0x8ada, 0x8aed, 0x8aec,
  0x9429, 0x9406, 0x941c, 0x9411, 0x9401, 0x942c, 0x94e2, 0x94e7,
  0x94fd, 0x94f9, 0x94ff, 0x94fe, 0x94d9, 0x94e6, 0x94e1, 0x94e4,
  0x955b, 0x9555, 0x9557, 0x955e, 0x9558, 0x95e1, 0x95f9, 0x95fc,
  0x95fe, 0x95f5, 0x95e9, 0x95f4, 0x95e7,
  /* 0xd8 */
  0x95e6, 0x95fa, 0x95e5, 0x95e3, 0x9177, 0x918b, 0x9185, 0x9271,
  0x9260, 0x9266, 0x927c, 0x9262, 0x92b2, 0x9367, 0x9c09, 0x9ce8,
  0x9d9a, 0x5496, 0x5498, 0x5499, 0x5493, 0x5486, 0x54ae, 0x548e,
  0x5481, 0x5483, 0x5490, 0x5465, 0x5491, 0x549f, 0x548f, 0x548a,
  0x5552, 0x55d9, 0x571f, 0x571c, 0x57a9, 0x57aa, 0x519c, 0x51a5,
  0x51a8, 0x51a0, 0x517a, 0x5248, 0x51af, 0x519e, 0x5185, 0x5182,
  0x51b8, 0x518c, 0x51ae, 0x519f, 0x51a9, 0x5170, 0x5181, 0x51ab,
  0x5172, 0x5198, 0x51ac, 0x5183, 0x5301, 0x5c24, 0x5c3a, 0x5c14,
  0x5c13, 0x5c2a, 0x5c2e, 0x5c25, 0x53f8, 0x5c45, 0x5c28, 0x5c11,
  0x5c16, 0x5c3e, 0x5c32, 0x5c3b, 0x5c23, 0x5c34, 0x5c35, 0x5c20,
  0x5c21, 0x5c36, 0x5d6c, 0x5ea2, 0x5e99, 0x5e92, 0x5e77, 0x5eaf,
  0x5e93, 0x5e75, 0x5eab, 0x5e71, 0x5ea8, 0x5ea1, 0x5e98, 0x5ea3,
  0x5e3a, 0x5e89, 0x5e87, 0x5e9a, 0x5e8e, 0x5e86, 0x5ea4, 0x5e76,
  0x5e70, 0x5e81, 0x5e91, 0x5e82, 0x5e9e, 0x5e90, 0x5fe7, 0x5fc0,
  0x5fc6, 0x5fd9, 0x5fdc, 0x5fc7, 0x5fc3, 0x5801, 0x583d, 0x593a,
  0x594e, 0x5966, 0x594c, 0x5946, 0x5932, 0x5938, 0x595c, 0x5943,
  0x5958, 0x593e, 0x5937, 0x595f, 0x5930, 0x593c, 0x5954, 0x594f,
  0x5934, 0x5944, 0x5935, 0x5931, 0x593f, 0x593b, 0x594d, 0x5948,
  0x5a49, 0x5a4c, 0x5b55, 0x5bab, 0x5ba8, 0x5ba6, 0x64c4, 0x64b4,
  0x64c1, 0x64ef, 0x64c3, 0x64c9, 0x6519,
  /* 0xd9 */
  0x64ff, 0x6507, 0x651b, 0x6508, 0x64f8, 0x651e, 0x64f5, 0x64f1,
  0x64f3, 0x64cc, 0x650e, 0x6515, 0x6510, 0x651d, 0x64f2, 0x6509,
  0x6506, 0x6647, 0x6799, 0x67bc, 0x67bd, 0x67c3, 0x67e8, 0x67e5,
  0x67e2, 0x67ce, 0x6090, 0x67fe, 0x67c7, 0x67ed, 0x67fb, 0x67d8,
  0x67ff, 0x67f8, 0x606c, 0x67d2, 0x67b3, 0x67d0, 0x67d1, 0x67c9,
  0x67d5, 0x67de, 0x67cf, 0x67ca, 0x67c1, 0x67c6, 0x67c5, 0x67fd,
  0x67da, 0x67d4, 0x613f, 0x616a, 0x6167, 0x6169, 0x6151, 0x6165,
  0x6168, 0x6181, 0x6190, 0x6193, 0x61a3, 0x61dd, 0x61df, 0x6271,
  0x6261, 0x6276, 0x628d, 0x627c, 0x6274, 0x6267, 0x627f, 0x630c,
  0x6d01, 0x6cde, 0x6d09, 0x6cd1, 0x6d27, 0x6ce1, 0x6ce7, 0x6cfc,
  0x6d02, 0x6cdb, 0x6cfa, 0x6ce6, 0x6ce9, 0x6cfb, 0x6d1e, 0x6d1d,
  0x6cfe, 0x6cec, 0x6d0a, 0x6cc1, 0x6d05, 0x6d7d, 0x6cb9, 0x6d1c,
  0x6ce2, 0x6ccb, 0x6d19, 0x6cf5, 0x6cdd, 0x6cf0, 0x6cf1, 0x6ce5,
  0x6d06, 0x6d07, 0x6d1a, 0x6cc3, 0x6cc5, 0x6cd0, 0x6cd3, 0x6ceb,
  0x6cf9, 0x6cdc, 0x6d0b, 0x6cd9, 0x6ce4, 0x6d18, 0x6d28, 0x6cca,
  0x6f34, 0x6f36, 0x6f32, 0x6f31, 0x6f99, 0x6f9a, 0x6f94, 0x6f98,
  0x6fb0, 0x6ffd, 0x6fff, 0x6ffe, 0x683d, 0x69f1, 0x6a4b, 0x6a4a,
  0x6a12, 0x6a44, 0x6a85, 0x6a31, 0x6a30, 0x6a48, 0x6a6f, 0x6a26,
  0x6a32, 0x6a4c, 0x6a50, 0x6a7e, 0x6a11, 0x6a3e, 0x6a46, 0x6a4d,
  0x6a5c, 0x6a36, 0x6a0e, 0x6a23, 0x6a53,
  /* 0xda */
  0x6a65, 0x6a51, 0x6a6c, 0x6a3c, 0x6a25, 0x6a6d, 0x6a7c, 0x6a66,
  0x6a34, 0x6a2f, 0x6a3d, 0x6a5e, 0x6a68, 0x6a2a, 0x6a75, 0x6a69,
  0x6a7a, 0x6a58, 0x6a74, 0x6a5f, 0x6a6b, 0x6a38, 0x6a3b, 0x6a57,
  0x752d, 0x7513, 0x7522, 0x74f6, 0x7523, 0x753c, 0x752e, 0x7528,
  0x752f, 0x753f, 0x7512, 0x7525, 0x7537, 0x7516, 0x7646, 0x7657,
  0x7685, 0x7684, 0x768b, 0x7688, 0x7686, 0x771f, 0x7706, 0x773d,
  0x772f, 0x773c, 0x773e, 0x772a, 0x773f, 0x7720, 0x772b, 0x772e,
  0x7738, 0x7701, 0x7023, 0x7021, 0x703d, 0x7026, 0x701b, 0x7017,
  0x702c, 0x7020, 0x703c, 0x7029, 0x702e, 0x7010, 0x7024, 0x702d,
  0x703f, 0x70f6, 0x7122, 0x7162, 0x7161, 0x71ea, 0x71d7, 0x71ec,
  0x71eb, 0x71d0, 0x71d2, 0x71e9, 0x71da, 0x7298, 0x729f, 0x72d7,
  0x734b, 0x734a, 0x7349, 0x7340, 0x7348, 0x7347, 0x7343, 0x7346,
  0x7341, 0x73d3, 0x73e1, 0x7c6d, 0x7c69, 0x7c68, 0x7c51, 0x7c60,
  0x7c7c, 0x7c67, 0x7c63, 0x7c7d, 0x7c64, 0x7c65, 0x7c53, 0x7c6f,
  0x7d79, 0x7d7e, 0x7d7f, 0x7d7d, 0x7e0f, 0x7e07, 0x7e0e, 0x7e01,
  0x7e09, 0x7e94, 0x7eeb, 0x7ee9, 0x7f47, 0x7f36, 0x7f49, 0x7f45,
  0x7f41, 0x7f43, 0x7f4d, 0x7f55, 0x7f48, 0x78af, 0x7893, 0x78a5,
  0x78ac, 0x7955, 0x7962, 0x796e, 0x795e, 0x795b, 0x796a, 0x7967,
  0x7942, 0x7960, 0x7951, 0x7966, 0x795f, 0x7959, 0x7964, 0x795c,
  0x7952, 0x7943, 0x7b33, 0x7b32, 0x7b68,
  /* 0xdb */
  0x7b6b, 0x7baf, 0x7bad, 0x7bac, 0x7bda, 0x845c, 0x8442, 0x845d,
  0x84f3, 0x84d9, 0x854e, 0x8547, 0x855f, 0x8542, 0x854a, 0x8530,
  0x8540, 0x8537, 0x85eb, 0x85e3, 0x85fa, 0x85f5, 0x85f4, 0x8609,
  0x8631, 0x8630, 0x8632, 0x8678, 0x8736, 0x87c2, 0x87f4, 0x802e,
  0x87cd, 0x87e5, 0x801f, 0x87ea, 0x87e9, 0x87f1, 0x87fb, 0x801d,
  0x87cb, 0x87c5, 0x87e6, 0x87ee, 0x87b2, 0x800c, 0x87d0, 0x87e8,
  0x87d5, 0x87f2, 0x87ec, 0x87c6, 0x87c3, 0x87db, 0x87f8, 0x87c4,
  0x8004, 0x8002, 0x87d3, 0x801c, 0x800b, 0x87cf, 0x87fe, 0x87d8,
  0x87f7, 0x87ca, 0x87dc, 0x87e7, 0x801e, 0x87ce, 0x87e1, 0x87e3,
  0x87c9, 0x87f6, 0x87da, 0x87ef, 0x8016, 0x87d6, 0x87f3, 0x82d5,
  0x82ef, 0x82eb, 0x82de, 0x82ee, 0x82d7, 0x82e7, 0x82d0, 0x82e6,
  0x82d1, 0x82e1, 0x82e4, 0x82da, 0x82e5, 0x82dc, 0x8c45, 0x8c5b,
  0x8c58, 0x8cb7, 0x8cda, 0x8cb4, 0x8cb5, 0x8ccd, 0x8cb3, 0x8cbb,
  0x8cb1, 0x8cba, 0x8cb0, 0x8cbf, 0x8d0c, 0x8cc4, 0x8d98, 0x8d95,
  0x8d9a, 0x8dd0, 0x8dd7, 0x8dd6, 0x8e43, 0x8e40, 0x8e34, 0x8e54,
  0x8e4d, 0x8e5a, 0x8e55, 0x8e49, 0x8e48, 0x8e5f, 0x8e45, 0x8e5c,
  0x8e47, 0x8e41, 0x8e42, 0x8852, 0x888c, 0x888d, 0x88b7, 0x88b3,
  0x88bd, 0x88b4, 0x88b8, 0x8989, 0x898d, 0x8984, 0x89d5, 0x89de,
  0x89c0, 0x89ca, 0x89db, 0x89d1, 0x89c2, 0x89d8, 0x89d4, 0x89c5,
  0x89da, 0x89c8, 0x8ae2, 0x8afa, 0x8af7,
  /* 0xdc */
  0x8af4, 0x8aeb, 0x8ae3, 0x8ae8, 0x8af8, 0x8aea, 0x8ae5, 0x8afb,
  0x8ae6, 0x8afc, 0x8ae1, 0x8af9, 0x8ae4, 0x9420, 0x9439, 0x9422,
  0x950b, 0x9521, 0x9509, 0x94f2, 0x94f1, 0x9505, 0x94f4, 0x94f6,
  0x950c, 0x950d, 0x950a, 0x9508, 0x950e, 0x956c, 0x9569, 0x9552,
  0x956f, 0x956d, 0x960c, 0x9607, 0x9628, 0x960e, 0x9617, 0x962b,
  0x9602, 0x9601, 0x960d, 0x961f, 0x95f2, 0x95f0, 0x960b, 0x9609,
  0x962a, 0x960f, 0x9611, 0x9629, 0x9614, 0x961a, 0x9608, 0x961b,
  0x9176, 0x9180, 0x9181, 0x919d, 0x928a, 0x9273, 0x9285, 0x9284,
  0x928e, 0x928d, 0x92cf, 0x92c5, 0x92ce, 0x92fc, 0x92fd, 0x9361,
  0x937d, 0x9363, 0x9c0a, 0x9ca4, 0x9ce6, 0x98eb, 0x9af4, 0x4a8e,
  0x4a89, 0x4abb, 0x54b0, 0x54b2, 0x54cb, 0x54a3, 0x54c9, 0x54c7,
  0x54b9, 0x54c5, 0x54cf, 0x54bd, 0x54cc, 0x54b7, 0x54bc, 0x54c6,
  0x54c4, 0x54bb, 0x54b5, 0x55da, 0x5677, 0x5675, 0x5676, 0x5671,
  0x51ce, 0x51d6, 0x51c1, 0x51dd, 0x51c6, 0x51c7, 0x51d0, 0x51cd,
  0x51d9, 0x51c9, 0x51e4, 0x51b2, 0x51df, 0x5180, 0x51c2, 0x51d8,
  0x51ef, 0x51db, 0x51c5, 0x51ff, 0x51c0, 0x51d4, 0x51cf, 0x5319,
  0x5c5e, 0x5c65, 0x5c69, 0x5c42, 0x5c40, 0x5c44, 0x5c62, 0x5c58,
  0x5c43, 0x5c50, 0x5c54, 0x5c68, 0x5c56, 0x5c30, 0x5c6e, 0x5c7c,
  0x5cf1, 0x5eca, 0x5ec9, 0x5ec6, 0x5eb7, 0x5eb5, 0x5ebc, 0x5eb8,
  0x5ebd, 0x5eb2, 0x5ec5, 0x5eb6, 0x5ecb,
  /* 0xdd */
  0x5eba, 0x5ecd, 0x5ec7, 0x5eb9, 0x5ebb, 0x5ec0, 0x5eb4, 0x5e9d,
  0x5fdb, 0x5fd5, 0x5fd4, 0x5812, 0x583e, 0x597c, 0x596e, 0x5947,
  0x5968, 0x597f, 0x5961, 0x5953, 0x5965, 0x596a, 0x596f, 0x59fd,
  0x5a42, 0x5a43, 0x5a47, 0x5a40, 0x5a46, 0x5ac8, 0x5ac1, 0x5acb,
  0x5ac6, 0x5aca, 0x5b4d, 0x5ba2, 0x5ba0, 0x64fa, 0x6544, 0x6547,
  0x6526, 0x6548, 0x653b, 0x653f, 0x6523, 0x654b, 0x6522, 0x6542,
  0x6524, 0x654d, 0x662d, 0x9565, 0x662e, 0x6628, 0x6629, 0x67c8,
  0x67fc, 0x67e6, 0x601d, 0x601f, 0x6004, 0x602d, 0x6029, 0x603e,
  0x604e, 0x6012, 0x6018, 0x6015, 0x6034, 0x603a, 0x602f, 0x602e,
  0x6001, 0x602b, 0x603d, 0x6025, 0x604c, 0x6038, 0x6022, 0x6007,
  0x6017, 0x604d, 0x6028, 0x602a, 0x6006, 0x67ea, 0x6016, 0x6023,
  0x602c, 0x6003, 0x6162, 0x619f, 0x61de, 0x628b, 0x6281, 0x6298,
  0x629d, 0x6286, 0x6287, 0x6294, 0x6299, 0x6275, 0x632d, 0x6d6b,
  0x6d52, 0x6d35, 0x6d43, 0x6d6f, 0x6d7c, 0x6d32, 0x6d48, 0x6d67,
  0x6d34, 0x6d4f, 0x6d5a, 0x6d54, 0x6d77, 0x6d45, 0x6d44, 0x6d38,
  0x6d61, 0x6d3e, 0x6d30, 0x6d68, 0x6cfd, 0x6d75, 0x6d39, 0x6d64,
  0x6d4d, 0x6d62, 0x6d49, 0x6d7b, 0x6d55, 0x6d4c, 0x6d79, 0x6d41,
  0x6d36, 0x6d46, 0x6d3a, 0x6d51, 0x6d42, 0x6d5c, 0x6d3f, 0x6d5f,
  0x6d22, 0x6d76, 0x6d31, 0x6f4b, 0x6f48, 0x6f4e, 0x6f4f, 0x6f45,
  0x6f4c, 0x6f96, 0xfe00, 0x6ff6, 0x6ff1,
  /* 0xde */
  0x6ff4, 0x6ffa, 0x6ff5, 0x6a96, 0x6adb, 0x6ac5, 0x6a82, 0x6acd,
  0x6a92, 0x6a9e, 0x6a99, 0x6aad, 0x6abc, 0x6ab4, 0x6acb, 0x6adf,
  0x6ab0, 0x6acc, 0x6a93, 0x6ac4, 0x6aba, 0x6abd, 0x6ac0, 0x6aab,
  0x6ac2, 0x6abf, 0x6ab3, 0x6ace, 0x6ad1, 0x6ad5, 0x6a94, 0x6a9f,
  0x6a83, 0x6a80, 0x6aa9, 0x6aac, 0x6ab2, 0x6abe, 0x6add, 0x6ac7,
  0x6a9a, 0x6aa3, 0x6aae, 0x754a, 0x7559, 0x755f, 0x756e, 0x756d,
  0x754c, 0x7550, 0x756f, 0x757f, 0x7575, 0x7567, 0x756c, 0x754f,
  0x7555, 0x754e, 0x7546, 0x757d, 0x7552, 0x755d, 0x755e, 0x7549,
  0x7540, 0x7557, 0x7642, 0x7680, 0x7681, 0x769c, 0x769d, 0x7683,
  0x7731, 0x774f, 0x7736, 0x7737, 0x774d, 0x7747, 0x7744, 0x7049,
  0x7047, 0x7046, 0x705f, 0x705c, 0x705a, 0x704d, 0x7042, 0x705d,
  0x7043, 0x704f, 0x704b, 0x7040, 0x7059, 0x70ec, 0x70f2, 0x70f3,
  0x70f0, 0x7110, 0x7174, 0x717a, 0x6d8e, 0x71e2, 0x7202, 0x720e,
  0x71fa, 0x71f3, 0x71f1, 0x71f4, 0x71f5, 0x721d, 0x71f6, 0x71fb,
  0x71e0, 0x71f8, 0x71f0, 0x7294, 0x72b8, 0x72d0, 0x7358, 0x7352,
  0x736d, 0x735f, 0x735b, 0x7357, 0x7364, 0x736a, 0x7359, 0x7354,
  0x7360, 0x73ed, 0x7c8a, 0x7c97, 0x7c99, 0x7c82, 0x7c89, 0x7c98,
  0x7c88, 0x7c8b, 0x7cac, 0x7c8e, 0x7c74, 0x7c94, 0x7c8d, 0x7c9b,
  0x7c76, 0x7d71, 0x7d8f, 0x7d70, 0x7d74, 0x7e1c, 0x7e15, 0x7e14,
  0x7e1f, 0x7e1a, 0x7e18, 0x7e2f, 0x7e1e,
  /* 0xdf */
  0x7e16, 0x7e1d, 0x7eae, 0x7eaf, 0x7e93, 0x7ee6, 0x7f6b, 0x7f69,
  0x7f60, 0x7f79, 0x7f64, 0x7f7f, 0x7f68, 0x7f7e, 0x7f7c, 0x7f7d,
  0x7f6c, 0x7f75, 0x7f7b, 0x7f6e, 0x78bf, 0x78b9, 0x78a2, 0x7985,
  0x798b, 0x798d, 0x7980, 0x7972, 0x7988, 0x7977, 0x7983, 0x7976,
  0x798e, 0x7971, 0x7981, 0x7999, 0x7989, 0x7970, 0x799f, 0x7b60,
  0x7b66, 0x7b6a, 0x7b65, 0x7b61, 0x7bab, 0x7ba8, 0x7baa, 0x7bd6,
  0x7bd1, 0x842c, 0x8569, 0x856d, 0x857a, 0x8551, 0x8564, 0x8556,
  0x856f, 0x857f, 0x632c, 0x8553, 0x857b, 0x856a, 0x8562, 0x8549,
  0x856c, 0x8610, 0x8644, 0x8649, 0x864d, 0x864f, 0x8648, 0x80fc,
  0x8032, 0x805b, 0x807b, 0x8074, 0x8082, 0x8080, 0x8068, 0x805c,
  0x804d, 0x808b, 0x806a, 0x803d, 0x8040, 0x8070, 0x8057, 0x8054,
  0x8079, 0x807e, 0x8050, 0x810a, 0x8053, 0x803a, 0x8037, 0x8039,
  0x8077, 0x804e, 0x8075, 0x803f, 0x8048, 0x8024, 0x87d4, 0x8046,
  0x8022, 0x804f, 0x8020, 0x8052, 0x807d, 0x8034, 0x8043, 0x8041,
  0x805f, 0x8062, 0x80c8, 0x8083, 0x8036, 0x804a, 0x803b, 0x803e,
  0x8065, 0x8073, 0x8049, 0x8026, 0x806d, 0x8059, 0x8063, 0x805d,
  0x8306, 0x8309, 0x82fa, 0x8301, 0x82f7, 0x82db, 0x82f8, 0x8340,
  0x82f5, 0x8303, 0x8304, 0x830c, 0x82fb, 0x8300, 0x8308, 0x8cdb,
  0x8cc6, 0x8cc0, 0x8cc3, 0x8cd3, 0x8cd6, 0x8cd7, 0x8cc1, 0x8cdd,
  0x8d88, 0x8d96, 0x8dd2, 0x8de8, 0x8de9,
  /* 0xe0 */
  0x8dec, 0x8ded, 0x8def, 0x8dd1, 0x8deb, 0x8e7b, 0x8e8b, 0x8e72,
  0x8e6c, 0x8e32, 0x8e7a, 0x8e8f, 0x8e89, 0x8e78, 0x8e8e, 0x8e8c,
  0x8e79, 0x8e77, 0x8831, 0x8846, 0x8847, 0x8868, 0x8869, 0x886b,
  0x888b, 0x8889, 0x8888, 0x88c1, 0x8965, 0x8964, 0x899c, 0x8981,
  0x8983, 0x8982, 0x8980, 0x899e, 0x8999, 0x899d, 0x899f, 0x89fd,
  0x89ed, 0x89e1, 0x89fc, 0x89e3, 0x89dd, 0x89e4, 0x89ee, 0x89ef,
  0x89ea, 0x89ff, 0x89e6, 0x89f9, 0x8b0b, 0x8af2, 0x8b0c, 0x8b0d,
  0x8b08, 0x8b0a, 0x8b05, 0x8b0f, 0x8b06, 0x945f, 0x9432, 0x9449,
  0x9444, 0x9430, 0x951d, 0x9500, 0x9502, 0x951c, 0x951b, 0x9519,
  0x9506, 0x9503, 0x9563, 0x9562, 0x9645, 0x965f, 0x963d, 0x9637,
  0x966b, 0x963e, 0x9668, 0x9653, 0x968e, 0x9623, 0x9647, 0x964b,
  0x9660, 0x9661, 0x9642, 0x966d, 0x966a, 0x9662, 0x963b, 0x966c,
  0x967d, 0x963c, 0x9659, 0x966e, 0x965d, 0x967f, 0x9643, 0x965e,
  0x9641, 0x965b, 0x963f, 0x9192, 0x9191, 0x9193, 0x9196, 0x929f,
  0x929e, 0x929c, 0x929a, 0x92c3, 0x92f7, 0x92f0, 0x92f5, 0x92f8,
  0x937e, 0x937a, 0x9375, 0x937f, 0x9c02, 0x9c00, 0x9c03, 0x9ca1,
  0x9cfb, 0x9cf4, 0x9da2, 0x9dbf, 0x9dbd, 0x9db8, 0x9ea0, 0x9ea6,
  0x9f56, 0x98e7, 0x98e0, 0x98ea, 0x9a8d, 0x9af0, 0x54eb, 0x54d9,
  0x54da, 0x54e5, 0x54fe, 0x54d6, 0x54e7, 0x54d0, 0x54e9, 0x54de,
  0x54e1, 0x54fd, 0x54e2, 0x54ee, 0x54ed,
  /* 0xe1 */
  0x55d5, 0x568d, 0x568c, 0x56e4, 0x56e6, 0x573d, 0x57a1, 0x522a,
  0x5218, 0x5201, 0x521f, 0x51f1, 0x5202, 0x5211, 0x520c, 0x521e,
  0x520f, 0x51f7, 0x5210, 0x5209, 0x51f2, 0x51f4, 0x5c84, 0x5c71,
  0x5c9d, 0x5c95, 0x5c8b, 0x5c8c, 0x5c72, 0x5c79, 0x5c86, 0x5c77,
  0x5c8a, 0x5c9c, 0x5c83, 0x5c7b, 0x5c8f, 0x5c85, 0x5c76, 0x5c99,
  0x5c82, 0x5cf3, 0x5d66, 0x5ed1, 0x5ee3, 0x5ee8, 0x5ed8, 0x5ee7,
  0x5ed7, 0x5ee0, 0x5ee6, 0x5efe, 0x5eef, 0x5eed, 0x5ed6, 0x5ee1,
  0x5ed3, 0x5ed0, 0x5ed4, 0x5ee5, 0x5ed2, 0x5f7a, 0x5fed, 0x5fee,
  0x586e, 0x598f, 0x598d, 0x5970, 0x598b, 0x5977, 0x598c, 0x597a,
  0x5987, 0x5984, 0x5985, 0x5973, 0x5971, 0x5980, 0x5974, 0x5972,
  0x5a55, 0x5a54, 0x5a5e, 0x5ad5, 0x5adc, 0x5ada, 0x5ac3, 0x5ad1,
  0x5ad8, 0x5ad4, 0x5adf, 0x5ad9, 0x5b49, 0x5b4e, 0x5b62, 0x5bbb,
  0x6521, 0x6525, 0x654c, 0x6553, 0x657c, 0x657e, 0x655f, 0x655e,
  0x657f, 0x6561, 0x658d, 0x6579, 0x6559, 0x6577, 0x6556, 0x6568,
  0x6536, 0x6567, 0x656c, 0x655b, 0x6624, 0x662a, 0x6626, 0x6026,
  0x6040, 0x6056, 0x6050, 0x6079, 0x607b, 0x607f, 0x607e, 0x6070,
  0x6078, 0x606b, 0x60ab, 0x6043, 0x608f, 0x6053, 0x6051, 0x6046,
  0x605e, 0x606d, 0x605d, 0x6072, 0x6032, 0x6061, 0x6066, 0x6054,
  0x6068, 0x607a, 0x617e, 0x61ad, 0x62ac, 0x62ad, 0x6292, 0x6308,
  0x6309, 0x632f, 0x6dbc, 0x6dbb, 0x6dc4,
  /* 0xe2 */
  0x6dad, 0x6dc3, 0x6d9b, 0x6dbd, 0x6da1, 0x6db1, 0x6d9c, 0x6d94,
  0x6d83, 0x6daa, 0x6d80, 0x6da4, 0x6db3, 0x6da2, 0x6db2, 0x6dc9,
  0x6db0, 0x6da9, 0x6dd9, 0x6db4, 0x6dc7, 0x6d97, 0x6dc2, 0x6dbe,
  0x6d9e, 0x6da7, 0x6dac, 0x6d93, 0x6dd4, 0x6d9a, 0x6d9d, 0x6dcf,
  0x6db8, 0x6da8, 0x6dcb, 0x6f47, 0x6f40, 0x6f46, 0x6f93, 0x6f92,
  0x6fad, 0x6fce, 0x6fc9, 0x6ff3, 0x6ac3, 0x6af8, 0x6afc, 0x6b0e,
  0x6b28, 0x6af5, 0x6b3a, 0x6af6, 0x6b23, 0x6b04, 0x6b43, 0x6b14,
  0x6b17, 0x6b2a, 0x6b15, 0x6b36, 0x6b1f, 0x6ae0, 0x6b07, 0x6b3b,
  0x6b7e, 0x6af4, 0x6ae3, 0x6b20, 0x6b4d, 0x6b3d, 0x6b31, 0x6b38,
  0x6ae6, 0x6b0a, 0x6b03, 0x6b4e, 0x6b08, 0x6af0, 0x6afb, 0x6b34,
  0x6b11, 0x6af1, 0x6b37, 0x6b12, 0x6b00, 0x6b13, 0x6b05, 0x6b2c,
  0x758a, 0x759d, 0x7584, 0x758d, 0x7588, 0x758f, 0x7582, 0x7576,
  0x758b, 0x758c, 0x759a, 0x7649, 0x765e, 0x769a, 0x7698, 0x769e,
  0x774e, 0x7740, 0x775c, 0x7741, 0x706f, 0x707e, 0x707c, 0x7078,
  0x707f, 0x706a, 0x7063, 0x710d, 0x710f, 0x710e, 0x7170, 0x719d,
  0x721b, 0x7205, 0x7201, 0x7218, 0x721c, 0x7207, 0x7219, 0x72b5,
  0x738c, 0x7371, 0x7388, 0x738f, 0x7363, 0x738d, 0x7362, 0x7373,
  0x738e, 0x7cbf, 0x7ca7, 0x7cb9, 0x7ca0, 0x7ca5, 0x7c73, 0x7ca6,
  0x7c93, 0x7ca8, 0x7cad, 0x7ca1, 0x7caf, 0x7ca9, 0x7d95, 0x7d87,
  0x7d86, 0x7d9b, 0x7d98, 0x7d99, 0x7d9e,
  /* 0xe3 */
  0x7d9a, 0x7d85, 0x7d9f, 0x7d9d, 0x7e26, 0x7e47, 0x7e3d, 0x7e22,
  0x7e25, 0x7e2b, 0x7ea5, 0x7ea6, 0x7ea1, 0x7ee3, 0x7f85, 0x7f91,
  0x7f87, 0x7f9c, 0x7f9d, 0x7f9b, 0x7f80, 0x7f81, 0x7f96, 0x7f83,
  0x7f88, 0x7f95, 0x5689, 0x7f94, 0x7fa9, 0x7f8f, 0x78b6, 0x78b2,
  0x78b1, 0x78b7, 0x79aa, 0x79ba, 0x79cf, 0x79ae, 0x79a7, 0x79cc,
  0x79cd, 0x79c8, 0x7990, 0x79c3, 0x79c9, 0x79cb, 0x79c6, 0x79c1,
  0x79a2, 0x79b4, 0x799b, 0x79b1, 0x7992, 0x79ab, 0x79a3, 0x79a4,
  0x79ac, 0x79c4, 0x7b7e, 0x7bef, 0x7bee, 0x7be8, 0x7bd3, 0x8429,
  0x8450, 0x8451, 0x8584, 0x858b, 0x858e, 0x858a, 0x8580, 0x8581,
  0x8586, 0x8618, 0x809a, 0x80a9, 0x80ac, 0x8092, 0x80b7, 0x80c3,
  0x80cf, 0x80a1, 0x80a3, 0x80a6, 0x80b4, 0x80b9, 0x80cc, 0x80c0,
  0x80a7, 0x8097, 0x80bc, 0x80dd, 0x8090, 0x80aa, 0x80b6, 0x80af,
  0x8099, 0x80ca, 0x80c1, 0x8096, 0x80a4, 0x80a2, 0x80a5, 0x80db,
  0x8095, 0x80bb, 0x80c2, 0x80ad, 0x80da, 0x80d9, 0x80df, 0x80d6,
  0x80bd, 0x809c, 0x826c, 0x833e, 0x832e, 0x8325, 0x8366, 0x834d,
  0x8323, 0x8313, 0x832c, 0x8314, 0x8316, 0x834e, 0x8321, 0x834c,
  0x8333, 0x834b, 0x832d, 0x833f, 0x8327, 0x8320, 0x8331, 0x831f,
  0x8337, 0x833c, 0x8338, 0x834f, 0x832b, 0x832a, 0x8335, 0x8329,
  0x8317, 0x833d, 0x831c, 0x8cfa, 0x8cea, 0x8cfc, 0x8cff, 0x8cf7,
  0x8cf3, 0x8ce3, 0x8cf1, 0x8cfb, 0x8cf6,
  /* 0xe4 */
  0x8cfd, 0x8ce1, 0x8ce6, 0x8d90, 0x8dac, 0x8d92, 0x8d93, 0x8de4,
  0x8de6, 0x8de5, 0x8ea6, 0x8e94, 0x8e86, 0x8e9f, 0x8e82, 0x8e9b,
  0x8830, 0x8865, 0x8864, 0x88d8, 0x88c2, 0x88da, 0x899b, 0x8a04,
  0x8a0f, 0x89f2, 0x8a00, 0x89f0, 0x8a07, 0x8a0e, 0x8a0a, 0x8a0b,
  0x8a08, 0x89f3, 0x8a0d, 0x8a09, 0x8b1d, 0x8b1c, 0x8b03, 0x8b00,
  0x952e, 0x9511, 0x952d, 0x952f, 0x9512, 0x9510, 0x9517, 0x9529,
  0x952c, 0x9516, 0x9577, 0x957f, 0x9574, 0x957e, 0x96a8, 0x96a9,
  0x967b, 0x9696, 0x9677, 0x96ad, 0x9699, 0x96a7, 0x9680, 0x96ab,
  0x9697, 0x96a6, 0x9674, 0x969a, 0x9672, 0x96ae, 0x96e3, 0x9683,
  0x968f, 0x9698, 0x96af, 0x9670, 0x9685, 0x96ac, 0x9687, 0x968b,
  0x9681, 0x9694, 0x96aa, 0x9673, 0x968a, 0x96a4, 0x9690, 0x9686,
  0x9620, 0x9293, 0x92ac, 0x92f2, 0x9355, 0x9370, 0x9377, 0x9373,
  0x938e, 0x938d, 0x938f, 0x9376, 0x9389, 0x938c, 0x9372, 0x93c3,
  0x93c0, 0x9c1b, 0x9ca0, 0x9ca3, 0x9d0f, 0x9d0d, 0x9d0a, 0x9d90,
  0x9d91, 0x9dce, 0x9db4, 0x9db6, 0x9db7, 0x9dcf, 0x9db0, 0x9dca,
  0x9ebc, 0x9eee, 0x9eea, 0x9f33, 0x9f32, 0x9f6d, 0x9f6c, 0x9f52,
  0x98fc, 0x98ff, 0x98f8, 0x9aaa, 0x54f2, 0x550e, 0x553d, 0x54f5,
  0x550b, 0x550a, 0x54fb, 0x54f3, 0x5506, 0x5501, 0x54f0, 0x5507,
  0x5686, 0x5681, 0x56fc, 0x56e2, 0x5245, 0x524f, 0x5241, 0x5238,
  0x524c, 0x5247, 0x5244, 0x524b, 0x5255,
  /* 0xe5 */
  0x5257, 0x524d, 0x523e, 0x5230, 0x5221, 0x5233, 0x5235, 0x5227,
  0x5237, 0x5317, 0x5ca6, 0x5c90, 0x5cbc, 0x5cad, 0x5cae, 0x5ca2,
  0x5ca1, 0x5ca8, 0x5cac, 0x5cf2, 0x5ef2, 0x5ef9, 0x5ef0, 0x5efa,
  0x5efb, 0x5f0e, 0x5ef5, 0x5f0f, 0x5ef4, 0x5f0c, 0x5f0a, 0x5f08,
  0x5f02, 0x586a, 0x5994, 0x599a, 0x5992, 0x599f, 0x59af, 0x599e,
  0x5998, 0x59ad, 0x5991, 0x59ac, 0x5997, 0x5993, 0x5a64, 0x5a50,
  0x5a6d, 0x5a51, 0x79fe, 0x5ad6, 0x5ad3, 0x5aec, 0x5b44, 0x5bbf,
  0x6586, 0x658e, 0x6574, 0x65bc, 0x65bd, 0x65af, 0x6584, 0x6596,
  0x659e, 0x65a2, 0x65a0, 0x6592, 0x659f, 0x65a7, 0x65ac, 0x6580,
  0x656b, 0x65be, 0x6620, 0x6063, 0x607d, 0x609b, 0x60ad, 0x6088,
  0x609a, 0x6091, 0x6082, 0x6086, 0x6087, 0x6081, 0x60ae, 0x6092,
  0x6065, 0x60bc, 0x6095, 0x617b, 0x6177, 0x6174, 0x6176, 0x61bf,
  0x61be, 0x62b8, 0x62bd, 0x62a4, 0x62bf, 0x62ba, 0x62a7, 0x62a2,
  0x6e0d, 0x6e0b, 0x6e1a, 0x6de8, 0x6df5, 0x6e18, 0x6dfc, 0x6de9,
  0x6e2d, 0x6df2, 0x6de1, 0x6def, 0x6e16, 0x6e10, 0x6df3, 0x6e2a,
  0x6dff, 0x6de3, 0x6e19, 0x6dfa, 0x6dea, 0x6e4d, 0x6e05, 0x6deb,
  0x6df6, 0x6e00, 0x6df1, 0x6de6, 0x6e04, 0x6e09, 0x6e15, 0x6e28,
  0x6e02, 0x6dfb, 0x6e2b, 0x6e0a, 0x6df9, 0x6e1b, 0x6f5c, 0x6fa8,
  0x6fae, 0x6faf, 0x6fab, 0x680c, 0x680d, 0x6ff2, 0x680f, 0x6b4c,
  0x6b2b, 0x6b73, 0x6b8a, 0x6bcb, 0x6b9f,
  /* 0xe6 */
  0x6b80, 0x6b84, 0x6b81, 0x6b6f, 0x6b42, 0x6b88, 0x6b57, 0x6b9b,
  0x6b7b, 0x6b61, 0x6b8f, 0x6b58, 0x6b7f, 0x6b5f, 0x6b5d, 0x6b5a,
  0x6b99, 0x6b9e, 0x6b50, 0x6b0d, 0x6b6c, 0x6b66, 0x6b70, 0x6b6a,
  0x6b9d, 0x6b5e, 0x6b86, 0x6b64, 0x6b72, 0x6b98, 0x6b6e, 0x6b7a,
  0x6b67, 0x6b76, 0x75bf, 0x75a2, 0x7596, 0x75bd, 0x75ad, 0x7597,
  0x75a4, 0x75b8, 0x7590, 0x75a8, 0x7593, 0x75a9, 0x75ac, 0x75a7,
  0x7591, 0x75aa, 0x75be, 0x7695, 0x7697, 0x7755, 0x775f, 0x7753,
  0x7752, 0x776d, 0x7750, 0x7756, 0x776c, 0x7757, 0x7754, 0x776f,
  0x708a, 0x7084, 0x7087, 0x708b, 0x708c, 0x7070, 0x7088, 0x7085,
  0x7071, 0x7074, 0x7105, 0x710a, 0x7173, 0x7228, 0x7213, 0x7214,
  0x7210, 0x7211, 0x722e, 0x7217, 0x7225, 0x7216, 0x7291, 0x7290,
  0x7293, 0x7296, 0x7380, 0x7382, 0x7384, 0x7385, 0x7cc0, 0x7cb6,
  0x7cc2, 0x7cc1, 0x7cdc, 0x7cc3, 0x7cd9, 0x7cc5, 0x7cce, 0x7cc9,
  0x7cc4, 0x7d97, 0x7dac, 0x7dad, 0x7d91, 0x7daf, 0x7d96, 0x6f7b,
  0x7e34, 0x7ebf, 0x7eb9, 0x7ebe, 0x7fba, 0x7fc6, 0x7fb3, 0x7fa1,
  0x7fc3, 0x7fa2, 0x7fb4, 0x7fc7, 0x7fb8, 0x78c8, 0x78c5, 0x78c1,
  0x78c6, 0x79fa, 0x79d6, 0x79e7, 0x79ea, 0x79da, 0x79ec, 0x7a0e,
  0x79f7, 0x79eb, 0x79fb, 0x79fc, 0x79fd, 0x79e3, 0x79d2, 0x7b7b,
  0x7ba1, 0x7bbd, 0x7ba0, 0x7be0, 0x7be6, 0x7be7, 0x7be1, 0x7beb,
  0x7be5, 0x8469, 0x846a, 0x85ae, 0x8592,
  /* 0xe7 */
  0x8593, 0x8598, 0x85af, 0x8594, 0x859a, 0x861b, 0x8642, 0x865e,
  0x865f, 0x865d, 0x8643, 0x865c, 0x8129, 0x8136, 0x8102, 0x810d,
  0x8124, 0x8103, 0x8104, 0x8100, 0x8112, 0x8107, 0x812a, 0x8111,
  0x80f6, 0x8126, 0x80f7, 0x8105, 0x8101, 0x80f9, 0x8127, 0x80ff,
  0x8118, 0x80fa, 0x80e6, 0x80fe, 0x80f1, 0x811f, 0x80e7, 0x80e4,
  0x811b, 0x80f3, 0x8125, 0x8110, 0x8123, 0x810f, 0x80f0, 0x8113,
  0x80fb, 0x813c, 0x812b, 0x80ea, 0x80e5, 0x80fd, 0x80e2, 0x80f4,
  0x8115, 0x812d, 0x813d, 0x8106, 0x8114, 0x8122, 0x826f, 0x835b,
  0x836e, 0x8369, 0x837a, 0x83ec, 0x837e, 0x8355, 0x8359, 0x8356,
  0x835f, 0x836c, 0x8357, 0x835c, 0x8353, 0x8360, 0x8367, 0x835d,
  0x8343, 0x8352, 0x8350, 0x8362, 0x8361, 0x8377, 0x8363, 0x8351,
  0x8368, 0x8342, 0x8376, 0x8378, 0x836f, 0x836a, 0x8364, 0x8c57,
  0x8d08, 0x8d01, 0x8d19, 0x8d06, 0x8d1a, 0x8d15, 0x8d14, 0x8d0b,
  0x8d1b, 0x8d1c, 0x8d03, 0x8d04, 0x8daf, 0x8da9, 0x8dae, 0x8de0,
  0x8dfd, 0x8de1, 0x8ec2, 0x8ecb, 0x8eb5, 0x8ede, 0x8edc, 0x8ed9,
  0x8ed8, 0x8eb6, 0x8eda, 0x8eb3, 0x8ecd, 0x8ec8, 0x8ed5, 0x8ece,
  0x8eb7, 0x8eb0, 0x8ed4, 0x8833, 0x8840, 0x8882, 0x88e8, 0x88d2,
  0x88d4, 0x88e5, 0x88d7, 0x88d0, 0x88ea, 0x89ad, 0x8991, 0x89ac,
  0x8996, 0x8a2d, 0x8a2e, 0x8a28, 0x8a29, 0x8a23, 0x8a18, 0x8a16,
  0x8a1b, 0x8a1c, 0x8a14, 0x8a2b, 0x8a2a,
  /* 0xe8 */
  0x8a19, 0x8a1f, 0x8a15, 0x8a1e, 0x8a11, 0x8a1a, 0x8a17, 0x8b21,
  0x8b29, 0x8b15, 0x8b17, 0x8b2d, 0x8b2e, 0x8b1b, 0x8b1a, 0x947e,
  0x947d, 0x9462, 0x946a, 0x9466, 0x9522, 0x9526, 0x9524, 0x9527,
  0x953f, 0x952b, 0x9523, 0x9588, 0x958b, 0x9587, 0x958c, 0x958f,
  0x9589, 0x958d, 0x96dd, 0x96ce, 0x96c9, 0x96cd, 0x96d4, 0x96bb,
  0x96c2, 0x96fc, 0x96d2, 0x96d5, 0x96e4, 0x96da, 0x96d0, 0x96c1,
  0x96e2, 0x96cf, 0x96e5, 0x96c7, 0x96c5, 0x96c3, 0x96eb, 0x96c0,
  0x96d8, 0x96c4, 0x96ed, 0x96d3, 0x96ea, 0x96dc, 0x96de, 0x96b8,
  0x96ec, 0x96cb, 0x96b9, 0x9171, 0x91a1, 0x91a6, 0x91a3, 0x91bd,
  0x92a9, 0x92af, 0x92de, 0x9308, 0x9305, 0x930f, 0x9357, 0x9387,
  0x9383, 0x9385, 0x93dd, 0x93c2, 0x9c13, 0x9c10, 0x9c2b, 0x9c24,
  0x9c25, 0x9c2d, 0x9c16, 0x9c2a, 0x9cbf, 0x9d05, 0x9cf7, 0x9d1c,
  0x9d19, 0x9d1b, 0x9d1a, 0x9d18, 0x9dd1, 0x9dc0, 0x9dc2, 0x9dde,
  0x9dd9, 0x9dc3, 0x9dc4, 0x9ddb, 0x9dd5, 0x9dc6, 0x9dda, 0x9dc1,
  0x9ebe, 0x9ee1, 0x9ee6, 0x9efe, 0x9eff, 0x9efc, 0x9f4b, 0x9f4e,
  0x9f6a, 0x9f79, 0x9f7c, 0x9f6b, 0x9f7b, 0x9f78, 0x9f7d, 0x9f65,
  0x9f69, 0x9f61, 0x98f1, 0x98f7, 0x98f0, 0x98f2, 0x98fa, 0x990a,
  0x990d, 0x98f4, 0x98f6, 0x9905, 0x9908, 0x9909, 0x9a8e, 0x9ade,
  0x9b02, 0x9b1d, 0x5511, 0x551e, 0x551a, 0x5517, 0x551c, 0x55d3,
  0x5739, 0x57ec, 0x527d, 0x526d, 0x5263,
  /* 0xe9 */
  0x527e, 0x526b, 0x526e, 0x5260, 0x527f, 0x5253, 0x527a, 0x5311,
  0x5316, 0x5cc5, 0x5cb0, 0x5cc4, 0x5cb2, 0x5cb7, 0x5ccf, 0x5cb1,
  0x5ccb, 0x5f1a, 0x5f14, 0x5f16, 0x5f2c, 0x5f19, 0x5f1e, 0x5f1d,
  0x5f1b, 0x5f25, 0x5f17, 0x5f2d, 0x5f13, 0x5fe2, 0x59a1, 0x59bc,
  0x59a4, 0x59aa, 0x59b8, 0x59bd, 0x59a3, 0x59a7, 0x59a5, 0x59bf,
  0x59a0, 0x59a2, 0x59b9, 0x5a6a, 0x5a65, 0x5a6b, 0x5a62, 0x5ae4,
  0x5aea, 0x5aeb, 0x5ae5, 0x5ae8, 0x5b46, 0x5bb1, 0x6590, 0x65a5,
  0x659b, 0x65c8, 0x65b9, 0x65cb, 0x65cc, 0x65c1, 0x65b7, 0x65b2,
  0x65b5, 0x6581, 0x60da, 0x60db, 0x60dd, 0x60c2, 0x60c4, 0x60b0,
  0x6084, 0x60ce, 0x60d6, 0x60fe, 0x60d4, 0x613e, 0x6172, 0x6171,
  0x61af, 0x62c5, 0x62b3, 0x62cd, 0x62c7, 0x62c6, 0x62c2, 0x62b0,
  0x62b6, 0x62b7, 0x62c1, 0x632e, 0x6e39, 0x6e6b, 0x6e44, 0x6e6a,
  0x6e3f, 0x6e65, 0x6e33, 0x6e50, 0x6e60, 0x6e7b, 0x6e56, 0x6e5c,
  0x6e25, 0x6e57, 0x6e36, 0x6e32, 0x6e4c, 0x6e67, 0x6e69, 0x6e5d,
  0x6e42, 0x6e59, 0x6e62, 0x6e64, 0x6e6d, 0x6e31, 0x6e53, 0x6e5b,
  0x6e58, 0x6e40, 0x6e43, 0x6e4b, 0x6f58, 0x6f59, 0x6f5b, 0x6faa,
  0x6fa7, 0x6fa6, 0x6fc5, 0x6fca, 0x6809, 0x680e, 0x680b, 0x6ba0,
  0x6bc6, 0x6bae, 0x6bca, 0x6bb1, 0x6bc3, 0x6bc5, 0x6b53, 0x6bc9,
  0x6bb0, 0x6b93, 0x6bc7, 0x6ba5, 0x7409, 0x6ba8, 0x6ba3, 0x6bb7,
  0x6ba1, 0x6ba7, 0x6bc2, 0x6bb2, 0x6bb5,
  /* 0xea */
  0x6baf, 0x6bc4, 0x6ba6, 0x6bc0, 0x6ba2, 0x6bbf, 0x6bbd, 0x75c8,
  0x75cf, 0x75b2, 0x75b5, 0x75db, 0x75cd, 0x75cc, 0x75c6, 0x75d9,
  0x75c7, 0x75ca, 0x75c2, 0x75b0, 0x75d5, 0x75b1, 0x75cb, 0x75d7,
  0x75d6, 0x7690, 0x7693, 0x7764, 0x776b, 0x776a, 0x7761, 0x7768,
  0x7766, 0x7767, 0x7072, 0x7097, 0x70ad, 0x7099, 0x709f, 0x7098,
  0x70ac, 0x7106, 0x718d, 0x7222, 0x7220, 0x723c, 0x7230, 0x723e,
  0x7231, 0x7238, 0x723f, 0x723d, 0x72b6, 0x72eb, 0x7397, 0x7390,
  0x73ac, 0x7391, 0x7396, 0x73af, 0x73ae, 0x7398, 0x7394, 0x739a,
  0x7cd0, 0x7ce4, 0x7ce8, 0x7ce7, 0x7cd3, 0x7cee, 0x7cd6, 0x7cec,
  0x7cef, 0x7ce0, 0x7cd2, 0x7ced, 0x7da9, 0x7e49, 0x7e45, 0x7e4a,
  0x7ebb, 0x7eb5, 0x7eb8, 0x7ebc, 0x7eba, 0x7fd3, 0x7fee, 0x7fea,
  0x7fd0, 0x7fd8, 0x7fe8, 0x7fd7, 0x7fe5, 0x7ff4, 0x7fd9, 0x7fe7,
  0x7fef, 0x7fd1, 0x7fe6, 0x7fd5, 0x7fd2, 0x78df, 0x78d9, 0x78da,
  0x78dd, 0x78dc, 0x7a1f, 0x7a2c, 0x7a1a, 0x7a01, 0x7a12, 0x7a2d,
  0x7a1e, 0x7a03, 0x7a11, 0x7a18, 0x7a17, 0x7a2f, 0x7a06, 0x7a02,
  0x7a1b, 0x7a00, 0x7a19, 0x7a28, 0x7a29, 0x7b4e, 0x7b76, 0x7b71,
  0x7b77, 0x7bbc, 0x7be2, 0x8427, 0x8424, 0x8461, 0x85bc, 0x85ab,
  0x85a3, 0x85b4, 0x85b8, 0x85a6, 0x85bd, 0x85a1, 0x85b9, 0x85bf,
  0x85ba, 0x85aa, 0x85ff, 0x8658, 0x865b, 0x865a, 0x815b, 0x8148,
  0x8166, 0x8140, 0x815e, 0x816c, 0x8155,
  /* 0xeb */
  0x814d, 0x814b, 0x8169, 0x814c, 0x816f, 0x8149, 0x815c, 0x814a,
  0x816e, 0x8133, 0x8156, 0x817c, 0x8143, 0x8163, 0x8178, 0x8158,
  0x816a, 0x816d, 0x8181, 0x816b, 0x8150, 0x8159, 0x8168, 0x8161,
  0x826e, 0x8268, 0x8269, 0x8396, 0x8382, 0x839a, 0x839e, 0x839f,
  0x8385, 0x838c, 0x839b, 0x8395, 0x8374, 0x838a, 0x83ae, 0x8388,
  0x839d, 0x839c, 0x8390, 0x8389, 0x8399, 0x8391, 0x8397, 0x8384,
  0x8d13, 0x8d2b, 0x8d3d, 0x8d20, 0x8d23, 0x8d2a, 0x8d3c, 0x8d2f,
  0x8d24, 0x8d2e, 0x8d22, 0x8d21, 0x8d12, 0x8dfc, 0x8eed, 0x8eef,
  0x8eff, 0x8ef9, 0x8ef8, 0x8ed0, 0x8f19, 0x8ee9, 0x8ed2, 0x8efd,
  0x8ec5, 0x8ed3, 0x8eec, 0x8ee5, 0x8ef2, 0x8ee2, 0x8ef6, 0x889c,
  0x889f, 0x889d, 0x88f8, 0x88e3, 0x88fc, 0x88fd, 0x88fe, 0x8961,
  0x8963, 0x89a8, 0x89aa, 0x8a3e, 0x8a33, 0x8a35, 0x8a4d, 0x8a48,
  0x8a3b, 0x8a31, 0x8a30, 0x8a4c, 0x8a3d, 0x8a32, 0x8ab0, 0x8b3b,
  0x8b23, 0x8b38, 0x8b3f, 0x8b34, 0x8b3a, 0x8b39, 0x947b, 0x9474,
  0x9476, 0x948b, 0x94f7, 0x953e, 0x9538, 0x953b, 0x959e, 0x959d,
  0x959c, 0x9580, 0x9582, 0x972a, 0x9713, 0x9705, 0x9712, 0x970b,
  0x9702, 0x9777, 0x9735, 0x9731, 0x9716, 0x972e, 0x971f, 0x970c,
  0x974b, 0x9720, 0x9703, 0x9700, 0x96c6, 0x9710, 0x96f7, 0x9728,
  0x971e, 0x96f4, 0x96fa, 0x9739, 0x970f, 0x9729, 0x96f2, 0x9724,
  0x9734, 0x9738, 0x9727, 0x9719, 0x9701,
  /* 0xec */
  0x9706, 0x96f3, 0x9704, 0x970d, 0x96f6, 0x971b, 0x91b1, 0x91c0,
  0x91b3, 0x91b4, 0x91b7, 0x91bb, 0x91b2, 0x91b8, 0x91b0, 0x92a4,
  0x92d9, 0x9306, 0x931f, 0x931d, 0x9394, 0x939a, 0x9399, 0x93fd,
  0x93f5, 0x9c38, 0x9c22, 0x9c3f, 0x9d29, 0x9d12, 0x9d2a, 0x9d24,
  0x9d93, 0x9de3, 0x9de1, 0x9de8, 0x9de9, 0x9dfd, 0x9dee, 0x9de7,
  0x9de4, 0x9dea, 0x9eb4, 0x9eb2, 0x9eb9, 0x9eb6, 0x9efb, 0x9ef7,
  0x9ef4, 0x9efa, 0x9f3e, 0x9f8d, 0x9f88, 0x9f8a, 0x9f71, 0x9f73,
  0x9f76, 0x9f8f, 0x9f9e, 0x9f9f, 0x9f9d, 0x9f77, 0x9f98, 0x9f70,
  0x9f85, 0x9928, 0x991a, 0x992d, 0x9913, 0x9919, 0x9924, 0x9910,
  0x9915, 0x992f, 0x991d, 0x9914, 0x9912, 0x9a85, 0x9a8b, 0x9a8a,
  0x9aa3, 0x9aa0, 0x9ad8, 0x9adb, 0x9af7, 0x9b1f, 0x9b30, 0x552b,
  0x5528, 0x552f, 0x5529, 0x552d, 0x5524, 0x56f9, 0x529e, 0x5281,
  0x5280, 0x528b, 0x5289, 0x528e, 0x5273, 0x528f, 0x5272, 0x528c,
  0x5cdb, 0x5cd9, 0x5cc2, 0x5cdf, 0x5f20, 0x5f28, 0x5f3f, 0x5f2e,
  0x5f21, 0x5f2a, 0x5f2b, 0x5f22, 0x5f23, 0x5f76, 0x5ffc, 0x5fff,
  0x59ba, 0x5a61, 0x5a67, 0x5bb3, 0x5bb6, 0x65ce, 0x65b8, 0x65b1,
  0x65ea, 0x65ed, 0x65e8, 0x65e9, 0x65e5, 0x65d3, 0x60e2, 0x60e4,
  0x60ee, 0x60e6, 0x60e9, 0x60e5, 0x618c, 0x618d, 0x61bb, 0x61d7,
  0x62df, 0x6e80, 0x6e9b, 0x6e8c, 0x6ea8, 0x6e84, 0x6e92, 0x6e96,
  0x6eac, 0x6e93, 0x6e8a, 0x6e9e, 0x6e83,
  /* 0xed */
  0x6e98, 0x6e8e, 0x6ea5, 0x6ea9, 0x6e9c, 0x6e72, 0x6eab, 0x6e97,
  0x6e88, 0x6e81, 0x6e9f, 0x6f56, 0x6fa0, 0x6804, 0x6bc1, 0x6ba4,
  0x6bf9, 0x6bd9, 0x6bee, 0x6bd1, 0x6be0, 0x6bea, 0x6beb, 0x6bd3,
  0x6bff, 0x6bd0, 0x6bef, 0x6be5, 0x75ec, 0x75fc, 0x75e5, 0x75ff,
  0x75e9, 0x75fd, 0x75ef, 0x777e, 0x7763, 0x7762, 0x709a, 0x70bf,
  0x70a6, 0x709d, 0x70a7, 0x70a0, 0x70bc, 0x70a8, 0x70a2, 0x711d,
  0x711c, 0x711f, 0x7102, 0x7189, 0x724e, 0x7245, 0x7244, 0x724a,
  0x72a9, 0x72e4, 0x73b8, 0x73a6, 0x73bf, 0x73ba, 0x73bb, 0x73b9,
  0x73bc, 0x73a5, 0x73fd, 0x7cfe, 0x7cf0, 0x7d0f, 0x7cf6, 0x7cf1,
  0x7cff, 0x7d08, 0x7cf4, 0x7cf3, 0x7d09, 0x7da6, 0x7da5, 0x7e51,
  0x7e56, 0x7e5b, 0x7e55, 0x7e59, 0x7e57, 0x7eb3, 0x7ecd, 0x7ecc,
  0x7808, 0x7802, 0x7fff, 0x780d, 0x7ff2, 0x7ff6, 0x7803, 0x7ff9,
  0x7806, 0x7ffe, 0x780f, 0x7804, 0x780e, 0x780c, 0x7ff5, 0x7ff0,
  0x780b, 0x7ffd, 0x7ffc, 0x781d, 0x7807, 0x78e5, 0x7a20, 0x7a31,
  0x7a4f, 0x7a3e, 0x9c45, 0x7a35, 0x7a27, 0x7a44, 0x7a4d, 0x7a4a,
  0x7a24, 0x7a41, 0x7a3d, 0x7a36, 0x7a3b, 0x7a49, 0x7a37, 0x7b48,
  0x7b72, 0x7b73, 0x7b70, 0x7bf9, 0x7bff, 0x8421, 0x85b6, 0x85c9,
  0x85c1, 0x85c7, 0x85c8, 0x85ca, 0x85b1, 0x85e4, 0x8656, 0x8657,
  0x8651, 0x818e, 0x818d, 0x8182, 0x81aa, 0x8198, 0x81ad, 0x8186,
  0x81ae, 0x8176, 0x81a9, 0x8197, 0x8193,
  /* 0xee */
  0x817a, 0x8171, 0x8184, 0x81ac, 0x8177, 0x8175, 0x815a, 0x8183,
  0x819b, 0x818b, 0x8180, 0x8194, 0x8190, 0x818c, 0x81af, 0x818f,
  0x8185, 0x8188, 0x8174, 0x817b, 0x8195, 0x819d, 0x8192, 0x8265,
  0x83b3, 0x83a7, 0x83a0, 0x83c8, 0x83bd, 0x83a1, 0x83b4, 0x83b8,
  0x83b1, 0x83a3, 0x83c4, 0x83ce, 0x83cf, 0x83c1, 0x83ba, 0x83a2,
  0x83c9, 0x83c7, 0x83b9, 0x83bb, 0x83b2, 0x83b5, 0x83b0, 0x83d3,
  0x83bf, 0x8d38, 0x8d3e, 0x8d31, 0x8d33, 0x8d4c, 0x8d5f, 0x8d3a,
  0x8d4f, 0x8da0, 0x8da2, 0x8da3, 0x8dff, 0x8dfe, 0x8f13, 0x8f15,
  0x8f1b, 0x8f1c, 0x8f08, 0x8f06, 0x8f2f, 0x8f02, 0x8f1f, 0x8f18,
  0x8f0a, 0x8f00, 0x8f05, 0x8f0b, 0x8f11, 0x8f1e, 0x8f17, 0x8842,
  0x887d, 0x887f, 0x887c, 0x8862, 0x8898, 0x8899, 0x88f4, 0x8962,
  0x8a43, 0x8a40, 0x8a5e, 0x8a5d, 0x8a41, 0x8a4a, 0x8b4e, 0x8b4d,
  0x9488, 0x9473, 0x9535, 0x9597, 0x95af, 0x9596, 0x9594, 0x9592,
  0x95ac, 0x9590, 0x95ad, 0x97ac, 0x978e, 0x97a2, 0x9769, 0x975b,
  0x974a, 0x9771, 0x9755, 0x9751, 0x977b, 0x9744, 0x975d, 0x975c,
  0x976d, 0x9760, 0x9782, 0x9741, 0x9767, 0x9774, 0x975a, 0x9758,
  0x975f, 0x9742, 0x977c, 0x977a, 0x9776, 0x976c, 0x9753, 0x976e,
  0x976a, 0x978d, 0x9743, 0x9754, 0x91ca, 0x91cd, 0x91c4, 0x91ce,
  0x91c8, 0x91ba, 0x92a3, 0x92bd, 0x92a1, 0x932d, 0x9312, 0x9315,
  0x9310, 0x9314, 0x9397, 0x93ac, 0x9391,
  /* 0xef */
  0x9393, 0x9390, 0x93d8, 0x93d9, 0x93fc, 0x9c4c, 0x9c49, 0x9c47,
  0x9c44, 0x9c48, 0x9c4e, 0x9d28, 0x9d26, 0x9d21, 0x9d27, 0x9d3e,
  0x9d3f, 0x9d22, 0x9d20, 0x9d3c, 0x9d3d, 0x9d95, 0x9dae, 0x9dac,
  0x9e0f, 0x9df7, 0x9df9, 0x9dfa, 0x9df4, 0x9df5, 0x9dfb, 0x9df6,
  0x9df0, 0x9df3, 0x9df1, 0x9e0e, 0x9eb3, 0x9ef3, 0x9ef0, 0x9f0c,
  0x9ef1, 0x9f45, 0x9f97, 0x9fa5, 0x9f93, 0x9f96, 0x9fab, 0x9fac,
  0x9fa8, 0x9fa9, 0x9f8b, 0x9faf, 0x9fad, 0x9fa2, 0x993e, 0x994c,
  0x996a, 0x993b, 0x9923, 0x9922, 0x993c, 0x9935, 0x993d, 0x9948,
  0x994f, 0x994e, 0x9933, 0x993a, 0x994d, 0x9930, 0x7bf8, 0x9920,
  0x9a87, 0x9a84, 0x9a80, 0x9abd, 0x9ac5, 0x9ad7, 0x9af6, 0x9af2,
  0x9b29, 0x9b2e, 0x9b2f, 0x9b59, 0x9bad, 0x553c, 0x5520, 0x5523,
  0x5295, 0x5291, 0x529a, 0x5297, 0x5290, 0x5294, 0x5d7d, 0x5f31,
  0x5864, 0x5867, 0x59cd, 0x5a60, 0x5a63, 0x65d5, 0x65d2, 0x65e0,
  0x65e3, 0x65fc, 0x65e7, 0x65fd, 0x65e6, 0x65db, 0x65e4, 0x60f2,
  0x6109, 0x60f0, 0x60f5, 0x610c, 0x610e, 0x60f1, 0x6199, 0x61d6,
  0x62d7, 0x62d6, 0x62d5, 0x6ec8, 0x6eb4, 0x6eb0, 0x6eec, 0x6ecb,
  0x6eb7, 0x6ebb, 0x6eba, 0x6eca, 0x6eb9, 0x6ea0, 0x6f53, 0x6fc4,
  0x6806, 0x740a, 0x7401, 0x7400, 0x740c, 0x7408, 0x7419, 0x7403,
  0x6bf2, 0x740d, 0x6bf6, 0x742b, 0x6bf1, 0x6bfa, 0x7407, 0x760c,
  0x75f2, 0x75f4, 0x760e, 0x75f0, 0x777b,
  /* 0xf0 */
  0x70b5, 0x70cd, 0x70b8, 0x70cc, 0x70b3, 0x70bb, 0x70b6, 0x70cf,
  0x7119, 0x711e, 0x7251, 0x7269, 0x7254, 0x725d, 0x725e, 0x725a,
  0x7257, 0x72ab, 0x72b0, 0x72e1, 0x73cf, 0x73b7, 0x7cf2, 0x7d01,
  0x7d1e, 0x7d19, 0x7d04, 0x7d1d, 0x7d1f, 0x7d1c, 0x7da0, 0x7da1,
  0x7e52, 0x7811, 0x7824, 0x7814, 0x782d, 0x7812, 0x7820, 0x7810,
  0x782b, 0x7825, 0x782f, 0x7828, 0x783d, 0x7a51, 0x7a5d, 0x7a5b,
  0x7a6e, 0x7a55, 0x7a6f, 0x7a52, 0x7a5c, 0x7a6d, 0x7a5a, 0x7a5e,
  0x7bb8, 0x7bbe, 0x7bfa, 0x7bf5, 0x8478, 0x85dc, 0x85df, 0x85dd,
  0x8652, 0x8653, 0x81b9, 0x81cb, 0x81cd, 0x81ce, 0x81cf, 0x81be,
  0x81b8, 0x81b0, 0x81ca, 0x81c9, 0x81b2, 0x81c6, 0x81c3, 0x81c5,
  0x81c8, 0x81bc, 0x81bb, 0x81df, 0x8229, 0x81b5, 0x81ba, 0x81b3,
  0x8264, 0x83ea, 0x83eb, 0x83ef, 0x83d6, 0x83e6, 0x83e7, 0x83e8,
  0x83d2, 0x83fe, 0x83e9, 0x83d9, 0x83d1, 0x83de, 0x83e0, 0x83d5,
  0x83ee, 0x83a9, 0x83da, 0x83d4, 0x8c0c, 0x83f9, 0x83e5, 0x83d0,
  0x8d5e, 0x8d46, 0x8d42, 0x8d41, 0x8d4b, 0x8d5d, 0x8d5c, 0x8d44,
  0x8f27, 0x8f2a, 0x8f2e, 0x8f3e, 0x8f3d, 0x8f38, 0x8f4a, 0x8f22,
  0x8f31, 0x8f33, 0x8f3c, 0x8f28, 0x8f3a, 0x8f2b, 0x8f3b, 0x8f23,
  0x8f29, 0x8f36, 0x8f30, 0x8f37, 0x884f, 0x8878, 0x8894, 0x8895,
  0x889a, 0x88f3, 0x8909, 0x890f, 0x890d, 0x8a51, 0x8a6f, 0x8a6d,
  0x8a5a, 0x8a5b, 0x8a53, 0x8a68, 0x8a6a,
  /* 0xf1 */
  0x8a56, 0x8a57, 0x8a6c, 0x8a50, 0x8a64, 0x8a59, 0x8b4b, 0x8b4a,
  0x8b45, 0x8b46, 0x9525, 0x9537, 0x9536, 0x9533, 0x95a5, 0x95a8,
  0x95aa, 0x95a2, 0x95a7, 0x97b8, 0x9781, 0x979f, 0x97ba, 0x9796,
  0x9790, 0x9784, 0x97aa, 0x9783, 0x97a7, 0x9793, 0x97ab, 0x9798,
  0x9785, 0x9794, 0x9792, 0x9780, 0x97bc, 0x979c, 0x97bf, 0x97a9,
  0x97a5, 0x97b9, 0x97ae, 0x97a8, 0x91df, 0x91de, 0x91dc, 0x92be,
  0x92da, 0x92d7, 0x59cf, 0x92d2, 0x92d5, 0x92d0, 0x932e, 0x932f,
  0x9328, 0x93a1, 0x93a3, 0x93a5, 0x93a6, 0x93a9, 0x93a7, 0x93af,
  0x93a8, 0x93da, 0x93d4, 0x93db, 0x93d5, 0x93f7, 0x9c5d, 0x9c5c,
  0x9c5f, 0x9cb5, 0x9d4c, 0x9d31, 0x9d37, 0x9e02, 0x9e06, 0x9e04,
  0x9e00, 0x9e09, 0x9e1c, 0x9e07, 0x9e08, 0x9e0a, 0x9e0b, 0x9ecd,
  0x9ed1, 0x9f05, 0x9f09, 0x9f08, 0x9f24, 0x9f38, 0x9f47, 0x9f41,
  0x9f46, 0x9fca, 0x9fcb, 0x9fce, 0x9fb2, 0x9fcc, 0x9fb8, 0x9fb5,
  0x9fde, 0x9fbb, 0x9fc9, 0x9fb4, 0x9fb0, 0x9951, 0x995e, 0x9942,
  0x9947, 0x9956, 0x9946, 0x9954, 0x995b, 0x9941, 0x995a, 0x995f,
  0x9959, 0x9952, 0x9955, 0x9957, 0x9a83, 0x9a81, 0x9ad2, 0x9b0c,
  0x9b0d, 0x9b1b, 0x9b28, 0x9b26, 0x9b27, 0x9b24, 0x9b25, 0x9b41,
  0x9b58, 0x5539, 0x5538, 0x569b, 0x56fa, 0x57b9, 0x52a6, 0x52a0,
  0x52ab, 0x52aa, 0x52a7, 0x52a1, 0x5cd7, 0x5cd0, 0x5cd6, 0x5d1f,
  0x5f30, 0x5f33, 0x5f32, 0x59ce, 0x5a7d,
  /* 0xf2 */
  0x5bb2, 0x65f6, 0x610a, 0x611d, 0x6100, 0x6104, 0x6101, 0x6103,
  0x6189, 0x61d3, 0x61d0, 0x62d3, 0x6eea, 0x6eed, 0x6ec1, 0x6edc,
  0x6ed4, 0x6ec6, 0x6ed2, 0x6ed1, 0x6edd, 0x6ee6, 0x6ec2, 0x6ec0,
  0x6ed3, 0x6f6d, 0x6fbd, 0x6801, 0x7414, 0x742a, 0x742d, 0x741b,
  0x7426, 0x742c, 0x742f, 0x742e, 0x7424, 0x741a, 0x7429, 0x7411,
  0x7427, 0x7601, 0x7607, 0x760a, 0x760f, 0x7608, 0x76a8, 0x76ab,
  0x76a9, 0x76ae, 0x76ac, 0x70c6, 0x70c8, 0x70ba, 0x70ce, 0x711b,
  0x726d, 0x73c4, 0x73c7, 0x73c9, 0x73fc, 0x7d10, 0x7d16, 0x7d2c,
  0x7d11, 0x7d1a, 0x7d13, 0x7dbd, 0x7e6a, 0x7e65, 0x783e, 0x7831,
  0x7834, 0x7821, 0x7836, 0x78e1, 0x78e7, 0x7a7b, 0x7a78, 0x7a75,
  0x7a7d, 0x7a7a, 0x7a62, 0x7a77, 0x7a7f, 0x7a79, 0x7a65, 0x7b46,
  0x7b47, 0x7b8e, 0x7b8b, 0x7bba, 0x7bf0, 0x7bf3, 0x8475, 0x85da,
  0x85d8, 0x8669, 0x866c, 0x866e, 0x81e6, 0x81fc, 0x81e0, 0x81d4,
  0x81ec, 0x81e5, 0x81d7, 0x81da, 0x81e1, 0x81ff, 0x81f5, 0x81d5,
  0x81d2, 0x81ee, 0x81d1, 0x81dc, 0x81fd, 0x81eb, 0x81e2, 0x81d3,
  0x81ef, 0x8c0d, 0x83f7, 0x8c0e, 0x83fb, 0x83fa, 0x8c04, 0x8c01,
  0x8c06, 0x8c0b, 0x83f1, 0x8c05, 0x83f2, 0x8c07, 0x8c0f, 0x8d6f,
  0x8d57, 0x8d56, 0x8d5a, 0x8d6c, 0x8d51, 0x8d55, 0x8d50, 0x8d54,
  0x8d85, 0x8dba, 0x8dbb, 0x8dfb, 0x8f5d, 0x8f45, 0x8f47, 0x8f4d,
  0x8f5e, 0x8f5b, 0x8f59, 0x8f46, 0x8f58,
  /* 0xf3 */
  0x8f5c, 0x8f4f, 0x8f5f, 0x8f5a, 0x884e, 0x887a, 0x887b, 0x8897,
  0x890b, 0x890a, 0x8904, 0x89a1, 0x89a7, 0x89a0, 0x89a6, 0x8a60,
  0x8a75, 0x8a7e, 0x8a67, 0x8a62, 0x8a76, 0x8acf, 0x8b5f, 0x8b5c,
  0x8b42, 0x8b5d, 0x8b5e, 0x8bb9, 0x954d, 0x9532, 0x95bd, 0x95a0,
  0x97d3, 0x97ca, 0x97c2, 0x97cf, 0x97d7, 0x97dd, 0x97f4, 0x97e1,
  0x97c1, 0x97d4, 0x97a4, 0x97eb, 0x97c7, 0x97d9, 0x97e3, 0x97ee,
  0x97d8, 0x97c9, 0x97c3, 0x97cd, 0x97df, 0x97ea, 0x9170, 0x91d7,
  0x91d6, 0x92ec, 0x9324, 0x9326, 0x9321, 0x9325, 0x932b, 0x93be,
  0x93ba, 0x93bb, 0x93d0, 0x93d3, 0x93d2, 0x9c51, 0x9c54, 0x9c50,
  0x9c5a, 0x9cb2, 0x9cb0, 0x9cb6, 0x9cb3, 0x9d45, 0x9d4a, 0x9d4e,
  0x9dab, 0x9daa, 0x9e17, 0x9e18, 0x9e28, 0x9e10, 0x9e29, 0x9e16,
  0x9e2f, 0x9e2d, 0x9e2a, 0x9e2e, 0x9e13, 0x9e11, 0x9e19, 0x9ecf,
  0x9f06, 0x9f07, 0x9f03, 0x9f01, 0x9f3a, 0x9fe7, 0x9fe6, 0x9fed,
  0x9fd3, 0x9fe9, 0x9feb, 0x9fef, 0x9ffd, 0x9fd9, 0x9fda, 0x9fe1,
  0x9fd1, 0x9fd4, 0x9fe8, 0x9fd8, 0x9fec, 0x9fd7, 0x997a, 0x998c,
  0x9987, 0x9989, 0x9985, 0x997c, 0x998d, 0x9975, 0x998b, 0x9986,
  0x9981, 0x9970, 0x9966, 0x9979, 0x9978, 0x997d, 0x9964, 0x9988,
  0x997e, 0x9976, 0x998f, 0x9962, 0x9974, 0x9972, 0x998a, 0x9965,
  0x9a99, 0x9a9c, 0x9acd, 0x9af1, 0x9b20, 0x9b4d, 0x9b4c, 0x9b40,
  0x9b5b, 0x9b5a, 0x9b55, 0x573a, 0x52bf,
  /* 0xf4 */
  0x52b8, 0x52be, 0x5cee, 0x5f48, 0x59cb, 0x59ca, 0x5ae3, 0x5ae2,
  0x5bcd, 0x5bcc, 0x65f4, 0x611a, 0x611b, 0x6118, 0x611e, 0x61d2,
  0x62e5, 0x62ee, 0x62e9, 0x6efe, 0x6efd, 0x6ee7, 0x6ee5, 0x6ef4,
  0x6efc, 0x6ee3, 0x6ee2, 0x7431, 0x7438, 0x7422, 0x743a, 0x7439,
  0x743c, 0x744f, 0x7435, 0x7432, 0x7437, 0x7434, 0x744d, 0x7436,
  0x743e, 0x744c, 0x761e, 0x7619, 0x76a5, 0x7770, 0x7771, 0x70b7,
  0x72a6, 0x72a7, 0x72b3, 0x72e0, 0x73c1, 0x73c3, 0x73c2, 0x73c0,
  0x73ff, 0x7d28, 0x7d2e, 0x7d2a, 0x7d25, 0x7d29, 0x7d24, 0x7dbf,
  0x7e63, 0x7e61, 0x7e60, 0x7efa, 0x7844, 0x7845, 0x7847, 0x784a,
  0x7848, 0x78e3, 0x7a76, 0x7a73, 0x7a8c, 0x7a8d, 0x7bb7, 0x7bf2,
  0x8474, 0x85d6, 0x85d4, 0x8606, 0x8665, 0x8664, 0x822f, 0x81f2,
  0x820c, 0x81f3, 0x8216, 0x820d, 0x81fb, 0x8209, 0x8204, 0x8208,
  0x8201, 0x81f0, 0x8c14, 0x8c1d, 0x8c1c, 0x8c1a, 0x8c1e, 0x8c1b,
  0x8d6e, 0x8d6b, 0x8db4, 0x8dfa, 0x8f6d, 0x8f67, 0x8f50, 0x8f65,
  0x8f6e, 0x8f68, 0x8f6a, 0x8f60, 0x89a3, 0x8a8b, 0x8a85, 0x8a89,
  0x8b54, 0x8b5b, 0x8b5a, 0x8b58, 0x8b55, 0x8b57, 0x9480, 0x954e,
  0x954c, 0x95ba, 0x95b8, 0x95bf, 0x95be, 0x9006, 0x901e, 0x97f6,
  0x902d, 0x9002, 0x9019, 0x97f3, 0x9018, 0x901d, 0x9025, 0x9014,
  0x9000, 0x97f8, 0x900d, 0x97fa, 0x900a, 0x9003, 0x901b, 0x901f,
  0x97f7, 0x9004, 0x97f5, 0x9007, 0x97f2,
  /* 0xf5 */
  0x97f1, 0x9001, 0x97fb, 0x901c, 0x900b, 0x91d3, 0x91ed, 0x91d2,
  0x9323, 0x9322, 0x93b4, 0x93b6, 0x93f0, 0x93f3, 0x9c6d, 0x9c6f,
  0x9c6e, 0x9c52, 0x9ccc, 0x9ccf, 0x9d5d, 0x9d43, 0x9d54, 0x9d41,
  0x9d46, 0x9d5e, 0x9e3f, 0x9e39, 0x9e3c, 0x9e21, 0x9e27, 0x9e3b,
  0x9e24, 0x9e23, 0x9e35, 0x9e20, 0x9eca, 0x9ec7, 0x9ecb, 0x9f1d,
  0x9f1f, 0x9f1c, 0x9806, 0x9805, 0x9ffa, 0x9808, 0x981f, 0x9ff5,
  0x984d, 0x980a, 0x9803, 0x980b, 0x981a, 0x9819, 0x9804, 0x9992,
  0x9994, 0x99a9, 0x9990, 0x999f, 0x9995, 0x999d, 0x9996, 0x99ad,
  0x9999, 0x9991, 0x99a7, 0x999a, 0x99ac, 0x9997, 0x99af, 0x99a5,
  0x9993, 0x99ae, 0x99b2, 0x99a4, 0x999b, 0x99ab, 0x99aa, 0x9a94,
  0x9a96, 0x9a97, 0x9ae8, 0x9ae9, 0x9aea, 0x9aeb, 0x9b3d, 0x9b23,
  0x9b56, 0x9b6d, 0x9b53, 0x9b50, 0x9b54, 0x9b9c, 0x5537, 0x5534,
  0x5695, 0x569a, 0x52ce, 0x52b0, 0x52b3, 0x5f45, 0x5f4a, 0x59c6,
  0x59c2, 0x5afc, 0x65f0, 0x6116, 0x6f0f, 0x6ef1, 0x6f0e, 0x6ef5,
  0x6f0d, 0x744e, 0x7449, 0x7447, 0x7445, 0x7444, 0x7448, 0x744b,
  0x7610, 0x7617, 0x7614, 0x7773, 0x711a, 0x7267, 0x73dd, 0x7d20,
  0x7d3c, 0x7d22, 0x7859, 0x785e, 0x78ff, 0x7a87, 0x7a8a, 0x7a85,
  0x7a86, 0x7a8b, 0x7a80, 0x7b40, 0x7bb6, 0x843d, 0x85d0, 0x8215,
  0x8227, 0x822b, 0x8212, 0x822e, 0x8211, 0x8214, 0x822a, 0x8223,
  0x822c, 0x822d, 0x8224, 0x8213, 0x8228,
  /* 0xf6 */
  0x8c24, 0x8c10, 0x8c16, 0x8c2d, 0x8c29, 0x8c11, 0x8c26, 0x8c47,
  0x8d60, 0x8d64, 0x8d63, 0x8d66, 0x8df7, 0x8f74, 0x8f75, 0x8f48,
  0x8f77, 0x8f76, 0x891d, 0x8919, 0x89a2, 0x8a83, 0x8a81, 0x8b53,
  0x8b56, 0x8b50, 0x954b, 0x9549, 0x9548, 0x95b4, 0x9032, 0x9036,
  0x903b, 0x9024, 0x9030, 0x9031, 0x903d, 0x9034, 0x9027, 0x903a,
  0x9021, 0x904d, 0x903c, 0x91e8, 0x91e9, 0x91ee, 0x9338, 0x9337,
  0x93b2, 0x93ec, 0x9c69, 0x9cc4, 0x9ccb, 0x9ccd, 0x9d55, 0x9d5b,
  0x9e34, 0x9e30, 0x9e4b, 0x9e49, 0x9e4f, 0x9e4c, 0x9e37, 0x9e32,
  0x9ec0, 0x9f18, 0x9f1a, 0x9f15, 0x9f1b, 0x9f37, 0x9f5f, 0x9826,
  0x9810, 0x9811, 0x9821, 0x982e, 0x9825, 0x9824, 0x9829, 0x982c,
  0x99ba, 0x99bb, 0x99b1, 0x99cc, 0x99ca, 0x99c7, 0x99c2, 0x99b3,
  0x99c8, 0x99ce, 0x99b6, 0x99b8, 0x99c3, 0x99b4, 0x99b7, 0x99a1,
  0x99c5, 0x99bc, 0x99a0, 0x99c1, 0x99be, 0x99c0, 0x99bf, 0x9a77,
  0x9a91, 0x9ae6, 0x9ae3, 0x9ae0, 0x9b16, 0x9b15, 0x9b17, 0x9b3c,
  0x9b43, 0x9b68, 0x9b69, 0x9b9f, 0x4ab4, 0x52cb, 0x52c8, 0x52c6,
  0x5d7c, 0x5f46, 0x5f41, 0x59d8, 0x59dc, 0x5aff, 0x612c, 0x612d,
  0x612b, 0x612f, 0x6f06, 0x6f05, 0x6f04, 0x6800, 0x7458, 0x745b,
  0x745a, 0x745f, 0x7613, 0x7612, 0x76a4, 0x7772, 0x70d5, 0x70d8,
  0x70d4, 0x70da, 0x7260, 0x72a0, 0x7d38, 0x7db9, 0x7e7d, 0x7e7c,
  0x785a, 0x7851, 0x7854, 0x7856, 0x7857,
  /* 0xf7 */
  0x78f9, 0x78fc, 0x7a9c, 0x7b42, 0x7b8a, 0x85d3, 0x8666, 0x8239,
  0x8238, 0x823e, 0x8221, 0x823f, 0x823b, 0x8c21, 0x8c25, 0x8c2b,
  0x8c27, 0x8c28, 0x8d7c, 0x8db2, 0x8db3, 0x8df6, 0x8f73, 0x8f89,
  0x8f8f, 0x8f8b, 0x8f88, 0x8f72, 0x8918, 0x8a98, 0x8a99, 0x8a97,
  0x8a9f, 0x8a9d, 0x8a9b, 0x8a9a, 0x8b6d, 0x8b6f, 0x954a, 0x9041,
  0x905d, 0x9047, 0x9046, 0x9042, 0x904a, 0x9048, 0x9045, 0x9044,
  0x904b, 0x9332, 0x93ee, 0x9c67, 0x9c64, 0x9cc6, 0x9d59, 0x9d56,
  0x9e43, 0x9e5e, 0x9e59, 0x9e41, 0x9e42, 0x9e45, 0x9e47, 0x9e44,
  0x9e5f, 0x9e5d, 0x9edd, 0x9f14, 0x9f26, 0x9f36, 0x9f5b, 0x9f58,
  0x984b, 0x9845, 0x9832, 0x9849, 0x9834, 0x983e, 0x984c, 0x9831,
  0x983a, 0x9839, 0x983f, 0x9830, 0x983b, 0x99d6, 0x99df, 0x99d3,
  0x99d7, 0x99c6, 0x99dd, 0x99d1, 0x99dc, 0x99d2, 0x99e4, 0x99d4,
  0x99d5, 0x99db, 0x99f8, 0x99d8, 0x99d0, 0x9abb, 0x9afd, 0x9b38,
  0x9b3e, 0x9b3f, 0x9b4f, 0x9b66, 0x9b98, 0x9baf, 0x5530, 0x5694,
  0x5ce5, 0x5cea, 0x5d7f, 0x5f40, 0x59d5, 0x8c22, 0x5b42, 0x660c,
  0x660e, 0x6609, 0x6124, 0x6128, 0x619b, 0x62e6, 0x6f1c, 0x6f1f,
  0x6f02, 0x6fc7, 0x7456, 0x7457, 0x762f, 0x778f, 0x778c, 0x778e,
  0x727d, 0x73d9, 0x786a, 0x786b, 0x7a98, 0x8661, 0x8237, 0x824d,
  0x8234, 0x8231, 0x823c, 0x8236, 0x8233, 0x8c3d, 0x8c3f, 0x8c23,
  0x8c3e, 0x8d7b, 0x8d79, 0x8d7e, 0x8df3,
  /* 0xf8 */
  0x8f81, 0x8f83, 0x8f86, 0x8f85, 0x8848, 0x8914, 0x8a95, 0x8b69,
  0x8b6e, 0x95b1, 0x906f, 0x9058, 0x9050, 0x905a, 0x9053, 0x93c9,
  0x93c8, 0x9c0d, 0x9e5b, 0x9e54, 0x9f13, 0x9f12, 0x9f2d, 0x985f,
  0x9855, 0x985d, 0x9847, 0x9840, 0x9846, 0x9858, 0x9854, 0x9841,
  0x9843, 0x99f6, 0x99fa, 0x99e2, 0x99ee, 0x99e6, 0x99f5, 0x99e9,
  0x99fb, 0x99ec, 0x99e3, 0x99eb, 0x99ff, 0x99fd, 0x99ef, 0x99e1,
  0x99f9, 0x99fe, 0x99e5, 0x99e0, 0x9acf, 0x9add, 0x9aff, 0x9afe,
  0x9b0b, 0x9b11, 0x9b35, 0x9b3a, 0x9b3b, 0x9b4e, 0x9b42, 0x9b7c,
  0x9b7d, 0x9b63, 0x9b62, 0x52de, 0x52c0, 0x5f43, 0x5860, 0x6120,
  0x62e0, 0x62e3, 0x6f1e, 0x7452, 0x746c, 0x7450, 0x746d, 0x762e,
  0x70d6, 0x70e8, 0x73d8, 0x7d35, 0x7dba, 0x7dbb, 0x7867, 0x7a9a,
  0x7b84, 0x8660, 0x824e, 0x8c35, 0x8c3a, 0x8c38, 0x8c46, 0x8f99,
  0x8f98, 0x8a93, 0x8a92, 0x8aad, 0x8a90, 0x95b3, 0x95b0, 0x95cf,
  0x9066, 0x9065, 0x9064, 0x92e8, 0x934b, 0x934e, 0x934a, 0x93ca,
  0x93e8, 0x9e53, 0x9ed8, 0x9f54, 0x986e, 0x986a, 0x986b, 0x986f,
  0x9853, 0x986d, 0x9a0f, 0x99f3, 0x9a0a, 0x9a0e, 0x9a0b, 0x9a08,
  0x9a0d, 0x9a0c, 0x9a04, 0x99f2, 0x99f0, 0x9a09, 0x9aad, 0x9b13,
  0x9b4b, 0x9b79, 0x9b78, 0x9b7b, 0x52d9, 0x6123, 0x61b5, 0x6f15,
  0x6f14, 0x6f1a, 0x6f17, 0x746f, 0x762b, 0x76a7, 0x73d5, 0x73d4,
  0x7d34, 0x7864, 0x7866, 0x78fb, 0x7a97,
  /* 0xf9 */
  0x7a95, 0x7a96, 0x7a94, 0x85ed, 0x85ec, 0x824b, 0x824a, 0x8245,
  0x8d74, 0x8d77, 0x8d71, 0x8d76, 0x8df2, 0x8f95, 0x8f94, 0x8aa8,
  0x8aa9, 0x8aae, 0x9063, 0x9060, 0x9062, 0x907c, 0x907e, 0x9344,
  0x9c7f, 0x9d52, 0x9865, 0x9863, 0x9860, 0x9a06, 0x9a00, 0x9a1d,
  0x9a02, 0x9a1f, 0x9a1c, 0x9aac, 0x9af8, 0x9b04, 0x9b4a, 0x9b75,
  0x9b76, 0x9b77, 0x9b74, 0x5313, 0x746b, 0x7862, 0x8c31, 0x89bf,
  0x8aab, 0x95ce, 0x9079, 0x9075, 0x907b, 0x9078, 0x9e6d, 0x9879,
  0x987e, 0x987c, 0x9878, 0x9a19, 0x9a1e, 0x9afb, 0x9b07, 0x9ba9,
  0x7465, 0x7468, 0x78fa, 0x8267, 0x8c33, 0x8c30, 0x8c32, 0x8f93,
  0x8891, 0x8aa4, 0x8ac4, 0x9346, 0x9c7e, 0x9c79, 0x9cc1, 0x9d6c,
  0x9da6, 0x9e69, 0x9e6b, 0x9e6a, 0x9f29, 0x9a18, 0x9a1a, 0x9b45,
  0x660a, 0x6f13, 0x762a, 0x8241, 0x8aa5, 0x908f, 0x908d, 0x908c,
  0x9e64, 0x9e65, 0x9f23, 0x9a14, 0x7624, 0x8246, 0x8f92, 0x908e,
  0x9874, 0x9aba, 0x7278, 0x9e66, 0x9877, 0x9a10, 0x7464, 0x7467,
  0x9aa9, 0x9b73, 0x9b44, 0x9b95
};

static const acp_uint16_t big5_2charset[ /*13703*/ ] = {
  0xa64b, 0xa64a, 0xa649, 0xa5bc, 0xa655, 0xa5de, 0xa55d, 0xa5dc,
  0xa5df, 0xa7b3, 0xa7b1, 0xa7b0, 0xa7b2, 0xa7b6, 0xa749, 0xa748,
  0xa74b, 0xa74a, 0xa745, 0xa744, 0xa747, 0xa746, 0xa741, 0xa740,
  0xa743, 0xa742, 0xa75d, 0xa75c, 0xa75f, 0xa75e, 0xa759, 0xa758,
  0xa75b, 0xa75a, 0xa755, 0xa754, 0xa757, 0xa756, 0xa751, 0xa750,
  0xa753, 0xa752, 0xa76d, 0xa76c, 0xa76f, 0xa76e, 0xa769, 0xa768,
  0xa76b, 0xa76a, 0xa765, 0xa764, 0xa767, 0xa766, 0xa761, 0xa760,
  0xa763, 0xa762, 0xa77d, 0xa77c, 0xa77f, 0xa77e, 0xc3be, 0xc3bc,
  0xc3bf, 0xc3b9, 0xc3b8, 0xc3bb, 0xc3ba, 0xc3b5, 0xc3b4, 0xc3b7,
  0xc3b6, 0xc3b1, 0xc3b0, 0xc3b3, 0xc3b2, 0xc3cd, 0xc3cc, 0xc3cf,
  0xc3ce, 0xc3c9, 0xc3c8, 0xc3cb, 0xc3ca, 0xc3c5, 0xc3c4, 0xc3c7,
  0xc3c6, 0xc3c1, 0xc3c0, 0xc3c2, 0xc3dd, 0xc3dc, 0xc3df, 0xc3de,
  0xc3d9, 0xc3d8, 0xc3db, 0xc3da, 0xc3d5, 0xc3d4, 0xc3d7, 0xc3d6,
  0xc3d1, 0xc3d0, 0xc3d3, 0xc3d2, 0xc3ed, 0xc3ec, 0xc3ef, 0xc3ee,
  0xc3e9, 0xc3e8, 0xc3eb, 0xc3ea, 0xc3e5, 0xc3c3, 0xa55b, 0xa555,
  0xa5a8, 0xa5ab, 0xa5aa, 0xa5a5, 0xa548, 0xa541, 0xa546, 0xa5a1,
  0xa5a6, 0xa5bd, 0xa5cf, 0xa647, 0xa5cc, 0xa646, 0xa6b4, 0xa6b7,
  0xa6b6, 0xa6b1, 0xa6b0, 0xa6b3, 0xa6b2, 0xa6cd, 0xa6cc, 0xa6cf,
  0xa5fb, 0xa5f9, 0xa5fa, 0xa5f8, 0xa5f5, 0xa5f4, 0xa5f6, 0xa5f7,
  0xa5d9, 0xa5d6, 0xa5e5, 0xa5ea, 0xa5f0, 0xa5f1, 0xa5e9, 0xa5e8,
  0xa5e1, 0xa5e0, 0xa5e2, 0xa5e3, 0xa5ee, 0xa5d1, 0xa5d7, 0xa5d0,
  0xa5d5, 0xa5d4, 0xa5eb, 0xa5e4, 0xc3e4, 0xc3e7, 0xc3e6, 0xc3e1,
  0xc3e0, 0xc3e3, 0xc3e2, 0xc3fd, 0xc3fc, 0xc3ff, 0xc3fe, 0xc3f9,
  0xc3f8, 0xc3fb, 0xc3fa, 0xc3f5, 0xc3f4, 0xc3f7, 0xc3f6, 0xc3f1,
  0xa67a, 0xa675, 0xa677, 0xa676, 0xa671, 0xa670, 0xa678, 0xa679,
  0xa67e, 0xa67f, 0xa67c, 0xa6a9, 0xa6a8, 0xa6aa, 0xa6ab, 0xa673,
  0xa6ac, 0xa6ae, 0xa6af, 0xa6a1, 0xa6a0, 0xa6a3, 0xa66f, 0xa66e,
  0xa669, 0xa668, 0xa66b, 0xa66a, 0xa665, 0xa664, 0xa67d, 0xa662,
  0xa663, 0xa660, 0xa661, 0xa666, 0xa667, 0xa67b, 0xa674, 0xa5b0,
  0xa5b1, 0xa5bb, 0xa5b8, 0xa5b2, 0xa5b3, 0xa5b6, 0xa5b7, 0xa5be,
  0xa5ba, 0xa5b9, 0xa6a5, 0xa6a4, 0xa6a6, 0xa6a7, 0xa5b4, 0xa5b5,
  0xa5fe, 0xa5fd, 0xa5ff, 0xa5fc, 0xa54d, 0xa54f, 0xa54e, 0xa5bf,
  0xc2a9, 0xa57c, 0xa57f, 0xa560, 0xa563, 0xa578, 0xa57b, 0xa574,
  0xa577, 0xa564, 0xa567, 0xa648, 0xa568, 0xa56b, 0xa5a4, 0xa5a7,
  0xa6ce, 0xa6c9, 0xa6c8, 0xa6cb, 0xa6ca, 0xa6c5, 0xa6c4, 0xa6c7,
  0xa6c6, 0xc2a8, 0xc2ab, 0xc2aa, 0xc2a5, 0xc2a4, 0xc2a7, 0xc2a6,
  0xc2a1, 0xc2a0, 0xc2a3, 0xc2a2, 0xc2bd, 0xc2bc, 0xc2bf, 0xc2be,
  0xc2b9, 0xc2b8, 0xc2bb, 0xc2ba, 0xc2b5, 0xc2b4, 0xc2b7, 0xc2b6,
  0xc2b1, 0xc2b0, 0xc2b3, 0xc2b2, 0xc2cd, 0xc2cc, 0xc2cf, 0xc2ce,
  0xc2c9, 0xc2c8, 0xc2cb, 0xc2ca, 0xc2c5, 0xc2c4, 0xc2c7, 0xc2c6,
  0xc2c1, 0xc2c0, 0xc2c3, 0xc2c2, 0xc2dd, 0xc2dc, 0xc2df, 0xc2de,
  0xc2d9, 0xc2d8, 0xc2db, 0xc2da, 0xc2d5, 0xc2d4, 0xc2d7, 0xc2d6,
  0xc2d1, 0xc2d0, 0xc2d3, 0xc2d2, 0xc2ed, 0xc2ec, 0xc2ef, 0xc2ee,
  0xc2e9, 0xc2e8, 0xc2eb, 0xc2ea, 0xc2e5, 0xc2e4, 0xc2e7, 0xc2e6,
  0xc2e1, 0xc2e0, 0xc2e3, 0xc2e2, 0xc2fd, 0xc2fc, 0xc2ff, 0xc2fe,
  0xc2f9, 0xc2f8, 0xc2fb, 0xc2fa, 0xc2af, 0xc2ae, 0xc2f5, 0xc2f4,
  0xc2f7, 0xc2f6, 0xc2f1, 0xc2f0, 0xc2f3, 0xc34d, 0xc34c, 0xc34f,
  0xc34e, 0xc349, 0xc348, 0xc34b, 0xc34a, 0xc345, 0xc344, 0xc347,
  0xc346, 0xc341, 0xc340, 0xc343, 0xc342, 0xc35d, 0xc35c, 0xc35f,
  0xc35e, 0xc359, 0xc358, 0xc35b, 0xc35a, 0xc355, 0xc354, 0xc357,
  0xc356, 0xc351, 0xc350, 0xc353, 0xc352, 0xc36d, 0xc36c, 0xc36f,
  0xc36e, 0xc369, 0xc368, 0xc36b, 0xc36a, 0xc365, 0xc364, 0xc367,
  0xc366, 0xc361, 0xc360, 0xc363, 0xc362, 0xc37d, 0xc37c, 0xc37f,
  0xc37e, 0xc379, 0xc378, 0xc37b, 0xc37a, 0xc375, 0xc374, 0xc377,
  0xc376, 0xc371, 0xc370, 0xc373, 0xc3ac, 0xc3af, 0xc3ae, 0xc3a9,
  0xc3a8, 0xc3ab, 0xc3aa, 0xc3a5, 0xc3a4, 0xc3a7, 0xc3a6, 0xc3a1,
  0xc3a0, 0xc3a3, 0xc3a2, 0xc3bd, 0xc2ac, 0xa779, 0xa778, 0xa77b,
  0xa77a, 0xa775, 0xa774, 0xa777, 0xa776, 0xa771, 0xa770, 0xa773,
  0xa7ac, 0xa7af, 0xa7ae, 0xa7a9, 0xa7a8, 0xa7ab, 0xa7aa, 0xa7a5,
  0xa7a4, 0xa7a7, 0xa7a6, 0xa7a1, 0xa7a0, 0xa7a3, 0xa7a2, 0xa7bd,
  0xa7bc, 0xa7bf, 0xa7be, 0xa7b9, 0xa7b8, 0xa7bb, 0xa7ba, 0xa7b5,
  0xa7b4, 0xa7b7, 0xa5cd, 0xa658, 0xa65b, 0xa65d, 0xa65c, 0xa65f,
  0xa659, 0xa65a, 0xa65e, 0xa5e6, 0xa5e7, 0xa642, 0xa04d, 0xa04f,
  0xa04e, 0xcd48, 0xa05b, 0xa059, 0xa05a, 0xa058, 0xcd4b, 0xa0ae,
  0xcd42, 0xcd40, 0xa0af, 0xa0ac, 0xa14f, 0xa14c, 0xa14d, 0xa14e,
  0xa0f3, 0xa1ed, 0xa1ec, 0xacce, 0xa055, 0xa0a9, 0xcd5d, 0xa0a8,
  0xcd6e, 0xa2e7, 0xcfbc, 0xa054, 0xa0ab, 0xa149, 0xcd69, 0xcd4d,
  0xa049, 0xa056, 0xcd4a, 0xa051, 0xa0aa, 0xa148, 0xa14a, 0xa14b,
  0xa1ef, 0xa1ee, 0xacc9, 0xa9b1, 0xa04c, 0xcd4c, 0xa048, 0xa053,
  0xa050, 0xa1e9, 0xacc8, 0xb4a3, 0xd046, 0xb2ce, 0xd8bc, 0xd8bf,
  0xa04b, 0xa0a4, 0xaccb, 0xa04a, 0xcd45, 0xa052, 0xa0a7, 0xa0a1,
  0xcd5c, 0xa0a0, 0xa0a6, 0xa1e8, 0xacca, 0xacc5, 0xaf48, 0xa06d,
  0xa0a3, 0xa1eb, 0xa1e5, 0xa1ea, 0xa2e6, 0xacc4, 0xacc7, 0xaf4b,
  0xaf4a, 0xa9b0, 0xd8be, 0xf2db, 0xa045, 0xa0bd, 0xa0a2, 0xcd5f,
  0xa0bc, 0xa0ba, 0xa0bf, 0xa0be, 0xcd59, 0xcd5e, 0xa0b8, 0xa0bb,
  0xa0b9, 0xa147, 0xa146, 0xa141, 0xa140, 0xa144, 0xa15d, 0xcd67,
  0xcd6b, 0xcd64, 0xa15c, 0xa16c, 0xcd65, 0xa143, 0xa142, 0xa145,
  0xcd68, 0xcd6a, 0xa1f8, 0xcdbd, 0xa1ff, 0xa1fb, 0xcdb7, 0xcda3,
  0xa1fe, 0xcdbf, 0xa1f9, 0xa1fa, 0xa1e4, 0xcdbc, 0xa1f5, 0xcdb8,
  0xcdb4, 0xcdbb, 0xcdbe, 0xa1e7, 0xa1e1, 0xa1f4, 0xa1e3, 0xcda6,
  0xa1fc, 0xa1e2, 0xa1fd, 0xcdb6, 0xcdb5, 0xcda2, 0xa1e0, 0xcda1,
  0xa1e6, 0xcdb9, 0xcdba, 0xcda0, 0xce6b, 0xa34f, 0xa2f9, 0xce6a,
  0xa2fc, 0xa349, 0xa2f4, 0xa2f5, 0xce56, 0xa2f1, 0xa2fa, 0xce6d,
  0xce65, 0xce69, 0xa2f7, 0xa2f0, 0xa2e3, 0xa34a, 0xce50, 0xcfb0,
  0xa2e1, 0xa34e, 0xa2e0, 0xa2f8, 0xa2fb, 0xce6f, 0xce53, 0xa2f6,
  0xa2fe, 0xce57, 0xa2e2, 0xce68, 0xa348, 0xa345, 0xa2ff, 0xa34d,
  0xa34b, 0xa2fd, 0xce6e, 0xa34c, 0xce64, 0xce51, 0xa2f3, 0xce52,
  0xce6c, 0xacd5, 0xcfb2, 0xcfc6, 0xacdd, 0xcfc1, 0xacc6, 0xacd8,
  0xacc3, 0xcfb4, 0xacdb, 0xcfb5, 0xcfb1, 0xcfce, 0xcfcc, 0xacd3,
  0xacd4, 0xcfbe, 0xcfb8, 0xacd6, 0xacc2, 0xcfbb, 0xcfcf, 0xcfc4,
  0xacd9, 0xcfb6, 0xcfb9, 0xacde, 0xcfba, 0xacda, 0xcfb7, 0xacdf,
  0xacc0, 0xacd1, 0xcfc9, 0xacd0, 0xcfc5, 0xcfcb, 0xcfc7, 0xacd7,
  0xcfb3, 0xcfbf, 0xcfcd, 0xacdc, 0xcfc8, 0xacc1, 0xcfca, 0xaf5b,
  0xaf47, 0xc9ed, 0xc9e5, 0xaf44, 0xaf5c, 0xaf50, 0xc9e3, 0xc9e1,
  0xc9ea, 0xaf46, 0xc9e0, 0xc9ee, 0xaf54, 0xaf5d, 0xaf55, 0xc9d3,
  0xc9e7, 0xc9ec, 0xaf59, 0xc9ef, 0xc9d0, 0xaf56, 0xaf43, 0xaf5a,
  0xaf40, 0xc9d2, 0xc9e9, 0xc9e6, 0xaf58, 0xaf5f, 0xc9eb, 0xaf57,
  0xc9e4, 0xc9e8, 0xaf42, 0xaf51, 0xaf5e, 0xaf41, 0xaf45, 0xc9e2,
  0xa9da, 0xa9cc, 0xa9dc, 0xa9db, 0xd4dd, 0xd4c2, 0xd4d9, 0xd4d8,
  0xa9c9, 0xa9c0, 0xa9d7, 0xa9c3, 0xd4c4, 0xa9ca, 0xd4c7, 0xa9d1,
  0xa9de, 0xa9b3, 0xa9b2, 0xd4d0, 0xb4b2, 0xa9c1, 0xa9c6, 0xd4c6,
  0xa9c2, 0xd056, 0xa9cb, 0xd4db, 0xa9d8, 0xa9d9, 0xa9c7, 0xd4c3,
  0xd4da, 0xd4c5, 0xa9c4, 0xd4d5, 0xa9df, 0xd4c1, 0xa9cd, 0xa9ce,
  0xa9cf, 0xd4d4, 0xa9dd, 0xa9c8, 0xa9d4, 0xa9d6, 0xd4de, 0xa9d5,
  0xd4d6, 0xd4c0, 0xd4d1, 0xd4dc, 0xd4d7, 0xd4df, 0xa9c5, 0xd06e,
  0xd05a, 0xb4be, 0xd051, 0xd06f, 0xb4bf, 0xd058, 0xb4bb, 0xd054,
  0xd05f, 0xb4b9, 0xd05b, 0xb4b4, 0xb4b3, 0xd06a, 0xd05c, 0xb4b7,
  0xd06b, 0xb4b8, 0xd055, 0xb4bc, 0xd05e, 0xd042, 0xd050, 0xd05d,
  0xd043, 0xd057, 0xd06d, 0xd06c, 0xb4ba, 0xdc56, 0xd053, 0xd040,
  0xd052, 0xb4cc, 0xd069, 0xb4cd, 0xd041, 0xd059, 0xd068, 0xb4b1,
  0xb4b6, 0xb4b5, 0xb4b0, 0xb4a2, 0xb4bd, 0xb7c5, 0xdc53, 0xdc5a,
  0xb7c8, 0xdc52, 0xdc58, 0xdc55, 0xb7c9, 0xdc54, 0xb7ca, 0xdc50,
  0xdc5e, 0xdc5f, 0xb7c4, 0xb7c7, 0xb7cb, 0xb7c6, 0xdc5c, 0xdc51,
  0xdc57, 0xdc59, 0xb7ce, 0xdc5b, 0xb2c7, 0xb2c9, 0xd8ba, 0xb2c0,
  0xd8b0, 0xd8cd, 0xb2cb, 0xb2ca, 0xd8b7, 0xb2c8, 0xd8ce, 0xb2c6,
  0xd8c9, 0xd8b2, 0xb2c1, 0xd8b9, 0xb2c4, 0xd8b8, 0xd8b3, 0xd8b1,
  0xd8b5, 0xb2c5, 0xd8bb, 0xb2c3, 0xd8b6, 0xd8cf, 0xd8b4, 0xd8cc,
  0xbdbb, 0xbdbe, 0xbdb9, 0xe4f4, 0xe4fc, 0xbdbf, 0xbda2, 0xe4ff,
  0xbdbc, 0xe4f8, 0xe4fa, 0xe4f3, 0xe4f0, 0xe4f5, 0xbda3, 0xe4fd,
  0xbda1, 0xe4fe, 0xbdba, 0xe4fb, 0xe4f7, 0xbdbd, 0xbda0, 0xe4f1,
  0xe4f6, 0xbdb8, 0xe4f9, 0xbff5, 0xe0e1, 0xe0e4, 0xbff4, 0xbffa,
  0xe0fd, 0xe0e0, 0xe0eb, 0xbffb, 0xbff7, 0xe0ea, 0xbff8, 0xbff0,
  0xe0e7, 0xe0e6, 0xbff6, 0xbff1, 0xe0fc, 0xe0e3, 0xe0e2, 0xbaa7,
  0xecf5, 0xbaaa, 0xecf8, 0xbaa4, 0xbaa6, 0xecfb, 0xbaa5, 0xecfa,
  0xecf9, 0xc47b, 0xe8b0, 0xc47a, 0xe8b6, 0xe8b1, 0xe8b7, 0xe8b4,
  0xe8b3, 0xc478, 0xebb5, 0xebb4, 0xe0e5, 0xebba, 0xc475, 0xc752,
  0xf5e6, 0xf5e1, 0xc0da, 0xc0d5, 0xf1cc, 0xf1cd, 0xc161, 0xc166,
  0xf3dd, 0xa044, 0xa06c, 0xa0b4, 0xa0b5, 0xa15e, 0xa15f, 0xa1f1,
  0xa1f6, 0xa1f0, 0xa1f7, 0xa347, 0xa344, 0xa346, 0xaced, 0xacd2,
  0xacec, 0xaf53, 0xa654, 0xd4d3, 0xa657, 0xb4cf, 0xa651, 0xa656,
  0xdc6d, 0xa650, 0xbdb5, 0xa653, 0xa047, 0xa0b7, 0xa1f3, 0xacef,
  0xa046, 0xa0b0, 0xa0b6, 0xa0b1, 0xa24d, 0xa341, 0xace9, 0xacee,
  0xace8, 0xa9d0, 0xbaa1, 0xcd43, 0xa159, 0xa158, 0xa24c, 0xce67,
  0xaf6d, 0xaf52, 0xd4ed, 0xd4d2, 0xb4ce, 0xa0b3, 0xcd58, 0xcfc0,
  0xaf6c, 0xa9ed, 0xa9d3, 0xa9d2, 0xbaa0, 0xa15b, 0xa24f, 0xcdb1,
  0xa340, 0xa343, 0xce66, 0xcfc3, 0xaceb, 0xcfc2, 0xd4ef, 0xd4ee,
  0xa9ee, 0xd4e9, 0xd4ec, 0xa9e9, 0xa9ef, 0xa9ec, 0xd4e8, 0xd065,
  0xdc6c, 0xd8c8, 0xe54d, 0xbff3, 0xbaa3, 0xecf4, 0xa041, 0xa057,
  0xb4c9, 0xb7c0, 0xbdb4, 0xcd4f, 0xa0b2, 0xa154, 0xa15a, 0xa155,
  0xacea, 0xa040, 0xa043, 0xa06f, 0xa0cd, 0xa0cc, 0xa0cf, 0xcdb3,
  0xa157, 0xcd66, 0xa24b, 0xcdb2, 0xa249, 0xa248, 0xcdb0, 0xa24a,
  0xa24e, 0xce61, 0xaee1, 0xce60, 0xce63, 0xa35d, 0xa342, 0xa35e,
  0xa35c, 0xa35f, 0xace0, 0xace1, 0xcfd9, 0xcfdc, 0xcfdf, 0xcfdd,
  0xace3, 0xace7, 0xace4, 0xace6, 0xace5, 0xace2, 0xaf6e, 0xc9fd,
  0xcfde, 0xaf65, 0xc9fc, 0xaf69, 0xaf6a, 0xaf6b, 0xaf68, 0xaf6f,
  0xd4e5, 0xa9ea, 0xd4e6, 0xa9e8, 0xd4ea, 0xa9e5, 0xa9eb, 0xa9e4,
  0xd4e4, 0xd4e7, 0xd4eb, 0xd4e1, 0xb7dc, 0xb4c8, 0xd064, 0xd066,
  0xd067, 0xd061, 0xb4cb, 0xb7c3, 0xb7c2, 0xb7dd, 0xb2dd, 0xd8ca,
  0xd8cb, 0xd8c5, 0xd8c4, 0xb2dc, 0xb2c2, 0xe54c, 0xe54f, 0xbdb6,
  0xbdb7, 0xe757, 0xb84d, 0xb84c, 0xb84f, 0xb849, 0xe0ff, 0xe0fe,
  0xb84e, 0xbaa2, 0xbabd, 0xf5e0, 0xf1ce, 0xf1cf, 0xf3dc, 0xa042,
  0xa151, 0xa156, 0xa245, 0xcdcd, 0xa358, 0xa35b, 0xa359, 0xa35a,
  0xce62, 0xce7d, 0xacfc, 0xcfd8, 0xacfd, 0xc9ff, 0xaf61, 0xc9fe,
  0xaf66, 0xaf64, 0xaf67, 0xd4e0, 0xb4ca, 0xd063, 0xb4c7, 0xd060,
  0xb5e8, 0xb4c4, 0xb4c5, 0xb7d9, 0xb7de, 0xb7df, 0xb2df, 0xb2d8,
  0xb2db, 0xb2d9, 0xb2de, 0xe54e, 0xe549, 0xe0f8, 0xb848, 0xe0f9,
  0xbabc, 0xe8b2, 0xc474, 0xf5e3, 0xc058, 0xa06e, 0xa0ce, 0xcd5b,
  0xa0c9, 0xa0c8, 0xa150, 0xa153, 0xa244, 0xce7c, 0xcfdb, 0xcfda,
  0xaf60, 0xd4e3, 0xb4c1, 0xb4c6, 0xdc6e, 0xdc6f, 0xa05d, 0xa0cb,
  0xa152, 0xb4c0, 0xcd4e, 0xcd61, 0xa16d, 0xcdcf, 0xa246, 0xa247,
  0xcdcc, 0xa355, 0xa9e7, 0xd062, 0xb2da, 0xe548, 0xbdb1, 0xecf7,
  0xf7f0, 0xa0ca, 0xcfd5, 0xc9f9, 0xb4dd, 0xb4c3, 0xb4c2, 0xa05c,
  0xa069, 0xa6c0, 0xa0c7, 0xa0c4, 0xa0c5, 0xa16e, 0xa16f, 0xcd60,
  0xcdce, 0xacf8, 0xacff, 0xacf9, 0xacfe, 0xaf63, 0xb7d8, 0xa05f,
  0xa0c6, 0xa168, 0xa169, 0xce7f, 0xacfb, 0xcd5a, 0xa16a, 0xa16b,
  0xa241, 0xa240, 0xce7e, 0xa354, 0xa357, 0xacfa, 0xacf5, 0xacf4,
  0xaf62, 0xc9f8, 0xa9e6, 0xcd49, 0xa0c1, 0xcdc9, 0xce79, 0xce78,
  0xcfd4, 0xcfd7, 0xc9fa, 0xc9fb, 0xc9f4, 0xc9f5, 0xaf7d, 0xd07d,
  0xa9e0, 0xd4e2, 0xa9e1, 0xdc69, 0xb7db, 0xdc68, 0xe54b, 0xbdb0,
  0xb84b, 0xf5e2, 0xcd55, 0xa165, 0xb4dc, 0xa05e, 0xa068, 0xa0c3,
  0xa0c0, 0xa0c2, 0xacf6, 0xacf7, 0xacf1, 0xaf7c, 0xa9e3, 0xecf6,
  0xc642, 0xa06b, 0xa167, 0xa174, 0xa179, 0xa162, 0xa163, 0xa178,
  0xa17e, 0xa161, 0xa177, 0xa160, 0xa164, 0xa175, 0xa17a, 0xa17b,
  0xa166, 0xa17f, 0xa17c, 0xa176, 0xa17d, 0xa25e, 0xa254, 0xa258,
  0xa256, 0xcdc8, 0xa255, 0xa243, 0xa25c, 0xa259, 0xa25d, 0xa25a,
  0xa257, 0xa242, 0xa25f, 0xa25b, 0xa251, 0xce73, 0xce76, 0xa36a,
  0xce71, 0xa356, 0xa350, 0xa378, 0xa37d, 0xcea8, 0xce70, 0xa352,
  0xa36c, 0xcea9, 0xa365, 0xce75, 0xa379, 0xa37b, 0xa351, 0xa360,
  0xce7b, 0xa37e, 0xa369, 0xa363, 0xa362, 0xce7a, 0xa361, 0xa367,
  0xa366, 0xa37c, 0xceac, 0xa353, 0xa37f, 0xceae, 0xa36b, 0xa36e,
  0xce77, 0xa36f, 0xceab, 0xa368, 0xa364, 0xa36d, 0xceaf, 0xce74,
  0xcfe6, 0xcfe7, 0xad42, 0xcfe0, 0xcfe2, 0xcfe9, 0xcfea, 0xcfe3,
  0xad5d, 0xcfec, 0xcfe8, 0xcfe4, 0xca44, 0xad46, 0xca40, 0xacf0,
  0xcfeb, 0xacf3, 0xad41, 0xad48, 0xad4c, 0xcfef, 0xad49, 0xad44,
  0xad5f, 0xcfee, 0xcfd1, 0xad4e, 0xcfd0, 0xcfd2, 0xad4b, 0xad45,
  0xcfd6, 0xcfed, 0xad5c, 0xad40, 0xcfe5, 0xad5e, 0xad47, 0xcfd3,
  0xad4a, 0xad4f, 0xad4d, 0xcfe1, 0xad43, 0xca45, 0xc9f6, 0xca46,
  0xc9f0, 0xaf75, 0xafa5, 0xaf79, 0xafaa, 0xaf70, 0xafa9, 0xaf7f,
  0xc9f1, 0xca4e, 0xafae, 0xca42, 0xafa8, 0xaf74, 0xca48, 0xca4f,
  0xaf7a, 0xc9f7, 0xafab, 0xca47, 0xaf71, 0xca41, 0xafa4, 0xaf7e,
  0xaf73, 0xaf76, 0xca4d, 0xafac, 0xca4b, 0xca4a, 0xaf77, 0xafaf,
  0xaf7b, 0xaf78, 0xc9f3, 0xca49, 0xca43, 0xd549, 0xa9f6, 0xd4fc,
  0xd4fb, 0xa9f9, 0xaa4d, 0xd4f9, 0xa9e2, 0xa9f4, 0xa9f3, 0xd4f6,
  0xa9f7, 0xa9f0, 0xd4f3, 0xa9f8, 0xd4f8, 0xd54f, 0xd54e, 0xa9fa,
  0xd54c, 0xa9fe, 0xaa4e, 0xd4f5, 0xa9fc, 0xd54b, 0xd4f4, 0xd4f0,
  0xa9fb, 0xaa4f, 0xd4f7, 0xa9f1, 0xd54d, 0xd54a, 0xd0ac, 0xd548,
  0xaa49, 0xa9fd, 0xd4f1, 0xd4fe, 0xa9f5, 0xd4ff, 0xd4fa, 0xd4fd,
  0xaa4c, 0xd07a, 0xb4e9, 0xd0aa, 0xb4ef, 0xb4d2, 0xd071, 0xb4d6,
  0xd0af, 0xb4eb, 0xd07b, 0xd076, 0xd077, 0xa9ff, 0xb4ec, 0xd0a8,
  0xd0a5, 0xd07e, 0xb7e5, 0xd0a4, 0xb4ea, 0xb4d4, 0xb4db, 0xd073,
  0xb4de, 0xd0ab, 0xb4d7, 0xd0a7, 0xd079, 0xd0a9, 0xb4d0, 0xd078,
  0xd075, 0xd070, 0xb4d3, 0xb4d1, 0xb4e5, 0xb4ee, 0xb4da, 0xb5df,
  0xb4d5, 0xd074, 0xb4e8, 0xb4ed, 0xd0ae, 0xb4d8, 0xb4d9, 0xd07c,
  0xd07f, 0xdc67, 0xb7da, 0xb7d7, 0xdc78, 0xb7e3, 0xdc75, 0xb7d5,
  0xdc7c, 0xb7d3, 0xb7e9, 0xb1b0, 0xb7ef, 0xdc63, 0xb7e2, 0xb7d6,
  0xb7ee, 0xdc7b, 0xd8da, 0xdc76, 0xdc62, 0xdc6b, 0xdc7e, 0xdc60,
  0xb7ec, 0xdc74, 0xb7d0, 0xb7fc, 0xb7e7, 0xb7d2, 0xb7d1, 0xb7ea,
  0xdc77, 0xdc61, 0xdc7f, 0xdc79, 0xdc65, 0xdc7a, 0xb7d4, 0xdc6a,
  0xb7ed, 0xb7fd, 0xb7e1, 0xdc64, 0xb7eb, 0xb7e0, 0xb7e4, 0xb7e8,
  0xdc7d, 0xb7e6, 0xd8d8, 0xd8dc, 0xd8ed, 0xd8c7, 0xd8de, 0xb2e8,
  0xb2eb, 0xb2d3, 0xd8d1, 0xb2e5, 0xd8c2, 0xd8c3, 0xd8c1, 0xd8d3,
  0xb2d1, 0xd8d5, 0xd8c0, 0xb2d2, 0xd8db, 0xb2d7, 0xd8df, 0xd8d4,
  0xd8d6, 0xd8d2, 0xb2ee, 0xd8c6, 0xb2d0, 0xd8dd, 0xb2d5, 0xb2e9,
  0xd8d7, 0xb2ed, 0xb2ec, 0xb2ea, 0xb2d6, 0xa652, 0xb2d4, 0xd8d9,
  0xb2ef, 0xd8d0, 0xbdc0, 0xbdc5, 0xe558, 0xe55c, 0xe546, 0xbdcf,
  0xbdb3, 0xe559, 0xbdb2, 0xe543, 0xe55d, 0xe55e, 0xbdc9, 0xbdc6,
  0xbdc8, 0xe544, 0xbdcb, 0xbdca, 0xe541, 0xbdc1, 0xe547, 0xe542,
  0xbdce, 0xe545, 0xbdc4, 0xbdcc, 0xbdcd, 0xe540, 0xe55f, 0xbdc7,
  0xe54a, 0xb840, 0xe14a, 0xe149, 0xb84a, 0xb85e, 0xb859, 0xb847,
  0xe14f, 0xb841, 0xe0f4, 0xb85f, 0xe14b, 0xb844, 0xe145, 0xb845,
  0xe14e, 0xe148, 0xb846, 0xe14c, 0xe0f7, 0xe0fa, 0xdc66, 0xe0f0,
  0xe0fb, 0xe0f1, 0xe0f6, 0xe0f5, 0xb842, 0xb843, 0xb85d, 0xe0f3,
  0xbabf, 0xe14d, 0xed48, 0xecf0, 0xbab3, 0xed4f, 0xbabb, 0xbab7,
  0xed4c, 0xbab4, 0xbab8, 0xbab5, 0xbabe, 0xbab0, 0xed4e, 0xecf3,
  0xbab1, 0xecf1, 0xbab6, 0xed49, 0xed4d, 0xb85c, 0xbab2, 0xed4b,
  0xbaba, 0xbab9, 0xe8cb, 0xe8c5, 0xc476, 0xe8c4, 0xe8ca, 0xe8c8,
  0xe8c9, 0xc470, 0xe8ce, 0xc473, 0xe8cc, 0xe8cf, 0xc477, 0xc4ac,
  0xc471, 0xe8cd, 0xc65d, 0xebb1, 0xebb7, 0xebb2, 0xebb0, 0xebb6,
  0xebb3, 0xc76d, 0xf5ff, 0xf5fe, 0xc05b, 0xf5f9, 0xf5fd, 0xf5f8,
  0xf5fc, 0xc65c, 0xf7f3, 0xf04c, 0xc054, 0xf04d, 0xc055, 0xc05a,
  0xc057, 0xf1c8, 0xf1cb, 0xc0d7, 0xc0d4, 0xc0d6, 0xf1c9, 0xf2d5,
  0xf2da, 0xc160, 0xc162, 0xc163, 0xf2d4, 0xc1c5, 0xfcab, 0xc1fc,
  0xfca8, 0xfce3, 0xcd44, 0xa170, 0xa171, 0xa252, 0xa253, 0xcdca,
  0xa250, 0xcdcb, 0xa374, 0xcea4, 0xcea5, 0xa37a, 0xa377, 0xceaa,
  0xa375, 0xcffd, 0xcffc, 0xad59, 0xafa7, 0xd545, 0xd544, 0xaa48,
  0xaa4b, 0xd0a1, 0xb4e4, 0xb4e6, 0xd0a6, 0xb4e7, 0xdc71, 0xb7ff,
  0xb2e4, 0xb2e7, 0xd8ec, 0xbdc2, 0xbdc3, 0xe144, 0xed45, 0xed4a,
  0xfd66, 0xa06a, 0xcd54, 0xcd63, 0xcd62, 0xa26f, 0xa26b, 0xcdc4,
  0xa269, 0xa26e, 0xcdc5, 0xa268, 0xa26c, 0xa26d, 0xcdc7, 0xa3ab,
  0xa3ae, 0xa370, 0xcea7, 0xcea6, 0xa3ac, 0xcea0, 0xa376, 0xcea3,
  0xcea1, 0xa373, 0xa3af, 0xa3a8, 0xa3a9, 0xa371, 0xcea2, 0xad54,
  0xcff3, 0xad56, 0xad57, 0xc84d, 0xad55, 0xad5a, 0xcff8, 0xcff9,
  0xcfff, 0xcffa, 0xcffb, 0xcffe, 0xcff1, 0xcff0, 0xcff7, 0xcff5,
  0xad5b, 0xcff6, 0xad51, 0xc84c, 0xcff4, 0xafa6, 0xad58, 0xafa1,
  0xca59, 0xca57, 0xafbf, 0xca55, 0xca53, 0xca58, 0xca54, 0xca56,
  0xca50, 0xca5a, 0xca5b, 0xca5c, 0xca5f, 0xafa0, 0xafa2, 0xafa3,
  0xca5e, 0xca51, 0xafbc, 0xca5d, 0xd55e, 0xd55f, 0xd55a, 0xd543,
  0xd55c, 0xd55d, 0xd559, 0xd555, 0xaa4a, 0xaa47, 0xd542, 0xd558,
  0xaa44, 0xd547, 0xafbd, 0xd0b7, 0xd55b, 0xd540, 0xaa45, 0xd541,
  0xd0bc, 0xb4e1, 0xb4fd, 0xd0cc, 0xd0a2, 0xd0b0, 0xb4fc, 0xd0b2,
  0xd0c8, 0xd0c4, 0xd0cd, 0xd0b9, 0xd0b1, 0xd0c7, 0xd0c5, 0xd0b3,
  0xd0b4, 0xd0bf, 0xdcab, 0xd0bd, 0xb4f8, 0xd0ba, 0xb4fb, 0xb4ff,
  0xd0a0, 0xd0ce, 0xd0b8, 0xd0be, 0xd0cb, 0xb4fe, 0xd0c1, 0xb4e0,
  0xb4e2, 0xd0b6, 0xd0bb, 0xaa46, 0xb4e3, 0xd0b5, 0xd0ca, 0xd0c6,
  0xd0cf, 0xd0c9, 0xd0a3, 0xdcac, 0xdca7, 0xdca4, 0xb7f7, 0xdcaf,
  0xb7f6, 0xb7f4, 0xdca9, 0xb7fb, 0xdca5, 0xdcae, 0xdca8, 0xdc70,
  0xb7f9, 0xdcbf, 0xdcbc, 0xdca3, 0xb7fe, 0xb7fa, 0xb7f5, 0xd546,
  0xdca6, 0xb7f8, 0xb4f9, 0xdca0, 0xdc73, 0xdcbd, 0xdca2, 0xdcbe,
  0xd8e2, 0xdca1, 0xdcaa, 0xd8ea, 0xb2f9, 0xb2fa, 0xb2ff, 0xd8eb,
  0xd8e7, 0xd8e8, 0xb2e1, 0xb2fb, 0xd8ef, 0xb2fd, 0xd8e4, 0xb2e3,
  0xb2e0, 0xd8e1, 0xb2e2, 0xd8e3, 0xd8e6, 0xb2e6, 0xb2f8, 0xd8fd,
  0xd8e9, 0xd8e0, 0xd8ee, 0xb2fc, 0xb2fe, 0xd8e5, 0xd8fc, 0xe550,
  0xbddd, 0xe56e, 0xbdd8, 0xe552, 0xe56b, 0xe55a, 0xbdda, 0xbddc,
  0xe551, 0xb858, 0xe556, 0xe569, 0xbddf, 0xbddb, 0xe557, 0xe56d,
  0xe568, 0xe55b, 0xbdd9, 0xe553, 0xe56f, 0xe565, 0xe555, 0xe56c,
  0xbdde, 0xe56a, 0xe554, 0xb854, 0xe146, 0xb85a, 0xb85b, 0xe140,
  0xe15f, 0xe143, 0xe15c, 0xb851, 0xbaa8, 0xb856, 0xe147, 0xe15d,
  0xb857, 0xe142, 0xe141, 0xb855, 0xed40, 0xed42, 0xed47, 0xbacc,
  0xed41, 0xbacd, 0xed43, 0xbace, 0xed5d, 0xbacf, 0xed44, 0xed46,
  0xc4a8, 0xe8c1, 0xc4a9, 0xe8c0, 0xc4ae, 0xe8c6, 0xc4af, 0xe8c7,
  0xc65e, 0xc65f, 0xf5fb, 0xf5f5, 0xf5fa, 0xc76c, 0xc76f, 0xc76e,
  0xf04f, 0xc056, 0xf3de, 0xf3df, 0xc1ff, 0xa065, 0xa0dd, 0xa3aa,
  0xca52, 0xb7f1, 0xb7f0, 0xd8ff, 0xbdd5, 0xe564, 0xe15e, 0xcd57,
  0xcebd, 0xc84f, 0xca6d, 0xd554, 0xaa41, 0xf5f4, 0xc0d1, 0xa064,
  0xa173, 0xcd7d, 0xa26a, 0xa265, 0xad50, 0xb4fa, 0xbdd7, 0xbdd6,
  0xbdd4, 0xa067, 0xa0dc, 0xa0de, 0xa0df, 0xcd56, 0xa0d9, 0xa1ac,
  0xcd7c, 0xa1af, 0xa264, 0xa267, 0xcdc6, 0xa3a5, 0xcebc, 0xad6c,
  0xc84e, 0xad52, 0xad6d, 0xad53, 0xd557, 0xafbb, 0xafb8, 0xafba,
  0xafb9, 0xca6c, 0xad6f, 0xafbe, 0xaa40, 0xaa43, 0xaa42, 0xd0c0,
  0xb7f3, 0xdcb9, 0xb4f5, 0xb2f5, 0xbdd0, 0xbdd1, 0xe567, 0xb850,
  0xbac9, 0xebcd, 0xf2d7, 0xf3d9, 0xa066, 0xa1ae, 0xa1a9, 0xcddc,
  0xa261, 0xa262, 0xcdc2, 0xcdc0, 0xa263, 0xcddd, 0xcddf, 0xcdc1,
  0xa27c, 0xa27d, 0xa260, 0xa266, 0xcdc3, 0xa3be, 0xa3bd, 0xcebb,
  0xceb4, 0xceb5, 0xa3a7, 0xa3bf, 0xa3a2, 0xceb8, 0xcebe, 0xa3a3,
  0xa3a4, 0xa3a1, 0xceb9, 0xceb6, 0xceba, 0xa3a0, 0xa3bc, 0xa3b9,
  0xcebf, 0xceb7, 0xa3a6, 0xad6a, 0xad62, 0xc842, 0xc845, 0xad7d,
  0xc85e, 0xc849, 0xc846, 0xad6b, 0xc848, 0xad69, 0xc841, 0xc85d,
  0xad6e, 0xc85c, 0xc847, 0xc840, 0xad7f, 0xad64, 0xc859, 0xc85f,
  0xad63, 0xad61, 0xc844, 0xad66, 0xc84a, 0xc84b, 0xad67, 0xad65,
  0xad7c, 0xad60, 0xad68, 0xc843, 0xafb4, 0xafcd, 0xca62, 0xafb5,
  0xca6a, 0xca6e, 0xca7e, 0xca6f, 0xafb6, 0xca61, 0xafb3, 0xafcc,
  0xafb1, 0xca7d, 0xafb2, 0xaa5b, 0xca7b, 0xca69, 0xca6b, 0xca60,
  0xca7c, 0xca78, 0xca7f, 0xca66, 0xca63, 0xca65, 0xafce, 0xca67,
  0xca64, 0xca79, 0xafb7, 0xca68, 0xafcf, 0xafb0, 0xaa51, 0xd56f,
  0xaa56, 0xd56d, 0xaa5d, 0xaa58, 0xd552, 0xd551, 0xd56c, 0xaa5c,
  0xd556, 0xaa59, 0xaa5f, 0xd56e, 0xaa5e, 0xaa5a, 0xaa55, 0xaa57,
  0xaa54, 0xd550, 0xd553, 0xd569, 0xd0d9, 0xb4f4, 0xdccf, 0xd0de,
  0xd0eb, 0xb54d, 0xd0e9, 0xb4f3, 0xb4f7, 0xd0e0, 0xd0d0, 0xd0ed,
  0xb54e, 0xd0e7, 0xd0ef, 0xb4f6, 0xb549, 0xd0ea, 0xd0e8, 0xd0db,
  0xd0e6, 0xd0d2, 0xd0d7, 0xd0dd, 0xd0e1, 0xd0d1, 0xd0c2, 0xb54f,
  0xd0ec, 0xd0e3, 0xd0d3, 0xd0df, 0xd0da, 0xd0c3, 0xb54c, 0xd0d6,
  0xd0d5, 0xb4f1, 0xd0dc, 0xd0e4, 0xb4f0, 0xd0d4, 0xd0d8, 0xd0e5,
  0xb04d, 0xdcb6, 0xdcb5, 0xdcc4, 0xdcb0, 0xdcc7, 0xb04f, 0xdccb,
  0xdcce, 0xdcc9, 0xdcca, 0xdcc6, 0xd0ee, 0xdcc0, 0xd94a, 0xb04e,
  0xdcc3, 0xdcbb, 0xdccd, 0xdcc8, 0xb04c, 0xb049, 0xdcc1, 0xdcc2,
  0xdcb7, 0xdcba, 0xdcb4, 0xdcb3, 0xdcb1, 0xb048, 0xdcc5, 0xdcb2,
  0xdccc, 0xdcb8, 0xd8f7, 0xd8f5, 0xb34f, 0xb34d, 0xd94e, 0xd8f4,
  0xd949, 0xd94d, 0xd8fa, 0xd94b, 0xd8fb, 0xd8f0, 0xb2f3, 0xb2f0,
  0xb2f1, 0xd8f6, 0xd94c, 0xb2f4, 0xb34c, 0xd8f9, 0xd8f3, 0xd8fe,
  0xd8f1, 0xb2f7, 0xd94f, 0xd8f8, 0xb2f6, 0xd948, 0xe563, 0xbdef,
  0xbdec, 0xbdee, 0xe577, 0xe57d, 0xe57b, 0xe566, 0xe574, 0xe575,
  0xe571, 0xe578, 0xbdd3, 0xe579, 0xbde9, 0xe560, 0xbdd2, 0xe576,
  0xbded, 0xe562, 0xe57f, 0xe57a, 0xe57c, 0xe561, 0xe57e, 0xe158,
  0xb86c, 0xe155, 0xe15a, 0xe157, 0xe151, 0xb852, 0xe15b, 0xe159,
  0xe150, 0xe156, 0xe154, 0xe152, 0xe153, 0xb86e, 0xb853, 0xb86d,
  0xb86f, 0xe16d, 0xed5a, 0xed5b, 0xed58, 0xed55, 0xed5c, 0xed5f,
  0xed57, 0xed5e, 0xbac8, 0xed51, 0xed56, 0xed59, 0xe8dc, 0xc4a5,
  0xe8c2, 0xe8d9, 0xe8de, 0xed54, 0xc4aa, 0xe8df, 0xe8c3, 0xe8db,
  0xe8d8, 0xc4ab, 0xe8dd, 0xbacb, 0xc659, 0xebcc, 0xf5f7, 0xf5f6,
  0xf5f1, 0xc051, 0xc050, 0xf04e, 0xf1c5, 0xf1ca, 0xf2d6, 0xf2d1,
  0xf3d8, 0xfcaa, 0xa061, 0xa060, 0xa063, 0xa0d8, 0xa1a8, 0xcdde,
  0xa27f, 0xa27e, 0xa3ba, 0xa3b5, 0xa3bb, 0xa3b8, 0xad7e, 0xc858,
  0xad78, 0xad79, 0xc85b, 0xafc9, 0xaa50, 0xd568, 0xd0fd, 0xb548,
  0xb04a, 0xd0e2, 0xb04b, 0xbde8, 0xe570, 0xbaca, 0xc4a4, 0xe8da,
  0xc053, 0xc17d, 0xcd7f, 0xa1ab, 0xcd7e, 0xa27b, 0xa279, 0xa278,
  0xa27a, 0xa3b7, 0xa3b4, 0xceb1, 0xa3b6, 0xceb0, 0xc85a, 0xc855,
  0xad7b, 0xad75, 0xad77, 0xad7a, 0xad76, 0xad74, 0xafc5, 0xafc8,
  0xafca, 0xafc4, 0xafcb, 0xd56b, 0xca7a, 0xd565, 0xd56a, 0xaa6e,
  0xaa52, 0xaa6d, 0xaa6f, 0xaa69, 0xaa6c, 0xaa6b, 0xaa68, 0xb547,
  0xd0ff, 0xd0fc, 0xb544, 0xb545, 0xb54a, 0xb546, 0xb54b, 0xdcd8,
  0xdcdf, 0xb044, 0xdcdc, 0xdcdb, 0xb046, 0xdcd9, 0xb045, 0xb047,
  0xdcde, 0xd945, 0xd944, 0xd947, 0xbdeb, 0xbde3, 0xe573, 0xbde5,
  0xbde1, 0xe5ac, 0xbde0, 0xbde4, 0xbde7, 0xbdea, 0xbde6, 0xb86b,
  0xdcdd, 0xb86a, 0xb868, 0xb869, 0xed50, 0xbac5, 0xe8d5, 0xe8d4,
  0xc769, 0xc052, 0xa062, 0xa275, 0xafc7, 0xd564, 0xaa6a, 0xb543,
  0xb540, 0xb541, 0xb041, 0xb040, 0xdcda, 0xbde2, 0xbac4, 0xa07d,
  0xcd51, 0xa0db, 0xcd79, 0xcdd9, 0xa274, 0xad71, 0xd946, 0xa07c,
  0xa0da, 0xcdd8, 0xceb3, 0xceb2, 0xa3b1, 0xdcd5, 0xb043, 0xd941,
  0xc4a7, 0xa07f, 0xa0a5, 0xa0d5, 0xcd78, 0xa1aa, 0xa3cd, 0xa3b2,
  0xa3b0, 0xa3b3, 0xc854, 0xad73, 0xadac, 0xc857, 0xad70, 0xafc3,
  0xca75, 0xafc0, 0xafc6, 0xafc1, 0xaa67, 0xaa65, 0xd566, 0xaa64,
  0xd567, 0xaa53, 0xd0fe, 0xb55d, 0xb55c, 0xb542, 0xbdfd, 0xe5af,
  0xb865, 0xb864, 0xe16c, 0xc4a6, 0xebcf, 0xebce, 0xc0d0, 0xfca5,
  0xcd46, 0xa0d4, 0xa07e, 0xcd7a, 0xcd7b, 0xa277, 0xcdda, 0xcdd5,
  0xcddb, 0xcdd4, 0xceca, 0xcecf, 0xcec9, 0xcecb, 0xcece, 0xa3c9,
  0xcecd, 0xcecc, 0xa3cc, 0xa3cf, 0xcec8, 0xcec5, 0xa3ce, 0xcec4,
  0xc865, 0xc86f, 0xc850, 0xadae, 0xc868, 0xc86e, 0xc851, 0xc864,
  0xc861, 0xc86a, 0xc86d, 0xada8, 0xc86b, 0xadab, 0xc86c, 0xc869,
  0xc856, 0xc852, 0xc866, 0xadaa, 0xada5, 0xc853, 0xc867, 0xadaf,
  0xada9, 0xcaa6, 0xcaa9, 0xcaa7, 0xcaae, 0xcaa8, 0xca70, 0xca76,
  0xcaa1, 0xcaa4, 0xca74, 0xafdd, 0xcaaa, 0xcaa5, 0xcaab, 0xca71,
  0xca77, 0xafc2, 0xcaaf, 0xca73, 0xcaac, 0xcaa0, 0xaa62, 0xaa63,
  0xd561, 0xaa66, 0xd563, 0xaa7d, 0xd562, 0xaa7e, 0xaa7c, 0xd57d,
  0xcaa3, 0xd57f, 0xaa60, 0xaa61, 0xd560, 0xd57c, 0xaa7f, 0xb55e,
  0xb55f, 0xd0f8, 0xd0f4, 0xd0f6, 0xb559, 0xd0f3, 0xb555, 0xd14c,
  0xb557, 0xb55b, 0xb553, 0xb556, 0xd0fa, 0xb558, 0xd0fb, 0xd0f9,
  0xd14e, 0xd0f5, 0xb55a, 0xd14f, 0xb551, 0xd0f0, 0xd0f1, 0xb550,
  0xd0f7, 0xb554, 0xd149, 0xd14d, 0xdcea, 0xdce3, 0xdcee, 0xb05c,
  0xdcd2, 0xdce2, 0xdcd4, 0xdce1, 0xdce7, 0xdce9, 0xdce0, 0xdceb,
  0xdcd3, 0xdcfd, 0xdcd1, 0xdce4, 0xdcd7, 0xdcfc, 0xb05f, 0xdce6,
  0xd942, 0xdcd0, 0xb042, 0xdcec, 0xb05d, 0xdced, 0xdce8, 0xdcef,
  0xdce5, 0xd95e, 0xd95b, 0xd943, 0xd95d, 0xd958, 0xd959, 0xb34e,
  0xdcd6, 0xd95f, 0xb349, 0xd940, 0xd95c, 0xe5a4, 0xe5bd, 0xe5aa,
  0xe5a3, 0xe5a8, 0xe5a0, 0xe5bc, 0xe5a9, 0xe5a5, 0xe5ae, 0xbdfc,
  0xe5ab, 0xbdff, 0xe5a1, 0xe5a6, 0xe5a7, 0xe5a2, 0xe168, 0xe16a,
  0xb866, 0xe165, 0xe16e, 0xe16f, 0xe161, 0xe167, 0xb867, 0xe160,
  0xe169, 0xe164, 0xe166, 0xe16b, 0xed6c, 0xed6b, 0xed6d, 0xed68,
  0xed53, 0xed65, 0xed69, 0xed64, 0xed6e, 0xed52, 0xed6a, 0xed67,
  0xed6f, 0xe8d7, 0xc4a2, 0xc4a0, 0xc4a1, 0xc4a3, 0xebc9, 0xf57f,
  0xf5f0, 0xf049, 0xf048, 0xc06d, 0xf1c4, 0xc0d3, 0xf1c7, 0xf2d3,
  0xc17f, 0xc17c, 0xf2d0, 0xc1c4, 0xf3db, 0xa079, 0xa276, 0xcdd7,
  0xcec7, 0xacb8, 0xb552, 0xa078, 0xa1a7, 0xa1a4, 0xa1a5, 0xa3c8,
  0xaa79, 0xd95a, 0xa07b, 0xa07a, 0xa075, 0xa0d7, 0xafdc, 0xcaa2,
  0xb05e, 0xa074, 0xcd50, 0xa1a6, 0xa1a1, 0xcd75, 0xa271, 0xcec6,
  0xa3cb, 0xcec1, 0xada3, 0xc863, 0xada1, 0xada6, 0xc860, 0xada4,
  0xc862, 0xada7, 0xada0, 0xafdf, 0xafd9, 0xcabe, 0xcabd, 0xcabc,
  0xcabf, 0xcab9, 0xafde, 0xd579, 0xd57e, 0xaa7b, 0xaa78, 0xb56f,
  0xd14b, 0xb56c, 0xb56e, 0xb56d, 0xb058, 0xd148, 0xb05b, 0xdcfe,
  0xb05a, 0xdcff, 0xb059, 0xd957, 0xd951, 0xb348, 0xd956, 0xd954,
  0xd955, 0xe5b9, 0xbdfa, 0xbdf8, 0xbdfb, 0xe5bf, 0xe5be, 0xbdfe,
  0xe17c, 0xe162, 0xb860, 0xe17d, 0xb863, 0xb861, 0xbdf9, 0xed60,
  0xed66, 0xed61, 0xe163, 0xe8d1, 0xc4bd, 0xe8d6, 0xebc8, 0xebcb,
  0xed63, 0xf5f3, 0xa077, 0xa1a0, 0xa273, 0xcdd6, 0xa270, 0xada2,
  0xb34b, 0xa0d6, 0xa1a3, 0xafd8, 0xb055, 0xcd74, 0xcd77, 0xcdd1,
  0xa3c5, 0xcedd, 0xcec3, 0xa3c4, 0xcec0, 0xcec2, 0xcedc, 0xa3ca,
  0xadbe, 0xadb9, 0xadbc, 0xadbd, 0xcab5, 0xadbf, 0xafdb, 0xcaba,
  0xcab4, 0xcabb, 0xcab7, 0xafda, 0xaa74, 0xd578, 0xd57a, 0xaa7a,
  0xd575, 0xaa75, 0xd57b, 0xcab8, 0xd14a, 0xd147, 0xd146, 0xd145,
  0xb56a, 0xb56b, 0xb569, 0xb568, 0xd144, 0xb565, 0xb057, 0xb056,
  0xb051, 0xd950, 0xd952, 0xd96c, 0xb345, 0xb34a, 0xb054, 0xd96d,
  0xd953, 0xe5b5, 0xe5bb, 0xe5b1, 0xbdf5, 0xe5b0, 0xe5b7, 0xbdf4,
  0xe5ba, 0xe5b8, 0xe5b6, 0xb87d, 0xe17e, 0xe5b4, 0xb87f, 0xe179,
  0xb87c, 0xb879, 0xe178, 0xb862, 0xb87e, 0xed7e, 0xed7c, 0xed7d,
  0xed7f, 0xed62, 0xc76b, 0xf04b, 0xf04a, 0xf1c6, 0xf2d2, 0xc258,
  0xadb8, 0xa3c7, 0xafd5, 0xa076, 0xa0d1, 0xa1a2, 0xcdd0, 0xa3c6,
  0xcedf, 0xcab6, 0xafd4, 0xbdf7, 0xa071, 0xa2ac, 0xb344, 0xa070,
  0xa0d0, 0xa0d3, 0xa1bc, 0xa1bd, 0xcdd3, 0xa2af, 0xcede, 0xa3c1,
  0xc87c, 0xc87f, 0xc87e, 0xadbb, 0xadba, 0xc87d, 0xadb5, 0xafd7,
  0xcab1, 0xd577, 0xaa77, 0xd574, 0xb564, 0xd141, 0xb567, 0xd140,
  0xb050, 0xd96f, 0xe5b2, 0xe5b3, 0xbdf6, 0xb878, 0xe17b, 0xbac7,
  0xed79, 0xc4bc, 0xc17e, 0xf3d5, 0xc879, 0xcab0, 0xb566, 0xdcf9,
  0xb347, 0xc658, 0xa3c3, 0xa3c0, 0xafd6, 0xd576, 0xb560, 0xb74e,
  0xb563, 0xb561, 0xb053, 0xe5cd, 0xbdf1, 0xb87b, 0xcd41, 0xcdd2,
  0xced8, 0xa3c2, 0xced9, 0xa3dd, 0xadb1, 0xc87a, 0xc87b, 0xadb6,
  0xadb4, 0xadb7, 0xc878, 0xafd0, 0xcab3, 0xafed, 0xafd1, 0xafef,
  0xafd3, 0xafd2, 0xafec, 0xaa70, 0xaa71, 0xaa76, 0xd142, 0xb562,
  0xb57f, 0xb57d, 0xd143, 0xb578, 0xb57c, 0xd15d, 0xb579, 0xb57e,
  0xdcfb, 0xdcf8, 0xb06c, 0xb052, 0xb06d, 0xdcfa, 0xb346, 0xd969,
  0xb341, 0xd96e, 0xe17a, 0xb875, 0xe5cc, 0xb87a, 0xbdf0, 0xe8d3,
  0xed78, 0xc4bf, 0xe8d0, 0xf64d, 0xf045, 0xf044, 0xa0d2, 0xa1bf,
  0xcd76, 0xa3df, 0xa3d9, 0xcdef, 0xced5, 0xceda, 0xcedb, 0xcdec,
  0xcded, 0xa2a9, 0xa3de, 0xa3dc, 0xa2ae, 0xadb0, 0xc875, 0xadb3,
  0xced0, 0xced2, 0xced3, 0xc874, 0xced7, 0xa3d5, 0xa3db, 0xced4,
  0xced6, 0xceec, 0xa3d8, 0xced1, 0xcee8, 0xadcd, 0xceef, 0xa3da,
  0xceed, 0xceee, 0xadb2, 0xadcc, 0xcee9, 0xc8a2, 0xc8af, 0xc873,
  0xc8a3, 0xc8a4, 0xafea, 0xadcf, 0xc8a7, 0xc8a0, 0xafee, 0xc8a1,
  0xadce, 0xadc5, 0xadcb, 0xc8ae, 0xc871, 0xc8a8, 0xadc0, 0xc8bd,
  0xafe9, 0xc8ab, 0xafe8, 0xadc4, 0xc8a5, 0xcac0, 0xafeb, 0xc876,
  0xadc7, 0xafe5, 0xadc6, 0xadca, 0xadc1, 0xc8aa, 0xc877, 0xc8a6,
  0xadc9, 0xc870, 0xc8a9, 0xc8ac, 0xadc8, 0xcab2, 0xcacd, 0xcac7,
  0xd5ac, 0xcac6, 0xafe3, 0xcac3, 0xcac9, 0xafe0, 0xcacb, 0xcaca,
  0xcac4, 0xafe4, 0xaaae, 0xcac8, 0xcacc, 0xaaa9, 0xcac2, 0xaa73,
  0xd570, 0xcac5, 0xd571, 0xcace, 0xcac1, 0xafe1, 0xaaac, 0xafff,
  0xaaaf, 0xcadd, 0xd573, 0xafe6, 0xaaab, 0xaffc, 0xaffd, 0xafe2,
  0xaaa8, 0xcadc, 0xaaaa, 0xafe7, 0xcacf, 0xb57b, 0xd5a9, 0xd5ab,
  0xd5a5, 0xaaa5, 0xaaa3, 0xd15e, 0xd5a1, 0xd5ae, 0xb575, 0xd15c,
  0xaaa0, 0xaaa6, 0xd5a3, 0xd15f, 0xd5a8, 0xaaa1, 0xd5a4, 0xaaa2,
  0xd5a6, 0xaaa7, 0xd5a7, 0xd5a0, 0xd5aa, 0xaaa4, 0xb574, 0xd5af,
  0xb57a, 0xb577, 0xd158, 0xd153, 0xb069, 0xb571, 0xb5ae, 0xb068,
  0xd16d, 0xb5a7, 0xdcf4, 0xd15b, 0xb5af, 0xb5a8, 0xb573, 0xd159,
  0xd16f, 0xd168, 0xdd44, 0xd16e, 0xdcf0, 0xb5ac, 0xb5a5, 0xb5a1,
  0xd150, 0xdcf5, 0xd16c, 0xb576, 0xdcf7, 0xd169, 0xdcf1, 0xd154,
  0xb06f, 0xd15a, 0xd155, 0xb5aa, 0xb5ab, 0xd156, 0xb5a6, 0xd152,
  0xb5a9, 0xd151, 0xb5a4, 0xb06b, 0xb06e, 0xdcf6, 0xd157, 0xb570,
  0xb066, 0xb062, 0xdd4d, 0xb35c, 0xb060, 0xdd49, 0xb07c, 0xd968,
  0xdd4b, 0xb35e, 0xb064, 0xb061, 0xdd4a, 0xdd45, 0xdd43, 0xb07e,
  0xb359, 0xdd47, 0xdd42, 0xdd4e, 0xb353, 0xb358, 0xb07f, 0xdd4c,
  0xdd5d, 0xb350, 0xb07d, 0xb343, 0xdd40, 0xb079, 0xdd48, 0xdcf3,
  0xb067, 0xdd4f, 0xdd46, 0xb340, 0xb35f, 0xb06a, 0xdd41, 0xb35d,
  0xb065, 0xb351, 0xe5ce, 0xd97d, 0xd965, 0xe5cf, 0xd961, 0xd963,
  0xd966, 0xb356, 0xd967, 0xb352, 0xe5df, 0xb357, 0xbe4d, 0xd97c,
  0xe5c9, 0xb355, 0xd964, 0xd960, 0xbdf3, 0xb342, 0xd96b, 0xd96a,
  0xbe4c, 0xb35a, 0xb354, 0xb35b, 0xd962, 0xe5c5, 0xe5c4, 0xe5c3,
  0xb870, 0xe5d8, 0xbe4a, 0xbe4b, 0xe5dd, 0xb871, 0xe5c8, 0xbe48,
  0xe5d9, 0xbe4e, 0xbe49, 0xe5dc, 0xe1a7, 0xb877, 0xb063, 0xe5de,
  0xb8ae, 0xe5c6, 0xb876, 0xb8af, 0xe5cb, 0xe5c7, 0xe5ca, 0xe5c0,
  0xbe45, 0xb874, 0xbe4f, 0xe177, 0xe5c2, 0xb8ac, 0xb8a9, 0xe5c1,
  0xb873, 0xe174, 0xe173, 0xbac3, 0xe175, 0xedae, 0xe1a4, 0xb8a5,
  0xb8ab, 0xbac1, 0xe1ab, 0xe1af, 0xb8a1, 0xed75, 0xb8a7, 0xe1ac,
  0xed7b, 0xe1a8, 0xe1a5, 0xe170, 0xb8a6, 0xb8a8, 0xed7a, 0xbac0,
  0xe1aa, 0xb8aa, 0xb8a4, 0xe1a9, 0xb8a0, 0xe1ae, 0xe171, 0xe176,
  0xbac6, 0xe1a6, 0xed77, 0xe8ed, 0xbadd, 0xedaf, 0xed73, 0xe8ec,
  0xbadc, 0xedac, 0xed71, 0xc4b9, 0xe8d2, 0xed74, 0xed76, 0xc4b8,
  0xbade, 0xc4be, 0xbadf, 0xc4ba, 0xed70, 0xbac2, 0xebc2, 0xebca,
  0xe8ea, 0xebc5, 0xe8ee, 0xc65b, 0xe8e8, 0xe8e9, 0xc4bb, 0xe8ef,
  0xe8eb, 0xebdd, 0xebc1, 0xebc3, 0xebc4, 0xebc7, 0xebc0, 0xebc6,
  0xc76a, 0xc767, 0xc764, 0xc765, 0xc06c, 0xf047, 0xc06f, 0xf64c,
  0xc0d2, 0xf1c1, 0xc0ed, 0xc179, 0xc1c7, 0xf3d4, 0xf3d7, 0xf3d6,
  0xfdb7, 0xa0ed, 0xcd71, 0xa1be, 0xa2ab, 0xa2aa, 0xa2a8, 0xa2a5,
  0xa3d7, 0xa3d4, 0xc8bc, 0xadc2, 0xadc3, 0xd5a2, 0xb5a0, 0xb5a3,
  0xb078, 0xd97f, 0xb36d, 0xb36c, 0xd979, 0xd97b, 0xd978, 0xe5da,
  0xe5db, 0xbe44, 0xe5d5, 0xe1a1, 0xb8a3, 0xbad9, 0xc4b5, 0xc65a,
  0xc4b4, 0xa0ec, 0xceeb, 0xc8bf, 0xaddc, 0xaddd, 0xaddf, 0xaffe,
  0xcadf, 0xcade, 0xd5bd, 0xaabd, 0xb5a2, 0xb07b, 0xdd5c, 0xa0ef,
  0xa073, 0xa0ee, 0xcd70, 0xa1ba, 0xa1bb, 0xa1b9, 0xa1b8, 0xa2a6,
  0xcde4, 0xcde6, 0xa2a7, 0xcdee, 0xcde9, 0xcde7, 0xcdeb, 0xcde5,
  0xa2a4, 0xcde8, 0xcde1, 0xcdea, 0xa3ec, 0xa3e7, 0xa3e5, 0xcefd,
  0xcee0, 0xcef8, 0xa3eb, 0xcefb, 0xa3d2, 0xcefe, 0xa3e8, 0xcee2,
  0xcee3, 0xa3ee, 0xcef9, 0xa3e9, 0xadde, 0xa3d3, 0xcefc, 0xceea,
  0xa3d6, 0xa3e3, 0xcee1, 0xceff, 0xa3ed, 0xa3ef, 0xcee5, 0xcee4,
  0xcee7, 0xa3e0, 0xa3ea, 0xa3e1, 0xcee6, 0xa3e6, 0xa3d0, 0xa3d1,
  0xa3e4, 0xadec, 0xc8b3, 0xc8ba, 0xadd1, 0xade2, 0xc8be, 0xc8b7,
  0xc8b1, 0xc8b2, 0xade7, 0xc8b6, 0xc8b9, 0xade5, 0xc8b5, 0xc8cd,
  0xadd4, 0xc8b0, 0xadee, 0xadef, 0xc8bb, 0xadda, 0xadd5, 0xaddb,
  0xade3, 0xadeb, 0xaded, 0xadd9, 0xc8b4, 0xadd2, 0xadd8, 0xadea,
  0xadfd, 0xcad9, 0xade9, 0xc8b8, 0xadd7, 0xadd0, 0xadd3, 0xade1,
  0xade0, 0xade6, 0xade8, 0xade4, 0xadd6, 0xaff9, 0xcad7, 0xa84c,
  0xaff5, 0xaff7, 0xa84d, 0xcaeb, 0xaff0, 0xd5bc, 0xaabc, 0xa84e,
  0xcada, 0xcad2, 0xaff3, 0xcad3, 0xcad6, 0xcaee, 0xcae8, 0xaffa,
  0xaff6, 0xa84f, 0xaabe, 0xcaed, 0xaff4, 0xa848, 0xcad4, 0xaff1,
  0xaabf, 0xaffb, 0xcadb, 0xcad0, 0xcad8, 0xcad5, 0xcad1, 0xd5bf,
  0xa849, 0xcaec, 0xcaef, 0xcae9, 0xaff8, 0xaacc, 0xd5b3, 0xaab2,
  0xaacd, 0xd5b9, 0xd5c9, 0xaabb, 0xd16b, 0xd5cb, 0xd5cd, 0xd5ba,
  0xd5c4, 0xd5b7, 0xaab1, 0xd170, 0xd5b0, 0xaab3, 0xaab8, 0xd5c6,
  0xd5b2, 0xaab5, 0xd5b5, 0xd5b8, 0xd5bb, 0xaab4, 0xd5c8, 0xd5c1,
  0xaab6, 0xd5b1, 0xd5b6, 0xaace, 0xaacf, 0xaab9, 0xaab7, 0xaab0,
  0xd5c5, 0xd5cf, 0xaaba, 0xd5be, 0xd5c7, 0xd5cc, 0xd5ce, 0xd5ca,
  0xd16a, 0xb5ba, 0xb5c6, 0xb5c7, 0xb5b2, 0xd174, 0xd178, 0xd17f,
  0xd1ab, 0xb5b7, 0xb5bf, 0xd17a, 0xb0a5, 0xb5bb, 0xd1ac, 0xb5c1,
  0xb5c4, 0xd176, 0xd167, 0xb5c5, 0xd1ae, 0xd164, 0xb5b0, 0xb5cc,
  0xd1af, 0xd17e, 0xb5cf, 0xb5b1, 0xd165, 0xb075, 0xd1a8, 0xd17c,
  0xb5ca, 0xd179, 0xd1a9, 0xb5cb, 0xdd5f, 0xb5be, 0xd162, 0xb5b5,
  0xb5ce, 0xb5b3, 0xd175, 0xd163, 0xd161, 0xd173, 0xb5bd, 0xb5c9,
  0xb5b9, 0xb07a, 0xd171, 0xb5b8, 0xb5bc, 0xb5cd, 0xb5b6, 0xb5b4,
  0xd17d, 0xb5c8, 0xd160, 0xd177, 0xd17b, 0xdd59, 0xdd5e, 0xd166,
  0xdd69, 0xb077, 0xdd67, 0xdd54, 0xdd6a, 0xd97a, 0xb070, 0xdd66,
  0xdd63, 0xb071, 0xdd51, 0xdd60, 0xdd61, 0xb073, 0xdd58, 0xb074,
  0xb0ae, 0xb0ac, 0xdd64, 0xdd52, 0xb0a8, 0xdd7d, 0xdd65, 0xdd7c,
  0xb0a0, 0xb0a6, 0xdd6b, 0xdd68, 0xdd6e, 0xdd50, 0xb0a9, 0xb0af,
  0xd5b4, 0xdd5b, 0xd9ba, 0xdd5a, 0xb076, 0xb0a7, 0xd974, 0xb0ab,
  0xb0aa, 0xdd55, 0xdd62, 0xd975, 0xdd6d, 0xdd56, 0xb0a4, 0xdd6c,
  0xdd53, 0xb0a3, 0xb37d, 0xd971, 0xd9bc, 0xd9bb, 0xd9a7, 0xb361,
  0xd9b6, 0xb364, 0xd977, 0xd976, 0xb36f, 0xb366, 0xd9a9, 0xb363,
  0xb362, 0xd9a8, 0xd9bf, 0xd9b5, 0xb367, 0xb369, 0xd9ae, 0xd970,
  0xd9b7, 0xd9a5, 0xd9a4, 0xd973, 0xd9b9, 0xd9a6, 0xd9b8, 0xd9a0,
  0xb368, 0xe5d4, 0xb365, 0xb36b, 0xd9b4, 0xd9bd, 0xd9a1, 0xd9ac,
  0xbe5e, 0xd9a2, 0xb360, 0xd9aa, 0xd9ab, 0xb36a, 0xb36e, 0xe5e3,
  0xd9be, 0xd9a3, 0xd9af, 0xe5e4, 0xe5d7, 0xe5e8, 0xe5e1, 0xbe5c,
  0xb0a1, 0xe5e7, 0xbe41, 0xbe46, 0xe5fc, 0xe5d6, 0xe5e5, 0xe5d1,
  0xe5ea, 0xbe42, 0xe5e6, 0xdd6f, 0xe5ff, 0xe5ee, 0xbe5f, 0xe1b7,
  0xb8a2, 0xe5fd, 0xe5e2, 0xbe59, 0xe1a0, 0xb8bd, 0xe1a3, 0xe5d2,
  0xe5ed, 0xe5d0, 0xe5ef, 0xe5d3, 0xe5fe, 0xbe43, 0xb8bc, 0xbe5d,
  0xbe58, 0xe5ec, 0xe5e0, 0xe5eb, 0xe1bc, 0xbe47, 0xb8b9, 0xeda7,
  0xe1bb, 0xe1b8, 0xe1ba, 0xe1b9, 0xb8b8, 0xb8b6, 0xb8b5, 0xb8b4,
  0xe1a2, 0xe1bf, 0xe1b1, 0xb8cc, 0xb8b2, 0xe1be, 0xdd57, 0xb8bf,
  0xe1b4, 0xe1bd, 0xb8cf, 0xe1b5, 0xbe40, 0xb8ba, 0xe5e9, 0xb8b7,
  0xb8b3, 0xb8cd, 0xb8b0, 0xb8b1, 0xb8bb, 0xe1b6, 0xb8be, 0xb8ce,
  0xbad5, 0xbad4, 0xeda4, 0xbaef, 0xbad2, 0xbadb, 0xbad0, 0xeda6,
  0xbad6, 0xbad8, 0xbad1, 0xeda5, 0xc4b6, 0xbada, 0xbad3, 0xc4b7,
  0xedaa, 0xedab, 0xbaed, 0xbaec, 0xeda8, 0xeda9, 0xc4b1, 0xeda3,
  0xbad7, 0xeda1, 0xc4b0, 0xc4cf, 0xe8e7, 0xe8e1, 0xc4b2, 0xe8e0,
  0xe8e4, 0xe8e6, 0xc4cd, 0xc4ce, 0xe8e5, 0xc4b3, 0xc4cc, 0xc654,
  0xeda0, 0xc655, 0xc653, 0xebd9, 0xc651, 0xc650, 0xebda, 0xebde,
  0xc657, 0xebdc, 0xc766, 0xebd8, 0xebdb, 0xebdf, 0xc656, 0xf64f,
  0xf648, 0xf64b, 0xf649, 0xf64a, 0xc761, 0xf64e, 0xf043, 0xc069,
  0xf040, 0xf041, 0xf046, 0xc06e, 0xc068, 0xf1c0, 0xc0ef, 0xc0ec,
  0xf2ec, 0xf2ed, 0xf2ee, 0xc1c6, 0xc178, 0xf3d0, 0xf2ef, 0xf3d1,
  0xc1c0, 0xc1c1, 0xc1fe, 0xfca4, 0xfce2, 0xa0e9, 0xdd7f, 0xeda2,
  0xa2a1, 0xcefa, 0xa3fc, 0xa3e2, 0xa3fd, 0xc8cc, 0xadfc, 0xa84b,
  0xcaea, 0xcae5, 0xa84a, 0xd5c3, 0xaac9, 0xaac8, 0xd5c0, 0xb5de,
  0xb5c2, 0xd1aa, 0xb5db, 0xb5d8, 0xb5c3, 0xb5dc, 0xb5d9, 0xb5dd,
  0xdd7b, 0xb5c0, 0xb0a2, 0xb0bc, 0xb0bf, 0xdd78, 0xdd75, 0xb0bd,
  0xdd7e, 0xdd7a, 0xdd79, 0xb37c, 0xd9b1, 0xbe5b, 0xe5f9, 0xbaee,
  0xb8c9, 0xe1b0, 0xb8c8, 0xb8cb, 0xe1b2, 0xe1b3, 0xe1cd, 0xedbc,
  0xedbd, 0xe8e2, 0xe8e3, 0xc4c9, 0xc4c8, 0xf645, 0xa0e8, 0xdd74,
  0xb0b9, 0xb0be, 0xd9b0, 0xebd5, 0xc0ee, 0xf3d3, 0xa0eb, 0xaacb,
  0xb5d5, 0xb5da, 0xdd77, 0xdd76, 0xb37f, 0xe5f8, 0xbe5a, 0xedbf,
  0xa0ea, 0xa1b5, 0xadff, 0xc8cf, 0xcae4, 0xa845, 0xb5d4, 0xdd71,
  0xb0b8, 0xb37e, 0xe1cc, 0xe1cf, 0xe8fd, 0xc652, 0xfcfd, 0xa0e5,
  0xc8ce, 0xadfe, 0xa844, 0xcae7, 0xaaca, 0xd5df, 0xd5dd, 0xd5dc,
  0xaac5, 0xd5c2, 0xb5d6, 0xb5d1, 0xd1a5, 0xb5d0, 0xb5d7, 0xdd70,
  0xdd73, 0xd9b3, 0xbe54, 0xbe55, 0xe8fc, 0xebd4, 0xf647, 0xf644,
  0xf042, 0xcd53, 0xa847, 0xa0e4, 0xa1b4, 0xa2a3, 0xa2a0, 0xa2a2,
  0xa2bd, 0xcde3, 0xcde0, 0xcef5, 0xa3ff, 0xcef6, 0xcef7, 0xcef4,
  0xcef1, 0xadf9, 0xc8c4, 0xc8c8, 0xc8c3, 0xadf6, 0xadf4, 0xc8c7,
  0xc8cb, 0xc8c0, 0xadf5, 0xae4d, 0xc8c5, 0xc8c9, 0xadf3, 0xc8c6,
  0xadfa, 0xc8c1, 0xadf7, 0xadf1, 0xc8dd, 0xc8c2, 0xc8ca, 0xadfb,
  0xadf8, 0xadf0, 0xcae2, 0xcaf8, 0xa85d, 0xa840, 0xcae1, 0xcafc,
  0xa85e, 0xa846, 0xcafd, 0xa843, 0xa85c, 0xcafe, 0xa841, 0xcaf5,
  0xa842, 0xa85f, 0xcae0, 0xcaff, 0xcafb, 0xcae3, 0xcae6, 0xcafa,
  0xcaf9, 0xaadd, 0xaac4, 0xaac1, 0xaac2, 0xd5d8, 0xaac7, 0xd5de,
  0xaac3, 0xaac6, 0xd5db, 0xaac0, 0xd1a1, 0xb5d2, 0xd1a6, 0xd1a0,
  0xb5d3, 0xb5ee, 0xd5d9, 0xd1a7, 0xd1a3, 0xb5ed, 0xd1a4, 0xb5ef,
  0xb5ec, 0xddaa, 0xddaf, 0xb0bb, 0xb0b7, 0xb0ba, 0xdda8, 0xdda5,
  0xb0b5, 0xb0b4, 0xb0b3, 0xd9ca, 0xddab, 0xb0b1, 0xddae, 0xddac,
  0xb0b0, 0xdda9, 0xb374, 0xd9b2, 0xb37b, 0xb37a, 0xb378, 0xd9c9,
  0xd9ce, 0xd9cd, 0xb376, 0xd9cf, 0xb0b6, 0xd9cb, 0xd9cc, 0xb375,
  0xb379, 0xb377, 0xd9c8, 0xbe51, 0xe5f5, 0xe5fa, 0xe5fb, 0xbe57,
  0xbe56, 0xe1c8, 0xe1c5, 0xb8c5, 0xb8ca, 0xe1c4, 0xe1c9, 0xb8c7,
  0xe1cb, 0xb8c4, 0xe1ce, 0xe1ca, 0xbae4, 0xbaeb, 0xedb6, 0xedb7,
  0xedb4, 0xedb9, 0xedb8, 0xbaea, 0xbae9, 0xbae5, 0xedbe, 0xbae8,
  0xedbb, 0xedba, 0xedb1, 0xedb5, 0xe8ff, 0xc4ca, 0xebd1, 0xc4cb,
  0xebd7, 0xebd6, 0xc66d, 0xc763, 0xf646, 0xc760, 0xf05c, 0xf05f,
  0xc06b, 0xf05d, 0xc0e9, 0xf3d2, 0xc1c3, 0xfca7, 0xfca6, 0xa0e7,
  0xa2bc, 0xa2bf, 0xa3fe, 0xc8dc, 0xa859, 0xaadc, 0xb5e9, 0xb4df,
  0xb0b2, 0xb0cd, 0xb7c1, 0xdda4, 0xb371, 0xe5f7, 0xe5f4, 0xa0e6,
  0xa2be, 0xc8df, 0xae4f, 0xae4c, 0xcaf4, 0xcaf7, 0xd5da, 0xd5d5,
  0xaadf, 0xaade, 0xaad9, 0xd1a2, 0xb5eb, 0xb0cf, 0xb0cc, 0xd9c5,
  0xdb77, 0xe5f6, 0xedb0, 0xc66c, 0xc06a, 0xa0e1, 0xa1b1, 0xa1b0,
  0xa1b6, 0xa1b3, 0xa1b7, 0xa2bb, 0xcdfb, 0xa2b8, 0xa2ba, 0xcdfc,
  0xcdfd, 0xcdfe, 0xcdff, 0xcdf8, 0xa2b9, 0xcde2, 0xcdf9, 0xcef0,
  0xa3f0, 0xcef3, 0xcf4e, 0xa3f1, 0xcf4a, 0xcf4f, 0xcf48, 0xa3f8,
  0xa3fb, 0xa3fa, 0xa3f5, 0xac4d, 0xcf4c, 0xa3f7, 0xac4c, 0xcf4d,
  0xcf4b, 0xa3f4, 0xcf49, 0xa3f6, 0xa3f9, 0xa3f3, 0xae5a, 0xc8d9,
  0xae4e, 0xae40, 0xae43, 0xae4b, 0xae55, 0xae45, 0xc8d1, 0xae5e,
  0xc8da, 0xae44, 0xc8eb, 0xc8ea, 0xc8d2, 0xc8d5, 0xae5b, 0xc8e9,
  0xae5c, 0xae42, 0xc8e8, 0xc8ee, 0xc8d6, 0xc8de, 0xc8d7, 0xae47,
  0xae5d, 0xae49, 0xc8d3, 0xc8d0, 0xc8d8, 0xae5f, 0xc8ec, 0xc8db,
  0xae58, 0xc8e5, 0xae48, 0xae41, 0xc8d4, 0xc8ef, 0xae59, 0xae4a,
  0xae46, 0xc8ed, 0xcb56, 0xa851, 0xa864, 0xcb5b, 0xcb41, 0xa86f,
  0xcb47, 0xa856, 0xcb48, 0xa868, 0xcb5f, 0xcaf3, 0xcb4c, 0xcb49,
  0xcaf6, 0xcb5c, 0xcb6c, 0xa86d, 0xcb4b, 0xcb55, 0xcaf0, 0xcb52,
  0xcb6d, 0xcb6e, 0xcb57, 0xcb46, 0xcb5e, 0xa86b, 0xa854, 0xa86c,
  0xa860, 0xa85b, 0xa855, 0xcb4e, 0xa867, 0xa86e, 0xcb50, 0xcb4d,
  0xa861, 0xa86a, 0xcb44, 0xa866, 0xcb5d, 0xcb45, 0xa869, 0xcb51,
  0xcb59, 0xa853, 0xcb6f, 0xcb4a, 0xa857, 0xcb54, 0xcb42, 0xa852,
  0xcb58, 0xa85a, 0xcaf1, 0xa865, 0xaaee, 0xa850, 0xcb43, 0xcb40,
  0xcb4f, 0xcb53, 0xcb5a, 0xa858, 0xd5e1, 0xaae7, 0xd5e0, 0xd5ec,
  0xaad2, 0xaae6, 0xd5d7, 0xd5ee, 0xd5e6, 0xd5d4, 0xd5f9, 0xaad8,
  0xd5fe, 0xd5e3, 0xd5e2, 0xaad0, 0xaae5, 0xd5e8, 0xd5eb, 0xd5fd,
  0xd5ea, 0xd5ef, 0xd5d1, 0xd5d0, 0xd5e7, 0xd5e9, 0xaadb, 0xaad7,
  0xd5ff, 0xd5d3, 0xaaeb, 0xaaef, 0xaae8, 0xaae1, 0xaad6, 0xaaea,
  0xd5e4, 0xaae4, 0xaad5, 0xaada, 0xd5d6, 0xd5d2, 0xaaed, 0xd5fc,
  0xd5e5, 0xd5ed, 0xaae9, 0xaaec, 0xaad4, 0xaad1, 0xd1c9, 0xd1b9,
  0xd1b8, 0xd1b4, 0xd1c5, 0xd1c8, 0xd1b3, 0xd1b0, 0xb5e0, 0xd1cc,
  0xd1dd, 0xd1bd, 0xd1dc, 0xd1ce, 0xd1d8, 0xd1c4, 0xb5e1, 0xd1ca,
  0xb5ea, 0xb5f1, 0xb5ff, 0xb5fb, 0xb5f8, 0xd1bc, 0xd1c3, 0xd1d9,
  0xd1c1, 0xd1de, 0xd1cd, 0xd1bf, 0xd1df, 0xd1cf, 0xb5e7, 0xb5fa,
  0xd1c6, 0xb5fd, 0xd1c7, 0xd1be, 0xb5f5, 0xb5f7, 0xd1c0, 0xb5f6,
  0xb5e4, 0xd1b7, 0xd1c2, 0xb5e2, 0xb5f4, 0xd1b1, 0xd1cb, 0xd1ba,
  0xd1b6, 0xb5f9, 0xd1bb, 0xb5e5, 0xb5fc, 0xb5e3, 0xd1b2, 0xaad3,
  0xddcd, 0xb5e6, 0xb5fe, 0xddce, 0xddd4, 0xddc3, 0xb0db, 0xb0dc,
  0xddb0, 0xb0df, 0xddc0, 0xddcb, 0xddde, 0xb0c3, 0xdda6, 0xddd8,
  0xb0c9, 0xddbe, 0xb0ca, 0xb0cb, 0xb0da, 0xdda0, 0xddc2, 0xdddd,
  0xb0c4, 0xb0c8, 0xddb6, 0xb0dd, 0xddbb, 0xdddc, 0xb0c1, 0xddc4,
  0xdddb, 0xddbd, 0xddb8, 0xdda2, 0xb0c6, 0xddcf, 0xd9d3, 0xddbc,
  0xb0c2, 0xddb7, 0xdddf, 0xb0c7, 0xddba, 0xddb9, 0xddc8, 0xb0c0,
  0xb0ce, 0xb0d4, 0xddc5, 0xddca, 0xdda1, 0xb0c5, 0xddd9, 0xddb1,
  0xddb3, 0xddc6, 0xddc7, 0xdda7, 0xb0de, 0xb0d8, 0xddbf, 0xddb4,
  0xddcc, 0xb0d9, 0xddb5, 0xddc9, 0xddda, 0xddc1, 0xddd5, 0xdda3,
  0xd9ff, 0xb3ab, 0xd9fd, 0xd9d6, 0xd9ed, 0xd9d4, 0xd9e1, 0xd9c6,
  0xd9df, 0xd9e7, 0xd9f9, 0xd9d1, 0xd9c2, 0xd9ef, 0xd9ea, 0xd9de,
  0xd9e9, 0xd9dd, 0xd9da, 0xd9d5, 0xb3a5, 0xd9e6, 0xd9e4, 0xd9c1,
  0xd9e3, 0xd9e2, 0xd9fc, 0xb3a1, 0xb3a9, 0xd1b5, 0xd9d9, 0xd9eb,
  0xd9d8, 0xb3ac, 0xb3bc, 0xd9e0, 0xb3a2, 0xb3a6, 0xd9c7, 0xb3ae,
  0xd9c0, 0xb3bd, 0xd9d0, 0xd9c4, 0xb3a4, 0xd9ec, 0xd9dc, 0xb3a7,
  0xd9d7, 0xb373, 0xb0d5, 0xd9ee, 0xddb2, 0xd9c3, 0xd9e5, 0xb3a8,
  0xd9e8, 0xb3af, 0xd9d2, 0xb3a0, 0xd9db, 0xd9fe, 0xb3aa, 0xdacb,
  0xb3a3, 0xe647, 0xe645, 0xe653, 0xe64b, 0xe655, 0xb370, 0xbe52,
  0xe64f, 0xe650, 0xe64a, 0xe658, 0xbe69, 0xbe50, 0xe656, 0xe64d,
  0xe657, 0xbe62, 0xe65c, 0xe66c, 0xbe60, 0xe644, 0xbe53, 0xe646,
  0xe654, 0xbe6a, 0xe649, 0xbe66, 0xbe6c, 0xe640, 0xe64e, 0xe5f1,
  0xe65a, 0xbe65, 0xe66d, 0xe5f0, 0xbe68, 0xe65e, 0xbe6b, 0xe648,
  0xe65d, 0xe641, 0xe643, 0xbe6d, 0xe652, 0xbe63, 0xe642, 0xe66f,
  0xe5f3, 0xe659, 0xbe6e, 0xbe61, 0xbe67, 0xe64c, 0xe65b, 0xbe64,
  0xbe6f, 0xe65f, 0xe651, 0xe1d8, 0xe1dc, 0xe1c0, 0xe1ec, 0xe1d3,
  0xb8c0, 0xe1e8, 0xe1d9, 0xb8d5, 0xe1d6, 0xe1dd, 0xe1d7, 0xb8d8,
  0xe1e3, 0xe1e6, 0xe1d0, 0xe1c3, 0xe1ef, 0xe1e9, 0xb8dc, 0xe1d5,
  0xe1de, 0xe1c7, 0xb8c3, 0xb8db, 0xe1ea, 0xb8da, 0xe1c6, 0xe1e0,
  0xe1ed, 0xe1eb, 0xb8d9, 0xe1ee, 0xe1e7, 0xb8d4, 0xb8de, 0xe1d1,
  0xe1c2, 0xe1e2, 0xe1c1, 0xe1e5, 0xb8dd, 0xe1db, 0xe1da, 0xb8c2,
  0xb8c1, 0xe1df, 0xb8df, 0xb8c6, 0xe1e4, 0xe1e1, 0xe1d4, 0xedc7,
  0xedcf, 0xedb3, 0xbafb, 0xbae6, 0xbafd, 0xbae1, 0xedc1, 0xedda,
  0xbae7, 0xedc9, 0xedc0, 0xe1d2, 0xedc3, 0xbafc, 0xedd0, 0xbaf8,
  0xbaf5, 0xedcd, 0xbaf9, 0xedd6, 0xedd1, 0xeddf, 0xeddc, 0xedc4,
  0xedde, 0xedd7, 0xedd4, 0xbae2, 0xbae0, 0xedc6, 0xedc5, 0xedc8,
  0xedd5, 0xbafa, 0xeddb, 0xbafe, 0xbaff, 0xeddd, 0xedb2, 0xedcc,
  0xedce, 0xedd8, 0xedc2, 0xbae3, 0xedcb, 0xedd9, 0xedca, 0xc4c2,
  0xe948, 0xc4c5, 0xe8f8, 0xe94c, 0xc4c7, 0xe945, 0xe8f1, 0xe8fa,
  0xe944, 0xe8fe, 0xe8f3, 0xc4dc, 0xe949, 0xe947, 0xe8f0, 0xc4c4,
  0xe94d, 0xe8f9, 0xc4dd, 0xe94a, 0xe8f4, 0xc4c1, 0xe8f6, 0xe8f5,
  0xc4df, 0xe8f7, 0xc4c6, 0xc4c3, 0xe94e, 0xe8fb, 0xe94b, 0xe94f,
  0xc66e, 0xebea, 0xc665, 0xc664, 0xc66f, 0xebeb, 0xebee, 0xebe9,
  0xc66b, 0xebd3, 0xebef, 0xc668, 0xebd2, 0xc66a, 0xc669, 0xebd0,
  0xebec, 0xebe8, 0xf65c, 0xf643, 0xf65a, 0xf65b, 0xf659, 0xf642,
  0xc77f, 0xf65d, 0xc77c, 0xc4c0, 0xf65e, 0xc77d, 0xf655, 0xf65f,
  0xf640, 0xebed, 0xc762, 0xf641, 0xf05b, 0xf058, 0xf658, 0xc065,
  0xf054, 0xf057, 0xf059, 0xf055, 0xf05e, 0xf1dc, 0xf05a, 0xc0ea,
  0xc0e8, 0xf1c2, 0xf1df, 0xf1c3, 0xf1dd, 0xc0eb, 0xf2e8, 0xf2eb,
  0xc17b, 0xf2e9, 0xf3ef, 0xc1c2, 0xf3ed, 0xf3ec, 0xfca1, 0xc25b,
  0xfcfe, 0xfcfc, 0xfcff, 0xfcf9, 0xfdb6, 0xa0e0, 0xa2b5, 0xae54,
  0xc8e4, 0xcb69, 0xd5f8, 0xd5fa, 0xd5fb, 0xd5f5, 0xb5f0, 0xd1da,
  0xd5f4, 0xd1db, 0xd1d5, 0xd1d4, 0xddd7, 0xb0d6, 0xddd6, 0xddd0,
  0xb0d1, 0xb0d7, 0xddd1, 0xd9f7, 0xd9f5, 0xd9fa, 0xd9fb, 0xd9f8,
  0xb3bf, 0xd9f4, 0xbe7d, 0xe66e, 0xe668, 0xbe7c, 0xe669, 0xb8d6,
  0xb8d7, 0xe1fd, 0xedd2, 0xedd3, 0xeded, 0xbaf4, 0xe946, 0xc4de,
  0xebe5, 0xc667, 0xf654, 0xc17a, 0xa0e3, 0xa1b2, 0xa2b4, 0xac4f,
  0xae57, 0xae56, 0xa863, 0xd5f7, 0xb3be, 0xe2dc, 0xbaf7, 0xc666,
  0xa0e2, 0xa2b7, 0xc8e6, 0xae51, 0xc8e7, 0xcb68, 0xa862, 0xcb6b,
  0xa87d, 0xd5f1, 0xaae3, 0xaae0, 0xd1d3, 0xd1d1, 0xd1d0, 0xd1d6,
  0xd1d7, 0xddd3, 0xddec, 0xb0d3, 0xddd2, 0xb0d0, 0xdded, 0xd9f6,
  0xe66b, 0xe66a, 0xe665, 0xe1fe, 0xe1ff, 0xb8d1, 0xe1fc, 0xe1f9,
  0xedec, 0xedef, 0xedee, 0xe941, 0xc4d9, 0xc661, 0xf657, 0xc0e5,
  0xcd52, 0xa87c, 0xcb6a, 0xaae2, 0xb5f3, 0xb0d2, 0xddef, 0xb3b8,
  0xb3b9, 0xe664, 0xe667, 0xb8d0, 0xb8d3, 0xede8, 0xede9, 0xebe4,
  0xf3ee, 0xa0fd, 0xcd6d, 0xa1cd, 0xac4e, 0xcf45, 0xa87f, 0xb3bb,
  0xa0fc, 0xcb65, 0xa87e, 0xcb64, 0xc4d8, 0xa0ff, 0xc8e1, 0xcb67,
  0xd64f, 0xd64c, 0xd5f3, 0xd5f0, 0xd64e, 0xd64d, 0xb64d, 0xb64c,
  0xb0ed, 0xddee, 0xdde9, 0xdde8, 0xda4c, 0xda4f, 0xda4d, 0xd9f0,
  0xd9f3, 0xb3ba, 0xe666, 0xe1fa, 0xe1fb, 0xe1f8, 0xe1f5, 0xedea,
  0xedeb, 0xbaf6, 0xede5, 0xc4db, 0xe940, 0xebe7, 0xf656, 0xf2ea,
  0xa0fe, 0xa1cf, 0xa1cc, 0xae50, 0xcd6c, 0xcd73, 0xa2b6, 0xcdfa,
  0xcf44, 0xcf47, 0xae53, 0xc8e0, 0xa879, 0xcb66, 0xcb61, 0xaafd,
  0xaaf9, 0xd649, 0xaafe, 0xaafc, 0xaaff, 0xd1d2, 0xb64f, 0xb0ee,
  0xb0ec, 0xb0ef, 0xddeb, 0xbe7f, 0xa0f9, 0xcdac, 0xa1ce, 0xcda9,
  0xa1cb, 0xcdae, 0xa1c8, 0xa1c9, 0xac49, 0xcdaf, 0xcdf5, 0xcdf1,
  0xcdf3, 0xce4d, 0xa2c8, 0xa2cb, 0xcdf6, 0xa2cc, 0xcdf4, 0xcdf0,
  0xa2cf, 0xa2b0, 0xa2b3, 0xa2c9, 0xcdf7, 0xa2b1, 0xac48, 0xa2b2,
  0xa2cd, 0xa2ce, 0xcf56, 0xcf54, 0xcf41, 0xac5c, 0xcf5e, 0xac41,
  0xcf40, 0xcf58, 0xcf5f, 0xac42, 0xcf5c, 0xac5b, 0xcf57, 0xac55,
  0xac57, 0xcf46, 0xac40, 0xcf51, 0xac59, 0xac5a, 0xc948, 0xac4a,
  0xac53, 0xac58, 0xcf43, 0xac47, 0xac54, 0xcf5b, 0xac45, 0xac44,
  0xc94e, 0xcf42, 0xac5d, 0xac56, 0xcf50, 0xcf5d, 0xac43, 0xac5e,
  0xc8e3, 0xac51, 0xcf5a, 0xac5f, 0xac50, 0xac4b, 0xcf59, 0xac46,
  0xcf55, 0xc949, 0xae67, 0xae77, 0xc8f8, 0xae7c, 0xc946, 0xae6f,
  0xae68, 0xc94f, 0xc8fe, 0xc8fa, 0xae60, 0xae62, 0xc8f7, 0xae7b,
  0xae65, 0xae6b, 0xae6a, 0xae78, 0xc94a, 0xae7d, 0xc8f4, 0xc8f6,
  0xae63, 0xae7e, 0xc8f1, 0xc947, 0xa878, 0xae74, 0xae6e, 0xc944,
  0xc940, 0xc8f5, 0xc942, 0xc94d, 0xae61, 0xc8f9, 0xae66, 0xae70,
  0xae7f, 0xc8ff, 0xcb78, 0xae75, 0xae71, 0xc94c, 0xc94b, 0xae73,
  0xae7a, 0xae64, 0xae52, 0xae69, 0xc8fb, 0xae6d, 0xc943, 0xc8fd,
  0xc8e2, 0xc8f0, 0xc8fc, 0xae76, 0xaaf8, 0xae79, 0xc8f3, 0xae6c,
  0xa8ab, 0xc941, 0xcb71, 0xcbac, 0xcba9, 0xcb7a, 0xcbaa, 0xcba7,
  0xcba1, 0xcb79, 0xa87b, 0xa876, 0xd644, 0xa8a0, 0xcba8, 0xcba0,
  0xcb76, 0xcb7e, 0xd669, 0xa873, 0xcbaf, 0xcb75, 0xcb77, 0xa8a8,
  0xcb70, 0xa870, 0xcb7d, 0xcba5, 0xcba6, 0xa877, 0xa8a5, 0xcb60,
  0xa8a7, 0xa875, 0xa8a3, 0xcba4, 0xcb62, 0xa8a6, 0xd653, 0xc945,
  0xa871, 0xa87a, 0xcb7b, 0xcb63, 0xa8a1, 0xa8a9, 0xcbae, 0xa8a4,
  0xa8aa, 0xcb74, 0xa8ac, 0xcb7c, 0xa8af, 0xa8ae, 0xcb7f, 0xcbab,
  0xa874, 0xcb73, 0xd641, 0xaaf0, 0xab4e, 0xd658, 0xd656, 0xd65a,
  0xd647, 0xd640, 0xd64b, 0xd64a, 0xab47, 0xaaf7, 0xd65b, 0xd652,
  0xab48, 0xaafb, 0xab4d, 0xd643, 0xab4f, 0xd642, 0xd654, 0xab49,
  0xd665, 0xd645, 0xaaf1, 0xaaf6, 0xab45, 0xd648, 0xd66b, 0xd657,
  0xd66a, 0xd66c, 0xd65e, 0xd66f, 0xd651, 0xd668, 0xd66e, 0xab44,
  0xd659, 0xaaf4, 0xaaf5, 0xab4c, 0xab4a, 0xd66d, 0xab4b, 0xd65c,
  0xb64e, 0xd664, 0xd65d, 0xd646, 0xaaf3, 0xab46, 0xaafa, 0xd655,
  0xd650, 0xb668, 0xd1ec, 0xd1e8, 0xb65f, 0xb65d, 0xb64a, 0xd1ee,
  0xd1ef, 0xb656, 0xd1e5, 0xb658, 0xd1f7, 0xd24a, 0xb649, 0xd1fa,
  0xd1fd, 0xb66a, 0xd1ed, 0xd1f1, 0xb669, 0xb655, 0xb66e, 0xb643,
  0xd1e1, 0xd1f3, 0xd1fb, 0xb642, 0xb644, 0xd248, 0xd1f0, 0xd24d,
  0xb65c, 0xb654, 0xd24f, 0xd1e7, 0xd1f6, 0xd1e2, 0xd249, 0xb653,
  0xb64b, 0xb651, 0xd1f9, 0xd1ff, 0xd1fe, 0xb65e, 0xd1e3, 0xd1e0,
  0xb645, 0xd1ea, 0xd24b, 0xb647, 0xd1fc, 0xb665, 0xb66f, 0xd1eb,
  0xb652, 0xb650, 0xb66b, 0xd1f5, 0xb66c, 0xd65f, 0xd1f4, 0xb66d,
  0xd24c, 0xb648, 0xd1f8, 0xb65a, 0xd1e4, 0xb65b, 0xb659, 0xb641,
  0xb646, 0xddea, 0xd24e, 0xd1e6, 0xddf1, 0xb640, 0xb14c, 0xb657,
  0xb0e3, 0xddfb, 0xb0f1, 0xdde7, 0xb0e6, 0xb0ea, 0xde44, 0xb0e0,
  0xb0fc, 0xb0e1, 0xb0f8, 0xde40, 0xde49, 0xddfc, 0xb0f7, 0xb0f9,
  0xddf0, 0xb0e9, 0xde47, 0xde4e, 0xb0e5, 0xddfa, 0xb0fa, 0xde58,
  0xde5b, 0xb0e8, 0xde45, 0xb0f4, 0xddf6, 0xdde0, 0xdde3, 0xb0f0,
  0xddff, 0xddf4, 0xddfe, 0xb0f6, 0xb149, 0xdde2, 0xdde5, 0xdde4,
  0xdde6, 0xb0e7, 0xddf5, 0xb0f5, 0xb14f, 0xddf7, 0xde5e, 0xde46,
  0xb0eb, 0xde5c, 0xb0ff, 0xb0fd, 0xde5a, 0xb0e2, 0xde4c, 0xddf9,
  0xddf3, 0xb14a, 0xde48, 0xde4f, 0xddfd, 0xb14e, 0xde42, 0xde41,
  0xde59, 0xb0e4, 0xde4d, 0xb14b, 0xde4a, 0xb0fe, 0xb0fb, 0xde4b,
  0xb148, 0xddf8, 0xd1e9, 0xde5d, 0xde43, 0xde5f, 0xdde1, 0xb14d,
  0xda6c, 0xda6d, 0xda4b, 0xb3b0, 0xda52, 0xda44, 0xda47, 0xb3ca,
  0xda65, 0xb3cf, 0xda53, 0xda4e, 0xb3c5, 0xb3b3, 0xda5f, 0xda45,
  0xda46, 0xda6e, 0xb3b5, 0xda67, 0xda6f, 0xb3cc, 0xda5a, 0xb3c1,
  0xb3c6, 0xb3c8, 0xda64, 0xb3b4, 0xda58, 0xda41, 0xda54, 0xda68,
  0xb3c0, 0xb3b6, 0xda59, 0xda40, 0xb3c9, 0xb3ce, 0xda5d, 0xda57,
  0xda69, 0xda4a, 0xda5c, 0xb3b1, 0xda56, 0xb3c4, 0xb3cd, 0xda43,
  0xb3b2, 0xda48, 0xda5e, 0xda6a, 0xb0f3, 0xbebd, 0xda5b, 0xe661,
  0xda55, 0xda6b, 0xb3cb, 0xda42, 0xb3b7, 0xb3c7, 0xb8fd, 0xda49,
  0xda50, 0xda51, 0xe6a7, 0xbea0, 0xe670, 0xe6a9, 0xbeaf, 0xe663,
  0xbea2, 0xbe7a, 0xe660, 0xe6bd, 0xbebc, 0xe67c, 0xe6ae, 0xe67e,
  0xe6be, 0xe6a2, 0xbe78, 0xbeac, 0xe25e, 0xbea3, 0xbe70, 0xe662,
  0xe6a3, 0xbeae, 0xe6a6, 0xe6b5, 0xe678, 0xe673, 0xe6bb, 0xe6a1,
  0xbe71, 0xe671, 0xbe7b, 0xbe79, 0xbea5, 0xe677, 0xe67a, 0xe675,
  0xe6bf, 0xe6ba, 0xe6b8, 0xbe77, 0xe6b4, 0xbe73, 0xbeaa, 0xe67d,
  0xe1f7, 0xe674, 0xbe75, 0xbea1, 0xbea4, 0xbe76, 0xe6a8, 0xe679,
  0xbea7, 0xe6aa, 0xbea9, 0xbeab, 0xbe7e, 0xe6a4, 0xe6ac, 0xe67f,
  0xbea8, 0xe6bc, 0xe6b9, 0xe676, 0xe6a5, 0xbe74, 0xb8d2, 0xe6ab,
  0xe1f4, 0xe6a0, 0xe67b, 0xe249, 0xe243, 0xb8ef, 0xe240, 0xe254,
  0xb8e9, 0xe246, 0xe242, 0xb8e2, 0xe24b, 0xb8ea, 0xe25f, 0xedfd,
  0xb8fe, 0xb8ff, 0xe259, 0xe24e, 0xe253, 0xb8e0, 0xb8ee, 0xe25a,
  0xe256, 0xe26d, 0xe258, 0xe244, 0xb8eb, 0xb8e4, 0xb8fc, 0xb8e1,
  0xe241, 0xe6af, 0xe245, 0xe252, 0xb8e5, 0xb8e6, 0xe26c, 0xb8ed,
  0xe25b, 0xe1f6, 0xe251, 0xc4d2, 0xe247, 0xb8ec, 0xe248, 0xb8e8,
  0xe1f1, 0xbea6, 0xe24c, 0xe257, 0xe24f, 0xe24d, 0xb8e7, 0xe255,
  0xe1f3, 0xe25c, 0xe25d, 0xe250, 0xe24a, 0xb8e3, 0xedfe, 0xbb44,
  0xbaf3, 0xee4d, 0xede6, 0xbb4c, 0xedfa, 0xbb45, 0xbb4e, 0xedf8,
  0xe942, 0xedf6, 0xee4f, 0xedf7, 0xede4, 0xedf5, 0xee49, 0xee4b,
  0xbaf0, 0xee48, 0xbb49, 0xbb47, 0xbb4a, 0xedf3, 0xbb4b, 0xedf4,
  0xede0, 0xedff, 0xedf0, 0xbb48, 0xbb4f, 0xbaf1, 0xbb4d, 0xedfc,
  0xe1f0, 0xede1, 0xede2, 0xee4c, 0xedf9, 0xede7, 0xe943, 0xee4e,
  0xede3, 0xedf1, 0xe95c, 0xc4ee, 0xc4da, 0xc4d6, 0xe95e, 0xe954,
  0xe95a, 0xc4d4, 0xc4d7, 0xc4ec, 0xe957, 0xe95f, 0xc4d1, 0xe95b,
  0xe958, 0xe956, 0xc4ef, 0xc4d0, 0xc4ed, 0xe959, 0xc4e9, 0xc4d3,
  0xc4e8, 0xc4d5, 0xe955, 0xe95d, 0xebfa, 0xc67c, 0xebf9, 0xebfb,
  0xc662, 0xebff, 0xebfe, 0xebe3, 0xedfb, 0xebe2, 0xc67d, 0xebe6,
  0xc660, 0xebf5, 0xc663, 0xebe1, 0xebe0, 0xebfc, 0xc67e, 0xc67f,
  0xebfd, 0xc775, 0xf652, 0xf668, 0xc774, 0xf651, 0xc77b, 0xc77e,
  0xf66a, 0xc77a, 0xc779, 0xf653, 0xf66c, 0xf66f, 0xf66e, 0xf66b,
  0xebf8, 0xf650, 0xc778, 0xf669, 0xf665, 0xf66d, 0xf050, 0xc067,
  0xf06d, 0xc066, 0xf065, 0xf052, 0xf051, 0xf053, 0xf06f, 0xf068,
  0xf069, 0xf06a, 0xf056, 0xc064, 0xf06e, 0xf06b, 0xf064, 0xf06c,
  0xf1de, 0xf1d9, 0xf1d5, 0xf1d4, 0xf1db, 0xf1da, 0xf1d8, 0xc0e4,
  0xc175, 0xf2e6, 0xf2e5, 0xf2e4, 0xf2e7, 0xc174, 0xf3e8, 0xf3e9,
  0xfca2, 0xc1f9, 0xfca0, 0xfcbd, 0xfca3, 0xfcf8, 0xc25a, 0xc268,
  0xfdae, 0xfd61, 0xfdaf, 0xfddd, 0xfddc, 0xa0f8, 0xa2ca, 0xce4c,
  0xcf53, 0xac52, 0xac6f, 0xcf52, 0xac6d, 0xac6c, 0xc955, 0xc957,
  0xc958, 0xc95f, 0xc959, 0xaea9, 0xaeaf, 0xc95b, 0xaeae, 0xc95e,
  0xc95d, 0xaeac, 0xc95a, 0xc95c, 0xaea8, 0xc954, 0xcba2, 0xcbbe,
  0xa8ba, 0xcbbb, 0xa8a2, 0xa8bf, 0xa8b9, 0xa8bb, 0xa8be, 0xcbbf,
  0xcbbc, 0xa8bc, 0xcbb9, 0xcbb8, 0xcba3, 0xa8b8, 0xa8bd, 0xcbbd,
  0xd67a, 0xd675, 0xd674, 0xab5d, 0xab41, 0xd663, 0xd67b, 0xd676,
  0xab5c, 0xd661, 0xd67f, 0xd666, 0xd678, 0xd67c, 0xab40, 0xab42,
  0xd677, 0xd667, 0xd660, 0xd67e, 0xd679, 0xd671, 0xd67d, 0xab43,
  0xb660, 0xd243, 0xd25d, 0xd241, 0xd255, 0xd247, 0xd25a, 0xb664,
  0xd245, 0xde56, 0xd25f, 0xb661, 0xd25e, 0xd25b, 0xd257, 0xd242,
  0xd259, 0xb667, 0xb666, 0xd254, 0xd240, 0xd244, 0xd256, 0xd25c,
  0xd258, 0xd246, 0xb145, 0xb144, 0xde68, 0xb142, 0xde54, 0xde6f,
  0xde55, 0xb141, 0xde6d, 0xde53, 0xde52, 0xb147, 0xde6e, 0xde51,
  0xde57, 0xb146, 0xde50, 0xde6c, 0xb140, 0xde69, 0xda7d, 0xda7a,
  0xda74, 0xdaac, 0xb3d7, 0xda66, 0xb3df, 0xda77, 0xb3da, 0xdaaf,
  0xb3c3, 0xda70, 0xda60, 0xda73, 0xda61, 0xb3d1, 0xda75, 0xb3c2,
  0xdaae, 0xb3d9, 0xda7c, 0xb3d4, 0xda71, 0xda62, 0xda7b, 0xda7f,
  0xda63, 0xb3dc, 0xb3d5, 0xb3db, 0xb3de, 0xb3d6, 0xb3dd, 0xda78,
  0xb3d8, 0xb143, 0xda76, 0xda7e, 0xda79, 0xe6cc, 0xbeb9, 0xe6b0,
  0xe6ce, 0xe6b2, 0xbebb, 0xe6b3, 0xe6cf, 0xe6b7, 0xe6b1, 0xbeb8,
  0xe6cd, 0xe6b6, 0xbeba, 0xbebf, 0xe6c9, 0xbebe, 0xe26a, 0xe269,
  0xe27d, 0xe267, 0xe261, 0xb8f9, 0xe26b, 0xe263, 0xe260, 0xe266,
  0xe27c, 0xb8fa, 0xe265, 0xe262, 0xb8f8, 0xe26e, 0xe268, 0xb8fb,
  0xe26f, 0xe27f, 0xe264, 0xee47, 0xbb5c, 0xee58, 0xee5e, 0xbb46,
  0xee44, 0xee41, 0xee40, 0xee45, 0xbb58, 0xbb5b, 0xee4a, 0xee5b,
  0xee5c, 0xbb42, 0xbb41, 0xee5d, 0xee43, 0xbb5f, 0xee5f, 0xbb40,
  0xbb43, 0xee42, 0xbb5d, 0xee46, 0xee59, 0xbb5e, 0xee5a, 0xee55,
  0xbb59, 0xc4ea, 0xc4e3, 0xe951, 0xe96f, 0xe96d, 0xc4e7, 0xc4e4,
  0xc4eb, 0xe953, 0xc4e1, 0xc4e6, 0xc4e5, 0xe96c, 0xe950, 0xe952,
  0xc4e0, 0xc67a, 0xebf6, 0xc679, 0xc678, 0xebf0, 0xc67b, 0xebf7,
  0xebf4, 0xf661, 0xebf1, 0xf660, 0xc777, 0xf666, 0xf667, 0xf664,
  0xc776, 0xc061, 0xf067, 0xf066, 0xf1d1, 0xf1d6, 0xc0e7, 0xf1d7,
  0xf2e1, 0xf2e0, 0xf3eb, 0xfcbc, 0xfcfb, 0xfdb1, 0xc274, 0xfdcb,
  0xa0fb, 0xaeab, 0xaeaa, 0xa8b5, 0xc4e2, 0xa0fa, 0xaea5, 0xab5f,
  0xb3d0, 0xa0f5, 0xb663, 0xbeb5, 0xcd6f, 0xcbba, 0xd670, 0xe6c8,
  0xc4fd, 0xa0f4, 0xaea4, 0xcbb5, 0xcbb4, 0xde6b, 0xb15d, 0xdaa9,
  0xb3d3, 0xe6cb, 0xb8f5, 0xc771, 0xa0f7, 0xde6a, 0xa0f6, 0xa2c4,
  0xce4f, 0xa2c5, 0xac68, 0xac69, 0xac6e, 0xcf6d, 0xaea7, 0xaea6,
  0xc956, 0xcbb7, 0xcbb0, 0xa8b7, 0xcbb6, 0xa8b4, 0xcbb1, 0xa8b6,
  0xd6af, 0xd6ac, 0xd673, 0xab5e, 0xd250, 0xd253, 0xb662, 0xd251,
  0xd252, 0xb15f, 0xb67d, 0xb15c, 0xde66, 0xde67, 0xde65, 0xde64,
  0xde61, 0xdaab, 0xdaa8, 0xdaa4, 0xdaa5, 0xdaaa, 0xbeb4, 0xe6c4,
  0xe6c5, 0xbeb7, 0xe6ca, 0xe27e, 0xe279, 0xb8f4, 0xee54, 0xee57,
  0xf67f, 0xc770, 0xf67c, 0xf67d, 0xf663, 0xf662, 0xc0e6, 0xf061,
  0xf2e3, 0xfcfa, 0xa0f1, 0xcda8, 0xa1ca, 0xcdab, 0xce4e, 0xce49,
  0xcf6b, 0xcf6f, 0xcf6c, 0xaea1, 0xcf68, 0xac6a, 0xcf6e, 0xac6b,
  0xcf6a, 0xcf69, 0xc952, 0xcbb3, 0xc950, 0xc969, 0xaea0, 0xaebd,
  0xc968, 0xc96c, 0xc96f, 0xc951, 0xaea2, 0xc953, 0xaea3, 0xc96e,
  0xc96d, 0xcbcf, 0xa8b0, 0xa8b3, 0xcbc8, 0xcbb2, 0xcbc9, 0xcbcd,
  0xa8b1, 0xcbce, 0xcbcc, 0xd6a5, 0xd6a8, 0xd6aa, 0xab55, 0xab5a,
  0xab58, 0xd6a9, 0xd6a4, 0xab59, 0xab5b, 0xd6ab, 0xd26a, 0xd6ae,
  0xd6a7, 0xd26f, 0xd26b, 0xd268, 0xde63, 0xde74, 0xd265, 0xd26e,
  0xde60, 0xb679, 0xb67e, 0xd26c, 0xd269, 0xb678, 0xb67f, 0xb67c,
  0xd26d, 0xd264, 0xde7d, 0xde7a, 0xb159, 0xde7b, 0xde7e, 0xb15b,
  0xde78, 0xde62, 0xde7c, 0xde79, 0xde7f, 0xb158, 0xde75, 0xb15e,
  0xb3d2, 0xdaa0, 0xdaa1, 0xdaa7, 0xb3ef, 0xb3ec, 0xdaa3, 0xdaa6,
  0xe6c7, 0xbeb6, 0xb3ed, 0xdabd, 0xdaa2, 0xe6c0, 0xe6c6, 0xb8f7,
  0xbeb1, 0xe6c1, 0xe27b, 0xb8f6, 0xe278, 0xe273, 0xe270, 0xe276,
  0xe277, 0xe27a, 0xe275, 0xe274, 0xe271, 0xe2ac, 0xee52, 0xee51,
  0xee50, 0xbb5a, 0xee56, 0xee6c, 0xee6d, 0xee53, 0xe969, 0xe968,
  0xc4fc, 0xc4ff, 0xe96e, 0xc674, 0xebf3, 0xc675, 0xc773, 0xc7ac,
  0xc060, 0xf063, 0xf060, 0xf1d0, 0xf2e2, 0xc177, 0xf3e5, 0xf3ea,
  0xf3e4, 0xa1c5, 0xcbcb, 0xab54, 0xb67b, 0xd267, 0xa1c4, 0xcdaa,
  0xa0f0, 0xce48, 0xcf61, 0xcf67, 0xcf66, 0xcf65, 0xac65, 0xcf64,
  0xc960, 0xaebe, 0xc966, 0xc96a, 0xc967, 0xc96b, 0xaeb8, 0xc964,
  0xaebf, 0xaebc, 0xaeb9, 0xc961, 0xc965, 0xa8cf, 0xa8c8, 0xcbc3,
  0xcbc0, 0xcbc1, 0xa8b2, 0xcbd8, 0xcbc6, 0xa8cc, 0xd6a2, 0xcbdf,
  0xcbdd, 0xa8c9, 0xcbc5, 0xcbde, 0xcbc7, 0xcbd9, 0xcbdc, 0xcbc4,
  0xa8cd, 0xcbdb, 0xcbca, 0xa8ce, 0xd6b9, 0xd6a6, 0xd6bb, 0xd6a3,
  0xd6b4, 0xd6b7, 0xd6a1, 0xd6b5, 0xd6b8, 0xd6be, 0xd6ba, 0xab52,
  0xab50, 0xd6bc, 0xd6a0, 0xd6bd, 0xd6b6, 0xd6bf, 0xab53, 0xcbc2,
  0xab57, 0xab51, 0xd275, 0xd260, 0xd266, 0xd261, 0xd27e, 0xd279,
  0xd27d, 0xb676, 0xd278, 0xd27f, 0xd262, 0xb674, 0xd263, 0xb67a,
  0xb677, 0xd27c, 0xd274, 0xab56, 0xb675, 0xd27a, 0xd27b, 0xb671,
  0xde73, 0xdeac, 0xb16d, 0xdeaa, 0xdea4, 0xdeaf, 0xb157, 0xdeab,
  0xdea8, 0xb156, 0xb16c, 0xb16f, 0xdea5, 0xb155, 0xde70, 0xde76,
  0xdeae, 0xde77, 0xb152, 0xde71, 0xdea9, 0xdea7, 0xb154, 0xb153,
  0xb151, 0xb150, 0xb15a, 0xb3e4, 0xdaba, 0xb3e5, 0xdab6, 0xdabc,
  0xdab1, 0xdabf, 0xdabe, 0xdab0, 0xdab7, 0xdab5, 0xdab4, 0xdab8,
  0xdab9, 0xdab3, 0xb3e8, 0xdabb, 0xb3e7, 0xb3e9, 0xb3e6, 0xb3e1,
  0xb3ea, 0xb3eb, 0xe6c3, 0xbeb3, 0xbeb0, 0xe6de, 0xb8f1, 0xbeb2,
  0xbecc, 0xe6d9, 0xb3ee, 0xbecd, 0xe6dd, 0xe6df, 0xe6c2, 0xe6dc,
  0xe2a6, 0xe2a7, 0xe2aa, 0xb94d, 0xee6f, 0xb94c, 0xe2ab, 0xb8f3,
  0xe2a5, 0xe2a8, 0xe2af, 0xe2a4, 0xe2ae, 0xe2a9, 0xb8f0, 0xe964,
  0xee6b, 0xee68, 0xee6a, 0xe96b, 0xbb57, 0xee6e, 0xbb55, 0xbb51,
  0xbb56, 0xee69, 0xee65, 0xbb54, 0xe960, 0xc4f8, 0xc677, 0xc4fb,
  0xc4fe, 0xe967, 0xe965, 0xe966, 0xe963, 0xc4f9, 0xe961, 0xe96a,
  0xf44f, 0xf448, 0xf678, 0xf44d, 0xf062, 0xf44b, 0xc7af, 0xf449,
  0xc676, 0xf44c, 0xf44e, 0xf44a, 0xf67b, 0xf679, 0xc7ae, 0xf67e,
  0xc063, 0xc0e0, 0xf2fc, 0xc0e1, 0xf2fe, 0xf2fd, 0xf2ff, 0xc1dd,
  0xfcbf, 0xa1c7, 0xc963, 0xd6b1, 0xd6b0, 0xb670, 0xdab2, 0xbb50,
  0xc7a9, 0xc176, 0xfcbe, 0xa1c6, 0xc962, 0xa66d, 0xcbda, 0xcbd5,
  0xd6b3, 0xd6b2, 0xb673, 0xb6ac, 0xdea6, 0xdacf, 0xdacc, 0xdacd,
  0xe6d8, 0xe6db, 0xe6da, 0xbecf, 0xe2a0, 0xe2a1, 0xee64, 0xbb53,
  0xbb52, 0xe97f, 0xe962, 0xe97d, 0xe97c, 0xf444, 0xf445, 0xc671,
  0xf67a, 0xf1d3, 0xa1c1, 0xa8cb, 0xb6af, 0xdace, 0xa1c0, 0xd6cd,
  0xb6ae, 0xb16e, 0xb169, 0xa1c3, 0xa1c2, 0xce4b, 0xac67, 0xac64,
  0xa8ca, 0xcbd4, 0xdea1, 0xa1dd, 0xa1dc, 0xa1df, 0xa1de, 0xac66,
  0xac61, 0xcf63, 0xcf60, 0xaebb, 0xc97f, 0xc97d, 0xc97c, 0xcbd7,
  0xcbd6, 0xa8c6, 0xa8c4, 0xa8c7, 0xa8c5, 0xab6d, 0xab69, 0xab6e,
  0xd6cc, 0xab6f, 0xab6c, 0xd6cf, 0xb6ab, 0xd276, 0xd277, 0xb6a9,
  0xb6a8, 0xb16b, 0xb168, 0xdea3, 0xdea0, 0xb6aa, 0xb3e0, 0xdac8,
  0xb3e3, 0xdac9, 0xe6d5, 0xe2a3, 0xb94f, 0xee67, 0xe97e, 0xc7ab,
  0xc7a8, 0xc171, 0xa1d9, 0xc97e, 0xb6a5, 0xe6d4, 0xbece, 0xcf62,
  0xcf7d, 0xc979, 0xaeb5, 0xaeb4, 0xaeba, 0xa8c2, 0xa8dd, 0xa8c0,
  0xa8c3, 0xcbd1, 0xcbd0, 0xa8c1, 0xd6ce, 0xab65, 0xab64, 0xb6a6,
  0xd6c4, 0xab63, 0xab61, 0xd6c7, 0xd6c8, 0xab66, 0xab67, 0xab68,
  0xd6c5, 0xd6ca, 0xd6c9, 0xab60, 0xd6cb, 0xab6b, 0xab6a, 0xb6a1,
  0xd2ac, 0xd2af, 0xb6a0, 0xd271, 0xd273, 0xd2a9, 0xd2ae, 0xd270,
  0xb6a4, 0xb6a7, 0xdebb, 0xb166, 0xb167, 0xdebd, 0xb165, 0xdebe,
  0xb161, 0xdeb9, 0xb160, 0xdebc, 0xb16a, 0xb164, 0xdeb8, 0xdebf,
  0xdea2, 0xdadf, 0xdaca, 0xb3fd, 0xb3fe, 0xb3ff, 0xb3fa, 0xb3fb,
  0xdade, 0xdadc, 0xdac7, 0xdac3, 0xdac0, 0xb3f9, 0xdadd, 0xdac1,
  0xdad9, 0xdac6, 0xb3f8, 0xb3e2, 0xb3fc, 0xdac4, 0xe6d6, 0xbeca,
  0xe6d2, 0xbecb, 0xe6d1, 0xbec8, 0xdac5, 0xdac2, 0xe6d3, 0xbec5,
  0xe6ed, 0xe6d0, 0xe6d7, 0xe2bc, 0xe2b8, 0xe2ba, 0xe2be, 0xe2bf,
  0xe2bd, 0xb948, 0xb94e, 0xb945, 0xb944, 0xe2b9, 0xb94b, 0xe2a2,
  0xb94a, 0xbec9, 0xe2bb, 0xb949, 0xee61, 0xee66, 0xee7e, 0xee60,
  0xee7f, 0xee62, 0xbb6d, 0xee7c, 0xbb6c, 0xbb6f, 0xee7d, 0xee63,
  0xc4f5, 0xe979, 0xc4fa, 0xe97a, 0xe978, 0xe97b, 0xc4f4, 0xf440,
  0xc6ac, 0xf443, 0xc670, 0xf442, 0xc673, 0xf441, 0xf45d, 0xf447,
  0xc7aa, 0xf675, 0xc7a5, 0xc062, 0xf446, 0xc07d, 0xc0e3, 0xf1d2,
  0xc173, 0xf2f9, 0xc170, 0xf3e7, 0xc1f8, 0xc1fb, 0xfdc1, 0xa8dc,
  0xcbd3, 0xb163, 0xb162, 0xa1d8, 0xa2c7, 0xce4a, 0xcf7c, 0xac60,
  0xaeb7, 0xa8df, 0xa8de, 0xa8d9, 0xd2ab, 0xd6c6, 0xab62, 0xb6a3,
  0xd2a8, 0xdeb5, 0xb17c, 0xdeba, 0xb17d, 0xdad8, 0xb947, 0xe2b6,
  0xe2b5, 0xe2b4, 0xe2b7, 0xe975, 0xf45c, 0xf07c, 0xf07d, 0xf2f8,
  0xa1db, 0xc978, 0xab7d, 0xb17f, 0xdadb, 0xe6ec, 0xb946, 0xee79,
  0xf45f, 0xf07f, 0xa1da, 0xaeb6, 0xa8da, 0xcbd2, 0xa8d5, 0xa8db,
  0xa8d8, 0xd6c1, 0xab7c, 0xab7f, 0xab7e, 0xb6bd, 0xd2aa, 0xb6a2,
  0xdeb4, 0xb6bc, 0xb17e, 0xdada, 0xb3f5, 0xb3f4, 0xbec4, 0xbec7,
  0xb941, 0xbb69, 0xee78, 0xbb6e, 0xe974, 0xc4f7, 0xf45e, 0xf07e,
  0xa1d5, 0xac63, 0xc975, 0xc97a, 0xaeb1, 0xc97b, 0xaeb0, 0xc974,
  0xcbe8, 0xa8d6, 0xa8d7, 0xcbea, 0xcbeb, 0xa8d2, 0xa8d3, 0xa8d4,
  0xcbec, 0xcbef, 0xcbee, 0xa8ed, 0xcbed, 0xa8d1, 0xcbe9, 0xa8d0,
  0xd6c2, 0xd6de, 0xd6dc, 0xd6dd, 0xd6d9, 0xd6d8, 0xd6db, 0xd6c3,
  0xd6c0, 0xab78, 0xab7b, 0xd6da, 0xd6df, 0xd2bd, 0xd6d5, 0xab7a,
  0xab79, 0xd2a7, 0xd2a4, 0xd2a6, 0xd2a1, 0xd2a3, 0xd2a0, 0xd2bf,
  0xb6b8, 0xb6bf, 0xb6bb, 0xd2a5, 0xb6ba, 0xd2bc, 0xb6b9, 0xd2a2,
  0xb6be, 0xdeb1, 0xdeb3, 0xdeb7, 0xdeb6, 0xdeb2, 0xdecc, 0xdecf,
  0xdeb0, 0xdecd, 0xb179, 0xdad6, 0xdaed, 0xdad5, 0xdad1, 0xdaec,
  0xdad0, 0xb3f7, 0xbc4e, 0xb3f0, 0xdad4, 0xdad7, 0xbec3, 0xbc4b,
  0xb3f3, 0xbc49, 0xb3f1, 0xdad2, 0xbc48, 0xdad3, 0xbc4c, 0xb3f6,
  0xbc4f, 0xdaef, 0xe6eb, 0xe6e5, 0xbc4d, 0xe6ee, 0xbec1, 0xe6e4,
  0xbec0, 0xe6ea, 0xe6ef, 0xe6e8, 0xe6e7, 0xbec6, 0xe6e9, 0xb943,
  0xe2b2, 0xe2b3, 0xb95c, 0xb942, 0xe2b1, 0xb940, 0xe2b0, 0xb95d,
  0xee70, 0xeeac, 0xee73, 0xee7b, 0xee77, 0xee74, 0xee7a, 0xbb6b,
  0xbb6a, 0xbb68, 0xee75, 0xee76, 0xee71, 0xbb65, 0xc54d, 0xe9ae,
  0xc4f1, 0xe976, 0xc4f3, 0xc54c, 0xc4f0, 0xe9af, 0xe971, 0xc4f6,
  0xe9ac, 0xe977, 0xe973, 0xe970, 0xf458, 0xc6a9, 0xc6a8, 0xc6af,
  0xc6ae, 0xf459, 0xf676, 0xc7a4, 0xf674, 0xf677, 0xf079, 0xf07a,
  0xf078, 0xf07b, 0xf1ed, 0xc0e2, 0xf3e6, 0xfcb9, 0xc1fa, 0xfcf5,
  0xfcf4, 0xc26b, 0xa1d4, 0xa8ec, 0xdece, 0xdaee, 0xa1d7, 0xac62,
  0xaeb3, 0xcbe5, 0xcbe4, 0xab75, 0xdec9, 0xb178, 0xbc4a, 0xc54f,
  0xe9a9, 0xf671, 0xf075, 0xa1d6, 0xc9ac, 0xc977, 0xc971, 0xc973,
  0xc970, 0xc976, 0xaeb2, 0xa8ef, 0xcbff, 0xcbe0, 0xcbe7, 0xcbfc,
  0xa8e9, 0xa8e8, 0xcbfd, 0xcbe2, 0xcbe3, 0xcbe6, 0xcbe1, 0xcbfe,
  0xa8ee, 0xab71, 0xaba9, 0xabae, 0xd6ec, 0xd6d6, 0xd6d4, 0xabac,
  0xd2b4, 0xab77, 0xd6d3, 0xd6ef, 0xd6e9, 0xd6ed, 0xd6d7, 0xabaf,
  0xd6d2, 0xd6d0, 0xab74, 0xd6e8, 0xaba8, 0xd6ee, 0xab70, 0xd6d1,
  0xab73, 0xab76, 0xb6b4, 0xd2b7, 0xd2be, 0xd2b8, 0xd2ba, 0xd2b5,
  0xd2bb, 0xb6b7, 0xd2b6, 0xd2b9, 0xdec5, 0xb17b, 0xdedd, 0xdec8,
  0xdedc, 0xdecb, 0xdeca, 0xdec2, 0xdec3, 0xdec6, 0xb6b5, 0xb17a,
  0xdec4, 0xdec1, 0xb175, 0xdec0, 0xdec7, 0xdae3, 0xdaff, 0xbc43,
  0xe6fd, 0xbc5c, 0xdafd, 0xdae0, 0xdae5, 0xdae7, 0xdae6, 0xdae9,
  0xbc40, 0xbc41, 0xbc45, 0xdaea, 0xbc42, 0xbc5d, 0xdaeb, 0xdae4,
  0xdafc, 0xbc47, 0xbc46, 0xdae2, 0xdae8, 0xe6ff, 0xbedd, 0xe6f9,
  0xdae1, 0xe6fb, 0xbed9, 0xe6fa, 0xe6fe, 0xbedc, 0xe6e2, 0xbede,
  0xe6e1, 0xe6fc, 0xe6f8, 0xe6e3, 0xbc44, 0xe6e6, 0xbedf, 0xe6e0,
  0xb959, 0xe2cc, 0xb955, 0xb95b, 0xbec2, 0xe2c5, 0xe2c4, 0xb95e,
  0xe2ca, 0xe2c7, 0xb958, 0xb95f, 0xe2ce, 0xe2cd, 0xe2c8, 0xe2cf,
  0xb954, 0xe2c9, 0xe2cb, 0xb95a, 0xbb67, 0xeea5, 0xeeaf, 0xeeab,
  0xeea1, 0xeea0, 0xeea4, 0xeea7, 0xeeaa, 0xeea9, 0xbb61, 0xbb64,
  0xeeae, 0xeea8, 0xbb66, 0xeea6, 0xc54b, 0xe9a7, 0xe9a8, 0xc548,
  0xc54e, 0xe9a1, 0xc549, 0xe9a5, 0xe9a4, 0xe9ab, 0xe9a0, 0xf45b,
  0xc54a, 0xe9aa, 0xe9a3, 0xe9a6, 0xf457, 0xf45a, 0xc6ab, 0xf456,
  0xf450, 0xf451, 0xf455, 0xf454, 0xf6ae, 0xc7a7, 0xf673, 0xf6af,
  0xf670, 0xf6a9, 0xf6ac, 0xf077, 0xf070, 0xf074, 0xc07c, 0xf076,
  0xf071, 0xf073, 0xc07f, 0xc079, 0xc07e, 0xf1ec, 0xf1ee, 0xf1ef,
  0xf2fb, 0xfcb8, 0xfcf7, 0xa1d1, 0xcf7f, 0xaecd, 0xc9ae, 0xaecc,
  0xaecf, 0xc9af, 0xcbf5, 0xcbfa, 0xa8eb, 0xa8e4, 0xa8e5, 0xa8ea,
  0xcbf9, 0xcbfb, 0xcbf8, 0xd6e5, 0xabaa, 0xd6e1, 0xd6e6, 0xd6e7,
  0xd6eb, 0xabab, 0xaba7, 0xaba0, 0xaba3, 0xd6ea, 0xd6e4, 0xaba1,
  0xaba6, 0xaba4, 0xaba5, 0xd2cf, 0xd2cd, 0xd2b1, 0xb6b6, 0xd2b0,
  0xb6b1, 0xd2b3, 0xd2b2, 0xd2cc, 0xb6b0, 0xded8, 0xded9, 0xdede,
  0xdedf, 0xdafb, 0xbc5f, 0xdafe, 0xdaf8, 0xbc5e, 0xbc59, 0xdaf9,
  0xe74c, 0xe6f4, 0xe6f7, 0xbeda, 0xbed8, 0xbedb, 0xe74e, 0xe74f,
  0xe6f3, 0xe6f0, 0xe6f1, 0xe6f6, 0xe74d, 0xe6f5, 0xe2c6, 0xe2dd,
  0xe2c3, 0xe2c0, 0xe2c1, 0xe2c2, 0xeea3, 0xbb60, 0xc545, 0xe9bd,
  0xc544, 0xe9a2, 0xf452, 0xf453, 0xc6aa, 0xf6a8, 0xc7a6, 0xf0ac,
  0xc1ac, 0xf2fa, 0xfcba, 0xfcbb, 0xcda5, 0xa8e7, 0xa8e6, 0xd2ce,
  0xbc5b, 0xa1d0, 0xac7f, 0xac7c, 0xac7d, 0xc9a9, 0xaec9, 0xaece,
  0xa8e3, 0xcbf7, 0xcbf0, 0xcbf6, 0xa8e1, 0xa8e0, 0xcbf4, 0xcbf1,
  0xabb8, 0xd6fe, 0xd6f8, 0xd6f9, 0xabbf, 0xd6e2, 0xabbd, 0xaba2,
  0xabbe, 0xabbc, 0xabb9, 0xd6ff, 0xd6e0, 0xd6e3, 0xd6fc, 0xd6fd,
  0xd2cb, 0xd2ca, 0xd2c8, 0xd2c9, 0xb6b3, 0xb170, 0xdedb, 0xded5,
  0xded7, 0xb171, 0xb177, 0xdeda, 0xb176, 0xded4, 0xb174, 0xdb4c,
  0xdafa, 0xdaf7, 0xdaf3, 0xbc57, 0xdaf1, 0xdaf6, 0xdaf5, 0xdaf4,
  0xbc55, 0xdb4d, 0xbc5a, 0xbc51, 0xbc56, 0xbc54, 0xdaf0, 0xe744,
  0xe745, 0xe749, 0xbed5, 0xe74a, 0xe74b, 0xbed4, 0xb953, 0xe2df,
  0xb952, 0xb956, 0xb950, 0xb957, 0xb951, 0xeea2, 0xbb7d, 0xeebc,
  0xeebd, 0xe748, 0xbb7f, 0xbb7c, 0xbb63, 0xbb62, 0xe9b8, 0xe9be,
  0xc547, 0xe9b9, 0xe9bb, 0xe9bf, 0xe9bc, 0xf46d, 0xc6a7, 0xc6a5,
  0xc6a4, 0xf6ab, 0xf6aa, 0xc7a0, 0xc7a1, 0xf0ae, 0xf0a9, 0xf0af,
  0xf2f5, 0xf2f4, 0xa1d3, 0xce45, 0xac7e, 0xc9a8, 0xaecb, 0xaec8,
  0xc9ab, 0xd44d, 0xa8e2, 0xcbf3, 0xa8fd, 0xabbb, 0xd6f5, 0xd6fb,
  0xd6f1, 0xabba, 0xd6fa, 0xd6f6, 0xd6f4, 0xd6f7, 0xd2c5, 0xd2c7,
  0xb6b2, 0xd2c4, 0xb6cd, 0xb1af, 0xb1ac, 0xb173, 0xded6, 0xdb49,
  0xbc50, 0xbc53, 0xdb4e, 0xdb4f, 0xe747, 0xbed6, 0xbed7, 0xe746,
  0xe741, 0xb96c, 0xb96d, 0xeeb8, 0xe2de, 0xe2d8, 0xe2d9, 0xeeb9,
  0xeebf, 0xeebb, 0xeebe, 0xbb7e, 0xe9ba, 0xc546, 0xe9b5, 0xe9b4,
  0xc6a6, 0xc6a1, 0xc078, 0xc1dc, 0xa1d2, 0xd44c, 0xd6f0, 0xabb5,
  0xb7b7, 0xb7b4, 0xb1a9, 0xded0, 0xb1ae, 0xded1, 0xdb48, 0xbed1,
  0xe740, 0xbed0, 0xc07b, 0xf0a8, 0xa2c6, 0xaeca, 0xc9aa, 0xa8ff,
  0xa8fc, 0xd44f, 0xd44e, 0xd74d, 0xd74f, 0xabb4, 0xd749, 0xd74a,
  0xd748, 0xd74b, 0xd74e, 0xd6f3, 0xabb7, 0xd745, 0xd74c, 0xd2de,
  0xb6cb, 0xd2d1, 0xb6ce, 0xd2d8, 0xb6ca, 0xb6cc, 0xd2dd, 0xd2d0,
  0xd2dc, 0xd2c3, 0xb6c8, 0xb6cf, 0xd2d9, 0xd2da, 0xb6c9, 0xd2d5,
  0xb6c5, 0xd2d4, 0xd2c2, 0xd2db, 0xd2d7, 0xd2df, 0xd2c0, 0xd2c6,
  0xd2d6, 0xded2, 0xdee9, 0xdeed, 0xdeeb, 0xb1aa, 0xd2c1, 0xdeec,
  0xb1a8, 0xded3, 0xb1a1, 0xdeef, 0xb1a6, 0xdeee, 0xb1a0, 0xb1a5,
  0xb1a3, 0xb1a4, 0xb1a7, 0xb1ab, 0xdee8, 0xbc6c, 0xdb5d, 0xdb5e,
  0xdb4a, 0xdb41, 0xdb4b, 0xbc6e, 0xdb47, 0xdb45, 0xbc6f, 0xdb42,
  0xdb43, 0xdb46, 0xdb40, 0xdb44, 0xbeec, 0xdb5f, 0xbc52, 0xdb5c,
  0xe750, 0xbee5, 0xe755, 0xbeea, 0xe743, 0xe75d, 0xbeed, 0xe758,
  0xe759, 0xe75a, 0xbee8, 0xe75f, 0xe75c, 0xbee9, 0xbed2, 0xe75e,
  0xbeef, 0xe754, 0xe756, 0xe75b, 0xe742, 0xbeee, 0xb964, 0xbed3,
  0xe751, 0xe2d4, 0xb96f, 0xe2d6, 0xb96e, 0xb968, 0xe2d3, 0xe2db,
  0xbeeb, 0xe2d1, 0xe2d5, 0xbc6d, 0xb965, 0xb969, 0xb96b, 0xb96a,
  0xbb7b, 0xe2d0, 0xe2da, 0xb967, 0xe2d7, 0xeecd, 0xeeb6, 0xeec8,
  0xbb79, 0xeeb0, 0xbb75, 0xeece, 0xeeb7, 0xeeba, 0xeecb, 0xc55c,
  0xbb74, 0xeecf, 0xeeb5, 0xbb7a, 0xeeb1, 0xbb76, 0xeeb4, 0xeeb3,
  0xbb77, 0xeecc, 0xeec9, 0xe9c6, 0xe9c1, 0xe9b1, 0xe9ce, 0xe9cc,
  0xc542, 0xe9c5, 0xeeb2, 0xe9b2, 0xe9c4, 0xc543, 0xe9b3, 0xe9b0,
  0xe9ca, 0xe9c9, 0xe9cb, 0xe9b7, 0xe9c7, 0xc541, 0xe9c8, 0xe9c3,
  0xe9cf, 0xc55d, 0xc540, 0xe9cd, 0xe9b6, 0xe9c0, 0xbb78, 0xf46e,
  0xf46c, 0xf46a, 0xc6bd, 0xf468, 0xf469, 0xc6bf, 0xf467, 0xc6bc,
  0xf466, 0xf465, 0xc6a3, 0xf464, 0xf46f, 0xc6a2, 0xc6a0, 0xf6a6,
  0xf46b, 0xf461, 0xf6a5, 0xc7bf, 0xc7bd, 0xf6a7, 0xf6a1, 0xf6a4,
  0xc7bc, 0xc7a3, 0xc7a2, 0xc7be, 0xc075, 0xf0a7, 0xf0a4, 0xf0aa,
  0xf0ab, 0xf0a5, 0xc07a, 0xc074, 0xc0fd, 0xf1e8, 0xf1e9, 0xf2f7,
  0xf2f1, 0xf2f3, 0xf2f0, 0xf2f6, 0xc1ae, 0xc1af, 0xc1de, 0xc1df,
  0xc1d9, 0xf3e0, 0xf3e1, 0xfcf6, 0xfcb5, 0xfcf1, 0xc255, 0xc254,
  0xfd60, 0xc273, 0xa2c1, 0xc9a5, 0xd448, 0xd44b, 0xd449, 0xa8fe,
  0xd44a, 0xd445, 0xd444, 0xd744, 0xd742, 0xd740, 0xabb6, 0xd746,
  0xd741, 0xd743, 0xd747, 0xb6c4, 0xd2d3, 0xb6c6, 0xd2ed, 0xb6c7,
  0xd2d2, 0xdee5, 0xb1a2, 0xdee7, 0xdeea, 0xd2ec, 0xb1bd, 0xdee4,
  0xdb5b, 0xbc69, 0xdb59, 0xbc68, 0xdb58, 0xbc6b, 0xbee4, 0xe76c,
  0xe753, 0xe76d, 0xbee7, 0xbee6, 0xe752, 0xe2d2, 0xe2ed, 0xb966,
  0xe2ef, 0xe2ec, 0xa66c, 0xeec7, 0xeec6, 0xeeca, 0xeec5, 0xbb71,
  0xbb70, 0xeec4, 0xc55a, 0xc55e, 0xc555, 0xc559, 0xc55b, 0xc55f,
  0xc558, 0xc6be, 0xe9c2, 0xf6a3, 0xf6a0, 0xf0a6, 0xc077, 0xc076,
  0xf34c, 0xf1eb, 0xf34d, 0xfcf0, 0xfda9, 0xa2c0, 0xac79, 0xc9a4,
  0xaec5, 0xa8fb, 0xd441, 0xa8f9, 0xd447, 0xa8f4, 0xa8f8, 0xa8f7,
  0xa8f5, 0xd446, 0xa8fa, 0xabb2, 0xabb3, 0xd757, 0xabca, 0xd75e,
  0xd754, 0xabce, 0xd75f, 0xd755, 0xd75b, 0xabcf, 0xabc9, 0xd758,
  0xabb0, 0xd759, 0xabc5, 0xabc8, 0xabc4, 0xabcb, 0xd75c, 0xd75d,
  0xd75a, 0xabcd, 0xabb1, 0xabcc, 0xd2fd, 0xd2e4, 0xb1b8, 0xd2e5,
  0xb6c2, 0xb6db, 0xb6de, 0xb6d4, 0xb6d5, 0xb6d9, 0xd2ef, 0xd2e8,
  0xd2e9, 0xb6dd, 0xd2eb, 0xd2e2, 0xb6dc, 0xd2ee, 0xd2e1, 0xd2e0,
  0xb6df, 0xd2e7, 0xb6da, 0xb6c0, 0xb6d8, 0xd2ea, 0xb6c1, 0xd2e6,
  0xd2e3, 0xdef6, 0xdeff, 0xb1bf, 0xdef4, 0xdefb, 0xdee3, 0xdefa,
  0xb1b9, 0xdee2, 0xdee6, 0xbc61, 0xdef9, 0xb1bc, 0xdef7, 0xb1b5,
  0xb1b7, 0xdee0, 0xb1b4, 0xdefd, 0xb1be, 0xdef5, 0xdefc, 0xdef8,
  0xdefe, 0xb1bb, 0xdee1, 0xb1b6, 0xb6c3, 0xb1ba, 0xb1b1, 0xbc65,
  0xdb50, 0xdb52, 0xdb6c, 0xdb68, 0xdb56, 0xdb54, 0xbc67, 0xdb6d,
  0xdb69, 0xdb51, 0xdb55, 0xdb5a, 0xdb6f, 0xdb57, 0xdb53, 0xbc66,
  0xbc64, 0xdb6b, 0xbc6a, 0xdb6e, 0xe77f, 0xbee3, 0xe767, 0xb975,
  0xe779, 0xbefc, 0xe775, 0xbefa, 0xe768, 0xe778, 0xe76f, 0xe77a,
  0xe76b, 0xbef3, 0xbef6, 0xe77b, 0xe77d, 0xbee0, 0xbef8, 0xbef9,
  0xbefe, 0xbef4, 0xe76e, 0xbef7, 0xe77c, 0xbefb, 0xbee1, 0xe77e,
  0xbee2, 0xbefd, 0xbef5, 0xe765, 0xe76a, 0xe769, 0xe761, 0xe764,
  0xe760, 0xbef0, 0xe774, 0xbeff, 0xe763, 0xe762, 0xe766, 0xbef1,
  0xe2ea, 0xb97d, 0xb974, 0xb978, 0xe2e9, 0xb97f, 0xb97b, 0xe2fd,
  0xb961, 0xe2e5, 0xb979, 0xe2e6, 0xe2eb, 0xb97e, 0xb97a, 0xe2e8,
  0xb97c, 0xe2e2, 0xb963, 0xe2e3, 0xe2e0, 0xb977, 0xe17f, 0xb960,
  0xe2e1, 0xe2ee, 0xb976, 0xe2e7, 0xb962, 0xe2e4, 0xbbaf, 0xbbaa,
  0xbb73, 0xeed5, 0xeec2, 0xeed6, 0xeede, 0xeed4, 0xbba5, 0xbbac,
  0xeec1, 0xeedf, 0xeed1, 0xeed8, 0xeed7, 0xeec3, 0xeedb, 0xbbae,
  0xeed9, 0xbbab, 0xbba8, 0xeedd, 0xeedc, 0xeec0, 0xeeda, 0xbba9,
  0xeed3, 0xeed0, 0xe9d7, 0xe9db, 0xc552, 0xe9dd, 0xc554, 0xc564,
  0xe9d1, 0xc56c, 0xc550, 0xe9de, 0xc569, 0xc56a, 0xe9d3, 0xc551,
  0xe9d8, 0xc568, 0xe9ed, 0xe9d0, 0xe9dc, 0xc56d, 0xc557, 0xc565,
  0xe9d5, 0xc56e, 0xe9df, 0xc553, 0xe9d2, 0xc56f, 0xc556, 0xe9d4,
  0xc56b, 0xe9da, 0xe9d6, 0xf463, 0xf479, 0xc6b4, 0xf47a, 0xc6b9,
  0xc6b8, 0xf462, 0xf47b, 0xf47c, 0xc6b7, 0xc6ba, 0xf460, 0xc6bb,
  0xf47e, 0xf478, 0xc6b5, 0xf47f, 0xf47d, 0xf6b5, 0xc7ba, 0xc7b5,
  0xc7b9, 0xc7b8, 0xf6b9, 0xf6bf, 0xf6bb, 0xc7b7, 0xf6ba, 0xf6bd,
  0xf6a2, 0xf6be, 0xf6bc, 0xc7bb, 0xf6b8, 0xf0a1, 0xc073, 0xc070,
  0xf0a0, 0xf0a2, 0xf0a3, 0xc0ac, 0xf1e6, 0xf1e5, 0xf1e4, 0xf1ea,
  0xf1e7, 0xc0ff, 0xf1e1, 0xc0fc, 0xf34f, 0xc1d8, 0xc1da, 0xf3e3,
  0xc1db, 0xfcb4, 0xfd4d, 0xfd4f, 0xfcf3, 0xfd4c, 0xc261, 0xa2c3,
  0xa8f6, 0xd662, 0xabc7, 0xb6d7, 0xdef1, 0xdef0, 0xeed2, 0xc567,
  0xe9ec, 0xc6b6, 0xf6b7, 0xf6b4, 0xc0af, 0xf1e0, 0xf34e, 0xc1f5,
  0xce44, 0xaec4, 0xac78, 0xd440, 0xd76d, 0xd756, 0xd752, 0xd750,
  0xabc6, 0xd753, 0xd751, 0xd2fc, 0xdef3, 0xdf4d, 0xdb64, 0xdb67,
  0xbc63, 0xbc62, 0xdb65, 0xdb66, 0xdb6a, 0xbc60, 0xbf4d, 0xbc7d,
  0xe777, 0xb971, 0xe2fc, 0xb970, 0xbba4, 0xeeef, 0xeeed, 0xeeec,
  0xe9e9, 0xe9ee, 0xe9ef, 0xf6b6, 0xc7b4, 0xf6b1, 0xf349, 0xc1f4,
  0xfcb7, 0xa2c2, 0xaec6, 0xaec7, 0xd442, 0xa8f1, 0xd443, 0xd76f,
  0xabc1, 0xd2ff, 0xd76c, 0xb6d1, 0xd2f8, 0xd2fe, 0xd2f9, 0xb6d6,
  0xdf4f, 0xdf4e, 0xdf4c, 0xbc7e, 0xdb60, 0xdb61, 0xdb63, 0xbc7f,
  0xbc7c, 0xe2ff, 0xe2f9, 0xb973, 0xe2fe, 0xeeee, 0xbba7, 0xf474,
  0xf475, 0xc7b6, 0xf6b0, 0xc7b0, 0xc7b1, 0xf0bd, 0xf1e3, 0xc0fe,
  0xa2dd, 0xd45d, 0xa8f0, 0xd768, 0xabc3, 0xd769, 0xd76e, 0xabc0,
  0xd2f6, 0xd2f0, 0xd2fb, 0xd2fa, 0xb6d0, 0xd2f5, 0xb6d3, 0xd2f1,
  0xd2f4, 0xd2f7, 0xb6d2, 0xb1b3, 0xb1b2, 0xdf49, 0xdb62, 0xdb7d,
  0xe773, 0xbf4e, 0xbf4c, 0xbf4f, 0xe776, 0xe771, 0xe770, 0xe2f4,
  0xe2f7, 0xb9ac, 0xe2fa, 0xe2fb, 0xe2f5, 0xe2f8, 0xbba0, 0xeee9,
  0xbba6, 0xbba1, 0xe9eb, 0xc566, 0xe9e8, 0xeba5, 0xf477, 0xf476,
  0xc6b1, 0xc6b0, 0xc561, 0xf6b3, 0xf6b2, 0xf0bc, 0xc0ae, 0xa2dc,
  0xa2df, 0xa8f3, 0xaec1, 0xabc2, 0xd45c, 0xb1cd, 0xa2de, 0xa94c,
  0xd45f, 0xd45e, 0xa94d, 0xa94f, 0xa2d9, 0xd459, 0xabdc, 0xd76b,
  0xabde, 0xabdd, 0xabdf, 0xd34c, 0xb6ed, 0xd34d, 0xd2f3, 0xdb7c,
  0xe7ac, 0xb9af, 0xbba3, 0xeeeb, 0xeee8, 0xe9ea, 0xf1e2, 0xa2d8,
  0xcf7e, 0xc9a7, 0xa94e, 0xd458, 0xd765, 0xabd9, 0xd76a, 0xabd8,
  0xd34e, 0xb6ef, 0xd34f, 0xd349, 0xb6ec, 0xdf4b, 0xdf4a, 0xdf48,
  0xb1cc, 0xbc79, 0xbc78, 0xbf48, 0xe7ae, 0xe7af, 0xbf49, 0xe2f6,
  0xe2f1, 0xeeea, 0xc57d, 0xc562, 0xc560, 0xc563, 0xc57c, 0xf471,
  0xc6b2, 0xc6b3, 0xf6cd, 0xf0bf, 0xc1a8, 0xc1a9, 0xa2db, 0xd5f6,
  0xbc7a, 0xb1cf, 0xbc7b, 0xbf4b, 0xa2da, 0xcda4, 0xa2d5, 0xa2d4,
  0xc9a6, 0xcf7b, 0xcf7a, 0xac7a, 0xcf79, 0xac7b, 0xac74, 0xcf78,
  0xac76, 0xac77, 0xcf75, 0xac75, 0xaedc, 0xaec2, 0xc9a0, 0xaec3,
  0xaede, 0xaed8, 0xaedf, 0xc9bd, 0xc9a1, 0xaedb, 0xaedd, 0xac71,
  0xaed9, 0xc9a2, 0xc9a3, 0xaec0, 0xd456, 0xa94a, 0xa945, 0xd450,
  0xd45a, 0xd457, 0xd46e, 0xd46c, 0xa944, 0xd46a, 0xa941, 0xd469,
  0xd451, 0xd454, 0xdf44, 0xd46f, 0xa949, 0xd468, 0xd45b, 0xd452,
  0xa94b, 0xa946, 0xd46d, 0xa942, 0xa940, 0xd455, 0xa947, 0xd453,
  0xa943, 0xa948, 0xd46b, 0xabd7, 0xabee, 0xabd5, 0xabdb, 0xd767,
  0xabd3, 0xabd6, 0xd761, 0xabd0, 0xd766, 0xd764, 0xd763, 0xabef,
  0xabed, 0xdf45, 0xd762, 0xd760, 0xabda, 0xabd4, 0xabd1, 0xabd2,
  0xabec, 0xd343, 0xb6e9, 0xd348, 0xd34a, 0xd345, 0xd35d, 0xd341,
  0xd347, 0xd340, 0xd35c, 0xb6e8, 0xb6e4, 0xd34b, 0xd342, 0xb6ea,
  0xb6eb, 0xd346, 0xd344, 0xb6ee, 0xb6e5, 0xb1c5, 0xdf5c, 0xdf42,
  0xb1c7, 0xdf47, 0xdbac, 0xb1c4, 0xdf43, 0xdf46, 0xb1c8, 0xb1c6,
  0xdf5d, 0xb1ca, 0xdf40, 0xbf4a, 0xb1cb, 0xdf41, 0xb1c1, 0xb1c9,
  0xb1ce, 0xdb7a, 0xdb78, 0xdb76, 0xdb7e, 0xdbaf, 0xdb75, 0xdb7f,
  0xbc76, 0xbcae, 0xdb70, 0xdb7b, 0xbc73, 0xbc71, 0xdb73, 0xbc74,
  0xbc75, 0xdb74, 0xbc70, 0xb1c0, 0xdb71, 0xdb79, 0xbc77, 0xbcac,
  0xbcaf, 0xbf41, 0xbf45, 0xbf40, 0xe7ab, 0xe7a8, 0xe7aa, 0xbf47,
  0xe7a9, 0xbf46, 0xe7a7, 0xe7a4, 0xe7a5, 0xbf44, 0xe34c, 0xe349,
  0xb9a5, 0xe34e, 0xb9aa, 0xb9ae, 0xb9a9, 0xb9a8, 0xe34d, 0xe2f3,
  0xb9ab, 0xe34f, 0xe2f0, 0xeee4, 0xeefe, 0xbbbc, 0xbbbd, 0xeee0,
  0xeee2, 0xeee7, 0xeee3, 0xeee5, 0xeefc, 0xbba2, 0xeefd, 0xeee1,
  0xeeff, 0xeee6, 0xc579, 0xe9e5, 0xe9e3, 0xc575, 0xc577, 0xc57a,
  0xc57b, 0xc578, 0xc57e, 0xe9e4, 0xe9e1, 0xc57f, 0xe9e0, 0xc574,
  0xe9e6, 0xe9e7, 0xc6cd, 0xc6cc, 0xf4ac, 0xf470, 0xf473, 0xf6cf,
  0xf6cc, 0xc7b3, 0xf0b9, 0xc0a9, 0xf0be, 0xf1fd, 0xf348, 0xc1ab,
  0xfd4e, 0xfd49, 0xc1d5, 0xa2d7, 0xaeda, 0xdf5f, 0xbf43, 0xc576,
  0xe9e2, 0xa2d6, 0xabe8, 0xabe9, 0xdf5e, 0xeef9, 0xa2d1, 0xa95d,
  0xdf59, 0xdf58, 0xdf5b, 0xbf42, 0xbbbf, 0xa2d0, 0xaed5, 0xd465,
  0xabeb, 0xd77d, 0xb6e7, 0xdf5a, 0xbca9, 0xbf5d, 0xbbbe, 0xc571,
  0xc6cf, 0xf0b8, 0xa2d3, 0xaed4, 0xabea, 0xd35f, 0xb1c3, 0xbf5c,
  0xe7a6, 0xe348, 0xa2d2, 0xb1c2, 0xdbae, 0xbf5f, 0xa2ed, 0xc9bc,
  0xd464, 0xa95c, 0xd77f, 0xabe7, 0xabe5, 0xabe4, 0xabe6, 0xd77c,
  0xd35a, 0xd359, 0xd35b, 0xb6e6, 0xb6e0, 0xb6e1, 0xd35e, 0xb6e3,
  0xd358, 0xdf55, 0xdf54, 0xdf57, 0xdbab, 0xdbaa, 0xdba8, 0xdba5,
  0xbca8, 0xdba9, 0xbf5e, 0xe347, 0xe34b, 0xe344, 0xe346, 0xe345,
  0xe34a, 0xeef8, 0xeefb, 0xeefa, 0xbbb9, 0xbbb8, 0xe9fc, 0xe9fd,
  0xe9ff, 0xf4ae, 0xf4af, 0xf6c9, 0xf6c8, 0xf6ce, 0xc0a8, 0xf0bb,
  0xf0ba, 0xf34b, 0xf3e2, 0xfcb6, 0xa2ec, 0xac70, 0xc570, 0xa2ef,
  0xd355, 0xdf56, 0xc24c, 0xce47, 0xce46, 0xce40, 0xa2ee, 0xce43,
  0xce41, 0xcfaf, 0xcfae, 0xcf76, 0xcfac, 0xacac, 0xacaf, 0xcf71,
  0xcf77, 0xcf74, 0xcf70, 0xac73, 0xcf73, 0xd467, 0xc9bb, 0xaed1,
  0xc9b8, 0xc9ba, 0xaed6, 0xc9b1, 0xaed2, 0xc9bf, 0xc9cd, 0xc9cb,
  0xaeeb, 0xc9ce, 0xaeee, 0xc9b4, 0xc9b2, 0xc9cc, 0xc9b9, 0xaeef,
  0xaed0, 0xc9b7, 0xaee9, 0xaeea, 0xaeec, 0xaed7, 0xc9b3, 0xc9b5,
  0xc9c8, 0xaee4, 0xaee8, 0xaeed, 0xc9b0, 0xabe1, 0xc9b6, 0xaed3,
  0xaee5, 0xc9be, 0xc9cf, 0xc9c9, 0xa96f, 0xa951, 0xa969, 0xa96c,
  0xd47c, 0xd479, 0xa950, 0xd466, 0xa95b, 0xa96d, 0xa96e, 0xa968,
  0xd4af, 0xd47a, 0xa958, 0xd4ac, 0xa954, 0xa95a, 0xa95f, 0xd462,
  0xd473, 0xd47e, 0xd47b, 0xd4a8, 0xa96b, 0xd470, 0xa953, 0xd475,
  0xd4a9, 0xd478, 0xd474, 0xd471, 0xd460, 0xd4ae, 0xd476, 0xd461,
  0xd47d, 0xa952, 0xa957, 0xa95e, 0xa955, 0xa959, 0xa96a, 0xd463,
  0xd7a8, 0xa956, 0xd477, 0xca4c, 0xd7a5, 0xabf7, 0xd77b, 0xd7ae,
  0xd770, 0xd7bf, 0xd7a7, 0xd773, 0xd7a4, 0xd775, 0xd771, 0xd7b8,
  0xabf0, 0xd7a0, 0xd7a9, 0xabe0, 0xd7be, 0xd779, 0xd7a1, 0xabf1,
  0xabfa, 0xd77e, 0xabf8, 0xabf9, 0xabf4, 0xd7a6, 0xabfc, 0xabf5,
  0xd47f, 0xdf51, 0xd7ab, 0xd777, 0xabf6, 0xd776, 0xd7ac, 0xabf3,
  0xd778, 0xd7a2, 0xd7a3, 0xd7bb, 0xabfe, 0xabfd, 0xd7b9, 0xd7bd,
  0xd7aa, 0xd7af, 0xabfb, 0xabff, 0xd77a, 0xabe3, 0xd7bc, 0xabe2,
  0xd774, 0xd353, 0xd36d, 0xd368, 0xd374, 0xb6f1, 0xb6ff, 0xd350,
  0xb6f0, 0xb6f3, 0xd365, 0xd362, 0xd378, 0xd36f, 0xd364, 0xb74d,
  0xd37a, 0xd37f, 0xb6f7, 0xb6f5, 0xd363, 0xd367, 0xd351, 0xb6e2,
  0xd36c, 0xd354, 0xb6fa, 0xb6f4, 0xd36b, 0xd36e, 0xb6f9, 0xd37e,
  0xb6fc, 0xd369, 0xd377, 0xd361, 0xd366, 0xb6fd, 0xb6f6, 0xb6fe,
  0xd357, 0xd352, 0xd37d, 0xd37b, 0xb74c, 0xd356, 0xd36a, 0xd360,
  0xb6fb, 0xd375, 0xd37c, 0xd379, 0xb6f8, 0xdf61, 0xdf6d, 0xb1da,
  0xdf70, 0xdfaa, 0xdfa7, 0xb1d8, 0xdf65, 0xdfae, 0xdf64, 0xdf7a,
  0xb1ef, 0xdf7e, 0xb1d2, 0xdf79, 0xdf50, 0xdfa9, 0xb1e5, 0xdfac,
  0xdf78, 0xdfa1, 0xdf7d, 0xdbc5, 0xdfa2, 0xb1eb, 0xdf63, 0xdf77,
  0xb1e4, 0xb1d9, 0xdf7f, 0xdfa0, 0xdf66, 0xdf69, 0xdf62, 0xdf6e,
  0xdf6c, 0xb1dd, 0xdfa8, 0xdf67, 0xdfa5, 0xdfa4, 0xb1d5, 0xb1d0,
  0xb1d4, 0xb1ec, 0xdf73, 0xb1d7, 0xdf7b, 0xdf6b, 0xb1df, 0xdf53,
  0xdfaf, 0xdfa6, 0xdf68, 0xb1ed, 0xdfbd, 0xdf7c, 0xdf60, 0xb1dc,
  0xb1e8, 0xdf71, 0xb1ea, 0xdf75, 0xb1d1, 0xb1db, 0xb1d3, 0xb1de,
  0xb1e9, 0xdf74, 0xdf6a, 0xdf76, 0xdf6f, 0xdfab, 0xdfa3, 0xdf52,
  0xdbca, 0xdbd0, 0xbc58, 0xdbc1, 0xdbc7, 0xdbb8, 0xbca4, 0xdbc8,
  0xdbd4, 0xdbcc, 0xbcbc, 0xdbd5, 0xdbb2, 0xb1ee, 0xdbc2, 0xdbcd,
  0xdbdb, 0xbcbd, 0xbca5, 0xdba7, 0xdbbf, 0xdbc6, 0xdbce, 0xdbd1,
  0xdbcb, 0xbcbb, 0xdbda, 0xbca0, 0xdbc4, 0xdbdc, 0xdbbb, 0xdbdd,
  0xdbec, 0xdbbc, 0xdbdf, 0xdbd2, 0xdba6, 0xb1d6, 0xdbb4, 0xdbb5,
  0xbca2, 0xdbb1, 0xdbb3, 0xdbc0, 0xdbd3, 0xbcbf, 0xbcbe, 0xdbbd,
  0xbca6, 0xdbb9, 0xdbd7, 0xbcb9, 0xbca1, 0xbca3, 0xbcb8, 0xdbed,
  0xdbde, 0xdbc3, 0xdbb6, 0xdbb7, 0xbca7, 0xdba1, 0xbcaa, 0xdbc9,
  0xdba0, 0xdbcf, 0xdbba, 0xdbd6, 0xbcab, 0xdbbe, 0xdba2, 0xdbd8,
  0xdba3, 0xbf6d, 0xe7de, 0xe7cf, 0xe7a1, 0xe7c7, 0xbf55, 0xe7b6,
  0xe7c8, 0xbf56, 0xe7b3, 0xbf54, 0xe7a2, 0xe7c0, 0xe7a3, 0xe7cc,
  0xe7a0, 0xe7b2, 0xe7c5, 0xe7cb, 0xe7b7, 0xe7b8, 0xe7be, 0xe7b9,
  0xe7ca, 0xe7df, 0xe7b1, 0xbf57, 0xe7ba, 0xe7c6, 0xbf50, 0xe7bb,
  0xe7bd, 0xe7cd, 0xbf6c, 0xbf58, 0xbf53, 0xe7b5, 0xe7bf, 0xbf5a,
  0xdbd9, 0xbf5b, 0xe7ce, 0xbf59, 0xbf6e, 0xbf51, 0xe7c9, 0xe7b4,
  0xe7bc, 0xe7c1, 0xe7b0, 0xbf6f, 0xe7dd, 0xbf52, 0xe7c2, 0xe7c4,
  0xe7c3, 0xe7dc, 0xe37e, 0xe379, 0xe36a, 0xe36b, 0xe36f, 0xb9b9,
  0xb9a1, 0xe37b, 0xe378, 0xdba4, 0xe352, 0xe36e, 0xe350, 0xe37d,
  0xe36c, 0xe37a, 0xe357, 0xe355, 0xe369, 0xe363, 0xe364, 0xb9bb,
  0xe342, 0xe360, 0xb9ba, 0xdbb0, 0xe356, 0xe35f, 0xe358, 0xe376,
  0xe351, 0xe35e, 0xe35c, 0xe343, 0xb9bd, 0xe368, 0xb9a2, 0xb9be,
  0xe36d, 0xe365, 0xb9a4, 0xe375, 0xe371, 0xb9a6, 0xe35a, 0xe366,
  0xe362, 0xe359, 0xe374, 0xb9bf, 0xb9bc, 0xe341, 0xb9b8, 0xe37f,
  0xe35b, 0xe367, 0xe35d, 0xe353, 0xe354, 0xb9a0, 0xb9a3, 0xe361,
  0xe370, 0xe377, 0xe37c, 0xe340, 0xb9a7, 0xef44, 0xef4d, 0xef4e,
  0xbbb6, 0xef48, 0xeef4, 0xef4c, 0xef4a, 0xbbb5, 0xbbb1, 0xbbbb,
  0xeef6, 0xef41, 0xef4b, 0xeef1, 0xef58, 0xef42, 0xeef5, 0xea4b,
  0xeef3, 0xbbba, 0xef47, 0xef59, 0xbbb2, 0xef5c, 0xeef0, 0xef49,
  0xef45, 0xef4f, 0xef5b, 0xef5e, 0xef5d, 0xbbb4, 0xbbb7, 0xbbb3,
  0xeef7, 0xef5a, 0xbbb0, 0xef40, 0xef46, 0xef43, 0xea5e, 0xea4d,
  0xea48, 0xea5f, 0xea49, 0xe9f6, 0xea4c, 0xc5af, 0xe9f9, 0xea40,
  0xea42, 0xe9fe, 0xc5ac, 0xea5c, 0xea44, 0xc5a5, 0xea5d, 0xea4f,
  0xc5a7, 0xe9f4, 0xef5f, 0xea47, 0xea4a, 0xe9f8, 0xea58, 0xc5a9,
  0xc5a8, 0xe9fa, 0xea45, 0xea59, 0xea46, 0xe9f0, 0xc5aa, 0xc5ae,
  0xea41, 0xe9f3, 0xea5b, 0xe9f5, 0xea4e, 0xea43, 0xe9f7, 0xe9f1,
  0xc6c6, 0xe9fb, 0xc5a4, 0xc6c9, 0xc573, 0xc5ab, 0xc6c5, 0xf4be,
  0xf4a4, 0xf4a9, 0xf4a7, 0xf4b9, 0xf4b5, 0xf4ba, 0xc6c7, 0xc6c4,
  0xf4a6, 0xf4b4, 0xf4a3, 0xf4ab, 0xf4a5, 0xf4aa, 0xf4a0, 0xf4bf,
  0xf4a8, 0xf4a1, 0xf4bc, 0xc6ca, 0xf4a2, 0xc6c8, 0xf4bd, 0xc6ce,
  0xc6cb, 0xf6d8, 0xf4b8, 0xc7cf, 0xf6c0, 0xf6dc, 0xf6c4, 0xf6c1,
  0xf6d9, 0xc7cd, 0xf6d4, 0xf6df, 0xf6c7, 0xf6d7, 0xf6de, 0xc7ce,
  0xc7c9, 0xf6da, 0xf6c6, 0xc7b2, 0xc7cc, 0xf6cb, 0xf6c3, 0xf6c5,
  0xf6d5, 0xf6db, 0xf6ca, 0xf6c2, 0xf0b3, 0xc7c8, 0xf6dd, 0xc0aa,
  0xc0a4, 0xc0ab, 0xf0ce, 0xf0b6, 0xf0b4, 0xf0b0, 0xf0b7, 0xf0b2,
  0xf0cc, 0xc0a7, 0xc0a1, 0xf0cd, 0xc0a0, 0xc0a6, 0xf0cf, 0xc0a5,
  0xc0f9, 0xf1fc, 0xf1fa, 0xc0fb, 0xf0b1, 0xf1fb, 0xf1f0, 0xf1f9,
  0xf1f6, 0xf1f7, 0xf0b5, 0xf1f8, 0xf4bb, 0xf1f3, 0xf1fe, 0xf1f5,
  0xf1f1, 0xf1ff, 0xf347, 0xc0f8, 0xf1f4, 0xf3f9, 0xf346, 0xf344,
  0xf34a, 0xf345, 0xf341, 0xc1d4, 0xf3ff, 0xf3fd, 0xf3f8, 0xf3fe,
  0xf3fb, 0xc1d7, 0xf3fc, 0xfcb1, 0xfd48, 0xfd4b, 0xfd4a, 0xfdca,
  0xfdb0, 0xce42, 0xaee7, 0xa965, 0xd7b5, 0xd7ba, 0xb44d, 0xb74f,
  0xd371, 0xd376, 0xb1e7, 0xbcb5, 0xbcba, 0xbcb4, 0xe7d9, 0xe373,
  0xef55, 0xef57, 0xef54, 0xc5a6, 0xea5a, 0xf4b7, 0xfda8, 0xa2e9,
  0xc9c4, 0xc9c7, 0xc9c5, 0xc9ca, 0xaee6, 0xd4a4, 0xd4aa, 0xd4ab,
  0xa964, 0xa966, 0xa967, 0xd4a5, 0xd7c9, 0xd7cc, 0xd7b2, 0xb44c,
  0xd7cf, 0xb44b, 0xd7b1, 0xd7c6, 0xd7c0, 0xd7b0, 0xb44e, 0xd7c3,
  0xd7c4, 0xd7b6, 0xd7cd, 0xd7c7, 0xd7cb, 0xd7ce, 0xb445, 0xd7c1,
  0xd7b3, 0xd7ca, 0xd7b4, 0xb44a, 0xb449, 0xd7c8, 0xd7c5, 0xd7b7,
  0xb448, 0xb44f, 0xb741, 0xd3a8, 0xb746, 0xd3a5, 0xd3a6, 0xb745,
  0xb74b, 0xd373, 0xd3a4, 0xd3aa, 0xd3a9, 0xd3a1, 0xd3a0, 0xd3a2,
  0xd3bd, 0xd370, 0xb748, 0xd3af, 0xd3ac, 0xd3a3, 0xb74a, 0xd3ae,
  0xb744, 0xb749, 0xd3ab, 0xb740, 0xb747, 0xd3a7, 0xb1fc, 0xdfb2,
  0xdfb9, 0xb1e3, 0xdbea, 0xdfb0, 0xdfbc, 0xb1e1, 0xdfbb, 0xb1e2,
  0xdfb7, 0xdfb5, 0xb1ff, 0xb1e6, 0xdfbf, 0xdfb8, 0xb1fd, 0xdfbe,
  0xdfb3, 0xdfb1, 0xdfba, 0xdfb4, 0xdfb6, 0xb1e0, 0xdbe5, 0xdbe3,
  0xdbe9, 0xdbe7, 0xbcb7, 0xdbeb, 0xbccd, 0xbcb2, 0xbcb3, 0xdbe0,
  0xbccc, 0xbccf, 0xdbee, 0xdbfd, 0xbcce, 0xbcb0, 0xbcb1, 0xdbe1,
  0xbcc9, 0xdbef, 0xdbe8, 0xdbe2, 0xdbe6, 0xe7f9, 0xe7e4, 0xbcb6,
  0xbf67, 0xe7d0, 0xe7ff, 0xe7d3, 0xbf68, 0xe7d6, 0xe7e9, 0xe7d1,
  0xbf6a, 0xe7db, 0xe7fc, 0xbf65, 0xe7e3, 0xe7e2, 0xe7da, 0xbf60,
  0xe7eb, 0xe7ed, 0xe7ea, 0xe7d7, 0xe7fe, 0xe7e6, 0xe7e8, 0xe7d8,
  0xbf64, 0xe7e1, 0xbf61, 0xe7fd, 0xe7e7, 0xbf6b, 0xe7e5, 0xe7ef,
  0xbf69, 0xe7d4, 0xe7ec, 0xe7e0, 0xe7d2, 0xe7ee, 0xb9cc, 0xdbe4,
  0xe3bf, 0xe3b6, 0xe3bc, 0xe3a0, 0xe3a7, 0xb9cf, 0xe3a5, 0xbf66,
  0xe3ac, 0xb9cd, 0xe3aa, 0xb9b2, 0xe3a1, 0xe3a4, 0xe3b4, 0xe3b9,
  0xe3a3, 0xe3be, 0xb9b6, 0xe3a6, 0xe3b3, 0xe3af, 0xe3ae, 0xe3b7,
  0xb9b1, 0xe3b2, 0xb9b3, 0xe3cd, 0xe3bd, 0xe7d5, 0xe3bb, 0xe3a2,
  0xe3b5, 0xe3b8, 0xe3ab, 0xb9b4, 0xe3b0, 0xb9b7, 0xe3a9, 0xb9b0,
  0xef69, 0xe3ba, 0xe3b1, 0xef6c, 0xb9b5, 0xbbcd, 0xef66, 0xef6a,
  0xef68, 0xef6d, 0xef62, 0xbbc9, 0xef51, 0xef65, 0xef64, 0xef52,
  0xef53, 0xef61, 0xef6f, 0xef50, 0xef6e, 0xef63, 0xef56, 0xef60,
  0xef67, 0xbbcf, 0xbbcc, 0xbbce, 0xef6b, 0xf4c6, 0xea54, 0xc5bc,
  0xea50, 0xea57, 0xea6c, 0xea6a, 0xea51, 0xea7d, 0xc5a3, 0xea67,
  0xea52, 0xea66, 0xea6b, 0xea60, 0xea53, 0xc5be, 0xc5bf, 0xea6d,
  0xea63, 0xea55, 0xea61, 0xc5a1, 0xea69, 0xea6e, 0xea65, 0xea56,
  0xc5bd, 0xc5b9, 0xea6f, 0xea64, 0xc5b8, 0xea68, 0xc5a0, 0xc5a2,
  0xf4ca, 0xf4c8, 0xf4c1, 0xf4c4, 0xf4c0, 0xf4b3, 0xf4cb, 0xf4dc,
  0xea62, 0xf4cf, 0xc6c2, 0xe3a8, 0xf4b0, 0xf4c7, 0xf4c9, 0xf4cc,
  0xf4b1, 0xf4b6, 0xf4dd, 0xf4cd, 0xf4b2, 0xc6c0, 0xf4c5, 0xc6c1,
  0xc6c3, 0xf4ce, 0xf4c2, 0xf6d3, 0xf6d2, 0xc7c4, 0xf6d1, 0xc7cb,
  0xf6e9, 0xc7c7, 0xf6eb, 0xf6d6, 0xf4c3, 0xf6e5, 0xf6d0, 0xc7ca,
  0xf6ee, 0xf6e8, 0xf6ed, 0xf6ea, 0xf6ef, 0xf6ec, 0xc7c5, 0xf0c8,
  0xf0cb, 0xf0c5, 0xc0a3, 0xc0a2, 0xf0c4, 0xf0ca, 0xf0c9, 0xf24f,
  0xf248, 0xf24c, 0xc0f7, 0xf24e, 0xc0f4, 0xc0f5, 0xc0fa, 0xf249,
  0xf35c, 0xf342, 0xf343, 0xf24d, 0xf35d, 0xf24b, 0xf340, 0xf3f4,
  0xf3da, 0xf3fa, 0xc1d6, 0xf3f5, 0xf3f7, 0xfcb2, 0xc1f7, 0xfcb3,
  0xfcb0, 0xc1f6, 0xc257, 0xfd63, 0xfdaa, 0xfdab, 0xfda5, 0xa2e8,
  0xd4a7, 0xd7c2, 0xd7dd, 0xdfcd, 0xf24a, 0xfccd, 0xa2eb, 0xa961,
  0xd4a6, 0xd3bc, 0xb743, 0xdfcf, 0xdfcc, 0xb1fe, 0xbcc8, 0xe3cc,
  0xb9ce, 0xb9c9, 0xbbc8, 0xc1f1, 0xa2ea, 0xd4a1, 0xaee0, 0xd4a3,
  0xd4a0, 0xa960, 0xd7dc, 0xd7d5, 0xb444, 0xd7db, 0xd7d9, 0xd7d6,
  0xd7df, 0xd7de, 0xb447, 0xb443, 0xd7d1, 0xb440, 0xd7d7, 0xd7da,
  0xd7d8, 0xb446, 0xb441, 0xd7d4, 0xb75d, 0xd3bf, 0xb758, 0xd3cf,
  0xb759, 0xd3c9, 0xd3b5, 0xb75f, 0xd3ce, 0xd3be, 0xb75e, 0xd3b2,
  0xd3b6, 0xd3b0, 0xd3ba, 0xd3b3, 0xb742, 0xd3b7, 0xd3b4, 0xd3b8,
  0xd3cd, 0xd3b1, 0xd3b9, 0xd3bb, 0xb75c, 0xd3cc, 0xb1fb, 0xdfc0,
  0xdfc4, 0xdfc6, 0xdfcb, 0xdfc8, 0xdfce, 0xdfc7, 0xdfc1, 0xdfc5,
  0xdfca, 0xb1f9, 0xb1f8, 0xdfc2, 0xbcc0, 0xdbff, 0xdbf5, 0xdbfe,
  0xdbf9, 0xdbf4, 0xbcc2, 0xbcca, 0xbcc3, 0xdbfc, 0xdfc9, 0xbcc7,
  0xbcc5, 0xdbfa, 0xdbfb, 0xbcc4, 0xbcc6, 0xdbf8, 0xbccb, 0xbcc1,
  0xe7fb, 0xbf79, 0xe04f, 0xe04c, 0xe7f6, 0xbf7b, 0xe04d, 0xe7fa,
  0xe7f5, 0xbf63, 0xbf7d, 0xe7f0, 0xe7f8, 0xbf7f, 0xbf7c, 0xe7f4,
  0xe7f3, 0xe7f1, 0xbf7e, 0xe7f7, 0xdfc3, 0xbf62, 0xe3cf, 0xe3c4,
  0xb9cb, 0xe3c0, 0xb9c7, 0xe3c8, 0xe3ce, 0xe3c1, 0xb9c8, 0xe3c6,
  0xb9ca, 0xb9c5, 0xe3c9, 0xb9c4, 0xe3c7, 0xe3cb, 0xe3ca, 0xe3c5,
  0xbf78, 0xef7d, 0xef71, 0xbbc7, 0xef7a, 0xef74, 0xbbc5, 0xef7c,
  0xef78, 0xef75, 0xbbcb, 0xbbc4, 0xef76, 0xef7e, 0xef79, 0xef77,
  0xef7f, 0xef7b, 0xbbca, 0xea7f, 0xea7c, 0xc5ba, 0xea7a, 0xc5b4,
  0xc5bb, 0xea7e, 0xc5b7, 0xea79, 0xea78, 0xea75, 0xc5b5, 0xf4db,
  0xf4d4, 0xf4de, 0xf4d8, 0xf4d9, 0xf4da, 0xf4d5, 0xea7b, 0xf4df,
  0xc7c0, 0xf6e1, 0xf6e2, 0xf6fc, 0xf6e7, 0xf6e6, 0xf6e3, 0xf6fd,
  0xc7c3, 0xc7c1, 0xc7c6, 0xf6e0, 0xf6e4, 0xf0c7, 0xc0bd, 0xf0c6,
  0xf244, 0xc0f6, 0xf246, 0xc0f1, 0xf245, 0xf247, 0xc1a5, 0xf35f,
  0xc1aa, 0xf3f0, 0xf3f1, 0xf3f6, 0xfd45, 0xfd44, 0xfd46, 0xfd47,
  0xce5d, 0xa2e5, 0xa963, 0xd3c8, 0xb1fa, 0xdbf7, 0xc6dd, 0xf6ff,
  0xacae, 0xb75a, 0xb75b, 0xdfdd, 0xb1f5, 0xdfdf, 0xdfdc, 0xdbf6,
  0xbcdd, 0xe04e, 0xe04b, 0xe048, 0xe049, 0xe3c3, 0xe3dd, 0xe3c2,
  0xbbc1, 0xbbc6, 0xc5b6, 0xea74, 0xea76, 0xea77, 0xc6dc, 0xf6f9,
  0xf6fe, 0xf0c1, 0xc0bc, 0xc0f0, 0xf359, 0xf35e, 0xc256, 0xaca9,
  0xd4a2, 0xa962, 0xd3c5, 0xd3cb, 0xd3ca, 0xdfd9, 0xdfd8, 0xe44e,
  0xdfde, 0xdbf1, 0xe44c, 0xe44d, 0xe44f, 0xbcdc, 0xdbf3, 0xdbf0,
  0xe449, 0xe044, 0xe04a, 0xe045, 0xe3de, 0xe3dc, 0xe3df, 0xef70,
  0xea71, 0xea70, 0xc6df, 0xf6f8, 0xf0c0, 0xc0bf, 0xf241, 0xf358,
  0xc1a4, 0xf3f3, 0xfd41, 0xaca8, 0xa97c, 0xa97f, 0xd4bd, 0xd4bc,
  0xa97d, 0xb459, 0xb45f, 0xb45c, 0xb455, 0xb45d, 0xb454, 0xd7d0,
  0xb45b, 0xb45e, 0xb45a, 0xb458, 0xb442, 0xb752, 0xb754, 0xd3c1,
  0xb753, 0xb76d, 0xb757, 0xb756, 0xd3c7, 0xb755, 0xd3c6, 0xb750,
  0xd3c4, 0xb751, 0xb249, 0xb24b, 0xdfd5, 0xb248, 0xb1f4, 0xb1f0,
  0xbce9, 0xe444, 0xdfd7, 0xb1f3, 0xdfd0, 0xdfd3, 0xb24e, 0xdfed,
  0xdfef, 0xdfee, 0xdfda, 0xdfdb, 0xdfe9, 0xb24f, 0xdfec, 0xdfd2,
  0xb24d, 0xb1f6, 0xb24a, 0xdfd6, 0xdfd1, 0xdfd4, 0xb24c, 0xb1f1,
  0xb1f7, 0xe445, 0xbcd2, 0xbcd7, 0xbcd8, 0xbce8, 0xbcdb, 0xbcdf,
  0xbcec, 0xbcd3, 0xbced, 0xbcda, 0xbcd1, 0xbcde, 0xbcd9, 0xe45d,
  0xe440, 0xe448, 0xe447, 0xbcef, 0xe45c, 0xbcee, 0xbcd4, 0xe44a,
  0xe442, 0xe446, 0xe443, 0xe441, 0xbcd0, 0xe44b, 0xbcd5, 0xe041,
  0xbf75, 0xbf76, 0xe043, 0xbfa8, 0xe040, 0xbf70, 0xb9c2, 0xe042,
  0xbfa9, 0xe046, 0xbfab, 0xbf74, 0xbcd6, 0xbf71, 0xbf77, 0xbf73,
  0xbfaf, 0xbf7a, 0xbfaa, 0xbfae, 0xbfac, 0xe047, 0xb9db, 0xb9df,
  0xb9d4, 0xe3db, 0xb9d7, 0xe3ef, 0xe3d6, 0xb9c6, 0xe3ee, 0xe3d0,
  0xb9d8, 0xe3d3, 0xb9d9, 0xe3ec, 0xb9c3, 0xe3d2, 0xe3d8, 0xb9c0,
  0xefa7, 0xb9de, 0xb9dd, 0xb9d5, 0xe3d9, 0xe3d5, 0xb9c1, 0xe3da,
  0xe3d4, 0xe3d7, 0xb9da, 0xe3d1, 0xe3ed, 0xe3e9, 0xb9d6, 0xbbdf,
  0xefa8, 0xefa6, 0xefa5, 0xef73, 0xefa1, 0xefac, 0xefaa, 0xbbc0,
  0xbbde, 0xefa0, 0xbbc2, 0xbbd4, 0xbbd9, 0xefa2, 0xefa4, 0xbbdd,
  0xefaf, 0xbbd7, 0xefae, 0xefa9, 0xbbd6, 0xbbd5, 0xb9dc, 0xbbc3,
  0xefbd, 0xbbd1, 0xbbd8, 0xefa3, 0xbbdc, 0xbbdb, 0xbbda, 0xc5ce,
  0xeaa9, 0xeaa0, 0xeaa7, 0xeaa1, 0xc5cd, 0xeaa8, 0xeaa6, 0xc5b1,
  0xeaaa, 0xc5c9, 0xeaae, 0xeaa5, 0xeaa2, 0xefab, 0xeaa4, 0xeaaf,
  0xc5b0, 0xeaac, 0xc5b3, 0xeabd, 0xc5b2, 0xeaa3, 0xc5cf, 0xea73,
  0xc5cc, 0xeaab, 0xf4d1, 0xf4e7, 0xf4e8, 0xf4ea, 0xf4d6, 0xc6de,
  0xf4d7, 0xc6db, 0xc6d8, 0xf4e4, 0xf4ec, 0xf4d3, 0xf4e9, 0xf4d0,
  0xf4d2, 0xf4e5, 0xf4eb, 0xc6d9, 0xf4e0, 0xf4e6, 0xf4ef, 0xf4e1,
  0xf4ee, 0xf6f4, 0xc7c2, 0xf74c, 0xf242, 0xc7db, 0xf4ed, 0xf6fa,
  0xc7df, 0xf6f5, 0xf6f0, 0xc7d9, 0xc7d8, 0xf6fb, 0xf74d, 0xf74f,
  0xf6f7, 0xf6f1, 0xf6f3, 0xf6f6, 0xf74e, 0xc7dc, 0xc7da, 0xc7de,
  0xc7dd, 0xf0dd, 0xc0ba, 0xf0c3, 0xf0df, 0xf0de, 0xc0b8, 0xf0d9,
  0xf0dc, 0xf0c2, 0xc0b5, 0xc0b9, 0xf0d8, 0xc0bb, 0xc0be, 0xc0f3,
  0xc14d, 0xf243, 0xf240, 0xf25d, 0xf25c, 0xc14c, 0xf35b, 0xf356,
  0xc1a7, 0xf355, 0xf35a, 0xf357, 0xf354, 0xfc4e, 0xc1d1, 0xfc4f,
  0xfc4d, 0xfc4c, 0xc1f3, 0xc1f0, 0xfccc, 0xfccf, 0xc24d, 0xfd40,
  0xfd43, 0xc26a, 0xc260, 0xfda4, 0xfdc5, 0xacab, 0xd3c0, 0xd3c3,
  0xe45f, 0xe05d, 0xe3e8, 0xc5cb, 0xc5c8, 0xf4e3, 0xf749, 0xfc49,
  0xacaa, 0xd7d3, 0xb457, 0xb76c, 0xe459, 0xe45e, 0xb9d1, 0xe3eb,
  0xb9d0, 0xeabc, 0xc6da, 0xc27b, 0xaca5, 0xc9c6, 0xd7d2, 0xb76f,
  0xd3c2, 0xd3dd, 0xdfe8, 0xb245, 0xbceb, 0xe45b, 0xe458, 0xe45a,
  0xe05c, 0xe05f, 0xbfa5, 0xbbd0, 0xb9d3, 0xbbd3, 0xeab8, 0xeabf,
  0xeab9, 0xeabe, 0xc5ca, 0xf4e2, 0xf74b, 0xf748, 0xcfa9, 0xb451,
  0xb456, 0xd7ed, 0xd3dc, 0xdfea, 0xdfeb, 0xb244, 0xe454, 0xe457,
  0xe455, 0xbce5, 0xbcea, 0xbfa7, 0xbfa4, 0xe3ea, 0xefbe, 0xefbc,
  0xefbf, 0xbbd2, 0xeaba, 0xeabb, 0xf4ff, 0xf4fc, 0xf4fd, 0xf74a,
  0xfda7, 0xaca4, 0xa97e, 0xa979, 0xb450, 0xb453, 0xd7ef, 0xd7ec,
  0xd3df, 0xb765, 0xb76b, 0xb76e, 0xb76a, 0xb768, 0xb769, 0xb247,
  0xdfe7, 0xbce0, 0xb241, 0xb25c, 0xdfe1, 0xb25e, 0xb25f, 0xb258,
  0xdfe6, 0xdfe5, 0xb242, 0xb246, 0xb240, 0xdfe4, 0xb259, 0xb25d,
  0xb243, 0xbce2, 0xbce3, 0xbce1, 0xbcfd, 0xbce7, 0xbce6, 0xbce4,
  0xe456, 0xe059, 0xbfa1, 0xbfa0, 0xbfa6, 0xe05e, 0xe058, 0xe3e7,
  0xe3e1, 0xb9ea, 0xe3e0, 0xb9ed, 0xe3e4, 0xb9d2, 0xb9e4, 0xb9e8,
  0xb9eb, 0xb9ef, 0xe3e5, 0xb9ec, 0xe3e3, 0xe3e6, 0xb9e5, 0xb9ee,
  0xb9e9, 0xefb8, 0xefba, 0xefbb, 0xefb5, 0xbbed, 0xefb9, 0xc5c6,
  0xeab5, 0xc5c5, 0xc5c1, 0xc5c7, 0xc5c4, 0xf4fe, 0xf4fb, 0xf4f8,
  0xf4f9, 0xc6d5, 0xf745, 0xf744, 0xc7d5, 0xf747, 0xc7d4, 0xc0b7,
  0xc0b4, 0xf25f, 0xc14f, 0xf25e, 0xf351, 0xc1a6, 0xc1a1, 0xfc48,
  0xc24f, 0xaca7, 0xb767, 0xb764, 0xe451, 0xe450, 0xbfa3, 0xefb4,
  0xb9e7, 0xefb7, 0xeab4, 0xaca6, 0xd4bf, 0xa97b, 0xa978, 0xd7ee,
  0xb452, 0xd7e9, 0xd3d8, 0xd3d9, 0xd3de, 0xdfe3, 0xb255, 0xdfe0,
  0xb25a, 0xdfe2, 0xb25b, 0xe452, 0xe46f, 0xe46d, 0xe46c, 0xe468,
  0xe453, 0xe46b, 0xe46e, 0xe469, 0xbfbd, 0xe05b, 0xbfa2, 0xe3ff,
  0xe3fd, 0xb9e6, 0xe3e2, 0xe3fc, 0xb9e1, 0xefb6, 0xefb1, 0xc5c0,
  0xf741, 0xf743, 0xf746, 0xf740, 0xf0db, 0xf259, 0xfd62, 0xaca1,
  0xa97a, 0xd7e8, 0xd7ea, 0xd7eb, 0xd3d5, 0xb761, 0xd3db, 0xb766,
  0xd3d4, 0xd3d7, 0xd3da, 0xdff6, 0xb26d, 0xdffe, 0xdff4, 0xb256,
  0xb253, 0xdfff, 0xb254, 0xdffb, 0xe461, 0xb250, 0xdffc, 0xdffa,
  0xdff9, 0xdff7, 0xdffd, 0xdff5, 0xb251, 0xb252, 0xdff8, 0xb257,
  0xbcff, 0xe465, 0xbcfc, 0xe462, 0xe463, 0xbcf5, 0xbcf4, 0xe47d,
  0xbcfe, 0xe460, 0xbcfa, 0xe47f, 0xe464, 0xe466, 0xbcf9, 0xe46a,
  0xe467, 0xe47c, 0xbcf8, 0xe47e, 0xbcfb, 0xbfbc, 0xe056, 0xe06c,
  0xe054, 0xe06f, 0xe055, 0xe050, 0xe06e, 0xe06d, 0xe052, 0xe053,
  0xe05a, 0xe051, 0xe057, 0xb9fc, 0xb9e3, 0xe3f6, 0xec4c, 0xec4e,
  0xec4d, 0xe3f5, 0xe3f7, 0xec48, 0xec4f, 0xe3f1, 0xec4b, 0xe3f4,
  0xec49, 0xb9e2, 0xb9f8, 0xb9fe, 0xe3fe, 0xb9f9, 0xb9fd, 0xe3f9,
  0xe3fb, 0xe3f8, 0xe3f0, 0xe3f3, 0xb9ff, 0xb9e0, 0xe3fa, 0xefcb,
  0xbbef, 0xefb0, 0xbbee, 0xbbeb, 0xefcf, 0xefb2, 0xbbe8, 0xefce,
  0xefc9, 0xefb3, 0xefca, 0xefcd, 0xefc8, 0xbbe9, 0xbbec, 0xefcc,
  0xeab2, 0xc5dd, 0xc5c3, 0xc5dc, 0xc5c2, 0xeab3, 0xeab6, 0xeab7,
  0xeab0, 0xeab1, 0xf548, 0xc6d3, 0xf4f6, 0xf4f7, 0xc6d4, 0xf54c,
  0xf54d, 0xf4fa, 0xf54e, 0xf4f1, 0xc6d0, 0xf4f4, 0xf54f, 0xf4f5,
  0xc6d7, 0xc6d1, 0xf4f0, 0xc6d6, 0xf4f3, 0xf549, 0xf75f, 0xc7d3,
  0xf742, 0xf75e, 0xc7d6, 0xf75c, 0xc7ed, 0xc7d0, 0xf75d, 0xc7d2,
  0xf759, 0xc7d7, 0xc0b1, 0xc0b3, 0xf0d4, 0xc0b0, 0xf0da, 0xc7d1,
  0xf0d5, 0xc0b6, 0xc14e, 0xc148, 0xf25b, 0xc149, 0xf258, 0xf36c,
  0xc1a0, 0xf36d, 0xc1a3, 0xf353, 0xf350, 0xf36f, 0xf36e, 0xfc4b,
  0xf352, 0xfccb, 0xfcce, 0xfcc9, 0xfcc8, 0xc251, 0xfd5c, 0xfd5d,
  0xfd42, 0xfd7d, 0xfdb3, 0xfda6, 0xc263, 0xaca0, 0xb46d, 0xbcf7,
  0xb9fb, 0xefc5, 0xc6d2, 0xf758, 0xfda1, 0xaca3, 0xaee3, 0xa974,
  0xa975, 0xb46e, 0xd7e5, 0xb46c, 0xd7e4, 0xb46f, 0xd3d2, 0xd3d6,
  0xb760, 0xd3d3, 0xd3d0, 0xd3d1, 0xb763, 0xd3ed, 0xd3ec, 0xd84e,
  0xd84c, 0xd848, 0xd84b, 0xd841, 0xd845, 0xd847, 0xd84f, 0xdff1,
  0xd844, 0xd846, 0xd849, 0xd84a, 0xdff0, 0xb26f, 0xd84d, 0xdff3,
  0xb26c, 0xb26e, 0xbcf0, 0xe478, 0xe47a, 0xe47b, 0xe476, 0xbcf6,
  0xe475, 0xe479, 0xe474, 0xe477, 0xbcf1, 0xbcf3, 0xe471, 0xe06a,
  0xe06b, 0xe069, 0xe068, 0xbfbe, 0xbfb8, 0xbfbf, 0xbfb9, 0xec40,
  0xec43, 0xec44, 0xec47, 0xb9f5, 0xb9f0, 0xb9fa, 0xb9f3, 0xb9f4,
  0xec46, 0xec41, 0xec45, 0xba4d, 0xb9f6, 0xb9f7, 0xb9f1, 0xec4a,
  0xefc7, 0xbbe5, 0xefc1, 0xbbe7, 0xefc2, 0xefc6, 0xefc4, 0xefc3,
  0xbbe4, 0xefc0, 0xbbea, 0xc5de, 0xc5db, 0xeacc, 0xc5d9, 0xeacd,
  0xc5df, 0xc5d8, 0xf54b, 0xf54a, 0xf545, 0xc6ed, 0xf544, 0xc6ec,
  0xc7ef, 0xf755, 0xf754, 0xf75a, 0xf75b, 0xf757, 0xc7ec, 0xf0d0,
  0xf0d6, 0xf0d1, 0xf0d3, 0xf0d7, 0xf0d2, 0xf255, 0xf254, 0xf25a,
  0xc14b, 0xf369, 0xc1a2, 0xf368, 0xfc45, 0xfc4a, 0xaca2, 0xb269,
  0xbd4d, 0xbfbb, 0xbbe1, 0xbbe6, 0xc7ee, 0xc071, 0xc14a, 0xacbd,
  0xb469, 0xbd4c, 0xf756, 0xcfab, 0xacbc, 0xacb9, 0xacbe, 0xacbf,
  0xcfa8, 0xc9c0, 0xc9c2, 0xaee2, 0xaefc, 0xc9c1, 0xc9c3, 0xaefd,
  0xc9dc, 0xc9dd, 0xc9df, 0xd4bb, 0xd4b9, 0xa971, 0xd4be, 0xa9ae,
  0xa973, 0xa976, 0xa9a9, 0xa970, 0xa9af, 0xa9ac, 0xd4b8, 0xa977,
  0xb467, 0xd7e6, 0xd7fc, 0xb46a, 0xb463, 0xb464, 0xd7e3, 0xd7fd,
  0xb461, 0xd7e7, 0xd7e0, 0xb465, 0xb468, 0xd7e1, 0xb466, 0xd7e2,
  0xb460, 0xb46b, 0xd3ee, 0xd3eb, 0xb77d, 0xb777, 0xb77b, 0xd3e9,
  0xb773, 0xb77a, 0xb771, 0xb77f, 0xb762, 0xb77c, 0xb770, 0xd3e8,
  0xb778, 0xb775, 0xb779, 0xb774, 0xd3ea, 0xb776, 0xb77e, 0xd3ef,
  0xd840, 0xb268, 0xd842, 0xb26a, 0xb264, 0xd843, 0xb26b, 0xb267,
  0xb265, 0xbd4a, 0xe4ae, 0xbd42, 0xe473, 0xbd5d, 0xbd48, 0xe4ac,
  0xbd47, 0xe4af, 0xbd4e, 0xbd4f, 0xbd40, 0xbd41, 0xbd46, 0xbd44,
  0xbd43, 0xe470, 0xbd49, 0xbd4b, 0xbd45, 0xbfb5, 0xbfb6, 0xbfb2,
  0xbfb4, 0xbfb3, 0xbfb1, 0xbfba, 0xbfb0, 0xbfb7, 0xec5f, 0xba4e,
  0xba4c, 0xec5e, 0xba49, 0xba4f, 0xec5c, 0xec5d, 0xbbfd, 0xec42,
  0xbbe3, 0xbbe0, 0xefdd, 0xba48, 0xbbe2, 0xefdc, 0xbbff, 0xefdf,
  0xbbfc, 0xc5d5, 0xeace, 0xc5da, 0xc5d1, 0xc5d7, 0xc5d6, 0xc6ee,
  0xc5d4, 0xeacf, 0xefde, 0xc6ef, 0xc6e9, 0xc7e9, 0xc7e8, 0xf0ed,
  0xc1d3, 0xc1d0, 0xacbb, 0xce58, 0xb462, 0xce5f, 0xce5e, 0xce5c,
  0xce59, 0xcfa7, 0xcfaa, 0xcfa1, 0xcfa5, 0xacba, 0xacb7, 0xcfa4,
  0xacb4, 0xcfa6, 0xacb5, 0xc9d8, 0xc9da, 0xaef9, 0xc9de, 0xc9db,
  0xc9d9, 0xaeff, 0xaef8, 0xaefe, 0xd4b5, 0xd4b1, 0xd4b4, 0xa9aa,
  0xa9a5, 0xd4b6, 0xd4b0, 0xd4b2, 0xa9a8, 0xd4b3, 0xa9ab, 0xd3e3,
  0xd4b7, 0xd7ff, 0xd7f6, 0xd7f4, 0xd7f9, 0xd7f8, 0xd7f7, 0xd7f1,
  0xb47c, 0xd7fa, 0xd7fe, 0xb47d, 0xb47f, 0xd7fb, 0xd7f0, 0xd7f5,
  0xb7ac, 0xd3fc, 0xd3e4, 0xd3e2, 0xd3fd, 0xb7af, 0xd3e5, 0xd3e7,
  0xd4ba, 0xd3e1, 0xd3e0, 0xd3e6, 0xb261, 0xd85b, 0xefd9, 0xd85a,
  0xd859, 0xb7ae, 0xb263, 0xd85e, 0xd854, 0xd855, 0xb266, 0xd851,
  0xd85f, 0xd856, 0xd85d, 0xd857, 0xd858, 0xb260, 0xe4a7, 0xe4a8,
  0xe4a6, 0xe4ab, 0xe4a9, 0xe4aa, 0xbd5c, 0xe4a4, 0xe4a5, 0xbd5f,
  0xbfcc, 0xbfcd, 0xe063, 0xe07c, 0xe064, 0xe060, 0xbfcf, 0xe061,
  0xe067, 0xe07d, 0xe066, 0xe065, 0xe062, 0xec54, 0xba45, 0xf547,
  0xec5b, 0xec5a, 0xec58, 0xd85c, 0xba4a, 0xec57, 0xec59, 0xba4b,
  0xba44, 0xec55, 0xefd8, 0xbbfe, 0xefdb, 0xefda, 0xeac9, 0xc5d0,
  0xf546, 0xf541, 0xf540, 0xf750, 0xf751, 0xf0ef, 0xf0ec, 0xf256,
  0xf251, 0xf257, 0xf36b, 0xc1bd, 0xacb6, 0xa9a7, 0xa9a4, 0xb478,
  0xb479, 0xd04d, 0xd04c, 0xd7f3, 0xb47e, 0xd3f8, 0xd3fb, 0xd3ff,
  0xb7a9, 0xd3fe, 0xd3f9, 0xd852, 0xd86c, 0xd850, 0xd86d, 0xb262,
  0xd853, 0xb27d, 0xd97e, 0xbd58, 0xbd59, 0xbd5e, 0xe4a1, 0xe4a0,
  0xe07e, 0xe078, 0xbfcb, 0xbfce, 0xbfc8, 0xbfc9, 0xe079, 0xe07f,
  0xec6c, 0xec53, 0xec52, 0xba40, 0xec6d, 0xec56, 0xec51, 0xba47,
  0xba46, 0xec50, 0xba41, 0xefd6, 0xefd1, 0xefd4, 0xefd7, 0xbbf9,
  0xefd5, 0xeac5, 0xeac8, 0xeaca, 0xc5ed, 0xeac6, 0xc5d2, 0xeac4,
  0xeac1, 0xeac7, 0xeacb, 0xc5d3, 0xf542, 0xf55d, 0xf543, 0xf55f,
  0xc6e8, 0xc6eb, 0xf752, 0xc7ea, 0xf55c, 0xf753, 0xc7eb, 0xf0e8,
  0xf0eb, 0xc0b2, 0xf0e9, 0xf0ee, 0xf250, 0xc145, 0xfc44, 0xfcc5,
  0xfcca, 0xc24e, 0xc250, 0xfcc4, 0xfd7c, 0xc262, 0xacb1, 0xaefb,
  0xbd5b, 0xc0cd, 0xacb0, 0xa9a6, 0xb7a8, 0xb27c, 0xc6ea, 0xaefa,
  0xd4cc, 0xd4cd, 0xd04f, 0xb475, 0xb47b, 0xb477, 0xd049, 0xb474,
  0xb47a, 0xd04e, 0xb7a5, 0xd3f1, 0xb7aa, 0xb7a4, 0xdc4f, 0xb7a6,
  0xd3f3, 0xdc4d, 0xd3fa, 0xb7a7, 0xdc4e, 0xd3f4, 0xd3f7, 0xd3f5,
  0xb7ab, 0xdc4c, 0xd3f6, 0xd3f0, 0xd860, 0xd861, 0xd867, 0xd86f,
  0xd87c, 0xd868, 0xd862, 0xd87b, 0xd863, 0xb274, 0xb278, 0xd86e,
  0xd864, 0xb27a, 0xd865, 0xb275, 0xb277, 0xd866, 0xb27f, 0xb27e,
  0xd87a, 0xd878, 0xd879, 0xd86b, 0xd87f, 0xb27b, 0xb279, 0xd87e,
  0xd869, 0xd86a, 0xd87d, 0xe0b7, 0xe4ba, 0xe4bd, 0xe4ce, 0xe4c1,
  0xe4be, 0xbd6c, 0xe4cd, 0xbd5a, 0xbd54, 0xbd68, 0xe4bc, 0xbd57,
  0xbd51, 0xbd6b, 0xbd56, 0xbd69, 0xe4b4, 0xe4a3, 0xbd6f, 0xe4b5,
  0xbd53, 0xe4c7, 0xbd6e, 0xe4c5, 0xe4b1, 0xe4cb, 0xbd6d, 0xe4a2,
  0xe4c4, 0xe4c9, 0xe4c6, 0xbd55, 0xbd6a, 0xbd50, 0xe4b8, 0xe4b0,
  0xe4cc, 0xe4c8, 0xbd52, 0xe4b9, 0xe4bf, 0xe4b3, 0xe4b6, 0xe4b7,
  0xe4b2, 0xe4cf, 0xe4ca, 0xe075, 0xbfca, 0xe0a9, 0xe077, 0xbfc1,
  0xbfdd, 0xe0a0, 0xe0b8, 0xe0ab, 0xbfc5, 0xe0a7, 0xe4bb, 0xbfc4,
  0xe0bc, 0xe0bb, 0xe0a3, 0xe0bd, 0xe0b4, 0xe0bf, 0xe073, 0xe0a4,
  0xbfdc, 0xbfc0, 0xe071, 0xe0a6, 0xbfc6, 0xe0a8, 0xbfc7, 0xe0be,
  0xe0af, 0xe074, 0xbfc3, 0xe0b5, 0xe076, 0xe0a2, 0xe0a1, 0xe0aa,
  0xe07a, 0xe07b, 0xe0ac, 0xe0b9, 0xbfc2, 0xe0ba, 0xe070, 0xe0ae,
  0xba5f, 0xba57, 0xba58, 0xeca9, 0xecac, 0xec6a, 0xba5d, 0xba42,
  0xba5b, 0xec68, 0xba59, 0xec7c, 0xec6e, 0xec69, 0xba43, 0xecae,
  0xba55, 0xec79, 0xec74, 0xec7e, 0xefe3, 0xec62, 0xec7a, 0xec78,
  0xec65, 0xec6f, 0xec70, 0xba5a, 0xec73, 0xec75, 0xec60, 0xec66,
  0xec6b, 0xec63, 0xec76, 0xec67, 0xec77, 0xecaf, 0xba5e, 0xec7b,
  0xec71, 0xec7f, 0xec61, 0xba5c, 0xe0a5, 0xec7d, 0xba54, 0xec64,
  0xeff9, 0xbbfa, 0xeffe, 0xeffd, 0xe849, 0xbbf6, 0xe84c, 0xeff5,
  0xe84e, 0xefe4, 0xeffb, 0xbbf0, 0xefec, 0xefd2, 0xe84f, 0xe84d,
  0xeff3, 0xefe0, 0xefe1, 0xefef, 0xc44d, 0xefe5, 0xefff, 0xeff0,
  0xc44e, 0xe848, 0xc5e5, 0xc448, 0xbbf3, 0xefeb, 0xefe2, 0xefd3,
  0xefed, 0xbbf8, 0xc44f, 0xbbf7, 0xefea, 0xeffa, 0xeffc, 0xc44c,
  0xefd0, 0xc5ee, 0xeff4, 0xeff1, 0xbbf1, 0xefe6, 0xc449, 0xbbf4,
  0xbbf5, 0xeff8, 0xeff6, 0xbbfb, 0xefe9, 0xeff7, 0xefe8, 0xefe7,
  0xeadf, 0xeada, 0xc5e8, 0xc5ea, 0xead0, 0xc5ec, 0xeae1, 0xeaee,
  0xead5, 0xead4, 0xeaef, 0xc5e3, 0xeaec, 0xeadc, 0xeaed, 0xead9,
  0xeae0, 0xc5e0, 0xc5e6, 0xead8, 0xeae5, 0xead7, 0xeaea, 0xeae4,
  0xeadd, 0xc5eb, 0xeae7, 0xead3, 0xc5e7, 0xead6, 0xc5e1, 0xeae9,
  0xc5e9, 0xeadb, 0xeae8, 0xead2, 0xefee, 0xeaeb, 0xeade, 0xc5e4,
  0xeae6, 0xc5ef, 0xeac3, 0xf56d, 0xf554, 0xc6e4, 0xf559, 0xf56e,
  0xf556, 0xead1, 0xf568, 0xf558, 0xc6e5, 0xf552, 0xc6e7, 0xc6ff,
  0xc6fd, 0xf56c, 0xc6fc, 0xf55a, 0xf555, 0xf550, 0xf56f, 0xeac0,
  0xc6e6, 0xf567, 0xf56a, 0xf566, 0xf553, 0xf557, 0xf565, 0xf767,
  0xf551, 0xc6e3, 0xc6e0, 0xeac2, 0xc6e2, 0xf569, 0xf56b, 0xc6e1,
  0xf564, 0xf55e, 0xf55b, 0xf77e, 0xf76e, 0xc7e6, 0xf77c, 0xf76c,
  0xc7e1, 0xf761, 0xf765, 0xc7fc, 0xf77f, 0xf76f, 0xf768, 0xc7e4,
  0xf779, 0xf760, 0xf77d, 0xc7e2, 0xc7f9, 0xc7ff, 0xf764, 0xf769,
  0xc7e0, 0xc7e3, 0xf76d, 0xc7e7, 0xc7e5, 0xc7fd, 0xf762, 0xc7fe,
  0xf766, 0xf778, 0xc7f8, 0xf76a, 0xf763, 0xf0fe, 0xf14f, 0xf0f8,
  0xf0f1, 0xf76b, 0xf0f7, 0xf0e4, 0xf14d, 0xc0ce, 0xf0e0, 0xf0f3,
  0xf0f9, 0xc0cf, 0xf149, 0xf0fb, 0xf0f6, 0xf0f0, 0xf0ea, 0xf14c,
  0xf0ff, 0xf0fa, 0xf0e6, 0xf0e2, 0xf14e, 0xf0f4, 0xf0e5, 0xf0e1,
  0xf0e3, 0xf0f5, 0xc0cc, 0xf0fc, 0xf0e7, 0xf0fd, 0xf26c, 0xf26b,
  0xc142, 0xf265, 0xc144, 0xf269, 0xf267, 0xc143, 0xc147, 0xc146,
  0xf26d, 0xf26a, 0xc140, 0xf268, 0xc141, 0xf252, 0xf26e, 0xf26f,
  0xf253, 0xf264, 0xc1bc, 0xf360, 0xf37d, 0xf361, 0xf363, 0xf362,
  0xf364, 0xf367, 0xf36a, 0xf366, 0xf365, 0xc1bf, 0xc1be, 0xfc46,
  0xfc40, 0xfc41, 0xfc43, 0xc1ed, 0xfc47, 0xc1d2, 0xc1ec, 0xfcc6,
  0xfcc1, 0xc249, 0xfcc7, 0xfd5e, 0xfd5f, 0xfd59, 0xc252, 0xfd58,
  0xc253, 0xfd5b, 0xfd7f, 0xfd78, 0xfd79, 0xc265, 0xfd7e, 0xc27f,
  0xc27d, 0xc27c, 0xc27a, 0xfdcd, 0xfdcc, 0xfdb2, 0xfdc4, 0xaef5,
  0xdc49, 0xd875, 0xeca8, 0xf77b, 0xaef4, 0xa9a1, 0xb476, 0xdc48,
  0xdc4b, 0xb7a1, 0xb270, 0xd877, 0xd874, 0xb2ae, 0xb271, 0xd876,
  0xb273, 0xb2af, 0xb2ac, 0xb276, 0xbd65, 0xe4dd, 0xe4c3, 0xe4c2,
  0xe4c0, 0xbfdf, 0xbfd8, 0xbfda, 0xbfdb, 0xbfde, 0xbfd9, 0xecaa,
  0xecab, 0xba56, 0xeca5, 0xeca4, 0xba51, 0xe840, 0xe846, 0xeafe,
  0xe844, 0xe847, 0xc44b, 0xe84b, 0xe843, 0xe845, 0xe841, 0xeae2,
  0xeafc, 0xeaff, 0xc5fe, 0xeae3, 0xc5ff, 0xeafd, 0xc5e2, 0xc5fd,
  0xc5fc, 0xe84a, 0xc6f8, 0xf563, 0xf561, 0xf560, 0xc6fe, 0xc6fb,
  0xc6f9, 0xf77a, 0xf775, 0xc7fb, 0xf148, 0xf14a, 0xf14b, 0xc0c9,
  0xc15d, 0xf260, 0xf261, 0xf266, 0xaef7, 0xcda7, 0xce55, 0xa2e4,
  0xce5b, 0xce54, 0xce5a, 0xcfa3, 0xaccc, 0xaccf, 0xcfbd, 0xacb2,
  0xcfa2, 0xcfa0, 0xaccd, 0xacb3, 0xc9d5, 0xc9d6, 0xaef0, 0xc9d7,
  0xc9d4, 0xaef1, 0xaef6, 0xaf4d, 0xc9d1, 0xaef3, 0xd4cb, 0xa9a3,
  0xa9a2, 0xa9bd, 0xd4ca, 0xd4ce, 0xa9a0, 0xd4c9, 0xd4c8, 0xd4cf,
  0xb4a9, 0xb4ac, 0xd048, 0xb4af, 0xb4a8, 0xd04b, 0xb473, 0xb471,
  0xb470, 0xb4ae, 0xb7a0, 0xdc44, 0xb7b8, 0xdc45, 0xdc46, 0xb7bc,
  0xdc47, 0xb2a6, 0xb7a2, 0xb7bf, 0xb7a3, 0xb7be, 0xb7b9, 0xb7bd,
  0xdc4a, 0xb2aa, 0xd870, 0xd8ae, 0xd8af, 0xb2a1, 0xb2a5, 0xb2a4,
  0xd871, 0xd873, 0xd8ac, 0xb2a9, 0xb2ab, 0xb2a7, 0xb2a8, 0xe4de,
  0xe4dc, 0xe4df, 0xbd67, 0xbd66, 0xe4d9, 0xbd64, 0xbfd5, 0xbfd7,
  0xbfd4, 0xe0b6, 0xe0b1, 0xeca6, 0xeca7, 0xc44a, 0xc445, 0xe842,
  0xc444, 0xeafb, 0xeaf9, 0xeaf8, 0xc5f9, 0xf562, 0xc7fa, 0xc5f8,
  0xaf4c, 0xb4ab, 0xd04a, 0xdc41, 0xb7bb, 0xb2a0, 0xd8a9, 0xd8ab,
  0xb2a2, 0xb2a3, 0xb2bd, 0xb2bc, 0xd8a8, 0xbd63, 0xbd62, 0xbd60,
  0xbfd6, 0xbd61, 0xe4d8, 0xbfd1, 0xeca1, 0xe85d, 0xc447, 0xc5fb,
  0xf57d, 0xf579, 0xc6f4, 0xf57c, 0xc6f7, 0xc6f5, 0xf578, 0xc6f6,
  0xf57e, 0xf774, 0xc6fa, 0xc7f5, 0xfcc0, 0xaf4f, 0xb7b5, 0xb7ba,
  0xb2bf, 0xd8a5, 0xd8aa, 0xb2be, 0xe4d4, 0xbd7e, 0xbd7d, 0xe4d5,
  0xbd7f, 0xe4db, 0xbd7c, 0xe4da, 0xe0b0, 0xbfd0, 0xeca2, 0xba50,
  0xeca0, 0xba53, 0xba52, 0xeca3, 0xba6d, 0xe85c, 0xc443, 0xc446,
  0xc45d, 0xe85e, 0xc441, 0xe85f, 0xc442, 0xc440, 0xeaf4, 0xeaf6,
  0xc5fa, 0xeaf7, 0xc5f5, 0xeaf5, 0xeafa, 0xf57a, 0xf57b, 0xc6f1,
  0xf575, 0xf773, 0xc7f7, 0xf770, 0xf777, 0xc7f4, 0xf776, 0xf771,
  0xf145, 0xf144, 0xc0c8, 0xc15e, 0xf263, 0xc15c, 0xc15f, 0xf262,
  0xc1b9, 0xc1b8, 0xf37c, 0xc248, 0xfcc2, 0xc24a, 0xfcc3, 0xfcdd,
  0xc24b, 0xfd5a, 0xfda0, 0xaf4e, 0xbd79, 0xe0b3, 0xecbd, 0xc45c,
  0xc45f, 0xaf49, 0xba6c, 0xc7f6, 0xa9bc, 0xc45e, 0xc1ef, 0xa9bf,
  0xdc40, 0xd8a4, 0xd8a6, 0xd8a7, 0xe4d0, 0xe4d7, 0xbd78, 0xbd7b,
  0xe4d6, 0xe4d1, 0xe0cd, 0xe0c8, 0xbfd3, 0xe0b2, 0xe0cc, 0xe0c5,
  0xe0ce, 0xe0ca, 0xe0c9, 0xe0cf, 0xe0cb, 0xbfd2, 0xecbe, 0xecbc,
  0xba6e, 0xba6f, 0xecbf, 0xba69, 0xe85b, 0xe858, 0xc459, 0xe859,
  0xeaf1, 0xeaf3, 0xeb4c, 0xeb4d, 0xc5f4, 0xeaf0, 0xf5ac, 0xc6f0,
  0xf570, 0xf5af, 0xc6f3, 0xf576, 0xf573, 0xf571, 0xf574, 0xc74d,
  0xf577, 0xf7ac, 0xf7ae, 0xf7af, 0xf147, 0xf146, 0xf27d, 0xc1ba,
  0xc1bb, 0xfc42, 0xfc5d, 0xc245, 0xfcdc, 0xc264, 0xa9be, 0xb2b9,
  0xe0c7, 0xe0c4, 0xecb8, 0xecb9, 0xc5f7, 0xeb4e, 0xeb4f, 0xf5a8,
  0xf5ae, 0xf5ab, 0xf5a9, 0xc7f1, 0xf7a9, 0xf7a8, 0xf7ab, 0xf27c,
  0xf37f, 0xfcdf, 0xa9b9, 0xe85a, 0xeb49, 0xa9b8, 0xbfed, 0xe855,
  0xc74c, 0xf5aa, 0xc7f0, 0xf141, 0xf140, 0xc159, 0xfc5c, 0xa9bb,
  0xb7b6, 0xb7b1, 0xdc43, 0xb2b8, 0xb2bb, 0xd8a1, 0xb2ba, 0xbd77,
  0xbd71, 0xe4d2, 0xe4ed, 0xe4d3, 0xbd7a, 0xbd75, 0xbd76, 0xbd74,
  0xe0c6, 0xbfec, 0xbfef, 0xecb1, 0xba6a, 0xecba, 0xecbb, 0xecb6,
  0xba68, 0xc456, 0xecb5, 0xecb0, 0xecb7, 0xecb4, 0xba6b, 0xc454,
  0xe857, 0xc458, 0xe856, 0xe854, 0xc455, 0xc45b, 0xc457, 0xc45a,
  0xeb48, 0xeb47, 0xeb4b, 0xeb44, 0xc5f6, 0xe9d9, 0xeb45, 0xeb4a,
  0xc749, 0xc74f, 0xc748, 0xc74e, 0xf5a5, 0xf5a4, 0xf5a7, 0xc74b,
  0xf7a7, 0xc04d, 0xf7a5, 0xc04c, 0xf7aa, 0xf7a4, 0xc7f3, 0xf15c,
  0xf143, 0xf142, 0xf15d, 0xf27f, 0xc15b, 0xc158, 0xf379, 0xf37e,
  0xc1b5, 0xc1ee, 0xc244, 0xc26d, 0xfd55, 0xfda3, 0xfda2, 0xa9ba,
  0xd8a0, 0xe4ec, 0xe0c1, 0xe0c0, 0xbfee, 0xbfe9, 0xecb3, 0xba65,
  0xc5f1, 0xf5a6, 0xc74a, 0xf7a0, 0xc04f, 0xf7a1, 0xf7a3, 0xf7a6,
  0xf278, 0xf15f, 0xf15e, 0xc0cb, 0xf279, 0xf27e, 0xf378, 0xfdbd,
  0xa9b5, 0xa9b4, 0xb4aa, 0xd045, 0xdc42, 0xb2b5, 0xb2b6, 0xb2b4,
  0xd8a3, 0xb2b0, 0xb2b7, 0xb2b1, 0xbd73, 0xe4ef, 0xe4ee, 0xeccd,
  0xbd70, 0xbdac, 0xbdaf, 0xe0c2, 0xe0c3, 0xbfe8, 0xbfeb, 0xe0dd,
  0xecb2, 0xbfe5, 0xba64, 0xbfea, 0xc451, 0xeccc, 0xba66, 0xba67,
  0xeccf, 0xecc8, 0xecce, 0xecc9, 0xba61, 0xc46c, 0xc452, 0xc453,
  0xe850, 0xc46d, 0xe851, 0xeb46, 0xe853, 0xc450, 0xe852, 0xeb43,
  0xeb41, 0xeb40, 0xeb5f, 0xc746, 0xeb5c, 0xeb59, 0xeb5e, 0xeb5d,
  0xeb42, 0xc5f0, 0xf5a3, 0xf5a0, 0xc747, 0xc745, 0xc744, 0xf5a1,
  0xf7bc, 0xc04e, 0xf7bd, 0xf7a2, 0xc049, 0xf155, 0xf15a, 0xf158,
  0xf159, 0xc0c5, 0xc0ca, 0xf154, 0xf37b, 0xc1b4, 0xf27a, 0xc15a,
  0xf27b, 0xf15b, 0xf37a, 0xc1e9, 0xc26c, 0xfd54, 0xfdbc, 0xa9b7,
  0xdc5d, 0xeb58, 0xa9b6, 0xe0df, 0xe0dc, 0xe86d, 0xeb5a, 0xeb5b,
  0xc741, 0xf7bf, 0xf7be, 0xc0c4, 0xfdbf, 0xb4a5, 0xb2b2, 0xb2b3,
  0xe4e9, 0xe4eb, 0xbda9, 0xe4e8, 0xbdae, 0xbda8, 0xe4ea, 0xe0d9,
  0xe0db, 0xe0d8, 0xe0d5, 0xbfe4, 0xe0da, 0xe0de, 0xe0d4, 0xecc1,
  0xecc2, 0xecdc, 0xecca, 0xecc6, 0xecc5, 0xba63, 0xba7c, 0xba7e,
  0xecc4, 0xecc7, 0xba7f, 0xecc0, 0xecdd, 0xecc3, 0xba79, 0xba7d,
  0xeccb, 0xba60, 0xba62, 0xc46e, 0xe86b, 0xe869, 0xe86e, 0xe864,
  0xe865, 0xe86a, 0xe86f, 0xc46f, 0xe86c, 0xe868, 0xc469, 0xeb57,
  0xeb53, 0xeb56, 0xeb50, 0xeb51, 0xeb54, 0xeb52, 0xeb6f, 0xeb6d,
  0xeb6c, 0xc64d, 0xc5f3, 0xeb55, 0xeb6e, 0xf5be, 0xf5bb, 0xf5b5,
  0xf5ba, 0xf5bc, 0xf5b8, 0xf5bd, 0xf5bf, 0xc740, 0xf5a2, 0xf5b9,
  0xf7cd, 0xf7b8, 0xc048, 0xc04b, 0xf7b9, 0xf7b4, 0xf7b2, 0xf7ba,
  0xf7b3, 0xf7b6, 0xf7b7, 0xf7b0, 0xf7b5, 0xf7bb, 0xf7b1, 0xf16d,
  0xf153, 0xc0c7, 0xf150, 0xf16e, 0xf16c, 0xc0c6, 0xf151, 0xf157,
  0xf156, 0xc0c0, 0xf152, 0xc0c1, 0xf16f, 0xf275, 0xf273, 0xf274,
  0xc156, 0xf2ac, 0xc157, 0xf270, 0xf271, 0xc154, 0xf276, 0xc155,
  0xf277, 0xf370, 0xf3ac, 0xf373, 0xf376, 0xc1b6, 0xf375, 0xf371,
  0xf3ae, 0xf3af, 0xf374, 0xf377, 0xc1b7, 0xfc5f, 0xc1ea, 0xfc5e,
  0xc1e8, 0xc1eb, 0xfcde, 0xc247, 0xfd7b, 0xc267, 0xfdbe, 0xc266,
  0xfdb9, 0xfdb8, 0xfdce, 0xfdcf, 0xc277, 0xfdc0, 0xb4a4, 0xe4e4,
  0xe4e5, 0xbfe7, 0xbfe6, 0xe0d7, 0xecdf, 0xe861, 0xba78, 0xc468,
  0xe867, 0xe860, 0xc46b, 0xeb69, 0xe866, 0xf5b4, 0xc743, 0xf7cc,
  0xf16b, 0xf169, 0xf168, 0xf2af, 0xc151, 0xf3a9, 0xc1e7, 0xc1b1,
  0xc1e5, 0xc1e4, 0xfcd9, 0xc26f, 0xb4a7, 0xf5b7, 0xd044, 0xbdab,
  0xe0d6, 0xbfe1, 0xe0d1, 0xecd9, 0xecde, 0xc465, 0xba7b, 0xba7a,
  0xecda, 0xecdb, 0xecd8, 0xe863, 0xe87c, 0xe87d, 0xe862, 0xc46a,
  0xeb65, 0xeb6b, 0xeb68, 0xeb6a, 0xc742, 0xf5b1, 0xf5b0, 0xc75d,
  0xf5b6, 0xf7ce, 0xf7cf, 0xf7c8, 0xc04a, 0xf7c9, 0xf16a, 0xf164,
  0xf165, 0xf2ae, 0xf2ab, 0xf2a9, 0xf2a8, 0xf3a8, 0xc1b0, 0xfc59,
  0xfc58, 0xfc5b, 0xc246, 0xc26e, 0xfdbb, 0xb4a6, 0xba75, 0xc464,
  0xf5b3, 0xf3ab, 0xfdc9, 0xd047, 0xc276, 0xb4a1, 0xe87f, 0xf5b2,
  0xf7cb, 0xf2aa, 0xf3aa, 0xb4a0, 0xe0d0, 0xe0d3, 0xbfe0, 0xbfe3,
  0xecd4, 0xba77, 0xba74, 0xecd5, 0xeb64, 0xf5cd, 0xf5cf, 0xf5cc,
  0xc75e, 0xc75f, 0xc75c, 0xc153, 0xf2a5, 0xc150, 0xf3a4, 0xf3a5,
  0xc241, 0xfcd8, 0xb7b0, 0xe4e7, 0xe0ec, 0xe0d2, 0xe0ed, 0xecef,
  0xecd0, 0xecd7, 0xecec, 0xecee, 0xba71, 0xeced, 0xecd1, 0xecd6,
  0xecd2, 0xecd3, 0xba76, 0xe870, 0xe875, 0xe87b, 0xe8ac, 0xe87a,
  0xe87e, 0xe874, 0xe879, 0xeb7f, 0xe878, 0xe8af, 0xe871, 0xc467,
  0xe876, 0xe877, 0xe873, 0xeb67, 0xeb60, 0xeb61, 0xeb79, 0xeb62,
  0xeb7e, 0xeb7c, 0xeb7d, 0xeb63, 0xeb66, 0xc64e, 0xc64f, 0xc649,
  0xc64c, 0xeb78, 0xf5c5, 0xf5c6, 0xf5c4, 0xf5c0, 0xf5c3, 0xf5cb,
  0xc755, 0xf5ca, 0xf5c8, 0xf5c1, 0xf5c9, 0xf5ce, 0xc75a, 0xc758,
  0xc759, 0xf5c7, 0xf7c2, 0xf7d8, 0xc047, 0xf7dd, 0xf7de, 0xf7da,
  0xc046, 0xf7df, 0xf7c7, 0xf7c4, 0xf7db, 0xf7c0, 0xf7c6, 0xf7d9,
  0xf7c1, 0xc044, 0xc045, 0xf7ca, 0xf7c5, 0xf7dc, 0xf7c3, 0xf161,
  0xf162, 0xc75b, 0xf160, 0xf17e, 0xf17c, 0xf166, 0xf17b, 0xf167,
  0xc0c2, 0xf17f, 0xf163, 0xc0c3, 0xf178, 0xf179, 0xf2a6, 0xf2a7,
  0xf2bc, 0xf2a0, 0xf2bd, 0xc16d, 0xf2a3, 0xf2a2, 0xf2a4, 0xf2a1,
  0xc152, 0xc1b2, 0xf3b9, 0xf3a2, 0xf3be, 0xf3bb, 0xf3bf, 0xf3a3,
  0xc1cc, 0xf3bc, 0xf3b8, 0xc1cd, 0xf3a1, 0xf17d, 0xf3bd, 0xf3a0,
  0xf3a7, 0xf3a6, 0xc1b3, 0xfc57, 0xfc51, 0xfc52, 0xfc56, 0xfc6d,
  0xfc54, 0xfc5a, 0xc1e6, 0xfc50, 0xc1e0, 0xc1e1, 0xfc55, 0xfc53,
  0xfcd7, 0xc240, 0xfcd6, 0xfcd4, 0xfcdb, 0xfcd5, 0xfcda, 0xfd57,
  0xfd51, 0xfd56, 0xfd74, 0xfd75, 0xfd7a, 0xfd77, 0xc27e, 0xc279,
  0xfdc7, 0xfdc3, 0xb7b3, 0xd8a2, 0xe4e0, 0xbdaa, 0xe4e6, 0xe4e1,
  0xe0ef, 0xe0ee, 0xbffc, 0xbfe2, 0xe0e9, 0xbffd, 0xece5, 0xece6,
  0xece8, 0xece1, 0xece9, 0xeceb, 0xecea, 0xece7, 0xbaac, 0xece2,
  0xece3, 0xba70, 0xece4, 0xece0, 0xba73, 0xe8a1, 0xc462, 0xe8aa,
  0xc466, 0xe8a9, 0xe8a7, 0xe8a0, 0xc47d, 0xe8a4, 0xe8ab, 0xe8a3,
  0xe8a8, 0xe8a6, 0xc461, 0xe8ae, 0xc460, 0xc463, 0xe8a5, 0xeba4,
  0xeb77, 0xeb76, 0xeb73, 0xeb71, 0xeb7b, 0xeb74, 0xeba8, 0xeb70,
  0xc648, 0xebaa, 0xeba9, 0xc64b, 0xebab, 0xeb7a, 0xebaf, 0xebae,
  0xebac, 0xf5df, 0xf5d9, 0xf5da, 0xf5dc, 0xc754, 0xf5d4, 0xf5dd,
  0xf5d7, 0xf5db, 0xf5d5, 0xf5d1, 0xf5d8, 0xf5d0, 0xf5de, 0xf5c2,
  0xc757, 0xf5d6, 0xc756, 0xc040, 0xeb75, 0xf7fc, 0xf7e5, 0xc042,
  0xf7e9, 0xc05d, 0xf7e0, 0xf7ea, 0xf7d0, 0xc043, 0xf7e7, 0xf7e8,
  0xf7eb, 0xf7d5, 0xf7d2, 0xf7e3, 0xf7e6, 0xf7ee, 0xf7e2, 0xf7d3,
  0xf7d4, 0xf7e1, 0xf7d6, 0xf7e4, 0xf7ed, 0xf7fd, 0xf7d1, 0xc041,
  0xf7d7, 0xf7ec, 0xf7ef, 0xf170, 0xf176, 0xf1af, 0xf1a3, 0xf1a8,
  0xf171, 0xf175, 0xf1aa, 0xf173, 0xf1ae, 0xf177, 0xf1a7, 0xf17a,
  0xf1ac, 0xf1ab, 0xf1a5, 0xf1a6, 0xf174, 0xf1a2, 0xf1bd, 0xf1a4,
  0xf1a0, 0xf1a9, 0xf2cc, 0xf2c9, 0xc16c, 0xf2ce, 0xf2c5, 0xf2cb,
  0xc16f, 0xf2b0, 0xf2be, 0xf2bf, 0xc169, 0xf2b2, 0xf2cd, 0xf2b1,
  0xf2b9, 0xf2b4, 0xf1a1, 0xf2b8, 0xc16e, 0xf2b6, 0xf2b7, 0xf2bb,
  0xf2cf, 0xf2ba, 0xf3b6, 0xf2c8, 0xf2ca, 0xf2b3, 0xf2b5, 0xf3b1,
  0xf3b3, 0xf3b5, 0xc1cf, 0xf3c8, 0xf3ce, 0xc1ce, 0xf3cf, 0xf3cc,
  0xf3b7, 0xf3ba, 0xf3b0, 0xf3cb, 0xf3b4, 0xf3b2, 0xfc64, 0xfc63,
  0xfc69, 0xfc6a, 0xc1e3, 0xfc66, 0xfc7f, 0xf3cd, 0xfc68, 0xfc62,
  0xfc7e, 0xfc67, 0xfc6e, 0xfc60, 0xfc61, 0xfc7c, 0xfc7d, 0xf3c9,
  0xfc65, 0xfc6f, 0xfc6b, 0xc243, 0xc242, 0xfc6c, 0xfceb, 0xfcd0,
  0xfce8, 0xfcef, 0xfcee, 0xfcd1, 0xfcd2, 0xfcea, 0xfcec, 0xfced,
  0xfcd3, 0xfce9, 0xfd50, 0xfd53, 0xfd6d, 0xfd52, 0xfd6f, 0xfd6c,
  0xfd71, 0xfd76, 0xfdba, 0xfdb5, 0xfdc8, 0xc275, 0xc271, 0xfdc2,
  0xc270, 0xb7b2, 0xc0dd, 0xf2c4, 0xc25d, 0xc25c, 0xb7cd, 0xe4e3,
  0xbda5, 0xecfd, 0xe8bd, 0xe8bc, 0xe8a2, 0xeba6, 0xeba7, 0xc64a,
  0xf5d2, 0xeba1, 0xf5d3, 0xf7fe, 0xc05c, 0xc05e, 0xf7ff, 0xc05f,
  0xf1bc, 0xf1be, 0xf1bf, 0xf2c7, 0xc168, 0xc1e2, 0xfce5, 0xfd6e,
  0xfddf, 0xb7cc, 0xe0e8, 0xbaaf, 0xe8be, 0xe8bf, 0xeba0, 0xc059,
  0xc0dc, 0xf3ca, 0xfdc6, 0xb7cf, 0xbfff, 0xbaae, 0xf7f9, 0xfc79,
  0xb2cd, 0xeba3, 0xc269, 0xb2cc, 0xbaa9, 0xc645, 0xfc78, 0xb2cf,
  0xecfc, 0xc47f, 0xe8b9, 0xe8b8, 0xc47c, 0xeba2, 0xc641, 0xc647,
  0xc646, 0xc644, 0xf5ed, 0xc751, 0xf1b8, 0xf1b9, 0xf1ba, 0xf1bb,
  0xc0df, 0xf2c6, 0xf2c0, 0xf2c1, 0xc16b, 0xf3c5, 0xfc7b, 0xfc7a,
  0xc1fd, 0xfd69, 0xfd70, 0xc278, 0xd8bd, 0xe8bb, 0xebbd, 0xf7f8,
  0xe4e2, 0xebbc, 0xf5ef, 0xf5ec, 0xfc75, 0xc25f, 0xfd68, 0xfd73,
  0xbda4, 0xecff, 0xecfe, 0xe8ba, 0xbda7, 0xc750, 0xf5ee, 0xf2c2,
  0xc16a, 0xf2dd, 0xf2c3, 0xfc74, 0xfce4, 0xbda6, 0xebb9, 0xebbe,
  0xebbf, 0xf5e9, 0xf5e5, 0xf5ea, 0xf5eb, 0xf5e8, 0xc753, 0xf7fb,
  0xf1b4, 0xc0de, 0xf1b5, 0xf2dc, 0xf3c6, 0xf3c7, 0xc1c9, 0xf3c4,
  0xfc71, 0xfc76, 0xfc77, 0xbffe, 0xe8b5, 0xc640, 0xf7fa, 0xf7f5,
  0xf3c1, 0xfc70, 0xfce7, 0xfd6b, 0xfdb4, 0xfdd9, 0xbff9, 0xc643,
  0xf5e4, 0xf7f4, 0xf2df, 0xfc73, 0xbaab, 0xebb8, 0xf5e7, 0xf7f7,
  0xf7f6, 0xf7f1, 0xf1b3, 0xf1b7, 0xc165, 0xf1b0, 0xf1b1, 0xc0d9,
  0xf1b6, 0xc0db, 0xc0d8, 0xf2d9, 0xf2de, 0xc164, 0xc167, 0xc1cb,
  0xf3c0, 0xc1c8, 0xfcae, 0xfca9, 0xfcaf, 0xfcac, 0xc259, 0xfce6,
  0xfce1, 0xfce0, 0xc25e, 0xfd6a, 0xfd67, 0xfd64, 0xfd65, 0xfdde,
  0xc47e, 0xc768, 0xf1b2, 0xf2d8, 0xc1ca, 0xf3c3, 0xfdd8, 0xc479,
  0xebbb, 0xf3c2, 0xfdac, 0xcd47, 0xd9f1, 0xa547, 0xa55a, 0xa554,
  0xa556, 0xa552, 0xa56d, 0xa56e, 0xa569, 0xa56a, 0xa565, 0xa566,
  0xa561, 0xa562, 0xa57d, 0xa57e, 0xa579, 0xa57a, 0xa575, 0xa576,
  0xa571, 0xa5cb, 0xa5ca, 0xa5c7, 0xa5c6, 0xa5c5, 0xa5c4, 0xa551,
  0xa540, 0xa542, 0xa55c, 0xa55f, 0xa55e, 0xa559, 0xa570, 0xa573,
  0xa5ac, 0xa5af, 0xa5ae, 0xa5a9, 0xa5c1, 0xa5c0, 0xa5c3, 0xa5d3,
  0xa5d2, 0xa5ed, 0xa5ec, 0xa5ef, 0xa641, 0xa640, 0xa643, 0xa544,
  0xa5a0, 0xa64e, 0xa645, 0xa5a3, 0xa550, 0xa553, 0xa5a2, 0xa5c2,
  0xa54c, 0xa5dd, 0xa549, 0xa64c, 0xa6a2, 0xa6bd, 0xa6bc, 0xa6bf,
  0xa6be, 0xa6b9, 0xa6b8, 0xa6bb, 0xa6ba, 0xa6b5, 0xa54a, 0xa54b,
  0xa5d8, 0xa5da, 0xa5db, 0xa545, 0xa644, 0xa6c2, 0xa6dd, 0xa6dc,
  0xa6df, 0xa6de, 0xa6d9, 0xa6d8, 0xa6db, 0xa6da, 0xa6d5, 0xa6d4,
  0xa6d7, 0xa6d6, 0xa6d1, 0xa6d0, 0xa6d3, 0xa6d2, 0xa6ed, 0xa6ec,
  0xa6ef, 0xa6ee, 0xa6e9, 0xa6e8, 0xa6eb, 0xa6ea, 0xa6e5, 0xa64f,
  0xa5c9, 0xa6e4, 0xa6e7, 0xa6e6, 0xa6e1, 0xa6e0, 0xa6e3, 0xa6e2,
  0xa6fd, 0xa6fc, 0xa6ff, 0xa6fe, 0xa6f9, 0xa6f8, 0xa6fb, 0xa6fa,
  0xa6f5, 0xa6f4, 0xa6f7, 0xa6f6, 0xa6f1, 0xa6f0, 0xa6f3, 0xa74d,
  0xa74c, 0xa74f, 0xa74e, 0xa56c, 0xa558, 0xa56f, 0xa543
};

static const aciConvSummary16 big5_uni2indx_page00[ /*16*/ ] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x00ac }, {    4, 0x0083 },
  {    7, 0x0000 }, {    7, 0x0080 }, {    8, 0x0000 }, {    8, 0x0080 }
};

static const aciConvSummary16 big5_uni2indx_page02[ /*38*/ ] = {
  /* 0x0200 */
  {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 },
  {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 },
  {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 }, {    9, 0x0000 },
  {    9, 0x0e80 }, {   13, 0x0200 }, {   14, 0x0000 }, {   14, 0x0000 },
  /* 0x0300 */
  {   14, 0x0000 }, {   14, 0x0000 }, {   14, 0x0000 }, {   14, 0x0000 },
  {   14, 0x0000 }, {   14, 0x0000 }, {   14, 0x0000 }, {   14, 0x0000 },
  {   14, 0x0000 }, {   14, 0xfffe }, {   29, 0x03fb }, {   38, 0xfffe },
  {   53, 0x03fb }, {   62, 0x0000 }, {   62, 0x0000 }, {   62, 0x0000 },
  /* 0x0400 */
  {   62, 0x0002 }, {   63, 0x1ff0 }, {   72, 0xfff8 }, {   85, 0xffff },
  {  101, 0xffff }, {  117, 0x0002 }
};

static const aciConvSummary16 big5_uni2indx_page20[ /*44*/ ] = {
  /* 0x2000 */
  {  118, 0x0000 }, {  118, 0x3318 }, {  124, 0x0064 }, {  127, 0x4824 },
  {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 },
  {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 },
  {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 }, {  131, 0x0000 },
  /* 0x2100 */
  {  131, 0x0228 }, {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x0000 },
  {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x03ff }, {  144, 0x0000 },
  {  144, 0x0000 }, {  144, 0x03cf }, {  152, 0x0000 }, {  152, 0x0000 },
  {  152, 0x0000 }, {  152, 0x0000 }, {  152, 0x0000 }, {  152, 0x0000 },
  /* 0x2200 */
  {  152, 0x0000 }, {  152, 0xc400 }, {  155, 0x4e29 }, {  162, 0x1030 },
  {  165, 0x0000 }, {  165, 0x0004 }, {  166, 0x00c3 }, {  170, 0x0000 },
  {  170, 0x0000 }, {  170, 0x0000 }, {  170, 0x0020 }, {  171, 0x8000 }
};

static const aciConvSummary16 big5_uni2indx_page24[ /*37*/ ] = {
  /* 0x2400 */
  {  172, 0x0000 }, {  172, 0x0000 }, {  172, 0x0000 }, {  172, 0x0000 },
  {  172, 0x0000 }, {  172, 0x0000 }, {  172, 0x03ff }, {  182, 0x3ff0 },
  {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 },
  {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 },
  /* 0x2500 */
  {  192, 0x1005 }, {  195, 0x1111 }, {  199, 0x1010 }, {  201, 0x1010 },
  {  203, 0x0000 }, {  203, 0x4001 }, {  205, 0xe402 }, {  210, 0x000f },
  {  214, 0xfffe }, {  229, 0x0030 }, {  231, 0x0003 }, {  233, 0x300c },
  {  237, 0xc8c0 }, {  242, 0x0000 }, {  242, 0x003c }, {  246, 0x0000 },
  /* 0x2600 */
  {  246, 0x0260 }, {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 },
  {  249, 0x0007 }
};

static const aciConvSummary16 big5_uni2indx_page30[ /*62*/ ] = {
  /* 0x3000 */
  {  252, 0xff2f }, {  265, 0x6037 }, {  272, 0x03fe }, {  281, 0x0000 },
  {  281, 0xfffe }, {  296, 0xffff }, {  312, 0xffff }, {  328, 0xffff },
  {  344, 0xffff }, {  360, 0x600f }, {  366, 0xfffe }, {  381, 0xffff },
  {  397, 0xffff }, {  413, 0xffff }, {  429, 0xffff }, {  445, 0x407f },
  /* 0x3100 */
  {  453, 0xffe0 }, {  464, 0xffff }, {  480, 0x03ff }, {  490, 0x0000 },
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 },
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 },
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 },
  /* 0x3200 */
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 },
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0000 },
  {  490, 0x0000 }, {  490, 0x0000 }, {  490, 0x0008 }, {  491, 0x0000 },
  {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 },
  /* 0x3300 */
  {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 },
  {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 }, {  491, 0x0000 },
  {  491, 0xc000 }, {  493, 0x7000 }, {  496, 0x0002 }, {  497, 0x0000 },
  {  497, 0x4010 }, {  499, 0x0026 }
};

static const aciConvSummary16 big5_uni2indx_page4e[ /*1307*/ ] = {
  /* 0x4e00 */
  {  502, 0xff8b }, {  514, 0xc373 }, {  523, 0x6840 }, {  527, 0x1b0f },
  {  535, 0xe9ac }, {  544, 0xf34c }, {  553, 0x0200 }, {  554, 0xc008 },
  {  557, 0x795c }, {  566, 0xca3e }, {  575, 0x7976 }, {  585, 0x0648 },
  {  589, 0x2fdf }, {  601, 0xf7f0 }, {  612, 0x033a }, {  618, 0xa8ff },
  /* 0x4f00 */
  {  629, 0xef37 }, {  641, 0x233f }, {  650, 0xb004 }, {  654, 0xfd59 },
  {  665, 0xf3ca }, {  675, 0xffff }, {  691, 0xde9f }, {  703, 0xfff9 },
  {  717, 0xabff }, {  730, 0x7df7 }, {  743, 0xc000 }, {  745, 0x8eec },
  {  754, 0xeebf }, {  767, 0xffdb }, {  781, 0xd003 }, {  786, 0x45fa },
  /* 0x5000 */
  {  795, 0xfae1 }, {  805, 0xdffe }, {  819, 0xbfef }, {  833, 0x10ab },
  {  839, 0xffeb }, {  853, 0xfcaa }, {  863, 0xef3f }, {  876, 0x24fd },
  {  885, 0x78ad }, {  894, 0x7f76 }, {  906, 0xf00c }, {  912, 0xedff },
  {  926, 0xcff6 }, {  938, 0x2cfa }, {  947, 0xf7f9 }, {  960, 0xeb6b },
  /* 0x5100 */
  {  971, 0x1ffd }, {  983, 0x95bf }, {  994, 0x6677 }, { 1004, 0xbfbf },
  { 1018, 0x3bfb }, { 1030, 0xfeb4 }, { 1041, 0x7bae }, { 1052, 0x11e2 },
  { 1058, 0xa681 }, { 1064, 0x41be }, { 1072, 0x1435 }, { 1078, 0x72c3 },
  { 1086, 0x7d70 }, { 1095, 0x7191 }, { 1102, 0x0003 }, { 1104, 0x276b },
  /* 0x5200 */
  { 1113, 0x57cb }, { 1123, 0x70cf }, { 1132, 0x4732 }, { 1139, 0x0def },
  { 1149, 0x7eda }, { 1160, 0xfc74 }, { 1170, 0xfe06 }, { 1179, 0xbdb4 },
  { 1189, 0x3f9f }, { 1201, 0x8bca }, { 1209, 0x7e49 }, { 1218, 0x5800 },
  { 1221, 0x228f }, { 1228, 0xebec }, { 1239, 0x8a5c }, { 1246, 0xddbb },
  /* 0x5300 */
  { 1258, 0xef60 }, { 1267, 0xb6e7 }, { 1278, 0xa40f }, { 1285, 0xf293 },
  { 1294, 0x37bb }, { 1305, 0x549e }, { 1313, 0xd04b }, { 1320, 0x9baf },
  { 1331, 0xc414 }, { 1336, 0xf7d4 }, { 1347, 0x30b0 }, { 1352, 0x0a14 },
  { 1356, 0x2f08 }, { 1362, 0x88d0 }, { 1367, 0xff7e }, { 1381, 0x192f },
  /* 0x5400 */
  { 1389, 0xffda }, { 1402, 0xfb07 }, { 1412, 0x7ff1 }, { 1424, 0x7beb },
  { 1436, 0xc5ef }, { 1447, 0x0010 }, { 1448, 0x99ff }, { 1460, 0xfdff },
  { 1475, 0x79d7 }, { 1486, 0x0567 }, { 1493, 0xffe7 }, { 1507, 0xfdcb },
  { 1519, 0xc3ff }, { 1531, 0x4040 }, { 1533, 0x6ff7 }, { 1546, 0xbd8e },
  /* 0x5500 */
  { 1556, 0xdffa }, { 1569, 0x0497 }, { 1575, 0xf4c0 }, { 1582, 0x5bff },
  { 1595, 0xed7b }, { 1607, 0xd0e7 }, { 1616, 0x047e }, { 1623, 0xf8e0 },
  { 1631, 0xff9f }, { 1645, 0xb73e }, { 1656, 0x7dfe }, { 1669, 0x882e },
  { 1675, 0xfffd }, { 1690, 0xbe7f }, { 1703, 0x83fe }, { 1713, 0xf6c4 },
  /* 0x5600 */
  { 1722, 0xf357 }, { 1733, 0xb8fd }, { 1744, 0xd680 }, { 1750, 0xef7d },
  { 1763, 0x5767 }, { 1773, 0x4788 }, { 1779, 0xff7d }, { 1793, 0xc3df },
  { 1804, 0xf0ff }, { 1816, 0x37a9 }, { 1825, 0x7de0 }, { 1834, 0x70fc },
  { 1843, 0x3f6f }, { 1855, 0xec9a }, { 1864, 0x4cb3 }, { 1872, 0x8681 },
  /* 0x5700 */
  { 1877, 0x3f9e }, { 1888, 0xdd5c }, { 1898, 0xf70d }, { 1908, 0x4819 },
  { 1913, 0xfea3 }, { 1924, 0x0007 }, { 1927, 0xaf56 }, { 1937, 0x38ff },
  { 1948, 0x980d }, { 1954, 0xefb8 }, { 1965, 0x403d }, { 1971, 0xb760 },
  { 1979, 0xd8ce }, { 1988, 0x9035 }, { 1994, 0x72bf }, { 2005, 0x3fff },
  /* 0x5800 */
  { 2019, 0x7ff7 }, { 2033, 0x7a11 }, { 2040, 0xf7bb }, { 2053, 0xabff },
  { 2066, 0xff00 }, { 2074, 0x6fbe }, { 2086, 0xa93c }, { 2094, 0xfe72 },
  { 2105, 0xcfef }, { 2118, 0xf11b }, { 2127, 0xdb6b }, { 2138, 0xf40a },
  { 2145, 0xc3e6 }, { 2154, 0xef7e }, { 2167, 0x9b9c }, { 2176, 0xf610 },
  /* 0x5900 */
  { 2183, 0xf048 }, { 2189, 0x16f4 }, { 2197, 0xfeb5 }, { 2209, 0x5182 },
  { 2214, 0xc7b1 }, { 2223, 0x15bb }, { 2232, 0x6e87 }, { 2241, 0xfbdf },
  { 2255, 0xe43f }, { 2265, 0x63cd }, { 2274, 0xc1ff }, { 2285, 0x7e7e },
  { 2297, 0xfdeb }, { 2310, 0x7d5f }, { 2322, 0x777b }, { 2334, 0xfcfe },
  /* 0x5a00 */
  { 2347, 0x960b }, { 2354, 0xdbea }, { 2365, 0x6229 }, { 2371, 0x53e8 },
  { 2379, 0x37df }, { 2391, 0xfdef }, { 2405, 0x36f5 }, { 2415, 0xbd81 },
  { 2423, 0xdc18 }, { 2430, 0xfcbd }, { 2442, 0xd2e4 }, { 2450, 0xffff },
  { 2466, 0x3fd7 }, { 2478, 0xffe0 }, { 2489, 0x7f6f }, { 2502, 0xabf8 },
  /* 0x5b00 */
  { 2512, 0x9bae }, { 2522, 0x6ed9 }, { 2532, 0xf5fb }, { 2545, 0xf115 },
  { 2553, 0x79a9 }, { 2562, 0xbdfb }, { 2575, 0x5a3c }, { 2583, 0xadaf },
  { 2594, 0xdbba }, { 2605, 0x1fac }, { 2614, 0x71fc }, { 2624, 0x8379 },
  { 2632, 0x7cf7 }, { 2644, 0xc35f }, { 2654, 0xdfff }, { 2669, 0x0567 },
  /* 0x5c00 */
  { 2676, 0xff9a }, { 2688, 0x8467 }, { 2695, 0x1534 }, { 2701, 0xdf8b },
  { 2712, 0xf9f3 }, { 2724, 0x3373 }, { 2733, 0xf7bd }, { 2746, 0x5e1a },
  { 2754, 0xbf40 }, { 2762, 0xa03f }, { 2770, 0xffff }, { 2786, 0x01eb },
  { 2793, 0xdfc0 }, { 2802, 0xcfdd }, { 2814, 0x7500 }, { 2819, 0xabd3 },
  /* 0x5d00 */
  { 2829, 0xf8c3 }, { 2838, 0xeed6 }, { 2849, 0x43fd }, { 2859, 0xb7ff },
  { 2873, 0x5eaf }, { 2884, 0x4227 }, { 2890, 0x9bac }, { 2899, 0xf686 },
  { 2908, 0x27d7 }, { 2918, 0xf6bc }, { 2929, 0xf787 }, { 2940, 0x35b7 },
  { 2950, 0xaacd }, { 2959, 0xe176 }, { 2968, 0x49e7 }, { 2977, 0xe29f },
  /* 0x5e00 */
  { 2987, 0x545c }, { 2994, 0xaff2 }, { 3005, 0x2b3f }, { 3015, 0x61d8 },
  { 3022, 0xfc3b }, { 3033, 0xbbb8 }, { 3043, 0xffcf }, { 3057, 0x7b7d },
  { 3069, 0xbf95 }, { 3080, 0x1ce0 }, { 3086, 0x7dfd }, { 3099, 0x43ff },
  { 3110, 0x5ff6 }, { 3122, 0xfffe }, { 3137, 0xd3ef }, { 3149, 0xc4ce },
  /* 0x5f00 */
  { 3157, 0x8db6 }, { 3166, 0xadbc }, { 3176, 0x63dc }, { 3185, 0x11eb },
  { 3193, 0xdf59 }, { 3204, 0x23d0 }, { 3210, 0xbeb4 }, { 3220, 0xf3db },
  { 3232, 0x1fe7 }, { 3243, 0xdbc7 }, { 3254, 0xff63 }, { 3266, 0xfae4 },
  { 3276, 0xb22b }, { 3284, 0x63f7 }, { 3295, 0xed3b }, { 3306, 0xadba },
  /* 0x6000 */
  { 3316, 0xfe01 }, { 3324, 0x7eff }, { 3338, 0xfff7 }, { 3353, 0x02bc },
  { 3359, 0x32ff }, { 3370, 0xef39 }, { 3381, 0xfffc }, { 3395, 0x8005 },
  { 3398, 0x77fb }, { 3411, 0xbcf5 }, { 3422, 0x010d }, { 3426, 0xfff7 },
  { 3441, 0xfffb }, { 3456, 0xbf3a }, { 3467, 0x0057 }, { 3472, 0xdfff },
  /* 0x6100 */
  { 3487, 0xef7b }, { 3500, 0xbd7d }, { 3512, 0xdb88 }, { 3520, 0xc8d4 },
  { 3527, 0xfff3 }, { 3541, 0xed7c }, { 3552, 0x5dee }, { 3563, 0x56ff },
  { 3575, 0x7e0d }, { 3584, 0xac5f }, { 3594, 0xff96 }, { 3606, 0xd57f },
  { 3618, 0x3fee }, { 3630, 0xc140 }, { 3634, 0x6ff9 }, { 3646, 0xffe7 },
  /* 0x6200 */
  { 3660, 0x779b }, { 3671, 0x8e77 }, { 3681, 0x6ebf }, { 3693, 0xe45d },
  { 3702, 0x6fcf }, { 3714, 0x5f1f }, { 3725, 0xe07f }, { 3735, 0xfedf },
  { 3749, 0xd7db }, { 3761, 0x01fe }, { 3769, 0xff00 }, { 3777, 0xfb7b },
  { 3790, 0xffd4 }, { 3802, 0x1fdf }, { 3814, 0xf800 }, { 3819, 0xffff },
  /* 0x6300 */
  { 3835, 0xfb8f }, { 3847, 0x007b }, { 3853, 0xbf00 }, { 3860, 0x7f5c },
  { 3871, 0xffff }, { 3887, 0x07f3 }, { 3896, 0xeba0 }, { 3904, 0x3de7 },
  { 3915, 0xf7bf }, { 3929, 0xfbd7 }, { 3942, 0xffbf }, { 3957, 0x6003 },
  { 3961, 0xfffd }, { 3976, 0xbfed }, { 3989, 0xefbb }, { 4002, 0x027f },
  /* 0x6400 */
  { 4010, 0xfe40 }, { 4018, 0xddfd }, { 4031, 0xfdff }, { 4046, 0xe2f9 },
  { 4056, 0x680b }, { 4062, 0xfb1f }, { 4074, 0xfbe3 }, { 4086, 0xaffd },
  { 4099, 0x9fa4 }, { 4108, 0xf7ed }, { 4121, 0x7a7d }, { 4132, 0xf80f },
  { 4141, 0xeebe }, { 4153, 0x0fd5 }, { 4162, 0xbb5d }, { 4173, 0xfd9f },
  /* 0x6500 */
  { 4186, 0xf2db }, { 4197, 0x3bf9 }, { 4208, 0xfe7f }, { 4222, 0xebcc },
  { 4232, 0x876a }, { 4240, 0x73fa }, { 4251, 0x95fc }, { 4261, 0x9ffc },
  { 4273, 0x109f }, { 4280, 0xfaf7 }, { 4293, 0xddb7 }, { 4305, 0xbbcd },
  { 4316, 0xf87e }, { 4327, 0xeccd }, { 4337, 0xf366 }, { 4347, 0x3c3f },
  /* 0x6600 */
  { 4357, 0xfffd }, { 4372, 0xb03f }, { 4381, 0xe9f7 }, { 4393, 0x067e },
  { 4401, 0x96ae }, { 4410, 0xfe06 }, { 4419, 0xd576 }, { 4429, 0x5fd7 },
  { 4441, 0x3fd1 }, { 4451, 0xa3f3 }, { 4461, 0xcf07 }, { 4470, 0x6fb7 },
  { 4482, 0x9fd1 }, { 4492, 0x7f44 }, { 4501, 0x7b59 }, { 4511, 0xd3dd },
  /* 0x6700 */
  { 4522, 0xaf3b }, { 4533, 0xa9bd }, { 4543, 0x7dcf }, { 4555, 0xff3a },
  { 4567, 0xfbe0 }, { 4577, 0xf6eb }, { 4589, 0xb401 }, { 4594, 0xffff },
  { 4610, 0x7afa }, { 4621, 0xb7bf }, { 4634, 0xc000 }, { 4636, 0x0ffd },
  { 4647, 0xff7f }, { 4662, 0xff1f }, { 4675, 0xfefc }, { 4688, 0x95ff },
  /* 0x6800 */
  { 4700, 0x0000 }, { 4700, 0xb5dc }, { 4710, 0xef63 }, { 4721, 0x3f3e },
  { 4732, 0xfb7f }, { 4746, 0x001b }, { 4750, 0xe800 }, { 4754, 0xfbf6 },
  { 4767, 0x9eef }, { 4779, 0xb8df }, { 4790, 0xff9f }, { 4804, 0x003f },
  { 4810, 0x7bd0 }, { 4819, 0xf5ff }, { 4833, 0xdfdb }, { 4846, 0x3fff },
  /* 0x6900 */
  { 4860, 0xfdf0 }, { 4871, 0x00bf }, { 4878, 0x8420 }, { 4881, 0xbbbd },
  { 4893, 0xdf37 }, { 4905, 0xffde }, { 4919, 0xff6d }, { 4932, 0x0ff3 },
  { 4942, 0x604c }, { 4947, 0x5efb }, { 4959, 0xfffb }, { 4974, 0xfafb },
  { 4987, 0xfe5e }, { 4999, 0x0219 }, { 5003, 0x79f4 }, { 5013, 0xf9de },
  /* 0x6a00 */
  { 5025, 0xa7f7 }, { 5037, 0xebfa }, { 5049, 0x01eb }, { 5056, 0xff34 },
  { 5067, 0xebd3 }, { 5078, 0xef73 }, { 5090, 0xafd7 }, { 5102, 0xc040 },
  { 5105, 0x72bb }, { 5115, 0xdcff }, { 5128, 0xf17f }, { 5140, 0x2fd8 },
  { 5149, 0xb8ec }, { 5158, 0xfe0b }, { 5168, 0xdda3 }, { 5178, 0x1f0b },
  /* 0x6b00 */
  { 5186, 0x8f1d }, { 5195, 0x47cf }, { 5205, 0xb12b }, { 5213, 0xffde },
  { 5227, 0x7fee }, { 5240, 0xda73 }, { 5250, 0x24ff }, { 5260, 0xcbc4 },
  { 5268, 0xf75d }, { 5280, 0xcbf2 }, { 5290, 0xecfd }, { 5302, 0xb4ed },
  { 5312, 0xbff9 }, { 5325, 0x4ddd }, { 5335, 0x99dd }, { 5345, 0xfb8d },
  /* 0x6c00 */
  { 5356, 0xbb7f }, { 5369, 0xaf7b }, { 5381, 0xddfb }, { 5394, 0xc959 },
  { 5402, 0xfc4f }, { 5413, 0xfab5 }, { 5424, 0xafe3 }, { 5435, 0x6d5f },
  { 5446, 0xffff }, { 5462, 0x3f7d }, { 5474, 0x7800 }, { 5478, 0xffdb },
  { 5492, 0xb6ff }, { 5505, 0x7eff }, { 5519, 0xfbaf }, { 5532, 0x022f },
  /* 0x6d00 */
  { 5538, 0xff9b }, { 5551, 0xefc7 }, { 5563, 0xffa5 }, { 5575, 0xffff },
  { 5591, 0x0007 }, { 5594, 0xc700 }, { 5599, 0xf7ff }, { 5614, 0xfff1 },
  { 5627, 0x7ffd }, { 5641, 0x01bf }, { 5649, 0xdc00 }, { 5654, 0xfdbc },
  { 5666, 0xbff5 }, { 5679, 0xffff }, { 5695, 0xff7f }, { 5710, 0x3eff },
  /* 0x6e00 */
  { 5723, 0x0029 }, { 5726, 0xbe00 }, { 5732, 0xf9ff }, { 5746, 0xff7f },
  { 5761, 0x6efb }, { 5773, 0xfd7e }, { 5786, 0xcbff }, { 5799, 0x039e },
  { 5806, 0xe300 }, { 5811, 0xfbdd }, { 5824, 0xccff }, { 5836, 0xf6df },
  { 5849, 0xffff }, { 5865, 0x117f }, { 5874, 0xf800 }, { 5879, 0xfbf6 },
  /* 0x6f00 */
  { 5892, 0xe7ef }, { 5905, 0xd73c }, { 5915, 0xfeef }, { 5929, 0xdfef },
  { 5943, 0xc00b }, { 5948, 0xedbf }, { 5961, 0xfedf }, { 5975, 0xfdcd },
  { 5987, 0x7bf5 }, { 5999, 0x40fd }, { 6007, 0xffff }, { 6023, 0xb75f },
  { 6035, 0xffdf }, { 6050, 0xf930 }, { 6058, 0xfbdf }, { 6072, 0xdc97 },
  /* 0x7000 */
  { 6082, 0xfef3 }, { 6095, 0xbff2 }, { 6107, 0x8fdf }, { 6119, 0xdfbf },
  { 6133, 0x177f }, { 6144, 0xede6 }, { 6155, 0x0f7f }, { 6166, 0x3553 },
  { 6174, 0x447c }, { 6181, 0x877e }, { 6191, 0xfa12 }, { 6199, 0x45bb },
  { 6208, 0xede0 }, { 6217, 0x779e }, { 6228, 0x8017 }, { 6233, 0xbfd9 },
  /* 0x7100 */
  { 6245, 0x7e55 }, { 6255, 0xde89 }, { 6264, 0xc16f }, { 6273, 0x0447 },
  { 6278, 0x7ade }, { 6289, 0xf75d }, { 6301, 0x57ff }, { 6314, 0x2905 },
  { 6319, 0x86f7 }, { 6329, 0xfe95 }, { 6340, 0x97b3 }, { 6350, 0xf32f },
  { 6361, 0xcfff }, { 6375, 0x9f75 }, { 6386, 0x71f7 }, { 6397, 0xfb17 },
  /* 0x7200 */
  { 6408, 0x34ee }, { 6417, 0xee19 }, { 6426, 0x37cc }, { 6435, 0xef61 },
  { 6445, 0x9fd6 }, { 6456, 0xef4c }, { 6466, 0xd68f }, { 6476, 0xfbdd },
  { 6489, 0x7b73 }, { 6500, 0x6def }, { 6512, 0xd7fe }, { 6525, 0xa431 },
  { 6531, 0x5e7f }, { 6543, 0x97d7 }, { 6554, 0x0f5b }, { 6563, 0xffd8 },
  /* 0x7300 */
  { 6575, 0x9d83 }, { 6583, 0x7bce }, { 6594, 0x22ec }, { 6601, 0xdcff },
  { 6614, 0x763d }, { 6624, 0xef87 }, { 6635, 0xdfe7 }, { 6648, 0xfded },
  { 6661, 0x4fff }, { 6674, 0xa0fc }, { 6682, 0x3b77 }, { 6693, 0xdbfc },
  { 6705, 0x3ded }, { 6716, 0x7fdc }, { 6728, 0x6fa9 }, { 6738, 0xf570 },
  /* 0x7400 */
  { 6747, 0x3ffb }, { 6760, 0x2c40 }, { 6764, 0xff7f }, { 6779, 0x847f },
  { 6788, 0xec57 }, { 6798, 0xdeb7 }, { 6810, 0xe69c }, { 6819, 0xf22f },
  { 6829, 0x0feb }, { 6839, 0xd5b5 }, { 6849, 0xafeb }, { 6861, 0xede7 },
  { 6873, 0x8c2f }, { 6881, 0xfff0 }, { 6893, 0x537f }, { 6904, 0xe8f0 },
  /* 0x7500 */
  { 6912, 0xb99d }, { 6922, 0xb5ff }, { 6935, 0xff66 }, { 6947, 0xe78f },
  { 6958, 0xd981 }, { 6965, 0xbe10 }, { 6972, 0x9c7c }, { 6981, 0xe3c1 },
  { 6989, 0x9cd1 }, { 6997, 0x2733 }, { 7005, 0x0cbc }, { 7012, 0xff6d },
  { 7025, 0xfcb7 }, { 7037, 0xefb7 }, { 7050, 0xa0df }, { 7059, 0xffff },
  /* 0x7600 */
  { 7075, 0xbf0b }, { 7085, 0xfe7b }, { 7098, 0xa3ff }, { 7110, 0x353f },
  { 7120, 0x13cc }, { 7127, 0x97cd }, { 7137, 0x7637 }, { 7147, 0xfb27 },
  { 7158, 0xcfd6 }, { 7169, 0x7e6c }, { 7179, 0xec50 }, { 7186, 0xed31 },
  { 7195, 0x677c }, { 7205, 0xfc1c }, { 7214, 0xf6fa }, { 7226, 0x5fbf },
  /* 0x7700 */
  { 7239, 0x0fba }, { 7248, 0xae2f }, { 7258, 0xa3ad }, { 7267, 0x7ffe },
  { 7281, 0xfcf0 }, { 7291, 0xde74 }, { 7301, 0xffef }, { 7316, 0xf200 },
  { 7321, 0xfbbf }, { 7335, 0xfea2 }, { 7345, 0x3daf }, { 7356, 0xbcff },
  { 7369, 0xf694 }, { 7378, 0x5fb9 }, { 7389, 0xf3ad }, { 7400, 0x3f8f },
  /* 0x7800 */
  { 7411, 0xf26c }, { 7420, 0xa01f }, { 7427, 0xffef }, { 7442, 0x01bf },
  { 7450, 0x7728 }, { 7458, 0x7005 }, { 7463, 0xff35 }, { 7475, 0xda03 },
  { 7482, 0xd2f9 }, { 7492, 0xc7fa }, { 7503, 0x3fbf }, { 7516, 0x5c1d },
  { 7524, 0xff3a }, { 7536, 0xec33 }, { 7545, 0xb7af }, { 7557, 0xfe9c },
  /* 0x7900 */
  { 7568, 0x5236 }, { 7575, 0x7a9f }, { 7586, 0xbffa }, { 7599, 0xe722 },
  { 7607, 0x9ff7 }, { 7620, 0xfcff }, { 7634, 0x2fbb }, { 7645, 0xb61d },
  { 7654, 0xed06 }, { 7662, 0x1dfd }, { 7673, 0x7dd7 }, { 7685, 0xefdf },
  { 7699, 0xeb23 }, { 7708, 0xf166 }, { 7717, 0x7ed9 }, { 7728, 0x0dc0 },
  /* 0x7a00 */
  { 7733, 0x3d3d }, { 7743, 0xdfbf }, { 7757, 0xc945 }, { 7764, 0xba83 },
  { 7772, 0x7dd1 }, { 7782, 0x9dd0 }, { 7790, 0x7b87 }, { 7800, 0xcf73 },
  { 7811, 0x9ff3 }, { 7823, 0xc3f5 }, { 7833, 0xdf0d }, { 7843, 0xc5fe },
  { 7854, 0x0cb3 }, { 7861, 0x8302 }, { 7865, 0xe879 }, { 7874, 0xaec0 },
  /* 0x7b00 */
  { 7881, 0xc773 }, { 7891, 0x6f0f }, { 7901, 0xfd7d }, { 7914, 0x093f },
  { 7922, 0xfff1 }, { 7935, 0x0157 }, { 7941, 0x62fb }, { 7951, 0x01ff },
  { 7960, 0xfdb4 }, { 7971, 0x3bf3 }, { 7982, 0xb013 }, { 7988, 0x43b2 },
  { 7995, 0x5ed3 }, { 8005, 0xff30 }, { 8015, 0x0fff }, { 8027, 0xeb9f },
  /* 0x7c00 */
  { 8039, 0xfeef }, { 8053, 0xf203 }, { 8060, 0x3fef }, { 8073, 0xfb89 },
  { 8083, 0x37a9 }, { 8092, 0x9e99 }, { 8101, 0xdef9 }, { 8113, 0xa72c },
  { 8121, 0x3733 }, { 8130, 0xc1f6 }, { 8139, 0x812e }, { 8145, 0xfe3e },
  { 8157, 0x5d20 }, { 8163, 0xf2f7 }, { 8175, 0xd585 }, { 8183, 0x69d7 },
  /* 0x7d00 */
  { 8193, 0xffff }, { 8209, 0xffff }, { 8225, 0xdb07 }, { 8234, 0xff6f },
  { 8248, 0xc4ff }, { 8259, 0xd97f }, { 8271, 0xefce }, { 8283, 0xbe0f },
  { 8293, 0xf17b }, { 8304, 0xf05e }, { 8313, 0xf6cf }, { 8325, 0xffb7 },
  { 8339, 0x5ef7 }, { 8351, 0xef84 }, { 8360, 0xd7cb }, { 8371, 0x0edf },
  /* 0x7e00 */
  { 8381, 0xff08 }, { 8390, 0xfcff }, { 8404, 0xee3f }, { 8416, 0xffff },
  { 8432, 0x13ff }, { 8443, 0xd7ff }, { 8457, 0xaf0f }, { 8467, 0x7ffd },
  { 8481, 0xbdc7 }, { 8492, 0x1ffa }, { 8503, 0x0000 }, { 8503, 0x0000 },
  { 8503, 0x0000 }, { 8503, 0x0000 }, { 8503, 0x0000 }, { 8503, 0x0000 },
  /* 0x7f00 */
  { 8503, 0x0000 }, { 8503, 0x0000 }, { 8503, 0x0000 }, { 8503, 0xe740 },
  { 8510, 0xbd38 }, { 8519, 0xf933 }, { 8529, 0x7feb }, { 8542, 0xfeed },
  { 8555, 0x7fe8 }, { 8566, 0x7c76 }, { 8576, 0xb3f7 }, { 8588, 0xffef },
  { 8603, 0xfeaf }, { 8616, 0xd8b7 }, { 8626, 0xff6f }, { 8640, 0xfbbf },
  /* 0x8000 */
  { 8654, 0xf8fb }, { 8666, 0xdbf7 }, { 8679, 0x1752 }, { 8686, 0xe2f9 },
  { 8696, 0x85c8 }, { 8702, 0x7547 }, { 8711, 0x9090 }, { 8715, 0xe3ef },
  { 8727, 0x9ef4 }, { 8737, 0x3f6d }, { 8748, 0xee2e }, { 8758, 0x0536 },
  { 8764, 0xf7bc }, { 8776, 0x7ff3 }, { 8789, 0xa07b }, { 8797, 0x7f3f },
  /* 0x8100 */
  { 8810, 0x0567 }, { 8817, 0xeb60 }, { 8825, 0xbabe }, { 8836, 0x6601 },
  { 8841, 0xfcd8 }, { 8851, 0x583f }, { 8860, 0xcaf7 }, { 8871, 0x87df },
  { 8882, 0xbfcd }, { 8894, 0xffa0 }, { 8904, 0x5bcd }, { 8914, 0xfebf },
  { 8928, 0xb6fd }, { 8940, 0xefa7 }, { 8952, 0x77ef }, { 8965, 0xdf9c },
  /* 0x8200 */
  { 8976, 0x3fb7 }, { 8988, 0xf877 }, { 8999, 0x9d27 }, { 9008, 0xb7fc },
  { 9020, 0xcab5 }, { 9029, 0xdfef }, { 9043, 0xfb5a }, { 9054, 0xf1b6 },
  { 9064, 0xec39 }, { 9073, 0xef1f }, { 9085, 0xfbbf }, { 9099, 0x7ffb },
  { 9113, 0x000d }, { 9116, 0xdafe }, { 9128, 0xbdfb }, { 9141, 0x4e7f },
  /* 0x8300 */
  { 9152, 0x33ff }, { 9164, 0x5ac0 }, { 9170, 0xbff5 }, { 9183, 0x9ffe },
  { 9196, 0xffbf }, { 9211, 0x005f }, { 9217, 0x0000 }, { 9217, 0xfdf8 },
  { 9229, 0xffca }, { 9241, 0x6ffd }, { 9254, 0xcffd }, { 9267, 0xa001 },
  { 9270, 0xdfff }, { 9285, 0xfbf2 }, { 9297, 0xdfbf }, { 9311, 0xff7f },
  /* 0x8400 */
  { 9326, 0xfeda }, { 9338, 0x080f }, { 9343, 0xba08 }, { 9349, 0xbfff },
  { 9364, 0x7afd }, { 9376, 0xeed7 }, { 9388, 0xfbeb }, { 9401, 0x67f9 },
  { 9412, 0xe044 }, { 9417, 0xff93 }, { 9429, 0xdf97 }, { 9441, 0x9f57 },
  { 9452, 0xfef7 }, { 9466, 0x08df }, { 9474, 0xdf80 }, { 9482, 0xfedf },
  /* 0x8500 */
  { 9496, 0xffc5 }, { 9508, 0xf7fe }, { 9522, 0xfffb }, { 9537, 0x6803 },
  { 9542, 0x67fb }, { 9554, 0x6bfa }, { 9565, 0x7fff }, { 9580, 0x5fe2 },
  { 9590, 0xffff }, { 9606, 0xff73 }, { 9619, 0x87df }, { 9630, 0xe7fb },
  { 9643, 0xebfd }, { 9656, 0xf7a7 }, { 9668, 0xbf7e }, { 9681, 0xefc7 },
  /* 0x8600 */
  { 9693, 0x1ef3 }, { 9703, 0xdf82 }, { 9712, 0x76ff }, { 9725, 0xdf7e },
  { 9738, 0x79c9 }, { 9747, 0xda7d }, { 9758, 0xefbe }, { 9771, 0x1e9b },
  { 9780, 0x7ce0 }, { 9788, 0x77fb }, { 9801, 0x87be }, { 9811, 0xfffb },
  { 9826, 0x1bff }, { 9838, 0xffdb }, { 9852, 0x3f5c }, { 9862, 0x4fe0 },
  /* 0x8700 */
  { 9870, 0x7fff }, { 9885, 0x5f0e }, { 9894, 0x77ff }, { 9908, 0xddbf },
  { 9921, 0xf04f }, { 9930, 0xffff }, { 9946, 0xffff }, { 9962, 0x0ff8 },
  { 9971, 0xa3be }, { 9981, 0xfddf }, { 9995, 0xfc1c }, { 10004, 0xfffd },
  { 10019, 0x1f7d }, { 10030, 0xfb9e }, { 10042, 0xbdff }, { 10056, 0xdedc },
  /* 0x8800 */
  { 10067, 0x3f6f }, { 10079, 0xbafb }, { 10091, 0xdf7f }, { 10105, 0xfbef },
  { 10119, 0x7d1b }, { 10129, 0x2eec }, { 10138, 0xaf8e }, { 10148, 0xf2f7 },
  { 10160, 0x7b0f }, { 10170, 0xcfee }, { 10182, 0x1d96 }, { 10190, 0x77c6 },
  { 10200, 0x7e07 }, { 10209, 0xfff5 }, { 10223, 0xd982 }, { 10230, 0x7fdf },
  /* 0x8900 */
  { 10244, 0x5ee6 }, { 10254, 0xc7ff }, { 10267, 0xfeee }, { 10280, 0x79ef },
  { 10292, 0x9a56 }, { 10300, 0xffcf }, { 10314, 0xfe5f }, { 10327, 0xde5e },
  { 10338, 0x896e }, { 10346, 0xf9e8 }, { 10356, 0xf45e }, { 10366, 0xe6c4 },
  { 10374, 0x0001 }, { 10375, 0xbe7c }, { 10386, 0x3b7f }, { 10398, 0xdddf },
  /* 0x8a00 */
  { 10411, 0xd59d }, { 10421, 0xe9ef }, { 10433, 0x34ac }, { 10440, 0xde53 },
  { 10450, 0xf573 }, { 10461, 0x4bf7 }, { 10472, 0x7b4f }, { 10483, 0x9eff },
  { 10496, 0xb8fe }, { 10507, 0x476e }, { 10516, 0x0dfb }, { 10526, 0xff45 },
  { 10537, 0xabfd }, { 10549, 0xfbfe }, { 10563, 0xe9d7 }, { 10574, 0xddff },
  /* 0x8b00 */
  { 10588, 0xedf7 }, { 10601, 0x7fff }, { 10616, 0xddfd }, { 10629, 0x7eeb },
  { 10641, 0xcfe7 }, { 10653, 0xb7ff }, { 10667, 0xbde9 }, { 10678, 0xef91 },
  { 10688, 0x5d75 }, { 10698, 0xd77c }, { 10709, 0x0000 }, { 10709, 0x0000 },
  { 10709, 0x0000 }, { 10709, 0x0000 }, { 10709, 0x0000 }, { 10709, 0x0000 },
  /* 0x8c00 */
  { 10709, 0x0000 }, { 10709, 0x0000 }, { 10709, 0x0000 }, { 10709, 0xfa80 },
  { 10716, 0xffee }, { 10730, 0xb4f1 }, { 10739, 0xbf76 }, { 10751, 0x2fef },
  { 10763, 0xb677 }, { 10774, 0x77bf }, { 10787, 0x9fbf }, { 10800, 0xfffd },
  { 10815, 0x95bf }, { 10826, 0xf6ae }, { 10837, 0x75ff }, { 10850, 0x7f3b },
  /* 0x8d00 */
  { 10862, 0xa7f5 }, { 10873, 0x0af9 }, { 10881, 0x0000 }, { 10881, 0x0000 },
  { 10881, 0x0000 }, { 10881, 0x0000 }, { 10881, 0xfbd0 }, { 10891, 0x2bdd },
  { 10901, 0xf633 }, { 10911, 0x9a7f }, { 10922, 0xfdab }, { 10934, 0xd6fc },
  { 10945, 0xf9e6 }, { 10956, 0xbfeb }, { 10969, 0xdfdf }, { 10983, 0xf41f },
  /* 0x8e00 */
  { 10993, 0xa6fd }, { 11004, 0xffff }, { 11020, 0x4aff }, { 11031, 0xf37b },
  { 11043, 0x7fb7 }, { 11056, 0xfef9 }, { 11069, 0xb6ff }, { 11082, 0x1d5c },
  { 11090, 0x7ff6 }, { 11103, 0xe5ff }, { 11116, 0x1f7b }, { 11127, 0x2404 },
  { 11130, 0xbe05 }, { 11138, 0xf99e }, { 11149, 0xdbe3 }, { 11160, 0xdff2 },
  /* 0x8f00 */
  { 11172, 0x6fef }, { 11185, 0xfdff }, { 11200, 0xd679 }, { 11210, 0xcbfc },
  { 11221, 0xebfd }, { 11234, 0xefff }, { 11249, 0x001f }, { 11254, 0x0000 },
  { 11254, 0x0000 }, { 11254, 0x9800 }, { 11257, 0xe148 }, { 11263, 0x8017 },
  { 11268, 0x6a74 }, { 11276, 0x00fe }, { 11283, 0x6d7f }, { 11295, 0xfdf1 },
  /* 0x9000 */
  { 11307, 0xb87f }, { 11318, 0xfef3 }, { 11331, 0xe01f }, { 11339, 0xf176 },
  { 11349, 0xee96 }, { 11359, 0x7b3f }, { 11371, 0xeb8d }, { 11381, 0xfffd },
  { 11396, 0xadff }, { 11409, 0xcbb3 }, { 11419, 0x84ef }, { 11428, 0xe17f },
  { 11439, 0x4daa }, { 11447, 0xbff0 }, { 11458, 0xbf3f }, { 11471, 0xfe3f },
  /* 0x9100 */
  { 11484, 0xebff }, { 11498, 0xffd7 }, { 11512, 0xffdf }, { 11527, 0xcf7f },
  { 11540, 0xfffb }, { 11555, 0x85ed }, { 11564, 0xd73f }, { 11576, 0x07bc },
  { 11584, 0xaeff }, { 11597, 0xfe0f }, { 11608, 0xfdaf }, { 11621, 0x76bf },
  { 11633, 0xfaef }, { 11646, 0x37bb }, { 11657, 0x7fdc }, { 11669, 0xa3ba },
  /* 0x9200 */
  { 11678, 0xb6ff }, { 11691, 0x56f7 }, { 11702, 0x60f8 }, { 11709, 0xe7df },
  { 11722, 0xff61 }, { 11733, 0x4cdf }, { 11743, 0xb0fb }, { 11753, 0xff45 },
  { 11764, 0x7ded }, { 11776, 0x3ffa }, { 11788, 0x1fff }, { 11801, 0x18fc },
  { 11809, 0xffff }, { 11825, 0xe3af }, { 11836, 0xc7d3 }, { 11846, 0xdf83 },
  /* 0x9300 */
  { 11856, 0xfb57 }, { 11868, 0xef7d }, { 11881, 0xefff }, { 11896, 0x1378 },
  { 11903, 0xfec0 }, { 11912, 0x5ff7 }, { 11925, 0x34bb }, { 11934, 0x5ee3 },
  { 11944, 0xf70d }, { 11954, 0xeff6 }, { 11967, 0xd7fe }, { 11980, 0x00bf },
  { 11987, 0xf59d }, { 11998, 0xf7f7 }, { 12012, 0x51de }, { 12021, 0xffe0 },
  /* 0x9400 */
  { 12032, 0xfec9 }, { 12043, 0x037f }, { 12052, 0x5f01 }, { 12059, 0xbfef },
  { 12073, 0x9ff1 }, { 12084, 0x60a7 }, { 12091, 0xef1d }, { 12102, 0xf1ff },
  { 12115, 0x000f }, { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 },
  { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 },
  /* 0x9500 */
  { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 },
  { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x0000 }, { 12119, 0x3c80 },
  { 12124, 0xfb4d }, { 12135, 0xd91f }, { 12145, 0x7b3a }, { 12155, 0xfee3 },
  { 12167, 0x3fe9 }, { 12178, 0xdc7f }, { 12190, 0x003f }, { 12196, 0x0000 },
  /* 0x9600 */
  { 12196, 0x0000 }, { 12196, 0x5000 }, { 12198, 0xf51f }, { 12209, 0xbe07 },
  { 12218, 0xfc1d }, { 12228, 0xf91b }, { 12238, 0xbc1e }, { 12247, 0x71ff },
  { 12259, 0x6ff9 }, { 12271, 0x5bbe }, { 12282, 0x5796 }, { 12291, 0x9b1b },
  { 12300, 0x7fff }, { 12315, 0xfffc }, { 12329, 0x872e }, { 12337, 0xafe7 },
  /* 0x9700 */
  { 12349, 0xebf5 }, { 12361, 0xf34f }, { 12372, 0xdffd }, { 12386, 0xe725 },
  { 12395, 0x0bdc }, { 12403, 0x5d44 }, { 12410, 0x5747 }, { 12419, 0xfddd },
  { 12432, 0xed3f }, { 12444, 0x7790 }, { 12452, 0x7d7f }, { 12465, 0x8ac8 },
  { 12471, 0xfafa }, { 12483, 0xf3f9 }, { 12495, 0x202a }, { 12499, 0xef4b },
  /* 0x9800 */
  { 12510, 0xf5ff }, { 12524, 0x79cf }, { 12535, 0xabd3 }, { 12545, 0x0ba5 },
  { 12552, 0xf77a }, { 12564, 0xfb8f }, { 12576, 0x8ebd }, { 12586, 0x001f },
  { 12591, 0x0000 }, { 12591, 0x0000 }, { 12591, 0xf300 }, { 12597, 0xfd4e },
  { 12608, 0x1a57 }, { 12616, 0x8800 }, { 12618, 0xaeac }, { 12627, 0x7654 },
  /* 0x9900 */
  { 12635, 0x17ad }, { 12644, 0xcdff }, { 12657, 0xffb2 }, { 12669, 0xf42f },
  { 12679, 0x5baa }, { 12688, 0xdbff }, { 12702, 0x0002 }, { 12703, 0x0000 },
  { 12703, 0x0000 }, { 12703, 0x73c0 }, { 12710, 0xf9ea }, { 12721, 0x2e3f },
  { 12731, 0xfa8e }, { 12741, 0xbbff }, { 12755, 0x76bc }, { 12765, 0xffd3 },
  /* 0x9a00 */
  { 12778, 0xeefe }, { 12791, 0x7e72 }, { 12801, 0x7ebd }, { 12813, 0xe7f7 },
  { 12826, 0xf77f }, { 12840, 0xcefd }, { 12852, 0x0ff5 }, { 12862, 0x0000 },
  { 12862, 0x0000 }, { 12862, 0x0000 }, { 12862, 0xa900 }, { 12866, 0xdb9b },
  { 12877, 0xa4c7 }, { 12885, 0x917f }, { 12895, 0xf8ca }, { 12904, 0x7ece },
  /* 0x9b00 */
  { 12915, 0x7d7a }, { 12926, 0xc7e7 }, { 12937, 0xcbbd }, { 12948, 0xdcae },
  { 12958, 0xfd7e }, { 12971, 0x8f76 }, { 12981, 0x91d3 }, { 12989, 0x7cf3 },
  { 13000, 0x01e5 }, { 13006, 0x4c2f }, { 13014, 0xed77 }, { 13026, 0xa360 },
  { 13032, 0x07db }, { 13041, 0x5ef8 }, { 13051, 0x1df7 }, { 13062, 0x2181 },
  /* 0x9c00 */
  { 13066, 0x6be0 }, { 13074, 0x309c }, { 13080, 0x3b3a }, { 13089, 0xfade },
  { 13101, 0x7f53 }, { 13112, 0xc3f5 }, { 13122, 0x61cd }, { 13130, 0x07ba },
  { 13138, 0x0000 }, { 13138, 0x0000 }, { 13138, 0x0000 }, { 13138, 0x0000 },
  { 13138, 0x0000 }, { 13138, 0x0000 }, { 13138, 0x26e0 }, { 13144, 0xbefe },
  /* 0x9d00 */
  { 13157, 0x03f9 }, { 13165, 0xebb5 }, { 13176, 0xe36d }, { 13186, 0xe9cb },
  { 13196, 0x9c2f }, { 13205, 0xbfde }, { 13218, 0x9f83 }, { 13227, 0xabbf },
  { 13239, 0x1ff7 }, { 13251, 0xffd5 }, { 13264, 0xb7df }, { 13277, 0xdffe },
  { 13291, 0xfdae }, { 13303, 0xffef }, { 13318, 0xfb7e }, { 13331, 0xeffd },
  /* 0x9e00 */
  { 13345, 0xaaff }, { 13357, 0x6ebf }, { 13369, 0x0000 }, { 13369, 0x0000 },
  { 13369, 0x0000 }, { 13369, 0x0000 }, { 13369, 0x0000 }, { 13369, 0xb620 },
  { 13375, 0x7fcd }, { 13387, 0xbe9e }, { 13398, 0x62b3 }, { 13406, 0x58f1 },
  { 13414, 0xf10d }, { 13422, 0xfd7b }, { 13435, 0xe9f1 }, { 13445, 0xbefd },
  /* 0x9f00 */
  { 13458, 0xc6c3 }, { 13466, 0x5f6d }, { 13477, 0xff3d }, { 13490, 0x69ff },
  { 13502, 0xffcf }, { 13516, 0xfbf4 }, { 13528, 0xdcfb }, { 13540, 0x4ff7 },
  { 13552, 0x2000 }, { 13553, 0x1137 }, { 13560, 0x0015 }
};

static const aciConvSummary16 big5_uni2indx_pagefa[ /*1*/ ] = {
  /* 0xfa00 */
  { 13563, 0x3000 }
};

static const aciConvSummary16 big5_uni2indx_pagefe[ /*23*/ ] = {
  /* 0xfe00 */
  { 13565, 0x0000 }, { 13565, 0x0000 }, { 13565, 0x0000 }, { 13565, 0xfffb },
  { 13580, 0xfe1f }, { 13592, 0xfef5 }, { 13605, 0x0e7f }, { 13615, 0x0000 },
  { 13615, 0x0000 }, { 13615, 0x0000 }, { 13615, 0x0000 }, { 13615, 0x0000 },
  { 13615, 0x0000 }, { 13615, 0x0000 }, { 13615, 0x0000 }, { 13615, 0x0000 },
  /* 0xff00 */
  { 13615, 0xff7a }, { 13628, 0xffff }, { 13644, 0xffff }, { 13660, 0x97ff },
  { 13673, 0xfffe }, { 13688, 0x3fff }, { 13702, 0x0010 }
};

ACP_EXPORT acp_sint32_t aciConvConvertMbToWc4Big5( void   * aSrc,
                                                   acp_sint32_t     aSrcRemain,
                                                   acp_sint32_t   * aSrcAdvance,
                                                   void   * aDest,
                                                   acp_sint32_t     aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      BIG5 ==> UTF16
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t   * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint32_t      i;
    acp_uint16_t    wc;
    acp_sint32_t      sRet;

    /* Code set 0 (ASCII) */
    if (sSrcCharPtr[0] < 0x80)
    {
        sRet = aciConvConvertMbToWc4Ascii(aSrc, aSrcRemain, aSrcAdvance, aDest,
                                          aDestRemain);
    }
    else
    {
        if( (sSrcCharPtr[0] >= 0xa1 && sSrcCharPtr[0] <= 0xc7) || 
            (sSrcCharPtr[0] >= 0xc9 && sSrcCharPtr[0] <= 0xf9) )
        {
            if (aSrcRemain >= 2)
            {
                if( (sSrcCharPtr[1] >= 0x40 && sSrcCharPtr[1] < 0x7f) || 
                    (sSrcCharPtr[1] >= 0xa1 && sSrcCharPtr[1] < 0xff) )
                {
                    i = 157 * (sSrcCharPtr[0] - 0xa1) + 
                        (sSrcCharPtr[1] - (sSrcCharPtr[1] >= 0xa1 ? 0x62 : 0x40));

                    wc = 0xfffd;

                    if (i < 6280)
                    {
                        if (i < 6121)
                        {
                            wc = big5_2uni_pagea1[i] ^ BIG5_XOR_VALUE;
                        }
                        else
                        {
                            /* Nothing to do */
                        }
                    }
                    else
                    {
                        if (i < 13932)
                        {
                            wc = big5_2uni_pagec9[i-6280] ^ BIG5_XOR_VALUE;
                        }
                        else
                        {
                            /* Nothing to do */
                        }
                    
                    }

                    if (wc != 0xfffd)
                    {
                        ACICONV_WC_TO_UTF16BE(aDest, wc);
                        sRet = 2;
                        *aSrcAdvance = 2;
                    }
                    else
                    {
                        sRet = ACICONV_RET_ILSEQ;
                        *aSrcAdvance = 2;
                    }
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_TOOFEW;
                *aSrcAdvance = aSrcRemain;
            }
        }
        else
        {
            sRet = ACICONV_RET_ILSEQ;
            *aSrcAdvance = 1;
        }
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvConvertWcToMb4Big5( void   * aSrc,
                                                   acp_sint32_t     aSrcRemain,
                                                   acp_sint32_t   * aSrcAdvance,
                                                   void   * aDest,
                                                   acp_sint32_t     aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      BIG5 <== UTF16
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16   * sSummary = NULL;
    acp_uint16_t              sUsed;
    acp_uint8_t             * sDestCharPtr = NULL;
    acp_sint32_t                sRet;
    acp_uint16_t              c;
    acp_uint32_t                i;
    acp_uint16_t              wc;
    
    sRet = aciConvConvertWcToMb4Ascii( aSrc, aSrcRemain, aSrcAdvance, aDest,
                                       aDestRemain );

    if( sRet != ACICONV_RET_ILUNI )
    {
        /* Nothing to do */
    }
    else
    {
        ACICONV_UTF16BE_TO_WC( wc, aSrc );
        sDestCharPtr = (acp_uint8_t *)aDest;
    
        if (aDestRemain >= 2)
        {
            if (wc < 0x0100)
            {
                sSummary = &big5_uni2indx_page00[(wc>>4)];
            }
            else if (wc >= 0x0200 && wc < 0x0460)
            {
                sSummary = &big5_uni2indx_page02[(wc>>4)-0x020];
            }
            else if (wc >= 0x2000 && wc < 0x22c0)
            {
                sSummary = &big5_uni2indx_page20[(wc>>4)-0x200];
            }
            else if (wc >= 0x2400 && wc < 0x2650)
            {
                sSummary = &big5_uni2indx_page24[(wc>>4)-0x240];
            }
            else if (wc >= 0x3000 && wc < 0x33e0)
            {
                sSummary = &big5_uni2indx_page30[(wc>>4)-0x300];
            }
            else if (wc >= 0x4e00 && wc < 0x9fb0)
            {
                sSummary = &big5_uni2indx_page4e[(wc>>4)-0x4e0];
            }
            else if (wc >= 0xfa00 && wc < 0xfa10)
            {
                sSummary = &big5_uni2indx_pagefa[(wc>>4)-0xfa0];
            }
            else if (wc >= 0xfe00 && wc < 0xff70)
            {
                sSummary = &big5_uni2indx_pagefe[(wc>>4)-0xfe0];
            }
            else
            {
                /* Nothing to do */
            }
        
            if (sSummary != NULL)
            {
                sUsed = sSummary->used;

                i = wc & 0x0f;

                if (sUsed & ((acp_uint16_t) 1 << i))
                {
                    /* Keep in `sUsed' only the bits 0..i-1. */
                    sUsed &= ((acp_uint16_t) 1 << i) - 1;

                    /*Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                    sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                    sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                    sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                    sUsed = (sUsed & 0x00ff) + (sUsed >> 8);

                    c = big5_2charset[sSummary->indx + sUsed] ^ BIG5_XOR_VALUE;

                    sDestCharPtr[0] = (c >> 8); 
                    sDestCharPtr[1] = (c & 0xff);

                    sRet = 2;
                    *aSrcAdvance = 2;
                }
                else
                {
                    sRet = ACICONV_RET_ILUNI;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_TOOSMALL;
            *aSrcAdvance = aSrcRemain;
        }
    }

    return sRet;
}
 
