/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id$
 **********************************************************************/

#include <aciConvCp932ext.h>

static const acp_uint16_t gCp932Ext2UniPage87[ /*92*/ ] = {
    0x78db, 0x78da, 0x78d9, 0x78d8, 0x78df, 0x78de, 0x78dd, 0x78dc,
    0x78d3, 0x78d2, 0x78d1, 0x78d0, 0x78d7, 0x78d6, 0x78d5, 0x78d4,
    0x78cb, 0x78ca, 0x78c9, 0x78c8, 0x7ddb, 0x7dda, 0x7dd9, 0x7dd8,
    0x7ddf, 0x7dde, 0x7ddd, 0x7ddc, 0x7dd3, 0x7dd2, 0xa346, 0x6ff2,
    0x6faf, 0x6f99, 0x6ff6, 0x6fa3, 0x6f9c, 0x6fb8, 0x6f8d, 0x6fea,
    0x6fec, 0x6fb6, 0x6f9d, 0x6f98, 0x6f90, 0x6ff1, 0x6f80, 0x6f27,
    0x6f26, 0x6f25, 0x6f35, 0x6f34, 0x6f7f, 0x6f1a, 0xa346, 0xa346,
    0xa346, 0xa346, 0xa346, 0xa346, 0xa346, 0xa346, 0x6fc0, 0x6ca6,
    0x6ca4, 0x7dad, 0x6f76, 0x7d9a, 0x6e1f, 0x6e1e, 0x6e1d, 0x6e1c,
    0x6e13, 0x6e8a, 0x6e89, 0x6e82, 0x6fc5, 0x6fc6, 0x6fc7, 0x7ee9,
    0x7eda, 0x7e90, 0x7e95, 0x7eaa, 0x7ea1, 0x7e1e, 0x7e9b, 0x7ea4,
    0x7e04, 0x7e8e, 0x7e92, 0x7e91
};

static const acp_uint16_t gCp932Ext2UniPageed[ /*376*/ ] = {
    0x2231, 0xd5a7, 0xcff3, 0xce33, 0xd867, 0x1372, 0x2c00, 0x3a8a,
    0x3473, 0xce42, 0x3a40, 0x03fe, 0x1293, 0x125a, 0x1247, 0x13bb,
    0x13b8, 0x1382, 0x13ed, 0x1329, 0x1331, 0x1321, 0x132f, 0x1376,
    0x0cfb, 0x0c99, 0x1344, 0x0ca5, 0x0cfd, 0x0ccb, 0x0cf9, 0x0c2f,
    0x0c4f, 0x0c63, 0x0df1, 0x0ddf, 0x0d26, 0x0d05, 0x0d57, 0x0eae,
    0x0e27, 0x0e1d, 0x0e7b, 0x0e60, 0x0fbb, 0x0fbc, 0x0f9f, 0x0fc9,
    0x0f28, 0x0f09, 0x0f66, 0xa6b5, 0x0827, 0x0831, 0x0812, 0x0844,
    0x093d, 0x0be2, 0x0bde, 0x0b17, 0x0b73, 0x0b7c, 0xa6b4, 0xa6ab,
    0x0425, 0x0409, 0x05b0, 0x05e8, 0x05e0, 0x05e6, 0x05d8, 0x051f,
    0x0501, 0x07ed, 0x077b, 0x2994, 0x0763, 0x0757, 0x00a5, 0x001d,
    0x0001, 0x004e, 0x019c, 0x01e8, 0xa6aa, 0x01f9, 0x01d6, 0x0103,
    0x0102, 0x016b, 0x039a, 0x038f, 0x03dc, 0x030c, 0x0365, 0x3ce6,
    0x3c3e, 0x3c31, 0x3c65, 0x3c6e, 0x3d9b, 0x3c49, 0x3daa, 0x3d8c,
    0x3d8b, 0x3d23, 0x3ea8, 0x3e1d, 0x3f4e, 0x38db, 0x3826, 0x3875,
    0x39f5, 0x3abb, 0x3aae, 0x3a80, 0x3ab2, 0x3a95, 0x3aa5, 0x3a9f,
    0x3ade, 0x3aec, 0x3ae2, 0xa6a9, 0x3ac8, 0x3a22, 0x3a1b, 0x3a09,
    0x3a04, 0x3a41, 0x3bb5, 0xa592, 0x3bdd, 0x3b00, 0x34e9, 0x3b7b,
    0x34ba, 0x34ff, 0x3474, 0xa6a8, 0x35d3, 0xa6af, 0x3523, 0x3559,
    0x368b, 0x36d0, 0x36fd, 0x36c8, 0x36c5, 0x3659, 0x365f, 0x376d,
    0x3084, 0x30e7, 0x303d, 0x30d4, 0x3061, 0x31bf, 0x313c, 0x31d4,
    0x312d, 0x3117, 0x3174, 0x3143, 0x3149, 0x3147, 0x3282, 0x32e7,
    0x329c, 0x3287, 0x3204, 0x3333, 0x330e, 0x334e, 0x2cbe, 0x2cbc,
    0x2c93, 0x2c3e, 0x2c10, 0x2db4, 0x2dbf, 0x2de7, 0x2dfd, 0x2dfc,
    0xa6ae, 0x2d7a, 0x2d45, 0x2e0a, 0x2e05, 0x2f9f, 0xa6ad, 0x2fcc,
    0x2f06, 0x2f72, 0x2f6d, 0x2f58, 0x2f69, 0x28bc, 0x2f4e, 0x289d,
    0x2891, 0x2892, 0x2895, 0x28d9, 0x2832, 0x2824, 0x29ba, 0x29d4,
    0x2a39, 0x2a27, 0x2a25, 0x2a20, 0x2a1d, 0xa6ac, 0x2bfd, 0x0e14,
    0x249a, 0x24f5, 0x24df, 0x24c1, 0x258b, 0xa6a3, 0xa6a2, 0xa6a1,
    0x252f, 0xa6a0, 0x2520, 0x266a, 0x265c, 0xa6a7, 0x2650, 0x2725,
    0xa6a6, 0x21f3, 0x21e7, 0x210c, 0x211b, 0x216d, 0x22e9, 0x23fc,
    0x231a, 0xa6a5, 0xdfba, 0xdfd9, 0xdfc4, 0xdf7c, 0xdf4d, 0xd8f3,
    0xd80f, 0xd9e8, 0xd9e2, 0xd9d0, 0xa6a4, 0xd90b, 0xa69b, 0xa69a,
    0xd4bc, 0xd44e, 0xd6a9, 0xd68c, 0xd6c2, 0xd61c, 0xd605, 0xd664,
    0xa699, 0xd64d, 0xd7e8, 0xd7c4, 0xd04b, 0xd04f, 0xd1a9, 0xd1cd,
    0xa698, 0xd274, 0xa69f, 0xa69e, 0xccdc, 0xcc65, 0xa69d, 0xcdae,
    0xcd9c, 0xcd61, 0xcd6c, 0xcd65, 0xcd56, 0xcd55, 0xcd5f, 0xcd5e,
    0xcebd, 0xceab, 0xceb1, 0xce81, 0xcefb, 0xce87, 0xcef5, 0xcee2,
    0xceea, 0xce82, 0xcedc, 0xce1c, 0xcecc, 0xcec3, 0xce5c, 0xce6c,
    0xce62, 0xce6b, 0xa69c, 0xce6e, 0xce5b, 0xce68, 0xcf9e, 0xcf9a,
    0xce40, 0xa693, 0xcfa5, 0xce44, 0xcfa6, 0xcfb9, 0xcfcb, 0xcfec,
    0xcf1f, 0xcf7d, 0xcf65, 0xcf43, 0xc88a, 0xc8fe, 0xc8f3, 0xc929,
    0xa567, 0xa692, 0xca26, 0xca14, 0xcb88, 0xcb80, 0xcbf8, 0xcbf6,
    0xcbf4, 0xcbea, 0xcbee, 0xc4ec, 0xc4de, 0xa691, 0xa690, 0xc59c,
    0xa697, 0xc525, 0xc6f5, 0xc662, 0xc667, 0xc7ce, 0xc7c9, 0xc734,
    0xc70a, 0xc700, 0xc0bb, 0xc1cb, 0xc1d0, 0xa696, 0xc2a2, 0xc26a,
    0xa346, 0xa346, 0x7dcb, 0x7dca, 0x7dc9, 0x7dc8, 0x7dcf, 0x7dce,
    0x7dcd, 0x7dcc, 0x7dc3, 0x7dc2, 0xa359, 0xa35f, 0xa3bc, 0xa3b9
};

static const acp_uint16_t gCp932Ext2UniPagefa[ /*388*/ ] = {
    0x7dcb, 0x7dca, 0x7dc9, 0x7dc8, 0x7dcf, 0x7dce, 0x7dcd, 0x7dcc,
    0x7dc3, 0x7dc2, 0x7ddb, 0x7dda, 0x7dd9, 0x7dd8, 0x7ddf, 0x7dde,
    0x7ddd, 0x7ddc, 0x7dd3, 0x7dd2, 0xa359, 0xa35f, 0xa3bc, 0xa3b9,
    0x6e8a, 0x7dad, 0x7d9a, 0x7e8e, 0x2231, 0xd5a7, 0xcff3, 0xce33,
    0xd867, 0x1372, 0x2c00, 0x3a8a, 0x3473, 0xce42, 0x3a40, 0x03fe,
    0x1293, 0x125a, 0x1247, 0x13bb, 0x13b8, 0x1382, 0x13ed, 0x1329,
    0x1331, 0x1321, 0x132f, 0x1376, 0x0cfb, 0x0c99, 0x1344, 0x0ca5,
    0x0cfd, 0x0ccb, 0x0cf9, 0x0c2f, 0x0c4f, 0x0c63, 0x0df1, 0x0ddf,
    0x0d26, 0x0d05, 0x0d57, 0x0eae, 0x0e27, 0x0e1d, 0x0e7b, 0x0e60,
    0x0fbb, 0x0fbc, 0x0f9f, 0x0fc9, 0x0f28, 0x0f09, 0x0f66, 0xa6b5,
    0x0827, 0x0831, 0x0812, 0x0844, 0x093d, 0x0be2, 0x0bde, 0x0b17,
    0x0b73, 0x0b7c, 0xa6b4, 0xa6ab, 0x0425, 0x0409, 0x05b0, 0x05e8,
    0x05e0, 0x05e6, 0x05d8, 0x051f, 0x0501, 0x07ed, 0x077b, 0x2994,
    0x0763, 0x0757, 0x00a5, 0x001d, 0x0001, 0x004e, 0x019c, 0x01e8,
    0xa6aa, 0x01f9, 0x01d6, 0x0103, 0x0102, 0x016b, 0x039a, 0x038f,
    0x03dc, 0x030c, 0x0365, 0x3ce6, 0x3c3e, 0x3c31, 0x3c65, 0x3c6e,
    0x3d9b, 0x3c49, 0x3daa, 0x3d8c, 0x3d8b, 0x3d23, 0x3ea8, 0x3e1d,
    0x3f4e, 0x38db, 0x3826, 0x3875, 0x39f5, 0x3abb, 0x3aae, 0x3a80,
    0x3ab2, 0x3a95, 0x3aa5, 0x3a9f, 0x3ade, 0x3aec, 0x3ae2, 0xa6a9,
    0x3ac8, 0x3a22, 0x3a1b, 0x3a09, 0x3a04, 0x3a41, 0x3bb5, 0xa592,
    0x3bdd, 0x3b00, 0x34e9, 0x3b7b, 0x34ba, 0x34ff, 0x3474, 0xa6a8,
    0x35d3, 0xa6af, 0x3523, 0x3559, 0x368b, 0x36d0, 0x36fd, 0x36c8,
    0x36c5, 0x3659, 0x365f, 0x376d, 0x3084, 0x30e7, 0x303d, 0x30d4,
    0x3061, 0x31bf, 0x313c, 0x31d4, 0x312d, 0x3117, 0x3174, 0x3143,
    0x3149, 0x3147, 0x3282, 0x32e7, 0x329c, 0x3287, 0x3204, 0x3333,
    0x330e, 0x334e, 0x2cbe, 0x2cbc, 0x2c93, 0x2c3e, 0x2c10, 0x2db4,
    0x2dbf, 0x2de7, 0x2dfd, 0x2dfc, 0xa6ae, 0x2d7a, 0x2d45, 0x2e0a,
    0x2e05, 0x2f9f, 0xa6ad, 0x2fcc, 0x2f06, 0x2f72, 0x2f6d, 0x2f58,
    0x2f69, 0x28bc, 0x2f4e, 0x289d, 0x2891, 0x2892, 0x2895, 0x28d9,
    0x2832, 0x2824, 0x29ba, 0x29d4, 0x2a39, 0x2a27, 0x2a25, 0x2a20,
    0x2a1d, 0xa6ac, 0x2bfd, 0x0e14, 0x249a, 0x24f5, 0x24df, 0x24c1,
    0x258b, 0xa6a3, 0xa6a2, 0xa6a1, 0x252f, 0xa6a0, 0x2520, 0x266a,
    0x265c, 0xa6a7, 0x2650, 0x2725, 0xa6a6, 0x21f3, 0x21e7, 0x210c,
    0x211b, 0x216d, 0x22e9, 0x23fc, 0x231a, 0xa6a5, 0xdfba, 0xdfd9,
    0xdfc4, 0xdf7c, 0xdf4d, 0xd8f3, 0xd80f, 0xd9e8, 0xd9e2, 0xd9d0,
    0xa6a4, 0xd90b, 0xa69b, 0xa69a, 0xd4bc, 0xd44e, 0xd6a9, 0xd68c,
    0xd6c2, 0xd61c, 0xd605, 0xd664, 0xa699, 0xd64d, 0xd7e8, 0xd7c4,
    0xd04b, 0xd04f, 0xd1a9, 0xd1cd, 0xa698, 0xd274, 0xa69f, 0xa69e,
    0xccdc, 0xcc65, 0xa69d, 0xcdae, 0xcd9c, 0xcd61, 0xcd6c, 0xcd65,
    0xcd56, 0xcd55, 0xcd5f, 0xcd5e, 0xcebd, 0xceab, 0xceb1, 0xce81,
    0xcefb, 0xce87, 0xcef5, 0xcee2, 0xceea, 0xce82, 0xcedc, 0xce1c,
    0xcecc, 0xcec3, 0xce5c, 0xce6c, 0xce62, 0xce6b, 0xa69c, 0xce6e,
    0xce5b, 0xce68, 0xcf9e, 0xcf9a, 0xce40, 0xa693, 0xcfa5, 0xce44,
    0xcfa6, 0xcfb9, 0xcfcb, 0xcfec, 0xcf1f, 0xcf7d, 0xcf65, 0xcf43,
    0xc88a, 0xc8fe, 0xc8f3, 0xc929, 0xa567, 0xa692, 0xca26, 0xca14,
    0xcb88, 0xcb80, 0xcbf8, 0xcbf6, 0xcbf4, 0xcbea, 0xcbee, 0xc4ec,
    0xc4de, 0xa691, 0xa690, 0xc59c, 0xa697, 0xc525, 0xc6f5, 0xc662,
    0xc667, 0xc7ce, 0xc7c9, 0xc734, 0xc70a, 0xc700, 0xc0bb, 0xc1cb,
    0xc1d0, 0xa696, 0xc2a2, 0xc26a
};

ACP_EXPORT
acp_sint32_t aciConvConvertMbToWc4Cp932ext( void         * aSrc,
                                            acp_sint32_t   aSrcRemain,
                                            acp_sint32_t * aSrcAdvance,
                                            void         * aDest )
{
/***********************************************************************
 *
 * Description :
 *     PROJ-2590 [ɼ] CP932 database character set 
 *
 * Implementation :
 *     1) CP932EXT  
 *
 ***********************************************************************/

    acp_uint8_t  * sSrcPtr = (acp_uint8_t *)aSrc;
    acp_uint16_t   sWideChar = 0;
    acp_uint32_t   sNum = 0;
    acp_sint32_t   sRet = ACICONV_RET_ILUNI;

    if ( ( sSrcPtr[ 0 ] == 0x87 ) ||
         ( ( sSrcPtr[ 0 ] >= 0xed ) && ( sSrcPtr[ 0 ] <= 0xee ) ) ||
         ( ( sSrcPtr[ 0 ] >= 0xfa ) && ( sSrcPtr[ 0 ] <= 0xfc ) ) )
    {
        if ( aSrcRemain < 2 )
        {
            *aSrcAdvance = aSrcRemain;
            sRet = ACICONV_RET_TOOFEW;
        }
        else
        {
            if ( ( ( sSrcPtr[ 1 ] >= 0x40 ) && ( sSrcPtr[ 1 ] < 0x7f ) ) ||
                 ( ( sSrcPtr[ 1 ] >= 0x80 ) && ( sSrcPtr[ 1 ] < 0xfd ) ) )
            {
                sNum = 188 * 
                       ( sSrcPtr[ 0 ] - ( ( sSrcPtr[ 0 ] >= 0xe0 ) ? 0xc1 : 0x81 ) ) +
                       ( sSrcPtr[ 1 ] - ( ( sSrcPtr[ 1 ] >= 0x80 ) ? 0x41 : 0x40 ) );
                
                sWideChar = 0xfffd;
                
                if ( sNum < 8272 )
                {
                    if ( sNum < 1220 )
                    {
                        sWideChar = gCp932Ext2UniPage87[ sNum - 1128 ] ^ ACI_CP932EXT_XOR_VALUE;
                    }
                    else
                    {
                        // Nothing to do
                    }
                }
                else if ( sNum < 10716 )
                {
                    if ( sNum < 8648 )
                    {
                        sWideChar = gCp932Ext2UniPageed[ sNum - 8272 ] ^ ACI_CP932EXT_XOR_VALUE;
                    }
                    else
                    {
                        // Nothing to do
                    }
                }
                else
                {
                    if ( sNum < 11104 )
                    {
                        sWideChar = gCp932Ext2UniPagefa[ sNum - 10716 ] ^ ACI_CP932EXT_XOR_VALUE;
                    }
                    else
                    {
                        // Nothing to do
                    }
                }

                if ( sWideChar != 0xfffd )
                {
                    ACICONV_WC_TO_UTF16BE( aDest, sWideChar );

                    *aSrcAdvance = 2;
                    sRet = 2;
                }
                else
                {
                    *aSrcAdvance = 2;
                    sRet = ACICONV_RET_ILSEQ;
                }
            }
            else
            {
                *aSrcAdvance = 2;
                sRet = ACICONV_RET_ILSEQ;
            }
        }
    }
    else
    {
        *aSrcAdvance = 1;
        sRet = ACICONV_RET_ILSEQ;
    }

    return sRet;
}

static const acp_uint16_t gCp932Ext2Charset[ /*457*/ ] = {
    0xa6e2, 0xa6e1, 0xa6f1, 0xa6f0, 0xa6f7, 0xa6f6, 0xa6f5, 0xa6f4,
    0xa6eb, 0xa6ea, 0xa6e9, 0xa6e8, 0xa6fb, 0xa6fa, 0xa6f9, 0xa6f8,
    0xa6ff, 0xa6fe, 0xa6fd, 0xa6fc, 0xa6f3, 0xa6f2, 0xdb2f, 0xdb2e,
    0xdb23, 0xdb2c, 0xdb20, 0xdb27, 0xdb29, 0xdb28, 0xa6e0, 0xdb2b,
    0xdb2a, 0xdb2d, 0xdb22, 0xdbfb, 0xdbfa, 0xdbf9, 0xdbf8, 0xdbff,
    0xdbfe, 0xdbfd, 0xdbfc, 0xdbf3, 0xdbf2, 0xdbf1, 0xdbf0, 0xdbf7,
    0xdbf6, 0xdbf5, 0xdbf4, 0xdbeb, 0xdbea, 0xdbe9, 0xdbe8, 0xdb3b,
    0xdb3a, 0xa6e3, 0xdb30, 0xdb37, 0xdb3e, 0xdb3d, 0xdb3c, 0xdb33,
    0xdb32, 0xdbde, 0xdbd2, 0xdbdb, 0xdbd8, 0xdbda, 0xdbd0, 0xdbd1,
    0xdbdf, 0xdbd7, 0xdbdd, 0xdbd5, 0xdbe4, 0xdbd6, 0xdbd9, 0xdbdc,
    0xdbd3, 0xdbc5, 0xdb34, 0xdb35, 0xdb36, 0xdbc9, 0xdbc8, 0xdbd4,
    0xdbcb, 0xdbca, 0xdbce, 0xdbcf, 0xdb38, 0xa6d3, 0xa6d2, 0xa6d1,
    0xa6d0, 0xa6d7, 0xa6d6, 0xa6d5, 0xa6cb, 0xa6d4, 0xa6c9, 0xa6ca,
    0xa6da, 0xa6c8, 0xa6cd, 0xa6cc, 0xa6ce, 0xa6cf, 0xa6c1, 0xa6c3,
    0xa6c2, 0xa6c0, 0xa6c6, 0xa6c7, 0xa6c5, 0xa63b, 0xa63a, 0xa639,
    0xa638, 0xa63f, 0xa63e, 0xa63d, 0xa7cc, 0xa63c, 0xa633, 0xa632,
    0xa631, 0xa630, 0xa637, 0xa636, 0xa635, 0xa634, 0xa629, 0xa62a,
    0xa628, 0xa62f, 0xa62e, 0xa62d, 0xa62c, 0xa623, 0xa621, 0xa622,
    0xa626, 0xa625, 0xa624, 0xa61b, 0xa61a, 0xa619, 0xa618, 0xa61f,
    0xa61e, 0xa61d, 0xa61c, 0xa612, 0xa611, 0xa610, 0xa617, 0xa616,
    0xa615, 0xa614, 0xa609, 0xa60b, 0xa608, 0xa60f, 0xa60e, 0xa60d,
    0xa60c, 0xa603, 0xa6dc, 0xa602, 0xa601, 0xa600, 0xa607, 0xa606,
    0xa605, 0xa67b, 0xa604, 0xa679, 0xa678, 0xa67a, 0xa67e, 0xa67f,
    0xa67d, 0xa67c, 0xa673, 0xa672, 0xa671, 0xa670, 0xa677, 0xa676,
    0xa675, 0xa66a, 0xa674, 0xa668, 0xa66f, 0xa669, 0xa6d8, 0xa66b,
    0xa66d, 0xa66c, 0xa66e, 0xa662, 0xa661, 0xa660, 0xa667, 0xa666,
    0xa665, 0xa6dd, 0xa664, 0xa65a, 0xa659, 0xa65f, 0xa65e, 0xa65d,
    0xa658, 0xa6df, 0xa65c, 0xa652, 0xa650, 0xa657, 0xa656, 0xa654,
    0xa655, 0xa64b, 0xa64a, 0xa649, 0xa648, 0xa64f, 0xa64e, 0xa64d,
    0xa643, 0xa64c, 0xa642, 0xa641, 0xa647, 0xa640, 0xa7fb, 0xa7fa,
    0xa7f9, 0xa7ff, 0xa7f8, 0xa7fe, 0xa7f3, 0xa7fd, 0xa7f2, 0xa7fc,
    0xa7f1, 0xa7f0, 0xa7f7, 0xa7f6, 0xa7f5, 0xa7f4, 0xa7eb, 0xa7ea,
    0xa7e9, 0xa6d9, 0xa7ef, 0xa7e8, 0xa7ed, 0xa7ec, 0xa7ee, 0xa7e2,
    0xa7e1, 0xa7e0, 0xa7e7, 0xa7e6, 0xa7e4, 0xa7db, 0xa7da, 0xa7df,
    0xa7d9, 0xa7d8, 0xa7dd, 0xa7de, 0xa7dc, 0xa7d2, 0xa7d3, 0xa7d1,
    0xa7d0, 0xa7d7, 0xa7d6, 0xa7d5, 0xa613, 0xa7d4, 0xa7cb, 0xa7c8,
    0xa7ca, 0xa7c9, 0xa7cf, 0xa7cd, 0xa7c3, 0xa7c2, 0xa7c1, 0xa7c0,
    0xa7c7, 0xa73a, 0xa738, 0xa73f, 0xa73e, 0xa73c, 0xa733, 0xa731,
    0xa730, 0xa736, 0xa737, 0xa735, 0xa734, 0xa6e7, 0xa72b, 0xa72a,
    0xa728, 0xa72f, 0xa72e, 0xa72d, 0xa72c, 0xa723, 0xa722, 0xa6db,
    0xa721, 0xa720, 0xa727, 0xa725, 0xa71a, 0xa719, 0xa6e6, 0xa718,
    0xa71f, 0xa71e, 0xa71d, 0xa71c, 0xa713, 0xa711, 0xa710, 0xa717,
    0xa716, 0xa715, 0xa714, 0xa70b, 0xa709, 0xa70e, 0xa70d, 0xa703,
    0xa702, 0xa700, 0xa701, 0xa707, 0xa704, 0xa77b, 0xa706, 0xa705,
    0xa77a, 0xa778, 0xa779, 0xa771, 0xa77f, 0xa77d, 0xa77e, 0xa77c,
    0xa772, 0xa773, 0xa770, 0xa776, 0xa775, 0xa6e4, 0xa777, 0xa769,
    0xa76d, 0xa76f, 0xa76b, 0xa76a, 0xa76e, 0xa774, 0xa6de, 0xa762,
    0xa767, 0xa765, 0xa766, 0xa760, 0xa763, 0xa76c, 0xa6e5, 0xa75b,
    0xa764, 0xa75a, 0xa759, 0xa758, 0xa75f, 0xa75e, 0xa75d, 0xa75c,
    0xa753, 0xa750, 0xa757, 0xa756, 0xa755, 0xa754, 0xa74b, 0xa74a,
    0xa749, 0xa748, 0xa74f, 0xa74e, 0xa743, 0xa741, 0xa740, 0xa747,
    0xa0fb, 0xa0f9, 0xa0fa, 0xa0f8, 0xa0ff, 0xa0fe, 0xa0fd, 0xa0f3,
    0xa0fc, 0xa0f1, 0xa0f0, 0xa65b, 0xa752, 0xa62b, 0xa620, 0xa627,
    0xa60a, 0xa663, 0xa653, 0xa651, 0xa7e3, 0xa7e5, 0xa7ce, 0xa7c6,
    0xa7c5, 0xa73b, 0xa739, 0xa73d, 0xa732, 0xa729, 0xa726, 0xa724,
    0xa71b, 0xa712, 0xa70a, 0xa708, 0xa70f, 0xa70c, 0xa768, 0xa761,
    0xa751, 0xa74d, 0xa74c, 0xa742, 0xa0f2, 0xa6ec, 0xa6ed, 0xa6ef,
    0xa6ee
};

static const aciConvSummary16 gCp932ExtUni2IndexPage21[ /*28*/ ] = {
    /* 0x2100 */
    {    0, 0x0000 }, {    0, 0x0040 }, {    1, 0x0002 }, {    2, 0x0000 },
    {    2, 0x0000 }, {    2, 0x0000 }, {    2, 0x03ff }, {   12, 0x03ff },
    {   22, 0x0000 }, {   22, 0x0000 }, {   22, 0x0000 }, {   22, 0x0000 },
    {   22, 0x0000 }, {   22, 0x0000 }, {   22, 0x0000 }, {   22, 0x0000 },
    /* 0x2200 */
    {   22, 0x0000 }, {   22, 0x8402 }, {   25, 0x4e01 }, {   30, 0x0020 },
    {   31, 0x0000 }, {   31, 0x0004 }, {   32, 0x0002 }, {   33, 0x0000 },
    {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0020 }, {   34, 0x8000 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage24[ /*8*/ ] = {
    /* 0x2400 */
    {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 },
    {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0xffff }, {   51, 0x000f }
};

/* 0x3000 */
static const aciConvSummary16 gCp932ExtUni2IndexPage30[ /*2*/ ] = {
    {   55, 0x0000 }, {   55, 0xa000 },
};

static const aciConvSummary16 gCp932ExtUni2IndexPage32[ /*29*/ ] = {
    /* 0x3200 */
    {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0206 },
    {   60, 0x0000 }, {   60, 0x0000 }, {   60, 0x0000 }, {   60, 0x0000 },
    {   60, 0x0000 }, {   60, 0x0000 }, {   60, 0x01f0 }, {   65, 0x0000 },
    {   65, 0x0000 }, {   65, 0x0000 }, {   65, 0x0000 }, {   65, 0x0000 },
    /* 0x3300 */
    {   65, 0x2008 }, {   67, 0x0110 }, {   69, 0x08cc }, {   74, 0x0840 },
    {   76, 0x2600 }, {   79, 0x0082 }, {   81, 0x0000 }, {   81, 0x7800 },
    {   85, 0xc000 }, {   87, 0x7000 }, {   90, 0x0002 }, {   91, 0x0000 },
    {   91, 0x2010 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage4e[ /*121*/ ] = {
    /* 0x4e00 */
    {   93, 0x0000 }, {   93, 0x0000 }, {   93, 0x0100 }, {   94, 0x0000 },
    {   94, 0x0000 }, {   94, 0x0000 }, {   94, 0x0000 }, {   94, 0x0000 },
    {   94, 0x0000 }, {   94, 0x0000 }, {   94, 0x0000 }, {   94, 0x0000 },
    {   94, 0x0000 }, {   94, 0x0000 }, {   94, 0x0002 }, {   95, 0x1000 },
    /* 0x4f00 */
    {   96, 0x0009 }, {   98, 0x0000 }, {   98, 0x0000 }, {   98, 0x0200 },
    {   99, 0x0000 }, {   99, 0x0040 }, {  100, 0x0000 }, {  100, 0x0000 },
    {  100, 0x0400 }, {  101, 0x0414 }, {  104, 0x0000 }, {  104, 0x0000 },
    {  104, 0x2200 }, {  106, 0x0000 }, {  106, 0x0000 }, {  106, 0x8000 },
    /* 0x5000 */
    {  107, 0x0000 }, {  107, 0x4000 }, {  108, 0x0004 }, {  109, 0x0000 },
    {  109, 0x0045 }, {  112, 0x0000 }, {  112, 0x0000 }, {  112, 0x0001 },
    {  113, 0x0000 }, {  113, 0x0010 }, {  114, 0x0000 }, {  114, 0x0000 },
    {  114, 0x0000 }, {  114, 0x0100 }, {  115, 0x0000 }, {  115, 0x0010 },
    /* 0x5100 */
    {  116, 0x0000 }, {  116, 0x0000 }, {  116, 0x0000 }, {  116, 0x0000 },
    {  116, 0x0400 }, {  117, 0x0000 }, {  117, 0x0010 }, {  118, 0x0000 },
    {  118, 0x0000 }, {  118, 0x2000 }, {  119, 0x0000 }, {  119, 0x4000 },
    {  120, 0x0000 }, {  120, 0x0000 }, {  120, 0x1000 }, {  121, 0x0000 },
    /* 0x5200 */
    {  121, 0x0000 }, {  121, 0x0020 }, {  122, 0x0000 }, {  122, 0x0000 },
    {  122, 0x0000 }, {  122, 0x0000 }, {  122, 0x0000 }, {  122, 0x0000 },
    {  122, 0x0000 }, {  122, 0x1000 }, {  123, 0x8040 }, {  125, 0x0000 },
    {  125, 0x0001 }, {  126, 0x0800 }, {  127, 0x0000 }, {  127, 0x0000 },
    /* 0x5300 */
    {  127, 0x0081 }, {  129, 0x0000 }, {  129, 0x0010 }, {  130, 0x0000 },
    {  130, 0x0000 }, {  130, 0x0000 }, {  130, 0x0000 }, {  130, 0x0004 },
    {  131, 0x0000 }, {  131, 0x0008 }, {  132, 0x0000 }, {  132, 0x0004 },
    {  133, 0x0000 }, {  133, 0x2000 }, {  134, 0x0000 }, {  134, 0x0000 },
    /* 0x5400 */
    {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x0000 },
    {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x0000 }, {  134, 0x0000 },
    {  134, 0x0400 }, {  135, 0x1000 }, {  136, 0x0200 }, {  137, 0x0000 },
    {  137, 0x0000 }, {  137, 0x0000 }, {  137, 0x0000 }, {  137, 0x8000 },
    /* 0x5500 */
    {  138, 0x0000 }, {  138, 0x0000 }, {  138, 0x0000 }, {  138, 0x0000 },
    {  138, 0x0000 }, {  138, 0x0000 }, {  138, 0x0000 }, {  138, 0x0000 },
    {  138, 0x0040 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage57[ /*44*/ ] = {
    /* 0x5700 */
    {  139, 0x0000 }, {  139, 0x0000 }, {  139, 0x0000 }, {  139, 0x0000 },
    {  139, 0x0000 }, {  139, 0x0200 }, {  140, 0x0020 }, {  141, 0x0000 },
    {  141, 0x0000 }, {  141, 0x0000 }, {  141, 0x1000 }, {  142, 0x0000 },
    {  142, 0x0180 }, {  144, 0x0000 }, {  144, 0x0000 }, {  144, 0x0000 },
    /* 0x5800 */
    {  144, 0x0000 }, {  144, 0x0000 }, {  144, 0x0000 }, {  144, 0x0000 },
    {  144, 0x0000 }, {  144, 0x0000 }, {  144, 0x0000 }, {  144, 0x0000 },
    {  144, 0x0000 }, {  144, 0x4000 }, {  145, 0x0000 }, {  145, 0x0004 },
    {  146, 0x0000 }, {  146, 0x0000 }, {  146, 0x0000 }, {  146, 0x0000 },
    /* 0x5900 */
    {  146, 0x0800 }, {  147, 0x0000 }, {  147, 0x0000 }, {  147, 0x0000 },
    {  147, 0x0000 }, {  147, 0x2808 }, {  150, 0x0008 }, {  151, 0x0000 },
    {  151, 0x0000 }, {  151, 0x0000 }, {  151, 0x0010 }, {  152, 0x0400 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage5b[ /*46*/ ] = {
    /* 0x5b00 */
    {  153, 0x0000 }, {  153, 0x0000 }, {  153, 0x0000 }, {  153, 0x0000 },
    {  153, 0x0000 }, {  153, 0x0040 }, {  154, 0x0000 }, {  154, 0x0000 },
    {  154, 0x0000 }, {  154, 0x0000 }, {  154, 0x0000 }, {  154, 0x0000 },
    {  154, 0x0001 }, {  155, 0x0100 }, {  156, 0x1000 }, {  157, 0x0000 },
    /* 0x5c00 */
    {  157, 0x0000 }, {  157, 0x4000 }, {  158, 0x0000 }, {  158, 0x0000 },
    {  158, 0x0000 }, {  158, 0x0000 }, {  158, 0x0000 }, {  158, 0x0000 },
    {  158, 0x0000 }, {  158, 0x0000 }, {  158, 0x0040 }, {  159, 0x0400 },
    {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0020 },
    /* 0x5d00 */
    {  161, 0x0000 }, {  161, 0x0000 }, {  161, 0x0080 }, {  162, 0x0000 },
    {  162, 0x0004 }, {  163, 0x0008 }, {  164, 0x2000 }, {  165, 0x0000 },
    {  165, 0x0000 }, {  165, 0x0000 }, {  165, 0x0000 }, {  165, 0x0300 },
    {  167, 0x0000 }, {  167, 0x0001 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage5f[ /*458*/] = {
    /* 0x5f00 */
    {  168, 0x0000 }, {  168, 0x0000 }, {  168, 0x0002 }, {  169, 0x0010 },
    {  170, 0x0020 }, {  171, 0x0000 }, {  171, 0x0080 }, {  172, 0x0000 },
    {  172, 0x0000 }, {  172, 0x0000 }, {  172, 0x0000 }, {  172, 0x0080 },
    {  173, 0x0000 }, {  173, 0x4000 }, {  174, 0x0000 }, {  174, 0x0000 },
    /* 0x6000 */
    {  174, 0x0000 }, {  174, 0x0000 }, {  174, 0x0000 }, {  174, 0x0000 },
    {  174, 0x0000 }, {  174, 0x2000 }, {  175, 0x0000 }, {  175, 0x0000 },
    {  175, 0x0420 }, {  177, 0x0000 }, {  177, 0x0000 }, {  177, 0x0000 },
    {  177, 0x0000 }, {  177, 0x4020 }, {  179, 0x0000 }, {  179, 0x0004 },
    /* 0x6100 */
    {  180, 0x0000 }, {  180, 0x0002 }, {  181, 0x0001 }, {  182, 0x0081 },
    {  184, 0x0000 }, {  184, 0x0000 }, {  184, 0x0000 }, {  184, 0x0000 },
    {  184, 0x0000 }, {  184, 0x0100 }, {  185, 0x0000 }, {  185, 0x0000 },
    {  185, 0x0000 }, {  185, 0x0000 }, {  185, 0x0000 }, {  185, 0x0000 },
    /* 0x6200 */
    {  185, 0x0000 }, {  185, 0x0008 }, {  186, 0x0000 }, {  186, 0x0000 },
    {  186, 0x0000 }, {  186, 0x0000 }, {  186, 0x0000 }, {  186, 0x0000 },
    {  186, 0x0000 }, {  186, 0x0000 }, {  186, 0x0040 }, {  187, 0x0000 },
    {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 },
    /* 0x6300 */
    {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 },
    {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 },
    {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 },
    {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0000 }, {  187, 0x0020 },
    /* 0x6400 */
    {  188, 0x0000 }, {  188, 0x0000 }, {  188, 0x0000 }, {  188, 0x0000 },
    {  188, 0x0000 }, {  188, 0x0000 }, {  188, 0x0001 }, {  189, 0x0000 },
    {  189, 0x0000 }, {  189, 0x2000 }, {  190, 0x0000 }, {  190, 0x0000 },
    {  190, 0x4000 }, {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 },
    /* 0x6500 */
    {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 },
    {  191, 0x4000 }, {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 },
    {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 },
    {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 }, {  192, 0x0000 },
    /* 0x6600 */
    {  192, 0x0201 }, {  194, 0x4020 }, {  196, 0x4010 }, {  198, 0x0802 },
    {  200, 0x0000 }, {  200, 0x0280 }, {  202, 0x0020 }, {  203, 0x0008 },
    {  204, 0x0000 }, {  204, 0x0200 }, {  205, 0x0001 }, {  206, 0x8004 },
    {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0c00 },
    /* 0x6700 */
    {  210, 0x4000 }, {  211, 0x0000 }, {  211, 0x0000 }, {  211, 0x0000 },
    {  211, 0x0000 }, {  211, 0x0000 }, {  211, 0x0040 }, {  212, 0x0000 },
    {  212, 0x0000 }, {  212, 0x0000 }, {  212, 0x0000 }, {  212, 0x0800 },
    {  213, 0x0001 }, {  214, 0x0000 }, {  214, 0x0000 }, {  214, 0x0000 },
    /* 0x6800 */
    {  214, 0x0002 }, {  215, 0x0000 }, {  215, 0x0000 }, {  215, 0x0000 },
    {  215, 0x0010 }, {  216, 0x0004 }, {  217, 0x0000 }, {  217, 0x0000 },
    {  217, 0x0000 }, {  217, 0x0000 }, {  217, 0x0000 }, {  217, 0x0000 },
    {  217, 0x8100 }, {  219, 0x0000 }, {  219, 0x0000 }, {  219, 0x0000 },
    /* 0x6900 */
    {  219, 0x0000 }, {  219, 0x0000 }, {  219, 0x0000 }, {  219, 0x0000 },
    {  219, 0x0000 }, {  219, 0x0000 }, {  219, 0x0100 }, {  220, 0x0000 },
    {  220, 0x0000 }, {  220, 0x0100 }, {  221, 0x0000 }, {  221, 0x0000 },
    {  221, 0x0000 }, {  221, 0x0000 }, {  221, 0x0004 }, {  222, 0x0000 },
    /* 0x6a00 */
    {  222, 0x0000 }, {  222, 0x0000 }, {  222, 0x0000 }, {  222, 0x0001 },
    {  223, 0x0040 }, {  224, 0x0000 }, {  224, 0x0800 }, {  225, 0x4008 },
    {  227, 0x0000 }, {  227, 0x0000 }, {  227, 0x0000 }, {  227, 0x0000 },
    {  227, 0x0000 }, {  227, 0x0000 }, {  227, 0x0014 }, {  229, 0x0000 },
    /* 0x6b00 */
    {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 },
    {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 },
    {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 }, {  229, 0x0000 },
    {  229, 0x0000 }, {  229, 0x0040 }, {  230, 0x0000 }, {  230, 0x0000 },
    /* 0x6c00 */
    {  230, 0x0000 }, {  230, 0x0000 }, {  230, 0x0000 }, {  230, 0x8000 },
    {  231, 0x0000 }, {  231, 0x1000 }, {  232, 0x8000 }, {  233, 0x0000 },
    {  233, 0x0040 }, {  234, 0x0000 }, {  234, 0x0000 }, {  234, 0x0000 },
    {  234, 0x0000 }, {  234, 0x0400 }, {  235, 0x0000 }, {  235, 0x0000 },
    /* 0x6d00 */
    {  235, 0x0010 }, {  236, 0x0000 }, {  236, 0x0000 }, {  236, 0x0000 },
    {  236, 0x0000 }, {  236, 0x0000 }, {  236, 0x8000 }, {  237, 0x0000 },
    {  237, 0x0080 }, {  238, 0x0040 }, {  239, 0x1000 }, {  240, 0x0000 },
    {  240, 0x8000 }, {  241, 0x0000 }, {  241, 0x0000 }, {  241, 0x1104 },
    /* 0x6e00 */
    {  244, 0x0000 }, {  244, 0x0000 }, {  244, 0x0080 }, {  245, 0x1200 },
    {  247, 0x0000 }, {  247, 0x1000 }, {  248, 0x0000 }, {  248, 0x0000 },
    {  248, 0x0000 }, {  248, 0x0000 }, {  248, 0x0000 }, {  248, 0x8000 },
    {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 },
    /* 0x6f00 */
    {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 },
    {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 }, {  249, 0x0000 },
    {  249, 0x0100 }, {  250, 0x0000 }, {  250, 0x0000 }, {  250, 0x0020 },
    {  251, 0x0000 }, {  251, 0x0000 }, {  251, 0x0000 }, {  251, 0x0020 },
    /* 0x7000 */
    {  252, 0x00a0 }, {  254, 0x0000 }, {  254, 0x0100 }, {  255, 0x0000 },
    {  255, 0x0000 }, {  255, 0x0000 }, {  255, 0x0000 }, {  255, 0x0000 },
    {  255, 0x0020 }, {  256, 0x0000 }, {  256, 0x0800 }, {  257, 0x0800 },
    {  258, 0x0000 }, {  258, 0x0000 }, {  258, 0x0000 }, {  258, 0x0000 },
    /* 0x7100 */
    {  258, 0x8010 }, {  260, 0x0000 }, {  260, 0x0000 }, {  260, 0x0000 },
    {  260, 0x00c0 }, {  262, 0x1000 }, {  263, 0x0000 }, {  263, 0x0000 },
    {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 }, {  263, 0x0000 },
    {  263, 0x0002 }, {  264, 0x0000 }, {  264, 0x0000 }, {  264, 0x4000 },
    /* 0x7200 */
    {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x0000 },
    {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x0000 },
    {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x0000 }, {  265, 0x4002 },
    {  267, 0x0000 }, {  267, 0x0000 }, {  267, 0x0000 }, {  267, 0x0000 },
    /* 0x7300 */
    {  267, 0x0000 }, {  267, 0x0000 }, {  267, 0x0010 }, {  268, 0x0000 },
    {  268, 0x0000 }, {  268, 0x0000 }, {  268, 0x0000 }, {  268, 0x0080 },
    {  269, 0x0000 }, {  269, 0x0000 }, {  269, 0x0000 }, {  269, 0x2000 },
    {  270, 0x0200 }, {  271, 0x0044 }, {  273, 0x0008 }, {  274, 0x0020 },
    /* 0x7400 */
    {  275, 0x0080 }, {  276, 0x0000 }, {  276, 0x4640 }, {  280, 0x0000 },
    {  280, 0x0000 }, {  280, 0x0000 }, {  280, 0x0004 }, {  281, 0x0000 },
    {  281, 0x0200 }, {  282, 0x8000 }, {  283, 0x0000 }, {  283, 0x0000 },
    {  283, 0x0000 }, {  283, 0x0000 }, {  283, 0x0000 }, {  283, 0x0000 },
    /* 0x7500 */
    {  283, 0x0002 }, {  284, 0x0000 }, {  284, 0x8000 }, {  285, 0x0000 },
    {  285, 0x0000 }, {  285, 0x0000 }, {  285, 0x8000 }, {  286, 0x0000 },
    {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 },
    {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 },
    /* 0x7600 */
    {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 },
    {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 }, {  286, 0x0000 },
    {  286, 0x0004 }, {  287, 0x5800 }, {  290, 0x0040 }, {  291, 0x0000 },
    {  291, 0x0000 }, {  291, 0x0000 }, {  291, 0x0000 }, {  291, 0x0000 },
    /* 0x7700 */
    {  291, 0x0000 }, {  291, 0x0000 }, {  291, 0x0000 }, {  291, 0x0000 },
    {  291, 0x0040 }, {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0000 },
    {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0000 },
    {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0000 },
    /* 0x7800 */
    {  292, 0x0000 }, {  292, 0x0000 }, {  292, 0x0002 }, {  293, 0x0000 },
    {  293, 0x4000 }, {  294, 0x0000 }, {  294, 0x0010 }, {  295, 0x0400 },
    {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0000 },
    {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0000 },
    /* 0x7900 */
    {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0000 }, {  296, 0x0001 },
    {  297, 0x0000 }, {  297, 0x0000 }, {  297, 0x0000 }, {  297, 0x0000 },
    {  297, 0x0000 }, {  297, 0x0810 }, {  299, 0x0000 }, {  299, 0x0000 },
    {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 },
    /* 0x7a00 */
    {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 },
    {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 },
    {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 }, {  299, 0x0000 },
    {  299, 0x0000 }, {  299, 0x0002 }, {  300, 0x0880 }, {  302, 0x0000 },
    /* 0x7b00 */
    {  302, 0x0000 }, {  302, 0x0000 }, {  302, 0x0000 }, {  302, 0x0000 },
    {  302, 0x0000 }, {  302, 0x0000 }, {  302, 0x0000 }, {  302, 0x0000 },
    {  302, 0x0000 }, {  302, 0x4000 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage7d[ /*43*/ ] = {
    /* 0x7d00 */
    {  303, 0x0000 }, {  303, 0x0000 }, {  303, 0x0000 }, {  303, 0x0000 },
    {  303, 0x0100 }, {  304, 0x1000 }, {  305, 0x0000 }, {  305, 0x0000 },
    {  305, 0x0000 }, {  305, 0x0000 }, {  305, 0x0001 }, {  306, 0x0080 },
    {  307, 0x0000 }, {  307, 0x0040 }, {  308, 0x0000 }, {  308, 0x0000 },
    /* 0x7e00 */
    {  308, 0x0000 }, {  308, 0x0000 }, {  308, 0x0000 }, {  308, 0x0000 },
    {  308, 0x0000 }, {  308, 0x0004 }, {  309, 0x0000 }, {  309, 0x0000 },
    {  309, 0x0400 }, {  310, 0x0000 }, {  310, 0x0000 }, {  310, 0x0000 },
    {  310, 0x0000 }, {  310, 0x0000 }, {  310, 0x0000 }, {  310, 0x0000 },
    /* 0x7f00 */
    {  310, 0x0000 }, {  310, 0x0000 }, {  310, 0x0000 }, {  310, 0x0000 },
    {  310, 0x0080 }, {  311, 0x0000 }, {  311, 0x0000 }, {  311, 0x0000 },
    {  311, 0x0000 }, {  311, 0x0000 }, {  311, 0x0002 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage83[ /*44*/ ] = {
    /* 0x8300 */
    {  312, 0x0002 }, {  313, 0x0000 }, {  313, 0x0000 }, {  313, 0x0000 },
    {  313, 0x0000 }, {  313, 0x0000 }, {  313, 0x0004 }, {  314, 0x8000 },
    {  315, 0x0000 }, {  315, 0x0000 }, {  315, 0x0000 }, {  315, 0x0000 },
    {  315, 0x0080 }, {  316, 0x0000 }, {  316, 0x0000 }, {  316, 0x0040 },
    /* 0x8400 */
    {  317, 0x0000 }, {  317, 0x0000 }, {  317, 0x0000 }, {  317, 0x0000 },
    {  317, 0x0100 }, {  318, 0x0000 }, {  318, 0x0000 }, {  318, 0x0000 },
    {  318, 0x0000 }, {  318, 0x0000 }, {  318, 0x0000 }, {  318, 0x0010 },
    {  319, 0x0000 }, {  319, 0x1000 }, {  320, 0x0000 }, {  320, 0x0000 },
    /* 0x8500 */
    {  320, 0x0000 }, {  320, 0x0000 }, {  320, 0x0000 }, {  320, 0x0000 },
    {  320, 0x0000 }, {  320, 0x0208 }, {  322, 0x0800 }, {  323, 0x0000 },
    {  323, 0x0000 }, {  323, 0x0000 }, {  323, 0x0000 }, {  323, 0x0001 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage88[ /*109*/ ] = {
    /* 0x8800 */
    {  324, 0x0080 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
    {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
    {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 },
    {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0000 }, {  325, 0x0020 },
    /* 0x8900 */
    {  326, 0x0000 }, {  326, 0x1000 }, {  327, 0x0000 }, {  327, 0x0000 },
    {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 },
    {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 },
    {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 }, {  327, 0x0000 },
    /* 0x8a00 */
    {  327, 0x0000 }, {  327, 0x0004 }, {  328, 0x0000 }, {  328, 0x0080 },
    {  329, 0x0000 }, {  329, 0x0000 }, {  329, 0x0000 }, {  329, 0x0200 },
    {  330, 0x0000 }, {  330, 0x0000 }, {  330, 0x0080 }, {  331, 0x4000 },
    {  332, 0x0000 }, {  332, 0x8000 }, {  333, 0x0000 }, {  333, 0x0040 },
    /* 0x8b00 */
    {  334, 0x0000 }, {  334, 0x0000 }, {  334, 0x0000 }, {  334, 0x0000 },
    {  334, 0x0000 }, {  334, 0x0008 }, {  335, 0x0000 }, {  335, 0x8000 },
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 },
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 },
    /* 0x8c00 */
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 },
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 },
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 },
    {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0000 }, {  336, 0x0011 },
    /* 0x8d00 */
    {  338, 0x0000 }, {  338, 0x0004 }, {  339, 0x0000 }, {  339, 0x0000 },
    {  339, 0x0000 }, {  339, 0x0000 }, {  339, 0x0000 }, {  339, 0x0040 },
    {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 },
    {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 },
    /* 0x8e00 */
    {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 },
    {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 },
    {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 }, {  340, 0x0000 },
    {  340, 0x8000 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPage90[ /*238*/ ] = {
    /* 0x9000 */
    {  341, 0x0000 }, {  341, 0x0000 }, {  341, 0x0000 }, {  341, 0x0000 },
    {  341, 0x0000 }, {  341, 0x0000 }, {  341, 0x0080 }, {  342, 0x0000 },
    {  342, 0x0000 }, {  342, 0x0000 }, {  342, 0x0000 }, {  342, 0x0000 },
    {  342, 0x0000 }, {  342, 0x4000 }, {  343, 0x0000 }, {  343, 0x0000 },
    /* 0x9100 */
    {  343, 0x0000 }, {  343, 0x0020 }, {  344, 0x0080 }, {  345, 0x0000 },
    {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
    {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
    {  345, 0x0000 }, {  345, 0x4480 }, {  348, 0x6030 }, {  352, 0x0000 },
    /* 0x9200 */
    {  352, 0x0440 }, {  354, 0x0001 }, {  355, 0x0000 }, {  355, 0x1600 },
    {  358, 0x4001 }, {  360, 0x0202 }, {  362, 0x0080 }, {  363, 0x0180 },
    {  365, 0x0100 }, {  366, 0x0000 }, {  366, 0x0080 }, {  367, 0x0000 },
    {  367, 0x0000 }, {  367, 0x02a9 }, {  372, 0x0081 }, {  374, 0x8a00 },
    /* 0x9300 */
    {  377, 0x0004 }, {  378, 0x6000 }, {  380, 0x0022 }, {  382, 0x0000 },
    {  382, 0x0100 }, {  383, 0x0080 }, {  384, 0x0000 }, {  384, 0x0001 },
    {  385, 0x0000 }, {  385, 0x0000 }, {  385, 0x0010 }, {  386, 0x0000 },
    {  386, 0x0040 }, {  387, 0x4000 }, {  388, 0x0000 }, {  388, 0x0100 },
    /* 0x9400 */
    {  389, 0x0000 }, {  389, 0x0000 }, {  389, 0x0000 }, {  389, 0x0002 },
    {  390, 0x0120 }, {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 },
    {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 },
    {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 },
    /* 0x9500 */
    {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 },
    {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 }, {  392, 0x0000 },
    {  392, 0x0000 }, {  392, 0x0004 }, {  393, 0x0000 }, {  393, 0x0000 },
    {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 },
    /* 0x9600 */
    {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 },
    {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 }, {  393, 0x0000 },
    {  393, 0x0000 }, {  393, 0x2000 }, {  394, 0x8000 }, {  395, 0x0000 },
    {  395, 0x0000 }, {  395, 0x0000 }, {  395, 0x0000 }, {  395, 0x0000 },
    /* 0x9700 */
    {  395, 0x0000 }, {  395, 0x0000 }, {  395, 0x0000 }, {  395, 0x0808 },
    {  397, 0xa008 }, {  400, 0x0022 }, {  402, 0x0000 }, {  402, 0x0000 },
    {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 },
    {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 },
    /* 0x9800 */
    {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 }, {  402, 0x0000 },
    {  402, 0x0000 }, {  402, 0x0080 }, {  403, 0x0020 }, {  404, 0x0000 },
    {  404, 0x0000 }, {  404, 0x0000 }, {  404, 0x0000 }, {  404, 0x0000 },
    {  404, 0x0000 }, {  404, 0x0000 }, {  404, 0x0000 }, {  404, 0x0000 },
    /* 0x9900 */
    {  404, 0x0000 }, {  404, 0x0000 }, {  404, 0x0080 }, {  405, 0x0000 },
    {  405, 0x0000 }, {  405, 0x0000 }, {  405, 0x0000 }, {  405, 0x0000 },
    {  405, 0x0000 }, {  405, 0x4000 }, {  406, 0x0000 }, {  406, 0x0000 },
    {  406, 0x0000 }, {  406, 0x0000 }, {  406, 0x0000 }, {  406, 0x0000 },
    /* 0x9a00 */
    {  406, 0x0000 }, {  406, 0x0000 }, {  406, 0x0000 }, {  406, 0x0000 },
    {  406, 0x4000 }, {  407, 0x0000 }, {  407, 0x0000 }, {  407, 0x0000 },
    {  407, 0x0000 }, {  407, 0x0000 }, {  407, 0x0000 }, {  407, 0x0000 },
    {  407, 0x0000 }, {  407, 0x1200 }, {  409, 0x0000 }, {  409, 0x0000 },
    /* 0x9b00 */
    {  409, 0x0000 }, {  409, 0x0000 }, {  409, 0x0000 }, {  409, 0x0000 },
    {  409, 0x0000 }, {  409, 0x0000 }, {  409, 0x0000 }, {  409, 0x0024 },
    {  411, 0x8000 }, {  412, 0x0000 }, {  412, 0x0000 }, {  412, 0x0802 },
    {  414, 0x0000 }, {  414, 0x0000 }, {  414, 0x0000 }, {  414, 0x0000 },
    /* 0x9c00 */
    {  414, 0x0001 }, {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 },
    {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 },
    {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 },
    {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 },
    /* 0x9d00 */
    {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0000 },
    {  415, 0x0000 }, {  415, 0x0000 }, {  415, 0x0800 }, {  416, 0x0001 },
    {  417, 0x0000 }, {  417, 0x0000 }, {  417, 0x0000 }, {  417, 0x0000 },
    {  417, 0x0000 }, {  417, 0x0000 }, {  417, 0x0000 }, {  417, 0x0000 },
    /* 0x9e00 */
    {  417, 0x0000 }, {  417, 0x0200 }, {  418, 0x0000 }, {  418, 0x0000 },
    {  418, 0x0000 }, {  418, 0x0000 }, {  418, 0x0000 }, {  418, 0x0000 },
    {  418, 0x0000 }, {  418, 0x0000 }, {  418, 0x0000 }, {  418, 0x0000 },
    {  418, 0x0000 }, {  418, 0x0002 }
};

static const aciConvSummary16 gCp932ExtUni2IndexPagef9[ /*19*/ ] = {
    /* 0xf900 */
    {  419, 0x0000 }, {  419, 0x0000 }, {  419, 0x0200 }, {  420, 0x0000 },
    {  420, 0x0000 }, {  420, 0x0000 }, {  420, 0x0000 }, {  420, 0x0000 },
    {  420, 0x0000 }, {  420, 0x0000 }, {  420, 0x0000 }, {  420, 0x0000 },
    {  420, 0x0000 }, {  420, 0x1000 }, {  421, 0x0000 }, {  421, 0x0000 },
    /* 0xfa00 */
    {  421, 0xc000 }, {  423, 0xffff }, {  439, 0x3fff }
};

static const aciConvSummary16 gCp932ExtUni2IndexPageff[ /*15*/ ] = {
    /* 0xff00 */
    {  453, 0x0084 }, {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0000 },
    {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0000 },
    {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0000 },
    {  455, 0x0000 }, {  455, 0x0000 }, {  455, 0x0014 }
};

ACP_EXPORT
acp_sint32_t aciConvConvertWcToMb4Cp932ext( void         * aSrc,
                                            acp_sint32_t * aSrcAdvance,
                                            void         * aDest,
                                            acp_sint32_t   aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *     PROJ-2590 [ɼ] CP932 database character set 
 *
 * Implementation :
 *     1) CP932EXT  ȯ 
 *
 ***********************************************************************/

    acp_uint8_t      *  sDestPtr = ( acp_uint8_t * )aDest;
    aciConvSummary16 *  sSummary = NULL;
    acp_uint16_t        sWideChar = 0;
    acp_uint16_t        sVal = 0;
    acp_uint16_t        sUsed = 0;
    acp_uint32_t        sNum = 0;
    acp_sint32_t        sRet = ACICONV_RET_ILUNI;

    if ( aDestRemain < 2 )
    {
        *aSrcAdvance = 2;
        sRet = ACICONV_RET_TOOSMALL;
    }
    else
    {
        ACICONV_UTF16BE_TO_WC( sWideChar, aSrc );

        if ( ( sWideChar >= 0x2100 ) && ( sWideChar < 0x22c0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage21[ ( sWideChar >> 4 ) - 0x210 ];
        }
        else if ( ( sWideChar >= 0x2400 ) && ( sWideChar < 0x2480 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage24[ ( sWideChar >> 4 ) - 0x240 ];
        }
        else if ( ( sWideChar >= 0x3000 ) && ( sWideChar < 0x3020 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage30[ ( sWideChar >> 4 ) - 0x300 ];
        }
        else if ( ( sWideChar >= 0x3200 ) && ( sWideChar < 0x33d0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage32[ ( sWideChar >> 4 ) - 0x320 ];
        }
        else if ( ( sWideChar >= 0x4e00 ) && ( sWideChar < 0x5590 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage4e[ ( sWideChar >> 4 ) - 0x4e0 ];
        }
        else if ( ( sWideChar >= 0x5700 ) && ( sWideChar < 0x59c0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage57[ ( sWideChar >> 4 ) - 0x570 ];
        }
        else if ( ( sWideChar >= 0x5b00 ) && ( sWideChar < 0x5de0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage5b[ ( sWideChar >> 4 ) - 0x5b0 ];
        }
        else if ( ( sWideChar >= 0x5f00 ) && ( sWideChar < 0x7ba0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage5f[ ( sWideChar >> 4 ) - 0x5f0 ];
        }
        else if ( ( sWideChar >= 0x7d00 ) && ( sWideChar < 0x7fb0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage7d[ ( sWideChar >> 4 ) - 0x7d0 ];
        }
        else if ( ( sWideChar >= 0x8300 ) && ( sWideChar < 0x85c0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage83[ ( sWideChar >> 4 ) - 0x830 ];
        }
        else if ( ( sWideChar >= 0x8800 ) && ( sWideChar < 0x8ed0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage88[ ( sWideChar >> 4 ) - 0x880 ];
        }
        else if ( ( sWideChar >= 0x9000 ) && ( sWideChar < 0x9ee0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPage90[ ( sWideChar >> 4 ) - 0x900 ];
        }
        else if ( ( sWideChar >= 0xf900 ) && ( sWideChar < 0xfa30 ) )
        {
            sSummary = &gCp932ExtUni2IndexPagef9[ ( sWideChar >> 4 ) - 0xf90 ];
        }
        else if ( ( sWideChar >= 0xff00 ) && ( sWideChar < 0xfff0 ) )
        {
            sSummary = &gCp932ExtUni2IndexPageff[ ( sWideChar >> 4 ) - 0xff0 ];
        }
        else
        {
            // Nothing to do
        }

        if ( sSummary == NULL )
        {
            *aSrcAdvance = 2;
            sRet = ACICONV_RET_ILUNI;
        }
        else
        {
            sUsed = sSummary->used;
            sNum  = sWideChar & 0x0f;

            if ( sUsed & ( (acp_uint16_t) 1 << sNum ) )
            {
                // Keep in `used' only the bits 0..i-1.
                sUsed &= ( (acp_uint16_t) 1 << sNum ) - 1;

                // Add `summary->indx' and the number of bits set in `used'.
                sUsed = ( sUsed & 0x5555 ) + ( ( sUsed & 0xaaaa ) >> 1 );
                sUsed = ( sUsed & 0x3333 ) + ( ( sUsed & 0xcccc ) >> 2 );
                sUsed = ( sUsed & 0x0f0f ) + ( ( sUsed & 0xf0f0 ) >> 4 );
                sUsed = ( sUsed & 0x00ff ) + ( sUsed >> 8 );

                sVal = gCp932Ext2Charset[ sSummary->indx + sUsed ] ^ ACI_CP932EXT_XOR_VALUE;

                sDestPtr[ 0 ] = ( sVal >> 8 );
                sDestPtr[ 1 ] = ( sVal & 0xff );

                *aSrcAdvance = 2;
                sRet = 2;
            }
            else
            {
                *aSrcAdvance = 2;
                sRet = ACICONV_RET_ILUNI;
            }
        }
    }

    return sRet;
}
