/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvGb2312.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvAscii.h>
#include <aciConvGb2312.h>

static const acp_uint16_t gb2312_2uni_page21[ /*831*/ ] = {
  /* 0x21 */
  0x340d, 0x340c, 0x340f, 0x34f6, 0x06c4, 0x06ca, 0x04a5, 0x340e,
  0x3408, 0x2418, 0xfb53, 0x241b, 0x242b, 0x2415, 0x2414, 0x2411,
  0x2410, 0x3419, 0x3418, 0x3405, 0x3404, 0x3407, 0x3406, 0x3401,
  0x3400, 0x3403, 0x3402, 0x341b, 0x341a, 0x341d, 0x341c, 0x04bc,
  0x04da, 0x04fa, 0x263b, 0x262a, 0x2625, 0x261c, 0x2602, 0x2627,
  0x2624, 0x2605, 0x263a, 0x2617, 0x26a8, 0x2628, 0x262d, 0x271f,
  0x2694, 0x2626, 0x2623, 0x266c, 0x2641, 0x2645, 0x2630, 0x2610,
  0x266d, 0x2663, 0x2662, 0x2669, 0x2668, 0x2613, 0x2638, 0x2639,
  0x224f, 0x224d, 0x04bd, 0x243f, 0x243e, 0x250e, 0xfb09, 0x04a9,
  0xfbed, 0xfbec, 0x243d, 0x04aa, 0x251b, 0x220b, 0x2208, 0x21c6,
  0x21c2, 0x21c3, 0x21ca, 0x21cb, 0x21ac, 0x21ad, 0x21be, 0x21bf,
  0x2436, 0x259f, 0x259d, 0x259c, 0x259e, 0x341e,
  /* 0x22 */
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x2085, 0x2084, 0x2087, 0x2086, 0x2081, 0x2080, 0x2083, 0x2082,
  0x209d, 0x209c, 0x209f, 0x209e, 0x2099, 0x2098, 0x209b, 0x209a,
  0x2095, 0x2094, 0x2097, 0x2096, 0x2079, 0x2078, 0x207b, 0x207a,
  0x2075, 0x2074, 0x2077, 0x2076, 0x2071, 0x2070, 0x2073, 0x2072,
  0x208d, 0x208c, 0x208f, 0x208e, 0x2089, 0x2088, 0x208b, 0x208a,
  0x206d, 0x206c, 0x206f, 0x206e, 0x2069, 0x2068, 0x206b, 0x206a,
  0x2065, 0x2064, 0xfbf0, 0xfbf0, 0x362d, 0x362c, 0x362f, 0x362e,
  0x3629, 0x3628, 0x362b, 0x362a, 0x3625, 0x3624, 0xfbf0, 0xfbf0,
  0x256d, 0x256c, 0x256f, 0x256e, 0x2569, 0x2568, 0x256b, 0x256a,
  0x2565, 0x2564, 0x2567, 0x2566, 0xfbf0, 0xfbf0,
  /* 0x23 */
  0xfb0c, 0xfb0f, 0xfb0e, 0xfbe8, 0xfb08, 0xfb0b, 0xfb0a, 0xfb05,
  0xfb04, 0xfb07, 0xfb06, 0xfb01, 0xfb00, 0xfb03, 0xfb02, 0xfb1d,
  0xfb1c, 0xfb1f, 0xfb1e, 0xfb19, 0xfb18, 0xfb1b, 0xfb1a, 0xfb15,
  0xfb14, 0xfb17, 0xfb16, 0xfb11, 0xfb10, 0xfb13, 0xfb12, 0xfb2d,
  0xfb2c, 0xfb2f, 0xfb2e, 0xfb29, 0xfb28, 0xfb2b, 0xfb2a, 0xfb25,
  0xfb24, 0xfb27, 0xfb26, 0xfb21, 0xfb20, 0xfb23, 0xfb22, 0xfb3d,
  0xfb3c, 0xfb3f, 0xfb3e, 0xfb39, 0xfb38, 0xfb3b, 0xfb3a, 0xfb35,
  0xfb34, 0xfb37, 0xfb36, 0xfb31, 0xfb30, 0xfb33, 0xfb32, 0xfb4d,
  0xfb4c, 0xfb4f, 0xfb4e, 0xfb49, 0xfb48, 0xfb4b, 0xfb4a, 0xfb45,
  0xfb44, 0xfb47, 0xfb46, 0xfb41, 0xfb40, 0xfb43, 0xfb42, 0xfb5d,
  0xfb5c, 0xfb5f, 0xfb5e, 0xfb59, 0xfb58, 0xfb5b, 0xfb5a, 0xfb55,
  0xfb54, 0xfb57, 0xfb56, 0xfb51, 0xfb50, 0xfbee,
  /* 0x24 */
  0x344c, 0x344f, 0x344e, 0x3449, 0x3448, 0x344b, 0x344a, 0x3445,
  0x3444, 0x3447, 0x3446, 0x3441, 0x3440, 0x3443, 0x3442, 0x345d,
  0x345c, 0x345f, 0x345e, 0x3459, 0x3458, 0x345b, 0x345a, 0x3455,
  0x3454, 0x3457, 0x3456, 0x3451, 0x3450, 0x3453, 0x3452, 0x346d,
  0x346c, 0x346f, 0x346e, 0x3469, 0x3468, 0x346b, 0x346a, 0x3465,
  0x3464, 0x3467, 0x3466, 0x3461, 0x3460, 0x3463, 0x3462, 0x347d,
  0x347c, 0x347f, 0x347e, 0x3479, 0x3478, 0x347b, 0x347a, 0x3475,
  0x3474, 0x3477, 0x3476, 0x3471, 0x3470, 0x3473, 0x3472, 0x348d,
  0x348c, 0x348f, 0x348e, 0x3489, 0x3488, 0x348b, 0x348a, 0x3485,
  0x3484, 0x3487, 0x3486, 0x3481, 0x3480, 0x3483, 0x3482, 0x349d,
  0x349c, 0x349f, 0x349e, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x25 */
  0x34ac, 0x34af, 0x34ae, 0x34a9, 0x34a8, 0x34ab, 0x34aa, 0x34a5,
  0x34a4, 0x34a7, 0x34a6, 0x34a1, 0x34a0, 0x34a3, 0x34a2, 0x34bd,
  0x34bc, 0x34bf, 0x34be, 0x34b9, 0x34b8, 0x34bb, 0x34ba, 0x34b5,
  0x34b4, 0x34b7, 0x34b6, 0x34b1, 0x34b0, 0x34b3, 0x34b2, 0x34cd,
  0x34cc, 0x34cf, 0x34ce, 0x34c9, 0x34c8, 0x34cb, 0x34ca, 0x34c5,
  0x34c4, 0x34c7, 0x34c6, 0x34c1, 0x34c0, 0x34c3, 0x34c2, 0x34dd,
  0x34dc, 0x34df, 0x34de, 0x34d9, 0x34d8, 0x34db, 0x34da, 0x34d5,
  0x34d4, 0x34d7, 0x34d6, 0x34d1, 0x34d0, 0x34d3, 0x34d2, 0x34ed,
  0x34ec, 0x34ef, 0x34ee, 0x34e9, 0x34e8, 0x34eb, 0x34ea, 0x34e5,
  0x34e4, 0x34e7, 0x34e6, 0x34e1, 0x34e0, 0x34e3, 0x34e2, 0x34fd,
  0x34fc, 0x34ff, 0x34fe, 0x34f9, 0x34f8, 0x34fb, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x26 */
  0x079c, 0x079f, 0x079e, 0x0799, 0x0798, 0x079b, 0x079a, 0x0795,
  0x0794, 0x0797, 0x0796, 0x0791, 0x0790, 0x0793, 0x0792, 0x07ad,
  0x07ac, 0x07ae, 0x07a9, 0x07a8, 0x07ab, 0x07aa, 0x07a5, 0x07a4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x07bc, 0x07bf, 0x07be, 0x07b9, 0x07b8, 0x07bb, 0x07ba, 0x07b5,
  0x07b4, 0x07b7, 0x07b6, 0x07b1, 0x07b0, 0x07b3, 0x07b2, 0x07cd,
  0x07cc, 0x07ce, 0x07c9, 0x07c8, 0x07cb, 0x07ca, 0x07c5, 0x07c4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x27 */
  0x001d, 0x001c, 0x001f, 0x001e, 0x0019, 0x0018, 0x000c, 0x001b,
  0x001a, 0x0015, 0x0014, 0x0017, 0x0016, 0x0011, 0x0010, 0x0013,
  0x0012, 0x002d, 0x002c, 0x002f, 0x002e, 0x0029, 0x0028, 0x002b,
  0x002a, 0x0025, 0x0024, 0x0027, 0x0026, 0x0021, 0x0020, 0x0023,
  0x0022, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x003d, 0x003c, 0x003f, 0x003e, 0x0039, 0x0038, 0x005c, 0x003b,
  0x003a, 0x0035, 0x0034, 0x0037, 0x0036, 0x0031, 0x0030, 0x0033,
  0x0032, 0x004d, 0x004c, 0x004f, 0x004e, 0x0049, 0x0048, 0x004b,
  0x004a, 0x0045, 0x0044, 0x0047, 0x0046, 0x0041, 0x0040, 0x0043,
  0x0042, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x28 */
  0x050c, 0x04ec, 0x05c3, 0x04ed, 0x051e, 0x04e4, 0x0516, 0x04e5,
  0x0526, 0x04e0, 0x05dd, 0x04e1, 0x0540, 0x04fe, 0x05df, 0x04ff,
  0x0566, 0x04f7, 0x05d9, 0x04f4, 0x05db, 0x05d5, 0x05d7, 0x05d1,
  0x04f1, 0x04e7, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0x3508, 0x350b, 0x350a, 0x3505,
  0x3504, 0x3507, 0x3506, 0x3501, 0x3500, 0x3503, 0x3502, 0x351d,
  0x351c, 0x351f, 0x351e, 0x3519, 0x3518, 0x351b, 0x351a, 0x3515,
  0x3514, 0x3517, 0x3516, 0x3511, 0x3510, 0x3513, 0x3512, 0x352d,
  0x352c, 0x352f, 0x352e, 0x3529, 0x3528, 0x352b, 0x352a, 0x3525,
  0x3524, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x29 */
  0xfbf0, 0xfbf0, 0xfbf0, 0x210d, 0x210c, 0x210f, 0x210e, 0x2109,
  0x2108, 0x210b, 0x210a, 0x2105, 0x2104, 0x2107, 0x2106, 0x2101,
  0x2100, 0x2103, 0x2102, 0x211d, 0x211c, 0x211f, 0x211e, 0x2119,
  0x2118, 0x211b, 0x211a, 0x2115, 0x2114, 0x2117, 0x2116, 0x2111,
  0x2110, 0x2113, 0x2112, 0x212d, 0x212c, 0x212f, 0x212e, 0x2129,
  0x2128, 0x212b, 0x212a, 0x2125, 0x2124, 0x2127, 0x2126, 0x2121,
  0x2120, 0x2123, 0x2122, 0x213d, 0x213c, 0x213f, 0x213e, 0x2139,
  0x2138, 0x213b, 0x213a, 0x2135, 0x2134, 0x2137, 0x2136, 0x2131,
  0x2130, 0x2133, 0x2132, 0x214d, 0x214c, 0x214f, 0x214e, 0x2149,
  0x2148, 0x214b, 0x214a, 0x2145, 0x2144, 0x2147, 0x2146
};

static const acp_uint16_t gb2312_2uni_page30[ /*6768*/ ] = {
  /* 0x30 */
  0x5147, 0x9232, 0x53ce, 0x6725, 0x50c3, 0x5104, 0x50cd, 0x729c,
  0x7241, 0x8131, 0x73e3, 0x8673, 0x7c80, 0x763c, 0x9295, 0x9380,
  0x6825, 0x5f84, 0x4bf7, 0x6704, 0x629a, 0x58b5, 0x84f7, 0x6c45,
  0x84a3, 0x620f, 0x72c3, 0x55f4, 0x615b, 0x75a1, 0x7bfc, 0x8c89,
  0x54bf, 0x5d68, 0x65c7, 0x6bbe, 0x86a0, 0x6741, 0x665f, 0x57e0,
  0x502a, 0x7f0b, 0x5566, 0x71a9, 0x59f9, 0x66d9, 0x89c6, 0x937b,
  0x6687, 0x8414, 0x5350, 0x9335, 0x7b6f, 0x7635, 0x7270, 0x63c2,
  0x7273, 0x604b, 0x4b7d, 0x8928, 0x66d1, 0x7e1a, 0x619c, 0x77e0,
  0x6021, 0x667e, 0x8621, 0x9c8c, 0x6372, 0x7645, 0x6663, 0x66c1,
  0x4b39, 0x70ee, 0x5747, 0x5693, 0x7ac7, 0x94ab, 0x5a23, 0x6c8b,
  0x6d91, 0x858d, 0x7adc, 0x6cdf, 0x7cc8, 0x8281, 0x915c, 0x5480,
  0x8829, 0x86d3, 0x84d3, 0x5708, 0x8d1f, 0x5668,
  /* 0x31 */
  0x8189, 0x92f4, 0x4bd0, 0x5c2c, 0x9d7c, 0x5f90, 0x66bc, 0x66a8,
  0x62b9, 0x8874, 0x9880, 0x760b, 0x6362, 0x7c9c, 0x64bf, 0x575c,
  0x571a, 0x8b85, 0x84c1, 0x8910, 0x90ac, 0x5400, 0x76c5, 0x5d0a,
  0x64e6, 0x7514, 0x8ca6, 0x5d59, 0x86e2, 0x6321, 0x7f25, 0x5924,
  0x7afa, 0x7120, 0x68f8, 0x8a6b, 0x8bf5, 0x9431, 0x9b36, 0x6fd9,
  0x9514, 0x7f19, 0x5b71, 0x7caa, 0x80db, 0x8130, 0x6fd8, 0x6fd4,
  0x6fdb, 0x5a0c, 0x5a8a, 0x71f4, 0x91e0, 0x6150, 0x5b07, 0x5bc8,
  0x8b92, 0x5ccc, 0x85cf, 0x9472, 0x9256, 0x93a0, 0x8bb4, 0x7b1b,
  0x8921, 0x664c, 0x4bb2, 0x57d5, 0x5753, 0x8ba5, 0x8ba4, 0x8ba6,
  0x9440, 0x6c0a, 0x5b67, 0x8595, 0x8c65, 0x98db, 0x6586, 0x5626,
  0x7227, 0x5b61, 0x6181, 0x6bdf, 0x6ae5, 0x5fb3, 0x6045, 0x5578,
  0x55bd, 0x63c9, 0x4a14, 0x7dc4, 0x9d71, 0x74be,
  /* 0x32 */
  0x71c8, 0x5a7b, 0x77b6, 0x87ed, 0x60a0, 0x66e5, 0x90b8, 0x68ef,
  0x5757, 0x56ce, 0x6002, 0x90cf, 0x7f99, 0x4b22, 0x5a16, 0x863b,
  0x851b, 0x8587, 0x6a29, 0x68c7, 0x9e7e, 0x6758, 0x5751, 0x50f7,
  0x8c68, 0x53ed, 0x4a00, 0x5a0e, 0x6f68, 0x7832, 0x94e5, 0x641b,
  0x60eb, 0x7711, 0x8ccc, 0x635d, 0x6640, 0x892f, 0x7361, 0x8a24,
  0x95ca, 0x5b64, 0x87d1, 0x812c, 0x9d1d, 0x57cf, 0x8298, 0x6f86,
  0x64e0, 0x64e5, 0x7472, 0x86c0, 0x863c, 0x4ade, 0x68aa, 0x81c2,
  0x60c0, 0x78d4, 0x6df0, 0x62f4, 0x8744, 0x5798, 0x7f5b, 0x4baa,
  0x5581, 0x6946, 0x584f, 0x8a60, 0x67df, 0x57c4, 0x8721, 0x873b,
  0x63e8, 0x7cb9, 0x6030, 0x5fd2, 0x5899, 0x59e3, 0x8fea, 0x66cb,
  0x63f9, 0x8877, 0x600d, 0x67b7, 0x8344, 0x9d86, 0x881a, 0x7b2d,
  0x90ff, 0x4aaa, 0x921d, 0x9ca9, 0x6201, 0x771b,
  /* 0x33 */
  0x5337, 0x5810, 0x5a35, 0x9172, 0x5472, 0x84ad, 0x578f, 0x6153,
  0x7148, 0x513c, 0x542c, 0x8988, 0x6689, 0x9093, 0x6310, 0x523f,
  0x6b63, 0x59ef, 0x5038, 0x749f, 0x8b6b, 0x6662, 0x60a9, 0x67ae,
  0x5b76, 0x6b85, 0x94f9, 0x85ee, 0x8bbd, 0x5815, 0x6265, 0x5bfc,
  0x6884, 0x9245, 0x898c, 0x8c61, 0x609c, 0x7dfd, 0x53c3, 0x6e54,
  0x661d, 0x5045, 0x4a55, 0x7e06, 0x64e4, 0x6b89, 0x8fd7, 0x6672,
  0x9413, 0x9e86, 0x7de9, 0x500e, 0x71f9, 0x670c, 0x5714, 0x686d,
  0x8bd2, 0x5b16, 0x9e7d, 0x8436, 0x9b72, 0x4b85, 0x5837, 0x8969,
  0x7bc8, 0x61a8, 0x74b0, 0x5548, 0x55bf, 0x8266, 0x590a, 0x5fad,
  0x66b0, 0x9561, 0x7179, 0x8a01, 0x7e2d, 0x650c, 0x7f74, 0x4aca,
  0x7af5, 0x7388, 0x4a1c, 0x85e0, 0x5610, 0x55f7, 0x6e7c, 0x57a5,
  0x8a8a, 0x9109, 0x92c2, 0x6acc, 0x9269, 0x6d57,
  /* 0x34 */
  0x7c4d, 0x54a5, 0x73da, 0x601d, 0x8deb, 0x5d09, 0x67ee, 0x59d0,
  0x7e72, 0x6d30, 0x4b2d, 0x8634, 0x5195, 0x4a3f, 0x71a3, 0x7e9a,
  0x5a6f, 0x5a87, 0x91e2, 0x5616, 0x5034, 0x7487, 0x677b, 0x9129,
  0x538f, 0x6228, 0x6d32, 0x958a, 0x510a, 0x69fe, 0x7aa2, 0x8c2f,
  0x663e, 0x7afd, 0x71b8, 0x8725, 0x7ccc, 0x92c1, 0x8b93, 0x6545,
  0x70fa, 0x8fc0, 0x6f69, 0x5637, 0x895d, 0x6f2c, 0x8467, 0x807c,
  0x52fc, 0x570b, 0x4ac3, 0x4a16, 0x55dc, 0x789a, 0x9586, 0x780a,
  0x4bce, 0x8a72, 0x7fec, 0x7e91, 0x606a, 0x5919, 0x54a1, 0x850b,
  0x720c, 0x78b4, 0x69e1, 0x7bed, 0x635c, 0x5f55, 0x5ff5, 0x7cc6,
  0x60a3, 0x601e, 0x67a7, 0x6726, 0x9114, 0x6020, 0x8bb3, 0x7f59,
  0x7224, 0x665e, 0x5d2a, 0x504b, 0x6f74, 0x54ae, 0x6639, 0x5a2b,
  0x6f8b, 0x4aee, 0x893a, 0x8c86, 0x5b88, 0x9423,
  /* 0x35 */
  0x642d, 0x8430, 0x66c8, 0x4a34, 0x5758, 0x94f5, 0x67b5, 0x84cb,
  0x61eb, 0x6823, 0x4b4b, 0x64e3, 0x69ec, 0x8fd3, 0x5b34, 0x82c6,
  0x5b5e, 0x672c, 0x5557, 0x876c, 0x6c6e, 0x560d, 0x676e, 0x8a45,
  0x541f, 0x5896, 0x7d7a, 0x5ff1, 0x563d, 0x7e36, 0x64b1, 0x945e,
  0x72da, 0x5bba, 0x5b9a, 0x7289, 0x8a61, 0x7462, 0x7276, 0x7f44,
  0x73a7, 0x55fe, 0x949e, 0x5c29, 0x4b43, 0x6af9, 0x8be7, 0x6141,
  0x7f16, 0x76c9, 0x69a9, 0x7bd2, 0x5eec, 0x66b8, 0x5a98, 0x533d,
  0x808f, 0x7f21, 0x5a10, 0x5b12, 0x941f, 0x7b19, 0x9cad, 0x678f,
  0x6aca, 0x7c95, 0x74b4, 0x5575, 0x9356, 0x53a6, 0x7138, 0x4b4e,
  0x7135, 0x5a9a, 0x64eb, 0x5d6d, 0x69cd, 0x6fb2, 0x7c84, 0x57f1,
  0x92d8, 0x55c6, 0x560c, 0x6784, 0x5007, 0x909e, 0x880e, 0x89c1,
  0x7634, 0x7c92, 0x837b, 0x8be0, 0x8800, 0x57ed,
  /* 0x36 */
  0x4a0c, 0x72e2, 0x57e3, 0x9084, 0x9c7b, 0x9b03, 0x9120, 0x5f97,
  0x8faf, 0x4a2f, 0x4a11, 0x55a1, 0x806e, 0x65cf, 0x56a5, 0x6c06,
  0x4b9a, 0x6466, 0x55b6, 0x6913, 0x5551, 0x669b, 0x619a, 0x926c,
  0x884b, 0x941a, 0x71d5, 0x94f0, 0x736e, 0x6fdf, 0x7687, 0x76e1,
  0x8ff6, 0x5c38, 0x7374, 0x8941, 0x6351, 0x914d, 0x8497, 0x5aab,
  0x6a2c, 0x5d9f, 0x7ee2, 0x73e0, 0x9136, 0x6fb8, 0x61a0, 0x7b03,
  0x5c0b, 0x555c, 0x9212, 0x5ff4, 0x5ca4, 0x5025, 0x8a7f, 0x616b,
  0x9c72, 0x52e9, 0x9090, 0x72f3, 0x944c, 0x678a, 0x50cb, 0x5d17,
  0x5d37, 0x5396, 0x8abf, 0x6338, 0x89f7, 0x8638, 0x564c, 0x64fd,
  0x5c18, 0x82f3, 0x58e5, 0x9a48, 0x4bc9, 0x9c90, 0x8fb4, 0x5e28,
  0x647b, 0x5789, 0x6671, 0x9442, 0x950f, 0x9d72, 0x6464, 0x8401,
  0x5532, 0x843e, 0x5819, 0x9d78, 0x693c, 0x4a81,
  /* 0x37 */
  0x893d, 0x57dc, 0x7b57, 0x7f42, 0x4b1d, 0x4a42, 0x920d, 0x68d8,
  0x77dd, 0x81e4, 0x5a0b, 0x7167, 0x7bf6, 0x6e07, 0x73f3, 0x909f,
  0x7a4c, 0x55ec, 0x74eb, 0x57c0, 0x8bd9, 0x870e, 0x8924, 0x76a2,
  0x9d60, 0x68d6, 0x5347, 0x86be, 0x61b4, 0x84a7, 0x6632, 0x923f,
  0x5da5, 0x4af2, 0x8fb2, 0x7ab7, 0x6133, 0x87ff, 0x9353, 0x516c,
  0x9cd3, 0x84a8, 0x5727, 0x8ff0, 0x502d, 0x84b7, 0x5a92, 0x68b5,
  0x8934, 0x86a1, 0x9557, 0x5024, 0x6816, 0x560b, 0x7aba, 0x5352,
  0x7517, 0x6873, 0x7884, 0x5d46, 0x4af0, 0x5bf2, 0x6529, 0x78a7,
  0x4a3d, 0x580c, 0x63a6, 0x830f, 0x58fd, 0x9106, 0x9cc3, 0x71a2,
  0x74f0, 0x942f, 0x55a2, 0x7b10, 0x8fb0, 0x5d44, 0x55e9, 0x4b56,
  0x502b, 0x5d26, 0x617a, 0x84a9, 0x5f78, 0x667b, 0x66cf, 0x8b9d,
  0x5a48, 0x6812, 0x7f2b, 0x4b02, 0x4bd5, 0x6300,
  /* 0x38 */
  0x6963, 0x69a7, 0x7d82, 0x8cbc, 0x5b1a, 0x7126, 0x6697, 0x8b88,
  0x4be2, 0x95d1, 0x61aa, 0x8522, 0x855c, 0x5a91, 0x855d, 0x8979,
  0x5662, 0x8d8b, 0x8946, 0x5d00, 0x5488, 0x4ad5, 0x9211, 0x763b,
  0x8574, 0x8912, 0x5fc1, 0x8fae, 0x9249, 0x5d8a, 0x7b17, 0x509d,
  0x527b, 0x5203, 0x8fe8, 0x6134, 0x6d8f, 0x9094, 0x72db, 0x6a84,
  0x5a7f, 0x7115, 0x634b, 0x63dc, 0x7ef2, 0x8490, 0x897b, 0x6512,
  0x7dcb, 0x616f, 0x896e, 0x5585, 0x5617, 0x90af, 0x7b35, 0x8496,
  0x7abf, 0x589a, 0x6a22, 0x636d, 0x7fd4, 0x7286, 0x9ed5, 0x8582,
  0x7b99, 0x78d8, 0x6013, 0x915d, 0x7e32, 0x5047, 0x50e8, 0x6f41,
  0x600c, 0x6605, 0x9a30, 0x84fe, 0x7194, 0x567f, 0x9364, 0x8056,
  0x6c31, 0x82e9, 0x920c, 0x9299, 0x90e1, 0x4a27, 0x5009, 0x7ad4,
  0x6c34, 0x89d2, 0x8418, 0x62f9, 0x5a97, 0x7bb4,
  /* 0x39 */
  0x53cf, 0x8432, 0x6c9a, 0x59e8, 0x6136, 0x5692, 0x6460, 0x9b97,
  0x4b96, 0x8aa1, 0x5561, 0x5fa6, 0x5b1e, 0x59e4, 0x6853, 0x66fc,
  0x892c, 0x557c, 0x90a4, 0x56f3, 0x6892, 0x86d2, 0x76da, 0x53af,
  0x6389, 0x8920, 0x5d12, 0x8b91, 0x87ca, 0x5098, 0x7f80, 0x4b3d,
  0x68b0, 0x5f69, 0x5ddc, 0x9b1e, 0x57e9, 0x82c7, 0x9ea5, 0x883a,
  0x84ac, 0x6148, 0x9c73, 0x52f7, 0x92ca, 0x5623, 0x70d1, 0x565d,
  0x5fec, 0x670f, 0x8d0f, 0x4a5b, 0x66dd, 0x6427, 0x6cf7, 0x557e,
  0x5f95, 0x55ad, 0x8dcf, 0x7fac, 0x9d8b, 0x7b5d, 0x64e2, 0x7441,
  0x8922, 0x5544, 0x5a72, 0x9416, 0x707d, 0x8dc9, 0x5320, 0x7c48,
  0x5b5f, 0x9b92, 0x91f7, 0x8b65, 0x9f31, 0x8fec, 0x7275, 0x6c4f,
  0x63d1, 0x89e7, 0x8938, 0x5630, 0x8b87, 0x6ad7, 0x6cc0, 0x9108,
  0x94e0, 0x52f0, 0x6391, 0x8cf4, 0x8bca, 0x50c5,
  /* 0x3a */
  0x9eb5, 0x5f64, 0x697a, 0x682b, 0x4aa8, 0x5fbe, 0x9e8a, 0x956e,
  0x65a5, 0x94a2, 0x93e4, 0x5026, 0x69b8, 0x5fdf, 0x55f0, 0x5187,
  0x7b58, 0x7bfd, 0x60b1, 0x6740, 0x61fc, 0x65b3, 0x6480, 0x7507,
  0x685a, 0x6844, 0x5d22, 0x6360, 0x8627, 0x5cd8, 0x5283, 0x8867,
  0x6fe6, 0x94d0, 0x5d70, 0x841a, 0x57fa, 0x6964, 0x5078, 0x5190,
  0x877a, 0x87c2, 0x6c35, 0x7db3, 0x5081, 0x4b58, 0x5005, 0x72df,
  0x8884, 0x920f, 0x68be, 0x69b5, 0x8966, 0x8d1d, 0x9a69, 0x8937,
  0x5232, 0x9adc, 0x71d8, 0x5b85, 0x76ed, 0x6465, 0x50f1, 0x4aa5,
  0x6e27, 0x8c6c, 0x645f, 0x8b7d, 0x50c9, 0x74d5, 0x8274, 0x9a32,
  0x6927, 0x5f82, 0x5b15, 0x7aaf, 0x5184, 0x4ba2, 0x7739, 0x5031,
  0x5797, 0x5414, 0x5003, 0x5071, 0x4a43, 0x5bf0, 0x7057, 0x5cfb,
  0x8066, 0x84ec, 0x8379, 0x76dd, 0x78c7, 0x6a5b,
  /* 0x3b */
  0x5b2a, 0x8243, 0x5121, 0x66a9, 0x4a9f, 0x68a7, 0x663a, 0x86bc,
  0x50da, 0x5743, 0x7733, 0x6adc, 0x7136, 0x561f, 0x571b, 0x8fd0,
  0x6ddd, 0x5b87, 0x640d, 0x69e3, 0x5342, 0x6f2f, 0x77a2, 0x6c5e,
  0x8bd5, 0x7b1e, 0x676f, 0x64ae, 0x5129, 0x71e7, 0x886f, 0x7518,
  0x69ae, 0x5fab, 0x5a76, 0x875f, 0x6541, 0x9ac9, 0x7cf7, 0x835a,
  0x782a, 0x728a, 0x55fd, 0x64fb, 0x7541, 0x624e, 0x5a41, 0x6440,
  0x8803, 0x747d, 0x6728, 0x8b84, 0x5bb0, 0x646f, 0x82d9, 0x52d3,
  0x6fcc, 0x6499, 0x656a, 0x5744, 0x64ed, 0x626b, 0x8932, 0x7df0,
  0x4b17, 0x74e4, 0x684a, 0x8fbe, 0x8fff, 0x7ad5, 0x8769, 0x6202,
  0x5e57, 0x9f4f, 0x695c, 0x69fa, 0x884c, 0x6936, 0x4b14, 0x7466,
  0x87ba, 0x661b, 0x64dc, 0x9300, 0x892a, 0x7d75, 0x55f6, 0x5333,
  0x53f7, 0x6337, 0x7175, 0x7e30, 0x7de2, 0x7f98,
  /* 0x3c */
  0x8481, 0x9d68, 0x8bf4, 0x6bcd, 0x8fa8, 0x9a2c, 0x5de1, 0x7ae4,
  0x7b04, 0x5004, 0x638c, 0x6cd5, 0x8b9c, 0x7840, 0x92cb, 0x57c7,
  0x6428, 0x71b3, 0x687f, 0x577e, 0x5ec4, 0x7aaa, 0x6729, 0x55ed,
  0x8507, 0x59fc, 0x80d2, 0x668d, 0x558d, 0x5f6e, 0x4b03, 0x7d60,
  0x564f, 0x64b5, 0x6943, 0x5fc9, 0x5fcf, 0x8fac, 0x8fbd, 0x61ef,
  0x5bc1, 0x9248, 0x5d9e, 0x7aea, 0x7aa7, 0x5204, 0x63ba, 0x5d34,
  0x4b7e, 0x5fbb, 0x56ad, 0x8757, 0x9c87, 0x8933, 0x713f, 0x90b3,
  0x544a, 0x7e31, 0x4afa, 0x63bb, 0x9e73, 0x5ecc, 0x6f71, 0x72dc,
  0x5357, 0x581b, 0x7f37, 0x91f9, 0x7543, 0x5571, 0x84a4, 0x867d,
  0x5d75, 0x7b09, 0x872a, 0x6ccd, 0x63e1, 0x7cbc, 0x7c7a, 0x66ee,
  0x676c, 0x7f8d, 0x4be0, 0x5667, 0x55c2, 0x875d, 0x6dd6, 0x9679,
  0x89f8, 0x893c, 0x8dcc, 0x9123, 0x7fa0, 0x4afb,
  /* 0x3d */
  0x5468, 0x863d, 0x565c, 0x9d62, 0x6a1d, 0x6a88, 0x69aa, 0x5af7,
  0x54f8, 0x5dd1, 0x580b, 0x694b, 0x6852, 0x718b, 0x8086, 0x6c65,
  0x5d5b, 0x8fbf, 0x572d, 0x957c, 0x9240, 0x8144, 0x6d1f, 0x7d0c,
  0x752b, 0x84fb, 0x4aa9, 0x94c7, 0x694a, 0x9e89, 0x5e0a, 0x52b1,
  0x6008, 0x90fd, 0x73e6, 0x4ba8, 0x8517, 0x76ec, 0x8ddf, 0x9d77,
  0x7b39, 0x7ad3, 0x5672, 0x6154, 0x9578, 0x8b72, 0x8b8e, 0x57e6,
  0x7e9b, 0x67e0, 0x67a8, 0x728b, 0x7df5, 0x8c5a, 0x923b, 0x6627,
  0x56a6, 0x868f, 0x6c59, 0x637d, 0x677a, 0x7366, 0x7ee0, 0x690c,
  0x7ade, 0x8dee, 0x5ddd, 0x661f, 0x81c4, 0x86a8, 0x7141, 0x5412,
  0x4ac6, 0x71a8, 0x8fe6, 0x5847, 0x59f3, 0x7f46, 0x61a9, 0x95dc,
  0x4ac7, 0x6928, 0x8d52, 0x792a, 0x912b, 0x4ac8, 0x8825, 0x8bd6,
  0x937e, 0x6246, 0x7d8c, 0x8bdc, 0x74e1, 0x6975,
  /* 0x3e */
  0x5830, 0x56bf, 0x874b, 0x556f, 0x8703, 0x7356, 0x627b, 0x98b5,
  0x4aa1, 0x64c7, 0x78b3, 0x78be, 0x7ac2, 0x4a98, 0x8f6b, 0x6262,
  0x9c85, 0x9354, 0x5c8e, 0x6161, 0x9151, 0x5b89, 0x71c4, 0x935b,
  0x7ed2, 0x7ed3, 0x55cd, 0x74a2, 0x7e95, 0x67e7, 0x7e7b, 0x7aad,
  0x779b, 0x93e0, 0x4a48, 0x7475, 0x4a50, 0x955f, 0x57a4, 0x615c,
  0x61ea, 0x85f1, 0x8608, 0x5083, 0x583c, 0x7197, 0x93ad, 0x66d5,
  0x76d4, 0x71b0, 0x5848, 0x9e74, 0x87c7, 0x584d, 0x508d, 0x73e4,
  0x4a33, 0x68a3, 0x8457, 0x66df, 0x6763, 0x59e5, 0x557a, 0x89d0,
  0x8a13, 0x9122, 0x4bfc, 0x57e8, 0x64ea, 0x74a1, 0x566a, 0x675d,
  0x9a4e, 0x5e12, 0x542b, 0x733a, 0x577a, 0x7aef, 0x6088, 0x6126,
  0x6684, 0x6795, 0x5419, 0x7638, 0x8dc4, 0x55be, 0x8fcd, 0x7ad0,
  0x534a, 0x87c1, 0x90aa, 0x5596, 0x5016, 0x58f6,
  /* 0x3f */
  0x4bc7, 0x7eee, 0x6957, 0x94ec, 0x9e82, 0x518d, 0x509b, 0x576c,
  0x50a2, 0x5b0d, 0x67e4, 0x6d7a, 0x55e2, 0x6565, 0x5607, 0x5c27,
  0x56d5, 0x5343, 0x7c00, 0x7306, 0x5aba, 0x657a, 0x78ed, 0x6656,
  0x669a, 0x4aaf, 0x7498, 0x840e, 0x66fa, 0x74e9, 0x936d, 0x537a,
  0x86d6, 0x63e2, 0x6cf8, 0x7cd8, 0x9c9a, 0x7ddc, 0x5cfe, 0x50be,
  0x57e2, 0x6a39, 0x5546, 0x5636, 0x5faf, 0x8ff3, 0x84a2, 0x514e,
  0x53ab, 0x647e, 0x535c, 0x5020, 0x7e77, 0x645d, 0x5f59, 0x67aa,
  0x66ad, 0x57ee, 0x666e, 0x5fca, 0x63a2, 0x50e0, 0x7e92, 0x86eb,
  0x957a, 0x5a9e, 0x8ce9, 0x5d35, 0x53a3, 0x6703, 0x89e5, 0x84e2,
  0x535a, 0x7f7a, 0x4ba4, 0x5be6, 0x5fb0, 0x6f33, 0x572c, 0x7f5d,
  0x76cf, 0x6c4b, 0x73f2, 0x733b, 0x61fa, 0x55b8, 0x4a82, 0x72d9,
  0x58b2, 0x7ea8, 0x8078, 0x5d43, 0x9f4c, 0x548d,
  /* 0x40 */
  0x9d85, 0x652a, 0x6a8e, 0x5369, 0x620b, 0x674b, 0x52fd, 0x66e1,
  0x6664, 0x5ade, 0x9219, 0x538e, 0x66c4, 0x518a, 0x832c, 0x8547,
  0x8bae, 0x516b, 0x87bc, 0x6368, 0x895b, 0x80d0, 0x5e67, 0x6c02,
  0x66eb, 0x7fe3, 0x921c, 0x557d, 0x6b91, 0x883d, 0x67f0, 0x8dc5,
  0x65df, 0x7b0b, 0x74cf, 0x6ae8, 0x7008, 0x6d99, 0x76f1, 0x5ac7,
  0x94c3, 0x631a, 0x6967, 0x6753, 0x56be, 0x766f, 0x840c, 0x4b61,
  0x5de8, 0x9567, 0x74d4, 0x6990, 0x56df, 0x4a5d, 0x92fa, 0x9160,
  0x8173, 0x7cc7, 0x7922, 0x552c, 0x539f, 0x60cf, 0x8486, 0x7876,
  0x68e7, 0x6cfc, 0x6d53, 0x55ba, 0x5795, 0x6ca5, 0x768c, 0x9ac3,
  0x7ffc, 0x76f5, 0x7db6, 0x6b1e, 0x700b, 0x6343, 0x95c1, 0x98a9,
  0x7d31, 0x8784, 0x8759, 0x5002, 0x6c1a, 0x4a30, 0x5784, 0x56bc,
  0x7c33, 0x578b, 0x5624, 0x5485, 0x4b86, 0x4bdd,
  /* 0x41 */
  0x71ef, 0x7ec6, 0x789f, 0x68a8, 0x92bb, 0x5696, 0x708e, 0x50e4,
  0x4be4, 0x8459, 0x87bf, 0x8bd3, 0x917d, 0x5ac4, 0x6411, 0x6992,
  0x5a15, 0x6156, 0x8535, 0x90f3, 0x6446, 0x74b1, 0x7ace, 0x78a3,
  0x55c4, 0x6c8c, 0x78bc, 0x8662, 0x4a29, 0x8b8b, 0x95c2, 0x6273,
  0x4aa3, 0x8808, 0x60a4, 0x8447, 0x54d7, 0x719a, 0x75c3, 0x5fe8,
  0x8bb0, 0x6b6b, 0x4a8b, 0x608f, 0x916e, 0x5adb, 0x6194, 0x561a,
  0x8ccf, 0x74c5, 0x56ae, 0x7703, 0x703e, 0x639a, 0x7cfa, 0x931b,
  0x4a39, 0x94b6, 0x98d3, 0x69c6, 0x55d6, 0x894c, 0x5010, 0x66c3,
  0x77bf, 0x87fc, 0x92fb, 0x9b89, 0x90ce, 0x4b3b, 0x7b97, 0x55c1,
  0x7478, 0x9278, 0x58a0, 0x9c8b, 0x57eb, 0x4ae9, 0x6a91, 0x7004,
  0x6db9, 0x7c66, 0x9d82, 0x7154, 0x5615, 0x7229, 0x694c, 0x63fe,
  0x5560, 0x9b94, 0x8446, 0x5094, 0x7f31, 0x7eb2,
  /* 0x42 */
  0x928b, 0x5389, 0x66ef, 0x924a, 0x6d71, 0x5e09, 0x600f, 0x7fde,
  0x6b02, 0x9246, 0x86ab, 0x576f, 0x9c88, 0x5a9d, 0x7484, 0x67be,
  0x5769, 0x8242, 0x988c, 0x9a9e, 0x7c81, 0x933f, 0x89e2, 0x894f,
  0x9a72, 0x6b53, 0x7d89, 0x5b58, 0x924b, 0x6623, 0x9e79, 0x5018,
  0x90d0, 0x4bae, 0x61c8, 0x5868, 0x586c, 0x7b18, 0x825c, 0x6822,
  0x5b86, 0x778a, 0x6ae9, 0x7af2, 0x58eb, 0x6716, 0x5f67, 0x6aeb,
  0x5778, 0x4a7c, 0x67ad, 0x7168, 0x66ac, 0x8b63, 0x4b2b, 0x4adc,
  0x68ab, 0x7abb, 0x8fb7, 0x8010, 0x83b7, 0x7b5a, 0x9436, 0x912e,
  0x7fa4, 0x9eac, 0x8cf5, 0x8030, 0x6916, 0x9e8b, 0x7ad1, 0x5d85,
  0x9ab6, 0x7796, 0x7c0c, 0x828f, 0x9e61, 0x9e8f, 0x5216, 0x501a,
  0x53c6, 0x4a7d, 0x9aab, 0x575b, 0x8bc5, 0x8504, 0x739f, 0x9d9f,
  0x82e3, 0x6aec, 0x811e, 0x62f1, 0x656f, 0x6b26,
  /* 0x43 */
  0x8824, 0x869f, 0x8726, 0x72ff, 0x681e, 0x5bd4, 0x87b0, 0x7726,
  0x8708, 0x9117, 0x6fd6, 0x73d6, 0x90cb, 0x5762, 0x870f, 0x559f,
  0x5a30, 0x8881, 0x8935, 0x4a45, 0x77a6, 0x6397, 0x6c88, 0x957b,
  0x9304, 0x7569, 0x68ac, 0x7304, 0x5e9f, 0x914c, 0x6fc2, 0x7b83,
  0x622a, 0x5fdd, 0x5db4, 0x5e97, 0x91e5, 0x91fa, 0x4ae1, 0x8001,
  0x8094, 0x6ea1, 0x72d2, 0x913d, 0x7716, 0x6cab, 0x5f52, 0x7322,
  0x9597, 0x936c, 0x78d1, 0x8bfa, 0x8811, 0x5b28, 0x787e, 0x7dd5,
  0x8dc8, 0x68c1, 0x8311, 0x5fcb, 0x5a4f, 0x6cc4, 0x732d, 0x7af8,
  0x5598, 0x5540, 0x56c4, 0x5e24, 0x7b08, 0x936f, 0x86da, 0x67c2,
  0x7389, 0x81dd, 0x7ddf, 0x6a37, 0x5a94, 0x5d94, 0x811c, 0x7460,
  0x681c, 0x66b2, 0x72b2, 0x6142, 0x64a2, 0x91f0, 0x6203, 0x8392,
  0x9a2e, 0x90e0, 0x5000, 0x5070, 0x8821, 0x6075,
  /* 0x44 */
  0x6074, 0x821c, 0x6e2c, 0x8591, 0x7ce5, 0x6064, 0x9f59, 0x66b4,
  0x6326, 0x87a6, 0x5ca5, 0x9ad5, 0x68a6, 0x6b2d, 0x5fd3, 0x9241,
  0x8806, 0x7652, 0x63dd, 0x66ca, 0x766c, 0x4aa4, 0x5dcb, 0x6fc0,
  0x5c9e, 0x62a3, 0x5a58, 0x56d2, 0x6558, 0x6325, 0x72e3, 0x736b,
  0x766a, 0x7e4b, 0x66f2, 0x50e7, 0x505d, 0x90ad, 0x94ae, 0x5e11,
  0x7abe, 0x681b, 0x4a4e, 0x5d7b, 0x841d, 0x5d45, 0x575a, 0x713a,
  0x92b3, 0x52c7, 0x672d, 0x851c, 0x6471, 0x91f4, 0x69db, 0x506f,
  0x9d8c, 0x5588, 0x5ee4, 0x84f0, 0x5da3, 0x931e, 0x5427, 0x68e8,
  0x5831, 0x66d2, 0x4b6d, 0x5732, 0x8576, 0x940b, 0x6ab7, 0x8126,
  0x66c5, 0x5a79, 0x7cb3, 0x60b8, 0x6776, 0x5bf8, 0x5e15, 0x9572,
  0x9a12, 0x5832, 0x6742, 0x844f, 0x5f70, 0x5163, 0x9147, 0x9140,
  0x6988, 0x64a5, 0x63ed, 0x76d3, 0x55d0, 0x5f8c,
  /* 0x45 */
  0x66ea, 0x68d3, 0x7656, 0x6660, 0x90a3, 0x7ab0, 0x851e, 0x695e,
  0x5591, 0x5b09, 0x5d79, 0x56a7, 0x641f, 0x5d7e, 0x629b, 0x825d,
  0x7192, 0x6727, 0x65eb, 0x78e2, 0x8ff7, 0x50eb, 0x6f2a, 0x9a28,
  0x6fb9, 0x81d8, 0x5058, 0x547b, 0x68a9, 0x5167, 0x89b9, 0x7621,
  0x5a18, 0x6418, 0x703b, 0x66c0, 0x679f, 0x7641, 0x5b95, 0x6a4e,
  0x6933, 0x610d, 0x6b55, 0x72d5, 0x7cdd, 0x72f1, 0x7159, 0x5629,
  0x57d6, 0x4a5e, 0x5a93, 0x61cc, 0x8427, 0x84db, 0x6696, 0x508b,
  0x5625, 0x74a3, 0x8c80, 0x89dc, 0x68ec, 0x5075, 0x84d7, 0x53f4,
  0x8cf9, 0x8959, 0x9267, 0x9540, 0x4b64, 0x6896, 0x51ba, 0x72cb,
  0x7c3d, 0x66a5, 0x74f4, 0x6b83, 0x5b60, 0x80e1, 0x6cd7, 0x7c71,
  0x7ffa, 0x85a5, 0x6306, 0x9a42, 0x676a, 0x7cbd, 0x5362, 0x7c1f,
  0x9334, 0x6674, 0x66a6, 0x5685, 0x7038, 0x6fda,
  /* 0x46 */
  0x5169, 0x8533, 0x71bf, 0x72a3, 0x5734, 0x71d3, 0x54f6, 0x584c,
  0x8f61, 0x7fca, 0x5442, 0x764a, 0x9e9a, 0x9cd5, 0x6b0f, 0x70ef,
  0x7d65, 0x608a, 0x73a8, 0x66f1, 0x9c9c, 0x8926, 0x50cc, 0x8455,
  0x4a5f, 0x5367, 0x86f4, 0x8000, 0x5a7e, 0x55e0, 0x70fb, 0x8fc9,
  0x5842, 0x536c, 0x68f1, 0x9c8a, 0x5e4b, 0x7c39, 0x9f49, 0x8be6,
  0x7898, 0x565b, 0x665c, 0x90f7, 0x4acb, 0x878b, 0x806c, 0x87e4,
  0x80bf, 0x53d9, 0x6339, 0x530e, 0x6263, 0x696b, 0x883c, 0x62d0,
  0x741c, 0x6312, 0x6f37, 0x6c1b, 0x6617, 0x5db6, 0x4a0e, 0x55c9,
  0x6b0b, 0x63df, 0x6882, 0x557b, 0x6cc6, 0x5d4a, 0x6f6a, 0x716b,
  0x5903, 0x851d, 0x9b5d, 0x61da, 0x7d45, 0x7d4c, 0x9e9c, 0x897a,
  0x588f, 0x4a53, 0x4b0c, 0x5022, 0x5d5c, 0x7c01, 0x5265, 0x6819,
  0x8bc9, 0x5b0e, 0x6870, 0x68ee, 0x8fa6, 0x679d,
  /* 0x47 */
  0x647d, 0x6930, 0x7678, 0x666b, 0x9083, 0x90c8, 0x574e, 0x8bcc,
  0x7f73, 0x4ad2, 0x882b, 0x4a73, 0x9ad9, 0x90bc, 0x90be, 0x5640,
  0x6b51, 0x946e, 0x6948, 0x8839, 0x5c1c, 0x5941, 0x6f2d, 0x6f44,
  0x63a7, 0x5056, 0x8559, 0x7b81, 0x5c94, 0x813a, 0x5b37, 0x66af,
  0x6e4a, 0x9134, 0x617f, 0x6489, 0x6c68, 0x73aa, 0x4a59, 0x4ba5,
  0x59ea, 0x9395, 0x60a1, 0x7bd5, 0x58e0, 0x4bc2, 0x7e80, 0x560a,
  0x8709, 0x4a19, 0x6422, 0x7e8e, 0x90ab, 0x4bb8, 0x4abf, 0x7deb,
  0x7039, 0x56e9, 0x86b4, 0x60df, 0x7db0, 0x5fd0, 0x688c, 0x935f,
  0x8b76, 0x682f, 0x5433, 0x5772, 0x6a08, 0x60c3, 0x6279, 0x683d,
  0x64c8, 0x9c7a, 0x8ffa, 0x5a8b, 0x7031, 0x7e7a, 0x7dc6, 0x4a15,
  0x94bc, 0x700e, 0x684f, 0x52d7, 0x9546, 0x68c8, 0x8986, 0x5737,
  0x82cb, 0x62ff, 0x8aa2, 0x5845, 0x9e7c, 0x6a2d,
  /* 0x48 */
  0x57db, 0x5e3b, 0x9b86, 0x89ae, 0x57b6, 0x5305, 0x9caa, 0x634e,
  0x9596, 0x68c4, 0x5565, 0x71c7, 0x66fe, 0x76a1, 0x5635, 0x5690,
  0x7b37, 0x7499, 0x7235, 0x5779, 0x9a47, 0x6dba, 0x7c63, 0x92cd,
  0x8cd4, 0x7ba9, 0x753b, 0x75ce, 0x5584, 0x63de, 0x70e9, 0x5ce9,
  0x6115, 0x52ba, 0x8fa4, 0x9d7b, 0x667d, 0x7ad8, 0x64f4, 0x74e0,
  0x5ce1, 0x4acc, 0x4ab7, 0x5bc0, 0x93ea, 0x4af6, 0x8fa9, 0x560e,
  0x5d87, 0x7aa6, 0x6659, 0x4ac0, 0x61e8, 0x6603, 0x8735, 0x80c4,
  0x876e, 0x8380, 0x7599, 0x6abb, 0x5fb4, 0x7adf, 0x559a, 0x67c4,
  0x63d9, 0x8484, 0x8734, 0x8c18, 0x551f, 0x5f77, 0x5d8f, 0x8bbc,
  0x4a7e, 0x6850, 0x5568, 0x8d28, 0x8b62, 0x9223, 0x8147, 0x7053,
  0x911d, 0x91fd, 0x69ab, 0x86e8, 0x5b3c, 0x609f, 0x691f, 0x8025,
  0x8563, 0x98ce, 0x5c53, 0x8956, 0x4a04, 0x57cc,
  /* 0x49 */
  0x4b13, 0x616e, 0x6c5c, 0x51de, 0x4a2a, 0x6019, 0x9e97, 0x6666,
  0x5ecf, 0x7052, 0x867f, 0x69a4, 0x6ce3, 0x54ea, 0x8783, 0x7c0f,
  0x634d, 0x5634, 0x6894, 0x7abc, 0x54b6, 0x5168, 0x7553, 0x7f56,
  0x625f, 0x77c7, 0x86e6, 0x6344, 0x587c, 0x562d, 0x7570, 0x8c66,
  0x91e7, 0x9258, 0x60c8, 0x896c, 0x85be, 0x5189, 0x6858, 0x664a,
  0x7b23, 0x5c9f, 0x4b29, 0x514b, 0x8942, 0x6241, 0x4a07, 0x5817,
  0x8cfe, 0x6caf, 0x6743, 0x7e00, 0x74ea, 0x8680, 0x56f7, 0x93fb,
  0x581c, 0x50e5, 0x94b8, 0x7ac0, 0x5d6f, 0x8947, 0x82ca, 0x8601,
  0x8600, 0x896b, 0x6049, 0x5809, 0x655c, 0x6984, 0x7d33, 0x8fb3,
  0x7c3a, 0x713e, 0x5076, 0x4b35, 0x8aa6, 0x69fc, 0x5e2d, 0x7ac8,
  0x7d53, 0x6885, 0x5fac, 0x5e7b, 0x7117, 0x84b3, 0x6543, 0x6a1a,
  0x5cfd, 0x7112, 0x7128, 0x767f, 0x574a, 0x7afe,
  /* 0x4a */
  0x730c, 0x72d6, 0x5664, 0x84d1, 0x532e, 0x5a05, 0x5d3c, 0x76e3,
  0x61b0, 0x6a72, 0x8fda, 0x5835, 0x827c, 0x574c, 0x73fe, 0x66f3,
  0x61fb, 0x4acd, 0x9cd2, 0x828d, 0x5f93, 0x8fcb, 0x57ff, 0x73ef,
  0x4b72, 0x5843, 0x9e7b, 0x5dc6, 0x5b02, 0x7d37, 0x5ce6, 0x4a1b,
  0x63f2, 0x4a86, 0x66e0, 0x8e9e, 0x9410, 0x56b2, 0x6222, 0x51d1,
  0x5261, 0x940f, 0x4ad8, 0x4b80, 0x95c7, 0x9d7d, 0x6802, 0x5a0f,
  0x644e, 0x5fa9, 0x8dcb, 0x8fd8, 0x613b, 0x6646, 0x9d9b, 0x5f85,
  0x5ff2, 0x6785, 0x5123, 0x57da, 0x722b, 0x5570, 0x8121, 0x63af,
  0x6cbe, 0x6f87, 0x669f, 0x8b9e, 0x57d9, 0x861f, 0x69dc, 0x7182,
  0x4a6b, 0x8943, 0x5f7d, 0x7592, 0x81a2, 0x629c, 0x62d4, 0x7b7f,
  0x830d, 0x9ac0, 0x9b2d, 0x5853, 0x6322, 0x8bfd, 0x6c1c, 0x6352,
  0x6600, 0x7edb, 0x5c88, 0x5abb, 0x617d, 0x6b3c,
  /* 0x4b */
  0x6458, 0x563a, 0x8400, 0x6059, 0x8c7d, 0x7124, 0x5a08, 0x6c1e,
  0x66f9, 0x9311, 0x57c1, 0x7630, 0x880c, 0x6839, 0x736c, 0x7e03,
  0x5023, 0x73a1, 0x9c77, 0x8611, 0x8ff9, 0x7c58, 0x6319, 0x74cc,
  0x61a2, 0x6098, 0x523b, 0x6410, 0x7dcc, 0x57f5, 0x4a10, 0x6f76,
  0x848b, 0x5ff7, 0x51ee, 0x52d6, 0x4b37, 0x4b31, 0x9d7f, 0x59fe,
  0x6373, 0x8435, 0x640f, 0x9c8f, 0x940c, 0x5f86, 0x8fb1, 0x8ff8,
  0x6011, 0x8655, 0x60d3, 0x51f0, 0x86c2, 0x9568, 0x4bda, 0x792d,
  0x9412, 0x7892, 0x54fe, 0x5c5c, 0x6aa2, 0x5fb2, 0x8fc4, 0x848e,
  0x9575, 0x8091, 0x7f9a, 0x8270, 0x9286, 0x9282, 0x7ae8, 0x9ede,
  0x7c83, 0x588c, 0x7e5a, 0x944f, 0x92aa, 0x7d52, 0x5f54, 0x6752,
  0x7f06, 0x80dc, 0x6ca0, 0x510b, 0x7b24, 0x701d, 0x792f, 0x910c,
  0x664d, 0x5c41, 0x4adb, 0x5f8e, 0x5d74, 0x5c59,
  /* 0x4c */
  0x7760, 0x6713, 0x8a46, 0x8a02, 0x84c3, 0x86d9, 0x66a1, 0x57fd,
  0x68fd, 0x9553, 0x5d27, 0x640c, 0x687d, 0x5340, 0x6047, 0x8927,
  0x7226, 0x6ae4, 0x5356, 0x6e8d, 0x71fd, 0x6b60, 0x8820, 0x8805,
  0x536b, 0x6fe2, 0x8c9f, 0x7cbe, 0x67af, 0x57f4, 0x74a0, 0x6869,
  0x5c55, 0x6027, 0x5c0f, 0x6ced, 0x8596, 0x511d, 0x78db, 0x5415,
  0x8ab7, 0x69c1, 0x8992, 0x74e6, 0x6782, 0x6996, 0x6ad9, 0x7aeb,
  0x8009, 0x6c4e, 0x940e, 0x69d5, 0x927b, 0x8fa5, 0x5d5a, 0x7674,
  0x81e9, 0x8573, 0x71b1, 0x8e87, 0x6ca2, 0x5659, 0x8a2f, 0x911c,
  0x67dd, 0x9c95, 0x8a49, 0x5171, 0x4b5e, 0x62f2, 0x5282, 0x64d8,
  0x6998, 0x564e, 0x5844, 0x5d24, 0x69f6, 0x5c66, 0x713d, 0x7111,
  0x6461, 0x8619, 0x854b, 0x671c, 0x636c, 0x8bef, 0x7337, 0x89fe,
  0x8939, 0x90cc, 0x5a1b, 0x5788, 0x5021, 0x74ce,
  /* 0x4d */
  0x684d, 0x5afa, 0x5451, 0x4aa0, 0x5aa0, 0x6737, 0x864a, 0x9417,
  0x6c5d, 0x9563, 0x73be, 0x5001, 0x90d1, 0x5b69, 0x7ee8, 0x6c7b,
  0x6748, 0x7f5f, 0x7ad2, 0x71d6, 0x547a, 0x6698, 0x5d39, 0x9402,
  0x55f5, 0x7dce, 0x7e8c, 0x52f3, 0x5b9f, 0x9419, 0x698f, 0x586d,
  0x5312, 0x501d, 0x5559, 0x6a40, 0x52ef, 0x67a5, 0x9c9e, 0x8572,
  0x8318, 0x8d27, 0x940d, 0x5013, 0x5862, 0x85cd, 0x66db, 0x6655,
  0x853c, 0x9a38, 0x924d, 0x9e63, 0x9e71, 0x6d20, 0x5da8, 0x66de,
  0x5133, 0x671b, 0x50ca, 0x82d4, 0x6931, 0x5e0e, 0x70eb, 0x8c91,
  0x6f67, 0x5d1b, 0x8841, 0x5b22, 0x6a73, 0x77a4, 0x9c70, 0x4a35,
  0x74fa, 0x5f81, 0x7c9a, 0x6730, 0x6257, 0x729b, 0x64c6, 0x5f96,
  0x5e44, 0x4a0a, 0x8558, 0x6867, 0x7786, 0x4aac, 0x6384, 0x7b5c,
  0x5b8d, 0x61f7, 0x6316, 0x5bd5, 0x5d89, 0x5e0c,
  /* 0x4e */
  0x59c0, 0x5ba3, 0x577c, 0x93eb, 0x8bd0, 0x6c48, 0x52f9, 0x5122,
  0x64d2, 0x4a37, 0x6b40, 0x7af9, 0x86ca, 0x8003, 0x5dd9, 0x4b12,
  0x4b27, 0x5833, 0x7aa1, 0x6327, 0x8117, 0x507e, 0x7142, 0x84ce,
  0x518f, 0x9f42, 0x4b40, 0x6a20, 0x881e, 0x5804, 0x657d, 0x5766,
  0x7212, 0x6a24, 0x8287, 0x618a, 0x91f6, 0x7ab4, 0x5036, 0x7e3e,
  0x7907, 0x91e3, 0x51ec, 0x7bcc, 0x70e3, 0x6710, 0x831a, 0x69ac,
  0x7e90, 0x661c, 0x61ac, 0x576a, 0x67ec, 0x688e, 0x59e6, 0x5051,
  0x90a5, 0x4a41, 0x686c, 0x8fe1, 0x5846, 0x61ed, 0x8691, 0x6caa,
  0x5033, 0x5039, 0x6fc6, 0x6f6b, 0x4a99, 0x674f, 0x5745, 0x8613,
  0x4b00, 0x4ba3, 0x5353, 0x6607, 0x92f3, 0x6269, 0x7664, 0x56f2,
  0x56ac, 0x6492, 0x8fe2, 0x6219, 0x7594, 0x639d, 0x8d72, 0x7c5f,
  0x73f0, 0x627d, 0x5236, 0x5035, 0x912c, 0x7677,
  /* 0x4f */
  0x7e0d, 0x6462, 0x5a01, 0x6484, 0x8590, 0x5d18, 0x64d1, 0x7589,
  0x74e2, 0x6aa7, 0x685d, 0x768d, 0x6e89, 0x8ca0, 0x5a20, 0x4a6d,
  0x5ebe, 0x5191, 0x90ee, 0x691a, 0x78f6, 0x9294, 0x6602, 0x7acb,
  0x7383, 0x8273, 0x572e, 0x9313, 0x8b9b, 0x628a, 0x58ec, 0x4bad,
  0x76e0, 0x4a06, 0x57ab, 0x5d02, 0x501e, 0x678d, 0x9125, 0x5545,
  0x4ad4, 0x9891, 0x7aa9, 0x50b5, 0x8929, 0x8c59, 0x863a, 0x91ff,
  0x6983, 0x5b2b, 0x5ec1, 0x6233, 0x9264, 0x77bd, 0x7723, 0x57b2,
  0x8577, 0x9d88, 0x7bac, 0x5fa7, 0x927a, 0x925d, 0x7ab2, 0x72f5,
  0x57af, 0x917b, 0x9d94, 0x7fbc, 0x8d49, 0x6a55, 0x4a6c, 0x7bd9,
  0x7d68, 0x8feb, 0x64fe, 0x50c0, 0x4aa6, 0x9c74, 0x59fa, 0x6e6c,
  0x54c2, 0x501c, 0x886c, 0x802a, 0x7c50, 0x9309, 0x5647, 0x50e3,
  0x52ae, 0x910d, 0x6985, 0x5fb8, 0x69cb, 0x625e,
  /* 0x50 */
  0x5802, 0x5f50, 0x6c2c, 0x849b, 0x5175, 0x7f1c, 0x6145, 0x6d59,
  0x4a96, 0x6f4a, 0x8343, 0x9386, 0x5742, 0x6712, 0x6037, 0x94a7,
  0x6191, 0x84cc, 0x881d, 0x5594, 0x6cbd, 0x5775, 0x83f4, 0x65c5,
  0x68c9, 0x68f6, 0x882f, 0x585c, 0x81a7, 0x86a2, 0x9101, 0x6f2e,
  0x8b96, 0x61bd, 0x5bf6, 0x5bce, 0x4bec, 0x8c48, 0x6212, 0x8568,
  0x7724, 0x64f7, 0x5579, 0x561c, 0x5386, 0x5b6f, 0x94af, 0x8c41,
  0x959f, 0x5a75, 0x6342, 0x642a, 0x5dde, 0x5549, 0x55fb, 0x84f5,
  0x5705, 0x6874, 0x92c9, 0x7587, 0x4b1c, 0x4be3, 0x7b93, 0x6330,
  0x51c8, 0x9105, 0x7dcd, 0x8c9b, 0x7aee, 0x5c92, 0x6601, 0x930d,
  0x8257, 0x5215, 0x9c76, 0x5b9d, 0x8fb5, 0x80c9, 0x955a, 0x57d4,
  0x61e0, 0x5a82, 0x7151, 0x6469, 0x7963, 0x5e72, 0x7ae7, 0x7ae0,
  0x8b64, 0x51aa, 0x5fae, 0x64a1, 0x61c6, 0x7789,
  /* 0x51 */
  0x9404, 0x726e, 0x7324, 0x7ad7, 0x9379, 0x8196, 0x5f6b, 0x7e79,
  0x92e7, 0x8c4d, 0x56c6, 0x7582, 0x5ba7, 0x61e1, 0x8fef, 0x5ff6,
  0x9e62, 0x59ec, 0x6f84, 0x6856, 0x8fa0, 0x8fa2, 0x9407, 0x8bc8,
  0x5786, 0x66b1, 0x9a2b, 0x9a20, 0x504d, 0x4a26, 0x86b0, 0x7654,
  0x8291, 0x591b, 0x8c54, 0x69a2, 0x92c8, 0x50dc, 0x4a97, 0x8fbb,
  0x7504, 0x50b0, 0x9204, 0x74d2, 0x69f4, 0x72dd, 0x4a28, 0x7c19,
  0x831f, 0x58a4, 0x5afb, 0x8e0d, 0x9c91, 0x9203, 0x7483, 0x68b2,
  0x5d49, 0x67a4, 0x7331, 0x8c40, 0x6b19, 0x867e, 0x5c3d, 0x75d8,
  0x5781, 0x7c17, 0x92cc, 0x510c, 0x5b6b, 0x753d, 0x5fb9, 0x8817,
  0x9e81, 0x6f8e, 0x5d23, 0x9a22, 0x7dea, 0x6365, 0x6661, 0x4b62,
  0x71ac, 0x7b87, 0x6906, 0x923e, 0x682a, 0x4afd, 0x71df, 0x5576,
  0x6c3a, 0x6b33, 0x948d, 0x857d, 0x5d9b, 0x707b,
  /* 0x52 */
  0x604a, 0x582a, 0x9468, 0x7e9c, 0x882e, 0x5dd7, 0x50a1, 0x860d,
  0x8762, 0x8d8c, 0x840d, 0x6d3d, 0x5243, 0x843b, 0x763a, 0x95c3,
  0x55bb, 0x4a52, 0x9c78, 0x679b, 0x4a17, 0x57fb, 0x62fe, 0x8546,
  0x5d11, 0x69bf, 0x4a0d, 0x5cf4, 0x5736, 0x67db, 0x90fc, 0x4b90,
  0x4b07, 0x8c6e, 0x9c9d, 0x5d3a, 0x945a, 0x7df6, 0x4ae7, 0x84fd,
  0x719c, 0x688f, 0x5f91, 0x5de5, 0x5b50, 0x6d08, 0x828c, 0x5417,
  0x59ff, 0x4a54, 0x73ee, 0x4ae8, 0x8677, 0x669c, 0x621e, 0x949c,
  0x5874, 0x4ab2, 0x5b74, 0x85cb, 0x9435, 0x8489, 0x71a6, 0x4aab,
  0x8cd9, 0x6502, 0x6fc8, 0x5bcb, 0x4a44, 0x72c7, 0x6aaf, 0x8fee,
  0x8fa3, 0x8807, 0x8fdc, 0x5b0f, 0x7bf1, 0x7bc1, 0x7ac3, 0x8738,
  0x8766, 0x52ed, 0x6fba, 0x93fe, 0x9239, 0x5df6, 0x5012, 0x90fb,
  0x69e6, 0x5fc8, 0x9d63, 0x5834, 0x5b18, 0x929d,
  /* 0x53 */
  0x577d, 0x86fc, 0x6e3c, 0x5e79, 0x9a7d, 0x5a99, 0x7b25, 0x87b4,
  0x8029, 0x8028, 0x876a, 0x834a, 0x8bc3, 0x896f, 0x72c5, 0x5b7c,
  0x9c9b, 0x7c61, 0x622d, 0x50d2, 0x66e8, 0x4b6e, 0x85ce, 0x71c5,
  0x5ab5, 0x92c0, 0x8a07, 0x82f4, 0x5082, 0x68fe, 0x6981, 0x6835,
  0x6472, 0x56ca, 0x7125, 0x5a70, 0x4b15, 0x64ad, 0x5bea, 0x5829,
  0x713c, 0x94a3, 0x90cd, 0x76b4, 0x68b4, 0x6a35, 0x9544, 0x6304,
  0x57c6, 0x57fe, 0x4b5c, 0x95c4, 0x8ffc, 0x57c5, 0x5a71, 0x8bcf,
  0x69e9, 0x4a83, 0x72cf, 0x6d8b, 0x8253, 0x6517, 0x860b, 0x4b54,
  0x4bd3, 0x9433, 0x9871, 0x6504, 0x6a10, 0x6a19, 0x9288, 0x4a85,
  0x5e3c, 0x92e5, 0x4a03, 0x5872, 0x7db4, 0x5f8a, 0x8fe0, 0x7bb0,
  0x7784, 0x53d2, 0x8686, 0x94cc, 0x500c, 0x944a, 0x51b6, 0x58e7,
  0x5bac, 0x6505, 0x6f3f, 0x76fc, 0x84bf, 0x8e84,
  /* 0x54 */
  0x6979, 0x5fde, 0x8cd8, 0x9c89, 0x8866, 0x9e60, 0x9a3e, 0x6a07,
  0x55a9, 0x554e, 0x53ae, 0x8c8c, 0x5792, 0x67f9, 0x8b98, 0x52e0,
  0x5055, 0x530b, 0x7732, 0x6a9d, 0x7b15, 0x8bd1, 0x86dc, 0x6532,
  0x6425, 0x926f, 0x62fd, 0x7aab, 0x8987, 0x89ce, 0x90a8, 0x58be,
  0x78a9, 0x6305, 0x64ab, 0x9208, 0x8415, 0x4a9c, 0x94ea, 0x570d,
  0x9265, 0x554c, 0x8bdd, 0x8179, 0x9550, 0x6258, 0x93f8, 0x5f58,
  0x5710, 0x7c35, 0x634f, 0x6c30, 0x50c4, 0x7473, 0x5fbd, 0x8b70,
  0x5580, 0x5325, 0x50bc, 0x611f, 0x628f, 0x8953, 0x894e, 0x8502,
  0x8061, 0x9460, 0x78d2, 0x55f2, 0x81f6, 0x63ae, 0x61e4, 0x6bac,
  0x82a9, 0x8a8c, 0x5267, 0x942d, 0x728f, 0x747b, 0x75e8, 0x892e,
  0x66e4, 0x5614, 0x68f0, 0x8931, 0x6403, 0x5c93, 0x6583, 0x62f3,
  0x896d, 0x6643, 0x51be, 0x6a2e, 0x6320, 0x8b6a,
  /* 0x55 */
  0x90ec, 0x91f5, 0x7325, 0x6c08, 0x6da5, 0x5086, 0x4a40, 0x74b5,
  0x8fc5, 0x6055, 0x6186, 0x5f88, 0x7e89, 0x5437, 0x5fe5, 0x73b6,
  0x6fec, 0x8e74, 0x7895, 0x68b3, 0x72c2, 0x61a4, 0x8b9a, 0x5920,
  0x5858, 0x8235, 0x6c05, 0x576d, 0x6615, 0x7ed4, 0x6a56, 0x7af0,
  0x6e12, 0x7eed, 0x5b7d, 0x6b3e, 0x5b2d, 0x6781, 0x69a5, 0x635b,
  0x4a05, 0x5a1d, 0x892b, 0x4ada, 0x84cd, 0x7239, 0x9291, 0x66d6,
  0x6220, 0x6673, 0x68b1, 0x8978, 0x756a, 0x7b64, 0x554b, 0x848a,
  0x57e1, 0x9463, 0x6695, 0x50ff, 0x82fd, 0x8b94, 0x8408, 0x911a,
  0x811a, 0x8bd4, 0x6954, 0x77c0, 0x6192, 0x7312, 0x7109, 0x7c2a,
  0x85f6, 0x8913, 0x9085, 0x4bab, 0x6398, 0x71b4, 0x8fc7, 0x930a,
  0x6722, 0x914a, 0x9238, 0x80b5, 0x672e, 0x734c, 0x5b8c, 0x76fd,
  0x4a84, 0x6419, 0x6179, 0x66e2, 0x6f6e, 0x6132,
  /* 0x56 */
  0x5a2a, 0x71ca, 0x94dc, 0x8fcc, 0x8690, 0x6390, 0x6122, 0x503c,
  0x8315, 0x73e8, 0x84af, 0x850f, 0x684c, 0x4a46, 0x7aca, 0x8441,
  0x72f9, 0x6d00, 0x6f9b, 0x666a, 0x5431, 0x4b89, 0x534d, 0x670a,
  0x6f6f, 0x89b3, 0x57e7, 0x61e5, 0x7ab5, 0x5bda, 0x6717, 0x67ba,
  0x85fe, 0x85f9, 0x7b63, 0x5a11, 0x58d4, 0x563b, 0x6277, 0x7de4,
  0x7e17, 0x8925, 0x7494, 0x71d9, 0x6ad3, 0x68b6, 0x7e9f, 0x4a20,
  0x72c8, 0x5bed, 0x9092, 0x8c7a, 0x7ac5, 0x7dc0, 0x84b2, 0x95c0,
  0x4aff, 0x4b1a, 0x8612, 0x5065, 0x59d3, 0x693f, 0x8fc1, 0x78a8,
  0x8b79, 0x8495, 0x5a17, 0x509f, 0x72bc, 0x5f94, 0x6231, 0x9ea9,
  0x77ed, 0x6c27, 0x82d6, 0x633c, 0x7727, 0x8ff5, 0x8fd6, 0x941d,
  0x7ef4, 0x74d6, 0x7563, 0x66c9, 0x73a4, 0x523c, 0x4a36, 0x805a,
  0x63fc, 0x56a4, 0x82cd, 0x8923, 0x90f5, 0x7f5c,
  /* 0x57 */
  0x4b42, 0x68e5, 0x7d50, 0x9e76, 0x669e, 0x7627, 0x66f0, 0x4a1e,
  0x7c1b, 0x8b61, 0x60bd, 0x8957, 0x7fcb, 0x6c64, 0x5a89, 0x8cc8,
  0x5d8b, 0x6093, 0x5ce3, 0x76bb, 0x6d03, 0x9128, 0x8bf0, 0x8955,
  0x536d, 0x7b0d, 0x880b, 0x55cb, 0x6744, 0x66d4, 0x575e, 0x6c41,
  0x702f, 0x870c, 0x9541, 0x5149, 0x734d, 0x7471, 0x6947, 0x5574,
  0x50a5, 0x8949, 0x5df2, 0x6ac6, 0x69c9, 0x5f51, 0x7926, 0x4ad9,
  0x7870, 0x6ade, 0x5f5d, 0x85e7, 0x6a00, 0x5f5a, 0x9f0e, 0x6cd8,
  0x8a27, 0x5f9a, 0x7af1, 0x6436, 0x7ab8, 0x94b4, 0x897d, 0x5d42,
  0x67c0, 0x7dd2, 0x89be, 0x575f, 0x61c2, 0x7d5b, 0x8fc8, 0x9236,
  0x7ac9, 0x90b6, 0x7a8f, 0x5239, 0x9584, 0x630d, 0x7b67, 0x5807,
  0x9478, 0x6225, 0x59eb, 0x4b5d, 0x63d3, 0x5457, 0x4b51, 0x535d,
  0x5aaa, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x58 */
  0x4a80, 0x4a01, 0x554d, 0x4a1d, 0x5af2, 0x5748, 0x4a18, 0x4a95,
  0x4a13, 0x9f3f, 0x5f61, 0x5264, 0x4a25, 0x7db7, 0x4a32, 0x5718,
  0x4a4a, 0x5d20, 0x7636, 0x5763, 0x681d, 0x52d2, 0x84e9, 0x9d9a,
  0x6fde, 0x7373, 0x9b1a, 0x4a3b, 0x4a92, 0x9b1d, 0x4a51, 0x4a64,
  0x4a9e, 0x8685, 0x5f56, 0x5161, 0x5202, 0x4ac9, 0x5780, 0x5790,
  0x57ae, 0x57a8, 0x57a3, 0x9368, 0x8950, 0x5717, 0x57f8, 0x572b,
  0x5723, 0x5733, 0x8951, 0x576b, 0x576e, 0x560f, 0x5605, 0x5603,
  0x5620, 0x563e, 0x5632, 0x564d, 0x5641, 0x5653, 0x566c, 0x5651,
  0x80a2, 0x5670, 0x568f, 0x568c, 0x569d, 0x569e, 0x558f, 0x7b59,
  0x4ab6, 0x4ace, 0x4ac4, 0x4acf, 0x4ae5, 0x4aec, 0x4ae6, 0x4ad3,
  0x4b16, 0x4afe, 0x4b2f, 0x4b69, 0x4af8, 0x4b28, 0x4b2a, 0x4b04,
  0x4b26, 0x4b53, 0x4b6a, 0x6135, 0x4b57, 0x4b50,
  /* 0x59 */
  0x4b52, 0x4b5a, 0x4b3f, 0x4b30, 0x4b7b, 0x4b79, 0x4b9c, 0x4b84,
  0x4b8e, 0x4b82, 0x4b73, 0x4b76, 0x4ba7, 0x4b71, 0x4ba1, 0x4b99,
  0x4beb, 0x4be5, 0x4be7, 0x4bc8, 0x4bd7, 0x4bee, 0x4bd1, 0x4bdc,
  0x4bd2, 0x4bf5, 0x5424, 0x5441, 0x4bfe, 0x5421, 0x5402, 0x5423,
  0x5420, 0x4bf3, 0x5411, 0x5401, 0x5428, 0x5425, 0x5473, 0x544e,
  0x5458, 0x5445, 0x5443, 0x5461, 0x5476, 0x54a8, 0x54aa, 0x54a4,
  0x54b7, 0x54db, 0x550b, 0x54e0, 0x54e1, 0x54eb, 0x54e3, 0x550a,
  0x5506, 0x4ad0, 0x6830, 0x4b55, 0x4b68, 0x4bc3, 0x9bad, 0x684b,
  0x7879, 0x5563, 0x59f0, 0x9ac4, 0x9d95, 0x558c, 0x5d19, 0x56f4,
  0x5700, 0x8e0a, 0x571d, 0x55e6, 0x5d14, 0x5558, 0x4aad, 0x555b,
  0x4abe, 0x8c63, 0x8ca9, 0x4ab8, 0x8519, 0x8cdf, 0x7d8d, 0x5f39,
  0x8c0e, 0x7bb5, 0x55a6, 0x55bc, 0x55b0, 0x55b1,
  /* 0x5a */
  0x55ca, 0x559b, 0x55af, 0x55a8, 0x8fad, 0x8fab, 0x8faa, 0x8fa7,
  0x8fb9, 0x8fb8, 0x8fba, 0x8fcf, 0x8fce, 0x8fc6, 0x8fc2, 0x8fc3,
  0x8fdf, 0x8fde, 0x8fd9, 0x8fdb, 0x8fd5, 0x8fd4, 0x8fd1, 0x8fd2,
  0x8fed, 0x8fe9, 0x8fe5, 0x8fe4, 0x8fe3, 0x8ffd, 0x8ffe, 0x8ffb,
  0x8ff4, 0x8ff1, 0x8ff2, 0x880d, 0x880f, 0x8809, 0x880a, 0x8801,
  0x8802, 0x881c, 0x881f, 0x8819, 0x8818, 0x881b, 0x8814, 0x8816,
  0x8815, 0x8810, 0x8812, 0x882d, 0x882c, 0x8828, 0x882a, 0x8827,
  0x8826, 0x8823, 0x8822, 0x883f, 0x883e, 0x8838, 0x883b, 0x5764,
  0x5777, 0x9210, 0x922f, 0x922c, 0x923c, 0x9227, 0x9230, 0x9231,
  0x924f, 0x9244, 0x9259, 0x9252, 0x926a, 0x9261, 0x927f, 0x9279,
  0x9285, 0x9280, 0x929a, 0x92bd, 0x949a, 0x9496, 0x9490, 0x9494,
  0x94a1, 0x94ac, 0x94b9, 0x94be, 0x94bb, 0x94b7,
  /* 0x5b */
  0x94b5, 0x94bd, 0x94c2, 0x94c8, 0x94b3, 0x94dd, 0x94c9, 0x94ca,
  0x94de, 0x94eb, 0x94ef, 0x94d1, 0x94da, 0x94d6, 0x94e6, 0x94e2,
  0x94f3, 0x9509, 0x952f, 0x9513, 0x952e, 0x953c, 0x9522, 0x9534,
  0x954e, 0x954b, 0x5600, 0x5d4f, 0x56af, 0x56a1, 0x56a0, 0x56b3,
  0x50f2, 0x56dd, 0x56db, 0x56fd, 0x57d2, 0x75e3, 0x73c0, 0x5af9,
  0x55f8, 0x55f1, 0x9f22, 0x57bb, 0x5b0c, 0x7157, 0x59e2, 0x5341,
  0x53a4, 0x53ac, 0x5c73, 0x5cb1, 0x5cc8, 0x5cdc, 0x5324, 0x5321,
  0x5327, 0x533e, 0x5334, 0x5323, 0x5322, 0x5351, 0x5336, 0x534f,
  0x5364, 0x5388, 0x5366, 0x538b, 0x5371, 0x5376, 0x5365, 0x5360,
  0x537b, 0x537e, 0x53a0, 0x53a9, 0x5381, 0x53bf, 0x53c2, 0x53aa,
  0x53b9, 0x539e, 0x53ad, 0x53d8, 0x53d5, 0x53d7, 0x53d4, 0x53df,
  0x53b5, 0x53f9, 0x53e2, 0x53f5, 0x53e9, 0x53d0,
  /* 0x5c */
  0x5c06, 0x5c00, 0x53f0, 0x53e0, 0x5c0d, 0x5c13, 0x5c14, 0x5c49,
  0x5c2d, 0x5c68, 0x5c61, 0x5c8c, 0x5c84, 0x5c97, 0x5c8d, 0x9da5,
  0x9b14, 0x65f2, 0x8674, 0x8670, 0x8672, 0x8682, 0x8687, 0x86a5,
  0x8689, 0x8683, 0x869c, 0x869a, 0x8694, 0x86a6, 0x86b5, 0x86b3,
  0x86bd, 0x86c5, 0x86c7, 0x86ee, 0x8695, 0x86ba, 0x86a3, 0x86c6,
  0x86c1, 0x86cc, 0x86a4, 0x86b9, 0x86ac, 0x86a7, 0x8692, 0x86c9,
  0x86c3, 0x86a9, 0x86ec, 0x8704, 0x86fa, 0x86e9, 0x8702, 0x870a,
  0x86d1, 0x86f9, 0x86df, 0x86d5, 0x8701, 0x86f6, 0x86de, 0x871c,
  0x8717, 0x870b, 0x8719, 0x8718, 0x86ed, 0x86d8, 0x8711, 0x875c,
  0x8756, 0x8751, 0x8705, 0x879f, 0x8731, 0x8739, 0x873c, 0x8796,
  0x8753, 0x8722, 0x8742, 0x874a, 0x874e, 0x8752, 0x874d, 0x871a,
  0x876d, 0x8720, 0x8737, 0x873e, 0x876b, 0x8768,
  /* 0x5d */
  0x8765, 0x8716, 0x8764, 0x8761, 0x8767, 0x8760, 0x8763, 0x87bd,
  0x8775, 0x87be, 0x87b9, 0x87ad, 0x87a7, 0x879e, 0x8791, 0x8788,
  0x8771, 0x87bb, 0x87a4, 0x8770, 0x87b5, 0x8776, 0x8795, 0x8793,
  0x87a5, 0x87b7, 0x87b1, 0x87cc, 0x800c, 0x87e8, 0x87d5, 0x5c0a,
  0x8015, 0x8006, 0x87d0, 0x87f0, 0x87db, 0x8011, 0x8035, 0x801c,
  0x800b, 0x87d9, 0x87d2, 0x8002, 0x800e, 0x87f5, 0x87f4, 0x87e7,
  0x87c8, 0x87cd, 0x802b, 0x87fd, 0x87ec, 0x8051, 0x805c, 0x8057,
  0x8054, 0x807e, 0x808a, 0x8085, 0x8077, 0x8084, 0x8075, 0x8031,
  0x804b, 0x8064, 0x807b, 0x8081, 0x8083, 0x803c, 0x8060, 0x80cc,
  0x80c0, 0x80dd, 0x80eb, 0x80b0, 0x80de, 0x80c7, 0x80b2, 0x80b7,
  0x80ed, 0x80ac, 0x80b4, 0x80b9, 0x809a, 0x80e8, 0x80ee, 0x8101,
  0x7100, 0x8135, 0x80fd, 0x8134, 0x8112, 0x8137,
  /* 0x5e */
  0x815b, 0x8136, 0x80f2, 0x80f1, 0x8154, 0x8145, 0x8165, 0x8169,
  0x8153, 0x8177, 0x73af, 0x814e, 0x817f, 0x8176, 0x81a9, 0x81a5,
  0x818a, 0x8182, 0x8174, 0x81a3, 0x8191, 0x8188, 0x81b4, 0x81ba,
  0x81bd, 0x81de, 0x81cc, 0x81d1, 0x81f2, 0x822a, 0x8208, 0x8224,
  0x821b, 0x8231, 0x5af3, 0x5b05, 0x5d31, 0x5d4c, 0x843a, 0x5d58,
  0x5d57, 0x5d55, 0x5702, 0x582f, 0x5828, 0x5821, 0x5839, 0x6641,
  0x6667, 0x6692, 0x66b6, 0x66c7, 0x66d7, 0x66da, 0x66e3, 0x672f,
  0x66fb, 0x6734, 0x6746, 0x674e, 0x67a0, 0x67fb, 0x677c, 0x6777,
  0x6783, 0x67b9, 0x6760, 0x67a1, 0x6787, 0x6764, 0x67a3, 0x67b1,
  0x67ff, 0x67f5, 0x67ed, 0x67f2, 0x67c9, 0x67d3, 0x67c3, 0x605f,
  0x67cb, 0x67b3, 0x6048, 0x604c, 0x6006, 0x6016, 0x602d, 0x6001,
  0x602b, 0x602c, 0x6053, 0x6089, 0x6060, 0x609b,
  /* 0x5f */
  0x6077, 0x60ba, 0x60b5, 0x6094, 0x60b7, 0x60cd, 0x60dd, 0x60da,
  0x60e9, 0x60ef, 0x6104, 0x6128, 0x6123, 0x5b06, 0x5bdf, 0x7114,
  0x5b1c, 0x5752, 0x57fc, 0x57f0, 0x57e4, 0x57e5, 0x57f6, 0x501f,
  0x501b, 0x500b, 0x5046, 0x505f, 0x505e, 0x5059, 0x505b, 0x504e,
  0x502c, 0x505a, 0x5054, 0x502e, 0x503f, 0x508f, 0x5099, 0x507a,
  0x507c, 0x5069, 0x5097, 0x5096, 0x5089, 0x507b, 0x506b, 0x5090,
  0x50dd, 0x50a0, 0x50cf, 0x50b9, 0x50df, 0x50aa, 0x50ab, 0x50de,
  0x50d9, 0x507f, 0x50ae, 0x50d8, 0x50b6, 0x50b2, 0x50c1, 0x50d4,
  0x50d7, 0x50d1, 0x50a4, 0x50a7, 0x50a9, 0x50d0, 0x50c2, 0x50d3,
  0x5116, 0x50ea, 0x512d, 0x50f0, 0x5119, 0x50fe, 0x512f, 0x512e,
  0x5102, 0x511c, 0x512a, 0x5127, 0x516a, 0x5182, 0x51b8, 0x5144,
  0x5160, 0x514c, 0x5158, 0x5132, 0x515d, 0x5131,
  /* 0x60 */
  0x513a, 0x515b, 0x5178, 0x517b, 0x517a, 0x513e, 0x513d, 0x5151,
  0x5186, 0x51df, 0x518e, 0x51bc, 0x51b4, 0x5185, 0x518c, 0x5192,
  0x5173, 0x51db, 0x519c, 0x5176, 0x51d2, 0x51b0, 0x51b3, 0x5199,
  0x5194, 0x51e7, 0x51fa, 0x51c4, 0x5212, 0x51dc, 0x51e6, 0x51e1,
  0x51d9, 0x51eb, 0x51d0, 0x51c9, 0x51e2, 0x51e8, 0x51ff, 0x51fe,
  0x51c1, 0x51c0, 0x51e5, 0x51f8, 0x51e9, 0x8b99, 0x5213, 0x5205,
  0x5201, 0x520c, 0x5229, 0x522e, 0x51f3, 0x520d, 0x522a, 0x5220,
  0x5255, 0x5234, 0x525a, 0x5221, 0x5240, 0x526f, 0x5254, 0x5251,
  0x5241, 0x5259, 0x528b, 0x5269, 0x527c, 0x5266, 0x5276, 0x5271,
  0x5288, 0x529e, 0x52a2, 0x52d9, 0x52da, 0x52d0, 0x52ec, 0x52f8,
  0x52e6, 0x52f4, 0x52f2, 0x5309, 0x5307, 0x5304, 0x5311, 0x5a02,
  0x5a14, 0x5a19, 0x5a1c, 0x5a3c, 0x5a36, 0x5a31,
  /* 0x61 */
  0x5a3a, 0x5a49, 0x5a59, 0x5a56, 0x5a53, 0x5a6c, 0x5881, 0x5877,
  0x5880, 0x589d, 0x589b, 0x5885, 0x5895, 0x5894, 0x589c, 0x5897,
  0x5891, 0x58b8, 0x58af, 0x58b0, 0x58a1, 0x58a6, 0x58bc, 0x58ae,
  0x58cc, 0x58ba, 0x58c9, 0x58df, 0x58e9, 0x58c6, 0x58e8, 0x590f,
  0x590e, 0x592a, 0x592b, 0x5923, 0x5929, 0x5913, 0x590b, 0x5916,
  0x5955, 0x5933, 0x5939, 0x5930, 0x5961, 0x5956, 0x5962, 0x5950,
  0x5966, 0x5946, 0x5947, 0x5964, 0x5979, 0x598f, 0x5994, 0x5990,
  0x887e, 0x59ba, 0x59c8, 0x5b7e, 0x5b7a, 0x5b8f, 0x5b8a, 0x5b84,
  0x5b81, 0x5b98, 0x5b94, 0x5b91, 0x5ba5, 0x5ba0, 0x5bb8, 0x5bb1,
  0x8c6f, 0x5b6c, 0x76a0, 0x76bd, 0x76b9, 0x76ba, 0x76b5, 0x76ce,
  0x76cc, 0x76c3, 0x76c0, 0x76df, 0x76e5, 0x76e2, 0x76e4, 0x76ff,
  0x76f9, 0x76fa, 0x770c, 0x76fe, 0x770e, 0x76f7,
  /* 0x62 */
  0x76f6, 0x771a, 0x771e, 0x772c, 0x7707, 0x7713, 0x7710, 0x7718,
  0x772f, 0x7734, 0x7728, 0x7721, 0x7735, 0x773c, 0x775d, 0x7740,
  0x775a, 0x776d, 0x7761, 0x7762, 0x7773, 0x8616, 0x5d28, 0x9cea,
  0x5d29, 0x5d0f, 0x9d6e, 0x9d6a, 0x9d65, 0x9d64, 0x9d67, 0x9d66,
  0x9d61, 0x9d79, 0x9d7a, 0x9d70, 0x9d8d, 0x9d89, 0x9d8a, 0x9d87,
  0x9d80, 0x9d9d, 0x9d9c, 0x9d9e, 0x9d99, 0x9d98, 0x5a8d, 0x5a9c,
  0x5a86, 0x5a9b, 0x5aa8, 0x5aad, 0x5ab4, 0x5ab8, 0x5ab3, 0x5abe,
  0x895e, 0x5adf, 0x5adc, 0x5ad6, 0x5ae5, 0x5ae7, 0x85b7, 0x5bc9,
  0x5bc4, 0x5bdb, 0x5bc2, 0x640e, 0x5be3, 0x6409, 0x5bec, 0x5be9,
  0x5bf3, 0x6408, 0x640b, 0x5be7, 0x5be0, 0x5bf5, 0x6414, 0x6438,
  0x642b, 0x6416, 0x6402, 0x6400, 0x6424, 0x6426, 0x6407, 0x6432,
  0x642c, 0x6475, 0x6474, 0x6476, 0x6477, 0x644f,
  /* 0x63 */
  0x6467, 0x6470, 0x649b, 0x6497, 0x64a0, 0x6490, 0x648e, 0x649f,
  0x6481, 0x6496, 0x64e1, 0x64b6, 0x64bc, 0x64d0, 0x64d5, 0x64cb,
  0x64d7, 0x64b9, 0x652d, 0x652b, 0x6518, 0x652e, 0x64f9, 0x650d,
  0x6503, 0x6526, 0x6547, 0x6578, 0x65a1, 0x6599, 0x65aa, 0x65ba,
  0x65d9, 0x65f8, 0x5bd0, 0x92be, 0x91e4, 0x91e6, 0x91fc, 0x91fe,
  0x91f8, 0x91fb, 0x91f1, 0x91f3, 0x920e, 0x9209, 0x920b, 0x9205,
  0x9207, 0x9206, 0x9201, 0x9200, 0x9202, 0x921f, 0x9218, 0x921b,
  0x921a, 0x9214, 0x9217, 0x4a21, 0x7632, 0x6618, 0x6838, 0x6859,
  0x6851, 0x6847, 0x68ae, 0x6888, 0x689d, 0x6899, 0x6881, 0x6865,
  0x6864, 0x6879, 0x687b, 0x688b, 0x68a4, 0x68dd, 0x68d9, 0x68a0,
  0x68fa, 0x68f5, 0x68fc, 0x68da, 0x68bf, 0x68ed, 0x68db, 0x68f7,
  0x68e6, 0x68e3, 0x68bc, 0x68de, 0x68e2, 0x68f3,
  /* 0x64 */
  0x6934, 0x692a, 0x6901, 0x694e, 0x6945, 0x690a, 0x6909, 0x6914,
  0x6903, 0x6926, 0x6940, 0x6923, 0x6938, 0x6917, 0x6942, 0x695f,
  0x6959, 0x693e, 0x699c, 0x6962, 0x6993, 0x69ad, 0x6953, 0x699e,
  0x6999, 0x6951, 0x696d, 0x6971, 0x696e, 0x6a17, 0x69ca, 0x69c8,
  0x69d3, 0x6a03, 0x69b2, 0x69ed, 0x6a1c, 0x69eb, 0x69d0, 0x69d4,
  0x6a1b, 0x69a6, 0x6a01, 0x69a3, 0x6a26, 0x6a63, 0x6a43, 0x6a66,
  0x6abf, 0x6a52, 0x6a8b, 0x6a5e, 0x6a59, 0x6a3f, 0x6a28, 0x6a49,
  0x6ad2, 0x6abc, 0x6a95, 0x6aed, 0x6b20, 0x6aef, 0x6aa8, 0x6aaa,
  0x6ab0, 0x6ab6, 0x6aba, 0x6ada, 0x6ab9, 0x6ac2, 0x6a82, 0x6acf,
  0x6a92, 0x6b6f, 0x6b4b, 0x6b4a, 0x6b29, 0x6b18, 0x6af4, 0x6b22,
  0x6b3b, 0x6b46, 0x6b79, 0x6b27, 0x6b04, 0x6b24, 0x6b84, 0x6b80,
  0x6b81, 0x6b75, 0x6b7f, 0x6b71, 0x6b77, 0x6bdc,
  /* 0x65 */
  0x6bc4, 0x6baa, 0x6bb4, 0x6bbb, 0x6bcf, 0x6bec, 0x6be3, 0x6bd3,
  0x6bed, 0x6be2, 0x7417, 0x742e, 0x7416, 0x7434, 0x7438, 0x7442,
  0x7453, 0x5f8d, 0x5f89, 0x5f98, 0x5f9e, 0x5fa8, 0x5fb5, 0x7122,
  0x9e93, 0x6039, 0x5fe9, 0x5fe3, 0x8d3d, 0x5ffd, 0x8a4a, 0x8f0a,
  0x8bbb, 0x8bde, 0x8bd8, 0x8be8, 0x8be3, 0x8be9, 0x8be4, 0x8beb,
  0x8bfe, 0x8be5, 0x9408, 0x9409, 0x9406, 0x942b, 0x941c, 0x9400,
  0x941b, 0x942c, 0x9438, 0x943b, 0x9420, 0x9422, 0x9449, 0x945c,
  0x945f, 0x945d, 0x9465, 0x9455, 0x946f, 0x9456, 0x62b4, 0x9479,
  0x9470, 0x948f, 0x9485, 0x948e, 0x9486, 0x5b5d, 0x5b5a, 0x5b5b,
  0x5b55, 0x5836, 0x50a6, 0x585d, 0x5854, 0x5f7c, 0x586e, 0x586b,
  0x7bb1, 0x5b27, 0x5b24, 0x5b20, 0x8679, 0x5b31, 0x9f36, 0x5863,
  0x5d8c, 0x5d8e, 0x5d80, 0x5da4, 0x5da7, 0x5dae,
  /* 0x66 */
  0x5d9a, 0x5dc7, 0x5da6, 0x5d93, 0x5da9, 0x5ddf, 0x5dbf, 0x5da2,
  0x5dda, 0x5db3, 0x5e08, 0x5e0b, 0x5dd0, 0x5e05, 0x5dee, 0x5dd5,
  0x5df4, 0x5e01, 0x5e04, 0x5e3f, 0x5e39, 0x5e1c, 0x5e2e, 0x5e1e,
  0x5e4d, 0x5e6a, 0x5e47, 0x5e58, 0x5e31, 0x5e6f, 0x5e78, 0x84e1,
  0x5ea7, 0x5e96, 0x5e7a, 0x5e77, 0x5eb3, 0x5ee6, 0x5ebf, 0x5edf,
  0x5ed9, 0x5eb5, 0x5eed, 0x5eee, 0x5efc, 0x5edb, 0x5eeb, 0x5ed5,
  0x5ed1, 0x5f04, 0x5f1a, 0x5f1b, 0x5f3f, 0x5f3a, 0x5f4d, 0x5818,
  0x5811, 0x5f57, 0x5f68, 0x5f7e, 0x5f5c, 0x5f5e, 0x5f6f, 0x9e78,
  0x9e7a, 0x9e75, 0x9e77, 0x9e72, 0x9e70, 0x9e8d, 0x9e8c, 0x9e88,
  0x9e85, 0x9e87, 0x9e9d, 0x9e9f, 0x9e9e, 0x9e9b, 0x9e95, 0x9e96,
  0x9e91, 0x9e90, 0x9e92, 0x9ead, 0x9eaf, 0x9eae, 0x9ea8, 0x9eaa,
  0x7a92, 0x7aac, 0x7aae, 0x7aa8, 0x7aa5, 0x7aa4,
  /* 0x67 */
  0x7aa0, 0x7abd, 0x7ab3, 0x7acd, 0x7acc, 0x7acf, 0x7ac4, 0x7ac6,
  0x7ac1, 0x7add, 0x7ad9, 0x7ada, 0x7ad6, 0x7aed, 0x7aec, 0x7ae5,
  0x7ae6, 0x7ae3, 0x7ae2, 0x7afc, 0x7aff, 0x7b00, 0x7afb, 0x7af7,
  0x7af6, 0x7af3, 0x7b0c, 0x7b0f, 0x7b0e, 0x7b0a, 0x7b05, 0x7b06,
  0x7b01, 0x7b02, 0x7b1c, 0x7b1f, 0x7b1a, 0x7b14, 0x7b11, 0x7b16,
  0x7b12, 0x7b2c, 0x7b2f, 0x7b2e, 0x7b29, 0x7b28, 0x7b2b, 0x7b2a,
  0x7b27, 0x7b26, 0x7b21, 0x7b20, 0x7b22, 0x7b3d, 0x7b3c, 0x7b3f,
  0x7b3e, 0x7b38, 0x5a77, 0x7172, 0x59d6, 0x7133, 0x9498, 0x7783,
  0x779c, 0x77a3, 0x77af, 0x7792, 0x77c2, 0x77cf, 0x77dc, 0x77ba,
  0x77be, 0x77cd, 0x77c4, 0x77c5, 0x77e8, 0x77d4, 0x9c71, 0x7007,
  0x77e4, 0x77ea, 0x77d3, 0x77b7, 0x77ff, 0x7002, 0x7027, 0x7056,
  0x702b, 0x7028, 0x7025, 0x703d, 0x7023, 0x7021,
  /* 0x68 */
  0x7016, 0x7017, 0x704c, 0x7051, 0x705a, 0x7058, 0x7054, 0x707a,
  0x7060, 0x7073, 0x7091, 0x7083, 0x708d, 0x708c, 0x708a, 0x7086,
  0x7093, 0x70a5, 0x70a4, 0x709d, 0x70aa, 0x70df, 0x70b7, 0x93e7,
  0x93e6, 0x93e1, 0x6341, 0x635e, 0x6353, 0x6345, 0x6364, 0x63a8,
  0x638a, 0x6367, 0x637e, 0x6395, 0x63aa, 0x6378, 0x63a5, 0x6393,
  0x63a0, 0x6386, 0x637a, 0x6371, 0x63fd, 0x6c04, 0x63d5, 0x6c07,
  0x63e4, 0x63bd, 0x6c01, 0x63d4, 0x63b8, 0x63d7, 0x63be, 0x63d0,
  0x6c0d, 0x63ce, 0x63b5, 0x63ef, 0x6c03, 0x63cc, 0x63f0, 0x6c3f,
  0x6c3e, 0x6c6d, 0x6c6c, 0x6c43, 0x6c6f, 0x6c49, 0x6c69, 0x6c8e,
  0x6c10, 0x6c58, 0x6c6b, 0x6c4c, 0x6c6a, 0x6c4d, 0x6c33, 0x6c47,
  0x6c44, 0x6c24, 0x6cb8, 0x6c82, 0x6c79, 0x6c7a, 0x6c9e, 0x6c66,
  0x6ccf, 0x6d63, 0x6cf1, 0x6d12, 0x6d2d, 0x6cf4,
  /* 0x69 */
  0x6d29, 0x6cfd, 0x6d06, 0x6d0c, 0x6d5a, 0x6cee, 0x6d1d, 0x6d7c,
  0x6d34, 0x6d6d, 0x6d4f, 0x6d50, 0x6d89, 0x6d66, 0x6d8d, 0x6d95,
  0x6d75, 0x6d39, 0x6dc1, 0x6d8a, 0x6d85, 0x6dc3, 0x6d84, 0x6d6b,
  0x6d6e, 0x6d74, 0x6d96, 0x6daa, 0x6db6, 0x6da6, 0x6da0, 0x6dd9,
  0x6dbc, 0x6dcc, 0x6dc7, 0x6dd2, 0x6d98, 0x6ded, 0x6d80, 0x6df2,
  0x6e22, 0x6de0, 0x6e1a, 0x6e15, 0x6e68, 0x6dff, 0x6e49, 0x6e33,
  0x6ead, 0x6e5d, 0x6e56, 0x6e38, 0x6e83, 0x6e74, 0x6e30, 0x6e25,
  0x6e55, 0x6e71, 0x6e9c, 0x6e9d, 0x6ea4, 0x6e9a, 0x6ea6, 0x773a,
  0x775f, 0x6f8c, 0x6f8f, 0x6f8a, 0x6f89, 0x6f9f, 0x6f9e, 0x6f80,
  0x6f97, 0x6f96, 0x6fac, 0x6fa7, 0x8b66, 0x8b60, 0x8b7c, 0x8b7f,
  0x8b7e, 0x8b78, 0x8b7b, 0x8b75, 0x8b7a, 0x8b74, 0x8b77, 0x8b71,
  0x8b73, 0x8b8c, 0x8b8f, 0x8b89, 0x8b8a, 0x8b86,
  /* 0x6a */
  0x8b80, 0x8b83, 0x8b82, 0x8b95, 0x8b97, 0x8ac3, 0x6606, 0x661a,
  0x6616, 0x6612, 0x662f, 0x662c, 0x6628, 0x6629, 0x6621, 0x85ea,
  0x70e2, 0x70f9, 0x70f2, 0x7102, 0x711c, 0x711e, 0x6139, 0x61e3,
  0x61e2, 0x61fd, 0x6207, 0x6214, 0x637f, 0x620e, 0x6218, 0x620d,
  0x7488, 0x62fa, 0x6210, 0x6239, 0x623c, 0x623b, 0x6238, 0x840b,
  0x6252, 0x6259, 0x624c, 0x6242, 0x625b, 0x626c, 0x625a, 0x627a,
  0x6289, 0x6281, 0x62aa, 0x6290, 0x62b3, 0x62d6, 0x62d1, 0x62eb,
  0x62e4, 0x893f, 0x893e, 0x893b, 0x8936, 0x8930, 0x894d, 0x8948,
  0x894b, 0x8945, 0x8944, 0x894a, 0x8940, 0x8958, 0x8954, 0x8dca,
  0x8dc7, 0x8dc6, 0x8dc1, 0x8dc3, 0x8dc2, 0x8ddd, 0x8ddc, 0x7663,
  0x7692, 0x7650, 0x766b, 0x7662, 0x7673, 0x7672, 0x7689, 0x7686,
  0x7680, 0x7682, 0x769f, 0x6705, 0x673f, 0x67bd,
  /* 0x6b */
  0x6032, 0x60d5, 0x8409, 0x6fe7, 0x6ffe, 0x6ff0, 0x6ff8, 0x6ff4,
  0x6808, 0x680a, 0x680b, 0x6800, 0x6818, 0x6815, 0x6814, 0x6817,
  0x682c, 0x6824, 0x6829, 0x6827, 0x683f, 0x6138, 0x6158, 0x6166,
  0x7640, 0x765f, 0x765b, 0x763d, 0x826f, 0x561b, 0x8492, 0x8491,
  0x849e, 0x84b1, 0x6307, 0x84b0, 0x84bc, 0x84a6, 0x84a0, 0x84b9,
  0x84ba, 0x84ea, 0x84e5, 0x84e4, 0x84e7, 0x84d6, 0x84cf, 0x84c9,
  0x84d4, 0x84c0, 0x84da, 0x631d, 0x84d0, 0x84e6, 0x84fc, 0x84f9,
  0x84e0, 0x8500, 0x8503, 0x84ff, 0x84f1, 0x6318, 0x851f, 0x8857,
  0x853b, 0x8513, 0x8521, 0x8515, 0x853f, 0x8545, 0x8541, 0x855e,
  0x8579, 0x8554, 0x8557, 0x857c, 0x856d, 0x8564, 0x8571, 0x8570,
  0x8560, 0x856a, 0x5c40, 0x5eb8, 0x8585, 0x858f, 0x859c, 0x6ad8,
  0x85ae, 0x85a7, 0x85c1, 0x632b, 0x85c7, 0x85b6,
  /* 0x6c */
  0x85cc, 0x85ab, 0x6f29, 0x6f3a, 0x6f34, 0x6f4e, 0x6f4b, 0x6f54,
  0x9cdc, 0x9cdf, 0x9cde, 0x9cd8, 0x9cd4, 0x9cd7, 0x6fbe, 0x5b4d,
  0x6fcf, 0x8dfe, 0x619d, 0x9b5c, 0x619e, 0x61b1, 0x61cb, 0x61c9,
  0x61ce, 0x61c1, 0x61c3, 0x61df, 0x61db, 0x748d, 0x7491, 0x749b,
  0x7490, 0x74b6, 0x74cd, 0x74ba, 0x74a6, 0x74bc, 0x74e5, 0x74c7,
  0x751d, 0x751e, 0x751b, 0x7522, 0x753c, 0x757e, 0x7551, 0x7565,
  0x7548, 0x757f, 0x7547, 0x7575, 0x7577, 0x7595, 0x75be, 0x75b8,
  0x75a5, 0x75ad, 0x75ed, 0x75d9, 0x75ea, 0x75f4, 0x7610, 0x7625,
  0x7461, 0x7515, 0x756b, 0x75b4, 0x6633, 0x6630, 0x664e, 0x6645,
  0x6644, 0x7d36, 0x7d4d, 0x7d4b, 0x7d44, 0x7d56, 0x7d51, 0x7d5e,
  0x7d57, 0x7d6f, 0x7d5a, 0x7d6d, 0x7d62, 0x7d6a, 0x7d77, 0x7d88,
  0x7d87, 0x7d97, 0x7daa, 0x7dbe, 0x5bdc, 0x5bdd,
  /* 0x6d */
  0x6431, 0x6450, 0x6457, 0x646a, 0x644c, 0x6454, 0x646e, 0x64a6,
  0x650b, 0x6500, 0x6550, 0x65a4, 0x6590, 0x65c6, 0x65dc, 0x660b,
  0x848d, 0x8472, 0x689e, 0x68fb, 0x69f1, 0x73fb, 0x73f5, 0x7c0d,
  0x7c04, 0x7c1a, 0x7c15, 0x7c1c, 0x61a6, 0x7c20, 0x7c11, 0x7c10,
  0x7c34, 0x7c37, 0x7c36, 0x7c12, 0x7c31, 0x7c28, 0x7c21, 0x7c2e,
  0x7c24, 0x7c43, 0x7c60, 0x7c5b, 0x7c5a, 0x7c2b, 0x7c5d, 0x7c4a,
  0x7c41, 0x7c67, 0x7c96, 0x7c9e, 0x7c97, 0x7c8a, 0x7c91, 0x7cac,
  0x7cae, 0x7cbf, 0x7cb4, 0x7ca8, 0x7cd9, 0x7cd4, 0x7cc4, 0x7ce1,
  0x7cff, 0x7d08, 0x7cf9, 0x7d1e, 0x7d29, 0x7d13, 0x7d39, 0x9b96,
  0x9af4, 0x9af6, 0x9af1, 0x72fc, 0x7309, 0x7300, 0x72f4, 0x730a,
  0x7305, 0x7317, 0x732f, 0x7314, 0x7320, 0x732b, 0x7338, 0x7335,
  0x735d, 0x735c, 0x734a, 0x734e, 0x7357, 0x7365,
  /* 0x6e */
  0x736f, 0x7368, 0x7372, 0x7380, 0x7370, 0x738d, 0x7381, 0x739c,
  0x7392, 0x73ad, 0x73bd, 0x73b8, 0x73b0, 0x7137, 0x714d, 0x7143,
  0x7146, 0x7145, 0x7156, 0x717f, 0x7174, 0x718e, 0x7b55, 0x7b6c,
  0x7b52, 0x8e45, 0x7b65, 0x7b79, 0x7b7c, 0x7b74, 0x7b8c, 0x7b73,
  0x72c0, 0x72e8, 0x8c3f, 0x9088, 0x908b, 0x908a, 0x9086, 0x9087,
  0x9081, 0x9080, 0x9082, 0x909d, 0x9099, 0x909a, 0x9098, 0x9097,
  0x9096, 0x9091, 0x90ae, 0x90a9, 0x90a6, 0x90a7, 0x90a0, 0x90a1,
  0x90a2, 0x90bd, 0x90bf, 0x90b9, 0x90bb, 0x90ba, 0x90b5, 0x90b4,
  0x90b7, 0x90b1, 0x90b0, 0x90b2, 0x90c9, 0x90c5, 0x90c4, 0x90c7,
  0x90c6, 0x90c1, 0x90c0, 0x90c3, 0x90dd, 0x90dc, 0x90df, 0x90d8,
  0x90db, 0x90da, 0x90d4, 0x90d5, 0x90d6, 0x90d3, 0x90d2, 0x90ed,
  0x90ef, 0x90e9, 0x90e8, 0x90ea, 0x90e5, 0x90e7,
  /* 0x6f */
  0x90e4, 0x90e6, 0x90e3, 0x90e2, 0x90fe, 0x90f9, 0x90f8, 0x90fa,
  0x90f4, 0x90f1, 0x90f0, 0x90f2, 0x910e, 0x910f, 0x910b, 0x910a,
  0x9104, 0x9107, 0x9100, 0x9103, 0x9102, 0x911f, 0x911e, 0x9119,
  0x9118, 0x911b, 0x9115, 0x9116, 0x9110, 0x9113, 0x9112, 0x912f,
  0x9127, 0x9126, 0x9124, 0x9121, 0x913c, 0x913f, 0x9139, 0x913b,
  0x913a, 0x9135, 0x9131, 0x9133, 0x9132, 0x914f, 0x9138, 0x9149,
  0x9148, 0x914b, 0x9144, 0x9141, 0x9143, 0x9142, 0x915f, 0x915e,
  0x9159, 0x915b, 0x915a, 0x9155, 0x9154, 0x9156, 0x9153, 0x9152,
  0x9150, 0x916c, 0x916f, 0x9169, 0x9168, 0x916b, 0x916a, 0x9165,
  0x9164, 0x9167, 0x9166, 0x9161, 0x9162, 0x917c, 0x917f, 0x917e,
  0x9137, 0x73ea, 0x73e1, 0x92c4, 0x7dd8, 0x7de0, 0x7dee, 0x7de6,
  0x7e0b, 0x594a, 0x7e0e, 0x7e0f, 0x7e13, 0x7e19,
  /* 0x70 */
  0x7e34, 0x7e3a, 0x7e5c, 0x9ac2, 0x9da8, 0x7e7d, 0x7285, 0x7283,
  0x729e, 0x7294, 0x72a9, 0x70d3, 0x70ed, 0x7121, 0x9a2d, 0x9a2f,
  0x9a25, 0x9a24, 0x9a27, 0x9a26, 0x9a21, 0x9a3f, 0x9a3c, 0x9a3b,
  0x9a35, 0x9a3a, 0x9a34, 0x9a37, 0x9a33, 0x9a4c, 0x9a4f, 0x9a49,
  0x9a4b, 0x9a4a, 0x9a45, 0x9a44, 0x9a46, 0x9a41, 0x9a43, 0x9a5c,
  0x9a58, 0x9a5a, 0x9a57, 0x9a56, 0x9a51, 0x9a53, 0x9a6e, 0x9a6b,
  0x9a6a, 0x9a65, 0x9a64, 0x9a67, 0x9a66, 0x9a61, 0x9a7c, 0x9a60,
  0x9a7e, 0x719f, 0x7199, 0x719b, 0x71ad, 0x7190, 0x71a1, 0x71ae,
  0x71be, 0x71b9, 0x71b5, 0x71c9, 0x71bc, 0x71bd, 0x71ce, 0x71cf,
  0x71db, 0x71c0, 0x71ee, 0x71e5, 0x71eb, 0x71e9, 0x71e6, 0x71ea,
  0x720e, 0x71fc, 0x71f1, 0x71f2, 0x721d, 0x720d, 0x7208, 0x7201,
  0x721a, 0x7207, 0x7228, 0x7215, 0x7218, 0x7214,
  /* 0x71 */
  0x7216, 0x7231, 0x722f, 0x722d, 0x724d, 0x7220, 0x723d, 0x7232,
  0x7238, 0x724e, 0x7233, 0x723e, 0x7240, 0x7253, 0x7259, 0x7251,
  0x725b, 0x7266, 0x7262, 0x7bc7, 0x7eeb, 0x7e75, 0x7e74, 0x7e8d,
  0x7e8b, 0x7e85, 0x7e98, 0x7eab, 0x7ead, 0x7ea1, 0x7ea5, 0x7ea0,
  0x7ebe, 0x8c69, 0x8c64, 0x8c7f, 0x8c70, 0x8c72, 0x8c8f, 0x8caf,
  0x8ccb, 0x8cba, 0x8cb1, 0x8cc4, 0x8cef, 0x8cc3, 0x8cee, 0x8ce8,
  0x8cfc, 0x8d17, 0x8cf1, 0x8ce5, 0x8cf3, 0x8cfd, 0x8d2c, 0x8d14,
  0x8d1e, 0x8d16, 0x8d07, 0x8d39, 0x8d26, 0x8d3b, 0x8d4c, 0x8d6b,
  0x8d76, 0x7186, 0x84e8, 0x72bf, 0x72b9, 0x73d1, 0x841f, 0x8419,
  0x841b, 0x8411, 0x842d, 0x842f, 0x8428, 0x842b, 0x842a, 0x8424,
  0x8425, 0x843c, 0x8406, 0x8438, 0x844e, 0x844b, 0x8440, 0x845f,
  0x8464, 0x847c, 0x8d8e, 0x9c75, 0x9c8d, 0x9c8e,
  /* 0x72 */
  0x9c84, 0x9c81, 0x9c80, 0x9c82, 0x9c99, 0x9c97, 0x9c96, 0x9c93,
  0x9c92, 0x9cac, 0x9caf, 0x9ca8, 0x9cab, 0x8240, 0x8259, 0x8261,
  0x8263, 0x8272, 0x8277, 0x8271, 0x8276, 0x82a5, 0x8280, 0x8286,
  0x82a1, 0x8290, 0x82aa, 0x82ae, 0x82a7, 0x829e, 0x82a4, 0x82bb,
  0x82c9, 0x82b8, 0x82c3, 0x82bd, 0x82b7, 0x82bc, 0x82a2, 0x82c4,
  0x82c2, 0x82b9, 0x82e4, 0x82fc, 0x82ff, 0x82e0, 0x82fe, 0x82dd,
  0x831e, 0x82d3, 0x82f9, 0x82d2, 0x82d5, 0x82dc, 0x830e, 0x830a,
  0x82f5, 0x8305, 0x8307, 0x8300, 0x8304, 0x832e, 0x8336, 0x8313,
  0x8328, 0x8323, 0x8317, 0x8333, 0x8345, 0x8339, 0x833c, 0x8324,
  0x833a, 0x8332, 0x838f, 0x832f, 0x8370, 0x8373, 0x8376, 0x836d,
  0x837d, 0x8341, 0x8363, 0x8386, 0x835e, 0x836e, 0x8371, 0x8369,
  0x8354, 0x8368, 0x839e, 0x83a2, 0x83a5, 0x83df,
  /* 0x73 */
  0x83cb, 0x8385, 0x8388, 0x83a0, 0x839a, 0x838e, 0x83a6, 0x83e8,
  0x83a1, 0x83b8, 0x83be, 0x83c6, 0x83de, 0x83b0, 0x83dc, 0x83cd,
  0x83c7, 0x83d6, 0x83e7, 0x83ed, 0x83e3, 0x8c1b, 0x8c1e, 0x83f3,
  0x8c07, 0x8c16, 0x8c2c, 0x8c34, 0x8c31, 0x7b3b, 0x7b4f, 0x7b49,
  0x7b48, 0x861d, 0x7ef7, 0x7ef0, 0x7f05, 0x7f0e, 0x7f09, 0x7f18,
  0x7f07, 0x7f26, 0x7f02, 0x7f4a, 0x7f35, 0x7f27, 0x7f14, 0x7f23,
  0x7f3c, 0x7f2d, 0x7f28, 0x7f29, 0x7f3e, 0x7f33, 0x7f13, 0x7f55,
  0x7f57, 0x7f48, 0x7f78, 0x7f41, 0x7f50, 0x7f6d, 0x7f63, 0x7f76,
  0x7f6f, 0x7f7f, 0x7f7c, 0x7f9d, 0x7fab, 0x7faa, 0x7fb5, 0x7fa1,
  0x7f90, 0x7fa5, 0x7f88, 0x7fa7, 0x7f91, 0x7faf, 0x7fa6, 0x7fb9,
  0x7fdc, 0x7fcc, 0x7fc1, 0x7fd0, 0x7fd7, 0x7fe8, 0x7feb, 0x7fe7,
  0x7801, 0x7ff3, 0x7ff1, 0x7802, 0x781b, 0x7806,
  /* 0x74 */
  0x7812, 0x7827, 0x782b, 0x7835, 0x784c, 0x784d, 0x85f3, 0x860c,
  0x860f, 0x8609, 0x85e1, 0x8c49, 0x862c, 0x862f, 0x862e, 0x8620,
  0x8622, 0x8625, 0x8626, 0x8635, 0x8636, 0x863e, 0x8639, 0x8633,
  0x8649, 0x8644, 0x8646, 0x8642, 0x8657, 0x8652, 0x8665, 0x8c73,
  0x8c88, 0x8c85, 0x8cd5, 0x8cd2, 0x8d53, 0x7b90, 0x7b92, 0x7baa,
  0x7ba2, 0x7bbd, 0x7bbf, 0x7871, 0x6144, 0x789c, 0x7890, 0x7891,
  0x7893, 0x78af, 0x78bf, 0x78b1, 0x78b0, 0x78cc, 0x78ca, 0x78c1,
  0x78c0, 0x78c5, 0x78c8, 0x78da, 0x78e5, 0x8663, 0x62a5, 0x7bb2,
  0x7bc3, 0x7bd8, 0x7be8, 0x7bec, 0x7beb, 0x7be4, 0x7be3, 0x7bfe,
  0x78f5, 0x797a, 0x79ab, 0x79a3, 0x7a4a, 0x7a96, 0x9ab5, 0x9ab9,
  0x897e, 0x8989, 0x8999, 0x899c, 0x89bc, 0x896a, 0x8960, 0x884a,
  0x8844, 0x9547, 0x955d, 0x9543, 0x9542, 0x9569,
  /* 0x75 */
  0x956f, 0x956c, 0x957d, 0x9564, 0x9562, 0x9570, 0x9573, 0x957f,
  0x9579, 0x9574, 0x9581, 0x9588, 0x959d, 0x9580, 0x959c, 0x95af,
  0x95ae, 0x95a7, 0x95a0, 0x95a3, 0x95a2, 0x95b8, 0x95b9, 0x95b7,
  0x8858, 0x9a73, 0x89b5, 0x89e6, 0x8a08, 0x8a54, 0x8a64, 0x89b8,
  0x89b2, 0x89b1, 0x89b7, 0x89c9, 0x89db, 0x89da, 0x89d7, 0x89d3,
  0x89c3, 0x89c2, 0x89d6, 0x89cb, 0x89e1, 0x89fa, 0x89f5, 0x89ee,
  0x89f4, 0x89f6, 0x89e9, 0x8a04, 0x89f0, 0x8a19, 0x8a10, 0x8a12,
  0x8a21, 0x8a23, 0x8a2e, 0x8a22, 0x8a37, 0x8a4d, 0x8a34, 0x8a38,
  0x8a30, 0x8a3c, 0x8a44, 0x8a4c, 0x8a4f, 0x8a5c, 0x8a5f, 0x8a47,
  0x8a7d, 0x8a7b, 0x8a71, 0x8a62, 0x8a79, 0x8a88, 0x8a82, 0x8a99,
  0x8a9d, 0x8a91, 0x8a93, 0x8875, 0x888f, 0x8887, 0x8888, 0x8895,
  0x8899, 0x6196, 0x8ddb, 0x8dd3, 0x8dd7, 0x8dd1,
  /* 0x76 */
  0x8de8, 0x8de6, 0x8de2, 0x8e33, 0x8f2b, 0x935e, 0x92e4, 0x92fe,
  0x92e2, 0x930b, 0x930c, 0x9305, 0x9302, 0x9303, 0x9327, 0x9320,
  0x933d, 0x9333, 0x9b8d, 0x9b8e, 0x9b88, 0x9b8b, 0x9b8a, 0x9b85,
  0x9b84, 0x9b87, 0x9b81, 0x9af3, 0x9b06, 0x9b00, 0x92b4, 0x92b1,
  0x92b0, 0x92c3, 0x92df, 0x73b2, 0x92ed, 0x9683, 0x96a3, 0x96c5,
  0x9733, 0x9767, 0x97c7, 0x9782, 0x9033, 0x9066, 0x9872, 0x988f,
  0x9888, 0x988b, 0x988a, 0x9885, 0x7e2e, 0x9886, 0x9883, 0x989d,
  0x989c, 0x989f, 0x9899, 0x9898, 0x9897, 0x9896, 0x9893, 0x9892,
  0x98ad, 0x98ac, 0x98af, 0x98ae, 0x98a8, 0x98ab, 0x98aa, 0x98a5,
  0x98a4, 0x98a6, 0x98a0, 0x98a3, 0x98bd, 0x98bc, 0x98bf, 0x98be,
  0x98b9, 0x98b8, 0x98bb, 0x98ba, 0x98b7, 0x98b6, 0x98b1, 0x98b0,
  0x98c9, 0x98c8, 0x98cb, 0x98ca, 0x98c7, 0x98c6,
  /* 0x77 */
  0x98c1, 0x98c0, 0x98c3, 0x98c2, 0x98dd, 0x98de, 0x98d9, 0x98d8,
  0x98da, 0x98d5, 0x98d4, 0x98d1, 0x98d0, 0x98d2, 0x98ef, 0x9371,
  0x9388, 0x939c, 0x939f, 0x9399, 0x93a2, 0x93a6, 0x93ae, 0x93bf,
  0x93b9, 0x9ebc, 0x9ebd, 0x9eba, 0x9a55, 0x9ebb, 0x9eb7, 0x9eb1,
  0x9ecc, 0x9ecd, 0x9ec8, 0x9ecf, 0x9ec6, 0x9ec1, 0x9edc, 0x9f48,
  0x9f4e, 0x9f4a, 0x9f44, 0x9f45, 0x9f40, 0x9f5c, 0x9ce5, 0x9d00,
  0x9d23, 0x9d58, 0x9d59, 0x9ed2, 0x9eec, 0x9eeb, 0x9ee2, 0x9ee6,
  0x9ef6, 0x9ee0, 0x9ef4, 0x9f05, 0x9f02, 0x9f1e, 0x9f12, 0x9f2e,
  0x9ab0, 0x9ab3, 0x7a36, 0x9a8f, 0x9a8a, 0x9a85, 0x9a86, 0x9a9f,
  0x97db, 0x9a90, 0x9a92, 0x9ad6, 0x9ad1, 0x9ad0, 0x9aed, 0x9ad2,
  0x9aef, 0x9ae4, 0x9aea, 0x9ae8, 0x9ae7, 0x9ae2, 0x9b2f, 0x9b21,
  0x9b22, 0x9b34, 0x9b3a, 0x9b30, 0x9b33, 0x9b49
};

static const acp_uint16_t gb2312_2charset[ /*7445*/ ] = {
  0x2565, 0x2561, 0x252a, 0x256e, 0x254d, 0x254c, 0x2c29, 0x2c2f,
  0x2c25, 0x2c2b, 0x2c37, 0x2c21, 0x2c27, 0x2c3d, 0x2c23, 0x254f,
  0x2c39, 0x2c3f, 0x2c34, 0x2c2c, 0x2c28, 0x2c2a, 0x2c24, 0x2c20,
  0x2c3c, 0x2c2e, 0x2c26, 0x2c22, 0x2c3e, 0x2c38, 0x2c3b, 0x2c3a,
  0x2c35, 0x252b, 0x2528, 0x222c, 0x222f, 0x222e, 0x2229, 0x2228,
  0x222b, 0x222a, 0x2225, 0x2224, 0x2227, 0x2226, 0x2221, 0x2220,
  0x2223, 0x2222, 0x223d, 0x223c, 0x223f, 0x223e, 0x2239, 0x2238,
  0x223b, 0x223a, 0x2235, 0x224c, 0x224f, 0x224e, 0x2249, 0x2248,
  0x224b, 0x224a, 0x2245, 0x2244, 0x2247, 0x2246, 0x2241, 0x2240,
  0x2243, 0x2242, 0x225d, 0x225c, 0x225f, 0x225e, 0x2259, 0x2258,
  0x225b, 0x225a, 0x2255, 0x232a, 0x232c, 0x232f, 0x232e, 0x2329,
  0x2328, 0x232b, 0x2325, 0x2324, 0x2327, 0x2326, 0x2321, 0x2320,
  0x2323, 0x2322, 0x233d, 0x233c, 0x233f, 0x233e, 0x2339, 0x2338,
  0x233b, 0x233a, 0x2335, 0x2334, 0x2337, 0x2336, 0x2331, 0x2330,
  0x2333, 0x2332, 0x234d, 0x234c, 0x235c, 0x235f, 0x235e, 0x2359,
  0x2358, 0x235b, 0x2355, 0x2354, 0x2357, 0x2356, 0x2351, 0x2350,
  0x2353, 0x2352, 0x236d, 0x236c, 0x236f, 0x236e, 0x2369, 0x2368,
  0x236b, 0x236a, 0x2365, 0x2364, 0x2367, 0x2366, 0x2361, 0x2360,
  0x2363, 0x2362, 0x237d, 0x237c, 0x235a, 0x2527, 0x2521, 0x2523,
  0x2522, 0x253d, 0x253c, 0x2520, 0x2566, 0x2569, 0x2568, 0x2574,
  0x256b, 0x2560, 0x267c, 0x267f, 0x267e, 0x2679, 0x2678, 0x267b,
  0x267a, 0x2675, 0x2674, 0x2677, 0x2676, 0x2671, 0x2576, 0x2571,
  0x2577, 0x2570, 0x2547, 0x254a, 0x254b, 0x2541, 0x2555, 0x2553,
  0x2542, 0x2543, 0x2549, 0x2548, 0x2544, 0x2545, 0x255f, 0x255e,
  0x256d, 0x2552, 0x254e, 0x2546, 0x255a, 0x255b, 0x2558, 0x2554,
  0x2559, 0x2551, 0x2550, 0x2557, 0x2556, 0x255c, 0x2540, 0x255d,
  0x2654, 0x2657, 0x2656, 0x2651, 0x2650, 0x2653, 0x2652, 0x266d,
  0x266c, 0x266f, 0x2648, 0x264b, 0x264a, 0x2645, 0x2644, 0x2647,
  0x2646, 0x2641, 0x2640, 0x2643, 0x2642, 0x265d, 0x265c, 0x265f,
  0x265e, 0x2659, 0x2658, 0x265b, 0x265a, 0x2655, 0x263c, 0x263f,
  0x263e, 0x2639, 0x2638, 0x263b, 0x263a, 0x2635, 0x2634, 0x2637,
  0x2636, 0x2631, 0x2630, 0x2633, 0x2632, 0x264d, 0x264c, 0x264f,
  0x264e, 0x2649, 0x2d29, 0x2d28, 0x2d2b, 0x2d2a, 0x2d25, 0x2d24,
  0x2d27, 0x2d26, 0x2d21, 0x2d20, 0x2d23, 0x2d22, 0x2d3d, 0x2d3c,
  0x2d3f, 0x2d3e, 0x2d39, 0x2d38, 0x2d3b, 0x2d3a, 0x2d35, 0x2d34,
  0x2d37, 0x2d36, 0x2d31, 0x2d30, 0x2d33, 0x2d32, 0x2d4d, 0x2d4c,
  0x2d4f, 0x2d4e, 0x2d49, 0x2d48, 0x2d4b, 0x2d4a, 0x2d45, 0x2d44,
  0x2d47, 0x2d46, 0x2d41, 0x2d40, 0x2d43, 0x2d42, 0x2d5d, 0x2d5c,
  0x2d5f, 0x2d5e, 0x2d59, 0x2d58, 0x2d5b, 0x2d5a, 0x2d55, 0x2d54,
  0x2d57, 0x2d56, 0x2d51, 0x2d50, 0x2d53, 0x2d52, 0x2d6d, 0x2d6c,
  0x2d6f, 0x2d6e, 0x2d69, 0x2d68, 0x2d6b, 0x2d6a, 0x2d65, 0x2d64,
  0x2d67, 0x2d66, 0x2d61, 0x2d60, 0x2d63, 0x2d62, 0x257b, 0x2578,
  0x2575, 0x257a, 0x2579, 0x257e, 0x257d, 0x257f, 0x257c, 0x2562,
  0x2563, 0x256f, 0x256c, 0x252c, 0x252f, 0x252e, 0x2525, 0x2524,
  0x2539, 0x2538, 0x253b, 0x253a, 0x2535, 0x2534, 0x2537, 0x2536,
  0x2533, 0x2532, 0x2573, 0x253f, 0x253e, 0x2531, 0x2530, 0x202c,
  0x202f, 0x202e, 0x2029, 0x2028, 0x202b, 0x202a, 0x2025, 0x2024,
  0x2027, 0x2026, 0x2021, 0x2020, 0x2023, 0x2022, 0x203d, 0x203c,
  0x203f, 0x203e, 0x2039, 0x2038, 0x203b, 0x203a, 0x2035, 0x2034,
  0x2037, 0x2036, 0x2031, 0x2030, 0x2033, 0x2032, 0x204d, 0x204c,
  0x204f, 0x204e, 0x2049, 0x2048, 0x204b, 0x204a, 0x2045, 0x2044,
  0x2047, 0x2046, 0x2041, 0x2040, 0x2043, 0x2042, 0x205d, 0x205c,
  0x205f, 0x205e, 0x2059, 0x2058, 0x205b, 0x205a, 0x2055, 0x2054,
  0x2057, 0x2056, 0x2051, 0x2050, 0x2053, 0x2052, 0x206d, 0x206c,
  0x206f, 0x206e, 0x2069, 0x2068, 0x206b, 0x206a, 0x2065, 0x2064,
  0x2067, 0x2066, 0x2061, 0x2060, 0x2063, 0x2062, 0x207d, 0x207c,
  0x207f, 0x207e, 0x212c, 0x212f, 0x212e, 0x2129, 0x2128, 0x212b,
  0x212a, 0x2125, 0x2124, 0x2127, 0x2126, 0x2121, 0x2120, 0x2123,
  0x2122, 0x213d, 0x213c, 0x213f, 0x213e, 0x2139, 0x2138, 0x213b,
  0x213a, 0x2135, 0x2134, 0x2137, 0x2136, 0x2131, 0x2130, 0x2133,
  0x2132, 0x214d, 0x214c, 0x214f, 0x214e, 0x2149, 0x2148, 0x214b,
  0x214a, 0x2145, 0x2144, 0x2147, 0x2146, 0x2141, 0x2140, 0x2143,
  0x2142, 0x215d, 0x215c, 0x215f, 0x215e, 0x2159, 0x2158, 0x215b,
  0x215a, 0x2155, 0x2154, 0x2157, 0x2156, 0x2151, 0x2150, 0x2153,
  0x2152, 0x216d, 0x216c, 0x216f, 0x216e, 0x2169, 0x2168, 0x216b,
  0x216a, 0x2165, 0x2164, 0x2167, 0x2166, 0x2161, 0x2160, 0x2163,
  0x2162, 0x217d, 0x217c, 0x217f, 0x217e, 0x2179, 0x2178, 0x217b,
  0x2529, 0x2c48, 0x2c4b, 0x2c4a, 0x2c45, 0x2c44, 0x2c47, 0x2c46,
  0x2c41, 0x2c40, 0x2c43, 0x2c42, 0x2c5d, 0x2c5c, 0x2c5f, 0x2c5e,
  0x2c59, 0x2c58, 0x2c5b, 0x2c5a, 0x2c55, 0x2c54, 0x2c57, 0x2c56,
  0x2c51, 0x2c50, 0x2c53, 0x2c52, 0x2c6d, 0x2c6c, 0x2c6f, 0x2c6e,
  0x2c69, 0x2c68, 0x2c6b, 0x2c6a, 0x2c65, 0x2c64, 0x2668, 0x266b,
  0x266a, 0x2665, 0x2664, 0x2667, 0x2666, 0x2661, 0x2660, 0x2663,
  0x5636, 0x322c, 0x4252, 0x497f, 0x5144, 0x4c70, 0x4d42, 0x4b4f,
  0x5c2f, 0x3636, 0x5766, 0x5c29, 0x377e, 0x5325, 0x435f, 0x5c2a,
  0x4e4d, 0x437d, 0x3576, 0x5638, 0x3059, 0x3226, 0x4f32, 0x5c24,
  0x3227, 0x4530, 0x5542, 0x4d28, 0x5c20, 0x3c7b, 0x5533, 0x6751,
  0x525d, 0x336c, 0x3023, 0x4554, 0x5c31, 0x4965, 0x3129, 0x4a27,
  0x527a, 0x447b, 0x3a54, 0x5c22, 0x4046, 0x3a4e, 0x5c3c, 0x4739,
  0x5668, 0x5223, 0x4a57, 0x512a, 0x3e78, 0x332b, 0x445b, 0x4234,
  0x415f, 0x434a, 0x3d59, 0x3746, 0x565f, 0x5c32, 0x3a48, 0x427f,
  0x563f, 0x4b3d, 0x4b6a, 0x4e64, 0x5c4d, 0x467f, 0x465f, 0x4c64,
  0x4321, 0x4546, 0x5765, 0x5174, 0x4e4f, 0x3273, 0x5c2c, 0x5757,
  0x3b7a, 0x504b, 0x3f28, 0x5c4c, 0x4a68, 0x3a23, 0x5c25, 0x554a,
  0x5424, 0x5c30, 0x5d62, 0x497b, 0x3b37, 0x3936, 0x3e28, 0x566d,
  0x3677, 0x3e6d, 0x403b, 0x4b60, 0x3a24, 0x4929, 0x454c, 0x435a,
  0x5d7c, 0x5d79, 0x4c46, 0x5c64, 0x5657, 0x4e3f, 0x4c47, 0x5c61,
  0x5c67, 0x5c4b, 0x397b, 0x4240, 0x377d, 0x5c66, 0x397c, 0x3964,
  0x4c59, 0x305e, 0x4655, 0x365b, 0x535d, 0x4e46, 0x4f76, 0x5141,
  0x3c3b, 0x4b44, 0x5d57, 0x5c7d, 0x4327, 0x5c63, 0x3077, 0x4563,
  0x5659, 0x5c60, 0x564a, 0x5c62, 0x474a, 0x557b, 0x5254, 0x5c7f,
  0x5c78, 0x3873, 0x3856, 0x4c43, 0x3350, 0x334f, 0x427e, 0x5c75,
  0x564c, 0x4a64, 0x3832, 0x3371, 0x3328, 0x5450, 0x5257, 0x5748,
  0x3f62, 0x3f6c, 0x5c7c, 0x4d2c, 0x4a3d, 0x3026, 0x5c7e, 0x4d46,
  0x5c7b, 0x465a, 0x5c7a, 0x4a3c, 0x5c74, 0x3623, 0x3d4d, 0x5d2e,
  0x3464, 0x456b, 0x4d61, 0x4f48, 0x4f4b, 0x5d29, 0x3165, 0x3126,
  0x4a36, 0x3140, 0x532c, 0x5379, 0x575e, 0x4868, 0x3e43, 0x5d2f,
  0x5d51, 0x576d, 0x5c70, 0x337d, 0x537a, 0x5c73, 0x5c77, 0x5d2c,
  0x406e, 0x573b, 0x5c79, 0x5d50, 0x5c76, 0x4168, 0x445d, 0x557d,
  0x3456, 0x385c, 0x5d2b, 0x5d28, 0x5d21, 0x5d23, 0x5d26, 0x4e34,
  0x5d24, 0x523b, 0x3753, 0x5d25, 0x4470, 0x4e41, 0x5d27, 0x5d2a,
  0x5d3d, 0x323c, 0x3d24, 0x564d, 0x4b4d, 0x464f, 0x3949, 0x5161,
  0x366d, 0x4345, 0x3b66, 0x5d20, 0x5d22, 0x4a67, 0x3e63, 0x435b,
  0x356e, 0x3054, 0x3260, 0x5d39, 0x3b2c, 0x5d53, 0x4343, 0x4473,
  0x5d35, 0x4f5a, 0x3370, 0x5d38, 0x5d3a, 0x352e, 0x576c, 0x5d34,
  0x5448, 0x5d3b, 0x5d3c, 0x5d3f, 0x4524, 0x5d3e, 0x387e, 0x5453,
  0x3c24, 0x3a6e, 0x5d30, 0x5d37, 0x343e, 0x5d4f, 0x5d49, 0x353b,
  0x5d32, 0x3134, 0x3a7e, 0x4845, 0x3e7f, 0x565d, 0x5d4e, 0x3965,
  0x3726, 0x5d48, 0x3a66, 0x5d4b, 0x5d36, 0x4052, 0x5d33, 0x5d4c,
  0x5d4d, 0x5123, 0x5238, 0x436e, 0x5d45, 0x3854, 0x5d47, 0x5d31,
  0x5d46, 0x4226, 0x5d44, 0x537b, 0x492e, 0x392c, 0x5d41, 0x4131,
  0x4938, 0x5d40, 0x5d4a, 0x3728, 0x3b73, 0x3c38, 0x4471, 0x3475,
  0x307b, 0x5d43, 0x5d42, 0x302f, 0x5d5d, 0x3052, 0x344c, 0x5d5c,
  0x4d38, 0x4b7c, 0x5d5f, 0x4548, 0x5d5b, 0x4d23, 0x5d58, 0x5d59,
  0x5d5a, 0x4f56, 0x3924, 0x422a, 0x5d5e, 0x5d55, 0x5d54, 0x4c68,
  0x4451, 0x3274, 0x5c2e, 0x5047, 0x5027, 0x545b, 0x3769, 0x515a,
  0x4b45, 0x3d6f, 0x3b46, 0x476f, 0x325f, 0x494e, 0x5d63, 0x5d7d,
  0x313e, 0x3238, 0x3a29, 0x4c66, 0x4c26, 0x3446, 0x3d26, 0x4574,
  0x5d6f, 0x4431, 0x3d3f, 0x3d55, 0x5446, 0x3575, 0x4269, 0x3a52,
  0x3169, 0x5345, 0x5575, 0x386b, 0x4e53, 0x3830, 0x5d6b, 0x5c6a,
  0x4057, 0x3c59, 0x4c30, 0x366c, 0x5054, 0x473d, 0x476c, 0x5e2f,
  0x4c52, 0x5439, 0x3a71, 0x4124, 0x3d57, 0x5e2e, 0x5024, 0x5e29,
  0x5d76, 0x3221, 0x3366, 0x3574, 0x5d71, 0x3768, 0x3a7b, 0x3b7b,
  0x563c, 0x4469, 0x323e, 0x5d73, 0x5d70, 0x3a36, 0x426d, 0x5331,
  0x5e2c, 0x4534, 0x317f, 0x4565, 0x3878, 0x3058, 0x4550, 0x4070,
  0x3835, 0x333f, 0x3362, 0x5d61, 0x4233, 0x3b20, 0x3f46, 0x3147,
  0x5f44, 0x545a, 0x4934, 0x3431, 0x377b, 0x3f7a, 0x5f47, 0x3e22,
  0x5069, 0x313b, 0x317e, 0x5c5b, 0x4c5d, 0x335b, 0x435d, 0x5c5a,
  0x3b22, 0x5f36, 0x5c55, 0x5441, 0x3f23, 0x6f33, 0x455d, 0x4578,
  0x507f, 0x3c58, 0x3039, 0x3778, 0x4d33, 0x415d, 0x4154, 0x4476,
  0x357d, 0x5c54, 0x3d43, 0x3130, 0x5c57, 0x524b, 0x4f2f, 0x4c22,
  0x4d3f, 0x3041, 0x3b41, 0x3d79, 0x5c56, 0x5c51, 0x326a, 0x384c,
  0x4867, 0x4b7a, 0x5c50, 0x433d, 0x3d5d, 0x392e, 0x4853, 0x4247,
  0x5c6d, 0x5c53, 0x5c52, 0x3473, 0x3a6a, 0x4e2e, 0x3879, 0x3c3c,
  0x3c63, 0x5c6f, 0x3946, 0x5c69, 0x5c6e, 0x4171, 0x5c68, 0x5c6b,
  0x452b, 0x4c3d, 0x3461, 0x3d2b, 0x385e, 0x4a7c, 0x5f30, 0x455e,
  0x3222, 0x5277, 0x4121, 0x3954, 0x5f33, 0x5f32, 0x4475, 0x3a2f,
  0x4440, 0x5f4d, 0x4e4b, 0x3627, 0x574f, 0x476e, 0x5526, 0x5f4f,
  0x4458, 0x5f4e, 0x3b3c, 0x4031, 0x4357, 0x5f49, 0x5d65, 0x4d5a,
  0x3d39, 0x4a7d, 0x5045, 0x3471, 0x305f, 0x5454, 0x5d64, 0x5a46,
  0x5d66, 0x5c3d, 0x3f22, 0x353c, 0x375a, 0x5c43, 0x505c, 0x393e,
  0x3b62, 0x4b36, 0x5c5d, 0x3346, 0x5c5c, 0x4228, 0x4375, 0x5630,
  0x5c5f, 0x4069, 0x4e23, 0x432a, 0x5c2b, 0x4d70, 0x4a6a, 0x3f51,
  0x3466, 0x3f27, 0x5420, 0x353d, 0x5369, 0x5332, 0x3128, 0x4679,
  0x4042, 0x3624, 0x363a, 0x3568, 0x5b3f, 0x5131, 0x3b25, 0x4621,
  0x5c58, 0x463c, 0x5c59, 0x4a59, 0x5e6d, 0x4a4d, 0x5c39, 0x4723,
  0x572c, 0x4a2e, 0x3839, 0x4c39, 0x465c, 0x3a60, 0x543b, 0x5e6c,
  0x4369, 0x372a, 0x327f, 0x4871, 0x4477, 0x447a, 0x5534, 0x556c,
  0x5c4a, 0x3653, 0x4468, 0x3e7c, 0x5c45, 0x5020, 0x4b6c, 0x5c44,
  0x5c47, 0x4b4e, 0x3775, 0x3a4a, 0x5c46, 0x5f41, 0x4c28, 0x4b55,
  0x4c73, 0x3643, 0x575b, 0x366b, 0x383d, 0x575c, 0x4f26, 0x3339,
  0x332f, 0x4e68, 0x4c2c, 0x4e51, 0x3569, 0x547d, 0x415c, 0x5f48,
  0x3173, 0x3b57, 0x3d48, 0x3a69, 0x4560, 0x5b3b, 0x5b38, 0x5236,
  0x395d, 0x5154, 0x3445, 0x322e, 0x3b44, 0x4825, 0x5b3e, 0x4e3a,
  0x575f, 0x5c42, 0x563b, 0x3e48, 0x4f33, 0x4833, 0x5b3a, 0x317d,
  0x5b39, 0x5778, 0x3759, 0x3c7a, 0x5b37, 0x3e42, 0x3827, 0x3178,
  0x4921, 0x4776, 0x3e7e, 0x4479, 0x494f, 0x4b7f, 0x5b35, 0x4b48,
  0x464d, 0x5b34, 0x467d, 0x3a70, 0x4552, 0x4941, 0x567a, 0x3340,
  0x5b4c, 0x5b49, 0x337c, 0x3444, 0x325b, 0x3359, 0x3e21, 0x4870,
  0x3b59, 0x4f3c, 0x4279, 0x5225, 0x5b48, 0x4a6f, 0x373e, 0x4a71,
  0x3038, 0x4a4a, 0x3e7d, 0x4a6c, 0x5530, 0x5b4d, 0x3079, 0x3747,
  0x3c6b, 0x5b36, 0x4048, 0x5b31, 0x5b30, 0x5b33, 0x4136, 0x5b32,
  0x5b4f, 0x503c, 0x5b4e, 0x4337, 0x4a55, 0x4055, 0x5b47, 0x5b42,
  0x5251, 0x5b44, 0x5b57, 0x4a3b, 0x3e4a, 0x5b43, 0x5b45, 0x4153,
  0x4d66, 0x3e79, 0x4771, 0x3a5a, 0x5b4b, 0x5b40, 0x4155, 0x512b,
  0x3e40, 0x3a41, 0x5730, 0x3c4d, 0x5269, 0x5b4a, 0x3d33, 0x3b2a,
  0x4571, 0x5b46, 0x5b41, 0x5b5d, 0x5b56, 0x5b68, 0x5b5a, 0x5b5b,
  0x5344, 0x5b6e, 0x5b69, 0x6166, 0x562a, 0x5b5f, 0x3b24, 0x5056,
  0x3b45, 0x5b59, 0x4b41, 0x5b50, 0x5547, 0x5b53, 0x342a, 0x423a,
  0x5b5e, 0x3e68, 0x3252, 0x4956, 0x3d73, 0x5058, 0x5b52, 0x4b61,
  0x3428, 0x5b6a, 0x5b5c, 0x554b, 0x5b58, 0x5b55, 0x5b54, 0x5b51,
  0x3f24, 0x5b6d, 0x5b6c, 0x5b6f, 0x5b6b, 0x5b65, 0x5739, 0x3c6a,
  0x413b, 0x5b67, 0x4d57, 0x4525, 0x4049, 0x3b53, 0x4b75, 0x5151,
  0x5b63, 0x3635, 0x3e52, 0x5b61, 0x5f4c, 0x5569, 0x4f79, 0x3030,
  0x342b, 0x5b7c, 0x484b, 0x5b7f, 0x5b60, 0x5b64, 0x5b66, 0x5b62,
  0x5b7d, 0x3f30, 0x5b7e, 0x5b79, 0x3f2e, 0x4e56, 0x4a25, 0x642a,
  0x3727, 0x642b, 0x642c, 0x5b73, 0x4954, 0x5b71, 0x5b77, 0x3b5d,
  0x5349, 0x4d41, 0x5b75, 0x342c, 0x5b70, 0x5b76, 0x642f, 0x6425,
  0x3345, 0x422c, 0x4d3b, 0x443f, 0x5b78, 0x4133, 0x5c49, 0x5b74,
  0x407b, 0x642e, 0x6429, 0x6428, 0x5428, 0x6439, 0x4869, 0x643c,
  0x3b2b, 0x6422, 0x4a34, 0x6426, 0x4d4b, 0x4423, 0x6423, 0x3e60,
  0x3e3d, 0x6424, 0x5b7b, 0x643e, 0x6435, 0x3020, 0x6434, 0x4b3f,
  0x3e45, 0x643d, 0x5477, 0x6421, 0x5076, 0x5b7a, 0x416a, 0x6420,
  0x577a, 0x643b, 0x643a, 0x6449, 0x546c, 0x6431, 0x6444, 0x6447,
  0x6433, 0x6427, 0x4d29, 0x644c, 0x643f, 0x4e45, 0x644e, 0x6438,
  0x4a46, 0x4f4e, 0x6440, 0x644b, 0x644f, 0x6446, 0x6437, 0x6432,
  0x644d, 0x6448, 0x644a, 0x6445, 0x6441, 0x6436, 0x4f59, 0x6458,
  0x645b, 0x645f, 0x645d, 0x3843, 0x645c, 0x3c4f, 0x5c48, 0x5467,
  0x4662, 0x6442, 0x6430, 0x6459, 0x645e, 0x645a, 0x6451, 0x6455,
  0x527b, 0x373d, 0x5361, 0x4f36, 0x6457, 0x4a76, 0x3e54, 0x646c,
  0x6450, 0x5620, 0x646f, 0x6456, 0x6454, 0x6452, 0x646d, 0x6453,
  0x6469, 0x427a, 0x5c21, 0x5066, 0x646b, 0x4e44, 0x6468, 0x3c4c,
  0x646a, 0x6465, 0x6464, 0x646e, 0x3e32, 0x486a, 0x6467, 0x4b74,
  0x6466, 0x4c4f, 0x394d, 0x405f, 0x6461, 0x6460, 0x4379, 0x4f49,
  0x6463, 0x3f55, 0x5c3b, 0x567f, 0x6462, 0x4948, 0x3257, 0x647c,
  0x503d, 0x442a, 0x305c, 0x4a2a, 0x647d, 0x647f, 0x3d41, 0x3d77,
  0x4931, 0x647e, 0x4259, 0x6479, 0x503f, 0x4c2b, 0x647b, 0x6478,
  0x647a, 0x494c, 0x4e28, 0x5057, 0x5f5a, 0x5f54, 0x5f55, 0x3d6a,
  0x5f51, 0x5f50, 0x3155, 0x5f57, 0x5f56, 0x372c, 0x5f52, 0x3f75,
  0x523a, 0x5f6d, 0x3a74, 0x3336, 0x5f5d, 0x4823, 0x3b3f, 0x3f38,
  0x5375, 0x3b5e, 0x3b64, 0x386c, 0x483e, 0x5f53, 0x345e, 0x4a66,
  0x3355, 0x5334, 0x424f, 0x4429, 0x4834, 0x5f6a, 0x5f6c, 0x4237,
  0x5f6e, 0x5f65, 0x417a, 0x5f67, 0x5f64, 0x3b4d, 0x5f6b, 0x5f68,
  0x3034, 0x4421, 0x462f, 0x5f6f, 0x5f69, 0x5440, 0x5f60, 0x4450,
  0x5f7f, 0x326f, 0x5f7e, 0x5f5f, 0x3d35, 0x5026, 0x5f61, 0x3b5c,
  0x5f7d, 0x5f5c, 0x316b, 0x5f66, 0x3b68, 0x5f63, 0x5f7c, 0x5f74,
  0x3d2c, 0x342e, 0x467c, 0x374a, 0x5f62, 0x5f75, 0x425f, 0x5f79,
  0x5f78, 0x5f7a, 0x5f7b, 0x5f73, 0x577f, 0x3637, 0x5f70, 0x5829,
  0x5f76, 0x5f77, 0x5f71, 0x416d, 0x3f74, 0x582e, 0x5828, 0x484e,
  0x325c, 0x594d, 0x582c, 0x582f, 0x4338, 0x3264, 0x582a, 0x582b,
  0x5824, 0x3529, 0x3141, 0x3b3d, 0x5552, 0x324f, 0x5825, 0x4f77,
  0x6f7e, 0x4f51, 0x4f73, 0x484c, 0x4c76, 0x5827, 0x4863, 0x5826,
  0x5f5e, 0x5822, 0x5821, 0x3a3e, 0x4e76, 0x5820, 0x4d47, 0x4034,
  0x4330, 0x5823, 0x507b, 0x546b, 0x4026, 0x3258, 0x5f59, 0x3557,
  0x5f58, 0x5f5b, 0x3e33, 0x4c4d, 0x4e32, 0x4c44, 0x533e, 0x4d74,
  0x3b4a, 0x3e75, 0x5631, 0x6637, 0x302b, 0x3535, 0x3c39, 0x4b49,
  0x5d6a, 0x4b2b, 0x496f, 0x5d60, 0x326d, 0x5634, 0x3d36, 0x6634,
  0x663a, 0x307e, 0x4861, 0x4826, 0x337f, 0x5c3f, 0x5566, 0x3e36,
  0x4e2a, 0x493a, 0x5649, 0x3b69, 0x385d, 0x326c, 0x5a48, 0x5a4b,
  0x5f31, 0x5554, 0x426b, 0x4043, 0x3363, 0x3351, 0x3b71, 0x536d,
  0x4278, 0x3531, 0x5a45, 0x393c, 0x485a, 0x5a47, 0x5a44, 0x3161,
  0x4d50, 0x344f, 0x4123, 0x4126, 0x4041, 0x3864, 0x4f70, 0x3e4e,
  0x6174, 0x4c6a, 0x6177, 0x4970, 0x533c, 0x3c33, 0x4665, 0x4c5c,
  0x6176, 0x3247, 0x3846, 0x5570, 0x622c, 0x4763, 0x6229, 0x6173,
  0x6228, 0x495a, 0x334c, 0x6171, 0x6170, 0x622e, 0x4050, 0x6225,
  0x622a, 0x474e, 0x4253, 0x6227, 0x403a, 0x622f, 0x4e31, 0x396e,
  0x3d4e, 0x622b, 0x5458, 0x4a22, 0x6224, 0x623d, 0x562b, 0x3927,
  0x6220, 0x6222, 0x445c, 0x5641, 0x382a, 0x623c, 0x567b, 0x5346,
  0x4973, 0x4953, 0x462b, 0x6226, 0x6221, 0x3932, 0x6223, 0x623e,
  0x623f, 0x623b, 0x6235, 0x4062, 0x4045, 0x3a67, 0x4d62, 0x623a,
  0x327d, 0x4769, 0x5764, 0x6239, 0x6238, 0x4c2f, 0x6230, 0x6234,
  0x4248, 0x497c, 0x6236, 0x6231, 0x3f64, 0x6233, 0x6237, 0x443a,
  0x5729, 0x6232, 0x4d79, 0x624e, 0x6249, 0x547b, 0x4730, 0x4749,
  0x624f, 0x624c, 0x624a, 0x4b3c, 0x6f79, 0x6247, 0x6248, 0x3853,
  0x4d24, 0x3838, 0x4b5e, 0x6245, 0x6244, 0x6243, 0x625d, 0x625c,
  0x6246, 0x3158, 0x6241, 0x6242, 0x4056, 0x624b, 0x6240, 0x625f,
  0x6259, 0x625e, 0x6258, 0x5d75, 0x625b, 0x625a, 0x535e, 0x6250,
  0x6253, 0x3b5a, 0x505d, 0x535b, 0x306b, 0x4f62, 0x6257, 0x5c4e,
  0x5343, 0x542f, 0x4742, 0x6252, 0x3833, 0x3d4f, 0x6256, 0x552a,
  0x3e2f, 0x4642, 0x5c26, 0x4e66, 0x6163, 0x6251, 0x3378, 0x4c6b,
  0x4078, 0x613f, 0x4073, 0x4f71, 0x613e, 0x5121, 0x5763, 0x4e55,
  0x343f, 0x4f43, 0x4967, 0x3e67, 0x6138, 0x6139, 0x5357, 0x3d54,
  0x526b, 0x3225, 0x497d, 0x5646, 0x352b, 0x4e38, 0x3765, 0x4d7e,
  0x3b40, 0x5476, 0x4e5f, 0x613b, 0x3f4f, 0x4b51, 0x3d21, 0x505a,
  0x3e2b, 0x556a, 0x4b71, 0x385f, 0x613a, 0x4c50, 0x3b60, 0x357b,
  0x4f53, 0x3848, 0x3849, 0x5677, 0x4751, 0x3b51, 0x3c36, 0x474f,
  0x3e23, 0x502f, 0x4353, 0x4022, 0x3661, 0x3d5c, 0x6136, 0x4545,
  0x5122, 0x6131, 0x6133, 0x306a, 0x3259, 0x4f4f, 0x553d, 0x3131,
  0x4e54, 0x336f, 0x4d69, 0x3926, 0x4a33, 0x537d, 0x542c, 0x4d54,
  0x3276, 0x6255, 0x386f, 0x3733, 0x4d5d, 0x6254, 0x372f, 0x5a41,
  0x5745, 0x5a40, 0x562f, 0x5a43, 0x3a40, 0x5a42, 0x4e21, 0x5671,
  0x3752, 0x6167, 0x406c, 0x3a2c, 0x4a3f, 0x407f, 0x3a5b, 0x4225,
  0x366e, 0x3a5e, 0x4371, 0x4866, 0x3961, 0x4a50, 0x4e37, 0x424c,
  0x6161, 0x5431, 0x5134, 0x6160, 0x4e79, 0x494d, 0x4648, 0x6162,
  0x4649, 0x617d, 0x6175, 0x4940, 0x4d30, 0x5654, 0x6525, 0x5761,
  0x4f67, 0x427c, 0x6521, 0x652a, 0x6524, 0x6527, 0x6522, 0x3660,
  0x6526, 0x3c57, 0x6520, 0x6523, 0x653d, 0x3137, 0x653c, 0x653e,
  0x6535, 0x555f, 0x653b, 0x6538, 0x4566, 0x653a, 0x504d, 0x653f,
  0x6537, 0x343b, 0x6539, 0x3b74, 0x6534, 0x6536, 0x6533, 0x6531,
  0x5248, 0x4b32, 0x6530, 0x6532, 0x4640, 0x3266, 0x5775, 0x4340,
  0x3368, 0x3a73, 0x654d, 0x654c, 0x654a, 0x376a, 0x4264, 0x3053,
  0x554f, 0x6545, 0x654b, 0x6548, 0x654e, 0x654f, 0x354d, 0x5135,
  0x6549, 0x6546, 0x6541, 0x6547, 0x6b77, 0x655e, 0x655f, 0x433b,
  0x6544, 0x6543, 0x655d, 0x6559, 0x655c, 0x6540, 0x6542, 0x6558,
  0x655b, 0x655a, 0x6555, 0x6557, 0x6556, 0x4a2c, 0x6350, 0x3025,
  0x5250, 0x553f, 0x373f, 0x3d29, 0x537e, 0x4344, 0x3a53, 0x3d23,
  0x4a5a, 0x3663, 0x5f42, 0x3837, 0x565c, 0x4f45, 0x3440, 0x4b62,
  0x5d6e, 0x3960, 0x355f, 0x4e5d, 0x3631, 0x4f2a, 0x3326, 0x4e2b,
  0x4b2e, 0x6475, 0x5147, 0x6476, 0x6477, 0x414c, 0x4876, 0x453c,
  0x6474, 0x526e, 0x3622, 0x5249, 0x3156, 0x3075, 0x522c, 0x4b22,
  0x3462, 0x6471, 0x652c, 0x372e, 0x6470, 0x6473, 0x473c, 0x4750,
  0x652f, 0x3374, 0x3f42, 0x652e, 0x4036, 0x6529, 0x6528, 0x652b,
  0x303c, 0x3c44, 0x4230, 0x4067, 0x362f, 0x545f, 0x6356, 0x3f4e,
  0x575a, 0x5749, 0x3d6e, 0x6642, 0x5322, 0x4361, 0x355e, 0x303f,
  0x665c, 0x547f, 0x4623, 0x665d, 0x3b6f, 0x572b, 0x315a, 0x665f,
  0x3167, 0x4760, 0x3c70, 0x3c23, 0x415e, 0x3342, 0x6659, 0x665e,
  0x3245, 0x5374, 0x4928, 0x6655, 0x665b, 0x4e71, 0x3b38, 0x5734,
  0x6658, 0x665a, 0x4523, 0x4445, 0x6656, 0x6657, 0x4427, 0x4543,
  0x6651, 0x6650, 0x6653, 0x5f45, 0x555e, 0x492f, 0x3925, 0x5a4e,
  0x5c28, 0x3b27, 0x5f40, 0x5661, 0x4277, 0x4127, 0x5a49, 0x355a,
  0x5b23, 0x4e30, 0x5b3c, 0x3d20, 0x5670, 0x3c28, 0x3e66, 0x3757,
  0x3151, 0x5148, 0x475b, 0x4b5f, 0x3f2c, 0x617e, 0x617f, 0x6179,
  0x4969, 0x4c78, 0x3122, 0x4332, 0x617b, 0x683d, 0x616b, 0x3d64,
  0x313c, 0x4631, 0x6165, 0x616a, 0x6164, 0x5640, 0x6567, 0x5443,
  0x4923, 0x5568, 0x3647, 0x3566, 0x357f, 0x4160, 0x514e, 0x573d,
  0x6551, 0x6550, 0x5656, 0x3734, 0x3546, 0x4974, 0x517a, 0x6553,
  0x3a3b, 0x3070, 0x6552, 0x3e51, 0x656d, 0x3f3f, 0x4644, 0x656c,
  0x5461, 0x4930, 0x656f, 0x314e, 0x414a, 0x656e, 0x6569, 0x5774,
  0x6568, 0x5520, 0x656b, 0x4a2f, 0x656a, 0x314f, 0x6565, 0x3f58,
  0x5449, 0x666d, 0x3555, 0x5669, 0x666c, 0x3844, 0x4c41, 0x666e,
  0x6873, 0x6870, 0x5b22, 0x666f, 0x5233, 0x4971, 0x472b, 0x674e,
  0x525f, 0x666a, 0x6665, 0x574a, 0x6661, 0x3b61, 0x6660, 0x6668,
  0x374d, 0x4063, 0x6663, 0x544e, 0x3e7b, 0x6664, 0x3353, 0x3f3e,
  0x4821, 0x4f46, 0x6669, 0x666b, 0x6667, 0x6666, 0x667a, 0x6679,
  0x5078, 0x667e, 0x4120, 0x5177, 0x414f, 0x364d, 0x6662, 0x667f,
  0x4522, 0x4f31, 0x312c, 0x6674, 0x383c, 0x667c, 0x5459, 0x5034,
  0x6678, 0x3d5b, 0x667b, 0x435e, 0x667d, 0x5351, 0x692c, 0x6675,
  0x6928, 0x6673, 0x4e5c, 0x4538, 0x3f5d, 0x3b5b, 0x3e6e, 0x4f2c,
  0x692b, 0x692e, 0x692f, 0x3f5b, 0x692a, 0x5479, 0x6929, 0x3e53,
  0x327a, 0x672c, 0x323f, 0x487c, 0x3d2a, 0x4b2f, 0x432c, 0x3b5f,
  0x327c, 0x6677, 0x6676, 0x6670, 0x6671, 0x4058, 0x672f, 0x574c,
  0x672a, 0x4349, 0x4b29, 0x6724, 0x3e3a, 0x6725, 0x3f57, 0x672e,
  0x6729, 0x6727, 0x672b, 0x4a7f, 0x574b, 0x3f31, 0x504e, 0x4077,
  0x6925, 0x5471, 0x6728, 0x4778, 0x6720, 0x3522, 0x673f, 0x384f,
  0x6721, 0x3132, 0x4364, 0x673d, 0x3a27, 0x4962, 0x3f7e, 0x4865,
  0x6722, 0x673c, 0x4b2a, 0x6723, 0x4a24, 0x3f50, 0x3166, 0x3a68,
  0x365f, 0x3740, 0x3534, 0x6726, 0x365c, 0x3121, 0x3d52, 0x3265,
  0x4b66, 0x673a, 0x3f41, 0x4c4a, 0x5447, 0x6735, 0x3763, 0x6924,
  0x5777, 0x5769, 0x6927, 0x6734, 0x566f, 0x6738, 0x5753, 0x3c5d,
  0x673e, 0x673b, 0x3352, 0x6739, 0x442f, 0x6737, 0x5035, 0x3045,
  0x6736, 0x3f48, 0x4d7a, 0x4d68, 0x4030, 0x6926, 0x4670, 0x3f56,
  0x3b23, 0x4a32, 0x6731, 0x3b3b, 0x3562, 0x507a, 0x6733, 0x6920,
  0x6732, 0x3e24, 0x6921, 0x6730, 0x674d, 0x3e3b, 0x3223, 0x5435,
  0x344e, 0x6923, 0x6922, 0x444c, 0x674c, 0x413e, 0x674f, 0x583f,
  0x693d, 0x3c67, 0x4a61, 0x6e2a, 0x546a, 0x4e74, 0x4c5b, 0x4b3a,
  0x3744, 0x4a5f, 0x3969, 0x6753, 0x3f7f, 0x6e25, 0x5130, 0x4250,
  0x6e24, 0x6e27, 0x6e21, 0x6e26, 0x6e23, 0x6e20, 0x3955, 0x6e22,
  0x4633, 0x304c, 0x307a, 0x3f2a, 0x686b, 0x6868, 0x3332, 0x4f74,
  0x356f, 0x686a, 0x4d45, 0x6865, 0x6864, 0x4e5b, 0x5a5d, 0x3648,
  0x5077, 0x4246, 0x344a, 0x307f, 0x4c5e, 0x495d, 0x3b35, 0x3b56,
  0x4329, 0x5239, 0x4424, 0x5a5c, 0x4d25, 0x5562, 0x4129, 0x346a,
  0x373b, 0x4c48, 0x346f, 0x337b, 0x4177, 0x327e, 0x515f, 0x375d,
  0x3831, 0x3720, 0x3a7c, 0x345c, 0x565b, 0x4e6e, 0x5328, 0x493b,
  0x323b, 0x3b34, 0x5156, 0x3c2a, 0x415a, 0x5a5f, 0x3b54, 0x4658,
  0x434d, 0x3f29, 0x3525, 0x4167, 0x4176, 0x482a, 0x352a, 0x315b,
  0x4025, 0x5a5e, 0x5537, 0x3764, 0x477f, 0x337a, 0x5279, 0x312e,
  0x367d, 0x4039, 0x4064, 0x4420, 0x5a59, 0x3465, 0x4149, 0x456d,
  0x3d58, 0x3a51, 0x4955, 0x3443, 0x4942, 0x5a5b, 0x3a5d, 0x5333,
  0x5a58, 0x515d, 0x3450, 0x406f, 0x462e, 0x387d, 0x5738, 0x4434,
  0x412c, 0x362b, 0x507c, 0x4425, 0x4e4e, 0x5a5a, 0x5171, 0x3d3d,
  0x4c20, 0x4f24, 0x5a54, 0x3b30, 0x4239, 0x532a, 0x4e3d, 0x404e,
  0x375b, 0x3d5f, 0x5235, 0x6e71, 0x3439, 0x3b6b, 0x4879, 0x4957,
  0x5232, 0x4643, 0x4a43, 0x482f, 0x5423, 0x405e, 0x313f, 0x5a55,
  0x5178, 0x383a, 0x3f5e, 0x3429, 0x413f, 0x3061, 0x517c, 0x6e70,
  0x5a57, 0x492b, 0x4961, 0x4a6b, 0x5a51, 0x493c, 0x442b, 0x5330,
  0x5a56, 0x344b, 0x3e39, 0x4d5e, 0x407e, 0x3a65, 0x363b, 0x4441,
  0x4f7d, 0x387c, 0x3f36, 0x313a, 0x4178, 0x5a6b, 0x5a6e, 0x3a50,
  0x5a52, 0x303a, 0x3950, 0x5a6d, 0x4060, 0x4b4b, 0x316d, 0x3253,
  0x4e57, 0x3179, 0x5a68, 0x514b, 0x5a6c, 0x4840, 0x4273, 0x4148,
  0x5639, 0x3a7f, 0x465e, 0x4830, 0x3735, 0x395e, 0x3b55, 0x494b,
  0x5557, 0x3066, 0x5a69, 0x5a50, 0x5a6a, 0x6e73, 0x463d, 0x5a6f,
  0x524d, 0x312a, 0x3679, 0x5a65, 0x5a7f, 0x5a60, 0x5a7c, 0x4c6d,
  0x536c, 0x5a62, 0x4765, 0x486c, 0x3668, 0x5633, 0x5a63, 0x5a66,
  0x4a58, 0x302a, 0x3b26, 0x3a33, 0x395f, 0x5a64, 0x5023, 0x5a53,
  0x5a67, 0x4432, 0x5a61, 0x367e, 0x3c64, 0x462a, 0x394c, 0x5a78,
  0x5a75, 0x3626, 0x3029, 0x3067, 0x4d2b, 0x5a7b, 0x4f5c, 0x3c6e,
  0x5a7a, 0x5a77, 0x5a74, 0x484f, 0x346c, 0x3063, 0x6137, 0x5422,
  0x3666, 0x6f2c, 0x5a79, 0x4d6e, 0x5a7e, 0x3457, 0x562c, 0x357a,
  0x4822, 0x5a7d, 0x4f29, 0x5127, 0x5a76, 0x3050, 0x402b, 0x5a70,
  0x4773, 0x402c, 0x5b2c, 0x4541, 0x5a71, 0x3a62, 0x423f, 0x3748,
  0x4c7b, 0x4f37, 0x5a73, 0x5b29, 0x533f, 0x373a, 0x454e, 0x4346,
  0x3628, 0x3064, 0x5326, 0x4061, 0x5b2f, 0x5b2e, 0x5b28, 0x3e3e,
  0x5b2b, 0x4453, 0x4d4e, 0x3654, 0x436b, 0x5b2a, 0x4351, 0x5b25,
  0x6f2f, 0x4f5e, 0x5b27, 0x5b24, 0x364c, 0x4147, 0x5b26, 0x5051,
  0x4c4c, 0x5b21, 0x3a7d, 0x5b20, 0x522a, 0x6e3a, 0x6f3b, 0x4e58,
  0x5c71, 0x3c49, 0x3d28, 0x3348, 0x5173, 0x3d47, 0x542a, 0x7040,
  0x315d, 0x4779, 0x3a45, 0x6f3a, 0x3430, 0x3941, 0x453f, 0x355b,
  0x3725, 0x3c5f, 0x4d2f, 0x3255, 0x6f35, 0x3a39, 0x4e70, 0x434e,
  0x5176, 0x337e, 0x4a49, 0x5126, 0x357e, 0x683e, 0x3452, 0x6838,
  0x323a, 0x4542, 0x7177, 0x543c, 0x5168, 0x4a5e, 0x3962, 0x376f,
  0x3c26, 0x513b, 0x6930, 0x3242, 0x4f34, 0x544f, 0x3330, 0x683b,
  0x4e24, 0x4159, 0x6834, 0x6835, 0x464e, 0x683a, 0x5470, 0x6837,
  0x6836, 0x5368, 0x6831, 0x6830, 0x4261, 0x4a53, 0x3845, 0x4c58,
  0x3124, 0x3a44, 0x5231, 0x506a, 0x5523, 0x547c, 0x6e35, 0x6e34,
  0x6e37, 0x3e38, 0x4e3c, 0x3b78, 0x4977, 0x6e4d, 0x3437, 0x6e33,
  0x4428, 0x6e36, 0x3670, 0x477a, 0x3f65, 0x565a, 0x4a79, 0x6e32,
  0x6e31, 0x6e4e, 0x544a, 0x573e, 0x3037, 0x474c, 0x537f, 0x515c,
  0x4e4a, 0x6e48, 0x6e49, 0x6e4a, 0x6e4b, 0x526a, 0x4b59, 0x6e46,
  0x3f43, 0x3977, 0x4d43, 0x6e41, 0x4d34, 0x4b73, 0x6e47, 0x5043,
  0x6e40, 0x6e42, 0x4960, 0x6e44, 0x6e43, 0x4a63, 0x3f53, 0x3732,
  0x4258, 0x3a3d, 0x4a77, 0x436a, 0x3a2a, 0x6e5d, 0x524a, 0x454d,
  0x5050, 0x6e5c, 0x4b33, 0x6e5f, 0x4e63, 0x4122, 0x3438, 0x6e59,
  0x6e5e, 0x7052, 0x4037, 0x3524, 0x6152, 0x6e58, 0x4e62, 0x6e5b,
  0x6e5a, 0x4255, 0x6e55, 0x6e54, 0x5036, 0x4377, 0x563a, 0x3c71,
  0x6e4f, 0x3651, 0x4671, 0x5075, 0x486b, 0x5363, 0x504f, 0x575d,
  0x6f4e, 0x417e, 0x3373, 0x6f59, 0x4f3a, 0x6f53, 0x4447, 0x4976,
  0x3722, 0x4257, 0x6f71, 0x4033, 0x4a39, 0x4024, 0x3533, 0x5070,
  0x4e78, 0x5261, 0x425e, 0x3269, 0x3f77, 0x546d, 0x4d3c, 0x505e,
  0x4c25, 0x3c46, 0x6c33, 0x4d31, 0x6c36, 0x4463, 0x545e, 0x3649,
  0x3068, 0x6c31, 0x5145, 0x3248, 0x6c30, 0x4e75, 0x3c51, 0x4878,
  0x4439, 0x5563, 0x6c32, 0x6c4f, 0x3e31, 0x3520, 0x3951, 0x6e30,
  0x6c4e, 0x6c4b, 0x6c46, 0x6c41, 0x4f44, 0x3468, 0x3826, 0x3d34,
  0x6c4c, 0x497a, 0x6c47, 0x4a7b, 0x5160, 0x455b, 0x6c49, 0x473b,
  0x3d76, 0x522b, 0x6c45, 0x4e6d, 0x506b, 0x6c4d, 0x6c48, 0x6c4a,
  0x4334, 0x336e, 0x6c44, 0x3b50, 0x6c5f, 0x6c5a, 0x6c58, 0x3851,
  0x3842, 0x6c56, 0x6c53, 0x6c57, 0x3577, 0x3455, 0x403e, 0x3c41,
  0x426f, 0x4c33, 0x4c6c, 0x6c42, 0x6c59, 0x6c5b, 0x3d7c, 0x6c55,
  0x5378, 0x4076, 0x6c51, 0x3664, 0x6c5c, 0x3860, 0x3b4f, 0x6c40,
  0x5274, 0x4575, 0x367c, 0x6c52, 0x4e4c, 0x6c54, 0x5129, 0x3567,
  0x5136, 0x6c43, 0x6c5d, 0x323d, 0x6c5e, 0x6c50, 0x4435, 0x4e7a,
  0x4f25, 0x4251, 0x4478, 0x6c64, 0x542e, 0x6c7f, 0x5267, 0x6c6d,
  0x6c6c, 0x5574, 0x3e46, 0x3c74, 0x3c7c, 0x5059, 0x6c62, 0x6c63,
  0x6c61, 0x3d7d, 0x485f, 0x6c6b, 0x4a2b, 0x3b7f, 0x3435, 0x6c7c,
  0x6c7d, 0x534d, 0x6c69, 0x4924, 0x4d2e, 0x3f35, 0x3956, 0x6c67,
  0x6c6f, 0x6c6e, 0x6c68, 0x3138, 0x6c6a, 0x4348, 0x6c66, 0x6c60,
  0x393d, 0x5323, 0x6c75, 0x6c78, 0x493d, 0x6c7b, 0x4537, 0x6c65,
  0x473a, 0x347d, 0x6c79, 0x6c7a, 0x3d2e, 0x4d5f, 0x4743, 0x4a6d,
  0x446b, 0x4f7e, 0x4850, 0x5438, 0x4e6c, 0x6c7e, 0x3861, 0x6c74,
  0x4753, 0x4268, 0x3d7a, 0x3479, 0x5355, 0x3821, 0x4162, 0x4849,
  0x6d2b, 0x4d20, 0x6d2f, 0x446f, 0x3b4e, 0x6c73, 0x3d5a, 0x6c76,
  0x6d29, 0x5643, 0x6d2e, 0x523f, 0x5338, 0x6d2a, 0x393a, 0x6c71,
  0x6c70, 0x6d2c, 0x495b, 0x5621, 0x6d3f, 0x6d24, 0x3027, 0x3036,
  0x6d26, 0x5425, 0x6d28, 0x3773, 0x6d21, 0x446e, 0x6d27, 0x6d34,
  0x6d35, 0x6d23, 0x6c77, 0x6d25, 0x3b21, 0x6d3c, 0x6d37, 0x4628,
  0x6d22, 0x3c48, 0x6d20, 0x5751, 0x6d39, 0x6d38, 0x6d3a, 0x6d4a,
  0x444b, 0x6d48, 0x6d3d, 0x6d36, 0x347c, 0x6d31, 0x5128, 0x6d33,
  0x6d32, 0x6d4c, 0x457c, 0x4c3b, 0x6d30, 0x6d4f, 0x6d4e, 0x6d3e,
  0x6d3b, 0x3f3c, 0x6d4d, 0x387a, 0x6d49, 0x6d4b, 0x6d47, 0x6d43,
  0x3656, 0x6d45, 0x3323, 0x6d46, 0x6d41, 0x514c, 0x402e, 0x6d55,
  0x3e6c, 0x6d44, 0x572e, 0x6d59, 0x6d5a, 0x6d5d, 0x6d42, 0x434c,
  0x6d5f, 0x6d54, 0x3745, 0x6d5e, 0x4b7d, 0x6d40, 0x377a, 0x6d5b,
  0x6d57, 0x4839, 0x4b20, 0x6d58, 0x6d51, 0x6d56, 0x6d53, 0x6d5c,
  0x6d50, 0x6d52, 0x4747, 0x433a, 0x3043, 0x3f3b, 0x544d, 0x682e,
  0x413a, 0x5776, 0x6829, 0x6828, 0x4256, 0x3b63, 0x682b, 0x682a,
  0x5427, 0x4335, 0x3c65, 0x6825, 0x5234, 0x5170, 0x3046, 0x3630,
  0x4a69, 0x426a, 0x496c, 0x3078, 0x4f4d, 0x3852, 0x6d6f, 0x6d6e,
  0x5567, 0x6d68, 0x3074, 0x6d69, 0x553e, 0x4e6f, 0x365d, 0x6d65,
  0x6d6b, 0x6d6a, 0x523e, 0x6d64, 0x6d67, 0x6d66, 0x6d61, 0x6822,
  0x4134, 0x3243, 0x567e, 0x3163, 0x3f54, 0x683c, 0x566e, 0x4a6e,
  0x4035, 0x4732, 0x3233, 0x5c34, 0x3545, 0x3542, 0x355c, 0x4173,
  0x355d, 0x4726, 0x513c, 0x6f29, 0x3e4c, 0x4837, 0x6f28, 0x6f2a,
  0x6f25, 0x6f2b, 0x6f24, 0x6f26, 0x6f27, 0x6f21, 0x4e42, 0x5c38,
  0x477c, 0x4728, 0x4275, 0x6f20, 0x4047, 0x6f23, 0x6f22, 0x6f3d,
  0x3358, 0x3377, 0x6f3c, 0x436f, 0x6f3e, 0x3e29, 0x5578, 0x343c,
  0x6f3f, 0x6f39, 0x3127, 0x4645, 0x4365, 0x6f38, 0x4f23, 0x6752,
  0x574d, 0x5d56, 0x492c, 0x5220, 0x437e, 0x5d6d, 0x3f6e, 0x3e37,
  0x676f, 0x4b26, 0x676d, 0x4d4a, 0x3e34, 0x5539, 0x676c, 0x4c67,
  0x3d22, 0x3920, 0x3755, 0x4a56, 0x484d, 0x6765, 0x6764, 0x4979,
  0x4820, 0x383e, 0x6767, 0x6766, 0x5457, 0x4276, 0x3357, 0x4352,
  0x5647, 0x4a5b, 0x6769, 0x6761, 0x4d7f, 0x374c, 0x676a, 0x426e,
  0x6768, 0x693e, 0x676b, 0x4d3e, 0x416b, 0x3d38, 0x4736, 0x676e,
  0x4130, 0x4529, 0x4654, 0x365a, 0x6760, 0x3f2b, 0x4020, 0x677d,
  0x3a57, 0x6776, 0x6778, 0x3e5e, 0x335d, 0x5740, 0x5243, 0x515e,
  0x3d4c, 0x5139, 0x5555, 0x5434, 0x437b, 0x4c27, 0x3639, 0x4757,
  0x6763, 0x6771, 0x6762, 0x3325, 0x677a, 0x6779, 0x3337, 0x412f,
  0x677b, 0x4150, 0x3625, 0x4271, 0x406d, 0x532f, 0x446c, 0x6774,
  0x6777, 0x6770, 0x4824, 0x677e, 0x5733, 0x354e, 0x6939, 0x677c,
  0x677f, 0x6775, 0x5437, 0x424e, 0x507e, 0x6773, 0x396d, 0x602a,
  0x602b, 0x557e, 0x602e, 0x6024, 0x4c7a, 0x4b39, 0x6025, 0x6023,
  0x4668, 0x3239, 0x397f, 0x602f, 0x3e64, 0x6027, 0x6021, 0x3270,
  0x5253, 0x603f, 0x6020, 0x602c, 0x3f63, 0x4950, 0x432f, 0x4144,
  0x457a, 0x6029, 0x433e, 0x3921, 0x3930, 0x6028, 0x534a, 0x366f,
  0x6026, 0x384e, 0x6022, 0x3f66, 0x603d, 0x4125, 0x603c, 0x516e,
  0x3b2e, 0x6037, 0x603a, 0x6036, 0x6030, 0x425b, 0x3e4b, 0x4446,
  0x3c2c, 0x6039, 0x502c, 0x3e2e, 0x3973, 0x6031, 0x4932, 0x4074,
  0x4b76, 0x4d6b, 0x5732, 0x4b5c, 0x603e, 0x6035, 0x6034, 0x4864,
  0x4843, 0x4459, 0x6038, 0x453d, 0x603b, 0x4a5d, 0x3f4c, 0x315e,
  0x4c7e, 0x392a, 0x514a, 0x4d21, 0x3c2f, 0x6047, 0x6041, 0x5549,
  0x5637, 0x3e20, 0x3e59, 0x604e, 0x3160, 0x5340, 0x604d, 0x4b70,
  0x6032, 0x4551, 0x4847, 0x4e6a, 0x405a, 0x4859, 0x6045, 0x604a,
  0x604c, 0x6049, 0x3120, 0x5754, 0x604b, 0x5674, 0x306e, 0x3f39,
  0x4d63, 0x3033, 0x3f61, 0x5540, 0x4860, 0x6938, 0x4368, 0x5025,
  0x6046, 0x5358, 0x604f, 0x3928, 0x6048, 0x576b, 0x6044, 0x4d75,
  0x6033, 0x5768, 0x4373, 0x3244, 0x5071, 0x363e, 0x605a, 0x4a4f,
  0x6040, 0x4a31, 0x3c56, 0x605b, 0x3b47, 0x5743, 0x4761, 0x4145,
  0x6055, 0x4949, 0x6042, 0x6059, 0x6058, 0x3e73, 0x4b6b, 0x5132,
  0x605f, 0x605d, 0x6043, 0x4968, 0x4e27, 0x442e, 0x392b, 0x605e,
  0x3c45, 0x606a, 0x5039, 0x6056, 0x4562, 0x6064, 0x566a, 0x6052,
  0x606d, 0x4b27, 0x4f50, 0x6057, 0x605c, 0x6068, 0x4c51, 0x606e,
  0x406a, 0x606f, 0x606c, 0x3771, 0x6065, 0x316c, 0x5341, 0x606b,
  0x3f21, 0x535f, 0x4842, 0x6f75, 0x6069, 0x3d7b, 0x5240, 0x6054,
  0x6051, 0x4677, 0x6053, 0x4646, 0x4449, 0x465d, 0x3578, 0x483f,
  0x3143, 0x6062, 0x4222, 0x426c, 0x6078, 0x4624, 0x4461, 0x5550,
  0x6063, 0x4023, 0x6060, 0x607b, 0x6079, 0x4673, 0x6050, 0x607d,
  0x4e73, 0x5149, 0x607c, 0x5577, 0x6066, 0x6061, 0x607f, 0x4a26,
  0x4146, 0x433c, 0x4637, 0x6067, 0x4547, 0x483b, 0x373c, 0x6076,
  0x607e, 0x6077, 0x6070, 0x6071, 0x3743, 0x3737, 0x607a, 0x6074,
  0x6075, 0x4161, 0x4430, 0x5065, 0x612f, 0x3449, 0x6129, 0x612e,
  0x3829, 0x6128, 0x612c, 0x6073, 0x3579, 0x6125, 0x6124, 0x612b,
  0x612a, 0x6127, 0x4254, 0x6126, 0x6120, 0x6121, 0x6122, 0x6123,
  0x3d6d, 0x613d, 0x613c, 0x3f7d, 0x686c, 0x477d, 0x314b, 0x3f5f,
  0x4564, 0x5063, 0x3a49, 0x534b, 0x505b, 0x365e, 0x6833, 0x6e4c,
  0x4622, 0x303b, 0x555a, 0x3739, 0x4c3f, 0x3b36, 0x684d, 0x5246,
  0x6832, 0x684c, 0x6848, 0x3a6b, 0x4832, 0x4157, 0x3a31, 0x684b,
  0x3573, 0x6849, 0x5125, 0x316e, 0x684f, 0x453b, 0x376e, 0x684e,
  0x4f35, 0x444e, 0x4873, 0x455f, 0x6845, 0x3e6b, 0x445e, 0x527f,
  0x5541, 0x3b33, 0x333e, 0x4d58, 0x684a, 0x3f6f, 0x4841, 0x3970,
  0x4c45, 0x4b24, 0x4964, 0x4166, 0x3364, 0x5544, 0x3e35, 0x6844,
  0x6847, 0x3f4d, 0x6846, 0x686f, 0x3537, 0x3354, 0x3934, 0x6841,
  0x556b, 0x6840, 0x4c36, 0x685c, 0x685e, 0x3f40, 0x3868, 0x6842,
  0x4d3a, 0x4737, 0x686e, 0x5158, 0x685d, 0x527e, 0x685f, 0x6843,
  0x6859, 0x6858, 0x4d32, 0x4b25, 0x5451, 0x5521, 0x4c56, 0x685b,
  0x4a78, 0x4e61, 0x6857, 0x6854, 0x3433, 0x685a, 0x6855, 0x6869,
  0x4c31, 0x454a, 0x6851, 0x556d, 0x6856, 0x5062, 0x6850, 0x5f4b,
  0x6853, 0x3521, 0x6852, 0x686d, 0x532b, 0x414d, 0x6f31, 0x3423,
  0x3a79, 0x3c35, 0x5622, 0x345b, 0x3174, 0x5c3e, 0x4f21, 0x6750,
  0x4221, 0x346b, 0x414b, 0x6f34, 0x6f37, 0x6f36, 0x554d, 0x412e,
  0x6e7f, 0x403f, 0x4038, 0x4443, 0x6e7e, 0x404c, 0x4a62, 0x6e7d,
  0x6e79, 0x4d71, 0x432e, 0x4855, 0x4a73, 0x6e78, 0x6e7b, 0x4b21,
  0x446a, 0x6e7a, 0x3232, 0x6e75, 0x6e74, 0x6e77, 0x6e76, 0x6e7c,
  0x4c23, 0x6566, 0x3335, 0x6561, 0x6560, 0x5339, 0x6563, 0x6562,
  0x5741, 0x657c, 0x3b7c, 0x657d, 0x315f, 0x353a, 0x657e, 0x657f,
  0x3e71, 0x6579, 0x3d3a, 0x3a5c, 0x4071, 0x3e50, 0x394b, 0x6578,
  0x657a, 0x324d, 0x4b4c, 0x4e25, 0x657b, 0x5175, 0x5771, 0x6575,
  0x6571, 0x6574, 0x6577, 0x4467, 0x6573, 0x662c, 0x444a, 0x6576,
  0x6570, 0x6628, 0x4559, 0x662e, 0x6625, 0x3673, 0x662f, 0x4740,
  0x364f, 0x662a, 0x662b, 0x6629, 0x6624, 0x6626, 0x5444, 0x5260,
  0x4725, 0x6621, 0x4b5a, 0x6623, 0x3e62, 0x6d6d, 0x6620, 0x6627,
  0x3f26, 0x503e, 0x663d, 0x6622, 0x6d6c, 0x663c, 0x663f, 0x663e,
  0x482c, 0x6639, 0x6638, 0x5473, 0x4647, 0x577c, 0x4978, 0x636d,
  0x636c, 0x3a4c, 0x4667, 0x6369, 0x636e, 0x496b, 0x4738, 0x636f,
  0x3f3a, 0x4b5b, 0x456c, 0x6364, 0x6365, 0x6379, 0x362e, 0x6367,
  0x636b, 0x6361, 0x6366, 0x4d37, 0x5169, 0x6368, 0x3324, 0x636a,
  0x6363, 0x637e, 0x5264, 0x6360, 0x637f, 0x637c, 0x346d, 0x6378,
  0x437f, 0x4448, 0x4460, 0x457d, 0x637d, 0x637b, 0x4f7b, 0x6c2f,
  0x6c2c, 0x534c, 0x6377, 0x6374, 0x6376, 0x637a, 0x6373, 0x6370,
  0x6371, 0x4558, 0x4354, 0x4170, 0x414e, 0x4360, 0x6c2e, 0x6c2b,
  0x6c28, 0x6c2a, 0x3e7a, 0x6375, 0x6c29, 0x4c7d, 0x4d27, 0x6c24,
  0x3d68, 0x5573, 0x6c25, 0x6c27, 0x6c20, 0x6c23, 0x452a, 0x6c22,
  0x6c3d, 0x6c21, 0x6c39, 0x6c26, 0x6c3c, 0x6c38, 0x6c3f, 0x6c3e,
  0x6c3a, 0x6c3b, 0x3d42, 0x7421, 0x7420, 0x423d, 0x3467, 0x4c32,
  0x4952, 0x4a40, 0x6e3c, 0x6e3f, 0x4232, 0x3044, 0x6e3e, 0x516a,
  0x5974, 0x6e39, 0x6e38, 0x6e3b, 0x3c47, 0x5b3d, 0x4d78, 0x487d,
  0x4d77, 0x4d76, 0x574e, 0x4f2b, 0x3c2b, 0x7423, 0x354f, 0x6135,
  0x4862, 0x5744, 0x385a, 0x4d67, 0x316a, 0x405d, 0x3164, 0x6a23,
  0x3f20, 0x6353, 0x6a22, 0x3724, 0x6a3f, 0x6a3c, 0x396a, 0x6a3d,
  0x4a3a, 0x4142, 0x4579, 0x5f43, 0x6a3e, 0x547e, 0x4659, 0x4265,
  0x3321, 0x6a39, 0x3766, 0x3f76, 0x6a38, 0x6351, 0x6a3b, 0x3923,
  0x756f, 0x4e65, 0x5644, 0x7457, 0x7456, 0x7451, 0x454b, 0x3c60,
  0x3a43, 0x7453, 0x413c, 0x7450, 0x557c, 0x746d, 0x3441, 0x3967,
  0x5652, 0x7452, 0x3022, 0x3365, 0x746b, 0x7468, 0x422e, 0x746c,
  0x746f, 0x304e, 0x746e, 0x5163, 0x4856, 0x3a5f, 0x383f, 0x7465,
  0x746a, 0x7469, 0x362c, 0x522f, 0x5735, 0x3a3a, 0x4c21, 0x7467,
  0x557a, 0x5241, 0x3e56, 0x7464, 0x3236, 0x4939, 0x422b, 0x452c,
  0x7466, 0x7463, 0x7460, 0x747d, 0x7461, 0x3f33, 0x7462, 0x4838,
  0x747f, 0x3758, 0x3559, 0x747e, 0x7479, 0x747b, 0x306c, 0x747c,
  0x747a, 0x7477, 0x7475, 0x7478, 0x7470, 0x7474, 0x7471, 0x7473,
  0x752c, 0x4a4c, 0x7529, 0x752e, 0x457b, 0x7476, 0x4e50, 0x307c,
  0x357c, 0x483c, 0x752b, 0x752a, 0x7521, 0x5143, 0x7524, 0x4c3e,
  0x752f, 0x7526, 0x7525, 0x7528, 0x7527, 0x3424, 0x7520, 0x7522,
  0x753c, 0x753d, 0x7523, 0x552f, 0x753f, 0x753e, 0x3d62, 0x314a,
  0x345a, 0x3454, 0x5060, 0x3149, 0x3959, 0x3f47, 0x742a, 0x3c53,
  0x7425, 0x3425, 0x7424, 0x4963, 0x7427, 0x7426, 0x4229, 0x5268,
  0x7569, 0x7568, 0x477e, 0x5756, 0x525c, 0x4165, 0x5722, 0x566b,
  0x6a4c, 0x3436, 0x5138, 0x5543, 0x386d, 0x3e5d, 0x3b75, 0x3c4a,
  0x314c, 0x4141, 0x4e2f, 0x4746, 0x6a4f, 0x4032, 0x322f, 0x6961,
  0x4729, 0x523c, 0x4b6d, 0x6962, 0x4143, 0x3251, 0x4e2c, 0x6960,
  0x697d, 0x697c, 0x4731, 0x3b39, 0x6963, 0x6979, 0x697f, 0x516b,
  0x4752, 0x697e, 0x697b, 0x512e, 0x552e, 0x6978, 0x475d, 0x697a,
  0x3b79, 0x3a61, 0x6975, 0x487a, 0x5556, 0x5348, 0x517b, 0x6971,
  0x6976, 0x6974, 0x6977, 0x6970, 0x3a2b, 0x4f22, 0x6a2c, 0x3230,
  0x6a2f, 0x404d, 0x6973, 0x3953, 0x364a, 0x324e, 0x6a28, 0x5c37,
  0x6a2e, 0x6a2b, 0x4764, 0x377f, 0x6a2a, 0x6a29, 0x4b34, 0x6a25,
  0x467a, 0x6a24, 0x6a27, 0x5a26, 0x423e, 0x434b, 0x5278, 0x3144,
  0x4f3f, 0x6a26, 0x4926, 0x6a21, 0x513d, 0x6a20, 0x7249, 0x5f4a,
  0x302e, 0x4721, 0x756b, 0x4e35, 0x565e, 0x5227, 0x6b7f, 0x3a55,
  0x394e, 0x6b7e, 0x3241, 0x3426, 0x4e22, 0x693b, 0x693a, 0x4a74,
  0x3322, 0x3b7e, 0x6935, 0x4666, 0x4d3d, 0x6934, 0x427b, 0x3b3e,
  0x6931, 0x4175, 0x555d, 0x5324, 0x6937, 0x6936, 0x556f, 0x6932,
  0x694d, 0x6949, 0x6945, 0x694b, 0x6943, 0x5165, 0x6944, 0x694a,
  0x6933, 0x4164, 0x424b, 0x4d64, 0x505f, 0x694c, 0x694f, 0x694e,
  0x6948, 0x4474, 0x302c, 0x3d65, 0x695d, 0x695c, 0x6947, 0x6942,
  0x4a75, 0x4f3b, 0x6941, 0x6940, 0x4b78, 0x695f, 0x457f, 0x573f,
  0x6946, 0x4c3a, 0x3862, 0x417d, 0x695b, 0x3162, 0x4638, 0x3420,
  0x4f64, 0x3523, 0x6959, 0x4966, 0x316f, 0x6958, 0x695e, 0x695a,
  0x3177, 0x6955, 0x6954, 0x6951, 0x3541, 0x417b, 0x3863, 0x6957,
  0x4831, 0x3667, 0x6956, 0x4066, 0x3048, 0x3478, 0x6952, 0x4457,
  0x3065, 0x4140, 0x6950, 0x3b49, 0x6953, 0x4028, 0x696d, 0x696c,
  0x696e, 0x455a, 0x3f4a, 0x3935, 0x696f, 0x6969, 0x696b, 0x6968,
  0x696a, 0x4e33, 0x6867, 0x447c, 0x4d6a, 0x6866, 0x4263, 0x6861,
  0x4260, 0x6860, 0x687d, 0x536b, 0x687e, 0x687c, 0x6863, 0x6862,
  0x532e, 0x4d7c, 0x4f63, 0x6879, 0x687f, 0x4b64, 0x687b, 0x423c,
  0x384d, 0x6878, 0x3136, 0x3f7b, 0x687a, 0x5d7a, 0x3976, 0x4636,
  0x6875, 0x6874, 0x3c2e, 0x6877, 0x6876, 0x6871, 0x5760, 0x5c23,
  0x4466, 0x4350, 0x3e41, 0x546e, 0x4f30, 0x4937, 0x3c5c, 0x3571,
  0x4362, 0x525b, 0x3b4b, 0x4766, 0x6b78, 0x4755, 0x536f, 0x6b7a,
  0x375e, 0x4355, 0x5560, 0x5245, 0x6b75, 0x6b7b, 0x3f70, 0x374b,
  0x3958, 0x564b, 0x3f6d, 0x4b2c, 0x6b71, 0x6b76, 0x6b74, 0x3741,
  0x4d59, 0x4f3d, 0x6b73, 0x3453, 0x5244, 0x6b70, 0x3760, 0x7258,
  0x4a45, 0x742f, 0x742c, 0x3133, 0x3857, 0x3f71, 0x3c68, 0x404f,
  0x742e, 0x4f66, 0x742b, 0x5525, 0x3a32, 0x4363, 0x753b, 0x753a,
  0x3b58, 0x3024, 0x7535, 0x4936, 0x4359, 0x5120, 0x7534, 0x7537,
  0x4342, 0x5629, 0x5242, 0x7536, 0x395c, 0x303d, 0x3a30, 0x3051,
  0x4a5c, 0x3b52, 0x7530, 0x3b77, 0x7531, 0x7532, 0x7533, 0x754d,
  0x754c, 0x4573, 0x452f, 0x4e77, 0x5133, 0x3a37, 0x3a34, 0x514f,
  0x3b2f, 0x4922, 0x7538, 0x3952, 0x3246, 0x527c, 0x774e, 0x7749,
  0x3c40, 0x774b, 0x774a, 0x3447, 0x7748, 0x7744, 0x4f7c, 0x7746,
  0x542b, 0x3547, 0x7745, 0x7742, 0x315c, 0x775a, 0x775f, 0x7759,
  0x775e, 0x3376, 0x3532, 0x7743, 0x7747, 0x3157, 0x775d, 0x775c,
  0x7758, 0x7740, 0x386e, 0x4570, 0x775b, 0x7757, 0x7741, 0x3145,
  0x3963, 0x7751, 0x3329, 0x3b7d, 0x5273, 0x493f, 0x307d, 0x3652,
  0x7755, 0x7754, 0x4d35, 0x7750, 0x7753, 0x776c, 0x7752, 0x776e,
  0x776f, 0x7756, 0x3b67, 0x3762, 0x776d, 0x4324, 0x387f, 0x7766,
  0x3d32, 0x7769, 0x3620, 0x3f73, 0x4f6e, 0x7760, 0x7764, 0x3d51,
  0x7763, 0x7768, 0x776b, 0x7767, 0x466c, 0x7761, 0x7762, 0x7765,
  0x3870, 0x4b69, 0x777d, 0x776a, 0x777f, 0x5320, 0x4227, 0x777e,
  0x777c, 0x4625, 0x3c50, 0x7778, 0x7779, 0x3056, 0x777b, 0x777a,
  0x7775, 0x4437, 0x4464, 0x417c, 0x7776, 0x7777, 0x3055, 0x7773,
  0x7774, 0x7771, 0x7770, 0x702c, 0x702e, 0x3f44, 0x702f, 0x7029,
  0x3633, 0x702b, 0x7028, 0x3823, 0x475a, 0x5d6c, 0x446d, 0x7041,
  0x535c, 0x3356, 0x7043, 0x452e, 0x4244, 0x305b, 0x513e, 0x705d,
  0x7042, 0x705c, 0x4f57, 0x705f, 0x504c, 0x526d, 0x336d, 0x4535,
  0x4536, 0x705e, 0x3a21, 0x306f, 0x7059, 0x7058, 0x3a26, 0x705b,
  0x7056, 0x705a, 0x7057, 0x3e70, 0x7055, 0x7054, 0x3c6f, 0x484a,
  0x7051, 0x3657, 0x475e, 0x506e, 0x3b3a, 0x7050, 0x4139, 0x7064,
  0x4b38, 0x4a44, 0x4f55, 0x4f7a, 0x3979, 0x5342, 0x4456, 0x5478,
  0x7067, 0x7066, 0x7061, 0x736e, 0x333c, 0x7060, 0x5366, 0x7063,
  0x6274, 0x3a4d, 0x6277, 0x3e61, 0x6276, 0x4b46, 0x6271, 0x5031,
  0x383b, 0x6270, 0x6273, 0x3840, 0x4c5f, 0x4a3e, 0x632c, 0x3032,
  0x632f, 0x4d39, 0x3c54, 0x4044, 0x5350, 0x4657, 0x335a, 0x5230,
  0x4a4b, 0x3349, 0x412b, 0x632e, 0x4b52, 0x6329, 0x6328, 0x632b,
  0x453a, 0x5364, 0x4d7d, 0x4b35, 0x5222, 0x5258, 0x632a, 0x3460,
  0x6325, 0x6324, 0x4d51, 0x5662, 0x3a20, 0x6327, 0x347e, 0x4c53,
  0x396c, 0x6326, 0x4c4b, 0x6321, 0x3f6b, 0x3c75, 0x5529, 0x6320,
  0x466a, 0x3a75, 0x3947, 0x493e, 0x6323, 0x6322, 0x3a63, 0x5468,
  0x4f6a, 0x485d, 0x3841, 0x633d, 0x3825, 0x547a, 0x633c, 0x5475,
  0x633f, 0x633e, 0x304f, 0x6339, 0x6338, 0x4d73, 0x4a21, 0x476d,
  0x633a, 0x354c, 0x377c, 0x6335, 0x6334, 0x5356, 0x514d, 0x6337,
  0x4641, 0x5337, 0x6336, 0x6331, 0x6330, 0x3867, 0x4768, 0x444f,
  0x6333, 0x6332, 0x3824, 0x634d, 0x634c, 0x633b, 0x325d, 0x634f,
  0x634e, 0x6349, 0x3f37, 0x3153, 0x464b, 0x356d, 0x6348, 0x5038,
  0x634b, 0x3c32, 0x6345, 0x634a, 0x3361, 0x6344, 0x3675, 0x6347,
  0x6346, 0x6341, 0x6340, 0x6343, 0x6342, 0x635d, 0x572a, 0x4f78,
  0x635c, 0x635f, 0x635e, 0x6359, 0x4d44, 0x6358, 0x635b, 0x635a,
  0x6355, 0x6354, 0x3944, 0x6357, 0x7733, 0x3c5a, 0x4c3c, 0x7732,
  0x774d, 0x774c, 0x3d53, 0x4975, 0x5c65, 0x3e3c, 0x4653, 0x6a3a,
  0x332e, 0x6a34, 0x6a35, 0x3458, 0x6a36, 0x515b, 0x5362, 0x524e,
  0x6a30, 0x4e7d, 0x6a31, 0x6a33, 0x6a4d, 0x6a32, 0x557f, 0x4331,
  0x474d, 0x3c6c, 0x456a, 0x704b, 0x5452, 0x704a, 0x4b56, 0x4c37,
  0x7045, 0x7044, 0x7047, 0x7046, 0x5d77, 0x3c73, 0x617c, 0x577d,
  0x706d, 0x4a41, 0x376c, 0x7539, 0x5663, 0x706c, 0x4b65, 0x706f,
  0x4341, 0x3159, 0x3069, 0x7069, 0x706e, 0x7068, 0x706b, 0x706a,
  0x3e3f, 0x3432, 0x7065, 0x3320, 0x5660, 0x5626, 0x4442, 0x3b31,
  0x6f2e, 0x5152, 0x6e45, 0x757e, 0x3275, 0x4f2e, 0x4040, 0x756a,
  0x7565, 0x3c76, 0x7564, 0x3e49, 0x5048, 0x345f, 0x7567, 0x7566,
  0x7561, 0x7560, 0x7563, 0x7562, 0x757c, 0x757d, 0x4158, 0x757f,
  0x3277, 0x7579, 0x5623, 0x5a4a, 0x4f47, 0x3751, 0x312f, 0x3d2f,
  0x4079, 0x7578, 0x757b, 0x4549, 0x4576, 0x523d, 0x757a, 0x7575,
  0x4527, 0x4235, 0x3a56, 0x7574, 0x3042, 0x7577, 0x693f, 0x693c,
  0x4f6d, 0x5653, 0x4f4c, 0x5155, 0x4c6f, 0x4452, 0x382c, 0x6f4c,
  0x5429, 0x526f, 0x324a, 0x3c55, 0x6f4d, 0x3c43, 0x6f32, 0x372b,
  0x3d44, 0x5226, 0x3379, 0x3347, 0x386a, 0x3333, 0x6f4b, 0x6f4a,
  0x3434, 0x3b42, 0x6f48, 0x5770, 0x6f45, 0x6f44, 0x3343, 0x6f4f,
  0x6f49, 0x4d7b, 0x525a, 0x5140, 0x543f, 0x6f42, 0x4a35, 0x6f5d,
  0x3125, 0x353e, 0x6f5f, 0x4828, 0x415b, 0x6f5e, 0x6f5c, 0x4152,
  0x6f43, 0x4e29, 0x6f58, 0x3476, 0x3e77, 0x5c3a, 0x756e, 0x6f47,
  0x6f46, 0x6f41, 0x6f40, 0x6f5b, 0x624d, 0x6f54, 0x3b65, 0x5645,
  0x6f5a, 0x6f51, 0x3c61, 0x6f55, 0x3937, 0x5455, 0x343a, 0x6f50,
  0x4051, 0x5221, 0x306d, 0x467b, 0x3834, 0x6f57, 0x6f56, 0x506d,
  0x4267, 0x4059, 0x6f52, 0x412a, 0x5d78, 0x363c, 0x6f69, 0x3948,
  0x6f6f, 0x6f6e, 0x3c21, 0x495c, 0x6f68, 0x6f6c, 0x453e, 0x422f,
  0x487e, 0x6f6b, 0x443d, 0x5635, 0x6f6a, 0x3c22, 0x3c20, 0x6f65,
  0x4336, 0x497e, 0x6f67, 0x6f66, 0x6f60, 0x5445, 0x6f7f, 0x6f63,
  0x6f7c, 0x4c74, 0x5571, 0x6f61, 0x6f64, 0x3c34, 0x4b54, 0x4068,
  0x6f62, 0x6f7d, 0x4857, 0x4945, 0x347f, 0x6f7b, 0x6f78, 0x363f,
  0x3c6d, 0x6f7a, 0x3561, 0x4848, 0x4029, 0x4b28, 0x6f74, 0x682f,
  0x417f, 0x6f77, 0x4d48, 0x6652, 0x6f73, 0x4943, 0x682c, 0x3556,
  0x573a, 0x5651, 0x6f70, 0x6f76, 0x3731, 0x6e3d, 0x5359, 0x7026,
  0x3779, 0x524c, 0x524f, 0x5164, 0x3a47, 0x702a, 0x5625, 0x7025,
  0x7024, 0x7027, 0x3a46, 0x5752, 0x4d6d, 0x4d6c, 0x774f, 0x4e6b,
  0x487f, 0x663b, 0x4f39, 0x4a65, 0x5256, 0x7020, 0x7023, 0x7022,
  0x703f, 0x3e30, 0x703e, 0x346e, 0x703d, 0x703c, 0x392f, 0x3658,
  0x703b, 0x703a, 0x326b, 0x363d, 0x4b42, 0x7039, 0x3021, 0x7038,
  0x7035, 0x7034, 0x492a, 0x7037, 0x7036, 0x7031, 0x4f5f, 0x7030,
  0x7033, 0x7032, 0x7053, 0x4531, 0x3865, 0x4d26, 0x5553, 0x6178,
  0x583e, 0x5658, 0x5839, 0x3421, 0x5838, 0x3957, 0x5834, 0x5c4f,
  0x583a, 0x577e, 0x4d5b, 0x5837, 0x583b, 0x5836, 0x472f, 0x5831,
  0x5848, 0x5830, 0x4a52, 0x5228, 0x5842, 0x5840, 0x585f, 0x396b,
  0x4626, 0x5835, 0x5846, 0x5843, 0x5833, 0x335f, 0x3448, 0x584a,
  0x5433, 0x584c, 0x3f25, 0x3331, 0x5841, 0x584b, 0x5832, 0x4356,
  0x5532, 0x584d, 0x5847, 0x585d, 0x4a20, 0x584f, 0x584e, 0x5845,
  0x5844, 0x3659, 0x585c, 0x4f58, 0x503a, 0x5856, 0x5852, 0x482b,
  0x586b, 0x476a, 0x5851, 0x3b4c, 0x5854, 0x3477, 0x3d3b, 0x5868,
  0x585e, 0x5849, 0x585b, 0x4c79, 0x3b6d, 0x4d36, 0x3530, 0x572f,
  0x5857, 0x5858, 0x4236, 0x5853, 0x534f, 0x4722, 0x333b, 0x435c,
  0x4724, 0x586f, 0x5855, 0x5866, 0x5859, 0x5850, 0x3a28, 0x585a,
  0x586d, 0x586e, 0x5869, 0x5875, 0x586c, 0x592f, 0x586a, 0x3866,
  0x3049, 0x472e, 0x366a, 0x5877, 0x587f, 0x5862, 0x5871, 0x5863,
  0x567d, 0x3665, 0x4c5a, 0x4c6e, 0x5876, 0x5860, 0x587a, 0x5878,
  0x3a2e, 0x5879, 0x3650, 0x587e, 0x387b, 0x5865, 0x3f49, 0x447e,
  0x3859, 0x5864, 0x5867, 0x587c, 0x587b, 0x5874, 0x3139, 0x4c54,
  0x3f6a, 0x5873, 0x5870, 0x5726, 0x592c, 0x592e, 0x5928, 0x567c,
  0x5929, 0x592b, 0x592a, 0x5624, 0x3e44, 0x5924, 0x593b, 0x593c,
  0x5939, 0x593d, 0x4243, 0x447f, 0x4d22, 0x5861, 0x5923, 0x593a,
  0x587d, 0x5922, 0x5935, 0x5921, 0x5934, 0x593e, 0x5920, 0x4027,
  0x5925, 0x443e, 0x4526, 0x5927, 0x5926, 0x593f, 0x3f7c, 0x5938,
  0x5725, 0x5937, 0x5936, 0x472a, 0x595f, 0x5931, 0x595c, 0x3d30,
  0x3a58, 0x3a77, 0x3e47, 0x5947, 0x5948, 0x5932, 0x3646, 0x594e,
  0x5946, 0x3629, 0x5958, 0x5933, 0x425d, 0x595d, 0x5959, 0x456f,
  0x334b, 0x5943, 0x5942, 0x5949, 0x5930, 0x5940, 0x485c, 0x5944,
  0x594f, 0x4745, 0x4231, 0x4a23, 0x5941, 0x5945, 0x594c, 0x594b,
  0x4651, 0x5724, 0x5727, 0x595e, 0x4b79, 0x4c75, 0x596b, 0x594a,
  0x596d, 0x4669, 0x596c, 0x595a, 0x5275, 0x5954, 0x5955, 0x3c7d,
  0x595b, 0x4242, 0x3220, 0x596f, 0x3e74, 0x506c, 0x596a, 0x305d,
  0x5957, 0x3b76, 0x596e, 0x5952, 0x5950, 0x3154, 0x5956, 0x5951,
  0x5953, 0x3922, 0x5969, 0x5968, 0x5978, 0x4744, 0x4f6f, 0x597f,
  0x5c6c, 0x425c, 0x5979, 0x5179, 0x597e, 0x597d, 0x5961, 0x5962,
  0x5965, 0x5463, 0x4c55, 0x5963, 0x5964, 0x5967, 0x4f7f, 0x5960,
  0x3540, 0x443b, 0x3836, 0x597c, 0x597a, 0x597b, 0x5966, 0x4163,
  0x5976, 0x5a29, 0x5a2e, 0x5975, 0x4762, 0x4676, 0x516c, 0x4a38,
  0x5970, 0x3641, 0x4065, 0x4e52, 0x4333, 0x5977, 0x5971, 0x5973,
  0x5a2f, 0x3427, 0x3543, 0x5a21, 0x5a2b, 0x393b, 0x4c62, 0x5a2c,
  0x5a28, 0x5a24, 0x5a25, 0x5a2a, 0x5a20, 0x5041, 0x5a3e, 0x5a27,
  0x5a23, 0x4454, 0x352c, 0x5a3b, 0x5a3c, 0x5a3f, 0x552b, 0x5a38,
  0x5a22, 0x5a3d, 0x5430, 0x5a39, 0x4e60, 0x5a34, 0x5a35, 0x5a3a,
  0x5a36, 0x3968, 0x3655, 0x4767, 0x5a37, 0x4137, 0x5a31, 0x4854,
  0x3327, 0x5068, 0x5a30, 0x5a32, 0x402f, 0x5a4c, 0x5a33, 0x5a4d,
  0x5137, 0x5a4f, 0x7623, 0x3f2f, 0x463f, 0x413d, 0x464a, 0x7622,
  0x5464, 0x5750, 0x6f30, 0x376b, 0x763d, 0x763c, 0x4e20, 0x3e6a,
  0x763e, 0x7638, 0x7639, 0x4f69, 0x4b37, 0x763f, 0x4e39, 0x5642,
  0x4661, 0x4a4e, 0x7635, 0x347b, 0x763a, 0x7633, 0x3642, 0x554c,
  0x7637, 0x7631, 0x5064, 0x7636, 0x763b, 0x7632, 0x7630, 0x7634,
  0x764a, 0x7649, 0x764b, 0x7647, 0x764f, 0x764d, 0x7648, 0x5276,
  0x764c, 0x4374, 0x4d52, 0x7645, 0x3d4b, 0x313d, 0x764e, 0x7644,
  0x765d, 0x765b, 0x3f5a, 0x7658, 0x4951, 0x5266, 0x765f, 0x7659,
  0x3c7f, 0x7646, 0x7643, 0x4674, 0x5150, 0x7641, 0x7640, 0x7642,
  0x765e, 0x7654, 0x5731, 0x3267, 0x4e7c, 0x3369, 0x765a, 0x7655,
  0x7657, 0x7650, 0x7656, 0x7651, 0x555c, 0x765c, 0x4944, 0x4a42,
  0x5224, 0x766e, 0x4756, 0x766d, 0x4422, 0x7661, 0x7653, 0x766c,
  0x7665, 0x766f, 0x766a, 0x766b, 0x7664, 0x7652, 0x7669, 0x7667,
  0x5721, 0x7668, 0x3678, 0x767f, 0x5426, 0x7678, 0x3f45, 0x7674,
  0x767d, 0x767b, 0x7675, 0x7677, 0x767e, 0x767c, 0x3e76, 0x3176,
  0x7662, 0x767a, 0x7660, 0x7663, 0x7666, 0x772b, 0x772e, 0x772f,
  0x7679, 0x4c57, 0x7676, 0x7728, 0x4775, 0x7670, 0x772a, 0x7724,
  0x7729, 0x7671, 0x7726, 0x7727, 0x4650, 0x7723, 0x773d, 0x772c,
  0x773c, 0x7721, 0x7722, 0x7673, 0x7720, 0x773f, 0x7739, 0x7725,
  0x773e, 0x7738, 0x543a, 0x7735, 0x5d74, 0x7734, 0x773a, 0x4c69,
  0x773b, 0x7737, 0x7736, 0x304d, 0x6a4e, 0x7731, 0x7730, 0x5527,
  0x7021, 0x544b, 0x545d, 0x5551, 0x4b43, 0x395b, 0x554e, 0x3e6f,
  0x6564, 0x564f, 0x754f, 0x3634, 0x3560, 0x754e, 0x4d4d, 0x3749,
  0x5d7f, 0x4f28, 0x7549, 0x5259, 0x7548, 0x704d, 0x754b, 0x5021,
  0x754a, 0x344d, 0x704c, 0x704f, 0x3071, 0x4156, 0x4836, 0x5469,
  0x496d, 0x7545, 0x5d7e, 0x3536, 0x4b23, 0x3c29, 0x7547, 0x7546,
  0x364e, 0x455c, 0x533d, 0x7544, 0x7541, 0x7543, 0x5d7b, 0x566c,
  0x502e, 0x704e, 0x4c34, 0x7049, 0x7540, 0x7542, 0x3b6e, 0x755d,
  0x7559, 0x755b, 0x755c, 0x4d5c, 0x416c, 0x466e, 0x3d71, 0x755e,
  0x7558, 0x3d5e, 0x7556, 0x3e5b, 0x3470, 0x7554, 0x7555, 0x755f,
  0x7557, 0x755a, 0x4c61, 0x4947, 0x7550, 0x6130, 0x7551, 0x7553,
  0x7552, 0x4b68, 0x7048, 0x397e, 0x756d, 0x756c, 0x4a7a, 0x5627,
  0x7576, 0x3c3f, 0x3876, 0x3d56, 0x3d6b, 0x4754, 0x4e5e, 0x6e65,
  0x444d, 0x3a78, 0x6e64, 0x6e67, 0x6e66, 0x6e61, 0x6e60, 0x6e63,
  0x6e62, 0x394a, 0x7176, 0x7170, 0x7173, 0x7171, 0x396f, 0x722c,
  0x3028, 0x722f, 0x722e, 0x683f, 0x5559, 0x5d67, 0x7229, 0x6a37,
  0x513f, 0x5773, 0x4851, 0x4e49, 0x614d, 0x7228, 0x3a22, 0x4224,
  0x5e28, 0x384b, 0x3224, 0x3c31, 0x4c42, 0x3828, 0x5e2b, 0x5e2a,
  0x485b, 0x4c4e, 0x5e25, 0x4270, 0x5538, 0x5664, 0x553b, 0x384a,
  0x393f, 0x3f69, 0x5e24, 0x5e27, 0x5545, 0x5e26, 0x5460, 0x3262,
  0x4656, 0x4f42, 0x3360, 0x4d65, 0x334e, 0x3a7a, 0x5229, 0x5e21,
  0x5e20, 0x424d, 0x536a, 0x4e3b, 0x5124, 0x4f52, 0x5162, 0x5e23,
  0x5252, 0x3047, 0x5e3d, 0x5e22, 0x5666, 0x5e3c, 0x5e3f, 0x5e3e,
  0x4e59, 0x5e39, 0x4e26, 0x5e38, 0x5e3b, 0x3742, 0x5262, 0x5e3a,
  0x3f3d, 0x3123, 0x5e35, 0x5e34, 0x3d63, 0x5522, 0x5665, 0x5e37,
  0x3c4e, 0x4b67, 0x3662, 0x5e36, 0x5e31, 0x3966, 0x4a51, 0x5762,
  0x5e30, 0x4a7e, 0x5e33, 0x5758, 0x3f68, 0x5e32, 0x4f38, 0x4f5d,
  0x5e4d, 0x4366, 0x5263, 0x5e4c, 0x4138, 0x324c, 0x5e4f, 0x3341,
  0x3b43, 0x5e4e, 0x5e49, 0x4f20, 0x5e48, 0x317a, 0x5e4b, 0x454f,
  0x5336, 0x5e4a, 0x4835, 0x5667, 0x403c, 0x5e45, 0x3170, 0x3f5c,
  0x5e44, 0x543e, 0x5e47, 0x5e46, 0x4a30, 0x5e41, 0x5e40, 0x5e43,
  0x367a, 0x5e5c, 0x5e42, 0x5565, 0x5e5d, 0x4758, 0x5e5f, 0x5e5e,
  0x5e59, 0x5e58, 0x5436, 0x5628, 0x3474, 0x5e5b, 0x4326, 0x5e5a,
  0x397a, 0x472c, 0x5e55, 0x5e54, 0x4770, 0x483a, 0x5e57, 0x5e56,
  0x4433, 0x425a, 0x5e51, 0x5e50, 0x4339, 0x5e53, 0x5e52, 0x3d45,
  0x3f60, 0x3234, 0x7075, 0x7074, 0x496e, 0x7134, 0x6f6d, 0x4b7e,
  0x3f32, 0x3e4d, 0x5028, 0x6554, 0x7179, 0x3527, 0x367f, 0x7178,
  0x717a, 0x3e5c, 0x717b, 0x473f, 0x7174, 0x7175, 0x3539, 0x5167,
  0x3c37, 0x3d3c, 0x364b, 0x507d, 0x4b40, 0x3451, 0x5146, 0x3f78,
  0x5247, 0x333a, 0x483d, 0x423b, 0x356c, 0x3d37, 0x5271, 0x3d6c,
  0x332c, 0x3877, 0x6e57, 0x6e56, 0x4874, 0x3d7e, 0x6e51, 0x3076,
  0x473e, 0x335c, 0x3e55, 0x6e50, 0x5079, 0x6e53, 0x385b, 0x3f52,
  0x6e52, 0x4553, 0x4635, 0x5052, 0x5347, 0x6e6d, 0x6e6c, 0x6e69,
  0x6e6f, 0x6e6e, 0x4d53, 0x3c3e, 0x3249, 0x6e68, 0x4e67, 0x4d40,
  0x3040, 0x6654, 0x416f, 0x6e6b, 0x4438, 0x5335, 0x6e6a, 0x5321,
  0x4c71, 0x5c5e, 0x5c40, 0x5053, 0x5074, 0x4d49, 0x5723, 0x3c5e,
  0x376d, 0x4d6f, 0x707b, 0x3e58, 0x707a, 0x5352, 0x707c, 0x3c3d,
  0x5159, 0x3c42, 0x427d, 0x374e, 0x707f, 0x3721, 0x5030, 0x437a,
  0x7079, 0x707e, 0x4846, 0x4c29, 0x7078, 0x536e, 0x4132, 0x714d,
  0x7136, 0x714e, 0x714f, 0x5237, 0x714c, 0x5033, 0x7149, 0x7141,
  0x3442, 0x3175, 0x7144, 0x7147, 0x4151, 0x7148, 0x714b, 0x714a,
  0x7146, 0x3a6d, 0x7145, 0x3c77, 0x715d, 0x715e, 0x3b6a, 0x3d7f,
  0x7131, 0x7140, 0x463a, 0x4875, 0x3874, 0x7143, 0x7142, 0x715c,
  0x3268, 0x715f, 0x7158, 0x7130, 0x7159, 0x5736, 0x3761, 0x4829,
  0x715b, 0x715a, 0x3a6c, 0x7155, 0x4852, 0x7156, 0x3645, 0x5354,
  0x7154, 0x7157, 0x7151, 0x716f, 0x716d, 0x7152, 0x7150, 0x716c,
  0x7153, 0x7169, 0x7168, 0x486e, 0x6132, 0x3135, 0x716e, 0x7165,
  0x482e, 0x716b, 0x716a, 0x7133, 0x3549, 0x7132, 0x3148, 0x3669,
  0x7161, 0x7164, 0x325a, 0x7160, 0x7167, 0x7166, 0x3057, 0x5067,
  0x7163, 0x3774, 0x7162, 0x717c, 0x717d, 0x717f, 0x717e, 0x4d60,
  0x3d27, 0x4376, 0x326e, 0x4844, 0x6e2b, 0x3738, 0x5073, 0x3d61,
  0x5474, 0x6d60, 0x5327, 0x6d63, 0x465b, 0x4c60, 0x3e69, 0x6d62,
  0x6d7d, 0x6d7c, 0x526c, 0x6d7f, 0x6d7e, 0x6d78, 0x6d79, 0x6d7b,
  0x6d7a, 0x436c, 0x6d75, 0x5055, 0x6d74, 0x3943, 0x6d77, 0x6d76,
  0x3942, 0x6d71, 0x3c25, 0x4533, 0x6d70, 0x353f, 0x3f59, 0x3d78,
  0x6d73, 0x6e2c, 0x6e2f, 0x6e2e, 0x3375, 0x3820, 0x4e69, 0x6443,
  0x5022, 0x4b30, 0x513a, 0x6e29, 0x5153, 0x6e28, 0x544c, 0x3d31,
  0x304a, 0x3554, 0x443c, 0x356b, 0x356a, 0x3565, 0x3730, 0x4c65,
  0x614c, 0x3552, 0x4544, 0x3062, 0x4325, 0x5755, 0x4274, 0x5535,
  0x3d70, 0x4678, 0x5720, 0x5046, 0x3971, 0x614f, 0x3338, 0x614e,
  0x3f34, 0x516f, 0x3975, 0x503b, 0x4a28, 0x4521, 0x3754, 0x487b,
  0x614b, 0x6149, 0x6145, 0x6147, 0x614a, 0x3142, 0x4245, 0x3171,
  0x6148, 0x4e7b, 0x6144, 0x4759, 0x3548, 0x382e, 0x533a, 0x4946,
  0x4f40, 0x4e47, 0x485e, 0x6141, 0x6146, 0x406b, 0x552c, 0x553a,
  0x6140, 0x615d, 0x4935, 0x527d, 0x6142, 0x3150, 0x4933, 0x615c,
  0x3237, 0x4925, 0x3d69, 0x4e48, 0x375c, 0x4f54, 0x5061, 0x615f,
  0x3367, 0x6143, 0x6158, 0x3073, 0x615b, 0x615e, 0x6159, 0x5650,
  0x4652, 0x354b, 0x576f, 0x3250, 0x4f61, 0x615a, 0x577b, 0x3564,
  0x3279, 0x6157, 0x6155, 0x6154, 0x314d, 0x5648, 0x6151, 0x6153,
  0x6150, 0x433f, 0x562e, 0x6156, 0x506f, 0x5157, 0x616d, 0x537c,
  0x616c, 0x3551, 0x5576, 0x616f, 0x6169, 0x616e, 0x6168, 0x5655,
  0x3146, 0x6352, 0x5e78, 0x5e75, 0x5e7b, 0x5e7a, 0x5e77, 0x5442,
  0x404a, 0x3463, 0x543d, 0x5e74, 0x5747, 0x3e27, 0x5f2f, 0x437c,
  0x5e71, 0x5e76, 0x4d56, 0x5e70, 0x5f2c, 0x5353, 0x5e73, 0x4557,
  0x5f28, 0x5779, 0x5f2a, 0x5f29, 0x5f25, 0x3931, 0x4444, 0x5f2e,
  0x5f2b, 0x522e, 0x5f24, 0x5f20, 0x5f23, 0x5f21, 0x3e4f, 0x3b29,
  0x5f26, 0x5f27, 0x504a, 0x3632, 0x5f22, 0x3d74, 0x5f3d, 0x3736,
  0x312b, 0x3231, 0x5f3c, 0x3278, 0x5f3f, 0x3544, 0x5f39, 0x5f3e,
  0x5f38, 0x5f3a, 0x5f3b, 0x5f35, 0x5f34, 0x5f37, 0x5742, 0x7077,
  0x4378, 0x534e, 0x4169, 0x7071, 0x7070, 0x7076, 0x3a4b, 0x5462,
  0x335e, 0x5040, 0x4827, 0x712f, 0x712c, 0x3e25, 0x7073, 0x4f5b,
  0x7129, 0x445f, 0x3767, 0x4927, 0x7128, 0x712e, 0x3939, 0x7125,
  0x7124, 0x3940, 0x4735, 0x3b6c, 0x4f6c, 0x7127, 0x712b, 0x712a,
  0x407d, 0x7121, 0x3031, 0x5360, 0x305a, 0x7126, 0x7123, 0x7120,
  0x7122, 0x545c, 0x475c, 0x4c24, 0x713d, 0x713c, 0x713f, 0x713e,
  0x7139, 0x7138, 0x713a, 0x713b, 0x7135, 0x3644, 0x5759, 0x4e40,
  0x4462, 0x5255, 0x563d, 0x4532, 0x397d, 0x3c27, 0x3875, 0x724b,
  0x724a, 0x7245, 0x7244, 0x7247, 0x7241, 0x7246, 0x7364, 0x7240,
  0x7243, 0x6a49, 0x6a48, 0x6a4b, 0x5166, 0x3229, 0x6a45, 0x6a4a,
  0x6a44, 0x6a47, 0x4328, 0x6a46, 0x6a41, 0x333d, 0x317b, 0x6a40,
  0x6a42, 0x6a43, 0x3c4b, 0x6a5d, 0x6a5c, 0x6a5f, 0x3256, 0x3723,
  0x525e, 0x404b, 0x3538, 0x3c5b, 0x6a5e, 0x6a59, 0x5032, 0x4358,
  0x3a76, 0x4a54, 0x3d3e, 0x6a5b, 0x6a58, 0x6a55, 0x6a5a, 0x4128,
  0x6a54, 0x6a57, 0x4323, 0x6a56, 0x4322, 0x6a51, 0x362a, 0x6a50,
  0x6a53, 0x6a52, 0x6a6d, 0x6a6c, 0x5367, 0x6a6f, 0x6a6e, 0x3855,
  0x6a69, 0x5746, 0x4877, 0x3621, 0x4568, 0x6a68, 0x432b, 0x4720,
  0x6a6b, 0x6a6a, 0x6a65, 0x6a64, 0x6a67, 0x6a66, 0x6a61, 0x6a60,
  0x6a63, 0x6a62, 0x6a7d, 0x6a7c, 0x6a7f, 0x6a79, 0x6a7e, 0x6a78,
  0x4920, 0x464c, 0x6a7b, 0x6a7a, 0x6a75, 0x512c, 0x6a74, 0x4b3e,
  0x6a77, 0x6a76, 0x6a71, 0x6a70, 0x6b2c, 0x6a73, 0x6b2f, 0x3c78,
  0x4777, 0x6b2e, 0x6b29, 0x394f, 0x5632, 0x3674, 0x6b28, 0x6b2b,
  0x6b2a, 0x5675, 0x6b25, 0x5270, 0x6b24, 0x4241, 0x6b27, 0x6b26,
  0x4539, 0x6b21, 0x4b77, 0x4f75, 0x6b23, 0x6b20, 0x3777, 0x3d75,
  0x6b22, 0x6b3d, 0x546f, 0x6b3c, 0x6b3f, 0x336b, 0x5432, 0x6b3e,
  0x6b39, 0x6b38, 0x4c7c, 0x486d, 0x6b3b, 0x6b3a, 0x6b35, 0x6b34,
  0x6b37, 0x516d, 0x6b36, 0x3060, 0x4727, 0x6b31, 0x6b30, 0x6b33,
  0x6b32, 0x4a70, 0x6b4d, 0x466d, 0x3035, 0x533b, 0x3978, 0x4b4a,
  0x6b4e, 0x6b4c, 0x6b4f, 0x6b49, 0x322a, 0x3871, 0x3a6f, 0x4741,
  0x6b48, 0x6b4b, 0x6b4a, 0x6b42, 0x6b45, 0x6b44, 0x6b47, 0x434f,
  0x6b7c, 0x3240, 0x6b46, 0x6b41, 0x6b40, 0x324b, 0x4733, 0x6b43,
  0x6b5d, 0x6b5c, 0x6b5f, 0x517f, 0x6b5e, 0x407a, 0x6b59, 0x4075,
  0x6b58, 0x6b5b, 0x3c69, 0x347a, 0x6b5a, 0x6b55, 0x6b54, 0x6b57,
  0x6b56, 0x6b51, 0x6b50, 0x6b53, 0x3a38, 0x6b6c, 0x6b52, 0x6b6d,
  0x6b6f, 0x6b6e, 0x4540, 0x6b69, 0x6b68, 0x6b6b, 0x6b6a, 0x6b65,
  0x6b64, 0x6b67, 0x6b66, 0x6b61, 0x4455, 0x6b60, 0x4520, 0x6b63,
  0x6b62, 0x6b7d, 0x4b6f, 0x3729, 0x4748, 0x6748, 0x4d4c, 0x674b,
  0x3558, 0x4a47, 0x303e, 0x4c7f, 0x674a, 0x4b5d, 0x6745, 0x3869,
  0x6744, 0x6747, 0x474b, 0x512f, 0x405b, 0x3d66, 0x4a48, 0x6746,
  0x477b, 0x6741, 0x332a, 0x3c7e, 0x3e5f, 0x6740, 0x6743, 0x5049,
  0x6742, 0x675d, 0x5546, 0x675c, 0x675f, 0x675e, 0x6759, 0x555b,
  0x6758, 0x3676, 0x4436, 0x675b, 0x4426, 0x675a, 0x6755, 0x6754,
  0x6757, 0x6756, 0x3c3a, 0x5e6f, 0x325e, 0x5e69, 0x5e6e, 0x5e6b,
  0x4c63, 0x5e68, 0x334d, 0x5579, 0x5678, 0x517e, 0x395a, 0x5365,
  0x5e65, 0x5e6a, 0x342f, 0x495e, 0x5e64, 0x3c30, 0x3847, 0x4630,
  0x4629, 0x374f, 0x5e67, 0x4627, 0x403d, 0x3938, 0x4b53, 0x5e66,
  0x4d4f, 0x3550, 0x5e61, 0x3235, 0x5037, 0x3770, 0x5e60, 0x5044,
  0x4b58, 0x416e, 0x5e63, 0x5e62, 0x5e7d, 0x4567, 0x4858, 0x4b50,
  0x576a, 0x462c, 0x5e7c, 0x4f68, 0x5e7f, 0x4f6b, 0x5673, 0x3c79,
  0x5e7e, 0x3422, 0x4b3b, 0x5142, 0x4f60, 0x5e79, 0x6749, 0x4528,
  0x7232, 0x724d, 0x724c, 0x405c, 0x4c35, 0x556e, 0x5456, 0x5548,
  0x3822, 0x3d40, 0x6b79, 0x304b, 0x5737, 0x724f, 0x3776, 0x724e,
  0x317c, 0x7248, 0x5767, 0x722a, 0x5524, 0x7224, 0x7225, 0x456e,
  0x445a, 0x352f, 0x4a60, 0x5465, 0x7226, 0x4b7b, 0x7227, 0x517d,
  0x7221, 0x4734, 0x3f79, 0x7223, 0x7220, 0x4053, 0x4555, 0x4f27,
  0x4b31, 0x7222, 0x723d, 0x723c, 0x463b, 0x3459, 0x4174, 0x723f,
  0x436d, 0x722b, 0x3a35, 0x3a3f, 0x3168, 0x334a, 0x3b32, 0x475f,
  0x476b, 0x5c41, 0x3c62, 0x3974, 0x5528, 0x345d, 0x733d, 0x733c,
  0x5421, 0x343d, 0x733f, 0x733e, 0x7339, 0x4347, 0x3a42, 0x733a,
  0x733b, 0x3553, 0x7338, 0x7335, 0x7334, 0x4a29, 0x4c40, 0x3e26,
  0x6c35, 0x6c34, 0x6c37, 0x3a4f, 0x5679, 0x5042, 0x4d55, 0x563e,
  0x3228, 0x4367, 0x7571, 0x4b63, 0x4f3e, 0x5466, 0x6362, 0x496a,
  0x3d46, 0x3254, 0x7570, 0x3469, 0x4f41, 0x7573, 0x5029, 0x4620,
  0x4561, 0x4249, 0x3a3c, 0x762c, 0x3858, 0x762f, 0x762e, 0x7629,
  0x564e, 0x4238, 0x494a, 0x7628, 0x573c, 0x3b48, 0x486f, 0x762b,
  0x762a, 0x5558, 0x3263, 0x7625, 0x7624, 0x3152, 0x7627, 0x7626,
  0x3671, 0x7621, 0x7620, 0x4c2a, 0x336a, 0x6824, 0x6827, 0x6826,
  0x6821, 0x4223, 0x6820, 0x6823, 0x3344, 0x4e3e, 0x6635, 0x7342,
  0x735d, 0x3640, 0x735c, 0x735e, 0x735f, 0x6636, 0x382f, 0x6631,
  0x6630, 0x6633, 0x6632, 0x664d, 0x664c, 0x3334, 0x5676, 0x3929,
  0x4e43, 0x3528, 0x4f4a, 0x664f, 0x3271, 0x4c49, 0x664e, 0x3945,
  0x3570, 0x6649, 0x327b, 0x6648, 0x4054, 0x664b, 0x4b57, 0x3d50,
  0x664a, 0x442c, 0x6645, 0x367b, 0x6644, 0x457e, 0x6647, 0x6646,
  0x4675, 0x6641, 0x6640, 0x6643, 0x4e5a, 0x5c35, 0x5d68, 0x4b6e,
  0x7428, 0x583d, 0x4660, 0x502b, 0x4959, 0x553c, 0x3756, 0x4370,
  0x3638, 0x4632, 0x626d, 0x4e36, 0x626c, 0x626f, 0x3a59, 0x626e,
  0x5329, 0x4958, 0x6268, 0x3850, 0x6269, 0x626b, 0x626a, 0x4663,
  0x3933, 0x6265, 0x466b, 0x3e2a, 0x6264, 0x6267, 0x375f, 0x5564,
  0x3b28, 0x6266, 0x4262, 0x6261, 0x6260, 0x6263, 0x4220, 0x6262,
  0x4d2a, 0x627d, 0x627c, 0x627f, 0x6134, 0x627e, 0x6279, 0x466f,
  0x6278, 0x627b, 0x5265, 0x627a, 0x6275, 0x3d4a, 0x7336, 0x7337,
  0x7333, 0x7331, 0x3e2c, 0x7332, 0x734d, 0x734f, 0x734c, 0x7349,
  0x734e, 0x7348, 0x734b, 0x734a, 0x4f65, 0x3c52, 0x7359, 0x7358,
  0x735b, 0x7355, 0x7357, 0x735a, 0x7356, 0x7354, 0x535a, 0x7351,
  0x7350, 0x7353, 0x7352, 0x736d, 0x5f46, 0x5c27, 0x617a, 0x3d60,
  0x3b70, 0x3f67, 0x7344, 0x424a, 0x7345, 0x7347, 0x7341, 0x7346,
  0x7340, 0x4a37, 0x7343, 0x402a, 0x576e, 0x7242, 0x463e, 0x725d,
  0x725c, 0x725f, 0x725e, 0x7259, 0x725b, 0x3526, 0x725a, 0x7255,
  0x7254, 0x7257, 0x7256, 0x7251, 0x7250, 0x7253, 0x4b47, 0x7252,
  0x726d, 0x726c, 0x726f, 0x726e, 0x7269, 0x447d, 0x7268, 0x726b,
  0x726a, 0x7265, 0x7264, 0x7267, 0x7266, 0x7261, 0x7260, 0x7263,
  0x7262, 0x727d, 0x727c, 0x727f, 0x727e, 0x7279, 0x3a25, 0x7278,
  0x727b, 0x727a, 0x7275, 0x4c77, 0x7274, 0x7277, 0x7276, 0x7271,
  0x7270, 0x7273, 0x732c, 0x732f, 0x732e, 0x7329, 0x7328, 0x732b,
  0x732a, 0x7325, 0x3563, 0x7324, 0x7327, 0x7326, 0x7321, 0x7320,
  0x4556, 0x7323, 0x7322, 0x407c, 0x7422, 0x382b, 0x743d, 0x4774,
  0x4135, 0x5536, 0x743c, 0x743f, 0x743e, 0x7439, 0x7438, 0x5531,
  0x5561, 0x743a, 0x743b, 0x502a, 0x495f, 0x7435, 0x7437, 0x7434,
  0x7436, 0x7431, 0x3c66, 0x7430, 0x3e65, 0x7433, 0x7432, 0x3a64,
  0x744d, 0x3261, 0x744c, 0x744f, 0x744e, 0x7449, 0x4c38, 0x7448,
  0x744b, 0x744a, 0x4179, 0x7445, 0x7444, 0x7447, 0x7330, 0x7446,
  0x7441, 0x7440, 0x7443, 0x7442, 0x3e5a, 0x745d, 0x745c, 0x745f,
  0x745e, 0x7459, 0x7458, 0x745b, 0x7455, 0x5728, 0x745a, 0x7454,
  0x7137, 0x4634, 0x7369, 0x7368, 0x736b, 0x736a, 0x7365, 0x4639,
  0x7367, 0x7366, 0x467e, 0x707d, 0x7062, 0x4664, 0x736c, 0x736f,
  0x3f4b, 0x5d69, 0x4e7f, 0x4465, 0x7429, 0x3e57, 0x4320, 0x4021,
  0x7361, 0x7360, 0x7363, 0x737d, 0x7362, 0x737c, 0x7379, 0x737e,
  0x737f, 0x7378, 0x737b, 0x6964, 0x6967, 0x6966, 0x7231, 0x7230,
  0x7233, 0x322b, 0x5c33, 0x3d49, 0x5c36, 0x583c, 0x4e7e, 0x737a,
  0x7375, 0x7374, 0x7376, 0x7377, 0x354a, 0x7371, 0x7370, 0x7373,
  0x4266, 0x6839, 0x3750, 0x723e, 0x7239, 0x4569, 0x7238, 0x723b,
  0x723a, 0x7235, 0x7234, 0x7237, 0x4c2e, 0x7236, 0x4577, 0x3d25,
  0x6965, 0x3d67, 0x5d52, 0x272c, 0x272f, 0x272e, 0x256a, 0x2728,
  0x272b, 0x272a, 0x2725, 0x2724, 0x2727, 0x2726, 0x2721, 0x2720,
  0x2723, 0x2722, 0x273d, 0x273c, 0x273f, 0x273e, 0x2739, 0x2738,
  0x273b, 0x273a, 0x2735, 0x2734, 0x2737, 0x2736, 0x2731, 0x2730,
  0x2733, 0x2732, 0x274d, 0x274c, 0x274f, 0x274e, 0x2749, 0x2748,
  0x274b, 0x274a, 0x2745, 0x2744, 0x2747, 0x2746, 0x2741, 0x2740,
  0x2743, 0x2742, 0x275d, 0x275c, 0x275f, 0x275e, 0x2759, 0x2758,
  0x275b, 0x275a, 0x2755, 0x2754, 0x2757, 0x2756, 0x2751, 0x2750,
  0x2753, 0x2752, 0x276d, 0x276c, 0x276f, 0x276e, 0x2769, 0x2768,
  0x276b, 0x276a, 0x2765, 0x2764, 0x2767, 0x2766, 0x2761, 0x2760,
  0x2763, 0x2762, 0x277d, 0x277c, 0x277f, 0x277e, 0x2779, 0x2778,
  0x277b, 0x277a, 0x2775, 0x2774, 0x2777, 0x2776, 0x2771, 0x2770,
  0x2526, 0x2564, 0x2567, 0x2773, 0x2729
};

static const aciConvSummary16 gb2312_uni2indx_page00[ /*70*/ ] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0190 }, {    3, 0x0003 },
  {    5, 0x0000 }, {    5, 0x0080 }, {    6, 0x3703 }, {   13, 0x168c },
  /* 0x0100 */
  {   19, 0x0002 }, {   20, 0x0808 }, {   22, 0x0800 }, {   23, 0x0000 },
  {   23, 0x2000 }, {   24, 0x0000 }, {   24, 0x0800 }, {   25, 0x0000 },
  {   25, 0x0000 }, {   25, 0x0000 }, {   25, 0x0000 }, {   25, 0x0000 },
  {   25, 0x4000 }, {   26, 0x1555 }, {   33, 0x0000 }, {   33, 0x0000 },
  /* 0x0200 */
  {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 },
  {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 },
  {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 }, {   33, 0x0000 },
  {   33, 0x0280 }, {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 },
  /* 0x0300 */
  {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 },
  {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 }, {   35, 0x0000 },
  {   35, 0x0000 }, {   35, 0xfffe }, {   50, 0x03fb }, {   59, 0xfffe },
  {   74, 0x03fb }, {   83, 0x0000 }, {   83, 0x0000 }, {   83, 0x0000 },
  /* 0x0400 */
  {   83, 0x0002 }, {   84, 0xffff }, {  100, 0xffff }, {  116, 0xffff },
  {  132, 0xffff }, {  148, 0x0002 }
};

static const aciConvSummary16 gb2312_uni2indx_page20[ /*101*/ ] = {
  /* 0x2000 */
  {  149, 0x0000 }, {  149, 0x3360 }, {  155, 0x0040 }, {  156, 0x080d },
  {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 },
  {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 },
  {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 }, {  160, 0x0000 },
  /* 0x2100 */
  {  160, 0x0008 }, {  161, 0x0040 }, {  162, 0x0000 }, {  162, 0x0000 },
  {  162, 0x0000 }, {  162, 0x0000 }, {  162, 0x0fff }, {  174, 0x0000 },
  {  174, 0x0000 }, {  174, 0x000f }, {  178, 0x0000 }, {  178, 0x0000 },
  {  178, 0x0000 }, {  178, 0x0000 }, {  178, 0x0000 }, {  178, 0x0000 },
  /* 0x2200 */
  {  178, 0x8100 }, {  180, 0x6402 }, {  184, 0x4fa1 }, {  192, 0x20f0 },
  {  197, 0x1100 }, {  199, 0x0000 }, {  199, 0xc033 }, {  205, 0x0000 },
  {  205, 0x0000 }, {  205, 0x0200 }, {  206, 0x0020 }, {  207, 0x0000 },
  {  207, 0x0000 }, {  207, 0x0000 }, {  207, 0x0000 }, {  207, 0x0000 },
  /* 0x2300 */
  {  207, 0x0000 }, {  207, 0x0004 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  /* 0x2400 */
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x03ff }, {  218, 0xfff0 },
  {  230, 0xffff }, {  246, 0x0fff }, {  258, 0x0000 }, {  258, 0x0000 },
  {  258, 0x0000 }, {  258, 0x0000 }, {  258, 0x0000 }, {  258, 0x0000 },
  /* 0x2500 */
  {  258, 0xffff }, {  274, 0xffff }, {  290, 0xffff }, {  306, 0xffff },
  {  322, 0x0fff }, {  334, 0x0000 }, {  334, 0x0000 }, {  334, 0x0000 },
  {  334, 0x0000 }, {  334, 0x0000 }, {  334, 0x0003 }, {  336, 0x000c },
  {  338, 0xc8c0 }, {  343, 0x0000 }, {  343, 0x0000 }, {  343, 0x0000 },
  /* 0x2600 */
  {  343, 0x0060 }, {  345, 0x0000 }, {  345, 0x0000 }, {  345, 0x0000 },
  {  345, 0x0005 }
};

static const aciConvSummary16 gb2312_uni2indx_page30[ /*35*/ ] = {
  /* 0x3000 */
  {  347, 0xff2f }, {  360, 0x00fb }, {  367, 0x0000 }, {  367, 0x0000 },
  {  367, 0xfffe }, {  382, 0xffff }, {  398, 0xffff }, {  414, 0xffff },
  {  430, 0xffff }, {  446, 0x000f }, {  450, 0xfffe }, {  465, 0xffff },
  {  481, 0xffff }, {  497, 0xffff }, {  513, 0xffff }, {  529, 0x087f },
  /* 0x3100 */
  {  537, 0xffe0 }, {  548, 0xffff }, {  564, 0x03ff }, {  574, 0x0000 },
  {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 },
  {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 },
  {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x0000 },
  /* 0x3200 */
  {  574, 0x0000 }, {  574, 0x0000 }, {  574, 0x03ff }
};

static const aciConvSummary16 gb2312_uni2indx_page4e[ /*1263*/ ] = {
  /* 0x4e00 */
  {  584, 0x7f8b }, {  595, 0x7f7b }, {  608, 0x3db4 }, {  617, 0xef55 },
  {  628, 0xfba8 }, {  638, 0xf35d }, {  649, 0x0243 }, {  653, 0x400b },
  {  657, 0xfb40 }, {  665, 0x8d3e }, {  674, 0x7bf7 }, {  687, 0x8c2c },
  {  693, 0x6eff }, {  706, 0xe3fa }, {  717, 0x1d3a }, {  725, 0xa8ed },
  /* 0x4f00 */
  {  734, 0xe602 }, {  740, 0xcf83 }, {  749, 0x8cf5 }, {  758, 0x3555 },
  {  766, 0xe048 }, {  771, 0xffab }, {  784, 0x92b9 }, {  792, 0xd859 },
  {  800, 0xab18 }, {  807, 0x2892 }, {  812, 0xd7e9 }, {  823, 0x8020 },
  {  825, 0xc438 }, {  831, 0xf583 }, {  840, 0xe74a }, {  849, 0x450a },
  /* 0x5000 */
  {  854, 0xb000 }, {  857, 0x9714 }, {  864, 0x7762 }, {  873, 0x5400 },
  {  876, 0xd188 }, {  882, 0x1420 }, {  885, 0x1020 }, {  887, 0xc8c0 },
  {  892, 0x2121 }, {  896, 0x0000 }, {  896, 0x13a8 }, {  902, 0x0c04 },
  {  905, 0x8000 }, {  906, 0x0440 }, {  908, 0x70c0 }, {  913, 0x0828 },
  /* 0x5100 */
  {  916, 0x08c0 }, {  919, 0x0004 }, {  920, 0x0002 }, {  921, 0x8000 },
  {  922, 0x2b7b }, {  932, 0x1472 }, {  938, 0x7924 }, {  945, 0x3bfb },
  {  957, 0x3327 }, {  965, 0x1ae4 }, {  972, 0x9835 }, {  979, 0x38ef },
  {  989, 0x9ad1 }, {  997, 0x2802 }, { 1000, 0xa813 }, { 1006, 0xbf69 },
  /* 0x5200 */
  { 1017, 0x65cf }, { 1027, 0x2fc6 }, { 1036, 0x6b11 }, { 1043, 0xafc9 },
  { 1053, 0x340f }, { 1060, 0x5053 }, { 1066, 0x86a2 }, { 1072, 0xa004 },
  { 1075, 0x0106 }, { 1078, 0xe809 }, { 1084, 0x3f0f }, { 1094, 0xc00e },
  { 1099, 0x0a88 }, { 1103, 0x8145 }, { 1108, 0x0010 }, { 1109, 0xc601 },
  /* 0x5300 */
  { 1114, 0xa161 }, { 1120, 0x26e1 }, { 1127, 0x444b }, { 1133, 0xce00 },
  { 1138, 0xc7aa }, { 1147, 0xd4ee }, { 1157, 0xcadf }, { 1168, 0x85bb },
  { 1177, 0x3a74 }, { 1185, 0xa520 }, { 1190, 0x436c }, { 1197, 0x8840 },
  { 1200, 0x3f06 }, { 1208, 0x8bd2 }, { 1216, 0xff79 }, { 1229, 0x3bef },
  /* 0x5400 */
  { 1241, 0xf75a }, { 1252, 0xe8ef }, { 1263, 0xfbcb }, { 1275, 0x5b36 },
  { 1284, 0x0d49 }, { 1290, 0x1bfd }, { 1301, 0x0154 }, { 1305, 0x39ee },
  { 1315, 0xd855 }, { 1323, 0x2e75 }, { 1332, 0xbfd8 }, { 1343, 0xa91a },
  { 1350, 0xf3d7 }, { 1362, 0xf6bf }, { 1375, 0x67e0 }, { 1383, 0xb40c },
  /* 0x5500 */
  { 1389, 0x82c2 }, { 1394, 0x0813 }, { 1398, 0xd49d }, { 1407, 0xd08b },
  { 1414, 0x065a }, { 1420, 0x1061 }, { 1424, 0x74f2 }, { 1433, 0x59e0 },
  { 1440, 0x8f9f }, { 1451, 0xb312 }, { 1458, 0x0080 }, { 1459, 0x6aaa },
  { 1467, 0x3230 }, { 1472, 0xb05e }, { 1480, 0x9d7a }, { 1490, 0x60ac },
  /* 0x5600 */
  { 1496, 0xd303 }, { 1503, 0xc900 }, { 1507, 0x3098 }, { 1512, 0x8a56 },
  { 1519, 0x7000 }, { 1522, 0x1390 }, { 1527, 0x1f14 }, { 1534, 0x1842 },
  { 1538, 0xc060 }, { 1542, 0x0008 }, { 1543, 0x8008 }, { 1545, 0x1080 },
  { 1547, 0x0400 }, { 1548, 0xec90 }, { 1555, 0x2817 }, { 1561, 0xe633 },
  /* 0x5700 */
  { 1570, 0x0758 }, { 1576, 0x9000 }, { 1578, 0xf708 }, { 1586, 0x4e09 },
  { 1592, 0xf485 }, { 1600, 0xfc83 }, { 1609, 0xaf53 }, { 1619, 0x18c8 },
  { 1624, 0x187c }, { 1631, 0x080c }, { 1634, 0x6adf }, { 1645, 0x0114 },
  { 1648, 0xc80c }, { 1653, 0xa734 }, { 1661, 0xa011 }, { 1665, 0x2710 },
  /* 0x5800 */
  { 1670, 0x28c5 }, { 1676, 0x4222 }, { 1680, 0x0413 }, { 1684, 0x0021 },
  { 1686, 0x3010 }, { 1689, 0x4112 }, { 1693, 0x1820 }, { 1696, 0x4000 },
  { 1697, 0x022b }, { 1702, 0xc60c }, { 1708, 0x0300 }, { 1710, 0x1000 },
  { 1711, 0x0022 }, { 1713, 0x0022 }, { 1715, 0x5810 }, { 1719, 0x0249 },
  /* 0x5900 */
  { 1723, 0xa094 }, { 1728, 0x9670 }, { 1735, 0xeeb0 }, { 1744, 0x1792 },
  { 1751, 0xcb96 }, { 1760, 0x05f2 }, { 1767, 0x0025 }, { 1770, 0x2358 },
  { 1776, 0x25de }, { 1785, 0x42cc }, { 1791, 0xcf38 }, { 1800, 0x4a04 },
  { 1804, 0x0c40 }, { 1807, 0x359f }, { 1817, 0x1128 }, { 1821, 0x8a00 },
  /* 0x5a00 */
  { 1824, 0x13fa }, { 1833, 0x910a }, { 1838, 0x0229 }, { 1842, 0x1056 },
  { 1847, 0x0641 }, { 1851, 0x0420 }, { 1853, 0x0484 }, { 1856, 0x84f0 },
  { 1862, 0x0000 }, { 1862, 0x0c04 }, { 1865, 0x0400 }, { 1866, 0x412c },
  { 1871, 0x1206 }, { 1875, 0x1154 }, { 1880, 0x0a4b }, { 1886, 0x0002 },
  /* 0x5b00 */
  { 1887, 0x0200 }, { 1888, 0x00c0 }, { 1890, 0x0000 }, { 1890, 0x0094 },
  { 1893, 0x0001 }, { 1894, 0xbfbb }, { 1907, 0x167c }, { 1915, 0x242b },
  { 1921, 0x9bbb }, { 1932, 0x7fa8 }, { 1942, 0x0c7f }, { 1951, 0xe379 },
  { 1961, 0x10f4 }, { 1967, 0xe00d }, { 1973, 0x4132 }, { 1978, 0x9f01 },
  /* 0x5c00 */
  { 1985, 0x8652 }, { 1991, 0x3572 }, { 1999, 0x10b4 }, { 2004, 0xff12 },
  { 2014, 0xcf27 }, { 2024, 0x4223 }, { 2029, 0xc06b }, { 2036, 0x8602 },
  { 2040, 0x3106 }, { 2045, 0x1fd3 }, { 2055, 0x3a0c }, { 2061, 0xa1aa },
  { 2068, 0x0812 }, { 2071, 0x0204 }, { 2073, 0x2572 }, { 2080, 0x0801 },
  /* 0x5d00 */
  { 2082, 0x40cc }, { 2087, 0x4850 }, { 2091, 0x62d0 }, { 2097, 0x6010 },
  { 2100, 0x1c80 }, { 2104, 0x2900 }, { 2107, 0x9a00 }, { 2111, 0x0010 },
  { 2112, 0x0004 }, { 2113, 0x2200 }, { 2115, 0x0000 }, { 2115, 0x0080 },
  { 2116, 0x2020 }, { 2118, 0x6800 }, { 2121, 0xcbe6 }, { 2131, 0x609e },
  /* 0x5e00 */
  { 2138, 0x916e }, { 2146, 0x3f73 }, { 2157, 0x60c0 }, { 2161, 0x3982 },
  { 2167, 0x1034 }, { 2171, 0x4830 }, { 2175, 0x0006 }, { 2177, 0xbd5c },
  { 2187, 0x8cd1 }, { 2194, 0xd6fb }, { 2206, 0x20e1 }, { 2211, 0x43e8 },
  { 2218, 0x0600 }, { 2220, 0x084e }, { 2225, 0x0500 }, { 2227, 0xc4d0 },
  /* 0x5f00 */
  { 2233, 0x8d1f }, { 2242, 0x89aa }, { 2249, 0xa6e1 }, { 2257, 0x1602 },
  { 2261, 0x0001 }, { 2262, 0x21ed }, { 2270, 0x3656 }, { 2278, 0x1a8b },
  { 2285, 0x1fb7 }, { 2296, 0x13a5 }, { 2303, 0x6502 }, { 2308, 0x30a0 },
  { 2312, 0xb278 }, { 2320, 0x23c7 }, { 2328, 0x6c93 }, { 2336, 0xe922 },
  /* 0x6000 */
  { 2343, 0xe47f }, { 2354, 0x3a74 }, { 2362, 0x8fe3 }, { 2372, 0x9820 },
  { 2376, 0x280e }, { 2381, 0x2625 }, { 2387, 0xbf9c }, { 2398, 0xbf49 },
  { 2408, 0x3218 }, { 2413, 0xac54 }, { 2420, 0xb949 }, { 2428, 0x1916 },
  { 2434, 0x0c60 }, { 2438, 0xb522 }, { 2445, 0xfbc1 }, { 2455, 0x0659 },
  /* 0x6100 */
  { 2461, 0xe343 }, { 2469, 0x8420 }, { 2472, 0x08d9 }, { 2478, 0x8000 },
  { 2479, 0x5500 }, { 2483, 0x2022 }, { 2486, 0x0184 }, { 2489, 0x00a1 },
  { 2492, 0x4800 }, { 2494, 0x2010 }, { 2496, 0x1380 }, { 2500, 0x4080 },
  { 2502, 0x0d04 }, { 2506, 0x0016 }, { 2509, 0x0040 }, { 2510, 0x8020 },
  /* 0x6200 */
  { 2512, 0xfd40 }, { 2520, 0x8de7 }, { 2530, 0x5436 }, { 2537, 0xe098 },
  { 2543, 0x7b8b }, { 2553, 0x091e }, { 2559, 0xfec8 }, { 2569, 0xd249 },
  { 2576, 0x0611 }, { 2580, 0x8dee }, { 2590, 0x1937 }, { 2598, 0xba22 },
  { 2605, 0x77f4 }, { 2616, 0x9fdd }, { 2628, 0xf3ec }, { 2639, 0xf0da },
  /* 0x6300 */
  { 2648, 0x4386 }, { 2654, 0xec42 }, { 2661, 0x8d3f }, { 2671, 0x2604 },
  { 2675, 0xfa6c }, { 2685, 0xc021 }, { 2689, 0x628e }, { 2696, 0x0cc2 },
  { 2701, 0xd785 }, { 2710, 0x0145 }, { 2714, 0x77ad }, { 2725, 0x5599 },
  { 2733, 0xe250 }, { 2739, 0x4045 }, { 2743, 0x260b }, { 2749, 0xa154 },
  /* 0x6400 */
  { 2755, 0x9827 }, { 2762, 0x5819 }, { 2768, 0x3443 }, { 2774, 0xa410 },
  { 2778, 0x05f2 }, { 2785, 0x4114 }, { 2789, 0x2280 }, { 2792, 0x0700 },
  { 2795, 0x00b4 }, { 2799, 0x4266 }, { 2805, 0x7210 }, { 2810, 0x15a1 },
  { 2816, 0x6025 }, { 2821, 0x4185 }, { 2826, 0x0054 }, { 2829, 0x0000 },
  /* 0x6500 */
  { 2829, 0x0201 }, { 2831, 0x0104 }, { 2833, 0xc820 }, { 2837, 0xcb70 },
  { 2845, 0x9320 }, { 2850, 0x6a62 }, { 2857, 0x184c }, { 2862, 0x0095 },
  { 2866, 0x1880 }, { 2869, 0x9a8b }, { 2877, 0xaab2 }, { 2885, 0x3201 },
  { 2889, 0xd87a }, { 2898, 0x00c4 }, { 2901, 0xf3e5 }, { 2912, 0x04c3 },
  /* 0x6600 */
  { 2917, 0xd44d }, { 2925, 0xa238 }, { 2931, 0xa1a1 }, { 2937, 0x5072 },
  { 2943, 0x980a }, { 2948, 0x84fc }, { 2956, 0xc152 }, { 2962, 0x44d1 },
  { 2968, 0x1094 }, { 2972, 0x20c2 }, { 2976, 0x4180 }, { 2979, 0x4210 },
  { 2982, 0x0000 }, { 2982, 0x3a00 }, { 2986, 0x0240 }, { 2988, 0xd29d },
  /* 0x6700 */
  { 2997, 0x2f01 }, { 3003, 0xa8b1 }, { 3010, 0xbd40 }, { 3017, 0x2432 },
  { 3022, 0xd34d }, { 3031, 0xd04b }, { 3038, 0xa723 }, { 3046, 0xd0ad },
  { 3054, 0x0a92 }, { 3059, 0x75a1 }, { 3067, 0xadac }, { 3076, 0x01e9 },
  { 3082, 0x801a }, { 3086, 0x771f }, { 3097, 0x9225 }, { 3103, 0xa01b },
  /* 0x6800 */
  { 3109, 0xdfa1 }, { 3119, 0x20ca }, { 3124, 0x0602 }, { 3127, 0x738c },
  { 3135, 0x577f }, { 3147, 0x003b }, { 3152, 0x0bff }, { 3163, 0x00d0 },
  { 3166, 0x806a }, { 3171, 0x0088 }, { 3173, 0xa1c4 }, { 3179, 0x0029 },
  { 3182, 0x2a05 }, { 3187, 0x0524 }, { 3191, 0x4009 }, { 3194, 0x1623 },
  /* 0x6900 */
  { 3200, 0x6822 }, { 3205, 0x8005 }, { 3208, 0x2011 }, { 3211, 0xa211 },
  { 3216, 0x0004 }, { 3217, 0x6490 }, { 3222, 0x4849 }, { 3227, 0x1382 },
  { 3232, 0x23d5 }, { 3240, 0x1930 }, { 3245, 0x2980 }, { 3249, 0x0892 },
  { 3253, 0x5402 }, { 3257, 0x8811 }, { 3261, 0x2001 }, { 3263, 0xa004 },
  /* 0x6a00 */
  { 3266, 0x0400 }, { 3267, 0x8180 }, { 3270, 0x8502 }, { 3274, 0x6022 },
  { 3278, 0x0090 }, { 3280, 0x0b01 }, { 3284, 0x0022 }, { 3286, 0x1202 },
  { 3289, 0x4011 }, { 3292, 0x0083 }, { 3295, 0x1a01 }, { 3299, 0x0000 },
  { 3299, 0x0000 }, { 3299, 0x0000 }, { 3299, 0x0000 }, { 3299, 0x0000 },
  /* 0x6b00 */
  { 3299, 0x0000 }, { 3299, 0x0000 }, { 3299, 0x009f }, { 3305, 0x4684 },
  { 3310, 0x12c8 }, { 3315, 0x0200 }, { 3316, 0x04fc }, { 3323, 0x1a00 },
  { 3326, 0x2ede }, { 3336, 0x0c4c }, { 3341, 0x0402 }, { 3343, 0x80b8 },
  { 3348, 0xa826 }, { 3354, 0x0afc }, { 3362, 0x8c02 }, { 3366, 0x2228 },
  /* 0x6c00 */
  { 3370, 0xa0e0 }, { 3375, 0x8f7b }, { 3386, 0xc7d6 }, { 3396, 0x2135 },
  { 3402, 0x06c7 }, { 3409, 0xf8b1 }, { 3418, 0x0713 }, { 3424, 0x6255 },
  { 3431, 0x936e }, { 3440, 0x8a19 }, { 3446, 0x6efa }, { 3457, 0xfb0e },
  { 3467, 0x1630 }, { 3472, 0x48f9 }, { 3480, 0xcd2f }, { 3490, 0x7deb },
  /* 0x6d00 */
  { 3502, 0x5892 }, { 3508, 0x4e84 }, { 3514, 0x4ca0 }, { 3519, 0x7a2e },
  { 3528, 0xedea }, { 3539, 0x561e }, { 3547, 0xc649 }, { 3554, 0x1190 },
  { 3558, 0x5324 }, { 3564, 0xe83a }, { 3572, 0xcfdb }, { 3584, 0x8124 },
  { 3588, 0x18f1 }, { 3595, 0x6342 }, { 3601, 0x5853 }, { 3608, 0x1a8a },
  /* 0x6e00 */
  { 3614, 0x7420 }, { 3619, 0x24d3 }, { 3626, 0xaa3b }, { 3635, 0x0514 },
  { 3639, 0x6018 }, { 3643, 0x8958 }, { 3649, 0x4800 }, { 3651, 0xc000 },
  { 3653, 0x8268 }, { 3658, 0x9101 }, { 3662, 0x84a4 }, { 3667, 0x2cd6 },
  { 3675, 0x8886 }, { 3680, 0xc4ba }, { 3688, 0x0377 }, { 3696, 0x0210 },
  /* 0x6f00 */
  { 3698, 0x8244 }, { 3702, 0x0038 }, { 3705, 0xae11 }, { 3712, 0x404a },
  { 3716, 0x28c0 }, { 3720, 0x5100 }, { 3723, 0x6044 }, { 3727, 0x1514 },
  { 3732, 0x7310 }, { 3738, 0x1000 }, { 3739, 0x0082 }, { 3741, 0x0248 },
  { 3744, 0x0205 }, { 3747, 0x4006 }, { 3750, 0xc003 }, { 3754, 0x0000 },
  /* 0x7000 */
  { 3754, 0x0000 }, { 3754, 0x0c02 }, { 3757, 0x0008 }, { 3758, 0x0220 },
  { 3760, 0x9000 }, { 3762, 0x4000 }, { 3763, 0xb800 }, { 3767, 0xd161 },
  { 3774, 0x4621 }, { 3779, 0x3274 }, { 3786, 0xf800 }, { 3791, 0x3b8a },
  { 3799, 0x050f }, { 3805, 0x8b00 }, { 3809, 0xbbd0 }, { 3818, 0x2280 },
  /* 0x7100 */
  { 3821, 0x0600 }, { 3823, 0x0769 }, { 3830, 0x8040 }, { 3832, 0x0043 },
  { 3835, 0x5420 }, { 3839, 0x5000 }, { 3841, 0x41d0 }, { 3846, 0x250c },
  { 3851, 0x8410 }, { 3854, 0x8310 }, { 3858, 0x1101 }, { 3861, 0x0228 },
  { 3864, 0x4008 }, { 3866, 0x0030 }, { 3868, 0x40a1 }, { 3872, 0x0200 },
  /* 0x7200 */
  { 3873, 0x0040 }, { 3874, 0x2000 }, { 3875, 0x1500 }, { 3878, 0xabe3 },
  { 3888, 0x3180 }, { 3892, 0xaa44 }, { 3898, 0xc2c6 }, { 3905, 0xc624 },
  { 3911, 0xac13 }, { 3918, 0x8004 }, { 3920, 0xb000 }, { 3923, 0x03d1 },
  { 3929, 0x611e }, { 3936, 0x4285 }, { 3941, 0xf303 }, { 3949, 0x1d9f },
  /* 0x7300 */
  { 3959, 0x440a }, { 3963, 0x78e8 }, { 3971, 0x5e26 }, { 3979, 0xc392 },
  { 3986, 0x2000 }, { 3987, 0x0085 }, { 3990, 0xb001 }, { 3994, 0x4000 },
  { 3995, 0x4a90 }, { 4000, 0x8842 }, { 4004, 0xca04 }, { 4009, 0x0c8d },
  { 4015, 0xa705 }, { 4022, 0x4203 }, { 4026, 0x22a1 }, { 4031, 0x0004 },
  /* 0x7400 */
  { 4032, 0x8668 }, { 4038, 0x0c01 }, { 4041, 0x5564 }, { 4048, 0x1079 },
  { 4054, 0x0002 }, { 4055, 0xdea0 }, { 4063, 0x2000 }, { 4064, 0x40c1 },
  { 4068, 0x488b }, { 4074, 0x5001 }, { 4077, 0x0380 }, { 4080, 0x0400 },
  { 4081, 0x0000 }, { 4081, 0x5004 }, { 4084, 0xc05d }, { 4091, 0x80d0 },
  /* 0x7500 */
  { 4095, 0xa010 }, { 4098, 0x970a }, { 4105, 0xbb20 }, { 4112, 0x4daf },
  { 4122, 0xd921 }, { 4129, 0x1e10 }, { 4134, 0x0460 }, { 4137, 0x8314 },
  { 4142, 0x8848 }, { 4146, 0xa6d6 }, { 4155, 0xd83b }, { 4164, 0x733f },
  { 4175, 0x27bc }, { 4184, 0x4974 }, { 4191, 0x0ddc }, { 4199, 0x9213 },
  /* 0x7600 */
  { 4205, 0x142b }, { 4211, 0x8ba1 }, { 4218, 0x2e75 }, { 4227, 0xd139 },
  { 4235, 0x3009 }, { 4239, 0x5050 }, { 4243, 0x8808 }, { 4246, 0x6900 },
  { 4250, 0x49d4 }, { 4257, 0x024a }, { 4261, 0x4010 }, { 4263, 0x8016 },
  { 4267, 0xe564 }, { 4275, 0x89d7 }, { 4284, 0xc020 }, { 4287, 0x5316 },
  /* 0x7700 */
  { 4294, 0x2b92 }, { 4301, 0x8600 }, { 4304, 0xa345 }, { 4311, 0x15e0 },
  { 4317, 0x008b }, { 4321, 0x0c03 }, { 4325, 0x196e }, { 4333, 0xe200 },
  { 4337, 0x7031 }, { 4343, 0x8006 }, { 4346, 0x16a5 }, { 4353, 0xa829 },
  { 4359, 0x2000 }, { 4360, 0x1880 }, { 4363, 0x7aac }, { 4372, 0xe148 },
  /* 0x7800 */
  { 4378, 0x3207 }, { 4384, 0xb5d6 }, { 4394, 0x32e8 }, { 4401, 0x5f91 },
  { 4410, 0x50a1 }, { 4415, 0x20e5 }, { 4421, 0x7c00 }, { 4426, 0x1080 },
  { 4428, 0x7280 }, { 4433, 0x9d8a }, { 4441, 0x00aa }, { 4445, 0x421f },
  { 4452, 0x0e22 }, { 4457, 0x0231 }, { 4461, 0x1100 }, { 4463, 0x0494 },
  /* 0x7900 */
  { 4467, 0x0022 }, { 4469, 0x4008 }, { 4471, 0x0010 }, { 4472, 0x5c10 },
  { 4477, 0x0343 }, { 4482, 0xfcc8 }, { 4491, 0xa1a5 }, { 4498, 0x0580 },
  { 4501, 0x8433 }, { 4507, 0x0400 }, { 4508, 0x0080 }, { 4509, 0x6e08 },
  { 4515, 0x2a4b }, { 4522, 0x8126 }, { 4527, 0xaad8 }, { 4535, 0x2901 },
  /* 0x7a00 */
  { 4539, 0x684d }, { 4546, 0x4490 }, { 4550, 0x0009 }, { 4552, 0xba88 },
  { 4559, 0x0040 }, { 4560, 0x0082 }, { 4562, 0x0000 }, { 4562, 0x87d1 },
  { 4570, 0x215b }, { 4577, 0xb1e6 }, { 4586, 0x3161 }, { 4592, 0x8008 },
  { 4594, 0x0800 }, { 4595, 0xc240 }, { 4599, 0xa069 }, { 4605, 0xa600 },
  /* 0x7b00 */
  { 4609, 0x8d58 }, { 4616, 0x4a32 }, { 4622, 0x5d71 }, { 4631, 0x550a },
  { 4637, 0x9aa0 }, { 4643, 0x2d57 }, { 4652, 0x4005 }, { 4655, 0x4aa6 },
  { 4662, 0x2021 }, { 4665, 0x30b1 }, { 4671, 0x3fc6 }, { 4681, 0x0112 },
  { 4684, 0x10c2 }, { 4688, 0x260a }, { 4693, 0x4462 }, { 4698, 0x5082 },
  /* 0x7c00 */
  { 4702, 0x9880 }, { 4706, 0x8040 }, { 4708, 0x04c0 }, { 4711, 0x8100 },
  { 4713, 0x2003 }, { 4716, 0x0000 }, { 4716, 0x0000 }, { 4716, 0x3818 },
  { 4721, 0x0200 }, { 4722, 0xf1a6 }, { 4731, 0x4434 }, { 4736, 0x720e },
  { 4743, 0x35a2 }, { 4750, 0x92e0 }, { 4756, 0x8101 }, { 4759, 0x0900 },
  /* 0x7d00 */
  { 4761, 0x0400 }, { 4762, 0x0000 }, { 4762, 0x8885 }, { 4767, 0x0000 },
  { 4767, 0x0000 }, { 4767, 0x0000 }, { 4767, 0x4000 }, { 4768, 0x0080 },
  { 4769, 0x0000 }, { 4769, 0x0000 }, { 4769, 0x4040 }, { 4771, 0x0000 },
  { 4771, 0x0000 }, { 4771, 0x0000 }, { 4771, 0x0000 }, { 4771, 0x0000 },
  /* 0x7e00 */
  { 4771, 0x0000 }, { 4771, 0x0000 }, { 4771, 0x0000 }, { 4771, 0x0800 },
  { 4772, 0x0082 }, { 4774, 0x0000 }, { 4774, 0x0000 }, { 4774, 0x0000 },
  { 4774, 0x0004 }, { 4775, 0x8800 }, { 4777, 0xbfff }, { 4792, 0xe7ef },
  { 4805, 0xffff }, { 4821, 0xffbf }, { 4836, 0xefef }, { 4850, 0xfdff },
  /* 0x7f00 */
  { 4865, 0xfbff }, { 4880, 0xbffe }, { 4894, 0xffff }, { 4910, 0x057f },
  { 4919, 0x0034 }, { 4922, 0x85b3 }, { 4930, 0x4706 }, { 4936, 0x4216 },
  { 4941, 0x5402 }, { 4945, 0xe410 }, { 4950, 0x8092 }, { 4954, 0xb305 },
  { 4961, 0x5422 }, { 4966, 0x8130 }, { 4970, 0x4263 }, { 4976, 0x180b },
  /* 0x8000 */
  { 4981, 0x387b }, { 4990, 0x13f5 }, { 4999, 0x07e5 }, { 5007, 0xa9ea },
  { 5016, 0x3c4c }, { 5023, 0x0514 }, { 5027, 0x0600 }, { 5029, 0x8002 },
  { 5031, 0x1ad9 }, { 5039, 0xbd48 }, { 5047, 0xee37 }, { 5058, 0xf496 },
  { 5067, 0x705f }, { 5076, 0x7ec0 }, { 5084, 0xbfb2 }, { 5095, 0x355f },
  /* 0x8100 */
  { 5105, 0xe644 }, { 5112, 0x455f }, { 5121, 0x9000 }, { 5123, 0x4146 },
  { 5128, 0x1d40 }, { 5133, 0x063b }, { 5140, 0x62a1 }, { 5146, 0xfe13 },
  { 5156, 0x8505 }, { 5161, 0x3902 }, { 5166, 0x0548 }, { 5170, 0x0c08 },
  { 5173, 0x144f }, { 5180, 0x0000 }, { 5180, 0x3488 }, { 5185, 0x5818 },
  /* 0x8200 */
  { 5190, 0x3077 }, { 5198, 0xd815 }, { 5205, 0xbd0e }, { 5214, 0x4bfb },
  { 5225, 0x8a90 }, { 5230, 0x8500 }, { 5233, 0xc100 }, { 5236, 0xe61d },
  { 5245, 0xed14 }, { 5253, 0xb386 }, { 5261, 0xff72 }, { 5273, 0x639b },
  { 5282, 0xfd92 }, { 5292, 0xd9be }, { 5303, 0x887b }, { 5311, 0x0a92 },
  /* 0x8300 */
  { 5316, 0xd3fe }, { 5328, 0x1cb2 }, { 5335, 0xb980 }, { 5341, 0x177a },
  { 5350, 0x82c9 }, { 5356, 0xdc17 }, { 5365, 0xfffb }, { 5380, 0x3980 },
  { 5385, 0x4260 }, { 5389, 0x590c }, { 5395, 0x0f01 }, { 5400, 0x37df },
  { 5412, 0x94a3 }, { 5419, 0xb150 }, { 5425, 0x0623 }, { 5430, 0x2307 },
  /* 0x8400 */
  { 5436, 0xf85a }, { 5445, 0x3102 }, { 5449, 0x01f0 }, { 5454, 0x3102 },
  { 5458, 0x0040 }, { 5459, 0x1e82 }, { 5465, 0x3a0a }, { 5471, 0x056a },
  { 5477, 0x5b84 }, { 5484, 0x1280 }, { 5487, 0x8002 }, { 5489, 0xa714 },
  { 5496, 0x2612 }, { 5501, 0xa04b }, { 5507, 0x1069 }, { 5512, 0x9001 },
  /* 0x8500 */
  { 5515, 0x1000 }, { 5516, 0x848a }, { 5521, 0x1802 }, { 5524, 0x3f80 },
  { 5531, 0x0708 }, { 5535, 0x4240 }, { 5538, 0x0110 }, { 5540, 0x4e14 },
  { 5546, 0x80b0 }, { 5550, 0x1800 }, { 5552, 0xc510 }, { 5557, 0x0281 },
  { 5560, 0x8202 }, { 5563, 0x1029 }, { 5567, 0x0210 }, { 5569, 0x8800 },
  /* 0x8600 */
  { 5571, 0x0020 }, { 5572, 0x0042 }, { 5574, 0x0280 }, { 5576, 0x1100 },
  { 5578, 0xe000 }, { 5581, 0x4413 }, { 5586, 0x5804 }, { 5590, 0xfe02 },
  { 5598, 0x3c07 }, { 5605, 0x3028 }, { 5609, 0x9798 }, { 5617, 0x0473 },
  { 5623, 0xced1 }, { 5632, 0xcb13 }, { 5640, 0x6210 }, { 5644, 0x431f },
  /* 0x8700 */
  { 5652, 0x278d }, { 5660, 0x55ac }, { 5668, 0x422e }, { 5674, 0xc892 },
  { 5680, 0x5380 }, { 5685, 0x0288 }, { 5688, 0x4039 }, { 5693, 0x7851 },
  { 5700, 0x292c }, { 5706, 0x8088 }, { 5709, 0xb900 }, { 5714, 0x2428 },
  { 5718, 0x0c41 }, { 5722, 0x080e }, { 5726, 0x4421 }, { 5730, 0x4200 },
  /* 0x8800 */
  { 5732, 0x0408 }, { 5734, 0x0868 }, { 5738, 0x0006 }, { 5740, 0x1204 },
  { 5743, 0x3031 }, { 5748, 0x0290 }, { 5751, 0x5b3e }, { 5761, 0xe085 },
  { 5767, 0x2936 }, { 5774, 0x1044 }, { 5777, 0x2814 }, { 5781, 0x1082 },
  { 5784, 0x4266 }, { 5790, 0x8334 }, { 5796, 0x013c }, { 5801, 0x531b },
  /* 0x8900 */
  { 5809, 0x0404 }, { 5811, 0x0e0d }, { 5817, 0x0c22 }, { 5821, 0x0051 },
  { 5824, 0x0012 }, { 5826, 0xc000 }, { 5828, 0x0040 }, { 5829, 0x8800 },
  { 5831, 0x004a }, { 5834, 0x0000 }, { 5834, 0x0000 }, { 5834, 0x0000 },
  { 5834, 0xdff6 }, { 5847, 0x5447 }, { 5854, 0x8868 }, { 5859, 0x0008 },
  /* 0x8a00 */
  { 5860, 0x0081 }, { 5862, 0x0000 }, { 5862, 0x0000 }, { 5862, 0x4000 },
  { 5863, 0x0100 }, { 5864, 0x0000 }, { 5864, 0x0000 }, { 5864, 0x0200 },
  { 5865, 0x0600 }, { 5867, 0x0008 }, { 5868, 0x0000 }, { 5868, 0x0000 },
  { 5868, 0x0000 }, { 5868, 0x0000 }, { 5868, 0x0000 }, { 5868, 0x0000 },
  /* 0x8b00 */
  { 5868, 0x0080 }, { 5869, 0x0000 }, { 5869, 0x0040 }, { 5870, 0x0000 },
  { 5870, 0x0000 }, { 5870, 0x0000 }, { 5870, 0x1040 }, { 5872, 0x0000 },
  { 5872, 0x0000 }, { 5872, 0x0000 }, { 5872, 0xefff }, { 5887, 0xf7fd },
  { 5901, 0xff7f }, { 5916, 0xfffe }, { 5931, 0xfbff }, { 5946, 0xffff },
  /* 0x8c00 */
  { 5962, 0xfdff }, { 5977, 0xbfff }, { 5992, 0xffff }, { 6008, 0x00ff },
  { 6016, 0x12c2 }, { 6021, 0x0420 }, { 6023, 0x0c06 }, { 6027, 0x0708 },
  { 6031, 0x1624 }, { 6036, 0x0110 }, { 6038, 0x0000 }, { 6038, 0x0000 },
  { 6038, 0x0000 }, { 6038, 0x0000 }, { 6038, 0x0000 }, { 6038, 0x0000 },
  /* 0x8d00 */
  { 6038, 0x0000 }, { 6038, 0xe000 }, { 6041, 0xfffe }, { 6056, 0xffff },
  { 6072, 0xffff }, { 6088, 0x7f79 }, { 6100, 0x28df }, { 6109, 0x00f9 },
  { 6115, 0x0c32 }, { 6120, 0x8012 }, { 6123, 0x0008 }, { 6124, 0xd53a },
  { 6133, 0xd858 }, { 6140, 0xecc2 }, { 6148, 0x9d18 }, { 6155, 0x2fa8 },
  /* 0x8e00 */
  { 6163, 0x9620 }, { 6168, 0xe010 }, { 6172, 0xd60c }, { 6179, 0x2622 },
  { 6184, 0x0f97 }, { 6193, 0x0206 }, { 6196, 0xb240 }, { 6201, 0x9055 },
  { 6207, 0x80a2 }, { 6211, 0x5011 }, { 6215, 0x9800 }, { 6218, 0x0404 },
  { 6220, 0x4000 }, { 6221, 0x0000 }, { 6221, 0x0000 }, { 6221, 0x0000 },
  /* 0x8f00 */
  { 6221, 0x0000 }, { 6221, 0x0000 }, { 6221, 0x0000 }, { 6221, 0x0000 },
  { 6221, 0x0000 }, { 6221, 0x0000 }, { 6221, 0xfbc0 }, { 6230, 0xffff },
  { 6246, 0xeffe }, { 6260, 0xdffb }, { 6274, 0x0b08 }, { 6278, 0x6243 },
  { 6284, 0x41b6 }, { 6291, 0xfb3b }, { 6303, 0x6f74 }, { 6313, 0x2389 },
  /* 0x9000 */
  { 6319, 0xae7f }, { 6331, 0xecd7 }, { 6342, 0xe047 }, { 6349, 0x5960 },
  { 6355, 0xa096 }, { 6361, 0x098f }, { 6368, 0x612c }, { 6374, 0xa030 },
  { 6378, 0x090d }, { 6383, 0x2aaa }, { 6390, 0xd44e }, { 6398, 0x4f7b },
  { 6409, 0xc4b2 }, { 6416, 0x388b }, { 6423, 0xa9c6 }, { 6431, 0x6110 },
  /* 0x9100 */
  { 6435, 0x0014 }, { 6437, 0x4200 }, { 6439, 0x800c }, { 6442, 0x0202 },
  { 6444, 0xfe48 }, { 6453, 0x6485 }, { 6459, 0xd63e }, { 6469, 0xe3f7 },
  { 6481, 0x3aa0 }, { 6487, 0x0c07 }, { 6492, 0xe40c }, { 6498, 0x0430 },
  { 6501, 0xf680 }, { 6508, 0x1002 }, { 6510, 0x0000 }, { 6510, 0x0000 },
  /* 0x9200 */
  { 6510, 0x0000 }, { 6510, 0x0000 }, { 6510, 0x0000 }, { 6510, 0x0000 },
  { 6510, 0x0000 }, { 6510, 0x0000 }, { 6510, 0x0000 }, { 6510, 0x0010 },
  { 6511, 0x4000 }, { 6512, 0x0000 }, { 6512, 0x4000 }, { 6513, 0x0000 },
  { 6513, 0x0100 }, { 6514, 0x0000 }, { 6514, 0x0000 }, { 6514, 0x0000 },
  /* 0x9300 */
  { 6514, 0x0000 }, { 6514, 0x0000 }, { 6514, 0x0000 }, { 6514, 0x4000 },
  { 6515, 0x0000 }, { 6515, 0x0000 }, { 6515, 0x0400 }, { 6516, 0x0000 },
  { 6516, 0x8000 }, { 6517, 0x0000 }, { 6517, 0x0000 }, { 6517, 0x0000 },
  { 6517, 0x0400 }, { 6518, 0x0040 }, { 6519, 0x0000 }, { 6519, 0x0000 },
  /* 0x9400 */
  { 6519, 0x0000 }, { 6519, 0x0000 }, { 6519, 0x0000 }, { 6519, 0x4000 },
  { 6520, 0x0000 }, { 6520, 0x0000 }, { 6520, 0x0800 }, { 6521, 0x0000 },
  { 6521, 0xffe0 }, { 6532, 0xfebd }, { 6545, 0xffff }, { 6561, 0xffff },
  { 6577, 0x7f7f }, { 6591, 0xfbe7 }, { 6604, 0xffbf }, { 6619, 0xf7ff },
  /* 0x9500 */
  { 6634, 0xffff }, { 6650, 0xefff }, { 6665, 0xff7e }, { 6679, 0xdff7 },
  { 6693, 0xf6f7 }, { 6706, 0xfbdf }, { 6720, 0xbffe }, { 6734, 0x804f },
  { 6740, 0x0000 }, { 6740, 0x0000 }, { 6740, 0x0000 }, { 6740, 0x0000 },
  { 6740, 0x0000 }, { 6740, 0x0000 }, { 6740, 0xef00 }, { 6747, 0x7fff },
  /* 0x9600 */
  { 6762, 0xff7f }, { 6777, 0xb6f7 }, { 6789, 0x4406 }, { 6793, 0xb87e },
  { 6803, 0x3bf5 }, { 6814, 0x8831 }, { 6819, 0x1796 }, { 6827, 0x00f4 },
  { 6832, 0xa960 }, { 6838, 0x1391 }, { 6844, 0x0080 }, { 6845, 0x7249 },
  { 6852, 0xf2f3 }, { 6863, 0x0024 }, { 6865, 0x8701 }, { 6870, 0x42c8 },
  /* 0x9700 */
  { 6875, 0xe3d3 }, { 6885, 0x5048 }, { 6889, 0x2400 }, { 6891, 0x4305 },
  { 6896, 0x0000 }, { 6896, 0x4a4c }, { 6902, 0x0227 }, { 6907, 0x1058 },
  { 6911, 0x2820 }, { 6914, 0x0116 }, { 6918, 0xa809 }, { 6923, 0x0014 },
  { 6925, 0x0000 }, { 6925, 0x0000 }, { 6925, 0x3ec0 }, { 6932, 0x0068 },
  /* 0x9800 */
  { 6935, 0x0000 }, { 6935, 0x0000 }, { 6935, 0x0000 }, { 6935, 0x0000 },
  { 6935, 0x0000 }, { 6935, 0x0000 }, { 6935, 0x0000 }, { 6935, 0xffe0 },
  { 6946, 0xb7ff }, { 6960, 0xfddb }, { 6973, 0x00f7 }, { 6980, 0x0000 },
  { 6980, 0x4000 }, { 6981, 0xc72e }, { 6990, 0x0180 }, { 6992, 0x0000 },
  /* 0x9900 */
  { 6992, 0x2000 }, { 6993, 0x0001 }, { 6994, 0x4000 }, { 6995, 0x0000 },
  { 6995, 0x0000 }, { 6995, 0x0030 }, { 6997, 0xffa8 }, { 7008, 0xb4f7 },
  { 7019, 0xadf3 }, { 7030, 0x03ff }, { 7040, 0x0120 }, { 7042, 0x0000 },
  { 7042, 0x0000 }, { 7042, 0x0000 }, { 7042, 0x0000 }, { 7042, 0x0000 },
  /* 0x9a00 */
  { 7042, 0x0000 }, { 7042, 0x0000 }, { 7042, 0x0000 }, { 7042, 0x0000 },
  { 7042, 0x0000 }, { 7042, 0x0000 }, { 7042, 0xf000 }, { 7046, 0xfffb },
  { 7061, 0x9df7 }, { 7073, 0xfdcf }, { 7086, 0x01bf }, { 7094, 0x15c3 },
  { 7101, 0x1827 }, { 7107, 0x810a }, { 7111, 0xa842 }, { 7116, 0x0a00 },
  /* 0x9b00 */
  { 7118, 0x8108 }, { 7121, 0x8008 }, { 7123, 0x8008 }, { 7125, 0x1804 },
  { 7128, 0xa3be }, { 7138, 0x0012 }, { 7140, 0x0000 }, { 7140, 0x0000 },
  { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 },
  { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 },
  /* 0x9c00 */
  { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 },
  { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x0000 }, { 7140, 0x9000 },
  { 7142, 0x69e6 }, { 7151, 0xdc37 }, { 7161, 0x6bff }, { 7174, 0x3dff },
  { 7187, 0xfcf8 }, { 7198, 0xf3f9 }, { 7210, 0x0004 }
};

static const aciConvSummary16 gb2312_uni2indx_page9e[ /*27*/ ] = {
  /* 0x9e00 */
  { 7211, 0x0000 }, { 7211, 0x8000 }, { 7212, 0xbf6f }, { 7225, 0xe7ee },
  { 7237, 0xdffe }, { 7251, 0x5da2 }, { 7259, 0x3fd8 }, { 7269, 0xc00b },
  { 7274, 0x0984 }, { 7278, 0xa00c }, { 7282, 0x0040 }, { 7283, 0x6910 },
  { 7288, 0xe210 }, { 7293, 0xb912 }, { 7300, 0x86a5 }, { 7307, 0x5a00 },
  /* 0x9f00 */
  { 7311, 0x6800 }, { 7314, 0x0289 }, { 7318, 0x9005 }, { 7322, 0x6a80 },
  { 7327, 0x0010 }, { 7328, 0x0003 }, { 7330, 0x0000 }, { 7330, 0x8000 },
  { 7331, 0x1ff9 }, { 7342, 0x8e00 }, { 7346, 0x0001 }
};

static const aciConvSummary16 gb2312_uni2indx_pageff[ /*15*/ ] = {
  /* 0xff00 */
  { 7347, 0xfffe }, { 7362, 0xffff }, { 7378, 0xffff }, { 7394, 0xffff },
  { 7410, 0xffff }, { 7426, 0x7fff }, { 7441, 0x0000 }, { 7441, 0x0000 },
  { 7441, 0x0000 }, { 7441, 0x0000 }, { 7441, 0x0000 }, { 7441, 0x0000 },
  { 7441, 0x0000 }, { 7441, 0x0000 }, { 7441, 0x002b }
};

ACP_EXPORT
acp_sint32_t aciConvConvertMbToWc4Gb2312( void         * aSrc,
                                          acp_sint32_t   aSrcRemain,
                                          acp_sint32_t * aSrcAdvance,
                                          void         * aDest,
                                          acp_sint32_t   aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      GB2312 ==> UTF16
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t  * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint8_t    sSrcChar[2];
    acp_uint32_t   sNum;
    acp_sint32_t   sRet;
    acp_uint16_t   sWc;

    /* Code set 0 (ASCII) */
    if ( sSrcCharPtr[0] < 0x80 )
    {
        sRet = aciConvConvertMbToWc4Ascii(aSrc,
                                          aSrcRemain,
                                          aSrcAdvance,
                                          aDest,
                                          aDestRemain);
    }
    else
    {
        if ( ( sSrcCharPtr[1] >= 0xa1 ) && ( sSrcCharPtr[1] < 0xff ) )
        {
            if ( aSrcRemain < 2 )
            {
                sRet = ACICONV_RET_TOOFEW;
                *aSrcAdvance = aSrcRemain;
            }
            else
            {
                /* BUG-29135
                 * GB231280 code page 0x80  ؾ Ѵ.
                 */
                sSrcChar[0] = sSrcCharPtr[0] - 0x80;
                sSrcChar[1] = sSrcCharPtr[1] - 0x80;

                sNum = 94 * ( sSrcChar[0] - 0x21 ) + ( sSrcChar[1] - 0x21 );

                sWc = 0xfffd;

                if ( sNum < 1410 )
                {
                    if ( sNum < 831 )
                    {
                        sWc = gb2312_2uni_page21[sNum] ^ GB2312_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else
                {
                    if ( sNum < 8178 )
                    {
                        sWc = gb2312_2uni_page30[sNum-1410] ^ GB2312_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }

                if ( sWc != 0xfffd )
                {
                    ACICONV_WC_TO_UTF16BE( aDest, sWc );

                    sRet = 2;
                    *aSrcAdvance = 2;
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
        }
        else
        {
            sRet = ACICONV_RET_ILSEQ;
            *aSrcAdvance = 1;
        }
    }

    return sRet;
}

ACP_EXPORT
acp_sint32_t aciConvConvertWcToMb4Gb2312( void         * aSrc,
                                          acp_sint32_t   aSrcRemain,
                                          acp_sint32_t * aSrcAdvance,
                                          void         * aDest,
                                          acp_sint32_t   aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      GB2312 <== UTF16
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16 * sSummary = NULL;
    acp_uint16_t             sUsed;
    acp_uint8_t            * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_uint8_t              sDestChar[2];
    acp_uint32_t             sNum;
    acp_sint32_t             sRet;
    acp_uint16_t             sVal;
    acp_uint16_t             sWc;

    sRet = aciConvConvertWcToMb4Ascii( aSrc,
                                       aSrcRemain,
                                       aSrcAdvance,
                                       aDest,
                                       aDestRemain );

    if( sRet != ACICONV_RET_ILUNI )
    {
        /* Nothing to do */
    }
    else
    {
        if ( aDestRemain < 2 )
        {
            sRet = ACICONV_RET_TOOSMALL;
            *aSrcAdvance = 2;
        }
        else
        {
            ACICONV_UTF16BE_TO_WC( sWc, aSrc );

            if ( sWc < 0x0460 )
            {
                sSummary = &gb2312_uni2indx_page00[(sWc>>4)];
            }
            else if ( ( sWc >= 0x2000 ) && ( sWc < 0x2650 ) )
            {
                sSummary = &gb2312_uni2indx_page20[(sWc>>4)-0x200];
            }
            else if ( ( sWc >= 0x3000 ) && ( sWc < 0x3230 ) )
            {
                sSummary = &gb2312_uni2indx_page30[(sWc>>4)-0x300];
            }
            else if ( ( sWc >= 0x4e00 ) && ( sWc < 0x9cf0 ) )
            {
                sSummary = &gb2312_uni2indx_page4e[(sWc>>4)-0x4e0];
            }
            else if ( ( sWc >= 0x9e00 ) && ( sWc < 0x9fb0 ) )
            {
                sSummary = &gb2312_uni2indx_page9e[(sWc>>4)-0x9e0];
            }
            else if ( ( sWc >= 0xff00 ) && ( sWc < 0xfff0 ) )
            {
                sSummary = &gb2312_uni2indx_pageff[(sWc>>4)-0xff0];
            }
            else
            {
                /* Nothing to do */
            }

            if ( sSummary != NULL )
            {
                sUsed = sSummary->used;

                sNum = sWc & 0x0f;

                if ( sUsed & ( (acp_uint16_t) 1 << sNum ) )
                {
                    sUsed &= ( (acp_uint16_t) 1 << sNum ) - 1;

                    sUsed = ( sUsed & 0x5555 ) + ( ( sUsed & 0xaaaa ) >> 1 );
                    sUsed = ( sUsed & 0x3333 ) + ( ( sUsed & 0xcccc ) >> 2 );
                    sUsed = ( sUsed & 0x0f0f ) + ( ( sUsed & 0xf0f0 ) >> 4 );
                    sUsed = ( sUsed & 0x00ff ) + ( sUsed >> 8 );

                    sVal = gb2312_2charset[sSummary->indx + sUsed]
                        ^ GB2312_XOR_VALUE;

                    sDestChar[0] = ( sVal >> 8 );
                    sDestChar[1] = ( sVal & 0xff );

                    /*
                     * BUG-29135
                     * GB231280 code page 0x80 ؼ ؾ Ѵ.
                     */
                    sDestCharPtr[0] = sDestChar[0] + 0x80;
                    sDestCharPtr[1] = sDestChar[1] + 0x80;

                    sRet = 2;
                    *aSrcAdvance = 2;
                }
                else
                {
                    sRet = ACICONV_RET_ILUNI;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvCopyGb2312( void         * aSrc,
                                           acp_sint32_t   aSrcRemain,
                                           acp_sint32_t * aSrcAdvance,
                                           void         * aDest,
                                           acp_sint32_t   aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *     PROJ-2414 [ɼ] GBK, CP936 character set ߰
 *     ex) GB2312 ==> GBK
 *                ==> CP936
 *                ==> GB18030
 *
 * Implementation :  ĳ  Լ    ϴ.
 *
 ***********************************************************************/

    acp_uint8_t  * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint8_t  * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_sint32_t   sRet;

    /* PROJ-2414 [ɼ] GBK, CP936 character set ߰ */
    if ( sSrcCharPtr[0] < 0x80 )
    {
        *sDestCharPtr = *sSrcCharPtr;

        *aSrcAdvance = 1;
        sRet = 1;
    }
    else
    {
        if( ( sSrcCharPtr[0] >= 0xa1 ) && ( sSrcCharPtr[0] < 0xff ) )
        {
            if ( aSrcRemain < 2 )
            {
                *aSrcAdvance = aSrcRemain;
                sRet = ACICONV_RET_TOOFEW;
            }
            else
            {
                if ( aDestRemain < 2 )
                {
                    *aSrcAdvance = 2;
                    sRet = ACICONV_RET_TOOSMALL;
                }
                else
                {
                    sDestCharPtr[0] = sSrcCharPtr[0];
                    sDestCharPtr[1] = sSrcCharPtr[1];

                    *aSrcAdvance = 2;
                    sRet = 2;
                }
            }
        }
        else
        {
            *aSrcAdvance = 1;
            sRet = ACICONV_RET_ILSEQ;
        }
    }

    return sRet;
}
