/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvJisx0212.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvJisx0212.h>

static const acp_uint16_t jisx0212_2uni_page22[ /*81*/ ] = {
  /* 0x22 */
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0x06d5, 0x06ca,
  0x04b5, 0x06d4, 0x06d0, 0x04a2, 0x06d6, 0x06d7, 0xfb53, 0x0789,
  0x0788, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x04ac, 0x04ab, 0x04b2, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0x04b7, 0x04a7, 0x04a4, 0x04a3, 0x252f, 0x04a9,
  0x251b
};

static const acp_uint16_t jisx0212_2uni_page26[ /*188*/ ] = {
  /* 0x26 */
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x078b, 0x0785, 0x0784, 0x0787, 0x07a7, 0xfbf0, 0x0781, 0xfbf0,
  0x0783, 0x07a6, 0xfbf0, 0x0782, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x07a1, 0x07a0, 0x07a3, 0x07a2, 0x07c7, 0x079d, 0x07c1, 0x07cf,
  0x07c0, 0x07c6, 0x07bd, 0x07c3, 0xfbf0, 0xfbf0,
  /* 0x27 */
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x000f, 0x000e, 0x0009, 0x0008, 0x000b, 0x000a, 0x0005,
  0x0004, 0x0007, 0x0006, 0x0001, 0x0003, 0x0002, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x005f, 0x005e, 0x0059, 0x0058, 0x005b, 0x005a, 0x0055,
  0x0054, 0x0057, 0x0056, 0x0051, 0x0053, 0x0052
};

static const acp_uint16_t jisx0212_2uni_page29[ /*275*/ ] = {
  /* 0x29 */
  0x04cb, 0x051d, 0xfbf0, 0x052b, 0xfbf0, 0x053f, 0xfbf0, 0x054c,
  0x0532, 0xfbf0, 0x0547, 0x04d5, 0x055f, 0xfbf0, 0x056b, 0x04d3,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x04eb, 0x051c, 0x04fd, 0x052a, 0x053c, 0x053e, 0x0535, 0x054f,
  0x054d, 0x0544, 0x0546, 0x04f5, 0x055e, 0x04d2, 0x056a, 0x04f3,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x2a */
  0x04cc, 0x04cd, 0x04c9, 0x04cf, 0x050f, 0x05c0, 0x050d, 0x0509,
  0x04c8, 0x04ce, 0x050b, 0x0505, 0x0501, 0x04ca, 0x0507, 0x0503,
  0x04c4, 0x04c5, 0x04c6, 0x04c7, 0x0517, 0x051b, 0x051f, 0x0515,
  0xfbf0, 0x0511, 0x0513, 0x052f, 0x052d, 0x0529, 0x04c0, 0x04c1,
  0x04c2, 0x04c3, 0x05c2, 0x053d, 0x0527, 0x0523, 0x0525, 0x0539,
  0x053b, 0x0534, 0x0530, 0x0536, 0x054e, 0x054a, 0x0548, 0x04dc,
  0x04de, 0x04df, 0x04db, 0x04d9, 0x05dc, 0x055d, 0x0541, 0x04d8,
  0x0559, 0x0555, 0x055b, 0x0557, 0x0551, 0x056d, 0x0553, 0x0569,
  0x056f, 0x04d7, 0x04d4, 0x04d1, 0x04d6, 0x0561, 0x05de, 0x057d,
  0x0567, 0x057f, 0x0563, 0x0565, 0x05da, 0x05d6, 0x05d4, 0x05d8,
  0x0579, 0x04d0, 0x0575, 0x057b, 0x0574, 0x0570, 0x0576, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x2b */
  0x04ec, 0x04ed, 0x04e9, 0x04ef, 0x050e, 0x05c3, 0x050c, 0x0508,
  0x04e8, 0x04ee, 0x050a, 0x0504, 0x0500, 0x04ea, 0x0506, 0x0502,
  0x04e4, 0x04e5, 0x04e6, 0x04e7, 0x0516, 0x051a, 0x051e, 0x0514,
  0x05f8, 0x0510, 0x0512, 0xfbf0, 0x052c, 0x0528, 0x04e0, 0x04e1,
  0x04e2, 0x04e3, 0x05dd, 0xfbf0, 0x0526, 0x0522, 0x0524, 0x0538,
  0x053a, 0x0537, 0x0533, 0x0531, 0x0549, 0x0545, 0x054b, 0x04fc,
  0x04fe, 0x04ff, 0x04fb, 0x04f9, 0x05df, 0x055c, 0x0540, 0x04f8,
  0x0558, 0x0554, 0x055a, 0x0556, 0x0550, 0x056c, 0x0552, 0x0568,
  0x056e, 0x04f7, 0x04f4, 0x04f1, 0x04f6, 0x0560, 0x05d9, 0x057c,
  0x0566, 0x057e, 0x0562, 0x0564, 0x05d5, 0x05d1, 0x05d7, 0x05db,
  0x0578, 0x04f0, 0x04f2, 0x057a, 0x0577, 0x0573, 0x0571
};

static const acp_uint16_t jisx0212_2uni_page30[ /*5801*/ ] = {
  /* 0x30 */
  0x4a0f, 0x4a09, 0x4a08, 0x4a01, 0x4a1f, 0x4a12, 0x4a2e, 0x4a29,
  0x4a25, 0x4a26, 0x4a23, 0x4a22, 0x4a3d, 0x4a38, 0x4a4d, 0x4a4c,
  0x4a49, 0x4a4a, 0x4a5c, 0x4a57, 0x4a51, 0x4a6e, 0x4a65, 0x4a64,
  0x4a79, 0x4a78, 0x4a74, 0x4a72, 0x4a80, 0x4a9b, 0x4a9a, 0x4a90,
  0x4aa2, 0x4ab4, 0x4ace, 0x4add, 0x4ad7, 0x4ad6, 0x4aed, 0x4aec,
  0x4aef, 0x4ae5, 0x4ae2, 0x4afc, 0x4afe, 0x4af8, 0x4af0, 0x4af3,
  0x4af2, 0x4b0d, 0x4b0f, 0x4b0e, 0x4b05, 0x4b06, 0x4b01, 0x4b1f,
  0x4b18, 0x4b1b, 0x4b1a, 0x4b14, 0x4b23, 0x4b3c, 0x4b6d, 0x4b3e,
  0x4b38, 0x4b3a, 0x4b34, 0x4b36, 0x4b33, 0x4b4d, 0x4b4f, 0x4b45,
  0x4b44, 0x4b46, 0x4b41, 0x4b5f, 0x4b59, 0x4b5b, 0x4b55, 0x4b52,
  0x4b6e, 0x4b67, 0x4b61, 0x4b63, 0x4b7c, 0x4b7a, 0x4b75, 0x4b74,
  0x4b77, 0x4b70, 0x4b73, 0x4b8c, 0x4b8f, 0x4b89,
  /* 0x31 */
  0x4b88, 0x4b84, 0x4b87, 0x4b81, 0x4b83, 0x4b9d, 0x4b9f, 0x4b9e,
  0x4b99, 0x4b9a, 0x4b94, 0x4b97, 0x4b93, 0x4b92, 0x4bbf, 0x4bba,
  0x4bb4, 0x4bb6, 0x4bb1, 0x4bb0, 0x4bb3, 0x4bcd, 0x4bcc, 0x4bc8,
  0x4bcb, 0x4bc5, 0x4bc4, 0x4bc6, 0x4bc1, 0x4bc0, 0x4bc2, 0x4bdf,
  0x4bd1, 0x4bed, 0x4bef, 0x4bfd, 0x4bff, 0x4bf1, 0x4bf0, 0x4bf2,
  0x540d, 0x540c, 0x5409, 0x540a, 0x5407, 0x5401, 0x5403, 0x541d,
  0x541e, 0x541a, 0x5415, 0x5416, 0x5411, 0x5410, 0x5413, 0x542f,
  0x542a, 0x5423, 0x543d, 0x543f, 0x543e, 0x5438, 0x544d, 0x544c,
  0x544f, 0x5448, 0x544b, 0x5447, 0x5441, 0x5443, 0x545c, 0x545f,
  0x545e, 0x545a, 0x5454, 0x5452, 0x546d, 0x546f, 0x546e, 0x546b,
  0x546a, 0x5467, 0x5460, 0x547d, 0x547c, 0x5436, 0x548c, 0x548e,
  0x5489, 0x548b, 0x5487, 0x5483, 0x5482, 0x549d,
  /* 0x32 */
  0x549f, 0x549e, 0x5499, 0x549b, 0x5496, 0x5491, 0x5493, 0x5492,
  0x54ad, 0x54ac, 0x54af, 0x54a7, 0x54a2, 0x54bd, 0x54b4, 0x54b7,
  0x54b0, 0x54cd, 0x54ce, 0x54c9, 0x54ca, 0x54c1, 0x54c3, 0x54dd,
  0x54de, 0x54d9, 0x54d5, 0x54d1, 0x54d0, 0x54d2, 0x54ef, 0x54e9,
  0x54eb, 0x54e5, 0x54e4, 0x54e2, 0x54fc, 0x54fb, 0x54f7, 0x54f3,
  0x550e, 0x550b, 0x550a, 0x5505, 0x5506, 0x5501, 0x5500, 0x5503,
  0x54ff, 0x551d, 0x551a, 0x5514, 0x5516, 0x5511, 0x5510, 0x5513,
  0x552e, 0x552a, 0x5525, 0x5521, 0x5520, 0x5522, 0x553c, 0x553e,
  0x5539, 0x5538, 0x5535, 0x5534, 0x554f, 0x5547, 0x5542, 0x555e,
  0x5558, 0x555a, 0x5555, 0x5552, 0x5569, 0x556b, 0x5573, 0x558e,
  0x5589, 0x5586, 0x5583, 0x5595, 0x5590, 0x55ac, 0x55ae, 0x55a0,
  0x55b5, 0x55b7, 0x55b1, 0x55b3, 0x55b2, 0x55cf,
  /* 0x33 */
  0x55c5, 0x55c2, 0x55dc, 0x55df, 0x55de, 0x55d8, 0x55d5, 0x55d3,
  0x55ef, 0x55e8, 0x55e3, 0x55ff, 0x55fe, 0x55f9, 0x55fa, 0x560c,
  0x560f, 0x5608, 0x561f, 0x561e, 0x5618, 0x561b, 0x5615, 0x562f,
  0x5625, 0x563c, 0x563f, 0x5638, 0x5631, 0x5648, 0x5644, 0x5658,
  0x565a, 0x5655, 0x5657, 0x5651, 0x5652, 0x566d, 0x566c, 0x566b,
  0x5663, 0x567a, 0x5675, 0x5674, 0x568d, 0x568f, 0x5688, 0x5687,
  0x5681, 0x569e, 0x5698, 0x569b, 0x569a, 0x5695, 0x5697, 0x5691,
  0x56a9, 0x56a8, 0x56ab, 0x56aa, 0x56a2, 0x56bd, 0x56bb, 0x56ba,
  0x56b5, 0x56b7, 0x56b6, 0x56b0, 0x56cd, 0x56c9, 0x56cb, 0x56c5,
  0x56c1, 0x56c2, 0x56dc, 0x56d9, 0x56db, 0x56d6, 0x56d1, 0x56ec,
  0x56e8, 0x56e5, 0x56e4, 0x56e7, 0x56e1, 0x56fd, 0x56fc, 0x56f9,
  0x56fb, 0x56fa, 0x570d, 0x570e, 0x5707, 0x5706,
  /* 0x34 */
  0x5701, 0x571c, 0x571e, 0x5715, 0x5716, 0x5711, 0x5713, 0x5712,
  0x5728, 0x572a, 0x5725, 0x5724, 0x5726, 0x5721, 0x5720, 0x573d,
  0x573f, 0x5738, 0x5731, 0x5730, 0x5733, 0x574f, 0x5741, 0x5746,
  0x5754, 0x5756, 0x576c, 0x576e, 0x5768, 0x5761, 0x5760, 0x577f,
  0x5774, 0x5773, 0x578e, 0x578a, 0x5785, 0x5783, 0x579e, 0x5799,
  0x5794, 0x5790, 0x57ac, 0x57a9, 0x57a7, 0x57a6, 0x57a2, 0x57bf,
  0x57b9, 0x57b8, 0x57ba, 0x57b5, 0x57b7, 0x57b0, 0x57cd, 0x57c8,
  0x57c2, 0x57df, 0x57de, 0x57d8, 0x57d7, 0x57d0, 0x57d3, 0x57ed,
  0x57eb, 0x57ea, 0x57f8, 0x500f, 0x501e, 0x5017, 0x502c, 0x502a,
  0x5025, 0x5027, 0x5022, 0x503c, 0x5039, 0x5038, 0x504e, 0x5049,
  0x504a, 0x5040, 0x5042, 0x5053, 0x506f, 0x5069, 0x506b, 0x506a,
  0x5064, 0x5066, 0x5060, 0x5063, 0x5079, 0x5072,
  /* 0x35 */
  0x508c, 0x508e, 0x5088, 0x5085, 0x5084, 0x5080, 0x509c, 0x5098,
  0x509b, 0x5091, 0x5092, 0x50ac, 0x50ab, 0x50aa, 0x50a4, 0x50a7,
  0x50a0, 0x50a3, 0x50bc, 0x50ba, 0x50b4, 0x50b7, 0x50b6, 0x50b2,
  0x50cb, 0x50c7, 0x50c0, 0x50c3, 0x50ed, 0x50e7, 0x50e1, 0x50e2,
  0x50fb, 0x50f1, 0x50f3, 0x50f2, 0x510d, 0x510c, 0x5108, 0x5105,
  0x5104, 0x5101, 0x5100, 0x5103, 0x5118, 0x5127, 0x5126, 0x513f,
  0x5138, 0x513b, 0x5136, 0x5131, 0x5130, 0x514c, 0x514a, 0x5144,
  0x5147, 0x5140, 0x515d, 0x515c, 0x5155, 0x5157, 0x5156, 0x5153,
  0x516d, 0x516c, 0x5169, 0x516b, 0x5172, 0x518c, 0x518f, 0x518b,
  0x5185, 0x5183, 0x5182, 0x519c, 0x519f, 0x519e, 0x5199, 0x519a,
  0x51ae, 0x51a9, 0x51a0, 0x51bf, 0x51b2, 0x51cc, 0x51ce, 0x51cb,
  0x51c4, 0x51c6, 0x51c1, 0x51c3, 0x51dc, 0x51df,
  /* 0x36 */
  0x51de, 0x51da, 0x51d5, 0x51d6, 0x51d3, 0x51ef, 0x51e4, 0x51fb,
  0x51f2, 0x5208, 0x5205, 0x5207, 0x5200, 0x5203, 0x5202, 0x521d,
  0x521c, 0x521f, 0x5214, 0x5221, 0x523d, 0x523e, 0x5238, 0x523a,
  0x5234, 0x5236, 0x5231, 0x5230, 0x5232, 0x524d, 0x524c, 0x524e,
  0x5249, 0x524b, 0x5244, 0x5246, 0x5240, 0x5242, 0x5259, 0x5253,
  0x526d, 0x526c, 0x526f, 0x526e, 0x526b, 0x5264, 0x5260, 0x5262,
  0x527c, 0x527f, 0x5278, 0x5289, 0x5288, 0x5285, 0x5286, 0x5281,
  0x5298, 0x5294, 0x5297, 0x5290, 0x5293, 0x5292, 0x52ab, 0x52aa,
  0x52a5, 0x52a4, 0x52a6, 0x52a1, 0x52a0, 0x52bc, 0x52be, 0x52ba,
  0x52b3, 0x52c8, 0x52c4, 0x52c7, 0x52c6, 0x52c2, 0x52dd, 0x52c1,
  0x52c0, 0x52d4, 0x52d1, 0x52d0, 0x52d2, 0x52ec, 0x52e9, 0x52e8,
  0x52eb, 0x52ea, 0x52e5, 0x52fc, 0x52e6, 0x52e0,
  /* 0x37 */
  0x52fb, 0x52fa, 0x530c, 0x530f, 0x530a, 0x5307, 0x5301, 0x531c,
  0x5318, 0x5317, 0x5316, 0x5310, 0x532d, 0x532f, 0x532e, 0x5329,
  0x5328, 0x5324, 0x5327, 0x5321, 0x5323, 0x5322, 0x533e, 0x5339,
  0x5330, 0x5333, 0x5332, 0x5348, 0x534b, 0x5341, 0x5340, 0x535f,
  0x536f, 0x5368, 0x536a, 0x5365, 0x5366, 0x5360, 0x5363, 0x5362,
  0x537d, 0x537c, 0x537e, 0x5379, 0x5378, 0x537a, 0x5374, 0x5377,
  0x5376, 0x5371, 0x5373, 0x538c, 0x538e, 0x5381, 0x5399, 0x539a,
  0x5394, 0x5397, 0x5391, 0x5390, 0x5393, 0x5392, 0x53ac, 0x5398,
  0x53aa, 0x53a5, 0x53a4, 0x53a1, 0x53b5, 0x53b0, 0x53ca, 0x53c5,
  0x53c1, 0x53c2, 0x53d8, 0x53d0, 0x53d3, 0x53e9, 0x53eb, 0x53ea,
  0x53e4, 0x53e0, 0x53fd, 0x53f8, 0x53fb, 0x53f5, 0x53f0, 0x53f3,
  0x53f2, 0x5c0e, 0x5c09, 0x5c05, 0x5c04, 0x53ec,
  /* 0x38 */
  0x5c01, 0x5c00, 0x5c16, 0x5c13, 0x5c12, 0x5c2d, 0x5c2b, 0x5c2a,
  0x5c20, 0x5c3f, 0x5c34, 0x5c32, 0x5c44, 0x5c41, 0x5c40, 0x5c42,
  0x5c5d, 0x5c58, 0x5c52, 0x5c6c, 0x5c69, 0x5c6a, 0x5c65, 0x5c75,
  0x5c71, 0x5c72, 0x5c8d, 0x5c8c, 0x5c8a, 0x5c85, 0x5c84, 0x5c87,
  0x5c81, 0x5c80, 0x5c82, 0x5c9d, 0x5c99, 0x5c9b, 0x5c90, 0x5cad,
  0x5cac, 0x5caf, 0x5cab, 0x5ca4, 0x5cbc, 0x5cbf, 0x5cc9, 0x5cb1,
  0x5ccf, 0x5cc5, 0x5cc0, 0x5cc3, 0x5cdd, 0x5cdf, 0x5cd9, 0x5cdb,
  0x5cd7, 0x5cd0, 0x5cec, 0x5cef, 0x5ce4, 0x5cfe, 0x5d08, 0x5d0b,
  0x5d06, 0x5d01, 0x5d1f, 0x5d1e, 0x5d19, 0x824c, 0x5d10, 0x5d2c,
  0x5d2e, 0x5d29, 0x5d25, 0x5d22, 0x5d3d, 0x5d3e, 0x5d38, 0x5d3b,
  0x5d32, 0x5d4e, 0x5d4b, 0x5d5f, 0x5d5e, 0x5d54, 0x5d56, 0x5d50,
  0x5d53, 0x5d52, 0x5d6c, 0x5d6e, 0x5d66, 0x5d60,
  /* 0x39 */
  0x5d62, 0x5d7f, 0x5d78, 0x5d7b, 0x5d74, 0x5d76, 0x5d71, 0x5d86,
  0x5d81, 0x5d83, 0x5d9f, 0x5d98, 0x5d9a, 0x5d92, 0x5da9, 0x5daa,
  0x5da0, 0x5da3, 0x5da2, 0x5dbd, 0x5dbe, 0x5dba, 0x5db7, 0x5db1,
  0x5dcc, 0x5dce, 0x5dc9, 0x5dc5, 0x5dc7, 0x5dc0, 0x5ddf, 0x5dd0,
  0x5dd3, 0x5dd2, 0x5dee, 0x5de9, 0x5dea, 0x5de3, 0x5de2, 0x5dfc,
  0x5dff, 0x5df9, 0x5dfa, 0x5e0d, 0x5e09, 0x5e01, 0x5e00, 0x5e03,
  0x5e1f, 0x5e1e, 0x5e13, 0x5e2e, 0x5e29, 0x5e2a, 0x5e25, 0x5e27,
  0x5e20, 0x5e3d, 0x5e49, 0x5e48, 0x5e4a, 0x5e45, 0x5e41, 0x5e5d,
  0x5e58, 0x5e53, 0x5e6e, 0x5e68, 0x5e6a, 0x5e60, 0x5e7a, 0x5e77,
  0x5e76, 0x5e73, 0x5e86, 0x5e9d, 0x5e9e, 0x5e9b, 0x5e94, 0x5e91,
  0x5e93, 0x5e92, 0x5ead, 0x5eaf, 0x5eaa, 0x5ea1, 0x5ebc, 0x5ebf,
  0x5ebe, 0x5eb8, 0x5eb5, 0x5eb7, 0x5eb6, 0x5eb2,
  /* 0x3a */
  0x5ec9, 0x5ecb, 0x5ec5, 0x5ec2, 0x5ed7, 0x5ed1, 0x5eed, 0x5ee8,
  0x5ee7, 0x5ee3, 0x5ef8, 0x5efb, 0x5ef0, 0x5f0d, 0x5f0c, 0x5f05,
  0x5f1a, 0x5f39, 0x5f14, 0x5f16, 0x5f10, 0x5f2c, 0x5f28, 0x5f20,
  0x5f35, 0x5f4c, 0x5f46, 0x5f41, 0x5f5f, 0x5f5b, 0x5f53, 0x5f65,
  0x5f63, 0x5f62, 0x5f71, 0x5f70, 0x5f73, 0x5f72, 0x5f8c, 0x5f89,
  0x5f8b, 0x5f87, 0x5f83, 0x5f9d, 0x5f9c, 0x5f9e, 0x5f99, 0x5f9b,
  0x5fa5, 0x5fa4, 0x5fa1, 0x5fa0, 0x5fa2, 0x5fbc, 0x5fbf, 0x5fba,
  0x5fb7, 0x5fb1, 0x5fcd, 0x5fcc, 0x5fc0, 0x5fc2, 0x5fdb, 0x5fda,
  0x5fd5, 0x5fd4, 0x5fd7, 0x5fed, 0x5fe2, 0x5ffc, 0x5ff9, 0x5ff0,
  0x5801, 0x581a, 0x5813, 0x5812, 0x582e, 0x582b, 0x5824, 0x5826,
  0x5821, 0x5823, 0x583d, 0x583f, 0x5838, 0x583b, 0x5854, 0x5857,
  0x5851, 0x586f, 0x586e, 0x586a, 0x5865, 0x5864,
  /* 0x3b */
  0x5860, 0x587d, 0x5879, 0x5878, 0x5877, 0x5876, 0x5871, 0x5870,
  0x588a, 0x5885, 0x5887, 0x5882, 0x589f, 0x5890, 0x5892, 0x58ad,
  0x58af, 0x58ae, 0x58ab, 0x58a7, 0x58bf, 0x58b9, 0x58b8, 0x58b7,
  0x58c4, 0x58c6, 0x58df, 0x58d0, 0x58da, 0x58e3, 0x58fc, 0x58ff,
  0x58f9, 0x590c, 0x590b, 0x5900, 0x591f, 0x5926, 0x592e, 0x5929,
  0x592b, 0x592a, 0x593c, 0x5939, 0x5934, 0x5930, 0x5932, 0x594f,
  0x594e, 0x594b, 0x5945, 0x5958, 0x595c, 0x5954, 0x5947, 0x5952,
  0x596d, 0x596c, 0x596f, 0x5969, 0x5967, 0x5960, 0x597d, 0x5974,
  0x5977, 0x5973, 0x5972, 0x598c, 0x598e, 0x5985, 0x5987, 0x599f,
  0x599e, 0x5999, 0x5998, 0x5994, 0x5996, 0x5992, 0x59ad, 0x59aa,
  0x59a6, 0x59bd, 0x59b9, 0x59b5, 0x59b4, 0x59ce, 0x59ca, 0x59c6,
  0x59dd, 0x59c3, 0x59d5, 0x59d4, 0x59ed, 0x59e9,
  /* 0x3c */
  0x59e4, 0x59f5, 0x59f4, 0x5a0d, 0x5a0a, 0x5a00, 0x5a1f, 0x5a19,
  0x5a18, 0x5a15, 0x5a12, 0x5a2d, 0x5a23, 0x5a25, 0x5a3f, 0x5a38,
  0x5a33, 0x5a46, 0x5a5d, 0x5a44, 0x5a5c, 0x5a5b, 0x5a55, 0x5a56,
  0x5a51, 0x5a53, 0x5a65, 0x5a67, 0x5a66, 0x5a61, 0x5a60, 0x5a63,
  0x5a7d, 0x5a8d, 0x5a86, 0x5a83, 0x5aaf, 0x5aa9, 0x5aa8, 0x5aa5,
  0x5aa7, 0x5aa1, 0x5abc, 0x5abe, 0x5ab0, 0x5ab3, 0x5ab2, 0x5acb,
  0x5ac1, 0x5ac6, 0x5ac3, 0x5adc, 0x5adf, 0x5ad9, 0x5ad8, 0x5ad1,
  0x5ad3, 0x5ae8, 0x5ae6, 0x5b0f, 0x5b0b, 0x5b0a, 0x5b05, 0x5b03,
  0x5b14, 0x5b11, 0x5b10, 0x5b2c, 0x5b2f, 0x5b2e, 0x5b29, 0x5b25,
  0x5b26, 0x5b21, 0x5b23, 0x5b3d, 0x5b39, 0x5b3b, 0x5b36, 0x5b30,
  0x5b32, 0x5b4d, 0x5b49, 0x5b48, 0x5b4a, 0x5b40, 0x5b5d, 0x5b59,
  0x5b55, 0x5b56, 0x5b6d, 0x5b6e, 0x5b69, 0x5b6a,
  /* 0x3d */
  0x5b62, 0x5b7f, 0x5b79, 0x5b78, 0x5b75, 0x5b77, 0x5b70, 0x5b73,
  0x5b84, 0x5b80, 0x5b82, 0x5b9b, 0x5b91, 0x5b90, 0x5baf, 0x5baa,
  0x5ba6, 0x5ba9, 0x5ba1, 0x5ba2, 0x5bbd, 0x5bbc, 0x5bb5, 0x5bc9,
  0x5bca, 0x5bc5, 0x5bc4, 0x5bc6, 0x5bdd, 0x5bdc, 0x5bdf, 0x5bde,
  0x5bd9, 0x5bd3, 0x5bec, 0x5bef, 0x5be5, 0x5be4, 0x5be7, 0x5be1,
  0x5be0, 0x5be3, 0x5be2, 0x5bff, 0x5bfe, 0x5bfb, 0x5bf7, 0x5bf1,
  0x640a, 0x6407, 0x6400, 0x641e, 0x6419, 0x641a, 0x6415, 0x6417,
  0x6412, 0x6429, 0x6420, 0x643e, 0x6438, 0x644d, 0x644a, 0x6445,
  0x6444, 0x6441, 0x645c, 0x6459, 0x645b, 0x645a, 0x6450, 0x646c,
  0x646a, 0x647c, 0x6473, 0x6472, 0x648f, 0x648b, 0x6485, 0x6487,
  0x6483, 0x649c, 0x649e, 0x6498, 0x6495, 0x6490, 0x6493, 0x64af,
  0x64a9, 0x64a8, 0x64a5, 0x64bd, 0x64bc, 0x64ba,
  /* 0x3e */
  0x64b6, 0x64b3, 0x64cf, 0x64c9, 0x64c5, 0x64c4, 0x64c7, 0x64c6,
  0x64c3, 0x64c2, 0x64d9, 0x64d8, 0x64d4, 0x64d6, 0x64d0, 0x64d3,
  0x64ef, 0x64e8, 0x64ff, 0x64f8, 0x64f5, 0x64f1, 0x64f0, 0x650f,
  0x650a, 0x6507, 0x6501, 0x651d, 0x651c, 0x651f, 0x651e, 0x6519,
  0x651b, 0x651a, 0x6514, 0x6511, 0x6513, 0x652f, 0x6527, 0x6526,
  0x653d, 0x653c, 0x6538, 0x653b, 0x653a, 0x6534, 0x654c, 0x6548,
  0x654b, 0x6544, 0x6553, 0x656d, 0x6561, 0x657f, 0x6575, 0x6576,
  0x6571, 0x6572, 0x658d, 0x658c, 0x658e, 0x6589, 0x6586, 0x6580,
  0x659f, 0x659e, 0x659a, 0x6595, 0x6591, 0x6590, 0x6592, 0x65ad,
  0x65a8, 0x65a5, 0x65a7, 0x65a0, 0x65b5, 0x65b4, 0x65b1, 0x65cd,
  0x65cc, 0x65cf, 0x65c3, 0x65c2, 0x65d8, 0x65d1, 0x65d0, 0x65d3,
  0x65d2, 0x65ec, 0x65ef, 0x65ea, 0x65e4, 0x65e8,
  /* 0x3f */
  0x65e1, 0x65e0, 0x65e2, 0x660c, 0x660e, 0x6609, 0x660a, 0x661e,
  0x6618, 0x6611, 0x662d, 0x662f, 0x662e, 0x662a, 0x6624, 0x6626,
  0x6634, 0x6630, 0x664f, 0x664e, 0x6649, 0x664b, 0x6641, 0x665d,
  0x665c, 0x665f, 0x6659, 0x665b, 0x6657, 0x6651, 0x6669, 0x6660,
  0x6662, 0x667e, 0x6677, 0x6670, 0x6680, 0x6683, 0x6682, 0x669d,
  0x66ab, 0x66a5, 0x66be, 0x66bb, 0x66ba, 0x66b7, 0x66b3, 0x66b2,
  0x66c9, 0x66c3, 0x66d8, 0x66db, 0x66d7, 0x66e7, 0x66ff, 0x66f9,
  0x66f1, 0x66f0, 0x670e, 0x6709, 0x6707, 0x6706, 0x6700, 0x671d,
  0x671e, 0x671b, 0x6715, 0x6724, 0x6727, 0x6720, 0x6738, 0x673b,
  0x6734, 0x6731, 0x674c, 0x674f, 0x674e, 0x6749, 0x674b, 0x6747,
  0x6746, 0x6743, 0x675f, 0x675e, 0x6759, 0x6755, 0x6756, 0x6768,
  0x676b, 0x6761, 0x6760, 0x677c, 0x6779, 0x6778,
  /* 0x40 */
  0x6775, 0x6771, 0x6770, 0x6772, 0x678f, 0x6789, 0x678a, 0x6787,
  0x679d, 0x6799, 0x6798, 0x6794, 0x6797, 0x6793, 0x67a9, 0x67ab,
  0x67a0, 0x67a3, 0x67a2, 0x67b0, 0x67cc, 0x67c8, 0x67c5, 0x67c3,
  0x67dc, 0x67de, 0x67d9, 0x67d8, 0x67d1, 0x67ed, 0x67e8, 0x67e7,
  0x67e1, 0x67ff, 0x67fe, 0x67f8, 0x67f5, 0x67f4, 0x6004, 0x6007,
  0x601d, 0x601f, 0x6019, 0x6015, 0x6013, 0x602d, 0x602f, 0x6029,
  0x6028, 0x6024, 0x6027, 0x6022, 0x603d, 0x6038, 0x6030, 0x6032,
  0x6046, 0x6042, 0x605c, 0x605f, 0x605e, 0x6059, 0x6057, 0x6056,
  0x6051, 0x6050, 0x6052, 0x606d, 0x606c, 0x606e, 0x6060, 0x607e,
  0x6079, 0x6076, 0x6070, 0x6088, 0x608a, 0x6082, 0x609d, 0x609c,
  0x6095, 0x6094, 0x6096, 0x6090, 0x6092, 0x60ac, 0x60ae, 0x60ab,
  0x60a5, 0x60a1, 0x60be, 0x60b0, 0x60b3, 0x60b2,
  /* 0x41 */
  0x60c9, 0x60c4, 0x60c7, 0x60c6, 0x60c1, 0x60c3, 0x60dd, 0x60dc,
  0x60d8, 0x60da, 0x60e9, 0x60e8, 0x60e4, 0x60e7, 0x60e0, 0x60fd,
  0x60f8, 0x60fa, 0x60f6, 0x60f2, 0x610c, 0x6109, 0x6105, 0x6104,
  0x6107, 0x6102, 0x611e, 0x6119, 0x611b, 0x6114, 0x6116, 0x6113,
  0x6112, 0x612f, 0x612b, 0x6124, 0x6123, 0x613c, 0x6137, 0x6131,
  0x6130, 0x614e, 0x614a, 0x6144, 0x615d, 0x615f, 0x6159, 0x6152,
  0x616d, 0x616a, 0x6166, 0x6177, 0x6170, 0x618c, 0x6188, 0x6187,
  0x619f, 0x6198, 0x6195, 0x6190, 0x61ad, 0x61ae, 0x61ab, 0x61a3,
  0x61bf, 0x61be, 0x61b9, 0x61b2, 0x61cf, 0x61c5, 0x61c4, 0x61c3,
  0x61dd, 0x61d9, 0x61db, 0x61d5, 0x61d2, 0x61fd, 0x61ff, 0x61f9,
  0x61f8, 0x61f4, 0x61f3, 0x61f2, 0x620d, 0x6209, 0x6205, 0x6204,
  0x6200, 0x621c, 0x621f, 0x6218, 0x621b, 0x6210,
  /* 0x42 */
  0x6213, 0x622c, 0x622f, 0x622e, 0x6229, 0x622b, 0x6224, 0x6227,
  0x6226, 0x6221, 0x6223, 0x623d, 0x623c, 0x623e, 0x6234, 0x623a,
  0x624d, 0x6248, 0x624b, 0x6247, 0x6241, 0x625c, 0x6243, 0x625a,
  0x6255, 0x6254, 0x6256, 0x6251, 0x626d, 0x626c, 0x62f6, 0x6267,
  0x6266, 0x6261, 0x6273, 0x627e, 0x6278, 0x6272, 0x627a, 0x6275,
  0x6274, 0x6276, 0x628d, 0x6271, 0x6286, 0x6281, 0x6280, 0x629d,
  0x629f, 0x6294, 0x6297, 0x6296, 0x6291, 0x6292, 0x62ad, 0x62a9,
  0x62a0, 0x62bc, 0x62bf, 0x62b8, 0x62b6, 0x62b2, 0x62cd, 0x62cf,
  0x62ce, 0x62c5, 0x62c1, 0x62c3, 0x62c2, 0x62d9, 0x62d6, 0x62d2,
  0x62e5, 0x62e6, 0x62e1, 0x62e3, 0x62f7, 0x6308, 0x630a, 0x6303,
  0x631e, 0x6314, 0x6311, 0x632d, 0x632f, 0x633e, 0x6333, 0x6348,
  0x634a, 0x6345, 0x6341, 0x6359, 0x6358, 0x6350,
  /* 0x43 */
  0x636b, 0x6361, 0x6363, 0x6379, 0x637b, 0x6376, 0x638c, 0x6389,
  0x6383, 0x6382, 0x639c, 0x639e, 0x639b, 0x6395, 0x6394, 0x6396,
  0x63bd, 0x63bc, 0x63bf, 0x63b8, 0x63b6, 0x63b1, 0x63b0, 0x63f4,
  0x63cd, 0x63cf, 0x63ce, 0x63c8, 0x63c5, 0x63c4, 0x63df, 0x63da,
  0x63d4, 0x63d1, 0x63ec, 0x63eb, 0x63fd, 0x63ff, 0x63fb, 0x63fa,
  0x6c5f, 0x6c19, 0x6c14, 0x6c10, 0x6c12, 0x6c25, 0x6c2a, 0x6c21,
  0x6c20, 0x6c22, 0x6c3d, 0x6c3c, 0x6c3e, 0x6c36, 0x6c32, 0x6c49,
  0x6c48, 0x6c47, 0x6c41, 0x6c58, 0x6c5a, 0x6c55, 0x6c56, 0x6c66,
  0x6c63, 0x6c62, 0x6c7d, 0x6c7c, 0x6c7f, 0x6c78, 0x6c74, 0x6c77,
  0x6c76, 0x6c71, 0x6c8f, 0x6c89, 0x6c8b, 0x6c85, 0x6c9b, 0x6c95,
  0x6c97, 0x6c91, 0x6cac, 0x6cae, 0x6ca8, 0x6ca4, 0x6ca7, 0x6ca3,
  0x6cbf, 0x6cb6, 0x6cc8, 0x6cc5, 0x6cc1, 0x6cc2,
  /* 0x44 */
  0x6cdd, 0x6cdc, 0x6cde, 0x6cdb, 0x6cd4, 0x6cd1, 0x6cd0, 0x6ce8,
  0x6ce5, 0x6ce7, 0x6ce6, 0x6ce1, 0x6ce0, 0x6cfd, 0x6cfc, 0x6cf8,
  0x6cfb, 0x6cf6, 0x6cf1, 0x6cf0, 0x6d0b, 0x6d04, 0x6d07, 0x6d1d,
  0x6d1c, 0x6d1e, 0x6d1b, 0x6d1a, 0x6d3c, 0x6d3e, 0x6d38, 0x6d35,
  0x6d36, 0x6d4f, 0x6d48, 0x6d44, 0x6d43, 0x6d5a, 0x6d56, 0x6d6e,
  0x6d69, 0x6d68, 0x6d6b, 0x6d65, 0x6d64, 0x6d61, 0x6d7d, 0x6d7c,
  0x6d7f, 0x6d77, 0x6d76, 0x6d72, 0x6d8d, 0x6d80, 0x6d9f, 0x6d9b,
  0x6d95, 0x6dac, 0x6da8, 0x6dab, 0x6da5, 0x6da6, 0x6da0, 0x6da2,
  0x6dba, 0x6db5, 0x6db7, 0x6db1, 0x6dc8, 0x6dc5, 0x6ddc, 0x6ddb,
  0x6dda, 0x6def, 0x6de8, 0x6de3, 0x6de2, 0x6dfc, 0x6dfe, 0x6df8,
  0x6df3, 0x6e0d, 0x6e0c, 0x6e0e, 0x6e02, 0x6e1c, 0x6e18, 0x6e17,
  0x6e10, 0x6e2d, 0x6e29, 0x6e25, 0x6e3d, 0x6e3f,
  /* 0x45 */
  0x6e39, 0x6e3a, 0x6e36, 0x6e33, 0x6e32, 0x6e48, 0x6e4b, 0x6e44,
  0x6e47, 0x6e43, 0x6e5d, 0x6e5c, 0x6e5f, 0x6e58, 0x6e5b, 0x6e56,
  0x6e69, 0x6e6a, 0x6e67, 0x6e7c, 0x6e7e, 0x6e73, 0x6e8c, 0x6e8e,
  0x6e8b, 0x6e8a, 0x6e84, 0x6e86, 0x6e9c, 0x6e96, 0x6e90, 0x6e93,
  0x6e92, 0x6ea8, 0x6ea6, 0x6ea2, 0x6ebd, 0x6ebc, 0x6eb9, 0x6eb0,
  0x6eb3, 0x6eb2, 0x6ecb, 0x6ec4, 0x6ec5, 0x6ec1, 0x6edd, 0x6ed9,
  0x6ed8, 0x6edb, 0x6ed1, 0x6ed0, 0x6ee9, 0x6eea, 0x6ee1, 0x6efd,
  0x6efc, 0x6eff, 0x6ef1, 0x6ef0, 0x6f0f, 0x6f0e, 0x6f0b, 0x6f0a,
  0x6f04, 0x6f02, 0x6f1d, 0x6f1c, 0x6f1a, 0x6f16, 0x6f13, 0x6f29,
  0x6f25, 0x6f26, 0x6f21, 0x6f22, 0x6f38, 0x6f3b, 0x6f36, 0x6f32,
  0x6f4b, 0x6f47, 0x6f40, 0x6f5f, 0x6f5b, 0x6f55, 0x6f50, 0x6f6d,
  0x6f6a, 0x6f66, 0x6f63, 0x6f7d, 0x6f78, 0x6f70,
  /* 0x46 */
  0x6f73, 0x6f8f, 0x6f88, 0x6f9a, 0x6f96, 0x6f92, 0x6fad, 0x6faf,
  0x6fae, 0x6fa5, 0x6fa4, 0x6fa1, 0x6fa0, 0x6fa3, 0x6fbd, 0x6fb5,
  0x6fb4, 0x6fb0, 0x6fb3, 0x6fce, 0x6fc9, 0x6fc4, 0x6fc1, 0x6fdb,
  0x6fd7, 0x6fec, 0x6fee, 0x6feb, 0x6fea, 0x6fe3, 0x6ffc, 0x6ffa,
  0x6ff4, 0x6ff2, 0x680f, 0x6809, 0x6808, 0x6804, 0x6800, 0x6803,
  0x681d, 0x681f, 0x6814, 0x6812, 0x682b, 0x682a, 0x6825, 0x6821,
  0x6823, 0x683e, 0x6838, 0x683b, 0x6837, 0x6836, 0x6832, 0x6847,
  0x6846, 0x6840, 0x6842, 0x685f, 0x6859, 0x6854, 0x6856, 0x6851,
  0x6866, 0x6860, 0x6862, 0x6879, 0x687b, 0x6875, 0x6874, 0x6876,
  0x6888, 0x688b, 0x688a, 0x6884, 0x6899, 0x6898, 0x689a, 0x6895,
  0x6891, 0x6892, 0x68bd, 0x68bf, 0x68b9, 0x68cf, 0x68cb, 0x68c0,
  0x68c2, 0x68dd, 0x68dc, 0x68df, 0x68d9, 0x68db,
  /* 0x47 */
  0x68d7, 0x68d1, 0x68ed, 0x68ea, 0x68e4, 0x68e6, 0x68e1, 0x68e3,
  0x68ff, 0x68f9, 0x6909, 0x690a, 0x6907, 0x6903, 0x6902, 0x691c,
  0x691e, 0x6917, 0x692b, 0x692a, 0x6925, 0x686a, 0x6923, 0x6922,
  0x693c, 0x6934, 0x6931, 0x6932, 0x695a, 0x6953, 0x6952, 0x696c,
  0x6968, 0x696a, 0x6962, 0x697d, 0x6971, 0x698f, 0x698a, 0x699c,
  0x699f, 0x6999, 0x699b, 0x699a, 0x6995, 0x69a7, 0x69a1, 0x69b9,
  0x69ba, 0x69b4, 0x69b0, 0x69b2, 0x69c9, 0x69c5, 0x69c7, 0x69c3,
  0x69c2, 0x69db, 0x69d6, 0x69d0, 0x69d2, 0x69ed, 0x69ef, 0x69e8,
  0x69e4, 0x69e2, 0x69fd, 0x69f9, 0x69fb, 0x69f1, 0x6a0d, 0x6a09,
  0x6a13, 0x6a2f, 0x6a2a, 0x6a3f, 0x6a3b, 0x6a34, 0x6a36, 0x6a31,
  0x6a49, 0x6a48, 0x6a45, 0x6a44, 0x6a46, 0x6a42, 0x6a5c, 0x6a5f,
  0x6a5e, 0x6a59, 0x6a5a, 0x6a51, 0x6a50, 0x6a53,
  /* 0x48 */
  0x6a6f, 0x6a6e, 0x6a65, 0x6a7e, 0x6a76, 0x6a70, 0x6a80, 0x6a9e,
  0x6a94, 0x6aad, 0x6aaa, 0x6aa0, 0x6aa3, 0x6abc, 0x6abe, 0x6ab6,
  0x6ab2, 0x6acd, 0x6acc, 0x6ace, 0x6aca, 0x6ac5, 0x6ac7, 0x6ac0,
  0x6ac3, 0x6ac2, 0x6ae6, 0x6ae0, 0x6ae3, 0x6af4, 0x6af6, 0x6af0,
  0x6b09, 0x6b05, 0x6b07, 0x6b01, 0x6b00, 0x6b1b, 0x6b15, 0x6b17,
  0x6b16, 0x6b2b, 0x6b24, 0x6b27, 0x6b22, 0x6b3d, 0x6b3e, 0x6b3b,
  0x6b36, 0x6b31, 0x6b20, 0x6b42, 0x6b5c, 0x6b5f, 0x6b5e, 0x6b5a,
  0x6b54, 0x6b57, 0x6b50, 0x6b53, 0x6b6c, 0x6b6f, 0x6b65, 0x6b61,
  0x6b70, 0x6b73, 0x6b8e, 0x6b8a, 0x6b85, 0x6b86, 0x6b81, 0x6b80,
  0x6b9d, 0x6b9f, 0x6b9e, 0x6b99, 0x6b9b, 0x6b97, 0x6b92, 0x6bad,
  0x6ba8, 0x6bab, 0x6baa, 0x6ba5, 0x6ba3, 0x6ba2, 0x6bbd, 0x6bb8,
  0x6bbb, 0x6bb1, 0x6bc8, 0x6bca, 0x6bc5, 0x6bc7,
  /* 0x49 */
  0x6bd7, 0x6bd3, 0x6be5, 0x6be4, 0x6bfd, 0x6bf8, 0x6bf4, 0x6bf1,
  0x6bf0, 0x740d, 0x7408, 0x740b, 0x740a, 0x7400, 0x741a, 0x742d,
  0x742e, 0x7422, 0x7439, 0x743a, 0x7434, 0x7431, 0x744e, 0x7449,
  0x7445, 0x7444, 0x7447, 0x7446, 0x7459, 0x7458, 0x7450, 0x7453,
  0x7443, 0x7469, 0x7468, 0x7461, 0x7463, 0x7478, 0x747b, 0x7473,
  0x748c, 0x7488, 0x748b, 0x7499, 0x7498, 0x749b, 0x749a, 0x7495,
  0x7496, 0x74a9, 0x74a6, 0x74bd, 0x74bc, 0x74b9, 0x74ba, 0x74c7,
  0x74dc, 0x74de, 0x74d9, 0x74d8, 0x74db, 0x74d5, 0x74d1, 0x74e9,
  0x74f7, 0x750e, 0x7509, 0x7508, 0x750b, 0x750a, 0x7506, 0x7501,
  0x7502, 0x7513, 0x752d, 0x7526, 0x7520, 0x7522, 0x753d, 0x753c,
  0x7535, 0x754c, 0x7548, 0x754b, 0x754a, 0x7547, 0x7546, 0x755d,
  0x755f, 0x755a, 0x7557, 0x7551, 0x7553, 0x756d,
  /* 0x4a */
  0x7565, 0x7574, 0x758d, 0x7588, 0x758a, 0x7581, 0x759f, 0x7597,
  0x7596, 0x75ad, 0x75af, 0x75a2, 0x75bd, 0x75bf, 0x75be, 0x75b7,
  0x75b2, 0x75cd, 0x75cc, 0x75c9, 0x75c6, 0x75c1, 0x75de, 0x75db,
  0x75d4, 0x75d7, 0x75d1, 0x75f5, 0x75f3, 0x760d, 0x760a, 0x7605,
  0x7604, 0x761e, 0x761a, 0x7617, 0x7610, 0x7612, 0x7629, 0x7626,
  0x7622, 0x7639, 0x7635, 0x7634, 0x764c, 0x764f, 0x764e, 0x7648,
  0x7643, 0x7642, 0x765d, 0x765e, 0x7658, 0x765b, 0x7657, 0x7651,
  0x7653, 0x766d, 0x766e, 0x7665, 0x7666, 0x7663, 0x7662, 0x767c,
  0x767a, 0x7675, 0x7676, 0x7671, 0x7672, 0x7689, 0x7684, 0x7680,
  0x7683, 0x769e, 0x7696, 0x76a5, 0x76a0, 0x76a3, 0x76bc, 0x76b9,
  0x76b3, 0x76cc, 0x76ca, 0x76c4, 0x76c1, 0x76d8, 0x76db, 0x76d5,
  0x76d2, 0x76e8, 0x76fe, 0x76f9, 0x76f7, 0x76f6,
  /* 0x4b */
  0x76f3, 0x770f, 0x7709, 0x7708, 0x770a, 0x7706, 0x7700, 0x771f,
  0x771e, 0x7715, 0x7714, 0x7713, 0x772f, 0x7729, 0x772a, 0x7725,
  0x7721, 0x773c, 0x773f, 0x7738, 0x7737, 0x7736, 0x7730, 0x774e,
  0x7740, 0x775d, 0x775f, 0x775b, 0x7755, 0x7750, 0x7753, 0x7752,
  0x776d, 0x776b, 0x776a, 0x7764, 0x7766, 0x7761, 0x7763, 0x7762,
  0x777c, 0x777a, 0x7774, 0x7771, 0x778d, 0x778c, 0x778e, 0x7788,
  0x778b, 0x7783, 0x779d, 0x779e, 0x7798, 0x779a, 0x7795, 0x7791,
  0x7793, 0x7792, 0x77ad, 0x77af, 0x77a8, 0x77ab, 0x77a7, 0x77a6,
  0x77a0, 0x77b8, 0x77ba, 0x77b4, 0x77b1, 0x77b0, 0x77b2, 0x77c8,
  0x77cb, 0x77c4, 0x77c6, 0x77c1, 0x77c2, 0x77df, 0x77de, 0x77db,
  0x77d4, 0x77d0, 0x77ec, 0x77ee, 0x77eb, 0x77ea, 0x77e4, 0x77f9,
  0x77f8, 0x77fa, 0x77f4, 0x77f7, 0x77f6, 0x77f0,
  /* 0x4c */
  0x77f2, 0x700d, 0x700c, 0x7009, 0x700a, 0x7007, 0x701c, 0x7017,
  0x7016, 0x7029, 0x702b, 0x7025, 0x7024, 0x7027, 0x7026, 0x7021,
  0x7020, 0x7023, 0x7022, 0x703d, 0x703c, 0x7034, 0x704d, 0x704e,
  0x7049, 0x704b, 0x704a, 0x7046, 0x7040, 0x705c, 0x705f, 0x705a,
  0x7050, 0x706f, 0x706b, 0x706a, 0x7065, 0x7066, 0x7060, 0x7063,
  0x707c, 0x707f, 0x708d, 0x708c, 0x7088, 0x708b, 0x708a, 0x7084,
  0x7082, 0x709d, 0x709c, 0x709f, 0x7095, 0x7094, 0x7097, 0x7091,
  0x7092, 0x70ad, 0x70ac, 0x70ae, 0x70ab, 0x70a5, 0x70a4, 0x70a7,
  0x70a6, 0x70a3, 0x70a2, 0x70bc, 0x70bf, 0x70b8, 0x70b4, 0x70b6,
  0x70b2, 0x70c5, 0x70c4, 0x70c1, 0x70dd, 0x70de, 0x70d5, 0x70d7,
  0x70d6, 0x70d3, 0x70d2, 0x70e9, 0x70e5, 0x70e7, 0x70e6, 0x70e2,
  0x70f9, 0x70f7, 0x70f6, 0x70f1, 0x70f2, 0x710b,
  /* 0x4d */
  0x711f, 0x711b, 0x711a, 0x712d, 0x712c, 0x7129, 0x712a, 0x7124,
  0x7127, 0x7122, 0x713b, 0x7134, 0x7130, 0x7133, 0x7132, 0x714d,
  0x714e, 0x714a, 0x7145, 0x7143, 0x715d, 0x715f, 0x715a, 0x7153,
  0x7152, 0x716c, 0x7162, 0x717c, 0x7174, 0x7177, 0x7176, 0x7171,
  0x7170, 0x7173, 0x718c, 0x7188, 0x719d, 0x719f, 0x719e, 0x7198,
  0x7194, 0x7191, 0x71af, 0x71a9, 0x71b9, 0x71b7, 0x71b2, 0x71cd,
  0x71cc, 0x71c9, 0x71cb, 0x71c1, 0x71c3, 0x71c2, 0x71da, 0x71d1,
  0x71d2, 0x71ed, 0x71ec, 0x71e9, 0x71ea, 0x71e1, 0x71e3, 0x71e2,
  0x71fc, 0x71f4, 0x720d, 0x720f, 0x720e, 0x7209, 0x720a, 0x7205,
  0x7207, 0x7201, 0x7202, 0x721f, 0x721e, 0x7218, 0x721b, 0x7214,
  0x7216, 0x7211, 0x7210, 0x7213, 0x722e, 0x7228, 0x722b, 0x7224,
  0x7220, 0x723f, 0x723e, 0x7238, 0x7235, 0x7234,
  /* 0x4e */
  0x7237, 0x7231, 0x7247, 0x724d, 0x724c, 0x724e, 0x7249, 0x7248,
  0x7244, 0x7246, 0x7258, 0x7254, 0x7252, 0x7269, 0x7268, 0x7260,
  0x7263, 0x7262, 0x727c, 0x7279, 0x728c, 0x7288, 0x7281, 0x7280,
  0x7298, 0x7296, 0x7291, 0x7290, 0x7292, 0x72ad, 0x72af, 0x72ae,
  0x72a9, 0x72a8, 0x72ab, 0x72aa, 0x72a5, 0x72a7, 0x72a0, 0x72b0,
  0x72cc, 0x72c8, 0x72c4, 0x72c6, 0x72c1, 0x72c3, 0x72d9, 0x72d4,
  0x72ed, 0x72eb, 0x72e5, 0x72e1, 0x72fd, 0x72fc, 0x72fb, 0x72f4,
  0x72f1, 0x730d, 0x730b, 0x7307, 0x7303, 0x731f, 0x7319, 0x7318,
  0x731a, 0x7314, 0x7317, 0x7311, 0x732f, 0x7325, 0x7320, 0x7323,
  0x7322, 0x7339, 0x7338, 0x733b, 0x7334, 0x7330, 0x7333, 0x734f,
  0x7348, 0x734b, 0x7347, 0x7340, 0x7343, 0x7342, 0x735f, 0x735b,
  0x735a, 0x7351, 0x7353, 0x7352, 0x736d, 0x736f,
  /* 0x4f */
  0x7369, 0x736a, 0x7367, 0x7361, 0x737d, 0x737f, 0x737e, 0x7379,
  0x7377, 0x7370, 0x738d, 0x7389, 0x7381, 0x7380, 0x7399, 0x7398,
  0x739b, 0x7397, 0x7392, 0x73af, 0x73aa, 0x73a7, 0x73a3, 0x73a2,
  0x73bc, 0x73b8, 0x73b3, 0x73ce, 0x73c4, 0x73dc, 0x73df, 0x73d8,
  0x73d4, 0x73d3, 0x73d2, 0x73ed, 0x73e9, 0x73eb, 0x73e7, 0x73e1,
  0x73fd, 0x73fc, 0x73f9, 0x73f5, 0x73f6, 0x7c08, 0x7c0b, 0x7c04,
  0x7c00, 0x7c03, 0x7c1c, 0x7c10, 0x7c2c, 0x7c2f, 0x7c2e, 0x7c20,
  0x7c23, 0x7c3d, 0x7c38, 0x7c3a, 0x7c4e, 0x7c49, 0x7c4a, 0x7c45,
  0x7c41, 0x7c43, 0x7c5f, 0x7c51, 0x7c53, 0x7c6d, 0x7c6c, 0x7c6e,
  0x7c69, 0x7c65, 0x7c67, 0x7c63, 0x7c77, 0x7c73, 0x7c87, 0x7c82,
  0x7c99, 0x7c95, 0x7cac, 0x7c90, 0x7c93, 0x7c92, 0x7ca9, 0x7ca5,
  0x7ca1, 0x7ca0, 0x7cbd, 0x7cbc, 0x7cbf, 0x7cbe,
  /* 0x50 */
  0x7cb6, 0x7cb0, 0x7cb2, 0x7cca, 0x7cc5, 0x7cc4, 0x7cc1, 0x7cc3,
  0x7cdf, 0x7cde, 0x7cd8, 0x7cdb, 0x7ce9, 0x7cd6, 0x7cd2, 0x7ced,
  0x7cec, 0x7ceb, 0x7ce7, 0x7cff, 0x7cfe, 0x7d0d, 0x7cfb, 0x7cfa,
  0x7cf7, 0x7cf6, 0x7cf2, 0x7d0b, 0x7d01, 0x7d1d, 0x7d17, 0x7d11,
  0x7d13, 0x7d12, 0x7d2d, 0x7d28, 0x7d2a, 0x7d24, 0x7d20, 0x7d3c,
  0x7d39, 0x7d38, 0x7d36, 0x7d30, 0x7d32, 0x7d49, 0x7d48, 0x7d4b,
  0x7d47, 0x7d46, 0x7d42, 0x7d5c, 0x7d59, 0x7d55, 0x7d56, 0x7d51,
  0x7d6a, 0x7d64, 0x7d66, 0x7d7f, 0x7d74, 0x7d76, 0x7d71, 0x7d73,
  0x7d86, 0x7d81, 0x7d9c, 0x7d9e, 0x7d99, 0x7d98, 0x7d9b, 0x7d95,
  0x7d96, 0x7d91, 0x7dac, 0x7da5, 0x7da4, 0x7da6, 0x7da2, 0x7dbc,
  0x7db9, 0x7db5, 0x7db6, 0x7dcf, 0x7dc9, 0x7dca, 0x7dc5, 0x7dc7,
  0x7dc2, 0x7dd9, 0x7ddb, 0x7dd7, 0x7dd0, 0x7dd3,
  /* 0x51 */
  0x7ded, 0x7def, 0x7de8, 0x7de7, 0x7de6, 0x7de0, 0x7dfc, 0x7df5,
  0x7df1, 0x7e0f, 0x7e0e, 0x7e0a, 0x7e04, 0x7e07, 0x7e01, 0x7e1c,
  0x7e18, 0x7e16, 0x7e13, 0x7e2c, 0x7e2a, 0x7e26, 0x7e20, 0x7e22,
  0x7e3d, 0x7e39, 0x7e38, 0x7e35, 0x7e34, 0x7e37, 0x7e49, 0x7e48,
  0x7e4a, 0x7e45, 0x7e41, 0x7e58, 0x7e5b, 0x7e54, 0x7e51, 0x7e50,
  0x7e52, 0x7e6d, 0x7e68, 0x7e6a, 0x7e67, 0x7e60, 0x7e78, 0x7e75,
  0x7e73, 0x7e8d, 0x7e8f, 0x7e88, 0x7e8b, 0x7e87, 0x7e86, 0x7e9d,
  0x7e9c, 0x7e99, 0x7e93, 0x7ead, 0x7eae, 0x7ea1, 0x7ebe, 0x7eb8,
  0x7eb4, 0x7eb6, 0x7eb1, 0x7ecb, 0x7ec4, 0x7ec1, 0x7ec3, 0x7edc,
  0x7ed6, 0x7ee5, 0x7ee4, 0x7ee6, 0x7ee1, 0x7efc, 0x7ef9, 0x7ef6,
  0x7ef0, 0x7ef3, 0x7f0a, 0x7f19, 0x7f12, 0x7f2e, 0x7f2a, 0x7f24,
  0x7f27, 0x7f26, 0x7f20, 0x7f23, 0x7f22, 0x7f3d,
  /* 0x52 */
  0x7f3c, 0x7f39, 0x7f30, 0x7f32, 0x7f4d, 0x7f4c, 0x7f4a, 0x7f43,
  0x7f58, 0x7f6d, 0x7f69, 0x7f6b, 0x7f64, 0x7f67, 0x7f60, 0x7f62,
  0x7f7f, 0x7f7e, 0x7f7a, 0x7f89, 0x7f84, 0x7f83, 0x7f9d, 0x7f9c,
  0x7f9b, 0x7f96, 0x7f93, 0x7fad, 0x7fa8, 0x7fa1, 0x7fa2, 0x7fbd,
  0x7fbf, 0x7fb8, 0x7fbb, 0x7fb7, 0x7fb6, 0x7fb1, 0x7fb0, 0x7fcf,
  0x7fc8, 0x7fc5, 0x7fc7, 0x7fd9, 0x7fdb, 0x7fda, 0x7fd4, 0x7fd7,
  0x7fd6, 0x7fe5, 0x7fe7, 0x7fff, 0x7ff9, 0x7ff8, 0x7ff5, 0x7ff4,
  0x7ff7, 0x7ff1, 0x7ff3, 0x780c, 0x780f, 0x780e, 0x7809, 0x780b,
  0x7804, 0x7806, 0x7801, 0x7803, 0x7802, 0x7814, 0x7816, 0x782d,
  0x7828, 0x782b, 0x7825, 0x7821, 0x783c, 0x783e, 0x7839, 0x783b,
  0x7834, 0x7837, 0x784b, 0x7847, 0x7858, 0x785c, 0x785f, 0x785e,
  0x7854, 0x7857, 0x7856, 0x7851, 0x7850, 0x7853,
  /* 0x53 */
  0x786c, 0x786e, 0x786a, 0x7864, 0x7860, 0x7863, 0x787d, 0x787f,
  0x7874, 0x7871, 0x7870, 0x788b, 0x788a, 0x7882, 0x7899, 0x7893,
  0x78ad, 0x78ab, 0x78bd, 0x78bb, 0x78ba, 0x78b7, 0x78b6, 0x78b1,
  0x78b2, 0x78c9, 0x78ca, 0x78c5, 0x78c4, 0x78c0, 0x78c2, 0x78de,
  0x78d9, 0x78d8, 0x78da, 0x78d4, 0x78d7, 0x78d0, 0x78eb, 0x78e4,
  0x78e6, 0x78f8, 0x790e, 0x790a, 0x7905, 0x7904, 0x7902, 0x791c,
  0x791f, 0x791e, 0x791b, 0x7910, 0x7913, 0x792e, 0x792b, 0x7927,
  0x7920, 0x793c, 0x7931, 0x7930, 0x7933, 0x794d, 0x794c, 0x794a,
  0x7945, 0x7940, 0x795c, 0x795e, 0x795a, 0x7954, 0x7957, 0x7951,
  0x7950, 0x7968, 0x796a, 0x7967, 0x797d, 0x7975, 0x7977, 0x7976,
  0x7972, 0x798c, 0x798f, 0x798e, 0x7988, 0x798b, 0x7985, 0x7986,
  0x7981, 0x7980, 0x799c, 0x799b, 0x799a, 0x7990,
  /* 0x54 */
  0x7993, 0x79ab, 0x79aa, 0x79a7, 0x79be, 0x79bb, 0x79ba, 0x79b4,
  0x79cf, 0x79ce, 0x79c9, 0x79c8, 0x79cb, 0x79c1, 0x79c0, 0x79c3,
  0x79da, 0x79d4, 0x7a0d, 0x79ef, 0x79e8, 0x79eb, 0x79e7, 0x79e6,
  0x79e0, 0x79fc, 0x79f8, 0x79fb, 0x79f4, 0x79f7, 0x7a05, 0x7a1d,
  0x7a1c, 0x7a18, 0x7a1a, 0x7a11, 0x7a10, 0x7a2d, 0x7a2a, 0x7a25,
  0x7a21, 0x7a20, 0x7a22, 0x7a3e, 0x7a3b, 0x7a32, 0x7a49, 0x7a48,
  0x7a4a, 0x7a43, 0x7a5d, 0x7a5f, 0x7a55, 0x7a52, 0x7a6c, 0x7a6f,
  0x7a68, 0x7a66, 0x7a63, 0x7a62, 0x7a7e, 0x7a75, 0x7a73, 0x7a8c,
  0x7a8b, 0x7a8a, 0x7a87, 0x7a80, 0x7a9c, 0x7a98, 0x7a95, 0x7a97,
  0x7a90, 0x7a93, 0x7b31, 0x7b36, 0x7b30, 0x7b33, 0x7b32, 0x7b4e,
  0x7b49, 0x7b4a, 0x7b42, 0x7b5f, 0x7b5e, 0x7b56, 0x7b51, 0x7b50,
  0x7b6c, 0x7b6e, 0x7b69, 0x7b68, 0x7b6b, 0x7b60,
  /* 0x55 */
  0x7b7c, 0x7b70, 0x7b73, 0x7b72, 0x7b8d, 0x7b86, 0x7b80, 0x7b82,
  0x7b9d, 0x7b9c, 0x7b9b, 0x7b9a, 0x7b91, 0x7bac, 0x7baf, 0x7bab,
  0x7ba7, 0x7ba0, 0x7bb9, 0x7bb1, 0x7bb2, 0x7bcd, 0x7bce, 0x7bc5,
  0x7bc3, 0x7bc2, 0x7bd6, 0x7bd2, 0x7bee, 0x7be8, 0x7be5, 0x7be1,
  0x7be3, 0x7be2, 0x7bff, 0x7bf7, 0x7bf0, 0x7bf3, 0x7bf2, 0x840a,
  0x8405, 0x8407, 0x8400, 0x8403, 0x8402, 0x841c, 0x841e, 0x8419,
  0x841b, 0x8410, 0x8413, 0x8412, 0x842d, 0x8429, 0x842b, 0x8421,
  0x8423, 0x843d, 0x8439, 0x8438, 0x843a, 0x8434, 0x8437, 0x8431,
  0x8433, 0x844d, 0x8449, 0x846d, 0x8469, 0x846b, 0x8460, 0x847c,
  0x8478, 0x848c, 0x8485, 0x8483, 0x8491, 0x8493, 0x84ab, 0x84aa,
  0x84a6, 0x84b5, 0x84b4, 0x84c5, 0x84c0, 0x84c2, 0x84df, 0x84d9,
  0x84d8, 0x84da, 0x84d5, 0x84ed, 0x84e0, 0x84e3,
  /* 0x56 */
  0x84fd, 0x84ff, 0x84fe, 0x84fb, 0x84f4, 0x84f7, 0x84f3, 0x850e,
  0x8506, 0x851b, 0x851a, 0x8515, 0x8511, 0x8513, 0x852d, 0x8529,
  0x852a, 0x8521, 0x853d, 0x8538, 0x8537, 0x8531, 0x8548, 0x854a,
  0x8547, 0x8541, 0x855f, 0x855a, 0x856d, 0x856c, 0x856a, 0x8565,
  0x8564, 0x8560, 0x8562, 0x857a, 0x858c, 0x859d, 0x8589, 0x8588,
  0x858b, 0x8586, 0x8583, 0x859b, 0x8595, 0x8596, 0x8593, 0x85af,
  0x85a3, 0x85bf, 0x85b9, 0x85b6, 0x85c6, 0x85ce, 0x85c8, 0x85c7,
  0x85c3, 0x85c2, 0x85d8, 0x85da, 0x85d6, 0x85d0, 0x85d3, 0x85ec,
  0x85e9, 0x85e6, 0x85e1, 0x85fd, 0x85fc, 0x85ff, 0x85f8, 0x85fb,
  0x85f5, 0x85f4, 0x85f0, 0x85f2, 0x860d, 0x860e, 0x8602, 0x861e,
  0x8619, 0x8614, 0x8617, 0x8610, 0x862c, 0x862f, 0x8625, 0x863f,
  0x8639, 0x8637, 0x864e, 0x8649, 0x8648, 0x864b,
  /* 0x57 */
  0x8646, 0x8643, 0x8642, 0x865c, 0x865b, 0x8651, 0x866d, 0x866e,
  0x866a, 0x8660, 0x8679, 0x8676, 0x8670, 0x8672, 0x868d, 0x868c,
  0x868e, 0x8689, 0x868a, 0x8684, 0x8687, 0x8683, 0x869c, 0x8699,
  0x869b, 0x8695, 0x8697, 0x8696, 0x86ad, 0x86ac, 0x86ae, 0x86a9,
  0x86aa, 0x86a5, 0x86a4, 0x86a7, 0x86a3, 0x86bd, 0x86bf, 0x86b9,
  0x86ba, 0x86b7, 0x86b1, 0x86b3, 0x86b2, 0x86cb, 0x86dd, 0x86d8,
  0x86d7, 0x86ed, 0x86ef, 0x86e9, 0x86e5, 0x86e7, 0x86e0, 0x86e2,
  0x86fb, 0x86fa, 0x86f0, 0x86f3, 0x870d, 0x870c, 0x870a, 0x8705,
  0x8707, 0x8706, 0x8759, 0x8716, 0x8710, 0x8713, 0x8712, 0x872c,
  0x872f, 0x8721, 0x8720, 0x8723, 0x873d, 0x873e, 0x873a, 0x8737,
  0x8731, 0x8730, 0x874f, 0x874e, 0x8749, 0x874a, 0x8740, 0x8743,
  0x875c, 0x8758, 0x875b, 0x875a, 0x877d, 0x8775,
  /* 0x58 */
  0x8770, 0x8772, 0x878d, 0x878f, 0x8789, 0x878b, 0x8780, 0x879f,
  0x8799, 0x8798, 0x8795, 0x8794, 0x8796, 0x8791, 0x8790, 0x87ab,
  0x87aa, 0x87a4, 0x87a1, 0x87b3, 0x87b2, 0x87cd, 0x87ca, 0x87c4,
  0x87c2, 0x87dd, 0x87dc, 0x87d9, 0x87d0, 0x875e, 0x87e5, 0x87e7,
  0x87fb, 0x87f5, 0x87f4, 0x87f1, 0x800c, 0x800b, 0x8007, 0x8002,
  0x801c, 0x8018, 0x8014, 0x87a0, 0x8022, 0x8034, 0x8048, 0x804a,
  0x8045, 0x8047, 0x8040, 0x8042, 0x805c, 0x805f, 0x805b, 0x8055,
  0x8054, 0x8057, 0x8051, 0x806d, 0x8069, 0x8068, 0x806a, 0x8067,
  0x807d, 0x807e, 0x8079, 0x807b, 0x8075, 0x8071, 0x8070, 0x808c,
  0x8088, 0x809f, 0x809e, 0x8098, 0x8093, 0x80ab, 0x80a5, 0x80a4,
  0x80a7, 0x80a2, 0x80bc, 0x80b9, 0x80b7, 0x80b0, 0x80b3, 0x80cd,
  0x80cf, 0x80ca, 0x80c5, 0x80c1, 0x80c2, 0x80de,
  /* 0x59 */
  0x80d1, 0x80ea, 0x80e7, 0x80e2, 0x80fd, 0x80fc, 0x80ff, 0x80fa,
  0x813f, 0x80f7, 0x80f6, 0x80f0, 0x810f, 0x810e, 0x810a, 0x8101,
  0x8103, 0x811d, 0x8111, 0x8113, 0x812f, 0x812e, 0x8129, 0x8128,
  0x812a, 0x8127, 0x8126, 0x8122, 0x813e, 0x8139, 0x813b, 0x8132,
  0x814b, 0x8142, 0x815d, 0x815c, 0x815f, 0x815e, 0x815b, 0x8154,
  0x8151, 0x8150, 0x8153, 0x8152, 0x816d, 0x816c, 0x816f, 0x8169,
  0x8166, 0x8162, 0x8174, 0x8177, 0x8176, 0x8170, 0x8172, 0x818c,
  0x8188, 0x818b, 0x8184, 0x8186, 0x8181, 0x8182, 0x819e, 0x8195,
  0x8190, 0x8192, 0x81ad, 0x81af, 0x81a8, 0x81aa, 0x81b9, 0x81bb,
  0x81ba, 0x81b5, 0x81b1, 0x81b0, 0x81b3, 0x81b2, 0x81cf, 0x81ca,
  0x81c7, 0x81c6, 0x81c3, 0x81a0, 0x81d5, 0x81d7, 0x81d2, 0x81ed,
  0x81eb, 0x81e5, 0x81e0, 0x81fe, 0x81fb, 0x81f1,
  /* 0x5a */
  0x81f2, 0x820d, 0x8209, 0x8208, 0x8200, 0x8203, 0x821d, 0x821c,
  0x821f, 0x8215, 0x8214, 0x8216, 0x8213, 0x822c, 0x822a, 0x8224,
  0x823b, 0x8235, 0x8237, 0x8231, 0x8230, 0x824d, 0x824f, 0x824b,
  0x825f, 0x825e, 0x825b, 0x825a, 0x8255, 0x8254, 0x8250, 0x826d,
  0x826c, 0x826f, 0x826e, 0x8269, 0x8264, 0x8261, 0x8262, 0x8278,
  0x827b, 0x827a, 0x8277, 0x8280, 0x829c, 0x829b, 0x8295, 0x8297,
  0x8291, 0x82ac, 0x82ab, 0x82aa, 0x82a5, 0x82a0, 0x82bc, 0x82be,
  0x82b9, 0x82b8, 0x82ba, 0x82b5, 0x82b4, 0x82b2, 0x82cd, 0x82cc,
  0x82ce, 0x82c8, 0x82dc, 0x82df, 0x82d8, 0x82da, 0x82d7, 0x82d1,
  0x82ed, 0x82ee, 0x82e8, 0x82ea, 0x8285, 0x82f7, 0x82f1, 0x82f0,
  0x8309, 0x8308, 0x830a, 0x8306, 0x8303, 0x8302, 0x831d, 0x831e,
  0x8319, 0x8314, 0x8313, 0x8312, 0x832c, 0x832e,
  /* 0x5b */
  0x8325, 0x8323, 0x8322, 0x833c, 0x833f, 0x8334, 0x8337, 0x8331,
  0x8330, 0x8333, 0x834d, 0x834e, 0x8348, 0x8340, 0x8355, 0x8350,
  0x836c, 0x8369, 0x8368, 0x8362, 0x837c, 0x837f, 0x8376, 0x838e,
  0x8389, 0x8388, 0x838b, 0x838a, 0x8385, 0x8384, 0x8386, 0x8381,
  0x839d, 0x839e, 0x8398, 0x839a, 0x8395, 0x8394, 0x8393, 0x83ad,
  0x83ae, 0x83aa, 0x83a1, 0x83a0, 0x83a3, 0x83bc, 0x83b8, 0x83b3,
  0x83b2, 0x83cc, 0x83c5, 0x83c4, 0x83c7, 0x83c3, 0x83d8, 0x83db,
  0x83d4, 0x83d7, 0x83d1, 0x83d2, 0x83ef, 0x83ee, 0x83e9, 0x83e7,
  0x83e6, 0x83e0, 0x83fc, 0x83fe, 0x83f5, 0x83f7, 0x83f2, 0x8c0c,
  0x8c0e, 0x8c0b, 0x8c04, 0x8c07, 0x8c06, 0x8c1d, 0x8c14, 0x8c1f,
  0x8c1e, 0x8c19, 0x8c15, 0x8c17, 0x8c16, 0x8c11, 0x8c13, 0x8c12,
  0x8c25, 0x8c20, 0x8c23, 0x8c3d, 0x8c3f, 0x8c38,
  /* 0x5c */
  0x8c37, 0x8c31, 0x8c4c, 0x8c4e, 0x8c48, 0x8c45, 0x8c44, 0x8c47,
  0x8c46, 0x8c43, 0x8c5c, 0x8c58, 0x8c5b, 0x8c55, 0x8c57, 0x8c51,
  0x8c52, 0x8c6d, 0x8c69, 0x8c64, 0x8c7c, 0x8c74, 0x8c76, 0x8c8d,
  0x8c95, 0x8c97, 0x8c96, 0x8c91, 0x8c92, 0x8cad, 0x8ca5, 0x8ca7,
  0x8cb7, 0x8cb0, 0x8cb3, 0x8ccd, 0x8cc7, 0x8cc6, 0x8cc1, 0x8cc0,
  0x8cc3, 0x8cdc, 0x8cdf, 0x8cde, 0x8cd6, 0x8cd3, 0x8cea, 0x8ce2,
  0x8cfd, 0x8cfc, 0x8cf8, 0x8cfa, 0x8d0c, 0x8d0b, 0x8d00, 0x8d03,
  0x8d02, 0x8d18, 0x8d1b, 0x8d15, 0x8d14, 0x8d17, 0x8d11, 0x8d2d,
  0x8d2b, 0x8d2a, 0x8d25, 0x8d3d, 0x8d3c, 0x8d3f, 0x8d38, 0x8d34,
  0x8d37, 0x8d33, 0x8d4d, 0x8d4f, 0x8d48, 0x8d4b, 0x8d44, 0x8d42,
  0x8d5f, 0x8d5a, 0x8d57, 0x8d56, 0x8d51, 0x8d6c, 0x8d6f, 0x8d6e,
  0x8d66, 0x8d63, 0x8d7d, 0x8d7e, 0x8d78, 0x8d77,
  /* 0x5d */
  0x8d76, 0x8d71, 0x8d70, 0x8d84, 0x8d80, 0x8d9d, 0x8d99, 0x8d98,
  0x8d96, 0x8d91, 0x8d92, 0x8dad, 0x8da8, 0x8dbd, 0x8db9, 0x8db8,
  0x8dbb, 0x8dba, 0x8db1, 0x8dd9, 0x8dd8, 0x8ddb, 0x8dda, 0x8dd5,
  0x8de8, 0x8de4, 0x8de6, 0x8de0, 0x8dfc, 0x8dfe, 0x8dfb, 0x8df4,
  0x8df0, 0x8df2, 0x8e09, 0x8e08, 0x8e0a, 0x8e02, 0x8e1c, 0x8e1f,
  0x8e19, 0x8e18, 0x8e13, 0x8e2d, 0x8e2f, 0x8e29, 0x8e2b, 0x8e26,
  0x8e21, 0x8e22, 0x8e38, 0x8e3a, 0x8e30, 0x8e33, 0x8e4d, 0x8e4e,
  0x8e48, 0x8e4a, 0x8e44, 0x8e40, 0x8e43, 0x8e5e, 0x8e5b, 0x8e5a,
  0x8e55, 0x8e51, 0x8e50, 0x8e6c, 0x8e68, 0x8e6a, 0x8e78, 0x8e7b,
  0x8e7a, 0x8e74, 0x8e77, 0x8e76, 0x8e73, 0x8e72, 0x8e8d, 0x8e8e,
  0x8e8b, 0x8e86, 0x8e82, 0x8e9d, 0x8e9f, 0x8e9b, 0x8e9a, 0x8e94,
  0x8e92, 0x8eaa, 0x8ea4, 0x8ea3, 0x8ea2, 0x8ebe,
  /* 0x5e */
  0x8ebb, 0x8eba, 0x8eb6, 0x8eb3, 0x8ece, 0x8ecb, 0x8ec5, 0x8ec4,
  0x8ec7, 0x8edc, 0x8ede, 0x8ed9, 0x8ed8, 0x8eda, 0x8ed0, 0x8ed2,
  0x8ee1, 0x8efd, 0x8ef9, 0x8ef8, 0x8efb, 0x8ef1, 0x8ef2, 0x8f08,
  0x8f0b, 0x8f06, 0x8f1c, 0x8f11, 0x8f13, 0x8f12, 0x8f07, 0x8f20,
  0x8f3d, 0x8f3a, 0x8f31, 0x8f4f, 0x8f4e, 0x8f49, 0x8f48, 0x8f4b,
  0x8f45, 0x8f5f, 0x8f5e, 0x8f59, 0x8f54, 0x8f40, 0x8f53, 0x8f6e,
  0x8f60, 0x8f7b, 0x8f75, 0x8f74, 0x8f71, 0x8f73, 0x8f8c, 0x8f89,
  0x8f88, 0x8f86, 0x8f80, 0x8f82, 0x8f99, 0x8f98, 0x8f91, 0x8f93,
  0x8f92, 0x8835, 0x8834, 0x8830, 0x8833, 0x8848, 0x884a, 0x8844,
  0x8846, 0x8842, 0x885c, 0x885e, 0x8859, 0x885a, 0x8855, 0x8856,
  0x8850, 0x8854, 0x886e, 0x8869, 0x886b, 0x8865, 0x8864, 0x8860,
  0x887e, 0x8878, 0x887b, 0x8876, 0x8873, 0x888b,
  /* 0x5f */
  0x888a, 0x8886, 0x889d, 0x889f, 0x889e, 0x8894, 0x8896, 0x8891,
  0x88a9, 0x88b4, 0x88b7, 0x88c8, 0x88cb, 0x88c4, 0x88c6, 0x88c2,
  0x88db, 0x88d8, 0x88d4, 0x88d0, 0x88ec, 0x88e5, 0x88e1, 0x88e2,
  0x88fd, 0x88ff, 0x88f8, 0x88fa, 0x88f5, 0x88f3, 0x88f2, 0x890c,
  0x890e, 0x8904, 0x891f, 0x891a, 0x8916, 0x8968, 0x8964, 0x8961,
  0x8963, 0x8972, 0x898f, 0x8989, 0x8985, 0x8980, 0x899d, 0x899c,
  0x8998, 0x8993, 0x8992, 0x89ad, 0x89ab, 0x89a6, 0x89a1, 0x89a2,
  0x89bf, 0x89b8, 0x89ba, 0x89b4, 0x89b6, 0x89cd, 0x89c8, 0x89cb,
  0x89ca, 0x89c5, 0x89c7, 0x89c3, 0x89dc, 0x89d9, 0x89d8, 0x89da,
  0x89d4, 0x89e9, 0x89e8, 0x89ea, 0x89e1, 0x89fd, 0x89b1, 0x89fc,
  0x89ff, 0x89f9, 0x89f0, 0x8a0c, 0x8a09, 0x8a08, 0x8a0b, 0x8a06,
  0x8a1c, 0x8a19, 0x8a1b, 0x8a2d, 0x8a2c, 0x8a2f,
  /* 0x60 */
  0x8a2e, 0x8a2b, 0x8a2a, 0x8a3c, 0x8a3e, 0x8a3b, 0x8a3a, 0x8a35,
  0x8a34, 0x8a30, 0x8a4d, 0x8a4c, 0x8a46, 0x8a40, 0x8a43, 0x8a42,
  0x8a59, 0x8a56, 0x8a51, 0x8a50, 0x8a53, 0x8a6c, 0x8a6f, 0x8a64,
  0x8a61, 0x8a60, 0x8a62, 0x8a7d, 0x8a7c, 0x8a74, 0x8a77, 0x8a76,
  0x8a8f, 0x8a8e, 0x8a84, 0x8a9d, 0x8a9f, 0x8a98, 0x8a97, 0x8a96,
  0x8a90, 0x8a93, 0x8aaf, 0x8aaa, 0x8aa4, 0x8aa0, 0x8aa3, 0x8abe,
  0x8ab8, 0x8ab7, 0x8ab6, 0x8acd, 0x8acc, 0x8ace, 0x8ac9, 0x8aca,
  0x8ac2, 0x8adc, 0x8ad9, 0x8ad1, 0x8ae5, 0x8ae3, 0x8afd, 0x8afc,
  0x8afa, 0x8af4, 0x8af7, 0x8ae0, 0x8b0d, 0x8b0f, 0x8b0a, 0x8b05,
  0x8b02, 0x8b1d, 0x8b1b, 0x8b1a, 0x8b15, 0x8b13, 0x8b2d, 0x8b2c,
  0x8b2e, 0x8b28, 0x8b2a, 0x8b25, 0x8b21, 0x8b20, 0x8b23, 0x8b39,
  0x8b38, 0x8b3b, 0x8b3a, 0x8b37, 0x8b4d, 0x8b4c,
  /* 0x61 */
  0x8b4e, 0x8b4a, 0x8b42, 0x8b5c, 0x8b5f, 0x8b5e, 0x8b59, 0x8b58,
  0x8b55, 0x8b50, 0x8b53, 0x8b68, 0x8b90, 0x8bad, 0x8bac, 0x8ba9,
  0x8ba8, 0x8bab, 0x8bb8, 0x8bbb, 0x8bb5, 0x8bb3, 0x8bcd, 0x8bcc,
  0x8bcb, 0x8bc7, 0x8bc6, 0x8bc0, 0x8bdd, 0x8bdf, 0x8bde, 0x8bd8,
  0x8bed, 0x8bee, 0x8be9, 0x8be5, 0x8be3, 0x8bfc, 0x8bf8, 0x8bfb,
  0x8bf6, 0x8bf3, 0x940f, 0x9409, 0x9405, 0x9401, 0x9415, 0x9416,
  0x9425, 0x9424, 0x9422, 0x9427, 0x9421, 0x9420, 0x943e, 0x9439,
  0x943a, 0x9432, 0x944e, 0x9449, 0x9441, 0x9456, 0x9450, 0x946f,
  0x946b, 0x946a, 0x9461, 0x947d, 0x9479, 0x9474, 0x9488, 0x9485,
  0x9486, 0x9481, 0x9483, 0x949d, 0x9498, 0x949a, 0x9495, 0x9494,
  0x9496, 0x94ad, 0x94ac, 0x94af, 0x94a8, 0x94bd, 0x94bf, 0x94be,
  0x94b9, 0x94bb, 0x94b0, 0x94c1, 0x94b3, 0x94ce,
  /* 0x62 */
  0x94c9, 0x94c8, 0x94ca, 0x94c5, 0x94d8, 0x94da, 0x94d5, 0x94d4,
  0x94d1, 0x94d0, 0x94d2, 0x94e8, 0x94df, 0x94fb, 0x94e6, 0x94e2,
  0x94fd, 0x94f9, 0x94f3, 0x94f2, 0x950d, 0x9509, 0x9508, 0x950b,
  0x9505, 0x9500, 0x951d, 0x9519, 0x951b, 0x951a, 0x9515, 0x9517,
  0x9511, 0x9513, 0x952d, 0x9528, 0x952f, 0x952e, 0x952a, 0x9524,
  0x9523, 0x9522, 0x953c, 0x9539, 0x953b, 0x953a, 0x9534, 0x9537,
  0x9531, 0x9530, 0x954e, 0x954a, 0x9545, 0x9542, 0x955e, 0x955a,
  0x9554, 0x9557, 0x9556, 0x956c, 0x9569, 0x956a, 0x9560, 0x9579,
  0x9574, 0x9577, 0x9576, 0x958c, 0x958e, 0x9588, 0x958b, 0x9587,
  0x9583, 0x959c, 0x959e, 0x9599, 0x9598, 0x9595, 0x9593, 0x95ac,
  0x95ab, 0x95a5, 0x95a1, 0x95a0, 0x95a3, 0x95bd, 0x95bc, 0x95bf,
  0x95be, 0x95bb, 0x95b6, 0x95b1, 0x95b0, 0x95b2,
  /* 0x63 */
  0x95cf, 0x95ce, 0x95c8, 0x95de, 0x95d9, 0x95da, 0x95d4, 0x95d7,
  0x95d3, 0x95e9, 0x95e8, 0x95e4, 0x95e7, 0x95e1, 0x95e0, 0x95e3,
  0x95e2, 0x95fd, 0x95fc, 0x95fa, 0x95f4, 0x95f6, 0x95f0, 0x960d,
  0x960c, 0x9609, 0x9608, 0x960b, 0x960a, 0x9604, 0x9607, 0x9601,
  0x961d, 0x961f, 0x961e, 0x961b, 0x9615, 0x9611, 0x9610, 0x962e,
  0x9629, 0x9628, 0x962b, 0x9625, 0x9623, 0x9622, 0x963d, 0x963e,
  0x9638, 0x963b, 0x9635, 0x9634, 0x9637, 0x9631, 0x9633, 0x964d,
  0x964f, 0x964e, 0x964b, 0x964a, 0x9647, 0x9640, 0x9643, 0x9642,
  0x965c, 0x9655, 0x9654, 0x9651, 0x9650, 0x966d, 0x966c, 0x9668,
  0x966a, 0x9665, 0x9664, 0x9663, 0x9662, 0x967d, 0x9678, 0x967b,
  0x967a, 0x9675, 0x9674, 0x9676, 0x9671, 0x9670, 0x9672, 0x9685,
  0x9684, 0x9687, 0x9680, 0x9683, 0x969f, 0x969a,
  /* 0x64 */
  0x9694, 0x9692, 0x96ad, 0x96a9, 0x96a8, 0x96aa, 0x96a5, 0x96a6,
  0x96a2, 0x96bf, 0x96bb, 0x96b5, 0x96b7, 0x96b6, 0x96b1, 0x96b0,
  0x96b2, 0x96cd, 0x96cc, 0x96cf, 0x96ce, 0x96c8, 0x96cb, 0x96ca,
  0x96c5, 0x96c6, 0x96c1, 0x96c0, 0x96c3, 0x96dd, 0x96de, 0x96d8,
  0x96da, 0x96d5, 0x96d4, 0x96d1, 0x96d0, 0x96d2, 0x96ed, 0x96ec,
  0x96ee, 0x96e8, 0x96ea, 0x96e5, 0x96e1, 0x96e3, 0x96fd, 0x96f4,
  0x96f6, 0x96f2, 0x970d, 0x970f, 0x9705, 0x9700, 0x971c, 0x9719,
  0x9718, 0x9711, 0x9710, 0x9713, 0x9712, 0x972c, 0x9729, 0x9728,
  0x972a, 0x9724, 0x9727, 0x973e, 0x9739, 0x973b, 0x973a, 0x974a,
  0x9745, 0x9744, 0x975d, 0x975c, 0x975f, 0x9758, 0x975a, 0x9755,
  0x9757, 0x9753, 0x9769, 0x9768, 0x976a, 0x9764, 0x9767, 0x9760,
  0x9762, 0x977d, 0x977c, 0x977e, 0x9779, 0x977b,
  /* 0x65 */
  0x9777, 0x9770, 0x9772, 0x978d, 0x978c, 0x978f, 0x9785, 0x9787,
  0x9786, 0x9780, 0x9782, 0x979f, 0x9798, 0x9795, 0x9796, 0x9793,
  0x97ac, 0x97ae, 0x97a9, 0x97ab, 0x97a5, 0x97a6, 0x97b9, 0x97b8,
  0x97bb, 0x97b7, 0x97a4, 0x97cc, 0x97c9, 0x97c8, 0x97cb, 0x97ca,
  0x97c4, 0x97c7, 0x97c6, 0x97c1, 0x97c0, 0x97de, 0x97d4, 0x97d1,
  0x97d3, 0x97d2, 0x97ef, 0x97eb, 0x97ea, 0x97f4, 0x97fa, 0x97f5,
  0x97f7, 0x97f6, 0x97f0, 0x900c, 0x900f, 0x9009, 0x9005, 0x9004,
  0x9000, 0x9003, 0x9002, 0x9018, 0x901b, 0x901a, 0x9012, 0x9023,
  0x9022, 0x903c, 0x903f, 0x903e, 0x9039, 0x9036, 0x9032, 0x9030,
  0x904e, 0x9048, 0x9045, 0x9047, 0x9041, 0x9058, 0x9054, 0x9051,
  0x9052, 0x906c, 0x906e, 0x9065, 0x9066, 0x9060, 0x9063, 0x9062,
  0x907c, 0x907f, 0x9089, 0x908e, 0x9175, 0x9174,
  /* 0x66 */
  0x9173, 0x9189, 0x9185, 0x9181, 0x9180, 0x9183, 0x9190, 0x9193,
  0x9192, 0x91ac, 0x91ab, 0x91a4, 0x91a6, 0x91a1, 0x91b9, 0x91bb,
  0x91b7, 0x91b0, 0x91b2, 0x91cb, 0x91c5, 0x91c4, 0x91c6, 0x91dd,
  0x91dc, 0x91df, 0x91de, 0x91d4, 0x91d7, 0x91d0, 0x91d3, 0x91d2,
  0x91ed, 0x91e9, 0x91eb, 0x9210, 0x9213, 0x922f, 0x9229, 0x9228,
  0x922b, 0x9221, 0x923c, 0x923e, 0x923a, 0x9235, 0x9234, 0x9237,
  0x9231, 0x9230, 0x924c, 0x925f, 0x9259, 0x925b, 0x925a, 0x9255,
  0x926c, 0x9263, 0x9279, 0x9276, 0x9271, 0x9273, 0x9272, 0x928c,
  0x928f, 0x928e, 0x9289, 0x9284, 0x929c, 0x929b, 0x9297, 0x9290,
  0x9292, 0x92a9, 0x92a8, 0x92ab, 0x92a4, 0x92a3, 0x92a2, 0x92be,
  0x92b7, 0x92c7, 0x92df, 0x59bf, 0x92d5, 0x92d7, 0x92d0, 0x92d3,
  0x92d2, 0x92e4, 0x92e2, 0x92fc, 0x92f7, 0x930f,
  /* 0x67 */
  0x930e, 0x9308, 0x9304, 0x9317, 0x9316, 0x9310, 0x932c, 0x932f,
  0x932e, 0x9325, 0x933c, 0x933e, 0x934c, 0x934e, 0x9347, 0x9343,
  0x9342, 0x9358, 0x935a, 0x9355, 0x9357, 0x9356, 0x936e, 0x936a,
  0x9367, 0x9363, 0x937e, 0x937b, 0x937a, 0x9375, 0x9376, 0x9370,
  0x9372, 0x938d, 0x9384, 0x9398, 0x939b, 0x939a, 0x9394, 0x9397,
  0x9393, 0x9392, 0x93af, 0x93a1, 0x93a3, 0x93bc, 0x93bf, 0x93b8,
  0x93bb, 0x93b5, 0x93b4, 0x93b7, 0x93b1, 0x93b3, 0x93b2, 0x93cc,
  0x93c9, 0x93c8, 0x93ca, 0x93c4, 0x93c7, 0x93c1, 0x93c0, 0x93c3,
  0x93dd, 0x93dc, 0x93d9, 0x93da, 0x93d5, 0x93d4, 0x93d0, 0x93d3,
  0x93ed, 0x93d6, 0x93ec, 0x93e9, 0x93e2, 0x93fc, 0x93f9, 0x93fa,
  0x93f5, 0x93f7, 0x9c0a, 0x9c07, 0x9c14, 0x9c00, 0x9c03, 0x9c19,
  0x9c1b, 0x9c11, 0x9c13, 0x9c2d, 0x9c2e, 0x9c2b,
  /* 0x68 */
  0x9c26, 0x9c23, 0x9c22, 0x9c3d, 0x9c3f, 0x9c3e, 0x9c38, 0x9c28,
  0x9c33, 0x9c49, 0x9c4a, 0x9c47, 0x9c5c, 0x9c5f, 0x9c5e, 0x9c5b,
  0x9c5a, 0x9c54, 0x9c57, 0x9c6f, 0x9c6e, 0x9c68, 0x9c6b, 0x9c67,
  0x9c61, 0x9ca6, 0x9ca0, 0x9ca3, 0x9cbd, 0x9cb9, 0x9cba, 0x9cb5,
  0x9cb7, 0x9cb6, 0x9cb2, 0x9ccf, 0x9cc8, 0x9cc5, 0x9cc1, 0x9cec,
  0x9cee, 0x9ce8, 0x9ceb, 0x9cea, 0x9ce7, 0x9cfe, 0x9cfb, 0x9d0f,
  0x9d0a, 0x9d05, 0x9d1c, 0x9d18, 0x9d1b, 0x9d1a, 0x9d17, 0x9d16,
  0x9d11, 0x9d12, 0x9d2f, 0x9d2b, 0x9d2a, 0x9d26, 0x9d3c, 0x9d3f,
  0x9d3e, 0x9d39, 0x9d38, 0x9d34, 0x9d37, 0x9d36, 0x9d31, 0x9d4d,
  0x9d4c, 0x9d4b, 0x9d4a, 0x9d45, 0x9d40, 0x9d43, 0x9d59, 0x9d55,
  0x9d54, 0x9d56, 0x9d51, 0x9d53, 0x9d52, 0x9d6d, 0x9d96, 0x9d90,
  0x9d92, 0x9dab, 0x9dbd, 0x9dbc, 0x9dbf, 0x9db8,
  /* 0x69 */
  0x9db4, 0x9db7, 0x9db0, 0x9db2, 0x9dce, 0x9dc4, 0x9dde, 0x9dd9,
  0x9dd4, 0x9dd7, 0x9dd1, 0x9dd3, 0x9dea, 0x9de7, 0x9de6, 0x9de1,
  0x9dfd, 0x9df9, 0x9df8, 0x9df4, 0x9df0, 0x9df3, 0x9e0f, 0x9e0e,
  0x9e09, 0x9e06, 0x9e01, 0x9e1d, 0x9e1c, 0x9e1b, 0x9e13, 0x9e2d,
  0x9e2f, 0x9e2e, 0x9e29, 0x9e2a, 0x9e20, 0x9e23, 0x9e3e, 0x9e38,
  0x9e3b, 0x9e35, 0x9e4a, 0x9e4c, 0x9e49, 0x9e47, 0x9e46, 0x9e41,
  0x9e43, 0x9e5c, 0x9e59, 0x9e5b, 0x9e50, 0x9ea7, 0x9ea1, 0x9ea3,
  0x9ea2, 0x9ebf, 0x9eb9, 0x9eb8, 0x9ebb, 0x9eb4, 0x9eb6, 0x9eb3,
  0x9eb2, 0x9ecc, 0x9ece, 0x9ecb, 0x9ec5, 0x9ec3, 0x9edd, 0x9edf,
  0x9ed8, 0x9edb, 0x9eda, 0x9ed6, 0x9ed1, 0x9eed, 0x9ee9, 0x9ee8,
  0x9eea, 0x9ee4, 0x9ee1, 0x9eff, 0x9efe, 0x9ef8, 0x9ef4, 0x9ef7,
  0x9ef0, 0x9ef2, 0x9f0d, 0x9f0c, 0x9f0f, 0x9f0e,
  /* 0x6a */
  0x9f09, 0x9f08, 0x9f05, 0x9f04, 0x9f06, 0x9f01, 0x9f00, 0x9f03,
  0x9f1d, 0x9f1f, 0x9f1b, 0x9f14, 0x9f16, 0x9f11, 0x9f2d, 0x9f2b,
  0x9f26, 0x9f20, 0x9f3e, 0x9f39, 0x9f38, 0x9f3a, 0x9f34, 0x9f37,
  0x9f30, 0x9f45, 0x9f46, 0x9f41, 0x9f58, 0x9f5b, 0x9f5a, 0x9f56,
  0x9f53, 0x9f6c, 0x9f6e, 0x9f68, 0x9f6b, 0x9f65, 0x9f67, 0x9f66,
  0x9f61, 0x9f60, 0x9f63, 0x9f7e, 0x9f78, 0x9f7a, 0x9f75, 0x9f74,
  0x9f72, 0x9f8d, 0x9f89, 0x9f88, 0x9f8b, 0x9f8a, 0x9f84, 0x9f87,
  0x9f86, 0x9f80, 0x9f82, 0x9f9d, 0x9f99, 0x9f97, 0x9f90, 0x9f93,
  0x9fab, 0x9faa, 0x9fa4, 0x9fa1, 0x9fbd, 0x9fbc, 0x9fbf, 0x9fba,
  0x9fb5, 0x9fb6, 0x9fb1, 0x9fb3, 0x9fb2, 0x9fcc, 0x9fca, 0x9fc5,
  0x9fc3, 0x9fdd, 0x9fda, 0x9fd5, 0x9fd0, 0x9fd2, 0x9fe8, 0x9fea,
  0x9fe7, 0x9fe6, 0x9fe2, 0x9ffe, 0x9ffa, 0x9ff5,
  /* 0x6b */
  0x9ff4, 0x9ff7, 0x9ff0, 0x9ff2, 0x980d, 0x980f, 0x9806, 0x9802,
  0x981c, 0x981b, 0x9815, 0x9814, 0x9817, 0x9811, 0x9813, 0x982f,
  0x982e, 0x982b, 0x982a, 0x9825, 0x9824, 0x9827, 0x983c, 0x9838,
  0x983b, 0x983a, 0x9830, 0x984c, 0x984e, 0x9849, 0x9848, 0x9844,
  0x9847, 0x9843, 0x9842, 0x985d, 0x985e, 0x9859, 0x985b, 0x9855,
  0x9856, 0x9850, 0x9853, 0x9852, 0x986e, 0x9864, 0x9867, 0x9851,
  0x9866, 0x9865, 0x9863, 0x987d, 0x987f, 0x9878, 0x987a, 0x9876,
  0x98eb, 0x98ff, 0x98fa, 0x98f4, 0x9906, 0x990f, 0x991c, 0x991a,
  0x9915, 0x9911, 0x9910, 0x9913, 0x9922, 0x993d, 0x993f, 0x993e,
  0x9939, 0x9937, 0x9931, 0x9948, 0x9930, 0x994f, 0x994e, 0x994a,
  0x9947, 0x995e, 0x9959, 0x9952, 0x996e, 0x996f, 0x9968, 0x9964,
  0x9967, 0x9966, 0x997d, 0x997b, 0x997a, 0x9976,
  /* 0x6c */
  0x9971, 0x9973, 0x998e, 0x9989, 0x998b, 0x9987, 0x9980, 0x9983,
  0x999f, 0x999e, 0x9998, 0x999b, 0x999a, 0x9995, 0x99ac, 0x99a7,
  0x99a1, 0x99a3, 0x99bc, 0x99b8, 0x99b4, 0x99b1, 0x99b2, 0x99ce,
  0x99ca, 0x99c4, 0x99c7, 0x99d9, 0x99d8, 0x99db, 0x99da, 0x99d7,
  0x99d3, 0x99d2, 0x99ed, 0x99e8, 0x99ea, 0x99e4, 0x99e6, 0x99e3,
  0x99fd, 0x99fe, 0x99f9, 0x99f3, 0x9a07, 0x9a0f, 0x9a0a, 0x9a03,
  0x9a1d, 0x9a1c, 0x9a1f, 0x9a18, 0x9a1b, 0x9a14, 0x9a11, 0x9a10,
  0x9a77, 0x9a76, 0x9a71, 0x9a8d, 0x9a8f, 0x9a8e, 0x9a89, 0x9a88,
  0x9a8a, 0x9a83, 0x9a82, 0x9a9b, 0x9a95, 0x9a96, 0x9a93, 0x9aa9,
  0x9aa5, 0x9aa1, 0x9aa3, 0x9aa2, 0x9abd, 0x9abe, 0x9ab9, 0x9ab8,
  0x9acb, 0x9ac5, 0x9ac6, 0x9ad8, 0x9ad2, 0x9ae9, 0x9aea, 0x9ae1,
  0x9ae0, 0x9ae3, 0x9afd, 0x9afc, 0x9aff, 0x9af8,
  /* 0x6d */
  0x9af5, 0x9af2, 0x9b0f, 0x9b0e, 0x9b04, 0x9b02, 0x9b1d, 0x9b1c,
  0x9b1f, 0x9b19, 0x9b1b, 0x9b1a, 0x9b14, 0x9b17, 0x9b16, 0x9b12,
  0x9b2f, 0x9b2b, 0x9b27, 0x9b26, 0x9b22, 0x9b3c, 0x9b3f, 0x9b39,
  0x9b3a, 0x9b34, 0x9b37, 0x9b31, 0x9b30, 0x9b32, 0x9b4c, 0x9b4e,
  0x9b49, 0x9b48, 0x9b4b, 0x9b4a, 0x9b5e, 0x9b58, 0x9b5b, 0x9b5a,
  0x9b55, 0x9b57, 0x9b50, 0x9b53, 0x9b65, 0x9b64, 0x9b60, 0x9b63,
  0x9b62, 0x9b7d, 0x9b7c, 0x9b7e, 0x9b78, 0x9b77, 0x9b70, 0x9b82,
  0x9b9d, 0x9b9c, 0x9b9f, 0x9b99, 0x9b9b, 0x9b9a, 0x9b93, 0x9bac,
  0x9baf, 0x9bae, 0x9ba8
};

static const acp_uint16_t jisx0212_2charset[ /*6067*/ ] = {
  0x264f, 0x267d, 0x264e, 0x2660, 0x2661, 0x2663, 0x2639, 0x263c,
  0x2666, 0x2649, 0x2e2f, 0x2e2c, 0x2e29, 0x2e27, 0x2e2e, 0x2e24,
  0x2d2c, 0x2e23, 0x2e3f, 0x2e3c, 0x2e39, 0x2e3e, 0x2e4d, 0x2e32,
  0x2e4f, 0x2e4c, 0x2e5d, 0x2e5f, 0x2e5c, 0x2e59, 0x2e55, 0x2e5e,
  0x2d21, 0x2e6e, 0x2e6f, 0x2e68, 0x2e69, 0x2e7f, 0x2d3d, 0x2d43,
  0x2f2f, 0x2f2c, 0x2f29, 0x2f27, 0x2f2e, 0x2f24, 0x2d4c, 0x2f23,
  0x2f3f, 0x2f3c, 0x2f39, 0x2f3e, 0x2f4d, 0x2f32, 0x2f4f, 0x2f4c,
  0x2d4e, 0x2f5d, 0x2f5f, 0x2f5c, 0x2f59, 0x2f55, 0x2f5e, 0x2d41,
  0x2f6e, 0x2f6f, 0x2f68, 0x2f69, 0x2f7f, 0x2d5d, 0x2f7e, 0x2e2a,
  0x2f2a, 0x2e28, 0x2f28, 0x2e25, 0x2f25, 0x2e26, 0x2f26, 0x2e21,
  0x2f21, 0x2e22, 0x2f22, 0x2e20, 0x2f20, 0x2e3d, 0x2f3d, 0x2d2f,
  0x2d4f, 0x2e3a, 0x2f3a, 0x2e3b, 0x2f3b, 0x2e35, 0x2f35, 0x2e38,
  0x2f38, 0x2e37, 0x2f37, 0x2e36, 0x2f36, 0x2e30, 0x2f30, 0x2e31,
  0x2e33, 0x2f33, 0x2d29, 0x2d49, 0x2e4a, 0x2f4a, 0x2e48, 0x2f48,
  0x2e4b, 0x2f4b, 0x2e49, 0x2d48, 0x2d2b, 0x2d4b, 0x2e45, 0x2f45,
  0x2e44, 0x2f44, 0x2d4a, 0x2e47, 0x2f47, 0x2e41, 0x2f41, 0x2e46,
  0x2f46, 0x2d24, 0x2d44, 0x2d25, 0x2d45, 0x2e40, 0x2f40, 0x2e42,
  0x2f42, 0x2e43, 0x2f43, 0x2d47, 0x2d26, 0x2d46, 0x2e5a, 0x2f5a,
  0x2e5b, 0x2f5b, 0x2d20, 0x2d40, 0x2e54, 0x2f54, 0x2e56, 0x2f56,
  0x2e57, 0x2f57, 0x2e51, 0x2f51, 0x2e50, 0x2f50, 0x2e52, 0x2f52,
  0x2e53, 0x2f53, 0x2e6c, 0x2f6c, 0x2e6d, 0x2f6d, 0x2d22, 0x2d42,
  0x2e61, 0x2f61, 0x2e64, 0x2f64, 0x2e6b, 0x2f6b, 0x2e66, 0x2f66,
  0x2e65, 0x2f65, 0x2e67, 0x2f67, 0x2e7c, 0x2f7c, 0x2e79, 0x2f79,
  0x2e7e, 0x2e78, 0x2f78, 0x2e7a, 0x2f7a, 0x2e7b, 0x2f7b, 0x2e2b,
  0x2f2b, 0x2e4e, 0x2f4e, 0x2e58, 0x2f58, 0x2e6a, 0x2f6a, 0x2e7d,
  0x2f7d, 0x2e60, 0x2f60, 0x2e62, 0x2f62, 0x2e63, 0x2f63, 0x2f34,
  0x263d, 0x2622, 0x263f, 0x263b, 0x2638, 0x263e, 0x2635, 0x2634,
  0x226c, 0x226f, 0x226e, 0x2269, 0x226a, 0x2264, 0x2261, 0x227b,
  0x2268, 0x2267, 0x227c, 0x227f, 0x227e, 0x2279, 0x2276, 0x2275,
  0x2278, 0x2277, 0x227a, 0x2274, 0x2271, 0x234f, 0x234e, 0x2349,
  0x2348, 0x234b, 0x234a, 0x2345, 0x2344, 0x2347, 0x2346, 0x2341,
  0x2340, 0x2343, 0x237f, 0x237e, 0x2379, 0x2378, 0x237b, 0x237a,
  0x2375, 0x2374, 0x2377, 0x2376, 0x2371, 0x2370, 0x2373, 0x267c,
  0x2662, 0x342c, 0x342f, 0x342e, 0x3429, 0x3428, 0x342b, 0x342a,
  0x3425, 0x3424, 0x3427, 0x3426, 0x3421, 0x3420, 0x3423, 0x3422,
  0x343d, 0x343c, 0x343f, 0x343e, 0x3439, 0x3438, 0x343b, 0x343a,
  0x3435, 0x3434, 0x3437, 0x3436, 0x3431, 0x3430, 0x3433, 0x3432,
  0x344d, 0x344c, 0x344f, 0x344e, 0x3449, 0x3448, 0x344b, 0x344a,
  0x3445, 0x3444, 0x3447, 0x3446, 0x3441, 0x3440, 0x3443, 0x3442,
  0x345d, 0x345c, 0x345f, 0x345e, 0x3459, 0x3458, 0x345b, 0x345a,
  0x3455, 0x3454, 0x3457, 0x3456, 0x3451, 0x3450, 0x3453, 0x346d,
  0x346c, 0x346f, 0x346e, 0x3469, 0x3468, 0x346b, 0x346a, 0x3465,
  0x3464, 0x3467, 0x3466, 0x3461, 0x3460, 0x3463, 0x3462, 0x347d,
  0x3452, 0x347c, 0x347f, 0x347e, 0x3479, 0x3478, 0x347b, 0x347a,
  0x3475, 0x3474, 0x3477, 0x3476, 0x3471, 0x3470, 0x3473, 0x352c,
  0x352f, 0x352e, 0x3529, 0x3528, 0x352b, 0x352a, 0x3525, 0x3524,
  0x3527, 0x3526, 0x3521, 0x3520, 0x3523, 0x3522, 0x353d, 0x353c,
  0x353f, 0x353e, 0x3539, 0x3538, 0x353b, 0x353a, 0x3535, 0x3534,
  0x3537, 0x3536, 0x3531, 0x3530, 0x3533, 0x3532, 0x354d, 0x354c,
  0x354f, 0x354e, 0x3549, 0x3548, 0x354b, 0x354a, 0x3545, 0x3544,
  0x3547, 0x3546, 0x3541, 0x3540, 0x3543, 0x3542, 0x355d, 0x355c,
  0x355f, 0x355e, 0x3559, 0x3558, 0x355b, 0x355a, 0x3555, 0x3554,
  0x3557, 0x3556, 0x3551, 0x3550, 0x3553, 0x357b, 0x3552, 0x356d,
  0x356c, 0x356f, 0x356e, 0x3569, 0x3568, 0x356b, 0x356a, 0x3565,
  0x3564, 0x3567, 0x3566, 0x3561, 0x3560, 0x3563, 0x3562, 0x357d,
  0x357c, 0x357f, 0x357e, 0x3579, 0x3578, 0x357a, 0x3575, 0x3574,
  0x3577, 0x3576, 0x3571, 0x3570, 0x3573, 0x362c, 0x362f, 0x362e,
  0x3629, 0x3628, 0x362b, 0x362a, 0x3625, 0x3624, 0x3627, 0x3626,
  0x3621, 0x3620, 0x3623, 0x3622, 0x363d, 0x363c, 0x363f, 0x363e,
  0x3639, 0x3638, 0x363b, 0x363a, 0x3635, 0x3634, 0x3637, 0x3636,
  0x3631, 0x3630, 0x3633, 0x3632, 0x364d, 0x364c, 0x364f, 0x364e,
  0x3649, 0x3648, 0x365c, 0x364b, 0x364a, 0x3645, 0x3644, 0x3647,
  0x3646, 0x3641, 0x3640, 0x3643, 0x3642, 0x365d, 0x365f, 0x365e,
  0x3659, 0x3658, 0x365b, 0x365a, 0x3655, 0x3654, 0x3657, 0x3656,
  0x3651, 0x3650, 0x3653, 0x3652, 0x366d, 0x366c, 0x366f, 0x366e,
  0x3669, 0x3668, 0x366b, 0x366a, 0x3665, 0x3664, 0x3667, 0x3666,
  0x3661, 0x3660, 0x3663, 0x3662, 0x367d, 0x367c, 0x367f, 0x367e,
  0x3679, 0x3678, 0x367b, 0x367a, 0x3675, 0x3674, 0x3677, 0x3676,
  0x3671, 0x3670, 0x3673, 0x372c, 0x372f, 0x372e, 0x3729, 0x3728,
  0x372b, 0x372a, 0x3725, 0x3724, 0x3727, 0x3726, 0x3721, 0x3720,
  0x3723, 0x3722, 0x373d, 0x373c, 0x373f, 0x373e, 0x3739, 0x3738,
  0x373b, 0x373a, 0x3735, 0x3734, 0x3737, 0x3736, 0x3731, 0x3730,
  0x3733, 0x3732, 0x374d, 0x374c, 0x374f, 0x374e, 0x3749, 0x3748,
  0x374b, 0x374a, 0x3745, 0x3744, 0x3747, 0x3746, 0x3741, 0x3740,
  0x3743, 0x3742, 0x375d, 0x375c, 0x375f, 0x375e, 0x3759, 0x3758,
  0x375b, 0x375a, 0x3755, 0x3754, 0x3757, 0x3756, 0x3751, 0x3750,
  0x3753, 0x3752, 0x376d, 0x376c, 0x376f, 0x376e, 0x3769, 0x3768,
  0x376b, 0x376a, 0x3765, 0x3764, 0x3767, 0x3766, 0x3761, 0x3760,
  0x3763, 0x3762, 0x377d, 0x377c, 0x377f, 0x377e, 0x3779, 0x3778,
  0x377b, 0x377a, 0x3775, 0x3774, 0x3777, 0x3776, 0x3771, 0x3770,
  0x3773, 0x302c, 0x302f, 0x302e, 0x3029, 0x3028, 0x302b, 0x302a,
  0x3025, 0x3024, 0x3027, 0x3026, 0x3021, 0x3020, 0x3023, 0x3022,
  0x303d, 0x303c, 0x303f, 0x303e, 0x3039, 0x3038, 0x303b, 0x3035,
  0x303a, 0x3034, 0x3037, 0x3036, 0x3031, 0x3030, 0x3033, 0x3032,
  0x304d, 0x304c, 0x304f, 0x304e, 0x3049, 0x3048, 0x304b, 0x304a,
  0x3045, 0x3044, 0x3047, 0x3046, 0x3041, 0x3040, 0x3043, 0x3042,
  0x305d, 0x305c, 0x305f, 0x305e, 0x3059, 0x3058, 0x305b, 0x305a,
  0x3055, 0x3054, 0x3057, 0x3056, 0x3051, 0x3050, 0x3053, 0x3052,
  0x306d, 0x306c, 0x306f, 0x306e, 0x3069, 0x3068, 0x306b, 0x306a,
  0x3065, 0x3064, 0x3067, 0x3066, 0x3061, 0x3060, 0x3063, 0x3062,
  0x307d, 0x307c, 0x307f, 0x307e, 0x3079, 0x3078, 0x307b, 0x307a,
  0x3075, 0x3074, 0x3077, 0x3076, 0x3071, 0x3070, 0x3073, 0x312c,
  0x312f, 0x312e, 0x3129, 0x3128, 0x312b, 0x312a, 0x3125, 0x3124,
  0x3127, 0x3126, 0x3121, 0x3120, 0x3123, 0x3122, 0x313d, 0x313c,
  0x313f, 0x313e, 0x3139, 0x3138, 0x313b, 0x313a, 0x3135, 0x3134,
  0x3137, 0x3136, 0x3131, 0x3130, 0x3133, 0x3132, 0x314d, 0x314c,
  0x314f, 0x314e, 0x3149, 0x3148, 0x314b, 0x314a, 0x3145, 0x3144,
  0x3147, 0x3146, 0x3141, 0x3140, 0x3143, 0x3142, 0x315d, 0x315c,
  0x315f, 0x315e, 0x3159, 0x3158, 0x315b, 0x315a, 0x3155, 0x3154,
  0x3157, 0x3156, 0x3151, 0x3150, 0x3153, 0x3152, 0x316d, 0x316c,
  0x316f, 0x316e, 0x3169, 0x3168, 0x316b, 0x316a, 0x3165, 0x3164,
  0x3167, 0x3166, 0x3161, 0x3160, 0x3163, 0x3162, 0x317d, 0x317c,
  0x317f, 0x317e, 0x3179, 0x3178, 0x317b, 0x317a, 0x3175, 0x3174,
  0x3177, 0x3176, 0x3171, 0x3170, 0x3173, 0x322c, 0x322f, 0x322e,
  0x3229, 0x3228, 0x322b, 0x322a, 0x3225, 0x3224, 0x3227, 0x3226,
  0x3221, 0x3220, 0x3223, 0x3222, 0x323d, 0x323c, 0x323f, 0x323e,
  0x3239, 0x3238, 0x323b, 0x323a, 0x3235, 0x3234, 0x3237, 0x3236,
  0x3231, 0x3230, 0x3233, 0x3232, 0x324d, 0x324c, 0x324f, 0x324e,
  0x3249, 0x3248, 0x324b, 0x324a, 0x3245, 0x3244, 0x3247, 0x3246,
  0x3241, 0x3240, 0x3243, 0x3242, 0x325d, 0x325c, 0x325f, 0x325e,
  0x3259, 0x3258, 0x325b, 0x325a, 0x3255, 0x3254, 0x3257, 0x3256,
  0x3251, 0x3250, 0x3253, 0x3252, 0x326d, 0x326c, 0x326f, 0x326e,
  0x3269, 0x3268, 0x326b, 0x326a, 0x3265, 0x3264, 0x3267, 0x3266,
  0x3261, 0x3260, 0x327d, 0x327c, 0x3263, 0x3262, 0x327f, 0x327e,
  0x3279, 0x3278, 0x327b, 0x327a, 0x3275, 0x3274, 0x3277, 0x3276,
  0x3270, 0x3273, 0x3271, 0x332c, 0x332f, 0x332e, 0x3329, 0x3328,
  0x332b, 0x332a, 0x3325, 0x3324, 0x3327, 0x3326, 0x3321, 0x3320,
  0x3323, 0x3322, 0x333d, 0x333c, 0x333f, 0x333e, 0x3339, 0x3338,
  0x333b, 0x333a, 0x3335, 0x3334, 0x3337, 0x3336, 0x3331, 0x3330,
  0x3333, 0x3332, 0x334d, 0x334c, 0x334f, 0x334e, 0x3349, 0x3348,
  0x334b, 0x334a, 0x3345, 0x3344, 0x3347, 0x3346, 0x3341, 0x3340,
  0x3343, 0x3342, 0x335d, 0x335c, 0x335f, 0x335e, 0x3359, 0x3358,
  0x335b, 0x335a, 0x336d, 0x3355, 0x3354, 0x3357, 0x3356, 0x3351,
  0x3350, 0x3353, 0x3352, 0x336c, 0x336f, 0x336e, 0x3369, 0x3368,
  0x336b, 0x336a, 0x3365, 0x3364, 0x3367, 0x3366, 0x3361, 0x3360,
  0x3373, 0x3363, 0x3362, 0x337d, 0x337c, 0x337f, 0x337e, 0x3379,
  0x3378, 0x337b, 0x337a, 0x3375, 0x3374, 0x3377, 0x3376, 0x3371,
  0x3370, 0x3c2c, 0x3c2f, 0x3c2e, 0x3c29, 0x3c28, 0x3c2b, 0x3c2a,
  0x3c25, 0x3c24, 0x3c27, 0x3c26, 0x3c21, 0x3c20, 0x3c23, 0x3c22,
  0x3c3d, 0x3c3c, 0x3c3f, 0x3c3e, 0x3c39, 0x3c38, 0x3c3b, 0x3c3a,
  0x3c35, 0x3c34, 0x3c37, 0x3c36, 0x3c31, 0x3c30, 0x3c33, 0x3c32,
  0x3c4d, 0x3c4c, 0x3c4f, 0x3c4e, 0x3c49, 0x3c48, 0x3c4b, 0x3c4a,
  0x3c45, 0x3c44, 0x3c47, 0x3c46, 0x3c41, 0x3c40, 0x3c43, 0x3c5d,
  0x3c5c, 0x3c42, 0x3c5f, 0x3c5e, 0x3c59, 0x3c58, 0x3c5b, 0x3c5a,
  0x3c55, 0x3c54, 0x3c57, 0x3c56, 0x3c51, 0x3c50, 0x3c53, 0x3c52,
  0x3c6d, 0x3c6c, 0x3c6f, 0x3c6e, 0x3c69, 0x3c68, 0x3c6a, 0x3c65,
  0x3c64, 0x3c67, 0x3c66, 0x3c61, 0x3c60, 0x3c63, 0x3c62, 0x3c7d,
  0x3c7c, 0x3c7f, 0x3c7e, 0x3c79, 0x3c78, 0x3c7b, 0x3c7a, 0x3c75,
  0x3c74, 0x3c77, 0x3c76, 0x3c71, 0x3c70, 0x3c73, 0x3d2c, 0x3d2f,
  0x3d2e, 0x3d29, 0x3d28, 0x3d2b, 0x3d2a, 0x3d25, 0x3d24, 0x3d27,
  0x3d26, 0x3d21, 0x3d20, 0x3d23, 0x3d22, 0x3d3d, 0x3d3c, 0x3d3f,
  0x3d3e, 0x3d39, 0x3d38, 0x3d3b, 0x3d3a, 0x3d35, 0x3d34, 0x3d37,
  0x3d36, 0x3d31, 0x3d30, 0x3d33, 0x3d32, 0x3d4d, 0x3d4c, 0x3d4f,
  0x3d4e, 0x3d49, 0x3d48, 0x3d4b, 0x3d4a, 0x3d45, 0x3d44, 0x3d47,
  0x3d46, 0x3d41, 0x3d40, 0x3d43, 0x3d42, 0x3d5d, 0x3d5c, 0x3d5f,
  0x3d5e, 0x3d59, 0x3d58, 0x3d5b, 0x3d5a, 0x3d55, 0x3d54, 0x3d57,
  0x3d56, 0x3d51, 0x3d50, 0x3d53, 0x3d52, 0x3d6d, 0x3d6c, 0x3d6f,
  0x3d6e, 0x3d69, 0x3d68, 0x3d6b, 0x3d6a, 0x3d65, 0x3d64, 0x3d67,
  0x3d66, 0x3d61, 0x3d60, 0x3d63, 0x3d62, 0x3d7d, 0x3d7c, 0x3d7f,
  0x3d7e, 0x3d79, 0x3d78, 0x3d7b, 0x3d7a, 0x3d75, 0x3d74, 0x3d77,
  0x3d76, 0x3d71, 0x3d70, 0x3d73, 0x3e2c, 0x3e2f, 0x3e2e, 0x3e29,
  0x3e28, 0x3e2b, 0x3e2a, 0x3e25, 0x3e24, 0x3e27, 0x3e26, 0x3e21,
  0x3e20, 0x3e23, 0x3e22, 0x3e3d, 0x3e3c, 0x3e3e, 0x3e39, 0x3e38,
  0x3e3b, 0x3e3a, 0x3e35, 0x3e3f, 0x3e34, 0x3e37, 0x3e36, 0x3e31,
  0x3e30, 0x3e33, 0x3e32, 0x3e4d, 0x3e4c, 0x3e4f, 0x3e4e, 0x3e49,
  0x3e48, 0x3e4b, 0x3e4a, 0x3e45, 0x3e44, 0x3e47, 0x3e46, 0x3e41,
  0x3e40, 0x3e43, 0x3e42, 0x3e5d, 0x3e5c, 0x3e5f, 0x3e5e, 0x3e59,
  0x3e58, 0x3e5b, 0x3e5a, 0x3e55, 0x3e54, 0x3e57, 0x3e56, 0x3e51,
  0x3e50, 0x3e53, 0x3e52, 0x3e6d, 0x3e6c, 0x3e6f, 0x3e6e, 0x3e69,
  0x3e68, 0x3e6b, 0x3e6a, 0x3e65, 0x3e64, 0x3e67, 0x3e66, 0x3e61,
  0x3e60, 0x3e63, 0x3e62, 0x3e7d, 0x3e7c, 0x3e7f, 0x3e7e, 0x3e79,
  0x3e78, 0x3e7b, 0x3e7a, 0x3e75, 0x3e74, 0x3e77, 0x3e76, 0x3e71,
  0x3e70, 0x3e73, 0x3f2c, 0x3f2f, 0x3f2e, 0x3f29, 0x3f28, 0x3f2b,
  0x3f2a, 0x3f25, 0x3f24, 0x3f27, 0x3f26, 0x3f21, 0x3f20, 0x3f23,
  0x3f22, 0x3f3d, 0x3f3c, 0x3f3f, 0x3f3e, 0x3f39, 0x3f38, 0x3f3b,
  0x3f3a, 0x3f35, 0x3f34, 0x3f37, 0x3f36, 0x3f30, 0x3f31, 0x3f33,
  0x3f32, 0x3f4d, 0x3f4c, 0x3f4f, 0x3f4e, 0x3f49, 0x3f48, 0x3f4a,
  0x3f45, 0x3f44, 0x3f47, 0x3f4b, 0x3f46, 0x3f41, 0x3f40, 0x3f43,
  0x3f42, 0x3f5d, 0x3f5c, 0x3f5f, 0x3f5e, 0x3f5a, 0x3f58, 0x3f59,
  0x3f5b, 0x3f55, 0x3f54, 0x3f57, 0x3f56, 0x3f51, 0x3f50, 0x3f53,
  0x3f52, 0x3f6d, 0x3f6c, 0x3f6f, 0x3f6e, 0x3f69, 0x3f68, 0x3f6b,
  0x3f6a, 0x3f65, 0x3f64, 0x3f67, 0x3f66, 0x3f61, 0x3f60, 0x3f63,
  0x3f62, 0x3f7d, 0x3f7c, 0x3f7f, 0x6279, 0x3f7e, 0x3f79, 0x3f78,
  0x3f7b, 0x3f7a, 0x3f75, 0x3f77, 0x3f74, 0x3f76, 0x3f71, 0x3f70,
  0x3f73, 0x382c, 0x382f, 0x382e, 0x3829, 0x3828, 0x382b, 0x382a,
  0x3825, 0x3824, 0x3827, 0x3826, 0x3821, 0x3823, 0x3820, 0x3822,
  0x383d, 0x383c, 0x3839, 0x383f, 0x383e, 0x3838, 0x383b, 0x383a,
  0x3835, 0x3834, 0x3837, 0x3836, 0x3831, 0x3830, 0x3833, 0x3832,
  0x384d, 0x384c, 0x384f, 0x384e, 0x3849, 0x3848, 0x384b, 0x384a,
  0x3845, 0x3844, 0x3847, 0x3846, 0x3841, 0x3840, 0x3843, 0x3842,
  0x385d, 0x385f, 0x385c, 0x385e, 0x3859, 0x3858, 0x385b, 0x385a,
  0x3855, 0x3854, 0x3857, 0x3856, 0x3851, 0x3850, 0x3853, 0x3852,
  0x386d, 0x386c, 0x386f, 0x386e, 0x3869, 0x3868, 0x386b, 0x386a,
  0x3865, 0x3864, 0x3867, 0x3866, 0x3861, 0x3860, 0x3863, 0x3862,
  0x387d, 0x387c, 0x387f, 0x387e, 0x3879, 0x3878, 0x387b, 0x387a,
  0x3875, 0x3874, 0x3877, 0x3876, 0x3871, 0x3870, 0x3873, 0x392c,
  0x392f, 0x392e, 0x3929, 0x3928, 0x392b, 0x392a, 0x3925, 0x3924,
  0x3927, 0x3926, 0x3921, 0x3920, 0x3923, 0x3922, 0x393f, 0x393d,
  0x393c, 0x393e, 0x3939, 0x3938, 0x393b, 0x393a, 0x3935, 0x3934,
  0x3937, 0x3936, 0x3931, 0x3930, 0x3933, 0x3932, 0x394d, 0x394c,
  0x394f, 0x394e, 0x3949, 0x3948, 0x394b, 0x394a, 0x3945, 0x3944,
  0x3947, 0x3946, 0x3941, 0x3940, 0x3943, 0x3942, 0x395d, 0x395c,
  0x395f, 0x395e, 0x3959, 0x3958, 0x395b, 0x395a, 0x3955, 0x3954,
  0x3957, 0x3956, 0x3951, 0x3950, 0x3953, 0x3952, 0x396d, 0x396c,
  0x396f, 0x396e, 0x3969, 0x3968, 0x396b, 0x396a, 0x3965, 0x3964,
  0x3967, 0x3966, 0x3961, 0x3960, 0x3963, 0x3962, 0x397d, 0x397c,
  0x397f, 0x397e, 0x3979, 0x3978, 0x397b, 0x397a, 0x3975, 0x3974,
  0x3977, 0x3976, 0x3971, 0x3970, 0x3973, 0x3a2c, 0x3a2f, 0x3a2e,
  0x3a29, 0x3a28, 0x3a2b, 0x3a2a, 0x3a25, 0x3a24, 0x3a27, 0x3a26,
  0x3a21, 0x3a20, 0x3a23, 0x3a22, 0x3a3d, 0x3a3c, 0x3a3f, 0x3a3e,
  0x3a39, 0x3a38, 0x3a3b, 0x3a3a, 0x3a35, 0x3a34, 0x3a37, 0x3a36,
  0x3a31, 0x3a30, 0x3a33, 0x3a32, 0x3a4d, 0x3a4c, 0x3a4f, 0x3a4e,
  0x3a49, 0x3a48, 0x3a4b, 0x3a4a, 0x3a45, 0x3a44, 0x3a47, 0x3a46,
  0x3a41, 0x3a40, 0x3a43, 0x3a42, 0x3a5d, 0x3a5c, 0x3a5f, 0x3a5e,
  0x3a59, 0x3a58, 0x3a5b, 0x3a5a, 0x3a55, 0x3a54, 0x3a57, 0x3a56,
  0x3a51, 0x3a50, 0x3a53, 0x3a52, 0x3a6d, 0x3a6c, 0x3a6f, 0x3a6e,
  0x3a69, 0x3a68, 0x3a6b, 0x3a6a, 0x3a65, 0x3a64, 0x3a67, 0x3a66,
  0x3a61, 0x3a60, 0x3a63, 0x3a62, 0x3a7d, 0x3a7c, 0x3a7f, 0x3a7e,
  0x3a79, 0x3a78, 0x3a7b, 0x3a7a, 0x3a75, 0x3a74, 0x3a77, 0x3a76,
  0x3a73, 0x3a71, 0x3a70, 0x3b2c, 0x3b2f, 0x3b2e, 0x3b29, 0x3b28,
  0x3b2b, 0x3b2a, 0x3b25, 0x3b24, 0x3b27, 0x3b26, 0x3b21, 0x3b20,
  0x3b23, 0x3b22, 0x3b3d, 0x3b3c, 0x3b3f, 0x3b3e, 0x3b39, 0x3b38,
  0x3b3b, 0x3b3a, 0x3b35, 0x3b34, 0x3b37, 0x3b36, 0x3b31, 0x3b30,
  0x3b33, 0x3b32, 0x3b4d, 0x3b4c, 0x3b4f, 0x3b4e, 0x3b49, 0x3b48,
  0x3b4b, 0x3b4a, 0x3b45, 0x3b44, 0x3b47, 0x3b46, 0x3b41, 0x3b40,
  0x3b43, 0x3b42, 0x3b5d, 0x3b5c, 0x3b5f, 0x3b5e, 0x3b59, 0x3b58,
  0x3b5b, 0x3b5a, 0x3b55, 0x3b54, 0x3b57, 0x3b56, 0x3b51, 0x3b50,
  0x3b53, 0x3b52, 0x3b6d, 0x3b6c, 0x3b6f, 0x3b6e, 0x3b69, 0x3b68,
  0x3b6b, 0x3b6a, 0x3b65, 0x3b64, 0x3b67, 0x3b66, 0x3b61, 0x3b60,
  0x3b63, 0x3b62, 0x3b7d, 0x3b7c, 0x3b7f, 0x3b7e, 0x3b79, 0x3b78,
  0x3b7b, 0x3b7a, 0x3b75, 0x3b74, 0x3b77, 0x3b76, 0x3b71, 0x3b70,
  0x3b73, 0x442c, 0x442f, 0x442e, 0x4429, 0x4428, 0x442b, 0x442a,
  0x4425, 0x4424, 0x4427, 0x4426, 0x4421, 0x4420, 0x4423, 0x4422,
  0x443d, 0x443c, 0x443f, 0x443e, 0x4439, 0x4438, 0x443b, 0x443a,
  0x4435, 0x4434, 0x4437, 0x4436, 0x4431, 0x4430, 0x4433, 0x4432,
  0x444d, 0x444c, 0x444f, 0x444e, 0x4449, 0x4448, 0x444b, 0x444a,
  0x4445, 0x4444, 0x4447, 0x4446, 0x4441, 0x4440, 0x4443, 0x4442,
  0x445d, 0x445c, 0x445f, 0x445e, 0x4459, 0x4458, 0x445b, 0x445a,
  0x4455, 0x4454, 0x4457, 0x4456, 0x4451, 0x4450, 0x4453, 0x4452,
  0x446d, 0x446c, 0x446f, 0x446e, 0x4469, 0x4468, 0x446b, 0x446a,
  0x4465, 0x4464, 0x4467, 0x4466, 0x4461, 0x4460, 0x4463, 0x4462,
  0x447d, 0x447c, 0x447f, 0x447e, 0x4479, 0x4478, 0x447b, 0x447a,
  0x4475, 0x4474, 0x4477, 0x4476, 0x4471, 0x4470, 0x4473, 0x452c,
  0x452f, 0x452e, 0x4529, 0x4528, 0x452b, 0x452a, 0x4525, 0x4524,
  0x4527, 0x4526, 0x4521, 0x4520, 0x4523, 0x4522, 0x453d, 0x453c,
  0x453f, 0x453e, 0x4539, 0x4538, 0x453b, 0x453a, 0x4535, 0x4534,
  0x4537, 0x4536, 0x4531, 0x4530, 0x4533, 0x4532, 0x454d, 0x454c,
  0x454f, 0x454e, 0x4549, 0x4548, 0x454b, 0x454a, 0x4545, 0x4544,
  0x4547, 0x4546, 0x4541, 0x4540, 0x4543, 0x4542, 0x455d, 0x455c,
  0x455f, 0x455e, 0x4559, 0x4558, 0x455b, 0x455a, 0x4555, 0x4554,
  0x4557, 0x4556, 0x4551, 0x4550, 0x4553, 0x4552, 0x456d, 0x456c,
  0x456f, 0x456e, 0x4569, 0x4568, 0x456b, 0x456a, 0x4565, 0x4564,
  0x4567, 0x4566, 0x4561, 0x4560, 0x4563, 0x4562, 0x457d, 0x457c,
  0x457f, 0x457e, 0x4579, 0x4578, 0x457b, 0x457a, 0x4575, 0x4574,
  0x4577, 0x4576, 0x4571, 0x4570, 0x4573, 0x462c, 0x462f, 0x462e,
  0x4629, 0x4628, 0x462b, 0x462a, 0x4625, 0x4624, 0x4627, 0x4626,
  0x4621, 0x4620, 0x4623, 0x463d, 0x4622, 0x463c, 0x463f, 0x463e,
  0x4639, 0x4638, 0x463a, 0x463b, 0x4635, 0x4634, 0x4637, 0x4636,
  0x4631, 0x4630, 0x4633, 0x464d, 0x464c, 0x464f, 0x4649, 0x4648,
  0x464a, 0x4645, 0x4644, 0x4647, 0x4641, 0x464e, 0x464b, 0x4646,
  0x4640, 0x4643, 0x4642, 0x465d, 0x465c, 0x465f, 0x465e, 0x4659,
  0x4658, 0x465b, 0x465a, 0x4655, 0x4654, 0x4657, 0x4656, 0x4651,
  0x4650, 0x4653, 0x4652, 0x466d, 0x466c, 0x466f, 0x466e, 0x4669,
  0x4668, 0x466b, 0x466a, 0x4665, 0x4664, 0x4667, 0x4666, 0x4661,
  0x4660, 0x4632, 0x4663, 0x4662, 0x467d, 0x467c, 0x467f, 0x467e,
  0x4679, 0x4678, 0x467b, 0x467a, 0x4675, 0x4674, 0x4677, 0x4676,
  0x4671, 0x4670, 0x4673, 0x472c, 0x472f, 0x472e, 0x4729, 0x4728,
  0x472b, 0x472a, 0x4725, 0x4724, 0x4727, 0x4726, 0x4721, 0x4720,
  0x4723, 0x4722, 0x473d, 0x473c, 0x473f, 0x473e, 0x4739, 0x4738,
  0x473b, 0x473a, 0x4734, 0x4737, 0x4736, 0x4731, 0x4730, 0x4733,
  0x4732, 0x474d, 0x474c, 0x474f, 0x474e, 0x4749, 0x4748, 0x474b,
  0x474a, 0x4745, 0x4735, 0x4747, 0x4746, 0x4741, 0x4740, 0x4742,
  0x4743, 0x475d, 0x475c, 0x475f, 0x475e, 0x4759, 0x4758, 0x475b,
  0x475a, 0x4755, 0x4754, 0x4757, 0x4756, 0x4744, 0x4751, 0x4750,
  0x4753, 0x4752, 0x476d, 0x476c, 0x476f, 0x476e, 0x4769, 0x4768,
  0x476b, 0x476a, 0x4765, 0x4764, 0x4767, 0x4766, 0x4761, 0x4760,
  0x4763, 0x4762, 0x477d, 0x477c, 0x477f, 0x477e, 0x4779, 0x4778,
  0x477b, 0x477a, 0x4775, 0x4774, 0x4777, 0x4776, 0x4771, 0x4770,
  0x4773, 0x402c, 0x402f, 0x402e, 0x4029, 0x4028, 0x402b, 0x402a,
  0x4025, 0x4024, 0x4027, 0x4026, 0x4021, 0x4020, 0x4023, 0x4022,
  0x403d, 0x403c, 0x403f, 0x403e, 0x4039, 0x4038, 0x403b, 0x403a,
  0x4035, 0x4034, 0x4037, 0x4036, 0x4031, 0x4030, 0x4033, 0x4032,
  0x404d, 0x404c, 0x404f, 0x404e, 0x4049, 0x4048, 0x404b, 0x404a,
  0x4045, 0x4044, 0x4047, 0x4046, 0x4041, 0x4040, 0x4043, 0x4042,
  0x405d, 0x405c, 0x405f, 0x405e, 0x4059, 0x4058, 0x405b, 0x405a,
  0x4055, 0x4054, 0x4057, 0x4056, 0x4051, 0x4050, 0x4053, 0x4052,
  0x406d, 0x406c, 0x406f, 0x406e, 0x4069, 0x4068, 0x406b, 0x406a,
  0x4065, 0x4064, 0x4067, 0x4066, 0x4061, 0x4060, 0x4063, 0x4062,
  0x407d, 0x407c, 0x407f, 0x407e, 0x4079, 0x4078, 0x407b, 0x407a,
  0x4075, 0x4074, 0x4077, 0x4076, 0x4071, 0x4070, 0x4073, 0x412c,
  0x412f, 0x412e, 0x4129, 0x4128, 0x412b, 0x412a, 0x4125, 0x4124,
  0x4127, 0x4126, 0x4121, 0x4120, 0x4123, 0x4122, 0x413d, 0x413c,
  0x413f, 0x413e, 0x4139, 0x4138, 0x413b, 0x413a, 0x4135, 0x4134,
  0x4137, 0x4136, 0x4131, 0x4130, 0x4133, 0x4132, 0x414d, 0x414c,
  0x414f, 0x414e, 0x4149, 0x4148, 0x414b, 0x414a, 0x4145, 0x4144,
  0x4147, 0x4146, 0x4140, 0x4141, 0x4143, 0x4142, 0x415d, 0x415c,
  0x415f, 0x415e, 0x4159, 0x4158, 0x415b, 0x415a, 0x4155, 0x4154,
  0x4157, 0x4156, 0x4151, 0x4150, 0x4153, 0x4152, 0x416d, 0x416c,
  0x416f, 0x416e, 0x4169, 0x4168, 0x416b, 0x416a, 0x4165, 0x4164,
  0x4167, 0x4166, 0x4161, 0x4160, 0x4163, 0x4162, 0x417d, 0x417c,
  0x417f, 0x417e, 0x4179, 0x4178, 0x417b, 0x417a, 0x4175, 0x4174,
  0x4177, 0x4176, 0x4171, 0x4170, 0x4173, 0x422c, 0x422f, 0x422e,
  0x4229, 0x4228, 0x422b, 0x422a, 0x4225, 0x4224, 0x4227, 0x4226,
  0x4221, 0x4220, 0x4223, 0x4222, 0x423d, 0x423c, 0x423f, 0x423e,
  0x4239, 0x4238, 0x423b, 0x423a, 0x4235, 0x4234, 0x4237, 0x4236,
  0x4231, 0x4230, 0x4233, 0x4232, 0x424d, 0x424c, 0x424f, 0x424e,
  0x4249, 0x4248, 0x424b, 0x424a, 0x4245, 0x4244, 0x4247, 0x4246,
  0x4241, 0x4240, 0x4243, 0x4242, 0x425d, 0x425c, 0x425f, 0x425e,
  0x4259, 0x4258, 0x425b, 0x425a, 0x4255, 0x4254, 0x4257, 0x4256,
  0x4251, 0x4250, 0x4253, 0x4252, 0x426d, 0x433b, 0x426c, 0x426f,
  0x426e, 0x4269, 0x4268, 0x426b, 0x426a, 0x4265, 0x4264, 0x4267,
  0x4266, 0x4261, 0x4260, 0x4263, 0x4262, 0x427d, 0x427c, 0x427f,
  0x427e, 0x4279, 0x4278, 0x427b, 0x427a, 0x4275, 0x4274, 0x4277,
  0x4276, 0x4271, 0x4270, 0x4273, 0x432c, 0x432f, 0x432e, 0x4329,
  0x4328, 0x432b, 0x432a, 0x4325, 0x4324, 0x4327, 0x4326, 0x4321,
  0x4320, 0x4323, 0x4322, 0x433d, 0x433c, 0x433f, 0x433e, 0x4339,
  0x4338, 0x433a, 0x4335, 0x4334, 0x4337, 0x4336, 0x4331, 0x4330,
  0x4333, 0x4332, 0x434d, 0x434c, 0x434f, 0x434e, 0x4349, 0x4348,
  0x434b, 0x434a, 0x4345, 0x4344, 0x4347, 0x4346, 0x4341, 0x4340,
  0x4343, 0x4342, 0x435d, 0x435c, 0x435f, 0x435e, 0x4359, 0x4358,
  0x435b, 0x435a, 0x4355, 0x4354, 0x4357, 0x4356, 0x4351, 0x4350,
  0x4353, 0x4352, 0x436d, 0x436c, 0x436f, 0x436e, 0x4369, 0x4368,
  0x436b, 0x436a, 0x4365, 0x4364, 0x4367, 0x4366, 0x4361, 0x4360,
  0x4363, 0x4362, 0x437d, 0x437c, 0x437f, 0x437e, 0x4379, 0x4378,
  0x437b, 0x437a, 0x4375, 0x4374, 0x4377, 0x4376, 0x4371, 0x4370,
  0x4373, 0x4c2c, 0x4c2f, 0x4c2e, 0x4c29, 0x4c28, 0x4c2b, 0x4c2a,
  0x4c25, 0x4c24, 0x4c27, 0x4c26, 0x4c21, 0x4c20, 0x4c23, 0x4c22,
  0x4c3d, 0x4c3c, 0x4c3f, 0x4c3e, 0x4c39, 0x4c38, 0x4c3b, 0x4c3a,
  0x4c35, 0x4c34, 0x4c37, 0x4c36, 0x4c31, 0x4c30, 0x4c33, 0x4c32,
  0x4c4d, 0x4c4c, 0x4c4f, 0x4c4e, 0x4c49, 0x4c48, 0x4c4b, 0x4c4a,
  0x4c45, 0x4c44, 0x4c47, 0x4c46, 0x4c41, 0x4c5e, 0x4c40, 0x4c43,
  0x4c42, 0x4c5d, 0x4c5c, 0x4c5f, 0x4c59, 0x4c58, 0x4c5b, 0x4c5a,
  0x4c55, 0x4c54, 0x4c57, 0x4c56, 0x4c51, 0x4c50, 0x4c53, 0x4c52,
  0x4c6d, 0x4c6c, 0x4c6f, 0x4c6e, 0x4c69, 0x4c68, 0x4c6b, 0x4c6a,
  0x4c65, 0x4c64, 0x4c67, 0x4c66, 0x4c61, 0x4c60, 0x4c63, 0x4c62,
  0x4c7d, 0x4c7c, 0x4c7f, 0x4c7e, 0x4c79, 0x4c78, 0x4c7b, 0x4c7a,
  0x4c75, 0x4c74, 0x4c77, 0x4c76, 0x4c71, 0x4c70, 0x4c73, 0x4d2c,
  0x4d2f, 0x4d2e, 0x4d29, 0x4d28, 0x4d2b, 0x4d2a, 0x4d25, 0x4d24,
  0x4d27, 0x4d26, 0x4d21, 0x4d20, 0x4d23, 0x4d22, 0x4d3d, 0x4d3c,
  0x4d3f, 0x4d3e, 0x4d39, 0x4d38, 0x4d3b, 0x4d3a, 0x4d35, 0x4d34,
  0x4d37, 0x4d36, 0x4d31, 0x4d4c, 0x4d30, 0x4d33, 0x4d32, 0x4d4d,
  0x4d4f, 0x4d4e, 0x4d49, 0x4d48, 0x4d4b, 0x4d4a, 0x4d45, 0x4d44,
  0x4d47, 0x4d46, 0x4d41, 0x4d40, 0x4d43, 0x4d42, 0x4d5d, 0x4d5c,
  0x4d5f, 0x4d5e, 0x4d59, 0x4d58, 0x4d5b, 0x4d5a, 0x4d55, 0x4d54,
  0x4d57, 0x4d56, 0x4d51, 0x4d50, 0x4d53, 0x4d52, 0x4d6d, 0x4d6c,
  0x4d6f, 0x4d6e, 0x4d69, 0x4d68, 0x4d6b, 0x4d6a, 0x4d65, 0x4d64,
  0x4d67, 0x4d66, 0x4d61, 0x4d60, 0x4d63, 0x4d62, 0x4d7d, 0x4d7c,
  0x4d7f, 0x4d7e, 0x4d79, 0x4d78, 0x4d7b, 0x4d7a, 0x4d75, 0x4d74,
  0x4d77, 0x4d76, 0x4d71, 0x4d70, 0x4d73, 0x4e2c, 0x4e2f, 0x4e2e,
  0x4e29, 0x4e28, 0x4e2b, 0x4e2a, 0x4e25, 0x4e24, 0x4e27, 0x4e26,
  0x4e21, 0x4e20, 0x4e23, 0x4e22, 0x4e3d, 0x4e3c, 0x4e3f, 0x4e3e,
  0x4e39, 0x4e38, 0x4e3b, 0x4e3a, 0x4e35, 0x4e34, 0x4e37, 0x4e36,
  0x4e31, 0x4e30, 0x4e33, 0x4e32, 0x4e4d, 0x4e4c, 0x4e4f, 0x4e4e,
  0x4e49, 0x4e48, 0x4e4b, 0x4e4a, 0x4e45, 0x4e44, 0x4e47, 0x4e46,
  0x4e41, 0x4e40, 0x4e43, 0x4e42, 0x4e5d, 0x4e5c, 0x4e5f, 0x4e5e,
  0x4e59, 0x4e58, 0x4e5b, 0x4e5a, 0x4e55, 0x4e54, 0x4e57, 0x4e56,
  0x4e51, 0x4e50, 0x4e53, 0x4e52, 0x4e6d, 0x4e6c, 0x4e6f, 0x4e6e,
  0x4e69, 0x4e68, 0x4e6b, 0x4e6a, 0x4e65, 0x4e64, 0x4e67, 0x4e66,
  0x4e61, 0x4e60, 0x4e63, 0x4e62, 0x4e7d, 0x4e7c, 0x4e7f, 0x4e7e,
  0x4e79, 0x4e78, 0x4e7b, 0x4e7a, 0x4e75, 0x4e74, 0x4e77, 0x4e76,
  0x4e71, 0x4e70, 0x4e73, 0x4f2c, 0x4f2f, 0x4f2e, 0x4f29, 0x4f28,
  0x4f2b, 0x4f2a, 0x4f25, 0x4f24, 0x4f27, 0x4f26, 0x4f21, 0x4f20,
  0x4f23, 0x4f22, 0x4f3d, 0x4f3c, 0x4f3f, 0x4f3e, 0x4f39, 0x4f38,
  0x4f3b, 0x4f3a, 0x4f35, 0x4f34, 0x4f37, 0x4f36, 0x4f31, 0x4f30,
  0x4f33, 0x4f32, 0x4f4d, 0x4f4c, 0x4f4f, 0x4f4e, 0x4f49, 0x4f48,
  0x4f4b, 0x4f4a, 0x4f45, 0x4f44, 0x4f47, 0x4f46, 0x4f41, 0x4f40,
  0x4f43, 0x4f42, 0x4f5d, 0x4f5c, 0x4f5f, 0x4f5e, 0x4f59, 0x4f58,
  0x4f5b, 0x4f5a, 0x4f55, 0x4f54, 0x4f57, 0x4f56, 0x4f51, 0x4f50,
  0x4f53, 0x4f52, 0x4f6d, 0x4f6c, 0x4f6f, 0x4f6e, 0x4f69, 0x4f68,
  0x4f6b, 0x4f6a, 0x4f65, 0x4f64, 0x4f67, 0x4f66, 0x4f61, 0x4f60,
  0x4f63, 0x4f62, 0x4f7d, 0x4f7c, 0x4f7f, 0x4f7e, 0x4f79, 0x4f78,
  0x4f7b, 0x4f7a, 0x4f75, 0x4f74, 0x4f77, 0x4f76, 0x4f71, 0x4f70,
  0x4f73, 0x482c, 0x482f, 0x482e, 0x4829, 0x4828, 0x482b, 0x482a,
  0x4825, 0x4824, 0x4827, 0x4826, 0x4821, 0x4820, 0x4823, 0x4822,
  0x483d, 0x483c, 0x483f, 0x483e, 0x4839, 0x4838, 0x483b, 0x483a,
  0x4835, 0x4834, 0x4837, 0x4836, 0x4831, 0x4830, 0x4833, 0x4832,
  0x484d, 0x484c, 0x484f, 0x484e, 0x4849, 0x4848, 0x484b, 0x484a,
  0x4845, 0x4844, 0x4847, 0x4846, 0x4841, 0x4840, 0x4843, 0x4842,
  0x485d, 0x485c, 0x485f, 0x485e, 0x4859, 0x4858, 0x485b, 0x485a,
  0x4855, 0x4854, 0x4857, 0x4856, 0x4851, 0x4850, 0x4853, 0x4852,
  0x486d, 0x486c, 0x486f, 0x486e, 0x4869, 0x4868, 0x486b, 0x486a,
  0x4865, 0x4864, 0x4867, 0x4866, 0x4861, 0x4860, 0x4863, 0x4862,
  0x487d, 0x487c, 0x487f, 0x487e, 0x4879, 0x4878, 0x487b, 0x487a,
  0x4875, 0x4874, 0x4877, 0x4876, 0x4871, 0x4870, 0x4873, 0x492c,
  0x492f, 0x492e, 0x4929, 0x4928, 0x492b, 0x492a, 0x4925, 0x4924,
  0x4927, 0x4926, 0x4921, 0x4920, 0x4923, 0x4922, 0x493d, 0x493c,
  0x493f, 0x493e, 0x4939, 0x4938, 0x493b, 0x493a, 0x4935, 0x4934,
  0x4937, 0x4936, 0x4931, 0x4930, 0x4933, 0x4932, 0x494d, 0x494c,
  0x494f, 0x494e, 0x4949, 0x4948, 0x494b, 0x494a, 0x4945, 0x4944,
  0x4947, 0x4946, 0x4941, 0x4940, 0x4943, 0x4942, 0x495d, 0x495c,
  0x495f, 0x495e, 0x4959, 0x4958, 0x495b, 0x495a, 0x4955, 0x4954,
  0x4957, 0x4956, 0x4951, 0x4950, 0x4953, 0x4952, 0x496d, 0x496c,
  0x496f, 0x496e, 0x4969, 0x4968, 0x496b, 0x496a, 0x4965, 0x4964,
  0x4967, 0x4966, 0x4961, 0x4960, 0x4963, 0x4962, 0x497d, 0x497c,
  0x497f, 0x497e, 0x4979, 0x4978, 0x497b, 0x497a, 0x4975, 0x4974,
  0x4977, 0x4976, 0x4971, 0x4970, 0x4973, 0x4a2c, 0x4a2f, 0x4a29,
  0x4a28, 0x4a2b, 0x4a2a, 0x4a25, 0x4a24, 0x4a2e, 0x4a27, 0x4a26,
  0x4a21, 0x4a20, 0x4a23, 0x4a22, 0x4a3d, 0x4a3c, 0x4a3f, 0x4a3e,
  0x4a39, 0x4a38, 0x4a3b, 0x4a3a, 0x4a35, 0x4a34, 0x4a37, 0x4a36,
  0x4a31, 0x4a30, 0x4a33, 0x4a32, 0x4a4d, 0x4a4c, 0x4a4f, 0x4a4e,
  0x4a49, 0x4a48, 0x4a4b, 0x4a4a, 0x4a45, 0x4a44, 0x4a47, 0x4a46,
  0x4a41, 0x4a40, 0x4a43, 0x4a42, 0x4a5d, 0x4a5c, 0x4a5f, 0x4a5e,
  0x4a59, 0x4a58, 0x4a5b, 0x4a5a, 0x4a55, 0x4a54, 0x4a57, 0x4a56,
  0x4a51, 0x4a50, 0x4a53, 0x4a52, 0x4a6d, 0x4a6c, 0x4a6f, 0x4a6e,
  0x4a69, 0x4a68, 0x4a6b, 0x4a6a, 0x4a65, 0x4a64, 0x4a67, 0x4a66,
  0x4a61, 0x4a60, 0x4a63, 0x4a62, 0x4a7d, 0x4a7c, 0x4a7f, 0x4a7e,
  0x4a79, 0x4a78, 0x4a7b, 0x4a7a, 0x4a75, 0x4a74, 0x4a77, 0x4a76,
  0x4a71, 0x4a70, 0x4a73, 0x4b2c, 0x4b2f, 0x4b2e, 0x4b29, 0x4b28,
  0x4b2b, 0x4b2a, 0x4b25, 0x4b24, 0x4b27, 0x4b26, 0x4b21, 0x4b20,
  0x4b23, 0x4b22, 0x4b3d, 0x4b3c, 0x4b3f, 0x4b3e, 0x4b39, 0x4b38,
  0x4b3b, 0x4b3a, 0x4b35, 0x4b34, 0x4b37, 0x4b36, 0x4b31, 0x4b30,
  0x4b33, 0x4b32, 0x4b4d, 0x4b4c, 0x4b4f, 0x4b4e, 0x4b49, 0x4b48,
  0x4b4b, 0x4b4a, 0x4b45, 0x4b44, 0x4b47, 0x4b46, 0x4b41, 0x4b40,
  0x4b43, 0x4b42, 0x4b5d, 0x4b5c, 0x4b5f, 0x4b5e, 0x4b59, 0x4b58,
  0x4b5b, 0x4b5a, 0x4b55, 0x4b54, 0x4b57, 0x4b56, 0x4b51, 0x4b50,
  0x4b53, 0x4b52, 0x4b6d, 0x4b6c, 0x4b6f, 0x4b6e, 0x4b69, 0x4b68,
  0x4b6b, 0x4b6a, 0x4b65, 0x4b64, 0x4b67, 0x4b66, 0x4b61, 0x4b60,
  0x4b63, 0x4b62, 0x4b7d, 0x4b7c, 0x4b7f, 0x4b79, 0x4b78, 0x4b7b,
  0x4b7e, 0x4b7a, 0x4b75, 0x4b74, 0x4b77, 0x4b76, 0x4b71, 0x4b70,
  0x4b73, 0x542c, 0x542f, 0x542e, 0x5429, 0x5428, 0x542b, 0x542a,
  0x5425, 0x5424, 0x5427, 0x5426, 0x5421, 0x5423, 0x5422, 0x543d,
  0x543c, 0x5420, 0x543f, 0x543e, 0x5439, 0x5438, 0x543a, 0x5435,
  0x5434, 0x5437, 0x5436, 0x543b, 0x5431, 0x5430, 0x5433, 0x5432,
  0x544d, 0x544c, 0x544f, 0x544e, 0x5449, 0x5448, 0x544b, 0x544a,
  0x5445, 0x5444, 0x5447, 0x5446, 0x5441, 0x5440, 0x5443, 0x5442,
  0x545d, 0x545c, 0x545f, 0x545e, 0x5459, 0x5458, 0x545b, 0x545a,
  0x5455, 0x5454, 0x5457, 0x5456, 0x5451, 0x5450, 0x5453, 0x5452,
  0x546d, 0x546c, 0x546f, 0x546e, 0x5469, 0x5468, 0x546b, 0x546a,
  0x5465, 0x5464, 0x5467, 0x5466, 0x5461, 0x5460, 0x5463, 0x5462,
  0x547d, 0x547c, 0x547f, 0x547e, 0x5479, 0x5478, 0x547b, 0x547a,
  0x5475, 0x5474, 0x5477, 0x5476, 0x5471, 0x5470, 0x5473, 0x552c,
  0x552f, 0x552e, 0x5529, 0x5528, 0x552b, 0x552a, 0x5525, 0x5524,
  0x5527, 0x5526, 0x5521, 0x5520, 0x5523, 0x5522, 0x553d, 0x553c,
  0x553f, 0x553e, 0x5539, 0x5538, 0x553b, 0x553a, 0x5535, 0x5534,
  0x5537, 0x5536, 0x5531, 0x5530, 0x5533, 0x5532, 0x554d, 0x554c,
  0x554f, 0x554e, 0x5549, 0x5548, 0x554b, 0x554a, 0x5545, 0x5544,
  0x5547, 0x5546, 0x5541, 0x5540, 0x5543, 0x5542, 0x555d, 0x555c,
  0x555f, 0x555e, 0x5559, 0x5558, 0x555b, 0x555a, 0x5555, 0x5554,
  0x5557, 0x5556, 0x5551, 0x5550, 0x5553, 0x5552, 0x556d, 0x556c,
  0x556f, 0x556e, 0x5569, 0x5568, 0x556b, 0x556a, 0x5565, 0x5564,
  0x5567, 0x5566, 0x5561, 0x5560, 0x5563, 0x5562, 0x557d, 0x557c,
  0x557f, 0x557e, 0x5579, 0x5578, 0x557b, 0x557a, 0x5575, 0x5574,
  0x5577, 0x5576, 0x5571, 0x5570, 0x5573, 0x562c, 0x562f, 0x562e,
  0x5629, 0x5628, 0x562b, 0x562a, 0x5625, 0x5624, 0x5627, 0x5626,
  0x5621, 0x5620, 0x5623, 0x5622, 0x563d, 0x563c, 0x563f, 0x563e,
  0x5639, 0x5638, 0x563b, 0x563a, 0x5635, 0x5634, 0x5637, 0x5636,
  0x5631, 0x5630, 0x5633, 0x5632, 0x564d, 0x564c, 0x564f, 0x564e,
  0x5649, 0x5648, 0x564b, 0x564a, 0x5645, 0x5644, 0x5647, 0x5646,
  0x5641, 0x5640, 0x5643, 0x5642, 0x565d, 0x565c, 0x565f, 0x565e,
  0x5659, 0x5658, 0x565b, 0x565a, 0x5655, 0x5654, 0x5657, 0x5656,
  0x5651, 0x5650, 0x5653, 0x5652, 0x566d, 0x566c, 0x566f, 0x566e,
  0x5669, 0x5668, 0x566b, 0x566a, 0x5665, 0x5664, 0x5667, 0x5666,
  0x5661, 0x5660, 0x5663, 0x5662, 0x567d, 0x567c, 0x567f, 0x567e,
  0x5679, 0x567b, 0x567a, 0x5675, 0x5678, 0x5674, 0x5677, 0x5676,
  0x5671, 0x5670, 0x5673, 0x572c, 0x572f, 0x572e, 0x5729, 0x5728,
  0x572b, 0x572a, 0x5725, 0x5724, 0x5727, 0x5726, 0x5721, 0x5720,
  0x5723, 0x5722, 0x573d, 0x573c, 0x573f, 0x573e, 0x5739, 0x5738,
  0x573b, 0x573a, 0x5735, 0x5734, 0x5737, 0x5736, 0x5731, 0x5730,
  0x5733, 0x5732, 0x574d, 0x574c, 0x574f, 0x574e, 0x5749, 0x5748,
  0x574b, 0x574a, 0x5745, 0x5744, 0x5747, 0x5746, 0x5741, 0x5740,
  0x5743, 0x5742, 0x575d, 0x575c, 0x575f, 0x575e, 0x5759, 0x5758,
  0x575b, 0x575a, 0x5755, 0x5754, 0x5757, 0x5756, 0x5751, 0x5750,
  0x5753, 0x5752, 0x576d, 0x576c, 0x576f, 0x576e, 0x5769, 0x5768,
  0x576b, 0x576a, 0x5765, 0x5764, 0x5767, 0x5766, 0x5761, 0x5760,
  0x5763, 0x5762, 0x577d, 0x577c, 0x577f, 0x577e, 0x5779, 0x5778,
  0x577b, 0x577a, 0x5775, 0x5774, 0x5777, 0x5776, 0x5771, 0x5770,
  0x5773, 0x502c, 0x502f, 0x502e, 0x5029, 0x5028, 0x502b, 0x502a,
  0x5025, 0x5024, 0x5027, 0x5026, 0x5021, 0x5020, 0x5023, 0x5022,
  0x503d, 0x503c, 0x503f, 0x5039, 0x5038, 0x503b, 0x503a, 0x5035,
  0x5034, 0x5037, 0x5036, 0x5031, 0x5030, 0x5033, 0x503e, 0x5032,
  0x504d, 0x504c, 0x504f, 0x504e, 0x5049, 0x5048, 0x504b, 0x504a,
  0x5045, 0x5044, 0x5047, 0x5046, 0x5041, 0x5040, 0x5043, 0x5042,
  0x505d, 0x505c, 0x505f, 0x505e, 0x5059, 0x5058, 0x505b, 0x505a,
  0x5055, 0x5054, 0x5057, 0x5056, 0x5051, 0x5050, 0x5053, 0x5052,
  0x506d, 0x506c, 0x506f, 0x506e, 0x5069, 0x5068, 0x506b, 0x506a,
  0x5065, 0x5064, 0x5067, 0x5061, 0x5066, 0x5060, 0x5063, 0x5062,
  0x507d, 0x507c, 0x507f, 0x507e, 0x5079, 0x5078, 0x507b, 0x507a,
  0x5075, 0x5074, 0x5077, 0x5076, 0x5071, 0x5070, 0x5073, 0x512c,
  0x512f, 0x512e, 0x5129, 0x5128, 0x512b, 0x512a, 0x5125, 0x5124,
  0x5127, 0x5126, 0x5121, 0x5120, 0x5123, 0x5122, 0x513d, 0x513c,
  0x513f, 0x513e, 0x5139, 0x5138, 0x513b, 0x513a, 0x5135, 0x5134,
  0x5137, 0x5136, 0x5131, 0x5130, 0x5133, 0x5132, 0x514d, 0x514c,
  0x514f, 0x514e, 0x5149, 0x5148, 0x514b, 0x514a, 0x5145, 0x5144,
  0x5147, 0x5146, 0x5141, 0x5140, 0x5143, 0x5142, 0x515d, 0x515c,
  0x515f, 0x515e, 0x5159, 0x5158, 0x515b, 0x515a, 0x5155, 0x5154,
  0x5157, 0x5156, 0x5151, 0x5150, 0x5153, 0x5152, 0x516d, 0x516c,
  0x516f, 0x516e, 0x5169, 0x5168, 0x516b, 0x516a, 0x5165, 0x5164,
  0x5167, 0x5166, 0x5161, 0x5160, 0x5163, 0x5162, 0x517d, 0x517c,
  0x517f, 0x517e, 0x5179, 0x5178, 0x517b, 0x517a, 0x5175, 0x5174,
  0x5177, 0x5176, 0x5171, 0x5170, 0x5173, 0x522c, 0x522f, 0x522e,
  0x5229, 0x5228, 0x522b, 0x522a, 0x5225, 0x5224, 0x5227, 0x5226,
  0x5221, 0x5220, 0x5223, 0x5222, 0x523d, 0x523c, 0x523f, 0x523e,
  0x5239, 0x5238, 0x523b, 0x523a, 0x5235, 0x5234, 0x5237, 0x5236,
  0x5231, 0x5230, 0x5233, 0x5232, 0x524d, 0x524c, 0x524f, 0x524e,
  0x5249, 0x5248, 0x524a, 0x5245, 0x5244, 0x5247, 0x5246, 0x524b,
  0x5241, 0x5240, 0x5243, 0x5242, 0x525d, 0x525c, 0x525f, 0x525e,
  0x5259, 0x525b, 0x525a, 0x5255, 0x5258, 0x5254, 0x5257, 0x5256,
  0x5251, 0x5250, 0x5253, 0x5252, 0x526d, 0x526c, 0x526f, 0x526e,
  0x5269, 0x5268, 0x526b, 0x526a, 0x5265, 0x5264, 0x5267, 0x5266,
  0x5261, 0x5260, 0x5263, 0x5262, 0x527d, 0x527c, 0x527f, 0x527e,
  0x5279, 0x5278, 0x527b, 0x527a, 0x5275, 0x5274, 0x5277, 0x5276,
  0x5271, 0x5270, 0x5273, 0x532c, 0x532f, 0x532e, 0x5329, 0x5328,
  0x532b, 0x532a, 0x5325, 0x5324, 0x5327, 0x5326, 0x5321, 0x5320,
  0x5323, 0x5322, 0x533d, 0x533c, 0x533f, 0x533e, 0x5339, 0x5338,
  0x533b, 0x533a, 0x5335, 0x5334, 0x5337, 0x5336, 0x5331, 0x5330,
  0x5333, 0x5332, 0x534d, 0x534c, 0x534f, 0x534e, 0x5349, 0x5348,
  0x534b, 0x534a, 0x5345, 0x5344, 0x5347, 0x5346, 0x5341, 0x5340,
  0x5343, 0x5342, 0x535d, 0x535c, 0x535f, 0x535e, 0x5359, 0x5358,
  0x535b, 0x535a, 0x5355, 0x5354, 0x5357, 0x5356, 0x5351, 0x5350,
  0x5353, 0x5352, 0x536d, 0x536c, 0x536f, 0x5369, 0x5368, 0x536b,
  0x536a, 0x5365, 0x5364, 0x5367, 0x5366, 0x5361, 0x5360, 0x5363,
  0x5362, 0x537d, 0x537c, 0x537f, 0x537e, 0x5379, 0x5378, 0x537b,
  0x537a, 0x5375, 0x5374, 0x5c33, 0x536e, 0x5377, 0x5376, 0x5371,
  0x5370, 0x5373, 0x5c2c, 0x5c2f, 0x5c2e, 0x5c29, 0x5c28, 0x5c2b,
  0x5c2a, 0x5c25, 0x5c24, 0x5c27, 0x5c26, 0x5c21, 0x5c20, 0x5c23,
  0x5c22, 0x5c3d, 0x5c3c, 0x5c3f, 0x5c3e, 0x5c41, 0x5c39, 0x5c38,
  0x5c3b, 0x5c3a, 0x5c35, 0x5c34, 0x5c37, 0x5c36, 0x5c31, 0x5c30,
  0x5c32, 0x5c4d, 0x5c4c, 0x5c4f, 0x5c4e, 0x5c49, 0x5c48, 0x5c4b,
  0x5c4a, 0x5c45, 0x5c44, 0x5c47, 0x5c46, 0x5c40, 0x5c43, 0x5c42,
  0x5c5d, 0x5c5c, 0x5c5f, 0x5c5e, 0x5c59, 0x5c58, 0x5c5b, 0x5c5a,
  0x5c55, 0x5c54, 0x5c57, 0x5c56, 0x5c51, 0x5c50, 0x5c53, 0x5c52,
  0x5c6d, 0x5c6c, 0x5c6f, 0x5c6e, 0x5c69, 0x5c68, 0x5c6b, 0x5c6a,
  0x5c65, 0x5c64, 0x5c67, 0x5c66, 0x5c61, 0x5c60, 0x5c63, 0x5c62,
  0x5c7d, 0x5c7c, 0x5c7f, 0x5c7e, 0x5c79, 0x5c78, 0x5c7b, 0x5c7a,
  0x5c75, 0x5c74, 0x5c77, 0x5c76, 0x5c71, 0x5c70, 0x5c73, 0x5d2c,
  0x5d2f, 0x5d2e, 0x5d29, 0x5d28, 0x5d2b, 0x5d2a, 0x5d25, 0x5d27,
  0x5d26, 0x5d21, 0x5d20, 0x5d23, 0x5d22, 0x5d3d, 0x5d3c, 0x5d3f,
  0x5d3e, 0x5d39, 0x5d38, 0x5d3b, 0x5d3a, 0x5d35, 0x5d34, 0x5d37,
  0x5d36, 0x5d31, 0x5d24, 0x5d30, 0x5d33, 0x5d32, 0x5d4d, 0x5d4c,
  0x5d4f, 0x5d4e, 0x5d49, 0x5d48, 0x5d4b, 0x5d4a, 0x5d45, 0x5d44,
  0x5d47, 0x5d46, 0x5d41, 0x5d40, 0x5d43, 0x5d42, 0x5d5d, 0x5d5c,
  0x5d5f, 0x5d5e, 0x5d59, 0x5d58, 0x5d5b, 0x5d5a, 0x5d55, 0x5d54,
  0x5d57, 0x5d56, 0x5d51, 0x5d50, 0x5d53, 0x5d52, 0x5d6d, 0x5d6c,
  0x5d6f, 0x5d6e, 0x5d69, 0x5d68, 0x5d6b, 0x5d79, 0x5d6a, 0x5d65,
  0x5d64, 0x5d67, 0x5d66, 0x5d61, 0x5d60, 0x5d63, 0x5d62, 0x5d7d,
  0x5d7c, 0x5d7f, 0x5d7e, 0x5d78, 0x5d7b, 0x5d7a, 0x5d75, 0x5d74,
  0x5d77, 0x5d76, 0x5d71, 0x5d70, 0x5d73, 0x5e2c, 0x5e2f, 0x5e2e,
  0x5e29, 0x5e28, 0x5e2b, 0x5e2a, 0x5e25, 0x5e24, 0x5e27, 0x5e26,
  0x5e21, 0x5e20, 0x5e23, 0x5e22, 0x5e3d, 0x5e3c, 0x5e3f, 0x5e3e,
  0x5e39, 0x5e38, 0x5e3b, 0x3c6b, 0x5e3a, 0x5e35, 0x5e34, 0x5e37,
  0x5e36, 0x5e31, 0x5e30, 0x5e33, 0x5e32, 0x5e4d, 0x5e4c, 0x5e4f,
  0x5e4e, 0x5e49, 0x5e48, 0x5e4b, 0x5e4a, 0x5e45, 0x5e44, 0x5e47,
  0x5e46, 0x5e60, 0x5e41, 0x5e40, 0x5e43, 0x5e42, 0x5e5d, 0x5e5c,
  0x5e5f, 0x5e5e, 0x5e59, 0x5e58, 0x5e5b, 0x5e5a, 0x5e55, 0x5e54,
  0x5e57, 0x5e56, 0x5e51, 0x5e50, 0x5e53, 0x5e52, 0x5e6d, 0x5e6c,
  0x5e6f, 0x5e6e, 0x5e69, 0x5e68, 0x5e6b, 0x5e6a, 0x5e65, 0x5e64,
  0x5e67, 0x5e66, 0x5e61, 0x5e63, 0x5e62, 0x5e7d, 0x5e7c, 0x5e7f,
  0x5e7e, 0x5e79, 0x5e78, 0x5e7b, 0x5e7a, 0x5e75, 0x5e74, 0x5e77,
  0x5e76, 0x5e71, 0x5e70, 0x5e73, 0x5f2c, 0x5f2f, 0x5f2e, 0x5f29,
  0x5f28, 0x5f2b, 0x5f2a, 0x5f25, 0x5f24, 0x5f27, 0x5f26, 0x5f21,
  0x5f20, 0x5f23, 0x5f22, 0x5f3d, 0x5f3c, 0x5f3f, 0x5f3e, 0x5f39,
  0x5f38, 0x5f3b, 0x5f3a, 0x5f35, 0x5f34, 0x5f37, 0x5f36, 0x5f31,
  0x5f30, 0x5f33, 0x5f32, 0x5f4d, 0x5f4c, 0x5f4f, 0x5f4e, 0x5f49,
  0x5f48, 0x5f4b, 0x5f4a, 0x5f45, 0x5f44, 0x5f47, 0x5f46, 0x5f41,
  0x5f40, 0x5f43, 0x5f42, 0x5f5d, 0x5f5c, 0x5f5f, 0x5f5e, 0x5f59,
  0x5f58, 0x5f5b, 0x5f5a, 0x5f55, 0x5f54, 0x5f57, 0x5f56, 0x5f51,
  0x5f50, 0x5f53, 0x5f52, 0x5f6d, 0x5f6c, 0x5f6f, 0x5f6e, 0x5f69,
  0x5f68, 0x5f6b, 0x5f6a, 0x5f65, 0x5f64, 0x5f67, 0x5f66, 0x5f61,
  0x5f60, 0x5f63, 0x5f7d, 0x5f7c, 0x5f7f, 0x5f7e, 0x5f62, 0x5f79,
  0x5f78, 0x5f7b, 0x5f7a, 0x5f75, 0x5f74, 0x5f77, 0x5f76, 0x5f71,
  0x5f70, 0x5f73, 0x582c, 0x582f, 0x582e, 0x5829, 0x5828, 0x582b,
  0x582a, 0x5825, 0x5824, 0x5827, 0x5826, 0x5821, 0x5820, 0x5823,
  0x5822, 0x583d, 0x583c, 0x583f, 0x583e, 0x5839, 0x5838, 0x583b,
  0x583a, 0x5835, 0x5834, 0x5837, 0x5836, 0x5831, 0x5830, 0x5833,
  0x5832, 0x584d, 0x584c, 0x584f, 0x584e, 0x5849, 0x5848, 0x584b,
  0x584a, 0x5845, 0x5844, 0x5847, 0x5846, 0x5841, 0x5840, 0x5843,
  0x5842, 0x585d, 0x585c, 0x585f, 0x585e, 0x5859, 0x5858, 0x585b,
  0x585a, 0x5855, 0x5854, 0x5857, 0x5856, 0x5851, 0x5850, 0x5853,
  0x5852, 0x586d, 0x586c, 0x586f, 0x586e, 0x5869, 0x5868, 0x586b,
  0x586a, 0x5865, 0x5864, 0x5867, 0x5866, 0x5861, 0x5860, 0x5863,
  0x5862, 0x587d, 0x587c, 0x587f, 0x587e, 0x5879, 0x5878, 0x587b,
  0x587a, 0x5875, 0x5874, 0x5877, 0x5876, 0x5871, 0x5870, 0x5873,
  0x592c, 0x592f, 0x592e, 0x5929, 0x5928, 0x592b, 0x592a, 0x5925,
  0x5924, 0x5927, 0x5926, 0x5921, 0x5920, 0x5923, 0x5922, 0x593d,
  0x593c, 0x593f, 0x593e, 0x5939, 0x5938, 0x593b, 0x593a, 0x5935,
  0x5934, 0x5937, 0x5936, 0x5931, 0x5930, 0x5933, 0x5932, 0x594d,
  0x594c, 0x594f, 0x594e, 0x5949, 0x5948, 0x594b, 0x594a, 0x5945,
  0x5944, 0x5947, 0x5946, 0x5941, 0x5940, 0x5943, 0x5942, 0x595d,
  0x595c, 0x595f, 0x595e, 0x5959, 0x5958, 0x595b, 0x595a, 0x5955,
  0x5954, 0x5957, 0x5956, 0x5951, 0x5950, 0x5953, 0x5952, 0x596d,
  0x596c, 0x596f, 0x596e, 0x5969, 0x5968, 0x596b, 0x596a, 0x5965,
  0x5964, 0x5967, 0x5966, 0x5961, 0x5960, 0x5963, 0x5962, 0x597d,
  0x597c, 0x597f, 0x597e, 0x5979, 0x5978, 0x597b, 0x597a, 0x5975,
  0x5974, 0x5977, 0x5976, 0x5971, 0x5970, 0x5973, 0x5a2c, 0x5a2f,
  0x5a2e, 0x5a29, 0x5a28, 0x5a2b, 0x5a2a, 0x5a25, 0x5a24, 0x5a27,
  0x5a26, 0x5a21, 0x5a20, 0x5a23, 0x5a22, 0x5a3d, 0x5a3c, 0x5a3f,
  0x5a3e, 0x5a39, 0x5a38, 0x5a3b, 0x5a3a, 0x5a35, 0x5a34, 0x5a32,
  0x5a37, 0x5a36, 0x5a31, 0x5a30, 0x5a33, 0x5a4d, 0x5a4c, 0x5a4f,
  0x5a4e, 0x5a49, 0x5a48, 0x5a4b, 0x5a4a, 0x5a45, 0x5a44, 0x5a43,
  0x5a47, 0x5a46, 0x5a41, 0x5a40, 0x5a42, 0x5a5d, 0x5a5c, 0x5a5f,
  0x5a5e, 0x5a59, 0x5a58, 0x5a5b, 0x5a5a, 0x5a55, 0x5a54, 0x5a57,
  0x5a56, 0x5a51, 0x5a50, 0x5a53, 0x5a52, 0x5a6d, 0x5a6c, 0x5a6f,
  0x5a6e, 0x5a69, 0x5a68, 0x5a6b, 0x5a6a, 0x5a65, 0x5a64, 0x5a67,
  0x5a66, 0x5a61, 0x5a60, 0x5a63, 0x5a62, 0x5a7f, 0x5a7d, 0x5a7c,
  0x5a7e, 0x5a79, 0x5a78, 0x5a7b, 0x5a7a, 0x5a75, 0x5a74, 0x5a77,
  0x5a76, 0x5a71, 0x5a70, 0x5a73, 0x5b2c, 0x5b2f, 0x5b2e, 0x5b29,
  0x5b28, 0x5b2b, 0x5b2a, 0x5b25, 0x5b24, 0x5b27, 0x5b26, 0x5b21,
  0x5b20, 0x5b23, 0x5b22, 0x5b3d, 0x5b3f, 0x5b3c, 0x5b3e, 0x5b39,
  0x5b38, 0x5b3b, 0x5b3a, 0x5b35, 0x5b34, 0x5b37, 0x5b36, 0x5b31,
  0x5b30, 0x5b33, 0x5b32, 0x5b4d, 0x5b4c, 0x5b4f, 0x5b4e, 0x5b49,
  0x5b48, 0x5b4b, 0x5b4a, 0x5b45, 0x5b44, 0x5b47, 0x5b46, 0x5b41,
  0x5b40, 0x5b43, 0x5b42, 0x5b5d, 0x5b5c, 0x5b5f, 0x5b5e, 0x5b59,
  0x5b58, 0x5b5b, 0x5b5a, 0x5b55, 0x5b54, 0x5b57, 0x5b56, 0x5b51,
  0x5b50, 0x5b62, 0x5b53, 0x5b52, 0x5b6d, 0x5b6c, 0x5b6f, 0x5b6e,
  0x5b69, 0x5b68, 0x5b6b, 0x5b6a, 0x5b65, 0x5b64, 0x5b67, 0x5b66,
  0x5b61, 0x5b60, 0x5b63, 0x5b7d, 0x5b7c, 0x5b7f, 0x5b7e, 0x5b79,
  0x5b78, 0x5b7b, 0x5b7a, 0x5b75, 0x5b74, 0x5b77, 0x5b76, 0x5b71,
  0x5b70, 0x5b73, 0x642c, 0x642f, 0x642e, 0x6429, 0x6428, 0x642b,
  0x642a, 0x6425, 0x6424, 0x6427, 0x6426, 0x6421, 0x6420, 0x6423,
  0x6422, 0x643d, 0x643c, 0x643f, 0x643e, 0x6439, 0x6438, 0x643b,
  0x643a, 0x6435, 0x6434, 0x6437, 0x6436, 0x6431, 0x6430, 0x6433,
  0x6432, 0x644d, 0x644c, 0x644f, 0x644e, 0x6449, 0x6448, 0x644b,
  0x644a, 0x6445, 0x6444, 0x6447, 0x6446, 0x6441, 0x6440, 0x6443,
  0x6442, 0x645d, 0x645c, 0x645f, 0x645e, 0x6459, 0x6458, 0x645b,
  0x645a, 0x6455, 0x6454, 0x6457, 0x6456, 0x6451, 0x6450, 0x6469,
  0x6453, 0x6452, 0x646d, 0x646c, 0x646f, 0x646e, 0x6468, 0x646b,
  0x646a, 0x6465, 0x6464, 0x6467, 0x6466, 0x6461, 0x6460, 0x6463,
  0x6462, 0x647d, 0x647c, 0x647f, 0x647e, 0x6479, 0x6478, 0x647b,
  0x647a, 0x6475, 0x6474, 0x6477, 0x6476, 0x6471, 0x6470, 0x6473,
  0x652c, 0x652f, 0x652e, 0x6529, 0x6528, 0x652b, 0x652a, 0x6525,
  0x6524, 0x6527, 0x6526, 0x6521, 0x6520, 0x6523, 0x6522, 0x653d,
  0x653c, 0x653f, 0x653e, 0x6539, 0x6538, 0x653b, 0x653a, 0x6535,
  0x6534, 0x6537, 0x6536, 0x6531, 0x6530, 0x6533, 0x6532, 0x654d,
  0x654c, 0x654f, 0x654e, 0x6549, 0x6548, 0x654b, 0x654a, 0x6545,
  0x6544, 0x6547, 0x6546, 0x6541, 0x6540, 0x6543, 0x6542, 0x655d,
  0x655c, 0x655f, 0x6559, 0x6558, 0x655b, 0x655e, 0x655a, 0x6555,
  0x6554, 0x6557, 0x6556, 0x6551, 0x6550, 0x6553, 0x6552, 0x656d,
  0x656c, 0x656f, 0x656e, 0x6569, 0x6568, 0x656b, 0x656a, 0x6565,
  0x6564, 0x6567, 0x6566, 0x6561, 0x6560, 0x6563, 0x6562, 0x657d,
  0x657c, 0x657f, 0x657e, 0x6579, 0x6578, 0x657b, 0x657a, 0x6575,
  0x6574, 0x6577, 0x6576, 0x6570, 0x6573, 0x662c, 0x662f, 0x662e,
  0x6629, 0x6571, 0x6620, 0x6628, 0x662b, 0x662a, 0x6625, 0x6624,
  0x6627, 0x6626, 0x6621, 0x6622, 0x663d, 0x663c, 0x663f, 0x6623,
  0x663e, 0x6639, 0x6638, 0x663b, 0x663a, 0x6635, 0x6634, 0x6637,
  0x6636, 0x6631, 0x6630, 0x6633, 0x6632, 0x664d, 0x664c, 0x664f,
  0x664e, 0x6648, 0x664b, 0x6649, 0x664a, 0x6645, 0x6644, 0x6647,
  0x6646, 0x6641, 0x6640, 0x6643, 0x6642, 0x665d, 0x665c, 0x665f,
  0x665e, 0x6659, 0x6658, 0x665b, 0x665a, 0x6655, 0x6654, 0x6657,
  0x6656, 0x6651, 0x6650, 0x6653, 0x6652, 0x666d, 0x666c, 0x666f,
  0x666e, 0x6669, 0x6668, 0x666b, 0x666a, 0x6665, 0x6664, 0x6667,
  0x6666, 0x6661, 0x6660, 0x6663, 0x6662, 0x667d, 0x667c, 0x667f,
  0x667e, 0x6679, 0x6678, 0x667b, 0x667a, 0x6675, 0x6674, 0x6677,
  0x6676, 0x6671, 0x6670, 0x6673, 0x672c, 0x672f, 0x672e, 0x6729,
  0x6728, 0x672b, 0x672a, 0x6725, 0x6724, 0x6727, 0x6726, 0x6721,
  0x6720, 0x6723, 0x6722, 0x673d, 0x673c, 0x673f, 0x673e, 0x6739,
  0x6738, 0x673b, 0x673a, 0x6735, 0x6734, 0x6737, 0x6736, 0x6731,
  0x6730, 0x6733, 0x6732, 0x674d, 0x674c, 0x674f, 0x674e, 0x6749,
  0x6748, 0x674b, 0x674a, 0x6745, 0x6744, 0x6747, 0x6746, 0x6741,
  0x6740, 0x6743, 0x6742, 0x675d, 0x675c, 0x675f, 0x675e, 0x6759,
  0x6758, 0x675b, 0x675a, 0x6755, 0x6754, 0x6757, 0x6756, 0x6751,
  0x6750, 0x6753, 0x6752, 0x676d, 0x676c, 0x676f, 0x676e, 0x6769,
  0x6768, 0x676b, 0x676a, 0x6765, 0x6764, 0x6767, 0x6766, 0x6761,
  0x6760, 0x6763, 0x6762, 0x677d, 0x677c, 0x677f, 0x677e, 0x6779,
  0x6778, 0x677b, 0x677a, 0x6775, 0x6774, 0x6777, 0x6776, 0x6771,
  0x6770, 0x6773, 0x602c, 0x602f, 0x602e, 0x6029, 0x6028, 0x602b,
  0x602a, 0x6025, 0x6024, 0x6027, 0x6026, 0x6021, 0x6020, 0x6023,
  0x6022, 0x603d, 0x603c, 0x603f, 0x603e, 0x6039, 0x6038, 0x603b,
  0x603a, 0x6035, 0x6034, 0x6037, 0x6036, 0x6031, 0x6030, 0x6033,
  0x6032, 0x604d, 0x604c, 0x604f, 0x604e, 0x6049, 0x6048, 0x604b,
  0x604a, 0x6045, 0x6044, 0x6047, 0x6046, 0x6041, 0x6040, 0x6043,
  0x6042, 0x605d, 0x605c, 0x605f, 0x605e, 0x6059, 0x6058, 0x605b,
  0x605a, 0x6055, 0x6054, 0x6057, 0x6056, 0x6051, 0x6050, 0x6053,
  0x6052, 0x606d, 0x606c, 0x606f, 0x606e, 0x6069, 0x6068, 0x606b,
  0x606a, 0x6065, 0x6064, 0x6067, 0x6066, 0x6061, 0x6060, 0x6063,
  0x6062, 0x607d, 0x607c, 0x607f, 0x607e, 0x6079, 0x6078, 0x607b,
  0x607a, 0x6075, 0x6074, 0x6077, 0x6076, 0x6071, 0x6070, 0x6073,
  0x612c, 0x612f, 0x612e, 0x6129, 0x6128, 0x612b, 0x612a, 0x6125,
  0x6124, 0x6127, 0x6126, 0x6121, 0x6120, 0x6123, 0x6122, 0x613d,
  0x613c, 0x613f, 0x613e, 0x6139, 0x6138, 0x6136, 0x613b, 0x613a,
  0x6135, 0x6134, 0x6137, 0x6131, 0x6130, 0x6133, 0x6132, 0x614d,
  0x614c, 0x614f, 0x614e, 0x6149, 0x6148, 0x614b, 0x614a, 0x6145,
  0x6144, 0x6147, 0x6146, 0x6141, 0x6140, 0x6142, 0x615d, 0x6143,
  0x615c, 0x615f, 0x615e, 0x6159, 0x6158, 0x615b, 0x615a, 0x6155,
  0x6154, 0x6157, 0x6156, 0x6151, 0x6150, 0x6153, 0x6152, 0x616d,
  0x616c, 0x616f, 0x616e, 0x6169, 0x6168, 0x616b, 0x6165, 0x616a,
  0x6164, 0x6167, 0x6166, 0x6161, 0x6160, 0x6163, 0x6162, 0x617d,
  0x617c, 0x617f, 0x617e, 0x6179, 0x6178, 0x617b, 0x617a, 0x6175,
  0x6174, 0x6177, 0x6171, 0x6176, 0x6170, 0x6173, 0x622c, 0x622f,
  0x622e, 0x6229, 0x6228, 0x622b, 0x622a, 0x6225, 0x6224, 0x6227,
  0x6226, 0x6221, 0x6220, 0x6223, 0x6222, 0x623d, 0x623c, 0x623f,
  0x623e, 0x6239, 0x6238, 0x623b, 0x623a, 0x6235, 0x6234, 0x6237,
  0x6236, 0x6231, 0x6230, 0x6233, 0x6232, 0x624d, 0x624c, 0x624f,
  0x624e, 0x6249, 0x6248, 0x624b, 0x624a, 0x6245, 0x6244, 0x6247,
  0x6246, 0x6241, 0x6240, 0x6243, 0x6242, 0x625d, 0x625c, 0x625f,
  0x625e, 0x6259, 0x6258, 0x625b, 0x625a, 0x6255, 0x6254, 0x6257,
  0x6256, 0x6251, 0x6250, 0x6253, 0x6252, 0x626d, 0x626c, 0x626f,
  0x626e, 0x6269, 0x6268, 0x626b, 0x626a, 0x6265, 0x6264, 0x6267,
  0x6266, 0x6261, 0x6260, 0x6263, 0x6262, 0x627d, 0x627c, 0x627f,
  0x627e, 0x6278, 0x627b, 0x627a, 0x6275, 0x6274, 0x6277, 0x6276,
  0x6271, 0x6270, 0x6273, 0x632c, 0x632f, 0x632e, 0x6329, 0x6328,
  0x632b, 0x632a, 0x6325, 0x6324, 0x6327, 0x6326, 0x6321, 0x6320,
  0x6323, 0x6322, 0x633d, 0x633c, 0x633f, 0x633e, 0x6339, 0x6338,
  0x633b, 0x633a, 0x6335, 0x6334, 0x6337, 0x6336, 0x6331, 0x6330,
  0x6333, 0x6332, 0x634d, 0x634c, 0x634f, 0x634e, 0x6349, 0x6348,
  0x634b, 0x634a, 0x6345, 0x6344, 0x6347, 0x6346, 0x6341, 0x6340,
  0x6343, 0x6342, 0x635d, 0x635c, 0x635f, 0x635e, 0x6359, 0x6358,
  0x635b, 0x635a, 0x6355, 0x6354, 0x6357, 0x6356, 0x6351, 0x6350,
  0x6353, 0x6352, 0x636d, 0x636c, 0x636f, 0x636e, 0x6369, 0x6368,
  0x636b, 0x6367, 0x636a, 0x6365, 0x6364, 0x6366, 0x6361, 0x6360,
  0x6363, 0x6362, 0x637d, 0x637c, 0x637f, 0x637e, 0x6379, 0x637b,
  0x637a, 0x6375, 0x6374, 0x6378, 0x6377, 0x6376, 0x6371, 0x6370,
  0x6c25, 0x6373, 0x6c2c, 0x6c2f, 0x6c2e, 0x6c29, 0x6c28, 0x6c2b,
  0x6c2a, 0x6c24, 0x6c27, 0x6c26, 0x6c21, 0x6c20, 0x6c23, 0x6c22,
  0x6c3d, 0x6c3c, 0x6c3f, 0x6c3e, 0x6c39, 0x6c38, 0x6c3b, 0x6c3a,
  0x6c35, 0x6c34, 0x6c37, 0x6c36, 0x6c31, 0x6c30, 0x6c33, 0x6c32,
  0x6c4d, 0x6c4c, 0x6c4f, 0x6c4e, 0x6c49, 0x6c48, 0x6c4b, 0x6c4a,
  0x6c45, 0x6c44, 0x6c47, 0x6c46, 0x6c41, 0x6c40, 0x6c43, 0x6c42,
  0x6c5d, 0x6c5c, 0x6c5f, 0x6c5e, 0x6c59, 0x6c58, 0x6c5b, 0x6c5a,
  0x6c55, 0x6c54, 0x6c57, 0x6c56, 0x6c51, 0x6c50, 0x6c53, 0x6c52,
  0x6c6d, 0x6c6c, 0x6c6f, 0x6c6e, 0x6c69, 0x6c68, 0x6c6b, 0x6c6a,
  0x6c65, 0x6c64, 0x6c67, 0x6c66, 0x6c61, 0x6c60, 0x6c63, 0x6c62,
  0x6c7d, 0x6c7c, 0x6c7f, 0x6c7e, 0x6c79, 0x6c78, 0x6c7b, 0x6c7a,
  0x6c75, 0x6c74, 0x6c77, 0x6c76, 0x6c71, 0x6c70, 0x6c73, 0x6d2c,
  0x6d2f, 0x6d2e, 0x6d29, 0x6d28, 0x6d2b, 0x6d2a, 0x6d25, 0x6d24,
  0x6d27, 0x6d26, 0x6d21, 0x6d20, 0x6d23, 0x6d22, 0x6d3d, 0x6d3c,
  0x6d3f, 0x6d3e, 0x6d39, 0x6d38, 0x6d3b, 0x6d3a, 0x6d35, 0x6d34,
  0x6d37, 0x6d36, 0x6d31, 0x6d30, 0x6d33, 0x6d32, 0x6d4d, 0x6d4c,
  0x6d4f, 0x6d4e, 0x6d49, 0x6d48, 0x6d4b, 0x6d4a, 0x6d45, 0x6d44,
  0x6d47, 0x6d41, 0x6d40, 0x6d46, 0x6d43, 0x6d42, 0x6d5d, 0x6d5c,
  0x6d5f, 0x6d5e, 0x6d59, 0x6d58, 0x6d5b, 0x6d5a, 0x6d55, 0x6d54,
  0x6d57, 0x6d56, 0x6d51, 0x6d50, 0x6d53, 0x6d52, 0x6d6d, 0x6d6c,
  0x6d6f, 0x6d6e, 0x6d69, 0x6d68, 0x6d6b, 0x6d6a, 0x6d65, 0x6d64,
  0x6d67, 0x6d66, 0x6d61, 0x6d60, 0x6d63, 0x6d62, 0x6d7d, 0x6d7c,
  0x6d7f, 0x6d7e, 0x6d79, 0x6d78, 0x6d7b, 0x6d7a, 0x6d75, 0x6d74,
  0x6d77, 0x6d76, 0x6d71, 0x6d70, 0x6d73, 0x6e2c, 0x6e2f, 0x6e2e,
  0x6e29, 0x6e28, 0x6e2b, 0x6e2a, 0x6e25, 0x6e24, 0x6e27, 0x6e26,
  0x6e21, 0x6e20, 0x6e23, 0x6e22, 0x6e3d, 0x6e3c, 0x6e3f, 0x6e3e,
  0x6e39, 0x6e38, 0x6e3b, 0x6e3a, 0x6e35, 0x6e34, 0x6e37, 0x6e36,
  0x6e31, 0x6e30, 0x6e33, 0x6e32, 0x6e4d, 0x6e4c, 0x6e4f, 0x6e4e,
  0x6e49, 0x6e48, 0x6e4b, 0x6e4a, 0x6e45, 0x6e44, 0x6e47, 0x6e46,
  0x6e41, 0x6e40, 0x6e43, 0x6e42, 0x6e5d, 0x6e5c, 0x6e5f, 0x6e5e,
  0x6e59, 0x6e58, 0x6e5b, 0x6e5a, 0x6e55, 0x6e54, 0x6e57, 0x6e56,
  0x6e51, 0x6e50, 0x6e53, 0x6e52, 0x6e6d, 0x6e6c, 0x6e6f, 0x6e6e,
  0x6e69, 0x6e68, 0x6e6b, 0x6e6a, 0x6e65, 0x6e64, 0x6e67, 0x6e66,
  0x6e61, 0x6e60, 0x6e63, 0x6e62, 0x6e7d, 0x6e7c, 0x6e7f, 0x6e7e,
  0x6e79, 0x6e78, 0x6e7b, 0x6e7a, 0x6e75, 0x6e74, 0x6e77, 0x6e76,
  0x6e71, 0x6e70, 0x6e73, 0x6f2c, 0x6f2f, 0x6f2e, 0x6f29, 0x6f28,
  0x6f2b, 0x6f2a, 0x6f25, 0x6f24, 0x6f27, 0x6f26, 0x6f21, 0x6f20,
  0x6f23, 0x6f22, 0x6f3d, 0x6f3c, 0x6f3f, 0x6f3e, 0x6f39, 0x6f38,
  0x6f3b, 0x6f3a, 0x6f35, 0x6f34, 0x6f37, 0x6f36, 0x6f31, 0x6f30,
  0x6f33, 0x6f32, 0x6f4d, 0x6f4c, 0x6f4f, 0x6f4e, 0x6f49, 0x6f48,
  0x6f4b, 0x6f4a, 0x6f45, 0x6f44, 0x6f5d, 0x6f47, 0x6f46, 0x6f41,
  0x6f40, 0x6f5f, 0x6f43, 0x6f42, 0x6f5c, 0x6f5e, 0x6f59, 0x6f58,
  0x6f5b, 0x6f5a, 0x6f55, 0x6f54, 0x6f57, 0x6f56, 0x6f51, 0x6f53,
  0x6f50, 0x6f52, 0x6f6d, 0x6f6c, 0x6f6f, 0x6f6e, 0x6f69, 0x6f68,
  0x6f6b, 0x6f6a, 0x6f65, 0x6f64, 0x6f67, 0x6f66, 0x6f60, 0x6f63,
  0x6f62, 0x6f61, 0x6f7d, 0x6f7c, 0x6f7f, 0x6f7e, 0x6f79, 0x6f7b,
  0x6f78, 0x6f7a, 0x6f75, 0x6f74, 0x6f77, 0x6f76, 0x6f71, 0x6f70,
  0x6f73, 0x682c, 0x682f, 0x682e, 0x6829, 0x6828, 0x682b, 0x682a,
  0x6825, 0x6824, 0x6827, 0x6826, 0x6821, 0x6820, 0x6823, 0x6822,
  0x683d, 0x683c, 0x683f, 0x683e, 0x6839, 0x6838, 0x683b, 0x683a,
  0x6835, 0x6834, 0x6837, 0x6836, 0x6831, 0x6830, 0x6833, 0x6832,
  0x684d, 0x684c, 0x684f, 0x684e, 0x6849, 0x6848, 0x684b, 0x684a,
  0x6845, 0x6844, 0x6847, 0x6846, 0x6841, 0x6843, 0x6842, 0x6840,
  0x685d, 0x685c, 0x685f, 0x685e, 0x6859, 0x6858, 0x685b, 0x685a,
  0x6855, 0x6854, 0x6857, 0x6856, 0x6851, 0x6850, 0x6853, 0x6852,
  0x686d, 0x686c, 0x686f, 0x686e, 0x6869, 0x6868, 0x686b, 0x686a,
  0x6865, 0x6864, 0x6867, 0x6866, 0x6861, 0x6860, 0x6863, 0x6862,
  0x687d, 0x687c, 0x687f, 0x687e, 0x6879, 0x6878, 0x687b, 0x687a,
  0x6875, 0x6874, 0x6877, 0x6876, 0x6871, 0x6870, 0x6873, 0x692c,
  0x692f, 0x692e, 0x6929, 0x6928, 0x692b, 0x692a, 0x6925, 0x6924,
  0x6927, 0x6926, 0x6921, 0x6920, 0x6923, 0x6922, 0x693d, 0x693c,
  0x693f, 0x693e, 0x6939, 0x6938, 0x693b, 0x693a, 0x6935, 0x6934,
  0x6937, 0x6936, 0x6931, 0x6930, 0x6933, 0x6932, 0x694d, 0x694c,
  0x694f, 0x694e, 0x6949, 0x6948, 0x694b, 0x694a, 0x6945, 0x6944,
  0x6947, 0x6946, 0x6941, 0x6940, 0x6943, 0x6942, 0x695d, 0x695c,
  0x695f, 0x695e, 0x6959, 0x6958, 0x695b, 0x695a, 0x6955, 0x6954,
  0x6957, 0x6956, 0x6951, 0x6950, 0x6953, 0x6952, 0x696d, 0x696c,
  0x696f, 0x696e, 0x263a
};

static const aciConvSummary16 jisx0212_uni2indx_page00[ /*70*/ ] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0xc652 }, {    7, 0x8500 },
  {   10, 0xffff }, {   26, 0xff7e }, {   40, 0xffff }, {   56, 0xff7f },
  /* 0x0100 */
  {   71, 0xffff }, {   87, 0xffcf }, {  101, 0xcff7 }, {  114, 0xffff },
  {  130, 0x3fff }, {  144, 0xffff }, {  160, 0xffff }, {  176, 0x7fff },
  {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 },
  {  191, 0xe000 }, {  194, 0x1fff }, {  207, 0x0000 }, {  207, 0x0020 },
  /* 0x0200 */
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 }, {  208, 0x0000 },
  {  208, 0x0080 }, {  209, 0x2f00 }, {  214, 0x0000 }, {  214, 0x0000 },
  /* 0x0300 */
  {  214, 0x0000 }, {  214, 0x0000 }, {  214, 0x0000 }, {  214, 0x0000 },
  {  214, 0x0000 }, {  214, 0x0000 }, {  214, 0x0000 }, {  214, 0x0000 },
  {  214, 0xd770 }, {  223, 0x0001 }, {  224, 0xfc00 }, {  230, 0x0001 },
  {  231, 0x7c04 }, {  237, 0x0000 }, {  237, 0x0000 }, {  237, 0x0000 },
  /* 0x0400 */
  {  237, 0xdffc }, {  250, 0x0000 }, {  250, 0x0000 }, {  250, 0x0000 },
  {  250, 0x0000 }, {  250, 0xdffc }
};

static const aciConvSummary16 jisx0212_uni2indx_page21[ /*3*/ ] = {
  /* 0x2100 */
  {  263, 0x0000 }, {  263, 0x0040 }, {  264, 0x0004 }
};

static const aciConvSummary16 jisx0212_uni2indx_page4e[ /*1307*/ ] = {
  /* 0x4e00 */
  {  265, 0x1034 }, {  269, 0x8004 }, {  271, 0xc918 }, {  277, 0x0021 },
  {  279, 0x0093 }, {  283, 0x1402 }, {  286, 0x0308 }, {  289, 0x8230 },
  {  293, 0x2000 }, {  294, 0x20c0 }, {  297, 0x8000 }, {  298, 0x0200 },
  {  299, 0x0008 }, {  300, 0x0c01 }, {  303, 0x8107 }, {  308, 0xe02a },
  /* 0x4f00 */
  {  314, 0x190d }, {  320, 0x02e4 }, {  325, 0x4000 }, {  326, 0x4aaa },
  {  333, 0x1b05 }, {  339, 0x8154 }, {  344, 0x5409 }, {  349, 0x6782 },
  {  356, 0x5636 }, {  364, 0xc69d }, {  373, 0x0000 }, {  373, 0x7a84 },
  {  380, 0xbb63 }, {  390, 0x1004 }, {  392, 0x0005 }, {  394, 0xb005 },
  /* 0x5000 */
  {  399, 0x5493 }, {  406, 0x7989 }, {  414, 0x4084 }, {  417, 0x082d },
  {  422, 0x5467 }, {  430, 0x828e }, {  436, 0x24cd }, {  443, 0x0003 },
  {  445, 0xc45a }, {  452, 0xd85d }, {  461, 0x8407 }, {  466, 0x2601 },
  {  470, 0x5099 }, {  476, 0xb119 }, {  483, 0x8354 }, {  489, 0x4446 },
  /* 0x5100 */
  {  494, 0x79c8 }, {  502, 0x7a81 }, {  509, 0xb188 }, {  515, 0x033a },
  {  521, 0x8404 }, {  524, 0x81a8 }, {  529, 0x0050 }, {  531, 0x4000 },
  {  532, 0x4818 }, {  536, 0x2100 }, {  538, 0x200a }, {  541, 0xd500 },
  {  546, 0x8104 }, {  549, 0x412e }, {  555, 0x4024 }, {  558, 0x009c },
  /* 0x5200 */
  {  562, 0x0026 }, {  565, 0x016c }, {  570, 0x0104 }, {  572, 0x1026 },
  {  576, 0x0220 }, {  578, 0x95a0 }, {  584, 0x4043 }, {  588, 0x0380 },
  {  591, 0x1425 }, {  596, 0x15e8 }, {  603, 0x80f0 }, {  608, 0x2dc1 },
  {  615, 0x9151 }, {  621, 0x1852 }, {  626, 0x1722 }, {  632, 0x00d3 },
  /* 0x5300 */
  {  637, 0x1c09 }, {  642, 0xd90a }, {  649, 0x3ba0 }, {  656, 0x7025 },
  {  662, 0x1804 }, {  665, 0x0a00 }, {  667, 0x302a }, {  672, 0x4204 },
  {  675, 0x4188 }, {  679, 0x2218 }, {  683, 0x8c12 }, {  688, 0x25b4 },
  {  695, 0x8021 }, {  698, 0x642c }, {  704, 0x00c1 }, {  707, 0x0020 },
  /* 0x5400 */
  {  708, 0x0004 }, {  709, 0x0408 }, {  711, 0x8582 }, {  716, 0x0032 },
  {  719, 0xa098 }, {  724, 0x4000 }, {  725, 0x6ad4 }, {  733, 0x8010 },
  {  735, 0x232a }, {  741, 0x9062 }, {  746, 0x66c2 }, {  753, 0x8e82 },
  {  759, 0x6440 }, {  763, 0x0000 }, {  763, 0x9401 }, {  767, 0xd040 },
  /* 0x5500 */
  {  771, 0x7323 }, {  779, 0x0020 }, {  780, 0x0c00 }, {  782, 0x3864 },
  {  788, 0x2682 }, {  793, 0x4d03 }, {  799, 0x0053 }, {  803, 0x8000 },
  {  804, 0xc146 }, {  810, 0x009e }, {  815, 0x2018 }, {  818, 0x8004 },
  {  820, 0x5a4a }, {  827, 0x498e }, {  834, 0x0204 }, {  836, 0x8040 },
  /* 0x5600 */
  {  838, 0xe520 }, {  844, 0x0207 }, {  848, 0x1000 }, {  849, 0xbaa9 },
  {  858, 0xaa5b }, {  867, 0x4010 }, {  869, 0xa24f }, {  877, 0x0026 },
  {  880, 0x1930 }, {  885, 0xe620 }, {  891, 0x3bc0 }, {  898, 0x408a },
  {  902, 0xbe20 }, {  909, 0xb201 }, {  914, 0x29f2 }, {  922, 0x00c2 },
  /* 0x5700 */
  {  925, 0x1486 }, {  930, 0x2c22 }, {  935, 0xd63d }, {  945, 0xe018 },
  {  950, 0x3060 }, {  954, 0x0004 }, {  955, 0xe9a4 }, {  963, 0x5ebb },
  {  974, 0x100a }, {  977, 0xf6b0 }, {  986, 0x1382 }, {  991, 0x2100 },
  {  993, 0x9180 }, {  997, 0x6020 }, { 1000, 0x22d2 }, { 1006, 0xe161 },
  /* 0x5800 */
  { 1013, 0x3318 }, { 1019, 0xc800 }, { 1022, 0x20c1 }, { 1026, 0x8204 },
  { 1029, 0xb200 }, { 1033, 0x8021 }, { 1036, 0x0192 }, { 1040, 0x9100 },
  { 1043, 0xb783 }, { 1052, 0x2051 }, { 1056, 0x0247 }, { 1061, 0x1006 },
  { 1064, 0x6114 }, { 1069, 0x2455 }, { 1075, 0x0206 }, { 1078, 0x0008 },
  /* 0x5900 */
  { 1079, 0x1860 }, { 1083, 0x201c }, { 1087, 0x811a }, { 1092, 0x8069 },
  { 1097, 0x0048 }, { 1099, 0xea0c }, { 1106, 0xa80a }, { 1111, 0x1a64 },
  { 1117, 0x5800 }, { 1120, 0x80a4 }, { 1124, 0xe090 }, { 1129, 0x1489 },
  { 1134, 0x251a }, { 1140, 0xe004 }, { 1144, 0xc098 }, { 1149, 0x0096 },
  /* 0x5a00 */
  { 1153, 0x7011 }, { 1158, 0x400c }, { 1161, 0x2598 }, { 1167, 0x0001 },
  { 1168, 0x11b0 }, { 1173, 0x4021 }, { 1176, 0x20a8 }, { 1180, 0x4c80 },
  { 1184, 0x0800 }, { 1185, 0xd249 }, { 1192, 0x1085 }, { 1196, 0x8d2e },
  { 1204, 0x8150 }, { 1208, 0x1400 }, { 1210, 0x4421 }, { 1214, 0x2060 },
  /* 0x5b00 */
  { 1217, 0x0103 }, { 1220, 0x2a80 }, { 1224, 0x2022 }, { 1227, 0x0110 },
  { 1229, 0x1802 }, { 1232, 0x4044 }, { 1235, 0xc100 }, { 1238, 0xf000 },
  { 1242, 0x4452 }, { 1247, 0x005b }, { 1252, 0xb300 }, { 1257, 0x1486 },
  { 1262, 0xa003 }, { 1266, 0x07c0 }, { 1271, 0x8001 }, { 1273, 0x2012 },
  /* 0x5c00 */
  { 1276, 0x1000 }, { 1277, 0xc080 }, { 1280, 0x5a48 }, { 1286, 0x0065 },
  { 1290, 0x0000 }, { 1290, 0x1600 }, { 1293, 0x238c }, { 1299, 0x3c31 },
  { 1306, 0x8580 }, { 1310, 0xa004 }, { 1313, 0x044d }, { 1318, 0x0434 },
  { 1322, 0x0a00 }, { 1324, 0x2084 }, { 1327, 0x4000 }, { 1328, 0x0016 },
  /* 0x5d00 */
  { 1331, 0x2042 }, { 1334, 0x0004 }, { 1335, 0x08d8 }, { 1340, 0xa212 },
  { 1345, 0x054c }, { 1350, 0x8222 }, { 1354, 0x2417 }, { 1360, 0xc601 },
  { 1365, 0x050a }, { 1369, 0x8a3c }, { 1376, 0x0881 }, { 1379, 0x0315 },
  { 1384, 0x4888 }, { 1388, 0x0301 }, { 1391, 0x0211 }, { 1394, 0x0300 },
  /* 0x5e00 */
  { 1396, 0x2081 }, { 1399, 0x8134 }, { 1404, 0x4101 }, { 1407, 0x4024 },
  { 1410, 0x0a00 }, { 1412, 0x5943 }, { 1419, 0x7d00 }, { 1425, 0x0001 },
  { 1426, 0x4801 }, { 1429, 0x0000 }, { 1429, 0x1534 }, { 1435, 0xe00a },
  { 1440, 0x5840 }, { 1444, 0x5036 }, { 1450, 0x0820 }, { 1452, 0x0000 },
  /* 0x5f00 */
  { 1452, 0x41c4 }, { 1457, 0x3200 }, { 1460, 0x591e }, { 1468, 0xa851 },
  { 1474, 0x20b1 }, { 1479, 0x0911 }, { 1483, 0x8099 }, { 1488, 0x6534 },
  { 1495, 0xa200 }, { 1498, 0x3040 }, { 1501, 0x9894 }, { 1507, 0x0103 },
  { 1510, 0x0b90 }, { 1515, 0x401f }, { 1521, 0xf706 }, { 1530, 0x144c },
  /* 0x6000 */
  { 1535, 0x2480 }, { 1538, 0x8598 }, { 1544, 0x2010 }, { 1546, 0x0028 },
  { 1548, 0x1381 }, { 1553, 0x20d2 }, { 1558, 0x0082 }, { 1560, 0xc002 },
  { 1563, 0x4544 }, { 1568, 0x612a }, { 1574, 0x0134 }, { 1578, 0x4883 },
  { 1583, 0xcf14 }, { 1591, 0x6a30 }, { 1597, 0x0024 }, { 1599, 0x3124 },
  /* 0x6100 */
  { 1604, 0x1484 }, { 1608, 0x52df }, { 1618, 0x0c04 }, { 1621, 0x02e3 },
  { 1627, 0x0262 }, { 1631, 0x4000 }, { 1632, 0x1001 }, { 1634, 0x9904 },
  { 1639, 0x281b }, { 1645, 0xb18c }, { 1652, 0x2521 }, { 1657, 0x1300 },
  { 1660, 0xc007 }, { 1665, 0xf020 }, { 1670, 0xb2a6 }, { 1678, 0x0000 },
  /* 0x6200 */
  { 1678, 0x009a }, { 1682, 0x1028 }, { 1685, 0x0a8d }, { 1691, 0x2200 },
  { 1693, 0x105c }, { 1698, 0x1457 }, { 1705, 0xa010 }, { 1708, 0x2408 },
  { 1711, 0xe000 }, { 1714, 0x0001 }, { 1715, 0x0140 }, { 1717, 0xc4c8 },
  { 1723, 0x4010 }, { 1725, 0x0460 }, { 1728, 0x0400 }, { 1729, 0x3014 },
  /* 0x6300 */
  { 1733, 0x2c18 }, { 1738, 0x0149 }, { 1742, 0x2600 }, { 1745, 0x1260 },
  { 1749, 0x4c5e }, { 1757, 0x091c }, { 1762, 0x3060 }, { 1766, 0xb132 },
  { 1773, 0x0494 }, { 1777, 0x4631 }, { 1783, 0xe050 }, { 1788, 0x2000 },
  { 1789, 0x4122 }, { 1793, 0x103a }, { 1798, 0x1421 }, { 1802, 0x032c },
  /* 0x6400 */
  { 1807, 0x0600 }, { 1809, 0x4115 }, { 1814, 0x8635 }, { 1821, 0xa021 },
  { 1825, 0x8800 }, { 1827, 0xbc1e }, { 1836, 0x200b }, { 1840, 0x2818 },
  { 1844, 0x80a0 }, { 1847, 0xab03 }, { 1854, 0x114a }, { 1859, 0xe008 },
  { 1863, 0x5e10 }, { 1869, 0x00a3 }, { 1873, 0x2630 }, { 1878, 0x88a1 },
  /* 0x6500 */
  { 1883, 0x8712 }, { 1889, 0xca58 }, { 1896, 0x4244 }, { 1900, 0x3402 },
  { 1904, 0x0288 }, { 1907, 0x8015 }, { 1911, 0x0881 }, { 1914, 0x2400 },
  { 1916, 0x0422 }, { 1919, 0x2124 }, { 1923, 0x4049 }, { 1927, 0x801c },
  { 1931, 0x4304 }, { 1935, 0x8151 }, { 1940, 0x0000 }, { 1940, 0xc235 },
  /* 0x6600 */
  { 1947, 0x2311 }, { 1952, 0x6066 }, { 1958, 0x5e5e }, { 1968, 0x028b },
  { 1973, 0x5461 }, { 1979, 0x1b82 }, { 1985, 0x1c03 }, { 1990, 0xdba8 },
  { 1999, 0x3801 }, { 2003, 0x9e05 }, { 2010, 0x2011 }, { 2013, 0x8826 },
  { 2018, 0xd10d }, { 2025, 0x8810 }, { 2028, 0x5900 }, { 2032, 0x0c00 },
  /* 0x6700 */
  { 2034, 0x40a0 }, { 2037, 0x1208 }, { 2040, 0x0005 }, { 2042, 0x4008 },
  { 2044, 0x11a0 }, { 2048, 0x2030 }, { 2051, 0x5040 }, { 2054, 0x0850 },
  { 2057, 0xc012 }, { 2061, 0x0b4a }, { 2067, 0x0000 }, { 2067, 0x3827 },
  { 2074, 0x032d }, { 2080, 0x1284 }, { 2084, 0x0042 }, { 2086, 0x02c5 },
  /* 0x6800 */
  { 2091, 0x0000 }, { 2091, 0xa210 }, { 2095, 0xb180 }, { 2100, 0x880b },
  { 2105, 0x1430 }, { 2109, 0x09a4 }, { 2114, 0xc800 }, { 2117, 0x1e27 },
  { 2125, 0x0154 }, { 2129, 0x1540 }, { 2133, 0x462a }, { 2139, 0x0804 },
  { 2141, 0x9120 }, { 2145, 0x324b }, { 2152, 0x3d20 }, { 2158, 0x3863 },
  /* 0x6900 */
  { 2165, 0x0640 }, { 2168, 0x00cb }, { 2173, 0x0000 }, { 2173, 0x092a },
  { 2178, 0x4224 }, { 2182, 0x0880 }, { 2184, 0x1378 }, { 2191, 0x8c07 },
  { 2197, 0x2001 }, { 2199, 0x0144 }, { 2202, 0xa962 }, { 2209, 0x1580 },
  { 2213, 0x0120 }, { 2215, 0x00c2 }, { 2218, 0xc024 }, { 2222, 0x402a },
  /* 0x6a00 */
  { 2226, 0x800b }, { 2230, 0x2422 }, { 2234, 0x0111 }, { 2237, 0xc895 },
  { 2244, 0x4660 }, { 2249, 0x0867 }, { 2255, 0x0490 }, { 2258, 0x400a },
  { 2261, 0x0aca }, { 2267, 0xe802 }, { 2272, 0x8820 }, { 2275, 0xe013 },
  { 2281, 0x1340 }, { 2285, 0x3071 }, { 2291, 0x1090 }, { 2294, 0x3007 },
  /* 0x6b00 */
  { 2299, 0x82cc }, { 2305, 0x4883 }, { 2310, 0x9910 }, { 2315, 0x8860 },
  { 2319, 0x2440 }, { 2322, 0x2144 }, { 2326, 0x4881 }, { 2330, 0x6021 },
  { 2334, 0x0024 }, { 2336, 0x8880 }, { 2339, 0x730d }, { 2347, 0x6301 },
  { 2352, 0x1218 }, { 2356, 0x0440 }, { 2358, 0x40ca }, { 2363, 0x8282 },
  /* 0x6c00 */
  { 2367, 0x6234 }, { 2373, 0x8205 }, { 2377, 0x51c0 }, { 2382, 0x8c68 },
  { 2388, 0xac00 }, { 2392, 0x1a14 }, { 2397, 0xa880 }, { 2401, 0x0b50 },
  { 2406, 0x02e0 }, { 2410, 0x91b0 }, { 2416, 0x0000 }, { 2416, 0x0015 },
  { 2419, 0xa044 }, { 2423, 0x1457 }, { 2430, 0x5a81 }, { 2436, 0x0014 },
  /* 0x6d00 */
  { 2438, 0xc490 }, { 2443, 0x040a }, { 2446, 0xc1c0 }, { 2451, 0x9202 },
  { 2455, 0x0000 }, { 2455, 0xc080 }, { 2458, 0x80a2 }, { 2462, 0x1001 },
  { 2464, 0x0084 }, { 2466, 0x01d6 }, { 2472, 0x1400 }, { 2474, 0xa290 },
  { 2479, 0xc510 }, { 2484, 0xa840 }, { 2488, 0x8225 }, { 2493, 0x1051 },
  /* 0x6e00 */
  { 2497, 0x0011 }, { 2499, 0x4000 }, { 2500, 0x0084 }, { 2502, 0x1a44 },
  { 2507, 0x8b30 }, { 2513, 0x709e }, { 2521, 0x010c }, { 2524, 0x2808 },
  { 2527, 0x2000 }, { 2528, 0x0208 }, { 2530, 0x6081 }, { 2534, 0x880a },
  { 2538, 0xe58b }, { 2547, 0x0000 }, { 2547, 0x6800 }, { 2550, 0x2a00 },
  /* 0x6f00 */
  { 2553, 0x3510 }, { 2558, 0x0d40 }, { 2562, 0xa640 }, { 2567, 0x1849 },
  { 2572, 0x8000 }, { 2573, 0x668e }, { 2581, 0x1106 }, { 2585, 0x6000 },
  { 2587, 0x3988 }, { 2593, 0x845d }, { 2600, 0xc1e1 }, { 2607, 0x1061 },
  { 2611, 0x05a0 }, { 2615, 0x4400 }, { 2617, 0x0300 }, { 2619, 0x3221 },
  /* 0x7000 */
  { 2624, 0x20e1 }, { 2629, 0x0080 }, { 2630, 0x8009 }, { 2633, 0x1290 },
  { 2637, 0x4f18 }, { 2644, 0x6030 }, { 2648, 0x5030 }, { 2652, 0x4060 },
  { 2655, 0x0062 }, { 2658, 0x09f0 }, { 2664, 0x0810 }, { 2666, 0x0093 },
  { 2670, 0x0400 }, { 2671, 0x117a }, { 2678, 0x0010 }, { 2679, 0x0400 },
  /* 0x7100 */
  { 2680, 0x98f8 }, { 2688, 0x4000 }, { 2689, 0xa801 }, { 2693, 0x0103 },
  { 2696, 0x0ce2 }, { 2702, 0x5485 }, { 2708, 0x0101 }, { 2710, 0x0200 },
  { 2711, 0x10a1 }, { 2715, 0x0c04 }, { 2718, 0x8005 }, { 2721, 0x840d },
  { 2726, 0x1813 }, { 2731, 0x1648 }, { 2736, 0x0000 }, { 2736, 0x4100 },
  /* 0x7200 */
  { 2738, 0x0381 }, { 2742, 0xa488 }, { 2747, 0x8810 }, { 2750, 0x0310 },
  { 2753, 0xc02e }, { 2759, 0x5469 }, { 2766, 0xc909 }, { 2772, 0x9982 },
  { 2778, 0x6210 }, { 2782, 0x0808 }, { 2784, 0x6100 }, { 2787, 0x4012 },
  { 2790, 0x1282 }, { 2794, 0x8160 }, { 2798, 0x0020 }, { 2799, 0x4c18 },
  /* 0x7300 */
  { 2804, 0x28b4 }, { 2810, 0x430c }, { 2815, 0x1194 }, { 2820, 0x2c26 },
  { 2826, 0x2008 }, { 2828, 0xe145 }, { 2835, 0xdac1 }, { 2843, 0x1282 },
  { 2847, 0x406b }, { 2853, 0xd1a9 }, { 2861, 0x2c65 }, { 2868, 0xb2a0 },
  { 2874, 0x9a60 }, { 2880, 0x224c }, { 2885, 0x02ca }, { 2890, 0xaeb0 },
  /* 0x7400 */
  { 2898, 0x0493 }, { 2903, 0x0c02 }, { 2906, 0xff50 }, { 2916, 0x0203 },
  { 2919, 0x28d9 }, { 2926, 0x2086 }, { 2930, 0x69c4 }, { 2937, 0x0006 },
  { 2939, 0x82e3 }, { 2946, 0x9707 }, { 2954, 0xcf4b }, { 2964, 0x8a26 },
  { 2970, 0x1300 }, { 2973, 0xcd09 }, { 2980, 0x8d10 }, { 2985, 0x9c10 },
  /* 0x7500 */
  { 2990, 0x0040 }, { 2991, 0x00c4 }, { 2994, 0x8693 }, { 3001, 0xe240 },
  { 3006, 0x4189 }, { 3011, 0xc085 }, { 3016, 0x8002 }, { 3018, 0x7e02 },
  { 3025, 0x0022 }, { 3027, 0x122d }, { 3033, 0x0014 }, { 3035, 0x8410 },
  { 3038, 0xd053 }, { 3045, 0x9080 }, { 3048, 0xd093 }, { 3055, 0x0202 },
  /* 0x7600 */
  { 3057, 0x959d }, { 3066, 0x7a6c }, { 3075, 0x2268 }, { 3080, 0x172c },
  { 3087, 0x0e3b }, { 3095, 0x8220 }, { 3098, 0xe030 }, { 3103, 0x0012 },
  { 3105, 0x3022 }, { 3109, 0xb820 }, { 3114, 0x25fd }, { 3124, 0x2000 },
  { 3125, 0x5a22 }, { 3131, 0x0210 }, { 3133, 0x1141 }, { 3137, 0x1243 },
  /* 0x7700 */
  { 3142, 0x4441 }, { 3146, 0x16b4 }, { 3153, 0xe104 }, { 3158, 0x6270 },
  { 3164, 0xe464 }, { 3171, 0xd0c4 }, { 3177, 0x1495 }, { 3183, 0x241d },
  { 3189, 0x3011 }, { 3193, 0x8470 }, { 3198, 0xc484 }, { 3203, 0x4022 },
  { 3206, 0x0208 }, { 3208, 0xc226 }, { 3214, 0x1451 }, { 3219, 0x0913 },
  /* 0x7800 */
  { 3224, 0x6260 }, { 3229, 0x2002 }, { 3231, 0x600e }, { 3236, 0x00a1 },
  { 3239, 0x5198 }, { 3245, 0x5004 }, { 3248, 0x451b }, { 3255, 0x4400 },
  { 3257, 0x8400 }, { 3259, 0xe110 }, { 3264, 0x3112 }, { 3269, 0xa80f },
  { 3276, 0x5380 }, { 3281, 0x886c }, { 3287, 0x0453 }, { 3292, 0x8ccc },
  /* 0x7900 */
  { 3299, 0x1041 }, { 3302, 0xd401 }, { 3307, 0x22a1 }, { 3312, 0xa832 },
  { 3318, 0x8c70 }, { 3324, 0x1912 }, { 3329, 0x0a80 }, { 3332, 0x5a04 },
  { 3337, 0x1800 }, { 3339, 0x197a }, { 3347, 0x8b02 }, { 3352, 0x0912 },
  { 3356, 0x8594 }, { 3362, 0x6450 }, { 3367, 0x2c25 }, { 3373, 0x1102 },
  /* 0x7a00 */
  { 3376, 0x168c }, { 3382, 0x4822 }, { 3386, 0xa882 }, { 3391, 0x0731 },
  { 3397, 0x11b0 }, { 3402, 0xb260 }, { 3408, 0x24a1 }, { 3413, 0x4120 },
  { 3416, 0x0c65 }, { 3422, 0x4013 }, { 3426, 0x1009 }, { 3429, 0x1a28 },
  { 3434, 0x5240 }, { 3438, 0x0802 }, { 3440, 0x1b00 }, { 3444, 0x6812 },
  /* 0x7b00 */
  { 3449, 0x0080 }, { 3450, 0x8010 }, { 3452, 0xee88 }, { 3460, 0xa013 },
  { 3465, 0x4083 }, { 3469, 0x0020 }, { 3470, 0xa651 }, { 3477, 0x008c },
  { 3480, 0x4210 }, { 3483, 0x4843 }, { 3488, 0x9021 }, { 3492, 0x3c65 },
  { 3500, 0x0524 }, { 3504, 0x0ed0 }, { 3510, 0x0500 }, { 3512, 0x5734 },
  /* 0x7c00 */
  { 3520, 0xda5e }, { 3530, 0x0a00 }, { 3532, 0x1161 }, { 3537, 0x065a },
  { 3543, 0x0440 }, { 3545, 0x7e2e }, { 3555, 0x628a }, { 3561, 0x3205 },
  { 3566, 0x80c0 }, { 3569, 0x4010 }, { 3571, 0x0041 }, { 3573, 0x9cc1 },
  { 3580, 0xa390 }, { 3586, 0x26b8 }, { 3593, 0x0a40 }, { 3596, 0x0020 },
  /* 0x7d00 */
  { 3597, 0x8388 }, { 3602, 0x604e }, { 3608, 0x2448 }, { 3612, 0x7002 },
  { 3616, 0x2183 }, { 3621, 0x368a }, { 3628, 0x04a0 }, { 3631, 0x8d01 },
  { 3636, 0x396e }, { 3645, 0x60c2 }, { 3650, 0x04c0 }, { 3653, 0x02c8 },
  { 3657, 0x707c }, { 3665, 0x0280 }, { 3667, 0x2c64 }, { 3673, 0x0662 },
  /* 0x7e00 */
  { 3678, 0x0101 }, { 3680, 0x30a3 }, { 3686, 0xb181 }, { 3692, 0x8048 },
  { 3695, 0x40b0 }, { 3699, 0x8105 }, { 3703, 0xc826 }, { 3709, 0x4108 },
  { 3712, 0x24c2 }, { 3717, 0x6522 }, { 3723, 0x0000 }, { 3723, 0x0000 },
  { 3723, 0x0000 }, { 3723, 0x0000 }, { 3723, 0x0000 }, { 3723, 0x0000 },
  /* 0x7f00 */
  { 3723, 0x0000 }, { 3723, 0x0000 }, { 3723, 0x0000 }, { 3723, 0xf800 },
  { 3728, 0x8098 }, { 3732, 0x380c }, { 3737, 0x207a }, { 3743, 0xe002 },
  { 3747, 0xa801 }, { 3751, 0x10c3 }, { 3756, 0x2446 }, { 3761, 0x9010 },
  { 3764, 0xc109 }, { 3769, 0x8800 }, { 3771, 0xd128 }, { 3777, 0xe404 },
  /* 0x8000 */
  { 3782, 0xe580 }, { 3788, 0xe05a }, { 3795, 0x5051 }, { 3800, 0x56b1 },
  { 3808, 0x0011 }, { 3810, 0x0000 }, { 3810, 0x2051 }, { 3814, 0x0022 },
  { 3816, 0x4102 }, { 3819, 0x5000 }, { 3821, 0x08c0 }, { 3824, 0x0300 },
  { 3826, 0xa100 }, { 3829, 0x01b4 }, { 3834, 0x6001 }, { 3837, 0x464d },
  /* 0x8100 */
  { 3844, 0x0808 }, { 3846, 0x51c0 }, { 3851, 0x1091 }, { 3855, 0x1421 },
  { 3859, 0x14a0 }, { 3863, 0x0084 }, { 3865, 0xa383 }, { 3872, 0x0080 },
  { 3873, 0x4872 }, { 3879, 0x4941 }, { 3884, 0x4004 }, { 3886, 0x0814 },
  { 3889, 0xcc28 }, { 3895, 0x68a0 }, { 3900, 0x1812 }, { 3904, 0xa367 },
  /* 0x8200 */
  { 3913, 0x8009 }, { 3916, 0x2618 }, { 3921, 0x0106 }, { 3924, 0x0414 },
  { 3927, 0xc878 }, { 3934, 0x1042 }, { 3937, 0x2089 }, { 3941, 0xa810 },
  { 3945, 0x469b }, { 3953, 0x0d52 }, { 3959, 0x479b }, { 3968, 0xd495 },
  { 3976, 0x0040 }, { 3977, 0x0421 }, { 3980, 0xa515 }, { 3987, 0x60c0 },
  /* 0x8300 */
  { 3991, 0x0d83 }, { 3997, 0xe800 }, { 4001, 0x7006 }, { 4006, 0x3489 },
  { 4012, 0x609c }, { 4018, 0x00fa }, { 4024, 0x0000 }, { 4024, 0xa101 },
  { 4028, 0x2055 }, { 4033, 0x3b34 }, { 4041, 0x32c0 }, { 4046, 0xc000 },
  { 4048, 0x8281 }, { 4052, 0x2013 }, { 4056, 0x0500 }, { 4058, 0x1340 },
  /* 0x8400 */
  { 4062, 0x8442 }, { 4066, 0x0222 }, { 4069, 0x8000 }, { 4070, 0x0200 },
  { 4071, 0xa5a0 }, { 4077, 0x1746 }, { 4084, 0x04b1 }, { 4089, 0x3159 },
  { 4096, 0x0022 }, { 4098, 0x402c }, { 4102, 0x8740 }, { 4107, 0x6412 },
  { 4112, 0x9185 }, { 4118, 0x1008 }, { 4120, 0x8480 }, { 4123, 0x2c87 },
  /* 0x8500 */
  { 4130, 0x508c }, { 4135, 0x5001 }, { 4138, 0x8cbc }, { 4146, 0x805c },
  { 4151, 0x8040 }, { 4153, 0xf24f }, { 4163, 0x8817 }, { 4169, 0xae00 },
  { 4174, 0x9a62 }, { 4181, 0xa108 }, { 4185, 0x20a5 }, { 4190, 0xf1d0 },
  { 4198, 0x4c84 }, { 4203, 0x8500 }, { 4206, 0x2141 }, { 4210, 0x9048 },
  /* 0x8600 */
  { 4214, 0x6031 }, { 4219, 0x4b07 }, { 4226, 0x0282 }, { 4229, 0x3540 },
  { 4234, 0x0047 }, { 4238, 0x23cc }, { 4245, 0x921f }, { 4253, 0x04e0 },
  { 4257, 0x2100 }, { 4259, 0x1542 }, { 4264, 0x21c2 }, { 4269, 0x83ba },
  { 4277, 0x002b }, { 4281, 0x14a6 }, { 4287, 0x00a9 }, { 4291, 0x3400 },
  /* 0x8700 */
  { 4294, 0xc8b0 }, { 4300, 0xc219 }, { 4306, 0xc10a }, { 4311, 0x7606 },
  { 4318, 0x2029 }, { 4322, 0x2100 }, { 4324, 0x8032 }, { 4328, 0x0806 },
  { 4331, 0x1bf8 }, { 4340, 0x43a9 }, { 4347, 0x7089 }, { 4353, 0xc022 },
  { 4357, 0x4702 }, { 4362, 0x9660 }, { 4368, 0x2c1c }, { 4374, 0x850a },
  /* 0x8800 */
  { 4379, 0x0e4a }, { 4385, 0xdf1d }, { 4396, 0x6100 }, { 4399, 0x1425 },
  { 4404, 0x4f2a }, { 4412, 0x9562 }, { 4419, 0x0211 }, { 4422, 0x0a02 },
  { 4425, 0x0001 }, { 4426, 0x9d00 }, { 4431, 0x0501 }, { 4434, 0x6400 },
  { 4437, 0x7c01 }, { 4443, 0x480e }, { 4448, 0x8080 }, { 4450, 0x00a3 },
  /* 0x8900 */
  { 4454, 0xe042 }, { 4459, 0x1760 }, { 4465, 0x01c1 }, { 4469, 0x4627 },
  { 4476, 0x8265 }, { 4482, 0x1c84 }, { 4487, 0x480e }, { 4492, 0x3c29 },
  { 4499, 0x2200 }, { 4501, 0x9831 }, { 4507, 0x0021 }, { 4509, 0x10f1 },
  { 4515, 0x0000 }, { 4515, 0x01f0 }, { 4520, 0x2a20 }, { 4524, 0xa24a },
  /* 0x8a00 */
  { 4530, 0x80b0 }, { 4534, 0x4036 }, { 4539, 0x9855 }, { 4546, 0x60a0 },
  { 4550, 0x62a9 }, { 4557, 0x31c8 }, { 4563, 0x00a2 }, { 4566, 0xcee0 },
  { 4574, 0x8849 }, { 4579, 0x82c5 }, { 4585, 0xc280 }, { 4589, 0x48c8 },
  { 4594, 0x0748 }, { 4599, 0xa0ba }, { 4606, 0x1000 }, { 4607, 0x9071 },
  /* 0x8b00 */
  { 4613, 0x0c60 }, { 4617, 0xd002 }, { 4621, 0x2000 }, { 4622, 0x1081 },
  { 4625, 0x217c }, { 4632, 0x421c }, { 4637, 0x2008 }, { 4639, 0x5340 },
  { 4644, 0xa832 }, { 4650, 0xd030 }, { 4655, 0x0000 }, { 4655, 0x0000 },
  { 4655, 0x0000 }, { 4655, 0x0000 }, { 4655, 0x0000 }, { 4655, 0x0000 },
  /* 0x8c00 */
  { 4655, 0x0000 }, { 4655, 0x0000 }, { 4655, 0x0000 }, { 4655, 0x6300 },
  { 4659, 0x8aa0 }, { 4664, 0x2b9a }, { 4672, 0x2358 }, { 4678, 0x4868 },
  { 4683, 0x08c0 }, { 4686, 0x1a0d }, { 4692, 0x0010 }, { 4693, 0x0600 },
  { 4695, 0x8a60 }, { 4700, 0x2260 }, { 4704, 0x9102 }, { 4708, 0xc1a5 },
  /* 0x8d00 */
  { 4715, 0x020a }, { 4718, 0x0884 }, { 4721, 0x0000 }, { 4721, 0x0000 },
  { 4721, 0x0000 }, { 4721, 0x0000 }, { 4721, 0x5220 }, { 4725, 0x8000 },
  { 4726, 0x2114 }, { 4730, 0xc023 }, { 4735, 0x9841 }, { 4740, 0x1aa4 },
  { 4746, 0x45e1 }, { 4753, 0x02b2 }, { 4758, 0x10b0 }, { 4762, 0x2017 },
  /* 0x8e00 */
  { 4767, 0x0872 }, { 4772, 0x0052 }, { 4775, 0x00cf }, { 4781, 0x23ca },
  { 4788, 0xe803 }, { 4794, 0x7810 }, { 4799, 0xb206 }, { 4805, 0x0e03 },
  { 4810, 0x020c }, { 4813, 0x6c25 }, { 4820, 0x6284 }, { 4825, 0x0c28 },
  { 4829, 0x809b }, { 4835, 0x1012 }, { 4838, 0x6100 }, { 4841, 0x0683 },
  /* 0x8f00 */
  { 4846, 0x8185 }, { 4851, 0x41c1 }, { 4856, 0x71ab }, { 4865, 0x04f0 },
  { 4870, 0x808b }, { 4875, 0x613e }, { 4883, 0x0020 }, { 4884, 0x0000 },
  { 4884, 0x0000 }, { 4884, 0x2000 }, { 4885, 0x0073 }, { 4890, 0x4160 },
  { 4894, 0x2c43 }, { 4900, 0x002d }, { 4904, 0x4119 }, { 4909, 0x4862 },
  /* 0x9000 */
  { 4914, 0x1114 }, { 4918, 0x0900 }, { 4920, 0xb700 }, { 4926, 0x8098 },
  { 4930, 0x1018 }, { 4933, 0x2800 }, { 4935, 0x10c4 }, { 4939, 0x0211 },
  { 4942, 0x5920 }, { 4947, 0x0ba1 }, { 4953, 0x0027 }, { 4957, 0x605d },
  { 4964, 0x11b8 }, { 4970, 0xb3a4 }, { 4978, 0x8820 }, { 4981, 0xc051 },
  /* 0x9100 */
  { 4986, 0x2171 }, { 4992, 0x55d1 }, { 5000, 0xc2ad }, { 5008, 0x36d2 },
  { 5016, 0x8188 }, { 5020, 0x0e88 }, { 5025, 0x2092 }, { 5029, 0x0e10 },
  { 5033, 0x446a }, { 5039, 0x413a }, { 5045, 0x7142 }, { 5051, 0xb84f },
  { 5060, 0x002c }, { 5063, 0x4698 }, { 5069, 0xf630 }, { 5077, 0x2a83 },
  /* 0x9200 */
  { 5083, 0x16f3 }, { 5092, 0x314d }, { 5099, 0xc178 }, { 5106, 0x5769 },
  { 5115, 0xe4cd }, { 5124, 0x3302 }, { 5129, 0xc3a3 }, { 5137, 0xbbe1 },
  { 5147, 0x6700 }, { 5152, 0x8284 }, { 5156, 0x89b1 }, { 5163, 0xbd44 },
  { 5171, 0x79ef }, { 5183, 0xb3a9 }, { 5192, 0x51ab }, { 5200, 0x8a01 },
  /* 0x9300 */
  { 5204, 0x2105 }, { 5208, 0xf032 }, { 5215, 0x06b2 }, { 5221, 0x00d8 },
  { 5225, 0x0380 }, { 5228, 0x45a7 }, { 5236, 0xa6b0 }, { 5243, 0xa45b },
  { 5251, 0xad07 }, { 5259, 0x4924 }, { 5264, 0x0b5a }, { 5271, 0x0470 },
  { 5275, 0x3ef2 }, { 5285, 0xd208 }, { 5290, 0x00c4 }, { 5293, 0x2f80 },
  /* 0x9400 */
  { 5299, 0xe316 }, { 5307, 0x80e0 }, { 5311, 0xc000 }, { 5313, 0xa81e },
  { 5320, 0x1528 }, { 5325, 0x9220 }, { 5329, 0xe90a }, { 5336, 0x0006 },
  { 5338, 0x0018 }, { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 },
  { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 },
  /* 0x9500 */
  { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 },
  { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x0000 }, { 5340, 0x4300 },
  { 5343, 0x7110 }, { 5348, 0xe000 }, { 5351, 0x1a42 }, { 5356, 0xa450 },
  { 5361, 0x0b40 }, { 5365, 0xe60f }, { 5374, 0x0051 }, { 5377, 0x0000 },
  /* 0x9600 */
  { 5377, 0x0000 }, { 5377, 0x6000 }, { 5379, 0x1074 }, { 5384, 0x378a },
  { 5392, 0x0002 }, { 5393, 0x01d4 }, { 5398, 0x4002 }, { 5400, 0xd810 },
  { 5405, 0x021e }, { 5410, 0xa442 }, { 5415, 0xc270 }, { 5421, 0x0408 },
  { 5423, 0x0400 }, { 5424, 0xe504 }, { 5430, 0x8200 }, { 5432, 0x0402 },
  /* 0x9700 */
  { 5434, 0x022c }, { 5438, 0x2c00 }, { 5441, 0x010e }, { 5445, 0x000a },
  { 5447, 0xc40a }, { 5452, 0x0da0 }, { 5457, 0x4488 }, { 5461, 0xa9c8 },
  { 5468, 0x0201 }, { 5470, 0xc6e0 }, { 5477, 0x5004 }, { 5480, 0xd766 },
  { 5490, 0x76b2 }, { 5499, 0x6b93 }, { 5508, 0x8013 }, { 5512, 0x0592 },
  /* 0x9800 */
  { 5517, 0x6480 }, { 5521, 0x5250 }, { 5526, 0xc869 }, { 5533, 0x402d },
  { 5538, 0x0490 }, { 5541, 0x06ce }, { 5548, 0x146c }, { 5554, 0x0000 },
  { 5554, 0x0000 }, { 5554, 0x0000 }, { 5554, 0x6800 }, { 5557, 0x8d91 },
  { 5564, 0x1124 }, { 5568, 0x0000 }, { 5568, 0x04ea }, { 5574, 0x0048 },
  /* 0x9900 */
  { 5576, 0x0184 }, { 5579, 0x9ce2 }, { 5587, 0x08c4 }, { 5591, 0x1e3e },
  { 5600, 0x61c3 }, { 5607, 0xdb10 }, { 5614, 0x0001 }, { 5615, 0x0000 },
  { 5615, 0x0000 }, { 5615, 0xa800 }, { 5618, 0x0040 }, { 5619, 0xa627 },
  { 5627, 0x0208 }, { 5629, 0x5618 }, { 5635, 0x1c80 }, { 5639, 0x6231 },
  /* 0x9a00 */
  { 5645, 0x181c }, { 5650, 0x4043 }, { 5654, 0x609d }, { 5661, 0x0168 },
  { 5665, 0x5c92 }, { 5672, 0x2052 }, { 5676, 0x0000 }, { 5676, 0x0000 },
  { 5676, 0x0000 }, { 5676, 0x0000 }, { 5676, 0xd400 }, { 5680, 0xca74 },
  { 5688, 0x414a }, { 5693, 0x18e5 }, { 5700, 0x12b1 }, { 5706, 0xa62c },
  /* 0x9b00 */
  { 5713, 0x7b3f }, { 5725, 0x1a45 }, { 5731, 0x2841 }, { 5735, 0x26b8 },
  { 5742, 0x1900 }, { 5745, 0x48e0 }, { 5750, 0x7d6a }, { 5760, 0x83a8 },
  { 5766, 0xaef1 }, { 5776, 0x6411 }, { 5781, 0x12c0 }, { 5785, 0xd987 },
  { 5794, 0x4182 }, { 5798, 0xa181 }, { 5803, 0x8ca0 }, { 5808, 0xa788 },
  /* 0x9c00 */
  { 5815, 0x8805 }, { 5819, 0x5742 }, { 5826, 0x07cc }, { 5833, 0x20e2 },
  { 5838, 0xc63a }, { 5846, 0xf959 }, { 5856, 0x4f08 }, { 5862, 0x08a5 },
  { 5867, 0x0000 }, { 5867, 0x0000 }, { 5867, 0x0000 }, { 5867, 0x0000 },
  { 5867, 0x0000 }, { 5867, 0x0000 }, { 5867, 0x0040 }, { 5868, 0x0284 },
  /* 0x9d00 */
  { 5871, 0x0804 }, { 5873, 0x7182 }, { 5879, 0x8000 }, { 5880, 0x341d },
  { 5887, 0x04ac }, { 5892, 0x8018 }, { 5895, 0x0e2c }, { 5901, 0x58c1 },
  { 5907, 0x6458 }, { 5913, 0x01ec }, { 5919, 0x5402 }, { 5923, 0x9222 },
  { 5928, 0x0688 }, { 5932, 0xc4f0 }, { 5939, 0x4aa1 }, { 5945, 0x4019 },
  /* 0x9e00 */
  { 5949, 0x4484 }, { 5953, 0x3267 }, { 5961, 0x0000 }, { 5961, 0x0000 },
  { 5961, 0x0000 }, { 5961, 0x0000 }, { 5961, 0x0000 }, { 5961, 0x1c00 },
  { 5964, 0xc0bd }, { 5972, 0x4940 }, { 5976, 0xd110 }, { 5981, 0x0039 },
  { 5985, 0x0940 }, { 5988, 0x8020 }, { 5990, 0x7090 }, { 5995, 0x8127 },
  /* 0x9f00 */
  { 6001, 0x820c }, { 6005, 0x8ed7 }, { 6015, 0x8c44 }, { 6020, 0xb696 },
  { 6029, 0x00fa }, { 6035, 0x65e8 }, { 6043, 0xe300 }, { 6048, 0x242b },
  { 6054, 0x8000 }, { 6055, 0x40d7 }, { 6062, 0x002e }
};

static const aciConvSummary16 jisx0212_uni2indx_pageff[ /*6*/ ] = {
  /* 0xff00 */
  { 6066, 0x0000 }, { 6066, 0x0000 }, { 6066, 0x0000 }, { 6066, 0x0000 },
  { 6066, 0x0000 }, { 6066, 0x4000 }
};

ACP_EXPORT acp_sint32_t aciConvConvertMbToWc4Jisx0212( void   * aSrc,
                                                       acp_sint32_t     aSrcRemain,
                                                       acp_sint32_t   * aSrcAdvance,
                                                       void   * aDest,
                                                       acp_sint32_t     aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      (EUCJP, SHIFT-JIS) ==> UTF16  Ǵ ȯ
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t   * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_sint32_t      sRet;
    acp_uint16_t    wc;

    aDestRemain = 0;
    
    if( (sSrcCharPtr[0] == 0x22) || 
        ((sSrcCharPtr[0] >= 0x26) && (sSrcCharPtr[0] <= 0x27)) || 
        ((sSrcCharPtr[0] >= 0x29) && (sSrcCharPtr[0] <= 0x2b)) || 
        ((sSrcCharPtr[0] >= 0x30) && (sSrcCharPtr[0] <= 0x6d)) )
    {
        if( aSrcRemain >= 2 )
        {
            if( (sSrcCharPtr[1] >= 0x21) && (sSrcCharPtr[1] < 0x7f) )
            {
                acp_uint32_t i = 94 * (sSrcCharPtr[0] - 0x21) + (sSrcCharPtr[1] - 0x21);
                wc = 0xfffd;

                if (i < 470)
                {
                    if (i < 175)
                    {
                        wc = jisx0212_2uni_page22[i-94] ^ JISX0212_XOR_VALUE;
                    }
                    else
                    {
                        /*  Nothing to do */
                    }
                }
                else if (i < 752)
                {
                    if (i < 658)
                    {
                        wc = jisx0212_2uni_page26[i-470] ^ JISX0212_XOR_VALUE;
                    }
                    else
                    {
                        /*  Nothing to do */
                    }
                }
                else if (i < 1410)
                {
                    if (i < 1027)
                    {
                        wc = jisx0212_2uni_page29[i-752] ^ JISX0212_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else
                {
                    if (i < 7211)
                    {
                        wc = jisx0212_2uni_page30[i-1410] ^ JISX0212_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }

                if(wc != 0xfffd)
                {
                    ACICONV_WC_TO_UTF16BE( aDest, wc );
                    
                    sRet = 2;
                    *aSrcAdvance = 2;
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILSEQ;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_TOOFEW;
            *aSrcAdvance = aSrcRemain;
        }
    }
    else
    {
        sRet = ACICONV_RET_ILSEQ;
        *aSrcAdvance = 1;
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvConvertWcToMb4Jisx0212( void   * aSrc,
                                                       acp_sint32_t     aSrcRemain,
                                                       acp_sint32_t   * aSrcAdvance,
                                                       void   * aDest,
                                                       acp_sint32_t     aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      (EUCJP, SHIFT-JIS) <== UTF16BE  Ǵ ȯ
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16   * sSummary = NULL;
    acp_uint16_t        sUsed;
    acp_uint8_t       * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_sint32_t          sRet;
    acp_uint16_t        c;
    acp_uint32_t          i;
    acp_uint16_t        wc;

    aSrcRemain = 0;

    ACICONV_UTF16BE_TO_WC( wc, aSrc );
    
    if (aDestRemain >= 2)
    {
        if (wc < 0x0460)
        {
            sSummary = &jisx0212_uni2indx_page00[(wc>>4)];
        }
        else if (wc >= 0x2100 && wc < 0x2130)
        {
            sSummary = &jisx0212_uni2indx_page21[(wc>>4)-0x210];
        }
        else if (wc >= 0x4e00 && wc < 0x9fb0)
        {
            sSummary = &jisx0212_uni2indx_page4e[(wc>>4)-0x4e0];
        }
        else if (wc >= 0xff00 && wc < 0xff60)
        {
            sSummary = &jisx0212_uni2indx_pageff[(wc>>4)-0xff0];
        }
        else
        {
        }

        if (sSummary != NULL) 
        {
            sUsed = sSummary->used;
            i = wc & 0x0f;

            if (sUsed & ((acp_uint16_t) 1 << i)) 
            {
                /* Keep in `sUsed' only the bits 0..i-1. */
                sUsed &= ((acp_uint16_t) 1 << i) - 1;

                /* Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                sUsed = (sUsed & 0x00ff) + (sUsed >> 8);

                c = jisx0212_2charset[sSummary->indx + sUsed] ^ JISX0212_XOR_VALUE;

                sDestCharPtr[0] = (c >> 8); 
                sDestCharPtr[1] = (c & 0xff);

                sRet = 2;
                *aSrcAdvance = 2;
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_ILUNI;
            *aSrcAdvance = 2;
        }
    }
    else
    {
        sRet = ACICONV_RET_TOOSMALL;
        *aSrcAdvance = 2;
    }

    return sRet;
}
 
