/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvKsc5601.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvKsc5601.h>

static const acp_uint16_t ksc5601_2uni_page21[ /*1115*/ ] = {
  /* 0x21 */
  0x340d, 0x340c, 0x340f, 0x04ba, 0x2428, 0x242b, 0x04a5, 0x340e,
  0x04a0, 0x2418, 0x2628, 0xfb31, 0x2631, 0x2415, 0x2414, 0x2411,
  0x2410, 0x3419, 0x3418, 0x3405, 0x3404, 0x3407, 0x3406, 0x3401,
  0x3400, 0x3403, 0x3402, 0x341d, 0x341c, 0x04bc, 0x04da, 0x04fa,
  0x266d, 0x2669, 0x2668, 0x2613, 0x2639, 0x04bd, 0x243f, 0x243e,
  0x250e, 0x2526, 0xfbed, 0xfbec, 0xfbe8, 0x224f, 0x224d, 0x262d,
  0x26a8, 0x271f, 0x260f, 0x260a, 0x266c, 0x265f, 0x04aa, 0x2436,
  0x220b, 0x2208, 0x21c6, 0x21c2, 0x21c3, 0x21ca, 0x21cb, 0x21ac,
  0x21ad, 0x21be, 0x21bf, 0x21b0, 0x21b1, 0x259f, 0x259d, 0x259c,
  0x259e, 0x2599, 0x341e, 0x2667, 0x2666, 0x2617, 0x2630, 0x2610,
  0x2638, 0x2626, 0x2621, 0x2605, 0x2606, 0x268b, 0x268a, 0x268f,
  0x268e, 0x2627, 0x2624, 0x262a, 0x2625, 0xfbef,
  /* 0x22 */
  0x25df, 0x25d9, 0x260d, 0x260e, 0x04b9, 0xfb53, 0x06ca, 0x06d5,
  0x06d0, 0x06d7, 0x06d4, 0x04b5, 0x06d6, 0x04ac, 0x04b2, 0x06dd,
  0x2623, 0x261c, 0x2602, 0x04a9, 0x2504, 0x243d, 0x21cc, 0x21cd,
  0x21ba, 0x21bb, 0x2269, 0x226d, 0x226c, 0x2268, 0x226a, 0x226e,
  0x2694, 0x21c5, 0x21ae, 0x21dd, 0x21dc, 0x219f, 0x21a9, 0x21a8,
  0x21a5, 0x21aa, 0x21ab, 0x21a4, 0x2265, 0x2202, 0x2203, 0x2211,
  0x2213, 0x04bb, 0x242d, 0x242c, 0x2598, 0x259a, 0x2594, 0x259b,
  0x2595, 0x2260, 0x2264, 0x2267, 0x2261, 0x3672, 0x3611, 0x251b,
  0x37ca, 0x252f, 0x37cf, 0x37d5, 0x252c, 0x24a1, 0x04a3, 0x3673,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x23 */
  0xfb0c, 0xfb0f, 0xfb0e, 0xfb09, 0xfb08, 0xfb0b, 0xfb0a, 0xfb05,
  0xfb04, 0xfb07, 0xfb06, 0xfb01, 0xfb00, 0xfb03, 0xfb02, 0xfb1d,
  0xfb1c, 0xfb1f, 0xfb1e, 0xfb19, 0xfb18, 0xfb1b, 0xfb1a, 0xfb15,
  0xfb14, 0xfb17, 0xfb16, 0xfb11, 0xfb10, 0xfb13, 0xfb12, 0xfb2d,
  0xfb2c, 0xfb2f, 0xfb2e, 0xfb29, 0xfb28, 0xfb2b, 0xfb2a, 0xfb25,
  0xfb24, 0xfb27, 0xfb26, 0xfb21, 0xfb20, 0xfb23, 0xfb22, 0xfb3d,
  0xfb3c, 0xfb3f, 0xfb3e, 0xfb39, 0xfb38, 0xfb3b, 0xfb3a, 0xfb35,
  0xfb34, 0xfb37, 0xfb36, 0xfbeb, 0xfb30, 0xfb33, 0xfb32, 0xfb4d,
  0xfb4c, 0xfb4f, 0xfb4e, 0xfb49, 0xfb48, 0xfb4b, 0xfb4a, 0xfb45,
  0xfb44, 0xfb47, 0xfb46, 0xfb41, 0xfb40, 0xfb43, 0xfb42, 0xfb5d,
  0xfb5c, 0xfb5f, 0xfb5e, 0xfb59, 0xfb58, 0xfb5b, 0xfb5a, 0xfb55,
  0xfb54, 0xfb57, 0xfb56, 0xfb51, 0xfb50, 0xfbee,
  /* 0x24 */
  0x353c, 0x353f, 0x353e, 0x3539, 0x3538, 0x353b, 0x353a, 0x3535,
  0x3534, 0x3537, 0x3536, 0x3531, 0x3530, 0x3533, 0x3532, 0x354d,
  0x354c, 0x354f, 0x354e, 0x3549, 0x3548, 0x354b, 0x354a, 0x3545,
  0x3544, 0x3547, 0x3546, 0x3541, 0x3540, 0x3543, 0x3542, 0x355d,
  0x355c, 0x355f, 0x355e, 0x3559, 0x3558, 0x355b, 0x355a, 0x3555,
  0x3554, 0x3557, 0x3556, 0x3551, 0x3550, 0x3553, 0x3552, 0x356d,
  0x356c, 0x356f, 0x356e, 0x3569, 0x3568, 0x356b, 0x356a, 0x3565,
  0x3564, 0x3567, 0x3566, 0x3561, 0x3560, 0x3563, 0x3562, 0x357d,
  0x357c, 0x357f, 0x357e, 0x3579, 0x3578, 0x357b, 0x357a, 0x3575,
  0x3574, 0x3577, 0x3576, 0x3571, 0x3570, 0x3573, 0x3572, 0x358d,
  0x358c, 0x358f, 0x358e, 0x3589, 0x3588, 0x358b, 0x358a, 0x3585,
  0x3584, 0x3587, 0x3586, 0x3581, 0x3580, 0x3583,
  /* 0x25 */
  0x257d, 0x257c, 0x257f, 0x257e, 0x2579, 0x2578, 0x257b, 0x257a,
  0x2575, 0x2574, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0x256d,
  0x256c, 0x256f, 0x256e, 0x2569, 0x2568, 0x256b, 0x256a, 0x2565,
  0x2564, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x079c, 0x079f, 0x079e, 0x0799, 0x0798, 0x079b, 0x079a, 0x0795,
  0x0794, 0x0797, 0x0796, 0x0791, 0x0790, 0x0793, 0x0792, 0x07ad,
  0x07ac, 0x07ae, 0x07a9, 0x07a8, 0x07ab, 0x07aa, 0x07a5, 0x07a4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x07bc, 0x07bf, 0x07be, 0x07b9, 0x07b8, 0x07bb, 0x07ba, 0x07b5,
  0x07b4, 0x07b7, 0x07b6, 0x07b1, 0x07b0, 0x07b3, 0x07b2, 0x07cd,
  0x07cc, 0x07ce, 0x07c9, 0x07c8, 0x07cb, 0x07ca, 0x07c5, 0x07c4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x26 */
  0x210d, 0x210f, 0x2101, 0x211d, 0x2115, 0x2119, 0x2111, 0x2121,
  0x2129, 0x2139, 0x2131, 0x210c, 0x210e, 0x2102, 0x211e, 0x2116,
  0x211a, 0x212e, 0x213e, 0x2126, 0x2136, 0x2146, 0x212d, 0x2122,
  0x2125, 0x213a, 0x2132, 0x2110, 0x213d, 0x2128, 0x2135, 0x214f,
  0x211f, 0x211c, 0x2117, 0x2114, 0x211b, 0x2118, 0x2103, 0x2100,
  0x2113, 0x2112, 0x212c, 0x212f, 0x212b, 0x212a, 0x2124, 0x2127,
  0x2120, 0x2123, 0x213c, 0x213f, 0x2138, 0x213b, 0x2134, 0x2137,
  0x2130, 0x2133, 0x214d, 0x214c, 0x214e, 0x2149, 0x2148, 0x214b,
  0x214a, 0x2145, 0x2144, 0x2147, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x27 */
  0x3798, 0x379b, 0x379a, 0x251e, 0x3795, 0x37c9, 0x37ae, 0x37a9,
  0x37a8, 0x37ab, 0x3794, 0x3797, 0x3796, 0x3791, 0x3790, 0x3793,
  0x3792, 0x37ad, 0x37ac, 0x37af, 0x37c7, 0x3780, 0x3783, 0x3782,
  0x37c2, 0x3785, 0x3784, 0x37c5, 0x37aa, 0x37a5, 0x37bd, 0x37bc,
  0x37bf, 0x37be, 0x37b9, 0x37b8, 0x37bb, 0x37ba, 0x37b5, 0x37b4,
  0x378d, 0x378c, 0x378f, 0x378e, 0x3789, 0x37b7, 0x37b6, 0x37b1,
  0x37b0, 0x37b3, 0x37b2, 0x379d, 0x379c, 0x379f, 0x379e, 0x3799,
  0x252b, 0x37cd, 0x37cc, 0x3787, 0x3786, 0x3781, 0x37db, 0x37c8,
  0x37a0, 0x37a3, 0x37a2, 0x37d6, 0x37a4, 0x37a7, 0x37a6, 0x37a1,
  0x37d0, 0x37dd, 0x37de, 0x37ce, 0x37c4, 0x37d1, 0x37cb, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x28 */
  0x04cb, 0x04dd, 0x04a7, 0x052b, 0xfbf0, 0x053f, 0xfbf0, 0x0532,
  0x054c, 0x04d5, 0x055f, 0x04b7, 0x04d3, 0x056b, 0x0547, 0xfbf0,
  0x366d, 0x366c, 0x366f, 0x366e, 0x3669, 0x3668, 0x366b, 0x366a,
  0x3665, 0x3664, 0x3667, 0x3666, 0x3661, 0x3660, 0x3663, 0x3662,
  0x367d, 0x367c, 0x367f, 0x367e, 0x3679, 0x3678, 0x367b, 0x367a,
  0x3675, 0x3674, 0x3677, 0x3676, 0x20dd, 0x20dc, 0x20df, 0x20de,
  0x20d9, 0x20d8, 0x20db, 0x20da, 0x20d5, 0x20d4, 0x20d7, 0x20d6,
  0x20d1, 0x20d0, 0x20d3, 0x20d2, 0x20ed, 0x20ec, 0x20ef, 0x20ee,
  0x20e9, 0x20e8, 0x20eb, 0x20ea, 0x20e5, 0x20e4, 0x206d, 0x206c,
  0x206f, 0x206e, 0x2069, 0x2068, 0x206b, 0x206a, 0x2065, 0x2064,
  0x2067, 0x2066, 0x2061, 0x2060, 0x2063, 0x04b0, 0x255e, 0x2559,
  0x04b1, 0x04b3, 0x2556, 0x2551, 0x2550, 0x2553,
  /* 0x29 */
  0x04eb, 0x051c, 0x04fd, 0x052a, 0x053c, 0x053e, 0x0535, 0x054d,
  0x054f, 0x04f5, 0x055e, 0x04d2, 0x04f3, 0x056a, 0x0546, 0x0544,
  0x360d, 0x360c, 0x360f, 0x360e, 0x3609, 0x3608, 0x360b, 0x360a,
  0x3605, 0x3604, 0x3607, 0x3606, 0x3601, 0x3600, 0x3603, 0x3602,
  0x361d, 0x361c, 0x361f, 0x361e, 0x3619, 0x3618, 0x361b, 0x361a,
  0x3615, 0x3614, 0x3617, 0x3616, 0x2091, 0x2090, 0x2093, 0x2092,
  0x20ad, 0x20ac, 0x20af, 0x20ae, 0x20a9, 0x20a8, 0x20ab, 0x20aa,
  0x20a5, 0x20a4, 0x20a7, 0x20a6, 0x20a1, 0x20a0, 0x20a3, 0x20a2,
  0x20bd, 0x20bc, 0x20bf, 0x20be, 0x20b9, 0x20b8, 0x2079, 0x2078,
  0x207b, 0x207a, 0x2075, 0x2074, 0x2077, 0x2076, 0x2071, 0x2070,
  0x2073, 0x2072, 0x208d, 0x208c, 0x208f, 0x04b4, 0x04bf, 0x04be,
  0x2479, 0x2472, 0x248c, 0x248f, 0x248e, 0x2489,
  /* 0x2a */
  0x344c, 0x344f, 0x344e, 0x3449, 0x3448, 0x344b, 0x344a, 0x3445,
  0x3444, 0x3447, 0x3446, 0x3441, 0x3440, 0x3443, 0x3442, 0x345d,
  0x345c, 0x345f, 0x345e, 0x3459, 0x3458, 0x345b, 0x345a, 0x3455,
  0x3454, 0x3457, 0x3456, 0x3451, 0x3450, 0x3453, 0x3452, 0x346d,
  0x346c, 0x346f, 0x346e, 0x3469, 0x3468, 0x346b, 0x346a, 0x3465,
  0x3464, 0x3467, 0x3466, 0x3461, 0x3460, 0x3463, 0x3462, 0x347d,
  0x347c, 0x347f, 0x347e, 0x3479, 0x3478, 0x347b, 0x347a, 0x3475,
  0x3474, 0x3477, 0x3476, 0x3471, 0x3470, 0x3473, 0x3472, 0x348d,
  0x348c, 0x348f, 0x348e, 0x3489, 0x3488, 0x348b, 0x348a, 0x3485,
  0x3484, 0x3487, 0x3486, 0x3481, 0x3480, 0x3483, 0x3482, 0x349d,
  0x349c, 0x349f, 0x349e, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x2b */
  0x34ac, 0x34af, 0x34ae, 0x34a9, 0x34a8, 0x34ab, 0x34aa, 0x34a5,
  0x34a4, 0x34a7, 0x34a6, 0x34a1, 0x34a0, 0x34a3, 0x34a2, 0x34bd,
  0x34bc, 0x34bf, 0x34be, 0x34b9, 0x34b8, 0x34bb, 0x34ba, 0x34b5,
  0x34b4, 0x34b7, 0x34b6, 0x34b1, 0x34b0, 0x34b3, 0x34b2, 0x34cd,
  0x34cc, 0x34cf, 0x34ce, 0x34c9, 0x34c8, 0x34cb, 0x34ca, 0x34c5,
  0x34c4, 0x34c7, 0x34c6, 0x34c1, 0x34c0, 0x34c3, 0x34c2, 0x34dd,
  0x34dc, 0x34df, 0x34de, 0x34d9, 0x34d8, 0x34db, 0x34da, 0x34d5,
  0x34d4, 0x34d7, 0x34d6, 0x34d1, 0x34d0, 0x34d3, 0x34d2, 0x34ed,
  0x34ec, 0x34ef, 0x34ee, 0x34e9, 0x34e8, 0x34eb, 0x34ea, 0x34e5,
  0x34e4, 0x34e7, 0x34e6, 0x34e1, 0x34e0, 0x34e3, 0x34e2, 0x34fd,
  0x34fc, 0x34ff, 0x34fe, 0x34f9, 0x34f8, 0x34fb, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x2c */
  0x001d, 0x001c, 0x001f, 0x001e, 0x0019, 0x0018, 0x000c, 0x001b,
  0x001a, 0x0015, 0x0014, 0x0017, 0x0016, 0x0011, 0x0010, 0x0013,
  0x0012, 0x002d, 0x002c, 0x002f, 0x002e, 0x0029, 0x0028, 0x002b,
  0x002a, 0x0025, 0x0024, 0x0027, 0x0026, 0x0021, 0x0020, 0x0023,
  0x0022, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x003d, 0x003c, 0x003f, 0x003e, 0x0039, 0x0038, 0x005c, 0x003b,
  0x003a, 0x0035, 0x0034, 0x0037, 0x0036, 0x0031, 0x0030, 0x0033,
  0x0032, 0x004d, 0x004c, 0x004f, 0x004e, 0x0049, 0x0048, 0x004b,
  0x004a, 0x0045, 0x0044, 0x0047, 0x0046, 0x0041, 0x0040, 0x0043,
  0x0042
};

static const acp_uint16_t ksc5601_2uni_page30[ /*2350*/ ] = {
  /* 0x30 */
  0xa80d, 0xa80c, 0xa809, 0xa80a, 0xa805, 0xa804, 0xa807, 0xa81d,
  0xa81c, 0xa81f, 0xa81e, 0xa819, 0xa818, 0xa81b, 0xa81a, 0xa814,
  0xa817, 0xa816, 0xa811, 0xa810, 0xa82d, 0xa829, 0xa821, 0xa820,
  0xa822, 0xa83d, 0xa83c, 0xa835, 0xa834, 0xa831, 0xa84d, 0xa846,
  0xa840, 0xa859, 0xa855, 0xa851, 0xa87d, 0xa87c, 0xa879, 0xa87a,
  0xa875, 0xa877, 0xa88d, 0xa88c, 0xa88e, 0xa889, 0xa888, 0xa88b,
  0xa884, 0xa887, 0xa886, 0xa881, 0xa89d, 0xa899, 0xa891, 0xa890,
  0xa892, 0xa8ad, 0xa8ac, 0xa8a5, 0xa8a4, 0xa8a7, 0xa8a1, 0xa8a2,
  0xa8bd, 0xa8b5, 0xa8b4, 0xa8b6, 0xa8b1, 0xa8b0, 0xa8cc, 0xa8c9,
  0xa8c5, 0xa8c1, 0xa8d8, 0xa8da, 0xa8ed, 0xa8ec, 0xa8e9, 0xa8ea,
  0xa8e5, 0xa8e7, 0xa8e1, 0xa8e2, 0xa8fd, 0xa8fc, 0xa8fe, 0xa8f8,
  0xa8fb, 0xa8f1, 0xa8f0, 0xa90d, 0xa909, 0xa90b,
  /* 0x31 */
  0xa901, 0xa900, 0xa902, 0xa91c, 0xa915, 0xa911, 0xa92d, 0xa924,
  0xa921, 0xa920, 0xa939, 0xa938, 0xa935, 0xa931, 0xa949, 0xa948,
  0xa94a, 0xa944, 0xa95d, 0xa959, 0xa955, 0xa96c, 0xa96e, 0xa961,
  0xa960, 0xa97d, 0xa97e, 0xa979, 0xa978, 0xa97b, 0xa976, 0xa971,
  0xa970, 0xa972, 0xa98c, 0xa98f, 0xa985, 0xa984, 0xa981, 0xa99d,
  0xa991, 0xa990, 0xa9a9, 0xa9ba, 0xa9cd, 0xa9cc, 0xa9c9, 0xa9c5,
  0xa9dd, 0xa9dc, 0xa9de, 0xa9d1, 0xa9ed, 0xa9e9, 0xa9f5, 0xa9f4,
  0xa9f1, 0xa9f2, 0xaa0d, 0xaa0c, 0xaa05, 0xaa04, 0xaa06, 0xaa00,
  0xaa19, 0xaa3d, 0xaa3c, 0xaa39, 0xaa3a, 0xaa35, 0xaa37, 0xaa4d,
  0xaa4c, 0xaa4e, 0xaa48, 0xaa4b, 0xaa47, 0xaa41, 0xaa40, 0xaa43,
  0xaa5d, 0xaa59, 0xaa5b, 0xaa51, 0xaa50, 0xaa52, 0xaa6d, 0xaa6c,
  0xaa68, 0xaa65, 0xaa64, 0xaa61, 0xaa7d, 0xaa75,
  /* 0x32 */
  0xaa74, 0xaa76, 0xaa71, 0xaa70, 0xaa89, 0xaa88, 0xaa81, 0xaab1,
  0xaab0, 0xaab3, 0xaacd, 0xaac9, 0xaac1, 0xaac0, 0xaac2, 0xaadd,
  0xaadc, 0xaad5, 0xaad4, 0xaad1, 0xaae5, 0xaae6, 0xaae0, 0xaaf9,
  0xaaf5, 0xaaf1, 0xab0a, 0xab05, 0xab00, 0xab1d, 0xab21, 0xab20,
  0xab3d, 0xab3f, 0xab39, 0xab31, 0xab30, 0xab32, 0xab4c, 0xab4f,
  0xab4e, 0xab45, 0xab44, 0xab5d, 0xab51, 0xab50, 0xab69, 0xab68,
  0xab74, 0xab8d, 0xab89, 0xab85, 0xab9d, 0xab9c, 0xab98, 0xab91,
  0xabb5, 0xabb4, 0xabb1, 0xabcd, 0xabca, 0xabc5, 0xabc4, 0xabc6,
  0xabc0, 0xabc3, 0xabd9, 0xabd1, 0xabe5, 0xabe4, 0xabfd, 0xabfc,
  0xabf9, 0xabf5, 0xb40d, 0xb40c, 0xb409, 0xb401, 0xb41d, 0xb419,
  0xb411, 0xb410, 0xb425, 0xb449, 0xb448, 0xb445, 0xb447, 0xb441,
  0xb443, 0xb45e, 0xb459, 0xb458, 0xb45a, 0xb454,
  /* 0x33 */
  0xb450, 0xb471, 0xb470, 0xb48d, 0xb489, 0xb481, 0xb480, 0xb482,
  0xb49c, 0xb495, 0xb494, 0xb497, 0xb491, 0xb492, 0xb4ad, 0xb4ac,
  0xb4af, 0xb4a5, 0xb4a4, 0xb4a6, 0xb4a1, 0xb4a0, 0xb4a3, 0xb4a2,
  0xb4bc, 0xb4be, 0xb4b9, 0xb4b8, 0xb4b5, 0xb4b1, 0xb4c9, 0xb4c8,
  0xb4ca, 0xb4c5, 0xb4c4, 0xb4dd, 0xb4dc, 0xb4d9, 0xb4d5, 0xb4ed,
  0xb4e8, 0xb505, 0xb504, 0xb506, 0xb501, 0xb51d, 0xb51f, 0xb51e,
  0xb515, 0xb514, 0xb516, 0xb511, 0xb510, 0xb52e, 0xb529, 0xb528,
  0xb525, 0xb521, 0xb539, 0xb538, 0xb53a, 0xb535, 0xb534, 0xb54d,
  0xb54c, 0xb549, 0xb545, 0xb55d, 0xb55c, 0xb559, 0xb558, 0xb555,
  0xb551, 0xb56d, 0xb575, 0xb574, 0xb571, 0xb58d, 0xb58f, 0xb585,
  0xb584, 0xb586, 0xb580, 0xb59f, 0xb59e, 0xb599, 0xb595, 0xb591,
  0xb5a5, 0xb5c1, 0xb5dd, 0xb5d9, 0xb5d1, 0xb5d0,
  /* 0x34 */
  0xb5d2, 0xb5e5, 0xb5e4, 0xb5e1, 0xb5fd, 0xb5f4, 0xb5f6, 0xb5f0,
  0xb609, 0xb608, 0xb605, 0xb606, 0xb601, 0xb619, 0xb618, 0xb61a,
  0xb614, 0xb62d, 0xb639, 0xb631, 0xb655, 0xb651, 0xb66d, 0xb665,
  0xb664, 0xb679, 0xb678, 0xb671, 0xb689, 0xb688, 0xb684, 0xb69d,
  0xb69c, 0xb699, 0xb695, 0xb694, 0xb697, 0xb6ad, 0xb6ac, 0xb6ae,
  0xb6a8, 0xb6ab, 0xb6a7, 0xb6a1, 0xb6bd, 0xb6b9, 0xb6c5, 0xb6c4,
  0xb6c1, 0xb6dd, 0xb6df, 0xb6d5, 0xb6d4, 0xb6d6, 0xb6d0, 0xb6ef,
  0xb6e9, 0xb6e8, 0xb6eb, 0xb6e5, 0xb6e6, 0xb6e1, 0xb6e0, 0xb6e3,
  0xb6e2, 0xb6fe, 0xb6f9, 0xb6f8, 0xb6fa, 0xb6f5, 0xb6f4, 0xb6f7,
  0xb6f6, 0xb6f2, 0xb70d, 0xb70c, 0xb709, 0xb705, 0xb71d, 0xb71c,
  0xb71e, 0xb719, 0xb718, 0xb711, 0xb759, 0xb758, 0xb75b, 0xb755,
  0xb756, 0xb751, 0xb753, 0xb752, 0xb769, 0xb768,
  /* 0x35 */
  0xb76a, 0xb764, 0xb766, 0xb763, 0xb77d, 0xb77c, 0xb779, 0xb775,
  0xb78d, 0xb78c, 0xb78e, 0xb789, 0xb788, 0xb781, 0xb79d, 0xb799,
  0xb7ad, 0xb7ac, 0xb7a5, 0xb7a1, 0xb7c9, 0xb7c8, 0xb7c5, 0xb7c6,
  0xb7c1, 0xb7c3, 0xb7dd, 0xb7d9, 0xb7d8, 0xb7da, 0xb7d4, 0xb7d6,
  0xb7d0, 0xb7ed, 0xb7e9, 0xb7e5, 0xb7f1, 0xb01d, 0xb015, 0xb011,
  0xb02d, 0xb025, 0xb024, 0xb026, 0xb039, 0xb05d, 0xb05c, 0xb059,
  0xb055, 0xb06d, 0xb06c, 0xb06e, 0xb068, 0xb061, 0xb08d, 0xb085,
  0xb090, 0xb0a9, 0xb0a5, 0xb0a1, 0xb0b8, 0xb0ba, 0xb0b4, 0xb0cd,
  0xb0c9, 0xb0c5, 0xb0dd, 0xb0d8, 0xb0d1, 0xb0d0, 0xb0ed, 0xb0ee,
  0xb0e9, 0xb0eb, 0xb0e1, 0xb0e0, 0xb0e2, 0xb0fc, 0xb0f5, 0xb119,
  0xb118, 0xb115, 0xb116, 0xb111, 0xb129, 0xb128, 0xb12a, 0xb125,
  0xb124, 0xb127, 0xb13d, 0xb13c, 0xb139, 0xb135,
  /* 0x36 */
  0xb14d, 0xb14c, 0xb14e, 0xb149, 0xb148, 0xb146, 0xb141, 0xb140,
  0xb15d, 0xb159, 0xb151, 0xb150, 0xb152, 0xb16d, 0xb16c, 0xb1ad,
  0xb1ac, 0xb1a9, 0xb1a5, 0xb1a7, 0xb1a6, 0xb1bd, 0xb1bc, 0xb1be,
  0xb1b9, 0xb1b8, 0xb1b6, 0xb1b1, 0xb1b0, 0xb1cd, 0xb1c9, 0xb1c1,
  0xb1c0, 0xb1c2, 0xb1dd, 0xb1dc, 0xb1d5, 0xb1e1, 0xb21d, 0xb21c,
  0xb219, 0xb215, 0xb228, 0xb221, 0xb239, 0xb245, 0xb269, 0xb265,
  0xb291, 0xb290, 0xb2ad, 0xb2a9, 0xb2a6, 0xb2a1, 0xb2bc, 0xb2d9,
  0xb2fd, 0xb2f9, 0xb2f5, 0xb30d, 0xb30c, 0xb308, 0xb325, 0xb324,
  0xb321, 0xb322, 0xb33d, 0xb335, 0xb334, 0xb336, 0xb349, 0xb345,
  0xb341, 0xb359, 0xb358, 0xb36d, 0xb369, 0xb365, 0xb37d, 0xb37c,
  0xb37e, 0xb378, 0xb371, 0xb370, 0xb38d, 0xb389, 0xb381, 0xb380,
  0xb382, 0xb39d, 0xb39c, 0xb39f, 0xb39b, 0xb39a,
  /* 0x37 */
  0xb395, 0xb394, 0xb391, 0xb3ad, 0xb3a5, 0xb3a4, 0xb3a6, 0xb3a1,
  0xb3a0, 0xb3b9, 0xb3b8, 0xb3b5, 0xb3ca, 0xb3c4, 0xb3e1, 0xb3e0,
  0xb3fd, 0xb3f9, 0xb3f1, 0xb3f0, 0xb3f2, 0xbc0d, 0xbc0c, 0xbc0a,
  0xbc05, 0xbc04, 0xbc01, 0xbc1d, 0xbc15, 0xbc14, 0xbc16, 0xbc10,
  0xbc29, 0xbc28, 0xbc25, 0xbc21, 0xbc39, 0xbc38, 0xbc3a, 0xbc35,
  0xbc34, 0xbc4d, 0xbc49, 0xbc5c, 0xbc5e, 0xbc51, 0xbc50, 0xbc6d,
  0xbc69, 0xbc61, 0xbc60, 0xbc62, 0xbc7c, 0xbc75, 0xbc71, 0xbc80,
  0xbca5, 0xbcbd, 0xbcb9, 0xbcb5, 0xbccd, 0xbccc, 0xbcce, 0xbcc8,
  0xbcc1, 0xbcdd, 0xbcd9, 0xbcd0, 0xbcd2, 0xbcec, 0xbce5, 0xbce4,
  0xbce1, 0xbcfd, 0xbcf5, 0xbcf4, 0xbcf6, 0xbcf0, 0xbd09, 0xbd15,
  0xbd2d, 0xbd31, 0xbd30, 0xbd4d, 0xbd49, 0xbd41, 0xbd42, 0xbd5c,
  0xbd55, 0xbd54, 0xbd51, 0xbd6d, 0xbd65, 0xbd64,
  /* 0x38 */
  0xbd66, 0xbd60, 0xbd79, 0xbd78, 0xbd75, 0xbd71, 0xbd89, 0xbd88,
  0xbd8a, 0xbd84, 0xbd87, 0xbd80, 0xbd83, 0xbda1, 0xbda0, 0xbdbd,
  0xbdb9, 0xbdb1, 0xbdb0, 0xbdb2, 0xbdcc, 0xbdc5, 0xbdc4, 0xbdc1,
  0xbdc3, 0xbdc2, 0xbddd, 0xbddc, 0xbddf, 0xbdd5, 0xbdd4, 0xbdd6,
  0xbdd0, 0xbdd3, 0xbdec, 0xbdee, 0xbde9, 0xbde8, 0xbde5, 0xbde1,
  0xbdf9, 0xbdf8, 0xbdfa, 0xbdf5, 0xbdf4, 0xbdf7, 0xbe0d, 0xbe0c,
  0xbe05, 0xbe18, 0xbe35, 0xbe34, 0xbe31, 0xbe4d, 0xbe4f, 0xbe45,
  0xbe44, 0xbe46, 0xbe40, 0xbe43, 0xbe5e, 0xbe59, 0xbe58, 0xbe55,
  0xbe51, 0xbe69, 0xbe68, 0xbe6a, 0xbe65, 0xbe64, 0xbe7d, 0xbe7c,
  0xbe79, 0xbe75, 0xbe8e, 0xbe89, 0xbe88, 0xbe8a, 0xbe81, 0xbea5,
  0xbea4, 0xbea6, 0xbea1, 0xbebd, 0xbebf, 0xbeb5, 0xbeb4, 0xbeb6,
  0xbeb0, 0xbec9, 0xbec5, 0xbed5, 0xbed4, 0xbef1,
  /* 0x39 */
  0xbf0d, 0xbf09, 0xbf00, 0xbf02, 0xbf1c, 0xbf15, 0xbf11, 0xbf2d,
  0xbf24, 0xbf26, 0xbf39, 0xbf38, 0xbf3b, 0xbf35, 0xbf36, 0xbf31,
  0xbf30, 0xbf33, 0xbf49, 0xbf48, 0xbf4a, 0xbf44, 0xbf40, 0xbf42,
  0xbf5d, 0xbf59, 0xbf55, 0xbf6c, 0xbf6e, 0xbf61, 0xbf85, 0xbf81,
  0xbf9d, 0xbfa9, 0xbfa5, 0xbfa1, 0xbfb9, 0xbfba, 0xbfcd, 0xbfc9,
  0xbfc5, 0xbfdd, 0xbfde, 0xbff5, 0xbff4, 0xbff1, 0xbff2, 0xb80d,
  0xb80f, 0xb805, 0xb804, 0xb806, 0xb801, 0xb800, 0xb802, 0xb81c,
  0xb819, 0xb818, 0xb81b, 0xb81a, 0xb815, 0xb816, 0xb811, 0xb810,
  0xb813, 0xb812, 0xb829, 0xb828, 0xb82a, 0xb824, 0xb820, 0xb83d,
  0xb83c, 0xb839, 0xb835, 0xb84d, 0xb84c, 0xb84e, 0xb849, 0xb848,
  0xb844, 0xb841, 0xb840, 0xb85d, 0xb850, 0xb889, 0xb888, 0xb885,
  0xb886, 0xb881, 0xb883, 0xb899, 0xb898, 0xb89a,
  /* 0x3a */
  0xb894, 0xb897, 0xb8ad, 0xb8ac, 0xb8a9, 0xb8aa, 0xb8a5, 0xb8bd,
  0xb8bc, 0xb8be, 0xb8b9, 0xb8b8, 0xb8b1, 0xb8b0, 0xb8cd, 0xb8c9,
  0xb8c0, 0xb8c2, 0xb8dd, 0xb8dc, 0xb8d8, 0xb8d5, 0xb8d1, 0xb8f9,
  0xb8f8, 0xb8fb, 0xb8f5, 0xb8f1, 0xb909, 0xb908, 0xb90a, 0xb904,
  0xb91d, 0xb919, 0xb929, 0xb921, 0xb94d, 0xb945, 0xb944, 0xb941,
  0xb95d, 0xb955, 0xb954, 0xb969, 0xb965, 0xb98d, 0xb98c, 0xb989,
  0xb98a, 0xb985, 0xb984, 0xb987, 0xb99d, 0xb99c, 0xb99e, 0xb998,
  0xb994, 0xb997, 0xb991, 0xb9a9, 0xb9bd, 0xb9b5, 0xb9d9, 0xb9d8,
  0xb9d5, 0xb9d1, 0xb9e4, 0xb9fd, 0xb9f9, 0xb9f5, 0xba0d, 0xba0e,
  0xba08, 0xba01, 0xba00, 0xba1d, 0xba19, 0xba11, 0xba10, 0xba12,
  0xba49, 0xba48, 0xba45, 0xba41, 0xba43, 0xba59, 0xba58, 0xba5a,
  0xba54, 0xba57, 0xba56, 0xba6d, 0xba6c, 0xba69,
  /* 0x3b */
  0xba65, 0xba67, 0xba7d, 0xba7c, 0xba7e, 0xba79, 0xba78, 0xba76,
  0xba71, 0xba70, 0xba8d, 0xba89, 0xba81, 0xba80, 0xba82, 0xba9d,
  0xba9c, 0xba95, 0xba94, 0xbaa5, 0xbadd, 0xbadc, 0xbad9, 0xbada,
  0xbad5, 0xbaed, 0xbaee, 0xbae9, 0xbae8, 0xbae1, 0xbb0c, 0xbb05,
  0xbb04, 0xbb15, 0xbb14, 0xbb16, 0xbb11, 0xbb10, 0xbb4d, 0xbb4c,
  0xbb49, 0xbb45, 0xbb5d, 0xbb5c, 0xbb58, 0xbb99, 0xbbbd, 0xbbc8,
  0xbbc1, 0xbbc0, 0xbbdd, 0xbbd9, 0xbbd1, 0xbbd2, 0xbbec, 0xc431,
  0xc45c, 0xc455, 0xc451, 0xc46d, 0xc465, 0xc464, 0xc49d, 0xc49c,
  0xc499, 0xc495, 0xc4ad, 0xc4ac, 0xc4ae, 0xc4a8, 0xc4a1, 0xc4a0,
  0xc4a2, 0xc4bd, 0xc4be, 0xc4b9, 0xc4b8, 0xc4bb, 0xc4b1, 0xc4b0,
  0xc4b2, 0xc4cd, 0xc4cc, 0xc4c8, 0xc4c5, 0xc4c4, 0xc4c1, 0xc4dd,
  0xc4d5, 0xc4d4, 0xc4d6, 0xc4d1, 0xc4d0, 0xc4e9,
  /* 0x3c */
  0xc4e8, 0xc4e5, 0xc4e1, 0xc4f9, 0xc4f8, 0xc4fa, 0xc4f4, 0xc50d,
  0xc509, 0xc505, 0xc51d, 0xc518, 0xc511, 0xc510, 0xc513, 0xc512,
  0xc52d, 0xc52e, 0xc529, 0xc52b, 0xc52a, 0xc521, 0xc520, 0xc522,
  0xc53d, 0xc53c, 0xc53b, 0xc535, 0xc534, 0xc531, 0xc54d, 0xc545,
  0xc544, 0xc546, 0xc541, 0xc540, 0xc559, 0xc558, 0xc555, 0xc551,
  0xc569, 0xc568, 0xc56a, 0xc565, 0xc564, 0xc57d, 0xc579, 0xc575,
  0xc588, 0xc581, 0xc580, 0xc583, 0xc59d, 0xc599, 0xc59b, 0xc591,
  0xc590, 0xc592, 0xc5ac, 0xc5a8, 0xc5a5, 0xc5a4, 0xc5a1, 0xc5bd,
  0xc5b0, 0xc5c9, 0xc5c5, 0xc5c1, 0xc5d9, 0xc5da, 0xc5d5, 0xc5ed,
  0xc5e9, 0xc5e5, 0xc5fd, 0xc5fc, 0xc5fe, 0xc5f1, 0xc5f0, 0xc60d,
  0xc609, 0xc601, 0xc600, 0xc602, 0xc61c, 0xc615, 0xc614, 0xc611,
  0xc612, 0xc62d, 0xc625, 0xc624, 0xc626, 0xc620,
  /* 0x3d */
  0xc622, 0xc63c, 0xc63f, 0xc639, 0xc645, 0xc65d, 0xc65c, 0xc659,
  0xc655, 0xc66d, 0xc668, 0xc661, 0xc660, 0xc67d, 0xc679, 0xc671,
  0xc670, 0xc672, 0xc68c, 0xc685, 0xc684, 0xc69d, 0xc695, 0xc696,
  0xc690, 0xc6a9, 0xc6a8, 0xc6a5, 0xc6a1, 0xc6a0, 0xc6b9, 0xc6b8,
  0xc6ba, 0xc6b4, 0xc6d1, 0xc6d0, 0xc6ed, 0xc6ee, 0xc6e9, 0xc6e6,
  0xc6e1, 0xc6e0, 0xc6e2, 0xc6fc, 0xc6fb, 0xc6f5, 0xc6f4, 0xc6f6,
  0xc6f1, 0xc70d, 0xc705, 0xc704, 0xc701, 0xc700, 0xc71e, 0xc719,
  0xc718, 0xc715, 0xc711, 0xc729, 0xc728, 0xc725, 0xc724, 0xc748,
  0xc765, 0xc764, 0xc761, 0xc77d, 0xc77f, 0xc775, 0xc774, 0xc771,
  0xc770, 0xc789, 0xc785, 0xc781, 0xc7cd, 0xc7d5, 0xc7d4, 0xc7d1,
  0xc7d2, 0xc7ed, 0xc7ef, 0xc7e5, 0xc7e4, 0xc7e0, 0xc7f9, 0xc7f8,
  0xc7f5, 0xc005, 0xc01d, 0xc029, 0xc021, 0xc03d,
  /* 0x3e */
  0xc039, 0xc031, 0xc030, 0xc045, 0xc069, 0xc068, 0xc065, 0xc061,
  0xc079, 0xc078, 0xc074, 0xc08d, 0xc099, 0xc091, 0xc0b5, 0xc0b1,
  0xc0e4, 0xc0fd, 0xc0fc, 0xc0f9, 0xc0f5, 0xc0f7, 0xc0f2, 0xc10d,
  0xc10c, 0xc101, 0xc11d, 0xc119, 0xc111, 0xc125, 0xc124, 0xc121,
  0xc13d, 0xc135, 0xc134, 0xc136, 0xc130, 0xc149, 0xc148, 0xc145,
  0xc144, 0xc147, 0xc141, 0xc140, 0xc143, 0xc15e, 0xc159, 0xc158,
  0xc15a, 0xc155, 0xc154, 0xc150, 0xc153, 0xc16d, 0xc16c, 0xc169,
  0xc165, 0xc17d, 0xc17c, 0xc17e, 0xc179, 0xc178, 0xc171, 0xc170,
  0xc18d, 0xc189, 0xc18a, 0xc181, 0xc180, 0xc182, 0xc19c, 0xc198,
  0xc19a, 0xc195, 0xc191, 0xc1ad, 0xc1a4, 0xc1b9, 0xc1b8, 0xc1b5,
  0xc1b4, 0xc1b6, 0xc1b1, 0xc1b0, 0xc1b3, 0xc1c9, 0xc1c8, 0xc1cb,
  0xc1ca, 0xc1c5, 0xc1c4, 0xc1c7, 0xc1c1, 0xc1c3,
  /* 0x3f */
  0xc1dd, 0xc1dc, 0xc1d9, 0xc1d5, 0xc1ed, 0xc1ec, 0xc1ee, 0xc1e8,
  0xc1e1, 0xc1e0, 0xc1e3, 0xc1fd, 0xc1f9, 0xc1fb, 0xc1fa, 0xc1f1,
  0xc1f0, 0xc1f3, 0xc1f2, 0xc20d, 0xc20c, 0xc208, 0xc20b, 0xc20a,
  0xc205, 0xc201, 0xc21d, 0xc215, 0xc214, 0xc216, 0xc211, 0xc229,
  0xc228, 0xc225, 0xc221, 0xc220, 0xc223, 0xc23d, 0xc23e, 0xc239,
  0xc238, 0xc23a, 0xc234, 0xc236, 0xc24d, 0xc24c, 0xc249, 0xc245,
  0xc25d, 0xc25c, 0xc25e, 0xc259, 0xc258, 0xc251, 0xc250, 0xc26d,
  0xc261, 0xc262, 0xc27c, 0xc275, 0xc274, 0xc271, 0xc28d, 0xc285,
  0xc284, 0xc286, 0xc280, 0xc299, 0xc298, 0xc295, 0xc291, 0xc2a9,
  0xc2a8, 0xc2aa, 0xc2a4, 0xc2bd, 0xc2bc, 0xc2b9, 0xc2b5, 0xc2b4,
  0xc2b7, 0xc2cd, 0xc2cc, 0xc2ce, 0xc2c8, 0xc2c1, 0xc2c0, 0xc2dd,
  0xc2d9, 0xc2d1, 0xc2d0, 0xc2ed, 0xc2ec, 0xc2e5,
  /* 0x40 */
  0xc2e4, 0xc2e1, 0xc2fd, 0xc2f5, 0xc2f4, 0xc2f0, 0xc309, 0xc308,
  0xc305, 0xc301, 0xc319, 0xc318, 0xc31a, 0xc314, 0xc32d, 0xc32c,
  0xc329, 0xc325, 0xc33d, 0xc33c, 0xc33e, 0xc338, 0xc33a, 0xc331,
  0xc330, 0xc34d, 0xc349, 0xc347, 0xc341, 0xc340, 0xc342, 0xc35c,
  0xc35f, 0xc35e, 0xc359, 0xc358, 0xc35b, 0xc35a, 0xc355, 0xc351,
  0xc36d, 0xc365, 0xc366, 0xc379, 0xc378, 0xc375, 0xc371, 0xc370,
  0xc373, 0xc38e, 0xc389, 0xc388, 0xc38a, 0xc385, 0xc384, 0xc387,
  0xc383, 0xc39d, 0xc39c, 0xc399, 0xc39b, 0xc39a, 0xc395, 0xc397,
  0xc3ad, 0xc3ac, 0xc3ae, 0xc3a9, 0xc3a8, 0xc3ab, 0xc3a1, 0xc3a0,
  0xc3bd, 0xc3b9, 0xc3b1, 0xc3b0, 0xc3b2, 0xc3cd, 0xc3cc, 0xc3c5,
  0xc3c4, 0xc3c1, 0xc3c3, 0xc3dd, 0xc3d5, 0xc3d0, 0xc3e9, 0xc3e5,
  0xc3e1, 0xcc0d, 0xcc0c, 0xcc09, 0xcc05, 0xcc07,
  /* 0x41 */
  0xcc1d, 0xcc1c, 0xcc1e, 0xcc18, 0xcc1b, 0xcc11, 0xcc10, 0xcc2d,
  0xcc29, 0xcc21, 0xcc20, 0xcc22, 0xcc3c, 0xcc35, 0xcc31, 0xcc4d,
  0xcc45, 0xcc44, 0xcc41, 0xcc40, 0xcc59, 0xcc7d, 0xcc7c, 0xcc79,
  0xcc75, 0xcc77, 0xcc8d, 0xcc8c, 0xcc8e, 0xcc88, 0xcc8b, 0xcc8a,
  0xcc86, 0xcc81, 0xcc80, 0xcc99, 0xcc90, 0xcc92, 0xccac, 0xcca5,
  0xccb1, 0xccb0, 0xccc9, 0xccc5, 0xccc1, 0xccd9, 0xccd8, 0xccda,
  0xccd4, 0xcced, 0xccec, 0xcce9, 0xccf8, 0xccf1, 0xccf0, 0xcd0d,
  0xcd09, 0xcd08, 0xcd0b, 0xcd01, 0xcd00, 0xcd02, 0xcd1c, 0xcd15,
  0xcd21, 0xcd39, 0xcd5d, 0xcd5c, 0xcd59, 0xcd55, 0xcd6d, 0xcd6c,
  0xcd6e, 0xcd61, 0xcd7d, 0xcd79, 0xcd71, 0xcd85, 0xcd84, 0xcd81,
  0xcd9d, 0xcd95, 0xcd94, 0xcd96, 0xcd90, 0xcdcd, 0xcdcc, 0xcdc9,
  0xcdca, 0xcdc5, 0xcdc7, 0xcddd, 0xcddc, 0xcdde,
  /* 0x42 */
  0xcdd8, 0xcddb, 0xcdd4, 0xcdd7, 0xcdd1, 0xcdd0, 0xcded, 0xcdef,
  0xcde9, 0xcdea, 0xcde1, 0xcde0, 0xcde2, 0xcdfd, 0xcdfc, 0xcdf5,
  0xcdf4, 0xcdf1, 0xce0d, 0xce05, 0xce04, 0xce06, 0xce01, 0xce00,
  0xce19, 0xce15, 0xce24, 0xce41, 0xce40, 0xce5d, 0xce59, 0xce51,
  0xce50, 0xce52, 0xce6d, 0xce6c, 0xce65, 0xce70, 0xce89, 0xce95,
  0xceb1, 0xceb0, 0xcecd, 0xcec9, 0xcec1, 0xcec0, 0xcec2, 0xcedc,
  0xcede, 0xced5, 0xced4, 0xceed, 0xcee1, 0xcef9, 0xcf05, 0xcf1d,
  0xcf19, 0xcf15, 0xcf2d, 0xcf2c, 0xcf4c, 0xcf45, 0xcf44, 0xcf41,
  0xcf5d, 0xcf55, 0xcf54, 0xcf50, 0xcf69, 0xcf75, 0xcf74, 0xcf91,
  0xcfb5, 0xcfd9, 0xcfe9, 0xcfea, 0xcfe4, 0xc801, 0xc800, 0xc81d,
  0xc819, 0xc811, 0xc810, 0xc82c, 0xc82f, 0xc82a, 0xc825, 0xc824,
  0xc821, 0xc823, 0xc83d, 0xc835, 0xc834, 0xc836,
  /* 0x43 */
  0xc831, 0xc830, 0xc833, 0xc849, 0xc848, 0xc845, 0xc841, 0xc859,
  0xc858, 0xc85a, 0xc855, 0xc854, 0xc86d, 0xc869, 0xc86b, 0xc865,
  0xc87d, 0xc878, 0xc895, 0xc894, 0xc891, 0xc8ad, 0xc8a5, 0xc8a4,
  0xc8a6, 0xc8a1, 0xc8a0, 0xc8b9, 0xc8b8, 0xc8b5, 0xc8b1, 0xc8c9,
  0xc8c8, 0xc8ca, 0xc8c4, 0xc8dd, 0xc8d9, 0xc8e9, 0xc8e1, 0xc8fd,
  0xc90c, 0xc905, 0xc904, 0xc901, 0xc91d, 0xc915, 0xc914, 0xc916,
  0xc910, 0xc929, 0xc925, 0xc921, 0xc934, 0xc951, 0xc96d, 0xc969,
  0xc961, 0xc960, 0xc962, 0xc97c, 0xc975, 0xc985, 0xc999, 0xc998,
  0xc995, 0xc991, 0xc9a9, 0xc9a8, 0xc9aa, 0xc9a4, 0xc9bd, 0xc9c9,
  0xc9c1, 0xc9dd, 0xc9e5, 0xc9e1, 0xc9fd, 0xc9f5, 0xc9f4, 0xc9f6,
  0xc9f0, 0xca09, 0xca05, 0xca01, 0xca19, 0xca14, 0xca2d, 0xca2c,
  0xca29, 0xca25, 0xca3d, 0xca3c, 0xca3e, 0xca38,
  /* 0x44 */
  0xca55, 0xca54, 0xca51, 0xca52, 0xca6d, 0xca6c, 0xca65, 0xca64,
  0xca66, 0xca60, 0xca79, 0xca78, 0xca75, 0xca71, 0xca89, 0xca88,
  0xca8a, 0xca84, 0xca9d, 0xca9c, 0xca99, 0xca95, 0xcaad, 0xcaac,
  0xcaae, 0xcaa9, 0xcaa8, 0xcaa1, 0xcaa0, 0xcacc, 0xcae9, 0xcae8,
  0xcae5, 0xcae6, 0xcae1, 0xcaf9, 0xcaf8, 0xcafa, 0xcaf5, 0xcaf4,
  0xcb0d, 0xcb0c, 0xcb09, 0xcb05, 0xcb1d, 0xcb1c, 0xcb1e, 0xcb18,
  0xcb11, 0xcb2d, 0xcb29, 0xcb21, 0xcb20, 0xcb22, 0xcb3d, 0xcb3c,
  0xcb35, 0xcb59, 0xcb58, 0xcb55, 0xcb51, 0xcb69, 0xcb68, 0xcb6a,
  0xcb64, 0xcb7d, 0xcb7c, 0xcb79, 0xcb75, 0xcb8d, 0xcb88, 0xcb81,
  0xcbac, 0xcba5, 0xcbbd, 0xcbc9, 0xcbed, 0xcbec, 0xcbe9, 0xcbe5,
  0xcbfd, 0xcbfc, 0xcbfe, 0xcbf8, 0xcbf1, 0xd40d, 0xd409, 0xd41c,
  0xd415, 0xd420, 0xd439, 0xd438, 0xd435, 0xd431,
  /* 0x45 */
  0xd449, 0xd448, 0xd44a, 0xd444, 0xd45d, 0xd459, 0xd455, 0xd46d,
  0xd461, 0xd460, 0xd47d, 0xd479, 0xd471, 0xd470, 0xd48c, 0xd4a9,
  0xd4a8, 0xd4a5, 0xd4a1, 0xd4b9, 0xd4b8, 0xd4ba, 0xd4b4, 0xd4cd,
  0xd4cc, 0xd4c9, 0xd4c5, 0xd4c4, 0xd4dd, 0xd4dc, 0xd4de, 0xd4d9,
  0xd4d8, 0xd4d1, 0xd4d0, 0xd4ed, 0xd4e9, 0xd4e1, 0xd4e0, 0xd4e2,
  0xd4fd, 0xd4fc, 0xd4f5, 0xd500, 0xd53d, 0xd53c, 0xd539, 0xd535,
  0xd537, 0xd54d, 0xd54c, 0xd54e, 0xd549, 0xd548, 0xd541, 0xd540,
  0xd55d, 0xd559, 0xd551, 0xd550, 0xd552, 0xd56c, 0xd565, 0xd561,
  0xd571, 0xd589, 0xd585, 0xd5ad, 0xd5ac, 0xd5a9, 0xd5a5, 0xd5bd,
  0xd5bc, 0xd5be, 0xd5b8, 0xd5b7, 0xd5b1, 0xd5cd, 0xd5d5, 0xd5f9,
  0xd5f5, 0xd60a, 0xd604, 0xd61d, 0xd621, 0xd620, 0xd63d, 0xd639,
  0xd631, 0xd630, 0xd632, 0xd64c, 0xd645, 0xd651,
  /* 0x46 */
  0xd669, 0xd68d, 0xd68c, 0xd689, 0xd685, 0xd69d, 0xd69c, 0xd698,
  0xd691, 0xd6ad, 0xd6a9, 0xd6a1, 0xd6bc, 0xd6b5, 0xd6b4, 0xd6b1,
  0xd6b2, 0xd6cd, 0xd6cf, 0xd6c5, 0xd6c4, 0xd6c6, 0xd6d9, 0xd6d5,
  0xd6d1, 0xd6e9, 0xd6e8, 0xd6fd, 0xd6fc, 0xd6f9, 0xd6f5, 0xd70d,
  0xd70c, 0xd70e, 0xd708, 0xd701, 0xd700, 0xd703, 0xd71d, 0xd719,
  0xd71b, 0xd711, 0xd710, 0xd712, 0xd72d, 0xd72c, 0xd728, 0xd725,
  0xd724, 0xd721, 0xd73d, 0xd735, 0xd734, 0xd736, 0xd731, 0xd730,
  0xd749, 0xd748, 0xd771, 0xd770, 0xd78d, 0xd789, 0xd781, 0xd780,
  0xd782, 0xd79d, 0xd79c, 0xd795, 0xd794, 0xd791, 0xd7ad, 0xd7a5,
  0xd7a4, 0xd7a6, 0xd7a0, 0xd7b9, 0xd7b5, 0xd7b1, 0xd7c9, 0xd7c8,
  0xd7c5, 0xd7c4, 0xd7dd, 0xd7d5, 0xd7ec, 0xd7ee, 0xd7e1, 0xd7e0,
  0xd7fd, 0xd7f9, 0xd7f1, 0xd7f0, 0xd7f2, 0xd00c,
  /* 0x47 */
  0xd005, 0xd010, 0xd04d, 0xd049, 0xd051, 0xd06d, 0xd069, 0xd060,
  0xd062, 0xd075, 0xd074, 0xd071, 0xd072, 0xd08d, 0xd08f, 0xd085,
  0xd084, 0xd086, 0xd080, 0xd099, 0xd0a4, 0xd0c1, 0xd0dd, 0xd0d9,
  0xd0d1, 0xd0d2, 0xd0e5, 0xd0e1, 0xd0fd, 0xd0f5, 0xd0f6, 0xd0f0,
  0xd109, 0xd105, 0xd101, 0xd119, 0xd118, 0xd11a, 0xd131, 0xd130,
  0xd14d, 0xd149, 0xd141, 0xd140, 0xd142, 0xd15c, 0xd155, 0xd154,
  0xd151, 0xd16d, 0xd168, 0xd165, 0xd164, 0xd166, 0xd160, 0xd179,
  0xd178, 0xd175, 0xd171, 0xd189, 0xd188, 0xd18a, 0xd185, 0xd184,
  0xd19d, 0xd1a8, 0xd1c5, 0xd1c4, 0xd1c1, 0xd1dd, 0xd1df, 0xd1d5,
  0xd1d4, 0xd1d6, 0xd1d0, 0xd1e9, 0xd1e8, 0xd1e5, 0xd1e1, 0xd1f9,
  0xd1f8, 0xd1fa, 0xd1f4, 0xd20d, 0xd20c, 0xd209, 0xd205, 0xd21d,
  0xd21c, 0xd21e, 0xd219, 0xd218, 0xd211, 0xd22d,
  /* 0x48 */
  0xd229, 0xd220, 0xd235, 0xd234, 0xd231, 0xd24d, 0xd248, 0xd245,
  0xd244, 0xd246, 0xd240, 0xd25c, 0xd259, 0xd258, 0xd255, 0xd251,
  0xd26a, 0xd264, 0xd27d, 0xd27c, 0xd279, 0xd28e, 0xd288, 0xd281,
  0xd280, 0xd29d, 0xd299, 0xd290, 0xd292, 0xd2ac, 0xd2a5, 0xd2a1,
  0xd2bd, 0xd2b4, 0xd2b6, 0xd2c9, 0xd2c8, 0xd2c5, 0xd2c1, 0xd2dc,
  0xd2d9, 0xd2da, 0xd2d4, 0xd2ed, 0xd2e9, 0xd2e5, 0xd2fd, 0xd2f8,
  0xd2f1, 0xd2f0, 0xd30d, 0xd309, 0xd31c, 0xd315, 0xd314, 0xd311,
  0xd32d, 0xd325, 0xd324, 0xd326, 0xd320, 0xd339, 0xd338, 0xd335,
  0xd331, 0xd349, 0xd34a, 0xd344, 0xd35d, 0xd35c, 0xd359, 0xd35b,
  0xd35a, 0xd355, 0xd354, 0xd36d, 0xd36c, 0xd36e, 0xd368, 0xd364,
  0xd361, 0xd37d, 0xd379, 0xd371, 0xd370, 0xd38c, 0xd385, 0xd384,
  0xd381, 0xd39d, 0xd395, 0xd394, 0xd396, 0xd390
};

static const acp_uint16_t ksc5601_2uni_page4a[ /*4888*/ ] = {
  /* 0x4a */
  0x4b30, 0x4b7e, 0x544a, 0x54f4, 0x56ad, 0x57e2, 0x5078, 0x50e8,
  0x5204, 0x5ecc, 0x5fbb, 0x628a, 0x63bb, 0x63ba, 0x63e2, 0x6f41,
  0x77cf, 0x71cf, 0x7e31, 0x86d6, 0x8709, 0x8c5a, 0x8c85, 0x8e3b,
  0x88c5, 0x89c2, 0x8af6, 0x8beb, 0x9dd8, 0x5636, 0x5779, 0x5009,
  0x6467, 0x6569, 0x6fb1, 0x77c2, 0x8517, 0x8db7, 0x8ddf, 0x91ae,
  0x4b8e, 0x5607, 0x5cb3, 0x5d75, 0x5deb, 0x5a7f, 0x5a74, 0x65ca,
  0x67cd, 0x634b, 0x63e1, 0x6c72, 0x6b9a, 0x7243, 0x7306, 0x7cf8,
  0x7e05, 0x7ef2, 0x782c, 0x8490, 0x8663, 0x867c, 0x8ee6, 0x919e,
  0x4a66, 0x5190, 0x62fa, 0x6a39, 0x7cae, 0x7ee0, 0x8056, 0x8d1d,
  0x8343, 0x93a5, 0x56d5, 0x5343, 0x5c27, 0x5941, 0x6512, 0x65b3,
  0x662c, 0x616f, 0x63dc, 0x6e49, 0x6a16, 0x7115, 0x71be, 0x72ee,
  0x73bd, 0x7937, 0x94a2, 0x905c, 0x905f, 0x9b98,
  /* 0x4b */
  0x572e, 0x58a1, 0x713f, 0x84d6, 0x964d, 0x9195, 0x5656, 0x5c05,
  0x5dd1, 0x58ac, 0x591a, 0x5aba, 0x5b37, 0x5b47, 0x657a, 0x6852,
  0x7177, 0x718b, 0x78ed, 0x797e, 0x79bc, 0x7b81, 0x8559, 0x862c,
  0x819c, 0x8d4c, 0x8f16, 0x96f1, 0x9240, 0x984a, 0x4ac6, 0x4afa,
  0x5406, 0x55fc, 0x5c42, 0x653a, 0x6533, 0x6565, 0x6134, 0x6de7,
  0x6b1c, 0x71a8, 0x728b, 0x72db, 0x7f8a, 0x86a8, 0x80c6, 0xfd0d,
  0x97aa, 0x9186, 0x518d, 0x5faf, 0x535c, 0xfd0c, 0x78be, 0x7bb4,
  0x95b8, 0x5425, 0x57b6, 0x5848, 0x59e5, 0x66df, 0x6763, 0x60d7,
  0x60ea, 0x6a2d, 0x74a1, 0x7d56, 0x89d0, 0x8a13, 0xfd0f, 0x9470,
  0x9648, 0x96f5, 0x4a73, 0x4afb, 0x5468, 0x59f3, 0x5af7, 0x650b,
  0x6d5a, 0x857c, 0x8259, 0x8a4a, 0x9778, 0x9e26, 0x4a53, 0x549c,
  0x637d, 0x6c4d, 0x5504, 0x5680, 0x569f, 0x6eaf,
  /* 0x4c */
  0x73b1, 0x961d, 0x9ad9, 0x56a6, 0x6422, 0x8bff, 0x5445, 0x65a4,
  0x67e0, 0x60c7, 0x6c31, 0x6e89, 0x6bcd, 0x8585, 0x8dac, 0x9299,
  0x5c08, 0x7670, 0x76a1, 0x7109, 0x7974, 0x7a60, 0x84a4, 0x8d86,
  0x8f79, 0x946e, 0x995c, 0x6684, 0x6877, 0x6b59, 0x795d, 0x7b37,
  0x8e2e, 0x5571, 0x6547, 0x7f90, 0x8f14, 0x965a, 0x9781, 0x4aa1,
  0x4bde, 0x5413, 0x54b3, 0x550b, 0x56cc, 0x56c0, 0x5772, 0x537d,
  0x5c8e, 0x5a97, 0x5b9c, 0x657b, 0x65a1, 0x60c3, 0x6161, 0x6262,
  0x62b6, 0x62f9, 0x6c9a, 0x698a, 0x7488, 0x74fc, 0x7092, 0x70a8,
  0x70c7, 0x71d4, 0x7c61, 0x7ce1, 0x7ed2, 0x7efb, 0x7948, 0x799e,
  0x8418, 0x8432, 0x8516, 0x879b, 0x8f6b, 0x8b18, 0x9418, 0x97ec,
  0x9c0e, 0x9c35, 0x9e57, 0x9fe5, 0x4bcf, 0x515e, 0x5c37, 0x5d5c,
  0x5f6e, 0x584b, 0x64b5, 0x661f, 0x6c4f, 0x6cbd,
  /* 0x4d */
  0x6ce5, 0x6aa7, 0x7141, 0x7275, 0x7cc3, 0x7e30, 0x78f6, 0x7a66,
  0x7a71, 0x8e05, 0x8eac, 0x8832, 0x9283, 0x99c9, 0x57e9, 0x57e4,
  0x5047, 0x507c, 0x52f7, 0x5ddc, 0x5f69, 0x5836, 0x5aa6, 0x66fa,
  0x613a, 0x6148, 0x617f, 0x62ad, 0x63a2, 0x6dcc, 0x68b0, 0x71f1,
  0x729d, 0x7373, 0x7e32, 0x7b99, 0x840e, 0x84ac, 0x8582, 0x86eb,
  0x86f0, 0x87fd, 0x81cc, 0x8c3c, 0x8cb9, 0x8ea8, 0xfd0e, 0x8b91,
  0x9723, 0x92ca, 0x9c6a, 0x9ed5, 0x9b1e, 0x50e0, 0x6196, 0x62ff,
  0x6c82, 0x7e4d, 0x883a, 0x996d, 0x52fd, 0x5369, 0x591c, 0x620b,
  0x6cbc, 0x6cc0, 0x6af3, 0x7025, 0x8c93, 0x9fe9, 0x6865, 0xfd09,
  0x9ea5, 0x4b96, 0x5561, 0x557c, 0x5692, 0x5f59, 0x59e8, 0x645d,
  0x6460, 0x66fc, 0x67aa, 0x6136, 0x77d4, 0x7e77, 0x82ae, 0x88af,
  0x9382, 0x4a3f, 0x5fec, 0x6605, 0x6391, 0x70d1,
  /* 0x4e */
  0x7ddc, 0x87de, 0x8e8a, 0x8ebf, 0x89e5, 0x9443, 0x9746, 0x9c4b,
  0x5ade, 0x6de5, 0x81f2, 0x94e0, 0xfd08, 0x55ad, 0x5f95, 0x5fe1,
  0x656e, 0x6cf7, 0x6f33, 0x7441, 0x7022, 0x70d5, 0x7fac, 0x7b5d,
  0x87c8, 0x8dcd, 0x88a6, 0x91d1, 0x9d25, 0x5623, 0x6450, 0x66e1,
  0x940f, 0x4b87, 0x5544, 0x572c, 0x5cd4, 0x5aee, 0x62ed, 0x6935,
  0x7497, 0x76cf, 0x77db, 0x7f5d, 0x84fc, 0x9056, 0x576b, 0x6796,
  0x7b66, 0x4a5b, 0x548d, 0x5c47, 0x5cd3, 0x6427, 0x652a, 0x66dd,
  0x6ddd, 0x9f4c, 0x5f82, 0x7915, 0x84bc, 0x8b52, 0x4aa9, 0x54dc,
  0x50a1, 0x51a1, 0x5f01, 0x59ad, 0x59ea, 0x6127, 0x6143, 0x6c2c,
  0x6e46, 0x76ec, 0x7283, 0x73e2, 0x7953, 0x7bf4, 0x85ad, 0x8143,
  0x82d2, 0x8b0e, 0x8b43, 0x94c7, 0x9d0e, 0x9e58, 0x9fa6, 0x4a15,
  0x4a48, 0x4a50, 0x4aca, 0x4bfc, 0x557a, 0x56f3,
  /* 0x4f */
  0x574d, 0x57ee, 0x57e8, 0x5083, 0x5219, 0x5378, 0x53af, 0x5fca,
  0x598a, 0x5add, 0x65f1, 0x66d5, 0x615c, 0x63b5, 0x63e4, 0x6dc6,
  0x6f5d, 0x6fcb, 0x6fe1, 0x684f, 0x6a90, 0x7475, 0x76da, 0x779b,
  0x700e, 0x73b2, 0x73e4, 0x7e7b, 0x7972, 0x8404, 0x85f1, 0x8608,
  0x8607, 0x86d2, 0x8c6f, 0x8f3e, 0x88f1, 0x8acd, 0x941c, 0x94bc,
  0x9669, 0x96bb, 0x9ddf, 0x9e48, 0x98e4, 0x99da, 0x9b91, 0x5306,
  0x584d, 0x87c7, 0x93ad, 0x93a6, 0x9ab9, 0x5016, 0x7e95, 0x7ba9,
  0x8cd4, 0x8ac0, 0x94ec, 0x5c0d, 0x5845, 0x6795, 0x7e92, 0x5fa3,
  0x5b1e, 0x7e74, 0x7ea3, 0x8683, 0x8aa1, 0x542b, 0x5635, 0x56f5,
  0x577a, 0x5305, 0x66fe, 0x677f, 0x6f07, 0x69ce, 0x733a, 0x57a8,
  0x775a, 0x8165, 0x8a7b, 0x91d8, 0x6337, 0x6ece, 0x6b7d, 0x8e60,
  0x8ac1, 0x9d46, 0xfd0b, 0x627a, 0x6f75, 0x88b9,
  /* 0x50 */
  0x9f31, 0xfd0a, 0x57e6, 0x5320, 0x5d43, 0x67cb, 0x6df6, 0x77e7,
  0x7c48, 0x7eb7, 0x7ec8, 0x78f3, 0x8078, 0x8d82, 0x897e, 0x9438,
  0x91a5, 0x56f6, 0x534a, 0x714a, 0x7f6d, 0x87c1, 0x9613, 0xfd05,
  0x6e55, 0x5546, 0x5646, 0x568a, 0x6612, 0x6cd5, 0x6d78, 0x9294,
  0x54c8, 0x56a9, 0x56e9, 0x65ce, 0x61a9, 0x6c34, 0x6df2, 0x7073,
  0x7f46, 0x86b4, 0x87e6, 0x8dbf, 0x8f34, 0x8bdc, 0x9d44, 0xfd04,
  0x4ac7, 0x5d9a, 0x60df, 0x621c, 0x6e83, 0x7039, 0x7d8c, 0x7db0,
  0x86a4, 0x8c73, 0x8c72, 0x8d52, 0xfd07, 0x972b, 0x4b06, 0x57c7,
  0x6428, 0x667c, 0x687f, 0x7917, 0x796b, 0x4a95, 0x556f, 0x73d1,
  0x84a2, 0x4b0c, 0x4b03, 0x557b, 0x558d, 0x51d1, 0x5265, 0x5336,
  0x53f7, 0x53f1, 0x5d19, 0x5d4a, 0x5d9e, 0x5fc9, 0x589d, 0x5903,
  0x59fc, 0x5a73, 0x5bc1, 0x668d, 0x61da, 0x61ee,
  /* 0x51 */
  0x6313, 0x6312, 0x6353, 0x6cc6, 0x6cc9, 0x6e52, 0x6f37, 0x682e,
  0x6870, 0x688f, 0x69ca, 0x7795, 0x702b, 0x7027, 0x708f, 0x70ae,
  0x7175, 0x7172, 0x7c8c, 0x7ce2, 0x7d4c, 0x7d4a, 0x7d45, 0x7d77,
  0x7f98, 0x790d, 0x79b7, 0x7b85, 0x840b, 0x8420, 0x8481, 0x8e15,
  0x8f42, 0x8845, 0x897a, 0x972c, 0x9729, 0x9cef, 0x9d5c, 0x9e03,
  0x9e02, 0x9e68, 0x9a9f, 0x79c7, 0x4b7b, 0x5004, 0x66e3, 0x6c59,
  0x95dc, 0x51a6, 0x5537, 0xfd06, 0xfd01, 0x5e11, 0x65eb, 0xfd00,
  0x66c2, 0x66f2, 0xfd03, 0xfd02, 0xfd1d, 0xfd1c, 0xfd1f, 0xfd1e,
  0x94ae, 0xfd19, 0xfd18, 0xfd1b, 0xfd1a, 0xfd15, 0x8ef3, 0xfd14,
  0xfd17, 0xfd16, 0xfd11, 0x629b, 0xfd10, 0x755b, 0xfd13, 0xfd12,
  0x92ee, 0xfd2d, 0x6742, 0x6777, 0x575a, 0xfd2c, 0x6382, 0x6d6d,
  0x6a7e, 0xfd2f, 0x713a, 0xfd2e, 0xfd29, 0xfd28,
  /* 0x52 */
  0x7900, 0xfd2b, 0xfd2a, 0x8c7f, 0x52c7, 0x5e15, 0xfd25, 0xfd24,
  0xfd27, 0xfd26, 0xfd21, 0x4a4e, 0xfd20, 0x556a, 0x5d45, 0x63fd,
  0x841d, 0xfd23, 0x5d7e, 0x5a79, 0x6097, 0x7dc7, 0x5bf8, 0x6461,
  0x66c5, 0x6776, 0x5fea, 0x5fda, 0x56a7, 0xfd22, 0x5d79, 0x5b24,
  0x641f, 0xfd3d, 0xfd3c, 0xfd3f, 0x7054, 0xfd3e, 0xfd39, 0xfd38,
  0xfd3b, 0xfd3a, 0xfd35, 0x9ddc, 0xfd34, 0xfd37, 0xfd36, 0xfd31,
  0xfd30, 0xfd33, 0xfd32, 0xfd4d, 0xfd4c, 0xfd4f, 0xfd4e, 0x6bce,
  0xfd49, 0xfd48, 0x85b2, 0x8bbf, 0x64fc, 0xfd4b, 0xfd4a, 0x856b,
  0xfd45, 0xfd44, 0x5832, 0xfd47, 0xfd46, 0xfd41, 0xfd40, 0xfd43,
  0xfd42, 0xfd5d, 0xfd5c, 0x5ee4, 0x8e28, 0x6376, 0x791d, 0xfd5f,
  0xfd5e, 0xfd59, 0xfd58, 0xfd5b, 0xfd5a, 0x84f0, 0xfd55, 0xfd54,
  0x5831, 0x68e8, 0x5732, 0x6ab7, 0x5d17, 0x873b,
  /* 0x53 */
  0x4a34, 0x4abb, 0x4b4b, 0x51a3, 0x5315, 0x5cca, 0x5b5b, 0x61ba,
  0x61eb, 0x6e8d, 0x6fb8, 0x6a40, 0x73e0, 0x7ee2, 0x7813, 0x79d3,
  0x82c6, 0x8c9f, 0x953f, 0x9756, 0x60b6, 0x6bb3, 0x7777, 0x71b5,
  0x9459, 0x515b, 0x5340, 0x65b7, 0x60d9, 0x62ca, 0x69ec, 0x6a56,
  0x6b60, 0x6bb4, 0x71fd, 0x844e, 0x85b0, 0x814c, 0x8d8e, 0x8eca,
  0x8f57, 0x9712, 0x689e, 0x715e, 0x7f59, 0x8a02, 0x9450, 0x511d,
  0x5c0f, 0x5c55, 0x5a6f, 0x660a, 0x6093, 0x6ced, 0x717b, 0x78db,
  0x83be, 0x9ae5, 0x4aee, 0x5385, 0x5363, 0x5d2a, 0x5800, 0x58bc,
  0x5a3b, 0x5b88, 0x6639, 0x60ec, 0x77be, 0x85f7, 0x8c86, 0x88b5,
  0x9287, 0x9ad6, 0x5f88, 0x5bba, 0x64be, 0x541f, 0x560d, 0x563d,
  0x531b, 0x5c38, 0x5c5a, 0x5803, 0x586d, 0x58fb, 0x5986, 0x5aab,
  0x5b9f, 0x64b1, 0x671c, 0x6784, 0x601a, 0x6c4e,
  /* 0x54 */
  0x6cf4, 0x6ecf, 0x69d5, 0x6a2c, 0x6ad9, 0x6be9, 0x75f3, 0x72d1,
  0x7374, 0x7dbc, 0x7e36, 0x8009, 0x8da4, 0x88e0, 0x89fe, 0x8a45,
  0x940e, 0x9419, 0x945e, 0x94f0, 0x9740, 0x927b, 0x93d1, 0x6fdf,
  0x740b, 0x7655, 0x76af, 0x7765, 0x736e, 0x7db2, 0x7fe9, 0x7a96,
  0x8f8d, 0x5ca4, 0x64ca, 0x616b, 0x61f0, 0x62b3, 0x6881, 0x7513,
  0x75c4, 0x8857, 0x9c1e, 0x4a60, 0x7e8c, 0x4ad0, 0x55a1, 0x55c0,
  0x56d8, 0x5001, 0x65aa, 0x637c, 0x6c5d, 0x6cd2, 0x6913, 0x6b71,
  0x71b1, 0x73be, 0x7ee8, 0x84f9, 0x806e, 0x9688, 0x5551, 0x619a,
  0x6351, 0x639e, 0x71d5, 0x7eca, 0x877e, 0xfd57, 0x884b, 0x941a,
  0x9c20, 0x5862, 0x85cd, 0x8697, 0x944c, 0x9462, 0x9600, 0x5b9a,
  0x5990, 0x6e54, 0x75c5, 0x7276, 0x7f44, 0x81e9, 0x8f09, 0x952a,
  0x9e3d, 0x518a, 0x65fb, 0xfd56, 0x7264, 0x7b88,
  /* 0x55 */
  0x8232, 0x83b7, 0x8cf5, 0x9482, 0xfd51, 0x6916, 0x74d4, 0x77d3,
  0x796c, 0x8030, 0xfd50, 0x9567, 0x9dfc, 0xfd53, 0x4a8f, 0x5778,
  0x6f09, 0x6f1f, 0x7433, 0x7616, 0x8220, 0x9a13, 0x5641, 0x8bae,
  0x595d, 0x60e8, 0x6121, 0x6f1b, 0x6be6, 0x784e, 0x7a91, 0x81c0,
  0x8d69, 0x8db0, 0x66c4, 0x85d5, 0x8c12, 0x5ac7, 0x631a, 0x6967,
  0x76f1, 0x7008, 0x7062, 0x838f, 0x94d3, 0x4b8b, 0x5900, 0x5bad,
  0x8007, 0x55ba, 0x67ad, 0x7168, 0x4aa3, 0x540b, 0x5564, 0x55c4,
  0x6c8c, 0x6e1c, 0x78a3, 0x78bc, 0x78ea, 0x8662, 0x8edf, 0x8b16,
  0x95c2, 0x4bbb, 0x553a, 0x56f8, 0x504f, 0x5ae1, 0x6563, 0x6633,
  0x61c8, 0x6ed7, 0x6bf3, 0x7d27, 0x81d1, 0x8c2e, 0x91a0, 0x9e6f,
  0x9e67, 0x9a9a, 0x9ac3, 0x5696, 0x62cb, 0x6f7a, 0x7410, 0x7d26,
  0x8b6f, 0x934f, 0x659d, 0x660d, 0x612e, 0x6b2e,
  /* 0x56 */
  0x7544, 0x7084, 0x79f9, 0x8462, 0x80e3, 0x8b2b, 0x942e, 0x9747,
  0x55b0, 0x561a, 0x56ae, 0x6901, 0x74c5, 0x8ccf, 0x5ac4, 0x618f,
  0x6fa3, 0x6bcf, 0x7833, 0x7778, 0x4ae9, 0x4b3b, 0x52f4, 0xfd52,
  0x58b7, 0x59b7, 0x6411, 0x77bf, 0x7f20, 0x7b97, 0x7bc3, 0x844b,
  0x9413, 0x9639, 0x92fb, 0x9345, 0x9c15, 0x9b6c, 0x4b86, 0x6baa,
  0x7da3, 0x95b9, 0x92ba, 0x56d3, 0xfd6d, 0x6085, 0x60c9, 0x6ede,
  0x6b53, 0x7415, 0x761d, 0x72ea, 0x840c, 0x820b, 0x8251, 0x89e2,
  0x8b08, 0x933f, 0x9f62, 0x99f7, 0x9a78, 0x7c81, 0x7d72, 0x79ad,
  0x87c4, 0x9709, 0x9a72, 0x9a9e, 0x8edb, 0x5cd2, 0x5b09, 0x632a,
  0x742a, 0x70c2, 0x786d, 0x8473, 0x552c, 0x7425, 0x766f, 0x7cc7,
  0x88cf, 0x88d7, 0x88f9, 0x92fa, 0x4a8b, 0x54d7, 0x5fe3, 0x5adb,
  0x6194, 0x75c3, 0x724f, 0x73a0, 0x8447, 0x80f1,
  /* 0x57 */
  0x9471, 0x9f2a, 0x9b80, 0x5cd5, 0x5e4c, 0x586f, 0x6e1e, 0x69d7,
  0x6b02, 0x7236, 0x7922, 0x7a3a, 0x8113, 0x8d35, 0x97e9, 0x9246,
  0x5684, 0x61df, 0x63fe, 0x6db9, 0x694c, 0x6a91, 0x7402, 0x7004,
  0x706d, 0x7154, 0x7229, 0x7c66, 0x8f21, 0x9c53, 0x5560, 0x6623,
  0x9275, 0x4b9b, 0x5426, 0x5914, 0x69e7, 0x79b5, 0x8b27, 0x5b86,
  0x6549, 0x6c1a, 0xfd6c, 0x928b, 0x56df, 0x8486, 0x55d1, 0x55c1,
  0x6d53, 0x7e11, 0x79b3, 0x87fc, 0x9278, 0x4bd7, 0x5624, 0x5795,
  0x5002, 0x5103, 0x5868, 0x64aa, 0x6343, 0x6ca5, 0x6961, 0x768c,
  0x76f5, 0x700b, 0x708e, 0xfd6f, 0x71ef, 0x7861, 0x7b74, 0x7bb5,
  0x8784, 0x8cc2, 0x8cec, 0x95c1, 0x95dd, 0x92ef, 0x9fc4, 0x5010,
  0x6b73, 0x75dd, 0x7095, 0x81f7, 0x8aa7, 0x92ae, 0x985a, 0x9a92,
  0x639a, 0x69c6, 0x703e, 0x85e5, 0x931b, 0x7c21,
  /* 0x58 */
  0x7ec6, 0x7f2d, 0x789f, 0x6064, 0x7067, 0x71ff, 0x7cb1, 0x7ce5,
  0x9da1, 0x9f59, 0x9ab6, 0x5fd3, 0x5a58, 0x6b2d, 0x8591, 0x87a6,
  0x9485, 0x4a0a, 0x5740, 0x5e24, 0x59df, 0x5b43, 0x656f, 0x6730,
  0x6264, 0x62f1, 0x6af2, 0x6b26, 0x746e, 0x7393, 0x8021, 0x811e,
  0x8c36, 0x8b1e, 0x9d48, 0x9836, 0x5111, 0x66b4, 0x6326, 0x68a6,
  0x8704, 0x8d67, 0x9377, 0x4aac, 0x5d89, 0x5bd5, 0x5bd4, 0x6316,
  0x79bf, 0x7b59, 0x869f, 0x8726, 0x87b0, 0x8b13, 0x9494, 0x53c6,
  0x5db4, 0x5e9f, 0x5fdd, 0x622a, 0x6397, 0x6c88, 0x6fc2, 0x7569,
  0x7b78, 0x88ba, 0x88ee, 0x948c, 0x9f48, 0x8505, 0x8887, 0x9241,
  0x9e4d, 0x9aa8, 0x5f52, 0x681e, 0x7716, 0x72ff, 0x72d2, 0x8001,
  0x55a7, 0x8d9e, 0x5540, 0x5598, 0x56c4, 0x6cc4, 0x6899, 0x7309,
  0x732d, 0x79b2, 0x79e1, 0x936f, 0x9ab8, 0x6ac8,
  /* 0x59 */
  0x811c, 0x55a8, 0x5000, 0x5070, 0x6203, 0x6290, 0x6d2a, 0x6a92,
  0x72b2, 0x739c, 0x871a, 0x80cf, 0x8392, 0x9564, 0x9695, 0x98f9,
  0x8c8f, 0x4ba3, 0x559f, 0x56d2, 0x5dcb, 0x5a30, 0x6558, 0x6075,
  0x6074, 0x62a3, 0x63dd, 0x6e2c, 0x6fc0, 0x6fd6, 0x7652, 0x766c,
  0x704c, 0x7335, 0x73d6, 0x841a, 0x86b1, 0x8708, 0x8f0d, 0x8f25,
  0x8881, 0x6325, 0x689d, 0x766a, 0x72e3, 0x736b, 0x7e4b, 0x99a4,
  0x6f72, 0x689f, 0x5d2f, 0x632b, 0x8094, 0x5762, 0x5c9e, 0x5d94,
  0x5ad2, 0x67c2, 0x6239, 0x637e, 0x6a37, 0x7726, 0x7eda, 0x86da,
  0x9725, 0x56d4, 0x59e6, 0x65a3, 0x65c6, 0x6607, 0x66ca, 0x60a6,
  0x61ed, 0x6d54, 0x6f6b, 0x6fc6, 0x752c, 0x77fa, 0x7150, 0x7a4b,
  0x8613, 0x870f, 0x8167, 0x8eae, 0x88b2, 0x932a, 0x996c, 0x5ca5,
  0x9ad5, 0x541c, 0x5603, 0x5036, 0x5142, 0x618a,
  /* 0x5a */
  0x687b, 0x7907, 0x7906, 0x8453, 0x8287, 0x918d, 0x92e2, 0x56f2,
  0x6898, 0x7664, 0x507e, 0x5e97, 0x5833, 0x5946, 0x5b41, 0x5ba3,
  0x6327, 0x6cbb, 0x6d6e, 0x6a31, 0x6a49, 0x7304, 0x787e, 0x7b83,
  0x818a, 0x8f03, 0x8bfa, 0x936c, 0x9af9, 0x58ba, 0x64bb, 0x6500,
  0x65a6, 0x6142, 0x61f6, 0x61f1, 0x681c, 0x68e2, 0x7792, 0x77c4,
  0x79ec, 0x9199, 0x5fcb, 0x8311, 0x8f1d, 0x5650, 0x5757, 0x66c0,
  0x6002, 0x60bf, 0x6339, 0x6e35, 0x68c7, 0x77cd, 0x7093, 0x7f99,
  0x7898, 0x7a16, 0x8587, 0x863b, 0x8189, 0x8be6, 0x92f4, 0x9dcc,
  0x4b39, 0x5747, 0x57c0, 0x57d6, 0x66c1, 0x6021, 0x610d, 0x619c,
  0x6dce, 0x68e3, 0x6b55, 0x77e0, 0x7159, 0x722f, 0x72e9, 0x72f1,
  0x7cdd, 0x7cf6, 0x7d21, 0x794b, 0x8621, 0x83ed, 0x8bd9, 0x9c1f,
  0x9ce2, 0x56ce, 0x66d9, 0x60a8, 0x6a29, 0x6b5c,
  /* 0x5b */
  0x7271, 0x89c6, 0x95bc, 0x966f, 0x9ee3, 0x9f4e, 0x542e, 0x5480,
  0x5347, 0x5da5, 0x5825, 0x5a4a, 0x5b7a, 0x6632, 0x6133, 0x61b4,
  0x61cc, 0x6204, 0x6386, 0x6d91, 0x6acf, 0x7cc8, 0x792c, 0x84a7,
  0x858d, 0x8626, 0x86be, 0x80ac, 0x8281, 0x8e27, 0x8f1a, 0x94ab,
  0x923f, 0x9b9d, 0x5400, 0x4bfe, 0xfd6e, 0x53f4, 0x5b95, 0x66d1,
  0x679f, 0x6362, 0x6a4e, 0x7514, 0x72ce, 0x84c1, 0x84d7, 0x8cf9,
  0x8cf8, 0x8d14, 0x88ed, 0x8b24, 0x9540, 0x9267, 0x4b22, 0x4b7d,
  0x5a16, 0x63c2, 0x6c2f, 0x7270, 0x7273, 0x9f49, 0x5a6c, 0x6e07,
  0x7564, 0x75d9, 0x7167, 0xfd69, 0x7a4c, 0x814e, 0x81e4, 0x9cd1,
  0x4b1d, 0x7f42, 0x7b7d, 0x91a8, 0x55ec, 0x5a0b, 0x6cb8, 0x6833,
  0x6843, 0x68d6, 0x76a2, 0x7fc9, 0x870e, 0x68d8, 0x7037, 0x54f6,
  0x5685, 0x5ccc, 0x60d5, 0x6e9a, 0x70aa, 0x725b,
  /* 0x5c */
  0x7caa, 0x821a, 0x91ef, 0x9334, 0xfd68, 0x5753, 0x5b0c, 0x8f87,
  0x8ba5, 0x8ba2, 0x9487, 0x5628, 0x73a8, 0x9844, 0x9b05, 0x4a14,
  0x540f, 0x5578, 0x5856, 0x5a7a, 0x6213, 0x6237, 0x63c9, 0x6cc8,
  0x74be, 0x710c, 0x71c8, 0x7dc4, 0x7ed0, 0x8b2a, 0x9d2d, 0x9e05,
  0x4bd0, 0x5c2c, 0x5c3c, 0x5ffb, 0x6263, 0x6f68, 0x691c, 0x6a77,
  0x6b70, 0x77e9, 0x7126, 0x87e4, 0x8cd1, 0x8d1e, 0x8f51, 0x8b19,
  0x4b02, 0x54d8, 0x571d, 0x5751, 0x5f9e, 0x5ba4, 0x6300, 0x7d82,
  0x8574, 0x8722, 0x8119, 0x8d0a, 0x8d8b, 0x8b34, 0x8b36, 0x9da8,
  0x981f, 0x6321, 0x4a7b, 0x4bf5, 0x5d44, 0x580c, 0x58e2, 0x58fd,
  0x676a, 0x6cdf, 0x74f0, 0x75af, 0x7026, 0x7a26, 0x80e1, 0x830f,
  0x942f, 0x96df, 0x98fe, 0x4a00, 0x4ad5, 0x4be2, 0x5488, 0x565b,
  0x5662, 0x502b, 0x509d, 0x53ed, 0x5d26, 0x5e6b,
  /* 0x5d */
  0x5f57, 0x5f78, 0x5fc1, 0x5a91, 0xfd6b, 0x667b, 0x617a, 0x61aa,
  0x6963, 0x6aa8, 0x763b, 0x7f2b, 0x7832, 0x7b3b, 0x855d, 0x855c,
  0x8597, 0x864d, 0x8694, 0x87a4, 0x8e0e, 0x88ad, 0x88eb, 0x88f6,
  0x8979, 0x89b7, 0x94e5, 0x95d1, 0x9211, 0x9249, 0x9dd4, 0x98ea,
  0x571a, 0x560b, 0x5024, 0x5279, 0x5cbe, 0x5d59, 0x5d63, 0x5bf2,
  0x65a9, 0x6663, 0x621d, 0x6873, 0x7517, 0x72cb, 0x7884, 0x78d3,
  0x7916, 0x86a1, 0x88cc, 0x92fd, 0xfd6a, 0x4b56, 0x5b1a, 0x5b72,
  0x66cf, 0x5924, 0x6306, 0x6cd7, 0x7c71, 0x7a4e, 0x9961, 0x4a18,
  0x5494, 0x5718, 0x5727, 0x575c, 0x5d8e, 0x5e6f, 0x5a8a, 0x64bf,
  0x6587, 0x6644, 0x6674, 0x619d, 0x638a, 0x6daa, 0x6fd9, 0x6fdb,
  0x6fda, 0x6fd5, 0x68b5, 0xfd65, 0x7038, 0x71f7, 0x7c1f, 0x7c9c,
  0x7dd8, 0x7dd5, 0x788e, 0x79c6, 0x7bec, 0x84a8,
  /* 0x5e */
  0x8533, 0x85cf, 0x87ff, 0x8317, 0x8ce5, 0x8eb4, 0x8f61, 0x88b6,
  0x9514, 0x9353, 0x9cd6, 0x9b36, 0x52a1, 0x5f27, 0x5b61, 0x6181,
  0x6ebe, 0x6fa2, 0x6951, 0x6bfc, 0x7418, 0x7650, 0x77a0, 0x88aa,
  0x88de, 0x9c36, 0x659c, 0x683a, 0x8455, 0x9e0c, 0x4a40, 0x4a86,
  0x4a96, 0x4ad8, 0x4b37, 0x4b31, 0x4b72, 0x4bd2, 0x54f2, 0x57ff,
  0x57f5, 0x510b, 0x51ee, 0x52d6, 0x5ce6, 0x5d6f, 0x5e1c, 0x5fe6,
  0x5ff7, 0x5809, 0x59fe, 0x5a26, 0x5b94, 0x6410, 0x6765, 0x6191,
  0x61a2, 0x63fb, 0x63f6, 0x6ca0, 0x6f76, 0x6894, 0x68da, 0x6a2e,
  0x7404, 0x7748, 0x7c0f, 0x7d33, 0x7d4d, 0x7d6d, 0x7dcc, 0x7fe4,
  0x791a, 0x797f, 0x848b, 0x8600, 0x8783, 0x80dc, 0x82ca, 0x8cd2,
  0x8e5d, 0x8e53, 0x8f10, 0x88d1, 0x896b, 0x8ba0, 0x94a7, 0x9cf1,
  0x9dd2, 0x9a90, 0x5647, 0xfd64, 0x6319, 0xfd67,
  /* 0x5f */
  0x5495, 0x5627, 0x587c, 0x616e, 0x6858, 0x77c7, 0x712e, 0x7190,
  0x7f9a, 0x8091, 0x9575, 0x933d, 0x4a7a, 0x609f, 0x6fb7, 0x7553,
  0x81a4, 0x4a04, 0xfd66, 0x6344, 0x6ce3, 0x6a1a, 0x8692, 0x8115,
  0x8c66, 0x67fa, 0x6b8c, 0x961f, 0x9ca2, 0x4a07, 0x54ba, 0x54c2,
  0x5512, 0x514b, 0x51a7, 0x521a, 0x5f4d, 0x5814, 0x58ed, 0x5a35,
  0x5a87, 0x5aad, 0x5acf, 0x64fe, 0x6c5c, 0x6e6c, 0x6a55, 0x7630,
  0x764d, 0x76cd, 0x72f5, 0x7d68, 0x7fbc, 0x7bd9, 0x8cfe, 0x8df9,
  0x8e7e, 0x886c, 0x88d3, 0x9311, 0x5c53, 0x70b0, 0x88f0, 0x51ca,
  0xfd61, 0x7e6c, 0x792f, 0x867f, 0x767f, 0x7112, 0x7128, 0xfd60,
  0x7f14, 0x5c88, 0x5cf6, 0x59b1, 0x5a82, 0x5abb, 0x5b9d, 0x6458,
  0x669f, 0x6772, 0x6140, 0x629c, 0x62d4, 0x62f5, 0x6c1b, 0x6cff,
  0x768d, 0x7053, 0x7f63, 0x7963, 0x79db, 0x7b7f,
  /* 0x60 */
  0x84e8, 0x861f, 0x81a2, 0x8d72, 0x8e9e, 0x9410, 0x96e9, 0x9ac0,
  0x9b2d, 0x5d18, 0x5d60, 0x5a20, 0x64d1, 0x6219, 0x627e, 0x639d,
  0x685d, 0x69c8, 0x6b52, 0x73fe, 0x7ca4, 0x80cb, 0x95c6, 0x9726,
  0x4ad4, 0x54c7, 0x5545, 0x5189, 0x5f06, 0x5fae, 0x664a, 0x6173,
  0x61c6, 0x6a3f, 0x7570, 0x700c, 0x7049, 0x708a, 0x70b2, 0x7261,
  0x7da7, 0x79d7, 0x7a58, 0x7ba5, 0x8577, 0x85be, 0x8634, 0x8217,
  0x83e1, 0x8e78, 0x89ee, 0x9475, 0x969c, 0x9028, 0x9d40, 0x9fa3,
  0x5765, 0x585c, 0x6d59, 0x68c9, 0x6924, 0x6a26, 0x8601, 0x8196,
  0x8d36, 0x8e20, 0x8ea7, 0x92e7, 0x9b6a, 0x566c, 0x62b4, 0x6fbf,
  0x7a9b, 0x83f3, 0x8900, 0x918e, 0x9250, 0x6110, 0x6984, 0x75e3,
  0xfd63, 0x53c3, 0x5dde, 0x5fa1, 0x642a, 0x64f7, 0x661d, 0x6212,
  0x6252, 0x7724, 0x77f4, 0x72d6, 0x730c, 0x7f61,
  /* 0x61 */
  0x845b, 0x847f, 0x8568, 0x8ead, 0x959f, 0x4a1b, 0x56ef, 0x6f7f,
  0x691a, 0x7e08, 0x7f34, 0x793d, 0xfd62, 0x88bd, 0x57e1, 0x5222,
  0x5c5c, 0x5fb8, 0x5802, 0x581c, 0x59ef, 0x664d, 0x678e, 0x6019,
  0x6220, 0x6cbe, 0x68b1, 0x6985, 0x6aa2, 0x7412, 0x74a9, 0x75df,
  0x712b, 0x7182, 0x7183, 0x7214, 0x7f1c, 0x7fed, 0x7826, 0x792d,
  0x7934, 0x8121, 0x8160, 0x820a, 0x8e39, 0x9400, 0x946c, 0x94b8,
  0x96ba, 0x93fb, 0x9e3a, 0x4bda, 0x5861, 0x6352, 0x699c, 0x7892,
  0x7a81, 0x8f1b, 0x891b, 0x9412, 0x5f66, 0x59f0, 0x6000, 0x80cd,
  0x9451, 0x9cec, 0x778a, 0x5f86, 0x6497, 0x6373, 0x69d3, 0x8e12,
  0x8eab, 0x940c, 0x9c01, 0x563a, 0xfd7d, 0x745c, 0x7c83, 0x979b,
  0x8c7d, 0x95da, 0x4be3, 0x57da, 0x51f0, 0x52d7, 0x538f, 0x5cf0,
  0x5ecf, 0x5f85, 0x58a6, 0x58cd, 0x5a28, 0x650c,
  /* 0x62 */
  0x6600, 0x6646, 0x6785, 0x6011, 0x613b, 0x6175, 0x6e34, 0x6f87,
  0x6839, 0x6914, 0x6b3c, 0x75ea, 0x76e4, 0x7775, 0x700a, 0x70bf,
  0x722b, 0x736c, 0x7dcd, 0x7e5a, 0x7ee7, 0x78b4, 0x7982, 0x79a1,
  0x7a6c, 0x7b93, 0x8524, 0x873c, 0x809d, 0x80d7, 0x81e7, 0x8c9b,
  0x8ebd, 0x8f9d, 0x8b35, 0x944f, 0x948e, 0x9561, 0x969b, 0x96b4,
  0x9286, 0x92aa, 0x92a5, 0x92db, 0x930d, 0x9c05, 0x9d9b, 0x9ede,
  0x9f17, 0x57d9, 0x5c73, 0x5d14, 0x5f7d, 0x5fb2, 0x69dc, 0x6b57,
  0x7592, 0x702c, 0x70b4, 0x8488, 0x87f0, 0x59ec, 0x5b8a, 0x5ba7,
  0x644f, 0x61e1, 0x6c1f, 0x6d62, 0x6e5e, 0x6f84, 0x6938, 0x69fe,
  0x77ee, 0x72f3, 0x73a1, 0x7f40, 0x7919, 0x852e, 0x8611, 0x874d,
  0x80f9, 0x816e, 0x8e6f, 0x8ec9, 0x958a, 0x9713, 0x9c0b, 0x9db9,
  0x6601, 0x8c5e, 0x8bfd, 0x9668, 0x590a, 0x592a,
  /* 0x63 */
  0x5964, 0x7052, 0x8590, 0x8365, 0x6bd8, 0x66f3, 0x7bdf, 0x8d3b,
  0x8d7f, 0x4a13, 0x4a55, 0x54ea, 0x56d0, 0x574a, 0x6672, 0x620a,
  0x7a64, 0x8c08, 0x9253, 0x4b80, 0x5714, 0x523b, 0x5dc6, 0x5ea9,
  0x5835, 0x5843, 0x5840, 0x5a0f, 0x5b1c, 0x644e, 0x61b0, 0x6222,
  0x624f, 0x63b3, 0x63f9, 0x7711, 0x73ef, 0x7d37, 0x7bc8, 0x8099,
  0x80c0, 0x8d9b, 0x8e6b, 0x8e64, 0x8eec, 0x8858, 0x8877, 0x53f9,
  0x5fd9, 0x5b02, 0x6462, 0x66e0, 0x6d00, 0x6f9b, 0x6a51, 0x7589,
  0x7fdf, 0x8358, 0x8f55, 0x8af3, 0x9cd2, 0x9cf3, 0x4b35, 0x4b8c,
  0x4bec, 0x5076, 0x5e2d, 0x5fb5, 0x6531, 0x61bd, 0x6265, 0x75f1,
  0x713e, 0x7d53, 0x793e, 0x8543, 0x85ee, 0x8795, 0x81a7, 0x81c3,
  0x830e, 0x8e07, 0x8aa6, 0x8b96, 0xfd7c, 0x8bc8, 0x5d3c, 0x5fa9,
  0x5feb, 0x6484, 0x5fe4, 0x5806, 0x5bce, 0x688c,
  /* 0x64 */
  0xfd7f, 0x69fc, 0x7406, 0x7117, 0x86a2, 0x8efb, 0x4acd, 0x574c,
  0xfd7e, 0x92d4, 0x6802, 0x4a93, 0x4bc9, 0x555f, 0x5153, 0x5e28,
  0x58e5, 0x661c, 0x7654, 0x86b0, 0x87a7, 0x82f3, 0x8c54, 0x8e10,
  0x9232, 0x92c8, 0x9d1e, 0x9904, 0x9950, 0x5c07, 0x58be, 0x59b0,
  0x5a49, 0x64ec, 0x6518, 0x67ec, 0x6e0f, 0x6a28, 0x950f, 0x9759,
  0x9c43, 0x981d, 0x9b7a, 0x5f84, 0x58b5, 0x6704, 0x6242, 0x6c45,
  0x7331, 0x92cc, 0x9380, 0x9c59, 0x9f92, 0x61ac, 0x8f0c, 0x8ac6,
  0x91b1, 0x5138, 0x58a4, 0x59db, 0x5ab8, 0x629a, 0x7241, 0x87f9,
  0x91ca, 0x5cde, 0x66b1, 0x76c3, 0x9925, 0x4afd, 0x5d23, 0x6402,
  0x6236, 0x6f8e, 0x7dea, 0x992b, 0x579e, 0x50cd, 0x53ce, 0x591b,
  0x6516, 0x62db, 0x69a2, 0x7c80, 0x8673, 0x9295, 0x9349, 0x5789,
  0x6671, 0x679b, 0x69bf, 0x7a07, 0x8546, 0x9c40,
  /* 0x65 */
  0x6ef6, 0x7b41, 0x99a2, 0x9a17, 0x4a52, 0x5436, 0x55bb, 0x5d11,
  0x64f4, 0x67fb, 0x6d3d, 0x7637, 0x843b, 0xfd79, 0x95c3, 0x5b3c,
  0xfd78, 0xfd7b, 0x7909, 0x86e8, 0x8062, 0x80b6, 0x81e8, 0x8a80,
  0xfd7a, 0x4b62, 0xfd75, 0xfd74, 0x5ce9, 0x5f4e, 0x6454, 0x67d7,
  0x6115, 0x6160, 0x6295, 0xfd77, 0x6d47, 0x6e2e, 0x6906, 0x740c,
  0x7561, 0x71df, 0x7200, 0x7dbe, 0x7e7d, 0xfd76, 0x7b87, 0xfd71,
  0x8d49, 0xfd70, 0x8f9e, 0x95cd, 0x9270, 0xfd73, 0x9d07, 0x5309,
  0x5bac, 0x61b1, 0x6b0c, 0x720d, 0x7dab, 0x8e93, 0x9da0, 0x9f57,
  0x9b61, 0x5509, 0x65bb, 0x669c, 0x6e80, 0x85cb, 0x544e, 0x5c3d,
  0x5b6b, 0x7504, 0x8e0d, 0x8ef7, 0x5f71, 0x821b, 0x4bf7, 0x5531,
  0x52b9, 0x5d49, 0x67a4, 0x69f4, 0x59a7, 0x6d60, 0x558b, 0x4a85,
  0x4b54, 0xfd72, 0xfd8d, 0xfd8c, 0x5d8f, 0xfd8f,
  /* 0x66 */
  0xfd8e, 0x6f52, 0x6850, 0xfd89, 0x70b8, 0x7d1b, 0xfd88, 0x860a,
  0x8648, 0x8734, 0x8b32, 0x8b50, 0xfd8b, 0x9d15, 0xfd8a, 0xfd85,
  0xfd84, 0x4aab, 0xfd87, 0x53d2, 0x5b74, 0x621e, 0xfd86, 0xfd81,
  0x71a6, 0x7a74, 0x8f62, 0xfd80, 0x940b, 0x9e56, 0x52a8, 0x5c2a,
  0x5df5, 0x5e12, 0x5fb9, 0xfd83, 0x5afb, 0xfd82, 0xfd9d, 0x675d,
  0x6736, 0xfd9c, 0x6d30, 0x688a, 0x68b2, 0x6983, 0x699e, 0x69f8,
  0x6b19, 0xfd9f, 0x74d2, 0x753b, 0x7554, 0xfd9e, 0x75ce, 0x75d8,
  0xfd99, 0x7c42, 0x7c62, 0xfd98, 0x7f78, 0x79ee, 0xfd9b, 0x7a22,
  0xfd9a, 0x8c40, 0x8ad2, 0xfd95, 0xfd94, 0xfd97, 0x9656, 0xfd96,
  0x98fb, 0xfd91, 0xfd90, 0xfd93, 0x6488, 0x6988, 0xfd92, 0x75bc,
  0xfdad, 0xfdac, 0x91bc, 0x57a0, 0xfdaf, 0xfdae, 0xfda9, 0x63de,
  0xfda8, 0x7483, 0x753d, 0x703d, 0x867b, 0x86df,
  /* 0x67 */
  0xfdab, 0x91b6, 0x9ee8, 0x9a70, 0x62c9, 0xfdaa, 0x75cc, 0x8044,
  0xfda5, 0xfda4, 0x5c46, 0xfda7, 0xfda6, 0x59b5, 0x5b7c, 0xfda1,
  0x622d, 0x6283, 0x6d74, 0x6da3, 0x6835, 0x68fe, 0x6a3b, 0x6b4c,
  0x6bd7, 0x7416, 0x7422, 0x755d, 0x75d2, 0x777d, 0xfda0, 0x7056,
  0xfda3, 0x70d9, 0x72c5, 0x7e43, 0x7a9e, 0xfda2, 0xfdbd, 0x86fc,
  0x8e6d, 0x8bc3, 0xfdbc, 0x9745, 0xfdbf, 0x9314, 0xfdbe, 0xfdb9,
  0x4a4f, 0x5427, 0xfdb8, 0x5605, 0x57ec, 0x62fe, 0x6860, 0x6bc7,
  0x7707, 0x7372, 0x7e6f, 0x86a3, 0x81d0, 0x820f, 0xfdbb, 0x8cd9,
  0x8e6e, 0x8f70, 0x8866, 0xfdba, 0x96be, 0xfdb5, 0x931e, 0x9c1d,
  0x4a99, 0x4b00, 0x4bc4, 0x54bf, 0x5745, 0x5033, 0x503e, 0x51d7,
  0x5c6f, 0x5cb7, 0x5d6a, 0x5e16, 0x5fe9, 0x6492, 0xfdb4, 0x65c7,
  0x615b, 0x61f2, 0x6269, 0x6caa, 0x6857, 0x6bbe,
  /* 0x68 */
  0x74c2, 0x75a1, 0x775f, 0x7f70, 0x8305, 0x8ea9, 0x983f, 0x9b0a,
  0x5846, 0x688e, 0x7749, 0x7784, 0x9637, 0x6aa6, 0x7068, 0x7212,
  0x7e64, 0x7a18, 0x8207, 0x554d, 0x5cc8, 0x60cc, 0x70e3, 0x7118,
  0x727d, 0x7bcc, 0x9498, 0x92c0, 0x9d59, 0x6a2b, 0x70eb, 0x7ea4,
  0x7ea7, 0x85e8, 0x82d4, 0x8375, 0x8e16, 0x5e44, 0x5f81, 0x5f96,
  0x6cac, 0x6d0d, 0x696e, 0x77a4, 0x701e, 0x7021, 0x7c9a, 0x79e4,
  0x7be6, 0x8515, 0x8558, 0x8793, 0x8841, 0x9223, 0x9c1c, 0x62fd,
  0x5b8d, 0x61f7, 0x6384, 0x6867, 0x7786, 0x5420, 0x5e0e, 0x6f67,
  0x73e3, 0x5d1b, 0x5961, 0x59c0, 0x7728, 0x7142, 0xfdb7, 0xfdb6,
  0x54e8, 0x55f4, 0x5c22, 0x5d20, 0x5d9b, 0x5dd7, 0x5fe8, 0xfdb1,
  0xfdb0, 0x59af, 0x66da, 0x601b, 0x609e, 0x60f3, 0xfdb3, 0x62d1,
  0xfdb2, 0x6e45, 0xfdcd, 0x75f2, 0x7069, 0xfdcc,
  /* 0x69 */
  0x7e85, 0x7ea2, 0x7a4a, 0x7a53, 0x840d, 0x857d, 0xfdcf, 0x83e2,
  0x8d8c, 0x8f2d, 0x9454, 0xfdce, 0x948d, 0x9d5f, 0x6573, 0x6f3f,
  0x6979, 0x7a12, 0x8d28, 0x8bbc, 0x4bdc, 0x54a0, 0x559a, 0x56ca,
  0x53ca, 0x5c84, 0x5fb4, 0x5ab5, 0x654f, 0x6d98, 0x6981, 0x6a6a,
  0x6abb, 0x7599, 0x706f, 0x7125, 0x7121, 0x847e, 0x8735, 0x80c4,
  0x8a07, 0x9799, 0x97d3, 0xfdc9, 0x4a83, 0x4b5c, 0x547b, 0x5527,
  0x57c5, 0x57c6, 0x57fe, 0x5f8a, 0x5fde, 0x5829, 0x6517, 0x658f,
  0x61f9, 0x7656, 0x779a, 0x704d, 0x72cf, 0x7d5d, 0x7d9c, 0x7db4,
  0x790b, 0x7bb0, 0x8686, 0x81d8, 0x8253, 0x8bcf, 0x944a, 0x94f8,
  0x95e7, 0x9288, 0x92e5, 0x92e4, 0x56db, 0x5b6a, 0x61e0, 0x623c,
  0x6c22, 0x7551, 0x7e3b, 0x94cc, 0x9c07, 0x4a9c, 0xfdc8, 0x6e5f,
  0x6f93, 0x6b9d, 0x7584, 0x8415, 0x86b5, 0x815e,
  /* 0x6a */
  0x9446, 0x9298, 0x92ff, 0x93f6, 0x8117, 0x9f3c, 0x4a9d, 0x7587,
  0x92c9, 0x554e, 0x5792, 0x50ec, 0x531e, 0x531f, 0x53ae, 0x5e96,
  0x5ec9, 0x5fce, 0x6425, 0x6532, 0x67f9, 0x6888, 0x6934, 0x6a7f,
  0x6a9d, 0x763d, 0x7732, 0x705a, 0x86dc, 0x8c8c, 0x8b48, 0x946d,
  0xfdcb, 0x926f, 0x9c55, 0x9916, 0x6305, 0x8987, 0x9653, 0x4b40,
  0x5444, 0x54d3, 0x577c, 0x5300, 0x5dd9, 0x5e0c, 0x5804, 0x657d,
  0x629d, 0x6a20, 0x763f, 0x7046, 0x79e2, 0x84ce, 0x8003, 0x806b,
  0x8132, 0x8352, 0x8c56, 0x8d15, 0x8f0f, 0x9458, 0x93c6, 0x9f42,
  0x4a7e, 0x4b9c, 0x551f, 0x5567, 0xfdca, 0x5122, 0x51a4, 0x5f77,
  0x5fa8, 0x5a71, 0x5a70, 0x5ab3, 0x64ad, 0x64d2, 0x6505, 0x6504,
  0x67c9, 0x6135, 0x6304, 0xfdc5, 0x63d9, 0x63d7, 0xfdc4, 0x6d6c,
  0x6d6f, 0x68b4, 0x692a, 0xfdc7, 0x6a35, 0xfdc6,
  /* 0x6b */
  0x6bec, 0x773b, 0x773a, 0xfdc1, 0x7051, 0x713c, 0xfdc0, 0x725f,
  0xfdc3, 0xfdc2, 0x79a0, 0x85f3, 0x8035, 0x8cd8, 0x8e95, 0x8ed6,
  0x8ee0, 0x8a3d, 0x8a4f, 0x9447, 0x9433, 0x9477, 0x9544, 0x95c4,
  0x9763, 0xfddd, 0xfddc, 0x5c04, 0xfddf, 0x6fde, 0x8484, 0x84bf,
  0xfdde, 0xfdd9, 0x554c, 0x5d66, 0x5834, 0xfdd8, 0xfddb, 0x6b69,
  0x77aa, 0x84e9, 0x890a, 0xfdda, 0x961a, 0x9182, 0xfdd5, 0xfdd4,
  0xfdd7, 0xfdd6, 0x8472, 0x6603, 0x7411, 0x7965, 0x8380, 0xfdd1,
  0x53ad, 0x6464, 0x654a, 0x6fba, 0x8eb3, 0x968d, 0x92bc, 0x4a54,
  0x5012, 0x69e6, 0x8120, 0x927d, 0x93fe, 0x9ce3, 0x67db, 0x68ee,
  0x949c, 0x55d0, 0x65c4, 0x85b7, 0x99f4, 0x4b90, 0x5417, 0x550d,
  0x5f91, 0x6502, 0x65f2, 0x60e1, 0x6d08, 0x6fc8, 0x719c, 0x73ee,
  0x7ba4, 0x8669, 0x8182, 0x83f6, 0x8c6e, 0x8eb1,
  /* 0x6c */
  0x8f7d, 0x95a6, 0x4a81, 0x4ae8, 0x4b07, 0xfdd0, 0xfdd3, 0x5d3a,
  0x5de5, 0xfdd2, 0x59ff, 0x5b16, 0x5b56, 0x642c, 0xfded, 0xfdec,
  0xfdef, 0xfdee, 0x7633, 0x77e8, 0xfde9, 0x717d, 0x71c0, 0xfde8,
  0x7df6, 0xfdeb, 0x8401, 0x843e, 0x8489, 0x86ec, 0x875c, 0xfdea,
  0xfde5, 0x88b0, 0x88be, 0x948a, 0xfde4, 0xfde7, 0x9cf9, 0x9d01,
  0xfde6, 0xfde1, 0x743a, 0x72c7, 0x7bc7, 0x7bc1, 0x7bf1, 0x8f17,
  0x4ab7, 0x4acc, 0x560e, 0x577d, 0xfde0, 0x50b0, 0x52ed, 0x5df6,
  0x5fc8, 0x5b18, 0x5bc0, 0x6a63, 0xfde3, 0xfde2, 0x7967, 0x8738,
  0xfdfd, 0x829e, 0x8e80, 0xfdfc, 0x9360, 0x937a, 0xfdff, 0xfdfe,
  0x4a0d, 0x4b57, 0x4b73, 0x5cf4, 0x61e8, 0x6aaf, 0x9435, 0x97bd,
  0x9db4, 0x4af6, 0x5ce1, 0x5d87, 0x5dd4, 0x644c, 0xfdf9, 0xfdf8,
  0x7e19, 0xfdfb, 0x8742, 0x88ce, 0x5568, 0x5749,
  /* 0x6d */
  0xfdfa, 0xfdf5, 0xfdf4, 0x4ac0, 0x5664, 0x5f58, 0x86b2, 0x4ad9,
  0x5637, 0x50a5, 0x5dc4, 0x5df2, 0x5f5d, 0x5f5a, 0x5f51, 0x646e,
  0x6545, 0x6ac6, 0x7494, 0x7563, 0x778b, 0x70fa, 0x71b8, 0x7ccc,
  0x7926, 0x8408, 0x85e7, 0x8725, 0x811a, 0x81c4, 0x8ee3, 0x88ca,
  0x92c1, 0x4b51, 0x56f7, 0x52b1, 0x61a6, 0x6225, 0x7471, 0x74b5,
  0x7638, 0x79b0, 0x8680, 0x9541, 0x92cd, 0x997f, 0x5f7c, 0x6cea,
  0x6f95, 0x6b77, 0x72d3, 0x589c, 0x62a6, 0x6b56, 0x7fb9, 0x7827,
  0x8c3b, 0x92d1, 0x4a05, 0x4ada, 0x572d, 0x5c39, 0x5cb6, 0x5ce2,
  0x5d61, 0x580a, 0x5a3e, 0x5a89, 0x5b38, 0x6781, 0x62bf, 0x635b,
  0x6e12, 0x6eae, 0x6f01, 0x6b32, 0x764b, 0xfdf7, 0x775d, 0x7086,
  0x7eed, 0x78aa, 0x8575, 0x85d2, 0x85ea, 0x8787, 0x8061, 0x812e,
  0x8199, 0x81c2, 0x8cd0, 0x891e, 0x95a1, 0x917a,
  /* 0x6e */
  0x9291, 0x5580, 0x50c4, 0x5325, 0x5fbd, 0x6640, 0x635d, 0x6c30,
  0x6c9e, 0x6a30, 0x6ade, 0x7470, 0x7a2c, 0x8ccc, 0x88ac, 0x8b04,
  0x9b46, 0x9b43, 0x7620, 0x7f82, 0x8ec0, 0x9717, 0x4b4a, 0x4b43,
  0x553f, 0x508d, 0x5ddd, 0x5a98, 0x66b8, 0x6378, 0x6d63, 0x6e1a,
  0x68a3, 0x6a17, 0x76d4, 0x7727, 0x71b0, 0x7fb5, 0x7938, 0x86ea,
  0x87f4, 0x805a, 0x81fa, 0x8e56, 0x88a2, 0x8a8a, 0x9414, 0x94b5,
  0x92c3, 0x9b52, 0x56ee, 0x5007, 0x5eec, 0x5fcf, 0x6055, 0x6178,
  0x6af9, 0x76c9, 0xfdf6, 0x7289, 0x7e40, 0x7f16, 0x7840, 0x7a33,
  0x7bd2, 0x8776, 0x8f26, 0x88c7, 0x8969, 0x89ec, 0x8a52, 0x8be7,
  0x8bf4, 0x9464, 0x97dc, 0x4b4e, 0x4b77, 0x54be, 0x5565, 0x5575,
  0x5640, 0x5667, 0x5c6c, 0x5c71, 0x5d6d, 0x5805, 0x5858, 0x5ad6,
  0x6496, 0x663d, 0x6c1e, 0x6fb2, 0x6805, 0x6bbc,
  /* 0x6f */
  0x7543, 0x702d, 0x713d, 0x7135, 0x715c, 0x727f, 0x7f41, 0x7f86,
  0x7fa0, 0x7fcb, 0x7a82, 0x8e63, 0x8b33, 0x8b44, 0x9632, 0x969e,
  0x972f, 0x9026, 0x92f6, 0x9c57, 0x9c66, 0x9d13, 0x560a, 0x6627,
  0x6695, 0x6954, 0x7269, 0x7ec7, 0x7fcd, 0x797b, 0x576d, 0x58b3,
  0x5a9a, 0x6b35, 0x74b4, 0x7895, 0x931c, 0x9f83, 0x9ad3, 0x67a8,
  0x6077, 0x837b, 0x4a0c, 0x4a98, 0x4aa0, 0x5451, 0x5478, 0x5045,
  0x5dce, 0x5f97, 0x5a4d, 0x5aa0, 0x5afa, 0x5b8c, 0x64c8, 0x6737,
  0x6132, 0x6179, 0x61c1, 0x627b, 0x6275, 0x63f3, 0x6d65, 0x6e84,
  0x6f6e, 0x684d, 0x69cd, 0x69e5, 0x6a12, 0x6a53, 0x7413, 0x74ac,
  0x7783, 0x77f0, 0x7137, 0x7356, 0x7c8a, 0x7d83, 0x7e06, 0x7e70,
  0x78b3, 0x7983, 0x864a, 0x8e0f, 0x8ee7, 0x8893, 0x9520, 0x9547,
  0x95d5, 0x966b, 0x96c1, 0x972d, 0x930b, 0x935b,
  /* 0x70 */
  0x9351, 0x9c0f, 0x9b03, 0x563b, 0x569c, 0x5171, 0x5c29, 0x5a10,
  0x5b12, 0x6481, 0x67dd, 0x6ca2, 0x6bd2, 0x7d60, 0x7f21, 0x85c0,
  0x81b7, 0x8cf0, 0x8ef5, 0x8a49, 0x9580, 0x9269, 0x9296, 0x9330,
  0x9c41, 0x9b47, 0x4bc3, 0x554b, 0x55c6, 0x56a4, 0x523f, 0x5b19,
  0x5b66, 0x67a7, 0x60c0, 0x61e4, 0x624c, 0x62f7, 0x62f4, 0x6310,
  0x6c90, 0x6cda, 0x6df0, 0x6b18, 0x6b63, 0x756a, 0x75e8, 0x7627,
  0x70a7, 0x7337, 0x7d5b, 0x7d57, 0x7dd2, 0x7e2d, 0x7e98, 0x789a,
  0x78d2, 0x7949, 0x7a7d, 0x848a, 0x81f6, 0x82a9, 0x8e59, 0x8eb2,
  0x8994, 0x8a8c, 0x942d, 0x9460, 0x95ee, 0x9236, 0x92d8, 0x98e8,
  0x61c2, 0x780a, 0x89be, 0x97ce, 0x5f55, 0x5807, 0x575f, 0x66d4,
  0x7710, 0x542a, 0x5f9a, 0x5b93, 0x64bd, 0x6566, 0x6cd8, 0x69d4,
  0x7023, 0x7e23, 0x794f, 0x7991, 0x7a3c, 0x8566,
  /* 0x71 */
  0x8a27, 0x8a38, 0x9773, 0x9015, 0x4b5d, 0x535d, 0x59eb, 0x5aaa,
  0x6726, 0x7b67, 0x4a36, 0x4b42, 0x4b82, 0x5457, 0x5dd0, 0x84c9,
  0x5067, 0x5065, 0x51f3, 0x5d42, 0x5f94, 0x59d3, 0x5ad7, 0x6250,
  0x633c, 0x63fc, 0x6c27, 0x68e5, 0x693f, 0x6a47, 0x6b80, 0x74ba,
  0x77ed, 0x718a, 0x7841, 0x790f, 0x7921, 0x79af, 0x8612, 0x82d6,
  0x8e36, 0x8e88, 0x897d, 0x8a87, 0x8b3e, 0x943c, 0x9543, 0x955f,
  0x9049, 0x9ddd, 0x7ef4, 0x78a8, 0x4bc7, 0x550c, 0x55cb, 0x53c5,
  0x5fe2, 0x58f6, 0x6254, 0x6e30, 0x6957, 0x6a9b, 0x6be1, 0x7501,
  0x7162, 0x7eee, 0x8c2f, 0x942c, 0x9478, 0x92c6, 0x9df2, 0x870c,
  0x4a20, 0x4aff, 0x8c4b, 0x95c0, 0x5770, 0x6ed6, 0x6d66, 0x684c,
  0x8077, 0x5c93, 0x6583, 0x62f3, 0x66e2, 0x74d0, 0x711c, 0x71ca,
  0x7a5f, 0x80b5, 0x8f44, 0x8905, 0x4a46, 0x57e7,
  /* 0x72 */
  0x50a6, 0x533d, 0x534d, 0x5bda, 0x670c, 0x670a, 0x6062, 0x6122,
  0x61e5, 0x6277, 0x6390, 0x63be, 0x6f6f, 0x686d, 0x6897, 0x6b21,
  0x73e8, 0x7c28, 0x7d44, 0x7d5a, 0x7914, 0x84af, 0x850f, 0x85fe,
  0x8690, 0x86ba, 0x8315, 0x8e81, 0xfdf1, 0x8909, 0x89b3, 0x947f,
  0x72f9, 0x7e14, 0x7e3a, 0x7a59, 0x847a, 0x510a, 0x51d9, 0x5c78,
  0x6722, 0x602f, 0x6244, 0x6246, 0x6c60, 0x6d96, 0x6f89, 0x6928,
  0x6abc, 0x77c0, 0x7065, 0x70ac, 0x7156, 0x71b4, 0x72ec, 0x7313,
  0x7386, 0x7deb, 0x7a04, 0x7a10, 0x85f6, 0x8122, 0x8c9a, 0x8e37,
  0x88dc, 0x8ae6, 0x8bbd, 0x943f, 0x97a0, 0x926e, 0x927e, 0x930a,
  0x4b89, 0x57fc, 0x5de7, 0x5ec4, 0x5a14, 0x6c43, 0x70cb, 0x71b3,
  0x7de4, 0x7e9f, 0x85ae, 0x82e0, 0x88e7, 0x89c1, 0x8be0, 0x6192,
  0x6318, 0xfdf0, 0x53fa, 0x6b5a, 0x79d0, 0x8b22,
  /* 0x73 */
  0x97fb, 0x92cb, 0x5bb8, 0x65ff, 0x6b89, 0x4a19, 0x4b95, 0x5412,
  0x57c4, 0x51d2, 0x5962, 0x59e3, 0x6f2c, 0x6f69, 0x7cc6, 0x7f97,
  0xfdf3, 0x8a44, 0x8ac7, 0x9463, 0x6744, 0x6033, 0x734d, 0x7e89,
  0x9722, 0x9072, 0x9b67, 0x60bd, 0x6ba2, 0x75eb, 0x70a5, 0x70d7,
  0x7ec9, 0x781f, 0x7a8f, 0x78bf, 0x7a95, 0x8f97, 0x8907, 0x9070,
  0x9d1d, 0x9d41, 0x5634, 0x5fd2, 0x60eb, 0x6320, 0x7923, 0x54e0,
  0x57ce, 0x5c74, 0x6555, 0x6554, 0x65f7, 0x61a1, 0x7ed4, 0x8f9f,
  0x8f9b, 0x5404, 0x542c, 0x5678, 0x513c, 0x5e31, 0x5aed, 0x5b7d,
  0x6539, 0x6153, 0x6201, 0x623b, 0x62af, 0x6dc0, 0x6ac9, 0x6b3f,
  0x771b, 0x722c, 0x7e9e, 0x8534, 0x8654, 0x87db, 0x80b1, 0x54b8,
  0x53fd, 0x5fcd, 0x5fe5, 0x5b64, 0x67ac, 0x7c2b, 0x79b8, 0x87d1,
  0x812c, 0x95ca, 0x95f8, 0x5587, 0x63f8, 0x7f5b,
  /* 0x74 */
  0x88a1, 0x55c9, 0x5db6, 0x64b0, 0x8258, 0x5411, 0xfdf2, 0x5659,
  0x5837, 0x6570, 0x6617, 0x66de, 0x60ff, 0x61a8, 0x6ac1, 0x722d,
  0x8507, 0x8a6d, 0x9252, 0x92b6, 0x4ad2, 0x574e, 0x5195, 0x5d24,
  0x59d0, 0x60c8, 0x68c4, 0x69f7, 0x7799, 0x7e72, 0x8616, 0x81ab,
  0x88e9, 0x8a1d, 0x947a, 0x95ea, 0x91ec, 0x922c, 0x93cb, 0x55f5,
  0x50ff, 0x518b, 0x5bb4, 0x60a9, 0x6b85, 0x79b9, 0x8b12, 0x8b40,
  0x9038, 0x54c4, 0x581b, 0x68b3, 0x69f6, 0x7116, 0x73b6, 0x7830,
  0x7869, 0x8e74, 0x8ecf, 0x5c13, 0x5db3, 0x5a1b, 0x677a, 0x765f,
  0x7187, 0x7366, 0x8ed1, 0x88b1, 0x8b1f, 0x5afe, 0x6279, 0x69f5,
  0x8470, 0x87cc, 0x8ec6, 0x935c, 0x9fdb, 0xfe0d, 0x564e, 0x62f2,
  0x6998, 0x6ae2, 0x79ed, 0x8eeb, 0x9423, 0x9453, 0x9ed9, 0x5610,
  0x5672, 0x50e5, 0x6599, 0x6689, 0x66d6, 0x6caf,
  /* 0x75 */
  0x6d1f, 0x6d57, 0x6e38, 0x749f, 0x752b, 0x7c50, 0x7d0c, 0x7d03,
  0x7ddf, 0x7e00, 0x849b, 0x8675, 0x86d8, 0x8744, 0x8144, 0x888f,
  0x8988, 0x956f, 0x9586, 0x95a3, 0x4bce, 0x52dc, 0x75e0, 0x73da,
  0x830d, 0x8df5, 0x5ff5, 0x5bdb, 0x635c, 0x94a5, 0x57ef, 0x5c57,
  0x5ff8, 0x64a9, 0x658c, 0x606d, 0x7a30, 0x847d, 0x8128, 0x968e,
  0x60a3, 0x54a1, 0x5919, 0x630d, 0x5c91, 0x66b0, 0x67a5, 0x6d03,
  0x6d75, 0x6e13, 0x6a66, 0x72b7, 0x7dc6, 0x86b6, 0x8024, 0x8ec2,
  0x89a5, 0x8bf0, 0x951f, 0x9546, 0x9591, 0x971d, 0x9715, 0x9797,
  0x92d6, 0x9e3b, 0x9800, 0x4a1c, 0x7151, 0x7d50, 0x7ef7, 0x7f5c,
  0x7fc4, 0x7a23, 0x80c9, 0x8a54, 0x8a79, 0x8af5, 0x941d, 0x6228,
  0x6d32, 0x704e, 0x55f7, 0x6323, 0x9ad1, 0x5548, 0x5bed, 0x689b,
  0x83ff, 0x8c50, 0x8c7a, 0x64b9, 0x85b8, 0x800e,
  /* 0x76 */
  0x8908, 0x57db, 0x5034, 0x5239, 0x5e3b, 0x583c, 0x7487, 0x7bed,
  0x8457, 0x850b, 0x85e0, 0x89ae, 0x9584, 0x9e52, 0x99ff, 0x5479,
  0x4ac9, 0x57ad, 0x64f6, 0x6a21, 0x5869, 0x4b85, 0x5429, 0x51e9,
  0x58d4, 0x5a52, 0x6468, 0x6c99, 0x68b6, 0x69c9, 0x75b3, 0x71d9,
  0x71f9, 0x726c, 0x7e17, 0x7e44, 0x79ca, 0x79f6, 0x7b63, 0x85f9,
  0x82a4, 0x8b11, 0x92c4, 0x9dbe, 0x9b5f, 0x564a, 0x56c8, 0x9ce0,
  0x8da7, 0x4a0e, 0x63df, 0x6b0b, 0x4bb8, 0x5fef, 0x6398, 0x6885,
  0x6975, 0x7016, 0x7c2a, 0x95d0, 0x9771, 0x83c9, 0x7de9, 0x7e3c,
  0x5be6, 0x4adb, 0x50a9, 0x5133, 0x5ca3, 0x5da8, 0x64fd, 0x665e,
  0x66db, 0x633b, 0x6d58, 0x8638, 0x924d, 0x9dbc, 0x9dd0, 0x5421,
  0x575e, 0x5149, 0x5371, 0xfe0c, 0x6655, 0xfe0f, 0x60ef, 0x6266,
  0x63d0, 0x6bcc, 0x6be2, 0x702f, 0x7035, 0x8e1a,
  /* 0x77 */
  0x9035, 0x505c, 0x520b, 0x536b, 0x5b45, 0x6597, 0x6f43, 0x7455,
  0x74a0, 0x79b6, 0x8e98, 0x5d67, 0x8526, 0x67af, 0x7305, 0x8430,
  0x88a7, 0x5c59, 0x6020, 0x6db6, 0x5f98, 0x5a1c, 0x6a62, 0xfe0e,
  0x8164, 0x5541, 0x57fd, 0x5d27, 0x642d, 0x6546, 0x6f8b, 0x687d,
  0x68fd, 0x7f13, 0x84c3, 0x86d9, 0x89cb, 0x94bd, 0x9cbc, 0xfe09,
  0x60ca, 0x6ba9, 0x609c, 0x6109, 0x5543, 0x501d, 0x5312, 0x8e03,
  0x6552, 0x6c7b, 0xfe08, 0x71d6, 0x7f5f, 0x797c, 0x9417, 0x5c0b,
  0x6dc1, 0x8572, 0x8d27, 0x940d, 0x9c34, 0x5475, 0x5d5a, 0x5da1,
  0x6698, 0x9402, 0x9f27, 0x6550, 0x7674, 0x91db, 0x536c, 0x5e4b,
  0x59f9, 0x6687, 0x60a0, 0x60f7, 0x637a, 0x68ef, 0x6933, 0x7621,
  0x703b, 0x7c39, 0x7b7a, 0x86a0, 0x89d6, 0x9c1a, 0x5629, 0x534f,
  0x6372, 0x7645, 0x70ee, 0x88a4, 0x8bab, 0x961c,
  /* 0x78 */
  0x9227, 0x5566, 0x57e0, 0x6741, 0x4b64, 0x5109, 0x649b, 0x615a,
  0x6896, 0x6972, 0x7641, 0x76f0, 0x7e1a, 0x8d8a, 0x8890, 0x5b60,
  0x6b83, 0x74f4, 0x85a5, 0x6503, 0x4bb2, 0x5442, 0x664c, 0x764a,
  0x7fca, 0x79e5, 0x7be4, 0x9440, 0x93a0, 0x9e14, 0x88bb, 0x5367,
  0x5a7e, 0x63bd, 0x8000, 0x8e58, 0x502d, 0x5f1b, 0x5a6e, 0x5aef,
  0x5b07, 0x618e, 0x84b7, 0x8130, 0x9184, 0x9256, 0x4b45, 0x5708,
  0x5700, 0x5702, 0x508b, 0x50f7, 0x530e, 0x5a0e, 0x641b, 0x6696,
  0x66bc, 0x6758, 0xfe0b, 0x68ec, 0x696b, 0x71bc, 0x7c3f, 0x84d3,
  0x8522, 0x86d3, 0x806c, 0x80bf, 0x8c80, 0x8d1f, 0x9406, 0x96e7,
  0x9cf0, 0x9f9c, 0x5a48, 0x62b9, 0x62d0, 0x741c, 0x760b, 0xfe0a,
  0x4bf8, 0x5670, 0x5b67, 0x655e, 0x635e, 0x6e14, 0x6b0f, 0x70ef,
  0x7d65, 0x8c65, 0x8874, 0x9cca, 0x9cc9, 0x9e4e,
  /* 0x79 */
  0x50cc, 0x7e12, 0x6d5e, 0x8efa, 0x8847, 0x9ca5, 0x9da3, 0x5b71,
  0x66a6, 0x71bf, 0x72a3, 0x8ca6, 0x9472, 0x924f, 0x5734, 0x5b31,
  0x5bc8, 0x68c1, 0x77c1, 0x716f, 0x7186, 0x7f4b, 0x86f3, 0x9d90,
  0x4a42, 0x9431, 0x4a06, 0x4b58, 0x57ab, 0x5d02, 0x5ac5, 0x623d,
  0x68be, 0x7058, 0x877a, 0x836b, 0x88cd, 0x945d, 0x9313, 0x9818,
  0x5cdc, 0x5f75, 0x825d, 0x8f19, 0x99b9, 0x5fdf, 0x6465, 0x6480,
  0x61fc, 0x685a, 0x6b2f, 0x6bae, 0x7417, 0x7b58, 0x7bfd, 0x919c,
  0x919f, 0x925d, 0x93de, 0x567f, 0x8b49, 0x55f0, 0x5026, 0x50b5,
  0x516e, 0x5187, 0x6eb6, 0x69b8, 0x79d5, 0x866b, 0x9691, 0x927a,
  0x9a74, 0x5005, 0x50c5, 0x72df, 0x82e9, 0x91a9, 0x91d9, 0x9251,
  0x4aaf, 0x4b04, 0x5de3, 0x5eeb, 0x59fa, 0x645f, 0x669a, 0x6360,
  0x6c4c, 0x688b, 0x6a22, 0x7b35, 0x8496, 0x8627,
  /* 0x7a */
  0xfe05, 0xfe04, 0x9c08, 0x4aa8, 0x5458, 0x50be, 0x539e, 0x5d57,
  0x5f64, 0x5fbe, 0x65c5, 0x6d7a, 0x697a, 0x742e, 0x83f4, 0x8dee,
  0x8e7f, 0x8eea, 0x948f, 0x9de0, 0x9eb5, 0x56b3, 0x6c35, 0x541b,
  0x5a75, 0x6342, 0x874a, 0x8c41, 0x4aa6, 0x501c, 0x52a3, 0x77eb,
  0x9518, 0x93f2, 0x9d04, 0x9d5a, 0x9d94, 0x525e, 0x5c92, 0x8256,
  0x8e3c, 0x65bf, 0x6efb, 0x7776, 0x8adf, 0x6f4a, 0x92a7, 0x9e5a,
  0x5d58, 0x760d, 0x8966, 0x9364, 0x4bd9, 0x58f9, 0x5b2b, 0x65f5,
  0x6256, 0x68e6, 0x74a6, 0x7789, 0x77b4, 0x77f3, 0x7324, 0x7340,
  0x794e, 0x796f, 0x7a2e, 0x863a, 0x8c5f, 0xfe07, 0x88ef, 0x9644,
  0x9c62, 0x5f5c, 0x7e79, 0x8c4d, 0x9c0c, 0x5ec1, 0x4bed, 0x5759,
  0x5d33, 0x58f0, 0x6733, 0x6974, 0x76f4, 0x8508, 0x850a, 0x87af,
  0x96c2, 0x9c3d, 0x4aa5, 0x5549, 0x561c, 0x5386,
  /* 0x7b */
  0x5b6f, 0x68cf, 0x6ac3, 0x7408, 0x745d, 0x74a2, 0x759f, 0x77e4,
  0x7064, 0x8747, 0x83af, 0x8c6c, 0x9405, 0x94af, 0x97ae, 0x9da5,
  0x5563, 0x5b5a, 0x64ed, 0x656a, 0x62be, 0x8154, 0x8a47, 0x95a2,
  0x9386, 0x4a43, 0x4a9f, 0x5071, 0x5cd8, 0x5cf7, 0x5d70, 0x58b8,
  0x5b2a, 0x663b, 0x6645, 0x6207, 0x626a, 0x6fe6, 0x6964, 0x69c2,
  0x6a5b, 0x6af5, 0x6b99, 0x6bed, 0x6be4, 0x7450, 0x76dd, 0x7028,
  0x7057, 0x70ed, 0x729e, 0x7d51, 0x78c7, 0x7a13, 0x84ec, 0x86ab,
  0x8066, 0x80b2, 0x8243, 0x8252, 0x8379, 0x8f7a, 0x8867, 0x97a1,
  0x9c0d, 0x9c68, 0x64dc, 0x661b, 0x957a, 0x5e57, 0x6202, 0x69fa,
  0x6a33, 0x7032, 0x9f4f, 0x5bf0, 0x64d7, 0x7f02, 0x50c9, 0x5b15,
  0x6853, 0x68de, 0x6927, 0x74d5, 0x7908, 0x8274, 0x8e01, 0x9936,
  0x571b, 0x5081, 0x5f08, 0x6e37, 0x7466, 0x7178,
  /* 0x7c */
  0x7d80, 0x7db3, 0x86bc, 0x87e2, 0x8e7c, 0x8f4c, 0x88a5, 0x9379,
  0xfe06, 0x60f9, 0x6126, 0x7cb7, 0x7cb6, 0x7e66, 0x4a35, 0x5197,
  0x5d5d, 0x5fab, 0x5a76, 0x64ae, 0x67d6, 0x6f6c, 0x6268, 0x6c5e,
  0x6a14, 0x7568, 0x70bd, 0x7905, 0x9489, 0x9e64, 0x9828, 0x6936,
  0x6adc, 0x7733, 0x884c, 0x91c7, 0x55fd, 0x5a41, 0x5ba5, 0x6440,
  0x64fb, 0x653d, 0x6541, 0x624e, 0x6249, 0x6da8, 0x68cc, 0x6a52,
  0x6ac4, 0x6b6f, 0x7541, 0x7091, 0x728a, 0x7fcc, 0x782a, 0x875f,
  0x835a, 0x945c, 0x9280, 0x9ace, 0x5722, 0x52d3, 0x5af6, 0x5b87,
  0x646f, 0x6499, 0x65fa, 0x626b, 0x630e, 0x6e91, 0x69e3, 0x6ba3,
  0x747d, 0x7767, 0x7a67, 0x85b3, 0x8739, 0x82d9, 0x8ea5, 0x88c9,
  0x568e, 0x777f, 0x5f9b, 0x6e66, 0x9009, 0x50e3, 0x528b, 0x5f50,
  0x6145, 0x6188, 0x62c4, 0x6c92, 0x6980, 0x69cb,
  /* 0x7d */
  0x7636, 0x84b9, 0x9578, 0x9e40, 0x4ba2, 0x5414, 0x5797, 0x5003,
  0x5031, 0x5184, 0x51c8, 0x5a32, 0x5b81, 0x6330, 0x756b, 0x77d0,
  0x9408, 0x56d6, 0x56fe, 0x5c69, 0x5cc3, 0x7509, 0x7582, 0x75f6,
  0x81bd, 0x8e1e, 0x6285, 0x81a5, 0x51aa, 0x6289, 0x7547, 0x803c,
  0x5744, 0x5194, 0x6fcc, 0x5b54, 0x5bb0, 0x67e3, 0x6284, 0x754a,
  0x8efc, 0x8b10, 0x9ab3, 0x4b1c, 0x6037, 0x74c6, 0x716b, 0x826a,
  0x6469, 0x8f43, 0x99f5, 0x554a, 0x55fb, 0x5705, 0x693b, 0x84f5,
  0x9adc, 0x6218, 0x6f2e, 0x7495, 0x71d8, 0x500e, 0x5874, 0x790a,
  0x8e1b, 0x6f2d, 0x6f30, 0x6f4b, 0x5035, 0x647d, 0x6930, 0x7bd8,
  0x8605, 0x54db, 0x55d3, 0x5191, 0x5266, 0x52c0, 0x5de1, 0x5f04,
  0x5a01, 0x6594, 0x6595, 0x663c, 0x6253, 0x62eb, 0x7594, 0x75b4,
  0x75b7, 0x76aa, 0x7daa, 0x7e0d, 0x7bbf, 0x8e7d
};

static const acp_uint16_t ksc5601_2charset[ /*8227*/ ] = {
  0x2623, 0x2639, 0x255a, 0x252a, 0x2c2e, 0x2524, 0x266a, 0x254b,
  0x2533, 0x2d7a, 0x2d75, 0x2628, 0x265f, 0x2529, 0x2621, 0x2d7b,
  0x2c21, 0x2c74, 0x2c7b, 0x2c77, 0x2622, 0x2c2c, 0x2c2f, 0x2532,
  0x2c27, 0x2c20, 0x2d21, 0x2d2c, 0x2d2e, 0x254d, 0x2d27, 0x2d20,
  0x2d2f, 0x2c29, 0x2d29, 0x2d28, 0x2c2b, 0x2d2b, 0x2d2a, 0x2c25,
  0x2d25, 0x2c24, 0x2d24, 0x2d3d, 0x2c22, 0x2d22, 0x2c26, 0x2d26,
  0x2c23, 0x2d23, 0x262a, 0x263d, 0x2625, 0x2626, 0x2627, 0x2620,
  0x2624, 0x214c, 0x214f, 0x214e, 0x2149, 0x2148, 0x214b, 0x214a,
  0x2145, 0x2144, 0x2147, 0x2146, 0x2141, 0x2140, 0x2143, 0x2142,
  0x215d, 0x215c, 0x215f, 0x215e, 0x2159, 0x2158, 0x215b, 0x215a,
  0x2155, 0x216c, 0x216f, 0x216e, 0x2169, 0x2168, 0x216b, 0x216a,
  0x2165, 0x2164, 0x2167, 0x2166, 0x2161, 0x2160, 0x2163, 0x2162,
  0x217d, 0x217c, 0x217f, 0x217e, 0x2179, 0x2178, 0x217b, 0x217a,
  0x2175, 0x282a, 0x282c, 0x282f, 0x282e, 0x2829, 0x2828, 0x282b,
  0x2825, 0x2824, 0x2827, 0x2826, 0x2821, 0x2820, 0x2823, 0x2822,
  0x283d, 0x283c, 0x283f, 0x283e, 0x2839, 0x2838, 0x283b, 0x283a,
  0x2835, 0x2834, 0x2837, 0x2836, 0x2831, 0x2830, 0x2833, 0x2832,
  0x284d, 0x284c, 0x285c, 0x285f, 0x285e, 0x2859, 0x2858, 0x285b,
  0x2855, 0x2854, 0x2857, 0x2856, 0x2851, 0x2850, 0x2853, 0x2852,
  0x286d, 0x286c, 0x286f, 0x286e, 0x2869, 0x2868, 0x286b, 0x286a,
  0x2865, 0x2864, 0x2867, 0x2866, 0x2861, 0x2860, 0x2863, 0x2862,
  0x287d, 0x287c, 0x285a, 0x2527, 0x2523, 0x2522, 0x253d, 0x253c,
  0x265e, 0x2659, 0x2528, 0x252b, 0x263b, 0x254a, 0x2545, 0x2555,
  0x2d74, 0x2d77, 0x2d76, 0x2d71, 0x2d70, 0x2d73, 0x266b, 0x2544,
  0x2638, 0x2329, 0x266d, 0x2668, 0x266f, 0x2354, 0x2547, 0x2c7a,
  0x2c75, 0x2c76, 0x2c71, 0x2c70, 0x2c73, 0x213d, 0x213c, 0x213f,
  0x213e, 0x2139, 0x2138, 0x213b, 0x213a, 0x2135, 0x2134, 0x212c,
  0x212f, 0x212e, 0x2129, 0x2128, 0x212b, 0x212a, 0x2125, 0x2124,
  0x2127, 0x256a, 0x2565, 0x256b, 0x2564, 0x2567, 0x2658, 0x2655,
  0x265b, 0x2654, 0x265a, 0x262c, 0x262f, 0x262e, 0x255e, 0x2629,
  0x2559, 0x2579, 0x2578, 0x263e, 0x263f, 0x2563, 0x257d, 0x2549,
  0x255d, 0x2526, 0x2571, 0x2570, 0x2576, 0x2577, 0x257f, 0x257e,
  0x263c, 0x2548, 0x257c, 0x2520, 0x2562, 0x255b, 0x254c, 0x2558,
  0x254f, 0x254e, 0x2561, 0x2560, 0x2575, 0x2574, 0x257b, 0x257a,
  0x264c, 0x255c, 0x255f, 0x2c6a, 0x2c65, 0x2c64, 0x2c67, 0x2c66,
  0x2c61, 0x2c60, 0x2c63, 0x2c62, 0x2c7d, 0x2c7c, 0x2c7f, 0x2c7e,
  0x2c79, 0x2c78, 0x2d6a, 0x2d65, 0x2d64, 0x2d67, 0x2d66, 0x2d61,
  0x2d60, 0x2d63, 0x2d62, 0x2d7d, 0x2d7c, 0x2d7f, 0x2d7e, 0x2d79,
  0x2d78, 0x2d40, 0x2d43, 0x2d42, 0x2d5d, 0x2d5c, 0x2d5f, 0x2d5e,
  0x2d59, 0x2d58, 0x2d5b, 0x2d5a, 0x2d55, 0x2d54, 0x2d57, 0x2d56,
  0x2d51, 0x2d50, 0x2d53, 0x2d52, 0x2d6d, 0x2d6c, 0x2d6f, 0x2d6e,
  0x2d69, 0x2d68, 0x2d6b, 0x2c40, 0x2c43, 0x2c42, 0x2c5d, 0x2c5c,
  0x2c5f, 0x2c5e, 0x2c59, 0x2c58, 0x2c5b, 0x2c5a, 0x2c55, 0x2c54,
  0x2c57, 0x2c56, 0x2c51, 0x2c50, 0x2c53, 0x2c52, 0x2c6d, 0x2c6c,
  0x2c6f, 0x2c6e, 0x2c69, 0x2c68, 0x2c6b, 0x222c, 0x2221, 0x222f,
  0x2220, 0x222e, 0x2245, 0x224a, 0x2223, 0x2229, 0x224f, 0x224c,
  0x2222, 0x222b, 0x224b, 0x2248, 0x223c, 0x2228, 0x2249, 0x224e,
  0x223d, 0x222a, 0x2231, 0x2244, 0x2247, 0x223a, 0x2246, 0x2241,
  0x223f, 0x2224, 0x2233, 0x2240, 0x2243, 0x2234, 0x2242, 0x225d,
  0x2239, 0x2225, 0x225c, 0x225f, 0x2235, 0x2230, 0x225e, 0x2259,
  0x223e, 0x2227, 0x2258, 0x225b, 0x2237, 0x2232, 0x225a, 0x2255,
  0x2238, 0x2226, 0x2254, 0x2257, 0x2236, 0x2256, 0x2251, 0x224d,
  0x2250, 0x2253, 0x2252, 0x226d, 0x226c, 0x226f, 0x226e, 0x2269,
  0x223b, 0x264b, 0x256c, 0x256d, 0x264e, 0x264a, 0x2645, 0x2646,
  0x2647, 0x2644, 0x2641, 0x256e, 0x256f, 0x2637, 0x2634, 0x2568,
  0x2569, 0x2635, 0x263a, 0x2552, 0x2553, 0x264f, 0x2556, 0x2550,
  0x2551, 0x2649, 0x2648, 0x2557, 0x2554, 0x2642, 0x2643, 0x265d,
  0x265c, 0x2542, 0x2543, 0x2631, 0x2630, 0x264d, 0x2636, 0x2633,
  0x2632, 0x2640, 0x2656, 0x2651, 0x2650, 0x2657, 0x252c, 0x252f,
  0x252e, 0x2525, 0x2539, 0x2538, 0x253b, 0x253a, 0x2535, 0x2534,
  0x2537, 0x2536, 0x2531, 0x2530, 0x2566, 0x253f, 0x253e, 0x2e2c,
  0x2e2f, 0x2e2e, 0x2e29, 0x2e28, 0x2e2b, 0x2e2a, 0x2e25, 0x2e24,
  0x2e27, 0x2e26, 0x2e21, 0x2e20, 0x2e23, 0x2e22, 0x2e3d, 0x2e3c,
  0x2e3f, 0x2e3e, 0x2e39, 0x2e38, 0x2e3b, 0x2e3a, 0x2e35, 0x2e34,
  0x2e37, 0x2e36, 0x2e31, 0x2e30, 0x2e33, 0x2e32, 0x2e4d, 0x2e4c,
  0x2e4f, 0x2e4e, 0x2e49, 0x2e48, 0x2e4b, 0x2e4a, 0x2e45, 0x2e44,
  0x2e47, 0x2e46, 0x2e41, 0x2e40, 0x2e43, 0x2e42, 0x2e5d, 0x2e5c,
  0x2e5f, 0x2e5e, 0x2e59, 0x2e58, 0x2e5b, 0x2e5a, 0x2e55, 0x2e54,
  0x2e57, 0x2e56, 0x2e51, 0x2e50, 0x2e53, 0x2e52, 0x2e6d, 0x2e6c,
  0x2e6f, 0x2e6e, 0x2e69, 0x2e68, 0x2e6b, 0x2e6a, 0x2e65, 0x2e64,
  0x2e67, 0x2e66, 0x2e61, 0x2e60, 0x2e63, 0x2e62, 0x2e7d, 0x2e7c,
  0x2e7f, 0x2e7e, 0x2f2c, 0x2f2f, 0x2f2e, 0x2f29, 0x2f28, 0x2f2b,
  0x2f2a, 0x2f25, 0x2f24, 0x2f27, 0x2f26, 0x2f21, 0x2f20, 0x2f23,
  0x2f22, 0x2f3d, 0x2f3c, 0x2f3f, 0x2f3e, 0x2f39, 0x2f38, 0x2f3b,
  0x2f3a, 0x2f35, 0x2f34, 0x2f37, 0x2f36, 0x2f31, 0x2f30, 0x2f33,
  0x2f32, 0x2f4d, 0x2f4c, 0x2f4f, 0x2f4e, 0x2f49, 0x2f48, 0x2f4b,
  0x2f4a, 0x2f45, 0x2f44, 0x2f47, 0x2f46, 0x2f41, 0x2f40, 0x2f43,
  0x2f42, 0x2f5d, 0x2f5c, 0x2f5f, 0x2f5e, 0x2f59, 0x2f58, 0x2f5b,
  0x2f5a, 0x2f55, 0x2f54, 0x2f57, 0x2f56, 0x2f51, 0x2f50, 0x2f53,
  0x2f52, 0x2f6d, 0x2f6c, 0x2f6f, 0x2f6e, 0x2f69, 0x2f68, 0x2f6b,
  0x2f6a, 0x2f65, 0x2f64, 0x2f67, 0x2f66, 0x2f61, 0x2f60, 0x2f63,
  0x2f62, 0x2f7d, 0x2f7c, 0x2f7f, 0x2f7e, 0x2f79, 0x2f78, 0x2f7b,
  0x202c, 0x202f, 0x202e, 0x2029, 0x2028, 0x202b, 0x202a, 0x2025,
  0x2024, 0x2027, 0x2026, 0x2021, 0x2020, 0x2023, 0x2022, 0x203d,
  0x203c, 0x203f, 0x203e, 0x2039, 0x2038, 0x203b, 0x203a, 0x2035,
  0x2034, 0x2037, 0x2036, 0x2031, 0x2030, 0x2033, 0x2032, 0x204d,
  0x204c, 0x204f, 0x204e, 0x2049, 0x2048, 0x204b, 0x204a, 0x2045,
  0x2044, 0x2047, 0x2046, 0x2041, 0x2040, 0x2043, 0x2042, 0x205d,
  0x205c, 0x205f, 0x205e, 0x2059, 0x2058, 0x205b, 0x205a, 0x2055,
  0x2054, 0x2057, 0x2056, 0x2051, 0x2050, 0x2053, 0x2052, 0x206d,
  0x206c, 0x206f, 0x206e, 0x2069, 0x2068, 0x206b, 0x206a, 0x2065,
  0x2064, 0x2067, 0x2066, 0x2061, 0x2060, 0x2063, 0x2062, 0x207d,
  0x207c, 0x207f, 0x207e, 0x2079, 0x2078, 0x207b, 0x207a, 0x2075,
  0x2074, 0x2077, 0x2076, 0x2071, 0x2070, 0x2073, 0x2d3c, 0x2d3f,
  0x2d3e, 0x2d39, 0x2d38, 0x2d3b, 0x2d3a, 0x2d35, 0x2d34, 0x2d37,
  0x2d36, 0x2d31, 0x2d30, 0x2d33, 0x2d32, 0x2d4d, 0x2d4c, 0x2d4f,
  0x2d4e, 0x2d49, 0x2d48, 0x2d4b, 0x2d4a, 0x2d45, 0x2d44, 0x2d47,
  0x2d46, 0x2d41, 0x2652, 0x2c3c, 0x2c3f, 0x2c3e, 0x2c39, 0x2c38,
  0x2c3b, 0x2c3a, 0x2c35, 0x2c34, 0x2c37, 0x2c36, 0x2c31, 0x2c30,
  0x2c33, 0x2c32, 0x2c4d, 0x2c4c, 0x2c4f, 0x2c4e, 0x2c49, 0x2c48,
  0x2c4b, 0x2c4a, 0x2c45, 0x2c44, 0x2c47, 0x2c46, 0x2c41, 0x2665,
  0x2653, 0x2344, 0x2347, 0x2346, 0x2341, 0x2340, 0x2337, 0x2336,
  0x2351, 0x2350, 0x2353, 0x233b, 0x233a, 0x2335, 0x2359, 0x2358,
  0x235b, 0x235a, 0x2355, 0x232c, 0x232f, 0x232e, 0x2328, 0x2326,
  0x2321, 0x2320, 0x2323, 0x2322, 0x233d, 0x233c, 0x233f, 0x233e,
  0x2339, 0x232a, 0x2325, 0x2324, 0x2327, 0x2330, 0x2333, 0x2368,
  0x236b, 0x236a, 0x2365, 0x236c, 0x236f, 0x236e, 0x2332, 0x234d,
  0x234c, 0x234f, 0x234e, 0x2349, 0x2348, 0x234b, 0x234a, 0x2345,
  0x2343, 0x2342, 0x235d, 0x235c, 0x235f, 0x235e, 0x2357, 0x2356,
  0x266e, 0x2361, 0x232b, 0x236d, 0x2362, 0x266c, 0x2331, 0x2360,
  0x2338, 0x2334, 0x2367, 0x2366, 0x2352, 0x2669, 0x2369, 0x2363,
  0x2364, 0x6864, 0x6b46, 0x725f, 0x5c3f, 0x6956, 0x5b3f, 0x5b33,
  0x7d36, 0x5879, 0x7169, 0x772b, 0x596d, 0x652b, 0x4a75, 0x583d,
  0x6727, 0x7564, 0x4977, 0x7822, 0x572c, 0x7526, 0x635c, 0x5621,
  0x4a74, 0x7570, 0x5a32, 0x7f37, 0x7d34, 0x4a5f, 0x6726, 0x6f6d,
  0x4a77, 0x4f7a, 0x6128, 0x4e6c, 0x5041, 0x6e6c, 0x586e, 0x5b20,
  0x4f66, 0x5122, 0x5278, 0x6175, 0x5a4d, 0x682e, 0x6d40, 0x6e2a,
  0x6d7b, 0x7f36, 0x6364, 0x6b41, 0x546b, 0x5a4c, 0x6021, 0x5c41,
  0x7d7c, 0x4a52, 0x7e29, 0x623f, 0x7e76, 0x7e30, 0x4845, 0x6b40,
  0x5158, 0x572f, 0x685c, 0x602a, 0x685f, 0x723c, 0x4a76, 0x545c,
  0x4f32, 0x6929, 0x6925, 0x5a4f, 0x726f, 0x6951, 0x5878, 0x6434,
  0x5043, 0x7038, 0x5756, 0x5238, 0x6829, 0x606b, 0x7567, 0x4f61,
  0x4f4d, 0x687f, 0x5467, 0x7d7f, 0x6828, 0x5452, 0x6367, 0x5466,
  0x585c, 0x5f64, 0x7941, 0x5f5a, 0x5e6c, 0x523b, 0x6752, 0x5a4e,
  0x5a49, 0x4e2c, 0x6a61, 0x572e, 0x6a3a, 0x7c42, 0x6e45, 0x6a35,
  0x7521, 0x7528, 0x6d43, 0x7d31, 0x6174, 0x6867, 0x595b, 0x694f,
  0x7c28, 0x6137, 0x5f55, 0x4e2f, 0x5540, 0x6a60, 0x6866, 0x5a48,
  0x676d, 0x4e44, 0x7664, 0x5143, 0x723b, 0x4a4f, 0x524a, 0x6739,
  0x7520, 0x6e6f, 0x534f, 0x772a, 0x4967, 0x6f63, 0x5d3f, 0x7928,
  0x7258, 0x516f, 0x7c38, 0x4878, 0x7138, 0x6020, 0x6366, 0x7558,
  0x7436, 0x6d38, 0x4844, 0x7e58, 0x6559, 0x535b, 0x584c, 0x5a4b,
  0x7e62, 0x676c, 0x657e, 0x587b, 0x4a71, 0x5f49, 0x7c7c, 0x5869,
  0x6162, 0x583c, 0x515b, 0x7757, 0x4f4c, 0x5f4e, 0x5d77, 0x5763,
  0x7e35, 0x792b, 0x6f62, 0x702b, 0x4847, 0x7725, 0x7756, 0x5f2a,
  0x723a, 0x4b6b, 0x747f, 0x4f57, 0x635f, 0x534e, 0x727d, 0x6c53,
  0x612b, 0x616a, 0x4e2e, 0x482a, 0x6e44, 0x7c3b, 0x7e28, 0x7523,
  0x6b43, 0x4f60, 0x723d, 0x6b42, 0x6d42, 0x7353, 0x4a5e, 0x587a,
  0x5f25, 0x4f75, 0x5b2c, 0x596c, 0x7147, 0x6d3b, 0x6361, 0x6a63,
  0x777d, 0x5b32, 0x4846, 0x544c, 0x705f, 0x6437, 0x5b4d, 0x4a6d,
  0x585f, 0x7967, 0x527b, 0x6e47, 0x6c64, 0x6721, 0x775d, 0x4e29,
  0x5f75, 0x5a4a, 0x6f7d, 0x755b, 0x616f, 0x4841, 0x4f76, 0x6e6e,
  0x5b4c, 0x5260, 0x6d5d, 0x6a34, 0x516e, 0x555e, 0x617d, 0x6c39,
  0x6f4e, 0x6e27, 0x7e71, 0x717b, 0x7431, 0x7959, 0x6436, 0x4a4e,
  0x5437, 0x7337, 0x5c7e, 0x7340, 0x6023, 0x5052, 0x546a, 0x6870,
  0x5623, 0x6a62, 0x515a, 0x6e69, 0x7c2f, 0x4966, 0x5332, 0x7f3c,
  0x4961, 0x583f, 0x5461, 0x4a70, 0x6a7d, 0x484f, 0x5460, 0x617a,
  0x7771, 0x6a2f, 0x5d3e, 0x5c79, 0x6d3a, 0x4a23, 0x5d2f, 0x5c7c,
  0x5042, 0x612a, 0x515f, 0x5224, 0x702f, 0x755a, 0x5155, 0x7430,
  0x535d, 0x505d, 0x5342, 0x6f67, 0x7966, 0x5f60, 0x7848, 0x4f4f,
  0x7958, 0x7045, 0x6c67, 0x717e, 0x7d53, 0x5762, 0x685e, 0x594f,
  0x6b3a, 0x6359, 0x4e47, 0x5d76, 0x7e70, 0x5227, 0x7075, 0x737a,
  0x5821, 0x535a, 0x5b2f, 0x4a33, 0x577d, 0x7429, 0x6561, 0x4b6a,
  0x7746, 0x6924, 0x4e33, 0x7062, 0x7243, 0x5a76, 0x5436, 0x513a,
  0x6a7c, 0x7025, 0x5875, 0x4f2a, 0x5e43, 0x646b, 0x6928, 0x6a7f,
  0x5874, 0x7d51, 0x7751, 0x7c7f, 0x7074, 0x787c, 0x5431, 0x5f74,
  0x533c, 0x4f71, 0x7428, 0x4f70, 0x5179, 0x4960, 0x4e28, 0x5226,
  0x544f, 0x7433, 0x5630, 0x4829, 0x7e3b, 0x4840, 0x5e77, 0x7242,
  0x6d35, 0x5c78, 0x4843, 0x5340, 0x505c, 0x6d60, 0x4e66, 0x5d6f,
  0x793f, 0x6720, 0x5241, 0x5d39, 0x652a, 0x6a5e, 0x544e, 0x793e,
  0x5169, 0x4b65, 0x694e, 0x543f, 0x4a73, 0x5e25, 0x7c5d, 0x795b,
  0x7c5c, 0x7c5f, 0x585e, 0x596f, 0x7f74, 0x594c, 0x6738, 0x6950,
  0x4a49, 0x4f2c, 0x596e, 0x7850, 0x7d22, 0x5676, 0x4b2c, 0x6025,
  0x703b, 0x6873, 0x6723, 0x6360, 0x794c, 0x5e6f, 0x5c3e, 0x5969,
  0x7462, 0x727c, 0x7e7d, 0x5578, 0x5e42, 0x5859, 0x582b, 0x6b32,
  0x4a42, 0x6454, 0x5d5b, 0x6859, 0x6e46, 0x4e32, 0x513d, 0x4b64,
  0x7560, 0x4842, 0x6075, 0x6060, 0x5355, 0x792a, 0x6e26, 0x723f,
  0x4b7d, 0x7d30, 0x6279, 0x4f56, 0x775c, 0x6d5c, 0x7724, 0x546d,
  0x6d5f, 0x5e6e, 0x665f, 0x722f, 0x6579, 0x5e69, 0x6358, 0x7132,
  0x4b2f, 0x4922, 0x4b2e, 0x493d, 0x7573, 0x542e, 0x6522, 0x7c2e,
  0x4e2b, 0x7336, 0x7667, 0x5a45, 0x6d5e, 0x5a44, 0x7953, 0x4e4d,
  0x7d67, 0x5543, 0x6a59, 0x505f, 0x5d2e, 0x7925, 0x5354, 0x7343,
  0x7e33, 0x4b5b, 0x537d, 0x6f6c, 0x7c48, 0x5877, 0x594e, 0x7d52,
  0x6362, 0x7968, 0x722e, 0x5d71, 0x7924, 0x6363, 0x5168, 0x6b5d,
  0x493c, 0x732f, 0x753f, 0x753c, 0x493f, 0x5e26, 0x4e2a, 0x676f,
  0x7f31, 0x5d29, 0x6a37, 0x7c5e, 0x7f77, 0x4b29, 0x5876, 0x726e,
  0x6927, 0x762c, 0x4a6c, 0x7e2b, 0x7d6d, 0x685b, 0x6063, 0x7d2c,
  0x7f62, 0x7d66, 0x6a2e, 0x6e21, 0x4e25, 0x7077, 0x495b, 0x787b,
  0x7044, 0x7c59, 0x7c2b, 0x5a47, 0x764b, 0x5357, 0x575d, 0x5c48,
  0x6e6b, 0x7750, 0x6057, 0x7269, 0x727f, 0x5b4f, 0x5d70, 0x487b,
  0x5737, 0x6022, 0x7d6c, 0x742b, 0x4f5e, 0x6431, 0x7047, 0x5077,
  0x7927, 0x7d6f, 0x703a, 0x794f, 0x783d, 0x7961, 0x4e6f, 0x7930,
  0x6e6a, 0x5b4e, 0x555f, 0x4a6f, 0x5729, 0x7926, 0x5b6d, 0x764a,
  0x637d, 0x5463, 0x7727, 0x5a46, 0x7235, 0x6578, 0x753e, 0x732e,
  0x4e24, 0x4b28, 0x5b49, 0x653d, 0x7432, 0x7229, 0x673b, 0x7e4b,
  0x5462, 0x7960, 0x5949, 0x787a, 0x6232, 0x5a20, 0x7e32, 0x617c,
  0x6949, 0x5628, 0x7963, 0x713b, 0x657b, 0x5a41, 0x7853, 0x685a,
  0x4950, 0x523a, 0x493e, 0x7c58, 0x6155, 0x4b67, 0x4b5d, 0x6e41,
  0x6e23, 0x6e20, 0x577c, 0x5728, 0x7342, 0x6a29, 0x5429, 0x762f,
  0x547d, 0x762e, 0x7375, 0x543e, 0x5f24, 0x5736, 0x4e61, 0x752b,
  0x4f58, 0x736a, 0x4953, 0x7329, 0x7c4d, 0x5750, 0x485d, 0x4b2b,
  0x727e, 0x657a, 0x5751, 0x7e73, 0x7e2a, 0x6f54, 0x4b2a, 0x6e22,
  0x6062, 0x6d34, 0x7555, 0x5c55, 0x647f, 0x6239, 0x5871, 0x777c,
  0x675d, 0x7676, 0x5f4b, 0x547c, 0x547f, 0x4b51, 0x575c, 0x483c,
  0x7355, 0x4f25, 0x6f31, 0x6033, 0x7051, 0x584f, 0x742a, 0x624d,
  0x4e60, 0x6c66, 0x6165, 0x584e, 0x6953, 0x577f, 0x487a, 0x4a59,
  0x6326, 0x4f4e, 0x653c, 0x733f, 0x577e, 0x575f, 0x714d, 0x5b50,
  0x6a7e, 0x637c, 0x7939, 0x7645, 0x775f, 0x6a79, 0x665e, 0x485c,
  0x5b67, 0x6d37, 0x5d5a, 0x7140, 0x757f, 0x7e4a, 0x5d75, 0x504f,
  0x7268, 0x5948, 0x637f, 0x6952, 0x4e46, 0x5f77, 0x6c38, 0x572b,
  0x7938, 0x7d44, 0x606f, 0x7f30, 0x5329, 0x4a48, 0x4a58, 0x526b,
  0x6130, 0x5a40, 0x687e, 0x696d, 0x6861, 0x7f33, 0x5b66, 0x6575,
  0x7d33, 0x547e, 0x6427, 0x6c6f, 0x6659, 0x5670, 0x6125, 0x5d5e,
  0x5753, 0x7035, 0x7331, 0x5870, 0x6c61, 0x606a, 0x677a, 0x6825,
  0x7e7c, 0x617f, 0x5479, 0x5622, 0x5868, 0x5428, 0x7539, 0x783c,
  0x4875, 0x594b, 0x7e5c, 0x7352, 0x7e25, 0x6a78, 0x5a43, 0x637e,
  0x7321, 0x6f49, 0x696c, 0x6426, 0x594a, 0x563e, 0x5632, 0x4e41,
  0x7f32, 0x6170, 0x5968, 0x5c40, 0x6879, 0x5478, 0x6c60, 0x545f,
  0x5d55, 0x726b, 0x5f27, 0x736d, 0x5c54, 0x702e, 0x7050, 0x6b5c,
  0x5d38, 0x6926, 0x673a, 0x6a36, 0x4939, 0x647e, 0x6e40, 0x6878,
  0x6c63, 0x4f24, 0x7522, 0x4e40, 0x6824, 0x7666, 0x7962, 0x7d7e,
  0x624c, 0x6855, 0x6921, 0x6e43, 0x6c52, 0x5a42, 0x562b, 0x6379,
  0x555b, 0x624f, 0x676e, 0x603d, 0x5c39, 0x7228, 0x7753, 0x5328,
  0x7365, 0x6c4b, 0x7f6b, 0x596b, 0x5873, 0x5c57, 0x5e21, 0x6e3d,
  0x6735, 0x4e27, 0x6574, 0x6e3c, 0x7661, 0x7e63, 0x6a58, 0x7d79,
  0x5661, 0x7f76, 0x797d, 0x6430, 0x4a6e, 0x7c4b, 0x5a23, 0x5b48,
  0x6133, 0x6920, 0x7e67, 0x4963, 0x692b, 0x6923, 0x7460, 0x592c,
  0x6922, 0x7875, 0x5c66, 0x4874, 0x4938, 0x7e24, 0x6550, 0x6658,
  0x6942, 0x592f, 0x7d47, 0x6e65, 0x6160, 0x5766, 0x6d59, 0x6577,
  0x6041, 0x6569, 0x6c4a, 0x4a56, 0x5858, 0x7338, 0x787e, 0x747e,
  0x4a22, 0x7538, 0x6b5f, 0x6c45, 0x6f7c, 0x4f59, 0x6433, 0x6775,
  0x6e64, 0x783f, 0x6479, 0x4b6d, 0x6a28, 0x7e27, 0x624e, 0x653f,
  0x4e26, 0x6769, 0x6d36, 0x665b, 0x777f, 0x6a5b, 0x6e3f, 0x547b,
  0x6854, 0x5e46, 0x4b25, 0x592e, 0x5c56, 0x7d43, 0x6d58, 0x675c,
  0x5631, 0x5c21, 0x7741, 0x4976, 0x725b, 0x6378, 0x6c62, 0x6774,
  0x5636, 0x777e, 0x6776, 0x5a5d, 0x4a3d, 0x527a, 0x7554, 0x714c,
  0x5849, 0x7136, 0x5a5c, 0x586b, 0x5a5f, 0x696f, 0x6a7b, 0x6e42,
  0x7463, 0x6771, 0x5752, 0x5779, 0x653e, 0x6539, 0x705e, 0x5b4b,
  0x6d5b, 0x5f26, 0x722b, 0x6734, 0x6f48, 0x7024, 0x493b, 0x5674,
  0x5e20, 0x566e, 0x4b5c, 0x4f51, 0x4877, 0x4b50, 0x6c24, 0x6736,
  0x6737, 0x6457, 0x6a7a, 0x583e, 0x5778, 0x532b, 0x7238, 0x5356,
  0x6558, 0x5067, 0x5b2e, 0x7952, 0x547a, 0x6959, 0x4f27, 0x6056,
  0x6576, 0x4f2f, 0x576d, 0x6032, 0x7f4d, 0x5e33, 0x6040, 0x5234,
  0x6b4d, 0x6571, 0x7234, 0x5b4a, 0x603c, 0x586a, 0x5865, 0x7e5b,
  0x577b, 0x7557, 0x7e7f, 0x6670, 0x5142, 0x5475, 0x4952, 0x7146,
  0x607d, 0x4f26, 0x5349, 0x6673, 0x5957, 0x5e23, 0x4e63, 0x5134,
  0x672c, 0x6c6e, 0x7726, 0x4b24, 0x577a, 0x507c, 0x4a69, 0x6c7f,
  0x6178, 0x6323, 0x5237, 0x5b61, 0x604d, 0x6c69, 0x5c38, 0x6051,
  0x7034, 0x753b, 0x6653, 0x6538, 0x4962, 0x752a, 0x4a68, 0x4f50,
  0x5d6e, 0x7721, 0x5474, 0x6826, 0x5a5e, 0x7364, 0x7d78, 0x6553,
  0x4f63, 0x6731, 0x7c5b, 0x5f63, 0x797c, 0x733b, 0x7053, 0x7660,
  0x5f54, 0x7425, 0x6570, 0x5a59, 0x6421, 0x696e, 0x576c, 0x5b45,
  0x5d3b, 0x7921, 0x6b5e, 0x604c, 0x7c66, 0x5f21, 0x784b, 0x5c20,
  0x7237, 0x5f52, 0x575e, 0x7c4a, 0x4e43, 0x7c4c, 0x5639, 0x5839,
  0x7e34, 0x4e42, 0x783e, 0x6e67, 0x6e66, 0x5477, 0x6969, 0x596a,
  0x5b44, 0x5b60, 0x6a31, 0x6b4c, 0x485f, 0x5929, 0x5b47, 0x5775,
  0x7525, 0x493a, 0x6b59, 0x6050, 0x5b63, 0x4f21, 0x6d31, 0x6e61,
  0x5b46, 0x7d32, 0x5222, 0x514b, 0x4b27, 0x4a24, 0x5275, 0x753a,
  0x6a75, 0x5d54, 0x7752, 0x7c45, 0x4a4b, 0x516b, 0x706b, 0x6248,
  0x6b58, 0x4f62, 0x7852, 0x582a, 0x526a, 0x7c44, 0x675f, 0x6730,
  0x4b6c, 0x744d, 0x6857, 0x595a, 0x7f7d, 0x6821, 0x7424, 0x7e5a,
  0x7f4c, 0x564d, 0x613d, 0x6968, 0x4f20, 0x7d3d, 0x7328, 0x4f23,
  0x5e22, 0x5c3b, 0x572a, 0x7f3f, 0x7949, 0x6820, 0x7f2c, 0x6164,
  0x6d63, 0x7779, 0x7c7e, 0x744c, 0x5a22, 0x7c3d, 0x776d, 0x6322,
  0x5f20, 0x6238, 0x7d25, 0x5955, 0x6c54, 0x6b5b, 0x576f, 0x6652,
  0x786d, 0x5345, 0x7920, 0x5b62, 0x485e, 0x5774, 0x507d, 0x5f4a,
  0x5a58, 0x7479, 0x515d, 0x6154, 0x784a, 0x585b, 0x666d, 0x5e3d,
  0x772e, 0x5761, 0x7046, 0x7948, 0x6770, 0x7d3c, 0x5476, 0x6856,
  0x7131, 0x7629, 0x5c43, 0x5c42, 0x717a, 0x726c, 0x563a, 0x7f61,
  0x5945, 0x6065, 0x564c, 0x7c5a, 0x5236, 0x5a5b, 0x7330, 0x6823,
  0x546c, 0x6478, 0x6e3e, 0x4a5b, 0x4828, 0x687b, 0x666c, 0x6733,
  0x7845, 0x497d, 0x7d7b, 0x5b7d, 0x6132, 0x4a32, 0x786c, 0x693d,
  0x795c, 0x7236, 0x7d42, 0x6f57, 0x4e4c, 0x5635, 0x497c, 0x675e,
  0x796b, 0x6260, 0x6777, 0x7427, 0x7d5d, 0x786f, 0x7c2a, 0x6568,
  0x6a74, 0x637b, 0x6e60, 0x7839, 0x714f, 0x5351, 0x7478, 0x5965,
  0x5760, 0x7171, 0x5e32, 0x4876, 0x5777, 0x7029, 0x6b5a, 0x504e,
  0x7f6e, 0x7f60, 0x6420, 0x6e63, 0x7f3e, 0x604f, 0x726a, 0x5650,
  0x5b41, 0x7844, 0x6124, 0x647b, 0x723e, 0x6573, 0x4f7d, 0x6e62,
  0x6e7d, 0x5e4d, 0x7c39, 0x6f7f, 0x604e, 0x6d5a, 0x607c, 0x4e62,
  0x4a5a, 0x7847, 0x776c, 0x4f49, 0x6768, 0x4f48, 0x6e39, 0x6d30,
  0x5344, 0x6f56, 0x693c, 0x484e, 0x7333, 0x7846, 0x7c79, 0x5d3a,
  0x775e, 0x7759, 0x7369, 0x735c, 0x5c3a, 0x4a3c, 0x4e4f, 0x7f39,
  0x4f4b, 0x747b, 0x516a, 0x6e5d, 0x4859, 0x4f22, 0x7027, 0x6d22,
  0x714e, 0x6d55, 0x5964, 0x757e, 0x5176, 0x5a36, 0x7076, 0x797e,
  0x797f, 0x732b, 0x5944, 0x505e, 0x4825, 0x5e4c, 0x4858, 0x5d69,
  0x7e47, 0x616e, 0x5731, 0x4e7d, 0x5449, 0x4e5d, 0x7e26, 0x6f66,
  0x6375, 0x5d68, 0x555a, 0x7729, 0x5076, 0x786e, 0x7e55, 0x7758,
  0x4b26, 0x6f7e, 0x5171, 0x5759, 0x4971, 0x5d6b, 0x6674, 0x662c,
  0x6f59, 0x647a, 0x603f, 0x4871, 0x7f69, 0x7026, 0x5430, 0x4e7c,
  0x6b35, 0x534d, 0x6a77, 0x7979, 0x576e, 0x7f4f, 0x5165, 0x5f23,
  0x653b, 0x7c3a, 0x6432, 0x7f4e, 0x5967, 0x662f, 0x6a2b, 0x7265,
  0x7278, 0x5947, 0x546f, 0x592b, 0x5966, 0x6074, 0x6722, 0x5471,
  0x7071, 0x4831, 0x7367, 0x6169, 0x5b7c, 0x736c, 0x7d7a, 0x6b34,
  0x7c55, 0x7d24, 0x7c54, 0x6a30, 0x5c4b, 0x606e, 0x7143, 0x5954,
  0x5d6a, 0x5634, 0x514e, 0x5e68, 0x5e5d, 0x5554, 0x4a55, 0x4f53,
  0x7021, 0x5e76, 0x7264, 0x6c7e, 0x4b21, 0x747d, 0x7070, 0x5f45,
  0x4a4d, 0x6759, 0x5542, 0x7578, 0x497f, 0x4b66, 0x4935, 0x672b,
  0x5557, 0x7628, 0x762b, 0x6043, 0x5776, 0x7524, 0x7644, 0x6b55,
  0x6244, 0x5c35, 0x7e7e, 0x7738, 0x7c29, 0x557e, 0x6245, 0x7c57,
  0x5864, 0x5a5a, 0x4f52, 0x4b61, 0x7052, 0x5579, 0x5637, 0x5b7f,
  0x653a, 0x662e, 0x5771, 0x696b, 0x5f44, 0x6077, 0x4b53, 0x4a5d,
  0x515e, 0x7778, 0x7323, 0x6b45, 0x497e, 0x7142, 0x617e, 0x744f,
  0x4e5c, 0x6e7c, 0x542b, 0x5d57, 0x7426, 0x6f6a, 0x614d, 0x7838,
  0x6049, 0x4824, 0x794b, 0x6e38, 0x6127, 0x5b37, 0x6552, 0x5e5c,
  0x6535, 0x6c79, 0x5770, 0x6629, 0x7647, 0x5e6b, 0x733e, 0x7940,
  0x773b, 0x6a5a, 0x7149, 0x5c29, 0x762a, 0x5d35, 0x5d34, 0x6b44,
  0x5243, 0x7346, 0x5b23, 0x6c78, 0x5638, 0x5758, 0x7041, 0x5e71,
  0x5d65, 0x7366, 0x7144, 0x7731, 0x5e5f, 0x5738, 0x6c3b, 0x5242,
  0x7037, 0x7344, 0x4827, 0x744e, 0x485b, 0x545e, 0x5730, 0x5f76,
  0x4f6d, 0x5769, 0x727a, 0x5137, 0x7740, 0x4f6c, 0x6f79, 0x7020,
  0x7827, 0x7361, 0x6c7b, 0x5e6a, 0x7341, 0x614c, 0x6463, 0x5170,
  0x4a6b, 0x7826, 0x5136, 0x7625, 0x6628, 0x4934, 0x6e7f, 0x4f4a,
  0x4979, 0x5f22, 0x6b54, 0x4937, 0x7874, 0x5b7e, 0x4a6a, 0x5e4f,
  0x4b20, 0x6374, 0x7c25, 0x776f, 0x4e7f, 0x5b29, 0x5049, 0x485a,
  0x614f, 0x4936, 0x6b57, 0x6a55, 0x592a, 0x662b, 0x644d, 0x523d,
  0x7c47, 0x7877, 0x5d73, 0x5a3d, 0x5961, 0x5e65, 0x506d, 0x5274,
  0x495a, 0x5a55, 0x7675, 0x605b, 0x5448, 0x7023, 0x5925, 0x6948,
  0x775b, 0x5a54, 0x676b, 0x5725, 0x5f3d, 0x6157, 0x6732, 0x5f3c,
  0x5164, 0x644c, 0x6b56, 0x7464, 0x533f, 0x5470, 0x5d64, 0x5473,
  0x6860, 0x5724, 0x7624, 0x7449, 0x666f, 0x6d62, 0x7d5c, 0x6d54,
  0x6c57, 0x5e4e, 0x5e49, 0x5048, 0x6377, 0x496d, 0x673d, 0x5f3f,
  0x7f49, 0x776e, 0x5d28, 0x7f6a, 0x5946, 0x5459, 0x623b, 0x6423,
  0x7957, 0x5838, 0x6475, 0x633c, 0x717d, 0x5c51, 0x694b, 0x6534,
  0x674d, 0x7d4d, 0x6d7d, 0x5d56, 0x7769, 0x583b, 0x6064, 0x7448,
  0x674c, 0x7841, 0x7840, 0x7646, 0x7641, 0x6042, 0x7556, 0x7e54,
  0x7535, 0x7978, 0x6474, 0x6376, 0x783a, 0x7869, 0x7f48, 0x676a,
  0x5c34, 0x7275, 0x5848, 0x4855, 0x6422, 0x706a, 0x6b51, 0x4b71,
  0x6b50, 0x7627, 0x7933, 0x4e21, 0x7936, 0x794a, 0x633f, 0x6e5c,
  0x5b79, 0x5561, 0x6053, 0x614e, 0x5d2b, 0x4931, 0x7768, 0x6958,
  0x5d37, 0x696a, 0x7f38, 0x7c61, 0x646a, 0x4854, 0x504b, 0x6328,
  0x5178, 0x5733, 0x7876, 0x607f, 0x5b78, 0x6c75, 0x7c60, 0x4a4a,
  0x797b, 0x6c55, 0x4955, 0x635b, 0x4857, 0x4e6e, 0x5b7b, 0x744a,
  0x744b, 0x5c37, 0x7579, 0x707d, 0x7141, 0x7868, 0x6e48, 0x6e7e,
  0x5956, 0x585a, 0x5a70, 0x7674, 0x514a, 0x5c5d, 0x7445, 0x552c,
  0x552f, 0x5d59, 0x5265, 0x5d47, 0x5e3c, 0x5c4a, 0x586f, 0x7743,
  0x7179, 0x7534, 0x5e5e, 0x7267, 0x4b78, 0x7923, 0x4e5f, 0x5b39,
  0x5350, 0x7e37, 0x6a2a, 0x7130, 0x7c78, 0x6965, 0x506c, 0x552e,
  0x655b, 0x7d75, 0x5f47, 0x4f74, 0x5059, 0x5d51, 0x6a33, 0x7360,
  0x5663, 0x656b, 0x7374, 0x5960, 0x6c56, 0x5f3e, 0x557a, 0x643d,
  0x506f, 0x725a, 0x5374, 0x5c50, 0x4970, 0x7626, 0x4930, 0x7c4f,
  0x7621, 0x4e20, 0x4e23, 0x4b23, 0x674f, 0x583a, 0x5f57, 0x5d36,
  0x4e7e, 0x725e, 0x6275, 0x6e78, 0x6e7b, 0x7274, 0x4b22, 0x4e5e,
  0x4e22, 0x563d, 0x7537, 0x533e, 0x674e, 0x7770, 0x5a57, 0x5a56,
  0x6b53, 0x666e, 0x6a76, 0x5b7a, 0x5347, 0x4a65, 0x5f56, 0x7536,
  0x6d7c, 0x7e3a, 0x544b, 0x4826, 0x6a25, 0x4f77, 0x7d74, 0x4870,
  0x5773, 0x605d, 0x7663, 0x5058, 0x5b40, 0x7835, 0x555d, 0x7640,
  0x735f, 0x4e59, 0x5154, 0x5c53, 0x4954, 0x6a24, 0x7231, 0x4856,
  0x7444, 0x7871, 0x6c44, 0x7073, 0x6371, 0x5353, 0x5a51, 0x7421,
  0x4873, 0x496c, 0x6537, 0x5f62, 0x5e3f, 0x5528, 0x5835, 0x5c7b,
  0x5529, 0x496f, 0x5867, 0x747a, 0x7447, 0x5433, 0x5951, 0x505b,
  0x575b, 0x695d, 0x492c, 0x5b38, 0x5b75, 0x502c, 0x4a3f, 0x6c47,
  0x6f78, 0x6758, 0x715d, 0x712c, 0x5d2a, 0x6126, 0x6246, 0x717c,
  0x6148, 0x7d2e, 0x6456, 0x7266, 0x4f7c, 0x5d67, 0x712f, 0x535c,
  0x5575, 0x6e75, 0x6e74, 0x5e3e, 0x6b52, 0x7562, 0x617b, 0x6a32,
  0x6669, 0x5432, 0x7e21, 0x715c, 0x633e, 0x6d33, 0x7643, 0x5f39,
  0x7843, 0x5963, 0x6339, 0x5339, 0x7339, 0x4933, 0x5e64, 0x4b3d,
  0x7354, 0x776b, 0x4a54, 0x4a27, 0x4f45, 0x542a, 0x7446, 0x544a,
  0x6048, 0x5f6d, 0x5157, 0x532a, 0x6a4d, 0x7c7b, 0x715f, 0x6964,
  0x5d31, 0x614b, 0x712e, 0x5e59, 0x662a, 0x7f71, 0x7551, 0x4e79,
  0x6c77, 0x4a64, 0x6d75, 0x6668, 0x5434, 0x507f, 0x552b, 0x5b43,
  0x7879, 0x5727, 0x4821, 0x6b6d, 0x6168, 0x5458, 0x5f71, 0x786b,
  0x4f73, 0x6967, 0x5a3c, 0x7d6e, 0x502f, 0x4b7b, 0x525d, 0x5167,
  0x7563, 0x7e46, 0x612c, 0x513c, 0x4b60, 0x6966, 0x513f, 0x5131,
  0x796f, 0x7720, 0x7956, 0x6d3d, 0x552a, 0x796e, 0x4a3e, 0x7969,
  0x7e43, 0x4e3d, 0x732a, 0x4b3c, 0x622f, 0x783b, 0x7620, 0x6b6c,
  0x7723, 0x584b, 0x5d66, 0x6c6d, 0x6525, 0x517b, 0x4b70, 0x5a50,
  0x5d5c, 0x6067, 0x7642, 0x7332, 0x666b, 0x6625, 0x675b, 0x695c,
  0x6d74, 0x523c, 0x5a3f, 0x6465, 0x5726, 0x6f51, 0x5b22, 0x4e4e,
  0x6a71, 0x794e, 0x6f7b, 0x4b3f, 0x5d61, 0x5d30, 0x5c52, 0x5035,
  0x6f33, 0x5962, 0x597d, 0x597c, 0x597f, 0x5d33, 0x7f4b, 0x4b3e,
  0x6a70, 0x6026, 0x5e48, 0x5c61, 0x5525, 0x6624, 0x5a31, 0x6338,
  0x5f7d, 0x6b6f, 0x757d, 0x4b39, 0x5f7c, 0x643c, 0x5b28, 0x7d5f,
  0x6370, 0x622e, 0x7f7c, 0x4f3d, 0x7623, 0x496a, 0x6c51, 0x635a,
  0x734d, 0x546e, 0x5e2c, 0x4830, 0x5524, 0x5941, 0x6773, 0x5527,
  0x6c27, 0x6e3b, 0x7d77, 0x6241, 0x7255, 0x504a, 0x5d46, 0x5d5f,
  0x5746, 0x5c7a, 0x5e24, 0x7175, 0x5a53, 0x7622, 0x7c24, 0x5c45,
  0x6a4c, 0x7d4c, 0x597e, 0x6e77, 0x7230, 0x6536, 0x4932, 0x7059,
  0x6240, 0x7842, 0x7f2f, 0x6451, 0x7036, 0x5e58, 0x7d3f, 0x7f7f,
  0x5f7b, 0x5a52, 0x5f7f, 0x7c51, 0x7363, 0x6f65, 0x5677, 0x7531,
  0x7e57, 0x5e67, 0x5e4b, 0x734c, 0x633b, 0x614a, 0x5221, 0x584a,
  0x6524, 0x6627, 0x512b, 0x505a, 0x765d, 0x6e76, 0x6450, 0x7f7e,
  0x7530, 0x666a, 0x795a, 0x4a45, 0x6e3a, 0x784d, 0x796a, 0x7362,
  0x5338, 0x6b37, 0x7550, 0x5a3e, 0x6c46, 0x7c50, 0x7f4a, 0x5145,
  0x5352, 0x5924, 0x6d3c, 0x7e20, 0x7254, 0x7e79, 0x7c27, 0x6263,
  0x4851, 0x6531, 0x6462, 0x6d32, 0x7870, 0x6243, 0x655a, 0x6242,
  0x707c, 0x607e, 0x6076, 0x7d69, 0x6b6e, 0x4b63, 0x7233, 0x643f,
  0x7873, 0x5526, 0x5377, 0x7f45, 0x665a, 0x502e, 0x7475, 0x5325,
  0x656a, 0x5732, 0x6b69, 0x5348, 0x6f6f, 0x786a, 0x602f, 0x6665,
  0x625d, 0x7f65, 0x7065, 0x6179, 0x7031, 0x7058, 0x5b3b, 0x7834,
  0x6a4f, 0x4e78, 0x6b68, 0x4f6f, 0x5029, 0x5a6d, 0x5e70, 0x604b,
  0x6c33, 0x6453, 0x7239, 0x6e5f, 0x7d76, 0x644f, 0x4e69, 0x633a,
  0x6e70, 0x5d50, 0x5e39, 0x6a27, 0x7f64, 0x5f46, 0x5e38, 0x7533,
  0x5721, 0x7f44, 0x5b42, 0x574d, 0x675a, 0x6b6b, 0x785d, 0x6d4d,
  0x715e, 0x6851, 0x733a, 0x6e35, 0x5574, 0x5845, 0x6e34, 0x7553,
  0x533b, 0x4b38, 0x5d25, 0x6863, 0x5927, 0x492f, 0x6c23, 0x6530,
  0x765c, 0x6d4c, 0x5671, 0x5f38, 0x776a, 0x5c73, 0x785c, 0x693f,
  0x7022, 0x7f2e, 0x784c, 0x6a26, 0x5028, 0x707f, 0x6a54, 0x7f47,
  0x496e, 0x5c36, 0x6156, 0x7c7a, 0x7259, 0x5324, 0x4f44, 0x625c,
  0x7441, 0x5c23, 0x7d5e, 0x5173, 0x5c31, 0x763d, 0x6626, 0x7765,
  0x6b4f, 0x6961, 0x6335, 0x5e73, 0x4833, 0x7671, 0x5e66, 0x6655,
  0x695b, 0x525c, 0x643e, 0x785f, 0x6f45, 0x574c, 0x7440, 0x4b7a,
  0x695f, 0x5055, 0x5844, 0x537c, 0x5b36, 0x7728, 0x7040, 0x7532,
  0x7c3c, 0x6d77, 0x7f46, 0x4e58, 0x7d59, 0x7347, 0x5245, 0x7865,
  0x7730, 0x6a73, 0x6373, 0x574f, 0x573b, 0x4820, 0x7277, 0x523f,
  0x5655, 0x6355, 0x6728, 0x6334, 0x7420, 0x7f41, 0x6f2c, 0x502b,
  0x7f40, 0x5130, 0x7552, 0x7276, 0x5a39, 0x5166, 0x6145, 0x7f29,
  0x5034, 0x5a6c, 0x602e, 0x533a, 0x7c63, 0x5a38, 0x525f, 0x7d58,
  0x6337, 0x6f58, 0x517a, 0x6b6a, 0x6533, 0x7e23, 0x5264, 0x5263,
  0x6336, 0x6846, 0x513e, 0x4a39, 0x7f28, 0x6563, 0x7325, 0x7f43,
  0x5c30, 0x7f70, 0x7864, 0x4b3b, 0x694a, 0x6a21, 0x4850, 0x722a,
  0x6277, 0x7129, 0x7951, 0x693e, 0x4a44, 0x6b65, 0x6532, 0x7e56,
  0x4f6e, 0x7324, 0x7f2b, 0x5834, 0x754d, 0x6945, 0x6b4e, 0x5220,
  0x7943, 0x6c2c, 0x7f79, 0x512a, 0x757b, 0x625e, 0x4853, 0x7c3f,
  0x5866, 0x793b, 0x6167, 0x756d, 0x5f41, 0x5940, 0x5045, 0x5d60,
  0x7128, 0x6276, 0x6259, 0x7945, 0x522c, 0x7932, 0x785e, 0x6b2c,
  0x6331, 0x5563, 0x6258, 0x6d7f, 0x5b3d, 0x5c6d, 0x7837, 0x7922,
  0x7443, 0x5f6c, 0x6144, 0x6939, 0x644e, 0x6755, 0x6d76, 0x6e25,
  0x793a, 0x7f2a, 0x6d4f, 0x797a, 0x6654, 0x5861, 0x6c2f, 0x627d,
  0x7975, 0x7974, 0x7232, 0x632a, 0x625a, 0x507e, 0x5044, 0x5277,
  0x537f, 0x654d, 0x5f6f, 0x6255, 0x6330, 0x7442, 0x7733, 0x6621,
  0x713a, 0x647d, 0x7935, 0x6765, 0x502a, 0x6c71, 0x7e5f, 0x7c62,
  0x525e, 0x5139, 0x745d, 0x737d, 0x6a3e, 0x6e37, 0x6e5e, 0x6944,
  0x5926, 0x6121, 0x792c, 0x5b5d, 0x683e, 0x5b5c, 0x6960, 0x7c35,
  0x7377, 0x7c26, 0x706d, 0x5037, 0x603e, 0x6d57, 0x5a3b, 0x5d32,
  0x5d4d, 0x5262, 0x5d41, 0x5e27, 0x5b68, 0x7368, 0x483f, 0x5b74,
  0x536d, 0x5036, 0x7977, 0x483e, 0x5f7e, 0x5b5f, 0x4a47, 0x6a57,
  0x6069, 0x7f42, 0x4b3a, 0x6a4e, 0x4a67, 0x6620, 0x536c, 0x7e78,
  0x5144, 0x7c21, 0x6354, 0x7764, 0x5c60, 0x6749, 0x747c, 0x6c68,
  0x6477, 0x6a49, 0x5d53, 0x6f2f, 0x6f2e, 0x784f, 0x6e36, 0x6c26,
  0x5a6f, 0x6962, 0x6c2e, 0x4b7c, 0x5031, 0x7867, 0x6333, 0x787f,
  0x5239, 0x6623, 0x573a, 0x7e41, 0x7e51, 0x6938, 0x656e, 0x6c21,
  0x6c50, 0x6b64, 0x7030, 0x4b35, 0x6d56, 0x5521, 0x5e4a, 0x6f44,
  0x6c41, 0x5a3a, 0x5231, 0x5768, 0x7e50, 0x5e5b, 0x4e3c, 0x5e45,
  0x5b2b, 0x7d3e, 0x765f, 0x4e49, 0x4a46, 0x4978, 0x793d, 0x5125,
  0x754c, 0x6664, 0x5847, 0x6839, 0x7e4d, 0x7f25, 0x5425, 0x5e61,
  0x5d63, 0x6476, 0x6b67, 0x7e53, 0x6449, 0x4b34, 0x5147, 0x536f,
  0x6622, 0x5335, 0x6c40, 0x7257, 0x6b2f, 0x6657, 0x7271, 0x7f5d,
  0x5520, 0x4969, 0x5523, 0x5860, 0x6c43, 0x7474, 0x4a38, 0x6271,
  0x5376, 0x545b, 0x5978, 0x737c, 0x7270, 0x5f7a, 0x7f67, 0x6d51,
  0x5d4c, 0x717f, 0x6448, 0x6e59, 0x7d4f, 0x6e31, 0x5648, 0x7f5c,
  0x634d, 0x6f28, 0x5b77, 0x672f, 0x5334, 0x6d4e, 0x6c70, 0x6c22,
  0x765e, 0x7f24, 0x5c28, 0x5146, 0x5445, 0x5522, 0x536e, 0x644b,
  0x522f, 0x697d, 0x537e, 0x7859, 0x5e5a, 0x4852, 0x7659, 0x553d,
  0x486d, 0x5f70, 0x7732, 0x745c, 0x7836, 0x663d, 0x6228, 0x6656,
  0x5b53, 0x644a, 0x7662, 0x486c, 0x5267, 0x634f, 0x4a3b, 0x774d,
  0x4973, 0x7f5f, 0x7c75, 0x7376, 0x6c32, 0x6c3a, 0x693b, 0x5837,
  0x4839, 0x757a, 0x6c35, 0x4e7b, 0x6029, 0x705b, 0x5b6b, 0x5b2a,
  0x5b6a, 0x654c, 0x6d49, 0x5846, 0x6d48, 0x6b2e, 0x6f2b, 0x4f2e,
  0x6764, 0x5576, 0x6b29, 0x6b66, 0x5439, 0x492e, 0x6c6b, 0x6b28,
  0x5741, 0x5e60, 0x5337, 0x7658, 0x7168, 0x5d62, 0x7d39, 0x5159,
  0x7942, 0x5f6e, 0x756c, 0x683b, 0x7f73, 0x575a, 0x553c, 0x4f3c,
  0x553f, 0x4f3f, 0x754f, 0x706c, 0x7d38, 0x654e, 0x654f, 0x6f7a,
  0x5b25, 0x4f47, 0x6234, 0x7c53, 0x7d27, 0x4e7a, 0x693a, 0x5735,
  0x765b, 0x5054, 0x6a48, 0x767d, 0x4e3f, 0x5836, 0x7575, 0x683a,
  0x6147, 0x724d, 0x7950, 0x506e, 0x486f, 0x7359, 0x5368, 0x574e,
  0x5c2b, 0x724c, 0x597b, 0x494d, 0x6151, 0x6146, 0x6549, 0x6c3d,
  0x703d, 0x7767, 0x5e63, 0x5336, 0x663c, 0x5327, 0x5276, 0x6052,
  0x4e5b, 0x6f25, 0x5f73, 0x724f, 0x6b36, 0x5070, 0x6445, 0x6c34,
  0x6b2b, 0x4929, 0x5079, 0x5f2c, 0x5f51, 0x5f50, 0x6a51, 0x4f46,
  0x7858, 0x4a66, 0x494c, 0x7f5e, 0x7d26, 0x7159, 0x5d24, 0x6d50,
  0x5f40, 0x5943, 0x634e, 0x6841, 0x7d61, 0x4f41, 0x6471, 0x5025,
  0x695e, 0x5c62, 0x765a, 0x4e75, 0x5e62, 0x5259, 0x5d40, 0x5c63,
  0x764c, 0x5b5e, 0x5e7d, 0x6667, 0x6470, 0x5c75, 0x7322, 0x5e3b,
  0x4e5a, 0x7655, 0x5c74, 0x7e52, 0x4b62, 0x5d4f, 0x745f, 0x605c,
  0x773a, 0x7e6d, 0x6b61, 0x663f, 0x5030, 0x5d43, 0x706f, 0x5024,
  0x494f, 0x6357, 0x7654, 0x5d27, 0x5c33, 0x5820, 0x6666, 0x5271,
  0x4e74, 0x5057, 0x705a, 0x482c, 0x4b37, 0x7135, 0x5d4e, 0x5465,
  0x6748, 0x6f75, 0x763c, 0x4b36, 0x5720, 0x6c6c, 0x4a61, 0x6439,
  0x5a6e, 0x597a, 0x763f, 0x777b, 0x7256, 0x5373, 0x7c52, 0x737f,
  0x5424, 0x6257, 0x712b, 0x5331, 0x486e, 0x6256, 0x5950, 0x553e,
  0x6b60, 0x5253, 0x6079, 0x6562, 0x5975, 0x6c42, 0x4e68, 0x582c,
  0x6438, 0x7821, 0x7820, 0x5c2a, 0x6935, 0x5f3b, 0x527d, 0x7722,
  0x4928, 0x5e7c, 0x5c25, 0x4869, 0x5539, 0x4e55, 0x5e7f, 0x712a,
  0x7125, 0x622b, 0x5161, 0x5175, 0x5e7e, 0x674b, 0x5a69, 0x5a68,
  0x5538, 0x553b, 0x553a, 0x763e, 0x6d53, 0x745e, 0x7639, 0x7459,
  0x4f69, 0x7f59, 0x716b, 0x6767, 0x5a6b, 0x5b59, 0x7c74, 0x7423,
  0x5535, 0x5252, 0x545a, 0x782c, 0x6b63, 0x5855, 0x6d52, 0x6150,
  0x7976, 0x6444, 0x5244, 0x5027, 0x6141, 0x6d6d, 0x5455, 0x782f,
  0x5033, 0x663e, 0x5a6a, 0x5831, 0x563b, 0x7158, 0x4a2c, 0x7124,
  0x5974, 0x5977, 0x7458, 0x7252, 0x7657, 0x6066, 0x767c, 0x6834,
  0x7971, 0x6527, 0x4e54, 0x6b62, 0x7127, 0x6874, 0x7c20, 0x764f,
  0x724e, 0x535f, 0x7d2f, 0x745b, 0x7477, 0x726d, 0x6d7e, 0x764e,
  0x5026, 0x4e3e, 0x492b, 0x494e, 0x4957, 0x5d42, 0x7249, 0x6a50,
  0x6349, 0x6639, 0x5b6f, 0x6356, 0x6c3c, 0x7823, 0x6140, 0x7e66,
  0x4b31, 0x4b6f, 0x497b, 0x6b7d, 0x7033, 0x5040, 0x7735, 0x6d2c,
  0x767f, 0x7766, 0x745a, 0x4b5a, 0x4b52, 0x6c4d, 0x6c4c, 0x4b6e,
  0x6d2f, 0x5427, 0x774c, 0x5426, 0x5069, 0x6b31, 0x5c2c, 0x5d52,
  0x775a, 0x5830, 0x4868, 0x697c, 0x756f, 0x5056, 0x6638, 0x4e6b,
  0x5723, 0x486b, 0x755e, 0x716a, 0x4e57, 0x7f63, 0x6548, 0x5b64,
  0x6a53, 0x734f, 0x5c2f, 0x5921, 0x7422, 0x5230, 0x6526, 0x7d3b,
  0x5078, 0x5444, 0x6b2a, 0x6661, 0x5f67, 0x4a41, 0x7165, 0x7358,
  0x5740, 0x7773, 0x5438, 0x6473, 0x5b76, 0x6250, 0x6c29, 0x4f40,
  0x6b25, 0x6a39, 0x5e55, 0x5534, 0x5b24, 0x773d, 0x4849, 0x4a3a,
  0x6b24, 0x5b58, 0x695a, 0x6a4b, 0x6b30, 0x785b, 0x5f79, 0x6b27,
  0x7c34, 0x7164, 0x6754, 0x654b, 0x5032, 0x5a65, 0x7467, 0x774f,
  0x5722, 0x4e56, 0x785a, 0x6955, 0x654a, 0x7055, 0x523e, 0x5920,
  0x5133, 0x754e, 0x6a52, 0x5266, 0x7054, 0x536b, 0x5e3a, 0x5976,
  0x5942, 0x5c2e, 0x5e54, 0x7455, 0x6b49, 0x6555, 0x7559, 0x697f,
  0x5156, 0x5151, 0x7749, 0x4f5a, 0x663b, 0x6b7c, 0x7f58, 0x5755,
  0x595d, 0x7454, 0x4f3e, 0x5150, 0x492a, 0x5421, 0x5537, 0x7549,
  0x613e, 0x7f78, 0x6d6c, 0x796d, 0x7831, 0x5e2f, 0x5e2e, 0x562c,
  0x5662, 0x6660, 0x5a64, 0x4a51, 0x7638, 0x5469, 0x595c, 0x6545,
  0x5f3a, 0x5b6e, 0x6934, 0x7548, 0x7742, 0x5326, 0x6521, 0x6766,
  0x6a4a, 0x6544, 0x4e77, 0x7476, 0x7e6c, 0x7457, 0x486a, 0x5e79,
  0x4832, 0x4a60, 0x5124, 0x7e6f, 0x5468, 0x6f5b, 0x6852, 0x5b71,
  0x735b, 0x5a67, 0x4f39, 0x6b33, 0x4838, 0x4b30, 0x6b7f, 0x663a,
  0x4865, 0x7471, 0x526d, 0x754b, 0x6635, 0x6f26, 0x4f38, 0x5c5c,
  0x7043, 0x777a, 0x534b, 0x5536, 0x7327, 0x6947, 0x535e, 0x5c77,
  0x7248, 0x5541, 0x5971, 0x5b70, 0x7d68, 0x6447, 0x7670, 0x573d,
  0x707e, 0x5e44, 0x6253, 0x7c37, 0x6c5d, 0x5c76, 0x6e58, 0x522e,
  0x724b, 0x7656, 0x6071, 0x6c3f, 0x5e57, 0x7651, 0x7f5b, 0x6d3f,
  0x6a20, 0x7e6e, 0x5863, 0x7167, 0x626d, 0x7470, 0x5321, 0x7148,
  0x6a6d, 0x5f68, 0x5953, 0x5d7d, 0x6d2e, 0x7574, 0x7649, 0x6446,
  0x6d29, 0x6634, 0x673c, 0x7866, 0x4925, 0x483b, 0x7456, 0x6237,
  0x4924, 0x774e, 0x6554, 0x6b26, 0x6348, 0x6464, 0x7748, 0x504d,
  0x5132, 0x5923, 0x7d71, 0x484d, 0x612f, 0x4a35, 0x5c5f, 0x7d5b,
  0x7527, 0x4a5c, 0x724a, 0x5f66, 0x5b73, 0x5c6c, 0x737e, 0x536a,
  0x5073, 0x5531, 0x6142, 0x4f3b, 0x5e35, 0x4949, 0x5233, 0x6637,
  0x4b55, 0x6441, 0x6f74, 0x7970, 0x5365, 0x4f55, 0x6d6f, 0x6c37,
  0x674a, 0x6840, 0x6843, 0x5232, 0x672a, 0x5b5b, 0x7965, 0x6a6c,
  0x7225, 0x5970, 0x7c36, 0x6c5c, 0x7d5a, 0x4a63, 0x6842, 0x6d28,
  0x5258, 0x4948, 0x6937, 0x5530, 0x4b33, 0x6836, 0x563c, 0x4864,
  0x5d49, 0x6d71, 0x5533, 0x6831, 0x6120, 0x733d, 0x4867, 0x5749,
  0x524d, 0x5270, 0x652c, 0x5a30, 0x7224, 0x5e29, 0x5229, 0x714b,
  0x652f, 0x6d4b, 0x7648, 0x7064, 0x5261, 0x6f5e, 0x6830, 0x6651,
  0x5a66, 0x7451, 0x6f32, 0x5343, 0x5532, 0x7126, 0x7d70, 0x4e51,
  0x494b, 0x763b, 0x5973, 0x483a, 0x5f35, 0x5464, 0x4a50, 0x6f4d,
  0x792f, 0x7c46, 0x6e5b, 0x753d, 0x5f43, 0x734e, 0x5f42, 0x4f29,
  0x7c6d, 0x7f5a, 0x6f47, 0x642c, 0x4a40, 0x5051, 0x7955, 0x567b,
  0x763a, 0x7e7b, 0x7227, 0x7e7a, 0x5c6b, 0x703c, 0x6c5f, 0x4e48,
  0x4866, 0x6663, 0x6636, 0x7320, 0x7c6c, 0x7761, 0x5a2c, 0x6070,
  0x6761, 0x5922, 0x593d, 0x4f3a, 0x6c5e, 0x652e, 0x566d, 0x7473,
  0x6d2b, 0x4f7f, 0x697e, 0x5854, 0x6440, 0x7357, 0x5f34, 0x4823,
  0x5e56, 0x494a, 0x593c, 0x5c22, 0x672e, 0x4a62, 0x767e, 0x7c3e,
  0x6443, 0x7170, 0x6f61, 0x5748, 0x7861, 0x5656, 0x5066, 0x5a2f,
  0x616b, 0x743d, 0x5149, 0x6979, 0x6760, 0x6c4f, 0x6978, 0x5371,
  0x6936, 0x7226, 0x7635, 0x7245, 0x576b, 0x7650, 0x4b32, 0x6f21,
  0x4b4d, 0x6225, 0x7964, 0x4b4c, 0x6452, 0x5a61, 0x642f, 0x7032,
  0x6662, 0x5d7c, 0x754a, 0x4f35, 0x7d73, 0x5f37, 0x5e78, 0x7261,
  0x5e51, 0x7e69, 0x6442, 0x593f, 0x6224, 0x6b7e, 0x7760, 0x6f77,
  0x7d6b, 0x4e50, 0x5153, 0x4e53, 0x5b69, 0x6270, 0x7121, 0x6078,
  0x6d6e, 0x6946, 0x4b69, 0x5c5e, 0x593e, 0x5061, 0x7634, 0x5b3a,
  0x4f43, 0x7f55, 0x5454, 0x595f, 0x7379, 0x6351, 0x6028, 0x782e,
  0x5f36, 0x7637, 0x6d70, 0x5447, 0x715b, 0x5d48, 0x6039, 0x692a,
  0x6e30, 0x6273, 0x7349, 0x7120, 0x5d6d, 0x4e39, 0x7c6f, 0x4b4f,
  0x6833, 0x6139, 0x4945, 0x6a45, 0x6345, 0x4944, 0x7d3a, 0x7565,
  0x5d7f, 0x5f78, 0x4e38, 0x5d4b, 0x5c44, 0x5d26, 0x6931, 0x5c59,
  0x5857, 0x6631, 0x7860, 0x686d, 0x5673, 0x6d4a, 0x6227, 0x667d,
  0x7e36, 0x7123, 0x7f27, 0x6876, 0x6832, 0x7855, 0x5068, 0x7d4e,
  0x6a6f, 0x5364, 0x697b, 0x5a60, 0x4861, 0x6763, 0x6c59, 0x7e75,
  0x5939, 0x6038, 0x5c3d, 0x5c58, 0x7067, 0x4a34, 0x526c, 0x4b5f,
  0x543b, 0x4a2f, 0x7763, 0x7775, 0x5841, 0x5446, 0x7829, 0x4947,
  0x5359, 0x5a2e, 0x606d, 0x6a44, 0x6650, 0x7173, 0x5021, 0x515c,
  0x5c7d, 0x7c4e, 0x6e5a, 0x715a, 0x5c32, 0x794d, 0x6f20, 0x5127,
  0x6325, 0x6a47, 0x4e6a, 0x7c6e, 0x5050, 0x6e55, 0x7f54, 0x697a,
  0x6138, 0x5420, 0x757c, 0x6630, 0x6745, 0x5d58, 0x5b27, 0x5f31,
  0x7c69, 0x7577, 0x613b, 0x7762, 0x7f57, 0x656d, 0x5d21, 0x7166,
  0x643b, 0x6d45, 0x4f42, 0x6744, 0x5a63, 0x6633, 0x5862, 0x5228,
  0x667c, 0x5273, 0x5d2c, 0x5c4d, 0x5856, 0x6930, 0x5b35, 0x6e28,
  0x5320, 0x7774, 0x6975, 0x714a, 0x6547, 0x6f6e, 0x7653, 0x7c41,
  0x6e54, 0x574b, 0x5f6b, 0x7122, 0x4a7d, 0x6d73, 0x7f3b, 0x667f,
  0x4b7f, 0x7334, 0x5d7e, 0x6546, 0x5e50, 0x5e34, 0x6f76, 0x4f34,
  0x6974, 0x646d, 0x704d, 0x7931, 0x5b3c, 0x6762, 0x642e, 0x7934,
  0x743c, 0x4946, 0x6933, 0x514d, 0x677d, 0x6977, 0x6d69, 0x5160,
  0x6350, 0x507b, 0x613a, 0x5f6a, 0x6632, 0x6a46, 0x5379, 0x7450,
  0x4a26, 0x6353, 0x525b, 0x6541, 0x6c3e, 0x6163, 0x582f, 0x645d,
  0x5138, 0x512c, 0x7f56, 0x7d46, 0x4f7e, 0x7028, 0x7e45, 0x525a,
  0x6d68, 0x7f51, 0x795d, 0x7f7b, 0x5e28, 0x5f30, 0x686f, 0x497a,
  0x7453, 0x7244, 0x5a62, 0x573c, 0x7863, 0x6c4e, 0x7545, 0x4a7c,
  0x7d60, 0x7679, 0x603b, 0x7134, 0x587d, 0x677c, 0x6c28, 0x7636,
  0x5a29, 0x5e41, 0x4e64, 0x6757, 0x7854, 0x6e57, 0x7d49, 0x6729,
  0x7f50, 0x6b47, 0x6c49, 0x5141, 0x6f5a, 0x5d20, 0x7f26, 0x5754,
  0x512f, 0x7253, 0x5e7b, 0x645c, 0x6d25, 0x7174, 0x7e22, 0x6f71,
  0x6467, 0x673f, 0x5148, 0x756e, 0x5163, 0x4941, 0x6954, 0x5c4c,
  0x7e61, 0x7566, 0x7e31, 0x626f, 0x7e68, 0x6677, 0x4e3b, 0x603a,
  0x6e56, 0x7177, 0x7f21, 0x4b4e, 0x6f70, 0x7c77, 0x5b34, 0x657c,
  0x5629, 0x7176, 0x5457, 0x5456, 0x6e33, 0x5d3c, 0x4e3a, 0x576a,
  0x7c68, 0x573f, 0x664d, 0x7652, 0x4968, 0x7d21, 0x4940, 0x6a23,
  0x5223, 0x5367, 0x636d, 0x6f23, 0x4b54, 0x5840, 0x6976, 0x5a7d,
  0x5366, 0x5a28, 0x5b5a, 0x5f5d, 0x5f5c, 0x512e, 0x743f, 0x5851,
  0x4e65, 0x7c6b, 0x5843, 0x6e51, 0x5f5f, 0x6d3e, 0x7356, 0x6725,
  0x5323, 0x646c, 0x4f37, 0x615c, 0x5451, 0x514c, 0x5c47, 0x6724,
  0x6429, 0x6d24, 0x574a, 0x5850, 0x7c23, 0x4835, 0x5423, 0x5c7f,
  0x6747, 0x4822, 0x5020, 0x725c, 0x5441, 0x4e4b, 0x514f, 0x4a37,
  0x4e4a, 0x7e3d, 0x5b55, 0x7137, 0x6166, 0x6b79, 0x5938, 0x4927,
  0x677f, 0x7f7a, 0x735d, 0x7937, 0x796c, 0x7273, 0x554d, 0x6c48,
  0x6035, 0x6565, 0x484c, 0x5660, 0x5f33, 0x646f, 0x7e44, 0x6540,
  0x4e35, 0x766d, 0x7544, 0x5a7c, 0x7452, 0x7c49, 0x6a41, 0x5a7f,
  0x6344, 0x667e, 0x636c, 0x6746, 0x6741, 0x4b75, 0x6b21, 0x7973,
  0x7828, 0x7e3c, 0x5b54, 0x645f, 0x7057, 0x7547, 0x4a2e, 0x7631,
  0x686e, 0x6428, 0x7326, 0x6f22, 0x6153, 0x6529, 0x4926, 0x5d79,
  0x6c2b, 0x4943, 0x6564, 0x7862, 0x646e, 0x664c, 0x4a29, 0x5a2b,
  0x6f73, 0x6f50, 0x746d, 0x7056, 0x6679, 0x5745, 0x7066, 0x6a38,
  0x7155, 0x5152, 0x5268, 0x6f3d, 0x706e, 0x6740, 0x7079, 0x7e3f,
  0x6b78, 0x4e52, 0x6f3c, 0x6932, 0x7944, 0x602b, 0x7d29, 0x743e,
  0x6161, 0x556a, 0x5d4a, 0x605a, 0x6e50, 0x507a, 0x5e37, 0x5e40,
  0x7d41, 0x6557, 0x5f32, 0x4848, 0x685d, 0x4f36, 0x5a7e, 0x6d27,
  0x5d45, 0x6a6e, 0x5330, 0x4b49, 0x5440, 0x782b, 0x7576, 0x795f,
  0x554c, 0x6756, 0x5744, 0x5842, 0x4860, 0x5a2a, 0x6236, 0x682c,
  0x4834, 0x7f53, 0x636f, 0x504c, 0x5825, 0x664f, 0x7755, 0x615e,
  0x7754, 0x774b, 0x4956, 0x4921, 0x784e, 0x506a, 0x554f, 0x7d28,
  0x6c58, 0x6743, 0x5047, 0x5b57, 0x7f52, 0x636e, 0x7c76, 0x6742,
  0x713d, 0x5c6a, 0x5d44, 0x7c22, 0x6b7b, 0x593b, 0x6a22, 0x4975,
  0x5a35, 0x782a, 0x7371, 0x733c, 0x4a36, 0x702c, 0x6a40, 0x6523,
  0x684e, 0x4b73, 0x7c32, 0x5c6f, 0x5765, 0x5a25, 0x7069, 0x684f,
  0x5d78, 0x7d48, 0x595e, 0x527c, 0x6871, 0x787d, 0x694d, 0x4e34,
  0x6a69, 0x766c, 0x5a34, 0x527f, 0x5a79, 0x5b56, 0x5f5e, 0x7e6a,
  0x5c6e, 0x704c, 0x593a, 0x7678, 0x5023, 0x527e, 0x5935, 0x4b48,
  0x5b52, 0x7633, 0x722c, 0x6f46, 0x7571, 0x774a, 0x6466, 0x6971,
  0x6556, 0x6a68, 0x5a78, 0x7e5e, 0x7546, 0x5422, 0x5934, 0x554e,
  0x713c, 0x6e4b, 0x746c, 0x7221, 0x7154, 0x7466, 0x5937, 0x7632,
  0x7348, 0x5f2f, 0x767b, 0x4e37, 0x7378, 0x4f68, 0x6a6b, 0x645e,
  0x4a28, 0x5255, 0x5022, 0x6d44, 0x5743, 0x704f, 0x4f6b, 0x752c,
  0x6f3f, 0x752f, 0x6f3e, 0x7439, 0x4f79, 0x503d, 0x773f, 0x7f3a,
  0x7161, 0x6a6a, 0x703f, 0x7160, 0x4b7e, 0x746f, 0x6a43, 0x7541,
  0x6135, 0x5378, 0x677e, 0x4b68, 0x4b4b, 0x773e, 0x6055, 0x4b74,
  0x4b57, 0x7e40, 0x626e, 0x766f, 0x7163, 0x4e36, 0x6751, 0x4a7f,
  0x5254, 0x6a3d, 0x7068, 0x5c4f, 0x585d, 0x4863, 0x516d, 0x7247,
  0x7947, 0x5c5b, 0x7042, 0x522b, 0x5833, 0x5f59, 0x534a, 0x7673,
  0x7540, 0x664e, 0x5853, 0x5852, 0x6b20, 0x6226, 0x7d50, 0x6e32,
  0x6b23, 0x705d, 0x4a7e, 0x6221, 0x4a53, 0x5174, 0x6779, 0x495d,
  0x5135, 0x7370, 0x5824, 0x5a7b, 0x5827, 0x766e, 0x6d39, 0x5651,
  0x6d6b, 0x677b, 0x6347, 0x5443, 0x5e7a, 0x4e31, 0x6a65, 0x5e53,
  0x767a, 0x6676, 0x482b, 0x5e36, 0x6a64, 0x7157, 0x7351, 0x6567,
  0x4a4c, 0x503c, 0x793c, 0x6230, 0x7f20, 0x7c6a, 0x6543, 0x736f,
  0x7162, 0x4b4a, 0x503f, 0x4862, 0x5065, 0x6a42, 0x735a, 0x642b,
  0x524c, 0x6551, 0x746e, 0x7569, 0x587c, 0x522a, 0x7078, 0x7543,
  0x7669, 0x543d, 0x6862, 0x7d37, 0x6f38, 0x5060, 0x6649, 0x6d6a,
  0x6f39, 0x6e2c, 0x7c31, 0x4a2b, 0x7d4b, 0x7857, 0x503e, 0x5734,
  0x6e53, 0x6d26, 0x656c, 0x5742, 0x707b, 0x6e4d, 0x6542, 0x4837,
  0x6a67, 0x7469, 0x7739, 0x5063, 0x764d, 0x7568, 0x704e, 0x6459,
  0x6f3b, 0x532c, 0x4f65, 0x7d20, 0x6d20, 0x5c69, 0x7e3e, 0x6648,
  0x7830, 0x6849, 0x5c3c, 0x5826, 0x5129, 0x6f64, 0x6c36, 0x5c5a,
  0x7f23, 0x556c, 0x5f4d, 0x7133, 0x5a7a, 0x4e76, 0x734b, 0x4b45,
  0x655d, 0x6a5d, 0x6d79, 0x4a79, 0x5140, 0x4b56, 0x5936, 0x4a21,
  0x6d65, 0x5039, 0x604a, 0x7156, 0x7e4c, 0x5a24, 0x5075, 0x6b7a,
  0x573e, 0x6f3a, 0x6b75, 0x7151, 0x6941, 0x5f58, 0x7542, 0x755d,
  0x713f, 0x5d23, 0x5121, 0x664b, 0x792e, 0x7f68, 0x5b26, 0x6678,
  0x7220, 0x713e, 0x7438, 0x6528, 0x7150, 0x682f, 0x6970, 0x7139,
  0x7f35, 0x5f2e, 0x5247, 0x4f54, 0x6159, 0x7777, 0x6f35, 0x643a,
  0x5361, 0x7561, 0x6122, 0x516c, 0x5360, 0x555c, 0x657f, 0x6b74,
  0x5931, 0x7251, 0x7468, 0x7049, 0x6d64, 0x7776, 0x5062, 0x482f,
  0x7373, 0x5b31, 0x6f40, 0x543a, 0x524f, 0x6c20, 0x6b22, 0x4f28,
  0x4f64, 0x7e65, 0x484b, 0x626a, 0x6e4a, 0x5f29, 0x4b44, 0x6671,
  0x6b77, 0x6f53, 0x7145, 0x5053, 0x6458, 0x6b3d, 0x664a, 0x5d22,
  0x7d6a, 0x6368, 0x4b47, 0x655c, 0x6645, 0x6b76, 0x7e74, 0x587f,
  0x642a, 0x7c65, 0x4f67, 0x4f31, 0x526f, 0x7153, 0x7152, 0x6a3b,
  0x667b, 0x5747, 0x6b71, 0x5549, 0x6b3c, 0x5548, 0x5453, 0x5d6c,
  0x6435, 0x495c, 0x7734, 0x6341, 0x5225, 0x4a2a, 0x5038, 0x6045,
  0x5739, 0x6f34, 0x4f78, 0x7250, 0x752e, 0x484a, 0x6d47, 0x657d,
  0x716d, 0x7f22, 0x4f5c, 0x7f6d, 0x7668, 0x687d, 0x7461, 0x6a66,
  0x6d46, 0x487d, 0x5322, 0x772c, 0x7878, 0x7529, 0x645b, 0x6b3f,
  0x705c, 0x732c, 0x755c, 0x4e71, 0x4e70, 0x4a43, 0x7745, 0x7737,
  0x6973, 0x5e2b, 0x6461, 0x7c40, 0x4f5f, 0x6f43, 0x7d55, 0x7d54,
  0x4e6d, 0x5e47, 0x4f2b, 0x4e45, 0x7d63, 0x5f61, 0x543c, 0x5162,
  0x627e, 0x632f, 0x6054, 0x606c, 0x7849, 0x7d62, 0x4b79, 0x736b,
  0x4a31, 0x7048, 0x582e, 0x5930, 0x704b, 0x7c2c, 0x6c5b, 0x5f4c,
  0x746b, 0x6034, 0x7260, 0x7d23, 0x5933, 0x533d, 0x5c65, 0x4f30,
  0x7d57, 0x7c43, 0x7d7d, 0x6460, 0x673e, 0x703e, 0x6e4f, 0x766b,
  0x743b, 0x5f5b, 0x6f69, 0x766a, 0x5358, 0x503b, 0x7d65, 0x534c,
  0x6158, 0x6d67, 0x5341, 0x5764, 0x6644, 0x7856, 0x4920, 0x483d,
  0x6e2f, 0x607b, 0x544d, 0x743a, 0x6a2c, 0x537b, 0x6647, 0x6646,
  0x7e42, 0x6f52, 0x5246, 0x7039, 0x6940, 0x605f, 0x6e24, 0x6037,
  0x772f, 0x495f, 0x7246, 0x756b, 0x694c, 0x6c31, 0x6a5c, 0x746a,
  0x6641, 0x6027, 0x716c, 0x6957, 0x5363, 0x557c, 0x6d66, 0x6d61,
  0x6469, 0x5e2a, 0x5959, 0x6e2e, 0x524e, 0x5279, 0x5e52, 0x6b3e,
  0x6640, 0x6b70, 0x7665, 0x6b48, 0x636a, 0x5370, 0x6343, 0x5b51,
  0x7d4a, 0x5d7b, 0x5b21, 0x5257, 0x5829, 0x7435, 0x5177, 0x607a,
  0x5249, 0x7061, 0x6b73, 0x742c, 0x5a27, 0x5e31, 0x5c71, 0x7e59,
  0x6868, 0x7825, 0x686b, 0x5c46, 0x7f34, 0x605e, 0x4974, 0x4b5e,
  0x4e67, 0x4b59, 0x7c30, 0x704a, 0x6e52, 0x7d56, 0x503a, 0x6f68,
  0x655f, 0x6e29, 0x7e4f, 0x7f6c, 0x7e60, 0x742f, 0x487c, 0x7e2e,
  0x667a, 0x6643, 0x6d78, 0x6566, 0x6365, 0x6c5a, 0x5e75, 0x5046,
  0x737b, 0x5248, 0x5064, 0x7e77, 0x487f, 0x7350, 0x5a37, 0x4a25,
  0x7434, 0x6073, 0x6044, 0x6059, 0x6e4e, 0x6b39, 0x5333, 0x7f6f,
  0x495e, 0x6b38, 0x7e64, 0x7d2b, 0x5b30, 0x734a, 0x7c70, 0x7c71,
  0x5a26, 0x5f65, 0x6750, 0x656f, 0x554b, 0x725d, 0x6f6b, 0x5e74,
  0x684a, 0x5a75, 0x7c64, 0x6753, 0x4a78, 0x7e4e, 0x615a, 0x6845,
  0x7744, 0x6036, 0x6223, 0x6b3b, 0x5832, 0x4a30, 0x5c4e, 0x5442,
  0x4b77, 0x7747, 0x645a, 0x554a, 0x6d23, 0x6c30, 0x7e49, 0x6642,
  0x7e48, 0x7d35, 0x586d, 0x7f3d, 0x5c24, 0x6152, 0x7d2a, 0x7263,
  0x7241, 0x6675, 0x687c, 0x5e6d, 0x755f, 0x5641, 0x4b46, 0x4e30,
  0x5932, 0x7262, 0x5a74, 0x7e39, 0x5120, 0x756a, 0x5a33, 0x584d,
  0x5545, 0x5544, 0x7c33, 0x4f7b, 0x5074, 0x716f, 0x655e, 0x5c64,
  0x7c73, 0x4b41, 0x7929, 0x4a7b, 0x7e5d, 0x487e, 0x6233, 0x7223,
  0x517d, 0x5547, 0x7833, 0x517c, 0x4964, 0x7e38, 0x665d, 0x707a,
  0x4959, 0x632e, 0x5f28, 0x665c, 0x532f, 0x736e, 0x6e2b, 0x542c,
  0x4a57, 0x7f66, 0x5f2b, 0x5f53, 0x5c68, 0x6e6d, 0x5c27, 0x616d,
  0x5256, 0x6b4b, 0x7c67, 0x6058, 0x4a7a, 0x6455, 0x5362, 0x7060,
  0x496b, 0x4879, 0x716e, 0x6047, 0x586c, 0x7d45, 0x7832, 0x6c2a,
  0x5c49, 0x4f33, 0x5823, 0x537a, 0x7465, 0x594d, 0x4b40, 0x587e,
  0x5d3d, 0x6264, 0x6031, 0x6e49, 0x6061, 0x6068, 0x7f75, 0x4836,
  0x6030, 0x4951, 0x5d7a, 0x5952, 0x6943, 0x5d5d, 0x612e, 0x7d40,
  0x4923, 0x4b43, 0x7222, 0x795e, 0x6f60, 0x5251, 0x6129, 0x513b,
  0x5250, 0x7d64, 0x6329, 0x526e, 0x5546, 0x5269, 0x517f, 0x5a77,
  0x5375, 0x5c67, 0x4b58, 0x5c70, 0x5c26, 0x7946, 0x7851, 0x6425,
  0x517e, 0x7954, 0x482e, 0x5d74, 0x5767, 0x7178, 0x6b4a, 0x5757,
  0x5e30, 0x6c25, 0x5822, 0x742e, 0x4958, 0x6424, 0x5a21, 0x7437,
  0x6a3c, 0x6a3f, 0x7240, 0x6a5f, 0x524b, 0x6468, 0x7736, 0x616c,
  0x6046, 0x532e, 0x5f4f, 0x4e73, 0x4b42, 0x342c, 0x342f, 0x342e,
  0x3429, 0x3428, 0x342b, 0x342a, 0x3425, 0x3424, 0x3427, 0x3426,
  0x3421, 0x3420, 0x3423, 0x3422, 0x343d, 0x343c, 0x343f, 0x343e,
  0x3439, 0x3438, 0x343b, 0x343a, 0x3435, 0x3434, 0x3437, 0x3436,
  0x3431, 0x3430, 0x3433, 0x3432, 0x344d, 0x344c, 0x344f, 0x344e,
  0x3449, 0x3448, 0x344b, 0x344a, 0x3445, 0x3444, 0x3447, 0x3446,
  0x3441, 0x3440, 0x3443, 0x3442, 0x345d, 0x345c, 0x345f, 0x345e,
  0x3459, 0x3458, 0x345b, 0x345a, 0x3455, 0x3454, 0x3457, 0x3456,
  0x3451, 0x3450, 0x3453, 0x3452, 0x346d, 0x346c, 0x346f, 0x346e,
  0x3469, 0x3468, 0x346b, 0x346a, 0x3465, 0x3464, 0x3467, 0x3466,
  0x3461, 0x3460, 0x3463, 0x3462, 0x347d, 0x347c, 0x347f, 0x347e,
  0x3479, 0x3478, 0x347b, 0x347a, 0x3475, 0x3474, 0x3477, 0x3476,
  0x3471, 0x3470, 0x3473, 0x352c, 0x352f, 0x352e, 0x3529, 0x3528,
  0x352b, 0x352a, 0x3525, 0x3524, 0x3527, 0x3526, 0x3521, 0x3520,
  0x3523, 0x3522, 0x353d, 0x353c, 0x353f, 0x353e, 0x3539, 0x3538,
  0x353b, 0x353a, 0x3535, 0x3534, 0x3537, 0x3536, 0x3531, 0x3530,
  0x3533, 0x3532, 0x354d, 0x354c, 0x354f, 0x354e, 0x3549, 0x3548,
  0x354b, 0x354a, 0x3545, 0x3544, 0x3547, 0x3546, 0x3541, 0x3540,
  0x3543, 0x3542, 0x355d, 0x355c, 0x355f, 0x355e, 0x3559, 0x3558,
  0x355b, 0x355a, 0x3555, 0x3554, 0x3557, 0x3556, 0x3551, 0x3550,
  0x3553, 0x3552, 0x356d, 0x356c, 0x356f, 0x356e, 0x3569, 0x3568,
  0x356b, 0x356a, 0x3565, 0x3564, 0x3567, 0x3566, 0x3561, 0x3560,
  0x3563, 0x3562, 0x357d, 0x357c, 0x357f, 0x357e, 0x3579, 0x3578,
  0x357b, 0x357a, 0x3575, 0x3574, 0x3577, 0x3576, 0x3571, 0x3570,
  0x3573, 0x362c, 0x362f, 0x362e, 0x3629, 0x3628, 0x362b, 0x362a,
  0x3625, 0x3624, 0x3627, 0x3626, 0x3621, 0x3620, 0x3623, 0x3622,
  0x363d, 0x363c, 0x363f, 0x363e, 0x3639, 0x3638, 0x363b, 0x363a,
  0x3635, 0x3634, 0x3637, 0x3636, 0x3631, 0x3630, 0x3633, 0x3632,
  0x364d, 0x364c, 0x364f, 0x364e, 0x3649, 0x3648, 0x364b, 0x364a,
  0x3645, 0x3644, 0x3647, 0x3646, 0x3641, 0x3640, 0x3643, 0x3642,
  0x365d, 0x365c, 0x365f, 0x365e, 0x3659, 0x3658, 0x365b, 0x365a,
  0x3655, 0x3654, 0x3657, 0x3656, 0x3651, 0x3650, 0x3653, 0x3652,
  0x366d, 0x366c, 0x366f, 0x366e, 0x3669, 0x3668, 0x366b, 0x366a,
  0x3665, 0x3664, 0x3667, 0x3666, 0x3661, 0x3660, 0x3663, 0x3662,
  0x367d, 0x367c, 0x367f, 0x367e, 0x3679, 0x3678, 0x367b, 0x367a,
  0x3675, 0x3674, 0x3677, 0x3676, 0x3671, 0x3670, 0x3673, 0x372c,
  0x372f, 0x372e, 0x3729, 0x3728, 0x372b, 0x372a, 0x3725, 0x3724,
  0x3727, 0x3726, 0x3721, 0x3720, 0x3723, 0x3722, 0x373d, 0x373c,
  0x373f, 0x373e, 0x3739, 0x3738, 0x373b, 0x373a, 0x3735, 0x3734,
  0x3737, 0x3736, 0x3731, 0x3730, 0x3733, 0x3732, 0x374d, 0x374c,
  0x374f, 0x374e, 0x3749, 0x3748, 0x374b, 0x374a, 0x3745, 0x3744,
  0x3747, 0x3746, 0x3741, 0x3740, 0x3743, 0x3742, 0x375d, 0x375c,
  0x375f, 0x375e, 0x3759, 0x3758, 0x375b, 0x375a, 0x3755, 0x3754,
  0x3757, 0x3756, 0x3751, 0x3750, 0x3753, 0x3752, 0x376d, 0x376c,
  0x376f, 0x376e, 0x3769, 0x3768, 0x376b, 0x376a, 0x3765, 0x3764,
  0x3767, 0x3766, 0x3761, 0x3760, 0x3763, 0x3762, 0x377d, 0x377c,
  0x377f, 0x377e, 0x3779, 0x3778, 0x377b, 0x377a, 0x3775, 0x3774,
  0x3777, 0x3776, 0x3771, 0x3770, 0x3773, 0x302c, 0x302f, 0x302e,
  0x3029, 0x3028, 0x302b, 0x302a, 0x3025, 0x3024, 0x3027, 0x3026,
  0x3021, 0x3020, 0x3023, 0x3022, 0x303d, 0x303c, 0x303f, 0x303e,
  0x3039, 0x3038, 0x303b, 0x303a, 0x3035, 0x3034, 0x3037, 0x3036,
  0x3031, 0x3030, 0x3033, 0x3032, 0x304d, 0x304c, 0x304f, 0x304e,
  0x3049, 0x3048, 0x304b, 0x304a, 0x3045, 0x3044, 0x3047, 0x3046,
  0x3041, 0x3040, 0x3043, 0x3042, 0x305d, 0x305c, 0x305f, 0x305e,
  0x3059, 0x3058, 0x305b, 0x305a, 0x3055, 0x3054, 0x3057, 0x3056,
  0x3051, 0x3050, 0x3053, 0x3052, 0x306d, 0x306c, 0x306f, 0x306e,
  0x3069, 0x3068, 0x306b, 0x306a, 0x3065, 0x3064, 0x3067, 0x3066,
  0x3061, 0x3060, 0x3063, 0x3062, 0x307d, 0x307c, 0x307f, 0x307e,
  0x3079, 0x3078, 0x307b, 0x307a, 0x3075, 0x3074, 0x3077, 0x3076,
  0x3071, 0x3070, 0x3073, 0x312c, 0x312f, 0x312e, 0x3129, 0x3128,
  0x312b, 0x312a, 0x3125, 0x3124, 0x3127, 0x3126, 0x3121, 0x3120,
  0x3123, 0x3122, 0x313d, 0x313c, 0x313f, 0x313e, 0x3139, 0x3138,
  0x313b, 0x313a, 0x3135, 0x3134, 0x3137, 0x3136, 0x3131, 0x3130,
  0x3133, 0x3132, 0x314d, 0x314c, 0x314f, 0x314e, 0x3149, 0x3148,
  0x314b, 0x314a, 0x3145, 0x3144, 0x3147, 0x3146, 0x3141, 0x3140,
  0x3143, 0x3142, 0x315d, 0x315c, 0x315f, 0x315e, 0x3159, 0x3158,
  0x315b, 0x315a, 0x3155, 0x3154, 0x3157, 0x3156, 0x3151, 0x3150,
  0x3153, 0x3152, 0x316d, 0x316c, 0x316f, 0x316e, 0x3169, 0x3168,
  0x316b, 0x316a, 0x3165, 0x3164, 0x3167, 0x3166, 0x3161, 0x3160,
  0x3163, 0x3162, 0x317d, 0x317c, 0x317f, 0x317e, 0x3179, 0x3178,
  0x317b, 0x317a, 0x3175, 0x3174, 0x3177, 0x3176, 0x3171, 0x3170,
  0x3173, 0x322c, 0x322f, 0x322e, 0x3229, 0x3228, 0x322b, 0x322a,
  0x3225, 0x3224, 0x3227, 0x3226, 0x3221, 0x3220, 0x3223, 0x3222,
  0x323d, 0x323c, 0x323f, 0x323e, 0x3239, 0x3238, 0x323b, 0x323a,
  0x3235, 0x3234, 0x3237, 0x3236, 0x3231, 0x3230, 0x3233, 0x3232,
  0x324d, 0x324c, 0x324f, 0x324e, 0x3249, 0x3248, 0x324b, 0x324a,
  0x3245, 0x3244, 0x3247, 0x3246, 0x3241, 0x3240, 0x3243, 0x3242,
  0x325d, 0x325c, 0x325f, 0x325e, 0x3259, 0x3258, 0x325b, 0x325a,
  0x3255, 0x3254, 0x3257, 0x3256, 0x3251, 0x3250, 0x3253, 0x3252,
  0x326d, 0x326c, 0x326f, 0x326e, 0x3269, 0x3268, 0x326b, 0x326a,
  0x3265, 0x3264, 0x3267, 0x3266, 0x3261, 0x3260, 0x3263, 0x3262,
  0x327d, 0x327c, 0x327f, 0x327e, 0x3279, 0x3278, 0x327b, 0x327a,
  0x3275, 0x3274, 0x3277, 0x3276, 0x3271, 0x3270, 0x3273, 0x332c,
  0x332f, 0x332e, 0x3329, 0x3328, 0x332b, 0x332a, 0x3325, 0x3324,
  0x3327, 0x3326, 0x3321, 0x3320, 0x3323, 0x3322, 0x333d, 0x333c,
  0x333f, 0x333e, 0x3339, 0x3338, 0x333b, 0x333a, 0x3335, 0x3334,
  0x3337, 0x3336, 0x3331, 0x3330, 0x3333, 0x3332, 0x334d, 0x334c,
  0x334f, 0x334e, 0x3349, 0x3348, 0x334b, 0x334a, 0x3345, 0x3344,
  0x3347, 0x3346, 0x3341, 0x3340, 0x3343, 0x3342, 0x335d, 0x335c,
  0x335f, 0x335e, 0x3359, 0x3358, 0x335b, 0x335a, 0x3355, 0x3354,
  0x3357, 0x3356, 0x3351, 0x3350, 0x3353, 0x3352, 0x336d, 0x336c,
  0x336f, 0x336e, 0x3369, 0x3368, 0x336b, 0x336a, 0x3365, 0x3364,
  0x3367, 0x3366, 0x3361, 0x3360, 0x3363, 0x3362, 0x337d, 0x337c,
  0x337f, 0x337e, 0x3379, 0x3378, 0x337b, 0x337a, 0x3375, 0x3374,
  0x3377, 0x3376, 0x3371, 0x3370, 0x3373, 0x3c2c, 0x3c2f, 0x3c2e,
  0x3c29, 0x3c28, 0x3c2b, 0x3c2a, 0x3c25, 0x3c24, 0x3c27, 0x3c26,
  0x3c21, 0x3c20, 0x3c23, 0x3c22, 0x3c3d, 0x3c3c, 0x3c3f, 0x3c3e,
  0x3c39, 0x3c38, 0x3c3b, 0x3c3a, 0x3c35, 0x3c34, 0x3c37, 0x3c36,
  0x3c31, 0x3c30, 0x3c33, 0x3c32, 0x3c4d, 0x3c4c, 0x3c4f, 0x3c4e,
  0x3c49, 0x3c48, 0x3c4b, 0x3c4a, 0x3c45, 0x3c44, 0x3c47, 0x3c46,
  0x3c41, 0x3c40, 0x3c43, 0x3c42, 0x3c5d, 0x3c5c, 0x3c5f, 0x3c5e,
  0x3c59, 0x3c58, 0x3c5b, 0x3c5a, 0x3c55, 0x3c54, 0x3c57, 0x3c56,
  0x3c51, 0x3c50, 0x3c53, 0x3c52, 0x3c6d, 0x3c6c, 0x3c6f, 0x3c6e,
  0x3c69, 0x3c68, 0x3c6b, 0x3c6a, 0x3c65, 0x3c64, 0x3c67, 0x3c66,
  0x3c61, 0x3c60, 0x3c63, 0x3c62, 0x3c7d, 0x3c7c, 0x3c7f, 0x3c7e,
  0x3c79, 0x3c78, 0x3c7b, 0x3c7a, 0x3c75, 0x3c74, 0x3c77, 0x3c76,
  0x3c71, 0x3c70, 0x3c73, 0x3d2c, 0x3d2f, 0x3d2e, 0x3d29, 0x3d28,
  0x3d2b, 0x3d2a, 0x3d25, 0x3d24, 0x3d27, 0x3d26, 0x3d21, 0x3d20,
  0x3d23, 0x3d22, 0x3d3d, 0x3d3c, 0x3d3f, 0x3d3e, 0x3d39, 0x3d38,
  0x3d3b, 0x3d3a, 0x3d35, 0x3d34, 0x3d37, 0x3d36, 0x3d31, 0x3d30,
  0x3d33, 0x3d32, 0x3d4d, 0x3d4c, 0x3d4f, 0x3d4e, 0x3d49, 0x3d48,
  0x3d4b, 0x3d4a, 0x3d45, 0x3d44, 0x3d47, 0x3d46, 0x3d41, 0x3d40,
  0x3d43, 0x3d42, 0x3d5d, 0x3d5c, 0x3d5f, 0x3d5e, 0x3d59, 0x3d58,
  0x3d5b, 0x3d5a, 0x3d55, 0x3d54, 0x3d57, 0x3d56, 0x3d51, 0x3d50,
  0x3d53, 0x3d52, 0x3d6d, 0x3d6c, 0x3d6f, 0x3d6e, 0x3d69, 0x3d68,
  0x3d6b, 0x3d6a, 0x3d65, 0x3d64, 0x3d67, 0x3d66, 0x3d61, 0x3d60,
  0x3d63, 0x3d62, 0x3d7d, 0x3d7c, 0x3d7f, 0x3d7e, 0x3d79, 0x3d78,
  0x3d7b, 0x3d7a, 0x3d75, 0x3d74, 0x3d77, 0x3d76, 0x3d71, 0x3d70,
  0x3d73, 0x3e2c, 0x3e2f, 0x3e2e, 0x3e29, 0x3e28, 0x3e2b, 0x3e2a,
  0x3e25, 0x3e24, 0x3e27, 0x3e26, 0x3e21, 0x3e20, 0x3e23, 0x3e22,
  0x3e3d, 0x3e3c, 0x3e3f, 0x3e3e, 0x3e39, 0x3e38, 0x3e3b, 0x3e3a,
  0x3e35, 0x3e34, 0x3e37, 0x3e36, 0x3e31, 0x3e30, 0x3e33, 0x3e32,
  0x3e4d, 0x3e4c, 0x3e4f, 0x3e4e, 0x3e49, 0x3e48, 0x3e4b, 0x3e4a,
  0x3e45, 0x3e44, 0x3e47, 0x3e46, 0x3e41, 0x3e40, 0x3e43, 0x3e42,
  0x3e5d, 0x3e5c, 0x3e5f, 0x3e5e, 0x3e59, 0x3e58, 0x3e5b, 0x3e5a,
  0x3e55, 0x3e54, 0x3e57, 0x3e56, 0x3e51, 0x3e50, 0x3e53, 0x3e52,
  0x3e6d, 0x3e6c, 0x3e6f, 0x3e6e, 0x3e69, 0x3e68, 0x3e6b, 0x3e6a,
  0x3e65, 0x3e64, 0x3e67, 0x3e66, 0x3e61, 0x3e60, 0x3e63, 0x3e62,
  0x3e7d, 0x3e7c, 0x3e7f, 0x3e7e, 0x3e79, 0x3e78, 0x3e7b, 0x3e7a,
  0x3e75, 0x3e74, 0x3e77, 0x3e76, 0x3e71, 0x3e70, 0x3e73, 0x3f2c,
  0x3f2f, 0x3f2e, 0x3f29, 0x3f28, 0x3f2b, 0x3f2a, 0x3f25, 0x3f24,
  0x3f27, 0x3f26, 0x3f21, 0x3f20, 0x3f23, 0x3f22, 0x3f3d, 0x3f3c,
  0x3f3f, 0x3f3e, 0x3f39, 0x3f38, 0x3f3b, 0x3f3a, 0x3f35, 0x3f34,
  0x3f37, 0x3f36, 0x3f31, 0x3f30, 0x3f33, 0x3f32, 0x3f4d, 0x3f4c,
  0x3f4f, 0x3f4e, 0x3f49, 0x3f48, 0x3f4b, 0x3f4a, 0x3f45, 0x3f44,
  0x3f47, 0x3f46, 0x3f41, 0x3f40, 0x3f43, 0x3f42, 0x3f5d, 0x3f5c,
  0x3f5f, 0x3f5e, 0x3f59, 0x3f58, 0x3f5b, 0x3f5a, 0x3f55, 0x3f54,
  0x3f57, 0x3f56, 0x3f51, 0x3f50, 0x3f53, 0x3f52, 0x3f6d, 0x3f6c,
  0x3f6f, 0x3f6e, 0x3f69, 0x3f68, 0x3f6b, 0x3f6a, 0x3f65, 0x3f64,
  0x3f67, 0x3f66, 0x3f61, 0x3f60, 0x3f63, 0x3f62, 0x3f7d, 0x3f7c,
  0x3f7f, 0x3f7e, 0x3f79, 0x3f78, 0x3f7b, 0x3f7a, 0x3f75, 0x3f74,
  0x3f77, 0x3f76, 0x3f71, 0x3f70, 0x3f73, 0x382c, 0x382f, 0x382e,
  0x3829, 0x3828, 0x382b, 0x382a, 0x3825, 0x3824, 0x3827, 0x3826,
  0x3821, 0x3820, 0x3823, 0x3822, 0x383d, 0x383c, 0x383f, 0x383e,
  0x3839, 0x3838, 0x383b, 0x383a, 0x3835, 0x3834, 0x3837, 0x3836,
  0x3831, 0x3830, 0x3833, 0x3832, 0x384d, 0x384c, 0x384f, 0x384e,
  0x3849, 0x3848, 0x384b, 0x384a, 0x3845, 0x3844, 0x3847, 0x3846,
  0x3841, 0x3840, 0x3843, 0x3842, 0x385d, 0x385c, 0x385f, 0x385e,
  0x3859, 0x3858, 0x385b, 0x385a, 0x3855, 0x3854, 0x3857, 0x3856,
  0x3851, 0x3850, 0x3853, 0x3852, 0x386d, 0x386c, 0x386f, 0x386e,
  0x3869, 0x3868, 0x386b, 0x386a, 0x3865, 0x3864, 0x3867, 0x3866,
  0x3861, 0x3860, 0x3863, 0x3862, 0x387d, 0x387c, 0x387f, 0x387e,
  0x3879, 0x3878, 0x387b, 0x387a, 0x3875, 0x3874, 0x3877, 0x3876,
  0x3871, 0x3870, 0x3873, 0x392c, 0x392f, 0x392e, 0x3929, 0x3928,
  0x392b, 0x392a, 0x3925, 0x3924, 0x3927, 0x3926, 0x3921, 0x3920,
  0x3923, 0x3922, 0x393d, 0x393c, 0x393f, 0x393e, 0x3939, 0x3938,
  0x393b, 0x393a, 0x3935, 0x3934, 0x3937, 0x3936, 0x3931, 0x3930,
  0x3933, 0x3932, 0x394d, 0x394c, 0x394f, 0x394e, 0x3949, 0x3948,
  0x394b, 0x394a, 0x3945, 0x3944, 0x3947, 0x3946, 0x3941, 0x3940,
  0x3943, 0x3942, 0x395d, 0x395c, 0x395f, 0x395e, 0x3959, 0x3958,
  0x395b, 0x395a, 0x3955, 0x3954, 0x3957, 0x3956, 0x3951, 0x3950,
  0x3953, 0x3952, 0x396d, 0x396c, 0x396f, 0x396e, 0x3969, 0x3968,
  0x396b, 0x396a, 0x3965, 0x3964, 0x3967, 0x3966, 0x3961, 0x3960,
  0x3963, 0x3962, 0x397d, 0x397c, 0x397f, 0x397e, 0x3979, 0x3978,
  0x397b, 0x397a, 0x3975, 0x3974, 0x3977, 0x3976, 0x3971, 0x3970,
  0x3973, 0x3a2c, 0x3a2f, 0x3a2e, 0x3a29, 0x3a28, 0x3a2b, 0x3a2a,
  0x3a25, 0x3a24, 0x3a27, 0x3a26, 0x3a21, 0x3a20, 0x3a23, 0x3a22,
  0x3a3d, 0x3a3c, 0x3a3f, 0x3a3e, 0x3a39, 0x3a38, 0x3a3b, 0x3a3a,
  0x3a35, 0x3a34, 0x3a37, 0x3a36, 0x3a31, 0x3a30, 0x3a33, 0x3a32,
  0x3a4d, 0x3a4c, 0x3a4f, 0x3a4e, 0x3a49, 0x3a48, 0x3a4b, 0x3a4a,
  0x3a45, 0x3a44, 0x3a47, 0x3a46, 0x3a41, 0x3a40, 0x3a43, 0x3a42,
  0x3a5d, 0x3a5c, 0x3a5f, 0x3a5e, 0x3a59, 0x3a58, 0x3a5b, 0x3a5a,
  0x3a55, 0x3a54, 0x3a57, 0x3a56, 0x3a51, 0x3a50, 0x3a53, 0x3a52,
  0x3a6d, 0x3a6c, 0x3a6f, 0x3a6e, 0x3a69, 0x3a68, 0x3a6b, 0x3a6a,
  0x3a65, 0x3a64, 0x3a67, 0x3a66, 0x3a61, 0x3a60, 0x3a63, 0x3a62,
  0x3a7d, 0x3a7c, 0x3a7f, 0x3a7e, 0x3a79, 0x3a78, 0x3a7b, 0x3a7a,
  0x3a75, 0x3a74, 0x3a77, 0x3a76, 0x3a71, 0x3a70, 0x3a73, 0x3b2c,
  0x3b2f, 0x3b2e, 0x3b29, 0x3b28, 0x3b2b, 0x3b2a, 0x3b25, 0x3b24,
  0x3b27, 0x3b26, 0x3b21, 0x3b20, 0x3b23, 0x3b22, 0x3b3d, 0x3b3c,
  0x3b3f, 0x3b3e, 0x3b39, 0x3b38, 0x3b3b, 0x3b3a, 0x3b35, 0x3b34,
  0x3b37, 0x3b36, 0x3b31, 0x3b30, 0x3b33, 0x3b32, 0x3b4d, 0x3b4c,
  0x3b4f, 0x3b4e, 0x3b49, 0x3b48, 0x3b4b, 0x3b4a, 0x3b45, 0x3b44,
  0x3b47, 0x3b46, 0x3b41, 0x3b40, 0x3b43, 0x3b42, 0x3b5d, 0x3b5c,
  0x3b5f, 0x3b5e, 0x3b59, 0x3b58, 0x3b5b, 0x3b5a, 0x3b55, 0x3b54,
  0x3b57, 0x3b56, 0x3b51, 0x3b50, 0x3b53, 0x3b52, 0x3b6d, 0x3b6c,
  0x3b6f, 0x3b6e, 0x3b69, 0x3b68, 0x3b6b, 0x3b6a, 0x3b65, 0x3b64,
  0x3b67, 0x3b66, 0x3b61, 0x3b60, 0x3b63, 0x3b62, 0x3b7d, 0x3b7c,
  0x3b7f, 0x3b7e, 0x3b79, 0x3b78, 0x3b7b, 0x3b7a, 0x3b75, 0x3b74,
  0x3b77, 0x3b76, 0x3b71, 0x3b70, 0x3b73, 0x442c, 0x442f, 0x442e,
  0x4429, 0x4428, 0x442b, 0x442a, 0x4425, 0x4424, 0x4427, 0x4426,
  0x4421, 0x4420, 0x4423, 0x4422, 0x443d, 0x443c, 0x443f, 0x443e,
  0x4439, 0x4438, 0x443b, 0x443a, 0x4435, 0x4434, 0x4437, 0x4436,
  0x4431, 0x4430, 0x4433, 0x4432, 0x444d, 0x444c, 0x444f, 0x444e,
  0x4449, 0x4448, 0x444b, 0x444a, 0x4445, 0x4444, 0x4447, 0x4446,
  0x4441, 0x4440, 0x4443, 0x4442, 0x445d, 0x445c, 0x445f, 0x445e,
  0x4459, 0x4458, 0x445b, 0x445a, 0x4455, 0x4454, 0x4457, 0x4456,
  0x4451, 0x4450, 0x4453, 0x4452, 0x446d, 0x446c, 0x446f, 0x446e,
  0x4469, 0x4468, 0x446b, 0x446a, 0x4465, 0x4464, 0x4467, 0x4466,
  0x4461, 0x4460, 0x4463, 0x4462, 0x447d, 0x447c, 0x447f, 0x447e,
  0x4479, 0x4478, 0x447b, 0x447a, 0x4475, 0x4474, 0x4477, 0x4476,
  0x4471, 0x4470, 0x4473, 0x452c, 0x452f, 0x452e, 0x4529, 0x4528,
  0x452b, 0x452a, 0x4525, 0x4524, 0x4527, 0x4526, 0x4521, 0x4520,
  0x4523, 0x4522, 0x453d, 0x453c, 0x453f, 0x453e, 0x4539, 0x4538,
  0x453b, 0x453a, 0x4535, 0x4534, 0x4537, 0x4536, 0x4531, 0x4530,
  0x4533, 0x4532, 0x454d, 0x454c, 0x454f, 0x454e, 0x4549, 0x4548,
  0x454b, 0x454a, 0x4545, 0x4544, 0x4547, 0x4546, 0x4541, 0x4540,
  0x4543, 0x4542, 0x455d, 0x455c, 0x455f, 0x455e, 0x4559, 0x4558,
  0x455b, 0x455a, 0x4555, 0x4554, 0x4557, 0x4556, 0x4551, 0x4550,
  0x4553, 0x4552, 0x456d, 0x456c, 0x456f, 0x456e, 0x4569, 0x4568,
  0x456b, 0x456a, 0x4565, 0x4564, 0x4567, 0x4566, 0x4561, 0x4560,
  0x4563, 0x4562, 0x457d, 0x457c, 0x457f, 0x457e, 0x4579, 0x4578,
  0x457b, 0x457a, 0x4575, 0x4574, 0x4577, 0x4576, 0x4571, 0x4570,
  0x4573, 0x462c, 0x462f, 0x462e, 0x4629, 0x4628, 0x462b, 0x462a,
  0x4625, 0x4624, 0x4627, 0x4626, 0x4621, 0x4620, 0x4623, 0x4622,
  0x463d, 0x463c, 0x463f, 0x463e, 0x4639, 0x4638, 0x463b, 0x463a,
  0x4635, 0x4634, 0x4637, 0x4636, 0x4631, 0x4630, 0x4633, 0x4632,
  0x464d, 0x464c, 0x464f, 0x464e, 0x4649, 0x4648, 0x464b, 0x464a,
  0x4645, 0x4644, 0x4647, 0x4646, 0x4641, 0x4640, 0x4643, 0x4642,
  0x465d, 0x465c, 0x465f, 0x465e, 0x4659, 0x4658, 0x465b, 0x465a,
  0x4655, 0x4654, 0x4657, 0x4656, 0x4651, 0x4650, 0x4653, 0x4652,
  0x466d, 0x466c, 0x466f, 0x466e, 0x4669, 0x4668, 0x466b, 0x466a,
  0x4665, 0x4664, 0x4667, 0x4666, 0x4661, 0x4660, 0x4663, 0x4662,
  0x467d, 0x467c, 0x467f, 0x467e, 0x4679, 0x4678, 0x467b, 0x467a,
  0x4675, 0x4674, 0x4677, 0x4676, 0x4671, 0x4670, 0x4673, 0x472c,
  0x472f, 0x472e, 0x4729, 0x4728, 0x472b, 0x472a, 0x4725, 0x4724,
  0x4727, 0x4726, 0x4721, 0x4720, 0x4723, 0x4722, 0x473d, 0x473c,
  0x473f, 0x473e, 0x4739, 0x4738, 0x473b, 0x473a, 0x4735, 0x4734,
  0x4737, 0x4736, 0x4731, 0x4730, 0x4733, 0x4732, 0x474d, 0x474c,
  0x474f, 0x474e, 0x4749, 0x4748, 0x474b, 0x474a, 0x4745, 0x4744,
  0x4747, 0x4746, 0x4741, 0x4740, 0x4743, 0x4742, 0x475d, 0x475c,
  0x475f, 0x475e, 0x4759, 0x4758, 0x475b, 0x475a, 0x4755, 0x4754,
  0x4757, 0x4756, 0x4751, 0x4750, 0x4753, 0x4752, 0x476d, 0x476c,
  0x476f, 0x476e, 0x4769, 0x4768, 0x476b, 0x476a, 0x4765, 0x4764,
  0x4767, 0x4766, 0x4761, 0x4760, 0x4763, 0x4762, 0x477d, 0x477c,
  0x477f, 0x477e, 0x4779, 0x4778, 0x477b, 0x477a, 0x4775, 0x4774,
  0x4777, 0x4776, 0x4771, 0x4770, 0x4773, 0x402c, 0x402f, 0x402e,
  0x4029, 0x4028, 0x402b, 0x402a, 0x4025, 0x4024, 0x4027, 0x4026,
  0x4021, 0x4020, 0x4023, 0x4022, 0x403d, 0x403c, 0x403f, 0x403e,
  0x4039, 0x4038, 0x403b, 0x403a, 0x4035, 0x4034, 0x4037, 0x4036,
  0x4031, 0x4030, 0x4033, 0x4032, 0x404d, 0x404c, 0x404f, 0x404e,
  0x4049, 0x4048, 0x404b, 0x404a, 0x4045, 0x4044, 0x4047, 0x4046,
  0x4041, 0x4040, 0x4043, 0x4042, 0x405d, 0x405c, 0x405f, 0x405e,
  0x4059, 0x4058, 0x405b, 0x405a, 0x4055, 0x4054, 0x4057, 0x4056,
  0x4051, 0x4050, 0x4053, 0x4052, 0x406d, 0x406c, 0x406f, 0x406e,
  0x4069, 0x4068, 0x406b, 0x406a, 0x4065, 0x4064, 0x4067, 0x4066,
  0x4061, 0x4060, 0x4063, 0x4062, 0x407d, 0x407c, 0x407f, 0x407e,
  0x4079, 0x4078, 0x407b, 0x407a, 0x4075, 0x4074, 0x4077, 0x4076,
  0x4071, 0x4070, 0x4073, 0x412c, 0x412f, 0x412e, 0x4129, 0x4128,
  0x412b, 0x412a, 0x4125, 0x4124, 0x4127, 0x4126, 0x4121, 0x4120,
  0x4123, 0x4122, 0x413d, 0x413c, 0x413f, 0x413e, 0x4139, 0x4138,
  0x413b, 0x413a, 0x4135, 0x4134, 0x4137, 0x4136, 0x4131, 0x4130,
  0x4133, 0x4132, 0x414d, 0x414c, 0x414f, 0x414e, 0x4149, 0x4148,
  0x414b, 0x414a, 0x4145, 0x4144, 0x4147, 0x4146, 0x4141, 0x4140,
  0x4143, 0x4142, 0x415d, 0x415c, 0x415f, 0x415e, 0x4159, 0x4158,
  0x415b, 0x415a, 0x4155, 0x4154, 0x4157, 0x4156, 0x4151, 0x4150,
  0x4153, 0x4152, 0x416d, 0x416c, 0x416f, 0x416e, 0x4169, 0x4168,
  0x416b, 0x416a, 0x4165, 0x4164, 0x4167, 0x4166, 0x4161, 0x4160,
  0x4163, 0x4162, 0x417d, 0x417c, 0x417f, 0x417e, 0x4179, 0x4178,
  0x417b, 0x417a, 0x4175, 0x4174, 0x4177, 0x4176, 0x4171, 0x4170,
  0x4173, 0x422c, 0x422f, 0x422e, 0x4229, 0x4228, 0x422b, 0x422a,
  0x4225, 0x4224, 0x4227, 0x4226, 0x4221, 0x4220, 0x4223, 0x4222,
  0x423d, 0x423c, 0x423f, 0x423e, 0x4239, 0x4238, 0x423b, 0x423a,
  0x4235, 0x4234, 0x4237, 0x4236, 0x4231, 0x4230, 0x4233, 0x4232,
  0x424d, 0x424c, 0x424f, 0x424e, 0x4249, 0x4248, 0x424b, 0x424a,
  0x4245, 0x4244, 0x4247, 0x4246, 0x4241, 0x4240, 0x4243, 0x4242,
  0x425d, 0x425c, 0x425f, 0x425e, 0x4259, 0x4258, 0x425b, 0x425a,
  0x4255, 0x4254, 0x4257, 0x4256, 0x4251, 0x4250, 0x4253, 0x4252,
  0x426d, 0x426c, 0x426f, 0x426e, 0x4269, 0x4268, 0x426b, 0x426a,
  0x4265, 0x4264, 0x4267, 0x4266, 0x4261, 0x4260, 0x4263, 0x4262,
  0x427d, 0x427c, 0x427f, 0x427e, 0x4279, 0x4278, 0x427b, 0x427a,
  0x4275, 0x4274, 0x4277, 0x4276, 0x4271, 0x4270, 0x4273, 0x432c,
  0x432f, 0x432e, 0x4329, 0x4328, 0x432b, 0x432a, 0x4325, 0x4324,
  0x4327, 0x4326, 0x4321, 0x4320, 0x4323, 0x4322, 0x433d, 0x433c,
  0x433f, 0x433e, 0x4339, 0x4338, 0x433b, 0x433a, 0x4335, 0x4334,
  0x4337, 0x4336, 0x4331, 0x4330, 0x4333, 0x4332, 0x434d, 0x434c,
  0x434f, 0x434e, 0x4349, 0x4348, 0x434b, 0x434a, 0x4345, 0x4344,
  0x4347, 0x4346, 0x4341, 0x4340, 0x4343, 0x4342, 0x435d, 0x435c,
  0x435f, 0x435e, 0x4359, 0x4358, 0x435b, 0x435a, 0x4355, 0x4354,
  0x4357, 0x4356, 0x4351, 0x4350, 0x4353, 0x4352, 0x436d, 0x436c,
  0x436f, 0x436e, 0x4369, 0x4368, 0x436b, 0x436a, 0x4365, 0x4364,
  0x4367, 0x4366, 0x4361, 0x4360, 0x4363, 0x4362, 0x437d, 0x437c,
  0x437f, 0x437e, 0x4379, 0x4378, 0x437b, 0x437a, 0x4375, 0x4374,
  0x4377, 0x4376, 0x4371, 0x4370, 0x4373, 0x4c2c, 0x4c2f, 0x4c2e,
  0x4c29, 0x4c28, 0x4c2b, 0x4c2a, 0x4c25, 0x4c24, 0x4c27, 0x4c26,
  0x4c21, 0x4c20, 0x4c23, 0x4c22, 0x4c3d, 0x4c3c, 0x4c3f, 0x4c3e,
  0x4c39, 0x4c38, 0x4c3b, 0x4c3a, 0x4c35, 0x4c34, 0x4c37, 0x4c36,
  0x4c31, 0x4c30, 0x4c33, 0x4c32, 0x4c4d, 0x4c4c, 0x4c4f, 0x4c4e,
  0x4c49, 0x4c48, 0x4c4b, 0x4c4a, 0x4c45, 0x4c44, 0x4c47, 0x4c46,
  0x4c41, 0x4c40, 0x4c43, 0x4c42, 0x4c5d, 0x4c5c, 0x4c5f, 0x4c5e,
  0x4c59, 0x4c58, 0x4c5b, 0x4c5a, 0x4c55, 0x4c54, 0x4c57, 0x4c56,
  0x4c51, 0x4c50, 0x4c53, 0x4c52, 0x4c6d, 0x4c6c, 0x4c6f, 0x4c6e,
  0x4c69, 0x4c68, 0x4c6b, 0x4c6a, 0x4c65, 0x4c64, 0x4c67, 0x4c66,
  0x4c61, 0x4c60, 0x4c63, 0x4c62, 0x4c7d, 0x4c7c, 0x4c7f, 0x4c7e,
  0x4c79, 0x4c78, 0x4c7b, 0x4c7a, 0x4c75, 0x4c74, 0x4c77, 0x4c76,
  0x4c71, 0x4c70, 0x4c73, 0x4f5d, 0x4f5b, 0x4f6a, 0x4942, 0x4965,
  0x4a20, 0x4b76, 0x542f, 0x5435, 0x545d, 0x5450, 0x5559, 0x5558,
  0x5555, 0x5556, 0x5551, 0x5550, 0x5553, 0x5552, 0x556d, 0x556f,
  0x556e, 0x5569, 0x5568, 0x556b, 0x5565, 0x5564, 0x5567, 0x5566,
  0x5560, 0x5562, 0x557d, 0x557f, 0x557b, 0x5577, 0x5571, 0x5570,
  0x5573, 0x562f, 0x562e, 0x562a, 0x5625, 0x5624, 0x5627, 0x5626,
  0x5620, 0x563f, 0x5633, 0x564f, 0x564e, 0x5649, 0x564b, 0x564a,
  0x5645, 0x5644, 0x5647, 0x5646, 0x5640, 0x5643, 0x5642, 0x565d,
  0x565c, 0x565f, 0x565e, 0x5659, 0x5658, 0x565b, 0x565a, 0x5654,
  0x5657, 0x5653, 0x5652, 0x566c, 0x566f, 0x5669, 0x5668, 0x566b,
  0x566a, 0x5665, 0x5664, 0x5667, 0x5666, 0x567d, 0x567c, 0x567f,
  0x567e, 0x5679, 0x5678, 0x567a, 0x5675, 0x506b, 0x5071, 0x5128,
  0x5126, 0x5123, 0x5235, 0x5240, 0x5346, 0x5369, 0x5f48, 0x5f69,
  0x5828, 0x5928, 0x5958, 0x5979, 0x5a71, 0x5a73, 0x5b3e, 0x5b6c,
  0x5b65, 0x647c, 0x6520, 0x6560, 0x6778, 0x602c, 0x6024, 0x6123,
  0x613c, 0x613f, 0x6134, 0x6136, 0x6131, 0x6149, 0x6143, 0x615d,
  0x615f, 0x615b, 0x6177, 0x6176, 0x6171, 0x6173, 0x622c, 0x6229,
  0x622a, 0x6220, 0x6222, 0x623d, 0x623c, 0x623e, 0x623a, 0x6235,
  0x6231, 0x6249, 0x624b, 0x624a, 0x6247, 0x625f, 0x625b, 0x6254,
  0x6251, 0x6252, 0x626c, 0x6269, 0x6268, 0x626b, 0x6265, 0x6267,
  0x6266, 0x6261, 0x6262, 0x627c, 0x627f, 0x6278, 0x627b, 0x627a,
  0x6274, 0x632c, 0x632b, 0x6324, 0x6327, 0x6321, 0x6320, 0x633d,
  0x6332, 0x634c, 0x634b, 0x634a, 0x6346, 0x6340, 0x6342, 0x635d,
  0x635e, 0x6352, 0x6369, 0x636b, 0x637a, 0x6c6a, 0x6c65, 0x6c7d,
  0x6c7c, 0x6c7a, 0x6c74, 0x6c76, 0x6c73, 0x6d2a, 0x6d21, 0x6d41,
  0x6d7a, 0x6e4c, 0x6e68, 0x6e79, 0x6e7a, 0x6e71, 0x6e73, 0x6f29,
  0x6f2a, 0x6f24, 0x6f27, 0x6f37, 0x6f36, 0x6f30, 0x6f4c, 0x6f4f,
  0x6f4b, 0x6f4a, 0x6f41, 0x6f42, 0x6f5d, 0x6f5c, 0x6f5f, 0x6f55,
  0x682b, 0x682a, 0x6827, 0x6822, 0x683d, 0x683c, 0x683f, 0x6838,
  0x6835, 0x6837, 0x684d, 0x684c, 0x6848, 0x684b, 0x6844, 0x6847,
  0x6858, 0x6850, 0x6853, 0x686c, 0x6869, 0x686a, 0x6865, 0x687a,
  0x6875, 0x6877, 0x692c, 0x692f, 0x692e, 0x6963, 0x6a56, 0x7630,
  0x7677, 0x773c, 0x702a, 0x7063, 0x7279, 0x727b, 0x7335, 0x7345,
  0x735e, 0x7c56, 0x7c7d, 0x7e2c, 0x7e2f, 0x7e6b, 0x7824, 0x272c,
  0x272f, 0x272e, 0x2729, 0x2728, 0x272b, 0x272a, 0x2725, 0x2724,
  0x2727, 0x2726, 0x2721, 0x2720, 0x2723, 0x2722, 0x273d, 0x273c,
  0x273f, 0x273e, 0x2739, 0x2738, 0x273b, 0x273a, 0x2735, 0x2734,
  0x2737, 0x2736, 0x2731, 0x2730, 0x2733, 0x2732, 0x274d, 0x274c,
  0x274f, 0x274e, 0x2749, 0x2748, 0x274b, 0x274a, 0x2745, 0x2744,
  0x2747, 0x2746, 0x2741, 0x2740, 0x2743, 0x2742, 0x275d, 0x275c,
  0x275f, 0x275e, 0x2759, 0x2758, 0x275b, 0x275a, 0x2755, 0x2754,
  0x2757, 0x2756, 0x2521, 0x2750, 0x2753, 0x2752, 0x276d, 0x276c,
  0x276f, 0x276e, 0x2769, 0x2768, 0x276b, 0x276a, 0x2765, 0x2764,
  0x2767, 0x2766, 0x2761, 0x2760, 0x2763, 0x2762, 0x277d, 0x277c,
  0x277f, 0x277e, 0x2779, 0x2778, 0x277b, 0x277a, 0x2775, 0x2774,
  0x2777, 0x2776, 0x2771, 0x2770, 0x262b, 0x2546, 0x2541, 0x2573,
  0x2773, 0x2540, 0x2751
};

static const aciConvSummary16 ksc5601_uni2indx_page00[ /*70*/ ] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x6592 }, {    7, 0xf7df },
  {   21, 0x0040 }, {   22, 0xc181 }, {   27, 0x0040 }, {   28, 0x4181 },
  /* 0x0100 */
  {   32, 0x0000 }, {   32, 0x0002 }, {   33, 0x00c0 }, {   35, 0x810e },
  {   40, 0x0e07 }, {   46, 0x000c }, {   48, 0x00c0 }, {   50, 0x0000 },
  {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 },
  {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 },
  /* 0x0200 */
  {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 },
  {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 },
  {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 }, {   50, 0x0000 },
  {   50, 0x0080 }, {   51, 0x2f01 }, {   57, 0x0000 }, {   57, 0x0000 },
  /* 0x0300 */
  {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0000 },
  {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0000 }, {   57, 0x0000 },
  {   57, 0x0000 }, {   57, 0xfffe }, {   72, 0x03fb }, {   81, 0xfffe },
  {   96, 0x03fb }, {  105, 0x0000 }, {  105, 0x0000 }, {  105, 0x0000 },
  /* 0x0400 */
  {  105, 0x0002 }, {  106, 0xffff }, {  122, 0xffff }, {  138, 0xffff },
  {  154, 0xffff }, {  170, 0x0002 }
};

static const aciConvSummary16 ksc5601_uni2indx_page20[ /*103*/ ] = {
  /* 0x2000 */
  {  171, 0x0000 }, {  171, 0x3320 }, {  176, 0x0063 }, {  180, 0x080d },
  {  184, 0x0000 }, {  184, 0x0000 }, {  184, 0x0000 }, {  184, 0x8010 },
  {  186, 0x001e }, {  190, 0x0000 }, {  190, 0x1000 }, {  191, 0x0000 },
  {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 }, {  191, 0x0000 },
  /* 0x2100 */
  {  191, 0x0208 }, {  193, 0x0048 }, {  195, 0x0846 }, {  199, 0x0000 },
  {  199, 0x0000 }, {  199, 0x7818 }, {  205, 0x03ff }, {  215, 0x03ff },
  {  225, 0x0000 }, {  225, 0x03ff }, {  235, 0x0000 }, {  235, 0x0000 },
  {  235, 0x0000 }, {  235, 0x0014 }, {  237, 0x0000 }, {  237, 0x0000 },
  /* 0x2200 */
  {  237, 0x898d }, {  244, 0x6402 }, {  248, 0x5fa1 }, {  257, 0x3030 },
  {  261, 0x0000 }, {  261, 0x0004 }, {  262, 0x0c33 }, {  268, 0x0000 },
  {  268, 0x00cc }, {  272, 0x0200 }, {  273, 0x0020 }, {  274, 0x0000 },
  {  274, 0x0000 }, {  274, 0x0000 }, {  274, 0x0000 }, {  274, 0x0000 },
  /* 0x2300 */
  {  274, 0x0000 }, {  274, 0x0004 }, {  275, 0x0000 }, {  275, 0x0000 },
  {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 },
  {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 },
  {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 },
  /* 0x2400 */
  {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x0000 },
  {  275, 0x0000 }, {  275, 0x0000 }, {  275, 0x7fff }, {  290, 0xfff0 },
  {  302, 0x0007 }, {  305, 0xf000 }, {  309, 0xffff }, {  325, 0x003f },
  {  331, 0x0000 }, {  331, 0xffff }, {  347, 0x03ff }, {  357, 0x0000 },
  /* 0x2500 */
  {  357, 0xf00f }, {  365, 0xffff }, {  381, 0xffff }, {  397, 0xffff },
  {  413, 0x0fff }, {  425, 0x0000 }, {  425, 0x0000 }, {  425, 0x0000 },
  {  425, 0x0000 }, {  425, 0x0004 }, {  426, 0x03fb }, {  435, 0x30cc },
  {  441, 0xc9c3 }, {  449, 0x0003 }, {  451, 0x0000 }, {  451, 0x0000 },
  /* 0x2600 */
  {  451, 0xc060 }, {  455, 0x5000 }, {  457, 0x0000 }, {  457, 0x0000 },
  {  457, 0x0005 }, {  459, 0x0000 }, {  459, 0x37bb }
};

static const aciConvSummary16 ksc5601_uni2indx_page30[ /*62*/ ] = {
  /* 0x3000 */
  {  470, 0xff0f }, {  482, 0x003b }, {  487, 0x0000 }, {  487, 0x0000 },
  {  487, 0xfffe }, {  502, 0xffff }, {  518, 0xffff }, {  534, 0xffff },
  {  550, 0xffff }, {  566, 0x000f }, {  570, 0xfffe }, {  585, 0xffff },
  {  601, 0xffff }, {  617, 0xffff }, {  633, 0xffff }, {  649, 0x007f },
  /* 0x3100 */
  {  656, 0x0000 }, {  656, 0x0000 }, {  656, 0x0000 }, {  656, 0xfffe },
  {  671, 0xffff }, {  687, 0xffff }, {  703, 0xffff }, {  719, 0xffff },
  {  735, 0x7fff }, {  750, 0x0000 }, {  750, 0x0000 }, {  750, 0x0000 },
  {  750, 0x0000 }, {  750, 0x0000 }, {  750, 0x0000 }, {  750, 0x0000 },
  /* 0x3200 */
  {  750, 0xffff }, {  766, 0x1fff }, {  779, 0x0000 }, {  779, 0x0000 },
  {  779, 0x0000 }, {  779, 0x0000 }, {  779, 0xffff }, {  795, 0xcfff },
  {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 },
  {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 },
  /* 0x3300 */
  {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 },
  {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 }, {  809, 0x0000 },
  {  809, 0xff1f }, {  822, 0xffff }, {  838, 0xffff }, {  854, 0xffff },
  {  870, 0x87ff }, {  882, 0x3949 }
};

static const aciConvSummary16 ksc5601_uni2indx_page4e[ /*1306*/ ] = {
  /* 0x4e00 */
  {  889, 0x2f8b }, {  898, 0x4372 }, {  905, 0x2000 }, {  906, 0x0b04 },
  {  910, 0xe82c }, {  917, 0xe340 }, {  923, 0x2800 }, {  925, 0x40c8 },
  {  929, 0x5944 }, {  935, 0x4937 }, {  943, 0x7976 }, {  953, 0x0440 },
  {  955, 0x2c93 }, {  962, 0xa3f0 }, {  970, 0x0038 }, {  973, 0x08c5 },
  /* 0x4f00 */
  {  978, 0xee02 }, {  985, 0x0003 }, {  987, 0x8000 }, {  988, 0x3550 },
  {  994, 0xe1c8 }, { 1001, 0x1e23 }, { 1008, 0x8200 }, { 1010, 0xc449 },
  { 1016, 0xad5a }, { 1025, 0x2942 }, { 1030, 0xc000 }, { 1032, 0x8060 },
  { 1035, 0x461c }, { 1041, 0xa49a }, { 1048, 0xc003 }, { 1052, 0x052a },
  /* 0x5000 */
  { 1057, 0x2a44 }, { 1062, 0xd646 }, { 1070, 0x3dda }, { 1080, 0x0800 },
  { 1081, 0x8388 }, { 1086, 0x1420 }, { 1089, 0x0020 }, { 1090, 0x0170 },
  { 1094, 0x2021 }, { 1097, 0x0302 }, { 1100, 0x3000 }, { 1102, 0x40ac },
  { 1107, 0x8620 }, { 1111, 0x4462 }, { 1116, 0x20a0 }, { 1119, 0x8a00 },
  /* 0x5100 */
  { 1122, 0x0253 }, { 1127, 0x8004 }, { 1129, 0x0402 }, { 1131, 0x1484 },
  { 1135, 0x7bfb }, { 1148, 0x1004 }, { 1150, 0x7fa4 }, { 1160, 0x11e2 },
  { 1166, 0x2441 }, { 1170, 0x00a4 }, { 1173, 0x1421 }, { 1177, 0x20c0 },
  { 1180, 0x3a50 }, { 1186, 0x7000 }, { 1189, 0x0002 }, { 1190, 0x2743 },
  /* 0x5200 */
  { 1197, 0x45c9 }, { 1204, 0x2082 }, { 1207, 0x4630 }, { 1212, 0x0fc1 },
  { 1219, 0x3c88 }, { 1225, 0x2850 }, { 1229, 0x8602 }, { 1233, 0xa024 },
  { 1237, 0x2388 }, { 1242, 0x8806 }, { 1246, 0x0e19 }, { 1252, 0x4000 },
  { 1253, 0x22aa }, { 1259, 0xeb64 }, { 1268, 0x001c }, { 1271, 0xcd28 },
  /* 0x5300 */
  { 1278, 0xa120 }, { 1282, 0x02e1 }, { 1287, 0x840b }, { 1292, 0x8200 },
  { 1294, 0x279b }, { 1303, 0x549e }, { 1311, 0x8141 }, { 1315, 0xa0b3 },
  { 1322, 0x0010 }, { 1323, 0x8508 }, { 1327, 0x2061 }, { 1331, 0x0800 },
  { 1332, 0x2f08 }, { 1338, 0x08d0 }, { 1342, 0xbe3e }, { 1353, 0x010f },
  /* 0x5400 */
  { 1358, 0xf718 }, { 1367, 0xa803 }, { 1372, 0x0a41 }, { 1376, 0x5b08 },
  { 1382, 0x0504 }, { 1385, 0x0002 }, { 1386, 0x0500 }, { 1388, 0x382a },
  { 1394, 0x5041 }, { 1398, 0x0001 }, { 1399, 0x1910 }, { 1403, 0x2108 },
  { 1406, 0x0313 }, { 1411, 0x0000 }, { 1411, 0x6122 }, { 1416, 0x0404 },
  /* 0x5500 */
  { 1418, 0x40d0 }, { 1422, 0x1001 }, { 1424, 0x8000 }, { 1425, 0x4022 },
  { 1428, 0x8050 }, { 1431, 0x4048 }, { 1434, 0x0008 }, { 1435, 0x1000 },
  { 1436, 0x06d1 }, { 1442, 0x3700 }, { 1447, 0x5e80 }, { 1453, 0x0000 },
  { 1453, 0x00a0 }, { 1455, 0x9410 }, { 1459, 0x0018 }, { 1461, 0x6000 },
  /* 0x5600 */
  { 1463, 0x0240 }, { 1465, 0x0090 }, { 1467, 0x8000 }, { 1468, 0x0054 },
  { 1471, 0x0000 }, { 1471, 0x0008 }, { 1472, 0x0900 }, { 1474, 0x0010 },
  { 1475, 0x0040 }, { 1476, 0x0000 }, { 1476, 0x5020 }, { 1479, 0x1010 },
  { 1481, 0x2400 }, { 1483, 0x4c02 }, { 1487, 0x0001 }, { 1488, 0x0601 },
  /* 0x5700 */
  { 1491, 0x2918 }, { 1496, 0x814c }, { 1501, 0x2100 }, { 1503, 0x0801 },
  { 1505, 0x6485 }, { 1511, 0x0003 }, { 1513, 0x4452 }, { 1518, 0x1021 },
  { 1521, 0x0904 }, { 1524, 0x0008 }, { 1525, 0x000d }, { 1528, 0x0000 },
  { 1528, 0x4988 }, { 1533, 0x8000 }, { 1534, 0x0001 }, { 1535, 0x1691 },
  /* 0x5800 */
  { 1541, 0x0765 }, { 1548, 0x4000 }, { 1549, 0x8492 }, { 1554, 0x0433 },
  { 1559, 0x8c00 }, { 1562, 0x4592 }, { 1568, 0x0016 }, { 1571, 0x5220 },
  { 1575, 0x0228 }, { 1578, 0xd008 }, { 1582, 0x4300 }, { 1585, 0x4c08 },
  { 1589, 0x40a2 }, { 1593, 0xc32a }, { 1600, 0x9810 }, { 1604, 0x2e00 },
  /* 0x5900 */
  { 1608, 0x8000 }, { 1609, 0x1670 }, { 1615, 0x6e84 }, { 1622, 0x4082 },
  { 1625, 0xc390 }, { 1631, 0x04b3 }, { 1637, 0x7c85 }, { 1645, 0x2118 },
  { 1649, 0x041c }, { 1653, 0x02c8 }, { 1657, 0x1120 }, { 1660, 0x4a00 },
  { 1663, 0x0a48 }, { 1667, 0x361b }, { 1675, 0x5540 }, { 1680, 0x8900 },
  /* 0x5a00 */
  { 1683, 0x000a }, { 1685, 0x9902 }, { 1690, 0x0221 }, { 1693, 0x1040 },
  { 1695, 0x0242 }, { 1698, 0x0400 }, { 1699, 0x0044 }, { 1701, 0x0000 },
  { 1701, 0x0000 }, { 1701, 0x0c04 }, { 1704, 0x0010 }, { 1705, 0x0000 },
  { 1705, 0x1216 }, { 1710, 0x0000 }, { 1710, 0x0242 }, { 1713, 0x0000 },
  /* 0x5b00 */
  { 1713, 0x1a20 }, { 1717, 0x0040 }, { 1718, 0x0400 }, { 1719, 0x0000 },
  { 1719, 0x0009 }, { 1721, 0xb5b3 }, { 1731, 0x0a18 }, { 1735, 0x1523 },
  { 1741, 0x9ba0 }, { 1748, 0x1fe8 }, { 1757, 0x507c }, { 1764, 0x8379 },
  { 1772, 0x10fd }, { 1780, 0xc09d }, { 1787, 0xdbf6 }, { 1799, 0x0560 },
  /* 0x5c00 */
  { 1803, 0xef92 }, { 1813, 0x0242 }, { 1816, 0x0110 }, { 1818, 0xdf02 },
  { 1826, 0x6961 }, { 1833, 0x0822 }, { 1836, 0x9035 }, { 1842, 0x0202 },
  { 1844, 0x0000 }, { 1844, 0x0003 }, { 1846, 0x1a02 }, { 1850, 0x45aa },
  { 1857, 0x0001 }, { 1858, 0x0200 }, { 1859, 0x8101 }, { 1862, 0x2851 },
  /* 0x5d00 */
  { 1867, 0x6080 }, { 1870, 0x02d2 }, { 1875, 0x0280 }, { 1877, 0x0000 },
  { 1877, 0x1800 }, { 1879, 0x0001 }, { 1880, 0x9200 }, { 1883, 0x0000 },
  { 1883, 0x0880 }, { 1885, 0x2000 }, { 1886, 0x0405 }, { 1889, 0x3500 },
  { 1893, 0x2000 }, { 1894, 0x6044 }, { 1898, 0x49e6 }, { 1906, 0x609e },
  /* 0x5e00 */
  { 1913, 0x104c }, { 1917, 0x2a42 }, { 1922, 0x2820 }, { 1925, 0xa148 },
  { 1930, 0x10b1 }, { 1935, 0x8020 }, { 1937, 0x000e }, { 1940, 0x7b9c },
  { 1950, 0x8490 }, { 1954, 0x14a0 }, { 1958, 0x28c1 }, { 1963, 0x41e0 },
  { 1968, 0x0704 }, { 1972, 0x8c49 }, { 1978, 0x100d }, { 1982, 0x0cc8 },
  /* 0x5f00 */
  { 1987, 0x8412 }, { 1991, 0x89ba }, { 1999, 0x02c0 }, { 2002, 0x1422 },
  { 2006, 0x5500 }, { 2010, 0x0ac0 }, { 2014, 0x3ec4 }, { 2022, 0x9283 },
  { 2028, 0x1ca3 }, { 2035, 0x4387 }, { 2042, 0x4703 }, { 2048, 0x22a0 },
  { 2052, 0x3028 }, { 2056, 0x03c0 }, { 2060, 0x0801 }, { 2062, 0xa020 },
  /* 0x6000 */
  { 2065, 0x8000 }, { 2066, 0x3044 }, { 2070, 0x85a3 }, { 2077, 0x0000 },
  { 2077, 0x200e }, { 2081, 0x2225 }, { 2086, 0xb73c }, { 2096, 0x0001 },
  { 2097, 0x3220 }, { 2101, 0x8c50 }, { 2106, 0x0099 }, { 2110, 0x315d },
  { 2118, 0x00a0 }, { 2120, 0x9402 }, { 2124, 0x0003 }, { 2126, 0x0e4b },
  /* 0x6100 */
  { 2133, 0xe342 }, { 2140, 0x8c20 }, { 2144, 0x0080 }, { 2145, 0xd091 },
  { 2151, 0x1d94 }, { 2158, 0xa328 }, { 2164, 0x499c }, { 2171, 0x60c1 },
  { 2176, 0x4406 }, { 2180, 0x0713 }, { 2186, 0x5a90 }, { 2192, 0x4444 },
  { 2196, 0x0f88 }, { 2202, 0x0000 }, { 2202, 0x0040 }, { 2203, 0x95c4 },
  /* 0x6200 */
  { 2210, 0x7581 }, { 2217, 0x8447 }, { 2223, 0x4402 }, { 2226, 0xc053 },
  { 2232, 0x2b83 }, { 2239, 0x0108 }, { 2241, 0x4000 }, { 2242, 0x9242 },
  { 2247, 0x0611 }, { 2251, 0x09a6 }, { 2257, 0x0800 }, { 2258, 0x3222 },
  { 2263, 0xb384 }, { 2270, 0x1bdd }, { 2280, 0xf000 }, { 2284, 0xc08a },
  /* 0x6300 */
  { 2289, 0x0282 }, { 2292, 0x0002 }, { 2293, 0x8800 }, { 2295, 0x6c00 },
  { 2299, 0x9200 }, { 2302, 0x0021 }, { 2304, 0x4180 }, { 2307, 0x8c84 },
  { 2312, 0x1308 }, { 2316, 0x0944 }, { 2320, 0x07a7 }, { 2328, 0x0000 },
  { 2328, 0x8051 }, { 2332, 0x0c41 }, { 2336, 0x6002 }, { 2339, 0x00d0 },
  /* 0x6400 */
  { 2342, 0xa000 }, { 2344, 0x10d0 }, { 2348, 0x3004 }, { 2351, 0x4400 },
  { 2353, 0x0000 }, { 2353, 0x0100 }, { 2354, 0x8201 }, { 2357, 0x0700 },
  { 2360, 0x0100 }, { 2361, 0x440e }, { 2366, 0x6830 }, { 2371, 0x0805 },
  { 2374, 0x64b2 }, { 2381, 0x0514 }, { 2385, 0x10e6 }, { 2391, 0x4414 },
  /* 0x6500 */
  { 2395, 0x0011 }, { 2397, 0x2100 }, { 2399, 0x9c08 }, { 2404, 0xcbc0 },
  { 2411, 0xe120 }, { 2416, 0x40c2 }, { 2420, 0x304c }, { 2425, 0x41b4 },
  { 2431, 0x10ac }, { 2436, 0x9a83 }, { 2443, 0x98b2 }, { 2450, 0x3281 },
  { 2455, 0x9822 }, { 2460, 0x0084 }, { 2462, 0x3369 }, { 2470, 0xbc12 },
  /* 0x6600 */
  { 2477, 0xd6c0 }, { 2484, 0xc03b }, { 2491, 0xa1a1 }, { 2497, 0x0c53 },
  { 2503, 0x8a1e }, { 2510, 0xea00 }, { 2515, 0xcbf0 }, { 2524, 0x05d8 },
  { 2530, 0x4390 }, { 2535, 0x21c3 }, { 2541, 0x4805 }, { 2545, 0x4a1c },
  { 2551, 0x02d0 }, { 2555, 0x3240 }, { 2559, 0x0041 }, { 2561, 0xd79d },
  /* 0x6700 */
  { 2572, 0x2b09 }, { 2578, 0xe8b0 }, { 2585, 0x7dc0 }, { 2593, 0x2452 },
  { 2598, 0xc240 }, { 2602, 0xd04b }, { 2609, 0xa000 }, { 2611, 0xc8ab },
  { 2619, 0x8a80 }, { 2623, 0x34a9 }, { 2630, 0x8000 }, { 2631, 0x41c9 },
  { 2637, 0x8010 }, { 2639, 0x241f }, { 2646, 0x9200 }, { 2649, 0x487b },
  /* 0x6800 */
  { 2657, 0x0000 }, { 2657, 0x00cc }, { 2661, 0x8406 }, { 2665, 0x3300 },
  { 2669, 0x410f }, { 2675, 0x001b }, { 2679, 0x2000 }, { 2680, 0x8040 },
  { 2682, 0x8022 }, { 2685, 0xa098 }, { 2690, 0xa186 }, { 2696, 0x006b },
  { 2701, 0x2a30 }, { 2706, 0x85a4 }, { 2712, 0x4181 }, { 2716, 0x0604 },
  /* 0x6900 */
  { 2719, 0x6021 }, { 2723, 0x0004 }, { 2724, 0x0080 }, { 2725, 0xa001 },
  { 2728, 0x0400 }, { 2729, 0x46b8 }, { 2736, 0xe90f }, { 2745, 0x03a0 },
  { 2749, 0x0000 }, { 2749, 0x1820 }, { 2752, 0x40a0 }, { 2755, 0x0810 },
  { 2757, 0x380a }, { 2762, 0x0001 }, { 2763, 0x0500 }, { 2765, 0xa800 },
  /* 0x6a00 */
  { 2768, 0x0404 }, { 2770, 0xc28a }, { 2776, 0x000a }, { 2778, 0x2720 },
  { 2783, 0x0910 }, { 2786, 0x830c }, { 2791, 0x0802 }, { 2793, 0x0000 },
  { 2793, 0x6211 }, { 2798, 0x1080 }, { 2800, 0x000c }, { 2802, 0x0808 },
  { 2804, 0x000c }, { 2806, 0x0c08 }, { 2809, 0x0000 }, { 2809, 0x0840 },
  /* 0x6b00 */
  { 2811, 0x1410 }, { 2814, 0x0044 }, { 2816, 0x000b }, { 2819, 0x6404 },
  { 2823, 0x50c0 }, { 2827, 0x8001 }, { 2829, 0x047e }, { 2836, 0x8984 },
  { 2841, 0x0658 }, { 2846, 0x4140 }, { 2849, 0xc000 }, { 2851, 0x94a4 },
  { 2857, 0xa862 }, { 2863, 0x09dc }, { 2870, 0x1800 }, { 2872, 0x0000 },
  /* 0x6c00 */
  { 2872, 0x8100 }, { 2874, 0x000a }, { 2876, 0x0008 }, { 2877, 0x4190 },
  { 2881, 0x4007 }, { 2885, 0xe4a1 }, { 2892, 0x2501 }, { 2896, 0x6445 },
  { 2902, 0x11ee }, { 2910, 0x0e7d }, { 2919, 0x4800 }, { 2921, 0xfb08 },
  { 2929, 0x1616 }, { 2935, 0x08a8 }, { 2939, 0xc92e }, { 2947, 0x0009 },
  /* 0x6d00 */
  { 2949, 0x1800 }, { 2951, 0x4a82 }, { 2956, 0x06a0 }, { 2960, 0x6b64 },
  { 2968, 0x0002 }, { 2969, 0x1600 }, { 2972, 0x5648 }, { 2978, 0x8390 },
  { 2983, 0x73a0 }, { 2990, 0x002a }, { 2993, 0x8000 }, { 2994, 0x0024 },
  { 2996, 0x88f9 }, { 3004, 0x4702 }, { 3009, 0x4d02 }, { 3014, 0x0faa },
  /* 0x6e00 */
  { 3022, 0x0000 }, { 3022, 0x8e80 }, { 3027, 0xb87b }, { 3037, 0x7554 },
  { 3045, 0x2418 }, { 3049, 0xd940 }, { 3055, 0xc880 }, { 3059, 0x040c },
  { 3062, 0x0000 }, { 3062, 0xb041 }, { 3067, 0x8c24 }, { 3072, 0x0442 },
  { 3075, 0x5a34 }, { 3082, 0x001a }, { 3085, 0x8000 }, { 3086, 0xc110 },
  /* 0x6f00 */
  { 3090, 0x8046 }, { 3094, 0x0032 }, { 3097, 0x180d }, { 3102, 0x8106 },
  { 3106, 0x0002 }, { 3107, 0xcd92 }, { 3115, 0x6014 }, { 3119, 0x7401 },
  { 3124, 0x6112 }, { 3129, 0x0091 }, { 3132, 0xc098 }, { 3137, 0x420a },
  { 3141, 0x040f }, { 3146, 0x8420 }, { 3149, 0x9a13 }, { 3156, 0x4002 },
  /* 0x7000 */
  { 3158, 0x8a62 }, { 3164, 0xfd22 }, { 3173, 0x8188 }, { 3177, 0x4080 },
  { 3179, 0x1000 }, { 3180, 0x2103 }, { 3184, 0x0808 }, { 3186, 0x3101 },
  { 3190, 0x4420 }, { 3193, 0x0704 }, { 3197, 0xb812 }, { 3203, 0x0388 },
  { 3207, 0x8900 }, { 3210, 0xa300 }, { 3214, 0x0000 }, { 3214, 0x2202 },
  /* 0x7100 */
  { 3217, 0x1210 }, { 3220, 0x4600 }, { 3223, 0x0042 }, { 3225, 0x0041 },
  { 3227, 0x5680 }, { 3232, 0x5241 }, { 3237, 0x52f0 }, { 3244, 0x2000 },
  { 3245, 0x8610 }, { 3249, 0x8214 }, { 3253, 0x1004 }, { 3255, 0x4602 },
  { 3259, 0x430a }, { 3264, 0x8035 }, { 3269, 0x60e0 }, { 3274, 0xd800 },
  /* 0x7200 */
  { 3278, 0x0041 }, { 3280, 0x0801 }, { 3282, 0x3400 }, { 3285, 0x6c65 },
  { 3293, 0x11c1 }, { 3298, 0xab04 }, { 3304, 0x0286 }, { 3308, 0x2204 },
  { 3311, 0x0003 }, { 3313, 0x0000 }, { 3313, 0x9084 }, { 3317, 0x0000 },
  { 3317, 0x4015 }, { 3321, 0x0281 }, { 3324, 0x0202 }, { 3326, 0x3300 },
  /* 0x7300 */
  { 3330, 0x0400 }, { 3331, 0x3840 }, { 3335, 0x0e20 }, { 3339, 0xc0c0 },
  { 3343, 0x0030 }, { 3345, 0x0085 }, { 3348, 0x0500 }, { 3350, 0x0d25 },
  { 3356, 0x4ad0 }, { 3362, 0x81d0 }, { 3367, 0x2280 }, { 3370, 0x020c },
  { 3373, 0xb605 }, { 3380, 0x6240 }, { 3384, 0x2679 }, { 3392, 0x6280 },
  /* 0x7400 */
  { 3396, 0x02ea }, { 3402, 0x0808 }, { 3404, 0xdd67 }, { 3415, 0x8579 },
  { 3423, 0x081b }, { 3428, 0xdea0 }, { 3436, 0x8735 }, { 3444, 0x4000 },
  { 3445, 0x0a8c }, { 3450, 0xd100 }, { 3454, 0x05aa }, { 3460, 0xa225 },
  { 3466, 0x8440 }, { 3469, 0x1510 }, { 3473, 0x404d }, { 3478, 0x0080 },
  /* 0x7500 */
  { 3479, 0x0012 }, { 3481, 0x8d22 }, { 3487, 0x1968 }, { 3493, 0x058f },
  { 3500, 0x9080 }, { 3503, 0x3a1a }, { 3510, 0x8464 }, { 3515, 0x8561 },
  { 3521, 0xccc0 }, { 3527, 0x2002 }, { 3529, 0x0820 }, { 3531, 0x732e },
  { 3540, 0x20a4 }, { 3544, 0x0b34 }, { 3550, 0x0004 }, { 3551, 0x1415 },
  /* 0x7600 */
  { 3556, 0x2001 }, { 3558, 0x8200 }, { 3560, 0x0057 }, { 3565, 0x0800 },
  { 3566, 0x5004 }, { 3569, 0x0044 }, { 3571, 0x1212 }, { 3575, 0x7905 },
  { 3582, 0x40d0 }, { 3586, 0x0009 }, { 3588, 0x4000 }, { 3589, 0x8400 },
  { 3591, 0x054c }, { 3596, 0xd844 }, { 3602, 0x409a }, { 3607, 0x5114 },
  /* 0x7700 */
  { 3612, 0x0b12 }, { 3617, 0x4000 }, { 3618, 0x0201 }, { 3620, 0x1580 },
  { 3624, 0x2001 }, { 3626, 0x0800 }, { 3627, 0x084a }, { 3631, 0xc200 },
  { 3634, 0x0800 }, { 3635, 0x4002 }, { 3637, 0x3020 }, { 3640, 0x9809 },
  { 3645, 0x0000 }, { 3645, 0x1880 }, { 3648, 0xe22c }, { 3655, 0x0008 },
  /* 0x7800 */
  { 3656, 0x0004 }, { 3657, 0x0004 }, { 3658, 0x10e0 }, { 3662, 0x0014 },
  { 3664, 0x8020 }, { 3666, 0x2000 }, { 3667, 0x9800 }, { 3670, 0x1000 },
  { 3671, 0x7082 }, { 3676, 0x0082 }, { 3678, 0x0288 }, { 3681, 0x1c00 },
  { 3684, 0x4c22 }, { 3689, 0x0001 }, { 3690, 0x9100 }, { 3693, 0x0820 },
  /* 0x7900 */
  { 3695, 0x4002 }, { 3697, 0x0040 }, { 3698, 0x1c00 }, { 3701, 0x4400 },
  { 3703, 0x0383 }, { 3708, 0x7cc1 }, { 3716, 0x2121 }, { 3720, 0x8400 },
  { 3722, 0xe002 }, { 3726, 0x0002 }, { 3727, 0x44c0 }, { 3731, 0xe20a },
  { 3737, 0x0e03 }, { 3742, 0x8126 }, { 3747, 0x02d0 }, { 3751, 0x0800 },
  /* 0x7a00 */
  { 3752, 0x2921 }, { 3757, 0x9690 }, { 3763, 0x4001 }, { 3765, 0xb8c2 },
  { 3772, 0x6241 }, { 3777, 0x0080 }, { 3778, 0x0a06 }, { 3782, 0xa651 },
  { 3789, 0x0112 }, { 3792, 0x812c }, { 3797, 0xc600 }, { 3801, 0x0400 },
  { 3802, 0x0cb0 }, { 3807, 0xa280 }, { 3811, 0xa429 }, { 3817, 0x8640 },
  /* 0x7b00 */
  { 3821, 0x8000 }, { 3822, 0x4a02 }, { 3826, 0x3041 }, { 3830, 0x0200 },
  { 3831, 0xba40 }, { 3837, 0x0057 }, { 3842, 0x5001 }, { 3845, 0x2020 },
  { 3847, 0x8880 }, { 3850, 0x24b0 }, { 3855, 0x2002 }, { 3857, 0x0112 },
  { 3860, 0x02d3 }, { 3866, 0x0004 }, { 3867, 0x0211 }, { 3870, 0x0000 },
  /* 0x7c00 */
  { 3870, 0x0080 }, { 3871, 0x4004 }, { 3873, 0x0c82 }, { 3877, 0xe000 },
  { 3880, 0x3008 }, { 3883, 0x0000 }, { 3883, 0x1011 }, { 3886, 0x0008 },
  { 3887, 0x0208 }, { 3889, 0x81a4 }, { 3894, 0x40a0 }, { 3897, 0x420e },
  { 3902, 0x0400 }, { 3903, 0xc040 }, { 3906, 0x0081 }, { 3908, 0x4800 },
  /* 0x7d00 */
  { 3910, 0x2df5 }, { 3920, 0x0f91 }, { 3927, 0xd807 }, { 3934, 0x0629 },
  { 3939, 0x007c }, { 3944, 0x4001 }, { 3946, 0x4546 }, { 3952, 0x824e },
  { 3958, 0xc000 }, { 3960, 0x1008 }, { 3962, 0x3005 }, { 3966, 0xed36 },
  { 3976, 0x0c80 }, { 3979, 0x6540 }, { 3984, 0x930b }, { 3991, 0x0810 },
  /* 0x7e00 */
  { 3993, 0x0600 }, { 3995, 0xe820 }, { 4000, 0xc80a }, { 4005, 0x6082 },
  { 4009, 0x00ca }, { 4013, 0x4034 }, { 4017, 0x2e02 }, { 4022, 0x1201 },
  { 4025, 0x9004 }, { 4028, 0x1948 }, { 4033, 0x0000 }, { 4033, 0x0000 },
  { 4033, 0x0000 }, { 4033, 0x0000 }, { 4033, 0x0000 }, { 4033, 0x0000 },
  /* 0x7f00 */
  { 4033, 0x0000 }, { 4033, 0x0000 }, { 4033, 0x0000 }, { 4033, 0x0540 },
  { 4036, 0x1000 }, { 4037, 0x0031 }, { 4040, 0x4c00 }, { 4043, 0x02a5 },
  { 4048, 0x5520 }, { 4053, 0x4410 }, { 4056, 0x0310 }, { 4059, 0x2304 },
  { 4063, 0x5422 }, { 4068, 0x8034 }, { 4072, 0x0a03 }, { 4076, 0x1201 },
  /* 0x8000 */
  { 4079, 0x126b }, { 4086, 0x01a1 }, { 4090, 0x2000 }, { 4091, 0xa048 },
  { 4095, 0x0448 }, { 4098, 0x4540 }, { 4102, 0x8000 }, { 4103, 0xe08d },
  { 4110, 0x1af0 }, { 4117, 0x2840 }, { 4120, 0x8626 }, { 4126, 0x0416 },
  { 4130, 0x5018 }, { 4134, 0x4c00 }, { 4137, 0x0032 }, { 4140, 0x2112 },
  /* 0x8100 */
  { 4144, 0x05e4 }, { 4150, 0x0d00 }, { 4153, 0x8a08 }, { 4157, 0x4200 },
  { 4159, 0x4800 }, { 4161, 0x0033 }, { 4165, 0x0860 }, { 4168, 0x8703 },
  { 4174, 0x8501 }, { 4178, 0x3400 }, { 4181, 0x0109 }, { 4184, 0xe428 },
  { 4190, 0x2045 }, { 4194, 0x8100 }, { 4196, 0x25a8 }, { 4202, 0x5c18 },
  /* 0x8200 */
  { 4208, 0x35a0 }, { 4214, 0xd804 }, { 4219, 0x1c02 }, { 4223, 0x02e0 },
  { 4227, 0x00a1 }, { 4230, 0x0200 }, { 4231, 0xc050 }, { 4235, 0x4146 },
  { 4240, 0x6800 }, { 4243, 0xa604 }, { 4248, 0xf260 }, { 4255, 0xbb8a },
  { 4264, 0x0000 }, { 4264, 0xc8b6 }, { 4272, 0x00e2 }, { 4276, 0x6002 },
  /* 0x8300 */
  { 4279, 0x023e }, { 4285, 0x0080 }, { 4286, 0x8900 }, { 4289, 0x0372 },
  { 4295, 0x8681 }, { 4300, 0x0006 }, { 4302, 0x0000 }, { 4302, 0x0888 },
  { 4305, 0x4600 }, { 4308, 0x4140 }, { 4311, 0x0e04 }, { 4315, 0x2000 },
  { 4316, 0x1622 }, { 4321, 0x1048 }, { 4324, 0x8a00 }, { 4327, 0x2217 },
  /* 0x8400 */
  { 4333, 0x7418 }, { 4339, 0x0000 }, { 4339, 0x1200 }, { 4341, 0x2102 },
  { 4344, 0x0200 }, { 4345, 0x0880 }, { 4347, 0x984a }, { 4353, 0x0420 },
  { 4355, 0x0000 }, { 4355, 0x1211 }, { 4359, 0x0002 }, { 4360, 0x9904 },
  { 4365, 0x2a55 }, { 4372, 0x0402 }, { 4374, 0x5000 }, { 4376, 0x1010 },
  /* 0x8500 */
  { 4378, 0x0000 }, { 4378, 0x459a }, { 4385, 0xb02a }, { 4391, 0xa000 },
  { 4393, 0x420a }, { 4397, 0x0208 }, { 4399, 0x2708 }, { 4404, 0x0000 },
  { 4404, 0x8090 }, { 4407, 0x0812 }, { 4410, 0x8740 }, { 4415, 0x0401 },
  { 4417, 0xe202 }, { 4422, 0x3020 }, { 4425, 0x0630 }, { 4429, 0x8c80 },
  /* 0x8600 */
  { 4433, 0x04c4 }, { 4437, 0x04c0 }, { 4440, 0x2000 }, { 4441, 0x8000 },
  { 4442, 0x4000 }, { 4443, 0xd831 }, { 4450, 0x0080 }, { 4451, 0x0200 },
  { 4452, 0x1400 }, { 4454, 0x0008 }, { 4455, 0x0218 }, { 4458, 0x0000 },
  { 4458, 0x0880 }, { 4460, 0x8a10 }, { 4464, 0x2010 }, { 4466, 0x4000 },
  /* 0x8700 */
  { 4467, 0x010d }, { 4471, 0x1500 }, { 4474, 0x0000 }, { 4474, 0x0000 },
  { 4474, 0x4000 }, { 4475, 0x80a0 }, { 4478, 0x0140 }, { 4480, 0x0150 },
  { 4483, 0x2004 }, { 4485, 0x8000 }, { 4486, 0x0004 }, { 4487, 0x0408 },
  { 4489, 0x0010 }, { 4490, 0x0000 }, { 4490, 0x9001 }, { 4493, 0x4a04 },
  /* 0x8800 */
  { 4497, 0x0020 }, { 4498, 0x8000 }, { 4499, 0x000c }, { 4501, 0x0842 },
  { 4504, 0x3041 }, { 4508, 0x2a8c }, { 4514, 0x090e }, { 4519, 0xc085 },
  { 4524, 0x2906 }, { 4529, 0x40c4 }, { 4533, 0x0800 }, { 4534, 0x0010 },
  { 4535, 0x8006 }, { 4538, 0xb230 }, { 4544, 0x0102 }, { 4546, 0x2138 },
  /* 0x8900 */
  { 4551, 0x0080 }, { 4552, 0x030d }, { 4557, 0x0420 }, { 4559, 0x0940 },
  { 4562, 0x0012 }, { 4564, 0x8000 }, { 4565, 0x0410 }, { 4567, 0x8004 },
  { 4569, 0x88ca }, { 4575, 0x0048 }, { 4577, 0x0602 }, { 4580, 0x2404 },
  { 4583, 0x0001 }, { 4584, 0x0004 }, { 4585, 0x0008 }, { 4586, 0x0110 },
  /* 0x8a00 */
  { 4588, 0x550d }, { 4595, 0xa9c8 }, { 4602, 0x2428 }, { 4606, 0x0c52 },
  { 4611, 0x0000 }, { 4611, 0x4831 }, { 4616, 0x624d }, { 4623, 0x022f },
  { 4629, 0x30a0 }, { 4633, 0x4128 }, { 4637, 0x057b }, { 4645, 0xd205 },
  { 4651, 0xa894 }, { 4657, 0x1844 }, { 4661, 0x6cc2 }, { 4668, 0x45c2 },
  /* 0x8b00 */
  { 4674, 0x4017 }, { 4679, 0x2ed1 }, { 4687, 0x1901 }, { 4691, 0x0208 },
  { 4693, 0xc202 }, { 4697, 0x1500 }, { 4700, 0x9040 }, { 4703, 0x2091 },
  { 4707, 0x0401 }, { 4709, 0x044d }, { 4714, 0x0000 }, { 4714, 0x0000 },
  { 4714, 0x0000 }, { 4714, 0x0000 }, { 4714, 0x0000 }, { 4714, 0x0000 },
  /* 0x8c00 */
  { 4714, 0x0000 }, { 4714, 0x0000 }, { 4714, 0x0000 }, { 4714, 0x8080 },
  { 4716, 0x1542 }, { 4721, 0x0420 }, { 4723, 0x0c02 }, { 4726, 0x0600 },
  { 4728, 0x1404 }, { 4731, 0x6000 }, { 4733, 0x9f87 }, { 4743, 0xb9d9 },
  { 4753, 0x059f }, { 4761, 0x540a }, { 4766, 0x245d }, { 4773, 0x3810 },
  /* 0x8d00 */
  { 4777, 0x25b0 }, { 4783, 0x0048 }, { 4785, 0x0000 }, { 4785, 0x0000 },
  { 4785, 0x0000 }, { 4785, 0x0000 }, { 4785, 0x0850 }, { 4788, 0x0099 },
  { 4792, 0x0420 }, { 4794, 0x0200 }, { 4795, 0x0108 }, { 4797, 0x4408 },
  { 4800, 0x9840 }, { 4804, 0x2800 }, { 4806, 0x810a }, { 4810, 0x0008 },
  /* 0x8e00 */
  { 4811, 0x8400 }, { 4813, 0x4001 }, { 4815, 0x0400 }, { 4816, 0x0021 },
  { 4818, 0x0794 }, { 4824, 0x8200 }, { 4826, 0x0001 }, { 4827, 0x0050 },
  { 4829, 0x2482 }, { 4833, 0x0000 }, { 4833, 0x1c00 }, { 4836, 0x0000 },
  { 4836, 0x3c01 }, { 4841, 0x8004 }, { 4843, 0x0800 }, { 4844, 0x4900 },
  /* 0x8f00 */
  { 4847, 0x0228 }, { 4850, 0xf83c }, { 4859, 0x86c0 }, { 4864, 0xcb08 },
  { 4870, 0x6230 }, { 4875, 0xa000 }, { 4877, 0x0004 }, { 4878, 0x0000 },
  { 4878, 0x0000 }, { 4878, 0x1800 }, { 4880, 0xa148 }, { 4885, 0x0007 },
  { 4888, 0x4024 }, { 4891, 0x0012 }, { 4893, 0x2c40 }, { 4897, 0x2285 },
  /* 0x9000 */
  { 4902, 0xa96f }, { 4912, 0xe6b3 }, { 4922, 0x400f }, { 4927, 0x5126 },
  { 4933, 0x6c86 }, { 4940, 0x723b }, { 4949, 0xe20b }, { 4956, 0xb5a4 },
  { 4964, 0x859f }, { 4973, 0x0222 }, { 4976, 0x854c }, { 4982, 0x0123 },
  { 4986, 0x0402 }, { 4988, 0x4000 }, { 4989, 0x2102 }, { 4992, 0x2020 },
  /* 0x9100 */
  { 4994, 0x0004 }, { 4995, 0x0224 }, { 4998, 0x2080 }, { 5000, 0x0004 },
  { 5001, 0x7e00 }, { 5007, 0x0004 }, { 5008, 0x1604 }, { 5012, 0x01a0 },
  { 5015, 0x2a80 }, { 5019, 0x1004 }, { 5021, 0xd800 }, { 5025, 0x0032 },
  { 5028, 0xfa81 }, { 5036, 0x3183 }, { 5042, 0x0488 }, { 5045, 0x0020 },
  /* 0x9200 */
  { 5046, 0x2000 }, { 5047, 0x4087 }, { 5052, 0x0000 }, { 5052, 0x8410 },
  { 5055, 0x0221 }, { 5058, 0x4880 }, { 5061, 0x0074 }, { 5065, 0x0000 },
  { 5065, 0x0029 }, { 5068, 0x114a }, { 5073, 0x0000 }, { 5073, 0x02c8 },
  { 5077, 0x9000 }, { 5079, 0x0004 }, { 5080, 0x0410 }, { 5082, 0x1100 },
  /* 0x9300 */
  { 5084, 0x0010 }, { 5085, 0xc501 }, { 5090, 0xc957 }, { 5099, 0x0000 },
  { 5099, 0x2d00 }, { 5103, 0x0810 }, { 5105, 0x4000 }, { 5106, 0x5020 },
  { 5109, 0x1000 }, { 5110, 0x0450 }, { 5113, 0x3088 }, { 5117, 0x0001 },
  { 5118, 0x0008 }, { 5119, 0x4002 }, { 5121, 0x0012 }, { 5123, 0x0040 },
  /* 0x9400 */
  { 5124, 0x0010 }, { 5125, 0x0100 }, { 5126, 0x0820 }, { 5128, 0x0120 },
  { 5130, 0x0010 }, { 5131, 0x0806 }, { 5134, 0x0000 }, { 5134, 0xa000 },
  { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 },
  { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 },
  /* 0x9500 */
  { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 },
  { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0000 }, { 5136, 0x0080 },
  { 5137, 0x8a09 }, { 5142, 0x011e }, { 5147, 0x2138 }, { 5152, 0x1802 },
  { 5155, 0x0480 }, { 5157, 0x1070 }, { 5161, 0x0006 }, { 5163, 0x0000 },
  /* 0x9600 */
  { 5163, 0x0000 }, { 5163, 0x1000 }, { 5164, 0x4402 }, { 5167, 0x8804 },
  { 5170, 0x3815 }, { 5176, 0xf801 }, { 5182, 0x041c }, { 5186, 0x21e9 },
  { 5193, 0x6c60 }, { 5199, 0x1b30 }, { 5205, 0x0588 }, { 5209, 0x0882 },
  { 5212, 0x7af3 }, { 5223, 0x1a60 }, { 5228, 0x870c }, { 5234, 0x0ac5 },
  /* 0x9700 */
  { 5240, 0x00c1 }, { 5243, 0x524a }, { 5249, 0x0080 }, { 5250, 0x2205 },
  { 5254, 0x0114 }, { 5257, 0x5042 }, { 5261, 0x2206 }, { 5265, 0x0490 },
  { 5268, 0xa800 }, { 5271, 0x0000 }, { 5271, 0x2901 }, { 5275, 0x0000 },
  { 5275, 0x0840 }, { 5277, 0x1008 }, { 5279, 0x0000 }, { 5279, 0x8848 },
  /* 0x9800 */
  { 5283, 0x156f }, { 5292, 0x018f }, { 5298, 0x2000 }, { 5299, 0x0b01 },
  { 5303, 0x7040 }, { 5307, 0x4510 }, { 5311, 0x88a0 }, { 5315, 0x0000 },
  { 5315, 0x0000 }, { 5315, 0x0000 }, { 5315, 0x8100 }, { 5317, 0x0002 },
  { 5318, 0x0090 }, { 5320, 0x9800 }, { 5323, 0xe006 }, { 5328, 0x7010 },
  /* 0x9900 */
  { 5332, 0x1608 }, { 5336, 0x4109 }, { 5340, 0x0101 }, { 5342, 0x0000 },
  { 5342, 0x3a20 }, { 5347, 0x0096 }, { 5351, 0x0000 }, { 5351, 0x0000 },
  { 5351, 0x0000 }, { 5351, 0x2240 }, { 5354, 0x7120 }, { 5359, 0x021a },
  { 5363, 0x0002 }, { 5364, 0xa227 }, { 5371, 0x2000 }, { 5372, 0x8002 },
  /* 0x9a00 */
  { 5374, 0xc102 }, { 5378, 0x0200 }, { 5379, 0x0800 }, { 5380, 0x00c1 },
  { 5383, 0x2029 }, { 5387, 0x8ca0 }, { 5392, 0x0624 }, { 5396, 0x0000 },
  { 5396, 0x0000 }, { 5396, 0x0000 }, { 5396, 0x0100 }, { 5397, 0x0100 },
  { 5398, 0x0000 }, { 5398, 0x0118 }, { 5401, 0x4020 }, { 5403, 0x0000 },
  /* 0x9b00 */
  { 5403, 0x0000 }, { 5403, 0x0400 }, { 5404, 0x0480 }, { 5406, 0x1002 },
  { 5408, 0x803e }, { 5414, 0x0410 }, { 5416, 0x8000 }, { 5417, 0x0000 },
  { 5417, 0x4000 }, { 5418, 0x8002 }, { 5420, 0x4800 }, { 5422, 0x0000 },
  { 5422, 0x0200 }, { 5423, 0x0040 }, { 5424, 0x0110 }, { 5426, 0x0000 },
  /* 0x9c00 */
  { 5426, 0x2000 }, { 5427, 0x0025 }, { 5430, 0x0020 }, { 5431, 0x0804 },
  { 5433, 0x0280 }, { 5435, 0x0080 }, { 5436, 0x0000 }, { 5436, 0x0000 },
  { 5436, 0x0000 }, { 5436, 0x0000 }, { 5436, 0x0000 }, { 5436, 0x0000 },
  { 5436, 0x0000 }, { 5436, 0x0000 }, { 5436, 0x02a0 }, { 5439, 0x0058 },
  /* 0x9d00 */
  { 5442, 0x0200 }, { 5443, 0x0800 }, { 5444, 0x0140 }, { 5446, 0x0800 },
  { 5447, 0x0000 }, { 5447, 0x2002 }, { 5449, 0x1003 }, { 5452, 0x0004 },
  { 5453, 0x0000 }, { 5453, 0x0000 }, { 5453, 0x8200 }, { 5455, 0x0010 },
  { 5456, 0x0010 }, { 5457, 0x0080 }, { 5458, 0x0000 }, { 5458, 0x0704 },
  /* 0x9e00 */
  { 5462, 0x0000 }, { 5462, 0x4400 }, { 5464, 0x0000 }, { 5464, 0x0000 },
  { 5464, 0x0000 }, { 5464, 0x0000 }, { 5464, 0x0000 }, { 5464, 0xa220 },
  { 5468, 0x0000 }, { 5468, 0xa08c }, { 5473, 0x0020 }, { 5474, 0x4830 },
  { 5478, 0x6008 }, { 5481, 0x5912 }, { 5487, 0x0100 }, { 5488, 0x0010 },
  /* 0x9f00 */
  { 5489, 0x4180 }, { 5492, 0x0008 }, { 5493, 0x0001 }, { 5494, 0x0800 },
  { 5495, 0x4c00 }, { 5498, 0x8004 }, { 5500, 0x1482 }, { 5504, 0x0080 },
  { 5505, 0x2000 }, { 5506, 0x1021 }
};

static const aciConvSummary16 ksc5601_uni2indx_pageac[ /*698*/ ] = {
  /* 0xac00 */
  { 5509, 0x0793 }, { 5516, 0x3eff }, { 5529, 0xb011 }, { 5534, 0x1303 },
  { 5539, 0x2801 }, { 5542, 0x1110 }, { 5545, 0x0000 }, { 5545, 0x0593 },
  { 5551, 0x1e7b }, { 5561, 0xb011 }, { 5566, 0x9703 }, { 5573, 0x3b01 },
  { 5579, 0x1112 }, { 5583, 0x00a0 }, { 5585, 0x9593 }, { 5593, 0x306b },
  /* 0xad00 */
  { 5600, 0xb051 }, { 5606, 0x1102 }, { 5609, 0x3201 }, { 5613, 0x1130 },
  { 5617, 0x02b0 }, { 5621, 0x0111 }, { 5624, 0x300a }, { 5628, 0xb879 },
  { 5637, 0x1306 }, { 5642, 0x3001 }, { 5645, 0x0010 }, { 5646, 0x0080 },
  { 5647, 0x0113 }, { 5651, 0x100b }, { 5655, 0x0011 }, { 5657, 0x9300 },
  /* 0xae00 */
  { 5661, 0x2b03 }, { 5667, 0x0010 }, { 5668, 0x0000 }, { 5668, 0x0593 },
  { 5674, 0x746b }, { 5683, 0xb051 }, { 5689, 0x1323 }, { 5695, 0x3b01 },
  { 5701, 0x1030 }, { 5704, 0x0000 }, { 5704, 0x0000 }, { 5704, 0x7000 },
  { 5707, 0xb011 }, { 5712, 0x1303 }, { 5717, 0x2900 }, { 5720, 0x1110 },
  /* 0xaf00 */
  { 5723, 0x2180 }, { 5726, 0x0001 }, { 5727, 0x3000 }, { 5729, 0xb015 },
  { 5735, 0x030e }, { 5740, 0x3001 }, { 5743, 0x0030 }, { 5745, 0x0200 },
  { 5746, 0x0111 }, { 5749, 0x1023 }, { 5753, 0x0000 }, { 5753, 0x1300 },
  { 5756, 0x6b81 }, { 5763, 0x1010 }, { 5765, 0x0300 }, { 5767, 0x0113 },
  /* 0xb000 */
  { 5771, 0x1013 }, { 5775, 0x3011 }, { 5779, 0x0100 }, { 5780, 0x0000 },
  { 5780, 0x5530 }, { 5786, 0x22b8 }, { 5792, 0x0000 }, { 5792, 0x3000 },
  { 5794, 0xb011 }, { 5799, 0x9702 }, { 5805, 0xfb07 }, { 5815, 0x113a },
  { 5821, 0x03b0 }, { 5826, 0x0113 }, { 5830, 0x0021 }, { 5832, 0x0000 },
  /* 0xb100 */
  { 5832, 0x1b00 }, { 5836, 0x3b0d }, { 5844, 0x1138 }, { 5849, 0x03b0 },
  { 5854, 0x0113 }, { 5858, 0x1133 }, { 5864, 0x0001 }, { 5865, 0x1300 },
  { 5868, 0x2b05 }, { 5874, 0x111c }, { 5879, 0x0100 }, { 5880, 0x0000 },
  { 5880, 0x1000 }, { 5881, 0xb011 }, { 5886, 0x1300 }, { 5889, 0x2a01 },
  /* 0xb200 */
  { 5893, 0x1930 }, { 5898, 0x02b0 }, { 5902, 0x0001 }, { 5903, 0x1010 },
  { 5905, 0x0000 }, { 5905, 0x1100 }, { 5907, 0x0301 }, { 5910, 0x1030 },
  { 5913, 0x0230 }, { 5916, 0x0713 }, { 5922, 0x146b }, { 5929, 0x0011 },
  { 5931, 0x1300 }, { 5934, 0x2b05 }, { 5940, 0xf974 }, { 5950, 0x8fb8 },
  /* 0xb300 */
  { 5959, 0x0113 }, { 5963, 0x103b }, { 5969, 0x0000 }, { 5969, 0x0000 },
  { 5969, 0x0000 }, { 5969, 0xd970 }, { 5977, 0x4ab0 }, { 5983, 0x0113 },
  { 5987, 0x103b }, { 5993, 0x0011 }, { 5995, 0x1103 }, { 5999, 0x0000 },
  { 5999, 0x5930 }, { 6005, 0x2ab1 }, { 6012, 0x0111 }, { 6015, 0x1000 },
  /* 0xb400 */
  { 6016, 0x0000 }, { 6016, 0x1101 }, { 6019, 0x0b01 }, { 6023, 0x0010 },
  { 6024, 0x0000 }, { 6024, 0x0113 }, { 6028, 0x102b }, { 6033, 0x0000 },
  { 6033, 0x0101 }, { 6035, 0x2000 }, { 6036, 0x1110 }, { 6039, 0x02a0 },
  { 6042, 0x0111 }, { 6045, 0x3021 }, { 6049, 0xb059 }, { 6056, 0x0102 },
  /* 0xb500 */
  { 6058, 0x0000 }, { 6058, 0x1930 }, { 6063, 0x07b0 }, { 6069, 0x0113 },
  { 6073, 0x383b }, { 6081, 0xb011 }, { 6086, 0x0003 }, { 6088, 0x0000 },
  { 6088, 0x0000 }, { 6088, 0x0000 }, { 6088, 0x0d13 }, { 6094, 0x383b },
  { 6102, 0xb011 }, { 6107, 0x0103 }, { 6110, 0x1000 }, { 6111, 0x0000 },
  /* 0xb600 */
  { 6111, 0x0000 }, { 6111, 0x0113 }, { 6115, 0x1020 }, { 6117, 0x0010 },
  { 6118, 0x0100 }, { 6119, 0x0000 }, { 6119, 0x0110 }, { 6121, 0x0000 },
  { 6121, 0x0000 }, { 6121, 0x3000 }, { 6123, 0x1811 }, { 6127, 0x0002 },
  { 6128, 0x0000 }, { 6128, 0x0010 }, { 6129, 0x0000 }, { 6129, 0x0111 },
  /* 0xb700 */
  { 6132, 0x0023 }, { 6135, 0x0000 }, { 6135, 0x9300 }, { 6139, 0x0b01 },
  { 6143, 0x1110 }, { 6146, 0x0030 }, { 6148, 0x0111 }, { 6151, 0x302b },
  { 6157, 0xb011 }, { 6162, 0x13c7 }, { 6170, 0x3b01 }, { 6176, 0x0130 },
  { 6179, 0x0280 }, { 6181, 0x0000 }, { 6181, 0x3000 }, { 6183, 0xb011 },
  /* 0xb800 */
  { 6188, 0x1383 }, { 6194, 0x2b01 }, { 6199, 0x1130 }, { 6203, 0x03b0 },
  { 6208, 0x0011 }, { 6210, 0x300a }, { 6214, 0xb011 }, { 6219, 0x1102 },
  { 6222, 0x2000 }, { 6223, 0x0000 }, { 6223, 0x0100 }, { 6224, 0x0111 },
  { 6227, 0x102b }, { 6232, 0xa011 }, { 6236, 0x1302 }, { 6240, 0x2b01 },
  /* 0xb900 */
  { 6245, 0x0010 }, { 6246, 0x0100 }, { 6247, 0x0001 }, { 6248, 0x3000 },
  { 6250, 0x9011 }, { 6254, 0x1302 }, { 6258, 0x2b01 }, { 6263, 0x1130 },
  { 6267, 0x66b0 }, { 6274, 0x0000 }, { 6274, 0x3000 }, { 6276, 0xb011 },
  { 6281, 0xd302 }, { 6287, 0x6b07 }, { 6295, 0x113a }, { 6301, 0x07b0 },
  /* 0xba00 */
  { 6307, 0x0103 }, { 6310, 0x0020 }, { 6311, 0x0000 }, { 6311, 0x1300 },
  { 6314, 0x6b05 }, { 6321, 0x1138 }, { 6326, 0x03b0 }, { 6331, 0x0113 },
  { 6335, 0x10b8 }, { 6340, 0x0000 }, { 6340, 0x1b00 }, { 6344, 0x2b05 },
  { 6350, 0x0110 }, { 6352, 0x0300 }, { 6354, 0x0000 }, { 6354, 0x1000 },
  /* 0xbb00 */
  { 6355, 0xa011 }, { 6359, 0x1102 }, { 6362, 0x0a01 }, { 6365, 0x7970 },
  { 6373, 0xa2b0 }, { 6379, 0x0111 }, { 6382, 0x100a }, { 6385, 0x0000 },
  { 6385, 0x1100 }, { 6387, 0x0001 }, { 6388, 0x1110 }, { 6391, 0x0090 },
  { 6393, 0x0111 }, { 6396, 0x0009 }, { 6398, 0x0000 }, { 6398, 0x9300 },
  /* 0xbc00 */
  { 6402, 0xbb05 }, { 6410, 0xf9f2 }, { 6421, 0x22b0 }, { 6426, 0x0113 },
  { 6430, 0x323b }, { 6438, 0x2001 }, { 6440, 0x0000 }, { 6440, 0x0000 },
  { 6440, 0x5930 }, { 6446, 0x06b0 }, { 6451, 0x0193 }, { 6456, 0x303b },
  { 6463, 0xa011 }, { 6467, 0x1123 }, { 6472, 0x0000 }, { 6472, 0x1170 },
  /* 0xbd00 */
  { 6477, 0x02b0 }, { 6481, 0x0011 }, { 6483, 0x1010 }, { 6485, 0x0000 },
  { 6485, 0x1301 }, { 6489, 0x0301 }, { 6492, 0x0110 }, { 6494, 0x0000 },
  { 6494, 0x0793 }, { 6501, 0x162b }, { 6508, 0x0010 }, { 6509, 0x0101 },
  { 6511, 0x0000 }, { 6511, 0x1130 }, { 6515, 0x0200 }, { 6516, 0x0111 },
  /* 0xbe00 */
  { 6519, 0x3029 }, { 6524, 0xb011 }, { 6529, 0x0000 }, { 6529, 0x0000 },
  { 6529, 0x5130 }, { 6534, 0x0eb0 }, { 6540, 0x0513 }, { 6545, 0x383b },
  { 6553, 0xb011 }, { 6558, 0x0303 }, { 6562, 0x0100 }, { 6563, 0x0000 },
  { 6563, 0x0000 }, { 6563, 0x0193 }, { 6568, 0x1039 }, { 6573, 0x0000 },
  /* 0xbf00 */
  { 6573, 0x0302 }, { 6576, 0x3b00 }, { 6581, 0x0000 }, { 6581, 0x0000 },
  { 6581, 0x0113 }, { 6585, 0x0023 }, { 6588, 0x0000 }, { 6588, 0x0000 },
  { 6588, 0x0000 }, { 6588, 0x0010 }, { 6589, 0x0000 }, { 6589, 0x0001 },
  { 6590, 0x3020 }, { 6593, 0x9011 }, { 6597, 0x0002 }, { 6598, 0x0000 },
  /* 0xc000 */
  { 6598, 0x0000 }, { 6598, 0x0000 }, { 6598, 0x0000 }, { 6598, 0x1000 },
  { 6599, 0x0000 }, { 6599, 0x1102 }, { 6602, 0x0301 }, { 6605, 0x0000 },
  { 6605, 0x0000 }, { 6605, 0x0113 }, { 6609, 0xb02b }, { 6616, 0xb079 },
  { 6624, 0x1323 }, { 6630, 0x3b01 }, { 6636, 0x1130 }, { 6640, 0x02b0 },
  /* 0xc100 */
  { 6644, 0x0111 }, { 6647, 0xf021 }, { 6653, 0xb0d9 }, { 6661, 0x1343 },
  { 6667, 0x3b01 }, { 6673, 0x1130 }, { 6677, 0x03b0 }, { 6682, 0x0111 },
  { 6685, 0x7020 }, { 6689, 0xb051 }, { 6695, 0x1322 }, { 6700, 0x2001 },
  { 6702, 0x1110 }, { 6705, 0x0190 }, { 6708, 0x0111 }, { 6711, 0x300b },
  /* 0xc200 */
  { 6716, 0xb011 }, { 6721, 0x9302 }, { 6726, 0xab01 }, { 6732, 0x0016 },
  { 6735, 0x0100 }, { 6736, 0x0113 }, { 6740, 0x3021 }, { 6744, 0xb011 },
  { 6749, 0x0302 }, { 6752, 0x2901 }, { 6756, 0x3130 }, { 6761, 0x02b0 },
  { 6765, 0x0000 }, { 6765, 0x3000 }, { 6767, 0xb819 }, { 6774, 0x1b42 },
  /* 0xc300 */
  { 6780, 0x3301 }, { 6785, 0x1138 }, { 6790, 0x0330 }, { 6794, 0x0000 },
  { 6794, 0x0020 }, { 6795, 0x0000 }, { 6795, 0x1300 }, { 6798, 0x3305 },
  { 6804, 0x1110 }, { 6807, 0x0000 }, { 6807, 0x0000 }, { 6807, 0x0000 },
  { 6807, 0x0001 }, { 6808, 0x9300 }, { 6812, 0x2305 }, { 6817, 0x0130 },
  /* 0xc400 */
  { 6820, 0x0100 }, { 6821, 0x0001 }, { 6822, 0x1010 }, { 6824, 0x3011 },
  { 6828, 0x0100 }, { 6829, 0x0000 }, { 6829, 0x1130 }, { 6833, 0x0230 },
  { 6836, 0x0001 }, { 6837, 0x1010 }, { 6839, 0x0000 }, { 6839, 0x1100 },
  { 6841, 0x0000 }, { 6841, 0x0000 }, { 6841, 0x0200 }, { 6842, 0x8513 },
  /* 0xc500 */
  { 6848, 0x1003 }, { 6851, 0x1011 }, { 6854, 0x1300 }, { 6857, 0x2b01 },
  { 6862, 0x7730 }, { 6870, 0x63b8 }, { 6878, 0x0113 }, { 6882, 0x303b },
  { 6889, 0xb091 }, { 6895, 0x11a2 }, { 6900, 0x0201 }, { 6902, 0x7b30 },
  { 6910, 0x57f0 }, { 6919, 0x0113 }, { 6923, 0x702b }, { 6930, 0xf0d1 },
  /* 0xc600 */
  { 6938, 0x11e3 }, { 6945, 0x1b01 }, { 6950, 0x7130 }, { 6956, 0x0ab9 },
  { 6963, 0x0113 }, { 6967, 0x303b }, { 6974, 0x9001 }, { 6977, 0x1302 },
  { 6981, 0x2b01 }, { 6986, 0x1130 }, { 6990, 0x02b0 }, { 6994, 0x0713 },
  { 7000, 0x302b }, { 7006, 0x3011 }, { 7010, 0x1303 }, { 7015, 0x2301 },
  /* 0xc700 */
  { 7019, 0x1130 }, { 7023, 0x02b0 }, { 7027, 0x0113 }, { 7031, 0x30ab },
  { 7038, 0xb411 }, { 7044, 0x11fe }, { 7053, 0x0901 }, { 7056, 0x7130 },
  { 7062, 0x47b8 }, { 7070, 0x05d3 }, { 7077, 0x307b }, { 7085, 0xb011 },
  { 7090, 0x5303 }, { 7096, 0x2101 }, { 7099, 0x1110 }, { 7102, 0x0000 },
  /* 0xc800 */
  { 7102, 0x0513 }, { 7107, 0x306b }, { 7114, 0xb011 }, { 7119, 0x1102 },
  { 7122, 0x3301 }, { 7127, 0x0010 }, { 7128, 0x0000 }, { 7128, 0x0513 },
  { 7133, 0x38eb }, { 7142, 0xa010 }, { 7145, 0x0102 }, { 7147, 0x3000 },
  { 7149, 0x1110 }, { 7152, 0x02b0 }, { 7156, 0x0013 }, { 7159, 0x3020 },
  /* 0xc900 */
  { 7162, 0xb071 }, { 7169, 0x0102 }, { 7171, 0x1000 }, { 7172, 0x0010 },
  { 7173, 0x0000 }, { 7173, 0x0113 }, { 7177, 0x100b }, { 7181, 0x1011 },
  { 7184, 0x1300 }, { 7187, 0x2b01 }, { 7192, 0x0000 }, { 7192, 0x0000 },
  { 7192, 0x0593 }, { 7198, 0x366b }, { 7207, 0xb095 }, { 7214, 0x1303 },
  /* 0xca00 */
  { 7219, 0x3b01 }, { 7225, 0x0110 }, { 7227, 0x0200 }, { 7228, 0x0000 },
  { 7228, 0x3000 }, { 7230, 0xb011 }, { 7235, 0x0103 }, { 7238, 0x2000 },
  { 7239, 0x0010 }, { 7240, 0x0100 }, { 7241, 0x0000 }, { 7241, 0x3000 },
  { 7243, 0xb011 }, { 7248, 0x030a }, { 7252, 0x1001 }, { 7254, 0x0010 },
  /* 0xcb00 */
  { 7255, 0x0100 }, { 7256, 0x0111 }, { 7259, 0x0003 }, { 7261, 0x0000 },
  { 7261, 0x1302 }, { 7265, 0x2301 }, { 7269, 0x0010 }, { 7270, 0x0300 },
  { 7272, 0x0000 }, { 7272, 0x1000 }, { 7273, 0x0000 }, { 7273, 0x0100 },
  { 7274, 0x0000 }, { 7274, 0x0010 }, { 7275, 0x0290 }, { 7278, 0x0000 },
  /* 0xcc00 */
  { 7278, 0x3000 }, { 7280, 0x3011 }, { 7284, 0x5386 }, { 7291, 0x7b01 },
  { 7298, 0x1130 }, { 7302, 0x03b0 }, { 7307, 0x0151 }, { 7311, 0x0021 },
  { 7313, 0x0000 }, { 7313, 0x1300 }, { 7316, 0x3b01 }, { 7322, 0x1130 },
  { 7326, 0x02b0 }, { 7330, 0x0011 }, { 7332, 0x1010 }, { 7334, 0x0001 },
  /* 0xcd00 */
  { 7335, 0x1302 }, { 7339, 0x2b01 }, { 7344, 0x1110 }, { 7347, 0x0200 },
  { 7348, 0x0000 }, { 7348, 0x1000 }, { 7349, 0xb011 }, { 7354, 0x0102 },
  { 7356, 0x0100 }, { 7357, 0x1130 }, { 7361, 0x02b0 }, { 7365, 0x0001 },
  { 7366, 0x1010 }, { 7368, 0x0001 }, { 7369, 0x1100 }, { 7371, 0x2b01 },
  /* 0xce00 */
  { 7376, 0x1110 }, { 7379, 0x0210 }, { 7381, 0x0113 }, { 7385, 0x002b },
  { 7389, 0x0000 }, { 7389, 0x9300 }, { 7393, 0x2b03 }, { 7399, 0x1130 },
  { 7403, 0x02b0 }, { 7407, 0x0113 }, { 7411, 0x303b }, { 7418, 0x0000 },
  { 7418, 0x0002 }, { 7419, 0x0000 }, { 7419, 0x1930 }, { 7424, 0x03b0 },
  /* 0xcf00 */
  { 7429, 0x0113 }, { 7433, 0x102b }, { 7438, 0xb011 }, { 7443, 0x0103 },
  { 7446, 0x0000 }, { 7446, 0x1130 }, { 7450, 0x02b0 }, { 7454, 0x0113 },
  { 7458, 0x1021 }, { 7461, 0x0000 }, { 7461, 0x0102 }, { 7463, 0x0001 },
  { 7464, 0x0010 }, { 7465, 0x0000 }, { 7465, 0x0113 }, { 7469, 0x102b },
  /* 0xd000 */
  { 7474, 0x0011 }, { 7476, 0x0102 }, { 7478, 0x2000 }, { 7479, 0x1130 },
  { 7483, 0x02b0 }, { 7487, 0x0111 }, { 7490, 0x3001 }, { 7493, 0x3011 },
  { 7497, 0x0002 }, { 7498, 0x0000 }, { 7498, 0x1130 }, { 7502, 0x02b0 },
  { 7506, 0x0313 }, { 7511, 0x303b }, { 7518, 0xb011 }, { 7523, 0x0103 },
  /* 0xd100 */
  { 7526, 0x2000 }, { 7527, 0x0000 }, { 7527, 0x0000 }, { 7527, 0x0513 },
  { 7532, 0x303b }, { 7539, 0xb011 }, { 7544, 0x1102 }, { 7547, 0x1000 },
  { 7548, 0x0110 }, { 7550, 0x0000 }, { 7550, 0x0113 }, { 7554, 0x142b },
  { 7560, 0x0001 }, { 7561, 0x0100 }, { 7562, 0x0000 }, { 7562, 0x0110 },
  /* 0xd200 */
  { 7564, 0x0280 }, { 7566, 0x0001 }, { 7567, 0x3000 }, { 7569, 0xb011 },
  { 7574, 0x0102 }, { 7576, 0x1000 }, { 7577, 0x0010 }, { 7578, 0x0000 },
  { 7578, 0x0113 }, { 7582, 0x1023 }, { 7586, 0x1011 }, { 7589, 0x9302 },
  { 7594, 0x0b05 }, { 7599, 0x1110 }, { 7602, 0x0030 }, { 7604, 0x0113 },
  /* 0xd300 */
  { 7608, 0x702b }, { 7615, 0xb051 }, { 7621, 0x1323 }, { 7627, 0x3b01 },
  { 7633, 0x0030 }, { 7635, 0x0000 }, { 7635, 0x0000 }, { 7635, 0x3000 },
  { 7637, 0xb011 }, { 7642, 0x1303 }, { 7647, 0x2b01 }, { 7652, 0x1110 },
  { 7655, 0x0330 }, { 7659, 0x0101 }, { 7661, 0x300a }, { 7665, 0xb011 },
  /* 0xd400 */
  { 7670, 0x0102 }, { 7672, 0x2000 }, { 7673, 0x0000 }, { 7673, 0x0000 },
  { 7673, 0x0011 }, { 7675, 0x1000 }, { 7676, 0xa011 }, { 7680, 0x9300 },
  { 7684, 0x2b05 }, { 7690, 0x0010 }, { 7691, 0x0200 }, { 7692, 0x0000 },
  { 7692, 0x1000 }, { 7693, 0x9011 }, { 7697, 0x1100 }, { 7699, 0x2901 },
  /* 0xd500 */
  { 7703, 0x1110 }, { 7706, 0x00b0 }, { 7709, 0x0000 }, { 7709, 0x3000 },
  { 7711, 0xb011 }, { 7716, 0x1302 }, { 7720, 0x2b21 }, { 7726, 0x1130 },
  { 7730, 0x03b0 }, { 7735, 0x0001 }, { 7736, 0x0020 }, { 7737, 0x0000 },
  { 7737, 0x1300 }, { 7740, 0x2b05 }, { 7746, 0x1130 }, { 7750, 0x02b0 },
  /* 0xd600 */
  { 7754, 0x0113 }, { 7758, 0x103b }, { 7764, 0x2011 }, { 7767, 0x1300 },
  { 7770, 0x2b21 }, { 7776, 0x1132 }, { 7781, 0x0280 }, { 7783, 0x0013 },
  { 7786, 0x3028 }, { 7790, 0xa011 }, { 7794, 0x1102 }, { 7797, 0x0a01 },
  { 7800, 0x1130 }, { 7804, 0x0292 }, { 7808, 0x0111 }, { 7811, 0x3021 },
  /* 0xd700 */
  { 7815, 0x0011 }, { 7817, 0x1302 }, { 7821, 0x2b01 }, { 7826, 0x1130 },
  { 7830, 0x0290 }, { 7833, 0x03d3 }, { 7840, 0x122b }, { 7846, 0x3011 },
  { 7850, 0x1302 }, { 7854, 0x2b01 }
};

static const aciConvSummary16 ksc5601_uni2indx_pagef9[ /*17*/ ] = {
  /* 0xf900 */
  { 7859, 0xffff }, { 7875, 0xffff }, { 7891, 0xffff }, { 7907, 0xffff },
  { 7923, 0xffff }, { 7939, 0xffff }, { 7955, 0xffff }, { 7971, 0xffff },
  { 7987, 0xffff }, { 8003, 0xffff }, { 8019, 0xffff }, { 8035, 0xffff },
  { 8051, 0xffff }, { 8067, 0xffff }, { 8083, 0xffff }, { 8099, 0xffff },
  /* 0xfa00 */
  { 8115, 0x0fff }
};

static const aciConvSummary16 ksc5601_uni2indx_pageff[ /*15*/ ] = {
  /* 0xff00 */
  { 8127, 0xfffe }, { 8142, 0xffff }, { 8158, 0xffff }, { 8174, 0xffff },
  { 8190, 0xffff }, { 8206, 0x7fff }, { 8221, 0x0000 }, { 8221, 0x0000 },
  { 8221, 0x0000 }, { 8221, 0x0000 }, { 8221, 0x0000 }, { 8221, 0x0000 },
  { 8221, 0x0000 }, { 8221, 0x0000 }, { 8221, 0x006f }
};

ACP_EXPORT acp_sint32_t aciConvConvertMbToWc4Ksc5601( void    * aSrc,
                                                      acp_sint32_t      aSrcRemain,
                                                      acp_sint32_t    * aSrcAdvance,
                                                      void    * aDest,
                                                      acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      KSC5601 ==> UTF16
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t   * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint32_t      i;
    acp_uint16_t    wc;
    acp_sint32_t      sRet;

    aDestRemain = 0;

    if ( (sSrcCharPtr[0] >= 0x21 && sSrcCharPtr[0] <= 0x2c) ||
         (sSrcCharPtr[0] >= 0x30 && sSrcCharPtr[0] <= 0x48) ||
         (sSrcCharPtr[0] >= 0x4a && sSrcCharPtr[0] <= 0x7d) )
    {
        if (aSrcRemain >= 2)
        {
            if (sSrcCharPtr[1] >= 0x21 && sSrcCharPtr[1] < 0x7f)
            {
                i = 94 * (sSrcCharPtr[0] - 0x21) + (sSrcCharPtr[1] - 0x21);
                wc = 0xfffd;

                if (i < 1410)
                {
                    if (i < 1115)
                    {
                        wc = ksc5601_2uni_page21[i] ^ KSC5601_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else if (i < 3854)
                {
                    if (i < 3760)
                    {
                        wc = ksc5601_2uni_page30[i-1410] ^ KSC5601_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else
                {
                    if (i < 8742)
                    {
                        wc = ksc5601_2uni_page4a[i-3854] ^ KSC5601_XOR_VALUE;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }

                if (wc != 0xfffd) 
                {
                    ACICONV_WC_TO_UTF16BE( aDest, wc );
                    
                    sRet = 2;
                    *aSrcAdvance = 2;
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILSEQ;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_TOOFEW;
            *aSrcAdvance = aSrcRemain;
        }
    }
    else
    {
        sRet = ACICONV_RET_ILSEQ;
        *aSrcAdvance = 1;
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvConvertWcToMb4Ksc5601( void    * aSrc,
                                                      acp_sint32_t      aSrcRemain,
                                                      acp_sint32_t    * aSrcAdvance,
                                                      void    * aDest,
                                                      acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      UTF16 ==> KSC5601
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16   * sSummary = NULL;
    acp_uint16_t              sUsed;
    acp_uint8_t             * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_sint32_t                sRet;
    acp_uint16_t              c;
    acp_uint32_t                i;
    acp_uint16_t              wc;

    aSrcRemain = 0;

    ACICONV_UTF16BE_TO_WC( wc, aSrc );
    
    if (aDestRemain >= 2)
    {
        if( wc < 0x0460 )
        {
            sSummary = &ksc5601_uni2indx_page00[(wc>>4)];
        }
        else if( (wc >= 0x2000) && (wc < 0x2670) )
        {
            sSummary = &ksc5601_uni2indx_page20[(wc>>4)-0x200];
        }
        else if( (wc >= 0x3000) && (wc < 0x33e0) )
        {
            sSummary = &ksc5601_uni2indx_page30[(wc>>4)-0x300];
        }
        else if( (wc >= 0x4e00) && (wc < 0x9fa0) )
        {
            sSummary = &ksc5601_uni2indx_page4e[(wc>>4)-0x4e0];
        }
        else if( (wc >= 0xac00) && (wc < 0xd7a0) )
        {
            sSummary = &ksc5601_uni2indx_pageac[(wc>>4)-0xac0];
        }
        else if( (wc >= 0xf900) && (wc < 0xfa10) )
        {
            sSummary = &ksc5601_uni2indx_pagef9[(wc>>4)-0xf90];
        }
        else if( (wc >= 0xff00) && (wc < 0xfff0) )
        {
            sSummary = &ksc5601_uni2indx_pageff[(wc>>4)-0xff0];
        }
        else
        {
            /* Nothing to do */
        }

        if( sSummary != NULL )
        {
            sUsed = sSummary->used;

            i = wc & 0x0f;

            if( sUsed & ((acp_uint16_t) 1 << i) )
            {
                /* Keep in `sUsed' only the bits 0..i-1. */
                sUsed &= ((acp_uint16_t) 1 << i) - 1;

                /*Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                sUsed = (sUsed & 0x00ff) + (sUsed >> 8);

                c = ksc5601_2charset[sSummary->indx + sUsed] ^ KSC5601_XOR_VALUE;

                sDestCharPtr[0] = (c >> 8); 
                sDestCharPtr[1] = (c & 0xff);

                sRet = 2;
                *aSrcAdvance = 2;
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_ILUNI;
            *aSrcAdvance = 2;
        }
    }
    else
    {
        sRet = ACICONV_RET_TOOSMALL;
        *aSrcAdvance = 2;
    }

    return sRet;
}

 
