/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvUhc1.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvUhc1.h>

static const acp_uint16_t uhc_1_2uni_main_page81[ /*64*/ ] = {
  0xac1f, 0xac90, 0xad09, 0xad8c, 0xade7, 0xae67, 0xaefb, 0xaf4a,
  0xafa2, 0xb02d, 0xb0b8, 0xb13f, 0xb183, 0xb21a, 0xb272, 0xb2ed,
  0xb37b, 0xb3fc, 0xb458, 0xb4b0, 0xb503, 0xb58d, 0xb61d, 0xb67c,
  0xb6de, 0xb73e, 0xb782, 0xb80c, 0xb898, 0xb8ec, 0xb947, 0xb9c9,
  0xba5a, 0xbadf, 0xbb35, 0xbb87, 0xbc1e, 0xbc9d, 0xbce3, 0xbd7a,
  0xbdcf, 0xbe20, 0xbea5, 0xbf3e, 0xbf9e, 0xbffb, 0xc05d, 0xc0ba,
  0xc12f, 0xc1ac, 0xc239, 0xc28a, 0xc30d, 0xc367, 0xc3c6, 0xc45b,
  0xc4b7, 0xc512, 0xc58b, 0xc63b, 0xc6b5, 0xc73b, 0xc7a5, 0xc82f
};

static const acp_uint8_t uhc_1_2uni_page81[ /*5696*/ ] = {
  /* 0x81 */
  0x1d, 0x1c, 0x1e, 0x19, 0x14, 0x17, 0x16, 0x11,
  0x10, 0x0b, 0x01, 0x00, 0x02, 0x3d, 0x3c, 0x3e,
  0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x31, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x25, 0x24, 0x26,
  0x21, 0x20, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59,
  0x58, 0x5b, 0x5a, 0x55, 0x57, 0x51, 0x50, 0x53,
  0x52, 0x4d, 0x4c, 0x4e, 0x49, 0x48, 0x4a, 0x45,
  0x44, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x6d, 0x6c, 0x6e, 0x69,
  0x6a, 0x64, 0x67, 0x66, 0x61, 0x60, 0x9d, 0x98,
  0x9b, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x0c, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x03, 0x3d, 0x3c,
  0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x30,
  0x2c, 0x2f, 0x2e, 0x28, 0x2b, 0x25, 0x24, 0x27,
  0x21, 0x20, 0x23, 0x5d, 0x5c, 0x5f, 0x5e, 0x59,
  0x58, 0x5b, 0x5a, 0x54, 0x56, 0x51, 0x50, 0x53,
  0x52, 0x4d, 0x4c, 0x4f, 0x48, 0x4b, 0x45, 0x44,
  0x41, 0x43, 0x7d, 0x7c, 0x78, 0x7a, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x6c, 0x6f, 0x69, 0x68, 0x6b,
  0x65, 0x67, 0x66, 0x61, 0x60, 0x63, 0x9c, 0x9e,
  0x98, 0x9b,
  /* 0x82 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x18, 0x1b, 0x1a, 0x14,
  0x17, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x0b, 0x0a, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3f, 0x3e, 0x38, 0x3b, 0x3a, 0x34,
  0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2f, 0x29,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x20, 0x23,
  0x22, 0x5c, 0x5f, 0x5e, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x53, 0x4d, 0x4c, 0x4f,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x47, 0x46, 0x40,
  0x43, 0x7e, 0x79, 0x78, 0x7b, 0x77, 0x71, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x6b, 0x6a, 0x64, 0x67,
  0x66, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x30, 0x33, 0x2c, 0x2f, 0x29, 0x28,
  0x2b, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23,
  0x5c, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x51, 0x50, 0x53, 0x4d, 0x4c, 0x4f, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41,
  0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79,
  0x78, 0x7b,
  /* 0x83 */
  0x1d, 0x1c, 0x1e, 0x19, 0x15, 0x14, 0x17, 0x16,
  0x11, 0x10, 0x0d, 0x0f, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x25, 0x24, 0x26,
  0x21, 0x22, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x55,
  0x57, 0x50, 0x53, 0x52, 0x4c, 0x48, 0x4a, 0x45,
  0x44, 0x46, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x79,
  0x75, 0x74, 0x77, 0x71, 0x70, 0x6d, 0x6c, 0x6e,
  0x69, 0x68, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61,
  0x60, 0x1d, 0x19, 0x18, 0x1b, 0x1a, 0x15, 0x14,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0e, 0x09,
  0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39,
  0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29,
  0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21,
  0x20, 0x23, 0x22, 0x5d, 0x5c, 0x58, 0x5a, 0x55,
  0x54, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x49, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x7d,
  0x7c, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76,
  /* 0x84 */
  0x1d, 0x1c, 0x1e, 0x19, 0x1b, 0x15, 0x14, 0x17,
  0x16, 0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0e, 0x09,
  0x08, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3e, 0x39, 0x38, 0x3b, 0x35,
  0x34, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5f, 0x5e, 0x59, 0x58, 0x55, 0x54, 0x56, 0x50,
  0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x45,
  0x47, 0x43, 0x42, 0x7d, 0x7c, 0x79, 0x78, 0x7b,
  0x7a, 0x75, 0x74, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07,
  0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3e,
  0x39, 0x38, 0x3b, 0x3a, 0x35, 0x37, 0x36, 0x31,
  0x33, 0x32, 0x2d, 0x2f, 0x2e, 0x29, 0x28, 0x2b,
  0x2a, 0x25, 0x26, 0x21, 0x20, 0x22, 0x5d, 0x5c,
  0x5f, 0x5e, 0x59, 0x5b, 0x5a, 0x55, 0x54, 0x57,
  0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47,
  0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7e, 0x79,
  0x7b, 0x7a,
  /* 0x85 */
  0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a, 0x16,
  0x10, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2e, 0x29,
  0x2b, 0x2a, 0x25, 0x27, 0x26, 0x21, 0x20, 0x23,
  0x22, 0x5d, 0x5e, 0x59, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x56, 0x51, 0x53, 0x52, 0x4d, 0x4f, 0x4e,
  0x49, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41,
  0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b,
  0x7a, 0x75, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x0b, 0x0a, 0x04,
  0x06, 0x00, 0x02, 0x3d, 0x3c, 0x3f, 0x3b, 0x35,
  0x37, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27,
  0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f,
  0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57,
  0x56, 0x53, 0x52, 0x4c, 0x4f, 0x4e, 0x48, 0x4b,
  0x4a, 0x45, 0x44, 0x47, 0x46, 0x43, 0x7d, 0x7f,
  0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x76, 0x70, 0x73,
  0x6e, 0x69,
  /* 0x86 */
  0x1d, 0x1c, 0x1f, 0x18, 0x16, 0x10, 0x0c, 0x0f,
  0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x03, 0x3c, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x30, 0x33, 0x2d, 0x2c, 0x2f, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x21, 0x20, 0x23,
  0x22, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x78, 0x75, 0x74, 0x77, 0x71,
  0x72, 0x6d, 0x6c, 0x6f, 0x68, 0x64, 0x67, 0x66,
  0x61, 0x1d, 0x19, 0x18, 0x1a, 0x15, 0x14, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x09, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x3d, 0x3c, 0x3e,
  0x39, 0x38, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x2d, 0x2c, 0x29, 0x28, 0x2a, 0x25, 0x24,
  0x26, 0x21, 0x20, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x45, 0x44, 0x46, 0x41, 0x40, 0x42,
  0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x75, 0x77, 0x71,
  0x70, 0x73, 0x72, 0x6e, 0x69, 0x68, 0x6a, 0x65,
  0x64, 0x66,
  /* 0x87 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x32, 0x2d, 0x2c,
  0x2e, 0x29, 0x28, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x5d, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x55, 0x54, 0x51, 0x50, 0x52, 0x4d, 0x4c,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47,
  0x41, 0x43, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x75, 0x1d, 0x1f, 0x1e, 0x1b, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x12, 0x0c, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x2b, 0x2a, 0x25,
  0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d,
  0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4f, 0x4e, 0x49, 0x4b, 0x4a, 0x45, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7e, 0x79, 0x78,
  0x7b, 0x7a,
  /* 0x88 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x0a, 0x05, 0x04, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3e, 0x39, 0x3b, 0x3a, 0x35,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2e, 0x28, 0x25,
  0x24, 0x27, 0x21, 0x23, 0x22, 0x5d, 0x5f, 0x5e,
  0x59, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51,
  0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x46, 0x41, 0x43, 0x42,
  0x7d, 0x7f, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x76,
  0x70, 0x72, 0x6d, 0x6c, 0x6f, 0x69, 0x65, 0x67,
  0x66, 0x1d, 0x1c, 0x1f, 0x1b, 0x11, 0x10, 0x13,
  0x0f, 0x0e, 0x08, 0x0b, 0x0a, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3f, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x30, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x7a, 0x74, 0x77, 0x70, 0x6d, 0x6c,
  0x6f, 0x6e,
  /* 0x89 */
  0x1d, 0x1f, 0x19, 0x1b, 0x1a, 0x14, 0x11, 0x10,
  0x12, 0x0d, 0x0c, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x01, 0x3d, 0x3c, 0x3f, 0x3e, 0x39,
  0x38, 0x3a, 0x35, 0x34, 0x36, 0x31, 0x30, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5e, 0x59, 0x58, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x7d, 0x7c, 0x7e, 0x79, 0x7a, 0x74,
  0x76, 0x71, 0x70, 0x6d, 0x6f, 0x69, 0x6b, 0x65,
  0x64, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x30, 0x33, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x25, 0x24, 0x27, 0x21,
  0x20, 0x23, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x54, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4c, 0x4f, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e,
  /* 0x8a */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x10, 0x13, 0x0d, 0x0c, 0x0f,
  0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x00,
  0x02, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25,
  0x24, 0x27, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5f, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57,
  0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x7d, 0x7c, 0x7f, 0x79, 0x78,
  0x7b, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x14, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x01,
  0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x39, 0x38,
  0x3b, 0x3a, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x2c, 0x2f, 0x29, 0x28, 0x25, 0x27, 0x26, 0x21,
  0x20, 0x23, 0x5c, 0x5e, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x74, 0x77, 0x71,
  0x70, 0x6d,
  /* 0x8b */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x15, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x09, 0x08, 0x0a, 0x05,
  0x04, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x39, 0x35, 0x34, 0x37, 0x36, 0x31, 0x2d, 0x2c,
  0x2e, 0x29, 0x28, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x5d, 0x59, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45,
  0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d,
  0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75,
  0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d,
  0x6c, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0f, 0x0e, 0x08, 0x0b, 0x0a, 0x04, 0x01,
  0x00, 0x03, 0x02, 0x3f, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x33, 0x32, 0x2c, 0x2f, 0x2e, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x27, 0x26, 0x23, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x54, 0x57, 0x56, 0x51,
  0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72,
  /* 0x8c */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0f, 0x0e, 0x08, 0x0b, 0x0a, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23,
  0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25,
  0x24, 0x27, 0x20, 0x23, 0x5d, 0x5c, 0x5f, 0x59,
  0x58, 0x5b, 0x5a, 0x55, 0x54, 0x51, 0x50, 0x53,
  0x52, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c,
  /* 0x8d */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2f,
  0x2e, 0x29, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x22, 0x5d, 0x5c, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53,
  0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b,
  0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43,
  0x42, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x15,
  0x17, 0x16, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x0a, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3f, 0x3e, 0x39, 0x3b, 0x3a, 0x35,
  0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x23, 0x22, 0x5d, 0x5f, 0x5e, 0x59, 0x5b,
  0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x52, 0x4c,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x46, 0x41,
  0x43, 0x42, 0x7d, 0x7f, 0x7e, 0x79, 0x78, 0x7b,
  0x7a, 0x75, 0x76, 0x6d, 0x6c, 0x6f, 0x6a, 0x65,
  0x67, 0x66,
  /* 0x8e */
  0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x16, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x0a,
  0x05, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x34,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27,
  0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f,
  0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57,
  0x56, 0x51, 0x52, 0x4d, 0x4f, 0x4e, 0x49, 0x4b,
  0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x42, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x76, 0x71, 0x73, 0x72,
  0x6d, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x14, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x08, 0x0b, 0x05, 0x04, 0x07, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x38, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x2d, 0x2c, 0x2f, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5c, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x50, 0x53, 0x4d, 0x4c, 0x4f,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x40,
  0x42, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x75,
  0x74, 0x77, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e,
  /* 0x8f */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x31, 0x30, 0x33, 0x2d, 0x2c, 0x2f, 0x29,
  0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x20, 0x22,
  0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x55, 0x54,
  0x57, 0x51, 0x50, 0x53, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x44, 0x46, 0x40, 0x43,
  0x42, 0x7d, 0x7c, 0x7f, 0x78, 0x7b, 0x75, 0x74,
  0x77, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x14, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3b, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x33, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x50, 0x53, 0x4d,
  0x4c, 0x4f, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x41, 0x40, 0x42, 0x7c, 0x7f, 0x7e, 0x79,
  0x78, 0x7b,
  /* 0x90 */
  0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x10, 0x0d, 0x0f, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x01, 0x00, 0x02, 0x3d,
  0x3c, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x31, 0x33, 0x2c, 0x2f, 0x28, 0x2b, 0x2a, 0x25,
  0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d,
  0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4c, 0x49, 0x48, 0x4a, 0x45, 0x44, 0x46, 0x41,
  0x40, 0x43, 0x42, 0x7d, 0x7c, 0x79, 0x7b, 0x75,
  0x74, 0x77, 0x76, 0x71, 0x70, 0x6d, 0x6c, 0x6e,
  0x64, 0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x15, 0x16,
  0x11, 0x13, 0x0f, 0x0e, 0x08, 0x0b, 0x0a, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3f, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27,
  0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x7b, 0x7a, 0x74, 0x77, 0x76, 0x70, 0x72, 0x6d,
  0x6c, 0x6f,
  /* 0x91 */
  0x1d, 0x1e, 0x18, 0x15, 0x14, 0x17, 0x16, 0x12,
  0x0d, 0x0f, 0x0e, 0x09, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x02, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27,
  0x26, 0x22, 0x5c, 0x5f, 0x5e, 0x59, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7e, 0x7b, 0x7a, 0x75, 0x77, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6e, 0x68, 0x6a, 0x65, 0x64,
  0x67, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x05, 0x04, 0x07,
  0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x26,
  0x21, 0x20, 0x22, 0x5d, 0x5c, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x51, 0x53, 0x4d,
  0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4a, 0x45, 0x44,
  0x46, 0x41, 0x40, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78,
  /* 0x92 */
  0x1d, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x12, 0x0c, 0x0f, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x03, 0x3d, 0x3f, 0x3e, 0x39, 0x3b,
  0x34, 0x37, 0x36, 0x30, 0x33, 0x32, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x27, 0x21,
  0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7c, 0x7f, 0x7e, 0x78, 0x7b, 0x7a,
  0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d,
  0x6c, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x16, 0x11, 0x10, 0x12, 0x0d,
  0x0c, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x06, 0x01, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3a, 0x35, 0x34, 0x36, 0x31, 0x30,
  0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2a,
  0x25, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d,
  0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45,
  0x44, 0x47, 0x46, 0x41, 0x40, 0x7d, 0x7c, 0x7e,
  0x79, 0x7a,
  /* 0x93 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x16, 0x10,
  0x12, 0x0d, 0x0b, 0x0a, 0x00, 0x03, 0x02, 0x3d,
  0x3e, 0x38, 0x3a, 0x35, 0x34, 0x36, 0x31, 0x32,
  0x2d, 0x2f, 0x2e, 0x29, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x22, 0x5e, 0x59, 0x58, 0x5a,
  0x55, 0x56, 0x51, 0x53, 0x52, 0x4d, 0x4c, 0x4f,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x1a, 0x14,
  0x17, 0x10, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x0b,
  0x05, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3f, 0x3e,
  0x38, 0x3b, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2f, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x23, 0x22, 0x5c, 0x5f, 0x5e, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x53, 0x4f, 0x4e,
  0x49, 0x4b, 0x4a, 0x44, 0x47, 0x46, 0x40, 0x43,
  0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b,
  0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73,
  0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x6a, 0x64, 0x67,
  0x66, 0x60,
  /* 0x94 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x15, 0x17,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0e, 0x09,
  0x08, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55,
  0x54, 0x51, 0x50, 0x52, 0x4d, 0x4c, 0x4e, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x44, 0x41, 0x40, 0x43,
  0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7a,
  0x75, 0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x06, 0x01, 0x03, 0x02, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x36, 0x30, 0x32, 0x2d, 0x2c, 0x29,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x23,
  0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x55, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45,
  0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d,
  0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75,
  0x74, 0x77,
  /* 0x95 */
  0x1d, 0x1c, 0x19, 0x18, 0x1a, 0x15, 0x14, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x02, 0x3d, 0x3c, 0x3e, 0x39, 0x38, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x32, 0x2d,
  0x2f, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x21,
  0x20, 0x22, 0x5d, 0x5c, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x55, 0x54, 0x51, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x14, 0x17, 0x11, 0x10, 0x13, 0x0d, 0x0f, 0x0e,
  0x09, 0x08, 0x0b, 0x04, 0x06, 0x02, 0x3d, 0x3c,
  0x3f, 0x38, 0x3b, 0x35, 0x34, 0x37, 0x31, 0x33,
  0x32, 0x2d, 0x2c, 0x2f, 0x28, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x5c, 0x5f, 0x59, 0x58, 0x5b, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x4c, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x71, 0x70, 0x73, 0x72, 0x6d,
  0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65,
  0x64, 0x67,
  /* 0x96 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x07, 0x06, 0x00, 0x03, 0x3c, 0x3f, 0x3e, 0x39,
  0x38, 0x3b, 0x3a, 0x34, 0x37, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x28, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x57,
  0x56, 0x51, 0x50, 0x53, 0x52, 0x4f, 0x4e, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41,
  0x40, 0x43, 0x42, 0x7f, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x02, 0x3d,
  0x3f, 0x3e, 0x39, 0x3b, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x32, 0x2d, 0x2c, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42,
  /* 0x97 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x56, 0x51,
  0x53, 0x52, 0x4d, 0x4f, 0x4e, 0x49, 0x48, 0x4b,
  0x4a, 0x45, 0x47, 0x46, 0x40, 0x42, 0x7d, 0x7c,
  0x7f, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23,
  0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53,
  0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4a,
  0x45, 0x44,
  /* 0x98 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x04,
  0x07, 0x06, 0x00, 0x03, 0x02, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3b, 0x3a, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4f, 0x4e, 0x48, 0x4b, 0x4a, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7f, 0x79,
  0x7b, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x17,
  0x16, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x0a, 0x06,
  0x01, 0x00, 0x02, 0x3d, 0x3e, 0x39, 0x3b, 0x3a,
  0x35, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2e, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x22,
  0x5d, 0x5f, 0x5e, 0x59, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x56, 0x51, 0x52, 0x4c, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x47, 0x46, 0x41, 0x43, 0x42,
  0x7d, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75,
  0x77, 0x76, 0x71, 0x70, 0x72, 0x6d, 0x6c, 0x6f,
  0x6e, 0x69, 0x67, 0x66, 0x63, 0x9c, 0x9f, 0x9e,
  0x99, 0x9a,
  /* 0x99 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x18, 0x15, 0x14, 0x16,
  0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09,
  0x08, 0x05, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x39, 0x38, 0x3a, 0x35, 0x34, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x29, 0x25, 0x24, 0x27,
  0x26, 0x21, 0x20, 0x22, 0x5d, 0x5c, 0x5e, 0x59,
  0x58, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x49, 0x48, 0x4b,
  0x4a, 0x45, 0x44, 0x40, 0x42, 0x7d, 0x7c, 0x7e,
  0x78, 0x7b, 0x7a, 0x75, 0x74, 0x71, 0x73, 0x6d,
  0x6c, 0x6f, 0x69, 0x68, 0x65, 0x64, 0x66, 0x61,
  0x60, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x09, 0x08, 0x0b, 0x05, 0x04,
  0x07, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x39, 0x38, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x2d, 0x2c, 0x2f, 0x29, 0x28, 0x2b, 0x25,
  0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x5c, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x50,
  0x53, 0x4d, 0x4c, 0x4f, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x40, 0x42, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x74, 0x77, 0x71, 0x70, 0x6d,
  0x6c, 0x6f,
  /* 0x9a */
  0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x15, 0x17, 0x11,
  0x12, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x33, 0x32, 0x2c, 0x2f, 0x2e,
  0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x20,
  0x23, 0x22, 0x5d, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x57, 0x56, 0x50, 0x53, 0x52, 0x4c, 0x4f,
  0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x47, 0x41, 0x43,
  0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x7b, 0x7a, 0x75,
  0x74, 0x77, 0x76, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x1d, 0x1f, 0x1e, 0x18, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x12, 0x0d, 0x0f, 0x0e, 0x09,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x02, 0x3c,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27,
  0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f,
  0x5e, 0x59, 0x5a, 0x55, 0x57, 0x56, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x4a, 0x44, 0x46, 0x41,
  0x40, 0x43, 0x7d, 0x7e, 0x7b, 0x7a, 0x75, 0x77,
  0x76, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6e, 0x69,
  0x6a, 0x65,
  /* 0x9b */
  0x1d, 0x1c, 0x1f, 0x1b, 0x1a, 0x14, 0x17, 0x16,
  0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x0b,
  0x0a, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c,
  0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x47, 0x46,
  0x40, 0x43, 0x42, 0x7c, 0x7e, 0x79, 0x78, 0x7b,
  0x7a, 0x1d, 0x1c, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x16, 0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0e,
  0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51,
  0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49,
  0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41,
  0x40, 0x7d,
  /* 0x9c */
  0x1d, 0x1f, 0x1e, 0x1b, 0x15, 0x14, 0x17, 0x16,
  0x11, 0x12, 0x0d, 0x0c, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x06, 0x01, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x57, 0x56, 0x51,
  0x50, 0x53, 0x52, 0x4d, 0x4f, 0x4e, 0x49, 0x4b,
  0x4a, 0x45, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x3d, 0x3c,
  0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x2d, 0x2c, 0x2f, 0x29, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x52, 0x4d,
  0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e,
  /* 0x9d */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x12, 0x0d,
  0x0c, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24,
  0x27, 0x26, 0x21, 0x20, 0x23, 0x5d, 0x5c, 0x5f,
  0x5e, 0x59, 0x58, 0x55, 0x54, 0x56, 0x51, 0x50,
  0x52, 0x4c, 0x4f, 0x4e, 0x49, 0x45, 0x44, 0x47,
  0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7e,
  0x79, 0x1d, 0x1f, 0x1e, 0x19, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x06,
  0x01, 0x03, 0x02, 0x3d, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x36, 0x30, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x2a, 0x25, 0x21, 0x5d, 0x5c,
  0x5f, 0x5e, 0x5a, 0x56, 0x51, 0x50, 0x4d, 0x4e,
  0x49, 0x4b, 0x4a, 0x45, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7e, 0x7a, 0x75, 0x74, 0x77,
  0x76, 0x71, 0x72, 0x6d, 0x6f, 0x6e, 0x69, 0x6b,
  0x6a, 0x64, 0x67, 0x66, 0x61, 0x62, 0x9c, 0x9e,
  0x99, 0x98,
  /* 0x9e */
  0x1d, 0x1e, 0x19, 0x18, 0x1a, 0x15, 0x14, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x09,
  0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x3d, 0x3c, 0x39, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x28, 0x2a, 0x24, 0x21, 0x20, 0x22, 0x5d,
  0x5c, 0x5e, 0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54,
  0x51, 0x53, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x44, 0x46, 0x41, 0x40, 0x42, 0x7f, 0x7e, 0x79,
  0x78, 0x71, 0x70, 0x73, 0x6e, 0x69, 0x68, 0x6a,
  0x65, 0x64, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d,
  0x9c, 0x99, 0x9a, 0x95, 0x94, 0x97, 0x96, 0x91,
  0x90, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x14, 0x16,
  0x11, 0x0d, 0x0f, 0x09, 0x0b, 0x0a, 0x05, 0x04,
  0x01, 0x00, 0x02, 0x3d, 0x3c, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x31, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x25, 0x24, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5a, 0x55, 0x57, 0x51, 0x50, 0x53, 0x52, 0x4d,
  0x4c, 0x49, 0x48, 0x4a, 0x45, 0x44, 0x46, 0x41,
  0x40, 0x43, 0x42, 0x7d, 0x7c, 0x79, 0x7b, 0x75,
  0x74, 0x77, 0x76, 0x71, 0x70, 0x6d, 0x6c, 0x6e,
  0x69, 0x68, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61,
  0x60, 0x9d,
  /* 0x9f */
  0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a, 0x17,
  0x16, 0x10, 0x13, 0x12, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x07, 0x01, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x3e, 0x3b, 0x3a, 0x34, 0x37, 0x36, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x2b, 0x2a, 0x27,
  0x26, 0x21, 0x20, 0x23, 0x22, 0x5f, 0x5e, 0x58,
  0x5b, 0x5a, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53,
  0x52, 0x4f, 0x4e, 0x49, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x43, 0x42, 0x7c, 0x7f, 0x7e, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x73, 0x6d,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x67, 0x66,
  0x60, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x11, 0x13, 0x0d, 0x0f, 0x0e, 0x09,
  0x08, 0x05, 0x04, 0x06, 0x01, 0x00, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x38, 0x35, 0x37, 0x2e, 0x29,
  0x28, 0x2a, 0x25, 0x24, 0x26, 0x21, 0x20, 0x23,
  0x22, 0x5d, 0x5c, 0x5e, 0x59, 0x5b, 0x5a, 0x55,
  0x54, 0x57, 0x56, 0x51, 0x50, 0x4d, 0x4c, 0x4e,
  0x49, 0x48, 0x44, 0x47, 0x46, 0x41, 0x7d, 0x78,
  0x7b, 0x7a, 0x74, 0x71, 0x70, 0x72, 0x6e, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x61, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x95, 0x94, 0x96, 0x91, 0x90, 0x92,
  0x8d, 0x8c,
  /* 0xa0 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x17, 0x16, 0x11,
  0x10, 0x13, 0x12, 0x0f, 0x0e, 0x08, 0x0a, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3c, 0x3f,
  0x3e, 0x39, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x30, 0x33, 0x32, 0x2c, 0x2f, 0x2e, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23,
  0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b,
  0x5a, 0x57, 0x56, 0x50, 0x53, 0x52, 0x4c, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x47, 0x41, 0x42, 0x7d,
  0x7c, 0x7f, 0x7e, 0x7b, 0x7a, 0x74, 0x77, 0x76,
  0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x6b,
  0x65, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1a,
  0x15, 0x14, 0x16, 0x11, 0x10, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x05, 0x04, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b,
  0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x5d,
  0x5c, 0x5e, 0x59, 0x58, 0x5a, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x4d, 0x4f, 0x4b, 0x4a, 0x45, 0x41,
  0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x71, 0x73, 0x6d,
  0x6c, 0x6f
};

static const acp_uint16_t uhc_1_2charset_main[ /*45*/ ] = {
  0x815c, 0x81d0, 0x8286, 0x837e, 0x83f4, 0x84aa, 0x8598, 0x865a,
  0x86ce, 0x87bc, 0x8874, 0x88f2, 0x89a0, 0x8a96, 0x8b50, 0x8bc4,
  0x8cba, 0x8d72, 0x8de8, 0x8ede, 0x8f8c, 0x904e, 0x90c2, 0x91b0,
  0x9268, 0x92e6, 0x93d4, 0x948a, 0x9544, 0x95f8, 0x96ae, 0x979c,
  0x985e, 0x98d2, 0x9980, 0x9a78, 0x9af6, 0x9ba4, 0x9c9a, 0x9d54,
  0x9dc8, 0x9ebe, 0x9f76, 0x9fec, 0xa0a2
};

static const acp_uint8_t uhc_1_2charset[ /*5696*/ ] = {
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94,
  0x97, 0x96, 0x91, 0x90, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa5, 0xa4,
  0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x97, 0x96, 0x91, 0x90, 0x93, 0x92,
  0x8d, 0x8c, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x97, 0x96, 0x91, 0x90, 0x93, 0x92, 0x8d, 0x8c,
  0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a, 0x85, 0x84,
  0x87, 0x86, 0x81, 0x80, 0x83, 0x82, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0xa1, 0xa0, 0xa3, 0xa2, 0xdd, 0xdc,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a, 0x93, 0x92,
  0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa5, 0xa4,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x97, 0x96, 0x8f, 0x8e, 0x89, 0x88,
  0x8b, 0x8a, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94,
  0x97, 0x96, 0x91, 0x90, 0x93, 0x92, 0x8d, 0x8c,
  0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a, 0x85, 0x84,
  0x87, 0x86, 0x81, 0x80, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0xab, 0xaa, 0xa5, 0xa4,
  0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2, 0xdd, 0xdc,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x95, 0x94, 0x97, 0x96, 0x91, 0x90, 0x93, 0x92,
  0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x87, 0x86, 0x81, 0x80, 0x83, 0x82, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x91, 0x90,
  0x93, 0x92, 0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88,
  0x8b, 0x8a, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94,
  0x97, 0x96, 0x91, 0x90, 0x93, 0x92, 0x8d, 0x8c,
  0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa5, 0xa4,
  0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2, 0xdd, 0xdc,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x97, 0x96, 0x91, 0x90, 0x93, 0x92,
  0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x89, 0x88, 0x8b, 0x8a, 0x85, 0x84,
  0x87, 0x86, 0x81, 0x80, 0x83, 0x82, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x5b, 0x5a, 0x55, 0x54,
  0x57, 0x56, 0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96, 0x91, 0x90,
  0x93, 0x92, 0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88,
  0x8b, 0x8a, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94,
  0x97, 0x96, 0x91, 0x90, 0x93, 0x92, 0x8d, 0x8c,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa5, 0xa4,
  0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2, 0xdd, 0xdc,
  0x1d, 0x1c, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e, 0x69, 0x68, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x97, 0x96, 0x91, 0x90, 0x93, 0x92,
  0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x93, 0x92, 0x8d, 0x8c,
  0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a, 0x85, 0x84,
  0x87, 0x86, 0x81, 0x80, 0x83, 0x82, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0xdd, 0xdc,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94,
  0x97, 0x96, 0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0xb9, 0xb8, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa5, 0xa4,
  0xa7, 0xa6, 0xa1, 0xa0, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x77, 0x76, 0x71, 0x70, 0x73, 0x72, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x97, 0x96, 0x91, 0x90, 0x93, 0x92,
  0x8b, 0x8a, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x95, 0x94,
  0x97, 0x96, 0x91, 0x90, 0x93, 0x92, 0x8d, 0x8c,
  0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a, 0x85, 0x84,
  0x87, 0x86, 0x81, 0x80, 0x83, 0x82, 0xbd, 0xbc,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x41, 0x40, 0x43, 0x42,
  0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a,
  0x75, 0x74, 0x77, 0x76, 0x71, 0x70, 0x73, 0x72,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2, 0xdd, 0xdc,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x51, 0x50, 0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e,
  0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46,
  0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e,
  0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76,
  0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e,
  0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66,
  0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e,
  0x99, 0x98, 0x9b, 0x9a, 0x95, 0x94, 0x97, 0x96,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x71, 0x70, 0x73, 0x72, 0x6d, 0x6c,
  0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a, 0x65, 0x64,
  0x67, 0x66, 0x61, 0x60, 0x63, 0x62, 0x9d, 0x9c,
  0x9f, 0x9e, 0x99, 0x98, 0x91, 0x90, 0x93, 0x92,
  0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88, 0x8b, 0x8a,
  0x85, 0x84, 0x87, 0x86, 0x81, 0x80, 0x83, 0x82,
  0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22,
  0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58, 0x5b, 0x5a,
  0x55, 0x54, 0x57, 0x56, 0x51, 0x50, 0x53, 0x52,
  0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a,
  0x45, 0x44, 0x47, 0x46, 0x83, 0x82, 0xbd, 0xbc,
  0xbf, 0xbe, 0xb9, 0xb8, 0xbb, 0xba, 0xb5, 0xb4,
  0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2, 0xad, 0xac,
  0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e, 0x59, 0x58,
  0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56, 0x51, 0x50,
  0x53, 0x52, 0x4d, 0x4c, 0x4f, 0x4e, 0x49, 0x48,
  0x4b, 0x4a, 0x45, 0x44, 0x47, 0x46, 0x41, 0x40,
  0x43, 0x42, 0x7d, 0x7c, 0x7f, 0x7e, 0x79, 0x78,
  0x7b, 0x7a, 0x75, 0x74, 0x77, 0x76, 0x71, 0x70,
  0x73, 0x72, 0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68,
  0x6b, 0x6a, 0x65, 0x64, 0x67, 0x66, 0x61, 0x60,
  0x63, 0x62, 0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x4d, 0x4c,
  0x4f, 0x4e, 0x49, 0x48, 0x4b, 0x4a, 0x45, 0x44,
  0x47, 0x46, 0x41, 0x40, 0x43, 0x42, 0x7d, 0x7c,
  0x7f, 0x7e, 0x79, 0x78, 0x7b, 0x7a, 0x75, 0x74,
  0x6d, 0x6c, 0x6f, 0x6e, 0x69, 0x68, 0x6b, 0x6a,
  0x65, 0x64, 0x67, 0x66, 0x61, 0x60, 0x63, 0x62,
  0x9d, 0x9c, 0x9f, 0x9e, 0x99, 0x98, 0x9b, 0x9a,
  0x95, 0x94, 0x8d, 0x8c, 0x8f, 0x8e, 0x89, 0x88,
  0x8b, 0x8a, 0x85, 0x84, 0x87, 0x86, 0x81, 0x80,
  0x83, 0x82, 0xbd, 0xbc, 0xbf, 0xbe, 0xb9, 0xb8,
  0xbb, 0xba, 0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0,
  0xb3, 0xb2, 0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8,
  0xab, 0xaa, 0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0,
  0xa3, 0xa2, 0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x27, 0x26, 0x21, 0x20, 0x23, 0x22
};

static const aciConvSummary16 uhc_1_uni2indx_pageac[ /*459*/ ] = {
  /* 0xac00 */
  {    0, 0xf86c }, {    9, 0xc100 }, {   12, 0x4fee }, {   23, 0xecfc },
  {   34, 0xd7fe }, {   47, 0xeeef }, {   60, 0xffff }, {   76, 0xfa6c },
  {   86, 0xe184 }, {   92, 0x4fee }, {  103, 0x68fc }, {  112, 0xc4fe },
  {  122, 0xeeed }, {  134, 0xff5f }, {  148, 0x6a6c }, {  156, 0xcf94 },
  /* 0xad00 */
  {  165, 0x4fae }, {  175, 0xeefd }, {  188, 0xcdfe }, {  200, 0xeecf },
  {  212, 0xfd4f }, {  224, 0xfeee }, {  237, 0xcff5 }, {  249, 0x4786 },
  {  256, 0xecf9 }, {  267, 0xcffe }, {  280, 0xffef }, {  295, 0xff7f },
  {  310, 0xfeec }, {  322, 0xeff4 }, {  334, 0xffee }, {  348, 0x6cff },
  /* 0xae00 */
  {  360, 0xd4fc }, {  370, 0xffef }, {  385, 0xffff }, {  401, 0xfa6c },
  {  411, 0x8b94 }, {  418, 0x4fae }, {  428, 0xecdc }, {  438, 0xc4fe },
  {  448, 0xefcf }, {  461, 0xffff }, {  477, 0xffff }, {  493, 0x8fff },
  {  506, 0x4fee }, {  517, 0xecfc }, {  528, 0xd6ff }, {  541, 0xeeef },
  /* 0xaf00 */
  {  554, 0xde7f }, {  567, 0xfffe }, {  582, 0xcfff }, {  596, 0x4fea },
  {  606, 0xfcf1 }, {  617, 0xcffe }, {  630, 0xffcf }, {  644, 0xfdff },
  {  659, 0xfeee }, {  672, 0xefdc }, {  684, 0xffff }, {  700, 0xecff },
  {  713, 0x947e }, {  722, 0xefef }, {  736, 0xfcff }, {  750, 0xfeec },
  /* 0xb000 */
  {  762, 0xefec }, {  774, 0xcfee }, {  786, 0xfeff }, {  801, 0xffff },
  {  817, 0xaacf }, {  827, 0xdd47 }, {  837, 0xffff }, {  853, 0xcfff },
  {  867, 0x4fee }, {  878, 0x68fd }, {  888, 0x04f8 }, {  894, 0xeec5 },
  {  904, 0xfc4f }, {  915, 0xfeec }, {  927, 0xffde }, {  941, 0xffff },
  /* 0xb100 */
  {  957, 0xe4ff }, {  969, 0xc4f2 }, {  977, 0xeec7 }, {  988, 0xfc4f },
  {  999, 0xfeec }, { 1011, 0xeecc }, { 1021, 0xfffe }, { 1036, 0xecff },
  { 1049, 0xd4fa }, { 1059, 0xeee3 }, { 1070, 0xfeff }, { 1085, 0xffff },
  { 1101, 0xefff }, { 1116, 0x4fee }, { 1127, 0xecff }, { 1140, 0xd5fe },
  /* 0xb200 */
  { 1152, 0xe6cf }, { 1163, 0xfd4f }, { 1175, 0xfffe }, { 1190, 0xefef },
  { 1204, 0xffff }, { 1220, 0xeeff }, { 1234, 0xfcfe }, { 1247, 0xefcf },
  { 1260, 0xfdcf }, { 1273, 0xf8ec }, { 1283, 0xeb94 }, { 1292, 0xffee },
  { 1306, 0xecff }, { 1319, 0xd4fa }, { 1329, 0x068b }, { 1335, 0x7047 },
  /* 0xb300 */
  { 1342, 0xfeec }, { 1354, 0xefc4 }, { 1364, 0xffff }, { 1380, 0xffff },
  { 1396, 0xffff }, { 1412, 0x268f }, { 1420, 0xb54f }, { 1430, 0xfeec },
  { 1442, 0xefc4 }, { 1452, 0xffee }, { 1466, 0xeefc }, { 1478, 0xffff },
  { 1494, 0xa6cf }, { 1504, 0xd54e }, { 1513, 0xfeee }, { 1526, 0xefff },
  /* 0xb400 */
  { 1541, 0xffff }, { 1557, 0xeefe }, { 1570, 0xf4fe }, { 1582, 0xffef },
  { 1597, 0xffff }, { 1613, 0xfeec }, { 1625, 0xefd4 }, { 1636, 0xffff },
  { 1652, 0xfefe }, { 1666, 0xdfff }, { 1681, 0xeeef }, { 1694, 0xfd5f },
  { 1707, 0xfeee }, { 1720, 0xcfde }, { 1732, 0x4fa6 }, { 1741, 0xfefd },
  /* 0xb500 */
  { 1755, 0xffff }, { 1771, 0xe6cf }, { 1782, 0xf84f }, { 1792, 0xfeec },
  { 1804, 0xc7c4 }, { 1812, 0x4fee }, { 1823, 0xfffc }, { 1837, 0xffff },
  { 1853, 0xffff }, { 1869, 0xffff }, { 1885, 0xf2ec }, { 1895, 0xc7c4 },
  { 1903, 0x4fee }, { 1914, 0xfefc }, { 1927, 0xefff }, { 1942, 0xffff },
  /* 0xb600 */
  { 1958, 0xffff }, { 1974, 0xfeec }, { 1986, 0xefdf }, { 2000, 0xffef },
  { 2015, 0xfeff }, { 2030, 0xffff }, { 2046, 0xfeef }, { 2060, 0xffff },
  { 2076, 0xffff }, { 2092, 0xcfff }, { 2106, 0xe7ee }, { 2118, 0xfffd },
  { 2133, 0xffff }, { 2149, 0xffef }, { 2164, 0xffff }, { 2180, 0xfeee },
  /* 0xb700 */
  { 2193, 0xffdc }, { 2206, 0xffff }, { 2222, 0x6cff }, { 2234, 0xf4fe },
  { 2246, 0xeeef }, { 2259, 0xffcf }, { 2273, 0xfeee }, { 2286, 0xcfd4 },
  { 2296, 0x4fee }, { 2307, 0xec38 }, { 2315, 0xc4fe }, { 2325, 0xfecf },
  { 2338, 0xfd7f }, { 2352, 0xffff }, { 2368, 0xcfff }, { 2382, 0x4fee },
  /* 0xb800 */
  { 2393, 0xec7c }, { 2403, 0xd4fe }, { 2414, 0xeecf }, { 2426, 0xfc4f },
  { 2437, 0xffee }, { 2451, 0xcff5 }, { 2463, 0x4fee }, { 2474, 0xeefd },
  { 2487, 0xdfff }, { 2502, 0xffff }, { 2518, 0xfeff }, { 2533, 0xfeee },
  { 2546, 0xefd4 }, { 2557, 0x5fee }, { 2569, 0xecfd }, { 2581, 0xd4fe },
  /* 0xb900 */
  { 2592, 0xffef }, { 2607, 0xfeff }, { 2622, 0xfffe }, { 2637, 0xcfff },
  { 2651, 0x6fee }, { 2663, 0xecfd }, { 2675, 0xd4fe }, { 2686, 0xeecf },
  { 2698, 0x994f }, { 2707, 0xffff }, { 2723, 0xcfff }, { 2737, 0x4fee },
  { 2748, 0x2cfd }, { 2758, 0x94f8 }, { 2766, 0xeec5 }, { 2776, 0xf84f },
  /* 0xba00 */
  { 2786, 0xfefc }, { 2799, 0xffdf }, { 2814, 0xffff }, { 2830, 0xecff },
  { 2843, 0x94fa }, { 2852, 0xeec7 }, { 2863, 0xfc4f }, { 2874, 0xfeec },
  { 2886, 0xef47 }, { 2897, 0xffff }, { 2913, 0xe4ff }, { 2925, 0xd4fa },
  { 2935, 0xfeef }, { 2949, 0xfcff }, { 2963, 0xffff }, { 2979, 0xefff },
  /* 0xbb00 */
  { 2994, 0x5fee }, { 3006, 0xeefd }, { 3019, 0xf5fe }, { 3032, 0x868f },
  { 3040, 0x5d4f }, { 3050, 0xfeee }, { 3063, 0xeff5 }, { 3076, 0xffff },
  { 3092, 0xeeff }, { 3106, 0xfffe }, { 3121, 0xeeef }, { 3134, 0xff6f },
  { 3148, 0xfeee }, { 3161, 0xfff6 }, { 3175, 0xffff }, { 3191, 0x6cff },
  /* 0xbc00 */
  { 3203, 0x44fa }, { 3211, 0x060d }, { 3216, 0xdd4f }, { 3227, 0xfeec },
  { 3239, 0xcdc4 }, { 3247, 0xdffe }, { 3261, 0xffff }, { 3277, 0xffff },
  { 3293, 0xa6cf }, { 3303, 0xf94f }, { 3314, 0xfe6c }, { 3325, 0xcfc4 },
  { 3334, 0x5fee }, { 3346, 0xeedc }, { 3357, 0xffff }, { 3373, 0xee8f },
  /* 0xbd00 */
  { 3384, 0xfd4f }, { 3396, 0xffee }, { 3410, 0xefef }, { 3424, 0xffff },
  { 3440, 0xecfe }, { 3452, 0xfcfe }, { 3465, 0xfeef }, { 3479, 0xffff },
  { 3495, 0xf86c }, { 3504, 0xe9d4 }, { 3513, 0xffef }, { 3528, 0xfefe },
  { 3542, 0xffff }, { 3558, 0xeecf }, { 3570, 0xfdff }, { 3585, 0xfeee },
  /* 0xbe00 */
  { 3598, 0xcfd6 }, { 3609, 0x4fee }, { 3620, 0xffff }, { 3636, 0xffff },
  { 3652, 0xaecf }, { 3663, 0xf14f }, { 3673, 0xfaec }, { 3684, 0xc7c4 },
  { 3692, 0x4fee }, { 3703, 0xfcfc }, { 3715, 0xfeff }, { 3730, 0xffff },
  { 3746, 0xffff }, { 3762, 0xfe6c }, { 3773, 0xefc6 }, { 3784, 0xffff },
  /* 0xbf00 */
  { 3800, 0xfcfd }, { 3813, 0xc4ff }, { 3824, 0xffff }, { 3840, 0xffff },
  { 3856, 0xfeec }, { 3868, 0xffdc }, { 3881, 0xffff }, { 3897, 0xffff },
  { 3913, 0xffff }, { 3929, 0xffef }, { 3944, 0xffff }, { 3960, 0xfffe },
  { 3975, 0xcfdf }, { 3988, 0x6fee }, { 4000, 0xfffd }, { 4015, 0xffff },
  /* 0xc000 */
  { 4031, 0xffff }, { 4047, 0xffff }, { 4063, 0xffff }, { 4079, 0xefff },
  { 4094, 0xffff }, { 4110, 0xeefd }, { 4123, 0xfcfe }, { 4136, 0xffff },
  { 4152, 0xffff }, { 4168, 0xfeec }, { 4180, 0x4fd4 }, { 4189, 0x4f86 },
  { 4197, 0xecdc }, { 4207, 0xc4fe }, { 4217, 0xeecf }, { 4229, 0xfd4f },
  /* 0xc100 */
  { 4241, 0xfeee }, { 4254, 0x0fde }, { 4264, 0x4f26 }, { 4272, 0xecbc },
  { 4282, 0xc4fe }, { 4292, 0xeecf }, { 4304, 0xfc4f }, { 4315, 0xfeee },
  { 4328, 0x8fdf }, { 4340, 0x4fae }, { 4350, 0xecdd }, { 4361, 0xdffe },
  { 4375, 0xeeef }, { 4388, 0xfe6f }, { 4401, 0xfeee }, { 4414, 0xcff4 },
  /* 0xc200 */
  { 4425, 0x4fee }, { 4436, 0x6cfd }, { 4447, 0x54fe }, { 4457, 0xffe9 },
  { 4470, 0xfeff }, { 4485, 0xfeec }, { 4497, 0xcfde }, { 4509, 0x4fee },
  { 4520, 0xfcfd }, { 4533, 0xd6fe }, { 4545, 0xcecf }, { 4556, 0xfd4f },
  { 4568, 0xffff }, { 4584, 0xcfff }, { 4598, 0x47e6 }, { 4607, 0xe4bd },
  /* 0xc300 */
  { 4617, 0xccfe }, { 4628, 0xeec7 }, { 4639, 0xfccf }, { 4651, 0xffff },
  { 4667, 0xffdf }, { 4682, 0xffff }, { 4698, 0xecff }, { 4711, 0xccfa },
  { 4721, 0xeeef }, { 4734, 0xffff }, { 4750, 0xffff }, { 4766, 0xffff },
  { 4782, 0xfffe }, { 4797, 0x6cff }, { 4809, 0xdcfa }, { 4820, 0xfecf },
  /* 0xc400 */
  { 4833, 0xfeff }, { 4848, 0xfffe }, { 4863, 0xefef }, { 4877, 0xcfee },
  { 4889, 0xfeff }, { 4904, 0xffff }, { 4920, 0xeecf }, { 4932, 0xfdcf },
  { 4945, 0xfffe }, { 4960, 0xefef }, { 4974, 0xffff }, { 4990, 0xeeff },
  { 5004, 0xffff }, { 5020, 0xffff }, { 5036, 0xfdff }, { 5051, 0x7aec },
  /* 0xc500 */
  { 5061, 0xeffc }, { 5074, 0xefee }, { 5087, 0xecff }, { 5100, 0xd4fe },
  { 5111, 0x88cf }, { 5119, 0x9c47 }, { 5127, 0xfeec }, { 5139, 0xcfc4 },
  { 5148, 0x4f6e }, { 5158, 0xee5d }, { 5169, 0xfdfe }, { 5183, 0x84cf },
  { 5191, 0xa80f }, { 5198, 0xfeec }, { 5210, 0x8fd4 }, { 5219, 0x0f2e },
  /* 0xc600 */
  { 5227, 0xee1c }, { 5236, 0xe4fe }, { 5247, 0x8ecf }, { 5257, 0xf546 },
  { 5266, 0xfeec }, { 5278, 0xcfc4 }, { 5287, 0x6ffe }, { 5300, 0xecfd },
  { 5312, 0xd4fe }, { 5323, 0xeecf }, { 5335, 0xfd4f }, { 5347, 0xf8ec },
  { 5357, 0xcfd4 }, { 5367, 0xcfee }, { 5379, 0xecfc }, { 5390, 0xdcfe },
  /* 0xc700 */
  { 5402, 0xeecf }, { 5414, 0xfd4f }, { 5426, 0xfeec }, { 5438, 0xcf54 },
  { 5447, 0x4bee }, { 5457, 0xee01 }, { 5464, 0xf6fe }, { 5477, 0x8ecf },
  { 5487, 0xb847 }, { 5495, 0xfa2c }, { 5504, 0xcf84 }, { 5512, 0x4fee },
  { 5523, 0xacfc }, { 5533, 0xdefe }, { 5546, 0xeeef }, { 5559, 0xffff },
  /* 0xc800 */
  { 5575, 0xfaec }, { 5586, 0xcf94 }, { 5595, 0x4fee }, { 5606, 0xeefd },
  { 5619, 0xccfe }, { 5630, 0xffef }, { 5645, 0xffff }, { 5661, 0xfaec },
  { 5672, 0xc714 }, { 5679, 0x5fef }, { 5692, 0x001d }
};

ACP_EXPORT acp_sint32_t aciConvConvertMbToWc4Uhc1( void    * aSrc,
                                                   acp_sint32_t      aSrcRemain,
                                                   acp_sint32_t    * aSrcAdvance,
                                                   void    * aDest,
                                                   acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      CP949 ==> UTF16BE ϴ Լ
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t   * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint32_t      i;
    acp_sint32_t      sRet;
    acp_uint32_t      row;
    acp_uint32_t      col;
    acp_uint16_t    wc;
    acp_uint32_t      sIndex;

    aDestRemain = 0;
    
    if ((sSrcCharPtr[0] >= 0x81 && sSrcCharPtr[0] <= 0xa0))
    {
        if (aSrcRemain >= 2)
        {
            if( (sSrcCharPtr[1] >= 0x41 && sSrcCharPtr[1] < 0x5b) || 
                (sSrcCharPtr[1] >= 0x61 && sSrcCharPtr[1] < 0x7b) || 
                (sSrcCharPtr[1] >= 0x81 && sSrcCharPtr[1] < 0xff) )
            {
                row = sSrcCharPtr[0] - 0x81;
                col = sSrcCharPtr[1] - 
                      (sSrcCharPtr[1] >= 0x81 ? 
                                0x4d : sSrcCharPtr[1] >= 0x61 ? 0x47 : 0x41);
                i = 178 * row + col;

                if (i < 5696)
                {
                    sIndex = 2*row+(col>=89?1:0);
                    if (sIndex >= 64)
                    {
                        sRet = ACICONV_RET_ILSEQ;
                        *aSrcAdvance = 2;
                    }
                    else
                    {
                        wc = (acp_uint16_t) ( (uhc_1_2uni_main_page81[sIndex] ^ UHC1_XOR_VALUE) +
                                              (uhc_1_2uni_page81[i] ^ UHC1_XOR_VALUE) );

                        ACICONV_WC_TO_UTF16BE( aDest, wc );
                    
                        sRet = 2;
                        *aSrcAdvance = 2;
                    }
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILSEQ;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_TOOFEW;
            *aSrcAdvance = aSrcRemain;
        }
    }
    else
    {
        sRet = ACICONV_RET_ILSEQ;
        *aSrcAdvance = 1;
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvConvertWcToMb4Uhc1( void    * aSrc,
                                                   acp_sint32_t      aSrcRemain,
                                                   acp_sint32_t    * aSrcAdvance,
                                                   void    * aDest,
                                                   acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      CP949 <== UTF16 ϴ Լ
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16   * sSummary = NULL;
    acp_uint16_t              sUsed;
    acp_uint8_t             * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_sint32_t                sRet;
    acp_uint16_t              c;
    acp_uint32_t                i;
    acp_uint16_t              wc;

    aSrcRemain = 0;
    
    ACICONV_UTF16BE_TO_WC( wc, aSrc );
    
    if (aDestRemain >= 2)
    {
        if (wc >= 0xac00 && wc < 0xc8b0)
        {
            sSummary = &uhc_1_uni2indx_pageac[(wc>>4)-0xac0];

            sUsed = sSummary->used;

            i = wc & 0x0f;
            
            if (sUsed & ((acp_uint16_t) 1 << i))
            {
                /* Keep in `sUsed' only the bits 0..i-1. */
                sUsed &= ((acp_uint16_t) 1 << i) - 1;

                /*Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                sUsed = (sUsed & 0x00ff) + (sUsed >> 8);
                sUsed += sSummary->indx;

                c = (uhc_1_2charset_main[sUsed>>7] ^ UHC1_XOR_VALUE) +
                    (uhc_1_2charset[sUsed] ^ UHC1_XOR_VALUE);

                sDestCharPtr[0] = (c >> 8); 
                sDestCharPtr[1] = (c & 0xff);

                sRet = 2;
                *aSrcAdvance = 2;
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_ILUNI;
            *aSrcAdvance = 2;
        }
    }
    else
    {
        sRet = ACICONV_RET_TOOSMALL;
        *aSrcAdvance = 2;
    }

    return sRet;
}

 
