/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: aciConvUhc2.c 11353 2010-06-25 05:28:05Z djin $
 **********************************************************************/

#include <aciConvUhc2.h>

static const acp_uint16_t uhc_2_2uni_main_pagea1[ /*76*/ ] = {
  0xc8b8, 0xc8c5, 0xc90d, 0xc923, 0xc96c, 0xc9b8, 0xc9c3, 0xca01,
  0xca5a, 0xca66, 0xcab5, 0xcac0, 0xcb16, 0xcb27, 0xcb70, 0xcb84,
  0xcbd8, 0xcbee, 0xcc38, 0xcc7a, 0xcc89, 0xccd2, 0xcce3, 0xcd29,
  0xcd7c, 0xcd8f, 0xcddb, 0xcde8, 0xce31, 0xce40, 0xce87, 0xced1,
  0xcf1f, 0xcf26, 0xcf70, 0xcf83, 0xcfd1, 0xcfe2, 0xd033, 0xd079,
  0xd088, 0xd0d1, 0xd118, 0xd12f, 0xd173, 0xd186, 0xd1cd, 0xd1e0,
  0xd237, 0xd243, 0xd290, 0xd2d8, 0xd2e6, 0xd323, 0xd377, 0xd3bc,
  0xd3ca, 0xd410, 0xd425, 0xd47a, 0xd483, 0xd4d4, 0xd4e3, 0xd533,
  0xd579, 0xd580, 0xd5d7, 0xd61b, 0xd620, 0xd66a, 0xd6b6, 0xd6ff,
  0xd708, 0xd753, 0xd790, 0xffe0
};

static const acp_uint8_t uhc_2_2uni_pagea1[ /*3126*/ ] = {
  /* 0xa1 */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x04, 0x07,
  0x06, 0x01, 0x00, 0x03, 0x3d, 0x3c, 0x3f, 0x39,
  0x38, 0x3b, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x2c, 0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x17, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x3e, 0x3b, 0x3a, 0x34, 0x37, 0x36, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x2b,
  /* 0xa2 */
  0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a, 0x14,
  0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x3e, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x09, 0x08, 0x0a, 0x05,
  0x04, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x39, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x32, 0x2d, 0x2c,
  /* 0xa3 */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x04, 0x07, 0x01,
  0x00, 0x03, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x34, 0x36, 0x30, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x00, 0x03, 0x3d,
  0x3c, 0x39, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x30,
  0x32, 0x2f, 0x2e, 0x2b,
  /* 0xa4 */
  0x1d, 0x1c, 0x1e, 0x18, 0x1a, 0x15, 0x17, 0x16,
  0x11, 0x10, 0x0d, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x01, 0x00, 0x02, 0x3d, 0x3c, 0x3e, 0x39,
  0x38, 0x3b, 0x3a, 0x35, 0x34, 0x31, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28, 0x2a, 0x25, 0x24, 0x26,
  0x21, 0x20, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37,
  /* 0xa5 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x15, 0x17,
  0x16, 0x11, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x0a, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c,
  0x2f, 0x2e, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31,
  /* 0xa6 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x0b, 0x0a, 0x04, 0x07,
  0x06, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x3b, 0x35, 0x37, 0x31, 0x30, 0x33, 0x32, 0x2f,
  0x2e, 0x29, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x31, 0x30,
  /* 0xa7 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1b, 0x1a, 0x15,
  0x17, 0x16, 0x11, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39,
  0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x33, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x0d,
  0x0c, 0x0e, 0x09, 0x08, 0x0a, 0x05, 0x04, 0x07,
  0x06, 0x01, 0x00, 0x3d, 0x3c, 0x3f, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2f,
  /* 0xa8 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36,
  /* 0xa9 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x3d, 0x3c,
  0x3e, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x06, 0x01, 0x03, 0x02, 0x3d,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x36,
  0x31, 0x30, 0x2d, 0x2c,
  /* 0xaa */
  0x1d, 0x1c, 0x18, 0x1b, 0x15, 0x17, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x08, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x3c, 0x3f, 0x39, 0x38, 0x3b,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x2c,
  0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x21, 0x20,
  0x23, 0x5d, 0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x17, 0x16, 0x11, 0x10, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31,
  /* 0xab */
  0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x1a, 0x14, 0x17,
  0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x0b, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3f,
  0x3e, 0x38, 0x3b, 0x3a, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x33, 0x32, 0x2f, 0x29, 0x2b, 0x2a, 0x25,
  0x24, 0x27, 0x1d, 0x1f, 0x1e, 0x19, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x03, 0x02, 0x3d, 0x3f,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x30, 0x33,
  /* 0xac */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0e, 0x09,
  0x08, 0x0b, 0x0a, 0x05, 0x04, 0x01, 0x03, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34,
  0x36, 0x31, 0x30, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1b,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x34, 0x37, 0x36,
  /* 0xad */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x10, 0x12, 0x0c, 0x0f, 0x0e, 0x09,
  0x08, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x1d, 0x1c, 0x19, 0x18, 0x1a, 0x15,
  0x14, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x09, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2e,
  /* 0xae */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1a, 0x15,
  0x14, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34, 0x36, 0x31,
  0x30, 0x33, 0x1d, 0x1c, 0x1f, 0x18, 0x1a, 0x14,
  0x17, 0x16, 0x11, 0x10, 0x13, 0x0d, 0x0c, 0x0f,
  0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01,
  0x00, 0x03, 0x3d, 0x3c, 0x3f, 0x3e, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x30, 0x33, 0x2d, 0x2c,
  0x2f, 0x29, 0x28, 0x2b,
  /* 0xaf */
  0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x15, 0x17, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x33, 0x32, 0x1d, 0x1c, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x10, 0x12, 0x0c, 0x0f, 0x0e, 0x09,
  0x08, 0x0b, 0x04, 0x07, 0x01, 0x00, 0x03, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x34, 0x36,
  0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x28, 0x2b,
  0x25, 0x24, 0x27, 0x21,
  /* 0xb0 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x15, 0x11,
  0x10, 0x13, 0x12, 0x0d, 0x0c, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x07, 0x06, 0x00, 0x03, 0x3c, 0x3f,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x37, 0x33, 0x32,
  0x2d, 0x2c, 0x2f, 0x2e,
  /* 0xb1 */
  0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x10, 0x0d, 0x0f, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x06, 0x01, 0x00, 0x02,
  0x3d, 0x3c, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x31, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2a, 0x25, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x06, 0x01, 0x03, 0x02, 0x3d,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x36,
  0x30, 0x32, 0x2d, 0x2c,
  /* 0xb2 */
  0x1d, 0x1c, 0x1f, 0x18, 0x1b, 0x15, 0x14, 0x17,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x09,
  0x08, 0x0b, 0x0a, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x30,
  /* 0xb3 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x0b, 0x0a, 0x04, 0x07,
  0x06, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x3b, 0x35, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2c, 0x2f, 0x1d, 0x1f, 0x1e, 0x19, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x30,
  /* 0xb4 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x15, 0x14,
  0x16, 0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x08, 0x05, 0x07, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3e, 0x39, 0x38, 0x3a, 0x35, 0x34,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2e,
  0x29, 0x28, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x17, 0x16, 0x10, 0x13, 0x12, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x07, 0x06,
  0x01, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39,
  0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x33, 0x32, 0x2d,
  /* 0xb5 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x0c,
  0x0f, 0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x3c, 0x3e, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x30, 0x33, 0x2d, 0x2c, 0x2f,
  0x28, 0x2b, 0x1d, 0x1c, 0x1f, 0x1e, 0x1b, 0x17,
  0x16, 0x11, 0x10, 0x13, 0x12, 0x0f, 0x0e, 0x08,
  0x0b, 0x0a, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3f, 0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36,
  0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29,
  0x28, 0x2b, 0x2a, 0x25,
  /* 0xb6 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x0d, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x01, 0x00, 0x02, 0x3d,
  0x3c, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34,
  0x31, 0x33, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2a, 0x25, 0x24, 0x26,
  /* 0xb7 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0a, 0x05, 0x04,
  0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x37,
  0x36, 0x31, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a,
  0x15, 0x17, 0x16, 0x11, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x0a, 0x04, 0x06, 0x01, 0x00,
  0x03, 0x3d, 0x3f, 0x3e, 0x39, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2f, 0x2e, 0x29,
  /* 0xb8 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x38, 0x3b, 0x3a, 0x34, 0x37,
  0x36, 0x31, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x16, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31,
  /* 0xb9 */
  0x1d, 0x1c, 0x19, 0x18, 0x1a, 0x15, 0x14, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x09, 0x0b,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32, 0x2d,
  0x2c, 0x2e, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x39, 0x38, 0x3a, 0x35, 0x34,
  0x36, 0x31, 0x30, 0x33,
  /* 0xba */
  0x1d, 0x1c, 0x1f, 0x18, 0x1b, 0x1a, 0x14, 0x17,
  0x16, 0x11, 0x10, 0x13, 0x0d, 0x0c, 0x0f, 0x09,
  0x08, 0x0b, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x3d, 0x3c, 0x3f, 0x3e, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x30, 0x33, 0x2d, 0x2c, 0x29,
  0x2b, 0x2a, 0x1d, 0x1c, 0x1f, 0x18, 0x1a, 0x15,
  0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x0d, 0x0c,
  0x0f, 0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x06,
  0x01, 0x00, 0x03, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x30, 0x33, 0x2d,
  0x2c, 0x2f, 0x29, 0x28,
  /* 0xbb */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x1a, 0x14, 0x16,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x09, 0x0b, 0x0a,
  0x05, 0x07, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3e,
  0x3a, 0x35, 0x34, 0x36, 0x31, 0x32, 0x2d, 0x2f,
  0x2e, 0x29, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x22, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a,
  0x35, 0x34, 0x37, 0x36,
  /* 0xbc */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x09, 0x08, 0x0a, 0x05, 0x04, 0x06,
  0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c, 0x39, 0x35,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x2d, 0x2c, 0x2e,
  0x29, 0x28, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x14, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x09, 0x08, 0x0b, 0x05, 0x04, 0x07, 0x01,
  0x00, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x38, 0x3b,
  0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x2d, 0x2c,
  0x2f, 0x2e, 0x29, 0x28,
  /* 0xbd */
  0x1d, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x0a, 0x05, 0x07, 0x06, 0x01, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x3a, 0x34,
  0x36, 0x31, 0x30, 0x33, 0x32, 0x2d, 0x2f, 0x2e,
  0x29, 0x28, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37,
  /* 0xbe */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x14, 0x17, 0x16, 0x10, 0x13, 0x12, 0x0d, 0x0c,
  0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d, 0x3c,
  0x3f, 0x3e, 0x38, 0x3b, 0x3a, 0x34, 0x37, 0x36,
  0x30, 0x33, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1a, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0e, 0x09, 0x0b, 0x0a, 0x07, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3e, 0x38, 0x3a, 0x35, 0x34,
  0x37, 0x36, 0x31, 0x33, 0x32, 0x2d, 0x2c, 0x2f,
  0x2e, 0x29, 0x28, 0x2b,
  /* 0xbf */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a, 0x05,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3d,
  0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35,
  0x34, 0x37, 0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b,
  0x15, 0x14, 0x17, 0x11, 0x10, 0x13, 0x12, 0x0d,
  0x0c, 0x0f, 0x09, 0x08, 0x0a, 0x05, 0x04, 0x07,
  0x06, 0x01, 0x00, 0x03, 0x3d, 0x3c, 0x3f, 0x39,
  0x38, 0x3b, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x2d, 0x2c, 0x2e,
  /* 0xc0 */
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1a, 0x15,
  0x14, 0x16, 0x11, 0x10, 0x12, 0x0d, 0x0c, 0x0f,
  0x0e, 0x09, 0x08, 0x05, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x0d, 0x0c, 0x0e, 0x09, 0x08, 0x0a, 0x05, 0x04,
  0x07, 0x06, 0x01, 0x00, 0x3d, 0x3f, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x31, 0x30, 0x32, 0x2d,
  0x2c, 0x2e, 0x29, 0x28,
  /* 0xc1 */
  0x1d, 0x1f, 0x1e, 0x1b, 0x15, 0x17, 0x16, 0x11,
  0x10, 0x13, 0x12, 0x0f, 0x0e, 0x08, 0x0b, 0x0a,
  0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02, 0x3f,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x30, 0x33,
  0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x2b,
  0x2a, 0x25, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13,
  0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x3a, 0x35, 0x34, 0x37,
  /* 0xc2 */
  0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a, 0x14, 0x17,
  0x16, 0x11, 0x10, 0x0d, 0x0f, 0x09, 0x08, 0x0b,
  0x0a, 0x05, 0x04, 0x01, 0x00, 0x02, 0x3d, 0x3c,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x31,
  0x33, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28, 0x25,
  0x24, 0x26, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1b,
  0x1a, 0x15, 0x14, 0x11, 0x0d, 0x0c, 0x0f, 0x0e,
  0x09, 0x08, 0x0a, 0x05, 0x04, 0x06, 0x01, 0x00,
  0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38, 0x3b,
  0x35, 0x34, 0x37, 0x36, 0x31, 0x30, 0x33, 0x32,
  0x2d, 0x2c, 0x29, 0x28,
  /* 0xc3 */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x14,
  0x17, 0x10, 0x12, 0x0c, 0x0f, 0x0e, 0x08, 0x0b,
  0x04, 0x07, 0x01, 0x00, 0x03, 0x3d, 0x3c, 0x3f,
  0x3e, 0x39, 0x38, 0x3b, 0x3a, 0x35, 0x34, 0x36,
  0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x28, 0x2b,
  0x25, 0x24, 0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18,
  0x1b, 0x1a, 0x15, 0x14, 0x17, 0x16, 0x10, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x0a, 0x05, 0x07,
  0x06, 0x01, 0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e,
  0x39, 0x38, 0x3a, 0x34, 0x36, 0x31, 0x30, 0x33,
  0x32, 0x2d, 0x2f, 0x2e,
  /* 0xc4 */
  0x1d, 0x1f, 0x1e, 0x19, 0x1b, 0x1a, 0x15, 0x14,
  0x17, 0x16, 0x11, 0x10, 0x12, 0x0c, 0x0f, 0x0e,
  0x09, 0x08, 0x0b, 0x0a, 0x05, 0x06, 0x01, 0x03,
  0x02, 0x3d, 0x3f, 0x3e, 0x39, 0x38, 0x3a, 0x35,
  0x37, 0x36, 0x30, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x2b, 0x1d, 0x1c, 0x1e, 0x19, 0x18, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x12, 0x0d,
  0x0c, 0x0f, 0x09, 0x08, 0x0b, 0x0a, 0x05, 0x04,
  0x01, 0x00, 0x02, 0x3d, 0x3c, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x2d, 0x2c, 0x2f,
  /* 0xc5 */
  0x1d, 0x1c, 0x1f, 0x18, 0x1b, 0x15, 0x14, 0x17,
  0x11, 0x10, 0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x08,
  0x0a, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x3c,
  0x3f, 0x39, 0x38, 0x3b, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x2d, 0x2c, 0x2e, 0x28, 0x2b,
  0x2a, 0x25, 0x1d, 0x1c, 0x19, 0x18, 0x1a, 0x11,
  0x10, 0x13, 0x12, 0x0d, 0x0c, 0x09, 0x0b, 0x05,
  0x04, 0x07, 0x01, 0x00, 0x02, 0x3d, 0x3c, 0x3e,
  0x39, 0x38, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31,
  0x30, 0x2d, 0x2c, 0x2f, 0x29, 0x28, 0x2b, 0x2a,
  0x25, 0x24, 0x21, 0x20,
  /* 0xc6 */
  0x1d, 0x1c, 0x1f, 0x19, 0x18, 0x1b, 0x1a, 0x15,
  0x14, 0x17, 0x10, 0x12, 0x0c, 0x0f, 0x0e, 0x09,
  0x08, 0x0b
};

static const acp_uint16_t uhc_2_2charset_main[ /*49*/ ] = {
  0xa15c, 0xa190, 0xa26e, 0xa344, 0xa458, 0xa48c, 0xa56a, 0xa67e,
  0xa754, 0xa788, 0xa89c, 0xa97a, 0xaa50, 0xaa84, 0xab98, 0xac76,
  0xad4c, 0xad80, 0xae94, 0xaf72, 0xb048, 0xb15c, 0xb190, 0xb26e,
  0xb344, 0xb458, 0xb48c, 0xb56a, 0xb67e, 0xb754, 0xb788, 0xb89c,
  0xb97a, 0xba50, 0xba84, 0xbb98, 0xbc76, 0xbd4c, 0xbd80, 0xbe94,
  0xbf72, 0xc048, 0xc15c, 0xc190, 0xc26e, 0xc344, 0xc458, 0xc48c,
  0xc56a
};

static const acp_uint8_t uhc_2_2charset[ /*3126*/ ] = {
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8, 0xcb, 0xca,
  0xc5, 0xc4, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xf9, 0xf8, 0xfb, 0xfa, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26, 0x21, 0x20,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0x01, 0x00, 0x03, 0x02,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8, 0xcb, 0xca,
  0xc5, 0xc4, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x07, 0x06, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0xb9, 0xb8, 0xbb, 0xba,
  0xb5, 0xb4, 0xb7, 0xb6, 0xb1, 0xb0, 0xb3, 0xb2,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xd9, 0xd8,
  0xdb, 0xda, 0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xf9, 0xf8, 0xfb, 0xfa, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xd3, 0xd2,
  0xcd, 0xcc, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x0b, 0x0a,
  0x05, 0x04, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x2b, 0x2a, 0x25, 0x24, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xd7, 0xd6, 0xd1, 0xd0, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x15, 0x14, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x35, 0x34, 0x37, 0x36,
  0x31, 0x30, 0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e,
  0x29, 0x28, 0x2b, 0x2a, 0x25, 0x24, 0x27, 0x26,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0xf5, 0xf4, 0xf7, 0xf6,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0x37, 0x36, 0x31, 0x30,
  0x33, 0x32, 0x2d, 0x2c, 0x2f, 0x2e, 0x29, 0x28,
  0x21, 0x20, 0x23, 0x22, 0x5d, 0x5c, 0x5f, 0x5e,
  0x59, 0x58, 0x5b, 0x5a, 0x55, 0x54, 0x57, 0x56,
  0x1d, 0x1c, 0x1f, 0x1e, 0x19, 0x18, 0x1b, 0x1a,
  0x15, 0x14, 0x17, 0x16, 0x11, 0x10, 0x13, 0x12,
  0xad, 0xac, 0xaf, 0xae, 0xa9, 0xa8, 0xab, 0xaa,
  0xa5, 0xa4, 0xa7, 0xa6, 0xa1, 0xa0, 0xa3, 0xa2,
  0xdd, 0xdc, 0xdf, 0xde, 0xd9, 0xd8, 0xdb, 0xda,
  0xd5, 0xd4, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6, 0xc1, 0xc0,
  0xc3, 0xc2, 0xfd, 0xfc, 0xff, 0xfe, 0xf9, 0xf8,
  0x1d, 0x1c, 0x1f, 0x1e, 0x17, 0x16, 0x11, 0x10,
  0x13, 0x12, 0x0d, 0x0c, 0x0f, 0x0e, 0x09, 0x08,
  0x0b, 0x0a, 0x05, 0x04, 0x07, 0x06, 0x01, 0x00,
  0x03, 0x02, 0x3d, 0x3c, 0x3f, 0x3e, 0x39, 0x38,
  0x3b, 0x3a, 0x35, 0x34, 0xd7, 0xd6, 0xd1, 0xd0,
  0xd3, 0xd2, 0xcd, 0xcc, 0xcf, 0xce, 0xc9, 0xc8,
  0xcb, 0xca, 0xc5, 0xc4, 0xc7, 0xc6
};

static const aciConvSummary16 uhc_2_uni2indx_pagec8[ /*251*/ ] = {
  /* 0xc800 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0xfee0 }, {   10, 0xcfff },
  {   24, 0xeeef }, {   37, 0xfd4f }, {   49, 0xffec }, {   62, 0xcfdf },
  /* 0xc900 */
  {   75, 0x4f8e }, {   84, 0xfefd }, {   98, 0xefff }, {  113, 0xffef },
  {  128, 0xffff }, {  144, 0xfeec }, {  156, 0xeff4 }, {  168, 0xefee },
  {  181, 0xecff }, {  194, 0xd4fe }, {  205, 0xffff }, {  221, 0xffff },
  {  237, 0xfa6c }, {  247, 0xc994 }, {  254, 0x4f6a }, {  263, 0xecfc },
  /* 0xca00 */
  {  274, 0xc4fe }, {  284, 0xfeef }, {  298, 0xfdff }, {  313, 0xffff },
  {  329, 0xcfff }, {  343, 0x4fee }, {  354, 0xfefc }, {  367, 0xdfff },
  {  382, 0xffef }, {  397, 0xfeff }, {  412, 0xffff }, {  428, 0xcfff },
  {  442, 0x4fee }, {  453, 0xfcf5 }, {  465, 0xeffe }, {  479, 0xffef },
  /* 0xcb00 */
  {  494, 0xfeff }, {  509, 0xfeee }, {  522, 0xfffc }, {  536, 0xffff },
  {  552, 0xecfd }, {  564, 0xdcfe }, {  576, 0xffef }, {  591, 0xfcff },
  {  605, 0xffff }, {  621, 0xefff }, {  636, 0xffff }, {  652, 0xfeff },
  {  667, 0xffff }, {  683, 0xffef }, {  698, 0xfd6f }, {  711, 0xffff },
  /* 0xcc00 */
  {  727, 0xcfff }, {  741, 0xcfee }, {  753, 0xac79 }, {  762, 0x84fe },
  {  771, 0xeecf }, {  783, 0xfc4f }, {  794, 0xfeae }, {  806, 0xffde },
  {  820, 0xffff }, {  836, 0xecff }, {  849, 0xc4fe }, {  859, 0xeecf },
  {  871, 0xfd4f }, {  883, 0xffee }, {  897, 0xefef }, {  911, 0xfffe },
  /* 0xcd00 */
  {  926, 0xecfd }, {  938, 0xd4fe }, {  949, 0xeeef }, {  962, 0xfdff },
  {  977, 0xffff }, {  993, 0xefff }, { 1008, 0x4fee }, { 1019, 0xfefd },
  { 1033, 0xfeff }, { 1048, 0xeecf }, { 1060, 0xfd4f }, { 1072, 0xfffe },
  { 1087, 0xefef }, { 1101, 0xfffe }, { 1116, 0xeeff }, { 1130, 0xd4fe },
  /* 0xce00 */
  { 1141, 0xeeef }, { 1154, 0xfdef }, { 1168, 0xfeec }, { 1180, 0xffd4 },
  { 1192, 0xffff }, { 1208, 0x6cff }, { 1220, 0xd4fc }, { 1230, 0xeecf },
  { 1242, 0xfd4f }, { 1254, 0xfeec }, { 1266, 0xcfc4 }, { 1275, 0xffff },
  { 1291, 0xfffd }, { 1306, 0xffff }, { 1322, 0xe6cf }, { 1333, 0xfc4f },
  /* 0xcf00 */
  { 1344, 0xfeec }, { 1356, 0xefd4 }, { 1367, 0x4fee }, { 1378, 0xfefc },
  { 1391, 0xffff }, { 1407, 0xeecf }, { 1419, 0xfd4f }, { 1431, 0xfeec },
  { 1443, 0xefde }, { 1456, 0xffff }, { 1472, 0xfefd }, { 1486, 0xfffe },
  { 1501, 0xffef }, { 1516, 0xffff }, { 1532, 0xfeec }, { 1544, 0xefd4 },
  /* 0xd000 */
  { 1555, 0xffee }, { 1569, 0xfefd }, { 1583, 0xdfff }, { 1598, 0xeecf },
  { 1610, 0xfd4f }, { 1622, 0xfeee }, { 1635, 0xcffe }, { 1648, 0xcfee },
  { 1660, 0xfffd }, { 1675, 0xffff }, { 1691, 0xeecf }, { 1703, 0xfd4f },
  { 1715, 0xfcec }, { 1726, 0xcfc4 }, { 1735, 0x4fee }, { 1746, 0xfefc },
  /* 0xd100 */
  { 1759, 0xdfff }, { 1774, 0xffff }, { 1790, 0xffff }, { 1806, 0xfaec },
  { 1817, 0xcfc4 }, { 1826, 0x4fee }, { 1837, 0xeefd }, { 1850, 0xefff },
  { 1865, 0xfeef }, { 1879, 0xffff }, { 1895, 0xfeec }, { 1907, 0xebd4 },
  { 1917, 0xfffe }, { 1932, 0xfeff }, { 1947, 0xffff }, { 1963, 0xfeef },
  /* 0xd200 */
  { 1977, 0xfd7f }, { 1991, 0xfffe }, { 2006, 0xcfff }, { 2020, 0x4fee },
  { 2031, 0xfefd }, { 2045, 0xefff }, { 2060, 0xffef }, { 2075, 0xffff },
  { 2091, 0xfeec }, { 2103, 0xefdc }, { 2115, 0xefee }, { 2128, 0x6cfd },
  { 2139, 0xf4fa }, { 2150, 0xeeef }, { 2163, 0xffcf }, { 2177, 0xfeec },
  /* 0xd300 */
  { 2189, 0x8fd4 }, { 2198, 0x4fae }, { 2208, 0xecdc }, { 2218, 0xc4fe },
  { 2228, 0xffcf }, { 2242, 0xffff }, { 2258, 0xffff }, { 2274, 0xcfff },
  { 2288, 0x4fee }, { 2299, 0xecfc }, { 2310, 0xd4fe }, { 2321, 0xeeef },
  { 2334, 0xfccf }, { 2346, 0xfefe }, { 2360, 0xcff5 }, { 2372, 0x4fee },
  /* 0xd400 */
  { 2383, 0xfefd }, { 2397, 0xdfff }, { 2412, 0xffff }, { 2428, 0xffff },
  { 2444, 0xffee }, { 2458, 0xefff }, { 2473, 0x5fee }, { 2485, 0x6cff },
  { 2497, 0xd4fa }, { 2507, 0xffef }, { 2522, 0xfdff }, { 2537, 0xffff },
  { 2553, 0xefff }, { 2568, 0x6fee }, { 2580, 0xeeff }, { 2594, 0xd6fe },
  /* 0xd500 */
  { 2606, 0xeeef }, { 2619, 0xff4f }, { 2632, 0xffff }, { 2648, 0xcfff },
  { 2662, 0x4fee }, { 2673, 0xecfd }, { 2685, 0xd4de }, { 2695, 0xeecf },
  { 2707, 0xfc4f }, { 2718, 0xfffe }, { 2733, 0xffdf }, { 2748, 0xffff },
  { 2764, 0xecff }, { 2777, 0xd4fa }, { 2787, 0xeecf }, { 2799, 0xfd4f },
  /* 0xd600 */
  { 2811, 0xfeec }, { 2823, 0xefc4 }, { 2833, 0xdfee }, { 2846, 0xecff },
  { 2859, 0xd4de }, { 2869, 0xeecd }, { 2880, 0xfd7f }, { 2894, 0xffec },
  { 2907, 0xcfd7 }, { 2919, 0x5fee }, { 2931, 0xeefd }, { 2944, 0xf5fe },
  { 2957, 0xeecf }, { 2969, 0xfd6d }, { 2981, 0xfeee }, { 2994, 0xcfde },
  /* 0xd700 */
  { 3006, 0xffee }, { 3020, 0xecfd }, { 3032, 0xd4fe }, { 3043, 0xeecf },
  { 3055, 0xfd6f }, { 3068, 0xfc2c }, { 3077, 0xedd4 }, { 3087, 0xcfee },
  { 3099, 0xecfd }, { 3111, 0xd4fe }, { 3122, 0x000f }
};

ACP_EXPORT acp_sint32_t aciConvConvertMbToWc4Uhc2( void    * aSrc,
                                                   acp_sint32_t      aSrcRemain,
                                                   acp_sint32_t    * aSrcAdvance,
                                                   void    * aDest,
                                                   acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      CP949 ==> UTF16 ϴ Լ
 *
 * Implementation :
 *
 ***********************************************************************/

    acp_uint8_t   * sSrcCharPtr = (acp_uint8_t *)aSrc;
    acp_uint32_t      i;
    acp_sint32_t      sRet;
    acp_uint32_t      row;
    acp_uint32_t      col;
    acp_uint16_t    wc;
    acp_uint32_t      sIndex;

    aDestRemain = 0;
    
    if ((sSrcCharPtr[0] >= 0xa0 && sSrcCharPtr[0] <= 0xc6))
    {
        if (aSrcRemain >= 2)
        {
            if( (sSrcCharPtr[1] >= 0x41 && sSrcCharPtr[1] < 0x5b) || 
                (sSrcCharPtr[1] >= 0x61 && sSrcCharPtr[1] < 0x7b) || 
                (sSrcCharPtr[1] >= 0x81 && sSrcCharPtr[1] < 0xff) )
            {
                row = sSrcCharPtr[0] - 0xa1;
                col = sSrcCharPtr[1] - 
                      (sSrcCharPtr[1] >= 0x81 ? 
                                0x4d : sSrcCharPtr[1] >= 0x61 ? 0x47 : 0x41);
                i = 84 * row + col;

                if (i < 3126)
                {
                    sIndex = 2*row+(col>=42?1:0);
                    if (sIndex >= 76)
                    {
                        sRet = ACICONV_RET_ILSEQ;
                        *aSrcAdvance = 2;
                    }
                    else
                    {
                        wc = (acp_uint16_t) ( (uhc_2_2uni_main_pagea1[sIndex] ^ UHC2_XOR_VALUE) +
                                              (uhc_2_2uni_pagea1[i] ^ UHC2_XOR_VALUE) );

                        ACICONV_WC_TO_UTF16BE( aDest, wc );
                    
                        sRet = 2;
                        *aSrcAdvance = 2;
                    }
                }
                else
                {
                    sRet = ACICONV_RET_ILSEQ;
                    *aSrcAdvance = 2;
                }
            }
            else
            {
                sRet = ACICONV_RET_ILSEQ;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_TOOFEW;
            *aSrcAdvance = aSrcRemain;
        }
    }
    else
    {
        sRet = ACICONV_RET_ILSEQ;
        *aSrcAdvance = 1;
    }

    return sRet;
}

ACP_EXPORT acp_sint32_t aciConvConvertWcToMb4Uhc2( void    * aSrc,
                                                   acp_sint32_t      aSrcRemain,
                                                   acp_sint32_t    * aSrcAdvance,
                                                   void    * aDest,
                                                   acp_sint32_t      aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      CP949 <== UTF16BE ϴ Լ
 *
 * Implementation :
 *
 ***********************************************************************/

    const aciConvSummary16   * sSummary = NULL;
    acp_uint16_t              sUsed;
    acp_uint8_t             * sDestCharPtr = (acp_uint8_t *)aDest;
    acp_sint32_t                sRet;
    acp_uint16_t              c;
    acp_uint32_t                i;
    acp_uint16_t              wc;

    aSrcRemain = 0;
    
    ACICONV_UTF16BE_TO_WC( wc, aSrc );
    
    if (aDestRemain >= 2)
    {
        if (wc >= 0xc800 && wc < 0xd7b0)
        {
            sSummary = &uhc_2_uni2indx_pagec8[(wc>>4)-0xc80];

            sUsed = sSummary->used;

            i = wc & 0x0f;
            
            if (sUsed & ((acp_uint16_t) 1 << i))
            {
                /* Keep in `sUsed' only the bits 0..i-1. */
                sUsed &= ((acp_uint16_t) 1 << i) - 1;

                /*Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                sUsed = (sUsed & 0x00ff) + (sUsed >> 8);
                sUsed += sSummary->indx;

                c = (uhc_2_2charset_main[sUsed>>6] ^ UHC2_XOR_VALUE) +
                    (uhc_2_2charset[sUsed] ^ UHC2_XOR_VALUE);

                sDestCharPtr[0] = (c >> 8); 
                sDestCharPtr[1] = (c & 0xff);

                sRet = 2;
                *aSrcAdvance = 2;
            }
            else
            {
                sRet = ACICONV_RET_ILUNI;
                *aSrcAdvance = 2;
            }
        }
        else
        {
            sRet = ACICONV_RET_ILUNI;
            *aSrcAdvance = 2;
        }
    }
    else
    {
        sRet = ACICONV_RET_TOOSMALL;
        *aSrcAdvance = 2;
    }

    return sRet;
}

 
