/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: idnGbkext2.cpp 65693 2014-06-25 10:08:17Z myungsub.shin $
 **********************************************************************/

#include <idnGbkext2.h>

static const UShort gGbkExt22UniA8[8272] = {
    /* 0xa8 */
    0x8fff, 0x8ffe, 0x8fec, 0xad26, 0xad20, 0xad10, 0xad00, 0xac30,
    0xac3c, 0xaca3, 0xaca2, 0xacad, 0xacac, 0xaf20, 0xaf2a, 0xaf16,
    0xaf67, 0xaf53, 0xaf52, 0xaf8a, 0xa865, 0xa864, 0xa867, 0xa866,
    0xa861, 0xa860, 0xa863, 0xa862, 0xa86d, 0xa86c, 0xa86f, 0xa86e,
    0xa869, 0xa868, 0xa86b, 0xa86a, 0xa855, 0xa854, 0xa857, 0xa856,
    0xa851, 0xa850, 0xa853, 0xa852, 0xa85d, 0xa85c, 0xa85f, 0xa85e,
    0xa859, 0xa858, 0xa85b, 0xa85a, 0xa845, 0xa844, 0xa847, 0xa846,
    0xa8b4, 0xa8b7, 0xa8b6, 0xa8b1, 0xa8b0, 0xa8b3, 0xa8b2, 0xa8bd,
    0xa8bc, 0xa8bf, 0xa8be, 0xa8b9, 0xa8b8, 0xa8bb, 0xa8ba, 0xa8a6,
    0xa8a1, 0xa8a0, 0xa889, 0xa888, 0xa8d7, 0xa8d6, 0xa8d1, 0xa8d0,
    0xab3c, 0xafa0, 0xbd27, 0xbd28, 0xbd2b, 0x72c8, 0x72c8, 0x72c8,
    0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8,
    /* 0xa9 */
    0xbd14, 0xbd17, 0xbd16, 0xbd11, 0xbd10, 0xbd13, 0xbd12, 0xbd1d,
    0xbd1c, 0xbf96, 0xbebb, 0xbeba, 0xbea9, 0xbea8, 0xbeab, 0xbe94,
    0xbef1, 0xbefb, 0xbee4, 0xbee7, 0xbee0, 0x7305, 0x72d7, 0x72d1,
    0x72c8, 0xac14, 0xbf04, 0x72c8, 0xad25, 0x72c8, 0x72c8, 0x72c8,
    0xbdc9, 0xbdae, 0xbda9, 0xbdc8, 0xbdcb, 0xbd33, 0xbda8, 0xbdab,
    0x737c, 0x737f, 0x737e, 0x7379, 0x7378, 0x737b, 0x737a, 0x7365,
    0x7364, 0x7367, 0x7361, 0x7360, 0x7363, 0x7362, 0x736c, 0x736f,
    0x736e, 0x7369, 0x7368, 0x736b, 0x736a, 0x7355, 0x7354, 0x7357,
    0x7356, 0x7351, 0x7350, 0x7353, 0x735d, 0x735c, 0x735f, 0x735e,
    0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8,
    0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0xbd32, 0x72c8, 0x72c8,
    0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8, 0x72c8,
    /* 0xaa */
    0xffe9, 0xffe8, 0xffea, 0xffd7, 0xffd6, 0xffd1, 0xffd0, 0xffd3,
    0xffd2, 0xffdf, 0xffde, 0xffc0, 0xffc3, 0xffcc, 0xffc8, 0xffcb,
    0xffca, 0xfe35, 0xfe37, 0xfe31, 0xfe30, 0xfe33, 0xfe32, 0xfe3d,
    0xfe3c, 0xfe3e, 0xfe39, 0xfe38, 0xfe3a, 0xfe25, 0xfe24, 0xfe27,
    0xfe21, 0xfe2d, 0xfe2c, 0xfe2f, 0xfe2a, 0xfe15, 0xfe16, 0xfe11,
    0xfe13, 0xfe12, 0xfe1d, 0xfe18, 0xfe1a, 0xfe05, 0xfe07, 0xfe06,
    0xfe00, 0xfe03, 0xfe0f, 0xfe0e, 0xfe09, 0xfe08, 0xfe75, 0xfe74,
    0xfe77, 0xfe76, 0xfe71, 0xfe70, 0xfe73, 0xfe72, 0xfe7d, 0xfe7c,
    0xfe7f, 0xfe7e, 0xfe79, 0xfe7b, 0xfe7a, 0xfe64, 0xfe66, 0xfe61,
    0xfe60, 0xfe63, 0xfe6d, 0xfe6c, 0xfe6f, 0xfe6e, 0xfe69, 0xfe68,
    0xfe6b, 0xfe6a, 0xfe54, 0xfe57, 0xfe56, 0xfe51, 0xfe50, 0xfe53,
    0xfe52, 0xfe5d, 0xfe5c, 0xfe5f, 0xfe5e, 0xfe5b, 0xfe45, 0xfe44,
    /* 0xab */
    0xfe47, 0xfe46, 0xfe41, 0xfe40, 0xfe43, 0xfe42, 0xfe4d, 0xfe4c,
    0xfe4f, 0xfe4e, 0xfe49, 0xfe48, 0xfe4a, 0xfeb5, 0xfeb4, 0xfeb7,
    0xfeb6, 0xfeb0, 0xfeb3, 0xfebd, 0xfebf, 0xfeb9, 0xfeb8, 0xfeba,
    0xfea5, 0xfea7, 0xfea6, 0xfea1, 0xfea0, 0xfea2, 0xfead, 0xfeac,
    0xfeaf, 0xfea9, 0xfea8, 0xfeab, 0xfe95, 0xfe94, 0xfe96, 0xfe91,
    0xfe90, 0xfe93, 0xfe92, 0xfe9d, 0xfe9f, 0xfe99, 0xfe98, 0xfe84,
    0xfe81, 0xfe80, 0xfe83, 0xfe8d, 0xfe8c, 0xfe89, 0xfe88, 0xfe8b,
    0xfe8a, 0xfef4, 0xfef6, 0xfef1, 0xfef0, 0xfef3, 0xfef2, 0xfefe,
    0xfef9, 0xfefb, 0xfee7, 0xfee6, 0xfee1, 0xfee0, 0xfee3, 0xfee2,
    0xfeed, 0xfeef, 0xfeee, 0xfee9, 0xfee8, 0xfeea, 0xfed4, 0xfed7,
    0xfed6, 0xfed1, 0xfed3, 0xfedd, 0xfedf, 0xfede, 0xfed9, 0xfedb,
    0xfeda, 0xfec5, 0xfec4, 0xfec6, 0xfec1, 0xfec0, 0xfec3, 0xfec2,
    /* 0xac */
    0xfecd, 0xfecc, 0xfecf, 0xfece, 0xfec9, 0xfec8, 0xfecb, 0xfeca,
    0xf935, 0xf934, 0xf937, 0xf931, 0xf932, 0xf93d, 0xf93e, 0xf939,
    0xf938, 0xf93b, 0xf924, 0xf927, 0xf926, 0xf921, 0xf920, 0xf923,
    0xf922, 0xf92d, 0xf92c, 0xf929, 0xf928, 0xf92b, 0xf92a, 0xf915,
    0xf914, 0xf916, 0xf911, 0xf912, 0xf91c, 0xf91e, 0xf918, 0xf91a,
    0xf904, 0xf907, 0xf902, 0xf90d, 0xf90c, 0xf90f, 0xf90e, 0xf908,
    0xf90b, 0xf90a, 0xf975, 0xf977, 0xf976, 0xf971, 0xf970, 0xf973,
    0xf972, 0xf97d, 0xf97c, 0xf97f, 0xf97e, 0xf979, 0xf978, 0xf97b,
    0xf97a, 0xf965, 0xf964, 0xf967, 0xf966, 0xf961, 0xf963, 0xf96d,
    0xf968, 0xf955, 0xf954, 0xf957, 0xf956, 0xf951, 0xf950, 0xf953,
    0xf952, 0xf95d, 0xf95c, 0xf95f, 0xf95e, 0xf959, 0xf95b, 0xf95a,
    0xf944, 0xf947, 0xf946, 0xf941, 0xf940, 0xf94d, 0xf94c, 0xf94f,
    /* 0xad */
    0xf94e, 0xf949, 0xf948, 0xf94a, 0xf9b7, 0xf9b1, 0xf9b0, 0xf9b3,
    0xf9bd, 0xf9bc, 0xf9bf, 0xf9b9, 0xf9b8, 0xf9ba, 0xf9a4, 0xf9a7,
    0xf9a6, 0xf9a1, 0xf9a0, 0xf9a3, 0xf9a2, 0xf9ad, 0xf9ac, 0xf9af,
    0xf9ae, 0xf9a8, 0xf9aa, 0xf995, 0xf994, 0xf997, 0xf996, 0xf991,
    0xf990, 0xf993, 0xf99f, 0xf99e, 0xf999, 0xf998, 0xf99b, 0xf99a,
    0xf985, 0xf984, 0xf987, 0xf986, 0xf981, 0xf980, 0xf983, 0xf982,
    0xf98d, 0xf98c, 0xf98e, 0xf989, 0xf988, 0xf98b, 0xf98a, 0xf9f5,
    0xf9f4, 0xf9f7, 0xf9f6, 0xf9f1, 0xf9f0, 0xf9f3, 0xf9f2, 0xf9fd,
    0xf9fc, 0xf9ff, 0xf9fe, 0xf9f9, 0xf9f8, 0xf9fb, 0xf9fa, 0xf9e5,
    0xf9e4, 0xf9e6, 0xf9e1, 0xf9e0, 0xf9e3, 0xf9e2, 0xf9ed, 0xf9ec,
    0xf9ef, 0xf9ee, 0xf9e8, 0xf9ea, 0xf9d4, 0xf9d0, 0xf9d2, 0xf9dd,
    0xf9dc, 0xf9df, 0xf9de, 0xf9d9, 0xf9d8, 0xf9c5, 0xf9c4, 0xf9c7,
    /* 0xae */
    0xf9c6, 0xf9c0, 0xf9cd, 0xf9cc, 0xf9cf, 0xf9ce, 0xf9c9, 0xf9c8,
    0xf9cb, 0xf835, 0xf834, 0xf837, 0xf836, 0xf830, 0xf833, 0xf832,
    0xf83d, 0xf83c, 0xf83f, 0xf83e, 0xf839, 0xf83b, 0xf825, 0xf827,
    0xf821, 0xf820, 0xf823, 0xf822, 0xf82e, 0xf828, 0xf82b, 0xf815,
    0xf814, 0xf817, 0xf816, 0xf811, 0xf813, 0xf812, 0xf81f, 0xf81b,
    0xf801, 0xf803, 0xf80c, 0xf809, 0xf808, 0xf80a, 0xf874, 0xf877,
    0xf876, 0xf871, 0xf873, 0xf872, 0xf87c, 0xf87f, 0xf878, 0xf865,
    0xf864, 0xf867, 0xf866, 0xf860, 0xf863, 0xf862, 0xf86d, 0xf868,
    0xf86b, 0xf86a, 0xf855, 0xf854, 0xf857, 0xf856, 0xf851, 0xf852,
    0xf85d, 0xf85c, 0xf85e, 0xf859, 0xf858, 0xf85b, 0xf85a, 0xf845,
    0xf844, 0xf846, 0xf840, 0xf843, 0xf842, 0xf84f, 0xf84e, 0xf849,
    0xf848, 0xf84b, 0xf8b5, 0xf8b4, 0xf8b7, 0xf8b1, 0xf8b0, 0xf8b2,
    /* 0xaf */
    0xf8bd, 0xf8bc, 0xf8bf, 0xf8b9, 0xf8b8, 0xf8bb, 0xf8a5, 0xf8a6,
    0xf8a0, 0xf8ad, 0xf8ae, 0xf8a9, 0xf8ab, 0xf897, 0xf893, 0xf892,
    0xf89d, 0xf89c, 0xf89f, 0xf898, 0xf883, 0xf882, 0xf88f, 0xf88e,
    0xf88a, 0xf8f5, 0xf8f4, 0xf8f3, 0xf8fe, 0xf8f9, 0xf8fb, 0xf8fa,
    0xf8e5, 0xf8e4, 0xf8e6, 0xf8e2, 0xf8ec, 0xf8ef, 0xf8e9, 0xf8e8,
    0xf8ea, 0xf8d5, 0xf8d4, 0xf8d0, 0xf8dc, 0xf8d9, 0xf8d8, 0xf8db,
    0xf8da, 0xf8c7, 0xf8c6, 0xf8c0, 0xf8c3, 0xf8c2, 0xf8cd, 0xf8cf,
    0xf8ce, 0xf8c8, 0xf8cb, 0xfb37, 0xfb31, 0xfb33, 0xfb32, 0xfb3d,
    0xfb3c, 0xfb3e, 0xfb38, 0xfb3b, 0xfb3a, 0xfb24, 0xfb27, 0xfb26,
    0xfb21, 0xfb23, 0xfb2f, 0xfb29, 0xfb28, 0xfb2b, 0xfb14, 0xfb16,
    0xfb12, 0xfb1d, 0xfb19, 0xfb1b, 0xfb1a, 0xfb04, 0xfb07, 0xfb03,
    0xfb02, 0xfb0c, 0xfb0f, 0xfb0e, 0xfb08, 0xfb74, 0xfb77, 0xfb71,
    /* 0xb0 */
    0xfb70, 0xfb73, 0xfb72, 0xfb7d, 0xfb7c, 0xfb7f, 0xfb7e, 0xfb7b,
    0xfb7a, 0xfb65, 0xfb64, 0xfb67, 0xfb66, 0xfb60, 0xfb62, 0xfb6d,
    0xfb6c, 0xfb6f, 0xfb6e, 0xfb68, 0xfb6a, 0xfb55, 0xfb54, 0xfb57,
    0xfb51, 0xfb50, 0xfb53, 0xfb52, 0xfb5d, 0xfb5c, 0xfb5f, 0xfb59,
    0xfb58, 0xfb5b, 0xfb45, 0xfb44, 0xfb47, 0xfb46, 0xfb41, 0xfb40,
    0xfb43, 0xfb42, 0xfb4c, 0xfb4f, 0xfb49, 0xfb4a, 0xfbb5, 0xfbb4,
    0xfbb6, 0xfbb0, 0xfbbc, 0xfbbf, 0xfbb9, 0xfbb8, 0xfbba, 0xfba5,
    0xfba7, 0xfba1, 0xfba0, 0xfba2, 0xfbad, 0xfbaf, 0xfbae, 0xfba9,
    0xfba8, 0xfbab, 0xfbaa, 0xfb95, 0xfb94, 0xfb97, 0xfb96, 0xfb90,
    0xfb93, 0xfb92, 0xfb9d, 0xfb9c, 0xfb9f, 0xfb9e, 0xfb99, 0xfb98,
    0xfb9a, 0xfb85, 0xfb86, 0xfb80, 0xfb83, 0xfb82, 0xfb8d, 0xfb8c,
    0xfb8f, 0xfb8e, 0xfb89, 0xfb88, 0xfb8b, 0xfbf5, 0xfbf4, 0xfbf6,
    /* 0xb1 */
    0xfbf1, 0xfbf2, 0xfbfc, 0xfbfe, 0xfbf9, 0xfbe6, 0xfbe0, 0xfbec,
    0xfbef, 0xfbe9, 0xfbe8, 0xfbeb, 0xfbd5, 0xfbd4, 0xfbd7, 0xfbd6,
    0xfbd1, 0xfbd3, 0xfbd2, 0xfbdd, 0xfbdc, 0xfbdf, 0xfbde, 0xfbd9,
    0xfbd8, 0xfbc5, 0xfbc6, 0xfbc0, 0xfbc3, 0xfbc2, 0xfbcf, 0xfbce,
    0xfbc8, 0xfbca, 0xfa35, 0xfa37, 0xfa36, 0xfa30, 0xfa33, 0xfa3f,
    0xfa39, 0xfa3b, 0xfa3a, 0xfa25, 0xfa24, 0xfa27, 0xfa26, 0xfa21,
    0xfa20, 0xfa23, 0xfa22, 0xfa2d, 0xfa2e, 0xfa29, 0xfa28, 0xfa2b,
    0xfa14, 0xfa16, 0xfa11, 0xfa10, 0xfa12, 0xfa1f, 0xfa1e, 0xfa19,
    0xfa1b, 0xfa05, 0xfa04, 0xfa07, 0xfa06, 0xfa01, 0xfa0c, 0xfa0e,
    0xfa08, 0xfa0b, 0xfa0a, 0xfa77, 0xfa71, 0xfa70, 0xfa73, 0xfa7d,
    0xfa7c, 0xfa7f, 0xfa7e, 0xfa79, 0xfa78, 0xfa7b, 0xfa7a, 0xfa67,
    0xfa66, 0xfa61, 0xfa60, 0xfa63, 0xfa62, 0xfa6d, 0xfa6c, 0xfa69,
    /* 0xb2 */
    0xfa68, 0xfa6b, 0xfa6a, 0xfa55, 0xfa51, 0xfa52, 0xfa5c, 0xfa5f,
    0xfa58, 0xfa5b, 0xfa5a, 0xfa45, 0xfa44, 0xfa47, 0xfa46, 0xfa41,
    0xfa40, 0xfa43, 0xfa42, 0xfa4d, 0xfa4f, 0xfa4e, 0xfa49, 0xfab4,
    0xfab7, 0xfab6, 0xfab3, 0xfab2, 0xfabd, 0xfabc, 0xfabf, 0xfabe,
    0xfaba, 0xfaa5, 0xfaa6, 0xfaa1, 0xfaa0, 0xfaa3, 0xfaa2, 0xfaad,
    0xfaac, 0xfaaf, 0xfaae, 0xfaa9, 0xfaa8, 0xfaab, 0xfa94, 0xfa96,
    0xfa91, 0xfa93, 0xfa9d, 0xfa9e, 0xfa98, 0xfa9b, 0xfa9a, 0xfa84,
    0xfa87, 0xfa81, 0xfa83, 0xfa82, 0xfa8d, 0xfa8c, 0xfa8f, 0xfa89,
    0xfa8b, 0xfaf5, 0xfaf4, 0xfaf7, 0xfaf6, 0xfaf1, 0xfaf0, 0xfaf3,
    0xfaf2, 0xfafd, 0xfafc, 0xfaff, 0xfafe, 0xfaf9, 0xfafb, 0xfafa,
    0xfae5, 0xfae4, 0xfae7, 0xfae6, 0xfae1, 0xfae0, 0xfae3, 0xfaed,
    0xfaec, 0xfaef, 0xfae8, 0xfaeb, 0xfaea, 0xfad5, 0xfad4, 0xfad1,
    /* 0xb3 */
    0xfad3, 0xfadd, 0xfadf, 0xfada, 0xfac5, 0xfac4, 0xfac7, 0xfac1,
    0xfac0, 0xfac2, 0xfacc, 0xfacf, 0xface, 0xfac9, 0xf536, 0xf531,
    0xf530, 0xf533, 0xf532, 0xf53d, 0xf53f, 0xf53e, 0xf53b, 0xf53a,
    0xf525, 0xf526, 0xf520, 0xf52c, 0xf52e, 0xf52b, 0xf515, 0xf514,
    0xf517, 0xf511, 0xf51d, 0xf51f, 0xf51e, 0xf51b, 0xf51a, 0xf504,
    0xf507, 0xf506, 0xf500, 0xf503, 0xf508, 0xf50a, 0xf574, 0xf577,
    0xf576, 0xf571, 0xf573, 0xf57d, 0xf57c, 0xf57f, 0xf57e, 0xf578,
    0xf57a, 0xf564, 0xf566, 0xf561, 0xf56d, 0xf56c, 0xf56f, 0xf56e,
    0xf569, 0xf56b, 0xf56a, 0xf555, 0xf554, 0xf557, 0xf556, 0xf551,
    0xf550, 0xf553, 0xf552, 0xf55d, 0xf55c, 0xf55a, 0xf545, 0xf544,
    0xf547, 0xf546, 0xf541, 0xf540, 0xf543, 0xf54d, 0xf54c, 0xf54f,
    0xf54e, 0xf548, 0xf54b, 0xf54a, 0xf5b5, 0xf5b4, 0xf5b7, 0xf5b6,
    /* 0xb4 */
    0xf5b1, 0xf5b0, 0xf5b3, 0xf5bd, 0xf5bf, 0xf5be, 0xf5ba, 0xf5a5,
    0xf5a7, 0xf5a1, 0xf5a0, 0xf5a3, 0xf5ac, 0xf5a8, 0xf5ab, 0xf595,
    0xf597, 0xf591, 0xf593, 0xf59d, 0xf59c, 0xf59f, 0xf59e, 0xf599,
    0xf598, 0xf59b, 0xf59a, 0xf580, 0xf583, 0xf582, 0xf58d, 0xf58f,
    0xf58e, 0xf589, 0xf588, 0xf58a, 0xf5f5, 0xf5f7, 0xf5f6, 0xf5f1,
    0xf5f3, 0xf5f2, 0xf5fd, 0xf5f9, 0xf5f8, 0xf5fb, 0xf5fa, 0xf5e4,
    0xf5e7, 0xf5e6, 0xf5e3, 0xf5e2, 0xf5ed, 0xf5ef, 0xf5ee, 0xf5e9,
    0xf5e8, 0xf5eb, 0xf5ea, 0xf5d5, 0xf5d4, 0xf5d7, 0xf5d6, 0xf5d1,
    0xf5d0, 0xf5d3, 0xf5d2, 0xf5dc, 0xf5df, 0xf5de, 0xf5d8, 0xf5db,
    0xf5da, 0xf5c5, 0xf5c4, 0xf5c6, 0xf5c0, 0xf5c3, 0xf5cd, 0xf5cc,
    0xf5ce, 0xf5c9, 0xf5c8, 0xf5cb, 0xf5ca, 0xf435, 0xf437, 0xf436,
    0xf431, 0xf433, 0xf432, 0xf43d, 0xf43c, 0xf43f, 0xf43e, 0xf439,
    /* 0xb5 */
    0xf438, 0xf43b, 0xf43a, 0xf425, 0xf424, 0xf427, 0xf421, 0xf420,
    0xf423, 0xf422, 0xf42d, 0xf42c, 0xf42f, 0xf42e, 0xf429, 0xf428,
    0xf42a, 0xf415, 0xf414, 0xf417, 0xf416, 0xf410, 0xf413, 0xf412,
    0xf41d, 0xf41c, 0xf41f, 0xf41e, 0xf419, 0xf418, 0xf41b, 0xf41a,
    0xf405, 0xf404, 0xf407, 0xf406, 0xf400, 0xf403, 0xf402, 0xf40d,
    0xf40c, 0xf408, 0xf40a, 0xf477, 0xf476, 0xf471, 0xf470, 0xf472,
    0xf47f, 0xf47e, 0xf479, 0xf478, 0xf47b, 0xf47a, 0xf465, 0xf464,
    0xf467, 0xf461, 0xf460, 0xf46d, 0xf46c, 0xf454, 0xf456, 0xf451,
    0xf453, 0xf45c, 0xf45f, 0xf45e, 0xf459, 0xf45b, 0xf445, 0xf444,
    0xf447, 0xf446, 0xf441, 0xf440, 0xf443, 0xf44c, 0xf44e, 0xf449,
    0xf448, 0xf44b, 0xf44a, 0xf4b7, 0xf4b6, 0xf4b3, 0xf4b2, 0xf4bd,
    0xf4bc, 0xf4be, 0xf4b9, 0xf4b8, 0xf4bb, 0xf4a5, 0xf4a4, 0xf4a7,
    /* 0xb6 */
    0xf4a6, 0xf4a1, 0xf4a0, 0xf4a3, 0xf4a2, 0xf4ad, 0xf4ac, 0xf4ae,
    0xf4a9, 0xf4a8, 0xf4ab, 0xf4aa, 0xf495, 0xf494, 0xf497, 0xf496,
    0xf491, 0xf490, 0xf493, 0xf49d, 0xf49c, 0xf49f, 0xf49e, 0xf499,
    0xf498, 0xf49b, 0xf49a, 0xf485, 0xf484, 0xf487, 0xf481, 0xf480,
    0xf483, 0xf482, 0xf48d, 0xf489, 0xf48a, 0xf4f7, 0xf4f1, 0xf4f0,
    0xf4f2, 0xf4fd, 0xf4ff, 0xf4f9, 0xf4fb, 0xf4fa, 0xf4e5, 0xf4e6,
    0xf4e1, 0xf4e3, 0xf4e2, 0xf4ec, 0xf4ef, 0xf4ee, 0xf4e9, 0xf4e8,
    0xf4eb, 0xf4d5, 0xf4d4, 0xf4d7, 0xf4d0, 0xf4dd, 0xf4df, 0xf4d9,
    0xf4db, 0xf4c4, 0xf4c7, 0xf4c6, 0xf4c1, 0xf4c0, 0xf4c3, 0xf4c2,
    0xf4cc, 0xf4cf, 0xf4c9, 0xf4cb, 0xf4ca, 0xf734, 0xf731, 0xf730,
    0xf732, 0xf73d, 0xf73c, 0xf73f, 0xf739, 0xf73a, 0xf725, 0xf724,
    0xf727, 0xf726, 0xf720, 0xf723, 0xf72d, 0xf72c, 0xf72e, 0xf729,
    /* 0xb7 */
    0xf728, 0xf72a, 0xf714, 0xf717, 0xf711, 0xf710, 0xf713, 0xf712,
    0xf71d, 0xf71c, 0xf71f, 0xf71e, 0xf719, 0xf718, 0xf71b, 0xf71a,
    0xf705, 0xf704, 0xf707, 0xf701, 0xf700, 0xf703, 0xf70d, 0xf70f,
    0xf70b, 0xf775, 0xf774, 0xf777, 0xf776, 0xf771, 0xf770, 0xf772,
    0xf77d, 0xf77c, 0xf77f, 0xf77e, 0xf779, 0xf778, 0xf77b, 0xf77a,
    0xf765, 0xf767, 0xf766, 0xf761, 0xf760, 0xf763, 0xf76d, 0xf76c,
    0xf76f, 0xf76e, 0xf769, 0xf768, 0xf76b, 0xf76a, 0xf755, 0xf754,
    0xf757, 0xf756, 0xf751, 0xf750, 0xf753, 0xf752, 0xf75d, 0xf75c,
    0xf75f, 0xf75e, 0xf759, 0xf758, 0xf75b, 0xf75a, 0xf744, 0xf747,
    0xf746, 0xf740, 0xf74e, 0xf749, 0xf748, 0xf74b, 0xf7b7, 0xf7b0,
    0xf7b2, 0xf7bc, 0xf7bf, 0xf7be, 0xf7b9, 0xf7bb, 0xf7ba, 0xf7a5,
    0xf7a6, 0xf7a1, 0xf7ac, 0xf7af, 0xf7ae, 0xf7ab, 0xf794, 0xf797,
    /* 0xb8 */
    0xf796, 0xf791, 0xf792, 0xf79c, 0xf79f, 0xf79e, 0xf79b, 0xf79a,
    0xf785, 0xf784, 0xf787, 0xf781, 0xf780, 0xf783, 0xf782, 0xf78d,
    0xf78c, 0xf78f, 0xf78e, 0xf789, 0xf788, 0xf78b, 0xf7f5, 0xf7f4,
    0xf7f7, 0xf7f6, 0xf7f1, 0xf7f0, 0xf7f3, 0xf7f2, 0xf7fd, 0xf7fc,
    0xf7ff, 0xf7f9, 0xf7f8, 0xf7fb, 0xf7fa, 0xf7e5, 0xf7e4, 0xf7e7,
    0xf7e6, 0xf7e1, 0xf7e0, 0xf7e2, 0xf7ed, 0xf7ef, 0xf7ee, 0xf7e9,
    0xf7e8, 0xf7d4, 0xf7d7, 0xf7d1, 0xf7d2, 0xf7dd, 0xf7dc, 0xf7df,
    0xf7de, 0xf7d9, 0xf7db, 0xf7c5, 0xf7c4, 0xf7c7, 0xf7c6, 0xf7c1,
    0xf7c0, 0xf7c3, 0xf7c2, 0xf7cd, 0xf7ce, 0xf7c9, 0xf7cb, 0xf635,
    0xf634, 0xf637, 0xf630, 0xf632, 0xf63c, 0xf639, 0xf638, 0xf63b,
    0xf625, 0xf627, 0xf626, 0xf623, 0xf622, 0xf62d, 0xf62f, 0xf629,
    0xf628, 0xf62a, 0xf614, 0xf617, 0xf616, 0xf612, 0xf61c, 0xf618,
    /* 0xb9 */
    0xf61a, 0xf605, 0xf607, 0xf601, 0xf600, 0xf603, 0xf602, 0xf60c,
    0xf60e, 0xf608, 0xf60a, 0xf675, 0xf674, 0xf677, 0xf676, 0xf671,
    0xf673, 0xf67d, 0xf67f, 0xf678, 0xf67b, 0xf666, 0xf660, 0xf662,
    0xf66c, 0xf669, 0xf66b, 0xf66a, 0xf654, 0xf656, 0xf651, 0xf650,
    0xf653, 0xf652, 0xf65d, 0xf65c, 0xf65f, 0xf65e, 0xf659, 0xf658,
    0xf65a, 0xf645, 0xf646, 0xf641, 0xf643, 0xf64d, 0xf64f, 0xf649,
    0xf648, 0xf64a, 0xf6b4, 0xf6b7, 0xf6b6, 0xf6b1, 0xf6b3, 0xf6b2,
    0xf6bd, 0xf6bc, 0xf6bf, 0xf6be, 0xf6b9, 0xf6bb, 0xf6ba, 0xf6a4,
    0xf6a7, 0xf6a6, 0xf6a3, 0xf6ad, 0xf6ac, 0xf6af, 0xf6ae, 0xf6ab,
    0xf6aa, 0xf695, 0xf696, 0xf691, 0xf690, 0xf69b, 0xf69a, 0xf685,
    0xf687, 0xf686, 0xf680, 0xf683, 0xf682, 0xf68c, 0xf68f, 0xf68e,
    0xf689, 0xf688, 0xf68b, 0xf68a, 0xf6f5, 0xf6f7, 0xf6f6, 0xf6f1,
    /* 0xba */
    0xf6f0, 0xf6fd, 0xf6fc, 0xf6ff, 0xf6fe, 0xf6f8, 0xf6fb, 0xf6fa,
    0xf6e5, 0xf6e7, 0xf6e1, 0xf6e0, 0xf6e3, 0xf6e2, 0xf6ed, 0xf6ee,
    0xf6e9, 0xf6eb, 0xf6ea, 0xf6d5, 0xf6d7, 0xf6d6, 0xf6d1, 0xf6d2,
    0xf6dd, 0xf6dc, 0xf6de, 0xf6d9, 0xf6d8, 0xf6da, 0xf6c5, 0xf6c7,
    0xf6c6, 0xf6c1, 0xf6c0, 0xf6c3, 0xf6cd, 0xf6cc, 0xf6cf, 0xf6ce,
    0xf6c8, 0xf6ca, 0xf135, 0xf134, 0xf137, 0xf136, 0xf131, 0xf130,
    0xf133, 0xf13d, 0xf13c, 0xf13f, 0xf138, 0xf13b, 0xf125, 0xf124,
    0xf127, 0xf126, 0xf121, 0xf120, 0xf122, 0xf12d, 0xf12c, 0xf12f,
    0xf12e, 0xf129, 0xf128, 0xf12b, 0xf115, 0xf114, 0xf117, 0xf116,
    0xf111, 0xf110, 0xf11d, 0xf11c, 0xf11e, 0xf119, 0xf118, 0xf11b,
    0xf11a, 0xf105, 0xf104, 0xf107, 0xf106, 0xf101, 0xf100, 0xf103,
    0xf102, 0xf10c, 0xf10f, 0xf10e, 0xf109, 0xf108, 0xf10b, 0xf177,
    /* 0xbb */
    0xf176, 0xf171, 0xf170, 0xf173, 0xf172, 0xf17d, 0xf17c, 0xf17f,
    0xf17e, 0xf179, 0xf17b, 0xf17a, 0xf165, 0xf164, 0xf167, 0xf166,
    0xf161, 0xf160, 0xf163, 0xf162, 0xf16d, 0xf16c, 0xf16f, 0xf16e,
    0xf169, 0xf168, 0xf16b, 0xf16a, 0xf155, 0xf154, 0xf157, 0xf156,
    0xf151, 0xf150, 0xf153, 0xf152, 0xf15d, 0xf15c, 0xf15f, 0xf15e,
    0xf159, 0xf158, 0xf15b, 0xf15a, 0xf145, 0xf144, 0xf147, 0xf140,
    0xf143, 0xf142, 0xf14d, 0xf14c, 0xf14f, 0xf14b, 0xf14a, 0xf1b5,
    0xf1b4, 0xf1b7, 0xf1b6, 0xf1b1, 0xf1b0, 0xf1b3, 0xf1b2, 0xf1bd,
    0xf1bf, 0xf1be, 0xf1b9, 0xf1b8, 0xf1bb, 0xf1ba, 0xf1a5, 0xf1a6,
    0xf1a1, 0xf1a3, 0xf1ac, 0xf1af, 0xf1ae, 0xf195, 0xf194, 0xf196,
    0xf193, 0xf192, 0xf19d, 0xf19c, 0xf19e, 0xf199, 0xf198, 0xf19a,
    0xf185, 0xf181, 0xf180, 0xf183, 0xf182, 0xf18d, 0xf18f, 0xf18e,
    /* 0xbc */
    0xf18a, 0xf1f5, 0xf1f7, 0xf1f6, 0xf1f1, 0xf1f3, 0xf1fc, 0xf1fe,
    0xf1fb, 0xf1fa, 0xf1e5, 0xf1e4, 0xf1e7, 0xf1e6, 0xf1e1, 0xf1ed,
    0xf1ef, 0xf1ee, 0xf1e8, 0xf1eb, 0xf1d4, 0xf1d7, 0xf1d6, 0xf1d1,
    0xf1d0, 0xf1d3, 0xf1d2, 0xf1dc, 0xf1df, 0xf1de, 0xf1d9, 0xf1d8,
    0xf1db, 0xf1c5, 0xf1c4, 0xf1c7, 0xf1c6, 0xf1c1, 0xf1c0, 0xf1c3,
    0xf1c2, 0xf1cc, 0xf1cf, 0xf1c9, 0xf1c8, 0xf1cb, 0xf1ca, 0xf035,
    0xf034, 0xf037, 0xf036, 0xf031, 0xf030, 0xf033, 0xf032, 0xf03d,
    0xf03c, 0xf03e, 0xf039, 0xf038, 0xf03b, 0xf03a, 0xf025, 0xf024,
    0xf027, 0xf026, 0xf021, 0xf020, 0xf023, 0xf022, 0xf02d, 0xf02c,
    0xf02f, 0xf02e, 0xf029, 0xf028, 0xf02b, 0xf02a, 0xf014, 0xf016,
    0xf011, 0xf010, 0xf013, 0xf01d, 0xf01c, 0xf01f, 0xf019, 0xf018,
    0xf01b, 0xf005, 0xf004, 0xf007, 0xf006, 0xf001, 0xf000, 0xf003,
    /* 0xbd */
    0xf002, 0xf00d, 0xf00c, 0xf00f, 0xf00e, 0xf009, 0xf008, 0xf00b,
    0xf00a, 0xf075, 0xf074, 0xf077, 0xf076, 0xf071, 0xf070, 0xf073,
    0xf072, 0xf07d, 0xf07c, 0xf07f, 0xf07e, 0xf079, 0xf078, 0xf07b,
    0xf07a, 0xf065, 0xf064, 0xf067, 0xf066, 0xf061, 0xf060, 0xf063,
    0xf062, 0xf06d, 0xf06c, 0xf06f, 0xf06e, 0xf069, 0xf068, 0xf06b,
    0xf06a, 0xf055, 0xf054, 0xf057, 0xf056, 0xf051, 0xf050, 0xf053,
    0xf052, 0xf05d, 0xf05c, 0xf05f, 0xf05e, 0xf059, 0xf058, 0xf05a,
    0xf045, 0xf044, 0xf047, 0xf046, 0xf041, 0xf040, 0xf043, 0xf04d,
    0xf04c, 0xf04f, 0xf04e, 0xf049, 0xf048, 0xf04b, 0xf04a, 0xf0b5,
    0xf0b4, 0xf0b7, 0xf0b6, 0xf0b1, 0xf0b0, 0xf0b3, 0xf0b2, 0xf0bd,
    0xf0bc, 0xf0bf, 0xf0be, 0xf0b9, 0xf0b8, 0xf0bb, 0xf0ba, 0xf0a5,
    0xf0a4, 0xf0a7, 0xf0a6, 0xf0a1, 0xf0a0, 0xf0a3, 0xf0a2, 0xf0ad,
    /* 0xbe */
    0xf0ac, 0xf0af, 0xf0ae, 0xf0a9, 0xf0a8, 0xf0ab, 0xf0aa, 0xf095,
    0xf094, 0xf097, 0xf096, 0xf091, 0xf090, 0xf092, 0xf09d, 0xf09c,
    0xf09f, 0xf09e, 0xf099, 0xf098, 0xf09a, 0xf085, 0xf084, 0xf087,
    0xf086, 0xf081, 0xf080, 0xf083, 0xf082, 0xf08d, 0xf08c, 0xf08f,
    0xf08e, 0xf089, 0xf088, 0xf08b, 0xf08a, 0xf0f5, 0xf0f4, 0xf0f7,
    0xf0f6, 0xf0f1, 0xf0f0, 0xf0f3, 0xf0f2, 0xf0fd, 0xf0fc, 0xf0ff,
    0xf0fe, 0xf0f9, 0xf0f8, 0xf0fb, 0xf0fa, 0xf0e5, 0xf0e4, 0xf0e7,
    0xf0e6, 0xf0e1, 0xf0e0, 0xf0e3, 0xf0e2, 0xf0ed, 0xf0ec, 0xf0ef,
    0xf0ee, 0xf0e9, 0xf0e8, 0xf0eb, 0xf0ea, 0xf0d5, 0xf0d4, 0xf0d7,
    0xf0d6, 0xf0d1, 0xf0d0, 0xf0d3, 0xf0d2, 0xf0dd, 0xf0dc, 0xf0df,
    0xf0de, 0xf0d9, 0xf0d8, 0xf0db, 0xf0da, 0xf0c5, 0xf0c4, 0xf0c7,
    0xf0c6, 0xf0c1, 0xf0c0, 0xf0c3, 0xf0c2, 0xf0cd, 0xf0cc, 0xf0cf,
    /* 0xbf */
    0xf0ce, 0xf0c9, 0xf0c8, 0xf0cb, 0xf0ca, 0xf335, 0xf334, 0xf337,
    0xf336, 0xf331, 0xf330, 0xf333, 0xf332, 0xf33d, 0xf33c, 0xf33f,
    0xf33e, 0xf339, 0xf338, 0xf33b, 0xf33a, 0xf325, 0xf324, 0xf327,
    0xf326, 0xf321, 0xf320, 0xf323, 0xf322, 0xf32d, 0xf32c, 0xf32f,
    0xf32e, 0xf329, 0xf328, 0xf32b, 0xf32a, 0xf315, 0xf314, 0xf317,
    0xf316, 0xf311, 0xf310, 0xf313, 0xf312, 0xf31d, 0xf31c, 0xf31f,
    0xf31e, 0xf319, 0xf318, 0xf31b, 0xf31a, 0xf305, 0xf304, 0xf307,
    0xf306, 0xf301, 0xf300, 0xf303, 0xf302, 0xf30d, 0xf30c, 0xf30f,
    0xf309, 0xf308, 0xf30b, 0xf30a, 0xf375, 0xf377, 0xf376, 0xf371,
    0xf370, 0xf373, 0xf37d, 0xf37c, 0xf37f, 0xf37e, 0xf379, 0xf378,
    0xf37b, 0xf37a, 0xf365, 0xf364, 0xf367, 0xf366, 0xf361, 0xf360,
    0xf363, 0xf362, 0xf36d, 0xf36c, 0xf36f, 0xf36e, 0xf369, 0xf368,
    /* 0xc0 */
    0xf36b, 0xf36a, 0xf355, 0xf354, 0xf357, 0xf356, 0xf351, 0xf350,
    0xf353, 0xf352, 0xf35d, 0xf35c, 0xf35f, 0xf35e, 0xf359, 0xf358,
    0xf35b, 0xf35a, 0xf345, 0xf344, 0xf347, 0xf346, 0xf341, 0xf340,
    0xf343, 0xf342, 0xf34d, 0xf34c, 0xf34f, 0xf34e, 0xf349, 0xf348,
    0xf34b, 0xf34a, 0xf3b5, 0xf3b4, 0xf3b6, 0xf3b1, 0xf3b0, 0xf3b3,
    0xf3b2, 0xf3bd, 0xf3bc, 0xf3bf, 0xf3be, 0xf3b9, 0xf3b8, 0xf3bb,
    0xf3ba, 0xf3a5, 0xf3a4, 0xf3a7, 0xf3a6, 0xf3a1, 0xf3a0, 0xf3a3,
    0xf3a2, 0xf3ad, 0xf3ac, 0xf3af, 0xf3a9, 0xf3a8, 0xf3ab, 0xf39b,
    0xf381, 0xf38e, 0xf389, 0xf3e3, 0xf3d1, 0xf3d9, 0xf3cc, 0xf23f,
    0xf225, 0xf22b, 0xf202, 0xf20c, 0xf20e, 0xf209, 0xf208, 0xf20b,
    0xf20a, 0xf275, 0xf274, 0xf276, 0xf273, 0xf272, 0xf27d, 0xf27c,
    0xf27f, 0xf27e, 0xf279, 0xf278, 0xf27b, 0xf27a, 0xf267, 0xf266,
    /* 0xc1 */
    0xf263, 0xf26c, 0xf26e, 0xf269, 0xf268, 0xf26b, 0xf255, 0xf256,
    0xf251, 0xf250, 0xf253, 0xf252, 0xf25e, 0xf259, 0xf258, 0xf25a,
    0xf245, 0xf246, 0xf240, 0xf243, 0xf242, 0xf24d, 0xf24f, 0xf24e,
    0xf249, 0xf248, 0xf24a, 0xf2b5, 0xf2b7, 0xf2b6, 0xf2b1, 0xf2b0,
    0xf2b3, 0xf2b2, 0xf2bd, 0xf2bc, 0xf2be, 0xf2b8, 0xf2ba, 0xf2a5,
    0xf2a4, 0xf2a7, 0xf2a6, 0xf2a0, 0xf2a3, 0xf2a2, 0xf2ad, 0xf2ac,
    0xf2ae, 0xf2a9, 0xf295, 0xf297, 0xf296, 0xf290, 0xf293, 0xf29d,
    0xf29c, 0xf29f, 0xf29e, 0xf299, 0xf298, 0xf29b, 0xf284, 0xf286,
    0xf281, 0xf280, 0xf283, 0xf282, 0xf28f, 0xf28e, 0xf28b, 0xf2f5,
    0xf2f7, 0xf2f6, 0xf2f1, 0xf2f3, 0xf2f2, 0xf2fd, 0xf2fc, 0xf2fe,
    0xf2f8, 0xf2fa, 0xf2e5, 0xf2e4, 0xf2e7, 0xf2e6, 0xf2e3, 0xf2e2,
    0xf2ec, 0xf2ef, 0xf2ee, 0xf2e9, 0xf2e8, 0xf2eb, 0xf2d7, 0xf2d6,
    /* 0xc2 */
    0xf2d1, 0xf2d2, 0xf2dd, 0xf2df, 0xf2de, 0xf2d9, 0xf2d8, 0xf2da,
    0xf2c7, 0xf2c1, 0xf2c0, 0xf2c3, 0xf2c2, 0xf2cd, 0xf2cc, 0xf2cf,
    0xf2c8, 0xf2cb, 0xf2ca, 0x0d37, 0x0d32, 0x0d3d, 0x0d3c, 0x0d3f,
    0x0d3b, 0x0d3a, 0x0d24, 0x0d26, 0x0d2f, 0x0d2e, 0x0d28, 0x0d2b,
    0x0d2a, 0x0d14, 0x0d16, 0x0d11, 0x0d1e, 0x0d19, 0x0d18, 0x0d1b,
    0x0d1a, 0x0d05, 0x0d07, 0x0d01, 0x0d0c, 0x0d0f, 0x0d09, 0x0d0b,
    0x0d75, 0x0d74, 0x0d71, 0x0d70, 0x0d72, 0x0d7d, 0x0d7c, 0x0d7b,
    0x0d7a, 0x0d65, 0x0d64, 0x0d66, 0x0d60, 0x0d63, 0x0d62, 0x0d6c,
    0x0d6e, 0x0d69, 0x0d68, 0x0d6b, 0x0d6a, 0x0d55, 0x0d54, 0x0d57,
    0x0d56, 0x0d51, 0x0d50, 0x0d53, 0x0d52, 0x0d5d, 0x0d5e, 0x0d59,
    0x0d58, 0x0d5b, 0x0d5a, 0x0d45, 0x0d47, 0x0d46, 0x0d41, 0x0d40,
    0x0d43, 0x0d42, 0x0d4d, 0x0d4c, 0x0d4f, 0x0d4e, 0x0d49, 0x0d48,
    /* 0xc3 */
    0x0d4b, 0x0db4, 0x0db7, 0x0db0, 0x0dbd, 0x0dbf, 0x0db8, 0x0dbb,
    0x0dba, 0x0da5, 0x0da4, 0x0da7, 0x0da1, 0x0da0, 0x0da2, 0x0dac,
    0x0dab, 0x0d96, 0x0d93, 0x0d92, 0x0d9d, 0x0d99, 0x0d85, 0x0d86,
    0x0d80, 0x0d83, 0x0d8d, 0x0d8c, 0x0d8e, 0x0df0, 0x0df2, 0x0dfd,
    0x0dfc, 0x0dff, 0x0dfe, 0x0dfa, 0x0de5, 0x0de4, 0x0de7, 0x0de6,
    0x0de1, 0x0de0, 0x0ded, 0x0dea, 0x0dd5, 0x0dd7, 0x0dd6, 0x0dd3,
    0x0ddb, 0x0dc0, 0x0dc2, 0x0dcc, 0x0dce, 0x0dcb, 0x0dca, 0x0c35,
    0x0c34, 0x0c36, 0x0c31, 0x0c30, 0x0c32, 0x0c3d, 0x0c3e, 0x0c39,
    0x0c20, 0x0c22, 0x0c2c, 0x0c2e, 0x0c29, 0x0c28, 0x0c2a, 0x0c15,
    0x0c14, 0x0c17, 0x0c16, 0x0c11, 0x0c10, 0x0c13, 0x0c12, 0x0c1d,
    0x0c1c, 0x0c1f, 0x0c1e, 0x0c18, 0x0c1b, 0x0c05, 0x0c06, 0x0c01,
    0x0c00, 0x0c02, 0x0c0c, 0x0c0f, 0x0c0e, 0x0c09, 0x0c08, 0x0c0a,
    /* 0xc4 */
    0x0c75, 0x0c74, 0x0c77, 0x0c76, 0x0c71, 0x0c70, 0x0c72, 0x0c7c,
    0x0c78, 0x0c7b, 0x0c7a, 0x0c67, 0x0c63, 0x0c62, 0x0c6d, 0x0c6e,
    0x0c69, 0x0c68, 0x0c6b, 0x0c6a, 0x0c54, 0x0c57, 0x0c56, 0x0c51,
    0x0c53, 0x0c5d, 0x0c5f, 0x0c5e, 0x0c59, 0x0c5a, 0x0c47, 0x0c46,
    0x0c40, 0x0c43, 0x0c42, 0x0c4d, 0x0cb4, 0x0cb6, 0x0cb1, 0x0cb0,
    0x0cb3, 0x0cb2, 0x0cbc, 0x0cbe, 0x0cb9, 0x0cb8, 0x0cbb, 0x0ca5,
    0x0ca7, 0x0ca6, 0x0ca1, 0x0ca0, 0x0ca3, 0x0ca2, 0x0cac, 0x0caf,
    0x0cab, 0x0caa, 0x0c95, 0x0c94, 0x0c97, 0x0c91, 0x0c90, 0x0c92,
    0x0c9c, 0x0c9e, 0x0c99, 0x0c98, 0x0c9b, 0x0c9a, 0x0c85, 0x0c84,
    0x0c87, 0x0c81, 0x0c80, 0x0c83, 0x0c82, 0x0c8d, 0x0c8c, 0x0c89,
    0x0c88, 0x0c8b, 0x0c8a, 0x0cf1, 0x0cf0, 0x0cf2, 0x0cfd, 0x0cfc,
    0x0cfe, 0x0cf8, 0x0cfb, 0x0cfa, 0x0ce5, 0x0ce4, 0x0ce7, 0x0ce6,
    /* 0xc5 */
    0x0ce1, 0x0ce0, 0x0ce3, 0x0ce2, 0x0ced, 0x0cec, 0x0cef, 0x0cee,
    0x0ce9, 0x0ce8, 0x0ceb, 0x0cea, 0x0cd5, 0x0cd4, 0x0cd7, 0x0cd1,
    0x0cd0, 0x0cd3, 0x0cdd, 0x0cdc, 0x0cde, 0x0cdb, 0x0cda, 0x0cc5,
    0x0cc4, 0x0cc7, 0x0cc0, 0x0cc3, 0x0cc2, 0x0ccd, 0x0ccc, 0x0ccf,
    0x0cc8, 0x0cca, 0x0f36, 0x0f32, 0x0f3d, 0x0f3c, 0x0f3f, 0x0f3e,
    0x0f3b, 0x0f3a, 0x0f24, 0x0f26, 0x0f20, 0x0f23, 0x0f22, 0x0f2d,
    0x0f2c, 0x0f2f, 0x0f28, 0x0f15, 0x0f11, 0x0f10, 0x0f13, 0x0f12,
    0x0f1c, 0x0f1b, 0x0f07, 0x0f0f, 0x0f09, 0x0f08, 0x0f0a, 0x0f75,
    0x0f74, 0x0f77, 0x0f76, 0x0f70, 0x0f73, 0x0f7d, 0x0f7f, 0x0f79,
    0x0f78, 0x0f7b, 0x0f65, 0x0f64, 0x0f67, 0x0f66, 0x0f61, 0x0f60,
    0x0f63, 0x0f62, 0x0f6c, 0x0f6e, 0x0f69, 0x0f68, 0x0f6b, 0x0f55,
    0x0f54, 0x0f57, 0x0f56, 0x0f51, 0x0f50, 0x0f53, 0x0f52, 0x0f5c,
    /* 0xc6 */
    0x0f5f, 0x0f5e, 0x0f59, 0x0f58, 0x0f44, 0x0f40, 0x0f43, 0x0f42,
    0x0f4d, 0x0f4e, 0x0f49, 0x0fb5, 0x0fb4, 0x0fb6, 0x0fb0, 0x0fb3,
    0x0fb2, 0x0fbc, 0x0fb9, 0x0fa5, 0x0fa6, 0x0fa1, 0x0fa0, 0x0fa3,
    0x0faf, 0x0fae, 0x0fab, 0x0f95, 0x0f97, 0x0f96, 0x0f92, 0x0f87,
    0x0f80, 0x0f83, 0x0f8f, 0x0f8e, 0x0f89, 0x0f8a, 0x0ff5, 0x0ff7,
    0x0ff6, 0x0ff0, 0x0ff3, 0x0ffc, 0x0fe5, 0x0fe3, 0x0fec, 0x0fef,
    0x0fe8, 0x0fd7, 0x0fd2, 0x0fdd, 0x0fdc, 0x0fdf, 0x0fd9, 0x0fd8,
    0x0fdb, 0x0fc5, 0x0fc7, 0x0fc6, 0x0fc0, 0x0fc3, 0x0fcd, 0x0fcf,
    0x0fc9, 0x0fc8, 0x0fcb, 0x0fca, 0x0e35, 0x0e3f, 0x0e3e, 0x0e38,
    0x0e25, 0x0e27, 0x0e26, 0x0e23, 0x0e2d, 0x0e2c, 0x0e28, 0x0e2b,
    0x0e2a, 0x0e15, 0x0e14, 0x0e17, 0x0e16, 0x0e11, 0x0e10, 0x0e13,
    0x0e1c, 0x0e1f, 0x0e1b, 0x0e05, 0x0e07, 0x0e02, 0x0e0e, 0x0e08,
    /* 0xc7 */
    0x0e0b, 0x0e0a, 0x0e74, 0x0e77, 0x0e71, 0x0e70, 0x0e7d, 0x0e7f,
    0x0e7e, 0x0e79, 0x0e78, 0x0e7b, 0x0e66, 0x0e60, 0x0e63, 0x0e62,
    0x0e6d, 0x0e6c, 0x0e68, 0x0e57, 0x0e45, 0x0e44, 0x0e47, 0x0e46,
    0x0e41, 0x0e40, 0x0e43, 0x0e4c, 0x0e4f, 0x0e4b, 0x0e4a, 0x0eb5,
    0x0eb4, 0x0eb7, 0x0eb6, 0x0eb1, 0x0eb2, 0x0ebd, 0x0ebf, 0x0ebe,
    0x0eb9, 0x0eb8, 0x0eba, 0x0ea5, 0x0ea4, 0x0ea1, 0x0ea0, 0x0ea3,
    0x0ea2, 0x0eac, 0x0eaf, 0x0ea8, 0x0eaa, 0x0e94, 0x0e97, 0x0e96,
    0x0e91, 0x0e90, 0x0e93, 0x0e92, 0x0e99, 0x0e98, 0x0e9b, 0x0e9a,
    0x0e80, 0x0e8e, 0x0e8b, 0x0e8a, 0x0ef7, 0x0ef6, 0x0ef1, 0x0ef3,
    0x0efd, 0x0efc, 0x0efe, 0x0ef8, 0x0efb, 0x0ee5, 0x0ee4, 0x0ee7,
    0x0ee6, 0x0ee0, 0x0ee2, 0x0eec, 0x0eef, 0x0eee, 0x0eeb, 0x0ed7,
    0x0ed6, 0x0ed1, 0x0ed3, 0x0ed2, 0x0edd, 0x0ede, 0x0ed9, 0x0ed8,
    /* 0xc8 */
    0x0edb, 0x0eda, 0x0ec6, 0x0ec1, 0x0ec0, 0x0ec3, 0x0ec2, 0x0ecf,
    0x0ece, 0x0ec9, 0x0ecb, 0x0eca, 0x0935, 0x0937, 0x0930, 0x0932,
    0x093d, 0x093c, 0x093f, 0x0925, 0x0927, 0x0926, 0x0921, 0x0920,
    0x0923, 0x0922, 0x092c, 0x092f, 0x092e, 0x092b, 0x092a, 0x0915,
    0x0914, 0x0917, 0x0916, 0x091c, 0x091f, 0x091e, 0x0919, 0x0918,
    0x091b, 0x091a, 0x0905, 0x0907, 0x0906, 0x0901, 0x0900, 0x0903,
    0x0902, 0x090c, 0x090f, 0x090e, 0x090b, 0x090a, 0x0975, 0x0974,
    0x0977, 0x0976, 0x0971, 0x0970, 0x0972, 0x097d, 0x097c, 0x097f,
    0x097e, 0x0979, 0x0978, 0x097b, 0x097a, 0x0965, 0x0967, 0x0966,
    0x0961, 0x0960, 0x0963, 0x096d, 0x0968, 0x096b, 0x096a, 0x0955,
    0x0957, 0x0951, 0x0950, 0x0953, 0x0952, 0x095d, 0x095f, 0x095b,
    0x095a, 0x0945, 0x0947, 0x0941, 0x0942, 0x094c, 0x094e, 0x0949,
    /* 0xc9 */
    0x0948, 0x094b, 0x094a, 0x09b5, 0x09b4, 0x09b6, 0x09b1, 0x09b0,
    0x09b3, 0x09bf, 0x09b8, 0x09ba, 0x09a5, 0x09a4, 0x09a7, 0x09a6,
    0x09a1, 0x09a0, 0x09a3, 0x09ad, 0x09af, 0x09ae, 0x09a8, 0x09ab,
    0x09aa, 0x0995, 0x0997, 0x0996, 0x0991, 0x0990, 0x0993, 0x0992,
    0x099d, 0x099c, 0x099f, 0x099e, 0x0999, 0x0998, 0x099b, 0x0985,
    0x0984, 0x0986, 0x0980, 0x0983, 0x0982, 0x098e, 0x0989, 0x098b,
    0x09f5, 0x09f7, 0x09f6, 0x09f0, 0x09f3, 0x09f2, 0x09fd, 0x09fe,
    0x09f9, 0x09fb, 0x09fa, 0x09e7, 0x09e1, 0x09e0, 0x09e2, 0x09ed,
    0x09ec, 0x09ef, 0x09ee, 0x09e9, 0x09eb, 0x09d4, 0x09d7, 0x09d1,
    0x09d2, 0x09dd, 0x09dc, 0x09df, 0x09de, 0x09d8, 0x09db, 0x09da,
    0x09c4, 0x09c7, 0x09c6, 0x09c1, 0x09c0, 0x09c3, 0x09c2, 0x09cd,
    0x09cc, 0x09cf, 0x09ce, 0x09c8, 0x09cb, 0x0835, 0x0834, 0x0837,
    /* 0xca */
    0x0836, 0x0831, 0x0830, 0x0833, 0x0832, 0x083d, 0x083c, 0x083f,
    0x083e, 0x0838, 0x083b, 0x083a, 0x0825, 0x0827, 0x0821, 0x0820,
    0x0823, 0x082d, 0x082c, 0x082e, 0x0829, 0x0828, 0x082b, 0x0815,
    0x0817, 0x0816, 0x0811, 0x0810, 0x0813, 0x0812, 0x081d, 0x081c,
    0x081f, 0x0818, 0x081b, 0x081a, 0x0805, 0x0804, 0x0807, 0x0806,
    0x0801, 0x0800, 0x0803, 0x080b, 0x080a, 0x0875, 0x0874, 0x0877,
    0x0871, 0x0870, 0x0873, 0x0872, 0x087e, 0x0879, 0x0878, 0x087b,
    0x087a, 0x0865, 0x0864, 0x0867, 0x0866, 0x0861, 0x0860, 0x0862,
    0x086d, 0x086f, 0x086e, 0x0869, 0x0868, 0x086a, 0x0855, 0x0854,
    0x0857, 0x0856, 0x0850, 0x0853, 0x0852, 0x085c, 0x085f, 0x085e,
    0x0859, 0x0858, 0x085b, 0x085a, 0x0845, 0x0844, 0x0846, 0x0840,
    0x0843, 0x0842, 0x084d, 0x0849, 0x0848, 0x084a, 0x08b5, 0x08b4,
    /* 0xcb */
    0x08b7, 0x08b6, 0x08b3, 0x08bd, 0x08bc, 0x08bf, 0x08be, 0x08b9,
    0x08b8, 0x08bb, 0x08a5, 0x08a4, 0x08a7, 0x08a6, 0x08a1, 0x08a0,
    0x08a3, 0x08a2, 0x08ad, 0x08ac, 0x08af, 0x08a8, 0x08ab, 0x08aa,
    0x0895, 0x0894, 0x0897, 0x0896, 0x0890, 0x0893, 0x0892, 0x089c,
    0x089e, 0x0899, 0x0898, 0x0884, 0x0887, 0x0886, 0x0881, 0x0880,
    0x0883, 0x088d, 0x088f, 0x088e, 0x0889, 0x0888, 0x088b, 0x088a,
    0x08f5, 0x08f7, 0x08f6, 0x08f1, 0x08f0, 0x08f3, 0x08f2, 0x08fd,
    0x08ff, 0x08fe, 0x08f9, 0x08f8, 0x08fb, 0x08e4, 0x08e7, 0x08e1,
    0x08e3, 0x08e2, 0x08ed, 0x08ec, 0x08ef, 0x08ee, 0x08e8, 0x08eb,
    0x08ea, 0x08d5, 0x08d4, 0x08d7, 0x08d6, 0x08d0, 0x08d3, 0x08d2,
    0x08dd, 0x08df, 0x08de, 0x08d9, 0x08d8, 0x08db, 0x08da, 0x08c5,
    0x08c4, 0x08c7, 0x08c6, 0x08c1, 0x08c0, 0x08c3, 0x08c2, 0x08cd,
    /* 0xcc */
    0x08cc, 0x08cf, 0x08c9, 0x08c8, 0x08cb, 0x0b35, 0x0b34, 0x0b37,
    0x0b36, 0x0b31, 0x0b33, 0x0b32, 0x0b3d, 0x0b3c, 0x0b3f, 0x0b3e,
    0x0b39, 0x0b38, 0x0b3b, 0x0b3a, 0x0b25, 0x0b27, 0x0b26, 0x0b21,
    0x0b20, 0x0b22, 0x0b2d, 0x0b2c, 0x0b2f, 0x0b2e, 0x0b29, 0x0b28,
    0x0b2b, 0x0b2a, 0x0b15, 0x0b14, 0x0b17, 0x0b16, 0x0b11, 0x0b10,
    0x0b13, 0x0b1d, 0x0b1f, 0x0b1e, 0x0b19, 0x0b18, 0x0b1b, 0x0b1a,
    0x0b05, 0x0b04, 0x0b07, 0x0b06, 0x0b01, 0x0b00, 0x0b03, 0x0b02,
    0x0b0c, 0x0b0f, 0x0b0e, 0x0b08, 0x0b0b, 0x0b0a, 0x0b75, 0x0b74,
    0x0b77, 0x0b76, 0x0b71, 0x0b70, 0x0b73, 0x0b72, 0x0b7d, 0x0b7c,
    0x0b7f, 0x0b7e, 0x0b79, 0x0b67, 0x0b66, 0x0b60, 0x0b63, 0x0b62,
    0x0b6d, 0x0b6c, 0x0b6e, 0x0b69, 0x0b68, 0x0b6a, 0x0b55, 0x0b54,
    0x0b56, 0x0b51, 0x0b50, 0x0b53, 0x0b52, 0x0b5d, 0x0b5c, 0x0b5f,
    /* 0xcd */
    0x0b58, 0x0b5a, 0x0b45, 0x0b47, 0x0b46, 0x0b41, 0x0b40, 0x0b43,
    0x0b42, 0x0b4d, 0x0bb6, 0x0bb1, 0x0bb0, 0x0bb3, 0x0bb2, 0x0bbd,
    0x0bbc, 0x0bbb, 0x0bba, 0x0ba5, 0x0ba4, 0x0ba7, 0x0ba1, 0x0ba3,
    0x0ba2, 0x0bad, 0x0bac, 0x0baf, 0x0bae, 0x0bab, 0x0baa, 0x0b95,
    0x0b94, 0x0b97, 0x0b90, 0x0b93, 0x0b9e, 0x0b98, 0x0b9b, 0x0b87,
    0x0b86, 0x0b82, 0x0b8d, 0x0b8c, 0x0b8e, 0x0b89, 0x0b88, 0x0b8b,
    0x0b8a, 0x0bf4, 0x0bf7, 0x0bf6, 0x0bf0, 0x0bfd, 0x0bf9, 0x0bf8,
    0x0be7, 0x0be6, 0x0be0, 0x0be3, 0x0be2, 0x0bef, 0x0be9, 0x0be8,
    0x0bd5, 0x0bd4, 0x0bd7, 0x0bd6, 0x0bd0, 0x0bd3, 0x0bd2, 0x0bdd,
    0x0bdf, 0x0bde, 0x0bd9, 0x0bda, 0x0bc0, 0x0bc3, 0x0bc2, 0x0bcf,
    0x0bce, 0x0bc9, 0x0bc8, 0x0bca, 0x0a34, 0x0a31, 0x0a30, 0x0a33,
    0x0a3e, 0x0a39, 0x0a3b, 0x0a3a, 0x0a25, 0x0a24, 0x0a21, 0x0a23,
    /* 0xce */
    0x0a2c, 0x0a2e, 0x0a28, 0x0a2a, 0x0a15, 0x0a11, 0x0a13, 0x0a12,
    0x0a1d, 0x0a1f, 0x0a1e, 0x0a19, 0x0a18, 0x0a1a, 0x0a05, 0x0a07,
    0x0a06, 0x0a00, 0x0a03, 0x0a0d, 0x0a0c, 0x0a0f, 0x0a09, 0x0a08,
    0x0a75, 0x0a74, 0x0a77, 0x0a76, 0x0a71, 0x0a70, 0x0a73, 0x0a7f,
    0x0a7e, 0x0a78, 0x0a7a, 0x0a65, 0x0a64, 0x0a67, 0x0a61, 0x0a60,
    0x0a63, 0x0a6d, 0x0a6f, 0x0a6e, 0x0a69, 0x0a68, 0x0a6b, 0x0a6a,
    0x0a54, 0x0a57, 0x0a53, 0x0a52, 0x0a5d, 0x0a5c, 0x0a5f, 0x0a5e,
    0x0a59, 0x0a58, 0x0a5a, 0x0a44, 0x0a47, 0x0a46, 0x0a40, 0x0a42,
    0x0a4d, 0x0a4c, 0x0a4f, 0x0a4a, 0x0ab5, 0x0ab4, 0x0ab1, 0x0ab3,
    0x0ab2, 0x0abc, 0x0abf, 0x0ab9, 0x0abb, 0x0aba, 0x0aa5, 0x0aa4,
    0x0aa7, 0x0aa1, 0x0aa0, 0x0aa3, 0x0aad, 0x0aac, 0x0aaf, 0x0aae,
    0x0aa9, 0x0aa8, 0x0aab, 0x0a95, 0x0a94, 0x0a97, 0x0a96, 0x0a91,
    /* 0xcf */
    0x0a90, 0x0a93, 0x0a92, 0x0a9c, 0x0a9f, 0x0a9b, 0x0a85, 0x0a84,
    0x0a87, 0x0a81, 0x0a83, 0x0a82, 0x0a8d, 0x0a8c, 0x0a8e, 0x0a89,
    0x0a8b, 0x0a8a, 0x0af4, 0x0af7, 0x0af6, 0x0af1, 0x0af0, 0x0af2,
    0x0afd, 0x0afc, 0x0af9, 0x0af8, 0x0afb, 0x0afa, 0x0ae5, 0x0ae1,
    0x0ae0, 0x0ae3, 0x0ae2, 0x0aed, 0x0aec, 0x0aef, 0x0ae9, 0x0ae8,
    0x0aeb, 0x0aea, 0x0ad4, 0x0ad7, 0x0ad6, 0x0ad1, 0x0ad3, 0x0ad2,
    0x0add, 0x0adc, 0x0ade, 0x0ad9, 0x0ad8, 0x0ada, 0x0ac5, 0x0ac4,
    0x0ac7, 0x0ac6, 0x0ac1, 0x0ac0, 0x0ac3, 0x0ac2, 0x0acd, 0x0acf,
    0x0ace, 0x0ac9, 0x0ac8, 0x0aca, 0x0535, 0x0534, 0x0537, 0x0531,
    0x0530, 0x0533, 0x0532, 0x053d, 0x053c, 0x053e, 0x0539, 0x0538,
    0x053b, 0x053a, 0x0525, 0x0524, 0x0527, 0x0521, 0x0522, 0x052d,
    0x052c, 0x052f, 0x0529, 0x0528, 0x052b, 0x052a, 0x0515, 0x0516,
    /* 0xd0 */
    0x0511, 0x0510, 0x0513, 0x0512, 0x051d, 0x051c, 0x051f, 0x051e,
    0x0519, 0x0518, 0x051b, 0x051a, 0x0505, 0x0504, 0x0506, 0x0501,
    0x0500, 0x0503, 0x0502, 0x050d, 0x050f, 0x050e, 0x0508, 0x050b,
    0x050a, 0x0574, 0x0577, 0x0576, 0x0573, 0x0572, 0x057d, 0x057c,
    0x057f, 0x057e, 0x057b, 0x057a, 0x0565, 0x0564, 0x0567, 0x0566,
    0x0560, 0x0563, 0x056d, 0x056f, 0x056e, 0x0569, 0x0568, 0x056b,
    0x056a, 0x0555, 0x0553, 0x0552, 0x055f, 0x0558, 0x055a, 0x0544,
    0x0546, 0x0541, 0x0540, 0x0543, 0x054d, 0x054c, 0x054f, 0x054e,
    0x0549, 0x05b5, 0x05b6, 0x05b3, 0x05b2, 0x05bc, 0x05bf, 0x05b9,
    0x05bb, 0x05ba, 0x05a5, 0x05a4, 0x05a6, 0x05a1, 0x05a0, 0x05a2,
    0x05ad, 0x05ac, 0x05af, 0x05ae, 0x05a8, 0x05ab, 0x05aa, 0x0595,
    0x0594, 0x0596, 0x0590, 0x0593, 0x0592, 0x059d, 0x059c, 0x059f,
    /* 0xd1 */
    0x0599, 0x059b, 0x059a, 0x0585, 0x0587, 0x0586, 0x0581, 0x0580,
    0x0583, 0x058d, 0x058c, 0x058f, 0x058e, 0x0588, 0x058b, 0x058a,
    0x05f5, 0x05f6, 0x05f1, 0x05f2, 0x05fd, 0x05ff, 0x05fe, 0x05f9,
    0x05f8, 0x05fa, 0x05e5, 0x05e4, 0x05e6, 0x05e3, 0x05e2, 0x05ef,
    0x05ee, 0x05e9, 0x05e8, 0x05eb, 0x05d5, 0x05d4, 0x05d3, 0x05d2,
    0x05dc, 0x05df, 0x05de, 0x05d9, 0x05d8, 0x05db, 0x05da, 0x05c7,
    0x05c0, 0x05c3, 0x05c2, 0x05cf, 0x05ce, 0x05c8, 0x05ca, 0x0435,
    0x0434, 0x0436, 0x0431, 0x0430, 0x0433, 0x0432, 0x043d, 0x043c,
    0x043e, 0x0439, 0x0438, 0x043b, 0x043a, 0x0424, 0x0421, 0x0420,
    0x0423, 0x0422, 0x042d, 0x0429, 0x0428, 0x042b, 0x042a, 0x0415,
    0x0417, 0x0416, 0x0411, 0x0413, 0x0412, 0x041d, 0x041c, 0x0419,
    0x0418, 0x041b, 0x041a, 0x0404, 0x0407, 0x0406, 0x0400, 0x0402,
    /* 0xd2 */
    0x040d, 0x040c, 0x040f, 0x040e, 0x0409, 0x0408, 0x040b, 0x040a,
    0x0475, 0x0477, 0x0476, 0x0470, 0x0473, 0x0472, 0x047d, 0x047c,
    0x047f, 0x047e, 0x0479, 0x0478, 0x047b, 0x047a, 0x0465, 0x0464,
    0x0467, 0x0466, 0x0461, 0x0460, 0x0463, 0x0462, 0x046d, 0x046c,
    0x046f, 0x046e, 0x0469, 0x0468, 0x0455, 0x0454, 0x0457, 0x0456,
    0x0451, 0x0450, 0x0452, 0x045d, 0x045c, 0x045f, 0x045e, 0x0459,
    0x0458, 0x045b, 0x045a, 0x0445, 0x0444, 0x0447, 0x0446, 0x0441,
    0x0440, 0x0443, 0x0442, 0x044d, 0x044c, 0x044f, 0x0449, 0x0448,
    0x044b, 0x04b5, 0x04b7, 0x04b1, 0x04b0, 0x04b2, 0x04bd, 0x04bc,
    0x04bf, 0x04be, 0x04b9, 0x04b8, 0x04bb, 0x04ba, 0x04a5, 0x04a4,
    0x04a7, 0x04a6, 0x04a1, 0x04a0, 0x04a3, 0x04a2, 0x04ad, 0x04ac,
    0x04af, 0x04ae, 0x04a9, 0x04a8, 0x04ab, 0x04aa, 0x0495, 0x0494,
    /* 0xd3 */
    0x0497, 0x0496, 0x0491, 0x0490, 0x0493, 0x0492, 0x049d, 0x049c,
    0x049f, 0x049e, 0x0499, 0x0498, 0x049b, 0x049a, 0x0485, 0x0484,
    0x0487, 0x0486, 0x0481, 0x0480, 0x0483, 0x0482, 0x048d, 0x048c,
    0x048f, 0x048e, 0x0489, 0x0488, 0x048b, 0x048a, 0x04f5, 0x04f6,
    0x04f8, 0x04e6, 0x04e1, 0x04e0, 0x04e2, 0x04ed, 0x04ec, 0x04ee,
    0x04e8, 0x04ea, 0x04d5, 0x04d4, 0x04d7, 0x04d1, 0x04d2, 0x04dd,
    0x04dc, 0x04df, 0x04d9, 0x04d8, 0x04db, 0x04c5, 0x04c4, 0x04c7,
    0x04c1, 0x04c0, 0x04c3, 0x04c2, 0x04cd, 0x04cc, 0x04cf, 0x04ce,
    0x04c9, 0x04c8, 0x04cb, 0x04ca, 0x0734, 0x0737, 0x0736, 0x0731,
    0x0730, 0x0733, 0x073d, 0x073c, 0x073f, 0x073e, 0x0739, 0x0738,
    0x073b, 0x073a, 0x0725, 0x0724, 0x0727, 0x0726, 0x0721, 0x0720,
    0x0723, 0x0722, 0x072d, 0x072c, 0x072f, 0x072e, 0x0729, 0x0728,
    /* 0xd4 */
    0x072b, 0x072a, 0x0715, 0x0714, 0x0717, 0x0716, 0x0711, 0x0710,
    0x0713, 0x0712, 0x071d, 0x071c, 0x071f, 0x071e, 0x0719, 0x0718,
    0x071b, 0x071a, 0x0705, 0x0704, 0x0707, 0x0706, 0x0701, 0x0700,
    0x0703, 0x0702, 0x070d, 0x070c, 0x070f, 0x070e, 0x0709, 0x0708,
    0x070a, 0x0775, 0x0774, 0x0777, 0x0776, 0x0771, 0x0770, 0x0773,
    0x0772, 0x077c, 0x077f, 0x077e, 0x0779, 0x0778, 0x077b, 0x077a,
    0x0765, 0x0764, 0x0767, 0x0766, 0x0761, 0x0760, 0x0763, 0x0762,
    0x076d, 0x076c, 0x076f, 0x076e, 0x0769, 0x0768, 0x076b, 0x076a,
    0x0755, 0x0754, 0x0757, 0x0756, 0x0751, 0x0750, 0x0753, 0x0752,
    0x075d, 0x075c, 0x075f, 0x075e, 0x0759, 0x0758, 0x075b, 0x075a,
    0x0745, 0x0744, 0x0747, 0x0746, 0x0741, 0x0740, 0x0743, 0x0742,
    0x074d, 0x074f, 0x074e, 0x0749, 0x0748, 0x074b, 0x074a, 0x07b5,
    /* 0xd5 */
    0x07b4, 0x07b7, 0x07b6, 0x07b1, 0x07b0, 0x07b3, 0x07b2, 0x07bd,
    0x07be, 0x07b9, 0x07b8, 0x07bb, 0x07ba, 0x07a5, 0x07a4, 0x07a7,
    0x07a1, 0x07a0, 0x07a3, 0x07a2, 0x07ad, 0x07ac, 0x07af, 0x07ae,
    0x07a9, 0x07a8, 0x07ab, 0x07aa, 0x0795, 0x0794, 0x0797, 0x0796,
    0x0791, 0x0790, 0x0793, 0x0792, 0x079d, 0x079c, 0x079f, 0x079e,
    0x0799, 0x0798, 0x079b, 0x079a, 0x0785, 0x0784, 0x0787, 0x0786,
    0x0781, 0x0780, 0x0783, 0x0782, 0x078d, 0x078c, 0x078f, 0x078e,
    0x0789, 0x0788, 0x078b, 0x078a, 0x07f5, 0x07f4, 0x07f7, 0x07f6,
    0x07f1, 0x07f0, 0x07f3, 0x07f2, 0x07fd, 0x07fc, 0x07ff, 0x07fe,
    0x07f9, 0x07f8, 0x07fb, 0x07fa, 0x07e5, 0x07e4, 0x07e7, 0x07e6,
    0x07e1, 0x07e0, 0x07e3, 0x07e2, 0x07ed, 0x07ec, 0x07ef, 0x07ee,
    0x07e9, 0x07e8, 0x07eb, 0x07ea, 0x07d5, 0x07d4, 0x07d7, 0x07d6,
    /* 0xd6 */
    0x07d1, 0x07d0, 0x07d3, 0x07d2, 0x07dd, 0x07dc, 0x07df, 0x07de,
    0x07d9, 0x07d8, 0x07db, 0x07da, 0x07c5, 0x07c4, 0x07c7, 0x07c6,
    0x07c1, 0x07c0, 0x07c3, 0x07c2, 0x07cd, 0x07cc, 0x07cf, 0x07ce,
    0x07c9, 0x07c8, 0x07cb, 0x07ca, 0x0635, 0x0634, 0x0637, 0x0636,
    0x0631, 0x0630, 0x0633, 0x063d, 0x063c, 0x063f, 0x063e, 0x0639,
    0x0638, 0x063b, 0x063a, 0x0625, 0x0624, 0x0627, 0x0626, 0x0621,
    0x0620, 0x0623, 0x0622, 0x062d, 0x062c, 0x062f, 0x062e, 0x0629,
    0x0628, 0x062b, 0x062a, 0x0615, 0x0614, 0x0617, 0x0616, 0x0611,
    0x0610, 0x0612, 0x061d, 0x061c, 0x061f, 0x061e, 0x0619, 0x0618,
    0x061b, 0x061a, 0x0605, 0x0604, 0x0607, 0x0606, 0x0601, 0x0600,
    0x0603, 0x0602, 0x060d, 0x060c, 0x060f, 0x060e, 0x0609, 0x0608,
    0x060b, 0x060a, 0x0675, 0x0674, 0x0677, 0x0676, 0x0671, 0x0670,
    /* 0xd7 */
    0x0673, 0x0672, 0x067d, 0x067c, 0x067f, 0x067e, 0x0679, 0x0678,
    0x067b, 0x067a, 0x0665, 0x0664, 0x0667, 0x0666, 0x0661, 0x0660,
    0x0663, 0x0662, 0x066d, 0x066c, 0x066f, 0x066e, 0x0669, 0x0668,
    0x066b, 0x066a, 0x0655, 0x0654, 0x0657, 0x0656, 0x0651, 0x0650,
    0x0652, 0x065d, 0x065c, 0x065f, 0x065e, 0x0658, 0x065b, 0x065a,
    0x0645, 0x0644, 0x0647, 0x0646, 0x0641, 0x0640, 0x0643, 0x0642,
    0x064d, 0x064c, 0x064f, 0x064e, 0x0649, 0x0648, 0x064b, 0x064a,
    0x06b5, 0x06b4, 0x06b7, 0x06b6, 0x06b1, 0x06b0, 0x06b3, 0x06b2,
    0x06bd, 0x06bc, 0x06bf, 0x06be, 0x06b9, 0x06b8, 0x06bb, 0x06ba,
    0x06a5, 0x06a4, 0x06a7, 0x06a6, 0x06a1, 0x06a0, 0x06a3, 0x06a2,
    0x06ad, 0x06ac, 0x06af, 0x06ae, 0x06a9, 0x06a8, 0x06ab, 0x06aa,
    0x0699, 0x0684, 0x068e, 0x06f2, 0x06e5, 0x06df, 0x013c, 0x012b,
    /* 0xd8 */
    0x010d, 0x010c, 0x010f, 0x010e, 0x0109, 0x0108, 0x010b, 0x010a,
    0x0175, 0x0177, 0x0176, 0x0171, 0x0170, 0x017d, 0x017f, 0x017e,
    0x0178, 0x017b, 0x017a, 0x0165, 0x0164, 0x0167, 0x0166, 0x0161,
    0x0163, 0x0162, 0x016d, 0x016c, 0x016e, 0x0169, 0x0168, 0x016b,
    0x016a, 0x0155, 0x0156, 0x0151, 0x0150, 0x0153, 0x0152, 0x015d,
    0x015c, 0x0159, 0x0158, 0x015b, 0x015a, 0x0145, 0x0144, 0x0147,
    0x0141, 0x0140, 0x0143, 0x0142, 0x014e, 0x0149, 0x0148, 0x014b,
    0x014a, 0x01b5, 0x01b4, 0x01b6, 0x01b1, 0x01b3, 0x01b2, 0x01bd,
    0x01be, 0x01b8, 0x01bb, 0x01ba, 0x01a5, 0x01a4, 0x01a7, 0x01a6,
    0x01a0, 0x01a3, 0x01a2, 0x01ac, 0x01af, 0x01ae, 0x01a9, 0x01a8,
    0x01ab, 0x01aa, 0x0195, 0x0194, 0x0197, 0x0196, 0x0191, 0x0190,
    0x0193, 0x0192, 0x019d, 0x019c, 0x019f, 0x019e, 0x0199, 0x0198,
    /* 0xd9 */
    0x019b, 0x019a, 0x0185, 0x0184, 0x0187, 0x0186, 0x0181, 0x0180,
    0x0183, 0x0182, 0x018d, 0x018c, 0x018f, 0x018e, 0x0189, 0x0188,
    0x018b, 0x018a, 0x01f5, 0x01f4, 0x01f7, 0x01f6, 0x01f1, 0x01f0,
    0x01f3, 0x01f2, 0x01fd, 0x01fc, 0x01ff, 0x01fe, 0x01f9, 0x01f8,
    0x01fb, 0x01fa, 0x01e5, 0x01e4, 0x01e7, 0x01e6, 0x01e1, 0x01e0,
    0x01e3, 0x01e2, 0x01ed, 0x01ec, 0x01ef, 0x01ee, 0x01e9, 0x01e8,
    0x01eb, 0x01ea, 0x01d5, 0x01d4, 0x01d7, 0x01d6, 0x01d1, 0x01d0,
    0x01d3, 0x01d2, 0x01dd, 0x01dc, 0x01df, 0x01de, 0x01d9, 0x01d8,
    0x01db, 0x01da, 0x01c5, 0x01c4, 0x01c7, 0x01c6, 0x01c1, 0x01c0,
    0x01c3, 0x01c2, 0x01cd, 0x01cc, 0x01cf, 0x01ce, 0x01c9, 0x01c8,
    0x01cb, 0x01ca, 0x0035, 0x0034, 0x0037, 0x0036, 0x0031, 0x0030,
    0x0033, 0x0032, 0x003d, 0x003c, 0x003f, 0x003e, 0x0039, 0x0038,
    /* 0xda */
    0x003b, 0x003a, 0x0025, 0x0024, 0x0027, 0x0026, 0x0021, 0x0020,
    0x0023, 0x0022, 0x002d, 0x002c, 0x002f, 0x002e, 0x0029, 0x0015,
    0x0064, 0x0067, 0x0062, 0x006a, 0x0050, 0x005d, 0x005c, 0x005f,
    0x0059, 0x005b, 0x005a, 0x0044, 0x0047, 0x004d, 0x004c, 0x004f,
    0x004e, 0x0049, 0x0048, 0x004b, 0x004a, 0x00b5, 0x00b7, 0x00b6,
    0x00b3, 0x00b2, 0x00bd, 0x00bc, 0x00b9, 0x00b8, 0x00bb, 0x00ba,
    0x00a5, 0x00a7, 0x00a6, 0x00a0, 0x00a3, 0x00a2, 0x00ad, 0x00ac,
    0x00af, 0x00ae, 0x00a9, 0x00a8, 0x00ab, 0x0095, 0x0094, 0x0097,
    0x0091, 0x0090, 0x0093, 0x0092, 0x009d, 0x009c, 0x009f, 0x009e,
    0x0099, 0x0098, 0x009b, 0x009a, 0x0085, 0x0087, 0x0083, 0x0082,
    0x008c, 0x008e, 0x0088, 0x00f5, 0x00f4, 0x00f7, 0x00f0, 0x00f2,
    0x00fd, 0x00fc, 0x00ff, 0x00f8, 0x00e5, 0x00e7, 0x00e6, 0x00e1,
    /* 0xdb */
    0x00e0, 0x00ed, 0x00ec, 0x00e9, 0x00d5, 0x00d4, 0x00d7, 0x00d0,
    0x00d3, 0x00d2, 0x00dc, 0x00d8, 0x00db, 0x00c5, 0x00c4, 0x00c7,
    0x00c1, 0x00c3, 0x00c9, 0x00cb, 0x00ca, 0x0335, 0x0334, 0x0337,
    0x0336, 0x0331, 0x0333, 0x0332, 0x033d, 0x033e, 0x0338, 0x033b,
    0x0325, 0x0324, 0x0327, 0x0326, 0x0320, 0x0323, 0x0322, 0x032d,
    0x032c, 0x032f, 0x032e, 0x0329, 0x0315, 0x0314, 0x0311, 0x0310,
    0x0313, 0x0312, 0x031d, 0x031e, 0x0318, 0x0305, 0x0307, 0x0306,
    0x0301, 0x0303, 0x0302, 0x030d, 0x030e, 0x0309, 0x030b, 0x030a,
    0x0376, 0x0370, 0x0373, 0x0379, 0x0378, 0x037b, 0x037a, 0x0365,
    0x0366, 0x0361, 0x0360, 0x0363, 0x0362, 0x036d, 0x036f, 0x036e,
    0x0369, 0x0368, 0x036b, 0x036a, 0x0355, 0x0354, 0x0357, 0x0356,
    0x0351, 0x0350, 0x0352, 0x035d, 0x035f, 0x035e, 0x035b, 0x0344,
    /* 0xdc */
    0x0346, 0x0340, 0x0342, 0x034d, 0x034c, 0x034f, 0x034e, 0x0348,
    0x034b, 0x03b5, 0x03b7, 0x03b6, 0x03b1, 0x03b3, 0x03bd, 0x03bc,
    0x03bf, 0x03be, 0x03b9, 0x03b8, 0x03bb, 0x03a4, 0x03a7, 0x03a6,
    0x03a0, 0x03a3, 0x03a2, 0x03ad, 0x03ac, 0x03af, 0x03ae, 0x03a8,
    0x03aa, 0x0395, 0x0394, 0x0397, 0x0396, 0x0391, 0x0390, 0x0393,
    0x0392, 0x039d, 0x039c, 0x039f, 0x0398, 0x039b, 0x0385, 0x0384,
    0x0386, 0x0381, 0x0380, 0x0383, 0x0382, 0x038d, 0x038c, 0x038e,
    0x0389, 0x0388, 0x038b, 0x038a, 0x03f5, 0x03f4, 0x03f7, 0x03f6,
    0x03f1, 0x03f0, 0x03f3, 0x03f2, 0x03fd, 0x03fc, 0x03ff, 0x03fe,
    0x03f9, 0x03f8, 0x03fa, 0x03e5, 0x03e4, 0x03e7, 0x03e6, 0x03e1,
    0x03e0, 0x03e3, 0x03e2, 0x03ed, 0x03ec, 0x03ef, 0x03ee, 0x03e9,
    0x03e8, 0x03eb, 0x03ea, 0x03d5, 0x03d4, 0x03d7, 0x03d6, 0x03d1,
    /* 0xdd */
    0x03d0, 0x03d3, 0x03d2, 0x03dd, 0x03dc, 0x03df, 0x03de, 0x03d9,
    0x03d8, 0x03db, 0x03da, 0x03c5, 0x03c4, 0x03c7, 0x03c6, 0x03c1,
    0x03c0, 0x03c3, 0x03c2, 0x03cd, 0x03cc, 0x03cf, 0x03ce, 0x03c9,
    0x03c8, 0x03cb, 0x03ca, 0x0235, 0x0234, 0x0237, 0x0236, 0x0231,
    0x0230, 0x0233, 0x0232, 0x023d, 0x023c, 0x023f, 0x023e, 0x0239,
    0x0238, 0x023b, 0x023a, 0x0225, 0x0224, 0x0227, 0x0226, 0x0221,
    0x0220, 0x0223, 0x0222, 0x022d, 0x022c, 0x022f, 0x022e, 0x0229,
    0x0228, 0x022b, 0x022a, 0x0215, 0x0214, 0x0217, 0x0216, 0x0211,
    0x0210, 0x0213, 0x0212, 0x021d, 0x021c, 0x021f, 0x021e, 0x0219,
    0x0218, 0x021b, 0x021a, 0x0205, 0x0204, 0x0207, 0x0206, 0x0201,
    0x0200, 0x0203, 0x0202, 0x020d, 0x020c, 0x020f, 0x020e, 0x0209,
    0x0208, 0x020b, 0x020a, 0x0275, 0x0274, 0x0277, 0x0276, 0x0271,
    /* 0xde */
    0x0270, 0x0273, 0x0272, 0x027d, 0x027c, 0x027f, 0x027e, 0x0279,
    0x0278, 0x027b, 0x027a, 0x0265, 0x0264, 0x0267, 0x0266, 0x0261,
    0x0260, 0x0263, 0x0262, 0x026d, 0x026c, 0x026f, 0x026e, 0x0269,
    0x0268, 0x026b, 0x026a, 0x0255, 0x0254, 0x0257, 0x0256, 0x0251,
    0x0250, 0x025f, 0x02b5, 0x02b9, 0x02a7, 0x02a8, 0x0295, 0x0294,
    0x0297, 0x0291, 0x0290, 0x0293, 0x0292, 0x029f, 0x0299, 0x0298,
    0x029b, 0x029a, 0x0287, 0x0286, 0x0281, 0x0280, 0x0282, 0x028d,
    0x028f, 0x028e, 0x0289, 0x028a, 0x02f5, 0x02f6, 0x02f3, 0x02fc,
    0x02ff, 0x02fe, 0x02f9, 0x02f8, 0x02fa, 0x02e7, 0x02e3, 0x02e2,
    0x02ef, 0x02d5, 0x02d4, 0x02d6, 0x02d2, 0x02d9, 0x02da, 0x02c4,
    0x02c7, 0x02c1, 0x02c0, 0x02c3, 0x02cf, 0x02ce, 0x02c9, 0x02cb,
    0x02ca, 0x1d32, 0x1d3d, 0x1d39, 0x1d3b, 0x1d26, 0x1d20, 0x1d2d,
    /* 0xdf */
    0x1d2c, 0x1d29, 0x1d16, 0x1d11, 0x1d10, 0x1d12, 0x1d1d, 0x1d1c,
    0x1d1f, 0x1d1e, 0x1d19, 0x1d05, 0x1d04, 0x1d07, 0x1d06, 0x1d01,
    0x1d02, 0x1d0c, 0x1d0f, 0x1d08, 0x1d0a, 0x1d75, 0x1d76, 0x1d70,
    0x1d73, 0x1d7d, 0x1d7c, 0x1d7f, 0x1d7e, 0x1d79, 0x1d7b, 0x1d61,
    0x1d60, 0x1d63, 0x1d6c, 0x1d6f, 0x1d69, 0x1d68, 0x1d6b, 0x1d6a,
    0x1d55, 0x1d54, 0x1d51, 0x1d53, 0x1d52, 0x1d5c, 0x1d5f, 0x1d5e,
    0x1d59, 0x1d5a, 0x1d45, 0x1d44, 0x1d47, 0x1d46, 0x1d43, 0x1d42,
    0x1d4d, 0x1d4c, 0x1d4f, 0x1d4e, 0x1d49, 0x1d4b, 0x1db4, 0x1db1,
    0x1db0, 0x1db3, 0x1db2, 0x1dbc, 0x1dbf, 0x1db9, 0x1db8, 0x1dbb,
    0x1dba, 0x1da5, 0x1da7, 0x1da1, 0x1da3, 0x1dad, 0x1daf, 0x1da9,
    0x1dab, 0x1daa, 0x1d95, 0x1d91, 0x1d90, 0x1d92, 0x1d9d, 0x1d9c,
    0x1d9e, 0x1d98, 0x1d87, 0x1d82, 0x1d89, 0x1d88, 0x1d8a, 0x1df5,
    /* 0xe0 */
    0x1df7, 0x1df6, 0x1df3, 0x1dfd, 0x1dfc, 0x1dfe, 0x1df9, 0x1df8,
    0x1de7, 0x1de1, 0x1de0, 0x1de3, 0x1ded, 0x1dec, 0x1def, 0x1deb,
    0x1dea, 0x1dd5, 0x1dd6, 0x1dd1, 0x1dd0, 0x1ddc, 0x1ddf, 0x1dd9,
    0x1ddb, 0x1dc5, 0x1dc4, 0x1dc7, 0x1dc6, 0x1dc0, 0x1dc3, 0x1dc2,
    0x1dcc, 0x1dcf, 0x1dce, 0x1dc9, 0x1dca, 0x1c35, 0x1c34, 0x1c36,
    0x1c30, 0x1c33, 0x1c32, 0x1c3d, 0x1c3c, 0x1c3f, 0x1c3e, 0x1c39,
    0x1c38, 0x1c3b, 0x1c3a, 0x1c25, 0x1c24, 0x1c27, 0x1c26, 0x1c21,
    0x1c20, 0x1c23, 0x1c22, 0x1c2d, 0x1c2f, 0x1c2e, 0x1c29, 0x1c28,
    0x1c2a, 0x1c15, 0x1c14, 0x1c11, 0x1c10, 0x1c13, 0x1c12, 0x1c1d,
    0x1c1c, 0x1c1f, 0x1c1e, 0x1c19, 0x1c18, 0x1c1b, 0x1c05, 0x1c07,
    0x1c06, 0x1c01, 0x1c00, 0x1c03, 0x1c02, 0x1c0d, 0x1c0f, 0x1c0e,
    0x1c09, 0x1c08, 0x1c0b, 0x1c0a, 0x1c75, 0x1c74, 0x1c77, 0x1c71,
    /* 0xe1 */
    0x1c70, 0x1c72, 0x1c7d, 0x1c64, 0x1c66, 0x1c61, 0x1c60, 0x1c63,
    0x1c6d, 0x1c6c, 0x1c6e, 0x1c69, 0x1c6a, 0x1c55, 0x1c53, 0x1c52,
    0x1c5d, 0x1c5e, 0x1c58, 0x1c46, 0x1c4f, 0x1c4e, 0x1c49, 0x1cb5,
    0x1cb4, 0x1cb7, 0x1cb6, 0x1cb1, 0x1cb3, 0x1cbd, 0x1cbf, 0x1cbb,
    0x1cba, 0x1ca6, 0x1ca1, 0x1ca0, 0x1ca3, 0x1ca2, 0x1cad, 0x1cac,
    0x1ca9, 0x1ca8, 0x1cab, 0x1caa, 0x1c95, 0x1c94, 0x1c91, 0x1c90,
    0x1c93, 0x1c92, 0x1c9d, 0x1c9c, 0x1c9e, 0x1c99, 0x1c85, 0x1c84,
    0x1c87, 0x1c86, 0x1c83, 0x1c82, 0x1c8d, 0x1c8c, 0x1c8e, 0x1c89,
    0x1c88, 0x1c8b, 0x1c8a, 0x1cf5, 0x1cf4, 0x1cf7, 0x1cf6, 0x1cf1,
    0x1cf0, 0x1cf3, 0x1cfd, 0x1cfe, 0x1ce5, 0x1ce7, 0x1ce6, 0x1ce1,
    0x1ce0, 0x1ce3, 0x1ce2, 0x1ced, 0x1cec, 0x1cef, 0x1cee, 0x1ce8,
    0x1ceb, 0x1cea, 0x1cd5, 0x1cd4, 0x1cd7, 0x1cd6, 0x1cd1, 0x1cd0,
    /* 0xe2 */
    0x1cd3, 0x1cd2, 0x1cdd, 0x1cdc, 0x1cdf, 0x1cde, 0x1cd9, 0x1cd8,
    0x1cdb, 0x1cda, 0x1cc5, 0x1cc4, 0x1cc7, 0x1cc6, 0x1cc1, 0x1cc0,
    0x1cc3, 0x1cc2, 0x1ccd, 0x1ccc, 0x1ccf, 0x1cce, 0x1cc9, 0x1cc8,
    0x1ccb, 0x1cca, 0x1f35, 0x1f34, 0x1f37, 0x1f36, 0x1f31, 0x1f30,
    0x1f33, 0x1f32, 0x1f3d, 0x1f3c, 0x1f3f, 0x1f3e, 0x1f39, 0x1f38,
    0x1f3b, 0x1f3a, 0x1f25, 0x1f24, 0x1f27, 0x1f26, 0x1f21, 0x1f20,
    0x1f23, 0x1f22, 0x1f2d, 0x1f2c, 0x1f2f, 0x1f2e, 0x1f29, 0x1f28,
    0x1f2b, 0x1f2a, 0x1f15, 0x1f14, 0x1f17, 0x1f16, 0x1f11, 0x1f10,
    0x1f13, 0x1f12, 0x1f1d, 0x1f1c, 0x1f1f, 0x1f1e, 0x1f19, 0x1f18,
    0x1f1b, 0x1f1a, 0x1f05, 0x1f04, 0x1f07, 0x1f06, 0x1f01, 0x1f00,
    0x1f03, 0x1f02, 0x1f0d, 0x1f0c, 0x1f0f, 0x1f0e, 0x1f09, 0x1f08,
    0x1f0b, 0x1f0a, 0x1f75, 0x1f74, 0x1f77, 0x1f76, 0x1f71, 0x1f70,
    /* 0xe3 */
    0x1f73, 0x1f72, 0x1f7d, 0x1f7c, 0x1f7f, 0x1f7e, 0x1f79, 0x1f78,
    0x1f7b, 0x1f7a, 0x1f65, 0x1f64, 0x1f67, 0x1f66, 0x1f61, 0x1f60,
    0x1f63, 0x1f62, 0x1f6d, 0x1f6c, 0x1f6f, 0x1f6e, 0x1f69, 0x1f68,
    0x1f6b, 0x1f6a, 0x1f55, 0x1f54, 0x1f57, 0x1f56, 0x1f51, 0x1f50,
    0x1f53, 0x1f52, 0x1f5d, 0x1f5c, 0x1f5f, 0x1f5e, 0x1f59, 0x1f58,
    0x1f5b, 0x1f5a, 0x1f45, 0x1f44, 0x1f47, 0x1f46, 0x1f40, 0x1f43,
    0x1f42, 0x1f4d, 0x1f4c, 0x1f4f, 0x1f4e, 0x1f49, 0x1f48, 0x1f4b,
    0x1f4a, 0x1fb5, 0x1fb4, 0x1fb7, 0x1fb6, 0x1fb1, 0x1fb0, 0x1fb3,
    0x1fb2, 0x1fbd, 0x1fbc, 0x1fbf, 0x1fbe, 0x1fb9, 0x1fb8, 0x1fba,
    0x1fa5, 0x1fa4, 0x1fa7, 0x1fa6, 0x1fa1, 0x1fa0, 0x1fa3, 0x1fa2,
    0x1fad, 0x1fac, 0x1faf, 0x1fae, 0x1fa9, 0x1fa8, 0x1fab, 0x1faa,
    0x1f95, 0x1f94, 0x1f97, 0x1f96, 0x1f91, 0x1f90, 0x1f93, 0x1f92,
    /* 0xe4 */
    0x1f9d, 0x1f9c, 0x1f9f, 0x1f9e, 0x1f99, 0x1f98, 0x1f9a, 0x1f85,
    0x1f84, 0x1f87, 0x1f86, 0x1f81, 0x1f80, 0x1f83, 0x1f82, 0x1f8d,
    0x1f8c, 0x1f8f, 0x1f8e, 0x1f89, 0x1f88, 0x1f8b, 0x1f8a, 0x1ff5,
    0x1ff4, 0x1ff7, 0x1ff6, 0x1ff1, 0x1ff0, 0x1ff3, 0x1ff2, 0x1ffc,
    0x1fff, 0x1ffe, 0x1ff9, 0x1ff8, 0x1ffb, 0x1ffa, 0x1fe5, 0x1fe4,
    0x1fe7, 0x1fe6, 0x1fe1, 0x1fe0, 0x1fe3, 0x1fe2, 0x1fed, 0x1fec,
    0x1fef, 0x1fee, 0x1fe9, 0x1fe8, 0x1feb, 0x1fea, 0x1fd5, 0x1fd4,
    0x1fd7, 0x1fd6, 0x1fd1, 0x1fd0, 0x1fd3, 0x1fd2, 0x1fdd, 0x1fdc,
    0x1fdf, 0x1fde, 0x1fd9, 0x1fd8, 0x1fdb, 0x1fda, 0x1fc5, 0x1fc4,
    0x1fc7, 0x1fc6, 0x1fc1, 0x1fc0, 0x1fc3, 0x1fc2, 0x1fcd, 0x1fcc,
    0x1fcf, 0x1fce, 0x1fc9, 0x1fc8, 0x1fcb, 0x1fca, 0x1e35, 0x1e34,
    0x1e37, 0x1e36, 0x1e31, 0x1e30, 0x1e33, 0x1e32, 0x1e3d, 0x1e3c,
    /* 0xe5 */
    0x1e3f, 0x1e3e, 0x1e39, 0x1e38, 0x1e3b, 0x1e3a, 0x1e25, 0x1e24,
    0x1e27, 0x1e26, 0x1e21, 0x1e20, 0x1e23, 0x1e22, 0x1e2d, 0x1e2c,
    0x1e2f, 0x1e2e, 0x1e29, 0x1e28, 0x1e2b, 0x1e2a, 0x1e15, 0x1e14,
    0x1e17, 0x1e16, 0x1e11, 0x1e10, 0x1e13, 0x1e12, 0x1e1d, 0x1e1c,
    0x1e1f, 0x1e1e, 0x1e19, 0x1e18, 0x1e1b, 0x1e1a, 0x1e05, 0x1e04,
    0x1e07, 0x1e06, 0x1e01, 0x1e00, 0x1e03, 0x1e02, 0x1e0d, 0x1e0c,
    0x1e0f, 0x1e0e, 0x1e09, 0x1e08, 0x1e0a, 0x1e75, 0x1e74, 0x1e77,
    0x1e76, 0x1e71, 0x1e70, 0x1e73, 0x1e72, 0x1e7d, 0x1e7c, 0x1e7f,
    0x1e7e, 0x1e79, 0x1e78, 0x1e7b, 0x1e7a, 0x1e65, 0x1e64, 0x1e67,
    0x1e66, 0x1e61, 0x1e60, 0x1e63, 0x1e62, 0x1e6d, 0x1e6c, 0x1e6f,
    0x1e6e, 0x1e69, 0x1e68, 0x1e6b, 0x1e6a, 0x1e55, 0x1e54, 0x1e57,
    0x1e56, 0x1e51, 0x1e50, 0x1e53, 0x1e52, 0x1e5d, 0x1e5c, 0x1e5e,
    /* 0xe6 */
    0x1e59, 0x1e58, 0x1e5b, 0x1e5a, 0x1e45, 0x1e44, 0x1e47, 0x1e46,
    0x1e41, 0x1e40, 0x1e43, 0x1e42, 0x1e4d, 0x1e4c, 0x1e4f, 0x1e4e,
    0x1e49, 0x1e48, 0x1e4b, 0x1e4a, 0x1eb5, 0x1eb4, 0x1eb7, 0x1eb6,
    0x1eb1, 0x1eb0, 0x1eb3, 0x1eb2, 0x1ebd, 0x1ebc, 0x1ebf, 0x1ebe,
    0x1eb9, 0x1eb8, 0x1ebb, 0x1ea5, 0x1ea4, 0x1ea7, 0x1ea6, 0x1ea1,
    0x1ea0, 0x1ea3, 0x1ea2, 0x1ead, 0x1eac, 0x1eaf, 0x1eae, 0x1ea9,
    0x1ea8, 0x1eab, 0x1eaa, 0x1e95, 0x1e94, 0x1e97, 0x1e96, 0x1e91,
    0x1e90, 0x1e93, 0x1e92, 0x1e9d, 0x1e9c, 0x1e9f, 0x1e9e, 0x1e99,
    0x1e98, 0x1e9b, 0x1e9a, 0x1e85, 0x1e84, 0x1e87, 0x1e86, 0x1e81,
    0x1e80, 0x1e83, 0x1e82, 0x1e8d, 0x1e8c, 0x1e8f, 0x1e8e, 0x1e89,
    0x1e88, 0x1e8b, 0x1e8a, 0x1ef5, 0x1ef4, 0x1ef7, 0x1ef6, 0x1ef1,
    0x1ef0, 0x1ef3, 0x1ef2, 0x1efd, 0x1efc, 0x1efe, 0x1ef9, 0x1ef8,
    /* 0xe7 */
    0x1efb, 0x1efa, 0x1ee5, 0x1ee4, 0x1ee7, 0x1ee6, 0x1ee1, 0x1ee0,
    0x1ee2, 0x1eed, 0x1eec, 0x1eef, 0x1eee, 0x1ee9, 0x1ee8, 0x1eeb,
    0x1eea, 0x1ed5, 0x1ed4, 0x1ed7, 0x1ed6, 0x1ed1, 0x1ed0, 0x1ed3,
    0x1ed2, 0x1edd, 0x1edc, 0x1edf, 0x1ede, 0x1ed9, 0x1ed8, 0x1edb,
    0x1eda, 0x1ec5, 0x1ec4, 0x1ec7, 0x1ec6, 0x1ec1, 0x1ec0, 0x1ec3,
    0x1ec2, 0x1ecd, 0x1ecc, 0x1ecf, 0x1ece, 0x1ec9, 0x1ec8, 0x1ecb,
    0x1eca, 0x1935, 0x1934, 0x1937, 0x1936, 0x1931, 0x1930, 0x1933,
    0x1932, 0x193d, 0x193c, 0x193f, 0x193e, 0x1939, 0x1938, 0x193b,
    0x193a, 0x1925, 0x1924, 0x1927, 0x1926, 0x1921, 0x1920, 0x1923,
    0x1922, 0x192d, 0x192c, 0x192f, 0x192e, 0x1929, 0x1928, 0x192b,
    0x192a, 0x1915, 0x1914, 0x1917, 0x1916, 0x1911, 0x1910, 0x1913,
    0x1912, 0x191d, 0x191c, 0x191f, 0x191e, 0x1919, 0x1918, 0x191b,
    /* 0xe8 */
    0x191a, 0x1905, 0x1904, 0x1907, 0x1906, 0x1901, 0x1900, 0x1903,
    0x1902, 0x190d, 0x190c, 0x190f, 0x190e, 0x1909, 0x1908, 0x190a,
    0x1975, 0x1974, 0x1977, 0x1976, 0x1971, 0x1970, 0x1973, 0x1972,
    0x197d, 0x197c, 0x197f, 0x197e, 0x1979, 0x1978, 0x197b, 0x197a,
    0x1965, 0x1964, 0x1967, 0x1966, 0x1961, 0x1960, 0x1963, 0x1962,
    0x196d, 0x196c, 0x196f, 0x196e, 0x1969, 0x1968, 0x196b, 0x196a,
    0x1955, 0x1954, 0x1957, 0x1956, 0x1951, 0x1950, 0x1953, 0x1952,
    0x195d, 0x195c, 0x195f, 0x1959, 0x1958, 0x195b, 0x195a, 0x1945,
    0x1944, 0x1947, 0x1946, 0x1941, 0x1940, 0x1943, 0x1942, 0x194d,
    0x194c, 0x194f, 0x194e, 0x1949, 0x1948, 0x194b, 0x194a, 0x19b5,
    0x19b4, 0x19b7, 0x19b6, 0x19b1, 0x19a4, 0x19a3, 0x19ad, 0x19f2,
    0x19fa, 0x19e6, 0x19e1, 0x19ef, 0x19d3, 0x19ce, 0x1829, 0x1815,
    /* 0xe9 */
    0x1812, 0x1806, 0x1808, 0x1876, 0x187d, 0x187e, 0x1860, 0x186f,
    0x1855, 0x185b, 0x1841, 0x1840, 0x1842, 0x184d, 0x184c, 0x184f,
    0x184e, 0x1849, 0x1848, 0x184b, 0x18b5, 0x18b4, 0x18b7, 0x18b6,
    0x18b1, 0x18b0, 0x18b3, 0x18b2, 0x18bd, 0x18bc, 0x18bf, 0x18be,
    0x18b9, 0x18b8, 0x18bb, 0x18ba, 0x18a5, 0x18a4, 0x18a7, 0x18a6,
    0x18a1, 0x18a0, 0x18a3, 0x18a2, 0x18ad, 0x18ac, 0x18af, 0x18ae,
    0x18a9, 0x18a8, 0x18ab, 0x18aa, 0x1895, 0x1894, 0x1897, 0x1896,
    0x1891, 0x1890, 0x1893, 0x1892, 0x189d, 0x189c, 0x189f, 0x189e,
    0x1899, 0x1898, 0x189b, 0x189a, 0x1885, 0x1884, 0x1887, 0x1886,
    0x1881, 0x1880, 0x1883, 0x1882, 0x188d, 0x188c, 0x188f, 0x188e,
    0x1889, 0x1888, 0x188b, 0x188a, 0x18f5, 0x18f4, 0x18f7, 0x18f6,
    0x18f1, 0x18f0, 0x18f3, 0x18f2, 0x18fd, 0x18fc, 0x18ff, 0x18fe,
    /* 0xea */
    0x18f9, 0x18f8, 0x18fb, 0x18fa, 0x18e5, 0x18e4, 0x18e7, 0x18e6,
    0x18e1, 0x18e0, 0x18e3, 0x18e2, 0x18ed, 0x18ec, 0x18ef, 0x18ee,
    0x18e9, 0x18e8, 0x18eb, 0x18ea, 0x18d5, 0x18d4, 0x18d7, 0x18d6,
    0x18d1, 0x18d0, 0x18d3, 0x18d2, 0x18d9, 0x18ca, 0x1b32, 0x1b26,
    0x1b2d, 0x1b2e, 0x1b2b, 0x1b15, 0x1b16, 0x1b11, 0x1b10, 0x1b13,
    0x1b12, 0x1b1d, 0x1b1c, 0x1b1e, 0x1b19, 0x1b18, 0x1b1a, 0x1b05,
    0x1b02, 0x1b0d, 0x1b0c, 0x1b0f, 0x1b0b, 0x1b74, 0x1b76, 0x1b7f,
    0x1b7b, 0x1b7a, 0x1b64, 0x1b67, 0x1b66, 0x1b63, 0x1b62, 0x1b6d,
    0x1b6c, 0x1b6f, 0x1b69, 0x1b68, 0x1b6b, 0x1b55, 0x1b56, 0x1b50,
    0x1b53, 0x1b5e, 0x1b58, 0x1b5b, 0x1b5a, 0x1b45, 0x1b44, 0x1b46,
    0x1b4d, 0x1b4c, 0x1b4f, 0x1b4e, 0x1b49, 0x1b48, 0x1b4b, 0x1b4a,
    0x1bb5, 0x1bb4, 0x1bb7, 0x1bb6, 0x1bb1, 0x1bb2, 0x1bbc, 0x1bbf,
    /* 0xeb */
    0x1bb9, 0x1bbb, 0x1ba4, 0x1ba7, 0x1ba6, 0x1ba0, 0x1ba3, 0x1baf,
    0x1bae, 0x1ba8, 0x1bab, 0x1baa, 0x1b95, 0x1b94, 0x1b97, 0x1b96,
    0x1b91, 0x1b90, 0x1b93, 0x1b9d, 0x1b9c, 0x1b9f, 0x1b9e, 0x1b99,
    0x1b98, 0x1b9b, 0x1b9a, 0x1b84, 0x1b87, 0x1b81, 0x1b80, 0x1b82,
    0x1b8d, 0x1b8f, 0x1b8e, 0x1b8a, 0x1bf7, 0x1bf6, 0x1bfd, 0x1bff,
    0x1bfe, 0x1be5, 0x1be4, 0x1be6, 0x1be1, 0x1be3, 0x1be2, 0x1bed,
    0x1bec, 0x1bef, 0x1bee, 0x1be9, 0x1be8, 0x1beb, 0x1bea, 0x1bd4,
    0x1bd7, 0x1bd6, 0x1bd1, 0x1bd0, 0x1bd3, 0x1bd2, 0x1bde, 0x1bd9,
    0x1bd8, 0x1bdb, 0x1bc5, 0x1bc4, 0x1bc7, 0x1bc1, 0x1bc0, 0x1bcd,
    0x1bcf, 0x1bce, 0x1bc9, 0x1bc8, 0x1bca, 0x1a37, 0x1a36, 0x1a30,
    0x1a3f, 0x1a3e, 0x1a39, 0x1a25, 0x1a24, 0x1a27, 0x1a21, 0x1a20,
    0x1a22, 0x1a2d, 0x1a2c, 0x1a2f, 0x1a2e, 0x1a28, 0x1a2a, 0x1a15,
    /* 0xec */
    0x1a14, 0x1a17, 0x1a16, 0x1a11, 0x1a10, 0x1a13, 0x1a12, 0x1a1d,
    0x1a1c, 0x1a1e, 0x1a19, 0x1a1b, 0x1a1a, 0x1a04, 0x1a06, 0x1a01,
    0x1a00, 0x1a03, 0x1a02, 0x1a0f, 0x1a0e, 0x1a09, 0x1a08, 0x1a0a,
    0x1a75, 0x1a74, 0x1a77, 0x1a76, 0x1a71, 0x1a70, 0x1a73, 0x1a72,
    0x1a7d, 0x1a7c, 0x1a7f, 0x1a7e, 0x1a79, 0x1a78, 0x1a7b, 0x1a7a,
    0x1a65, 0x1a64, 0x1a61, 0x1a60, 0x1a62, 0x1a6d, 0x1a6f, 0x1a69,
    0x1a68, 0x1a6a, 0x1a56, 0x1a51, 0x1a53, 0x1a52, 0x1a5d, 0x1a5f,
    0x1a5e, 0x1a59, 0x1a58, 0x1a5b, 0x1a5a, 0x1a45, 0x1a44, 0x1a47,
    0x1a40, 0x1a42, 0x1a4d, 0x1a4c, 0x1a4f, 0x1a4e, 0x1a48, 0x1a4b,
    0x1a4a, 0x1ab5, 0x1ab4, 0x1ab7, 0x1ab6, 0x1ab1, 0x1ab3, 0x1ab2,
    0x1abd, 0x1abc, 0x1abf, 0x1ab9, 0x1abb, 0x1aba, 0x1aa5, 0x1aa6,
    0x1aa0, 0x1aa3, 0x1aa2, 0x1aac, 0x1aaf, 0x1aae, 0x1aa9, 0x1aa8,
    /* 0xed */
    0x1aab, 0x1aaa, 0x1a94, 0x1a97, 0x1a91, 0x1a90, 0x1a93, 0x1a92,
    0x1a9d, 0x1a9c, 0x1a9f, 0x1a99, 0x1a9b, 0x1a85, 0x1a84, 0x1a86,
    0x1a80, 0x1a83, 0x1a82, 0x1a8d, 0x1a8c, 0x1a8f, 0x1a8e, 0x1a89,
    0x1a88, 0x1a8b, 0x1a8a, 0x1af5, 0x1af4, 0x1af7, 0x1af6, 0x1af1,
    0x1af0, 0x1af3, 0x1af2, 0x1afd, 0x1afc, 0x1aff, 0x1afe, 0x1af9,
    0x1af8, 0x1afb, 0x1afa, 0x1ae5, 0x1ae4, 0x1ae7, 0x1ae6, 0x1ae1,
    0x1ae0, 0x1ae3, 0x1ae2, 0x1aed, 0x1aec, 0x1aef, 0x1aee, 0x1ae9,
    0x1ae8, 0x1aeb, 0x1aea, 0x1ad5, 0x1ad4, 0x1ad7, 0x1ad6, 0x1ad1,
    0x1ad0, 0x1add, 0x1adb, 0x1ada, 0x1ac5, 0x1ac4, 0x1ac7, 0x1ac1,
    0x1ac2, 0x1acd, 0x1acc, 0x1acf, 0x1ace, 0x1ac9, 0x1ac8, 0x1acb,
    0x1aca, 0x1535, 0x1534, 0x1537, 0x1536, 0x1531, 0x1530, 0x1533,
    0x1532, 0x153d, 0x153c, 0x153f, 0x153e, 0x1539, 0x1538, 0x153b,
    /* 0xee */
    0x153a, 0x1525, 0x1524, 0x1527, 0x1526, 0x1521, 0x1520, 0x1523,
    0x1522, 0x152d, 0x152c, 0x152f, 0x152e, 0x1529, 0x1528, 0x152b,
    0x152a, 0x1515, 0x1514, 0x1517, 0x1516, 0x1511, 0x1510, 0x1513,
    0x1512, 0x151d, 0x151c, 0x151f, 0x151e, 0x1519, 0x1518, 0x151b,
    0x151a, 0x1505, 0x1504, 0x1507, 0x1506, 0x1501, 0x1500, 0x1503,
    0x1502, 0x150d, 0x150c, 0x150f, 0x150e, 0x1509, 0x1508, 0x150b,
    0x150a, 0x1575, 0x1574, 0x1577, 0x1576, 0x1571, 0x1570, 0x1573,
    0x1572, 0x157d, 0x157c, 0x157f, 0x157e, 0x1579, 0x1578, 0x157b,
    0x157a, 0x1565, 0x1564, 0x1567, 0x1566, 0x1561, 0x1560, 0x1563,
    0x1562, 0x156d, 0x156c, 0x156f, 0x156e, 0x1569, 0x1568, 0x156b,
    0x156a, 0x1555, 0x1554, 0x1557, 0x1556, 0x1551, 0x1550, 0x1553,
    0x1552, 0x155d, 0x155c, 0x155f, 0x155e, 0x1559, 0x1558, 0x155b,
    /* 0xef */
    0x155a, 0x1545, 0x1544, 0x1547, 0x1546, 0x1541, 0x15be, 0x15bb,
    0x15a7, 0x15a0, 0x15ac, 0x1596, 0x159d, 0x159c, 0x159f, 0x159e,
    0x1599, 0x1598, 0x159b, 0x159a, 0x1585, 0x1584, 0x1587, 0x1586,
    0x1581, 0x1580, 0x1583, 0x1582, 0x158d, 0x158c, 0x158f, 0x158e,
    0x1589, 0x1588, 0x158b, 0x158a, 0x15f5, 0x15f4, 0x15f7, 0x15f6,
    0x15f1, 0x15f0, 0x15f3, 0x15f2, 0x15fd, 0x15fc, 0x15ff, 0x15fe,
    0x15f9, 0x15f8, 0x15fa, 0x15e5, 0x15e1, 0x15e3, 0x15e2, 0x15ee,
    0x15e9, 0x15e8, 0x15d5, 0x15d4, 0x15d7, 0x15d6, 0x15d1, 0x15d0,
    0x15d3, 0x15dc, 0x15df, 0x15de, 0x15d9, 0x15d8, 0x15db, 0x15da,
    0x15c5, 0x15c4, 0x15c7, 0x15c6, 0x15c1, 0x15c0, 0x15c3, 0x15c2,
    0x15cd, 0x15cc, 0x15cf, 0x15ce, 0x15c9, 0x15c8, 0x15cb, 0x15ca,
    0x1435, 0x1434, 0x1437, 0x1436, 0x1431, 0x1430, 0x1433, 0x1432,
    /* 0xf0 */
    0x143d, 0x143c, 0x143f, 0x143e, 0x1439, 0x143b, 0x143a, 0x1424,
    0x1427, 0x1426, 0x1421, 0x1420, 0x1423, 0x1422, 0x142d, 0x142c,
    0x142f, 0x142e, 0x1429, 0x1428, 0x142b, 0x142a, 0x1415, 0x1414,
    0x1417, 0x1416, 0x1411, 0x1410, 0x1413, 0x1412, 0x141d, 0x141c,
    0x141f, 0x141e, 0x1419, 0x1418, 0x141a, 0x1405, 0x1404, 0x1407,
    0x1406, 0x1401, 0x1400, 0x1403, 0x1402, 0x140d, 0x140c, 0x140f,
    0x140e, 0x1409, 0x1408, 0x140b, 0x140a, 0x1475, 0x1474, 0x1477,
    0x1476, 0x1471, 0x1470, 0x1473, 0x1472, 0x147d, 0x147c, 0x147f,
    0x147e, 0x1479, 0x1478, 0x147b, 0x147a, 0x1465, 0x1464, 0x1467,
    0x1466, 0x1463, 0x1462, 0x146d, 0x146c, 0x146f, 0x146e, 0x1469,
    0x1468, 0x146b, 0x146a, 0x1455, 0x1454, 0x1457, 0x1451, 0x1453,
    0x1446, 0x144d, 0x144c, 0x144e, 0x144b, 0x14b7, 0x14b6, 0x14bc,
    /* 0xf1 */
    0x14b9, 0x14bb, 0x14af, 0x14ae, 0x14a9, 0x14a8, 0x14ab, 0x14aa,
    0x1495, 0x1494, 0x1497, 0x1496, 0x1491, 0x1493, 0x1492, 0x149c,
    0x149f, 0x149e, 0x1499, 0x1498, 0x149b, 0x149a, 0x1485, 0x1484,
    0x1487, 0x1486, 0x1481, 0x1480, 0x1483, 0x1482, 0x148d, 0x148c,
    0x148f, 0x148e, 0x1489, 0x1488, 0x148b, 0x148a, 0x14f5, 0x14f4,
    0x14f7, 0x14f6, 0x14f1, 0x14f0, 0x14f3, 0x14f2, 0x14fd, 0x14fc,
    0x14ff, 0x14fe, 0x14f9, 0x14f8, 0x14fb, 0x14fa, 0x14e5, 0x14e4,
    0x14e7, 0x14e6, 0x14e1, 0x14e0, 0x14e3, 0x14e2, 0x14ed, 0x14ec,
    0x14ef, 0x14ee, 0x14e9, 0x14e8, 0x14eb, 0x14ea, 0x14d5, 0x14d4,
    0x14d7, 0x14d6, 0x14d1, 0x14d0, 0x14d3, 0x14d2, 0x14dd, 0x14dc,
    0x14df, 0x14de, 0x14d9, 0x14d8, 0x14db, 0x14da, 0x14c5, 0x14c4,
    0x14c7, 0x14c6, 0x14c1, 0x14c0, 0x14c3, 0x14c2, 0x14cd, 0x14cc,
    /* 0xf2 */
    0x14cf, 0x14ce, 0x14c9, 0x14c8, 0x14cb, 0x14ca, 0x1735, 0x1734,
    0x1737, 0x1736, 0x1731, 0x1730, 0x1733, 0x1732, 0x173d, 0x173c,
    0x173f, 0x173e, 0x1739, 0x1738, 0x173b, 0x173a, 0x1725, 0x1724,
    0x1727, 0x1726, 0x1721, 0x1720, 0x1723, 0x1722, 0x172d, 0x172c,
    0x172f, 0x172e, 0x1729, 0x1728, 0x172b, 0x172a, 0x1715, 0x1714,
    0x1717, 0x1716, 0x1711, 0x1710, 0x1713, 0x1712, 0x171d, 0x171c,
    0x171f, 0x171e, 0x1719, 0x1718, 0x171b, 0x171a, 0x1705, 0x1704,
    0x1707, 0x1706, 0x1701, 0x1700, 0x1703, 0x1702, 0x170d, 0x170c,
    0x170f, 0x170e, 0x1709, 0x1708, 0x170b, 0x170a, 0x1775, 0x1774,
    0x1777, 0x1776, 0x1771, 0x1770, 0x1773, 0x1772, 0x177d, 0x177c,
    0x177f, 0x177e, 0x1779, 0x1778, 0x177b, 0x177a, 0x1765, 0x1764,
    0x1767, 0x1766, 0x1761, 0x1760, 0x1763, 0x1762, 0x176d, 0x176c,
    /* 0xf3 */
    0x176f, 0x176e, 0x1769, 0x1768, 0x176b, 0x176a, 0x1755, 0x1754,
    0x1757, 0x1756, 0x1751, 0x1750, 0x1753, 0x1752, 0x175d, 0x175c,
    0x175f, 0x175e, 0x1747, 0x17b6, 0x17bc, 0x17b8, 0x17bb, 0x17a1,
    0x17a0, 0x17ac, 0x1793, 0x179c, 0x179f, 0x179e, 0x1799, 0x1798,
    0x179b, 0x179a, 0x1787, 0x1786, 0x1781, 0x1780, 0x178c, 0x178e,
    0x1788, 0x178b, 0x178a, 0x17f6, 0x17f1, 0x17f3, 0x17f2, 0x17fd,
    0x17fc, 0x17ff, 0x17f8, 0x17fb, 0x17fa, 0x17e5, 0x17e7, 0x17e1,
    0x17e0, 0x17e3, 0x17e2, 0x17ec, 0x17ef, 0x17ee, 0x17e9, 0x17e8,
    0x17eb, 0x17d5, 0x17d7, 0x17d6, 0x17d1, 0x17d0, 0x17d2, 0x17dd,
    0x17dc, 0x17df, 0x17d9, 0x17db, 0x17c5, 0x17c4, 0x17c7, 0x17c6,
    0x17c1, 0x17c0, 0x17c3, 0x17c2, 0x17cd, 0x17cf, 0x17c9, 0x17c8,
    0x17cb, 0x17ca, 0x1635, 0x1634, 0x1637, 0x1631, 0x1630, 0x1633,
    /* 0xf4 */
    0x1632, 0x163c, 0x163f, 0x163e, 0x1639, 0x1638, 0x163b, 0x1625,
    0x1624, 0x1627, 0x1621, 0x1620, 0x1623, 0x1622, 0x162d, 0x162c,
    0x162f, 0x162e, 0x1629, 0x1628, 0x162b, 0x1615, 0x1614, 0x1617,
    0x1611, 0x1610, 0x1613, 0x1612, 0x161d, 0x161c, 0x161f, 0x161e,
    0x1619, 0x1618, 0x161b, 0x1605, 0x1604, 0x1606, 0x1601, 0x1600,
    0x1603, 0x1602, 0x160d, 0x160c, 0x160f, 0x1608, 0x160b, 0x160a,
    0x1675, 0x1673, 0x167f, 0x167e, 0x1679, 0x167b, 0x1665, 0x1667,
    0x1666, 0x1660, 0x1663, 0x1662, 0x166d, 0x166c, 0x166f, 0x166e,
    0x1669, 0x1668, 0x166b, 0x166a, 0x1655, 0x1654, 0x1657, 0x1656,
    0x1651, 0x1650, 0x1653, 0x1652, 0x165d, 0x165c, 0x165f, 0x165e,
    0x1659, 0x1658, 0x165b, 0x165a, 0x1645, 0x1644, 0x1647, 0x1646,
    0x1641, 0x1640, 0x1643, 0x1642, 0x164d, 0x164c, 0x164f, 0x164e,
    /* 0xf5 */
    0x1649, 0x1648, 0x164b, 0x164a, 0x16b5, 0x16b4, 0x16b7, 0x16b6,
    0x16b1, 0x16b0, 0x16b3, 0x16b2, 0x16bd, 0x16bc, 0x16bf, 0x16be,
    0x16b9, 0x16b8, 0x16bb, 0x16ba, 0x16a5, 0x16a4, 0x16a7, 0x16a6,
    0x16a1, 0x16a0, 0x16a3, 0x16a2, 0x16ad, 0x16ac, 0x16af, 0x16ae,
    0x16a9, 0x16a8, 0x16ab, 0x16aa, 0x1695, 0x1694, 0x1697, 0x1696,
    0x1691, 0x1690, 0x1693, 0x1692, 0x169d, 0x169c, 0x169f, 0x169e,
    0x1699, 0x1698, 0x169b, 0x169a, 0x1685, 0x1684, 0x1687, 0x1686,
    0x1681, 0x1680, 0x1683, 0x1682, 0x168d, 0x168c, 0x168f, 0x168e,
    0x1689, 0x1688, 0x168b, 0x168a, 0x16f5, 0x16f4, 0x16f7, 0x16f6,
    0x16f1, 0x16f0, 0x16f3, 0x16f2, 0x16fd, 0x16fc, 0x16ff, 0x16fe,
    0x16f9, 0x16f8, 0x16fb, 0x16fa, 0x16e5, 0x16e4, 0x16e7, 0x16e6,
    0x16e1, 0x16e0, 0x16e3, 0x16e2, 0x16ed, 0x16ec, 0x16ef, 0x16ee,
    /* 0xf6 */
    0x16e9, 0x16e8, 0x16eb, 0x16ea, 0x16d5, 0x16d4, 0x16d7, 0x16d6,
    0x16d1, 0x16d0, 0x16d3, 0x16d2, 0x16dd, 0x16dc, 0x16df, 0x16de,
    0x16d9, 0x16d8, 0x16db, 0x16da, 0x16c5, 0x16c4, 0x16c7, 0x16c6,
    0x16c1, 0x16c0, 0x16c3, 0x16c2, 0x16cd, 0x16cc, 0x16cf, 0x16ce,
    0x16c9, 0x16c8, 0x16cb, 0x16ca, 0x1135, 0x1134, 0x1137, 0x1136,
    0x1131, 0x1130, 0x1133, 0x1132, 0x113d, 0x113c, 0x113f, 0x113e,
    0x1139, 0x1138, 0x113b, 0x113a, 0x1125, 0x1124, 0x1127, 0x1126,
    0x1121, 0x1120, 0x1123, 0x1122, 0x112d, 0x112c, 0x112f, 0x112e,
    0x1129, 0x1128, 0x112b, 0x112a, 0x1115, 0x1114, 0x1117, 0x1116,
    0x1111, 0x1110, 0x1113, 0x1112, 0x111d, 0x111c, 0x111f, 0x111e,
    0x1119, 0x1118, 0x111b, 0x111a, 0x1105, 0x1104, 0x1107, 0x1106,
    0x1101, 0x1100, 0x1103, 0x1102, 0x110d, 0x110c, 0x110f, 0x110e,
    /* 0xf7 */
    0x1109, 0x1108, 0x110b, 0x110a, 0x1175, 0x1174, 0x1177, 0x1176,
    0x1171, 0x1170, 0x1173, 0x1172, 0x117d, 0x117c, 0x117f, 0x117e,
    0x1179, 0x1178, 0x117b, 0x117a, 0x1165, 0x1164, 0x1167, 0x1166,
    0x1161, 0x1160, 0x1163, 0x1162, 0x116d, 0x116c, 0x116f, 0x116e,
    0x1169, 0x1168, 0x116b, 0x116a, 0x1155, 0x1154, 0x1157, 0x1156,
    0x1151, 0x1150, 0x1153, 0x1152, 0x115d, 0x115c, 0x115f, 0x115e,
    0x1159, 0x1158, 0x115b, 0x115a, 0x1145, 0x1144, 0x1147, 0x1146,
    0x1141, 0x1140, 0x1143, 0x1142, 0x114d, 0x114c, 0x114f, 0x114e,
    0x1148, 0x114b, 0x11b5, 0x11b6, 0x11b1, 0x11bc, 0x11bf, 0x11b9,
    0x11ba, 0x11a6, 0x11a3, 0x11a2, 0x11ad, 0x11ac, 0x11a8, 0x119f,
    0x1199, 0x119a, 0x118c, 0x118b, 0x118a, 0x11f5, 0x11f4, 0x11f7,
    0x11fd, 0x11fc, 0x11e4, 0x11e7, 0x11ef, 0x11ee, 0x11d5, 0x11d4,
    /* 0xf8 */
    0x11d6, 0x11d1, 0x11d0, 0x11d3, 0x11d2, 0x11dd, 0x11dc, 0x11df,
    0x11de, 0x11d9, 0x11d8, 0x11db, 0x11da, 0x11c5, 0x11c4, 0x11c7,
    0x11c6, 0x11c1, 0x11c0, 0x11c3, 0x11c2, 0x11cd, 0x11cc, 0x11cf,
    0x11ce, 0x11c9, 0x11c8, 0x11cb, 0x11ca, 0x1035, 0x1034, 0x1037,
    0x1036, 0x1031, 0x1030, 0x1033, 0x1032, 0x103d, 0x103c, 0x103f,
    0x103e, 0x1039, 0x1038, 0x103b, 0x103a, 0x1025, 0x1024, 0x1027,
    0x1026, 0x1021, 0x1020, 0x1023, 0x1022, 0x102d, 0x102c, 0x102f,
    0x102e, 0x1029, 0x1028, 0x102b, 0x102a, 0x1015, 0x1014, 0x1017,
    0x1016, 0x1011, 0x1010, 0x1013, 0x1012, 0x101d, 0x101c, 0x101f,
    0x101e, 0x1019, 0x1018, 0x101b, 0x101a, 0x1005, 0x1004, 0x1007,
    0x1006, 0x1001, 0x1000, 0x1003, 0x1002, 0x100d, 0x100c, 0x100f,
    0x100e, 0x1009, 0x1008, 0x100b, 0x100a, 0x1075, 0x1074, 0x1077,
    /* 0xf9 */
    0x1076, 0x1071, 0x1070, 0x1073, 0x1072, 0x107d, 0x107c, 0x107f,
    0x107e, 0x1079, 0x1078, 0x107b, 0x107a, 0x1065, 0x1064, 0x1067,
    0x1066, 0x1061, 0x1060, 0x1063, 0x1062, 0x106d, 0x106c, 0x106f,
    0x106e, 0x1069, 0x1068, 0x106b, 0x106a, 0x1055, 0x1054, 0x1057,
    0x1056, 0x1051, 0x1050, 0x1053, 0x1052, 0x105d, 0x105c, 0x105f,
    0x105e, 0x1059, 0x1058, 0x105b, 0x105a, 0x1045, 0x1044, 0x1047,
    0x1046, 0x1041, 0x1040, 0x1043, 0x1042, 0x104d, 0x104c, 0x104f,
    0x104e, 0x1049, 0x1048, 0x104b, 0x104a, 0x10b5, 0x10b4, 0x10b7,
    0x10b6, 0x10b1, 0x10b0, 0x10b3, 0x10b2, 0x10bd, 0x10bc, 0x10bf,
    0x10be, 0x10b9, 0x10b8, 0x10bb, 0x10ba, 0x10a5, 0x10a4, 0x10a7,
    0x10a6, 0x10a1, 0x10a0, 0x10a3, 0x10a2, 0x10ad, 0x10ac, 0x10af,
    0x10ae, 0x10a9, 0x10a8, 0x10ab, 0x10aa, 0x1095, 0x1094, 0x1097,
    /* 0xfa */
    0x1096, 0x1091, 0x1090, 0x1093, 0x1092, 0x109d, 0x109c, 0x109f,
    0x109e, 0x1099, 0x1098, 0x109b, 0x109a, 0x1085, 0x1084, 0x1087,
    0x1086, 0x1081, 0x1080, 0x1083, 0x1082, 0x108d, 0x108c, 0x108f,
    0x108e, 0x1089, 0x1088, 0x108b, 0x108a, 0x10f5, 0x10f4, 0x10f7,
    0x10f6, 0x10f1, 0x10f0, 0x10f3, 0x10f2, 0x10fd, 0x10fc, 0x10ff,
    0x10fe, 0x10f9, 0x10f8, 0x10fb, 0x10fa, 0x10e5, 0x10e4, 0x10e7,
    0x10e6, 0x10e1, 0x10e0, 0x10e3, 0x10e2, 0x10ed, 0x10ec, 0x10ef,
    0x10ee, 0x10e9, 0x10e8, 0x10eb, 0x10ea, 0x10d5, 0x10d4, 0x10d7,
    0x10d6, 0x10d1, 0x10d0, 0x10d3, 0x10d2, 0x10dd, 0x10dc, 0x10df,
    0x10de, 0x10d9, 0x10d8, 0x10db, 0x10da, 0x10c5, 0x10c4, 0x10c7,
    0x10c6, 0x10c1, 0x10c0, 0x10c3, 0x10c2, 0x10cd, 0x10cc, 0x10cf,
    0x10ce, 0x10c9, 0x10c8, 0x10cb, 0x10ca, 0x1335, 0x1334, 0x1337,
    /* 0xfb */
    0x1336, 0x1331, 0x1330, 0x1333, 0x1332, 0x133d, 0x133c, 0x133f,
    0x133e, 0x1339, 0x1338, 0x133b, 0x133a, 0x1325, 0x1324, 0x1327,
    0x1326, 0x1321, 0x1320, 0x1323, 0x1322, 0x132d, 0x132c, 0x132f,
    0x132e, 0x1329, 0x1328, 0x132b, 0x1311, 0x1312, 0x131b, 0x1305,
    0x1301, 0x130e, 0x1309, 0x1375, 0x1378, 0x1365, 0x1367, 0x1366,
    0x1361, 0x1363, 0x136c, 0x1368, 0x136a, 0x1355, 0x1354, 0x1357,
    0x1350, 0x135b, 0x135a, 0x1347, 0x1341, 0x1340, 0x1343, 0x1342,
    0x134d, 0x134c, 0x134f, 0x134e, 0x1349, 0x1348, 0x13b5, 0x13b4,
    0x13b6, 0x13b1, 0x13b0, 0x13b3, 0x13bc, 0x13bf, 0x13b9, 0x13b8,
    0x13bb, 0x13ba, 0x13a5, 0x13a4, 0x13a1, 0x13a0, 0x13a3, 0x13a2,
    0x13ad, 0x13ac, 0x13af, 0x13ae, 0x13a9, 0x13ab, 0x1395, 0x1394,
    0x1397, 0x1396, 0x1391, 0x1390, 0x1392, 0x139d, 0x139c, 0x139f,
    /* 0xfc */
    0x139e, 0x1399, 0x1398, 0x139b, 0x139a, 0x1385, 0x1384, 0x1387,
    0x1386, 0x1380, 0x1383, 0x1382, 0x138c, 0x138f, 0x1389, 0x138a,
    0x13f5, 0x13f4, 0x13f7, 0x13f6, 0x13f0, 0x13f3, 0x13f2, 0x13fd,
    0x13ff, 0x13fe, 0x13f9, 0x13e5, 0x13e7, 0x13e6, 0x13e0, 0x13e3,
    0x13e2, 0x13ec, 0x13ef, 0x13eb, 0x13d4, 0x13d6, 0x13d1, 0x13d3,
    0x13dd, 0x13de, 0x13d9, 0x13d8, 0x13db, 0x13c5, 0x13c4, 0x13c7,
    0x13c6, 0x13c1, 0x13c0, 0x13c3, 0x13c2, 0x13cd, 0x13cf, 0x13c8,
    0x13ca, 0x1235, 0x1234, 0x1237, 0x1236, 0x1231, 0x1230, 0x1233,
    0x1232, 0x123d, 0x123c, 0x123f, 0x1239, 0x123a, 0x1224, 0x1227,
    0x1221, 0x1220, 0x1223, 0x122d, 0x122f, 0x122e, 0x1229, 0x1228,
    0x122b, 0x122a, 0x1214, 0x1216, 0x1211, 0x1210, 0x1213, 0x1212,
    0x121d, 0x121c, 0x121f, 0x121e, 0x1218, 0x121b, 0x1205, 0x1204,
    /* 0xfd */
    0x1207, 0x1206, 0x1201, 0x1200, 0x1203, 0x120d, 0x120f, 0x1209,
    0x120a, 0x1275, 0x1274, 0x1277, 0x1276, 0x1270, 0x1273, 0x1272,
    0x127d, 0x127c, 0x127f, 0x127e, 0x1279, 0x1278, 0x127b, 0x127a,
    0x1267, 0x1266, 0x1261, 0x1260, 0x1263, 0x1262, 0x126d, 0x126c,
    0x126f, 0x126e, 0x1269, 0x1268, 0x126b, 0x126a, 0x1255, 0x1254,
    0x1257, 0x1256, 0x1251, 0x1250, 0x1253, 0x1252, 0x125d, 0x125c,
    0x125f, 0x125e, 0x1259, 0x1258, 0x125b, 0x125a, 0x1245, 0x1244,
    0x1247, 0x1246, 0x1241, 0x1240, 0x1243, 0x1242, 0x124d, 0x124c,
    0x124f, 0x124e, 0x1249, 0x1248, 0x124b, 0x12b4, 0x12b7, 0x12b8,
    0x12bb, 0x12ba, 0x12a5, 0x12a4, 0x12a7, 0x12a6, 0x12a1, 0x12a0,
    0x12a3, 0x12a2, 0x12ad, 0x12a9, 0x12a8, 0x12ab, 0x1294, 0x1297,
    0x1296, 0x1291, 0x1290, 0x7419, 0x744c, 0x74a0, 0x74d2, 0x74c4,
    /* 0xfe */
    0x7739, 0x7738, 0x773b, 0x773a, 0x7724, 0x7726, 0x7721, 0x772d,
    0x772a, 0x7715, 0x7714, 0x7716, 0x7711, 0x7712, 0x771d, 0x771c
};

SInt convertMbToWc4Gbkext2( void    * aSrc,
                            SInt      aSrcRemain,
                            void    * aDest,
                            SInt   /* aDestRemain */ )
{
/***********************************************************************
 *
 * Description :
 *     PROJ-2414 [ɼ] GBK, CP936 character set ߰
 *     GBKEXT2 ==> UTF16BE
 *
 * Implementation :
 *     1) GBKEXT2  ȯ .
 *
 ***********************************************************************/

    UChar  * sSrcCharPtr;
    UInt     sNum;
    SInt     sRet;
    UShort   sWc;

    sSrcCharPtr = (UChar *)aSrc;

    if ( ( sSrcCharPtr[0] >= 0xa8 ) && ( sSrcCharPtr[0] <= 0xfe ) )
    {
        if ( aSrcRemain < 2 )
        {
            sRet = RET_TOOFEW;
        }
        else
        {
            /* 1) GBKEXT2  ȯ  */
            if ( ( ( sSrcCharPtr[1] >= 0x40 ) && ( sSrcCharPtr[1] < 0x7f ) ) ||
                 ( ( sSrcCharPtr[1] >= 0x80 ) && ( sSrcCharPtr[1] < 0xa1 ) ) )
            {
               sNum= ( 96 * ( sSrcCharPtr[0] - 0x81 ) ) +
                       ( sSrcCharPtr[1] -
                         ( sSrcCharPtr[1] >= 0x80 ? 0x41 : 0x40 ) );

                if (sNum < 12016 )
                {
                    sWc = gGbkExt22UniA8[sNum-3744] ^ IDN_GBKEXT2_XOR_VALUE;
                    WC_TO_UTF16BE( aDest, sWc );

                    sRet = 2;
                }
                else
                {
                    sRet = RET_ILSEQ;
                }
            }
            else
            {
                sRet = RET_ILSEQ;
            }
        }
    }
    else
    {
        /* GBK  ̹ üũϱ , ǻ    б̴. */
        sRet = RET_ILSEQ;
    }

    return sRet;
}
