/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: qdbCommon.cpp 25810 2008-04-30 00:20:56Z peh $
 **********************************************************************/

#include <idnJisx0208.h>

static const UShort jisx0208_2uni_page21[690] = {
  /* 0x21 */
  0x340d, 0x340c, 0x340f, 0xfb01, 0xfb03, 0x34f6, 0xfb17, 0xfb16,
  0xfb12, 0xfb0c, 0x3496, 0x3491, 0x04b9, 0xfb4d, 0x04a5, 0xfb33,
  0xfbee, 0xfb32, 0x34f0, 0x34f3, 0x3490, 0x3493, 0x340e, 0x4ad0,
  0x3408, 0x340b, 0x340a, 0x34f1, 0x2418, 0x241d, 0xfb02, 0xfb31,
  0x3411, 0x241b, 0xfb51, 0x242b, 0x2428, 0x2415, 0x2414, 0x2411,
  0x2410, 0xfb05, 0xfb04, 0x3419, 0x3418, 0xfb36, 0xfb30, 0xfb56,
  0xfb50, 0x3405, 0x3404, 0x3407, 0x3406, 0x3401, 0x3400, 0x3403,
  0x3402, 0x341d, 0x341c, 0xfb06, 0x261f, 0x04bc, 0x04da, 0x04fa,
  0xfb10, 0x266d, 0xfb11, 0xfb13, 0x266b, 0x266a, 0x2613, 0x2639,
  0x224f, 0x224d, 0x04bd, 0x243f, 0x243e, 0x250e, 0xfbe8, 0xfb09,
  0x04af, 0x04ae, 0xfb08, 0xfb0e, 0xfb0b, 0xfb07, 0xfb2d, 0x04aa,
  0x220b, 0x2208, 0x21c6, 0x21c2, 0x21c3, 0x21ca,
  /* 0x22 */
  0x21cb, 0x21ac, 0x21ad, 0x21be, 0x21bf, 0x21b0, 0x21b1, 0x2436,
  0x341f, 0x259f, 0x259d, 0x259c, 0x259e, 0x341e, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x2605, 0x2606, 0x268b, 0x268a, 0x268f, 0x268e, 0x2627,
  0x2624, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x262a, 0x2625, 0x04a1, 0x25df, 0x25d9, 0x260d, 0x260e,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0x262d, 0x26a8, 0x271f, 0x260f, 0x260a,
  0x266c, 0x265f, 0x2667, 0x2666, 0x2617, 0x2630, 0x2610, 0x2638,
  0x2626, 0x2621, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0x2526, 0x243d, 0x2262, 0x2260, 0x2267, 0x242d, 0x242c,
  0x04bb, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0x21e2,
  /* 0x23 */
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfb1d,
  0xfb1c, 0xfb1f, 0xfb1e, 0xfb19, 0xfb18, 0xfb1b, 0xfb1a, 0xfb15,
  0xfb14, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfb2c, 0xfb2f, 0xfb2e, 0xfb29, 0xfb28, 0xfb2b, 0xfb2a, 0xfb25,
  0xfb24, 0xfb27, 0xfb26, 0xfb21, 0xfb20, 0xfb23, 0xfb22, 0xfb3d,
  0xfb3c, 0xfb3f, 0xfb3e, 0xfb39, 0xfb38, 0xfb3b, 0xfb3a, 0xfb35,
  0xfb34, 0xfb37, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfb4c, 0xfb4f, 0xfb4e, 0xfb49, 0xfb48, 0xfb4b, 0xfb4a, 0xfb45,
  0xfb44, 0xfb47, 0xfb46, 0xfb41, 0xfb40, 0xfb43, 0xfb42, 0xfb5d,
  0xfb5c, 0xfb5f, 0xfb5e, 0xfb59, 0xfb58, 0xfb5b, 0xfb5a, 0xfb55,
  0xfb54, 0xfb57, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x24 */
  0x344c, 0x344f, 0x344e, 0x3449, 0x3448, 0x344b, 0x344a, 0x3445,
  0x3444, 0x3447, 0x3446, 0x3441, 0x3440, 0x3443, 0x3442, 0x345d,
  0x345c, 0x345f, 0x345e, 0x3459, 0x3458, 0x345b, 0x345a, 0x3455,
  0x3454, 0x3457, 0x3456, 0x3451, 0x3450, 0x3453, 0x3452, 0x346d,
  0x346c, 0x346f, 0x346e, 0x3469, 0x3468, 0x346b, 0x346a, 0x3465,
  0x3464, 0x3467, 0x3466, 0x3461, 0x3460, 0x3463, 0x3462, 0x347d,
  0x347c, 0x347f, 0x347e, 0x3479, 0x3478, 0x347b, 0x347a, 0x3475,
  0x3474, 0x3477, 0x3476, 0x3471, 0x3470, 0x3473, 0x3472, 0x348d,
  0x348c, 0x348f, 0x348e, 0x3489, 0x3488, 0x348b, 0x348a, 0x3485,
  0x3484, 0x3487, 0x3486, 0x3481, 0x3480, 0x3483, 0x3482, 0x349d,
  0x349c, 0x349f, 0x349e, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x25 */
  0x34ac, 0x34af, 0x34ae, 0x34a9, 0x34a8, 0x34ab, 0x34aa, 0x34a5,
  0x34a4, 0x34a7, 0x34a6, 0x34a1, 0x34a0, 0x34a3, 0x34a2, 0x34bd,
  0x34bc, 0x34bf, 0x34be, 0x34b9, 0x34b8, 0x34bb, 0x34ba, 0x34b5,
  0x34b4, 0x34b7, 0x34b6, 0x34b1, 0x34b0, 0x34b3, 0x34b2, 0x34cd,
  0x34cc, 0x34cf, 0x34ce, 0x34c9, 0x34c8, 0x34cb, 0x34ca, 0x34c5,
  0x34c4, 0x34c7, 0x34c6, 0x34c1, 0x34c0, 0x34c3, 0x34c2, 0x34dd,
  0x34dc, 0x34df, 0x34de, 0x34d9, 0x34d8, 0x34db, 0x34da, 0x34d5,
  0x34d4, 0x34d7, 0x34d6, 0x34d1, 0x34d0, 0x34d3, 0x34d2, 0x34ed,
  0x34ec, 0x34ef, 0x34ee, 0x34e9, 0x34e8, 0x34eb, 0x34ea, 0x34e5,
  0x34e4, 0x34e7, 0x34e6, 0x34e1, 0x34e0, 0x34e3, 0x34e2, 0x34fd,
  0x34fc, 0x34ff, 0x34fe, 0x34f9, 0x34f8, 0x34fb, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x26 */
  0x079c, 0x079f, 0x079e, 0x0799, 0x0798, 0x079b, 0x079a, 0x0795,
  0x0794, 0x0797, 0x0796, 0x0791, 0x0790, 0x0793, 0x0792, 0x07ad,
  0x07ac, 0x07ae, 0x07a9, 0x07a8, 0x07ab, 0x07aa, 0x07a5, 0x07a4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x07bc, 0x07bf, 0x07be, 0x07b9, 0x07b8, 0x07bb, 0x07ba, 0x07b5,
  0x07b4, 0x07b7, 0x07b6, 0x07b1, 0x07b0, 0x07b3, 0x07b2, 0x07cd,
  0x07cc, 0x07ce, 0x07c9, 0x07c8, 0x07cb, 0x07ca, 0x07c5, 0x07c4,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x27 */
  0x001d, 0x001c, 0x001f, 0x001e, 0x0019, 0x0018, 0x000c, 0x001b,
  0x001a, 0x0015, 0x0014, 0x0017, 0x0016, 0x0011, 0x0010, 0x0013,
  0x0012, 0x002d, 0x002c, 0x002f, 0x002e, 0x0029, 0x0028, 0x002b,
  0x002a, 0x0025, 0x0024, 0x0027, 0x0026, 0x0021, 0x0020, 0x0023,
  0x0022, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0x003d, 0x003c, 0x003f, 0x003e, 0x0039, 0x0038, 0x005c, 0x003b,
  0x003a, 0x0035, 0x0034, 0x0037, 0x0036, 0x0031, 0x0030, 0x0033,
  0x0032, 0x004d, 0x004c, 0x004f, 0x004e, 0x0049, 0x0048, 0x004b,
  0x004a, 0x0045, 0x0044, 0x0047, 0x0046, 0x0041, 0x0040, 0x0043,
  0x0042, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x28 */
  0x210d, 0x210f, 0x2101, 0x211d, 0x2115, 0x2119, 0x2111, 0x2121,
  0x2129, 0x2139, 0x2131, 0x210c, 0x210e, 0x2102, 0x211e, 0x2116,
  0x211a, 0x212e, 0x213e, 0x2126, 0x2136, 0x2146, 0x212d, 0x2122,
  0x2125, 0x213a, 0x2132, 0x2110, 0x213d, 0x2128, 0x2135, 0x214f,
};

static const UShort jisx0208_2uni_page30[6398] = {
  /* 0x30 */
  0x4a91, 0x511b, 0x5e0e, 0x9232, 0x50cd, 0x6516, 0x6725, 0x5dfb,
  0x942f, 0x8078, 0x8711, 0x7e5d, 0x64a7, 0x67ec, 0x6a28, 0x61e0,
  0x806b, 0x86ab, 0x9ff8, 0x6c9e, 0x532a, 0x61ac, 0x667c, 0x5f96,
  0x5ddd, 0x8276, 0x9cf9, 0x796f, 0x79b3, 0x9f83, 0x661b, 0x7892,
  0x8cba, 0x5f84, 0x5ab8, 0x6704, 0x629a, 0x6c45, 0x91ca, 0x9380,
  0x6342, 0x4ae8, 0x4b07, 0x4b40, 0x4b90, 0x5444, 0x52ff, 0x5d3a,
  0x5dd9, 0x5e0c, 0x5804, 0x64d2, 0x6502, 0x657d, 0x621e, 0x6d08,
  0x74b7, 0x7142, 0x717d, 0x7df6, 0x79a0, 0x79e2, 0x84ce, 0x8003,
  0x8c6e, 0x8f0f, 0x9458, 0x9477, 0x5736, 0x4a98, 0x4aa8, 0x53d2,
  0x84bf, 0x94cc, 0x7ce2, 0x4a0d, 0x5cfc, 0x6aaf, 0x9435, 0x7e3f,
  0x8725, 0x8686, 0x9822, 0x554c, 0x577d, 0x50b0, 0x50ec, 0x52ed,
  0x5df6, 0x5b18, 0x9cff, 0x69e6, 0x84e9, 0x8120,
  /* 0x31 */
  0x926f, 0x927d, 0x92ad, 0x93f6, 0x5006, 0x57fe, 0x5f8a, 0x74c2,
  0x7bb0, 0x8bcf, 0x92e5, 0x5762, 0x9951, 0x7eb7, 0x4a1c, 0x7c9e,
  0x85f1, 0x6a2b, 0x5215, 0x5109, 0x6f10, 0x8117, 0x9836, 0x5de8,
  0x57a4, 0x696b, 0x70d1, 0x9182, 0x524f, 0x4a9c, 0x9446, 0x92ff,
  0x8742, 0x9d01, 0x57ec, 0x51bb, 0x5f3d, 0x5b7c, 0x622d, 0x62fe,
  0x6c09, 0x6835, 0x68fe, 0x6924, 0x7056, 0x72c5, 0x7e43, 0x9c39,
  0x86fc, 0x8c56, 0x8e6d, 0x96e0, 0x69bf, 0x71a6, 0x72c7, 0x9dc8,
  0x64ab, 0x8f0c, 0x8987, 0x91bf, 0x6d83, 0x57a0, 0x558b, 0x531f,
  0x5c3d, 0x5d49, 0x5fb9, 0x5afb, 0x6425, 0x67a4, 0x67f9, 0x68b2,
  0x6b19, 0x7483, 0x7519, 0x7554, 0x75d8, 0x7732, 0x7a0c, 0x867b,
  0x86dc, 0x819a, 0x946d, 0x9656, 0x9916, 0x5c64, 0x61b1, 0x6857,
  0x7128, 0x55f4, 0x5d23, 0x5d68, 0x5b8d, 0x5bd1,
  /* 0x32 */
  0x66b1, 0x61f7, 0x6e27, 0x6f2a, 0x6fb9, 0x7786, 0x7bcc, 0x8d5b,
  0x9921, 0x9903, 0x9ac9, 0x58ac, 0x689b, 0x8776, 0x5509, 0x5846,
  0x65bb, 0x85cb, 0x6c7b, 0x766c, 0x4a54, 0x4bf7, 0x5775, 0x6464,
  0x6a24, 0x7e42, 0x93fe, 0x4a06, 0x571b, 0x4ae3, 0x4b58, 0x4b30,
  0x4bac, 0x4b7e, 0x56ad, 0x57e2, 0x5204, 0x5d02, 0x5ecc, 0x5fbb,
  0x5fec, 0x7ddc, 0x628a, 0x6391, 0x63bb, 0x6f41, 0x68be, 0x7466,
  0x77cf, 0x7d80, 0x7db3, 0x7e31, 0x7f8a, 0x86bc, 0x86d6, 0x8709,
  0x877a, 0x87e2, 0x87de, 0x836b, 0x8ebf, 0x5224, 0x88a5, 0x8beb,
  0x9443, 0x9313, 0x8287, 0x4bc9, 0x58e5, 0x661c, 0x7654, 0x7136,
  0x85e8, 0x86b0, 0x82f3, 0x88cd, 0x92c8, 0x9d1e, 0x9dd8, 0x4ac6,
  0x4b17, 0x8dee, 0x52d3, 0x5c47, 0x5cc7, 0x5af6, 0x5be6, 0x6427,
  0x6499, 0x646f, 0x65dd, 0x661f, 0x66dd, 0x6134,
  /* 0x33 */
  0x9f4c, 0x626b, 0x6cbd, 0x697a, 0x747d, 0x7141, 0x728b, 0x7978,
  0x86a8, 0x83f4, 0x9186, 0x9283, 0x8890, 0x55fc, 0x56b3, 0x5d1b,
  0x50be, 0x5fbe, 0x591b, 0x6565, 0x6d8f, 0x69a2, 0x7c80, 0x80c6,
  0x8c5a, 0x8e7f, 0x97aa, 0x9eb5, 0x6961, 0x9da5, 0x82d4, 0x53ae,
  0x63f2, 0x82c3, 0x9603, 0x568e, 0x528a, 0x5009, 0x5ade, 0x66ec,
  0x60b4, 0x6c31, 0x6c35, 0x6fb6, 0x777f, 0x7cb7, 0x7e66, 0x8d97,
  0x8ddf, 0x8966, 0x8b0e, 0x94e0, 0x91ae, 0x9299, 0x9364, 0x5f6b,
  0x58be, 0x6d70, 0x9c40, 0x9c43, 0x6796, 0x7f2d, 0x6e26, 0x6e72,
  0x6cbb, 0x9800, 0x6b52, 0x567f, 0x5190, 0x647d, 0x66e1, 0x6936,
  0x6a0a, 0x6adc, 0x8056, 0x8d1d, 0x8b49, 0x4a19, 0x9834, 0x57fb,
  0x6d16, 0x6e37, 0x9389, 0x6c27, 0x5551, 0x7ece, 0x80bf, 0x95d1,
  0x9781, 0x5256, 0x9925, 0x6c2f, 0x8708, 0x803c,
  /* 0x34 */
  0x78a8, 0x5605, 0x86c8, 0x70eb, 0x4a73, 0x4b8e, 0x55ad, 0x5fdf,
  0x5607, 0x56d5, 0x56ea, 0x59f6, 0x5197, 0x5c27, 0x5deb, 0x5f81,
  0x5f95, 0x5fd6, 0x5a7f, 0x5a74, 0x64ae, 0x6512, 0x656e, 0x65b3,
  0x67d6, 0x616f, 0x63dc, 0x6c5e, 0x6cf7, 0x6f33, 0x6f5e, 0x685a,
  0x6b2f, 0x6b9a, 0x6b48, 0x70bd, 0x7115, 0x72ee, 0x7306, 0x7ef2,
  0x7fac, 0x782c, 0x79e4, 0x7b3b, 0x7bfd, 0x8490, 0x866b, 0x8793,
  0x8dbe, 0x8ec1, 0x88a6, 0x9489, 0x905c, 0x919e, 0x919c, 0x91af,
  0x9268, 0x93de, 0x9d25, 0x8615, 0x4a35, 0x5026, 0x58b5, 0x59c1,
  0x77a4, 0x7241, 0x7331, 0x58a4, 0x7be6, 0x8906, 0x92cc, 0x9c1c,
  0x9c59, 0x9c55, 0x4b0c, 0x4b03, 0x577c, 0x5191, 0x5265, 0x53f7,
  0x5d4a, 0x5f04, 0x5fc9, 0x589d, 0x5a01, 0x5a73, 0x5bc1, 0x67e3,
  0x6337, 0x61da, 0x61ef, 0x6312, 0x6cc6, 0x6cc9,
  /* 0x35 */
  0x6e52, 0x5a3d, 0x6fc8, 0x681a, 0x6870, 0x7172, 0x7d45, 0x5f6e,
  0x7e0d, 0x790d, 0x5bb0, 0x8d82, 0x8e15, 0x88b9, 0x897a, 0x8ac1,
  0x8b10, 0x9cef, 0x9e03, 0x9f31, 0x4a8d, 0x5470, 0x550d, 0x5d9e,
  0x5f91, 0x6622, 0x668d, 0x60e1, 0x6f37, 0x76ad, 0x719c, 0x7d4a,
  0x7ba4, 0x83f6, 0x8eb1, 0x8f7d, 0x67a1, 0x87c7, 0x93ad, 0x5004,
  0x500e, 0x51a6, 0x6c59, 0x6e55, 0x8e7d, 0x7c2a, 0x6378, 0x9ac0,
  0x5779, 0x5faf, 0x8517, 0x825d, 0x940b, 0x4a15, 0x4a48, 0x4aca,
  0x4b1c, 0x57c7, 0x5035, 0x5fa3, 0x5b1e, 0x6428, 0x615c, 0x6330,
  0x684f, 0x687f, 0x68ee, 0x7475, 0x700e, 0x7e7b, 0x7ea3, 0x7f05,
  0x7917, 0x78f3, 0x796b, 0x61ea, 0x7656, 0x57b6, 0x5848, 0x59e5,
  0x66df, 0x66ed, 0x6714, 0x6a2d, 0x8257, 0x8e3c, 0x89d0, 0x96f5,
  0x6b0c, 0x7dab, 0x9f57, 0x4aa5, 0x4aa6, 0x4aa1,
  /* 0x36 */
  0x4b96, 0x4bad, 0x54dc, 0x554a, 0x7efb, 0x557c, 0x55fb, 0x5759,
  0x572c, 0x5772, 0x57e6, 0x51a1, 0x5c8e, 0x58ec, 0x5b3a, 0x5b47,
  0x6422, 0x645d, 0x6460, 0x6712, 0x6154, 0x6e46, 0x68cc, 0x76cf,
  0x76e0, 0x73e2, 0x84f5, 0x8508, 0x8605, 0x8143, 0x94fa, 0x97ec,
  0x93f2, 0x9d5a, 0x9e57, 0x4afd, 0x55d0, 0x5820, 0x628c, 0x6d60,
  0x584d, 0x62ff, 0x6d78, 0x7784, 0x6c5d, 0x788c, 0x54c8, 0x56e9,
  0x534a, 0x59f3, 0x972b, 0x61a9, 0x6f2e, 0x6f30, 0x7039, 0x7d8c,
  0x7db0, 0x7f46, 0x79c7, 0x86b4, 0x87c1, 0x8c72, 0x8d52, 0x8f34,
  0x8bdc, 0x95dc, 0x5012, 0x968d, 0x4a50, 0x543b, 0x57e8, 0x5737,
  0x76da, 0x779b, 0x73e4, 0x86eb, 0x8aa2, 0x9dcb, 0x9dc5, 0x9ddf,
  0x557a, 0x6517, 0x8253, 0x51bd, 0x7e77, 0x547b, 0x5fde, 0x944a,
  0x9288, 0x4a3f, 0x6ed6, 0x95ea, 0x585c, 0x5845,
  /* 0x37 */
  0x6795, 0x7e92, 0x689e, 0x9379, 0x8b6c, 0x7ea7, 0x7587, 0x9285,
  0x788f, 0x6c1a, 0x7a7d, 0x6c5c, 0x9761, 0x56ff, 0x5016, 0x81a6,
  0x8e1e, 0x7ba9, 0x8ac0, 0x94ec, 0x576b, 0x8c85, 0x7d4c, 0x4bcf,
  0x54b3, 0x561c, 0x5549, 0x515e, 0x5320, 0x77e7, 0x5386, 0x5d5c,
  0x5b6f, 0x5b89, 0x6478, 0x657b, 0x656a, 0x65a4, 0x67bf, 0x6037,
  0x6161, 0x6262, 0x6c4f, 0x6a1e, 0x716b, 0x7e30, 0x78f6, 0x7941,
  0x7994, 0x7a46, 0x7b66, 0x8703, 0x8747, 0x82c0, 0x8e05, 0x8e6e,
  0x8f6b, 0x8af0, 0x9c17, 0x9982, 0x86b5, 0x8bc3, 0x9fe5, 0x568a,
  0x6612, 0x608e, 0x6bcd, 0x9294, 0x6c4c, 0x549c, 0x6f2d, 0x6877,
  0x6b59, 0x7e79, 0x795d, 0x8c4d, 0x8e2e, 0x6305, 0x4afb, 0x5434,
  0x542b, 0x5468, 0x5571, 0x5635, 0x566e, 0x51aa, 0x5302, 0x5c08,
  0x5ec1, 0x5af7, 0x65bf, 0x65f5, 0x66fe, 0x677f,
  /* 0x38 */
  0x6d11, 0x6e24, 0x7670, 0x76a1, 0x7723, 0x7c19, 0x7c62, 0x7974,
  0x7301, 0x84a4, 0x8d86, 0x8f14, 0x88ef, 0x8adf, 0x946e, 0x9778,
  0x9277, 0x9c58, 0x9e1e, 0x9a75, 0x554e, 0x5792, 0x57be, 0x5a76,
  0x5b2b, 0x6a16, 0x6a9d, 0x7789, 0x77f3, 0x794e, 0x863a, 0x8e0d,
  0x8ef7, 0x925d, 0x4a43, 0x5406, 0x57e9, 0x5071, 0x52f7, 0x5ddc,
  0x5f69, 0x59fc, 0x5aa6, 0x5b2a, 0x6635, 0x6148, 0x63a2, 0x6a5b,
  0x76dd, 0x78c7, 0x8cb9, 0x84ac, 0x84ec, 0x87fd, 0x8243, 0x8e8a,
  0x89e5, 0x963a, 0x92ca, 0x9c6a, 0x9b1e, 0x4a99, 0x4a9f, 0x4b00,
  0x5745, 0x5044, 0x5033, 0x5e22, 0x5b81, 0x5bac, 0x6492, 0x6caa,
  0x6e83, 0x7057, 0x7c8c, 0x8e93, 0x8ea9, 0x8f7a, 0x959d, 0x4a53,
  0x9fc4, 0x4aa9, 0x4b71, 0x4ba2, 0x5414, 0x541b, 0x5544, 0x5561,
  0x5692, 0x56b4, 0x56f3, 0x5797, 0x57ee, 0x501c,
  /* 0x39 */
  0x5003, 0x5184, 0x535c, 0x53af, 0x5d70, 0x5f59, 0x5f50, 0x5f82,
  0x59e8, 0x59ea, 0x59fa, 0x5a75, 0x5a8e, 0x5a97, 0x5aba, 0x5b15,
  0x645f, 0x6541, 0x669a, 0x66d5, 0x67aa, 0x6136, 0x620f, 0x624e,
  0x62f9, 0x6360, 0x6c2c, 0x6c9a, 0x6dc6, 0x6852, 0x6927, 0x6964,
  0x6a22, 0x6a90, 0x713f, 0x728a, 0x7c61, 0x7e32, 0x78ed, 0x7908,
  0x7915, 0x7953, 0x79bc, 0x8418, 0x840e, 0x84a2, 0x84bc, 0x8559,
  0x8582, 0x8627, 0x875f, 0x8c41, 0x8c6c, 0x8f16, 0x88af, 0x88f1,
  0x94c7, 0x9578, 0x967c, 0x7c32, 0x96f1, 0x91a9, 0x9240, 0x9c08,
  0x9d94, 0x9ed5, 0x9936, 0x5656, 0x56a6, 0x57fa, 0x5005, 0x5cd8,
  0x66fa, 0x6bed, 0x8867, 0x8b52, 0x9ab4, 0x5546, 0x5636, 0x5047,
  0x52f0, 0x7e4d, 0x957a, 0x996d, 0x9adf, 0x7749, 0x6b04, 0x857d,
  0x711c, 0x5bf0, 0x64d7, 0x9ea5, 0x76d6, 0x8bb1,
  /* 0x3a */
  0x6f69, 0x9c0e, 0x4ac7, 0x52fd, 0x5369, 0x5cb3, 0x5e57, 0x6465,
  0x65ca, 0x6202, 0x620b, 0x6c34, 0x6cbc, 0x69fa, 0x71d8, 0x7937,
  0x8663, 0x9f4f, 0x4a96, 0x4b5d, 0x57c4, 0x510b, 0x5962, 0x59eb,
  0x59e3, 0x63f6, 0x6894, 0x707e, 0x7c0f, 0x8e5d, 0x979b, 0x8cd2,
  0x535d, 0x5aaa, 0x6726, 0x54b8, 0x54a1, 0x5580, 0x630d, 0x50c4,
  0x5c53, 0x5db6, 0x5fbd, 0x5b64, 0x6640, 0x67ac, 0x6c30, 0x6f7e,
  0x6a05, 0x7470, 0x95ca, 0x768d, 0x7c18, 0x7c2b, 0x7d60, 0x6183,
  0x793d, 0x87d1, 0x8ccc, 0x8b04, 0x9296, 0x5669, 0x5325, 0x635d,
  0x7b67, 0x88ac, 0x55b9, 0x534f, 0x9227, 0x5c37, 0x6d87, 0x84b9,
  0x50bf, 0x5903, 0x53f1, 0x7c98, 0x99f7, 0x4b51, 0x5647, 0x5086,
  0x6033, 0x6225, 0x6319, 0x63f8, 0x7e89, 0x7f5b, 0x792f, 0x9722,
  0x6c51, 0x9fa0, 0x7f34, 0x5714, 0x5587, 0x563a,
  /* 0x3b */
  0x5fd2, 0x66fb, 0x60a3, 0x60eb, 0x6320, 0x6fb7, 0x81a4, 0x92dc,
  0x729d, 0x9fdb, 0x6741, 0x970b, 0x9fa6, 0x72b2, 0x625f, 0x4a04,
  0x5495, 0x57cf, 0x587c, 0x64e5, 0x609f, 0x616e, 0x6c52, 0x75eb,
  0x77c7, 0x712e, 0x7f9a, 0x7a8f, 0x8298, 0x8f8e, 0x88d6, 0x9575,
  0x9d1d, 0x61a1, 0x62a6, 0x6f86, 0x4ad8, 0x4ad9, 0x4b37, 0x4b72,
  0x5637, 0x57f5, 0x57ff, 0x51ee, 0x52d6, 0x5ce6, 0x5dc6, 0x5dc4,
  0x5df2, 0x5f5d, 0x5840, 0x5a0f, 0x5a26, 0x5bda, 0x6410, 0x670a,
  0x6122, 0x5f51, 0x61a2, 0x61b0, 0x61e5, 0x6390, 0x6f6f, 0x6f76,
  0x6802, 0x7748, 0x7d44, 0x7dcc, 0x78f5, 0x7914, 0x7926, 0x84af,
  0x850f, 0x85fe, 0x8d9b, 0x8e53, 0x8e64, 0x8e6b, 0x8e81, 0x8ee3,
  0x88ca, 0x88d1, 0x92c1, 0x9cf1, 0x6f62, 0x4a86, 0x4b31, 0x4b80,
  0x555d, 0x5f5a, 0x5ff7, 0x6545, 0x670c, 0x624f,
  /* 0x3c */
  0x6f2c, 0x6ac6, 0x68b6, 0x7633, 0x70b0, 0x71d9, 0x7ccc, 0x7d37,
  0x8401, 0x843e, 0x85e7, 0x8099, 0x8b93, 0x685d, 0x9a72, 0x5b02,
  0x8f55, 0x9926, 0x7ef7, 0x8af5, 0x5f80, 0x92e6, 0x4a0e, 0x57fc,
  0x53fa, 0x5d3c, 0x5ec4, 0x5fa9, 0x6484, 0x6a72, 0x6b0b, 0x71b3,
  0x88e7, 0x5f92, 0x810d, 0x7fed, 0x547f, 0x63f9, 0x8690, 0x586c,
  0x8147, 0x7a13, 0x8603, 0x5594, 0x5809, 0x6765, 0x896b, 0x6191,
  0x7563, 0x7d33, 0x791a, 0x8408, 0x8f10, 0x8ac7, 0x9463, 0x82ca,
  0x94a7, 0x5412, 0x56f7, 0x5837, 0x635e, 0x7471, 0x7638, 0x9541,
  0x95c5, 0x9726, 0x86e8, 0x5fcf, 0x5b3c, 0x64f4, 0x4a36, 0x57db,
  0x5f85, 0x6646, 0x633c, 0x6f87, 0x76e4, 0x77ed, 0x7e23, 0x8566,
  0x89ae, 0x955f, 0x9d9b, 0x551f, 0x57da, 0x5067, 0x5ff2, 0x6785,
  0x6e34, 0x79a1, 0x930d, 0x52d7, 0x57c3, 0x5065,
  /* 0x3d */
  0x5f9a, 0x583c, 0x59d3, 0x4be3, 0x650c, 0x66f3, 0x693f, 0x7dcd,
  0x7dc6, 0x794f, 0x7a40, 0x7bdf, 0x85e0, 0x8612, 0x809d, 0x8c4b,
  0x8d7f, 0x8f9d, 0x8a79, 0x8b22, 0x943c, 0x9546, 0x9561, 0x92cb,
  0x9591, 0x4acd, 0x4b42, 0x5548, 0x574c, 0x5b9e, 0x6603, 0x63d9,
  0x684c, 0x6a06, 0x776e, 0x7a2b, 0x95c0, 0x968e, 0x57d9, 0x5d14,
  0x5fb2, 0x69dc, 0x7d50, 0x7a23, 0x7896, 0x5c73, 0x7592, 0x55f7,
  0x8c5e, 0x8bfd, 0x4bc7, 0x58f6, 0x6228, 0x73a1, 0x7eee, 0x8611,
  0x9df2, 0x55cb, 0x5ba7, 0x61e1, 0x6d62, 0x6f84, 0x69fe, 0x6a9b,
  0x6b69, 0x72f3, 0x7919, 0x59ec, 0x9478, 0x958a, 0x9c0b, 0x55eb,
  0x5610, 0x664d, 0x629c, 0x62d4, 0x6a17, 0x5abb, 0x79df, 0x7b7f,
  0x62f5, 0x81a2, 0x81fa, 0x8ef5, 0x56a4, 0x57d4, 0x5d7e, 0x5a82,
  0x5b9d, 0x6458, 0x96e9, 0x9269, 0x54ba, 0x5512,
  /* 0x3e */
  0x56d0, 0x572d, 0x574a, 0x57e1, 0x50e5, 0x514b, 0x513c, 0x521a,
  0x5d65, 0x5db3, 0x5e31, 0x5fb8, 0x580b, 0x5802, 0x581c, 0x5817,
  0x5a89, 0x5a87, 0x5aed, 0x5b7d, 0x6672, 0x6689, 0x66d6, 0x6781,
  0x677a, 0x620a, 0x6201, 0x6220, 0x627b, 0x6373, 0x6caf, 0x6e12,
  0x6e38, 0x68b1, 0x6985, 0x6a04, 0x6a55, 0x7531, 0x752b, 0x756a,
  0x71ca, 0x730c, 0x7c50, 0x7d0c, 0x7d68, 0x7dfd, 0x7eed, 0x7f1c,
  0x78aa, 0x7934, 0x849b, 0x87db, 0x8086, 0x8144, 0x8c50, 0x8cfe,
  0x8e12, 0x8e31, 0x8e59, 0x8e7e, 0x886c, 0x88d3, 0x95a9, 0x966b,
  0x9773, 0x9015, 0x9291, 0x9395, 0x4a07, 0x4a05, 0x4a13, 0x4a5a,
  0x559a, 0x567d, 0x53c3, 0x5c39, 0x5cc1, 0x5f2f, 0x5a35, 0x64c8,
  0x60f3, 0x636c, 0x635b, 0x6949, 0x76bb, 0x717e, 0x7e6e, 0x80b5,
  0x8f7f, 0x95b5, 0x972d, 0x523c, 0x53f9, 0x9cf3,
  /* 0x3f */
  0x66e0, 0x6d00, 0x6f9b, 0x75e0, 0x7a59, 0x847a, 0x867f, 0x8deb,
  0x9cd2, 0x8358, 0x8bbc, 0x5836, 0x4b35, 0x4bec, 0x4bb8, 0x510a,
  0x5e2d, 0x5fd0, 0x5fe4, 0x5bce, 0x6543, 0x6722, 0x61bd, 0x6246,
  0x6ce3, 0x6d96, 0x6975, 0x69fc, 0x713e, 0x71b4, 0x7312, 0x7d53,
  0x7deb, 0x793e, 0x85ee, 0x86a2, 0x81a7, 0x8da7, 0x8e37, 0x8aa6,
  0x8b96, 0x943f, 0x95d0, 0x930a, 0x4ab7, 0x4acc, 0x560e, 0x5c78,
  0x5ce1, 0x5806, 0x7117, 0x5830, 0x8543, 0x8e07, 0x8bc8, 0x926e,
  0x9360, 0x7f28, 0x8ec2, 0x9c05, 0x956f, 0x52fe, 0x57a5, 0x941a,
  0x5034, 0x538f, 0x5a28, 0x67a5, 0x6839, 0x7487, 0x736c, 0x7886,
  0x7bed, 0x8c7d, 0x944f, 0x9559, 0x971d, 0x9715, 0x9282, 0x7053,
  0x9ec9, 0x590a, 0x5964, 0x617d, 0x63af, 0x89a5, 0x92d6, 0x6763,
  0x6344, 0x6d14, 0x87c8, 0x9c1a, 0x92cd, 0x8cf3,
  /* 0x40 */
  0x6b89, 0x6077, 0x5ff5, 0x4a1b, 0x7421, 0x7150, 0x6222, 0x55c9,
  0x563b, 0x56ef, 0x5dde, 0x5b8c, 0x642a, 0x661d, 0x6132, 0x6179,
  0x6212, 0x6279, 0x6cff, 0x6c1b, 0x6f6e, 0x6a08, 0x767f, 0x7112,
  0x72d6, 0x78b3, 0x845b, 0x5cfd, 0x8cf0, 0x8d72, 0x8ead, 0x8e9e,
  0x8ec6, 0x9410, 0x959f, 0x935f, 0x9354, 0x6184, 0x7e03, 0x850b,
  0x92b6, 0x5a20, 0x64d1, 0x6617, 0x61a8, 0x6219, 0x639d, 0x73fe,
  0x7e40, 0x7840, 0x7a33, 0x8507, 0x88a1, 0x8969, 0x89ec, 0x8a52,
  0x7ca4, 0x560a, 0x66d4, 0x67a8, 0x604f, 0x6695, 0x8e20, 0x7e8e,
  0x7fcd, 0x8ea1, 0x92e7, 0x797b, 0x8601, 0x8344, 0x4ad4, 0x5545,
  0x574e, 0x576d, 0x5fae, 0x580f, 0x581b, 0x59d0, 0x662b, 0x664a,
  0x60bd, 0x6c1e, 0x6c39, 0x68c4, 0x6948, 0x691a, 0x63de, 0x6b51,
  0x7543, 0x7570, 0x61c6, 0x7e72, 0x7fa0, 0x79d7,
  /* 0x41 */
  0x7a47, 0x7ba5, 0x8577, 0x8616, 0x8634, 0x81ab, 0x8e63, 0x88c3,
  0x89f8, 0x9475, 0x947a, 0x96a0, 0x969c, 0x918e, 0x9fa3, 0x5640,
  0x5189, 0x6b35, 0x753b, 0x5565, 0x7d88, 0x7a58, 0x85be, 0x78c3,
  0x5241, 0x5c5c, 0x58a5, 0x67a7, 0x62f3, 0x62f0, 0x6d57, 0x76d4,
  0x7182, 0x7183, 0x7d03, 0x7d5b, 0x7dd2, 0x789a, 0x792d, 0x7949,
  0x820a, 0x8e39, 0x9236, 0x946c, 0x9b2d, 0x54ea, 0x5678, 0x57c1,
  0x57ef, 0x5404, 0x51a7, 0x5ce3, 0x5d42, 0x7630, 0x5f86, 0x5869,
  0x5710, 0x64ee, 0x64fe, 0x6751, 0x678e, 0x6732, 0x67b6, 0x60c0,
  0x61e4, 0x62f4, 0x59ee, 0x6dc0, 0x6df0, 0x6b18, 0x75e8, 0x4a84,
  0x71e4, 0x72f5, 0x7e9e, 0x78d2, 0x79c2, 0x7991, 0x846c, 0x8744,
  0x8755, 0x8061, 0x80b1, 0x81f6, 0x8cc8, 0x897d, 0x940c, 0x9460,
  0x979a, 0x9311, 0x9e1f, 0x54c2, 0x5c9a, 0x6583,
  /* 0x42 */
  0x85de, 0x8138, 0x8905, 0x942d, 0x4bce, 0x5479, 0x564a, 0x577e,
  0x6462, 0x6744, 0x6352, 0x6a21, 0x89be, 0x9412, 0x4bda, 0x5853,
  0x88c7, 0x61c2, 0x7997, 0x575f, 0x8c9b, 0x557b, 0x67ce, 0x5f55,
  0x5f66, 0x5807, 0x6000, 0x635c, 0x9451, 0x4adb, 0x5d17, 0x5d27,
  0x687d, 0x8e5c, 0x5133, 0x5c18, 0x5da8, 0x64fd, 0x665e, 0x63cc,
  0x8638, 0x6d58, 0x924d, 0x9dc9, 0x9e25, 0x4b5e, 0x5c0b, 0x5ff3,
  0x841d, 0x58bc, 0x5a22, 0x5b88, 0x642d, 0x6546, 0x6639, 0x62f2,
  0x68fd, 0x6ad3, 0x84c3, 0x8572, 0x86d9, 0x8c86, 0x88b5, 0x940d,
  0x9423, 0x9287, 0x9ad6, 0x9fd6, 0x4aee, 0x57fd, 0x5d2a, 0x7f21,
  0x9580, 0x9c41, 0x99f4, 0x6ad0, 0x742a, 0x575e, 0x5149, 0x5f88,
  0x6655, 0x6693, 0x66de, 0x68af, 0x6be2, 0x702f, 0x8e1a, 0x9035,
  0x6bcc, 0x8ef3, 0x8735, 0x55ea, 0x82f5, 0x57e7,
  /* 0x43 */
  0x57e4, 0x4b4b, 0x9459, 0x8bbd, 0x5d67, 0x853c, 0x59f0, 0x7ee7,
  0x8bb2, 0x6cd7, 0x883a, 0x76f5, 0x9845, 0x6e30, 0x8ebd, 0x4a34,
  0x5755, 0x520b, 0x536b, 0x66c8, 0x67af, 0x61eb, 0x6f43, 0x69ec,
  0x6a56, 0x74a0, 0x73e0, 0x7ee2, 0x7fa7, 0x79b6, 0x8430, 0x84cb,
  0x82c6, 0x8e98, 0x9756, 0x52ee, 0x5cca, 0x5b33, 0x61a0, 0x629b,
  0x6e8d, 0x6fb8, 0x713a, 0x8eca, 0x5429, 0x73e8, 0x533d, 0x5b16,
  0x6468, 0x6277, 0x686d, 0x71f9, 0x7e17, 0x7b63, 0x85f9, 0x8315,
  0x9448, 0x9dbe, 0x7fc4, 0x7151, 0x7ef4, 0x7f5c, 0x80c9, 0x941d,
  0x7de4, 0x7e9f, 0x873b, 0x5eec, 0x734d, 0x4a20, 0x4aff, 0x5f94,
  0x5bed, 0x66b0, 0x6231, 0x63fc, 0x68e5, 0x8266, 0x8c7a, 0x8e36,
  0x9543, 0x96fe, 0x9ddd, 0x6e1a, 0x742b, 0x7727, 0x86ea, 0x805a,
  0x88a2, 0x4a0c, 0x554b, 0x55c6, 0x5186, 0x5ff8,
  /* 0x44 */
  0x5a1b, 0x5a3e, 0x5a8c, 0x5b19, 0x5b38, 0x5b66, 0x5bb9, 0x65ff,
  0x671c, 0x62af, 0x6310, 0x6b63, 0x765f, 0x7137, 0x7337, 0x8479,
  0x8534, 0x8575, 0x837b, 0x8eb2, 0x8ed1, 0x8988, 0x89fe, 0x9697,
  0x917a, 0x9c0f, 0x98e8, 0x56c8, 0x675a, 0x72f9, 0x6318, 0x6885,
  0x77c0, 0x88ce, 0x97a3, 0x927e, 0x6928, 0x5c91, 0x6d03, 0x6dc1,
  0x8bf0, 0x9797, 0x71d6, 0x9417, 0x5c57, 0x6c0f, 0x67b9, 0x6df6,
  0x4b4e, 0x6b21, 0x63d5, 0x8bb6, 0x812b, 0x79b9, 0x9759, 0x6d32,
  0x6b7d, 0x5367, 0x5cfa, 0x5f21, 0x7921, 0x7627, 0x5007, 0x95ee,
  0x99b9, 0x4aa0, 0x4b43, 0x5451, 0x5478, 0x564e, 0x8893, 0x5045,
  0x5c29, 0x5f97, 0x5a10, 0x5a98, 0x5aa0, 0x5afa, 0x5b12, 0x6481,
  0x66b8, 0x6737, 0x67dd, 0x6ca2, 0x684d, 0x7c8a, 0x7d83, 0x7e06,
  0x79ed, 0x864a, 0x8e0f, 0x8eeb, 0x8a49, 0x941e,
  /* 0x45 */
  0x94b5, 0x9520, 0x95d5, 0x9b03, 0x68e8, 0x6055, 0x60ef, 0x6178,
  0x6af9, 0x7289, 0x7f16, 0x9464, 0x97dc, 0x6ab7, 0x50ff, 0x5bb4,
  0x60a9, 0x8b40, 0x8be0, 0x9649, 0x5575, 0x5c66, 0x5d24, 0x5858,
  0x5a9a, 0x69f6, 0x7a82, 0x7111, 0x88b1, 0x8aef, 0x9c56, 0x74b4,
  0x4b10, 0x6fb2, 0x6bbc, 0x713d, 0x92f6, 0x5543, 0x501d, 0x5c38,
  0x5c5a, 0x5da1, 0x586d, 0x5b9f, 0x619a, 0x6351, 0x6a2c, 0x7276,
  0x87d2, 0x88e0, 0x9419, 0x94f0, 0x9740, 0x7c28, 0x7c37, 0x56a7,
  0x5aab, 0x5312, 0x5d79, 0x641f, 0x541f, 0x5557, 0x55a1, 0x55c0,
  0x560d, 0x511d, 0x5c59, 0x5c55, 0x5d5a, 0x5f98, 0x58fb, 0x5986,
  0x64b1, 0x6698, 0x6020, 0x637c, 0x6c4e, 0x6cb1, 0x6cd2, 0x72da,
  0x69d5, 0x6a62, 0x6996, 0x7462, 0x75c5, 0x5b5e, 0x71d5, 0x7d7a,
  0x7f44, 0x7f59, 0x7f5f, 0x78db, 0x797c, 0x563d,
  /* 0x46 */
  0x806e, 0x8164, 0x81e9, 0x8e03, 0x8f09, 0x884b, 0x8a02, 0x940e,
  0x9402, 0x9014, 0x927b, 0x9c20, 0x9e3d, 0x91d5, 0x54c0, 0x56d8,
  0x5001, 0x5c0f, 0x5803, 0x65aa, 0x6093, 0x6913, 0x73be, 0x7ee8,
  0x84f9, 0x8009, 0x945e, 0x9688, 0x58ed, 0x990a, 0x5732, 0x5b9a,
  0x5bbe, 0x6991, 0x7674, 0x736e, 0x7db2, 0x7fe9, 0x6fdf, 0x76e1,
  0x8ea0, 0x6c0e, 0x6e6c, 0x55f5, 0x7e8c, 0x6d39, 0x5847, 0x98fb,
  0x86e6, 0x5fc8, 0x9544, 0x7413, 0x5275, 0x5862, 0x64ca, 0x616b,
  0x6881, 0x8857, 0x944c, 0x9c1e, 0x505c, 0x62ca, 0x9600, 0x5d45,
  0x94ae, 0x5588, 0x4a40, 0x55e7, 0x8194, 0x8f03, 0x7455, 0x6777,
  0x9746, 0x6d6f, 0x9db9, 0x7a09, 0x717a, 0x575a, 0x6d6d, 0x8ad2,
  0x92ee, 0x6850, 0x4a81, 0x5831, 0x5b1d, 0x8be4, 0x570f, 0x88dc,
  0x8484, 0x8274, 0x5af2, 0x61e8, 0x4a7e, 0x5568,
  /* 0x47 */
  0x5d8f, 0x5832, 0x93e3, 0x4af6, 0x5d87, 0x5bc0, 0x8e80, 0x6bec,
  0x7dbd, 0x7d6f, 0x5fea, 0x807c, 0x7726, 0x75bc, 0x5a79, 0x5bf8,
  0x6776, 0x6097, 0x75ce, 0x7895, 0x4a4e, 0x5af1, 0x4a46, 0x53d1,
  0x52af, 0x64a4, 0x6bce, 0x7900, 0x84f0, 0x853e, 0x85b2, 0x8bbf,
  0x8d9a, 0x82a9, 0x59f9, 0x6687, 0x60a0, 0x8d8a, 0x637a, 0x68ef,
  0x6933, 0x703b, 0x7c39, 0x5e4b, 0x7b78, 0x86a0, 0x9da1, 0x4bfe,
  0x5ace, 0x66d0, 0x679f, 0x615a, 0x6362, 0x72ce, 0x7641, 0x84c1,
  0x84b7, 0x8b24, 0x9540, 0x5400, 0x53f4, 0x5e9f, 0x6c88, 0x6d7e,
  0x7569, 0x76f0, 0x88ba, 0x5cff, 0x88ed, 0x9267, 0x9414, 0x8372,
  0x7de9, 0x73ea, 0x8024, 0x4b22, 0x5668, 0x5757, 0x66c0, 0x63c2,
  0x68c7, 0x7270, 0x7f99, 0x7898, 0x863b, 0x8189, 0x8be6, 0x62d0,
  0x6b2d, 0x760b, 0x7a16, 0x87a6, 0x9dcc, 0x9aab,
  /* 0x48 */
  0x55f0, 0x7fbc, 0x7c7f, 0x7fb5, 0x848a, 0x7f45, 0x6ee5, 0x5a6c,
  0x8481, 0x715c, 0x716d, 0x5566, 0x966f, 0x6a81, 0x7277, 0x959a,
  0x9ee7, 0x4b1d, 0x7b7d, 0x6691, 0x7f42, 0x91a8, 0x98e4, 0x5277,
  0x5c54, 0x82e9, 0x92b1, 0x4b39, 0x5629, 0x5747, 0x57c0, 0x57d6,
  0x5a0b, 0x6021, 0x619c, 0x6372, 0x6833, 0x6843, 0x7645, 0x76a2,
  0x77e0, 0x7159, 0x7a4c, 0x8621, 0x81e4, 0x88a4, 0x7fc9, 0x95cb,
  0x7564, 0x9c1f, 0x9ce2, 0x6730, 0x6264, 0x7167, 0x72e9, 0x7cdd,
  0x814e, 0x82e3, 0x5727, 0x575c, 0x502b, 0x5d8e, 0x5a8a, 0x5b71,
  0x64bf, 0x6644, 0x6674, 0x66a6, 0x619d, 0x6fd9, 0x68c1, 0x71bf,
  0x72a3, 0x7c9c, 0x7dd5, 0x79c6, 0x7b7a, 0x84a8, 0x8ca6, 0x8eb4,
  0x88b6, 0x9472, 0x9353, 0x9cd6, 0x6e06, 0x7835, 0x5494, 0x5833,
  0x5ba3, 0x638a, 0x6fd5, 0x7038, 0x7304, 0x7b83,
  /* 0x49 */
  0x9b36, 0x63c7, 0x7e1a, 0x5734, 0x7186, 0x9ee0, 0x5b6b, 0x8590,
  0x87fc, 0x8495, 0x5b31, 0x5bc8, 0x716f, 0x7f4b, 0x9431, 0x6c6a,
  0x5de6, 0x5e96, 0x791d, 0x7273, 0x8f21, 0x4bf8, 0x5b67, 0x6e14,
  0x683a, 0x6b0f, 0x70ef, 0x7d65, 0x8c65, 0x8e58, 0x8874, 0x5ad2,
  0x67c2, 0x71c8, 0x7ddf, 0x86da, 0x9725, 0x96ff, 0x8091, 0x82e0,
  0x9820, 0x50cc, 0x5b61, 0x6181, 0x6951, 0x7418, 0x88aa, 0x88de,
  0x9c36, 0x6142, 0x70fb, 0x4a00, 0x4ad5, 0x53ed, 0x5d26, 0x5e6b,
  0x5fc1, 0x55a5, 0x5a0e, 0x5a91, 0x641b, 0x667b, 0x617a, 0x61aa,
  0x6263, 0x6963, 0x763b, 0x7f2b, 0x855d, 0x8597, 0x8694, 0x8f51,
  0x88ad, 0x88eb, 0x8979, 0x9211, 0x9249, 0x4ba3, 0x60a6, 0x6f6b,
  0x8613, 0x806c, 0x8167, 0x94e5, 0x580c, 0x6d5e, 0x9ca5, 0x8077,
  0x815a, 0x4b02, 0x5662, 0x5ba4, 0x5a48, 0x6300,
  /* 0x4a */
  0x7d82, 0x8574, 0x8d0a, 0x8d8b, 0x69f8, 0x5b1a, 0x6658, 0x68b5,
  0x4ac2, 0x7664, 0x9f9f, 0x560b, 0x5036, 0x5279, 0x5cbe, 0x65a9,
  0x6663, 0x7517, 0x5d63, 0x7884, 0x78d3, 0x7916, 0x92fd, 0x618a,
  0x8453, 0x4a14, 0x4b78, 0x5578, 0x5c4d, 0x5a6e, 0x5a7e, 0x5b07,
  0x63c9, 0x4a2b, 0x8130, 0x9184, 0x9256, 0x787e, 0x9c0c, 0x54f6,
  0x5ccc, 0x725b, 0x7caa, 0x5628, 0x73a8, 0x811c, 0x7f8b, 0x5442,
  0x5d04, 0x764a, 0x7fca, 0x79e5, 0x8bb7, 0x8bd9, 0x9440, 0x4bb2,
  0x56c4, 0x5e24, 0x5b0c, 0x93a0, 0x4bd0, 0x861a, 0x96e7, 0x530e,
  0x6758, 0x6f64, 0x7126, 0x8cd1, 0x8b19, 0x7e4f, 0x56d2, 0x5c9e,
  0x6558, 0x6607, 0x62a3, 0x6fc0, 0x7832, 0x87e4, 0x542e, 0x4bf5,
  0x5708, 0x504b, 0x5c3c, 0x5d44, 0x5f90, 0x58fd, 0x58e2, 0x5924,
  0x5a9b, 0x66bc, 0x676a, 0x6133, 0x61b4, 0x6306,
  /* 0x4b */
  0x68d8, 0x68ec, 0x74f4, 0x7c3f, 0x7a26, 0x84d3, 0x86be, 0x8001,
  0x80e1, 0x830f, 0x8d1f, 0x8e27, 0x8847, 0x94ab, 0x96df, 0x9cf0,
  0x98fe, 0x9961, 0x4a42, 0x4aac, 0x5480, 0x565b, 0x5347, 0x5da5,
  0x5a30, 0x5bd5, 0x5bd4, 0x6632, 0x62b9, 0x6316, 0x63dd, 0x6cdf,
  0x559f, 0x792c, 0x84a7, 0x85a5, 0x8f0d, 0x8881, 0x88b2, 0x9673,
  0x923f, 0x502d, 0x9c21, 0x571a, 0x54d8, 0x5751, 0x5ca5, 0x60bf,
  0x6339, 0x766a, 0x736b, 0x7e4b, 0x95eb, 0x56ce, 0x68ac, 0x6f8b,
  0x5c0d, 0x5a41, 0x5d59, 0x6321, 0x7bf6, 0x55ec, 0x72cb, 0x6064,
  0x7ce5, 0x9f59, 0x9ab6, 0x53c6, 0x5db4, 0x622a, 0x6397, 0x6fc3,
  0x50e4, 0x6dd4, 0x5a58, 0x8591, 0x6398, 0x9fa7, 0x63f3, 0x985f,
  0x6c50, 0x4aab, 0x4bee, 0x57c5, 0x66b4, 0x6326, 0x68a6, 0x8bc9,
  0x4ba0, 0x7a60, 0x9ab2, 0x4a0a, 0x656f, 0x6a8d,
  /* 0x4c */
  0x6b26, 0x811e, 0x507e, 0x6327, 0x9f48, 0x59fe, 0x7f98, 0x58a1,
  0x5fcb, 0x8311, 0x6a47, 0x80dc, 0x7e19, 0x8505, 0x5d94, 0x7880,
  0x681c, 0x732d, 0x56d4, 0x5d2f, 0x752c, 0x7652, 0x73d6, 0x932a,
  0x996c, 0x6d06, 0x5e72, 0x5e15, 0x55a8, 0x5000, 0x5070, 0x6203,
  0x72d2, 0x8bfa, 0x9695, 0x98f9, 0x5de7, 0x7650, 0x6ac8, 0x5540,
  0x6cc4, 0x79b2, 0x79e1, 0x936f, 0x9ab7, 0x6075, 0x6e2c, 0x870f,
  0x5d89, 0x5f52, 0x6fd6, 0x7716, 0x72ff, 0x79bf, 0x841a, 0x8094,
  0x553f, 0x6325, 0x9ad4, 0x72e3, 0x636f, 0x56f2, 0x9d08, 0x5829,
  0x6636, 0x7873, 0x88bd, 0x5142, 0x64bb, 0x7906, 0x918d, 0x570c,
  0x4a52, 0x55bb, 0x5d11, 0x7637, 0x843b, 0x95c3, 0x5b28, 0x73ef,
  0x5789, 0x5b74, 0x7909, 0x81a1, 0x8e3e, 0x8a80, 0x935b, 0x63fe,
  0x81a3, 0x905e, 0x6504, 0x6505, 0x68b4, 0x725f,
  /* 0x4d */
  0x8ee0, 0x8b35, 0x5122, 0x4b5c, 0x5527, 0x56ca, 0x57c6, 0x5fa8,
  0x5a70, 0x64ad, 0x658f, 0x67db, 0x6304, 0x63d7, 0x6a6a, 0x6981,
  0x773b, 0x773a, 0x713c, 0x7d5d, 0x8cd8, 0x8e95, 0x9447, 0x949c,
  0x94f8, 0x92c9, 0x8380, 0x5d18, 0x4a85, 0x4b54, 0x4a03, 0x8e84,
  0x8b32, 0x9c1d, 0x54a0, 0x5a71, 0x5d9b, 0x5fb4, 0x5ab5, 0x67d7,
  0x67f7, 0x60cc, 0x62d1, 0x6d47, 0x6dd5, 0x6906, 0x6abb, 0x7599,
  0x7125, 0x7ea2, 0x7b87, 0x840d, 0x8044, 0x80c4, 0x8d8c, 0x8f2c,
  0x8a07, 0x9468, 0x9270, 0x9d07, 0x6573, 0x669c, 0x6f3f, 0x688e,
  0x6979, 0x7bc1, 0x7bf1, 0x69cd, 0x7b88, 0x83b7, 0x8cf5, 0x6368,
  0x87bc, 0x9c31, 0x92fa, 0x6916, 0x796c, 0x8030, 0x9567, 0x4a7c,
  0x5778, 0x595d, 0x6f09, 0x6be6, 0x81c0, 0x8220, 0x8daa, 0x5624,
  0x5002, 0x5868, 0x6343, 0x6ca5, 0x700b, 0x708e,
  /* 0x4e */
  0x71ef, 0x8cc2, 0x8cec, 0x95c1, 0x92ef, 0x9275, 0x5b86, 0x778a,
  0x7ec6, 0x8043, 0x67ad, 0x7168, 0x5684, 0x694c, 0x6a91, 0x7004,
  0x7154, 0x7c66, 0x789f, 0x928b, 0x7ed1, 0x9b80, 0x4bbb, 0x6563,
  0x61c8, 0x8251, 0x4a8b, 0x4aa3, 0x54d7, 0x4a2c, 0x55c1, 0x5fe3,
  0x6194, 0x6c8c, 0x69b1, 0x7712, 0x724f, 0x73a0, 0x7e11, 0x78ea,
  0x8662, 0x8edf, 0x9471, 0x95c2, 0x9278, 0x9c15, 0x5696, 0x79dc,
  0x5426, 0x5795, 0x639a, 0x69c6, 0x75dd, 0x703e, 0x85e5, 0x8b27,
  0x92ae, 0x985a, 0x9a92, 0x706d, 0x5c4c, 0x6994, 0x7922, 0x9c53,
  0x4ae9, 0x4b3b, 0x4b86, 0x55ba, 0x56bc, 0x59b7, 0x6411, 0x77bf,
  0x7d31, 0x86de, 0x9639, 0x92ba, 0x92fb, 0x9307, 0x9a9a, 0x9b6f,
  0x62ab, 0x6f79, 0x561a, 0x56ae, 0x74c5, 0x8ccf, 0x5ac4, 0x6446,
  0x659d, 0x6b2e, 0x7544, 0x7833, 0x79f9, 0x8462,
  /* 0x4f */
  0x80e3, 0x942e, 0x9721, 0x504f, 0x9f62, 0x6ede, 0x7484, 0x88cf,
  0x89e2, 0x933f, 0x56b9, 0x5e4c, 0x5ac7, 0x5b09, 0x631a, 0x6d71,
  0x6d99, 0x6967, 0x6b02, 0x766f, 0x76f1, 0x7fe0, 0x840c, 0x8473,
  0x8346, 0x94c3, 0x5560, 0x9a9e, 0x7d89, 0x8486, 0x973f, 0x8edb,
  0x5420, 0x5081, 0x8e7c, 0x6f67, 0x88c9, 0x850a, 0x64dc, 0x63ad,
  0x99ff, 0x4a94, 0x4a95, 0x981d, 0x8e66, 0x81cc, 0x8165, 0x6d0d,
  0x6a73, 0x7c9a, 0x8558, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0, 0xfbf0,
  /* 0x50 */
  0x5b01, 0x4a1d, 0x4a18, 0x4a27, 0x4a3c, 0x4a3b, 0x4a31, 0x4a32,
  0x4a4f, 0x4a5b, 0x4a55, 0x4a8f, 0x4a88, 0x8866, 0x4a87, 0x861f,
  0x5b00, 0x4a83, 0x4a93, 0x4a92, 0x4aad, 0x4aaf, 0x4abd, 0x4abe,
  0x4abb, 0x4ac3, 0x4ac0, 0x4ac9, 0x4acb, 0x4acf, 0x4ada, 0x4ad3,
  0x4ae0, 0x4ad2, 0x4afa, 0x4b04, 0x4b57, 0x4b3d, 0x4b56, 0x4b50,
  0x4b5a, 0x4b4a, 0x4b7b, 0x4b85, 0x4b82, 0x4b95, 0x4b76, 0x4b64,
  0x4b7d, 0x4b9c, 0x4b62, 0x4b8b, 0x4b9b, 0x5515, 0x4bd9, 0x4bd2,
  0x4bc3, 0x4bd5, 0x4bd6, 0x4bdc, 0x4bd7, 0x4bdd, 0x4be9, 0x4be8,
  0x5417, 0x5425, 0x5419, 0x5427, 0x5428, 0x5408, 0x4b11, 0x4bfb,
  0x542c, 0x5424, 0x5421, 0x4bf3, 0x4be2, 0x541c, 0x540b, 0x544e,
  0x544a, 0x630e, 0x5458, 0x545d, 0x5445, 0x5457, 0x545b, 0x5461,
  0x5475, 0x548d, 0x5497, 0x5488, 0x54b9, 0x54bf,
  /* 0x51 */
  0x54c4, 0x54c7, 0x54be, 0x54cf, 0x54db, 0x54d3, 0x54e8, 0x54e0,
  0x54ee, 0x54e3, 0x54f4, 0x54f8, 0x5504, 0x550c, 0x550f, 0x551b,
  0x5518, 0x5519, 0x5517, 0x552c, 0x5537, 0x553a, 0x5531, 0x5536,
  0x5532, 0x554d, 0x555f, 0x5541, 0x5559, 0x556f, 0x7ef5, 0x5564,
  0x5567, 0x5563, 0x558d, 0x558f, 0x52d5, 0x5581, 0x5584, 0x5582,
  0x559c, 0x559e, 0x5598, 0x559b, 0x55a9, 0x55ab, 0x55af, 0x55a4,
  0x55a7, 0x55a6, 0x55be, 0x55bc, 0x55bf, 0x55bd, 0x55b8, 0x55b0,
  0x55c8, 0x55c4, 0x55d6, 0x55ed, 0x8258, 0x55e4, 0x55e0, 0x55fd,
  0x55f8, 0x55f3, 0x5609, 0x5606, 0x5619, 0x5603, 0x562a, 0x5627,
  0x5623, 0x563e, 0x5634, 0x5642, 0x5649, 0x5646, 0x5641, 0x5653,
  0x5659, 0x5667, 0x5679, 0x5664, 0x567e, 0x5672, 0x5670, 0x5680,
  0x5699, 0x569f, 0x567c, 0x5685, 0x569c, 0x8ba5,
  /* 0x52 */
  0x8baa, 0x56a1, 0x56a0, 0x56b1, 0x56b8, 0x56cc, 0x56c0, 0x56da,
  0x56d3, 0x56ee, 0x56eb, 0x9ce0, 0x56ed, 0x56fe, 0x56f8, 0x56f5,
  0x56f4, 0x570b, 0x5705, 0x7135, 0x5700, 0x571d, 0x5702, 0x5718,
  0x5717, 0x572e, 0x5722, 0x573c, 0x573e, 0x5735, 0x574d, 0x574b,
  0x5748, 0x4a1a, 0x5744, 0x5740, 0x55db, 0x5753, 0x5764, 0x5763,
  0x5d15, 0x5776, 0x577a, 0x578f, 0x579b, 0x57ad, 0x57ab, 0x57a8,
  0x57a3, 0x57bd, 0x57bb, 0x57ce, 0x781f, 0x92d4, 0x57d2, 0x62f1,
  0x75e3, 0x57e3, 0x57e5, 0x57e0, 0x57f7, 0x500c, 0x5030, 0x504d,
  0x5021, 0x5020, 0x5031, 0x5023, 0x503b, 0x5024, 0x5010, 0x5043,
  0x5082, 0x5078, 0x5083, 0x5052, 0x507c, 0x507a, 0x507d, 0x509f,
  0x5076, 0x508d, 0x507b, 0x5089, 0x509d, 0x508b, 0x50ca, 0x50af,
  0x50b5, 0x50a8, 0x50a1, 0x50c9, 0x50c5, 0x50a5,
  /* 0x53 */
  0x50a6, 0x50cf, 0x50a9, 0x50b3, 0x50b1, 0x50d5, 0x50e8, 0x50eb,
  0x5102, 0x5119, 0x50f0, 0x50e3, 0x50e0, 0x50f7, 0x50ef, 0x5134,
  0x514d, 0x516e, 0x5141, 0x5123, 0x5151, 0x5148, 0x515b, 0x515a,
  0x5135, 0x513e, 0x5150, 0x5194, 0x518d, 0x50a2, 0x5187, 0x5192,
  0x5176, 0x5173, 0x5195, 0x5193, 0x51a3, 0x5171, 0x518e, 0x51a4,
  0x518a, 0x51a5, 0x51d7, 0x51c8, 0x51d2, 0x51c9, 0x51d1, 0x51e9,
  0x51d9, 0x5219, 0x51fa, 0x521b, 0x51f3, 0x51f0, 0x5216, 0x51f4,
  0x5243, 0x525d, 0x75d2, 0x5239, 0x523b, 0x523f, 0x5235, 0x5266,
  0x5269, 0x5222, 0x5261, 0x5267, 0x528b, 0x528d, 0x5287, 0x52ad,
  0x5299, 0x5282, 0x52a8, 0x52a3, 0x52bb, 0x52b9, 0x52cf, 0x52b1,
  0x52cc, 0x52ce, 0x52cd, 0x52c5, 0x52c3, 0x52dc, 0x52de, 0x52da,
  0x52e3, 0x52f4, 0x530d, 0x52f2, 0x5309, 0x5304,
  /* 0x54 */
  0x5305, 0x5306, 0x5300, 0x531e, 0x5315, 0x531b, 0x51ca, 0x5311,
  0x532b, 0x533a, 0x5335, 0x5343, 0x5336, 0x534d, 0x5342, 0x5364,
  0x53cd, 0x5385, 0x536c, 0x5372, 0x5384, 0x539e, 0x53ad, 0x53be,
  0x53a9, 0x53a7, 0x53bd, 0x53ce, 0x53cb, 0x53d9, 0x53df, 0x53de,
  0x5c07, 0x53db, 0x53ee, 0x5c06, 0x5c14, 0x5c10, 0x5c7f, 0x5c2c,
  0x5c6f, 0x5c46, 0x5c7d, 0x6fcd, 0x5c5f, 0x5c30, 0x5c74, 0x5c88,
  0x5cb4, 0x5c92, 0x5ca6, 0x5cb7, 0x5cd3, 0x5cb6, 0x5cb5, 0x5ca3,
  0x5cc8, 0x5cde, 0x5cdc, 0x5cda, 0x5cd4, 0x5cd5, 0x5ce8, 0x5cd1,
  0x5ce9, 0x5cd2, 0x5ce2, 0x5cf7, 0x5cf4, 0x5cf6, 0x5cf1, 0x5cf0,
  0x5d0f, 0x5d07, 0x5d1d, 0x5d16, 0x6cab, 0x5d28, 0x5d21, 0x5d20,
  0x5d3f, 0x5d35, 0x5d33, 0x7edf, 0x5d58, 0x5d5d, 0x5d43, 0x5d57,
  0x5d55, 0x5d6f, 0x5d6d, 0x5d6a, 0x5d61, 0x5d64,
  /* 0x55 */
  0x5d75, 0x5d8c, 0x5d90, 0x4b53, 0x4ba6, 0x5dae, 0x5dbf, 0x5dcb,
  0x5de5, 0x5dd1, 0x5d80, 0x5dd4, 0x5dd7, 0x5e28, 0x5e12, 0x5e1c,
  0x5e11, 0x5e04, 0x5e17, 0x5e4d, 0x5e61, 0x5e44, 0x5e38, 0x5e3b,
  0x5e6f, 0x5e67, 0x5e97, 0x5eb1, 0x5eb3, 0x5ec6, 0x5ecf, 0x5eb0,
  0x5eee, 0x5eda, 0x5eeb, 0x5ee4, 0x5edb, 0x5ef7, 0x5ef6, 0x5f01,
  0x5f06, 0x5f1b, 0x5f3f, 0x5edd, 0x5f27, 0x5f3b, 0x5f33, 0x5f4e,
  0x5f48, 0x5f4d, 0x5f5c, 0x5f58, 0x5f57, 0x5f56, 0x5f68, 0x5f64,
  0x5f7d, 0x5f7e, 0x5f78, 0x5f75, 0x6185, 0x5f77, 0x5f8d, 0x5f8e,
  0x5fab, 0x5fb5, 0x5fce, 0x5fca, 0x5fc4, 0x5fd9, 0x5fdd, 0x5fe9,
  0x5feb, 0x5fef, 0x5fd3, 0x5fe8, 0x5fe6, 0x5ffd, 0x5ffb, 0x5ffe,
  0x5808, 0x580a, 0x5805, 0x5800, 0x581e, 0x582d, 0x582f, 0x5825,
  0x5835, 0x5834, 0x584c, 0x584b, 0x5843, 0x585e,
  /* 0x56 */
  0x585d, 0x5842, 0x5f7c, 0x5861, 0x5863, 0x4a6f, 0x587b, 0x5874,
  0x5881, 0x589c, 0x5899, 0x5d96, 0x58a6, 0x58b6, 0x58bb, 0x58b1,
  0x58ba, 0x58c8, 0x58b3, 0x58ca, 0x58d4, 0x58e4, 0x58f0, 0x58f7,
  0x58e0, 0x5981, 0x58e7, 0x5906, 0x5918, 0x591a, 0x5951, 0x5912,
  0x5916, 0x591c, 0x5919, 0x592f, 0x5917, 0x5914, 0x5915, 0x5941,
  0x595f, 0x5943, 0x5946, 0x5961, 0x597e, 0x597b, 0x598a, 0x5989,
  0x598f, 0x59af, 0x5990, 0x59a1, 0x59a3, 0x59b0, 0x599d, 0x59ba,
  0x59b1, 0x59c4, 0x59c0, 0x59de, 0x59df, 0x59db, 0x59d6, 0x59e6,
  0x59ff, 0x59f8, 0x5a06, 0x5a17, 0x5a14, 0x5a1c, 0x5a16, 0x5a3b,
  0x5a3a, 0x5a49, 0x5a4e, 0x5a4d, 0x5a43, 0x5a5a, 0x5a59, 0x5a52,
  0x5a6f, 0x5a69, 0x5a4a, 0x5a78, 0x5a7b, 0x5a77, 0x9ab1, 0x5a72,
  0x5aad, 0x5acc, 0x5acf, 0x5ac5, 0x5add, 0x5ac2,
  /* 0x57 */
  0x5adb, 0x5aee, 0x5ad0, 0x5ad7, 0x5ad6, 0x5aef, 0x5aec, 0x5ae5,
  0x5ae4, 0x5ae1, 0x5afc, 0x5afe, 0x5afd, 0x5af9, 0x5af5, 0x5af3,
  0x5b0e, 0x5b04, 0x5b50, 0x5b51, 0x5b06, 0x5b1c, 0x5b1b, 0x5b24,
  0x5b20, 0x5b35, 0x5b4c, 0x5b45, 0x5b41, 0x5b43, 0x5b22, 0x5b5c,
  0x5b5b, 0x5b5a, 0x5b54, 0x5b6c, 0x5b60, 0x5b7e, 0x5b7a, 0x5b8e,
  0x5b8f, 0x5b72, 0x5b87, 0x5b85, 0x5b9c, 0x5b8a, 0x5b93, 0x5b94,
  0x5b95, 0x5bad, 0x5ba5, 0x5ba0, 0x5bb1, 0x5bdb, 0x5bf6, 0x5be9,
  0x5bf5, 0x5bfc, 0x5bd0, 0x64be, 0x5bf2, 0x642c, 0x646d, 0x6414,
  0x641d, 0x6424, 0x6403, 0x643c, 0x6416, 0x6418, 0x6426, 0x642b,
  0x6402, 0x6437, 0x6457, 0x644c, 0x6467, 0x647a, 0x6452, 0x6447,
  0x644b, 0x6440, 0x646e, 0x644e, 0x6469, 0x644f, 0x6461, 0x6466,
  0x6454, 0x648c, 0x6480, 0x64ea, 0x648e, 0x6497,
  /* 0x58 */
  0x6489, 0x6496, 0x649b, 0x649a, 0x649f, 0x64aa, 0x6486, 0x64ec,
  0x64b5, 0x64ed, 0x64de, 0x64b9, 0x5bfd, 0x64b0, 0x64cb, 0x64b8,
  0x64d5, 0x6540, 0x6518, 0x650b, 0x64fb, 0x64fa, 0x650d, 0x64f9,
  0x64f7, 0x650e, 0x652c, 0x64f6, 0x64fc, 0x6500, 0x6503, 0x654a,
  0x6533, 0x6525, 0x652a, 0x6547, 0x6532, 0x6531, 0x6521, 0x6539,
  0x6530, 0x654f, 0x6549, 0x657e, 0x657a, 0x6555, 0x6554, 0x6557,
  0x6566, 0x6579, 0x6562, 0x6568, 0x657c, 0x6552, 0x6550, 0x655e,
  0x6578, 0x6594, 0x659b, 0x658a, 0x65a1, 0x6599, 0x6597, 0x6587,
  0x659c, 0x65a6, 0x65a3, 0x65c1, 0x65c7, 0x65c4, 0x65fa, 0x65c5,
  0x65ce, 0x65cb, 0x65b7, 0x65c6, 0x7b74, 0x65c0, 0x65eb, 0x65ee,
  0x65fb, 0x65f7, 0x65f9, 0x65f2, 0x65f0, 0x65f1, 0x65f3, 0x660d,
  0x6605, 0x6604, 0x6600, 0x6601, 0x6619, 0x6616,
  /* 0x59 */
  0x6613, 0x662c, 0x6627, 0x6623, 0x663d, 0x663f, 0x663e, 0x664c,
  0x6643, 0x6653, 0x666e, 0x6656, 0x666d, 0x6665, 0x6671, 0x668f,
  0x6684, 0x6673, 0x669f, 0x669e, 0x669b, 0x66d9, 0x668e, 0x6699,
  0x66da, 0x66dc, 0x66b6, 0x66c2, 0x66f2, 0x66cb, 0x60d9, 0x66c5,
  0x66d1, 0x66c1, 0x66c7, 0x66cf, 0x66ca, 0x6696, 0x66c4, 0x6701,
  0x66e3, 0x66fc, 0x672a, 0x670f, 0x6705, 0x66e2, 0x66f8, 0x675d,
  0x6733, 0x6740, 0x6011, 0x6742, 0x679b, 0x6783, 0x678d, 0x67a6,
  0x677b, 0x67ae, 0x6782, 0x6784, 0x6792, 0x67b8, 0x6766, 0x6764,
  0x67b3, 0x67e4, 0x67cd, 0x67cb, 0x67ee, 0x67c4, 0x67df, 0x67fb,
  0x67c9, 0x601b, 0x6039, 0x600b, 0x601e, 0x602b, 0x603b, 0x6110,
  0x601a, 0x6025, 0x6002, 0x606a, 0x6062, 0x607b, 0x6043, 0x6127,
  0x6098, 0x609e, 0x60a8, 0x60a4, 0x6085, 0x60b1,
  /* 0x5a */
  0x60d7, 0x60df, 0x60c8, 0x60ca, 0x60b6, 0x60d5, 0x60cf, 0x60fc,
  0x60ea, 0x8604, 0x60ed, 0x60ec, 0x66a1, 0x60ee, 0x60e2, 0x6121,
  0x60fb, 0x60f9, 0x60ff, 0x60f7, 0x610d, 0x60f0, 0x6115, 0x6111,
  0x6108, 0x6129, 0x612e, 0x6126, 0x6139, 0x6138, 0x613a, 0x613b,
  0x6135, 0x7146, 0x6145, 0x615b, 0x6158, 0x6140, 0x6155, 0x6153,
  0x6150, 0x617f, 0x6175, 0x618f, 0x618e, 0x8f87, 0x6196, 0x6192,
  0x61a6, 0x61ba, 0x61ce, 0x61cb, 0x61cc, 0x61c9, 0x61c1, 0x61df,
  0x61d6, 0x61d4, 0x61ed, 0x61ec, 0x61fc, 0x637f, 0x6207, 0x620e,
  0x61f6, 0x637e, 0x6238, 0x623b, 0x6239, 0x6211, 0x6242, 0x6249,
  0x6244, 0x624c, 0x6253, 0x6250, 0x6269, 0x626a, 0x6265, 0x6252,
  0x626f, 0x627d, 0x628e, 0x6285, 0x6283, 0x6284, 0x6289, 0x6295,
  0x6290, 0x62cc, 0x62b4, 0x62c4, 0x62b3, 0x62b1,
  /* 0x5b */
  0x62c9, 0x62b5, 0x62db, 0x62d7, 0x62ed, 0x6232, 0x62eb, 0x62e4,
  0x62fd, 0x62f8, 0x62fa, 0x6302, 0x631b, 0x6313, 0x632b, 0x632a,
  0x9335, 0x6323, 0x6332, 0x633b, 0x634c, 0x6335, 0x633a, 0x634b,
  0x6353, 0x636d, 0x6354, 0x636e, 0x6369, 0x6384, 0x637d, 0x63a4,
  0x6371, 0x6367, 0x6381, 0x6386, 0x63ab, 0x63ac, 0x6388, 0x63ba,
  0x63e2, 0x63b9, 0x63e1, 0x63be, 0x63e4, 0x63b5, 0x63e9, 0x63d3,
  0x63d0, 0x63ef, 0x63e3, 0x63b4, 0x63c3, 0x63cb, 0x63ea, 0x6e91,
  0x6c13, 0x6c4b, 0x6c24, 0x6c4d, 0x6c40, 0x6c3f, 0x6c43, 0x6cbe,
  0x6c26, 0x6c54, 0x6c6e, 0x6c7a, 0x6c72, 0x6c92, 0x6c82, 0x6ca0,
  0x6c99, 0x6c90, 0x6c96, 0x6c8e, 0x6ea3, 0x6cb4, 0x6c79, 0x6cb8,
  0x6cad, 0x6cb7, 0x6d02, 0x6c80, 0x6c73, 0x6d0c, 0x6cc7, 0x6d05,
  0x6cd5, 0x6d2f, 0x6d2b, 0x6cec, 0x6d01, 0x6cc0,
  /* 0x5c */
  0x6cd9, 0x6cea, 0x6cd8, 0x6d3b, 0x6d1f, 0x6d09, 0x6cda, 0x6cee,
  0x6d28, 0x6cf4, 0x6ced, 0x6ce2, 0x6d25, 0x6d27, 0x6d17, 0x6d2e,
  0x6d2c, 0x6ccb, 0x6d74, 0x6d7a, 0x6d51, 0x6d75, 0x6d66, 0x6d59,
  0x6d73, 0x6d63, 0x6d34, 0x6d79, 0x6d30, 0x6d54, 0x6d3d, 0x6d6c,
  0x6d53, 0x6d50, 0x6d8c, 0x6d67, 0x6dbf, 0x6da3, 0x6ddd, 0x6db2,
  0x6dcc, 0x6dde, 0x6db3, 0x6dc3, 0x5fe5, 0x6dc7, 0x6dd0, 0x6db6,
  0x6dce, 0x6daa, 0x6e23, 0x6d9c, 0x6dad, 0x6d91, 0x6d98, 0x6db9,
  0x6dd3, 0x6de5, 0x6e0f, 0x6e16, 0x6df2, 0x6f07, 0x6df4, 0x6dff,
  0x6dea, 0x6e08, 0x6dbc, 0x6e13, 0x6de0, 0x6e19, 0x6de6, 0x6e07,
  0x6e1f, 0x6ecc, 0x6e2e, 0x6e1e, 0x6e49, 0x6e01, 0x6e7f, 0x6e3b,
  0x6e75, 0x6e4a, 0x6e6f, 0x6e54, 0x6e6b, 0x6e45, 0x6e35, 0x6e2f,
  0x6e9d, 0x6e80, 0x6ead, 0x6e89, 0x6eaf, 0x6eae,
  /* 0x5d */
  0x6e9a, 0x821a, 0x6eb6, 0x6ece, 0x6ecf, 0x6eb5, 0x6ebe, 0x6ea1,
  0x6ed3, 0x6edc, 0x6ed2, 0x6ea7, 0x6ed7, 0x6ee7, 0x6ef6, 0x6f08,
  0x821b, 0x6ef7, 0x6f1f, 0x6f1b, 0x9f3c, 0x6f12, 0x6f35, 0x6f3a,
  0x72d1, 0x6f34, 0x9ce3, 0x6f4a, 0x6f4e, 0x6f44, 0x6f5d, 0x6f54,
  0x6f59, 0x6f56, 0x6f52, 0x6f6c, 0x6f75, 0x6f74, 0x6f72, 0x6f8d,
  0x6f89, 0x6f8e, 0x6f80, 0x6f95, 0x6f98, 0x6f93, 0x6fa9, 0x6fa7,
  0x6fa6, 0x6fa2, 0x6fbf, 0x6fbc, 0x6fbe, 0x6fba, 0x6fb1, 0x6fcb,
  0x6fc6, 0x6fde, 0x6fd2, 0x6fe1, 0x6fe6, 0x6ffe, 0x6fe2, 0x9ab3,
  0x6805, 0x681e, 0x6819, 0x6816, 0x6829, 0x682e, 0x6853, 0x6858,
  0x686f, 0x6867, 0x688f, 0x6880, 0x6897, 0x688c, 0x6896, 0x6873,
  0x6865, 0x687e, 0x689f, 0x689d, 0x68c9, 0x68fc, 0x68de, 0x68b0,
  0x68da, 0x68c8, 0x68d0, 0x68a3, 0x68bc, 0x68b3,
  /* 0x5e */
  0x68b7, 0x68d6, 0x68e2, 0x68d4, 0x68e7, 0x6912, 0x8c40, 0x693b,
  0x6926, 0x6930, 0x6935, 0x6914, 0x6938, 0x693e, 0x691f, 0x6901,
  0x696e, 0x699e, 0x6969, 0x6957, 0x6974, 0x6954, 0x6983, 0x6998,
  0x6be9, 0x6988, 0x69f4, 0x6a18, 0x6a07, 0x69b8, 0x69ca, 0x69eb,
  0x69b5, 0x69cb, 0x69e1, 0x69d3, 0x69c1, 0x69e5, 0x69df, 0x69c8,
  0x69f7, 0x69d4, 0x69e9, 0x69d8, 0x69e7, 0x69e3, 0x6a20, 0x6a63,
  0x6a23, 0x6a14, 0x6a7f, 0x6a52, 0x6a33, 0x6a2e, 0x6a66, 0x6a26,
  0x6a7b, 0x6a40, 0x6a12, 0x6a4e, 0x6a37, 0x6a43, 0x6a29, 0x6af2,
  0x6a10, 0x6a35, 0x6a8f, 0x6aa7, 0x6a95, 0x6ac4, 0x6aba, 0x6ade,
  0x6ab0, 0x6aa2, 0x6ac9, 0x6abf, 0x6ad9, 0x6ad8, 0x6a82, 0x6aa8,
  0x6acf, 0x6a92, 0x6b4c, 0x6b1c, 0x7441, 0x6ae1, 0x6af5, 0x6af3,
  0x6b32, 0x6aff, 0x6b3c, 0x6ae2, 0x6b3f, 0x6ac1,
  /* 0x5f */
  0x6b33, 0x6b1e, 0x6afa, 0x6b8b, 0x6b77, 0x6b75, 0x6b8c, 0x6b8d,
  0x6b62, 0x6b56, 0x6bfe, 0x6b60, 0x6b8f, 0x6b71, 0x6b55, 0x6b83,
  0x6b9c, 0x6bcf, 0x6b6b, 0x6bbe, 0x6bae, 0x6bac, 0x6ba9, 0x6bb4,
  0x6bcb, 0x6ba7, 0x6bd2, 0x6bd8, 0x6be1, 0x6bd9, 0x6bd5, 0x6bfc,
  0x6be3, 0x6bd6, 0x7404, 0x7406, 0x6bf7, 0x741c, 0x740c, 0x7402,
  0x6bf3, 0x7416, 0x7417, 0x6b79, 0x7410, 0x7415, 0x7412, 0x743d,
  0x7433, 0x743f, 0x745c, 0x746e, 0x7494, 0x749f, 0x74a2, 0x74fc,
  0x74a1, 0x74b5, 0x74be, 0x74a3, 0x74d2, 0x74c6, 0x74d0, 0x74d4,
  0x7504, 0x74f0, 0x7511, 0x7514, 0x7568, 0x7558, 0x7585, 0x756b,
  0x756f, 0x7541, 0x755b, 0x7561, 0x7582, 0x75f6, 0x7589, 0x7598,
  0x75a5, 0x75a1, 0x75da, 0x75b4, 0x75b3, 0x75df, 0x75c4, 0x75d9,
  0x75c3, 0x75ed, 0x75e1, 0x75ea, 0x75f8, 0x75f1,
  /* 0x60 */
  0x75f4, 0x75f2, 0x7600, 0x761d, 0x7616, 0x7625, 0x7620, 0x7621,
  0x763d, 0x763f, 0x7636, 0x7631, 0x7632, 0x764d, 0x764b, 0x7646,
  0x7655, 0x7679, 0x7673, 0x768f, 0x768c, 0x768a, 0x769f, 0x769b,
  0x76af, 0x76aa, 0x76b4, 0x76bf, 0x76ce, 0x76cb, 0x76c9, 0x76c3,
  0x76df, 0x76ef, 0x76ed, 0x76ec, 0x76f4, 0x76fa, 0x5402, 0x771a,
  0x7707, 0x7711, 0x771b, 0x7710, 0x7739, 0x7722, 0x7724, 0x7728,
  0x7733, 0x7743, 0x7742, 0x9ad5, 0x775a, 0x7767, 0x7765, 0x777d,
  0x7775, 0x7778, 0x7776, 0x7777, 0x77c5, 0x77be, 0x77c3, 0x77b6,
  0x77cd, 0x77e8, 0x77e3, 0x77d3, 0x70af, 0x7008, 0x7062, 0x7028,
  0x77f5, 0x703f, 0x7037, 0x7058, 0x7032, 0x7052, 0x7054, 0x704c,
  0x7051, 0x7064, 0x707d, 0x706e, 0x7067, 0x707b, 0x7073, 0x7086,
  0x7093, 0x70aa, 0x70c7, 0x70c2, 0x70d9, 0x77fc,
  /* 0x61 */
  0x70ed, 0x70ee, 0x70ea, 0x70e4, 0x70e3, 0x70ff, 0x70fd, 0x70fc,
  0x70f5, 0x70fa, 0x7109, 0x710e, 0x7108, 0x7101, 0x7103, 0x7100,
  0x7118, 0x711e, 0x7113, 0x712b, 0x7121, 0x7131, 0x7149, 0x7140,
  0x7147, 0x7144, 0x7156, 0x714b, 0x7157, 0x7164, 0x7169, 0x716a,
  0x7166, 0x7160, 0x7175, 0x717b, 0x718b, 0x718a, 0x7179, 0x7187,
  0x7184, 0x718f, 0x7199, 0x7197, 0x7190, 0x71a8, 0x71ae, 0x71cf,
  0x71be, 0x71ce, 0x71b8, 0x71b0, 0x71b5, 0x71b1, 0x71bc, 0x71c0,
  0x71c7, 0x71df, 0x71d4, 0x71ee, 0x71d3, 0x71f3, 0x71f2, 0x71f1,
  0x720c, 0x71fd, 0x71f7, 0x71ff, 0x71fe, 0x7206, 0x7200, 0x7204,
  0x7212, 0x722a, 0x722d, 0x722c, 0x722f, 0x7229, 0x7239, 0x723d,
  0x7236, 0x724a, 0x7245, 0x724b, 0x7251, 0x7255, 0x726c, 0x726f,
  0x7265, 0x7264, 0x7267, 0x726a, 0x7261, 0x727d,
  /* 0x62 */
  0x727f, 0x727b, 0x7275, 0x7271, 0x728d, 0x728e, 0x7285, 0x7286,
  0x7283, 0x729b, 0x729e, 0x7294, 0x7297, 0x72bd, 0x72b9, 0x72b5,
  0x72b4, 0x72b7, 0x72cf, 0x72c0, 0x72db, 0x72df, 0x72d3, 0x72ec,
  0x72e8, 0x72ea, 0x72e7, 0x8222, 0x72f6, 0x7305, 0x730a, 0x7309,
  0x7324, 0x7329, 0x7313, 0x7328, 0x732b, 0x7316, 0x733a, 0x7335,
  0x734a, 0x7357, 0x7365, 0x7366, 0x7356, 0x7368, 0x7372, 0x7373,
  0x7374, 0x7383, 0x7386, 0x739c, 0x73ad, 0x7393, 0x73bd, 0x73bb,
  0x73b4, 0x73b2, 0x73b1, 0x73b0, 0x73b6, 0x73ca, 0x73c0, 0x73da,
  0x73d7, 0x73d1, 0x73ee, 0x73e3, 0x73f1, 0x7c01, 0x7c1f, 0x7d2b,
  0x7c2d, 0x7d27, 0x7c48, 0x7c83, 0x7c79, 0x7c8b, 0x7c71, 0x7c97,
  0x7c81, 0x7cae, 0x7cb8, 0x7ca7, 0x7ca2, 0x7cdc, 0x7ccb, 0x7cc6,
  0x7cd9, 0x7cb3, 0x7cb1, 0x7cc8, 0x7cc7, 0x7ce1,
  /* 0x63 */
  0x7cea, 0x7cd7, 0x7cf0, 0x7cf9, 0x7d0a, 0x7d1f, 0x7d1c, 0x7d14,
  0x7d21, 0x7d26, 0x7d4d, 0x7d6d, 0x7d5a, 0x7d52, 0x7d57, 0x7d58,
  0x7d5e, 0x7d77, 0x7d72, 0x7d87, 0x7d90, 0x7daa, 0x9b46, 0x7da7,
  0x7da3, 0x7dbe, 0x7db4, 0x7db7, 0x7dc4, 0x7dd8, 0x7dea, 0x7de1,
  0x7dec, 0x7dee, 0x7e05, 0x7e00, 0x7e15, 0x7e14, 0x7e2d, 0x7e12,
  0x7d8d, 0x7e3c, 0x7e36, 0x7e33, 0x7e3a, 0x7e4e, 0x7e5a, 0x7e44,
  0x7e6c, 0x7e6f, 0x7e64, 0x9b90, 0x7e7d, 0x7e74, 0x7e70, 0x7e85,
  0x7e9a, 0x7e98, 0x7e95, 0x7e9b, 0x7ea4, 0x7ec5, 0x7ebd, 0x7ebb,
  0x7ec8, 0x7ec9, 0x7eb2, 0x948e, 0x7eca, 0x7ec7, 0x7ec0, 0x7ec2,
  0x7ed8, 0x7ede, 0x7ed4, 0x7ed7, 0x7ed0, 0x7eec, 0x7eef, 0x7eeb,
  0x7ee0, 0x7efd, 0x7f0f, 0x7f02, 0x7f07, 0x7f0b, 0x7f3e, 0x7f15,
  0x7f14, 0x7f13, 0x7f38, 0x7f25, 0x7f3b, 0x7f5d,
  /* 0x64 */
  0x7f77, 0x7f09, 0x7f40, 0x7f06, 0x7f41, 0x7f48, 0x7f78, 0x7f68,
  0x7f79, 0x7f6a, 0x7f7d, 0x7f7c, 0x7f61, 0x7f63, 0x7f90, 0x7f95,
  0x7f92, 0x7f80, 0x7f91, 0x7f97, 0x7f86, 0x7f9f, 0x7f82, 0x7f50,
  0x7f94, 0x7fc6, 0x7fcc, 0x7fc1, 0x7fc2, 0x7fb9, 0x7fcb, 0x7fd0,
  0x7fe4, 0x781c, 0x7819, 0x7feb, 0x7fe8, 0x786d, 0x780d, 0x780a,
  0x781e, 0x7ffe, 0x7ffa, 0x781a, 0x7800, 0x7ffb, 0x782e, 0x782a,
  0x7827, 0x7812, 0x783a, 0x7826, 0x7830, 0x7841, 0x784e, 0x7859,
  0x7842, 0x784d, 0x785d, 0x7855, 0x7852, 0x7869, 0x785b, 0x7868,
  0x7861, 0x7878, 0x788e, 0x789d, 0x78a9, 0x78a0, 0x78af, 0x78a6,
  0x78ac, 0x78a5, 0x78be, 0x78bf, 0x78bc, 0x78a3, 0x78b4, 0x78b0,
  0x78cd, 0x78c8, 0x78cf, 0x78d5, 0x78df, 0x78d1, 0x78ef, 0x9f36,
  0x78e2, 0x78ff, 0x78f9, 0x78fb, 0x78f7, 0x790b,
  /* 0x65 */
  0x790f, 0x7911, 0x7918, 0x7907, 0x7948, 0x7946, 0x7923, 0x793f,
  0x7932, 0x7938, 0x794b, 0x797e, 0x795b, 0x7943, 0x797f, 0x7965,
  0x7963, 0x7942, 0x796e, 0x799e, 0x7984, 0x7956, 0x7982, 0x7970,
  0x7996, 0x79b7, 0x79a3, 0x79ae, 0x79b8, 0x79ca, 0x79b0, 0x79a6,
  0x7a30, 0x79af, 0x79a2, 0x79d1, 0x79b5, 0x7992, 0x79bd, 0x79d5,
  0x79d0, 0x79e9, 0x79d3, 0x79f6, 0x79ff, 0x79ec, 0x7a08, 0x7a07,
  0x7a2e, 0x7a2c, 0x7a1f, 0x7a3c, 0x7a12, 0x7a04, 0x7a06, 0x7a2f,
  0x7a4b, 0x7a6b, 0x7a36, 0x7a38, 0x7a34, 0x7a4e, 0x7a3a, 0x7a3f,
  0x7a37, 0x7a6a, 0x7a50, 0x7a5b, 0x7a53, 0x7a54, 0x7a57, 0x7a74,
  0x7a67, 0x7a64, 0x7a71, 0x7a76, 0x7a8e, 0x79d8, 0x7a70, 0x8ba3,
  0x7a72, 0x7a85, 0x7a84, 0x7a81, 0x7a9f, 0x7a9d, 0x7a9e, 0x7a99,
  0x7a9b, 0x7a83, 0x7a96, 0x7a91, 0x7b35, 0x7b37,
  /* 0x66 */
  0x7b48, 0x7b41, 0x7b40, 0x7b43, 0x7b5d, 0x7b5c, 0x7b58, 0x7b59,
  0x7b55, 0x7b52, 0x7b6d, 0x7b65, 0x7b64, 0x7b6a, 0x7b75, 0x7b8f,
  0x7b8b, 0x7b8e, 0x7b85, 0x7b8a, 0x7b81, 0x7b99, 0x7b93, 0x7b90,
  0x7b97, 0x7bae, 0x7ba2, 0x7bbf, 0x7bb4, 0x7ba3, 0x7bbb, 0x7bb5,
  0x8f7c, 0x7bc8, 0x7bcb, 0x7bc7, 0x7bd8, 0x7bd9, 0x7bec, 0x7beb,
  0x7be4, 0x7bfe, 0x7bf4, 0x9cd1, 0x840b, 0x8409, 0x8406, 0x841f,
  0x8415, 0x8414, 0x8411, 0x842c, 0x8425, 0x8432, 0x8436, 0x8447,
  0x844b, 0x845f, 0x8455, 0x8457, 0x8452, 0x846f, 0x8465, 0x847e,
  0x847f, 0x847d, 0x847b, 0x8474, 0x8470, 0x8472, 0x8489, 0x848b,
  0x8488, 0x8496, 0x849e, 0x8497, 0x84a0, 0x559d, 0x84a1, 0x84d6,
  0x84e8, 0x84d4, 0x84d0, 0x84c9, 0x84d7, 0x84db, 0x8504, 0x84e2,
  0x84fc, 0x8516, 0x8524, 0x852e, 0x8522, 0x8546,
  /* 0x67 */
  0x9286, 0x854b, 0x8533, 0x855e, 0x855c, 0x84f1, 0x857c, 0x8563,
  0x8568, 0x856b, 0x8579, 0x858e, 0x8585, 0x8587, 0x858d, 0x858f,
  0x85ad, 0x8598, 0x85a9, 0x85ae, 0x8552, 0x859e, 0x85a4, 0x85bd,
  0x85b8, 0x85b3, 0x85b5, 0x85b0, 0x85cd, 0x85cf, 0x85b7, 0x85c4,
  0x85c0, 0x85dc, 0x85d4, 0x85d5, 0x85c5, 0x85d7, 0x85d2, 0x85ed,
  0x85ea, 0x85f7, 0x85f6, 0x85f3, 0x860c, 0x860f, 0x8608, 0x860a,
  0x8607, 0x8600, 0x861d, 0x861b, 0x8624, 0x8626, 0x8635, 0x863e,
  0x864d, 0x8654, 0x8655, 0x8650, 0x8657, 0x8652, 0x8669, 0x866f,
  0x8665, 0x8667, 0x8666, 0x8623, 0x867c, 0x867a, 0x8675, 0x8673,
  0x8680, 0x869f, 0x86a6, 0x8692, 0x86b6, 0x86a1, 0x86ec, 0x86ee,
  0x86d2, 0x86df, 0x86f9, 0x86fe, 0x86f7, 0x879e, 0x870e, 0x86f6,
  0x86f4, 0x86d3, 0x870b, 0x86d1, 0x8704, 0x86d4,
  /* 0x68 */
  0x8738, 0x8739, 0x871b, 0x873f, 0x873c, 0x874d, 0x8734, 0x875d,
  0x8748, 0x8722, 0x8726, 0x871a, 0x8715, 0x8788, 0x8797, 0x87a7,
  0x8792, 0x87af, 0x879b, 0x872e, 0x8783, 0x878a, 0x8787, 0x8771,
  0x87b8, 0x877e, 0x8778, 0x87ad, 0x8784, 0x87a5, 0x87f9, 0x801e,
  0x87e6, 0x87c3, 0x87f0, 0x800e, 0x87d5, 0x8006, 0x87cc, 0x87fa,
  0x800a, 0x87ed, 0x87ff, 0x8000, 0x802f, 0x802d, 0x87b0, 0x8035,
  0x810b, 0x87f6, 0x8060, 0x8027, 0x8031, 0x8157, 0x8089, 0x807a,
  0x8066, 0x80a0, 0x8063, 0x808f, 0x8064, 0x804b, 0x8021, 0x8062,
  0x8074, 0x8038, 0x80c7, 0x806f, 0x80b4, 0x80b2, 0x8092, 0x80d4,
  0x80c0, 0x80b6, 0x80d7, 0x80dd, 0x80cc, 0x80cb, 0x80db, 0x80ac,
  0x812c, 0x80f2, 0x80f9, 0x811a, 0x8115, 0x8121, 0x8112, 0x8118,
  0x8119, 0x80f1, 0x814d, 0x816e, 0x8155, 0x8145,
  /* 0x69 */
  0x814c, 0x820f, 0x8146, 0x8158, 0x818d, 0x81a9, 0x8185, 0x819c,
  0x8187, 0x81a5, 0x8160, 0x8199, 0x8196, 0x81e7, 0x818a, 0x8191,
  0x817a, 0x8173, 0x819d, 0x81c4, 0x81b7, 0x81c2, 0x81b4, 0x81dd,
  0x81d8, 0x81d0, 0x81e8, 0x81d1, 0x81f4, 0x8207, 0x821e, 0x8206,
  0x81f3, 0x81f7, 0x820b, 0x822f, 0x8217, 0x823d, 0x8232, 0x8240,
  0x4a58, 0x8259, 0x8252, 0x826a, 0x827c, 0x829e, 0x82ae, 0x82a4,
  0x82a7, 0x8286, 0x8281, 0x82bb, 0x82a2, 0x82c9, 0x82cb, 0x82bd,
  0x82c4, 0x8c2e, 0x82a6, 0x82d9, 0x82d3, 0x82e4, 0x82e1, 0x82d2,
  0x82d6, 0x82e2, 0x831f, 0x830b, 0x8305, 0x830d, 0x830e, 0x82f6,
  0x831c, 0x8304, 0x8300, 0x82f4, 0x8307, 0x8339, 0x8332, 0x833a,
  0x8336, 0x8328, 0x8324, 0x8317, 0x836d, 0x8352, 0x8375, 0x8341,
  0x8343, 0x8379, 0x835a, 0x8365, 0x8363, 0x8354,
  /* 0x6a */
  0x835e, 0x836e, 0x8367, 0x8c08, 0x83af, 0x8392, 0x838f, 0x83a2,
  0x83c6, 0x83b0, 0x83cd, 0x83dd, 0x92db, 0x83a6, 0x83c9, 0x83be,
  0x83ca, 0x83cb, 0x83b6, 0x83e2, 0x83ff, 0x83ed, 0x8c02, 0x8c00,
  0x83f3, 0x83fb, 0x83fa, 0x8c03, 0x83df, 0x8c1c, 0x8c1b, 0x8c18,
  0x8c2f, 0x8c2c, 0x8c3c, 0x8c3b, 0x8c34, 0x8c2a, 0x8c36, 0x8c49,
  0x8c4f, 0x8c5f, 0x8c54, 0x8c53, 0x8c6f, 0x8c66, 0x8c8c, 0x8c73,
  0x8c93, 0x8c78, 0x8c70, 0x8cb8, 0x8c7f, 0x8c8f, 0x8c9a, 0x8c9f,
  0x8ca3, 0x8c94, 0x8caf, 0x8c80, 0x8ca9, 0x8cbd, 0x8cb2, 0x8cbc,
  0x8cce, 0x8cc9, 0x8cd9, 0x8cd5, 0x8cd4, 0x8cd0, 0x8cf4, 0x8d0f,
  0x8cf1, 0x8cf9, 0x8ce5, 0x8cff, 0x8d09, 0x8d01, 0x8d07, 0x8d1e,
  0x8d4e, 0x8d13, 0x8d28, 0x8d27, 0x8d26, 0x8d4c, 0x8d49, 0x8d36,
  0x8d3b, 0x8d35, 0x8d41, 0x8d10, 0x8d6d, 0x8d53,
  /* 0x6b */
  0x8d6b, 0x8d69, 0x8d60, 0x8d67, 0x8d62, 0x8d79, 0x8d7a, 0x8d73,
  0x8d8e, 0x8d85, 0x8d87, 0x8d9e, 0x8d95, 0x8dac, 0x8da4, 0x8dab,
  0x8da1, 0x8da2, 0x8dbf, 0x8db7, 0x8db0, 0x8db2, 0x8dcd, 0x8dd7,
  0x8dd1, 0x8dd0, 0x8dea, 0x8df9, 0x8df5, 0x8e0e, 0x8e1b, 0x8e1d,
  0x8e01, 0x8e16, 0x8e10, 0x8e28, 0x8e3b, 0x8e4c, 0x8e56, 0x8e5f,
  0x8e4b, 0x8e45, 0x8e71, 0x8e60, 0x8e61, 0x8e6f, 0x8e88, 0x8e8f,
  0x8e89, 0x8ea5, 0x8eac, 0x8e9c, 0x8ea8, 0x8eab, 0x8e97, 0x8eae,
  0x8ec9, 0x8ec0, 0x8ecf, 0x8ed7, 0x8ee6, 0x8efe, 0x8eea, 0x8ee9,
  0x8efc, 0x8f19, 0x8eed, 0x8eef, 0x8efa, 0x8ed3, 0x8ed6, 0x8f01,
  0x8f0a, 0x8f17, 0x8eec, 0x8f1b, 0x8f1d, 0x8f1a, 0x8f2d, 0x8f3e,
  0x93a6, 0x8f2b, 0x8f26, 0x8f33, 0x8f25, 0x8f4c, 0x8f41, 0x8f42,
  0x8f43, 0x8f44, 0x8f5b, 0x8f56, 0x8f57, 0x8f66,
  /* 0x6c */
  0x8f52, 0x8f61, 0x8f62, 0x8f79, 0x8f70, 0x8f8d, 0x8f81, 0x8f83,
  0x8f9f, 0x8f9e, 0x8f9b, 0x8f94, 0x8f97, 0x8837, 0x884c, 0x8832,
  0x8845, 0x8841, 0x8843, 0x885d, 0x8858, 0x886f, 0x8861, 0x8875,
  0x8877, 0x888f, 0x8884, 0x8888, 0x8887, 0x8880, 0x8883, 0x8899,
  0x8871, 0x8895, 0x6610, 0x88a0, 0x88a7, 0x88b0, 0x88bf, 0x88be,
  0x88a3, 0x88bb, 0x88c5, 0x88cc, 0x88e9, 0x88ee, 0x88d7, 0x88f0,
  0x88f7, 0x88f6, 0x8909, 0x8908, 0x8907, 0x890a, 0x8902, 0x8900,
  0x891d, 0x9b43, 0x891e, 0x88c0, 0x8919, 0x891b, 0x896a, 0x8960,
  0x897c, 0x897e, 0x898c, 0x8994, 0x89cf, 0x89b3, 0x89b7, 0x89c2,
  0x89d7, 0x89db, 0x89c1, 0x89d6, 0x89c6, 0x89e7, 0x89e6, 0x89d2,
  0x89ee, 0x89f1, 0x8a05, 0x8a04, 0x89f2, 0x8a10, 0x8a13, 0x8a1d,
  0x8a12, 0x8a4f, 0x8a38, 0x8a3d, 0x8a39, 0x8a47,
  /* 0x6d */
  0x8a4a, 0x8a44, 0x8a41, 0x8a5d, 0x8a45, 0x8a54, 0x8a69, 0x8a6d,
  0x8a27, 0x8a6e, 0x8a58, 0x8a7b, 0x8a7f, 0x8a71, 0x8a8c, 0x8a8a,
  0x8a88, 0x8a89, 0x8a86, 0x8a87, 0x8a9e, 0x8a9c, 0x8a99, 0x8a94,
  0x8aa7, 0x8aac, 0x8aa1, 0x8abd, 0x8acb, 0x8abc, 0x8ab3, 0x8ac8,
  0x8ac5, 0x8ac6, 0x8ad6, 0x8aee, 0x8af1, 0x8af6, 0x8ae6, 0x8af3,
  0x8b07, 0x8b08, 0x8b18, 0x8b1f, 0x8b14, 0x8b1e, 0x8b11, 0x8b12,
  0x8b16, 0x8b01, 0x8b2b, 0x8b3e, 0x8b36, 0x8b34, 0x8b48, 0x8b4f,
  0x8b33, 0x8b41, 0x8b44, 0x8b4b, 0x8b43, 0x8b5a, 0x8b51, 0x8b6f,
  0x8b6e, 0x8b69, 0x8b91, 0x8b92, 0x8bae, 0x8ba0, 0x8ba2, 0x8bba,
  0x8bd7, 0x8be8, 0x8bef, 0x8be7, 0x8be2, 0x948a, 0x8bf9, 0x9408,
  0x8bf4, 0x8bf7, 0x941c, 0x9418, 0x942c, 0x9400, 0x9413, 0x941b,
  0x9406, 0x942a, 0x943b, 0x9438, 0x9434, 0x8bf5,
  /* 0x6e */
  0x9442, 0x945d, 0x945c, 0x945f, 0x9403, 0x9444, 0x9433, 0x945b,
  0x9455, 0x9453, 0x9465, 0x9462, 0x947b, 0x92a5, 0x947f, 0x948f,
  0x9470, 0x948c, 0x948d, 0x9487, 0x9484, 0x9482, 0x94a5, 0x94a2,
  0x94bc, 0x94b8, 0x94ef, 0x94e9, 0x6645, 0x94d6, 0x950f, 0x951f,
  0x9514, 0x953f, 0x953d, 0x9547, 0x955b, 0x9555, 0x956e, 0x9568,
  0x9564, 0x957e, 0x957f, 0x9586, 0x9584, 0x958f, 0x95af, 0x95a6,
  0x95a2, 0x95a7, 0x95b8, 0x95b9, 0x95b7, 0x95cd, 0x95cc, 0x95c4,
  0x95c6, 0x95dd, 0x95db, 0x95d2, 0x95ec, 0x95d6, 0x95f1, 0x95f8,
  0x95fb, 0x9613, 0x95f2, 0x9619, 0x9621, 0x9618, 0x961c, 0x9653,
  0x965a, 0x9648, 0x9644, 0x9669, 0x9645, 0x9698, 0x9632, 0x9646,
  0x965d, 0x9691, 0x969b, 0x969e, 0x9696, 0x9657, 0x96c2, 0x96b4,
  0x96ba, 0x96e4, 0x9702, 0x96f7, 0x9749, 0x9723,
  /* 0x6f */
  0x9714, 0x972f, 0x9717, 0x972e, 0x9737, 0x9738, 0x9736, 0x9751,
  0x976d, 0x9771, 0x9763, 0x975b, 0x97bd, 0x97a1, 0x97a0, 0x9799,
  0x97b4, 0x97db, 0x97da, 0x97e5, 0x97e8, 0x97d5, 0x97ce, 0x97d0,
  0x97dd, 0x97c5, 0x97e9, 0x9017, 0x9019, 0x901e, 0x900e, 0x900a,
  0x901d, 0x903b, 0x9026, 0x9038, 0x902c, 0x9037, 0x904c, 0x905f,
  0x9049, 0x9056, 0x906d, 0x906f, 0x9053, 0x9067, 0x9624, 0x907d,
  0x9078, 0x907a, 0x9070, 0x9057, 0x9071, 0x9073, 0x908c, 0x9072,
  0x918f, 0x918a, 0x9187, 0x9199, 0x919b, 0x9195, 0x9194, 0x91ad,
  0x91a5, 0x91aa, 0x91a0, 0x91b1, 0x91b6, 0x91b4, 0x91b3, 0x91c7,
  0x6bfb, 0x91ce, 0x91c0, 0x91c1, 0x91d8, 0x91d9, 0x91db, 0x91d1,
  0x91ec, 0x91e8, 0x91ef, 0x922c, 0x9225, 0x9223, 0x9222, 0x924f,
  0x9241, 0x9242, 0x9246, 0x927a, 0x9251, 0x9253,
  /* 0x70 */
  0x9250, 0x9252, 0x926b, 0x927f, 0x9261, 0x9280, 0x9295, 0x9298,
  0x929a, 0x92a7, 0x92aa, 0x92bc, 0x92bf, 0x92bd, 0x92b9, 0x92bb,
  0x92b5, 0x92b4, 0x92c3, 0x92c6, 0x92c4, 0x92c0, 0x8d40, 0x92d1,
  0x9300, 0x92d8, 0x92f4, 0x9309, 0x930b, 0x9305, 0x931e, 0x9303,
  0x931c, 0x9302, 0x931b, 0x9314, 0x9329, 0x9327, 0x933d, 0x9334,
  0x9330, 0x9333, 0x9349, 0x934b, 0x9345, 0x934f, 0x9344, 0x9351,
  0x936d, 0x9369, 0x936b, 0x9365, 0x56df, 0x9366, 0x937c, 0x9374,
  0x9388, 0x9371, 0x938c, 0x9377, 0x938b, 0x9386, 0x9382, 0x939d,
  0x9391, 0x93a5, 0x93ab, 0x93ae, 0x93be, 0x93b9, 0x93ce, 0x93cb,
  0x93c5, 0x93c6, 0x93d1, 0x93e0, 0x9b42, 0x93ff, 0x7ed2, 0x93fb,
  0x93f8, 0x9c02, 0x9c01, 0x9c35, 0x9c29, 0x9c2c, 0x9c3a, 0x9c30,
  0x9c4b, 0x9c42, 0x9c46, 0x9c66, 0x9c62, 0x9c7d,
  /* 0x71 */
  0x9c7c, 0x9c79, 0x9c7e, 0x9ca7, 0x9ca2, 0x9cbc, 0x9cbb, 0x9cc9,
  0x9cce, 0x9ccb, 0x9ce4, 0x9ce6, 0x9d0e, 0x9d04, 0x9d1f, 0x9d19,
  0x9d15, 0x9d2c, 0x9d10, 0x9d13, 0x9d29, 0x9d2d, 0x9d21, 0x9d23,
  0x9d30, 0x9d33, 0x9d4f, 0x9d44, 0x9d48, 0x9d5d, 0x9d46, 0x9d5c,
  0x9d5f, 0x9d41, 0x9d58, 0x9d9a, 0x9d95, 0x9da8, 0x9da0, 0x9da3,
  0x9db1, 0x9dd2, 0x9dd6, 0x9dd0, 0x9dd5, 0x9ddc, 0x9de0, 0x9de3,
  0x9dfc, 0x9dff, 0x9df6, 0x9df5, 0x9e0c, 0x9e02, 0x9e08, 0x9def,
  0x9e14, 0x9e26, 0x9e3a, 0x9e48, 0x9e4f, 0x9e4d, 0x9e4e, 0x9e33,
  0x9e58, 0x9e40, 0x9e56, 0x9e5a, 0x9e52, 0x9e6f, 0x9e68, 0x9e69,
  0x9e64, 0x9e66, 0x9e67, 0x9ea0, 0x9ebd, 0x9eb1, 0x9ecd, 0x9ec2,
  0x9edc, 0x9ede, 0x9ed9, 0x9ed3, 0x9ed2, 0x9eef, 0x9eee, 0x9eeb,
  0x9ee2, 0x9ee6, 0x9ee3, 0x9ef9, 0x9efc, 0x9efa,
  /* 0x72 */
  0x9ef6, 0x9f0b, 0x9f15, 0x9f17, 0x9f12, 0x9f2f, 0x9f2e, 0x9f28,
  0x9f2a, 0x9f25, 0x9f24, 0x9f27, 0x9f23, 0x9f22, 0x9f3f, 0x9f49,
  0x9f4e, 0x9f42, 0x9f40, 0x9f43, 0x9f5c, 0x9f55, 0x9f79, 0x9f9e,
  0x9f8e, 0x9f9c, 0x9f9b, 0x9f9a, 0x9f92, 0x9fad, 0x9fa5, 0x9fb9,
  0x9fcd, 0x9fc7, 0x9fb4, 0x9fcb, 0x9fc2, 0x9fdc, 0x9fdf, 0x9fee,
  0x9fef, 0x9fe9, 0x9fd9, 0x9fec, 0x9837, 0x9fff, 0x9ffc, 0x9ffd,
  0x9818, 0x9819, 0x9804, 0x981e, 0x9801, 0x980b, 0x9805, 0x981f,
  0x9807, 0x9809, 0x9823, 0x9816, 0x9828, 0x9829, 0x982c, 0x983d,
  0x984a, 0x983f, 0x984b, 0x9833, 0x9857, 0x986d, 0x986a, 0x987b,
  0x9875, 0x98ea, 0x98e1, 0x98fd, 0x9904, 0x9905, 0x98e6, 0x990e,
  0x990b, 0x9927, 0x992b, 0x99a2, 0x992e, 0x9912, 0x9949, 0x9918,
  0x991f, 0x994c, 0x9932, 0x9933, 0x994b, 0x9945,
  /* 0x73 */
  0x9950, 0x9953, 0x9969, 0x995c, 0x995d, 0x9954, 0x997f, 0x9984,
  0x998a, 0x99a6, 0x9962, 0x9977, 0x9997, 0x99a9, 0x99a4, 0x99bf,
  0x99c9, 0x99cc, 0x99b6, 0x99b5, 0x99b7, 0x99cb, 0x99c2, 0x99cf,
  0x99d4, 0x99de, 0x99f5, 0x99eb, 0x99e0, 0x99e2, 0x99f0, 0x9a17,
  0x9a16, 0x9a13, 0x9a78, 0x9a74, 0x9a70, 0x9a8c, 0x9a85, 0x9a86,
  0x9a81, 0x9a9f, 0x9a98, 0x9a9c, 0x9a90, 0x9aa8, 0x9aa4, 0x9ab5,
  0x9aa7, 0x9aa0, 0x936c, 0x9ac1, 0x9ac3, 0x9ac2, 0x9add, 0x9ad9,
  0x9ad1, 0x9ad3, 0x9ad0, 0x9aed, 0x9ae8, 0x9ae5, 0x9ae2, 0x9af9,
  0x9afb, 0x9afa, 0x9af4, 0x9af6, 0x9af1, 0x9af0, 0x9b0a, 0x9b05,
  0x72ba, 0x9b18, 0x9b2c, 0x9b21, 0x9b33, 0x9b47, 0x9b5f, 0x9b59,
  0x9b6e, 0x9b52, 0x9b6d, 0x9b6c, 0x9b6b, 0x9b6a, 0x9b61, 0x9b67,
  0x9b7a, 0x9b7f, 0x9b7b, 0x9b98, 0x9b91, 0x9bad,
  /* 0x74 */
  0x5c22, 0x6dca, 0x9454, 0x7069, 0x55d1, 0x7594,
};

static const UShort jisx0208_2charset[6879] = {
  0x257c, 0x257f, 0x2575, 0x2522, 0x2641, 0x2566, 0x2553, 0x2520,
  0x2674, 0x2552, 0x256d, 0x222c, 0x222f, 0x222e, 0x2229, 0x2228,
  0x222b, 0x222a, 0x2225, 0x2224, 0x2227, 0x2226, 0x2221, 0x2220,
  0x2223, 0x2222, 0x223d, 0x223c, 0x223f, 0x223e, 0x2239, 0x2238,
  0x223b, 0x223a, 0x2235, 0x224c, 0x224f, 0x224e, 0x2249, 0x2248,
  0x224b, 0x224a, 0x2245, 0x2244, 0x2247, 0x2246, 0x2241, 0x2240,
  0x2243, 0x2242, 0x225d, 0x225c, 0x225f, 0x225e, 0x2259, 0x2258,
  0x225b, 0x225a, 0x2255, 0x232a, 0x232c, 0x232f, 0x232e, 0x2329,
  0x2328, 0x232b, 0x2325, 0x2324, 0x2327, 0x2326, 0x2321, 0x2320,
  0x2323, 0x2322, 0x233d, 0x233c, 0x233f, 0x233e, 0x2339, 0x2338,
  0x233b, 0x233a, 0x2335, 0x2334, 0x2337, 0x2336, 0x2331, 0x2330,
  0x2333, 0x2332, 0x234d, 0x234c, 0x235c, 0x235f, 0x235e, 0x2359,
  0x2358, 0x235b, 0x2355, 0x2354, 0x2357, 0x2356, 0x2351, 0x2350,
  0x2353, 0x2352, 0x236d, 0x236c, 0x236f, 0x236e, 0x2369, 0x2368,
  0x236b, 0x236a, 0x2365, 0x2364, 0x2367, 0x2366, 0x2361, 0x2360,
  0x2363, 0x2362, 0x237d, 0x237c, 0x235a, 0x2533, 0x2530, 0x254f,
  0x254b, 0x254a, 0x2545, 0x2544, 0x267a, 0x2675, 0x2548, 0x2549,
  0x267e, 0x2561, 0x2560, 0x2625, 0x2563, 0x267f, 0x2626, 0x2621,
  0x2627, 0x2620, 0x2640, 0x2643, 0x2642, 0x2652, 0x265d, 0x266d,
  0x2637, 0x2636, 0x2550, 0x2668, 0x266a, 0x256a, 0x2651, 0x2647,
  0x2646, 0x264c, 0x264d, 0x2664, 0x2667, 0x2565, 0x2665, 0x266b,
  0x266f, 0x256f, 0x266c, 0x2568, 0x256b, 0x266e, 0x2669, 0x2633,
  0x2632, 0x2631, 0x2630, 0x2650, 0x2653, 0x2c2c, 0x2c21, 0x2c2f,
  0x2c20, 0x2c2e, 0x2c23, 0x2c29, 0x2c22, 0x2c2b, 0x2c3c, 0x2c28,
  0x2c3d, 0x2c2a, 0x2c31, 0x2c3a, 0x2c3f, 0x2c24, 0x2c33, 0x2c34,
  0x2c39, 0x2c25, 0x2c35, 0x2c30, 0x2c3e, 0x2c27, 0x2c37, 0x2c32,
  0x2c38, 0x2c26, 0x2c36, 0x2c4d, 0x2c3b, 0x262e, 0x262f, 0x2628,
  0x2629, 0x262a, 0x262b, 0x262c, 0x2573, 0x2576, 0x2570, 0x2571,
  0x2673, 0x2577, 0x2574, 0x2567, 0x2564, 0x267b, 0x2678, 0x2679,
  0x252c, 0x252f, 0x252e, 0x253a, 0x2534, 0x2537, 0x2536, 0x255f,
  0x255e, 0x2559, 0x2558, 0x255b, 0x255a, 0x2555, 0x2554, 0x2557,
  0x2556, 0x2624, 0x2623, 0x2541, 0x2540, 0x254c, 0x202c, 0x202f,
  0x202e, 0x2029, 0x2028, 0x202b, 0x202a, 0x2025, 0x2024, 0x2027,
  0x2026, 0x2021, 0x2020, 0x2023, 0x2022, 0x203d, 0x203c, 0x203f,
  0x203e, 0x2039, 0x2038, 0x203b, 0x203a, 0x2035, 0x2034, 0x2037,
  0x2036, 0x2031, 0x2030, 0x2033, 0x2032, 0x204d, 0x204c, 0x204f,
  0x204e, 0x2049, 0x2048, 0x204b, 0x204a, 0x2045, 0x2044, 0x2047,
  0x2046, 0x2041, 0x2040, 0x2043, 0x2042, 0x205d, 0x205c, 0x205f,
  0x205e, 0x2059, 0x2058, 0x205b, 0x205a, 0x2055, 0x2054, 0x2057,
  0x2056, 0x2051, 0x2050, 0x2053, 0x2052, 0x206d, 0x206c, 0x206f,
  0x206e, 0x2069, 0x2068, 0x206b, 0x206a, 0x2065, 0x2064, 0x2067,
  0x2066, 0x2061, 0x2060, 0x2063, 0x2062, 0x207d, 0x207c, 0x207f,
  0x207e, 0x2526, 0x2521, 0x2538, 0x253b, 0x212c, 0x212f, 0x212e,
  0x2129, 0x2128, 0x212b, 0x212a, 0x2125, 0x2124, 0x2127, 0x2126,
  0x2121, 0x2120, 0x2123, 0x2122, 0x213d, 0x213c, 0x213f, 0x213e,
  0x2139, 0x2138, 0x213b, 0x213a, 0x2135, 0x2134, 0x2137, 0x2136,
  0x2131, 0x2130, 0x2133, 0x2132, 0x214d, 0x214c, 0x214f, 0x214e,
  0x2149, 0x2148, 0x214b, 0x214a, 0x2145, 0x2144, 0x2147, 0x2146,
  0x2141, 0x2140, 0x2143, 0x2142, 0x215d, 0x215c, 0x215f, 0x215e,
  0x2159, 0x2158, 0x215b, 0x215a, 0x2155, 0x2154, 0x2157, 0x2156,
  0x2151, 0x2150, 0x2153, 0x2152, 0x216d, 0x216c, 0x216f, 0x216e,
  0x2169, 0x2168, 0x216b, 0x216a, 0x2165, 0x2164, 0x2167, 0x2166,
  0x2161, 0x2160, 0x2163, 0x2162, 0x217d, 0x217c, 0x217f, 0x217e,
  0x2179, 0x2178, 0x217b, 0x252b, 0x2531, 0x253e, 0x2539, 0x3461,
  0x4777, 0x383a, 0x4f71, 0x3a6b, 0x3f3d, 0x3a68, 0x3631, 0x4d59,
  0x4932, 0x542f, 0x3522, 0x3763, 0x542e, 0x4429, 0x564f, 0x315b,
  0x4e37, 0x3a6a, 0x4a33, 0x4e4f, 0x5429, 0x476b, 0x5428, 0x3277,
  0x542b, 0x3050, 0x473d, 0x386a, 0x542a, 0x5425, 0x5424, 0x4338,
  0x315a, 0x433a, 0x426e, 0x3c4e, 0x4f3e, 0x6d44, 0x5427, 0x3a65,
  0x5426, 0x3638, 0x3268, 0x3c7d, 0x4864, 0x522b, 0x497d, 0x4270,
  0x3028, 0x3138, 0x5421, 0x5420, 0x4a36, 0x4930, 0x4565, 0x5422,
  0x3f7b, 0x427e, 0x543f, 0x3533, 0x3c52, 0x3c53, 0x346b, 0x4b46,
  0x4b47, 0x3e3e, 0x342c, 0x543e, 0x5439, 0x5438, 0x4f39, 0x543b,
  0x3c7f, 0x346a, 0x4f7f, 0x3171, 0x3170, 0x3173, 0x406f, 0x4a31,
  0x543a, 0x5435, 0x5434, 0x3b40, 0x3937, 0x3b43, 0x5433, 0x5431,
  0x5430, 0x3155, 0x3e2e, 0x367d, 0x5436, 0x5437, 0x4e24, 0x3f4b,
  0x3f48, 0x4633, 0x5432, 0x4d58, 0x446a, 0x2535, 0x544d, 0x544f,
  0x4668, 0x4a6c, 0x3447, 0x544c, 0x3633, 0x3249, 0x476a, 0x3362,
  0x544e, 0x4329, 0x3066, 0x5449, 0x3446, 0x3c6d, 0x3061, 0x4d77,
  0x4c3f, 0x3154, 0x367c, 0x546a, 0x414c, 0x4361, 0x544b, 0x4c31,
  0x4a6f, 0x3b20, 0x3f4a, 0x3f7a, 0x364d, 0x405c, 0x472f, 0x5447,
  0x3441, 0x406e, 0x3936, 0x3e39, 0x4929, 0x4643, 0x3632, 0x5444,
  0x4933, 0x5448, 0x544a, 0x3e63, 0x5445, 0x5129, 0x545d, 0x545e,
  0x545c, 0x364f, 0x4e36, 0x5446, 0x5442, 0x3c7e, 0x3f45, 0x302b,
  0x5459, 0x5441, 0x4a6e, 0x3f75, 0x5440, 0x545f, 0x5458, 0x5443,
  0x322c, 0x3440, 0x322f, 0x364c, 0x5128, 0x4f74, 0x4d63, 0x3c79,
  0x3b22, 0x4a3a, 0x4e55, 0x3335, 0x4628, 0x3669, 0x395e, 0x5454,
  0x5453, 0x5451, 0x545a, 0x4622, 0x5457, 0x5450, 0x5456, 0x4e50,
  0x5455, 0x3b23, 0x4f7e, 0x5452, 0x546d, 0x3929, 0x5460, 0x435d,
  0x4d3b, 0x5465, 0x4e7d, 0x363b, 0x5461, 0x546b, 0x5462, 0x455f,
  0x3c49, 0x4351, 0x644a, 0x5463, 0x4150, 0x546e, 0x3c7b, 0x3c78,
  0x546c, 0x3857, 0x5464, 0x4e62, 0x4740, 0x5468, 0x337c, 0x546f,
  0x5467, 0x5469, 0x4a5c, 0x5466, 0x4b4c, 0x326b, 0x337d, 0x547d,
  0x547c, 0x5478, 0x3443, 0x4e5d, 0x5479, 0x547e, 0x547a, 0x547b,
  0x4069, 0x337f, 0x5475, 0x3848, 0x462b, 0x4068, 0x327b, 0x5474,
  0x313b, 0x5477, 0x5471, 0x4f38, 0x336b, 0x3f3c, 0x4c7a, 0x5476,
  0x3e48, 0x494e, 0x5473, 0x552e, 0x5470, 0x3e49, 0x3970, 0x3334,
  0x5529, 0x3242, 0x552c, 0x552f, 0x4222, 0x4571, 0x322e, 0x4f40,
  0x5528, 0x4a30, 0x552b, 0x5524, 0x552a, 0x4543, 0x5525, 0x5527,
  0x5521, 0x5526, 0x4e45, 0x313a, 0x5523, 0x5522, 0x3622, 0x5520,
  0x3879, 0x553f, 0x553c, 0x553d, 0x545b, 0x553e, 0x3973, 0x5539,
  0x4928, 0x4854, 0x553b, 0x5538, 0x5535, 0x553a, 0x5534, 0x5537,
  0x3479, 0x3c38, 0x3336, 0x3931, 0x4776, 0x3229, 0x4465, 0x3c7a,
  0x3d63, 0x5531, 0x4845, 0x414b, 0x3f74, 0x5536, 0x5530, 0x4153,
  0x3778, 0x5533, 0x4273, 0x4539, 0x554d, 0x554c, 0x4c21, 0x3c75,
  0x4b36, 0x554f, 0x322b, 0x4e31, 0x463b, 0x327c, 0x4138, 0x337e,
  0x554e, 0x5549, 0x426f, 0x3552, 0x554a, 0x3e70, 0x554b, 0x3e4b,
  0x5545, 0x6263, 0x5544, 0x4f4c, 0x5547, 0x5546, 0x5541, 0x3a64,
  0x3841, 0x302a, 0x5542, 0x5540, 0x4830, 0x5543, 0x4d57, 0x555d,
  0x555c, 0x555f, 0x4152, 0x555b, 0x5559, 0x5558, 0x555e, 0x3e6e,
  0x555a, 0x4867, 0x4a69, 0x5555, 0x4425, 0x5554, 0x3957, 0x5557,
  0x4771, 0x4a32, 0x416d, 0x5648, 0x5556, 0x7028, 0x3248, 0x5551,
  0x4f53, 0x3965, 0x4671, 0x5553, 0x4269, 0x5552, 0x556d, 0x3723,
  0x556c, 0x322a, 0x4241, 0x3577, 0x395d, 0x4c2c, 0x556f, 0x416c,
  0x3b42, 0x556e, 0x4e21, 0x4457, 0x302f, 0x3024, 0x5569, 0x556b,
  0x3337, 0x5568, 0x4a7e, 0x3964, 0x4c30, 0x4e41, 0x556a, 0x4975,
  0x5565, 0x5564, 0x4173, 0x5567, 0x4424, 0x3e73, 0x3379, 0x5566,
  0x3f44, 0x3d62, 0x406b, 0x5560, 0x462a, 0x3e62, 0x5563, 0x5562,
  0x453d, 0x5561, 0x557c, 0x4f3b, 0x3d69, 0x557d, 0x3378, 0x3e53,
  0x4360, 0x5579, 0x557f, 0x4d76, 0x3a67, 0x5576, 0x3769, 0x5578,
  0x557e, 0x4542, 0x557a, 0x557b, 0x3749, 0x336d, 0x5571, 0x4a20,
  0x5575, 0x5570, 0x5577, 0x5574, 0x4a42, 0x3c74, 0x364e, 0x4a79,
  0x3978, 0x4155, 0x3d68, 0x562f, 0x562e, 0x4a68, 0x4b26, 0x5628,
  0x3c77, 0x5629, 0x3722, 0x562b, 0x4f5b, 0x4031, 0x492b, 0x4e54,
  0x562a, 0x7458, 0x423d, 0x5625, 0x3027, 0x483e, 0x3a2c, 0x5624,
  0x4e6a, 0x5620, 0x4427, 0x5627, 0x325d, 0x5626, 0x3026, 0x3323,
  0x5623, 0x5622, 0x563d, 0x563c, 0x3856, 0x3c76, 0x4853, 0x4865,
  0x427a, 0x4e7c, 0x563f, 0x563e, 0x5638, 0x563a, 0x563b, 0x5635,
  0x3630, 0x4f41, 0x3e71, 0x5634, 0x4554, 0x3a2f, 0x3224, 0x5637,
  0x4c56, 0x5636, 0x5631, 0x5630, 0x5633, 0x4d29, 0x3265, 0x3468,
  0x4232, 0x5632, 0x3930, 0x4464, 0x564c, 0x564d, 0x3a2e, 0x3c6c,
  0x564e, 0x4c33, 0x5649, 0x4c51, 0x4639, 0x4663, 0x3225, 0x4263,
  0x473c, 0x4363, 0x4f43, 0x564b, 0x4467, 0x3338, 0x564a, 0x5645,
  0x3521, 0x3478, 0x3060, 0x4625, 0x315c, 0x497c, 0x5646, 0x363a,
  0x5647, 0x3227, 0x5641, 0x487c, 0x5640, 0x4a5f, 0x3c71, 0x3c3b,
  0x5643, 0x565d, 0x5642, 0x3b52, 0x3534, 0x3553, 0x565c, 0x565f,
  0x3c3a, 0x565e, 0x3163, 0x3f3f, 0x5659, 0x4f79, 0x3e38, 0x3157,
  0x492a, 0x455d, 0x4c32, 0x3870, 0x394a, 0x3865, 0x3878, 0x397b,
  0x4c4d, 0x565a, 0x354e, 0x455c, 0x3c70, 0x3c48, 0x326a, 0x5656,
  0x472c, 0x4673, 0x3226, 0x3a29, 0x5651, 0x5657, 0x3649, 0x466b,
  0x3835, 0x3f46, 0x352b, 0x377d, 0x3d6b, 0x3f47, 0x5650, 0x5653,
  0x3144, 0x374b, 0x3d6a, 0x3145, 0x4052, 0x3528, 0x423c, 0x4833,
  0x3d2c, 0x4974, 0x414a, 0x3c73, 0x3322, 0x566a, 0x326e, 0x4f47,
  0x4c50, 0x566b, 0x3053, 0x566c, 0x566f, 0x5669, 0x5668, 0x3156,
  0x3b6c, 0x4e20, 0x566e, 0x5652, 0x3c6e, 0x566d, 0x4b29, 0x4e7f,
  0x4065, 0x3c6f, 0x3d7d, 0x5665, 0x4250, 0x5661, 0x3873, 0x387b,
  0x5662, 0x5660, 0x482e, 0x5667, 0x567e, 0x5663, 0x567c, 0x3c4b,
  0x4832, 0x567f, 0x5679, 0x567b, 0x3e7d, 0x4b4f, 0x5666, 0x5664,
  0x5678, 0x567d, 0x5675, 0x572e, 0x5677, 0x5673, 0x572c, 0x5676,
  0x5733, 0x3e64, 0x373c, 0x5674, 0x5728, 0x347b, 0x5729, 0x3428,
  0x4d47, 0x572f, 0x5671, 0x567a, 0x5670, 0x3e45, 0x572b, 0x347a,
  0x5722, 0x572a, 0x5725, 0x3a28, 0x4f64, 0x5720, 0x5721, 0x4122,
  0x5723, 0x5726, 0x3539, 0x3e3b, 0x3b3d, 0x5724, 0x416f, 0x5727,
  0x342f, 0x5739, 0x492e, 0x3a2a, 0x5737, 0x5734, 0x573d, 0x464e,
  0x573c, 0x4662, 0x573b, 0x3a2b, 0x573e, 0x4869, 0x3331, 0x573a,
  0x5735, 0x5738, 0x5736, 0x573f, 0x574c, 0x574b, 0x574f, 0x5730,
  0x574a, 0x453c, 0x5744, 0x3d2f, 0x5732, 0x4770, 0x574e, 0x5731,
  0x3020, 0x3063, 0x3768, 0x5749, 0x574d, 0x337b, 0x5747, 0x5745,
  0x455e, 0x3147, 0x3221, 0x5748, 0x3279, 0x3549, 0x5743, 0x5741,
  0x502a, 0x575c, 0x5746, 0x5742, 0x5740, 0x3f41, 0x575d, 0x575e,
  0x5755, 0x575b, 0x5758, 0x473f, 0x3648, 0x575f, 0x5759, 0x3a25,
  0x353e, 0x575a, 0x3653, 0x576f, 0x3a71, 0x5753, 0x5751, 0x5750,
  0x5752, 0x3530, 0x4534, 0x5754, 0x5757, 0x3777, 0x576c, 0x3062,
  0x5769, 0x576d, 0x576e, 0x4e23, 0x4258, 0x4c35, 0x576b, 0x5768,
  0x3748, 0x576a, 0x5767, 0x5764, 0x5765, 0x4334, 0x5766, 0x5761,
  0x5763, 0x5760, 0x577d, 0x577e, 0x577c, 0x5762, 0x577f, 0x5779,
  0x5778, 0x577b, 0x577a, 0x5775, 0x5548, 0x3871, 0x3f40, 0x367e,
  0x3475, 0x4749, 0x5774, 0x3e29, 0x3442, 0x3b53, 0x5777, 0x3c4a,
  0x3d7c, 0x5771, 0x5776, 0x4e6d, 0x5770, 0x502c, 0x5773, 0x502f,
  0x502e, 0x337a, 0x356d, 0x5029, 0x502b, 0x5028, 0x5025, 0x4157,
  0x5024, 0x3438, 0x3e52, 0x3330, 0x4742, 0x5027, 0x5026, 0x5020,
  0x5023, 0x3e69, 0x325c, 0x4f3a, 0x5021, 0x5022, 0x3e4c, 0x3d2e,
  0x503e, 0x3e28, 0x473e, 0x503d, 0x4057, 0x5039, 0x3b6f, 0x503f,
  0x5038, 0x3332, 0x503b, 0x503a, 0x3d29, 0x374d, 0x5034, 0x5037,
  0x5036, 0x5035, 0x503c, 0x5031, 0x5030, 0x4f69, 0x3a66, 0x5032,
  0x504d, 0x5033, 0x504f, 0x4335, 0x3465, 0x4d5b, 0x504e, 0x3a70,
  0x3834, 0x4350, 0x307d, 0x3e66, 0x4f54, 0x423f, 0x3375, 0x4642,
  0x504c, 0x5049, 0x4649, 0x5048, 0x504b, 0x5045, 0x4064, 0x3023,
  0x702c, 0x356c, 0x4e7e, 0x3a61, 0x4145, 0x3e6b, 0x5043, 0x4e30,
  0x4a50, 0x3679, 0x5047, 0x4537, 0x5040, 0x416e, 0x4144, 0x4169,
  0x4c34, 0x4040, 0x3e44, 0x5044, 0x357b, 0x413b, 0x5046, 0x504a,
  0x3b5d, 0x5042, 0x3943, 0x3220, 0x505d, 0x4e65, 0x4570, 0x404b,
  0x505f, 0x4f42, 0x505e, 0x5055, 0x4e22, 0x505a, 0x505c, 0x5059,
  0x505b, 0x3e2b, 0x4e44, 0x5054, 0x4748, 0x3678, 0x3a60, 0x5056,
  0x5057, 0x3d65, 0x5051, 0x5053, 0x5050, 0x506d, 0x5058, 0x506f,
  0x506c, 0x5052, 0x3f43, 0x3b5c, 0x4559, 0x506e, 0x4431, 0x3460,
  0x4369, 0x4056, 0x5068, 0x5069, 0x506b, 0x506a, 0x5065, 0x5064,
  0x4e5c, 0x5067, 0x364b, 0x5066, 0x4931, 0x373d, 0x5644, 0x3945,
  0x4632, 0x5061, 0x4866, 0x4839, 0x5063, 0x466a, 0x413a, 0x464d,
  0x4d5a, 0x5062, 0x507d, 0x3576, 0x3837, 0x507c, 0x345d, 0x507f,
  0x507e, 0x356f, 0x307c, 0x426d, 0x4e79, 0x507a, 0x4558, 0x507b,
  0x334d, 0x4f56, 0x5078, 0x4168, 0x5074, 0x5075, 0x5076, 0x5077,
  0x3571, 0x5071, 0x3a24, 0x5073, 0x4728, 0x5070, 0x4e3e, 0x397a,
  0x4156, 0x512c, 0x3d28, 0x512f, 0x432c, 0x4c53, 0x485c, 0x4328,
  0x5126, 0x3135, 0x4948, 0x4822, 0x5221, 0x512e, 0x512b, 0x4648,
  0x4f35, 0x4147, 0x512a, 0x4f68, 0x3e47, 0x3a27, 0x5125, 0x3f5d,
  0x3f42, 0x3434, 0x3c45, 0x4426, 0x345c, 0x5121, 0x5120, 0x5127,
  0x3535, 0x3022, 0x5124, 0x4848, 0x4d3c, 0x3425, 0x3474, 0x3f5c,
  0x345f, 0x342e, 0x513f, 0x513d, 0x4831, 0x513e, 0x513c, 0x5122,
  0x3b3c, 0x5123, 0x4e57, 0x3c69, 0x513a, 0x5135, 0x3a26, 0x5139,
  0x4b21, 0x4341, 0x513b, 0x3e2a, 0x5134, 0x4d55, 0x5137, 0x5138,
  0x4836, 0x4353, 0x5136, 0x4d3f, 0x5131, 0x514d, 0x5130, 0x364a,
  0x5132, 0x3836, 0x5133, 0x3374, 0x5141, 0x5148, 0x514f, 0x4769,
  0x514c, 0x514e, 0x5149, 0x514b, 0x514a, 0x307f, 0x5144, 0x5145,
  0x5147, 0x3a63, 0x5140, 0x4051, 0x3548, 0x5146, 0x5143, 0x5142,
  0x515f, 0x515d, 0x515c, 0x3f5f, 0x515e, 0x3d2b, 0x5159, 0x3f77,
  0x4635, 0x5158, 0x515b, 0x3f57, 0x3d2a, 0x485f, 0x3125, 0x3c44,
  0x515a, 0x3755, 0x5155, 0x4634, 0x5154, 0x522e, 0x5157, 0x5156,
  0x5151, 0x5153, 0x5152, 0x516d, 0x467d, 0x352a, 0x3864, 0x344f,
  0x455a, 0x303d, 0x3838, 0x3d25, 0x416b, 0x392c, 0x303c, 0x4765,
  0x4067, 0x3435, 0x3134, 0x4e78, 0x384f, 0x315f, 0x4466, 0x3831,
  0x4925, 0x516c, 0x3151, 0x3e46, 0x373f, 0x356e, 0x3a21, 0x3645,
  0x516f, 0x494b, 0x3944, 0x3869, 0x516e, 0x307e, 0x425f, 0x4824,
  0x5169, 0x5168, 0x4d54, 0x516a, 0x3025, 0x327a, 0x516b, 0x303f,
  0x3b3f, 0x5166, 0x3f2c, 0x3644, 0x5167, 0x5165, 0x5161, 0x5164,
  0x4326, 0x5840, 0x3b3e, 0x5160, 0x4a4d, 0x5163, 0x517d, 0x4773,
  0x5162, 0x442e, 0x3f76, 0x465d, 0x387a, 0x4d78, 0x4461, 0x3840,
  0x517c, 0x3a20, 0x517f, 0x517e, 0x345e, 0x4637, 0x3b5f, 0x5179,
  0x423e, 0x3a23, 0x3a22, 0x5178, 0x4460, 0x3a3d, 0x517b, 0x517a,
  0x486d, 0x5175, 0x324b, 0x392f, 0x5174, 0x5177, 0x3851, 0x3b21,
  0x4279, 0x3b59, 0x4c75, 0x432f, 0x3244, 0x5176, 0x3162, 0x5171,
  0x3273, 0x4242, 0x363d, 0x3f5e, 0x5170, 0x522f, 0x522c, 0x3270,
  0x5173, 0x4135, 0x463d, 0x4146, 0x3845, 0x4555, 0x4977, 0x5229,
  0x5228, 0x425b, 0x3f3e, 0x522a, 0x5225, 0x5224, 0x3079, 0x5227,
  0x5226, 0x3621, 0x4536, 0x3069, 0x5220, 0x4825, 0x465f, 0x3754,
  0x5222, 0x523c, 0x3052, 0x5223, 0x523d, 0x523e, 0x523f, 0x5239,
  0x5238, 0x4230, 0x3223, 0x3668, 0x523b, 0x5236, 0x5234, 0x4e7a,
  0x4e7b, 0x416a, 0x5235, 0x3959, 0x523a, 0x3b7f, 0x5231, 0x3e67,
  0x524f, 0x524e, 0x5230, 0x373e, 0x5233, 0x524a, 0x524b, 0x5248,
  0x524c, 0x524d, 0x5249, 0x4e75, 0x5246, 0x5245, 0x5247, 0x497f,
  0x5244, 0x5232, 0x3b7e, 0x5241, 0x3e3a, 0x5240, 0x5243, 0x525c,
  0x525d, 0x5242, 0x4165, 0x5237, 0x525a, 0x525e, 0x525f, 0x5259,
  0x5258, 0x5255, 0x4a6b, 0x5254, 0x525b, 0x5257, 0x306d, 0x5256,
  0x5250, 0x5251, 0x5253, 0x5252, 0x4463, 0x392e, 0x3969, 0x456e,
  0x3d24, 0x3e35, 0x3d27, 0x317d, 0x526d, 0x3e34, 0x3c47, 0x526c,
  0x482b, 0x434e, 0x526f, 0x3d26, 0x3021, 0x472a, 0x325f, 0x3f59,
  0x4d56, 0x4c4c, 0x526e, 0x3078, 0x526b, 0x402c, 0x5268, 0x5269,
  0x526a, 0x4066, 0x3b6e, 0x3f58, 0x4447, 0x465e, 0x312f, 0x402f,
  0x5265, 0x5264, 0x3a62, 0x4f34, 0x5261, 0x5266, 0x5267, 0x4d70,
  0x527e, 0x4f57, 0x5260, 0x5262, 0x4f66, 0x5263, 0x527d, 0x4c25,
  0x527c, 0x4e33, 0x527f, 0x303e, 0x4e32, 0x4322, 0x5279, 0x5278,
  0x3d21, 0x3039, 0x527b, 0x3c35, 0x4949, 0x4924, 0x307b, 0x5275,
  0x402e, 0x3d20, 0x3a3c, 0x4c52, 0x3a3f, 0x3975, 0x4061, 0x4e74,
  0x4134, 0x3d23, 0x4d51, 0x5274, 0x4154, 0x3e4f, 0x3c46, 0x4060,
  0x344e, 0x3963, 0x3d22, 0x494a, 0x5277, 0x5276, 0x435c, 0x5271,
  0x4a7a, 0x4b20, 0x5273, 0x5270, 0x374a, 0x532c, 0x5329, 0x5328,
  0x532e, 0x4d4d, 0x3a3e, 0x532a, 0x532b, 0x532f, 0x5325, 0x5324,
  0x5327, 0x5320, 0x5326, 0x5321, 0x5323, 0x3569, 0x4063, 0x5322,
  0x3377, 0x367b, 0x433b, 0x533d, 0x4276, 0x4e56, 0x533c, 0x4b23,
  0x533f, 0x4e4d, 0x5338, 0x542c, 0x543c, 0x383d, 0x4278, 0x533b,
  0x3150, 0x4029, 0x3477, 0x533a, 0x4e2b, 0x3d3d, 0x475d, 0x4062,
  0x4862, 0x3c34, 0x3c41, 0x5335, 0x5334, 0x5332, 0x3868, 0x4028,
  0x3222, 0x5337, 0x4d26, 0x474b, 0x5336, 0x5331, 0x323d, 0x5330,
  0x5333, 0x534d, 0x417b, 0x534c, 0x534f, 0x534e, 0x5339, 0x533e,
  0x5349, 0x334c, 0x4d2a, 0x3e41, 0x4d3a, 0x402b, 0x4d46, 0x5348,
  0x3a39, 0x354b, 0x534b, 0x534a, 0x487f, 0x4c6d, 0x5347, 0x3570,
  0x4421, 0x5344, 0x5345, 0x334f, 0x4659, 0x5343, 0x5341, 0x5346,
  0x4a2a, 0x3c68, 0x3974, 0x5340, 0x4141, 0x3933, 0x424d, 0x535c,
  0x535d, 0x5342, 0x535f, 0x3c6b, 0x535e, 0x4d71, 0x3956, 0x5359,
  0x4c74, 0x424c, 0x402a, 0x413d, 0x5358, 0x3126, 0x3b39, 0x4d21,
  0x307a, 0x432b, 0x535b, 0x3f5b, 0x4f37, 0x4f36, 0x3573, 0x5356,
  0x4764, 0x5355, 0x367a, 0x5c20, 0x5357, 0x433d, 0x5354, 0x535a,
  0x3d77, 0x5350, 0x536e, 0x5364, 0x536c, 0x4151, 0x536b, 0x4d50,
  0x536d, 0x5368, 0x4a6a, 0x3f5a, 0x4658, 0x5353, 0x3153, 0x5365,
  0x4420, 0x3568, 0x536f, 0x3675, 0x536a, 0x323c, 0x5369, 0x5367,
  0x5361, 0x537b, 0x5379, 0x537c, 0x537d, 0x4a75, 0x537f, 0x323f,
  0x3d3c, 0x3977, 0x5374, 0x5366, 0x5362, 0x5352, 0x3677, 0x537e,
  0x5378, 0x475c, 0x3e25, 0x3635, 0x5360, 0x5375, 0x537a, 0x323e,
  0x4624, 0x376b, 0x334e, 0x5363, 0x5377, 0x5370, 0x5c2c, 0x3830,
  0x5c2a, 0x407d, 0x5376, 0x5c28, 0x3674, 0x5c2e, 0x5c29, 0x5373,
  0x5c2f, 0x3c6a, 0x4927, 0x3038, 0x3554, 0x5c2b, 0x4337, 0x3420,
  0x4c6c, 0x5351, 0x5c21, 0x5c3d, 0x4868, 0x5c24, 0x4164, 0x5c23,
  0x3a7d, 0x5c22, 0x425a, 0x4b4a, 0x5c26, 0x5c3c, 0x3d76, 0x4446,
  0x3459, 0x5c27, 0x5c25, 0x4557, 0x5371, 0x3f39, 0x464b, 0x5c30,
  0x4556, 0x5c35, 0x5c38, 0x5c3b, 0x386b, 0x5c34, 0x5c31, 0x5c3a,
  0x3928, 0x5c37, 0x5c39, 0x4871, 0x4876, 0x5c33, 0x5c32, 0x3458,
  0x5c3e, 0x327f, 0x342b, 0x303b, 0x5c36, 0x5c4e, 0x5c4f, 0x5c4a,
  0x5c45, 0x5c4b, 0x5c44, 0x5c4c, 0x5c48, 0x5c47, 0x5c46, 0x5c4d,
  0x3f71, 0x5c49, 0x465b, 0x3d3f, 0x5c3f, 0x3b38, 0x5c55, 0x4e64,
  0x5c43, 0x5c42, 0x5c5d, 0x5c5a, 0x5c5b, 0x4f70, 0x303a, 0x5c59,
  0x3348, 0x3739, 0x5c5c, 0x4a35, 0x5c5e, 0x345b, 0x5c58, 0x5c41,
  0x5c5f, 0x5c54, 0x3349, 0x5c40, 0x4950, 0x4926, 0x5c51, 0x5c6d,
  0x4573, 0x4a74, 0x5c6c, 0x5c53, 0x5c56, 0x5c57, 0x5c52, 0x4e3d,
  0x4239, 0x334b, 0x5c6f, 0x5c50, 0x5c6e, 0x3376, 0x363c, 0x5c66,
  0x3035, 0x5c64, 0x5c67, 0x3e24, 0x5c65, 0x5c6b, 0x5c68, 0x5c61,
  0x5c69, 0x5c63, 0x3676, 0x5c7d, 0x5c62, 0x4025, 0x5c7e, 0x5c7c,
  0x5c6a, 0x3371, 0x5c7f, 0x5c7b, 0x5c78, 0x5c7a, 0x5c79, 0x5c75,
  0x5c74, 0x5c77, 0x4e67, 0x5c71, 0x5c76, 0x3932, 0x4423, 0x366b,
  0x3671, 0x5c70, 0x3432, 0x4441, 0x5c73, 0x684e, 0x5d2c, 0x336c,
  0x5d2f, 0x4462, 0x5d2e, 0x5d29, 0x3137, 0x5d28, 0x5d2b, 0x5d2a,
  0x465a, 0x3c40, 0x486c, 0x4f31, 0x3967, 0x5d25, 0x447d, 0x6a30,
  0x4c6f, 0x3867, 0x3e40, 0x5d24, 0x464a, 0x4e2a, 0x467c, 0x5d21,
  0x5d27, 0x5d20, 0x5d26, 0x5d23, 0x4e3c, 0x343a, 0x4d53, 0x4c6e,
  0x5d22, 0x5d3f, 0x3a38, 0x3136, 0x5d3d, 0x5d3a, 0x3a3b, 0x5d3c,
  0x4349, 0x4953, 0x5d3e, 0x5d39, 0x5d35, 0x4167, 0x5d38, 0x3d3e,
  0x4453, 0x5d4b, 0x4c39, 0x467f, 0x4c69, 0x5e20, 0x4e77, 0x407c,
  0x4f78, 0x5d36, 0x362c, 0x4767, 0x5d49, 0x4739, 0x5d33, 0x5d48,
  0x5d4d, 0x5d4a, 0x5d4e, 0x5d4f, 0x4362, 0x5d31, 0x3670, 0x5d37,
  0x317c, 0x467e, 0x5d3b, 0x5d34, 0x3d39, 0x4456, 0x3a3a, 0x5d4c,
  0x435f, 0x317f, 0x3745, 0x376a, 0x3b2c, 0x5d44, 0x5d43, 0x5d47,
  0x3370, 0x5d42, 0x3f2f, 0x3d64, 0x392b, 0x5d30, 0x3f70, 0x5d41,
  0x3f55, 0x5d40, 0x3449, 0x5d45, 0x4024, 0x317e, 0x3239, 0x5d46,
  0x342a, 0x3e4e, 0x3b3b, 0x407f, 0x4c59, 0x5d5c, 0x4553, 0x4627,
  0x3f26, 0x5d5f, 0x5d59, 0x5d5d, 0x4e6c, 0x4030, 0x4551, 0x4e76,
  0x3843, 0x5d6d, 0x5d52, 0x3b75, 0x3373, 0x5d54, 0x3a34, 0x4265,
  0x433c, 0x5d5a, 0x4550, 0x3875, 0x5d51, 0x3a35, 0x5d5b, 0x5d56,
  0x435e, 0x5d58, 0x332c, 0x3750, 0x5d50, 0x4a26, 0x3e43, 0x4738,
  0x5d57, 0x4451, 0x3d38, 0x3b69, 0x356b, 0x4531, 0x5d55, 0x3148,
  0x334a, 0x4042, 0x5d53, 0x4552, 0x5d6c, 0x5d6e, 0x463a, 0x5d64,
  0x5d69, 0x5d6b, 0x4d4c, 0x407e, 0x5d6a, 0x4921, 0x4945, 0x3034,
  0x3423, 0x5d68, 0x5d6f, 0x3075, 0x356a, 0x5d65, 0x4944, 0x5d61,
  0x4636, 0x5d7e, 0x5d60, 0x5d67, 0x5d7c, 0x5d5e, 0x5d63, 0x5d7f,
  0x4c4f, 0x4166, 0x5d66, 0x5d62, 0x3345, 0x3e7c, 0x4450, 0x5d7a,
  0x412b, 0x5d79, 0x4f6d, 0x5d78, 0x5d7b, 0x4843, 0x442f, 0x336f,
  0x5d70, 0x3f38, 0x5d77, 0x5d74, 0x433f, 0x4238, 0x413c, 0x5d76,
  0x5d71, 0x4d62, 0x4348, 0x3f2e, 0x447c, 0x4f5d, 0x3744, 0x5e28,
  0x5d73, 0x4947, 0x5e2a, 0x5e2e, 0x5e29, 0x456d, 0x5e2f, 0x5d32,
  0x5e2b, 0x5e2c, 0x5e26, 0x5e21, 0x412a, 0x5e23, 0x3f29, 0x5e24,
  0x3131, 0x5e22, 0x5e25, 0x5e3e, 0x5e3f, 0x5e3c, 0x5e39, 0x5e3b,
  0x3a7c, 0x5e38, 0x5e34, 0x5e3a, 0x5e35, 0x5d7d, 0x5e36, 0x5e37,
  0x5d75, 0x5e31, 0x5e3d, 0x3f54, 0x5e30, 0x5e33, 0x5e4d, 0x5e32,
  0x5e4c, 0x3673, 0x3d3b, 0x4e71, 0x4422, 0x3c43, 0x5e4e, 0x5e4b,
  0x4d5f, 0x3152, 0x5e48, 0x5e49, 0x4359, 0x5e4a, 0x3238, 0x5e44,
  0x5e45, 0x3037, 0x3f3b, 0x4255, 0x3344, 0x3b79, 0x5e47, 0x443d,
  0x4125, 0x4d52, 0x5e46, 0x5e41, 0x5e40, 0x4e35, 0x5150, 0x444b,
  0x4d41, 0x3e55, 0x4c68, 0x4c4e, 0x4140, 0x4a4c, 0x5e42, 0x385d,
  0x5e5d, 0x343b, 0x3259, 0x4440, 0x4d6d, 0x5e5c, 0x3f4f, 0x474a,
  0x3f56, 0x3b3a, 0x5e5f, 0x4e70, 0x357a, 0x3f51, 0x5e58, 0x5e5e,
  0x5e5b, 0x4a34, 0x5e59, 0x4476, 0x5e5a, 0x463f, 0x5e55, 0x3077,
  0x5e57, 0x5e54, 0x5e56, 0x5e51, 0x3076, 0x4271, 0x473b, 0x3161,
  0x3f50, 0x456c, 0x3951, 0x343d, 0x5e50, 0x362f, 0x5e6c, 0x3d3a,
  0x5e6d, 0x3e26, 0x3a37, 0x5e52, 0x3a36, 0x484d, 0x3e27, 0x345a,
  0x4443, 0x5e6b, 0x443c, 0x354a, 0x3958, 0x4f6b, 0x3e7f, 0x3a31,
  0x442a, 0x5e68, 0x5e6e, 0x5e69, 0x4766, 0x5f2b, 0x5e67, 0x3f73,
  0x3d35, 0x5e65, 0x5e64, 0x3b35, 0x5e6a, 0x3f22, 0x5e61, 0x5e66,
  0x5e7d, 0x5e7c, 0x5e60, 0x372f, 0x5e63, 0x5e62, 0x4c58, 0x4d6c,
  0x3347, 0x5e7f, 0x443f, 0x3a30, 0x475f, 0x324a, 0x5e7e, 0x5e7a,
  0x3646, 0x5e79, 0x5e7b, 0x5e78, 0x3966, 0x4745, 0x3448, 0x5e75,
  0x5e74, 0x4027, 0x4a7c, 0x3f4e, 0x4e66, 0x4f30, 0x5f2f, 0x5e76,
  0x5e73, 0x5e70, 0x5e77, 0x5f2c, 0x4253, 0x5e71, 0x5f2e, 0x3961,
  0x5f29, 0x4946, 0x4375, 0x5f28, 0x5f2a, 0x5f25, 0x5f24, 0x3247,
  0x3545, 0x3d34, 0x5f27, 0x5f26, 0x397c, 0x456f, 0x5655, 0x4533,
  0x4530, 0x4655, 0x3e4a, 0x547f, 0x3363, 0x4920, 0x4e73, 0x4d73,
  0x5f21, 0x3e7e, 0x4032, 0x5f20, 0x4b22, 0x4f33, 0x4026, 0x5f23,
  0x3071, 0x5f22, 0x5f3d, 0x4857, 0x4829, 0x4f7b, 0x4f51, 0x3f28,
  0x5f3f, 0x3866, 0x4f5c, 0x5f39, 0x5f3a, 0x5f3b, 0x3074, 0x316d,
  0x5f3e, 0x5f38, 0x5f35, 0x3b74, 0x4976, 0x3444, 0x3e6d, 0x4631,
  0x3850, 0x3a7e, 0x5f36, 0x4143, 0x5f34, 0x4626, 0x5f37, 0x3a7f,
  0x4850, 0x5f31, 0x5f30, 0x4965, 0x5f4f, 0x3d37, 0x4358, 0x5f32,
  0x4161, 0x5e53, 0x5e6f, 0x3142, 0x434a, 0x5f4c, 0x3a33, 0x4c49,
  0x5f4a, 0x4c77, 0x5f33, 0x5f49, 0x5f4e, 0x4442, 0x4f60, 0x4a5e,
  0x4f6a, 0x3641, 0x3f53, 0x4b45, 0x5f4b, 0x3b78, 0x5f48, 0x5f4d,
  0x3c42, 0x5f41, 0x5f47, 0x3640, 0x5f45, 0x5f43, 0x5f59, 0x4645,
  0x4e4c, 0x5f5b, 0x4d2f, 0x5f58, 0x437d, 0x4f32, 0x3036, 0x447a,
  0x394d, 0x405e, 0x4923, 0x5f5c, 0x5f5d, 0x5f5f, 0x5f42, 0x5f5a,
  0x5f40, 0x5f46, 0x5f5e, 0x5f44, 0x4761, 0x4875, 0x384b, 0x3e79,
  0x3e37, 0x4f62, 0x374c, 0x4043, 0x4247, 0x3544, 0x447f, 0x4439,
  0x3327, 0x5f54, 0x3d36, 0x3771, 0x5f56, 0x3779, 0x5f6c, 0x5f53,
  0x447e, 0x3746, 0x3e21, 0x3747, 0x3e42, 0x5f51, 0x3368, 0x3346,
  0x4160, 0x5f57, 0x344b, 0x5f50, 0x5f52, 0x3240, 0x3321, 0x3031,
  0x3146, 0x5f6f, 0x3e74, 0x4f7c, 0x3f3a, 0x5f6e, 0x4d3d, 0x5f62,
  0x363e, 0x5f69, 0x5f78, 0x5f68, 0x4a4f, 0x5f61, 0x4352, 0x5f79,
  0x5f6a, 0x3439, 0x5f64, 0x3d31, 0x5f66, 0x5f67, 0x5f6b, 0x5f7c,
  0x3a32, 0x5060, 0x3c65, 0x4971, 0x5f65, 0x4079, 0x372e, 0x3e20,
  0x5f6d, 0x5f7d, 0x376c, 0x5f63, 0x5f7f, 0x4163, 0x3073, 0x583f,
  0x4844, 0x5f7a, 0x3070, 0x5f73, 0x4f4d, 0x582c, 0x582e, 0x582a,
  0x5f74, 0x4727, 0x4162, 0x5826, 0x5f71, 0x5825, 0x582f, 0x3b34,
  0x5821, 0x443e, 0x5827, 0x3030, 0x4b5d, 0x5f7b, 0x582b, 0x3455,
  0x5f75, 0x4837, 0x5f70, 0x3b2f, 0x404a, 0x5f7e, 0x5828, 0x3b77,
  0x5822, 0x377c, 0x3c2c, 0x583c, 0x5f77, 0x583d, 0x5824, 0x5f76,
  0x5820, 0x5823, 0x5832, 0x4243, 0x5829, 0x5836, 0x5830, 0x4055,
  0x4941, 0x4d7b, 0x5835, 0x4647, 0x5833, 0x4532, 0x5838, 0x584f,
  0x584c, 0x4262, 0x584d, 0x4267, 0x5849, 0x583a, 0x3245, 0x5837,
  0x3950, 0x436d, 0x5831, 0x3246, 0x5839, 0x583b, 0x583e, 0x4b3d,
  0x3757, 0x5834, 0x584e, 0x3738, 0x3e6a, 0x3550, 0x5859, 0x4b3c,
  0x585a, 0x3b37, 0x585b, 0x5858, 0x585f, 0x584b, 0x586e, 0x5848,
  0x5855, 0x585d, 0x5846, 0x5845, 0x5844, 0x585c, 0x702f, 0x5843,
  0x3d30, 0x4045, 0x4569, 0x5841, 0x584a, 0x5847, 0x4940, 0x4f67,
  0x5842, 0x5854, 0x586c, 0x5857, 0x586a, 0x5868, 0x586d, 0x5852,
  0x405d, 0x4568, 0x5850, 0x5856, 0x586f, 0x5865, 0x4c78, 0x5863,
  0x5864, 0x5861, 0x586b, 0x4779, 0x4d35, 0x5851, 0x5869, 0x3a4d,
  0x4842, 0x5875, 0x5866, 0x3c2f, 0x362e, 0x3752, 0x585e, 0x3a4c,
  0x587d, 0x587a, 0x3874, 0x377f, 0x4723, 0x5860, 0x587f, 0x587b,
  0x323b, 0x3141, 0x5879, 0x312c, 0x4246, 0x587e, 0x5878, 0x5862,
  0x587c, 0x376d, 0x4744, 0x5871, 0x5877, 0x3c64, 0x5874, 0x592c,
  0x5f55, 0x5876, 0x5870, 0x5873, 0x5921, 0x5925, 0x5f60, 0x592a,
  0x592b, 0x592e, 0x5867, 0x5928, 0x5929, 0x5927, 0x4b2b, 0x5920,
  0x3276, 0x5924, 0x5926, 0x4c2a, 0x5923, 0x593f, 0x5922, 0x497e,
  0x593d, 0x5853, 0x593e, 0x5939, 0x3538, 0x593b, 0x336a, 0x382c,
  0x3258, 0x3629, 0x4952, 0x5935, 0x593a, 0x5937, 0x3130, 0x325b,
  0x3033, 0x5930, 0x5931, 0x5933, 0x3643, 0x473a, 0x5932, 0x3032,
  0x594c, 0x594d, 0x594f, 0x594e, 0x5949, 0x3f52, 0x4438, 0x3e2c,
  0x4d7d, 0x4e6f, 0x4b49, 0x3f78, 0x3e5d, 0x4a7f, 0x5948, 0x594b,
  0x3f6d, 0x594a, 0x5945, 0x5947, 0x5944, 0x4f55, 0x3953, 0x3861,
  0x3f49, 0x5946, 0x5940, 0x3b2e, 0x5941, 0x5943, 0x5942, 0x595d,
  0x595c, 0x595f, 0x5959, 0x595e, 0x5958, 0x3628, 0x4747, 0x595b,
  0x3f2b, 0x3741, 0x595a, 0x414f, 0x5041, 0x312e, 0x5955, 0x5954,
  0x4e61, 0x4f65, 0x424a, 0x5957, 0x4c6b, 0x4c76, 0x485e, 0x5956,
  0x5950, 0x5951, 0x5952, 0x5953, 0x596c, 0x3f6c, 0x483c, 0x596f,
  0x596e, 0x3129, 0x5969, 0x596b, 0x5968, 0x3b68, 0x4d34, 0x3547,
  0x4c48, 0x4078, 0x394c, 0x316c, 0x4c4b, 0x3823, 0x5965, 0x304d,
  0x3575, 0x427f, 0x596a, 0x3d33, 0x475e, 0x5964, 0x597c, 0x5967,
  0x464c, 0x316f, 0x597f, 0x3365, 0x3128, 0x597d, 0x5963, 0x5966,
  0x496d, 0x404d, 0x4254, 0x5961, 0x5979, 0x597e, 0x332e, 0x3620,
  0x3e36, 0x5960, 0x5962, 0x4f5a, 0x4679, 0x4f7a, 0x5971, 0x5970,
  0x3642, 0x4e25, 0x4870, 0x5a2c, 0x382e, 0x3a4f, 0x5975, 0x5973,
  0x3565, 0x323a, 0x5978, 0x5977, 0x4479, 0x437c, 0x4c6a, 0x597a,
  0x4f2c, 0x5974, 0x5a29, 0x5a2f, 0x5976, 0x4f2f, 0x4345, 0x316e,
  0x4128, 0x4760, 0x5a28, 0x5a2e, 0x4654, 0x597b, 0x3546, 0x4943,
  0x5a3d, 0x5a22, 0x447b, 0x5a21, 0x4961, 0x423b, 0x5a2b, 0x4048,
  0x3541, 0x3d32, 0x5a24, 0x392a, 0x5a23, 0x5a20, 0x5a25, 0x5a26,
  0x3765, 0x5a27, 0x4344, 0x4a23, 0x3a79, 0x4478, 0x5a3b, 0x5a39,
  0x4d40, 0x5a3c, 0x5a3e, 0x3537, 0x3d4d, 0x4b3f, 0x3730, 0x4d6f,
  0x496c, 0x3729, 0x3b36, 0x5a38, 0x5a37, 0x3a4e, 0x493d, 0x5a3a,
  0x5a3f, 0x5a35, 0x4a53, 0x417e, 0x424f, 0x373b, 0x3558, 0x5a33,
  0x5a4c, 0x4a4e, 0x4969, 0x5a45, 0x5a4f, 0x5a32, 0x4a59, 0x5a48,
  0x3947, 0x5a4a, 0x5a41, 0x417c, 0x5a47, 0x5a49, 0x4735, 0x5a46,
  0x5a4d, 0x5a4b, 0x5a40, 0x3471, 0x5a4e, 0x5a43, 0x3b31, 0x3952,
  0x4e28, 0x3e23, 0x5a36, 0x5a44, 0x4137, 0x443b, 0x3764, 0x3e5c,
  0x3a49, 0x5a30, 0x394f, 0x3341, 0x5a31, 0x5a5f, 0x3960, 0x3c37,
  0x5a6c, 0x5a56, 0x3179, 0x4142, 0x5a5b, 0x5a52, 0x3422, 0x353f,
  0x3634, 0x5a55, 0x4621, 0x5a42, 0x5a5c, 0x3d4c, 0x5a6f, 0x5a50,
  0x5a58, 0x5a51, 0x4826, 0x5a57, 0x5a53, 0x3c5d, 0x3a48, 0x4734,
  0x5a59, 0x4922, 0x5a5a, 0x5a5d, 0x417f, 0x5a5e, 0x5a54, 0x4b5c,
  0x3833, 0x4f73, 0x5a6e, 0x4c23, 0x5a62, 0x3c36, 0x396d, 0x5a68,
  0x4a22, 0x3d4f, 0x5a7f, 0x3463, 0x5a7d, 0x5a69, 0x5a67, 0x5a61,
  0x4942, 0x5a6a, 0x4123, 0x5a64, 0x5a7c, 0x5a66, 0x484a, 0x5a6b,
  0x382f, 0x5a73, 0x3767, 0x5a65, 0x5a60, 0x5a63, 0x4661, 0x4657,
  0x5a7b, 0x5a71, 0x5a77, 0x4124, 0x5b2e, 0x5a7a, 0x5a75, 0x5a6d,
  0x3174, 0x4d37, 0x3832, 0x3d7a, 0x4b3e, 0x5a79, 0x5b2f, 0x3564,
  0x456b, 0x4374, 0x304c, 0x4a77, 0x482c, 0x405f, 0x5a76, 0x5a70,
  0x453f, 0x5b2c, 0x5a74, 0x5a7e, 0x304e, 0x3364, 0x5b22, 0x5b27,
  0x4475, 0x376e, 0x396c, 0x5b3e, 0x5b21, 0x4021, 0x5b24, 0x4054,
  0x5b41, 0x5b2b, 0x5b28, 0x5b23, 0x5b25, 0x5b2a, 0x5b20, 0x442c,
  0x5b29, 0x5b3d, 0x5b3c, 0x304f, 0x5b3b, 0x5b38, 0x5b3a, 0x5b37,
  0x414e, 0x5b39, 0x5b35, 0x336e, 0x4674, 0x5b3f, 0x4336, 0x5b34,
  0x5b33, 0x5b31, 0x5b32, 0x5b4f, 0x5b36, 0x3d67, 0x4325, 0x5a34,
  0x4979, 0x5b30, 0x5b4c, 0x4678, 0x5b4d, 0x5b26, 0x6b64, 0x5b48,
  0x5b44, 0x5b4a, 0x5b4e, 0x5b49, 0x5b45, 0x5b4b, 0x4d43, 0x5b43,
  0x5b46, 0x5b47, 0x5b40, 0x4259, 0x5b42, 0x4778, 0x4660, 0x4428,
  0x5b5d, 0x5b5f, 0x5b5c, 0x5a78, 0x5b5e, 0x426a, 0x5b59, 0x365d,
  0x4179, 0x3728, 0x3169, 0x3853, 0x3e5f, 0x4b2a, 0x3b6b, 0x3567,
  0x5b5b, 0x5b58, 0x5b54, 0x4737, 0x5b51, 0x5b5a, 0x5b56, 0x5b57,
  0x414d, 0x3454, 0x4a78, 0x5b53, 0x3525, 0x5b6d, 0x5b52, 0x5b50,
  0x5b55, 0x4f2e, 0x5b6f, 0x5b6c, 0x3566, 0x5b69, 0x4e3f, 0x5b6e,
  0x4838, 0x3a4a, 0x453e, 0x3a4b, 0x4a76, 0x5b67, 0x4474, 0x5b6b,
  0x5b66, 0x3561, 0x5b64, 0x436c, 0x5b68, 0x5b65, 0x3a45, 0x4c5c,
  0x5b61, 0x385c, 0x4477, 0x5b62, 0x5b6a, 0x332a, 0x5b60, 0x495d,
  0x5b7d, 0x702b, 0x3942, 0x5b7c, 0x5b7f, 0x4323, 0x5b79, 0x5b78,
  0x433e, 0x4178, 0x5b7a, 0x5b74, 0x4a58, 0x5b7b, 0x5b75, 0x3560,
  0x5b7e, 0x5756, 0x5b77, 0x456a, 0x3f35, 0x5b71, 0x5b76, 0x3b29,
  0x5654, 0x5b70, 0x642c, 0x5b63, 0x5b73, 0x642f, 0x4377, 0x642e,
  0x6429, 0x6428, 0x642b, 0x4053, 0x6425, 0x642a, 0x6424, 0x6427,
  0x3852, 0x4d6e, 0x4861, 0x6426, 0x6421, 0x455b, 0x3829, 0x6420,
  0x6423, 0x6422, 0x4e5f, 0x4c4a, 0x643d, 0x435a, 0x4020, 0x643c,
  0x366a, 0x3160, 0x484b, 0x483b, 0x3639, 0x4b39, 0x4f5f, 0x4e27,
  0x443a, 0x643f, 0x424e, 0x3c2e, 0x643e, 0x3e59, 0x6438, 0x6439,
  0x643b, 0x643a, 0x6435, 0x3133, 0x6434, 0x6437, 0x3c29, 0x4c45,
  0x6431, 0x3a78, 0x6436, 0x3235, 0x6430, 0x6432, 0x6433, 0x644d,
  0x3c5c, 0x644c, 0x3264, 0x454d, 0x3d70, 0x644e, 0x6449, 0x644f,
  0x3860, 0x4245, 0x3234, 0x644b, 0x4721, 0x6448, 0x4b38, 0x436f,
  0x6444, 0x6446, 0x6445, 0x4859, 0x6447, 0x6441, 0x4a49, 0x645d,
  0x6442, 0x477b, 0x4320, 0x3c28, 0x6443, 0x6440, 0x493c, 0x493f,
  0x645c, 0x3563, 0x3d7b, 0x3f6f, 0x645f, 0x645e, 0x6458, 0x394e,
  0x645a, 0x645b, 0x6455, 0x3740, 0x6457, 0x6454, 0x6451, 0x6456,
  0x3c31, 0x4a25, 0x3241, 0x362b, 0x3267, 0x306c, 0x4a65, 0x6453,
  0x646d, 0x646c, 0x365c, 0x6450, 0x3f34, 0x404c, 0x6452, 0x6469,
  0x3863, 0x646f, 0x3333, 0x4c44, 0x646e, 0x6473, 0x6464, 0x3c30,
  0x3168, 0x646b, 0x4970, 0x4a3d, 0x467b, 0x6465, 0x6467, 0x4a5b,
  0x325a, 0x4c71, 0x4347, 0x6466, 0x6460, 0x647d, 0x6461, 0x6462,
  0x3c67, 0x3540, 0x647c, 0x3b7d, 0x6463, 0x4a51, 0x6479, 0x7029,
  0x647f, 0x6478, 0x646a, 0x647e, 0x3e31, 0x647b, 0x647a, 0x4973,
  0x6475, 0x6474, 0x6468, 0x6477, 0x3049, 0x3828, 0x6476, 0x6471,
  0x6470, 0x3536, 0x652c, 0x4d36, 0x652f, 0x3029, 0x652e, 0x6529,
  0x6528, 0x652a, 0x6525, 0x652b, 0x4d5e, 0x6527, 0x6524, 0x6521,
  0x6526, 0x6520, 0x6523, 0x653d, 0x6522, 0x3d74, 0x653f, 0x653c,
  0x3048, 0x3b5e, 0x4131, 0x653e, 0x4435, 0x3f37, 0x3574, 0x6539,
  0x495c, 0x4e6e, 0x6538, 0x4149, 0x493e, 0x3d4e, 0x3b30, 0x4746,
  0x5639, 0x4023, 0x3665, 0x653b, 0x653a, 0x6531, 0x6537, 0x6534,
  0x5e4f, 0x372b, 0x6535, 0x3457, 0x4c27, 0x4c47, 0x4a3c, 0x6530,
  0x6536, 0x4751, 0x442b, 0x4c26, 0x4d20, 0x6532, 0x4a21, 0x3340,
  0x654d, 0x6533, 0x4c5b, 0x654c, 0x654f, 0x3456, 0x3a7b, 0x654a,
  0x6549, 0x4260, 0x654e, 0x312b, 0x6547, 0x6548, 0x654b, 0x6544,
  0x6545, 0x4d28, 0x454f, 0x454c, 0x3132, 0x6546, 0x6541, 0x6540,
  0x6542, 0x6543, 0x355b, 0x655a, 0x4c65, 0x655c, 0x655e, 0x6558,
  0x3b33, 0x655b, 0x6559, 0x384d, 0x655d, 0x655f, 0x4d4f, 0x3a44,
  0x6554, 0x6555, 0x6557, 0x382b, 0x3e22, 0x417a, 0x6556, 0x4046,
  0x6550, 0x4a2c, 0x6551, 0x4564, 0x656f, 0x6569, 0x6568, 0x4759,
  0x656e, 0x656d, 0x6553, 0x6552, 0x656c, 0x6565, 0x656b, 0x656a,
  0x6564, 0x6566, 0x6561, 0x6560, 0x6563, 0x6567, 0x657d, 0x6562,
  0x657c, 0x4a48, 0x6579, 0x657f, 0x657e, 0x306f, 0x4873, 0x4e47,
  0x657b, 0x6578, 0x657a, 0x6575, 0x6571, 0x6574, 0x6577, 0x6576,
  0x6570, 0x6573, 0x662c, 0x662f, 0x662e, 0x4c22, 0x415d, 0x6629,
  0x437f, 0x4d39, 0x6628, 0x662b, 0x4127, 0x372a, 0x3d49, 0x662a,
  0x6625, 0x6624, 0x3f24, 0x6626, 0x6627, 0x6621, 0x6620, 0x4c64,
  0x6623, 0x6622, 0x7764, 0x663d, 0x663c, 0x663f, 0x3f23, 0x663e,
  0x435b, 0x4f52, 0x3543, 0x355a, 0x6639, 0x663b, 0x6638, 0x417d,
  0x4434, 0x5934, 0x663a, 0x484c, 0x6635, 0x304b, 0x4c5a, 0x6634,
  0x6637, 0x6636, 0x4851, 0x4858, 0x4033, 0x4567, 0x6630, 0x396f,
  0x3a47, 0x664d, 0x6632, 0x6633, 0x4c70, 0x304a, 0x3c24, 0x664b,
  0x664e, 0x3b32, 0x483f, 0x664f, 0x6649, 0x6648, 0x664c, 0x664a,
  0x6645, 0x4022, 0x306e, 0x4768, 0x6644, 0x6647, 0x6640, 0x3b6a,
  0x4249, 0x6643, 0x4f5e, 0x6646, 0x6641, 0x665c, 0x665d, 0x6642,
  0x665e, 0x665f, 0x6659, 0x665b, 0x6658, 0x4e40, 0x395b, 0x4a4b,
  0x665a, 0x423a, 0x6655, 0x6654, 0x6650, 0x6656, 0x6651, 0x6657,
  0x6653, 0x6652, 0x666d, 0x666c, 0x483a, 0x666f, 0x487d, 0x666e,
  0x4743, 0x4367, 0x3266, 0x4736, 0x6669, 0x3237, 0x445d, 0x6668,
  0x3e30, 0x666b, 0x666a, 0x3c2b, 0x3e58, 0x6664, 0x415b, 0x3e5b,
  0x3143, 0x4f29, 0x4346, 0x415a, 0x3d51, 0x6666, 0x3a46, 0x4a3f,
  0x3d48, 0x3c2a, 0x4c2e, 0x6660, 0x6662, 0x3c66, 0x6663, 0x407b,
  0x667c, 0x373a, 0x6661, 0x4c67, 0x353d, 0x3e61, 0x4b5f, 0x667d,
  0x667f, 0x4e46, 0x4454, 0x6679, 0x6678, 0x667e, 0x3743, 0x6676,
  0x6677, 0x382a, 0x6671, 0x667a, 0x6670, 0x6675, 0x4c55, 0x667b,
  0x6674, 0x672f, 0x672c, 0x4f6c, 0x6673, 0x3466, 0x6729, 0x672e,
  0x3a41, 0x6728, 0x454e, 0x672a, 0x672b, 0x6725, 0x6665, 0x6667,
  0x6727, 0x6724, 0x3825, 0x4a64, 0x385f, 0x6726, 0x333a, 0x314d,
  0x312a, 0x3f6e, 0x4939, 0x673c, 0x673d, 0x4549, 0x6720, 0x6722,
  0x3946, 0x3b4d, 0x6723, 0x6721, 0x4327, 0x3a40, 0x4d31, 0x3e5a,
  0x4175, 0x673f, 0x673e, 0x6744, 0x3255, 0x4b30, 0x4538, 0x6739,
  0x365f, 0x407a, 0x4e2c, 0x6738, 0x3177, 0x673b, 0x6735, 0x6734,
  0x4324, 0x6737, 0x6736, 0x6731, 0x3254, 0x365e, 0x4248, 0x3925,
  0x3f69, 0x6730, 0x3924, 0x3647, 0x4d4e, 0x6733, 0x4c66, 0x4548,
  0x674c, 0x674f, 0x4364, 0x3b4c, 0x6732, 0x476c, 0x674d, 0x3a43,
  0x3451, 0x3124, 0x674e, 0x4075, 0x6749, 0x444a, 0x4820, 0x4d2e,
  0x6748, 0x674b, 0x4758, 0x4a4a, 0x6745, 0x674a, 0x3862, 0x6747,
  0x347d, 0x6740, 0x6746, 0x3659, 0x3343, 0x6741, 0x3d4b, 0x3d7f,
  0x4e6b, 0x6743, 0x4f59, 0x675d, 0x445c, 0x3542, 0x3637, 0x3421,
  0x6742, 0x675c, 0x675f, 0x3a7a, 0x675e, 0x3742, 0x6758, 0x3367,
  0x316b, 0x675b, 0x3278, 0x675a, 0x4471, 0x4240, 0x446d, 0x3e78,
  0x6755, 0x476f, 0x4566, 0x6757, 0x6751, 0x6754, 0x6756, 0x332f,
  0x6750, 0x332b, 0x316a, 0x495f, 0x6752, 0x676d, 0x3523, 0x676e,
  0x377b, 0x676f, 0x676c, 0x6768, 0x6753, 0x676b, 0x4a24, 0x676a,
  0x6765, 0x5079, 0x6767, 0x6764, 0x6766, 0x6761, 0x4a38, 0x6760,
  0x7462, 0x3a42, 0x6763, 0x6762, 0x395a, 0x4235, 0x677d, 0x4725,
  0x677c, 0x4731, 0x677f, 0x3228, 0x5532, 0x4750, 0x383e, 0x3045,
  0x677e, 0x602f, 0x677b, 0x3165, 0x6778, 0x6029, 0x6779, 0x3a5d,
  0x6775, 0x6774, 0x4126, 0x6777, 0x3753, 0x3b57, 0x4d69, 0x6771,
  0x4665, 0x677a, 0x6776, 0x6770, 0x3e76, 0x602b, 0x4d23, 0x4c2b,
  0x4174, 0x3257, 0x6028, 0x602e, 0x4c38, 0x6773, 0x4753, 0x4176,
  0x4177, 0x3e7b, 0x6035, 0x6025, 0x6027, 0x6020, 0x6023, 0x6026,
  0x6021, 0x6024, 0x602a, 0x602c, 0x4e42, 0x3658, 0x6038, 0x603f,
  0x603a, 0x603b, 0x437e, 0x482a, 0x3f36, 0x603d, 0x6034, 0x6039,
  0x603e, 0x6022, 0x603c, 0x3044, 0x4730, 0x4470, 0x4c2f, 0x6033,
  0x4c29, 0x446c, 0x6036, 0x4c42, 0x6032, 0x4e5e, 0x4756, 0x6037,
  0x6031, 0x6030, 0x604d, 0x3849, 0x424b, 0x6048, 0x6049, 0x604c,
  0x4b3b, 0x6047, 0x6043, 0x6046, 0x604a, 0x6045, 0x6040, 0x604f,
  0x5658, 0x6044, 0x604e, 0x6041, 0x605f, 0x3047, 0x6042, 0x605d,
  0x605c, 0x6059, 0x605e, 0x4c7b, 0x6058, 0x4a71, 0x4e60, 0x6057,
  0x605a, 0x605b, 0x445f, 0x6054, 0x6056, 0x6055, 0x6052, 0x6051,
  0x6050, 0x604b, 0x6053, 0x606d, 0x606c, 0x4e4b, 0x606f, 0x486f,
  0x3243, 0x3324, 0x606e, 0x4e39, 0x3b65, 0x483d, 0x6069, 0x4a3e,
  0x4379, 0x454b, 0x4339, 0x3940, 0x344d, 0x6064, 0x606a, 0x6068,
  0x302c, 0x3a5c, 0x6067, 0x6065, 0x606b, 0x6063, 0x6060, 0x6061,
  0x6066, 0x6062, 0x607d, 0x4437, 0x607c, 0x607e, 0x607f, 0x3c5f,
  0x4535, 0x6078, 0x4171, 0x6079, 0x607b, 0x4e38, 0x4561, 0x3d4a,
  0x607a, 0x4a45, 0x6074, 0x6077, 0x6076, 0x6071, 0x3f68, 0x6070,
  0x3342, 0x3167, 0x3127, 0x612c, 0x487e, 0x3d45, 0x6073, 0x6129,
  0x486b, 0x4331, 0x4d3e, 0x396e, 0x612e, 0x385e, 0x3d44, 0x3f6b,
  0x3164, 0x4e3b, 0x612f, 0x454a, 0x4f4f, 0x3e7a, 0x3f6a, 0x4050,
  0x612a, 0x4a52, 0x3e54, 0x6125, 0x3b4f, 0x6127, 0x3a5f, 0x3e3d,
  0x6124, 0x3927, 0x3c33, 0x4545, 0x6128, 0x6126, 0x612b, 0x335d,
  0x6123, 0x613f, 0x3366, 0x6120, 0x613b, 0x3d47, 0x4960, 0x3431,
  0x613e, 0x3166, 0x613d, 0x613c, 0x4170, 0x6122, 0x6121, 0x3725,
  0x4469, 0x3c25, 0x6135, 0x6138, 0x613a, 0x6139, 0x335c, 0x463e,
  0x6134, 0x4563, 0x614b, 0x614f, 0x6131, 0x614d, 0x3877, 0x3450,
  0x6136, 0x614e, 0x614a, 0x3d46, 0x485b, 0x405b, 0x6130, 0x6148,
  0x6137, 0x4733, 0x6132, 0x3430, 0x4847, 0x6133, 0x3256, 0x4c61,
  0x4560, 0x4a5d, 0x3962, 0x6163, 0x6145, 0x4473, 0x6149, 0x6144,
  0x6146, 0x4074, 0x6143, 0x6147, 0x4e59, 0x3046, 0x4846, 0x3453,
  0x6140, 0x4a70, 0x6141, 0x3562, 0x4261, 0x6142, 0x615b, 0x615d,
  0x615a, 0x615e, 0x4376, 0x3847, 0x6158, 0x615f, 0x6155, 0x615c,
  0x3949, 0x4f28, 0x3941, 0x6159, 0x616d, 0x6151, 0x6152, 0x6150,
  0x616c, 0x6156, 0x614c, 0x445e, 0x4c46, 0x6153, 0x6154, 0x452c,
  0x335f, 0x3926, 0x3b28, 0x453b, 0x6169, 0x616b, 0x616a, 0x616e,
  0x6168, 0x6157, 0x616f, 0x6167, 0x6164, 0x4f77, 0x3326, 0x6165,
  0x6161, 0x6166, 0x6162, 0x617c, 0x3f31, 0x6160, 0x617f, 0x617e,
  0x6179, 0x6177, 0x4136, 0x617b, 0x6178, 0x617a, 0x6175, 0x6174,
  0x6176, 0x6171, 0x3041, 0x6170, 0x6173, 0x622c, 0x622f, 0x622e,
  0x6229, 0x6228, 0x622b, 0x6225, 0x622a, 0x6224, 0x6227, 0x6226,
  0x6223, 0x6221, 0x6220, 0x3e6c, 0x335e, 0x475b, 0x4c3e, 0x397d,
  0x4340, 0x4c60, 0x6222, 0x5c60, 0x623d, 0x623f, 0x4968, 0x623c,
  0x6239, 0x623e, 0x495e, 0x6238, 0x4c73, 0x623b, 0x6234, 0x6235,
  0x623a, 0x6237, 0x333f, 0x452f, 0x314c, 0x6233, 0x6236, 0x6231,
  0x6232, 0x624d, 0x6230, 0x3524, 0x362a, 0x624f, 0x624e, 0x6249,
  0x496f, 0x3921, 0x624b, 0x6248, 0x3b64, 0x624a, 0x6245, 0x6244,
  0x3068, 0x3040, 0x6247, 0x6246, 0x4f50, 0x496e, 0x4959, 0x4b3a,
  0x3d40, 0x6243, 0x3859, 0x6240, 0x6242, 0x3824, 0x465c, 0x625d,
  0x3d41, 0x485a, 0x625c, 0x625f, 0x625e, 0x6259, 0x6258, 0x3827,
  0x4860, 0x625a, 0x4732, 0x625b, 0x6254, 0x6255, 0x6257, 0x4436,
  0x6256, 0x6251, 0x4e34, 0x6250, 0x4562, 0x6253, 0x6252, 0x4a73,
  0x626f, 0x626c, 0x626d, 0x403d, 0x626e, 0x3b2b, 0x6269, 0x6268,
  0x4b35, 0x626b, 0x626a, 0x6264, 0x6265, 0x4c28, 0x4274, 0x4b33,
  0x4c24, 0x6266, 0x3a5e, 0x4d27, 0x6261, 0x6267, 0x3043, 0x3c59,
  0x3f65, 0x4c63, 0x3c27, 0x4f4e, 0x6262, 0x6260, 0x3d43, 0x3d42,
  0x3464, 0x3e65, 0x4354, 0x3452, 0x6279, 0x474d, 0x4355, 0x4656,
  0x627b, 0x627f, 0x6278, 0x627d, 0x627e, 0x4f2b, 0x3c58, 0x3470,
  0x627c, 0x6275, 0x6274, 0x4234, 0x3236, 0x632b, 0x4330, 0x3f64,
  0x3231, 0x4445, 0x4b4b, 0x4823, 0x627a, 0x4459, 0x315e, 0x6277,
  0x6271, 0x6276, 0x6270, 0x472b, 0x4333, 0x403c, 0x632e, 0x632f,
  0x6273, 0x3b58, 0x4d68, 0x6328, 0x6329, 0x3d5d, 0x4b5e, 0x6338,
  0x6324, 0x6327, 0x387d, 0x6325, 0x3d75, 0x632a, 0x6326, 0x403f,
  0x4e2f, 0x452e, 0x4651, 0x6322, 0x633d, 0x6321, 0x6320, 0x6323,
  0x3d5c, 0x633b, 0x633f, 0x4d6b, 0x4f61, 0x4d25, 0x633c, 0x6339,
  0x633e, 0x4f49, 0x633a, 0x6335, 0x453a, 0x6334, 0x6336, 0x6332,
  0x6331, 0x6337, 0x4332, 0x6330, 0x6333, 0x363f, 0x6348, 0x634d,
  0x634c, 0x634f, 0x462c, 0x6349, 0x634e, 0x634b, 0x634a, 0x6345,
  0x3b4e, 0x3664, 0x6344, 0x4a5a, 0x3826, 0x3920, 0x3f67, 0x475a,
  0x6347, 0x6346, 0x353c, 0x6341, 0x6340, 0x6343, 0x6342, 0x635d,
  0x3230, 0x5e27, 0x635c, 0x4468, 0x635f, 0x3846, 0x635e, 0x543d,
  0x6359, 0x4e53, 0x3051, 0x4529, 0x3955, 0x4d7c, 0x3923, 0x6358,
  0x3d5f, 0x635b, 0x4c41, 0x6369, 0x6355, 0x4644, 0x4378, 0x3c32,
  0x635a, 0x4528, 0x6354, 0x4077, 0x6356, 0x6357, 0x6350, 0x6351,
  0x6353, 0x636d, 0x6352, 0x3042, 0x636c, 0x636f, 0x636e, 0x3e3c,
  0x4a44, 0x6368, 0x3b2a, 0x357d, 0x636b, 0x636a, 0x6365, 0x347f,
  0x6364, 0x6367, 0x4d6a, 0x384a, 0x6361, 0x3724, 0x343f, 0x6366,
  0x6363, 0x4343, 0x3b49, 0x365b, 0x4f2a, 0x3350, 0x3251, 0x6360,
  0x3667, 0x302e, 0x357c, 0x637f, 0x4a67, 0x4650, 0x4d49, 0x6373,
  0x365a, 0x6371, 0x6377, 0x637c, 0x6362, 0x637d, 0x386e, 0x3261,
  0x477a, 0x425c, 0x355c, 0x6379, 0x637e, 0x6374, 0x6378, 0x6375,
  0x485d, 0x637a, 0x3655, 0x3770, 0x6376, 0x6370, 0x3359, 0x6c2e,
  0x6c21, 0x6c20, 0x3426, 0x6c39, 0x347c, 0x6c26, 0x6c27, 0x6c28,
  0x6c29, 0x6c2f, 0x6c2c, 0x476e, 0x4676, 0x6c2a, 0x6c2b, 0x6c24,
  0x457d, 0x3358, 0x354c, 0x6c25, 0x3d5e, 0x457c, 0x6c37, 0x6c36,
  0x3654, 0x3623, 0x6c35, 0x6c23, 0x6c3b, 0x6c30, 0x6c3a, 0x6c38,
  0x637b, 0x6c3e, 0x6c22, 0x305d, 0x6c3c, 0x6c31, 0x6c3f, 0x6c33,
  0x6c3d, 0x4371, 0x4964, 0x6c34, 0x6c42, 0x6c4a, 0x3b76, 0x314b,
  0x3250, 0x6c4f, 0x3656, 0x3a59, 0x6c48, 0x3e57, 0x415c, 0x6c47,
  0x4e63, 0x6c4c, 0x3657, 0x3c5b, 0x4d24, 0x6c46, 0x6c32, 0x6c45,
  0x6c5f, 0x6c4e, 0x6c49, 0x4237, 0x6c44, 0x6c4b, 0x4f25, 0x6c41,
  0x346d, 0x6c4d, 0x6c43, 0x6c40, 0x4366, 0x6c59, 0x6c52, 0x3773,
  0x6c6f, 0x6c5d, 0x6c58, 0x4963, 0x6c53, 0x4958, 0x4a27, 0x4775,
  0x3766, 0x4d7f, 0x6c69, 0x422c, 0x343c, 0x6c50, 0x6c54, 0x457f,
  0x6c5e, 0x6c56, 0x6c6d, 0x4321, 0x3427, 0x6c55, 0x6c6c, 0x4d75,
  0x6c51, 0x6c5a, 0x3a58, 0x3922, 0x3821, 0x4855, 0x4d4a, 0x6c6a,
  0x6c7d, 0x6c57, 0x377a, 0x3a75, 0x6c68, 0x6c67, 0x457e, 0x6c6b,
  0x6c60, 0x4752, 0x6c63, 0x495b, 0x6c6e, 0x3735, 0x6c64, 0x6c61,
  0x4821, 0x6c62, 0x6c65, 0x6c66, 0x4f24, 0x4b2c, 0x6c7e, 0x6c77,
  0x6c7f, 0x384e, 0x6c5c, 0x4e43, 0x482f, 0x6c74, 0x6c75, 0x6c79,
  0x6c78, 0x353b, 0x6c7a, 0x6c7c, 0x4058, 0x6c7b, 0x3473, 0x462f,
  0x4e4e, 0x6c76, 0x6d2c, 0x4c54, 0x6c73, 0x3a5b, 0x3844, 0x6d2e,
  0x3233, 0x6d29, 0x4d74, 0x6c70, 0x6c5b, 0x6c71, 0x4b42, 0x422f,
  0x4d7e, 0x6d26, 0x6d3c, 0x6d3f, 0x6d28, 0x437b, 0x6d22, 0x6d2a,
  0x6d24, 0x6d3e, 0x6d25, 0x6d21, 0x357f, 0x4268, 0x6d20, 0x6d3d,
  0x6d2b, 0x452b, 0x6d27, 0x3f2a, 0x3b48, 0x333d, 0x4879, 0x4874,
  0x397f, 0x6d3a, 0x6d38, 0x4b43, 0x6d39, 0x4978, 0x6d3b, 0x6d35,
  0x6d34, 0x6d31, 0x6d37, 0x422e, 0x6d36, 0x4c40, 0x6d23, 0x397e,
  0x6d30, 0x6d4f, 0x4579, 0x6d4c, 0x6d2f, 0x6d4e, 0x4544, 0x6d33,
  0x6d4d, 0x6d32, 0x593c, 0x592f, 0x6d48, 0x6d49, 0x497b, 0x6631,
  0x6d4b, 0x6d4a, 0x6d45, 0x3c5a, 0x3159, 0x6d47, 0x5550, 0x3178,
  0x4a37, 0x327e, 0x6d46, 0x6d41, 0x4763, 0x6d40, 0x4277, 0x3437,
  0x366e, 0x6d5f, 0x6d5e, 0x6d43, 0x3f30, 0x6d42, 0x434f, 0x6d5d,
  0x6d5c, 0x6d56, 0x6d58, 0x6d55, 0x6d59, 0x6d5b, 0x6d5a, 0x3855,
  0x6d54, 0x474c, 0x335b, 0x374f, 0x6d51, 0x3732, 0x6d6c, 0x6d50,
  0x6d6d, 0x4c37, 0x6d53, 0x6d52, 0x4d45, 0x4c57, 0x6d6f, 0x4670,
  0x6d61, 0x6d65, 0x3666, 0x6d6b, 0x4f27, 0x6d6a, 0x6d69, 0x6d68,
  0x6d67, 0x6d60, 0x6d66, 0x6d64, 0x6d6e, 0x4755, 0x6d79, 0x4827,
  0x6d7f, 0x6d7e, 0x6d63, 0x6d7d, 0x6d7c, 0x6d62, 0x446b, 0x4b34,
  0x6d75, 0x6d74, 0x6e2c, 0x3b27, 0x6d76, 0x6d73, 0x6d7b, 0x6d78,
  0x6e2f, 0x3651, 0x6d71, 0x6e2e, 0x6d70, 0x6d77, 0x403e, 0x6d7a,
  0x4365, 0x6e2a, 0x4936, 0x6e2b, 0x6e28, 0x6e23, 0x6e25, 0x6e3d,
  0x496b, 0x6e3e, 0x6e27, 0x6e26, 0x6e22, 0x6e3f, 0x6e3c, 0x6e24,
  0x6e21, 0x6e30, 0x6e3b, 0x6e39, 0x6e38, 0x6e37, 0x6e36, 0x3727,
  0x314f, 0x6e34, 0x6e29, 0x6e35, 0x6e31, 0x6e3a, 0x6e33, 0x6e4d,
  0x6e32, 0x6e4f, 0x6e4c, 0x6d57, 0x6e4b, 0x6e4e, 0x6e49, 0x6e48,
  0x6e4a, 0x3361, 0x6e44, 0x6e45, 0x393d, 0x3d59, 0x5a2a, 0x6e47,
  0x395c, 0x3734, 0x6e46, 0x355f, 0x3a5a, 0x6e41, 0x3d58, 0x6e40,
  0x346c, 0x4d30, 0x6e43, 0x3b67, 0x6e58, 0x6e5f, 0x4762, 0x6e5e,
  0x6e5d, 0x3253, 0x6e42, 0x6e5b, 0x333b, 0x4653, 0x6e51, 0x6e55,
  0x4638, 0x6e5a, 0x6e57, 0x6e5c, 0x6e56, 0x6e50, 0x4c62, 0x6e54,
  0x6e53, 0x6e6d, 0x3c5e, 0x6e59, 0x344c, 0x6e52, 0x3e56, 0x4a7b,
  0x6e6c, 0x6e6f, 0x4578, 0x4a2f, 0x6e6e, 0x4938, 0x6e69, 0x6e68,
  0x4e69, 0x6e6b, 0x3e4d, 0x4a2e, 0x6e66, 0x6e61, 0x3a55, 0x6e67,
  0x496a, 0x6e6a, 0x6e64, 0x4430, 0x3b73, 0x6e65, 0x6e60, 0x4e2e,
  0x6e62, 0x6e63, 0x3761, 0x4f26, 0x6e7d, 0x6e71, 0x6e7f, 0x6e7e,
  0x6e79, 0x6e78, 0x6e74, 0x6e77, 0x6e75, 0x6e7b, 0x6e7c, 0x6e7a,
  0x6e76, 0x743a, 0x3625, 0x6e73, 0x3252, 0x6e70, 0x6f2f, 0x6f2c,
  0x6f29, 0x6f2e, 0x6f28, 0x393c, 0x6f2b, 0x6f2a, 0x6f25, 0x4433,
  0x495a, 0x6f24, 0x4e29, 0x434b, 0x6f27, 0x6f26, 0x3c26, 0x3121,
  0x6f21, 0x3f66, 0x434c, 0x6f20, 0x375d, 0x6f23, 0x6f3d, 0x497a,
  0x6f22, 0x3b4b, 0x6f3c, 0x6f3f, 0x6f3e, 0x305c, 0x6f39, 0x6f38,
  0x6f3b, 0x6f3a, 0x375c, 0x6f35, 0x6f34, 0x6f37, 0x367f, 0x3b25,
  0x6f36, 0x6f31, 0x6f30, 0x3c4d, 0x4076, 0x6f33, 0x335a, 0x3b5b,
  0x6f4c, 0x4229, 0x6f4d, 0x333c, 0x6f32, 0x467a, 0x3120, 0x6f4f,
  0x6f4e, 0x3a54, 0x3360, 0x6f49, 0x4f21, 0x4452, 0x317b, 0x4878,
  0x4547, 0x6f48, 0x3b4a, 0x477d, 0x3a57, 0x6f4b, 0x6f44, 0x6f47,
  0x3e33, 0x464f, 0x6f45, 0x3a56, 0x4d33, 0x6f4a, 0x3f61, 0x355e,
  0x6f43, 0x3355, 0x3f63, 0x3f60, 0x4b40, 0x6f40, 0x6f41, 0x452a,
  0x3140, 0x4b4e, 0x3737, 0x3a51, 0x6f46, 0x6f5d, 0x6f5c, 0x6f42,
  0x3c55, 0x494d, 0x3f62, 0x432a, 0x6f59, 0x444d, 0x474f, 0x493b,
  0x6f5a, 0x3c61, 0x4432, 0x6f5e, 0x6f55, 0x3c60, 0x6f58, 0x6f5b,
  0x6f5f, 0x446f, 0x4244, 0x4722, 0x3650, 0x4c7d, 0x314e, 0x4039,
  0x6f56, 0x6f54, 0x4741, 0x444c, 0x305f, 0x6f57, 0x3b56, 0x4a47,
  0x4b4d, 0x6f51, 0x6f6a, 0x4038, 0x6f6b, 0x6f6e, 0x6f66, 0x6f69,
  0x6f6d, 0x4071, 0x6f52, 0x6f50, 0x492c, 0x3f7d, 0x6f6c, 0x6f53,
  0x6f68, 0x3979, 0x3c4c, 0x4677, 0x4f48, 0x3557, 0x346f, 0x4228,
  0x6f64, 0x6f65, 0x426b, 0x6f60, 0x6f6f, 0x6f61, 0x6f63, 0x3c21,
  0x6f67, 0x3d5b, 0x3858, 0x6f62, 0x4955, 0x6f7f, 0x6f78, 0x6f7e,
  0x4d38, 0x6f7d, 0x326d, 0x6f79, 0x6f7b, 0x6f77, 0x6f7a, 0x6f74,
  0x6f75, 0x6f76, 0x383c, 0x6f70, 0x6f71, 0x4d65, 0x682c, 0x3354,
  0x6f73, 0x682f, 0x682e, 0x3149, 0x624c, 0x3a74, 0x6829, 0x3c63,
  0x6828, 0x682b, 0x3f33, 0x5e43, 0x682a, 0x6825, 0x393f, 0x6824,
  0x6827, 0x6826, 0x6821, 0x6820, 0x4726, 0x6823, 0x683d, 0x6822,
  0x422b, 0x683c, 0x4f20, 0x683f, 0x683e, 0x6839, 0x6838, 0x4257,
  0x3a50, 0x683b, 0x3d66, 0x5423, 0x683a, 0x6835, 0x4d32, 0x6834,
  0x684c, 0x6837, 0x6831, 0x6836, 0x6830, 0x4f4b, 0x6833, 0x6832,
  0x684d, 0x684f, 0x3720, 0x406a, 0x4d64, 0x3e6f, 0x3d5a, 0x4d42,
  0x3652, 0x4c43, 0x6848, 0x305e, 0x4458, 0x6849, 0x6844, 0x4774,
  0x486e, 0x684a, 0x6845, 0x3123, 0x6847, 0x436e, 0x4652, 0x4c7c,
  0x4130, 0x684b, 0x4f4a, 0x3661, 0x6841, 0x4b25, 0x404f, 0x4b48,
  0x3f7c, 0x6846, 0x463c, 0x6851, 0x4525, 0x4275, 0x4d5d, 0x6842,
  0x3f32, 0x3f7f, 0x3a53, 0x4368, 0x3c20, 0x6843, 0x6840, 0x4d67,
  0x384c, 0x415f, 0x685c, 0x685f, 0x3d55, 0x685d, 0x685e, 0x6859,
  0x685b, 0x462e, 0x6858, 0x306b, 0x6855, 0x685a, 0x6854, 0x6856,
  0x6850, 0x6853, 0x445b, 0x3842, 0x6852, 0x375f, 0x686d, 0x457b,
  0x686c, 0x686f, 0x4d66, 0x3122, 0x686e, 0x403b, 0x3556, 0x6869,
  0x387c, 0x3b7b, 0x4620, 0x686a, 0x686b, 0x6868, 0x6860, 0x6866,
  0x6865, 0x6867, 0x6864, 0x6861, 0x317a, 0x687d, 0x445a, 0x687c,
  0x3c54, 0x6863, 0x6862, 0x4b24, 0x403a, 0x4524, 0x687f, 0x6878,
  0x687e, 0x6879, 0x4954, 0x422a, 0x6875, 0x687b, 0x687a, 0x6874,
  0x6924, 0x6871, 0x6870, 0x6876, 0x6877, 0x4070, 0x692c, 0x6928,
  0x692f, 0x6873, 0x692e, 0x6929, 0x6926, 0x692b, 0x4455, 0x6925,
  0x6927, 0x692a, 0x6920, 0x393e, 0x6921, 0x6923, 0x6922, 0x693f,
  0x693c, 0x693d, 0x6939, 0x693e, 0x487b, 0x693b, 0x6938, 0x693a,
  0x6935, 0x6937, 0x6934, 0x3b45, 0x6936, 0x3260, 0x6931, 0x6933,
  0x6932, 0x694d, 0x6930, 0x694c, 0x385b, 0x694f, 0x313d, 0x333e,
  0x3c23, 0x694e, 0x427d, 0x4133, 0x6949, 0x694a, 0x3839, 0x694b,
  0x6948, 0x3357, 0x6945, 0x375e, 0x6947, 0x3e51, 0x6944, 0x695f,
  0x6941, 0x6943, 0x4e68, 0x6946, 0x6940, 0x695c, 0x6942, 0x313c,
  0x695d, 0x695e, 0x4357, 0x4a55, 0x3939, 0x6959, 0x492f, 0x695b,
  0x6958, 0x6954, 0x494c, 0x6955, 0x3760, 0x695a, 0x6951, 0x6956,
  0x6957, 0x413f, 0x6950, 0x6953, 0x6952, 0x3d61, 0x3328, 0x696d,
  0x696c, 0x696f, 0x3b44, 0x696e, 0x3820, 0x6969, 0x6968, 0x562c,
  0x5573, 0x696b, 0x617d, 0x696a, 0x4729, 0x3b26, 0x434d, 0x6965,
  0x4e58, 0x4059, 0x3d73, 0x4724, 0x3527, 0x4f75, 0x3b5a, 0x3353,
  0x326c, 0x4e5b, 0x6964, 0x6966, 0x6967, 0x366d, 0x427b, 0x6961,
  0x437a, 0x413e, 0x6960, 0x395f, 0x6962, 0x484f, 0x6973, 0x697c,
  0x697f, 0x4044, 0x466d, 0x457a, 0x4225, 0x697d, 0x3158, 0x6974,
  0x697b, 0x6a28, 0x4224, 0x476d, 0x697e, 0x4073, 0x415e, 0x6979,
  0x6975, 0x3b6d, 0x436a, 0x4041, 0x444f, 0x697a, 0x4623, 0x4629,
  0x6978, 0x3424, 0x4b2f, 0x6977, 0x466c, 0x3938, 0x3b47, 0x6971,
  0x6976, 0x3462, 0x6970, 0x4d22, 0x6a2a, 0x4256, 0x3b66, 0x4754,
  0x3275, 0x6a2b, 0x493a, 0x3532, 0x4e5a, 0x366c, 0x6a2c, 0x6a2f,
  0x6a2e, 0x6a29, 0x4236, 0x472e, 0x346e, 0x6a25, 0x6a24, 0x702e,
  0x4630, 0x6a27, 0x357e, 0x4541, 0x3c22, 0x4957, 0x6a26, 0x4121,
  0x4575, 0x385a, 0x6a21, 0x6a22, 0x3968, 0x6a20, 0x4526, 0x4527,
  0x3469, 0x4a46, 0x6a3c, 0x4c7f, 0x6a3e, 0x6a3f, 0x6a3d, 0x6769,
  0x3059, 0x6963, 0x6a38, 0x6a39, 0x6a3b, 0x4935, 0x426c, 0x4f23,
  0x6a3a, 0x3854, 0x6a35, 0x6a34, 0x6a37, 0x412c, 0x3467, 0x3d54,
  0x4b37, 0x6a33, 0x3339, 0x6a36, 0x6a31, 0x4d79, 0x3759, 0x4934,
  0x3232, 0x4159, 0x6a32, 0x6a4d, 0x6a4c, 0x412f, 0x6a4e, 0x6a4f,
  0x425e, 0x6a49, 0x393b, 0x386d, 0x4356, 0x477c, 0x387f, 0x3b61,
  0x6a48, 0x6a4b, 0x3b50, 0x6a4a, 0x6a45, 0x6a44, 0x4962, 0x393a,
  0x6a46, 0x6a47, 0x3d57, 0x3d7e, 0x3f4d, 0x6a43, 0x396b, 0x6a40,
  0x6a41, 0x4664, 0x3c62, 0x444e, 0x4c3d, 0x3934, 0x6a42, 0x3a52,
  0x6a5f, 0x6a5d, 0x6a5c, 0x6a59, 0x6a5e, 0x3a77, 0x6a58, 0x6a5b,
  0x6a5a, 0x4c5d, 0x3e5e, 0x386c, 0x6a55, 0x6a54, 0x4a29, 0x3948,
  0x4863, 0x4a41, 0x6a57, 0x326f, 0x6a56, 0x412e, 0x6a53, 0x3775,
  0x3b46, 0x6a51, 0x6a50, 0x406d, 0x4f58, 0x3271, 0x6a6d, 0x6a6c,
  0x6a52, 0x6a6e, 0x4252, 0x374e, 0x6a6a, 0x6a69, 0x6a6b, 0x6a6f,
  0x6b42, 0x6a68, 0x4a66, 0x3c57, 0x6a62, 0x4139, 0x6a67, 0x6a60,
  0x6a66, 0x6a7d, 0x6a7c, 0x6a64, 0x6a7b, 0x3579, 0x6a65, 0x4c20,
  0x6a61, 0x3a6d, 0x3d56, 0x4f45, 0x3269, 0x394b, 0x4231, 0x4520,
  0x6a79, 0x6a63, 0x6a7e, 0x484e, 0x4035, 0x6a78, 0x6a7f, 0x4521,
  0x6a74, 0x6a75, 0x6a7a, 0x4f22, 0x3976, 0x6a77, 0x4e52, 0x3559,
  0x4d4b, 0x477f, 0x3175, 0x6a71, 0x3d50, 0x3f21, 0x6a76, 0x3b60,
  0x3b63, 0x6b2c, 0x6b2e, 0x3a76, 0x6b2f, 0x6b29, 0x325e, 0x4d48,
  0x386f, 0x4b2e, 0x6a73, 0x3e75, 0x4b32, 0x6b2b, 0x6b28, 0x6b2a,
  0x6a70, 0x4264, 0x4158, 0x405a, 0x6b21, 0x474e, 0x6b25, 0x6b24,
  0x3320, 0x6b26, 0x3c3d, 0x6b27, 0x3a6c, 0x3774, 0x6b3d, 0x3e32,
  0x4574, 0x4047, 0x3736, 0x6b23, 0x6b22, 0x404e, 0x6b20, 0x6b3c,
  0x6b3a, 0x6b37, 0x6b34, 0x4120, 0x6b3f, 0x6b3e, 0x6b3b, 0x6b35,
  0x324d, 0x6b36, 0x6b38, 0x6b39, 0x6b32, 0x6b4d, 0x6b4c, 0x6b33,
  0x6b30, 0x3a6f, 0x4227, 0x6b31, 0x6b48, 0x6b4e, 0x6b49, 0x6b4f,
  0x4675, 0x6b4b, 0x6b4a, 0x6b44, 0x3058, 0x6b45, 0x4877, 0x6b59,
  0x6b47, 0x6b40, 0x6b46, 0x6b41, 0x6b43, 0x6b5d, 0x6b5c, 0x6b5f,
  0x6b58, 0x6b5e, 0x6b5b, 0x6b55, 0x6b5a, 0x4034, 0x486a, 0x6b54,
  0x4523, 0x6b57, 0x4e49, 0x6b56, 0x3726, 0x3531, 0x305a, 0x305b,
  0x6b51, 0x6b50, 0x6b53, 0x6b52, 0x6b6d, 0x3055, 0x3758, 0x3d53,
  0x4c3b, 0x6b6f, 0x6b6c, 0x6b6e, 0x3551, 0x6b6b, 0x6b68, 0x6b69,
  0x6b6a, 0x6b67, 0x344a, 0x6b65, 0x6b61, 0x6b66, 0x6b63, 0x6b60,
  0x6b62, 0x4223, 0x6b7d, 0x6b7c, 0x6b7e, 0x6b7f, 0x4d61, 0x6b79,
  0x6b78, 0x3e68, 0x6b7b, 0x6b7a, 0x4f44, 0x4546, 0x3429, 0x4646,
  0x6b75, 0x4d60, 0x6b76, 0x6b74, 0x3d52, 0x6b77, 0x3c4f, 0x4e48,
  0x6b70, 0x742c, 0x6b73, 0x742f, 0x352c, 0x3b55, 0x3971, 0x3054,
  0x742e, 0x436b, 0x7428, 0x352f, 0x7429, 0x4049, 0x4a40, 0x4226,
  0x6b71, 0x4a2b, 0x3c3c, 0x4956, 0x3274, 0x4a39, 0x3325, 0x466f,
  0x632c, 0x742b, 0x3721, 0x3b62, 0x375b, 0x7425, 0x7424, 0x742a,
  0x3369, 0x3e50, 0x3a6e, 0x352e, 0x4a54, 0x7426, 0x6a23, 0x7427,
  0x7423, 0x7421, 0x7420, 0x7422, 0x743d, 0x4a61, 0x743c, 0x743f,
  0x4444, 0x4c36, 0x3b70, 0x306a, 0x4937, 0x3660, 0x3935, 0x3c56,
  0x7438, 0x7439, 0x3f7e, 0x743b, 0x743e, 0x3f25, 0x7437, 0x6e20,
  0x565b, 0x3b7a, 0x7435, 0x4a28, 0x427c, 0x3526, 0x446e, 0x383b,
  0x4e3a, 0x354d, 0x4a60, 0x4966, 0x7436, 0x4148, 0x3876, 0x7431,
  0x7430, 0x3b41, 0x7433, 0x4a63, 0x7434, 0x744d, 0x744f, 0x744c,
  0x7432, 0x744e, 0x7449, 0x4577, 0x366f, 0x7448, 0x4835, 0x744b,
  0x744a, 0x4b27, 0x5f3c, 0x7445, 0x7444, 0x7447, 0x7443, 0x7446,
  0x7441, 0x7440, 0x7442, 0x4449, 0x487a, 0x4448, 0x745d, 0x4c7e,
  0x745c, 0x775e, 0x4841, 0x745f, 0x745e, 0x7459, 0x375a, 0x745b,
  0x3b54, 0x745a, 0x3329, 0x7455, 0x7451, 0x7457, 0x7456, 0x377e,
  0x7454, 0x7450, 0x7453, 0x3445, 0x7452, 0x746d, 0x3a69, 0x746c,
  0x314a, 0x7469, 0x746e, 0x746f, 0x6f7c, 0x4e51, 0x7468, 0x746b,
  0x746a, 0x7465, 0x7464, 0x7467, 0x3057, 0x7466, 0x7461, 0x432e,
  0x7463, 0x3636, 0x747c, 0x747d, 0x3529, 0x324c, 0x4e4a, 0x4037,
  0x3e2f, 0x3d6d, 0x396a, 0x3b51, 0x747e, 0x747f, 0x494f, 0x3065,
  0x4c5f, 0x4251, 0x3b71, 0x4a43, 0x3356, 0x747b, 0x7478, 0x4f46,
  0x4221, 0x355d, 0x747a, 0x7479, 0x4d5c, 0x4967, 0x7475, 0x7474,
  0x7476, 0x4667, 0x3756, 0x3751, 0x7477, 0x3064, 0x3c3f, 0x3067,
  0x4132, 0x4a6d, 0x3c51, 0x7471, 0x7470, 0x7473, 0x752c, 0x752e,
  0x752f, 0x4d7a, 0x7529, 0x7528, 0x752b, 0x752a, 0x7524, 0x7525,
  0x7527, 0x4c79, 0x6241, 0x3b24, 0x313f, 0x7526, 0x7521, 0x5621,
  0x5936, 0x4c5e, 0x3476, 0x3436, 0x3f79, 0x4f3d, 0x3a73, 0x7520,
  0x4852, 0x7523, 0x4951, 0x354f, 0x3f4c, 0x7522, 0x3663, 0x753d,
  0x753c, 0x753e, 0x7539, 0x753b, 0x753f, 0x7538, 0x3056, 0x753a,
  0x7535, 0x7534, 0x7537, 0x7536, 0x7530, 0x7531, 0x7532, 0x754f,
  0x7533, 0x754d, 0x754c, 0x754e, 0x324f, 0x387e, 0x7549, 0x7548,
  0x3d6c, 0x754b, 0x3733, 0x4342, 0x754a, 0x7545, 0x4757, 0x4266,
  0x7544, 0x4370, 0x4641, 0x3555, 0x3263, 0x3262, 0x477e, 0x7543,
  0x327d, 0x3662, 0x7540, 0x7546, 0x7541, 0x7547, 0x7555, 0x7542,
  0x755d, 0x755c, 0x755f, 0x7559, 0x755e, 0x3954, 0x7558, 0x755a,
  0x313e, 0x755b, 0x4576, 0x3c3e, 0x7554, 0x4640, 0x7557, 0x4220,
  0x7556, 0x756d, 0x7553, 0x7550, 0x7552, 0x7551, 0x756f, 0x756c,
  0x7569, 0x324e, 0x756e, 0x7568, 0x756b, 0x7565, 0x756a, 0x7564,
  0x7566, 0x7567, 0x3d71, 0x7561, 0x7560, 0x3731, 0x7563, 0x7562,
  0x3b7c, 0x757d, 0x757c, 0x757f, 0x757e, 0x3d6f, 0x7579, 0x7578,
  0x757b, 0x757a, 0x7575, 0x4c3c, 0x7577, 0x4d2b, 0x7576, 0x7574,
  0x7570, 0x7571, 0x7573, 0x762c, 0x762f, 0x762e, 0x7629, 0x7628,
  0x762b, 0x762a, 0x7625, 0x7624, 0x7627, 0x7626, 0x7621, 0x7620,
  0x7623, 0x5938, 0x7622, 0x6075, 0x3139, 0x372c, 0x3e3f, 0x763c,
  0x763d, 0x4828, 0x763e, 0x7639, 0x763f, 0x7638, 0x4f6f, 0x763b,
  0x3176, 0x4b28, 0x763a, 0x7634, 0x3433, 0x7637, 0x4e26, 0x7635,
  0x7636, 0x7631, 0x7630, 0x7633, 0x7632, 0x4f63, 0x3f20, 0x3e77,
  0x4522, 0x764d, 0x764e, 0x764c, 0x7649, 0x3c7c, 0x764f, 0x7648,
  0x764b, 0x764a, 0x7646, 0x3f27, 0x4669, 0x7641, 0x7644, 0x7645,
  0x7647, 0x3352, 0x765d, 0x7642, 0x7643, 0x343e, 0x7657, 0x765b,
  0x765a, 0x765e, 0x7654, 0x7658, 0x376f, 0x4b41, 0x7655, 0x7659,
  0x765f, 0x765c, 0x7651, 0x7652, 0x7653, 0x7650, 0x4d44, 0x7656,
  0x347e, 0x766d, 0x766f, 0x3762, 0x7640, 0x353a, 0x7669, 0x766e,
  0x766c, 0x4720, 0x4f7d, 0x4a57, 0x7668, 0x766b, 0x766a, 0x7665,
  0x7664, 0x4036, 0x7667, 0x4c3a, 0x7662, 0x7666, 0x7661, 0x4f3c,
  0x4849, 0x425d, 0x767d, 0x767c, 0x4233, 0x7663, 0x7660, 0x3627,
  0x7674, 0x7675, 0x3578, 0x767b, 0x7678, 0x767e, 0x3776, 0x767f,
  0x383f, 0x3624, 0x3d6e, 0x7671, 0x7676, 0x7677, 0x767a, 0x7670,
  0x7673, 0x7728, 0x7729, 0x772b, 0x3520, 0x772c, 0x772f, 0x3d79,
  0x4834, 0x772e, 0x4f3f, 0x7726, 0x772a, 0x7721, 0x7724, 0x7725,
  0x3351, 0x7720, 0x7723, 0x7722, 0x7727, 0x7679, 0x773d, 0x406c,
  0x7739, 0x7738, 0x773e, 0x773f, 0x7735, 0x773c, 0x773b, 0x773a,
  0x7737, 0x7734, 0x7731, 0x7730, 0x7733, 0x4b44, 0x7736, 0x4666,
  0x3e60, 0x7732, 0x774d, 0x774c, 0x774f, 0x774e, 0x3c39, 0x7749,
  0x7748, 0x3822, 0x774b, 0x774a, 0x7745, 0x7744, 0x7741, 0x7747,
  0x4b31, 0x7746, 0x4a62, 0x7740, 0x4a56, 0x7743, 0x4373, 0x7742,
  0x775c, 0x775f, 0x775d, 0x3d60, 0x4840, 0x4f6e, 0x527a, 0x596d,
  0x4f76, 0x3626, 0x7759, 0x315d, 0x7758, 0x775b, 0x775a, 0x3d78,
  0x7755, 0x6459, 0x4856, 0x466e, 0x7754, 0x7756, 0x7757, 0x7751,
  0x7750, 0x7753, 0x7752, 0x776d, 0x776c, 0x776f, 0x776e, 0x7769,
  0x7768, 0x776b, 0x776a, 0x7765, 0x4129, 0x3c50, 0x7767, 0x4540,
  0x7766, 0x7761, 0x4d2c, 0x7760, 0x7763, 0x673a, 0x6857, 0x7460,
  0x7762, 0x777d, 0x777f, 0x777e, 0x7779, 0x4a7d, 0x777c, 0x7778,
  0x777b, 0x7775, 0x777a, 0x7777, 0x7776, 0x7774, 0x4a3b, 0x7771,
  0x7770, 0x6759, 0x7773, 0x2527, 0x2579, 0x257d, 0x257e, 0x2578,
  0x2547, 0x2546, 0x257b, 0x2551, 0x2529, 0x2528, 0x2532, 0x273d,
  0x273c, 0x273f, 0x273e, 0x2739, 0x2738, 0x273b, 0x273a, 0x2735,
  0x2734, 0x252a, 0x2525, 0x256e, 0x256c, 0x2569, 0x2524, 0x257a,
  0x274c, 0x274f, 0x274e, 0x2749, 0x2748, 0x274b, 0x274a, 0x2745,
  0x2744, 0x2747, 0x2746, 0x2741, 0x2740, 0x2743, 0x2742, 0x275d,
  0x275c, 0x275f, 0x275e, 0x2759, 0x2758, 0x275b, 0x275a, 0x2755,
  0x2754, 0x2757, 0x2543, 0x254d, 0x2542, 0x253d, 0x253f, 0x2523,
  0x276c, 0x276f, 0x276e, 0x2769, 0x2768, 0x276b, 0x276a, 0x2765,
  0x2764, 0x2767, 0x2766, 0x2761, 0x2760, 0x2763, 0x2762, 0x277d,
  0x277c, 0x277f, 0x277e, 0x2779, 0x2778, 0x277b, 0x277a, 0x2775,
  0x2774, 0x2777, 0x255d, 0x254e, 0x255c, 0x253c, 0x2562,
};

static const Summary16 jisx0208_uni2indx_page00[16] = {
  /* 0x0000 */
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x0000 },
  {    0, 0x0000 }, {    0, 0x0000 }, {    0, 0x118c }, {    5, 0x0053 },
  {    9, 0x0000 }, {    9, 0x0080 }, {   10, 0x0000 }, {   10, 0x0080 },
};
static const Summary16 jisx0208_uni2indx_page03[22] = {
  /* 0x0300 */
  {   11, 0x0000 }, {   11, 0x0000 }, {   11, 0x0000 }, {   11, 0x0000 },
  {   11, 0x0000 }, {   11, 0x0000 }, {   11, 0x0000 }, {   11, 0x0000 },
  {   11, 0x0000 }, {   11, 0xfffe }, {   26, 0x03fb }, {   35, 0xfffe },
  {   50, 0x03fb }, {   59, 0x0000 }, {   59, 0x0000 }, {   59, 0x0000 },
  /* 0x0400 */
  {   59, 0x0002 }, {   60, 0xffff }, {   76, 0xffff }, {   92, 0xffff },
  {  108, 0xffff }, {  124, 0x0002 },
};
static const Summary16 jisx0208_uni2indx_page20[50] = {
  /* 0x2000 */
  {  125, 0x0000 }, {  125, 0x3361 }, {  132, 0x0063 }, {  136, 0x080d },
  {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 },
  {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 },
  {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 }, {  140, 0x0000 },
  /* 0x2100 */
  {  140, 0x0008 }, {  141, 0x0000 }, {  141, 0x0800 }, {  142, 0x0000 },
  {  142, 0x0000 }, {  142, 0x0000 }, {  142, 0x0000 }, {  142, 0x0000 },
  {  142, 0x0000 }, {  142, 0x000f }, {  146, 0x0000 }, {  146, 0x0000 },
  {  146, 0x0000 }, {  146, 0x0014 }, {  148, 0x0000 }, {  148, 0x0000 },
  /* 0x2200 */
  {  148, 0x098d }, {  154, 0x6404 }, {  158, 0x1f81 }, {  165, 0x2030 },
  {  168, 0x0000 }, {  168, 0x0004 }, {  169, 0x0cc3 }, {  175, 0x0000 },
  {  175, 0x00cc }, {  179, 0x0000 }, {  179, 0x0020 }, {  180, 0x0000 },
  {  180, 0x0000 }, {  180, 0x0000 }, {  180, 0x0000 }, {  180, 0x0000 },
  /* 0x2300 */
  {  180, 0x0000 }, {  180, 0x0004 },
};
static const Summary16 jisx0208_uni2indx_page25[23] = {
  /* 0x2500 */
  {  181, 0x900f }, {  187, 0x3999 }, {  195, 0x9939 }, {  203, 0x9999 },
  {  211, 0x0804 }, {  213, 0x0000 }, {  213, 0x0000 }, {  213, 0x0000 },
  {  213, 0x0000 }, {  213, 0x0000 }, {  213, 0x0003 }, {  215, 0x300c },
  {  219, 0xc8c0 }, {  224, 0x0000 }, {  224, 0x8000 }, {  225, 0x0000 },
  /* 0x2600 */
  {  225, 0x0060 }, {  227, 0x0000 }, {  227, 0x0000 }, {  227, 0x0000 },
  {  227, 0x0005 }, {  229, 0x0000 }, {  229, 0xa400 },
};
static const Summary16 jisx0208_uni2indx_page30[16] = {
  /* 0x3000 */
  {  232, 0xffef }, {  247, 0x103f }, {  254, 0x0000 }, {  254, 0x0000 },
  {  254, 0xfffe }, {  269, 0xffff }, {  285, 0xffff }, {  301, 0xffff },
  {  317, 0xffff }, {  333, 0x780f }, {  341, 0xfffe }, {  356, 0xffff },
  {  372, 0xffff }, {  388, 0xffff }, {  404, 0xffff }, {  420, 0x787f },
};
static const Summary16 jisx0208_uni2indx_page4e[1307] = {
  /* 0x4e00 */
  {  431, 0x6f8b }, {  441, 0x43f3 }, {  450, 0x2442 }, {  454, 0x9b46 },
  {  462, 0xe82c }, {  469, 0xe3e0 }, {  477, 0x0004 }, {  478, 0x400a },
  {  481, 0x5f65 }, {  491, 0xdb36 }, {  501, 0x7977 }, {  512, 0x0449 },
  {  516, 0xecd7 }, {  527, 0xe3f0 }, {  536, 0x6038 }, {  541, 0x08c5 },
  /* 0x4f00 */
  {  546, 0xe602 }, {  552, 0x3403 }, {  557, 0x8000 }, {  558, 0x3551 },
  {  565, 0xe0c8 }, {  571, 0x7eab }, {  582, 0x8200 }, {  584, 0x9869 },
  {  591, 0xa948 }, {  597, 0x2942 }, {  602, 0xe803 }, {  608, 0x8060 },
  {  611, 0x441c }, {  616, 0xad93 }, {  625, 0xc03a }, {  631, 0x4568 },
  /* 0x5000 */
  {  637, 0xaa60 }, {  643, 0x8656 }, {  650, 0x3f7a }, {  661, 0x0240 },
  {  663, 0x8388 }, {  668, 0x1461 }, {  673, 0x1020 }, {  675, 0x2174 },
  {  681, 0x2021 }, {  684, 0x0702 }, {  688, 0x3000 }, {  690, 0x40bc },
  {  696, 0xa624 }, {  702, 0x4462 }, {  707, 0x60a8 }, {  712, 0x0a20 },
  /* 0x5100 */
  {  715, 0x0217 }, {  720, 0x8574 }, {  727, 0x0402 }, {  729, 0x9c84 },
  {  735, 0x7bfb }, {  748, 0x1415 }, {  753, 0x7f24 }, {  762, 0x11e2 },
  {  768, 0xb665 }, {  777, 0x02ef }, {  785, 0x1f75 }, {  795, 0x20ff },
  {  804, 0x3a70 }, {  811, 0x3840 }, {  815, 0x26c3 }, {  822, 0x6763 },
  /* 0x5200 */
  {  831, 0x4dd9 }, {  840, 0x2092 }, {  844, 0x46b0 }, {  850, 0x0fc9 },
  {  858, 0xbc98 }, {  866, 0x4850 }, {  870, 0x8638 }, {  876, 0xa03f },
  {  884, 0x2388 }, {  889, 0x8816 }, {  894, 0x3e09 }, {  901, 0x5232 },
  {  907, 0x22aa }, {  913, 0xe3a4 }, {  921, 0x00dd }, {  927, 0xc72c },
  /* 0x5300 */
  {  935, 0xa166 }, {  942, 0x26e1 }, {  949, 0x840b }, {  954, 0x8f0a },
  {  961, 0x27eb }, {  971, 0x559e }, {  980, 0xc241 }, {  985, 0x89bb },
  {  994, 0x0014 }, {  996, 0x8540 }, { 1000, 0x6361 }, { 1007, 0x0849 },
  { 1011, 0x7f0c }, { 1020, 0x8ad0 }, { 1026, 0xff3e }, { 1039, 0x05cf },
  /* 0x5400 */
  { 1047, 0xff1a }, { 1058, 0xa803 }, { 1063, 0x7a41 }, { 1070, 0x7b40 },
  { 1077, 0x4745 }, { 1084, 0x8002 }, { 1086, 0x0500 }, { 1088, 0x38eb },
  { 1097, 0xd851 }, { 1104, 0x0005 }, { 1106, 0x9934 }, { 1113, 0x710c },
  { 1119, 0x0397 }, { 1126, 0x0100 }, { 1127, 0x6366 }, { 1135, 0x2404 },
  /* 0x5500 */
  { 1138, 0x80d0 }, { 1142, 0x0051 }, { 1145, 0xc000 }, { 1147, 0x430a },
  { 1152, 0x9071 }, { 1158, 0x30c8 }, { 1163, 0x0008 }, { 1164, 0x5800 },
  { 1167, 0x0e99 }, { 1174, 0xf700 }, { 1181, 0x5f80 }, { 1188, 0x0041 },
  { 1190, 0x00b0 }, { 1193, 0x9410 }, { 1197, 0x0018 }, { 1199, 0x6280 },
  /* 0x5600 */
  { 1203, 0x0240 }, { 1205, 0x09d0 }, { 1210, 0x8200 }, { 1212, 0x0156 },
  { 1217, 0x5004 }, { 1220, 0x0801 }, { 1222, 0x1d10 }, { 1227, 0x0510 },
  { 1230, 0x84c1 }, { 1235, 0x0010 }, { 1236, 0x4025 }, { 1240, 0x1050 },
  { 1243, 0x410f }, { 1249, 0x4d8a }, { 1256, 0x4009 }, { 1259, 0xa60d },
  /* 0x5700 */
  { 1266, 0xab19 }, { 1274, 0x914c }, { 1280, 0x21c0 }, { 1284, 0x0981 },
  { 1288, 0xc485 }, { 1294, 0x0003 }, { 1296, 0x0652 }, { 1301, 0x8000 },
  { 1302, 0x0b04 }, { 1306, 0x0008 }, { 1307, 0x041d }, { 1312, 0x0009 },
  { 1314, 0x4849 }, { 1319, 0x905c }, { 1325, 0x0009 }, { 1327, 0x1690 },
  /* 0x5800 */
  { 1332, 0x0c65 }, { 1338, 0x2220 }, { 1341, 0x8412 }, { 1345, 0x2433 },
  { 1351, 0x0c03 }, { 1355, 0x4796 }, { 1363, 0x0a04 }, { 1366, 0x4225 },
  { 1371, 0x0028 }, { 1373, 0x9088 }, { 1377, 0x4900 }, { 1380, 0x4f08 },
  { 1386, 0x14a2 }, { 1391, 0xd3aa }, { 1400, 0xd830 }, { 1406, 0x3e87 },
  /* 0x5900 */
  { 1415, 0x8604 }, { 1419, 0x1f61 }, { 1427, 0x7ea4 }, { 1436, 0x4186 },
  { 1441, 0xc390 }, { 1447, 0x05b3 }, { 1454, 0x57a5 }, { 1463, 0x2118 },
  { 1467, 0x241e }, { 1473, 0x2a48 }, { 1478, 0x1128 }, { 1482, 0x4a04 },
  { 1486, 0x0a40 }, { 1489, 0x161b }, { 1496, 0x0d60 }, { 1501, 0x8840 },
  /* 0x5a00 */
  { 1504, 0x020a }, { 1507, 0x9502 }, { 1512, 0x8221 }, { 1516, 0x1060 },
  { 1519, 0x0243 }, { 1523, 0x0400 }, { 1524, 0x1444 }, { 1528, 0x8000 },
  { 1529, 0x0000 }, { 1529, 0x0c04 }, { 1532, 0x0000 }, { 1532, 0x7000 },
  { 1535, 0x1a06 }, { 1540, 0x00c1 }, { 1543, 0x024a }, { 1547, 0x0c00 },
  /* 0x5b00 */
  { 1549, 0x1a00 }, { 1552, 0x0040 }, { 1553, 0x1404 }, { 1556, 0x4045 },
  { 1560, 0x0029 }, { 1563, 0xbdb3 }, { 1574, 0x0a78 }, { 1580, 0x052b },
  { 1586, 0xbba9 }, { 1596, 0xbfa0 }, { 1605, 0x407c }, { 1611, 0x8379 },
  { 1619, 0x12fc }, { 1627, 0xe81d }, { 1635, 0x4bf6 }, { 1645, 0xc569 },
  /* 0x5c00 */
  { 1653, 0xeff6 }, { 1666, 0x044a }, { 1670, 0x2115 }, { 1675, 0xff02 },
  { 1684, 0xed63 }, { 1694, 0x402b }, { 1699, 0xd033 }, { 1706, 0x0242 },
  { 1709, 0x1000 }, { 1710, 0x0013 }, { 1713, 0x1b02 }, { 1718, 0x59ca },
  { 1726, 0x00a0 }, { 1728, 0x0200 }, { 1729, 0xa703 }, { 1736, 0x2c41 },
  /* 0x5d00 */
  { 1741, 0x4880 }, { 1744, 0x8ff2 }, { 1754, 0x0204 }, { 1756, 0x0000 },
  { 1756, 0x5800 }, { 1759, 0x1005 }, { 1762, 0x9200 }, { 1765, 0x0048 },
  { 1767, 0x1894 }, { 1772, 0x2001 }, { 1774, 0x5004 }, { 1777, 0x3480 },
  { 1781, 0x3200 }, { 1784, 0x684c }, { 1790, 0x49ea }, { 1798, 0x68be },
  /* 0x5e00 */
  { 1807, 0x184c }, { 1812, 0x2e42 }, { 1818, 0xa820 }, { 1822, 0x21c9 },
  { 1828, 0x50b9 }, { 1835, 0x80b0 }, { 1839, 0x001e }, { 1843, 0xff7c },
  { 1856, 0x849a }, { 1862, 0x14e0 }, { 1867, 0x28c1 }, { 1872, 0x01e0 },
  { 1876, 0x870e }, { 1883, 0xac49 }, { 1890, 0x130f }, { 1897, 0xdddb },
  /* 0x5f00 */
  { 1909, 0xbe1a }, { 1918, 0x89fb }, { 1928, 0xa2e0 }, { 1934, 0x51a2 },
  { 1940, 0x5502 }, { 1945, 0x32ca }, { 1952, 0x3e46 }, { 1960, 0x928b },
  { 1967, 0x1dbf }, { 1978, 0x438f }, { 1986, 0x6703 }, { 1993, 0x3218 },
  { 1998, 0x3028 }, { 2002, 0x33c0 }, { 2008, 0x0811 }, { 2011, 0xa923 },
  /* 0x6000 */
  { 2018, 0xc000 }, { 2020, 0x3a65 }, { 2028, 0x8fe3 }, { 2038, 0x0402 },
  { 2040, 0x2c4e }, { 2047, 0x8625 }, { 2053, 0xbf3d }, { 2065, 0x00a1 },
  { 2068, 0x3a1a }, { 2075, 0x8cd4 }, { 2082, 0x06c9 }, { 2088, 0x317c },
  { 2096, 0x00e0 }, { 2099, 0x950a }, { 2105, 0x018b }, { 2110, 0x0edb },
  /* 0x6100 */
  { 2119, 0xe34b }, { 2128, 0x8c20 }, { 2132, 0x1182 }, { 2136, 0xf010 },
  { 2141, 0x7d94 }, { 2150, 0xa728 }, { 2157, 0xc9ac }, { 2165, 0x40fb },
  { 2173, 0x4484 }, { 2177, 0x0653 }, { 2183, 0x5a90 }, { 2189, 0x4444 },
  { 2193, 0x3fc8 }, { 2202, 0x0001 }, { 2203, 0x0048 }, { 2205, 0xf5d4 },
  /* 0x6200 */
  { 2215, 0x7701 }, { 2222, 0xec57 }, { 2232, 0xc442 }, { 2237, 0x891d },
  { 2244, 0x6b83 }, { 2252, 0x4928 }, { 2257, 0x4109 }, { 2261, 0xd242 },
  { 2267, 0x061d }, { 2273, 0x59fe }, { 2284, 0x1800 }, { 2286, 0x3a22 },
  { 2292, 0xb7e4 }, { 2302, 0x3b9f }, { 2313, 0xf003 }, { 2319, 0xc0ea },
  /* 0x6300 */
  { 2326, 0x1386 }, { 2332, 0x8202 }, { 2335, 0x8980 }, { 2339, 0xe400 },
  { 2343, 0xb200 }, { 2347, 0x10a1 }, { 2351, 0x4b80 }, { 2356, 0x0cc4 },
  { 2361, 0xd309 }, { 2368, 0x8944 }, { 2373, 0x1faf }, { 2384, 0x4834 },
  { 2389, 0x8259 }, { 2395, 0x0c45 }, { 2400, 0x420a }, { 2404, 0x0450 },
  /* 0x6400 */
  { 2407, 0xa040 }, { 2410, 0x10c8 }, { 2414, 0x3140 }, { 2418, 0x4450 },
  { 2422, 0x4004 }, { 2424, 0x0100 }, { 2425, 0x8280 }, { 2428, 0x0540 },
  { 2431, 0x0108 }, { 2433, 0x442c }, { 2438, 0x6a30 }, { 2444, 0x1a05 },
  { 2449, 0x20a6 }, { 2454, 0x0514 }, { 2458, 0x90cf }, { 2466, 0x6456 },
  /* 0x6500 */
  { 2473, 0x0021 }, { 2475, 0x3100 }, { 2478, 0x9c18 }, { 2484, 0xcbf0 },
  { 2493, 0xa120 }, { 2497, 0x63e2 }, { 2505, 0x104c }, { 2509, 0x01b5 },
  { 2515, 0x538c }, { 2522, 0x9a83 }, { 2529, 0xb8b2 }, { 2537, 0x3281 },
  { 2542, 0x987a }, { 2550, 0x0a84 }, { 2554, 0x33e7 }, { 2564, 0x0c02 },
  /* 0x6600 */
  { 2567, 0xd4cc }, { 2575, 0x9018 }, { 2579, 0xa1a1 }, { 2585, 0x9070 },
  { 2590, 0x8a1e }, { 2597, 0xe004 }, { 2601, 0xc3d4 }, { 2609, 0x0451 },
  { 2613, 0x439a }, { 2620, 0x21c2 }, { 2625, 0x4844 }, { 2629, 0x5310 },
  { 2634, 0x0292 }, { 2638, 0x3640 }, { 2643, 0x0241 }, { 2646, 0xf3bd },
  /* 0x6700 */
  { 2658, 0xab09 }, { 2665, 0xe8f0 }, { 2673, 0x7dc0 }, { 2681, 0xa5d2 },
  { 2689, 0xc242 }, { 2694, 0xd24b }, { 2702, 0xa43f }, { 2711, 0xd0af },
  { 2720, 0x1aa0 }, { 2725, 0x34a1 }, { 2731, 0x8247 }, { 2737, 0x03d8 },
  { 2743, 0xc452 }, { 2749, 0x651b }, { 2757, 0xd294 }, { 2764, 0xc83a },
  /* 0x6800 */
  { 2771, 0x001c }, { 2774, 0x40c8 }, { 2778, 0x0e06 }, { 2783, 0x3314 },
  { 2789, 0x614f }, { 2797, 0xb21b }, { 2805, 0x0088 }, { 2807, 0xc0d0 },
  { 2812, 0xa02a }, { 2817, 0xa898 }, { 2823, 0xa1c5 }, { 2830, 0x166b },
  { 2838, 0x2e50 }, { 2844, 0x85b4 }, { 2851, 0xc08b }, { 2857, 0x0604 },
  /* 0x6900 */
  { 2860, 0xf933 }, { 2870, 0x1e04 }, { 2875, 0x056e }, { 2882, 0xa251 },
  { 2888, 0x0400 }, { 2889, 0x7638 }, { 2897, 0xec07 }, { 2905, 0x73b8 },
  { 2914, 0x4406 }, { 2918, 0x1832 }, { 2923, 0x4081 }, { 2926, 0xc816 },
  { 2932, 0x7c8a }, { 2940, 0x6309 }, { 2946, 0x2980 }, { 2950, 0xaa04 },
  /* 0x6a00 */
  { 2955, 0x1c24 }, { 2960, 0xca9c }, { 2968, 0x4e0e }, { 2975, 0x2760 },
  { 2981, 0x0990 }, { 2985, 0x8300 }, { 2988, 0x0046 }, { 2991, 0x8104 },
  { 2994, 0x6011 }, { 2998, 0x1081 }, { 3001, 0x540d }, { 3007, 0x0908 },
  { 3010, 0x000e }, { 3013, 0xcc0a }, { 3019, 0x0500 }, { 3021, 0x0c00 },
  /* 0x6b00 */
  { 3023, 0x0430 }, { 3026, 0xa044 }, { 3030, 0x008b }, { 3034, 0x6784 },
  { 3041, 0x5288 }, { 3046, 0x8a19 }, { 3052, 0x865e }, { 3060, 0x8b18 },
  { 3066, 0x2e59 }, { 3074, 0x4160 }, { 3078, 0x8c10 }, { 3082, 0x9cbe },
  { 3092, 0x6861 }, { 3098, 0x891c }, { 3104, 0x9800 }, { 3107, 0x0008 },
  /* 0x6c00 */
  { 3108, 0x8100 }, { 3110, 0x089a }, { 3115, 0x0018 }, { 3117, 0x4190 },
  { 3121, 0x4007 }, { 3125, 0xe4a1 }, { 3132, 0x0505 }, { 3136, 0x640d },
  { 3142, 0x310e }, { 3148, 0x0e4d }, { 3155, 0x4806 }, { 3159, 0xff0a },
  { 3169, 0x1632 }, { 3175, 0x2aa8 }, { 3181, 0x852e }, { 3188, 0x000b },
  /* 0x6d00 */
  { 3191, 0x1800 }, { 3193, 0xca84 }, { 3199, 0x0e20 }, { 3203, 0x696c },
  { 3211, 0x0032 }, { 3214, 0x1600 }, { 3217, 0x5658 }, { 3224, 0x0390 },
  { 3228, 0x5120 }, { 3232, 0x1a28 }, { 3237, 0x8000 }, { 3238, 0x1124 },
  { 3242, 0x18e1 }, { 3248, 0x4326 }, { 3254, 0x5d52 }, { 3262, 0x0eaa },
  /* 0x6e00 */
  { 3269, 0x0fa0 }, { 3275, 0xae28 }, { 3282, 0xfa7b }, { 3294, 0x4500 },
  { 3297, 0x6408 }, { 3301, 0x8940 }, { 3305, 0xc880 }, { 3309, 0xc044 },
  { 3313, 0x9005 }, { 3317, 0xb141 }, { 3323, 0x8424 }, { 3327, 0x24c4 },
  { 3332, 0x1a34 }, { 3338, 0x603a }, { 3344, 0x9000 }, { 3346, 0xc194 },
  /* 0x6f00 */
  { 3352, 0x8246 }, { 3357, 0x003a }, { 3361, 0x180d }, { 3366, 0xc106 },
  { 3371, 0x0022 }, { 3373, 0x9910 }, { 3378, 0xe050 }, { 3383, 0x1511 },
  { 3388, 0x4057 }, { 3394, 0x0082 }, { 3396, 0x041a }, { 3400, 0x020a },
  { 3403, 0x004f }, { 3408, 0x8930 }, { 3413, 0xd813 }, { 3420, 0x444a },
  /* 0x7000 */
  { 3425, 0x8a02 }, { 3429, 0xed22 }, { 3437, 0x10c0 }, { 3440, 0x4005 },
  { 3443, 0x1000 }, { 3444, 0x0102 }, { 3446, 0x8808 }, { 3449, 0x3101 },
  { 3453, 0x4600 }, { 3456, 0x0204 }, { 3458, 0xf000 }, { 3462, 0x0708 },
  { 3466, 0x8900 }, { 3469, 0xa200 }, { 3472, 0x0000 }, { 3472, 0x2202 },
  /* 0x7100 */
  { 3475, 0x0200 }, { 3476, 0x1610 }, { 3480, 0x0042 }, { 3482, 0x1040 },
  { 3484, 0x5200 }, { 3487, 0x0260 }, { 3490, 0x52f4 }, { 3498, 0x2000 },
  { 3499, 0x8510 }, { 3503, 0x8230 }, { 3507, 0x1100 }, { 3509, 0x4202 },
  { 3512, 0x4308 }, { 3516, 0x80b5 }, { 3522, 0x70e1 }, { 3529, 0x9a20 },
  /* 0x7200 */
  { 3534, 0x2040 }, { 3536, 0x0801 }, { 3538, 0x3500 }, { 3542, 0xfc65 },
  { 3552, 0x19c1 }, { 3558, 0xab04 }, { 3564, 0x0286 }, { 3568, 0x6214 },
  { 3573, 0x0087 }, { 3577, 0x0044 }, { 3579, 0x9085 }, { 3584, 0x0244 },
  { 3587, 0x405c }, { 3592, 0x0a85 }, { 3597, 0x3207 }, { 3603, 0x3380 },
  /* 0x7300 */
  { 3608, 0x0400 }, { 3609, 0xb8c0 }, { 3615, 0xce20 }, { 3621, 0xc0d0 },
  { 3626, 0xc030 }, { 3630, 0x0080 }, { 3631, 0x0508 }, { 3634, 0x0d25 },
  { 3640, 0x0a90 }, { 3644, 0x0040 }, { 3645, 0x0200 }, { 3646, 0x080c },
  { 3649, 0x6505 }, { 3655, 0x4000 }, { 3656, 0x6421 }, { 3661, 0x4102 },
  /* 0x7400 */
  { 3664, 0x0268 }, { 3668, 0x0000 }, { 3668, 0x0024 }, { 3670, 0x847c },
  { 3677, 0x0002 }, { 3678, 0xde20 }, { 3685, 0x8619 }, { 3691, 0x4049 },
  { 3695, 0x0808 }, { 3697, 0x4000 }, { 3698, 0x0084 }, { 3700, 0x2001 },
  { 3702, 0x8400 }, { 3704, 0x1010 }, { 3706, 0x42cd }, { 3713, 0x01c7 },
  /* 0x7500 */
  { 3719, 0x7038 }, { 3725, 0xd52a }, { 3733, 0x1968 }, { 3739, 0x1d8f },
  { 3748, 0xbe50 }, { 3756, 0x3e12 }, { 3763, 0x2ef5 }, { 3773, 0x81d9 },
  { 3780, 0xcec4 }, { 3788, 0x2412 }, { 3792, 0x0828 }, { 3795, 0x732e },
  { 3804, 0x24ac }, { 3810, 0x4b34 }, { 3817, 0x020c }, { 3820, 0xd41d },
  /* 0x7600 */
  { 3828, 0x2a02 }, { 3832, 0x8000 }, { 3833, 0x0097 }, { 3838, 0x0811 },
  { 3841, 0x11c4 }, { 3846, 0x1144 }, { 3850, 0x1786 }, { 3857, 0x7d45 },
  { 3866, 0x49d9 }, { 3874, 0x0649 }, { 3879, 0x4000 }, { 3880, 0x8791 },
  { 3887, 0x254c }, { 3893, 0xd8c4 }, { 3900, 0x44ba }, { 3907, 0x4914 },
  /* 0x7700 */
  { 3912, 0x1b92 }, { 3919, 0xc800 }, { 3922, 0x0271 }, { 3927, 0x1580 },
  { 3931, 0x0081 }, { 3933, 0x0c00 }, { 3935, 0x096a }, { 3941, 0xc200 },
  { 3944, 0x4800 }, { 3946, 0x4002 }, { 3948, 0x3021 }, { 3952, 0xba49 },
  { 3960, 0x2080 }, { 3962, 0x1c80 }, { 3966, 0xe2ac }, { 3974, 0x1008 },
  /* 0x7800 */
  { 3976, 0x1004 }, { 3978, 0x0034 }, { 3981, 0x00e1 }, { 3985, 0x8414 },
  { 3989, 0x0020 }, { 3990, 0x2000 }, { 3991, 0x9800 }, { 3994, 0x1014 },
  { 3997, 0x70c2 }, { 4003, 0x04aa }, { 4008, 0x8688 }, { 4013, 0x5420 },
  { 4017, 0x0c62 }, { 4022, 0x0413 }, { 4026, 0x9180 }, { 4030, 0x2010 },
  /* 0x7900 */
  { 4032, 0x4082 }, { 4035, 0x0206 }, { 4038, 0x1c40 }, { 4042, 0x5400 },
  { 4045, 0x0383 }, { 4050, 0xe4e9 }, { 4059, 0x2125 }, { 4064, 0x8480 },
  { 4067, 0xe433 }, { 4075, 0x2000 }, { 4076, 0x44c0 }, { 4080, 0xe609 },
  { 4087, 0x0a03 }, { 4091, 0x8126 }, { 4096, 0x12da }, { 4103, 0x0801 },
  /* 0x7a00 */
  { 4105, 0x6901 }, { 4110, 0x9790 }, { 4117, 0x4001 }, { 4119, 0xf886 },
  { 4127, 0xe24d }, { 4135, 0x0081 }, { 4137, 0x0a0e }, { 4142, 0xa651 },
  { 4149, 0x011a }, { 4153, 0x81ec }, { 4160, 0xc600 }, { 4164, 0x8441 },
  { 4168, 0xadb8 }, { 4177, 0xb62c }, { 4185, 0xa46f }, { 4194, 0x8741 },
  /* 0x7b00 */
  { 4200, 0x8d54 }, { 4207, 0x4b02 }, { 4212, 0x1161 }, { 4217, 0x0268 },
  { 4221, 0xbb60 }, { 4229, 0x2057 }, { 4235, 0x50a0 }, { 4239, 0x0433 },
  { 4244, 0xa8c0 }, { 4249, 0xb7b4 }, { 4259, 0x2402 }, { 4262, 0x0112 },
  { 4265, 0x9ad3 }, { 4274, 0x2000 }, { 4275, 0x2271 }, { 4281, 0x00c8 },
  /* 0x7c00 */
  { 4284, 0x2081 }, { 4287, 0x809e }, { 4293, 0x0c8a }, { 4298, 0xe180 },
  { 4303, 0xb009 }, { 4308, 0x8151 }, { 4313, 0x1031 }, { 4317, 0x4028 },
  { 4320, 0x2a0e }, { 4326, 0x89a5 }, { 4333, 0x69b6 }, { 4342, 0x620e },
  { 4348, 0x4425 }, { 4353, 0xd144 }, { 4359, 0x8085 }, { 4363, 0x4d54 },
  /* 0x7d00 */
  { 4370, 0x2c75 }, { 4378, 0x1fb1 }, { 4387, 0xd807 }, { 4394, 0x862d },
  { 4401, 0xd87c }, { 4410, 0x4841 }, { 4414, 0x414e }, { 4420, 0x226e },
  { 4427, 0x8200 }, { 4429, 0x9e08 }, { 4435, 0xf80c }, { 4442, 0xed37 },
  { 4453, 0x8c80 }, { 4457, 0x7526 }, { 4465, 0x9313 }, { 4472, 0x0814 },
  /* 0x7e00 */
  { 4475, 0x0e32 }, { 4481, 0xc804 }, { 4485, 0x484e }, { 4491, 0x6ea6 },
  { 4500, 0x2c4a }, { 4506, 0x6670 }, { 4513, 0x26c0 }, { 4518, 0xba01 },
  { 4524, 0xd30c }, { 4531, 0x185d }, { 4538, 0x0000 }, { 4538, 0x0000 },
  { 4538, 0x0000 }, { 4538, 0x0000 }, { 4538, 0x0000 }, { 4538, 0x0000 },
  /* 0x7f00 */
  { 4538, 0x0000 }, { 4538, 0x0000 }, { 4538, 0x0000 }, { 4538, 0x0540 },
  { 4541, 0x7020 }, { 4545, 0x8133 }, { 4551, 0x4f81 }, { 4558, 0x03a5 },
  { 4564, 0x55ec }, { 4573, 0x6410 }, { 4577, 0xc318 }, { 4583, 0x2344 },
  { 4588, 0x1462 }, { 4593, 0x0034 }, { 4596, 0x0a43 }, { 4601, 0x1a09 },
  /* 0x8000 */
  { 4606, 0x187b }, { 4614, 0x13a5 }, { 4621, 0x0102 }, { 4623, 0xa848 },
  { 4628, 0x0440 }, { 4630, 0xc544 }, { 4636, 0x8106 }, { 4640, 0xe2dd },
  { 4650, 0x1af0 }, { 4657, 0x2d48 }, { 4663, 0xb626 }, { 4671, 0x0416 },
  { 4675, 0x5058 }, { 4680, 0x6e40 }, { 4686, 0x8032 }, { 4690, 0x3112 },
  /* 0x8100 */
  { 4695, 0x07e4 }, { 4702, 0x0c00 }, { 4704, 0x8208 }, { 4707, 0x420a },
  { 4711, 0x4840 }, { 4714, 0x803b }, { 4720, 0x4860 }, { 4724, 0x8713 },
  { 4731, 0x850d }, { 4737, 0x3428 }, { 4742, 0x0319 }, { 4747, 0xe529 },
  { 4755, 0x2345 }, { 4761, 0x870a }, { 4767, 0x25a9 }, { 4774, 0x5c18 },
  /* 0x8200 */
  { 4780, 0x77a6 }, { 4790, 0xd9c5 }, { 4799, 0x5e00 }, { 4804, 0x03e8 },
  { 4810, 0x0081 }, { 4812, 0xa700 }, { 4817, 0xcd54 }, { 4825, 0x41c6 },
  { 4831, 0x2800 }, { 4833, 0xa204 }, { 4837, 0xb860 }, { 4843, 0x2b0a },
  { 4849, 0x0020 }, { 4850, 0xda9e }, { 4860, 0x08ea }, { 4866, 0x0e1a },
  /* 0x8300 */
  { 4872, 0x427c }, { 4879, 0x11c0 }, { 4883, 0x8908 }, { 4887, 0x0376 },
  { 4894, 0x8621 }, { 4899, 0x0105 }, { 4902, 0x0000 }, { 4902, 0x18a8 },
  { 4907, 0x46a0 }, { 4912, 0xc448 }, { 4917, 0x0d05 }, { 4922, 0x2022 },
  { 4925, 0x5422 }, { 4930, 0x9148 }, { 4935, 0x8a01 }, { 4939, 0x2897 },
  /* 0x8400 */
  { 4946, 0x7898 }, { 4953, 0x0008 }, { 4954, 0x1605 }, { 4959, 0x3122 },
  { 4964, 0x4240 }, { 4967, 0x0880 }, { 4969, 0xfa4e }, { 4979, 0x06a2 },
  { 4984, 0x0814 }, { 4987, 0x9211 }, { 4992, 0x2002 }, { 4994, 0x9b04 },
  { 5000, 0x2e52 }, { 5007, 0x0643 }, { 5012, 0x5000 }, { 5014, 0x9010 },
  /* 0x8500 */
  { 5017, 0x0041 }, { 5019, 0x85ba }, { 5027, 0x3042 }, { 5031, 0x2020 },
  { 5033, 0x4f0b }, { 5041, 0x05a0 }, { 5045, 0x2708 }, { 5050, 0x4080 },
  { 5052, 0x0591 }, { 5057, 0x1a93 }, { 5064, 0xdf50 }, { 5073, 0x0600 },
  { 5075, 0xa202 }, { 5079, 0x3021 }, { 5083, 0x0630 }, { 5087, 0x4e80 },
  /* 0x8600 */
  { 5092, 0x0cc4 }, { 5097, 0x04c8 }, { 5101, 0xa004 }, { 5104, 0x8001 },
  { 5106, 0x6000 }, { 5108, 0xd431 }, { 5115, 0x0880 }, { 5117, 0x0a02 },
  { 5120, 0x1c00 }, { 5123, 0x0028 }, { 5125, 0x8e18 }, { 5131, 0x0041 },
  { 5133, 0x6ad0 }, { 5140, 0xca10 }, { 5145, 0xf210 }, { 5151, 0x4b00 },
  /* 0x8700 */
  { 5155, 0x274d }, { 5163, 0x1506 }, { 5168, 0x0220 }, { 5170, 0x8890 },
  { 5174, 0x5a00 }, { 5178, 0x82a8 }, { 5183, 0x4549 }, { 5189, 0x8150 },
  { 5193, 0x2004 }, { 5195, 0x8000 }, { 5196, 0x8804 }, { 5199, 0x2c08 },
  { 5203, 0x08d1 }, { 5208, 0x0005 }, { 5210, 0x8001 }, { 5212, 0x4ac4 },
  /* 0x8800 */
  { 5218, 0xe020 }, { 5222, 0x0062 }, { 5225, 0x008e }, { 5229, 0x0a42 },
  { 5233, 0x3055 }, { 5239, 0x6a8c }, { 5246, 0x090e }, { 5251, 0xe0a5 },
  { 5258, 0x2906 }, { 5263, 0x42c4 }, { 5268, 0x4814 }, { 5272, 0x80b3 },
  { 5278, 0x803e }, { 5284, 0xb330 }, { 5291, 0x0102 }, { 5293, 0x731c },
  /* 0x8900 */
  { 5301, 0x1494 }, { 5306, 0x600d }, { 5311, 0x0c20 }, { 5314, 0x0940 },
  { 5317, 0x301a }, { 5322, 0xc040 }, { 5325, 0xa451 }, { 5331, 0xc094 },
  { 5336, 0x8dca }, { 5344, 0x05c8 }, { 5349, 0x96c2 }, { 5356, 0xa40c },
  { 5361, 0x0001 }, { 5362, 0x3404 }, { 5366, 0x00c8 }, { 5369, 0x0110 },
  /* 0x8a00 */
  { 5371, 0x550d }, { 5378, 0xa9c9 }, { 5386, 0x2428 }, { 5390, 0x1c5a },
  { 5397, 0x0142 }, { 5400, 0x4837 }, { 5407, 0x7a4d }, { 5416, 0x100f },
  { 5421, 0x32b4 }, { 5428, 0x452a }, { 5434, 0x317b }, { 5443, 0x9205 },
  { 5448, 0xb894 }, { 5455, 0x5c44 }, { 5461, 0x68d7 }, { 5470, 0x458a },
  /* 0x8b00 */
  { 5476, 0x5097 }, { 5483, 0x2ed1 }, { 5491, 0x1943 }, { 5497, 0x4208 },
  { 5500, 0xd202 }, { 5505, 0x9d40 }, { 5511, 0x9840 }, { 5515, 0x2097 },
  { 5521, 0x5409 }, { 5526, 0x064d }, { 5532, 0x0000 }, { 5532, 0x0000 },
  { 5532, 0x0000 }, { 5532, 0x0000 }, { 5532, 0x0000 }, { 5532, 0x0000 },
  /* 0x8c00 */
  { 5532, 0x0000 }, { 5532, 0x0000 }, { 5532, 0x0000 }, { 5532, 0x8480 },
  { 5535, 0x5542 }, { 5541, 0x0421 }, { 5544, 0x1c06 }, { 5549, 0x1700 },
  { 5553, 0x7624 }, { 5560, 0x6110 }, { 5564, 0xff87 }, { 5576, 0xb9dd },
  { 5587, 0x659f }, { 5597, 0x5c0a }, { 5603, 0x245d }, { 5610, 0x3c00 },
  /* 0x8d00 */
  { 5614, 0xadb0 }, { 5622, 0x0059 }, { 5626, 0x0000 }, { 5626, 0x0000 },
  { 5626, 0x0000 }, { 5626, 0x0000 }, { 5626, 0x28d0 }, { 5631, 0x009b },
  { 5636, 0x0422 }, { 5639, 0x0200 }, { 5640, 0x0108 }, { 5642, 0x4408 },
  { 5645, 0x9804 }, { 5649, 0xac40 }, { 5654, 0x8d0a }, { 5660, 0x9028 },
  /* 0x8e00 */
  { 5664, 0x8700 }, { 5668, 0xe001 }, { 5672, 0x0400 }, { 5673, 0x0031 },
  { 5676, 0x1794 }, { 5683, 0x8221 }, { 5687, 0x0019 }, { 5690, 0x1054 },
  { 5694, 0x2cb2 }, { 5701, 0x021a }, { 5705, 0x9c02 }, { 5710, 0x4003 },
  { 5713, 0x3d60 }, { 5720, 0x8804 }, { 5723, 0x080c }, { 5726, 0x7900 },
  /* 0x8f00 */
  { 5731, 0x1628 }, { 5736, 0xba3c }, { 5745, 0x8640 }, { 5749, 0xcb08 },
  { 5755, 0x7274 }, { 5763, 0x9080 }, { 5766, 0x001e }, { 5770, 0x0000 },
  { 5770, 0x0000 }, { 5770, 0xd800 }, { 5774, 0xe188 }, { 5780, 0x9c87 },
  { 5788, 0x4034 }, { 5792, 0x0412 }, { 5795, 0xae64 }, { 5803, 0x2791 },
  /* 0x9000 */
  { 5810, 0xe86b }, { 5819, 0xe6fb }, { 5831, 0x408f }, { 5837, 0x5366 },
  { 5845, 0xeea6 }, { 5855, 0x537f }, { 5866, 0xe32b }, { 5875, 0xb5e4 },
  { 5884, 0x869f }, { 5893, 0x0002 }, { 5894, 0x8548 }, { 5899, 0x0122 },
  { 5902, 0x4402 }, { 5905, 0x0800 }, { 5906, 0x2116 }, { 5911, 0x20a0 },
  /* 0x9100 */
  { 5914, 0x0004 }, { 5915, 0x0204 }, { 5917, 0x2000 }, { 5918, 0x0005 },
  { 5920, 0x7e00 }, { 5926, 0x0154 }, { 5930, 0x162c }, { 5936, 0x01ac },
  { 5941, 0x2a84 }, { 5946, 0x1085 }, { 5950, 0x8c14 }, { 5955, 0x0530 },
  { 5959, 0xfbc3 }, { 5970, 0xb943 }, { 5978, 0x00ca }, { 5982, 0x9060 },
  /* 0x9200 */
  { 5986, 0x6000 }, { 5988, 0x4032 }, { 5992, 0x1200 }, { 5994, 0x8090 },
  { 5997, 0x0b30 }, { 6002, 0x4c81 }, { 6007, 0x0054 }, { 6010, 0x4002 },
  { 6012, 0x0029 }, { 6015, 0x1d6a }, { 6023, 0x2000 }, { 6024, 0x0280 },
  { 6026, 0x8000 }, { 6027, 0x0004 }, { 6028, 0x2610 }, { 6032, 0x150c },
  /* 0x9300 */
  { 6037, 0x8040 }, { 6039, 0x0701 }, { 6043, 0xd94d }, { 6052, 0x0c24 },
  { 6056, 0x2810 }, { 6059, 0x1850 }, { 6063, 0x5001 }, { 6066, 0x5020 },
  { 6069, 0x1000 }, { 6070, 0x04d0 }, { 6074, 0x7080 }, { 6078, 0x0201 },
  { 6080, 0x0108 }, { 6082, 0x21c3 }, { 6088, 0x0132 }, { 6092, 0x0000 },
  /* 0x9400 */
  { 6092, 0x0088 }, { 6094, 0x0719 }, { 6100, 0x0802 }, { 6102, 0x0560 },
  { 6106, 0x0012 }, { 6108, 0x4c0e }, { 6114, 0x0405 }, { 6117, 0xf0a1 },
  { 6124, 0x0002 }, { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 },
  { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 },
  /* 0x9500 */
  { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 },
  { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0000 }, { 6125, 0x0080 },
  { 6126, 0x8e8d }, { 6134, 0x035a }, { 6140, 0x21bd }, { 6148, 0x5a04 },
  { 6153, 0x3488 }, { 6158, 0x1170 }, { 6163, 0x0026 }, { 6166, 0x0000 },
  /* 0x9600 */
  { 6166, 0x0000 }, { 6166, 0x1000 }, { 6167, 0xc502 }, { 6172, 0x8804 },
  { 6175, 0xb815 }, { 6182, 0xf801 }, { 6188, 0x147c }, { 6195, 0x25ed },
  { 6204, 0xed60 }, { 6212, 0x1bb0 }, { 6219, 0x0589 }, { 6224, 0x1bd7 },
  { 6234, 0x7af3 }, { 6245, 0x1a62 }, { 6251, 0x0d0c }, { 6256, 0x0ac5 },
  /* 0x9700 */
  { 6262, 0xe5d1 }, { 6271, 0x524a }, { 6277, 0x0490 }, { 6280, 0x6305 },
  { 6286, 0x0354 }, { 6291, 0x5244 }, { 6296, 0x2b57 }, { 6305, 0x1612 },
  { 6310, 0xa872 }, { 6317, 0x1101 }, { 6320, 0x2949 }, { 6326, 0x0018 },
  { 6328, 0x0948 }, { 6332, 0x1008 }, { 6334, 0x6000 }, { 6336, 0x886c },
  /* 0x9800 */
  { 6342, 0x916e }, { 6350, 0x058f }, { 6357, 0x3012 }, { 6361, 0x3990 },
  { 6367, 0xf840 }, { 6373, 0x4930 }, { 6378, 0x8880 }, { 6381, 0x001b },
  { 6385, 0x0000 }, { 6385, 0x0000 }, { 6385, 0x8500 }, { 6388, 0x0042 },
  { 6390, 0x0058 }, { 6393, 0x9800 }, { 6396, 0xea04 }, { 6402, 0x7014 },
  /* 0x9900 */
  { 6407, 0x1628 }, { 6412, 0x611d }, { 6419, 0x5113 }, { 6425, 0x6000 },
  { 6427, 0x1a24 }, { 6432, 0x00a7 }, { 6437, 0x0000 }, { 6437, 0x0000 },
  { 6437, 0x0000 }, { 6437, 0x03c0 }, { 6441, 0x7120 }, { 6446, 0x1018 },
  { 6449, 0x0172 }, { 6454, 0xa927 }, { 6462, 0x6004 }, { 6465, 0x8906 },
  /* 0x9a00 */
  { 6470, 0xc022 }, { 6474, 0x020c }, { 6477, 0x0900 }, { 6479, 0x4081 },
  { 6482, 0x202d }, { 6487, 0x8ca0 }, { 6492, 0x0e34 }, { 6498, 0x0000 },
  { 6498, 0x0000 }, { 6498, 0x0000 }, { 6498, 0x2100 }, { 6500, 0x1101 },
  { 6503, 0x8011 }, { 6506, 0xc11a }, { 6512, 0xec4c }, { 6520, 0x0892 },
  /* 0x9b00 */
  { 6524, 0x0040 }, { 6525, 0x8500 }, { 6528, 0xc7ac }, { 6537, 0x1806 },
  { 6541, 0xe03e }, { 6549, 0x0512 }, { 6553, 0x8000 }, { 6554, 0x0010 },
  { 6555, 0x4008 }, { 6557, 0x80ce }, { 6563, 0x6d01 }, { 6569, 0x0210 },
  { 6571, 0x8641 }, { 6576, 0x0856 }, { 6581, 0x011e }, { 6586, 0x0027 },
  /* 0x9c00 */
  { 6590, 0x3750 }, { 6597, 0x083d }, { 6603, 0xe032 }, { 6609, 0x4e05 },
  { 6615, 0x01c0 }, { 6618, 0x0484 }, { 6621, 0x0081 }, { 6623, 0x0140 },
  { 6625, 0x0000 }, { 6625, 0x0000 }, { 6625, 0x0000 }, { 6625, 0x0000 },
  { 6625, 0x0000 }, { 6625, 0x0000 }, { 6625, 0x1aa0 }, { 6630, 0x0059 },
  /* 0x9d00 */
  { 6634, 0x43c8 }, { 6640, 0x8824 }, { 6644, 0x1d48 }, { 6650, 0xc800 },
  { 6653, 0x0152 }, { 6657, 0x7203 }, { 6663, 0x9013 }, { 6668, 0x0404 },
  { 6670, 0x8280 }, { 6673, 0x0400 }, { 6674, 0x8a10 }, { 6678, 0x0d14 },
  { 6683, 0x8056 }, { 6688, 0x0208 }, { 6690, 0xa040 }, { 6693, 0x2704 },
  /* 0x9e00 */
  { 6698, 0x0000 }, { 6698, 0x4c00 }, { 6701, 0x0000 }, { 6701, 0x0000 },
  { 6701, 0x0000 }, { 6701, 0x0000 }, { 6701, 0x0000 }, { 6701, 0xa320 },
  { 6706, 0x1902 }, { 6710, 0xa0ae }, { 6717, 0x2660 }, { 6722, 0xdf00 },
  { 6729, 0xf010 }, { 6734, 0x7b15 }, { 6743, 0x8121 }, { 6747, 0x3ad0 },
  /* 0x9f00 */
  { 6754, 0x4180 }, { 6757, 0x0028 }, { 6759, 0x1003 }, { 6762, 0x4800 },
  { 6764, 0xcc00 }, { 6768, 0x8014 }, { 6771, 0x14cf }, { 6779, 0x00c4 },
  { 6782, 0x2000 }, { 6783, 0x3020 }, { 6786, 0x0001 },
};
static const Summary16 jisx0208_uni2indx_pageff[15] = {
  /* 0xff00 */
  { 6787, 0xdf7a }, { 6799, 0xffff }, { 6815, 0xffff }, { 6831, 0xffff },
  { 6847, 0xffff }, { 6863, 0x3fff }, { 6877, 0x0000 }, { 6877, 0x0000 },
  { 6877, 0x0000 }, { 6877, 0x0000 }, { 6877, 0x0000 }, { 6877, 0x0000 },
  { 6877, 0x0000 }, { 6877, 0x0000 }, { 6877, 0x0028 },
};

SInt convertMbToWc4Jisx0208( void   * aSrc,
                             SInt     aSrcRemain,
                             void   * aDest,
                             SInt     /* aDestRemain */ )
{
/***********************************************************************
 *
 * Description :
 *      (EUCJP, SHIFT-JIS) ==> UTF16BE  Ǵ ȯ
 *
 * Implementation :
 *
 ***********************************************************************/

    UChar   * sSrcCharPtr;
    SInt      sRet;
    UInt      i;
    UShort    wc;

    sSrcCharPtr = (UChar *)aSrc;

    if( ((sSrcCharPtr[0] >= 0x21) && (sSrcCharPtr[0] <= 0x28)) || 
        ((sSrcCharPtr[0] >= 0x30) && (sSrcCharPtr[0] <= 0x74)) )
    {
        if( aSrcRemain >= 2 ) 
        {
            if( (sSrcCharPtr[1] >= 0x21) && (sSrcCharPtr[1] < 0x7f) )
            {
                i = 94 * (sSrcCharPtr[0] - 0x21) + (sSrcCharPtr[1] - 0x21);
                wc = 0xfffd;

                if (i < 1410) 
                {
                    if (i < 690)
                    {
                        wc = jisx0208_2uni_page21[i] ^ JISX0208_XOR_VALUE;
                    }
                    else
                    {
                        // Nothing to do
                    }
                }
                else
                {
                    if(i < 7808)
                    {
                        wc = jisx0208_2uni_page30[i-1410] ^ JISX0208_XOR_VALUE;
                    }
                    else
                    {
                        // Nothing to do
                    }
                }

                if(wc != 0xfffd)
                {
                    WC_TO_UTF16BE( aDest, wc );
                    
                    sRet = 2;
                }
                else
                {
                    sRet = RET_ILSEQ;
                }
            }
            else
            {
                sRet = RET_ILSEQ;
            }
        }
        else
        {
            sRet = RET_TOOFEW;
        }
    }
    else
    {
        sRet = RET_ILSEQ;
    }

    return sRet;
}

SInt convertWcToMb4Jisx0208( void   * aSrc,
                             SInt     /* aSrcRemain */,
                             void   * aDest,
                             SInt     aDestRemain )
{
/***********************************************************************
 *
 * Description :
 *      (EUCJP, SHIFT-JIS) <== UTF16  Ǵ ȯ
 *
 * Implementation :
 *
 ***********************************************************************/

    const Summary16   * sSummary = NULL;
    UShort        sUsed;
    UChar       * sDestCharPtr;
    SInt          sRet;
    UShort        c;
    UInt          i;
    UShort        wc;

    sDestCharPtr = (UChar *)aDest;

    UTF16BE_TO_WC( wc, aSrc );
    
    if( aDestRemain >= 2 )
    {
        if( wc < 0x0100 )
        {
            sSummary = &jisx0208_uni2indx_page00[(wc>>4)];
        }
        else if(wc >= 0x0300 && wc < 0x0460)
        {
            sSummary = &jisx0208_uni2indx_page03[(wc>>4)-0x030];
        }
        else if (wc >= 0x2000 && wc < 0x2320)
        {
            sSummary = &jisx0208_uni2indx_page20[(wc>>4)-0x200];
        }
        else if (wc >= 0x2500 && wc < 0x2670)
        {
            sSummary = &jisx0208_uni2indx_page25[(wc>>4)-0x250];
        }
        else if (wc >= 0x3000 && wc < 0x3100)
        {
            sSummary = &jisx0208_uni2indx_page30[(wc>>4)-0x300];
        }
        else if (wc >= 0x4e00 && wc < 0x9fb0)
        {
            sSummary = &jisx0208_uni2indx_page4e[(wc>>4)-0x4e0];
        }
        else if (wc >= 0xff00 && wc < 0xfff0)
        {
            sSummary = &jisx0208_uni2indx_pageff[(wc>>4)-0xff0];
        }
        else
        {
            // Nothing to do
        }

        if( sSummary != NULL )
        {
            sUsed = sSummary->used;

            i = wc & 0x0f;

            if( sUsed & ((UShort) 1 << i) )
            {
                /* Keep in `sUsed' only the bits 0..i-1. */
                sUsed &= ((UShort) 1 << i) - 1;

                /* Add `sSummary->indx' and the number of bits set in `sUsed'.*/
                sUsed = (sUsed & 0x5555) + ((sUsed & 0xaaaa) >> 1);
                sUsed = (sUsed & 0x3333) + ((sUsed & 0xcccc) >> 2);
                sUsed = (sUsed & 0x0f0f) + ((sUsed & 0xf0f0) >> 4);
                sUsed = (sUsed & 0x00ff) + (sUsed >> 8);

                c = jisx0208_2charset[sSummary->indx + sUsed] ^ JISX0208_XOR_VALUE;

                sDestCharPtr[0] = (c >> 8); 
                sDestCharPtr[1] = (c & 0xff);

                sRet = 2;
            }
            else
            {
                sRet = RET_ILUNI;
            }
        }
        else
        {
            sRet = RET_ILUNI;
        }
    }
    else
    {
        sRet = RET_TOOSMALL;
    }

    return sRet;
}
 
