/***********************************************************************
 * Copyright 1999-2000, RTBase Corporation or its subsidiaries.
 * All rights reserved.
 **********************************************************************/

/***********************************************************************
 * $Id: iduCompression.cpp 66405 2014-08-13 07:15:26Z djin $
 **********************************************************************/



/***********************************************************************
 *  ڵ忡   (doc-30624)    ִ.
 **********************************************************************/

/***********************************************************************
 *
 *  :
 *
 * literal  =  ġ ʴ ڿ
 * match    =  ġǴ ڿ, offset, length ǥõȴ.
 *           offset ũ⿡  m2, m3, m4 match  .
 *       =        Ǿ Ÿ 
 *            literal match ϰ,   ƹ  Ǿ 
 *            Ÿ  Ḧ ǥϴ   ִ.
 * offset   = match ̴ ,   ġ ġ  ܾ ġ
 *            ̸ Ÿ.
 * len Ǵ length = match ̴ , ġ ܾ ̸ Ÿ.
 **********************************************************************/


/***********************************************************************
 *  ˰ 
 *
 *  ܾ  ̹  ܾ  ܾ  ʰ  ġ 󸶳
 *  matchϴ   Ÿ. ⿡  Ͼ.
 * ̶   ܾ͵ ġ ʴ ܾ literal̶ ϰ,  ܾ
 * ġǴ ܾ match Ѵ.
 * ⺻ 3byte̻ ܾ match  match ȴ.
 *   match ̴  ũ ε   ũⰡ 2byte matchǴ
 *  2byte   ظ   ð Һϰ ȴ.
 *   ˰򿡼 ġ  Ǵ  ٰų  ʴ´. 
 * literal    ְ, literal    ʱ 
 * literal  ŭ 尡 ǰ ȴ.
 * ġ   offset, 󸶳 ġǴ   ִ.
 *
 * literal  byte literal   Ÿ ִ. 
 * literal   literal  ʴ´.
 *  match  match   ִ.
 **********************************************************************/


/***********************************************************************
 *   
 *
 * ϴ  ó literal ´.  literal   match ´.
 * matchĿ ٸ match   ְ literal   ִ.  literal
 *    ְ match   ִ.    Ŀ   ´.
 **********************************************************************/

/***********************************************************************
 *     srcBuf : aaaa bbbb cccc dddd aaaa bbbb cccc ....
 * [ؽ̺]        ^ġ
 * [        ]
 * [        ]
 * [        ]
 * [        ]
 * [        ]
 * [        ]
 *
 * ⼭ ؽ̺ ӽ÷ ̴ ڷᱸ̴.  ؽ̺ srcBuf  
 *   ִ. , ؽ ̺ 뵵 ġǴ  ܾ  srcBuf
 *  ġ ִ ϱ  ̴ ̴.  ̰ ġ Ÿ
 * ʴ´. װ  ̺    ϸ   ִ.
 * ,   Ͽ   ʾƵ  ġ  ƴ϶     
 * ִ. ؽ̺ Ű ġ 4 data  xor ̿Ͽ Ѵ.
 *  Ű ̿Ͽ ؽ̺ ° ε   ε  ˾  ִ.
 *  װ  Ͱ ְ,  ͸  Ͽ   ڷᰡ 
 *   ڷ 3Ʈ ̻ ġ , match ϰ ȴ.
 *  match  ,  Ű  ؽ̺  ġ()
 * ϰ ȴ.
 * , hashTable[index(ġ[0-3])] = ġ
 * ̰ literal Ǵ ̴.  literal   Ѳ 
 * ϹǷ, literal   ʰ, ġ ̵ϰ ȴ.
 * ߿ match Ͼ ׶ ݱ Ƶξ literal Ѳ Եȴ.
 * ׷  literal  ̾  ʴ´.
 **********************************************************************/


/***********************************************************************
 *  )
 *
 * srcBuf:  Ϸϴ 
 * aaaa bbbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *
 * destBuf:   Ÿ 
 * [L 6]aaaa b[M offset= 1 len= 3][L 7] cccc d[M offset= 1 len= 3][L 5] aaaa
 * [M offset= 20 len= 16][L 2]zz[M offset= 20 len= 5][L 17]cds sdlkajsfd aa
 *
 * : ⼭ L literal Ÿ, M MATCH Ÿ.
 * ó ġ ̷     ϰڴ.
 *
 *
 * 1. ó ġ +4 ġ ϰ ȴ.
 * ,
 *
 * aaaa bbbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *     ^ġ
 *
 * ̶, " bbb"  ؽ Ű(index) Ѵ. ׷  7̶  Դٰ ϸ,
 *
 *  ܾ <= hashtable[index];
 * if ܾ[0~2] == ġ[0~2] then
 *      goto match;
 * else
 *      hashtable[index] <= ġ
 *
 * ̷  ġ ȴ. hashtable ƹ    ̹Ƿ, else
 *  ȴ. , hashTable[7] <= ġ
 *
 * ׷  ġ++, ,
 * aaaa bbbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *      ^ġ
 * ̰ Ű ȴ.
 *
 *
 *
 * 2. "bbbb" Ű Ѵ. 9 Դٰ .   ļ
 *      hashTable[7] <= ġ  ǰ ġ++ ȴ.
 * aaaa bbbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *       ^ġ
 *
 *
 *
 * 3. "bbb " Ű Ѵ. ̰ 9 Դ. 9 ٷ    ̴.
 *     ּҿ  ּҿ ̴ 1̴.    
 *    bbbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *     
 *    bbb cccc dddd aaaa bbbb cccc dddd zzaa bbcds sdlkajsfd aa
 *    ̹Ƿ    3 matchϰ ȴ.
 *    ׷ offset=1, len=3  match ̰Եȴ.
 *     match ̱  ʰ ׳ ġ ̵ ״ literal
 *       Բ match  ̰ ȴ.
 *    , ̶ Ǵ 
 *
 *    [L 6]aaaa b[M offset= 1 len= 3]   ̵ȴ.
 *
 * 4. ,   ϰ ȴ.
 *
 *
 *
 * )
 * 1.  [L 6]aaaa b[M offset= 1 len= 3]    Ҷ, 켱 ù Ʈ о
 *     ̰ literal̰,  6  ˾Ƴ. ׷  6 ״
 *     ۿ .
 *     ,
 *     destBuf "aaaa b" ̰Եȴ.
 *
 *
 * 2.  srcBuf   κ "[M offset= 1 len= 3]" κ Ѿ.
 *     offset 1̹Ƿ ' ġ-1' ġ 3ŭ  ġ ϸ ȴ.
 *       ϸ ' ġ-1'+3    ̶   ִ.
 *       source target    ϶.
 *     , 簡 Ǹ鼭
 *     "aaaa b"          "aaaa b"
 *            ^ġ         ^ġ-1
 *     "aaaa bb"         "aaaa bb"
 *            ^ġ         ^ġ-1
 *     "aaaa bbb"        "aaaa bbb"
 *            ^ġ         ^ġ-1
 *     "aaaa bbbb"       "aaaa bbbb"
 *            ^ġ         ^ġ-1
 *     , ڽ 簡 Ǹ鼭 Ŀ ǰ ̰ ٷ source ð Ŀ Ǵ°̴.
 *     ̰  簡 Ǳ   ̴.
 **********************************************************************/

/***********************************************************************
 *   (ù 1byte bit  Ÿ )
 * literal => 0000xxxx (0 1bit 0 Ǿ ,
 *                      x 1bit 0Ǵ 1,   ٴ don't care Ÿ.
 * match   => xxxxxxxx (̶  4bit  0  literal ̱  match
 *                       ܵȴ.)
 *
 *   => xxxxxxxx    ϴ  literal ̴.   literalε
 *              match .  ׷ٸ ̰  Ǵ  ִ°?
 *               ù byte  ȴ.  ̰   Ļ literal
 *             ; ϴ ڸ̴.  ̰  match     
 *            ̰  Ǵ   ִ ̴. literal  matchó ̰ 
 *            ؼ  literal̿ 17    Եȴ.
 *                
 *   => 00010001 00000000 00000000, 3byte Ѵ.  ̶ ù byte match
 *             ϰ ִ.   ڼ  ϸ m4  ϰ ִ.  ׷ 
 *             Ḧ Ǻϴ  m4 óϴ κп ϰԵȴ. m4 
 *            Ͱ °     ̰  Ǻ  ִ.
 *
 *
 * literal  ڼ  (⼭ t   literal  Ѵ.).
 * literal  t ũ⿡    ũⰡ Ѵ.
 * t<=3     ̰쿡 Ư   ʴ´. literal տ ݵ match
 *           ȴ. ġ Ư κп    ϰԵȴ.  literal
 *          3  쿡   尡  ʴ´.
 * t<=18    0000xxxx ̶ 4bit t-3  Ѵ.     ' + 3'
 *             literal ̸   ִ.
 * 18 < t   00000000 .... xxxxxxxx 18 ū 쿡 ù   0 ä  
 *          κп t-18   ȴ.  ̶  t-18> 255 쿡   
 *          1byte   .  00000000 ߰ϰ t ߰ 255  .
 *          ̷   ˰ ݿ δ.
 *
 *
 * match  ڼ 
 *
 * m2 => offset M2_MAX_OFFSET , length M2_MAX_LEN   .
 *       xxxxxx00 xxxxxxxx => ù Ʈ  3bit len ǥϴµ δ. ̶
 *       len-1  ´. ֳϸ, m2 쿡  ù byte ׻ 64̸̻鼭
 *       3bit 8 ǥ   ̴. match length  3̻̱  m2
 *       ׻ 64̻ ȴ.
 *       ù Ʈ ״ 3bit offset  3Ʈ ǥϰ, ״ Ʈ 
 *       offset  8bit ǥϴµ δ.
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [0]  [0]
 *       |           |  |           |
 *       +-- len-1 --+  +-offset-+
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [x]  [x]
 *       |                                    |
 *       +---       offset          -------+
 *
 *       ù Ʈ  2bit '3   Ǵ literal' ǥϴµ δ.
 *         ġ  2bit     ְ, ̰   뵵 δ.
 *
 *
 * m3 => offset M2_MAX_OFFSET  Ǵ,
 *       offset M3_MAX_OFFSET 쿡   .
 *         001 ϱ  ù  32 64   ȴ.
 *
 *       [0]  [0]  [1]  [0]  [0]  [x]  [x]  [x]
 *                  |   |                    |
 *                  |   +---    len -2  -----+
 *                M3_MARKER
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [0]  [0]
 *       |                          |
 *       +--- offset  6bit ------+
 *
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [0]  [0]
 *       |                                   |
 *       +--- offset  8bit ---------------+
 *
 *        len   ǥ    ŭ ٸ 5bit  0 ä
 *       1byte   ߰Ѵ.   ̰Ϳõ ǥ   ٸ  0 ä
 *       ̿ 255   ٽ ϳ  ߰ Ѵ.  ̿  ۾ ǥ
 *           Ѵ.
 *
 * m4 => offset M3_MAX_OFFSET ̸̻鼭 M4_MAX_OFFSET   
 *
 *      [0]  [0]  [0]  [1]  [x]  [x]  [x]  [x]
 *                      |        |           |
 *                      |        +- len -2  -+
 *                  M4_MARKER
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [0]  [0]
 *       |                          |
 *       +--- offset  6bit ------+
 *
 *
 *       [x]  [x]  [x]  [x]  [x]  [x]  [0]  [0]
 *       |                                   |
 *       +--- offset  8bit ---------------+
 *
 *
 *      M4_MAX_OFFSET =>  1011 1111 1111 1111
 *                      - 0100 0000 0000 0000 ( M3_MAX_OFFSET )
 *                      = 0111 1111 1111 1111
 *      m4 offset    Ѵ.  ̶  14 bit m3   ǥ
 *      ϰ, ֻ 1bit ù° Ʈ M4_MARKER ٷ  Ʈ Էϰ ȴ.
 **********************************************************************/

#include <idl.h>
#include <ide.h>
#include <idu.h>
#include <iduCompression.h>

#if defined(WRS_VXWORKS)
#undef m_len
#endif

#define COMPRESSION_BYTE(x)       ((UChar) ((x) & 0xff))

#define PTR(a)              ((vULong) (a))
#define PTR_LT(a,b)         (PTR(a) < PTR(b))
#define PTR_DIFF(a,b)       ((vULong) (PTR(a) - PTR(b)))
//pd:  ּҰ ̸ ϴ ũ Լ
#define pd(a,b)             PTR_DIFF(a,b)//((UInt) ((a)-(b)))

//m1  ʴ´.
#define M1_MAX_OFFSET   0x0400

/***********************************************************************
 *  offset    .  ̶ m2  2byte ϰ
 * m3, m4  3byte ̴̻.
 * m2 offset 0x0800,  8 ġ̰, ̰ Ȯ 2byte
 * Ѵ.  m2 ִ   ִ  1:4̴.
 * m3, m4 offset  , ̵ ġǴ ̴   ʴ. 
 * ġǴ ̰  ,  255 1byte   ٰ ȴ.
 **********************************************************************/
#define M2_MAX_OFFSET   0x0800
#define M3_MAX_OFFSET   0x4000
#define M4_MAX_OFFSET   0xbfff

#define M2_MIN_LEN      3
#define M2_MAX_LEN      8
#define M4_MIN_LEN      3
#define M4_MAX_LEN      9

// m3 m4 ϱ  Ʈ
#define M3_MARKER       32
#define M4_MARKER       16

/***********************************************************************
 * Ʒ 6 ũ Լ  ؽ Ű ϱ  ͵̴.
 * DX2, DX3  2byte, 3byte ӵ byte xor   Լ̴.
 * DMS, DM Ư Ʈ   Լ̴.
 * D_INDEX1  1 ؽ  Լ, D_INDEX2 2 ؽ  Լ̴.
 * ⼭ D_INDEX1  0,1,2° Ʈ ؽŰ    ġ
 * 3° byte ׸ ū  ġ ʴ´.
 * ̰  ؽŰ Կ ־ 3 ġ ַ ϰ,  byte
 *  ġ ͵ ƴϰ  ȹġ°͵ ƴϴ.
 *
 **********************************************************************/
#define DX2(p,s1,s2)                                            \
 	(((((UInt)((p)[2]) << (s2)) ^ (p)[1]) << (s1)) ^ (p)[0])
#define DX3(p,s1,s2,s3) ((DX2((p)+1,s2,s3) << (s1)) ^ (p)[0])
#define DMS(v,s)        ((UInt) (((v) & (IDU_COMPRESSION_D_MASK >> (s))) << (s)))
#define DM(v)           DMS(v,0)

#define D_INDEX1(d,p)       d = DM((0x21*DX3(p,5,5,6)) >> 5)
#define D_INDEX2(d,p)       d = (d & (IDU_COMPRESSION_D_MASK & 0x7ff)) ^ (IDU_COMPRESSION_D_HIGH | 0x1f)


/***********************************************************************
 *   ؽ Ű 缺 ˻Ѵ.
 * ̺κ ../include/iduCompression.h  'workMem ʱȭ ʿѰ?' ڼ Ǿ ִ.
 *  κ п workMem ʱȭ ʿ .
 **********************************************************************/
#define COMPRESSION_CHECK_MPOS_NON_DET(m_pos,m_off,in,ip,max_offset)        \
    (m_pos = ip - (UInt) PTR_DIFF(ip,m_pos), PTR_LT(m_pos,in) ||    \
	 (m_off = (UInt) PTR_DIFF(ip,m_pos)) <= 0 ||                    \
	 m_off > max_offset)

/***********************************************************************
 *    ּҰ PTR_ALIGNED2_4 Ѵٸ 1byte 縦  ʰ,
 * COPY4 ̿Ͽ 4byte Ѳ 縦    ִ.
 **********************************************************************/
#define COPY4(dst,src)    * (UInt *)(dst) = * ( UInt *)(src)

#define PTR_ALIGNED2_4(a,b) (((PTR(a) | PTR(b)) & 3) == 0)

#define COMPRESSION_E_INPUT_OVERRUN         (-4)
#define COMPRESSION_E_OUTPUT_OVERRUN        (-5)
#define COMPRESSION_E_INPUT_NOT_CONSUMED    (-8)

/***********************************************************************
 *   ũ  
 *
 * 1. match  ũⰡ  ʴ´. (־  1byte ), literal
 * ޾  ʴ´.   ־ ĺ ݵ literal  ϰ, literal
 *  ̵ ǹǷ   match ͼliteral  ־ Ѵ.
 * ׸ ̷  Ȳ ؼ Ͼ Ѵ.
 *
 * 2. ־ ó ĺ 1.
 *    literal 4 ̻   1  ʿ,  match3, ̷ 
 *    ӳ Ȳ
 *    => ᱹ  size ϴ ũ 
 *
 * 3. ־ ó ĺ 2.
 *    literal 19 ̻   2  ʿ,  match 3, ̷ 
 *     ӳ Ȳ
 *    =>  22byte 1 byte
 *
 * 4. ־ ó ĺ 3.
 *    literal 274 ̻   3  ʿ,  match 3 Ȳ,
 *    ̷    Ȳ
 *    =>  277byte 2 byte..  129byte 1byte
 *
 * 5. , ־ ó 2 , 22byte 1 byte.  3bitʿ
 *
 *  max_size(s) = s + ((s/22)+1) + 3 ȴ.
 *
 * PROJ-2010
 *   ߰ߵǾ,  ̻    
 * ˰ ؿ  Ǵ ּ Ǿ ܵд.
 * ߰  length 255 Ǵ offset 255  ̴ 1Ʈ 
 *  Ѵ.
 **********************************************************************/

/***********************************************************************
 * Description :   ϴ κ
 *
 * Ķ ǹ̴ compress  ϴ.
 *
 * Description :     ȣϴ Լ
 *
 * aSrc         - [IN] :   ϰ ϴ ҽ  ִ , ̶  ũ
 *			     ִ.
 *
 * aSrcLen      - [IN] : aSrc 
 *
 * aDest        - [IN] :    ԷµǴ ,   ũ ݵ
 *                       IDU_COMPRESSION_MAX_OUTSIZE(ҽũ)  Ͽ Ѵ.
 *
 * aDestLen     - [IN] : aDest 
 *
 * aResultLen   - [OUT]:   
 * aWorkMem     - [IN] :  ؽ̺  ޸𸮸  ־  Ų.
 *                       ̶  IDU_COMPRESSION_WORK_SIZEũ ޸𸮸 Ѵ.
 *
 **********************************************************************/
UInt iduCompression::compressInternal(  UChar *aSrcBuf ,
                                        UInt   aSrcLen,
                                        UChar *aDestBuf,
                                        UInt   /*aDestLen*/,
                                        UInt*  aResultLen,
                                        void*  aWorkMem )
{
    UChar  *sSrcPtr      = aSrcBuf;
    UChar  *sSrcRealEnd  = aSrcBuf + aSrcLen;

    /***********************************************************************
     * ⼭ M2_MAX_LEN ϴ  Ʒ Ǿ ִ.
     **********************************************************************/
    UChar  *sSrcShortEnd = aSrcBuf + aSrcLen - M2_MAX_LEN - 5;
    UChar  *sSrcCalcPtr  = aSrcBuf;

    UChar  *sDestPtr     = aDestBuf;

    //sDict aWorkMem ͸ ϴ ؽ ̺ .
    UChar **sDict        = (UChar **) aWorkMem;

    sSrcPtr += 4;

    for (;;)
    {
        register  UChar *m_pos;
        UInt m_off;
        UInt m_len;
        UInt dindex;

        // sSrcPtr[0~3] ؽŰ   ̰ dindex 
        D_INDEX1(dindex, sSrcPtr);

        m_pos = sDict[dindex];

        //  dindex 缺 ˻ϴ κ, ڼ  ../include/iduCompression.h
        //'aWorkMem ʱȭ ʿ ' κ 
        if (COMPRESSION_CHECK_MPOS_NON_DET(m_pos,m_off,aSrcBuf,sSrcPtr,M4_MAX_OFFSET))
            goto literal;

        /***********************************************************************
         * Ʒ  ǵ match  ּ 1byte  ڴ ̴.
         *  ()ϴ ⺻ match 3byte ¾ƾ ̷ .
         * Ʒ  ϱ ؼ , ϱ ؼ
         * 1. M2 offset̴. (̰쿡 ũⰡ 2bytḛ, ּ match 3byte̹Ƿ
         *    ּ 1byte ̴.)
         * 2. M3 Ǵ M4 offset̴. (̰쿡 ũⰡ 3bytḛ, ּ match
         *    4byte϶ Ʒ  ϰ ȴ.
         *
         * , M2_MAX_OFFSET ̰ų 4 ġ    ΰ  ϳ ϸ  ΰ
         *   ο  ʴ°ͺ ּ 1byte     ִ.
         *     ٰ ӵ  ŭ   ְ,  destBuf
         *   ִ ũ⸦ ̰Ϳ ؼ ϹǷ ̹  ʴ  .
         **********************************************************************/
        if ( (m_off <= M2_MAX_OFFSET) || (m_pos[3] == sSrcPtr[3]))
            goto try_match;

        /* 2 ؽ  */
        D_INDEX2(dindex,sSrcPtr);

        m_pos = sDict[dindex];

        if (COMPRESSION_CHECK_MPOS_NON_DET(m_pos,m_off,aSrcBuf,sSrcPtr,M4_MAX_OFFSET))
            goto literal;

        if ((m_off <= M2_MAX_OFFSET) || (m_pos[3] == sSrcPtr[3]))
            goto try_match;

        goto literal;

      try_match:
        //  ̰  3byte ġǴ 캻. ׷   literal Ѵ.
        if ((m_pos[0] == sSrcPtr[0]) && (m_pos[1] == sSrcPtr[1]) && (m_pos[2] == sSrcPtr[2]))
        {
            goto match;
        }

        //  literal 쿣   ʰ  ͸ ̵Ѵ.
      literal:
        // ؽ̺    ٲ۴.
        sDict[dindex] = sSrcPtr;

        ++sSrcPtr;
        if (sSrcPtr >= sSrcShortEnd)
            break;
        continue;


        /***********************************************************************
         *		LITERAL COMPRESS
         *   destBuf ʰ,   ͸  ϰ, ̺κп 
         * destBuf  ȴ.  ̶  տ  ް,    ̸ŭ
         * literal srcBuf  Ѵ.
         *
         *
         * literal     
         * 0x08		=> 8+3		=> 11
         * 0x00 0x08	=> 18+8+3	=> 26
         * 0x00 0x00 0x01 => 18+255+1	=> ...
         *
         **********************************************************************/
      match:
        sDict[dindex] = sSrcPtr;
        if (pd(sSrcPtr,sSrcCalcPtr) > 0)
        {
            register UInt t = pd(sSrcPtr,sSrcCalcPtr);

            /***********************************************************************
             * t<=3  쿣   literal   ʴ´.
             * ׷  3  ǥϱ  match  2° byte  
             *  Ѵ. match  2° byte  2bit  literal ̸
             * ǥ  ֵ ׻  ִ.
             **********************************************************************/
            if (t <= 3)
            {
                //  2byte ݵ ȿ  Ѵ.
                IDE_ASSERT(sDestPtr - 2 > aDestBuf);
                sDestPtr[-2] |= COMPRESSION_BYTE(t);
            }
            else
            {
                /* literal  쿣  4bit 0 ؾ ϱ  18  3 Ѵ.*/
                if (t <= 18)
                {
                    *sDestPtr++ = COMPRESSION_BYTE(t - 3);
                }
                else
                {
                    /***********************************************************************
                     * literal ̰ 18 Ѿ    ǥϱ  ߰ ϳ
                     * byte  ʿ Ѵ.
                     * ؼ 255 ̸ ǥϱ ؼ 0   ϳ ߰ ȴ.
                     **********************************************************************/
                    register UInt tt = t - 18;

                    *sDestPtr++ = 0;
                    while (tt > 255)
                    {
                        tt -= 255;
                        *sDestPtr++ = 0;
                    }
                    // tt 1̴̻.ֳϸ, t - 18 ϴµ, t 19̻̱ ̴.
                    //  while   Ǵ  255̻϶, while
                    // 255 ϱ  0   .
                    IDE_ASSERT(tt > 0);
                    *sDestPtr++ = COMPRESSION_BYTE(tt);
                }
            }
            //   κ ̾, Ʒ   literal 縦 Ѵ.
            do
            {
                *sDestPtr++ = *sSrcCalcPtr++;
            } while (--t > 0);
        }

        // ⿡  ͷ   destBuf   Ѵ.
        IDE_ASSERT(sSrcCalcPtr == sSrcPtr);

        /***********************************************************************
         *		MATCH COMPRESS
         * offset     , ׿ ߾ ۼ ϰ, length 
         * ´.
         ***********************************************************************/
        //ּ 3 ̻ ġ   Ȯ ϿǷ
        sSrcPtr += 3;

        /***********************************************************************
         *  8 match Ȯ Ѵ. ̶  checkϴ   ѹ  
         *  checkϱ , ÷ΰ ߻ ɼ ִ. ׷  
         *  M2_MAX_LEN  Ѵ.
         ***********************************************************************/
        if (m_pos[3] != *sSrcPtr++ ||
            m_pos[4] != *sSrcPtr++ ||
            m_pos[5] != *sSrcPtr++ ||
            m_pos[6] != *sSrcPtr++ ||
            m_pos[7] != *sSrcPtr++ ||
            m_pos[8] != *sSrcPtr++
            )
        {
            --sSrcPtr;
            m_len = sSrcPtr - sSrcCalcPtr;

            // ּ 3 ̻ ġ Ȯ Ͽ.
            IDE_ASSERT(m_len >= 3);
            // M2_MAX_LEN ̻̾ٸ ̰ б ʾҴ.
            IDE_ASSERT(m_len <= M2_MAX_LEN);

            //m2 match  ۼϴ κ
            if (m_off <= M2_MAX_OFFSET)
            {
                m_off -= 1;
                //ù 1byte  , ̿ offset .
                *sDestPtr++ = COMPRESSION_BYTE(((m_len - 1) << 5) | ((m_off & 7) << 2));
                // byte  ,
                *sDestPtr++ = COMPRESSION_BYTE(m_off >> 3);
            }
            // m3 match  ۼϴ κ
            else if (m_off <= M3_MAX_OFFSET)
            {
                m_off -= 1;
                //⼭   ù byte .
                *sDestPtr++ = COMPRESSION_BYTE(M3_MARKER | (m_len - 2));
                goto m3_m4_offset;
            }
            // m4 match  ۼϴ κ
            else
            {
                //m4 offset M3_MAX_OFFSET .
                m_off -= 0x4000;
                IDE_ASSERT(m_off > 0); IDE_ASSERT(m_off <= 0x7fff);

                //m4 marker , offset  Է, ̶ offset ֻ bit
                //ù  Ư  Ѵ.  m4  
                *sDestPtr++ = COMPRESSION_BYTE(M4_MARKER |
                                               ((m_off & 0x4000) >> 11) | (m_len - 2));
                goto m3_m4_offset;
            }
        }

        /***********************************************************************
         *  9 ̻ ġ    ׻  Ѿ üũ ϸ鼭 Ѵ.
         *  ̶   Ѵ.
         ***********************************************************************/
        else
        {
            //   Ѿ Ȯ ϸ鼭  ġǴ ȮѴ.
            {
                UChar *end = sSrcRealEnd;
                UChar *m = m_pos + M2_MAX_LEN + 1;
                while (sSrcPtr < end && *m == *sSrcPtr)
                    m++, sSrcPtr++;
                m_len = pd(sSrcPtr, sSrcCalcPtr);
            }

            // m_len M2_MAX_LEN ٸ ̰ б ʾ ̴.
            IDE_ASSERT(m_len > M2_MAX_LEN);

            // m3 match ۼ
            if (m_off <= M3_MAX_OFFSET)
            {
                m_off -= 1;
                if (m_len <= 33)
                {
                    *sDestPtr++ = COMPRESSION_BYTE(M3_MARKER | (m_len - 2));
                }
                else
                {
                    m_len -= 33;
                    *sDestPtr++ = M3_MARKER | 0;
                    //  ù Ʈ  ǥ      0 set 
                    // Ʈ   ǥѴ.
                    goto m3_m4_len;
                }
            }
            else
            {
                // m4 match  ۼ,
                m_off -= 0x4000;
                IDE_ASSERT(m_off > 0); IDE_ASSERT(m_off <= 0x7fff);

                // m4 max len̶ 9 Ѵ.  9 ù Ʈ    ǥ  
                // ̻ 쿡  ÷  Ʈ   ǥѴ.
                if (m_len <= M4_MAX_LEN)
                {
                    IDE_ASSERT(m_len == M4_MAX_LEN);
                    *sDestPtr++ = COMPRESSION_BYTE(M4_MARKER |
                                                   ((m_off & 0x4000) >> 11) | (m_len - 2));
                }

                //  ÷     ǥ
                else
                {
                    m_len -= M4_MAX_LEN;
                    *sDestPtr++ = COMPRESSION_BYTE(M4_MARKER | ((m_off & 0x4000) >> 11));

                    /***********************************************************************
                     *  m3   33ʰ, m4   9ʰ   ߰ ϳ  Ͽ
                     *  ̸ ǥѴ. ̶ literal  255 ϳ  ߰Ͽ 
                     *  ǥѴ.
                     ***********************************************************************/
                  m3_m4_len:
                    while (m_len > 255)
                    {
                        m_len -= 255;
                        *sDestPtr++ = 0;
                    }
                    IDE_ASSERT(m_len > 0);
                    *sDestPtr++ = COMPRESSION_BYTE(m_len);
                }
            }


            /***********************************************************************
             *  m3 m4 offset    ִ.
             *  ̶ m4 offset 1bit պκп Ҵ ϰ,  offset M3_MAX_OFFSET
             *    ǥ ϹǷ, m3 ũ m3 ǥ   ִ κк 2  
             *  offset ǥ   ִ.
             ***********************************************************************/
          m3_m4_offset:
            *sDestPtr++ = COMPRESSION_BYTE((m_off & 63) << 2);
            *sDestPtr++ = COMPRESSION_BYTE(m_off >> 6);
        }

        sSrcCalcPtr = sSrcPtr;
        if (sSrcPtr >= sSrcShortEnd)
            break;
    }

    *aResultLen = pd(sDestPtr, aDestBuf);
    return pd(sSrcRealEnd, sSrcCalcPtr);
}

/***********************************************************************
 * Description :     ȣϴ Լ
 *
 * aSrc         - [IN] :   ϰ ϴ ҽ  ִ , ̶  ũ
 *			     ִ.
 *
 * aSrcLen      - [IN] : aSrc 
 *
 * aDest        - [IN] :    ԷµǴ ,   ũ ݵ
 *                       IDU_COMPRESSION_MAX_OUTSIZE(ҽũ)  Ͽ Ѵ.
 *
 * aDestLen     - [IN] : aDest 
 *
 * aResultLen   - [OUT]:   
 * aWorkMem     - [IN] :  ؽ̺  ޸𸮸  ־  Ų.
 *                       ̶  IDU_COMPRESSION_WORK_SIZEũ ޸𸮸 Ѵ.
 *
 **********************************************************************/
IDE_RC iduCompression::compress   (  UChar   *aSrcBuf ,
                                     UInt     aSrcLen,
                                     UChar   *aDestBuf,
                                     UInt     aDestLen,
                                     UInt    *aResultLen,
                                     void    *aWorkMem )
{
    UChar  *sDestPtr     = aDestBuf;
    UInt sRemains;

    //̰ Ư   ʹ  쿡   ʴ´.
    if (aSrcLen <= M2_MAX_LEN + 5) /* <= 8 + 5 */
    {
        sRemains = aSrcLen;
    }

    else
    {
        /* over 13, so from sizeof 14 byte... */
        sRemains = compressInternal(aSrcBuf,
                                    aSrcLen,
                                    sDestPtr,
                                    aDestLen,
                                    aResultLen,
                                    aWorkMem);

        IDE_TEST_RAISE(aDestLen < *aResultLen, overflow_occurred);

        sDestPtr += *aResultLen;
    }

    /*sRemains 0̶ compressInternal  match  ̴. */
    if (sRemains > 0)
    {
        UChar *sSrcCalcPtr = aSrcBuf + aSrcLen - sRemains;

        /***********************************************************************
         *   238 ۾ƾ ϰ, match Ͼ ʾҾ Ѵ.
         ***********************************************************************/
        if ((sDestPtr == aDestBuf) && (sRemains <= 238))
        {
            //: ̺κ ׻   ó  Ǿ ִ.
            *sDestPtr++ = COMPRESSION_BYTE(17 + sRemains);
        }
        else
        {
            /* Ʒκ compressInternal literal óϴ κа  ϴ. */
            if (sRemains <= 3)
            {
                //compressInternal ó srcPtr 4ĭ ̷  ϱ  ̺κ  ó   .
                sDestPtr[-2] |= COMPRESSION_BYTE(sRemains);
            }
            else
            {
                //̺κ  ó   ְ,  literal   ִ.
                if (sRemains <= 18)
                {
                    *sDestPtr++ = COMPRESSION_BYTE(sRemains - 3);
                }
                else
                {
                    UInt tt = sRemains - 18;

                    *sDestPtr++ = 0;
                    while (tt > 255)
                    {
                        tt -= 255;
                        *sDestPtr++ = 0;
                    }

                    // tt 1̴̻.ֳϸ, t - 18 ϴµ, t 19̻̱ ̴.
                    //  while   Ǵ  255̻϶, while
                    // 255 ϱ  0   .
                    IDE_ASSERT(tt > 0);
                    *sDestPtr++ = COMPRESSION_BYTE(tt);
                }
            }
        }

        do
        {
            *sDestPtr++ = *sSrcCalcPtr++;
        } while (--sRemains > 0);
    }




    // ۼ,  M4_MARKER ǥ
    *sDestPtr++ = M4_MARKER | 1;
    *sDestPtr++ = 0;
    *sDestPtr++ = 0;

    *aResultLen = pd(sDestPtr, aDestBuf);

    return IDE_SUCCESS;

    IDE_EXCEPTION(overflow_occurred);
    {
        //return COMPRESSION_E_OUTPUT_OVERRUN;
        //IDE_SET(ideSetErrorCode(COMPRESSION_E_OUTPUT_OVERRUN));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}


/***********************************************************************
 * Description :    ҽ Ǯ ϴ Լ
 * aSrc         - [IN] :   ִ 
 * aSrcLen      - [IN] : aSrc ũ
 * aDest        - [IN] :     , ̰ ũ compress
 *			  ũ ϴ.   İ ũⰡ  
 * aDestLen     - [IN] : aDest ũ
 * aResultLen   - [OUT]:    ũ
 **********************************************************************/
IDE_RC iduCompression::decompress  (  UChar       *aSrcBuf,
                                      UInt         aSrcLen,
                                      UChar       *aDestBuf,
                                      UInt         aDestLen,
                                      UInt        *aResultLen )
{
    register UChar *sDestPtr;
    register UChar *sSrcPtr;
    register UInt   t;
    register UChar *m_pos;

    UChar *  sSrcRealEnd  = aSrcBuf  + aSrcLen;
    UInt     sInvalidSrcLen;
    UInt     sInvalidDestLen;

    *aResultLen = 0;

    sDestPtr = aDestBuf;
    sSrcPtr = aSrcBuf;

    /***********************************************************************
     *  Ǫµ ־ ٽ ù 1byte       
     * ϴٴ ̴.
     * 64̻           => m2
     * 32̻ 64̸     => m3
     * 16̻ 32̸     => m4
     * 16 ̸          => literal
     * ٸ    ù 1bit 쿣 17̻  Ͽ,  
     * Ÿ  ϳ literal  Ǿ Ǻ   ִ.
     **********************************************************************/
    /*  óϴ κ*/
    if (*sSrcPtr > 17)
    {
        // match  ϱ  17 ϹǷ  ̸ ˱ ؼ
        //־ Ѵ.
        t = *sSrcPtr++ - 17;
        /**********************************************************************
         * Ʒ 忡  t 4  θ  ʿ䰡 . ̺κ  literal
         * 縦   ̱ ̴.
         * ׷  ̰ goto match;  ɹ  Ʒ    ʾƵ .
         * ׷ ұϰ  ʴ    ư α׷̰, ۿ 
         * ġ ʱ ̴. decompress ̷ κ   ִ.
         **********************************************************************/
        if (t < 4)
            goto match_next;

        do
        {
            *sDestPtr++ = *sSrcPtr++;
        } while (--t > 0);

        goto first_literal_run;

    }

    while (1)
    {
        t = *sSrcPtr++;
        if (t >= 16)			// ̰ match Ѵ.
            goto match;


        /***********************************************************************
         *		 LITERAL DECOMPRESSION
         *
         **********************************************************************/
        // literal t, ù Ʈ 0̶  ̰ ̰ ּ 19̻ Ѵ.
        if (t == 0)
        {
            //   0 byte  ´ٸ ̰ 255ŭ ̰  Ǿ  Ѵ.
            while (*sSrcPtr == 0)
            {
                t += 255;
                sSrcPtr++;
            }
            t += 15 + *sSrcPtr++;
        }

        //⼭ t literal ̸ Ѵ.  t 0 ۴ٸ ͷ ٴ ǹ̰ ȴ.
        //ͷ µ    .
        IDE_ASSERT(t > 0);

        // PTR_ALIGNED2_4 ϸ 4byte ϰ ׷  1byte Ѵ.
        if (PTR_ALIGNED2_4(sDestPtr,sSrcPtr))
        {
            COPY4(sDestPtr,sSrcPtr);
            sDestPtr += 4; sSrcPtr += 4;

            // t 0 Ŭ ϰ, ׷  ׸ Ѵ.
            if (--t > 0)
            {
                // t 4 ũٸ COPY4 ϰ, ׷ ʴٸ Ұ
                if (t >= 4)
                {
                    do
                    {
                        COPY4(sDestPtr,sSrcPtr);
                        sDestPtr += 4; sSrcPtr += 4; t -= 4;
                    } while (t >= 4);

                    //  4 COPY4 ϰ, Ʒ 4  ͵ Ʈ  Ѵ.
                    if (t > 0)
                    {
                        do
                        {
                            *sDestPtr++ = *sSrcPtr++;
                        } while (--t > 0);
                    }

                }

                //t 4 ۱  Ʈ  縦 Ѵ.
                else
                {
                    do
                    {
                        *sDestPtr++ = *sSrcPtr++;
                    } while (--t > 0);
                }
            }
        }
        //1byte 
        else
        {
            //3 Ѳ ϸ鼭 t  ʴ    
            //鼭     ̴.
            *sDestPtr++ = *sSrcPtr++;
            *sDestPtr++ = *sSrcPtr++;
            *sDestPtr++ = *sSrcPtr++;
            do
            {
                *sDestPtr++ = *sSrcPtr++;
            } while (--t > 0);
        }

      first_literal_run:

        t = *sSrcPtr++;
        if (t >= 16)
            goto match;

        /***********************************************************************
         *  óϴ κп ̰  Ǵ° ϸ,
         * Ʒ 10   ʴ´ٰ ȴ.
         * ,   ó  ó ϸ ̰  ʴ´.
         * ֳϸ,    ̻ literal   Ǿ ̴.
         *  match  16̻̱  ⿡
         *  帧   ʴ´.
         **********************************************************************/
        m_pos = sDestPtr - (1 + M2_MAX_OFFSET);
        m_pos -= t >> 2;
        m_pos -= *sSrcPtr++ << 2;

        *sDestPtr++ = *m_pos++;
        *sDestPtr++ = *m_pos++;
        *sDestPtr++ = *m_pos;

        goto match_done;

        /***********************************************************************
         *		 MATCH DECOMPRESSION
         **********************************************************************/
        while (1)
        {

          match:
            if (t >= 64)                    // M2 offset
            {
                m_pos = sDestPtr - 1;       // apply low 3 bits
                m_pos -= (t >> 2) & 7;      // apply upper 8 bits
                m_pos -= *sSrcPtr++ << 3;
                t = (t >> 5) - 1;           // delete 1 more from len ( total delete 2 len)
                //t ġ ǹϴµ 0  .
                IDE_ASSERT(t > 0);
                goto copy_match;
            }
            else if (t >= 32)               // M3 offset
            {
                t &= 31;                    // because of it, 't' left only len
                if (t == 0)                 // len > 33
                {
                    while (*sSrcPtr == 0)
                    {
                        t += 255;
                        sSrcPtr++;
                    }
                    t += 31 + *sSrcPtr++;
                }
                m_pos = sDestPtr - 1;
                m_pos -= (sSrcPtr[0] >> 2) + (sSrcPtr[1] << 6);

                sSrcPtr += 2;
            }
            else if (t >= 16)                                   // M4 offset
            {
                m_pos = sDestPtr;
                m_pos -= (t & 8) << 11;                         // offset recovery
                t &= 7;                                         // len recovery
                if (t == 0)
                {
                    while (*sSrcPtr == 0)
                    {
                        t += 255;
                        sSrcPtr++;
                    }
                    t += 7 + *sSrcPtr++;                        // len recovery
                }
                m_pos -= (sSrcPtr[0] >> 2) + (sSrcPtr[1] << 6); //offset recovery
                sSrcPtr += 2;
                if (m_pos == sDestPtr)                          //end detect!!
                    goto eof_found;
                m_pos -= 0x4000;                                // offset recovery
            }
            else
            {
                // ġ  ̻   ̺κ   .
                m_pos = sDestPtr - 1;
                m_pos -= t >> 2;
                m_pos -= *sSrcPtr++ << 2;
                *sDestPtr++ = *m_pos++;
                *sDestPtr++ = *m_pos;
                goto match_done;
            }

            //t ġǴ  Ѵ. ̰ 0   .
            IDE_ASSERT(t > 0);

            //κп t settingϰ ⼭ ¥  
            //COPY4 ּ 2 Ͼ  ʰڴ° ڰ ϴ  .
            if (t >= 2 * 4 - (3 - 1) && PTR_ALIGNED2_4(sDestPtr,m_pos))
            {
                COPY4(sDestPtr,m_pos);

                sDestPtr += 4; m_pos += 4; t -= 4 - (3 - 1);
                do
                {
                    COPY4(sDestPtr,m_pos);
                    sDestPtr += 4; m_pos += 4; t -= 4;
                } while (t >= 4);

                if (t > 0)
                {
                    do
                    {
                        *sDestPtr++ = *m_pos++;
                    } while (--t > 0);
                }

            }
            else
            {
                // do not assign recovery, it will only byte recovery
              copy_match:
                //because so far total delete is 2
                *sDestPtr++ = *m_pos++;
                *sDestPtr++ = *m_pos++;
                do
                {
                    *sDestPtr++ = *m_pos++;
                }while (--t > 0);
            }

            /***********************************************************************
             *  ó κ ϰ literal  ݵ match ְ ȴ.
             *   match ڿ 2° byte  2bit   ִٸ
             * ̰ ̰ 3  literal ̾  Ѵ.
             **********************************************************************/
          match_done:

            t = sSrcPtr[-2] & 3;
            if (t == 0)
                break;

            // which is only for the 't<=3 literal'
          match_next:
            // Ʒ do while ϱ  ݵ t 0 Ŀ Ѵ.
            //  ⿡ ׷ 鸸  Ǿִ.
            IDE_ASSERT(t > 0);
            do
            {
                *sDestPtr++ = *sSrcPtr++;
            }while (--t > 0);
            t = *sSrcPtr++;
        }
    }


  eof_found:
    //̰  üũϸ鼭 ڿ õȴ.  ̰  ؼ   ִ.
    IDE_ASSERT(t == 1);
    *aResultLen = sDestPtr - aDestBuf;

    IDE_TEST_RAISE(sSrcPtr != sSrcRealEnd, size_error);

    return IDE_SUCCESS;

    IDE_EXCEPTION( size_error );
    {
        // BUG-26695 log decompress size ġ Recovery մϴ.

        sInvalidSrcLen  = sSrcPtr  - aSrcBuf;
        sInvalidDestLen = sDestPtr - aDestBuf;

        ideLog::log( IDE_SM_9, // SM_TRC_LOG_LEVEL_MRECOV
                     "Log decompress size is invalid\n"
                     "    Current log size : Comp Src Size %u,"
                     " Decomp Dest Size %u.\n"
                     "    Expected log size : Comp Src Size %u,"
                     " Decomp Dest Size %u.\n",
                     sInvalidSrcLen,
                     sInvalidDestLen,
                     aSrcLen,
                     aDestLen );
    }

#if defined(IDU_COMPRESSION_CHECK_OVERFLOW)
    IDE_EXCEPTION(overflow_occurred);
    {
        //return COMPRESSION_E_OUTPUT_OVERRUN;
        // IDE_SET(ideSetErrorCode(COMPRESSION_E_OUTPUT_OVERRUN));
    }
#endif /* IDU_COMPRESSION_CHECK_OVERFLOW */
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}
