/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: idnConv.h 24174 2007-11-19 01:23:49Z copyrei $
 *
 * Description :
 *     ĳ  ȯ 
 *
 **********************************************************************/

#ifndef _O_IDNCONV_H_
#define _O_IDNCONV_H_ 1

#include <idl.h>
#include <idnCharSet.h>

/* Return code if invalid. (xxx_mbtowc) */
#define RET_ILSEQ      (-1)

/* Return code if only a shift sequence of n bytes was read. (xxx_mbtowc) */
#define RET_TOOFEW     (-2)



/* Return code if invalid. (xxx_wctomb) */
#define RET_ILUNI      (-3)

/* Return code if output buffer is too small. (xxx_wctomb, xxx_reset) */
#define RET_TOOSMALL   (-4)

/* CJK character sets [CCS = coded character set] [CJKV.INF chapter 3] */

/*typedef struct Summary16 {
  UShort indx; // index into big table
  UShort used; // bitmask of used entries
} Summary16; */

// ĳ  ȯ  Լ 
typedef SInt (*charSetConvFunc)( void* aSrc, 
                                 SInt aSrcRemain, 
                                 void* aDest, 
                                 SInt aDestRemain );

typedef struct idnCharSetConvModule
{
    UInt             convPass; // ʿ ȯ Ƚ
    charSetConvFunc  conv1;
    charSetConvFunc  conv2;
} idnCharSetConvModule;

IDE_RC
convertCharSet( idnCharSetList   aSrcCharSet,
                idnCharSetList   aDestCharSet,
                void           * aSrc,
                SInt             aSrcRemain,
                void           * aDest,
                SInt           * aDestRemain,
                SInt             aNlsNcharConvExcp );

// To fix BUG-22699 UTF16 BIG ENDIAN .
//  ũδ  ̳ 񱳰˻ ÿ
// Wide-Char(ǻͰ ˾ƺ  ִ unicode) ʿϹǷ ׶ .

#if defined(ENDIAN_IS_BIG_ENDIAN)

#define UTF16BE_TO_WC(destWC,srcCharPtr)                 \
    do {                                                 \
        ((UChar*)&destWC)[0] = ((UChar*)srcCharPtr)[0];  \
        ((UChar*)&destWC)[1] = ((UChar*)srcCharPtr)[1];  \
    } while(0);

#define WC_TO_UTF16BE(destCharPtr,srcWC)                 \
    do {                                                 \
        ((UChar*)destCharPtr)[0] = ((UChar*)&srcWC)[0];  \
        ((UChar*)destCharPtr)[1] = ((UChar*)&srcWC)[1];  \
    } while(0);

#else

#define UTF16BE_TO_WC(destWC,srcCharPtr)                 \
    do {                                                 \
        ((UChar*)&destWC)[0] = ((UChar*)srcCharPtr)[1];  \
        ((UChar*)&destWC)[1] = ((UChar*)srcCharPtr)[0];  \
    } while(0);

#define WC_TO_UTF16BE(destCharPtr,srcWC)                 \
    do {                                                 \
        ((UChar*)destCharPtr)[0] = ((UChar*)&srcWC)[1];  \
        ((UChar*)destCharPtr)[1] = ((UChar*)&srcWC)[0];  \
    } while(0);

#endif

#endif /* _O_IDNCONV_H_ */
 
