/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/***********************************************************************
 * $Id: idnEnglish.h 80575 2017-07-21 07:06:35Z yoonhee.kim $
 **********************************************************************/

#ifndef _O_IDN_ENGLISH_H_
# define  _O_IDN_ENGLISH_H_  1

# include <idTypes.h>
# include <idnCharSet.h>

#define idnEnglishSpaceChar               (0x20)
#define idnEnglishExclamationPointChar    (0x21)
#define idnEnglishQuotationMarkChar       (0x22)
#define idnEnglishNumberSignChar          (0x23)
#define idnEnglishDollarSignChar          (0x24)
#define idnEnglishPercentSignChar         (0x25)
#define idnEnglishAmpersandChar           (0x26)
#define idnEnglishApostropheChar          (0x27)
#define idnEnglishOpeningParenthesisChar  (0x28)
#define idnEnglishClosingParenthesisChar  (0x29)
#define idnEnglishAsteriskChar            (0x2A)
#define idnEnglishPlusSignChar            (0x2B)
#define idnEnglishCommaChar               (0x2C)
#define idnEnglishHyphenChar              (0x2D)
#define idnEnglishMinusSignChar           (0x2D)
#define idnEnglishPeriodChar              (0x2E)
#define idnEnglishSlashChar               (0x2F)
#define idnEnglishZeroChar                (0x30)
#define idnEnglishOneChar                 (0x31)
#define idnEnglishTwoChar                 (0x32)
#define idnEnglishThreeChar               (0x33)
#define idnEnglishFourChar                (0x34)
#define idnEnglishFiveChar                (0x35)
#define idnEnglishSixChar                 (0x36)
#define idnEnglishSevenChar               (0x37)
#define idnEnglishEightChar               (0x38)
#define idnEnglishNineChar                (0x39)
#define idnEnglishColonChar               (0x3A)
#define idnEnglishSemicolonChar           (0x3B)
#define idnEnglishLessThanSignChar        (0x3C)
#define idnEnglishEqualSignChar           (0x3D)
#define idnEnglishGreaterThanSignChar     (0x3E)
#define idnEnglishQuestionMarkChar        (0x3F)
#define idnEnglishAtSignChar              (0x40)
#define idnEnglishCapitalAChar            (0x41)
#define idnEnglishCapitalBChar            (0x42)
#define idnEnglishCapitalCChar            (0x43)
#define idnEnglishCapitalDChar            (0x44)
#define idnEnglishCapitalEChar            (0x45)
#define idnEnglishCapitalFChar            (0x46)
#define idnEnglishCapitalGChar            (0x47)
#define idnEnglishCapitalHChar            (0x48)
#define idnEnglishCapitalIChar            (0x49)
#define idnEnglishCapitalJChar            (0x4A)
#define idnEnglishCapitalKChar            (0x4B)
#define idnEnglishCapitalLChar            (0x4C)
#define idnEnglishCapitalMChar            (0x4D)
#define idnEnglishCapitalNChar            (0x4E)
#define idnEnglishCapitalOChar            (0x4F)
#define idnEnglishCapitalPChar            (0x50)
#define idnEnglishCapitalQChar            (0x51)
#define idnEnglishCapitalRChar            (0x52)
#define idnEnglishCapitalSChar            (0x53)
#define idnEnglishCapitalTChar            (0x54)
#define idnEnglishCapitalUChar            (0x55)
#define idnEnglishCapitalVChar            (0x56)
#define idnEnglishCapitalWChar            (0x57)
#define idnEnglishCapitalXChar            (0x58)
#define idnEnglishCapitalYChar            (0x59)
#define idnEnglishCapitalZChar            (0x5A)
#define idnEnglishOpeningBracketChar      (0x5B)
#define idnEnglishBackwardSlashChar       (0x5C)
#define idnEnglishClosingBracketChar      (0x5D)
#define idnEnglishCaretChar               (0x5E)
#define idnEnglishUnderscoreChar          (0x5F)
#define idnEnglishGraveChar               (0x60)
#define idnEnglishLowercaseAChar          (0x61)
#define idnEnglishLowercaseBChar          (0x62)
#define idnEnglishLowercaseCChar          (0x63)
#define idnEnglishLowercaseDChar          (0x64)
#define idnEnglishLowercaseEChar          (0x65)
#define idnEnglishLowercaseFChar          (0x66)
#define idnEnglishLowercaseGChar          (0x67)
#define idnEnglishLowercaseHChar          (0x68)
#define idnEnglishLowercaseIChar          (0x69)
#define idnEnglishLowercaseJChar          (0x6A)
#define idnEnglishLowercaseKChar          (0x6B)
#define idnEnglishLowercaseLChar          (0x6C)
#define idnEnglishLowercaseMChar          (0x6D)
#define idnEnglishLowercaseNChar          (0x6E)
#define idnEnglishLowercaseOChar          (0x6F)
#define idnEnglishLowercasePChar          (0x70)
#define idnEnglishLowercaseQChar          (0x71)
#define idnEnglishLowercaseRChar          (0x72)
#define idnEnglishLowercaseSChar          (0x73)
#define idnEnglishLowercaseTChar          (0x74)
#define idnEnglishLowercaseUChar          (0x75)
#define idnEnglishLowercaseVChar          (0x76)
#define idnEnglishLowercaseWChar          (0x77)
#define idnEnglishLowercaseXChar          (0x78)
#define idnEnglishLowercaseYChar          (0x79)
#define idnEnglishLowercaseZChar          (0x7A)
#define idnEnglishOpeningBraceChar        (0x7B)
#define idnEnglishVerticalLineChar        (0x7C)
#define idnEnglishClosingBraceChar        (0x7D)
#define idnEnglishTildeChar               (0x7E)

typedef ULong idnEnglishChar;

typedef union idnEnglishIndex{
    struct US7ASCII {
	ULong index;
    } US7ASCII;
    struct KO16KSC5601 {
	ULong index;
    } KO16KSC5601;
} idnEnglishIndex;

extern idnEnglishChar idnEnglishAsciiChars[128];

extern UChar idnEnglishSpaceTemplete[128];
extern UChar idnEnglishWeekDaysTemplete[7][128];
extern UChar idnEnglishTruncateTemplete[7][128];

extern UShort idnEnglishSpaceTempleteLength;
extern UShort idnEnglishWeekDaysTempleteLength[7];
extern UShort idnEnglishTruncateTempleteLength[7];

SInt idnEnglishSkip( const UChar* s1, UShort s1Length, idnEnglishIndex* index, UShort skip );
SInt idnEnglishCharAt( idnEnglishChar* c, const UChar* s1, UShort s1Length, idnEnglishIndex* index );
SInt idnEnglishAddChar( UChar* s1, UShort s1Max, UShort* s1Length, idnEnglishChar c );
SInt idnEnglishToUpper( idnEnglishChar* c );
SInt idnEnglishToLower( idnEnglishChar* c );
SInt idnEnglishToAscii( idnEnglishChar* c );
SInt idnEnglishToLocal( idnEnglishChar* c );
SInt idnEnglishToCompareOrder(idnEnglishChar* c );
SInt idnEnglishToCaselessCompareOrder( idnEnglishChar* c );
SInt idnEnglishNextChar( idnEnglishChar* c, SInt* carry );
SInt idnEnglishCompare( SInt* order, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishLengthWithoutSpace( UShort* length, const UChar* s1, UShort s1Length );

SInt idnEnglishAsciiAt( idnEnglishChar*c, const UChar* s1, UShort s1Length, idnEnglishIndex* index );
SInt idnEnglishAddAscii( UChar* s1, UShort s1Max, UShort* s1Length, idnEnglishChar c );
SInt idnEnglishLength( UShort* length, const UChar* s1, UShort s1Length );
SInt idnEnglishLengthWithoutSpaceUsingByteScan( UShort* length, const UChar* s1, UShort s1Length );
SInt idnEnglishCompareUsingMemCmp( SInt* order, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishCompareUsingNls   ( SInt* order, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishCompareWithSpace( SInt* order, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishCaselessCompare( SInt* order, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishCopy( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length  );
SInt idnEnglishConcat( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishSubstr( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length, UShort start, UShort length );
SInt idnEnglishUpper( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishLower( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishLtrim( UChar* s1, UShort v1Max, UShort* s1Length, const UChar* s2, UShort s2Length, const UChar* s3, UShort s3Length );
SInt idnEnglishRtrim( UChar* s1, UShort v1Max, UShort* s1Length, const UChar* s2, UShort s2Length, const UChar* s3, UShort s3Length );
SInt idnEnglishTrim( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length, const UChar* s3, UShort s3Length );
SInt idnEnglishPosition( UShort* position, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishNextString( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length );
SInt idnEnglishLikeKey( UChar* s1, UShort s1Max, UShort* s1Length, const UChar* s2, UShort s2Length, const UChar* s3, UShort s3Length );
SInt idnEnglishLike( SInt* match, const UChar* s1, UShort s1Length, const UChar* s2, UShort s2Length, const UChar* s3, UShort s3Length );

#endif /* _O_IDN_ENGLISH_H_ */
