/***********************************************************************
 * Copyright 1999-2000, RTBase Corporation or its subsidiaries.
 * All rights reserved.
 **********************************************************************/

/***********************************************************************
 * $Id: iduCompression.h 47966 2011-07-04 07:36:01Z cgkim $
 **********************************************************************/

#ifndef _O_IDU_COMPRESSION_H_
#define _O_IDU_COMPRESSION_H_ 1

#include <idl.h>

/***********************************************************************
 * ⳪ ũ Լ  ؽ̺ õ  ϴµ δ.
 *
 * IDU_COMPRESSION_D_BITS : ؽ̺ Ű Ʈ Ÿ.  Ʈ Ű  
 *                           Ÿ.  Ʈ  ؼ ؽ ̺ 
 *                          ũ⵵    ִ. , ޸𸮻  , ø
 *                           ִ. compressԼ aWorkMem ũ⿡  ش.
 *
 * IDU_COMPRESSION_D_SIZE : ؽ̺ Ű ִ ũ⸦ Ÿ. 
 *
 * IDU_COMPRESSION_D_MASK : IDU_COMPRESSION_D_BITS  ŭ  Ʈ  1̴. 
 *                          ̰Ͱ and ϸ ؽŰ ȿ ȿ    ִ.
 *
 * IDU_COMPRESSION_D_HIGH : IDU_COMPRESSION_D_MASK    bit set 
 *
 **********************************************************************/
#define IDU_COMPRESSION_D_BITS          (12)    // ȿ : (D_BITS >= 8) && (D_BITS <= 18)
#define IDU_COMPRESSION_D_SIZE          ((UInt)1UL << (IDU_COMPRESSION_D_BITS))
#define IDU_COMPRESSION_D_MASK          (IDU_COMPRESSION_D_SIZE - 1)
#define IDU_COMPRESSION_D_HIGH          ((IDU_COMPRESSION_D_MASK >> 1) + 1)


/***********************************************************************
 * IDU_COMPRESSION_WORK_SIZE :	compessԼ ڷ  aWorkMem ũ ݵ 
 *                               ũ  Ѵ. ̰ ũ IDU_COMPRESSION_D_BITS
 *                               ޴´.  ֳϸ ؽ Ű   ؽ ̺
 *                              ũⰡ ޶ ̰, aWorkMem ٷ ؽ̺̱
 *                              ̴.  ϴµ ־ ϴ ؽ ̺ Ҷ
 *                                ־ Ѵ. 
 *
 * IDU_COMPRESSION_MAX_OUTSIZE : compressԼ aSrcBuf  ũ   ,
 *                               aDestBuf ũ ݵ aSrcBuf size ڷ ־ 
 *                               ũ Լ Ͽ ũ⸦ ؾ Ѵ.
 *                                ũ⿡   iduCompression.cpp ' ũ '
 *                               κ  ϱ ٶ.
 *
 **********************************************************************/
#define IDU_COMPRESSION_WORK_SIZE               ((UInt) (IDU_COMPRESSION_D_SIZE * sizeof(UChar *)))
#define IDU_COMPRESSION_MAX_OUTSIZE(size)       (size + (size / 16) + 64 + 3)

class iduCompression
{
/***********************************************************************
 * Description :   ϴ κ
 * Ķʹ compress .
 *
 **********************************************************************/
    static UInt   compressInternal(UChar *aSrcBuf ,
                                   UInt   aSrcLen,
                                   UChar *aDestBuf,
                                   UInt   aDestLen,
                                   UInt*  aResultLen,
                                   void*  aWorkMem );
public:
/***********************************************************************
 * Description :     ȣϴ Լ
 * 
 * aSrc		- [IN] :   ϰ ϴ ҽ  ִ , ̶  ũ
 *			     ִ. 
 *
 * aSrcLen	- [IN] : aSrc 
 *
 * aDest	- [IN] :    ԷµǴ ,   ũ ݵ
 *		 IDU_COMPRESSION_MAX_OUTSIZE(ҽũ)  Ͽ Ѵ.
 *
 * aDestLen	- [IN] : aDest  
 *
 * aResultLen	- [OUT]:   
 * aWorkMem	- [IN] :  ؽ̺  ޸𸮸  ־  Ų.
 *		 ̶  IDU_COMPRESSION_WORK_SIZEũ ޸𸮸 Ѵ.
 *
 *
 *
 * aWorkMem ʱȭ ʿ .
 * ؽ ̺ Ʈ srcBuf Ư ġ Ű ̴.
 * ⼭ ؽ ̺ workMem Ѵ.  ܺο  workMem ο 
 * ؽ ̺ Ѵ. 
 *
 * ׷  ؽ ̺ ִũ 
 * "IDU_COMPRESSION_D_SIZE(ؽŰ ִ ũ) * ּũ"  ȴ.
 *
 * iduCompression.cpp COMPRESSION_CHECK_MPOS_NON_DET(m_pos,m_off,aSrcBuf,sSrcPtr,M4_MAX_OFFSET)
 *	 ̺κ       ִ. 
 *
 *   츦      Ǵ 츦  ,
 * 1. srcBuf ó ּҺ     ( 0) 
 *	=>  ũԼ ˻ȴ.
 *
 * 2. srcBuf  ּҺ ū    
 *	=>  ũԼ   ġ ū ġ  Żϰ Ǿִ.
 *
 * 3.  ġ ۰ srcBuf ū   ( ,   
 *      ּ  ϰ  ) 
 *	=> ̶  ũο ϴٰ ǰ .  Ʒ 
 *	  ּҸ ͷ Ͽ  ͸ ãƼ ˻縦 ϰ ȴ. 
 *	 ƹ  ̶ ص ͷν   ̻ Ⱑ ƴ  ȴ. 
 *	̶   쿣  hash    ʹ ٸ ó 
 *	 Ǿ Żϰ ȴ. 
 *
 **********************************************************************/
    static IDE_RC compress(UChar *aSrc,
                           UInt   aSrcLen,
                           UChar *aDest,
                           UInt   aDestLen,
                           UInt*  aResultLen,
                           void*  aWorkMem );
    
/***********************************************************************
 * Description :    ҽ Ǯ ϴ Լ
 * aSrc		- [IN] :   ִ 
 * aSrcLen	- [IN] : aSrc ũ
 * aDest	- [IN] :     , ̰ ũ compress
 *			  ũ ϴ.   İ ũⰡ  
 * aDestLen	- [IN] : aDest ũ
 * aResultLen	- [OUT]:    ũ
 **********************************************************************/
    static IDE_RC decompress(UChar *aSrc,
                             UInt   aSrcLen,
                             UChar *aDest,
                             UInt   aDestLen,
                             UInt  *aResultLen);
};


#endif  // _O_IDU_COMPRESSION_H_

 
