/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: mtfDump.cpp 84991 2019-03-11 09:21:00Z andrew.shin $
 **********************************************************************/

#include <mte.h>
#include <mtc.h>
#include <mtd.h>
#include <mtf.h>
#include <mtk.h>
#include <mtv.h>

extern mtfModule mtfDump;

extern mtdModule mtdList;
extern mtdModule mtdInteger;

static mtcName mtfDumpFunctionName[1] = {
    { NULL, 4, (void*)"DUMP" }
};

static IDE_RC mtfDumpEstimate( mtcNode*     aNode,
                               mtcTemplate* aTemplate,
                               mtcStack*    aStack,
                               SInt         aRemain,
                               mtcCallBack* aCallBack );

mtfModule mtfDump = {
    1|MTC_NODE_OPERATOR_FUNCTION|MTC_NODE_EAT_NULL_TRUE,
    ~(MTC_NODE_INDEX_MASK),
    1.0,  // default selectivity ( ڰ ƴ)
    mtfDumpFunctionName,
    NULL,
    mtf::initializeDefault,
    mtf::finalizeDefault,
    mtfDumpEstimate
};

static IDE_RC mtfDumpCalculate( mtcNode*     aNode,
                                mtcStack*    aStack,
                                SInt         aRemain,
                                void*        aInfo,
                                mtcTemplate* aTemplate );

const mtcExecute mtfExecute = {
    mtf::calculateNA,
    mtf::calculateNA,
    mtf::calculateNA,
    mtf::calculateNA,
    mtfDumpCalculate,
    NULL,
    mtx::calculateNA,
    mtk::estimateRangeNA,
    mtk::extractRangeNA
};

IDE_RC mtfDumpEstimate( mtcNode*     aNode,
                        mtcTemplate* aTemplate,
                        mtcStack*    aStack,
                        SInt      /* aRemain */,
                        mtcCallBack* aCallBack )
{
    const mtdModule* sModules[2];
    UInt             sPrecision;

    IDE_TEST_RAISE( ( aNode->lflag & MTC_NODE_QUANTIFIER_MASK ) ==
                    MTC_NODE_QUANTIFIER_TRUE,
                    ERR_NOT_AGGREGATION );

    IDE_TEST_RAISE( (( aNode->lflag & MTC_NODE_ARGUMENT_COUNT_MASK ) < 1) ||
                    (( aNode->lflag & MTC_NODE_ARGUMENT_COUNT_MASK ) > 2),
                    ERR_INVALID_FUNCTION_ARGUMENT );

    aStack[0].column = aTemplate->rows[aNode->table].columns + aNode->column;

    IDE_TEST_RAISE( (aStack[1].column->module->id == MTD_LIST_ID ) ||
                    (aStack[1].column->module->id == MTD_ROWTYPE_ID ) ||
                    (aStack[1].column->module->id == MTD_RECORDTYPE_ID ) ||
                    (aStack[1].column->module->id == MTD_ASSOCIATIVE_ARRAY_ID ) ||
                    (aStack[1].column->module->id == MTD_BLOB_ID ) ||
                    (aStack[1].column->module->id == MTD_CLOB_ID ) ||
                    (aStack[1].column->module->id == MTD_BLOB_LOCATOR_ID ) ||
                    (aStack[1].column->module->id == MTD_CLOB_LOCATOR_ID ) ||
                    (aStack[1].column->module->id == MTD_ECHAR_ID ) ||
                    (aStack[1].column->module->id == MTD_EVARCHAR_ID ),
                    ERR_CONVERSION_NOT_APPLICABLE );

    IDE_TEST( mtf::getCharFuncResultModule( &sModules[0], NULL )
              != IDE_SUCCESS );

    sModules[1] = &mtdInteger;

    IDE_TEST( mtf::makeConversionNodes( aNode,
                                        aNode->arguments->next,
                                        aTemplate,
                                        aStack + 2,
                                        aCallBack,
                                        sModules + 1 )
             != IDE_SUCCESS );

    aTemplate->rows[aNode->table].execute[aNode->column] = mtfExecute;

    sPrecision = ( aStack[1].column->column.size << 2 ) + 50;

    if( sPrecision > MTD_CHAR_PRECISION_MAXIMUM )
    {
        sPrecision = MTD_CHAR_PRECISION_MAXIMUM;
    }

    /*
    IDE_TEST( sModule->estimate( aStack[0].column,
                                 1,
                                 sPrecision,
                                 0 )
              != IDE_SUCCESS );
    */
    IDE_TEST( mtc::initializeColumn( aStack[0].column,
                                     sModules[0],
                                     1,
                                     sPrecision,
                                     0 )
              != IDE_SUCCESS );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NOT_AGGREGATION );
    IDE_SET(ideSetErrorCode(mtERR_ABORT_NOT_AGGREGATION));

    IDE_EXCEPTION( ERR_INVALID_FUNCTION_ARGUMENT );
    IDE_SET(ideSetErrorCode(mtERR_ABORT_INVALID_FUNCTION_ARGUMENT));

    IDE_EXCEPTION( ERR_CONVERSION_NOT_APPLICABLE );
    IDE_SET(ideSetErrorCode(mtERR_ABORT_CONVERSION_NOT_APPLICABLE));

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

static UChar* mtfCalculateCopyDecNumber( UChar* aIterator,
                                         UChar* aFence,
                                         UInt   aValue )
{
/***********************************************************************
 *
 * Description : Copy Decimal Number
 *
 * Implementation :
 *    aValue aIterator 
 *
 ***********************************************************************/
    if( aValue >= 10 )
    {
        aIterator = mtfCalculateCopyDecNumber( aIterator, aFence, aValue/10 );
        aValue   %= 10;
    }

    if( aIterator < aFence )
    {
        *aIterator = aValue + '0';
        aIterator++;
    }

    return aIterator;
}

static UChar* mtfCalculateCopyHexNumber( UChar* aIterator,
                                         UChar* aFence,
                                         UInt   aValue )
{
/***********************************************************************
 *
 * Description : Copy Hex Number
 *
 * Implementation :
 *    aValue aIterator  
 *
 ***********************************************************************/
    if( aValue >= 16 )
    {
        aIterator = mtfCalculateCopyHexNumber( aIterator, aFence, aValue/16 );
        aValue   %= 16;
    }
    
    if( aIterator < aFence )
    {
        switch( aValue )
        {
            case 10:
                *aIterator = 'a';
                break;
            case 11:
                *aIterator = 'b';
                break;
            case 12:
                *aIterator = 'c';
                break;
            case 13:
                *aIterator = 'd';
                break;
            case 14:
                *aIterator = 'e';
                break;
            case 15:
                *aIterator = 'f';
                break;
            default:
                *aIterator = aValue + '0';
                break;
        }
        aIterator++;
    }
    
    return aIterator;
}

static UChar * mtfCalculateCopyString( UChar *     aIterator,
                                       UChar *     aFence,
                                       const char* aString )
{
/***********************************************************************
 *
 * Description : Copy String
 *
 * Implementation :
 *    aString aIterator  
 *
 ***********************************************************************/
    for( ; *aString != '\0' && aIterator < aFence; aString++, aIterator++ )
    {
        *aIterator = (const UChar)*aString;
    }

    return aIterator;
}

IDE_RC mtfDumpCalculate( mtcNode*     aNode,
                         mtcStack*    aStack,
                         SInt         aRemain,
                         void*        aInfo,
                         mtcTemplate* aTemplate )
{
/***********************************************************************
 *
 * Description : Dump Calculate
 *
 * Implementation :
 *    DUMP( expression )
 *
 *    aStack[0] : Էµ ڷḦ мϿ 'ڷ, , ޸ '
 *                  
 *    aStack[1] : Էµ ڷ
 *    aStack[2] : ޸  10 Ǵ 16   ְ Ѵ.
 *                (10 Ǵ 16 Է   ִ.)
 *                ڰ ų NULL̸ 10 ش.
 *
 *    ex ) DUMP(ename)
 *         ==> Type=CHAR(ENGLISH) Length=22: 0,20,83,87,78,...
 *
 ***********************************************************************/
    
    const mtdModule* sModule;
    const mtlModule* sLanguage;
    mtdCharType*     sResult;
    UChar *          sCurResultVal;
    UChar*           sFence;
    UChar*           sValue;
    UChar*           sValueFence;
    mtdIntegerType   sDecOrHex;
    
    IDE_TEST( mtf::postfixCalculate( aNode,
                                     aStack,
                                     aRemain,
                                     aInfo,
                                     aTemplate )
              != IDE_SUCCESS );

    // 
    // sResult->value : ڷ +  + ޸ 
    // sResult->length : value   
    sResult        = (mtdCharType*)aStack[0].value;
    
    sCurResultVal  = sResult->value; 
    sFence         = sCurResultVal + aStack[0].column->precision;

    // data module : data type  ȹ  ʿ
    sModule   = aStack[1].column->module;

    // language module : language type  ȹ  ʿ 
    sLanguage = aStack[1].column->language;
    
    if( sModule->isNull( aStack[1].column,
                         aStack[1].value ) == ID_TRUE )
    {
        // Էµ ڷᰡ NULL 
        sCurResultVal = mtfCalculateCopyString( sCurResultVal, sFence, "NULL" );
    }
    else
    {
        // expression شϴ 
        sValue = (UChar*)aStack[1].value;
        sValueFence = sValue + sModule->actualSize( aStack[1].column,
                                                    aStack[1].value );

        //--------------------------------------
        // ޸   ¸ (10 Ǵ 16)
        //--------------------------------------
        if( ( aNode->lflag & MTC_NODE_ARGUMENT_COUNT_MASK ) == 1 )
        {
            sDecOrHex = 10;
        }
        else
        {
            if( aStack[2].column->module->isNull( aStack[2].column,
                                              aStack[2].value ) == ID_TRUE)
            {
                sDecOrHex = 10;
            }
            else
            {
                IDE_TEST_RAISE( (*(mtdIntegerType*)aStack[2].value != 10) &&
                                (*(mtdIntegerType*)aStack[2].value != 16)
                                , ERR_ONLY_USE_DEC_OR_HEX );

                sDecOrHex = *(mtdIntegerType*)aStack[2].value;
            }
        }
        
        //--------------------------------------
        // Ÿ Ÿ   ( ex. Type=CHAR )
        //--------------------------------------

        sCurResultVal =
            mtfCalculateCopyString( sCurResultVal, sFence, "Type=" );

        sCurResultVal =
            mtfCalculateCopyString(sCurResultVal,
                                   sFence,
                                   (const char*)sModule->names->string );
        
        //--------------------------------------
        // Language   ( ex. (ENGLISH) )
        //--------------------------------------
        
        if( sLanguage != NULL )
        {
            sCurResultVal =
                mtfCalculateCopyString( sCurResultVal, sFence, "(" );

            sCurResultVal =
                mtfCalculateCopyString(sCurResultVal,
                                       sFence, 
                                       (const char*)sLanguage->names->string );

            sCurResultVal =
                mtfCalculateCopyString( sCurResultVal, sFence, ")" );
        }
        else
        {
            // nothing to do
        }

        //--------------------------------------
        //    ( ex. Length : 22 )
        //--------------------------------------

        sCurResultVal =
            mtfCalculateCopyString( sCurResultVal, sFence, " Length=" );

        sCurResultVal =
            mtfCalculateCopyDecNumber( sCurResultVal,
                                       sFence,
                                       sValueFence - sValue );

        //--------------------------------------
        // ޸ 
        //--------------------------------------

         sCurResultVal = mtfCalculateCopyString( sCurResultVal, sFence, ":" );
         
        if( sDecOrHex == 10 )
        {
            if( sValue < sValueFence )
            {
                sCurResultVal =
                    mtfCalculateCopyString( sCurResultVal, sFence, " " );
                
                sCurResultVal =
                    mtfCalculateCopyDecNumber( sCurResultVal,
                                               sFence,
                                               *sValue );
            }
            else
            {
                // nothing to do
            }

            for( sValue++; sValue < sValueFence; sValue++ )
            {
                sCurResultVal =
                    mtfCalculateCopyString( sCurResultVal, sFence, "," );
                
                sCurResultVal =
                    mtfCalculateCopyDecNumber( sCurResultVal,
                                               sFence,
                                               *sValue );
            }
        }
        else
        {
            if( sValue < sValueFence )
            {
                sCurResultVal =
                    mtfCalculateCopyString( sCurResultVal, sFence, " " );
                
                sCurResultVal =
                    mtfCalculateCopyHexNumber( sCurResultVal,
                                               sFence,
                                               *sValue );
            }
            else
            {
                // nothing to do
            }

            for( sValue++; sValue < sValueFence; sValue++ )
            {
                sCurResultVal =
                    mtfCalculateCopyString( sCurResultVal, sFence, "," );
                
                sCurResultVal =
                    mtfCalculateCopyHexNumber( sCurResultVal,
                                               sFence,
                                               *sValue );
            }
        }
    }
    
    sResult->length = sCurResultVal - sResult->value;
        
    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_ONLY_USE_DEC_OR_HEX );
    {
        IDE_SET(ideSetErrorCode(mtERR_ABORT_ONLY_USE_DEC_OR_HEX_IN_DUMP_FUNC));
    }
    
    IDE_EXCEPTION_END;
    
    return IDE_FAILURE;
}
 
