/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id$ 
 *
 * Description :
 *     DLAY(DeLAY) Node
 *
 *   :
 *
 *  :
 *
 **********************************************************************/

#ifndef _O_QMN_DLAY_H_
#define _O_QMN_DLAY_H_ 1

#include <mt.h>
#include <qmc.h>
#include <qmnDef.h>

//-----------------
// Code Node Flags
//-----------------


//-----------------
// Data Node Flags
//-----------------

/* qmndDLAY.flag                                     */
// First Initialization Done
#define QMND_DLAY_INIT_DONE_MASK           (0x00000001)
#define QMND_DLAY_INIT_DONE_FALSE          (0x00000000)
#define QMND_DLAY_INIT_DONE_TRUE           (0x00000001)

typedef struct qmncDLAY  
{
    //---------------------------------
    // Code   
    //---------------------------------

    qmnPlan        plan;
    UInt           flag;
    UInt           planID;

} qmncDLAY;

typedef struct qmndDLAY
{
    //---------------------------------
    // Data   
    //---------------------------------
    qmndPlan       plan;
    doItFunc       doIt;
    UInt         * flag;

} qmndDLAY;

class qmnDLAY
{
public:

    //------------------------
    // Base Function Pointer
    //------------------------

    // ʱȭ
    static IDE_RC init( qcTemplate * aTemplate,
                        qmnPlan    * aPlan );

    //  Լ
    static IDE_RC doIt( qcTemplate * aTemplate,
                        qmnPlan    * aPlan,
                        qmcRowFlag * aFlag );

    // Null Padding
    static IDE_RC padNull( qcTemplate * aTemplate,
                           qmnPlan    * aPlan );

    // Plan  
    static IDE_RC printPlan( qcTemplate   * aTemplate,
                             qmnPlan      * aPlan,
                             ULong          aDepth,
                             iduVarString * aString,
                             qmnDisplay     aMode );
};

#endif /* _O_QMN_DLAY_H_ */
