/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id$
 *
 * Description :
 *     SDIN(SharD INsert) Node
 *
 *      𵨿 insert ϴ Plan Node ̴.
 *
 *   :
 *
 *  :
 *
 **********************************************************************/

#ifndef _O_QMN_SHARD_INST_H_
#define _O_QMN_SHARD_INST_H_ 1

#include <mt.h>
#include <qmc.h>
#include <qmnDef.h>
#include <qcmTableInfo.h>
#include <qmmParseTree.h>
#include <qmnShardDML.h>
#include <sdi.h>

//-----------------
// Code Node Flags
//-----------------

//-----------------
// Data Node Flags
//-----------------

// qmndSDIN.flag
# define QMND_SDIN_INIT_DONE_MASK           (0x00000001)
# define QMND_SDIN_INIT_DONE_FALSE          (0x00000000)
# define QMND_SDIN_INIT_DONE_TRUE           (0x00000001)

// qmndSDIN.flag
# define QMND_SDIN_INSERT_MASK              (0x00000002)
# define QMND_SDIN_INSERT_FALSE             (0x00000000)
# define QMND_SDIN_INSERT_TRUE              (0x00000002)

typedef struct qmncSDIN
{
    //---------------------------------
    // Code   
    //---------------------------------

    qmnPlan               plan;
    UInt                  flag;
    UInt                  planID;

    //---------------------------------
    // querySet  
    //---------------------------------

    qmsTableRef         * tableRef;

    //---------------------------------
    // insert  
    //---------------------------------

    idBool                isInsertSelect;

    // update columns
    qcmColumn           * columns;
    qcmColumn           * columnsForValues;

    // update values
    qmmMultiRows        * rows;       /* BUG-42764 Multi Row */
    UInt                  valueIdx;   // update smiValues index
    UInt                  canonizedTuple;
    void                * queueMsgIDSeq;

    // sequence 
    qcParseSeqCaches    * nextValSeqs;

    //---------------------------------
    //  
    //---------------------------------

    UInt                  shardDataIndex;
    UInt                  shardDataOffset;
    UInt                  shardDataSize;

    UInt                  bindParam;    // offset
    UInt                  outBindParam; // offset

    qcNamePosition        shardQuery;
    sdiAnalyzeInfo      * shardAnalysis;
    UShort                shardParamCount;

    //---------------------------------
    // Display  
    //---------------------------------

    qmsNamePosition       tableOwnerName;     // Table Owner Name
    qmsNamePosition       tableName;          // Table Name
    qmsNamePosition       aliasName;          // Alias Name

    qmmReturnInto       * returnInto;    /* BUG-47766 */

} qmncSDIN;

typedef struct qmndSDIN
{
    //---------------------------------
    // Data   
    //---------------------------------

    qmndPlan              plan;
    doItFunc              doIt;
    UInt                * flag;

    //---------------------------------
    // INST  
    //---------------------------------

    /* BUG-42764 Multi Row */
    qmmMultiRows        * rows;   // Current row
    //---------------------------------
    // lob ó  
    //---------------------------------
    
    struct qmxLobInfo   * lobInfo;

    sdiDataNodes        * mDataInfo;

} qmndSDIN;

class qmnSDIN
{
public:

    //------------------------
    // Base Function Pointer
    //------------------------

    // ʱȭ
    static IDE_RC init( qcTemplate * aTemplate,
                        qmnPlan    * aPlan );

    //  Լ
    static IDE_RC doIt( qcTemplate * aTemplate,
                        qmnPlan    * aPlan,
                        qmcRowFlag * aFlag );

    // Null Padding
    static IDE_RC padNull( qcTemplate * aTemplate,
                           qmnPlan    * aPlan );

    // Plan  
    static IDE_RC printPlan( qcTemplate   * aTemplate,
                             qmnPlan      * aPlan,
                             ULong          aDepth,
                             iduVarString * aString,
                             qmnDisplay     aMode );

    static void shardStmtPartialRollbackUsingSavepoint( qcTemplate    * aTemplate,
                                                        qmnPlan       * aPlan );
private:

    //------------------------
    // ʱȭ  Լ
    //------------------------

    //  ʱȭ
    static IDE_RC firstInit( qcTemplate * aTemplate,
                             qmncSDIN   * aCodePlan,
                             qmndSDIN   * aDataPlan );

    static IDE_RC setParamInfo( qcTemplate   * aTemplate,
                                qmncSDIN     * aCodePlan,
                                sdiBindParam * aBindParams );

    // ȣǾ ȵ.
    static IDE_RC doItDefault( qcTemplate * aTemplate,
                               qmnPlan    * aPlan,
                               qmcRowFlag * aFlag );

    //  INST 
    static IDE_RC doItFirst( qcTemplate * aTemplate,
                             qmnPlan    * aPlan,
                             qmcRowFlag * aFlag );

    //  INST 
    static IDE_RC doItNext( qcTemplate * aTemplate,
                            qmnPlan    * aPlan,
                            qmcRowFlag * aFlag );

    //  INST 
    static IDE_RC doItFirstMultiRows( qcTemplate * aTemplate,
                                      qmnPlan    * aPlan,
                                      qmcRowFlag * aFlag );

    //  INST 
    static IDE_RC doItNextMultiRows( qcTemplate * aTemplate,
                                     qmnPlan    * aPlan,
                                     qmcRowFlag * aFlag );

    // Insert One Record
    static IDE_RC insertOneRow( qcTemplate * aTemplate,
                                qmnPlan    * aPlan );

    // Insert One Record
    static IDE_RC insertOnce( qcTemplate * aTemplate,
                              qmnPlan    * aPlan );

    static IDE_RC copySmiValueToTuple( qcTemplate      * aTemplate,
                                       qcmTableInfo    * aTableInfo,
                                       smiValue        * aInsertedRow,
                                       mtcTuple        * aTuple,
                                       sdiBindParam    * aBindParams,
                                       sdiOutBindParam * aOutBindParams,
                                       qmxLobInfo      * aLobInfo );
                                   

    /* PROJ-2728 Sharding LOB */
    static idBool existInLobInfoAndAdjustBindId(
                                       qmxLobInfo   * aLobInfo,
                                       SInt           aColumnOrder,
                                       SInt           aBindId );
};

#endif /* _O_QMN_SHARD_INST_H_ */
