/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: qcply.y 91584 2021-09-03 07:55:16Z khkwak $
 **********************************************************************/

/*
  BUGBUG stored procedure
  SP_boolean_expression
      check if the expresion is really a booelan expression.
  SP_ident_opt_simple_arglist
      make sure that every argument is are one of these.
    : TL_INTEGER
    | TL_NUMERIC
    | TL_LITERAL
    | TI_IDENTIFIER TL_LITERAL
    | TS_MINUS_SIGN TL_INTEGER
    | TS_PLUS_SIGN TL_INTEGER
    | TS_QUESTION_MARK
    | TI_HOSTVARIABLE
    | TR_NULL
    | SYSDATE

  SP_case_statement
    duplicate variable in abbriated form of CASE statement for type conversion.
  SP_for_loop_statement
    make newCounterNode to point to the same data area with counterNode.
  unified_invocation and SP_ident..
     set username to tableName
 */

%pure_parser

%{
#include <idl.h>
#include <idsPassword.h>
#include <smi.h>
#include <smiTableSpace.h>
#include <rp.h>
#include <mtcDef.h>
#include <qc.h>
#include <qcc.h>
#include <qdbCreate.h>
#include <qdbAlter.h>
#include <qdpGrant.h>
#include <qdpRevoke.h>
#include <qdc.h>
#include <qdd.h>
#include <qdm.h>
#include <qdn.h>
#include <qdnTrigger.h>
#include <qdr.h>
#include <qds.h>
#include <qdsSynonym.h>
#include <qdtAlter.h>
#include <qdtCreate.h>
#include <qdtDrop.h>
#include <qdx.h>
#include <qdv.h>
#include <qmv.h>
#include <qmo.h>
#include <qmx.h>
#include <qsv.h>
#include <qso.h>
#include <qsx.h>
#include <qrc.h>
#include <qtc.h>
#include <qtcDef.h>
#include <qcpUtil.h>
#include <qcpManager.h>
#include <qdParseTree.h>
#include <qdnTrigger.h>
#include <qmmParseTree.h>
#include <qmsParseTree.h>
#include <qriParseTree.h>
#include <qsParseTree.h>
#include <qspDef.h>
#include <qsvProcStmts.h>
#include <qsvCursor.h>
#include <qsvPkgStmts.h>
#include <qsoProcStmts.h>
#include <qsoPkgStmts.h>
#include <qsxExecutor.h>
#include <qcm.h>
#include <qcmUser.h>
#include <qcmPriv.h>
#include <qcuSqlSourceInfo.h>
#include <qcuProperty.h>
#include <qdcDir.h>
#include <qdq.h>
#include <qcg.h>
#include <qdbComment.h>
#include <qlParseTree.h> // PROJ-1685
#include <qdcLibrary.h>  // PROJ-1685
#include <qdcAudit.h>
#include <qdcJob.h>
#include "qcplx.h"
#include <qdkParseTree.h>
#include <qdk.h>
#include <qdpRole.h>
#include <qdbFlashback.h>
#include <qss.h>
#include <qdbDisjoin.h> /* PROJ-1810 */
#include <qdbJoin.h>    /* PROJ-1810 */
#include <qdbCopySwap.h>    /* PROJ-2600 Online DDL for Tablespace Alteration */
#include <sdi.h>
#include <qdsd.h>    

#define PARAM       ((qcplx*)param)
#define SESSION     (PARAM->mSession)
#define STATEMENT   (PARAM->mStatement)
#define QTEXT       (STATEMENT->myPlan->stmtText)
#define QTEXTLEN    (STATEMENT->myPlan->stmtTextLen)
#define MEMORY      (STATEMENT->myPlan->qmpMem)
#define NCHARLIST   (PARAM->mNcharList)

#define QCP_GET_TEMPLATE_SMI_VALUE_INDEX()                  \
    ( STATEMENT->myPlan->sTmplate->insOrUptStmtCount ++ )

// fix BUG-36522
SInt qcpllineno( SChar * aStmtText, SInt aStmtTextLen, SInt aOffset );

#define QCP_SET_INIT_PROC_PARSE_TREE(_dst_, _fromPosition_, _toPosition_ ) \
{                                                                          \
    ((qsProcStmts *)_dst_)->next = NULL;                                   \
    ((qsProcStmts *)_dst_)->pos.stmtText = QTEXT;                          \
    ((qsProcStmts *)_dst_)->pos.size =                                     \
        _toPosition_.offset                                                \
        + _toPosition_.size                                                \
        - _fromPosition_.offset;                                           \
    ((qsProcStmts *)_dst_)->pos.offset =                                   \
        _fromPosition_.offset;                                             \
    ((qsProcStmts *)_dst_)->parent = NULL;                                 \
    ((qsProcStmts *)_dst_)->parentLabels = NULL;                           \
    ((qsProcStmts *)_dst_)->childLabels = NULL;                            \
    ((qsProcStmts *)_dst_)->lineno = qcpllineno(QTEXT, QTEXTLEN, _fromPosition_.offset);\
    ((qsProcStmts *)_dst_)->useDate = ID_FALSE;                            \
}

//fix PROJ-1596
#define QCP_SET_CURSOR_SQL(_dst_, _fromPosition_, _toPosition_ )           \
{                                                                          \
    ((qsCursors *)_dst_)->pos.stmtText = QTEXT;                            \
    ((qsCursors *)_dst_)->pos.size =                                       \
        _toPosition_.offset                                                \
        + _toPosition_.size                                                \
        - _fromPosition_.offset;                                           \
    ((qsCursors *)_dst_)->pos.offset =                                     \
        _fromPosition_.offset;                                             \
}

#define QCP_SET_INIT_PROC_VAR_ITEM(_dst_, _varType_, _varNamePos_ )        \
{                                                                          \
    ((qsVariableItems *)(_dst_))->itemType = (_varType_);                  \
    ((qsVariableItems *)(_dst_))->table    = ID_USHORT_MAX;                \
    ((qsVariableItems *)(_dst_))->column   = ID_USHORT_MAX;                \
    ((qsVariableItems *)(_dst_))->objectID = QS_EMPTY_OID;                 \
    SET_POSITION( ((qsVariableItems *)(_dst_))->name, (_varNamePos_) );    \
    ((qsVariableItems *)(_dst_))->lineno = qcpllineno(QTEXT, QTEXTLEN, _varNamePos_.offset);\
    ((qsVariableItems *)(_dst_))->next = NULL;                             \
}

#define QCP_SET_COPY_PROC_VAR_TABLE_AND_COLUMN(_dst_, _typeNode_ )         \
{                                                                          \
    ((qsVariableItems *)(_dst_))->table    = QTC_NODE_TABLE( _typeNode_ ); \
    ((qsVariableItems *)(_dst_))->column   = QTC_NODE_COLUMN( _typeNode_ );\
    ((qsVariableItems *)(_dst_))->objectID = QS_EMPTY_OID;                 \
}

#define QCP_SET_INIT_PROC_SQL_STATEMENT( _spSql_ )          \
{                                                           \
    (_spSql_)->common.parse    = qsvProcStmts::parseSql;    \
    (_spSql_)->common.validate = qsvProcStmts::validateSql; \
    (_spSql_)->common.optimize = qsoProcStmts::optimizeNone;\
                                                            \
    (_spSql_)->sqlText             = NULL;                  \
    (_spSql_)->sqlTextLen          = 0;                     \
                                                            \
    (_spSql_)->isExistsSql         = ID_FALSE;              \
    (_spSql_)->isIntoVarRecordType = ID_FALSE;              \
    (_spSql_)->intoVariables       = NULL;                  \
    (_spSql_)->from                = NULL;                  \
    (_spSql_)->usingParams         = NULL;                  \
    (_spSql_)->usingParamCount     = 0;                     \
    (_spSql_)->usingSubprograms    = NULL;                  \
}

// PROJ-1073 Package
#define QCP_SET_INIT_PKG_PARSE_TREE( _dst_, _fromPosition_, _toPosition_ ) \
{                                                                          \
    ( (qsPkgStmts *)_dst_ )->next = NULL;                                  \
    ( (qsPkgStmts *)_dst_ )->pos.stmtText = QTEXT;                         \
    ( (qsPkgStmts *)_dst_ )->pos.size =                                    \
         _toPosition_.offset                                               \
         + _toPosition_.size                                               \
         - _fromPosition_.offset;                                          \
    ( (qsPkgStmts *)_dst_ )->pos.offset =                                  \
         _fromPosition_.offset;                                            \
    ( (qsPkgStmts *)_dst_ )->state = QS_PKG_STMTS_INIT_STATE;              \
    ( (qsPkgStmts *)_dst_ )->flag = 0;                                     \
}                                                                          \
 
#define QCP_SET_INIT_PKG_SUBPROGRAM_STATEMENT( _pkgSubprogram_ )                        \
{                                                                                       \
    ( _pkgSubprogram_ )->common.stmtType       = (_pkgSubprogram_)->parseTree->objType; \
    ( _pkgSubprogram_ )->common.parse          = qsvPkgStmts::parseCreateProc;          \
    ( _pkgSubprogram_ )->common.validateHeader = qsvPkgStmts::validateCreateProcHeader; \
    ( _pkgSubprogram_ )->common.validateBody   = qsvPkgStmts::validateCreateProcBody;   \
    ( _pkgSubprogram_ )->common.optimize       = qsoPkgStmts::optimizeCreateProc;       \
    ( _pkgSubprogram_ )->subprogramID          = 0;                                     \
}

#define QCP_ADJUST_POSITION( _stmt_, _pos_ )                                \
{                                                                           \
    (_stmt_)->position.size = (_pos_).offset + (_pos_).size - (_stmt_)->position.offset;   \
}

// PROJ-2638
// ͷ parsingǴ rule(opt_limit)̳ semicolon  rule  ġ  
#define QCP_ADJUST_LAST_POSITION( _pos_ )                                   \
{                                                                           \
    qcNamePosition  _endPos_;                                               \
    qcpUtil::setLastTokenPosition( PARAM->mLexer, &_endPos_ );              \
    (_pos_).size = _endPos_.offset + _endPos_.size - (_pos_).offset;        \
}                                                                           \

// opt_wait̳ opt_for_update ٷ  rule  ġ  
#define QCP_ADJUST_END_POSITION( _pos_ )                                    \
{                                                                           \
    qcNamePosition  _endPos_;                                               \
    qcpUtil::setEndTokenPosition( PARAM->mLexer, &_endPos_ );               \
    (_pos_).size = _endPos_.offset + _endPos_.size - (_pos_).offset;        \
}                                                                           \

#define QCP_ADD_POSITION( _posA_, _pos1_, _pos2_ )                          \
{                                                                           \
    qcNamePosition  _pos_;                                                  \
    _pos_.stmtText = (_pos1_).stmtText;                                     \
    _pos_.offset   = (_pos1_).offset;                                       \
    _pos_.size     = (_pos2_).size + (_pos2_).offset - (_pos1_).offset;     \
    SET_POSITION( _posA_, _pos_ );                                          \
}                                                                           \

/*BUGBUG_NT*/
#if defined(VC_WIN32)
#include <malloc.h>
#define strcasecmp _stricmp
#endif
/*BUGBUG_NT ADD*/

#if defined(SYMBIAN)
void * alloca(unsigned int);
#endif
// #define YYERROR_VERBOSE

extern mtfModule mtfExists;
extern mtfModule mtfNotExists;
extern mtfModule mtfVc2coll;
%}

%union {
    qcNamePosition          position;
    qcNamePosition *        positionPtr;
    qdUserNObjName *        userNObjName;   /* temporary struct */
    UInt                    flag;
    UInt                    uIntVal;
    SInt                    sIntVal;
    ULong                   uLongVal;
    ULong *                 uLongPtr;
    qtcNode *               expression[2];
    mtcColumn *             column;
    idBool                  boolType;
    qdTableParseTree *      tableParseTree;
    qdPartitionedTable *    partTable; /* PROJ-1502 */
    qdPartitionAttribute *  partAttr; /* PROJ-1502 */
    qdAlterPartition *      alterPart; /* PROJ-1502 */
    qdIndexPartitionAttribute * indexPartAttr; /* PROJ-1502 */
    qmmValueNode *          partKeyCond; /* PROJ-1502 */
    qdDefaultParseTree *    defaultParseTree;
    qdPartCondValParseTree *partCondValParseTree; // PROJ-1502 PARTITIONED DISK TABLE
    qdTableElement          tableElement;   /* temporary struct */
    qcmColumn *             columnDef;
    qcParseTree *           commonParseTree;
    qdStackParseTree *      stackParseTree;
    qdSystemSetParseTree *  systemSetParseTree;
    qdSetParseTree *        setParseTree;
    qdIndexParseTree *      indexParseTree;
    qdPartitionedIndex *    partIndex; /* PROJ-1502 */
    qdSequenceParseTree *   seqParseTree;
    qdSequenceOptions *     sequenceOptions;
    qdUserParseTree *       userParseTree;
    qdDropParseTree *       dropParseTree;
    qdTransParseTree *      transParseTree;
    qdSystemParseTree *     systemParseTree;
    qdConstraintSpec *      constraintSpec;
    qdReferenceSpec *       referenceSpec;
    qdGrantParseTree *      grantParseTree;
    qdRevokeParseTree *     revokeParseTree;
    qdDatabaseParseTree *   databaseParseTree;
    qdCreateTBSParseTree *  createTBSParseTree;
    qdAlterTBSParseTree *   alterTBSParseTree;
    qdDropTBSParseTree *    dropTBSParseTree;
    qdUserOptions *         userOptions;
    qdUserPasswOptions *    userPasswOptions; /* PROJ-2207 Password policy support*/
    qdTableOptions *        tableOptions;
    qdTablePhysicalAttr *   tablePhysicalAttr;
    qdTTL *                 ttl;
    qdSegStorageAttr *      attrNode;
    qdLobAttribute *        lobAttribute;
    qdLobStorageAttribute * lobStorageAttribute;
    qdTBSFileNames *        filename;
    qdTBSFilesSpec *        diskFilesSpec;
    qdTBSBackupState        tbsBackupState;
    qdBackupTargetSpec *    backupTargetSpec;
    qdBackupParseTree *     backupParseTree;
    qdWithTagSpec *         withTagSpec;
    qdTablespaceList *      tbsList;
    qdChangeTrackingParseTree * changeTrackingParseTree;
    qdRecoverSpec *         recoverSpec;
    qdRestoreTargetSpec *   restoreTargetSpec;
    qdRestoreParseTree *    restoreParseTree;
    qdMediaRecoveryParseTree *  mediaRecoveryParseTree;
    qdChangeMoveBackupParseTree * changeMoveBackupParseTree;
    smiDataFileAttr *       dataFileAttr;
    qdCreateTBSOptions *    createTBSOptions;
    qmmInsParseTree *       insParseTree;
    qmmDelParseTree *       delParseTree;
    qmmUptParseTree *       uptParseTree;
    qmmMoveParseTree *      moveParseTree;
    qmmSetClause            setClause;  /* temporary struct */
    qmmValueNode *          valueNode;
    qmmLockParseTree *      lockParseTree;
    qmmLockSPParseTree *    lockSPParseTree;  /* BUG-48345 Lock procedure statement */
    smiTableLockMode        tableLockMode;
    qmsParseTree *          selectParseTree;
    /* PROJ-1584 DML Returning Clause */
    qmmReturnInto *         dmlReturnInto;
    qmmReturnValue *        dmlReturnValue;
    qmmReturnIntoValue *    dmlReturnIntoValue;
    idBool                  dmlBulkCollect;
    qmsLimit *              limit;
    qmsLimitOrLoop *        limitOrLoop;
    qmsForUpdate *          forUpdate;
    qmsSortColumns *        sortColumn;
    qmsSetOpType            setOpType;
    qmsQuerySet *           querySet;
    qmsWithClause *         withClause;
    qmsSFWGH *              SFWGH;
    qmsHierarchy *          hierarchy;
    qmsConnectBy *          connectBy;
    qmsConcatElement*       concatElement;
    qmsSelectType           selectType;
    qmsTarget *             target;
    qmsInto *               into;  // PROJ-1584 DML return clause
    qmsFrom *               from;
    qmsPivot *              pivot;
    qmsPivotAggr *          pivotAggr;
    qmsUnpivot *            unpivot;          // PROJ-2523 Unpivot clause
    qmsUnpivotInNode *      unpivotInNode;    // PROJ-2523 Unpivot clause    
    qmsUnpivotInColInfo *   unpivotInColInfo; // PROJ-2523 Unpivot clause
    qmsUnpivotColName *     unpivotColName;   // PROJ-2523 Unpivot clause
    qmsPivotOrUnpivot       pivotOrUnpivot;   // PROJ-2523 Unpivot clause
    qmsDumpObjList *        dumpObjList;
    qmsJoinType             joinType;
    qmsTableRef *           tableRef;
    qmsPartitionRef *       partitionRef; // PROJ-1502 PARTITIONED DISK TABLE
    qriParseTree *          replParseTree;
    qriReplConnOpt *        replConnOpt;      // BUG-45984 Replication support of InfiniBand
    qriReplHost *           replHost;
    qriReplItem *           replItem;
    qriReplDirPath *        replDirPath;        /* BUG-31703 ټ ɼ  */
    qriReplApplierBuffer *  replApplierBuffer;
    qriReplOptions *        replOptions;        // PROJ-1915
    qriReplStartOption*     replStartOption;
    qriSessionParseTree*    replSessionParseTree;
    // stored procedure ( execution nodes )
    qspDataType *           spDataType;
    qsInOutType             spParamInout;
    qsNocopyType            spParamNocopy;
    qsExceptions *          spExceptions;
    qsProcStmts *           spStmts;
    qsProcStmtBlock *       spBlock;
    qsVariableItems *       spItemDecls;
    qsVariables *           spVarDefs;
    qsCursors *             spCurDefs;
    // PROJ-1075 UDT
    qsTypes *               spTypeDefs;
    qsExceptionDefs *       spExcpDefs;
    qsExceptionHandlers *   spExcpHdlrs;
    qsPragmaExceptionInit * spPragmaExcepInit; /* BUG-41240 EXCEPTION_INIT Pragma */
    qspCommonLoop *         spCommonLoop;
    qsProcStmtSql *         spSql;
    qsProcStmtIf *          spIf;
    qsProcStmtThen *        spThen;
    qsProcStmtElse *        spElse;
    qsProcStmtWhile *       spWhile;
    qsProcStmtFor *         spFor;
    qsProcStmtCursorFor *   spCurFor;
    qsProcStmtExit *        spExit;
    qsProcStmtContinue *    spContinue;
    qsProcStmtGoto *        spGoto;
    qsProcStmtLabel *       spLabel;
    qsProcStmtNull *        spNull;
    qsProcStmtOpen *        spOpen;
    qsProcStmtFetch *       spFetch;
    qsProcStmtClose *       spClose;
    qsProcStmtAssign *      spAssign;
    qsProcStmtRaise *       spRaise;
    qsProcStmtReturn *      spReturn;
    qsProcStmtExecImm *     spExecImm;
    qsProcStmtOpenFor *     spOpenFor;
    qsProcStmtException *   spExceptionBlock;        // BUG-37501
    qsUsingParam *          spUsingParam;
    // stored procedure ( DML )
    qsExecParseTree *       spExecParseTree;
    // stored procedure ( DDL )
    qsProcParseTree *       spParseTree;
    qsAlterParseTree *      spAlterParseTree;
    qsDropParseTree *       spDropParseTree;
    qmsHints *              hints;
    qdPrivileges *          privilege;
    qdGrantees *            grantee;

    // PROJ-1073 Package
    qsPkgStmtBlock *             pkgBlock;
    qsPkgSubprograms *           pkgSubprograms;
    qsPkgStmts *                 pkgStmts;
    qsPkgParseTree *             pkgParseTree;
    qsAlterPkgParseTree *        pkgAlterParseTree;
    qsDropPkgParseTree *         pkgDropParseTree;
    qsRestrictReferences *       pragmaRestrictReferences;
    qsRestrictReferencesOption * pragmaRestrictReferencesOption; 

    // limit host variable
    qmsLimitValue           limitValue;

    // PROJ-1359 Trigger
    qdnCreateTriggerParseTree * spCreateTrigger;
    qdnAlterTriggerParseTree  * spAlterTrigger;
    qdnDropTriggerParseTree   * spDropTrigger;
    qdnTriggerEvent           * spTriggerEvent;
    qdnTriggerEventTypeList   * spTriggerEventTypeList;
    qcmTriggerEventTime         sTriggerEventTime;
    UInt                        sTriggerEventType;
    qdnTriggerRef             * spTriggerReference;
    qdnTriggerActionCond        sTriggerActionCond;
    qdnTriggerAlterOption       sTriggerAlterOption;

    // PROJ-1149 Online-Backup & Media Recovery
    qdUntilSpec               * untilSpec; /* temporary struct */
    qdFromTagSpec             * fromTagSpec;
    qdOptionFlags               optionFlags; /* temporary struct */

    rpFlushOption               replFlushOption;

    // PROJ-1371 DIRECTORY
    qdDirectoryParseTree      * directoryParseTree;

    // Proj-1076 Synonym
    qdSynonymParseTree          * createSynonym;
    qdSynonymParseTree          * dropSynonym;

    // PROJ-1552 recovery point
    qsRecPointParseTree         * recPointParseTree;

    // To Fix BUG-13364
    qdIndexAttribute            * indexAttributes;

    // fix BUG-18937
    qdIndexAttrAndLocalIndex    * indexAttrAndLocalIndex;

    // PROJ-1548
    smiChkptPathAttrList        * chkptPathAttrList;
    qdAlterChkptPath            * alterChkptPath;

    // To fix BUG-17642
    qmsCaseExpr                 * caseExpr;
    qmsWhenThenList             * whenThenList;

    // TASK-2398 Log Compress
    // Create/Alter Tablespace   Tablespace Flag List
    qdTBSAttrFlagList           * tbsAttrFlagList;
    // Create/Alter Table   Table Flag List
    qdTableAttrFlagList         * tableAttrFlagList;
    qdTableRowMovement          * tableRowMovement;
    qdTableMaxRows              * tableMaxRows;
    UInt                        * loggingMode;

    // PROJ-1579 NCHAR
    qdCharacterSet              * charSetOpt;

    // PROJ-1762
    qtcOver                     * overClause;
    qtcOverColumn               * overColumn;

    /* PROJ-1805 */
    qtcWindow                   * window;
    qtcWindowPoint              * windowPoint;
    qtcWindowValue              * windowValue;

    // BUG-21387 COMMENT
    qdCommentParseTree          * commentParseTree;

    // PROJ-2002 Column Security
    qdExtColumnAttr             * extColumnAttr;

    // PROJ-1874 FK Novalidate
    qdConstraintState           * constraintState;

    // PROJ-1407 Temporary Table
    qdTemporaryOption           * temporaryOption;

    /* PROJ-2211 Materialized View */
    qdMViewBuildRefresh           mviewBuildRefresh;
    qdMViewRefreshTime            mviewRefreshTime;

    /* Proj-1715 */
    qmsOrderBy                  * orderBy;
    /* PROJ-1988 Implement MERGE statement */
    qmmMergeParseTree           * mergeParseTree;
    qmmMergeActions               mergeActions;

    /* PROJ-1090 Function-based Index */
    qdSortMode                    sortMode;
    qdColumnWithPosition        * columnWithPosition;

    // PROJ-1685
    qlParseTree                 * libParseTree;
    qlAlterParseTree            * libAlterParseTree;
    qlDropParseTree             * libDropParseTree;
    qsCallSpec                  * expCallSpec;
    qsCallSpecParam             * expCallSpecParam;

    /* BUG-36350 Updatable Join DML WITH READ ONLY */
    idBool                        isWithReadOnly;

    /* PROJ-1832 New database link */
    idBool                        publicFlag;
    qdkDatabaseLinkCreateParseTree * createDatabaseLinkParseTree;
    qdkRemoteDatabaseUserParseTree * remoteDatabaseUserParseTree;
    qdkDatabaseLinkDropParseTree   * dropDatabaseLinkParseTree;
    qdkDatabaseLinkAlterParseTree  * alterDatabaseLinkParseTree;
    qdkDatabaseLinkCloseParseTree  * closeDatabaseLinkParseTree;

    // PROJ-2223 audit
    qdcAuditParseTree           * auditParseTree;
    qdcNoAuditParseTree         * noAuditParseTree;
    /* BUG-39074 */
    qdcDelAuditParseTree        * delAuditParseTree;
    qdcAuditOperation           * auditOperation;
    qdStartOption                 startOption;

    // PROJ-2264 Dictionary table
    qcmCompressionColumn        * compressionColumn;

    /* PROJ-1438 Job Scheduler */
    qdJobParseTree              * jobParseTree;
    qtcJobInterval              * jobInterval;
    idBool                        jobEnable; // BUG-41713 each job enable disable
    
    /* PROJ-2359 Table/Partition Access Option */
    qcmAccessOption               accessOption;
    
    /* BUG-38946 position */
    qdOuterJoinOper             * outerJoinOper;

    /* PROJ-2435 order by nulls first/last */
    qmsNullsOption                nullsOption;

    /* PROJ-1812 ROLE */
    qmmJobOrRoleParseTree         jobOrRoleParseTree;

    // PROJ-2527 WITHIN GROUP AGGR
    qtcWithinGroup              * withinGroup;

    /* PROJ-1810 Partition Exchange */
    qdDisjoinTableParseTree     * disjoinTableParseTree;
    qdDisjoinTable              * disjoinTable;

    /* BUG-42764 Multi Row */
    qmmMultiRows                * multiRows;

    /* BUG-42883 alter index parser  */
    qdIndexTypeAndDirectKey       indexTypeAndDirectKey;

    // BUG-42989 Create trigger with enable/disable option.
    qcmTriggerAble                triggerAble;

    // PROJ-2528 Keep Aggregation
    qtcKeepAggr                 * keepAggr;

    // BUG-44710
    qcShardStmtSpec               shardStmtSpec;

    // BUG-45359
    qcShardNodes                * shardNodes;

    /* BUG-45921 */
    qdQueueSequenceParseTree    * queueSequenceParseTree;

    /* PROJ-2701 Sharding online data rebuild */
    qciStmtType                   stmtKind;

    qcNamePosList               * delNameList;

    qsProcType                    procType;

    // BUG-47790
    qdShardParseTree            * shardParseTree;
    qdReShardAttribute          * reShardAttr;

    // TASK-4703
    qcmShardFlag                  shardFlag;
}

//-------------------------------------------------------
// To Fix PR-10566
// [TOKEN ߰   ]
//    TOKEN ߰ , ش Token Column Name
//       ؾ Ѵ.
// TOKEN ߰    ݵ ؼϿ Ѵ.
//    - column_name RULE TOKEN column   ֵ .
//    - TC/Server/qp4/Bugs/PR-10566/   Test Case߰
//    - qcpUtil.cpp reservedWordTables TOKEN ߰ ؾ մϴ.
//-------------------------------------------------------

%token E_ERROR

//%token TR_ABSOLUTE
//%token TR_ACTION
%token TR_ADD
//%token TR_ADMIN
%token TR_AFTER
%token TR_AGER
//%token TR_AGGREGATE
//%token TR_ALIAS
%token TR_ALL
//%token TR_ALLOCATE
%token TR_ALTER
%token TR_ALTER_USER           // BUG-36769
%token TR_AND
%token TR_ANY
%token TR_ARCHIVE
%token TR_ARCHIVELOG
//%token TR_ARE
//%token TR_ARRAY
%token TR_AS
%token TR_ASC
//%token TR_ASSERTION
%token TR_AT
%token TR_AUTHID      /* BUG-45306 PSM AUTHID */
//%token TR_AUTHORIZATION
%token TR_AUTOEXTEND
%token TR_BACKUP
%token TR_BEFORE
%token TR_BEGIN
//%token TR_BINARY
//%token TR_BIT
//%token TR_BLOB
%token TR_BODY               // PROJ-1073 Package
//%token TR_BOOLEAN
//%token TR_BOTH
//%token TR_BREADTH
%token TR_BY
//%token TR_CALL
%token TR_CASCADE
//%token TR_CASCADED
%token TR_CASE
%token TR_CAST
//%token TR_CATALOG
//%token TR_CHAR
//%token TR_CHARACTER
%token TR_CHECK_OPENING_PARENTHESIS
//%token TR_CLASS
//%token TR_CLOB
%token TR_CHECKPOINT
%token TR_SHRINK_MEMPOOL
%token TR_DUMP_CALLSTACKS
%token TR_CLOSE
%token TR_COALESCE
//%token TR_COLLATE
//%token TR_COLLATION
%token TR_COLUMN
%token TR_COMMENT            // BUG-21387
%token TR_COMMIT
%token TR_COMPILE
//%token TR_COMPLETION
//%token TR_CONDITION
%token TR_CONNECT
//%token TR_CONNECTION
%token TR_CONSTRAINT
%token TR_CONSTRAINTS
//%token TR_CONSTRUCTOR
//%token TR_CONTAINS
%token TR_CONTINUE
//%token TR_CORRESPONDING
%token TR_CREATE
%token TR_CREATE_USER            // BUG-36769
%token TR_VOLATILE
%token TR_CROSS                  /* PROJ-2418 */
%token TR_CUBE
//%token TR_CURRENT
//%token TR_CURRENT_DATE
//%token TR_CURRENT_PATH
//%token TR_CURRENT_ROLE
//%token TR_CURRENT_TIME
//%token TR_CURRENT_TIMESTAMP
%token TR_CURRENT_USER      /* BUG-45306 PSM AUTHID */
%token TR_CURSOR
%token TR_CYCLE
//%token TR_DATA
%token TR_DATABASE
//%token TR_DATE
//%token TR_DAY
//%token TR_DEALLOCATE
//%token TR_DEC
//%token TR_DECIMAL
%token TR_DECLARE
%token TR_DEFAULT
//%token TR_DEFERRABLE
//%token TR_DEFERRED
%token TR_DEFINER      /* BUG-45306 PSM AUTHID */
%token TR_DELETE
//%token TR_DEPTH
//%token TR_DEREF
//Proj-1360 Queue
%token TR_DEQUEUE
%token TR_DESC
//%token TR_DESCRIBE
//%token TR_DESCRIPTOR
//%token TR_DESTROY
//%token TR_DESTRUCTOR
%token TR_DETERMINISTIC
//%token TR_DICTIONARY
//%token TR_DIAGNOSTICS
%token TR_DIRECTORY
%token TR_DISABLE
%token TR_DISASTER          // BUG-37372
%token TR_DISCONNECT
%token TR_DISTINCT
//%token TR_DO
//%token TR_DOMAIN
//%token TR_DOUBLE
%token TR_DROP
%token TR_DROP_USER               // BUG-36769
//%token TR_DYNAMIC
%token TR_EACH
%token TR_ELSE
%token TR_ELSEIF
%token TR_ENABLE
%token TR_END
//%token TR_END_EXEC
//%token TR_EQUALS
%token TR_ENQUEUE
%token TR_ESCAPE
//%token TR_EVERY
//%token TR_EXCEPT
%token TR_EXCEPTION
%token TR_EXEC
%token TR_EXECUTE
%token TR_EXIT
//%token TR_EXPAND
//%token TR_EXPANDING
//%token TR_EXTERNAL
%token TR_FALSE
%token TR_FETCH
%token TR_FIFO
//%token TR_FIRST
//%token TR_FLOAT
%token TR_FLUSH
%token TR_FLUSHER
%token TR_FOR
%token TR_FOREIGN
//%token TR_FOUND
%token TR_FROM
//%token TR_FREE
%token TR_FULL
%token TR_FUNCTION
//%token TR_GENERAL
//%token TR_GLOBAL
//%token TR_GO
%token TR_GOTO
%token TR_GRANT
%token TR_GROUP
//%token TR_GROUPING
//%token TR_HANDLER
%token TR_HAVING
//%token TR_HASH
//%token TR_HOUR
//%token TR_IDENTITY
%token TR_IF
//%token TR_IGNORE
//%token TR_IMMEDIATE
%token TR_IN
//%token TR_INDICATOR
//%token TR_INITIALIZE
//%token TR_INITIALLY
%token TR_INNER
//%token TR_INOUT
//%token TR_INPUT
%token TR_INSERT
//%token TR_INT
//%token TR_INTEGER
%token TR_INTERSECT
//%token TR_INTERVAL
%token TR_INTO
%token TR_IS
%token TR_ISOLATION
//%token TR_ITERATE
%token TR_JOIN
%token TR_KEY
//%token TR_LANGUAGE
//%token TR_LARGE
//%token TR_LAST
//%token TR_LEADING
//%token TR_LEAVE
%token TR_LEFT
%token TR_LESS
%token TR_LEVEL
%token TR_LIFO
%token TR_LIKE
%token TR_LIMIT
//%token TR_LITERAL
%token TR_LOCAL
%token TR_LOCALUNIQUE
//%token TR_LOCALTIME
//%token TR_LOCALTIMESTAMP
//%token TR_LOCATOR
%token TR_LOGANCHOR
%token TR_LOOP
//%token TR_MATCH
//%token TR_MEETS
%token TR_MERGE
//%token TR_MINUTE
//%token TR_MODIFIES
%token TR_MODIFY
//%token TR_MONTH
%token TR_MOVE
%token TR_MOVEMENT
//%token TR_NAMES
//%token TR_NATIONAL
//%token TR_NATURAL
//%token TR_NCHAR
//%token TR_NCLOB
%token TR_NEW
//%token TR_NEXT
//%token TR_NO
%token TR_NOARCHIVELOG
%token TR_NOCOPY
%token TR_NOCYCLE
//%token TR_NONE
//%token TR_NORMALIZE
%token TR_NOT
%token TR_NULL
//%token TL_NUMERIC
//%token TR_OBJECT
%token TR_OF
%token TR_OFF
%token TR_OLD
%token TR_ON
%token TR_OPEN
//%token TR_OPERATION
//%token TR_OPTION
%token  TR_OR
%token TR_ORDER
//%token TR_ORDINALITY
%token TR_OUT
%token TR_OUTER
//%token TR_OUTPUT
//%token TR_PAD
//%token TR_PARAMETER
//%token TR_PARAMETERS
//%token TR_PARTIAL
//%token TR_PATH
//%token TR_PERIOD
//%token TR_POSTFIX
//%token TR_PRECEDES
//%token TR_PRECISION
//%token TR_PREFIX
//%token TR_PREORDER
//%token TR_PREPARE
//%token TR_PRESERVE
%token TR_PACKAGE            // PROJ-1073 Package
%token TR_PARTITION
%token TR_PARTITIONS
%token TR_PRAGMA_AUTONOMOUS_TRANSACTION /* BUG-38509 autonomous transaction */
%token TR_PRAGMA_EXCEPTION_INIT         /* BUG-41240 EXCEPTION_INIT Pragma */
%token TR_PRAGMA_RESTRICT_REFERENCES
%token TR_PRIMARY
%token TR_PRIOR
%token TR_PRIVILEGES
%token TR_PROCEDURE
%token TR_QUEUE
%token TR_READ
//%token TR_READS
//%token TR_REAL
%token TR_REBUILD
%token TR_RECOVER
//%token TR_RECURSIVE
//%token TR_REDO
//%token TR_REF
%token TR_REFERENCES
%token TR_REFERENCING
//%token TR_RELATIVE
%token TR_REMOVE            // BUG-37372
//%token TR_REPEAT
//%token TR_RESIGNAL
//%token TR_RESTRICT
//%token TR_RESULT
%token TR_RETURN
//%token TR_RETURNS
%token TR_REVOKE
%token TR_RIGHT
%token TR_ROLLBACK
%token TR_ROLLUP
//%token TR_ROUTINE
%token TR_ROW
%token TR_ROWNUM
%token TR_SAVEPOINT
//%token TR_SCHEMA
//%token TR_SCROLL
//%token TR_SEARCH
///%token TR_SECOND
//%token TR_SECTION
%token TR_SELECT
%token TR_SEQUENCE
%token TR_SESSION
//%token TR_SESSION_USER
%token TR_SET
//%token TR_SETS
//%token TR_SIGNAL
//%token TR_SIZE
//%token TR_SMALLINT
%token TR_SOME
//%token TR_SPACE
//%token TR_SPECIFIC
%token TR_SPECIFICATION      // PROJ-1073 Package
//%token TR_SPECIFICTYPE
//%token TR_SQL
//%token TR_SQLEXECEPTION
//%token TR_SQLSTATE
//%token TR_SQLWARNING
%token TR_SPLIT
%token TR_START
//%token TR_STATE
%token TR_STATEMENT
//%token TR_STATIC
//%token TR_STRUTURE
//%token TR_SUCCEEDS
%token TR_SUPPLEMENTAL
//%token TR_SYSTEM_USER
%token TR_SYNONYM
%token TR_TABLE
%token TR_TEMPORARY
//%token TR_TERMINATE
%token TR_THAN
%token TR_THEN
//%token TR_TIME
//%token TR_TIMESTAMP
//%token TR_TIMEZONE_HOUR
//%token TR_TIMEZONE_MINUTE
%token TR_TO
//%token TR_TRAILING
//%token TR_TRANSACTION
//%token TR_TRANSLATION
//%token TR_TREAT
%token TR_TRIGGER
%token TR_TRUE
%token TR_TYPE         // PROJ-1075
%token TR_TYPESET      // PROJ-1075
//%token TR_UNDER
//%token TR_UNDO
%token TR_UNION
%token TR_UNIQUE
//%token TR_UNKNOWN
%token TR_UNTIL
%token TR_UPDATE
//%token TR_USAGE
//%token TR_USER
%token TR_USING
//%token TR_VALUE
%token TR_VALUES
//%token TR_VARCHAR
%token TR_VARIABLE
%token TR_VARIABLE_LARGE
//%token TR_VARING
%token TR_VIEW
%token TR_WHEN
%token TR_WHENEVER
%token TR_WHERE
%token TR_WHILE
%token TR_WITH
//%token TR_WITHOUT
%token TR_WORK
%token TR_WRITE
//%token TR_YEAR
//%token TR_ZONE
%token TR_LOGGING             // For PROJ-1469
%token TR_NOLOGGING           // For PROJ-1469
%token TR_PARALLEL            // to fix BUG-13127
%token TR_NOPARALLEL          // to fix BUG-13127
%token TR_LOB                 // PROJ-1362
%token TR_STORE               // PROJ-1362
%token TR_INITRANS            // PROJ-1704 MVCC Renewal
%token TR_MAXTRANS            // PROJ-1704 MVCC Renewal

%token TR_COMPRESSED          // For TASK-2398 Log Compress
%token TR_UNCOMPRESSED        // For TASK-2398 Log Compress
%token TA_COMPRESS            // PROJ-2264 Dictionary table
%token TA_REORGANIZE          // PROJ-2264 Dictionary table
%token TR_OVER                // PROJ-1762
%token TR__PROWID             // PROJ-1789 PROWID
%token TR_LINK                /* PROJ-1832 New database link */

%token TR_INSTEAD             // PROJ-1888 instead of trigger
%token TR_RETURNING            /* PROJ-1584 DML Returning Clause */
%token TR_GROUPING_SETS       /* PROJ-1353 */
%token TR_PRECEDING           /* PROJ-1805 */
%token TR_FOLLOWING           /* PROJ-1805 */
%token TR_CURRENT_ROW         /* PROJ-1805 */
%token TR_LATERAL             /* PROJ-2418 */
%token TR_APPLY               /* PROJ-2418 */
%token TR_WITHIN              // PROJ-2527 WITHIN GROUP AGGR
%token TR_WRAPPED             /* PROJ-2550 PSM Encryption */

%token TK_BETWEEN
%token TK_EXISTS
//%token TK_SYSTEM

%token TO_CONSTANT
%token TO_IDENTIFIED
%token TO_INDEX
%token TO_MINUS
%token TO_MODE
%token TO_OTHERS
%token TO_RAISE
%token TO_RENAME
%token TO_REPLACE
%token TO_ROWTYPE
%token TO_WAIT
%token TO_EXTENT
%token TO_SEGMENT
%token TO_STORAGE
%token TO_PIVOT
%token TO_UNPIVOT /* PROJ-2523 Unpivot clause */
%token TO_MATERIALIZED
%token TO_CONNECT_BY_NOCYCLE     /* PROJ-1715 */
%token TO_CONNECT_BY_ROOT        /* PROJ-1715 */
%token TO_LIBRARY    // PROJ-1685
%token TO_LANGUAGE   // PROJ-1685
%token TO_PARAMETERS // PROJ-1685
%token TO_AUDIT    // PROJ-2223 audit
%token TO_NOAUDIT  // PROJ-2223 audit
%token TO_ACCESS   // PROJ-2223 audit
%token TO_DELAUDIT // BUG-39074
%token TO_NULLS    /* PROJ-2435 order by nulls first/last */
%token TO_IGNORE_NULLS  /* BUG-40279 lead, lag with ignore nulls */
%token TO_PURGE    /* PROJ-2441 flashback */
%token TO_FLASHBACK
%token TO_VC2COLL // BUG-41310
%token TO_KEEP    /* PROJ-2528 Keep Aggregation */

%token TA_ELSIF
%token TA_EXTENTSIZE
%token TA_FIXED
%token TA_LOCK
%token TA_UNLOCK /*PROJ-2207 Password policy support */
%token TA_MAXROWS
//%token TA_NATIVE
%token TA_ONLINE
%token TA_OFFLINE
%token TA_REPLICATION
%token TA_IN_REVERSE
%token TA_ROWCOUNT
%token TA_STEP
%token TA_TABLESPACE
%token TA_TRUNCATE
%token TA_SQLCODE
%token TA_SQLERRM
%token TA_DECRYPT             // PROJ-2002
%token TA_BULK                /* PROJ-1584 DML Returning Clause */
%token TA_LINKER              /* PROJ-1832 New database link */
%token TA_REMOTE_TABLE        /* PROJ-1832 New database link */
%token TA_REMOTE_TABLE_STORE  /* BUG-37077 */
%token TA_SHARD   /* PROJ-2638 */
%token TA_NODE_META  /* BUG-44710 */
%token TA_NODE_DATA  /* BUG-44710 */
%token TA_DISJOIN /* PROJ-1810 Partition Exchange */
%token TA_CONJOIN /* BUG-42468 JOIN TO CONJOIN */
%token TA_ANALYSIS_PROPAGATION // BUG-46095

%token TI_NONQUOTED_IDENTIFIER
%token TI_QUOTED_IDENTIFIER
%token TI_HOSTVARIABLE

%token TL_TYPED_LITERAL
%token TL_LITERAL
%token TL_NCHAR_LITERAL     // PROJ-1579 NCHAR
%token TL_UNICODE_LITERAL   // PROJ-1579 NCHAR
%token TL_INTEGER
%token TL_NUMERIC

%token TS_CONCATENATION_SIGN
%token TS_DOUBLE_PERIOD

%token TS_EXCLAMATION_POINT
%token TS_PERCENT_SIGN
%token TS_OPENING_PARENTHESIS
%token TS_CLOSING_PARENTHESIS
%token TS_OPENING_BRACKET
%token TS_CLOSING_BRACKET
%token TS_ASTERISK
%token TS_PLUS_SIGN
%token TS_COMMA
%token TS_MINUS_SIGN
%token TS_PERIOD
%token TS_SLASH
%token TS_COLON
%token TS_SEMICOLON
%token TS_LESS_THAN_SIGN
%token TS_EQUAL_SIGN
%token TS_GREATER_THAN_SIGN
%token TS_QUESTION_MARK
%token TS_OUTER_JOIN_OPERATOR    // PROJ-1653 Outer Join Operator (+)
%token TS_AT_SIGN
%token TS_NAMED_ASSOCIATE_SIGN   /* BUG-41243 Name-based Argument Passing */
%token TM_TOP                    /* BUG-36580 supported TOP */
%token TM_TOP_ALL
%token TX_HINTS
%token TC_WITH_ROLLUP

%{
#include <idl.h>
#include <ideErrorMgr.h>
#include <iduMemory.h>
#include <qcuError.h>
#include <qc.h>
#include <qdParseTree.h>
#include <qmmParseTree.h>
#include <qmsParseTree.h>
#include <qriParseTree.h>
#include <qsParseTree.h>

extern int qcpllex(YYSTYPE * lvalp, void * param );

#define YYPARSE_PARAM param
#define YYLEX_PARAM   param

#undef yyerror
#define yyerror(msg) qcplerror((YYPARSE_PARAM), (msg))

static void qcplerror(void *, const SChar *);

%}

%%
sql_stmt
    /* session parameter */
    : alter_session_set_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = $<commonParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    // PROJ-2727 
    | shard_stmt_spec alter_session_set_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = $<commonParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;

          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    /* system */
    | alter_system_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<systemParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    // PROJ-2727 
    | shard_stmt_spec alter_system_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<systemParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;

          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    /* set */
    | set_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<setParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SET;
      }
    /* transaction */
    | commit_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_COMMIT;
      }
    | rollback_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;

          /* BUG-48216 */
          if ( QC_IS_NULL_NAME( $<transParseTree>1->savepointName ) == ID_TRUE )
          {
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_ROLLBACK;
          }
          else
          {
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_ROLLBACK_TO_SAVEPOINT;
          }
      }
    | savepoint_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SAVEPOINT;
      }
    | set_transaction_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SET_TX;
      }
    /* commit force */
    | commit_force_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<systemSetParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    /* rollback force */
    | rollback_force_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<systemSetParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    /* PROJ-1832 New database link - commit force database link */
    | commit_force_database_link_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind =
              QCI_STMT_COMMIT_FORCE_DATABASE_LINK;
      }
    /* PROJ-1832 New database link - rollback force database link */
    | rollback_force_database_link_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<transParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind =
              QCI_STMT_ROLLBACK_FORCE_DATABASE_LINK;
      }

    /* connect */
    | connect_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<userParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CONNECT;
      }
    | disconnect_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<userParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DISCONNECT;
      }
    /* user */
    | create_user_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<userParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | alter_user_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<userParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    /* privileges */
    | grant_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<grantParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | revoke_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<revokeParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    /* REPLICATION */
    | replication_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<replParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    /* DDL */
    | create_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | get_default_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<defaultParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    // PROJ-1502 PARTITIONED DISK TABLE
    | get_partcondval_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<partCondValParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | get_condition_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<defaultParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    // PROJ-2415 Grouping Sets Clause For parsePartialForQuerySet()
    | get_partial_select_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
      }
    // PROJ-2415 Grouping Sets Clause For parsePartialForOrderBy()
    | get_target_list_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;          
      }
    /* TASK-7219 */
    | get_partial_where_clause semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
      }
    | alter_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_table_constraint_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | rename_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | flashback_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | disjoin_table_statement semicolon_option
      {     
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<disjoinTableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }     
    | join_table_statement semicolon_option
      {     
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | truncate_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | create_index_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<indexParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | create_sequence_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<seqParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | create_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | create_or_replace_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_sequence_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<seqParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_index_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<indexParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | purge_table_statement semicolon_option
    {
        STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
        STATEMENT->myPlan->parseTree->stmt = STATEMENT;
        STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
    }
    | drop_index_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_sequence_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_user_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | drop_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    /* for PROJ-1371 DIRECTORY */
    | create_or_replace_directory_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<directoryParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | drop_directory_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<directoryParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
      /* for BUG-21387 COMMENT */
    | comment_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<commentParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_COMMENT;
      }
    | alter_database_shard_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<shardParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SHARD_DDL;
      }

    /* DML */
    | delete_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<delParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DELETE;
      }
    | insert_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<insParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_INSERT;
      }
    | update_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<uptParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_UPDATE;
      }
    | move_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<moveParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_MOVE;
      }
    | select_or_with_select_statement opt_for_update_clause opt_with_read_only semicolon_option
      {
          $<selectParseTree>1->forUpdate = $<forUpdate>2;

          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          if ( $<selectParseTree>1->forUpdate == NULL )
          {
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              // PROJ-1362
              // for update ִ 
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          QCP_ADJUST_LAST_POSITION( STATEMENT->myPlan->parseTree->stmtPos );
      }
    | lock_table_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<lockParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_LOCK_TABLE;
      }
    /* BUG-48345 Lock procedure statement */
    | lock_procedure_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<lockSPParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_LOCK_SP;
      }
    /* PROJ-1988 Implement MERGE statement */
    | merge_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<mergeParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_MERGE;
      }
    /* PROJ-2638 shard table */
    | shard_stmt_spec delete_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<delParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DELETE;
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    | shard_stmt_spec insert_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<insParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_INSERT;
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    | shard_stmt_spec update_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<uptParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_UPDATE;
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    | shard_stmt_spec select_or_with_select_statement opt_for_update_clause opt_with_read_only semicolon_option
      {
          $<selectParseTree>2->forUpdate = $<forUpdate>3;

          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          if ( $<selectParseTree>2->forUpdate == NULL )
          {
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              // PROJ-1362
              // for update ִ 
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          QCP_ADJUST_LAST_POSITION( STATEMENT->myPlan->parseTree->stmtPos );
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    /* PROCEDURE and FUNCTION */
    | SP_create_or_replace_procedure_statement semicolon_option
      {
          if ( $<spParseTree>1 != NULL )
          {
              STATEMENT->myPlan->parseTree = (qcParseTree*)$<spParseTree>1;
              STATEMENT->myPlan->parseTree->stmt = STATEMENT;
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CRT_SP;
          }
          else
          {
              /* PROJ-2550 PSM Encryption
                 encrypted text  parsing  parser tree  ʴ´. */

              /* Nothing to do. */
          }
      }
    | SP_create_or_replace_function_statement semicolon_option
      {
          if ( $<spParseTree>1 != NULL )
          {
              STATEMENT->myPlan->parseTree = (qcParseTree*)$<spParseTree>1;
              STATEMENT->myPlan->parseTree->stmt = STATEMENT;
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CRT_SP;
          }
          else
          {
              /* PROJ-2550 PSM Encryption
                 encrypted text  parsing  parser tree  ʴ´. */

              /* Nothing to do. */
          }
      }
    | SP_create_or_replace_typeset_statement semicolon_option
      {
          if ( $<spParseTree>1 != NULL )
          {
              STATEMENT->myPlan->parseTree = (qcParseTree*)$<spParseTree>1;
              STATEMENT->myPlan->parseTree->stmt = STATEMENT;
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CRT_SP;
          }
          else
          {
              /* PROJ-2550 PSM Encryption
                 encrypted text  parsing  parser tree  ʴ´. */

              /* Nothing to do. */
          }
      }
    // PROJ-1073 Package
    | SP_create_or_replace_package_statement semicolon_option
      {
          if ( $<pkgParseTree>1 != NULL )
          {
              STATEMENT->myPlan->parseTree = (qcParseTree*)$<pkgParseTree>1;
              STATEMENT->myPlan->parseTree->stmt = STATEMENT;
              STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CRT_SP;
          }
          else
          {
              /* PROJ-2550 PSM Encryption
                 encrypted text  parsing  parser tree  ʴ´. */

              /* Nothing to do. */
          }
      }
    | SP_alter_procedure_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spAlterParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | SP_alter_function_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spAlterParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    // PROJ-1073 Package
    | SP_alter_package_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<pkgAlterParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | SP_drop_procedure_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spDropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | SP_drop_function_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spDropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    // PROJ-1075 typeset
    | SP_drop_typeset_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spDropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    // PROJ-1073 Package
    | SP_drop_package_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<pkgDropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | SP_execute_proc_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spExecParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_EXEC_PROC;
      }
    | shard_stmt_spec SP_execute_proc_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spExecParseTree>2;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_EXEC_PROC;
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              STATEMENT->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              STATEMENT->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;
          }
      }
    | SP_execute_func_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spExecParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_EXEC_FUNC;
      }
    // PROJ-1073 Package
    | SP_execute_pkg_assign_argu_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spExecParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_EXEC_FUNC;
      }
    /* Database */
    | create_database_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<databaseParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CREATE_DB;
      }
    | alter_database_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<databaseParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_ALTER_DB;
      }
    | drop_database_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<databaseParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DROP_DB;
      }
    /* TableSpace */
    | create_tablespace_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<createTBSParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | create_temp_tablespace_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<createTBSParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | alter_tablespace_ddl_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<alterTBSParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    | alter_tablespace_dcl_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<alterTBSParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
      }
    | drop_tablespace_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropTBSParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NON_SCHEMA_DDL;
      }
    /* PROJ-1359 TRIGGER */
    | create_trigger_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spCreateTrigger>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_trigger_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spAlterTrigger>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_trigger_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<spDropTrigger>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    // Proj-1076 Synonym
    | create_synonym_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<createSynonym>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_synonym_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropSynonym>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    // Proj-1360 Queue
    | create_queue_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_queue_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_queue_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | dequeue_statement opt_fifo opt_wait_clause semicolon_option
      {
          qmsQueue *sQueue;
          QCP_STRUCT_ALLOC(sQueue, qmsQueue);
          sQueue->isFifo = $<boolType>2;
          sQueue->waitSec  = $<uLongVal>3 ;
          sQueue->tableID  = 0;
          $<selectParseTree>1->queue = sQueue;

          QCP_STRUCT_ALLOC($<forUpdate>$, qmsForUpdate);
          $<forUpdate>$->lockWaitMicroSec = 0;
          $<forUpdate>$->isQueue = ID_TRUE;
          $<forUpdate>$->isMoveAndDelete = ID_FALSE;
          $<selectParseTree>1->forUpdate = $<forUpdate>$;

          STATEMENT->myPlan->parseTree = (qcParseTree*)$<selectParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DEQUEUE;
      }
    | enqueue_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<insParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_ENQUEUE;
      }
    | create_materialized_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_materialized_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_materialized_view_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<dropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    // PROJ-1685
    | create_or_replace_library_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<libParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_library_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<libAlterParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_library_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<libDropParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    /* PROJ-1832 New database link */
    | create_database_link_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree *)$<createDatabaseLinkParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_database_link_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree *)$<dropDatabaseLinkParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_database_link_statement
      {
          STATEMENT->myPlan->parseTree = (qcParseTree *)$<alterDatabaseLinkParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CONTROL_DATABASE_LINKER;
      }
    | close_database_link_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree *)$<closeDatabaseLinkParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_CLOSE_DATABASE_LINK;
      }
    // PROJ-2223 audit
    | audit_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_AUDIT_OPTION;
      }
    | noaudit_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_NOAUDIT_OPTION;
      }
    /* BUG-39074 */
    | delaudit_statement semicolon_option
      {
          STATEMENT->myPlan->parseTree = (qcParseTree*)$<tableParseTree>1;
          STATEMENT->myPlan->parseTree->stmt = STATEMENT;
          STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_DELAUDIT_OPTION;
      }
    /* PROJ-1438 Job Scheduler */
    | create_job_or_role_statement semicolon_option
    {
        /* PROJ-1812 ROLE */  
        if ( $<jobOrRoleParseTree>1.jobParseTree != NULL )
        {
            STATEMENT->myPlan->parseTree = (qcParseTree *)$<jobOrRoleParseTree>1.jobParseTree;
        }
        else if ( $<jobOrRoleParseTree>1.userParseTree != NULL )
        {
            STATEMENT->myPlan->parseTree = (qcParseTree *)$<jobOrRoleParseTree>1.userParseTree;
        }
        else
        {
            /* Nothing To Do */
        }

        STATEMENT->myPlan->parseTree->stmt = STATEMENT;
        STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | alter_job_statement semicolon_option
      {
        STATEMENT->myPlan->parseTree = (qcParseTree *)$<jobParseTree>1;
        STATEMENT->myPlan->parseTree->stmt = STATEMENT;
        STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | drop_job_or_role_statement semicolon_option
    {
        /* PROJ-1812 ROLE */  
        if ( $<jobOrRoleParseTree>1.jobParseTree != NULL )
        {
            STATEMENT->myPlan->parseTree = (qcParseTree *)$<jobOrRoleParseTree>1.jobParseTree;
        }
        else if ( $<jobOrRoleParseTree>1.dropParseTree != NULL )
        {
            STATEMENT->myPlan->parseTree = (qcParseTree *)$<jobOrRoleParseTree>1.dropParseTree;
        }
        else
        {
            /* Nothing To Do */
        }
          
        STATEMENT->myPlan->parseTree->stmt = STATEMENT;
        STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_SCHEMA_DDL;
      }
    | anonymous_block semicolon_option
      {
        STATEMENT->myPlan->parseTree = (qcParseTree*)$<spParseTree>1;
        STATEMENT->myPlan->parseTree->stmt = STATEMENT;
        STATEMENT->myPlan->parseTree->stmtKind = QCI_STMT_EXEC_AB;
      }
    ;

SP_declaration_option
    : /* NULL */
      {
        $<boolType>$ = ID_FALSE;
      }
    | TR_DECLARE
      {
        $<boolType>$ = ID_TRUE;
      }
    | TR_AS
      {
        $<boolType>$ = ID_TRUE;
      }
    | TR_IS
      {
        $<boolType>$ = ID_TRUE;
      }
    ;

SP_label_option
    : SP_label_statement
      {
          $<spStmts>$ = (qsProcStmts*) $<spLabel>1;
      }
    | /* NULL */
      {
          $<spStmts>$ = NULL;
      }
    ;

anonymous_block
    : SP_label_option SP_declaration_option SP_first_block SP_name_option
      {
        mtcColumn        * sCursorColumn;
        qtcNode          * sCursorTypeNode[2];
        qcuSqlSourceInfo   sqlInfo;
        qsLabels         * sLabel;

        QCP_STRUCT_ALLOC($<spParseTree>$, qsProcParseTree);
        QC_SET_INIT_PARSE_TREE($<spParseTree>$, $<position>1);
        QS_PROC_PARSE_TREE_INIT($<spParseTree>$);

        $<spParseTree>$->objType = QS_PROC;

        $<spParseTree>$->procNamePos.stmtText = (SChar*)"ANONYMOUS_BLOCK";
        $<spParseTree>$->procNamePos.offset   = 0;
        $<spParseTree>$->procNamePos.size     = idlOS::strlen($<spParseTree>$->procNamePos.stmtText);

        $<spParseTree>$->returnTypeVar    = NULL ;
        $<spParseTree>$->returnTypeModule = NULL ;
        $<spParseTree>$->returnTypeColumn = NULL ;

        $<spParseTree>$->paraDecls      = NULL;
        $<spParseTree>$->block = $<spBlock>3;

        if ( ($<boolType>2 == ID_FALSE) &&
             $<spParseTree>$->block->variableItems != NULL )
        {
            sqlInfo.setSourceInfo( STATEMENT, &$<spParseTree>$->block->variableItems->name );
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                     sqlInfo.getErrMessage() ));
            sqlInfo.fini();
            YYABORT;
        }

        if ( $<spStmts>1 != NULL )
        {
            QCP_STRUCT_ALLOC( sLabel, qsLabels );
            SET_POSITION( sLabel->namePos, ((qsProcStmtLabel*)$<spStmts>1)->labelNamePos );
            sLabel->id = 0;
            sLabel->stmt = NULL;
            sLabel->next = NULL;
            $<spParseTree>$->block->common.parentLabels = sLabel;
        }

        $<spParseTree>$->expCallSpec    = NULL;
        $<spParseTree>$->procType       = QS_NORMAL;

        $<spParseTree>$->paraDeclCount  = 0;
        $<spParseTree>$->isDefiner      = ID_FALSE;

        // BUG-21761
        $<spParseTree>$->ncharList = NCHARLIST;

        // create SQL cursor
        QCP_TEST( qtc::createColumn( STATEMENT,
                                     &qtc::spCursorModule,
                                     &sCursorColumn,
                                     0, NULL, NULL, 1 )
                  != IDE_SUCCESS );

        QCP_TEST( qtc::makeProcVariable( STATEMENT,
                                         sCursorTypeNode,
                                         &( $<spParseTree>$->procNamePos ),
                                         sCursorColumn,
                                         QTC_PROC_VAR_OP_NEXT_COLUMN )
                  != IDE_SUCCESS );

        $<spParseTree>$->sqlCursorTypeNode = sCursorTypeNode[0];

        $<spParseTree>$->common.parse    = qsv::parseAB;
        $<spParseTree>$->common.validate = qsv::validateAB;
        $<spParseTree>$->common.optimize = qso::optimizeCreate;
        $<spParseTree>$->common.execute  = qsx::executeAB;
      }
      ;

semicolon_option
    : /* empty */
      {
          /* nothing to do */
      }
    | TS_SEMICOLON
      {
          /* nothing to do */
      }
    ;

/* the following names are included in user_object_name */
/*
table_name
view_name
sequence_name
index_name
queue_name
function_name
procedure_name
*/

/*
role_name
replication_name
constraint_name
user_name
property_name
savepoint_name
password_name
library_name
module_name
cursor_name
counter_name
argument_name
variable_name
label_name
exception_name
native_procedure_group_name
*/

// BUG-9020
TI_IDENTIFIER
    : TI_NONQUOTED_IDENTIFIER
    | TI_QUOTED_IDENTIFIER
      {
          $<position>$.stmtText = QTEXT;
          $<position>$.offset   = $<position>1.offset + 1;
          $<position>$.size     = $<position>1.size - 2;
      }
    ;

// To Fix PR-10566
// ش TOKEN Column Name   ,
// ҹڸ  ʵ UPPER CASE Ѵ.
column_name
    : TI_IDENTIFIER
    | TR_AGER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ARCHIVE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ARCHIVELOG
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_BACKUP
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CAST
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COMPILE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DIRECTORY
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DISABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DISASTER   // BUG-37372
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DETERMINISTIC
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ENABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FLUSH
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LEFT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LIMIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LOGANCHOR
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_MOVE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_NOARCHIVELOG
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_READ
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_RECOVER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_REMOVE     // BUG-37372
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_RIGHT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_ROWCOUNT
      {
          // To Fix PR-12941
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SYNONYM
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_UNTIL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_USING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LOGGING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_NOLOGGING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PARALLEL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ENQUEUE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_QUEUE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DEQUEUE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FIFO
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LIFO
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_NOPARALLEL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_STEP
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SEQUENCE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_TYPE // PROJ-1075
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_TYPESET // PROJ-1075
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LOB  // PROJ-1362
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_STORE // PROJ-1362
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_AT         // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LESS       // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_THAN       // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_MOVEMENT   // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COALESCE   // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_MERGE      // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PARTITIONS // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SPLIT      // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_REBUILD    // PROJ-1502 PARTITIONED DISK TABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_AUTOEXTEND
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CHECKPOINT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SHRINK_MEMPOOL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DUMP_CALLSTACKS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_VOLATILE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    // To fix BUG-17647
    | TR_OPEN
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    // To fix BUG-17647
    | TR_CLOSE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COMPRESSED // TASK-2398 Log Compress
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_UNCOMPRESSED // TASK-2398 Log Compress
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    //To fix BUG-22412
    | TO_SEGMENT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_MODIFY // PROJ-1877
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COMMENT // BUG-21387
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_DECRYPT // PROJ-2002
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    // BUG-27407
    | TA_ELSIF
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_EXTENTSIZE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_FIXED
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_MAXROWS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_OFFLINE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_ONLINE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_TRUNCATE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_EXTENT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_OTHERS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_RAISE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_REPLACE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_ROWTYPE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_STORAGE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_WAIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_PIVOT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    // PROJ-2523 Unpivot Clause
    | TO_UNPIVOT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_MATERIALIZED
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    // PROJ-1685
    | TO_LIBRARY
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_LANGUAGE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_PARAMETERS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_AUDIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_NOAUDIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_DELAUDIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_ACCESS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_AFTER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_BEFORE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_BEGIN
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CASCADE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COMMIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CONSTRAINTS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CONTINUE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CURSOR
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CYCLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DATABASE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DECLARE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DISCONNECT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_EACH
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ELSEIF
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_END
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ESCAPE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_EXEC
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_EXECUTE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_EXIT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FETCH
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FLUSHER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FULL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FUNCTION
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_GOTO
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_IF
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_INITRANS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_INNER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ISOLATION
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_JOIN
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LOCAL
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LOOP
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_MAXTRANS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_NOCYCLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_OFF
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_OUTER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_OVER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PROCEDURE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_REFERENCES
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_REFERENCING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_RETURN
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_REVOKE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ROLLBACK
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SAVEPOINT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_STATEMENT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_TEMPORARY
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_VARIABLE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_VARIABLE_LARGE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_WHILE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_WORK
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_WRITE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_KEY
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_ROLLUP
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CUBE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PRECEDING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_FOLLOWING
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_LINK /* PROJ-1832 New database link */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_REMOTE_TABLE /* PROJ-1832 New database link */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_REMOTE_TABLE_STORE /* BUG-37077 REMOTE_TABLE_STORE */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_SHARD /* PROJ-2638 */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_LINKER /* PROJ-1832 New database link */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_WHENEVER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PACKAGE   /* PROJ-1073 */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_SPECIFICATION
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_BODY
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_NULLS /* PROJ-2435 order by nulls first/last */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_PURGE /* PROJ-2441 flashback */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_FLASHBACK /* PROJ-2441 flashback */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_DISJOIN /* PROJ-1810 Partition Exchange */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TA_CONJOIN /* PROJ-1810 Partition Exchange */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_KEEP // PROJ-2528 Keep Aggregation
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_AUTHID
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_CURRENT_USER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_DEFINER
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    ;

// PROJ-1075 member built-in function  keyword 
// associative array Ǵ member function
// COUNT, DELETE, EXISTS, FIRST, LAST, NEXT, PRIOR
memberfunc_name
    : TR_DELETE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TK_EXISTS
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_PRIOR
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    ;

// BUG-15242
// keyword function   
keyword_function_name
    : TR_UNION
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_REPLACE
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_CONNECT_BY_ROOT
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_COALESCE /* BUG-36736 */
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TR_WITHIN // PROJ-2527 WITHIN GROUP AGGR
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    | TO_KEEP // PROJ-2528 Keep Aggregation
      {
          idlOS::strUpper( QTEXT + $<position>1.offset, $<position>1.size );
      }
    ;

alter_session_set_statement
    : TR_ALTER TR_SESSION TR_SET TA_REPLICATION TS_EQUAL_SIGN TR_TRUE
      {
          QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
          QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
          $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

          $<replSessionParseTree>$->common.parse    = qcc::parse;
          $<replSessionParseTree>$->common.validate = qcc::validate;
          $<replSessionParseTree>$->common.optimize = qcc::optimize;
          $<replSessionParseTree>$->common.execute  = qcc::execute;
          $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_DEFAULT;
      }
    | TR_ALTER TR_SESSION TR_SET TA_REPLICATION TS_EQUAL_SIGN TR_FALSE
      {
          QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
          QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
          $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

          $<replSessionParseTree>$->common.parse    = qcc::parse;
          $<replSessionParseTree>$->common.validate = qcc::validate;
          $<replSessionParseTree>$->common.optimize = qcc::optimize;
          $<replSessionParseTree>$->common.execute  = qcc::execute;
          $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_NONE;
      }
    | TR_ALTER TR_SESSION TR_SET TA_REPLICATION TS_EQUAL_SIGN TR_DEFAULT
      {
          QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
          QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
          $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

          $<replSessionParseTree>$->common.parse    = qcc::parse;
          $<replSessionParseTree>$->common.validate = qcc::validate;
          $<replSessionParseTree>$->common.optimize = qcc::optimize;
          $<replSessionParseTree>$->common.execute  = qcc::execute;
          $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_DEFAULT;
      }
    | TR_ALTER TR_SESSION TR_SET TA_REPLICATION TS_EQUAL_SIGN TI_NONQUOTED_IDENTIFIER//PROJ-1541
      {
          qcuSqlSourceInfo    sqlInfo;

          if ((idlOS::strMatch(
               "EAGER", 5,
               QTEXT+$<position>6.offset, $<position>6.size) == 0))
          {
              QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
              QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
              $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

              $<replSessionParseTree>$->common.parse    = qcc::parse;
              $<replSessionParseTree>$->common.validate = qcc::validate;
              $<replSessionParseTree>$->common.optimize = qcc::optimize;
              $<replSessionParseTree>$->common.execute  = qcc::execute;
              $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_NOT_SUPPORT;
          }
          else if (idlOS::strMatch(
                "LAZY", 4,
                QTEXT+$<position>6.offset, $<position>6.size) == 0)
          {
              QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
              QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
              $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

              $<replSessionParseTree>$->common.parse    = qcc::parse;
              $<replSessionParseTree>$->common.validate = qcc::validate;
              $<replSessionParseTree>$->common.optimize = qcc::optimize;
              $<replSessionParseTree>$->common.execute  = qcc::execute;
              $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_NOT_SUPPORT;
          }
          else if (idlOS::strMatch(
                "ACKED", 5,
                QTEXT+$<position>6.offset, $<position>6.size) == 0)
          {
              QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
              QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
              $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

              $<replSessionParseTree>$->common.parse    = qcc::parse;
              $<replSessionParseTree>$->common.validate = qcc::validate;
              $<replSessionParseTree>$->common.optimize = qcc::optimize;
              $<replSessionParseTree>$->common.execute  = qcc::execute;
              $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_NOT_SUPPORT;
          }
          else if (idlOS::strMatch("NONE", 4, QTEXT+$<position>6.offset,
                    $<position>6.size) == 0)
          {
              QCP_STRUCT_ALLOC($<replSessionParseTree>$, qriSessionParseTree);
              QC_SET_INIT_PARSE_TREE($<replSessionParseTree>$, $<position>1);
              $<replSessionParseTree>$->common.stmtKind = QCI_STMT_SET_REPLICATION_MODE;

              $<replSessionParseTree>$->common.parse    = qcc::parse;
              $<replSessionParseTree>$->common.validate = qcc::validate;
              $<replSessionParseTree>$->common.optimize = qcc::optimize;
              $<replSessionParseTree>$->common.execute  = qcc::execute;
              $<replSessionParseTree>$->replModeFlag    = SMI_TRANSACTION_REPL_NONE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>6 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TR_TRUE
      /* ALTER SESSION SET AUTOCOMMIT = TRUE */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "AUTOCOMMIT", 10,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
               QCP_STRUCT_ALLOC($<commonParseTree>$, qcParseTree);
               QC_SET_INIT_PARSE_TREE($<commonParseTree>$, $<position>1);
               $<commonParseTree>$->stmtKind = QCI_STMT_SET_AUTOCOMMIT_TRUE;

               $<commonParseTree>$->parse    = qcc::parse;
               $<commonParseTree>$->validate = qcc::validate;
               $<commonParseTree>$->optimize = qcc::optimize;
               $<commonParseTree>$->execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TR_FALSE
      /* ALTER SESSION SET AUTOCOMMIT = FALSE */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "AUTOCOMMIT", 10,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
               QCP_STRUCT_ALLOC($<commonParseTree>$, qcParseTree);
               QC_SET_INIT_PARSE_TREE($<commonParseTree>$, $<position>1);
               $<commonParseTree>$->stmtKind = QCI_STMT_SET_AUTOCOMMIT_FALSE;

               $<commonParseTree>$->parse    = qcc::parse;
               $<commonParseTree>$->validate = qcc::validate;
               $<commonParseTree>$->optimize = qcc::optimize;
               $<commonParseTree>$->execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_EQUAL_SIGN TI_NONQUOTED_IDENTIFIER
      /* ALTER SESSION SET EXPLAIN PLAN = ONLY */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "EXPLAIN", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0 &&
              idlOS::strMatch(
                "PLAN", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0 &&
              idlOS::strMatch(
                "ONLY", 4,
                QTEXT+$<position>7.offset, $<position>7.size) == 0)
          {
               QCP_STRUCT_ALLOC($<commonParseTree>$, qcParseTree);
               QC_SET_INIT_PARSE_TREE($<commonParseTree>$, $<position>1);
               $<commonParseTree>$->stmtKind = QCI_STMT_SET_PLAN_DISPLAY_ONLY;

               $<commonParseTree>$->parse    = qcc::parse;
               $<commonParseTree>$->validate = qcc::validate;
               $<commonParseTree>$->optimize = qcc::optimize;
               $<commonParseTree>$->execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_EQUAL_SIGN TR_ON
      /* ALTER SESSION SET EXPLAIN PLAN = ON */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "EXPLAIN", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0 &&
              idlOS::strMatch(
                "PLAN", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
          {
               QCP_STRUCT_ALLOC($<commonParseTree>$, qcParseTree);
               QC_SET_INIT_PARSE_TREE($<commonParseTree>$, $<position>1);
               $<commonParseTree>$->stmtKind = QCI_STMT_SET_PLAN_DISPLAY_ON;

               $<commonParseTree>$->parse    = qcc::parse;
               $<commonParseTree>$->validate = qcc::validate;
               $<commonParseTree>$->optimize = qcc::optimize;
               $<commonParseTree>$->execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_EQUAL_SIGN TR_OFF
      /* ALTER SESSION SET EXPLAIN PLAN = OFF */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "EXPLAIN", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0 &&
              idlOS::strMatch(
                "PLAN", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
          {
               QCP_STRUCT_ALLOC($<commonParseTree>$, qcParseTree);
               QC_SET_INIT_PARSE_TREE($<commonParseTree>$, $<position>1);
               $<commonParseTree>$->stmtKind = QCI_STMT_SET_PLAN_DISPLAY_OFF;

               $<commonParseTree>$->parse    = qcc::parse;
               $<commonParseTree>$->validate = qcc::validate;
               $<commonParseTree>$->optimize = qcc::optimize;
               $<commonParseTree>$->execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TL_INTEGER
      /* ALTER SESSION SET property = integer */
      {
          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind = QCI_STMT_SET_SESSION_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4);
          SET_POSITION( $<systemSetParseTree>$->value, $<position>6);

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qcc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qcc::execute;
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TL_LITERAL
      /* ALTER SESSION SET DEFAULT_DATE_FORMAT = 'literal' */
      {
          qcNamePosition sValuePosition;

          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind = QCI_STMT_SET_SESSION_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4) ;
          sValuePosition.stmtText = QTEXT;
          sValuePosition.offset   = $<position>6.offset + 1;
          sValuePosition.size     = $<position>6.size - 2;
          SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qcc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qcc::execute;
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_EQUAL_SIGN TL_INTEGER
      /* ALTER SESSION SET STACK SIZE = integer */
      {
          SLong               sStackSize;
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "STACK", 5,
                QTEXT+$<position>4.offset, $<position>4.size) == 0 &&
              idlOS::strMatch(
                "SIZE", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
          {
               QCP_STRUCT_ALLOC($<stackParseTree>$, qdStackParseTree);
               QC_SET_INIT_PARSE_TREE($<stackParseTree>$, $<position>1);
               $<stackParseTree>$->common.stmtKind = QCI_STMT_SET_STACK;

               if( qtc::getBigint( QTEXT, &sStackSize, &$<position>7 ) != IDE_SUCCESS )
               {
                   YYABORT;
               }

               $<stackParseTree>$->stackSize = sStackSize;

               $<stackParseTree>$->common.parse    = qcc::parse;
               $<stackParseTree>$->common.validate = qcc::validate;
               $<stackParseTree>$->common.optimize = qcc::optimize;
               $<stackParseTree>$->common.execute  = qcc::execute;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER transaction_mode
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "TRANSACTION", 11,
                QTEXT+$<position>4.offset, $<position>4.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          $<transParseTree>$ = $<transParseTree>5;
          $<transParseTree>$->isSession       = ID_TRUE;
          $<transParseTree>$->common.stmtKind = QCI_STMT_SET_TX;
          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN
      TI_NONQUOTED_IDENTIFIER
      {
        QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
        QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
        $<systemSetParseTree>$->common.stmtKind = QCI_STMT_SET_SESSION_PROPERTY;

        SET_POSITION( $<systemSetParseTree>$->name, $<position>4) ;
        SET_POSITION( $<systemSetParseTree>$->value, $<position>6 );

        $<systemSetParseTree>$->common.parse    = qcc::parse;
        $<systemSetParseTree>$->common.validate = qcc::validate;
        $<systemSetParseTree>$->common.optimize = qcc::optimize;
        $<systemSetParseTree>$->common.execute  = qcc::execute;
      }
    | TR_ALTER TR_SESSION TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TS_MINUS_SIGN TL_INTEGER
      {
        qcNamePosition sValuePosition;
        QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
        QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
        $<systemSetParseTree>$->common.stmtKind = QCI_STMT_SET_SESSION_PROPERTY;

        SET_POSITION( $<systemSetParseTree>$->name, $<position>4) ;

        sValuePosition.stmtText = QTEXT;
        sValuePosition.offset   = $<position>6.offset;
        sValuePosition.size     = $<position>7.size +
        $<position>7.offset - $<position>6.offset;
        SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

        $<systemSetParseTree>$->common.parse    = qcc::parse;
        $<systemSetParseTree>$->common.validate = qcc::validate;
        $<systemSetParseTree>$->common.optimize = qcc::optimize;
        $<systemSetParseTree>$->common.execute  = qcc::execute;
      }
    ;

alter_system_statement
    : TR_ALTER TI_NONQUOTED_IDENTIFIER TR_CHECKPOINT
      /* ALTER SYSTEM CHECKPOINT */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;
          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_CHKPT;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_SHRINK_MEMPOOL
      /* ALTER SYSTEM SHRINK_MEMPOOL */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;
          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_SHRINK_MEMPOOL;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_DUMP_CALLSTACKS
      /* ALTER SYSTEM DUMP_CALLSTACKS(BUG-45182)*/
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;
          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_DUMP_CALLSTACKS;
      }
    // PROJ-2264 Dictionary table
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TA_REORGANIZE
      /* ALTER SYSTEM REORGANIZE */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;

          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_REORGANIZE;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM COMPACT    */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                "VERIFY", 6,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind =
                  QCI_STMT_ALT_SYS_VERIFY;
          }
          else if (idlOS::strMatch(
                "COMPACT", 7,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM MEMORY COMPACT */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if ( (idlOS::strMatch(
                "MEMORY", 6,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
               && (idlOS::strMatch(
                "COMPACT", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0) )
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_MEMORY_COMPACT;
          }
          else if ( (idlOS::strMatch(
                "SWITCH", 6,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
               && (idlOS::strMatch(
                "LOGFILE", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0) )
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_SWITCH_LOGFILE;
          }
          else if ( (idlOS::strMatch(
                "COMPACT", 7,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
               && (idlOS::strMatch(
                "SQL_PLAN_CACHE", 14,
                QTEXT+$<position>4.offset, $<position>4.size) == 0) )
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_COMPACT_PLAN_CACHE;
          }
          else if ( (idlOS::strMatch(
                "RESET", 5,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
               && (idlOS::strMatch(
                "SQL_PLAN_CACHE", 14,
                QTEXT+$<position>4.offset, $<position>4.size) == 0) )
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_RESET_PLAN_CACHE;
          }
          else if ( (idlOS::strMatch(
                "STOP", 4,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
               && (idlOS::strMatch(
                "SECURITY", 8,
                QTEXT+$<position>4.offset, $<position>4.size) == 0) )
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_SECURITY;
              $<systemParseTree>$->startOption     = QDP_OPTION_STOP;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TO_AUDIT
      /* ALTER SYSTEM STOP AUDIT */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          if (idlOS::strMatch(
                  "STOP", 4,
                  QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_AUDIT;
              $<systemParseTree>$->startOption     = QDP_OPTION_STOP;
          }
          else if (idlOS::strMatch(
                       "RELOAD", 6,
                       QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_AUDIT;
              $<systemParseTree>$->startOption     = QDP_OPTION_RELOAD;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_START TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM START SECURITY */
      {
          qcuSqlSourceInfo  sqlInfo;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                  sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                "SECURITY", 8,
                QTEXT+$<position>4.offset, $<position>4.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                  sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;

          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_SECURITY;
          $<systemParseTree>$->startOption     = QDP_OPTION_START;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_START TO_AUDIT
      /* ALTER SYSTEM START AUDIT */
      {
          qcuSqlSourceInfo  sqlInfo;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                  sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;

          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_AUDIT;
          $<systemParseTree>$->startOption     = QDP_OPTION_START;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_FLUSH TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM FLUSH BUFFER_POOL */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if (idlOS::strMatch(
                  "BUFFER_POOL", 11,
                  QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_FLUSH_BUFFER_POOL;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_REBUILD TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM REBUILD MIN_VIEWSCN*/
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                  "MIN_VIEWSCN", 11,
                  QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
              QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

              $<systemParseTree>$->common.parse    = qcc::parse;
              $<systemParseTree>$->common.validate = qdc::validate;
              $<systemParseTree>$->common.optimize = qcc::optimize;
              $<systemParseTree>$->common.execute  = qdc::execute;

              $<systemParseTree>$->common.stmtKind =
                                   QCI_STMT_ALT_SYS_REBUILD_MIN_VIEWSCN;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_ARCHIVE TI_NONQUOTED_IDENTIFIER archivelog_start_option
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if (idlOS::strMatch(
                "LOG", 3,
                QTEXT+$<position>4.offset, $<position>4.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);

          // set archivelog_start_option
          $<systemParseTree>$->startArchivelog = $<boolType>5;

          // set function pointer
          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;

          $<systemParseTree>$->common.stmtKind = QCI_STMT_ALT_SYS_ARCHIVELOG;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_SET TI_IDENTIFIER TS_EQUAL_SIGN TL_INTEGER
      /* ALTER SYSTEM SET property = integer */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind =
              QCI_STMT_SET_SYSTEM_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4);
          SET_POSITION( $<systemSetParseTree>$->value, $<position>6);

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_SET TI_IDENTIFIER TS_EQUAL_SIGN TS_MINUS_SIGN TL_INTEGER
      /* ALTER SYSTEM SET property = - integer */
      {
          qcuSqlSourceInfo    sqlInfo;
          qcNamePosition sValuePosition;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind =
              QCI_STMT_SET_SYSTEM_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4);

          sValuePosition.stmtText = QTEXT;
          sValuePosition.offset   = $<position>6.offset;
          sValuePosition.size     = $<position>7.size +
              $<position>7.offset - $<position>6.offset;

          SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_SET TI_IDENTIFIER TS_EQUAL_SIGN TI_IDENTIFIER
      /* ALTER SYSTEM SET property = identifier */
      {
          qcuSqlSourceInfo    sqlInfo;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind =
              QCI_STMT_SET_SYSTEM_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4);
          SET_POSITION( $<systemSetParseTree>$->value, $<position>6);

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TR_SET TI_IDENTIFIER TS_EQUAL_SIGN TL_LITERAL
      /* ALTER SYSTEM SET property = 'literal' */
      {
          qcuSqlSourceInfo    sqlInfo;
          qcNamePosition sValuePosition;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind =
              QCI_STMT_SET_SYSTEM_PROPERTY;

          SET_POSITION( $<systemSetParseTree>$->name, $<position>4);

          sValuePosition.stmtText = QTEXT;
          sValuePosition.offset   = $<position>6.offset + 1;
          sValuePosition.size     = $<position>6.size - 2;

          SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER flusher_start_option TR_FLUSHER TL_INTEGER
      /* ALTER SYSTEM START/STOP FLUSHER integer */
      {
          qcuSqlSourceInfo  sqlInfo;
          SLong             sFlusherID;
          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if( qtc::getBigint( QTEXT, &sFlusherID, &$<position>5 ) != IDE_SUCCESS )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemParseTree>$, qdSystemParseTree);
          QC_SET_INIT_PARSE_TREE($<systemParseTree>$, $<position>1);
          $<systemParseTree>$->common.stmtKind =
              QCI_STMT_FLUSHER_ONOFF;

          $<systemParseTree>$->common.parse    = qcc::parse;
          $<systemParseTree>$->common.validate = qdc::validate;
          $<systemParseTree>$->common.optimize = qcc::optimize;
          $<systemParseTree>$->common.execute  = qdc::execute;
          $<systemParseTree>$->flusherID       = (UInt)sFlusherID;
          $<systemParseTree>$->startOption     = $<startOption>3;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TO_ACCESS TI_NONQUOTED_IDENTIFIER
      /* ALTER SYSTEM RELOAD ACCESS LIST */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if (idlOS::strMatch(
                "RELOAD", 6,
                QTEXT+$<position>3.offset, $<position>3.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if (idlOS::strMatch(
                "LIST", 4,
                QTEXT+$<position>5.offset, $<position>5.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;

          $<systemSetParseTree>$->common.stmtKind = QCI_STMT_RELOAD_ACCESS_LIST;
      }
    | TR_ALTER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TA_SHARD TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER opt_local
      /* ALTER SYSTEM RELOAD SHARD META NUMBER
       * ALTER SYSTEM RELOAD SHARD META NUMBER LOCAL */
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "SYSTEM", 6,
                                QTEXT + $<position>2.offset, $<position>2.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          if ( idlOS::strMatch( "RELOAD", 6,
                                QTEXT + $<position>3.offset, $<position>3.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          if ( idlOS::strMatch( "META", 4,
                                QTEXT + $<position>5.offset, $<position>5.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          if ( idlOS::strMatch( "NUMBER", 6,
                                QTEXT + $<position>6.offset, $<position>6.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>6 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<systemParseTree>$, qdSystemParseTree );
          QC_SET_INIT_PARSE_TREE( $<systemParseTree>$, $<position>1 );

          $<systemSetParseTree>$->common.stmtKind = $<stmtKind>7;

          $<systemSetParseTree>$->common.parse    = qcc::parse;
          $<systemSetParseTree>$->common.validate = qdc::validate;
          $<systemSetParseTree>$->common.optimize = qcc::optimize;
          $<systemSetParseTree>$->common.execute  = qdc::execute;
      }
    ;

opt_local
    : /* empty */
      {
          $<stmtKind>$ = QCI_STMT_RELOAD_SHARD_META_NUMBER;
      }
    | TR_LOCAL
      {
          $<stmtKind>$ = QCI_STMT_RELOAD_SHARD_META_NUMBER_LOCAL;
      }
    ;

flusher_start_option
    : TR_START
      {
          $<startOption>$ = QDP_OPTION_START;
      }
    | TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch("STOP", 4,
                              QTEXT+$<position>1.offset,
                              $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          $<startOption>$ = QDP_OPTION_STOP;
      }
    ;

archivelog_start_option
    : TR_START
      {
          $<boolType>$ = ID_TRUE;
      }
    | TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch("STOP", 4,
                              QTEXT+$<position>1.offset,
                              $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          $<boolType>$ = ID_FALSE;
      }
    ;

commit_statement
    : TR_COMMIT opt_work_clause
      {
          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    ;

commit_force_statement
    : TR_COMMIT opt_work_clause TI_NONQUOTED_IDENTIFIER TL_LITERAL
      /* COMMIT FORCE 'literal' */
      {
          qcuSqlSourceInfo    sqlInfo;
          qcNamePosition      sValuePosition;

          if (idlOS::strMatch(
                "FORCE", 5,
                QTEXT+$<position>3.offset, $<position>3.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind = QCI_STMT_COMMIT_FORCE;

          sValuePosition.stmtText = QTEXT;
          sValuePosition.offset   = $<position>4.offset + 1;
          sValuePosition.size     = $<position>4.size - 2;
          SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

          $<stackParseTree>$->common.parse    = qcc::parse;
          $<stackParseTree>$->common.validate = qcc::validate;
          $<stackParseTree>$->common.optimize = qcc::optimize;
          $<stackParseTree>$->common.execute  = qcc::execute;
      }
    ;

rollback_force_statement
    : TR_ROLLBACK opt_work_clause TI_NONQUOTED_IDENTIFIER TL_LITERAL
      /* ROLLBACK FORCE 'literal' */
      {
          qcuSqlSourceInfo    sqlInfo;
          qcNamePosition      sValuePosition;

          if (idlOS::strMatch(
                "FORCE", 5,
                QTEXT+$<position>3.offset, $<position>3.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<systemSetParseTree>$, qdSystemSetParseTree);
          QC_SET_INIT_PARSE_TREE($<systemSetParseTree>$, $<position>1);
          $<systemSetParseTree>$->common.stmtKind = QCI_STMT_ROLLBACK_FORCE;

          sValuePosition.stmtText = QTEXT;
          sValuePosition.offset   = $<position>4.offset + 1;
          sValuePosition.size     = $<position>4.size - 2;
          SET_POSITION( $<systemSetParseTree>$->value, sValuePosition );

          $<stackParseTree>$->common.parse    = qcc::parse;
          $<stackParseTree>$->common.validate = qcc::validate;
          $<stackParseTree>$->common.optimize = qcc::optimize;
          $<stackParseTree>$->common.execute  = qcc::execute;
      }
    ;

commit_force_database_link_statement
    : TR_COMMIT opt_work_clause TI_NONQUOTED_IDENTIFIER TR_DATABASE TR_LINK
      /* PROJ-1832 New database link - COMMIT FORCE DATABASE LINK */
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch(
                   "FORCE", 5,
                   QTEXT + $<position>3.offset, $<position>3.size ) != 0 )
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<transParseTree>$, qdTransParseTree );
          QC_SET_INIT_PARSE_TREE( $<transParseTree>$, $<position>1 );

          $<stackParseTree>$->common.parse    = qcc::parse;
          $<stackParseTree>$->common.validate = qcc::validate;
          $<stackParseTree>$->common.optimize = qcc::optimize;
          $<stackParseTree>$->common.execute  = qcc::execute;
      }
    ;

rollback_force_database_link_statement
    : TR_ROLLBACK opt_work_clause TI_NONQUOTED_IDENTIFIER TR_DATABASE TR_LINK
      /* PROJ-1832 New database link - ROLLBACK FORCE DATABASE LINK */
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch(
                   "FORCE", 5,
                   QTEXT + $<position>3.offset, $<position>3.size ) != 0 )
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<transParseTree>$, qdTransParseTree );
          QC_SET_INIT_PARSE_TREE( $<transParseTree>$, $<position>1 );
          
          $<stackParseTree>$->common.parse    = qcc::parse;
          $<stackParseTree>$->common.validate = qcc::validate;
          $<stackParseTree>$->common.optimize = qcc::optimize;
          $<stackParseTree>$->common.execute  = qcc::execute;
      }
    ;

savepoint_statement
    : TR_SAVEPOINT TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // savepoint name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // BUG-28440
          if( $<position>2.size > 1 )
          {
              if( idlOS::strMatch( "$$", 2, QTEXT+$<position>2.offset, 2 ) == 0 )
              {
                  // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          SET_POSITION($<transParseTree>$->savepointName, $<position>2);

          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    ;

rollback_statement
    : TR_ROLLBACK opt_work_clause
      {
          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          SET_EMPTY_POSITION($<transParseTree>$->savepointName);

          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    | TR_ROLLBACK opt_work_clause TR_TO TR_SAVEPOINT TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // savepoint name
          if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          SET_POSITION($<transParseTree>$->savepointName, $<position>5);

          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    ;

opt_work_clause
    : /* empty */
    | TR_WORK
    ;

set_transaction_statement
    : TR_SET TI_NONQUOTED_IDENTIFIER transaction_mode
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "TRANSACTION", 11,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          $<transParseTree>$ = $<transParseTree>3;
          $<transParseTree>$->isSession       = ID_FALSE;
          $<transParseTree>$->common.parse    = qcc::parse;
          $<transParseTree>$->common.validate = qcc::validate;
          $<transParseTree>$->common.optimize = qcc::optimize;
          $<transParseTree>$->common.execute  = qcc::execute;
      }
    ;

transaction_mode
    : TR_READ TI_NONQUOTED_IDENTIFIER
      /* READ ONLY */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "ONLY", 4,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          $<transParseTree>$->maskType  = (UInt)~SMI_TRANSACTION_MASK;
          $<transParseTree>$->maskValue = SMI_TRANSACTION_UNTOUCHABLE;
      }
    | TR_READ TR_WRITE
      {
          QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
          QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

          $<transParseTree>$->maskType  = (UInt)~SMI_TRANSACTION_MASK;
          $<transParseTree>$->maskValue = SMI_TRANSACTION_NORMAL;
      }
    | TR_ISOLATION TR_LEVEL TR_READ TI_NONQUOTED_IDENTIFIER
      /* ISOLATION LEVEL READ COMMITTED   */
      /* ISOLATION LEVEL READ UNCOMMITTED */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "COMMITTED", 9,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
              QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

              $<transParseTree>$->maskType  = (UInt)~SMI_ISOLATION_MASK;
              $<transParseTree>$->maskValue = SMI_ISOLATION_CONSISTENT;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ISOLATION TR_LEVEL TI_NONQUOTED_IDENTIFIER TR_READ
      /* ISOLATION LEVEL REPEATABLE READ */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "REPEATABLE", 10,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
              QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

              // To Fix PR-9756
              $<transParseTree>$->maskType  = (UInt)~SMI_ISOLATION_MASK;
              $<transParseTree>$->maskValue = SMI_ISOLATION_REPEATABLE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_ISOLATION TR_LEVEL TI_NONQUOTED_IDENTIFIER
      /* ISOLATION LEVEL READ SERIALIZABLE */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "SERIALIZABLE", 12,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              QCP_STRUCT_ALLOC($<transParseTree>$, qdTransParseTree);
              QC_SET_INIT_PARSE_TREE($<transParseTree>$, $<position>1);

              $<transParseTree>$->maskType  = (UInt)~SMI_ISOLATION_MASK;
              $<transParseTree>$->maskValue = SMI_ISOLATION_NO_PHANTOM;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

connect_statement
    : TR_CONNECT TI_IDENTIFIER TS_SLASH TI_IDENTIFIER opt_sysdba
      {
          qcuSqlSourceInfo    sqlInfo;

          // user name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // password
          if ($<position>4.size > IDS_MAX_PASSWORD_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userParseTree>$, qdUserParseTree);
          QC_SET_INIT_PARSE_TREE($<userParseTree>$, $<position>1);

          SET_POSITION($<userParseTree>$->userName, $<position>2);
          SET_POSITION($<userParseTree>$->password, $<position>4);
          // to upper case
          QC_PASSWORD_UPPER( $<position>4 );

          $<userParseTree>$->isSysdba = $<boolType>5;

          $<userParseTree>$->common.parse    = qcc::parse;
          $<userParseTree>$->common.validate = qcc::validate;
          $<userParseTree>$->common.optimize = qcc::optimize;
          $<userParseTree>$->common.execute  = qcc::execute;
      }
    ;

opt_sysdba
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_AS TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
              "SYSDBA", 6,
              QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_SYSDBA_OPTION,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

disconnect_statement
    : TR_DISCONNECT
      {
          QCP_STRUCT_ALLOC($<userParseTree>$, qdUserParseTree);
          QC_SET_INIT_PARSE_TREE($<userParseTree>$, $<position>1);

          SET_EMPTY_POSITION($<userParseTree>$->userName);
          SET_EMPTY_POSITION($<userParseTree>$->password);

          $<userParseTree>$->common.parse    = qcc::parse;
          $<userParseTree>$->common.validate = qcc::validate;
          $<userParseTree>$->common.optimize = qcc::optimize;
          $<userParseTree>$->common.execute  = qcc::execute;
      }
    ;

user_object_name
    : TI_IDENTIFIER
      {
          // check objectName length
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              qcuSqlSourceInfo    sqlInfo;
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userNObjName>$, qdUserNObjName);
          SET_EMPTY_POSITION($<userNObjName>$->userName);
          SET_POSITION($<userNObjName>$->objectName, $<position>1);
      }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // check userName length
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // check objectName length
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userNObjName>$, qdUserNObjName);
          SET_POSITION($<userNObjName>$->userName, $<position>1);
          SET_POSITION($<userNObjName>$->objectName, $<position>3);
      }
    ;

// PROJ-1502 PARTITIONED DISK TABLE
//    Ƽ 
opt_partition_name
    : /* empty */
      {
          $<partitionRef>$ = NULL;
      }
    | TR_PARTITION TS_OPENING_PARENTHESIS TI_IDENTIFIER TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<partitionRef>$, qmsPartitionRef);

          QCP_SET_INIT_QMS_PARTITION_REF($<partitionRef>$);

          SET_POSITION($<partitionRef>$->partitionName, $<position>3);
          QCP_ADD_POSITION( $<partitionRef>$->position,
                            $<position>1,
                            $<position>4 )

          // partition name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

create_user_statement
    : TR_CREATE_USER TI_IDENTIFIER TO_IDENTIFIED TR_BY TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // user name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          // password
          if ($<position>5.size > IDS_MAX_PASSWORD_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userParseTree>$, qdUserParseTree);
          QC_SET_INIT_PARSE_TREE($<userParseTree>$, $<position>1);

          SET_POSITION($<userParseTree>$->userName, $<position>2);
          SET_POSITION($<userParseTree>$->password, $<position>5);
          // to upper case
          QC_PASSWORD_UPPER( $<position>5 );

          $<userParseTree>$->accountLock     = QD_ACCOUNT_UNLOCK;
          $<userParseTree>$->passwLimitFlag  = QD_PASSWORD_POLICY_DISABLE;          
          $<userParseTree>$->lockDate        = NULL;          
          $<userParseTree>$->expiryDate      = NULL;
          $<userParseTree>$->failedCount     = 0;
          $<userParseTree>$->reuseCount      = 0;         

          $<userParseTree>$->failLoginAttempts = 0;
          $<userParseTree>$->passwLifeTime     = 0;
          $<userParseTree>$->passwReuseTime    = 0;
          $<userParseTree>$->passwReuseMax     = 0;
          $<userParseTree>$->passwLockTime     = 0;
          $<userParseTree>$->passwGraceTime    = 0;
          SET_EMPTY_POSITION($<userParseTree>$->passwVerifyFunc);           
          
          SET_EMPTY_POSITION($<userParseTree>$->dataTBSName);
          SET_EMPTY_POSITION($<userParseTree>$->tempTBSName);

          $<userParseTree>$->access     = NULL;
          $<userParseTree>$->expLock    = QD_NONE_LOCK;
          $<userParseTree>$->disableTCP = QD_DISABLE_TCP_NONE;

          $<userParseTree>$->common.parse    = qcc::parse;
          $<userParseTree>$->common.validate = qdr::validateCreate;
          $<userParseTree>$->common.optimize = qcc::optimize;
          $<userParseTree>$->common.execute  = qdr::executeCreate;
      }
    | TR_CREATE_USER TI_IDENTIFIER TO_IDENTIFIED TR_BY TI_IDENTIFIER user_options
      {
          qcuSqlSourceInfo     sqlInfo;
          qdUserPasswOptions * sLast;
          
          // user name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          // password
          if ($<position>5.size > IDS_MAX_PASSWORD_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          // password ߺ üũ
          if( $<userOptions>6->password != NULL )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,""));
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userParseTree>$, qdUserParseTree);
          QC_SET_INIT_PARSE_TREE($<userParseTree>$, $<position>1);

          SET_POSITION($<userParseTree>$->userName, $<position>2);
          SET_POSITION($<userParseTree>$->password, $<position>5);
          // to upper case
          QC_PASSWORD_UPPER( $<position>5 );
          
          $<userParseTree>$->accountLock    = QD_ACCOUNT_UNLOCK;         
          $<userParseTree>$->passwLimitFlag = QD_PASSWORD_POLICY_DISABLE;          
          $<userParseTree>$->lockDate       = NULL;          
          $<userParseTree>$->expiryDate     = NULL;
          $<userParseTree>$->failedCount    = 0;
          $<userParseTree>$->reuseCount     = 0;         

          $<userParseTree>$->failLoginAttempts = 0;
          $<userParseTree>$->passwLifeTime     = 0;
          $<userParseTree>$->passwReuseTime    = 0;
          $<userParseTree>$->passwReuseMax     = 0;
          $<userParseTree>$->passwLockTime     = 0;
          $<userParseTree>$->passwGraceTime    = 0;
          SET_EMPTY_POSITION($<userParseTree>$->passwVerifyFunc);
          
          if ( $<userOptions>6->dataTBSName == NULL )
          {
              SET_EMPTY_POSITION($<userParseTree>$->dataTBSName);
          }
          else
          {
              SET_POSITION($<userParseTree>$->dataTBSName,
                           (*($<userOptions>6->dataTBSName)));
          }
          if ( $<userOptions>6->tempTBSName == NULL )
          {
              SET_EMPTY_POSITION($<userParseTree>$->tempTBSName);
          }
          else
          {
              SET_POSITION($<userParseTree>$->tempTBSName,
                           (*($<userOptions>6->tempTBSName)));
          }

          $<userParseTree>$->access  = $<userOptions>6->access;
          
          if( $<userOptions>6->passwOptions != NULL )
          {
              /* password policy  */
              $<userParseTree>$->passwLimitFlag = QD_PASSWORD_POLICY_ENABLE;
                  
              for (sLast = $<userOptions>6->passwOptions;
                   sLast != NULL;
                   sLast = sLast->next)
              {
                  switch ( sLast->passwOptNum )
                  {
                      case QD_FAILED_LOGIN_ATTEMPTS:
                          $<userParseTree>$->failLoginAttempts=
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_LIFE_TIME:
                          $<userParseTree>$->passwLifeTime =
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_REUSE_TIME:
                          $<userParseTree>$->passwReuseTime =
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_REUSE_MAX:
                          $<userParseTree>$->passwReuseMax = 
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_LOCK_TIME:
                          $<userParseTree>$->passwLockTime = 
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_GRACE_TIME:
                          $<userParseTree>$->passwGraceTime =
                              sLast->passwOptValue;
                          break;
                      case QD_PASSWORD_VERIFY_FUNCTION:
                          SET_POSITION( $<userParseTree>$->passwVerifyFunc,
                                        sLast->passwVerifyFuncName);
                          break;
                      default:
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                          YYABORT;
                          break;
                  }
              }
          }
          else
          {
              // Nothing To Do
          }

          $<userParseTree>$->expLock    = QD_NONE_LOCK;
          $<userParseTree>$->disableTCP = $<userOptions>6->disableTCP;

          $<userParseTree>$->common.parse    = qcc::parse;
          $<userParseTree>$->common.validate = qdr::validateCreate;
          $<userParseTree>$->common.optimize = qcc::optimize;
          $<userParseTree>$->common.execute  = qdr::executeCreate;
      }
    ;

alter_user_statement
    : TR_ALTER_USER TI_IDENTIFIER user_option
      {
          qcuSqlSourceInfo     sqlInfo;
          qdUserPasswOptions * sLast;
          
          // user name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userParseTree>$, qdUserParseTree);
          QC_SET_INIT_PARSE_TREE($<userParseTree>$, $<position>1);

          SET_POSITION($<userParseTree>$->userName, $<position>2);

          
          $<userParseTree>$->accountLock    = QD_ACCOUNT_UNLOCK;
          $<userParseTree>$->expLock        = QD_NONE_LOCK;
          $<userParseTree>$->passwLimitFlag = QD_PASSWORD_POLICY_DISABLE;
          $<userParseTree>$->lockDate       = NULL;          
          $<userParseTree>$->expiryDate     = NULL;
          $<userParseTree>$->failedCount    = 0;
          $<userParseTree>$->reuseCount     = 0;
          
          $<userParseTree>$->failLoginAttempts = 0;
          $<userParseTree>$->passwLifeTime     = 0;
          $<userParseTree>$->passwReuseTime    = 0;
          $<userParseTree>$->passwReuseMax     = 0;
          $<userParseTree>$->passwLockTime     = 0;
          $<userParseTree>$->passwGraceTime    = 0;
          $<userParseTree>$->disableTCP        = QD_DISABLE_TCP_NONE;
          SET_EMPTY_POSITION($<userParseTree>$->passwVerifyFunc);
          
          if ( $<userOptions>3 != NULL )
          {
              if ( $<userOptions>3->password == NULL )
              {
                  SET_EMPTY_POSITION($<userParseTree>$->password);
              }
              else
              {
                  SET_POSITION($<userParseTree>$->password,
                               (*($<userOptions>3->password)));
              }
              if ( $<userOptions>3->dataTBSName == NULL )
              {
                  SET_EMPTY_POSITION($<userParseTree>$->dataTBSName);
              }
              else
              {
                  SET_POSITION($<userParseTree>$->dataTBSName,
                               (*($<userOptions>3->dataTBSName)));
              }
              if ( $<userOptions>3->tempTBSName == NULL )
              {
                  SET_EMPTY_POSITION($<userParseTree>$->tempTBSName);
              }
              else
              {
                  SET_POSITION($<userParseTree>$->tempTBSName,
                               (*($<userOptions>3->tempTBSName)));
              }

              if ( $<userOptions>3->passwOptions != NULL )
              {
                  /* password policy  */
                  $<userParseTree>$->passwLimitFlag = QD_PASSWORD_POLICY_ENABLE;
              
                  for (sLast = $<userOptions>3->passwOptions;
                       sLast != NULL;
                       sLast = sLast->next)
                  {
                      switch ( sLast->passwOptNum )
                      {
                          case QD_FAILED_LOGIN_ATTEMPTS:
                              $<userParseTree>$->failLoginAttempts =
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_LIFE_TIME:
                              $<userParseTree>$->passwLifeTime =
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_REUSE_TIME:
                              $<userParseTree>$->passwReuseTime =
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_REUSE_MAX:
                              $<userParseTree>$->passwReuseMax = 
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_LOCK_TIME:
                              $<userParseTree>$->passwLockTime = 
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_GRACE_TIME:
                              $<userParseTree>$->passwGraceTime =
                                  sLast->passwOptValue;
                              break;
                          case QD_PASSWORD_VERIFY_FUNCTION:
                              SET_POSITION( $<userParseTree>$->passwVerifyFunc,
                                            sLast->passwVerifyFuncName);
                              break;
                          default:
                              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                              YYABORT;
                              break;
                      }
                  }
              }
              else
              {
                  // Nothing To Do
              }
                        
              if ($<userOptions>3->expLock == QD_EXPLICITILY_LOCK )
              {
                  /* password policy  ʰ  lock ΰ */
                  $<userParseTree>$->accountLock = QD_ACCOUNT_LOCK;              
              }
              else
              {
                  if ($<userOptions>3->expLock == QD_EXPLICITILY_UNLOCK )
                  {
                      $<userParseTree>$->passwLimitFlag = QD_PASSWORD_POLICY_DISABLE;

                  }
                  else
                  {
                      $<userOptions>3->expLock = QD_NONE_LOCK;
                      // Nothing To Do
                  }
              }
              
              $<userParseTree>$->access     = $<userOptions>3->access;
              $<userParseTree>$->expLock    = $<userOptions>3->expLock;
              $<userParseTree>$->disableTCP = $<userOptions>3->disableTCP;
          }
          else
          {
              // Nothing To Do
          }
          
          $<userParseTree>$->common.parse    = qcc::parse;
          $<userParseTree>$->common.validate = qdr::validateAlter;
          $<userParseTree>$->common.optimize = qcc::optimize;
          $<userParseTree>$->common.execute  = qdr::executeAlter;
      }
    ;

user_options
    : user_options create_user_option
      {
          qdUserTBSAccess    * sTBSAccessLast;
          qdUserPasswOptions * sLast;

          if( ( $<userOptions>$->dataTBSName    != NULL &&
                $<userOptions>2->dataTBSName    != NULL  ) ||
              ( $<userOptions>$->tempTBSName    != NULL &&
                $<userOptions>2->tempTBSName    != NULL  ) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          if( $<userOptions>$->dataTBSName == NULL )
          {
              $<userOptions>$->dataTBSName = $<userOptions>2->dataTBSName;
          }
          if( $<userOptions>$->tempTBSName == NULL )
          {
              $<userOptions>$->tempTBSName = $<userOptions>2->tempTBSName;
          }
          if( $<userOptions>$->access == NULL )
          {
              $<userOptions>$->access = $<userOptions>2->access;
          }
          else
          {
              if( $<userOptions>2->access != NULL )
              {
                for (sTBSAccessLast = $<userOptions>$->access;
                     sTBSAccessLast->next != NULL;
                     sTBSAccessLast = sTBSAccessLast->next)
                    ;
                sTBSAccessLast->next = $<userOptions>2->access;
            }
        }
        if( $<userOptions>$->passwOptions == NULL )
        {
            $<userOptions>$->passwOptions = $<userOptions>2->passwOptions;
        }
        else
        {
            if( $<userOptions>2->passwOptions != NULL )
            {
                for (sLast = $<userOptions>$->passwOptions;
                     sLast->next != NULL;
                     sLast = sLast->next)
                    ;
                sLast->next = $<userOptions>2->passwOptions;
            }
        }
        /* PROJ-2474 TLS/SSL Support */
        if ( $<userOptions>$->disableTCP == QD_DISABLE_TCP_NONE )
        {
            $<userOptions>$->disableTCP = $<userOptions>2->disableTCP;
        }
        else
        {
            /* Nothing to do */
        }
      }
    | create_user_option
      {
          $<userOptions>$ = $<userOptions>1;
      }
    ;

/* PROJ-2207 Password policy support */
user_limit_options
    : TR_LIMIT TS_OPENING_PARENTHESIS user_limit_commalist TS_CLOSING_PARENTHESIS
      {
          $<userOptions>$ = $<userOptions>3;
      }    
    ;

user_limit_commalist
    : user_limit_commalist TS_COMMA user_limit 
      {
          qdUserPasswOptions * sLast;

          for (sLast = $<userOptions>1->passwOptions;
               sLast->next != NULL;
               sLast = sLast->next) ;
          sLast->next = $<userOptions>3->passwOptions;
          
          $<userOptions>$ = $<userOptions>1;
      }
    | user_limit
      {
          $<userOptions>$ = $<userOptions>1;
      }
    ;

user_limit
    : TI_NONQUOTED_IDENTIFIER column_name
     {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->passwOptions, qdUserPasswOptions);
          
          $<userOptions>$->passwOptions->next = NULL;

          $<userOptions>$->passwOptions->passwOptValue = 0;
          SET_EMPTY_POSITION($<userOptions>$->passwOptions->passwVerifyFuncName);

          /* set option number */
          if (idlOS::strMatch("FAILED_LOGIN_ATTEMPTS", 21,
                              QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_FAILED_LOGIN_ATTEMPTS;

              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_LIFE_TIME", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_LIFE_TIME;
              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_REUSE_TIME", 19,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_REUSE_TIME;
              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_REUSE_MAX", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_REUSE_MAX;
              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_LOCK_TIME", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_LOCK_TIME;
              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_GRACE_TIME", 19,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_GRACE_TIME;
              if (idlOS::strMatch("UNLIMITED", 9,
                                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                           sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // Nothing To Do
              }
          }
          else if (idlOS::strMatch("PASSWORD_VERIFY_FUNCTION", 24,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_VERIFY_FUNCTION;

              if ($<position>2.size > QC_PASSWORD_OPT_LEN)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
                        
              /* set value */
              SET_POSITION($<userOptions>$->passwOptions->passwVerifyFuncName,
                           $<position>2 );
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          $<userOptions>$->password    = NULL;
          $<userOptions>$->dataTBSName = NULL;
          $<userOptions>$->tempTBSName = NULL;
          $<userOptions>$->access      = NULL;
          $<userOptions>$->expLock     = QD_NONE_LOCK;
          $<userOptions>$->disableTCP  = QD_DISABLE_TCP_NONE;
      }
    | TI_NONQUOTED_IDENTIFIER TR_NULL
      {
          qcuSqlSourceInfo    sqlInfo;
          
          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->passwOptions, qdUserPasswOptions);
          
          $<userOptions>$->passwOptions->next = NULL;

          $<userOptions>$->passwOptions->passwOptValue = 0;
          SET_EMPTY_POSITION($<userOptions>$->passwOptions->passwVerifyFuncName);

          /* set option number */
          if (idlOS::strMatch("PASSWORD_VERIFY_FUNCTION", 24,
                              QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_VERIFY_FUNCTION;
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<userOptions>$->password    = NULL;
          $<userOptions>$->dataTBSName = NULL;
          $<userOptions>$->tempTBSName = NULL;
          $<userOptions>$->access      = NULL;
          $<userOptions>$->expLock     = QD_NONE_LOCK;
          $<userOptions>$->disableTCP  = QD_DISABLE_TCP_NONE;
      }
    | TI_NONQUOTED_IDENTIFIER TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sOptValue;

          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->passwOptions, qdUserPasswOptions);
          
          $<userOptions>$->passwOptions->next = NULL;

          $<userOptions>$->passwOptions->passwOptValue = 0;
          SET_EMPTY_POSITION($<userOptions>$->passwOptions->passwVerifyFuncName);

          /* set option number */
          if (idlOS::strMatch("FAILED_LOGIN_ATTEMPTS", 21,
                              QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_FAILED_LOGIN_ATTEMPTS;
          }
          else if (idlOS::strMatch("PASSWORD_LIFE_TIME", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_LIFE_TIME;
          }
          else if (idlOS::strMatch("PASSWORD_REUSE_TIME", 19,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_REUSE_TIME;
          }
          else if (idlOS::strMatch("PASSWORD_REUSE_MAX", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_REUSE_MAX;
          }
          else if (idlOS::strMatch("PASSWORD_LOCK_TIME", 18,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_LOCK_TIME;
          }
          else if (idlOS::strMatch("PASSWORD_GRACE_TIME", 19,
                                   QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<userOptions>$->passwOptions->passwOptNum = QD_PASSWORD_GRACE_TIME;
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          /* set value */
          if( qtc::getBigint( QTEXT, &sOptValue, &($<position>2)) != IDE_SUCCESS )
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              // Nothing To Do
          }

          /* option value '0' error */
          if ( sOptValue == 0 )
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              $<userOptions>$->passwOptions->passwOptValue = sOptValue;
          }
          
          $<userOptions>$->password    = NULL;
          $<userOptions>$->dataTBSName = NULL;
          $<userOptions>$->tempTBSName = NULL;
          $<userOptions>$->access      = NULL;
          $<userOptions>$->expLock     = QD_NONE_LOCK;
          $<userOptions>$->disableTCP  = QD_DISABLE_TCP_NONE;
      }
    ;

create_user_option
    : user_limit_options
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | temporary_tablespace
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | default_tablespace
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | access
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | disable_tcp_option
      {
          $<userOptions>$ = $<userOptions>1;
      }
    ;

user_option
    : user_limit_options
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | password_def
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | temporary_tablespace
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | default_tablespace
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | access_options
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | account_options
       {
          $<userOptions>$ = $<userOptions>1;
       }
    | disable_tcp_option
      {
          $<userOptions>$ = $<userOptions>1;
      }
    ;

disable_tcp_option /* PROJ-2474 TLS/SSL support */
    : TR_ENABLE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "TCP", 3,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);

          $<userOptions>$->password     = NULL;
          $<userOptions>$->dataTBSName  = NULL;
          $<userOptions>$->tempTBSName  = NULL;
          $<userOptions>$->access       = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;
          $<userOptions>$->disableTCP   = QD_DISABLE_TCP_FALSE;
      }
    | TR_DISABLE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "TCP", 3,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);

          $<userOptions>$->password     = NULL;
          $<userOptions>$->dataTBSName  = NULL;
          $<userOptions>$->tempTBSName  = NULL;
          $<userOptions>$->access       = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;

          $<userOptions>$->disableTCP = QD_DISABLE_TCP_TRUE;
      }
    ;

/* PROJ-2207 Password policy support */
account_options
    : TI_NONQUOTED_IDENTIFIER account_status
    {
        qcuSqlSourceInfo    sqlInfo;
 
        if (idlOS::strMatch(
                "ACCOUNT", 7,
                QTEXT+$<position>1.offset, $<position>1.size) != 0)
        {
            sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                     sqlInfo.getErrMessage() ));
            sqlInfo.fini();
            YYABORT;
        }
           
        QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);

        if ( $<boolType>2 == ID_TRUE )
        {
            $<userOptions>$->expLock = QD_EXPLICITILY_LOCK;
        }
        else
        {
            $<userOptions>$->expLock = QD_EXPLICITILY_UNLOCK;
        }
        
        $<userOptions>$->password     = NULL;
        $<userOptions>$->dataTBSName  = NULL;
        $<userOptions>$->tempTBSName  = NULL;
        $<userOptions>$->access       = NULL;
        $<userOptions>$->passwOptions = NULL;
        $<userOptions>$->disableTCP   = QD_DISABLE_TCP_NONE;
    }
    ;

account_status
    : TA_LOCK
      {
          $<boolType>$ = ID_TRUE;
      }
    | TA_UNLOCK
      {
          $<boolType>$ = ID_FALSE;
      }
    ;

access_options
    : access
      {
          $<userOptions>$ = $<userOptions>1;
      }
    | access_options access
      {
          qdUserTBSAccess * sLast;

          for (sLast = $<userOptions>1->access;
               sLast->next != NULL;
               sLast = sLast->next)
              ;
          sLast->next = $<userOptions>2->access;

          $<userOptions>$ = $<userOptions>1;
      }
    ;

password_def
    : TO_IDENTIFIED TR_BY TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // password
          if ($<position>3.size > IDS_MAX_PASSWORD_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->password, qcNamePosition);

          $<userOptions>$->dataTBSName  = NULL;
          $<userOptions>$->tempTBSName  = NULL;
          $<userOptions>$->access       = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;
          $<userOptions>$->disableTCP   = QD_DISABLE_TCP_NONE;

          SET_POSITION( (*($<userOptions>$->password)), $<position>3 );
          // to upper case
          QC_PASSWORD_UPPER( $<position>3 );
      }
    ;

temporary_tablespace
    : TR_TEMPORARY TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->tempTBSName, qcNamePosition);
          $<userOptions>$->password     = NULL;
          $<userOptions>$->dataTBSName  = NULL;
          $<userOptions>$->access       = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;
          $<userOptions>$->disableTCP   = QD_DISABLE_TCP_NONE;

          *($<userOptions>$->tempTBSName) = $<position>3;
      }
    ;

default_tablespace
    : TR_DEFAULT TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);
          QCP_STRUCT_ALLOC($<userOptions>$->dataTBSName, qcNamePosition);
          $<userOptions>$->password     = NULL;
          $<userOptions>$->tempTBSName  = NULL;
          $<userOptions>$->access       = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;
          $<userOptions>$->disableTCP   = QD_DISABLE_TCP_NONE;

          *($<userOptions>$->dataTBSName) = $<position>3;
      }
    ;

access
    : TO_ACCESS TI_IDENTIFIER access_option
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<userOptions>$, qdUserOptions);

          QCP_STRUCT_ALLOC($<userOptions>$->access, qdUserTBSAccess);
          SET_POSITION($<userOptions>$->access->TBSName, $<position>2);
          $<userOptions>$->access->isAccess = $<boolType>3;
          $<userOptions>$->access->next = NULL;

          $<userOptions>$->password     = NULL;
          $<userOptions>$->dataTBSName  = NULL;
          $<userOptions>$->tempTBSName  = NULL;
          $<userOptions>$->passwOptions = NULL;
          $<userOptions>$->expLock      = QD_NONE_LOCK;
          $<userOptions>$->disableTCP   = QD_DISABLE_TCP_NONE;
      }
    ;

access_option
    : TR_ON
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_OFF
      {
          $<boolType>$ = ID_FALSE;
      }
    ;

drop_user_statement
    : TR_DROP_USER TI_IDENTIFIER opt_cascade_tok
      {
          qcuSqlSourceInfo    sqlInfo;

          // user name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          SET_POSITION($<dropParseTree>$->objectName, $<position>2);

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateDropUser;
          $<dropParseTree>$->common.optimize = qcc::optimize;

          if ($<boolType>3 == ID_FALSE)
          {
              $<dropParseTree>$->common.execute  = qdd::executeDropUser;
          }
          else
          {
              $<dropParseTree>$->common.execute  = qdd::executeDropUserCascade;
          }
      }
    ;

grant_statement
    : grant_system_privileges_statement
      {
          $<grantParseTree>$ = $<grantParseTree>1;
      }
    | grant_object_privileges_statement
      {
          $<grantParseTree>$ = $<grantParseTree>1;
      }
    ;

grant_system_privileges_statement
    : TR_GRANT
      privilege_list
      TR_TO grantees_clause
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<grantParseTree>$, qdGrantParseTree);
          QC_SET_INIT_PARSE_TREE($<grantParseTree>$, $<position>1);
          QD_GRANT_PARSE_TREE_INIT($<grantParseTree>$);

          $<grantParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<grantParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if (sPriv->privType == QDP_OBJECT_PRIV)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          $<grantParseTree>$->grantees = $<grantee>4;
          $<grantParseTree>$->grantOption = ID_FALSE;
          $<grantParseTree>$->grantorID = 0;

          $<grantParseTree>$->common.parse    = qcc::parse;
          $<grantParseTree>$->common.validate = qdpGrant::validateGrantSystem;
          $<grantParseTree>$->common.optimize = qcc::optimize;
          $<grantParseTree>$->common.execute  = qdpGrant::executeGrantSystem;
      }
    ;

grant_object_privileges_statement
    : TR_GRANT
      privilege_list
      TR_ON user_object_name
      TR_TO grantees_clause
      opt_with_grant_option
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<grantParseTree>$, qdGrantParseTree);
          QC_SET_INIT_PARSE_TREE($<grantParseTree>$, $<position>1);
          QD_GRANT_PARSE_TREE_INIT($<grantParseTree>$);

          $<grantParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<grantParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if ( ( sPriv->privType == QDP_SYSTEM_PRIV) ||
                   ( sPriv->privType == QDP_ROLE_PRIV ) )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          $<grantParseTree>$->objectType[0] = 'N';
          $<grantParseTree>$->objectType[1] = '\0';

          SET_POSITION($<grantParseTree>$->userName, \
              $<userNObjName>4->userName);
          SET_POSITION($<grantParseTree>$->objectName, \
              $<userNObjName>4->objectName);

          $<grantParseTree>$->grantees = $<grantee>6;
          $<grantParseTree>$->grantOption = $<boolType>7;
          $<grantParseTree>$->grantorID = 0;

          $<grantParseTree>$->common.parse    = qcc::parse;
          $<grantParseTree>$->common.validate = qdpGrant::validateGrantObject;
          $<grantParseTree>$->common.optimize = qcc::optimize;
          $<grantParseTree>$->common.execute  = qdpGrant::executeGrantObject;
      }
    | TR_GRANT
      privilege_list
      TR_ON TR_DIRECTORY TI_IDENTIFIER
      TR_TO grantees_clause
      opt_with_grant_option
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<grantParseTree>$, qdGrantParseTree);
          QC_SET_INIT_PARSE_TREE($<grantParseTree>$, $<position>1);
          QD_GRANT_PARSE_TREE_INIT($<grantParseTree>$);

          $<grantParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<grantParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if ( ( sPriv->privType == QDP_SYSTEM_PRIV) ||
                   ( sPriv->privType == QDP_ROLE_PRIV ) )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          $<grantParseTree>$->objectType[0] = 'D';
          $<grantParseTree>$->objectType[1] = '\0';

          SET_POSITION($<grantParseTree>$->objectName, \
                       $<position>5);

          $<grantParseTree>$->grantees = $<grantee>7;
          $<grantParseTree>$->grantOption = $<boolType>8;
          $<grantParseTree>$->grantorID = 0;

          $<grantParseTree>$->common.parse    = qcc::parse;
          $<grantParseTree>$->common.validate = qdpGrant::validateGrantObject;
          $<grantParseTree>$->common.optimize = qcc::optimize;
          $<grantParseTree>$->common.execute  = qdpGrant::executeGrantObject;
      }
    ;

privilege_list
    : privilege_list TS_COMMA privilege
      {
          qdPrivileges * sLast;

          $<privilege>$ = $<privilege>1;
          for (sLast = $<privilege>$;
               sLast->next != NULL;
               sLast = sLast->next)
              ;
          sLast->next = $<privilege>3;
      }
    | privilege
      {
          $<privilege>$ = $<privilege>1;
      }
    ;

privilege
    /* system privileges */
    : TR_ALTER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "SYSTEM", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_SYSTEM_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TO_INDEX
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_INDEX_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TO_INDEX
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_INDEX_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TO_INDEX
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_INDEX_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_PROCEDURE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_PROCEDURE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TR_PROCEDURE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_PROCEDURE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TR_PROCEDURE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_PROCEDURE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_PROCEDURE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_PROCEDURE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_EXECUTE TR_ANY TR_PROCEDURE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_EXECUTE_ANY_PROCEDURE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }

    //-----------------------------------
    // PROJ-1359 Trigger
    //-----------------------------------

    | TR_CREATE TR_TRIGGER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_TRIGGER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TR_TRIGGER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_TRIGGER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TR_TRIGGER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_TRIGGER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_TRIGGER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_TRIGGER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }

       // Proj-1076 Synonym

    | TR_CREATE TR_SYNONYM
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_SYNONYM_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TI_NONQUOTED_IDENTIFIER TR_SYNONYM
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_PUBLIC_SYNONYM_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_CREATE TR_ANY TR_SYNONYM
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_SYNONYM_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_SYNONYM
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_SYNONYM_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TI_NONQUOTED_IDENTIFIER TR_SYNONYM
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_PUBLIC_SYNONYM_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }

    /* SEQUENCE */
    | TR_CREATE TR_SEQUENCE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_SEQUENCE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TR_SEQUENCE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_SEQUENCE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TR_SEQUENCE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_SEQUENCE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_SEQUENCE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_SEQUENCE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_SELECT TR_ANY TR_SEQUENCE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_SELECT_ANY_SEQUENCE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_SESSION
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_SESSION_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_SESSION
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_SESSION_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DELETE TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DELETE_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_INSERT TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_INSERT_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TA_LOCK TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_LOCK_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_SELECT TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_SELECT_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_UPDATE TR_ANY TR_TABLE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_UPDATE_ANY_TABLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE_USER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_USER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER_USER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_USER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP_USER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_USER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_GRANT TR_ANY TR_PRIVILEGES
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_GRANT_ANY_PRIVILEGES_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TA_TABLESPACE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_TABLESPACE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TA_TABLESPACE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_TABLESPACE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TA_TABLESPACE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_TABLESPACE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    /* PROJ-1371 Directories */
    | TR_CREATE TR_ANY TR_DIRECTORY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_DIRECTORY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TR_DIRECTORY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_DIRECTORY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }

    /* PROJ-2211 Materialized View */
    | TR_CREATE TO_MATERIALIZED TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_MATERIALIZED_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TO_MATERIALIZED TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_MATERIALIZED_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TO_MATERIALIZED TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_MATERIALIZED_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TO_MATERIALIZED TR_VIEW
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_MATERIALIZED_VIEW_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    // PROJ-1685
    | TR_CREATE TO_LIBRARY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_LIBRARY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TO_LIBRARY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_LIBRARY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TO_LIBRARY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_LIBRARY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TO_LIBRARY
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_LIBRARY_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }

      /*
    | TI_NONQUOTED_IDENTIFIER TA_TABLESPACE
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "MANAGE", 6,
                QTEXT+$<position>1.offset, $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                  sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_MANAGE_TABLESPACE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
      */
    /* object privileges */
    | TR_ALTER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_ALTER_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DELETE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_DELETE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_EXECUTE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_EXECUTE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TO_INDEX
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_INDEX_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_INSERT
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_INSERT_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_REFERENCES
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_REFERENCES_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_SELECT
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_SELECT_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_UPDATE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_OBJECT_UPDATE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALL
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALL_PRIVILEGES_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALL TR_PRIVILEGES
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALL_PRIVILEGES_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    /* PROJ-1371 Directories */
    | TR_READ
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_DIRECTORY_READ_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_WRITE
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_OBJECT_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_DIRECTORY_WRITE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }

    /* PROJ-1832 New database link */
    | TR_CREATE TR_DATABASE TR_LINK
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_DATABASE_LINK_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TI_NONQUOTED_IDENTIFIER TR_DATABASE TR_LINK
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_PUBLIC_DATABASE_LINK_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_DROP TI_NONQUOTED_IDENTIFIER TR_DATABASE TR_LINK
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_PUBLIC_DATABASE_LINK_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    /* PROJ-1812 ROLE */
    | TR_CREATE TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo   sqlInfo;

          if( idlOS::strMatch( "ROLE",
                               4,
                               QTEXT+$<position>2.offset,
                               $<position>2.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }
          
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ROLE_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_DROP TR_ANY TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo   sqlInfo;

          if ( idlOS::strMatch( "ROLE",
                                4,
                                QTEXT+$<position>3.offset,
                                $<position>3.size) == 0 )
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_ROLE_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else if ( idlOS::strMatch( "JOB",
                                     3,
                                     QTEXT+$<position>3.offset,
                                     $<position>3.size) == 0 )
          {
              QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
              $<privilege>$->privType = QDP_SYSTEM_PRIV;
              $<privilege>$->next = NULL;
              $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_DROP_ANY_JOB_NO;
              SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

      }
    | TR_GRANT TR_ANY TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo   sqlInfo;

        if( idlOS::strMatch( "ROLE",
                             4,
                             QTEXT+$<position>3.offset,
                             $<position>3.size) != 0 )
        {
            sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
            sqlInfo.init( MEMORY );
            IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                     sqlInfo.getErrMessage() ));
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            /* Nothing to do */
        }

        QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
        $<privilege>$->privType = QDP_SYSTEM_PRIV;
        $<privilege>$->next = NULL;
        $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_GRANT_ANY_ROLE_NO;
        SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
    }
/* PROJ-1812 ROLE */
    | TI_IDENTIFIER
      {
          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_ROLE_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = 0;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_CREATE TR_ANY TI_NONQUOTED_IDENTIFIER /* BUG-41408 noraml user create, alter, drop job */
      {
          qcuSqlSourceInfo   sqlInfo;

          if ( idlOS::strMatch( "JOB",
                                3,
                                QTEXT+$<position>3.offset,
                                $<position>3.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_CREATE_ANY_JOB_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    | TR_ALTER TR_ANY TI_NONQUOTED_IDENTIFIER /* BUG-41408 noraml user create, alter, drop job */
      {
          qcuSqlSourceInfo   sqlInfo;

          if ( idlOS::strMatch( "JOB",
                                3,
                                QTEXT+$<position>3.offset,
                                $<position>3.size) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          QCP_STRUCT_ALLOC($<privilege>$, qdPrivileges);
          $<privilege>$->privType = QDP_SYSTEM_PRIV;
          $<privilege>$->next = NULL;
          $<privilege>$->privOrRoleID = QCM_PRIV_ID_SYSTEM_ALTER_ANY_JOB_NO;
          SET_POSITION($<privilege>$->privOrRoleName, $<position>1);
      }
    ;

grantees_clause
    : grantees_clause TS_COMMA grantee
      {
          qdGrantees * sLast;

          $<grantee>$ = $<grantee>1;
          for (sLast = $<grantee>$; sLast->next != NULL; sLast = sLast->next) ;
          sLast->next = $<grantee>3;
      }
    | grantee
      {
          $<grantee>$ = $<grantee>1;
      }
    ;

grantee
    : TI_IDENTIFIER
      {
          
          QCP_STRUCT_ALLOC($<grantee>$, qdGrantees);
          SET_POSITION($<grantee>$->userOrRoleName, $<position>1);
          $<grantee>$->userType = QDP_USER_TYPE;
          $<grantee>$->next = NULL;
      }
    ;

opt_with_grant_option
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_WITH TR_GRANT TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "OPTION", 6,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

revoke_statement
    : revoke_system_privileges_statement
      {
          $<revokeParseTree>$ = $<revokeParseTree>1;
      }
    | revoke_object_privileges_statement
      {
          $<revokeParseTree>$ = $<revokeParseTree>1;
      }
    ;

revoke_system_privileges_statement
    : TR_REVOKE privilege_list
      TR_FROM grantees_clause
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<revokeParseTree>$, qdRevokeParseTree);
          QC_SET_INIT_PARSE_TREE($<revokeParseTree>$, $<position>1);
          QD_REVOKE_PARSE_TREE_INIT($<revokeParseTree>$);

          $<revokeParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<revokeParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if (sPriv->privType == QDP_OBJECT_PRIV)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          $<revokeParseTree>$->grantees = $<grantee>4;
          $<revokeParseTree>$->cascadeConstr = ID_FALSE;
          $<revokeParseTree>$->force = ID_FALSE;

          $<revokeParseTree>$->common.parse    = qcc::parse;
          $<revokeParseTree>$->common.validate =
                    qdpRevoke::validateRevokeSystem;
          $<revokeParseTree>$->common.optimize = qcc::optimize;
          $<revokeParseTree>$->common.execute  = qdpRevoke::executeRevokeSystem;
      }
    ;

revoke_object_privileges_statement
    : TR_REVOKE privilege_list
      TR_ON user_object_name
      TR_FROM grantees_clause
      opt_cascade_constraints
      opt_force
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<revokeParseTree>$, qdRevokeParseTree);
          QC_SET_INIT_PARSE_TREE($<revokeParseTree>$, $<position>1);
          QD_REVOKE_PARSE_TREE_INIT($<revokeParseTree>$);

          $<revokeParseTree>$->objectType[0] = 'N';
          $<revokeParseTree>$->objectType[1] = '\0';

          $<revokeParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<revokeParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if ( ( sPriv->privType == QDP_SYSTEM_PRIV ) ||
                   ( sPriv->privType == QDP_ROLE_PRIV ) )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          SET_POSITION($<revokeParseTree>$->userName, \
              $<userNObjName>4->userName);
          SET_POSITION($<revokeParseTree>$->objectName, \
              $<userNObjName>4->objectName);

          $<revokeParseTree>$->grantees = $<grantee>6;
          $<revokeParseTree>$->cascadeConstr = $<boolType>7;
          $<revokeParseTree>$->force = $<boolType>8;

          $<revokeParseTree>$->common.parse    = qcc::parse;
          $<revokeParseTree>$->common.validate =
                    qdpRevoke::validateRevokeObject;
          $<revokeParseTree>$->common.optimize = qcc::optimize;
          $<revokeParseTree>$->common.execute  = qdpRevoke::executeRevokeObject;
      }
    | TR_REVOKE privilege_list
      TR_ON TR_DIRECTORY TI_IDENTIFIER
      TR_FROM grantees_clause
      opt_cascade_constraints
      opt_force
      {
          qcuSqlSourceInfo    sqlInfo;
          qdPrivileges      * sPriv;

          QCP_STRUCT_ALLOC($<revokeParseTree>$, qdRevokeParseTree);
          QC_SET_INIT_PARSE_TREE($<revokeParseTree>$, $<position>1);
          QD_REVOKE_PARSE_TREE_INIT($<revokeParseTree>$);

          $<revokeParseTree>$->objectType[0] = 'D';
          $<revokeParseTree>$->objectType[1] = '\0';

          $<revokeParseTree>$->privileges = $<privilege>2;

          // BUG-13762
          for(sPriv = $<revokeParseTree>$->privileges;
              sPriv != NULL;
              sPriv = sPriv->next)
          {
              if ( ( sPriv->privType == QDP_SYSTEM_PRIV ) ||
                   ( sPriv->privType == QDP_ROLE_PRIV ) )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & sPriv->privOrRoleName );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          SET_POSITION($<revokeParseTree>$->objectName, \
              $<position>5);

          $<revokeParseTree>$->grantees = $<grantee>7;
          $<revokeParseTree>$->cascadeConstr = $<boolType>8;
          $<revokeParseTree>$->force = $<boolType>9;

          $<revokeParseTree>$->common.parse    = qcc::parse;
          $<revokeParseTree>$->common.validate =
                    qdpRevoke::validateRevokeObject;
          $<revokeParseTree>$->common.optimize = qcc::optimize;
          $<revokeParseTree>$->common.execute  = qdpRevoke::executeRevokeObject;
      }
    ;

opt_cascade_constraints
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_CASCADE TR_CONSTRAINTS
      {
          $<boolType>$ = ID_TRUE;
      }
    ;

opt_force
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "FORCE", 5,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;


/*********************************************
 * Synonym
 *********************************************/
create_synonym_statement
    : TR_CREATE TR_SYNONYM user_object_name
      TR_FOR user_object_name
      {
          QCP_STRUCT_ALLOC($<createSynonym>$, qdSynonymParseTree);
          QC_SET_INIT_PARSE_TREE($<createSynonym>$, $<position>1);
          QD_SYNONYM_PARSE_TREE_INIT($<createSynonym>$);

          /* set synonymOwnerName position */
          SET_POSITION($<createSynonym>$->synonymOwnerName, \
                       $<userNObjName>3->userName);
          /* set synonymName position */
          SET_POSITION($<createSynonym>$->synonymName, \
                       $<userNObjName>3->objectName);

          /* set objectOwnerName position */
          SET_POSITION($<createSynonym>$->objectOwnerName, \
                       $<userNObjName>5->userName);
          /* set objectName position */
          SET_POSITION($<createSynonym>$->objectName, \
                       $<userNObjName>5->objectName);

          $<createSynonym>$->common.parse    = qcc::parse;
          $<createSynonym>$->common.validate = qdsSynonym::validateCreateSynonym;
          $<createSynonym>$->common.optimize = qcc::optimize;
          $<createSynonym>$->common.execute  = qdsSynonym::executeCreateSynonym;
      }
    | TR_CREATE TI_NONQUOTED_IDENTIFIER TR_SYNONYM TI_IDENTIFIER
      TR_FOR user_object_name
    {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;

          }
          else
          { 
             /* Nothing To Do */
          }
          
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              qcuSqlSourceInfo    sqlInfo;
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<createSynonym>$, qdSynonymParseTree);
          QC_SET_INIT_PARSE_TREE($<createSynonym>$, $<position>1);
          QD_SYNONYM_PARSE_TREE_INIT($<createSynonym>$);

          /* PUBLIC SYNONYM */
          $<createSynonym>$->isPublic = ID_TRUE;
          /* set synonymName position */
          SET_POSITION($<createSynonym>$->synonymName, \
                       $<position>4);

          /* set objectOwnerName position */
          SET_POSITION($<createSynonym>$->objectOwnerName, \
                       $<userNObjName>6->userName);
          /* set objectName position */
          SET_POSITION($<createSynonym>$->objectName, \
                       $<userNObjName>6->objectName);

          $<createSynonym>$->common.parse    = qcc::parse;
          $<createSynonym>$->common.validate = qdsSynonym::validateCreateSynonym;
          $<createSynonym>$->common.optimize = qcc::optimize;
          $<createSynonym>$->common.execute  = qdsSynonym::executeCreateSynonym;
      }
    /* BUG-38825 CREATE OR REPLACE SYNONYM */
    | TR_CREATE TR_OR TO_REPLACE TR_SYNONYM user_object_name
      TR_FOR user_object_name
      {
          QCP_STRUCT_ALLOC($<createSynonym>$, qdSynonymParseTree);
          QC_SET_INIT_PARSE_TREE($<createSynonym>$, $<position>1);
          QD_SYNONYM_PARSE_TREE_INIT($<createSynonym>$);

          // OR REPLACE
          $<createSynonym>$->flag &= ~QDS_SYN_OPT_REPLACE_MASK;
          $<createSynonym>$->flag |= QDS_SYN_OPT_REPLACE_TRUE;

          /* set synonymOwnerName position */
          SET_POSITION($<createSynonym>$->synonymOwnerName, \
                       $<userNObjName>5->userName);
          /* set synonymName position */
          SET_POSITION($<createSynonym>$->synonymName, \
                       $<userNObjName>5->objectName);

          /* set objectOwnerName position */
          SET_POSITION($<createSynonym>$->objectOwnerName, \
                       $<userNObjName>7->userName);
          /* set objectName position */
          SET_POSITION($<createSynonym>$->objectName, \
                       $<userNObjName>7->objectName);

          $<createSynonym>$->common.parse    = qcc::parse;
          $<createSynonym>$->common.validate = qdsSynonym::validateCreateSynonym;
          $<createSynonym>$->common.optimize = qcc::optimize;
          $<createSynonym>$->common.execute  = qdsSynonym::executeRecreate;
      }
    | TR_CREATE TR_OR TO_REPLACE TI_NONQUOTED_IDENTIFIER TR_SYNONYM TI_IDENTIFIER
      TR_FOR user_object_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "PUBLIC", 6,
                  QTEXT+$<position>4.offset, $<position>4.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing To Do */
          }
          
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              qcuSqlSourceInfo    sqlInfo;
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<createSynonym>$, qdSynonymParseTree);
          QC_SET_INIT_PARSE_TREE($<createSynonym>$, $<position>1);
          QD_SYNONYM_PARSE_TREE_INIT($<createSynonym>$);

          // OR REPLACE
          $<createSynonym>$->flag &= ~QDS_SYN_OPT_REPLACE_MASK;
          $<createSynonym>$->flag |= QDS_SYN_OPT_REPLACE_TRUE;

          /* PUBLIC SYNONYM */
          $<createSynonym>$->isPublic = ID_TRUE;
          /* set synonymName position */
          SET_POSITION($<createSynonym>$->synonymName, \
                       $<position>6);

          /* set objectOwnerName position */
          SET_POSITION($<createSynonym>$->objectOwnerName, \
                       $<userNObjName>8->userName);
          /* set objectName position */
          SET_POSITION($<createSynonym>$->objectName, \
                       $<userNObjName>8->objectName);

          $<createSynonym>$->common.parse    = qcc::parse;
          $<createSynonym>$->common.validate = qdsSynonym::validateCreateSynonym;
          $<createSynonym>$->common.optimize = qcc::optimize;
          $<createSynonym>$->common.execute  = qdsSynonym::executeRecreate;
      }
;

drop_synonym_statement
    : TR_DROP TR_SYNONYM user_object_name
      {
          QCP_STRUCT_ALLOC($<dropSynonym>$, qdSynonymParseTree);
          QC_SET_INIT_PARSE_TREE($<dropSynonym>$, $<position>1);
          QD_SYNONYM_PARSE_TREE_INIT($<dropSynonym>$);

          /* set synonymOwnerName position */
          SET_POSITION($<dropSynonym>$->synonymOwnerName, \
                       $<userNObjName>3->userName);
          /* set synonymName position */
          SET_POSITION($<dropSynonym>$->synonymName, \
                       $<userNObjName>3->objectName);

          $<dropSynonym>$->common.parse    = qcc::parse;
          $<dropSynonym>$->common.validate = qdsSynonym::validateDropSynonym;
          $<dropSynonym>$->common.optimize = qcc::optimize;
          $<dropSynonym>$->common.execute  = qdsSynonym::executeDropSynonym;
      }
    | TR_DROP TI_NONQUOTED_IDENTIFIER TR_SYNONYM TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "PUBLIC", 6,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            /* Notihg To Do */
        }
          
        QCP_STRUCT_ALLOC($<dropSynonym>$, qdSynonymParseTree);
        QC_SET_INIT_PARSE_TREE($<dropSynonym>$, $<position>1);
        QD_SYNONYM_PARSE_TREE_INIT($<dropSynonym>$);

        /* PUBLIC SYNONYM */
        $<dropSynonym>$->isPublic = ID_TRUE;
        /* set synonymName position */
        SET_POSITION($<dropSynonym>$->synonymName, $<position>4);

        $<dropSynonym>$->common.parse    = qcc::parse;
        $<dropSynonym>$->common.validate = qdsSynonym::validateDropSynonym;
        $<dropSynonym>$->common.optimize = qcc::optimize;
        $<dropSynonym>$->common.execute  = qdsSynonym::executeDropSynonym;
    }
;

/*****************************************
 * REPLICATION
 ****************************************/

replication_statement
    : TR_CREATE opt_repl_mode TA_REPLICATION TI_IDENTIFIER
        opt_role opt_conflict_resolution opt_repl_options
        TR_WITH replication_with_hosts repl_tbl_commalist
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>4.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>4);

        $<replParseTree>$->replMode = $<sIntVal>2;

        // BUG-17616
        if($<sIntVal>2 != RP_DEFAULT_MODE)
        {
            $<replParseTree>$->replModeSelected = ID_TRUE;
        }
        else
        {
            $<replParseTree>$->replMode         = RP_LAZY_MODE;
            $<replParseTree>$->replModeSelected = ID_FALSE;
        }

        $<replParseTree>$->role               = $<sIntVal>5;
        $<replParseTree>$->conflictResolution = $<sIntVal>6;
        $<replParseTree>$->replOptions        = $<replOptions>7;
        $<replParseTree>$->hosts              = $<replHost>9;
        $<replParseTree>$->replItems          = $<replItem>10;

        // BUG-21761
        $<replParseTree>$->ncharList = NCHARLIST;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateCreate;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeCreate;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_ADD TR_TABLE repl_tbl
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        $<replParseTree>$->replItems = $<replItem>6;

        // BUG-21761
        $<replParseTree>$->ncharList = NCHARLIST;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateAlterAddTbl;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeAlterAddTbl;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_DROP TR_TABLE repl_tbl
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        $<replParseTree>$->replItems = $<replItem>6;

        // BUG-21761
        $<replParseTree>$->ncharList = NCHARLIST;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateAlterDropTbl;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeAlterDropTbl;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_ADD TI_NONQUOTED_IDENTIFIER replication_hosts
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "HOST", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            // replication name
            if ($<position>3.size > QC_MAX_NAME_LEN)
            {
                sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }

            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->hosts = $<replHost>6;

            // BUG-21761
            $<replParseTree>$->ncharList = NCHARLIST;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterAddHost;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterAddHost;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_DROP TI_NONQUOTED_IDENTIFIER replication_hosts
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "HOST", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            // replication name
            if ($<position>3.size > QC_MAX_NAME_LEN)
            {
                sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }

            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->hosts = $<replHost>6;

            // BUG-21761
            $<replParseTree>$->ncharList = NCHARLIST;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterDropHost;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterDropHost;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TI_NONQUOTED_IDENTIFIER replication_hosts
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "HOST", 4,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            // replication name
            if ($<position>3.size > QC_MAX_NAME_LEN)
            {
                sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }

            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->hosts = $<replHost>6;

            // BUG-21761
            $<replParseTree>$->ncharList = NCHARLIST;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetHost;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetHost;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TO_MODE repl_mode
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        $<replParseTree>$->replMode = $<sIntVal>6;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateAlterSetMode;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeAlterSetMode;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TI_NONQUOTED_IDENTIFIER enable_or_disable
      /* ALTER REPLICATION replication_name SET RECOVERY ENABLE/DISABLE */
      /* ALTER REPLICATION replication_name SET GAPLESS ENABLE/DISABLE */
      /* ALTER REPLICATION replication_name SET GROUPING ENABLE/DISABLE */
      /* ALTER REPLICATION replication_name SET DDL_REPLICATE ENABLE/DISABLE */
    {
        qcuSqlSourceInfo sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        
        if (idlOS::strMatch(
                "RECOVERY", 8,
                QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {

            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
            QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            if ( $<boolType>6 == ID_TRUE )
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_RECOVERY_SET;
            }
            else
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_RECOVERY_UNSET;
            }

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetRecovery;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetRecovery;
        }
        else if (idlOS::strMatch(
                     "GAPLESS", 7,
                     QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
            QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            if ( $<boolType>6 == ID_TRUE )
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_GAPLESS_SET;
            }
            else
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_GAPLESS_UNSET;
            }

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetGapless;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetGapless;
        
        }
        else if (idlOS::strMatch(
                     "GROUPING", 8,
                     QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
            QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            if ( $<boolType>6 == ID_TRUE )
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_GROUPING_SET;
            }
            else
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_GROUPING_UNSET;
            }

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetGrouping;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetGrouping;
        
        }
        else if (idlOS::strMatch(
                     "DDL_REPLICATE", 13,
                     QTEXT+$<position>5.offset, $<position>5.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
            QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            if ( $<boolType>6 == ID_TRUE )
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_DDL_REPLICATE_SET;
            }
            else
            {
                $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_DDL_REPLICATE_UNSET;
            }

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetDDLReplicate;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetDDLReplicate;
        
        }
        else
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_REPL_OPTION,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TR_PARALLEL TL_INTEGER opt_buffer_init_size
      /* ALTER REPLICATION replication_name SET PARALLEL 'parallelFactor' */
    {
#if !defined(ALTIBASE_MOBILE)

        qcuSqlSourceInfo sqlInfo;
        SLong            sParallelCount;

        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

        SET_POSITION($<replParseTree>$->replName, $<position>3);
        
        if ( qtc::getBigint( QTEXT, &sParallelCount, &($<position>6) ) != IDE_SUCCESS )
        {
            sqlInfo.setSourceInfo( STATEMENT, &($<position>6) );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_PARALLEL_RECEIVER_APPLY_SET;
            $<replParseTree>$->replOptions->parallelReceiverApplyCount = sParallelCount;
            $<replParseTree>$->replOptions->applierBuffer = $<replApplierBuffer>7;
            
            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateAlterSetParallel;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeAlterSetParallel;
        }
        
#else /* ALTIBASE_MOBILE */
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX));
        YYABORT;
#endif /* ALTIBASE_MOBILE */
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TA_OFFLINE TR_ENABLE TR_WITH offline_dirs
      /* ALTER REPLICATION replication_name SET OFFLINE ENABLE WITH dir dir ... */
    {
        qcuSqlSourceInfo sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

        $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_OFFLINE_SET;
        $<replParseTree>$->replOptions->logDirPath  = $<replDirPath>8;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateAlterSetOffline;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeAlterSetOfflineEnable;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER
        TR_SET TA_OFFLINE TR_DISABLE
      /* ALTER REPLICATION replication_name SET OFFLINE DISABLE */
    {
        qcuSqlSourceInfo sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        QCP_STRUCT_ALLOC($<replParseTree>$->replOptions, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replParseTree>$->replOptions );

        $<replParseTree>$->replOptions->optionsFlag = RP_OPTION_OFFLINE_UNSET;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateAlterSetOffline;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeAlterSetOfflineDisable;
    }
    | TR_DROP TA_REPLICATION TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateDrop;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qrc::executeDrop;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TR_START repl_start_option
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);
        $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_START;
        $<replParseTree>$->startOption = $<replStartOption>5->startOption;
        $<replParseTree>$->startSN     = $<replStartOption>5->startSN;
        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateStart;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qcc::executeError;

        if ( $<replStartOption>5->startOption == RP_START_OPTION_CONDITIONAL )
        {
            $<replParseTree>$->startType = RP_START_CONDITIONAL;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TR_START TR_WITH TA_OFFLINE
      /* PROJ-1915 ALTER REPLICATION replication_name START WITH OFFLINE */
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION($<replParseTree>$->replName, $<position>3);
        $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_START;
        $<replParseTree>$->startType = RP_OFFLINE;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateOfflineStart;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qcc::executeError;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TI_NONQUOTED_IDENTIFIER opt_repl_sync_table
      /* ALTER REPLICATION replication_name SYNC */
      /* ALTER REPLICATION replication_name QUICKSTART */
      /* ALTER REPLICATION replication_name STOP */
      /* ALTER REPLICATION replication_name RESET */
      /* ALTER REPLICATION replication_name FAILBACK */
      /* ALTER REPLICATION replication_name FAILOVER */
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        /*BUG-20108*/
        if( ($<replItem>5 != NULL) &&
            (idlOS::strMatch(
                "SYNC", 4,
                QTEXT+$<position>4.offset, $<position>4.size) != 0) )
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>5));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if (idlOS::strMatch(
                "SYNC", 4,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);
            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_SYNC;
            $<replParseTree>$->parallelFactor = 1;
            $<replParseTree>$->startType      = RP_SYNC;
            $<replParseTree>$->replItems      = $<replItem>5;

            $<replParseTree>$->common.parse    = qcc::parse;
            if($<replItem>5 != NULL)
            {
                $<replParseTree>$->common.validate = qrc::validateSyncTbl;
            }
            else
            {
                $<replParseTree>$->common.validate = qrc::validateSync;
            }
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else if (idlOS::strMatch(
                "QUICKSTART", 10,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);
            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_QUICKSTART;
            $<replParseTree>$->startType = RP_QUICK;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateQuickStart;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else if (idlOS::strMatch(
                "STOP", 4,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            /* BUG-42852 STOP FLUSH DCL ȯմϴ. */
            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_STOP;
            $<replParseTree>$->isImmediateStop = ID_FALSE;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qcc::validate;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else if (idlOS::strMatch(
                "RESET", 5,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateReset;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qrc::executeReset;
        }
        else if (idlOS::strMatch(
                "FAILBACK", 8,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->startType = RP_XLOGFILE_FAILBACK_SLAVE;
            
            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_FAILBACK;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateFailback;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else if ( idlOS::strMatch( "FAILOVER", 8,
                                   QTEXT+$<position>4.offset, $<position>4.size ) == 0 )
        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);

            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_FAILOVER;

            $<replParseTree>$->common.parse    = qcc::parse;
            $<replParseTree>$->common.validate = qrc::validateFailover;
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER opt_repl_sync_table
      /* ALTER REPLICATION replication_name SYNC ONLY ( table_name )*/
      /* ALTER REPLICATION replication_name SYNC CONDITION */
      /* ALTER REPLICATION replication_name QUICKSTART RETRY */
      /* ALTER REPLICATION replication_name STOP IMMEDIATE */
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        /*BUG-20108*/
        if( ($<replItem>6 != NULL) &&
            (idlOS::strMatch(
                "SYNC", 4,
                QTEXT+$<position>4.offset, $<position>4.size) != 0) )
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>6));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ( idlOS::strMatch( "SYNC", 4,
                              QTEXT+$<position>4.offset, $<position>4.size) == 0 )
        {
             if ( idlOS::strMatch( "ONLY", 4,
                                   QTEXT+$<position>5.offset, $<position>5.size ) == 0 )
            {
                QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
                QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
                QR_PARSE_TREE_INIT($<replParseTree>$);

                SET_POSITION($<replParseTree>$->replName, $<position>3);
                $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_SYNC;
                $<replParseTree>$->startType = RP_SYNC_ONLY;
                $<replParseTree>$->parallelFactor = 1;
                $<replParseTree>$->replItems = $<replItem>6;

                $<replParseTree>$->common.parse    = qcc::parse;
                if($<replItem>6 != NULL)
                {
                    $<replParseTree>$->common.validate = qrc::validateSyncTbl;
                }
                else
                {
                    $<replParseTree>$->common.validate = qrc::validateSync;
                }
                $<replParseTree>$->common.optimize = qcc::optimize;
                $<replParseTree>$->common.execute  = qcc::executeError;
            }
             else if ( idlOS::strMatch( "CONDITIONAL", 11,
                                        QTEXT+$<position>5.offset, $<position>5.size ) == 0 )
             {
                 if($<replItem>6 == NULL)
                 {
                     QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
                     QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
                     QR_PARSE_TREE_INIT($<replParseTree>$);

                     SET_POSITION($<replParseTree>$->replName, $<position>3);
                     $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_SYNC_CONDITION;
                     $<replParseTree>$->startType = RP_SYNC_CONDITIONAL;
                     $<replParseTree>$->parallelFactor = 1; 
                     $<replParseTree>$->common.parse    = qcc::parse;
                     $<replParseTree>$->common.validate = qrc::validateSync;
                     $<replParseTree>$->common.optimize = qcc::optimize;
                     $<replParseTree>$->common.execute  = qcc::executeError;
                 }
                 else
                 {
                     sqlInfo.setSourceInfo( STATEMENT, & $<position>6 );
                     sqlInfo.init( MEMORY );
                     IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                               sqlInfo.getErrMessage() ) );
                     sqlInfo.fini();
                     YYABORT;
                 }
             }
            else
            {
                sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
                sqlInfo.init( MEMORY );
                IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ) );
                sqlInfo.fini();
                YYABORT;
            }
        }
        else if ( idlOS::strMatch( "QUICKSTART", 10,
                                   QTEXT+$<position>4.offset, $<position>4.size ) == 0 ) 
        {
            if ( idlOS::strMatch( "RETRY", 5,
                                  QTEXT+$<position>5.offset, $<position>5.size ) == 0 )
            {
                QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
                QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
                QR_PARSE_TREE_INIT($<replParseTree>$);

                SET_POSITION($<replParseTree>$->replName, $<position>3);
                $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_QUICKSTART;
                $<replParseTree>$->parallelFactor = 1;
                $<replParseTree>$->startType      = RP_QUICK;
                $<replParseTree>$->startOption    = RP_START_OPTION_RETRY;

                $<replParseTree>$->common.parse    = qcc::parse;
                $<replParseTree>$->common.validate = qrc::validateQuickStart;
                $<replParseTree>$->common.optimize = qcc::optimize;
                $<replParseTree>$->common.execute  = qcc::executeError;
            }
            else
            {
                sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
                sqlInfo.init( MEMORY );
                IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ) );
                sqlInfo.fini();
                YYABORT;
            }
        }
        else if ( idlOS::strMatch( "STOP", 4,
                                   QTEXT+$<position>4.offset, $<position>4.size ) == 0 )
        {
            if ( idlOS::strMatch( "IMMEDIATE", 9,
                                  QTEXT+$<position>5.offset, $<position>5.size ) == 0 )
            {
                QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
                QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
                QR_PARSE_TREE_INIT($<replParseTree>$);

                SET_POSITION($<replParseTree>$->replName, $<position>3);

                /* BUG-42852 STOP FLUSH DCL ȯմϴ. */
                $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_STOP;
                $<replParseTree>$->isImmediateStop = ID_TRUE;

                $<replParseTree>$->common.parse    = qcc::parse;
                $<replParseTree>$->common.validate = qcc::validate;
                $<replParseTree>$->common.optimize = qcc::optimize;
                $<replParseTree>$->common.execute  = qcc::execute;
            }
            else
            {
                sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
                sqlInfo.init( MEMORY );
                IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ) );
                sqlInfo.fini();
                YYABORT;
            }
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TI_NONQUOTED_IDENTIFIER repl_sync_parallel opt_repl_sync_table
    /* ALTER REPLICATION replication_name SYNC ( PARALLEL number ) ( table_name )*/
    /* ALTER REPLICATION replication_name SYNC ONLY ( PARALLEL number ) ( table_name )*/
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if (idlOS::strMatch(
                "SYNC", 4,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)

        {
            QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
            QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
            QR_PARSE_TREE_INIT($<replParseTree>$);

            SET_POSITION($<replParseTree>$->replName, $<position>3);
            $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_SYNC;
            if($<sIntVal>5 > 0)
            {
                $<replParseTree>$->startType = RP_SYNC;
                $<replParseTree>$->parallelFactor = $<sIntVal>5;
            }
            else if ($<sIntVal>5 < 0)
            {
                $<replParseTree>$->startType = RP_SYNC_ONLY;
                $<replParseTree>$->parallelFactor = $<sIntVal>5 * (-1);
            }
            else
            {
                sqlInfo.setSourceInfo(STATEMENT, &($<position>5));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }

            $<replParseTree>$->replItems = $<replItem>6;

            $<replParseTree>$->common.parse    = qcc::parse;
            if($<replItem>6 != NULL)
            {
                $<replParseTree>$->common.validate = qrc::validateSyncTbl;
            }
            else
            {
                $<replParseTree>$->common.validate = qrc::validateSync;
            }
            $<replParseTree>$->common.optimize = qcc::optimize;
            $<replParseTree>$->common.execute  = qcc::executeError;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TR_FLUSH repl_flush_option
      /* ALTER REPLICATION replication_name FLUSH [ALL WAIT second] */
    {
        qcuSqlSourceInfo    sqlInfo;

        // replication name
        if ($<position>3.size > QC_MAX_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC( $<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE( $<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        SET_POSITION( $<replParseTree>$->replName, $<position>3);

        idlOS::memcpy( &($<replParseTree>$->flushOption),
                       &($<replFlushOption>5),
                       ID_SIZEOF( rpFlushOption ) );

        /* BUG-42852 STOP FLUSH DCL ȯմϴ. */
        $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_FLUSH;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qcc::validate;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qcc::execute;
    }
    | TR_ALTER TA_REPLICATION TR_TEMPORARY TI_IDENTIFIER  TR_TABLE temp_repl_tbl_commalist 
         TR_FROM repl_host
    /* ALTER REPLICATION TEMPORARY GET TABLE [username.table_name PARTITION partition_name ,]
           FROM 'remoteIp', remoteReplPort; */
    {
        qcuSqlSourceInfo    sqlInfo;
        
        if ( idlOS::strMatch( "GET", 3,
                              QTEXT+$<position>4.offset, $<position>4.size ) != 0 )
        {
            sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);

        $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_TEMP_SYNC;

        $<replParseTree>$->replItems      = $<replItem>6;
        $<replParseTree>$->hosts          = $<replHost>8;

        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateTempSync;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qcc::executeError;
    }
    | TR_ALTER TA_REPLICATION TI_IDENTIFIER TR_DELETE TI_IDENTIFIER 
      /* ALTER REPLICATION replication_name DELETE ITEM_REPLACE_HISTORY */
    {
        qcuSqlSourceInfo    sqlInfo;
        
        if ( idlOS::strMatch( "ITEM_REPLACE_HISTORY", 20,
                              QTEXT+$<position>5.offset, $<position>5.size ) != 0 )
        {
            sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replParseTree>$, qriParseTree);
        QC_SET_INIT_PARSE_TREE($<replParseTree>$, $<position>1);
        QR_PARSE_TREE_INIT($<replParseTree>$);
            
        $<replParseTree>$->common.stmtKind = QCI_STMT_ALT_REPLICATION_DELETE_ITEM_REPLACE_HISTORY;

        SET_POSITION( $<replParseTree>$->replName, $<position>3);
 
        $<replParseTree>$->common.parse    = qcc::parse;
        $<replParseTree>$->common.validate = qrc::validateDeleteItemReplaceHistory;
        $<replParseTree>$->common.optimize = qcc::optimize;
        $<replParseTree>$->common.execute  = qcc::executeError;
    };

opt_buffer_init_size
    : /* empty */
    {        
        QCP_STRUCT_ALLOC( $<replApplierBuffer>$, qriReplApplierBuffer );

        $<replApplierBuffer>$->size = 0;
        $<replApplierBuffer>$->type = 'M';
    }
    | TL_INTEGER TI_IDENTIFIER
    {
        SLong sBufferSize;
        qcuSqlSourceInfo sqlInfo;        

        QCP_STRUCT_ALLOC( $<replApplierBuffer>$, qriReplApplierBuffer );

        if( qtc::getBigint( QTEXT, &sBufferSize, &$<position>1 ) != IDE_SUCCESS )
        {
            YYABORT;
        }
        $<replApplierBuffer>$->size = sBufferSize;

        idlOS::strUpper( QTEXT + $<position>2.offset, $<position>2.size );

        if ( idlOS::strMatch( "K", 1,
                 QTEXT+$<position>2.offset, $<position>2.size) == 0 )
        {
            $<replApplierBuffer>$->type = 'K';
        }
        else if ( idlOS::strMatch( "M", 1,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0 )
        {
            $<replApplierBuffer>$->type = 'M';
        }
        else if ( idlOS::strMatch( "G", 1,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0) 
        {
            $<replApplierBuffer>$->type = 'G';
        }
        else
        {
            // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
         }
    }
    ;


opt_repl_options
    : /*empty*/
    {
        $<replOptions>$ = NULL;
    }
    | TI_NONQUOTED_IDENTIFIER repl_options
    {
        qcuSqlSourceInfo sqlInfo;
        if (idlOS::strMatch(
                "OPTIONS", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<replOptions>$ = $<replOptions>2;
        }
        else
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    ;

repl_options
    : repl_options repl_option
    {
        qriReplOptions* sLast;

        $<replOptions>$ = $<replOptions>1;
        for ( sLast = $<replOptions>$;
              sLast->next != NULL;
              sLast = sLast->next )
        {
            /* Nothing to do */
        }
        sLast->next = $<replOptions>2;
    }
    | repl_option
    {
        $<replOptions>$ = $<replOptions>1;
    }
    ;

repl_option
    : TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo sqlInfo;

        QCP_STRUCT_ALLOC($<replOptions>$, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replOptions>$ );

        if (idlOS::strMatch(
                "RECOVERY", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<replOptions>$->optionsFlag = RP_OPTION_RECOVERY_SET;
        }
        else if (idlOS::strMatch(
                "GAPLESS", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0 )
        {
            $<replOptions>$->optionsFlag = RP_OPTION_GAPLESS_SET;
        }
        else if (idlOS::strMatch(
                "GROUPING", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0 )
        {
            $<replOptions>$->optionsFlag = RP_OPTION_GROUPING_SET;
        }
        else if (idlOS::strMatch(
                "DDL_REPLICATE", 13,
                QTEXT+$<position>1.offset, $<position>1.size) == 0 )
        {
            $<replOptions>$->optionsFlag = RP_OPTION_DDL_REPLICATE_SET;
        }
        else if ( idlOS::strMatch(
                  "V6_PROTOCOL", 11,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0 )
        {
            /* BUG-46528 Apply __REPLICATION_USE_V6_PROTOCOL to each replication  */
            $<replOptions>$->optionsFlag = RP_OPTION_V6_PROTOCOL_SET;
            $<replOptions>$->logDirPath  = NULL;
            $<replOptions>$->next        = NULL;
        }
        else
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_REPL_OPTION,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TA_OFFLINE offline_dirs
    {
        QCP_STRUCT_ALLOC($<replOptions>$, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replOptions>$ );

        $<replOptions>$->optionsFlag = RP_OPTION_OFFLINE_SET;
        $<replOptions>$->logDirPath  = $<replDirPath>2;
    }
    | TR_PARALLEL TL_INTEGER opt_buffer_init_size 
    {
        qcuSqlSourceInfo sqlInfo;
        SLong            sParallelCount;
    
        QCP_STRUCT_ALLOC($<replOptions>$, qriReplOptions);
        QR_REPL_OPTIONS_INIT( $<replOptions>$ );
        
        if ( qtc::getBigint( QTEXT, &sParallelCount, &($<position>2) ) != IDE_SUCCESS )
        {
            sqlInfo.setSourceInfo( STATEMENT, &($<position>2) );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            $<replOptions>$->optionsFlag = RP_OPTION_PARALLEL_RECEIVER_APPLY_SET;
            $<replOptions>$->parallelReceiverApplyCount = sParallelCount;
            $<replOptions>$->applierBuffer = $<replApplierBuffer>3;
        }
    }
    | TR_LOCAL TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        // peer replication name
        if ( $<position>2.size > QC_MAX_NAME_LEN )
        {
            sqlInfo.setSourceInfo( STATEMENT, &($<position>2) );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            /* Nothing to do */
        }

        QCP_STRUCT_ALLOC( $<replOptions>$, qriReplOptions );
        QR_REPL_OPTIONS_INIT( $<replOptions>$ );

        $<replOptions>$->optionsFlag = RP_OPTION_LOCAL_SET;

        SET_POSITION( $<replOptions>$->peerReplName, $<position>2 );
    }
    ;

offline_dirs
    : offline_dirs TS_COMMA offline_dir
    {
        qriReplDirPath* sLast;

        $<replDirPath>$ = $<replDirPath>1;
        for ( sLast = $<replDirPath>$;
              sLast->next != NULL;
              sLast = sLast->next )
        {
            /* Nothing to do */
        }
        sLast->next = $<replDirPath>3;
    }
    | offline_dir
    {
        $<replDirPath>$ = $<replDirPath>1;
    }
    ;

offline_dir
    : TL_LITERAL
    {
        qcuSqlSourceInfo    sqlInfo;

        if ($<position>1.size > 512)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_PATH_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replDirPath>$, qriReplDirPath);

        // offline dir path
        SET_POSITION($<replDirPath>$->path, $<position>1);
        $<replDirPath>$->path.offset++;
        $<replDirPath>$->path.size -= 2;
        $<replDirPath>$->next = NULL;
    }
    ;

//PROJ-1541
repl_mode
    : TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo sqlInfo;

        if (idlOS::strMatch(
                "LAZY", 4,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<sIntVal>$ = RP_LAZY_MODE;
        }
        else if (idlOS::strMatch(
                "EAGER", 5,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<sIntVal>$ = RP_EAGER_MODE;
        }
        else if (idlOS::strMatch(
                "NOWAIT", 6,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<sIntVal>$ = RP_NOWAIT_MODE;
        }
        else if (idlOS::strMatch(
                "CONSISTENT", 10,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            $<sIntVal>$ = RP_CONSISTENT_MODE;
        }
        else
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    ;

opt_repl_mode
    : /* empty */
    {
        $<sIntVal>$ = RP_DEFAULT_MODE;  // BUG-17616
    }
    | repl_mode
    {
        $<sIntVal>$ = $<sIntVal>1;
    }
    ;

replication_with_hosts
    : replication_hosts
    | TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo sqlInfo;

        if (idlOS::strMatch(
                RP_SOCKET_UNIX_DOMAIN_STR, RP_SOCKET_UNIX_DOMAIN_LEN,
                QTEXT+$<position>1.offset, $<position>1.size) != 0)
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replHost>$, qriReplHost);
        QCP_STRUCT_ALLOC($<replHost>$->connOpt, qriReplConnOpt);

        // host IP
        SET_POSITION($<replHost>$->hostIp, $<position>1);

        // port
        $<replHost>$->portNumber = 0;

        // connection type
        $<replHost>$->connOpt->connType = RP_SOCKET_TYPE_UNIX;
        $<replHost>$->connOpt->ibLatency = RP_IB_LATENCY_NONE;
        
        $<replHost>$->next       = NULL;
    }
    ;

replication_hosts
    : replication_hosts repl_host
    {
        qriReplHost * sLast;

        $<replHost>$ = $<replHost>1;
        for ( sLast = $<replHost>$; sLast->next != NULL; sLast = sLast->next )
        {
            /* Nothing to do */
        }
        sLast->next = $<replHost>2;
    }
    | repl_host
    {
        $<replHost>$ = $<replHost>1;
    }
    ;

repl_host
    : TL_LITERAL TS_COMMA TL_INTEGER opt_using_conntype
    {
        SLong               sPortNo;
        qcuSqlSourceInfo    sqlInfo;

        // host IP
        if ($<position>1.size > QC_MAX_IP_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replHost>$, qriReplHost);

        // host IP
        SET_POSITION($<replHost>$->hostIp, $<position>1);

        $<replHost>$->hostIp.offset++;
        $<replHost>$->hostIp.size -= 2;

        // port
        if( qtc::getBigint( QTEXT, &sPortNo, &($<position>3) ) != IDE_SUCCESS )
        {
            YYABORT;
        }
        $<replHost>$->portNumber = sPortNo;

        // connection type
        $<replHost>$->connOpt = $<replConnOpt>4;

        $<replHost>$->next       = NULL;
    }
    ;

opt_using_conntype
    : // empty
    {
        QCP_STRUCT_ALLOC( $<replConnOpt>$, qriReplConnOpt );
       
        $<replConnOpt>$->connType  = RP_SOCKET_TYPE_TCP;
        $<replConnOpt>$->ibLatency = RP_IB_LATENCY_NONE;

    }
    | TR_USING TI_IDENTIFIER 
    {
        qcuSqlSourceInfo sqlInfo;

        QCP_STRUCT_ALLOC( $<replConnOpt>$, qriReplConnOpt );
        
        if( idlOS::strMatch(
                RP_SOCKET_TCP_STR, RP_SOCKET_TCP_LEN,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<replConnOpt>$->connType  = RP_SOCKET_TYPE_TCP;
            $<replConnOpt>$->ibLatency = RP_IB_LATENCY_NONE;
        }
        else if( idlOS::strMatch(
                RP_SOCKET_IB_STR, RP_SOCKET_IB_LEN,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<replConnOpt>$->connType  = RP_SOCKET_TYPE_IB;
            $<replConnOpt>$->ibLatency = RP_IB_LATENCY_0;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }


    }
    | TR_USING TI_IDENTIFIER TL_INTEGER
    { // IB
        SLong            sLatency;
        qcuSqlSourceInfo sqlInfo;

        QCP_STRUCT_ALLOC( $<replConnOpt>$, qriReplConnOpt );

        if ( idlOS::strMatch(
                RP_SOCKET_IB_STR, RP_SOCKET_IB_LEN,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<replConnOpt>$->connType  = RP_SOCKET_TYPE_IB;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        
        if ( qtc::getBigint( QTEXT, &sLatency, &($<position>3) ) == IDE_SUCCESS )
        {
            if ( sLatency == (SLong)RP_IB_LATENCY_0 || sLatency == (SLong)RP_IB_LATENCY_1 )
            {
                $<replConnOpt>$->ibLatency = (rpIBLatency)sLatency;
            }
            else
            { // syntax error
                sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        
    }
    ;


opt_role
    : // empty
    {
        $<sIntVal>$ = RP_ROLE_REPLICATION;
    }
    | TR_FOR TA_ANALYSIS_PROPAGATION
    {
        $<sIntVal>$ = RP_ROLE_ANALYSIS_PROPAGATION;
    }
    | TR_FOR TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo sqlInfo;

        if (idlOS::strMatch(
                "ANALYSIS", 8,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<sIntVal>$ = RP_ROLE_ANALYSIS;
        }
        else if( idlOS::strMatch(
                 "PROPAGATION", 11,
                 QTEXT+$<position>2.offset, $<position>2.size ) == 0 )
        {
            $<sIntVal>$ = RP_ROLE_PROPAGATION;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    | TR_FOR TI_NONQUOTED_IDENTIFIER TR_LOGGING
    {
        qcuSqlSourceInfo sqlInfo;

        if ( idlOS::strMatch(
             "PROPAGABLE", 10,
             QTEXT+$<position>2.offset, $<position>2.size ) == 0 )
        {

            $<sIntVal>$ = RP_ROLE_PROPAGABLE_LOGGING;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    ;

opt_conflict_resolution
    : // empty
    {
        $<sIntVal>$ = RP_CONFLICT_RESOLUTION_NONE;
    }
    | TR_AS TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "MASTER", 6,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<sIntVal>$ = RP_CONFLICT_RESOLUTION_MASTER;
        }
        else if (idlOS::strMatch(
                "SLAVE", 5,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
        {
            $<sIntVal>$ = RP_CONFLICT_RESOLUTION_SLAVE;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    ;

repl_tbl_commalist
    : // empty
    {
        $<replItem>$ = NULL;
    }
    | repl_tbl_commalist TS_COMMA repl_tbl
    {
        qriReplItem   * sLast;

        $<replItem>$ = $<replItem>1;
        for ( sLast = $<replItem>$; sLast->next != NULL; sLast = sLast->next )
        {
            /* Nothing to do */
        }
        sLast->next = $<replItem>3;
    }
    | repl_tbl
    {
        $<replItem>$ = $<replItem>1;
    }
    ;

repl_tbl
    : TR_FROM TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
        TR_TO TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        // table names
        if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>6));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>8.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>8));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );
                       
        SET_POSITION($<replItem>$->localUserName, $<position>2);
        SET_POSITION($<replItem>$->localTableName, $<position>4);
        SET_POSITION($<replItem>$->remoteUserName, $<position>6);
        SET_POSITION($<replItem>$->remoteTableName, $<position>8);
        
        $<replItem>$->replication_unit = RP_REPLICATION_TABLE_UNIT;
        $<replItem>$->ncharLiteralPos  = NULL;     // PROJ-1579 NCHAR
        $<replItem>$->next             = NULL;
    }
    |  TR_FROM TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER 
        TR_TO TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER 
    {
        qcuSqlSourceInfo    sqlInfo;

        // table names
        if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>6));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if ($<position>8.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>8));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        if ($<position>10.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>10));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        if ($<position>12.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>12));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );

        SET_POSITION($<replItem>$->localUserName, $<position>2);
        SET_POSITION($<replItem>$->localTableName, $<position>4);
        SET_POSITION($<replItem>$->localPartitionName, $<position>6);
        
        SET_POSITION($<replItem>$->remoteUserName, $<position>8);
        SET_POSITION($<replItem>$->remoteTableName, $<position>10);
        SET_POSITION($<replItem>$->remotePartitionName, $<position>12);
        
        $<replItem>$->replication_unit = RP_REPLICATION_PARTITION_UNIT;
        $<replItem>$->ncharLiteralPos  = NULL;     // PROJ-1579 NCHAR
        $<replItem>$->next             = NULL;
    }
    ;

temp_repl_tbl_commalist
    : temp_repl_tbl_commalist TS_COMMA temp_repl_tbl
    {
        qriReplItem   * sLast;

        $<replItem>$ = $<replItem>1;
        for ( sLast = $<replItem>$; sLast->next != NULL; sLast = sLast->next )
        {
            /* Nothing to do */
        }
        sLast->next = $<replItem>3;
    }
    | temp_repl_tbl
    {
        $<replItem>$ = $<replItem>1;
    }
    ;

temp_repl_tbl
    : TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        // user name
        if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        // table name
        if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );
                       
        SET_POSITION($<replItem>$->localUserName, $<position>1);
        SET_POSITION($<replItem>$->localTableName, $<position>3);
        
        $<replItem>$->replication_unit = RP_REPLICATION_TABLE_UNIT;
        $<replItem>$->ncharLiteralPos  = NULL;     // PROJ-1579 NCHAR
        $<replItem>$->next             = NULL;
    }
    |  TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER 
    {
        qcuSqlSourceInfo    sqlInfo;

        // user name
        if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        // table name
        if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        // partition name
        if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>5));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );

        SET_POSITION($<replItem>$->localUserName, $<position>1);
        SET_POSITION($<replItem>$->localTableName, $<position>3);
        SET_POSITION($<replItem>$->localPartitionName, $<position>5);
        
        $<replItem>$->replication_unit = RP_REPLICATION_PARTITION_UNIT;
        $<replItem>$->ncharLiteralPos  = NULL;     // PROJ-1579 NCHAR
        $<replItem>$->next             = NULL;
    }
    ;

repl_flush_option
    : // empty
    {
        $<replFlushOption>$.flushType = RP_FLUSH_FLUSH;
        $<replFlushOption>$.waitSecond = 0;
    }
    | TO_WAIT TL_INTEGER
    {
        $<replFlushOption>$.flushType = RP_FLUSH_WAIT;
        if( qtc::getBigint( QTEXT,
                            &($<replFlushOption>$.waitSecond),
                            &($<position>2) ) != IDE_SUCCESS )
        {
            YYABORT;
        }
    }
    | TR_ALL
    {
        $<replFlushOption>$.flushType = RP_FLUSH_ALL;
        $<replFlushOption>$.waitSecond = 0;
    }
    | TR_ALL TO_WAIT TL_INTEGER
    {
        $<replFlushOption>$.flushType = RP_FLUSH_ALL_WAIT;
        if( qtc::getBigint( QTEXT,
                            &($<replFlushOption>$.waitSecond),
                            &($<position>3) ) != IDE_SUCCESS )
        {
            YYABORT;
        }
    }
    | TR_FROM TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        $<replFlushOption>$.flushType = RP_FLUSH_XLOGFILE;
        if(idlOS::strMatch(
                "XLOGFILE", 8,
                QTEXT+$<position>2.offset, $<position>2.size) != 0) 
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
    }
    ;

// to fix BUG-17885
// sIntVal includes values of two variables (start_mode, parallel_factor).
// If sIntVal is negative number, start mode is RP_SYNC_START.
// else start mode is RP_SYNC_START_ONLY.
// Absoulte value of sIntVal is number of parallel factor.
repl_sync_parallel
    : TI_NONQUOTED_IDENTIFIER TR_PARALLEL TL_INTEGER
    {
        SLong               sParallelFactor;
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
               "ONLY", 4,
               QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            if( qtc::getBigint( QTEXT, &sParallelFactor, &($<position>3) ) != IDE_SUCCESS )
            {
                YYABORT;
            }
            if (sParallelFactor <= 0)
            {
                sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                sqlInfo.init( MEMORY );
                IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                          "Parallel factor is invalid.") );
                sqlInfo.fini();
                YYABORT;
            }
            $<sIntVal>$ = (SInt)(sParallelFactor * (-1));
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini(); 
            YYABORT;
        }
    }
    | TR_PARALLEL TL_INTEGER
    {
        SLong               sParallelFactor;
        qcuSqlSourceInfo    sqlInfo;

        if( qtc::getBigint( QTEXT, &sParallelFactor, &($<position>2) ) != IDE_SUCCESS )
        {
            YYABORT;
        }
        if (sParallelFactor <= 0)
        {
            sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      "Parallel factor is invalid.") );
            sqlInfo.fini(); 
            YYABORT;
        }
        $<sIntVal>$ = (SInt)sParallelFactor;
    }
    ;
opt_repl_sync_table
    :  // empty
    {
        $<replItem>$ = NULL;
    }
    | TR_TABLE repl_sync_table_commalist
    {
        $<replItem>$ = $<replItem>2;
    }
    ;
repl_sync_table_commalist
    : repl_sync_table_commalist TS_COMMA repl_sync_table
    {
        qriReplItem * sItem;
        $<replItem>$ = $<replItem>1;
        qcuSqlSourceInfo    sqlInfo;

        /* check duplicated table name */
        for ( sItem = $<replItem>$;
              sItem != NULL;
              sItem = sItem->next )
        {
            if ((idlOS::strMatch(QTEXT+sItem->localUserName.offset,
                                       sItem->localUserName.size,
                                 QTEXT+$<replItem>3->localUserName.offset,
                                       $<replItem>3->localUserName.size) == 0) &&
                (idlOS::strMatch(QTEXT+sItem->localTableName.offset,
                                       sItem->localTableName.size,
                                 QTEXT+$<replItem>3->localTableName.offset,
                                       $<replItem>3->localTableName.size) == 0))
            {
                sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
                sqlInfo.init(MEMORY);
                IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_SYNC_TABLE,
                                        sqlInfo.getErrMessage()));
                sqlInfo.fini();
                YYABORT;
            }
        }
        for ( sItem = $<replItem>$;
              sItem->next != NULL;
              sItem = sItem->next )
        {
            /* Nothing to do */
        }
        sItem->next = $<replItem>3;
    }
    | repl_sync_table
    {
        $<replItem>$ = $<replItem>1;
    }
    ;
repl_sync_table
    : TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        // user name length check
        if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        // table name length check
        if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );
        
        SET_POSITION($<replItem>$->localUserName, $<position>1);
        SET_POSITION($<replItem>$->localTableName, $<position>3);
        
        $<replItem>$->replication_unit = RP_REPLICATION_TABLE_UNIT;
        $<replItem>$->next = NULL;
    }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER 
    {
        qcuSqlSourceInfo    sqlInfo;

        // user name length check
        if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        // table name length check
        if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>3));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        // partition name length check
        if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>5));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        QCP_STRUCT_ALLOC($<replItem>$, qriReplItem);
        idlOS::memset( $<replItem>$,
                       0x00,
                       ID_SIZEOF(qriReplItem) );

        SET_POSITION($<replItem>$->localUserName, $<position>1);
        SET_POSITION($<replItem>$->localTableName, $<position>3);
        SET_POSITION($<replItem>$->localPartitionName, $<position>5);
        $<replItem>$->replication_unit = RP_REPLICATION_PARTITION_UNIT;
        $<replItem>$->next = NULL;
    }
    ;

repl_start_option
    : // empty
    {
        QCP_STRUCT_ALLOC($<replStartOption>$, qriReplStartOption);

        $<replStartOption>$->startOption = RP_START_OPTION_NONE;
        $<replStartOption>$->startSN     = 0;
    }
    | TI_NONQUOTED_IDENTIFIER
    {
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "RETRY", 5,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replStartOption>$, qriReplStartOption);

            $<replStartOption>$->startOption = RP_START_OPTION_RETRY;
            $<replStartOption>$->startSN     = 0;
        }
        else if (idlOS::strMatch(
                "CONDITIONAL", 11,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
        {
            QCP_STRUCT_ALLOC($<replStartOption>$, qriReplStartOption);

            $<replStartOption>$->startOption = RP_START_OPTION_CONDITIONAL;
            $<replStartOption>$->startSN     = 0;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>1));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

   }
    | TR_AT TI_NONQUOTED_IDENTIFIER TS_OPENING_PARENTHESIS TL_INTEGER TS_CLOSING_PARENTHESIS
      /* ALTER REPLICATION replicaiton_name START AT SN(sn) */
    {
        SLong               sValue;
        qcuSqlSourceInfo    sqlInfo;

        if (idlOS::strMatch(
                "SN", 2,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if( qtc::getBigint( QTEXT, &sValue, &($<position>4) ) != IDE_SUCCESS )
        {
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        if( sValue < 0 )
        { // syntax error
            sqlInfo.setSourceInfo(STATEMENT, &($<position>4));
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        QCP_STRUCT_ALLOC($<replStartOption>$, qriReplStartOption);

        $<replStartOption>$->startOption = RP_START_OPTION_SN;
        $<replStartOption>$->startSN     = sValue;
    }
    ;

/*****************************************
 * DDL
 ****************************************/
truncate_table_statement
    : TA_TRUNCATE TR_TABLE user_object_name
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateTruncateTable;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdd::executeTruncateTable;
      }
    ;

rename_table_statement
    : TO_RENAME user_object_name TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>2->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>2->objectName);

          /* set newTableName position */
          SET_POSITION($<tableParseTree>$->newTableName,
                       $<position>4);

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateRenameTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeRenameTable;
      }
    ;

/* PROJ-2441 flashback */
flashback_table_statement
    : TO_FLASHBACK TR_TABLE user_object_name TR_TO TR_BEFORE TR_DROP opt_flashback_rename
        {
            QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
            QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
            QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );
            
            /* set userName position */
            SET_POSITION($<tableParseTree>$->userName,
            $<userNObjName>3->userName);
            /* set tableName position */
            SET_POSITION($<tableParseTree>$->tableName,
            $<userNObjName>3->objectName);
            
            /* set newTableName position */
            SET_POSITION($<tableParseTree>$->newTableName,$<position>7);

            $<tableParseTree>$->common.parse    = qcc::parse;
            $<tableParseTree>$->common.validate = qdbFlashback::validateFlashbackTable;
            $<tableParseTree>$->common.optimize = qcc::optimize;
            $<tableParseTree>$->common.execute  = qdbFlashback::executeFlashbackTable;
        }
    ;

opt_flashback_rename
    : /* empty */
      {
          SET_EMPTY_POSITION($<position>$);
      }
    |
      TO_RENAME TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;
          
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
              sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<position>$ = $<position>3;
      }
      ;

drop_sequence_statement
    : TR_DROP TR_SEQUENCE user_object_name
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);
          
          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set objectName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateDropSequence;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdd::executeDropSequence;
      }
    ;

drop_index_statement
    : TR_DROP TO_INDEX user_object_name
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set objectName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          /* PROJ-1090 Function-based Index */
          $<dropParseTree>$->common.parse    = qdd::parseDropIndex;
          $<dropParseTree>$->common.validate = qdd::validateDropIndex;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdd::executeDropIndex;
      }
    ;

drop_table_statement
    : TR_DROP TR_TABLE user_object_name opt_drop_behavior
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set objectName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          if ($<boolType>4 == ID_TRUE)
          {
              $<dropParseTree>$->flag &= ~QDD_DROP_CASCADE_CONSTRAINTS_MASK;
              $<dropParseTree>$->flag |= QDD_DROP_CASCADE_CONSTRAINTS_TRUE;
          }
          else
          {
              $<dropParseTree>$->flag &= ~QDD_DROP_CASCADE_CONSTRAINTS_MASK;
              $<dropParseTree>$->flag |= QDD_DROP_CASCADE_CONSTRAINTS_FALSE;
          }

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateDropTable;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdd::executeDropTable;
      }
    ;

/* PROJ-2441 flashback */
purge_table_statement
    : TO_PURGE TR_TABLE user_object_name
      {
        QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
        QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
        QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

        /* set userName position */
        SET_POSITION($<dropParseTree>$->userName,
        $<userNObjName>3->userName);
        /* set objectName position */
        SET_POSITION($<dropParseTree>$->objectName,
        $<userNObjName>3->objectName);

        $<dropParseTree>$->common.parse    = qcc::parse;
        $<dropParseTree>$->common.validate = qdbFlashback::validatePurgeTable;
        $<dropParseTree>$->common.optimize = qcc::optimize;
        $<dropParseTree>$->common.execute  = qdbFlashback::executePurgeTable;
      }
    ;

/* PROJ-1810 Partition Exchange */
disjoin_table_statement
    : TA_DISJOIN TR_TABLE TI_IDENTIFIER //3
      TS_OPENING_PARENTHESIS
        disjoin_partitioning_clause //5
      TS_CLOSING_PARENTHESIS
      {
#ifdef ALTIBASE_PRODUCT_XDB
          qcuSqlSourceInfo  sqlInfo;
          
          sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
          sqlInfo.init( MEMORY );
          IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage() ) );
          sqlInfo.fini();
          YYABORT;
#else
          qdDisjoinTable    * sCurr;
          UInt                sPartCount;

          QCP_STRUCT_ALLOC( $<disjoinTableParseTree>$, qdDisjoinTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<disjoinTableParseTree>$, $<position>1 );
          QD_DISJOIN_PARSE_TREE_INIT( $<disjoinTableParseTree>$ );
      
          /* set tableName position */
          SET_POSITION( $<disjoinTableParseTree>$->tableName, $<position>3 );

          $<disjoinTableParseTree>$->disjoinTable = $<disjoinTable>5;
          for ( sCurr = $<disjoinTable>5, sPartCount = 0;
                sCurr != NULL;
                sCurr = sCurr->next, sPartCount++ ) ;

          $<disjoinTableParseTree>$->partCount = sPartCount;

          $<disjoinTableParseTree>$->common.parse    = qcc::parse;
          $<disjoinTableParseTree>$->common.validate = qdbDisjoin::validateDisjoinTable;
          $<disjoinTableParseTree>$->common.optimize = qcc::optimize;
          $<disjoinTableParseTree>$->common.execute  = qdbDisjoin::executeDisjoinTable;
#endif
      }
    ;

/* PROJ-1810 Partition Exchange */
disjoin_partitioning_clause
    : TR_PARTITION TI_IDENTIFIER TR_TO TR_TABLE TI_IDENTIFIER
      TS_COMMA disjoin_partitioning_clause
      {
          qcuSqlSourceInfo       sqlInfo;
          qdDisjoinTable       * sCurr;

          /* check object name length */
          if ( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo ( STATEMENT, & $<position>2 );
              sqlInfo.init ( MEMORY );
              IDE_SET ( ideSetErrorCode ( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                          sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if ( $<position>5.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          /* check duplicate partition/table name */
          for ( sCurr = $<disjoinTable>7;
                sCurr != NULL;
                sCurr = sCurr->next )
          {
              /* partition name */
              if ( idlOS::strMatch( (SChar*)( sCurr->oldPartName.stmtText
                                              + sCurr->oldPartName.offset ),
                                    sCurr->oldPartName.size,
                                    QTEXT+$<position>2.offset,
                                    $<position>2.size )
                   == 0 )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<disjoinTable>7->oldPartName );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DUPLICATE_PARTITION_NAME,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  /* Nothing To Do */
              }

              /* table name */
              if ( idlOS::strMatch( (SChar*)( sCurr->newTableName.stmtText
                                              + sCurr->newTableName.offset ),
                                    sCurr->newTableName.size,
                                    QTEXT+$<position>5.offset,
                                    $<position>5.size )
                   == 0 )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<disjoinTable>7->newTableName );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DUPLICATE_TABLE_NAME,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  /* Nothing To Do */
              }
          }

          QCP_STRUCT_ALLOC ( $<disjoinTable>$, qdDisjoinTable );
          QD_SET_INIT_DISJOIN_TABLE( $<disjoinTable>$ );

          SET_POSITION( $<disjoinTable>$->oldPartName, $<position>2 );
          SET_POSITION( $<disjoinTable>$->newTableName, $<position>5 );
          $<disjoinTable>$->next = $<disjoinTable>7;
      }
    | TR_PARTITION TI_IDENTIFIER TR_TO TR_TABLE TI_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          if ( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if ( $<position>5.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC ( $<disjoinTable>$, qdDisjoinTable );
          QD_SET_INIT_DISJOIN_TABLE( $<disjoinTable>$ );

          SET_POSITION( $<disjoinTable>$->oldPartName, $<position>2 );
          SET_POSITION( $<disjoinTable>$->newTableName, $<position>5 );
      }
    ;

/* PROJ-1810 Partition Exchange */
join_table_statement
    : TA_CONJOIN TR_TABLE TI_IDENTIFIER // 3
        join_partitioning_clause // 4
        join_table_options // 5; table options for JOIN TABLE statement
        opt_lob_attribute_list // 6; lob column properties
      {
          qcuSqlSourceInfo    sqlInfo;
#ifdef ALTIBASE_PRODUCT_XDB
          sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
          sqlInfo.init( MEMORY );
          IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage() ) );
          sqlInfo.fini();
          YYABORT;
#else
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set new table name position */
          SET_POSITION( $<tableParseTree>$->tableName, $<position>3 );

          $<tableParseTree>$->partTable = $<partTable>4;

          /* lob column property */
          $<tableParseTree>$->lobAttr = $<lobAttribute>6;

          /* PROJ-2359 Table/Partition Access Option */
          $<tableParseTree>$->accessOption = $<tableOptions>5->accessOption;

          // TableSpace Name
          if ($<tableOptions>5->TBSName == NULL)
          {
              SET_EMPTY_POSITION($<tableParseTree>$->TBSName);
          }
          else
          {
              SET_POSITION($<tableParseTree>$->TBSName,
                           (*($<tableOptions>5->TBSName)));
          }

          // PCTFREE
          if ($<tableOptions>5->pctFree == NULL)
          {
              $<tableParseTree>$->segAttr.mPctFree=
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctFree =
                  *($<tableOptions>5->pctFree);
          }

          // PCTUSED
          if ($<tableOptions>5->pctUsed == NULL)
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  *($<tableOptions>5->pctUsed);
          }

          // INITTRANS
          if ($<tableOptions>5->initTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  *($<tableOptions>5->initTrans);
          }

          // MAXTRANS
          if ($<tableOptions>5->maxTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  *($<tableOptions>5->maxTrans);
          }

          // PROJ-1671 Bitmap Segment
          // Segment Storage Attribute list
          if ($<tableOptions>5->segStorageAttr->initExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  *($<tableOptions>5->segStorageAttr->initExtCnt);
              $<tableParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->nextExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  *($<tableOptions>5->segStorageAttr->nextExtCnt);
              $<tableParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->minExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  *($<tableOptions>5->segStorageAttr->minExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->maxExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  *($<tableOptions>5->segStorageAttr->maxExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          $<tableParseTree>$->isRowmovement = $<tableOptions>5->isRowmovement;

          // PROJ-1665
          $<tableParseTree>$->loggingMode = $<tableOptions>5->loggingMode;
          $<tableParseTree>$->parallelDegree = $<tableOptions>5->parallelDegree;

          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse = qcc::parse;
          $<tableParseTree>$->common.validate = qdbJoin::validateJoinTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbJoin::executeJoinTable;
#endif
      }
    ;

/* PROJ-1810 Partition Exchange */
join_partitioning_clause
    : TR_PARTITION TR_BY
      TI_NONQUOTED_IDENTIFIER // 3; RANGE or LIST
      TS_OPENING_PARENTHESIS
        column_commalist // 5; part key column list
      TS_CLOSING_PARENTHESIS
      TS_OPENING_PARENTHESIS
        join_table_attr_list // 8; TABLE ... TO PARTITION ...
      TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo       sqlInfo;
          qdPartitionAttribute * sCurr;
          UInt                   sTotalPartCnt = 0;
          UInt                   sDefPartCnt = 0;

          QCP_STRUCT_ALLOC( $<partTable>$, qdPartitionedTable );
          // qdPartitionedTable ʱȭ
          QD_SET_INIT_PART_TABLE( $<partTable>$ );

          if( idlOS::strMatch( "RANGE",
                               5,
                               QTEXT+$<position>3.offset,
                               $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_RANGE;
              $<partTable>$->partInfoList = NULL;

              for( sCurr = $<partAttr>8;
                   sCurr != NULL;
                   sCurr = sCurr->next )
              {
                  if( ( sCurr->partValuesType == QD_LIST_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                  sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  if( sCurr->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  sTotalPartCnt++;
              }

              if( sDefPartCnt != 1 )
              {
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, "" ) );
                  YYABORT;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else if ( idlOS::strMatch( "RANGE_USING_HASH",
                                      16,
                                      QTEXT+$<position>3.offset,
                                      $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_RANGE_USING_HASH;
              $<partTable>$->partInfoList = NULL;

              for ( sCurr = $<partAttr>8;
                    sCurr != NULL;
                    sCurr = sCurr->next )
              {
                  if ( ( sCurr->partValuesType == QD_LIST_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                  sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  if ( sCurr->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  sTotalPartCnt++;
              }

              if ( sDefPartCnt != 1 )
              {
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, "" ) );
                  YYABORT;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else if( idlOS::strMatch( "LIST",
                                    4,
                                    QTEXT+$<position>3.offset,
                                    $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_LIST;
              $<partTable>$->partInfoList = NULL;

              for( sCurr = $<partAttr>8;
                   sCurr != NULL;
                   sCurr = sCurr->next )
              {
                  if( ( sCurr->partValuesType == QD_RANGE_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  if( sCurr->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  sTotalPartCnt++;
              }

              if( sDefPartCnt != 1 )
              {
                  IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, "") );
                  YYABORT;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
  ;

/* PROJ-1810 Partition Exchange */
join_table_attr_list
    : join_table_attr_list TS_COMMA join_table_attr
      {
          qdPartitionAttribute * sLastPart;
          $<partAttr>$ = $<partAttr>1;

          for( sLastPart = $<partAttr>$;
               sLastPart->next != NULL;
               sLastPart = sLastPart->next )
              ;

          sLastPart->next = $<partAttr>3;
      }
    | join_table_attr
      {
          $<partAttr>$ = $<partAttr>1;
      }
    ;

/* PROJ-1810 Partition Exchange */
join_table_attr
    : TR_TABLE TI_IDENTIFIER // 2; table name(old)
      TR_TO
      TR_PARTITION TI_IDENTIFIER // 5; partition name(new)
      TR_VALUES TR_LESS TR_THAN
      TS_OPENING_PARENTHESIS
        part_key_cond_list  // 10; partition key condition list
      TS_CLOSING_PARENTHESIS
      {
          /* Range Partition */
          qcuSqlSourceInfo sqlInfo;

          /* table name length */
          if( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing To Do */
          }

          /* partition name length */
          if( $<position>5.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing To Do */
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->oldTableName, $<position>2 );
          SET_POSITION( $<partAttr>$->tablePartName, $<position>5 );

          $<partAttr>$->partKeyCond = $<valueNode>10;
          $<partAttr>$->partValuesType = QD_RANGE_VALUES_TYPE;
          $<partAttr>$->next = NULL;
      }
    | TR_TABLE TI_IDENTIFIER // 2; table name(old)
      TR_TO
      TR_PARTITION TI_IDENTIFIER // 5; partition name(new)
      TR_VALUES
      TS_OPENING_PARENTHESIS
        part_key_cond_list  // 8; partition key condition list
      TS_CLOSING_PARENTHESIS
      {
          /* List Partition */
          qcuSqlSourceInfo sqlInfo;

          if( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if( $<position>5.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->oldTableName, $<position>2 );
          SET_POSITION( $<partAttr>$->tablePartName, $<position>5 );

          $<partAttr>$->partKeyCond = $<valueNode>8;
          $<partAttr>$->partValuesType = QD_LIST_VALUES_TYPE;
          $<partAttr>$->next = NULL;
      }
    | TR_TABLE TI_IDENTIFIER // 2; table name(old)
      TR_TO
      TR_PARTITION TI_IDENTIFIER // 5; partition name(new)
      TR_VALUES TR_DEFAULT
      {
          /* Default Partition */
          qcuSqlSourceInfo sqlInfo;

          if( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY) ;
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if( $<position>5.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->oldTableName, $<position>2 );
          SET_POSITION( $<partAttr>$->tablePartName, $<position>5 );

          $<partAttr>$->partValuesType = QD_DEFAULT_VALUES_TYPE;
          $<partAttr>$->next = NULL;
      }
    ;

join_table_options
    : row_movement_option // 1
      opt_record_access // 2
      tablespace_name_option // 3
      physical_attribute_option // 4
      ttl_option // 5
      storage_option // 6
      logging_option // 7
      parallel_option // 8
      {
          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);

          if ( $<tableRowMovement>1 != NULL )
          {
              $<tableOptions>$->isRowmovement =
                  $<tableRowMovement>1->rowMovement;
          }
          else
          {
              $<tableOptions>$->isRowmovement = ID_FALSE;
          }

          /* PROJ-2359 Table/Partition Access Option */
          $<tableOptions>$->accessOption = $<accessOption>2;

          $<tableOptions>$->TBSName = $<positionPtr>3;

          $<tableOptions>$->pctFree = $<tablePhysicalAttr>4->pctFree;
          $<tableOptions>$->pctUsed  = $<tablePhysicalAttr>4->pctUsed;
          $<tableOptions>$->initTrans  = $<ttl>5->initTrans;
          $<tableOptions>$->maxTrans  = $<ttl>5->maxTrans;

          $<tableOptions>$->segStorageAttr  = $<attrNode>6;

          $<tableOptions>$->loggingMode = $<loggingMode>7;
          $<tableOptions>$->parallelDegree = $<uIntVal>8;
      }
    ;

opt_drop_behavior
: /* empty */
{
    $<boolType>$ = ID_FALSE;
      }
    | TR_CASCADE
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_CASCADE TR_CONSTRAINTS
      {
          $<boolType>$ = ID_TRUE;
      }
    ;

alter_sequence_statement
    : TR_ALTER TR_SEQUENCE user_object_name sequence_options
      {
          /* TASK-7217 Sharded sequence
           * alter sequence restart start with   */
          if( $<sequenceOptions>4->startValue != NULL )
          {
              if ( ($<sequenceOptions>4->flag & QDS_SEQ_OPT_RESTART_MASK) == QDS_SEQ_OPT_RESTART_FALSE )
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                  YYABORT;
              }
          }

          QCP_STRUCT_ALLOC($<seqParseTree>$, qdSequenceParseTree);
          QC_SET_INIT_PARSE_TREE($<seqParseTree>$, $<position>1);
          QD_SEQUENCE_PARSE_TREE_INIT($<seqParseTree>$);

          /* set userName position */
          SET_POSITION($<seqParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set sequenceName position */
          SET_POSITION($<seqParseTree>$->sequenceName,
                       $<userNObjName>3->objectName);

          $<seqParseTree>$->sequenceOptions = $<sequenceOptions>4;

          $<seqParseTree>$->common.parse    = qcc::parse;
          $<seqParseTree>$->common.validate = qds::validateAlterOptions;
          $<seqParseTree>$->common.optimize = qcc::optimize;
          $<seqParseTree>$->common.execute  = qds::executeAlterOptions;
      }
    | TR_ALTER TR_SEQUENCE user_object_name sequence_sync_table
      {
          QCP_STRUCT_ALLOC($<seqParseTree>$, qdSequenceParseTree);
          QC_SET_INIT_PARSE_TREE($<seqParseTree>$, $<position>1);
          QD_SEQUENCE_PARSE_TREE_INIT($<seqParseTree>$);

          /* set userName position */
          SET_POSITION($<seqParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set sequenceName position */
          SET_POSITION($<seqParseTree>$->sequenceName,
                       $<userNObjName>3->objectName);

          $<seqParseTree>$->enableSeqTable = $<boolType>4;
          
          $<seqParseTree>$->common.parse    = qcc::parse;
          $<seqParseTree>$->common.validate = qds::validateAlterSeqTable;
          $<seqParseTree>$->common.optimize = qcc::optimize;
          $<seqParseTree>$->common.execute  = qds::executeAlterSeqTable;
      }
    | TR_ALTER TR_SEQUENCE user_object_name TR_FLUSH TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "CACHE", 5,
                  QTEXT+$<position>5.offset, $<position>5.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC($<seqParseTree>$, qdSequenceParseTree);
          QC_SET_INIT_PARSE_TREE($<seqParseTree>$, $<position>1);
          QD_SEQUENCE_PARSE_TREE_INIT($<seqParseTree>$);

          /* set userName position */
          SET_POSITION($<seqParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set sequenceName position */
          SET_POSITION($<seqParseTree>$->sequenceName,
                       $<userNObjName>3->objectName);
          
          $<seqParseTree>$->flushCache = ID_TRUE;
          
          $<seqParseTree>$->common.parse    = qcc::parse;
          $<seqParseTree>$->common.validate = qds::validateAlterFlushCache;
          $<seqParseTree>$->common.optimize = qcc::optimize;
          $<seqParseTree>$->common.execute  = qds::executeAlterFlushCache;
      }
    ;

sequence_options
    : sequence_options sequence_option
      {
          if( ( $<sequenceOptions>$->startValue     != NULL &&
                $<sequenceOptions>2->startValue     != NULL  ) ||
              ( $<sequenceOptions>$->incrementValue != NULL &&
                $<sequenceOptions>2->incrementValue != NULL  ) ||
              ( $<sequenceOptions>$->cacheValue     != NULL &&
                $<sequenceOptions>2->cacheValue     != NULL  ) ||
              ( $<sequenceOptions>$->cycleOption    != NULL &&
                $<sequenceOptions>2->cycleOption    != NULL  ) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          if( $<sequenceOptions>$->startValue == NULL )
          {
              $<sequenceOptions>$->startValue = $<sequenceOptions>2->startValue;
          }
          if( $<sequenceOptions>$->incrementValue == NULL )
          {
              $<sequenceOptions>$->incrementValue = $<sequenceOptions>2->incrementValue;
          }

          /* TASK-7217 Sharded sequence
           * minvalue option ߺ  ˻ */
          if ( ($<sequenceOptions>2->minValue != NULL) ||
               (($<sequenceOptions>2->flag & QDS_SEQ_OPT_NOMIN_MASK) == QDS_SEQ_OPT_NOMIN_TRUE) )
          {
              //  minvalue    ȵȴ.
              if ( (($<sequenceOptions>$->flag & QDS_SEQ_OPT_NOMIN_MASK) == QDS_SEQ_OPT_NOMIN_TRUE) ||
                   ($<sequenceOptions>$->minValue != NULL) )
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                  YYABORT;
              }

              $<sequenceOptions>$->minValue = $<sequenceOptions>2->minValue;
          }

          /* TASK-7217 Sharded sequence
           * maxvalue option ߺ  ˻ */
          if ( ($<sequenceOptions>2->maxValue != NULL) ||
               (($<sequenceOptions>2->flag & QDS_SEQ_OPT_NOMAX_MASK) == QDS_SEQ_OPT_NOMAX_TRUE) )
          {
              //  maxvalue    ȵȴ.
              if ( (($<sequenceOptions>$->flag & QDS_SEQ_OPT_NOMAX_MASK) == QDS_SEQ_OPT_NOMAX_TRUE) ||
                   ($<sequenceOptions>$->maxValue != NULL) )
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                  YYABORT;
              }

              $<sequenceOptions>$->maxValue = $<sequenceOptions>2->maxValue;
          }

          if( $<sequenceOptions>$->cacheValue == NULL )
          {
              $<sequenceOptions>$->cacheValue = $<sequenceOptions>2->cacheValue;
          }
          if( $<sequenceOptions>$->cycleOption == NULL )
          {
              $<sequenceOptions>$->cycleOption = $<sequenceOptions>2->cycleOption;
          }

          // ɼ ߺ  
          if ( ( ((($<sequenceOptions>$->flag) & QDS_SEQ_OPT_NOMIN_MASK)       == QDS_SEQ_OPT_NOMIN_TRUE) &&
                 ((($<sequenceOptions>2->flag) & QDS_SEQ_OPT_NOMIN_MASK)       == QDS_SEQ_OPT_NOMIN_TRUE) ) ||
               ( ((($<sequenceOptions>$->flag) & QDS_SEQ_OPT_NOMAX_MASK)       == QDS_SEQ_OPT_NOMAX_TRUE) &&
                 ((($<sequenceOptions>2->flag) & QDS_SEQ_OPT_NOMAX_MASK)       == QDS_SEQ_OPT_NOMAX_TRUE) ) ||
               ( ((($<sequenceOptions>$->flag) & QDS_SEQ_OPT_RESTART_MASK)     == QDS_SEQ_OPT_RESTART_TRUE) &&
                 ((($<sequenceOptions>2->flag) & QDS_SEQ_OPT_RESTART_MASK)     == QDS_SEQ_OPT_RESTART_TRUE) ) ||
               ( ((($<sequenceOptions>$->flag) & QDS_SEQ_OPT_SCALE_FIXED_MASK) == QDS_SEQ_OPT_SCALE_FIXED_TRUE) &&
                 ((($<sequenceOptions>2->flag) & QDS_SEQ_OPT_SCALE_FIXED_MASK) == QDS_SEQ_OPT_SCALE_FIXED_TRUE) ) ||
               ( ((($<sequenceOptions>$->flag) & QDS_SEQ_OPT_LOCALITY_MASK)    != 0) &&
                 ((($<sequenceOptions>2->flag) & QDS_SEQ_OPT_LOCALITY_MASK)    != 0) ) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          ($<sequenceOptions>$->flag) |= ( ($<sequenceOptions>2->flag)&(QDS_SEQ_OPT_NOMIN_MASK |
                                                                        QDS_SEQ_OPT_NOMAX_MASK |
                                                                        QDS_SEQ_OPT_LOCALITY_MASK |
                                                                        QDS_SEQ_OPT_RESTART_MASK |
                                                                        QDS_SEQ_OPT_SCALE_FIXED_MASK) );
      }
    | sequence_option
      {
          $<sequenceOptions>$ = $<sequenceOptions>1;
      }
    ;

sequence_option
    : TR_START TR_WITH TL_INTEGER
      {
          SLong sValue;
          if( qtc::getBigint( QTEXT, &sValue, &$<position>3 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          QCP_STRUCT_ALLOC($<sequenceOptions>$->startValue, SLong);
          *$<sequenceOptions>$->startValue    = sValue;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          $<sequenceOptions>$->cycleOption    = NULL;
          $<sequenceOptions>$->flag           = 0;
      }
    | TR_START TR_WITH TS_MINUS_SIGN TL_INTEGER
      {
          SLong sValue;
          if( qtc::getBigint( QTEXT, &sValue, &$<position>4 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          QCP_STRUCT_ALLOC($<sequenceOptions>$->startValue, SLong);
          *$<sequenceOptions>$->startValue    = -sValue;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          $<sequenceOptions>$->cycleOption    = NULL;
          $<sequenceOptions>$->flag           = 0;
      }
    | TI_NONQUOTED_IDENTIFIER TR_BY TL_INTEGER
      /* INCREMENT BY INTEGER */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "INCREMENT", 9,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>3 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->incrementValue, SLong);
              $<sequenceOptions>$->startValue      = NULL;
              *$<sequenceOptions>$->incrementValue = sValue;
              $<sequenceOptions>$->minValue        = NULL;
              $<sequenceOptions>$->maxValue        = NULL;
              $<sequenceOptions>$->cacheValue      = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER TR_BY TS_MINUS_SIGN TL_INTEGER
      /* INCREMENT BY - INTEGER */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "INCREMENT", 9,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>4 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->incrementValue, SLong);
              $<sequenceOptions>$->startValue      = NULL;
              *$<sequenceOptions>$->incrementValue = -sValue;
              $<sequenceOptions>$->minValue        = NULL;
              $<sequenceOptions>$->maxValue        = NULL;
              $<sequenceOptions>$->cacheValue      = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER TR_WITH TL_INTEGER
      /* RESTART WITH BIGINT */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "RESTART", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>3 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->startValue, SLong);
              *$<sequenceOptions>$->startValue      = sValue;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue        = NULL;
              $<sequenceOptions>$->maxValue        = NULL;
              $<sequenceOptions>$->cacheValue      = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag          = 0;
              $<sequenceOptions>$->flag         &= ~QDS_SEQ_OPT_RESTART_MASK;
              $<sequenceOptions>$->flag         |= QDS_SEQ_OPT_RESTART_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER TR_WITH TS_MINUS_SIGN TL_INTEGER
      /* RESTART WITH - BIGINT */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "RESTART", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>4 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->startValue, SLong);
              *$<sequenceOptions>$->startValue      = -sValue;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue        = NULL;
              $<sequenceOptions>$->maxValue        = NULL;
              $<sequenceOptions>$->cacheValue      = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag          = 0;
              $<sequenceOptions>$->flag         &= ~QDS_SEQ_OPT_RESTART_MASK;
              $<sequenceOptions>$->flag         |= QDS_SEQ_OPT_RESTART_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER TL_INTEGER
      /* CACHE    INTEGER */
      /* MAXVALUE INTEGER */
      /* MINVALUE INTEGER */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "CACHE", 5,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              if (sValue <= 1)
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QDS_CACHE_VALUE));
                  YYABORT;
              }

              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->cacheValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              $<sequenceOptions>$->maxValue       = NULL;
              *$<sequenceOptions>$->cacheValue    = sValue;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else if (idlOS::strMatch(
                "MAXVALUE", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->maxValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              *$<sequenceOptions>$->maxValue      = sValue;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else if (idlOS::strMatch(
                "MINVALUE", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->minValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              *$<sequenceOptions>$->minValue      = sValue;
              $<sequenceOptions>$->maxValue       = NULL;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER TS_MINUS_SIGN TL_INTEGER
      /* MAXVALUE - INTEGER */
      /* MINVALUE - INTEGER */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "MAXVALUE", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>3 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->maxValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              *$<sequenceOptions>$->maxValue      = -sValue;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else if (idlOS::strMatch(
                "MINVALUE", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>3 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->minValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              *$<sequenceOptions>$->minValue      = -sValue;
              $<sequenceOptions>$->maxValue       = NULL;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TI_NONQUOTED_IDENTIFIER
      /* NOMCACHE   */
      /* NOMAXVALUE */
      /* NOMINVALUE */
      /* RESTART */
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "NOCACHE", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              QCP_STRUCT_ALLOC($<sequenceOptions>$->cacheValue, SLong);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              $<sequenceOptions>$->maxValue       = NULL;
              *$<sequenceOptions>$->cacheValue    = 0;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
          }
          else if (idlOS::strMatch(
                "NOMAXVALUE", 10,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              $<sequenceOptions>$->maxValue       = NULL;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
              $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_NOMAX_MASK;
              $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_NOMAX_TRUE;
          }
          else if (idlOS::strMatch(
                "NOMINVALUE", 10,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              $<sequenceOptions>$->maxValue       = NULL;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
              $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_NOMIN_MASK;
              $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_NOMIN_TRUE;
          }
          else if (idlOS::strMatch(
                "RESTART", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
              $<sequenceOptions>$->startValue     = NULL;
              $<sequenceOptions>$->incrementValue = NULL;
              $<sequenceOptions>$->minValue       = NULL;
              $<sequenceOptions>$->maxValue       = NULL;
              $<sequenceOptions>$->cacheValue     = NULL;
              $<sequenceOptions>$->cycleOption    = NULL;
              $<sequenceOptions>$->flag           = 0;
              $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_RESTART_MASK;
              $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_RESTART_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TR_CYCLE
      {
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          QCP_STRUCT_ALLOC($<sequenceOptions>$->cycleOption, UInt);
          $<sequenceOptions>$->startValue     = NULL;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          *$<sequenceOptions>$->cycleOption   = 0;
          *$<sequenceOptions>$->cycleOption  &= ~SMI_SEQUENCE_CIRCULAR_MASK;
          *$<sequenceOptions>$->cycleOption  |= SMI_SEQUENCE_CIRCULAR_ENABLE;
          $<sequenceOptions>$->flag           = 0;
      }
    | TR_NOCYCLE
      {
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          QCP_STRUCT_ALLOC($<sequenceOptions>$->cycleOption, UInt);
          $<sequenceOptions>$->startValue    = NULL;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          *$<sequenceOptions>$->cycleOption   = 0;
          *$<sequenceOptions>$->cycleOption  &= ~SMI_SEQUENCE_CIRCULAR_MASK;
          *$<sequenceOptions>$->cycleOption  |= SMI_SEQUENCE_CIRCULAR_DISABLE;
          $<sequenceOptions>$->flag           = 0;
      }
    | TA_SHARD opt_fixed
      {
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          $<sequenceOptions>$->startValue     = NULL;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          $<sequenceOptions>$->cycleOption    = NULL;
          $<sequenceOptions>$->flag           = 0;
          $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_LOCALITY_MASK;
          $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_LOCALITY_SHARD;

          if ( $<boolType>2 == ID_TRUE )
          {
              $<sequenceOptions>$->flag &= ~QDS_SEQ_OPT_SCALE_FIXED_MASK;
              $<sequenceOptions>$->flag |= QDS_SEQ_OPT_SCALE_FIXED_TRUE;
          }
          else
          {
              $<sequenceOptions>$->flag &= ~QDS_SEQ_OPT_SCALE_FIXED_MASK;
              $<sequenceOptions>$->flag |= QDS_SEQ_OPT_SCALE_FIXED_FALSE;
          }
      }
    | TR_LOCAL
      {
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          $<sequenceOptions>$->startValue     = NULL;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          $<sequenceOptions>$->cycleOption    = NULL;

          $<sequenceOptions>$->flag           = 0;
          $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_LOCALITY_MASK;
          $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_LOCALITY_LOCAL;

          $<sequenceOptions>$->flag          &= ~QDS_SEQ_OPT_SCALE_FIXED_MASK;
          $<sequenceOptions>$->flag          |= QDS_SEQ_OPT_SCALE_FIXED_FALSE;
      }
    ;

opt_fixed
    : /* empty */
      {
          $<boolType>$ = ID_TRUE;
      }
    | TA_FIXED
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_VARIABLE
      {
          $<boolType>$ = ID_FALSE;
      }
    ;

alter_table_statement
    : TR_ALTER TR_TABLE user_object_name TR_ADD opt_column_tok
        TS_OPENING_PARENTHESIS
        column_def_commalist_or_table_constraint_def
        TS_CLOSING_PARENTHESIS
        opt_lob_attribute_list
        opt_partition_lob_attr_list
        compression_option
      {
          qcuSqlSourceInfo    sqlInfo;
          qcmColumn         * sColumn;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints = $<tableElement>7.constraints;
          $<tableParseTree>$->columns     = $<tableElement>7.columns;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          if ( $<tableParseTree>$->columns != NULL )
          {
              // A column must have data type.
              for (sColumn = $<tableParseTree>$->columns;
                   sColumn != NULL;
                   sColumn = sColumn->next)
              {
                  if (sColumn->basicInfo->module == NULL)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NO_HAVE_DATATYPE_IN_CRT_TBL));
                      YYABORT;
                  }
              }

              // PROJ-1362
              $<tableParseTree>$->lobAttr = $<lobAttribute>9;

              // BUG-21761
              $<tableParseTree>$->ncharList = NCHARLIST;

              // PROJ-1502 PARTITIONED DISK TABLE
              $<tableParseTree>$->partTable->partAttr = $<partAttr>10;
          
              // PROJ-2264 Dictionary Table
              $<tableParseTree>$->compressionColumn = $<compressionColumn>11;

              $<tableParseTree>$->flag = 0;

              $<tableParseTree>$->common.parse    = qcc::parse;
              $<tableParseTree>$->common.validate = qdbAlter::validateAddCol;
              $<tableParseTree>$->common.optimize = qcc::optimize;
              $<tableParseTree>$->common.execute  = qdbAlter::executeAddCol;
          }
          else
          {
              // BUG-39060
              if ( ( $<boolType>5 == ID_TRUE )  ||
                   ( $<lobAttribute>9 != NULL ) ||
                   ( $<partAttr>10 != NULL )    ||
                   ( $<compressionColumn>11 != NULL) )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              
              /* PROJ-1107 Check Constraint  */
              QCP_STRUCT_ALLOC( $<tableParseTree>$->from, qmsFrom );
              QCP_SET_INIT_QMS_FROM( $<tableParseTree>$->from );

              QCP_STRUCT_ALLOC( $<tableParseTree>$->from->tableRef, qmsTableRef );
              QCP_SET_INIT_QMS_TABLE_REF( $<tableParseTree>$->from->tableRef );

              SET_POSITION( $<tableParseTree>$->from->tableRef->userName,
                            $<userNObjName>3->userName );
              SET_POSITION( $<tableParseTree>$->from->tableRef->tableName,
                            $<userNObjName>3->objectName );

              $<tableParseTree>$->common.parse    = qcc::parse;
              $<tableParseTree>$->common.validate = qdn::validateAddConstr;
              $<tableParseTree>$->common.optimize = qcc::optimize;
              $<tableParseTree>$->common.execute  = qdn::executeAddConstr;
          }
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok
        TS_OPENING_PARENTHESIS column_name
        TR_SET TR_DEFAULT arithmetic_expression TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>7.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints           = NULL;
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns, qcmColumn);
          QCM_COLUMN_INIT($<tableParseTree>$->columns);

          SET_POSITION($<tableParseTree>$->columns->namePos, $<position>7);
          $<tableParseTree>$->columns->defaultValue = $<expression>10[0];

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateSetDefault;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeSetDefault;
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok
        TS_OPENING_PARENTHESIS column_name
        TR_DROP TR_DEFAULT TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>7.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints           = NULL;
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns, qcmColumn);
          QCM_COLUMN_INIT($<tableParseTree>$->columns);

          SET_POSITION($<tableParseTree>$->columns->namePos, $<position>7);

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateDropDefault;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeDropDefault;
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok
        TS_OPENING_PARENTHESIS column_name
        TR_NOT TR_NULL TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>7.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          qdConstraintSpec  * sConstr;
          qcmColumn         * sColumn;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);


          QCP_STRUCT_ALLOC(sConstr, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( sConstr );

          sConstr->constrType                = QD_NOT_NULL;

          QCP_STRUCT_ALLOC(sColumn, qcmColumn);
          QCM_COLUMN_INIT( sColumn );

          SET_POSITION(sColumn->namePos, $<position>7);

          $<tableParseTree>$->flag = 0;

          $<tableParseTree>$->columns     = sColumn;
          $<tableParseTree>$->constraints = sConstr;
          $<tableParseTree>$->constraints->constraintColumns = sColumn;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateNotNull;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeNotNull;
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok
        TS_OPENING_PARENTHESIS column_name
        TR_NULL TS_CLOSING_PARENTHESIS
      {
          qcmColumn         * sColumn;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>7.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // column name
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);


          QCP_STRUCT_ALLOC(sColumn, qcmColumn);
          QCM_COLUMN_INIT( sColumn );

          SET_POSITION(sColumn->namePos, $<position>7);

          $<tableParseTree>$->flag = 0;

          $<tableParseTree>$->columns = sColumn;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateNullable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeNullable;
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok TR_LOB
        TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
        TR_STORE TR_AS
        TS_OPENING_PARENTHESIS lob_storage_attribute_list TS_CLOSING_PARENTHESIS
        opt_partition_lob_attr_list
      {
          qdLobStorageAttribute * sLast;
          qdPartitionAttribute  * sPartAttr;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);


          // create lob_attribute
          QCP_STRUCT_ALLOC($<tableParseTree>$->lobAttr, qdLobAttribute);
          $<tableParseTree>$->lobAttr->columns = $<columnDef>8;
          $<tableParseTree>$->lobAttr->storageAttr = $<lobStorageAttribute>13;
          $<tableParseTree>$->lobAttr->next = NULL;

          // tablespace   
          if ($<tableParseTree>$->lobAttr->storageAttr != NULL)
          {
              for (sLast = $<tableParseTree>$->lobAttr->storageAttr;
                   sLast != NULL;
                   sLast = sLast->next)
              {
                  if (sLast->type == QD_LOB_STORAGE_ATTR_TABLESPACE)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                      YYABORT;
                  }
                  else
                  {
                      // Nothing to do.
                  }
              }
          }
          else
          {
              // Nothing to do.
          }

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
          $<tableParseTree>$->partTable->partAttr = $<partAttr>15;

          for (sPartAttr = $<tableParseTree>$->partTable->partAttr;
               sPartAttr != NULL;
               sPartAttr = sPartAttr->next)
          {
              if( sPartAttr->lobAttr != NULL )
              {
                  for (sLast = sPartAttr->lobAttr->storageAttr;
                       sLast != NULL;
                       sLast = sLast->next)
                  {
                      if (sLast->type == QD_LOB_STORAGE_ATTR_TABLESPACE)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                          YYABORT;
                      }
                      else
                      {
                          // Nothing to do.
                      }
                  }
              }
          }

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAlterLobAttributes;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAlterLobAttributes;
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALTER opt_column_tok TR_LOB
        TR_STORE TR_AS
        TS_OPENING_PARENTHESIS lob_storage_attribute_list TS_CLOSING_PARENTHESIS
        opt_partition_lob_attr_list
      {
          qdLobStorageAttribute * sLast;
          qdPartitionAttribute  * sPartAttr;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          // create lob_attribute
          QCP_STRUCT_ALLOC($<tableParseTree>$->lobAttr, qdLobAttribute);
          $<tableParseTree>$->lobAttr->columns = NULL;
          $<tableParseTree>$->lobAttr->storageAttr = $<lobStorageAttribute>10;
          $<tableParseTree>$->lobAttr->next = NULL;

          // tablespace   
          if ($<tableParseTree>$->lobAttr->storageAttr != NULL)
          {
              for (sLast = $<tableParseTree>$->lobAttr->storageAttr;
                   sLast != NULL;
                   sLast = sLast->next)
              {
                  if (sLast->type == QD_LOB_STORAGE_ATTR_TABLESPACE)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                      YYABORT;
                  }
                  else
                  {
                      // Nothing to do.
                  }
              }
          }
          else
          {
              // Nothing to do.
          }

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
          $<tableParseTree>$->partTable->partAttr = $<partAttr>12;

          for (sPartAttr = $<tableParseTree>$->partTable->partAttr;
               sPartAttr != NULL;
               sPartAttr = sPartAttr->next)
          {
              if( sPartAttr->lobAttr != NULL )
              {
                  for (sLast = sPartAttr->lobAttr->storageAttr;
                       sLast != NULL;
                       sLast = sLast->next)
                  {
                      if (sLast->type == QD_LOB_STORAGE_ATTR_TABLESPACE)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                          YYABORT;
                      }
                      else
                      {
                          // Nothing to do.
                      }
                  }
              }
          }

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAlterLobAttributes;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAlterLobAttributes;
      }
    // PROJ-1877
    | TR_ALTER TR_TABLE user_object_name TR_MODIFY opt_column_tok modify_column_spec
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );
          
          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints   = $<tableElement>6.constraints;
          $<tableParseTree>$->columns       = $<tableElement>6.columns;
          $<tableParseTree>$->modifyColumns = $<tableElement>6.modifyColumns;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateModifyCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeModifyCol;
      }
    // PROJ-1877
    | TR_ALTER TR_TABLE user_object_name TR_MODIFY opt_column_tok
      TS_OPENING_PARENTHESIS modify_column_commalist TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );
          
          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints   = $<tableElement>7.constraints;
          $<tableParseTree>$->columns       = $<tableElement>7.columns;
          $<tableParseTree>$->modifyColumns = $<tableElement>7.modifyColumns;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateModifyCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeModifyCol;
      }
    | TR_ALTER TR_TABLE user_object_name TR_DROP opt_column_tok column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints           = NULL;
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableParseTree>$->columns );

          SET_POSITION($<tableParseTree>$->columns->namePos, $<position>6);

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateDropCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeDropCol;
      }
    | TR_ALTER TR_TABLE user_object_name TR_DROP opt_column_tok
      TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints = NULL;
          $<tableParseTree>$->columns     = $<columnDef>7;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateDropCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeDropCol;
      }
    | TR_ALTER TR_TABLE user_object_name TO_RENAME TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);
          /* set newTableName position */
          SET_POSITION($<tableParseTree>$->newTableName,
                       $<position>6);

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateRenameTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeRenameTable;
      }
    | TR_ALTER TR_TABLE user_object_name TA_MAXROWS TL_INTEGER
      {
          SLong               sMaxRows = 0;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          // MAXROWS
          if( qtc::getBigint( QTEXT, &sMaxRows, &$<position>5 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          $<tableParseTree>$->maxrows = sMaxRows;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAlterMaxRows;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAlterMaxRows;
      }
      | TR_ALTER TR_TABLE user_object_name TI_NONQUOTED_IDENTIFIER opt_partition opt_maxpages
      // ALTER TABLE IDENTIFIER COMPACT
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "COMPACT", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
              QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
              QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

              /* set userName position */
              SET_POSITION($<tableParseTree>$->userName,
                           $<userNObjName>3->userName);
              /* set tableName position */
              SET_POSITION($<tableParseTree>$->tableName,
                           $<userNObjName>3->objectName);

              QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
              QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );
              $<tableParseTree>$->partTable->partAttr = $<partAttr>5;

              if ($<uLongPtr>6 != NULL)
              {
                  $<tableParseTree>$->maxrows = *($<uLongPtr>6);
              }
              
              // BUG-21761
              $<tableParseTree>$->ncharList = NCHARLIST;

              $<tableParseTree>$->common.parse    = qcc::parse;
              $<tableParseTree>$->common.validate = qdbAlter::validateCompactTable;
              $<tableParseTree>$->common.optimize = qcc::optimize;
              $<tableParseTree>$->common.execute  = qdbAlter::executeCompactTable;
          }
          else if (idlOS::strMatch(
                       "AGING", 5,
                       QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
              QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
              QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

              /* set userName position */
              SET_POSITION($<tableParseTree>$->userName,
                           $<userNObjName>3->userName);
              /* set tableName position */
              SET_POSITION($<tableParseTree>$->tableName,
                           $<userNObjName>3->objectName);

              QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
              QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
              $<tableParseTree>$->partTable->partAttr = $<partAttr>5;

              if ($<uLongPtr>6 != NULL)
              {
                  YYABORT;
              }
              
              $<tableParseTree>$->common.parse    = qcc::parse;
              $<tableParseTree>$->common.validate = qdbAlter::validateAgingTable;
              $<tableParseTree>$->common.optimize = qcc::optimize;
              $<tableParseTree>$->common.execute  = qdbAlter::executeAgingTable;
          }
          else if (idlOS::strMatch(
                       "TOUCH", 5,
                       QTEXT+$<position>4.offset, $<position>4.size) == 0)
          {
              QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
              QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
              QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

              /* set userName position */
              SET_POSITION($<tableParseTree>$->userName,
                           $<userNObjName>3->userName);
              /* set tableName position */
              SET_POSITION($<tableParseTree>$->tableName,
                           $<userNObjName>3->objectName);

              if ($<uLongPtr>6 != NULL)
              {
                  YYABORT;
              }
              
              $<tableParseTree>$->common.parse    = qcc::parse;
              $<tableParseTree>$->common.validate = qdbAlter::validateTouchTable;
              $<tableParseTree>$->common.optimize = qcc::optimize;
              $<tableParseTree>$->common.execute  = qdbAlter::executeTouchTable;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini(); 
              YYABORT;
          }
      }
    | TR_ALTER TR_TABLE user_object_name TR_ALL TO_INDEX enable_or_disable
      /* ALTER TABLE ALL INDEX ENABLE/DISABLE */
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAllIndexEnable;
          $<tableParseTree>$->common.optimize = qcc::optimize;

          if ( $<boolType>6 == ID_TRUE )
          {
              $<tableParseTree>$->common.execute = qdbAlter::executeAllIndexEnable;
          }
          else
          {
              $<tableParseTree>$->common.execute = qdbAlter::executeAllIndexDisable;
          }
      }
    | TR_ALTER TR_TABLE user_object_name
        TO_RENAME TR_COLUMN column_name TR_TO column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // new column name
          if ($<position>8.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>8 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          // old column
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableParseTree>$->columns );

          SET_POSITION($<tableParseTree>$->columns->namePos,$<position>6);

          // new column name
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns->next, qcmColumn);
          QCM_COLUMN_INIT( $<tableParseTree>$->columns->next );

          SET_POSITION($<tableParseTree>$->columns->next->namePos,$<position>8);

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateRenameCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeRenameCol;
      }
    /* PROJ-2359 Table/Partition Access Option */
    | TR_ALTER TR_TABLE user_object_name TO_ACCESS record_access
      {
          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION( $<tableParseTree>$->userName,
                        $<userNObjName>3->userName );
          /* set tableName position */
          SET_POSITION( $<tableParseTree>$->tableName,
                        $<userNObjName>3->objectName );

          $<tableParseTree>$->accessOption = $<accessOption>5;

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAccessTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAccessTable;
      }
    /* TASK-7307 DML Consistency in Shard */
    | TR_ALTER TR_TABLE user_object_name TO_ACCESS usable_option
      {
          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION( $<tableParseTree>$->userName,
                        $<userNObjName>3->userName );
          /* set tableName position */
          SET_POSITION( $<tableParseTree>$->tableName,
                        $<userNObjName>3->objectName );

          $<tableParseTree>$->mIsUsable = $<boolType>5;

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateUsableTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeUsableTable;
      }
    | TR_ALTER TR_TABLE user_object_name shard_flag_table_alter_option
      {
          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION( $<tableParseTree>$->userName,
                        $<userNObjName>3->userName );
          /* set tableName position */
          SET_POSITION( $<tableParseTree>$->tableName,
                        $<userNObjName>3->objectName );

          $<tableParseTree>$->mShardFlag = $<shardFlag>4;

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateShardFlag;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeShardFlag;
      }
    | TR_ALTER TR_TABLE user_object_name alter_table_partitioning
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          // qdPartitionedTable ʱȭ
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );
          $<tableParseTree>$->partTable->partAttr = $<partAttr>4;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          switch( $<tableParseTree>$->partTable->partAttr->alterPart->alterType )
          {
              case QD_ADD_HASH_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateAddPartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeAddPartition;
                  break;
              case QD_ADD_RANGE_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateAddRangePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeAddRangePartition;
                  break;
              case QD_COALESCE_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateCoalescePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeCoalescePartition;
                  break;
              case QD_DROP_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateDropPartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeDropPartition;
                  break;
              case QD_MERGE_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateMergePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeMergePartition;
                  break;
              case QD_RENAME_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateRenamePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeRenamePartition;
                  break;
              case QD_SPLIT_RANGE_PARTITION:
              case QD_SPLIT_LIST_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateSplitPartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeSplitPartition;
                  break;
              case QD_TRUNCATE_PARTITION:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateTruncatePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeTruncatePartition;
                  break;
              case QD_ENABLE_ROW_MOVEMENT:
              case QD_DISABLE_ROW_MOVEMENT:
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateRowmovement;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeRowmovement;
                  break;
              case QD_ACCESS_PARTITION :    /* PROJ-2359 Table/Partition Access Option */
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateAccessPartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeAccessPartition;
                  break;
              case QD_ALTER_PARTITION: /* PROJ-2464 hybrid partitioned table  */
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateAlterPartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeAlterPartition; 
                  break;
              case QD_USABLE_PARTITION : /* TASK-7307 DML Consistency in Shard */
                  // set function pointer
                  $<tableParseTree>$->common.parse    = qcc::parse;
                  $<tableParseTree>$->common.validate =
                                            qdbAlter::validateUsablePartition;
                  $<tableParseTree>$->common.optimize = qcc::optimize;
                  $<tableParseTree>$->common.execute  =
                                            qdbAlter::executeUsablePartition;
                  break;
              case QD_NONE_ALTER_PARTITION:
                  IDE_DASSERT(0);
                  break;
              default:
                  IDE_DASSERT(0);
                  break;
          }
      }
    /* PROJ-2465 Tablespace Alteration for Table */
    | TR_ALTER TR_TABLE user_object_name TR_ALTER TA_TABLESPACE
      TI_IDENTIFIER         // 6
      opt_index_storage     // 7
      opt_lob_storage       // 8
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName, tableName position */
          SET_POSITION( $<tableParseTree>$->userName,  $<userNObjName>3->userName );
          SET_POSITION( $<tableParseTree>$->tableName, $<userNObjName>3->objectName );

          /* Tablespace Name */
          if ( $<position>6.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>6 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          SET_POSITION( $<tableParseTree>$->TBSName, $<position>6 );

          /* Index Option */
          $<tableParseTree>$->indexTBSAttr = $<indexPartAttr>7;

          /* Lob Storage Option */
          $<tableParseTree>$->lobAttr = $<lobAttribute>8;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateAlterTablespace;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAlterTablespace;
      }
    /* PROJ-2600 Online DDL for Tablespace Alteration */
    | TR_ALTER TR_TABLE user_object_name TO_REPLACE user_object_name
      opt_partition                 // 6
      opt_using_prefix              // 7
      opt_rename_force              // 8
      opt_ignore_foreign_key_child  // 9
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName, tableName position : Target */
          SET_POSITION( $<tableParseTree>$->userName,  $<userNObjName>3->userName );
          SET_POSITION( $<tableParseTree>$->tableName, $<userNObjName>3->objectName );

          /* set userName, tableName position : Source */
          SET_POSITION( $<tableParseTree>$->mSourceUserName,  $<userNObjName>5->userName );
          SET_POSITION( $<tableParseTree>$->mSourceTableName, $<userNObjName>5->objectName );

          $<tableParseTree>$->mPartAttr = $<partAttr>6;
          
          SET_POSITION( $<tableParseTree>$->mNamesPrefix, $<position>7 );

          $<tableParseTree>$->mIsRenameForce = $<boolType>8;

          $<tableParseTree>$->mIgnoreForeignKeyChild = $<boolType>9;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbCopySwap::validateReplaceTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;

          if ( $<tableParseTree>$->mPartAttr == NULL )
          {
              $<tableParseTree>$->common.execute = qdbCopySwap::executeReplaceTable;
          }
          else
          {
              $<tableParseTree>$->common.execute = qdbCopySwap::executeReplacePartition;
          }
      }
   | TR_ALTER TR_TABLE user_object_name table_attr_clause
     // ALTER TABLE TBSNAME COMPRESSED LOGGING
     // ALTER TABLE TBSNAME UNCOMPRESSED LOGGING
     {
         QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
         QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
         QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

         /* set userName position */
         SET_POSITION($<tableParseTree>$->userName,
                      $<userNObjName>3->userName);
         /* set tableName position */
         SET_POSITION($<tableParseTree>$->tableName,
                      $<userNObjName>3->objectName);

         // BUG-21761
         $<tableParseTree>$->ncharList = NCHARLIST;

         // PROJ-1502 PARTITIONED DISK TABLE
         QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
         QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

         $<tableParseTree>$->tableAttrFlagList = $<tableAttrFlagList>4;
         $<tableParseTree>$->common.parse    = qcc::parse;
         $<tableParseTree>$->common.validate = qdbAlter::validateAttrFlag;
         $<tableParseTree>$->common.optimize = qcc::optimize;
         $<tableParseTree>$->common.execute  = qdbAlter::executeAttrFlag;
     }
   | TR_ALTER TR_TABLE user_object_name alter_table_properties
     {
          // alter table table_name table_properties
          // table properties( logging, parallel )
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          // user name
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);

          // table name
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          SET_EMPTY_POSITION($<tableParseTree>$->newTableName);

          // Logging Mode
          $<tableParseTree>$->loggingMode = $<tableOptions>4->loggingMode;

          // Prallel Degree
          $<tableParseTree>$->parallelDegree = $<tableOptions>4->parallelDegree;

          $<tableParseTree>$->flag = 0;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate
              = qdbAlter::validateAlterTableOptions;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute
              = qdbAlter::executeAlterTableOptions;
      }
    // PROJ-1723 [MDW/INTEGRATOR] Altibase Plugin 
    // TASK-5030
    // ALTER TABLE table_name ADD SUPPLEMENTAL LOG DATA ( ALL ) COLUMNS
    | TR_ALTER TR_TABLE user_object_name
      TR_ADD TR_SUPPLEMENTAL TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_OPENING_PARENTHESIS TR_ALL TS_CLOSING_PARENTHESIS TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "LOG", 3,
                  QTEXT+$<position>6.offset, $<position>6.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                  "DATA", 4,
                  QTEXT+$<position>7.offset, $<position>7.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                  "COLUMNS", 7,
                  QTEXT+$<position>11.offset, $<position>11.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>11 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->isSuppLogging = ID_TRUE;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate =
              qdbAlter::validateAlterTableSuppLogging;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  =
              qdbAlter::executeAlterTableSuppLogging;
      }
    // PROJ-1723 [MDW/INTEGRATOR] Altibase Plugin 
    // TASK-5030
    // ALTER TABLE table_name DROP SUPPLEMENTAL LOG DATA ( ALL ) COLUMNS
    | TR_ALTER TR_TABLE user_object_name
      TR_DROP TR_SUPPLEMENTAL TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      TS_OPENING_PARENTHESIS TR_ALL TS_CLOSING_PARENTHESIS TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "LOG", 3,
                  QTEXT+$<position>6.offset, $<position>6.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                  "DATA", 4,
                  QTEXT+$<position>7.offset, $<position>7.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch(
                  "COLUMNS", 7,
                  QTEXT+$<position>11.offset, $<position>11.size) != 0)
          {   // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>11 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->isSuppLogging = ID_FALSE;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate =
              qdbAlter::validateAlterTableSuppLogging;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  =
              qdbAlter::executeAlterTableSuppLogging;
      }
    | TR_ALTER TR_TABLE user_object_name physical_attribute_option ttl_option
      {
          // alter table table_name PCTFREE/PCTUSED;
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);

          if( ($<tablePhysicalAttr>4->pctFree == NULL) &&
              ($<tablePhysicalAttr>4->pctUsed == NULL) &&
              ($<ttl>5->initTrans == NULL) &&
              ($<ttl>5->maxTrans == NULL) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          // PCTFREE
          if ($<tablePhysicalAttr>4->pctFree == NULL)
          {
              $<tableParseTree>$->segAttr.mPctFree=
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctFree =
                  *($<tablePhysicalAttr>4->pctFree);
          }

          // PCTUSED
          if ($<tablePhysicalAttr>4->pctUsed == NULL)
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  *($<tablePhysicalAttr>4->pctUsed);
          }

          // Init/Max Trans
          if ($<ttl>5->initTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mInitTrans=
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  *($<ttl>5->initTrans);
          }

          if ($<ttl>5->maxTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mMaxTrans=
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  *($<ttl>5->maxTrans);
          }

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate
              = qdbAlter::validateAlterTableSegAttr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute
              = qdbAlter::executeAlterTableSegAttr;
      }
    | TR_ALTER TR_TABLE user_object_name
        TI_NONQUOTED_IDENTIFIER TO_EXTENT
        TS_OPENING_PARENTHESIS
        TI_NONQUOTED_IDENTIFIER size_option
        TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          // alter table table_name storage( .. );
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          if (idlOS::strMatch("ALLOCATE", 8,
                              QTEXT+$<position>4.offset, $<position>4.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch("SIZE", 4,
                              QTEXT+$<position>7.offset, $<position>7.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
          
          $<tableParseTree>$->altAllocExtSize = $<uLongVal>8;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate
              = qdbAlter::validateAlterTableAllocExtent;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute
              = qdbAlter::executeAlterTableAllocExtent;
      }
    | TR_ALTER TR_TABLE user_object_name
        TI_NONQUOTED_IDENTIFIER TO_EXTENT
      {
          qcuSqlSourceInfo    sqlInfo;

          // alter table table_name storage( .. );
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          if (idlOS::strMatch("ALLOCATE", 8,
                              QTEXT+$<position>4.offset, $<position>4.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
          
          $<tableParseTree>$->altAllocExtSize = 1; // align Ǿ 1 Extent Ҵȴ.

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate
              = qdbAlter::validateAlterTableAllocExtent;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute
              = qdbAlter::executeAlterTableAllocExtent;
      }
    | TR_ALTER TR_TABLE user_object_name storage_clause
      {
          // alter table table_name storage( .. );
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          if ( ($<attrNode>4->initExtCnt == NULL) &&
               ($<attrNode>4->nextExtCnt == NULL) &&
               ($<attrNode>4->minExtCnt  == NULL) &&
               ($<attrNode>4->maxExtCnt  == NULL) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          // InitExtents
          if ($<attrNode>4->initExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt=
                  *($<attrNode>4->initExtCnt);
              $<tableParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          // NextExtents
          if ($<attrNode>4->nextExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt=
                  *($<attrNode>4->nextExtCnt);
              $<tableParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          // minExtents
          if ($<attrNode>4->minExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt=
                  *($<attrNode>4->minExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          // maxExtents
          if ($<attrNode>4->maxExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt=
                  *($<attrNode>4->maxExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$->partTable, qdPartitionedTable);
          QD_SET_INIT_PART_TABLE($<tableParseTree>$->partTable);
          
          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate
              = qdbAlter::validateAlterTableSegStoAttr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute
              = qdbAlter::executeAlterTableSegStoAttr;
      }
    // PROJ-2264 Dictionary table
    // ALTER TABLE T1 REORGANIZE COLUMN I2;
    | TR_ALTER TR_TABLE user_object_name TA_REORGANIZE opt_column_tok column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints           = NULL;
          QCP_STRUCT_ALLOC($<tableParseTree>$->columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableParseTree>$->columns );

          SET_POSITION($<tableParseTree>$->columns->namePos, $<position>6);

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateReorganizeCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeReorganizeCol;
      }
    // PROJ-2264 Dictionary table
    // ALTER TABLE T1 REORGANIZE COLUMN ( I2, I3 );
    | TR_ALTER TR_TABLE user_object_name TA_REORGANIZE opt_column_tok
      TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints = NULL;
          $<tableParseTree>$->columns     = $<columnDef>7;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbAlter::validateReorganizeCol;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeReorganizeCol;
      }
    ;

/* PROJ-2600 Online DDL for Tablespace Alteration */
opt_using_prefix
    : // empty
      {
          SET_EMPTY_POSITION( $<position>$ );
      }
    | using_prefix
    ;

/* PROJ-2600 Online DDL for Tablespace Alteration */
using_prefix
    : TR_USING TI_NONQUOTED_IDENTIFIER TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "PREFIX",
                                6,
                                QTEXT + $<position>2.offset,
                                $<position>2.size ) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>2) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          if ( $<position>3.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>3) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          SET_POSITION( $<position>$, $<position>3 );
      }
    ;

/* PROJ-2600 Online DDL for Tablespace Alteration */
opt_rename_force
    : // empty
      {
          $<boolType>$ = ID_FALSE;
      }
    | TO_RENAME TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "FORCE",
                                5,
                                QTEXT + $<position>2.offset,
                                $<position>2.size ) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>2) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          $<boolType>$ = ID_TRUE;
      }
    ;

/* PROJ-2600 Online DDL for Tablespace Alteration */
opt_ignore_foreign_key_child
    : // empty
      {
          $<boolType>$ = ID_FALSE;
      }
    | TI_NONQUOTED_IDENTIFIER TR_FOREIGN TR_KEY TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "IGNORE",
                                6,
                                QTEXT + $<position>1.offset,
                                $<position>1.size ) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>1) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          if ( idlOS::strMatch( "CHILD",
                                5,
                                QTEXT + $<position>4.offset,
                                $<position>4.size ) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>4) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          $<boolType>$ = ID_TRUE;
      }
    ;

alter_table_properties
    : parallel_clause
      {
          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);

          $<tableOptions>$->maxrows = NULL;
          $<tableOptions>$->TBSName = NULL;
          $<tableOptions>$->pctFree = NULL;
          $<tableOptions>$->pctUsed  = NULL;
          $<tableOptions>$->partTable = NULL;
          $<tableOptions>$->isRowmovement = ID_FALSE;
          $<tableOptions>$->loggingMode = NULL;
          $<tableOptions>$->parallelDegree = $<uIntVal>1;
      }
    | logging_clause
      {
          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);
          QCP_STRUCT_ALLOC($<tableOptions>$->loggingMode, UInt);

          $<tableOptions>$->maxrows = NULL;
          $<tableOptions>$->TBSName = NULL;
          $<tableOptions>$->pctFree = NULL;
          $<tableOptions>$->pctUsed  = NULL;
          $<tableOptions>$->partTable = NULL;
          $<tableOptions>$->isRowmovement = ID_FALSE;
          *($<tableOptions>$->loggingMode) = $<uIntVal>1;
          $<tableOptions>$->parallelDegree = 0;
      }
    | logging_clause parallel_clause
      {
          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);
          QCP_STRUCT_ALLOC($<tableOptions>$->loggingMode, UInt);

          $<tableOptions>$->maxrows = NULL;
          $<tableOptions>$->TBSName = NULL;
          $<tableOptions>$->pctFree = NULL;
          $<tableOptions>$->pctUsed  = NULL;
          $<tableOptions>$->partTable = NULL;
          $<tableOptions>$->isRowmovement = ID_FALSE;
          *($<tableOptions>$->loggingMode) = $<uIntVal>1;
          $<tableOptions>$->parallelDegree = $<uIntVal>2;
      }
    | parallel_clause logging_clause
      {
          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);
          QCP_STRUCT_ALLOC($<tableOptions>$->loggingMode, UInt);

          $<tableOptions>$->maxrows = NULL;
          $<tableOptions>$->TBSName = NULL;
          $<tableOptions>$->pctFree = NULL;
          $<tableOptions>$->pctUsed  = NULL;
          $<tableOptions>$->partTable = NULL;
          $<tableOptions>$->isRowmovement = ID_FALSE;
          *($<tableOptions>$->loggingMode) = $<uIntVal>2;
          $<tableOptions>$->parallelDegree = $<uIntVal>1;
      }
    ;

logging_clause
    : TR_LOGGING
      {
          $<uIntVal>$ = SMI_TABLE_LOGGING;
      }

    | TR_NOLOGGING
      {
          $<uIntVal>$ = SMI_TABLE_NOLOGGING;
      }
    ;

parallel_clause
    : TR_PARALLEL TL_INTEGER
      {
          SLong sNumber;

          if( qtc::getBigint( QTEXT, &sNumber, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          if ((sNumber > 0) && (sNumber < 65536))
          {
              $<uIntVal>$ = sNumber;
          }
          else
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_PARALLEL_DEGREE));
              YYABORT;
          }
      }
    | TR_NOPARALLEL
      {
          $<uIntVal>$ = 1;
      }
    ;

modify_column_commalist
    : modify_column_commalist TS_COMMA modify_column_spec
      {
          qdConstraintSpec  * sLastConstr;
          qdConstraintSpec  * sCurrConstr;
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcmColumn         * sLastModifyColumn;
          qcmColumn         * sCurrModifyColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrConstr = $<tableElement>3.constraints;
          sCurrColumn = $<tableElement>3.columns;
          sCurrModifyColumn = $<tableElement>3.modifyColumns;

          // constraints
          if ($<tableElement>1.constraints == NULL)
          {
              $<tableElement>$.constraints = $<tableElement>3.constraints;
          }
          else
          {
              $<tableElement>$.constraints = $<tableElement>1.constraints;

              if (sCurrConstr != NULL)
              {
                  // check duplicate constraint name
                  for (sLastConstr = $<tableElement>$.constraints;
                       sLastConstr != NULL;
                       sLastConstr = sLastConstr->next)
                  {
                      if (QC_IS_NULL_NAME(sLastConstr->constrName) != ID_TRUE &&
                          QC_IS_NULL_NAME(sCurrConstr->constrName) != ID_TRUE)
                      {
                          if (idlOS::strMatch(
                                  QTEXT+sCurrConstr->constrName.offset, sCurrConstr->constrName.size,
                                  QTEXT+sLastConstr->constrName.offset, sLastConstr->constrName.size) == 0)
                          {
                              sqlInfo.setSourceInfo(STATEMENT, & (sLastConstr->constrName));
                              sqlInfo.init(MEMORY);
                              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_CONSTRAINT_NAME,
                                                      sqlInfo.getErrMessage()));
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                  }

                  // connect
                  sLastConstr = $<tableElement>$.constraints;
                  while (sLastConstr->next != NULL)
                  {
                      sLastConstr = sLastConstr->next;
                  }
                  sLastConstr->next = sCurrConstr;
              }
          }

          // columns
          if ($<tableElement>1.columns == NULL)
          {
              $<tableElement>$.columns = $<tableElement>3.columns;
              $<tableElement>$.modifyColumns = $<tableElement>3.modifyColumns;
          }
          else
          {
              $<tableElement>$.columns = $<tableElement>1.columns;
              $<tableElement>$.modifyColumns = $<tableElement>1.modifyColumns;

              // check duplicate column name
              for (sLastColumn = $<tableElement>$.columns;
                   sLastColumn != NULL;
                   sLastColumn = sLastColumn->next)
              {
                  if (idlOS::strMatch(
                          QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                          QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
                  {
                      sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                      sqlInfo.init(MEMORY);
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                              sqlInfo.getErrMessage()));
                      sqlInfo.fini();
                      YYABORT;
                  }
              }

              // connect
              sLastColumn = $<tableElement>$.columns;
              sLastModifyColumn = $<tableElement>$.modifyColumns;
              while (sLastColumn->next != NULL)
              {
                  sLastColumn = sLastColumn->next;
                  sLastModifyColumn = sLastModifyColumn->next;
              }
              sLastColumn->next = sCurrColumn;
              sLastModifyColumn->next = sCurrModifyColumn;
          }
      }
    | modify_column_spec
      {
          $<tableElement>$ = $<tableElement>1;
      }
    ;

modify_column_spec
    : column_name
      rule_data_type opt_variable_flag opt_in_row opt_tolerate_data_loss
      opt_default_clause opt_modify_column_constraint_spec
      {
          qdConstraintSpec  * sConstr;
          qcmColumn         * sColumn;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<tableElement>$.constraints = NULL;

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos = $<position>1;

          QCP_STRUCT_ALLOC($<tableElement>$.modifyColumns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.modifyColumns );

          $<tableElement>$.modifyColumns->namePos = $<position>1;

          // data type
          $<tableElement>$.modifyColumns->basicInfo   = $<column>2;
          $<tableElement>$.modifyColumns->flag        = $<flag>3;
          $<tableElement>$.modifyColumns->inRowLength = $<uIntVal>4;

          // default value
          $<tableElement>$.modifyColumns->flag &=
              ~QCM_COLUMN_MODIFY_DEFAULT_MASK; // initialize

          if ( $<expression>6[0] != NULL )
          {
              $<tableElement>$.modifyColumns->defaultValue = $<expression>6[0];

              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DEFAULT_TRUE;
          }
          else
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DEFAULT_FALSE;
          }

          // data loss
          $<tableElement>$.modifyColumns->flag &=
              ~QCM_COLUMN_MODIFY_DATA_LOSS_MASK; // initialize

          if ( $<boolType>5 == ID_TRUE )
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DATA_LOSS_TRUE;
          }
          else
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DATA_LOSS_FALSE;
          }

          // (not) null constraint
          $<tableElement>$.modifyColumns->flag &=
              ~QCM_COLUMN_MODIFY_NULLABLE_MASK; // initialize

          if ( $<uIntVal>7 == 0 )
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_NULLABLE_NONE;
          }
          else
          {
              if ( $<uIntVal>7 == 1 )
              {
                  $<tableElement>$.modifyColumns->flag |=
                      QCM_COLUMN_MODIFY_NULLABLE_NULL;
              }
              else if ( $<uIntVal>7 == 2 )
              {
                  $<tableElement>$.modifyColumns->flag |=
                      QCM_COLUMN_MODIFY_NULLABLE_NOTNULL;

                  // not null constraint validation ؾ
                  QCP_STRUCT_ALLOC( sConstr, qdConstraintSpec );
                  QD_SET_INIT_CONSTRAINT_SPEC( sConstr );

                  QCP_STRUCT_ALLOC( sColumn, qcmColumn );
                  QCM_COLUMN_INIT( sColumn );

                  SET_POSITION(sColumn->namePos, $<position>1);

                  sConstr->constrType = QD_NOT_NULL;
                  sConstr->constraintColumns = sColumn;

                  $<tableElement>$.constraints = sConstr;
              }
              else
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                  YYABORT;
              }
          }
      }
    | column_name opt_default_clause opt_modify_column_constraint_spec
      {
          qdConstraintSpec  * sConstr;
          qcmColumn         * sColumn;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // column name ִ  
          if (($<expression>2[0] == NULL) && ($<uIntVal>3 == 0))
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<tableElement>$.constraints = NULL;

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos = $<position>1;

          QCP_STRUCT_ALLOC($<tableElement>$.modifyColumns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.modifyColumns );

          $<tableElement>$.modifyColumns->namePos = $<position>1;

          // default value
          $<tableElement>$.modifyColumns->flag &=
              ~QCM_COLUMN_MODIFY_DEFAULT_MASK; // initialize

          if ( $<expression>2[0] != NULL )
          {
              $<tableElement>$.modifyColumns->defaultValue = $<expression>2[0];

              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DEFAULT_TRUE;
          }
          else
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_DEFAULT_FALSE;
          }

          // (not) null constraint
          $<tableElement>$.modifyColumns->flag &=
              ~QCM_COLUMN_MODIFY_NULLABLE_MASK; // initialize

          if ( $<uIntVal>3 == 0 )
          {
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_NULLABLE_NONE;
          }
          else
          {
              if ( $<uIntVal>3 == 1 )
              {
                  $<tableElement>$.modifyColumns->flag |=
                      QCM_COLUMN_MODIFY_NULLABLE_NULL;
              }
              else if ( $<uIntVal>3 == 2 )
              {
                  $<tableElement>$.modifyColumns->flag |=
                      QCM_COLUMN_MODIFY_NULLABLE_NOTNULL;

                  // not null constraint validation ؾ
                  QCP_STRUCT_ALLOC( sConstr, qdConstraintSpec );
                  QD_SET_INIT_CONSTRAINT_SPEC( sConstr );

                  QCP_STRUCT_ALLOC( sColumn, qcmColumn );
                  QCM_COLUMN_INIT( sColumn );

                  SET_POSITION(sColumn->namePos, $<position>1);

                  sConstr->constrType = QD_NOT_NULL;
                  sConstr->constraintColumns = sColumn;

                  $<tableElement>$.constraints = sConstr;
              }
              else
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                  YYABORT;
              }
          }
      }
    | column_name extended_column_attribute
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<tableElement>$.constraints = NULL;

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos = $<position>1;

          QCP_STRUCT_ALLOC($<tableElement>$.modifyColumns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.modifyColumns );

          $<tableElement>$.modifyColumns->namePos        = $<position>1;
          $<tableElement>$.modifyColumns->mExtColumnAttr = $<extColumnAttr>2;

          if ( QC_IS_NULL_NAME( $<extColumnAttr>2->mPolicyPosition ) != ID_TRUE )
          {
              $<tableElement>$.modifyColumns->flag &=
                  ~QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK;
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE;
          }
          else
          {
              $<tableElement>$.modifyColumns->flag &=
                  ~QCM_COLUMN_MODIFY_SRID_MASK;
              $<tableElement>$.modifyColumns->flag |=
                  QCM_COLUMN_MODIFY_SRID_TRUE;
          }
      }
    | column_name TA_DECRYPT
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<tableElement>$.constraints = NULL;

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos = $<position>1;

          QCP_STRUCT_ALLOC($<tableElement>$.modifyColumns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.modifyColumns );

          $<tableElement>$.modifyColumns->namePos = $<position>1;

          $<tableElement>$.modifyColumns->flag |=
              QCM_COLUMN_MODIFY_DECRYPT_COLUMN_TRUE;
      }
    ;

opt_tolerate_data_loss
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "TOLERATE", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0 &&
              idlOS::strMatch(
                "DATA", 4,
                QTEXT+$<position>2.offset, $<position>2.size) == 0 &&
              idlOS::strMatch(
                "LOSS", 4,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        "TOLERATE DATA LOSS" ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

opt_modify_column_constraint_spec
    : /* empty */
      {
          $<uIntVal>$ = 0;
      }
    | TR_NULL
      {
          $<uIntVal>$ = 1;
      }
    | TR_NOT TR_NULL
      {
          $<uIntVal>$ = 2;
      }
    ;

opt_partition
    : /* empty */
      {
          $<partAttr>$ = NULL;
      }
    | TR_PARTITION TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
      }
    ;

opt_maxpages
    : /* empty */
      {
          $<uLongPtr>$ = NULL;
      }
    | TI_NONQUOTED_IDENTIFIER TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sMaxPages = 0;

          if (idlOS::strMatch(
                "MAXPAGES", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              if( qtc::getBigint( QTEXT, &sMaxPages, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);

              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<uLongPtr>$, ULong );
          *($<uLongPtr>$) = sMaxPages;
      }
    ;

/* BUG-47599 ADD range PARTITION  ߰ */
add_partition_spec
      /* hash partition*/
    : partition_spec
      {
          // get partition_spec
          $<partAttr>$ = $<partAttr>1;
          $<partAttr>$->partValuesType = QD_HASH_VALUES_TYPE;
      }
      /* range partition*/
    | TR_PARTITION
      TI_IDENTIFIER             // 2
      TR_VALUES TR_LESS TR_THAN
      TS_OPENING_PARENTHESIS
         part_key_cond_list     // 7
      TS_CLOSING_PARENTHESIS
      opt_table_part_desc       // 9
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>9;
          $<partAttr>$->partKeyCond = $<valueNode>7;
          $<partAttr>$->partValuesType = QD_RANGE_VALUES_TYPE;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
      } 
      /* todo : default partition */ 
/*    | TR_PARTITION
      TI_IDENTIFIER            // 2
      TR_VALUES TR_DEFAULT
      opt_table_part_desc      // 5
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>5;
          $<partAttr>$->partKeyCond = NULL;
          $<partAttr>$->partValuesType = QD_DEFAULT_VALUES_TYPE;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );

      }*/
    ;

alter_table_partitioning
    : TR_ADD add_partition_spec
      opt_index_part_attr_list
      {
          // get partition_spec
          $<partAttr>$ = $<partAttr>2;

          // alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );

          switch ( $<partAttr>$->partValuesType )
          {
              //case QD_DEFAULT_VALUES_TYPE:
              case QD_RANGE_VALUES_TYPE:
                  $<partAttr>$->alterPart->alterType = QD_ADD_RANGE_PARTITION;
                  break;
              case QD_HASH_VALUES_TYPE:
                  $<partAttr>$->alterPart->alterType = QD_ADD_HASH_PARTITION;
                  break;
              default:
                  IDE_DASSERT(0);
                  break;
          }

          $<partAttr>$->alterPart->indexPartAttr = $<indexPartAttr>3;
      }
    | TR_COALESCE TR_PARTITION
      {
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          // alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_COALESCE_PARTITION;
      }
    | TR_DROP TR_PARTITION TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // tablePartName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // alter partition 
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_DROP_PARTITION;
      }
    | TR_MERGE        // 1
      TR_PARTITIONS   // 2
      TI_IDENTIFIER   // 3
      TS_COMMA        // 4
      TI_IDENTIFIER   // 5
      TR_INTO         // 6
      partition_spec  // 7
      opt_index_part_attr_list // 8
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // object name
          if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // ----------
          // SrcPart1
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // SrcPart1 tableName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // SrcPart1  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_MERGE_PARTITION;

          // ----------
          // SrcPart2
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next );
          // SrcPart2 tableName
          SET_POSITION( $<partAttr>$->next->tablePartName, $<position>5 );

          // SrcPart2  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->alterPart );
          $<partAttr>$->next->alterPart->alterType = QD_MERGE_PARTITION;

          // ----------
          // DstPart
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next, qdPartitionAttribute );

          // DstPart  partition_spec
          $<partAttr>$->next->next = $<partAttr>7;

          // DstPart  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next->alterPart,
                            qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->next->alterPart );
          $<partAttr>$->next->next->alterPart->alterType = QD_MERGE_PARTITION;

          // DstPart ε Ƽ 
          $<partAttr>$->next->next->alterPart->indexPartAttr = $<indexPartAttr>8;
      }
    | TO_RENAME TR_PARTITION TI_IDENTIFIER TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name-1
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // object name-2
          if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // OldPart tableName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // OldPart  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_RENAME_PARTITION;

          QCP_STRUCT_ALLOC( $<partAttr>$->next, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next );
          // NewPart tableName
          SET_POSITION( $<partAttr>$->next->tablePartName, $<position>5 );

          // NewPart  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->alterPart );
          $<partAttr>$->next->alterPart->alterType = QD_RENAME_PARTITION;
      }
    /* PROJ-2359 Table/Partition Access Option */
    | TO_ACCESS TR_PARTITION TI_IDENTIFIER record_access
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( $<position>3.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );
          $<partAttr>$->accessOption = $<accessOption>4;

          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_ACCESS_PARTITION;
      }
    /* TASK-7307 DML Consistency in Shard */
    | TO_ACCESS TR_PARTITION TI_IDENTIFIER usable_option
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( $<position>3.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );
          $<partAttr>$->mIsUsable = $<boolType>4;

          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_USABLE_PARTITION;
      }
    | TR_SPLIT                 // 1
      TR_PARTITION             // 2
      TI_IDENTIFIER            // 3
      TR_AT                    // 4
      TS_OPENING_PARENTHESIS   // 5
      part_key_cond_list       // 6
      TS_CLOSING_PARENTHESIS   // 7
      TR_INTO                  // 8
      TS_OPENING_PARENTHESIS   // 9
      partition_spec           // 10
      opt_index_part_attr_list // 11
      TS_COMMA                 // 12
      partition_spec           // 13
      opt_index_part_attr_list // 14
      TS_CLOSING_PARENTHESIS   // 15
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // ----------
          // SrcPart
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // SrcPart tableName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // Ƽ  
          $<partAttr>$->partKeyCond = $<valueNode>6;

          // SrcPart  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_SPLIT_RANGE_PARTITION;

          // ----------
          // DstPart1
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next );

          // DstPart1  partition_spec
          $<partAttr>$->next = $<partAttr>10;

          // DstPart1  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->alterPart );
          $<partAttr>$->next->alterPart->alterType = QD_SPLIT_RANGE_PARTITION;

          // DstPart1 ε Ƽ 
          $<partAttr>$->next->alterPart->indexPartAttr = $<indexPartAttr>11;

          // ----------
          // DstPart2
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next->next );

          // DstPart2  partition_spec
          $<partAttr>$->next->next = $<partAttr>13;

          // DstPart2  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next->alterPart,
                            qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->next->alterPart );
          $<partAttr>$->next->next->alterPart->alterType = QD_SPLIT_RANGE_PARTITION;

          // DstPart2 ε Ƽ 
          $<partAttr>$->next->next->alterPart->indexPartAttr = $<indexPartAttr>14;
      }
    | TR_SPLIT                 // 1
      TR_PARTITION             // 2
      TI_IDENTIFIER            // 3
      TR_VALUES                // 4
      TS_OPENING_PARENTHESIS   // 5
      part_key_cond_list       // 6
      TS_CLOSING_PARENTHESIS   // 7
      TR_INTO                  // 8
      TS_OPENING_PARENTHESIS   // 9
      partition_spec           // 10
      opt_index_part_attr_list // 11
      TS_COMMA                 // 12
      partition_spec           // 13
      opt_index_part_attr_list // 14
      TS_CLOSING_PARENTHESIS   // 15
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // ----------
          // SrcPart
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // SrcPart tableName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // Ƽ  
          $<partAttr>$->partKeyCond = $<valueNode>6;

          // SrcPart  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_SPLIT_LIST_PARTITION;

          // ----------
          // DstPart1
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next );

          // DstPart1  partition_spec
          $<partAttr>$->next = $<partAttr>10;

          // DstPart1  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->alterPart );
          $<partAttr>$->next->alterPart->alterType = QD_SPLIT_RANGE_PARTITION;

          // DstPart1 ε Ƽ 
          $<partAttr>$->next->alterPart->indexPartAttr = $<indexPartAttr>11;

          // ----------
          // DstPart2
          // ----------
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next->next );

          // DstPart2  partition_spec
          $<partAttr>$->next->next = $<partAttr>13;

          // DstPart2  alterPart
          QCP_STRUCT_ALLOC( $<partAttr>$->next->next->alterPart,
                            qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->next->alterPart );
          $<partAttr>$->next->next->alterPart->alterType = QD_SPLIT_RANGE_PARTITION;

          // DstPart2 ε Ƽ 
          $<partAttr>$->next->next->alterPart->indexPartAttr = $<indexPartAttr>14;
      }
    | TA_TRUNCATE TR_PARTITION TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // object name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );

          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          // tablePartName
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );

          // alter partition 
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_TRUNCATE_PARTITION;
      }
    | TR_ENABLE TR_ROW TR_MOVEMENT
      {
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          // alter partition 
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_ENABLE_ROW_MOVEMENT;
      }
    | TR_DISABLE TR_ROW TR_MOVEMENT
      {
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          // alter partition 
          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          // qdAlterPartition ʱȭ
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_DISABLE_ROW_MOVEMENT;
      }
    | TR_ALTER               // 1
      TR_PARTITION           // 2
      TI_IDENTIFIER          // 3
      TA_TABLESPACE          // 4
      TI_IDENTIFIER          // 5
      opt_index_storage      // 6
      opt_lob_storage        // 7
      {
          qcuSqlSourceInfo    sqlInfo;

          /* Partition Name */
          if ( $<position>3.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          /* Tablespace Name */
          if ( $<position>5.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          /* Target Partition  */
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
          SET_POSITION( $<partAttr>$->tablePartName, $<position>3 );
          SET_EMPTY_POSITION( $<partAttr>$->TBSName );

          QCP_STRUCT_ALLOC( $<partAttr>$->alterPart, qdAlterPartition );
          QD_SET_INIT_ALTER_PART( $<partAttr>$->alterPart );
          $<partAttr>$->alterPart->alterType = QD_ALTER_PARTITION;

          /* Target Tablespace  */
          QCP_STRUCT_ALLOC( $<partAttr>$->next, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$->next );
          SET_EMPTY_POSITION( $<partAttr>$->next->tablePartName );
          SET_POSITION( $<partAttr>$->next->TBSName, $<position>5 );

          QCP_STRUCT_ALLOC( $<partAttr>$->next->alterPart, qdAlterPartition );
          QD_SET_INIT_ALTER_PART( $<partAttr>$->next->alterPart );
          $<partAttr>$->next->alterPart->alterType = QD_ALTER_PARTITION;

          /* Index Option */
          $<partAttr>$->next->alterPart->indexPartAttr = $<indexPartAttr>6;

          /* Lob Storage Option */
          $<partAttr>$->next->lobAttr = $<lobAttribute>7;
      }
    ;

opt_lob_storage
    : /* empty */
      {
          $<lobAttribute>$ = NULL;
      }
    | TR_LOB                 // 1
      TS_OPENING_PARENTHESIS // 2
      lob_storage_list       // 3
      TS_CLOSING_PARENTHESIS // 4
      {
          $<lobAttribute>$ = $<lobAttribute>3;
      }
    ;

lob_storage_list
    : lob_storage_list TS_COMMA lob_storage_element
      {
          qdLobAttribute   * sLastLobAttr;
          qcmColumn        * sLastColumn;
          qcmColumn        * sCurrColumn;
          qcuSqlSourceInfo   sqlInfo;

          sCurrColumn = $<lobAttribute>3->columns;

          for ( sLastLobAttr  = $<lobAttribute>1;
                sLastLobAttr != NULL;
                sLastLobAttr  = sLastLobAttr->next )
          {
              sLastColumn = sLastLobAttr->columns;

              if ( idlOS::strMatch(
                       QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                       QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size ) == 0 )
              {
                  sqlInfo.setSourceInfo( STATEMENT, &( sLastColumn->namePos ) );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }

              if ( sLastLobAttr->next == NULL )
              {
                  sLastLobAttr->next = $<lobAttribute>3;
                  break;
              }
              else
              {
                  /* Nothing to do. */
              }
          }

          /* BUG-36739 */
          $<lobAttribute>$ = $<lobAttribute>1;
      }
    | lob_storage_element
      {
          $<lobAttribute>$ = $<lobAttribute>1;
      }
    ;

lob_storage_element
    : column_name   // 1
      TA_TABLESPACE // 2
      TI_IDENTIFIER // 3
      {
          qcuSqlSourceInfo  sqlInfo;

          QCP_STRUCT_ALLOC( $<lobAttribute>$, qdLobAttribute );

          /* Column Name */
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          /* Lob Tablesapce Name */
          if ( $<position>3.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          /* Column  */
          QCP_STRUCT_ALLOC( $<lobAttribute>$->columns, qcmColumn );
          QCM_COLUMN_INIT( $<lobAttribute>$->columns );

          SET_EMPTY_POSITION( $<lobAttribute>$->columns->userNamePos );
          SET_EMPTY_POSITION( $<lobAttribute>$->columns->tableNamePos );
          SET_POSITION( $<lobAttribute>$->columns->namePos, $<position>1 );

          /* Lob Tablesapce  */
          QCP_STRUCT_ALLOC( $<lobAttribute>$->storageAttr, qdLobStorageAttribute );
          $<lobAttribute>$->storageAttr->type = QD_LOB_STORAGE_ATTR_TABLESPACE;

          SET_POSITION( $<lobAttribute>$->storageAttr->TBSName, $<position>3 );
          $<lobAttribute>$->storageAttr->logging = ID_TRUE;
          $<lobAttribute>$->storageAttr->buffer = ID_TRUE;
          $<lobAttribute>$->storageAttr->next = NULL;

          $<lobAttribute>$->next = NULL;
      }
    ;

opt_index_storage
    : /* empty */
      {
          $<indexPartAttr>$ = NULL;
      }
    | TO_INDEX                // 1
      TS_OPENING_PARENTHESIS  // 2
      index_storage_list      // 3
      TS_CLOSING_PARENTHESIS  // 4
      {
          $<indexPartAttr>$ = $<indexPartAttr>3;
      }
    ;

index_storage_list
    : index_storage_list TS_COMMA index_storage_element
      {
          qdIndexPartitionAttribute * sLast;
          $<indexPartAttr>$ = $<indexPartAttr>1;

          for ( sLast = $<indexPartAttr>$;
                sLast->next != NULL;
                sLast = sLast->next )
          {
              /* Index Attribute ߺ ˻ qdbAlter::checkIndexPartattrlist Ѵ.
               * Nothing to do
               */
          }

          sLast->next = $<indexPartAttr>3;
      }
    | index_storage_element
      {
          $<indexPartAttr>$ = $<indexPartAttr>1;
      }
    ;

index_storage_element
    : TI_IDENTIFIER // 1
      TA_TABLESPACE // 2
      TI_IDENTIFIER // 3
      {
          qcuSqlSourceInfo sqlInfo;

          /* Partitioned Index Name */
          if ( $<position>1.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          /* Index Tablesapce Name */
          if ( $<position>3.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          /* Partitioned Index  */
          /* Index Tablesapce  */
          QCP_STRUCT_ALLOC( $<indexPartAttr>$, qdIndexPartitionAttribute );
          QD_SET_INIT_INDEX_PART_ATTR( $<indexPartAttr>$ );

          SET_POSITION( $<indexPartAttr>$->partIndexName, $<position>1 );
          SET_EMPTY_POSITION( $<indexPartAttr>$->indexPartName );
          SET_POSITION( $<indexPartAttr>$->TBSName, $<position>3 );

          $<indexPartAttr>$->next = NULL;
      }
    ;

opt_index_part_attr_list
    : /* empty */
      {
          $<indexPartAttr>$ = NULL;
      }
    | TO_INDEX
      TS_OPENING_PARENTHESIS
      index_part_attr_list
      TS_CLOSING_PARENTHESIS
      {
          $<indexPartAttr>$ = $<indexPartAttr>3;
      }
    ;

index_part_attr_list
    : index_part_attr_list TS_COMMA index_part_attr
      {
          qdIndexPartitionAttribute * sLastPart;
          $<indexPartAttr>$ = $<indexPartAttr>1;

          for ( sLastPart = $<indexPartAttr>$;
                sLastPart->next != NULL;
                sLastPart = sLastPart->next )
          {
              /* Index Attribute ߺ ˻ qdbAlter::checkIndexPartAttrList  ִ.
               * , Parser ߺ ˻縦  ʴ´.
               * Nothing to do
               */
          }

          sLastPart->next = $<indexPartAttr>3;
      }
    | index_part_attr
      {
          $<indexPartAttr>$ = $<indexPartAttr>1;
          $<indexPartAttr>$->next = NULL;
      }
    ;

index_part_attr
    : TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER
      {
          qcuSqlSourceInfo     sqlInfo;

          // partitioned index name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // index partition name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<indexPartAttr>$,
                            qdIndexPartitionAttribute );
          // qdIndexPartitionAttribute ʱȭ
          QD_SET_INIT_INDEX_PART_ATTR( $<indexPartAttr>$ );

          SET_POSITION( $<indexPartAttr>$->partIndexName, $<position>1 );
          SET_POSITION( $<indexPartAttr>$->indexPartName, $<position>3 );
          SET_EMPTY_POSITION( $<indexPartAttr>$->TBSName );
      }
    | TI_IDENTIFIER TR_PARTITION TI_IDENTIFIER
      TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo     sqlInfo;

          // partitioned index name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // index partition name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // index tablespace name
          if ($<position>5.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<indexPartAttr>$,
                            qdIndexPartitionAttribute );
          // qdIndexPartitionAttribute ʱȭ
          QD_SET_INIT_INDEX_PART_ATTR( $<indexPartAttr>$ );

          SET_POSITION( $<indexPartAttr>$->partIndexName, $<position>1 );
          SET_POSITION( $<indexPartAttr>$->indexPartName, $<position>3 );
          SET_POSITION( $<indexPartAttr>$->TBSName, $<position>5 );
      }
    ;

partition_spec
    : TR_PARTITION TI_IDENTIFIER opt_table_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>3;
          $<partAttr>$->partKeyCond = NULL;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
      }
    ;

enable_or_disable
    : TR_ENABLE
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_DISABLE
      {
          $<boolType>$ = ID_FALSE;
      }
    ;

alter_table_constraint_statement
    : TR_ALTER TR_TABLE user_object_name TR_ADD table_constraint_def
      {
          // To Fix PR-10909
          // QCP_STRUCT_ALLOC($<tblConstrParseTree>$, qdTblConstrParseTree);
          // QC_SET_INIT_PARSE_TREE($<tblConstrParseTree>$, $<position>1);

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->constraints = $<constraintSpec>5;

          /* PROJ-1107 Check Constraint  */
          QCP_STRUCT_ALLOC( $<tableParseTree>$->from, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<tableParseTree>$->from );

          QCP_STRUCT_ALLOC( $<tableParseTree>$->from->tableRef, qmsTableRef );
          QCP_SET_INIT_QMS_TABLE_REF( $<tableParseTree>$->from->tableRef );

          SET_POSITION( $<tableParseTree>$->from->tableRef->userName,
                        $<userNObjName>3->userName );
          SET_POSITION( $<tableParseTree>$->from->tableRef->tableName,
                        $<userNObjName>3->objectName );

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateAddConstr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeAddConstr;
      }
    // rename constraint
    | TR_ALTER TR_TABLE user_object_name TO_RENAME TR_CONSTRAINT
      TI_IDENTIFIER TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          qdConstraintSpec*   sOldConstraint;
          qdConstraintSpec*   sNewConstraint;

          // constraint name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          // constraint name
          if ($<position>8.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>8 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC(sOldConstraint, qdConstraintSpec);
          QCP_STRUCT_ALLOC(sNewConstraint, qdConstraintSpec);

          QD_SET_INIT_CONSTRAINT_SPEC( sOldConstraint );
          QD_SET_INIT_CONSTRAINT_SPEC( sNewConstraint );

          // ̸ ʿϹǷ ̸ .
          SET_POSITION(sOldConstraint->constrName,
              $<position>6);

          SET_POSITION(sNewConstraint->constrName,
              $<position>8);

          // old տ, new ڿ ֵ Ѵ.
          sOldConstraint->next = sNewConstraint;

          $<tableParseTree>$->constraints = sOldConstraint;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateRenameConstr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeRenameConstr;
      }

    | TR_ALTER TR_TABLE user_object_name TR_DROP TR_CONSTRAINT TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // constraint name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // To Fix PR-10909
          // QCP_STRUCT_ALLOC($<tblConstrParseTree>$, qdTblConstrParseTree);
          // QC_SET_INIT_PARSE_TREE($<tblConstrParseTree>$, $<position>1);

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC($<tableParseTree>$->constraints, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<tableParseTree>$->constraints );

          SET_POSITION($<tableParseTree>$->constraints->constrName,
              $<position>6);

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateDropConstr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeDropConstr;
      }
    | TR_ALTER TR_TABLE user_object_name
                TR_DROP TR_PRIMARY TR_KEY opt_cascade_tok
      {
          if ($<boolType>7 == ID_TRUE)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX));
              YYABORT;
          }

          // To Fix PR-10909
          // QCP_STRUCT_ALLOC($<tblConstrParseTree>$, qdTblConstrParseTree);
          // QC_SET_INIT_PARSE_TREE($<tblConstrParseTree>$, $<position>1);

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );
          
          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateDropPrimary;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeDropPrimary;
      }
    | TR_ALTER TR_TABLE user_object_name TR_DROP TR_UNIQUE
        TS_OPENING_PARENTHESIS column_with_opt_sort_mode_commalist
        TS_CLOSING_PARENTHESIS
        opt_cascade_tok
      {
          if ($<boolType>9 == ID_TRUE)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX));
              YYABORT;
          }

          // To Fix PR-10909
          // QCP_STRUCT_ALLOC($<tblConstrParseTree>$, qdTblConstrParseTree);
          // QC_SET_INIT_PARSE_TREE($<tblConstrParseTree>$, $<position>1);

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC( $<tableParseTree>$->constraints, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<tableParseTree>$->constraints );

          $<tableParseTree>$->constraints->constraintColumns = $<columnDef>7;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateDropUnique;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeDropUnique;
      }
    // PROJ-1502 PARTITIONED DISK TABLE
    | TR_ALTER TR_TABLE user_object_name TR_DROP TR_LOCALUNIQUE
        TS_OPENING_PARENTHESIS column_with_opt_sort_mode_commalist
        TS_CLOSING_PARENTHESIS
        opt_cascade_tok
      {
          if ($<boolType>9 == ID_TRUE)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX));
              YYABORT;
          }

          // To Fix PR-10909
          // QCP_STRUCT_ALLOC($<tblConstrParseTree>$, qdTblConstrParseTree);
          // QC_SET_INIT_PARSE_TREE($<tblConstrParseTree>$, $<position>1);

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC( $<tableParseTree>$->constraints, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<tableParseTree>$->constraints );

          $<tableParseTree>$->constraints->constraintColumns = $<columnDef>7;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateDropLocalUnique;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeDropLocalUnique;
      }
    // PROJ-1874 FOREIGN KEY NOVALIDATE
    | TR_ALTER TR_TABLE user_object_name TR_MODIFY TR_CONSTRAINT TI_IDENTIFIER
      constraint_state
      {
          qcuSqlSourceInfo    sqlInfo;

          // constraint name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          QCP_STRUCT_ALLOC($<tableParseTree>$->constraints, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<tableParseTree>$->constraints );

          SET_POSITION($<tableParseTree>$->constraints->constrName,
              $<position>6);

          $<tableParseTree>$->constraints->constrState = $<constraintState>7;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdn::validateModifyConstr;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdn::executeModifyConstr;
      }
    ;

opt_column_tok
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_COLUMN
      {
          $<boolType>$ = ID_TRUE;
      }
    ;

opt_cascade_tok
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_CASCADE
      {
          $<boolType>$ = ID_TRUE;
      }
    ;

alter_index_statement
    : TR_ALTER TO_INDEX user_object_name alter_index_clause
      {
          $<indexParseTree>$ = $<indexParseTree>4;
          QC_SET_INIT_PARSE_TREE($<indexParseTree>$, $<position>1);
          
          /* set userNameOfIndex position */
          SET_POSITION($<indexParseTree>$->userNameOfIndex,
                       $<userNObjName>3->userName);
          /* set indexName position */
          SET_POSITION($<indexParseTree>$->indexName,
                       $<userNObjName>3->objectName);
      }
    | TR_ALTER TO_INDEX user_object_name TR_SET alter_index_set_clause
      {
          $<indexParseTree>$ = $<indexParseTree>5;
          QC_SET_INIT_PARSE_TREE($<indexParseTree>$, $<position>1);
          
          /* set userNameOfIndex position */
          SET_POSITION($<indexParseTree>$->userNameOfIndex,
                       $<userNObjName>3->userName);
          /* set indexName position */
          SET_POSITION($<indexParseTree>$->indexName,
                       $<userNObjName>3->objectName);
      }
    ;

// BUG-42883 alter index parser 
// nonquoted identifier ϴ alter index  Ƽ óѴ.
alter_index_clause
    // PROJ-704 MVCC Renewal
    : TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "AGING", 5,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
              QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

              QCP_STRUCT_ALLOC($<indexParseTree>$->partIndex, qdPartitionedIndex);
              QD_SET_INIT_PARTITIONED_INDEX($<indexParseTree>$->partIndex);

              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAgingIndex;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAgingIndex;
          }
          else if (idlOS::strMatch( "PERSISTENT", 10, QTEXT+$<position>1.offset,
                                    $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
              QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

              QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
              QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );
              
              $<indexParseTree>$->flag  = 0;
              $<indexParseTree>$->flag &= ~QDX_IDX_OPT_PERSISTENT_MASK;
              $<indexParseTree>$->flag |= QDX_IDX_OPT_PERSISTENT_TRUE;

              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAlter;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAlterPers;
          }
          else if (idlOS::strMatch( "DIRECTKEY", 9, QTEXT+$<position>1.offset,
                                    $<position>1.size) == 0)
          {
              /* BUG-40683 */
              /*
               * PROJ-2433 Direct Key Index
               * statement : ALTER INDEX index_name DIRECTKEY 
               */
              QCP_STRUCT_ALLOC( $<indexParseTree>$, qdIndexParseTree );
              QD_INDEX_PARSE_TREE_INIT( $<indexParseTree>$ );

              QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
              QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );
 
              $<indexParseTree>$->flag  = 0;
              $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
              $<indexParseTree>$->flag |=  SMI_INDEX_DIRECTKEY_TRUE;
              $<indexParseTree>$->mDirectKeyMaxSize = 0;

              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAlterDirectKey;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAlterDirectKey;
          }
          else if (idlOS::strMatch( "REORGANIZATION", 14, QTEXT+$<position>1.offset,
                                    $<position>1.size) == 0)
          {
              /* PROJ-2614 Memory Index Key Reorganization */
              QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
              QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

              QCP_STRUCT_ALLOC($<indexParseTree>$->partIndex, qdPartitionedIndex);
              QD_SET_INIT_PARTITIONED_INDEX($<indexParseTree>$->partIndex);
          
              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAlterReorganization;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAlterReorganization;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
      | TI_NONQUOTED_IDENTIFIER TO_EXTENT
      {
          qcuSqlSourceInfo    sqlInfo;

          // alter index index_name storage( .. );
          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );

          if (idlOS::strMatch("ALLOCATE", 8,
                              QTEXT+$<position>1.offset, $<position>1.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          $<indexParseTree>$->altAllocExtSize = 1; // align Ǿ 1 Extent Ҵȴ.

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterAllocExtent;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterAllocExts;
      }
      | TI_NONQUOTED_IDENTIFIER TO_EXTENT
        TS_OPENING_PARENTHESIS
        TI_NONQUOTED_IDENTIFIER size_option
        TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );

          if (idlOS::strMatch("ALLOCATE", 8,
                              QTEXT+$<position>1.offset, $<position>1.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if (idlOS::strMatch("SIZE", 4,
                              QTEXT+$<position>4.offset, $<position>4.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          $<indexParseTree>$->altAllocExtSize = $<uLongVal>5;

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterAllocExtent;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterAllocExts;
      }
      | TR_REBUILD
      {
          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC($<indexParseTree>$->partIndex, qdPartitionedIndex);
          QD_SET_INIT_PARTITIONED_INDEX($<indexParseTree>$->partIndex);
          
          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterRebuild;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterRebuild;
      }
      // PROJ-1502 PARTITIONED DISK TABLE
      | TR_REBUILD TR_PARTITION TI_IDENTIFIER opt_index_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          // index partition name to rebuild
          SET_POSITION($<indexParseTree>$->rebuildPartName, $<position>3);

          // fix BUG-18937
          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );

          $<indexParseTree>$->partIndex->partAttr = $<partAttr>4;

          $<indexParseTree>$->flag  = 0;

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterRebuildPartition;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterRebuildPartition;
      }
     | storage_clause
     {
          // alter index index_name storage( .. );
          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );

          if ( ($<attrNode>1->initExtCnt == NULL) &&
               ($<attrNode>1->nextExtCnt == NULL) &&
               ($<attrNode>1->minExtCnt  == NULL) &&
               ($<attrNode>1->maxExtCnt  == NULL) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          // InitExtents
          if ($<attrNode>1->initExtCnt == NULL)
          {
              $<indexParseTree>$->segStoAttr.mInitExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mInitExtCnt=
                  *($<attrNode>1->initExtCnt);
              $<indexParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          // NextExtents
          if ($<attrNode>1->nextExtCnt == NULL)
          {
              $<indexParseTree>$->segStoAttr.mNextExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mNextExtCnt=
                  *($<attrNode>1->nextExtCnt);
              $<indexParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          // minExtents
          if ($<attrNode>1->minExtCnt == NULL)
          {
              $<indexParseTree>$->segStoAttr.mMinExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mMinExtCnt=
                  *($<attrNode>1->minExtCnt);
              $<indexParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          // maxExtents
          if ($<attrNode>1->maxExtCnt == NULL)
          {
              $<indexParseTree>$->segStoAttr.mMaxExtCnt=
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mMaxExtCnt=
                  *($<attrNode>1->maxExtCnt);
              $<indexParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterSegStoAttr;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterSegStoAttr;
      }
    /* BUG-15235 RENAME INDEX */
    | TO_RENAME TR_TO TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // new index name
          SET_POSITION($<indexParseTree>$->newIndexName, $<position>3);

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterRename;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterRename;
      }
    // BUG-42883 alter index parser 
    // ǹ̻ set ؾϳ ȣȯ set   ְѴ.
    | alter_index_set_clause
      {
          $<indexParseTree>$ = $<indexParseTree>1;
      }
    ;

// BUG-42883 alter index parser 
// nonquoted identifier ϴ alter index  Ƽ óѴ.
alter_index_set_clause
    : TI_NONQUOTED_IDENTIFIER on_off_clause
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch( "PERSISTENT", 10, QTEXT+$<position>1.offset,
                               $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
              QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

              QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
              QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );
              
              $<indexParseTree>$->flag  = 0;
              if ( $<boolType>2 == ID_TRUE )
              {
                  $<indexParseTree>$->flag &= ~QDX_IDX_OPT_PERSISTENT_MASK;
                  $<indexParseTree>$->flag |= QDX_IDX_OPT_PERSISTENT_TRUE;
              }
              else
              {
                  $<indexParseTree>$->flag &= ~QDX_IDX_OPT_PERSISTENT_MASK;
                  $<indexParseTree>$->flag |= QDX_IDX_OPT_PERSISTENT_FALSE;
              }

              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAlter;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAlterPers;
          }
          else if (idlOS::strMatch( "DIRECTKEY", 9, QTEXT+$<position>1.offset,
                                    $<position>1.size) == 0)
          {
              /* BUG-40683 */
              /*
               * PROJ-2433 Direct Key Index
               * statement : ALTER INDEX index_name DIRECTKEY 
               */
              QCP_STRUCT_ALLOC( $<indexParseTree>$, qdIndexParseTree );
              QD_INDEX_PARSE_TREE_INIT( $<indexParseTree>$ );

              QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
              QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );
 
              $<indexParseTree>$->flag  = 0;
              if ( $<boolType>2 == ID_TRUE )
              {
                  $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
                  $<indexParseTree>$->flag |=  SMI_INDEX_DIRECTKEY_TRUE;
                  $<indexParseTree>$->mDirectKeyMaxSize = 0;
              }
              else
              {
                  $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
                  $<indexParseTree>$->flag |= SMI_INDEX_DIRECTKEY_FALSE;
                  $<indexParseTree>$->mDirectKeyMaxSize = (ULong)(ID_ULONG_MAX);
              }

              $<indexParseTree>$->common.parse    = qcc::parse;
              $<indexParseTree>$->common.validate = qdx::validateAlterDirectKey;
              $<indexParseTree>$->common.optimize = qcc::optimize;
              $<indexParseTree>$->common.execute  = qdx::executeAlterDirectKey;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
      | TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TL_INTEGER 
      {
          /* BUG-40683 */
          /*
           * PROJ-2433 Direct Key Index
           * statement : ALTER INDEX index_name DIRECTKEY MAXSIZE n
           */
          qcuSqlSourceInfo   sqlInfo;
          SLong              sNumber;

          if ( idlOS::strMatch( "DIRECTKEY",
                                9,
                                QTEXT + $<position>1.offset,
                                $<position>1.size ) == 0 )
          {
              /* nothing to do */
          }
          else
          { /* syntax error */
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if ( idlOS::strMatch( "MAXSIZE",
                                7,
                                QTEXT + $<position>2.offset,
                                $<position>2.size ) == 0 )
          {
              /* nothing to do */
          }
          else
          { /* syntax error */
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          if ( qtc::getBigint( QTEXT,
                               &sNumber,
                               &$<position>3 ) != IDE_SUCCESS )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          QCP_STRUCT_ALLOC( $<indexParseTree>$, qdIndexParseTree );
          QD_INDEX_PARSE_TREE_INIT( $<indexParseTree>$ );

          QCP_STRUCT_ALLOC( $<indexParseTree>$->partIndex, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<indexParseTree>$->partIndex );
 
          $<indexParseTree>$->flag  = 0;
          $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
          $<indexParseTree>$->flag |=  SMI_INDEX_DIRECTKEY_TRUE;
          $<indexParseTree>$->mDirectKeyMaxSize = (ULong)sNumber;

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterDirectKey;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterDirectKey;
      }
      | ttl_clause
      {
          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          QCP_STRUCT_ALLOC($<indexParseTree>$->partIndex, qdPartitionedIndex);
          QD_SET_INIT_PARTITIONED_INDEX($<indexParseTree>$->partIndex);

          // INIT/MAX Trans
          if ($<ttl>1->initTrans == NULL)
          {
              $<indexParseTree>$->segAttr.mInitTrans=
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<indexParseTree>$->segAttr.mInitTrans =
                  *($<ttl>1->initTrans);
          }

          if ($<ttl>1->maxTrans == NULL)
          {
              $<indexParseTree>$->segAttr.mMaxTrans=
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<indexParseTree>$->segAttr.mMaxTrans =
                  *($<ttl>1->maxTrans);
          }

          $<indexParseTree>$->common.parse    = qcc::parse;
          $<indexParseTree>$->common.validate = qdx::validateAlterSegAttr;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::executeAlterSegAttr;
      }
    ;

on_off_clause
    : TR_ON
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_OFF
      {
          $<boolType>$ = ID_FALSE;
      }
    | TS_EQUAL_SIGN TR_ON
      {
          $<boolType>$ = ID_TRUE;
      }
    | TS_EQUAL_SIGN TR_OFF
      {
          $<boolType>$ = ID_FALSE;
      }
    ;

create_sequence_statement
    : TR_CREATE TR_SEQUENCE user_object_name opt_sequence_options opt_sequence_sync_table
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<seqParseTree>$, qdSequenceParseTree);
          QC_SET_INIT_PARSE_TREE($<seqParseTree>$, $<position>1);
          QD_SEQUENCE_PARSE_TREE_INIT($<seqParseTree>$);

          /* set userName position */
          SET_POSITION($<seqParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set sequenceName position */
          SET_POSITION($<seqParseTree>$->sequenceName,
                       $<userNObjName>3->objectName);

          $<seqParseTree>$->sequenceOptions = $<sequenceOptions>4;
          $<seqParseTree>$->enableSeqTable  = $<boolType>5;

          /* TASK-7217 Sharded sequence
           * CREATE SEQUENCE RESTARTɼ   . */
          if ( ($<seqParseTree>$->sequenceOptions->flag & QDS_SEQ_OPT_RESTART_MASK) == QDS_SEQ_OPT_RESTART_TRUE )
          {
              sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if( $<seqParseTree>$->sequenceOptions->incrementValue == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->incrementValue, SLong);
              *$<sequenceOptions>4->incrementValue = 1;
          }

          if( $<seqParseTree>$->sequenceOptions->minValue == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->minValue, SLong);
              if ( *$<seqParseTree>$->sequenceOptions->incrementValue > 0 )
              { // ascending sequence
                  *$<sequenceOptions>4->minValue = 1;
              }
              else
              { // descending sequence
                  if ( ($<seqParseTree>$->sequenceOptions->flag & QDS_SEQ_OPT_LOCALITY_MASK) == QDS_SEQ_OPT_LOCALITY_SHARD )
                  {
                      *$<sequenceOptions>4->minValue = QDS_SHARD_SEQUENCE_MIN_VALUE;
                  }
                  else
                  {
                      *$<sequenceOptions>4->minValue = QDS_SEQUENCE_MIN_VALUE;
                  }
              }
          }

          if( $<seqParseTree>$->sequenceOptions->maxValue == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->maxValue, SLong);
              if ( *$<seqParseTree>$->sequenceOptions->incrementValue > 0 )
              { // ascending sequence
                  if ( ($<seqParseTree>$->sequenceOptions->flag & QDS_SEQ_OPT_LOCALITY_MASK) == QDS_SEQ_OPT_LOCALITY_SHARD )
                  {
                      *$<sequenceOptions>4->maxValue = QDS_SHARD_SEQUENCE_MAX_VALUE;
                  }
                  else
                  {
                      *$<sequenceOptions>4->maxValue = QDS_SEQUENCE_MAX_VALUE;
                  }
              }
              else
              { // descending sequence
                  *$<sequenceOptions>4->maxValue = -1;
              }
          }

          if( $<seqParseTree>$->sequenceOptions->startValue == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->startValue, SLong);
              if ( *$<seqParseTree>$->sequenceOptions->incrementValue > 0 )
              { // ascending sequence
                  *$<sequenceOptions>4->startValue =
                      *$<sequenceOptions>4->minValue;
              }
              else
              { // descending sequence
                  *$<sequenceOptions>4->startValue =
                      *$<sequenceOptions>4->maxValue;
              }
          }

          if( $<seqParseTree>$->sequenceOptions->cacheValue == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->cacheValue, SLong);
              *$<sequenceOptions>4->cacheValue = 20;
          }

          if( $<seqParseTree>$->sequenceOptions->cycleOption == NULL )
          {
              QCP_STRUCT_ALLOC($<sequenceOptions>4->cycleOption, UInt);
              *$<sequenceOptions>4->cycleOption = 0;
              *$<sequenceOptions>4->cycleOption
                  &= ~SMI_SEQUENCE_CIRCULAR_MASK;
              *$<sequenceOptions>4->cycleOption
                  |= SMI_SEQUENCE_CIRCULAR_DISABLE;
          }

          $<seqParseTree>$->common.parse    = qcc::parse;
          $<seqParseTree>$->common.validate = qds::validateCreate;
          $<seqParseTree>$->common.optimize = qcc::optimize;
          $<seqParseTree>$->common.execute  = qds::executeCreate;
      }
    ;

opt_sequence_options
    : /* empty */
      {
          QCP_STRUCT_ALLOC($<sequenceOptions>$, qdSequenceOptions);
          $<sequenceOptions>$->startValue     = NULL;
          $<sequenceOptions>$->incrementValue = NULL;
          $<sequenceOptions>$->minValue       = NULL;
          $<sequenceOptions>$->maxValue       = NULL;
          $<sequenceOptions>$->cacheValue     = NULL;
          $<sequenceOptions>$->cycleOption    = NULL;
          $<sequenceOptions>$->flag           = 0;
      }
    | sequence_options
      {
          $<sequenceOptions>$ = $<sequenceOptions>1;
      }
    ;

opt_sequence_sync_table
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | sequence_sync_table
      {
          $<boolType>$ = $<boolType>1;
      }
    ;

sequence_sync_table
    : enable_or_disable TI_NONQUOTED_IDENTIFIER TR_TABLE
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "SYNC", 4,
                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, &($<position>2));
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          $<boolType>$ = $<boolType>1;
      }
    ;

create_index_statement
    : opt_index_uniqueness
      user_object_name
      TR_ON
      user_object_name
      TS_OPENING_PARENTHESIS
      expression_with_opt_sort_mode_commalist /* PROJ-1090 Function-based Index */
      TS_CLOSING_PARENTHESIS
      opt_index_partitioning_clause
      opt_index_type_and_directkey
      opt_index_pers
      opt_index_attributes // To Fix BUG-13364
      ttl_option
      storage_option       // PROJ-1671 BITMAP SEGMENT
      {
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<indexParseTree>$, qdIndexParseTree);
          QC_SET_INIT_PARSE_TREE($<indexParseTree>$, $<position>1);
          QD_INDEX_PARSE_TREE_INIT($<indexParseTree>$);

          /* set userNameOfIndex position */
          SET_POSITION($<indexParseTree>$->userNameOfIndex,
                       $<userNObjName>2->userName);
          /* set indexName position */
          SET_POSITION($<indexParseTree>$->indexName,
                       $<userNObjName>2->objectName);

          /* set userNameOfTable position */
          SET_POSITION($<indexParseTree>$->userNameOfTable,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<indexParseTree>$->tableName,
                       $<userNObjName>4->objectName);

          /* PROJ-1090 Function-based Index */
          QCP_STRUCT_ALLOC( $<indexParseTree>$->defaultExprFrom, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<indexParseTree>$->defaultExprFrom );

          QCP_STRUCT_ALLOC( $<indexParseTree>$->defaultExprFrom->tableRef, qmsTableRef );
          QCP_SET_INIT_QMS_TABLE_REF( $<indexParseTree>$->defaultExprFrom->tableRef );
          
          SET_POSITION( $<indexParseTree>$->defaultExprFrom->tableRef->userName,
                        $<userNObjName>4->userName );
          SET_POSITION( $<indexParseTree>$->defaultExprFrom->tableRef->tableName,
                        $<userNObjName>4->objectName );
          
          $<indexParseTree>$->keyColumns = $<columnWithPosition>6->column;

          // BUG-21761
          $<indexParseTree>$->ncharList = NCHARLIST;

          /* PROJ-1090 Function-based Index */
          QCP_TEST( qcpUtil::makeHiddenColumnNameAndPosition(
                                STATEMENT,
                                $<indexParseTree>$->indexName,
                                $<position>5,
                                $<position>7,
                                $<columnWithPosition>6 )
                    != IDE_SUCCESS );

          // PROJ-1502 PARTITIONED DISK TABLE
          if ($<flag>1 == QD_NONE_UNIQUE_INDEX ) // non-unique index
          {
              $<indexParseTree>$->flag =
                  SMI_INDEX_UNIQUE_DISABLE|SMI_INDEX_TYPE_NORMAL;
          }
          else if ($<flag>1 == QD_GLOBAL_UNIQUE_INDEX ) // global-unique index
          {
              $<indexParseTree>$->flag =
                  SMI_INDEX_UNIQUE_ENABLE|SMI_INDEX_TYPE_NORMAL;
          }
          else if ($<flag>1 == QD_LOCAL_UNIQUE_INDEX ) // local-unique index
          {
              $<indexParseTree>$->flag =
                  SMI_INDEX_LOCAL_UNIQUE_ENABLE|SMI_INDEX_TYPE_NORMAL;
          }
          else
          {
              // Nothing to do
          }

          // PROJ-1502 PARTITIONED DISK TABLE
          $<indexParseTree>$->partIndex = $<partIndex>8;

          $<indexParseTree>$->indexType = $<indexTypeAndDirectKey>9.position;

          /* PROJ-2433 Direct Key Index */
          if ( $<indexTypeAndDirectKey>9.maxSize != (ULong)(ID_ULONG_MAX) )
          {
              $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
              $<indexParseTree>$->flag |=  SMI_INDEX_DIRECTKEY_TRUE;
              $<indexParseTree>$->mDirectKeyMaxSize = $<indexTypeAndDirectKey>9.maxSize;
          }
          else
          {
              $<indexParseTree>$->flag &= ~SMI_INDEX_DIRECTKEY_MASK;
              $<indexParseTree>$->flag |=  SMI_INDEX_DIRECTKEY_FALSE;
              $<indexParseTree>$->mDirectKeyMaxSize = (ULong)(ID_ULONG_MAX);
          }

          if ( $<boolType>10 == ID_TRUE ) /* persistent index */
          {
              $<indexParseTree>$->flag &= ~QDX_IDX_OPT_PERSISTENT_MASK;
              $<indexParseTree>$->flag |= QDX_IDX_OPT_PERSISTENT_TRUE;
          }
          else
          {
              // Nothing to do
          }

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<indexParseTree>$->TBSName );
          $<indexParseTree>$->parallelDegree = 0;
          // BUG-17848
          $<indexParseTree>$->buildFlag = SMI_INDEX_BUILD_DEFAULT;

          for ( sCurIndexAttr = $<indexAttributes>11;
                sCurIndexAttr != NULL ;
                sCurIndexAttr = sCurIndexAttr->next )
          {
              switch( sCurIndexAttr->type )
              {
                  case QD_INDEX_ATTR_LOGGING :
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_LOGGING_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_LOGGING;
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_FORCE_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_NOFORCE;
                      break;
                  case QD_INDEX_ATTR_NOLOGGING_FORCE :
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_LOGGING_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_NOLOGGING;
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_FORCE_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_FORCE;
                      break;
                  case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_LOGGING_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_NOLOGGING;
                      $<indexParseTree>$->buildFlag &=
                          ~SMI_INDEX_BUILD_FORCE_MASK;
                      $<indexParseTree>$->buildFlag |=
                          SMI_INDEX_BUILD_NOFORCE;
                      break;
                  case QD_INDEX_ATTR_TABLESPACE :
                      SET_POSITION( $<indexParseTree>$->TBSName,
                                    sCurIndexAttr->TBSName );
                      break;
                  case QD_INDEX_ATTR_PARALLEL :
                      $<indexParseTree>$->parallelDegree =
                          sCurIndexAttr->parallelDegree;
                      break;
                  case QD_INDEX_ATTR_NOPARALLEL :
                      $<indexParseTree>$->parallelDegree = 1;  // BUG-16909
                      break;
                  default :
                      IDE_DASSERT(0);
                      break;
              }
          }

          // PROJ-1704 MVCC Renewal
          if ( $<ttl>12->initTrans == NULL )
          {
              $<indexParseTree>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<indexParseTree>$->segAttr.mInitTrans =
                  *$<ttl>12->initTrans;
          }

          if ( $<ttl>12->maxTrans == NULL )
          {
              $<indexParseTree>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<indexParseTree>$->segAttr.mMaxTrans =
                  *$<ttl>12->maxTrans;
          }

          // PROJ-1671 BITMAP TABLESPACE AND SEGMENT SPACE MANAGEMENT
          // Segment Storage Attribute list
          if ( $<attrNode>13->initExtCnt == NULL )
          {
              $<indexParseTree>$->segStoAttr.mInitExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mInitExtCnt =
                  *$<attrNode>13->initExtCnt;
              $<indexParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          if ( $<attrNode>13->nextExtCnt == NULL )
          {
              $<indexParseTree>$->segStoAttr.mNextExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mNextExtCnt =
                  *$<attrNode>13->nextExtCnt;
              $<indexParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          if ($<attrNode>13->minExtCnt == NULL)
          {
              $<indexParseTree>$->segStoAttr.mMinExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mMinExtCnt =
                  *$<attrNode>13->minExtCnt;
              $<indexParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          if ( $<attrNode>13->maxExtCnt == NULL )
          {
              $<indexParseTree>$->segStoAttr.mMaxExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<indexParseTree>$->segStoAttr.mMaxExtCnt =
                  *$<attrNode>13->maxExtCnt;
              $<indexParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          $<indexParseTree>$->common.parse    = qdx::parse;
          $<indexParseTree>$->common.validate = qdx::validate;
          $<indexParseTree>$->common.optimize = qcc::optimize;
          $<indexParseTree>$->common.execute  = qdx::execute;
      }
    ;

opt_index_uniqueness
    : TR_CREATE TO_INDEX
      {
          $<flag>$ = QD_NONE_UNIQUE_INDEX;
      }
    | TR_CREATE TR_UNIQUE TO_INDEX
      {
          $<flag>$ = QD_GLOBAL_UNIQUE_INDEX;
      }
    // PROJ-1502 PARTITIONED DISK TABLE
    | TR_CREATE TR_LOCALUNIQUE TO_INDEX
      {
          $<flag>$ = QD_LOCAL_UNIQUE_INDEX;
      }
    ;

opt_index_type_and_directkey
    : /* empty */
      {
          QD_INDEX_TYPE_DIRECT_KEY_INIT( &($<indexTypeAndDirectKey>$) );
      }
    | index_type
      {
          QD_INDEX_TYPE_DIRECT_KEY_INIT( &($<indexTypeAndDirectKey>$) );
          $<indexTypeAndDirectKey>$.position = $<position>1;
      }
    | index_directkey
      {
          QD_INDEX_TYPE_DIRECT_KEY_INIT( &($<indexTypeAndDirectKey>$) );
          $<indexTypeAndDirectKey>$.maxSize  = $<uLongVal>1;
      }
    | index_type index_directkey
      {
          QD_INDEX_TYPE_DIRECT_KEY_INIT( &($<indexTypeAndDirectKey>$) );
          $<indexTypeAndDirectKey>$.position = $<position>1;
          $<indexTypeAndDirectKey>$.maxSize  = $<uLongVal>2;
      }
    ;

index_type
    : TI_NONQUOTED_IDENTIFIER TR_IS TI_NONQUOTED_IDENTIFIER
      /* INDEXTYPE IS BTREE OR RTREE */
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( (idlOS::strMatch(
                "INDEXTYPE", 9,
                QTEXT+$<position>1.offset, $<position>1.size) == 0) &&
               ((idlOS::strMatch(
                "BTREE", 5,
                QTEXT+$<position>3.offset, $<position>3.size) == 0) ||
                (idlOS::strMatch(
                "RTREE", 5,
                QTEXT+$<position>3.offset, $<position>3.size) == 0) ||
                //PROJ-1488 Altibase Spatio-Temporal DBMS
                (idlOS::strMatch(
                "TDRTREE", 7,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)) )
          {
              $<position>$ = $<position>3;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

opt_index_directkey
    : /* empty */
      {
          /* PROJ-2433 Direct Key Index */
          $<uLongVal>$ = (ULong)(ID_ULONG_MAX);
      }
    | index_directkey
      {
          $<uLongVal>$ = $<uLongVal>1;
      }
    ;

index_directkey
    : TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER TL_INTEGER
      /* statement :  DIRECTKEY MAXSIZE x */
      {
          /* PROJ-2433 Direct Key Index */
          qcuSqlSourceInfo   sqlInfo;
          SLong              sNumber;

          if ( idlOS::strMatch( "DIRECTKEY",
                                9,
                                QTEXT + $<position>1.offset,
                                $<position>1.size ) != 0 )
          { /* syntax error */
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }
          
          if ( idlOS::strMatch( "MAXSIZE",
                                7,
                                QTEXT + $<position>2.offset,
                                $<position>2.size ) != 0 )
          { /* syntax error */
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          if ( qtc::getBigint( QTEXT,
                               &sNumber,
                               &$<position>3 ) != IDE_SUCCESS )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          $<uLongVal>$ = sNumber;
      }
    | TI_NONQUOTED_IDENTIFIER
      /* DIRECTKEY */
      {
          /* PROJ-2433 Direct Key Index */
          qcuSqlSourceInfo   sqlInfo;
          
          if ( idlOS::strMatch( "DIRECTKEY",
                                9,
                                QTEXT + $<position>1.offset,
                                $<position>1.size ) != 0 )
          { /* syntax error */
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }
          
          $<uLongVal>$ = 0;
      }
    ;

opt_index_pers
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TR_ON
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "PERSISTENT", 10,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }

          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }

    | TR_SET TI_NONQUOTED_IDENTIFIER TS_EQUAL_SIGN TR_OFF
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "PERSISTENT", 10,
                QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              $<boolType>$ = ID_FALSE;
          }

          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

constr_using_option
    : /* empty */
      {
          $<indexAttrAndLocalIndex>$ = NULL;
      }
    | TR_USING TO_INDEX opt_index_partitioning_clause opt_index_attributes ttl_option
      {
          QCP_STRUCT_ALLOC( $<indexAttrAndLocalIndex>$,
                            qdIndexAttrAndLocalIndex );

          // initialize
          $<indexAttrAndLocalIndex>$->partIndex = $<partIndex>3;
          $<indexAttrAndLocalIndex>$->indexAttr = $<indexAttributes>4;

          $<indexAttrAndLocalIndex>$->ttl       = $<ttl>5;
      }
    ;

opt_index_attributes
    : /* empty */
      {
          $<indexAttributes>$ = NULL;
      }
    | opt_index_attribute_list
      {
          $<indexAttributes>$ = $<indexAttributes>1;
      }
    ;

opt_index_attribute_list
    : opt_index_attribute_list opt_index_attribute_element
      {
          qdIndexAttribute * sLast;

          // check duplicate attribute & connect
          if ($<indexAttributes>1 != NULL)
          {
              for (sLast = $<indexAttributes>1;
                   sLast != NULL;
                   sLast = sLast->next)
              {
                  if ((sLast->type & QD_INDEX_ATTR_TYPE_MASK) ==
                      ($<indexAttributes>2->type & QD_INDEX_ATTR_TYPE_MASK))
                  {
                      if ((sLast->type & QD_INDEX_ATTR_TYPE_MASK) ==
                          QD_INDEX_ATTR_TYPE_LOGGING_FORCE_MASK )
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_LOGGING_OPTION));
                          YYABORT;
                      }
                      else if ((sLast->type & QD_INDEX_ATTR_TYPE_MASK) ==
                               QD_INDEX_ATTR_TYPE_TABLESPACE_MASK )
                      {
                          IDE_SET(ideSetErrorCode(
                                      qpERR_ABORT_QCP_INVALID_TABLESPACE_OPTION));
                          YYABORT;
                      }
                      else if ((sLast->type & QD_INDEX_ATTR_TYPE_MASK) ==
                               QD_INDEX_ATTR_TYPE_PARALLEL_MASK )
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_PARALLEL_OPTION));
                          YYABORT;
                      }
                      else
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                          YYABORT;
                      }
                  }

                  if (sLast->next == NULL)
                  {
                      sLast->next = $<indexAttributes>2;
                      break;
                  }
                  else
                  {
                      // Nothing to do.
                  }
              }

              // BUG-36739
              $<indexAttributes>$ = $<indexAttributes>1;
          }
          else
          {
              // BUG-36739
              $<indexAttributes>$ = $<indexAttributes>2;
          }
      }
    | opt_index_attribute_element
      {
          $<indexAttributes>$ = $<indexAttributes>1;
      }
    ;

opt_index_attribute_element
    :  TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace name
          if ($<position>2.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          $<indexAttributes>$->type = QD_INDEX_ATTR_TABLESPACE;
          SET_POSITION($<indexAttributes>$->TBSName, $<position>2);
          $<indexAttributes>$->parallelDegree = 0;
          $<indexAttributes>$->next = NULL;
      }

    | TR_PARALLEL TL_INTEGER
      {
          SLong sParallelDegree = QD_INDEX_DEFAULT_PARALLEL_DEGREE;

          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          $<indexAttributes>$->type = QD_INDEX_ATTR_PARALLEL;
          SET_EMPTY_POSITION($<indexAttributes>$->TBSName);
          if ( qtc::getBigint( QTEXT, &sParallelDegree, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          $<indexAttributes>$->parallelDegree = sParallelDegree;
          $<indexAttributes>$->next = NULL;
      }
    | TR_NOPARALLEL
      {
          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          $<indexAttributes>$->type = QD_INDEX_ATTR_NOPARALLEL;
          SET_EMPTY_POSITION($<indexAttributes>$->TBSName);
          $<indexAttributes>$->parallelDegree = 1;  // BUG-16909
          $<indexAttributes>$->next = NULL;
      }
    | TR_LOGGING
      {
          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          $<indexAttributes>$->type = QD_INDEX_ATTR_LOGGING;
          SET_EMPTY_POSITION($<indexAttributes>$->TBSName);
          $<indexAttributes>$->parallelDegree = 0;
          $<indexAttributes>$->next = NULL;
      }

    | TR_NOLOGGING
      {
          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          $<indexAttributes>$->type = QD_INDEX_ATTR_NOLOGGING_FORCE;
          SET_EMPTY_POSITION($<indexAttributes>$->TBSName);
          $<indexAttributes>$->parallelDegree = 0;
          $<indexAttributes>$->next = NULL;
      }

    | TR_NOLOGGING TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>2.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<indexAttributes>$, qdIndexAttribute );

          SET_EMPTY_POSITION($<indexAttributes>$->TBSName);
          $<indexAttributes>$->parallelDegree = 0;
          $<indexAttributes>$->next = NULL;

          if (idlOS::strMatch(
                  "NOFORCE", 7,
                  QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              $<indexAttributes>$->type = QD_INDEX_ATTR_NOLOGGING_NOFORCE;
          }
          else if (idlOS::strMatch(
                       "FORCE", 5,
                       QTEXT+$<position>2.offset, $<position>2.size) == 0)
          {
              $<indexAttributes>$->type = QD_INDEX_ATTR_NOLOGGING_FORCE;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

opt_index_partitioning_clause
    : /* empty */
      {
          // $<partIndex>$ = NULL;
          QCP_STRUCT_ALLOC( $<partIndex>$, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<partIndex>$ );
      }
    | local_partitioned_index
      {
          QCP_STRUCT_ALLOC( $<partIndex>$, qdPartitionedIndex );
          QD_SET_INIT_PARTITIONED_INDEX( $<partIndex>$ );

          $<partIndex>$->partAttr = $<partAttr>1;
          $<partIndex>$->partIndexType =
                                    QCM_LOCAL_NONE_PREFIXED_PARTITIONED_INDEX;
      }
    ;

local_partitioned_index
    : TR_LOCAL
      {
          $<partAttr>$ = NULL;
      }
    | TR_LOCAL
        TS_OPENING_PARENTHESIS
        on_partitioned_table_list
        TS_CLOSING_PARENTHESIS
      {
          $<partAttr>$ = $<partAttr>3;
      }
    ;

on_partitioned_table_list
    : on_partitioned_table_list TS_COMMA on_partitioned_table
      {
          qdPartitionAttribute * sLast;

          for( sLast = $<partAttr>1;
               sLast->next != NULL;
               sLast = sLast->next ) ;

          sLast->next = $<partAttr>3;

          $<partAttr>$ = $<partAttr>1;
      }
    | on_partitioned_table
      {
          $<partAttr>$ = $<partAttr>1;
      }
    ;

on_partitioned_table
    : TR_PARTITION TI_IDENTIFIER TR_ON TI_IDENTIFIER opt_index_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          // index partition name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // table partition name
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<partAttr>$ = $<partAttr>5;

          SET_POSITION( $<partAttr>$->indexPartName, $<position>2 );
          SET_POSITION( $<partAttr>$->tablePartName, $<position>4 );

          $<partAttr>$->next = NULL;
      }
    ;

opt_index_part_desc
    : /* empty */
      {
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );
      }
    | TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace name
          if ($<position>2.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          SET_POSITION($<partAttr>$->TBSName, $<position>2);
      }
    ;

create_table_statement
    : TR_CREATE opt_temporary TR_TABLE user_object_name
        TS_OPENING_PARENTHESIS table_element_commalist TS_CLOSING_PARENTHESIS
        table_options opt_lob_attribute_list
      {
          qcmColumn            * sColumn;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>4->objectName);

          $<tableParseTree>$->constraints = $<tableElement>6.constraints;
          $<tableParseTree>$->columns     = $<tableElement>6.columns;
          $<tableParseTree>$->select      = NULL;

          if ($<tableParseTree>$->columns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_HAVE_NO_COLUMN));
              YYABORT;
          }

          // A column must have data type.
          for (sColumn = $<tableParseTree>$->columns;
               sColumn != NULL;
               sColumn = sColumn->next)
          {
              if (sColumn->basicInfo->module == NULL)
              {
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_NO_HAVE_DATATYPE_IN_CRT_TBL));
                  YYABORT;
              }
          }

          $<tableParseTree>$->flag = 0;

          // temporary table
          if ( $<uIntVal>2 == 1 )
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_TRUE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_FALSE;
          }

          // MAXROWS
          if ($<tableOptions>8->maxrows == NULL)
          {
              $<tableParseTree>$->maxrows = 0;
          }
          else
          {
              $<tableParseTree>$->maxrows = *($<tableOptions>8->maxrows);
          }

          /* PROJ-2359 Table/Partition Access Option */
          $<tableParseTree>$->accessOption = $<tableOptions>8->accessOption;

          // TableSpace Name
          if ($<tableOptions>8->TBSName == NULL)
          {
              SET_EMPTY_POSITION($<tableParseTree>$->TBSName);
          }
          else
          {
              SET_POSITION($<tableParseTree>$->TBSName,
                           (*($<tableOptions>8->TBSName)));
          }
          // PCTFREE
          if ($<tableOptions>8->pctFree == NULL)
          {
              $<tableParseTree>$->segAttr.mPctFree=
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctFree =
                  *($<tableOptions>8->pctFree);
          }
          // PCTUSED
          if ($<tableOptions>8->pctUsed == NULL)
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  *($<tableOptions>8->pctUsed);
          }

          // INITTRANS
          if ($<tableOptions>8->initTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  *($<tableOptions>8->initTrans);
          }
          // MAXTRANS
          if ($<tableOptions>8->maxTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  *($<tableOptions>8->maxTrans);
          }

          // PROJ-1671 Bitmap Segment
          // Segment Storage Attribute list
          if ($<tableOptions>8->segStorageAttr->initExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  *($<tableOptions>8->segStorageAttr->initExtCnt);
              $<tableParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->nextExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  *($<tableOptions>8->segStorageAttr->nextExtCnt);
              $<tableParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->minExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  *($<tableOptions>8->segStorageAttr->minExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->maxExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  *($<tableOptions>8->segStorageAttr->maxExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          // PROJ-1362
          $<tableParseTree>$->lobAttr = $<lobAttribute>9;

          // PROJ-1502 PARTITIONED DISK TABLE
          if( $<tableOptions>8->partTable != NULL )
          {
              $<tableParseTree>$->partTable = $<tableOptions>8->partTable;
              $<tableParseTree>$->isRowmovement =
                                        $<tableOptions>8->isRowmovement;
          }

          // Table Flag  Attribute List
          $<tableParseTree>$->tableAttrFlagList
              = $<tableOptions>8->tableAttrFlagList;

          // PROJ-1665
          $<tableParseTree>$->loggingMode    = $<tableOptions>8->loggingMode;
          $<tableParseTree>$->parallelDegree = $<tableOptions>8->parallelDegree;

          // PROJ-1407 Temporary Table
          $<tableParseTree>$->temporaryOption = $<tableOptions>8->temporaryOption;

          // PROJ-2264 Dictionary Table
          $<tableParseTree>$->compressionColumn = $<tableOptions>8->compressionColumn;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // TASK-7307 DML Consistency in Shard
          $<tableParseTree>$->mShardFlag = $<tableOptions>8->mShardFlag;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbCreate::validateCreateTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbCreate::executeCreateTable;
      }
    | TR_CREATE opt_temporary TR_TABLE user_object_name
        TS_OPENING_PARENTHESIS table_element_commalist TS_CLOSING_PARENTHESIS
        table_options opt_lob_attribute_list
        TR_AS select_or_with_select_statement
      {
          qcmColumn         * sColumn;
          qcStatement       * sStatement;
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>4->objectName);

          $<tableParseTree>$->constraints = $<tableElement>6.constraints;
          $<tableParseTree>$->columns     = $<tableElement>6.columns;

          if ($<tableParseTree>$->columns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_HAVE_NO_COLUMN));
              YYABORT;
          }

          // A column cannot have data type.
          for (sColumn = $<tableParseTree>$->columns;
               sColumn != NULL;
               sColumn = sColumn->next)
          {
              if (sColumn->basicInfo->module != NULL)
              {
                  IDE_SET(ideSetErrorCode(
                              qpERR_ABORT_QCP_HAVE_DATATYPE_IN_CRT_TBL_AS_SELECT));
                  YYABORT;
              }
          }

          $<tableParseTree>$->flag = 0;

          // temporary table
          if ( $<uIntVal>2 == 1 )
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_TRUE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_FALSE;
          }

          // MAXROWS
          if ($<tableOptions>8->maxrows == NULL)
          {
              $<tableParseTree>$->maxrows = 0;
          }
          else
          {
              $<tableParseTree>$->maxrows = *($<tableOptions>8->maxrows);
          }

          /* PROJ-2359 Table/Partition Access Option */
          $<tableParseTree>$->accessOption = $<tableOptions>8->accessOption;

          // TableSpace Name
          if ($<tableOptions>8->TBSName == NULL)
          {
              SET_EMPTY_POSITION($<tableParseTree>$->TBSName);
          }
          else
          {
              SET_POSITION($<tableParseTree>$->TBSName,
                           (*($<tableOptions>8->TBSName)));
          }
          // PCTFREE
          if ($<tableOptions>8->pctFree == NULL)
          {
              $<tableParseTree>$->segAttr.mPctFree=
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctFree =
                  *($<tableOptions>8->pctFree);
          }
          // PCTUSED
          if ($<tableOptions>8->pctUsed == NULL)
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  *($<tableOptions>8->pctUsed);
          }

          // INITTRANS
          if ($<tableOptions>8->initTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  *($<tableOptions>8->initTrans);
          }
          // INITTRANS
          if ($<tableOptions>8->maxTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  *($<tableOptions>8->maxTrans);
          }

          // PROJ-1671 Bitmap Segment
          // Segment Storage Attribute list
          if ($<tableOptions>8->segStorageAttr->initExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  *($<tableOptions>8->segStorageAttr->initExtCnt);
              $<tableParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->nextExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  *($<tableOptions>8->segStorageAttr->nextExtCnt);
              $<tableParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->minExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  *($<tableOptions>8->segStorageAttr->minExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          if ($<tableOptions>8->segStorageAttr->maxExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  *($<tableOptions>8->segStorageAttr->maxExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          // PROJ-1362
          $<tableParseTree>$->lobAttr = $<lobAttribute>9;

          // PROJ-1502 PARTITIONED DISK TABLE
          if( $<tableOptions>8->partTable != NULL )
          {
              $<tableParseTree>$->partTable = $<tableOptions>8->partTable;
              $<tableParseTree>$->isRowmovement =
                                        $<tableOptions>8->isRowmovement;
          }

          // Table Flag  Attribute List
          $<tableParseTree>$->tableAttrFlagList
              = $<tableOptions>8->tableAttrFlagList;

          // PROJ-1665
          $<tableParseTree>$->loggingMode    = $<tableOptions>8->loggingMode;
          $<tableParseTree>$->parallelDegree = $<tableOptions>8->parallelDegree;

          // PROJ-1407 Temporary Table
          $<tableParseTree>$->temporaryOption = $<tableOptions>8->temporaryOption;
          
          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-2264 Dictionary Table
          if ($<tableOptions>8->compressionColumn != NULL)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<tableOptions>8->compressionColumn->namePos );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_TABLE_OPTION,
                                      sqlInfo.getErrMessage()) );
              sqlInfo.fini();
              YYABORT;
          }
          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>11)
          $<tableParseTree>$->select = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          $<tableParseTree>$->common.parse    =
                                    qdbCreate::parseCreateTableAsSelect;
          $<tableParseTree>$->common.validate =
                                    qdbCreate::validateCreateTableAsSelect;
          $<tableParseTree>$->common.optimize = qdbCreate::optimize;
          $<tableParseTree>$->common.execute  =
                                    qdbCreate::executeCreateTableAsSelect;
      }
    | TR_CREATE opt_temporary TR_TABLE user_object_name table_options opt_lob_attribute_list
        TR_AS select_or_with_select_statement
      {
          qcStatement       * sStatement;
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>4->objectName);

          $<tableParseTree>$->flag = 0;

          // temporary table
          if ( $<uIntVal>2 == 1 )
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_TRUE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_FALSE;
          }

          // MAXROWS
          if ($<tableOptions>5->maxrows == NULL)
          {
              $<tableParseTree>$->maxrows = 0;
          }
          else
          {
              $<tableParseTree>$->maxrows = *($<tableOptions>5->maxrows);
          }

          /* PROJ-2359 Table/Partition Access Option */
          $<tableParseTree>$->accessOption = $<tableOptions>5->accessOption;

          // TableSpace Name
          if ($<tableOptions>5->TBSName == NULL)
          {
              SET_EMPTY_POSITION($<tableParseTree>$->TBSName);
          }
          else
          {
              SET_POSITION($<tableParseTree>$->TBSName,
                           (*($<tableOptions>5->TBSName)));
          }
          // PCTFREE
          if ($<tableOptions>5->pctFree == NULL)
          {
              $<tableParseTree>$->segAttr.mPctFree=
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctFree =
                  *($<tableOptions>5->pctFree);
          }
          // PCTUSED
          if ($<tableOptions>5->pctUsed == NULL)
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  QD_INVALID_PCT_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mPctUsed =
                  *($<tableOptions>5->pctUsed);
          }

          // INITTRANS
          if ($<tableOptions>5->initTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mInitTrans =
                  *($<tableOptions>5->initTrans);
          }
          // MAXTRANS
          if ($<tableOptions>5->maxTrans == NULL)
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
          else
          {
              $<tableParseTree>$->segAttr.mMaxTrans =
                  *($<tableOptions>5->maxTrans);
          }

          // PROJ-1671 Bitmap Segment
          // Segment Storage Attribute list
          if ($<tableOptions>5->segStorageAttr->initExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mInitExtCnt =
                  *($<tableOptions>5->segStorageAttr->initExtCnt);
              $<tableParseTree>$->existSegStoAttr.mInitExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->nextExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mNextExtCnt =
                  *($<tableOptions>5->segStorageAttr->nextExtCnt);
              $<tableParseTree>$->existSegStoAttr.mNextExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->minExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMinExtCnt =
                  *($<tableOptions>5->segStorageAttr->minExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMinExt = ID_TRUE;
          }

          if ($<tableOptions>5->segStorageAttr->maxExtCnt == NULL)
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  QD_INVALID_SEGMENT_STORAGE_VALUE;
          }
          else
          {
              $<tableParseTree>$->segStoAttr.mMaxExtCnt =
                  *($<tableOptions>5->segStorageAttr->maxExtCnt);
              $<tableParseTree>$->existSegStoAttr.mMaxExt = ID_TRUE;
          }

          // PROJ-1362
          $<tableParseTree>$->lobAttr = $<lobAttribute>6;

          // PROJ-1502 PARTITIONED DISK TABLE
          if( $<tableOptions>5->partTable != NULL )
          {
              $<tableParseTree>$->partTable = $<tableOptions>5->partTable;
              $<tableParseTree>$->isRowmovement =
                                        $<tableOptions>5->isRowmovement;
          }

          // Table Flag  Attribute List
          $<tableParseTree>$->tableAttrFlagList
              = $<tableOptions>5->tableAttrFlagList;

          // PROJ-1665
          $<tableParseTree>$->loggingMode    = $<tableOptions>5->loggingMode;
          $<tableParseTree>$->parallelDegree = $<tableOptions>5->parallelDegree;

          // PROJ-1407 Temporary Table
          $<tableParseTree>$->temporaryOption = $<tableOptions>5->temporaryOption;
          
          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // PROJ-2264 Dictionary Table
          if ($<tableOptions>5->compressionColumn != NULL)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<tableOptions>5->compressionColumn->namePos );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_TABLE_OPTION,
                                      sqlInfo.getErrMessage()) );
              sqlInfo.fini();
              YYABORT;
          }

          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>8)
          $<tableParseTree>$->select = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          $<tableParseTree>$->common.parse    =
                                    qdbCreate::parseCreateTableAsSelect;
          $<tableParseTree>$->common.validate =
                                    qdbCreate::validateCreateTableAsSelect;
          $<tableParseTree>$->common.optimize = qdbCreate::optimize;
          $<tableParseTree>$->common.execute  =
                                    qdbCreate::executeCreateTableAsSelect;
      }
    /* PROJ-2600 Online DDL for Tablespace Alteration */
    | TR_CREATE opt_temporary TR_TABLE user_object_name
        TR_FROM TR_TABLE TI_NONQUOTED_IDENTIFIER user_object_name
        using_prefix shard_flag_backup
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE( $<tableParseTree>$, $<position>1 );
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          $<tableParseTree>$->flag = 0;

          // temporary table
          if ( $<uIntVal>2 == 1 )
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_TRUE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDT_CREATE_TEMPORARY_MASK;
              $<tableParseTree>$->flag |= QDT_CREATE_TEMPORARY_FALSE;
          }

          /* set userName, tableName position : Target */
          SET_POSITION( $<tableParseTree>$->userName,  $<userNObjName>4->userName );
          SET_POSITION( $<tableParseTree>$->tableName, $<userNObjName>4->objectName );

          if ( idlOS::strMatch( "SCHEMA",
                                6,
                                QTEXT + $<position>7.offset,
                                $<position>7.size ) != 0 )
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<position>7) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              /* Nothing to do */
          }

          /* set userName, tableName position : Source */
          SET_POSITION( $<tableParseTree>$->mSourceUserName,  $<userNObjName>8->userName );
          SET_POSITION( $<tableParseTree>$->mSourceTableName, $<userNObjName>8->objectName );

          SET_POSITION( $<tableParseTree>$->mNamesPrefix, $<position>9 );

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          // TASK-7307
          $<tableParseTree>$->mShardFlag = $<shardFlag>10;

          // PROJ-1502 PARTITIONED DISK TABLE
          QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
          QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

          // set function pointer
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdbCopySwap::validateCreateTableFromTableSchema;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbCopySwap::executeCreateTableFromTableSchema;
      }
    ;

opt_temporary
    : // empty
      {
          $<uIntVal>$ = 0;
      }
    | TR_TEMPORARY
      {
          $<uIntVal>$ = 1;
      }
    | TI_NONQUOTED_IDENTIFIER TR_TEMPORARY
      {
          qcuSqlSourceInfo    sqlInfo;
          
#if defined(ALTIBASE_PRODUCT_HDB)
          if (idlOS::strMatch("GLOBAL", 6,
                  QTEXT+$<position>1.offset, $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              // Nothing to do.
          }
          
          $<uIntVal>$ = 1;
#else
          if (idlOS::strMatch("GLOBAL", 6,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              // Nothing to do.
          }
          
          $<uIntVal>$ = 1;
#endif
      }
    ;

table_options
    : temporary_option
      table_partitioning_option
      row_movement_option
      table_maxrows_option
      opt_record_access
      tablespace_name_option
      physical_attribute_option
      ttl_option
      storage_option
      table_attr_list_option
      logging_option
      parallel_option
      compression_option
      shard_flag_table_create_option
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( $<partTable>2 != NULL )
          {
              // Partitioned Table MAXROW   
              if ( $<tableMaxRows>4 != NULL )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<tableMaxRows>4->namePosition );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }
          else
          {
              // Partioned Table ƴ  Row Movement   

              if ( $<tableRowMovement>3 != NULL )
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<tableRowMovement>3->namePosition );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage() ));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          QCP_STRUCT_ALLOC($<tableOptions>$, qdTableOptions);

          // PROJ-1407 Temporary Table
          $<tableOptions>$->temporaryOption = $<temporaryOption>1;
          
          $<tableOptions>$->partTable = $<partTable>2;

          if ( $<tableRowMovement>3 != NULL )
          {
              $<tableOptions>$->isRowmovement =
                  $<tableRowMovement>3->rowMovement;
          }
          else
          {
              $<tableOptions>$->isRowmovement = ID_FALSE;
          }


          if ( $<tableMaxRows>4 != NULL )
          {
              $<tableOptions>$->maxrows = & $<tableMaxRows>4->maxRows;
          }
          else
          {
              $<tableOptions>$->maxrows = NULL;
          }

          /* PROJ-2359 Table/Partition Access Option */
          $<tableOptions>$->accessOption = $<accessOption>5;

          $<tableOptions>$->TBSName = $<positionPtr>6;

          $<tableOptions>$->pctFree = $<tablePhysicalAttr>7->pctFree;
          $<tableOptions>$->pctUsed  = $<tablePhysicalAttr>7->pctUsed;
          $<tableOptions>$->initTrans  = $<ttl>8->initTrans;
          $<tableOptions>$->maxTrans  = $<ttl>8->maxTrans;

          $<tableOptions>$->segStorageAttr  = $<attrNode>9;

          $<tableOptions>$->tableAttrFlagList = $<tableAttrFlagList>10;

          $<tableOptions>$->loggingMode = $<loggingMode>11;
          $<tableOptions>$->parallelDegree = $<uIntVal>12;

          // PROJ-2264 Dictionary table
          $<tableOptions>$->compressionColumn = $<compressionColumn>13;

          /* TASK-7307 DML Consistency in Shard */
          $<tableOptions>$->mShardFlag = $<shardFlag>14;
      }
    ;

temporary_option
    : // empty
      {
          $<temporaryOption>$ = NULL;
      }
    | TR_ON TR_COMMIT TR_DELETE TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                "ROWS", 4,
                QTEXT+$<position>4.offset, $<position>4.size) != 0)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC($<temporaryOption>$, qdTemporaryOption);
          
          SET_POSITION( $<temporaryOption>$->temporaryPos, $<position>1 );
          $<temporaryOption>$->temporaryType = QCM_TEMPORARY_ON_COMMIT_DELETE_ROWS;
      }
    | TR_ON TR_COMMIT TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                "PRESERVE", 8,
                QTEXT+$<position>3.offset, $<position>3.size) != 0)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          if (idlOS::strMatch(
                "ROWS", 4,
                QTEXT+$<position>4.offset, $<position>4.size) != 0)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC($<temporaryOption>$, qdTemporaryOption);
          
          SET_POSITION( $<temporaryOption>$->temporaryPos, $<position>1 );
          $<temporaryOption>$->temporaryType = QCM_TEMPORARY_ON_COMMIT_PRESERVE_ROWS;
      }
    ;

logging_option
    : // empty
      {
          $<loggingMode>$ = NULL;
      }
    | logging_clause
      {
          QCP_STRUCT_ALLOC($<loggingMode>$, UInt);
          *($<loggingMode>$) = $<uIntVal>1;
      }
    ;

parallel_option
    : // empty
      {
          $<uIntVal>$ = 1;
      }
    | parallel_clause
      {
          $<uIntVal>$ = $<uIntVal>1;
      }
    ;

// PROJ-2264 Dictionary table
compression_option
    : // empty
      {
          $<compressionColumn>$ = NULL;
      }
    | TA_COMPRESS TS_OPENING_PARENTHESIS compression_column_commalist TS_CLOSING_PARENTHESIS
      {
          $<compressionColumn>$ = $<compressionColumn>3;
      }
    ;

// PROJ-2264 Dictionary table
compression_column_commalist
    : compression_column_commalist TS_COMMA compression_column_name
      {
          qcmCompressionColumn         * sLastColumn;
          qcmCompressionColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrColumn = $<compressionColumn>3;

          // BUG-36739
          $<compressionColumn>$ = $<compressionColumn>1;

          // check duplicate column name
          for( sLastColumn = $<compressionColumn>$;
               sLastColumn != NULL;
               sLastColumn = sLastColumn->next)
          {
              if (idlOS::strMatch(
                      QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                      QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          // connect
          sLastColumn = $<compressionColumn>$;
          while (sLastColumn->next != NULL)
          {
              sLastColumn = sLastColumn->next;
          }
          sLastColumn->next = sCurrColumn;
      }
    | compression_column_name
      {
          $<compressionColumn>$ = $<compressionColumn>1;
      }
    ;

// PROJ-2264 Dictionary table
compression_column_name
    : column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<compressionColumn>$, qcmCompressionColumn);
          QCM_COMPRESSION_COLUMN_INIT( $<compressionColumn>$ );

          SET_POSITION($<compressionColumn>$->namePos, $<position>1);
      }
    | column_name TA_MAXROWS TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sMaxRows = 0;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<compressionColumn>$, qcmCompressionColumn);
          QCM_COMPRESSION_COLUMN_INIT( $<compressionColumn>$ );

          SET_POSITION($<compressionColumn>$->namePos, $<position>1);

          // MAXROWS
          if( qtc::getBigint( QTEXT, &sMaxRows, &$<position>3 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          $<compressionColumn>$->maxrows = sMaxRows;
      }
    ;

table_attr_list_option
   :
     {
         $<tableAttrFlagList>$ = NULL;
     }
   | table_attr_list
     {
         $<tableAttrFlagList>$ = $<tableAttrFlagList>1;
     }
   ;

table_attr_list
   : table_attr_list table_attr_clause
     {
          qdTableAttrFlagList * sLast;

          $<tableAttrFlagList>$ = $<tableAttrFlagList>1;
          for (sLast = $<tableAttrFlagList>$;
               sLast->next != NULL;
               sLast = sLast->next)
              ;
          sLast->next = $<tableAttrFlagList>2;
     }
   | table_attr_clause
     {
         $<tableAttrFlagList>$ = $<tableAttrFlagList>1;
     }
   ;

/*
   Disk/Memory/Volatile/Temp װ ̺ ο
    Ǵ Attribute

   ⿡ ϸ Disk/Memory/Volatile/Temp Tablespace
   Create Table Alter Table ڵ ȴ.
 */
table_attr_clause
   : table_log_compression_clause
     {
         $<tableAttrFlagList>$ = $<tableAttrFlagList>1;
      }
   ;

table_log_compression_clause
   : TR_COMPRESSED TR_LOGGING
     {
         QCP_STRUCT_ALLOC($<tableAttrFlagList>$, qdTableAttrFlagList);

         $<tableAttrFlagList>$->next = NULL;

         $<tableAttrFlagList>$->attrPosition = $<position>2;

         $<tableAttrFlagList>$->attrMask  = SMI_TABLE_LOG_COMPRESS_MASK;
         $<tableAttrFlagList>$->attrValue = SMI_TABLE_LOG_COMPRESS_TRUE;
     }
   | TR_UNCOMPRESSED TR_LOGGING
     {
         QCP_STRUCT_ALLOC($<tableAttrFlagList>$, qdTableAttrFlagList);

         $<tableAttrFlagList>$->next = NULL;

         $<tableAttrFlagList>$->attrPosition = $<position>2;

         $<tableAttrFlagList>$->attrMask  = SMI_TABLE_LOG_COMPRESS_MASK;
         $<tableAttrFlagList>$->attrValue = SMI_TABLE_LOG_COMPRESS_FALSE;
     }
   ;

table_maxrows_option
  :
    {
        $<tableMaxRows>$ = NULL;
    }
  | table_maxrows
    {
        $<tableMaxRows>$ = $<tableMaxRows>1;
    }
  ;


table_partitioning_option
  :
    {
        $<partTable>$ = NULL;
    }
  | table_partitioning_clause
    {
        $<partTable>$ = $<partTable>1 ;
    }
  ;

/* PROJ-1502 PARTITIONED DISK TABLE */
table_partitioning_clause
    : TR_PARTITION TR_BY TI_NONQUOTED_IDENTIFIER
      TS_OPENING_PARENTHESIS
        column_commalist
      TS_CLOSING_PARENTHESIS
      TS_OPENING_PARENTHESIS
        part_attr_list
      TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<partTable>$, qdPartitionedTable );
          // qdPartitionedTable ʱȭ
          QD_SET_INIT_PART_TABLE( $<partTable>$ );

          if( idlOS::strMatch( "RANGE",
                                5,
                                QTEXT+$<position>3.offset,
                                $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_RANGE;
              $<partTable>$->partInfoList = NULL;

              qdPartitionAttribute * sLast = NULL;
              UInt                   sTotalPartCnt = 0;
              UInt                   sDefPartCnt = 0;
              qmmValueNode  * sKey    = NULL;
              qcmColumn     * sColumn = NULL;
              UInt sColumnCount = 0;
              UInt sMaxCount    = 0;
              // BUG-47599
              qdPartitionAttribute * sLastPart = NULL;

              for ( sColumn = $<partTable>$->partKeyColumns;
                    sColumn != NULL;
                    sColumn = sColumn->next, sColumnCount++ );

              for( sLast = $<partAttr>8;
                   sLast != NULL;
                   sLast = sLast->next )
              {
                  if( ( sLast->partValuesType == QD_HASH_VALUES_TYPE ) ||
                      ( sLast->partValuesType == QD_LIST_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }
                  else
                  {
                      // BUG-43042
                      sMaxCount = 0;
                      sKey = sLast->partKeyCond;

                      while( sKey != NULL )
                      {
                          if ( idlOS::strMatch( "MAXVALUE",
                                                8,
                                                QTEXT + sKey->value->position.offset,
                                                sKey->value->position.size ) == 0 )
                          {
                              sMaxCount++;
                          }
                          else
                          {
                              // Nothing to do.
                          }

                          sKey = sKey->next;
                      }

                      if ( sMaxCount > 0 )
                      {
                          if ( sMaxCount == sColumnCount )
                          {
                              sLast->partValuesType = QD_DEFAULT_VALUES_TYPE;
                              sLast->partKeyCond = NULL;
                          }
                          else
                          {

                              sqlInfo.setSourceInfo( STATEMENT, &sLast->partKeyCond->value->position );
                              sqlInfo.init( MEMORY );
                              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                        sqlInfo.getErrMessage() ) );
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                      else
                      {
                          // Nothing to do.
                      }
                  }

                  if( sLast->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  // BUG-47599 list   empty partition ġϵѴ.
                  if ( sLast->next == NULL )
                  {
                      sLastPart = sLast;
                  }

                  sTotalPartCnt++;
              }

              if( sDefPartCnt > 1 )
              {
                  IDE_SET(ideSetErrorCode(
                              qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, ""));
                  YYABORT;
              }
              else
              {
                  // BUG-47599 empty partition  
                  if ( sDefPartCnt == 0 )
                  {
                      qdPartitionAttribute   * sEmpPartAttr;
                      qcNamePosition           sEmpPartNamePos;

                      QCP_STRUCT_ALLOC( sEmpPartAttr, qdPartitionAttribute );
                      // qdPartitionAttribute ʱȭ
                      QD_SET_INIT_PARTITION_ATTR( sEmpPartAttr );

                      sEmpPartNamePos.stmtText = (SChar*)QD_EMPTY_PARTITION_NAME;
                      sEmpPartNamePos.offset = 0;
                      sEmpPartNamePos.size = QD_EMPTY_PARTITION_NAME_SIZE;
                      SET_POSITION( sEmpPartAttr->tablePartName, sEmpPartNamePos );

                      sEmpPartAttr->partValuesType = QD_DEFAULT_VALUES_TYPE;

                      sLastPart->next = sEmpPartAttr;
                      sTotalPartCnt++;
                  }
                  else
                  {
                      // default partition ִ 
                      // Noting to do.
                  }
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else if( idlOS::strMatch( "HASH",
                                    4,
                                    QTEXT+$<position>3.offset,
                                    $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_HASH;
              $<partTable>$->partInfoList = NULL;

              qdPartitionAttribute * sLast;
              UInt                   sTotalPartCnt = 0;

              for( sLast = $<partAttr>8;
                   sLast != NULL;
                   sLast = sLast->next )
              {
                  if( ( sLast->partValuesType == QD_RANGE_VALUES_TYPE ) ||
                      ( sLast->partValuesType == QD_LIST_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  if( sLast->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      IDE_SET(ideSetErrorCode(
                                  qpERR_ABORT_QDB_INVALID_DEFAULT_PART_COUNT_IN_HASH_PART_TABLE, ""));
                      YYABORT;
                  }

                  sTotalPartCnt++;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else if( idlOS::strMatch( "LIST",
                                    4,
                                    QTEXT+$<position>3.offset,
                                    $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_LIST;
              $<partTable>$->partInfoList = NULL;

              qdPartitionAttribute * sLast;
              UInt                   sTotalPartCnt = 0;
              UInt                   sDefPartCnt = 0;

              for( sLast = $<partAttr>8;
                   sLast != NULL;
                   sLast = sLast->next )
              {
                  if( ( sLast->partValuesType == QD_RANGE_VALUES_TYPE ) ||
                      ( sLast->partValuesType == QD_HASH_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  if( sLast->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  sTotalPartCnt++;
              }

              if( sDefPartCnt != 1 )
              {
                  IDE_SET(ideSetErrorCode(
                              qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, ""));
                  YYABORT;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else if( idlOS::strMatch( "RANGE_USING_HASH",
                                16,
                                QTEXT+$<position>3.offset,
                                $<position>3.size ) == 0 )
          {
              $<partTable>$->partKeyColumns = $<columnDef>5;
              $<partTable>$->partAttr = $<partAttr>8;
              $<partTable>$->partMethod = QCM_PARTITION_METHOD_RANGE_USING_HASH;
              $<partTable>$->partInfoList = NULL;

              qdPartitionAttribute * sLast = NULL;
              UInt                   sTotalPartCnt = 0;
              UInt                   sDefPartCnt = 0;
              qmmValueNode  * sKey    = NULL;
              qcmColumn     * sColumn = NULL;
              UInt sColumnCount = 0;
              UInt sMaxCount    = 0;

              for ( sColumn = $<partTable>$->partKeyColumns;
                    sColumn != NULL;
                    sColumn = sColumn->next, sColumnCount++ );

              for( sLast = $<partAttr>8;
                   sLast != NULL;
                   sLast = sLast->next )
              {
                  if( ( sLast->partValuesType == QD_HASH_VALUES_TYPE ) ||
                      ( sLast->partValuesType == QD_LIST_VALUES_TYPE ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }
                  else
                  {
                      // BUG-43042
                      sMaxCount = 0;
                      sKey = sLast->partKeyCond;

                      while( sKey != NULL )
                      {
                          if ( idlOS::strMatch( "MAXVALUE",
                                                8,
                                                QTEXT + sKey->value->position.offset,
                                                sKey->value->position.size ) == 0 )
                          {
                              sMaxCount++;
                          }
                          else
                          {
                              // Nothing to do.
                          }

                          sKey = sKey->next;
                      }

                      if ( sMaxCount > 0 )
                      {
                          if ( sMaxCount == sColumnCount )
                          {
                              sLast->partValuesType = QD_DEFAULT_VALUES_TYPE;
                              sLast->partKeyCond = NULL;
                          }
                          else
                          {

                              sqlInfo.setSourceInfo( STATEMENT, &sLast->partKeyCond->value->position );
                              sqlInfo.init( MEMORY );
                              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                        sqlInfo.getErrMessage() ) );
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                      else
                      {
                          // Nothing to do.
                      }
                  }

                  if( sLast->partValuesType == QD_DEFAULT_VALUES_TYPE )
                  {
                      sDefPartCnt++;
                  }

                  sTotalPartCnt++;
              }

              if( sDefPartCnt != 1 )
              {
                  IDE_SET(ideSetErrorCode(
                              qpERR_ABORT_QDB_INVALID_DEFAULT_PARTITION_COUNT, ""));
                  YYABORT;
              }

              $<partTable>$->partCount = sTotalPartCnt;
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

/* PROJ-1502 PARTITIONED DISK TABLE */
part_attr_list
    : part_attr_list TS_COMMA part_attr
      {
          qdPartitionAttribute * sLastPart;
          $<partAttr>$ = $<partAttr>1;

          for( sLastPart = $<partAttr>$;
               sLastPart->next != NULL;
               sLastPart = sLastPart->next )
          ;

          sLastPart->next = $<partAttr>3;
      }
    | part_attr
      {
          $<partAttr>$ = $<partAttr>1;
          $<partAttr>$->partOrder = QDB_NO_PARTITION_ORDER;
          SET_EMPTY_POSITION( $<partAttr>$->indexPartName );
          $<partAttr>$->tablePartNameStr = NULL;
          $<partAttr>$->indexPartNameStr = NULL;
      }
    ;

/* PROJ-1502 PARTITIONED DISK TABLE */
part_attr
    /* Range Partition */
    : TR_PARTITION TI_IDENTIFIER
      TR_VALUES TR_LESS TR_THAN
      TS_OPENING_PARENTHESIS
        part_key_cond_list
      TS_CLOSING_PARENTHESIS
        opt_table_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>9;
          $<partAttr>$->partKeyCond = $<valueNode>7;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
          $<partAttr>$->partValuesType = QD_RANGE_VALUES_TYPE;
      }
    /* Hash Partition */
    | TR_PARTITION TI_IDENTIFIER
        opt_table_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>3;
          $<partAttr>$->partKeyCond = NULL;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
          $<partAttr>$->partValuesType = QD_HASH_VALUES_TYPE;
      }
    /* List Partition */
    | TR_PARTITION TI_IDENTIFIER
      TR_VALUES
      TS_OPENING_PARENTHESIS
        part_key_cond_list
      TS_CLOSING_PARENTHESIS
        opt_table_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>7;
          $<partAttr>$->partKeyCond = $<valueNode>5;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
          $<partAttr>$->partValuesType = QD_LIST_VALUES_TYPE;
      }
    /* Default Partition */
    | TR_PARTITION TI_IDENTIFIER TR_VALUES TR_DEFAULT opt_table_part_desc
      {
          qcuSqlSourceInfo    sqlInfo;

          $<partAttr>$ = $<partAttr>5;
          $<partAttr>$->partKeyCond = NULL;
          $<partAttr>$->next = NULL;

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );
          $<partAttr>$->partValuesType = QD_DEFAULT_VALUES_TYPE;
      }
    ;

/* PROJ-2359 Table/Partition Access Option */
opt_record_access
    : /* empty */
      {
          $<accessOption>$ = QCM_ACCESS_OPTION_NONE;
      }
    | record_access
      {
          $<accessOption>$ = $<accessOption>1;
      }
    ;

record_access
    : TR_READ TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "ONLY",
                                4,
                                QTEXT+$<position>2.offset,
                                $<position>2.size ) == 0 )
          {
              $<accessOption>$ = QCM_ACCESS_OPTION_READ_ONLY;
          }
          else if ( idlOS::strMatch( "APPEND",
                                     6,
                                     QTEXT+$<position>2.offset,
                                     $<position>2.size ) == 0 )
          {
              $<accessOption>$ = QCM_ACCESS_OPTION_READ_APPEND;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    | TR_READ TR_WRITE
      {
          $<accessOption>$ = QCM_ACCESS_OPTION_READ_WRITE;
      }
    ;

shard_flag_table_create_option
    : /* empty */
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_NONE;
      }
    | TA_SHARD TR_BACKUP
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_BACKUP;
      }
    | TA_SHARD TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "META",
                                4,
                                QTEXT+$<position>2.offset,
                                $<position>2.size ) == 0 )
          {
              $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_META;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

shard_flag_backup
    : /* empty */
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_NONE;
      }
    | TA_SHARD TR_BACKUP
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_BACKUP;
      }
    ;

shard_flag_table_alter_option
    : TA_SHARD TR_BACKUP
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_BACKUP;
      }
    | TA_SHARD TR_SPLIT
      {
          $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_SPLIT;
      }
    | TA_SHARD TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "CLONE",
                                     5,
                                     QTEXT+$<position>2.offset,
                                     $<position>2.size ) == 0 )
          {
              $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_CLONE;
          }
          else if ( idlOS::strMatch( "SOLO",
                                     4,
                                     QTEXT+$<position>2.offset,
                                     $<position>2.size ) == 0 )
          {
              $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_SOLO;
          }
          else if ( idlOS::strMatch( "NONE",
                                     4,
                                     QTEXT+$<position>2.offset,
                                     $<position>2.size ) == 0 )
          {
              $<shardFlag>$ = QCM_SHARD_FLAG_TABLE_NONE;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

usable_option
    : TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ( idlOS::strMatch( "USABLE",
                                6,
                                QTEXT+$<position>1.offset,
                                $<position>1.size ) == 0 )
          {
              $<boolType>$ = ID_TRUE;
          }
          else if ( idlOS::strMatch( "UNUSABLE",
                                     8,
                                     QTEXT+$<position>1.offset,
                                     $<position>1.size ) == 0 )
          {
              $<boolType>$ = ID_FALSE;
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

part_key_cond_list
    : part_key_cond_list TS_COMMA part_key_cond
      {
          qmmValueNode  * sLastValueNode;

          for( sLastValueNode = $<valueNode>1;
               sLastValueNode->next != NULL;
               sLastValueNode = sLastValueNode->next )
          ;

          sLastValueNode->next = $<valueNode>3;

          $<valueNode>$ = $<valueNode>1;
      }
    | part_key_cond
      {
          $<valueNode>$ = $<valueNode>1;
      }
    ;

part_key_cond
    : arithmetic_expression
      {
          QCP_STRUCT_ALLOC($<valueNode>$, qmmValueNode);
          $<valueNode>$->value    = $<expression>1[0];
          $<valueNode>$->validate = ID_TRUE;
          $<valueNode>$->timestamp = ID_FALSE;
          $<valueNode>$->expand    = ID_FALSE;
          $<valueNode>$->msgID     = ID_FALSE;
          $<valueNode>$->next     = NULL;
      }
    ;

/* PROJ-1502 PARTITIONED DISK TABLE */
opt_table_part_desc
    : tablespace_name_option opt_lob_attribute_list opt_record_access
      {
          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          if ( $<positionPtr>1 != NULL )
          {
              SET_POSITION( $<partAttr>$->TBSName, *($<positionPtr>1) );
          }
          else
          {
              SET_EMPTY_POSITION( $<partAttr>$->TBSName );
          }
          $<partAttr>$->lobAttr = $<lobAttribute>2;

          /* PROJ-2359 Table/Partition Access Option */
          $<partAttr>$->accessOption = $<accessOption>3;
      }
    ;

/* PROJ-1502 PARTITIONED DISK TABLE */
row_movement_option
    : /* empty */
      {
          $<tableRowMovement>$ = NULL;
      }
    | TR_ENABLE TR_ROW TR_MOVEMENT
      {
          QCP_STRUCT_ALLOC( $<tableRowMovement>$, qdTableRowMovement);

          $<tableRowMovement>$->namePosition = $<position>1;
          $<tableRowMovement>$->rowMovement = ID_TRUE ;
      }
    | TR_DISABLE TR_ROW TR_MOVEMENT
      {
          QCP_STRUCT_ALLOC( $<tableRowMovement>$, qdTableRowMovement);

          $<tableRowMovement>$->namePosition = $<position>1;
          $<tableRowMovement>$->rowMovement = ID_FALSE ;
      }
    ;


tablespace_name_option
    :
      {
          $<positionPtr>$ = NULL;
      }
    | TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace
          if ($<position>2.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<positionPtr>$, qcNamePosition );

          *$<positionPtr>$ = $<position>2;
      }
  ;


physical_attribute_option
  : {
        QCP_STRUCT_ALLOC($<tablePhysicalAttr>$, qdTablePhysicalAttr);
        $<tablePhysicalAttr>$->pctFree = NULL;
        $<tablePhysicalAttr>$->pctUsed = NULL;
    }
  | physical_attribute_clause
    {
        $<tablePhysicalAttr>$ = $<tablePhysicalAttr>1;
    }
  | physical_attribute_clause physical_attribute_clause
    {
        qcuSqlSourceInfo    sqlInfo;

        if ( ( ( $<tablePhysicalAttr>1->pctFree != NULL) &&
               ( $<tablePhysicalAttr>2->pctFree != NULL) ) ||
             ( ( $<tablePhysicalAttr>1->pctUsed != NULL ) &&
               ( $<tablePhysicalAttr>2->pctUsed != NULL ) ) )
        {
            // PCTFREE  ι ų
            // PCTUSED ι  
            sqlInfo.setSourceInfo(STATEMENT,
                                  $<tablePhysicalAttr>$->freeUsedIdentPosition );
            sqlInfo.init(MEMORY);

            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        // PCTFREE, PCTUSED 
        if ( $<tablePhysicalAttr>1->pctFree == NULL )
        {
            $<tablePhysicalAttr>1->pctFree =
                $<tablePhysicalAttr>2->pctFree ;
        }

        if ( $<tablePhysicalAttr>1->pctUsed == NULL )
        {
            $<tablePhysicalAttr>1->pctUsed =
                $<tablePhysicalAttr>2->pctUsed ;
        }

        $<tablePhysicalAttr>$ = $<tablePhysicalAttr>1;
    }
  ;

physical_attribute_clause
    : TI_NONQUOTED_IDENTIFIER TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                "PCTFREE", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<tablePhysicalAttr>$, qdTablePhysicalAttr);
              QCP_STRUCT_ALLOC($<tablePhysicalAttr>$->pctFree, UInt);
              *$<tablePhysicalAttr>$->pctFree    = sValue;
              $<tablePhysicalAttr>$->pctUsed      = NULL;

              $<tablePhysicalAttr>$->freeUsedIdentPosition = & $<position>1;
          }
          else if (idlOS::strMatch(
                "PCTUSED", 7,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              SLong sValue;
              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              QCP_STRUCT_ALLOC($<tablePhysicalAttr>$, qdTablePhysicalAttr);
              $<tablePhysicalAttr>$->pctFree      = NULL;
              QCP_STRUCT_ALLOC($<tablePhysicalAttr>$->pctUsed, UInt);
              *$<tablePhysicalAttr>$->pctUsed      = sValue;

              $<tablePhysicalAttr>$->freeUsedIdentPosition = & $<position>1;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);

              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

ttl_option
  : {
        QCP_STRUCT_ALLOC($<ttl>$, qdTTL);
        $<ttl>$->initTrans = NULL;
        $<ttl>$->maxTrans = NULL;
    }
  | ttl_clause
    {
        $<ttl>$ = $<ttl>1;
    }
  ;

ttl_clause
  : ttl_element
    {
        $<ttl>$ = $<ttl>1;
    }
  | ttl_element ttl_element
    {
        qcuSqlSourceInfo    sqlInfo;

        if ( ( ( $<ttl>1->initTrans != NULL) &&
               ( $<ttl>2->initTrans != NULL) ) ||
             ( ( $<ttl>1->maxTrans != NULL ) &&
               ( $<ttl>2->maxTrans != NULL ) ) )
        {
            sqlInfo.setSourceInfo(STATEMENT,
                                  $<ttl>$->identPosition );
            sqlInfo.init(MEMORY);

            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }

        // INITTRANS MAXTRANS  ù° TTL 
        if ( $<ttl>1->initTrans == NULL )
        {
            $<ttl>1->initTrans =
                $<ttl>2->initTrans ;
        }

        if ( $<ttl>1->maxTrans == NULL )
        {
            $<ttl>1->maxTrans =
                $<ttl>2->maxTrans ;
        }

        $<ttl>$ = $<ttl>1;
    }
  ;

ttl_element
    : TR_INITRANS TL_INTEGER
      {
          SLong sValue;
          if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<ttl>$, qdTTL);
          QCP_STRUCT_ALLOC($<ttl>$->initTrans, UInt);
          *$<ttl>$->initTrans    = sValue;
          $<ttl>$->maxTrans      = NULL;

          $<ttl>$->identPosition = & $<position>1;
      }
    | TR_MAXTRANS TL_INTEGER
      {
          SLong sValue;
          if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<ttl>$, qdTTL);
          QCP_STRUCT_ALLOC($<ttl>$->maxTrans, UInt);
          *$<ttl>$->maxTrans    = sValue;
          $<ttl>$->initTrans      = NULL;

          $<ttl>$->identPosition = & $<position>1;
      }
    ;

storage_option
  : /* empty */
    {
        QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
        $<attrNode>$->initExtCnt   = NULL;
        $<attrNode>$->nextExtCnt   = NULL;
        $<attrNode>$->minExtCnt    = NULL;
        $<attrNode>$->maxExtCnt    = NULL;
    }
  | storage_clause
    {
        $<attrNode>$ = $<attrNode>1;
    }
  ;

storage_clause
    : TO_STORAGE TS_OPENING_PARENTHESIS
      segment_storage_attr_list
      TS_CLOSING_PARENTHESIS
      {

          qcuSqlSourceInfo    sqlInfo;
          qdSegStorageAttr  * segStorageAttr;
          idBool              isError;

          QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
          $<attrNode>$->initExtCnt   = NULL;
          $<attrNode>$->nextExtCnt   = NULL;
          $<attrNode>$->minExtCnt    = NULL;
          $<attrNode>$->maxExtCnt    = NULL;
          isError                    = ID_FALSE;

          for(segStorageAttr = $<attrNode>3;
              segStorageAttr != NULL;
              segStorageAttr = segStorageAttr->next)
          {
              if ( segStorageAttr->initExtCnt != NULL )
              {
                 if ( $<attrNode>$->initExtCnt == NULL )
                 {
                     QCP_STRUCT_ALLOC($<attrNode>$->initExtCnt, UInt);
                     *$<attrNode>$->initExtCnt = *segStorageAttr->initExtCnt;
                 }
                 else
                 {
                     isError = ID_TRUE;
                     break;
                 }
              }

              if ( segStorageAttr->nextExtCnt != NULL )
              {
                 if ( $<attrNode>$->nextExtCnt == NULL )
                 {
                     QCP_STRUCT_ALLOC($<attrNode>$->nextExtCnt, UInt);
                     *$<attrNode>$->nextExtCnt = *segStorageAttr->nextExtCnt;
                 }
                 else
                 {
                     isError = ID_TRUE;
                     break;
                 }
              }

              if ( segStorageAttr->minExtCnt != NULL )
              {
                 if ( $<attrNode>$->minExtCnt == NULL )
                 {
                     QCP_STRUCT_ALLOC($<attrNode>$->minExtCnt, UInt);
                     *$<attrNode>$->minExtCnt = *segStorageAttr->minExtCnt;
                 }
                 else
                 {
                     isError = ID_TRUE;
                     break;
                 }
              }

              if ( segStorageAttr->maxExtCnt != NULL )
              {
                 if ( $<attrNode>$->maxExtCnt == NULL )
                 {
                     QCP_STRUCT_ALLOC($<attrNode>$->maxExtCnt, UInt);
                     *$<attrNode>$->maxExtCnt = *segStorageAttr->maxExtCnt;
                 }
                 else
                 {
                     isError = ID_TRUE;
                     break;
                 }
              }
          }

          if ( isError == ID_TRUE )
          {
             sqlInfo.setSourceInfo(STATEMENT, &segStorageAttr->attrPosition );
             sqlInfo.init(MEMORY);
             IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
             sqlInfo.fini();
             YYABORT;
          }


          if ( ($<attrNode>$->initExtCnt == NULL) &&
               ($<attrNode>$->nextExtCnt == NULL) &&
               ($<attrNode>$->minExtCnt  == NULL) &&
               ($<attrNode>$->maxExtCnt  == NULL) )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
      }
    ;

segment_storage_attr_list
    : segment_storage_attr_list segment_storage_attr
      {
          qdSegStorageAttr * sLastAttr;

          $<attrNode>$ = $<attrNode>1;

          for( sLastAttr = $<attrNode>$;
               sLastAttr->next != NULL;
               sLastAttr = sLastAttr->next )
          ;

          sLastAttr->next = $<attrNode>2;
      }
    | segment_storage_attr
      {
          $<attrNode>$ = $<attrNode>1;
      }
    ;

segment_storage_attr
    : TI_NONQUOTED_IDENTIFIER TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sValue;

          if (idlOS::strMatch("INITEXTENTS", 11,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
              QCP_STRUCT_ALLOC($<attrNode>$->initExtCnt, UInt);

              if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
              {
                  YYABORT;
              }
              *$<attrNode>$->initExtCnt  = (UInt)sValue;
              $<attrNode>$->nextExtCnt   = NULL;
              $<attrNode>$->minExtCnt    = NULL;
              $<attrNode>$->maxExtCnt    = NULL;
              $<attrNode>$->next         = NULL;
              $<attrNode>$->attrPosition = $<position>1;
          }
          else
          {
              if (idlOS::strMatch("NEXTEXTENTS", 11,
                      QTEXT+$<position>1.offset, $<position>1.size) == 0)
              {
                  QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
                  QCP_STRUCT_ALLOC($<attrNode>$->nextExtCnt, UInt);

                  if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
                  {
                      YYABORT;
                  }
                  $<attrNode>$->initExtCnt   = NULL;
                  *$<attrNode>$->nextExtCnt  = (UInt)sValue;
                  $<attrNode>$->minExtCnt    = NULL;
                  $<attrNode>$->maxExtCnt    = NULL;
                  $<attrNode>$->next         = NULL;
                  $<attrNode>$->attrPosition = $<position>1;
              }
              else
              {
                  if (idlOS::strMatch("MINEXTENTS", 10,
                          QTEXT+$<position>1.offset, $<position>1.size) == 0)
                  {
                      QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
                      QCP_STRUCT_ALLOC($<attrNode>$->minExtCnt, UInt);

                      if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
                      {
                          YYABORT;
                      }
                      $<attrNode>$->initExtCnt   = NULL;
                      $<attrNode>$->nextExtCnt   = NULL;
                      *$<attrNode>$->minExtCnt   = (UInt)sValue;
                      $<attrNode>$->maxExtCnt    = NULL;
                      $<attrNode>$->next         = NULL;
                      $<attrNode>$->attrPosition = $<position>1;
                  }
                  else
                  {
                      if (idlOS::strMatch("MAXEXTENTS", 10,
                              QTEXT+$<position>1.offset, $<position>1.size) == 0)
                      {
                          QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
                          QCP_STRUCT_ALLOC($<attrNode>$->maxExtCnt, UInt);

                          if( qtc::getBigint( QTEXT, &sValue, &$<position>2 ) != IDE_SUCCESS )
                          {
                              YYABORT;
                          }
                          $<attrNode>$->initExtCnt   = NULL;
                          $<attrNode>$->nextExtCnt   = NULL;
                          $<attrNode>$->minExtCnt    = NULL;
                          *$<attrNode>$->maxExtCnt   = (UInt)sValue;
                          $<attrNode>$->next         = NULL;
                          $<attrNode>$->attrPosition = $<position>1;
                      }
                      else
                      {
                          // syntax error
                          sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                          sqlInfo.init(MEMORY);
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
                          sqlInfo.fini();
                          YYABORT;
                      }
                  }
              }
          }
      }
    | TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          // maxextents unlimited
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch("MAXEXTENTS", 10,
                              QTEXT+$<position>1.offset, $<position>1.size) != 0 )
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          if ( idlOS::strMatch("UNLIMITED", 9,
                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
          {
              // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<attrNode>$, qdSegStorageAttr);
          QCP_STRUCT_ALLOC($<attrNode>$->maxExtCnt, UInt);
          $<attrNode>$->initExtCnt   = NULL;
          $<attrNode>$->nextExtCnt   = NULL;
          $<attrNode>$->minExtCnt    = NULL;
          *$<attrNode>$->maxExtCnt   = ID_UINT_MAX;
          $<attrNode>$->next         = NULL;
      }
    ;

opt_partition_lob_attr_list
    : /* empty */
      {
          $<partAttr>$ = NULL;
      }
    | TS_OPENING_PARENTHESIS
      partition_lob_attr_list
      TS_CLOSING_PARENTHESIS
      {
          $<partAttr>$ = $<partAttr>2;
      }
    ;

partition_lob_attr_list
    : partition_lob_attr_list TS_COMMA partition_lob_attr
      {
          qdPartitionAttribute * sLastPart;
          $<partAttr>$ = $<partAttr>1;

          for( sLastPart = $<partAttr>$;
               sLastPart->next != NULL;
               sLastPart = sLastPart->next )
          ;

          sLastPart->next = $<partAttr>3;
      }
    | partition_lob_attr
      {
          $<partAttr>$ = $<partAttr>1;
      }
    ;

partition_lob_attr
    : TR_PARTITION
      TI_IDENTIFIER
      lob_attribute_list
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<partAttr>$, qdPartitionAttribute );
          // qdPartitionAttribute ʱȭ
          QD_SET_INIT_PARTITION_ATTR( $<partAttr>$ );

          // object name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION( $<partAttr>$->tablePartName, $<position>2 );

          $<partAttr>$->lobAttr = $<lobAttribute>3;
      }
    ;

opt_lob_attribute_list
    : /* empty */
      {
          $<lobAttribute>$ = NULL;
      }
    | lob_attribute_list
      {
          $<lobAttribute>$ = $<lobAttribute>1;
      }
    ;

lob_attribute_list
    : lob_attribute_list lob_attribute_element
      {
          qdLobAttribute    * sLastLobAttr;
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          if ($<lobAttribute>1 != NULL)
          {
              for (sLastLobAttr = $<lobAttribute>1;
                   sLastLobAttr != NULL;
                   sLastLobAttr = sLastLobAttr->next)
              {
                  if ($<lobAttribute>2->columns == NULL)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,""));
                      YYABORT;
                  }

                  for (sCurrColumn = $<lobAttribute>2->columns;
                       sCurrColumn != NULL;
                       sCurrColumn = sCurrColumn->next)
                  {
                      if (sLastLobAttr->columns == NULL)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,""));
                          YYABORT;
                      }

                      for (sLastColumn = sLastLobAttr->columns;
                           sLastColumn != NULL;
                           sLastColumn = sLastColumn->next)
                      {
                          if (idlOS::strMatch(
                                  QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                                  QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
                          {
                              sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                              sqlInfo.init(MEMORY);
                              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                                      sqlInfo.getErrMessage()));
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                  }

                  if (sLastLobAttr->next == NULL)
                  {
                      sLastLobAttr->next = $<lobAttribute>2;
                      break;
                  }
                  else
                  {
                      // Nothing to do.
                  }
              }

              // BUG-36739
              $<lobAttribute>$ = $<lobAttribute>1;
          }
          else
          {
              // BUG-36739
              $<lobAttribute>$ = $<lobAttribute>2;
          }
      }
    | lob_attribute_element
      {
          $<lobAttribute>$ = $<lobAttribute>1;
      }
    ;

lob_attribute_element
    : TR_LOB TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
        TR_STORE TR_AS
        TS_OPENING_PARENTHESIS lob_storage_attribute_list TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<lobAttribute>$, qdLobAttribute);
          $<lobAttribute>$->columns = $<columnDef>3;
          $<lobAttribute>$->storageAttr = $<lobStorageAttribute>8;
          $<lobAttribute>$->next = NULL;
      }
    | TR_LOB TR_STORE TR_AS
        TS_OPENING_PARENTHESIS lob_storage_attribute_list TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<lobAttribute>$, qdLobAttribute);
          $<lobAttribute>$->columns = NULL;
          $<lobAttribute>$->storageAttr = $<lobStorageAttribute>5;
          $<lobAttribute>$->next = NULL;
      }
    ;

lob_storage_attribute_list
    : lob_storage_attribute_list lob_storage_attribute_element
      {
          qdLobStorageAttribute * sLast;

          if ($<lobStorageAttribute>1 != NULL)
          {
              for (sLast = $<lobStorageAttribute>1;
                   sLast != NULL;
                   sLast = sLast->next)
              {
                  if (sLast->type == $<lobStorageAttribute>2->type)
                  {
                      if (sLast->type == QD_LOB_STORAGE_ATTR_TABLESPACE)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_TABLESPACE_OPTION));
                          YYABORT;
                      }
                      else if (sLast->type == QD_LOB_STORAGE_ATTR_LOGGING)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_LOGGING_OPTION));
                          YYABORT;
                      }
                      else if (sLast->type == QD_LOB_STORAGE_ATTR_BUFFER)
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_INVALID_BUFFER_OPTION));
                          YYABORT;
                      }
                      else
                      {
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
                          YYABORT;
                      }
                  }
                  else
                  {
                      // Nothing to do.
                  }

                  if (sLast->next == NULL)
                  {
                      sLast->next = $<lobStorageAttribute>2;
                      break;
                  }
                  else
                  {
                      // Nothing to do.
                  }
              }

              // BUG-36739
              $<lobStorageAttribute>$ = $<lobStorageAttribute>1;
          }
          else
          {
              // BUG-36739
              $<lobStorageAttribute>$ = $<lobStorageAttribute>2;
          }
      }
    | lob_storage_attribute_element
      {
          $<lobStorageAttribute>$ = $<lobStorageAttribute>1;
      }
    ;

lob_storage_attribute_element
    : TA_TABLESPACE TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // tablespace name
          if ($<position>2.size > QC_MAX_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<lobStorageAttribute>$, qdLobStorageAttribute);

          $<lobStorageAttribute>$->type = QD_LOB_STORAGE_ATTR_TABLESPACE;
          SET_POSITION($<lobStorageAttribute>$->TBSName, $<position>2);
          $<lobStorageAttribute>$->logging = ID_TRUE;
          $<lobStorageAttribute>$->buffer = ID_TRUE;
          $<lobStorageAttribute>$->next = NULL;
      }
    | TR_LOGGING
      {
          QCP_STRUCT_ALLOC($<lobStorageAttribute>$, qdLobStorageAttribute);
          SET_EMPTY_POSITION($<lobStorageAttribute>$->TBSName);
          $<lobStorageAttribute>$->type = QD_LOB_STORAGE_ATTR_LOGGING;
          $<lobStorageAttribute>$->logging = ID_TRUE;
          $<lobStorageAttribute>$->buffer = ID_TRUE;
          $<lobStorageAttribute>$->next = NULL;
      }

    | TR_NOLOGGING
      {
          QCP_STRUCT_ALLOC($<lobStorageAttribute>$, qdLobStorageAttribute);
          SET_EMPTY_POSITION($<lobStorageAttribute>$->TBSName);
          $<lobStorageAttribute>$->type = QD_LOB_STORAGE_ATTR_LOGGING;
          $<lobStorageAttribute>$->logging = ID_FALSE;
          $<lobStorageAttribute>$->buffer = ID_TRUE;
          $<lobStorageAttribute>$->next = NULL;
      }

    | TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<lobStorageAttribute>$, qdLobStorageAttribute);
          SET_EMPTY_POSITION($<lobStorageAttribute>$->TBSName);
          $<lobStorageAttribute>$->buffer = ID_TRUE;
          $<lobStorageAttribute>$->next = NULL;

          if (idlOS::strMatch(
                "BUFFER", 6,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<lobStorageAttribute>$->type = QD_LOB_STORAGE_ATTR_BUFFER;
              $<lobStorageAttribute>$->buffer = ID_TRUE;
          }
          else if (idlOS::strMatch(
                "NOBUFFER", 8,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<lobStorageAttribute>$->type = QD_LOB_STORAGE_ATTR_BUFFER;
              $<lobStorageAttribute>$->buffer = ID_FALSE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

table_element_commalist
    : table_element_commalist TS_COMMA table_element
      {
          qdConstraintSpec  * sLastConstr;
          qdConstraintSpec  * sCurrConstr;
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrConstr = $<tableElement>3.constraints;
          sCurrColumn = $<tableElement>3.columns;

          // constraints
          if ($<tableElement>1.constraints == NULL)
          {
              $<tableElement>$.constraints = $<tableElement>3.constraints;
          }
          else
          {
              $<tableElement>$.constraints = $<tableElement>1.constraints;

              if (sCurrConstr != NULL)
              {
                  // check duplicate constraint name
                  for (sLastConstr = $<tableElement>$.constraints;
                       sLastConstr != NULL;
                       sLastConstr = sLastConstr->next)
                  {
                      if (QC_IS_NULL_NAME(sLastConstr->constrName) != ID_TRUE &&
                          QC_IS_NULL_NAME(sCurrConstr->constrName) != ID_TRUE)
                      {
                          if (idlOS::strMatch(
                                  QTEXT+sCurrConstr->constrName.offset, sCurrConstr->constrName.size,
                                  QTEXT+sLastConstr->constrName.offset, sLastConstr->constrName.size) == 0)
                          {
                              sqlInfo.setSourceInfo(STATEMENT, & (sLastConstr->constrName));
                              sqlInfo.init(MEMORY);
                              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_CONSTRAINT_NAME,
                                                      sqlInfo.getErrMessage()));
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                  }

                  // connect
                  sLastConstr = $<tableElement>$.constraints;
                  while (sLastConstr->next != NULL)
                  {
                      sLastConstr = sLastConstr->next;
                  }
                  sLastConstr->next = sCurrConstr;
              }
          }

          // columns
          if ($<tableElement>1.columns == NULL)
          {
              $<tableElement>$.columns = $<tableElement>3.columns;
          }
          else
          {
              $<tableElement>$.columns = $<tableElement>1.columns;

              if (sCurrColumn != NULL)
              {
                  // check duplicate column name
                  for (sLastColumn = $<tableElement>$.columns;
                       sLastColumn != NULL;
                       sLastColumn = sLastColumn->next)
                  {
                      if (idlOS::strMatch(
                              QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                              QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
                      {
                          sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                          sqlInfo.init(MEMORY);
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                                  sqlInfo.getErrMessage()));
                          sqlInfo.fini();
                          YYABORT;
                      }
                  }

                  // connect
                  sLastColumn = $<tableElement>$.columns;
                  while (sLastColumn->next != NULL)
                  {
                      sLastColumn = sLastColumn->next;
                  }
                  sLastColumn->next = sCurrColumn;
              }
          }
      }
    | table_element
      {
          $<tableElement>$ = $<tableElement>1;
      }
    ;

table_element
    : table_constraint_def
      {
          $<tableElement>$.constraints = $<constraintSpec>1;
          $<tableElement>$.columns     = NULL;
      }
    | column_def
      {
          $<tableElement>$ = $<tableElement>1;
      }
    ;

table_constraint_def
    : opt_constraint_name TR_UNIQUE
        key_column_with_opt_sort_mode_commalist       /* 3 */
        opt_index_directkey                           /* 4 */
        opt_index_pers                                /* 5 */
        constr_using_option                           /* 6 */
      {
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_UNIQUE;
          $<constraintSpec>$->constraintColumns         = $<columnDef>3;
          if ($<constraintSpec>$->constraintColumns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          /* PROJ-2433 Direct Key Index */
          $<constraintSpec>$->mDirectKeyMaxSize = $<uLongVal>4;

          $<constraintSpec>$->isPers           = $<boolType>5;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if ( $<indexAttrAndLocalIndex>6 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>6->partIndex;

              if ( $<indexAttrAndLocalIndex>6->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>6->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>6->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
      }
    // PROJ-1502 PARTITIONED DISK TABLE
    | opt_constraint_name TR_LOCALUNIQUE
        key_column_with_opt_sort_mode_commalist       /* 3 */
        opt_index_directkey                           /* 4 */
        opt_index_pers                                /* 5 */
        constr_using_option                           /* 6 */
      {
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_LOCAL_UNIQUE;
          $<constraintSpec>$->constraintColumns         = $<columnDef>3;
          if ($<constraintSpec>$->constraintColumns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
        
          /* PROJ-2433 Direct Key Index */
          $<constraintSpec>$->mDirectKeyMaxSize = $<uLongVal>4;
          
          $<constraintSpec>$->isPers           = $<boolType>5;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if ( $<indexAttrAndLocalIndex>6 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>6->partIndex;

              if ( $<indexAttrAndLocalIndex>6->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>6->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>6->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
      }
    | opt_constraint_name TR_PRIMARY TR_KEY
        key_column_with_opt_sort_mode_commalist    /* 4 */
        opt_index_directkey                        /* 5 */
        opt_index_pers                             /* 6 */
        constr_using_option                        /* 7 */
      {
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_PRIMARYKEY;
          $<constraintSpec>$->constraintColumns         = $<columnDef>4;
          if ($<constraintSpec>$->constraintColumns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          /* PROJ-2433 */
          $<constraintSpec>$->mDirectKeyMaxSize = $<uLongVal>5;

          $<constraintSpec>$->isPers           = $<boolType>6;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if( $<indexAttrAndLocalIndex>7 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>7->partIndex;

              if ( $<indexAttrAndLocalIndex>7->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>7->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>7->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>7->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>7->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }
      }
    | opt_constraint_name TR_FOREIGN TR_KEY
        TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
        references_specification opt_constraint_state
      {
          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_FOREIGN;
          $<constraintSpec>$->constraintColumns         = $<columnDef>5;
          if ($<constraintSpec>$->constraintColumns == NULL)
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          $<constraintSpec>$->referentialConstraintSpec = $<referenceSpec>7;
          $<constraintSpec>$->constrState = $<constraintState>8;
      }
    | opt_constraint_name TR_CHECK_OPENING_PARENTHESIS expression TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC( $<constraintSpec>$, qdConstraintSpec );
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION( $<constraintSpec>$->constrName, $<position>1 );
          $<constraintSpec>$->constrType = QD_CHECK;
          $<constraintSpec>$->checkCondition = $<expression>3[0];

          /* adjust expression position */
          $<constraintSpec>$->checkCondition->position.offset =
                    $<position>2.offset + $<position>2.size;
          $<constraintSpec>$->checkCondition->position.size =
                    $<position>4.offset - $<position>2.offset - $<position>2.size;

          /* make constraint column */
          QCP_TEST( qcpUtil::makeConstraintColumnsFromExpression(
                                STATEMENT,
                                &($<constraintSpec>$->constraintColumns),
                                $<constraintSpec>$->checkCondition )
                    != IDE_SUCCESS );
      }
    ;

opt_constraint_name
    : /* empty */
      {
          SET_EMPTY_POSITION($<position>$);
      }
    | TR_CONSTRAINT TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          // table name
          if ($<position>2.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<position>$ = $<position>2;
      }
    ;

column_def_commalist_or_table_constraint_def
    : column_def_commalist
      {
          $<tableElement>$ = $<tableElement>1;
      }
    | table_constraint_def
      {
          $<tableElement>$.constraints = $<constraintSpec>1;
          $<tableElement>$.columns     = NULL;
      }
    ;

column_def_commalist
    : column_def_commalist TS_COMMA column_def
      {
          qdConstraintSpec  * sLastConstr;
          qdConstraintSpec  * sCurrConstr;
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrConstr = $<tableElement>3.constraints;
          sCurrColumn = $<tableElement>3.columns;

          // constraints
          if (sCurrConstr != NULL)
          {
              if ($<tableElement>1.constraints == NULL)
              {
                  $<tableElement>$.constraints = $<tableElement>3.constraints;
              }
              else
              {
                  $<tableElement>$.constraints = $<tableElement>1.constraints;

                  // check duplicate constraint name
                  for (sLastConstr = $<tableElement>$.constraints;
                       sLastConstr != NULL;
                       sLastConstr = sLastConstr->next)
                  {
                      if (QC_IS_NULL_NAME(sLastConstr->constrName) != ID_TRUE &&
                          QC_IS_NULL_NAME(sCurrConstr->constrName) != ID_TRUE)
                      {
                          if (idlOS::strMatch(
                                  QTEXT+sCurrConstr->constrName.offset, sCurrConstr->constrName.size,
                                  QTEXT+sLastConstr->constrName.offset, sLastConstr->constrName.size) == 0)
                          {
                              sqlInfo.setSourceInfo(STATEMENT, & (sLastConstr->constrName));
                              sqlInfo.init(MEMORY);
                              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_CONSTRAINT_NAME,
                                                      sqlInfo.getErrMessage()));
                              sqlInfo.fini();
                              YYABORT;
                          }
                      }
                  }

                  // connect
                  sLastConstr = $<tableElement>$.constraints;
                  while (sLastConstr->next != NULL)
                  {
                      sLastConstr = sLastConstr->next;
                  }
                  sLastConstr->next = sCurrConstr;
              }
          }

          // columns
          if ($<tableElement>1.columns == NULL)
          {
              $<tableElement>$.columns = $<tableElement>3.columns;
          }
          else
          {
              $<tableElement>$.columns = $<tableElement>1.columns;

              // check duplicate column name
              for (sLastColumn = $<tableElement>$.columns;
                   sLastColumn != NULL;
                   sLastColumn = sLastColumn->next)
              {
                  if (idlOS::strMatch(
                          QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                          QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
                  {
                      sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                      sqlInfo.init(MEMORY);
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                              sqlInfo.getErrMessage()));
                      sqlInfo.fini();
                      YYABORT;
                  }
              }

              // connect
              sLastColumn = $<tableElement>$.columns;
              while (sLastColumn->next != NULL)
              {
                  sLastColumn = sLastColumn->next;
              }
              sLastColumn->next = sCurrColumn;
          }
      }
    | column_def
      {
          $<tableElement>$ = $<tableElement>1;
      }
    ;

column_def
    : column_name opt_rule_data_type opt_variable_flag opt_in_row opt_default_clause
        opt_column_constraint_def_list
      {
          qdConstraintSpec  * sConstr;
          qdConstraintSpec  * sPrevConstr;
          qdConstraintSpec  * sLastConstr;
          idBool              sNullConstrExist    = ID_FALSE;
          idBool              sNotNullConstrExist = ID_FALSE;
          qcmColumn         * sColumn;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          $<tableElement>$.constraints = $<constraintSpec>6;

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos      = $<position>1;
          $<tableElement>$.columns->basicInfo    = $<column>2; // data type
          $<tableElement>$.columns->flag         = $<flag>3;
          $<tableElement>$.columns->inRowLength  = $<uIntVal>4;

          /* parsing ܰ谡 ƴ validation ܰ迡 ִ° Ǵ.
          if( $<column>2->module != NULL )
          {
              QCP_TEST( $<column>2->module->change( $<column>2, $<flag>3 )
                        != IDE_SUCCESS );
          }
          */

          $<tableElement>$.columns->defaultValue = $<expression>5[0];

          $<tableElement>$.columns->basicInfo->flag &=
              ~MTC_COLUMN_NOTNULL_TRUE; // initialize

          /* (1) check duplicate constraint name
           * (2) check NULL, NOT NULL conflicts
           * (3) make constraintColumns
           * (4) remove NULL constraint node
           */
          for (sPrevConstr = NULL,
               sConstr = $<constraintSpec>6;
               sConstr != NULL;
               sConstr = sConstr->next)
          {
              // check duplicate constraint name
              for (sLastConstr = sConstr->next;
                   sLastConstr != NULL;
                   sLastConstr = sLastConstr->next)
              {
                  if (QC_IS_NULL_NAME(sLastConstr->constrName) != ID_TRUE &&
                      QC_IS_NULL_NAME(sConstr->constrName) != ID_TRUE)
                  {
                      if (idlOS::strMatch(
                              QTEXT+sConstr->constrName.offset, sConstr->constrName.size,
                              QTEXT+sLastConstr->constrName.offset, sLastConstr->constrName.size) == 0)
                      {
                          sqlInfo.setSourceInfo(STATEMENT, & (sLastConstr->constrName));
                          sqlInfo.init(MEMORY);
                          IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_CONSTRAINT_NAME,
                                                  sqlInfo.getErrMessage()));
                          sqlInfo.fini();
                          YYABORT;
                      }
                  }
              }

              // check NULL, NOT NULL conflicts
              if (sConstr->constrType == QD_NOT_NULL)
              {
                  if (sNullConstrExist == ID_TRUE ||
                      sNotNullConstrExist == ID_TRUE)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_CONFLICT_NULL_CONSTRAINT));
                      YYABORT;
                  }
                  else
                  {
                      sNotNullConstrExist = ID_TRUE;
                      $<tableElement>$.columns->basicInfo->flag |=
                          MTC_COLUMN_NOTNULL_TRUE;
                  }
              }
              else if (sConstr->constrType == QD_NULL)
              {
                  if (sNullConstrExist == ID_TRUE ||
                      sNotNullConstrExist == ID_TRUE)
                  {
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_CONFLICT_NULL_CONSTRAINT));
                      YYABORT;
                  }
                  else
                  {
                      sNullConstrExist = ID_TRUE;
                  }
              }

              // make constraintColumns
              if ( sConstr->constrType == QD_CHECK ) /* PROJ-1107 Check Constraint  */
              {
                  for ( sColumn = sConstr->constraintColumns;
                        sColumn != NULL;
                        sColumn = sColumn->next )
                  {
                      /* Column Check Constraint ٸ Column Name   . */
                      if ( QC_IS_NAME_MATCHED( sColumn->namePos, $<tableElement>$.columns->namePos ) == ID_FALSE )
                      {
                          sqlInfo.setSourceInfo( STATEMENT, &(sColumn->namePos) );
                          sqlInfo.init( MEMORY );
                          IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_COLUMN_CHECK_CONSTRAINT_REFERENCE_OTHER_COLUMN,
                                                    sqlInfo.getErrMessage() ) );
                          sqlInfo.fini();
                          YYABORT;
                      }
                      else
                      {
                          /* Nothing to do */
                      }
                  }
              }
              else
              {
                  sConstr->constraintColumns->namePos =
                    $<tableElement>$.columns->namePos;
              }

              // remove NULL constraint node
              if (sConstr->constrType == QD_NULL)
              {
                  if (sPrevConstr == NULL)
                  {
                      $<tableElement>$.constraints = sConstr->next;
                  }
                  else
                  {
                      sPrevConstr->next = sConstr->next;
                  }
              }
              else
              {
                  sPrevConstr = sConstr;
              }
          } // end of for

          // make TIMESTAMP constraint
          if ( ( $<tableElement>$.columns->basicInfo->flag
                  & MTC_COLUMN_TIMESTAMP_MASK ) == MTC_COLUMN_TIMESTAMP_TRUE )
          {
              // make constraint structure
              QCP_STRUCT_ALLOC(sConstr, qdConstraintSpec);
              QD_SET_INIT_CONSTRAINT_SPEC( sConstr );

              QCP_STRUCT_ALLOC(sColumn, qcmColumn);
              QCM_COLUMN_INIT( sColumn );

              idlOS::memcpy( sColumn,
                             $<tableElement>$.columns,
                             sizeof(qcmColumn) );

              sConstr->constrType                = QD_TIMESTAMP;
              sConstr->constraintColumns         = sColumn;

              // connect
              sConstr->next = $<tableElement>$.constraints;
              $<tableElement>$.constraints = sConstr;
          }
      }
    ;

opt_variable_flag
    : /* empty */
      {
          $<flag>$ = QCM_COLUMN_TYPE_DEFAULT;
      }
    | TA_FIXED
      {
          $<flag>$ = QCM_COLUMN_TYPE_FIXED;
      }
    | TR_VARIABLE
      {
          $<flag>$ = QCM_COLUMN_TYPE_VARIABLE;
      }
    | TR_VARIABLE_LARGE
      {
          $<flag>$ = QCM_COLUMN_TYPE_VARIABLE_LARGE;
      }
    ;

opt_in_row
    : /* empty */
      {
          $<uIntVal>$ = ID_UINT_MAX;
      }
    | TR_IN TR_ROW TL_INTEGER
      {
          SLong               sNumber;
          qcuSqlSourceInfo    sqlInfo;

          if( qtc::getBigint( QTEXT, &sNumber, &$<position>3 ) != IDE_SUCCESS )
          {
              YYABORT;
          }
          else
          {
              if( sNumber < ID_UINT_MAX )
              {
                  $<uIntVal>$ = (UInt)sNumber;
              }
              else
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
          }
      }
    ;

opt_column_constraint_def_list
    : /* empty */
      {
          $<constraintSpec>$ = NULL;
      }
    | column_constraint_def_list
      {
          $<constraintSpec>$ = $<constraintSpec>1;
      }
    ;

column_constraint_def_list
    : column_constraint_def_list column_constraint
      {
          qdConstraintSpec * sLast;

          $<constraintSpec>$ = $<constraintSpec>1;
          if ($<constraintSpec>$ != NULL)
          {
              for (sLast = $<constraintSpec>$;
                   sLast->next != NULL;
                   sLast = sLast->next) ;
              sLast->next = $<constraintSpec>2;
          }
      }
    | column_constraint
      {
          $<constraintSpec>$ = $<constraintSpec>1;
      }
    ;

column_constraint
    : opt_constraint_name TR_NULL
      {
          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_NULL;

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );
      }
    | opt_constraint_name TR_NOT TR_NULL
      {
          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_NOT_NULL;

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );
      }
    | opt_constraint_name TR_CHECK_OPENING_PARENTHESIS expression TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC( $<constraintSpec>$, qdConstraintSpec );
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION( $<constraintSpec>$->constrName, $<position>1 );
          $<constraintSpec>$->constrType = QD_CHECK;
          $<constraintSpec>$->checkCondition = $<expression>3[0];

          /* adjust expression position */
          $<constraintSpec>$->checkCondition->position.offset =
                    $<position>2.offset + $<position>2.size;
          $<constraintSpec>$->checkCondition->position.size =
                    $<position>4.offset - $<position>2.offset - $<position>2.size;

          /* make constraint column */
          QCP_TEST( qcpUtil::makeConstraintColumnsFromExpression(
                                STATEMENT,
                                &($<constraintSpec>$->constraintColumns),
                                $<constraintSpec>$->checkCondition )
                    != IDE_SUCCESS );
      }
    | opt_constraint_name TR_UNIQUE
        opt_sort_mode               /* 3 */
        opt_index_directkey         /* 4 */
        opt_index_pers              /* 5 */
        constr_using_option         /* 6 */
      {
          mtcColumn        * sColumnInfo;
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_UNIQUE;

          /* PROJ-2433 */
          $<constraintSpec>$->mDirectKeyMaxSize       = $<uLongVal>4;

          $<constraintSpec>$->isPers                 = $<boolType>5;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if( $<indexAttrAndLocalIndex>6 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>6->partIndex;

              if ( $<indexAttrAndLocalIndex>6->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>6->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>6->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );

          // set sort option
          // BUG-16233
          QCP_STRUCT_CRALLOC(sColumnInfo, mtcColumn);
          sColumnInfo->column.flag = 0;
          if ($<boolType>3 == ID_FALSE) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          $<constraintSpec>$->constraintColumns->basicInfo = sColumnInfo;
      }
    // PROJ-1502 PARTITIONED DISK TABLE
    | opt_constraint_name TR_LOCALUNIQUE
        opt_sort_mode               /* 3 */
        opt_index_directkey         /* 4 */
        opt_index_pers              /* 5 */
        constr_using_option         /* 6 */
      {
          mtcColumn        * sColumnInfo;
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType       = QD_LOCAL_UNIQUE;

          /* PROJ-2433 Direct Key Index */
          $<constraintSpec>$->mDirectKeyMaxSize = $<uLongVal>4;

          $<constraintSpec>$->isPers           = $<boolType>5;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if( $<indexAttrAndLocalIndex>6 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>6->partIndex;

              if ( $<indexAttrAndLocalIndex>6->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>6->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>6->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>6->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );

          // set sort option
          // BUG-16233
          QCP_STRUCT_CRALLOC(sColumnInfo, mtcColumn);
          sColumnInfo->column.flag = 0;
          if ($<boolType>3 == ID_FALSE) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          $<constraintSpec>$->constraintColumns->basicInfo = sColumnInfo;
      }
    | opt_constraint_name TR_PRIMARY TR_KEY
        opt_sort_mode        /* 4 */
        opt_index_directkey  /* 5 */
        opt_index_pers       /* 6 */
        constr_using_option  /* 7 */
      {
          mtcColumn        * sColumnInfo;
          qdIndexAttribute * sCurIndexAttr;

          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType       = QD_PRIMARYKEY;

          /* PROJ-2433 Direct Key Index */
          $<constraintSpec>$->mDirectKeyMaxSize = $<uLongVal>5;

          $<constraintSpec>$->isPers           = $<boolType>6;

          // To Fix BUG-13364
          SET_EMPTY_POSITION( $<constraintSpec>$->indexTBSName );
          $<constraintSpec>$->parallelDegree = 0;

          // fix BUG-18937
          if( $<indexAttrAndLocalIndex>7 != NULL )
          {
              $<constraintSpec>$->partIndex =
                                        $<indexAttrAndLocalIndex>7->partIndex;

              if ( $<indexAttrAndLocalIndex>7->ttl->initTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mInitTrans =
                      *$<indexAttrAndLocalIndex>7->ttl->initTrans;
              }

              if ( $<indexAttrAndLocalIndex>7->ttl->maxTrans == NULL )
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      QD_INVALID_TRANS_VALUE;
              }
              else
              {
                  $<constraintSpec>$->segAttr.mMaxTrans =
                      *$<indexAttrAndLocalIndex>7->ttl->maxTrans;
              }

              for ( sCurIndexAttr = $<indexAttrAndLocalIndex>7->indexAttr ;
                    sCurIndexAttr != NULL ;
                    sCurIndexAttr = sCurIndexAttr->next )
              {
                  switch( sCurIndexAttr->type )
                  {
                      case QD_INDEX_ATTR_LOGGING :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_LOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_FORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_FORCE;
                          break;
                      case QD_INDEX_ATTR_NOLOGGING_NOFORCE :
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_LOGGING_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOLOGGING;
                          $<constraintSpec>$->buildFlag &=
                              ~SMI_INDEX_BUILD_FORCE_MASK;
                          $<constraintSpec>$->buildFlag |=
                              SMI_INDEX_BUILD_NOFORCE;
                          break;
                      case QD_INDEX_ATTR_TABLESPACE :
                          SET_POSITION( $<constraintSpec>$->indexTBSName,
                                        sCurIndexAttr->TBSName );
                          break;
                      case QD_INDEX_ATTR_PARALLEL :
                          $<constraintSpec>$->parallelDegree =
                              sCurIndexAttr->parallelDegree;
                          break;
                      case QD_INDEX_ATTR_NOPARALLEL :
                          $<constraintSpec>$->parallelDegree = 1;  // BUG-16909
                          break;
                      default :
                          IDE_DASSERT(0);
                          break;
                  }
              }
          }
          else
          {
              $<constraintSpec>$->segAttr.mInitTrans =
                  QD_INVALID_TRANS_VALUE;
              $<constraintSpec>$->segAttr.mMaxTrans =
                  QD_INVALID_TRANS_VALUE;
          }

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );

          // set sort option
          // BUG-16233
          QCP_STRUCT_CRALLOC(sColumnInfo, mtcColumn);
          sColumnInfo->column.flag = 0;
          if ($<boolType>4 == ID_FALSE) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          $<constraintSpec>$->constraintColumns->basicInfo = sColumnInfo;
      }
    | opt_constraint_name references_specification opt_constraint_state
      {
          QCP_STRUCT_ALLOC($<constraintSpec>$, qdConstraintSpec);
          QD_SET_INIT_CONSTRAINT_SPEC( $<constraintSpec>$ );

          SET_POSITION($<constraintSpec>$->constrName, $<position>1);
          $<constraintSpec>$->constrType                = QD_FOREIGN;
          $<constraintSpec>$->referentialConstraintSpec = $<referenceSpec>2;

          // make constraint column
          QCP_STRUCT_ALLOC($<constraintSpec>$->constraintColumns, qcmColumn);
          QCM_COLUMN_INIT( $<constraintSpec>$->constraintColumns );

          // PROJ-1874 FK NOVALIDATE
          $<constraintSpec>$->constrState = $<constraintState>3;
      }
    ;

opt_constraint_state
    : /* empty */
      {
          // If Constriant state is not defined, it will return NULL
          $<constraintState>$ = NULL;
      }
    | constraint_state
      {
          $<constraintState>$ = $<constraintState>1;
      }
    ;

constraint_state
    : constraint_enable_state
      {
          QCP_STRUCT_ALLOC($<constraintState>$, qdConstraintState);
          QD_CONSTRAINT_STATE_INIT($<constraintState>$);

          // Position 1 is not validate position
          //  yet use this for error message
          SET_POSITION($<constraintState>$->validatePosition, $<position>1);
      }
    | constraint_validate_state
      {
          QCP_STRUCT_ALLOC($<constraintState>$, qdConstraintState);
          QD_CONSTRAINT_STATE_INIT($<constraintState>$);

          $<constraintState>$->validate = $<boolType>1;
          SET_POSITION($<constraintState>$->validatePosition, $<position>1);
      }
    | constraint_enable_state constraint_validate_state
      {
          QCP_STRUCT_ALLOC($<constraintState>$, qdConstraintState);
          QD_CONSTRAINT_STATE_INIT($<constraintState>$);

          $<constraintState>$->validate = $<boolType>2;
          SET_POSITION($<constraintState>$->validatePosition, $<position>2);
      }
    ;

constraint_enable_state
    : TR_ENABLE
      {
          // Enable Parse ó  ʴ´.
      }
/*
// DIABLE  ʴ´.
    | TR_DISABLE
      {
          $<boolType>$ = ID_FALSE;
      }
*/
    ;

constraint_validate_state
    : TI_NONQUOTED_IDENTIFIER
      {
          // VALIDATE, NOVALIDATE
          qcuSqlSourceInfo sqlInfo;

          if (idlOS::strMatch(
                  "VALIDATE", 8,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          {
              if (idlOS::strMatch(
                      "NOVALIDATE", 10,
                      QTEXT+$<position>1.offset, $<position>1.size) == 0)
              {
                  $<boolType>$ = ID_FALSE;
              }
              else
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }
      }
    ;

opt_default_clause
    : /* empty */
      {
          $<expression>$[0] = NULL;
          $<expression>$[1] = NULL;
      }
    | TR_DEFAULT arithmetic_expression
      {
          $<expression>$[0] = $<expression>2[0];
          $<expression>$[1] = $<expression>2[1];
      }
    ;

opt_rule_data_type
    : /* empty */
      {
          mtcColumn     * sColumn;

          // BUG-16233
          QCP_STRUCT_CRALLOC( sColumn, mtcColumn );
          sColumn->module = NULL;
          sColumn->flag   = 0;

          $<column>$ = sColumn;
      }
    | rule_data_type opt_extended_column_attribute
      {
          $<column>$ = $<column>1;

          if ( $<extColumnAttr>2 != NULL )
          {
              if ( QC_IS_NULL_NAME( $<extColumnAttr>2->mPolicyPosition ) != ID_TRUE )
              {
                  QCP_TEST( qtc::changeColumn4Encrypt( STATEMENT,
                                                       $<extColumnAttr>2,
                                                       $<column>$ )
                            != IDE_SUCCESS );
              }
              else
              {
                  QCP_TEST( qtc::changeColumn4SRID( STATEMENT,
                                                    $<extColumnAttr>2,
                                                    $<column>$ )
                            != IDE_SUCCESS );
              }
          }
      }
    ;

rule_data_type
    : TI_IDENTIFIER
      {
          QCP_TEST( qtc::createColumn( STATEMENT,
                                       &$<position>1, &$<column>$,
                                       0, NULL, NULL, 1,
                                       ID_FALSE )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_OPENING_PARENTHESIS TL_INTEGER TS_CLOSING_PARENTHESIS
      {
          QCP_TEST( qtc::createColumn( STATEMENT,
                                       &$<position>1, &$<column>$,
                                       1, &$<position>3, NULL, 1,
                                       ID_FALSE )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_OPENING_PARENTHESIS TL_INTEGER TS_COMMA
      TL_INTEGER TS_CLOSING_PARENTHESIS
      {
          QCP_TEST( qtc::createColumn( STATEMENT,
                                       &$<position>1, &$<column>$,
                                       2, &$<position>3, &$<position>5, 1,
                                       ID_FALSE )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_OPENING_PARENTHESIS TL_INTEGER TS_COMMA
      TS_PLUS_SIGN TL_INTEGER TS_CLOSING_PARENTHESIS
      {
          QCP_TEST( qtc::createColumn( STATEMENT,
                                       &$<position>1, &$<column>$,
                                       2, &$<position>3, &$<position>6, 1,
                                       ID_FALSE )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_OPENING_PARENTHESIS TL_INTEGER TS_COMMA
      TS_MINUS_SIGN TL_INTEGER TS_CLOSING_PARENTHESIS
      {
          QCP_TEST( qtc::createColumn( STATEMENT,
                                       &$<position>1, &$<column>$,
                                       2, &$<position>3, &$<position>6, -1,
                                       ID_FALSE )
                    != IDE_SUCCESS );
      }
    ;

opt_extended_column_attribute
    : /* empty */
      {
          $<extColumnAttr>$ = NULL;
      }
    | extended_column_attribute
      {
          $<extColumnAttr>$ = $<extColumnAttr>1;
      }
    ;

extended_column_attribute
    : TI_NONQUOTED_IDENTIFIER TR_USING TL_LITERAL
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch("ENCRYPT", 7,
                              QTEXT+$<position>1.offset,
                              $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                              sqlInfo.getErrMessage());
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<extColumnAttr>$, qdExtColumnAttr );
          QD_SET_INIT_EXT_COLUMN_ATTR( $<extColumnAttr>$ );

          SET_QUOTE_POSITION( $<extColumnAttr>$->mPolicyPosition, $<position>3 );
      }
    | TI_NONQUOTED_IDENTIFIER TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sSrid;

          if ( idlOS::strMatch( "SRID", 4,
                                QTEXT+$<position>1.offset,
                                $<position>1.size ) != 0 )
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                               sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<extColumnAttr>$, qdExtColumnAttr );
          QD_SET_INIT_EXT_COLUMN_ATTR( $<extColumnAttr>$ );

          if( qtc::getBigint( QTEXT, &sSrid, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          $<extColumnAttr>$->mSrid = sSrid;
      }
    | TI_NONQUOTED_IDENTIFIER TS_MINUS_SIGN TL_INTEGER
      {
          qcuSqlSourceInfo    sqlInfo;
          SLong               sSrid;

          if ( idlOS::strMatch( "SRID", 4,
                                QTEXT+$<position>1.offset,
                                $<position>1.size ) != 0 )
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                               sqlInfo.getErrMessage() );
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC( $<extColumnAttr>$, qdExtColumnAttr );
          QD_SET_INIT_EXT_COLUMN_ATTR( $<extColumnAttr>$ );

          if( qtc::getBigint( QTEXT, &sSrid, &$<position>3 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          $<extColumnAttr>$->mSrid = -sSrid;
      }
    ;

opt_column_commalist
    : /* empty */
      {
          $<columnDef>$ = NULL;
      }
    | TS_OPENING_PARENTHESIS column_commalist TS_CLOSING_PARENTHESIS
      {
          $<columnDef>$ = $<columnDef>2;
      }
    ;

opt_table_column_commalist
    : /* empty */
      {
          $<columnDef>$ = NULL;
      }
    | TS_OPENING_PARENTHESIS table_column_commalist TS_CLOSING_PARENTHESIS
      {
          $<columnDef>$ = $<columnDef>2;
      }
    ;

key_column_with_opt_sort_mode_commalist
    : TS_OPENING_PARENTHESIS
        column_with_opt_sort_mode_commalist
      TS_CLOSING_PARENTHESIS
      {
          $<columnDef>$ = $<columnDef>2;
      }
    ;

expression_with_opt_sort_mode_commalist
    : expression_with_opt_sort_mode_commalist TS_COMMA expression_opt_sort_mode_with_position
      {
          qdColumnWithPosition  * sLastColumn;
          qdColumnWithPosition  * sCurrColumn;
          qcuSqlSourceInfo        sqlInfo;

          $<columnWithPosition>$ = $<columnWithPosition>1;

          sCurrColumn = $<columnWithPosition>3;
          SET_POSITION( sCurrColumn->beforePosition, $<position>2 );

          // check duplicate column name
          if ( (sCurrColumn->column->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
               != QCM_COLUMN_HIDDEN_COLUMN_TRUE )
          {
              for ( sLastColumn = $<columnWithPosition>$;
                    sLastColumn != NULL;
                    sLastColumn = sLastColumn->next )
              {
                  if ( QC_IS_NAME_MATCHED( sCurrColumn->column->namePos, sLastColumn->column->namePos ) )
                  {
                      sqlInfo.setSourceInfo( STATEMENT, &(sCurrColumn->column->namePos) );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }
                  else
                  {
                      /* Nothing to do */
                  }
              }
          }
          else
          {
              /* Nothing to do */
          }

          // connect
          sLastColumn = $<columnWithPosition>$;
          while ( sLastColumn->next != NULL )
          {
              sLastColumn = sLastColumn->next;
          }

          sLastColumn->next         = sCurrColumn;
          sLastColumn->column->next = sCurrColumn->column;
      }
    | expression_opt_sort_mode_with_position
      {
          $<columnWithPosition>$ = $<columnWithPosition>1;
      }
    ;

expression_opt_sort_mode_with_position
    : expression opt_sort_mode_with_position
      {
          qtcNode           * sNode;
          mtcColumn         * sColumnInfo;

          QCP_STRUCT_ALLOC( $<columnWithPosition>$, qdColumnWithPosition );
          SET_EMPTY_POSITION( $<columnWithPosition>$->beforePosition );
          SET_EMPTY_POSITION( $<columnWithPosition>$->afterPosition );
          $<columnWithPosition>$->next = NULL;

          QCP_STRUCT_ALLOC( $<columnWithPosition>$->column, qcmColumn );
          QCM_COLUMN_INIT( $<columnWithPosition>$->column );

          sNode = $<expression>1[0];

          /* qtc::makeColumn()  ׸ Column ȮѴ. */
          if ( (QC_IS_NULL_NAME( sNode->columnName ) == ID_FALSE) &&
               (sNode->node.module == &qtc::columnModule) )
          {
              /* Column ó */
              SET_POSITION( $<columnWithPosition>$->column->namePos, sNode->columnName );

          }
          else
          {
              /* Expression̹Ƿ, Hidden Column ó */
              $<columnWithPosition>$->column->flag &= ~QCM_COLUMN_HIDDEN_COLUMN_MASK;
              $<columnWithPosition>$->column->flag |= QCM_COLUMN_HIDDEN_COLUMN_TRUE;

              $<columnWithPosition>$->column->defaultValue = sNode;
          }

          // BUG-16233
          QCP_STRUCT_CRALLOC( sColumnInfo, mtcColumn );
          sColumnInfo->column.flag = 0;
          if ( $<sortMode>2.isDescending == ID_FALSE ) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          $<columnWithPosition>$->column->basicInfo = sColumnInfo;

          if ( QC_IS_NULL_NAME( $<sortMode>2.position ) == ID_FALSE )
          {
              SET_POSITION( $<columnWithPosition>$->afterPosition, $<sortMode>2.position );
          }
          else
          {
              /* Nothing to do */
          }
      }
    ;

opt_sort_mode_with_position
    : /* empty */
      {
          SET_EMPTY_POSITION( $<sortMode>$.position );
          $<sortMode>$.isDescending = ID_FALSE;
      }
    | TR_ASC
      {
          SET_POSITION( $<sortMode>$.position, $<position>1 );
          $<sortMode>$.isDescending = ID_FALSE;
      }
    | TR_DESC
      {
          SET_POSITION( $<sortMode>$.position, $<position>1 );
          $<sortMode>$.isDescending = ID_TRUE;
      }
    ;

column_with_opt_sort_mode_commalist
    : column_with_opt_sort_mode_commalist TS_COMMA column_name opt_sort_mode
      {
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          mtcColumn         * sColumnInfo;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // make current column
          QCP_STRUCT_ALLOC(sCurrColumn, qcmColumn);
          QCM_COLUMN_INIT( sCurrColumn );

          SET_POSITION(sCurrColumn->namePos, $<position>3);
          // BUG-16233
          QCP_STRUCT_CRALLOC(sColumnInfo, mtcColumn);
          sColumnInfo->column.flag = 0;
          if ($<boolType>4 == ID_FALSE) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          sCurrColumn->basicInfo    = sColumnInfo;

          // BUG-36739
          $<columnDef>$ = $<columnDef>1;

          // check duplicate column name
          for( sLastColumn = $<columnDef>$;
               sLastColumn != NULL;
               sLastColumn = sLastColumn->next)
          {
              if (idlOS::strMatch(
                      QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                      QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          // connect
          sLastColumn = $<columnDef>$;
          while (sLastColumn->next != NULL)
          {
              sLastColumn = sLastColumn->next;
          }

          sLastColumn->next = sCurrColumn;
      }
    | column_name opt_sort_mode
      {
          mtcColumn         * sColumnInfo;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<columnDef>$, qcmColumn);
          QCM_COLUMN_INIT( $<columnDef>$ );

          SET_EMPTY_POSITION($<columnDef>$->userNamePos);
          SET_EMPTY_POSITION($<columnDef>$->tableNamePos);
          SET_POSITION($<columnDef>$->namePos, $<position>1);

          // BUG-16233
          QCP_STRUCT_CRALLOC(sColumnInfo, mtcColumn);
          sColumnInfo->column.flag = 0;
          if ($<boolType>2 == ID_FALSE) // ASC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_ASCENDING;
          }
          else // DESC
          {
              sColumnInfo->column.flag &= ~SMI_COLUMN_ORDER_MASK;
              sColumnInfo->column.flag |= SMI_COLUMN_ORDER_DESCENDING;
          }
          $<columnDef>$->basicInfo    = sColumnInfo;
      }
    ;

column_commalist
    : column_commalist TS_COMMA column_name
      {
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // make current column
          QCP_STRUCT_ALLOC(sCurrColumn, qcmColumn);
          QCM_COLUMN_INIT( sCurrColumn );

          SET_POSITION(sCurrColumn->namePos, $<position>3);

          // BUG-36739
          $<columnDef>$ = $<columnDef>1;

          // check duplicate column name
          for( sLastColumn = $<columnDef>$;
               sLastColumn != NULL;
               sLastColumn = sLastColumn->next)
          {
              if (idlOS::strMatch(
                      QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                      QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          // connect
          sLastColumn = $<columnDef>$;
          while (sLastColumn->next != NULL)
          {
              sLastColumn = sLastColumn->next;
          }

          sLastColumn->next = sCurrColumn;
      }
    | column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // column name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<columnDef>$, qcmColumn);
          QCM_COLUMN_INIT( $<columnDef>$ );

          SET_EMPTY_POSITION($<columnDef>$->userNamePos);
          SET_EMPTY_POSITION($<columnDef>$->tableNamePos);
          SET_POSITION($<columnDef>$->namePos, $<position>1);
      }
    ;

table_column_commalist
    : table_column_commalist TS_COMMA set_column_def
      {
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrColumn = $<columnDef>3;
          
          // BUG-36739
          $<columnDef>$ = $<columnDef>1;

          // check duplicate column name
          for( sLastColumn = $<columnDef>$;
               sLastColumn != NULL;
               sLastColumn = sLastColumn->next)
          {
              // BUGBUG
              // Ʒ  t2.i1 t1.i1 ٸ column name ˻Ͽ dup üũѴ.
              // insert into t1(t2.i1, t1.i1) values (1,1)
              if (idlOS::strMatch(
                      QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                      QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
              {
                  sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }

          // connect
          sLastColumn = $<columnDef>$;
          while (sLastColumn->next != NULL)
          {
              sLastColumn = sLastColumn->next;
          }

          sLastColumn->next = sCurrColumn;
      }
    | set_column_def
      {
          $<columnDef>$ = $<columnDef>1;
      }
    ;

references_specification
    : TR_REFERENCES user_object_name opt_column_commalist opt_reference_spec_list
      {
          QCP_STRUCT_ALLOC($<referenceSpec>$, qdReferenceSpec);

          SET_POSITION($<referenceSpec>$->referencedUserName,
                       $<userNObjName>2->userName);
          SET_POSITION($<referenceSpec>$->referencedTableName,
                       $<userNObjName>2->objectName);

          $<referenceSpec>$->referencedColList = $<columnDef>3;

          // BUG-29728
          //  Meta table delete option cascade θ ľؼ 0,1
          // ǥ ִµ ̸  Ű ʰ   ̷
          // ٸ ɼ ´  ʰ DML κ ϰ ɼ
          // κи, ܼ  Ѱ־ Delete option մϴ
          $<referenceSpec>$->referenceRule = $<uIntVal>4 & QD_FOREIGN_OPTION_MASK;
      }
;

opt_reference_spec_list
    : //empty
    {
        $<uIntVal>$ = QD_FOREIGN_INIT;
    }
    | opt_reference_spec_list reference_spec
    {
        qcuSqlSourceInfo sqlInfo;

        // BUG-36739
        $<uIntVal>$ = $<uIntVal>1;

        // ߺ ׸ üũ
        //  ׺  ݺؼ  
        if (( QD_FOREIGN_DML_MASK & ($<uIntVal>$ & $<uIntVal>2))
             == (QD_FOREIGN_DML_MASK & $<uIntVal>2))
        {
            sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
            sqlInfo.init(MEMORY);
            IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage()));
            sqlInfo.fini();
            YYABORT;
        }
        else
        {
            $<uIntVal>$ |= $<uIntVal>2;
        }
    }
    ;

reference_spec
    : TR_ON TR_INSERT referential_action
      {
          $<uIntVal>$ = QD_FOREIGN_INSERT_NO_ACTION;
      }
    | TR_ON TR_UPDATE referential_action
      {
          $<uIntVal>$ = QD_FOREIGN_UPDATE_NO_ACTION;
      }
    | TR_ON TR_DELETE referential_action
      {
          $<uIntVal>$ = QD_FOREIGN_DELETE_NO_ACTION;
      }
    | TR_ON TR_DELETE TR_CASCADE
      {
          $<uIntVal>$ = QD_FOREIGN_DELETE_CASCADE;
      }
    | TR_ON TR_DELETE TR_SET TR_NULL
      {
          // PROJ-2212 foreign key on delete set null
          $<uIntVal>$ = QD_FOREIGN_DELETE_SET_NULL;
      }
    ;

referential_action
    : TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          if (idlOS::strMatch(
                  "NO", 2,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              if (idlOS::strMatch(
                      "ACTION", 6,
                      QTEXT+$<position>2.offset, $<position>2.size) != 0)
              { // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;

              }
              else
              {
                  //nothing to do
              }
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

table_maxrows
    : TA_MAXROWS TL_INTEGER
      {
          SLong    sMaxRows = 0;

          QCP_STRUCT_ALLOC($<tableMaxRows>$, qdTableMaxRows);

          if( qtc::getBigint( QTEXT, &sMaxRows, &$<position>2 ) != IDE_SUCCESS )
          {
              YYABORT;
          }

          $<tableMaxRows>$->namePosition = $<position>1;
          $<tableMaxRows>$->maxRows = sMaxRows;
      }
    ;

opt_allow_delete
    : /* empty */
      {
         $<tableAttrFlagList>$ = NULL;
      }
    | allow_delete
      {
        $<tableAttrFlagList>$ = $<tableAttrFlagList>1;
      }
    ;

allow_delete
    : TR_DELETE TR_ON
      {
         QCP_STRUCT_ALLOC($<tableAttrFlagList>$, qdTableAttrFlagList);

         SET_POSITION( $<tableAttrFlagList>$->attrPosition, $<position>2 );

         $<tableAttrFlagList>$->attrMask  = SMI_TABLE_QUEUE_ALLOW_DELETE_MASK;
         $<tableAttrFlagList>$->attrValue = SMI_TABLE_QUEUE_ALLOW_DELETE_TRUE;
         $<tableAttrFlagList>$->next      = NULL;
      }
    | TR_DELETE TR_OFF
      {
          QCP_STRUCT_ALLOC($<tableAttrFlagList>$, qdTableAttrFlagList);

         SET_POSITION( $<tableAttrFlagList>$->attrPosition, $<position>2 );

         $<tableAttrFlagList>$->attrMask  = SMI_TABLE_QUEUE_ALLOW_DELETE_MASK;
         $<tableAttrFlagList>$->attrValue = SMI_TABLE_QUEUE_ALLOW_DELETE_FALSE;
         $<tableAttrFlagList>$->next      = NULL;
      }
    ;

// Proj-1360 Queue
create_queue_statement
    : TR_CREATE
      TR_QUEUE
      user_object_name
      TS_OPENING_PARENTHESIS
      TL_INTEGER
      opt_variable_flag
      opt_in_row
      TS_CLOSING_PARENTHESIS
      table_maxrows_option
      opt_allow_delete
      tablespace_name_option
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT($<tableParseTree>$);

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->flag = 0;
          $<tableParseTree>$->flag &= ~QDQ_QUEUE_MASK;
          $<tableParseTree>$->flag |= QDQ_QUEUE_TRUE;
          
          // make column list
          QCP_TEST( qcpUtil::makeColumns4Queue( STATEMENT,
                                                &($<position>5),
                                                $<flag>6,
                                                $<uIntVal>7,
                                                $<tableParseTree>$ )
                    != IDE_SUCCESS );

          /* validateCreateTable   ʰ ó */
          // INITTRANS
          $<tableParseTree>$->segAttr.mInitTrans =
              QD_INVALID_TRANS_VALUE;

          $<tableParseTree>$->segAttr.mMaxTrans =
              QD_INVALID_TRANS_VALUE;

          if ( $<tableMaxRows>9 != NULL )
          {
              $<tableParseTree>$->maxrows = $<tableMaxRows>9->maxRows;
          }
          else
          {
              $<tableParseTree>$->maxrows = 0;
          }
          
          /* BUG-49063 DELETE ON/OFF */
          if ( $<tableAttrFlagList>10 != NULL )
          {
              $<tableParseTree>$->tableAttrFlagList
                  = $<tableAttrFlagList>10;
          }

          /* TableSpace Name */
          if ( $<positionPtr>11 != NULL )
          {
              SET_POSITION( $<tableParseTree>$->TBSName,
                            *($<positionPtr>11));
          }
          else
          {
              SET_EMPTY_POSITION( $<tableParseTree>$->TBSName );
          }
 
          /* PROJ-2464 hybrid partitioned table 
           * Segment Storage Attribute list
           */
          $<tableParseTree>$->segStoAttr.mInitExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mNextExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mMinExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mMaxExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          // message size
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate =
              qdbCreate::validateCreateTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdq::executeCreateQueue;
      }
    | TR_CREATE
      TR_QUEUE
      user_object_name
      TS_OPENING_PARENTHESIS
      column_def_commalist
      TS_CLOSING_PARENTHESIS
      table_maxrows_option
      opt_allow_delete
      tablespace_name_option
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT($<tableParseTree>$);

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->flag = 0;
          $<tableParseTree>$->flag &= ~QDQ_QUEUE_MASK;
          $<tableParseTree>$->flag |= QDQ_QUEUE_TRUE;

          // column constraint  ʴ´.
          if ( $<tableElement>5.constraints != NULL )
          {
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          else
          {
              // Nothing to do.
          }
          
          // make queue column list
          QCP_TEST( qcpUtil::makeColumns4StructQueue( STATEMENT,
                                                      $<tableElement>5.columns,
                                                      $<tableParseTree>$ )
                    != IDE_SUCCESS );
          
          /* validateCreateTable   ʰ ó */
          // INITTRANS
          $<tableParseTree>$->segAttr.mInitTrans =
              QD_INVALID_TRANS_VALUE;

          $<tableParseTree>$->segAttr.mMaxTrans =
              QD_INVALID_TRANS_VALUE;

          if ( $<tableMaxRows>7 != NULL )
          {
              $<tableParseTree>$->maxrows = $<tableMaxRows>7->maxRows;
          }
          else
          {
              $<tableParseTree>$->maxrows = 0;
          }

          /* BUG-49063 DELETE ON/OFF */
          if ( $<tableAttrFlagList>8 != NULL )
          {
              $<tableParseTree>$->tableAttrFlagList
                  = $<tableAttrFlagList>8;
          }

          /* TableSpace Name */
          if ( $<positionPtr>9 != NULL )
          {
              SET_POSITION( $<tableParseTree>$->TBSName,
                            *($<positionPtr>9));
          }
          else
          {
              SET_EMPTY_POSITION( $<tableParseTree>$->TBSName );
          }

          /* PROJ-2464 hybrid partitioned table 
           * Segment Storage Attribute list
           */
          $<tableParseTree>$->segStoAttr.mInitExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mNextExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mMinExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          $<tableParseTree>$->segStoAttr.mMaxExtCnt =
              QD_INVALID_SEGMENT_STORAGE_VALUE;

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;
          
          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate =
              qdbCreate::validateCreateTable;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdq::executeCreateQueue;
      }
    ;

alter_queue_statement
    : TR_ALTER TR_QUEUE user_object_name TI_NONQUOTED_IDENTIFIER opt_maxpages
      // ALTER QUEUE IDENTIFIER COMPACT
    {
        qcuSqlSourceInfo sqlInfo;

        if (idlOS::strMatch(
                "COMPACT", 7,
                QTEXT+$<position>4.offset, $<position>4.size) == 0)
        {
            QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
            QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
            QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

            /* set userName position */
            SET_POSITION($<tableParseTree>$->userName,
                         $<userNObjName>3->userName);
            /* set tableName position */
            SET_POSITION($<tableParseTree>$->tableName,
                         $<userNObjName>3->objectName);

            QCP_STRUCT_ALLOC( $<tableParseTree>$->partTable, qdPartitionedTable );
            QD_SET_INIT_PART_TABLE( $<tableParseTree>$->partTable );

            $<tableParseTree>$->flag = 0;
            $<tableParseTree>$->flag &= ~QDQ_QUEUE_MASK;
            $<tableParseTree>$->flag |= QDQ_QUEUE_TRUE;

            if ($<uLongPtr>5 != NULL)
            {
                $<tableParseTree>$->maxrows = *($<uLongPtr>5);
            }
            
            $<tableParseTree>$->common.parse    = qcc::parse;
            $<tableParseTree>$->common.validate =
                qdq::validateAlterCompactQueue;
            $<tableParseTree>$->common.optimize = qcc::optimize;
            $<tableParseTree>$->common.execute  = qdq::executeCompactQueue;
        }
        else
        { // syntax error
            sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
    }
    /* BUG-45921 */
    | TR_ALTER TR_QUEUE user_object_name TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      /* ALTER QUEUE IDENTIFIER MSGID RESET */
    {
        qcuSqlSourceInfo sqlInfo;

        QCP_STRUCT_ALLOC( $<queueSequenceParseTree>$, qdQueueSequenceParseTree );
        QC_SET_INIT_PARSE_TREE( $<queueSequenceParseTree>$, $<position>1 );
        QD_QUEUE_SEQUENCE_PARSE_TREE_INIT( $<queueSequenceParseTree>$ );

        /* set userName position */
        SET_POSITION( $<queueSequenceParseTree>$->mUserName,
                      $<userNObjName>3->userName );
        /* set tableName position */
        SET_POSITION( $<queueSequenceParseTree>$->mQueueName,
                      $<userNObjName>3->objectName );

        if ( idlOS::strMatch( "MSGID",
                              5,
                              QTEXT + $<position>4.offset,
                              $<position>4.size )
             == 0 )
        {
            /* Nothing to do */
        }
        else
        {
            sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }
            
        if ( idlOS::strMatch( "RESET",
                              5,
                              QTEXT + $<position>5.offset,
                              $<position>5.size )
             == 0 )
        {
            /* Nothing to do */
        }
        else
        {
            sqlInfo.setSourceInfo( STATEMENT, & $<position>5 );
            sqlInfo.init( MEMORY );
            IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage() ) );
            sqlInfo.fini();
            YYABORT;
        }

        $<queueSequenceParseTree>$->common.parse    = qcc::parse;
        $<queueSequenceParseTree>$->common.validate = qdq::validateAlterQueueSequence;
        $<queueSequenceParseTree>$->common.optimize = qcc::optimize;
        $<queueSequenceParseTree>$->common.execute  = qdq::executeAlterQueueSequence;
    }
    /* BUG-49063 */
    | TR_ALTER TR_QUEUE user_object_name allow_delete
      /* ALTER QUEUE IDENTIFIER DELETE ON */
      /* ALTER QUEUE IDENTIFIER DELETE OFF */
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT($<tableParseTree>$);

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->flag = 0;
          $<tableParseTree>$->flag &= ~QDQ_QUEUE_MASK;
          $<tableParseTree>$->flag |= QDQ_QUEUE_TRUE;

          /* BUG-49063 DELETE ON/OFF */
          if ( $<tableAttrFlagList>4 != NULL )
          {
              $<tableParseTree>$->tableAttrFlagList
                  = $<tableAttrFlagList>4;
          }

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate =
              qdq::validateAlterAllowDelete;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdbAlter::executeAttrFlag;
      }
    ;

// Proj - 1360 Queue
drop_queue_statement
    : TR_DROP TR_QUEUE user_object_name
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set objectName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          $<dropParseTree>$->flag = 0;
          $<dropParseTree>$->flag &= ~QDQ_QUEUE_MASK;
          $<dropParseTree>$->flag |= QDQ_QUEUE_TRUE;

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateDropTable;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdq::executeDropQueue;
      }
    ;

create_view_statement
    : TR_CREATE opt_no_force TR_VIEW user_object_name
        opt_view_column_def
        TR_AS select_or_with_select_statement
        opt_with_read_only
      {
          qcStatement       * sStatement;


          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>4->objectName);

          $<tableParseTree>$->columns     = $<tableElement>5.columns;
          $<tableParseTree>$->maxrows     = 0;

          $<tableParseTree>$->flag        = 0;
          $<tableParseTree>$->flag &= ~QDV_VIEW_DDL_MASK;
          $<tableParseTree>$->flag |= QDV_VIEW_DDL_TRUE;

          $<tableParseTree>$->flag &= ~QDV_OPT_REPLACE_MASK;
          $<tableParseTree>$->flag |= QDV_OPT_REPLACE_FALSE;

          if ( $<boolType>2 == ID_FALSE ) // NO FORCE
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_FORCE_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_FORCE_FALSE;
          }
          else // FORCE
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_FORCE_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_FORCE_TRUE;
          }
          
          /* BUG-36350 Updatable Join DML WITH READ ONLY */
          if ( $<isWithReadOnly>8 == ID_FALSE )
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_WITH_READ_ONLY_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_WITH_READ_ONLY_FALSE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_WITH_READ_ONLY_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_WITH_READ_ONLY_TRUE;
          }

          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->tableInfo   = NULL;

          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>7)
          $<tableParseTree>$->select = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          $<tableParseTree>$->common.parse    = qdv::parseCreateViewAsSelect;
          $<tableParseTree>$->common.validate = qdv::validateCreate;
          $<tableParseTree>$->common.optimize = qdbCreate::optimize;
          $<tableParseTree>$->common.execute  = qdv::executeCreate;
      }
    ;

create_or_replace_view_statement
    : TR_CREATE TR_OR TO_REPLACE opt_no_force TR_VIEW user_object_name
        opt_view_column_def
        TR_AS select_or_with_select_statement
        opt_with_read_only
      {
          qcStatement       * sStatement;

          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree);
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>6->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>6->objectName);

          $<tableParseTree>$->columns     = $<tableElement>7.columns;
          $<tableParseTree>$->maxrows     = 0;

          $<tableParseTree>$->flag        = 0;
          $<tableParseTree>$->flag &= ~QDV_VIEW_DDL_MASK;
          $<tableParseTree>$->flag |= QDV_VIEW_DDL_TRUE;

          // OR REPLACE
          $<tableParseTree>$->flag &= ~QDV_OPT_REPLACE_MASK;
          $<tableParseTree>$->flag |= QDV_OPT_REPLACE_TRUE;

          if ( $<boolType>4 == ID_FALSE ) // NO FORCE
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_FORCE_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_FORCE_FALSE;
          }
          else // FORCE
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_FORCE_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_FORCE_TRUE;
          }

          /* BUG-36350 Updatable Join DML WITH READ ONLY */
          if ( $<isWithReadOnly>10 == ID_FALSE )
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_WITH_READ_ONLY_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_WITH_READ_ONLY_FALSE;
          }
          else
          {
              $<tableParseTree>$->flag &= ~QDV_OPT_WITH_READ_ONLY_MASK;
              $<tableParseTree>$->flag |= QDV_OPT_WITH_READ_ONLY_TRUE;
          }
          
          // BUG-21761
          $<tableParseTree>$->ncharList = NCHARLIST;

          $<tableParseTree>$->tableInfo   = NULL;

          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>9)
          $<tableParseTree>$->select = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          $<tableParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          $<tableParseTree>$->common.parse    = qdv::parseCreateViewAsSelect;
          $<tableParseTree>$->common.validate = qdv::validateCreate;
          $<tableParseTree>$->common.optimize = qdbCreate::optimize;
          $<tableParseTree>$->common.execute  = qdv::executeCreate;
      }
    ;

opt_no_force
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          if (idlOS::strMatch(
                  "NO", 2,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              if (idlOS::strMatch(
                      "FORCE", 5,
                      QTEXT+$<position>2.offset, $<position>2.size) == 0)
              {
                  $<boolType>$ = ID_FALSE;
              }
              else
              {
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }
          else
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
          }
      }
    | TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          if (idlOS::strMatch(
                "FORCE", 5,
                QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

opt_view_column_def
    : /* empty */
      {
          $<tableElement>$.constraints = NULL;
          $<tableElement>$.columns     = NULL;
      }
    | TS_OPENING_PARENTHESIS view_element_commalist TS_CLOSING_PARENTHESIS
      {
          $<tableElement>$ = $<tableElement>2;
      }
    ;

view_element_commalist
    : view_element_commalist TS_COMMA view_element
      {
          qcmColumn         * sLastColumn;
          qcmColumn         * sCurrColumn;
          qcuSqlSourceInfo    sqlInfo;

          sCurrColumn = $<tableElement>3.columns;

          // columns
          if ($<tableElement>1.columns == NULL)
          {
              $<tableElement>$.columns = $<tableElement>3.columns;
          }
          else
          {
              $<tableElement>$.columns = $<tableElement>1.columns;

              // check duplicate column name
              for (sLastColumn = $<tableElement>$.columns;
                   sLastColumn != NULL;
                   sLastColumn = sLastColumn->next)
              {
                  if (idlOS::strMatch(
                          QTEXT+sCurrColumn->namePos.offset, sCurrColumn->namePos.size,
                          QTEXT+sLastColumn->namePos.offset, sLastColumn->namePos.size) == 0)
                  {
                      sqlInfo.setSourceInfo(STATEMENT, & (sLastColumn->namePos));
                      sqlInfo.init(MEMORY);
                      IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME,
                                              sqlInfo.getErrMessage()));
                      sqlInfo.fini();
                      YYABORT;
                  }
              }

              // connect
              sLastColumn = $<tableElement>$.columns;
              while (sLastColumn->next != NULL)
              {
                  sLastColumn = sLastColumn->next;
              }
              sLastColumn->next = sCurrColumn;
          }
      }
    | view_element
      {
          $<tableElement>$ = $<tableElement>1;
      }
    ;

view_element
    : column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // View column alias name
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<tableElement>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<tableElement>$.columns );

          $<tableElement>$.columns->namePos         = $<position>1;

          $<tableElement>$.columns->flag            = QCM_COLUMN_TYPE_DEFAULT;
      }
    ;

opt_with_read_only
    : /* empty */
      {
          /* BUG-36350 Updatable Join DML WITH READ ONLY */
          $<isWithReadOnly>$ = ID_FALSE;
      }
    | TR_WITH TR_READ TI_NONQUOTED_IDENTIFIER
      /* WITH READ ONLY */
      {
          qcuSqlSourceInfo sqlInfo;

          /* BUG-36350 Updatable Join DML WITH READ ONLY */
          if (idlOS::strMatch(
                "ONLY", 4,
                QTEXT+$<position>3.offset, $<position>3.size) == 0)
          {
              $<isWithReadOnly>$ = ID_TRUE;
          }
          else
          {
              // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

alter_view_statement
    : TR_ALTER TR_VIEW user_object_name TR_COMPILE
      /* ALTER VIEW [user_name.]view_name COMPILE */
      {
          QCP_STRUCT_ALLOC($<tableParseTree>$, qdTableParseTree );
          QC_SET_INIT_PARSE_TREE($<tableParseTree>$, $<position>1);
          QD_TABLE_PARSE_TREE_INIT( $<tableParseTree>$ );

          /* set userName position */
          SET_POSITION($<tableParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set tableName position */
          SET_POSITION($<tableParseTree>$->tableName,
                       $<userNObjName>3->objectName);

          $<tableParseTree>$->maxrows     = 0;
          $<tableParseTree>$->flag &= ~QDV_VIEW_DDL_MASK;
          $<tableParseTree>$->flag |= QDV_VIEW_DDL_TRUE;

          $<tableParseTree>$->common.parse    = qcc::parse;
          $<tableParseTree>$->common.validate = qdv::validateAlter;
          $<tableParseTree>$->common.optimize = qcc::optimize;
          $<tableParseTree>$->common.execute  = qdv::executeAlter;
      }
    ;

drop_view_statement
    : TR_DROP TR_VIEW user_object_name
      {
          QCP_STRUCT_ALLOC($<dropParseTree>$, qdDropParseTree);
          QC_SET_INIT_PARSE_TREE($<dropParseTree>$, $<position>1);
          QD_DROP_PARSE_TREE_INIT($<dropParseTree>$);

          /* set userName position */
          SET_POSITION($<dropParseTree>$->userName,
                       $<userNObjName>3->userName);
          /* set objectName position */
          SET_POSITION($<dropParseTree>$->objectName,
                       $<userNObjName>3->objectName);

          $<dropParseTree>$->common.parse    = qcc::parse;
          $<dropParseTree>$->common.validate = qdd::validateDropView;
          $<dropParseTree>$->common.optimize = qcc::optimize;
          $<dropParseTree>$->common.execute  = qdd::executeDropView;
      }
    ;

get_default_statement
    : TR_DEFAULT arithmetic_expression
      {
          QCP_STRUCT_ALLOC($<defaultParseTree>$, qdDefaultParseTree);

          $<defaultParseTree>$->defaultValue = $<expression>2[0];
          $<defaultParseTree>$->lastNode = $<expression>2[1];
// BUG-24087
// ν  insert  default valueó
// SYSDATE columnID ϴ  ϴ  .

          $<defaultParseTree>$->common.parse    = qcc::parseError;
          $<defaultParseTree>$->common.validate = qcc::validate;
          $<defaultParseTree>$->common.optimize = qcc::optimize;
          $<defaultParseTree>$->common.execute  = qcc::execute;
      }
    ;

// PROJ-1502 PARTITIONED DISK TABLE
get_partcondval_statement
    : TR_VALUES part_key_cond_list
      {
          QCP_STRUCT_ALLOC($<partCondValParseTree>$, qdPartCondValParseTree);
          $<partCondValParseTree>$->partKeyCond = $<valueNode>2;

          $<partCondValParseTree>$->common.parse    = qcc::parseError;
          $<partCondValParseTree>$->common.validate = qcc::validate;
          $<partCondValParseTree>$->common.optimize = qcc::optimize;
          $<partCondValParseTree>$->common.execute  = qcc::execute;
      }
    | TR_VALUES TR_DEFAULT
      {
          QCP_STRUCT_ALLOC($<partCondValParseTree>$, qdPartCondValParseTree);
          $<partCondValParseTree>$->partKeyCond = NULL;

          $<partCondValParseTree>$->common.parse    = qcc::parseError;
          $<partCondValParseTree>$->common.validate = qcc::validate;
          $<partCondValParseTree>$->common.optimize = qcc::optimize;
          $<partCondValParseTree>$->common.execute  = qcc::execute;
      }
    ;

get_condition_statement
    : TR_RETURN expression
      {
          QCP_STRUCT_ALLOC($<defaultParseTree>$, qdDefaultParseTree);

          $<defaultParseTree>$->defaultValue = $<expression>2[0];
          $<defaultParseTree>$->lastNode = $<expression>2[1];
// BUG-24087
// ν  insert  default valueó
// SYSDATE columnID ϴ  ϴ  .

          $<defaultParseTree>$->common.parse    = qcc::parseError;
          $<defaultParseTree>$->common.validate = qcc::validate;
          $<defaultParseTree>$->common.optimize = qcc::optimize;
          $<defaultParseTree>$->common.execute  = qcc::execute;
      }
    ;

get_partial_select_statement
    : TR_MODIFY select_or_with_select_statement
      {
          $<selectParseTree>$ = $<selectParseTree>2;        
      }

get_partial_where_clause
    : TR_WHERE expression
      {
          QCP_STRUCT_ALLOC( $<selectParseTree>$, qmsParseTree );
          QC_SET_INIT_PARSE_TREE( $<selectParseTree>$, $<position>1 );

          QCP_STRUCT_ALLOC( $<selectParseTree>$->querySet, qmsQuerySet );
          QCP_SET_INIT_QMS_QUERY_SET( $<selectParseTree>$->querySet );

          QCP_STRUCT_ALLOC( $<selectParseTree>$->querySet->SFWGH, qmsSFWGH );
          QCP_SET_INIT_QMS_SFWGH( $<selectParseTree>$->querySet->SFWGH );

          $<selectParseTree>$->querySet->SFWGH->where = $<expression>2[0];
      }

get_target_list_statement
    : TR_BACKUP order_to_select_sublist_commalist
      {
          qmsQuerySet * sQuerySet;

          QCP_STRUCT_ALLOC(sQuerySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET(sQuerySet);

          sQuerySet->setOp  = QMS_NONE;
          sQuerySet->SFWGH  = NULL;
          sQuerySet->target = $<target>2; 

          QCP_STRUCT_ALLOC($<selectParseTree>$, qmsParseTree);

          $<selectParseTree>$->querySet = sQuerySet;
      }
    ;

order_to_select_sublist_commalist
    : order_to_select_sublist_commalist TS_COMMA select_sublist opt_sort_mode
      {
          qmsTarget * sLast;

          $<target>$ = $<target>1;
          
          for (sLast = $<target>$; sLast->next != NULL; sLast = sLast->next) ;
          
          sLast->next = $<target>3;
          sLast->targetColumn->node.next =
              (mtcNode *)($<target>3->targetColumn);
      }
    | select_sublist opt_sort_mode
      {
          $<target>$ = $<target>1;
      }
    ;

/* BUG-21387 COMMENT */
comment_statement
    : TR_COMMENT TR_ON TR_TABLE TI_IDENTIFIER TR_IS TL_LITERAL
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<commentParseTree>$, qdCommentParseTree);
          QC_SET_INIT_PARSE_TREE($<commentParseTree>$, $<position>1);

          // TABLE Name
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_EMPTY_POSITION($<commentParseTree>$->userName);
          SET_POSITION(      $<commentParseTree>$->tableName,  $<position>4);
          SET_EMPTY_POSITION($<commentParseTree>$->columnName);
          SET_POSITION(      $<commentParseTree>$->comment,    $<position>6);

          $<commentParseTree>$->comment.offset += 1;
          $<commentParseTree>$->comment.size   -= 2;

          $<commentParseTree>$->common.parse    = qcc::parse;
          $<commentParseTree>$->common.validate = qdbComment::validateCommentTable;
          $<commentParseTree>$->common.optimize = qcc::optimize;
          $<commentParseTree>$->common.execute  = qdbComment::executeCommentTable;
      }
    | TR_COMMENT TR_ON TR_TABLE TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TR_IS TL_LITERAL
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<commentParseTree>$, qdCommentParseTree);
          QC_SET_INIT_PARSE_TREE($<commentParseTree>$, $<position>1);

          // User Name
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // Table Name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION(      $<commentParseTree>$->userName,   $<position>4);
          SET_POSITION(      $<commentParseTree>$->tableName,  $<position>6);
          SET_EMPTY_POSITION($<commentParseTree>$->columnName);
          SET_POSITION(      $<commentParseTree>$->comment,    $<position>8);

          $<commentParseTree>$->comment.offset += 1;
          $<commentParseTree>$->comment.size   -= 2;

          $<commentParseTree>$->common.parse    = qcc::parse;
          $<commentParseTree>$->common.validate = qdbComment::validateCommentTable;
          $<commentParseTree>$->common.optimize = qcc::optimize;
          $<commentParseTree>$->common.execute  = qdbComment::executeCommentTable;
      }
    | TR_COMMENT TR_ON TR_COLUMN TI_IDENTIFIER TS_PERIOD column_name TR_IS TL_LITERAL
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<commentParseTree>$, qdCommentParseTree);
          QC_SET_INIT_PARSE_TREE($<commentParseTree>$, $<position>1);

          // Table Name
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // Column Name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_EMPTY_POSITION($<commentParseTree>$->userName);
          SET_POSITION(      $<commentParseTree>$->tableName,  $<position>4);
          SET_POSITION(      $<commentParseTree>$->columnName, $<position>6);
          SET_POSITION(      $<commentParseTree>$->comment,    $<position>8);

          $<commentParseTree>$->comment.offset += 1;
          $<commentParseTree>$->comment.size   -= 2;

          $<commentParseTree>$->common.parse    = qcc::parse;
          $<commentParseTree>$->common.validate = qdbComment::validateCommentColumn;
          $<commentParseTree>$->common.optimize = qcc::optimize;
          $<commentParseTree>$->common.execute  = qdbComment::executeCommentColumn;
      }
    | TR_COMMENT TR_ON TR_COLUMN TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TS_PERIOD column_name TR_IS TL_LITERAL
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<commentParseTree>$, qdCommentParseTree);
          QC_SET_INIT_PARSE_TREE($<commentParseTree>$, $<position>1);

          // User Name
          if ($<position>4.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>4 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // Table Name
          if ($<position>6.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>6 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // Column Name
          if ($<position>8.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>8 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          SET_POSITION($<commentParseTree>$->userName,   $<position>4);
          SET_POSITION($<commentParseTree>$->tableName,  $<position>6);
          SET_POSITION($<commentParseTree>$->columnName, $<position>8);
          SET_POSITION($<commentParseTree>$->comment,    $<position>10);

          $<commentParseTree>$->comment.offset += 1;
          $<commentParseTree>$->comment.size -= 2;

          $<commentParseTree>$->common.parse    = qcc::parse;
          $<commentParseTree>$->common.validate = qdbComment::validateCommentColumn;
          $<commentParseTree>$->common.optimize = qcc::optimize;
          $<commentParseTree>$->common.execute  = qdbComment::executeCommentColumn;
      }
    ;

/*****************************************
 * DML
 ****************************************/
delete_statement
    : TR_DELETE opt_hints dml_table_reference opt_as_name opt_where_clause opt_return_clause opt_limit_clause
      {
          QCP_STRUCT_ALLOC($<delParseTree>$, qmmDelParseTree);
          QC_SET_INIT_PARSE_TREE($<delParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<delParseTree>$->common.stmtPos );

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<delParseTree>$->querySet);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<delParseTree>$->querySet->SFWGH);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH->from, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<delParseTree>$->querySet->SFWGH->from);

          // PROJ-2204 JOIN UPDATE, DELETE
          $<delParseTree>$->querySet->SFWGH->from->tableRef = $<tableRef>3;
          $<delParseTree>$->querySet->SFWGH->thisQuerySet = $<delParseTree>$->querySet;

          // HINTS
          $<delParseTree>$->querySet->SFWGH->hints = $<hints>2;

          // FROM clause
          SET_POSITION(
              $<delParseTree>$->querySet->SFWGH->from->tableRef->aliasName,
              $<position>4);

          // WHERE clause
          $<delParseTree>$->querySet->SFWGH->where = $<expression>5[0];

          $<delParseTree>$->querySet->SFWGH->startPos = $<position>1;

          $<delParseTree>$->deleteTableRef = NULL;

          // PROJ-1584 DML Return Clause
          $<delParseTree>$->returnInto = $<dmlReturnInto>6;

          // To Fix PR-12917
          $<delParseTree>$->limit = $<limit>7;
          $<delParseTree>$->mTableList = NULL;
          $<delParseTree>$->mDelList = NULL;

          // function pointer
          $<delParseTree>$->common.parse    = qmv::parseDelete;
          $<delParseTree>$->common.validate = qmv::validateDelete;
          $<delParseTree>$->common.optimize = qmo::optimizeDelete;
          $<delParseTree>$->common.execute  = qmx::executeDelete;
      }
    | TR_DELETE opt_hints TR_FROM dml_table_reference opt_as_name opt_where_clause opt_return_clause opt_limit_clause
      {
          QCP_STRUCT_ALLOC($<delParseTree>$, qmmDelParseTree);
          QC_SET_INIT_PARSE_TREE($<delParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<delParseTree>$->common.stmtPos );

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<delParseTree>$->querySet);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<delParseTree>$->querySet->SFWGH);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH->from, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<delParseTree>$->querySet->SFWGH->from);

          // PROJ-2204 JOIN UPDATE, DELETE
          $<delParseTree>$->querySet->SFWGH->from->tableRef = $<tableRef>4;
          $<delParseTree>$->querySet->SFWGH->thisQuerySet = $<delParseTree>$->querySet;

          // HINTS
          $<delParseTree>$->querySet->SFWGH->hints = $<hints>2;

          // FROM clause
          SET_POSITION(
              $<delParseTree>$->querySet->SFWGH->from->tableRef->aliasName,
              $<position>5);

          // WHERE clause
          $<delParseTree>$->querySet->SFWGH->where = $<expression>6[0];

          $<delParseTree>$->querySet->SFWGH->startPos = $<position>1;

          $<delParseTree>$->deleteTableRef = NULL;

          // PROJ-1584 DML Return Clause
          $<delParseTree>$->returnInto = $<dmlReturnInto>7;

          // To Fix PR-12917
          $<delParseTree>$->limit = $<limit>8;
          $<delParseTree>$->mTableList = NULL;
          $<delParseTree>$->mDelList = NULL;

          // function pointer
          $<delParseTree>$->common.parse    = qmv::parseDelete;
          $<delParseTree>$->common.validate = qmv::validateDelete;
          $<delParseTree>$->common.optimize = qmo::optimizeDelete;
          $<delParseTree>$->common.execute  = qmx::executeDelete;
      }
    | TR_DELETE opt_hints TR_FROM name_list TR_USING dml_table_commalist opt_where_clause opt_limit_clause
      {
          qcuSqlSourceInfo    sqlInfo;
          QCP_STRUCT_ALLOC($<delParseTree>$, qmmDelParseTree);
          QC_SET_INIT_PARSE_TREE($<delParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<delParseTree>$->common.stmtPos );

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<delParseTree>$->querySet);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<delParseTree>$->querySet->SFWGH);

          // PROJ-2204 JOIN UPDATE, DELETE
          $<delParseTree>$->querySet->SFWGH->thisQuerySet = $<delParseTree>$->querySet;

          $<delParseTree>$->querySet->SFWGH->from = $<from>6;

          // HINTS
          $<delParseTree>$->querySet->SFWGH->hints = $<hints>2;

          // WHERE clause
          $<delParseTree>$->querySet->SFWGH->where = $<expression>7[0];

          $<delParseTree>$->querySet->SFWGH->startPos = $<position>1;

          $<delParseTree>$->deleteTableRef = NULL;

          // PROJ-1584 DML Return Clause
          $<delParseTree>$->returnInto = NULL;

          // To Fix PR-12917
          $<delParseTree>$->limit = $<limit>8;;
          $<delParseTree>$->mTableList = NULL;
          $<delParseTree>$->mDelList = $<delNameList>4;

          if ( ( $<delParseTree>$->querySet->SFWGH->from->next == NULL ) &&
               ( $<delParseTree>$->querySet->SFWGH->from->joinType == QMS_NO_JOIN ) )
          {
              // function pointer
              $<delParseTree>$->common.parse    = qmv::parseDelete;
              $<delParseTree>$->common.validate = qmv::validateDelete;
              $<delParseTree>$->common.optimize = qmo::optimizeDelete;
              $<delParseTree>$->common.execute  = qmx::executeDelete;
          }
          else
          {
              if ( $<delParseTree>$->limit != NULL )
              {
                   sqlInfo.setSourceInfo(STATEMENT, & $<position>8 );
                   sqlInfo.init(MEMORY);
                   IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ));
                   sqlInfo.fini();
                   YYABORT;
              }
              // function pointer
              $<delParseTree>$->common.parse    = qmv::parseMultiDelete;
              $<delParseTree>$->common.validate = qmv::validateMultiDelete;
              $<delParseTree>$->common.optimize = qmo::optimizeMultiDelete;
              $<delParseTree>$->common.execute  = qmx::executeMultiDelete;
          }
      }
    | TR_DELETE opt_hints name_list TR_FROM dml_table_commalist opt_where_clause opt_return_clause opt_limit_clause
      {
          qcuSqlSourceInfo    sqlInfo;
          QCP_STRUCT_ALLOC($<delParseTree>$, qmmDelParseTree);
          QC_SET_INIT_PARSE_TREE($<delParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<delParseTree>$->common.stmtPos );

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<delParseTree>$->querySet);

          QCP_STRUCT_ALLOC($<delParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<delParseTree>$->querySet->SFWGH);

          // PROJ-2204 JOIN UPDATE, DELETE
          $<delParseTree>$->querySet->SFWGH->thisQuerySet = $<delParseTree>$->querySet;

          $<delParseTree>$->querySet->SFWGH->from = $<from>5;

          // HINTS
          $<delParseTree>$->querySet->SFWGH->hints = $<hints>2;

          // WHERE clause
          $<delParseTree>$->querySet->SFWGH->where = $<expression>6[0];

          $<delParseTree>$->querySet->SFWGH->startPos = $<position>1;

          $<delParseTree>$->deleteTableRef = NULL;

          // PROJ-1584 DML Return Clause
          $<delParseTree>$->returnInto = $<dmlReturnInto>7;

          // To Fix PR-12917
          $<delParseTree>$->limit = $<limit>8;;
          $<delParseTree>$->mTableList = NULL;
          $<delParseTree>$->mDelList = $<delNameList>3;

          if ( ( $<delParseTree>$->querySet->SFWGH->from->next == NULL ) &&
               ( $<delParseTree>$->querySet->SFWGH->from->joinType == QMS_NO_JOIN ) )
          {
              // function pointer
              $<delParseTree>$->common.parse    = qmv::parseDelete;
              $<delParseTree>$->common.validate = qmv::validateDelete;
              $<delParseTree>$->common.optimize = qmo::optimizeDelete;
              $<delParseTree>$->common.execute  = qmx::executeDelete;
          }
          else
          {
              if ( $<delParseTree>$->returnInto != NULL )
              {
                   sqlInfo.setSourceInfo(STATEMENT, & $<position>7 );
                   sqlInfo.init(MEMORY);
                   IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ));
                   sqlInfo.fini();
                   YYABORT;
              }
              if ( $<delParseTree>$->limit != NULL )
              {
                   sqlInfo.setSourceInfo(STATEMENT, & $<position>8 );
                   sqlInfo.init(MEMORY);
                   IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ));
                   sqlInfo.fini();
                   YYABORT;
              }
              // function pointer
              $<delParseTree>$->common.parse    = qmv::parseMultiDelete;
              $<delParseTree>$->common.validate = qmv::validateMultiDelete;
              $<delParseTree>$->common.optimize = qmo::optimizeMultiDelete;
              $<delParseTree>$->common.execute  = qmx::executeMultiDelete;
          }
      }
    ;

name_list
    : name_list TS_COMMA del_name
      {
          qcNamePosList * sLast;

          $<delNameList>$ = $<delNameList>1;
            
          for ( sLast = $<delNameList>$;
                sLast->next != NULL;
                sLast = sLast->next );
          sLast->next = $<delNameList>3;
      }
    | del_name
      {
          $<delNameList>$ = $<delNameList>1;
      }
    ;

del_name
    : TI_IDENTIFIER
      {
          QCP_STRUCT_ALLOC($<delNameList>$, qcNamePosList);
          
          SET_POSITION( $<delNameList>$->namePos, $<position>1 );
          $<delNameList>$->next = NULL;
      }
    ;


/* PROJ-1584 DML Returning Clause */
/* RETURN or RETURNING */

opt_return_clause
    : /* empty */
      {
          $<dmlReturnInto>$ = NULL;
      }
     | return_or_returning return_specification_commalist opt_bulk TR_INTO into_variable_commalist
      {
      
          QCP_STRUCT_ALLOC( $<dmlReturnInto>$, qmmReturnInto );
 
          $<dmlReturnInto>$->returnValue     = $<dmlReturnValue>2;
          $<dmlReturnInto>$->bulkCollect     = $<dmlBulkCollect>3;
          $<dmlReturnInto>$->returnIntoValue = $<dmlReturnIntoValue>5;
          
          SET_POSITION( $<dmlReturnInto>$->returnIntoValuePos, 
                        $<position>1 );
      }
     ;

/* BULK COLLECT ... */
opt_bulk
     : // empty
       {
           idBool  bulkCollect;
           bulkCollect = ID_FALSE;
          $<dmlBulkCollect>$ = bulkCollect;
       }
     | TA_BULK TI_NONQUOTED_IDENTIFIER
       {
           idBool              bulkCollect;
           qcuSqlSourceInfo    sqlInfo;
 
           if (idlOS::strMatch(
                 "COLLECT", 7,
                 QTEXT+$<position>2.offset, $<position>2.size) != 0)
           {
               sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
               sqlInfo.init(MEMORY);
               IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ));
               sqlInfo.fini();
               YYABORT;
           }

           bulkCollect = ID_TRUE;
          $<dmlBulkCollect>$ = bulkCollect;
       }
     ;



return_or_returning
    : TR_RETURN
      {
          /* nothing to do */
      }      
    | TR_RETURNING
      {
          /* nothing to do */
      }
    ;

return_specification_commalist
    : return_specification_commalist TS_COMMA return_specification      
      {
          qmmReturnValue * sLast;

          $<dmlReturnValue>$ = $<dmlReturnValue>1;
          
          for ( sLast = $<dmlReturnValue>$;
                sLast->next != NULL; 
                sLast = sLast->next ) ;
          sLast->next = $<dmlReturnValue>3;
      }
    | return_specification
      {
          $<dmlReturnValue>$ = $<dmlReturnValue>1;
      }
    ;

return_specification
    : arithmetic_expression
      {
          QCP_STRUCT_ALLOC($<dmlReturnValue>$, qmmReturnValue);

          $<dmlReturnValue>$->returnExpr = $<expression>1[0];
          $<dmlReturnValue>$->next       = NULL;
 
          SET_POSITION( $<dmlReturnValue>$->returningPos,
                        $<position>1 );
      }
    ;

/* RETURN .... INTO ... */
into_variable_commalist
    : into_variable_commalist TS_COMMA into_variable
      {
          qmmReturnIntoValue * sLast;

          $<dmlReturnIntoValue>$ = $<dmlReturnIntoValue>1;
          
          for ( sLast = $<dmlReturnIntoValue>$;
                sLast->next != NULL;                 
                sLast = sLast->next ) ;
          sLast->next = $<dmlReturnIntoValue>3;
      }
    | into_variable
      {
          $<dmlReturnIntoValue>$ = $<dmlReturnIntoValue>1;
      }      
    ;

host_variable
    : TS_QUESTION_MARK
      {
          /* Nothing to do. */
      }
    | TI_HOSTVARIABLE
      {
          /* Nothing to do. */
      }
    ;

into_variable
    : host_variable
      {     
          qtcNode * sNode[2];

          QCP_STRUCT_ALLOC( $<dmlReturnIntoValue>$, qmmReturnIntoValue );

          QCP_TEST( qtc::makeVariable( STATEMENT, sNode,
                                       &($<position>1) )
                                       != IDE_SUCCESS );

          $<dmlReturnIntoValue>$->returningInto  = sNode[0];
          $<dmlReturnIntoValue>$->next           = NULL;

          SET_POSITION( $<dmlReturnIntoValue>$->returningIntoPos,
                        $<position>1 );

      }
    | SP_variable_name
      {     
          QCP_STRUCT_ALLOC( $<dmlReturnIntoValue>$, qmmReturnIntoValue );
                              
          $<dmlReturnIntoValue>$->returningInto  = $<expression>1[0];
          $<dmlReturnIntoValue>$->next           = NULL; 
      }     
    ;

/* PROJ-2204 join update,delete */
dml_table_reference
    : user_object_name opt_partition_name
      {    
            QCP_STRUCT_ALLOC($<tableRef>$, qmsTableRef);
            QCP_SET_INIT_QMS_TABLE_REF($<tableRef>$);

            /* set userName position */
            SET_POSITION($<tableRef>$->userName,
                         $<userNObjName>1->userName);
            /* set tableName position */
            SET_POSITION($<tableRef>$->tableName,
                         $<userNObjName>1->objectName);
            /* set aliasName position */
            SET_POSITION($<tableRef>$->aliasName,
                         $<userNObjName>1->objectName);
            
            /* PROJ-1502 PARTITIONED DISK TABLE */
            $<tableRef>$->partitionRef = $<partitionRef>2;

            // dml_table_reference position Ѵ.
            if ( QC_IS_NULL_NAME( $<userNObjName>1->userName ) != ID_TRUE )
            {
                QCP_ADD_POSITION($<tableRef>$->position,
                                 $<userNObjName>1->userName,
                                 $<userNObjName>1->objectName);
            }
            else
            {
                SET_POSITION($<tableRef>$->position, $<userNObjName>1->objectName);
            }

            if ( $<tableRef>$->partitionRef != NULL )
            {
                $<tableRef>$->position.size =
                    $<tableRef>$->partitionRef->position.offset +
                    $<tableRef>$->partitionRef->position.size -
                    $<tableRef>$->position.offset;
            }
      }
      | TS_OPENING_PARENTHESIS select_or_with_select_statement TS_CLOSING_PARENTHESIS
      {
            qcStatement   * sStatement;

            QCP_STRUCT_ALLOC($<tableRef>$, qmsTableRef);
            QCP_SET_INIT_QMS_TABLE_REF($<tableRef>$);
            
            /* select_statement */
            QCP_STRUCT_ALLOC(sStatement, qcStatement);
            QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>2)
                sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          
            /* view */
            $<tableRef>$->view = sStatement;
      }
      ;

insert_statement
    : TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name TR_DEFAULT TR_VALUES opt_return_clause opt_wait_clause
      {
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          /* TASK-7219 Shard Transformer Refactoring */
          if ( $<uLongVal>9 != (ULong)( ID_ULONG_MAX ) )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;
          
          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;

          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);
          
          $<insParseTree>$->columns = NULL;
          $<insParseTree>$->rows    = NULL;
          $<insParseTree>$->select  = NULL;
          // BUG-46174
          $<insParseTree>$->spVariable = NULL;
          
          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = $<dmlReturnInto>8;

          $<insParseTree>$->outerQuerySet = NULL;
          
          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;

          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = $<uLongVal>9;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          // function pointer
          $<insParseTree>$->common.parse    = qmv::parseInsertAllDefault;
          $<insParseTree>$->common.validate = qmv::validateInsertAllDefault;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertValues;
      }
      | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name opt_table_column_commalist
        TR_VALUES
        SP_variable_name opt_return_clause opt_wait_clause
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<dmlReturnInto>9 == NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;
          
          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;

          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);

          if ( $<columnDef>6 != NULL )
          {
              // syntax error
              sqlInfo.setSourceInfo( STATEMENT, &($<columnDef>6->namePos) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }

          $<insParseTree>$->columns = $<columnDef>6;
          $<insParseTree>$->rows    = NULL;
          $<insParseTree>$->select  = NULL;

          // BUG-46174
          QCP_STRUCT_ALLOC( $<insParseTree>$->rows, qmmMultiRows );
          $<insParseTree>$->rows->values       = NULL; 
          $<insParseTree>$->rows->next         = NULL;

          $<insParseTree>$->spVariable = $<expression>8[0];
          $<insParseTree>$->spVariable->lflag &= ~QTC_NODE_SP_INS_UPT_VALUE_REC_MASK;
          $<insParseTree>$->spVariable->lflag |= QTC_NODE_SP_INS_UPT_VALUE_REC_TRUE; 

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = $<dmlReturnInto>9;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
     
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = $<uLongVal>10;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;

          $<insParseTree>$->common.parse    = qmv::parseInsertValues;
          $<insParseTree>$->common.validate = qmv::validateInsertValues;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertValues;
      }
    | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name opt_table_column_commalist
        TR_VALUES
        multi_rows_list opt_return_clause opt_wait_clause
      {
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<dmlReturnInto>9 == NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;
          
          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;

          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);

          $<insParseTree>$->columns = $<columnDef>6;
          $<insParseTree>$->rows    = $<multiRows>8;
          $<insParseTree>$->select  = NULL;
          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = $<dmlReturnInto>9;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
     
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = $<uLongVal>10;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;

          $<insParseTree>$->common.parse    = qmv::parseInsertValues;
          $<insParseTree>$->common.validate = qmv::validateInsertValues;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertValues;
      }
    | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name
      select_or_with_select_statement opt_for_update_clause
      {
          qcStatement       * sStatement;
          
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<forUpdate>7 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;
          
          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);
          
          $<insParseTree>$->columns = NULL;
          $<insParseTree>$->rows = NULL;

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          // select_statement
          $<selectParseTree>6->forUpdate = $<forUpdate>7;
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>6)
          $<insParseTree>$->select = sStatement;
          $<insParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          if ( $<selectParseTree>6->forUpdate == NULL )
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          if ( $<forUpdate>7 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }

          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
          
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          $<insParseTree>$->common.parse    = qmv::parseInsertSelect;
          $<insParseTree>$->common.validate = qmv::validateInsertSelect;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertSelect;
      }
    | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name
      shard_stmt_spec select_or_with_select_statement opt_for_update_clause
      {
          qcStatement       * sStatement;
          
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<forUpdate>8 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;
          
          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);
          
          $<insParseTree>$->columns = NULL;
          $<insParseTree>$->rows = NULL;

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          // select_statement
          $<selectParseTree>7->forUpdate = $<forUpdate>8;
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>7);
          // set shard statement
          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              sStatement->myPlan->parseTree->stmtShard = $<shardStmtSpec>6.shardType;
              sStatement->myPlan->parseTree->nodes = $<shardStmtSpec>6.nodes;
          }
          $<insParseTree>$->select = sStatement;
          $<insParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          if ( $<selectParseTree>7->forUpdate == NULL )
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          if ( $<forUpdate>8 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }

          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
          
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          $<insParseTree>$->common.parse    = qmv::parseInsertSelect;
          $<insParseTree>$->common.validate = qmv::validateInsertSelect;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertSelect;
      }
    | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name
        TS_OPENING_PARENTHESIS table_column_commalist TS_CLOSING_PARENTHESIS
        select_or_with_select_statement opt_for_update_clause
      {
          qcStatement       * sStatement;

          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<forUpdate>10 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;
          
          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);
          
          $<insParseTree>$->columns = $<columnDef>7;
          $<insParseTree>$->rows    = NULL;

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          // select_statement
          $<selectParseTree>9->forUpdate = $<forUpdate>10;
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>9)
          $<insParseTree>$->select = sStatement;
          $<insParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          if ( $<selectParseTree>9->forUpdate == NULL )
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          if ( $<forUpdate>10 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }

          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
          
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          $<insParseTree>$->common.parse    = qmv::parseInsertSelect;
          $<insParseTree>$->common.validate = qmv::validateInsertSelect;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertSelect;
      }
    | TR_INSERT opt_hints TR_INTO dml_table_reference opt_as_name
        TS_OPENING_PARENTHESIS table_column_commalist TS_CLOSING_PARENTHESIS
        shard_stmt_spec select_or_with_select_statement opt_for_update_clause
      {
          qcStatement       * sStatement;

          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          if ( $<forUpdate>11 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->common.stmtPos );
          }

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>4;

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->queueMsgIDSeq = NULL;
          
          // PROJ-1566
          $<insParseTree>$->hints = $<hints>2;

          SET_POSITION(
          $<insParseTree>$->tableRef->aliasName,
          $<position>5);
          
          $<insParseTree>$->columns = $<columnDef>7;
          $<insParseTree>$->rows    = NULL;

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;
          
          $<insParseTree>$->outerQuerySet = NULL;
          
          // select_statement
          $<selectParseTree>10->forUpdate = $<forUpdate>11;
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>10);

          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              sStatement->myPlan->parseTree->stmtShard = $<shardStmtSpec>9.shardType;
              sStatement->myPlan->parseTree->nodes = $<shardStmtSpec>9.nodes;
          }
          $<insParseTree>$->select = sStatement;
          $<insParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          if ( $<selectParseTree>10->forUpdate == NULL )
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          if ( $<forUpdate>11 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }

          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
          
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;
          
          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          $<insParseTree>$->common.parse    = qmv::parseInsertSelect;
          $<insParseTree>$->common.validate = qmv::validateInsertSelect;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertSelect;
      }
    | TR_INSERT opt_hints TR_ALL multi_insert_value_list
        select_or_with_select_statement opt_for_update_clause
      {
          qcStatement       * sStatement;
          qmmInsParseTree   * sCurr;

          $<insParseTree>$ = $<insParseTree>4;

          // set statement position
          for ( sCurr = $<insParseTree>$; sCurr != NULL; sCurr = sCurr->next )
          {
              QC_SET_INIT_PARSE_TREE(sCurr, $<position>1);
              // set size of statement
              if ( $<forUpdate>6 != NULL )
              {
                  QCP_ADJUST_END_POSITION( sCurr->common.stmtPos );
              }
              else
              {
                  QCP_ADJUST_LAST_POSITION( sCurr->common.stmtPos );
              }
          }

          // hint 
          // append hint  ̹Ƿ qmsHints ʹ  ʴ´.
          if ( $<hints>2 != NULL )
          {
              for ( sCurr = $<insParseTree>$; sCurr != NULL; sCurr = sCurr->next )
              {
                  QCP_STRUCT_ALLOC(sCurr->hints, qmsHints);
                  idlOS::memcpy( sCurr->hints, $<hints>2, ID_SIZEOF(qmsHints) );
              }
          }
          
          // BUG-36596 multi-table insert
          // select_statement
          $<selectParseTree>5->forUpdate = $<forUpdate>6;
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>5)
          $<insParseTree>$->select = sStatement;
          $<insParseTree>$->select->myPlan->parseTree->stmt = sStatement;
          if ( $<selectParseTree>5->forUpdate == NULL )
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
          }
          else
          {
              $<insParseTree>$->select->myPlan->parseTree->stmtKind = QCI_STMT_SELECT_FOR_UPDATE;
          }
          // set size of select_statement
          if ( $<forUpdate>6 != NULL )
          {
              QCP_ADJUST_END_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }
          else
          {
              QCP_ADJUST_LAST_POSITION( $<insParseTree>$->select->myPlan->parseTree->stmtPos );
          }

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          $<insParseTree>$->common.parse    = qmv::parseMultiInsertSelect;
          $<insParseTree>$->common.validate = qmv::validateMultiInsertSelect;
          $<insParseTree>$->common.optimize = qmo::optimizeMultiInsertSelect;
          $<insParseTree>$->common.execute  = qmx::executeMultiInsertSelect;
      }
    ;

multi_insert_value_list
    : multi_insert_value_list multi_insert_value
      {
          qmmInsParseTree * sLast;

          for( sLast= $<insParseTree>1; sLast->next != NULL; sLast= sLast->next );
          sLast->next = $<insParseTree>2;

          $<insParseTree>$ = $<insParseTree>1;
      }
    | multi_insert_value
      {
          $<insParseTree>$ = $<insParseTree>1;
      }
    ;

multi_insert_value
    : TR_INTO dml_table_reference opt_table_column_commalist
        TR_VALUES
      TS_OPENING_PARENTHESIS insert_atom_commalist TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);

          $<insParseTree>$->flag = QMM_MULTI_INSERT_TRUE;
          
          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->tableRef = $<tableRef>2;
          
          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // Proj-1360 Queue
          $<insParseTree>$->queueMsgIDSeq = NULL;

          // PROJ-1566
          $<insParseTree>$->hints = NULL;
          
          $<insParseTree>$->columns = $<columnDef>3;
          $<insParseTree>$->select = NULL;

          QCP_STRUCT_ALLOC($<insParseTree>$->rows, qmmMultiRows);
          $<insParseTree>$->rows->values       = $<valueNode>6;
          $<insParseTree>$->rows->next         = NULL;

          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;
          
          $<insParseTree>$->outerQuerySet = NULL;

          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();
          
          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef    = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;

          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;

          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
     
          $<insParseTree>$->common.parse    = qcc::parseError;
          $<insParseTree>$->common.validate = qcc::validate;
          $<insParseTree>$->common.optimize = qcc::optimize;
          $<insParseTree>$->common.execute  = qcc::execute;
      }
    ;

insert_atom_commalist
    : insert_atom_commalist TS_COMMA insert_atom
      {
          qmmValueNode * sLast;

          for( sLast= $<valueNode>1; sLast->next != NULL; sLast= sLast->next ) ;
          sLast->next = $<valueNode>3;

          $<valueNode>$ = $<valueNode>1;
      }
    | insert_atom
      {
          $<valueNode>$ = $<valueNode>1;
      }
    ;

insert_atom
    : arithmetic_expression
      {
          /* BUGBUG: ASSAM ( )  not including */
          QCP_STRUCT_ALLOC($<valueNode>$, qmmValueNode);
          $<valueNode>$->value    = $<expression>1[0];
          $<valueNode>$->validate = ID_TRUE;
          $<valueNode>$->timestamp = ID_FALSE;
          $<valueNode>$->expand    = ID_FALSE;
          $<valueNode>$->msgID     = ID_FALSE;
          $<valueNode>$->next     = NULL;
      }
    | TR_DEFAULT
      {
          QCP_STRUCT_ALLOC($<valueNode>$, qmmValueNode);
          $<valueNode>$->value    = NULL;
          $<valueNode>$->validate = ID_TRUE;
          $<valueNode>$->timestamp = ID_FALSE;
          $<valueNode>$->expand    = ID_FALSE;
          $<valueNode>$->msgID     = ID_FALSE;
          $<valueNode>$->next     = NULL;
      }
    ;

multi_rows_list
    : multi_rows_list TS_COMMA one_row
      {
          qmmMultiRows * sLast;

          for ( sLast = $<multiRows>1; sLast->next != NULL; sLast = sLast->next );
          sLast->next = $<multiRows>3;

          $<multiRows>$ = $<multiRows>1;
      }
    | one_row
      {
          $<multiRows>$ = $<multiRows>1;
      }
    ;

one_row
    : TS_OPENING_PARENTHESIS insert_atom_commalist TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC( $<multiRows>$, qmmMultiRows );
          $<multiRows>$->values       = $<valueNode>2;
          $<multiRows>$->next         = NULL;
      }
    ;

dml_table_commalist
    : dml_table_commalist TS_COMMA dml_table
      {
          qmsFrom * sLast;

          $<from>$ = $<from>1;
          for (sLast = $<from>$; sLast->next != NULL; sLast = sLast->next);
          sLast->next = $<from>3;
      }
    | dml_table
      {
          $<from>$ = $<from>1;
      }
    ;

dml_table
    : dml_table_reference opt_as_name
      {
          QCP_STRUCT_ALLOC( $<from>$, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<from>$ );
          $<from>$->tableRef =  $<tableRef>1;

          SET_POSITION( $<from>$->tableRef->aliasName, $<position>2 );
            
          $<from>$->fromPosition.stmtText = QTEXT;
          $<from>$->fromPosition.offset = $<position>1.offset;
          $<from>$->fromPosition.size = $<position>1.size;
      }
    | dml_joined_table
      {
          $<from>$ = $<from>1;
      }
    ;

dml_joined_table
    : dml_table opt_join_type TR_JOIN dml_table TR_ON expression
      {
          QCP_STRUCT_ALLOC( $<from>$, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<from>$ );

          $<from>$->joinType = $<joinType>2;
          $<from>$->left     = $<from>1;
          $<from>$->right    = $<from>4;
          $<from>$->onCondition = $<expression>6[0];

          $<from>$->fromPosition.stmtText = QTEXT;
          $<from>$->fromPosition.offset = $<position>2.offset;
          $<from>$->fromPosition.size = $<position>2.size;
      }
    ;

update_statement
    : TR_UPDATE opt_hints dml_table_commalist
        TR_SET assignment_list
        opt_where_clause
        opt_return_clause
        opt_limit_clause
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<uptParseTree>$, qmmUptParseTree);
          QC_SET_INIT_PARSE_TREE($<uptParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<uptParseTree>$->common.stmtPos );
          QCP_STRUCT_ALLOC($<uptParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<uptParseTree>$->querySet);
          QCP_STRUCT_ALLOC($<uptParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<uptParseTree>$->querySet->SFWGH);

          $<uptParseTree>$->querySet->SFWGH->hints = $<hints>2;
          $<uptParseTree>$->querySet->SFWGH->from = $<from>3;
          $<uptParseTree>$->querySet->SFWGH->thisQuerySet = $<uptParseTree>$->querySet;
          $<uptParseTree>$->updateTableRef = NULL;
          $<uptParseTree>$->updateColumns  = NULL;

          // SET clause
          $<uptParseTree>$->columns     = $<setClause>5.columns;
          $<uptParseTree>$->values      = $<setClause>5.values;
          $<uptParseTree>$->subqueries  = $<setClause>5.subqueries;
          $<uptParseTree>$->lists       = $<setClause>5.lists;
          // BUG-46174
          $<uptParseTree>$->spVariable  = $<setClause>5.spVariable;

          // WHERE clause
          $<uptParseTree>$->querySet->SFWGH->where = $<expression>6[0];

          $<uptParseTree>$->querySet->SFWGH->startPos = $<position>1;

          $<uptParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1584 DML Return Clause */
          $<uptParseTree>$->returnInto = $<dmlReturnInto>7;

          // To Fix PR-12917
          // UPDATE LIMIT
          $<uptParseTree>$->limit = $<limit>8;

          /* PROJ-1107 Check Constraint  */
          $<uptParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<uptParseTree>$->defaultTableRef = NULL;
          $<uptParseTree>$->defaultExprColumns = NULL;
          $<uptParseTree>$->mTableList = NULL;

          if ( ( $<uptParseTree>$->querySet->SFWGH->from->joinType == QMS_NO_JOIN ) &&
               ( $<uptParseTree>$->querySet->SFWGH->from->next == NULL ) )
          {
              // function pointer
              $<uptParseTree>$->common.parse    = qmv::parseUpdate;
              $<uptParseTree>$->common.validate = qmv::validateUpdate;
              $<uptParseTree>$->common.optimize = qmo::optimizeUpdate;
              $<uptParseTree>$->common.execute  = qmx::executeUpdate;
          }
          else
          {
              if ( $<uptParseTree>$->returnInto != NULL )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>7 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              if ( $<uptParseTree>$->limit != NULL )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>8 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              // function pointer
              $<uptParseTree>$->common.parse    = qmv::parseMultiUpdate;
              $<uptParseTree>$->common.validate = qmv::validateMultiUpdate;
              $<uptParseTree>$->common.optimize = qmo::optimizeMultiUpdate;
              $<uptParseTree>$->common.execute  = qmx::executeMultiUpdate;
          }
      }
    ;

// Proj 1360 Queue
enqueue_statement:
    TR_ENQUEUE opt_hints
    TR_INTO
    user_object_name
    opt_table_column_commalist
    TR_VALUES
    TS_OPENING_PARENTHESIS
    insert_atom_commalist
    TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<insParseTree>$, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<insParseTree>$, $<position>1);
          // set size of statement
          QCP_ADJUST_END_POSITION( $<insParseTree>$->common.stmtPos );
          QCP_STRUCT_ALLOC($<insParseTree>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<insParseTree>$->tableRef);
          $<insParseTree>$->flag = 0;
          $<insParseTree>$->flag |= QMM_QUEUE_TRUE;
          $<insParseTree>$->queueMsgIDSeq = NULL;

          // PROJ-1566 : insert  hint 
          // PROJ-1436 : enqueue  hint 
          $<insParseTree>$->hints = $<hints>2;
          
          /* set userName position */
          SET_POSITION($<insParseTree>$->tableRef->userName,
                       $<userNObjName>4->userName);
          /* set tableName position */
          SET_POSITION($<insParseTree>$->tableRef->tableName,
                       $<userNObjName>4->objectName);
          /* set aliasName position */
          SET_POSITION($<insParseTree>$->tableRef->aliasName,
                       $<userNObjName>4->objectName);

          $<insParseTree>$->outerQuerySet = NULL;

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<insParseTree>$->insertTableRef = NULL;
          $<insParseTree>$->insertColumns  = NULL;
          
          // BUG-46174
          $<insParseTree>$->spVariable = NULL;

          /* PROJ-1584 DML Return Clause */
          $<insParseTree>$->returnInto = NULL;

          $<insParseTree>$->columns = $<columnDef>5;
          $<insParseTree>$->select  = NULL;

          QCP_STRUCT_ALLOC($<insParseTree>$->rows, qmmMultiRows);
          $<insParseTree>$->rows->values       = $<valueNode>8;
          $<insParseTree>$->rows->next         = NULL;


          $<insParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<insParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<insParseTree>$->defaultTableRef = NULL;
          $<insParseTree>$->defaultExprColumns = NULL;
          
          // BUG-43063 insert nowait
          $<insParseTree>$->lockWaitMicroSec = ID_ULONG_MAX;

          // BUG-36596 multi-table insert
          $<insParseTree>$->next = NULL;
          
          $<insParseTree>$->common.parse    = qmv::parseInsertValues;
          $<insParseTree>$->common.validate = qmv::validateInsertValues;
          $<insParseTree>$->common.optimize = qmo::optimizeInsert;
          $<insParseTree>$->common.execute  = qmx::executeInsertValues;
      }
    ;
dequeue_statement
    : dequeue_query_term
      {
          QCP_STRUCT_ALLOC($<selectParseTree>$, qmsParseTree);
          QC_SET_INIT_PARSE_TREE($<selectParseTree>$, $<querySet>1->startPos);
          // set size of statement
          QCP_ADJUST_LAST_POSITION( $<selectParseTree>$->common.stmtPos );

          $<selectParseTree>$->withClause = NULL;
          $<selectParseTree>$->querySet   = $<querySet>1;
          $<selectParseTree>$->orderBy    = NULL;
          $<selectParseTree>$->limit      = NULL;
          $<selectParseTree>$->loopNode   = NULL;

          // PROJ-1413
          $<selectParseTree>$->isTransformed = ID_FALSE;
          $<selectParseTree>$->isSiblings    = ID_FALSE;

          // PROJ-2646
          $<selectParseTree>$->isView      = ID_FALSE;
          $<selectParseTree>$->isShardView = ID_FALSE;

          $<selectParseTree>$->common.parse     = qmv::parseSelect;
          $<selectParseTree>$->common.validate  = qmv::validateSelect;
          $<selectParseTree>$->common.optimize  = qmo::optimizeSelect;
          $<selectParseTree>$->common.execute   = qmx::executeSelect;
          $<selectParseTree>$->common.stmt      = STATEMENT;
      }
    ;

dequeue_query_term
    : dequeue_query_spec
      {
          QCP_STRUCT_ALLOC($<querySet>$, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<querySet>$);
          $<querySet>$->setOp  = QMS_NONE;
          $<querySet>$->SFWGH  = $<SFWGH>1;
          $<querySet>$->left   = NULL;
          $<querySet>$->right  = NULL;
          $<querySet>$->target = NULL;
          $<querySet>$->lflag  = 0;

          $<querySet>$->SFWGH->thisQuerySet = $<querySet>$;

          SET_POSITION($<querySet>$->startPos, $<querySet>$->SFWGH->startPos);
          SET_POSITION($<querySet>$->endPos, $<querySet>$->SFWGH->endPos);
      }
    ;

dequeue_query_spec
    : TR_DEQUEUE            // 1
        opt_hints           // 2
        target_list         // 3
        opt_into_list       // 4
        dequeue_from_clause // 5
        opt_where_clause    // 6
      {
          QCP_STRUCT_ALLOC($<SFWGH>$, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<SFWGH>$);

          $<SFWGH>$->hints         = $<hints>2;
          $<SFWGH>$->target        = $<target>3;
          $<SFWGH>$->intoVariables = $<into>4;
          $<SFWGH>$->from          = $<from>5;
          $<SFWGH>$->where         = $<expression>6[0];
          $<SFWGH>$->startPos      = $<position>1;
          // set endPos
          qcpUtil::setLastTokenPosition( PARAM->mLexer,
                                         &($<SFWGH>$->endPos) );
      }
    ;

dequeue_from_clause
    : TR_FROM dequeue_from_table_reference_commalist
      {
          $<from>$ = $<from>2;
          $<from>$->fromPosition = $<position>1;
      }
    ;

dequeue_from_table_reference_commalist
    : dequeue_from_table_reference
      {
          $<from>$ = $<from>1;
      }
    ;

dequeue_from_table_reference
    : TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->userName, $<position>1);
          SET_POSITION($<from>$->tableRef->tableName, $<position>3);
          SET_EMPTY_POSITION($<from>$->tableRef->aliasName);

          $<from>$->tableRef->view             = NULL;
          $<from>$->tableRef->tableInfo        = NULL;
          $<from>$->tableRef->tableHandle      = NULL;
          $<from>$->tableRef->tableAccessHints = NULL;
          $<from>$->tableRef->flag             = 0;
      }
    | TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_EMPTY_POSITION($<from>$->tableRef->userName);
          SET_POSITION($<from>$->tableRef->tableName, $<position>1);
          SET_EMPTY_POSITION($<from>$->tableRef->aliasName);

          $<from>$->tableRef->view = NULL;
          $<from>$->tableRef->tableInfo = NULL;
          $<from>$->tableRef->tableHandle = NULL;
          $<from>$->tableRef->tableAccessHints = NULL;
          $<from>$->tableRef->flag = 0;
      }
    ;

opt_fifo
    : /* empty */
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_FIFO
      {
          $<boolType>$ = ID_TRUE;
      }
    | TR_LIFO
      {
          $<boolType>$ = ID_FALSE;
      }

;

assignment_list
    : assignment_commalist
      {
          $<setClause>$ = $<setClause>1;
      }
    | TR_ROW TS_EQUAL_SIGN arithmetic_expression 
      {
          // BUG-46174
          qtcNode           * sRightNode = NULL;
          qtcNode           * sNode      = NULL;
          qmmValueNode      * sPrevNode  = NULL;
          qmmValueNode      * sValue;
          qcuSqlSourceInfo    sqlInfo;

          // setClause init
          $<setClause>$.columns = NULL;
          $<setClause>$.values = NULL;
          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists = NULL;
          $<setClause>$.spVariable = NULL;

          sRightNode = $<expression>3[0];

          if ( ( sRightNode->node.lflag & MTC_NODE_OPERATOR_MASK ) ==
               MTC_NODE_OPERATOR_LIST )
          {
              // SET ROW = ( :B0, :B1, ..., :Bn );
              if ( STATEMENT->calledByPSMFlag == ID_FALSE )
              {
                  // syntax error
                  // EXECUTE PSM 쿡  ϴ.
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }

              for( sNode = (qtcNode *)sRightNode->node.arguments;
                   sNode != NULL;
                   sNode = (qtcNode *)sNode->node.next )
              {
                  if ( (sNode->node.lflag & MTC_NODE_BIND_MASK)
                       != MTC_NODE_BIND_EXIST )
                  {
                      //  host  Ѵ.
                      sqlInfo.setSourceInfo( STATEMENT, &(sNode->position) );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }

                  QCP_STRUCT_ALLOC(sValue, qmmValueNode);
                  sValue->value     = sNode;
                  sValue->validate  = ID_TRUE;
                  sValue->calculate = ID_TRUE;
                  sValue->timestamp = ID_FALSE;
                  sValue->expand    = ID_FALSE;
                  sValue->next      = NULL;
                  sValue->msgID     = ID_FALSE;

                  if ( sPrevNode == NULL )
                  {
                      $<setClause>$.values = sValue;
                  }
                  else
                  {
                      sPrevNode->next = sValue;
                  }

                  sPrevNode = sValue;
              }

              QCP_STRUCT_ALLOC($<setClause>$.lists, qmmValueNode);
              $<setClause>$.lists->value     = sRightNode;
              $<setClause>$.lists->validate  = ID_TRUE;
              $<setClause>$.lists->calculate = ID_FALSE;
              $<setClause>$.lists->timestamp = ID_FALSE;
              $<setClause>$.lists->expand    = ID_FALSE;
              $<setClause>$.lists->msgID     = ID_FALSE;
              $<setClause>$.lists->next      = NULL;
          }
          else if ( ( sRightNode->node.module == &qtc::columnModule ) ||
                    ( sRightNode->node.module == &qtc::spFunctionCallModule) )
          {

              if ( idlOS::strMatch(
                      QTEXT+$<expression>3[0]->position.offset, 1,
                      "(", 1 ) == 0 )
              {
                  if ( ( STATEMENT->calledByPSMFlag == ID_TRUE ) &&
                       ( (sRightNode->node.lflag & MTC_NODE_BIND_MASK) !=
                         MTC_NODE_BIND_EXIST) )
                  {
                      // ROW = ( :B0 )
                      // EXECUTE PSM 쿡  ϴ.
                      QCP_STRUCT_ALLOC($<setClause>$.values, qmmValueNode);
                      $<setClause>$.values->value     = sRightNode;
                      $<setClause>$.values->validate  = ID_TRUE;
                      $<setClause>$.values->calculate = ID_TRUE;
                      $<setClause>$.values->timestamp = ID_FALSE;
                      $<setClause>$.values->expand    = ID_FALSE;
                      $<setClause>$.values->msgID     = ID_FALSE;
                      $<setClause>$.values->next      = NULL;
                  }
                  else
                  {
                      // UPDATE t1 SET ROW = (variable_name)   syntax error
                      // list 1 ִ  list  .
                      sqlInfo.setSourceInfo( STATEMENT, &($<expression>3[0]->position) );
                      sqlInfo.init( MEMORY );
                      IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                                sqlInfo.getErrMessage() ) );
                      sqlInfo.fini();
                      YYABORT;
                  }
              }
              else
              {
                  // SET ROW = variable_name
                  $<setClause>$.spVariable = $<expression>3[0];

                  $<setClause>$.spVariable->lflag &= ~QTC_NODE_SP_INS_UPT_VALUE_REC_MASK;
                  $<setClause>$.spVariable->lflag |= QTC_NODE_SP_INS_UPT_VALUE_REC_TRUE; 
              }
          }
          else
          {
              sqlInfo.setSourceInfo( STATEMENT, &($<expression>3[0]->position) );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ; 

assignment_commalist
    : assignment_commalist TS_COMMA assignment
      {
          qcmColumn     * sLastColumn;
          qmmValueNode  * sLastValue;
          qmmSubqueries * sLastSubquery;
          qmmValueNode  * sLastList;

          if( $<setClause>1.columns == NULL )
          {
              $<setClause>$.columns = $<setClause>3.columns;
          }
          else
          {
              $<setClause>$.columns = $<setClause>1.columns;
              for( sLastColumn = $<setClause>$.columns;
                   sLastColumn->next != NULL;
                   sLastColumn = sLastColumn->next) ;
              sLastColumn->next = $<setClause>3.columns;
          }

          if( $<setClause>1.values == NULL )
          {
              $<setClause>$.values = $<setClause>3.values;
          }
          else
          {
              $<setClause>$.values = $<setClause>1.values;
              for( sLastValue = $<setClause>$.values;
                   sLastValue->next != NULL;
                   sLastValue = sLastValue->next ) ;
              sLastValue->next = $<setClause>3.values;
          }

          if( $<setClause>1.subqueries == NULL )
          {
              $<setClause>$.subqueries = $<setClause>3.subqueries;
          }
          else
          {
              $<setClause>$.subqueries = $<setClause>1.subqueries;
              for( sLastSubquery = $<setClause>$.subqueries;
                   sLastSubquery->next != NULL;
                   sLastSubquery = sLastSubquery->next ) ;
              sLastSubquery->next = $<setClause>3.subqueries;
          }

          if( $<setClause>1.lists == NULL )
          {
              $<setClause>$.lists = $<setClause>3.lists;
          }
          else
          {
              $<setClause>$.lists = $<setClause>1.lists;
              for( sLastList = $<setClause>$.lists;
                   sLastList->next != NULL;
                   sLastList = sLastList->next ) ;
              sLastList->next = $<setClause>3.lists;
          }

          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    | assignment
      {
          $<setClause>$ = $<setClause>1;
      }
    ;

assignment
    //: TI_IDENTIFIER TS_EQUAL_SIGN arithmetic_expression
    : set_column_def TS_EQUAL_SIGN arithmetic_expression
      {
          $<setClause>$.columns = $<columnDef>1;

          QCP_STRUCT_ALLOC($<setClause>$.values, qmmValueNode);

          $<setClause>$.values->value     = $<expression>3[0];
          $<setClause>$.values->validate  = ID_TRUE;
          $<setClause>$.values->calculate = ID_TRUE;
          $<setClause>$.values->timestamp = ID_FALSE;
          $<setClause>$.values->expand    = ID_FALSE;
          $<setClause>$.values->next      = NULL;
          $<setClause>$.values->msgID     = ID_FALSE;
          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists      = NULL;
          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    | set_column_def TS_EQUAL_SIGN TR_DEFAULT
      {
          $<setClause>$.columns = $<columnDef>1;

          QCP_STRUCT_ALLOC($<setClause>$.values, qmmValueNode);
          $<setClause>$.values->msgID     = ID_FALSE;
          $<setClause>$.values->value     = NULL;
          $<setClause>$.values->validate  = ID_TRUE;
          $<setClause>$.values->calculate = ID_TRUE;
          $<setClause>$.values->timestamp = ID_FALSE;
          $<setClause>$.values->expand    = ID_FALSE;
          $<setClause>$.values->next      = NULL;

          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists      = NULL;
          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    | TS_OPENING_PARENTHESIS assignment_column_comma_list
      TS_CLOSING_PARENTHESIS TS_EQUAL_SIGN arithmetic_expression
      {
          qcmColumn*       sColumn;
          qmmValueNode*    sValue;
          qtcNode*         sRightNode;
          mtcNode*         sNode;
          qmmValuePointer* sValuePointer;
          qmmValuePointer* sLastValuePointer;

          sRightNode = $<expression>5[0];

          if( $<setClause>2.columns->next == NULL )
          {
              $<setClause>2.values->value     = sRightNode;
              $<setClause>2.values->validate  = ID_TRUE;
              $<setClause>2.values->calculate = ID_TRUE;
              $<setClause>2.values->timestamp = ID_FALSE;
              $<setClause>2.values->expand    = ID_FALSE;
              $<setClause>2.values->msgID     = ID_FALSE;
          }
          else if( ( sRightNode->node.lflag & MTC_NODE_OPERATOR_MASK ) ==
                    MTC_NODE_OPERATOR_SUBQUERY )
          {
              QCP_STRUCT_ALLOC($<setClause>2.subqueries, qmmSubqueries);
              $<setClause>2.subqueries->subquery     = sRightNode;
              $<setClause>2.subqueries->valuePointer = NULL;
              $<setClause>2.subqueries->next         = NULL;
              sLastValuePointer                      = NULL;

              for( sColumn = $<setClause>2.columns,
                   sValue  = $<setClause>2.values;
                   sColumn != NULL && sValue != NULL;
                   sColumn = sColumn->next,
                   sValue  = sValue->next )
              {
                  QCP_STRUCT_ALLOC(sValuePointer, qmmValuePointer);
                  sValuePointer->valueNode = sValue;
                  sValuePointer->next      = NULL;
                  if( sLastValuePointer == NULL )
                  {
                      $<setClause>2.subqueries->valuePointer = sValuePointer;
                  }
                  else
                  {
                      sLastValuePointer->next = sValuePointer;
                  }
                  sLastValuePointer = sValuePointer;
              }
          }
          else if( ( sRightNode->node.lflag & MTC_NODE_OPERATOR_MASK ) ==
                     MTC_NODE_OPERATOR_LIST )
          {
              for( sColumn = $<setClause>2.columns,
                   sValue  = $<setClause>2.values,
                   sNode   = sRightNode->node.arguments;
                   sColumn != NULL && sNode != NULL;
                   sColumn = sColumn->next,
                   sValue  = sValue->next,
                   sNode   = sNode->next )
              {
                  sValue->value     = (qtcNode*)sNode;
                  sValue->calculate = ID_TRUE;
                  sValue->timestamp = ID_FALSE;
              }
              if( sColumn != NULL || sNode != NULL )
              {
                  IDE_SET(ideSetErrorCode(mtERR_ABORT_INVALID_FUNCTION_ARGUMENT));
                  YYABORT;
              }

              QCP_STRUCT_ALLOC($<setClause>2.lists, qmmValueNode);
              $<setClause>2.lists->value     = sRightNode;
              $<setClause>2.lists->validate  = ID_TRUE;
              $<setClause>2.lists->calculate = ID_FALSE;
              $<setClause>2.lists->timestamp = ID_FALSE;
              $<setClause>2.lists->expand    = ID_FALSE;
              $<setClause>2.values->msgID     = ID_FALSE;
              $<setClause>2.lists->next      = NULL;
          }
          else
          {
              IDE_SET(ideSetErrorCode(mtERR_ABORT_INVALID_FUNCTION_ARGUMENT));
              YYABORT;
          }

          // BUG-46174
          $<setClause>2.spVariable = NULL;

          $<setClause>$ = $<setClause>2;
      }
    ;

set_column_def
    : column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<columnDef>$, qcmColumn);
          QCM_COLUMN_INIT( $<columnDef>$ );

          SET_EMPTY_POSITION($<columnDef>$->userNamePos);
          SET_EMPTY_POSITION($<columnDef>$->tableNamePos);
          SET_POSITION($<columnDef>$->namePos, $<position>1);
      }
    | TI_IDENTIFIER TS_PERIOD column_name
      {
          //SET_POSITION( $<expression>$[0]->tableName,  $<position>1 );
          //SET_POSITION( $<expression>$[0]->columnName, $<position>3 );
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          QCP_STRUCT_ALLOC($<columnDef>$, qcmColumn);
          QCM_COLUMN_INIT( $<columnDef>$ );

          SET_POSITION($<columnDef>$->tableNamePos, $<position>1);
          SET_POSITION($<columnDef>$->namePos, $<position>3);
      }
    ;

assignment_column_comma_list
    : assignment_column_comma_list TS_COMMA assignment_column
      {
          qcmColumn     * sLastColumn;
          qmmValueNode  * sLastValue;

          if( $<setClause>1.columns == NULL )
          {
              $<setClause>$.columns = $<setClause>3.columns;
          }
          else
          {
              $<setClause>$.columns = $<setClause>1.columns;
              for( sLastColumn = $<setClause>$.columns;
                   sLastColumn->next != NULL;
                   sLastColumn = sLastColumn->next) ;
              sLastColumn->next = $<setClause>3.columns;
          }

          if( $<setClause>1.values == NULL )
          {
              $<setClause>$.values = $<setClause>3.values;
          }
          else
          {
              $<setClause>$.values = $<setClause>1.values;
              for( sLastValue = $<setClause>$.values;
                   sLastValue->next != NULL;
                   sLastValue = sLastValue->next ) ;
              sLastValue->next = $<setClause>3.values;
          }

          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists      = NULL;
          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    | assignment_column
      {
          $<setClause>$ = $<setClause>1;
      }
    ;

assignment_column
    : column_name
      {
          qcuSqlSourceInfo sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<setClause>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<setClause>$.columns );

          SET_EMPTY_POSITION($<setClause>$.columns->tableNamePos);
          SET_POSITION($<setClause>$.columns->namePos, $<position>1);

          QCP_STRUCT_ALLOC($<setClause>$.values, qmmValueNode);
          $<setClause>$.values->value     = NULL;
          $<setClause>$.values->validate  = ID_FALSE;
          $<setClause>$.values->calculate = ID_FALSE;
          $<setClause>$.values->timestamp = ID_FALSE;
          $<setClause>$.values->expand    = ID_FALSE;
          $<setClause>$.values->msgID     = ID_FALSE;
          $<setClause>$.values->next      = NULL;

          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists      = NULL;
          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER
      {
          qcuSqlSourceInfo sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<setClause>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<setClause>$.columns );

          SET_POSITION($<setClause>$.columns->tableNamePos, $<position>1);
          SET_POSITION($<setClause>$.columns->namePos, $<position>3);

          QCP_STRUCT_ALLOC($<setClause>$.values, qmmValueNode);
          $<setClause>$.values->value     = NULL;
          $<setClause>$.values->validate  = ID_FALSE;
          $<setClause>$.values->calculate = ID_FALSE;
          $<setClause>$.values->timestamp = ID_FALSE;
          $<setClause>$.values->msgID     = ID_FALSE;
          $<setClause>$.values->expand    = ID_FALSE;
          $<setClause>$.values->next      = NULL;

          $<setClause>$.subqueries = NULL;
          $<setClause>$.lists      = NULL;
          // BUG-46174
          $<setClause>$.spVariable = NULL;
      }
    ;

/*****************************************
 * MOVE
 ****************************************/
move_statement
    : TR_MOVE opt_hints TR_INTO
      user_object_name opt_partition_name
      opt_table_column_commalist
      TR_FROM user_object_name opt_partition_name
      opt_move_expression_commalist
      opt_where_clause opt_limit_clause
      {
          QCP_STRUCT_ALLOC($<moveParseTree>$, qmmMoveParseTree);
          QC_SET_INIT_PARSE_TREE($<moveParseTree>$, $<position>1);
          // set size of select_statement
          QCP_ADJUST_LAST_POSITION( $<moveParseTree>$->common.stmtPos );
          QCP_STRUCT_ALLOC($<moveParseTree>$->querySet, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<moveParseTree>$->querySet);
          QCP_STRUCT_ALLOC($<moveParseTree>$->querySet->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<moveParseTree>$->querySet->SFWGH);
          QCP_STRUCT_ALLOC($<moveParseTree>$->querySet->SFWGH->from, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<moveParseTree>$->querySet->SFWGH->from);

          QCP_STRUCT_ALLOC($<moveParseTree>$->querySet->SFWGH->from->tableRef,
                           qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF(
              $<moveParseTree>$->querySet->SFWGH->from->tableRef);

          QCP_STRUCT_ALLOC($<moveParseTree>$->targetTableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<moveParseTree>$->targetTableRef);
          $<moveParseTree>$->querySet->SFWGH->thisQuerySet = $<moveParseTree>$->querySet;

          /* set target table position*/
          SET_POSITION($<moveParseTree>$->targetTableRef->userName,
                       $<userNObjName>4->userName);
          SET_POSITION($<moveParseTree>$->targetTableRef->tableName,
                       $<userNObjName>4->objectName);
          SET_POSITION($<moveParseTree>$->targetTableRef->aliasName,
                       $<userNObjName>4->objectName);

          // position 
          if ( QC_IS_NULL_NAME( $<userNObjName>4->userName ) == ID_TRUE )
          {
              SET_POSITION( $<moveParseTree>$->targetTableRef->position,
                            $<userNObjName>4->objectName );
          }
          else
          {
              QCP_ADD_POSITION( $<moveParseTree>$->targetTableRef->position,
                                $<userNObjName>4->userName,
                                $<userNObjName>4->objectName );
          }
          if ( $<partitionRef>5 != NULL )
          {
              QCP_ADD_POSITION( $<moveParseTree>$->targetTableRef->position,
                                $<moveParseTree>$->targetTableRef->position,
                                $<partitionRef>5->position );
          }

          // PROJ-1502 PARTITIONED DISK TABLE
          $<moveParseTree>$->targetTableRef->partitionRef = $<partitionRef>5;

          // target column list
          $<moveParseTree>$->columns = $<columnDef>6;

          /* set source table position */
          SET_POSITION(
              $<moveParseTree>$->querySet->SFWGH->from->tableRef->userName,
              $<userNObjName>8->userName);
          SET_POSITION(
              $<moveParseTree>$->querySet->SFWGH->from->tableRef->tableName,
              $<userNObjName>8->objectName);
          SET_POSITION(
              $<moveParseTree>$->querySet->SFWGH->from->tableRef->aliasName,
              $<userNObjName>8->objectName);

          // PROJ-1502 PARTITIONED DISK TABLE
          $<moveParseTree>$->querySet->SFWGH->from->tableRef->partitionRef = $<partitionRef>9;

          // hints
          $<moveParseTree>$->querySet->SFWGH->hints = $<hints>2;

          // move_expression_list
          $<moveParseTree>$->values = $<valueNode>10;

          // WHERE clause
          $<moveParseTree>$->querySet->SFWGH->where = $<expression>11[0];

          $<moveParseTree>$->querySet->SFWGH->startPos = $<position>1;
 
          // limit clause
          $<moveParseTree>$->limit = $<limit>12;

          $<moveParseTree>$->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<moveParseTree>$->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<moveParseTree>$->defaultTableRef = NULL;
          $<moveParseTree>$->defaultExprColumns = NULL;
          
          // function pointer
          $<moveParseTree>$->common.parse    = qmv::parseMove;
          $<moveParseTree>$->common.validate = qmv::validateMove;
          $<moveParseTree>$->common.optimize = qmo::optimizeMove;
          $<moveParseTree>$->common.execute  = qmx::executeMove;
      }
    ;

opt_move_expression_commalist
    : /* empty */
      {
          $<valueNode>$ = NULL;
      }
    | TS_OPENING_PARENTHESIS move_expression_commalist TS_CLOSING_PARENTHESIS
      {
          $<valueNode>$ = $<valueNode>2;
      }
    ;
move_expression_commalist
    : move_expression_commalist TS_COMMA move_expression
      {
          qmmValueNode      * sLastValue;

          // BUG-36739
          $<valueNode>$ = $<valueNode>1;

          // connect
          sLastValue = $<valueNode>$;
          while (sLastValue->next != NULL)
          {
              sLastValue = sLastValue->next;
          }

          sLastValue->next = $<valueNode>3;
      }
    |  move_expression
    {
        $<valueNode>$ = $<valueNode>1;
    }
    ;

move_expression
    : arithmetic_expression
      {
          QCP_STRUCT_ALLOC($<valueNode>$, qmmValueNode);

          $<valueNode>$->value     = $<expression>1[0];
          $<valueNode>$->validate  = ID_TRUE;
          $<valueNode>$->calculate = ID_TRUE;
          $<valueNode>$->timestamp = ID_FALSE;
          $<valueNode>$->expand    = ID_FALSE;
          $<valueNode>$->msgID     = ID_FALSE;
          $<valueNode>$->next      = NULL;
      }
    | TR_DEFAULT
      {
          QCP_STRUCT_ALLOC($<valueNode>$, qmmValueNode);

          $<valueNode>$->value     = NULL;
          $<valueNode>$->validate  = ID_TRUE;
          $<valueNode>$->calculate = ID_TRUE;
          $<valueNode>$->timestamp = ID_FALSE;
          $<valueNode>$->expand    = ID_FALSE;
          $<valueNode>$->msgID     = ID_FALSE;
          $<valueNode>$->next      = NULL;
      }
    ;

/* PROJ-1988 Implement MERGE statement */
/*****************************************
 * MERGE
 ****************************************/
merge_statement
    : TR_MERGE opt_hints
      TR_INTO user_object_name opt_partition_name opt_as_name
      TR_USING sel_from_table_reference
      TR_ON expression
      merge_actions_list
      {
          /* init mergeParseTree */
          QCP_STRUCT_ALLOC($<mergeParseTree>$, qmmMergeParseTree);
          QC_SET_INIT_PARSE_TREE($<mergeParseTree>$, $<position>1);
          QCP_ADJUST_LAST_POSITION( $<mergeParseTree>$->common.stmtPos );
 
          /* init mergeParseTree->target */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->target, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<mergeParseTree>$->target);
          /* init mergeParseTree->target->SFWGH */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->target->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<mergeParseTree>$->target->SFWGH);
          /* init mergeParseTree->target->SFWGH->from */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->target->SFWGH->from, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<mergeParseTree>$->target->SFWGH->from);
          /* init mergeParseTree->target->SFWGH->from->tableRef */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->target->SFWGH->from->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<mergeParseTree>$->target->SFWGH->from->tableRef);
          
          $<mergeParseTree>$->target->SFWGH->thisQuerySet = $<mergeParseTree>$->target;

          /* init mergeParseTree->source */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->source, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<mergeParseTree>$->source);
          /* init mergeParseTree->source->SFWGH */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->source->SFWGH, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<mergeParseTree>$->source->SFWGH);
          /* init mergeParseTree->source->SFWGH->from */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->source->SFWGH->from, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<mergeParseTree>$->source->SFWGH->from);
          /* init mergeParseTree->source->SFWGH->from->tableRef */
          QCP_STRUCT_ALLOC($<mergeParseTree>$->source->SFWGH->from->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<mergeParseTree>$->source->SFWGH->from->tableRef)
          
          $<mergeParseTree>$->source->SFWGH->thisQuerySet = $<mergeParseTree>$->source;

          $<mergeParseTree>$->updateParseTree = NULL;
          $<mergeParseTree>$->whereForUpdate = NULL;
          $<mergeParseTree>$->updateStatement = NULL;
          $<mergeParseTree>$->deleteParseTree = NULL;
          $<mergeParseTree>$->whereForDelete = NULL;
          $<mergeParseTree>$->deleteStatement = NULL;
          $<mergeParseTree>$->insertParseTree = NULL;
          $<mergeParseTree>$->whereForInsert = NULL;
          $<mergeParseTree>$->insertStatement = NULL;
          $<mergeParseTree>$->insertNoRowsParseTree = NULL;
          $<mergeParseTree>$->insertNoRowsStatement = NULL;
          
          $<mergeParseTree>$->selectTargetParseTree = NULL;
          $<mergeParseTree>$->selectTargetStatement = NULL;
          $<mergeParseTree>$->selectSourceParseTree = NULL;
          $<mergeParseTree>$->selectTargetStatement = NULL;
                    
          /* target table 4 partition 5 with alias 6 */
          SET_POSITION($<mergeParseTree>$->target->SFWGH->from->tableRef->userName, 
                       $<userNObjName>4->userName);
          SET_POSITION($<mergeParseTree>$->target->SFWGH->from->tableRef->tableName, 
                       $<userNObjName>4->objectName);
        
          $<mergeParseTree>$->target->SFWGH->from->tableRef->partitionRef = $<partitionRef>5; 
        
          SET_POSITION($<mergeParseTree>$->target->SFWGH->from->tableRef->aliasName,
                       $<position>6);
         
          // position 
          if ( QC_IS_NULL_NAME( $<userNObjName>4->userName ) == ID_TRUE )
          {
              SET_POSITION( $<mergeParseTree>$->target->SFWGH->from->tableRef->position,
                            $<userNObjName>4->objectName );
          }
          else
          {
              QCP_ADD_POSITION( $<mergeParseTree>$->target->SFWGH->from->tableRef->position,
                                $<userNObjName>4->userName,
                                $<userNObjName>4->objectName );
          }
          if ( $<partitionRef>5 != NULL )
          {
              QCP_ADD_POSITION( $<mergeParseTree>$->target->SFWGH->from->tableRef->position,
                                $<mergeParseTree>$->target->SFWGH->from->tableRef->position,
                                $<partitionRef>5->position );
          }

          $<mergeParseTree>$->target->SFWGH->from->tableRef->view = NULL;
          $<mergeParseTree>$->target->SFWGH->from->tableRef->tableInfo = NULL;
          $<mergeParseTree>$->target->SFWGH->from->tableRef->tableAccessHints = NULL;
          $<mergeParseTree>$->target->SFWGH->from->tableRef->flag = 0;
          
          $<mergeParseTree>$->target->SFWGH->where = NULL;
          $<mergeParseTree>$->target->SFWGH->startPos = $<position>1;
          $<mergeParseTree>$->target->SFWGH->outerQuery = $<mergeParseTree>$->source->SFWGH;
          
          /* hints 2 */
          $<mergeParseTree>$->target->SFWGH->hints = $<hints>2;
          
          /* source table 8 */
          $<mergeParseTree>$->source->SFWGH->from = $<from>8;
          $<mergeParseTree>$->source->SFWGH->startPos = $<position>1;
          
          /* hints 2 */
          $<mergeParseTree>$->source->SFWGH->hints = $<hints>2;
          
          /* on clause 10 */
          $<mergeParseTree>$->onExpr = $<expression>10[0];
          
          /* merge actions (UPDATE/DELETE/INSERT) 11 */
          if ( ( $<mergeActions>11.updateParseTree == NULL ) &&
               ( $<mergeActions>11.insertParseTree == NULL ) &&
               ( $<mergeActions>11.insertNoRowsParseTree == NULL ) )
          {
              // update insert ϳ ־ Ѵ.
              // syntax error
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          $<mergeParseTree>$->updateParseTree = $<mergeActions>11.updateParseTree;
          $<mergeParseTree>$->whereForUpdate = $<mergeActions>11.whereForUpdate;
          
          $<mergeParseTree>$->deleteParseTree = $<mergeActions>11.deleteParseTree;
          $<mergeParseTree>$->whereForDelete = $<mergeActions>11.whereForDelete;
          
          $<mergeParseTree>$->insertParseTree = $<mergeActions>11.insertParseTree;
          $<mergeParseTree>$->whereForInsert = $<mergeActions>11.whereForInsert;

          // BUG-37535
          $<mergeParseTree>$->insertNoRowsParseTree = $<mergeActions>11.insertNoRowsParseTree;
          
          /* function pointers */
          $<mergeParseTree>$->common.parse = qmv::parseMerge;
          $<mergeParseTree>$->common.validate = qmv::validateMerge;
          $<mergeParseTree>$->common.optimize = qmo::optimizeMerge;
          $<mergeParseTree>$->common.execute = qmx::executeMerge;
      }
    ;

merge_actions_list
    : merge_actions_list merge_actions
      {
          $<mergeActions>$ = $<mergeActions>1;
          
          if ( ( $<mergeActions>2.updateParseTree != NULL ) &&
               ( $<mergeActions>$.updateParseTree != NULL ) )
          {
              // ι̻ Ǹ ȵȴ.
              // syntax error
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          
          if ( ( $<mergeActions>2.insertParseTree != NULL ) &&
               ( $<mergeActions>$.insertParseTree != NULL ) )
          {
              // ι̻ Ǹ ȵȴ.
              // syntax error
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }

          if ( ( $<mergeActions>2.insertNoRowsParseTree != NULL ) &&
               ( $<mergeActions>$.insertNoRowsParseTree != NULL ) )
          {
              // ι̻ Ǹ ȵȴ.
              // syntax error
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
          
          if ( $<mergeActions>2.updateParseTree != NULL )
          {
              $<mergeActions>$.whereForUpdate  = $<mergeActions>2.whereForUpdate;
              $<mergeActions>$.updateParseTree = $<mergeActions>2.updateParseTree;
              
              $<mergeActions>$.whereForDelete  = $<mergeActions>2.whereForDelete;
              $<mergeActions>$.deleteParseTree = $<mergeActions>2.deleteParseTree;
          }
          
          if ( $<mergeActions>2.insertParseTree != NULL )
          {
              $<mergeActions>$.whereForInsert  = $<mergeActions>2.whereForInsert;
              $<mergeActions>$.insertParseTree = $<mergeActions>2.insertParseTree;

          }
          
          if ( $<mergeActions>2.insertNoRowsParseTree != NULL )
          {
              $<mergeActions>$.insertNoRowsParseTree = $<mergeActions>2.insertNoRowsParseTree;
          }
      }
    | merge_actions
      {
          $<mergeActions>$ = $<mergeActions>1;
      }
    ;

merge_actions
    : TR_WHEN when_condition TR_THEN then_action
      {
          qcuSqlSourceInfo    sqlInfo;

          $<mergeActions>$ = $<mergeActions>4;
          
          if ( $<uIntVal>2 == 0 )
          {
              // when matched, update ϴ.
              
              if ( $<mergeActions>$.updateParseTree == NULL )
              { // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }
          else if ( $<uIntVal>2 == 1 )
          {
              // when not matched, insert ϴ.
              
              if ( $<mergeActions>$.insertParseTree == NULL )
              { // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
          }
          else if ( $<uIntVal>2 == 2 )
          {
              // when no rows, insert ϴ.
              
              if ( $<mergeActions>$.insertParseTree == NULL )
              { // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
              
              if ( $<mergeActions>$.whereForInsert != NULL )
              { // syntax error
                  sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
                  sqlInfo.init(MEMORY);
                  IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                          sqlInfo.getErrMessage()));
                  sqlInfo.fini();
                  YYABORT;
              }
              
              // empty insert Ѵ.
              $<mergeActions>$.insertNoRowsParseTree = $<mergeActions>$.insertParseTree;
              $<mergeActions>$.insertParseTree = NULL;
          }
          else
          {
              // syntax error
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX, ""));
              YYABORT;
          }
      }
    ;

when_condition
    : TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                  "MATCHED", 7,
                  QTEXT+$<position>1.offset, $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          $<uIntVal>$ = 0;
      }
    | TR_NOT TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                  "MATCHED", 7,
                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          $<uIntVal>$ = 1;
      }
    | TI_NONQUOTED_IDENTIFIER TI_NONQUOTED_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                  "NO", 2,
                  QTEXT+$<position>1.offset, $<position>1.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          if (idlOS::strMatch(
                  "ROWS", 4,
                  QTEXT+$<position>2.offset, $<position>2.size) != 0)
          { // syntax error
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_SYNTAX,
                                      sqlInfo.getErrMessage()));
              sqlInfo.fini();
              YYABORT;
          }
          
          $<uIntVal>$ = 2;
      }
    ;

then_action
    : TR_UPDATE TR_SET assignment_commalist opt_where_clause opt_limit_clause
      opt_delete_where_clause
      {
          QMM_INIT_MERGE_ACTIONS(&$<mergeActions>$);
          
          /* init updateParseTree */
          QCP_STRUCT_ALLOC($<mergeActions>$.updateParseTree, qmmUptParseTree);
          QC_SET_INIT_PARSE_TREE($<mergeActions>$.updateParseTree, $<position>1);
          /* init updateParseTree->querySet */
              
          /* set clause 3 */
          $<mergeActions>$.updateParseTree->columns = $<setClause>3.columns;
          $<mergeActions>$.updateParseTree->values = $<setClause>3.values;
          $<mergeActions>$.updateParseTree->subqueries = $<setClause>3.subqueries;
          $<mergeActions>$.updateParseTree->lists = $<setClause>3.lists;
          // BUG-46174
          $<mergeActions>$.updateParseTree->spVariable = NULL;
          
          $<mergeActions>$.updateParseTree->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();
          
          /* where clause 4 */
          $<mergeActions>$.whereForUpdate = $<expression>4[0];
          
          /* limit clause 5 */
          $<mergeActions>$.updateParseTree->limit = $<limit>5;
          
          /* etc */
          $<mergeActions>$.updateParseTree->returnInto = NULL;

          /* PROJ-1107 Check Constraint  */
          $<mergeActions>$.updateParseTree->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<mergeActions>$.updateParseTree->defaultTableRef = NULL;
          $<mergeActions>$.updateParseTree->defaultExprColumns = NULL;
          $<mergeActions>$.updateParseTree->mTableList = NULL;

          /* function pointers */
          $<mergeActions>$.updateParseTree->common.parse    = qmv::parseUpdate;
          $<mergeActions>$.updateParseTree->common.validate = qmv::validateUpdate;
          $<mergeActions>$.updateParseTree->common.optimize = qmo::optimizeUpdate;
          $<mergeActions>$.updateParseTree->common.execute  = qmx::executeUpdate;
          
          /* delete parse tree 6 */
          $<mergeActions>$.deleteParseTree = $<mergeActions>6.deleteParseTree; 
          $<mergeActions>$.whereForDelete = $<mergeActions>6.whereForDelete;
      }
    | TR_INSERT opt_table_column_commalist
      TR_VALUES TS_OPENING_PARENTHESIS insert_atom_commalist TS_CLOSING_PARENTHESIS
      opt_where_clause
      {
          QMM_INIT_MERGE_ACTIONS(&$<mergeActions>$);
          
          /* init insertParseTree */
          QCP_STRUCT_ALLOC($<mergeActions>$.insertParseTree, qmmInsParseTree);
          QC_SET_INIT_PARSE_TREE($<mergeActions>$.insertParseTree, $<position>1);

          /* PROJ-2204 JOIN UPDATE, DELETE */
          $<mergeActions>$.insertParseTree->insertTableRef = NULL;
          $<mergeActions>$.insertParseTree->insertColumns  = NULL;
          
          /* some fix-up */
          $<mergeActions>$.insertParseTree->flag = 0;
          $<mergeActions>$.insertParseTree->queueMsgIDSeq = NULL;
    
          /* hints 2 */
          $<mergeActions>$.insertParseTree->hints = NULL;
    
          /* column names 2 */
          $<mergeActions>$.insertParseTree->columns = $<columnDef>2;
        
          /* column values 5 */
          QCP_STRUCT_ALLOC($<mergeActions>$.insertParseTree->rows, qmmMultiRows);
          $<mergeActions>$.insertParseTree->rows->values       = $<valueNode>5;
          $<mergeActions>$.insertParseTree->rows->next         = NULL;
          // BUG-46174
          $<mergeActions>$.insertParseTree->spVariable         = NULL;
          
          /* where 7 */
          $<mergeActions>$.whereForInsert = $<expression>7[0];
        
          /* some initializations */
          $<mergeActions>$.insertParseTree->returnInto = NULL;
          $<mergeActions>$.insertParseTree->outerQuerySet = NULL;
          $<mergeActions>$.insertParseTree->select = NULL;
          $<mergeActions>$.insertParseTree->valueIdx = QCP_GET_TEMPLATE_SMI_VALUE_INDEX();

          /* PROJ-1107 Check Constraint  */
          $<mergeActions>$.insertParseTree->checkConstrList = NULL;

          /* PROJ-1090 Function-based Index */
          $<mergeActions>$.insertParseTree->defaultTableRef = NULL;
          $<mergeActions>$.insertParseTree->defaultExprColumns = NULL; 

          // BUG-43063 insert nowait
          $<mergeActions>$.insertParseTree->lockWaitMicroSec = ID_ULONG_MAX;
         
          // BUG-36596 multi-table insert
          $<mergeActions>$.insertParseTree->next = NULL;
          
          /* function pointers */
          $<mergeActions>$.insertParseTree->common.parse    = qmv::parseInsertValues;
          $<mergeActions>$.insertParseTree->common.validate = qmv::validateInsertValues;
          $<mergeActions>$.insertParseTree->common.optimize = qmo::optimizeInsert;
          $<mergeActions>$.insertParseTree->common.execute  = qmx::executeInsertValues;
      }
    ;

opt_delete_where_clause
    : /* empty */
      {
          QMM_INIT_MERGE_ACTIONS(&$<mergeActions>$);
      }
    | TR_DELETE opt_where_clause opt_limit_clause
      {
          QMM_INIT_MERGE_ACTIONS(&$<mergeActions>$);
          
          /* init deleteParseTree */
          QCP_STRUCT_ALLOC($<mergeActions>$.deleteParseTree, qmmDelParseTree);
          QC_SET_INIT_PARSE_TREE($<mergeActions>$.deleteParseTree, $<position>1);
        
          /* where clause 2 */
          $<mergeActions>$.whereForDelete = $<expression>2[0];
        
          /* limit clause 3 */
          $<mergeActions>$.deleteParseTree->limit = $<limit>3;
        
          /* some initializations */
          $<mergeActions>$.deleteParseTree->returnInto = NULL;
          $<mergeActions>$.deleteParseTree->mTableList = NULL;
          $<mergeActions>$.deleteParseTree->mDelList = NULL;

          /* function pointers */
          $<mergeActions>$.deleteParseTree->common.parse    = qmv::parseDelete;
          $<mergeActions>$.deleteParseTree->common.validate = qmv::validateDelete;
          $<mergeActions>$.deleteParseTree->common.optimize = qmo::optimizeDelete;
          $<mergeActions>$.deleteParseTree->common.execute  = qmx::executeDelete;
      }
    ;

/*****************************************
 * SELECT
 ****************************************/
select_or_with_select_statement
    : select_statement
      {
        $<selectParseTree>$ = $<selectParseTree>1;
      }
    | with_select_statement
      {
        $<selectParseTree>$ = $<selectParseTree>1;
      }
    ;
    
select_statement
    : query_exp opt_order_by_clause opt_limit_or_loop_clause
      {
          QCP_STRUCT_ALLOC($<selectParseTree>$, qmsParseTree);
          QC_SET_INIT_PARSE_TREE($<selectParseTree>$, $<querySet>1->startPos);
          // set size of select_statement
          QCP_ADJUST_LAST_POSITION( $<selectParseTree>$->common.stmtPos );
          
          $<selectParseTree>$->withClause = NULL;
          $<selectParseTree>$->querySet   = $<querySet>1;
          $<selectParseTree>$->limit      = $<limitOrLoop>3->limit;
          $<selectParseTree>$->loopNode   = $<limitOrLoop>3->loopNode;
          $<selectParseTree>$->forUpdate  = NULL;
          $<selectParseTree>$->queue      = NULL;

          if ( $<orderBy>2 == NULL )
          {
              $<selectParseTree>$->orderBy = NULL;
              $<selectParseTree>$->isSiblings = ID_FALSE;
          }
          else
          {
              $<selectParseTree>$->orderBy    = $<orderBy>2->sortColumns;
              $<selectParseTree>$->isSiblings = $<orderBy>2->isSiblings;
          }

          // PROJ-1413
          $<selectParseTree>$->isTransformed = ID_FALSE;

          // PROJ-2646
          $<selectParseTree>$->isView      = ID_FALSE;
          $<selectParseTree>$->isShardView = ID_FALSE;

          $<selectParseTree>$->common.parse     = qmv::parseSelect;
          $<selectParseTree>$->common.validate  = qmv::validateSelect;
          $<selectParseTree>$->common.optimize  = qmo::optimizeSelect;
          $<selectParseTree>$->common.execute   = qmx::executeSelect;

          $<selectParseTree>$->common.stmt = STATEMENT;
      }
    ;

with_select_statement
    : subquery_factoring_clause query_exp opt_order_by_clause opt_limit_or_loop_clause
      {
          QCP_STRUCT_ALLOC($<selectParseTree>$, qmsParseTree);
          QC_SET_INIT_PARSE_TREE($<selectParseTree>$, $<withClause>1->startPos);
          // set size of select_statement
          QCP_ADJUST_LAST_POSITION( $<selectParseTree>$->common.stmtPos );

          $<selectParseTree>$->withClause = $<withClause>1;  
          $<selectParseTree>$->querySet   = $<querySet>2;
          $<selectParseTree>$->limit      = $<limitOrLoop>4->limit;
          $<selectParseTree>$->loopNode   = $<limitOrLoop>4->loopNode;
          $<selectParseTree>$->forUpdate  = NULL;
          $<selectParseTree>$->queue      = NULL;
          
          if ( $<orderBy>3 == NULL )
          {
              $<selectParseTree>$->orderBy = NULL;
              $<selectParseTree>$->isSiblings = ID_FALSE;
          }
          else
          {
              $<selectParseTree>$->orderBy    = $<orderBy>3->sortColumns;
              $<selectParseTree>$->isSiblings = $<orderBy>3->isSiblings;
          }

          // PROJ-1413
          $<selectParseTree>$->isTransformed = ID_FALSE;

          // PROJ-2646
          $<selectParseTree>$->isView      = ID_FALSE;
          $<selectParseTree>$->isShardView = ID_FALSE;

          $<selectParseTree>$->common.parse     = qmv::parseSelect;
          $<selectParseTree>$->common.validate  = qmv::validateSelect;
          $<selectParseTree>$->common.optimize  = qmo::optimizeSelect;
          $<selectParseTree>$->common.execute   = qmx::executeSelect;

          $<selectParseTree>$->common.stmt = STATEMENT;
      }
    | TS_OPENING_PARENTHESIS with_select_statement TS_CLOSING_PARENTHESIS
      {
          $<selectParseTree>$ = $<selectParseTree>2;
      }
    ;
    
set_op
    : TR_UNION
      {
          $<setOpType>$    = QMS_UNION;
      }
    | TR_UNION TR_ALL
      {
          $<setOpType>$    = QMS_UNION_ALL;
      }
    | TR_INTERSECT
      {
          $<setOpType>$   = QMS_INTERSECT;
      }
    | TO_MINUS
      {
          $<setOpType>$    = QMS_MINUS;
      }
    ;

query_exp
    : query_exp set_op query_term
      {
          QCP_STRUCT_ALLOC($<querySet>$, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<querySet>$);

          $<querySet>$->setOp = $<setOpType>2;
          $<querySet>$->left  = $<querySet>1;
          $<querySet>$->right = $<querySet>3;
          SET_POSITION($<querySet>$->startPos, $<querySet>$->left->startPos);
          SET_POSITION($<querySet>$->endPos, $<querySet>$->right->endPos);
      }
    | query_term
      {
          $<querySet>$ = $<querySet>1;
      }
    ;
    
opt_subquery_factoring_clause
    : /* empty */
      {
         $<withClause>$ = NULL;
      }
    | TR_WITH subquery_factoring_clause_list
      {
        $<withClause>$ = $<withClause>2;
        SET_POSITION( $<withClause>$->startPos, $<position>1 );
      }
    ;    

subquery_factoring_clause
    : TR_WITH subquery_factoring_clause_list
      {
        $<withClause>$ = $<withClause>2;
        SET_POSITION( $<withClause>$->startPos, $<position>1 );
      }
    ;

subquery_factoring_clause_list
    : subquery_factoring_clause_list TS_COMMA subquery_factoring_element
      {
          qmsWithClause * sLast;
          $<withClause>$ = $<withClause>1;
          
          for( sLast = $<withClause>$; 
               sLast->next != NULL;
               sLast = sLast->next )
              ;
          
          sLast->next = $<withClause>3;
      }
    | subquery_factoring_element
      {
        $<withClause>$ = $<withClause>1;
      }
    ;

subquery_factoring_element
    : TI_IDENTIFIER opt_view_column_def TR_AS
      TS_OPENING_PARENTHESIS select_statement TS_CLOSING_PARENTHESIS
      {
        // select_statement
        qcStatement   * sStatement;

        QCP_STRUCT_ALLOC($<withClause>$, qmsWithClause);
        QCP_SET_INIT_QMS_WITH($<withClause>$);
    
        SET_POSITION( $<withClause>$->stmtName, $<position>1 );
        
        $<withClause>$->stmtText.size     = $<position>6.offset - $<position>4.offset - 1;
        $<withClause>$->stmtText.offset   = $<position>4.offset + 1;
        $<withClause>$->stmtText.stmtText = QTEXT;

        $<withClause>$->columns = $<tableElement>2.columns;

        QCP_STRUCT_ALLOC(sStatement, qcStatement);
        QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>5)
        sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;
                
        $<withClause>$->stmt = sStatement;
        $<withClause>$->next = NULL;
      }
    ;
        
query_term
    : TS_OPENING_PARENTHESIS query_exp TS_CLOSING_PARENTHESIS
      {
          $<querySet>$ = $<querySet>2;

          SET_POSITION($<querySet>$->startPos, $<position>1);
          SET_POSITION($<querySet>$->endPos, $<position>3);
      }
    | query_spec
      {
          QCP_STRUCT_ALLOC($<querySet>$, qmsQuerySet);
          QCP_SET_INIT_QMS_QUERY_SET($<querySet>$);

          $<querySet>$->SFWGH  = $<SFWGH>1;

          $<querySet>$->SFWGH->thisQuerySet = $<querySet>$;

          SET_POSITION($<querySet>$->startPos, $<querySet>$->SFWGH->startPos);
          SET_POSITION($<querySet>$->endPos, $<querySet>$->SFWGH->endPos);
      }
    ;

query_spec
    : TR_SELECT                          // 1
        opt_hints                        // 2
        opt_quantifier                   // 3
        opt_top                          // 4
        target_list                      // 5
        opt_into_list                    // 6
        opt_from_clause                  // 7
        opt_where_clause                 // 8
        opt_hierarchical_query_clause    // 9
        opt_groupby_clause               // 10
        opt_having_clause                // 11
      {
          QCP_STRUCT_ALLOC($<SFWGH>$, qmsSFWGH);
          QCP_SET_INIT_QMS_SFWGH($<SFWGH>$);

          $<SFWGH>$->hints         = $<hints>2;
          $<SFWGH>$->selectType    = $<selectType>3;
          $<SFWGH>$->top           = $<limit>4;
          $<SFWGH>$->target        = $<target>5;
          $<SFWGH>$->intoVariables = $<into>6;
          $<SFWGH>$->from          = $<from>7;
          $<SFWGH>$->where         = $<expression>8[0];
          $<SFWGH>$->hierarchy     = $<hierarchy>9;
          $<SFWGH>$->group         = $<concatElement>10;
          $<SFWGH>$->having        = $<expression>11[0];

          $<SFWGH>$->startPos = $<position>1;
          // set endPos
          qcpUtil::setLastTokenPosition( PARAM->mLexer,
                                         &($<SFWGH>$->endPos) );
      }
    ;

opt_hints
    : /* empty */
      {
          $<hints>$ = NULL;
      }
    | TX_HINTS
      {
          $<hints>$ = STATEMENT->myPlan->hints;
          STATEMENT->myPlan->hints = NULL;
      }
    ;

opt_groupby_clause
    : /* empty */
      {
          $<concatElement>$ = NULL;
      }
    | TR_GROUP TR_BY group_concatenation
      {
          $<concatElement>$ = $<concatElement>3;
      }
    ;

opt_quantifier
    : /* empty */
      {
          $<selectType>$ = QMS_ALL;
      }
    | TR_ALL
      {
          $<selectType>$ = QMS_ALL;
      }
    | TR_DISTINCT
      {
          $<selectType>$ = QMS_DISTINCT;
      }
    ;

/* BUG-36580 supported TOP */
opt_top
    : /* empty */
     {
         $<limit>$ = NULL;
     }
    | TM_TOP_ALL
     {
         $<limit>$ = NULL;
     }
    | TM_TOP limit_value
     {
         QCP_STRUCT_ALLOC($<limit>$, qmsLimit);
         $<limit>$->start.constant = 1;
         $<limit>$->start.hostBindNode = NULL;
         $<limit>$->count = $<limitValue>2;
         SET_POSITION($<limit>$->limitPos, $<position>1);
     }
    | TM_TOP TS_OPENING_PARENTHESIS limit_value TS_CLOSING_PARENTHESIS
     {
         QCP_STRUCT_ALLOC($<limit>$, qmsLimit);
         $<limit>$->start.constant = 1;
         $<limit>$->start.hostBindNode = NULL;
         $<limit>$->count = $<limitValue>3;
         SET_POSITION($<limit>$->limitPos, $<position>1);
     }
    ;

target_list
    : select_sublist_commalist
      {
          $<target>$ = $<target>1;
      }
    ;

opt_into_list
    : // empty
      {
          $<into>$ = NULL;
      }
    | TR_INTO SP_variable_name_commalist // for stored procedure
      {
          QCP_STRUCT_ALLOC($<into>$, qmsInto);

          $<into>$->intoNodes    = $<expression>2[0];
          $<into>$->bulkCollect  = ID_FALSE;
          $<into>$->intoPosition = $<position>1;
      }
    | TA_BULK TI_NONQUOTED_IDENTIFIER TR_INTO SP_variable_name_commalist // for stored procedure
      {
          qcuSqlSourceInfo    sqlInfo;
          
          if (idlOS::strMatch(
                "COLLECT", 7,
                QTEXT+$<position>2.offset, $<position>2.size) != 0)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>2 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                       sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC($<into>$, qmsInto);

          $<into>$->intoNodes    = $<expression>4[0];
          $<into>$->bulkCollect  = ID_TRUE;
          $<into>$->intoPosition = $<position>1;
      }
    ;

select_sublist_commalist
    : select_sublist_commalist TS_COMMA select_sublist
      {
          qmsTarget * sLast;

          $<target>$ = $<target>1;
          for (sLast = $<target>$; sLast->next != NULL; sLast = sLast->next) ;
          sLast->next = $<target>3;
          sLast->targetColumn->node.next =
              (mtcNode *)($<target>3->targetColumn);
      }
    | select_sublist
      {
          $<target>$ = $<target>1;
      }
    ;

select_sublist
    : TS_ASTERISK
      {
          qtcNode           * sExpression;
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC($<setClause>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<setClause>$.columns );

          // make expression
          QCP_STRUCT_ALLOC(sExpression, qtcNode);
          QCP_TEST( qtc::makeTargetColumn(sExpression, 0, 0) != IDE_SUCCESS );
          SET_EMPTY_POSITION(sExpression->position);
          SET_EMPTY_POSITION(sExpression->userName);
          SET_EMPTY_POSITION(sExpression->tableName);
          SET_EMPTY_POSITION(sExpression->columnName);

          QCP_STRUCT_ALLOC($<target>$, qmsTarget);
          $<target>$->targetColumn = sExpression;
          /* TASK-7219 */
          $<target>$->tableName.name      = NULL;
          $<target>$->tableName.size      = QC_POS_EMPTY_SIZE;
          $<target>$->aliasTableName.name = NULL;
          $<target>$->aliasTableName.size = QC_POS_EMPTY_SIZE;

          $<target>$->flag = 0;
          $<target>$->flag &= ~QMS_TARGET_ASTERISK_MASK;
          $<target>$->flag |= QMS_TARGET_ASTERISK_TRUE;

          $<target>$->next = NULL;
      }
    | TI_IDENTIFIER TS_PERIOD TS_ASTERISK
      {
          qtcNode           * sExpression;
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<setClause>$.columns, qcmColumn);
          QCM_COLUMN_INIT( $<setClause>$.columns );

          // make expression
          QCP_STRUCT_ALLOC(sExpression, qtcNode);
          QCP_TEST( qtc::makeTargetColumn(sExpression, 0, 0) != IDE_SUCCESS );
          SET_EMPTY_POSITION(sExpression->position);
          SET_EMPTY_POSITION(sExpression->userName);
          SET_POSITION(sExpression->tableName, $<position>1);
          SET_EMPTY_POSITION(sExpression->columnName);

          QCP_STRUCT_ALLOC($<target>$, qmsTarget);
          QMS_TARGET_INIT($<target>$);
          $<target>$->targetColumn = sExpression;
          $<target>$->flag &= ~QMS_TARGET_ASTERISK_MASK;
          $<target>$->flag |= QMS_TARGET_ASTERISK_TRUE;
      }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TS_PERIOD TS_ASTERISK
      {
          qtcNode           * sExpression;
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // make expression
          QCP_STRUCT_ALLOC(sExpression, qtcNode);
          QCP_TEST( qtc::makeTargetColumn(sExpression, 0, 0) != IDE_SUCCESS );
          SET_EMPTY_POSITION(sExpression->position);
          SET_POSITION(sExpression->userName, $<position>1);
          SET_POSITION(sExpression->tableName, $<position>3);
          SET_EMPTY_POSITION(sExpression->columnName);

          QCP_STRUCT_ALLOC($<target>$, qmsTarget);
          QMS_TARGET_INIT($<target>$);
          $<target>$->targetColumn = sExpression;
          $<target>$->flag &= ~QMS_TARGET_ASTERISK_MASK;
          $<target>$->flag |= QMS_TARGET_ASTERISK_TRUE;
      }
    | arithmetic_expression opt_as_name
      {
          QCP_STRUCT_ALLOC($<target>$, qmsTarget);
          QMS_TARGET_INIT($<target>$);
          $<target>$->targetColumn = $<expression>1[0];

          if ($<position>2.size == QC_POS_EMPTY_SIZE)
          {
              $<target>$->aliasColumnName.name = NULL;
              $<target>$->aliasColumnName.size = QC_POS_EMPTY_SIZE;
          }
          else
          {
              $<target>$->aliasColumnName.name = QTEXT + $<position>2.offset;
              $<target>$->aliasColumnName.size = $<position>2.size;
          }
      }
    ;

opt_as_name
    : /* empty */
      {
          SET_EMPTY_POSITION($<position>$);
      }
    | TI_IDENTIFIER
      {
          $<position>$ = $<position>1;
      }
    // To Fix PR-12941
    // | TR_AS TI_IDENTIFIER
    | TR_AS column_name
      {
          $<position>$ = $<position>2;
      }
    | TL_LITERAL
      {
          $<position>$.stmtText = QTEXT;
          $<position>$.offset   = $<position>1.offset + 1;
          $<position>$.size     = $<position>1.size - 2;
      }
    | TR_AS TL_LITERAL
      {
          $<position>$.stmtText = QTEXT;
          $<position>$.offset   = $<position>2.offset + 1;
          $<position>$.size     = $<position>2.size - 2;
      }
    ;

opt_from_clause
    : /* empty */
      {
          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);

          $<from>$->tableRef->tableName.stmtText = (SChar*)"X$DUAL";
          $<from>$->tableRef->tableName.offset   = 0;
	      $<from>$->tableRef->tableName.size     = 6;

          SET_EMPTY_POSITION($<from>$->fromPosition);
      }
    | TR_FROM sel_from_table_reference_commalist
      {
          $<from>$               = $<from>2;
          $<from>$->fromPosition = $<position>1;
      }
    ;

sel_from_table_reference_commalist
    : sel_from_table_reference_commalist TS_COMMA sel_from_table_reference
      {
          qmsFrom * sLast;

          $<from>$ = $<from>1;
          for (sLast = $<from>$; sLast->next != NULL; sLast = sLast->next) ;
          sLast->next = $<from>3;
      }
    | sel_from_table_reference
      {
          $<from>$ = $<from>1;
      }
    ;

sel_from_table_reference
    : sel_from_table_single_reference
      {
          $<from>$ = $<from>1;
      }
    | joined_table
      {
          $<from>$ = $<from>1;
      }
    ;

sel_from_table_single_reference
    : TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER opt_partition_name opt_pivot_or_unpivot_clause opt_as_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // check userName length
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // check tableName length
          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->userName, $<position>1);
          SET_POSITION($<from>$->tableRef->tableName, $<position>3);
          SET_POSITION($<from>$->tableRef->aliasName, $<position>6);

          // PROJ-1502 PARTITIONED DISK TABLE
          $<from>$->tableRef->partitionRef = $<partitionRef>4;
          $<from>$->tableRef->pivot = $<pivotOrUnpivot>5.pivot;
          $<from>$->tableRef->unpivot = $<pivotOrUnpivot>5.unpivot;

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>3 );
          if ( $<partitionRef>4 != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<partitionRef>4->position );
          }
          if ( $<pivotOrUnpivot>5.pivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>5.pivot->position );
          }
          if ( $<pivotOrUnpivot>5.unpivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>5.unpivot->position );
          }
      }
    | TI_IDENTIFIER opt_partition_name opt_pivot_or_unpivot_clause opt_as_name
      {
          qcuSqlSourceInfo    sqlInfo;

          // check tableName length
          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->tableName, $<position>1);
          SET_POSITION($<from>$->tableRef->aliasName, $<position>4);

          // PROJ-1502 PARTITIONED DISK TABLE
          $<from>$->tableRef->partitionRef = $<partitionRef>2;
          $<from>$->tableRef->pivot = $<pivotOrUnpivot>3.pivot;
          $<from>$->tableRef->unpivot = $<pivotOrUnpivot>3.unpivot;

          // position 
          SET_POSITION( $<from>$->tableRef->position, $<position>1 );
          if ( $<partitionRef>2 != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<partitionRef>2->position );
          }
          if ( $<pivotOrUnpivot>3.pivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>3.pivot->position );
          }
          if ( $<pivotOrUnpivot>3.unpivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>3.unpivot->position );
          }
      }
    | TS_OPENING_PARENTHESIS select_or_with_select_statement TS_CLOSING_PARENTHESIS opt_pivot_or_unpivot_clause opt_as_name
      {
          qcStatement   * sStatement;

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->aliasName, $<position>5);

          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>2)
          sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          // set view
          $<selectParseTree>2->isView      = ID_TRUE;
          $<selectParseTree>2->isShardView = ID_FALSE;

          $<from>$->tableRef->view   = sStatement;
          $<from>$->tableRef->pivot  = $<pivotOrUnpivot>4.pivot;
          $<from>$->tableRef->unpivot  = $<pivotOrUnpivot>4.unpivot;

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>3 );
          if ( $<pivotOrUnpivot>4.pivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>4.pivot->position );
          }
          if ( $<pivotOrUnpivot>4.unpivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>4.unpivot->position );
          }
      }
    /* PROJ-2418 Cross/Outer APPLY & Lateral View */
    | TR_LATERAL TS_OPENING_PARENTHESIS select_or_with_select_statement TS_CLOSING_PARENTHESIS opt_pivot_or_unpivot_clause opt_as_name
      {
          qcStatement      * sStatement;

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->aliasName, $<position>6);

          // select_statement
          QCP_STRUCT_ALLOC(sStatement, qcStatement);
          QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>3)
          sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

          // set view
          $<selectParseTree>3->isView      = ID_TRUE;
          $<selectParseTree>3->isShardView = ID_FALSE;

          $<from>$->tableRef->view  = sStatement;
          $<from>$->tableRef->pivot  = $<pivotOrUnpivot>5.pivot;
          $<from>$->tableRef->unpivot  = $<pivotOrUnpivot>5.unpivot;

          $<from>$->tableRef->flag &= ~QMS_TABLE_REF_LATERAL_VIEW_MASK;
          $<from>$->tableRef->flag |= QMS_TABLE_REF_LATERAL_VIEW_TRUE;

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>4 );
          if ( $<pivotOrUnpivot>5.pivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>5.pivot->position );
          }
          if ( $<pivotOrUnpivot>5.unpivot != NULL )
          {
              QCP_ADD_POSITION( $<from>$->tableRef->position,
                                $<from>$->tableRef->position,
                                $<pivotOrUnpivot>5.unpivot->position );
          }
      }
    /* PROJ-1832 New database link */
    | TA_REMOTE_TABLE TS_OPENING_PARENTHESIS TI_IDENTIFIER TS_COMMA TL_LITERAL TS_CLOSING_PARENTHESIS opt_as_name 
      {
          qcuSqlSourceInfo    sqlInfo;

          /* check LINK_NAME length */
          if ( $<position>3.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode(
                           qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                           sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);

          QCP_STRUCT_ALLOC($<from>$->tableRef->remoteTable, qmsRemoteTable);
          QCP_SET_INIT_QMS_REMOTE_TABLE( $<from>$->tableRef->remoteTable );
          
          $<from>$->tableRef->remoteTable->mIsStore = ID_FALSE;
          
          SET_POSITION( $<from>$->tableRef->remoteTable->linkName,
                        $<position>3 );
          
          $<from>$->tableRef->remoteTable->remoteQuery.stmtText = QTEXT;
          $<from>$->tableRef->remoteTable->remoteQuery.offset =
              $<position>5.offset + 1;
          $<from>$->tableRef->remoteTable->remoteQuery.size =
              $<position>5.size - 2;
          
          SET_POSITION($<from>$->tableRef->aliasName, $<position>7);

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>6 );
      }
    /* BUG-37077 REMOTE_TABLE_STORE  */
    | TA_REMOTE_TABLE_STORE TS_OPENING_PARENTHESIS TI_IDENTIFIER TS_COMMA TL_LITERAL TS_CLOSING_PARENTHESIS opt_as_name 
      {
#ifdef ALTIBASE_PRODUCT_XDB
          qcuSqlSourceInfo  sqlInfo;
          
          sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
          sqlInfo.init( MEMORY );
          IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                    sqlInfo.getErrMessage() ) );
          sqlInfo.fini();
          YYABORT;
#else
          qcuSqlSourceInfo  sqlInfo;

          /* check LINK_NAME length */
          if ( $<position>3.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW, 
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC( $<from>$, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<from>$ );

          QCP_STRUCT_ALLOC( $<from>$->tableRef, qmsTableRef );
          QCP_SET_INIT_QMS_TABLE_REF( $<from>$->tableRef );

          QCP_STRUCT_ALLOC( $<from>$->tableRef->remoteTable, qmsRemoteTable );
          QCP_SET_INIT_QMS_REMOTE_TABLE( $<from>$->tableRef->remoteTable );
          
          $<from>$->tableRef->remoteTable->mIsStore = ID_TRUE;
          
          SET_POSITION( $<from>$->tableRef->remoteTable->linkName, $<position>3 );
          
          $<from>$->tableRef->remoteTable->remoteQuery.stmtText = QTEXT;
          $<from>$->tableRef->remoteTable->remoteQuery.offset = $<position>5.offset + 1;
          $<from>$->tableRef->remoteTable->remoteQuery.size = $<position>5.size - 2;
          
          SET_POSITION( $<from>$->tableRef->aliasName, $<position>7 );
#endif

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>6 );
      }
    /* PROJ-1832 New database link */
    | remote_table_name TS_AT_SIGN TI_IDENTIFIER opt_as_name
      {
          qcuSqlSourceInfo    sqlInfo;

          /* check TABLE_NAME length */
          if ( $<position>1.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode(
                           qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                           sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          
          /* check LINK_NAME length */
          if ( $<position>3.size > QC_MAX_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode(
                           qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                           sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_STRUCT_ALLOC( $<from>$, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<from>$ );
          
          QCP_STRUCT_ALLOC( $<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF( $<from>$->tableRef );
          
          QCP_STRUCT_ALLOC( $<from>$->tableRef->remoteTable, qmsRemoteTable);
          QCP_SET_INIT_QMS_REMOTE_TABLE( $<from>$->tableRef->remoteTable );
          SET_POSITION( $<from>$->tableRef->remoteTable->tableName,
                        $<position>1 );
          SET_POSITION( $<from>$->tableRef->remoteTable->linkName,
                        $<position>3 );

          SET_POSITION($<from>$->tableRef->aliasName,
                       $<position>4);

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>3 );
      }
    // PROJ-2638
    | shard_stmt_spec TS_OPENING_PARENTHESIS select_or_with_select_statement TS_CLOSING_PARENTHESIS opt_as_name 
      {
          qcuSqlSourceInfo   sqlInfo;
          qcStatement      * sStatement = NULL;

          if ( ( sdi::isShardCoordinator(STATEMENT) == ID_TRUE ) ||
               ( sdi::isPartialCoordinator(STATEMENT) == ID_TRUE ) )
          {
              QCP_STRUCT_ALLOC($<from>$, qmsFrom);
              QCP_SET_INIT_QMS_FROM($<from>$);

              QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
              QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);

              QCP_STRUCT_ALLOC(sStatement, qcStatement);
              QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>3)

              sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

              // set shard statement
              sStatement->myPlan->parseTree->stmtShard = $<shardStmtSpec>1.shardType;
              sStatement->myPlan->parseTree->nodes = $<shardStmtSpec>1.nodes;

              // set view
              $<selectParseTree>3->isView      = ID_TRUE;
              $<selectParseTree>3->isShardView = ID_TRUE;

              $<from>$->tableRef->view = sStatement;

              SET_POSITION($<from>$->tableRef->aliasName, $<position>5);
          }
          else
          {
              QCP_STRUCT_ALLOC($<from>$, qmsFrom);
              QCP_SET_INIT_QMS_FROM($<from>$);

              QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
              QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
              SET_POSITION($<from>$->tableRef->aliasName, $<position>5);

              // select_statement
              QCP_STRUCT_ALLOC(sStatement, qcStatement);
              QC_SET_STATEMENT(sStatement, STATEMENT, $<selectParseTree>3)
                  sStatement->myPlan->parseTree->stmtKind = QCI_STMT_SELECT;

              // set view
              $<selectParseTree>3->isView      = ID_TRUE;
              $<selectParseTree>3->isShardView = ID_FALSE;

              $<from>$->tableRef->view = sStatement;
          }

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>2,
                            $<position>4 );
      }
    // BUG-41311 table function
    | TR_TABLE TS_OPENING_PARENTHESIS table_func_argument TS_CLOSING_PARENTHESIS opt_as_name
      {
          qcuSqlSourceInfo    sqlInfo;

          QCP_STRUCT_ALLOC( $<from>$, qmsFrom );
          QCP_SET_INIT_QMS_FROM( $<from>$ );
          
          QCP_STRUCT_ALLOC( $<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF( $<from>$->tableRef );
          
          $<from>$->tableRef->funcNode = $<expression>3[0];
          
          SET_POSITION($<from>$->tableRef->aliasName, $<position>5);

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>4 );
      }
    | dump_object_table
      {
          $<from>$ = $<from>1;
      }
    ;

shard_stmt_spec
    : TA_SHARD
      {
          $<shardStmtSpec>$.position = $<position>1;
          $<shardStmtSpec>$.shardType = QC_STMT_SHARD_ANALYZE;
          $<shardStmtSpec>$.nodes = NULL;
      }
    | TA_NODE_META
      {
          $<shardStmtSpec>$.position = $<position>1;
          $<shardStmtSpec>$.shardType = QC_STMT_SHARD_META;
          $<shardStmtSpec>$.nodes = NULL;
      }
    | TA_NODE_DATA TS_CLOSING_BRACKET
      {
          $<shardStmtSpec>$.position = $<position>1;
          $<shardStmtSpec>$.shardType = QC_STMT_SHARD_DATA;
          $<shardStmtSpec>$.nodes = NULL;
      }
    | TA_NODE_DATA TS_OPENING_PARENTHESIS TS_CLOSING_PARENTHESIS
      TS_CLOSING_BRACKET
      {
          $<shardStmtSpec>$.position = $<position>1;
          $<shardStmtSpec>$.shardType = QC_STMT_SHARD_DATA;
          $<shardStmtSpec>$.nodes = NULL;
      }
    | TA_NODE_DATA TS_OPENING_PARENTHESIS shard_node_commalist TS_CLOSING_PARENTHESIS
      TS_CLOSING_BRACKET
      {
          $<shardStmtSpec>$.position = $<position>1;
          $<shardStmtSpec>$.shardType = QC_STMT_SHARD_DATA;
          $<shardStmtSpec>$.nodes = $<shardNodes>3;
      }
    ;

shard_node_commalist
    : shard_node_commalist TS_COMMA shard_node_element
      {
          qcShardNodes  * sLast;

          $<shardNodes>$ = $<shardNodes>1;
          for ( sLast = $<shardNodes>1; sLast->next != NULL; sLast = sLast->next );
          sLast->next = $<shardNodes>3;
      }
    | shard_node_element
      {
          $<shardNodes>$ = $<shardNodes>1;
      }
    ;

shard_node_element
    : TL_LITERAL
      {
          qcNamePosition sPosition;

          sPosition.stmtText = $<position>1.stmtText;
          sPosition.offset   = $<position>1.offset + 1;
          sPosition.size     = $<position>1.size - 2;

          QCP_STRUCT_ALLOC( $<shardNodes>$, qcShardNodes );
          SET_POSITION( $<shardNodes>$->namePos, sPosition);
          $<shardNodes>$->next = NULL;
      }
    ;

table_func_argument
    : unified_invocation
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    | TO_VC2COLL TS_OPENING_PARENTHESIS list_expression TS_CLOSING_PARENTHESIS
      {
          $<expression>$[0] = $<expression>3[0];
          $<expression>$[1] = $<expression>3[1];

          QCP_TEST( qtc::changeNodeByModule( STATEMENT,
                                            $<expression>$,
                                            &mtfVc2coll,
                                            &($<position>1),
                                            &($<position>4) )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_TEST( qtc::makeNode( STATEMENT,
                                   $<expression>$,
                                   &( $<position>1 ),
                                   (const UChar*)($<position>1.stmtText+
                                                  $<position>1.offset),
                                   $<position>1.size )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_PERIOD column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_TEST( qtc::makeColumn( STATEMENT, $<expression>$,
                                     NULL,
                                     &$<position>1,
                                     &$<position>3,
                                     NULL )
                    != IDE_SUCCESS );
      }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER TS_PERIOD column_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>5.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>5 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_TEST( qtc::makeColumn( STATEMENT, $<expression>$,
                                     &$<position>1,
                                     &$<position>3,
                                     &$<position>5,
                                     NULL )
                    != IDE_SUCCESS );
      }
    ;

remote_table_name
    : TI_NONQUOTED_IDENTIFIER
    | TI_QUOTED_IDENTIFIER
    ;

opt_pivot_or_unpivot_clause
    : /* empty */
      {
          $<pivotOrUnpivot>$.pivot = NULL;
          $<pivotOrUnpivot>$.unpivot = NULL;
      }
    | pivot_clause
      {
          $<pivotOrUnpivot>$.pivot = $<pivot>1;
          $<pivotOrUnpivot>$.unpivot = NULL;
      }
    | unpivot_clause
      {
          $<pivotOrUnpivot>$.pivot = NULL;
          $<pivotOrUnpivot>$.unpivot = $<unpivot>1;
      }
    ;

pivot_clause
    : TO_PIVOT TS_OPENING_PARENTHESIS pivot_aggregation_list pivot_for pivot_in TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<pivot>$, qmsPivot);
          QCP_SET_INIT_QMS_PIVOT($<pivot>$);
          $<pivot>$->aggrNodes  = $<pivotAggr>3;
          $<pivot>$->columnNode = $<expression>4[0];
          $<pivot>$->valueNode  = $<expression>5[0];

          // position 
          QCP_ADD_POSITION( $<pivot>$->position,
                            $<position>1,
                            $<position>6 );
      }
    ;

pivot_aggregation_list
    : pivot_aggregation_list TS_COMMA pivot_aggregation
      {
          qmsPivotAggr *sLast;

          // BUG-36739
          $<pivotAggr>$ = $<pivotAggr>1;

          for ( sLast = $<pivotAggr>1 ; sLast->next != NULL ; sLast = sLast->next ) ;
          sLast->next = $<pivotAggr>3;
      }
    | pivot_aggregation
      {
          $<pivotAggr>$ = $<pivotAggr>1;
      }
    ;

pivot_aggregation
    : TI_IDENTIFIER TS_OPENING_PARENTHESIS arithmetic_expression TS_CLOSING_PARENTHESIS opt_as_name
      {
          QCP_STRUCT_ALLOC($<pivotAggr>$, qmsPivotAggr);
          QCP_SET_INIT_QMS_PIVOT_AGGREGATION_NODE($<pivotAggr>$);

          SET_POSITION($<pivotAggr>$->aggrFunc, $<position>1);
          SET_POSITION($<pivotAggr>$->aliasName, $<position>5);
          $<pivotAggr>$->node = $<expression>3[0];
      }
    | TI_IDENTIFIER TS_OPENING_PARENTHESIS TS_ASTERISK TS_CLOSING_PARENTHESIS opt_as_name
      {
          QCP_STRUCT_ALLOC($<pivotAggr>$, qmsPivotAggr);
          QCP_SET_INIT_QMS_PIVOT_AGGREGATION_NODE($<pivotAggr>$);

          SET_POSITION($<pivotAggr>$->aggrFunc, $<position>1);
          SET_POSITION($<pivotAggr>$->aliasName, $<position>5);

          QCP_TEST( qtc::makeNode( STATEMENT,
                                    &$<pivotAggr>$->node,
                                    &($<position>3),
                                    (const UChar*)"*",
                                    1 )
                     != IDE_SUCCESS );
      }
    ;

pivot_for
    : TR_FOR TS_OPENING_PARENTHESIS column_name TS_CLOSING_PARENTHESIS
      {
          qcuSqlSourceInfo sqlInfo;
          
          if ( $<position>3.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>3 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_TEST( qtc::makeColumn( STATEMENT, $<expression>$,
                                     NULL,
                                     NULL,
                                     &$<position>3,
                                     NULL )
                    != IDE_SUCCESS );
      }
    | TR_FOR column_name
      {
          qcuSqlSourceInfo sqlInfo;
          
          if ( $<position>2.size > QC_MAX_OBJECT_NAME_LEN )
          {
              sqlInfo.setSourceInfo( STATEMENT, &$<position>2 );
              sqlInfo.init( MEMORY );
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }
          
          QCP_TEST( qtc::makeColumn( STATEMENT, $<expression>$,
                                     NULL,
                                     NULL,
                                     &$<position>2,
                                     NULL )
                    != IDE_SUCCESS );
      }
    ;

pivot_in
    : TR_IN TS_OPENING_PARENTHESIS pivot_in_item_list TS_CLOSING_PARENTHESIS
      {
          $<expression>$[0] = $<expression>3[0];
          $<expression>$[1] = $<expression>3[1];
          QCP_TEST( qtc::changeNode( STATEMENT, $<expression>$,
                                     &($<position>2), &($<position>4) )
                    != IDE_SUCCESS );
      }
    ;

pivot_in_item_list
    : pivot_in_item_list TS_COMMA pivot_in_item
      {
          if( $<expression>1[0]->node.module != NULL )
          {
              QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$,
                                       &($<expression>1[0]->position), (const UChar*)"", 0 )
                        != IDE_SUCCESS );
              QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                        != IDE_SUCCESS );
          }
          else
          {
              $<expression>$[0] = $<expression>1[0];
              $<expression>$[1] = $<expression>1[1];
          }
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | pivot_in_item
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

pivot_in_item
    : constant_plus_minus_prior opt_as_name
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];

          // alias userName Ѵ.
          SET_POSITION( $<expression>$[0]->userName,  $<position>2 );
      }
    ;

unpivot_clause
    : TO_UNPIVOT opt_include_nulls TS_OPENING_PARENTHESIS unpivot_column TR_FOR unpivot_column unpivot_in TS_CLOSING_PARENTHESIS
      {   
          QCP_STRUCT_ALLOC($<unpivot>$, qmsUnpivot);
          QCP_SET_INIT_QMS_UNPIVOT($<unpivot>$);
          $<unpivot>$->isIncludeNulls = $<boolType>2;
          $<unpivot>$->valueColName = $<unpivotColName>4;
          $<unpivot>$->measureColName = $<unpivotColName>6;
          $<unpivot>$->inColInfo = $<unpivotInColInfo>7;

          // position 
          QCP_ADD_POSITION( $<unpivot>$->position,
                            $<position>1,
                            $<position>8 );
      }
    ;

opt_include_nulls
    :  /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
    | TI_NONQUOTED_IDENTIFIER TO_NULLS
      {
          qcuSqlSourceInfo    sqlInfo;

          if (idlOS::strMatch(
                  "INCLUDE", 7,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<boolType>$ = ID_TRUE;
          }
          else if (idlOS::strMatch(
                  "EXCLUDE", 7,
                  QTEXT+$<position>1.offset, $<position>1.size) == 0)
          {
              $<boolType>$ = ID_FALSE;
          }
          else
          { // syntax error
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        sqlInfo.getErrMessage() ) );
              sqlInfo.fini();
              YYABORT;
          }
      }
    ;

unpivot_column
    : TS_OPENING_PARENTHESIS unpivot_colname_list TS_CLOSING_PARENTHESIS
      {
          $<unpivotColName>$ = $<unpivotColName>2;
      }
    | unpivot_colname
      {
          $<unpivotColName>$ = $<unpivotColName>1;
      }
    ;

unpivot_colname_list
    : unpivot_colname_list TS_COMMA unpivot_colname
      {
          qmsUnpivotColName * sLast;
          
          $<unpivotColName>$ = $<unpivotColName>1;

          for ( sLast = $<unpivotColName>1 ; sLast->next != NULL ; sLast = sLast->next ) ;
          sLast->next = $<unpivotColName>3;
      }
    | unpivot_colname
      {
          $<unpivotColName>$ = $<unpivotColName>1;
      }
    ;

unpivot_colname
    : column_name
      {
          QCP_STRUCT_ALLOC( $<unpivotColName>$, qmsUnpivotColName );
          QCP_SET_INIT_QMS_UNPIVOT_COL_NAME( $<unpivotColName>$ );
          SET_POSITION( $<unpivotColName>$->colName, $<position>1 );
      }
    ;

unpivot_in
    : TR_IN TS_OPENING_PARENTHESIS unpivot_in_list TS_CLOSING_PARENTHESIS
      {
          $<unpivotInColInfo>$ = $<unpivotInColInfo>3;
      }
    ;

unpivot_in_list
    : unpivot_in_list TS_COMMA unpivot_in_info
      {
          qmsUnpivotInColInfo * sLast;
          
          $<unpivotInColInfo>$ = $<unpivotInColInfo>1;

          for ( sLast = $<unpivotInColInfo>1 ; sLast->next != NULL ; sLast = sLast->next );
          sLast->next = $<unpivotInColInfo>3;
          
      }
    | unpivot_in_info
      {
          $<unpivotInColInfo>$ = $<unpivotInColInfo>1;
      }
    ;

unpivot_in_info
    : unpivot_in_col_info TR_AS unpivot_in_alias_info
      {   
          QCP_STRUCT_ALLOC( $<unpivotInColInfo>$, qmsUnpivotInColInfo );
          QCP_SET_INIT_QMS_UNPIVOT_IN_COL_INFO( $<unpivotInColInfo>$ );

          $<unpivotInColInfo>$->inColumn = $<unpivotInNode>1;
          $<unpivotInColInfo>$->inAlias = $<unpivotInNode>3;
      }
    | unpivot_in_col_info
      {
          qmsUnpivotInNode   * sInColumn;
          qmsUnpivotInNode   * sInAlias;
          qmsUnpivotInNode   * sPrevInAlias = NULL;
          qcNamePosition     * sLiteral;

          QCP_STRUCT_ALLOC( $<unpivotInColInfo>$, qmsUnpivotInColInfo );
          QCP_SET_INIT_QMS_UNPIVOT_IN_COL_INFO( $<unpivotInColInfo>$ );

          $<unpivotInColInfo>$->inColumn = $<unpivotInNode>1;

          for ( sInColumn  = $<unpivotInNode>1;
                sInColumn != NULL;
                sInColumn  = sInColumn->next )
          {
              QCP_STRUCT_ALLOC( sInAlias, qmsUnpivotInNode );
              QCP_SET_INIT_QMS_UNPIVOT_IN_NODE( sInAlias );

              QCP_STRUCT_ALLOC( sLiteral, qcNamePosition );
              sLiteral->stmtText = sInColumn->inNode->columnName.stmtText;
              sLiteral->offset   = sInColumn->inNode->columnName.offset;
              sLiteral->size     = sInColumn->inNode->columnName.size;

              QCP_TEST( qtc::makeValue( STATEMENT,
                                        &sInAlias->inNode,
                                        (const UChar*)"CHAR",
                                        4,                                        
                                        sLiteral,                                        
                                        (UChar*) sLiteral->stmtText + sLiteral->offset,                                        
                                        sLiteral->size,
                                        MTC_COLUMN_NORMAL_LITERAL )
                        != IDE_SUCCESS );
    
              if ( sInColumn == $<unpivotInNode>1 )
              {
                  $<unpivotInColInfo>$->inAlias = sInAlias;
                  sPrevInAlias = sInAlias;
              }
              else
              {
                  sPrevInAlias->next = sInAlias;
                  sPrevInAlias = sPrevInAlias->next;
              }
          }
      }
    ;

unpivot_in_col_info
    : TS_OPENING_PARENTHESIS unpivot_in_col_list TS_CLOSING_PARENTHESIS
      {
          $<unpivotInNode>$ = $<unpivotInNode>2;
      }
    | unpivot_in_column
      {
          $<unpivotInNode>$ = $<unpivotInNode>1;
      }
    ;

unpivot_in_col_list
    : unpivot_in_col_list TS_COMMA unpivot_in_column
      {
          qmsUnpivotInNode * sLast;

          $<unpivotInNode>$ = $<unpivotInNode>1;

          for ( sLast = $<unpivotInNode>1 ; sLast->next != NULL ; sLast = sLast->next ) ;
          sLast->next = $<unpivotInNode>3;
      }
    |  unpivot_in_column
      {
          $<unpivotInNode>$ = $<unpivotInNode>1;
      }
    ;

unpivot_in_column
    : column_name
      {
          qcuSqlSourceInfo    sqlInfo;
          qtcNode * sNode[2];

          QCP_STRUCT_ALLOC( $<unpivotInNode>$, qmsUnpivotInNode );
          QCP_SET_INIT_QMS_UNPIVOT_IN_NODE( $<unpivotInNode>$ );          

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_TEST( qtc::makeColumn( STATEMENT, sNode,
                                     NULL,
                                     NULL,
                                     &$<position>1,
                                     NULL )
                    != IDE_SUCCESS );

          $<unpivotInNode>$->inNode = sNode[0];
      }
    ;

unpivot_in_alias_info
    : TS_OPENING_PARENTHESIS unpivot_in_alias_list TS_CLOSING_PARENTHESIS
      {
          $<unpivotInNode>$ = $<unpivotInNode>2;
      }
    | unpivot_in_alias
      {
          $<unpivotInNode>$ = $<unpivotInNode>1;

      }
    ;

unpivot_in_alias_list
    : unpivot_in_alias_list TS_COMMA unpivot_in_alias
      {
          qmsUnpivotInNode * sLast;

          $<unpivotInNode>$ = $<unpivotInNode>1;
          for ( sLast = $<unpivotInNode>1 ; sLast->next != NULL ; sLast = sLast->next ) ;
          sLast->next = $<unpivotInNode>3;
      }
    | unpivot_in_alias
      {
          $<unpivotInNode>$ = $<unpivotInNode>1;
      }
    ;

unpivot_in_alias
    : constant_arithmetic_expression
      {   
          QCP_STRUCT_ALLOC( $<unpivotInNode>$, qmsUnpivotInNode );
          QCP_SET_INIT_QMS_UNPIVOT_IN_NODE( $<unpivotInNode>$ );

          $<unpivotInNode>$->inNode = $<expression>1[0];
      }
    ;

constant_arithmetic_expression
    : constant_concatenation
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

constant_concatenation
    : constant_concatenation TS_CONCATENATION_SIGN constant_addition_subtraction
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>2),
                                   (const UChar*)"||", 2 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | constant_addition_subtraction
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

constant_addition_subtraction
    : constant_addition_subtraction TS_PLUS_SIGN  constant_multiplication_division
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>2),
                                   (const UChar*)"+", 1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | constant_addition_subtraction TS_MINUS_SIGN constant_multiplication_division
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>2),
                                   (const UChar*)"-", 1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | constant_multiplication_division
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

constant_multiplication_division
    : constant_multiplication_division TS_ASTERISK constant_plus_minus_prior
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>2),
                                   (const UChar*)"*", 1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | constant_multiplication_division TS_SLASH constant_plus_minus_prior
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>2),
                                   (const UChar*)"/", 1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>1 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>3 )
                    != IDE_SUCCESS );
      }
    | constant_plus_minus_prior
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

constant_plus_minus_prior
    : TS_PLUS_SIGN  constant_terminal_expression
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>1),
                                   (const UChar*)"PLUS", 4 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>2 )
                    != IDE_SUCCESS );
      }
    | TS_MINUS_SIGN constant_terminal_expression
      {
          QCP_TEST( qtc::makeNode( STATEMENT, $<expression>$, &($<position>1),
                                   (const UChar*)"MINUS", 5 )
                    != IDE_SUCCESS );
          QCP_TEST( qtc::addArgument( $<expression>$, $<expression>2 )
                    != IDE_SUCCESS );
      }
    | constant_terminal_expression
      {
          $<expression>$[0] = $<expression>1[0];
          $<expression>$[1] = $<expression>1[1];
      }
    ;

constant_terminal_expression
    : TR_NULL
      {
          QCP_TEST( qtc::makeNullValue( STATEMENT,
                                        $<expression>$,
                                        &$<position>1 )
                    != IDE_SUCCESS );
      }
   | TL_INTEGER
      {
          //----------------------------------------------------------
          //  ͷ   Ѱ  ϴ Data Type
          // Ͽ Index   ִ ɼ ̰,
          //  ͷ  INTEGER ȯϴ 
          //   ŽŲ.
          //----------------------------------------------------------
          //   Type      |    ִ밪              |  Digit 
          //----------------------------------------------------------
          // SMALLINT    |                32767   |      < 5
          // INTEGER     |           2147483647   |      < 10
          // BIGINT      |  9223372036854775807   |      < 19
          //----------------------------------------------------------

          SChar sBuffer[20];

          if ( $<position>1.size < 20 )
          {
              idlOS::memcpy( sBuffer,
                             $<position>1.stmtText + $<position>1.offset,
                             $<position>1.size );
              sBuffer[$<position>1.size] = '\0';
          }
          else
          {
              // Nothing To Do
              // Numeric Type 
          }

          if ( ( $<position>1.size < 5 ) ||
               ( ( $<position>1.size == 5 ) &&
                 ( idlOS::strMatch( sBuffer,
                                    idlOS::strlen( sBuffer ),
                                    "32767",
                                    5 ) <= 0 ) ) )
          {
              QCP_TEST( qtc::makeValue(                      STATEMENT,
                                                        $<expression>$,
                                              (const UChar*)"SMALLINT",
                                                                     8,
                                                         &$<position>1,
                 (UChar*)( $<position>1.stmtText + $<position>1.offset ),
                                                      $<position>1.size,
                                               MTC_COLUMN_NORMAL_LITERAL )
                        != IDE_SUCCESS );
          }
          else if ( ( $<position>1.size < 10 ) ||
                    ( ( $<position>1.size == 10 ) &&
                      ( idlOS::strMatch( sBuffer,
                                         idlOS::strlen( sBuffer ),
                                         "2147483647",
                                         10 ) <= 0 ) ) )
          {
              QCP_TEST( qtc::makeValue(                      STATEMENT,
                                                        $<expression>$,
                                               (const UChar*)"INTEGER",
                                                                     7,
                                                         &$<position>1,
                 (UChar*)( $<position>1.stmtText + $<position>1.offset ),
                                                      $<position>1.size,
                                               MTC_COLUMN_NORMAL_LITERAL )
                        != IDE_SUCCESS );
          }
          else if ( ( $<position>1.size < 19 ) ||
                    ( ( $<position>1.size == 19 ) &&
                      ( idlOS::strMatch( sBuffer,
                                         idlOS::strlen( sBuffer ),
                                         "9223372036854775807",
                                         19 ) <= 0 ) ) )
          {
              QCP_TEST( qtc::makeValue(                      STATEMENT,
                                                        $<expression>$,
                                                (const UChar*)"BIGINT",
                                                                     6,
                                                         &$<position>1,
                 (UChar*)( $<position>1.stmtText + $<position>1.offset ),
                                                      $<position>1.size,
                                               MTC_COLUMN_NORMAL_LITERAL )
                        != IDE_SUCCESS );
          }
          else
          {
              QCP_TEST( qtc::makeValue(                      STATEMENT,
                                                        $<expression>$,
                                               (const UChar*)"FLOAT",
                                                                     5,
                                                         &$<position>1,
                 (UChar*)( $<position>1.stmtText + $<position>1.offset ),
                                                      $<position>1.size,
                                               MTC_COLUMN_NORMAL_LITERAL )
                        != IDE_SUCCESS );
          }
      }
    | TL_NUMERIC
      {
          QCP_TEST( qtc::makeValue(                                 STATEMENT,
                                                               $<expression>$,
                                                      (const UChar*)"FLOAT",
                                                                            5,
                                                                &$<position>1,
                        (UChar*)( $<position>1.stmtText + $<position>1.offset ),
                                                            $<position>1.size,
                                                   MTC_COLUMN_NORMAL_LITERAL )
                    != IDE_SUCCESS );
      }
    | TL_LITERAL
      {
          QCP_TEST( qtc::makeValue(                                 STATEMENT,
                                                               $<expression>$,
                                                         (const UChar*)"CHAR",
                                                                            4,
                                                                &$<position>1,
                    (UChar*)( $<position>1.stmtText + $<position>1.offset + 1 ),
                                                        $<position>1.size - 2,
                                                   MTC_COLUMN_NORMAL_LITERAL )
                    != IDE_SUCCESS );
      }
     // PROJ-1579 NCHAR
    // ex) N''
    | nchar_literal
      {
          // terminal  replication statement
          //  Ͽ rule .
      }
    // PROJ-1579 NCHAR
    // ex) U'\C548'
    | unicode_literal
      {
          // terminal  replication statement
          //  Ͽ rule .
      }
    | TL_TYPED_LITERAL
      {
          UChar           * sType;
          SInt              sTypeLength;
          UChar           * sLiteral;
          SInt              sLiteralLength;

          sType = (UChar*)( $<position>1.stmtText + $<position>1.offset);
          for( sLiteral = sType; *sLiteral != '\''; sLiteral++ ) ;
          sTypeLength = sLiteral - sType;

          idlOS::strUpper(sType, sTypeLength);

          sLiteral++;
          sLiteralLength = $<position>1.size - ( sLiteral - sType ) - 1;

          QCP_TEST( qtc::makeValue(     STATEMENT,
                                   $<expression>$,
                                            sType,
                                      sTypeLength,
                                   &$<position>1,
                                         sLiteral,
                                   sLiteralLength,
                        MTC_COLUMN_NORMAL_LITERAL )
                    != IDE_SUCCESS );
      }
      ;
//--------------------------------------------
// PROJ-1618 Online Disk Index PBT
//--------------------------------------------

dump_object_table
    : TI_IDENTIFIER TS_OPENING_PARENTHESIS dump_object_list TS_CLOSING_PARENTHESIS opt_as_name
      {
          qcuSqlSourceInfo    sqlInfo;
          SChar               sDumpName[QC_MAX_OBJECT_NAME_LEN + 1];

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          // To Fix BUG-16649
          QC_STR_COPY( sDumpName, $<position>1 );
          if ( ( idlOS::strlen( sDumpName ) < 2 ) ||
               ( idlOS::strMatch( sDumpName, 2, "D$", 2 ) != 0 ) )
          {
              sqlInfo.setSourceInfo( STATEMENT, & $<position>1 );
              sqlInfo.init( MEMORY );
              IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_SYNTAX,
                                        "- Invalid Dump Table" ) );
              sqlInfo.fini();
              YYABORT;
          }
          else
          {
              // nothing to do
          }

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          QCP_STRUCT_ALLOC($<from>$->tableRef, qmsTableRef);
          QCP_SET_INIT_QMS_TABLE_REF($<from>$->tableRef);
          SET_POSITION($<from>$->tableRef->tableName, $<position>1);
          SET_POSITION($<from>$->tableRef->aliasName, $<position>5);

          $<from>$->tableRef->mDumpObjList = $<dumpObjList>3;

          $<from>$->tableRef->view             = NULL;
          $<from>$->tableRef->tableInfo        = NULL;
          $<from>$->tableRef->tableAccessHints = NULL;
          $<from>$->tableRef->flag             = 0;

          // position 
          QCP_ADD_POSITION( $<from>$->tableRef->position,
                            $<position>1,
                            $<position>4 );
      }
    ;

dump_object_list
    : dump_object_list TS_COMMA dump_object
      {
          qmsDumpObjList   * sLast;

          // BUG-36739
          $<dumpObjList>$ = $<dumpObjList>1;

          for ( sLast = $<dumpObjList>1;
                sLast->mNext != NULL;
                sLast = sLast->mNext) ;
          sLast->mNext = $<dumpObjList>3;
      }
    | dump_object
      {
          $<dumpObjList>$ = $<dumpObjList>1;
      }
    ;

dump_object
    : TI_IDENTIFIER opt_partition_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<dumpObjList>$, qmsDumpObjList);
          QCP_SET_INIT_QMS_DUMP_OBJECT($<dumpObjList>$);
          SET_POSITION($<dumpObjList>$->mDumpObjPos, $<position>1);
          $<dumpObjList>$->mDumpPartitionRef = $<partitionRef>2;
      }
    | TL_INTEGER opt_partition_name
      {
          // such as TBS ID, PAGE ID
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<dumpObjList>$, qmsDumpObjList);
          QCP_SET_INIT_QMS_DUMP_OBJECT($<dumpObjList>$);
          SET_POSITION($<dumpObjList>$->mDumpObjPos, $<position>1);
          $<dumpObjList>$->mDumpPartitionRef = $<partitionRef>2;
      }
    | TI_IDENTIFIER TS_PERIOD TI_IDENTIFIER opt_partition_name
      {
          qcuSqlSourceInfo    sqlInfo;

          if ($<position>1.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>1 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          if ($<position>3.size > QC_MAX_OBJECT_NAME_LEN)
          {
              sqlInfo.setSourceInfo(STATEMENT, & $<position>3 );
              sqlInfo.init(MEMORY);
              IDE_SET(ideSetErrorCode(qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW,
                                      sqlInfo.getErrMessage() ));
              sqlInfo.fini();
              YYABORT;
          }

          QCP_STRUCT_ALLOC($<dumpObjList>$, qmsDumpObjList);
          QCP_SET_INIT_QMS_DUMP_OBJECT($<dumpObjList>$);
          SET_POSITION($<dumpObjList>$->mUserNamePos, $<position>1);
          SET_POSITION($<dumpObjList>$->mDumpObjPos, $<position>3);
          $<dumpObjList>$->mDumpPartitionRef = $<partitionRef>4;
      }

    ;

joined_table
    : sel_from_table_reference opt_join_type TR_JOIN sel_from_table_reference
        TR_ON expression
      {
          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          $<from>$->joinType = $<joinType>2;
          $<from>$->left     = $<from>1;
          $<from>$->right    = $<from>4;

          $<from>$->tableRef    = NULL;
          $<from>$->next        = NULL;
          $<from>$->onCondition = $<expression>6[0];
      }
    /* PROJ-2418 Cross/Outer APPLY & Lateral View */   
    | sel_from_table_reference apply_type TR_APPLY sel_from_table_single_reference
      {
          qmsFrom          * sFrom;
          qcuSqlSourceInfo   sqlInfo;
          qcNamePosition     sNodePosition;
          qcNamePosition     sArgPosition;
          qtcNode          * sDummyNode[2];
          qtcNode          * sDummyArg1[2];
          qtcNode          * sDummyArg2[2];

          QCP_STRUCT_ALLOC($<from>$, qmsFrom);
          QCP_SET_INIT_QMS_FROM($<from>$);

          sFrom = $<from>4;

          // If LATERAL keyword is already written, an error will be occurred.
          if ( sFrom->tableRef != NULL )
          {  
              if ( ( sFrom->tableRef->flag & QMS_TABLE_REF_LATERAL_VIEW_MASK ) ==
                       QMS_TABLE_REF_LATERAL_VIEW_TRUE )
              {
                  sqlInfo.setSourceInfo( STATEMENT, & $<position>4 );
                  sqlInfo.init( MEMORY );
                  IDE_SET( ideSetErrorCode( qpERR_ABORT_QCP_DUPLICATE_LATERAL_KEYWORD,
                                            sqlInfo.getErrMessage() ) );
                  sqlInfo.fini();
                  YYABORT;
              }
              else
              {
                  // set lateral view attribute
                  sFrom->tableRef->flag &= ~QMS_TABLE_REF_LATERAL_VIEW_MASK;
                  sFrom->tableRef->flag |= QMS_TABLE_REF_LATERAL_VIEW_TRUE;
              } 
          }
          else
          {
              // Nothing to do.
          } 

          // add Dummy Predicate "1 = 1"
          sArgPosition.stmtText = (SChar*)"1";
          sArgPosition.offset   = 0;
          sArgPosition.size     = 1;

          QCP_TEST( qtc::makeValue( STATEMENT,
                                    sDummyArg1,
                                    (const UChar*)"SMALLINT",
                                    8,
                                    & sArgPosition,
                                    (const UChar*)"1",
                                    sArgPosition.size,
                                    MTC_COLUMN_NORMAL_LITERAL )
                    != IDE_SUCCESS );

          QCP_TEST( qtc::makeValue( STATEMENT,
                                    sDummyArg2,
                                    (const UChar*)"SMALLINT",
                                    8,
                                    & sArgPosition,
                                    (const UChar*)"1",
                                    sArgPosition.size,
                                    MTC_COLUMN_NORMAL_LITERAL )
                    != IDE_SUCCESS );

          SET_EMPTY_POSITION( sNodePosition );

          QCP_TEST( qtc::makeNode( STATEMENT,
                                   sDummyNode,
                                   & sNodePosition,
                                   (const UChar*)"=", 1 )
                    != IDE_SUCCESS );

          QCP_TEST( qtc::addArgument( sDummyNode, sDummyArg1 )
                    != IDE_SUCCESS );

          QCP_TEST( qtc::addArgument( sDummyNode, sDummyArg2 )
                    != IDE_SUCCESS );
        
          $<from>$->joinType = $<joinType>2;
          $<from>$->left     = $<from>1;
          $<from>$->right    = $<from>4;

          $<from>$->tableRef    = NULL;
          $<from>$->next        = NULL;
          $<from>$->onCondition = sDummyNode[0];
      }
    ;

opt_join_type
    : /* empty */
      {
          $<joinType>$ = QMS_INNER_JOIN;
      }
    | TR_INNER
      {
          $<joinType>$ = QMS_INNER_JOIN;
      }
    | TR_LEFT opt_outer
      {
          $<joinType>$ = QMS_LEFT_OUTER_JOIN;
      }
    | TR_RIGHT opt_outer
      {
          $<joinType>$ = QMS_RIGHT_OUTER_JOIN;
      }
    | TR_FULL opt_outer
      {
          $<joinType>$ = QMS_FULL_OUTER_JOIN;
      }
    ;

opt_outer
    : /* empty */
    | TR_OUTER
    ;

apply_type
    : TR_CROSS
      {
          $<joinType>$ = QMS_INNER_JOIN;
      }
    | TR_OUTER
      {
          $<joinType>$ = QMS_LEFT_OUTER_JOIN;
      }
    ;

group_concatenation
    : group_concatenation TS_COMMA group_concatenation_element
      {
          qmsConcatElement   * sLastConcat;

          $<concatElement>$ = $<concatElement>1;

          for( sLastConcat = $<concatElement>$ ;
               sLastConcat->next != NULL ;
               sLastConcat = (sLastConcat->next) ) ;
          sLastConcat->next = ($<concatElement>3);
      }
    | group_concatenation_element
      {
          $<concatElement>$ = $<concatElement>1;
      }
    ;

group_concatenation_element
    : normal_rollup_cube_clause
      {
          $<concatElement>$ = $<concatElement>1;
      }
    | grouping_sets_clause
      {
          $<concatElement>$ = $<concatElement>1;
      }
    ;

normal_rollup_cube_clause
    : arithmetic_expression opt_with_rollup
      {
          QCP_STRUCT_ALLOC($<concatElement>$, qmsConcatElement);

          $<concatElement>$->type             = QMS_GROUPBY_NORMAL;
          $<concatElement>$->arithmeticOrList = $<expression>1[0];
          $<concatElement>$->next             = NULL;
          $<concatElement>$->arguments        = NULL;
         
          if ( $<boolType>2 == ID_TRUE )
          {
              $<concatElement>$->type = QMS_GROUPBY_WITH_ROLLUP;
          }

          SET_POSITION( $<concatElement>$->position, $<expression>1[0]->position );
      }
    | TR_ROLLUP TS_OPENING_PARENTHESIS rollup_cube_argument_list TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<concatElement>$, qmsConcatElement);

          $<concatElement>$->type             = QMS_GROUPBY_ROLLUP;
          $<concatElement>$->arithmeticOrList = NULL;
          $<concatElement>$->next             = NULL;
          $<concatElement>$->arguments        = $<concatElement>3;
          
          SET_POSITION( $<concatElement>$->position, $<position>1 );
          QCP_ADJUST_POSITION( $<concatElement>$, $<position>4 );
      }
    | TR_CUBE TS_OPENING_PARENTHESIS rollup_cube_argument_list TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<concatElement>$, qmsConcatElement);

          $<concatElement>$->type             = QMS_GROUPBY_CUBE;
          $<concatElement>$->arithmeticOrList = NULL;
          $<concatElement>$->next             = NULL;
          $<concatElement>$->arguments        = $<concatElement>3;
          
          SET_POSITION( $<concatElement>$->position, $<position>1 );
          QCP_ADJUST_POSITION( $<concatElement>$, $<position>4 );
      }
    ;

opt_with_rollup
    : /* empty */
      {
          $<boolType>$ = ID_FALSE;
      }
      | TC_WITH_ROLLUP
      {
          $<boolType>$ = ID_TRUE;
      }
    ;

grouping_sets_clause
    : TR_GROUPING_SETS TS_OPENING_PARENTHESIS grouping_sets_list TS_CLOSING_PARENTHESIS
      {
          QCP_STRUCT_ALLOC($<concatElement>$, qmsConcatElement);

          $<concatElement>$->type             = QMS_GROUPBY_GROUPING_SETS;
          $<concatElement>$->arithmeticOrList = NULL;
          $<concatElement>$->next             = NULL;
          $<concatElement>$->arguments        = $<concatElement>3;
          
          SET_POSITION( $<concatElement>$->position, $<position>1 );
          QCP_ADJUST_POSITION( $<concatElement>$, $<position>4 );
      }
    ;

grouping_sets_list
    : grouping_sets_list TS_COMMA normal_rollup_cube_clause
      {
          qmsConcatElement * sLastConcat;

          $<concatElement>$ = $<concatElement>1;

          for ( sLastConcat = $<concatElement>1;
                sLastConcat->next != NULL;
                sLastConcat = sLastConcat->next );
          sLastConcat->next = $<concatElement>3;
      }
    | grouping_sets_list TS_COMMA empty_group_operator
      {
          // PROJ-2415 Grouping Sets Clause
          qmsConcatElement * sLastConcat;

          $<concatElement>$ = $<concatElement>1;

          for ( sLastConcat = $<concatElement>1;
                sLastConcat->next != NULL