/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: qdbAlter.cpp 91576 2021-09-02 06:39:41Z donghyun1 $
 **********************************************************************/

#include <idl.h>
#include <ide.h>
#include <smiTableSpace.h>
#include <qdbCommon.h>
#include <qdbAlter.h>
#include <qdn.h>
#include <qmv.h>
#include <qtc.h>
#include <qcm.h>
#include <qcg.h>
#include <qmc.h>
#include <qcmCache.h>
#include <qcmUser.h>
#include <qcmTableSpace.h>
#include <qmvQuerySet.h>
#include <qmo.h>
#include <qmn.h>
#include <qcmTableInfo.h>
#include <qcmView.h>
#include <qcuTemporaryObj.h>
#include <qcuSqlSourceInfo.h>
#include <qdx.h>
#include <qdd.h>
#include <qmx.h>
#include <qcmProc.h>
#include <qdpPrivilege.h>
#include <qdnTrigger.h>
#include <qdtCommon.h>
#include <qmoPartition.h> // PROJ-1502 PARTITIONED DISK TABLE
#include <qdbComment.h>
#include <qcsModule.h>
#include <qdnCheck.h>
#include <qmsDefaultExpr.h>
#include <qcmAudit.h>
#include <qcmDictionary.h>
#include <qcmPkg.h>
#include <qcc.h>
#include <qdpRole.h>
#include <sdi.h>
#include <sdiGlobalDDL.h>

IDE_RC qdbAlter::validateAddCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ADD COLUMN ...  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ Replication ɷ, Recovery θ Ȯ
 *    5.  ÷ validation ˻ 
 *       => qdbCommon::validateColumnList ȣ
 *    6. ߰Ǵ constraint   validation 
 *       => qdn::validateConstraints ȣ
 *       => Check Constraint 
 *    7. close  ̺ ƴ üũ
 *    8. UNIQUE KEY, PRIMARY KEY    ̵ ε
 *       ̺̽   DEFAULT TABLESPACE ID 
 *       Ÿ оͼ ĽƮ 
 *    9. ̺ Replication ɷ,
 *       FOREIGN KEY, UNIQUE KEY, NOT NULL, Check Constraint Column ߰   Ȯ
 *    10. ǽð Add Column   ˻
 *
 ***********************************************************************/

    qdTableParseTree     * sParseTree;
    SInt                   sColumnCount;
    UInt                   sUniqueKeyCnt;
    qcuSqlSourceInfo       sqlInfo;
    smiTableSpaceAttr      TBSAttr;
    qdPartitionAttribute * sPartAttr;

    SInt                   sNewColCnt;
    qcmColumn            * sNewColumns;
    qcmColumn            * sColumn = NULL;
    qcmColumn            * sLobColumn = NULL;
    qcmPartitionInfoList * sPartInfoList;
    qdPartitionAttribute * sNewPartAttr = NULL;
    qcmTableInfo         * sPartInfo;
    UInt                   sPartCnt = 0;
    UInt                   i;
    idBool                 sIsFound = ID_FALSE;
    qdLobAttribute       * sLobAttr;
    qcmTableInfo         * sTempPartInfo;
    smSCN                  sSCN;
    void                 * sHandle;

    qdConstraintSpec     * sCurrConstr = NULL;
    qcmCompressionColumn * sCompColumn = NULL;
    qcmCompressionColumn * sCompPrev = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

#if defined(DEBUG)
    // BUG-38501
    // PROJ-2264 Dictionary table
    if ( QCU_FORCE_COMPRESSION_COLUMN == 1 )
    {
        //   ϴ 쿡  compression column  .
        // 1. Debug   Ǿ 
        // 2. Partition table  ƴ 
        // 3. Dictionary table  ƴ 
        // 4. Compress   
        // 5. Data memory/disk table  
        // 6. Compression column  Ǵ  Ÿ 

        if (smiTableSpace::isDataTableSpaceType( sParseTree->TBSAttr.mType ) == ID_TRUE )
        {
            if ((smiTableSpace::isMemTableSpaceType(sParseTree->TBSAttr.mType) != ID_TRUE) &&
                (smiTableSpace::isDiskTableSpaceType(sParseTree->TBSAttr.mType) != ID_TRUE))
            {
                /* do not compress */
                IDE_CONT(LABEL_PASS);
            }
            else
            {
                /* nothing to do */
            }
        }
        else
        {
            /* do not compress */
            IDE_CONT(LABEL_PASS);
        }

        if ( ( sParseTree->tableInfo->tablePartitionType != QCM_PARTITIONED_TABLE ) &&
             ( ( sParseTree->tableAttrValue & SMI_TABLE_DICTIONARY_MASK ) ==
               SMI_TABLE_DICTIONARY_FALSE ) &&
             ( sParseTree->compressionColumn == NULL ))
        {
            for( sColumn = sParseTree->columns; sColumn != NULL; sColumn = sColumn->next )
            {
                switch( sColumn->basicInfo->type.dataTypeId )
                {
                    case MTD_CHAR_ID :
                    case MTD_VARCHAR_ID :
                    case MTD_NCHAR_ID :
                    case MTD_NVARCHAR_ID :
                    case MTD_BYTE_ID :
                    case MTD_VARBYTE_ID :
                    case MTD_NIBBLE_ID :
                    case MTD_BIT_ID :
                    case MTD_VARBIT_ID :
                    case MTD_DATE_ID :
                        // Column  ũ(size) smOID   skip
                        // 켱 compression ϸ     ϰԵǰ
                        // in-place update ÿ logging  ߻ϰ ȴ.
                        if( sColumn->basicInfo->column.size < ID_SIZEOF(smOID) )
                        {
                            sColumn->basicInfo->column.flag &= ~SMI_COLUMN_COMPRESSION_MASK;
                            sColumn->basicInfo->column.flag |= SMI_COLUMN_COMPRESSION_FALSE;
                        }
                        else
                        {
                            // BUG-38670
                            // Hidden column  compress 󿡼 Ѵ.
                            // (Function based index)
                            if ( (sColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
                                 == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
                            {
                                sColumn->basicInfo->column.flag &= ~SMI_COLUMN_COMPRESSION_MASK;
                                sColumn->basicInfo->column.flag |= SMI_COLUMN_COMPRESSION_FALSE;
                            }
                            else
                            {
                                // Compression column  Ÿ flag 
                                sColumn->basicInfo->column.flag &= ~SMI_COLUMN_COMPRESSION_MASK;
                                sColumn->basicInfo->column.flag |= SMI_COLUMN_COMPRESSION_TRUE;

                                IDE_TEST( QC_QMP_MEM(aStatement)->alloc( ID_SIZEOF(qcmCompressionColumn),
                                                                         (void**)&sCompColumn )
                                          != IDE_SUCCESS );
                                QCM_COMPRESSION_COLUMN_INIT( sCompColumn );
                                SET_POSITION(sCompColumn->namePos, sColumn->namePos);

                                if( sCompPrev == NULL )
                                {
                                    sParseTree->compressionColumn = sCompColumn;
                                    sCompPrev                     = sCompColumn;
                                }
                                else
                                {
                                    sCompPrev->next               = sCompColumn;
                                    sCompPrev                     = sCompPrev->next;
                                }
                            }
                        }
                        break;
                    default :
                        sColumn->basicInfo->column.flag &= ~SMI_COLUMN_COMPRESSION_MASK;
                        sColumn->basicInfo->column.flag |= SMI_COLUMN_COMPRESSION_FALSE;
                        break;
                }
            }
        }
    }

    IDE_EXCEPTION_CONT(LABEL_PASS);
#endif

    if(sParseTree->tableInfo->replicationCount > 0)
    {
        /* PROJ-1442 Replication Online  DDL 
         * Recovery ɰ    
         */
        IDE_TEST_RAISE(sParseTree->tableInfo->replicationRecoveryCount > 0,
                       ERR_CANNOT_DDL_WITH_RECOVERY);

        if ( sParseTree->compressionColumn != NULL )
        {
            IDE_RAISE( ERR_COMPRESSION_COL_WITH_REPL );
        }
        else
        {
            /* Nothing to do */
        }
    }
    else
    {
        // Nothing to do.
    }

    // PROJ-2264 Dictionary table
    IDE_TEST( qcmDictionary::validateCompressColumn( aStatement,
                                                     sParseTree,
                                                     sParseTree->tableInfo->TBSType )
              != IDE_SUCCESS );

    // validation of columns specification
    sColumnCount = sParseTree->tableInfo->columnCount;
    IDE_TEST( qdbCommon::validateColumnListForAddCol( aStatement,
                                                      sParseTree->tableInfo,
                                                      sParseTree->columns,
                                                      sColumnCount )
              != IDE_SUCCESS );

    for ( sNewColumns = sParseTree->columns, sNewColCnt = 0;
          sNewColumns != NULL;
          sNewColumns = sNewColumns->next, sNewColCnt++ )
    {
        // Nothing to do.
    }

    idlOS::memset( &TBSAttr, 0, ID_SIZEOF( smiTableSpaceAttr ) );

    // PROJ-1362
    // validation of lob column attributes
    TBSAttr.mID = sParseTree->tableInfo->TBSID;
    TBSAttr.mType = sParseTree->tableInfo->TBSType;

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType
        == QCM_NONE_PARTITIONED_TABLE )
    {
        IDE_TEST_RAISE( sParseTree->partTable->partAttr != NULL,
                        ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );
    }
    else
    {
        // nothing to do
    }

    IDE_TEST(qdbCommon::validateLobAttributeList(
                 aStatement,
                 sParseTree->tableInfo,
                 sParseTree->columns,
                 &TBSAttr,
                 sParseTree->lobAttr )
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        // ADD COLUMN  Ľ̴ܰ迡
        // sParseTree->partTable ޸ Ҵ Ǿ ִ.

        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );

        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &(sParseTree->oldIndexTables) )
                  != IDE_SUCCESS );
        
        sPartInfoList = sParseTree->partTable->partInfoList;

        for( sPartCnt = 0;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, sPartCnt++ )
        {
            // Nothing to do.
        }

        IDU_LIMITPOINT("qdbAlter::validateAddCol::malloc");
        IDE_TEST(QC_QMP_MEM(aStatement)->cralloc(
                     ID_SIZEOF(qdPartitionAttribute) * sPartCnt,
                     (void**)& sNewPartAttr )
                 != IDE_SUCCESS);

        for( i = 0, sPartInfoList = sParseTree->partTable->partInfoList;
             sPartInfoList != NULL;
             i++, sPartInfoList = sPartInfoList->next )
        {
            //  Ƽ ŭ ݺϸ TBS 
            sPartInfo = sPartInfoList->partitionInfo;

            for( sPartAttr = sParseTree->partTable->partAttr;
                 sPartAttr != NULL;
                 sPartAttr = sPartAttr->next )
            {
                if( qcmPartition::getPartitionInfo( aStatement,
                                                    sParseTree->tableInfo->tableID,
                                                    sPartAttr->tablePartName,
                                                    & sTempPartInfo,
                                                    & sSCN,
                                                    & sHandle )
                    != IDE_SUCCESS )
                {
                    sqlInfo.setSourceInfo(aStatement,
                                          & sPartAttr->tablePartName);
                    IDE_RAISE( ERR_NOT_EXIST_TABLE_PARTITION );
                }

                if ( idlOS::strMatch( sPartAttr->tablePartName.stmtText + sPartAttr->tablePartName.offset,
                                      sPartAttr->tablePartName.size,
                                      sPartInfo->name,
                                      idlOS::strlen( sPartInfo->name ) ) == 0 )
                {
                    break;
                }
            }

            /* PROJ-2464 hybrid partitioned table  */
            IDE_TEST( qdbCommon::copyAndAdjustColumnList( aStatement,
                                                          TBSAttr.mType,
                                                          sPartInfo->TBSType,
                                                          sParseTree->columns,
                                                          &(sNewPartAttr[i].columns),
                                                          sNewColCnt,
                                                          ID_FALSE /* aEnableVariableColumn */ )
                      != IDE_SUCCESS );

            for( sColumn = sNewPartAttr[i].columns;
                 sColumn != NULL;
                 sColumn = sColumn->next )
            {
                if ((sColumn->basicInfo->module->flag & MTD_COLUMN_TYPE_MASK)
                    == MTD_COLUMN_TYPE_LOB)
                {
                    sIsFound = ID_FALSE;

                    for( sLobAttr = sParseTree->lobAttr;
                         sLobAttr != NULL;
                         sLobAttr = sLobAttr->next )
                    {
                        for( sLobColumn = sLobAttr->columns;
                             sLobColumn != NULL;
                             sLobColumn = sLobColumn->next )
                        {
                            if ( QC_IS_NAME_MATCHED( sLobColumn->namePos, sColumn->namePos ) )
                            {
                                sIsFound = ID_TRUE;
                                break;
                            }
                        }

                        if( sLobAttr->columns == NULL )
                        {
                            sIsFound = ID_TRUE;
                        }

                        if( sIsFound == ID_TRUE )
                        {
                            break;
                        }
                    }

                    if( sIsFound != ID_TRUE )
                    {
                        sColumn->basicInfo->column.colSpace = sPartInfo->TBSID;
                    }
                }
                else
                {
                    sColumn->basicInfo->column.colSpace = sPartInfo->TBSID;
                }
            }

            if( sPartAttr != NULL )
            {
                sNewPartAttr[i].lobAttr = sPartAttr->lobAttr;

                TBSAttr.mID = sPartInfo->TBSID;
                TBSAttr.mType = sPartInfo->TBSType;

                IDE_TEST(qdbCommon::validateLobAttributeList(
                             aStatement,
                             sParseTree->tableInfo,
                             sNewPartAttr[i].columns,
                             & TBSAttr,
                             sPartAttr->lobAttr )
                         != IDE_SUCCESS);
            }

            sNewPartAttr[i].next = NULL;

            if( i > 0 )
            {
                sNewPartAttr[i-1].next = &sNewPartAttr[i];
            }
        }
        sParseTree->partTable->partAttr = sNewPartAttr;
    }

    // validation of constraints
    IDE_TEST(qdn::validateConstraints(
                 aStatement,
                 sParseTree->tableInfo,
                 sParseTree->tableInfo->tableOwnerID,
                 sParseTree->tableInfo->TBSID,
                 sParseTree->tableInfo->TBSType,
                 sParseTree->constraints,
                 QDN_ON_ADD_COLUMN,
                 &sUniqueKeyCnt) != IDE_SUCCESS);

    /* PROJ-2464 hybrid partitioned table 
     *  - qdn::validateConstraints, Tablespace Validate Ŀ ȣ
     */
    IDE_TEST( qdbCommon::validateConstraintRestriction( aStatement,
                                                        sParseTree )
              != IDE_SUCCESS );

    /* PROJ-1107 Check Constraint  */
    for ( sCurrConstr = sParseTree->constraints;
          sCurrConstr != NULL;
          sCurrConstr = sCurrConstr->next )
    {
        if ( sCurrConstr->constrType == QD_CHECK )
        {
            sqlInfo.setSourceInfo( aStatement,
                                   &(sCurrConstr->checkCondition->position) );
            IDE_RAISE( ERR_SET_CHECK_CONSTRAINT );
        }
        else
        {
            /* Nothing to do */
        }
    }

    // set default TBS
    if ( sUniqueKeyCnt > 0 )
    {
        sParseTree->TBSAttr.mID = sParseTree->tableInfo->TBSID;
        /*    ̺ ̺̽ Ѵ
           IDE_TEST( qcmUser::getDefaultTBS(
           aStatement,
           sParseTree->tableInfo->tableOwnerID,
           &(sParseTree->TBSAttr.mID)) != IDE_SUCCESS );
        */
    }

    // PROJ-1442 Replication Online  DDL 
    if(sParseTree->tableInfo->replicationCount > 0)
    {
        for(sCurrConstr = sParseTree->constraints;
            sCurrConstr != NULL;
            sCurrConstr = sCurrConstr->next)
        {
            // Replication  Table Foreign Key ߰  
            IDE_TEST_RAISE(sCurrConstr->constrType == QD_FOREIGN,
                           ERR_FOREIGN_KEY_ON_REPLICATED_TABLE);
        } 
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }

    // key size limit ˻
    /* BUG-13528 : qdn::validateConstraints()  
       IDE_TEST( qdbCommon::validateKeySizeLimit(
       aStatement,
       sParseTree->tableInfo,
       sParseTree->constraints) != IDE_SUCCESS );
    */

    // check QC_MAX_COLUMN_COUNT in qc.h

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_CANNOT_DDL_WITH_RECOVERY)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DDL_WITH_RECOVERY));
    }
    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_NOT_EXIST_TABLE_PARTITION)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QCM_NOT_EXIST_TABLE_PARTITION,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_FOREIGN_KEY_ON_REPLICATED_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDN_ADD_COL_FOREIGN_KEY_WITH_REPLICATED_TBL));
    }
    IDE_EXCEPTION( ERR_SET_CHECK_CONSTRAINT );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NOT_ALLOWED_CHECK_CONSTRAINT,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_COMPRESSION_COL_WITH_REPL );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_ADD_COL_COMPRESSION_COL_WITH_REPLICATED_TBL));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateDropCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... DROP COLUMN ...  validation 
 *
 *    )
 *    hidden column    ִ.
 *
 * Implementation :
 *    1. ϴ ̺ üũ
 *    2. ALTER Ϸ ̺ Ÿ ̸̺  ȯ
 *    3. ALTER TABLE  ִ üũ
 *    4. ̺ Replication ɷ, Recovery θ Ȯ
 *    5.  ÷ ϴ üũ
 *    6. ÷   ̺ ÷ ϳ  ȴٸ  ȯ
 *    7. ϰ ϴ ÷ ϰ ִ Ű ִٸ  ȯ
 *    8. ̺ Replication ɷ,
 *       PRIMARY KEY, UNIQUE KEY, NOT NULL, Check Constraint, Function-based Index Column
 *          Ȯ
 *    9. Multi-column  Constraint , Ϻ Column    Ȯ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateDropCol"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    qcmColumn           * sParseColumn;
    qcmColumn           * sColumn;
    UInt                  sColumnCount = 0;
    UInt                  sConstColumnCount;
    UInt                  i;
    UInt                * sIndexColList;
    qcmIndex            * sIndexInfo;
    qcmRefChildInfo     * sChildInfo = NULL;  // BUG-28049
    qcmTableInfo        * sTableInfo;
    qcmIndex            * sPKIndex = NULL;
    qcmCheck            * sCheck = NULL;

    /* PROJ-1090 Function-based Index */
    idBool                sIsRelatedToFunctionBasedIndex = ID_FALSE;
    mtcColumn           * sMtcColumn    = NULL;
    qcmColumn           * sQcmColumn    = NULL;
    qcmColumn           * sHiddenColumn = NULL;
    qcuSqlSourceInfo      sqlInfo;
    UInt                  j;
    
    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    /* PROJ-1442 Replication Online  DDL 
     * Recovery ɰ    
     */
    if(sTableInfo->replicationCount > 0)
    {
        IDE_TEST_RAISE(sTableInfo->replicationRecoveryCount > 0,
                       ERR_CANNOT_DDL_WITH_RECOVERY);
    }

    for ( sParseColumn = sParseTree->columns;
          sParseColumn != NULL;
          sParseColumn = sParseColumn->next )
    {
        // check column existence
        IDE_TEST( qcmCache::getColumn( aStatement,
                                       sTableInfo,
                                       sParseColumn->namePos,
                                       &sColumn )
                  != IDE_SUCCESS );
        QDB_SET_QCM_COLUMN( sParseColumn, sColumn );

        // column name Ѵ.
        idlOS::strncpy( sParseColumn->name,
                        sColumn->name,
                        QC_MAX_OBJECT_NAME_LEN + 1 );
        sParseColumn->name[QC_MAX_OBJECT_NAME_LEN] = '\0';
    }

    /* PROJ-1090 Function-based Index
     *  Function-Based Index  Column ,
     *  Function-Based Index  Hidden Column  Ѵ.
     */
    for ( sParseColumn = sParseTree->columns;
          sParseColumn != NULL;
          sParseColumn = sParseColumn->next )
    {
        if ( (sParseColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
             == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
        {
            /* hidden column hidden column Ѵ. */
        }
        else
        {
            /* Ϲ column õ hidden column Ѵ. */
            
            for ( i = 0; i < sTableInfo->indexCount; i++ )
            {
                sIndexInfo = &(sTableInfo->indices[i]);

                /* Function-Based Index  Column ȮѴ. */
                IDE_TEST( qmsDefaultExpr::isRelatedToFunctionBasedIndex(
                              aStatement,
                              sTableInfo,
                              sIndexInfo,
                              sParseColumn->basicInfo->column.id,
                              &sIsRelatedToFunctionBasedIndex )
                          != IDE_SUCCESS );

                if ( sIsRelatedToFunctionBasedIndex != ID_TRUE )
                {
                    continue;
                }
                else
                {
                    /* Nothing to do */
                }

                /* Hidden Column   Ѵ. */
                for ( j = 0; j < sIndexInfo->keyColCount; j++ )
                {
                    sMtcColumn = &(sIndexInfo->keyColumns[j]);

                    IDE_TEST( qcmCache::getColumnByID( sTableInfo,
                                                       sMtcColumn->column.id,
                                                       &sQcmColumn )
                              != IDE_SUCCESS );

                    /* Hidden Column ȮѴ. */
                    if ( (sQcmColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
                         != QCM_COLUMN_HIDDEN_COLUMN_TRUE )
                    {
                        continue;
                    }
                    else
                    {
                        /* Nothing to do */
                    }

                    /* ̹   ߴ ȮѴ. */
                    if ( qdbCommon::findColumnIDInColumnList( sParseTree->columns,
                                                              sMtcColumn->column.id )
                         == ID_TRUE )
                    {
                        continue;
                    }
                    else
                    {
                        /* Nothing to do */
                    }

                    /* ޸𸮸 Ҵϰ ʿ  Ѵ. */
                    IDE_TEST( QC_QMP_MEM(aStatement)->alloc( ID_SIZEOF(qcmColumn),
                                                             (void**)&sHiddenColumn )
                              != IDE_SUCCESS );

                    QCM_COLUMN_INIT( sHiddenColumn );

                    sHiddenColumn->namePos.stmtText = sQcmColumn->name;
                    sHiddenColumn->namePos.offset   = 0;
                    sHiddenColumn->namePos.size     = idlOS::strlen( sQcmColumn->name );

                    QDB_SET_QCM_COLUMN( sHiddenColumn, sQcmColumn );

                    // column name Ѵ.
                    idlOS::strncpy( sHiddenColumn->name,
                                    sQcmColumn->name,
                                    QC_MAX_OBJECT_NAME_LEN + 1 );
                    sHiddenColumn->name[QC_MAX_OBJECT_NAME_LEN] = '\0';

                    /* Hidden Column Column List ޾Ƶд. */
                    sHiddenColumn->next = sParseColumn->next;
                    sParseColumn->next  = sHiddenColumn;
                }
            }
        }
    }

    sParseColumn = sParseTree->columns;

    while ( sParseColumn != NULL )
    {
        // PROJ-1442 Replication Online  DDL 
        if(sTableInfo->replicationCount > 0)
        {
            // Replication  Table Primary Key   
            sPKIndex = sTableInfo->primaryKey;

            for(i = 0; i < sPKIndex->keyColCount; i++)
            {
                IDE_TEST_RAISE((sParseColumn->basicInfo->column.id & SMI_COLUMN_ID_MASK) ==
                               (sPKIndex->keyColumns[i].column.id & SMI_COLUMN_ID_MASK),
                               ERR_PRIMARY_KEY_ON_REPLICATED_TABLE);
            }

            /* PROJ-2397 Dictionary Compressed Column Replication
             *
             */
            IDE_TEST_RAISE( ( sParseColumn->basicInfo->column.flag &
                              SMI_COLUMN_COMPRESSION_MASK ) == SMI_COLUMN_COMPRESSION_TRUE,
                              ERR_DROP_COMP_COL );

        }

        // check referential constraint exists on this column.
        for (i = 0; i < sTableInfo->uniqueKeyCount; i++)
        {
            sIndexInfo = sTableInfo->uniqueKeys[i].constraintIndex;

            if (qdn::intersectColumn((UInt*) smiGetIndexColumns(sIndexInfo->indexHandle),
                                     sIndexInfo->keyColCount,
                                     &(sParseColumn->basicInfo->column.id), 1) == ID_TRUE)
            {
                IDE_TEST(qcm::getChildKeys(aStatement,
                                           sIndexInfo,
                                           sTableInfo,
                                           &sChildInfo) != IDE_SUCCESS);

                IDE_TEST_RAISE(sChildInfo != NULL,
                               ERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST);
            }
        }

        sParseColumn = sParseColumn->next;
        sColumnCount++;
    }

    // if table has no column after current column is dropped,
    //  then ERR_HAVE_NO_COLUMN
    IDE_TEST_RAISE(sTableInfo->columnCount == sColumnCount,
                   ERR_HAVE_NO_COLUMN);

    // BUG-22255
    // multi-column constraint  Ұ
    for (i = 0; i < sTableInfo->uniqueKeyCount; i++)
    {
        sIndexInfo        = sTableInfo->uniqueKeys[i].constraintIndex;
        sIndexColList     = (UInt*) smiGetIndexColumns(sIndexInfo->indexHandle);
        sParseColumn      = sParseTree->columns;
        sConstColumnCount = 0;

        while ( sParseColumn != NULL )
        {
            if (qdn::intersectColumn( sIndexColList,
                                      sIndexInfo->keyColCount,
                                      &(sParseColumn->basicInfo->column.id), 1) == ID_TRUE)
            {
                sConstColumnCount++;
            }
            else
            {
                // Nothing to do.
            }

            sParseColumn = sParseColumn->next;
        }

        if ( (sConstColumnCount > 0) &&
             (sIndexInfo->keyColCount > sConstColumnCount) )
        {
            IDE_RAISE( ERR_ABORT_DROP_INDEX );
        }
        else
        {
            // Nothing to do.
        }
    }

    /* PROJ-1107 Check Constraint 
     * Multi-column  Check Constraint , Ϻ Column   .
     */
    for ( i = 0; i < sTableInfo->checkCount; i++ )
    {
        sCheck            = &(sTableInfo->checks[i]);
        sConstColumnCount = 0;

        for ( sParseColumn = sParseTree->columns;
              sParseColumn != NULL;
              sParseColumn = sParseColumn->next )
        {
            if ( qdn::intersectColumn( sCheck->constraintColumn,
                                       sCheck->constraintColumnCount,
                                       &(sParseColumn->basicInfo->column.id),
                                       1 )
                 == ID_TRUE )
            {
                sConstColumnCount++;
            }
            else
            {
                /* Nothing to do */
            }
        }

        IDE_TEST_RAISE( (sConstColumnCount > 0) &&
                        (sConstColumnCount < sCheck->constraintColumnCount),
                        ERR_ABORT_DROP_CHECK_CONSTRAINT );
    }

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sParseColumn = sParseTree->columns;

        while ( sParseColumn != NULL )
        {
            // cannot drop columns related to partitioned key
            if( qcmCache::getPartKeyColumn( aStatement,
                                            sTableInfo,
                                            sParseColumn->namePos,
                                            &sColumn ) == IDE_SUCCESS )
            {
                IDE_RAISE( ERR_ABORT_DROP_PART_KEY );
            }

            sParseColumn = sParseColumn->next;
        }

        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sTableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );
        
        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &(sParseTree->oldIndexTables) )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    if ( ( sTableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_CANNOT_DDL_WITH_RECOVERY)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DDL_WITH_RECOVERY));
    }
    IDE_EXCEPTION(ERR_PRIMARY_KEY_ON_REPLICATED_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDD_DROP_COL_PRIMARY_KEY_WITH_REPLICATED_TBL));
    }
    IDE_EXCEPTION(ERR_ABORT_DROP_PART_KEY);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_DROP_PART_KEY));
    }
    IDE_EXCEPTION(ERR_HAVE_NO_COLUMN);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_COLUMN_COUNT));
    }
    IDE_EXCEPTION(ERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST));
    }
    IDE_EXCEPTION(ERR_ABORT_DROP_INDEX)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_DROP_MULTI_COLUMN_CONSTRAINT_EXIST));
    }
    IDE_EXCEPTION( ERR_ABORT_DROP_CHECK_CONSTRAINT )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DROP_MULTI_COLUMN_CONSTRAINT_EXIST ) );
    }
    IDE_EXCEPTION( ERR_DROP_COMP_COL )
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_DROP_COMPRESSED_COLUMN_WITH_REPLICATE_TABLE));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateRenameCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... RENAME COLUMN ...  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *    5. Ǳ  ÷ ̸ ϴ üũ
 *    6.  ÷ ̸ ̹ ϴ üũ
 *    7. check constraint ó ,  constraint Parse Tree ߰
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateRenameCol"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    qcmColumn           * sOldColumn;
    qcmColumn           * sNewColumn;
    qcuSqlSourceInfo      sqlInfo;

    // initialize
    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    // check old column existence
    IDE_TEST(qcmCache::getColumn(aStatement,
                                 sParseTree->tableInfo,
                                 sParseTree->columns->namePos,
                                 &sOldColumn) != IDE_SUCCESS);
    QDB_SET_QCM_COLUMN(sParseTree->columns, sOldColumn);

    /* PROJ-1090 Function-based Index */
    if ( (sOldColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
         == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    }
    else
    {
        /* Nothing to do */
    }
    
    // old column name Ѵ.
    idlOS::strncpy( sParseTree->columns->name,
                    sOldColumn->name,
                    QC_MAX_OBJECT_NAME_LEN + 1 );
    sParseTree->columns->name[QC_MAX_OBJECT_NAME_LEN] = '\0';

    // PROJ-2002 Column Security
    // ȣ ÷ rename Ұ
    IDE_TEST_RAISE( (sParseTree->columns->basicInfo->module->flag
                     & MTD_ENCRYPT_TYPE_MASK)
                    == MTD_ENCRYPT_TYPE_TRUE,
                    ERR_EXIST_ENCRYPTED_COLUMN );

    // check new column name
    if (qcmCache::getColumn( aStatement,
                             sParseTree->tableInfo,
                             sParseTree->columns->next->namePos,
                             &sNewColumn)
        == IDE_SUCCESS)
    {
        sqlInfo.setSourceInfo(
            aStatement,
            & sNewColumn->namePos );
        IDE_RAISE(ERR_DUP_COLUMN_NAME);
    }

    /* PROJ-1107 Check Constraint  */
    IDE_TEST( qdnCheck::addCheckConstrSpecRelatedToColumn(
                            aStatement,
                            &(sParseTree->constraints),
                            sParseTree->tableInfo->checks,
                            sParseTree->tableInfo->checkCount,
                            sOldColumn->basicInfo->column.id )
              != IDE_SUCCESS );

    /* PROJ-1090 Function-based Index */
    IDE_TEST( qmsDefaultExpr::addDefaultExpressionColumnsRelatedToColumn(
                  aStatement,
                  &(sParseTree->defaultExprColumns),
                  sParseTree->tableInfo,
                  sOldColumn->basicInfo->column.id )
              != IDE_SUCCESS );
    
    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );
       
        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &(sParseTree->oldIndexTables) )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_DUP_COLUMN_NAME);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(
            ideSetErrorCode(qpERR_ABORT_QDB_DUPLICATE_COLUMN,
                            sqlInfo.getErrMessage() ));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_EXIST_ENCRYPTED_COLUMN);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_EXIST_ENCRYPTED_COLUMN));
    }
    IDE_EXCEPTION( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_HIDDEN_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateRenameTable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... RENAME TO ..., RENAME ... TO ...  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *    5.  ̺ ̸ ̹ ϴ üũ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateRenameTable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    qsOID                 sProcID;
    UInt                  sUserID;
    qcmColumn           * sColumn;
    UInt                  i;
    qcuSqlSourceInfo      sqlInfo;

    idBool                sExist      = ID_FALSE;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    // BUG-34388
    if (qdbCommon::containDollarInName(&(sParseTree->newTableName)) == ID_TRUE)
    {
        sqlInfo.setSourceInfo(aStatement, &(sParseTree->newTableName));
        IDE_RAISE(CANT_USE_RESERVED_WORD);
    }

    /* PROJ-2211 Materialized View */
    IDE_TEST_RAISE( sParseTree->tableInfo->tableType == QCM_MVIEW_TABLE,
                    ERR_RENAME_NOT_SUPPORT_MVIEW );

    // PROJ-2002 Column Security
    // ȣ ÷ ִ  rename Ұ
    for ( i = 0; i < sParseTree->tableInfo->columnCount; i++ )
    {
        sColumn = & sParseTree->tableInfo->columns[i];

        IDE_TEST_RAISE( (sColumn->basicInfo->module->flag
                         & MTD_ENCRYPT_TYPE_MASK)
                        == MTD_ENCRYPT_TYPE_TRUE,
                        ERR_EXIST_ENCRYPTED_COLUMN );
    }

    // if specified new object exists, then error
    IDE_TEST( qcm::existObject( aStatement,
                                ID_FALSE,
                                sParseTree->userName,
                                sParseTree->newTableName,
                                QS_OBJECT_MAX,
                                &sUserID,
                                &sProcID,
                                &sExist )
        != IDE_SUCCESS);

    IDE_TEST_RAISE(sExist == ID_TRUE, ERR_EXIST_OBJECT_NAME );

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_EXIST_OBJECT_NAME);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_EXIST_OBJECT_NAME));
    }
    IDE_EXCEPTION(ERR_EXIST_ENCRYPTED_COLUMN);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_EXIST_ENCRYPTED_COLUMN));
    }
    IDE_EXCEPTION( ERR_RENAME_NOT_SUPPORT_MVIEW );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDM_RENAME_NOT_SUPPORT_MVIEW ) );
    }
    IDE_EXCEPTION( CANT_USE_RESERVED_WORD )
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET( ideSetErrorCode(qpERR_ABORT_QDB_RESERVED_WORD_IN_OBJECT_NAME,
                                 sqlInfo.getErrMessage() ));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateSetDefault(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN (.. SET DEFAULT ..)  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. validation of default expression
 *    5. default  Ʈ · ϱ
 *    6. alter ϰ ϴ ÷ ϴ üũ
 *    7. 6   default Ʈ parse tree  ο
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateSetDefault"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    qcmColumn           * sColumn;
    qcuSqlSourceInfo      sqlInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    // validation of default expression
    IDE_TEST(qdbCommon::validateDefaultDefinition(
                 aStatement,
                 sParseTree->columns->defaultValue )
             != IDE_SUCCESS);

    // check existence of column
    IDE_TEST(qcmCache::getColumn(aStatement,
                                 sParseTree->tableInfo,
                                 sParseTree->columns->namePos,
                                 &sColumn)
             != IDE_SUCCESS);
    QDB_SET_QCM_COLUMN(sParseTree->columns, sColumn);

    // check TIMESTAMP column
    if( ( sColumn->basicInfo->flag & MTC_COLUMN_TIMESTAMP_MASK )
        == MTC_COLUMN_TIMESTAMP_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement, & sColumn->namePos );
        IDE_RAISE(ERR_CANNOT_SET_TIMESTAMP_DEFAULT);
    }
    
    /* PROJ-1090 Function-based Index */
    if ( (sColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
         == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    }
    else
    {
        /* Nothing to do */
    }

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          & sParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_CANNOT_SET_TIMESTAMP_DEFAULT);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(
            ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_SET_TIMESTAMP_DEFAULT,
                            sqlInfo.getErrMessage() ));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_HIDDEN_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateDropDefault(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN(... DROP DEFAULT ..)  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. alter ϰ ϴ ÷ ϴ üũ
 *    5. default  Ǿ ִ üũ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateDropDefault"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    qcmColumn           * sColumn;
    qcuSqlSourceInfo      sqlInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    // check existence of column
    IDE_TEST(qcmCache::getColumn(aStatement,
                                 sParseTree->tableInfo,
                                 sParseTree->columns->namePos,
                                 &sColumn) != IDE_SUCCESS);
    QDB_SET_QCM_COLUMN(sParseTree->columns, sColumn);

    // check existence of default
    IDE_TEST_RAISE(sColumn->defaultValueStr == NULL, ERR_NOT_EXIST_DEFAULT);

    /* PROJ-1090 Function-based Index */
    if ( (sColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
         == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    }
    else
    {
        /* Nothing to do */
    }
    
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          & sParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_NOT_EXIST_DEFAULT);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_EXISTS_DEFAULT));
    }
    IDE_EXCEPTION( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_HIDDEN_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateNotNull(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN (.. NOT NULL ..)  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. alter ϰ ϴ ÷ ϴ üũ
 *    5. Compression column ̸ 
 *    6. not null  ̹ Ǿ  
 *    7. Hidden Column̸ 
 *    8. check not null constraint => qdn::validateConstraints
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateNotNull"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    // alter column not null
    qdTableParseTree    * sParseTree;
    qcmColumn           * sColumn;
    qcuSqlSourceInfo      sqlInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    // check existence of column
    IDE_TEST(qcmCache::getColumn(aStatement,
                                 sParseTree->tableInfo,
                                 sParseTree->columns->namePos,
                                 &sColumn) != IDE_SUCCESS);
    QDB_SET_QCM_COLUMN(sParseTree->columns, sColumn);

    // PROJ-2264 Dictionary table
    // Compression column  NULL/NOT NULL  Ұϴ.
    if ( (sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
         == SMI_COLUMN_COMPRESSION_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_MODIFY_COMPRESSION_COLUMN );
    }
    else
    {
        // Nothing to do.
    }

    // check existence of not null.
    IDE_TEST_RAISE((sColumn->basicInfo->flag & MTC_COLUMN_NOTNULL_MASK)
                   == MTC_COLUMN_NOTNULL_TRUE,
                   ERR_EXIST_NOT_NULL);

    /* PROJ-1090 Function-based Index */
    if ( (sColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
         == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    }
    else
    {
        /* Nothing to do */
    }

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );
    }

    // check not null constraint.
    IDE_TEST(qdn::validateConstraints( aStatement,
                                       sParseTree->tableInfo,
                                       sParseTree->tableInfo->tableOwnerID,
                                       sParseTree->tableInfo->TBSID,
                                       sParseTree->tableInfo->TBSType,
                                       sParseTree->constraints,
                                       QDN_ON_ADD_CONSTRAINT,
                                       NULL )
             != IDE_SUCCESS);

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_EXIST_NOT_NULL);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_EXIST_NOT_NULL));
    }
    IDE_EXCEPTION( ERR_CANNOT_ALTER_HIDDEN_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_HIDDEN_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_MODIFY_COMPRESSION_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_COMPRESSION_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateNullable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER (COL NULL)  validation 
 *
 * Implementation :
 *    1. ϴ ̺ üũ
 *    2. ALTER Ϸ ̺ Ÿ ̸̺  ȯ
 *    3. ALTER TABLE  ִ üũ
 *    4. ̺ ȭ ɷ  ȯ
 *    5.  ÷ ϴ üũ
 *    6. Compression column ̸ 
 *    7. not null constraint  ٸ  ȯ
 *    8. ϰ ϴ ÷ primary key ÷̸  ȯ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateNullable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    // alter column null
    qdTableParseTree    * sParseTree;
    qcmColumn           * sColumn;
    qcuSqlSourceInfo      sqlInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    // check existence of column
    IDE_TEST(qcmCache::getColumn(aStatement,
                                 sParseTree->tableInfo,
                                 sParseTree->columns->namePos,
                                 &sColumn) != IDE_SUCCESS);
    QDB_SET_QCM_COLUMN(sParseTree->columns, sColumn);

    // PROJ-2264 Dictionary table
    // Compression column  NULL/NOT NULL  Ұϴ.
    if ( (sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
         == SMI_COLUMN_COMPRESSION_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               &(sParseTree->columns->namePos) );
        IDE_RAISE( ERR_MODIFY_COMPRESSION_COLUMN );
    }
    else
    {
        // Nothing to do.
    }

    // check existence of not null.
    IDE_TEST_RAISE((sColumn->basicInfo->flag & MTC_COLUMN_NOTNULL_MASK)
                   == MTC_COLUMN_NOTNULL_FALSE,
                   ERR_NOT_EXIST_NOT_NULL);

    // search not null constraint.

    // if this column is a primary key column, raise error.
    if (sParseTree->tableInfo->primaryKey != NULL)
    {
        IDE_TEST_RAISE(qdn::intersectColumn(
                           (UInt*) smiGetIndexColumns(sParseTree->tableInfo->primaryKey->indexHandle),
                           sParseTree->tableInfo->primaryKey->keyColCount,
                           &sColumn->basicInfo->column.id, 1) == ID_TRUE, ERR_NOT_ALLOWED_DROP_NOT_NULL);
    }

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_NOT_EXIST_NOT_NULL);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_EXIST_NOT_NULL));
    }
    IDE_EXCEPTION(ERR_NOT_ALLOWED_DROP_NOT_NULL);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_ALLOWED_DROP_NOT_NULL));
    }
    IDE_EXCEPTION( ERR_MODIFY_COMPRESSION_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_COMPRESSION_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateCompactTable( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... COMPACT  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. MEMORY ̺  
 *    4. alter table  ִ üũ
 *
 ***********************************************************************/

    qdTableParseTree     * sParseTree    = NULL;
    UInt                   sTableType    = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    SInt                   sCountMemType = 0;
    SInt                   sCountVolType = 0;
    qdPartitionAttribute * sPartAttr     = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* ̺ Ÿ  select  MEMORY  ̺ ƴ   ߻ */
    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* PROJ-2464 hybrid partitioned table 
     *  - HPT  쿡, Memory, Disk ü    ִ.
     *  -  Disk ü ԵǾ ش ɼ   ִ.
     *  - Partitioned  ó ߰Ѵ.
     *     1. Parser Ҵ  PartTable ⼭ ҴѴ.
     *     2. Partition List ´.
     *     3. Partition  ˻Ѵ.
     *     4. Memory ü  Compact   .
     *
     *  -   : ̺ Ÿ  select  MEMORY  ̺ ƴ   ߻
     *                To fix BUG-21965
     *                VOLATILE  ̺ 쵵 డϰ 
     */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        if ( sParseTree->partTable->partAttr == NULL )
        {
            /* 1. Partition List ´. */
            IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                              sParseTree->tableInfo->tableID,
                                                              &( sParseTree->partTable->partInfoList ) )
                      != IDE_SUCCESS );

        }
        else
        {
            /* BUG-43060 Partition  Compact */
            sPartAttr = sParseTree->partTable->partAttr;
            IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                                     sParseTree->tableInfo,
                                                     sPartAttr->tablePartName )
                       != IDE_SUCCESS );
        }

        sPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    /* 3. Partition  ˻Ѵ. */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                sPartInfoList,
                                                NULL,
                                                & sCountMemType,
                                                & sCountVolType );

    /* 4. Memory ü  Compact   . */
    IDE_TEST_RAISE( ( sCountMemType + sCountVolType ) == 0,
                    ERR_NO_MEMORY_OR_VOLATILE_TABLE );

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_FALSE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_MEMORY_OR_VOLATILE_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NO_MEMORY_OR_VOLATILE_TABLE ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAgingTable( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... DISK  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. DISK ̺  
 *    4. alter table  ִ üũ
 *
 ***********************************************************************/

    qdTableParseTree     * sParseTree     = NULL;
    UInt                   sTableType     = 0;
    qcmPartitionInfoList * sPartInfoList  = NULL;
    SInt                   sCountDiskType = 0;
    qdPartitionAttribute * sPartAttr      = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* ̺ Ÿ  select  DISK  ̺ ƴ   ߻ */
    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        if ( sParseTree->partTable->partAttr == NULL )
        {
            /* Ƽ Ʈ ĽƮ ޾Ƴ´. */
            IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                              sParseTree->tableInfo->tableID,
                                                              &( sParseTree->partTable->partInfoList ) )
                      != IDE_SUCCESS );

            /* PROJ-1624 non-partitioned index */
            IDE_TEST( qdx::makeAndLockIndexTableList( aStatement,
                                                      ID_FALSE,
                                                      sParseTree->tableInfo,
                                                      &( sParseTree->oldIndexTables ) )
                      != IDE_SUCCESS );
        }
        else
        {
            /* BUG-43060 Partition  Aging */
            sPartAttr = sParseTree->partTable->partAttr;
            IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                                     sParseTree->tableInfo,
                                                     sPartAttr->tablePartName )
                       != IDE_SUCCESS );

            /* BUG-43115 AGING PARTITION Deadlock
             *  Partitioned Table IX Lock , Deadlock ȸǸ  Index Table X Lock  ʴ´.
             *  ׷. Index Table AgingϷ, X Lock ƾ Ѵ.
             *  , AGING PARTITION 쿡 Index Table Aging  ʴ´.
             */
        }

        /* PROJ-2464 hybrid partitioned table  */
        sPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    /* PROJ-2464 hybrid partitioned table 
     *  - HPT  쿡, Memory, Disk ü    ִ.
     *  -  Memory ü ԵǾ ش ɼ   ִ.
     *  -  Disk ü  Aging   .
     *
     *  -   : ̺ Ÿ  select  DISK  ̺ ƴ   ߻
     */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                sPartInfoList,
                                                & sCountDiskType,
                                                NULL,
                                                NULL );

    IDE_TEST_RAISE( sCountDiskType == 0, ERR_NO_DISK_TABLE );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_DISK_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NO_DISK_TABLE ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAllIndexEnable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALL INDEX ENABLE/DISABLE  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *    5. ̺ uniquekey  ְ,  Ű ϴ child   
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateAllIndexEnable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    UInt                  i;
    qcmIndex            * sIndexInfo;
    qcmRefChildInfo     * sChildInfo = NULL;  // BUG-28049

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    // check referential constraint exists.
    for (i = 0; i < sParseTree->tableInfo->uniqueKeyCount; i++)
    {
        sIndexInfo = sParseTree->tableInfo->uniqueKeys[i].constraintIndex;

        IDE_TEST(qcm::getChildKeys(aStatement,
                                   sIndexInfo,
                                   sParseTree->tableInfo,
                                   &sChildInfo) != IDE_SUCCESS);

        IDE_TEST_RAISE(sChildInfo != NULL,
                       ERR_ABORT_REFERENTIAL_CONSTRAINT_EXIST);
    }

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          & sParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ABORT_REFERENTIAL_CONSTRAINT_EXIST);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateAlterMaxRows(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... MAXROWS n ...  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateAlterMaxRows"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::validateAlterMaxRows"));

    qdTableParseTree    * sParseTree;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    IDE_TEST_RAISE( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE,
                    ERR_ALTER_MODIFY_MAXROWS_OF_PARTITION );

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_MODIFY_MAXROWS_OF_PARTITION)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_MODIFY_MAXROWS_OF_PARTITION));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateAlterTableOptions(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... LOGGING/NOLOGGING PARALLEL/NOPARALLEL  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateAlterTableOptions"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::validateAlterTableOptions"));

    qdTableParseTree * sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          & sParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateAlterTableSegAttr( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... PCTFREE .. PCTUSED ..
 *                    INITRANS .. MAXTRANS ..;
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *
 ***********************************************************************/

    qdTableParseTree * sParseTree = NULL;
    UInt               sTableType = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement, ID_TRUE )
              != IDE_SUCCESS );

    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    IDE_TEST_RAISE( smiIsDiskTable( sParseTree->tableInfo->tableHandle ) != ID_TRUE,
                    ERR_NO_DISK_TABLE );

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( qdbCommon::validateAndSetSegAttr( sTableType,
                                                &( sParseTree->tableInfo->segAttr ),
                                                &( sParseTree->segAttr ),
                                                ID_TRUE )
              != IDE_SUCCESS );

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* Ƽ Ʈ ĽƮ ޾Ƴ´. */
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      &( sParseTree->partTable->partInfoList ) )
                  != IDE_SUCCESS );

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &( sParseTree->oldIndexTables)  )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_DISK_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NO_DISK_TABLE ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAlterTableSegStoAttr( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... STORAGE( INITEXTENTS ..
 *    NEXTEXTENTS .. MINEXTENTS .. MAXEXTENTS .. );
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *
 ***********************************************************************/

    qdTableParseTree * sParseTree = NULL;
    UInt               sTableType = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement, ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* BUG-29382 memory table  ؼ storage_clause   ȵ. */
    IDE_TEST_RAISE( smiIsDiskTable( sParseTree->tableInfo->tableHandle ) != ID_TRUE,
                    ERR_NO_DISK_TABLE );

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( qdbCommon::validateAndSetSegStoAttr( sTableType,
                                                   &( sParseTree->tableInfo->segStoAttr ),
                                                   &( sParseTree->segStoAttr ),
                                                   &( sParseTree->existSegStoAttr ),
                                                   ID_TRUE )
              != IDE_SUCCESS );

    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* Ƽ Ʈ ĽƮ ޾Ƴ´. */
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      &( sParseTree->partTable->partInfoList ) )
                  != IDE_SUCCESS );

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &( sParseTree->oldIndexTables ) )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_DISK_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NO_DISK_TABLE ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAlterTableAllocExtent( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALLOCATE EXTENT ( SIZE .. );
 *    ALTER TABLE ... ALLOCATE EXTENT;
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *    5. ̺ ũ  ̺ ƴϸ 
 *
 ***********************************************************************/

    qdTableParseTree * sParseTree = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement, ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    /* BUG-29382 disk table  ALLOCATE EXTENT    ִ. */
    IDE_TEST_RAISE( smiIsDiskTable( sParseTree->tableInfo->tableHandle ) != ID_TRUE,
                    ERR_NO_DISK_TABLE );

    if( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* Ƽ Ʈ ĽƮ ޾Ƴ´. */
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      &( sParseTree->partTable->partInfoList ) )
                  != IDE_SUCCESS );

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &( sParseTree->oldIndexTables ) )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do. */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_DISK_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NO_DISK_TABLE ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAlterLobAttributes(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1362
 *    ALTER TABLE ... ALTER COLUMN LOB ( lob column )
 *      STORE AS ( LOGGING/NOLOGGING/BUFFER/NOBUFFER )  validation 
 *
 * Implementation :
 *    1. ̺   üũ
 *    2. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    3. alter table  ִ üũ
 *    4. ̺ ȭ ɷ 
 *    5. alter ϰ ϴ ÷ ϴ üũ
 *    6. Lob÷ ƴϸ 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateAlterLobAttributes"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    // alter column logging
    qdTableParseTree    * sParseTree;
    qcmColumn           * sColumn;
    qcmColumn           * sLastColumn;
    UInt                  sLobColumnCount = 0;
    qcuSqlSourceInfo      sqlInfo;
    qdPartitionAttribute* sPartAttr;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    // check existence of column
    if (sParseTree->lobAttr->columns == NULL)
    {
        for (sLastColumn = sParseTree->tableInfo->columns;
             sLastColumn != NULL;
             sLastColumn = sLastColumn->next)
        {
            if ((sLastColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                == SMI_COLUMN_TYPE_LOB)
            {
                sLobColumnCount++;
            }
            else
            {
                // Nothing to do.
            }
        }

        IDE_TEST_RAISE( sLobColumnCount == 0,
                        ERR_NOT_FOUND_LOB_TYPE_COLUMN );
    }
    else
    {
        for (sLastColumn = sParseTree->lobAttr->columns;
             sLastColumn != NULL;
             sLastColumn = sLastColumn->next)
        {
            IDE_TEST(qcmCache::getColumn(aStatement,
                                         sParseTree->tableInfo,
                                         sLastColumn->namePos,
                                         &sColumn) != IDE_SUCCESS);
            QDB_SET_QCM_COLUMN(sLastColumn, sColumn);

            // check lob column
            if ((sLastColumn->basicInfo->module->flag & MTD_COLUMN_TYPE_MASK)
                != MTD_COLUMN_TYPE_LOB)
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sLastColumn->namePos);
                IDE_RAISE(ERR_MISMATCHED_LOB_TYPE_COLUMN);
            }
            else
            {
                // Nothing to do.
            }
        }
    }

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->tableInfo->tablePartitionType
        == QCM_NONE_PARTITIONED_TABLE )
    {
        IDE_TEST_RAISE( sParseTree->partTable->partAttr != NULL,
                        ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );
    }
    else
    {
        // nothing to do
    }

    //  ƼǺ  LOB ATTR  validation
    for( sPartAttr = sParseTree->partTable->partAttr;
         sPartAttr != NULL;
         sPartAttr = sPartAttr->next )
    {
        // Ƽ ̸ validation
        IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                                 sParseTree->tableInfo,
                                                 sPartAttr->tablePartName )
                  != IDE_SUCCESS );

        // check existence of column
        if (sPartAttr->lobAttr->columns == NULL)
        {
            sLobColumnCount = 0;

            for (sLastColumn = sParseTree->tableInfo->columns;
                 sLastColumn != NULL;
                 sLastColumn = sLastColumn->next)
            {
                if ((sLastColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                    == SMI_COLUMN_TYPE_LOB)
                {
                    sLobColumnCount++;
                }
                else
                {
                    // Nothing to do.
                }
            }

            IDE_TEST_RAISE( sLobColumnCount == 0,
                            ERR_NOT_FOUND_LOB_TYPE_COLUMN );
        }
        else
        {
            for (sLastColumn = sPartAttr->lobAttr->columns;
                 sLastColumn != NULL;
                 sLastColumn = sLastColumn->next)
            {
                IDE_TEST(qcmCache::getColumn(aStatement,
                                             sParseTree->tableInfo,
                                             sLastColumn->namePos,
                                             &sColumn) != IDE_SUCCESS);
                QDB_SET_QCM_COLUMN(sLastColumn, sColumn);

                // check lob column
                if ((sLastColumn->basicInfo->module->flag & MTD_COLUMN_TYPE_MASK)
                    != MTD_COLUMN_TYPE_LOB)
                {
                    sqlInfo.setSourceInfo(aStatement,
                                          & sLastColumn->namePos);
                    IDE_RAISE(ERR_MISMATCHED_LOB_TYPE_COLUMN);
                }
                else
                {
                    // Nothing to do.
                }
            }
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_NOT_FOUND_LOB_TYPE_COLUMN)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_FOUND_LOB_TYPE_COLUMN));
    }
    IDE_EXCEPTION(ERR_MISMATCHED_LOB_TYPE_COLUMN);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_MISMATCHED_LOB_TYPE_COLUMN,
                                sqlInfo.getErrMessage()));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::validateSplitPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *    ALTER TABLE tbl_name SPLIT PARTITION src_part
 *        { AT | VALUES } ( split_cond_value, ... )
 *            INTO ( PARTITION dst_part1, PARTITION dst_part2 )
 *     validation
 *
 *
 * Implementation :
 *      1. ALTER TABLE   validation
 *
 *      2. Ƽǵ ̺ üũ
 *
 *      3. SrcPart Ƽ ̸ validation
 *
 *      4. DstPart1 DstPart2 ̺̽ validation
 *
 *      5.  Ƽǵ ̺ ,   üũ
 *          5-1. SPLIT PARTITION ... AT  üũ
 *          5-2. Ƽ     üũ
 *               ( Ƽ Ű  ۰ų ƾ Ѵ.)
 *          5-3. Ƽ   src_part ϴ üũ
 *
 *      6. ؽ Ƽǵ ̺  
 *
 *      7. Ʈ Ƽǵ ̺  
 *          7-1. SPLIT PARTITION ... VALUES  üũ
 *          7-2. Ƽ   src_part ϴ üũ
 *
 *      8. ACCESS  ̺ Ÿ ˻
 *
 *      9. DstPart1, DstPart2 Ƽ ̸ validation
 *
 *     10. In-place Split Out-place Split Ǵ
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sSrcPartAttr;
    qdPartitionAttribute    * sDstPartAttr;
    qdPartitionAttribute    * sDstPartAttr2;
    qmmValueNode            * sNode;
    UInt                      sSplitCount;
    qcmTableInfo            * sPartitionInfo;
    smSCN                     sPartitionSCN;
    void                    * sPartitionHandle;
    qcuSqlSourceInfo          sqlInfo;
    qcmColumn               * sTargetColumn;
    qcmColumn               * sTableColumn;
    idBool                    sIsDefaultTBS;
    UInt                      i;
    SChar                     sDstPartName[QC_MAX_OBJECT_NAME_LEN + 1];

    qdIndexPartitionAttribute * sIndexPartAttr = NULL;
    qdIndexPartitionAttribute * sTempAttr = NULL;
    qdIndexPartitionAttribute * sTempAttr2 = NULL;
    qdIndexPartitionAttribute * sFirstAttr = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE_SPLIT_PARTITION,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    sSrcPartAttr = sParseTree->partTable->partAttr;

    // ------------------------------------------------------
    // 3. SrcPart Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sSrcPartAttr->tablePartName )
              != IDE_SUCCESS );

    sPartitionInfo = sParseTree->partTable->partInfoList->partitionInfo;

    if ( sPartitionInfo->replicationCount > 0 )
    {
        IDE_TEST( qci::mValidateReplicationCallback.mValidateAlterPartition( aStatement,
                                                                             sPartitionInfo )
                  != IDE_SUCCESS );

    }
    else
    {
        // Nothing to do
    }

    if ( ( sPartitionInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            1,
                            &(sPartitionInfo->tableOID) );
    }
    // ------------------------------------------------------
    // 3.5 non-partitioned index Ʈ ´.
    // ------------------------------------------------------
    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList( aStatement,
                                              ID_FALSE,
                                              sParseTree->tableInfo,
                                              &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    // ------------------------------------------------------
    // SrcPart min_value, max_value
    // qmsPartCondValList, qmmValueNode  ĽƮ ޾Ƴ´.
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::makePartCondValList( aStatement,
                                              sTableInfo,
                                              sPartitionInfo->partitionID,
                                              sSrcPartAttr )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // 4. DstPart1 DstPart2 ̺̽ validation
    // ------------------------------------------------------
    for( sDstPartAttr = sSrcPartAttr->next;
         sDstPartAttr != NULL;
         sDstPartAttr = sDstPartAttr->next )
    {
        // validation of  Ƽ TABLESPACE
        IDE_TEST( qdbCommon::validateTBSOfPartition( aStatement, sDstPartAttr )
                  != IDE_SUCCESS );

        /* PROJ-2639 Altibase Disk Edition */
#ifdef ALTI_CFG_EDITION_DISK
        if ( sTableInfo->tableOwnerID == QC_SYSTEM_USER_ID )
        {
            /* Nothing to do */
        }
        else
        {
            IDE_TEST_RAISE( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_FALSE,
                            ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
        }
#endif

        /* PROJ-2464 hybrid partitioned table  */
        IDE_TEST( validateTablespaceRestriction( sTableInfo, sDstPartAttr->TBSAttr.mType )
                  != IDE_SUCCESS );

        // IN-PLACE TABLESPACE õ    Ƽ
        // TBS .
        // OUT-PLACE  Ƽǵ ̺ TBS ,  ڰ 
        //  TBS ִٸ ش TBS .
        if( ( QC_IS_NAME_MATCHED( sDstPartAttr->tablePartName, sSrcPartAttr->tablePartName ) == ID_FALSE ) ||
            ( QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_FALSE ) ||
            ( sDstPartAttr->lobAttr != NULL ) )
        {
            sDstPartAttr->columns  = NULL;

            /* PROJ-2464 hybrid partitioned table  */
            IDE_TEST( qdbCommon::copyAndAdjustColumnList( aStatement,
                                                          sTableInfo->TBSType,
                                                          sDstPartAttr->TBSAttr.mType,
                                                          sTableInfo->columns,
                                                          &(sDstPartAttr->columns),
                                                          sTableInfo->columnCount,
                                                          ID_FALSE /* aEnableVariableColumn */ )
                      != IDE_SUCCESS );

            for( i = 0, sTableColumn = sTableInfo->columns, sTargetColumn = sDstPartAttr->columns;
                 sTableColumn != NULL ;
                 i++, sTableColumn = sTableColumn->next, sTargetColumn = sTargetColumn->next )
            {

                if ( (sTableColumn->basicInfo->module->flag &
                      MTD_COLUMN_TYPE_MASK)
                     == MTD_COLUMN_TYPE_LOB )
                {
                    /* Ƽǵ ̺ LOB COLUMN TBS   */
                    IDE_TEST( qcm::getIsDefaultTBS(
                                  aStatement,
                                  sTableInfo->tableID,
                                  (sTableInfo->tableID * SMI_COLUMN_ID_MAXIMUM) + i,
                                  & sIsDefaultTBS )
                              != IDE_SUCCESS );

                    /* PROJ-2464 hybrid partitioned table 
                     *  - Disk Partition , Partitioned Lob Column TBS(Default TBS)
                     *    Ǿ  Default TBS Ѵ.
                     *  - PROJ-2334 PMT MEMORY PARTITIONED TABLE : Memory Partition ,
                     *    Partition TBS Ѵ.
                     */
                    /* PROJ-2465 Tablespace Alteration for Table
                     *  -  Default TBS ó ߰Ѵ.
                     */
                    if ( ( sIsDefaultTBS == ID_TRUE ) &&
                         ( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_TRUE ) &&
                         ( smiTableSpace::isDiskTableSpaceType( sTableInfo->TBSType ) == ID_TRUE ) )
                    {
                        /* Create ColSpace  Default TBS ״ ̿Ѵ. */
                        /* Nothing to do */
                    }
                    else
                    {
                        sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
                    }
                }
                else
                {
                    sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
                }
            } // for
        } // if
        else
        {
            // IN-PLACE SPLIT
            sDstPartAttr->columns  = NULL;
            IDE_TEST( qcm::copyQcmColumns( QC_QMP_MEM(aStatement),
                                           sPartitionInfo->columns,
                                           &(sDstPartAttr->columns ),
                                           sPartitionInfo->columnCount )
                      != IDE_SUCCESS );
        }

        IDE_TEST(qdbCommon::validateLobAttributeList( aStatement,
                                                      sTableInfo,
                                                      sDstPartAttr->columns,
                                                      &(sDstPartAttr->TBSAttr),
                                                      sDstPartAttr->lobAttr )
                 != IDE_SUCCESS);
    }

    sSrcPartAttr = sParseTree->partTable->partAttr;

    // PROJ-1579 NCHAR
    //  Ƽ nchar literal list  ´.
    IDE_TEST( qdbCommon::makeNcharLiteralStr( aStatement,
                                              sParseTree->ncharList,
                                              sSrcPartAttr )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // 5.  Ƽǵ ̺ ,    üũ
    // ------------------------------------------------------
    if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
         ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
    {
        sSplitCount = 0;

        for( sNode = sSrcPartAttr->partKeyCond;
             sNode != NULL;
             sNode = sNode->next )
        {
            sSplitCount++;
        }

        // ------------------------------------------------------
        // 5-1.  Ƽǵ ̺
        //      SPLIT PARTITION ... AT ̾ Ѵ.
        // ------------------------------------------------------
        IDE_TEST_RAISE( sSrcPartAttr->alterPart->alterType !=
                        QD_SPLIT_RANGE_PARTITION,
                        ERR_SPLIT_AT_ON_RANGE_PART_TABLE );

        // ------------------------------------------------------
        // 5-2. Ƽ     üũ
        //      ( Ƽ Ű  ۰ų ƾ Ѵ.)
        // ------------------------------------------------------
        IDE_TEST_RAISE( sTableInfo->partKeyColCount < sSplitCount,
                        ERR_TOO_MANY_SPLIT_COND_VALUE_COUNT );

        // ------------------------------------------------------
        // 5-3. Ƽ   src_part ϴ üũ
        // ------------------------------------------------------
        IDE_TEST( qdbCommon::checkSplitCond( aStatement,
                                             sParseTree )
                  != IDE_SUCCESS );
    }
    // ------------------------------------------------------
    // 6. ؽ Ƽǵ ̺ , 
    // ------------------------------------------------------
    else if( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_HASH )
    {
        IDE_RAISE( ERR_SPLIT_PARTITION_ON_HASH_PART_TABLE );
    }
    // ------------------------------------------------------
    // 7. Ʈ Ƽǵ ̺ ,    üũ
    // ------------------------------------------------------
    else if( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_LIST )
    {
        // ------------------------------------------------------
        // 7-1. Ʈ Ƽǵ ̺
        //      SPLIT PARTITION ... VALUES ̾ Ѵ.
        // ------------------------------------------------------
        IDE_TEST_RAISE( sSrcPartAttr->alterPart->alterType != QD_SPLIT_LIST_PARTITION,
                        ERR_SPLIT_VALUES_ON_LIST_PART_TABLE );

        // ------------------------------------------------------
        // 7-2. Ƽ   src_part ϴ üũ
        // ------------------------------------------------------
        IDE_TEST( qdbCommon::checkSplitCond( aStatement,
                                             sParseTree )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do
    }

    // SrcPart, DstPart ٽ 
    sSrcPartAttr = sParseTree->partTable->partAttr;
    sDstPartAttr = sParseTree->partTable->partAttr->next;
    sDstPartAttr2 = sParseTree->partTable->partAttr->next->next;

    /* PROJ-2464 hybrid partitioned table  */
    // qdbCommon::getTableTypeCountInPartAttrList() ϱ , Src, Dst Partition List  иѴ.
    sSrcPartAttr->next = NULL;
    IDE_TEST( validateTableReferenceForPartitions( aStatement,
                                                   sTableInfo,
                                                   sSrcPartAttr,
                                                   sDstPartAttr )
              != IDE_SUCCESS );
    sSrcPartAttr->next = sDstPartAttr;

    // ------------------------------------------------------
    // 8. ACCESS  ̺ Ÿ ˻
    // ------------------------------------------------------
    /* PROJ-2359 Table/Partition Access Option */
    IDE_TEST_RAISE( ( sTableInfo->tableType == QCM_MVIEW_TABLE ) &&
                    ( ( sDstPartAttr->accessOption != QCM_ACCESS_OPTION_NONE ) ||
                      ( sDstPartAttr2->accessOption != QCM_ACCESS_OPTION_NONE ) ),
                    ERR_ACCESS_NOT_SUPPORT_MVIEW );

    // ------------------------------------------------------
    // 9. DstPart1 DstPart2 ̸ validation
    // ------------------------------------------------------
    if ( QC_IS_NAME_MATCHED( sDstPartAttr->tablePartName, sDstPartAttr2->tablePartName ) )
    {
        sqlInfo.setSourceInfo(aStatement,
                              & sDstPartAttr2->tablePartName );
        IDE_RAISE( ERR_DUPLICATE_PARTITION_NAME );
    }

    // ------------------------------------------------------
    // 10. In-place Split Out-place Split 
    // ------------------------------------------------------
    if ( QC_IS_NAME_MATCHED( sSrcPartAttr->tablePartName, sDstPartAttr->tablePartName ) )
    {
        if( (QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_TRUE) &&
            (sDstPartAttr->lobAttr == NULL) &&
            (sDstPartAttr->alterPart->indexPartAttr == NULL) )
        {
            sSrcPartAttr->alterPart->splitMergeType =
                QD_ALTER_PARTITION_LEFT_INPLACE_TYPE;
        }
        else
        {
            sSrcPartAttr->alterPart->splitMergeType =
                QD_ALTER_PARTITION_OUTPLACE_TYPE;
        }
    }
    else if ( QC_IS_NAME_MATCHED( sSrcPartAttr->tablePartName, sDstPartAttr2->tablePartName ) )
    {
        if( (QC_IS_NULL_NAME( sDstPartAttr2->TBSName ) == ID_TRUE) &&
            (sDstPartAttr2->lobAttr == NULL) &&
            (sDstPartAttr2->alterPart->indexPartAttr == NULL) )
        {
            sSrcPartAttr->alterPart->splitMergeType =
                QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE;
        }
        else
        {
            sSrcPartAttr->alterPart->splitMergeType =
                QD_ALTER_PARTITION_OUTPLACE_TYPE;
        }
    }
    else
    {
        sSrcPartAttr->alterPart->splitMergeType =
            QD_ALTER_PARTITION_OUTPLACE_TYPE;
    }

    /* PROJ-2757 Advanced Global DDL */
    if ( ( QCG_GET_SESSION_GLOBAL_DDL( aStatement ) == ID_TRUE ) &&
         ( QCM_TABLE_IS_SHARD_SPLIT( sTableInfo->mShardFlag ) == ID_TRUE ) )
    {
        // shard table  GLOBAL_DDL right in-place 
        IDE_TEST_RAISE( sSrcPartAttr->alterPart->splitMergeType !=
                        QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE,
                        ERR_GLOBAL_DDL );

        // list Ƽ ׸ Ѱ   
        if( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_LIST )
        {
            IDE_TEST_RAISE( sSrcPartAttr->partKeyCond->next != NULL,
                            ERR_PART_COND_COUNT );
        }
        else
        {
            /* Nothing to do */
        }

        if  ( QCG_GET_SESSION_IS_SHARD_USER_SESSION( aStatement ) == ID_TRUE )
        {
            // hash,range,list л 쿡  Ÿ ؾ ϹǷ executor 
            sParseTree->common.execute = sdiGlobalDDL::executeSplitPartition;
        }
        else
        {
            /* Nothing to do */
        }
    }
    else
    {
        /* Nothing to do */
    }

    // Left In-place  
    // DstPart2 ̸  ̸ Ƽ ִ üũ
    if( sSrcPartAttr->alterPart->splitMergeType ==
        QD_ALTER_PARTITION_LEFT_INPLACE_TYPE )
    {
        if( qcmPartition::getPartitionInfo( aStatement,
                                            sTableInfo->tableID,
                                            sDstPartAttr2->tablePartName,
                                            & sPartitionInfo,
                                            & sPartitionSCN,
                                            & sPartitionHandle )
            == IDE_SUCCESS )
        {
            sqlInfo.setSourceInfo(aStatement,
                                  & sDstPartAttr2->tablePartName );
            IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
        }
    }
    // Right In-place  
    // DstPart1 ̸  ̸ Ƽ ִ üũ
    else if( sSrcPartAttr->alterPart->splitMergeType ==
             QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE )
    {
        if( qcmPartition::getPartitionInfo( aStatement,
                                            sTableInfo->tableID,
                                            sDstPartAttr->tablePartName,
                                            & sPartitionInfo,
                                            & sPartitionSCN,
                                            & sPartitionHandle )
            == IDE_SUCCESS )
        {
            sqlInfo.setSourceInfo(aStatement,
                                  & sDstPartAttr->tablePartName );
            IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
        }
    }
    // Out-place  
    // DstPart1 Ǵ DstPart2 ̸  ̸ Ƽ ִ üũ
    else if( sSrcPartAttr->alterPart->splitMergeType ==
             QD_ALTER_PARTITION_OUTPLACE_TYPE )
    {
        if ( QC_IS_NAME_MATCHED( sSrcPartAttr->tablePartName, sDstPartAttr->tablePartName ) == ID_FALSE )
        {
            if( qcmPartition::getPartitionInfo( aStatement,
                                                sTableInfo->tableID,
                                                sDstPartAttr->tablePartName,
                                                & sPartitionInfo,
                                                & sPartitionSCN,
                                                & sPartitionHandle )
                == IDE_SUCCESS )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sDstPartAttr->tablePartName );
                IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
            }
        }
        else
        {
            // SrcPart DstPart1 ̸   üũ ʴ´.
            // Nothing to do
        }

        if ( QC_IS_NAME_MATCHED( sSrcPartAttr->tablePartName, sDstPartAttr2->tablePartName ) == ID_FALSE )
        {
            if( qcmPartition::getPartitionInfo( aStatement,
                                                sTableInfo->tableID,
                                                sDstPartAttr2->tablePartName,
                                                & sPartitionInfo,
                                                & sPartitionSCN,
                                                & sPartitionHandle )
                == IDE_SUCCESS )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sDstPartAttr2->tablePartName );
                IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
            }
        }
        else
        {
            // SrcPart DstPart2 ̸   üũ ʴ´.
            // Nothing to do
        }
    }
    else
    {
        // Nothing to do
    }


    // ------------------------------------------------------
    // ε Ƽ   validation
    // ------------------------------------------------------

    // DstPartAttr, DstPartAttr2 IndexAttr  üũϱ 
    // ϳ Ʈ 
    for( sDstPartAttr = sParseTree->partTable->partAttr->next;
         sDstPartAttr != NULL;
         sDstPartAttr = sDstPartAttr->next )
    {
        if ( sDstPartAttr->alterPart->indexPartAttr != NULL )
        {
            for ( sIndexPartAttr = sDstPartAttr->alterPart->indexPartAttr;
                  sIndexPartAttr != NULL;
                  sIndexPartAttr = sIndexPartAttr->next )
            {
                IDU_LIMITPOINT("qdbAlter::validateSplitPartition::malloc");
                IDE_TEST(STRUCT_ALLOC(QC_QMP_MEM(aStatement),
                                      qdIndexPartitionAttribute,
                                      & sTempAttr2)
                         != IDE_SUCCESS);

                idlOS::memcpy( sTempAttr2,
                               sIndexPartAttr,
                               ID_SIZEOF(qdIndexPartitionAttribute) );

                if (sFirstAttr == NULL)
                {
                    sTempAttr2->next = NULL;
                    sFirstAttr = sTempAttr2;
                }
                else
                {
                    sTempAttr2->next = sFirstAttr;
                    sFirstAttr = sTempAttr2;
                }
            }
        }
        else
        {
            /* Nothing to do */
        }
    }

    // Ƽǵ ε, ε Ƽ ̸     
    for( sTempAttr2 = sFirstAttr;
         sTempAttr2 != NULL;
         sTempAttr2 = sTempAttr2->next )
    {
        for( sTempAttr = sFirstAttr;
             sTempAttr != sTempAttr2;
             sTempAttr = sTempAttr->next )
        {
            if ( QC_IS_NAME_MATCHED( sTempAttr2->partIndexName, sTempAttr->partIndexName ) &&
                 QC_IS_NAME_MATCHED( sTempAttr2->indexPartName, sTempAttr->indexPartName ) )
            {
                sqlInfo.setSourceInfo( aStatement, &sTempAttr2->indexPartName );
                IDE_RAISE( ERR_DUPLICATE_PARTITION_NAME );
            }
            else
            {
                // Nothing to do.
            }
        }
    }

    // DstPart1, DstPart2 ʴ validation
    for( sDstPartAttr = sParseTree->partTable->partAttr->next;
         sDstPartAttr != NULL;
         sDstPartAttr = sDstPartAttr->next )
    {
        /* PROJ-2464 hybrid partitioned table  */
        IDE_TEST( validateIndexAlterationForPartition( aStatement,
                                                       sTableInfo,
                                                       sPartitionInfo,
                                                       sDstPartAttr )
                  != IDE_SUCCESS );

        if ( sDstPartAttr->alterPart->indexPartAttr != NULL )
        {
            IDE_TEST( checkIndexPartAttrList( aStatement,
                                              sTableInfo,
                                              sPartitionInfo,
                                              sSrcPartAttr,
                                              sDstPartAttr,
                                              sParseTree->userID )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_SPLIT_AT_ON_RANGE_PART_TABLE );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_PART_TABLE_METHOD_FOR_SPLIT_PARTITION_AT));
    }
    IDE_EXCEPTION(ERR_SPLIT_VALUES_ON_LIST_PART_TABLE );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_PART_TABLE_METHOD_FOR_SPLIT_PARTITION_VALUES));
    }
    IDE_EXCEPTION(ERR_TOO_MANY_SPLIT_COND_VALUE_COUNT);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_TOO_MANY_SPLIT_CONDITION_VALUE));
    }
    IDE_EXCEPTION(ERR_SPLIT_PARTITION_ON_HASH_PART_TABLE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_SPLIT_HASH_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_DUPLICATE_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_DUPLICATE_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_ALREADY_EXIST_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_ALREADY_EXIST_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_ACCESS_NOT_SUPPORT_MVIEW );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDM_ACCESS_NOT_SUPPORT_MVIEW ) );
    }
#ifdef ALTI_CFG_EDITION_DISK
    IDE_EXCEPTION( ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_USE_ONLY_DISK_TABLE_PARTITION_IN_DISK_EDITION ) );
    }
#endif
    IDE_EXCEPTION(ERR_GLOBAL_DDL)
    {
        QC_SHARD_GLOBAL_DDL_SET_ALLOWED( aStatement, ID_FALSE );
        IDE_SET( ideSetErrorCode( sdERR_ABORT_SDI_UNSUPPORTED_SPLIT_PARTITION_GLOBAL_DDL ) );
    }
    IDE_EXCEPTION( ERR_PART_COND_COUNT )
    {
        QC_SHARD_GLOBAL_DDL_SET_ALLOWED( aStatement, ID_FALSE );
        QC_STR_COPY( sDstPartName, sDstPartAttr->tablePartName );
        IDE_SET( ideSetErrorCode(sdERR_ABORT_SDM_PARTITION_KEY_COND_COUNT, sDstPartName) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateReorganizeCol( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description : PROJ-2264 Dictionary table
 *    ALTER TABLE ... REORGANIZE COLUMN ...  validation 
 *
 * Implementation :
 *    1. ϴ ̺ üũ
 *    2. ALTER Ϸ ̺ Ÿ ̸̺  ȯ
 *    3. ALTER TABLE  ִ üũ
 *    4.  ÷ compression column  üũ
 *
 ***********************************************************************/

    qdTableParseTree    * sParseTree;
    qcmColumn           * sParseColumn;
    qcmColumn           * sColumn;
    qcmTableInfo        * sTableInfo;
    qcuSqlSourceInfo      sqlInfo;
    UInt                  sColumnCount = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ALTER TABLE   validation 
    // => ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // PROJ-2429 Dictionary based data compress for on-disk DB 
    // volatile table   ʴ´.
    IDE_TEST_RAISE( smiTableSpace::isVolatileTableSpaceType( sTableInfo->TBSType ) == ID_TRUE,
                    ERR_NOT_SUPPORTED_TABLESPACE_TYPE );

    sParseColumn = sParseTree->columns;

    while ( sParseColumn != NULL )
    {
        // check column existence
        IDE_TEST(qcmCache::getColumn(aStatement,
                                     sTableInfo,
                                     sParseColumn->namePos,
                                     &sColumn) != IDE_SUCCESS);
        QDB_SET_QCM_COLUMN(sParseColumn, sColumn);

        // Compression column  üũ
        if ( ( sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK )
             == SMI_COLUMN_COMPRESSION_FALSE )
        {
            sqlInfo.setSourceInfo( aStatement, &(sParseColumn->namePos) );
            IDE_RAISE( ERR_REORGANIZE_COMPRESSION_COLUMN );
        }

        // column name Ѵ.
        idlOS::strncpy( sParseColumn->name,
                        sColumn->name,
                        QC_MAX_OBJECT_NAME_LEN + 1 );
        sParseColumn->name[QC_MAX_OBJECT_NAME_LEN] = '\0';

        sColumnCount++;
        sParseColumn = sParseColumn->next;
    }

    /* BUG-42759 Meta Table Cache ϸ  ˴ϴ.
     *  1. qcmCache::getColumn() Meta Table Cach Column ɴϴ.
     *  2. QDB_SET_QCM_COLUMN() Column Pointer sParseTree->columns մϴ.
     *  3. qcmDictionary::recreateDictionaryTable(), sParseTree->columns  Meta Table Cache մϴ.
     *
     *  sParseTree->columns Ͽ, Meta Table Cache  ʵ մϴ.
     */
    IDE_TEST( qcm::copyQcmColumns( QC_QMP_MEM( aStatement ),
                                   sParseTree->columns,
                                   &sParseColumn,
                                   sColumnCount )
              != IDE_SUCCESS );

    sParseTree->columns = sParseColumn;

    IDE_TEST_RAISE( sTableInfo->replicationCount > 0, ERR_REORGANIZE_REPL_TABLE );

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_NOT_SUPPORTED_TABLESPACE_TYPE)
    {    
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_COMPRESSION_NOT_SUPPORTED_TABLESPACE ) ); 
    }
    IDE_EXCEPTION( ERR_REORGANIZE_COMPRESSION_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_REORGANIZE_COMPRESSION_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_REORGANIZE_REPL_TABLE );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_REORGANIZE_COMPRESSION_COL_WITH_REPLICATED_TBL ) );
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::checkIndexPartAttrList(
    qcStatement             * aStatement,
    qcmTableInfo            * aTableInfo,
    qcmTableInfo            * aSrcPartInfo,
    qdPartitionAttribute    * aSrcPartAttr,
    qdPartitionAttribute    * aNewPartAttr,
    UInt                      aUserID)
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502
 *
 *    ALTER TABLE SPLIT PARTITION
 *                MERGE PARTITIONS
 *                ADD PARTITION ,
 *
 *    ε Ƽ  , validationϱ  ȴ.
 *
 * Implementation :
 *
 *
 *
 ***********************************************************************/

    qcuSqlSourceInfo          sqlInfo;
    UInt                      sIndexCount;
    UInt                      sCount = 0;
    qcmIndex                * sIndex;
    idBool                    sIsFound = ID_FALSE;
    // TASK-3876 Code Sonar, warning  0 
    UInt                      sPartIndexIDFromName = 0;
    UInt                      sPartIndexIDFromIndexPart = 0;
    SChar                     sIndexPartName[QC_MAX_OBJECT_NAME_LEN + 1];

    qdIndexPartitionAttribute * sIndexPartAttr = NULL;
    qdIndexPartitionAttribute * sTempAttr      = NULL;

    // ش ̺  ε  ִ üũ
    for ( sIndexPartAttr = aNewPartAttr->alterPart->indexPartAttr;
          sIndexPartAttr != NULL;
          sIndexPartAttr = sIndexPartAttr->next )
    {
        sIsFound = ID_FALSE;

        for ( sIndexCount = 0;
              sIndexCount < aTableInfo->indexCount;
              sIndexCount++ )
        {
            sIndex = & aTableInfo->indices[sIndexCount];

            // index attribute partitined index   ִ.
            if( ( sIndex->indexPartitionType != QCM_NONE_PARTITIONED_INDEX )
                &&
                ( idlOS::strMatch(sIndex->name,
                                  idlOS::strlen(sIndex->name),
                                  sIndexPartAttr->partIndexName.stmtText +
                                  sIndexPartAttr->partIndexName.offset,
                                  sIndexPartAttr->partIndexName.size) == 0 ) )
            {
                sIsFound = ID_TRUE;
                break;
            }
        }

        if( sIsFound == ID_FALSE )
        {
            break;
        }
    }

    if( sIsFound == ID_FALSE )
    {
        sqlInfo.setSourceInfo(aStatement,
                              & sIndexPartAttr->partIndexName );
        IDE_RAISE( ERR_NOT_EXIST_PARTITIONED_INDEX );
    }

    // ------------------------------------------------------------
    //  ε Ƽ ŭ ݺϸ validation
    // ------------------------------------------------------------
    for ( sIndexPartAttr = aNewPartAttr->alterPart->indexPartAttr;
          sIndexPartAttr != NULL;
          sIndexPartAttr = sIndexPartAttr->next )
    {
        // ------------------------------------------------------------
        // ̸ ߺ ˻
        // ------------------------------------------------------------
        for ( sTempAttr = aNewPartAttr->alterPart->indexPartAttr;
              sTempAttr != sIndexPartAttr;
              sTempAttr = sTempAttr->next )
        {
            // Ƽǵ ε ̸ ߺ ˻
            if ( QC_IS_NAME_MATCHED( sIndexPartAttr->partIndexName, sTempAttr->partIndexName ) )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sIndexPartAttr->partIndexName );
                IDE_RAISE( ERR_DUPLICATED_PARTITIONED_INDEX );
            }

            // ε Ƽ ̸ ߺ ˻
            if ( QC_IS_NAME_MATCHED( sIndexPartAttr->indexPartName, sTempAttr->indexPartName ) )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sIndexPartAttr->indexPartName);
                IDE_RAISE( ERR_DUPLICATE_PARTITION_NAME );
            }
        }

        // ADD PARTITION  
        if( aSrcPartInfo != NULL )
        {
            for( sIndexCount = 0;
                 sIndexCount < aSrcPartInfo->indexCount;
                 sIndexCount++ )
            {
                sIndex = & aSrcPartInfo->indices[sIndexCount];

                // SrcPart Ƽǵ ε ID ã
                if( idlOS::strMatch(sIndex->name,
                                    idlOS::strlen(sIndex->name),
                                    sIndexPartAttr->indexPartName.stmtText +
                                    sIndexPartAttr->indexPartName.offset,
                                    sIndexPartAttr->indexPartName.size)
                    == 0 )
                {
                    sPartIndexIDFromIndexPart = sIndex->indexId;
                    break;
                }
            }
        }

        for( sIndexCount = 0;
             sIndexCount < aTableInfo->indexCount;
             sIndexCount++ )
        {
            sIndex = & aTableInfo->indices[sIndexCount];

            //  Ƽǵ ε ̸ ID ã
            if( idlOS::strMatch(sIndex->name,
                                idlOS::strlen(sIndex->name),
                                sIndexPartAttr->partIndexName.stmtText +
                                sIndexPartAttr->partIndexName.offset,
                                sIndexPartAttr->partIndexName.size)
                == 0 )
            {
                sPartIndexIDFromName = sIndex->indexId;
                break;
            }
        }

        //  ̸ ε Ƽ
        // ش ̺ Ƽǿ ̹ ִ üũ
        // SrcPart DstPart ̸  쿡
        // ε Ƽ ̸     ִ.
        if ( ( aSrcPartAttr != NULL ) &&
             QC_IS_NAME_MATCHED( aSrcPartAttr->tablePartName, aNewPartAttr->tablePartName ) )
        {
            //  ε Ƽǰ  ̸  쿡 ƴ
            if( sPartIndexIDFromName != sPartIndexIDFromIndexPart )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sIndexPartAttr->indexPartName);
                IDE_RAISE( ERR_INVALID_INDEX_PARTITION_NAME );
            }
        }
        // SrcPart DstPart ̸ ٸٸ
        //  Ƽǵ ε, ε Ƽ ̸ ̹
        // SYS_INDEX_PARTITIONS_  
        else
        {
            QC_STR_COPY( sIndexPartName, sIndexPartAttr->indexPartName );

            IDE_TEST( qcmPartition::getIndexPartitionCount(
                          aStatement,
                          sPartIndexIDFromName,
                          sIndexPartName,
                          idlOS::strlen( sIndexPartName ),
                          & sCount )
                      != IDE_SUCCESS );

            if( sCount != 0 )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sIndexPartAttr->indexPartName);
                IDE_RAISE( ERR_ALREADY_EXIST_INDEX_PARTITION_NAME );
            }
        }

        // ------------------------------------------------------------
        // ̺ ̽ validation
        // ------------------------------------------------------------
        IDE_TEST( qdtCommon::getAndValidateTBSOfIndexPartition(
                      aStatement,
                      aNewPartAttr->TBSAttr.mID,
                      aNewPartAttr->TBSAttr.mType,
                      sIndexPartAttr->TBSName,
                      aUserID,
                      & sIndexPartAttr->TBSAttr.mID,
                      & sIndexPartAttr->TBSAttr.mType )
                  != IDE_SUCCESS );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_DUPLICATE_PARTITION_NAME);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_DUPLICATE_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_DUPLICATED_PARTITIONED_INDEX);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_DUP_PARTITIONED_INDEX_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_NOT_EXIST_PARTITIONED_INDEX);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_NOT_EXIST_PARTITIONED_INDEX,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_INVALID_INDEX_PARTITION_NAME);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_INVALID_INDEX_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_ALREADY_EXIST_INDEX_PARTITION_NAME);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_ALREADY_EXIST_INDEX_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateMergePartition(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *    ALTER TABLE ... MERGE PARTITIONS ...  validation 
 *
 *    ALTER TABLE tbl_name MERGE PARTITIONS src_part1, src_part2
 *            INTO PARTITION dst_part
 *     validation
 *
 *
 * Implementation :
 *      1. ALTER TABLE   validation 
 *      2. Ƽǵ ̺ üũ
 *      3. ؽ Ƽǵ ̸̺ 
 *      4. ACCESS  ̺ Ÿ ˻
 *      5. Ƽ ̸ validation
 *          4-1. SrcPart1 SrcPart2 ̸  üũ
 *          4-2. SrcPart1, SrcPart2 Ƽ ϴ üũ
 *      6.  Ƽǵ ̺
 *          5-1. SrcPart1 SrcPart2  ִ üũ
 *      7. DstPart ̺̽ validation
 *      8. Lob Column validation
 *      9. In-place Merge Out-place Merge 
 *     10. Out-place 
 *         DstPart ̸  ̸ Ƽ ִ üũ
 *
 *          - In-place Merge
 *              - Left In-place Merge
 *                  ( src_part1 == dst_part )
 *              - Right In-place Merge
 *                  ( src_part2 == dst_part )
 *
 *          - Out-place Merge
 *              ( src_part1 != dst_part ) and ( src_part2 != dst_part )
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sSrcPartAttr1;
    qdPartitionAttribute    * sSrcPartAttr2;
    qdPartitionAttribute    * sDstPartAttr;
    qcmTableInfo            * sSrcPartInfo1;
    qcmTableInfo            * sSrcPartInfo2;
    qcmTableInfo            * sDstPartInfo;
    smOID                   * sOldPartitionOID;
    smSCN                     sDstPartSCN;
    void                    * sDstPartHandle;
    qcuSqlSourceInfo          sqlInfo;

    qcmColumn               * sTargetColumn;
    qcmColumn               * sTableColumn;
    idBool                    sIsDefaultTBS;
    UInt                      i;


    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE_PARTITION,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_FALSE /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    // ------------------------------------------------------
    // 3. ؽ Ƽǵ ̸̺ 
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_HASH,
                    ERR_MERGE_PARTITION_ON_HASH_PART_TABLE );

    sSrcPartAttr1 = sParseTree->partTable->partAttr;
    sSrcPartAttr2 = sParseTree->partTable->partAttr->next;
    sDstPartAttr = sParseTree->partTable->partAttr->next->next;

    // ------------------------------------------------------
    // 4. ACCESS  ̺ Ÿ ˻
    // ------------------------------------------------------
    /* PROJ-2359 Table/Partition Access Option */
    IDE_TEST_RAISE( ( sTableInfo->tableType == QCM_MVIEW_TABLE ) &&
                    ( sDstPartAttr->accessOption != QCM_ACCESS_OPTION_NONE ),
                    ERR_ACCESS_NOT_SUPPORT_MVIEW );

    // ------------------------------------------------------
    // 5. Ƽ ̸ validation
    // ------------------------------------------------------
    // SrcPart1 SrcPart2 ̸  üũ
    if ( QC_IS_NAME_MATCHED( sSrcPartAttr1->tablePartName, sSrcPartAttr2->tablePartName ) )
    {
        sqlInfo.setSourceInfo(aStatement,
                              & sSrcPartAttr2->tablePartName );
        IDE_RAISE( ERR_DUPLICATE_PARTITION_NAME );
    }

    // ------------------------------------------------------
    // SrcPart1 Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sSrcPartAttr1->tablePartName )
              != IDE_SUCCESS );

    sSrcPartInfo1 = sParseTree->partTable->partInfoList->partitionInfo;

    // ------------------------------------------------------
    // SrcPart2 Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sSrcPartAttr2->tablePartName )
              != IDE_SUCCESS );

    sSrcPartInfo2 = sParseTree->partTable->partInfoList->next->partitionInfo;
 
    if ( ( sSrcPartInfo1->replicationCount > 0 ) || ( sSrcPartInfo2->replicationCount > 0 ) )
    {
        if ( sSrcPartInfo1->replicationCount > 0 )
        {
            IDE_TEST( qci::mValidateReplicationCallback.mValidateAlterPartition( aStatement,
                                                                                 sSrcPartInfo1 )
                      != IDE_SUCCESS );
        }
        else
        {
            /* Nothing to do */
        }

        if ( sSrcPartInfo2->replicationCount > 0 )
        {
            IDE_TEST( qci::mValidateReplicationCallback.mValidateAlterPartition( aStatement,
                                                                                 sSrcPartInfo2 )
                      != IDE_SUCCESS );
        }
        else
        {
            /* Nothing to do */
        }

    }
    else
    {
        // Nothing to do
    }

    if ( ( sSrcPartInfo1->replicationCount > 0 ) || ( sSrcPartInfo2->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        IDE_TEST( QC_QMP_MEM( aStatement )->alloc( ID_SIZEOF(smOID) * 2, (void**)&sOldPartitionOID )
                  != IDE_SUCCESS);
        sOldPartitionOID[0] = sSrcPartInfo1->tableOID;
        sOldPartitionOID[1] = sSrcPartInfo2->tableOID;

        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            2,
                            sOldPartitionOID );
    }
    // ------------------------------------------------------
    // non-partitioned index Ʈ ´.
    // ------------------------------------------------------
    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList( aStatement,
                                              ID_FALSE,
                                              sParseTree->tableInfo,
                                              &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    // ------------------------------------------------------
    // SrcPart1 min_value, max_value
    // mtdCharType, qmsPartCondValList, qmmValueNode
    //  ĽƮ ޾Ƴ´.
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::makePartCondValList( aStatement,
                                              sTableInfo,
                                              sSrcPartInfo1->partitionID,
                                              sSrcPartAttr1 )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // SrcPart2 min_value, max_value
    // mtdCharType, qmsPartCondValList, qmmValueNode
    //  ĽƮ ޾Ƴ´.
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::makePartCondValList( aStatement,
                                              sTableInfo,
                                              sSrcPartInfo2->partitionID,
                                              sSrcPartAttr2 )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // 6.  Ƽǵ ̸̺
    //    SrcPart1 SrcPart2  ִ üũ
    // ------------------------------------------------------
    if( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE )
    {
        IDE_TEST( qdbAlter::checkAdjPartition( aStatement,
                                               sTableInfo )
                  != IDE_SUCCESS );
    }
    else if ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH )
    {
        /* BUG-46065 support range using hash */
        IDE_TEST( qdbAlter::checkAdjRangeUsingHashPartition( aStatement,
                                                             sTableInfo )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    // ------------------------------------------------------
    // 7. DstPart ̺̽ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::validateTBSOfPartition( aStatement, sDstPartAttr )
              != IDE_SUCCESS );

    /* PROJ-2639 Altibase Disk Edition */
#ifdef ALTI_CFG_EDITION_DISK
    if ( sTableInfo->tableOwnerID == QC_SYSTEM_USER_ID )
    {
        /* Nothing to do */
    }
    else
    {
        IDE_TEST_RAISE( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_FALSE,
                        ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
    }
#endif

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( validateTablespaceRestriction( sTableInfo, sDstPartAttr->TBSAttr.mType )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    // qdbCommon::getTableTypeCountInPartAttrList() ϱ , Src, Dst Partition List  иѴ.
    sSrcPartAttr2->next = NULL;
    IDE_TEST( validateTableReferenceForPartitions( aStatement,
                                                   sTableInfo,
                                                   sSrcPartAttr1,
                                                   sDstPartAttr )
              != IDE_SUCCESS );
    sSrcPartAttr2->next = sDstPartAttr;

    // ------------------------------------------------------
    // 8. validation of LOB column attributes
    // ------------------------------------------------------
    //  ƼǺ LOB ÷  ϱ 
    // ̺ ÷   ̺ Ƽ ÷  Ѵ.
    // IN-PLACE TABLESPACE õ    Ƽ
    // TBS .( OUT-PLACE  Ƽǵ ̺ TBS .
    sDstPartAttr->columns  = NULL;
    if ( QC_IS_NAME_MATCHED( sDstPartAttr->tablePartName, sSrcPartAttr1->tablePartName ) &&
         ( QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_TRUE ) &&
         ( sDstPartAttr->lobAttr == NULL ) )
    {
        IDE_TEST( qcm::copyQcmColumns( QC_QMP_MEM(aStatement),
                                       sSrcPartInfo1->columns,
                                       &(sDstPartAttr->columns ),
                                       sSrcPartInfo1->columnCount ) != IDE_SUCCESS );
    }
    else
    {
        if ( QC_IS_NAME_MATCHED( sDstPartAttr->tablePartName, sSrcPartAttr2->tablePartName ) &&
             ( QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_TRUE ) &&
             ( sDstPartAttr->lobAttr == NULL ) )
        {
            IDE_TEST( qcm::copyQcmColumns( QC_QMP_MEM(aStatement),
                                           sSrcPartInfo2->columns,
                                           &(sDstPartAttr->columns ),
                                           sSrcPartInfo2->columnCount ) != IDE_SUCCESS );
        }
        else
        {
            /* PROJ-2464 hybrid partitioned table  */
            IDE_TEST( qdbCommon::copyAndAdjustColumnList( aStatement,
                                                          sTableInfo->TBSType,
                                                          sDstPartAttr->TBSAttr.mType,
                                                          sTableInfo->columns,
                                                          &(sDstPartAttr->columns),
                                                          sTableInfo->columnCount,
                                                          ID_FALSE /* aEnableVariableColumn */ )
                      != IDE_SUCCESS );

            for( i = 0, sTableColumn = sTableInfo->columns, sTargetColumn = sDstPartAttr->columns;
                 sTableColumn != NULL ;
                 i++, sTableColumn = sTableColumn->next, sTargetColumn = sTargetColumn->next )
            {

                if ( (sTableColumn->basicInfo->module->flag &
                      MTD_COLUMN_TYPE_MASK)
                     == MTD_COLUMN_TYPE_LOB )
                {
                    /* Ƽǵ ̺ LOB COLUMN TBS   */
                    IDE_TEST( qcm::getIsDefaultTBS(
                                  aStatement,
                                  sTableInfo->tableID,
                                  (sTableInfo->tableID * SMI_COLUMN_ID_MAXIMUM) + i,
                                  & sIsDefaultTBS )
                              != IDE_SUCCESS );

                    /* PROJ-2464 hybrid partitioned table 
                     *  - Disk Partition , Partitioned Lob Column TBS(Default TBS)
                     *    Ǿ  Default TBS Ѵ.
                     *  - PROJ-2334 PMT MEMORY PARTITIONED TABLE : Memory Partition ,
                     *    Partition TBS Ѵ.
                     */
                    /* PROJ-2465 Tablespace Alteration for Table
                     *  -  Default TBS ó ߰Ѵ.
                     */
                    if ( ( sIsDefaultTBS == ID_TRUE ) &&
                         ( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_TRUE ) &&
                         ( smiTableSpace::isDiskTableSpaceType( sTableInfo->TBSType ) == ID_TRUE ) )
                    {
                        /* Create ColSpace  Default TBS ״ ̿Ѵ. */
                        /* Nothing to do */
                    }
                    else
                    {
                        sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
                    }
                }
                else
                {
                    sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
                }
            } // for
        }
    }

    // LOB ÷ TBS  , Ƽ TBS .
    // ڷ  sTableInfo   ̰,
    //  sDstPartAttr TBS  ȴ.
    IDE_TEST(qdbCommon::validateLobAttributeList(
                 aStatement,
                 sTableInfo,
                 sDstPartAttr->columns,
                 &(sDstPartAttr->TBSAttr),
                 sDstPartAttr->lobAttr )
             != IDE_SUCCESS);

    // ------------------------------------------------------
    // 9. In-place Split Out-place Split 
    // ------------------------------------------------------
    if ( QC_IS_NAME_MATCHED( sSrcPartAttr1->tablePartName, sDstPartAttr->tablePartName ) )
    {
        if( (QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_TRUE) &&
            (sDstPartAttr->lobAttr == NULL) &&
            (sDstPartAttr->alterPart->indexPartAttr == NULL) )
        {
            sSrcPartAttr1->alterPart->splitMergeType =
                QD_ALTER_PARTITION_LEFT_INPLACE_TYPE;
        }
        else
        {
            sSrcPartAttr1->alterPart->splitMergeType =
                QD_ALTER_PARTITION_OUTPLACE_TYPE;
        }
    }
    else if ( QC_IS_NAME_MATCHED( sSrcPartAttr2->tablePartName, sDstPartAttr->tablePartName ) )
    {
        if( (QC_IS_NULL_NAME( sDstPartAttr->TBSName ) == ID_TRUE) &&
            (sDstPartAttr->lobAttr == NULL) &&
            (sDstPartAttr->alterPart->indexPartAttr == NULL) )
        {
            sSrcPartAttr1->alterPart->splitMergeType =
                QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE;
        }
        else
        {
            sSrcPartAttr1->alterPart->splitMergeType =
                QD_ALTER_PARTITION_OUTPLACE_TYPE;
        }
    }
    else
    {
        sSrcPartAttr1->alterPart->splitMergeType =
            QD_ALTER_PARTITION_OUTPLACE_TYPE;
    }

    // ------------------------------------------------------
    // 10. Out-place  DstPart ̸  ̸ Ƽ ִ üũ
    // ------------------------------------------------------
    if( sSrcPartAttr1->alterPart->splitMergeType ==
        QD_ALTER_PARTITION_OUTPLACE_TYPE )
    {
        if ( ( QC_IS_NAME_MATCHED( sSrcPartAttr1->tablePartName, sDstPartAttr->tablePartName ) == ID_FALSE ) &&
             ( QC_IS_NAME_MATCHED( sSrcPartAttr2->tablePartName, sDstPartAttr->tablePartName ) == ID_FALSE ) )
        {
            if( qcmPartition::getPartitionInfo( aStatement,
                                                sTableInfo->tableID,
                                                sDstPartAttr->tablePartName,
                                                & sDstPartInfo,
                                                & sDstPartSCN,
                                                & sDstPartHandle )
                == IDE_SUCCESS )
            {
                sqlInfo.setSourceInfo(aStatement,
                                      & sDstPartAttr->tablePartName );
                IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
            }
        }
        else
        {
            // DstPart ̸ SrcPart1 Ǵ SrcPart2 ̸ 
            // DstPart TBS ϸ Out-place зȴ.
            // (SrcPart TBS  TBS ϴ Out-place̴.)
            // , ̷ 쿡 DstPart ̸ üũ ʿ.

            // Nothing to do
        }
    }
    else
    {
        // Nothing to do
    }

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( validateIndexAlterationForPartition( aStatement,
                                                   sTableInfo,
                                                   sSrcPartInfo1,
                                                   sDstPartAttr )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // ε Ƽ   validation
    // ------------------------------------------------------

    if ( sDstPartAttr->alterPart->indexPartAttr != NULL )
    {
        // SrcPart1 DstPart ̸  
        if ( QC_IS_NAME_MATCHED( sSrcPartAttr1->tablePartName, sDstPartAttr->tablePartName ) )
        {
            // ε Ƽ ̸ ״ ߴ üũϱ 
            // SrcPart ڷ ش.
            IDE_TEST( checkIndexPartAttrList( aStatement,
                                              sTableInfo,
                                              sSrcPartInfo1,
                                              sSrcPartAttr1,
                                              sDstPartAttr,
                                              sParseTree->userID )
                      != IDE_SUCCESS );
        }
        // SrcPart2 DstPart ̸  
        // SrcPart1, SrcPart2 ̸ DstPart ̸   
        else
        {
            // ε Ƽ ̸ ״ ߴ üũ
            //    쿡 
            IDE_TEST( checkIndexPartAttrList( aStatement,
                                              sTableInfo,
                                              sSrcPartInfo2,
                                              sSrcPartAttr2,
                                              sDstPartAttr,
                                              sParseTree->userID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_MERGE_PARTITION_ON_HASH_PART_TABLE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_MERGE_HASH_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_DUPLICATE_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_DUPLICATE_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION(ERR_ALREADY_EXIST_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_ALREADY_EXIST_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_ACCESS_NOT_SUPPORT_MVIEW );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDM_ACCESS_NOT_SUPPORT_MVIEW ) );
    }
#ifdef ALTI_CFG_EDITION_DISK
    IDE_EXCEPTION( ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_USE_ONLY_DISK_TABLE_PARTITION_IN_DISK_EDITION ) );
    }
#endif
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateDropPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree       * sParseTree;
    qcmTableInfo           * sTableInfo;
    qdPartitionAttribute   * sPartAttr;
    qcmTableInfo           * sPartitionInfo;
    UInt                     sFindPartID = 0;          // TASK-3876 Code Sonar
    UInt                     sPartitionCount = 0;
    qcmPartitionIdList     * sPartIdList = NULL;
    idBool                   sIsFound = ID_FALSE;      // TASK-3876 Code Sonar

    qmsPartCondValList     * sPartCondMaxVal;
    mtdCharType            * sPartKeyCondMinValueStr;
    mtdCharType            * sPartKeyCondMaxValueStr;

    qmsPartCondValList     * sFindPartCondMinVal;
    mtdCharType            * sFindPartKeyCondMinValueStr;
    mtdCharType            * sFindPartKeyCondMaxValueStr;

    idBool                   sIsEmptyPart = ID_FALSE;

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc1");
    IDE_TEST( STRUCT_ALLOC( QC_QMP_MEM(aStatement),
                            qmsPartCondValList,
                            & sPartCondMaxVal )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc2");
    IDE_TEST( STRUCT_ALLOC( QC_QMP_MEM(aStatement),
                            qmsPartCondValList,
                            & sFindPartCondMinVal )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc3");
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE(
                  QC_QMP_MEM(aStatement),
                  UChar,
                  MTD_CHAR_TYPE_STRUCT_SIZE(QC_MAX_PARTKEY_COND_VALUE_LEN),
                  (void**) & sPartKeyCondMinValueStr )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc4");
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE(
                  QC_QMP_MEM(aStatement),
                  UChar,
                  MTD_CHAR_TYPE_STRUCT_SIZE(QC_MAX_PARTKEY_COND_VALUE_LEN),
                  (void**) & sPartKeyCondMaxValueStr )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc5");
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE(
                  QC_QMP_MEM(aStatement),
                  UChar,
                  MTD_CHAR_TYPE_STRUCT_SIZE(QC_MAX_PARTKEY_COND_VALUE_LEN),
                  (void**) & sFindPartKeyCondMinValueStr )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateDropPartition::malloc6");
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE(
                  QC_QMP_MEM(aStatement),
                  UChar,
                  MTD_CHAR_TYPE_STRUCT_SIZE(QC_MAX_PARTKEY_COND_VALUE_LEN),
                  (void**) & sFindPartKeyCondMaxValueStr )
              != IDE_SUCCESS );

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE_PARTITION,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_FALSE /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    sPartAttr = sParseTree->partTable->partAttr;

    // ------------------------------------------------------
    // 3.  Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sPartAttr->tablePartName )
              != IDE_SUCCESS );

    sPartitionInfo = sParseTree->partTable->partInfoList->partitionInfo;

    // ------------------------------------------------------
    // 3.5 non-partitioned index Ʈ ´.
    // ------------------------------------------------------
    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList( aStatement,
                                              ID_FALSE,
                                              sParseTree->tableInfo,
                                              &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    // ------------------------------------------------------
    // ؽ Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_HASH,
                    ERR_DROP_PARTITION_ON_HASH_PART_TABLE );

    // ------------------------------------------------------
    //  Ƽ  1 üũ
    // ------------------------------------------------------
    IDE_TEST( qcmPartition::getPartitionCount( aStatement,
                                               sTableInfo->tableID,
                                               & sPartitionCount )
              != IDE_SUCCESS );

    if ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE )
    {
        // Empty partition 
        IDE_TEST( qcmPartition::isEmptyPartition( QC_SMI_STMT( aStatement ),
                                                  sTableInfo->tableID,
                                                  &sIsEmptyPart )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    if ( sIsEmptyPart == ID_FALSE )
    {
        IDE_TEST_RAISE( sPartitionCount < 2,
                        ERR_DROP_THE_ONLY_PARTITION);
    }
    else
    {
        // BUG-47599 empty partition ϰ Ȯ
        IDE_TEST_RAISE( sPartitionCount < 3,
                        ERR_DROP_THE_ONLY_PARTITION);
    }

    // ------------------------------------------------------
    // default Ƽ üũ
    // ------------------------------------------------------
    IDE_TEST( qcmPartition::getPartMinMaxValue( QC_SMI_STMT( aStatement ),
                                                sPartitionInfo->partitionID,
                                                sPartKeyCondMinValueStr,
                                                sPartKeyCondMaxValueStr )
              != IDE_SUCCESS );

    // , Ʈ Ƽǵ ̺  ⺻ Ƽ max_value '\0'̴.
    IDE_TEST_RAISE( sPartKeyCondMaxValueStr->length == 0,
                    ERR_DROP_THE_DEFAULT_PARTITION);

    // ------------------------------------------------
    //  Ƽǵ ̸̺  Ƽ  Ƽ ã
    // ( Ƽ PARTITION_MIN_VALUE  Ǿ )
    // ------------------------------------------------
    if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
         ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
    {
        //  Ƽ max_value qmsPartCondValList .
        IDE_TEST( qcmPartition::getPartCondVal(
                      aStatement,
                      sTableInfo->partKeyColumns,
                      sTableInfo->partitionMethod,
                      sPartCondMaxVal,
                      NULL, /* aPartCondValStmtText */
                      NULL, /* aPartCondValNode */
                      sPartKeyCondMaxValueStr )
                  != IDE_SUCCESS );

        if (sPartCondMaxVal->partCondValCount == 0)
        {
            sPartCondMaxVal->partCondValType = QMS_PARTCONDVAL_DEFAULT;
        }
        else
        {
            sPartCondMaxVal->partCondValType = QMS_PARTCONDVAL_NORMAL;
        }

        // tableID Ƽ ID Ʈ ´.
        IDE_TEST( qcmPartition::getPartitionIdList( aStatement,
                                                    QC_SMI_STMT( aStatement ),
                                                    sTableInfo->tableID,
                                                    & sPartIdList )
                  != IDE_SUCCESS );

        for( ;
             sPartIdList != NULL;
             sPartIdList = sPartIdList->next )
        {
            sFindPartID = sPartIdList->partId;

            if( sFindPartID == sPartitionInfo->partitionID )
            {
                continue;
            }

            IDE_TEST( qcmPartition::getPartMinMaxValue( QC_SMI_STMT(aStatement),
                                                        sFindPartID,
                                                        sFindPartKeyCondMinValueStr,
                                                        sFindPartKeyCondMaxValueStr )
                      != IDE_SUCCESS );

            // ã Ƽ min_value qmsPartCondValList .
            IDE_TEST( qcmPartition::getPartCondVal(
                          aStatement,
                          sTableInfo->partKeyColumns,
                          sTableInfo->partitionMethod,
                          sFindPartCondMinVal,
                          NULL, /* aPartCondValStmtText */
                          NULL, /* aPartCondValNode */
                          sFindPartKeyCondMinValueStr )
                      != IDE_SUCCESS );

            if (sFindPartCondMinVal->partCondValCount == 0)
            {
                sFindPartCondMinVal->partCondValType = QMS_PARTCONDVAL_MIN;
            }
            else
            {
                sFindPartCondMinVal->partCondValType = QMS_PARTCONDVAL_NORMAL;
            }

            if ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE )
            {
                if ( qmoPartition::compareRangePartition( sTableInfo->partKeyColumns,
                                                          sPartCondMaxVal,
                                                          sFindPartCondMinVal ) == 0 )
                {
                    sIsFound = ID_TRUE;
                    break;
                }
                else
                {
                    // Nothing to do
                }
            }
            else
            {
                /* BUG-46065 support range using hash */
                if ( qmoPartition::compareRangeUsingHashPartition( sPartCondMaxVal,
                                                                   sFindPartCondMinVal ) == 0 )
                {
                    sIsFound = ID_TRUE;
                    break;
                }
                else
                {
                    // Nothing to do
                }
            }
        }

        IDE_DASSERT( sIsFound == ID_TRUE );

        // BUG-47599
        IDU_FIT_POINT( "qdbAlter::validateDropPartition::beforeCheckPartitionInfo" );

        //  Ƽ  ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                                 sFindPartID )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do
    }

    if ( sPartitionInfo->replicationCount > 0 )
    {
        IDE_TEST( qci::mValidateReplicationCallback.mValidateAlterPartition( aStatement,
                                                                             sPartitionInfo )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sPartitionInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        /* BUG-46457 Drop Partition DDL asynchronization support */
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sTableInfo->tableOID),
                            1,
                            &(sPartitionInfo->tableOID) );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_DROP_PARTITION_ON_HASH_PART_TABLE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DROP_PARTITION_ON_HASH_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_DROP_THE_ONLY_PARTITION)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DROP_THE_ONLY_PARTITION));
    }
    IDE_EXCEPTION(ERR_DROP_THE_DEFAULT_PARTITION)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DROP_THE_DEFAULT_PARTITION));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateRenamePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *    ALTER TABLE t1 RENAME PARTITION old_part TO new_part;
 *     validation
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sOldPartAttr;
    qdPartitionAttribute    * sNewPartAttr;
    qcuSqlSourceInfo          sqlInfo;

    qcmTableInfo            * sPartitionInfo;
    void                    * sHandle;
    smSCN                     sSCN;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    sOldPartAttr = sParseTree->partTable->partAttr;
    sNewPartAttr = sParseTree->partTable->partAttr->next;

    // ------------------------------------------------------
    // 3. OldPart Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sOldPartAttr->tablePartName )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // 4. NewPart Ƽ ̸ validation
    // ------------------------------------------------------
    if( qcmPartition::getPartitionInfo( aStatement,
                                        sTableInfo->tableID,
                                        sNewPartAttr->tablePartName,
                                        & sPartitionInfo,
                                        & sSCN,
                                        & sHandle )
        == IDE_SUCCESS )
    {
        sqlInfo.setSourceInfo(aStatement,
                              & sNewPartAttr->tablePartName );
        IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_ALREADY_EXIST_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_ALREADY_EXIST_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateTruncatePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *    1. ALTER TABLE   validation
 *    2. Ƽǵ ̺ üũ
 *    3. Ƽ ̸ validation
 *    4. ũ Ű  &&  Ű ϴ childϴ üũ
 *    5. ̺ Replication ɷ, Recovery θ Ȯ
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sPartAttr;
    qcmTableInfo            * sPartInfo;
    UInt                      i;
    qcmRefChildInfo         * sChildInfo;  // BUG-28049
    qcmIndex                * sIndexInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE_PARTITION,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    sPartAttr = sParseTree->partTable->partAttr;

    // ------------------------------------------------------
    // 3. Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sPartAttr->tablePartName )
              != IDE_SUCCESS );

    sPartInfo = sParseTree->partTable->partInfoList->partitionInfo;

    // ------------------------------------------------------
    // 3.5 non-partitioned index Ʈ ´.
    // ------------------------------------------------------
    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList( aStatement,
                                              ID_FALSE,
                                              sParseTree->tableInfo,
                                              &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    // ------------------------------------------------------
    // 4. ũ Ű  &&  Ű ϴ childϴ üũ
    // ------------------------------------------------------
    // check referential constraint
    for (i = 0; i < sTableInfo->indexCount; i++)
    {
        sIndexInfo = &(sTableInfo->indices[i]);

        if( sIndexInfo->isUnique == ID_TRUE )
        {
            IDE_TEST(qcm::getChildKeys(aStatement,
                                       sIndexInfo,
                                       sTableInfo,
                                       & sChildInfo)
                     != IDE_SUCCESS);

            if (sChildInfo != NULL)
            {
                // BUG-28049
                while (sChildInfo->childTableRef != NULL) // foreign key exists.
                {
                    // not self
                    IDE_TEST_RAISE( sChildInfo->childTableRef->tableInfo != sPartInfo,
                                    ERR_ABORT_REFERENTIAL_CONSTRAINT_EXIST );

                    sChildInfo = sChildInfo->next;
                }
            }
        }
    }

    // ------------------------------------------------------
    // 5. Replication   ˻
    // ------------------------------------------------------
    /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
     * Recovery ɰ    
     */
    if(sTableInfo->replicationCount > 0)
    {
        IDE_TEST_RAISE(sTableInfo->replicationRecoveryCount > 0,
                       ERR_CANNOT_DDL_WITH_RECOVERY);
    }
    else
    {
        // Nothing to do.
    }

    if ( ( sTableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            1,
                            &(sPartInfo->tableOID) );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_ABORT_REFERENTIAL_CONSTRAINT_EXIST);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST));
    }
    IDE_EXCEPTION(ERR_CANNOT_DDL_WITH_RECOVERY)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_DDL_WITH_RECOVERY));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateRowmovement( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAddPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qcmColumn               * sTargetColumn;
    qcmColumn               * sTableColumn;
    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sDstPartAttr;
    qcmTableInfo            * sPartInfo;
    smSCN                     sSCN;
    void                    * sHandle;
    qcuSqlSourceInfo          sqlInfo;
    qcmPartitionInfoList    * sPartInfoList = NULL;
    qcmPartitionInfoList    * sTempPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    UInt                      sPartOrder = 0;
    UInt                      sTotalPartCount = 0;
    UInt                      i;
    idBool                    sIsDefaultTBS;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;
    sDstPartAttr = sParseTree->partTable->partAttr;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    // ------------------------------------------------------
    // ؽ Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->partitionMethod != QCM_PARTITION_METHOD_HASH,
                    ERR_ADD_PARTITION_ON_NONE_HASH_PART_TABLE );

    // ------------------------------------------------------
    // ACCESS  ̺ Ÿ ˻
    // ------------------------------------------------------
    /* PROJ-2359 Table/Partition Access Option */
    IDE_TEST_RAISE( ( sTableInfo->tableType == QCM_MVIEW_TABLE ) &&
                    ( sDstPartAttr->accessOption != QCM_ACCESS_OPTION_NONE ),
                    ERR_ACCESS_NOT_SUPPORT_MVIEW );

    // ------------------------------------------------------------
    // Ƽ , Handle, SCN Ʈ ؼ ĽƮ ޾Ƴ´.
    // ------------------------------------------------------------

    //  Ƽǿ LOCK(IS)
    // Ƽ Ʈ ĽƮ ޾Ƴ´.
    IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                  aStatement,
                  sParseTree->tableInfo->tableID,
                  & (sParseTree->partTable->partInfoList) )
              != IDE_SUCCESS );

    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList(
                  aStatement,
                  ID_FALSE,
                  sParseTree->tableInfo,
                  &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    sPartInfoList = sParseTree->partTable->partInfoList;

    // ------------------------------------------------------
    // DstPart Ƽ ̸ validation
    // ------------------------------------------------------
    if( qcmPartition::getPartitionInfo( aStatement,
                                        sTableInfo->tableID,
                                        sDstPartAttr->tablePartName,
                                        & sPartInfo,
                                        & sSCN,
                                        & sHandle )
        == IDE_SUCCESS )
    {
        sqlInfo.setSourceInfo(aStatement,
                              & sDstPartAttr->tablePartName );
        IDE_RAISE( ERR_ALREADY_EXIST_PARTITION_NAME );
    }

    // ------------------------------------------------------
    // DstPart ̺̽ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::validateTBSOfPartition( aStatement, sDstPartAttr )
              != IDE_SUCCESS );

    /* PROJ-2639 Altibase Disk Edition */
#ifdef ALTI_CFG_EDITION_DISK
    if ( sTableInfo->tableOwnerID == QC_SYSTEM_USER_ID )
    {
        /* Nothing to do */
    }
    else
    {
        IDE_TEST_RAISE( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_FALSE,
                        ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
    }
#endif

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( validateTablespaceRestriction( sTableInfo, sDstPartAttr->TBSAttr.mType )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( validateTableReferenceForPartitions( aStatement,
                                                   sTableInfo,
                                                   NULL,
                                                   sDstPartAttr )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // validation of LOB column attributes
    // ------------------------------------------------------
    //  ƼǺ LOB ÷  ϱ 
    // ̺ ÷   ̺ Ƽ ÷  Ѵ.
    sDstPartAttr->columns  = NULL;

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( qdbCommon::copyAndAdjustColumnList( aStatement,
                                                  sTableInfo->TBSType,
                                                  sDstPartAttr->TBSAttr.mType,
                                                  sTableInfo->columns,
                                                  &(sDstPartAttr->columns),
                                                  sTableInfo->columnCount,
                                                  ID_FALSE /* aEnableVariableColumn */ )
              != IDE_SUCCESS );

    // colSpace  TBS Ѵ.
    //  Ƽ TBS ̹ validateTBSOfPartition Լ
    // Ǿ ִ.
    for ( i = 0, sTableColumn = sTableInfo->columns, sTargetColumn = sDstPartAttr->columns;
          sTableColumn != NULL ;
          i++, sTableColumn = sTableColumn->next, sTargetColumn = sTargetColumn->next )
    {
        if ( ( sTableColumn->basicInfo->module->flag & MTD_COLUMN_TYPE_MASK )
             == MTD_COLUMN_TYPE_LOB )
        {
            // ڰ Ƽǵ ̺ LOB TBS   
            // Ƽ TBS .
            IDE_TEST( qcm::getIsDefaultTBS(
                          aStatement,
                          sTableInfo->tableID,
                          (sTableInfo->tableID * SMI_COLUMN_ID_MAXIMUM) + i,
                          & sIsDefaultTBS )
                      != IDE_SUCCESS );

            /* PROJ-2464 hybrid partitioned table 
             *  - Disk Partition , Partitioned Lob Column TBS(Default TBS)
             *    Ǿ  Default TBS Ѵ.
             *  - PROJ-2334 PMT MEMORY PARTITIONED TABLE : Memory Partition ,
             *    Partition TBS Ѵ.
             */
            /* PROJ-2465 Tablespace Alteration for Table
             *  -  Default TBS ó ߰Ѵ.
             */
            if ( ( sIsDefaultTBS == ID_TRUE ) &&
                 ( smiTableSpace::isDiskTableSpaceType( sDstPartAttr->TBSAttr.mType ) == ID_TRUE ) &&
                 ( smiTableSpace::isDiskTableSpaceType( sTableInfo->TBSType ) == ID_TRUE ) )
            {
                /* Create ColSpace  Default TBS ״ ̿Ѵ. */
                /* Nothing to do */
            }
            else
            {
                sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
            }
        }
        else
        {
            sTargetColumn->basicInfo->column.colSpace = sDstPartAttr->TBSAttr.mID;
        }
    }

    // LOB ÷ TBS  , Ƽ TBS .
    // ڷ  sTableInfo   ̰,
    //  sDstPartAttr TBS  ȴ.
    IDE_TEST(qdbCommon::validateLobAttributeList( aStatement,
                                                  sTableInfo,
                                                  sDstPartAttr->columns,
                                                  &(sDstPartAttr->TBSAttr),
                                                  sDstPartAttr->lobAttr )
             != IDE_SUCCESS);

    IDE_TEST( qcmPartition::getPartitionCount( aStatement,
                                               sTableInfo->tableID,
                                               & sTotalPartCount )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::validateAddPartition::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_COUNT(QC_QMP_MEM(aStatement),
                                     qcmPartitionInfoList,
                                     sTotalPartCount,
                                     & sNewPartInfoList)
             != IDE_SUCCESS);

    // ------------------------------------------------------
    // PartInfoList PartOrder  Ѵ.
    // ------------------------------------------------------
    for( sTempPartInfoList = sPartInfoList;
         sTempPartInfoList != NULL;
         sTempPartInfoList = sTempPartInfoList->next )
    {
        sPartInfo = sTempPartInfoList->partitionInfo;

        // get Partition Order
        IDE_TEST( qcmPartition::getPartitionOrder( QC_SMI_STMT( aStatement ),
                                                   sTableInfo->tableID,
                                                   (UChar *) sPartInfo->name,
                                                   idlOS::strlen(sPartInfo->name),
                                                   & sPartOrder )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                  sTableInfo->tableID,
                                                  (UChar *)sTempPartInfoList->partitionInfo->name,
                                                  idlOS::strlen(sTempPartInfoList->partitionInfo->name),
                                                  & sNewPartInfoList[sPartOrder].partitionInfo,
                                                  & sNewPartInfoList[sPartOrder].partSCN,
                                                  & sNewPartInfoList[sPartOrder].partHandle )
                  != IDE_SUCCESS );

        sNewPartInfoList[sPartOrder].next = NULL;
    }

    for( sPartOrder = 0;
         sPartOrder < sTotalPartCount;
         sPartOrder++ )
    {
        if( sPartOrder == (sTotalPartCount - 1) )
        {
            sNewPartInfoList[sPartOrder].next = NULL;
        }
        else
        {
            sNewPartInfoList[sPartOrder].next = & sNewPartInfoList[sPartOrder+1];
        }
    }

    sParseTree->partTable->partInfoList = sNewPartInfoList;

    /* PROJ-2464 hybrid partitioned table  */
    IDE_TEST( validateIndexAlterationForPartition( aStatement,
                                                   sTableInfo,
                                                   sTableInfo,
                                                   sDstPartAttr )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // ε Ƽ   validation
    // ------------------------------------------------------

    if ( sDstPartAttr->alterPart->indexPartAttr != NULL )
    {
        IDE_TEST( checkIndexPartAttrList( aStatement,
                                          sTableInfo,
                                          NULL, /* sSrcPartInfo */
                                          NULL, /* sSrcPartAttr */
                                          sDstPartAttr,
                                          sParseTree->userID )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_ADD_PARTITION_ON_NONE_HASH_PART_TABLE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ADD_PARTITION_ON_NONE_HASH_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_ALREADY_EXIST_PARTITION_NAME)
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_ALREADY_EXIST_PARTITION_NAME,
                                 sqlInfo.getErrMessage()) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_ACCESS_NOT_SUPPORT_MVIEW );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDM_ACCESS_NOT_SUPPORT_MVIEW ) );
    }
#ifdef ALTI_CFG_EDITION_DISK
    IDE_EXCEPTION( ERR_NOT_SUPPORT_MEMORY_VOLATILE_TABLESPACE_IN_DISK_EDITION );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_USE_ONLY_DISK_TABLE_PARTITION_IN_DISK_EDITION ) );
    }
#endif
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateCoalescePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qcmTableInfo            * sPartInfo;
    qcmPartitionInfoList    * sPartInfoList = NULL;
    qcmPartitionInfoList    * sTempPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    UInt                      sTotalPartCount = 0;
    UInt                      sPartOrder = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement, SDI_DDL_TYPE_TABLE ) != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType
                    == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    // ------------------------------------------------------
    // ؽ Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->partitionMethod != QCM_PARTITION_METHOD_HASH,
                    ERR_COALESCE_PARTITION_ON_NONE_HASH_PART_TABLE );

    // ------------------------------------------------------------
    // Ƽ , Handle, SCN Ʈ ؼ ĽƮ ޾Ƴ´.
    // ------------------------------------------------------------

    //  Ƽǿ LOCK(IS)
    // Ƽ Ʈ ĽƮ ޾Ƴ´.
    IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                  aStatement,
                  sParseTree->tableInfo->tableID,
                  & (sParseTree->partTable->partInfoList) )
              != IDE_SUCCESS );

    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::makeAndLockIndexTableList(
                  aStatement,
                  ID_FALSE,
                  sParseTree->tableInfo,
                  &(sParseTree->oldIndexTables) )
              != IDE_SUCCESS );
    
    sPartInfoList = sParseTree->partTable->partInfoList;

    // ------------------------------------------------------
    //  Ƽ  1 üũ
    // ------------------------------------------------------
    IDE_TEST( qcmPartition::getPartitionCount( aStatement,
                                               sTableInfo->tableID,
                                               & sTotalPartCount )
              != IDE_SUCCESS );

    IDE_TEST_RAISE( sTotalPartCount < 2,
                    ERR_COALESCE_THE_ONLY_PARTITION);

    IDU_LIMITPOINT("qdbAlter::validateCoalescePartition::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_COUNT(QC_QMP_MEM(aStatement),
                                     qcmPartitionInfoList,
                                     sTotalPartCount,
                                     & sNewPartInfoList)
             != IDE_SUCCESS);

    // ------------------------------------------------------
    // PartInfoList PartOrder  Ѵ.
    // ------------------------------------------------------
    for( sTempPartInfoList = sPartInfoList;
         sTempPartInfoList != NULL;
         sTempPartInfoList = sTempPartInfoList->next )
    {
        sPartInfo = sTempPartInfoList->partitionInfo;

        // get Partition Order
        IDE_TEST( qcmPartition::getPartitionOrder( QC_SMI_STMT( aStatement ),
                                                   sTableInfo->tableID,
                                                   (UChar *) sPartInfo->name,
                                                   idlOS::strlen(sPartInfo->name),
                                                   & sPartOrder )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                  sTableInfo->tableID,
                                                  (UChar *)sTempPartInfoList->partitionInfo->name,
                                                  idlOS::strlen(sTempPartInfoList->partitionInfo->name),
                                                  & sNewPartInfoList[sPartOrder].partitionInfo,
                                                  & sNewPartInfoList[sPartOrder].partSCN,
                                                  & sNewPartInfoList[sPartOrder].partHandle )
                  != IDE_SUCCESS );

        sNewPartInfoList[sPartOrder].next = NULL;
    }

    for( sPartOrder = 0;
         sPartOrder < sTotalPartCount;
         sPartOrder++ )
    {
        if( sPartOrder == (sTotalPartCount - 1) )
        {
            sNewPartInfoList[sPartOrder].next = NULL;
        }
        else
        {
            sNewPartInfoList[sPartOrder].next = & sNewPartInfoList[sPartOrder+1];
        }
    }

    sParseTree->partTable->partInfoList = sNewPartInfoList;

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_COALESCE_PARTITION_ON_NONE_HASH_PART_TABLE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_COALESCE_PARTITION_ON_NONE_HASH_PART_TABLE));
    }
    IDE_EXCEPTION(ERR_COALESCE_THE_ONLY_PARTITION)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_COALESCE_THE_ONLY_PARTITION));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAccessPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-2359 Table/Partition Access Option
 *
 *    ALTER TABLE table ACCESS PARTITION partition READ { ONLY | WRITE | APPEND };
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qcmTableInfo            * sPartInfo;
    qdPartitionAttribute    * sPartAttr;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // ------------------------------------------------------
    // 1. ALTER TABLE   validation
    // ------------------------------------------------------
    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* BUG-48290 shard object  DDL  */
    IDE_TEST( sdi::checkShardObjectForDDL( aStatement,
                                           SDI_DDL_TYPE_TABLE_PARTITION,
                                           ID_TRUE, /* aIsGlobalDDLAllowedOnNonShardObject */
                                           ID_TRUE  /* aIsGlobalDDLAllowedOnShardObj */ )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // ------------------------------------------------------
    // 2. Ƽǵ ̺ üũ
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tablePartitionType == QCM_NONE_PARTITIONED_TABLE,
                    ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE );

    sPartAttr = sParseTree->partTable->partAttr;

    // ------------------------------------------------------
    // 3. ACCESS  ̺ Ÿ ˻
    // ------------------------------------------------------
    IDE_TEST_RAISE( sTableInfo->tableType == QCM_MVIEW_TABLE,
                    ERR_ACCESS_NOT_SUPPORT_MVIEW );

    // ------------------------------------------------------
    // 4. Ƽ ̸ validation
    // ------------------------------------------------------
    IDE_TEST( qdbCommon::checkPartitionInfo( aStatement,
                                             sTableInfo,
                                             sPartAttr->tablePartName )
              != IDE_SUCCESS );

    // ------------------------------------------------------
    // 5. ̹  ACCESS ϴ ˻
    // ------------------------------------------------------
    sPartInfo = sParseTree->partTable->partInfoList->partitionInfo;
    if ( sPartInfo->accessOption == sPartAttr->accessOption )
    {
        sParseTree->common.execute = qcc::execute;
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sPartInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_TRUE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            1,
                            &(sPartInfo->tableOID) );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_TABLE_PARTITION_ON_NONE_PART_TABLE ) );
    }
    IDE_EXCEPTION( ERR_ACCESS_NOT_SUPPORT_MVIEW );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDM_ACCESS_NOT_SUPPORT_MVIEW ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateAlterCommon( qcStatement * aStatement,
                                      idBool        aIsRepCheck )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE   validation
 *
 * Implementation :
 *    1.  ü   üũ
 *    2. ̺   üũ
 *    3. ̺ ڰ SYSTEM_ ̸ alter Ұ
 *    4. alter table  ִ üũ
 *    5. ̺ ȭ ɷ 
 *
 ***********************************************************************/

    qdTableParseTree    * sParseTree;
    qcuSqlSourceInfo      sqlInfo;
    
    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* BUG-30059 */
    if ( qdbCommon::containDollarInName( &(sParseTree->tableName) ) == ID_TRUE )
    {
        sqlInfo.setSourceInfo(
            aStatement,
            &(sParseTree->tableName) );

        IDE_RAISE( CANT_USE_RESERVED_WORD );
    }

    // check table exist.
    IDE_TEST( qdbCommon::checkTableInfo( aStatement,
                                         sParseTree->userName,
                                         sParseTree->tableName,
                                         &(sParseTree->userID),
                                         &(sParseTree->tableInfo),
                                         &(sParseTree->tableHandle),
                                         &(sParseTree->tableSCN))
              != IDE_SUCCESS);

    // Ƽǵ ̺ LOCK(IS)
    IDE_TEST( qcm::lockTableForDDLValidation(aStatement,
                                             sParseTree->tableHandle,
                                             sParseTree->tableSCN)
              != IDE_SUCCESS );

    if ( QCG_GET_SESSION_USER_ID(aStatement) != QC_SYSTEM_USER_ID )
    {
        // sParseTree->userID is a owner of table
        IDE_TEST_RAISE(sParseTree->userID == QC_SYSTEM_USER_ID,
                       ERR_NOT_ALTER_META);
    }
    else
    {
        if ( ( aStatement->session->mQPSpecific.mFlag
               & QC_SESSION_ALTER_META_MASK )
             == QC_SESSION_ALTER_META_DISABLE )
        {
            /* PROJ-2677 DDL synchronization */
            if ( qrc::isInternalDDL( aStatement ) != ID_TRUE ) 
            {
                IDE_RAISE(ERR_NOT_ALTER_META);
            }
            else
            {
                // Nothing to do
            }
        }
        else
        {
            // Nothing to do
        }
    }

    // PR-13725
    // CHECK OPERATABLE
    IDE_TEST( qdbAlter::checkOperatable( aStatement,
                                         sParseTree->tableInfo )
              != IDE_SUCCESS );
    
    /* PROJ-1090 Function-based Index */
    if ( sParseTree->addHiddenColumn != ID_TRUE )
    {
        // check grant
        IDE_TEST( qdpRole::checkDDLAlterTablePriv( aStatement,
                                                   sParseTree->tableInfo )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    // if specified tables is replicated, the error
    // fix BUG-19011
    if ( aIsRepCheck == ID_TRUE )
    {
        IDE_TEST_RAISE( sParseTree->tableInfo->replicationCount > 0,
                        ERR_DDL_WITH_REPLICATED_TABLE );
        //proj-1608:replicationCount 0  recovery count ׻ 0̾ 
        IDE_DASSERT( sParseTree->tableInfo->replicationRecoveryCount == 0 );
    }
    else
    {
        // Nothing to do
    }

    /* PROJ-1723 [MDW/INTEGRATOR] Altibase Plugin 
       DDL Statement Text α
    */
    if (QCU_DDL_SUPPLEMENTAL_LOG == 1)
    {
        IDE_TEST( qciMisc::writeDDLStmtTextLog( aStatement,
                                                sParseTree->tableInfo->tableOwnerID,
                                                sParseTree->tableInfo->name )
                  != IDE_SUCCESS );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_TBL ) );
    }
    IDE_EXCEPTION(ERR_NOT_ALTER_META);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDD_NO_DROP_META_TABLE));
    }
    IDE_EXCEPTION( CANT_USE_RESERVED_WORD );
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(
            ideSetErrorCode(qpERR_ABORT_QDB_RESERVED_WORD_IN_OBJECT_NAME,
                            sqlInfo.getErrMessage() ));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAddColByRecreateTable(
    qcStatement           * aStatement,          // in
    qdTableParseTree      * aParseTree,          // in
    idBool                  aIsPartitioned,      // in
    UInt                    aPartitionCount,     // in
    UInt                  * aPartitionID,        // in
    UInt                    aNewColCnt,          // in
    qcmColumn             * aNewTableColumn,     // in
    qcmColumn            ** aNewPartitionColumn, // in
    smOID                 * aNewTableOID,        // out
    smOID                ** aNewPartitionOID,    // out
    qcmTableInfo         ** aNewTableInfo,       // out
    qcmPartitionInfoList ** aNewPartInfoList )   // out
{
/***********************************************************************
 *
 * Description :
 *    ADD COL Ͽ Recreate Table
 *
 * Implementation :
 *
 *    1. ߰Ǵ ε  ο  
 *    2. ο Table 
 *    3. Meta  column spec 
 *    4. Meta ο column spec 
 *    5. ο Table constraint  
 *    6. ο Table index  
 *    7. Meta Cache  
 *    8. ο Column  constraint index 
 *    9.  table record ο table move
 *    10. not null constraint 
 *    11. Meta Cache  
 *
 ************************************************************************/

    UInt                      sTableID;
    qcmIndex                * sNewTableIndex = NULL;
    qcmIndex               ** sNewPartIndex  = NULL;
    UInt                      sNewPartIndexCount = 0;
    qcmPartitionInfoList    * sCurPartInfoList  = NULL;
    qcmTableInfo            * sPartInfo  = NULL;
    smOID                     sNewTableOID;
    smOID                   * sNewPartitionOID  = NULL;
    void                   ** sOldPartitionHandle  = NULL;
    qmsTableRef             * sOldTableRef = NULL;
    qcmTableInfo            * sOldTableInfo  = NULL;
    qcmTableInfo            * sNewTableInfo  = NULL;
    qcmTableInfo           ** sNewPartitionInfoArr  = NULL;
    qcmPartitionInfoList    * sOldPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    qdConstraintSpec        * sConstraint = NULL;
    qcmColumn               * sNewColumnAdded = NULL;
    qcmPartitionInfoList    * sSrcPartInfoList = NULL;
    qcmPartitionInfoList    * sDstPartInfoList = NULL;
    qcmTableInfo            * sSrcPartInfo = NULL;
    qcmTableInfo            * sDstPartInfo = NULL;
    smSCN                     sSCN;
    void                    * sOldTableHandle = NULL;
    void                    * sNewTableHandle = NULL;
    qdIndexTableList        * sIndexTable;
    UInt                      i;

    smiSegAttr                sSegAttr;
    smiSegStorageAttr         sSegStoAttr;
    UInt                      sPartType = 0;

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    SInt                  sCountDiskType = 0;
    SInt                  sCountMemType  = 0;
    SInt                  sCountVolType  = 0;
    UInt                  sTableType     = 0;

    //-----------------
    //   ʱȭ
    //-----------------

    sTableID             = aParseTree->tableInfo->tableID;
    sOldTableInfo        = aParseTree->tableInfo;
    sOldPartInfoList     = aParseTree->partTable->partInfoList;
    sOldTableHandle      = sOldTableInfo->tableHandle;

    //-----------------------------------------------------
    // ο Index     Ҵ
    //-----------------------------------------------------

    if (sOldTableInfo->indexCount > 0)
    {
        IDU_FIT_POINT( "qdbAlter::executeAddColByRecreateTable::alloc::sNewTableIndex",
                        idERR_ABORT_InsufficientMemory );

        // for non-partitioned, partitioned index
        IDE_TEST(aStatement->qmxMem->alloc(
                ID_SIZEOF(qcmIndex) * sOldTableInfo->indexCount,
                (void**)&sNewTableIndex)
            != IDE_SUCCESS);

        idlOS::memcpy(sNewTableIndex,
                      sOldTableInfo->indices,
                      ID_SIZEOF(qcmIndex) * sOldTableInfo->indexCount);

        // for index partition
        // fix BUG-18706
        if( aIsPartitioned == ID_TRUE )
        {
            IDU_LIMITPOINT("qdbAlter::executeAddColByRecreateTable::malloc2");
            IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmIndex*) *
                                               aPartitionCount,
                                               (void**)& sNewPartIndex)
                     != IDE_SUCCESS);

            for( sCurPartInfoList = sOldPartInfoList, i = 0;
                 sCurPartInfoList != NULL;
                 sCurPartInfoList = sCurPartInfoList->next, i++ )
            {
                sPartInfo = sCurPartInfoList->partitionInfo;

                if ( sPartInfo->indexCount > 0 )
                {
                    IDU_LIMITPOINT("qdbAlter::executeAddColByRecreateTable::malloc3");
                    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmIndex) *
                                                       sPartInfo->indexCount,
                                                       (void**)&sNewPartIndex[i])
                             != IDE_SUCCESS);
                    
                    if ( sNewPartIndexCount == 0 )
                    {
                        sNewPartIndexCount = sPartInfo->indexCount;
                    }
                    else
                    {
                        IDE_DASSERT( sNewPartIndexCount == sPartInfo->indexCount );
                    }
                    
                    idlOS::memcpy( sNewPartIndex[i],
                                   sPartInfo->indices,
                                   ID_SIZEOF(qcmIndex) * sPartInfo->indexCount );
                }
                else
                {
                    //  non-partitioned index  
                    sNewPartIndex[i] = NULL;
                }
            }
        }
        else
        {
            // Nothing to do
        }
    }
    else
    {
        // Nothing to do
    }

    //-----------------------------------------------------
    // ο table 
    //-----------------------------------------------------

    //-------------------
    // create "new" table.
    //-------------------
    IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                        aNewTableColumn,
                                        sOldTableInfo->tableOwnerID,
                                        sTableID,
                                        sOldTableInfo->maxrows,
                                        sOldTableInfo->TBSID,
                                        sOldTableInfo->segAttr,
                                        sOldTableInfo->segStoAttr,
                                        /*  Table Flag °  =>
                                           MASK Ʈ   1  */
                                        QDB_TABLE_ATTR_MASK_ALL,
                                        sOldTableInfo->tableFlag, /* Flag Value */
                                        sOldTableInfo->parallelDegree,
                                        &sNewTableOID)
             != IDE_SUCCESS);

    // BUG-44814 ddl    縦 ؾ
    smiStatistics::copyTableStats( smiGetTable(sNewTableOID), sOldTableHandle, NULL, 0 );

    // update table spec (tableOID).
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 aParseTree->userName,
                 aParseTree->tableName,
                 sTableID,
                 sNewTableOID,
                 sOldTableInfo->columnCount + aNewColCnt,
                 sOldTableInfo->parallelDegree )
             != IDE_SUCCESS);

    //-------------------
    // create "new" partition
    //-------------------
    if( aIsPartitioned == ID_TRUE )
    {
        IDU_LIMITPOINT("qdbAlter::executeAddColByRecreateTable::malloc4");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(void*) * aPartitionCount,
                                           (void**)&sOldPartitionHandle)
                 != IDE_SUCCESS);

        IDU_LIMITPOINT("qdbAlter::executeAddColByRecreateTable::malloc5");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smOID) * aPartitionCount,
                                           (void**)&sNewPartitionOID)
                 != IDE_SUCCESS);


        // ̺ Ƽ ŭ ݺ
        for( sCurPartInfoList = sOldPartInfoList, i = 0 ;
             sCurPartInfoList != NULL;
             sCurPartInfoList = sCurPartInfoList->next,i++)
        {
            sPartInfo              = sCurPartInfoList->partitionInfo;
            sOldPartitionHandle[i] = sPartInfo->tableHandle;
            sPartType              = sPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

            /* MASK-2464 hybrid partitioned table 
             *  - Partition Info  , Table Option Partitioned Table  Ѵ.
             *  - , PartInfo  ̿ ʰ, TBSID    ؼ ̿Ѵ.
             */
            qdbCommon::adjustPhysicalAttr( sPartType,
                                           sOldTableInfo->segAttr,
                                           sOldTableInfo->segStoAttr,
                                           & sSegAttr,
                                           & sSegStoAttr,
                                           ID_TRUE /* aIsTable */ );

            IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                                aNewPartitionColumn[i],
                                                sOldTableInfo->tableOwnerID,
                                                sTableID,
                                                sOldTableInfo->maxrows,
                                                sPartInfo->TBSID,
                                                sSegAttr,
                                                sSegStoAttr,
                                                /*  Table Flag
                                                   °  */
                                                QDB_TABLE_ATTR_MASK_ALL,
                                                sOldTableInfo->tableFlag, /* Flag Value */
                                                sOldTableInfo->parallelDegree,
                                                &sNewPartitionOID[i])
                     != IDE_SUCCESS);

            // BUG-44814 ddl    縦 ؾ
            smiStatistics::copyTableStats( smiGetTable(sNewPartitionOID[i]), sPartInfo->tableHandle, NULL, 0 );

            IDE_TEST(qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                             sTableID,
                                                             aPartitionID[i],
                                                             sNewPartitionOID[i] )
                     != IDE_SUCCESS );
        }
    }

    //-----------------------------------------------------
    // Meta  column spec 
    //-----------------------------------------------------

    // delete invalidated column spec from meta.
    IDE_TEST(deleteColumnSpecFromMeta(aStatement, sTableID)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        IDE_TEST(deletePartKeyColumnSpecFromMeta(aStatement,
                                                 sTableID,
                                                 QCM_TABLE_OBJECT_TYPE)
                 != IDE_SUCCESS);

        IDE_TEST(deletePartLobSpecFromMeta(aStatement, sTableID)
                 != IDE_SUCCESS);
    }

    // SYSTME User SYS_CONSTRAINTS_ Table ϶ Constraint  нѴ.
    if ( ( idlOS::strMatch( QCM_CONSTRAINTS,
                            idlOS::strlen( QCM_CONSTRAINTS ),
                            sOldTableInfo->name,
                            idlOS::strlen( sOldTableInfo->name ) ) != 0 ) ||
         ( sOldTableInfo->tableOwnerID != QC_SYSTEM_USER_ID ) )
    {
        IDE_TEST(qdd::deleteConstraintsFromMeta(aStatement, sTableID)
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do.
    }

    IDE_TEST(deleteIndexSpecFromMeta(aStatement, sTableID)
             != IDE_SUCCESS);


    //-----------------------------------------------------
    // Meta ο column spec 
    //-----------------------------------------------------

    // insert new column spec into meta.
    IDE_TEST(qdbCommon::insertColumnSpecIntoMeta(aStatement,
                                                 aParseTree->userID,
                                                 sTableID,
                                                 aNewTableColumn,
                                                 ID_FALSE /* is queue */)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        IDE_TEST(qdbCommon::insertPartKeyColumnSpecIntoMeta(
                     aStatement,
                     aParseTree->userID,
                     sTableID,
                     aNewTableColumn,
                     sOldTableInfo->partKeyColumns,
                     QCM_TABLE_OBJECT_TYPE)
                 != IDE_SUCCESS);

        for( i = 0; i < aPartitionCount; i++ )
        {
            IDE_TEST(qdbCommon::insertPartLobSpecIntoMeta(
                         aStatement,
                         aParseTree->userID,
                         sTableID,
                         aPartitionID[i],
                         aNewPartitionColumn[i])
                     != IDE_SUCCESS);
        }
    }

    //-----------------------------------------------------
    // ο table constraint index   ,
    // Meta Cache 籸
    //-----------------------------------------------------

    // PROJ-1624 non-partitioned index
    // index table createIndex ٽ ǹǷ meta  ̸ .
    if( aIsPartitioned == ID_TRUE )
    {
        for ( sIndexTable = aParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            IDE_TEST( qdx::dropIndexTable( aStatement,
                                           sIndexTable,
                                           ID_FALSE /* aIsDropTablespace */ )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        // Nothing to do.
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    sTableType = sOldTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* - Partition  ˻Ѵ. */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                sOldPartInfoList,
                                                & sCountDiskType,
                                                & sCountMemType,
                                                & sCountVolType );

    /* - Memory ü ְų, Index Table ִٸ, Index  Ѵ. */
    if ( ( ( sCountMemType + sCountVolType ) > 0 ) ||
         ( aParseTree->oldIndexTables != NULL ) )
    {
        IDE_TEST( qdbCommon::createConstraintFromInfo( aStatement,
                                                       sOldTableInfo,
                                                       sNewTableOID,
                                                       aPartitionCount,
                                                       sNewPartitionOID,
                                                       SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                       sNewTableIndex,
                                                       sNewPartIndex,
                                                       sNewPartIndexCount,
                                                       aParseTree->oldIndexTables,
                                                       &( aParseTree->newIndexTables ),
                                                       NULL )
                  != IDE_SUCCESS );

        IDE_TEST( qdbCommon::createIndexFromInfo( aStatement,
                                                  sOldTableInfo,
                                                  sNewTableOID,
                                                  aPartitionCount,
                                                  sNewPartitionOID,
                                                  SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                  sNewTableIndex,
                                                  sNewPartIndex,
                                                  sNewPartIndexCount,
                                                  aParseTree->oldIndexTables,
                                                  &( aParseTree->newIndexTables ),
                                                  NULL,
                                                  ID_TRUE )
                  != IDE_SUCCESS );

        /* PROJ-1624 global non-partitioned index
         *  - Index Meta Index Table Id Ѵ.
         */
        if ( aIsPartitioned == ID_TRUE )
        {
            for ( i = 0;
                  i < sOldTableInfo->indexCount;
                  i++ )
            {
                if ( ( sOldTableInfo->indices[i].indexPartitionType == QCM_NONE_PARTITIONED_INDEX ) &&
                     ( sOldTableInfo->indices[i].indexTableID != sNewTableIndex[i].indexTableID ) )
                {
                    IDE_TEST( qdx::updateIndexSpecFromMeta( aStatement,
                                                            sOldTableInfo->indices[i].indexId,
                                                            sNewTableIndex[i].indexTableID )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing to do */
                }
            }
        }
        else
        {
            /* Nothing to do */
        }
    }
    else
    {
        /* Nothing to do */
    }
    
    // Meta Cache( Table Header  qcmTableInfo ) 籸
    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sNewTableOID ) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sNewTableHandle)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        // ο qcmPartitionInfo pointer  迭 
        IDU_LIMITPOINT("qdbAlter::executeAddColByRecreateTable::malloc6");
        IDE_TEST( aStatement->qmxMem->cralloc(
                      ID_SIZEOF(qcmTableInfo*) * aPartitionCount,
                      (void**) & sNewPartitionInfoArr )
                  != IDE_SUCCESS);

        for( i = 0; i < aPartitionCount; i++ )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT(aStatement),
                          aPartitionID[i],
                          sNewPartitionOID[i],
                          sNewTableInfo )
                      != IDE_SUCCESS );

            IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i]),
                                           (void**)&sNewPartitionInfoArr[i] )
                != IDE_SUCCESS );
        }

        IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                      QC_SMI_STMT(aStatement),
                                                      aStatement->qmxMem,
                                                      sTableID,
                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sNewPartInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }

    //-----------------------------------------------------
    // ο column  constraint index ϰ,
    //  table record ο table moveϰ,
    //  VIEW Invalidate Ų ,
    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    //-----------------------------------------------------

    // create constraint on new column.
    for (sConstraint = aParseTree->constraints;
         sConstraint != NULL;
         sConstraint = sConstraint->next)
    {
        sNewColumnAdded = aNewTableColumn;
        while (sNewColumnAdded != NULL)
        {
            if ( QC_IS_NAME_MATCHED( sNewColumnAdded->namePos, sConstraint->constraintColumns->namePos ) )
            {
                break;
            }
            else
            {
                sNewColumnAdded = sNewColumnAdded->next;
            }
        }
        IDE_ASSERT( sNewColumnAdded != NULL );

        sConstraint->constraintColumns->basicInfo = sNewColumnAdded->basicInfo;

        IDE_TEST(qdbCommon::createConstrPrimaryUnique(
                     aStatement,
                     sNewTableOID,
                     sConstraint,
                     aParseTree->userID,
                     sTableID,
                     sNewPartInfoList,
                     sOldTableInfo->maxrows )
                 != IDE_SUCCESS);

        IDE_TEST(qdbCommon::createConstrNotNull(aStatement,
                                                sConstraint,
                                                aParseTree->userID,
                                                sTableID)
                 != IDE_SUCCESS);

        IDE_TEST(qdbCommon::createConstrTimeStamp(aStatement,
                                                  sConstraint,
                                                  aParseTree->userID,
                                                  sTableID)
                 != IDE_SUCCESS);
    }

    // create constraint on new column.
    for (sConstraint = aParseTree->constraints;
         sConstraint != NULL;
         sConstraint = sConstraint->next)
    {
        IDE_TEST(qdbCommon::createConstrForeign(aStatement,
                                                sConstraint,
                                                aParseTree->userID,
                                                sTableID)
                 != IDE_SUCCESS);
    }

    /* PROJ-1090 Function-based Index */
    if ( aParseTree->addHiddenColumn == ID_TRUE )
    {
        IDE_TEST( qdbCommon::createIndexFromIndexParseTree(
                      aStatement,
                      aParseTree->createIndexParseTree,
                      sNewTableOID,
                      sNewTableInfo,
                      sTableID,
                      sNewPartInfoList )
                  != IDE_SUCCESS );

        sOldTableRef = aParseTree->createIndexParseTree->
            defaultExprFrom->tableRef;
    }
    else
    {
        // Nothing to do.
    }
    
    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    (void)qcm::destroyQcmTableInfo(sNewTableInfo);
    sNewTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT( aStatement ),
                                         sTableID,
                                         sNewTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sNewTableHandle)
             != IDE_SUCCESS);

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sNewTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );
    
    // BUG-15936
    // copy new mtcColumn
    IDE_TEST( copyColInfo(aNewTableColumn, sNewTableInfo->columns)
              != IDE_SUCCESS );

    //-----------------------------------------------------
    //  table record ο table move
    //-----------------------------------------------------

    /* BUG-20992: TC/Server/sm4/PRJ-1548/dynmem/../suites/conc_disk/dt_dt.sql 
     *
     * : Disk Table ؼ Alter Table Add, Drop Table ϰ Record
     * Insertϴٰ   Alter  Table Memory Refine Free Insert
     *  Record ؼ Disk Ager Startup Ŀ  Ѵ.   Disk Ager
     *  Table Drop Ǿ  Skip ϴµ   Free Table Ҵ 
     * Disk Ager Free Record մϴ. ᱹ ̹  Table ؼ Free ϰ
     * ˴ϴ.
     *
     * ذ: ̷  ϱ ؼ ¥ Alter ϸ  Table Drop 
     *   Undo Log  ν Ager Record Freeϴ   մϴ.
     * moverowÿ undo log ϵ ʵ մϴ. ׷  ̷ ϴٺ Index
     * Key Insert ʴ  ֽϴ. ֳĸ Index Key Insert insert  
     * table ڵ带 Insert Insert  Cursor Closeÿ Insert Undo Record
     * о Table Record Insertմϴ. ׷ Insert Undo Record ϵ ʾұ 
     *  Insert  ʾƼ Alterÿ moverows    Index Key Insertϴ
     *  Logic Ͽϴ.
     *
     * : Alter Table Add Column  ο Table ϰ Insertÿ ο Table
     * Record Ŀ Index ؾ մϴ.
     * */

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        sSrcPartInfoList = sOldPartInfoList;
        sDstPartInfoList = sNewPartInfoList;

        for( i = 0; i < aPartitionCount; i++ )
        {
            // move row from old to new.
            // drop old table partitions
            sSrcPartInfo = sSrcPartInfoList->partitionInfo;
            sDstPartInfo = sDstPartInfoList->partitionInfo;

            IDE_TEST( copyColInfo(aNewPartitionColumn[i],
                                  sDstPartInfo->columns)
                      != IDE_SUCCESS );

            IDE_TEST(moveRow(aStatement,
                             sOldTableRef,
                             sOldTableInfo,
                             sOldPartitionHandle[i],
                             smiGetTable( sNewPartitionOID[i] ),
                             sSrcPartInfo->columns,
                             aNewPartitionColumn[i],
                             sNewTableInfo,
                             aParseTree->newIndexTables,
                             ID_FALSE /* No Undo Logging */)
                     != IDE_SUCCESS);

            sSrcPartInfoList = sSrcPartInfoList->next;
            sDstPartInfoList = sDstPartInfoList->next;
        }
        // drop old partitioned table
        IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                       sOldTableHandle,
                                       SMI_TBSLV_DDL_DML )
                  != IDE_SUCCESS);
    }
    else
    {
        // move row from old to new.
        // drop old non-partitioned table
        IDE_TEST(moveRow(aStatement,
                         sOldTableRef,
                         sOldTableInfo,
                         sOldTableHandle,
                         smiGetTable( sNewTableOID),
                         sOldTableInfo->columns,
                         aNewTableColumn,
                         NULL,
                         NULL,
                         ID_FALSE /* No Undo Logging */)
                 != IDE_SUCCESS);
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT   
     *  - Memory ü , Index Table ٸ, Index  Ѵ.
     */
    if ( ( ( sCountMemType + sCountVolType ) == 0 ) &&
         ( aParseTree->oldIndexTables == NULL ) )
    {
        IDE_TEST( qdbCommon::createConstraintFromInfo( aStatement,
                                                       sOldTableInfo,
                                                       sNewTableOID,
                                                       aPartitionCount,
                                                       sNewPartitionOID,
                                                       SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                       sNewTableIndex,
                                                       sNewPartIndex,
                                                       sNewPartIndexCount,
                                                       aParseTree->oldIndexTables,
                                                       &( aParseTree->newIndexTables ),
                                                       NULL )
                  != IDE_SUCCESS );

        IDE_TEST( qdbCommon::createIndexFromInfo( aStatement,
                                                  sOldTableInfo,
                                                  sNewTableOID,
                                                  aPartitionCount,
                                                  sNewPartitionOID,
                                                  SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                  sNewTableIndex,
                                                  sNewPartIndex,
                                                  sNewPartIndexCount,
                                                  aParseTree->oldIndexTables,
                                                  &( aParseTree->newIndexTables ),
                                                  NULL,
                                                  ID_TRUE )
                  != IDE_SUCCESS );

        /* PROJ-1624 global non-partitioned index
         *  - Index Meta Index Table Id Ѵ.
         */
        if ( aIsPartitioned == ID_TRUE )
        {
            for ( i = 0;
                  i < sOldTableInfo->indexCount;
                  i++ )
            {
                if ( ( sOldTableInfo->indices[i].indexPartitionType == QCM_NONE_PARTITIONED_INDEX ) &&
                     ( sOldTableInfo->indices[i].indexTableID != sNewTableIndex[i].indexTableID ) )
                {
                    IDE_TEST( qdx::updateIndexSpecFromMeta( aStatement,
                                                            sOldTableInfo->indices[i].indexId,
                                                            sNewTableIndex[i].indexTableID )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing to do */
                }
            }
        }
        else
        {
            /* Nothing to do */
        }

        IDU_FIT_POINT( "qdbAlter::executeAddColByRecreateTable::BUG-44230" );
    }
    else
    {
        /* Nothing to do */
    }

    //  VIEW Invalidate
    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 aParseTree->userID,
                 sOldTableInfo->name,
                 idlOS::strlen((SChar*)sOldTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    (void)qcm::destroyQcmTableInfo(sNewTableInfo);
    sNewTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT( aStatement ),
                                         sTableID,
                                         sNewTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sNewTableHandle)
             != IDE_SUCCESS);

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sNewTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    //-----------------------------------------------------
    //  not null constraint  ,
    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    //-----------------------------------------------------

    if (sNewTableInfo->primaryKey != NULL)
    {
        for ( i = 0; i < sNewTableInfo->primaryKey->keyColCount; i++)
        {
            IDE_TEST(qdbCommon::makeColumnNotNull(
                         aStatement,
                         sNewTableHandle,
                         sNewTableInfo->maxrows,
                         sNewPartInfoList,
                         aIsPartitioned,
                         sNewTableInfo->primaryKey->keyColumns[i].column.id)
                     != IDE_SUCCESS);
        }
    }

    (void)qcm::destroyQcmTableInfo(sNewTableInfo);
    sNewTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT( aStatement ),
                                         sTableID,
                                         sNewTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sNewTableHandle)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        for( sCurPartInfoList = sNewPartInfoList, i = 0;
             sCurPartInfoList != NULL;
             sCurPartInfoList = sCurPartInfoList->next, i++ )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          aPartitionID[i],
                          sNewPartitionOID[i],
                          sNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i] ),
                                           (void**)&sCurPartInfoList->partitionInfo )
                      != IDE_SUCCESS );

            (void)qcmPartition::destroyQcmPartitionInfo(sNewPartitionInfoArr[i]);
            sNewPartitionInfoArr[i] = sCurPartInfoList->partitionInfo;
        }

        IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                      QC_SMI_STMT(aStatement),
                                                      aStatement->qmxMem,
                                                      sTableID,
                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sNewTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    //-----------------------------------------------------
    //   Table Partition OID ȯ
    //-----------------------------------------------------

    *aNewTableOID     = sNewTableOID;
    *aNewPartitionOID = sNewPartitionOID;
    *aNewTableInfo    = sNewTableInfo;
    *aNewPartInfoList = sNewPartInfoList;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    // cleanup new table info
    if( aIsPartitioned == ID_TRUE )
    {
        if ( sNewPartitionInfoArr != NULL )
        {
            for ( i = 0; i < aPartitionCount; i++ )
            {
                (void)qcmPartition::destroyQcmPartitionInfo( sNewPartitionInfoArr[i] );
            }
        }
        
        for ( sIndexTable = aParseTree->newIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
        }
    }

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAddColByAlterMeta(
    qcStatement           * aStatement,              // in
    qdTableParseTree      * aParseTree,              // in
    idBool                  aIsPartitioned,          // in
    UInt                    aPartitionCount,         // in
    UInt                  * aPartitionID,            // in
    UInt                    aNewColCnt,              // in
    qcmColumn             * aNewTableColumn,         // in
    mtcColumn             * aNewTableMtcColumn,      // in
    qcmColumn            ** aNewPartitionColumn,     // in
    mtcColumn            ** aNewPartitionMtcColumn,  // in
    qcmTableInfo         ** aNewTableInfo,           // out
    qcmPartitionInfoList ** aNewPartInfoList )       // out
{
/***********************************************************************
 *
 * Description :
 *    ADD COL Meta    ( column   )
 *
 * Implementation :
 *    1. Table Header/Partition Header column list 
 *    2  SYS_TABLES_  ش table column count 
 *    3  SYS_COLUMNS_  ߰ column  ߰
 *    4  ο column  constraint 
 *    5. Meta Cache( Table Header  qcmTableInfo ) 籸
 *
 ***********************************************************************/

    UInt                      sTableID;
    smOID                     sTableOID;
    qcmTableInfo            * sOldTableInfo = NULL;
    qcmTableInfo            * sNewTableInfo = NULL;
    void                    * sTableHandle = NULL;
    void                    * sNewTableHandle = NULL;
    smSCN                     sSCN;
    qcmPartitionInfoList    * sOldPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    qcmPartitionInfoList    * sPartInfoList    = NULL;

    //-----------------
    //   ʱȭ
    //-----------------

    sOldTableInfo           = aParseTree->tableInfo;
    sTableID                = sOldTableInfo->tableID;
    sTableHandle            = aParseTree->tableHandle;
    sTableOID               = smiGetTableId(sTableHandle);
    sOldPartInfoList        = aParseTree->partTable->partInfoList;

    //-----------------------------------------------------
    // column   (    Ʒ  )
    // (1) Table Header / Partition Header column list 
    // (2) SYS_TABLES_ ش table column count 
    // (3) SYS_COLUMNS_ ߰ column  insert
    // (4) ο column  constraint 
    //-----------------------------------------------------

    IDE_TEST( alterColumnInfo4AddCol( aStatement,
                                      aParseTree,
                                      aNewColCnt,
                                      aIsPartitioned,
                                      aPartitionCount,
                                      aPartitionID,
                                      aNewTableColumn,
                                      aNewTableMtcColumn,
                                      aNewPartitionColumn,
                                      aNewPartitionMtcColumn )
              != IDE_SUCCESS );

    //-----------------------------------------------------
    // Meta Cache( Table Header  qcmTableInfo ) 籸
    //-----------------------------------------------------

    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sTableOID )
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID( aStatement,
                                    sTableID,
                                    &sNewTableInfo,
                                    &sSCN,
                                    &sNewTableHandle )
             != IDE_SUCCESS);

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sNewTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aIsPartitioned == ID_TRUE )
    {
        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sNewPartInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }

    //-----------------------------------------------------
    //  VIEW Invalidate Ų ,
    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    //-----------------------------------------------------

    //  VIEW Invalidate
    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 aParseTree->userID,
                 sOldTableInfo->name,
                 idlOS::strlen((SChar*)sOldTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    //  Meta Cache( Table Header  qcmTableInfo ) 籸
    (void)qcm::destroyQcmTableInfo(sNewTableInfo);
    sNewTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT( aStatement ),
                                         sTableID,
                                         sTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   & sNewTableInfo,
                                   & sSCN,
                                   & sNewTableHandle)
             != IDE_SUCCESS);

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    if( aIsPartitioned == ID_TRUE )
    {
        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sPartInfoList )
                  != IDE_SUCCESS );
        (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );
        sNewPartInfoList = sPartInfoList;

        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sNewPartInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sNewTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    *aNewTableInfo    = sNewTableInfo;
    *aNewPartInfoList = sNewPartInfoList;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    return IDE_FAILURE;
}


IDE_RC qdbAlter::executeAddCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ADD COL  
 *
 * Implementation :
 *    1. Lock ȹ
 *       ( Table Partition  Lock ȹ )
 *    2. Replication  ɸ ,
 *       (a) Ƽ ˻
 *       (b)  Receiver Thread 
 *    3. ߰ column default value  validation
 *    4.  ÷ ߰Ǵ ÷  ο ÷ Ʈ 
 *    5. column   Ǵ ο ̺ 
 *    6. SYS_REPL_ITEMS_ TABLE_OID ÷ 
 *    7.  Meta Cache 
 *    8. Table Meta Log Record 
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sOldTableInfo = NULL;
    idBool                    sIsPartitioned;
    qcmPartitionInfoList    * sOldPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    qcmPartitionInfoList    * sCurPartInfoList = NULL;
    smOID                     sOldTableOID;
    UInt                    * sPartitionID  = NULL;
    smOID                   * sOldPartitionOID  = NULL;
    idBool                    sIsReplicatedTable;
    UInt                      sPartitionCount;
    SInt                      sNewColCnt;
    qcmColumn               * sNewColumn  = NULL;
    qdPartitionAttribute    * sCurPartAttr  = NULL;
    qcmColumn               * sNewTableColumn  = NULL;
    mtcColumn               * sNewTableMtcColumn  = NULL;
    qcmColumn              ** sNewPartitionColumn  = NULL;
    mtcColumn              ** sNewPartitionMtcColumn  = NULL;
    idBool                    sRecreateTable;
    smOID                     sNewTableOID;
    smOID                   * sNewPartitionOID = NULL;
    qcmTableInfo            * sNewTableInfo  = NULL;
    qdConstraintSpec        * sConstraint = NULL;
    idBool                    sIsNull;
    UInt                      i;
    qdIndexTableList        * sIndexTable;
    qcmDictionaryTable      * sDictionaryTable;
    qcmDictionaryTable      * sDicTable;
    qcmCompressionColumn    * sCompColumn = NULL;
    UInt                      sTableID;

    smOID                   * sOldTableOIDArray = NULL;
    smOID                   * sNewTableOIDArray = NULL;
    UInt                      sTableOIDCount = 0;

    UInt                      sDDLSupplementalLog = QCU_DDL_SUPPLEMENTAL_LOG;
    UInt                      sDDLRequireLevel = 0;

    //-----------------
    //   ʱȭ
    //-----------------

    sParseTree         = (qdTableParseTree *)aStatement->myPlan->parseTree;
    sIsPartitioned     = ID_FALSE;
    sIsReplicatedTable = ID_FALSE;
    sPartitionCount    = 0;
    sNewColCnt         = 0;
    sRecreateTable     = ID_FALSE;
    sDictionaryTable   = NULL;

    //-----------------------------------------------------
    //  Lock ȹ
    //-----------------------------------------------------

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDU_FIT_POINT( "qdbAlter::executeAddCol::beforeXLock" );

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sTableID      = sParseTree->tableInfo->tableID; 

    // Ʒ  Lock  Ŀ ȹؾ 
    // Lock   tableInfo  Ȯ  
    // Lock   Ͽ ,
    // Exception , Ȯ tableInfo restoreϸ  ߻
    sOldTableInfo = sParseTree->tableInfo;
    sOldTableOID  = smiGetTableId(sParseTree->tableHandle);
    sNewTableOID  = sOldTableOID; // Recreate Tableÿ 

    // PROJ-1407 Temporary table
    // session temporary table ϴ  DDL   .
    IDE_TEST_RAISE( qcuTemporaryObj::existSessionTable( sOldTableInfo ) == ID_TRUE,
                    ERR_SESSION_TEMPORARY_TABLE_EXIST );

    // PROJ-1502 PARTITIONED DISK TABLE Ƽǵ ̺ 
    // Partition  Lock  ȹѴ.
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sIsPartitioned   = ID_TRUE;

        /* BUG-42681 valgrind split  add column ü  */
        IDE_TEST( qcmPartition::checkPartitionCount4Execute( aStatement,
                                                             sParseTree->partTable->partInfoList,
                                                             sTableID )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        // Partition OID Ʈ  ϱ Ͽ Partition  
        for( sCurPartInfoList = sOldPartInfoList;
             sCurPartInfoList != NULL;
             sCurPartInfoList = sCurPartInfoList->next )
        {
            sPartitionCount++;
        }

        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
        
        IDU_FIT_POINT( "qdbAlter::executeAddCol::alloc::sNewPartitionOID",
                        idERR_ABORT_InsufficientMemory );

        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smOID) * sPartitionCount,
                                           (void**)&sNewPartitionOID)
                 != IDE_SUCCESS);

        IDU_FIT_POINT( "qdbAlter::executeAddCol::alloc::sOldPartitionOID",
                        idERR_ABORT_InsufficientMemory );

        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smOID) * sPartitionCount,
                                           (void**)&sOldPartitionOID)
                 != IDE_SUCCESS);

        IDU_FIT_POINT( "qdbAlter::executeAddCol::alloc::sPartitionID",
                        idERR_ABORT_InsufficientMemory );

        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(UInt) * sPartitionCount,
                                           (void**)&sPartitionID)
                 != IDE_SUCCESS);

        // Parition ID Partition OID ȹ
        for( sCurPartInfoList = sOldPartInfoList, i = 0;
             sCurPartInfoList != NULL;
             sCurPartInfoList = sCurPartInfoList->next, i++ )
        {
            sPartitionID[i] = sCurPartInfoList->partitionInfo->partitionID;

            sOldPartitionOID[i] =
                smiGetTableId(sCurPartInfoList->partitionInfo->tableHandle);

            // NewPartitionOID ʱȭ
            // Recreate Table  Add Column  ,
            // NewPartitionOID   Partition OID   
            sNewPartitionOID[i] = sOldPartitionOID[i];
        }
    }

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDE_TEST( smiStatement::setViewSCNOfAllStmt( QC_SMI_STMT( aStatement ) )
              != IDE_SUCCESS );

    //------------------------------------------
    // sequence óϱ  ⺻  ȹ
    //------------------------------------------

    // check session cache SEQUENCE.CURRVAL
    if (aStatement->myPlan->parseTree->currValSeqs != NULL)
    {
        IDE_TEST(qmx::findSessionSeqCaches(aStatement,
                                           aStatement->myPlan->parseTree)
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do
    }

    // get SEQUENCE.NEXTVAL
    if (aStatement->myPlan->parseTree->nextValSeqs != NULL)
    {
        IDE_TEST(qmx::addSessionSeqCaches(aStatement,
                                          aStatement->myPlan->parseTree)
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do
    }
    
    //-----------------------------------------------------
    // ߰ Į default value  validate
    //-----------------------------------------------------

    // Table default value  validate
    sNewColCnt = 0;
    sNewColumn = sParseTree->columns;
    while (sNewColumn != NULL)
    {
        idlOS::strncpy(sNewColumn->name,
                       sNewColumn->namePos.stmtText +
                       sNewColumn->namePos.offset,
                       sNewColumn->namePos.size);

        // fix BUG-32700
        sNewColumn->name[sNewColumn->namePos.size] = '\0';

        if (sNewColumn->defaultValue != NULL)
        {
            if ( ( sNewColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
                 == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
            {
                // hidden column addɶ default expression ̸   
                // null   ִ.

                sIsNull = ID_TRUE;
            }
            else
            {
                IDE_TEST(qdbCommon::convertDefaultValueType(
                             aStatement,
                             & sNewColumn->basicInfo->type,
                             sNewColumn->defaultValue,
                             & sIsNull)
                         != IDE_SUCCESS);
            }

            // BUG-26151
            // primary key, not null constraint ߰ 
            // NULL default value   .
            if ( sIsNull == ID_TRUE )
            {
                for (sConstraint = sParseTree->constraints;
                     sConstraint != NULL;
                     sConstraint = sConstraint->next)
                {
                    if ( QC_IS_NAME_MATCHED( sNewColumn->namePos, sConstraint->constraintColumns->namePos ) )
                    {
                        break;
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }

                if ( sConstraint != NULL )
                {
                    IDE_TEST_RAISE(
                        ( sConstraint->constrType == QD_PRIMARYKEY )  ||
                        ( sConstraint->constrType == QD_NOT_NULL ),
                        ERR_CANNOT_SET_NULL_DEFAULT_VALUE );
                }
                else
                {
                    // Nothing to do.
                }
            }
            else
            {
                //BUG-32071
                //default NULL ƴҶ, ENCRYPT   
                if ( ( sNewColumn->basicInfo->module->flag & MTD_ENCRYPT_TYPE_MASK)
                     == MTD_ENCRYPT_TYPE_TRUE)
                {
                    IDE_RAISE( ERR_CANNOT_SET_DEFAULT_VALUE_WITH_ENCRYPT );
                }
                else
                {
                    // Nothing to do
                }
            }
        }
        else
        {
            // Nothing to do.
        }

        sNewColumn = sNewColumn->next;
        sNewColCnt++;
    }

    //-----------------------------------------------------
    // PROJ-1442 Replication Online  DDL   ó
    //-----------------------------------------------------

    //  Validate Execute ٸ Transaction̹Ƿ,
    // Ƽ ˻ Execute Ѵ.
    if(sOldTableInfo->replicationCount > 0)
    {
		sDDLRequireLevel = 0;

        for ( sNewColumn = sParseTree->columns;
              sNewColumn != NULL; 
              sNewColumn = sNewColumn->next )
        {
            if ( ( sNewColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
                 == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
            {
                sDDLRequireLevel = 1;
                break;
            }
            else
            {
                /* do nothing */
            }
        }

        for ( sConstraint = ((qdTableParseTree *)aStatement->myPlan->parseTree)->constraints;
              sConstraint != NULL;
              sConstraint = sConstraint->next )
        {
            if ( ( sConstraint->constrType == QD_UNIQUE )     ||
                 ( sConstraint->constrType == QD_LOCAL_UNIQUE ) ||
                 ( sConstraint->constrType == QD_NOT_NULL ) )
            {
                sDDLRequireLevel = 1;
                break;
            }
            else
            {
                /* do nothing */
            }
        }

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( sDDLRequireLevel,
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE(
            QC_SMI_STMT(aStatement)->getTrans()->getReplicationMode()
            == SMI_TRANSACTION_REPL_NONE,
            ERR_CANNOT_WRITE_REPL_INFO);

        //  Receiver Thread 
        if ( sIsPartitioned == ID_TRUE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sTableOIDCount = sPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sTableOIDCount = 1;
        }

        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   sOldTableOIDArray,
                                                                   sTableOIDCount )
                  != IDE_SUCCESS );

        // BUG-22703 : Begin Statement  Ŀ Hang ɸ
        // ʾƾ մϴ.
        // mStatistics    մϴ.
        IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                        aStatement->mStatistics,
                                                                        sOldTableOIDArray,
                                                                        sTableOIDCount )
                  != IDE_SUCCESS );

        sIsReplicatedTable = ID_TRUE;
    }

    //   system time ȹϿ template 
    IDE_TEST( qtc::setDatePseudoColumn( QC_PRIVATE_TMPLATE( aStatement ) ) != IDE_SUCCESS );

    //-----------------------------------------------------
    // ο column list 
    //-----------------------------------------------------

    // ο table  ʿ column list 
    // ( ߰ Į  Į  column list  )
    IDU_FIT_POINT( "qdbAlter::executeAddCol::alloc::sNewTableColumn",
                    idERR_ABORT_InsufficientMemory );

    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmColumn) *
                                       (sNewColCnt +
                                        sOldTableInfo->columnCount),
                                       (void**)&sNewTableColumn)
             != IDE_SUCCESS);

    IDU_FIT_POINT( "qdbAlter::executeAddCol::alloc::sNewTableMtcColumn",
                    idERR_ABORT_InsufficientMemory );

    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(mtcColumn) *
                                       (sNewColCnt +
                                        sOldTableInfo->columnCount),
                                       (void**)&sNewTableMtcColumn)
             != IDE_SUCCESS);

    IDE_TEST( addColInfoIntoParseTree(aStatement,
                                      sOldTableInfo,
                                      sParseTree->columns,
                                      sNewTableColumn,
                                      sNewTableMtcColumn)
              != IDE_SUCCESS );

    // ο partition  ʿ column list 
    // ( ߰ Į  Į  column list  )
    if( sIsPartitioned == ID_TRUE )
    {

        IDU_LIMITPOINT("qdbAlter::executeAddCol::malloc6");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmColumn*) *
                                           sPartitionCount,
                                           (void**)& sNewPartitionColumn)
                 != IDE_SUCCESS);

        IDU_LIMITPOINT("qdbAlter::executeAddCol::malloc7");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(mtcColumn*) *
                                           sPartitionCount,
                                           (void**)& sNewPartitionMtcColumn)
                 != IDE_SUCCESS);

        // ̺ Ƽ ŭ ݺ
        // ( sPartAttr Ʈ  Ƽ  ϴ. )
        for( sCurPartInfoList = sOldPartInfoList,
                 sCurPartAttr = sParseTree->partTable->partAttr,
                 i = 0;
             sCurPartInfoList != NULL;
             sCurPartInfoList = sCurPartInfoList->next,
                 sCurPartAttr = sCurPartAttr->next,
                 i++ )
        {
            IDU_LIMITPOINT("qdbAlter::executeAddCol::malloc8");
            IDE_TEST(aStatement->qmxMem->alloc(
                         ID_SIZEOF(qcmColumn) *
                         (sNewColCnt + sOldTableInfo->columnCount),
                         (void**)&sNewPartitionColumn[i])
                     != IDE_SUCCESS);

            IDU_LIMITPOINT("qdbAlter::executeAddCol::malloc9");
            IDE_TEST(aStatement->qmxMem->alloc(
                         ID_SIZEOF(mtcColumn) *
                         (sNewColCnt + sOldTableInfo->columnCount),
                         (void**)&sNewPartitionMtcColumn[i])
                     != IDE_SUCCESS);

            IDE_TEST( addColInfoIntoParseTree(aStatement,
                                              sCurPartInfoList->partitionInfo,
                                              sCurPartAttr->columns,
                                              sNewPartitionColumn[i],
                                              sNewPartitionMtcColumn[i])
                      != IDE_SUCCESS );

        }
    }
    else
    {
        // nothing to do
    }

    // PROJ-2264 Dictionary Table
    for ( sCompColumn = sParseTree->compressionColumn;
          sCompColumn != NULL;
          sCompColumn = sCompColumn->next )
    {
        IDE_TEST( qcmDictionary::makeDictionaryTable(
                      aStatement,
                      sOldTableInfo->TBSID,
                      sNewTableColumn,
                      sCompColumn,
                      &sDictionaryTable )
                  != IDE_SUCCESS );
    }

    //-----------------------------------------------------
    // Add Column 
    // (1) ( drop table & create new table )  
    //     column  ϵ   
    // (2) (1) õ  Add Column 
    //-----------------------------------------------------

    IDE_TEST( decideAddColExeMethod( aStatement, sParseTree, &sRecreateTable )
              != IDE_SUCCESS );

    if ( sRecreateTable == ID_TRUE )
    {
        IDE_TEST( executeAddColByRecreateTable( aStatement,
                                                sParseTree,
                                                sIsPartitioned,
                                                sPartitionCount,
                                                sPartitionID,
                                                sNewColCnt,
                                                sNewTableColumn,
                                                sNewPartitionColumn,
                                                & sNewTableOID,
                                                & sNewPartitionOID,
                                                & sNewTableInfo,
                                                & sNewPartInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        IDE_TEST( executeAddColByAlterMeta( aStatement,
                                            sParseTree,
                                            sIsPartitioned,
                                            sPartitionCount,
                                            sPartitionID,
                                            sNewColCnt,
                                            sNewTableColumn,
                                            sNewTableMtcColumn,
                                            sNewPartitionColumn,
                                            sNewPartitionMtcColumn,
                                            & sNewTableInfo,
                                            & sNewPartInfoList )
                  != IDE_SUCCESS );
    }

    // PROJ-2264 Dictionary Table
    for ( sDicTable = sDictionaryTable;
          sDicTable != NULL;
          sDicTable = sDicTable->next )
    {
        IDE_TEST( qdbCommon::insertCompressionTableSpecIntoMeta(
                     aStatement,
                     sTableID,                                    // data table id
                     sDicTable->dataColumn->basicInfo->column.id, // data table's column id
                     sDicTable->dictionaryTableInfo->tableID,     // dictionary table id
                     sDicTable->dictionaryTableInfo->maxrows )    // dictionary table's max rows
                  != IDE_SUCCESS);
    }

    //-----------------------------------------------------
    //  view ã, recompile
    //-----------------------------------------------------

    // BUG-11266
    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sNewTableInfo->name,
                 idlOS::strlen((SChar*)sNewTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // BUG-16543
    IDE_TEST(qdnTrigger::setInvalidTriggerCache4Table( sNewTableInfo )
             != IDE_SUCCESS);

    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( sDDLSupplementalLog == 1 ) )
    {
        if ( sIsPartitioned == ID_TRUE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sNewTableOIDArray = sNewPartitionOID;
            sTableOIDCount = sPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }

        //-----------------------------------------------------
        // PROJ-1442 Replication Online  DDL 
        // SYS_REPL_ITEMS_ TABLE_OID ÷ 
        //-----------------------------------------------------
        if ( sIsReplicatedTable == ID_TRUE )
        {
            IDE_TEST( qci::mCatalogReplicationCallback.mUpdateReplMetaTableOIDArray( aStatement,
                                                                                     sOldTableOIDArray,
                                                                                     sNewTableOIDArray,
                                                                                     sTableOIDCount )
                      != IDE_SUCCESS );
        }
        else
        {
            /* do nothing */
        }

        //-----------------------------------------------------
        //  PROJ-1442 Replication Online  DDL 
        //  Table Meta Log Record 
        //-----------------------------------------------------
        IDE_TEST( qciMisc::writeTableMetaLogForReplication( aStatement,
                                                            sOldTableOIDArray,
                                                            sNewTableOIDArray,
                                                            sTableOIDCount )
                  != IDE_SUCCESS );
    }
    else
    {
        /* do nothing */
    }

    /* PROJ-2197 PSM Renewal */
    // related PSM
    IDE_TEST(qcmProc::relSetInvalidProcOfRelated(
        aStatement,
        sParseTree->userID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    // PROJ-1073 Package
    IDE_TEST(qcmPkg::relSetInvalidPkgOfRelated(
            aStatement,
            sParseTree->userID,
            sParseTree->tableInfo->name,
            idlOS::strlen((SChar*)sParseTree->tableInfo->name),
            QS_TABLE) != IDE_SUCCESS);

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    IDU_FIT_POINT( "qdbAlter::executeAddCol::BUG-44230" );

    // PROJ-2002 Column Security
    //  ÷ ߰  ⿡ ˸.
    sNewColumn = sParseTree->columns;

    while (sNewColumn != NULL)
    {
        if ( (sNewColumn->basicInfo->module->flag & MTD_ENCRYPT_TYPE_MASK)
             == MTD_ENCRYPT_TYPE_TRUE )
        {
            (void) qcsModule::setColumnPolicy(
                sOldTableInfo->tableOwnerName,
                sOldTableInfo->name,
                sNewColumn->name,
                sNewColumn->basicInfo->mColumnAttr.mEncAttr.mPolicy );
        }
        else
        {
            // Nothing to do.
        }

        sNewColumn = sNewColumn->next;
    }

    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sNewTableInfo->tableOID),
                             0,
                             NULL );
    }

    //-----------------------------------------------------
    //  Meta Cache 
    //-----------------------------------------------------
    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    if( sIsPartitioned == ID_TRUE )
    {
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );

        // old index table tableinfo 
        if ( sRecreateTable == ID_TRUE )
        {
            for ( sIndexTable = sParseTree->oldIndexTables;
                  sIndexTable != NULL;
                  sIndexTable = sIndexTable->next )
            {
                (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
            }
        }
        else
        {
            // Nothing to do.
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_SESSION_TEMPORARY_TABLE_EXIST )
    {
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_TEMPORARY_TABLE_DDL_DISABLE ));
    }
    IDE_EXCEPTION(ERR_CANNOT_WRITE_REPL_INFO)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO));
    }
    IDE_EXCEPTION(ERR_CANNOT_SET_NULL_DEFAULT_VALUE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_SET_NULL_DEFAULT_VALUE));
    }
    IDE_EXCEPTION(ERR_CANNOT_SET_DEFAULT_VALUE_WITH_ENCRYPT)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_SET_DEFAULT_VALUE_WITH_ENCRYPT));
    }
    IDE_EXCEPTION_END;

    // PROJ-2264 Dictionary Table
    // DDL н dictionary table  Ѵ.
    for ( sDicTable = sDictionaryTable;
          sDicTable != NULL;
          sDicTable = sDicTable->next )
    {
        // BUG-36719
        // Dictionary table  Ÿ̺ ѹǾ  ̴.
        // ⼭ table info  Ѵ.
        (void)qcm::destroyQcmTableInfo( sDicTable->dictionaryTableInfo );
    }

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // on fail, must restore old table info.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

// for qdbAlter::executeAddCol.
IDE_RC qdbAlter::addColInfoIntoParseTree(qcStatement    * aStatement,
                                         qcmTableInfo   * aTableInfo,
                                         qcmColumn      * aAddedColumn,
                                         qcmColumn      * aNewTableColumns,
                                         mtcColumn      * aMtcColumns)
{
/***********************************************************************
 *
 * Description :
 *      executeAddCol κ ȣ, ߰Ǵ ÷  ο
 *         ÷ Ʈ 
 *
 * Implementation :
 *      1.  ÷ aNewTableColumns  ī
 *      2. ߰Ǵ ÷ aNewTableColumns  1 ̾ ī
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::addColInfoIntoParseTree"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qcmColumn  *sColumns;
    SInt        i;
    SInt        sTableID;
    SInt        sCurrentOffset;

    sTableID = aTableInfo->columns->basicInfo->column.id /
        SMI_COLUMN_ID_MAXIMUM;
    if ( smiTableSpace::isMemTableSpaceType( aTableInfo->TBSType ) == ID_TRUE )
    {
        sCurrentOffset = smiGetRowHeaderSize(SMI_TABLE_MEMORY);
    }
    else if ( smiTableSpace::isVolatileTableSpaceType( aTableInfo->TBSType ) == ID_TRUE )
    {
        sCurrentOffset = smiGetRowHeaderSize(SMI_TABLE_VOLATILE);
    }
    else
    {
        IDE_DASSERT( smiTableSpace::isDiskTableSpaceType( aTableInfo->TBSType ) == ID_TRUE );

        sCurrentOffset = 0;
    }

    // copy orgional columns.
    for ( sColumns = aTableInfo->columns,
              i = 0;
          sColumns != NULL;
          sColumns = sColumns->next,
              i++ )
    {
        idlOS::memcpy(&aNewTableColumns[i], sColumns, ID_SIZEOF(qcmColumn));
        idlOS::memcpy(&aMtcColumns[i], sColumns->basicInfo, ID_SIZEOF(mtcColumn));
        aNewTableColumns[i].basicInfo = &aMtcColumns[i];
        aNewTableColumns[i].next = &aNewTableColumns[i+1];

        if ( sColumns->defaultValueStr != NULL )
        {
            IDU_FIT_POINT( "qdbAlter::addColInfoIntoParseTree::alloc::defaultValue",
                            idERR_ABORT_InsufficientMemory );

            IDE_TEST( STRUCT_ALLOC(aStatement->qmxMem,
                                   qtcNode,
                                   &(aNewTableColumns[i].defaultValue))
                      != IDE_SUCCESS);
        }

        // PROJ-1579 NCHAR
        // old column default value ̹ Ÿ ̺ Ǿ 
        aNewTableColumns[i].ncharLiteralPos = NULL;
    }

    // copy added columns
    sColumns = aAddedColumn;

    while (sColumns != NULL)
    {
        idlOS::memcpy(&aNewTableColumns[i], sColumns, ID_SIZEOF(qcmColumn));
        idlOS::memcpy(&aMtcColumns[i], sColumns->basicInfo, ID_SIZEOF(mtcColumn));
        aNewTableColumns[i].basicInfo = &aMtcColumns[i];
        aMtcColumns[i].column.id = sTableID * SMI_COLUMN_ID_MAXIMUM + i;

        sColumns = sColumns->next;
        if (sColumns != NULL)
        {
            aNewTableColumns[i].next = &aNewTableColumns[i+1];
        }
        else
        {
            aNewTableColumns[i].next = NULL;
        }
        i++;
    }

    IDE_TEST( qdbCommon::setColListOffset( aStatement->qmxMem,
                                           aNewTableColumns,
                                           sCurrentOffset )
              != IDE_SUCCESS );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::copyColInfo(qcmColumn * aNewTableColumns,
                             qcmColumn * aTableColumns)
{
/***********************************************************************
 *
 * Description :
 *      BUG-15936
 *      executeAddCol κ ȣ, aNewTableColumns mtcColumn
 *       create table mtcColumn Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::setColInfoByTableInfo"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qcmColumn  * sSrcColumn;
    qcmColumn  * sDstColumn;

    sSrcColumn = aTableColumns;
    sDstColumn = aNewTableColumns;

    while ( (sSrcColumn != NULL) && (sDstColumn != NULL) )
    {
        IDE_ASSERT(
            (sDstColumn->basicInfo->column.id & SMI_COLUMN_ID_MASK) ==
            (sSrcColumn->basicInfo->column.id & SMI_COLUMN_ID_MASK) );

        // copy basicInfo
        idlOS::memcpy( sDstColumn->basicInfo,
                       sSrcColumn->basicInfo,
                       ID_SIZEOF(mtcColumn) );

        sSrcColumn = sSrcColumn->next;
        sDstColumn = sDstColumn->next;
    }

    IDE_ASSERT( (sSrcColumn == NULL) && (sDstColumn == NULL) );

    return IDE_SUCCESS;

#undef IDE_FN
}

IDE_RC qdbAlter::executeDropCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... DROP COLUMN ...  execution 
 *
 * Implementation :
 *    1. ĳǾ ִ qcmTableInfo  ̺ ڵ, ̺ ID صα
 *    2. ÷   ÷ ŭ qcmColumn,mtcColumn Ҵޱ
 *    3.   ʴ ÷  1  Ҵ ۿ ο
 *    4. ̺ ε ŭ qcmIndex  Ҵ޾Ƽ
 *        ε  
 *    5. ̺  Ͽ tableOID οޱ
 *    6. 1  ص ̺ ID  Ÿ ̺ ε  
 *    7. SYS_TABLES_  tableOID  5    
 *    8. 1  ص ̺ ID  Ÿ ̺ ÷  
 *    9. ο ÷  Ÿ ̺ Է
 *    10. 1  ص ̺ ID  Ÿ ̺ constraint  
 *    11. constraint  
 *    12. ε  
 *    13. Constraint õ Procedure   
 *    14. Index õ Procedure   
 *    15.  ̺   ̺  ű => moveRow ȣ
 *    16. related PSM  invalid · 
 *    17. related VIEW  invalid · 
 *    18. Ÿ ĳ 籸
 *
 * Replication ɸ Table  DDL , ߰ Ʒ ۾ Ѵ.
 *    1. Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
 *    2. Not Null  , Function-based Index, Unique Index, Unique Key  
 *       check   Ȯ 
 *    3.  Receiver Thread 
 *    4. SYS_REPL_ITEMS_ TABLE_OID ÷ 
 *    5. Table Meta Log Record 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeDropCol"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree        * sParseTree;
    qcmColumn               * sColumn;
    const void              * sOldTableHandle;
    void                   ** sOldPartitionHandle;
    qcmTableInfo            * sOldTableInfo = NULL;
    qcmColumn               * sNewTableColumn;
    mtcColumn               * sNewMtcColumn;
    SInt                      sColumnCount;
    UInt                      sTableID;
    UInt                    * sPartitionID;
    smSCN                     sSCN;
    qcmTableInfo            * sTempTableInfo = NULL;
    smOID                     sNewTableOID;
    smOID                   * sNewPartitionOID = NULL;
    smOID                     sOldTableOID;
    smOID                   * sOldPartitionOID = NULL;
    qcmIndex                * sNewTableIndex;
    qcmIndex               ** sNewPartIndex    = NULL;
    UInt                      sNewPartIndexCount = 0;
    void                    * sTableHandle;
    idBool                    sIsPartitioned = ID_FALSE;
    qcmPartitionInfoList    * sPartInfoList = NULL;
    qcmPartitionInfoList    * sDstPartInfoList = NULL;
    qcmPartitionInfoList    * sSrcPartInfoList = NULL;
    qcmPartitionInfoList    * sOldPartInfoList = NULL;
    qcmPartitionInfoList    * sNewPartInfoList = NULL;
    qcmTableInfo            * sPartInfo = NULL;
    qcmTableInfo            * sSrcPartInfo = NULL;
    qcmTableInfo            * sDstPartInfo = NULL;
    UInt                      i;
    UInt                      j;
    UInt                      sPartitionCount = 0;
    UInt                      sDelColumnCnt;
    UInt                    * sDelColumnID;
    qcmColumn              ** sNewPartitionColumn = NULL;
    mtcColumn              ** sNewPartitionMtcColumn = NULL;
    idBool                    sIsReplicatedTable = ID_FALSE;
    qcmTableInfo           ** sNewPartitionInfoArr = NULL;
    qdIndexTableList        * sIndexTable;
    qcmTableInfo            * sDicInfo;
    UInt                      sDicTableID;
    qcmCheck                * sCheckConstr;

    smiSegAttr                sSegAttr;
    smiSegStorageAttr         sSegStoAttr;
    UInt                      sPartType = 0;

    smOID                   * sOldTableOIDArray = NULL;
    smOID                   * sNewTableOIDArray = NULL;
    UInt                      sTableOIDCount = 0;

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    SInt                      sCountDiskType = 0;
    SInt                      sCountMemType  = 0;
    SInt                      sCountVolType  = 0;
    UInt                      sTableType     = 0;

    qcmIndex                * sIndexInfo = NULL;
    qcmCheck                * sCheck = NULL;
    UInt                      sDDLRequireLevel = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDU_FIT_POINT( "qdbAlter::executeDropCol::beforeXLock" );

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;
    sOldTableHandle = sParseTree->tableInfo->tableHandle;
    sOldTableOID = smiGetTableId(sOldTableHandle);

    // PROJ-1407 Temporary table
    // session temporary table ϴ  DDL   .
    IDE_TEST_RAISE( qcuTemporaryObj::existSessionTable( sOldTableInfo ) == ID_TRUE,
                    ERR_SESSION_TEMPORARY_TABLE_EXIST );

    // PROJ-1502 PARTITIONED DISK TABLE
    // Ƽǵ ̺ 
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sIsPartitioned = ID_TRUE;

        // -----------------------------------------------------
        // Partition OID Ʈ  ϱ  ޸ ũ 
        // -----------------------------------------------------

        /* BUG-42681 valgrind split  add column ü  */
        IDE_TEST( qcmPartition::checkPartitionCount4Execute( aStatement,
                                                             sParseTree->partTable->partInfoList,
                                                             sOldTableInfo->tableID )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );        

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        for ( sPartInfoList = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList = sPartInfoList->next )
        {
            sPartitionCount++;
        }

        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
        
        // OIDҴ  ʱȭ
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc1");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smOID) *
                                           sPartitionCount,
                                           (void**)&sOldPartitionOID)
                 != IDE_SUCCESS);

        for(sPartInfoList = sOldPartInfoList, i = 0;
            sPartInfoList != NULL;
            sPartInfoList = sPartInfoList->next, i++)
        {

            sPartInfo = sPartInfoList->partitionInfo;
            sOldPartitionOID[i] = smiGetTableId(sPartInfo->tableHandle);
        }
    }

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDE_TEST( smiStatement::setViewSCNOfAllStmt( QC_SMI_STMT( aStatement ) )
              != IDE_SUCCESS );

    /* PROJ-1442 Replication Online  DDL 
     * Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
     */
    if(sOldTableInfo->replicationCount > 0)
    {
        sDDLRequireLevel = 0;

        for ( sColumn = sParseTree->columns;
              sColumn != NULL;
              sColumn = sColumn->next )
        {
            if ( ( sColumn->basicInfo->flag & MTC_COLUMN_NOTNULL_MASK ) ==
                 MTC_COLUMN_NOTNULL_TRUE )
            {
                sDDLRequireLevel = 1;
                break;
            }
            else
            {
                /* do nothing */
            }

            if ( ( sColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK )
                 == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
            {
                sDDLRequireLevel = 1;
                break;
            }
            else
            {
                /* do nothing */
            }

            /* Unique Index */
            for ( i = 0; i < sOldTableInfo->indexCount; i++ )
            {
                sIndexInfo = &sOldTableInfo->indices[i];
                if ( ( sIndexInfo->isUnique == ID_TRUE ) || ( sIndexInfo->isLocalUnique == ID_TRUE ) )
                {
                    if ( qdn::intersectColumn( (UInt*)smiGetIndexColumns( sIndexInfo->indexHandle ),
                                               sIndexInfo->keyColCount,
                                               &(sColumn->basicInfo->column.id), 1 ) == ID_TRUE )
                    {
                        sDDLRequireLevel = 1;
                        break;
                    }
                    else
                    {
                        /* do nothing */
                    }
                }
                else
                {
                    /* do nothing */
                }
            }

            /* Unique Key */
            for ( i = 0; i < sOldTableInfo->uniqueKeyCount; i++ )
            {
                sIndexInfo = sOldTableInfo->uniqueKeys[i].constraintIndex;

                if ( qdn::intersectColumn( (UInt*)smiGetIndexColumns( sIndexInfo->indexHandle ),
                                           sIndexInfo->keyColCount,
                                           &(sColumn->basicInfo->column.id), 1 ) == ID_TRUE )
                {
                    sDDLRequireLevel = 1;
                    break;
                }
                else
                {
                    /* do nothing */
                }
            }

            /* check constraint */
            for ( i = 0; i < sOldTableInfo->checkCount; i++ )
            {
                sCheck = &(sOldTableInfo->checks[i]);
                if ( qdn::intersectColumn( sCheck->constraintColumn,
                                           sCheck->constraintColumnCount,
                                           &(sColumn->basicInfo->column.id),
                                           1 )
                     == ID_TRUE )
                {
                    sDDLRequireLevel = 1;
                    break;
                }
                else
                {
                    /* do nothing */
                }
            }
        }

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( sDDLRequireLevel,
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE(QC_SMI_STMT(aStatement)->getTrans()->getReplicationMode()
                       == SMI_TRANSACTION_REPL_NONE,
                       ERR_CANNOT_WRITE_REPL_INFO);

        /* PROJ-1442 Replication Online  DDL 
         *  Receiver Thread 
         */
        if ( sIsPartitioned == ID_TRUE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sTableOIDCount = sPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sTableOIDCount = 1;
        }

        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   sOldTableOIDArray,
                                                                   sTableOIDCount )
                  != IDE_SUCCESS );

        // BUG-22703 : Begin Statement  Ŀ Hang ɸ
        // ʾƾ մϴ.
        // mStatistics    մϴ.
        IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                        aStatement->mStatistics,
                                                                        sOldTableOIDArray,
                                                                        sTableOIDCount )
                  != IDE_SUCCESS );

        sIsReplicatedTable = ID_TRUE;
    }

    sTableID = sParseTree->tableInfo->tableID;
    sColumnCount = 0;

    sColumn = sParseTree->columns;
    while (sColumn != NULL)
    {
        sColumn = sColumn->next;
        sColumnCount ++;
    }

    sDelColumnCnt = sColumnCount;
    sColumnCount = sParseTree->tableInfo->columnCount - sColumnCount;

    IDU_FIT_POINT( "qdbAlter::executeDropCol::alloc::sNewTableColumn",
                    idERR_ABORT_InsufficientMemory );

    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmColumn) * sColumnCount,
                                       (void**)&sNewTableColumn)
             != IDE_SUCCESS);

    IDU_FIT_POINT( "qdbAlter::executeDropCol::alloc::sNewMtcColumn",
                    idERR_ABORT_InsufficientMemory );

    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(mtcColumn) * sColumnCount,
                                       (void**)&sNewMtcColumn)
             != IDE_SUCCESS);

    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(UInt) * sDelColumnCnt,
                                       (void**)&sDelColumnID)
             != IDE_SUCCESS);
    
    IDE_TEST(deleteColInfo(aStatement,
                           sParseTree,
                           sParseTree->tableInfo,
                           sNewTableColumn,
                           sNewMtcColumn,
                           sDelColumnID,
                           sColumnCount) != IDE_SUCCESS);

    if (sParseTree->tableInfo->indexCount > 0)
    {
        IDU_FIT_POINT( "qdbAlter::executeDropCol::alloc::sNewTableIndex",
                        idERR_ABORT_InsufficientMemory );

        // for non-partitioned, partitioned index
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmIndex)*
                                           sParseTree->tableInfo->indexCount,
                                           (void**)&sNewTableIndex)
                 != IDE_SUCCESS);

        idlOS::memcpy(sNewTableIndex,
                      sParseTree->tableInfo->indices,
                      ID_SIZEOF(qcmIndex) *
                        sParseTree->tableInfo->indexCount);

        // for index partition
        // fix BUG-18706
        if( sIsPartitioned == ID_TRUE )
        {
            IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc5");
            IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmIndex*) *
                                               sPartitionCount,
                                               (void**)& sNewPartIndex)
                     != IDE_SUCCESS);

            for( sPartInfoList = sOldPartInfoList, i = 0;
                 sPartInfoList != NULL;
                 sPartInfoList = sPartInfoList->next, i++ )
            {
                sPartInfo = sPartInfoList->partitionInfo;

                if ( sPartInfo->indexCount > 0 )
                {
                    IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc6");
                    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmIndex) *
                                                       sPartInfo->indexCount,
                                                       (void**)&sNewPartIndex[i])
                             != IDE_SUCCESS);
                    
                    if ( sNewPartIndexCount == 0 )
                    {
                        sNewPartIndexCount = sPartInfo->indexCount;
                    }
                    else
                    {
                        IDE_DASSERT( sNewPartIndexCount == sPartInfo->indexCount );
                    }
                    
                    idlOS::memcpy( sNewPartIndex[i],
                                   sPartInfo->indices,
                                   ID_SIZEOF(qcmIndex) * sPartInfo->indexCount );
                }
                else
                {
                    //  non-partitioned index  
                    sNewPartIndex[i] = NULL;
                }
            }
        }
        else
        {
            // Nothing to do
        }
    }
    else
    {
        sNewTableIndex = NULL;
    }

    IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                        sNewTableColumn,
                                        sParseTree->tableInfo->tableOwnerID,
                                        sParseTree->tableInfo->tableID,
                                        sParseTree->tableInfo->maxrows,
                                        sParseTree->tableInfo->TBSID,
                                        sParseTree->tableInfo->segAttr,
                                        sParseTree->tableInfo->segStoAttr,
                                        /*  Table Flag °  =>
                                           MASK Ʈ   1  */
                                        QDB_TABLE_ATTR_MASK_ALL,
                                        sParseTree->tableInfo->tableFlag, /* Flag Value */
                                        sParseTree->tableInfo->parallelDegree,
                                        &sNewTableOID)
             != IDE_SUCCESS);

    // BUG-44814 ddl    縦 ؾ
    smiStatistics::copyTableStats( smiGetTable(sNewTableOID), sOldTableHandle, sDelColumnID, sDelColumnCnt );

    IDE_TEST(deleteIndexSpecFromMeta(aStatement,
                                     sTableID)
             != IDE_SUCCESS);

    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sParseTree->tableInfo->tableID,
                 sNewTableOID,
                 sColumnCount,
                 sParseTree->tableInfo->parallelDegree)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc7");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smOID) * sPartitionCount,
                                           (void**)&sNewPartitionOID)
                 != IDE_SUCCESS);
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc8");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(void*) * sPartitionCount,
                                           (void**)&sOldPartitionHandle)
                 != IDE_SUCCESS);
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc9");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(UInt) * sPartitionCount,
                                           (void**)&sPartitionID)
                 != IDE_SUCCESS);

        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc10");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qcmColumn*) * sPartitionCount,
                                           (void**)& sNewPartitionColumn)
                 != IDE_SUCCESS);
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc11");
        IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(mtcColumn*) * sPartitionCount,
                                           (void**)& sNewPartitionMtcColumn)
                 != IDE_SUCCESS);

        // -----------------------------------------------------
        // ̺ Ƽ ŭ ݺ
        // -----------------------------------------------------
        for( sPartInfoList = sOldPartInfoList, i = 0;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            sPartInfo = sPartInfoList->partitionInfo;
            sPartType = sPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

            IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc12");
            IDE_TEST(aStatement->qmxMem->alloc(
                         ID_SIZEOF(qcmColumn) * sColumnCount,
                         (void**)&sNewPartitionColumn[i])
                     != IDE_SUCCESS);


            IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc13");
            IDE_TEST(aStatement->qmxMem->alloc(
                         ID_SIZEOF(mtcColumn) * sColumnCount,
                         (void**)&sNewPartitionMtcColumn[i])
                     != IDE_SUCCESS);

            IDE_TEST(deleteColInfo(aStatement,
                                   sParseTree,
                                   sPartInfo,
                                   sNewPartitionColumn[i],
                                   sNewPartitionMtcColumn[i],
                                   sDelColumnID,
                                   sColumnCount) != IDE_SUCCESS);

            /* PROJ-2464 hybrid partitioned table 
             *  - Partition Info  , Table Option Partitioned Table  Ѵ.
             *  - , PartInfo  ̿ ʰ, TBSID    ؼ ̿Ѵ.
             */
            qdbCommon::adjustPhysicalAttr( sPartType,
                                           sParseTree->tableInfo->segAttr,
                                           sParseTree->tableInfo->segStoAttr,
                                           & sSegAttr,
                                           & sSegStoAttr,
                                           ID_TRUE /* aIsTable */ );

            IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                                sNewPartitionColumn[i],
                                                sParseTree->tableInfo->tableOwnerID,
                                                sTableID,
                                                sParseTree->tableInfo->maxrows,
                                                sPartInfo->TBSID,
                                                sSegAttr,
                                                sSegStoAttr,
                                                /*  Table Flag
                                                   °  =>
                                                   MASK Ʈ  1μ*/
                                                QDB_TABLE_ATTR_MASK_ALL,
                                                sParseTree->tableInfo->tableFlag, /* Flag Value */
                                                sParseTree->tableInfo->parallelDegree,
                                                &sNewPartitionOID[i])
                     != IDE_SUCCESS);

            // BUG-44814 ddl    縦 ؾ
            smiStatistics::copyTableStats( smiGetTable(sNewPartitionOID[i]), sPartInfo->tableHandle, sDelColumnID, sDelColumnCnt );

            sOldPartitionHandle[i] = sPartInfo->tableHandle;
            sPartitionID[i] = sPartInfo->partitionID;

            IDE_TEST(qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                             sTableID,
                                                             sPartitionID[i],
                                                             sNewPartitionOID[i] )
                     != IDE_SUCCESS );
        }
    }

    IDE_TEST(deleteColumnSpecFromMeta(aStatement, sTableID)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        IDE_TEST(deletePartKeyColumnSpecFromMeta(aStatement,
                                                 sTableID,
                                                 QCM_TABLE_OBJECT_TYPE)
                 != IDE_SUCCESS);

        IDE_TEST(deletePartLobSpecFromMeta(aStatement,
                                           sTableID)
                 != IDE_SUCCESS);
    }

    // insert new column spec into meta.
    IDE_TEST(qdbCommon::insertColumnSpecIntoMeta(aStatement,
                                                 sParseTree->userID,
                                                 sTableID,
                                                 sNewTableColumn,
                                                 ID_FALSE /* is queue */)
             != IDE_SUCCESS);

    IDE_TEST(qdd::deleteConstraintsFromMeta(aStatement, sTableID)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        IDE_TEST(qdbCommon::insertPartKeyColumnSpecIntoMeta(aStatement,
                                                            sParseTree->userID,
                                                            sTableID,
                                                            sNewTableColumn,
                                                            sParseTree->tableInfo->partKeyColumns,
                                                            QCM_TABLE_OBJECT_TYPE)
                 != IDE_SUCCESS);

        for( i = 0; i < sPartitionCount; i++ )
        {
            IDE_TEST(qdbCommon::insertPartLobSpecIntoMeta(
                         aStatement,
                         sParseTree->userID,
                         sTableID,
                         sPartitionID[i],
                         sNewPartitionColumn[i])
                     != IDE_SUCCESS);
        }

        IDE_TEST( findDelIndexAndDelMeta( aStatement,
                                          sOldTableInfo,
                                          sParseTree->columns )
                  != IDE_SUCCESS );
        
        // PROJ-1624 non-partitioned index
        // index table createIndex ٽ ǹǷ meta  ̸ .
        for ( sIndexTable = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            IDE_TEST( qdx::dropIndexTable( aStatement,
                                           sIndexTable,
                                           ID_FALSE /* aIsDropTablespace */ )
                      != IDE_SUCCESS );
        }
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    sTableType = sOldTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* - Partition  ˻Ѵ. */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                sOldPartInfoList,
                                                & sCountDiskType,
                                                & sCountMemType,
                                                & sCountVolType );

    /* - Memory ü ְų, Index Table ִٸ, Index  Ѵ. */
    if ( ( ( sCountMemType + sCountVolType ) > 0 ) ||
         ( sParseTree->oldIndexTables != NULL ) )
    {
        IDE_TEST( qdbCommon::createConstraintFromInfo( aStatement,
                                                       sOldTableInfo,
                                                       sNewTableOID,
                                                       sPartitionCount,
                                                       sNewPartitionOID,
                                                       SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                       sNewTableIndex,
                                                       sNewPartIndex,
                                                       sNewPartIndexCount,
                                                       sParseTree->oldIndexTables,
                                                       &( sParseTree->newIndexTables ),
                                                       sParseTree->columns )
                  != IDE_SUCCESS );

        IDE_TEST( qdbCommon::createIndexFromInfo( aStatement,
                                                  sOldTableInfo,
                                                  sNewTableOID,
                                                  sPartitionCount,
                                                  sNewPartitionOID,
                                                  SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                  sNewTableIndex,
                                                  sNewPartIndex,
                                                  sNewPartIndexCount,
                                                  sParseTree->oldIndexTables,
                                                  &( sParseTree->newIndexTables ),
                                                  sParseTree->columns,
                                                  ID_TRUE )
                  != IDE_SUCCESS );

        /* PROJ-1624 global non-partitioned index
         *  - Index Meta Index Table Id Ѵ.
         */
        if ( sIsPartitioned == ID_TRUE )
        {
            for ( i = 0;
                  i < sOldTableInfo->indexCount;
                  i++ )
            {
                if ( ( sOldTableInfo->indices[i].indexPartitionType == QCM_NONE_PARTITIONED_INDEX ) &&
                     ( sOldTableInfo->indices[i].indexTableID != sNewTableIndex[i].indexTableID ) )
                {
                    IDE_TEST( qdx::updateIndexSpecFromMeta( aStatement,
                                                            sOldTableInfo->indices[i].indexId,
                                                            sNewTableIndex[i].indexTableID )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing to do */
                }
            }
        }
        else
        {
            /* Nothing to do */
        }
    }
    else
    {
        /* Nothing to do */
    }
    
    /* PROJ-2197 PSM Renewal */
    // related PSM
    IDE_TEST(qcmProc::relSetInvalidProcOfRelated(
        aStatement,
        sParseTree->userID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    // PROJ-1073 Package
    IDE_TEST(qcmPkg::relSetInvalidPkgOfRelated(
        aStatement,
        sParseTree->userID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    /* BUG-35445 Check Constraint, Function-Based Index   Function /  */
    for ( i = 0; i < sParseTree->tableInfo->checkCount; i++ )
    {
        sCheckConstr = &(sParseTree->tableInfo->checks[i]);

        for ( j = 0; j < sCheckConstr->constraintColumnCount; j++ )
        {
            if ( qdbCommon::findColumnIDInColumnList( sParseTree->columns,
                                                      sCheckConstr->constraintColumn[j] )
                 == ID_TRUE )
            {
                IDE_TEST( qcmProc::relRemoveRelatedToConstraintByConstraintID(
                                aStatement,
                                sCheckConstr->constraintID )
                          != IDE_SUCCESS );

                break;
            }
            else
            {
                /* Nothing to do */
            }
        }
    }

    for ( i = 0; i < sOldTableInfo->indexCount; i++ )
    {
        for ( j = 0; j < sOldTableInfo->indices[i].keyColCount; j++ )
        {
            if ( qdbCommon::findColumnIDInColumnList( sParseTree->columns,
                                                      sOldTableInfo->indices[i].keyColumns[j].column.id )
                 == ID_TRUE )
            {
                IDE_TEST( qcmProc::relRemoveRelatedToIndexByIndexID(
                                aStatement,
                                sOldTableInfo->indices[i].indexId )
                          != IDE_SUCCESS );
                break;
            }
            else
            {
                /* Nothing to do */
            }
        }
    }

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sNewTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sTempTableInfo,
                                   &sSCN,
                                   &sTableHandle)
             != IDE_SUCCESS);

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)

              != IDE_SUCCESS );

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        // ο qcmPartitionInfo pointer  array 
        IDU_LIMITPOINT("qdbAlter::executeDropCol::malloc14");
        IDE_TEST( aStatement->qmxMem->cralloc(
                      ID_SIZEOF(qcmTableInfo*) * sPartitionCount,
                      (void**) & sNewPartitionInfoArr )
                  != IDE_SUCCESS);

        for( i = 0; i < sPartitionCount; i++ )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT(aStatement),
                          sPartitionID[i],
                          sNewPartitionOID[i],
                          sTempTableInfo ) != IDE_SUCCESS );

            IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i]),
                                           (void**)&sNewPartitionInfoArr[i] )
                      != IDE_SUCCESS );
        }

        IDE_TEST( qcmPartition::getPartitionInfoList(
                      aStatement,
                      QC_SMI_STMT( aStatement ),
                      aStatement->qmxMem,
                      sTableID,
                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }

    // BUG-15936
    // copy new mtcColumn
    IDE_TEST( copyColInfo(sNewTableColumn,
                          sTempTableInfo->columns)
              != IDE_SUCCESS );

    /* PROJ-1442 Replication Online  DDL 
     * SYS_REPL_ITEMS_ TABLE_OID ÷ 
     */
    if(sIsReplicatedTable == ID_TRUE)
    {
        if ( sIsPartitioned == ID_TRUE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sNewTableOIDArray = sNewPartitionOID;
            sTableOIDCount = sPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }

        IDE_TEST( qci::mCatalogReplicationCallback.mUpdateReplMetaTableOIDArray( aStatement,
                                                                                 sOldTableOIDArray,
                                                                                 sNewTableOIDArray,
                                                                                 sTableOIDCount )
                  != IDE_SUCCESS );
    }

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        sSrcPartInfoList = sOldPartInfoList;
        sDstPartInfoList = sNewPartInfoList;

        for( i = 0; i < sPartitionCount; i++ )
        {
            // move row from old to new.
            // drop old table partitions
            sSrcPartInfo = sSrcPartInfoList->partitionInfo;
            sDstPartInfo = sDstPartInfoList->partitionInfo;

            IDE_TEST( copyColInfo(sNewPartitionColumn[i],
                                  sDstPartInfo->columns)
                      != IDE_SUCCESS );

            IDE_TEST(moveRow(aStatement,
                             NULL,
                             sOldTableInfo,
                             sOldPartitionHandle[i],
                             smiGetTable( sNewPartitionOID[i]),
                             sSrcPartInfo->columns,
                             sNewPartitionColumn[i],
                             sTempTableInfo,
                             sParseTree->newIndexTables,
                             ID_FALSE /* No Undo Logging */)
                     != IDE_SUCCESS);

            sSrcPartInfoList = sSrcPartInfoList->next;
            sDstPartInfoList = sDstPartInfoList->next;
        }
        // drop old partitioned table
        IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                       sOldTableHandle,
                                       SMI_TBSLV_DDL_DML )
                  != IDE_SUCCESS );
    }
    else
    {
        // move row from old to new.
        // drop old non-partitioned table
        IDE_TEST(moveRow(aStatement,
                         NULL,
                         sOldTableInfo,
                         sOldTableHandle,
                         smiGetTable( sNewTableOID),
                         sParseTree->tableInfo->columns,
                         sNewTableColumn,
                         NULL,
                         NULL,
                         ID_FALSE /* No Undo Logging */)
                 != IDE_SUCCESS);
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT   
     *  - Memory ü , Index Table ٸ, Index  Ѵ.
     */
    if ( ( ( sCountMemType + sCountVolType ) == 0 ) &&
         ( sParseTree->oldIndexTables == NULL ) )
    {
        IDE_TEST( qdbCommon::createConstraintFromInfo( aStatement,
                                                       sOldTableInfo,
                                                       sNewTableOID,
                                                       sPartitionCount,
                                                       sNewPartitionOID,
                                                       SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                       sNewTableIndex,
                                                       sNewPartIndex,
                                                       sNewPartIndexCount,
                                                       sParseTree->oldIndexTables,
                                                       &( sParseTree->newIndexTables ),
                                                       sParseTree->columns )
                  != IDE_SUCCESS );

        IDE_TEST( qdbCommon::createIndexFromInfo( aStatement,
                                                  sOldTableInfo,
                                                  sNewTableOID,
                                                  sPartitionCount,
                                                  sNewPartitionOID,
                                                  SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                                                  sNewTableIndex,
                                                  sNewPartIndex,
                                                  sNewPartIndexCount,
                                                  sParseTree->oldIndexTables,
                                                  &( sParseTree->newIndexTables ),
                                                  sParseTree->columns,
                                                  ID_TRUE )
                  != IDE_SUCCESS );

        /* PROJ-1624 global non-partitioned index
         *  - Index Meta Index Table Id Ѵ.
         */
        if ( sIsPartitioned == ID_TRUE )
        {
            for ( i = 0;
                  i < sOldTableInfo->indexCount;
                  i++ )
            {
                if ( ( sOldTableInfo->indices[i].indexPartitionType == QCM_NONE_PARTITIONED_INDEX ) &&
                     ( sOldTableInfo->indices[i].indexTableID != sNewTableIndex[i].indexTableID ) )
                {
                    IDE_TEST( qdx::updateIndexSpecFromMeta( aStatement,
                                                            sOldTableInfo->indices[i].indexId,
                                                            sNewTableIndex[i].indexTableID )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing to do */
                }
            }
        }
        else
        {
            /* Nothing to do */
        }

        /* - Meta Cache Recreate */
        (void)qcm::destroyQcmTableInfo( sTempTableInfo );

        sTempTableInfo = NULL;

        IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                               sTableID,
                                               sNewTableOID )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sTableID,
                                         & sTempTableInfo,
                                         & sSCN,
                                         & sTableHandle)
                  != IDE_SUCCESS );

        IDE_TEST( qcm::validateAndLockTable( aStatement,
                                             sTableHandle,
                                             sSCN,
                                             SMI_TABLE_LOCK_X )
                  != IDE_SUCCESS );

        /* PROJ-1502 PARTITIONED DISK TABLE */
        if ( sIsPartitioned == ID_TRUE )
        {
            for ( sPartInfoList  = sNewPartInfoList, i = 0;
                  sPartInfoList != NULL;
                  sPartInfoList  = sPartInfoList->next, i++ )
            {
                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo( QC_SMI_STMT( aStatement ),
                                                                    sPartitionID[i],
                                                                    sNewPartitionOID[i],
                                                                    sTempTableInfo,
                                                                    NULL )
                          != IDE_SUCCESS );

                IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i] ),
                                               (void**)& sPartInfoList->partitionInfo )
                          != IDE_SUCCESS );

                (void)qcmPartition::destroyQcmPartitionInfo( sNewPartitionInfoArr[i] );

                sNewPartitionInfoArr[i] = sPartInfoList->partitionInfo;
            }

            IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                          QC_SMI_STMT(aStatement),
                                                          aStatement->qmxMem,
                                                          sTableID,
                                                          & sNewPartInfoList )
                      != IDE_SUCCESS );
        }
        else
        {
            /* Nothing to do */            
        }

        IDU_FIT_POINT( "qdbAlter::executeDropCol::BUG-44230-1" );
    }
    else
    {
        /* Nothing to do */
    }
    
    // PROJ-2264 Dictionary table
    for( sColumn  = sParseTree->columns;
         sColumn != NULL;
         sColumn  = sColumn->next )
    {
        if( (sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
            == SMI_COLUMN_COMPRESSION_TRUE )
        {
            sDicInfo = (qcmTableInfo *)smiGetTableRuntimeInfoFromTableOID(
                sColumn->basicInfo->column.mDictionaryTableOID );
            sDicTableID = sDicInfo->tableID;

            // SYS_COMPRESSION_TABLES_   ÷  ڵ带 Ѵ.
            IDE_TEST( qdd::deleteCompressionTableSpecFromMetaByDicTableID(
                                        aStatement,
                                        sDicTableID )
                      != IDE_SUCCESS );
        }
        else
        {
            // uncompression column
            // Nothing to do.
        }
    }

    // Drop column   ÷ column id    Ƿ
    //  Ÿ ؾ Ѵ.
    for( sColumn  = sNewTableColumn;
         sColumn != NULL;
         sColumn  = sColumn->next )
    {
        if( (sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
            == SMI_COLUMN_COMPRESSION_TRUE )
        {
            sDicInfo = (qcmTableInfo *)smiGetTableRuntimeInfoFromTableOID(
                sColumn->basicInfo->column.mDictionaryTableOID );

            // SYS_COMPRESSION_TABLES_ Ÿ column id  Ѵ.
            IDE_TEST( qcmDictionary::updateColumnIDInCompressionTableSpecMeta(
                                        aStatement,
                                        sDicInfo->tableID,
                                        sColumn->basicInfo->column.id)
                      != IDE_SUCCESS );
        }
        else
        {
            // uncompression column
            // Nothing to do.
        }
    }

    // BUG-21387 COMMENT
    //   Column Comment  .
    for (sColumn = sParseTree->columns;
         sColumn != NULL;
         sColumn = sColumn->next)
    {
        IDE_TEST(qdbComment::deleteCommentColumn(
                     aStatement,
                     sParseTree->tableInfo->tableOwnerName,
                     sParseTree->tableInfo->name,
                     sColumn->name)
                 != IDE_SUCCESS);
    }

    // related VIEW
    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTempTableInfo->name,
                 idlOS::strlen((SChar*)sTempTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    // BUG-11266
    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTempTableInfo->name,
                 idlOS::strlen((SChar*)sTempTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // BUG-16543
    IDE_TEST(qdnTrigger::setInvalidTriggerCache4Table(
                 sTempTableInfo)
             != IDE_SUCCESS);

    /* PROJ-1442 Replication Online  DDL 
     * Table Meta Log Record 
     */
    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( QCU_DDL_SUPPLEMENTAL_LOG == 1 ) )
    {
        if ( sPartitionCount > 0 )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sNewTableOIDArray = sNewPartitionOID;
            sTableOIDCount = sPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }

        //-----------------------------------------------------
        // PROJ-1442 Replication Online  DDL 
        // SYS_REPL_ITEMS_ TABLE_OID ÷ 
        //-----------------------------------------------------
        if ( sIsReplicatedTable == ID_TRUE )
        {
            IDE_TEST( qci::mCatalogReplicationCallback.mUpdateReplMetaTableOIDArray( aStatement,
                                                                                     sOldTableOIDArray,
                                                                                     sNewTableOIDArray,
                                                                                     sTableOIDCount )
                      != IDE_SUCCESS );
        }
        else
        {
            /* do nothing */
        }

        //-----------------------------------------------------
        //  PROJ-1442 Replication Online  DDL 
        //  Table Meta Log Record 
        //-----------------------------------------------------
        IDE_TEST( qciMisc::writeTableMetaLogForReplication( aStatement,
                                                            sOldTableOIDArray,
                                                            sNewTableOIDArray,
                                                            sTableOIDCount )
                  != IDE_SUCCESS );
    }
    else
    {
        /* do nothing */
    }

    // PROJ-2002 Column Security
    //  ÷   ⿡ ˸.
    sColumn = sParseTree->columns;

    while (sColumn != NULL)
    {
        if ( (sColumn->basicInfo->module->flag & MTD_ENCRYPT_TYPE_MASK)
             == MTD_ENCRYPT_TYPE_TRUE )
        {
            idlOS::strncpy(sColumn->name,
                           sColumn->namePos.stmtText +
                           sColumn->namePos.offset,
                           sColumn->namePos.size);

            // fix BUG-32700
            sColumn->name[sColumn->namePos.size] = '\0';

            (void) qcsModule::unsetColumnPolicy(
                sOldTableInfo->tableOwnerName,
                sOldTableInfo->name,
                sColumn->name );
        }
        else
        {
            // Nothing to do.
        }

        sColumn = sColumn->next;
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    IDU_FIT_POINT( "qdbAlter::executeDropCol::BUG-44230-2" );

    // PROJ-2264 Dictionary table
    for( sColumn  = sParseTree->columns;
         sColumn != NULL;
         sColumn  = sColumn->next )
    {
        if( (sColumn->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
            == SMI_COLUMN_COMPRESSION_TRUE )
        {
            sDicInfo = (qcmTableInfo *) smiGetTableRuntimeInfoFromTableOID(
                sColumn->basicInfo->column.mDictionaryTableOID );

            // Dictionary table 
            // BUG-36719
            // ⼭ ϸ ǵ  .
            // ϴ dictionary table   ̰,
            // Drop column ۾ ü ߱  dictionary table 
            //   ó  ʴ´.
            (void) qcmDictionary::dropDictionaryTable( aStatement,
                                                       sDicInfo );
        }
        else
        {
            // uncompression column
            // Nothing to do.
        }
    }

    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sTempTableInfo->tableOID),
                             0,
                             NULL );
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    if( sIsPartitioned == ID_TRUE )
    {
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );

        // old index table tableinfo 
        for ( sIndexTable = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_SESSION_TEMPORARY_TABLE_EXIST )
    {
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_TEMPORARY_TABLE_DDL_DISABLE ));
    }
    IDE_EXCEPTION(ERR_CANNOT_WRITE_REPL_INFO)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO));
    }
    IDE_EXCEPTION_END;

    if( sIsPartitioned == ID_TRUE )
    {
        if ( sNewPartitionInfoArr != NULL )
        {
            for ( i = 0; i < sPartitionCount; i++ )
            {
                (void)qcmPartition::destroyQcmPartitionInfo( sNewPartitionInfoArr[i] );
            }
        }

        for ( sIndexTable = sParseTree->newIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
        }
    }

    (void)qcm::destroyQcmTableInfo( sTempTableInfo );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeRenameCol(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... RENAME COLUMN ...  execution 
 *
 * Implementation :
 *    1. SYS_COLUMNS_  ÷ ̸  => updateColumnName
 *    2. ̺ ID, OID صα
 *    3. ش Column  Check Constraint Check Condition 
 *    4. related PSM  invalid · 
 *    5. related VIEW  invalid · 
 *    6. qcm::touchTable
 *    7. Ÿ ĳ 籸
 *
 ***********************************************************************/

    qdTableParseTree      * sParseTree;
    smSCN                   sSCN;
    UInt                    sTableID = 0;
    smOID                   sTableOID;
    qcmTableInfo          * sOldTableInfo = NULL;
    qcmTableInfo          * sNewTableInfo = NULL;
    void                  * sTableHandle;
    qcmPartitionInfoList  * sOldPartInfoList      = NULL;
    qcmPartitionInfoList  * sNewPartInfoList      = NULL;
    idBool                  sIsPartitioned        = ID_FALSE;
    qcmTableInfo         ** sNewIndexTableInfoArr = NULL;
    SChar                   sNewColumnName[ QC_MAX_OBJECT_NAME_LEN + 1 ];
    UInt                    sIndexTableCount = 0;
    qdIndexTableList      * sOldIndexTableList    = NULL;
    qdIndexTableList      * sIndexTable;
    qcmTableInfo          * sIndexTableInfo;
    qcmIndex              * sIndex;
    UInt                    i;
    UInt                    j;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    /* PROJ-2197 PSM Renewal */
    // related PSM
    IDE_TEST(qcmProc::relSetInvalidProcOfRelated(
        aStatement,
        sParseTree->tableInfo->tableOwnerID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    // PROJ-1073 Package
    IDE_TEST(qcmPkg::relSetInvalidPkgOfRelated(
        aStatement,
        sParseTree->tableInfo->tableOwnerID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sIsPartitioned = ID_TRUE;

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
        
        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Index Table List Ѵ.
        sOldIndexTableList = sParseTree->oldIndexTables;

        for ( sIndexTable = sOldIndexTableList;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            sIndexTableCount++;
        }
    }
    else
    {
        // Nothing to do.
    }

    IDE_TEST(updateColumnName( aStatement,
                               sParseTree->columns,        // old column
                               sParseTree->columns->next ) // new column
             != IDE_SUCCESS);

    // PROJ-1624 non-partitioned index
    // index table ÷̸ Ѵ.
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( i = 0; i < sOldTableInfo->indexCount; i++ )
        {
            sIndex = &(sOldTableInfo->indices[i]);

            if ( sIndex->indexPartitionType == QCM_NONE_PARTITIONED_INDEX )
            {
                for ( j = 0; j < sIndex->keyColCount; j++ )
                {
                    if ( sParseTree->columns->basicInfo->column.id ==
                         sIndex->keyColumns[j].column.id )
                    {
                        IDE_TEST( qdx::findIndexTableInList(
                                      sOldIndexTableList,
                                      sIndex->indexTableID,
                                      & sIndexTable )
                                  != IDE_SUCCESS );
                        
                        // oid, rid  2÷̻ ؾѴ.
                        IDE_TEST_RAISE( j + 2 >= sIndexTable->tableInfo->columnCount,
                                        ERR_META_CRASH );
                        
                        IDE_TEST( updateColumnName(
                                      aStatement,
                                      &(sIndexTable->tableInfo->columns[j]), // old column
                                      sParseTree->columns->next ) // new column
                                  != IDE_SUCCESS);
                        
                        break;
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
            }
            else
            {
                // Nothing to do.
            }
        }
    }
    else
    {
        // Nothing to do.
    }
        
    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    // BUG-21387 COMMENT
    QC_STR_COPY( sNewColumnName, sParseTree->columns->next->namePos );

    IDE_TEST(qdbComment::updateCommentColumn(
                 aStatement,
                 sParseTree->tableInfo->tableOwnerName,
                 sParseTree->tableInfo->name,
                 sParseTree->columns->name,
                 sNewColumnName )
             != IDE_SUCCESS);

    /* PROJ-1107 Check Constraint  */
    IDE_TEST( qdnCheck::renameColumnInCheckConstraint(
                        aStatement,
                        sParseTree->constraints,
                        sOldTableInfo,
                        sParseTree->columns,
                        sParseTree->columns->next )
              != IDE_SUCCESS );

    /* PROJ-1090 Function-based Index */
    IDE_TEST( renameColumnInDefaultExpression(
                  aStatement,
                  sParseTree->defaultExprColumns,
                  sParseTree->columns,
                  sParseTree->columns->next )
              != IDE_SUCCESS );
        
    // related VIEW
    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->tableInfo->tableOwnerID,
                 sParseTree->tableInfo->name,
                 idlOS::strlen((SChar*)sParseTree->tableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle)
             != IDE_SUCCESS);

    // BUG-11266
    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sNewTableInfo->tableOwnerID,
                 sNewTableInfo->name,
                 idlOS::strlen((SChar*)sNewTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // BUG-16543
    IDE_TEST(qdnTrigger::setInvalidTriggerCache4Table( sNewTableInfo )
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
        
        // PROJ-1624 non-partitioned index
        if ( sIndexTableCount > 0 )
        {
            IDE_TEST( aStatement->qmxMem->cralloc(
                          ID_SIZEOF(qcmTableInfo *) * sIndexTableCount,
                          (void **) & sNewIndexTableInfoArr )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }

        // PROJ-1624 non-partitioned index
        for ( sIndexTable = sOldIndexTableList, i = 0;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next, i++ )
        {
            sIndexTableInfo = sIndexTable->tableInfo;
            
            IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                                       sIndexTable->tableID,
                                       SMI_TBSLV_DDL_DML )
                      != IDE_SUCCESS );

            IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT(aStatement),
                                                 sIndexTable->tableID,
                                                 sIndexTable->tableOID)
                     != IDE_SUCCESS);
            
            IDE_TEST(qcm::getTableInfoByID(aStatement,
                                           sIndexTable->tableID,
                                           &(sNewIndexTableInfoArr[i]),
                                           &sSCN,
                                           &sTableHandle)
                     != IDE_SUCCESS);
        }
    }
    else
    {
        // Nothing to do.
    }

    // PROJ-1442 Table Meta Log Record 
    if(QCU_DDL_SUPPLEMENTAL_LOG == 1)
    {
        IDE_TEST(qci::mManageReplicationCallback.mWriteTableMetaLog(
                     aStatement,
                     sTableOID,
                     sTableOID)
                 != IDE_SUCCESS);
    }

    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
        
        // PROJ-1624 non-partitioned index
        for ( sIndexTable = sOldIndexTableList;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            sIndexTableInfo = sIndexTable->tableInfo;
            (void)qcm::destroyQcmTableInfo(sIndexTableInfo);
        }
    }
    else
    {
        // Nothing to do.
    }

    // BUG-26464 Table Info, Partition Info destroy  
    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    if ( sIsPartitioned == ID_TRUE )
    {
        if ( sNewIndexTableInfoArr != NULL )
        {
            for ( i = 0; i < sIndexTableCount; i++ )
            {
                (void)qcm::destroyQcmTableInfo( sNewIndexTableInfoArr[i] );
            }
        }
    }

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   sOldIndexTableList );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::updateColumnName(
    qcStatement * aStatement,
    qcmColumn   * aOldColumn,
    qcmColumn   * aNewColumn)
{
/***********************************************************************
 *
 * Description :
 *      ALTER TABLE ... RENAME COL  executeRenameCol κ ȣ,
 *                 SYS_COLUMNS_ Ÿ ̺  
 *
 * Implementation :
 *      1. SYS_COLUMNS_ Ÿ ̺  
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeRenameCol"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    SChar     * sSqlStr;
    SChar       sColumnName[ QC_MAX_OBJECT_NAME_LEN + 1 ];
    vSLong      sRowCnt;

    QC_STR_COPY( sColumnName, aNewColumn->namePos );

    IDU_FIT_POINT( "qdbAlter::updateColumnName::alloc::sSqlStr",
                    idERR_ABORT_InsufficientMemory );

    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_COLUMNS_ SET COLUMN_NAME = '%s' "
                     "WHERE COLUMN_ID = INTEGER'%"ID_INT32_FMT"'",
                     sColumnName,
                     aOldColumn->basicInfo->column.id);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    IDE_TEST_RAISE(sRowCnt != 1, ERR_META_CRASH);

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::updateCheckCondition(
    qcStatement * aStatement,
    UInt          aConstraintID,
    SChar       * aCheckCondition )
{
/***********************************************************************
 *
 * Description :
 *  ALTER TABLE ... RENAME COLUMN  Լ.
 *  SYS_CONSTRAINTS_ Ÿ ̺ CHECK_CONDITION ÷ Ѵ.
 *
 * Implementation :
 *  1. ڿ Meta ֱ  ȯ
 *  2. CONSTRAINT_ID شϴ Check Constraint CHECK_CONDITION ÷ 
 *
 ***********************************************************************/

    SChar     * sStrForMeta = NULL;
    SChar     * sSqlStr     = NULL;
    vSLong      sRowCnt;

    IDE_TEST( qdbCommon::getStrForMeta( aStatement,
                                        aCheckCondition,
                                        idlOS::strlen( aCheckCondition ),
                                        &sStrForMeta )
              != IDE_SUCCESS );

    IDE_TEST( STRUCT_ALLOC_WITH_SIZE( aStatement->qmxMem,
                                      SChar,
                                      QD_MAX_SQL_LENGTH,
                                      &sSqlStr )
              != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_CONSTRAINTS_ SET CHECK_CONDITION = '%s' "
                     "WHERE CONSTRAINT_ID = INTEGER'%"ID_INT32_FMT"'",
                     sStrForMeta,
                     aConstraintID );

    IDE_TEST( qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                 sSqlStr,
                                 &sRowCnt )
              != IDE_SUCCESS );

    IDE_TEST_RAISE( sRowCnt != 1, ERR_META_CRASH );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_META_CRASH )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QCM_META_CRASH ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::findDelIndexAndDelMeta(
    qcStatement  * aStatement,
    qcmTableInfo * aTableInfo,
    qcmColumn    * aDelColumn )
/***********************************************************************
 *
 * Description :
 *       DropϷ ÷ Ű÷  ִ ε
 *       Ǳ   ε Ÿ ̺ Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/
{
    qcmIndex * sIndexInfo;
    UInt       sDelIndexID = 0;
    UInt       i, j;

    for (i = 0; i < aTableInfo->indexCount; i++)
    {
        sIndexInfo = &(aTableInfo->indices[i]);

        for (j = 0; j < sIndexInfo->keyColCount; j++)
        {
            if ( qdbCommon::findColumnIDInColumnList(
                     aDelColumn,
                     sIndexInfo->keyColumns[j].column.id ) == ID_TRUE )
            {
                sDelIndexID = sIndexInfo->indexId;
                
                // SYS_PART_INDICES_
                // SYS_INDEX_PARTITIONS_
                // SYS_PART_KEY_COLUMNS_
                IDE_TEST( deletePartIndexFromMeta( aStatement,
                                                   sDelIndexID )
                          != IDE_SUCCESS );
                
                break;
            }
            else
            {
                // Nothing to do.
            }
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::deleteColInfo( qcStatement      * aStatement,
                                qdTableParseTree * aParseTree,
                                qcmTableInfo     * aTableInfo,
                                qcmColumn        * aNewTableColumns,
                                mtcColumn        * aMtcColumns,
                                UInt             * aDelColumnID,
                                SInt               aColumnCount )
{
/***********************************************************************
 *
 * Description :
 *      ALTER TABLE ... DROP COL  executeDropCol Լκ ȣ
 *
 * Implementation :
 *      1. drop  ʴ ÷θ aNewTableColumns 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::deleteColInfo"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qcmColumn * sSrcColumn;
    qcmColumn * sDstColumn;

    SInt        i,j;
    UInt        sRemoveID   = 0;
    SInt        sTableID;
    SInt        sCurrentOffset;

    i = j = 0;
    sSrcColumn = aTableInfo->columns;

    sTableID = aTableInfo->columns->basicInfo->column.id /
        SMI_COLUMN_ID_MAXIMUM;

    if ( smiTableSpace::isMemTableSpaceType( aTableInfo->TBSType ) == ID_TRUE )
    {
        sCurrentOffset = smiGetRowHeaderSize(SMI_TABLE_MEMORY);
    }
    else if ( smiTableSpace::isVolatileTableSpaceType( aTableInfo->TBSType ) == ID_TRUE )
    {
        sCurrentOffset = smiGetRowHeaderSize(SMI_TABLE_VOLATILE);
    }
    else
    {
        IDE_DASSERT( smiTableSpace::isDiskTableSpaceType( aTableInfo->TBSType ) == ID_TRUE );

        sCurrentOffset = 0;
    }

    while (sSrcColumn != NULL)
    {
        // columns to be excluded.
        sDstColumn = aParseTree->columns;
        while ( sDstColumn != NULL)
        {
            if ( idlOS::strMatch( sSrcColumn->name,
                                  (SInt) idlOS::strlen(sSrcColumn->name),
                                  sDstColumn->namePos.stmtText + sDstColumn->namePos.offset,
                                  sDstColumn->namePos.size ) == 0 )
            {
                break;
            }

            sDstColumn = sDstColumn->next;
        }

        if (sDstColumn != NULL)
        { // this column has to be excluded.
            
            // BUG-44814 ŵ ÷ id ˾Ƴ.
            aDelColumnID[j] = sRemoveID;
            ++j;

            ++sRemoveID;
            sSrcColumn = sSrcColumn->next;
            continue;
        }
        else
        {
            idlOS::memcpy(&aNewTableColumns[i], sSrcColumn,
                          ID_SIZEOF(qcmColumn));
            idlOS::memcpy(&aMtcColumns[i],
                          sSrcColumn->basicInfo, ID_SIZEOF(mtcColumn));
            aNewTableColumns[i].basicInfo = &aMtcColumns[i];
            aMtcColumns[i].column.id = sTableID * SMI_COLUMN_ID_MAXIMUM + i;

            // fix BUG-14204
            if( sSrcColumn->defaultValueStr != NULL )
            {
                IDU_FIT_POINT( "qdbAlter::deleteColInfo::alloc::defaultValue",
                                idERR_ABORT_InsufficientMemory );

                IDE_TEST( STRUCT_ALLOC( aStatement->qmxMem,
                                        qtcNode,
                                        &(aNewTableColumns[i].defaultValue))
                          != IDE_SUCCESS);
            }
            else
            {
                // Nothing To Do
            }

            // PROJ-1579 NCHAR
            // old column default value ̹ Ÿ ̺ Ǿ 
            aNewTableColumns[i].ncharLiteralPos = NULL;

            sSrcColumn = sSrcColumn->next;
            if (i == aColumnCount -1)
            {
                aNewTableColumns[i].next = NULL;
            }
            else
            {
                aNewTableColumns[i].next = &aNewTableColumns[i+1];
            }
            i++;
            ++sRemoveID;
        }
    }

    IDE_TEST( qdbCommon::setColListOffset( aStatement->qmxMem,
                                           aNewTableColumns,
                                           sCurrentOffset )
              != IDE_SUCCESS );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeRenameTable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... RENAME TO ..., RENAME ... TO ...  execution 
 *
 * Implementation :
 *    1. SYS_TABLES_  ̺ ̸  => qdbCommon::updateTableSpecFromMeta
 *    2. ̺ ID, OID صα
 *    3. related PSM  invalid · 
 *    4. related VIEW  invalid · 
 *    5. qcm::touchTable
 *    6. Ÿ ĳ 籸
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeRenameTable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree     * sParseTree       = NULL;
    UInt                   sTableID         = 0;
    smOID                  sTableOID        = SM_OID_NULL;
    qcmTableInfo         * sOldTableInfo    = NULL;
    qcmTableInfo         * sTempTableInfo   = NULL;
    void                 * sTableHandle     = NULL;
    smSCN                  sSCN             = SM_SCN_INIT;
    SChar                  sNewTableName[ QC_MAX_OBJECT_NAME_LEN + 1 ];

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;

    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->newTableName,
                 sParseTree->tableInfo->tableID,
                 smiGetTableId(sParseTree->tableInfo->tableHandle),
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    // BUG-21387 COMMENT
    QC_STR_COPY( sNewTableName, sParseTree->newTableName );

    IDE_TEST(qdbComment::updateCommentTable(
                 aStatement,
                 sParseTree->tableInfo->tableOwnerName,
                 sParseTree->tableInfo->name,
                 sNewTableName )
             != IDE_SUCCESS);

    // PROJ-2223 audit
    IDE_TEST( qcmAudit::updateObjectName(
                  aStatement,
                  sParseTree->tableInfo->tableOwnerID,
                  sParseTree->tableInfo->name,
                  sNewTableName )
              != IDE_SUCCESS );
    
    /* PROJ-2197 PSM Renewal */
    // related PSM
    IDE_TEST(qcmProc::relSetInvalidProcOfRelated(
        aStatement,
        sParseTree->tableInfo->tableOwnerID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    // PROJ-1073 Package
    IDE_TEST( qcmPkg::relSetInvalidPkgOfRelated(
            aStatement,
            sParseTree->tableInfo->tableOwnerID,
            sParseTree->tableInfo->name,
            idlOS::strlen((SChar*)sParseTree->tableInfo->name),
            QS_TABLE ) != IDE_SUCCESS );

    // related VIEW
    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->tableInfo->tableOwnerID,
                 sParseTree->tableInfo->name,
                 idlOS::strlen((SChar*)sParseTree->tableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable( QC_SMI_STMT( aStatement ),
                              sTableID,
                              SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sTableOID)
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sTempTableInfo,
                                   &sSCN,
                                   &sTableHandle)
             != IDE_SUCCESS);

    // BUG-11266
    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sTempTableInfo->tableOwnerID,
                 sTempTableInfo->name,
                 idlOS::strlen((SChar*)sTempTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // PROJ-1442 Table Meta Log Record 
    if(QCU_DDL_SUPPLEMENTAL_LOG == 1)
    {
        IDE_TEST(qci::mManageReplicationCallback.mWriteTableMetaLog(
                                                                aStatement,
                                                                sTableOID,
                                                                sTableOID)
                 != IDE_SUCCESS);
    }
    
    IDE_TEST(qdnTrigger::executeRenameTable( aStatement, sTempTableInfo )
             != IDE_SUCCESS);

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sTempTableInfo );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   NULL,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeSetDefault(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN (... SET DEFAULT ...)  execution 
 *
 * Implementation :
 *    1. set SYSDATE => qtc::sysdate
 *    2. õ  ش ÷   Ÿ ȯ  ִ 
 *       üũ , ȯ => qdbCommon::convertDefaultValueType
 *    3. SYS_COLUMNS_  Ʈ   => updateColumnSpecDefault
 *    4. related PSM  invalid · 
 *    5. qcm::touchTable
 *    6. Ÿ ĳ 籸
 *
 * Replication ɸ Table  DDL , ߰ Ʒ ۾ Ѵ.
 *    1. Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeSetDefault"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree    * sParseTree;
    UInt                  sTableID;
    smOID                 sTableOID;
    qcmTableInfo        * sOldTableInfo = NULL;
    SChar               * sDefaultValueStr;

    // PROJ-1579 NCHAR
    UInt              sAddSize = 0;
    SChar           * sDefValBuffer = NULL;
    qcNamePosList   * sNcharList = NULL;
    qcNamePosition    sNamePos;
    UInt              sBufferSize = 0;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;
    void                 * sNewTableHandle  = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( qtc::setDatePseudoColumn( QC_PRIVATE_TMPLATE( aStatement ) ) != IDE_SUCCESS );

    // PROJ-1407 Temporary table
    // session temporary table ϴ  DDL   .
    IDE_TEST_RAISE( qcuTemporaryObj::existSessionTable( sOldTableInfo ) == ID_TRUE,
                    ERR_SESSION_TEMPORARY_TABLE_EXIST );

    /* PROJ-1442 Replication Online  DDL 
     * Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
     */
    if(sOldTableInfo->replicationCount > 0)
    {
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 0, 
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );
    }

    IDE_TEST(qdbCommon::convertDefaultValueType(
                 aStatement,
                 &sParseTree->columns->basicInfo->type,
                 sParseTree->columns->defaultValue,
                 NULL)
             != IDE_SUCCESS);

    // PROJ-1579 NCHAR
    // NCHAR LITERAL => UNICODE LITERAL κ ó
    if( sParseTree->ncharList != NULL )
    {
        for( sNcharList = sParseTree->ncharList;
             sNcharList != NULL;
             sNcharList = sNcharList->next )
        {
            sNamePos = sNcharList->namePos;

            // U Ÿ ȯϸ鼭 þ  
            sAddSize += (sNamePos.size - 3) * 2;
        }

        sBufferSize = sParseTree->columns->defaultValue->position.size +
                      sAddSize;

        IDU_LIMITPOINT("qdbAlter::executeSetDefault::malloc");
        IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                        SChar,
                                        sBufferSize,
                                        & sDefValBuffer)
                 != IDE_SUCCESS);

        IDE_TEST( qdbCommon::convertToUTypeString(
                      aStatement,
                      sParseTree->columns->defaultValue->position.offset,
                      sParseTree->columns->defaultValue->position.size,
                      sParseTree->ncharList,
                      sDefValBuffer,
                      sBufferSize )
                  != IDE_SUCCESS );

        IDE_TEST(qdbCommon::getStrForMeta(
                     aStatement,
                     sDefValBuffer,
                     idlOS::strlen( sDefValBuffer ),
                     &sDefaultValueStr)
                 != IDE_SUCCESS);
    }
    else
    {
        IDE_TEST(qdbCommon::getStrForMeta(
                     aStatement,
                     sParseTree->columns->defaultValue->position.stmtText +
                     sParseTree->columns->defaultValue->position.offset,
                     sParseTree->columns->defaultValue->position.size,
                     &sDefaultValueStr)
                 != IDE_SUCCESS);
    }

    sParseTree->columns->defaultValueStr = (UChar*)sDefaultValueStr;

    IDE_TEST(updateColumnSpecDefault(aStatement,
                                     sParseTree->columns)
             != IDE_SUCCESS);
    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sNewTableInfo->tableOID),
                             0,
                             NULL );
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_SESSION_TEMPORARY_TABLE_EXIST )
    {
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_TEMPORARY_TABLE_DDL_DISABLE ));
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::moveRow( qcStatement      * aStatement,
                          qmsTableRef      * aTableRef,
                          qcmTableInfo     * aTableInfo,
                          const void       * aSrcTable,
                          const void       * aDstTable,
                          qcmColumn        * aSrcTblColumn,
                          qcmColumn        * aDstTblColumn,
                          qcmTableInfo     * aNewTableInfo,
                          qdIndexTableList * aNewIndexTables,
                          idBool             aIsNeedUndoLog )
{
/***********************************************************************
 *
 * Description :
 *    aSrcTable  ͸ aDstTable  ű
 *
 *    ƷԼ ȣ.
 *    qdbAlter::executeAddCol()
 *    qdbAlter::executeDropCol()
 *
 * Implementation :
 *    1. smiTable::backupTableForAlterTable
 *    2. ...
 *    3. smiTable::restoreTableForAlterTable
 *    4. smiTable::dropTable
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::moveRow()"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::moveRow()"));

    SChar             * sNullRowValue;
    const void        * sOldRow;
    smiValue          * sNewRow;
    smiValue          * sNullRow;
    smiColumnList     * sSrcColumnList      = NULL;
    smiColumnList     * sBothColumnList     = NULL;
    smiColumnList     * sColumnPtr          = NULL;
    qdbConvertContext * sConvertContextList = NULL;
    qdbConvertContext * sConvertContextPtr  = NULL;
    SInt                sColumnCount = 0;
    UInt                sColumnOrder;
    UInt                sArguCount;
    mtcColumn         * sValueColumn;
    mtvConvert        * sConvert;
    qcmColumn         * sDestCol;
    qcmColumn         * sSrcCol;
    qcmColumn         * sLastCol;
    void              * sValue;
    void              * sCanonizedValue;
    smOID               sTableOID = SMI_NULL_OID;
    UInt                sTableType;
    SInt                sStage = 0;
    smiTableCursor      sSrcTblCursor;
    smiTableCursor      sDstTblCursor;
    smiTableCursor      sDictionaryDstTblCursor;
    mtcEncryptInfo      sEncryptInfo;

    iduMemoryStatus     sQmxMemStatus;

    UInt                sPartitionedTupleRowOffset = 0;
    UInt                sDiskRowSize               = 0;
    scGRID              sRowGRID;
    smiCursorProperties sSrcCursorProperty;
    smiCursorProperties sDstCursorProperty;

    qmxLobInfo        * sLobInfo = NULL;
    void              * sInsRow;
    scGRID              sInsGRID;

    UInt                sLastColumnSize;
    UInt                sSrcColCount = 0;
    UInt                sSrcLobColCount = 0;
    smiFetchColumnList *sSrcFetchColumnList = NULL;
    UInt                sStoringSize = 0;
    void               *sStoringValue;
    void              * sValueTemp;

    qdIndexTableCursors sIndexTableCursorInfo;
    idBool              sInitedCursorInfo = ID_FALSE;
    smOID               sPartOID          = SMI_NULL_OID;

    /* PROJ-1090 Function-based Index */
    idBool              sHasDefaultExpr = ID_FALSE;
    qcmColumn         * sNewColumns = NULL;

    // PROJ-2264 Dictionary table
    const void        * sDicTableHandle;
    void              * sRow;
    smOID             * sRowOID;

    // PROJ-2429 Dictionary based data compress for on-disk DB
    UInt     sNonStoringSize;
    smiValue sValue4Disk;

    qcmTableInfo      * sSrcTableInfo = NULL;

    qdbCallBackInfo     sCallBackInfo = {
        & sQmxMemStatus,
        aStatement->qmxMem,
        QC_PRIVATE_TMPLATE(aStatement),
        aTableInfo,
        NULL,
        NULL,
        NULL,
        ID_FALSE,
        NULL,
        NULL,
        NULL,
        aStatement,
        aSrcTblColumn,
        aDstTblColumn,
        NULL,
        0
    };

    smiAlterTableCallBack sCallBack = {
        (void*) & sCallBackInfo,
        qdbAlter::initializeConvert,
        qdbAlter::finalizeConvert,
        qdbAlter::convertSmiValue,
        qdbAlter::calculateSmiValueArray,
        qdbAlter::printProgressLog
    };

    /* PROJ-2464 hybrid partitioned table 
     *  - Move  SrcTable  Move Row ϱ ؼ, sSrcTableInfo->tableFlag  ̿Ѵ.
     */
    IDE_TEST( smiGetTableTempInfo( aSrcTable,
                                   (void**)&( sSrcTableInfo ) )
              != IDE_SUCCESS );

    sTableType = sSrcTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    // BUG-42920 DDL display data move progress
    if( aTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sCallBackInfo.partitionInfo = sSrcTableInfo;
    }
    else
    {
        // nothing to do
    }
    
    //-----------------------------------------
    // src table  smiColumnList 
    //-----------------------------------------

    for( sSrcCol = aSrcTblColumn; sSrcCol != NULL; sSrcCol = sSrcCol->next )
    {
        sSrcColCount++;

        if ( (sSrcCol->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
             == SMI_COLUMN_TYPE_LOB )
        {
            sSrcLobColCount++;
        }
    }

    if ( ( sTableType == SMI_TABLE_MEMORY ) ||
         ( sTableType == SMI_TABLE_VOLATILE ) )
    {
        /* ------------------------------------------------
         * create OLD table(*.TBL) file
         * free OLD table fixed/variable pagelist only
         * ----------------------------------------------*/

        sTableOID = smiGetTableId(aSrcTable);

        IDE_TEST(smiTable::backupTableForAlterTable(
                     QC_SMI_STMT( aStatement ),
                     aSrcTable,
                     aDstTable,
                     aStatement->mStatistics) != IDE_SUCCESS);
    }
    else
    {
        //-----------------------------
        // ũ ̺
        //-----------------------------

        // PROJ-1362
        // lob-locator   ҴѴ.
        IDE_TEST( qmx::initializeLobInfo(
                      aStatement,
                      & sLobInfo,
                      (UShort) sSrcLobColCount )
                  != IDE_SUCCESS );

        // Disk Table 
        // Record Read   ҴѴ.

        // PROJ-1877
        // aSrcTable tableInfo ̹  찡 ־
        // aSrcTblColumn ̿Ͽ row size ´.
        IDE_TEST( qdbCommon::getDiskRowSize( aSrcTblColumn,
                                             & sDiskRowSize )
                  != IDE_SUCCESS );

        // To fix BUG-14820
        // Disk-variable ÷ rid񱳸  ʱȭ ؾ .
        IDU_LIMITPOINT("qdbAlter::moveRow::malloc1");
        IDE_TEST( aStatement->qmxMem->cralloc( sDiskRowSize,
                                               (void **) & sOldRow )
                  != IDE_SUCCESS );
        sSrcTblCursor.initialize();
        sDstTblCursor.initialize();

        //-------------------------------------------
        // open src table. ( select )
        // cursor property .
        //
        // PROJ-1705
        // fetch column list  ؼ sm .
        //-------------------------------------------

        SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sSrcCursorProperty, aStatement->mStatistics );
        sSrcCursorProperty.mLockWaitMicroSec = 0;

        IDE_TEST( qdbCommon::makeFetchColumnList( QC_PRIVATE_TMPLATE(aStatement),
                                                  sSrcColCount,
                                                  aSrcTblColumn,
                                                  ID_TRUE,   // alloc smiColumnList
                                                  & sSrcFetchColumnList )
              != IDE_SUCCESS );

        sSrcCursorProperty.mFetchColumnList = sSrcFetchColumnList;

        IDE_TEST(
            sSrcTblCursor.open(
                QC_SMI_STMT( aStatement ),
                aSrcTable,
                NULL,
                smiGetRowSCN(aSrcTable),
                NULL,
                smiGetDefaultKeyRange(),
                smiGetDefaultKeyRange(),
                smiGetDefaultFilter(),
                SMI_LOCK_READ|
                SMI_TRAVERSE_FORWARD|
                SMI_PREVIOUS_DISABLE,
                SMI_SELECT_CURSOR,
                & sSrcCursorProperty )
            != IDE_SUCCESS);
        sStage = 1;

        //-------------------------------------------
        // open destination table. ( insert )
        // cursor property .
        //-------------------------------------------

        SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sDstCursorProperty, aStatement->mStatistics );

        sDstCursorProperty.mIsUndoLogging = aIsNeedUndoLog;

        IDE_TEST(
            sDstTblCursor.open(
                QC_SMI_STMT( aStatement ),
                aDstTable,
                NULL,
                smiGetRowSCN(aDstTable),
                NULL,
                smiGetDefaultKeyRange(),
                smiGetDefaultKeyRange(),
                smiGetDefaultFilter(),
                SMI_LOCK_WRITE|
                SMI_TRAVERSE_FORWARD|
                SMI_PREVIOUS_DISABLE,
                SMI_INSERT_CURSOR,
                & sDstCursorProperty )
            != IDE_SUCCESS);
        sStage += 2;
    }

    /* ------------------------------------------------
     * make new row values
     * ----------------------------------------------*/
    sColumnCount = 0;
    sDestCol = aDstTblColumn;
    sLastCol = aDstTblColumn;

    while (sDestCol != NULL)
    {
        if( sDestCol->basicInfo->column.offset >
            sLastCol->basicInfo->column.offset )
        {
            sLastCol = sDestCol;
        }
        sColumnCount ++;
        sDestCol = sDestCol->next;
    }

    IDU_LIMITPOINT("qdbAlter::moveRow::malloc2");
    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiValue) *
                                       sColumnCount,
                                       (void**)&sNewRow)
             != IDE_SUCCESS);

    IDU_LIMITPOINT("qdbAlter::moveRow::malloc3");
    IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiValue) *
                                       sColumnCount,
                                       (void**)&sNullRow)
             != IDE_SUCCESS);

    // PROJ-2264 Dictionary table
    if( (sLastCol->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
        == SMI_COLUMN_COMPRESSION_FALSE )
    {
        sLastColumnSize = sLastCol->basicInfo->module->nullValueSize();
    }
    else
    {
        sLastColumnSize = idlOS::align8( ID_SIZEOF(smOID) );
    }

    IDU_LIMITPOINT("qdbAlter::moveRow::malloc4");
    IDE_TEST(aStatement->qmxMem->alloc(
                 sLastCol->basicInfo->column.offset + sLastColumnSize,
                 (void**)&sNullRowValue )
             != IDE_SUCCESS);

    sDestCol = aDstTblColumn;

    while (sDestCol != NULL)
    {
        sColumnOrder = (sDestCol->basicInfo->column.id & SMI_COLUMN_ID_MASK);
        sSrcCol = aSrcTblColumn;
        while (sSrcCol != NULL)
        {
            if ( idlOS::strMatch( sSrcCol->name,
                                  idlOS::strlen( sSrcCol->name ),
                                  sDestCol->name,
                                  idlOS::strlen( sDestCol->name ) ) == 0 )
            {
                break;
            }
            else
            {
                sSrcCol = sSrcCol->next;
            }
        }

        //------------------------------
        // make null row
        //------------------------------

        // PROJ-1877
        // modify column   null Ͽ ο type
        // null  ʿϰ Ǿ  dest column  null value
        // Ѵ.

        // PROJ-2264 Dictionary table
        // Compression column  null   dictionary table  ϴ
        // null row  smOID   Ѵ.
        if( (sDestCol->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
            == SMI_COLUMN_COMPRESSION_FALSE )
        {
            // Variable column ؼ smiValue.vlaue NULL ҴѴ.
            if( ( sDestCol->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK )
                != SMI_COLUMN_TYPE_FIXED )
            {
                sNullRow[sColumnOrder].value = NULL;
                sNullRow[sColumnOrder].length = 0;
            }
            else
            {
                // PROJ-1705
                sValueTemp = (void*)mtc::value( sDestCol->basicInfo,
                                                sNullRowValue,
                                                MTD_OFFSET_USE );
                
                sDestCol->basicInfo->module->null( (sDestCol->basicInfo),
                                                   sValueTemp );

                IDE_TEST( qdbCommon::mtdValue2StoringValue(
                              sDestCol->basicInfo,
                              sDestCol->basicInfo,
                              sValueTemp,
                              &sStoringValue )
                          != IDE_SUCCESS );
                sNullRow[sColumnOrder].value = sStoringValue;

                IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                  sDestCol->basicInfo,
                                                  sValueTemp,
                                                  &sStoringSize )
                          != IDE_SUCCESS );
                sNullRow[sColumnOrder].length = sStoringSize;
            }
        }
        else
        {
            // PROJ-2264 Dictionary table
            // ⼭ ã Null  dictionary table  Null row  ִ ̴.
            //  ϴ ÷     ʰ,
            //  ߰ϴ ÷    dictionary table  insert ϰ
            //  OID  data table  ִ´.
            //
            // Compression column  mtc::value    OID  о dictionary table  ִ  о Ѵ.
            //  dictionary table  ְ,  ̷ о  ʿ  null value  sNullRow  ä ǹǷ
            //  ּ  Ѵ.
            sValue = sNullRowValue + sDestCol->basicInfo->column.offset;

            sDestCol->basicInfo->module->null( (sDestCol->basicInfo),
                                               sValue );

            IDE_TEST( qdbCommon::mtdValue2StoringValue(
                          sDestCol->basicInfo,
                          sDestCol->basicInfo,
                          sValue,
                          &sStoringValue )
                      != IDE_SUCCESS );
            sNullRow[sColumnOrder].value = sStoringValue;

            IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                              sDestCol->basicInfo,
                                              sValue,
                                              &sStoringSize )
                      != IDE_SUCCESS );
            sNullRow[sColumnOrder].length = sStoringSize;
        }

        if (sSrcCol != NULL)
        {
            /* ------------------------------------------------
             * NEW/OLD Table   smiColumnList
             * ----------------------------------------------*/

            if (sBothColumnList == NULL)
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc5");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiColumnList),
                                                   (void**)&sBothColumnList)
                         != IDE_SUCCESS);

                sColumnPtr = sBothColumnList;
            }
            else
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc6");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiColumnList),
                                                   (void**)&(sColumnPtr->next))
                         != IDE_SUCCESS);

                sColumnPtr = sColumnPtr->next;
            }

            sColumnPtr->column = (smiColumn *)&(sSrcCol->basicInfo->column);
            sColumnPtr->next   = NULL;

            /* ------------------------------------------------
             * NEW/OLD Table   column  convert list
             * ----------------------------------------------*/

            if (sConvertContextList == NULL)
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc7");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qdbConvertContext),
                                                   (void**)&sConvertContextList)
                         != IDE_SUCCESS);

                sConvertContextPtr = sConvertContextList;
            }
            else
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc8");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(qdbConvertContext),
                                                   (void**)&(sConvertContextPtr->next))
                         != IDE_SUCCESS);

                sConvertContextPtr = sConvertContextPtr->next;
            }

            // PROJ-1877
            // src column dest column  ٸ type 
            // convert context Ѵ.
            IDE_TEST( makeConvertContext( aStatement,
                                          sSrcCol->basicInfo,
                                          sDestCol->basicInfo,
                                          sConvertContextPtr )
                      != IDE_SUCCESS );

            sConvertContextPtr->next = NULL;
        }
        else
        {
            /* ------------------------------------------------
             * NEW شϴ smiColumnList
             * ----------------------------------------------*/

            // this column is a new added column.
            if (sDestCol->defaultValue == NULL) // set NULL for added column
            {
                // make new row
                if( ( sDestCol->basicInfo->flag & MTC_COLUMN_TIMESTAMP_MASK )
                    == MTC_COLUMN_TIMESTAMP_FALSE )
                {
                    sNewRow[sColumnOrder].length =
                        sNullRow[sColumnOrder].length;
                    sNewRow[sColumnOrder].value  =
                        sNullRow[sColumnOrder].value;
                }
                else
                {
                    // set timestamp
                    IDU_LIMITPOINT("qdbAlter::moveRow::malloc9");
                    IDE_TEST(aStatement->qmxMem->alloc(
                                 MTD_BYTE_TYPE_STRUCT_SIZE(
                                     QC_BYTE_PRECISION_FOR_TIMESTAMP
                                     ),
                                 &sValue)
                             != IDE_SUCCESS);

                    ((mtdByteType*)sValue)->length = QC_BYTE_PRECISION_FOR_TIMESTAMP;

                    IDE_TEST( qmx::setTimeStamp( ((mtdByteType*)sValue)->value ) != IDE_SUCCESS );

                    IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                      sDestCol->basicInfo,
                                                      sValue,
                                                      &sStoringSize )
                              != IDE_SUCCESS );
                    sNewRow[sColumnOrder].length = sStoringSize;

                    IDE_TEST( qdbCommon::mtdValue2StoringValue( sDestCol->basicInfo,
                                                      sDestCol->basicInfo,
                                                      sValue,
                                                      &sStoringValue )
                              != IDE_SUCCESS );
                    sNewRow[sColumnOrder].value  = sStoringValue;
                }
            }
            else
            {
                /* PROJ-1090 Function-based Index */
                if ( (sDestCol->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
                     == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
                {
                    sNewRow[sColumnOrder].length =
                        sNullRow[sColumnOrder].length;
                    sNewRow[sColumnOrder].value  =
                        sNullRow[sColumnOrder].value;
                    
                    if ( sHasDefaultExpr != ID_TRUE )
                    {
                        sHasDefaultExpr = ID_TRUE;

                        /* ߰Ǵ ù ÷  */
                        sNewColumns = sDestCol;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else // set DEFAULT value for added column
                {
                    // make default value
                    // Sequence Value ӽ 
                    IDE_TEST( qmx::dummySequenceNextVals(
                                  aStatement,
                                  aStatement->myPlan->parseTree->nextValSeqs )
                              != IDE_SUCCESS );

                    IDE_TEST(qtc::calculate(sDestCol->defaultValue,
                                            QC_PRIVATE_TMPLATE(aStatement)) != IDE_SUCCESS);
                    sValueColumn =
                        &( QC_PRIVATE_TMPLATE(aStatement)->tmplate.
                           rows[sDestCol->defaultValue->node.table].
                           columns[sDestCol->defaultValue->node.column]);

                    // check conversion
                    /* PROJ-1361 : data type language module и */

                    if (sDestCol->basicInfo->type.dataTypeId ==
                        sValueColumn->type.dataTypeId )
                    {
                        // same type
                        sValue = QC_PRIVATE_TMPLATE(aStatement)->tmplate.stack[0].value;
                    }
                    else
                    {
                        // convert
                        sArguCount =
                            sValueColumn->flag & MTC_COLUMN_ARGUMENT_COUNT_MASK;

                        IDE_TEST(mtv::estimateConvert4Server(
                                     aStatement->qmxMem,
                                     &sConvert,
                                     sDestCol->basicInfo->type,     //aDestinationType
                                     sValueColumn->type,            //aSourceType
                                     sArguCount,                    // aSourceArgument
                                     sValueColumn->precision,       // aSourcePrecision
                                     sValueColumn->scale,           // aSourceScale
                                     & QC_PRIVATE_TMPLATE(aStatement)->tmplate) // mtcTemplate* :
                                 // for passing session
                                 // dateFormat
                                 != IDE_SUCCESS);

                        // source value pointer
                        sConvert->stack[sConvert->count].value =
                            QC_PRIVATE_TMPLATE(aStatement)->tmplate.stack[0].value;

                        // destination value pointer
                        sValueColumn = sConvert->stack[0].column;
                        sValue       = sConvert->stack[0].value;

                        IDE_TEST(
                            mtv::executeConvert( sConvert,
                                                 &QC_PRIVATE_TMPLATE(aStatement)->tmplate )
                            != IDE_SUCCESS);
                    }

                    // PROJ-2002 Column Security
                    if ( ( sDestCol->basicInfo->module->flag & MTD_ENCRYPT_TYPE_MASK )
                         == MTD_ENCRYPT_TYPE_TRUE )
                    {
                        IDE_TEST( qcsModule::getEncryptInfo( aStatement,
                                                             aTableInfo,
                                                             sDestCol,
                                                             & sEncryptInfo )
                                  != IDE_SUCCESS );
                    }
                    else
                    {
                        // Nothing to do.
                    }

                    // canonize
                    if ( ( sDestCol->basicInfo->module->flag & MTD_CANON_MASK )
                         == MTD_CANON_NEED )
                    {
                        sCanonizedValue = sValue;

                        IDE_TEST( sDestCol->basicInfo->module->canonize(
                                      sDestCol->basicInfo,
                                      & sCanonizedValue,           // canonized value
                                      & sEncryptInfo,
                                      sValueColumn,
                                      sValue,                     // original value
                                      NULL,
                                      & QC_PRIVATE_TMPLATE(aStatement)->tmplate )
                                  != IDE_SUCCESS );

                        sValue = sCanonizedValue;
                    }
                    else if ( (sDestCol->basicInfo->module->flag & MTD_CANON_MASK)
                              == MTD_CANON_NEED_WITH_ALLOCATION )
                    {
                        IDU_LIMITPOINT("qdbAlter::moveRow::malloc10");
                        IDE_TEST(aStatement->qmxMem->alloc(
                                     sDestCol->basicInfo->column.size,
                                     (void**)&sCanonizedValue)
                                 != IDE_SUCCESS);

                        IDE_TEST( sDestCol->basicInfo->module->canonize(
                                      sDestCol->basicInfo,
                                      & sCanonizedValue,           // canonized value
                                      & sEncryptInfo,
                                      sValueColumn,
                                      sValue,                     // original value
                                      NULL,
                                      & QC_PRIVATE_TMPLATE(aStatement)->tmplate )
                                  != IDE_SUCCESS );

                        sValue = sCanonizedValue;
                    }
                    else
                    {
                        // Nothing to do.
                    }

                    sColumnOrder = (sDestCol->basicInfo->column.id &
                                    SMI_COLUMN_ID_MASK);

                    if ( ( sDestCol->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK )
                         == SMI_COLUMN_TYPE_LOB )
                    {
                        if( sValueColumn->module->isNull( sValueColumn,
                                                          sValue )
                            != ID_TRUE )
                        {
                            // PROJ-1362
                            IDE_DASSERT( sValueColumn->module->id
                                         == sDestCol->basicInfo->module->id );
                        }
                        else
                        {
                            // Nothing To Do
                        }
                    }
                    else
                    {
                        // Nothing To Do
                    }

                    // PROJ-1705
                    IDE_TEST( qdbCommon::mtdValue2StoringValue( sDestCol->basicInfo,
                                                                sValueColumn,
                                                                sValue,
                                                                &sStoringValue )
                              != IDE_SUCCESS );
                    sNewRow[sColumnOrder].value = sStoringValue;

                    IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                      sValueColumn,
                                                      sValue,
                                                      &sStoringSize )
                              != IDE_SUCCESS );
                    sNewRow[sColumnOrder].length = sStoringSize;

                }
            }

            // PROJ-2264 Dictionary table
            // Compression column   ߰  Null value  default value 
            // dictionary table  ְ,  row  OID  ߰ ÷ ä.
            if( (sDestCol->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
                == SMI_COLUMN_COMPRESSION_TRUE )
            {
                sDicTableHandle = smiGetTable( sDestCol->basicInfo->column.mDictionaryTableOID );
             
                SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sDstCursorProperty, aStatement->mStatistics );

                sDictionaryDstTblCursor.initialize();
                IDE_TEST( sDictionaryDstTblCursor.open(
                              QC_SMI_STMT( aStatement ),
                              sDicTableHandle,
                              NULL,
                              smiGetRowSCN( sDicTableHandle ),
                              NULL,
                              smiGetDefaultKeyRange(),
                              smiGetDefaultKeyRange(),
                              smiGetDefaultFilter(),
                              SMI_LOCK_WRITE|
                              SMI_TRAVERSE_FORWARD|
                              SMI_PREVIOUS_DISABLE,
                              SMI_INSERT_CURSOR,
                              & sDstCursorProperty )
                          != IDE_SUCCESS );
             
                // Dictionary table  insert ϰ
                // new row  value  OID  .
                // BUG-36718
                // Variable column  null    storing value(smiValue.value) 
                // NULL pointer  Ƿ storing value  ȯ ޾Ƽ ȵȴ.
                // Compressed value  row OID    ޾Ƽ
                // storing value  ִ´.

                IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF( smOID ),
                                                     (void **)&sRowOID )
                          != IDE_SUCCESS );

                // PROJ-2429 Dictionary based data compress for on-disk DB
                // qdbCommon::mtdValue2StoringValue, qdbCommon::storingSize Լ  
                // disk type value memory type ȯѴ.
                if ( smiTableSpace::isDiskTableSpace( sDestCol->basicInfo->column.colSpace ) == ID_TRUE ) 
                {
                    IDE_TEST( mtc::getNonStoringSize( &sDestCol->basicInfo->column, &sNonStoringSize ) 
                              != IDE_SUCCESS );

                    // disk  value memory ȯѴ.
                    if ( sNewRow[sColumnOrder].value != NULL )
                    {    
                        sValue4Disk.value  = (void*)((UChar*)sNewRow[sColumnOrder].value - sNonStoringSize); 
                        sValue4Disk.length = sDestCol->basicInfo->module->actualSize(
                            sDestCol->basicInfo, sValue4Disk.value );
                    }    
                    else 
                    {
                        sValue4Disk.value  = sDestCol->basicInfo->module->staticNull; 
                        sValue4Disk.length = sDestCol->basicInfo->module->nullValueSize();
                    }    

                    IDE_TEST( sDictionaryDstTblCursor.insertRowWithIgnoreUniqueError(
                                  &sDictionaryDstTblCursor,
                                  (smcTableHeader *)SMI_MISC_TABLE_HEADER( sDicTableHandle ),
                                  &sValue4Disk,
                                  sRowOID,
                                  &sRow )
                              != IDE_SUCCESS );
                }
                else
                {
                    IDE_TEST( sDictionaryDstTblCursor.insertRowWithIgnoreUniqueError(
                                  &sDictionaryDstTblCursor,
                                  (smcTableHeader *)SMI_MISC_TABLE_HEADER( sDicTableHandle ),
                                  &(sNewRow[sColumnOrder]),
                                  sRowOID,
                                  &sRow )
                              != IDE_SUCCESS );
                }

                IDE_TEST( sDictionaryDstTblCursor.close() != IDE_SUCCESS );

                sNewRow[sColumnOrder].value = sRowOID;
             
                // OID  Ƿ ̵ OID ̷ Ѵ.
                sNewRow[sColumnOrder].length = ID_SIZEOF(smOID);
            }
            else
            {
                // Not compression column.
                // Nothing to do.
            }
        }

        sDestCol = sDestCol->next;
    }

    if ( ( sTableType == SMI_TABLE_MEMORY ) ||
         ( sTableType == SMI_TABLE_VOLATILE ) )
    {
        // bothColumnList NEW/OLD Table   smiColumnList,
        // add column, drop column, modify column 
        // ݵ   ̻ both column Ͽ Ѵ.
        IDE_TEST_RAISE( sBothColumnList == NULL,
                        ERR_INVALID_BOTH_COLUMN_LIST );

        /* ------------------------------------------------
         * get OLD table columnlist ( smiColumnList )
         * ----------------------------------------------*/

        sSrcCol = aSrcTblColumn;
        while (sSrcCol != NULL)
        {
            if (sSrcColumnList == NULL)
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc11");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiColumnList),
                                                   (void**)&sSrcColumnList)
                         != IDE_SUCCESS);

                sColumnPtr     = sSrcColumnList;
            }
            else
            {
                IDU_LIMITPOINT("qdbAlter::moveRow::malloc12");
                IDE_TEST(aStatement->qmxMem->alloc(ID_SIZEOF(smiColumnList),
                                                   (void**)&(sColumnPtr->next))
                         != IDE_SUCCESS);

                sColumnPtr       = sColumnPtr->next;
            }

            sColumnPtr->column = (smiColumn *)&(sSrcCol->basicInfo->column);
            sColumnPtr->next   = NULL;

            sSrcCol = sSrcCol->next;
        }

        /* ------------------------------------------------
         * convert context
         * ----------------------------------------------*/

        // PROJ-1877
        // restore  convert context  callback .
        sCallBackInfo.convertContextList = sConvertContextList;
        sCallBackInfo.nullValues = sNullRow;

        /* PROJ-1090 Function-based Index */
        if ( sHasDefaultExpr == ID_TRUE )
        {
            sCallBackInfo.hasDefaultExpr = ID_TRUE;
            sCallBackInfo.srcTableRef    = aTableRef;
            sCallBackInfo.dstTblColumn   = sNewColumns;

            /* PROJ-2464 hybrid partitioned table  */
            sPartitionedTupleRowOffset = qmc::getRowOffsetForTuple( & QC_PRIVATE_TMPLATE(aStatement)->tmplate,
                                                                    aTableRef->table );

            IDU_FIT_POINT( "qdbAlter::moveRow::alloc::sCallBackInfo.rowBuffer",
                           idERR_ABORT_InsufficientMemory );

            IDE_TEST( aStatement->qmxMem->alloc( sPartitionedTupleRowOffset,
                                                 & sCallBackInfo.rowBuffer )
                      != IDE_SUCCESS );
        }
        else
        {
            /* Nothing to do */
        }
        
        /* ------------------------------------------------
         * restore table
         * ----------------------------------------------*/

        IDE_TEST(smiTable::restoreTableForAlterTable(
                     QC_SMI_STMT( aStatement ),
                     aSrcTable,
                     aDstTable,
                     sTableOID,
                     sSrcColumnList,
                     sBothColumnList,
                     sNewRow,
                     & sCallBack )
                 != IDE_SUCCESS);
    }
    else
    {
        //------------------------------------------
        // open index table insert cursors
        //------------------------------------------
        
        if ( aNewIndexTables != NULL )
        {
            IDE_TEST( qdx::initializeInsertIndexTableCursors(
                          aStatement,
                          aNewIndexTables,
                          &sIndexTableCursorInfo,
                          aNewTableInfo->indices,
                          aNewTableInfo->indexCount,
                          sColumnCount,
                          &sDstCursorProperty )
                      != IDE_SUCCESS );
            
            sInitedCursorInfo = ID_TRUE;
            
            sPartOID = smiGetTableId( aDstTable );    
        }
        else
        {
            // Nothing to do.
        }
        
        // move..
        IDE_TEST(sSrcTblCursor.beforeFirst() != IDE_SUCCESS);
        IDE_TEST(sSrcTblCursor.readRow(&sOldRow,
                                       &sRowGRID, SMI_FIND_NEXT)
                 != IDE_SUCCESS);
        
        while (sOldRow != NULL)
        {
            // To Fix PR-11704
            // ڵ Ǽ Ͽ ޸𸮰  ʵ ؾ .
            // Memory  Ͽ  ġ 
            IDE_TEST( aStatement->qmxMem->getStatus(&sQmxMemStatus)
                      != IDE_SUCCESS);

            (void)qmx::clearLobInfo( sLobInfo );

            // default value with sequence 
            IDE_TEST( qdbCommon::calculateDefaultValueWithSequence(
                          aStatement,
                          aTableInfo,
                          aSrcTblColumn,
                          aDstTblColumn,
                          sNewRow )
                      != IDE_SUCCESS );

            //------------------------------------------
            // INSERT 
            //------------------------------------------
            IDE_TEST(makeNewRow(QC_PRIVATE_TMPLATE(aStatement),
                                aTableInfo,
                                aSrcTblColumn,
                                aDstTblColumn,
                                sOldRow,
                                sNewRow,
                                & sSrcTblCursor,
                                sRowGRID,
                                sLobInfo,
                                sConvertContextList)
                     != IDE_SUCCESS);

            /* PROJ-1090 Function-based Index */
            if ( sHasDefaultExpr == ID_TRUE )
            {
                IDE_TEST( qmsDefaultExpr::calculateDefaultExpression(
                              QC_PRIVATE_TMPLATE(aStatement),
                              aTableRef,
                              NULL,
                              sNewColumns,
                              sOldRow,
                              sNewRow,
                              aDstTblColumn )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }

            IDE_TEST(sDstTblCursor.insertRow(sNewRow,
                                             & sInsRow,
                                             & sInsGRID)
                     != IDE_SUCCESS);

            //------------------------------------------
            // INSERT  Lob ÷ ó
            //------------------------------------------
            
            IDE_TEST( qmx::copyAndOutBindLobInfo( aStatement,
                                                  sLobInfo,
                                                  & sDstTblCursor,
                                                  sInsRow,
                                                  sInsGRID )
                      != IDE_SUCCESS );

            //------------------------------------------
            // INSERT  non-partitioned index ó
            //------------------------------------------

            if ( aNewIndexTables != NULL )
            {
                IDE_TEST( qdx::insertIndexTableCursors( &sIndexTableCursorInfo,
                                                        sNewRow,
                                                        sPartOID,
                                                        sInsGRID )
                          != IDE_SUCCESS );
            }
            else
            {
                // Nothing to do.
            }

            // BUG-42920 DDL display data move progress
            IDE_TEST( qdbAlter::printProgressLog( &sCallBackInfo,
                                                  ID_FALSE )
                      != IDE_SUCCESS );
            
            // To Fix PR-11704
            // Memory   Memory ̵
            IDE_TEST( aStatement->qmxMem->setStatus(&sQmxMemStatus)
                      != IDE_SUCCESS);

            IDE_TEST(sSrcTblCursor.readRow(&sOldRow, &sRowGRID, SMI_FIND_NEXT)
                     != IDE_SUCCESS);
        }

        // BUG-42920 DDL display data move progress
        IDE_TEST( qdbAlter::printProgressLog( &sCallBackInfo,
                                              ID_TRUE )
                  != IDE_SUCCESS );

        // close.
        sStage = 1;
        IDE_TEST(sDstTblCursor.close() != IDE_SUCCESS);
        sStage = 0;
        IDE_TEST(sSrcTblCursor.close() != IDE_SUCCESS);
        
        // close index table cursor
        if ( aNewIndexTables != NULL )
        {
            IDE_TEST( qdx::closeInsertIndexTableCursors(
                          &sIndexTableCursorInfo )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }
    }

    IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                   aSrcTable,
                                   SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_INVALID_BOTH_COLUMN_LIST )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QMC_UNEXPECTED_ERROR,
                                  "qdbAlter::moveRow",
                                  "Invalid both column list" ));
    }
    IDE_EXCEPTION_END;

    if (sStage == 1 || sStage == 3)
    {
        sSrcTblCursor.close();
    }
    if (sStage > 1)
    {
        sDstTblCursor.close();
    }

    if ( sInitedCursorInfo == ID_TRUE )
    {
        qdx::finalizeInsertIndexTableCursors(
            &sIndexTableCursorInfo );
    }
    else
    {
        // Nothing to do.
    }
    
    (void)qmx::finalizeLobInfo( aStatement, sLobInfo );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::updateColumnSpecSRID( qcStatement * aStatement,
                                       qcmColumn   * aColumns )
{
/***********************************************************************
 *
 * Description : PROJ-2422 SRID
 *               ÷ SRID   Ÿ 
 *
 * Implementation :
 *      1. SYS_GEOMETRIES_ Ÿ ̺ SRID  
 *
 ***********************************************************************/
    qcmColumn * sColumn;

    SChar     * sSqlStr;
    vSLong      sRowCnt;
    // update meta.
    sColumn = aColumns;

    IDE_TEST( STRUCT_ALLOC_WITH_SIZE( aStatement->qmxMem,
                                      SChar,
                                      QD_MAX_SQL_LENGTH,
                                      &sSqlStr )
             != IDE_SUCCESS );
    while ( sColumn != NULL )
    {
        idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                         "UPDATE SYS_GEOMETRIES_ SET SRID = INTEGER'%"ID_INT32_FMT"' "
                         "WHERE COLUMN_ID = INTEGER'%"ID_INT32_FMT"'",
                         sColumn->basicInfo->mColumnAttr.mSridAttr.mSrid,
                         sColumn->basicInfo->column.id );

        IDE_TEST( qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                     sSqlStr, &sRowCnt ) != IDE_SUCCESS );
        IDE_TEST_RAISE( sRowCnt != 1, ERR_BREAK_SCHEMA );
        sColumn = sColumn->next;
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_BREAK_SCHEMA );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_META_CRASH ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::updateColumnSpecDefault(qcStatement * aStatement,
                                         qcmColumn   * aColumns )
{
/***********************************************************************
 *
 * Description :
 *      executeDropDefault(Ʈ ),
 *      executeSetDefault(Ʈ ) Լκ ȣ
 *
 * Implementation :
 *      1. SYS_COLUMNS_ Ÿ ̺ DEFAULT_VAL  
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::updateColumnSpecDefault"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qcmColumn * sColumn;

    SChar     * sSqlStr;
    vSLong      sRowCnt;
    // update meta.
    sColumn = aColumns;
    IDU_LIMITPOINT("qdbAlter::updateColumnSpecDefault::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);
    while (sColumn != NULL)
    {
        if (sColumn->defaultValueStr != NULL)
        {
            idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                             "UPDATE SYS_COLUMNS_ SET DEFAULT_VAL = '%s' "
                             "WHERE COLUMN_ID = %"ID_INT32_FMT"",
                             sColumn->defaultValueStr,
                             sColumn->basicInfo->column.id );
        }
        else
        {
            idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                             "UPDATE SYS_COLUMNS_ SET DEFAULT_VAL = '' "
                             "WHERE COLUMN_ID = %"ID_INT32_FMT"",
                             sColumn->basicInfo->column.id);
        }

        IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT( aStatement ),
                                   sSqlStr, &sRowCnt) != IDE_SUCCESS);
        IDE_TEST_RAISE(sRowCnt != 1, ERR_BREAK_SCHEMA);
        sColumn = sColumn->next;
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_BREAK_SCHEMA);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_META_CRASH));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeNotNull(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN (... NOT NULL ...)  execution 
 *
 * Implementation :
 *    0. ȭ   Ȯ 
 *    1. alter ϰ ϴ ÷ ΰ Ͱ  üũ => hasNullValue
 *    2. SYS_COLUMNS_ Ÿ ̺  => qdbCommon::updateColumnSpecNull
 *    3. Ÿ̺ ο constraint  Է => qdbCommon::createConstrNotNull
 *    6. Ÿ ĳ 籸
 *    4. qcm::getTableInfoByID
 *    4. qdbCommon::makeColumnNotNull
 *    14. related PSM  invalid · 
 *    5. qcm::touchTable
 *    6. Ÿ ĳ 籸
 *
 ***********************************************************************/

    qcmColumn             * sColumn;
    qdTableParseTree      * sParseTree;
    UInt                    sTableID;
    smOID                   sTableOID;
    smSCN                   sSCN;
    idBool                  sHasNull;
    qcmTableInfo          * sOldTableInfo = NULL;
    qcmTableInfo          * sNewTableInfo = NULL;
    void                  * sTableHandle;
    idBool                  sIsPartitioned = ID_FALSE;
    qcmPartitionInfoList  * sOldPartInfoList = NULL;
    qcmPartitionInfoList  * sNewPartInfoList = NULL;
    smOID                   sOldTableOID = 0;
    smOID                   sNewTableOID = 0;
    smOID                 * sOldPartitionOID = NULL;
    UInt                    sOldPartitionCount = 0;
    idBool                  sIsReplicatedTable = ID_FALSE;
    smOID                 * sOldTableOIDArray = NULL;
    smOID                 * sNewTableOIDArray = NULL;
    UInt                    sTableOIDCount = 0;
    UInt                    sDDLSupplementalLog = QCU_DDL_SUPPLEMENTAL_LOG;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sColumn = sParseTree->columns;
    sOldTableInfo = sParseTree->tableInfo;
    sOldTableOID    = smiGetTableId( sOldTableInfo->tableHandle );

    // PROJ-1407 Temporary table
    // session temporary table ϴ  DDL   .
    IDE_TEST_RAISE( qcuTemporaryObj::existSessionTable( sOldTableInfo ) == ID_TRUE,
                    ERR_SESSION_TEMPORARY_TABLE_EXIST );

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sIsPartitioned = ID_TRUE;

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        if ( ( sOldTableInfo->replicationCount > 0 ) ||
             ( sDDLSupplementalLog == 1 ) )
        {

            IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                        sOldPartInfoList,
                                                        &sOldPartitionOID,
                                                        &sOldPartitionCount )
                      != IDE_SUCCESS );
        }
        else
        {
            /* do nothing */
        }
    }

    // PROJ-2642 Table on Replication Allow DDL
    if ( sOldTableInfo->replicationCount > 0 )
    {
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1,
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode() == SMI_TRANSACTION_REPL_NONE,
                        ERR_CANNOT_WRITE_REPL_INFO );

        if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sTableOIDCount = sOldPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sTableOIDCount = 1;
        }

        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   sOldTableOIDArray,
                                                                   sTableOIDCount )
                  != IDE_SUCCESS );

        IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                        aStatement->mStatistics,
                                                                        sOldTableOIDArray,
                                                                        sTableOIDCount )
                  != IDE_SUCCESS );

        sIsReplicatedTable = ID_TRUE;
    }
    else
    {
        /* do nothing */
    }

    IDE_TEST(hasNullValue(aStatement, sParseTree->tableInfo,
                          sColumn, &sHasNull) != IDE_SUCCESS);

    IDE_TEST_RAISE(sHasNull == ID_TRUE, ERR_HAS_NULL_VALUE);

    // set nullable flag to false.
    IDE_TEST(qdbCommon::updateColumnSpecNull(aStatement, sColumn, ID_FALSE)
             != IDE_SUCCESS);

    IDE_TEST(qdbCommon::createConstrNotNull(
                 aStatement,
                 sParseTree->constraints,
                 sParseTree->userID,
                 sParseTree->tableInfo->tableID)
             != IDE_SUCCESS);

    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sTableOID)
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle) != IDE_SUCCESS);

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    IDE_TEST(qdbCommon::makeColumnNotNull(
                 aStatement,
                 sParseTree->tableInfo->tableHandle,
                 sParseTree->tableInfo->maxrows,
                 sOldPartInfoList,
                 sIsPartitioned,
                 sColumn->basicInfo->column.id )
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable( QC_SMI_STMT( aStatement ),
                              sParseTree->tableInfo->tableID,
                              SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    (void)qcm::destroyQcmTableInfo(sNewTableInfo);
    sNewTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                          sTableID,
                                          sTableOID)
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle) != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }

    // PROJ-2642 Table on Replication Allow DDL
    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( sDDLSupplementalLog == 1 ) )
    {
        sNewTableOID = smiGetTableId( sNewTableInfo->tableHandle );

        if ( sIsPartitioned == ID_FALSE )
        {
            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }
        else
        {
            sOldTableOIDArray = sOldPartitionOID;

            IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                        sNewPartInfoList,
                                                        &sNewTableOIDArray,
                                                        &sTableOIDCount )
                      != IDE_SUCCESS );
        }

        IDE_TEST( qciMisc::writeTableMetaLogForReplication( aStatement,
                                                            sOldTableOIDArray,
                                                            sNewTableOIDArray,
                                                            sTableOIDCount )
                  != IDE_SUCCESS );

    }
    else
    {
        /* do nothing */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sNewTableInfo->tableOID),
                             0,
                             NULL );
    }

    if ( sIsPartitioned == ID_TRUE )
    {
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* do nothing */
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_SESSION_TEMPORARY_TABLE_EXIST )
    {
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_TEMPORARY_TABLE_DDL_DISABLE ));
    }
    IDE_EXCEPTION(ERR_HAS_NULL_VALUE);
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOTNULL_HAS_NULL));
    }
    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeNullable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *      ALTER TABLE ... ALTER COLUMN ( ... NULL ) 
 *
 * Implementation :
 *      0. ȭ   Ȯ 
 *      1. set nullable flag to true(Ÿ ̺ SYS_COLUMNS_ )
 *      2. SYS_CONSTRAINTS_, SYS_CONSTRAINT_COLUMNs_ Ÿ ̺
 *         NOT NULL constraint  
 *      3.  PSM ¸ invalid  
 *      4. Ÿ ĳ 籸
 *      5. ȭ  ̸ writeMetaLog 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeNullable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qcmColumn             * sColumn;
    qdTableParseTree      * sParseTree;
    UInt                    sTableID;
    smOID                   sOldTableOID = 0;
    smOID                   sNewTableOID = 0;
    smSCN                   sSCN;
    qcmTableInfo          * sOldTableInfo  = NULL;
    qcmTableInfo          * sNewTableInfo  = NULL;
    qcmTableInfo          * sTempTableInfo = NULL;
    void                  * sTableHandle;
    idBool                  sIsPartitioned   = ID_FALSE;
    qcmPartitionInfoList  * sOldPartInfoList = NULL;
    qcmPartitionInfoList  * sNewPartInfoList = NULL;
    smOID                 * sOldPartitionOID = NULL;
    UInt                    sOldPartitionCount = 0;
    idBool                  sIsReplicatedTable = ID_FALSE;
    smOID                 * sOldTableOIDArray = NULL;
    smOID                 * sNewTableOIDArray = NULL;
    UInt                    sTableOIDCount = 0;
    UInt                    sDDLSupplementalLog = QCU_DDL_SUPPLEMENTAL_LOG;


    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sColumn = sParseTree->columns;
    sOldTableInfo = sParseTree->tableInfo;
    sOldTableOID = smiGetTableId( sOldTableInfo->tableHandle );

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        sIsPartitioned = ID_TRUE;

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        if ( ( sOldTableInfo->replicationCount > 0 ) ||
             ( sDDLSupplementalLog == 1 ) )
        {
            IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                        sOldPartInfoList,
                                                        &sOldPartitionOID,
                                                        &sOldPartitionCount )
                      != IDE_SUCCESS );
        }
        else
        {
            /* do nothing */
        }
    }

    // PROJ-2642 Table on Replication Allow DDL
    if ( sOldTableInfo->replicationCount > 0 )
    {
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1,
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode() == SMI_TRANSACTION_REPL_NONE,
                        ERR_CANNOT_WRITE_REPL_INFO );


        if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            sOldTableOIDArray = sOldPartitionOID;
            sTableOIDCount = sOldPartitionCount;
        }
        else
        {
            sOldTableOIDArray = &sOldTableOID;
            sTableOIDCount = 1;
        }

        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   sOldTableOIDArray,
                                                                   sTableOIDCount )
                  != IDE_SUCCESS );

        IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                        aStatement->mStatistics,
                                                                        sOldTableOIDArray,
                                                                        sTableOIDCount )
                  != IDE_SUCCESS );

        sIsReplicatedTable = ID_TRUE;
    }
    else
    {
        /* do nothing */
    }

    // set nullable flag to true.
    IDE_TEST(qdbCommon::updateColumnSpecNull(aStatement,
                                             sColumn,
                                             ID_TRUE) != IDE_SUCCESS);

    IDE_TEST( deleteNotNullConstraint( aStatement,
                                       sParseTree->tableInfo,
                                       sColumn->basicInfo->column.id )
              != IDE_SUCCESS );

    sTableID = sOldTableInfo->tableID;

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sOldTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sOldTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sTempTableInfo,
                                   &sSCN,
                                   &sTableHandle) != IDE_SUCCESS);
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sTableHandle,
                                        sSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    IDE_TEST(qdbCommon::makeColumnNullable(aStatement,
                                           sParseTree->tableInfo,
                                           sColumn->basicInfo->column.id)
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sParseTree->tableInfo->tableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    (void)qcm::destroyQcmTableInfo(sTempTableInfo);
    sTempTableInfo = NULL;

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sOldTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle) != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sIsPartitioned == ID_TRUE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }

    // PROJ-2642 Table on Replication Allow DDL
    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( sDDLSupplementalLog == 1 ) )
    {
        sNewTableOID = smiGetTableId( sNewTableInfo->tableHandle );

        if ( sIsPartitioned == ID_FALSE )
        {
            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }
        else
        {
            sOldTableOIDArray = sOldPartitionOID;

            IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                        sNewPartInfoList,
                                                        &sNewTableOIDArray,
                                                        &sTableOIDCount )
                      != IDE_SUCCESS );
        }

        IDE_TEST( qciMisc::writeTableMetaLogForReplication( aStatement,
                                                            sOldTableOIDArray,
                                                            sNewTableOIDArray,
                                                            sTableOIDCount )
                  != IDE_SUCCESS );

    }
    else
    {
        /* do nothing */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sNewTableInfo->tableOID),
                             0,
                             NULL );
    }

    if ( sIsPartitioned == ID_TRUE )
    {
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* do nothing */
    }

    (void)qcm::destroyQcmTableInfo( sOldTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sTempTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // restore
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeDropDefault(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALTER COLUMN (... DROP DEFAULT ...)  execution 
 *
 * Implementation :
 *    1. qcm::getTableInfo
 *    2. SYS_COLUMNS_ Ÿ ̺  => updateColumnSpecDefault
 *    3. related PSM  invalid · 
 *    4. qcm::touchTable
 *    5. Ÿ ĳ 籸
 *
 * Replication ɸ Table  DDL , ߰ Ʒ ۾ Ѵ.
 *    1. Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeDropDefault"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree     * sParseTree       = NULL;
    qcmTableInfo         * sOldTableInfo    = NULL;
    qcmColumn            * sColumn          = NULL;
    UInt                   sTableID         = 0;
    smOID                  sTableOID        = SM_OID_NULL;
    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sParseTree->columns->defaultValueStr = NULL;
    sOldTableInfo = sParseTree->tableInfo;
    sColumn = sParseTree->columns;

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    /* PROJ-1442 Replication Online  DDL 
     * Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
     */
    if(sOldTableInfo->replicationCount > 0)
    {
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 0, 
                                                                                 sOldTableInfo )
                  != IDE_SUCCESS );
    }

    while (sColumn != NULL)
    {
        sColumn->defaultValueStr = NULL;
        sColumn = sColumn->next;
    }

    IDE_TEST(updateColumnSpecDefault(aStatement,
                                     sParseTree->columns)
             != IDE_SUCCESS);

    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sNewTableInfo->tableOID),
                             0,
                             NULL );
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeCompactTable( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... COMPACT  execution 
 *
 ***********************************************************************/

    qdTableParseTree     * sParseTree    = NULL;
    UInt                   sTableID      = 0;
    smOID                  sTableOID     = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    UInt                   sPartID       = 0;
    smOID                  sPartOID      = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    if ( sParseTree->partTable->partAttr == NULL )
    {
        /* Table  Lock ȹѴ. */
        IDE_TEST( qcm::validateAndLockTable( aStatement,
                                             sParseTree->tableHandle,
                                             sParseTree->tableSCN,
                                             SMI_TABLE_LOCK_X )
                  != IDE_SUCCESS );

        /* 1.  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Ƽ  쿡 IX Lock   ü .
        IDE_TEST( qcmPartition::validateAndLockTableAndPartitions( aStatement,
                                                                   sParseTree->tableHandle,
                                                                   sParseTree->tableSCN,
                                                                   sParseTree->partTable->partInfoList,
                                                                   SMI_TABLE_LOCK_IX,
                                                                   ID_FALSE ) //aIsSetViewSCN
                  != IDE_SUCCESS );
    }

    /* PROJ-2464 hybrid partitioned table 
     *  - HPT  쿡, Memory, Disk ü    ִ.
     *  -  Memory ü ش ɼ ؾ Ѵ.
     *     1.  Ƽǿ LOCK(X)
     *     2. Memory Partition Compact
     *     3. Memory Table Compact
     *     4.  Ƽ Last DDL Time Ѵ
     */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 2. Memory Parttion Compact */
        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            if ( ( sPartInfoList->partitionInfo->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK )
            {
                IDE_TEST( smiTable::compactTable( QC_SMI_STMT( aStatement ),
                                                  sPartInfoList->partHandle,
                                                  sParseTree->maxrows )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }
        }
    }
    else
    {
        /* 3. Memory Table Compact */
        IDE_TEST( smiTable::compactTable( QC_SMI_STMT( aStatement ),
                                          sParseTree->tableInfo->tableHandle,
                                          sParseTree->maxrows )
                  != IDE_SUCCESS );
    }

    sTableID  = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId( sParseTree->tableInfo->tableHandle );

    /* fix BUG-14394 */
    IDE_TEST( qdbCommon::updateTableSpecFromMeta( aStatement,
                                                  sParseTree->userName,
                                                  sParseTree->tableName,
                                                  sTableID,
                                                  sTableOID,
                                                  sParseTree->tableInfo->columnCount,
                                                  sParseTree->tableInfo->parallelDegree )
              != IDE_SUCCESS );

    /* 4.  Ƽ Last DDL Time Ѵ. */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sParseTree->tableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sParseTree->tableInfo->tableOID),
                             0,
                             NULL );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAgingTable( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... AGING  execution 
 *
 ***********************************************************************/

    qdTableParseTree     * sParseTree    = NULL;
    UInt                   sTableID      = 0;
    smOID                  sTableOID     = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    UInt                   sPartID       = 0;
    smOID                  sPartOID      = 0;
    qdIndexTableList     * sIndexTable   = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    if ( sParseTree->partTable->partAttr == NULL )
    {
        /* Table  Lock ȹѴ. */
        IDE_TEST( qcm::validateAndLockTable( aStatement,
                                             sParseTree->tableHandle,
                                             sParseTree->tableSCN,
                                             SMI_TABLE_LOCK_X )
                  != IDE_SUCCESS );

        /* 1.  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Ƽ  쿡 IX Lock   ü .
        IDE_TEST( qcmPartition::validateAndLockTableAndPartitions( aStatement,
                                                                   sParseTree->tableHandle,
                                                                   sParseTree->tableSCN,
                                                                   sParseTree->partTable->partInfoList,
                                                                   SMI_TABLE_LOCK_IX,
                                                                   ID_FALSE ) //aIsSetViewSCN
                  != IDE_SUCCESS );
    }

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDU_FIT_POINT( "qdbAlter::executeAgingTable::beforeLockIndexTable" );

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            /* PROJ-2464 hybrid partitioned table 
             *  - Disk Partition Aging
             */
            if ( ( sPartInfoList->partitionInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
            {
                IDE_TEST( smiTable::agingTable( QC_SMI_STMT( aStatement ),
                                                sPartInfoList->partHandle )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }
        }

        /* PROJ-1624 non-partitioned index */
        for ( sIndexTable = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            IDE_TEST(smiTable::agingTable( QC_SMI_STMT( aStatement ),
                                           sIndexTable->tableHandle )
                     != IDE_SUCCESS);
        }
    }
    else
    {
        IDE_TEST(smiTable::agingTable( QC_SMI_STMT( aStatement ),
                                       sParseTree->tableHandle )
                 != IDE_SUCCESS);
    }

    sTableID  = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId( sParseTree->tableInfo->tableHandle );

    /* fix BUG-14394 */
    IDE_TEST( qdbCommon::updateTableSpecFromMeta( aStatement,
                                                  sParseTree->userName,
                                                  sParseTree->tableName,
                                                  sTableID,
                                                  sTableOID,
                                                  sParseTree->tableInfo->columnCount,
                                                  sParseTree->tableInfo->parallelDegree )
              != IDE_SUCCESS );

    /*  Ƽ Last DDL Time Ѵ. */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sParseTree->tableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAllIndexEnable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALL INDEX ENABLE  execution 
 *
 * Implementation :
 *    1. smiTable::enableAllIndex ȣ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeAllIndexEnable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree     * sParseTree       = NULL;
    qcmTableInfo         * sOldTableInfo    = NULL;
    UInt                   sTableID         = 0;
    smOID                  sTableOID        = SM_OID_NULL;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmPartitionInfoList * sPartInfoList    = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::enableAllIndex( QC_SMI_STMT( aStatement ),
                                        sOldTableInfo->tableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList = sPartInfoList->next )
        {
            IDE_TEST( smiTable::enableAllIndex( QC_SMI_STMT( aStatement ),
                                                sPartInfoList->partHandle )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    sTableID = sOldTableInfo->tableID;
    sTableOID = smiGetTableId( sOldTableInfo->tableHandle );

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sOldTableInfo->columnCount,
                 sOldTableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeAllIndexDisable(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    ALTER TABLE ... ALL INDEX DISABLE  execution 
 *
 * Implementation :
 *    1. smiTable::disableAllIndex ȣ
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeAllIndexDisable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    qdTableParseTree     * sParseTree       = NULL;
    qcmTableInfo         * sOldTableInfo    = NULL;
    UInt                   sTableID         = 0;
    smOID                  sTableOID        = SM_OID_NULL;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmPartitionInfoList * sPartInfoList    = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;
    
    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::disableAllIndex( QC_SMI_STMT( aStatement ),
                                         sOldTableInfo->tableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList = sPartInfoList->next )
        {
            IDE_TEST( smiTable::disableAllIndex( QC_SMI_STMT( aStatement ),
                                                 sPartInfoList->partHandle )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    sTableID = sOldTableInfo->tableID;
    sTableOID = smiGetTableId( sOldTableInfo->tableHandle );

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sOldTableInfo->columnCount,
                 sOldTableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo(sOldTableInfo);
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    // on failure, restore tempinfo.
    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::deletePartIndexFromMeta(
    qcStatement *aStatement,
    UInt         aIndexID)
{
/***********************************************************************
 *
 * Description :
 *      executeDropCol κ ȣ, Ÿ ̺κ ε  
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::deletePartIndexFromMeta"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    SChar               * sSqlStr;
    vSLong sRowCnt;

    IDU_LIMITPOINT("qdbAlter::deletePartIndexFromMeta::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_PART_INDICES_ "
                     "WHERE INDEX_ID = INTEGER'%"ID_INT32_FMT"'",
                     aIndexID);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_INDEX_PARTITIONS_ "
                     "WHERE INDEX_ID = INTEGER'%"ID_INT32_FMT"'",
                     aIndexID);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    // To fix BUG-24282
    // Ƽǵ ̺ DROP COLUMN ٸ Ƽǵ ̺
    // Ÿ Ǵ 찡 ֽϴ.
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_PART_KEY_COLUMNS_ "
                     "WHERE PARTITION_OBJ_ID = INTEGER'%"ID_INT32_FMT"'"
                     "AND OBJECT_TYPE = INTEGER'%"ID_INT32_FMT"'",
                     aIndexID,
                     QCM_INDEX_OBJECT_TYPE );

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::deleteIndexSpecFromMeta(
    qcStatement *aStatement,
    UInt         aTableID)
{
/***********************************************************************
 *
 * Description :
 *      executeAddCol κ ȣ, Ÿ ̺κ ε  
 *
 * Implementation :
 *      1. SYS_INDICES_, SYS_INDEX_COLUMNS_ Ÿ ̺  
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::deleteIndexSpecFromMeta"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    SChar               * sSqlStr;
    vSLong sRowCnt;

    IDU_LIMITPOINT("qdbAlter::deleteIndexSpecFromMeta::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_INDICES_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_INDEX_COLUMNS_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::deleteColumnSpecFromMeta(
    qcStatement    * aStatement,
    UInt             aTableID)
{
/***********************************************************************
 *
 * Description :
 *      executeAddCol κ ȣ, Ÿ ̺κ ÷  
 *
 * Implementation :
 *      1. SYS_COLUMNS_ Ÿ ̺  
 *
 ***********************************************************************/
    SChar               * sSqlStr;
    vSLong sRowCnt;

    IDU_LIMITPOINT("qdbAlter::deleteColumnSpecFromMeta::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_COLUMNS_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    // PROJ-1362
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_LOBS_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT(aStatement),
                               sSqlStr,
                               & sRowCnt ) != IDE_SUCCESS);

    // PROJ-2002 Column Security
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_ENCRYPTED_COLUMNS_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT(aStatement),
                               sSqlStr,
                               & sRowCnt ) != IDE_SUCCESS);

    // PROJ-2422 srid
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_GEOMETRIES_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID );

    IDE_TEST( qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                 sSqlStr,
                                 &sRowCnt ) != IDE_SUCCESS );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::deletePartKeyColumnSpecFromMeta(
    qcStatement    * aStatement,
    UInt             aPartObjectID,
    UInt             aPartObjectType)
{
/***********************************************************************
 *
 * Description :
 *      executeAddCol κ ȣ, Ÿ ̺κ ÷  
 *
 * Implementation :
 *      1. SYS_COLUMNS_ Ÿ ̺  
 *
 ***********************************************************************/

    SChar               * sSqlStr;
    vSLong sRowCnt;

    IDU_LIMITPOINT("qdbAlter::deletePartKeyColumnSpecFromMeta::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_PART_KEY_COLUMNS_ "
                     "WHERE PARTITION_OBJ_ID = INTEGER'%"ID_INT32_FMT"'"
                     "AND OBJECT_TYPE = INTEGER'%"ID_INT32_FMT"'",
                     aPartObjectID,
                     aPartObjectType );

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::deletePartLobSpecFromMeta(
    qcStatement    * aStatement,
    UInt             aTableID)
{
/***********************************************************************
 *
 * Description :
 *      executeAddCol, executeDropCol κ ȣ,
 *      Ÿ ̺κ ÷  
 *
 * Implementation :
 *      1. SYS_PART_LOBS_ Ÿ ̺  
 *
 ***********************************************************************/

    SChar               * sSqlStr;
    vSLong sRowCnt;

    IDU_LIMITPOINT("qdbAlter::deletePartLobSpecFromMeta::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "DELETE FROM SYS_PART_LOBS_ "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     aTableID);

    IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT(aStatement),
                               sSqlStr,
                               & sRowCnt ) != IDE_SUCCESS);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::hasNullValue(qcStatement  *aStatement,
                              qcmTableInfo *aTableInfo,
                              qcmColumn    *aColumn,
                              idBool       *aHasNull)
{
/***********************************************************************
 *
 * Description :
 *    aColumn    ϴ θ  ڵ忡 ؼ ˻
 *
 *    qdbAlter::executeNotNull() ȣ.
 *
 * Implementation :
 *    1. Cursor ʱȭ
 *    2. Cursor Open
 *    3.  ڵ徿 鼭   ˻
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::hasNullValue"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(""));

    scGRID                 sRid; // Disk Table  Record IDentifier
    smiCursorProperties    sCursorProperty;
    smiTableCursor         sCursor;
    const void           * sRow = NULL;     // TASK-3876 Code Sonar
    const void           * sRowBuf = NULL;  // TASK-3876 Code Sonar
    void                 * sValueTemp;
    SInt                   sStage = 0;
    UInt                   sTableType;
    UInt                   sRowSize;
    qcmPartitionInfoList * sPartInfoList = NULL;
    qcmTableInfo         * sPartInfo;
    qdTableParseTree     * sParseTree;
    smiFetchColumnList   * sFetchColumnList = NULL;
    UChar                * sVarRowBuffer = NULL;
    UInt                   sVarRowSize;

    UInt                   sPartType     = 0 ;
    qcmTableInfo         * sDiskInfo     = NULL;
    qcmColumn            * sDiskColumn   = NULL;
    qcmTableInfo         * sMemoryInfo   = NULL;
    qcmColumn            * sMemoryColumn = NULL;
    qcmColumn            * sColumn       = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    sTableType = aTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* PROJ-2464 hybrid partitioned table 
     *  - Partitioned Alter  , sPartInfoList  Tablespace  ִ.
     */
    if ( aTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList = sPartInfoList->next )
        {
            sPartInfo = sPartInfoList->partitionInfo;

            if ( ( sPartInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
            {
                sDiskInfo = sPartInfo;
                sDiskColumn = qdbCommon::findColumnInColumnList( sPartInfo->columns,
                                                                 aColumn->basicInfo->column.id );

                IDE_TEST_RAISE( sDiskColumn == NULL, ERR_COLUMN_NOT_FOUND );
            }
            else
            {
                sMemoryInfo = sPartInfo;
                sMemoryColumn = qdbCommon::findColumnInColumnList( sPartInfo->columns,
                                                                   aColumn->basicInfo->column.id );

                IDE_TEST_RAISE( sMemoryColumn == NULL, ERR_COLUMN_NOT_FOUND );
            }
        }
    }
    else
    {
        if ( sTableType == SMI_TABLE_DISK )
        {
            sDiskInfo = aTableInfo;
            sDiskColumn = aColumn;
        }
        else
        {
            sMemoryInfo = aTableInfo;
            sMemoryColumn = aColumn;
        }
    }

    if ( sDiskInfo != NULL )
    {
        // Disk Table 

        // Record Read   ҴѴ.
        IDE_TEST( qdbCommon::getDiskRowSize( sDiskInfo,
                                             & sRowSize )
                  != IDE_SUCCESS );

        // To fix BUG-14820
        // Disk-variable ÷ rid񱳸  ʱȭ ؾ .
        IDU_LIMITPOINT("qdbAlter::hasNullValue::malloc1");
        IDE_TEST( aStatement->qmxMem->cralloc( sRowSize,
                                               (void **) & sRow )
                  != IDE_SUCCESS );

        // PROJ-1705
        // sm ڵ带 б fetch column list .
        IDE_TEST( qdbCommon::makeFetchColumnList(
                      QC_PRIVATE_TMPLATE(aStatement),
                      1,
                      sDiskColumn,
                      ID_TRUE,  // alloc smiColumnList
                      & sFetchColumnList ) != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    if ( sMemoryInfo != NULL )
    {
        // Memory Table  (Volatile Table Memory Table )
        // To fix BUG-24356
        // geometry ؼ value bufferҴ
        if ( ( (sMemoryColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                == SMI_COLUMN_TYPE_VARIABLE_LARGE ) &&
             (sMemoryColumn->basicInfo->module->id == MTD_GEOMETRY_ID) )
        {
            sVarRowSize = smiGetVariableColumnSize( SMI_TABLE_MEMORY ) +
                sMemoryColumn->basicInfo->column.size;
            sVarRowSize = idlOS::align( sVarRowSize, 8 );

            IDE_DASSERT( sVarRowSize > 0 );

            IDU_LIMITPOINT("qdbAlter::hasNullValue::malloc2");
            IDE_TEST( aStatement->qmxMem->cralloc( sVarRowSize,
                                                   (void**) & sVarRowBuffer )
                      != IDE_SUCCESS );

            IDE_TEST( qcm::copyQcmColumns( aStatement->qmxMem,
                                           sMemoryColumn,
                                           & sColumn,
                                           1 )
                      != IDE_SUCCESS );

            sColumn->basicInfo->column.value = (void*) sVarRowBuffer;

            sMemoryColumn = sColumn;
        }
        else
        {
            // Nothing to do.
        }
    }
    else
    {
        /* Nothing to do */
    }

    sRowBuf = sRow;
    *aHasNull = ID_FALSE;

    // PROJ-1502 PARTITIONED DISK TABLE
    if( aTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        // ĽƮ Ƽ  Ʈ ´.
        sPartInfoList = sParseTree->partTable->partInfoList;

        for( ;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next )
        {
            sRow = sRowBuf;
            sPartInfo = sPartInfoList->partitionInfo;

            sPartType = sPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

            // ˻  ڷ  ʱȭ
            SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sCursorProperty, aStatement->mStatistics );

            if ( sPartType == SMI_TABLE_DISK )
            {
                sCursorProperty.mFetchColumnList = sFetchColumnList;
                sColumn = sDiskColumn;
            }
            else
            {
                sColumn = sMemoryColumn;
            }

            sCursor.initialize();

            IDE_TEST(sCursor.open(
                         QC_SMI_STMT( aStatement ),
                         sPartInfo->tableHandle,
                         NULL,
                         smiGetRowSCN(sPartInfo->tableHandle),
                         NULL,
                         smiGetDefaultKeyRange(),
                         smiGetDefaultKeyRange(),
                         smiGetDefaultFilter(),
                         QCM_META_CURSOR_FLAG,
                         SMI_SELECT_CURSOR,
                         & sCursorProperty) != IDE_SUCCESS);
            sStage = 1;

            IDE_TEST(sCursor.beforeFirst() != IDE_SUCCESS);
            IDE_TEST(sCursor.readRow(&sRow, &sRid, SMI_FIND_NEXT) != IDE_SUCCESS);

            while ((sRow != NULL) && (*aHasNull != ID_TRUE))
            {
                if ((sColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                    == SMI_COLUMN_TYPE_LOB)
                {
                    // PROJ-1362
                    if ( smiIsNullLobColumn(sRow, &sColumn->basicInfo->column)
                         == ID_TRUE )
                    {
                        *aHasNull = ID_TRUE;
                        break;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }
                else
                {
                    sValueTemp = (void*)mtc::value( sColumn->basicInfo,
                                                    sRow,
                                                    MTD_OFFSET_USE );

                    if ( sColumn->basicInfo->module->isNull( sColumn->basicInfo,
                                                             sValueTemp )
                         == ID_TRUE )
                    {
                        *aHasNull = ID_TRUE;
                        break;
                    }
                    else
                    {
                        /* Nothing to do */
                    }
                }

                IDE_TEST(sCursor.readRow(&sRow, &sRid, SMI_FIND_NEXT)
                         != IDE_SUCCESS);
            }

            sStage = 0;

            IDE_TEST(sCursor.close() != IDE_SUCCESS);

            if( *aHasNull == ID_TRUE )
            {
                break;
            }
        }
    }
    else
    {
        // ˻  ڷ  ʱȭ
        SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sCursorProperty, aStatement->mStatistics );

        if ( sTableType == SMI_TABLE_DISK )
        {
            // PROJ-1705
            // sm ڵ带 б fetch column list .
            sCursorProperty.mFetchColumnList = sFetchColumnList;
            sColumn = sDiskColumn;
        }
        else
        {
            sColumn = sMemoryColumn;
        }

        sCursor.initialize();

        IDE_TEST(sCursor.open(
                     QC_SMI_STMT( aStatement ),
                     aTableInfo->tableHandle,
                     NULL,
                     smiGetRowSCN(aTableInfo->tableHandle),
                     NULL,
                     smiGetDefaultKeyRange(),
                     smiGetDefaultKeyRange(),
                     smiGetDefaultFilter(),
                     QCM_META_CURSOR_FLAG,
                     SMI_SELECT_CURSOR,
                     & sCursorProperty) != IDE_SUCCESS);
        sStage = 1;

        IDE_TEST(sCursor.beforeFirst() != IDE_SUCCESS);
        IDE_TEST(sCursor.readRow(&sRow, &sRid, SMI_FIND_NEXT) != IDE_SUCCESS);

        while ((sRow != NULL) && (*aHasNull != ID_TRUE))
        {
            if ((sColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                == SMI_COLUMN_TYPE_LOB)
            {
                // PROJ-1362
                if ( smiIsNullLobColumn(sRow, & sColumn->basicInfo->column)
                     == ID_TRUE )
                {
                    *aHasNull = ID_TRUE;
                    break;
                }
                else
                {
                    /* Nothing to do */
                }
            }
            else
            {
                sValueTemp = (void*)mtc::value( sColumn->basicInfo,
                                                sRow,
                                                MTD_OFFSET_USE );

                if (sColumn->basicInfo->module->isNull(sColumn->basicInfo,
                                                       sValueTemp )
                    == ID_TRUE)
                {
                    *aHasNull = ID_TRUE;
                    break;
                }
                else
                {
                    /* Nothing to do */
                }
            }

            IDE_TEST(sCursor.readRow(&sRow, &sRid, SMI_FIND_NEXT) != IDE_SUCCESS);
        }

        sStage = 0;

        IDE_TEST(sCursor.close() != IDE_SUCCESS);
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_COLUMN_NOT_FOUND )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QMC_UNEXPECTED_ERROR,
                                  "qdbAlter::hasNullValue",
                                  "Column Not Found" ) );
    }
    IDE_EXCEPTION_END;

    if (sStage == 1)
    {
        sCursor.close();
    }

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeAlterMaxRows(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *      ALTER TABLE ... MAXROWS 
 *
 * Implementation :
 *      1. getTableInfoByID
 *      2. modifyTableInfo
 *      3. SYS_TABLES_ Ÿ ̺ MAXROW  
 *      4. Ÿ ĳ 籸
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::executeAlterMaxRows"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::executeAlterMaxRows"));

    qdTableParseTree    * sParseTree;
    ULong                 sMaxRows;
    qcmTableInfo        * sTableInfo      = NULL;
    UInt                  sTableID;
    smOID                 sTableOID;
    SChar               * sSqlStr;
    vSLong                sRowCnt;

    qcmTableInfo        * sNewTableInfo   = NULL;
    void                * sNewTableHandle = NULL;
    smSCN                 sNewSCN         = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sTableInfo = sParseTree->tableInfo;
    sTableID = sTableInfo->tableID;

    if (sParseTree->maxrows == 0)
    {
        sMaxRows = ID_ULONG_MAX;
    }
    else
    {
        sMaxRows = sParseTree->maxrows;
    }

    // update maxrows
    IDE_TEST(smiTable::modifyTableInfo(QC_SMI_STMT( aStatement ),
                                       sTableInfo->tableHandle,
                                       NULL,
                                       0,
                                       NULL,
                                       0,
                                       SMI_TABLE_FLAG_UNCHANGE,
                                       SMI_TBSLV_DDL_DML,
                                       sMaxRows,
                                       0,
                                       ID_TRUE) /* aIsInitRowTemplate */
             != IDE_SUCCESS);

    IDU_LIMITPOINT("qdbAlter::executeAlterMaxRows::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_TABLES_ "
                     "SET MAXROW = BIGINT'%"ID_INT64_FMT"', "
                     "    LAST_DDL_TIME = SYSDATE "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     sParseTree->maxrows,
                     sTableID );

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    IDE_TEST_RAISE(sRowCnt != 1, ERR_META_CRASH);

    // rebuild tableInfo
    sTableOID = smiGetTableId(sTableInfo->tableHandle);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    /* Partitioned Table  Ƿ, Partition  ۾  ʴ´. */

    (void)qcm::destroyQcmTableInfo(sTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   NULL,
                                   NULL );

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeAlterTableOptions(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *      ALTER TABLE ... LOGGING/NOLOGGING PARALLEL/NOPARALLEL 
 *
 * Implementation :
 *      1. getTableInfoByID
 *      2. modifyTableInfo
 *      3. Ÿ ĳ 籸
 *
 ***********************************************************************/

    qdTableParseTree    * sParseTree = NULL;
    qcmTableInfo        * sTableInfo = NULL;
    UInt                  sTableID;
    smOID                 sTableOID;
    UInt                  sFlag;
    UInt                  sLoggingMode;
    UInt                  sParallelDegree;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    //------------------
    // ⺻  
    //------------------

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    //------------------
    // Table  Lock ȹѴ.
    //------------------

    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sTableInfo = sParseTree->tableInfo;
    sTableID   = sTableInfo->tableID;

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    //------------------
    // logging mode
    //------------------

    if ( sParseTree->loggingMode != NULL )
    {
        sLoggingMode = *(sParseTree->loggingMode);

        sFlag = sTableInfo->tableFlag;
        sFlag &= ~SMI_TABLE_LOGGING_MASK;
        sFlag |= sLoggingMode;
    }
    else
    {
        sFlag = SMI_TABLE_FLAG_UNCHANGE;
    }

    //------------------
    // parallel degree
    //------------------
    if ( sParseTree->parallelDegree != 0 )
    {
        sParallelDegree = sParseTree->parallelDegree;
    }
    else
    {
        // Parallel Degree 0̸
        // Parallel Degree ־  ǹ
        // ( Parallel Degree 0 ѱ
        //   sm ʿ  parallel degree 
        //     )
        sParallelDegree = 0;
    }

    //------------------
    // update logging mode & parallel degree
    //------------------
    IDE_TEST(smiTable::modifyTableInfo(QC_SMI_STMT( aStatement ),
                                       sTableInfo->tableHandle,
                                       NULL,
                                       0,
                                       NULL,
                                       0,
                                       sFlag,
                                       SMI_TBSLV_DDL_DML,
                                       0,
                                       sParallelDegree,
                                       ID_TRUE) /* aIsInitRowTemplate */
             != IDE_SUCCESS);

    /* TODO Partition  ʴ  ? */

    // rebuild tableInfo
    sTableOID = smiGetTableId(sTableInfo->tableHandle);

    if (sParallelDegree == 0)
    {
        sParallelDegree = sTableInfo->parallelDegree;
    }
    else
    {
        /* nothing to do */
    }

    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParallelDegree)
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo(sTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAlterLobAttributes(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1362
 *    ALTER TABLE ... ALTER LOB COLUMN ( lob column )
 *      STORE AS ( LOGGING/NOLOGGING/BUFFER/NOBUFFER )  execution 
 *
 * Implementation :
 *    1.   new Ÿ ĳ 
 *    2. getTableInfoByID
 *    3. SYS_LOBS_ Ÿ ̺ 
 *    4. modifyTableInfo
 *    5. related PSM  invalid · 
 *    6. qcm::touchTable
 *    7. Ÿ ĳ 籸
 *
 ***********************************************************************/

    qdTableParseTree      * sParseTree;
    UInt                    sTableID;
    smOID                   sTableOID;
    smSCN                   sSCN;
    qcmTableInfo          * sOldTableInfo = NULL;
    qcmTableInfo          * sNewInfo = NULL;
    void                  * sTableHandle;
    qcmColumn             * sLastColumn;
    smiColumnList         * sColumnList;
    smiColumnList        ** sPartColumnList = NULL;
    SChar                 * sSqlStr;
    UInt                    sPartUpdateCount = 0;
    UInt                    sUpdateCount = 0;
    UInt                    i = 0;
    UInt                    sPartitionID;
    qdPartitionAttribute  * sPartAttr;
    qcmPartitionInfoList  * sPartInfoList = NULL;
    qcmPartitionInfoList  * sOldPartInfoList = NULL;
    qcmPartitionInfoList  * sNewPartInfoList = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS);

    sOldTableInfo = sParseTree->tableInfo;

    sTableID = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId(sParseTree->tableInfo->tableHandle);

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT(aStatement),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableID,
                                   &sNewInfo,
                                   &sSCN,
                                   &sTableHandle) != IDE_SUCCESS);

    IDE_TEST(qdbCommon::allocSmiColList(aStatement,
                                        sTableHandle,
                                        &sColumnList)
             != IDE_SUCCESS);

    IDU_LIMITPOINT("qdbAlter::executeAlterLobAttributes::malloc1");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    if (sParseTree->lobAttr->columns == NULL)
    {
        // NULL̸ ̺  LOB ÷ alterѴ.
        for (sLastColumn = sNewInfo->columns;
             sLastColumn != NULL;
             sLastColumn = sLastColumn->next)
        {
            if ((sLastColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                == SMI_COLUMN_TYPE_LOB)
            {
                IDE_TEST( updateLobStorageAttr(aStatement,
                                               sParseTree->lobAttr,
                                               sColumnList,
                                               sLastColumn,
                                               sSqlStr,
                                               0, /* aPartID */
                                               & sUpdateCount ) );
            }
            else
            {
                // Nothing to do.
            }
        }
    }
    else
    {
        for (sLastColumn = sParseTree->lobAttr->columns;
             sLastColumn != NULL;
             sLastColumn = sLastColumn->next)
        {
            IDE_TEST( updateLobStorageAttr(aStatement,
                                           sParseTree->lobAttr,
                                           sColumnList,
                                           sLastColumn,
                                           sSqlStr,
                                           0, /* aPartID */
                                           & sUpdateCount ) );
        }
    }

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if( sParseTree->partTable->partAttr != NULL )
    {
        for( sPartInfoList = sOldPartInfoList, i = 0;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            // Nothing to do.
        }

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        IDU_LIMITPOINT("qdbAlter::executeAlterLobAttributes::malloc3");
        IDE_TEST( STRUCT_ALLOC_WITH_COUNT( aStatement->qmxMem,
                                           smiColumnList,
                                           i,
                                           & sPartColumnList )
                  != IDE_SUCCESS );

        for( sPartInfoList = sOldPartInfoList, i = 0;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            IDE_TEST(qdbCommon::allocSmiColList(aStatement,
                                                sPartInfoList->partHandle,
                                                & sPartColumnList[i] )
                     != IDE_SUCCESS);
        }
    }

    for( sPartAttr = sParseTree->partTable->partAttr,
             sPartInfoList = sNewPartInfoList, i = 0;
         sPartAttr != NULL;
         sPartAttr = sPartAttr->next,
             sPartInfoList = sPartInfoList->next, i++ )
    {
        sPartitionID = sPartInfoList->partitionInfo->partitionID;

        if (sParseTree->lobAttr->columns == NULL)
        {
            // NULL̸ ̺  LOB ÷ alterѴ.
            for (sLastColumn = sPartInfoList->partitionInfo->columns;
                 sLastColumn != NULL;
                 sLastColumn = sLastColumn->next)
            {
                if ((sLastColumn->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                    == SMI_COLUMN_TYPE_LOB)
                {
                    IDE_TEST( updateLobStorageAttr(aStatement,
                                                   sPartAttr->lobAttr,
                                                   sPartColumnList[i],
                                                   sLastColumn,
                                                   sSqlStr,
                                                   sPartitionID,
                                                   & sPartUpdateCount ) );
                }
                else
                {
                    // Nothing to do.
                }
            }
        }
        else
        {
            for (sLastColumn = sPartAttr->lobAttr->columns;
                 sLastColumn != NULL;
                 sLastColumn = sLastColumn->next)
            {
                IDE_TEST( updateLobStorageAttr(aStatement,
                                               sPartAttr->lobAttr,
                                               sPartColumnList[i],
                                               sLastColumn,
                                               sSqlStr,
                                               sPartitionID,
                                               & sPartUpdateCount ) );
            }
        }
    }

    if( sPartUpdateCount > 0 )
    {
        for( sPartInfoList = sNewPartInfoList, i = 0;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            IDE_TEST(smiTable::modifyTableInfo(
                         QC_SMI_STMT(aStatement),
                         sPartInfoList->partHandle,
                         sPartColumnList[i],
                         ID_SIZEOF(mtcColumn),
                         NULL,
                         0,
                         SMI_TABLE_FLAG_UNCHANGE,
                         SMI_TBSLV_DDL_DML,
                         sNewInfo->maxrows,
                         0,
                         ID_TRUE) /* aIsInitRowTemplate */
                     != IDE_SUCCESS);
        }
    }
    else
    {
        // Nothing to do
    }

    if (sUpdateCount > 0 || sPartUpdateCount > 0)
    {
        IDE_TEST(smiTable::modifyTableInfo(
                     QC_SMI_STMT(aStatement),
                     sTableHandle,
                     sColumnList,
                     ID_SIZEOF(mtcColumn),
                     NULL,
                     0,
                     SMI_TABLE_FLAG_UNCHANGE,
                     SMI_TBSLV_DDL_DML,
                     sNewInfo->maxrows,
                     0,
                     ID_TRUE) /* aIsInitRowTemplate */
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do.
    }

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    (void)qcm::destroyQcmTableInfo( sNewInfo );
    sNewInfo = NULL;

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sTableID,
                                           sTableOID )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     &sNewInfo,
                                     &sSCN,
                                     &sTableHandle )
              != IDE_SUCCESS );

    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );
        sNewPartInfoList = NULL;

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        // old partition info 
        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    // old table info 
    (void)qcm::destroyQcmTableInfo(sOldTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeSplitPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *    ALTER TABLE tbl_name SPLIT PARTITION src_part
 *        { AT | VALUES } ( split_cond_value, ... )
 *            INTO ( PARTITION dst_part1, PARTITION dst_part2 )
 *     execution
 *
 *    - In-place Split
 *          - Left In-place Split
 *              ( src_part == dst_part1 )
 *          - Right In-place Split
 *              ( src_part == dst_part2 )
 *
 *    - Out-place Split
 *          ( src_part != dst_part1 ) and ( src_part != dst_part2 )
 *
 *
 * Implementation :
 *      1. In-placec Split( Ƽ ̿ )
 *          1-1. DstPart Ƽ 
 *          1-2. DstPart  Ÿ  Է
 *               (SYS_TABLE_PARTITIONS_, SYS_PART_LOBS_)
 *          1-3. SrcPart DstPart  ̵
 *          1-4. SrcPart Ÿ  
 *               (SYS_TABLE_PARTITIONS_)
 *          1-5.  ε ִ  DstPart  ε 
 *
 *      2. Out-place Split(ο Ƽ 2  )
 *          2-1. DstPart1, DstPart2 Ƽ 
 *          2-2. DstPart1, DstPart2  Ÿ  Է
 *               (SYS_TABLE_PARTITIONS_, SYS_PART_LOBS_)
 *          2-3. SrcPart DstPart1 DstPart2  ̵
 *          2-4. SrcPart  Ÿ  
 *               (SYS_TABLE_PARTITIONS_, SYS_PART_LOBS_)
 *          2-5. SrcPart Ƽ 
 *          2-6.  ε ִ  DstPart1, DstPart2  ε 
 *
 *      3. Ÿ ĳ 籸(Ƽǵ ̺)
 *
 *      4. GLOBAL_DDL ̸鼭 coord. session̸  Ÿ 
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qcmTableInfo            * sOldTableInfo = NULL;
    qcmTableInfo            * sNewTableInfo = NULL;
    qdPartitionAttribute    * sSrcPartAttr;
    qdPartitionAttribute    * sDstPartAttr1;
    qdPartitionAttribute    * sDstPartAttr2;
    qcmTableInfo            * sSrcPartInfo = NULL;
    qcmTableInfo            * sTempInfo1 = NULL;
    void                    * sSrcPartHandle;
    qcmTableInfo            * sDstPartInfo1 = NULL;
    void                    * sDstPartHandle1;
    smSCN                     sDstPartSCN1;
    UInt                      sPartitionID1;
    smOID                     sPartitionOID1;
    qcmTableInfo            * sDstPartInfo2 = NULL;
    qcmTableInfo            * sTempInfo2 = NULL;
    void                    * sDstPartHandle2;
    smSCN                     sDstPartSCN2;
    UInt                      sPartitionID2;
    smOID                     sPartitionOID2;
    smOID                   * sNewPartitionOID;
    SChar                   * sSrcPartMinVal;
    SChar                   * sSrcPartMaxVal;
    SChar                   * sDstPartMinVal;
    SChar                   * sDstPartMaxVal;
    SChar                   * sDstPartMinVal2;
    SChar                   * sDstPartMaxVal2;
    UInt                      sPartOrder;
    UInt                      sIndexCount;
    smSCN                     sSCN = SM_SCN_INIT;
    void                    * sTableHandle = NULL;
    idBool                    sIsReplicated = ID_FALSE;
    idBool                    sIsDDLReplOption = ID_FALSE;

    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc1");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sSrcPartMinVal) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc2");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sSrcPartMaxVal) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc3");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMinVal) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc4");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMaxVal) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc5");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMinVal2) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeSplitPartition::malloc6");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMaxVal2) != IDE_SUCCESS);

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // BUG-42329
    IDU_FIT_POINT( "qdbAlter::executeSplitPartition::beforeXLock" );

    // BUG-42329 : Ƽǵ ̺ LOCK(IX)
    // SrcPart LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                  aStatement,
                  sParseTree->tableHandle,
                  sParseTree->tableSCN,
                  sParseTree->partTable->partInfoList,
                  SMI_TABLE_LOCK_IX,
                  ID_TRUE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    sSrcPartAttr  = sParseTree->partTable->partAttr;
    sDstPartAttr1 = sParseTree->partTable->partAttr->next;
    sDstPartAttr2 = sParseTree->partTable->partAttr->next->next;

    sSrcPartHandle = sParseTree->partTable->partInfoList->partHandle;
    sSrcPartInfo   = sParseTree->partTable->partInfoList->partitionInfo;

    /*
     * PROJ-2757 Advanced Global DDL
     *   split  Ǵ Ƽ usable 
     *   source Ƽ ״ .
     */
    sDstPartAttr1->mIsUsable = sSrcPartInfo->mIsUsable;
    sDstPartAttr2->mIsUsable = sSrcPartInfo->mIsUsable;

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        // Index Table  ʰ DML óϹǷ, IX Lock ´.
        IDE_TEST( qdx::validateAndLockIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      SMI_TBSLV_DDL_DML,
                      SMI_TABLE_LOCK_IX,
                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    /*
     * check replication count on partition
     */
    if ( sSrcPartInfo->replicationCount > 0 )
    {
        sIsReplicated = ID_TRUE;

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1,
                                                                                 sTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode()
                        == SMI_TRANSACTION_REPL_NONE,
                        ERR_CANNOT_WRITE_REPL_INFO );

        /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
         *  Receiver Thread 
         */
        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   &sSrcPartInfo->tableOID,
                                                                   1 )
                  != IDE_SUCCESS );

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLAsycReplOption( aStatement,
                                                                        sSrcPartInfo,
                                                                        &sIsDDLReplOption ) != IDE_SUCCESS );

        if ( ( ( QCG_GET_SESSION_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == ID_TRUE ) &&
               ( QCG_GET_SESSION_TABLE_ID_OF_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == sTableInfo->tableID ) ) ||
             ( QCG_GET_SESSION_TRANSACTIONAL_DDL( aStatement) == ID_TRUE ) ) /* PROJ-2757 */
        {
            IDE_TEST_RAISE( ( qciMisc::isDDLSync( aStatement ) == ID_TRUE ), ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL );
        }
        else
        {
            IDE_TEST_RAISE( ( qciMisc::isDDLSync( aStatement ) != ID_TRUE ) &&
                            ( sIsDDLReplOption != ID_TRUE ), ERR_DDL_WITH_REPLICATED_PARTITION );
        }
        
        if ( ( qciMisc::isDDLSync( aStatement ) == ID_TRUE ) ||
             ( sIsDDLReplOption == ID_TRUE ) )
        {
            //BUG-22703 : Begin Statement  Ŀ Hang ɸ ʾƾ մϴ.
            // mStatistics    մϴ.
            IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                            aStatement->mStatistics,
                                                                            &sSrcPartInfo->tableOID,
                                                                            1 )
                      != IDE_SUCCESS );
        }  
    }
    else
    {
        /* Nothing to do */
    }

    // Ÿ ̺ SrcPart
    // PARTITION_MIN_VALUE, PARTITION_MAX_VALUE ´.
    IDE_TEST( qcmPartition::getPartMinMaxValue( QC_SMI_STMT( aStatement ),
                                                sSrcPartInfo->partitionID,
                                                sSrcPartMinVal,
                                                sSrcPartMaxVal )
              != IDE_SUCCESS );

    switch ( sSrcPartAttr->alterPart->splitMergeType )
    {
        case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
            {
                //-----------------------------------------------------
                // 1-1. Ƽ Ű   Ѵ.
                //-----------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // DstPart2 PARTITION_MIN_VALUE Ƽ   ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMinVal2 )
                              != IDE_SUCCESS );

                    // ⺻ Ƽ ̶ max_value NULL̴.
                    if( idlOS::strlen( sSrcPartMaxVal ) == 0 )
                    {
                        sDstPartMaxVal2[0] = '\0';
                    }
                    // DstPart2 PARTITION_MAX_VALUE SrcPart max_value̴.
                    else
                    {
                        idlOS::memcpy( sDstPartMaxVal2,
                                       sSrcPartMaxVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMaxVal2[idlOS::strlen(sDstPartMaxVal2)] = '\0';
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // ⺻ Ƽ ̶ DstPart2
                    // min, max value NULL̴.
                    if( idlOS::strlen( sSrcPartMinVal ) == 0 )
                    {
                        sDstPartMinVal2[0] = '\0';
                        sDstPartMaxVal2[0] = '\0';
                    }
                    // DstPart2 PARTITION_MIN_VALUE
                    // SrcPart PARTITION_MIN_VALUE
                    //     ̴.
                    // (PARTITION_MAX_VALUE )
                    else
                    {
                        (void) qdbCommon::excludeSplitValFromPartVal( sTableInfo,
                                                                      sSrcPartAttr->alterPart,
                                                                      sDstPartMinVal2 );

                        idlOS::memcpy( sDstPartMaxVal2,
                                       sDstPartMinVal2,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMaxVal2[idlOS::strlen(sDstPartMaxVal2)] = '\0';
                    }

                    // SrcPart PARTITION_MIN_VALUE, PARTITION_MAX_VALUE
                    // Ƽ   ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sSrcPartMinVal )
                              != IDE_SUCCESS );

                    idlOS::memcpy( sSrcPartMaxVal,
                                   sSrcPartMinVal,
                                   ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                    sSrcPartMaxVal[idlOS::strlen(sSrcPartMaxVal)] = '\0';
                }

                //-----------------------------------------------------
                // 1-2. , Ʈ Ƽǵ ̺ Ƽ  
                //-----------------------------------------------------
                sPartOrder = QDB_NO_PARTITION_ORDER;

                // ------------------------------------------------
                // DstPart2 Ƽ   Ÿ  Է
                // ------------------------------------------------
                IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                                           sParseTree,
                                                           sTableInfo,
                                                           sDstPartAttr2,
                                                           sDstPartMinVal2,
                                                           sDstPartMaxVal2,
                                                           sPartOrder,
                                                           &sPartitionID2,
                                                           &sPartitionOID2)
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID2,
                              sPartitionOID2,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart2  ´.
                IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                          sTableInfo->tableID,
                                                          sDstPartAttr2->tablePartName,
                                                          & sDstPartInfo2,
                                                          & sDstPartSCN2,
                                                          & sDstPartHandle2 )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DISK PARTITIONED TABLE  ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo2->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle2,
                                  sSrcPartInfo,
                                  sDstPartInfo2,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                // ------------------------------------------------
                // SrcPart Ÿ  
                // ------------------------------------------------
                //  Ƽǵ ̺ 
                // SrcPart PARTITION_MAX_VALUE    Ѵ.
                // SrcPart max_value DstPart2 min_value̴.
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta (
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sDstPartMinVal2 )
                              != IDE_SUCCESS );
                }
                // Ʈ Ƽǵ ̺ 
                // excludeSplitValFromPartVal Լ س
                // min_value, max_value ̿Ͽ Ÿ ̺ Ѵ.
                else
                {
                    IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta (
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sSrcPartMinVal )
                              != IDE_SUCCESS );

                    IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta (
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sSrcPartMaxVal )
                              != IDE_SUCCESS );
                }

                /* PROJ-2359 Table/Partition Access Option */
                IDE_TEST( updatePartAccessOfTablePartMeta(
                                aStatement,
                                sSrcPartInfo->partitionID,
                                sDstPartAttr1->accessOption )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // SrcPart  ε ִ  DstPart2  ε 
                // ------------------------------------------------
                if( sTableInfo->indices != NULL )
                {
                    IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                              sTableInfo,
                                                              sDstPartInfo2,
                                                              sDstPartAttr2->alterPart->indexPartAttr )
                              != IDE_SUCCESS );
                }

                // ------------------------------------------------
                // PROJ-2334 PMT
                // MEMORY PARTITIONED TABLE  ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo2->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle2,
                                  sSrcPartInfo,
                                  sDstPartInfo2,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID2,
                              sPartitionOID2,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // ο DstPart2  ´.
                IDE_TEST( qcmPartition::getPartitionInfo(
                              aStatement,
                              sTableInfo->tableID,
                              sDstPartAttr2->tablePartName,
                              & sTempInfo2,
                              & sDstPartSCN2,
                              & sDstPartHandle2 )
                          != IDE_SUCCESS );

                //  DstPart2  Ѵ.
                (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo2);
                sDstPartInfo2 = sTempInfo2;
                
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ split  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterSplitPartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo,
                                  sSrcPartInfo,
                                  sDstPartInfo2 )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* do nothing */
                }
            }
            break;

        case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
            {
                //-----------------------------------------------------
                // 1-1. Ƽ Ű   Ѵ.
                //-----------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    //   Ƽ̸ DstPart1 min_value NULL̴.
                    if( idlOS::strlen( sSrcPartMinVal ) == 0 )
                    {
                        sDstPartMinVal[0] = '\0';
                    }
                    else
                    {
                        // DstPart1 PARTITION_MIN_VALUE SrcPart Min Value̴.
                        idlOS::memcpy( sDstPartMinVal,
                                       sSrcPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMinVal[idlOS::strlen(sDstPartMinVal)] = '\0';
                    }

                    // DstPart1 PARTITION_MAX_VALUE Ƽ  ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMaxVal )
                              != IDE_SUCCESS );
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // DstPart1 PARTITION_MIN_VALUE, PARTITION_MAX_VALUE
                    // Ƽ   ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMinVal )
                              != IDE_SUCCESS );

                    idlOS::memcpy( sDstPartMaxVal,
                                   sDstPartMinVal,
                                   ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                    sDstPartMaxVal[idlOS::strlen(sDstPartMaxVal)] = '\0';

                    // ⺻ Ƽ ̶ SrcPart
                    // min, max value NULL̴.
                    if( idlOS::strlen( sSrcPartMinVal ) == 0 )

                    {
                        sSrcPartMinVal[0] = '\0';
                        sSrcPartMaxVal[0] = '\0';
                    }
                    else
                    {
                        // SrcPart PARTITION_MIN_VALUE
                        // Ƽ   PARTITION_MIN_VALUE
                        // Ƽ     ̴.
                        // (PARTITION_MAX_VALUE )
                        (void) qdbCommon::excludeSplitValFromPartVal( sTableInfo,
                                                                      sSrcPartAttr->alterPart,
                                                                      sSrcPartMinVal );

                        idlOS::memcpy( sSrcPartMaxVal,
                                       sSrcPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sSrcPartMaxVal[idlOS::strlen(sSrcPartMaxVal)] = '\0';
                    }
                }

                //-----------------------------------------------------
                // 1-2. , Ʈ Ƽǵ ̺ Ƽ  
                //-----------------------------------------------------
                sPartOrder = QDB_NO_PARTITION_ORDER;

                // ------------------------------------------------
                // DstPart1 Ƽ   Ÿ  Է
                // ------------------------------------------------
                IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                                           sParseTree,
                                                           sTableInfo,
                                                           sDstPartAttr1,
                                                           sDstPartMinVal,
                                                           sDstPartMaxVal,
                                                           sPartOrder,
                                                           &sPartitionID1,
                                                           &sPartitionOID1 )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID1,
                              sPartitionOID1,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart1  ´.
                IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                          sTableInfo->tableID,
                                                          sDstPartAttr1->tablePartName,
                                                          & sDstPartInfo1,
                                                          & sDstPartSCN1,
                                                          & sDstPartHandle1 )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DISK PARTITIONED TABLE   ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo1->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle1,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                // ------------------------------------------------
                // SrcPart Ÿ  
                // ------------------------------------------------
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart PARTITION_MIN_VALUE    
                    // DstPart2 max_value SrcPart min_value̴.
                    IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sDstPartMaxVal )
                              != IDE_SUCCESS );
                }
                else
                {
                    IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta (
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sSrcPartMinVal )
                              != IDE_SUCCESS );

                    IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta (
                                  aStatement,
                                  sSrcPartInfo->partitionID,
                                  sSrcPartMaxVal )
                              != IDE_SUCCESS );
                }

                /* PROJ-2359 Table/Partition Access Option */
                IDE_TEST( updatePartAccessOfTablePartMeta(
                                aStatement,
                                sSrcPartInfo->partitionID,
                                sDstPartAttr2->accessOption )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // SrcPart  ε ִ  DstPart1  ε 
                // ------------------------------------------------
                if( sTableInfo->indices != NULL )
                {
                    IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                              sTableInfo,
                                                              sDstPartInfo1,
                                                              sDstPartAttr1->alterPart->indexPartAttr )
                              != IDE_SUCCESS );
                }

                // ------------------------------------------------
                // PROJ-2334 PMT
                // MEMORY PARTITIONED TABLE   ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo1->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle1,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID1,
                              sPartitionOID1,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                //  DstPart1  ´.
                IDE_TEST( qcmPartition::getPartitionInfo(
                              aStatement,
                              sTableInfo->tableID,
                              sDstPartAttr1->tablePartName,
                              & sTempInfo1,
                              & sDstPartSCN1,
                              & sDstPartHandle1 )
                          != IDE_SUCCESS );

                //  DstPart1  Ѵ.
                (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo1);
                sDstPartInfo1 = sTempInfo1;
                
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ split  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterSplitPartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sSrcPartInfo )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* do nothing */
                }
            }
            break;

        case QD_ALTER_PARTITION_OUTPLACE_TYPE:
            {
                //-----------------------------------------------------
                // 1-1. Ƽ Ű   Ѵ.
                //-----------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    //   Ƽ̸ DstPart1 min_value NULL̴.
                    if( idlOS::strlen( sSrcPartMinVal ) == 0 )
                    {
                        sDstPartMinVal[0] = '\0';
                    }
                    else
                    {
                        // DstPart1 PARTITION_MIN_VALUE SrcPart Min Value̴.
                        idlOS::memcpy( sDstPartMinVal,
                                       sSrcPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMinVal[idlOS::strlen(sDstPartMinVal)] = '\0';
                    }

                    // DstPart1 PARTITION_MAX_VALUE Ƽ  ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMaxVal )
                              != IDE_SUCCESS );

                    // DstPart2 PARTITION_MIN_VALUE Ƽ   ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMinVal2 )
                              != IDE_SUCCESS );

                    // ⺻ Ƽ̸ DstPart2 max_value NULL̴.
                    if( idlOS::strlen( sSrcPartMaxVal ) == 0 )
                    {
                        sDstPartMaxVal2[0] = '\0';
                    }
                    else
                    {
                        // DstPart2 PARTITION_MAX_VALUE SrcPart Max Value̴.
                        idlOS::memcpy( sDstPartMaxVal2,
                                       sSrcPartMaxVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMaxVal2[idlOS::strlen(sDstPartMaxVal2)] = '\0';
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // DstPart1 PARTITION_MIN_VALUE, PARTITION_MAX_VALUE
                    // Ƽ   ̴.
                    IDE_TEST( qdbCommon::getPartCondValueFromParseTree(
                                  aStatement,
                                  sSrcPartAttr,
                                  sDstPartMinVal )
                              != IDE_SUCCESS );

                    idlOS::memcpy( sDstPartMaxVal,
                                   sDstPartMinVal,
                                   ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                    sDstPartMaxVal[idlOS::strlen(sDstPartMaxVal)] = '\0';

                    // ⺻ Ƽ̸ DstPart2 min, max_value NULL̴.
                    if( idlOS::strlen( sSrcPartMinVal ) == 0 )
                    {
                        sDstPartMinVal2[0] = '\0';
                        sDstPartMaxVal2[0] = '\0';
                    }
                    else
                    {
                        // DstPart2 PARTITION_MIN_VALUE
                        // SrcPart PARTITION_MIN_VALUE
                        // Ƽ     ̴.
                        // (PARTITION_MAX_VALUE )
                        (void) qdbCommon::excludeSplitValFromPartVal( sTableInfo,
                                                                      sSrcPartAttr->alterPart,
                                                                      sDstPartMinVal2 );

                        idlOS::memcpy( sDstPartMaxVal2,
                                       sDstPartMinVal2,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );

                        sDstPartMaxVal2[idlOS::strlen(sDstPartMaxVal2)] = '\0';
                    }
                }

                //-----------------------------------------------------
                // 1-2. , Ʈ Ƽǵ ̺ Ƽ  
                //-----------------------------------------------------
                sPartOrder = QDB_NO_PARTITION_ORDER;

                IDE_TEST(qdd::deleteTablePartitionFromMeta(aStatement,
                                                           sSrcPartInfo->partitionID)
                         != IDE_SUCCESS );

                // ------------------------------------------------
                // DstPart1 Ƽ   Ÿ  Է
                // ------------------------------------------------
                IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                                           sParseTree,
                                                           sTableInfo,
                                                           sDstPartAttr1,
                                                           sDstPartMinVal,
                                                           sDstPartMaxVal,
                                                           sPartOrder,
                                                           &sPartitionID1,
                                                           &sPartitionOID1)
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DstPart2 Ƽ   Ÿ  Է
                // ------------------------------------------------
                IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                                           sParseTree,
                                                           sTableInfo,
                                                           sDstPartAttr2,
                                                           sDstPartMinVal2,
                                                           sDstPartMaxVal2,
                                                           sPartOrder,
                                                           &sPartitionID2,
                                                           &sPartitionOID2 )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID1,
                              sPartitionOID1,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID2,
                              sPartitionOID2,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart1  ´.
                IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                          sTableInfo->tableID,
                                                          sDstPartAttr1->tablePartName,
                                                          & sDstPartInfo1,
                                                          & sDstPartSCN1,
                                                          & sDstPartHandle1 )
                          != IDE_SUCCESS );

                // DstPart2  ´.
                IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                          sTableInfo->tableID,
                                                          sDstPartAttr2->tablePartName,
                                                          & sDstPartInfo2,
                                                          & sDstPartSCN2,
                                                          & sDstPartHandle2 )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DISK PARTITIONED TABLE  ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( ( sDstPartInfo1->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK ) &&
                     ( ( sDstPartInfo2->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK ) )
                {
                    IDE_TEST( qdbCommon::moveRowForOutplaceSplitPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle1,
                                  sDstPartHandle2,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sDstPartInfo2,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );

                    // ------------------------------------------------
                    // SrcPart 
                    // ------------------------------------------------
                    IDE_TEST( qdd::dropTablePartitionWithoutMeta( aStatement,
                                                                  sSrcPartInfo )
                              != IDE_SUCCESS );
                }
                else
                {
                    // -----------------------------------------------------
                    // PROJ-2334 PMT
                    // ε Ƽ  Ÿ ̺  
                    // sDstPartInfo  sSrcPartitionInfo   ִ.
                    // -----------------------------------------------------
                    for ( sIndexCount = 0;
                          sIndexCount < sSrcPartInfo->indexCount;
                          sIndexCount++ )
                    {
                        IDE_TEST( qdd::deleteIndexPartitionFromMeta(
                                      aStatement,
                                      sSrcPartInfo->indices[sIndexCount].indexPartitionID )
                                  != IDE_SUCCESS );
                    }
                }

                // ------------------------------------------------
                // SrcPart  ε ִ 
                // DstPart1, DstPart2  ε 
                // ------------------------------------------------
                if( sTableInfo->indices != NULL )
                {
                    IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                              sTableInfo,
                                                              sDstPartInfo1,
                                                              sDstPartAttr1->alterPart->indexPartAttr )
                              != IDE_SUCCESS );

                    IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                              sTableInfo,
                                                              sDstPartInfo2,
                                                              sDstPartAttr2->alterPart->indexPartAttr )
                              != IDE_SUCCESS );
                }
                else
                {
                    // Nothing to do
                }

                // ------------------------------------------------
                // PROJ-2334 PMT
                // MEMORY PARTITIONED TABLE  ̵
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( ( sDstPartInfo1->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK ) ||
                     ( ( sDstPartInfo2->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK ) )
                {
                    IDE_TEST( qdbCommon::moveRowForOutplaceSplitPartition(
                                  aStatement,
                                  sSrcPartHandle,
                                  sDstPartHandle1,
                                  sDstPartHandle2,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sDstPartInfo2,
                                  sParseTree->oldIndexTables,
                                  sSrcPartAttr->alterPart->splitMergeType )
                              != IDE_SUCCESS );

                    // -----------------------------------------------------
                    // SrcPart Ƽ ü 
                    // -----------------------------------------------------
                    IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                                   sSrcPartInfo->tableHandle,
                                                   SMI_TBSLV_DDL_DML )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID1,
                              sPartitionOID1,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID2,
                              sPartitionOID2,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart1  ´.
                IDE_TEST( qcmPartition::getPartitionInfo(
                              aStatement,
                              sTableInfo->tableID,
                              sDstPartAttr1->tablePartName,
                              & sTempInfo1,
                              & sDstPartSCN1,
                              & sDstPartHandle1 )
                          != IDE_SUCCESS );

                //  DstPart1  Ѵ.
                (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo1);
                sDstPartInfo1 = sTempInfo1;
                
                // DstPart2  ´.
                IDE_TEST( qcmPartition::getPartitionInfo(
                              aStatement,
                              sTableInfo->tableID,
                              sDstPartAttr2->tablePartName,
                              & sTempInfo2,
                              & sDstPartSCN2,
                              & sDstPartHandle2 )
                          != IDE_SUCCESS );
                
                //  DstPart2  Ѵ.
                (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo2);
                sDstPartInfo2 = sTempInfo2;
                
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ split  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterSplitPartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo,
                                  sDstPartInfo1,
                                  sDstPartInfo2 )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* do nothing */
                }
            }
            break;

        default:
            /* BUG-44469 [qx] codesonar warning in QX, MT, ST */
            IDE_TEST_RAISE( ID_TRUE, ERR_UNEXPECTED );
            break;

    }

    // To fix BUG-17547
    if( ( sSrcPartAttr->alterPart->splitMergeType ==
          QD_ALTER_PARTITION_LEFT_INPLACE_TYPE ) ||
        ( sSrcPartAttr->alterPart->splitMergeType ==
          QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE ) )
    {
        IDE_TEST(qcmPartition::touchPartition(
                     QC_SMI_STMT( aStatement ),
                     sSrcPartInfo->partitionID)
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do
    }

    if ( sIsReplicated == ID_TRUE )
    {
        // qci::mExecuteReplicationCallback.mExecuteAlterSplitPartition() touch ̹ 
        // н tableinfo  ʿ
        IDE_TEST( qcm::makeAndSetQcmTableInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->tableID,
                      smiGetTableId( sOldTableInfo->tableHandle ) )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sOldTableInfo->tableID,
                                         &sNewTableInfo,
                                         &sSCN,
                                         &sTableHandle )
                  != IDE_SUCCESS );

        // н new tableInfo  ʿ
        sTableInfo = sNewTableInfo;

        if ( sDstPartInfo1 != NULL )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          sPartitionID1,
                          sPartitionOID1,
                          sNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            //  DstPart1  ´.
            IDE_TEST( qcmPartition::getPartitionInfo(
                          aStatement,
                          sNewTableInfo->tableID,
                          sDstPartAttr1->tablePartName,
                          & sTempInfo1,
                          & sDstPartSCN1,
                          & sDstPartHandle1 )
                      != IDE_SUCCESS );

            //  DstPart1  Ѵ.
            (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo1 );
            sDstPartInfo1 = sTempInfo1;
        }
        else
        {
            /* Nothing to do */
        }

        if ( sDstPartInfo2 != NULL )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          sPartitionID2,
                          sPartitionOID2,
                          sNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            // ο DstPart2  ´.
            IDE_TEST( qcmPartition::getPartitionInfo(
                          aStatement,
                          sNewTableInfo->tableID,
                          sDstPartAttr2->tablePartName,
                          & sTempInfo2,
                          & sDstPartSCN2,
                          & sDstPartHandle2 )
                      != IDE_SUCCESS );

            //  DstPart2  Ѵ.
            (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo2 );
            sDstPartInfo2 = sTempInfo2;
        }
        else
        {
            /* Nothing to do */
        }

        if ( ( sIsReplicated == ID_TRUE ) ||
             ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
        {
            IDE_TEST( QC_QMX_MEM( aStatement )->alloc( ID_SIZEOF(smOID) * 2, (void**)&sNewPartitionOID )
                      != IDE_SUCCESS);
            sNewPartitionOID[0] = SM_OID_NULL;
            sNewPartitionOID[1] = SM_OID_NULL;
        }

        /* BUG-45943 Partition Merge / Split DDL synchronization support */
        switch ( sSrcPartAttr->alterPart->splitMergeType )
        {
            case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo->tableOID,
                                                                              sSrcPartInfo->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              SM_OID_NULL,
                                                                              sDstPartInfo2->tableOID )
                          != IDE_SUCCESS );

                sNewPartitionOID[0] =  sSrcPartInfo->tableOID;
                sNewPartitionOID[1] = sDstPartInfo2->tableOID;
                break;

            case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              SM_OID_NULL,
                                                                              sDstPartInfo1->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo->tableOID,
                                                                              sSrcPartInfo->tableOID )
                          != IDE_SUCCESS );

                sNewPartitionOID[0] = sDstPartInfo1->tableOID;
                sNewPartitionOID[1] = sSrcPartInfo->tableOID;
                break;

            case QD_ALTER_PARTITION_OUTPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              SM_OID_NULL,
                                                                              sDstPartInfo1->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              SM_OID_NULL,
                                                                              sDstPartInfo2->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo->tableOID,
                                                                              SM_OID_NULL )
                          != IDE_SUCCESS );
                
                sNewPartitionOID[0] = sDstPartInfo1->tableOID;
                sNewPartitionOID[1] = sDstPartInfo2->tableOID;
                break;

            default:
                IDE_DASSERT(0);
                break;
        }
        
        /* BUG-46252 Partition Merge / Split / Replace DDL asynchronization support */
        if ( qrc::isInternalDDL( aStatement ) != ID_TRUE )
        {
            IDE_TEST( qciMisc::writeDDLStmtTextLog( aStatement,
                                                    sTableInfo->tableOwnerID,
                                                    sTableInfo->name )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }
    }
    else
    {
        /* Nothing to do */
    }

    // BUG-42329
    IDU_FIT_POINT( "qdbAlter::executeSplitPartition::afterTouch" );

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  sParseTree->userName,
                  sParseTree->tableName,
                  sTableInfo->tableID,
                  smiGetTableId(sTableInfo->tableHandle),
                  sTableInfo->columnCount,
                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    if ( ( sIsReplicated == ID_TRUE ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sTableInfo->tableOID),
                             2,
                             sNewPartitionOID );
    }

    // Table Info, Partition Info destroy
    switch ( sSrcPartAttr->alterPart->splitMergeType )
    {
        case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
            break;

        case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
            break;

        case QD_ALTER_PARTITION_OUTPLACE_TYPE:
            (void)qcmPartition::destroyQcmPartitionInfo(sSrcPartInfo);
            break;

        default:
            IDE_DASSERT(0);
            break;
    }

    if ( sIsReplicated == ID_TRUE )
    {
        (void)qcm::destroyQcmTableInfo( sOldTableInfo );
    }
    else
    {
        /* Nothing to do */
    }

    /* PROJ-2757 Advanced Global DDL 
     *   4. GLOBAL_DDL ̸鼭 coord. session̸  Ÿ  */
    if ( ( QCG_GET_SESSION_GLOBAL_DDL( aStatement ) == ID_TRUE ) &&
         ( QCG_GET_SESSION_SHARD_SESSION_TYPE( aStatement ) == SDI_SESSION_TYPE_COORD ) &&
         ( QCM_TABLE_IS_SHARD_SPLIT( sTableInfo->mShardFlag ) == ID_TRUE ) )
    {
        IDE_TEST( sdiGlobalDDL::updateShardMetaForSplitPartition(
                        aStatement,
                        sTableInfo->tableOwnerName,
                        sTableInfo->name )
                  != IDE_SUCCESS );
                                                         
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_PARTITION )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_PART ) );
    }
    IDE_EXCEPTION( ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL ) );
    }
    IDE_EXCEPTION( ERR_UNEXPECTED )
    {
        IDE_SET( ideSetErrorCode( mtERR_ABORT_UNEXPECTED_ERROR,
                                  "executeSplitPartition",
                                  "invalid split type" ) );
    }
    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION_END;

    (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo1 );
    (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo2 );

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   NULL,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeMergePartition(qcStatement * aStatement)
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *    ALTER TABLE ... MERGE PARTITIONS ...  
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo;
    qdPartitionAttribute    * sSrcPartAttr1;
    qdPartitionAttribute    * sSrcPartAttr2;
    qdPartitionAttribute    * sDstPartAttr;
    idBool                    sIsLeftPartIsLess;

    qcmTableInfo            * sSrcPartInfo1 = NULL;
    void                    * sSrcPartHandle1;

    qcmTableInfo            * sSrcPartInfo2 = NULL;
    void                    * sSrcPartHandle2;

    qcmTableInfo            * sDstPartInfo = NULL;
    qcmTableInfo            * sTempInfo = NULL;
    void                    * sDstPartHandle;
    smSCN                     sDstPartSCN;
    smOID                   * sNewPartitionOID = NULL;

    mtdCharType             * sSrcPartMinVal;
    mtdCharType             * sSrcPartMaxVal;
    mtdCharType             * sSrcPartMinVal2;
    mtdCharType             * sSrcPartMaxVal2;
    SChar                   * sDstPartMinVal;
    SChar                   * sDstPartMaxVal;

    UInt                      sPartOrder;
    UInt                      sPartitionID;
    smOID                     sPartitionOID;
    UInt                      sIndexCount;

    qcmTableInfo            * sOldTableInfo = NULL;
    qcmTableInfo            * sNewTableInfo = NULL;
    smSCN                     sSCN = SM_SCN_INIT;
    void                    * sTableHandle = NULL;
    idBool                    sIsReplicated = ID_FALSE;
    idBool                    sIsDDLReplOption1 = ID_FALSE;
    idBool                    sIsDDLReplOption2 = ID_FALSE;

    IDU_LIMITPOINT("qdbAlter::executeMergePartition::malloc1");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMinVal) != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeMergePartition::malloc2");
    IDE_TEST(aStatement->qmxMem->cralloc(
                 ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1),
                 (void**)&sDstPartMaxVal) != IDE_SUCCESS);

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    sSrcPartAttr1  = sParseTree->partTable->partAttr;
    sSrcPartAttr2  = sParseTree->partTable->partAttr->next;
    sDstPartAttr   = sParseTree->partTable->partAttr->next->next;

    sIsLeftPartIsLess = sSrcPartAttr1->alterPart->isLeftPartIsLess;

    // BUG-42329 : Ƽǵ ̺ LOCK(X)
    //  Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                  aStatement,
                  sParseTree->tableHandle,
                  sParseTree->tableSCN,
                  sParseTree->partTable->partInfoList,
                  SMI_TABLE_LOCK_X,
                  ID_TRUE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    // --------------------------------------------------
    // SrcPart1 LOCK(X), ĽƮ SrcPartInfo1 ´.
    // --------------------------------------------------
    sSrcPartHandle1 = sParseTree->partTable->partInfoList->partHandle;
    sSrcPartInfo1   = sParseTree->partTable->partInfoList->partitionInfo;

    // --------------------------------------------------
    // SrcPart2 LOCK(X), ĽƮ SrcPartInfo2 ´.
    // --------------------------------------------------
    sSrcPartHandle2 = sParseTree->partTable->partInfoList->next->partHandle;
    sSrcPartInfo2   = sParseTree->partTable->partInfoList->next->partitionInfo;

    if ( ( sSrcPartInfo1->replicationCount > 0 ) &&
         ( sSrcPartInfo2->replicationCount > 0 ) )
    {
        sIsReplicated = ID_TRUE;
    }
    else
    {
        /* Nothing to do */
    }

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        // Index Table  ʰ DML óϹǷ, IX Lock ´.
        IDE_TEST( qdx::validateAndLockIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      SMI_TBSLV_DDL_DML,
                      SMI_TABLE_LOCK_IX,
                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }
    
    /*
     * PROJ-2336
     * check replication count on partition
     */
    if ( ( sSrcPartInfo1->replicationCount > 0 ) || ( sSrcPartInfo2->replicationCount > 0 ) )
    {
        IDE_TEST_RAISE( ( sSrcPartInfo1->replicationCount == 0 ) || ( sSrcPartInfo2->replicationCount == 0 ),
                        ERR_DDL_WITH_REPLICATED_PARTITION );

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1, 
                                                                                 sTableInfo ) 
                  != IDE_SUCCESS );

        IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode()
                        == SMI_TRANSACTION_REPL_NONE,
                        ERR_CANNOT_WRITE_REPL_INFO );

        /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
         *  Receiver Thread 
         */
        if ( sSrcPartInfo1->replicationCount > 0 )
        {
            IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                       &sSrcPartInfo1->tableOID,
                                                                       1 )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }

        if ( sSrcPartInfo2->replicationCount > 0 )
        {
            IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                       &sSrcPartInfo2->tableOID,
                                                                       1 )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLAsycReplOption( aStatement,
                                                                        sSrcPartInfo1,
                                                                        &sIsDDLReplOption1 ) != IDE_SUCCESS );

        IDE_TEST( qci::mManageReplicationCallback.mIsDDLAsycReplOption( aStatement,
                                                                        sSrcPartInfo2,
                                                                        &sIsDDLReplOption2 ) != IDE_SUCCESS );

        if ( ( QCG_GET_SESSION_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == ID_TRUE ) &&
             ( QCG_GET_SESSION_TABLE_ID_OF_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == sTableInfo->tableID ) )
        {
            IDE_TEST_RAISE( qciMisc::isDDLSync( aStatement ) == ID_TRUE, ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL );
        }
        else
        {
            IDE_TEST_RAISE( ( qciMisc::isDDLSync( aStatement ) != ID_TRUE ) &&
                            ( ( sIsDDLReplOption1 != ID_TRUE ) ||
                              ( sIsDDLReplOption2 != ID_TRUE ) ), ERR_DDL_WITH_REPLICATED_PARTITION );
        }

        if ( ( qciMisc::isDDLSync( aStatement ) == ID_TRUE ) ||
             ( sIsDDLReplOption1 == ID_TRUE ) ||
             ( sIsDDLReplOption2 == ID_TRUE ) )
        {
            if ( sSrcPartInfo1->replicationCount > 0 )
            {            
                IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                                aStatement->mStatistics,
                                                                                &sSrcPartInfo1->tableOID,
                                                                                1 )
                          != IDE_SUCCESS );
            }
            else
            {
                // Nothing to do
            }

            if ( sSrcPartInfo2->replicationCount > 0 )
            {
                IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                                aStatement->mStatistics,
                                                                                &sSrcPartInfo2->tableOID,
                                                                                1 )
                          != IDE_SUCCESS );
            }
            else
            {
                // Nothing to do
            }
        }

    }
    else
    {
        /* Nothing to do */
    }

    // --------------------------------------------------
    // SrcPart1, SrcPart2 min, max_value ĽƮ ´.
    // --------------------------------------------------
    sSrcPartMinVal = sSrcPartAttr1->alterPart->partKeyCondMinValStr;
    sSrcPartMaxVal = sSrcPartAttr1->alterPart->partKeyCondMaxValStr;

    sSrcPartMinVal2 = sSrcPartAttr2->alterPart->partKeyCondMinValStr;
    sSrcPartMaxVal2 = sSrcPartAttr2->alterPart->partKeyCondMaxValStr;

    // ------------------------------------------------
    // In-place, Out-place  ٸ ó
    // ------------------------------------------------
    switch( sSrcPartAttr1->alterPart->splitMergeType )
    {
        case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
            {
                // ------------------------------------------------
                //  ̵(SrcPart2->SrcPart1)
                // ------------------------------------------------
                IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                              aStatement,
                              sSrcPartHandle2,
                              sSrcPartHandle1,
                              sSrcPartInfo2,
                              sSrcPartInfo1,
                              sParseTree->oldIndexTables,
                              sSrcPartAttr1->alterPart->splitMergeType )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DstPart PARTITION_MIN_VALUE, PARTITION_MAX_VALUE Ѵ.
                // ------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart1 SrcPart2  Ƽ    
                    if( sIsLeftPartIsLess == ID_TRUE )
                    {
                        // DstPart max_value SrcPart2 max_value̴.
                        // DstPart min_value  ʴ´.
                        if( sSrcPartMaxVal2->length == 0 )
                        {
                            sDstPartMaxVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMaxVal,
                                           sSrcPartMaxVal2->value,
                                           sSrcPartMaxVal2->length );

                            sDstPartMaxVal[sSrcPartMaxVal2->length] = '\0';
                        }
                    }
                    else
                    {
                        // DstPart min_value SrcPart2 min_value̴.
                        // DstPart max_value  ʴ´.
                        if( sSrcPartMinVal2->length == 0 )
                        {
                            sDstPartMinVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMinVal,
                                           sSrcPartMinVal2->value,
                                           sSrcPartMinVal2->length );

                            sDstPartMinVal[sSrcPartMinVal2->length] = '\0';
                        }
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // յǴ Ƽ   Ƽ ⺻Ƽ̶
                    // DstPart min_value, max_value NULL̴.
                    if( ( sSrcPartMinVal->length == 0 ) ||
                        ( sSrcPartMinVal2->length == 0 ) )
                    {
                        sDstPartMinVal[0] = '\0';
                        sDstPartMaxVal[0] = '\0';
                    }
                    else
                    {
                        // SrcPart1 PARTITION_MIN_VALUE
                        // SrcPart2 PARTITION_MIN_VALUE ؼ
                        // sDstPartMinVal ´.
                        // (PARTITION_MAX_VALUE PARTITION_MIN_VALUE .)
                        qdbCommon::mergePartCondVal( aStatement,
                                                     sDstPartMinVal );

                        idlOS::memcpy( sDstPartMaxVal,
                                       sDstPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );
                    }
                }

                // ------------------------------------------------
                // SrcPart Ÿ  
                // ------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart1 SrcPart2  Ƽ    
                    if( sIsLeftPartIsLess == ID_TRUE )
                    {
                        // SrcPart1 max_value
                        // DstPart max_value Ѵ.
                        IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta(
                                      aStatement,
                                      sSrcPartInfo1->partitionID,
                                      sDstPartMaxVal )
                                  != IDE_SUCCESS );
                    }
                    else
                    {
                        // SrcPart1 min_value
                        // DstPart min_value Ѵ.
                        IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                                      aStatement,
                                      sSrcPartInfo1->partitionID,
                                      sDstPartMinVal )
                                  != IDE_SUCCESS );
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // SrcPart1 min_value
                    // DstPart min_value Ѵ.
                    IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                                  aStatement,
                                  sSrcPartInfo1->partitionID,
                                  sDstPartMinVal )
                              != IDE_SUCCESS );

                    // SrcPart1 max_value
                    // DstPart max_value Ѵ.
                    IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta(
                                  aStatement,
                                  sSrcPartInfo1->partitionID,
                                  sDstPartMaxVal )
                              != IDE_SUCCESS );
                }

                /* PROJ-2359 Table/Partition Access Option */
                IDE_TEST( updatePartAccessOfTablePartMeta(
                                aStatement,
                                sSrcPartInfo1->partitionID,
                                sDstPartAttr->accessOption )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // SrcPart2 
                // ------------------------------------------------
                IDE_TEST( qdd::dropTablePartition( aStatement,
                                                   sSrcPartInfo2,
                                                   ID_FALSE, /* aIsDropTablespace */
                                                   ID_FALSE )
                          != IDE_SUCCESS );

                /* BUG-42851 */
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ merge  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterMergePartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo1,
                                  sSrcPartInfo2,
                                  sSrcPartInfo1 )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* Nothing to do */
                }
            }
            break;

        case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
            {
                // ------------------------------------------------
                //  ̵(SrcPart1->SrcPart2)
                // ------------------------------------------------
                IDE_TEST( qdbCommon::moveRowForInplaceAlterPartition(
                              aStatement,
                              sSrcPartHandle1,
                              sSrcPartHandle2,
                              sSrcPartInfo1,
                              sSrcPartInfo2,
                              sParseTree->oldIndexTables,
                              sSrcPartAttr1->alterPart->splitMergeType )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DstPart PARTITION_MIN_VALUE, PARTITION_MAX_VALUE Ѵ.
                // ------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart1 SrcPart2  Ƽ    
                    if( sIsLeftPartIsLess == ID_TRUE )
                    {
                        // DstPart min_value SrcPart1 min_value̴.
                        // DstPart max_value  ʴ´.
                        if( sSrcPartMinVal->length == 0 )
                        {
                            sDstPartMinVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMinVal,
                                           sSrcPartMinVal->value,
                                           sSrcPartMinVal->length );

                            sDstPartMinVal[sSrcPartMinVal->length] = '\0';
                        }
                    }
                    else
                    {
                        // DstPart max_value SrcPart1 max_value̴.
                        // DstPart min_value  ʴ´.
                        if( sSrcPartMaxVal->length == 0 )
                        {
                            sDstPartMaxVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMaxVal,
                                           sSrcPartMaxVal->value,
                                           sSrcPartMaxVal->length );

                            sDstPartMaxVal[sSrcPartMaxVal->length] = '\0';
                        }
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // յǴ Ƽ   Ƽ ⺻Ƽ̶
                    // DstPart min_value, max_value NULL̴.
                    if( ( sSrcPartMinVal->length == 0 ) ||
                        ( sSrcPartMinVal2->length == 0 ) )
                    {
                        sDstPartMinVal[0] = '\0';
                        sDstPartMaxVal[0] = '\0';
                    }
                    else
                    {
                        // SrcPart1 PARTITION_MIN_VALUE
                        // SrcPart2 PARTITION_MIN_VALUE ؼ
                        // sDstPartMinVal ´.
                        // (PARTITION_MAX_VALUE PARTITION_MIN_VALUE .)
                        qdbCommon::mergePartCondVal( aStatement,
                                                     sDstPartMinVal );

                        idlOS::memcpy( sDstPartMaxVal,
                                       sDstPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );
                    }
                }

                // ------------------------------------------------
                // SrcPart Ÿ  
                // ------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart1 SrcPart2  Ƽ    
                    if( sIsLeftPartIsLess == ID_TRUE )
                    {
                        // SrcPart2 min_value
                        // DstPart min_value Ѵ.
                        IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                                      aStatement,
                                      sSrcPartInfo2->partitionID,
                                      sDstPartMinVal )
                                  != IDE_SUCCESS );
                    }
                    else
                    {
                        // SrcPart2 max_value
                        // DstPart max_value Ѵ.
                        IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta(
                                      aStatement,
                                      sSrcPartInfo2->partitionID,
                                      sDstPartMaxVal )
                                  != IDE_SUCCESS );
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // SrcPart2 min_value
                    // DstPart min_value Ѵ.
                    IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                                  aStatement,
                                  sSrcPartInfo2->partitionID,
                                  sDstPartMinVal )
                              != IDE_SUCCESS );

                    // SrcPart2 max_value
                    // DstPart max_value Ѵ.
                    IDE_TEST( qdbCommon::updatePartMaxValueOfTablePartMeta(
                                  aStatement,
                                  sSrcPartInfo2->partitionID,
                                  sDstPartMaxVal )
                              != IDE_SUCCESS );
                }

                /* PROJ-2359 Table/Partition Access Option */
                IDE_TEST( updatePartAccessOfTablePartMeta(
                                aStatement,
                                sSrcPartInfo2->partitionID,
                                sDstPartAttr->accessOption )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // SrcPart1 
                // ------------------------------------------------
                IDE_TEST( qdd::dropTablePartition( aStatement,
                                                   sSrcPartInfo1,
                                                   ID_FALSE, /* aIsDropTablespace */
                                                   ID_FALSE )
                          != IDE_SUCCESS );

                /* BUG-42851 */
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ merge  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterMergePartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo1,
                                  sSrcPartInfo2,
                                  sSrcPartInfo2 )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* Nothing to do */
                }
            }
            break;

        case QD_ALTER_PARTITION_OUTPLACE_TYPE:
            {
                // ------------------------------------------------
                // DstPart PARTITION_MIN_VALUE, PARTITION_MAX_VALUE Ѵ.
                // ------------------------------------------------
                //  Ƽǵ ̺
                if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
                     ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
                {
                    // SrcPart1 SrcPart2  Ƽ    
                    if( sIsLeftPartIsLess == ID_TRUE )
                    {
                        // DstPart min_value SrcPart1 min_value̴.
                        if( sSrcPartMinVal->length == 0 )
                        {
                            sDstPartMinVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMinVal,
                                           sSrcPartMinVal->value,
                                           sSrcPartMinVal->length );

                            sDstPartMinVal[sSrcPartMinVal->length] = '\0';
                        }

                        // DstPart max_value SrcPart2 max_value̴.
                        if( sSrcPartMaxVal2->length == 0 )
                        {
                            sDstPartMaxVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMaxVal,
                                           sSrcPartMaxVal2->value,
                                           sSrcPartMaxVal2->length );

                            sDstPartMaxVal[sSrcPartMaxVal2->length] = '\0';
                        }
                    }
                    else
                    {
                        // DstPart min_value SrcPart2 min_value̴.
                        if( sSrcPartMinVal2->length == 0 )
                        {
                            sDstPartMinVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMinVal,
                                           sSrcPartMinVal2->value,
                                           sSrcPartMinVal2->length );

                            sDstPartMinVal[sSrcPartMinVal2->length] = '\0';
                        }

                        // DstPart max_value SrcPart1 max_value̴.
                        if( sSrcPartMaxVal->length == 0 )
                        {
                            sDstPartMaxVal[0] = '\0';
                        }
                        else
                        {
                            idlOS::memcpy( sDstPartMaxVal,
                                           sSrcPartMaxVal->value,
                                           sSrcPartMaxVal->length );

                            sDstPartMaxVal[sSrcPartMaxVal->length] = '\0';
                        }
                    }
                }
                // Ʈ Ƽǵ ̺
                else
                {
                    // յǴ Ƽ   Ƽ ⺻Ƽ̶
                    // DstPart min_value, max_value NULL̴.
                    if( ( sSrcPartMinVal->length == 0 ) ||
                        ( sSrcPartMinVal2->length == 0 ) )
                    {
                        sDstPartMinVal[0] = '\0';
                        sDstPartMaxVal[0] = '\0';
                    }
                    else
                    {
                        // SrcPart1 PARTITION_MIN_VALUE
                        // SrcPart2 PARTITION_MIN_VALUE ؼ
                        // sDstPartMinVal ´.
                        // (PARTITION_MAX_VALUE PARTITION_MIN_VALUE .)
                        qdbCommon::mergePartCondVal( aStatement,
                                                     sDstPartMinVal );

                        idlOS::memcpy( sDstPartMaxVal,
                                       sDstPartMinVal,
                                       ID_SIZEOF(SChar) * (QC_MAX_PARTKEY_COND_VALUE_LEN+1) );
                    }
                }

                //-----------------------------------------------------
                // 1-2. , Ʈ Ƽǵ ̺ Ƽ  
                //-----------------------------------------------------
                sPartOrder = QDB_NO_PARTITION_ORDER;

                IDE_TEST(qdd::deleteTablePartitionFromMeta(aStatement,
                                                           sSrcPartInfo1->partitionID)
                         != IDE_SUCCESS );

                IDE_TEST(qdd::deleteTablePartitionFromMeta(aStatement,
                                                           sSrcPartInfo2->partitionID)
                         != IDE_SUCCESS );

                // ------------------------------------------------
                // DstPart1 Ƽ   Ÿ  Է
                // ------------------------------------------------
                IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                                           sParseTree,
                                                           sTableInfo,
                                                           sDstPartAttr,
                                                           sDstPartMinVal,
                                                           sDstPartMaxVal,
                                                           sPartOrder,
                                                           &sPartitionID,
                                                           &sPartitionOID )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID,
                              sPartitionOID,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart  ´.
                IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                          sTableInfo->tableID,
                                                          sDstPartAttr->tablePartName,
                                                          & sDstPartInfo,
                                                          & sDstPartSCN,
                                                          & sDstPartHandle )
                          != IDE_SUCCESS );

                // ------------------------------------------------
                // DISK PARTITIONED TABLE  ̵({SrcPart1, SrcPart2}->DstPart)
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForOutplaceMergePartition(
                                  aStatement,
                                  sSrcPartHandle1,
                                  sSrcPartHandle2,
                                  sDstPartHandle,
                                  sSrcPartInfo1,
                                  sSrcPartInfo2,
                                  sDstPartInfo,
                                  sParseTree->oldIndexTables )
                              != IDE_SUCCESS );

                    // ------------------------------------------------
                    // SrcPart1 
                    // ------------------------------------------------
                    IDE_TEST( qdd::dropTablePartitionWithoutMeta( aStatement,
                                                                  sSrcPartInfo1 )
                              != IDE_SUCCESS );

                    // ------------------------------------------------
                    // SrcPart2 
                    // ------------------------------------------------
                    IDE_TEST( qdd::dropTablePartitionWithoutMeta( aStatement,
                                                                  sSrcPartInfo2 )
                              != IDE_SUCCESS );
                }
                else
                {
                    // -----------------------------------------------------
                    // PROJ-2334 PMT
                    // memory partitioned table ε  data moveϱ
                    //  index partition meta   Ѵ.
                    // ε Ƽ  Ÿ ̺  
                    // -----------------------------------------------------
                    for ( sIndexCount = 0;
                          sIndexCount < sSrcPartInfo1->indexCount;
                          sIndexCount++ )
                    {
                        IDE_TEST( qdd::deleteIndexPartitionFromMeta(
                                      aStatement,
                                      sSrcPartInfo1->indices[sIndexCount].indexPartitionID )
                                  != IDE_SUCCESS );
                    }

                    for ( sIndexCount = 0;
                          sIndexCount < sSrcPartInfo2->indexCount;
                          sIndexCount++ )
                    {
                        IDE_TEST( qdd::deleteIndexPartitionFromMeta(
                                      aStatement,
                                      sSrcPartInfo2->indices[sIndexCount].indexPartitionID )
                                  != IDE_SUCCESS );
                    }

                }
                
                // ------------------------------------------------
                // SrcPart  ε ִ 
                // DstPart  ε 
                // ------------------------------------------------
                if( sTableInfo->indices != NULL )
                {
                    IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                              sTableInfo,
                                                              sDstPartInfo,
                                                              sDstPartAttr->alterPart->indexPartAttr )
                              != IDE_SUCCESS );
                }
                else
                {
                    // Nothing to do
                }

                // ------------------------------------------------
                // PROJ-2334 PMT
                // MEMORY PARTITIONED TABLE  ̵({SrcPart1, SrcPart2}->DstPart)
                // ------------------------------------------------
                /* PROJ-2464 hybrid partitioned table 
                 *  - DstPart Type ϵ Ѵ.
                 *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
                 *  - ,  ü  ϴ Partitioned  ü   Ų.
                 */
                if ( ( sDstPartInfo->tableFlag & SMI_TABLE_TYPE_MASK ) != SMI_TABLE_DISK )
                {
                    IDE_TEST( qdbCommon::moveRowForOutplaceMergePartition(
                                  aStatement,
                                  sSrcPartHandle1,
                                  sSrcPartHandle2,
                                  sDstPartHandle,
                                  sSrcPartInfo1,
                                  sSrcPartInfo2,
                                  sDstPartInfo,
                                  sParseTree->oldIndexTables )
                              != IDE_SUCCESS );

                    // -----------------------------------------------------
                    // SrcPart1 Ƽ ü 
                    // -----------------------------------------------------
                    IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                                   sSrcPartInfo1->tableHandle,
                                                   SMI_TBSLV_DDL_DML )
                              != IDE_SUCCESS );
                    
                    // -----------------------------------------------------
                    // SrcPart2 Ƽ ü 
                    // -----------------------------------------------------
                    IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                                   sSrcPartInfo2->tableHandle,
                                                   SMI_TBSLV_DDL_DML )
                              != IDE_SUCCESS );
                }
                else
                {
                    /* Nothing To Do */
                }

                IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                              QC_SMI_STMT( aStatement ),
                              sPartitionID,
                              sPartitionOID,
                              sTableInfo,
                              NULL )
                          != IDE_SUCCESS );

                // DstPart  ´.
                IDE_TEST( qcmPartition::getPartitionInfo(
                              aStatement,
                              sTableInfo->tableID,
                              sDstPartAttr->tablePartName,
                              & sTempInfo,
                              & sDstPartSCN,
                              & sDstPartHandle )
                          != IDE_SUCCESS );
                
                //  DstPart  Ѵ.
                (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo);
                sDstPartInfo = sTempInfo;
                
                /* BUG-42851 */
                if ( sIsReplicated == ID_TRUE )
                {
                    // BUG-42851 ȭ  Ƽ̸ ڵ merge  Ƽ ȭ 
                    // ߰Ѵ
                    IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterMergePartition(
                                  aStatement,
                                  sTableInfo,
                                  sSrcPartInfo1,
                                  sSrcPartInfo2,
                                  sDstPartInfo )
                              != IDE_SUCCESS );

                    sOldTableInfo = sTableInfo;
                }
                else
                {
                    /* Nothing to do */
                }
            }
            break;

        default:
            IDE_DASSERT(0);
            break;
    }

    // To fix BUG-17547
    if( sSrcPartAttr1->alterPart->splitMergeType ==
        QD_ALTER_PARTITION_LEFT_INPLACE_TYPE )
    {
        IDE_TEST(qcmPartition::touchPartition(
                     QC_SMI_STMT( aStatement ),
                     sSrcPartInfo1->partitionID)
                 != IDE_SUCCESS);
    }
    else if( sSrcPartAttr1->alterPart->splitMergeType ==
             QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE )
    {
        IDE_TEST(qcmPartition::touchPartition(
                     QC_SMI_STMT( aStatement ),
                     sSrcPartInfo2->partitionID)
                 != IDE_SUCCESS);
    }
    else
    {
        // Nothing to do
    }

    if ( sIsReplicated == ID_TRUE )
    {
        // qci::mExecuteReplicationCallback.mExecuteAlterMergePartition() touch ̹ 
        // н tableinfo  ʿ
        IDE_TEST( qcm::makeAndSetQcmTableInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->tableID,
                      smiGetTableId( sOldTableInfo->tableHandle ) )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sOldTableInfo->tableID,
                                         &sNewTableInfo,
                                         &sSCN,
                                         &sTableHandle )
                  != IDE_SUCCESS );

        // н new tableInfo  ʿ
        sTableInfo = sNewTableInfo;

        if ( sDstPartInfo != NULL )
        {
            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          sPartitionID,
                          sPartitionOID,
                          sNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            // DstPart  ´.
            IDE_TEST( qcmPartition::getPartitionInfo(
                          aStatement,
                          sNewTableInfo->tableID,
                          sDstPartAttr->tablePartName,
                          & sTempInfo,
                          & sDstPartSCN,
                          & sDstPartHandle )
                      != IDE_SUCCESS );

            //  DstPart  Ѵ.
            (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo);
            sDstPartInfo = sTempInfo;
        }
        else
        {
            /* Nothing to do */
        }

        if ( ( sIsReplicated == ID_TRUE ) ||
             ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
        {
            IDE_TEST( QC_QMX_MEM( aStatement )->alloc( ID_SIZEOF(smOID), (void**)&sNewPartitionOID )
                      != IDE_SUCCESS);
        }

        /* BUG-45943 Partition Merge / Split DDL synchronization support */
        switch ( sSrcPartAttr1->alterPart->splitMergeType )
        {
            case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo1->tableOID,
                                                                              sSrcPartInfo1->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo2->tableOID,
                                                                              SM_OID_NULL )
                          != IDE_SUCCESS );

                sNewPartitionOID[0] = sSrcPartInfo1->tableOID;
                break;
            case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo1->tableOID,
                                                                              SM_OID_NULL )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo2->tableOID,
                                                                              sSrcPartInfo2->tableOID )
                          != IDE_SUCCESS );

                sNewPartitionOID[0] = sSrcPartInfo2->tableOID;
                break;

            case QD_ALTER_PARTITION_OUTPLACE_TYPE:
                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              SM_OID_NULL,
                                                                              sDstPartInfo->tableOID )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo1->tableOID,
                                                                              SM_OID_NULL )
                          != IDE_SUCCESS );

                IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                              sSrcPartInfo2->tableOID,
                                                                              SM_OID_NULL )
                          != IDE_SUCCESS );

                sNewPartitionOID[0] = sDstPartInfo->tableOID;
                break;

            default:
                IDE_DASSERT(0);
                break;
        }
        
        /* BUG-46252 Partition Merge / Split / Replace DDL asynchronization support */
        if ( qrc::isInternalDDL( aStatement ) != ID_TRUE )
        {
            IDE_TEST( qciMisc::writeDDLStmtTextLog( aStatement,
                                                    sTableInfo->tableOwnerID,
                                                    sTableInfo->name )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }
    }
    else
    {
        /* Nothing to do */
    }

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  sParseTree->userName,
                  sParseTree->tableName,
                  sTableInfo->tableID,
                  smiGetTableId(sTableInfo->tableHandle),
                  sTableInfo->columnCount,
                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    if ( ( sIsReplicated == ID_TRUE ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sTableInfo->tableOID),
                             1,
                             sNewPartitionOID );
    }

    // Table Info, Partition Info destroy
    switch( sSrcPartAttr1->alterPart->splitMergeType )
    {
        case QD_ALTER_PARTITION_LEFT_INPLACE_TYPE:
            (void)qcmPartition::destroyQcmPartitionInfo(sSrcPartInfo2);
            break;

        case QD_ALTER_PARTITION_RIGHT_INPLACE_TYPE:
            (void)qcmPartition::destroyQcmPartitionInfo(sSrcPartInfo1);
            break;

        case QD_ALTER_PARTITION_OUTPLACE_TYPE:
            (void)qcmPartition::destroyQcmPartitionInfo(sSrcPartInfo1);
            (void)qcmPartition::destroyQcmPartitionInfo(sSrcPartInfo2);
            break;

        default:
            IDE_DASSERT(0);
            break;
    }

    if ( sIsReplicated == ID_TRUE )
    {
        (void)qcm::destroyQcmTableInfo( sOldTableInfo );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_PARTITION )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_PART ) );
    }
    IDE_EXCEPTION( ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL ) );
    }
    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION_END;

    (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo );

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   NULL,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeDropPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo = NULL;
    qcmTableInfo            * sOldTableInfo = NULL;
    qcmTableInfo            * sNewTableInfo = NULL;

    smSCN                     sSCN = SM_SCN_INIT;
    void                    * sTableHandle  = NULL;
    qcmTableInfo            * sDropPartInfo = NULL;
    qcmTableInfo            * sRightPartInfo;
    idBool                    sIsReplicated = ID_FALSE;

    SChar                     sPartMinVal[QC_MAX_PARTKEY_COND_VALUE_LEN+1];
    SChar                     sPartMaxVal[QC_MAX_PARTKEY_COND_VALUE_LEN+1];

    SChar                     sRightPartMinVal[QC_MAX_PARTKEY_COND_VALUE_LEN+1];
    SChar                     sRightPartMaxVal[QC_MAX_PARTKEY_COND_VALUE_LEN+1];

    idBool                    sIsDDLReplOption = ID_FALSE;

    idlOS::memset( sPartMinVal, 0x00, QC_MAX_PARTKEY_COND_VALUE_LEN+1 );
    idlOS::memset( sPartMaxVal, 0x00, QC_MAX_PARTKEY_COND_VALUE_LEN+1 );

    idlOS::memset( sRightPartMinVal, 0x00, QC_MAX_PARTKEY_COND_VALUE_LEN+1 );
    idlOS::memset( sRightPartMaxVal, 0x00, QC_MAX_PARTKEY_COND_VALUE_LEN+1 );

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // BUG-43243 IX -> X
    // Ƽǵ ̺ LOCK(X)
    //  Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                  aStatement,
                  sParseTree->tableHandle,
                  sParseTree->tableSCN,
                  sParseTree->partTable->partInfoList,
                  SMI_TABLE_LOCK_X,
                  ID_FALSE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    sDropPartInfo = sParseTree->partTable->partInfoList->partitionInfo;

    if ( sDropPartInfo->replicationCount > 0 )
    {
        sIsReplicated = ID_TRUE;
    }
    else
    {
        /* Nothing to do */
    }

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        // Index Table  ʰ DML óϹǷ, IX Lock ´.
        IDE_TEST( qdx::validateAndLockIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      SMI_TBSLV_DDL_DML,
                      SMI_TABLE_LOCK_IX,
                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    /*
     * check replication count on partition
     */
    if ( sIsReplicated == ID_TRUE )
    {  
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1, 
                                                                                 sTableInfo ) 
                  != IDE_SUCCESS );

        IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode()
                        == SMI_TRANSACTION_REPL_NONE,
                        ERR_CANNOT_WRITE_REPL_INFO );

        /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
         *  Receiver Thread 
         */
        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   &sDropPartInfo->tableOID,
                                                                   1 )
                  != IDE_SUCCESS );
        
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLAsycReplOption( aStatement,
                                                                        sDropPartInfo,
                                                                        &sIsDDLReplOption ) != IDE_SUCCESS );

        if ( ( QCG_GET_SESSION_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == ID_TRUE ) &&
             ( QCG_GET_SESSION_TABLE_ID_OF_LOCK_TABLE_UNTIL_NEXT_DDL( aStatement ) == sTableInfo->tableID ) )
        {
            IDE_TEST_RAISE( qciMisc::isDDLSync( aStatement ) == ID_TRUE, ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL );
        }
        else
        {
            IDE_TEST_RAISE( ( qciMisc::isDDLSync( aStatement ) != ID_TRUE ) &&
                            ( sIsDDLReplOption != ID_TRUE ), ERR_DDL_WITH_REPLICATED_PARTITION );
        }
        
        if ( ( qciMisc::isDDLSync( aStatement ) == ID_TRUE ) ||
             ( sIsDDLReplOption == ID_TRUE ) )
        {
            //BUG-22703 : Begin Statement  Ŀ Hang ɸ ʾƾ մϴ.
            // mStatistics    մϴ.
            IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                            aStatement->mStatistics,
                                                                            &sDropPartInfo->tableOID,
                                                                            1 )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    // ------------------------------------------------
    //  Ƽǵ ̸̺  Ƽ PARTITION_MIN_VALUE 
    // ------------------------------------------------
    if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
         ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
    {
        sRightPartInfo =
            sParseTree->partTable->partInfoList->next->partitionInfo;

        //  Ƽ min_value Ѵ.
        IDE_TEST( qcmPartition::getPartMinMaxValue( QC_SMI_STMT( aStatement ),
                                                    sDropPartInfo->partitionID,
                                                    sPartMinVal,
                                                    sPartMaxVal )
                  != IDE_SUCCESS );

        // BUG-47599
        // ֽ viewSCN  ϴ  : validate execute  Ÿ 
        IDE_TEST( qcmPartition::getPartMinMaxValue( QC_SMI_STMT( aStatement ),
                                                    sRightPartInfo->partitionID,
                                                    sRightPartMinVal,
                                                    sRightPartMaxVal )
                  != IDE_SUCCESS );

        //  Ƽ max  Ƽ min  Ȯ
        IDE_TEST_RAISE( ( idlOS::strMatch( sPartMaxVal,
                                           idlOS::strlen(sPartMaxVal),  
                                           sRightPartMinVal,
                                           idlOS::strlen(sRightPartMinVal) ) != 0 ),
                        ERR_REBUILD ); 

        //   Ƽ min_value
        //  Ƽ min_value Ѵ.
        IDE_TEST( qdbCommon::updatePartMinValueOfTablePartMeta(
                      aStatement,
                      sRightPartInfo->partitionID,
                      sPartMinVal )
                  != IDE_SUCCESS );
    }
    else
    {
        // Ʈ Ƽǵ ̺
        // Nothing to do
    }

    // ------------------------------------------------
    // index table drop partition oid 
    // ------------------------------------------------

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        IDE_TEST( qdx::deletePartitionInIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      smiGetTableId(sDropPartInfo->tableHandle) )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }
    
    // ------------------------------------------------
    // Ÿ ̺ ش Ƽǿ õ  
    // Ƽ 
    // ------------------------------------------------
    IDE_TEST(qdd::dropTablePartition( aStatement,
                                      sDropPartInfo,
                                      ID_FALSE, /* aIsDropTablespace */
                                      ID_FALSE )
             != IDE_SUCCESS );

    // BUG-43243
    if ( sIsReplicated == ID_TRUE )
    {
        IDE_TEST( qci::mExecuteReplicationCallback.mExecuteAlterDropPartition( 
                    aStatement,
                    sTableInfo,
                    sDropPartInfo ) 
                  != IDE_SUCCESS );

        sOldTableInfo = sTableInfo;

        // qci::mExecuteReplicationCallback.mExecuteAlterDropPartition() touch ̹ 
        //   н sOldTableInfo   ʿ
        IDE_TEST( qcm::makeAndSetQcmTableInfo( 
                        QC_SMI_STMT( aStatement ),
                        sOldTableInfo->tableID,
                        smiGetTableId( sOldTableInfo->tableHandle ) )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sOldTableInfo->tableID,
                                         &sNewTableInfo,
                                         &sSCN,
                                         &sTableHandle ) 
                  != IDE_SUCCESS );
        //   н sNewTableInfo  Ǿ 
        sTableInfo = sNewTableInfo;

        // table Partition   metaCache ̹Ƿ   ʴ´.

        /* BUG-46457 Drop Partition DDL asynchronization support */
        IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                      sDropPartInfo->tableOID,
                                                                      SM_OID_NULL )
                  != IDE_SUCCESS );

        if ( ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE ) ||
             ( sTableInfo->partitionMethod == QCM_PARTITION_METHOD_RANGE_USING_HASH ) )
        {
            sRightPartInfo = sParseTree->partTable->partInfoList->next->partitionInfo;

            IDE_TEST( qci::mManageReplicationCallback.mWriteTableMetaLog( aStatement,
                                                                          sRightPartInfo->tableOID,
                                                                          sRightPartInfo->tableOID )
                      != IDE_SUCCESS );

        }
        else
        {
            // Nothing to do
        }

        if ( qrc::isInternalDDL( aStatement ) != ID_TRUE )
        {
            IDE_TEST( qciMisc::writeDDLStmtTextLog( aStatement,
                                                    sTableInfo->tableOwnerID,
                                                    sTableInfo->name )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do
        }
    }
    else
    {
        /* Nothing to do */
    }

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  sParseTree->userName,
                  sParseTree->tableName,
                  sTableInfo->tableID,
                  smiGetTableId(sTableInfo->tableHandle),
                  sTableInfo->columnCount,
                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // Ÿ ĳ 
    (void)qcmPartition::destroyQcmPartitionInfo(sDropPartInfo);

    if ( sIsReplicated == ID_TRUE )
    {
        (void)qcm::destroyQcmTableInfo( sOldTableInfo );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_PARTITION )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_PART ) );
    }
    IDE_EXCEPTION( ERR_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_SYNC_WITH_LOCK_UNTIL_NEXT_DDL ) );
    }
    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION( ERR_REBUILD )
    {
        IDE_TEST( ideSetErrorCode( smERR_REBUILD_smiTableModified ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   NULL,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeRenamePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *    ALTER TABLE t1 RENAME PARTITION old_part TO new_part;
 *     execution
 *
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo     = NULL;
    qcmTableInfo            * sPartInfo      = NULL;
    SChar                     sNewPartName[QC_MAX_OBJECT_NAME_LEN + 1];

    qcmTableInfo            * sNewPartInfo   = NULL;
    void                    * sNewPartHandle = NULL;
    smSCN                     sNewSCN        = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // Ƽǵ ̺ LOCK(IX)
    // Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                  aStatement,
                  sParseTree->tableHandle,
                  sParseTree->tableSCN,
                  sParseTree->partTable->partInfoList,
                  SMI_TABLE_LOCK_IX,
                  ID_FALSE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    sPartInfo = sParseTree->partTable->partInfoList->partitionInfo;

    IDE_TEST_RAISE( sPartInfo->replicationCount > 0,
                    ERR_DDL_WITH_REPLICATED_PARTITION );

    QC_STR_COPY( sNewPartName, sParseTree->partTable->partAttr->next->tablePartName );

    // Ƽ ̸ Ʈ
    IDE_TEST( qdbCommon::updatePartNameOfTablePartMeta (
                  aStatement,
                  sPartInfo->partitionID,
                  sNewPartName )
              != IDE_SUCCESS );

    // To fix BUG-17547
    IDE_TEST(qcmPartition::touchPartition(
                 QC_SMI_STMT( aStatement ),
                 sPartInfo->partitionID)
             != IDE_SUCCESS);

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  sParseTree->userName,
                  sParseTree->tableName,
                  sTableInfo->tableID,
                  smiGetTableId(sTableInfo->tableHandle),
                  sTableInfo->columnCount,
                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                  QC_SMI_STMT( aStatement ),
                  sPartInfo->partitionID,
                  smiGetTableId( sPartInfo->tableHandle ),
                  sTableInfo,
                  NULL )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                              sTableInfo->tableID,
                                              (UChar *)sNewPartName,
                                              (SInt)idlOS::strlen( sNewPartName ),
                                              & sNewPartInfo,
                                              & sNewSCN,
                                              & sNewPartHandle )
              != IDE_SUCCESS );

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // Ÿ ĳ 
    (void)qcmPartition::destroyQcmPartitionInfo(sPartInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_PARTITION )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_PART ) );
    }
    IDE_EXCEPTION_END;

    (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfo );

    qcmPartition::restoreTempInfoForPartition( sTableInfo,
                                               sPartInfo );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeTruncatePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 * Replication ɸ Table  DDL , ߰ Ʒ ۾ Ѵ.
 *    1. Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
 *    2.  Receiver Thread 
 *    3. SYS_REPL_ITEMS_ TABLE_OID ÷ 
 *    4. Table Meta Log Record 
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo   = NULL;
    smOID                     sNewPartOID;
    smOID                     sOldPartOID;
    smOID                   * sNewPartitionOID = NULL;
    UInt                      sIndexCount;
    smiColumnList           * sColumnListAtKey;
    UInt                      sFlag = 0;

    qcmTableInfo            * sOldPartInfo = NULL;
    const void              * sIndexHandle;
    idBool                    sIsReplicatedTable = ID_FALSE;
    smiSegAttr                sSegAttr;
    smiSegStorageAttr         sSegStoAttr;

    UInt                      sPartType         = 0;

    qcmTableInfo            * sNewPartInfo   = NULL;
    void                    * sNewPartHandle = NULL;
    smSCN                     sNewSCN        = SM_SCN_INIT;

    qcmColumn               * sTempColumns = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // Ƽǵ ̺ LOCK(IX)
    // Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                  aStatement,
                  sParseTree->tableHandle,
                  sParseTree->tableSCN,
                  sParseTree->partTable->partInfoList,
                  SMI_TABLE_LOCK_IX,
                  ID_FALSE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        // Index Table  ʰ DML óϹǷ, IX Lock ´.
        IDE_TEST( qdx::validateAndLockIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      SMI_TBSLV_DDL_DML,
                      SMI_TABLE_LOCK_IX,
                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }
    
    sTableInfo = sParseTree->tableInfo;

    sOldPartInfo = sParseTree->partTable->partInfoList->partitionInfo;
    sOldPartOID  = smiGetTableId(sOldPartInfo->tableHandle);
    sPartType    = sOldPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
     * Validate Execute ٸ Transaction̹Ƿ, Ƽ ˻ Execute Ѵ.
     */
    if(sTableInfo->replicationCount > 0)
    {
        IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 0, 
                                                                                 sTableInfo )
                  != IDE_SUCCESS );

        IDE_TEST_RAISE(QC_SMI_STMT(aStatement)->getTrans()->getReplicationMode()
                       == SMI_TRANSACTION_REPL_NONE,
                       ERR_CANNOT_WRITE_REPL_INFO);

        /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
         *  Receiver Thread 
         */
        IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                   &sOldPartOID,
                                                                   1 )
                  != IDE_SUCCESS );

        //BUG-22703 : Begin Statement  Ŀ Hang ɸ ʾƾ մϴ.
        // mStatistics    մϴ.
        IDE_TEST(qci::mManageReplicationCallback.mStopReceiverThreads(
                                                        QC_SMI_STMT(aStatement),
                                                        aStatement->mStatistics,
                                                        &sOldPartOID,
                                                        1 )
                 != IDE_SUCCESS);

        sIsReplicatedTable = ID_TRUE;
    }

    /* PROJ-2464 hybrid partitioned table 
     *  - Partition Info  , Table Option Partitioned Table  Ѵ.
     *  - , PartInfo  ̿ ʰ, TBSID    ؼ ̿Ѵ.
     */
    qdbCommon::adjustPhysicalAttr( sPartType,
                                   sTableInfo->segAttr,
                                   sTableInfo->segStoAttr,
                                   & sSegAttr,
                                   & sSegStoAttr,
                                   ID_TRUE /* aIsTable */ );

    /* BUG-45503 Table  Ŀ  , Table Meta Cache Column   ʴ 찡 ֽϴ. */
    IDE_TEST( qcm::copyQcmColumns( QC_QMX_MEM( aStatement ),
                                   sOldPartInfo->columns,
                                   & sTempColumns,
                                   sOldPartInfo->columnCount )
              != IDE_SUCCESS );

    IDE_TEST(qdbCommon::createTableOnSM( aStatement,
                                         sTempColumns,
                                         sTableInfo->tableOwnerID,
                                         sTableInfo->tableID,
                                         sTableInfo->maxrows,
                                         sOldPartInfo->TBSID,
                                         sSegAttr,
                                         sSegStoAttr,
                                         /*  Table Flag
                                            °  =>
                                            MASK Ʈ  1μ*/
                                         QDB_TABLE_ATTR_MASK_ALL,
                                         sTableInfo->tableFlag, /* Flag Value */
                                         sTableInfo->parallelDegree,
                                         & sNewPartOID )
             != IDE_SUCCESS);

    // BUG-44814 ddl    縦 ؾ
    smiStatistics::copyTableStats( smiGetTable(sNewPartOID), sOldPartInfo->tableHandle, NULL, 0 );

    // SYS_TABLE_PARTITIONS_ PARTITION_OID Ʈ
    IDE_TEST(qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                     sTableInfo->tableID,
                                                     sOldPartInfo->partitionID,
                                                     sNewPartOID )
             != IDE_SUCCESS );

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sParseTree->tableInfo->tableID,
                 smiGetTableId(sParseTree->tableInfo->tableHandle),
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    // ------------------------------------------------
    // ε ϸ
    // re-create index!!
    // ------------------------------------------------
    // ٸ ̺ Ƽǿ ִ
    //  ε  Ȱ ؾ Ѵ.
    for( sIndexCount = 0;
         sIndexCount < sOldPartInfo->indexCount;
         sIndexCount++ )
    {
        // ε   flag
        sFlag = smiTable::getIndexInfo(sOldPartInfo->indices[sIndexCount].indexHandle);
        sSegAttr = smiTable::getIndexSegAttr(sOldPartInfo->indices[sIndexCount].indexHandle);
        sSegStoAttr = smiTable::getIndexSegStoAttr(sOldPartInfo->indices[sIndexCount].indexHandle);

        // ε   Ű ÷  Ѵ.
        IDE_TEST( qdx::getKeyColumnList( aStatement,
                                         & sOldPartInfo->indices[sIndexCount],
                                         & sColumnListAtKey )
                  != IDE_SUCCESS );

        /* PROJ-2464 hybrid partitioned table 
         *  - ó : PROJ-2433
         */
        IDE_TEST( smiTable::createIndex(aStatement->mStatistics,
                                        QC_SMI_STMT( aStatement ),
                                        sOldPartInfo->indices[sIndexCount].TBSID,
                                        smiGetTable( sNewPartOID ),
                                        (SChar*)sOldPartInfo->indices[sIndexCount].name,
                                        sOldPartInfo->indices[sIndexCount].indexId,
                                        sOldPartInfo->indices[sIndexCount].indexTypeId,
                                        sColumnListAtKey,
                                        sFlag,
                                        QD_INDEX_DEFAULT_PARALLEL_DEGREE,
                                        SMI_INDEX_BUILD_UNCOMMITTED_ROW_DISABLE,
                                        sSegAttr,
                                        sSegStoAttr,
                                        0, /* BUG-42124 : direct key index partitioned table  ʴ´. */
                                        & sIndexHandle )
                  != IDE_SUCCESS );
    }

    // ------------------------------------------------
    // index table old partition oid 
    // ------------------------------------------------

    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        IDE_TEST( qdx::deletePartitionInIndexTableList(
                      aStatement,
                      sParseTree->oldIndexTables,
                      sOldPartOID )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }
    
    /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
     * SYS_REPL_ITEMS_ TABLE_OID ÷ 
     */
    if(sIsReplicatedTable == ID_TRUE)
    {
        IDE_TEST(qci::mCatalogReplicationCallback.mUpdateReplMetaTableOIDArray( aStatement,
                                                                                &sOldPartOID,
                                                                                &sNewPartOID,
                                                                                1 )
                 != IDE_SUCCESS);
    }

    // Ÿ ĳ 
    IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                  QC_SMI_STMT( aStatement ),
                  sOldPartInfo->partitionID,
                  sNewPartOID,
                  sTableInfo,
                  NULL )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                              sTableInfo->tableID,
                                              (UChar *)sOldPartInfo->name,
                                              (SInt)idlOS::strlen( sOldPartInfo->name ),
                                              & sNewPartInfo,
                                              & sNewSCN,
                                              & sNewPartHandle )
              != IDE_SUCCESS );

    // ------------------------------------------------
    // OldPart 
    // ------------------------------------------------
    IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                   sOldPartInfo->tableHandle,
                                   SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    /* BUG-20514 (PROJ-1442) Partition  Truncate ؾ մϴ.
     * Table Meta Log Record 
     */
    if(sIsReplicatedTable == ID_TRUE)
    {
        IDE_TEST(qci::mManageReplicationCallback.mWriteTableMetaLog(
                aStatement,
                sOldPartOID,
                sNewPartOID)
            != IDE_SUCCESS);
    }

    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        IDE_TEST( QC_QMX_MEM( aStatement )->alloc( ID_SIZEOF(smOID), (void**)&sNewPartitionOID )
                  != IDE_SUCCESS);
        sNewPartitionOID[0] = sNewPartOID;

        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sTableInfo->tableOID),
                             1,
                             sNewPartitionOID );
    }

    // Ÿ ĳ 
    (void)qcmPartition::destroyQcmPartitionInfo(sOldPartInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_CANNOT_WRITE_REPL_INFO)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO));
    }
    IDE_EXCEPTION_END;

    (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfo );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeRowmovement( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree    * sParseTree;
    qcmTableInfo        * sTableInfo        = NULL;
    UInt                  sTableID;
    smOID                 sTableOID;
    SChar               * sTrueFalse[2] = {(SChar*)"T", (SChar*)"F"};
    SChar               * sIsRowmovement;
    SChar               * sSqlStr;
    vSLong                sRowCnt;

    qcmPartitionInfoList * sAllPartInfoList = NULL;
    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // Ƽǵ ̺ LOCK(X)
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;
    sTableID = sTableInfo->tableID;

    IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                  QC_SMI_STMT( aStatement ),
                                                  QC_QMX_MEM( aStatement ),
                                                  sTableInfo->tableID,
                                                  & sAllPartInfoList )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                              sAllPartInfoList,
                                                              SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                              SMI_TABLE_LOCK_X,
                                                              smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
              != IDE_SUCCESS );

    //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
    sOldPartInfoList = sAllPartInfoList;

    if( sParseTree->partTable->partAttr->alterPart->alterType ==
        QD_ENABLE_ROW_MOVEMENT )
    {
        sIsRowmovement = sTrueFalse[0];
    }
    else if( sParseTree->partTable->partAttr->alterPart->alterType ==
             QD_DISABLE_ROW_MOVEMENT )
    {
        sIsRowmovement = sTrueFalse[1];
    }
    else
    {
        // TASK-3876 Code Sonar
        //  ʴ case
        IDE_ASSERT( 0 );
    }

    IDU_LIMITPOINT("qdbAlter::executeRowmovement::malloc");
    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                    SChar,
                                    QD_MAX_SQL_LENGTH,
                                    &sSqlStr)
             != IDE_SUCCESS);

    // SYS_PART_TABLES_ ROW_MOVEMENT  
    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_PART_TABLES_ "
                     "SET ROW_MOVEMENT = CHAR'%s' "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     sIsRowmovement,
                     sTableID );

    IDE_TEST(qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                sSqlStr,
                                & sRowCnt ) != IDE_SUCCESS);

    IDE_TEST_RAISE(sRowCnt != 1, ERR_META_CRASH);

    // rebuild tableInfo
    sTableOID = smiGetTableId(sTableInfo->tableHandle);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sTableID,
                 sTableOID,
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableID,
                 sTableOID) != IDE_SUCCESS);

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                    sOldPartInfoList )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                  sNewTableInfo,
                                                                  sOldPartInfoList,
                                                                  & sNewPartInfoList )
              != IDE_SUCCESS );

    (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );

    (void)qcm::destroyQcmTableInfo(sTableInfo);

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAddPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qdPartitionAttribute    * sDstPartAttr;
    qcmTableInfo            * sTableInfo = NULL;
    qcmTableInfo            * sSrcPartInfo = NULL;
    qcmTableInfo            * sDstPartInfo = NULL;
    qcmTableInfo           ** sNewPartInfoArr = NULL;
    qcmPartitionInfoList    * sPartInfoList = NULL;
    qcmPartitionInfoList    * sSrcPartInfoList = NULL;
    UInt                      sDstPartCount;

    SChar                     sPartMinVal[1];
    SChar                     sPartMaxVal[1];
    UInt                      sDstPartOrder;

    UInt                    * sPartitionID;
    smOID                   * sNewPartitionOID = NULL;
    UInt                      i;
    UInt                      sFlag = 0;
    const void              * sIndexHandle;
    UInt                      sIndexCount = 0;
    smiColumnList           * sColumnListAtKey;
    smiSegAttr                sSegAttr;
    smiSegStorageAttr         sSegStoAttr;
    qdIndexTableList        * sIndexTable;
    qcmIndex                * sNewIndices = NULL;

    qcmTableInfo            * sNewTableInfo = NULL;
    void                    * sTableHandle;
    smOID                     sTableOID;
    smSCN                     sSCN;

    void                    * sDstPartHandle    = NULL;
    smSCN                     sDstPartSCN;
    SInt                      sTempMemType      = 0;
    SInt                      sTempVolType      = 0;
    SInt                      sCountMemType     = 0;
    SInt                      sCountVolType     = 0;
    UInt                      sPartType         = 0;

    qcmColumn               * sTempColumns = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;
    sDstPartAttr = sParseTree->partTable->partAttr;

    // Ƽǵ ̺ LOCK(X)
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    //  Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                              sParseTree->partTable->partInfoList,
                                                              SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                              SMI_TABLE_LOCK_X,
                                                              smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
              != IDE_SUCCESS );

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDE_TEST( smiStatement::setViewSCNOfAllStmt( QC_SMI_STMT( aStatement ) )
              != IDE_SUCCESS );

    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                  sParseTree->oldIndexTables,
                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                  SMI_TABLE_LOCK_X,
                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
              != IDE_SUCCESS );
        
    sTableInfo = sParseTree->tableInfo;

    sSrcPartInfoList = sParseTree->partTable->partInfoList;

    for( sPartInfoList = sSrcPartInfoList, sDstPartCount = 1;
         sPartInfoList != NULL;
         sPartInfoList = sPartInfoList->next, sDstPartCount++ )
    {
        // Nothing to do.
    }

    IDU_LIMITPOINT("qdbAlter::executeAddPartition::malloc1");
    IDE_TEST(aStatement->qmxMem->cralloc(ID_SIZEOF(smOID) * sDstPartCount,
                                         (void**)&sNewPartitionOID)
             != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeAddPartition::malloc2");
    IDE_TEST(aStatement->qmxMem->cralloc(ID_SIZEOF(UInt) * sDstPartCount,
                                         (void**)&sPartitionID)
             != IDE_SUCCESS);

    for( i = 0, sPartInfoList = sSrcPartInfoList;
         sPartInfoList != NULL;
         sPartInfoList = sPartInfoList->next, i++ )
    {
        sSrcPartInfo = sPartInfoList->partitionInfo;
        sPartType    = sSrcPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

        /* PROJ-2464 hybrid partitioned table 
         *  - Partition Info  , Table Option Partitioned Table  Ѵ.
         *  - , PartInfo  ̿ ʰ, TBSID    ؼ ̿Ѵ.
         */
        qdbCommon::adjustPhysicalAttr( sPartType,
                                       sTableInfo->segAttr,
                                       sTableInfo->segStoAttr,
                                       & sSegAttr,
                                       & sSegStoAttr,
                                       ID_TRUE /* aIsTable */ );

        /* BUG-45503 Table  Ŀ  , Table Meta Cache Column   ʴ 찡 ֽϴ. */
        IDE_TEST( qcm::copyQcmColumns( QC_QMX_MEM( aStatement ),
                                       sSrcPartInfo->columns,
                                       & sTempColumns,
                                       sSrcPartInfo->columnCount )
                  != IDE_SUCCESS );

        //  ̺ Flag
        // ο ̺  Flag  ȴ.
        IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                            sTempColumns,
                                            sTableInfo->tableOwnerID,
                                            sTableInfo->tableID,
                                            sTableInfo->maxrows,
                                            sSrcPartInfo->TBSID,
                                            sSegAttr,
                                            sSegStoAttr,
                                            /*  Table Flag
                                               °  =>
                                               MASK Ʈ  1μ*/
                                            QDB_TABLE_ATTR_MASK_ALL,
                                            sTableInfo->tableFlag, /* Flag Value */
                                            sTableInfo->parallelDegree,
                                            &sNewPartitionOID[i])
                 != IDE_SUCCESS);

        // BUG-44814 ddl    縦 ؾ
        smiStatistics::copyTableStats( smiGetTable(sNewPartitionOID[i]), sSrcPartInfo->tableHandle, NULL, 0 );
        
        sPartitionID[i] = sSrcPartInfo->partitionID;

        IDE_TEST(qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                         sTableInfo->tableID,
                                                         sPartitionID[i],
                                                         sNewPartitionOID[i] )
                 != IDE_SUCCESS );
    }

    sPartMinVal[0] = '\0';
    sPartMaxVal[0] = '\0';
    sDstPartOrder = sDstPartCount - 1;

    // ---------------------------------------------
    // DstPart   Ÿ  Է
    // ---------------------------------------------
    IDE_TEST( qdbCommon::createTablePartition( aStatement,
                                               sParseTree,
                                               sTableInfo,
                                               sDstPartAttr,
                                               sPartMinVal,
                                               sPartMaxVal,
                                               sDstPartOrder,
                                               & sPartitionID[i],
                                               & sNewPartitionOID[i] )
              != IDE_SUCCESS );

    // ---------------------------------------------
    // non-partitioned index 
    // ---------------------------------------------
    
    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        IDE_DASSERT( sTableInfo->indexCount > 0 );
        
        IDE_TEST( aStatement->qmxMem->alloc(
                      ID_SIZEOF(qcmIndex) * sTableInfo->indexCount,
                      (void**)&sNewIndices)
                  != IDE_SUCCESS );

        idlOS::memcpy( sNewIndices,
                       sTableInfo->indices,
                       ID_SIZEOF(qcmIndex) * sTableInfo->indexCount );
        
        //---------------------------
        // drop old index tables
        //---------------------------
        
        // index table createIndex ٽ ǹǷ meta  ̸ .
        for ( sIndexTable = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            IDE_TEST( qdx::dropIndexTable( aStatement,
                                           sIndexTable,
                                           ID_FALSE /* aIsDropTablespace */ )
                      != IDE_SUCCESS );
        }
        
        //---------------------------
        // create new index tables
        //---------------------------
        
        IDE_TEST( qdx::createIndexTableOfTable(
                      aStatement,
                      sTableInfo,
                      sNewIndices,
                      sParseTree->oldIndexTables,
                      &(sParseTree->newIndexTables) )
                  != IDE_SUCCESS );
        
        //---------------------------
        // update meta table
        //---------------------------
        
        IDE_TEST( qdx::updateIndexTableSpecFromMeta(
                      aStatement,
                      sTableInfo,
                      sNewIndices )
                  != IDE_SUCCESS );
    }
    else
    {
        /* BUG-44469 [qx] codesonar warning in QX, MT, ST */
        IDE_TEST_RAISE( sParseTree->newIndexTables != NULL, ERR_UNEXPECTED );
    }

    /* PROJ-2464 hybrid partitioned table 
     *  - Hash  쿡,  Partition  ϱ ,  Memory, Disk ü  ȮѴ.
     *  - DstPartAttr ü ȮѴ.
     */
    qdbCommon::getTableTypeCountInPartInfoList( NULL,
                                                sSrcPartInfoList,
                                                NULL,
                                                & sCountMemType,
                                                & sCountVolType );

    qdbCommon::getTableTypeCountInPartAttrList( NULL,
                                                sDstPartAttr,
                                                NULL,
                                                & sTempMemType,
                                                & sTempVolType );

    sCountMemType += sTempMemType;
    sCountVolType += sTempVolType;

    // ---------------------------------------------
    // DISK PARTITIONED TABLE  籸
    // ---------------------------------------------
    /* PROJ-2464 hybrid partitioned table 
     *  - ü   ϵ Ѵ.
     *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
     *  - ,  ü  ϴ Partitioned  ü   Ų.
     */
    if ( ( sCountMemType + sCountVolType ) == 0 )
    {
        IDE_TEST( qdbCommon::reorganizeForHashPartition(
                      aStatement,
                      sTableInfo,
                      sSrcPartInfoList,
                      sDstPartCount,
                      sNewPartitionOID,
                      sNewIndices,
                      sParseTree->newIndexTables )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing To Do */
    }

    // ---------------------------------------------
    // ε 
    // ---------------------------------------------
    if( sTableInfo->indices != NULL )
    {
        for( i = 0, sPartInfoList = sSrcPartInfoList;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            sSrcPartInfo = sPartInfoList->partitionInfo;

            for( sIndexCount = 0;
                 sIndexCount < sSrcPartInfo->indexCount;
                 sIndexCount++ )
            {
                // ε   flag
                sFlag = smiTable::getIndexInfo( sSrcPartInfo->indices[sIndexCount].indexHandle );
                sSegAttr = smiTable::getIndexSegAttr(sSrcPartInfo->indices[sIndexCount].indexHandle);
                sSegStoAttr = smiTable::getIndexSegStoAttr(sSrcPartInfo->indices[sIndexCount].indexHandle);

                // ε   Ű ÷  Ѵ.
                IDE_TEST( qdx::getKeyColumnList(
                              aStatement,
                              & sSrcPartInfo->indices[sIndexCount],
                              & sColumnListAtKey )
                          != IDE_SUCCESS );

                /* PROJ-2464 hybrid partitioned table 
                 *  - ó : PROJ-2433
                 */
                IDE_TEST( smiTable::createIndex(
                              aStatement->mStatistics,
                              QC_SMI_STMT( aStatement ),
                              sSrcPartInfo->indices[sIndexCount].TBSID,
                              smiGetTable( sNewPartitionOID[i]),
                              (SChar*)sSrcPartInfo->indices[sIndexCount].name,
                              sSrcPartInfo->indices[sIndexCount].indexId,
                              sSrcPartInfo->indices[sIndexCount].indexTypeId,
                              sColumnListAtKey,
                              sFlag,
                              QD_INDEX_DEFAULT_PARALLEL_DEGREE,
                              SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                              sSegAttr,
                              sSegStoAttr,
                              0, /* BUG-42124 : direct key index partitioned table  ʴ´. */
                              & sIndexHandle )
                          != IDE_SUCCESS );

                // BUG-44814 ddl    縦 ؾ
                smiStatistics::copyIndexStats( sIndexHandle, sSrcPartInfo->indices[sIndexCount].indexHandle );
            }
        }

        /* PROJ-2464 hybrid partitioned table 
         *  1. Dst PartInfo .
         *  2. Dst PartInfo ´.
         *  3. Dst Part Index Ѵ.
         */
        /* 1. Dst PartInfo . */
        IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo( QC_SMI_STMT( aStatement ),
                                                            sPartitionID[i],
                                                            sNewPartitionOID[i],
                                                            sTableInfo,
                                                            NULL )
                  != IDE_SUCCESS );

        /* 2. Dst PartInfo ´. */
        IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                                  sTableInfo->tableID,
                                                  sDstPartAttr->tablePartName,
                                                  & sDstPartInfo,
                                                  & sDstPartSCN,
                                                  & sDstPartHandle )
                  != IDE_SUCCESS );

        /* 3. Dst Part Index Ѵ. */
        IDE_TEST( qdx::createAllIndexOfTablePart( aStatement,
                                                  sTableInfo,
                                                  sDstPartInfo,
                                                  sDstPartAttr->alterPart->indexPartAttr )
                  != IDE_SUCCESS );
    }

    // ---------------------------------------------
    // PROJ-2334 PMT
    // MEMORY PARTITIONED TABLE  籸
    // ---------------------------------------------
    /* PROJ-2464 hybrid partitioned table 
     *  - ü   ϵ Ѵ.
     *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
     *  - ,  ü  ϴ Partitioned  ü   Ų.
     */
    if ( ( sCountMemType + sCountVolType ) != 0 )
    {
        IDE_TEST( qdbCommon::reorganizeForHashPartition(
                      aStatement,
                      sTableInfo,
                      sSrcPartInfoList,
                      sDstPartCount,
                      sNewPartitionOID,
                      sNewIndices,
                      sParseTree->newIndexTables )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing To Do */
    }
    
    for( sPartInfoList = sSrcPartInfoList;
         sPartInfoList != NULL;
         sPartInfoList = sPartInfoList->next )
    {
        sSrcPartInfo = sPartInfoList->partitionInfo;
        IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                       sSrcPartInfo->tableHandle,
                                       SMI_TBSLV_DDL_DML )
                  != IDE_SUCCESS );
    }

    IDU_LIMITPOINT("qdbAlter::executeAddPartition::malloc3");
    IDE_TEST(aStatement->qmxMem->cralloc( ID_SIZEOF(qcmTableInfo*)
                                          * (sDstPartCount-1),
                                          (void**)&sNewPartInfoArr)
             != IDE_SUCCESS);

    // ---------------------------------------------
    // Ÿ ĳ 
    // ---------------------------------------------

    // non-partitioned index  tableInfo Ѵ.
    sTableOID = smiGetTableId(sTableInfo->tableHandle);
    
    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableInfo->tableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableInfo->tableID,
                 sTableOID)
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableInfo->tableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle)
             != IDE_SUCCESS);
    
    for( i = 0, sPartInfoList = sSrcPartInfoList;
         sPartInfoList != NULL;
         sPartInfoList = sPartInfoList->next, i++ )
    {
        IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                      QC_SMI_STMT( aStatement ),
                      sPartitionID[i],
                      sNewPartitionOID[i],
                      sTableInfo,
                      NULL )
                  != IDE_SUCCESS );

        IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i] ),
                                       (void**)&sNewPartInfoArr[i] )
                  != IDE_SUCCESS );
    }


    /* BUG-42399 [qx] [valgrind] QX valgrind warnings
     *  - Dst PartInfo Index ϸ鼭, Dst PartInfo  ʿϿ
     *     ش Partition ̸ makeAndSetQcmPartitionInfo Ͽ.
     *    , ۾    ̸  ĳø ϰ Ѵ.
     *  - ó : PROJ-2464 hybrid partitioned table 
     */
    if ( sDstPartInfo != NULL )
    {
        (void)qcmPartition::destroyQcmPartitionInfo( sDstPartInfo );

        sDstPartInfo = NULL;
    }
    else
    {
        /* Nothing to do */
    }
    
    //  ADDǴ Ƽ Ÿ ĳ 
    IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                  QC_SMI_STMT( aStatement ),
                  sPartitionID[i],
                  sNewPartitionOID[i],
                  sTableInfo,
                  NULL )
              != IDE_SUCCESS );

    IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i] ),
                                   (void**)&sDstPartInfo )
              != IDE_SUCCESS);

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sParseTree->tableInfo->tableID,
                 smiGetTableId(sParseTree->tableInfo->tableHandle),
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    (void)qcmPartition::destroyQcmPartitionInfoList( sSrcPartInfoList );

    for ( sIndexTable = sParseTree->oldIndexTables;
          sIndexTable != NULL;
          sIndexTable = sIndexTable->next )
    {
        (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
    }
    
    (void)qcm::destroyQcmTableInfo(sTableInfo);
    
    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_UNEXPECTED );
    IDE_SET( ideSetErrorCode( mtERR_ABORT_UNEXPECTED_ERROR,
                              "executeAddPartition",
                              "invalid newIndexTables" ) );
    IDE_EXCEPTION_END;

    if ( sNewPartInfoArr != NULL )
    {
        for( i = 0, sPartInfoList = sSrcPartInfoList;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfoArr[i] );
        }
    }

    for ( sIndexTable = sParseTree->newIndexTables;
          sIndexTable != NULL;
          sIndexTable = sIndexTable->next )
    {
        (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
    }
        
    // ߰ Ƽ Ÿ ĳ 
    if( sDstPartInfo != NULL )
    {
        (void)qcmPartition::destroyQcmPartitionInfo(sDstPartInfo);
    }

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    // on fail, must restore temp info.
    qcmPartition::restoreTempInfo( sTableInfo,
                                   sSrcPartInfoList,
                                   NULL );
    
    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeCoalescePartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *    ALTER TABLE table_name COALESCE PARTITION;  execution
 *
 *    PartOrder  ū Ƽ( Ƽ) ϰ ͸
 *    籸Ѵ.
 *
 *
 * Implementation :
 *    disk partitioned table, memory partitioned table .
 *    data 籸  ٸ.
 *    disk partitioned table data 籸  index rebuild.
 *    memory partitioned table index rebuild  data 籸.
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo = NULL;
    qcmPartitionInfoList    * sSrcPartInfoList = NULL;
    qcmPartitionInfoList    * sPartInfoList = NULL;
    qcmTableInfo            * sSrcPartInfo = NULL;
    qcmTableInfo           ** sNewPartInfoArr = NULL;

    UInt                    * sPartitionID;
    smOID                   * sNewPartitionOID = NULL;
    UInt                      i = 0;
    UInt                      sFlag = 0;
    const void              * sIndexHandle;
    UInt                      sIndexCount = 0;
    UInt                      sDstPartCount = 0;
    smiColumnList           * sColumnListAtKey;
    smiSegAttr                sSegAttr;
    smiSegStorageAttr         sSegStoAttr;
    qdIndexTableList        * sIndexTable;
    qcmIndex                * sNewIndices = NULL;

    qcmTableInfo            * sNewTableInfo = NULL;
    void                    * sTableHandle;
    smOID                     sTableOID;
    smSCN                     sSCN;

    SInt                      sCountMemType     = 0;
    SInt                      sCountVolType     = 0;
    UInt                      sPartType         = 0;

    qcmColumn               * sTempColumns = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDU_FIT_POINT( "qdbAlter::executeCoalescePartition::beforeXLock" );

    // Ƽǵ ̺ LOCK(X)
    IDE_TEST( qcm::validateAndLockTable(aStatement,
                                        sParseTree->tableHandle,
                                        sParseTree->tableSCN,
                                        SMI_TABLE_LOCK_X)
              != IDE_SUCCESS );

    //  Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                              sParseTree->partTable->partInfoList,
                                                              SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                              SMI_TABLE_LOCK_X,
                                                              smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
              != IDE_SUCCESS );

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDE_TEST( smiStatement::setViewSCNOfAllStmt( QC_SMI_STMT( aStatement ) )
              != IDE_SUCCESS );

    // PROJ-1624 non-partitioned index
    IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                  sParseTree->oldIndexTables,
                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                  SMI_TABLE_LOCK_X,
                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    sSrcPartInfoList = sParseTree->partTable->partInfoList;

    IDE_DASSERT( sSrcPartInfoList->next != NULL );

    for( sPartInfoList = sSrcPartInfoList, sDstPartCount = 0;
         sPartInfoList->next != NULL;
         sPartInfoList = sPartInfoList->next, sDstPartCount++ )
    {
        // Nothing to do.
    }

    IDU_LIMITPOINT("qdbAlter::executeCoalescePartition::malloc1");
    IDE_TEST(aStatement->qmxMem->cralloc(ID_SIZEOF(smOID) * sDstPartCount,
                                         (void**)&sNewPartitionOID)
             != IDE_SUCCESS);
    IDU_LIMITPOINT("qdbAlter::executeCoalescePartition::malloc2");
    IDE_TEST(aStatement->qmxMem->cralloc(ID_SIZEOF(UInt) * sDstPartCount,
                                         (void**)&sPartitionID)
             != IDE_SUCCESS);

    // ---------------------------------------------
    // OUT-PLACE ADD  ο Ƽ 
    // ---------------------------------------------
    for( i = 0, sPartInfoList = sSrcPartInfoList;
         sPartInfoList->next != NULL;
         sPartInfoList = sPartInfoList->next, i++ )
    {
        sSrcPartInfo = sPartInfoList->partitionInfo;
        sPartType    = sSrcPartInfo->tableFlag & SMI_TABLE_TYPE_MASK;

        /* PROJ-2464 hybrid partitioned table 
         *  - Partition Info  , Table Option Partitioned Table  Ѵ.
         *  - , PartInfo  ̿ ʰ, TBSID    ؼ ̿Ѵ.
         */
        qdbCommon::adjustPhysicalAttr( sPartType,
                                       sTableInfo->segAttr,
                                       sTableInfo->segStoAttr,
                                       & sSegAttr,
                                       & sSegStoAttr,
                                       ID_TRUE /* aIsTable */ );

        /* BUG-45503 Table  Ŀ  , Table Meta Cache Column   ʴ 찡 ֽϴ. */
        IDE_TEST( qcm::copyQcmColumns( QC_QMX_MEM( aStatement ),
                                       sSrcPartInfo->columns,
                                       & sTempColumns,
                                       sSrcPartInfo->columnCount )
                  != IDE_SUCCESS );

        //  ̺ Flag
        // ο ̺  Flag  ȴ.
        IDE_TEST(qdbCommon::createTableOnSM(aStatement,
                                            sTempColumns,
                                            sTableInfo->tableOwnerID,
                                            sTableInfo->tableID,
                                            sTableInfo->maxrows,
                                            sSrcPartInfo->TBSID,
                                            sSegAttr,
                                            sSegStoAttr,
                                            /*  Table Flag
                                               °  =>
                                               MASK Ʈ  1μ*/
                                            QDB_TABLE_ATTR_MASK_ALL,
                                            sTableInfo->tableFlag, /* Flag Value */
                                            sTableInfo->parallelDegree,
                                            &sNewPartitionOID[i])
                 != IDE_SUCCESS);

        // BUG-44814 ddl    縦 ؾ
        smiStatistics::copyTableStats( smiGetTable(sNewPartitionOID[i]), sSrcPartInfo->tableHandle, NULL, 0 );

        sPartitionID[i] = sSrcPartInfo->partitionID;

        IDE_TEST(qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                         sTableInfo->tableID,
                                                         sPartitionID[i],
                                                         sNewPartitionOID[i] )
                 != IDE_SUCCESS );
    }

    // ---------------------------------------------
    // non-partitioned index 
    // ---------------------------------------------
    
    // PROJ-1624 non-partitioned index
    if ( sParseTree->oldIndexTables != NULL )
    {
        IDE_DASSERT( sTableInfo->indexCount > 0 );
        
        IDE_TEST( aStatement->qmxMem->alloc(
                      ID_SIZEOF(qcmIndex) * sTableInfo->indexCount,
                      (void**)&sNewIndices)
                  != IDE_SUCCESS );

        idlOS::memcpy( sNewIndices,
                       sTableInfo->indices,
                       ID_SIZEOF(qcmIndex) * sTableInfo->indexCount );
        
        //---------------------------
        // drop old index tables
        //---------------------------
        
        // index table createIndex ٽ ǹǷ meta  ̸ .
        for ( sIndexTable = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable = sIndexTable->next )
        {
            IDE_TEST( qdx::dropIndexTable( aStatement,
                                           sIndexTable,
                                           ID_FALSE /* aIsDropTablespace */ )
                      != IDE_SUCCESS );
        }
        
        //---------------------------
        // create new index tables
        //---------------------------
        
        IDE_TEST( qdx::createIndexTableOfTable(
                      aStatement,
                      sTableInfo,
                      sNewIndices,
                      sParseTree->oldIndexTables,
                      &(sParseTree->newIndexTables) )
                  != IDE_SUCCESS );
        
        //---------------------------
        // update meta table
        //---------------------------
        
        IDE_TEST( qdx::updateIndexTableSpecFromMeta(
                      aStatement,
                      sTableInfo,
                      sNewIndices )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    /* PROJ-2464 hybrid partitioned table 
     *  - Hash  쿡,  Partition  ϱ ,  Memory, Disk ü  ȮѴ.
     */
    qdbCommon::getTableTypeCountInPartInfoList( NULL,
                                                sSrcPartInfoList,
                                                NULL,
                                                & sCountMemType,
                                                & sCountVolType );

    // ---------------------------------------------
    // DISK PARTITIONED TABLE  籸
    // ---------------------------------------------
    /* PROJ-2464 hybrid partitioned table 
     *  - ü   ϵ Ѵ.
     *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
     *  - ,  ü  ϴ Partitioned  ü   Ų.
     */
    if ( ( sCountMemType + sCountVolType ) == 0 )
    {
        IDE_TEST( qdbCommon::reorganizeForHashPartition(
                      aStatement,
                      sTableInfo,
                      sSrcPartInfoList,
                      sDstPartCount,
                      sNewPartitionOID,
                      sNewIndices,
                      sParseTree->newIndexTables )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing To Do */
    }

    // ---------------------------------------------
    // ε 
    // ---------------------------------------------
    if( sTableInfo->indices != NULL )
    {
        for( i = 0, sPartInfoList = sSrcPartInfoList;
             sPartInfoList->next != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            sSrcPartInfo = sPartInfoList->partitionInfo;

            for( sIndexCount = 0;
                 sIndexCount < sSrcPartInfo->indexCount;
                 sIndexCount++ )
            {
                // ε   flag
                sFlag = smiTable::getIndexInfo( sSrcPartInfo->indices[sIndexCount].indexHandle );
                sSegAttr = smiTable::getIndexSegAttr(sSrcPartInfo->indices[sIndexCount].indexHandle);
                sSegStoAttr = smiTable::getIndexSegStoAttr(sSrcPartInfo->indices[sIndexCount].indexHandle);

                // ε   Ű ÷  Ѵ.
                IDE_TEST( qdx::getKeyColumnList(
                              aStatement,
                              & sSrcPartInfo->indices[sIndexCount],
                              & sColumnListAtKey )
                          != IDE_SUCCESS );

                /* PROJ-2464 hybrid partitioned table 
                 *  - ó : PROJ-2433
                 */
                IDE_TEST( smiTable::createIndex(
                              aStatement->mStatistics,
                              QC_SMI_STMT( aStatement ),
                              sSrcPartInfo->indices[sIndexCount].TBSID,
                              smiGetTable( sNewPartitionOID[i]),
                              (SChar*)sSrcPartInfo->indices[sIndexCount].name,
                              sSrcPartInfo->indices[sIndexCount].indexId,
                              sSrcPartInfo->indices[sIndexCount].indexTypeId,
                              sColumnListAtKey,
                              sFlag,
                              QD_INDEX_DEFAULT_PARALLEL_DEGREE,
                              SMI_INDEX_BUILD_UNCOMMITTED_ROW_ENABLE,
                              sSegAttr,
                              sSegStoAttr,
                              0, /* BUG-42124 : direct key index partitioned table  ʴ´. */
                              & sIndexHandle )
                          != IDE_SUCCESS );
                
                // BUG-44814 ddl    縦 ؾ
                smiStatistics::copyIndexStats( sIndexHandle, sSrcPartInfo->indices[sIndexCount].indexHandle );
            }
        }
    }

    // ---------------------------------------------
    // PROJ-2334 PMT
    // MEMORY PARTITIONED TABLE  籸
    // ---------------------------------------------
    /* PROJ-2464 hybrid partitioned table 
     *  - ü   ϵ Ѵ.
     *  - Index ߿ ؾ߸ ϴ ü ϱ , ü  moveRowϴ  ٸ.
     *  - ,  ü  ϴ Partitioned  ü   Ų.
     */
    if ( ( sCountMemType + sCountVolType ) != 0 )
    {
        IDE_TEST( qdbCommon::reorganizeForHashPartition(
                      aStatement,
                      sTableInfo,
                      sSrcPartInfoList,
                      sDstPartCount,
                      sNewPartitionOID,
                      sNewIndices,
                      sParseTree->newIndexTables )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing To Do */
    }
    for( sPartInfoList = sSrcPartInfoList;
         sPartInfoList->next != NULL;
         sPartInfoList = sPartInfoList->next )
    {
        sSrcPartInfo = sPartInfoList->partitionInfo;
        IDE_TEST( smiTable::dropTable( QC_SMI_STMT( aStatement ),
                                       sSrcPartInfo->tableHandle,
                                       SMI_TBSLV_DDL_DML )
                  != IDE_SUCCESS );
    }

    // ------------------------------------------------
    // Ÿ ̺ ش Ƽǿ õ  
    // Ƽ 
    // ------------------------------------------------
    sSrcPartInfo = sPartInfoList->partitionInfo;
    IDE_TEST(qdd::dropTablePartition( aStatement,
                                      sSrcPartInfo,
                                      ID_FALSE, /* aIsDropTablespace */
                                      ID_FALSE )
             != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::executeCoalescePartition::malloc3");
    IDE_TEST(aStatement->qmxMem->cralloc( ID_SIZEOF(qcmTableInfo*)
                                          * (sDstPartCount+1),
                                          (void**)&sNewPartInfoArr)
             != IDE_SUCCESS);

    // ---------------------------------------------
    // Ÿ ĳ (DstPart)
    // ---------------------------------------------
    
    // non-partitioned index  tableInfo Ѵ.
    sTableOID = smiGetTableId(sTableInfo->tableHandle);
    
    IDE_TEST(qcm::touchTable(QC_SMI_STMT( aStatement ),
                             sTableInfo->tableID,
                             SMI_TBSLV_DDL_DML )
             != IDE_SUCCESS);

    IDE_TEST(qcm::makeAndSetQcmTableInfo(
                 QC_SMI_STMT( aStatement ),
                 sTableInfo->tableID,
                 sTableOID)
             != IDE_SUCCESS);

    IDE_TEST(qcm::getTableInfoByID(aStatement,
                                   sTableInfo->tableID,
                                   &sNewTableInfo,
                                   &sSCN,
                                   &sTableHandle)
             != IDE_SUCCESS);
    
    for( i = 0, sPartInfoList = sSrcPartInfoList;
         sPartInfoList->next != NULL;
         sPartInfoList = sPartInfoList->next, i++ )
    {
        IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                      QC_SMI_STMT( aStatement ),
                      sPartitionID[i],
                      sNewPartitionOID[i],
                      sTableInfo,
                      NULL )
                  != IDE_SUCCESS );

        IDE_TEST( smiGetTableTempInfo( smiGetTable( sNewPartitionOID[i] ),
                                       (void**)&sNewPartInfoArr[i] )
                  != IDE_SUCCESS );
    }

    // fix BUG-14394
    IDE_TEST(qdbCommon::updateTableSpecFromMeta(
                 aStatement,
                 sParseTree->userName,
                 sParseTree->tableName,
                 sParseTree->tableInfo->tableID,
                 smiGetTableId(sParseTree->tableInfo->tableHandle),
                 sParseTree->tableInfo->columnCount,
                 sParseTree->tableInfo->parallelDegree )
             != IDE_SUCCESS);

    IDE_TEST(qcmView::setInvalidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE) != IDE_SUCCESS);

    IDE_TEST(qcmView::recompileAndSetValidViewOfRelated(
                 aStatement,
                 sParseTree->userID,
                 sTableInfo->name,
                 idlOS::strlen((SChar*)sTableInfo->name),
                 QS_TABLE)
             != IDE_SUCCESS);

    // ---------------------------------------------
    // Ÿ ĳ 
    // ---------------------------------------------
    (void)qcmPartition::destroyQcmPartitionInfoList( sSrcPartInfoList );

    for ( sIndexTable = sParseTree->oldIndexTables;
          sIndexTable != NULL;
          sIndexTable = sIndexTable->next )
    {
        (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
    }
    
    (void)qcm::destroyQcmTableInfo(sTableInfo);
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    // Ÿ ĳ   
    if ( sNewPartInfoArr != NULL )
    {
        for( i = 0, sPartInfoList = sSrcPartInfoList;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next, i++ )
        {
            (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfoArr[i] );
        }
    }

    for ( sIndexTable = sParseTree->newIndexTables;
          sIndexTable != NULL;
          sIndexTable = sIndexTable->next )
    {
        (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
    }
    
    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    // on fail, must restore temp info.
    qcmPartition::restoreTempInfo( sTableInfo,
                                   sSrcPartInfoList,
                                   NULL );
    
    return IDE_FAILURE;
}

IDE_RC qdbAlter::makeNewRow(qcTemplate        * aTemplate,
                            qcmTableInfo      * aTableInfo,
                            qcmColumn         * aSrcTblColumn,
                            qcmColumn         * aDstTblColumn,
                            const void        * aOldRow,
                            smiValue          * aNewRow,
                            smiTableCursor    * aSrcTblCursor,
                            scGRID              aRowGRID,
                            qmxLobInfo        * aLobInfo,
                            qdbConvertContext * aConvertContextList)
{
/***********************************************************************
 *
 *  Լ ũ ̺ ؼ ȣ.
 *
 **********************************************************************/

    SInt                sColumnOrder;
    qcmColumn         * sDestCol;
    qcmColumn         * sSrcCol;
    mtvConvert        * sConvert;
    mtcColumn         * sValueColumn;
    void              * sValue;
    void              * sCanonizedValue;
    smLobLocator        sLocator = MTD_LOCATOR_NULL;
    UInt                sInfo = 0;
    qdbConvertContext * sConvertContext;
    UInt                sStoringSize = 0;
    void              * sStoringValue;

    sConvertContext = aConvertContextList;
    sDestCol = aDstTblColumn;
    sInfo = MTC_LOB_LOCATOR_CLOSE_TRUE;

    while (sDestCol != NULL)
    {
        sColumnOrder = (sDestCol->basicInfo->column.id & SMI_COLUMN_ID_MASK);
        sSrcCol = aSrcTblColumn;
        while (sSrcCol != NULL)
        {
            if ( idlOS::strMatch( sSrcCol->name,
                                  idlOS::strlen( sSrcCol->name ),
                                  sDestCol->name,
                                  idlOS::strlen( sDestCol->name ) ) == 0 )
            {
                break;
            }
            else
            {
                sSrcCol = sSrcCol->next;
            }
        }

        if (sSrcCol != NULL)
        {
            if ((sSrcCol->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                == SMI_COLUMN_TYPE_LOB)
            {
                // PROJ-1362

                // SrcCol DestCol  type̴.
                IDE_DASSERT( sSrcCol->basicInfo->type.dataTypeId
                             == sDestCol->basicInfo->type.dataTypeId );
                
                if( SMI_GRID_IS_VIRTUAL_NULL(aRowGRID) )
                {
                    // GRID virtual null .
                    // Nothing to do.
                }
                else
                {
                    if ( smiIsNullLobColumn(aOldRow, &sSrcCol->basicInfo->column)
                         == ID_TRUE )
                    {
                        // Nothing to do.
                    }
                    else
                    {
                        /* PROJ-2334 PMT */
                        if ( (sSrcCol->basicInfo->column.flag & SMI_COLUMN_STORAGE_MASK)
                             == SMI_COLUMN_STORAGE_MEMORY )
                        {
                            IDE_TEST( smiLob::openLobCursorWithRow(
                                          aSrcTblCursor,
                                          (void*)aOldRow,
                                          & sSrcCol->basicInfo->column,
                                          sInfo,
                                          SMI_LOB_READ_MODE,
                                          & sLocator )
                                      != IDE_SUCCESS );
                        }
                        else
                        {
                            // null ƴ ͸
                            //fix BUG-19687
                            IDE_TEST( smiLob::openLobCursorWithGRID(
                                          aSrcTblCursor,
                                          aRowGRID,
                                          & sSrcCol->basicInfo->column,
                                          sInfo,
                                          SMI_LOB_READ_MODE,
                                          & sLocator )
                                      != IDE_SUCCESS );
                        }
                        
                        IDE_TEST( qmx::addLobInfoForCopy(
                                      aLobInfo,
                                      & sDestCol->basicInfo->column,
                                      sLocator)
                                  != IDE_SUCCESS );

                        sLocator = MTD_LOCATOR_NULL;
                    }
                }

                // null Ѵ.
                aNewRow[sColumnOrder].value = NULL;
                aNewRow[sColumnOrder].length = 0;
            }
            else
            {
                sValueColumn = sSrcCol->basicInfo;
                sValue       = (void*) mtc::value( sSrcCol->basicInfo,
                                                   aOldRow,
                                                   MTD_OFFSET_USE );

                if ( aConvertContextList != NULL )
                {
                    //-------------------------------------------------
                    // type ȯ ʿ  (conversion ʿ )
                    //
                    // a. modify decrypt 
                    // b. modify encrypt 
                    // c. data type ȯ
                    // d. length ȯ
                    //-------------------------------------------------

                    while ( 1 )
                    {
                        //-----------------------------------------
                        // a. modify decrypt (echar->char, evarchar->varchar)
                        //-----------------------------------------

                        if ( sConvertContext->needDecrypt == ID_TRUE )
                        {
                            //-------------------------------
                            // 1. decrypt
                            //-------------------------------

                            IDE_DASSERT( sConvertContext->encBuf != NULL );

                            sColumnOrder = sValueColumn->column.id & SMI_COLUMN_ID_MASK;

                            IDE_TEST( qcsModule::decryptColumn(
                                          aTemplate->stmt,
                                          aTableInfo,
                                          sColumnOrder,
                                          sValueColumn,
                                          sValue,
                                          sDestCol->basicInfo,
                                          sConvertContext->encBuf )
                                      != IDE_SUCCESS );

                            sValueColumn = sDestCol->basicInfo;
                            sValue       = sConvertContext->encBuf;

                            //-------------------------------
                            // 2. assign
                            //-------------------------------

                            // PROJ-1877
                            // alter table modify colum  type̳ length 
                            // null ƴ value null Ǵ 찡 ־ ȵȴ.
                            //  ̷ 찡 ִٸ not null constraint ִ ÷
                            // Ͽ type̳ length  value null ȴٸ ̸
                            // ˻Ͽ óؾ Ѵ.
                            //   ̷ 찡 . default_date_format
                            // ̿ϴ varchar->date 쵵 default_date_format ''
                            //      ߻ ʴ´.

                            // PROJ-1705
                            IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                          sDestCol->basicInfo,
                                          sValueColumn,
                                          (void*)sValue,
                                          &sStoringValue )
                                      !=IDE_SUCCESS );
                            aNewRow[sColumnOrder].value = sStoringValue;

                            IDE_TEST( qdbCommon::storingSize(
                                          sDestCol->basicInfo,
                                          sValueColumn,
                                          (void*)sValue,
                                          &sStoringSize )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].length = sStoringSize;

                            break;
                        }
                        else
                        {
                            // Nothing to do.
                        }

                        //-----------------------------------------
                        // b. modify encrypt (char->echar, varchar->evarchar)
                        //-----------------------------------------

                        if ( sConvertContext->needEncrypt == ID_TRUE )
                        {
                            //-------------------------------
                            // 1. encrypt
                            //-------------------------------

                            IDE_DASSERT( sConvertContext->encBuf != NULL );

                            sColumnOrder = sValueColumn->column.id & SMI_COLUMN_ID_MASK;

                            IDE_TEST( qcsModule::encryptColumn(
                                          aTemplate->stmt,
                                          aTableInfo,
                                          sColumnOrder,
                                          sValueColumn,
                                          sValue,
                                          sDestCol->basicInfo,
                                          sConvertContext->encBuf )
                                      != IDE_SUCCESS );

                            sValueColumn = sDestCol->basicInfo;
                            sValue       = sConvertContext->encBuf;

                            //-------------------------------
                            // 2. assign
                            //-------------------------------

                            // PROJ-1877
                            // alter table modify colum  type̳ length 
                            // null ƴ value null Ǵ 찡 ־ ȵȴ.
                            //  ̷ 찡 ִٸ not null constraint ִ ÷
                            // Ͽ type̳ length  value null ȴٸ ̸
                            // ˻Ͽ óؾ Ѵ.
                            //   ̷ 찡 . default_date_format
                            // ̿ϴ varchar->date 쵵 default_date_format ''
                            //      ߻ ʴ´.

                            // PROJ-1705
                            IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                          sDestCol->basicInfo,
                                          sValueColumn,
                                          (void*)sValue,
                                          &sStoringValue )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].value = sStoringValue;

                            IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                              sValueColumn,
                                                              (void*)sValue,
                                                              &sStoringSize )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].length = sStoringSize;

                            break;
                        }
                        else
                        {
                            // Nothing to do.
                        }

                        //-----------------------------------------
                        // c. data type ȯ
                        //-----------------------------------------

                        if ( (sConvertContext->needConvert == ID_TRUE) &&
                             (sConvertContext->needCanonize == ID_TRUE) )
                        {
                            //-------------------------------
                            // 1. conversion
                            //-------------------------------

                            IDE_DASSERT( sConvertContext->convert != NULL );

                            sConvert = sConvertContext->convert;

                            // source value pointer
                            sConvert->stack[sConvert->count].value = sValue;

                            // destination value pointer
                            sValueColumn = sConvert->stack[0].column;
                            sValue       = sConvert->stack[0].value;

                            IDE_TEST( mtv::executeConvert( sConvert,
                                                           & aTemplate->tmplate )
                                      != IDE_SUCCESS );

                            //-------------------------------
                            // 2. canonize (without echar, evarchar)
                            //-------------------------------

                            if ( ( sDestCol->basicInfo->module->flag & MTD_CANON_MASK )
                                 == MTD_CANON_NEED )
                            {
                                sCanonizedValue = sValue;

                                IDE_TEST( sDestCol->basicInfo->module->canonize(
                                              sDestCol->basicInfo,
                                              & sCanonizedValue,  // canonized value
                                              NULL,
                                              sValueColumn,
                                              sValue,            // original value
                                              NULL,
                                              & aTemplate->tmplate )
                                          != IDE_SUCCESS );

                                sValue = sCanonizedValue;
                            }
                            else if ( (sDestCol->basicInfo->module->flag & MTD_CANON_MASK)
                                      == MTD_CANON_NEED_WITH_ALLOCATION )
                            {
                                IDE_DASSERT( sConvertContext->canonBuf != NULL );

                                sCanonizedValue = sConvertContext->canonBuf;

                                IDE_TEST( sDestCol->basicInfo->module->canonize(
                                              sDestCol->basicInfo,
                                              & sCanonizedValue,  // canonized value
                                              NULL,
                                              sValueColumn,
                                              sValue,            // original value
                                              NULL,
                                              & aTemplate->tmplate )
                                          != IDE_SUCCESS );

                                sValue = sCanonizedValue;
                            }
                            else
                            {
                                // Nothing to do.
                            }

                            //-------------------------------
                            // 3. assign
                            //-------------------------------

                            // PROJ-1877
                            // alter table modify colum  type̳ length 
                            // null ƴ value null Ǵ 찡 ־ ȵȴ.
                            //  ̷ 찡 ִٸ not null constraint ִ ÷
                            // Ͽ type̳ length  value null ȴٸ ̸
                            // ˻Ͽ óؾ Ѵ.
                            //   ̷ 찡 . default_date_format
                            // ̿ϴ varchar->date 쵵 default_date_format ''
                            //      ߻ ʴ´.

                            // PROJ-1705
                            IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                          sDestCol->basicInfo,
                                          sValueColumn,
                                          (void*)sValue,
                                          &sStoringValue )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].value = sStoringValue;

                            IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                              sValueColumn,
                                                              (void*)sValue,
                                                              &sStoringSize )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].length = sStoringSize;

                            break;
                        }

                        //-------------------------------------------------
                        // d. length ȯ ʿ  (canonize ʿ )
                        //-------------------------------------------------

                        if ( (sConvertContext->needConvert == ID_FALSE) &&
                             (sConvertContext->needCanonize == ID_TRUE) )
                        {
                            //-------------------------------
                            // 1. canonize
                            //-------------------------------

                            if ( ( sDestCol->basicInfo->module->flag & MTD_CANON_MASK )
                                 == MTD_CANON_NEED )
                            {
                                sCanonizedValue = sValue;

                                IDE_TEST( sDestCol->basicInfo->module->canonize(
                                              sDestCol->basicInfo,
                                              & sCanonizedValue,  // canonized value
                                              NULL,
                                              sValueColumn,
                                              sValue,            // original value
                                              NULL,
                                              & aTemplate->tmplate )
                                          != IDE_SUCCESS );

                                sValue = sCanonizedValue;
                            }
                            else if ( (sDestCol->basicInfo->module->flag & MTD_CANON_MASK)
                                      == MTD_CANON_NEED_WITH_ALLOCATION )
                            {
                                IDE_DASSERT( sConvertContext->canonBuf != NULL );

                                sCanonizedValue = sConvertContext->canonBuf;

                                IDE_TEST( sDestCol->basicInfo->module->canonize(
                                              sDestCol->basicInfo,
                                              & sCanonizedValue,  // canonized value
                                              NULL,
                                              sValueColumn,
                                              sValue,            // original value
                                              NULL,
                                              & aTemplate->tmplate )
                                          != IDE_SUCCESS );

                                sValue = sCanonizedValue;
                            }
                            else
                            {
                                // Nothing to do.
                            }

                            //-------------------------------
                            // 2. assign
                            //-------------------------------

                            // PROJ-1877
                            // alter table modify colum  type̳ length 
                            // null ƴ value null Ǵ 찡 ־ ȵȴ.
                            //  ̷ 찡 ִٸ not null constraint ִ ÷
                            // Ͽ type̳ length  value null ȴٸ ̸
                            // ˻Ͽ óؾ Ѵ.
                            //   ̷ 찡 . default_date_format
                            // ̿ϴ varchar->date 쵵 default_date_format ''
                            //      ߻ ʴ´.

                            // PROJ-1705
                            IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                          sDestCol->basicInfo,
                                          sValueColumn,
                                          (void*)sValue,
                                          &sStoringValue )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].value = sStoringValue;

                            IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                              sValueColumn,
                                                              (void*)sValue,
                                                              &sStoringSize )
                                      != IDE_SUCCESS );
                            aNewRow[sColumnOrder].length = sStoringSize;

                            break;
                        }
                        else
                        {
                            // Nothing to do.
                        }

                        //-------------------------------------------------
                        // ״ ϴ 
                        //-------------------------------------------------

                        //-------------------------------
                        // 1. assign
                        //-------------------------------

                        // PROJ-1877
                        // alter table modify colum  type̳ length 
                        // null ƴ value null Ǵ 찡 ־ ȵȴ.
                        //  ̷ 찡 ִٸ not null constraint ִ ÷
                        // Ͽ type̳ length  value null ȴٸ ̸
                        // ˻Ͽ óؾ Ѵ.
                        //   ̷ 찡 . default_date_format
                        // ̿ϴ varchar->date 쵵 default_date_format ''
                        //      ߻ ʴ´.

                        // PROJ-1705
                        IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                      sDestCol->basicInfo,
                                      sValueColumn,
                                      (void*)sValue,
                                      &sStoringValue )
                                  != IDE_SUCCESS );
                        aNewRow[sColumnOrder].value = sStoringValue;

                        IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                          sValueColumn,
                                                          (void*)sValue,
                                                          &sStoringSize )
                                  != IDE_SUCCESS );
                        aNewRow[sColumnOrder].length = sStoringSize;

                        break;
                    }
                }
                else /* aConvertContextList == NULL */
                {
                    //-------------------------------------------------
                    // ״ ϴ 
                    //-------------------------------------------------

                    //-------------------------------
                    // 1. assign
                    //-------------------------------

                    // PROJ-1877
                    // alter table modify colum  type̳ length 
                    // null ƴ value null Ǵ 찡 ־ ȵȴ.
                    //  ̷ 찡 ִٸ not null constraint ִ ÷
                    // Ͽ type̳ length  value null ȴٸ ̸
                    // ˻Ͽ óؾ Ѵ.
                    //   ̷ 찡 . default_date_format
                    // ̿ϴ varchar->date 쵵 default_date_format ''
                    //      ߻ ʴ´.

                    // PROJ-1705
                    IDE_TEST( qdbCommon::mtdValue2StoringValue(
                                  sDestCol->basicInfo,
                                  sValueColumn,
                                  (void*)sValue,
                                  &sStoringValue )
                              != IDE_SUCCESS );
                    aNewRow[sColumnOrder].value = sStoringValue;

                    IDE_TEST( qdbCommon::storingSize( sDestCol->basicInfo,
                                                      sValueColumn,
                                                      (void*)sValue,
                                                      &sStoringSize )
                              != IDE_SUCCESS );
                    aNewRow[sColumnOrder].length = sStoringSize;
                }

                /* PROJ-2465 Tablespace Alteration for Table
                 *  ⿡ Dictionary Table OID ״ Ѵ.
                 *  Ŀ, qcmDictionary::rebuildDictionaryTable() Dictionary Table Value ߰ϰ,
                 *  Data Table ִ OID Ѵ.
                 */
                if ( (sDestCol->basicInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
                     == SMI_COLUMN_COMPRESSION_TRUE )
                {
                    IDE_DASSERT( sDestCol->basicInfo->column.mDictionaryTableOID != SM_NULL_OID );

                    sValue = (void*)( (UChar*) aOldRow + sSrcCol->basicInfo->column.offset );

                    // smiValue  dictionary table  OID  Ű Ѵ.
                    // OID  canonize ʿ.
                    // OID  memory table ̹Ƿ mtd value  storing value  ϴ.
                    aNewRow[sColumnOrder].value  = sValue;
                    aNewRow[sColumnOrder].length = ID_SIZEOF(smOID);
                }
                else
                {
                    // Nothing to do.
                }
            }

            if ( aConvertContextList != NULL )
            {
                IDE_DASSERT( sConvertContext != NULL );

                sConvertContext = sConvertContext->next;
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // Nothing to do.
        }

        sDestCol = sDestCol->next;
    }
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void) qmx::closeLobLocator( QC_STATISTICS(aTemplate->stmt), sLocator );

    return IDE_FAILURE;
}

// PR-13725
IDE_RC qdbAlter::checkOperatable( qcStatement  * aStatement,
                                  qcmTableInfo * aTableInfo )
{
/***********************************************************************
 *
 * Description :
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::checkOperatable"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(IDE_FN));

    qdTableParseTree    * sParseTree;
    qcuSqlSourceInfo      sqlInfo;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // PR-13725
    // CHECK OPERATABLE
    if( QCM_IS_OPERATABLE_QP_ALTER_TABLE( aTableInfo->operatableFlag )
        != ID_TRUE )
    {
        sqlInfo.setSourceInfo( aStatement,
                               & sParseTree->tableName );
        IDE_RAISE(ERR_NOT_EXIST_TABLE);
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_NOT_EXIST_TABLE);
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(
            ideSetErrorCode(qpERR_ABORT_QCV_NOT_EXISTS_TABLE,
                            sqlInfo.getErrMessage() ));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::updateLobStorageAttr( qcStatement       * aStatement,
                                       qdLobAttribute    * aLobAttr,
                                       smiColumnList     * aColumnList,
                                       qcmColumn         * aColumn,
                                       SChar             * aSqlStr,
                                       UInt                aPartID,
                                       UInt              * aUpdateCount )
{
#define IDE_FN "qdbAlter::updateLobStorageAttr"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY(IDE_FN));

    qdLobStorageAttribute * sLobStorageAttr;
    mtcColumn             * sMtcColumn;
    UInt                    sColOrder;
    vSLong                  sRowCnt;
    SChar                 * sTrueFalse[2] = {(SChar*)"T", (SChar*)"F"};
    SChar                 * sLogging;
    SChar                 * sBuffer;
    idBool                  sUpdateFlag;

    for (sLobStorageAttr = aLobAttr->storageAttr;
         sLobStorageAttr != NULL;
         sLobStorageAttr = sLobStorageAttr->next)
    {
        if (sLobStorageAttr->type == QD_LOB_STORAGE_ATTR_LOGGING)
        {
            // make logging column
            sColOrder = aColumn->basicInfo->column.id & SMI_COLUMN_ID_MASK;
            sMtcColumn = (mtcColumn*)(aColumnList[sColOrder].column);
            sUpdateFlag = ID_FALSE;

            if(sLobStorageAttr->logging == ID_TRUE)
            {
                sMtcColumn->column.flag &= ~SMI_COLUMN_LOGGING_MASK;
                sMtcColumn->column.flag |= SMI_COLUMN_LOGGING;
                sLogging = sTrueFalse[0];
                sUpdateFlag = ID_TRUE;
                (*aUpdateCount)++;
            }
            else if(sLobStorageAttr->logging == ID_FALSE)
            {
                sMtcColumn->column.flag &= ~SMI_COLUMN_LOGGING_MASK;
                sMtcColumn->column.flag |= SMI_COLUMN_NOLOGGING;
                sLogging = sTrueFalse[1];
                sUpdateFlag = ID_TRUE;
                (*aUpdateCount)++;
            }
            else
            {
                // Nothing to do.
            }

            if (sUpdateFlag == ID_TRUE)
            {
                if( aPartID == 0 )
                {
                    // update meta table
                    idlOS::snprintf(aSqlStr, QD_MAX_SQL_LENGTH,
                                    "UPDATE SYS_LOBS_ SET "
                                    "LOGGING = '%s'  "
                                    "WHERE COLUMN_ID = %"ID_INT32_FMT"",
                                    sLogging,
                                    aColumn->basicInfo->column.id );
                }
                else
                {
                    // update meta table
                    idlOS::snprintf(aSqlStr, QD_MAX_SQL_LENGTH,
                                    "UPDATE SYS_PART_LOBS_ SET "
                                    "LOGGING = '%s'  "
                                    "WHERE COLUMN_ID = %"ID_INT32_FMT""
                                    " AND PARTITION_ID = %"ID_INT32_FMT"",
                                    sLogging,
                                    aColumn->basicInfo->column.id,
                                    aPartID );
                }

                IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT(aStatement),
                                           aSqlStr,
                                           & sRowCnt )
                         != IDE_SUCCESS);

                IDE_TEST_RAISE(sRowCnt != 1, ERR_META_CRASH);
            }
            else
            {
                // Nothing to do.
            }
        }
        else if (sLobStorageAttr->type == QD_LOB_STORAGE_ATTR_BUFFER)
        {
            // make buffer column
            sColOrder = aColumn->basicInfo->column.id & SMI_COLUMN_ID_MASK;
            sMtcColumn = (mtcColumn*)(aColumnList[sColOrder].column);
            sUpdateFlag = ID_FALSE;

            if(sLobStorageAttr->buffer == ID_TRUE)
            {
                sMtcColumn->column.flag &= ~SMI_COLUMN_USE_BUFFER_MASK;
                sMtcColumn->column.flag |= SMI_COLUMN_USE_BUFFER;
                sBuffer = sTrueFalse[0];
                sUpdateFlag = ID_TRUE;
                (*aUpdateCount)++;
            }
            else if(sLobStorageAttr->buffer == ID_FALSE)
            {
                sMtcColumn->column.flag &= ~SMI_COLUMN_USE_BUFFER_MASK;
                sMtcColumn->column.flag |= SMI_COLUMN_USE_NOBUFFER;
                sBuffer = sTrueFalse[1];
                sUpdateFlag = ID_TRUE;
                (*aUpdateCount)++;
            }
            else
            {
                // Nothing to do.
            }

            if (sUpdateFlag == ID_TRUE)
            {
                if( aPartID == 0 )
                {
                    // update meta table
                    idlOS::snprintf(aSqlStr, QD_MAX_SQL_LENGTH,
                                    "UPDATE SYS_LOBS_ SET "
                                    "BUFFER = '%s'  "
                                    "WHERE COLUMN_ID = %"ID_INT32_FMT"",
                                    sBuffer,
                                    aColumn->basicInfo->column.id );
                }
                else
                {
                    // update meta table
                    idlOS::snprintf(aSqlStr, QD_MAX_SQL_LENGTH,
                                    "UPDATE SYS_PART_LOBS_ SET "
                                    "BUFFER = '%s'  "
                                    "WHERE COLUMN_ID = %"ID_INT32_FMT""
                                    " AND PARTITION_ID = %"ID_INT32_FMT"",
                                    sBuffer,
                                    aColumn->basicInfo->column.id,
                                    aPartID );
                }

                IDE_TEST(qcg::runDMLforDDL(QC_SMI_STMT(aStatement),
                                           aSqlStr,
                                           & sRowCnt )
                         != IDE_SUCCESS);

                IDE_TEST_RAISE(sRowCnt != 1, ERR_META_CRASH);
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // Nothing to do.
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::checkAdjPartition(
    qcStatement      * aStatement,
    qcmTableInfo     * aTableInfo )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-1502 PARTITIONED DISK TABLE
 *
 *     Ƽǵ ̺ MERGE 
 *    ΰ Ƽ  ִ Ƽ üũѴ.
 *
 *
 * Implementation :
 *
 ***********************************************************************/

    qmsPartCondValList   * sPartCondMinVal;
    qmsPartCondValList   * sPartCondMaxVal;
    mtdCharType          * sPartKeyCondMinValueStr;
    mtdCharType          * sPartKeyCondMaxValueStr;

    qmsPartCondValList   * sPartCondMinVal2;
    qmsPartCondValList   * sPartCondMaxVal2;
    mtdCharType          * sPartKeyCondMinValueStr2;
    mtdCharType          * sPartKeyCondMaxValueStr2;

    qdTableParseTree     * sParseTree;
    idBool                 sIsLeftPartIsLess = ID_FALSE;
    qdPartitionAttribute * sSrcPartAttr1;
    qdPartitionAttribute * sSrcPartAttr2;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    sSrcPartAttr1 = sParseTree->partTable->partAttr;
    sSrcPartAttr2 = sParseTree->partTable->partAttr->next;

    // ĽƮ ´.
    sPartCondMinVal         = sSrcPartAttr1->alterPart->partCondMinVal;
    sPartCondMaxVal         = sSrcPartAttr1->alterPart->partCondMaxVal;
    sPartKeyCondMinValueStr = sSrcPartAttr1->alterPart->partKeyCondMinValStr;
    sPartKeyCondMaxValueStr = sSrcPartAttr1->alterPart->partKeyCondMaxValStr;

    sPartCondMinVal2         = sSrcPartAttr2->alterPart->partCondMinVal;
    sPartCondMaxVal2         = sSrcPartAttr2->alterPart->partCondMaxVal;
    sPartKeyCondMinValueStr2 = sSrcPartAttr2->alterPart->partKeyCondMinValStr;
    sPartKeyCondMaxValueStr2 = sSrcPartAttr2->alterPart->partKeyCondMaxValStr;

    // ---------------------------------------------------
    // SrcPart1 max value SrcPart2 min value ų
    // SrcPart2 max value SrcPart1 max value 
    //   Ƽ̴.
    // ---------------------------------------------------
    if( (sPartKeyCondMinValueStr->length == 0) ||
        (sPartKeyCondMaxValueStr2->length == 0) )
    {
        sIsLeftPartIsLess = ID_TRUE;

        IDE_TEST_RAISE( qmoPartition::compareRangePartition(
                            aTableInfo->partKeyColumns,
                            sPartCondMaxVal,
                            sPartCondMinVal2 ) != 0,
                        ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
    }
    else if( (sPartKeyCondMaxValueStr->length == 0) ||
             (sPartKeyCondMinValueStr2->length == 0) )
    {
        sIsLeftPartIsLess = ID_FALSE;

        IDE_TEST_RAISE( qmoPartition::compareRangePartition(
                            aTableInfo->partKeyColumns,
                            sPartCondMinVal,
                            sPartCondMaxVal2 ) != 0,
                        ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
    }
    else
    {
        if( qmoPartition::compareRangePartition(
                aTableInfo->partKeyColumns,
                sPartCondMaxVal,
                sPartCondMinVal2 ) == 0 )
        {
            sIsLeftPartIsLess = ID_TRUE;
        }
        else if( qmoPartition::compareRangePartition(
                     aTableInfo->partKeyColumns,
                     sPartCondMaxVal2,
                     sPartCondMinVal ) == 0 )
        {
            sIsLeftPartIsLess = ID_FALSE;
        }
        else
        {
            IDE_RAISE( ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
        }
    }

    // SrcPart1 SrcPart2  ĽƮ  ´.
    sParseTree->partTable->partAttr->alterPart->isLeftPartIsLess = sIsLeftPartIsLess;

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_MERGE_NOT_ADJ_PARTITIONS_IN_RANGE_PART_TABLE));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* BUG-46065 support range using hash */
IDE_RC qdbAlter::checkAdjRangeUsingHashPartition( qcStatement  * aStatement,
                                                  qcmTableInfo * /* aTableInfo */ )
{
    qmsPartCondValList   * sPartCondMinVal;
    qmsPartCondValList   * sPartCondMaxVal;
    mtdCharType          * sPartKeyCondMinValueStr;
    mtdCharType          * sPartKeyCondMaxValueStr;

    qmsPartCondValList   * sPartCondMinVal2;
    qmsPartCondValList   * sPartCondMaxVal2;
    mtdCharType          * sPartKeyCondMinValueStr2;
    mtdCharType          * sPartKeyCondMaxValueStr2;

    qdTableParseTree     * sParseTree;
    idBool                 sIsLeftPartIsLess = ID_FALSE;
    qdPartitionAttribute * sSrcPartAttr1;
    qdPartitionAttribute * sSrcPartAttr2;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    sSrcPartAttr1 = sParseTree->partTable->partAttr;
    sSrcPartAttr2 = sParseTree->partTable->partAttr->next;

    // ĽƮ ´.
    sPartCondMinVal         = sSrcPartAttr1->alterPart->partCondMinVal;
    sPartCondMaxVal         = sSrcPartAttr1->alterPart->partCondMaxVal;
    sPartKeyCondMinValueStr = sSrcPartAttr1->alterPart->partKeyCondMinValStr;
    sPartKeyCondMaxValueStr = sSrcPartAttr1->alterPart->partKeyCondMaxValStr;

    sPartCondMinVal2         = sSrcPartAttr2->alterPart->partCondMinVal;
    sPartCondMaxVal2         = sSrcPartAttr2->alterPart->partCondMaxVal;
    sPartKeyCondMinValueStr2 = sSrcPartAttr2->alterPart->partKeyCondMinValStr;
    sPartKeyCondMaxValueStr2 = sSrcPartAttr2->alterPart->partKeyCondMaxValStr;

    // ---------------------------------------------------
    // SrcPart1 max value SrcPart2 min value ų
    // SrcPart2 max value SrcPart1 max value 
    //   Ƽ̴.
    // ---------------------------------------------------
    if ( (sPartKeyCondMinValueStr->length == 0) ||
         (sPartKeyCondMaxValueStr2->length == 0) )
    {
        sIsLeftPartIsLess = ID_TRUE;

        IDE_TEST_RAISE( qmoPartition::compareRangeUsingHashPartition(
                            sPartCondMaxVal,
                            sPartCondMinVal2 ) != 0,
                        ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
    }
    else if ( (sPartKeyCondMaxValueStr->length == 0) ||
              (sPartKeyCondMinValueStr2->length == 0) )
    {
        sIsLeftPartIsLess = ID_FALSE;

        IDE_TEST_RAISE( qmoPartition::compareRangeUsingHashPartition(
                            sPartCondMinVal,
                            sPartCondMaxVal2 ) != 0,
                        ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
    }
    else
    {
        if ( qmoPartition::compareRangeUsingHashPartition(
                sPartCondMaxVal,
                sPartCondMinVal2 ) == 0 )
        {
            sIsLeftPartIsLess = ID_TRUE;
        }
        else if ( qmoPartition::compareRangeUsingHashPartition(
                sPartCondMaxVal2,
                sPartCondMinVal ) == 0 )
        {
            sIsLeftPartIsLess = ID_FALSE;
        }
        else
        {
            IDE_RAISE( ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE );
        }
    }

    // SrcPart1 SrcPart2  ĽƮ  ´.
    sParseTree->partTable->partAttr->alterPart->isLeftPartIsLess = sIsLeftPartIsLess;

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_MERGE_NOT_ADJACENT_PARTITIONS_IN_RANGE_PART_TABLE)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_CANNOT_MERGE_NOT_ADJ_PARTITIONS_IN_RANGE_PART_TABLE));
    }

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/*
    Table Flag ϴ Alter  Validation

    ex> ALTER TABLE TABLENAME COMPRESSED LOGGING
    ex> ALTER TABLE TABLENAME UNCOMPRESSED LOGGING

    [IN] aStatement - Validation  Statement
 */
IDE_RC qdbAlter::validateAttrFlag( qcStatement * aStatement )
{
    qdTableParseTree     * sParseTree    = NULL;
    qcmPartitionInfoList * sPartInfoList = NULL;
    SInt                   sCountVolType = 0;
    UInt                   sTableType    = 0;
    UInt                   sFlag         = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_TRUE )
              != IDE_SUCCESS );

    IDE_ASSERT( sParseTree->tableAttrFlagList != NULL );

    /* List  ϳ Attribuate Flag ־  */
    IDE_ASSERT( sParseTree->tableAttrFlagList->next == NULL );

    /* PROJ-2464 hybrid partitioned table 
     *  - Table Partition  ߰ ˻̴.
     *  - Volatile Partition ִ , Uncompressed Logging ɼǸ Ѵ.
     *     1. Partition List ´.
     *     2. Volatile ü Uncompressed Logging ɼǸ Ѵ.
     */
    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;
    sFlag      = sParseTree->tableAttrFlagList->attrValue;

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 1. Partition List ´. */
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          &( sParseTree->partTable->partInfoList ) )
                  != IDE_SUCCESS );

        sPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    if ( ( sFlag & SMI_TABLE_LOG_COMPRESS_MASK ) == SMI_TABLE_LOG_COMPRESS_TRUE )
    {
        /* 2. Volatile ü Uncompressed Logging ɼǸ Ѵ. */
        qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                    sPartInfoList,
                                                    NULL,
                                                    NULL,
                                                    & sCountVolType );

        IDE_TEST_RAISE( sCountVolType > 0, ERR_VOLATILE_LOG_COMPRESS );
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_VOLATILE_LOG_COMPRESS );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDT_UNABLE_TO_COMPRESS_VOLATILE_TBS_LOG ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/*
    Table Flag ϴ Alter  Execution

    ex> ALTER TABLE TABLENAME COMPRESSED LOGGING
    ex> ALTER TABLE TABLENAME UNCOMPRESSED LOGGING

    BUG-49063
    ex> ALTER QUEUE TABLENAME DELETE ON
    ex> ALTER QUEUE TABLENAME DELETE OFF

    [IN] aStatement - Validation  Statement
 */

IDE_RC qdbAlter::executeAttrFlag( qcStatement * aStatement )
{
    qdTableParseTree     * sParseTree       = NULL;
    smOID                  sTableOID        = SMI_NULL_OID;
    qcmPartitionInfoList * sPartInfoList    = NULL;
    UInt                   sPartID          = 0;
    smOID                  sPartOID         = SMI_NULL_OID;
    qcmTableInfo         * sTableInfo       = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    smSCN                  sNewSCN;
    void                 * sNewTableHandle  = NULL;
    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* TASK-2176 Table  Lock ȹѴ. */
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;
    sTableOID  = smiGetTableId( sTableInfo->tableHandle );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 1.  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::alterTableFlag( QC_SMI_STMT( aStatement ),
                                        sTableInfo->tableHandle,
                                        sParseTree->tableAttrFlagList->attrMask,
                                        sParseTree->tableAttrFlagList->attrValue )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 2.  Ƽǿ ۾ Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            IDE_TEST( smiTable::alterTableFlag( QC_SMI_STMT( aStatement ),
                                                sPartInfoList->partHandle,
                                                sParseTree->tableAttrFlagList->attrMask,
                                                sParseTree->tableAttrFlagList->attrValue )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    /* fix BUG-14394 */
    IDE_TEST( qdbCommon::updateTableSpecFromMeta( aStatement,
                                                  sParseTree->userName,
                                                  sParseTree->tableName,
                                                  sTableInfo->tableID,
                                                  sTableOID,
                                                  sTableInfo->columnCount,
                                                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 3.  Ƽ Last DDL Time Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sTableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sTableInfo->tableID,
                                           sTableOID )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableInfo->tableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    /* Touch Commit   ̱ , Touch  Ѵ. */
    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableInfo->tableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo( sTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

/*
    Supplemental Logging ο 
    Table Flag ϴ Alter  Validation

    PROJ-1723 [MDW/INTEGRATOR] Altibase Plugin 

    ALTER TABLE table_name DROP SUPPLEMENTAL LOG DATA ( PRIMARY KEY ) COLUMNS
    ALTER TABLE table_name ADD SUPPLEMENTAL LOG DATA ( PRIMARY KEY ) COLUMNS

    [IN] aStatement - Validation  Statement
 */
IDE_RC qdbAlter::validateAlterTableSuppLogging( qcStatement * aStatement )
{
    qdTableParseTree     * sParseTree    = NULL;
    UInt                   sTableType    = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    SInt                   sCountVolType = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* ALTER TABLE   validation  - ̺ LOCK(IS) */
    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    IDE_TEST_RAISE( sParseTree->tableInfo->primaryKey == NULL,
                    ERR_NO_SUPP_LOGGING_WITHOUT_PK );

    /* PROJ-2464 hybrid partitioned table 
     *  - Table Partition  ߰ ˻̴.
     *  - Volatile Partition ִ , Supplemental Logging ɼǸ Ѵ.
     *     1. Parser Ҵ  PartTable ⼭ ҴѴ.
     *     2. Partition List ´.
     *     3. Volatile ü Supplemental Logging ɼǸ Ѵ.
     */
    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_DASSERT( sParseTree->partTable == NULL );

        /* 1. Parser Ҵ  PartTable ⼭ ҴѴ. */
        IDU_FIT_POINT( "qdbAlter::validateAlterTableSuppLogging::alloc::sParseTree->partTable",
                       idERR_ABORT_InsufficientMemory );

        IDE_TEST( QC_QMP_MEM( aStatement )->alloc( ID_SIZEOF( qdPartitionedTable ),
                                                   (void**)&( sParseTree->partTable ) )
                  != IDE_SUCCESS );

        /* 2. Partition List ´. */
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo( aStatement,
                                                          sParseTree->tableInfo->tableID,
                                                          &( sParseTree->partTable->partInfoList ) )
                  != IDE_SUCCESS );

        sPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    /* 3. Volatile ü Supplemental Logging ɼǸ Ѵ. */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                sPartInfoList,
                                                NULL,
                                                NULL,
                                                & sCountVolType );

    IDE_TEST_RAISE( sCountVolType > 0, ERR_NO_SUPP_LOGGING_ON_VOLATILE_TABLE );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_NO_SUPP_LOGGING_ON_VOLATILE_TABLE )
    {
        IDE_SET(ideSetErrorCode(
                    qpERR_ABORT_QDB_NO_SUPP_LOGGING_ON_VOLATILE_TABLE));
    }
    IDE_EXCEPTION( ERR_NO_SUPP_LOGGING_WITHOUT_PK )
    {
        IDE_SET(ideSetErrorCode(
                    qpERR_ABORT_QDB_NO_SUPP_LOGGING_WITHOUT_PK));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/*
    Supplemental Logging ο 
    Table Flag ϴ Alter  Execution

    PROJ-1723 [MDW/INTEGRATOR] Altibase Plugin 

    ALTER TABLE table_name DROP SUPPLEMENTAL LOG DATA ( PRIMARY KEY ) COLUMNS
    ALTER TABLE table_name ADD SUPPLEMENTAL LOG DATA ( PRIMARY KEY ) COLUMNS

    [IN] aStatement - Validation  Statement
 */

IDE_RC qdbAlter::executeAlterTableSuppLogging( qcStatement * aStatement )
{
    qdTableParseTree     * sParseTree       = NULL;
    UInt                   sNewAttrValue    = 0;
    smOID                  sTableOID        = SMI_NULL_OID;
    qcmPartitionInfoList * sPartInfoList    = NULL;
    UInt                   sPartID          = 0;
    smOID                  sPartOID         = SMI_NULL_OID;
    qcmTableInfo         * sTableInfo       = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    smSCN                  sNewSCN;
    void                 * sNewTableHandle  = NULL;
    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    if ( sParseTree->isSuppLogging == ID_TRUE )
    {
        sNewAttrValue = SMI_TABLE_SUPPLEMENTAL_LOGGING_TRUE;
    }
    else
    {
        sNewAttrValue = SMI_TABLE_SUPPLEMENTAL_LOGGING_FALSE;
    }

    /* TASK-2176 Table  Lock ȹѴ. */
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;
    sTableOID  = smiGetTableId( sTableInfo->tableHandle );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 1.  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::alterTableFlag( QC_SMI_STMT( aStatement ),
                                        sTableInfo->tableHandle,
                                        SMI_TABLE_SUPPLEMENTAL_LOGGING_MASK,
                                        sNewAttrValue )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 2.  Ƽǿ ۾ Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            IDE_TEST( smiTable::alterTableFlag( QC_SMI_STMT( aStatement ),
                                                sPartInfoList->partHandle,
                                                SMI_TABLE_SUPPLEMENTAL_LOGGING_MASK,
                                                sNewAttrValue )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    /* fix BUG-14394 */
    IDE_TEST( qdbCommon::updateTableSpecFromMeta( aStatement,
                                                  sParseTree->userName,
                                                  sParseTree->tableName,
                                                  sTableInfo->tableID,
                                                  sTableOID,
                                                  sTableInfo->columnCount,
                                                  sTableInfo->parallelDegree )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* 3.  Ƽ Last DDL Time Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sTableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sTableInfo->tableID,
                                           sTableOID )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableInfo->tableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    /* Touch Commit   ̱ , Touch  Ѵ. */
    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableInfo->tableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo( sTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

/*
    Table Insert Limit ϴ Alter  

    ex> ALTER TABLE TABLENAME INSERT HIGH LIMIT .. INSERT LOW LIMIT;
    ex> ALTER TABLE TABLENAME INSERT LOW LIMIT ..;

    [IN] aStatement - Validation  Statement
 */

IDE_RC qdbAlter::executeAlterTableSegAttr(qcStatement * aStatement)
{
    qdTableParseTree     * sParseTree    = NULL;
    SChar                * sSqlStr       = NULL;
    vSLong                 sRowCnt       = 0;
    qcmTableInfo         * sTableInfo    = NULL;
    UInt                   sTableID      = 0;
    smOID                  sTableOID     = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    UInt                   sPartID       = 0;
    smOID                  sPartOID      = 0 ;
    qdIndexTableList     * sIndexTable   = NULL;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* TASK-2176 - Table  Lock ȹѴ. */
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::alterTableSegAttr( QC_SMI_STMT( aStatement ),
                                           sTableInfo->tableHandle,
                                           sParseTree->segAttr )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            /* PROJ-2464 hybrid partitioned table 
             *  - Disk Partition SegAttr
             */
            if ( ( sPartInfoList->partitionInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
            {
                IDE_TEST( smiTable::alterTableSegAttr( QC_SMI_STMT( aStatement ),
                                                       sPartInfoList->partHandle,
                                                       sParseTree->segAttr )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }
        }

        /* PROJ-1624 non-partitioned index */
        for ( sIndexTable  = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable  = sIndexTable->next )
        {
            IDE_TEST( smiTable::alterTableSegAttr( QC_SMI_STMT( aStatement ),
                                                   sIndexTable->tableHandle,
                                                   sParseTree->segAttr )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    sTableID  = sTableInfo->tableID;
    sTableOID = smiGetTableId( sTableInfo->tableHandle );

    IDU_LIMITPOINT( "qdbAlter::executeAlterTableSegAttr::malloc" );
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE( aStatement->qmxMem,
                                      SChar,
                                      QD_MAX_SQL_LENGTH,
                                      & sSqlStr )
              != IDE_SUCCESS );

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_TABLES_ "
                     "SET PCTFREE= INTEGER'%"ID_INT32_FMT"', "
                     "    PCTUSED= INTEGER'%"ID_INT32_FMT"', "
                     "    INIT_TRANS= INTEGER'%"ID_INT32_FMT"', "
                     "    MAX_TRANS= INTEGER'%"ID_INT32_FMT"', "
                     "    LAST_DDL_TIME = SYSDATE "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     sParseTree->segAttr.mPctFree,
                     sParseTree->segAttr.mPctUsed,
                     sParseTree->segAttr.mInitTrans,
                     sParseTree->segAttr.mMaxTrans,
                     sTableID );

    IDE_TEST( qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                 sSqlStr,
                                 & sRowCnt )
              != IDE_SUCCESS );

    IDE_TEST_RAISE( sRowCnt != 1, ERR_META_CRASH );

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽ Last DDL Time Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sTableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sTableID,
                                           sTableOID )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo( sTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_META_CRASH )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QCM_META_CRASH ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}


/*
    Table STORAGE ϴ Alter   

    ex> ALTER TABLE TABLENAME STORAGE( .. );

    [IN] aStatement - Validation  Statement
 */

IDE_RC qdbAlter::executeAlterTableSegStoAttr( qcStatement * aStatement )
{

    qdTableParseTree     * sParseTree    = NULL;
    SChar                * sSqlStr       = NULL;
    vSLong                 sRowCnt       = 0;
    qcmTableInfo         * sTableInfo    = NULL;
    UInt                   sTableID      = 0;
    smOID                  sTableOID     = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    UInt                   sPartID       = 0;
    smOID                  sPartOID      = 0;
    qdIndexTableList     * sIndexTable   = NULL;

    qcmPartitionInfoList * sOldPartInfoList = NULL;
    qcmPartitionInfoList * sNewPartInfoList = NULL;
    qcmTableInfo         * sNewTableInfo    = NULL;
    void                 * sNewTableHandle  = NULL;
    smSCN                  sNewSCN          = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* TASK-2176 Table  Lock ȹѴ. */
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    /* Partitioned Table  Partition  Lock ȹѴ. */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
        
        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::alterTableSegStoAttr( QC_SMI_STMT( aStatement ),
                                              sTableInfo->tableHandle,
                                              sParseTree->segStoAttr )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            /* PROJ-2464 hybrid partitioned table 
             *  - Disk Partition SegStoAttr
             */
            if ( ( sPartInfoList->partitionInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
            {
                IDE_TEST( smiTable::alterTableSegStoAttr( QC_SMI_STMT( aStatement ),
                                                          sPartInfoList->partHandle,
                                                          sParseTree->segStoAttr )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }
        }

        /* PROJ-1624 non-partitioned index */
        for ( sIndexTable  = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable  = sIndexTable->next )
        {
            IDE_TEST( smiTable::alterTableSegStoAttr( QC_SMI_STMT( aStatement ),
                                                      sIndexTable->tableHandle,
                                                      sParseTree->segStoAttr )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }
    
    sTableID  = sTableInfo->tableID;
    sTableOID = smiGetTableId( sTableInfo->tableHandle );

    IDU_LIMITPOINT( "qdbAlter::executeAlterTableSegStoAttr::malloc" );
    IDE_TEST( STRUCT_ALLOC_WITH_SIZE( aStatement->qmxMem,
                                      SChar,
                                      QD_MAX_SQL_LENGTH,
                                      & sSqlStr )
              != IDE_SUCCESS );

    idlOS::snprintf( sSqlStr, QD_MAX_SQL_LENGTH,
                     "UPDATE SYS_TABLES_ "
                     "SET INITEXTENTS = BIGINT'%"ID_INT64_FMT"', "
                     "    NEXTEXTENTS = BIGINT'%"ID_INT64_FMT"', "
                     "    MINEXTENTS  = BIGINT'%"ID_INT64_FMT"', "
                     "    MAXEXTENTS  = BIGINT'%"ID_INT64_FMT"', "
                     "    LAST_DDL_TIME = SYSDATE "
                     "WHERE TABLE_ID = INTEGER'%"ID_INT32_FMT"'",
                     (ULong)sParseTree->segStoAttr.mInitExtCnt,
                     (ULong)sParseTree->segStoAttr.mNextExtCnt,
                     (ULong)sParseTree->segStoAttr.mMinExtCnt,
                     (ULong)sParseTree->segStoAttr.mMaxExtCnt,
                     sTableID );

    IDE_TEST( qcg::runDMLforDDL( QC_SMI_STMT( aStatement ),
                                 sSqlStr,
                                 & sRowCnt )
              != IDE_SUCCESS );

    IDE_TEST_RAISE( sRowCnt != 1, ERR_META_CRASH );


    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sTableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽ Last DDL Time Ѵ. */
        for ( sPartInfoList  = sOldPartInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sTableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sTableID,
                                           sTableOID )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sTableID,
                                     & sNewTableInfo,
                                     & sNewSCN,
                                     & sNewTableHandle )
              != IDE_SUCCESS );

    if ( sTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        sOldPartInfoList )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::makeAndSetAndGetQcmPartitionInfoList( aStatement,
                                                                      sNewTableInfo,
                                                                      sOldPartInfoList,
                                                                      & sNewPartInfoList )
                  != IDE_SUCCESS );

        (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
    }
    else
    {
        /* Nothing to do */
    }

    (void)qcm::destroyQcmTableInfo( sTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_META_CRASH )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QCM_META_CRASH ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );
    (void)qcmPartition::destroyQcmPartitionInfoList( sNewPartInfoList );

    qcmPartition::restoreTempInfo( sTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

/*
    Table Extent Ҵϴ Alter   

    ex> ALTER TABLE TABLENAME ALLOCATE EXTENT ( SIZE .. );

    [IN] aStatement - Validation  Statement
 */

IDE_RC qdbAlter::executeAlterTableAllocExtent( qcStatement * aStatement )
{
    qdTableParseTree     * sParseTree    = NULL;
    UInt                   sTableID      = 0;
    smOID                  sTableOID     = 0;
    qcmPartitionInfoList * sPartInfoList = NULL;
    UInt                   sPartID       = 0;
    smOID                  sPartOID      = 0;
    qdIndexTableList     * sIndexTable   = NULL;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    /* TASK-2176 Table  Lock ȹѴ. */
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    /* Partitioned Table  Partition  Lock ȹѴ. */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽǿ LOCK(X) */
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        /* PROJ-1624 non-partitioned index */
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    IDE_TEST( smiTable::alterTableAllocExts( QC_SMI_STMT( aStatement ),
                                             sParseTree->tableInfo->tableHandle,
                                             sParseTree->altAllocExtSize )
              != IDE_SUCCESS );

    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽǿ LOCK(X) */
        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            /* PROJ-2464 hybrid partitioned table 
             *  - Disk Partition Allocate Extent
             */
            if ( ( sPartInfoList->partitionInfo->tableFlag & SMI_TABLE_TYPE_MASK ) == SMI_TABLE_DISK )
            {
                IDE_TEST( smiTable::alterTableAllocExts( QC_SMI_STMT( aStatement ),
                                                         sPartInfoList->partHandle,
                                                         sParseTree->altAllocExtSize )
                          != IDE_SUCCESS );
            }
            else
            {
                /* Nothing to do */
            }
        }

        /* PROJ-1624 non-partitioned index */
        for ( sIndexTable  = sParseTree->oldIndexTables;
              sIndexTable != NULL;
              sIndexTable  = sIndexTable->next )
        {
            IDE_TEST( smiTable::alterTableAllocExts( QC_SMI_STMT( aStatement ),
                                                     sIndexTable->tableHandle,
                                                     sParseTree->altAllocExtSize )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    sTableID  = sParseTree->tableInfo->tableID;
    sTableOID = smiGetTableId( sParseTree->tableInfo->tableHandle );

    /* fix BUG-14394 */
    IDE_TEST( qdbCommon::updateTableSpecFromMeta( aStatement,
                                                  sParseTree->userName,
                                                  sParseTree->tableName,
                                                  sTableID,
                                                  sTableOID,
                                                  sParseTree->tableInfo->columnCount,
                                                  sParseTree->tableInfo->parallelDegree )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /*  Ƽ Last DDL Time Ѵ. */
        for ( sPartInfoList  = sParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList  = sPartInfoList->next )
        {
            sPartID  = sPartInfoList->partitionInfo->partitionID;
            sPartOID = smiGetTableId( sPartInfoList->partHandle );

            IDE_TEST( qdbCommon::updatePartTableSpecFromMeta( aStatement,
                                                              sParseTree->tableInfo->tableID,
                                                              sPartID,
                                                              sPartOID )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        /* Nothing to do */
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::validateModifyCol( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description : PROJ-1877
 *    ALTER TABLE ... MODIFY COLUMN ...;
 *
 *    modify column  װ  Ѵ.
 *      1. column type ȯ
 *      2. column length ȯ
 *      3. column (not)null constraint ߰ ( constraint name )
 *      4. column default ߰/
 *
 * Implementation :
 *    1. ϴ ̺ üũ
 *    2. ALTER Ϸ ̺ Ÿ ̸̺  ȯ
 *    3. ALTER TABLE  ִ üũ
 *    4.  ÷ ϴ üũ
 *    6. (not)null constraint ̹ ϴ üũ
 *    7. ̺ ÷ blob, clob, timestamp type̸  ȯ
 *    8.  ÷ blob, clob, timestamp type̸  ȯ
 *    9. ̺ ÷ ϰ ִ foreign key ִٸ length Ȯ븸 
 *    10. ̺ ÷ ϰ ִ foreign key ִٸ length Ȯ븸 
 *    14. partition key  length Ȯ븸 
 *    11. Ÿ ȯ matrix  뿩 ˻
 *        a. MISC GROUP type  typeθ ȯ ϴ.
 *           - byte<->byte
 *           - nibble<->nibble
 *        b. ɼ  flag 
 *    12. ÷  modify  flag 
 *    13. ÷, not null constraint validation
 *    15. check constraint  ÷ Data Type/Length ϸ  ȯ
 *    16. Hidden Column   .
 *        Hidden Column Expression Ե Column   .
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::validateModifyCol"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::validateModifyCol"));

    qdTableParseTree    * sParseTree;
    qcmColumn           * sParseColumn;
    qcmColumn           * sModifyColumn;
    qcmColumn           * sTableColumn;
    mtcColumn           * sTableColumnInfo;
    mtcColumn           * sModifyColumnInfo;
    qcmIndex            * sIndexInfo;
    qcmRefChildInfo     * sChildInfo;  // BUG-28049
    qdConstraintSpec    * sCheckConstrSpecList = NULL;
    UInt                  i;
    qcuSqlSourceInfo      sqlInfo;
    idBool                sIsValid;

    /* PROJ-1090 Function-based Index */
    qcmColumn           * sDefaultExprColumns = NULL;

    SInt                  sCountDiskType = 0;
    SInt                  sCountMemType  = 0;
    SInt                  sCountVolType  = 0;
    SInt                  sTotalCount    = 0;
    UInt                  sTableType     = 0;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    //-----------------------------------------
    // ALTER TABLE   validation 
    // 1. ϴ ̺ üũ
    // 2. ALTER Ϸ ̺ Ÿ ̸̺  ȯ
    // 3. ALTER TABLE  ִ üũ
    //-----------------------------------------

    IDE_TEST( validateAlterCommon( aStatement,
                                   ID_FALSE )
              != IDE_SUCCESS );

    /* PROJ-2464 hybrid partitioned table  */
    sTableType = sParseTree->tableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    //-----------------------------------------
    // partitioned table partInfo ޾ش.
    //-----------------------------------------

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        //  Ƽǿ LOCK(IS)
        // Ƽ Ʈ ĽƮ ޾Ƴ´.
        IDE_TEST( qdbCommon::checkAndSetAllPartitionInfo(
                      aStatement,
                      sParseTree->tableInfo->tableID,
                      & (sParseTree->partTable->partInfoList) )
                  != IDE_SUCCESS );
        
        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::makeAndLockIndexTableList(
                      aStatement,
                      ID_FALSE,
                      sParseTree->tableInfo,
                      &(sParseTree->oldIndexTables) )
                  != IDE_SUCCESS );

        /* 1. Partition  ˻Ѵ. */
        qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                    sParseTree->partTable->partInfoList,
                                                    & sCountDiskType,
                                                    & sCountMemType,
                                                    & sCountVolType );

        /* 2. Hybrid Partitioned Table  Modify Column  ʴ´. */
        sTotalCount = sCountDiskType + sCountMemType + sCountVolType;

        /* 2.1.   Type ˻Ѵ. Hybrid Partitioned Table ƴϴ. */
        IDE_TEST_RAISE( !( ( sTotalCount == sCountDiskType ) ||
                           ( sTotalCount == sCountMemType ) ||
                           ( sTotalCount == sCountVolType ) ),
                        ERR_UNSUPPORT_ON_HYBRID_PARTITIONED_TABLE );
    }
    else
    {
        // Nothing to do.
    }

    sParseColumn = sParseTree->columns;
    sModifyColumn = sParseTree->modifyColumns;

    while ( sParseColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        sqlInfo.setSourceInfo( aStatement,
                               & sParseColumn->namePos );

        //-----------------------------------------
        // 4.  ÷ ϴ üũ
        //-----------------------------------------

        IDE_TEST( qcmCache::getColumn( aStatement,
                                       sParseTree->tableInfo,
                                       sParseColumn->namePos,
                                       & sTableColumn )
                  != IDE_SUCCESS );

        // basicInfo Ѵ.
        QDB_SET_QCM_COLUMN( sParseColumn, sTableColumn );

        // default value Ѵ.
        sParseColumn->defaultValueStr = sTableColumn->defaultValueStr;

        if ( sModifyColumn->basicInfo == NULL )
        {
            // data type  ʾ Ѵ.
            sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_DATA_TYPE_MASK;
            sModifyColumn->flag |= QCM_COLUMN_MODIFY_DATA_TYPE_FALSE;

            // basicInfo  Ѵ.
            IDU_LIMITPOINT("qdbAlter::validateModifyCol::malloc2");
            IDE_TEST( QC_QMP_MEM(aStatement)->alloc(
                          ID_SIZEOF(mtcColumn),
                          (void**) & sModifyColumn->basicInfo )
                      != IDE_SUCCESS );

            idlOS::memcpy( (void*) sModifyColumn->basicInfo,
                           (void*) sTableColumn->basicInfo,
                           ID_SIZEOF(mtcColumn) );

            // srid  
            if ( ( sModifyColumn->flag & QCM_COLUMN_MODIFY_SRID_MASK )
                 == QCM_COLUMN_MODIFY_SRID_TRUE )
            {
                // ̺ ȭ ɷ  
                IDE_TEST_RAISE( sParseTree->tableInfo->replicationCount > 0,
                                ERR_DDL_WITH_REPLICATED_TABLE );

                IDE_TEST( qtc::changeColumn4SRID( aStatement,
                                                  sModifyColumn->mExtColumnAttr,
                                                  sModifyColumn->basicInfo )
                          != IDE_SUCCESS );

                // modify column name Ѵ.
                idlOS::strncpy( sModifyColumn->name,
                                sTableColumn->name,
                                QC_MAX_NAME_LEN + 1 );
                sModifyColumn->name[QC_MAX_NAME_LEN] = '\0';
            }
            else
            {
                // Nothing to do.
            }

            // encryption  
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK)
                 == QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE )
            {
                IDE_TEST( qtc::changeColumn4Encrypt(
                              aStatement,
                              sModifyColumn->mExtColumnAttr,
                              sModifyColumn->basicInfo )
                          != IDE_SUCCESS );

                // modify column name Ѵ.
                idlOS::strncpy( sModifyColumn->name,
                                sTableColumn->name,
                                QC_MAX_OBJECT_NAME_LEN + 1 );
                sModifyColumn->name[QC_MAX_OBJECT_NAME_LEN] = '\0';
            }
            else
            {
                // Nothing to do.
            }

            // decryption  
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DECRYPT_COLUMN_MASK)
                 == QCM_COLUMN_MODIFY_DECRYPT_COLUMN_TRUE )
            {
                IDE_TEST( qtc::changeColumn4Decrypt(
                              sModifyColumn->basicInfo )
                          != IDE_SUCCESS );

                // modify column name Ѵ.
                idlOS::strncpy( sModifyColumn->name,
                                sTableColumn->name,
                                QC_MAX_OBJECT_NAME_LEN + 1 );
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // data type  Ѵ.
            sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_DATA_TYPE_MASK;
            sModifyColumn->flag |= QCM_COLUMN_MODIFY_DATA_TYPE_TRUE;

            // basicInfo column.id Ѵ.
            sModifyColumn->basicInfo->column.id =
                sTableColumn->basicInfo->column.id;

            // modify column name Ѵ.
            idlOS::strncpy( sModifyColumn->name,
                            sTableColumn->name,
                            QC_MAX_OBJECT_NAME_LEN + 1 );
        }

        sTableColumnInfo = sParseColumn->basicInfo;
        sModifyColumnInfo = sModifyColumn->basicInfo;

        //-----------------------------------------
        // 5.1. PROJ-2264 Dictionary table
        //      Compression column  default value 游 ϴ.
        //-----------------------------------------

        if ( (sTableColumnInfo->column.flag & SMI_COLUMN_COMPRESSION_MASK)
             == SMI_COLUMN_COMPRESSION_TRUE )
        {
            if ( ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
                   == QCM_COLUMN_MODIFY_DATA_TYPE_FALSE ) &&
                 ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                   == QCM_COLUMN_MODIFY_NULLABLE_NONE ) &&
                 ( sModifyColumn->defaultValue != NULL ) )
            {
                // type  Ȥ length  ƴϰ
                // (not)null  ƴϰ
                // default value ϴ 

                // Nothing to do.
            }
            else
            {
                sqlInfo.setSourceInfo( aStatement,
                                       &(sModifyColumn->namePos) );
                IDE_RAISE( ERR_MODIFY_COMPRESSION_COLUMN );
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 6. (not)null constraint ̹ ϴ üũ
        //-----------------------------------------

        if  ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
              == QCM_COLUMN_MODIFY_NULLABLE_NULL )
        {
            // ̹ nullableε null ϸ 
            IDE_TEST_RAISE( (sTableColumnInfo->flag & MTC_COLUMN_NOTNULL_MASK)
                            == MTC_COLUMN_NOTNULL_FALSE,
                            ERR_NOT_EXIST_NOT_NULL );

            // primary key null ϸ 
            if ( sParseTree->tableInfo->primaryKey != NULL )
            {
                IDE_TEST_RAISE(
                    qdn::intersectColumn(
                        (UInt*) smiGetIndexColumns(sParseTree->tableInfo->primaryKey->indexHandle),
                        sParseTree->tableInfo->primaryKey->keyColCount,
                        & sModifyColumnInfo->column.id, 1 ) == ID_TRUE,
                    ERR_NOT_ALLOWED_DROP_NOT_NULL );
            }
            else
            {
                // Nothing to do.
            }
        }
        else if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                  == QCM_COLUMN_MODIFY_NULLABLE_NOTNULL )
        {
            // ̹ not nullε not null ϸ 
            IDE_TEST_RAISE( (sTableColumnInfo->flag & MTC_COLUMN_NOTNULL_MASK)
                            == MTC_COLUMN_NOTNULL_TRUE,
                            ERR_EXIST_NOT_NULL );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 7. ̺ ÷ blob, clob, timestamp type̸  ȯ
        // 8.  ÷ blob, clob, timestamp type̸  ȯ
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            // blob, clob, geometry
            IDE_TEST_RAISE( (sTableColumnInfo->module->id == MTD_BLOB_ID) ||
                            (sTableColumnInfo->module->id == MTD_CLOB_ID),
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            // timestamp
            IDE_TEST_RAISE( (sTableColumnInfo->flag & MTC_COLUMN_TIMESTAMP_MASK)
                            == MTC_COLUMN_TIMESTAMP_TRUE,
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            // blob, clob, geometry
            IDE_TEST_RAISE( (sModifyColumnInfo->module->id == MTD_BLOB_ID) ||
                            (sModifyColumnInfo->module->id == MTD_CLOB_ID),
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            // timestamp
            IDE_TEST_RAISE( (sModifyColumnInfo->flag & MTC_COLUMN_TIMESTAMP_MASK)
                            == MTC_COLUMN_TIMESTAMP_TRUE,
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            // geometry Ÿ data type   ,
            // length 游 
            IDE_TEST_RAISE(
                ( ( (sTableColumnInfo->module->id == MTD_GEOMETRY_ID) &&
                    (sModifyColumnInfo->module->id != MTD_GEOMETRY_ID) ) ||
                  ( (sTableColumnInfo->module->id != MTD_GEOMETRY_ID) &&
                    (sModifyColumnInfo->module->id == MTD_GEOMETRY_ID) ) ),
                ERR_ABORT_QDB_INVALID_MODIFICATION );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 8.5.1 char, varchar ̿ type encrypt modify  
        //-----------------------------------------

        if ( ( sModifyColumn->flag & QCM_COLUMN_MODIFY_SRID_MASK )
             == QCM_COLUMN_MODIFY_SRID_TRUE )
        {
            // geometry
            IDE_TEST_RAISE( sTableColumnInfo->module->id != MTD_GEOMETRY_ID,
                            ERR_ABORT_QDB_INVALID_MODIFICATION );
        }
        else
        {
            // Nothing to do.
        }

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK)
             == QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE )
        {
            // char, varchar
            IDE_TEST_RAISE( (sTableColumnInfo->module->id != MTD_CHAR_ID) &&
                            (sTableColumnInfo->module->id != MTD_VARCHAR_ID),
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            sIsValid = ID_FALSE;

            // BUG-26877 DDL    ߰
            IDE_TEST( qcsModule::checkSecurityPrivilege( aStatement,
                                                         sParseTree->tableInfo,
                                                         sModifyColumn,
                                                         ID_TRUE,
                                                         ID_TRUE,
                                                         ID_FALSE,
                                                         & sIsValid )
                      != IDE_SUCCESS );

            IDE_TEST_RAISE( sIsValid != ID_TRUE,
                            ERR_NOT_ALLOWED_ENCRYPTED_COLUMN_ACCESS );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 8.5.2 echar, evarchar ̿ type decrypt modify  
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DECRYPT_COLUMN_MASK)
             == QCM_COLUMN_MODIFY_DECRYPT_COLUMN_TRUE )
        {
            // echar, evarchar
            IDE_TEST_RAISE( (sTableColumnInfo->module->id != MTD_ECHAR_ID) &&
                            (sTableColumnInfo->module->id != MTD_EVARCHAR_ID),
                            ERR_ABORT_QDB_INVALID_MODIFICATION );

            sIsValid = ID_FALSE;

            // BUG-26877 DDL    ߰
            IDE_TEST( qcsModule::checkSecurityPrivilege( aStatement,
                                                         sParseTree->tableInfo,
                                                         sModifyColumn,
                                                         ID_TRUE,
                                                         ID_FALSE,
                                                         ID_TRUE,
                                                         & sIsValid )
                      != IDE_SUCCESS );

            IDE_TEST_RAISE( sIsValid != ID_TRUE,
                            ERR_NOT_ALLOWED_ENCRYPTED_COLUMN_ACCESS );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 8.5.3. echar, evarchar type type, length  Ұ
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            // echar, evarchar
            IDE_TEST_RAISE( (sTableColumnInfo->module->id == MTD_ECHAR_ID) ||
                            (sTableColumnInfo->module->id == MTD_EVARCHAR_ID),
                            ERR_ABORT_QDB_INVALID_MODIFICATION );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 9. ̺ ÷ ϰ ִ foreign key ִٸ length Ȯ븸 
        //-----------------------------------------

        // BUGBUG
        // foreign key ɷִٰؼ length Ȯ븸   ƴ϶
        // data loss ߻   ϴ.

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            for ( i = 0; i < sParseTree->tableInfo->foreignKeyCount; i++ )
            {
                if ( qdn::intersectColumn(
                         sParseTree->tableInfo->foreignKeys[i].referencingColumn,
                         sParseTree->tableInfo->foreignKeys[i].constraintColumnCount,
                         & sTableColumnInfo->column.id,
                         1 )
                     == ID_TRUE )
                {
                    if ( sTableColumnInfo->module->id != sModifyColumnInfo->module->id )
                    {
                        // type  Ұϴ.
                        IDE_RAISE( ERR_ABORT_QDB_INVALID_MODIFICATION );
                    }
                    else
                    {
                        // length  Ȯ븸 ϴ.
                        // (padding type̶ϴ equal  padding ڴ 񱳵
                        // Ƿ char(5) char(10) Ǵ fk constraint
                        //  ʴ´.)
                        if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                             == MTD_CREATE_PARAM_PRECISION )
                        {
                            IDE_TEST_RAISE( sTableColumnInfo->precision >
                                            sModifyColumnInfo->precision,
                                            ERR_ABORT_QDB_INVALID_MODIFICATION );
                        }
                        else if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                                  == MTD_CREATE_PARAM_PRECISIONSCALE )
                        {
                            IDE_TEST_RAISE( isEnlargingLengthForNumericType(
                                                sTableColumnInfo->precision,
                                                sTableColumnInfo->scale,
                                                sModifyColumnInfo->precision,
                                                sModifyColumnInfo->scale )
                                            == ID_FALSE,
                                            ERR_ABORT_QDB_INVALID_MODIFICATION );
                        }
                        else
                        {
                            // Nothing to do.
                        }
                    }
                }
                else
                {
                    // Nothing to do.
                }
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 10. ̺ ÷ ϰ ִ foreign key ִٸ length Ȯ븸 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            for ( i = 0; i < sParseTree->tableInfo->uniqueKeyCount; i++ )
            {
                sIndexInfo = sParseTree->tableInfo->uniqueKeys[i].constraintIndex;

                if ( qdn::intersectColumn(
                         (UInt*) smiGetIndexColumns(sIndexInfo->indexHandle),
                         sIndexInfo->keyColCount,
                         & sTableColumnInfo->column.id,
                         1 )
                     == ID_TRUE )
                {
                    IDE_TEST( qcm::getChildKeys( aStatement,
                                                 sIndexInfo,
                                                 sParseTree->tableInfo,
                                                 & sChildInfo )
                              != IDE_SUCCESS );

                    if ( sChildInfo != NULL )
                    {
                        if ( sTableColumnInfo->module->id != sModifyColumnInfo->module->id )
                        {
                            // type  Ұϴ.
                            IDE_RAISE( ERR_ABORT_QDB_INVALID_MODIFICATION );
                        }
                        else
                        {
                            // length  Ȯ븸 ϴ.
                            // (padding type̶ϴ equal  padding ڴ 񱳵
                            // Ƿ char(5) char(10) Ǵ fk constraint
                            //  ʴ´.)
                            if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                                 == MTD_CREATE_PARAM_PRECISION )
                            {
                                IDE_TEST_RAISE( sTableColumnInfo->precision >
                                                sModifyColumnInfo->precision,
                                                ERR_ABORT_QDB_INVALID_MODIFICATION );
                            }
                            else if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                                      == MTD_CREATE_PARAM_PRECISIONSCALE )
                            {
                                IDE_TEST_RAISE( isEnlargingLengthForNumericType(
                                                    sTableColumnInfo->precision,
                                                    sTableColumnInfo->scale,
                                                    sModifyColumnInfo->precision,
                                                    sModifyColumnInfo->scale )
                                                == ID_FALSE,
                                                ERR_ABORT_QDB_INVALID_MODIFICATION );
                            }
                            else
                            {
                                // Nothing to do.
                            }
                        }
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
                else
                {
                    // Nothing to do.
                }
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 14. partition key  length Ȯ븸 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
            {
                for ( i = 0; i < sParseTree->tableInfo->partKeyColCount; i++ )
                {
                    if ( sParseTree->tableInfo->partKeyColBasicInfo[i].column.id
                         == sTableColumnInfo->column.id )
                    {
                        if ( sTableColumnInfo->module->id != sModifyColumnInfo->module->id )
                        {
                            // type  Ұϴ.
                            IDE_RAISE( ERR_ABORT_QDB_INVALID_MODIFICATION );
                        }
                        else
                        {
                            // length  Ȯ븸 ϴ.
                            // (padding type̶ϴ equal  padding ڴ 񱳵
                            // Ƿ char(5) char(10) Ǵ 
                            //  ʴ´.)
                            if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                                 == MTD_CREATE_PARAM_PRECISION )
                            {
                                IDE_TEST_RAISE( sTableColumnInfo->precision >
                                                sModifyColumnInfo->precision,
                                                ERR_ABORT_QDB_INVALID_MODIFICATION );
                            }
                            else if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                                      == MTD_CREATE_PARAM_PRECISIONSCALE )
                            {
                                IDE_TEST_RAISE( isEnlargingLengthForNumericType(
                                                    sTableColumnInfo->precision,
                                                    sTableColumnInfo->scale,
                                                    sModifyColumnInfo->precision,
                                                    sModifyColumnInfo->scale )
                                                == ID_FALSE,
                                                ERR_ABORT_QDB_INVALID_MODIFICATION );
                            }
                            else
                            {
                                // Nothing to do.
                            }
                        }
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 11. Ÿ ȯ matrix  뿩 ˻
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            //-----------------------------------------
            // a. MISC GROUP type ˻
            //-----------------------------------------

            // binary, blob, byte, clob, nibble type type  Ұϴ.
            if ( sTableColumnInfo->module->id != sModifyColumnInfo->module->id )
            {
                IDE_TEST_RAISE( (sTableColumnInfo->module->flag & MTD_GROUP_MASK)
                                == MTD_GROUP_MISC,
                                ERR_ABORT_QDB_INVALID_MODIFICATION );
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // 12. ÷  modify  flag 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            if ( sTableColumnInfo->module->id != sModifyColumnInfo->module->id )
            {
                // type 
                sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_TYPE_MASK;
                sModifyColumn->flag |= QCM_COLUMN_MODIFY_TYPE_TRUE;

                // type  ڷᱸ   length 
                //   ִ.
                if ( ( (sTableColumnInfo->module->id == MTD_NCHAR_ID) &&
                       (sModifyColumnInfo->module->id == MTD_NVARCHAR_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_NVARCHAR_ID) &&
                       (sModifyColumnInfo->module->id == MTD_NCHAR_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_CHAR_ID) &&
                       (sModifyColumnInfo->module->id == MTD_VARCHAR_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_VARCHAR_ID) &&
                       (sModifyColumnInfo->module->id == MTD_CHAR_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_BIT_ID) &&
                       (sModifyColumnInfo->module->id == MTD_VARBIT_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_VARBIT_ID) &&
                       (sModifyColumnInfo->module->id == MTD_BIT_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_FLOAT_ID) &&
                       (sModifyColumnInfo->module->id == MTD_NUMERIC_ID) )
                     ||
                     ( (sTableColumnInfo->module->id == MTD_NUMERIC_ID) &&
                       (sModifyColumnInfo->module->id == MTD_FLOAT_ID) )
                     )
                {
                    // length 
                    sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_LENGTH_MASK;
                    sModifyColumn->flag |= QCM_COLUMN_MODIFY_LENGTH_TRUE;
                }
                else
                {
                    // Nothing to do.
                }
            }
            else
            {
                if ( (sTableColumnInfo->module->flag & MTD_CREATE_PARAM_MASK)
                     != MTD_CREATE_PARAM_NONE )
                {
                    // length 
                    sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_LENGTH_MASK;
                    sModifyColumn->flag |= QCM_COLUMN_MODIFY_LENGTH_TRUE;
                }
                else
                {
                    // Nothing to do.
                }
            }
        }
        else
        {
            // Nothing to do.
        }

        sParseColumn = sParseColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    //-----------------------------------------
    // 13. ÷, not null constraint validation
    //-----------------------------------------

    // decide column type
    IDE_TEST( qdbCommon::validateColumnListForModifyCol( aStatement,
                                                         sParseTree->tableInfo,
                                                         sParseTree->modifyColumns )
              != IDE_SUCCESS);

    // check not null constraint
    // (tableInfo constraints column  ä.)
    IDE_TEST( qdn::validateConstraints( aStatement,
                                        sParseTree->tableInfo,
                                        sParseTree->tableInfo->tableOwnerID,
                                        sParseTree->tableInfo->TBSID,
                                        sParseTree->tableInfo->TBSType,
                                        sParseTree->constraints,
                                        QDN_ON_MODIFY_COLUMN,
                                        NULL )
              != IDE_SUCCESS );

    //-----------------------------------------
    // 15. check constraint  ÷ Data Type/Length ϸ  ȯ
    //-----------------------------------------
    /* PROJ-1107 Check Constraint  */
    for ( sModifyColumn = sParseTree->modifyColumns;
          sModifyColumn != NULL;
          sModifyColumn = sModifyColumn->next )
    {
        if ( ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_TYPE_MASK)
                                   != QCM_COLUMN_MODIFY_TYPE_TRUE ) &&
             ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
                                   != QCM_COLUMN_MODIFY_LENGTH_TRUE ) )
        {
            continue;
        }
        else
        {
            /* Nothing to do */
        }

        IDE_TEST( qdnCheck::addCheckConstrSpecRelatedToColumn(
                                aStatement,
                                &sCheckConstrSpecList,
                                sParseTree->tableInfo->checks,
                                sParseTree->tableInfo->checkCount,
                                sModifyColumn->basicInfo->column.id )
                  != IDE_SUCCESS );

        if ( sCheckConstrSpecList != NULL )
        {
            sqlInfo.setSourceInfo( aStatement,
                                   &(sModifyColumn->namePos) );
            IDE_RAISE( ERR_MODIFY_COLUMN_HAVING_CHECK_CONSTRAINT );
        }
        else
        {
            /* Nothing to do */
        }
    }

    //-----------------------------------------
    // 16. Hidden Column   .
    //     Hidden Column Expression Ե Column   .
    //-----------------------------------------
    
    /* PROJ-1090 Function-based Index */
    for ( sModifyColumn = sParseTree->modifyColumns,
              sParseColumn = sParseTree->columns;
          sModifyColumn != NULL;
          sModifyColumn = sModifyColumn->next,
              sParseColumn = sParseColumn->next )
    {
        if ( ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_TYPE_MASK)
               != QCM_COLUMN_MODIFY_TYPE_TRUE ) &&
             ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
               != QCM_COLUMN_MODIFY_LENGTH_TRUE ) )
        {
            continue;
        }
        else
        {
            /* Nothing to do */
        }

        /* Hidden Column   . */
        if ( (sParseColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK)
             == QCM_COLUMN_HIDDEN_COLUMN_TRUE )
        {
            sqlInfo.setSourceInfo( aStatement,
                                   &(sModifyColumn->namePos) );
            IDE_RAISE( ERR_MODIFY_HIDDEN_COLUMN );
        }
        else
        {
            /* Nothing to do */
        }

        /* Hidden Column Expression Ե Column   . */
        IDE_TEST( qmsDefaultExpr::addDefaultExpressionColumnsRelatedToColumn(
                      aStatement,
                      & sDefaultExprColumns,
                      sParseTree->tableInfo,
                      sParseColumn->basicInfo->column.id )
                  != IDE_SUCCESS );
        
        if ( sDefaultExprColumns != NULL )
        {
            sqlInfo.setSourceInfo( aStatement,
                                   &(sModifyColumn->namePos) );
            IDE_RAISE( ERR_MODIFY_HIDDEN_COLUMN );
        }
        else
        {
            /* Nothing to do */
        }
    }
    
    //-----------------------------------------
    // 11. Ÿ ȯ matrix  뿩 ˻
    //-----------------------------------------

    sParseColumn = sParseTree->columns;
    sModifyColumn = sParseTree->modifyColumns;

    while ( sParseColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        sqlInfo.setSourceInfo( aStatement,
                               & sParseColumn->namePos );

        sTableColumnInfo = sParseColumn->basicInfo;
        sModifyColumnInfo = sModifyColumn->basicInfo;

        //-----------------------------------------
        // b. ɼ  flag 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK)
             == QCM_COLUMN_MODIFY_DATA_TYPE_TRUE )
        {
            //  ɼ  type   ϴ.

            // )
            // char variable -> varchar fixed
            // char variable -> char fixed
            // int variable -> double fixed

            if ( ( (sTableColumnInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                   != (sModifyColumnInfo->column.flag & SMI_COLUMN_TYPE_MASK) ) ||
                 ( sTableColumnInfo->column.vcInOutBaseSize
                   != sModifyColumnInfo->column.vcInOutBaseSize ) )
            {
                // column option 
                sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK;
                sModifyColumn->flag |= QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE;
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // c. encrypt Ȥ decrypt 
        //-----------------------------------------

        if ( ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK)
               == QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE ) ||
             ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DECRYPT_COLUMN_MASK)
               == QCM_COLUMN_MODIFY_DECRYPT_COLUMN_TRUE ) )
        {
            // encrypt Ȥ decrypt modify 쵵  ɼ
            // Ǵ  Ͽ recreate table Ѵ.

            // )
            // char -> echar
            // evarchar -> varchar

            // column option 
            sModifyColumn->flag &= ~QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK;
            sModifyColumn->flag |= QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE;
        }
        else
        {
            // Nothing to do.
        }

        sParseColumn = sParseColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    if ( ( sParseTree->tableInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLSrcInfo( aStatement,
                            ID_FALSE,
                            1,
                            &(sParseTree->tableInfo->tableOID),
                            0,
                            NULL );
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_EXIST_NOT_NULL );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_EXIST_NOT_NULL));
    }
    IDE_EXCEPTION( ERR_NOT_EXIST_NOT_NULL );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_EXIST_NOT_NULL));
    }
    IDE_EXCEPTION( ERR_NOT_ALLOWED_DROP_NOT_NULL );
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_ALLOWED_DROP_NOT_NULL));
    }
    IDE_EXCEPTION(ERR_NOT_ALLOWED_ENCRYPTED_COLUMN_ACCESS)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_NOT_ALLOWED_ENCRYPTED_COLUMN_ACCESS));
    }
    IDE_EXCEPTION( ERR_ABORT_QDB_INVALID_MODIFICATION )
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_MODIFICATION,
                                sqlInfo.getErrMessage()));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_MODIFY_COLUMN_HAVING_CHECK_CONSTRAINT );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_NOT_ALLOWED_COLUMN_HAVING_CHECK_CONSTRAINT,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_MODIFY_HIDDEN_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_HIDDEN_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    // PROJ-2264 Dictionary table
    IDE_EXCEPTION( ERR_MODIFY_COMPRESSION_COLUMN );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_ALTER_COMPRESSION_COLUMN,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    /* PROJ-2464 hybrid partitioned table  */
    IDE_EXCEPTION( ERR_UNSUPPORT_ON_HYBRID_PARTITIONED_TABLE );
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_SUPPORT_ON_HYBRID_PARTITIONED_TABLE ) );
    }
    IDE_EXCEPTION( ERR_DDL_WITH_REPLICATED_TABLE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_WITH_REPLICATED_TBL ) );
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::executeModifyCol( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description : PROJ-1877
 *    ALTER TABLE ... MODIFY COLUMN ...;
 *
 * Implementation :
 *    1. modify method  - 1ܰ
 *       table schema modify method Ѵ.
 *       a. method 1: alter meta
 *       b. method 2: alter meta and index
 *       c. method 3: recreate table
 *
 *    2. modify method  - 2ܰ
 *       table scan column value Ȯϰ
 *       modify method  Ѵ.
 *
 *    3. modify method 
 *
 *    type ȯ data loss ɼ ϴ   ٸ type
 *    ȯ ϴ. ̴ data loss  ǽð detect 
 *      ߰ ̴. ̰    ִ.
 *      a. data loss  ߻ ڴ   .
 *      b. column unique index, uk, pk   type ȯ
 *         data loss  index  ҰϿ DDL   ִ.
 *
 ***********************************************************************/

    qdTableParseTree      * sParseTree;
    qcmPartitionInfoList  * sPartInfoList;
    qcmPartitionInfoList  * sOldPartInfoList = NULL;
    qcmPartitionInfoList  * sNewPartInfoList = NULL;
    qcmTableInfo          * sPartInfo;
    UInt                    sPartCount = 0;
    qdTblColModifyMethod    sMethod;      // for non-partitioned table
    qdTblColModifyMethod  * sPartMethod;  // for partitioned table
    qdVerifyColumn        * sVerifyColumn;
    qcmTableInfo          * sOldTableInfo = NULL;
    qcmTableInfo          * sNewTableInfo = NULL;
    qcmTableInfo         ** sNewPartInfo = NULL;
    qcmColumn             * sColumn;
    qdIndexTableList      * sIndexTable;
    qdIndexTableList      * sDelIndexTables = NULL;
    smOID                 * sOldPartitionOID = NULL;
    UInt                    sOldPartitionCount = 0;
    smOID                   sOldTableOID = 0;
    smOID                   sNewTableOID = 0;
    idBool                  sIsReplicatedTable = ID_FALSE;
    smOID                 * sOldTableOIDArray = NULL;
    smOID                 * sNewTableOIDArray = NULL;
    UInt                    sTableOIDCount = 0;
    UInt                    sDDLSupplementalLog = QCU_DDL_SUPPLEMENTAL_LOG;
    idBool                  sCheckReplication = ID_FALSE;

    sParseTree    = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDU_FIT_POINT( "qdbAlter::executeModifyCol::beforeXLock" );

    // TASK-2176
    // Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sOldTableInfo = sParseTree->tableInfo;
    sOldTableOID = smiGetTableId( sOldTableInfo->tableHandle );

    // PROJ-1407 Temporary table
    // session temporary table ϴ  DDL   .
    IDE_TEST_RAISE( qcuTemporaryObj::existSessionTable( sOldTableInfo ) == ID_TRUE,
                    ERR_SESSION_TEMPORARY_TABLE_EXIST );

    // Partitioned Table  Partition  Lock ȹѴ.
    if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        /* BUG-42681 valgrind split  add column ü  */
        IDE_TEST( qcmPartition::checkPartitionCount4Execute( aStatement,
                                                             sParseTree->partTable->partInfoList,
                                                             sOldTableInfo->tableID )
                  != IDE_SUCCESS );

        //  Ƽǿ LOCK(X)
        IDE_TEST( qcmPartition::validateAndLockPartitionInfoList( aStatement,
                                                                  sParseTree->partTable->partInfoList,
                                                                  SMI_TBSLV_DDL_DML, // TBS Validation ɼ
                                                                  SMI_TABLE_LOCK_X,
                                                                  smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );
        
        //  ó Ͽ, Lock  Ŀ Partition List Ѵ.
        sOldPartInfoList = sParseTree->partTable->partInfoList;

        // PROJ-1624 non-partitioned index
        IDE_TEST( qdx::validateAndLockIndexTableList( aStatement,
                                                      sParseTree->oldIndexTables,
                                                      SMI_TBSLV_DDL_DML,
                                                      SMI_TABLE_LOCK_X,
                                                      smiGetDDLLockTimeOut((QC_SMI_STMT(aStatement))->getTrans()))
                  != IDE_SUCCESS );

        if ( ( sOldTableInfo->replicationCount > 0 ) ||
             ( sDDLSupplementalLog == 1 ) )
        {
            IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                        sOldPartInfoList,
                                                        &sOldPartitionOID,
                                                        &sOldPartitionCount )
                      != IDE_SUCCESS );
        }
        else
        {
            /* do nothing */
        }
    }
    else
    {
        // Nothing to do.
    }

    // PROJ-2642 Table on Replication Allow DDL
    if ( sOldTableInfo->replicationCount > 0 )
    {
        sCheckReplication = ID_FALSE;
        sColumn = sParseTree->modifyColumns;
        while ( sColumn != NULL )
        {
            /* primaryKey   Ұ */
            IDE_TEST_RAISE( qdn::intersectColumn( 
                    (UInt*)smiGetIndexColumns( sParseTree->tableInfo->primaryKey->indexHandle ),
                    sParseTree->tableInfo->primaryKey->keyColCount,
                    &(sColumn->basicInfo->column.id),
                    1 ) == ID_TRUE, ERR_MODIFY_COLUMN_IN_PRIMARY_KEY );

            if ( ( ( sColumn->flag & QCM_COLUMN_MODIFY_DATA_TYPE_MASK ) 
                   == QCM_COLUMN_MODIFY_DATA_TYPE_FALSE ) &&
                 ( ( sColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK ) 
                   == QCM_COLUMN_MODIFY_NULLABLE_NONE ) &&
                 ( sColumn->defaultValue != NULL ) &&
                 ( sCheckReplication == ID_FALSE ) )
            {
                /* do nothing */
            }
            else
            {
                /* ȭ  ̺   ÷  Ұ */
                IDE_TEST_RAISE( (sColumn->flag & QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK)
                                == QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE,
                                ERR_MODIFY_COLUMN_TO_ENCRYPT );

                sCheckReplication = ID_TRUE;
            }

            sColumn = sColumn->next;
        }

        if ( sCheckReplication == ID_TRUE )
        {
            IDE_TEST( qci::mManageReplicationCallback.mIsDDLEnableOnReplicatedTable( 1,
                                                                                     sOldTableInfo )
                      != IDE_SUCCESS );

            IDE_TEST_RAISE( QC_SMI_STMT( aStatement )->getTrans()->getReplicationMode() == SMI_TRANSACTION_REPL_NONE,
                            ERR_CANNOT_WRITE_REPL_INFO );

            if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
            {
                sOldTableOIDArray = sOldPartitionOID;
                sTableOIDCount = sOldPartitionCount;
            }
            else
            {
                sOldTableOIDArray = &sOldTableOID;
                sTableOIDCount = 1;
            }

            IDE_TEST( qciMisc::checkRunningEagerReplicationByTableOID( aStatement,
                                                                       sOldTableOIDArray,
                                                                       sTableOIDCount )
                      != IDE_SUCCESS );

            IDE_TEST( qci::mManageReplicationCallback.mStopReceiverThreads( QC_SMI_STMT(aStatement),
                                                                            aStatement->mStatistics,
                                                                            sOldTableOIDArray,
                                                                            sTableOIDCount )
                      != IDE_SUCCESS );

            sIsReplicatedTable = ID_TRUE;
        }
        else
        {
            /* do nothing */
        }
    }
    else
    {
        /* do nothing */
    }

    // BUG-43292 DDL / DDL partiton  ֽ viewSCN  
    IDE_TEST( smiStatement::setViewSCNOfAllStmt( QC_SMI_STMT( aStatement ) )
              != IDE_SUCCESS );

    //-----------------------------------------
    // modify method  - 1ܰ
    //-----------------------------------------
    if ( ( smiTableSpace::isMemTableSpaceType( sParseTree->tableInfo->TBSType )
           == ID_TRUE ) ||
         ( smiTableSpace::isVolatileTableSpaceType( sParseTree->tableInfo->TBSType )
           == ID_TRUE ) )
    {
        // modify schema modify method 
        IDE_TEST( decideModifyMethodForMemory( aStatement,
                                               sParseTree->columns,
                                               sParseTree->modifyColumns,
                                               & sMethod,
                                               & sVerifyColumn )
                  != IDE_SUCCESS );
    }
    else
    {
        IDE_DASSERT( smiTableSpace::isDiskTableSpaceType(
                         sParseTree->tableInfo->TBSType )
                     == ID_TRUE );
        
        // modify schema modify method 
        IDE_TEST( decideModifyMethodForDisk( aStatement,
                                             sParseTree->columns,
                                             sParseTree->modifyColumns,
                                             & sMethod,
                                             & sVerifyColumn )
                  != IDE_SUCCESS );
    }

        if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            // partitioned table   partition Ͽ
            //  ٸ modify method   ִ.

            // sPartMethod sMethod ʱȭѴ.
            sPartCount = 0;

            for( sPartInfoList = sOldPartInfoList;
                 sPartInfoList != NULL;
                 sPartInfoList = sPartInfoList->next )
            {
                sPartCount++;
            }

            IDE_DASSERT( sPartCount > 0 );

            IDU_LIMITPOINT( "qdbAlter::executeModifyCol::malloc1");
            IDE_TEST( aStatement->qmxMem->alloc(
                    ID_SIZEOF(qdTblColModifyMethod) * sPartCount,
                    (void**) & sPartMethod )
                != IDE_SUCCESS);

            // null ʱȭѴ.
            IDU_LIMITPOINT( "qdbAlter::executeModifyCol::malloc2");
            IDE_TEST( aStatement->qmxMem->cralloc(
                    ID_SIZEOF(qcmTableInfo*) * sPartCount,
                    (void**) & sNewPartInfo )
                != IDE_SUCCESS);

            sPartCount = 0;

            for( sPartInfoList = sOldPartInfoList;
                 sPartInfoList != NULL;
                 sPartInfoList = sPartInfoList->next )
            {
                sPartMethod[sPartCount] = sMethod;

                sPartCount++;
            }

    }
    else
    {
        /* Nothing To Do */
    }

    //-----------------------------------------
    // modify method  - 2ܰ
    //-----------------------------------------
    if ( ( smiTableSpace::isMemTableSpaceType( sParseTree->tableInfo->TBSType )
           == ID_TRUE ) ||
         ( smiTableSpace::isVolatileTableSpaceType( sParseTree->tableInfo->TBSType )
           == ID_TRUE ) )
    {
        if ( sVerifyColumn != NULL )
        {
            // memory table column о modify  ˻
            // memory table ׻ recreate̹Ƿ  modify method  ʴ´.
            IDE_TEST( verifyColumnValue( aStatement,
                                         sParseTree->tableInfo,
                                         sVerifyColumn,
                                         & sMethod )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // PROJ-2334 PMT
        // partitioned table modify method  - 2ܰ
        // memory table column  ߻ ϸ ׻ recreate
        // not null, default   ÿ meta modify .
        // Ʒ verifyColumnValue Ƽǿ  ó ϰ
        // Ƽǵ ̺ method   ȴ.
        //-----------------------------------------
        if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {    
            if ( sVerifyColumn != NULL )
            {
                // partition column о modify  ˻ϰ
                //  modify method 
                sPartCount = 0;

                for ( sPartInfoList = sOldPartInfoList;
                      sPartInfoList != NULL;
                      sPartInfoList = sPartInfoList->next )
                {
                    IDE_TEST( verifyColumnValue(
                                  aStatement,
                                  sPartInfoList->partitionInfo,
                                  sVerifyColumn,
                                  & sPartMethod[sPartCount] )
                              != IDE_SUCCESS );

                    sPartCount++;
                }
            }
            else
            {
                // Nothing to do.
            }
        }
        else
        {
            /* Nothing To Do */
        }
        
        //-----------------------------------------
        // modify method 
        // partitioned table 쿡 base table method  
        //  ȴ.
        //  memory table column ׻ recreateǱ ̴.
        //-----------------------------------------

        switch ( sMethod )
        {
            case QD_TBL_COL_MODIFY_METHOD_NONE:

                // ƹ͵  ʴ´.
                break;

            case QD_TBL_COL_MODIFY_METHOD_ALTER_META:
                
                // meta 游 alter table modify column ɼ
                IDE_TEST( alterMetaForMemory( aStatement,
                                              sParseTree,
                                              & sNewTableInfo,
                                              sNewPartInfo )
                          != IDE_SUCCESS );
                break;

            case QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE:

                // table  alter table modify column ɼ
                IDE_TEST( recreateTableForMemory( aStatement,
                                                  sParseTree,
                                                  & sNewTableInfo,
                                                  sNewPartInfo )
                          != IDE_SUCCESS );
                break;

            default:
                IDE_DASSERT( 0 );
        }
    }
    else
    {
        if ( sParseTree->tableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            if ( sVerifyColumn != NULL )
            {
                // partition column о modify  ˻ϰ
                //  modify method 
                sPartCount = 0;

                for( sPartInfoList = sOldPartInfoList;
                     sPartInfoList != NULL;
                     sPartInfoList = sPartInfoList->next )
                {
                    IDE_TEST( verifyColumnValue(
                                  aStatement,
                                  sPartInfoList->partitionInfo,
                                  sVerifyColumn,
                                  & sPartMethod[sPartCount] )
                              != IDE_SUCCESS );

                    sPartCount++;
                }
            }
            else
            {
                // Nothing to do.
            }

            //-----------------------------------------
            // modify method 
            //-----------------------------------------

            // meta 游 alter table modify column ɼ
            IDE_TEST( alterMetaForDisk( aStatement,
                                        sParseTree,
                                        & sNewTableInfo,
                                        sNewPartInfo )
                      != IDE_SUCCESS );

            // partition modify method Ѵ.
            sPartCount = 0;

            for( sPartInfoList = sOldPartInfoList;
                 sPartInfoList != NULL;
                 sPartInfoList = sPartInfoList->next )
            {
                sPartInfo = sPartInfoList->partitionInfo;

                switch ( sPartMethod[sPartCount] )
                {
                    case QD_TBL_COL_MODIFY_METHOD_NONE:
                        //PROJ-2399 rowTemplate
                        IDE_TEST( smiTable::modifyRowTemplate( QC_SMI_STMT( aStatement ), 
                                                               sPartInfo->tableHandle )
                                  != IDE_SUCCESS );                        
                        break;

                    case QD_TBL_COL_MODIFY_METHOD_ALTER_META:
                        //PROJ-2399 rowTemplate
                        IDE_TEST( smiTable::modifyRowTemplate( QC_SMI_STMT( aStatement ), 
                                                               sPartInfo->tableHandle )
                                  != IDE_SUCCESS );                        

                        // column  meta   Ͽ,
                        // index ϸ index column 
                        // ϵ Ѵ.

                        if ( sPartInfo->indexCount > 0 )
                        {
                            // PROJ-1911
                            // index  index 
                            IDE_TEST(
                                modifyIndexColumnInfo(
                                    aStatement,
                                    sVerifyColumn,
                                    ID_TRUE, // partitioned table partition
                                    & sNewPartInfo[sPartCount] )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // nothing to do
                        }

                        break;

                    case QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE:

                        // table  alter table modify column
                        // ɼ
                        IDE_TEST( recreateTableForDisk( aStatement,
                                                        sParseTree,
                                                        & sNewTableInfo,
                                                        sPartInfo,
                                                        sNewPartInfo,
                                                        sPartCount )
                                  != IDE_SUCCESS );
                        break;

                    default:
                        IDE_DASSERT( 0 );
                }

                sPartCount++;
            }

            // PROJ-1624 non-partitioned index
            // partitioned table index ׻ Ѵ.
            IDE_TEST( recreateIndexColumnInfo( aStatement,
                                               sParseTree->modifyColumns,
                                               & sNewTableInfo,
                                               sParseTree->oldIndexTables,
                                               & sParseTree->newIndexTables,
                                               & sDelIndexTables )
                      != IDE_SUCCESS );
        }
        else
        {
            // non-partitioned table

            //-----------------------------------------
            // modify method  - 2ܰ
            //-----------------------------------------

            if ( sVerifyColumn != NULL )
            {
                // disk table column о modify  ˻ϰ
                //  modify method 
                IDE_TEST( verifyColumnValue(
                              aStatement,
                              sParseTree->tableInfo,
                              sVerifyColumn,
                              & sMethod )
                          != IDE_SUCCESS );
            }
            else
            {
                // Nothing to do.
            }

            //-----------------------------------------
            // modify method 
            //-----------------------------------------

            // meta 游 alter table modify column ɼ
            IDE_TEST( alterMetaForDisk( aStatement,
                                        sParseTree,
                                        & sNewTableInfo,
                                        NULL )
                      != IDE_SUCCESS );

            switch ( sMethod )
            {
                case QD_TBL_COL_MODIFY_METHOD_NONE:
                    // PROJ-2399 rowTemplate 
                    IDE_TEST( smiTable::modifyRowTemplate( QC_SMI_STMT( aStatement ), 
                                                           sParseTree->tableInfo->tableHandle )
                              != IDE_SUCCESS );                        
                    break;

                case QD_TBL_COL_MODIFY_METHOD_ALTER_META:
                    //PROJ-2399 rowTemplate
                    IDE_TEST( smiTable::modifyRowTemplate( QC_SMI_STMT( aStatement ), 
                                                           sParseTree->tableInfo->tableHandle )
                              != IDE_SUCCESS );                        

                    // column  meta   Ͽ,
                    // index ϸ index column 
                    // ϵ Ѵ.

                    if ( sNewTableInfo->indexCount > 0 )
                    {
                        // PROJ-1911
                        // index  index 
                        IDE_TEST(
                            modifyIndexColumnInfo(
                                aStatement,
                                sVerifyColumn,
                                ID_FALSE, // partitioned table ƴ
                                & sNewTableInfo )
                            != IDE_SUCCESS );
                    }
                    else
                    {
                        // nothing to do
                    }

                    break;

                case QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE:

                    // table  alter table modify column ɼ
                    IDE_TEST( recreateTableForDisk( aStatement,
                                                    sParseTree,
                                                    & sNewTableInfo,
                                                    NULL,
                                                    NULL,
                                                    0 )
                              != IDE_SUCCESS );
                    break;

                default:
                    IDE_DASSERT( 0 );
            }
        }
    }

    //-----------------------------------------
    // Ÿ  ۾
    //-----------------------------------------
    // BUG-48036
    /* PROJ-2197 PSM Renewal */
    // related PSM
    IDE_TEST(qcmProc::relSetInvalidProcOfRelated(
        aStatement,
        sParseTree->userID,
        sParseTree->tableInfo->name,
        idlOS::strlen((SChar*)sParseTree->tableInfo->name),
        QS_TABLE) != IDE_SUCCESS);

    // PROJ-1073 Package
    IDE_TEST(qcmPkg::relSetInvalidPkgOfRelated(
            aStatement,
            sParseTree->userID,
            sParseTree->tableInfo->name,
            idlOS::strlen((SChar*)sParseTree->tableInfo->name),
            QS_TABLE) != IDE_SUCCESS);

    if ( sNewTableInfo != NULL )
    {
        IDE_TEST( qcmView::setInvalidViewOfRelated(
                      aStatement,
                      sParseTree->userID,
                      sOldTableInfo->name,
                      idlOS::strlen((SChar*)sOldTableInfo->name),
                      QS_TABLE )
                  != IDE_SUCCESS );

        IDE_TEST( qcmView::recompileAndSetValidViewOfRelated(
                      aStatement,
                      sParseTree->userID,
                      sOldTableInfo->name,
                      idlOS::strlen((SChar*)sOldTableInfo->name),
                      QS_TABLE )
                  != IDE_SUCCESS );

        // BUG-16543
        IDE_TEST( qdnTrigger::setInvalidTriggerCache4Table( sOldTableInfo )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    IDU_FIT_POINT( "qdbAlter::executeModifyCol::BUG-44230" );

    // PROJ-2642 Table on Replication Allow DDL
    if ( ( sIsReplicatedTable == ID_TRUE ) ||
         ( sDDLSupplementalLog == 1 ) )
    {
        if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            sOldTableOIDArray = sOldPartitionOID;

            if ( sNewTableInfo != NULL )
            {
                IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                              QC_SMI_STMT(aStatement),
                                                              QC_QMX_MEM(aStatement),
                                                              sNewTableInfo->tableID,
                                                              &sNewPartInfoList )
                          != IDE_SUCCESS );

                IDE_TEST( qcmPartition::getAllPartitionOID( QC_QMX_MEM(aStatement),
                                                            sNewPartInfoList,
                                                            &sNewTableOIDArray,
                                                            &sTableOIDCount )
                          != IDE_SUCCESS );
            }
            else
            {
                sNewTableOIDArray = sOldPartitionOID;
            }
        }
        else
        {
            if ( sNewTableInfo != NULL )
            {
                sNewTableOID = smiGetTableId( sNewTableInfo->tableHandle );
            }
            else
            {
                sNewTableOID = sOldTableOID;
            }

            sOldTableOIDArray = &sOldTableOID;
            sNewTableOIDArray = &sNewTableOID;
            sTableOIDCount = 1;
        }

        if ( sIsReplicatedTable == ID_TRUE )
        {
            IDE_TEST( qci::mCatalogReplicationCallback.mUpdateReplMetaTableOIDArray( aStatement,
                                                                                     sOldTableOIDArray,
                                                                                     sNewTableOIDArray,
                                                                                     sTableOIDCount )
                      != IDE_SUCCESS);
        }
        else
        {
            /* do nothing */
        }

        IDE_TEST( qciMisc::writeTableMetaLogForReplication( aStatement,
                                                            sOldTableOIDArray,
                                                            sNewTableOIDArray,
                                                            sTableOIDCount )
                  != IDE_SUCCESS );
    }
    else
    {
        /* do nothing */
    }

    // PROJ-2002 Column Security
    //  ÷   ⿡ ˸.
    sColumn = sParseTree->modifyColumns;

    while ( sColumn != NULL )
    {
        if ( (sColumn->flag & QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_MASK)
             == QCM_COLUMN_MODIFY_ENCRYPT_COLUMN_TRUE )
        {
            (void) qcsModule::setColumnPolicy(
                sOldTableInfo->tableOwnerName,
                sOldTableInfo->name,
                sColumn->name,
                sColumn->basicInfo->mColumnAttr.mEncAttr.mPolicy );
        }
        else if ( (sColumn->flag & QCM_COLUMN_MODIFY_DECRYPT_COLUMN_MASK)
                  == QCM_COLUMN_MODIFY_DECRYPT_COLUMN_TRUE )
        {
            (void) qcsModule::unsetColumnPolicy(
                sOldTableInfo->tableOwnerName,
                sOldTableInfo->name,
                sColumn->name );
        }
        else
        {
            // Nothing to do.
        }

        sColumn = sColumn->next;
    }

    //-----------------------------------------
    // old cached meta 
    //-----------------------------------------

    if ( sNewTableInfo != NULL )
    {
        if ( ( sIsReplicatedTable == ID_TRUE ) ||
             ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
        {
            qrc::setDDLDestInfo( aStatement, 
                                 1,
                                 &(sNewTableInfo->tableOID),
                                 0,
                                 NULL );
        }

        // PROJ-1502 PARTITIONED DISK TABLE
        if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
        {
            (void)qcmPartition::destroyQcmPartitionInfoList( sOldPartInfoList );
            
            for ( sIndexTable = sDelIndexTables;
                  sIndexTable != NULL;
                  sIndexTable = sIndexTable->next )
            {
                (void)qcm::destroyQcmTableInfo(sIndexTable->tableInfo);
            }
        }
        else
        {
            // Nothing to do.
        }

        (void) qcm::destroyQcmTableInfo( sOldTableInfo );
    }
    else
    {
        if ( ( sIsReplicatedTable == ID_TRUE ) ||
             ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
        {
            qrc::setDDLDestInfo( aStatement, 
                                 1,
                                 &(sOldTableInfo->tableOID),
                                 0,
                                 NULL );
        }
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_MODIFY_COLUMN_IN_PRIMARY_KEY )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_NOT_SUPPORTED_REPLICATED_TABLE, 
                                  "Modify Column in primary Key" ) );
    }
    IDE_EXCEPTION( ERR_MODIFY_COLUMN_TO_ENCRYPT )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_DDL_NOT_SUPPORTED_REPLICATED_TABLE,
                                  "Modify Column to encrypt" ) );
    }
    IDE_EXCEPTION( ERR_SESSION_TEMPORARY_TABLE_EXIST )
    {
        IDE_SET(ideSetErrorCode( qpERR_ABORT_QDB_TEMPORARY_TABLE_DDL_DISABLE ));
    }
    IDE_EXCEPTION( ERR_CANNOT_WRITE_REPL_INFO )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_CANNOT_WRITE_REPL_INFO ) );
    }
    IDE_EXCEPTION_END;

    (void)qcm::destroyQcmTableInfo( sNewTableInfo );

    if ( sNewPartInfo != NULL )
    {
        sPartCount = 0;

        for( sPartInfoList = sOldPartInfoList;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next )
        {
            (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfo[sPartCount] );

            sPartCount++;
        }
    }
    else
    {
        /* Nothing to do */
    }
        
    for ( sIndexTable = sParseTree->newIndexTables;
          sIndexTable != NULL;
          sIndexTable = sIndexTable->next )
    {
        (void)qcm::destroyQcmTableInfo( sIndexTable->tableInfo );
    }

    qcmPartition::restoreTempInfo( sOldTableInfo,
                                   sOldPartInfoList,
                                   NULL );

    return IDE_FAILURE;
}

// PROJ-2264 Dictionary table
IDE_RC qdbAlter::executeReorganizeCol( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description : PROJ-1877
 *    ALTER TABLE ... REORGANIZE COLUMN ...;
 *
 * Implementation :
 *    1. New dictionary table 
 *    2. New data table 
 *      2-1. New data table 
 *      2-2. Old data table -> new data table  ڵ ̵
 *      2-3. Old data table 
 *    3. Meta table 
 *    4. New dictionary table 籸
 *    5. Old dictionary table 
 *    6. Old data table meta cache 
 *
 ***********************************************************************/

    qdTableParseTree      * sParseTree;
    qcmTableInfo          * sTableInfo = NULL;
    qcmColumn             * sColumn;
    qcmDictionaryTable    * sNewDicTable;
    qcmDictionaryTable    * sNewDicIter;
    smOID                 * sOldDicOID;
    smOID                   sNewDataOID;
    qcmTableInfo          * sDicInfo;
    qcmTableInfo          * sNewDataInfo = NULL;
    UInt                    sDicID;
    UInt                    sColCnt = 0;
    UInt                    i;
    UInt                    sStage = 0;

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    SInt           sCountDiskType = 0;
    SInt           sCountMemType  = 0;
    SInt           sCountVolType  = 0;
    UInt           sTableType     = 0;

    sParseTree      = (qdTableParseTree *)aStatement->myPlan->parseTree;
    sNewDicTable    = NULL;

    // TASK-2176
    // Data Table  Lock ȹѴ.
    IDE_TEST( qcm::validateAndLockTable( aStatement,
                                         sParseTree->tableHandle,
                                         sParseTree->tableSCN,
                                         SMI_TABLE_LOCK_X )
              != IDE_SUCCESS );

    sTableInfo      = sParseTree->tableInfo;

    // Backup old dictionary table OID
    // New dictionary table  ϸ smiColumn   mDictionaryTableOID  ŵȴ.
    //  old dictionary table  ϰ Ÿ ϱ  ̸ Ѵ.
    for( sColumn = sParseTree->columns; sColumn != NULL; sColumn = sColumn->next )
    {
        sColCnt++;
    }

    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(smOID) * sColCnt,
                                         (void**) &sOldDicOID )
              != IDE_SUCCESS );

    for( sColumn = sParseTree->columns, i = 0;
         sColumn != NULL;
         sColumn = sColumn->next, i++ )
    {
        sOldDicOID[i] = sColumn->basicInfo->column.mDictionaryTableOID;
    }

    //-----------------------------------------
    // 1. New dictionary table 
    //-----------------------------------------
    IDE_TEST( qcmDictionary::recreateDictionaryTable( aStatement,
                                                      sTableInfo,
                                                      sParseTree->columns,
                                                      sTableInfo->TBSID,
                                                      &sNewDicTable )
              != IDE_SUCCESS );

    sStage = 1;
 
    //-----------------------------------------
    // 2. New data table  
    //    ڵ ̵  old data table 
    //-----------------------------------------
    IDE_TEST( recreateTableForReorganize( aStatement,
                                          sParseTree,
                                          //sParseTree->columns, // reorganized columns
                                          &sNewDataOID,
                                          &sNewDataInfo )
              != IDE_SUCCESS );

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    sTableType = sTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    /* - Partition  ˻Ѵ. */
    qdbCommon::getTableTypeCountInPartInfoList( & sTableType,
                                                NULL,
                                                & sCountDiskType,
                                                & sCountMemType,
                                                & sCountVolType );

    /* - Memory ü ְų, Index Table ִٸ, Index  Ѵ. */
    if ( ( ( sCountMemType + sCountVolType ) > 0 ) ||
         ( sParseTree->oldIndexTables != NULL ) )
    {
        IDE_TEST( recreateIndexForReorganize ( aStatement,
                                               sParseTree,
                                               sNewDataOID,
                                               & sNewDataInfo )
                  != IDE_SUCCESS );
    }
    else
    {
        /* Nothing to do */
    }

    /* - ڵ带 moveRow Ѵ.
     *    recreateTableForReorganize Ե moveRow  ű.
     */
    /* BUG-20992: TC/Server/sm4/PRJ-1548/dynmem/../suites/conc_disk/dt_dt.sql 
     *
     * : Disk Table ؼ Alter Table Add, Drop Table ϰ Record
     * Insertϴٰ   Alter  Table Memory Refine Free Insert
     *  Record ؼ Disk Ager Startup Ŀ  Ѵ.   Disk Ager
     *  Table Drop Ǿ  Skip ϴµ   Free Table Ҵ 
     * Disk Ager Free Record մϴ. ᱹ ̹  Table ؼ Free ϰ
     * ˴ϴ.
     *
     * ذ: ̷  ϱ ؼ ¥ Alter ϸ  Table Drop 
     *   Undo Log  ν Ager Record Freeϴ   մϴ.
     * moverowÿ undo log ϵ ʵ մϴ. ׷  ̷ ϴٺ Index
     * Key Insert ʴ  ֽϴ. ֳĸ Index Key Insert insert  
     * table ڵ带 Insert Insert  Cursor Closeÿ Insert Undo Record
     * о Table Record Insertմϴ. ׷ Insert Undo Record ϵ ʾұ 
     *  Insert  ʾƼ Alterÿ moverows    Index Key Insertϴ
     *  Logic Ͽϴ.
     *
     * : Alter Table Add Column  ο Table ϰ Insertÿ ο Table
     * Record Ŀ Index ؾ մϴ.
     * */
    /* move row from old to new. drop old non-partitioned table */
    IDE_TEST( moveRow( aStatement,
                       NULL,
                       sTableInfo,
                       sTableInfo->tableHandle,
                       smiGetTable( sNewDataOID ),
                       sTableInfo->columns,
                       sNewDataInfo->columns, /* sOldTableInfo->columns, aNewTableColumn, */
                       NULL,
                       NULL,
                       ID_FALSE /* No Undo Logging */ )
              != IDE_SUCCESS );

    //-----------------------------------------
    // 3. New dictionary table 籸
    //-----------------------------------------
    // Data table   о 鼭 new dictionary table  籸Ѵ.
    IDE_TEST( qcmDictionary::rebuildDictionaryTable( aStatement,
                                                     sTableInfo,
                                                     sNewDataInfo,
                                                     sNewDicTable )
              != IDE_SUCCESS );

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT   
     *  - Memory ü , Index Table ٸ, Index  Ѵ.
     */
    if ( ( ( sCountMemType + sCountVolType ) == 0 ) &&
         ( sParseTree->oldIndexTables == NULL ) )
    {
        IDE_TEST( recreateIndexForReorganize ( aStatement,
                                               sParseTree,
                                               sNewDataOID,
                                               & sNewDataInfo )
                  != IDE_SUCCESS );

        IDU_FIT_POINT( "qdbAlter::executeReorganizeCol::BUG-44230-1" );
    }
    else
    {
        /* Nothing to do */
    }

    //-----------------------------------------
    // 4. SYS_COMPRESSION_TABLES_ 
    //-----------------------------------------
    for( sNewDicIter = sNewDicTable, i = 0;
         sNewDicIter != NULL;
         sNewDicIter = sNewDicIter->next, i++ )
    {
        sDicInfo = (qcmTableInfo *)smiGetTableRuntimeInfoFromTableOID( sOldDicOID[i] );
        sDicID = sDicInfo->tableID;

        IDE_TEST( qcmDictionary::updateCompressionTableSpecMeta( aStatement,
                                                                 sDicID,
                                                                 sNewDicIter->dictionaryTableInfo->tableID )
                  != IDE_SUCCESS );
    }

    /* BUG-44230 ADD, DROP, MODIFY, REORGANIZE DDL INDEX, CONSTRAINT    */
    IDU_FIT_POINT( "qdbAlter::executeReorganizeCol::BUG-44230-2" );

    //-----------------------------------------
    // 5. Old dictionary table 
    //-----------------------------------------
    sStage = 0;

    for( sNewDicIter = sNewDicTable, i = 0;
         sNewDicIter != NULL;
         sNewDicIter = sNewDicIter->next, i++ )
    {
        sDicInfo = (qcmTableInfo *)smiGetTableRuntimeInfoFromTableOID( sOldDicOID[i] );

        // Drop old dictionary table
        // BUG-36719
        // ⼭ ϸ ǵ  .
        // ϴ old dictionary table   ̰,
        // Reorganize ۾ ü ߱  old dictionary table 
        //   ó  ʴ´.
        (void) qcmDictionary::removeDictionaryTableWithInfo( aStatement,
                                                             sDicInfo );

        // Table info  Ѵ.
        (void)qcm::destroyQcmTableInfo(sDicInfo);
    }

    //-----------------------------------------
    // 6. Old data table meta cache 
    //-----------------------------------------
    (void)qcm::destroyQcmTableInfo( sTableInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    if( sStage == 1 )
    {
        for( sNewDicIter = sNewDicTable;
             sNewDicIter != NULL;
             sNewDicIter = sNewDicIter->next )
        {
            // BUG-36719
            // Dictionary table  Ÿ̺ ѹǾ  ̴.
            // ⼭ table info  Ѵ.
            (void)qcm::destroyQcmTableInfo( sNewDicIter->dictionaryTableInfo );
        }
    }

    (void)qcm::destroyQcmTableInfo( sNewDataInfo );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::executeAccessPartition( qcStatement * aStatement )
{
/***********************************************************************
 *
 * Description :
 *    PROJ-2359 Table/Partition Access Option
 *
 *    ALTER TABLE table ACCESS PARTITION partition READ { ONLY | WRITE | APPEND };
 *
 * Implementation :
 *
 ***********************************************************************/

    qdTableParseTree        * sParseTree;
    qcmTableInfo            * sTableInfo     = NULL;
    qcmTableInfo            * sPartInfo      = NULL;
    qdPartitionAttribute    * sPartAttr;

    qcmTableInfo            * sNewPartInfo   = NULL;
    void                    * sNewPartHandle = NULL;
    smSCN                     sNewSCN        = SM_SCN_INIT;

    sParseTree = (qdTableParseTree *)aStatement->myPlan->parseTree;

    // Ƽǵ ̺ LOCK(IX)
    // Ƽǿ LOCK(X)
    IDE_TEST( qcmPartition::validateAndLockTableAndPartitions(
                    aStatement,
                    sParseTree->tableHandle,
                    sParseTree->tableSCN,
                    sParseTree->partTable->partInfoList,
                    SMI_TABLE_LOCK_IX,
                    ID_FALSE ) //aIsSetViewSCN
              != IDE_SUCCESS );

    sTableInfo = sParseTree->tableInfo;

    sPartInfo = sParseTree->partTable->partInfoList->partitionInfo;
    sPartAttr = sParseTree->partTable->partAttr;

    // Ƽ ACCESS Ʈ
    IDE_TEST( updatePartAccessOfTablePartMeta(
                    aStatement,
                    sPartInfo->partitionID,
                    sPartAttr->accessOption )
              != IDE_SUCCESS );

    // To fix BUG-17547
    IDE_TEST( qcmPartition::touchPartition(
                    QC_SMI_STMT( aStatement ),
                    sPartInfo->partitionID )
              != IDE_SUCCESS );

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  sParseTree->userName,
                  sParseTree->tableName,
                  sTableInfo->tableID,
                  smiGetTableId( sTableInfo->tableHandle ),
                  sTableInfo->columnCount,
                  sTableInfo->parallelDegree)
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                  QC_SMI_STMT( aStatement ),
                  sPartInfo->partitionID,
                  smiGetTableId( sPartInfo->tableHandle ),
                  sTableInfo,
                  NULL )
              != IDE_SUCCESS );

    IDE_TEST( qcmPartition::getPartitionInfo( aStatement,
                                              sTableInfo->tableID,
                                              (UChar *)sPartInfo->name,
                                              (SInt)idlOS::strlen( sPartInfo->name ),
                                              & sNewPartInfo,
                                              & sNewSCN,
                                              & sNewPartHandle )
              != IDE_SUCCESS );

    if ( ( sPartInfo->replicationCount > 0 ) ||
         ( QCG_GET_SESSION_IS_NEED_DDL_INFO( aStatement ) == ID_TRUE ) )
    {
        qrc::setDDLDestInfo( aStatement, 
                             1,
                             &(sTableInfo->tableOID),
                             1,
                             &(sNewPartInfo->tableOID) );
    }

    // Ÿ ĳ 
    (void)qcmPartition::destroyQcmPartitionInfo( sPartInfo );

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    (void)qcmPartition::destroyQcmPartitionInfo( sNewPartInfo );

    qcmPartition::restoreTempInfoForPartition( sTableInfo,
                                               sPartInfo );

    return IDE_FAILURE;
}

IDE_RC qdbAlter::decideModifyMethodForMemory(
    qcStatement           * aStatement,
    qcmColumn             * aTableColumns,
    qcmColumn             * aModifyColumns,
    qdTblColModifyMethod  * aMethod,
    qdVerifyColumn       ** aVerifyColumn )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *    memory table  modify column modify method 
 *
 * Implementation :
 *
 *    Table  column Ͽ  Ѵ
 *    (1) default value  , modify method 
 *    (2) (not) null  , modify method 
 *    (3) column option  , modify method 
 *    (4) type length  , modify method 
 *        - padding type -> non-padding type ȯ length 
 *        - non-padding type -> padding type ȯ length 
 *        - float->numeric type ȯ length 
 *        - numeric->flat type ȯ length 
 *    (5) length     , modify method 
 *        ex) char -> integer
 *    (6) type  length  , modify method 
 *        - non-padding type length 
 *        - padding type type length 
 *        - numeric length 
 *        - flaot length 
 *        - geometry  length 
 *
 *      , modify schema modify method ȴ.
 *
 ***********************************************************************/

    qdTblColModifyMethod    sMethod = QD_TBL_COL_MODIFY_METHOD_NONE;
    qcmColumn             * sTableColumn;
    qcmColumn             * sModifyColumn;
    mtcColumn             * sTableColumnInfo;
    mtcColumn             * sModifyColumnInfo;
    qdVerifyColumn        * sVerifyColumn = NULL;
    idBool                  sIsDataLoss   = ID_FALSE;

    sTableColumn  = aTableColumns;
    sModifyColumn = aModifyColumns;

    while ( sTableColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        sTableColumnInfo = sTableColumn->basicInfo;
        sModifyColumnInfo = sModifyColumn->basicInfo;

        //-----------------------------------------
        // (1) default value  , modify method 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DEFAULT_MASK)
             == QCM_COLUMN_MODIFY_DEFAULT_TRUE )
        {
            IDE_TEST( qdbCommon::convertDefaultValueType(
                          aStatement,
                          & sModifyColumnInfo->type,
                          sModifyColumn->defaultValue,
                          NULL )
                      != IDE_SUCCESS );

            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (2) (not) null  , modify method 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
             == QCM_COLUMN_MODIFY_NULLABLE_NULL )
        {
            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                  == QCM_COLUMN_MODIFY_NULLABLE_NOTNULL )
        {
            // sTableColumn null value  ˻ؾ
            // null  ,  

            // verifyColumn 
            IDE_TEST( addVerifyColumn( aStatement,
                                       sTableColumn,
                                       QD_VERIFY_NOT_NULL,
                                       0,
                                       0,
                                       0,
                                       QD_CHANGE_STORED_TYPE_NONE,
                                       & sVerifyColumn )
                      != IDE_SUCCESS );

            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (2) srid  , modify method 
        //-----------------------------------------

        if ( ( sModifyColumn->flag & QCM_COLUMN_MODIFY_SRID_MASK )
             == QCM_COLUMN_MODIFY_SRID_TRUE )
        {
            // sTableColumn srid ƴ value  ˻ؾ
            // srid ƴ value  ,  

            // verifyColumn 
            IDE_TEST( addVerifyColumn( aStatement,
                                       sTableColumn,
                                       QD_VERIFY_SRID,
                                       0,
                                       sModifyColumnInfo->mColumnAttr.mSridAttr.mSrid,
                                       0,
                                       QD_CHANGE_STORED_TYPE_NONE,
                                       & sVerifyColumn )
                      != IDE_SUCCESS );

            // rebuild meta
            if ( sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META )
            {
                // Nothing To Do
            }
            else
            {
                sMethod = QD_TBL_COL_MODIFY_METHOD_ALTER_META;
            }
        }
        else
        {
            // Nothing to do.
        }
        
        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK)
             == QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE )
        {
            //-----------------------------------------
            // (3) column option  , modify method 
            //-----------------------------------------

            // recreate
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
        }
        else
        {
            // Nothing to do
        }

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_TYPE_MASK)
             == QCM_COLUMN_MODIFY_TYPE_TRUE )
        {
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
                 == QCM_COLUMN_MODIFY_LENGTH_TRUE )
            {
                //-----------------------------------------
                // (4) type length  , modify method 
                //
                // Ʒ  8 case 
                // nchar->nvarchar
                // nvarchar->nchar
                // char->varchar
                // varchar->char
                // bit->varbit
                // varbit->bit
                // float->numeric
                // numeric->float
                //-----------------------------------------

                if ( (sTableColumnInfo->module->id == MTD_NCHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_CHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_BIT_ID) )
                {
                    //--------------------
                    // padding type -> non-padding type ȯ length 
                    // Ʒ 3 case 
                    // nchar->nvarchar
                    // char->varchar
                    // bit->varbit
                    //--------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // length  ų Ȯ
                        // recreate table
                        // )
                        // char(3)->varchar(3)
                        // bit(3)->varbit(5)
                    }
                    else
                    {
                        // length 
                        // sTableColumn value  null ƴϸ 
                        // )
                        // char(3)->varchar(1)

                        // sTableColumn  value null ,
                        //   recreate table
                        // ׿ ,
                        //   error

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_NONE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                }
                else if ( (sTableColumnInfo->module->id ==
                           MTD_NVARCHAR_ID) ||
                          (sTableColumnInfo->module->id ==
                           MTD_VARCHAR_ID) ||
                          (sTableColumnInfo->module->id ==
                           MTD_VARBIT_ID) )
                {
                    //--------------------
                    // non-padding type -> padding type ȯ length 
                    // Ʒ 3 case 
                    // nvarchar->nchar
                    // varchar->char
                    // varbit->bit
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // recreate table
                        // )
                        // nvarchar(4)->nchar(4)
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // recreate table
                        // )
                        // varbit(4)->bit(6)
                    }
                    else
                    {
                        // length 
                        // )
                        // varchar(4)->char(3)
                        // sTableColumn value   length
                        // sModifyColumn length ū  ϸ
                        // DDL   .

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length  ,
                        //    recreate table
                        // sTableColumn  value length
                        // Ϸ length  ,
                        //    recreate table
                        // ׿ ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_EXACT_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_NONE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_FLOAT_ID )
                {
                    //--------------------
                    // float->numeric type length 
                    //
                    // )
                    // float(8)->numeric(10,2)
                    // float(8)->numeric(5)
                    //--------------------

                    // float->numeric  schemaδ length Ȯ
                    //  Ǵ  .
                    // data loss ɼ  numeric length Ҵ Ұ
                    // ϴ.
                    if ( (sModifyColumn->flag &
                          QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                         == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                    {
                        // data loss ɼ   ,
                        // sTableColumn value sModifyColumn
                        // length ũٸ DDL   .

                        // sTableColumn  value length
                        // sModifyColumn length  ۰ų  ,
                        //    recreate table
                        // ׿ ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                sModifyColumnInfo->scale,
                                QD_CHANGE_STORED_TYPE_NONE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_NUMERIC_ID )
                {
                    //--------------------
                    // numeric->flat type length 
                    //--------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // )
                        // numeric(10,2)->float(10)
                    }
                    else
                    {
                        // )
                        // numeric(5)->float(3)

                        // data loss ɼ  numeric length Ҵ
                        // Ұϴ.
                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   ,
                            // sTableColumn value sModifyColumn
                            // length ũٸ DDL   .

                            // sTableColumn  value NULL̰ų
                            // sModifyColumn length  ۰ų 
                            //    recreate table
                            // ׿ ,
                            //    error

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    ID_SINT_MAX,  // scale 
                                    QD_CHANGE_STORED_TYPE_NONE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // Nothing to do.
                        }
                    }
                }
                else
                {
                    IDE_DASSERT( 0 );
                }
            }
            else
            {
                //-----------------------------------------
                // (5) length      ,
                //     modify method 
                //
                // Ʒ  2 case 
                // char->integer
                // varchar->date
                // )
                // char(4)->integer
                // varchar(8)->date
                //-----------------------------------------

                IDE_TEST( isDataLossConversion(
                              sTableColumnInfo->module->id,
                              sModifyColumnInfo->module->id,
                              & sIsDataLoss )
                          != IDE_SUCCESS );

                if ( ( sIsDataLoss == ID_TRUE ) &&
                     ( (sModifyColumn->flag &
                        QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                       == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE ) )
                {
                    // data loss ɼ   

                    // sTableColumn  value  null ,
                    //    recreate table
                    // ׿ ,
                    //    error

                    // BUG-28317
                    // value  NULL θ scan ʰ
                    // ˼ ִٸ   

                    // verifyColumn 
                    IDE_TEST( addVerifyColumn( aStatement,
                                               sTableColumn,
                                               QD_VERIFY_NULL,
                                               0,
                                               0,
                                               0,
                                               QD_CHANGE_STORED_TYPE_NONE,
                                               & sVerifyColumn )
                              != IDE_SUCCESS );
                }
                else
                {
                    // Nothing to do.
                }
            }

            // type  recreate table
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
        }
        else
        {
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
                 == QCM_COLUMN_MODIFY_LENGTH_TRUE )
            {
                //-----------------------------------------
                // (6) type  length  ,
                //     modify method 
                //
                // Ʒ  10 case 
                // nchar
                // nvarchar
                // char
                // varchar
                // bit
                // varbit
                // float
                // numeric
                // byte
                // nibble
                //-----------------------------------------

                if ( (sTableColumnInfo->module->id == MTD_NCHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_CHAR_ID)  ||
                     (sTableColumnInfo->module->id == MTD_BIT_ID)   ||
                     (sTableColumnInfo->module->id == MTD_BYTE_ID) )
                {
                    //--------------------
                    // padding type length 
                    // Ʒ 4 case 
                    // nchar, char, bit, byte
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // char(3)->char(3)

                        // none
                        // sMethod = QD_MODIFY_METHOD_NONE;
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // char(3)->char(5) length Ȯ

                        // recreate
                        sMethod =
                            sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                    else
                    {
                        // length 
                        // sTableColumn value  null ƴϸ 
                        // )
                        // char(3)->char(1) length 

                        // sTableColumn  value  null ,
                        //    recreate table
                        // ׿ ,
                        //    error

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn( aStatement,
                                             sTableColumn,
                                             QD_VERIFY_NULL,
                                             0,
                                             0,
                                             0,
                                             QD_CHANGE_STORED_TYPE_NONE,
                                             & sVerifyColumn )
                            != IDE_SUCCESS );

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                }
                else if ( (sTableColumnInfo->module->id == MTD_NVARCHAR_ID) ||
                          (sTableColumnInfo->module->id == MTD_VARCHAR_ID) ||
                          (sTableColumnInfo->module->id == MTD_VARBYTE_ID) ||
                          (sTableColumnInfo->module->id == MTD_VARBIT_ID) ||
                          (sTableColumnInfo->module->id == MTD_NIBBLE_ID) )
                {
                    //--------------------
                    // non-padding type length 
                    // Ʒ 4 case 
                    // nvarchar, varchar, varbit, nibble
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // varchar(5)->varchar(5)

                        // none
                        // sMethod = QD_MODIFY_METHOD_NONE;
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // varchar(5)->varchar(10) length Ȯ

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                    else
                    {
                        // length 
                        // sTableColumn value sModifyColumn
                        // length ũٸ DDL   .
                        // )
                        // varchar(5)->varchar(3) length 

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length  ų  ,
                        //    recreate table
                        // ׿ 
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_NONE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_FLOAT_ID )
                {
                    //--------------------
                    // float  length 
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // float(5)->float(5)

                        // none
                        // sMethod = QD_MODIFY_METHOD_NONE;
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // float(5)->float(10) length Ȯ

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                    else
                    {
                        // length 
                        // )
                        // float(5)->float(3) length 

                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   ,
                            // sTableColumn value sModifyColumn
                            // length ũٸ DDL   .

                            // sTableColumn  value null ̰ų
                            // sTableColumn  value length
                            // sModifyColumn length ۰ų 
                            //    recreate table
                            // ׿ ,
                            //    error

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    ID_SINT_MAX,  // scale 
                                    QD_CHANGE_STORED_TYPE_NONE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // Nothing to do
                        }

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_NUMERIC_ID )
                {
                    //--------------------
                    // numeric  length 
                    //--------------------

                    if ( ( sTableColumnInfo->precision ==
                           sModifyColumnInfo->precision ) &&
                         ( sTableColumnInfo->scale ==
                           sModifyColumnInfo->scale ) )
                    {
                        // length  
                        // )
                        // numeric(10,2)->numeric(10,2)
                        // numeric(10,0)->numeric(10)

                        // none
                        // sMethod = QD_MODIFY_METHOD_NONE;
                    }
                    else if ( isEnlargingLengthForNumericType(
                                  sTableColumnInfo->precision,
                                  sTableColumnInfo->scale,
                                  sModifyColumnInfo->precision,
                                  sModifyColumnInfo->scale )
                              == ID_TRUE )
                    {
                        // length Ȯ
                        // )
                        // numeric(10,2)->numeric(12,4) length Ȯ

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                    else
                    {
                        // length 
                        // )
                        // numeric(10,2)->numeric(12,8) length 

                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   ,
                            // sTableColumn value sModifyColumn
                            // length ũٸ DDL   .

                            // sTableColumn  value null ̰ų
                            // sTableColumn  value length
                            // sModifyColumn length  ų ,
                            //    recreate table
                            //   
                            //    error

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    sModifyColumnInfo->scale,
                                    QD_CHANGE_STORED_TYPE_NONE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // Nothing to do
                        }

                        // recreate table
                        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_GEOMETRY_ID )
                {
                    //--------------------
                    // geometric  length 
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // geometry(3)->geometry(3)

                        // none
                        // sMethod = QD_MODIFY_METHOD_NONE;
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // geometry(3)->geometry(5)

                        // recreate table
                        sMethod =
                            sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                    else
                    {
                        // length 
                        // )
                        // geometry(3)->geometry(1)

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length ų  ,
                        //    recreate table
                        //   ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_NONE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );

                        // recreate table
                        sMethod =
                            sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                            sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                    }
                }
                else
                {
                    IDE_DASSERT( 0 );
                }
            }
            else
            {
                // type, length   
                // Nothing to do.
            }
        }

        sTableColumn = sTableColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    *aMethod = sMethod;
    *aVerifyColumn = sVerifyColumn;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::decideModifyMethodForDisk(
    qcStatement           * aStatement,
    qcmColumn             * aTableColumns,
    qcmColumn             * aModifyColumns,
    qdTblColModifyMethod  * aMethod,
    qdVerifyColumn       ** aVerifyColumn )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *    disk table  modify column modify method 
 *
 * Implementation :
*
 *    Table  column Ͽ  Ѵ
 *    (1) default value  , modify method 
 *    (2) (not) null  , modify method 
 *    (3) column option  , modify method 
 *    (4) type length  , modify method 
 *        - padding type -> non-padding type ȯ length 
 *        - non-padding type -> padding type ȯ length 
 *        - float->numeric type length 
 *        - numeric->flat type length 
 *    (5) length     , modify method 
 *        ex) char -> integer
 *    (6) type  length  , modify method 
 *        - non-padding type length 
 *        - padding type type length 
 *        - numeric length 
 *        - flaot length 
 *        - geometry  length 
 *
 *    (1),(2),(3) modify schema modify method 
 *     ܴ table column о  modify method 
 *
 ***********************************************************************/

    qdTblColModifyMethod   sMethod = QD_TBL_COL_MODIFY_METHOD_NONE;
    qcmColumn            * sTableColumn;
    qcmColumn            * sModifyColumn;
    mtcColumn            * sTableColumnInfo;
    mtcColumn            * sModifyColumnInfo;
    qdVerifyColumn       * sVerifyColumn = NULL;
    idBool                 sIsDataLoss   = ID_FALSE;

    sTableColumn = aTableColumns;
    sModifyColumn = aModifyColumns;

    while ( sTableColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        sTableColumnInfo = sTableColumn->basicInfo;
        sModifyColumnInfo = sModifyColumn->basicInfo;

         //-----------------------------------------
        // (1) default value  , modify method 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DEFAULT_MASK)
             == QCM_COLUMN_MODIFY_DEFAULT_TRUE )
        {
            IDE_TEST( qdbCommon::convertDefaultValueType(
                          aStatement,
                          & sModifyColumnInfo->type,
                          sModifyColumn->defaultValue,
                          NULL )
                      != IDE_SUCCESS );

            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (2) (not) null  , modify method 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
             == QCM_COLUMN_MODIFY_NULLABLE_NULL )
        {
            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                  == QCM_COLUMN_MODIFY_NULLABLE_NOTNULL )
        {
            // sTableColumn null value  ˻ؾ
            // null  ,  

            // verifyColumn 
            IDE_TEST( addVerifyColumn( aStatement,
                                       sTableColumn,
                                       QD_VERIFY_NOT_NULL,
                                       0,
                                       0,
                                       0,
                                       QD_CHANGE_STORED_TYPE_FALSE,
                                       & sVerifyColumn )
                      != IDE_SUCCESS );

            // rebuild meta
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (2) srid  , modify method 
        //-----------------------------------------

        if ( ( sModifyColumn->flag & QCM_COLUMN_MODIFY_SRID_MASK )
             == QCM_COLUMN_MODIFY_SRID_TRUE )
        {
            // sTableColumn srid ƴ value  ˻ؾ
            // srid ƴ value  ,  

            // verifyColumn 
            IDE_TEST( addVerifyColumn( aStatement,
                                       sTableColumn,
                                       QD_VERIFY_SRID,
                                       0,
                                       sModifyColumnInfo->mColumnAttr.mSridAttr.mSrid,
                                       0,
                                       QD_CHANGE_STORED_TYPE_NONE,
                                       & sVerifyColumn )
                      != IDE_SUCCESS );

            // rebuild meta
            if ( sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META )
            {
                // Nothing To Do
            }
            else
            {
                sMethod = QD_TBL_COL_MODIFY_METHOD_ALTER_META;
            }
        }
        else
        {
            // Nothing to do.
        }
        
        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK)
             == QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE )
        {
            //-----------------------------------------
            // (3) column option  , modify method 
            //-----------------------------------------

            // recreate table
            sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                sMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
        }
        else
        {
            // Nothing to do
        }

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_TYPE_MASK)
             == QCM_COLUMN_MODIFY_TYPE_TRUE )
        {
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
                 == QCM_COLUMN_MODIFY_LENGTH_TRUE )
            {
                //-----------------------------------------
                // (4) type length  , modify method 
                //     type ȯ,  ڷ  Ͽ
                //     length  ϴ.
                //
                // Ʒ  8 case 
                // nchar->nvarchar
                // nvarchar->nchar
                // char->varchar
                // varchar->char
                // bit->varbit
                // varbit->bit
                // float->numeric
                // numeric->float
                //-----------------------------------------

                if ( (sTableColumnInfo->module->id == MTD_NCHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_CHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_BIT_ID) )
                {
                    //--------------------
                    // padding type -> non-padding type ȯ length 
                    // Ʒ 3 case 
                    // nchar->nvarchar
                    // char->varchar
                    // bit->varbit
                    //--------------------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // length  ų Ȯ
                        // )
                        // char(3)->varchar(3)
                        // bit(3)->varbit(5)
                    }
                    else
                    {
                        // length 
                        // )
                        // char(3)->varchar(1)

                        // sTableColumn  value null ,
                        //   rebuild meta
                        // ׿, 

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_FALSE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                }
                else if ( (sTableColumnInfo->module->id
                           == MTD_NVARCHAR_ID) ||
                          (sTableColumnInfo->module->id
                           == MTD_VARCHAR_ID) ||
                          (sTableColumnInfo->module->id
                           == MTD_VARBIT_ID) )
                {
                    //--------------------
                    // non-padding type -> padding type ȯ length 
                    // Ʒ 3 case 
                    // nvarchar->nchar
                    // varchar->char
                    // varbit->bit
                    //--------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // nvarchar(4)->nchar(4)

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length  ,
                        //    rebuild meta
                        // sTableColumn  value length
                        // Ϸ length  ,
                        //    recreate table
                        // ׿ ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_EXACT_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_FALSE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // varbit(4)->bit(6)
                        // padding type ϴ  pad ڸ
                        // ؾ ϹǷ
                        // sTableColumn value  null 츸
                        // ǽðϼ type  ϴ.

                        // sTableColumn  null value ,
                        //    rebuild meta
                        //   ,
                        //    recreate table

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL_ONLY,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_FALSE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                    else
                    {
                        // length 
                        // )
                        // varchar(4)->char(3)
                        // sTableColumn value length
                        // sModifyColumn length  
                        // ǽðϼ type  ϴ.

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length  ,
                        //    rebuild meta
                        // sTableColumn  value length
                        // Ϸ length  ,
                        //    recreate table
                        // ׿ ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_EXACT_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_FALSE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_FLOAT_ID )
                {
                    //--------------------
                    // float->numeric type length 
                    //
                    // )
                    // float(8)->numeric(10,2)
                    // float(3)->numeric(5)
                    //--------------------

                    // float->numeric  schemaδ length Ȯ
                    //  Ǵ  .

                    // data loss ɼ  numeric length Ҵ Ұ
                    // ϴ.
                    if ( (sModifyColumn->flag &
                          QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                         == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                    {
                        // data loss ɼ   ,
                        // sTableColumn value sModifyColumn length
                        // ϴ ˻ؾ
                        //
                        // sTableColumn  value length
                        // sModifyColumn length  ۰ų  ,
                        //    rebuild meta,
                        // ׿ ,
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                sModifyColumnInfo->scale,
                                QD_CHANGE_STORED_TYPE_FALSE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                    else
                    {
                        // sTableColumn  value null  ,
                        //    rebuild meta
                        //   ,
                        //    recreate table

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL_ONLY,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_FALSE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_NUMERIC_ID )
                {
                    //--------------------
                    // numeric->flat type length 
                    // )
                    // numeric(10,2)->float(10)
                    // numeric(5)->float(3)
                    //--------------------


                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // sTableColumn value length
                        // sModifyColumn length
                        //  ų ۴ٸ ǽðϼ
                        // type  ϴ.
                        // )
                        // numeric(10,2)->float(10)
                        // numeric(10,2)->float(20)
                    }
                    else
                    {
                        // )
                        // numeric(5)->float(3)

                        // data loss ɼ  numeric length Ҵ
                        // Ұϴ.
                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   
                            // sTableColumn  value NULL̰ų
                            // sModifyColumn length  ۰ų 
                            //    rebuild meta
                            //   ,
                            //   

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    ID_SINT_MAX,  // scale 
                                    QD_CHANGE_STORED_TYPE_FALSE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // data loss ɼ  
                            // sTableColumn  value NULL ,
                            //   rebuild meta
                            // ׿ ,
                            //   recreate table

                            // BUG-28317
                            // value  NULL θ scan
                            // ʰ ˼ ִٸ   

                            // verifyColumn 
                            IDE_TEST( addVerifyColumn(
                                          aStatement,
                                          sTableColumn,
                                          QD_VERIFY_NULL_ONLY,
                                          0,
                                          0,
                                          0,
                                          QD_CHANGE_STORED_TYPE_FALSE,
                                          & sVerifyColumn )
                                      != IDE_SUCCESS );
                        }
                    }
                }
                else
                {
                    IDE_DASSERT( 0 );
                }
            }
            else
            {
                //-----------------------------------------
                // (5) length      ,
                //     modify method 
                //
                // Ʒ  2 case 
                // char->integer
                // varchar->date
                // )
                // char(4)->integer
                // varchar(8)->date
                //-----------------------------------------

                // sTableColumn value  null 
                // ǽðϼ type  ϴ.

                IDE_TEST( isDataLossConversion(
                              sTableColumnInfo->module->id,
                              sModifyColumnInfo->module->id,
                              & sIsDataLoss )
                          != IDE_SUCCESS );

                if ( ( sIsDataLoss == ID_TRUE ) &&
                     ( (sModifyColumn->flag &
                        QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                       == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE ) )
                {
                    // data loss ɼ   

                    // sTableColumn  value  null ,
                    //    rebuild meta
                    //   ,
                    //    


                    // BUG-28317
                    // value  NULL θ scan ʰ
                    // ˼ ִٸ   

                    // verifyColumn 
                    IDE_TEST( addVerifyColumn( aStatement,
                                               sTableColumn,
                                               QD_VERIFY_NULL,
                                               0,
                                               0,
                                               0,
                                               QD_CHANGE_STORED_TYPE_TRUE,
                                               & sVerifyColumn )
                              != IDE_SUCCESS );
                }
                else
                {
                    // sTableColumn  value  null ,
                    //    rebuild meta
                    // ׿ ,
                    //    recreate table

                    // BUG-28317
                    // value  NULL θ scan ʰ
                    // ˼ ִٸ   

                    // verifyColumn 
                    IDE_TEST( addVerifyColumn( aStatement,
                                               sTableColumn,
                                               QD_VERIFY_NULL_ONLY,
                                               0,
                                               0,
                                               0,
                                               QD_CHANGE_STORED_TYPE_TRUE,
                                               & sVerifyColumn )
                              != IDE_SUCCESS );
                }
            }
        }
        else
        {
            if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_LENGTH_MASK)
                 == QCM_COLUMN_MODIFY_LENGTH_TRUE )
            {
                //-----------------------------------------
                // (6) type  length  ,
                //     modify method 
                //
                // Ʒ  10 case 
                // nchar
                // nvarchar
                // char
                // varchar
                // bit
                // varbit
                // float
                // numeric
                // byte
                // nibble
                //-----------------------------------------

                if ( (sTableColumnInfo->module->id == MTD_NCHAR_ID) ||
                     (sTableColumnInfo->module->id == MTD_CHAR_ID)  ||
                     (sTableColumnInfo->module->id == MTD_BIT_ID)   ||
                     (sTableColumnInfo->module->id == MTD_BYTE_ID) )
                {
                    //--------------------------------
                    // padding type length 
                    // Ʒ 4 case 
                    // nchar, char, bit, byte
                    //--------------------------------

                    if ( sTableColumnInfo->precision ==
                         sModifyColumnInfo->precision )
                    {
                        // length  
                        // )
                        // char(3)->char(3)
                    }
                    else if ( sTableColumnInfo->precision <
                              sModifyColumnInfo->precision )
                    {
                        // length Ȯ
                        // )
                        // char(3)->char(5) length Ȯ
                        // sTableColumn value  null 
                        // ǽðϼ type  ϴ.

                        // sTableColumn  value  null ,
                        //    rebuild meta,
                        // ׿ ,
                        //    recreate table

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL_ONLY,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_FALSE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                    else
                    {
                        // length 
                        // )
                        // char(3)->char(1) length 
                        // sTableColumn value  null 
                        // ǽðϼ type  ϴ.

                        // sTableColumn  value  null ,
                        //    rebuild meta,
                        // ׿ ,
                        //    error

                        // BUG-28317
                        // value  NULL θ scan ʰ
                        // ˼ ִٸ   

                        // verifyColumn 
                        IDE_TEST( addVerifyColumn(
                                      aStatement,
                                      sTableColumn,
                                      QD_VERIFY_NULL,
                                      0,
                                      0,
                                      0,
                                      QD_CHANGE_STORED_TYPE_FALSE,
                                      & sVerifyColumn )
                                  != IDE_SUCCESS );
                    }
                }
                else if (
                    (sTableColumnInfo->module->id == MTD_NVARCHAR_ID) ||
                    (sTableColumnInfo->module->id == MTD_VARCHAR_ID)  ||
                    (sTableColumnInfo->module->id == MTD_VARBYTE_ID)  ||
                    (sTableColumnInfo->module->id == MTD_VARBIT_ID)   ||
                    (sTableColumnInfo->module->id == MTD_NIBBLE_ID) )
                {
                    //--------------------------------
                    // non-padding type length 
                    // Ʒ 4 case 
                    // nvarchar, varchar, varbit, nibble
                    //--------------------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // length  ų Ȯ
                        // )
                        // nvarchar(5)->nvarchar(5)
                        // varchar(5)->varchar(10) length Ȯ
                    }
                    else
                    {
                        // length 
                        // )
                        // varchar(5)->varchar(3) length 

                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length  ų  ,
                        //    rebuild meta
                        // ׿ 
                        //    error

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_FALSE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_FLOAT_ID )
                {
                    //--------------------------------
                    // float  length 
                    //--------------------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // length  ų Ȯ
                        // )
                        // float(5)->float(5)
                        // float(5)->float(10) length Ȯ
                    }
                    else
                    {
                        // length 
                        // )
                        // float(5)->float(3) length 

                        // data loss ɼ  float length Ҵ
                        // Ұϴ.
                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   

                            // sTableColumn  value null ̰ų
                            // sTableColumn  value length
                            // sModifyColumn length ۰ų 
                            //    rebuild meta
                            // ׿ ,
                            //    error

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    ID_SINT_MAX,  // scale 
                                    QD_CHANGE_STORED_TYPE_FALSE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // sTableColumn  value null ,
                            //    rebuild meta
                            // ׿ ,
                            //    recreate table

                            // BUG-28317
                            // value  NULL θ scan
                            // ʰ ˼ ִٸ   

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_ONLY,
                                    0,
                                    0,
                                    0,
                                    QD_CHANGE_STORED_TYPE_FALSE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_NUMERIC_ID )
                {
                    //--------------------------------
                    // numeric  length 
                    // )
                    // numeric(5)->numeric(10) length Ȯ
                    // numeric(5)->numeric(3) length 
                    // numeric(5)->numeric(5,0)
                    // numeric(10,2)->numeric(15,3) length Ȯ
                    // numeric(10,2)->numeric(10,0) length 
                    // numeric(10,2)->numeric(10,2)
                    //--------------------------------

                    if ( isEnlargingLengthForNumericType(
                             sTableColumnInfo->precision,
                             sTableColumnInfo->scale,
                             sModifyColumnInfo->precision,
                             sModifyColumnInfo->scale )
                         == ID_TRUE )
                    {
                        // length Ȯ
                        // )
                        // numeric(5)->numeric(10) length Ȯ
                        // numeric(10,2)->numeric(15,3) length Ȯ
                        // numeric(5)->numeric(5,0)
                        // numeric(10,2)->numeric(10,2)
                    }
                    else
                    {
                        // length 
                        // )
                        // numeric(5)->numeric(3) length 
                        // numeric(10,2)->numeric(10,0) length 

                        // data loss ɼ  numeric length Ҵ
                        // Ұϴ.
                        if ( (sModifyColumn->flag &
                              QCM_COLUMN_MODIFY_DATA_LOSS_MASK)
                             == QCM_COLUMN_MODIFY_DATA_LOSS_FALSE )
                        {
                            // data loss ɼ   

                            // sTableColumn  value null ̰ų
                            // sTableColumn  value length
                            // sModifyColumn length  ų ,
                            //    rebuild meta
                            // ׿ 
                            //    error

                            // verifyColumn 
                            IDE_TEST(
                                addVerifyColumn(
                                    aStatement,
                                    sTableColumn,
                                    QD_VERIFY_NULL_OR_UNDER_SIZE,
                                    sModifyColumnInfo->column.size,
                                    sModifyColumnInfo->precision,
                                    sModifyColumnInfo->scale,
                                    QD_CHANGE_STORED_TYPE_FALSE,
                                    & sVerifyColumn )
                                != IDE_SUCCESS );
                        }
                        else
                        {
                            // sTableColumn  value null ,
                            //    rebuild meta
                            // ׿ ,
                            //    recreate table

                            // BUG-28317
                            // value  NULL θ scan
                            // ʰ ˼ ִٸ   

                            // verifyColumn 
                            IDE_TEST( addVerifyColumn(
                                          aStatement,
                                          sTableColumn,
                                          QD_VERIFY_NULL_ONLY,
                                          0,
                                          0,
                                          0,
                                          QD_CHANGE_STORED_TYPE_FALSE,
                                          & sVerifyColumn )
                                      != IDE_SUCCESS );
                        }
                    }
                }
                else if ( sTableColumnInfo->module->id == MTD_GEOMETRY_ID )
                {
                    //--------------------------------
                    // geometry  length 
                    //--------------------------------

                    if ( sTableColumnInfo->precision <=
                         sModifyColumnInfo->precision )
                    {
                        // length  ų Ȯ
                        // )
                        // geometry(3)->geometry(3)
                        // geometry(3)->geometry(5) length Ȯ
                    }
                    else
                    {
                        // length 
                        // sTableColumn  value null ̰ų
                        // sTableColumn  value length
                        // sModifyColumn length ų  ,
                        //    rebuild meta
                        // ׿ ,
                        //    error
                        //

                        // verifyColumn 
                        IDE_TEST(
                            addVerifyColumn(
                                aStatement,
                                sTableColumn,
                                QD_VERIFY_NULL_OR_UNDER_SIZE,
                                sModifyColumnInfo->column.size,
                                sModifyColumnInfo->precision,
                                ID_SINT_MAX,  // scale 
                                QD_CHANGE_STORED_TYPE_FALSE,
                                & sVerifyColumn )
                            != IDE_SUCCESS );
                    }
                }
                else
                {
                    IDE_DASSERT( 0 );
                }
            }
            else
            {
                // Nothing to do.
            }
        }

        sMethod = sMethod > QD_TBL_COL_MODIFY_METHOD_ALTER_META ?
            sMethod : QD_TBL_COL_MODIFY_METHOD_ALTER_META;

        sTableColumn = sTableColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    *aMethod = sMethod;
    *aVerifyColumn = sVerifyColumn;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::modifyIndexColumnInfo( qcStatement     * aStatement,
                                        qdVerifyColumn  * aVerifyColumns,
                                        idBool            aIsTablePartition,
                                        qcmTableInfo   ** aNewTableInfo )
{
 /***********************************************************************
 *
 * Description : PROJ-1911
 *    disk table  index  
 *
 * Implementation :
 *
 ***********************************************************************/

    qcmTableInfo         * sTableInfo;
    UInt                   sIndexCount;
    qdIdxColModify       * sIdxColModify;
    qcmIndex             * sIndex;
    mtcColumn            * sKeyColumn = NULL;
    qdVerifyColumn       * sVerifyColumn = NULL;
    idBool                 sAlterMeta = ID_TRUE;
    const void           * sIndexHandle = NULL;
    UInt                   i;
    UInt                   j;

    sTableInfo  = *aNewTableInfo;
    sIndexCount = sTableInfo->indexCount;

    if ( sIndexCount > 0 )
    {
        IDU_LIMITPOINT("qdbAlter::modifyIndexColumnInfo::malloc");
        IDE_TEST( aStatement->qmxMem->alloc(
                      ID_SIZEOF(qdIdxColModify) * sIndexCount,
                      (void**) &sIdxColModify )
                  != IDE_SUCCESS );
    }

    /* BUG-31868
     * ǽð Alter table ,  ̺  ε Ÿ 籸ؾ մϴ.
     * ε  ÷ Ǹ index ÷ ġ ǹǷ ȴ.
     *  ϰ  ε  ϵ Ѵ.
     */
    for ( i = 0; i < sIndexCount; i++ )
    {
        sIndex                   = &sTableInfo->indices[i];
        sIdxColModify[i].indexId = sIndex->indexId;

        sAlterMeta = ID_TRUE;

        for ( j = 0; j < sIndex->keyColCount; j++ )
        {
            sKeyColumn = & sIndex->keyColumns[j];

            for ( sVerifyColumn = aVerifyColumns;
                  sVerifyColumn != NULL;
                  sVerifyColumn = sVerifyColumn->next )
            {
                if ( sVerifyColumn->column->basicInfo->column.id ==
                     sKeyColumn->column.id )
                {
                    if ( sVerifyColumn->changeStoredType ==
                         QD_CHANGE_STORED_TYPE_TRUE )
                    {
                        // key column  ϳ  Ÿ
                        // Ǵ 
                        // index  ؾ 
                        sAlterMeta = ID_FALSE;
                        break;
                    }
                    else
                    {
                        // nothing to do
                    }
                    
                    // fix BUG-33004
                    //  Ÿ  ʾƵ
                    // ÷ ũⰡ Ǵ 쿡
                    // index  ־ Ѵ.
                    if ( sVerifyColumn->column->basicInfo->column.size !=
                         sKeyColumn->column.size )
                    {
                        sAlterMeta = ID_FALSE;
                        break;
                    }
                    else
                    {
                        // nothing to do
                    }
                }
                else
                {
                    // nothing to do
                }
            }
        }

        if ( sAlterMeta == ID_TRUE )
        {
            sIdxColModify[i].method = QD_IDX_COL_MODIFY_METHOD_ALTER_META;
        }
        else
        {
            sIdxColModify[i].method = QD_IDX_COL_MODIFY_METHOD_RECREATE_INDEX;
        }
    }

    for ( i = 0; i < sIndexCount; i++ )
    {
        //-----------------------------------------
        // Table Index column  
        //-----------------------------------------

        //  index recreateǸ
        // handle ٲ  SM Interfaceκ  handle
        // ; 

        sIndex       = &sTableInfo->indices[i];
        sIndexHandle = smiGetTableIndexByID( sTableInfo->tableHandle,
                                             sTableInfo->indices[i].indexId );

        if ( sIdxColModify[i].method == QD_IDX_COL_MODIFY_METHOD_ALTER_META )
        {
            // Meta 游 ص Ǵ index
            IDE_TEST( alterIndexMetaForDisk(aStatement,
                                            aIsTablePartition,
                                            &sTableInfo )
                      != IDE_SUCCESS );
        }
        else // QD_IDX_COL_MODIFY_METHOD_RECREATE_INDEX
        {
            // recreate ؾ Ǵ index
            IDE_TEST( recreateIndexForDisk(aStatement,
                                           sIndexHandle,
                                           sIndex,
                                           ID_FALSE,
                                           aIsTablePartition,
                                           &sTableInfo,
                                           NULL,
                                           NULL,
                                           NULL )
                        != IDE_SUCCESS );
        }

        // BUG-36045
        *aNewTableInfo = sTableInfo;
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::recreateIndexColumnInfo( qcStatement       * aStatement,
                                          qcmColumn         * /*aModifyColumns*/,
                                          qcmTableInfo     ** aNewTableInfo,
                                          qdIndexTableList  * aOldIndexTables,
                                          qdIndexTableList ** aNewIndexTables,
                                          qdIndexTableList ** aDelIndexTables )
{
 /***********************************************************************
 *
 * Description : PROJ-1624 non-partitioned index
 *     alter modify column modify column ϴ non-partitioned index
 *     index table Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/

    qcmTableInfo         * sTableInfo;
    UInt                   sIndexCount;
    qcmIndex             * sIndex;
    const void           * sIndexHandle = NULL;
    UInt                   i;

    sTableInfo  = *aNewTableInfo;
    sIndexCount = sTableInfo->indexCount;

    /* BUG-31868
     * ǽð Alter table ,  ̺  ε Ÿ 籸ؾ մϴ.
     * ε  ÷ Ǹ index ÷ ġ ǹǷ ȴ.
     *  ϰ  ε  ϵ Ѵ.
     */
    for ( i = 0; i < sIndexCount; i++ )
    {
        sIndex = &sTableInfo->indices[i];

        if ( sIndex->indexPartitionType == QCM_NONE_PARTITIONED_INDEX )
        {
            //  index recreateǸ
            // handle ٲ  SM Interfaceκ  handle
            // ; 
            sIndexHandle = smiGetTableIndexByID( sTableInfo->tableHandle,
                                                 sTableInfo->indices[i].indexId );

            IDE_TEST( recreateIndexForDisk( aStatement,
                                            sIndexHandle,
                                            sIndex,
                                            ID_TRUE,  // partitioned table
                                            ID_FALSE, // table partition
                                            & sTableInfo,
                                            aOldIndexTables,
                                            aNewIndexTables,
                                            aDelIndexTables )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }
    }

    *aNewTableInfo = sTableInfo;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::alterIndexMetaForDisk( qcStatement   * aStatement,        // in
                                        idBool          aIsTablePartition, // in
                                        qcmTableInfo ** aNewTableInfo )    // in,out
{
/***********************************************************************
 *
 * Description : PROJ-1911 index meta column  
 *
 * Implementation :
 *
 ***********************************************************************/

    qcmTableInfo    * sOldTableInfo = NULL;
    qcmTableInfo    * sNewTableInfo = NULL;
    void            * sTableHandle;
    smSCN             sSCN;

    sOldTableInfo = *aNewTableInfo;

    IDE_ASSERT( sOldTableInfo != NULL );    // TASK-3876 Code Sonar

    //-----------------------------------------
    // cached meta 
    //-----------------------------------------

    if ( aIsTablePartition == ID_TRUE )
    {
        IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->partitionID,
                      smiGetTableId( sOldTableInfo->tableHandle ),
                      sOldTableInfo,
                      NULL )
                  != IDE_SUCCESS );

        IDE_TEST(
            qcmPartition::getPartitionInfoByID( aStatement,
                                                sOldTableInfo->partitionID,
                                                & sNewTableInfo,
                                                & sSCN,
                                                & sTableHandle )
            != IDE_SUCCESS );

        (void) qcmPartition::destroyQcmPartitionInfo( sOldTableInfo );
    }
    else
    {
        IDE_TEST( qcm::makeAndSetQcmTableInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->tableID,
                      smiGetTableId( sOldTableInfo->tableHandle ) )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sOldTableInfo->tableID,
                                         & sNewTableInfo,
                                         & sSCN,
                                         & sTableHandle )
                  != IDE_SUCCESS);

        (void) qcm::destroyQcmTableInfo( sOldTableInfo );
    }

    *aNewTableInfo = sNewTableInfo;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    if ( sNewTableInfo != NULL )
    {
        if ( aIsTablePartition == ID_TRUE )
        {
            (void) qcmPartition::destroyQcmPartitionInfo( sNewTableInfo );
        }
        else
        {
            (void) qcm::destroyQcmTableInfo( sNewTableInfo );
        }
    }

    return IDE_FAILURE;
}

IDE_RC qdbAlter::recreateIndexForDisk( qcStatement       * aStatement,          // in
                                       const void        * aIndexHandle,        // in
                                       qcmIndex          * aIndex,              // in
                                       idBool              aIsPartitionedTable, // in
                                       idBool              aIsTablePartition,   // in
                                       qcmTableInfo     ** aNewTableInfo,       // in,out
                                       qdIndexTableList  * aOldIndexTables,     // in
                                       qdIndexTableList ** aNewIndexTables,     // in,out
                                       qdIndexTableList ** aDelIndexTables )    // out
{
 /***********************************************************************
 *
 * Description : PROJ-1911
 *     index 
 *
 * Implementation :
 *     ϳ index 
 *     (1) partitioned table  partitioned table
 *     (2) partitioned table  table partition
 *     (3) non-partitioned table  table
 *
 ***********************************************************************/

    smiColumnList        * sColumnListAtKey;
    qcmTableInfo         * sOldTableInfo   = NULL;
    qcmTableInfo         * sNewTableInfo   = NULL;
    qcmTableInfo         * sIndexTableInfo = NULL;
    UInt                   sFlag;
    smiSegAttr             sSegAttr;
    smiSegStorageAttr      sSegStoAttr;
    smSCN                  sSCN;
    void                 * sTableHandle;
    const void           * sNewIndexHandle;
    qcmPartitionInfoList * sTempPartInfoList = NULL;
    qdIndexTableList     * sOldIndexTable = NULL;
    qdIndexTableList     * sNewIndexTable = NULL;
    qdIndexTableList     * sIndexTable = NULL;
    qcmIndex             * sIndexTableIndex[2];
    qcNamePosition         sIndexTableNamePos;
    UInt                   sIndexTableFlag;
    UInt                   sIndexTableParallelDegree;
    qcmColumn            * sColumns;
    UInt                   sColumnCount;
    
    sOldTableInfo = *aNewTableInfo;

    IDE_ASSERT( sOldTableInfo != NULL );    // TASK-3876 Code Sonar

    //-----------------------------------------
    // index Ѵ.
    //-----------------------------------------

    // ε   flag
    sFlag = smiTable::getIndexInfo( aIndexHandle );
    sSegAttr = smiTable::getIndexSegAttr( aIndexHandle );
    sSegStoAttr = smiTable::getIndexSegStoAttr( aIndexHandle );

    // ش ε 
    IDE_TEST( smiTable::dropIndex( QC_SMI_STMT( aStatement ),
                                   sOldTableInfo->tableHandle,
                                   aIndexHandle,
                                   SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS);

    // ε   Ű ÷  Ѵ.
    // index keyColumn type flag sIndex ̹ Ǿ ִ.
    IDE_TEST( qdx::getKeyColumnList( aStatement,
                                     aIndex,
                                     & sColumnListAtKey )
              != IDE_SUCCESS );

    // ε 
    IDE_TEST( smiTable::createIndex(
                  aStatement->mStatistics,
                  QC_SMI_STMT( aStatement ),
                  aIndex->TBSID,
                  sOldTableInfo->tableHandle,
                  (SChar*)aIndex->name,
                  aIndex->indexId,
                  aIndex->indexTypeId,
                  sColumnListAtKey,
                  sFlag,
                  QD_INDEX_DEFAULT_PARALLEL_DEGREE,
                  SMI_INDEX_BUILD_UNCOMMITTED_ROW_DISABLE,
                  sSegAttr,
                  sSegStoAttr,
                  0, /* PROJ-2433 : disk direct key index  */
                  & sNewIndexHandle )
              != IDE_SUCCESS );

    // PROJ-1624 global non-partitioned index
    // ο index table Ѵ.
    if ( ( aIsPartitionedTable == ID_TRUE ) &&
         ( aIsTablePartition == ID_FALSE ) &&
         ( aIndex->indexPartitionType == QCM_NONE_PARTITIONED_INDEX ) )
    {
        IDE_DASSERT( aOldIndexTables != NULL );
        IDE_DASSERT( aNewIndexTables != NULL );
        IDE_DASSERT( aDelIndexTables != NULL );
        
        IDE_TEST_RAISE( aIndex->indexTableID == 0, ERR_META_CRASH );

        IDE_TEST( qdx::findIndexTableInList( aOldIndexTables,
                                             aIndex->indexTableID,
                                             & sOldIndexTable )
                  != IDE_SUCCESS );

        // drop index table Ͽ Ѵ.
        IDE_TEST( aStatement->qmxMem->alloc(
                      ID_SIZEOF(qdIndexTableList),
                      (void**)&sIndexTable )
                  != IDE_SUCCESS);

        idlOS::memcpy( sIndexTable,
                       sOldIndexTable,
                       ID_SIZEOF(qdIndexTableList) );

        sIndexTable->next = *aDelIndexTables;
        *aDelIndexTables = sIndexTable;
        
        //---------------------------
        // drop old index table
        //---------------------------
            
        IDE_TEST( qdx::dropIndexTable( aStatement,
                                       sOldIndexTable,
                                       ID_FALSE /* aIsDropTablespace */ )
                  != IDE_SUCCESS );
            
        //---------------------------
        // create new index table
        //---------------------------
            
        sIndexTableFlag = sOldIndexTable->tableInfo->tableFlag;
        sIndexTableParallelDegree = sOldIndexTable->tableInfo->parallelDegree;

        sIndexTableNamePos.stmtText = sOldIndexTable->tableInfo->name;
        sIndexTableNamePos.offset   = 0;
        sIndexTableNamePos.size     =
            idlOS::strlen(sOldIndexTable->tableInfo->name);

        // modified table info index table column Ѵ.
        IDE_TEST( qdx::makeColumns4ModifyColumn( aStatement,
                                                 sOldTableInfo,
                                                 aIndex->keyColumns,
                                                 aIndex->keyColCount,
                                                 aIndex->TBSID,
                                                 & sColumns,
                                                 & sColumnCount )
                  != IDE_SUCCESS );
        
        IDE_TEST( qdx::createIndexTable( aStatement,
                                         sOldIndexTable->tableInfo->tableOwnerID,
                                         sIndexTableNamePos,
                                         sColumns,
                                         sColumnCount,
                                         aIndex->TBSID,
                                         sOldIndexTable->tableInfo->segAttr, // sSegAttr index̴.
                                         sSegStoAttr,
                                         QDB_TABLE_ATTR_MASK_ALL,
                                         sIndexTableFlag, /* Flag Value */
                                         sIndexTableParallelDegree,
                                         & sNewIndexTable )
                  != IDE_SUCCESS );
        
        // link new index table
        sNewIndexTable->next = *aNewIndexTables;
        *aNewIndexTables = sNewIndexTable;

        // key index, rid index ã´.
        IDE_TEST( qdx::getIndexTableIndices( sOldIndexTable->tableInfo,
                                             sIndexTableIndex )
                  != IDE_SUCCESS );
            
        IDE_TEST( qdx::createIndexTableIndices(
                      aStatement,
                      sOldIndexTable->tableInfo->tableOwnerID,
                      sNewIndexTable,
                      NULL,
                      sIndexTableIndex[0]->name,
                      sIndexTableIndex[1]->name,
                      sIndexTableIndex[0]->TBSID,
                      sIndexTableIndex[0]->indexTypeId,
                      sFlag,
                      QD_INDEX_DEFAULT_PARALLEL_DEGREE,
                      SMI_INDEX_BUILD_UNCOMMITTED_ROW_DISABLE,
                      sSegAttr,
                      sSegStoAttr,
                      0 ) /* PROJ-2433 : disk direct key index  */
                  != IDE_SUCCESS );
        
        sIndexTableInfo = sNewIndexTable->tableInfo;

        IDE_TEST(qcm::makeAndSetQcmTableInfo(QC_SMI_STMT(aStatement),
                                             sNewIndexTable->tableID,
                                             sNewIndexTable->tableOID)
                 != IDE_SUCCESS);
            
        IDE_TEST(qcm::getTableInfoByID(aStatement,
                                       sNewIndexTable->tableID,
                                       &(sNewIndexTable->tableInfo),
                                       &(sNewIndexTable->tableSCN),
                                       &(sNewIndexTable->tableHandle))
                 != IDE_SUCCESS);
        (void)qcm::destroyQcmTableInfo( sIndexTableInfo );
        
        //---------------------------
        // build new index table
        //---------------------------

        IDE_TEST( qcmPartition::getPartitionInfoList( aStatement,
                                                      QC_SMI_STMT( aStatement ),
                                                      aStatement->qmxMem,
                                                      sOldTableInfo->tableID,
                                                      & sTempPartInfoList )
                  != IDE_SUCCESS );
        
        // index key mtcColumn table qcmColumn ȯѴ.
        IDE_TEST( qdx::makeColumns4BuildIndexTable( aStatement,
                                                    sOldTableInfo,
                                                    aIndex->keyColumns,
                                                    aIndex->keyColCount,
                                                    & sColumns,
                                                    & sColumnCount )
                  != IDE_SUCCESS );
        
        IDE_TEST( qdx::buildIndexTable( aStatement,
                                        sNewIndexTable,
                                        sColumns,
                                        sColumnCount,
                                        sOldTableInfo,
                                        sTempPartInfoList )
                  != IDE_SUCCESS );
        
        //---------------------------
        // update meta table
        //---------------------------

        IDE_TEST( qdx::updateIndexSpecFromMeta( aStatement,
                                                aIndex->indexId,
                                                sNewIndexTable->tableID )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }
    
    //-----------------------------------------
    // cached meta 
    //-----------------------------------------

    // qdbAlter::alterMetaForDisk() touch ̹ ߴ.

    if ( aIsTablePartition == ID_TRUE )
    {
        IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->partitionID,
                      smiGetTableId( sOldTableInfo->tableHandle ),
                      sOldTableInfo,
                      NULL )
                  != IDE_SUCCESS );

        IDE_TEST( qcmPartition::getPartitionInfoByID(
                      aStatement,
                      sOldTableInfo->partitionID,
                      & sNewTableInfo,
                      & sSCN,
                      & sTableHandle )
                  != IDE_SUCCESS );

        (void) qcmPartition::destroyQcmPartitionInfo( sOldTableInfo );
    }
    else
    {
        IDE_TEST( qcm::makeAndSetQcmTableInfo(
                      QC_SMI_STMT( aStatement ),
                      sOldTableInfo->tableID,
                      smiGetTableId( sOldTableInfo->tableHandle ) )
                  != IDE_SUCCESS );

        IDE_TEST( qcm::getTableInfoByID( aStatement,
                                         sOldTableInfo->tableID,
                                         & sNewTableInfo,
                                         & sSCN,
                                         & sTableHandle )
                  != IDE_SUCCESS);

        (void) qcm::destroyQcmTableInfo( sOldTableInfo );
    }

    *aNewTableInfo = sNewTableInfo;

    return IDE_SUCCESS;

    IDE_EXCEPTION(ERR_META_CRASH)
    {
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QCM_META_CRASH));
    }
    IDE_EXCEPTION_END;

    if ( sNewTableInfo != NULL )
    {
        if ( aIsTablePartition == ID_TRUE )
        {
            (void) qcmPartition::destroyQcmPartitionInfo( sNewTableInfo );
        }
        else
        {
            (void) qcm::destroyQcmTableInfo( sNewTableInfo );
        }
    }

    /* Index Table List Meta Cache  Լ Ѵ. */
    
    return IDE_FAILURE;
}

IDE_RC qdbAlter::addVerifyColumn( qcStatement         * aStatement,
                                  qcmColumn           * aTableColumn,
                                  qdVerifyCommand       aCommand,
                                  UInt                  aSize,
                                  SInt                  aPrecision,
                                  SInt                  aScale,
                                  qdChangeStoredType    aChangeStoredType,
                                  qdVerifyColumn     ** aVerifyColumn )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *
 * Implementation :
 *
 ***********************************************************************/

    qdVerifyColumn  * sColumn;

    // sVerifyColumn 
    IDU_LIMITPOINT("qdbAlter::addVerifyColumn::malloc");
    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(qdVerifyColumn),
                                         (void**) & sColumn )
              != IDE_SUCCESS );

    // sVerifyColumn ʱȭ
    sColumn->column           = aTableColumn;
    sColumn->command          = aCommand;
    sColumn->size             = aSize;
    sColumn->precision        = aPrecision;
    sColumn->scale            = aScale;
    sColumn->changeStoredType = aChangeStoredType;
    sColumn->next             = *aVerifyColumn;

    // sVerifyColumn 
    *aVerifyColumn = sColumn;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

idBool qdbAlter::isNullOnlyCommand( qdVerifyColumn * aVerifyColumn )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     verify command  QD_VERIFY_NULL_ONLY ˻Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::isNullOnlyCommand"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::isNullOnlyCommand"));

    qdVerifyColumn  * sVerifyColumn;
    idBool            sIsNullOnly = ID_TRUE;

    sVerifyColumn = aVerifyColumn;

    while ( sVerifyColumn != NULL )
    {
        if ( sVerifyColumn->command != QD_VERIFY_NULL_ONLY )
        {
            sIsNullOnly = ID_FALSE;
            break;
        }
        else
        {
            // Nothing to do.
        }

        sVerifyColumn = sVerifyColumn->next;
    }

    return sIsNullOnly;

#undef IDE_FN
}

IDE_RC qdbAlter::verifyColumnValue( qcStatement          * aStatement,
                                    qcmTableInfo         * aTableInfo,
                                    qdVerifyColumn       * aVerifyColumn,
                                    qdTblColModifyMethod * aMethod )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     alter table modify column execution table column value
 *     о modify  ˻Ѵ.
 *
 * Implementation :
 *    1. Cursor ʱȭ
 *    2. Cursor Open
 *    3.  ڵ徿 鼭  ˻
 *
 ***********************************************************************/

    qdVerifyColumn       * sVerifyColumn;
    scGRID                 sRid;
    smiCursorProperties    sCursorProperty;
    smiTableCursor         sCursor;
    smiFetchColumnList   * sFetchColumnList = NULL;
    const void           * sRow;
    SInt                   sStage = 0;
    UInt                   sTableType;
    mtcColumn            * sMtcColumn;
    UChar                * sVarRowBuffer = NULL;
    UInt                   sVarRowSize;
    UInt                   sVarRowOffset;
    UInt                   sRowSize;

    //-----------------------------------------
    // record б   
    //-----------------------------------------

    sTableType = aTableInfo->tableFlag & SMI_TABLE_TYPE_MASK;

    if ( sTableType == SMI_TABLE_DISK )
    {
        // Record Read   ҴѴ.
        IDE_TEST( qdbCommon::getDiskRowSize( aTableInfo,
                                             & sRowSize )
                  != IDE_SUCCESS );

        // To fix BUG-14820
        // Disk-variable ÷ rid񱳸  ʱȭ ؾ .
        IDU_LIMITPOINT("qdbAlter::verifyColumnValue::malloc1");
        IDE_TEST( aStatement->qmxMem->cralloc( sRowSize,
                                               (void**) & sRow )
                  != IDE_SUCCESS );

        // fetch column list ʱȭѴ.
        qdbCommon::initFetchColumnList( & sFetchColumnList );

        // fetch column list Ѵ.
        sVerifyColumn = aVerifyColumn;

        while ( sVerifyColumn != NULL )
        {
            // verify column ߰ϸ鼭  ߺ Ѵ.
            IDE_TEST( qdbCommon::addFetchColumnList(
                          aStatement->qmxMem,
                          sVerifyColumn->column->basicInfo,
                          & sFetchColumnList )
                      != IDE_SUCCESS );

            sVerifyColumn = sVerifyColumn->next;
        }
    }
    else
    {
        // memory table or volatile table
        IDE_DASSERT( ( sTableType == SMI_TABLE_MEMORY ) ||
                     ( sTableType == SMI_TABLE_VOLATILE ) );

        // BUGBUG
        // verify column table column ߺ  ִ. 
        // ߺǴ variable column Ͽ  row buffer  ǰ
        //  Ͽ   ȴ.

        // Variable Column value  ҴѴ.
        sVerifyColumn = aVerifyColumn;
        sVarRowSize = 0;

        while ( sVerifyColumn != NULL )
        {
            // To fix BUG-24356
            // geometry ؼ value bufferҴ
            if ( ( (sVerifyColumn->column->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                    == SMI_COLUMN_TYPE_VARIABLE_LARGE ) &&
                 (sVerifyColumn->column->basicInfo->module->id == MTD_GEOMETRY_ID) )
            {
                sVarRowSize += smiGetVariableColumnSize( sTableType ) +
                    sVerifyColumn->column->basicInfo->column.size;
                sVarRowSize = idlOS::align( sVarRowSize, 8 );
            }
            else
            {
                // Nothing to do.
            }

            sVerifyColumn = sVerifyColumn->next;
        }

        if ( sVarRowSize > 0 )
        {
            IDU_LIMITPOINT("qdbAlter::verifyColumnValue::malloc2");
            IDE_TEST( aStatement->qmxMem->cralloc( sVarRowSize,
                                                   (void**) & sVarRowBuffer )
                      != IDE_SUCCESS );

            sVerifyColumn = aVerifyColumn;
            sVarRowOffset = 0;

            while ( sVerifyColumn != NULL )
            {
                // To fix BUG-24356
                // geometry ؼ value bufferҴ
                if ( ( (sVerifyColumn->column->basicInfo->column.flag & SMI_COLUMN_TYPE_MASK)
                        == SMI_COLUMN_TYPE_VARIABLE_LARGE ) &&
                     (sVerifyColumn->column->basicInfo->module->id == MTD_GEOMETRY_ID) )
                {
                    // sVerifyColumn basicInfo sTableColumn basicInfo̹Ƿ
                    // ؼ Ѵ.
                    IDU_LIMITPOINT("qdbAlter::verifyColumnValue::malloc3");
                    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(mtcColumn),
                                                         (void**) & sMtcColumn )
                              != IDE_SUCCESS );

                    idlOS::memcpy( sMtcColumn,
                                   sVerifyColumn->column->basicInfo,
                                   ID_SIZEOF(mtcColumn) );

                    sMtcColumn->column.value = (void*) (sVarRowBuffer + sVarRowOffset);
                    sVerifyColumn->column->basicInfo = sMtcColumn;

                    sVarRowOffset += smiGetVariableColumnSize( sTableType ) +
                        sVerifyColumn->column->basicInfo->column.size;
                    sVarRowOffset = idlOS::align( sVarRowOffset, 8 );
                }
                else
                {
                    // Nothing to do.
                }

                sVerifyColumn = sVerifyColumn->next;
            }
        }
        else
        {
            // Nothing to do.
        }
    }

    //-----------------------------------------
    // record о ÷  ˻
    //-----------------------------------------

    // ˻  ڷ  ʱȭ
    SMI_CURSOR_PROP_INIT_FOR_FULL_SCAN( &sCursorProperty, aStatement->mStatistics );

    sCursorProperty.mFetchColumnList = sFetchColumnList;

    sCursor.initialize();

    IDE_TEST(sCursor.open(
                 QC_SMI_STMT( aStatement ),
                 aTableInfo->tableHandle,
                 NULL,
                 smiGetRowSCN(aTableInfo->tableHandle),
                 NULL,
                 smiGetDefaultKeyRange(),
                 smiGetDefaultKeyRange(),
                 smiGetDefaultFilter(),
                 QCM_META_CURSOR_FLAG,
                 SMI_SELECT_CURSOR,
                 & sCursorProperty) != IDE_SUCCESS);
    sStage = 1;

    IDE_TEST(sCursor.beforeFirst() != IDE_SUCCESS);
    IDE_TEST(sCursor.readRow(&sRow, &sRid, SMI_FIND_NEXT) != IDE_SUCCESS);

    if ( isNullOnlyCommand( aVerifyColumn ) == ID_TRUE )
    {
        // verify command  QD_VERIFY_NULL_ONLY ִٸ
        //  recreate ʿ ǴܵǸ  scan ߴ  ִ.

        while ( sRow != NULL )
        {
            IDE_TEST( verifyColumnValueNullOnlyForRow( aVerifyColumn,
                                                       sRow,
                                                       aMethod )
                      != IDE_SUCCESS );

            if ( *aMethod == QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE )
            {
                break;
            }
            else
            {
                // Nothing to do.
            }

            IDE_TEST( sCursor.readRow( &sRow, &sRid, SMI_FIND_NEXT )
                      != IDE_SUCCESS );
        }
    }
    else
    {
        //  verify command  record Ͽ ˻ؾ ϹǷ
        // full scan  ʿϴ.

        while ( sRow != NULL )
        {
            IDE_TEST( verifyColumnValueForRow( aStatement,
                                               aVerifyColumn,
                                               sRow,
                                               aMethod )
                      != IDE_SUCCESS );

            IDE_TEST( sCursor.readRow( &sRow, &sRid, SMI_FIND_NEXT )
                      != IDE_SUCCESS );
        }
    }

    sStage = 0;

    IDE_TEST(sCursor.close() != IDE_SUCCESS);

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    if ( sStage == 1 )
    {
        sCursor.close();
    }

    return IDE_FAILURE;
}

IDE_RC qdbAlter::verifyColumnValueForRow( qcStatement          * aStatement,
                                          qdVerifyColumn       * aVerifyColumn,
                                          const void           * aRow,
                                          qdTblColModifyMethod * aMethod )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     column value  row о ˻Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/

    qdVerifyColumn   * sVerifyColumn;
    mtcColumn        * sColumn;
    mtcColumn          sCanonizedColumn;
    UInt               sSize;
    SInt               sPrecision;
    SInt               sScale;
    qcuSqlSourceInfo   sqlInfo;
    void             * sValueTemp;
    void             * sCanonizedValue;

    sVerifyColumn = aVerifyColumn;

    while ( sVerifyColumn != NULL )
    {
        sColumn = sVerifyColumn->column->basicInfo;

        switch ( sVerifyColumn->command )
        {
            case QD_VERIFY_NOT_NULL:

                if ( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                     == SMI_COLUMN_TYPE_LOB )
                {
                    // PROJ-1362
                    if ( smiIsNullLobColumn(aRow, & sColumn->column)
                         == ID_TRUE )
                    {
                        sqlInfo.setSourceInfo( aStatement,
                                               & sVerifyColumn->column->namePos );
                        IDE_RAISE( ERR_INVALID_NULL_VALUE );
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
                else
                {
                    // null̸ 
                    sValueTemp = (void*)mtc::value( sColumn,
                                                    aRow,
                                                    MTD_OFFSET_USE );

                    if ( sColumn->module->isNull( sColumn,
                                                  sValueTemp ) == ID_TRUE )
                    {
                        sqlInfo.setSourceInfo( aStatement,
                                               & sVerifyColumn->column->namePos );
                        IDE_RAISE( ERR_INVALID_NULL_VALUE );
                    }
                    else
                    {
                        // Nothing to do.
                    }
                }
                break;

            case QD_VERIFY_NULL:

                //  null 츸 ǽðϼ Ѵ.
                // null ƴ  
                IDE_DASSERT( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                             != SMI_COLUMN_TYPE_LOB );

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // nothing to do
                }
                else
                {
                    sqlInfo.setSourceInfo( aStatement,
                                           & sVerifyColumn->column->namePos );
                    IDE_RAISE( ERR_INVALID_LENGTH );
                }
                break;

            case QD_VERIFY_NULL_ONLY:

                //  null 츸 ǽðϼ Ѵ.
                IDE_DASSERT( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                             != SMI_COLUMN_TYPE_LOB );

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // nothing to do
                }
                else
                {
                    // recreate
                    *aMethod = *aMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                        *aMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                }
                break;

            case QD_VERIFY_NULL_OR_UNDER_SIZE:

                //  null̰ų size ۰ų  츸 ǽðϼ
                // Ѵ. ׷   
                IDE_DASSERT( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                             != SMI_COLUMN_TYPE_LOB );
                IDE_DASSERT( sVerifyColumn->size > 0 );
                IDE_DASSERT( sVerifyColumn->precision > 0 );

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // null 
                    // nothing to do
                }
                else
                {
                    sSize = sColumn->module->actualSize( sColumn,
                                                         sValueTemp );

                    IDE_TEST( sColumn->module->getPrecision( sColumn,
                                                             sValueTemp,
                                                             & sPrecision,
                                                             & sScale )
                              != IDE_SUCCESS );

                    if ( sVerifyColumn->scale == ID_SINT_MAX )
                    {
                        // precision length  ǴѴ.

                        if ( ( sSize <= sVerifyColumn->size ) &&
                             ( sPrecision <= sVerifyColumn->precision ) )
                        {
                            // length  ϴ 

                            // Nothing to do.
                        }
                        else
                        {
                            sqlInfo.setSourceInfo( aStatement,
                                                   & sVerifyColumn->column->namePos );
                            IDE_RAISE( ERR_INVALID_LENGTH );
                        }
                    }
                    else
                    {
                        // precision, scale length  ǴѴ.

                        if ( ( sSize <= sVerifyColumn->size ) &&
                             ( isEnlargingLengthForNumericType( sPrecision,
                                                                sScale,
                                                                sVerifyColumn->precision,
                                                                sVerifyColumn->scale )
                               == ID_TRUE ) )
                        {
                            // length  ϴ 

                            // Nothing to do.
                        }
                        else
                        {
                            sqlInfo.setSourceInfo( aStatement,
                                                   & sVerifyColumn->column->namePos );
                            IDE_RAISE( ERR_INVALID_LENGTH );
                        }
                    }
                }
                break;

            case QD_VERIFY_NULL_OR_EXACT_OR_UNDER_SIZE:

                //  null̰ų size   ǽðϼ Ѵ.
                //  null̰ų size   ǽð Ѵ.
                // ׷   
                IDE_DASSERT( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                             != SMI_COLUMN_TYPE_LOB );
                IDE_DASSERT( sVerifyColumn->size > 0 );
                IDE_DASSERT( sVerifyColumn->precision > 0 );

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // nothing to do
                }
                else
                {
                    sSize = sColumn->module->actualSize( sColumn,
                                                         sValueTemp );

                    IDE_TEST( sColumn->module->getPrecision( sColumn,
                                                             sValueTemp,
                                                             & sPrecision,
                                                             & sScale )
                              != IDE_SUCCESS );

                    if ( sVerifyColumn->scale == ID_SINT_MAX )
                    {
                        // precision length  ǴѴ.

                        if ( ( sSize <= sVerifyColumn->size ) &&
                             ( sPrecision == sVerifyColumn->precision ) )
                        {
                            // length  
                            // nothing to do
                        }
                        else
                        {
                            if ( ( sSize <= sVerifyColumn->size ) &&
                                 ( sPrecision <= sVerifyColumn->precision ) )
                            {
                                // length  ϴ 

                                // recreate
                                *aMethod = *aMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                                    *aMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                            }
                            else
                            {
                                sqlInfo.setSourceInfo( aStatement,
                                                       & sVerifyColumn->column->namePos );
                                IDE_RAISE( ERR_INVALID_LENGTH );
                            }
                        }
                    }
                    else
                    {
                        // precision, scale length  ǴѴ.

                        if ( ( sSize <= sVerifyColumn->size ) &&
                             ( sPrecision == sVerifyColumn->precision ) &&
                             ( sScale == sVerifyColumn->scale ) )
                        {
                            // length  

                            // Nothing to do.
                        }
                        else
                        {
                            if ( ( sSize <= sVerifyColumn->size ) &&
                                 ( isEnlargingLengthForNumericType( sPrecision,
                                                                    sScale,
                                                                    sVerifyColumn->precision,
                                                                    sVerifyColumn->scale )
                                   == ID_TRUE ) )
                            {
                                // length  ϴ 

                                // recreate
                                *aMethod = *aMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                                    *aMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                            }
                            else
                            {
                                sqlInfo.setSourceInfo( aStatement,
                                                       & sVerifyColumn->column->namePos );
                                IDE_RAISE( ERR_INVALID_LENGTH );
                            }
                        }
                    }
                }
                break;

            case QD_VERIFY_SRID:

                //  srid ȯ ϴٸ ǽðϼ Ѵ.
                // ׷   
                mtc::initializeColumn( &sCanonizedColumn, sColumn );

                // srid precision ߴ.
                sCanonizedColumn.mColumnAttr.mSridAttr.mSrid = sVerifyColumn->precision;

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // nothing to do
                }
                else
                {
                    // geometry
                    if ( sColumn->module->canonize( & sCanonizedColumn,
                                                    & sCanonizedValue,
                                                    NULL,
                                                    sColumn,
                                                    sValueTemp,
                                                    NULL,
                                                    NULL ) == IDE_SUCCESS )
                    {
                        // srid  ϴ 
                    }
                    else
                    {
                        sqlInfo.setSourceInfo( aStatement,
                                               & sVerifyColumn->column->namePos );
                        IDE_RAISE( ERR_INVALID_SRID );
                    }
                }
                break;

            default:
                IDE_DASSERT( 0 );
                break;
        }

        sVerifyColumn = sVerifyColumn->next;
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_INVALID_NULL_VALUE );
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_NULL_VALUE,
                                sqlInfo.getErrMessage()));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_INVALID_LENGTH );
    {
        (void)sqlInfo.init(aStatement->qmeMem);
        IDE_SET(ideSetErrorCode(qpERR_ABORT_QDB_INVALID_LENGTH,
                                sqlInfo.getErrMessage()));
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION( ERR_INVALID_SRID );
    {
        (void)sqlInfo.init( aStatement->qmeMem );
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QDB_INVALID_SRID,
                                  sqlInfo.getErrMessage() ) );
        (void)sqlInfo.fini();
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC qdbAlter::verifyColumnValueNullOnlyForRow(
    qdVerifyColumn       * aVerifyColumn,
    const void           * aRow,
    qdTblColModifyMethod * aMethod )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     column value  row о ˻Ѵ.
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::verifyColumnValueNullOnlyForRow"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::verifyColumnValueNullOnlyForRow"));

    qdVerifyColumn   * sVerifyColumn;
    mtcColumn        * sColumn;
    void             * sValueTemp;

    sVerifyColumn = aVerifyColumn;

    while ( sVerifyColumn != NULL )
    {
        sColumn = sVerifyColumn->column->basicInfo;

        switch ( sVerifyColumn->command )
        {
            case QD_VERIFY_NULL_ONLY:

                //  null 츸 ǽðϼ Ѵ.
                IDE_DASSERT( (sColumn->column.flag & SMI_COLUMN_TYPE_MASK)
                             != SMI_COLUMN_TYPE_LOB );

                sValueTemp = (void*)mtc::value( sColumn,
                                                aRow,
                                                MTD_OFFSET_USE );

                if ( sColumn->module->isNull( sColumn,
                                              sValueTemp ) == ID_TRUE )
                {
                    // Nothing to do.
                }
                else
                {
                    // recreate
                    *aMethod = *aMethod > QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE ?
                        *aMethod : QD_TBL_COL_MODIFY_METHOD_RECREATE_TABLE;
                }
                break;


            default:
                IDE_DASSERT( 0 );
                break;
        }

        sVerifyColumn = sVerifyColumn->next;
    }

    return IDE_SUCCESS;

#undef IDE_FN
}

idBool qdbAlter::isEnlargingLengthForNumericType( SInt aSrcPrecision,
                                                  SInt aSrcScale,
                                                  SInt aDestPrecision,
                                                  SInt aDestScale )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *    numeric type length Ȯ ˻
 *
 *    )
 *    numeric(10,2) -> numeric(10,4) 
 *    numeric(10,2) -> numeric(12,4) Ȯ
 *    numeric(1,2) -> numeric(2,2) Ȯ
 *    numeric(1,2) -> numeric(2,3) Ȯ
 *    numeric(1,-10) -> numeric(2,-10) Ȯ
 *    numeric(1,-10) -> numeric(2,-9) Ȯ
 *
 * Implementation :
 *    1. src dest numeric type ǥ  ִ upper bound lower bound 
 *    2. dest src bound ϸ length Ȯ
 *    3. bound  쵵 length Ȯ 
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::isEnlargingLengthForNumericType"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::isEnlargingLengthForNumericType"));

    idBool  sEnlarge;
    SInt    sSrcUpper;
    SInt    sSrcLower;
    SInt    sDestUpper;
    SInt    sDestLower;

    sSrcUpper = aSrcPrecision - aSrcScale;
    sSrcLower = -aSrcScale;

    sDestUpper = aDestPrecision - aDestScale;
    sDestLower = -aDestScale;

    if ( (sSrcUpper <= sDestUpper) && (sSrcLower >= sDestLower) )
    {
        sEnlarge = ID_TRUE;
    }
    else
    {
        sEnlarge = ID_FALSE;
    }

    return sEnlarge;

#undef IDE_FN
}

IDE_RC qdbAlter::isDataLossConversion( UInt     aFromTypeId,
                                       UInt     aToTypeId,
                                       idBool * aIsDataLoss )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *    data loss ߻  ִ type conversion ǴѴ.
 *
 * Implementation :
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::isDataLossConversion"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::isDataLossConversion"));

    static UInt sTypeMap[QDB_CONVERT_MATRIX_SIZE] = {
        MTD_NCHAR_ID,
        MTD_NVARCHAR_ID,
        MTD_CHAR_ID,
        MTD_VARCHAR_ID,
        MTD_CLOB_ID,
        MTD_BIGINT_ID,
        MTD_DOUBLE_ID,
        MTD_FLOAT_ID,
        MTD_INTEGER_ID,
        MTD_NUMERIC_ID,
        MTD_REAL_ID,
        MTD_SMALLINT_ID,
        MTD_DATE_ID,
        MTD_BLOB_ID,
        MTD_BYTE_ID,
        MTD_NIBBLE_ID,
        MTD_BIT_ID,
        MTD_VARBIT_ID,
        MTD_GEOMETRY_ID
    };

    static UChar sLosslessConvertMap[QDB_CONVERT_MATRIX_SIZE][QDB_CONVERT_MATRIX_SIZE] = {
                                                                       // [From]
        {  0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // nchar
        {  1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // nvarchar
        {  1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // char
        {  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // varchar
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // clob
        {  1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 },  // bigint
        {  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // double
        {  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // float
        {  1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0 },  // integer
        {  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // numeric
        {  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // real
        {  1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // smallint
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // date
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // blob
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // byte
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },  // nibble
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 },  // bit
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 },  // varbit
        {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }   // geomerty
        // [To]
        // n  n  c  v  c  b  d  f  i  n  r  s  d  b  b  n  b  v  g
        // c  v  h  a  l  i  o  l  n  u  e  m  a  l  y  i  i  a  e
        // h  a  a  r  o  g  u  o  t  m  a  a  t  o  t  b  t  r  o
        // a  r  r  c  b  i  b  a  e  e  l  l  e  b  e  b     b  m
        // r  c     h     n  l  t  g  r     l           i     i  e
        //    h     a     t  e     r  i     i           t     t  t
        //    a     r                 c     n                    r
        //    r                             t                    y
    };

    SInt    sFromTypeIdx = -1;
    SInt    sToTypeIdx   = -1;
    UInt    i;

    IDE_DASSERT( aFromTypeId != aToTypeId );

    for ( i = 0; i < QDB_CONVERT_MATRIX_SIZE; i++ )
    {
        if ( sTypeMap[i] == aFromTypeId )
        {
            sFromTypeIdx = i;
        }
        else
        {
            // Nothing to do.
        }

        if ( sTypeMap[i] == aToTypeId )
        {
            sToTypeIdx = i;
        }
        else
        {
            // Nothing to do.
        }

        if ( (sFromTypeIdx >= 0) && (sToTypeIdx >= 0) )
        {
            break;
        }
        else
        {
            // Nothing to do.
        }
    }

    // ݵ ãƾ Ѵ.
    IDE_TEST_RAISE( (sFromTypeIdx < 0) || (sToTypeIdx < 0),
                    ERR_INVALID_TYPE );

    // 1̸ ս .
    if ( sLosslessConvertMap[sFromTypeIdx][sToTypeIdx] == 1 )
    {
        * aIsDataLoss = ID_FALSE;
    }
    else
    {
        * aIsDataLoss = ID_TRUE;
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION( ERR_INVALID_TYPE )
    {
        IDE_SET( ideSetErrorCode( qpERR_ABORT_QMC_UNEXPECTED_ERROR,
                                  "qdbAlter::isDataLossConversion",
                                  "Invalid type" ));
    }
    IDE_EXCEPTION_END;

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::alterMetaForMemory( qcStatement       * aStatement,
                                     qdTableParseTree  * aParseTree,
                                     qcmTableInfo     ** aNewTableInfo,
                                     qcmTableInfo     ** aNewPartInfo )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     meta 游 alter table modify column  Ѵ.
 *
 * Implementation :
 *     - (not) null constraint 
 *     - default value 
 *
 *     memory table type  module ޸ module align
 *     ޸Ƿ ÷  ٲ  ִ.  length 
 *     size ŰǷ ü ÷ offset ų  Ƿ
 *     ᱹ type, length  Ÿ 游δ Ұϴ.
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::alterMetaForMemory"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::alterMetaForMemory"));

    qcmTableInfo          * sOldTableInfo;
    qcmColumn             * sTableColumn;
    qcmColumn             * sModifyColumn;
    mtcColumn             * sMtcColumn;
    SChar                   sDefaultValueStrNull[1] = "";
    SChar                 * sDefaultValueStr;
    void                  * sTableHandle;
    smSCN                   sSCN;

    // PROJ-1579 NCHAR
    UInt                    sBufferSize = 0;
    UInt                    sAddSize = 0;
    SChar                 * sDefValBuffer = NULL;
    qcNamePosList         * sTempNamePosList = NULL;
    qcNamePosition          sNamePos;
    
    idBool                  sIsPartitioned;
    qcmPartitionInfoList  * sPartInfoList;
    qcmTableInfo          * sPartInfo;
    UInt                    sPartCount;

    sOldTableInfo = aParseTree->tableInfo;
    sTableColumn = aParseTree->columns;
    sModifyColumn = aParseTree->modifyColumns;

    while ( sTableColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        //-----------------------------------------
        // default value 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DEFAULT_MASK)
             == QCM_COLUMN_MODIFY_DEFAULT_TRUE )
        {
            sMtcColumn = QTC_TMPL_COLUMN( QC_PRIVATE_TMPLATE(aStatement),
                                          sModifyColumn->defaultValue );

            if ( sMtcColumn->module->id == MTD_NULL_ID )
            {
                // 'i1 default NULL' 'i1 drop default' ǹѴ.
                sDefaultValueStr = sDefaultValueStrNull;
            }
            else
            {
                // PROJ-1579 NCHAR
                // Ÿ̺ ϱ  Ʈ ȯϱ 
                // N Ÿ ִ  U Ÿ ȯѴ.
                for( sTempNamePosList = sModifyColumn->ncharLiteralPos;
                     sTempNamePosList != NULL;
                     sTempNamePosList = sTempNamePosList->next )
                {
                    sNamePos = sTempNamePosList->namePos;

                    // U Ÿ ȯϸ鼭 þ  
                    // N'' => U'\C548'  ȯȴٸ
                    // '' ĳ  KSC5601̶  ,
                    // single-quote ڴ 2 byte -> 5byte ȴ.
                    // , 1.5谡 þ ̴.
                    //(ü  ƴ϶ ϴ  ϴ )
                    // ,   ĳ   𸣹Ƿ
                    // * 2  ´.
                    sAddSize += (sNamePos.size - 3) * 2;
                }

                if ( sModifyColumn->ncharLiteralPos != NULL )
                {
                    sBufferSize = sModifyColumn->defaultValue->position.size +
                        sAddSize;

                    IDU_LIMITPOINT("qdbAlter::alterMetaForMemory::malloc");
                    IDE_TEST(STRUCT_ALLOC_WITH_SIZE(aStatement->qmxMem,
                                                    SChar,
                                                    sBufferSize,
                                                    & sDefValBuffer)
                             != IDE_SUCCESS);

                    IDE_TEST( qdbCommon::convertToUTypeString(
                                  aStatement,
                                  sModifyColumn->defaultValue->position.offset,
                                  sModifyColumn->defaultValue->position.size,
                                  sModifyColumn->ncharLiteralPos,
                                  sDefValBuffer,
                                  sBufferSize )
                              != IDE_SUCCESS );

                    IDE_TEST( qdbCommon::getStrForMeta(
                                  aStatement,
                                  sDefValBuffer,
                                  idlOS::strlen( sDefValBuffer ),
                                  & sDefaultValueStr)
                              != IDE_SUCCESS );
                }
                else
                {
                    IDE_TEST( qdbCommon::getStrForMeta(
                                  aStatement,
                                  sModifyColumn->defaultValue->position.stmtText+
                                  sModifyColumn->defaultValue->position.offset,
                                  sModifyColumn->defaultValue->position.size,
                                  & sDefaultValueStr )
                              != IDE_SUCCESS );
                }
            }

            sModifyColumn->defaultValueStr = (UChar*)sDefaultValueStr;

            // update column default value
            IDE_TEST( updateColumnSpecDefault( aStatement,
                                               sModifyColumn )
                      != IDE_SUCCESS);
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (not) null 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
             == QCM_COLUMN_MODIFY_NULLABLE_NULL )
        {
            // set nullable flag to true.
            IDE_TEST( qdbCommon::updateColumnSpecNull( aStatement,
                                                       sModifyColumn,
                                                       ID_TRUE )
                      != IDE_SUCCESS );

            // not null constraint 
            IDE_TEST( deleteNotNullConstraint(
                          aStatement,
                          sOldTableInfo,
                          sModifyColumn->basicInfo->column.id )
                      != IDE_SUCCESS );

            // smiTable::modifyTableInfo table  
            // partitioned table ؼ Լ ȿ ϰ ִ.
            IDE_TEST( qdbCommon::makeColumnNullable(
                          aStatement,
                          sOldTableInfo,
                          sModifyColumn->basicInfo->column.id )
                      != IDE_SUCCESS );
        }
        else if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                  == QCM_COLUMN_MODIFY_NULLABLE_NOTNULL )
        {
            // set nullable flag to false.
            IDE_TEST( qdbCommon::updateColumnSpecNull( aStatement,
                                                       sModifyColumn,
                                                       ID_FALSE )
                      != IDE_SUCCESS );

            // not null constraint ߰
            //   not null constraint modify column شϴ
            // constraint ãƼ ߰Ѵ.
            IDE_TEST( insertNotNullConstraint( aStatement,
                                               aParseTree,
                                               sModifyColumn )
                      != IDE_SUCCESS );

            // PROJ-1502 PARTITIONED DISK TABLE
            // PROJ-2334 PMT
            if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
            {
                sPartInfoList = aParseTree->partTable->partInfoList;
                sIsPartitioned = ID_TRUE;
            }
            else
            {
                sPartInfoList = NULL;
                sIsPartitioned = ID_FALSE;
            }

            // smiTable::modifyTableInfo table  
            // partitioned table ؼ Լ ȿ ϰ ִ.
            IDE_TEST( qdbCommon::makeColumnNotNull(
                          aStatement,
                          sOldTableInfo->tableHandle,
                          sOldTableInfo->maxrows,
                          sPartInfoList,
                          sIsPartitioned,
                          sModifyColumn->basicInfo->column.id )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // srid 
        //-----------------------------------------

        if ( ( sModifyColumn->flag & QCM_COLUMN_MODIFY_SRID_MASK )
             == QCM_COLUMN_MODIFY_SRID_TRUE )
        {
            IDE_TEST( updateColumnSpecSRID( aStatement,
                                            sModifyColumn )
                      != IDE_SUCCESS );
            
            // PROJ-1502 PARTITIONED DISK TABLE
            // PROJ-2334 PMT
            if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
            {
                sPartInfoList = aParseTree->partTable->partInfoList;
                sIsPartitioned = ID_TRUE;
            }
            else
            {
                sPartInfoList = NULL;
                sIsPartitioned = ID_FALSE;
            }

            // smiTable::modifyTableInfo table  
            // partitioned table ؼ Լ ȿ ϰ ִ.
            IDE_TEST( qdbCommon::makeColumnSRID( aStatement,
                                                 sOldTableInfo->tableHandle,
                                                 sOldTableInfo->maxrows,
                                                 sPartInfoList,
                                                 sIsPartitioned,
                                                 sModifyColumn->basicInfo->column.id,
                                                 sModifyColumn->basicInfo->mColumnAttr.mSridAttr.mSrid )
                      != IDE_SUCCESS );
        }
        else
        {
            // Nothing to do.
        }
        
        //-----------------------------------------
        // type, length 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK)
             == QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE )
        {
            // column option  

            // alter meta ddl   .
            IDE_DASSERT( 0 );
        }
        else
        {
            //  type, length 

            // Nothing to do.
        }

        sTableColumn = sTableColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    //-----------------------------------------
    // table spec 
    //-----------------------------------------

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  aParseTree->userName,
                  aParseTree->tableName,
                  sOldTableInfo->tableID,
                  smiGetTableId( sOldTableInfo->tableHandle ),
                  sOldTableInfo->columnCount,
                  sOldTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sOldTableInfo->tableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS);

    //-----------------------------------------
    // cached meta 
    //-----------------------------------------

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sOldTableInfo->tableID,
                                           smiGetTableId( sOldTableInfo->tableHandle ) )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sOldTableInfo->tableID,
                                     aNewTableInfo,
                                     & sSCN,
                                     & sTableHandle )
              != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    // PROJ-2334 PMT
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        aParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );

        IDE_DASSERT( aNewPartInfo != NULL );

        sPartCount = 0;

        for ( sPartInfoList = aParseTree->partTable->partInfoList;
              sPartInfoList != NULL;
              sPartInfoList = sPartInfoList->next )
        {
            sPartInfo = sPartInfoList->partitionInfo;

            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          sPartInfo->partitionID,
                          smiGetTableId( sPartInfo->tableHandle ),
                          *aNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            IDE_TEST( qcmPartition::getPartitionInfoByID(
                          aStatement,
                          sPartInfo->partitionID,
                          & aNewPartInfo[sPartCount],
                          & sSCN,
                          & sTableHandle )
                      != IDE_SUCCESS );

            sPartCount++;
        }
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    // qdbAlter::executeModifyCol() Meta Cache ޸𸮸 Ѵ.

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::alterMetaForDisk( qcStatement       * aStatement,
                                   qdTableParseTree  * aParseTree,
                                   qcmTableInfo     ** aNewTableInfo,
                                   qcmTableInfo     ** aNewPartInfo )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     meta 游 alter table modify column  Ѵ.
 *
 * Implementation :
 *     - (not) null constraint 
 *     - default value 
 *     - type, length 
 *
 *       type length  table ü column offset, size
 *       Ű column id,   ʴ´.
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::alterMetaForDisk"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::alterMetaForDisk"));

    qcmTableInfo          * sOldTableInfo;
    idBool                  sIsPartitioned;
    qcmPartitionInfoList  * sPartInfoList;
    qcmTableInfo          * sPartInfo;
    UInt                    sPartCount;
    smSCN                   sSCN;
    void                  * sTableHandle;
    qcmColumn             * sTableColumn;
    qcmColumn             * sModifyColumn;
    qcmColumn             * sNewColumn;
    mtcColumn             * sNewMtcColumn;
    qcmColumn             * sNewTableColumn;
    mtcColumn             * sNewTableMtcColumn;
    mtcColumn             * sMtcColumn;
    UInt                    sColumnCount;
    UInt                    sCurrentOffset;
    UInt                    i;

    sOldTableInfo = aParseTree->tableInfo;

    //-----------------------------------------
    // new table column 
    //-----------------------------------------

    // new table column 
    sColumnCount = sOldTableInfo->columnCount;

    IDU_LIMITPOINT("qdbAlter::alterMetaForDisk::malloc1");
    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(qcmColumn) * sColumnCount,
                                         (void**) &sNewTableColumn )
              != IDE_SUCCESS );

    IDU_LIMITPOINT("qdbAlter::alterMetaForDisk::malloc2");
    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(mtcColumn) * sColumnCount,
                                         (void**) &sNewTableMtcColumn)
              != IDE_SUCCESS );

    // new table column ʱȭ
    idlOS::memcpy( (void*) sNewTableColumn,
                   (void*) sOldTableInfo->columns,
                   ID_SIZEOF(qcmColumn) * sColumnCount );

    for ( i = 0; i < sColumnCount; i++ )
    {
        idlOS::memcpy( (void*) &sNewTableMtcColumn[i],
                       (void*) sNewTableColumn[i].basicInfo,
                       ID_SIZEOF(mtcColumn) );

        sNewTableColumn[i].basicInfo = &sNewTableMtcColumn[i];
    }

    // new table column 
    sTableColumn = aParseTree->columns;
    sModifyColumn = aParseTree->modifyColumns;

    while ( sTableColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        // sModifyColumn شϴ sNewTableColumn ã´.
        sNewColumn = NULL;
        sNewMtcColumn = NULL;

        for ( i = 0; i < sColumnCount; i++ )
        {
            // sModifyColumn->basicInfo->column.id ǾǷ
            // column.id Ѵ.
            if ( sModifyColumn->basicInfo->column.id ==
                 sNewTableColumn[i].basicInfo->column.id )
            {
                sNewColumn = & sNewTableColumn[i];
                sNewMtcColumn = & sNewTableMtcColumn[i];
                break;
            }
            else
            {
                // Nothing to do.
            }
        }

        // ݵ Ѵ.
        IDE_ASSERT( sNewColumn != NULL );
        IDE_ASSERT( sNewMtcColumn != NULL );

        // sNewTableColumn sModifyColumn Ѵ.
        // (sNewColumn->next  Ŀ Ѵ.)
        idlOS::memcpy( (void*) sNewColumn,
                       (void*) sModifyColumn,
                       ID_SIZEOF(qcmColumn) );

        idlOS::memcpy( (void*) sNewMtcColumn,
                       (void*) sModifyColumn->basicInfo,
                       ID_SIZEOF(mtcColumn) );

        // tableColumn  Ѵ.
        // not null flag
        sNewColumn->basicInfo->flag &= ~MTC_COLUMN_NOTNULL_MASK;
        sNewColumn->basicInfo->flag |=
            (sTableColumn->basicInfo->flag & MTC_COLUMN_NOTNULL_MASK);
        // default value
        sNewColumn->defaultValueStr = sTableColumn->defaultValueStr;
        /* PROJ-1090 Function-based Index */
        sNewColumn->flag &= ~QCM_COLUMN_HIDDEN_COLUMN_MASK;
        sNewColumn->flag |= (sTableColumn->flag & QCM_COLUMN_HIDDEN_COLUMN_MASK);

        //-----------------------------------------
        // default value 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_DEFAULT_MASK)
             == QCM_COLUMN_MODIFY_DEFAULT_TRUE )
        {
            sMtcColumn = QTC_TMPL_COLUMN( QC_PRIVATE_TMPLATE(aStatement),
                                          sNewColumn->defaultValue );

            if ( sMtcColumn->module->id == MTD_NULL_ID )
            {
                // 'i1 default NULL' 'i1 drop default' ǹѴ.
                sNewColumn->defaultValue = NULL;
            }
            else
            {
                // Nothing to do.
            }

            //  default value ʱȭѴ.
            sNewColumn->defaultValueStr = NULL;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // (not) null 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
             == QCM_COLUMN_MODIFY_NULLABLE_NULL )
        {
            // not null constraint 
            IDE_TEST( deleteNotNullConstraint(
                          aStatement,
                          sOldTableInfo,
                          sNewColumn->basicInfo->column.id )
                      != IDE_SUCCESS );

            // smiTable::modifyTableInfo table  
            // partitioned table ؼ Լ ȿ ϰ ִ.
            IDE_TEST( qdbCommon::makeColumnNullable(
                          aStatement,
                          sOldTableInfo,
                          sNewColumn->basicInfo->column.id )
                      != IDE_SUCCESS );

            // nullable flag Ѵ.
            sNewColumn->basicInfo->flag &= ~MTC_COLUMN_NOTNULL_MASK;
            sNewColumn->basicInfo->flag |= MTC_COLUMN_NOTNULL_FALSE;
        }
        else if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_NULLABLE_MASK)
                  == QCM_COLUMN_MODIFY_NULLABLE_NOTNULL )
        {
            // not null constraint ߰
            //   not null constraint modify column شϴ
            // constraint ãƼ ߰Ѵ.
            IDE_TEST( insertNotNullConstraint( aStatement,
                                               aParseTree,
                                               sNewColumn )
                      != IDE_SUCCESS );

            // PROJ-1502 PARTITIONED DISK TABLE
            if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
            {
                sPartInfoList = aParseTree->partTable->partInfoList;
                sIsPartitioned = ID_TRUE;
            }
            else
            {
                sPartInfoList = NULL;
                sIsPartitioned = ID_FALSE;
            }

            // smiTable::modifyTableInfo table  
            // partitioned table ؼ Լ ȿ ϰ ִ.
            IDE_TEST( qdbCommon::makeColumnNotNull(
                          aStatement,
                          sOldTableInfo->tableHandle,
                          sOldTableInfo->maxrows,
                          sPartInfoList,
                          sIsPartitioned,
                          sNewColumn->basicInfo->column.id )
                      != IDE_SUCCESS );

            // not null flag Ѵ.
            sNewColumn->basicInfo->flag &= ~MTC_COLUMN_NOTNULL_MASK;
            sNewColumn->basicInfo->flag |= MTC_COLUMN_NOTNULL_TRUE;
        }
        else
        {
            // Nothing to do.
        }

        //-----------------------------------------
        // type, length 
        //-----------------------------------------

        if ( (sModifyColumn->flag & QCM_COLUMN_MODIFY_COLUMN_OPTION_MASK)
             == QCM_COLUMN_MODIFY_COLUMN_OPTION_TRUE )
        {
            // column option  

            // Nothing to do.
        }
        else
        {
            //  type, length 

            // Nothing to do.
        }

        sTableColumn = sTableColumn->next;
        sModifyColumn = sModifyColumn->next;
    }

    //-----------------------------------------
    // modify  ƴ  ÷  default value  
    //-----------------------------------------

    for ( i = 0; i < sColumnCount; i++ )
    {
        // fix BUG-14204
        if ( sNewTableColumn[i].defaultValueStr != NULL )
        {
            // old column default value ̿ϱ 
            // dummy qtcNode δ.
            IDU_LIMITPOINT("qdbAlter::alterMetaForDisk::malloc3");
            IDE_TEST( aStatement->qmxMem->alloc(
                          ID_SIZEOF(qtcNode),
                          (void**) & sNewTableColumn[i].defaultValue )
                      != IDE_SUCCESS );

            // PROJ-1579 NCHAR
            // old column default value ̹ Ÿ ̺ Ǿ 
            sNewTableColumn[i].ncharLiteralPos = NULL;
        }
        else
        {
            // Nothing to do.
        }
    }

    //-----------------------------------------
    // sNewTableColumn next Ѵ.
    //-----------------------------------------

    for ( i = 0; i < sColumnCount - 1; i++ )
    {
        sNewTableColumn[i].next = & sNewTableColumn[i + 1];
    }
    sNewTableColumn[i].next = NULL;

    //-----------------------------------------
    // new table column offset 
    //-----------------------------------------

    IDE_DASSERT( smiTableSpace::isDiskTableSpaceType( sOldTableInfo->TBSType )
                 == ID_TRUE );

    // disk table̹Ƿ record header size  ʾ offset 0 Ѵ.
    sCurrentOffset = 0;

    // disk table schema memory table  ˻ϴ 
    // column id  ʴ´.
    IDE_TEST( qdbCommon::setColListOffset( aStatement->qmxMem,
                                           sNewTableColumn,
                                           sCurrentOffset )
              != IDE_SUCCESS );

    //-----------------------------------------
    // column spec 
    //-----------------------------------------

    // delete invalidated column spec from meta.
    IDE_TEST( deleteColumnSpecFromMeta( aStatement,
                                        sOldTableInfo->tableID )
              != IDE_SUCCESS );

    // insert new column spec into meta.
    IDE_TEST( qdbCommon::insertColumnSpecIntoMeta( aStatement,
                                                   aParseTree->userID,
                                                   sOldTableInfo->tableID,
                                                   sNewTableColumn,
                                                   ID_FALSE /* is queue */)
              != IDE_SUCCESS );

    // smiTable::modifyTableInfo table  
    // partitioned table ؼ Լ ȿ ϰ ִ.
    IDE_TEST( qdbCommon::makeColumnNewType( aStatement,
                                            sOldTableInfo,
                                            sNewTableColumn )
              != IDE_SUCCESS );

    //-----------------------------------------
    // table spec 
    //-----------------------------------------

    // fix BUG-14394
    IDE_TEST( qdbCommon::updateTableSpecFromMeta(
                  aStatement,
                  aParseTree->userName,
                  aParseTree->tableName,
                  sOldTableInfo->tableID,
                  smiGetTableId( sOldTableInfo->tableHandle ),
                  sOldTableInfo->columnCount,
                  sOldTableInfo->parallelDegree )
              != IDE_SUCCESS );

    IDE_TEST( qcm::touchTable( QC_SMI_STMT( aStatement ),
                               sOldTableInfo->tableID,
                               SMI_TBSLV_DDL_DML )
              != IDE_SUCCESS);

    //-----------------------------------------
    // cached meta 
    //-----------------------------------------

    IDE_TEST( qcm::makeAndSetQcmTableInfo( QC_SMI_STMT( aStatement ),
                                           sOldTableInfo->tableID,
                                           smiGetTableId( sOldTableInfo->tableHandle ) )
              != IDE_SUCCESS );

    IDE_TEST( qcm::getTableInfoByID( aStatement,
                                     sOldTableInfo->tableID,
                                     aNewTableInfo,
                                     & sSCN,
                                     & sTableHandle )
              != IDE_SUCCESS);

    // PROJ-1502 PARTITIONED DISK TABLE
    if ( sOldTableInfo->tablePartitionType == QCM_PARTITIONED_TABLE )
    {
        IDE_TEST( qcmPartition::touchPartitionInfoList( QC_SMI_STMT( aStatement ),
                                                        aParseTree->partTable->partInfoList )
                  != IDE_SUCCESS );

        IDE_DASSERT( aNewPartInfo != NULL );

        sPartCount = 0;

        for( sPartInfoList = aParseTree->partTable->partInfoList;
             sPartInfoList != NULL;
             sPartInfoList = sPartInfoList->next )
        {
            sPartInfo = sPartInfoList->partitionInfo;

            IDE_TEST( qcmPartition::makeAndSetQcmPartitionInfo(
                          QC_SMI_STMT( aStatement ),
                          sPartInfo->partitionID,
                          smiGetTableId( sPartInfo->tableHandle ),
                          *aNewTableInfo,
                          NULL )
                      != IDE_SUCCESS );

            IDE_TEST( qcmPartition::getPartitionInfoByID(
                          aStatement,
                          sPartInfo->partitionID,
                          & aNewPartInfo[sPartCount],
                          & sSCN,
                          & sTableHandle )
                      != IDE_SUCCESS );

            sPartCount++;
        }
    }
    else
    {
        // Nothing to do.
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    // qdbAlter::executeModifyCol() Meta Cache ޸𸮸 Ѵ.

    return IDE_FAILURE;

#undef IDE_FN
}

IDE_RC qdbAlter::recreateTableForMemory( qcStatement       * aStatement,
                                         qdTableParseTree  * aParseTree,
                                         qcmTableInfo     ** aNewTableInfo,
                                         qcmTableInfo     ** aNewPartInfo )
{
 /***********************************************************************
 *
 * Description : PROJ-1877
 *     table  table  ü(index) 
 *     alter table modify column  Ѵ.
 *
 * Implementation :
 *     1. memory table  re-create table.
 *     2. memory partitioned table  re-create table.
 *
 ***********************************************************************/

#define IDE_FN "qdbAlter::recreateTableForMemory"
    IDE_MSGLOG_FUNC(IDE_MSGLOG_BODY("qdbAlter::recreateTableForMemory"));

    qcmTableInfo          * sNewTableInfo = NULL;
    qcmTableInfo          * sOldTableInfo;
    smSCN                   sSCN;
    void                  * sTableHandle;
    qcmColumn             * sTableColumn;
    qcmColumn             * sModifyColumn;
    qcmColumn             * sNewColumn;
    qcmColumn             * sNewTableColumn;
    mtcColumn             * sNewMtcColumn;
    qcmIndex              * sNewTableIndex;
    mtcColumn             * sMtcColumn;
    UInt                    sColumnCount;
    UInt                    sCurrentOffset;
    smOID                   sNewTableOID;
    const void            * sNewTableHandle;
    qcmColumn             * sModifyColumns;
    qdConstraintSpec      * sConstraint;
    UInt                    i;
    
    const void            * sNewPartTableHandle;
    qcmTableInfo          * sOldPartInfo;
    qcmPartitionInfoList  * sPartInfoList;
    smOID                 * sNewPartitionOID   = NULL;
    UInt                    sPartitionCount    = 0;
    qcmIndex             ** sNewPartIndex      = NULL;
    UInt                    sNewPartIndexCount = 0;

    
    sOldTableInfo = aParseTree->tableInfo;
    
    //-----------------------------------------
    // new table column 
    //-----------------------------------------

    // new table column 
    sColumnCount = sOldTableInfo->columnCount;

    IDU_LIMITPOINT( "qdbAlter::recreateTableForMemory::malloc1");
    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(qcmColumn) * sColumnCount,
                                         (void**) &sNewTableColumn )
              != IDE_SUCCESS);

    IDU_LIMITPOINT( "qdbAlter::recreateTableForMemory::malloc2");
    IDE_TEST( aStatement->qmxMem->alloc( ID_SIZEOF(mtcColumn) * sColumnCount,
                                         (void**) &sNewMtcColumn)
              != IDE_SUCCESS);

    // new table column ʱȭ
    idlOS::memcpy( (void*) sNewTableColumn,
                   (void*) sOldTableInfo->columns,
                   ID_SIZEOF(qcmColumn) * sColumnCount );

    for ( i = 0; i < sColumnCount; i++ )
    {
        idlOS::memcpy( (void*) &sNewMtcColumn[i],
                       (void*) sNewTableColumn[i].basicInfo,
                       ID_SIZEOF(mtcColumn) );

        sNewTableColumn[i].basicInfo = &sNewMtcColumn[i];
    }

    // new table column 
    sTableColumn = aParseTree->columns;
    sModifyColumn = aParseTree->modifyColumns;

    while ( sTableColumn != NULL )
    {
        IDE_DASSERT( sModifyColumn != NULL );

        // sModifyColumn شϴ sNewTableColumn ã´.
        sNewColumn = NULL;

        for ( i = 0; i < sColumnCount; i++ )
        {
            // sModifyColumn->basicInfo->column.id ǾǷ
            // column.id Ѵ.
            if ( sModifyColumn->basicInfo->column.id ==
                 sNewTableColumn[i].basicInfo->column.id )
            {
                sNewColumn = & sNewTableColumn[i];
                break;
            }
            else
            {
                // Nothing to do.
            }
        }

        // ݵ Ѵ.
        IDE_ASSERT( sNewColumn != NULL );

        // sNewTableColumn sModifyColumn Ѵ.
        // (sNewColumn->next  Ŀ Ѵ.)
        idlOS::memcpy( (