/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id$
 *
 * Description :
 *     Semi join graph   Լ
 *
 *   :
 *
 *  :
 *
 **********************************************************************/

#include <ide.h>
#include <qmgSemiJoin.h>
#include <qmoOneNonPlan.h>
#include <qmoOneMtrPlan.h>
#include <qmoTwoNonPlan.h>
#include <qmoSelectivity.h>
#include <qmgJoin.h>
#include <qmo.h>

IDE_RC
qmgSemiJoin::init( qcStatement * aStatement,
                   qmgGraph    * aLeftGraph,
                   qmgGraph    * aRightGraph,
                   qmgGraph    * aGraph )
{
/***********************************************************************
 *
 * Description : qmgSemiJoin Graph ʱȭ
 *
 * Implementation :
 *    (1)  qmgSemiJoin   Ҵ
 *    (2)  graph(  Graph   ڷ  ) ʱȭ
 *    (3)  graph.type 
 *    (4)  graph.myQuerySet aQuerySet 
 *    (5)  graph.myFrom aFrom 
 *    (6)  graph.dependencies 
 *    (7)  qmgJoin onConditonCNF ó
 *    (8)  graph   ʱȭ
 *    (9)  graph.optimize graph.makePlan 
 *    (10) out 
 *
 ***********************************************************************/

    qmgJOIN   * sMyGraph;
    qcDepInfo   sOrDependencies;

    IDU_FIT_POINT_FATAL( "qmgSemiJoin::init::__FT__" );

    //------------------------------------------
    // ռ ˻
    //------------------------------------------

    IDE_DASSERT( aStatement != NULL );
    IDE_DASSERT( aLeftGraph != NULL );
    IDE_DASSERT( aRightGraph != NULL );
    IDE_DASSERT( aGraph != NULL );

    //---------------------------------------------------
    // Semi Join Graph  ⺻ ʱȭ
    //---------------------------------------------------

    sMyGraph = (qmgJOIN *)aGraph;

    // Graph   ʱȭ
    IDE_TEST( qmg::initGraph( & sMyGraph->graph ) != IDE_SUCCESS );

    // Graph  ǥ
    sMyGraph->graph.type = QMG_SEMI_JOIN;
    sMyGraph->graph.left  = aLeftGraph;
    sMyGraph->graph.right = aRightGraph;

    sMyGraph->graph.myFrom = NULL;
    sMyGraph->graph.myQuerySet = aLeftGraph->myQuerySet;

    IDE_TEST( qtc::dependencyOr( & aLeftGraph->depInfo,
                                 & aRightGraph->depInfo,
                                 & sOrDependencies )
              != IDE_SUCCESS );

    qtc::dependencySetWithDep( & sMyGraph->graph.depInfo,
                               & sOrDependencies );

    // Graph Լ ͸ 
    sMyGraph->graph.optimize = qmgSemiJoin::optimize;
    sMyGraph->graph.makePlan = qmgJoin::makePlan;
    sMyGraph->graph.printGraph = qmgJoin::printGraph;

    // Disk/Memory  
    switch(  sMyGraph->graph.myQuerySet->SFWGH->hints->interResultType )
    {
        case QMO_INTER_RESULT_TYPE_NOT_DEFINED :
            // ߰  Type Hint  ,
            // left disk̸ disk
            if ( ( sMyGraph->graph.left->flag & QMG_GRAPH_TYPE_MASK )
                   == QMG_GRAPH_TYPE_DISK )
            {
                sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
                sMyGraph->graph.flag |= QMG_GRAPH_TYPE_DISK;
            }
            else
            {
                sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
                sMyGraph->graph.flag |= QMG_GRAPH_TYPE_MEMORY;
            }
            break;
        case QMO_INTER_RESULT_TYPE_DISK :
            sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
            sMyGraph->graph.flag |= QMG_GRAPH_TYPE_DISK;
            break;
        case QMO_INTER_RESULT_TYPE_MEMORY :
            sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
            sMyGraph->graph.flag |= QMG_GRAPH_TYPE_MEMORY;
            break;
        default :
            IDE_DASSERT( 0 );
            break;
    }

    //---------------------------------------------------
    // Semi Join Graph   ڷ  ʱȭ
    //---------------------------------------------------

    // Semi join ڰ   Ƿ ON  ʴ´.
    sMyGraph->onConditionCNF = NULL;

    sMyGraph->joinMethods = NULL;
    sMyGraph->joinablePredicate = NULL;
    sMyGraph->nonJoinablePredicate = NULL;
    sMyGraph->hashBucketCnt = 0;
    sMyGraph->hashTmpTblCnt = 0;

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

IDE_RC
qmgSemiJoin::optimize( qcStatement * aStatement, qmgGraph * aGraph )
{
/***********************************************************************
 *
 * Description : qmgSemiJoin Graph ȭ
 *
 * Implementation :
 *    (0) left graph ȭ 
 *    (1) right graph ȭ 
 *    (2) subquery ó
 *    (3) Join Method ʱȭ
 *    (4) Join Method 
 *    (5) Join Method   ó
 *    (6)    
 *    (7) Preserved Order, DISK/MEMORY 
 *
 ***********************************************************************/

    qmgJOIN           * sMyGraph;
    qmoPredicate      * sPredicate;

    IDU_FIT_POINT_FATAL( "qmgSemiJoin::optimize::__FT__" );

    //------------------------------------------
    // ռ ˻
    //------------------------------------------

    IDE_DASSERT( aStatement != NULL );
    IDE_DASSERT( aGraph != NULL );

    //------------------------------------------
    // ⺻ ʱȭ
    //------------------------------------------

    sMyGraph = (qmgJOIN*) aGraph;

    // On condition  Ƿ left right optimization ʿ.

    // BUG-32703
    // ȭ ÿ view graph ȴ
    // left outer join  graph view ִٸ
    // ȭ Ŀ ( , view graph ȭ  Ŀ )
    // left outer join  type ( disk or memory )  ؾ Ѵ.
    // BUG-40191 __OPTIMIZER_DEFAULT_TEMP_TBS_TYPE Ʈ ؾ Ѵ.
    if ( aGraph->myQuerySet->SFWGH->hints->interResultType == QMO_INTER_RESULT_TYPE_NOT_DEFINED )
    {
        if ( ( sMyGraph->graph.left->flag & QMG_GRAPH_TYPE_MASK )
               == QMG_GRAPH_TYPE_DISK )
        {
            sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
            sMyGraph->graph.flag |= QMG_GRAPH_TYPE_DISK;
        }
        else
        {
            sMyGraph->graph.flag &= ~QMG_GRAPH_TYPE_MASK;
            sMyGraph->graph.flag |= QMG_GRAPH_TYPE_MEMORY;
        }
    }
    else
    {
        // nothing to do
    }

    if ( sMyGraph->graph.myPredicate != NULL )
    {
        /* TASK-7219 Non-shard DML */
        IDE_TEST( qmo::removeOutRefPredPushedForce( & sMyGraph->graph.myPredicate )
                  != IDE_SUCCESS );
    }
    else
    {
        // Nothing to do.
    }

    //------------------------------------------
    // Subquery Graph 
    // - To Fix BUG-10577
    //   Left, Right ȭ Ŀ subquery graph ؾ  view϶
    //   view   ̱  ϴ  ߻ ʴ´.
    //   ( = BUG-9736 )
    //   Predicate з dependencies ϱ  predicate
    //   Subquery graph   ص ȴ.
    //------------------------------------------

    if ( sMyGraph->graph.myPredicate != NULL )
    {
        IDE_TEST( qmoPred::optimizeSubqueries( aStatement,
                                               sMyGraph->graph.myPredicate,
                                               ID_FALSE )  // No KeyRange Tip
                  != IDE_SUCCESS );

        IDE_TEST(
            qmoPred::classifyJoinPredicate( aStatement,
                                            sMyGraph->graph.myPredicate,
                                            sMyGraph->graph.left,
                                            sMyGraph->graph.right,
                                            & sMyGraph->graph.depInfo )
            != IDE_SUCCESS );

        // To fix BUG-26885
        // DNF join Ǵ  materialize  predicate
        //  Ʃ ġ ٲ  Ƿ
        // join predicate Ѵ.
        if( aGraph->myQuerySet->SFWGH->crtPath->currentNormalType
            == QMO_NORMAL_TYPE_DNF )
        {   
            IDE_TEST(qmoPred::copyPredicate4Partition(
                         aStatement,
                         sMyGraph->graph.myPredicate,
                         &sPredicate,
                         0,
                         0,
                         ID_TRUE )
                     != IDE_SUCCESS );
        
            sMyGraph->graph.myPredicate = sPredicate;
        }
        else
        {
            // CNF̰ų NNF   ʿ䰡 .
            // Nothing To Do
        }
    }
    else
    {
        // Join Graph شϴ Predicate  
        // Nothing To Do
    }

    //------------------------------------------
    // Selectivity 
    //------------------------------------------

    // WHERE clause, ON clause   
    IDE_TEST( qmoSelectivity::setJoinSelectivity(
                  aStatement,
                  & sMyGraph->graph,
                  sMyGraph->graph.myPredicate,
                  & sMyGraph->graph.costInfo.selectivity )
              != IDE_SUCCESS );

    //------------------------------------------
    // Join Method ʱȭ
    //------------------------------------------

    // Join Method  Ҵ
    IDE_TEST( QC_QMP_MEM(aStatement)->alloc( ID_SIZEOF( qmoJoinMethod ) * QMG_SEMI_JOIN_METHOD_COUNT,
                                             (void **) &sMyGraph->joinMethods )
              != IDE_SUCCESS );

    // nested loop join method ʱȭ
    IDE_TEST( qmoJoinMethodMgr::init( aStatement,
                                      & sMyGraph->graph,
                                      sMyGraph->firstRowsFactor,
                                      sMyGraph->graph.myPredicate,
                                      QMO_JOIN_METHOD_NL,
                                      &sMyGraph->joinMethods[QMG_SEMI_JOIN_METHOD_NESTED] )
              != IDE_SUCCESS );

    // hash based join method ʱȭ
    IDE_TEST( qmoJoinMethodMgr::init( aStatement,
                                      & sMyGraph->graph,
                                      sMyGraph->firstRowsFactor,
                                      sMyGraph->graph.myPredicate,
                                      QMO_JOIN_METHOD_HASH,
                                      &sMyGraph->joinMethods[QMG_SEMI_JOIN_METHOD_HASH] )
              != IDE_SUCCESS );

    // sort based join method ʱȭ
    IDE_TEST( qmoJoinMethodMgr::init( aStatement,
                                      & sMyGraph->graph,
                                      sMyGraph->firstRowsFactor,
                                      sMyGraph->graph.myPredicate,
                                      QMO_JOIN_METHOD_SORT,
                                      &sMyGraph->joinMethods[QMG_SEMI_JOIN_METHOD_SORT] )
              != IDE_SUCCESS );

    // merge join method ʱȭ
    IDE_TEST( qmoJoinMethodMgr::init( aStatement,
                                      & sMyGraph->graph,
                                      sMyGraph->firstRowsFactor,
                                      sMyGraph->graph.myPredicate,
                                      QMO_JOIN_METHOD_MERGE,
                                      &sMyGraph->joinMethods[QMG_SEMI_JOIN_METHOD_MERGE] )
              != IDE_SUCCESS );

    // Semi join  join method selectivity 
    setJoinMethodsSelectivity( &sMyGraph->graph );

    //------------------------------------------
    //  Join Method    cost Join Method 
    //------------------------------------------

    IDE_TEST(
        qmgJoin::selectJoinMethodCost( aStatement,
                                       & sMyGraph->graph,
                                       sMyGraph->graph.myPredicate,
                                       sMyGraph->joinMethods,
                                       & sMyGraph->selectedJoinMethod )
        != IDE_SUCCESS );

    //------------------------------------------
    //    
    //------------------------------------------

    // record size 
    // Semi join left record  Ѵ.
    sMyGraph->graph.costInfo.recordSize =
        sMyGraph->graph.left->costInfo.recordSize;

    // BUG-37134 semi join, anti join  setJoinOrderFactor  ȣؾմϴ.
    //  qmgJoin  joinOrderFactor, joinSize 
    IDE_TEST( qmoSelectivity::setJoinOrderFactor(
                  aStatement,
                  & sMyGraph->graph,
                  sMyGraph->graph.myPredicate,
                  &sMyGraph->joinOrderFactor,
                  &sMyGraph->joinSize )
              != IDE_SUCCESS );

    // input record count 
    sMyGraph->graph.costInfo.inputRecordCnt =
        sMyGraph->graph.left->costInfo.outputRecordCnt;

    // BUG-37407 semi, anti join cost
    // output record count 
    sMyGraph->graph.costInfo.outputRecordCnt =
        sMyGraph->graph.left->costInfo.outputRecordCnt *
        sMyGraph->graph.costInfo.selectivity;

    sMyGraph->graph.costInfo.outputRecordCnt =
        IDL_MAX( sMyGraph->graph.costInfo.outputRecordCnt, 1.0 );

    // My Cost 
    sMyGraph->graph.costInfo.myAccessCost =
        sMyGraph->selectedJoinMethod->accessCost;
    sMyGraph->graph.costInfo.myDiskCost =
        sMyGraph->selectedJoinMethod->diskCost;
    sMyGraph->graph.costInfo.myAllCost =
        sMyGraph->selectedJoinMethod->totalCost;

    // Total Cost 
    // Join Graph ü Cost ̹ Child Cost  ϰ ִ.
    sMyGraph->graph.costInfo.totalAccessCost =
        sMyGraph->graph.costInfo.myAccessCost;
    sMyGraph->graph.costInfo.totalDiskCost =
        sMyGraph->graph.costInfo.myDiskCost;
    sMyGraph->graph.costInfo.totalAllCost =
        sMyGraph->graph.costInfo.myAllCost;

    //------------------------------------------
    // Join Method   ó
    //------------------------------------------

    // PROJ-2179
    sMyGraph->pushedDownPredicate = sMyGraph->graph.myPredicate;

    IDE_TEST(
        qmgJoin::afterJoinMethodDecision(
            aStatement,
            & sMyGraph->graph,
            sMyGraph->selectedJoinMethod,
            & sMyGraph->graph.myPredicate,
            & sMyGraph->joinablePredicate,
            & sMyGraph->nonJoinablePredicate)
        != IDE_SUCCESS );

    //------------------------------------------
    // Preserved Order
    //------------------------------------------

    IDE_TEST( qmgJoin::makePreservedOrder( aStatement,
                                           & sMyGraph->graph,
                                           sMyGraph->selectedJoinMethod,
                                           sMyGraph->joinablePredicate )
              != IDE_SUCCESS );
 
    // BUG-38279 Applying parallel query
    aGraph->flag &= ~QMG_PARALLEL_EXEC_MASK;
    aGraph->flag |= ((aGraph->left->flag & QMG_PARALLEL_EXEC_MASK) |
                     (aGraph->right->flag & QMG_PARALLEL_EXEC_MASK));

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

void
qmgSemiJoin::setJoinMethodsSelectivity( qmgGraph * aGraph )
{
/***********************************************************************
 *
 * Description :
 *     Semi/anti join join method selectivity Ѵ.
 *
 * Implementation :
 *     Nested loop join stored nested loop join  
 *      join method selectivity 0 Ѵ.
 *       join method selectivity   ٸ ݸ
 *      method selectivity   semi/anti join
 *       ϱ ̴.
 *
 ***********************************************************************/

    qmgJOIN           * sMyGraph;
    qmoJoinMethodCost * sJoinMethodCost;
    UInt                i, j;

    //------------------------------------------
    // ռ ˻
    //------------------------------------------

    IDE_DASSERT( aGraph != NULL );

    //------------------------------------------
    // ⺻ ʱȭ
    //------------------------------------------

    sMyGraph = (qmgJOIN*) aGraph;

    for( i = 0; i < QMG_SEMI_JOIN_METHOD_COUNT; i++ )
    {
        for( j = 0; j < sMyGraph->joinMethods[i].joinMethodCnt; j++ )
        {
            sJoinMethodCost = &sMyGraph->joinMethods[i].joinMethodCost[j];
            switch( sJoinMethodCost->flag & QMO_JOIN_METHOD_MASK )
            {
                case QMO_JOIN_METHOD_FULL_NL:
                case QMO_JOIN_METHOD_FULL_STORE_NL:
                    break;
                default:
                    sMyGraph->joinMethods[i].joinMethodCost[j].selectivity = 0;
                    break;
            }
        }
    }

}
