/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: smmTBSPhase.h 19201 2006-11-30 00:54:40Z kmkim $
 **********************************************************************/

#ifndef _O_SMM_TBS_MULTI_PHASE_H_
#define _O_SMM_TBS_MULTI_PHASE_H_ 1

#include <idu.h>
#include <iduMemPool.h>
#include <idp.h>
#include <smDef.h>
#include <smmDef.h>
#include <smu.h>

/*
  [] SMMȿ File Layer   .
          Layer ڵ忡  Layer ڵ带   .

  ----------------------------------------------------------------------------
  smmTBSCreate          ; Create Tablespace 
  smmTBSDrop            ; Drop Tablespace 
  smmTBSAlterAutoExtend ; Alter Tablespace Auto Extend 
  smmTBSAlterChkptPath  ; Alter Tablespace Add/Rename/Drop Checkpoint Path
  smmTBSAlterDiscard    ; Alter Tablespace Discard 
  smmTBSStartupShutdown ; Startup, Shutdown Tablespace ó 
  ----------------------------------------------------------------------------
  smmTBSChkptPath  ; Tablespace Checkpoint Path 
  smmTBSMultiPhase ; Tablespace ٴܰ ʱȭ
  ----------------------------------------------------------------------------
  smmManager       ; Tablespace   
  smmFPLManager    ; Tablespace Free Page List  
  smmExpandChunk   ; Chunk α 
  ----------------------------------------------------------------------------
  
  c.f> Memory Tablespace Alter Online/Offline smp layer Ǿ ִ.
*/


/*
    smmTBSMultiPhase ; Tablespace ٴܰ ʱȭ 

    ------------------------------------------------------------------------
    Tablespace ٴܰ ʱȭ/ı
    ------------------------------------------------------------------------   
    
    Tablespace ¿    ٴܰ
    ʱȭ Ѵ.

     ܰ ʱȭ ؼ  ܰ ʱȭ ʼ̴.
    (ex> 2. MEDIAܰ ʱȭ ؼ 1.STATEܰ ʱȭ ʼ)
    
    1. STATE  - State Phase
         :
         - Tablespace State  
         - ü   Lock Mutex 밡
         
       ʱȭ :
         - Tablespace Attributeʱȭ
         - Tablespace Lock, Mutexʱȭ
       
    2. MEDIA  - Media Phase
         :
         - Tablespace DB File Ͽ б/ 
         
       ʱȭ :
         - DB File ü ʱȭ, Open
    
    3. PAGE   - Page Phase
         :
         - Prepare/Restore (DB File => Page Memory  ε )
         - Tablespace Page /Ҵ/ݳ 
         
       ʱȭ :
         - PCH* ArrayҴ
         - Page Memory PoolҴ
         - Free Page List, Chunk  ʱȭ

    ------------------------------------------------------------------------
    Tablespace State ʱȭ ܰ
    ------------------------------------------------------------------------   
    A. ONLINE
       ʱȭ ܰ : PAGE
        : Page Ҵ ݳ, Page Data  ؾ
       
    B. OFFLINE
       ʱȭ ܰ : MEDIA
        : Checkpoint DB File Header RedoLSN ؾ
       
    C. DISCARDED
       ʱȭ ܰ : MEDIA
        :  Transaction ÿ DISCARD Tablespace ٰ
               Discard Tablespace Drop Tablespace 
                DML/DDL  ǹǷ,
               Tablespace ¸ ȸ   ȴ.
               
               Drop Tablespace ϱ , DB Fileü 
               ؾ ϸ, ̸  MEDIAܰ ʱȭ
               Ǿ־ Ѵ.
       
    D. DROPPED
       ʱȭ ܰ : STATE
        :  Transaction ÿ DROP Tablespace ٰ
               Drop Tablespace  DML/DDL  ǹǷ,
               Tablespace ¸ ȸ   ȴ.
    

    ------------------------------------------------------------------------   
    Meta/Service¿ Tablespace Node 
    ------------------------------------------------------------------------   
     - ONLINE => OFFLINE
        [ PAGE => MEDIA ] finiPAGE
       
     - OFFLINE => ONLINE
        [ MEDIA => PAGE ] initPAGE
       
     - ONLINE => DROPPED
        [ PAGE => STATE ] finiPAGE, finiMEDIA

     - OFFLINE => DROPPED
        [ STATE => PAGE ] initMEDIA, initPAGE
    ------------------------------------------------------------------------   
    Control¿ Tablespace Node 
     - ONLINE => DISCARDED
        [ PAGE => STATE ] finiPAGE, finiMEDIA
       
     - OFFLINE => DISCARDED
        [ STATE => PAGE ] initMEDIA, initPAGE
               
 */



class smmTBSMultiPhase
{
public :
    //  (ƹ͵ )
    smmTBSMultiPhase();

    
    // STATE Phase κ Tablespace ¿ 
    // ʿ ܰԱ ٴܰ ʱȭ
    static IDE_RC initTBS( smmTBSNode * aTBSNode,
                           smiTableSpaceAttr * aTBSAttr );
    
    // Server Shutdownÿ Tablespace ¿ 
    // Tablespace ʱȭ ܰ ıѴ.
    static IDE_RC finiTBS( smmTBSNode * aTBSNode );
    
    // PAGE, MEDIA Phaseκ STATE Phase  
    static IDE_RC finiToStatePhase( smmTBSNode * aTBSNode );

    // ٴܰ   MEDIAܰ 
    static IDE_RC finiToMediaPhase( UInt         aTBSState,
                                    smmTBSNode * aTBSNode );
    
    // Tablespace STATEܰ踦 ʱȭ
    static IDE_RC initStatePhase( smmTBSNode * aTBSNode,
                                  smiTableSpaceAttr * aTBSAttr );

    // STATEܰ ʱȭ Tablespace ٴܰʱȭ
    static IDE_RC initFromStatePhase( smmTBSNode * aTBSNode );
    
    // Tablespace MEDIAܰ踦 ʱȭ
    static IDE_RC initMediaPhase( smmTBSNode * aTBSNode );

    // Tablespace PAGEܰ踦 ʱȭ
    static IDE_RC initPagePhase( smmTBSNode * aTBSNode );

    // Tablespace STATEܰ踦 ı
    static IDE_RC finiStatePhase( smmTBSNode * aTBSNode );

    // Tablespace MEDIAܰ踦 ı
    static IDE_RC finiMediaPhase( smmTBSNode * aTBSNode );

    // Tablespace PAGEܰ踦 ı
    static IDE_RC finiPagePhase( smmTBSNode * aTBSNode );
};

#endif /* _O_SMM_TBS_MULTI_PHASE_H_ */
