/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: smrArchThread.h 82075 2018-01-17 06:39:52Z jina.kim $
 **********************************************************************/

#ifndef _O_SMR_ARCH_THREAD_H_
#define _O_SMR_ARCH_THREAD_H_ 1

#include <idu.h>
#include <idtBaseThread.h>
#include <smrArchMultiplexThread.h>

#define SMR_ARCH_THREAD_POOL_SIZE  (50)
#define SMR_ORIGINAL_ARCH_DIR_IDX  (0)

class smrArchThread : public idtBaseThread
{
//For Operation    
public:
    // ī̺ α Ʈ α ϳ  ߰Ѵ.
    IDE_RC addArchLogFile(UInt aLogFileNo);
    
    // ī̺ α Ʈ α 带 ϳ Ѵ.
    IDE_RC removeArchLogFile(smrArchLogFile *aLogFile);

    // ī̺ α Ʈ ִ αϵ ī̺Ѵ.
    // ī̺ 尡 ֱ,
    // Ȥ û   ϴ Լ̴.
    IDE_RC archLogFile();

    //  ī̺ Ϲȣ ´. 
    IDE_RC setLstArchLogFileNo(UInt    aArchLogFileNo);
    //  ī̺ Ϲȣ Ѵ.
    IDE_RC getLstArchLogFileNo(UInt*   aArchLogFileNo);

    //  ī̺ αϹȣ ´.
    IDE_RC getArchLFLstInfo(UInt   * aArchFstLFileNo,
                            idBool * aIsEmptyArchLFLst );
    
    // ī̺ α Ʈ  ʱȭ Ѵ.
    IDE_RC clearArchList();

    virtual void run();
    // ī̺ 带 ۽Ű, 尡 
    // ۵  ٸ.
    IDE_RC startThread();
    
    // ī̺ 带 ϰ, 尡 
    // Ǿ  ٸ.
    IDE_RC shutdown();

    // ī̺  ü ʱȭ Ѵ.
    IDE_RC initialize( const SChar   * aArchivePath,
                       smrLogFileMgr * aLogFileMgr,
                       UInt            aLstArchFileNo);

    //  ŸƮ ÿ ī̺ α Ʈ 籸Ѵ.
    IDE_RC recoverArchiveLogList( UInt aStartNo,
                                  UInt aEndNo );
    
    // ī̺  ü  Ѵ.
    IDE_RC destroy();
    
    IDE_RC lockListMtx() { return mMtxArchList.lock( NULL ); }
    IDE_RC unlockListMtx() { return mMtxArchList.unlock(); }

    IDE_RC lockThreadMtx() { return mMtxArchThread.lock( NULL ); }
    IDE_RC unlockThreadMtx() { return mMtxArchThread.unlock(); }
    
    // ī̺ 带 
    //  ī̺  αϵ ī̺ Ų.
    IDE_RC wait4EndArchLF( UInt aToFileNo );

    smrArchThread();
    virtual ~smrArchThread();

//For Member
private:
    // ī̺ αװ  丮
    // Log File Group ϳ unique ī̺ 丮 ʿϴ.
    const SChar            * mArchivePath[SM_ARCH_MULTIPLEX_PATH_CNT + 1];
    //  ī̺ 尡 ī̺ αϵ ϴ α 
    smrLogFileMgr          * mLogFileMgr;
    
    //  ִ ī̺ 带  condition value
    iduCond                  mCv;

    // smrArchLogFile Ҵ/  mempool
    iduMemPool               mMemPool;

    // ī̺ 带 ؾ   
    idBool                   mFinish;
    // ī̺ 尡  
    idBool                   mResume;

    // mLstArchFileNo  mArchFileList   ü   Mutex
    iduMutex                 mMtxArchList;
    // ī̺  ü   Mutex
    iduMutex                 mMtxArchThread;

    //  ī̺ αϹȣ
    UInt                     mLstArchFileNo;
    // ī̺ α ȣ  Ʈ
    smrArchLogFile           mArchFileList;

    UInt                     mArchivePathCnt;

    smrArchMultiplexThread * mArchMultiplexThreadArea;
};

#endif
