/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
* $Id: smmTBSMultiPhase.cpp 19201 2006-11-30 00:54:40Z kmkim $
**********************************************************************/

#include <idl.h>
#include <idm.h>
#include <idu.h>
#include <ideErrorMgr.h>
#include <smDef.h>
#include <smErrorCode.h>
#include <smu.h>
#include <smm.h>
#include <smmReq.h>
#include <sctTableSpaceMgr.h>
#include <smmTBSMultiPhase.h>

smmTBSMultiPhase::smmTBSMultiPhase()
{
}

/* Server Shutdownÿ Tablespace ¿ 
   Tablespace ʱȭ ܰ ıѴ.

   [IN] aTBSNode - Tablespace  Node
   
   ex> DISCARDED, OFFLINE TBS MEDIA, STATEܰ踦 ı
   ex> ONLINE TBS PAGE,MEDIA,STATEܰ踦 ı
 */
IDE_RC smmTBSMultiPhase::finiTBS( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    IDE_TEST( finiToStatePhase( aTBSNode )
              != IDE_SUCCESS );

    if ( sctTableSpaceMgr::hasState( & aTBSNode->mHeader,
                                     SCT_SS_NEED_STATE_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( finiStatePhase( aTBSNode ) != IDE_SUCCESS );
    }
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}




/* STATE Phase κ Tablespace ¿ 
   ʿ ܰԱ ٴܰ ʱȭ

   [IN] aTBSNode - Tablespace  Node
   [IN] aTBSAttr - Tablespace  Attribute
   
   ex> DISCARDED, OFFLINE TBS MEDIA, STATEܰ踦 ı
   ex> ONLINE TBS  STATE, MEDIA, PAGEܰ踦 ϳ ʱȭ
 */
IDE_RC smmTBSMultiPhase::initTBS( smmTBSNode        * aTBSNode,
                                  smiTableSpaceAttr * aTBSAttr )
{
    IDE_DASSERT( aTBSNode != NULL );

    // STATE Phase ʱȭ
    if ( sctTableSpaceMgr::isStateInSet( aTBSAttr->mTBSStateOnLA,
                                         SCT_SS_NEED_STATE_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( initStatePhase( aTBSNode,
                                  aTBSAttr ) != IDE_SUCCESS );
    }

    // MEDIA, PAGE Phase ʱȭ
    if ( sctTableSpaceMgr::isStateInSet( aTBSNode->mHeader.mState,
                                         SCT_SS_NEED_MEDIA_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( initFromStatePhase( aTBSNode ) != IDE_SUCCESS );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* STATEܰ ʱȭ Tablespace ٴܰʱȭ

   [IN] aTBSNode - Tablespace  Node
   
   ex> OFFLINE TBS MEDIAܰ ʱȭ
   ex> ONLINE TBS PAGE,MEDIAܰ ʱȭ
   
 */
  
IDE_RC smmTBSMultiPhase::initFromStatePhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    UInt sTBSState = aTBSNode->mHeader.mState;

    //  Tablespace ´ STATEܰ ʱȭ
    // ʿ ϴ ¿ Ѵ.
    IDE_ASSERT( sctTableSpaceMgr::isStateInSet( sTBSState,
                                                SCT_SS_NEED_STATE_PHASE )
                == ID_TRUE );
    
    // MEDIA Phaseʱȭ
    if ( sctTableSpaceMgr::isStateInSet( sTBSState,
                                         SCT_SS_NEED_MEDIA_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( initMediaPhase( aTBSNode ) != IDE_SUCCESS );
    }

    
    // PAGE Phase ʱȭ
    if ( sctTableSpaceMgr::isStateInSet( sTBSState,
                                         SCT_SS_NEED_PAGE_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( initPagePhase( aTBSNode ) != IDE_SUCCESS );
    }

    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}



/* ٴܰ   STATEܰ 

   [IN] aTBSNode - Tablespace  Node
   
   ex> OFFLINE TBS MEDIAܰ踦 ı
   ex> ONLINE TBS PAGE,MEDIAܰ踦 ı

   => sTBSNode State ̿ ʰ ڷ Ѿ State ̿Ѵ
 */
IDE_RC smmTBSMultiPhase::finiToStatePhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    UInt sTBSState = aTBSNode->mHeader.mState;
    
    
    // PAGE Phase ı
    if ( sctTableSpaceMgr::isStateInSet( sTBSState,
                                         SCT_SS_NEED_PAGE_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( finiPagePhase( aTBSNode ) != IDE_SUCCESS );
    }

    // MEDIA Phaseı
    if ( sctTableSpaceMgr::isStateInSet( sTBSState,
                                         SCT_SS_NEED_MEDIA_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( finiMediaPhase( aTBSNode ) != IDE_SUCCESS );
    }

    //  Tablespace ´ STATEܰ ʱȭ
    // ʿ ϴ ¿ Ѵ.
    IDE_ASSERT( sctTableSpaceMgr::isStateInSet( sTBSState,
                                                SCT_SS_NEED_STATE_PHASE )
                == ID_TRUE );
    
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* ٴܰ   MEDIAܰ 

   [IN] aTBSState - Tablespace State
   [IN] aTBSNode - Tablespace  Node
   
   ex> ONLINE TBS  PAGEܰ踦 ı

   => sTBSNode State ̿ ʰ ڷ Ѿ State ̿Ѵ
 */
IDE_RC smmTBSMultiPhase::finiToMediaPhase( UInt         aTBSState,
                                           smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    // PAGE Phase ı
    if ( sctTableSpaceMgr::isStateInSet( aTBSState, SCT_SS_NEED_PAGE_PHASE )
         == ID_TRUE )
    {
        IDE_TEST( finiPagePhase( aTBSNode ) != IDE_SUCCESS );
    }

    //  Tablespace ´ MEDIAܰ ʱȭ
    // ʿ ϴ ¿ Ѵ.
    IDE_ASSERT( sctTableSpaceMgr::isStateInSet( aTBSState,
                                                SCT_SS_NEED_MEDIA_PHASE )
                == ID_TRUE );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}


/* Tablespace STATEܰ踦 ʱȭ

   [IN] aTBSNode - Tablespace  Node
   [IN] aTBSAttr - Tablespace  Attribute
 */
IDE_RC smmTBSMultiPhase::initStatePhase( smmTBSNode * aTBSNode,
                                         smiTableSpaceAttr * aTBSAttr )
{
    IDE_DASSERT( aTBSNode != NULL );
    IDE_DASSERT( aTBSAttr != NULL );

    // Memory Tablespace Node ʱȭ ǽ
    IDE_TEST( smmManager::initMemTBSNode( aTBSNode,
                                          aTBSAttr )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* Tablespace MEDIAܰ踦 ʱȭ

   [IN] aTBSNode - Tablespace  Node

    : STATEܰ ʱȭ Ǿ ־ Ѵ.
 */
IDE_RC smmTBSMultiPhase::initMediaPhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    // Memory Tablespace Node ʱȭ ǽ
    IDE_TEST( smmManager::initMediaSystem( aTBSNode )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* Tablespace PAGEܰ踦 ʱȭ

   [IN] aTBSNode - Tablespace  Node

    : MEDIAܰʱȭ Ǿ ־ Ѵ.
 */
IDE_RC smmTBSMultiPhase::initPagePhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    // Memory Tablespace Node ʱȭ ǽ
    IDE_TEST( smmManager::initPageSystem( aTBSNode )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* Tablespace STATEܰ踦 ı

   [IN] aTBSNode - Tablespace  Node

    : STATEܰ谡 ʱȭ ¿ Ѵ.
    : PAGE,MEDIAܰ谡 ıǾ ־ Ѵ.
 */
IDE_RC smmTBSMultiPhase::finiStatePhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    IDE_TEST( smmManager::finiMemTBSNode( aTBSNode )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* Tablespace MEDIAܰ踦 ı

   [IN] aTBSNode - Tablespace  Node

    : STATE, MEDIAܰ谡  ʱȭ ¿ Ѵ.
    : PAGEܰ谡 ı Ǿ ־ Ѵ.
 */
IDE_RC smmTBSMultiPhase::finiMediaPhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    IDE_TEST( smmManager::finiMediaSystem( aTBSNode )
              != IDE_SUCCESS );


    // To Fix BUG-18100, 18099
    //        Shutdown Checkpoint Path Node Memory Leak߻  ذ
    IDE_TEST( smmTBSChkptPath::freeAllChkptPathNode( aTBSNode )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}

/* Tablespace PAGEܰ踦 ı

   [IN] aTBSNode - Tablespace  Node

    : STATE, MEDIA, PAGEܰ谡  ʱȭ ¿ Ѵ.
 */
IDE_RC smmTBSMultiPhase::finiPagePhase( smmTBSNode * aTBSNode )
{
    IDE_DASSERT( aTBSNode != NULL );

    IDE_TEST( smmManager::finiPageSystem( aTBSNode )
              != IDE_SUCCESS );
    
    return IDE_SUCCESS;

    IDE_EXCEPTION_END;

    return IDE_FAILURE;
}
