/** 
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 

/***********************************************************************
 * $Id: smuUtility.cpp 91197 2021-07-12 01:15:29Z emlee $
 **********************************************************************/

#include <smDef.h>
#include <smErrorCode.h>
#include <smuUtility.h>
#include <sdpDef.h>
#include <sdtSortDef.h>

smuWriteErrFunc smuUtility::mWriteError = &ideLog::log;

SInt smuUtility::outputMsg(const SChar *aFmt, ...)
{
    SInt rc;
    va_list ap;
    va_start(ap, aFmt);
    /* ------------------------------------------------
     *  vfprintf  idlOS:: ,
     *  PDL fprintf vfprintf ̿ؼ
     *  Ѵ. , PDL  Ǵ ,
     *  ::vfprintf ص ϴٰ ǴѴ.
     *  2001/05/09  by gamestar
     * ----------------------------------------------*/
    rc = ::vfprintf(stdout, aFmt, ap); 
    va_end(ap);
    idlOS::fflush(stdout);

    return rc;
}

SInt smuUtility::outputErr(const SChar *aFmt, ...)
{
    SInt rc;
    va_list ap;
    va_start(ap, aFmt);
    /* ------------------------------------------------
     *  vfprintf  idlOS:: ,
     *  PDL fprintf vfprintf ̿ؼ
     *  Ѵ. , PDL  Ǵ ,
     *  ::vfprintf ص ϴٰ ǴѴ.
     *  2001/05/09  by gamestar
     * ----------------------------------------------*/
    rc = ::vfprintf(stderr, aFmt, ap); 
    va_end(ap);
    idlOS::fflush(stderr);

    return rc;
}

IDE_RC smuUtility::outputUtilityHeader(const SChar *aUtilName)
{
    
    smuUtility::outputMsg("\n%s: Release %s - Production on %s \n",
                          aUtilName,
                          iduVersionString,
                          iduGetProductionTimeString() );
    
    smuUtility::outputMsg("%s\n\n", 
                          iduCopyRightString);
    
    return IDE_SUCCESS;
}


IDE_RC smuUtility::loadErrorMsb( SChar *aRootDir, SChar *aIDN )
{
    
    SChar filename[512];

    idlOS::memset(filename, 0, 512);
    idlOS::snprintf(filename, 512, "%s%cmsg%cE_ID_%s.msb", aRootDir, IDL_FILE_SEPARATOR, IDL_FILE_SEPARATOR, aIDN);
    IDE_TEST(ideRegistErrorMsb(filename) != IDE_SUCCESS);
    
    idlOS::memset(filename, 0, 512);
    idlOS::snprintf(filename, 512, "%s%cmsg%cE_SM_%s.msb", aRootDir, IDL_FILE_SEPARATOR, IDL_FILE_SEPARATOR, aIDN);
    IDE_TEST(ideRegistErrorMsb(filename) != IDE_SUCCESS);

    idlOS::memset(filename, 0, 512);
    idlOS::snprintf(filename, 512, "%s%cmsg%cE_QP_%s.msb", aRootDir, IDL_FILE_SEPARATOR, IDL_FILE_SEPARATOR, aIDN);
    IDE_TEST(ideRegistErrorMsb(filename) != IDE_SUCCESS);

    idlOS::memset(filename, 0, 512);
    idlOS::snprintf(filename, 512, "%s%cmsg%cE_MM_%s.msb", aRootDir, IDL_FILE_SEPARATOR, IDL_FILE_SEPARATOR, aIDN);
    IDE_TEST(ideRegistErrorMsb(filename) != IDE_SUCCESS);
    
    return IDE_SUCCESS;
    IDE_EXCEPTION_END;
    return IDE_FAILURE;
}

/******************************************************************
 * DESCRIPTION : 
 *    TimeValueκ ¥/ð ڿ ȹ
 *
 *  aTimeValue           - [IN]  ԷµǴ ð
 *  aBufferLength        - [OUT]    ũ
 *  aBuffer              - [OUT]   
 ******************************************************************/
void smuUtility::getTimeString( UInt    aTimeValue, 
                                UInt    aBufferLength,
                                SChar * aBuffer )
{
    struct tm        sTimeStruct;
    time_t           sTimeValue;

    sTimeValue = (time_t) aTimeValue;
    idlOS::localtime_r( &sTimeValue, &sTimeStruct);
    idlOS::snprintf( aBuffer,
                     aBufferLength,
                     "%4"ID_UINT32_FMT
                     "%02"ID_UINT32_FMT
                     "%02"ID_UINT32_FMT
                     "_%02"ID_UINT32_FMT
                     "%02"ID_UINT32_FMT
                     "%02"ID_UINT32_FMT,
                     sTimeStruct.tm_year + 1900,
                     sTimeStruct.tm_mon + 1,
                     sTimeStruct.tm_mday,
                     sTimeStruct.tm_hour,
                     sTimeStruct.tm_min,
                     sTimeStruct.tm_sec );
}

/******************************************************************
 * DESCRIPTION : 
 *    ƯԼ   ޾ ش  Ѵ. 
 *
 * 1.ũ ̺ ϰ ־  __TEMPDUMP_LEVEL
 *      ݽ Dumpθ Ѵ.
 * 2.Callstack   error.log  Ǿ ִ. 
 ******************************************************************/
void smuUtility::dumpFuncWithBuffer( UInt           aChkFlag, 
                                     ideLogModule   aModule, 
                                     UInt           aLevel, 
                                     smuDumpFunc    aDumpFunc,
                                     void         * aTarget )
{
    SChar        * sTempBuf;

    /* __TEMPDUMP_LEVEL  Dump */
    if ( smuProperty::getTempDumpLevel() == 2 )
    {
        ideLog::logCallStack( aChkFlag, aModule, aLevel );
    }

    ideLog::log( aChkFlag, 
                 aModule, 
                 aLevel,
                 "[DUMP] ERR-%05X(error=%"ID_UINT32_FMT") %s\n",
                 E_ERROR_CODE( ideGetErrorCode() ),
                 ideGetSystemErrno(),
                 ideGetErrorMsg( ideGetErrorCode() ) );

    if ( iduMemMgr::calloc( IDU_MEM_SM_SMU,
                            1,
                            ID_SIZEOF( SChar ) * IDE_DUMP_DEST_LIMIT,
                            (void**)&sTempBuf )
         == IDE_SUCCESS )
    {
        sTempBuf[0] = '\0';
        aDumpFunc( aTarget, sTempBuf, IDE_DUMP_DEST_LIMIT );
        ideLog::log( aChkFlag, aModule, aLevel, "%s", sTempBuf );
        (void) iduMemMgr::free( sTempBuf );
    }
}
void smuUtility::printFuncWithBuffer( smuDumpFunc    aDumpFunc,
                                      void         * aTarget ) 
{
    SChar        * sTempBuf;

    if( iduMemMgr::calloc( IDU_MEM_SM_SMU,
                           1,
                           ID_SIZEOF( SChar ) * IDE_DUMP_DEST_LIMIT,
                           (void**)&sTempBuf )
              == IDE_SUCCESS )
    {
        sTempBuf[0] = '\0';
        aDumpFunc( aTarget, sTempBuf, IDE_DUMP_DEST_LIMIT );
        idlOS::printf( "%s", sTempBuf );
        (void) iduMemMgr::free( sTempBuf );
    }
}

/******************************************************************
 * DESCRIPTION : 
 *     鿡  DumpFunction
 ******************************************************************/
void smuUtility::dumpGRID( void  * aTarget,
                           SChar * aOutBuf, 
                           UInt    aOutSize )
{
    scGRID * sGRID = (scGRID*)aTarget;

    idlVA::appendFormat( aOutBuf,
                         aOutSize,
                         "GRID[%"ID_UINT32_FMT
                         ",%"ID_UINT32_FMT
                         ",%"ID_UINT32_FMT"]",
                         sGRID->mSpaceID,
                         sGRID->mPageID,
                         sGRID->mOffset );
}

void smuUtility::dumpUInt( void  * aTarget,
                           SChar * aOutBuf, 
                           UInt    aOutSize ) 
{
    idlVA::appendFormat( aOutBuf,
                         aOutSize,
                         "%"ID_UINT32_FMT,
                         *(UInt*)aTarget );
}

void smuUtility::dumpExtDesc( void  * aTarget,
                              SChar * aOutBuf, 
                              UInt    aOutSize ) 
{
    sdpExtDesc * sExtDesc = (sdpExtDesc*)aTarget;

    idlVA::appendFormat( aOutBuf,
                         aOutSize,
                         "[%8"ID_UINT32_FMT
                         " %8"ID_UINT32_FMT"]",
                         sExtDesc->mExtFstPID,
                         sExtDesc->mLength );
}


//  IDE_RC smuUtility::makeDatabaseFileName(SChar  *aDBName,
//                                          SChar **aDBDir)
//  {
//      SInt   i;
//      SChar* sDbDir[SM_PINGPONG_COUNT];
    
//      sDbDir[0] = (SChar*)smuProperty::getDBDir(0);
//      sDbDir[1] = (SChar*)smuProperty::getDBDir(1);
    
//      IDE_TEST_RAISE(idlOS::strlen(aDBName) > (SM_MAX_DB_NAME -1),
//                     too_long_dbname);

//      for (i = 0; i < SM_PINGPONG_COUNT; i++)
//      {
//          IDE_TEST(iduMemMgr::calloc(IDU_MEM_SM_SMU,
//                                     1,
//                                     idlOS::strlen(aDBName) + idlOS::strlen(sDbDir[i]) + 4,
//                                     (void**)&(aDBDir[i]))
//                   != IDE_SUCCESS);

//          idlOS::sprintf(aDBDir[i], "%s%c%s-%u",
//                         sDbDir[i], IDL_FILE_SEPARATOR, aDBName, i);
//      }
    
//      return IDE_SUCCESS;

//      IDE_EXCEPTION(too_long_dbname);
//      {
//          IDE_SET( ideSetErrorCode( smERR_FATAL_TooLongDBName,
//                                    (UInt)SM_MAX_DB_NAME ) );
//      }
//      IDE_EXCEPTION_END;
//      return IDE_FAILURE;
//  }

/* --------------------------------------------------------------------

   Description :

   createdbÿ file  database dir ã´.
   db_dir ټ̱     ϳ
   Ѵ. 
    PINGPONG datafile е Ƿ   ʿ䰡 .
   property  ù° dir  ̴.
   
   ----------------------------------------------------------------- */



/* --------------------------------------------------------------------

   Description :

   
   ----------------------------------------------------------------- */

//  IDE_RC smuUtility::getCreateDBFileName(SChar **aFileName)
//  {
    
//      UInt sDirSelected = 0;
//      UInt sLoop;
    
//      for( sLoop = 0; sLoop != SM_DB_DIR_COUNT; ++sLoop )
//      {
        
//          makeFileName(smuProperty::getDBDir(sLoop),
//                       smuProperty::getDBName(),
//                       0,
//                       0,
//                       sFileName);
        
//          sExist = existDBFileName(sFileName);
        
//          if(sExist == ID_TRUE)
//          {
            
//          }
//      }

//      idlOS::sprintf(aDBDir, "%s",
//                     smuProperty::getDBDir(sDirSelected));
    
//      return IDE_SUCCESS;

//      IDE_EXCEPTION_END;
    
//      return IDE_FAILURE;
//  }


//  IDE_RC smuUtility::getDBDir( SChar **aDBDir)
//  {
//      SInt         i;
//      const SChar *sCurrDBDir;

//      for (i = 0; i < SM_PINGPONG_COUNT; i++)
//      {
//          sCurrDBDir = smuProperty::getDBDir(i);
        
//          IDE_TEST(iduMemMgr::calloc(IDU_MEM_SM_SMU,
//                                     1,
//                                     idlOS::strlen(sCurrDBDir) + 4,
//                                     (void**)&(aDBDir[i]))
//                   != IDE_SUCCESS);

//          idlOS::sprintf(aDBDir[i], "%s", sCurrDBDir);
//      }
    
//      return IDE_SUCCESS;
    
//      IDE_EXCEPTION_END;
    
//      return IDE_FAILURE;
    
//  }
