/*
 * Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

package Altibase.jdbc.driver.sharding.core;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

/**
 * ServerSide Ǵ ClientSide  Ǵ java.sql.Statement ̽ 
 */
public interface InternalShardingStatement
{
    ResultSet executeQuery(String aSql) throws SQLException;
    int executeUpdate(String aSql) throws SQLException;
    void close() throws SQLException;
    int getMaxFieldSize() throws SQLException;
    void setMaxFieldSize(int aMax) throws SQLException;
    int getMaxRows() throws SQLException;
    void setMaxRows(int aMax) throws SQLException;
    void setEscapeProcessing(boolean aEnable) throws SQLException;
    int getQueryTimeout() throws SQLException;
    void setQueryTimeout(int aSeconds) throws SQLException;
    void cancel() throws SQLException;
    SQLWarning getWarnings() throws SQLException;
    void clearWarnings() throws SQLException;
    void setCursorName(String aName) throws SQLException;
    boolean execute(String aSql) throws SQLException;
    ResultSet getResultSet() throws SQLException;
    int getUpdateCount() throws SQLException;
    boolean getMoreResults() throws SQLException;
    void setFetchSize(int aRows) throws SQLException;
    int getFetchSize() throws SQLException;
    Connection getConnection() throws SQLException;
    boolean getMoreResults(int aCurrent) throws SQLException;
    ResultSet getGeneratedKeys() throws SQLException;
    int executeUpdate(String aSql, int[] aColumnIndexes) throws SQLException;
    int executeUpdate(String aSql, String[] aColumnNames) throws SQLException;
    int executeUpdate(String aSql, int aAutoGeneratedKeys) throws SQLException;
    boolean execute(String aSql, int[] aColumnIndexes) throws SQLException;
    boolean execute(String aSql, String[] aColumnNames) throws SQLException;
    boolean execute(String aSql, int aAutoGeneratedKeys) throws SQLException;
    boolean isPrepared();
    boolean hasNoData();
    void makeQstrForGeneratedKeys(String aSql, int[] aColumnIndexes,
                                  String[] aColumnNames) throws SQLException;
    void clearForGeneratedKeys() throws SQLException;
    int getStmtType();
}
