/**
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <uln.h>
#include <ulnPrivate.h>
#include <ulnConv.h>
#include <ulnConvToTIME.h>

ACI_RC ulncCHAR_TIME(ulnFnContext  *aFnContext,
                     ulnAppBuffer  *aAppBuffer,
                     ulnColumn     *aColumn,
                     ulnLengthPair *aLength,
                     acp_uint16_t   aRowNumber)
{
    acp_char_t      *sDateFormat;
    acp_char_t      *sDateString;

    mtdDateType      sMtdDate = mtcdDateNull;       //BUG-28561 [CodeSonar] Uninitialized Variable
    SQL_TIME_STRUCT *sUserDate;

    acp_uint8_t      sErrMsgBuf[32] = {'\0', };

    sUserDate   = (SQL_TIME_STRUCT *)aAppBuffer->mBuffer;
    sDateString = (acp_char_t *)aColumn->mBuffer;

    sDateFormat = aFnContext->mHandle.mStmt->mParentDbc->mDateFormat;

    ACI_TEST_RAISE( mtdDateInterfaceToDate(&sMtdDate,
                                           (acp_uint8_t *)sDateString,
                                           aColumn->mDataLength,
                                           (acp_uint8_t *)sDateFormat,
                                           acpCStrLen(sDateFormat, ACP_SINT32_MAX))
                    != ACI_SUCCESS, INVALID_DATE_STR_ERROR );

    sUserDate->hour   = mtdDateInterfaceHour(&sMtdDate);
    sUserDate->minute = mtdDateInterfaceMinute(&sMtdDate);
    sUserDate->second = mtdDateInterfaceSecond(&sMtdDate);

    if (mtdDateInterfaceMicroSecond(&sMtdDate) != 0)
    {
        /*
         * 01s07
         *
         * BUGBUG : fraction portion  0  üũؾ ϳ?
         *
         * Altibase  DATE Ÿ ǻ SQL_TIMESTAMP Ÿ̴.
         * SQL_TIMESTAMP --> SQL_DATE ȯÿ
         *      1. timestamp  date κ õȴ.
         *      2. timestamp  time κ 0  ƴϸ, 01S07 Ѵ.
         */
        ulnErrorExtended(aFnContext,
                         aRowNumber,
                         aColumn->mColumnNumber,
                         ulERR_IGNORE_FRACTIONAL_TRUNCATION);
    }

    aLength->mNeeded  = ACI_SIZEOF(SQL_TIME_STRUCT);
    aLength->mWritten = ACI_SIZEOF(SQL_TIME_STRUCT);

    return ACI_SUCCESS;

    ACI_EXCEPTION( INVALID_DATE_STR_ERROR )
    {
        acpMemCpy( sErrMsgBuf,
                   sDateString,
                   ACP_MIN(31, aColumn->mDataLength) );
        ulnErrorExtended( aFnContext,
                          aRowNumber,
                          aColumn->mColumnNumber,
                          ulERR_ABORT_INVALID_DATE_STRING,
                          sErrMsgBuf,
                          sDateFormat );
    }
    ACI_EXCEPTION_END;

    return ACI_FAILURE;
}

ACI_RC ulncVARCHAR_TIME(ulnFnContext  *aFnContext,
                        ulnAppBuffer  *aAppBuffer,
                        ulnColumn     *aColumn,
                        ulnLengthPair *aLength,
                        acp_uint16_t   aRowNumber)
{
    return ulncCHAR_TIME(aFnContext,
                         aAppBuffer,
                         aColumn,
                         aLength,
                         aRowNumber);
}

ACI_RC ulncDATE_TIME(ulnFnContext  *aFnContext,
                     ulnAppBuffer  *aAppBuffer,
                     ulnColumn     *aColumn,
                     ulnLengthPair *aLength,
                     acp_uint16_t   aRowNumber)
{
    mtdDateType     *sMtdDate;
    SQL_TIME_STRUCT *sUserDate;

    sMtdDate = (mtdDateType *)aColumn->mBuffer;
    sUserDate  = (SQL_TIME_STRUCT *)aAppBuffer->mBuffer;

    sUserDate->hour   = mtdDateInterfaceHour(sMtdDate);
    sUserDate->minute = mtdDateInterfaceMinute(sMtdDate);
    sUserDate->second = mtdDateInterfaceSecond(sMtdDate);

    if (mtdDateInterfaceMicroSecond(sMtdDate) != 0)
    {
        /*
         * 01s07
         *
         * Altibase  DATE Ÿ ǻ SQL_TIMESTAMP Ÿ̴.
         * SQL_TIMESTAMP --> SQL_TIME  ȯÿ
         *      1. timestamp  date κ õȴ.
         *      2. timestamp  fractional κ 0  ƴϸ, 01S07 Ѵ.
         */
        ulnErrorExtended(aFnContext,
                         aRowNumber,
                         aColumn->mColumnNumber,
                         ulERR_IGNORE_FRACTIONAL_TRUNCATION);
    }

    aLength->mWritten = ACI_SIZEOF(SQL_TIME_STRUCT);
    aLength->mNeeded  = ACI_SIZEOF(SQL_TIME_STRUCT);

    return ACI_SUCCESS;
}

ACI_RC ulncINTERVAL_TIME(ulnFnContext  *aFnContext,
                         ulnAppBuffer  *aAppBuffer,
                         ulnColumn     *aColumn,
                         ulnLengthPair *aLength,
                         acp_uint16_t   aRowNumber)
{
    ACP_UNUSED(aAppBuffer);
    ACP_UNUSED(aLength);

    /*
     * 07006
     */
    return ulnErrorExtended(aFnContext,
                            aRowNumber,
                            aColumn->mColumnNumber,
                            ulERR_ABORT_INVALID_CONVERSION);
}

ACI_RC ulncNCHAR_TIME(ulnFnContext  *aFnContext,
                      ulnAppBuffer  *aAppBuffer,
                      ulnColumn     *aColumn,
                      ulnLengthPair *aLength,
                      acp_uint16_t   aRowNumber)
{
    acp_char_t      *sDateFormat;

    mtdDateType      sMtdDate = mtcdDateNull;       //BUG-28561 [CodeSonar] Uninitialized Variable
    SQL_TIME_STRUCT *sUserDate;

    ulnDbc          *sDbc;
    ulnCharSet       sCharSet;
    acp_sint32_t     sState = 0;

    acp_uint8_t      sErrMsgBuf[32] = {'\0', };

    ulnCharSetInitialize(&sCharSet);
    sState = 1;

    ULN_FNCONTEXT_GET_DBC(aFnContext, sDbc);

    /* BUG-46052 codesonar Null Pointer Dereference */
    ACI_TEST_RAISE(sDbc == NULL, InvalidHandleException);

    ACI_TEST(ulnCharSetConvert(&sCharSet,
                               aFnContext,
                               NULL,
                               (const mtlModule*)sDbc->mNcharCharsetLangModule,
                               sDbc->mClientCharsetLangModule,    //BUG-22684
                               (void*)aColumn->mBuffer,
                               aColumn->mDataLength,
                               CONV_DATA_OUT)
             != ACI_SUCCESS);

    sUserDate   = (SQL_TIME_STRUCT *)aAppBuffer->mBuffer;
    sDateFormat = aFnContext->mHandle.mStmt->mParentDbc->mDateFormat;

    ACI_TEST_RAISE( mtdDateInterfaceToDate(&sMtdDate,
                                           ulnCharSetGetConvertedText(&sCharSet),
                                           ulnCharSetGetConvertedTextLen(&sCharSet),
                                           (acp_uint8_t *)sDateFormat,
                                           acpCStrLen(sDateFormat, ACP_SINT32_MAX))
                    != ACI_SUCCESS, INVALID_DATE_STR_ERROR );

    sUserDate->hour   = mtdDateInterfaceHour(&sMtdDate);
    sUserDate->minute = mtdDateInterfaceMinute(&sMtdDate);
    sUserDate->second = mtdDateInterfaceSecond(&sMtdDate);

    if (mtdDateInterfaceMicroSecond(&sMtdDate) != 0)
    {
        /*
         * 01s07
         *
         * BUGBUG : fraction portion  0  üũؾ ϳ?
         *
         * Altibase  DATE Ÿ ǻ SQL_TIMESTAMP Ÿ̴.
         * SQL_TIMESTAMP --> SQL_DATE ȯÿ
         *      1. timestamp  date κ õȴ.
         *      2. timestamp  time κ 0  ƴϸ, 01S07 Ѵ.
         */
        ulnErrorExtended(aFnContext,
                         aRowNumber,
                         aColumn->mColumnNumber,
                         ulERR_IGNORE_FRACTIONAL_TRUNCATION);
    }

    aLength->mNeeded  = ACI_SIZEOF(SQL_TIME_STRUCT);
    aLength->mWritten = ACI_SIZEOF(SQL_TIME_STRUCT);

    sState = 0;
    ulnCharSetFinalize(&sCharSet);

    return ACI_SUCCESS;

    /* BUG-46052 codesonar Null Pointer Dereference */
    ACI_EXCEPTION(InvalidHandleException)
    {
        ULN_FNCONTEXT_SET_RC(aFnContext, SQL_INVALID_HANDLE);
    }
    ACI_EXCEPTION( INVALID_DATE_STR_ERROR )
    {
        acpMemCpy( sErrMsgBuf,
                   ulnCharSetGetConvertedText(&sCharSet),
                   ACP_MIN(31, ulnCharSetGetConvertedTextLen(&sCharSet)) );
        ulnErrorExtended( aFnContext,
                          aRowNumber,
                          aColumn->mColumnNumber,
                          ulERR_ABORT_INVALID_DATE_STRING,
                          sErrMsgBuf,
                          sDateFormat );
    }
    ACI_EXCEPTION_END;

    if (sState == 1)
    {
        ulnCharSetFinalize(&sCharSet);
    }

    return ACI_FAILURE;
}

ACI_RC ulncNVARCHAR_TIME(ulnFnContext  *aFnContext,
                         ulnAppBuffer  *aAppBuffer,
                         ulnColumn     *aColumn,
                         ulnLengthPair *aLength,
                         acp_uint16_t   aRowNumber)
{
    return ulncNCHAR_TIME(aFnContext,
                          aAppBuffer,
                          aColumn,
                          aLength,
                          aRowNumber);
}
