/**
 *  Copyright (c) 1999~2017, Altibase Corp. and/or its affiliates. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License, version 3,
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <ulnErrorDef.h>
#include <idErrorCodeClient.h>
#include <smErrorCodeClient.h>
#include <mtErrorCodeClient.h>
#include <mmErrorCodeClient.h>
#include <cmErrorCodeClient.h>
#include <qcuErrorClient.h>

ulnErrServerErrorMap gUlnServerErrorSQLSTATEMap[] =
{
    {"42501", qpERR_ABORT_QDP_REVOKE_PRIV_NOT_GRANTED         }, // BUG-38689 "Insufficient Privilege"
    {"07001", qpERR_ABORT_QSV_PROC_MAX_PARA_NUM_INT_ARG1      }, // "Wrong number of parameters"
    {"07S01", qpERR_ABORT_QSV_PROC_NOT_ALLOW_DEFAULT_SQLTEXT  }, // "Invalid use of default parameter"
    {"20070", qpERR_ABORT_QTC_MULTIPLE_ROWS                   }, // "A single-row subquery returns more than one row"
    {"21S01", qpERR_ABORT_QDB_MISMATCH_COL_COUNT              }, // "Insert value list does not match column list"
    {"21S01", qpERR_ABORT_QMV_NOT_ENOUGH_INSERT_VALUES        }, // "Not enough insert values"
    {"21S01", qpERR_ABORT_QMV_TOO_MANY_INSERT_VALUES          }, // "Too many insert values"
    {"22018", mtERR_ABORT_CONVERSION_NOT_APPLICABLE           }, // "Conversion not applicable"
    {"22018", mtERR_ABORT_INVALID_LITERAL                     }, // "Invalid literal"
    {"22012", mtERR_ABORT_DIVIDE_BY_ZERO                      }, // "Division by zero"
    {"22015", mtERR_ABORT_DATEDIFF_OUT_OF_RANGE_IN_SECOND     }, // "The interval between startdate and enddate exceeded 68 years"
    {"22015", mtERR_ABORT_DATEDIFF_OUT_OF_RANGE_IN_MICROSECOND}, // "The interval between startdate and enddate exceeded 30 days"
    {"22019", mtERR_ABORT_INVALID_ESCAPE                      }, // "Invalid escape character"
    {"22026", mtERR_ABORT_INVALID_LENGTH                      }, // "String data, length mismatch"
    {"23000", smERR_ABORT_smnUniqueViolation                  }, // "Integrity constraint violation"
    {"25S03", smERR_ABORT_Aborted                             }, // "Transaction is rolled back"
    {"28000", mmERR_ABORT_NO_USER_ERROR                       }, // "Invalid authorization specification"
    {"28000", mmERR_ABORT_INVALID_PASSWORD_ERROR              }, // "Invalid password"
    {"28000", mmERR_ABORT_MMC_ACCESS_MODE                     }, // "Invalid access privilege"
    {"42000", mmERR_ABORT_INVALID_STATEMENT_STATE_ERROR       }, // "Invalid request to process the SQL statement"
    {"42000", qpERR_ABORT_QCP_SYNTAX                          }, // "Syntax error or access violation"
    {"42000", qpERR_ABORT_QSV_INSUFFICIENT_ARGUEMNT_SQLTEXT   }, // "Insufficient arguments"
    {"42000", qpERR_ABORT_QSV_TOO_MANY_ARGUEMNT_SQLTEXT       }, // "Too many arguments"
    {"42000", qpERR_ABORT_QMV_NO_GROUP_EXPRESSION             }, // "Not a group expression in the target list"
    {"42000", qpERR_ABORT_QSV_NOT_EXIST_PROC_SQLTEXT          }, // "Procedure or function not found"
    {"42000", smERR_ABORT_NotFoundSavepoint                   }, // "Savepoint not found"
    {"42S01", qpERR_ABORT_QDB_EXIST_OBJECT_NAME               }, // "Base table, view, or column already exists"
    {"42S02", qpERR_ABORT_QCV_NOT_EXISTS_TABLE                }, // "Base table or view not found"
    {"42S11", qpERR_ABORT_QDX_DUPLICATE_INDEX                 }, // "Index already exists"
    {"42S12", qpERR_ABORT_QCM_NOT_EXISTS_INDEX                }, // "Index not found"
    {"42S22", qpERR_ABORT_QCM_NOT_EXIST_COLUMN                }, // "Column not found"
    {"HY098", mtERR_ABORT_VALIDATE_INVALID_VALUE              }, // "Scope type out of range"
    {"HY090", qpERR_ABORT_QCI_INVALID_HOST_DATA_SIZE          }, // "Invalid size of data to bind to a host variable"
    {"HY090", mmERR_ABORT_INVALID_DATA_SIZE                   }, // "Invalid size of data to bind to a host variable"
    {"HY090", mmERR_ABORT_INVALID_DATA_TYPE                   }, /* BUG-43294 */
    {"HY090", mmERR_ABORT_INVALID_SCALE_SIZE                  }, // "Invalid scale size of data to bind to a host variable"
    {"HY090", qpERR_ABORT_QCI_INVALID_BINDING                 }, // "Invalid bindings to host variables"
    {"HY103", mmERR_ABORT_INVALID_FETCH_ERROR                 }, // "Invalid retrieval code"
    {"HY104", mtERR_ABORT_INVALID_PRECISION                   }, // "Invalid precision of the data type"
    {"HYT00", idERR_ABORT_Query_Timeout                       }, // "Query Timeout expired"
    {"HYT00", smERR_ABORT_smcExceedLockTimeWait               }, // "Lock Timeout expired"
    {"22012", qpERR_ABORT_QSX_ZERO_DIVIDE },
    {"22003", idERR_ABORT_idaOverflow },
    {"22012", idERR_ABORT_idaDivideByZero },
    {"08004", idERR_ABORT_Session_Closed },
    {"HY004", mtERR_ABORT_DATATYPE_MODULE_NOT_FOUND },
    {"07001", mtERR_ABORT_INVALID_FUNCTION_ARGUMENT },
    {"HY104", mtERR_ABORT_INVALID_SCALE },
    {"22003", mtERR_ABORT_VALUE_OVERFLOW },
    {"HY105", mtERR_ABORT_ARGUMENT_NOT_APPLICABLE },
    {"HY004", mtERR_ABORT_NOT_SUPPORTED_OBJECT_TYPE },
    {"HY004", mtERR_ABORT_OBJECT_TYPE_NOT_APPLICABLE },
    {"HY104", mtERR_ABORT_TO_CHAR_MAX_PRECISION },
    {"HY107", mtERR_ABORT_VALIDATE_INVALID_LENGTH },
    {"22019", mtERR_ABORT_INVALID_LITERAL_AFTER_ESCAPE },
    {"22008", mtERR_ABORT_INVALID_DATE },
    {"22008", mtERR_ABORT_INVALID_YEAR },
    {"22008", mtERR_ABORT_INVALID_MONTH },
    {"22008", mtERR_ABORT_INVALID_DAY },
    {"22008", mtERR_ABORT_INVALID_HOUR },
    {"22008", mtERR_ABORT_INVALID_MINUTE },
    {"22008", mtERR_ABORT_INVALID_SECOND },
    {"22008", mtERR_ABORT_INVALID_MICROSECOND },
    {"HY107", mtERR_ABORT_ARGUMENT_VALUE_OUT_OF_RANGE },
    {"42000", qpERR_ABORT_QCP_NOT_SUPPORTED_SYNTAX },
    {"23000", qpERR_ABORT_QCP_CONFLICT_NULL_CONSTRAINT },
    {"42000", qpERR_ABORT_QCP_NO_HAVE_DATATYPE_IN_CRT_TBL },
    {"42000", qpERR_ABORT_QCP_HAVE_DATATYPE_IN_CRT_TBL_AS_SELECT },
    {"42000", qpERR_ABORT_QCP_DUPLICATE_COLUMN_NAME },
    {"42000", qpERR_ABORT_QCP_DUPLICATE_CONSTRAINT_NAME },
    {"42000", qpERR_ABORT_QCP_LIMIT_VALUE },
    {"3D000", qpERR_ABORT_QCM_NOT_EXIST_USER },
    {"42S02", qpERR_ABORT_QCM_NOT_EXIST_TABLE },
    {"42S02", qpERR_ABORT_QCM_NOT_EXIST_SEQUENCE },
    {"42S21", qpERR_ABORT_QDB_DUPLICATE_COLUMN },
    {"42S02", qpERR_ABORT_QDB_NOT_EXISTS_ALIAS },
    {"42000", qpERR_ABORT_QDB_INVALID_COLUMN_COUNT },
    {"3F000", qpERR_ABORT_QDB_NOT_EXISTS_DEFAULT },
    {"HY004", qpERR_ABORT_QDB_CREATE_DISABLE_DATA_TYPE },
    {"23000", qpERR_ABORT_QDB_REFERENTIAL_CONSTRAINT_EXIST },
    {"23000", qpERR_ABORT_QDB_NOT_EXIST_NOT_NULL },
    {"23000", qpERR_ABORT_QDB_NOT_ALLOWED_DROP_NOT_NULL },
    {"23000", qpERR_ABORT_QDB_EXIST_NOT_NULL },
    {"23000", qpERR_ABORT_QDB_NOTNULL_HAS_NULL },
    {"42000", qpERR_ABORT_QCV_NOT_ALLOWED_HOSTVAR },
    {"42000", qpERR_ABORT_QDS_START_LESS_MIN },
    {"42000", qpERR_ABORT_QDS_START_MORE_MAX },
    {"42000", qpERR_ABORT_QDS_MIN_VALUE },
    {"42000", qpERR_ABORT_QDS_CACHE_VALUE },
    {"42000", qpERR_ABORT_QDS_INCREMENT_VALUE },
    {"42000", qpERR_ABORT_QDS_INVALID_INCREMENT_VALUE },
    {"3D000", qpERR_ABORT_QDR_NOT_EXISTS_USER },
    {"3D000", qpERR_ABORT_QDR_DUPLICATE_USER },
    {"23000", qpERR_ABORT_QDD_DDL_WITH_REPLICATED_TBL },
    {"42000", qpERR_ABORT_QDD_NO_DROP_SYS_USER },
    {"23000", qpERR_ABORT_QDD_EXIST_OWN_OBJECT },
    {"3F000", qpERR_ABORT_QDN_NOT_EXISTS_CONSTRAINT },
    {"3F000", qpERR_ABORT_QDN_NOT_EXISTS_UNIQUE_KEY },
    {"3F000", qpERR_ABORT_QDN_NOT_EXISTS_PRIMARY_KEY },
    {"23000", qpERR_ABORT_QDN_DUPLICATE_PRIMARY_KEY },
    {"23000", qpERR_ABORT_QDN_DUPLICATE_CONSTRAINT },
    {"42000", qpERR_ABORT_QDN_MAX_KEY_COLUMN_COUNT },
    {"42S12", qpERR_ABORT_QDN_REFERENCED_CONSTRAINT_NOT_FOUND },
    {"23000", qpERR_ABORT_QDN_ADD_COL_NO_DEFAULT_NOTNULL },
    {"23000", qpERR_ABORT_QDN_DUPLICATE_CONSTRAINT_SPEC },
    {"42000", qpERR_ABORT_QDX_INVALID_KEY_FIELD_COUNT },
    {"42S22", qpERR_ABORT_QDX_DUPLICATE_INDEX_COLS },
    {"23000", qpERR_ABORT_QMV_NOT_NULL_CONSTRAINT },
    {"42000", qpERR_ABORT_QMV_DML_ON_CLOSED_TABLE },
    {"42S22", qpERR_ABORT_QMV_NOT_EXISTS_COLUMN },
    {"42000", qpERR_ABORT_QMV_COLUMN_AMBIGUOUS_DEF },
    {"42S02", qpERR_ABORT_QMV_NOT_EXISTS_ALIAS },
    {"42000", qpERR_ABORT_QMV_NO_SELECTED_EXPRESSION },
    {"42000", qpERR_ABORT_QMV_INVALID_POSITION_IN_ORDERBY },
    {"42000", qpERR_ABORT_QCV_NOT_ALLOWED_AGGREGATION },
    {"42000", qpERR_ABORT_QMV_MISMATCH_TARGET_COUNT },
    {"42000", qpERR_ABORT_QMV_INVALID_TABLE_NAME },
    {"42000", qpERR_ABORT_QMV_GROUP_ON_FORUPDATE },
    {"42000", qpERR_ABORT_QMV_AGGREGATE_ON_FORUPDATE },
    {"42000", qpERR_ABORT_QMV_DISTINCT_SETFUNCTION_ON_FORUPDATE },
    {"42000", qpERR_ABORT_QMV_JOIN_ON_FORUPDATE},
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_WITH_ORDER_BY },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_WITH_GROUP_BY },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_WITH_DISTINCT },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_WITH_SET },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_IN_VIEW },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_IN_SUBQUERY },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_IN_WHERE },
    {"42000", qpERR_ABORT_QMV_USE_SEQUENCE_IN_DEFAULT },
    {"42000", qpERR_ABORT_QMV_NESTED_AGGR_WITHOUT_GROUP },
    {"42000", qpERR_ABORT_QMV_TOO_DEEPLY_NESTED_AGGR },
    {"42000", qpERR_ABORT_QMV_DUP_COLUMN_IN_SET },
    {"3F000", qpERR_ABORT_QMX_SEQ_NOT_DEFINE_IN_SESSION },
    {"23000", qpERR_ABORT_QMX_NOT_NULL_CONSTRAINT },
    {"3F000", qpERR_ABORT_QRC_NOT_EXIST_REPLICATION },
    {"HY105", qpERR_ABORT_QTC_INVALID_ARGUMENT_TYPE },
    {"42000", qpERR_ABORT_QSV_DUPLICATE_PARAMETER_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_HAVE_RETURN_VALUE_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_HAVE_RETURN_VALUE_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_HAVE_RETURN_STMT },
    {"42000", qpERR_ABORT_QSV_PROC_MULTIPLE_REC_TARGET_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_EXIST_STMT_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_CANNOT_ASSIGN_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_USE_IN_LOOP_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_DUP_EXCEPTION_IN_HANDLER_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_EXIST_EXCEPTION_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_LOOP_LABEL_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_ASSIGN_LVALUE_NO_READONLY_VAR_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_SELECT_INTO_NO_READONLY_VAR_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_CURSOR_NAME_IS_SQL_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_ROWTYPE_IN_EXPRESSION_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_INVALID_OUT_ARGUEMNT_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_NOT_EXIST_VARIABLE_NAME_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_DUPLICATE_VARIABLE_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_CONSTANT_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_PROC_WRONG_CONSTANT_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_INAPPROPRIATE_INTO_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_NOT_HAVE_INTO_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_MISMATCHED_INTO_LIST_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_USING_ATTR_IN_INAPPROPRIATE_CLAUSE },
    {"42000", qpERR_ABORT_QSX_ROWTYPE_ON_RETURN_NOT_ALLOWED_ERROR_SQLTEXT },
    {"42000", qpERR_ABORT_QSX_ROWTYPE_ON_PARAM_NOT_ALLOWED_ERROR_SQLTEXT },
    {"42000", qpERR_ABORT_QSX_FUNCTION_WITH_NO_RETURN },
    {"42000", qpERR_ABORT_QSX_STEP_SIZE_LE_ZERO_SQLTEXT },
    {"42000", qpERR_ABORT_QSX_TOO_HIGH_CALL_DEPTH_ARG1 },
    {"24000", qpERR_ABORT_QSX_CURSOR_ALREADY_OPEN },
    {"24000", qpERR_ABORT_QSX_INVALID_CURSOR },
    {"42000", qpERR_ABORT_QSX_NOT_SUPPORTED_SQLTEXT },
    {"42S21", qpERR_ABORT_QDB_DUPLICATE_COLUMN_NAME },
    {"42000", qpERR_ABORT_QDB_NOT_ALLOWED_SUBQUERY },
    {"42000", qpERR_ABORT_QSV_NOT_ALLOWED_SUBQUERY_SQLTEXT },
    {"42000", qpERR_ABORT_QSV_NOT_CURSOR },
    {"42000", qpERR_ABORT_QCP_MAX_NAME_LENGTH_OVERFLOW },
    {"42000", qpERR_ABORT_QSF_FUNCTION_NOT_ALLOWED },
    {"42000", qpERR_ABORT_QMV_NOT_APPLICABLE_TYPE_IN_TARGET },
    {"42000", qpERR_ABORT_QCV_DML_ON_SEQUENCE },
    {"42000", qpERR_ABORT_QDS_CURR_LESS_MIN },
    {"42000", qpERR_ABORT_QDS_CURR_MORE_MAX },
    {"42000", qpERR_ABORT_QCC_CANNOT_EXEC_DDL },
    {"42000", qpERR_ABORT_QMV_HIERARCHICAL_WITH_JOIN },
    {"42000", qpERR_ABORT_QMV_HIERARCHICAL_WITH_VIEW },
    {"42000", qpERR_ABORT_QMV_SUBQ_IN_CONNECTBY },
    {"42000", qpERR_ABORT_QMV_PRIOR_WITHOUT_CONNECTBY },
    {"42000", qpERR_ABORT_QMN_HIER_LOOP },
    {"42000", qpERR_ABORT_QDD_NO_DROP_META_TABLE },
    {"42000", qpERR_ABORT_QDP_SELF_GRANT_OR_REVOKE },
    {"42000", qpERR_ABORT_QDP_INSUFFICIENT_PRIVILEGES },
    {"42000", qpERR_ABORT_QDP_DUPLICATE_PRIVILEGE },
    {"42000", qpERR_ABORT_QDP_WITHOUT_CASCADE_OPTION },
    {"42000", qpERR_ABORT_QDP_NOT_ALLOWED_PRIV },
    {"3F000", qpERR_ABORT_QDP_NOT_EXISTS_OBJECT },
    {"42000", qpERR_ABORT_QSV_NOT_ALLOWED_COUNTER_VAR_SQLTEXT },
    {"42000", qpERR_ABORT_QCV_DML_ON_READ_ONLY_VIEW },
    {"42000", qpERR_ABORT_QDP_NO_GRANT_DML_PRIV_OF_META_TABLE },
    {"42S02", qpERR_ABORT_QDV_NOT_EXISTS_VIEW },
    {"42000", qpERR_ABORT_QDV_CIRCULAR_VIEW },
    {"23000", qpERR_ABORT_QDB_DUPLICATE_TIMESTAMP_COLUMN },
    {"23000", qpERR_ABORT_QDB_CANNOT_SET_TIMESTAMP_DEFAULT },
    {"23000", qpERR_ABORT_QDN_CANNOT_DROP_TIMESTAMP },
    {"3D000", qpERR_ABORT_QDT_DUPLICATE_TBS_NAME },
    {"3D000", qpERR_ABORT_QDT_NOT_EXIST_TBS },
    {"42000", qpERR_ABORT_QDT_NO_DROP_SYSTEM_TBS },
    {"42000", qpERR_ABORT_QDT_OBJECT_EXIST },
    {"42000", qpERR_ABORT_QDT_NO_CREATE_IN_SYSTEM_TBS },
    {"42000", qpERR_ABORT_QDT_NO_ACCESS_TBS },
    {"42000", qpERR_ABORT_QDB_INVALID_INSERT_LOW_LIMIT },
    {"3D000", qpERR_ABORT_QDB_NO_MEMORY_OR_VOLATILE_TABLE },
    {"42000", qpERR_ABORT_QDX_UNSUPPORTED_INDEXTYPE },
    {"42000", qpERR_ABORT_QDT_INVALID_NEXT_SIZE },
    {"42000", qpERR_ABORT_QCV_NOT_ALLOWED_GROUPING_SET },
    {"42000", qpERR_ABORT_QDT_EXIST_FILE },
    {"42000", qpERR_ABORT_QDX_INVALID_INDEX_MEDIA },
    {"42000", qpERR_ABORT_QDN_NOT_ALLOWED_PRIMARY_AND_UNIQUE_KEY },
    {"42000", qpERR_ABORT_TRIGGER_INVALID_REFERENCING_GRANULARITY },
    {"3F000", qpERR_ABORT_TRIGGER_DUPLICATED_NAME },
    {"3F000", qpERR_ABORT_TRIGGER_NOT_EXIST },
    {"42000", qpERR_ABORT_TRIGGER_INVALID_REFERENCING },
    {"42S22", qpERR_ABORT_QCM_NOT_EXIST_COLUMN_NAME },
    {"42000", qpERR_ABORT_TRIGGER_WHEN_SUBQUERY },
    {"42000", qpERR_ABORT_TRIGGER_PSM },
    {"42000", qpERR_ABORT_TRIGGER_INVALID_ACTION_STMT },
    {"42000", qpERR_ABORT_TRIGGER_CYCLE_DETECTED },
    {"42000", qpERR_ABORT_TRIGGER_RECOMPILE },
    {"42000", qpERR_ABORT_TRIGGER_UNSUPPORTED },
    {"42000", qpERR_ABORT_TRIGGER_INVALID_TABLE_NAME },
    {"42000", qpERR_ABORT_NO_DDL_FOR_META },
    {"42000", qpERR_ABORT_QDT_INVALID_EXTENTSIZE },
    {"42000", qpERR_ABORT_INVALID_LIMIT_VALUE_TYPE },
    {"42000", qpERR_ABORT_QCP_INVALID_INSERT_LIMIT_OPTION },
    {"42000", qpERR_ABORT_QMV_MOVE_SAME_TABLE },
    {"01007", qpERR_ABORT_QDP_EXISTS_PRIVILEGE },
    {"42S02", qpERR_ABORT_NOT_FOUND_SYNONYM },
    {"42S01", qpERR_ABORT_SAME_SYNONYM },
    {"42000", qpERR_ABORT_QTC_TOO_MANY_TABLES },
    {"42000", qpERR_ABORT_QSF_INVALID_FILEOPEN_MODE },
    {"42000", qpERR_ABORT_QSF_DIRECTORY_ACCESS_DENIED },
    {"42000", qpERR_ABORT_QSV_DUPLICATE_LABEL },
    {"42000", qpERR_ABORT_QSV_ILLEGAL_GOTO },
    {"42000", qpERR_ABORT_QSF_INVALID_ERROR_RANGE },
    {"42000", qpERR_ABORT_QSV_PROC_NOT_USE_IN_EXCEPTION_HANDLER },
    {"42000", qpERR_ABORT_QCP_INVALID_PARALLEL_OPTION },
    {"42000", qpERR_ABORT_QCP_INVALID_TABLESPACE_OPTION },
    {"42000", qpERR_ABORT_QDQ_QUEUE_DML_DENIED },
    {"42000", qpERR_ABORT_QDQ_TABLE_ENQUEUE_DENIED },
    {"42000", qpERR_ABORT_QDQ_TABLE_DEQUEUE_DENIED },
    {"42000", qpERR_ABORT_QDQ_TABLE_DROP_QUEUE_DENIED },
    {"42000", qpERR_ABORT_QDQ_QUEUE_DROP_TABLE_DENIED },
    {"42000", qpERR_ABORT_QDQ_QUEUE_NAME_TOO_LONG },
    {"42000", qpERR_ABORT_QDQ_QUEUE_DEQUEUE_SUBQ_EXIST },
    {"42000", qpERR_ABORT_QDV_DDL_ON_VIEW },
    {"42000", qpERR_ABORT_INVALID_TRIGGER_TYPE },
    {"42000", qpERR_ABORT_QDP_NOT_EXIST_PRIVILEGE },
    {"42000", qpERR_ABORT_QDN_SELF_REFERENCE_NOT_SUPPORTED },
    {"08001", mmERR_ABORT_FAIL_TO_ESTABLISH_CONNECTION}, /* BUG-36465 */
    {"HY008", idERR_ABORT_Query_Canceled },
    {"22026", mtERR_ABORT_INVALID_LENGTH_COLUMN},
    {NULL, 0}
};

