CREATE OR REPLACE VIEW ADM_TABLE_MEM AS
SELECT A.TABLE_NAME, 
       B.PAGE_COUNT*32/1024 AS ALLOCFIXED, 
       (B.SLOT_COUNT) * B.SLOT_SIZE/1024/1024 AS USEDFIXED,
       C.ALLOCVAR,
       C.USEDVAR
FROM SYSTEM_.SYS_TABLES_ A,
     SYSTEM_.SYSX_FIXED_PAGE_MEMORY_ B,
     (
        SELECT TABLE_OID,
               SUM(PAGE_COUNT*32)/1024 AS ALLOCVAR, 
               SUM(SLOT_SIZE*(INSERTED_SLOT_COUNT - DELETED_SLOT_COUNT))/1024/1024 AS USEDVAR
        FROM SYSTEM_.SYSX_VAR_PAGE_MEMORY_ 
        GROUP BY TABLE_OID
     ) C
WHERE A.TABLE_OID = B.TABLE_OID AND
      B.TABLE_OID = C.TABLE_OID AND
      A.TABLE_TYPE ='T' AND
      A.TABLE_NAME not like 'SYSX_%'
;

