
/**

 Altibase  ӵ   մϴ. 

ID        :  Session ID 
CONN_INFO :  ӵ    
ACTIVE    :  Action θ Ǵմϴ. 
OPEN_STMT :  ش    Statment  
CURRENT_STMT :    Statement ID 
PROTOCOL :   Protocol 
COMMIT_MODE  : Commit  

**/

CREATE OR REPLACE VIEW ADM_SESSION AS
SELECT	ID, 
	REPLACE2(REPLACE2(COMM_NAME,'SOCKET-',NULL),'-SERVER',NULL) CONN_INFO,
	DECODE(ACTIVE_FLAG,1,'ACTIVE','INACTIVE') ACTIVE, 
	OPENED_STMT_COUNT OPEN_STMT,
	CURRENT_STMT_ID CURRENT_STMT,	
/*
	CLIENT_PID,DECODE(PROTOCOL_SESSION,
		1397051990,'HANDSHAKE FOR SYSDBA DISPATCH',
	        1094995278, 'HANDSHAKE FOR USERS DISPATCH',
	        1129270862, 'CONNECT',
	        1145652046, 'DISCONNECT',
		1229870668, 'INVALID',
		1280460613, 'TIMEOUT',
		1163022162, 'ERROR',
		1347568976, 'PREPARE',
		1163412803, 'EXECUTE',
		1162103122, 'EXECDIRECT',
		1179927368, 'FETCH',
		1179796805, 'FREE',
		1229931858, 'I/O ERROR',
		1161905998, 'EAGAIN ERROR',
		1480672077, 'XA COMMANDS',
		1094929998, 'ACKNOWLEDGE',
		1195725908, 'GET','UNKNOWN') PROTOCOL,
*/
	DECODE(AUTOCOMMIT_FLAG,0,'Non AutoCommit','AutoCommit') COMMIT_MODE
FROM V$SESSION;



/**

ü ̺  ȸ(Memory & Disk) 

TBS_NAME : Tablespace Name 
TABLE_NAME : Table Name 
ALLOCSIZE : Table  Ҵ  Size (Byte) 
TABLE_ID : Table Object ID 
REPL_COUNT : ش ̺ ɸ ø̼  

**/


CREATE OR REPLACE VIEW ADM_TABLE AS
SELECT	/* for Memory Tables */ 
	'SYS_TBS_MEMORY' TBS_NAME,
	B.USER_NAME||'.'||A.TABLE_NAME TABLE_NAME,
	(C.FIXED_ALLOC_MEM+C.VAR_ALLOC_MEM) ALLOCSIZE,
	TABLE_ID, 
	REPLICATION_COUNT REPL_COUNT
FROM 	SYSTEM_.SYS_TABLES_ A, SYSTEM_.SYS_USERS_ B, V$MEMTBL_INFO C
WHERE 	A.USER_ID = B.USER_ID AND
	A.TABLE_OID = C.TABLE_OID AND
	A.TBS_ID=0 AND A.USER_ID != 1
	AND A.TABLE_TYPE='T'
UNION ALL
SELECT  /* for Disk Tables */ 
	C.NAME TBS_NAME,
	B.USER_NAME||'.'||A.TABLE_NAME TABLE_NAME,
	C.EXTENT_PAGE_COUNT*C.PAGE_SIZE*D.EXTENT_TOTAL_COUNT ALLOCSIZE,
	TABLE_ID, 
	REPLICATION_COUNT REPL_COUNT
FROM 	SYSTEM_.SYS_TABLES_ A, SYSTEM_.SYS_USERS_ B, V$TABLESPACES C, V$SEGMENT D
WHERE 	A.USER_ID = B.USER_ID AND 
	A.TBS_ID = C.ID AND 
	D.TABLE_OID = A.TABLE_OID AND
	D.SEGMENT_TYPE='TABLE' AND
	A.TBS_ID != 0 AND A.USER_ID != 1;


/**

Constraint   ȸ 

TABLE_NAME : Contraint   ̺  
CONSTRAINT_NAME : Constraint  
CON_TYPE : Contraint  
INDEX_NAME : ش Constraint  index 縦 ʿ   ش Index  
REFERENCE_TABLE : Constraint  FK   ϴ ̺  
REFERENCE_INDEX : Constraint  FK   ϴ ε  

**/

CREATE OR REPLACE VIEW ADM_CONSTRAINT AS
SELECT	C.USER_NAME||'.'||B.TABLE_NAME TABLE_NAME,
	A.CONSTRAINT_NAME,
	DECODE(A.CONSTRAINT_TYPE,0,'FOREIGNKEY',
		1,'NOTNULL',
		2,'UNIQUE',
		3,'PRIMARYKEY',
		4,'NULL',
		5,'TIMESTAMP','UNKNOWN') CON_TYPE,
	D.INDEX_NAME,
	(SELECT TABLE_NAME FROM SYSTEM_.SYS_TABLES_ IT WHERE IT.TABLE_ID = A.REFERENCED_TABLE_ID) REFERENCE_TABLE,
	(SELECT INDEX_NAME FROM SYSTEM_.SYS_INDICES_ II WHERE II.INDEX_ID = A.REFERENCED_INDEX_ID) REFERENCE_INDEX
FROM	SYSTEM_.SYS_CONSTRAINTS_ A LEFT OUTER JOIN SYSTEM_.SYS_INDICES_ D
ON A.INDEX_ID = D.INDEX_ID ,
	SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C
WHERE	A.TABLE_ID = B.TABLE_ID AND 
	A.USER_ID = C.USER_ID
ORDER BY TABLE_NAME ,CON_TYPE;




/**

Segment   ȸ 

SEG_NAME : Segment   
TBS_NAME : ̺ ̽  
SEGMENT_TYPE : Segment  
EXTENT_TOTAL_COUNT : EXTENT   
ALLOC_SIZE : ALLOC  ü  
EXTENT_FULL : EXTENT   ִ  

**/
CREATE OR REPLACE VIEW ADM_SEGMENT AS
SELECT 	C.USER_NAME||'.'||B.TABLE_NAME SEG_NAME,
	D.NAME TBS_NAME, 
	A.SEGMENT_TYPE, 
	EXTENT_TOTAL_COUNT EXTENT_COUNT,
	D.EXTENT_PAGE_COUNT*D.PAGE_SIZE*A.EXTENT_TOTAL_COUNT ALLOC_SIZE,
	EXTENT_TOTAL_COUNT EXTENT_FULL
FROM	 V$SEGMENT A, SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C, V$TABLESPACES D
WHERE	
	A.TABLE_OID = B.TABLE_OID AND
	B.USER_ID = C.USER_ID AND
	A.SPACE_ID = D.ID AND 
	A.SEGMENT_TYPE='TABLE'
UNION ALL
SELECT 	C.USER_NAME||'.'||E.INDEX_NAME SEG_NAME,
	D.NAME TBS_NAME, 
	A.SEGMENT_TYPE, 
	EXTENT_TOTAL_COUNT EXTENT_COUNT,
	D.EXTENT_PAGE_COUNT*D.PAGE_SIZE*A.EXTENT_TOTAL_COUNT ALLOCSIZE,
	EXTENT_TOTAL_COUNT EXTENT_FULL
FROM	 V$SEGMENT A, X$INDEX B, SYSTEM_.SYS_USERS_ C, V$TABLESPACES D, SYSTEM_.SYS_INDICES_ E
WHERE
	A.SEGMENT_PID = B.INDEX_SEG_PID AND
	B.INDEX_ID = E.INDEX_ID AND
	E.USER_ID = C.USER_ID AND
	A.SPACE_ID = D.ID AND
	A.SEGMENT_TYPE='INDEX';

/**

 ε  

INDEX_ID : Index ID 
TABLE_NAME : ش ε ִ ̺  
TBS : Index Tablespace  
UNIQUENESS : Unique Index  
COLUMN_COUNT  : Column  


**/
CREATE OR REPLACE VIEW ADM_INDEX AS
SELECT	A.INDEX_ID, 
	C.USER_NAME||'.'||B.TABLE_NAME TABLE_NAME,
	A.INDEX_NAME INDEX_NAME,
	NVL(D.NAME,'MEMORY') TBS,
	DECODE(IS_UNIQUE,'T','UNIQUE','NONUIQUE') UNIQUENESS,
	A.COLUMN_CNT COLUMN_COUNT 
FROM	SYSTEM_.SYS_INDICES_ A LEFT OUTER JOIN V$TABLESPACES D
	ON A.TBS_ID = D.ID
	, SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C
WHERE	A.TABLE_ID = B.TABLE_ID	AND 
	A.USER_ID = C.USER_ID
	AND C.USER_ID != 1
ORDER BY TABLE_NAME, INDEX_NAME ;



/**

ε  ü ÷  

TABLE_NAME : ̺ 
INDEX_NAME : ε 
COLUMN_NAME : ÷ 
COLUMN_ORDER : ش ÷ Ordering   
**/

CREATE OR REPLACE VIEW ADM_INDEX_COLUMN AS
SELECT	D.USER_NAME||'.'||C.TABLE_NAME TABLE_NAME,
	B.INDEX_NAME, 
	E.COLUMN_NAME,
	DECODE(SORT_ORDER,'A','ASC','D','DESC') COLUMN_ORDER
FROM	SYSTEM_.SYS_INDEX_COLUMNS_ A, SYSTEM_.SYS_INDICES_ B,
	SYSTEM_.SYS_TABLES_ C, SYSTEM_.SYS_USERS_ D,
	SYSTEM_.SYS_COLUMNS_ E
WHERE	A.INDEX_ID = B.INDEX_ID AND
	A.TABLE_ID = C.TABLE_ID AND
	A.USER_ID = D.USER_ID AND
	A.COLUMN_ID = E.COLUMN_ID AND
	D.USER_ID != 1
ORDER BY TABLE_NAME, INDEX_NAME, INDEX_COL_ORDER;



/**


CREATE OR REPLACE VIEW ADM_MEMTBL AS
SELECT
        A.TABLE_OID TABLE_OID,
        C.USER_NAME||'.'||B.TABLE_NAME TABLE_NAME,
        A.MEM_SLOT_SIZE SLOT_SIZE,
        FIXED_ALLOC_MEM+VAR_ALLOC_MEM ALLOC_BYTE,
        FIXED_USED_MEM+VAR_USED_MEM USED_BYTE,
        ROUND( (FIXED_USED_MEM+VAR_USED_MEM)/(FIXED_ALLOC_MEM+VAR_ALLOC_MEM)*100
,2) EFFICIENCY
FROM            V$MEMTBL_INFO A ,SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C
WHERE           A.TABLE_OID = B.TABLE_OID AND B.USER_ID = C.USER_ID
AND C.USER_ID != 1
AND B.TABLE_TYPE = 'T'
ORDER BY TABLE_NAME;
**/


/**
ü 信   ȸ 
	
VIEW_NAME :   
VIEW_ID   : View Object ID 
STATUS	  : View   

**/

CREATE OR REPLACE VIEW ADM_VIEW AS
SELECT	C.USER_NAME||'.'||B.TABLE_NAME VIEW_NAME,
	A.VIEW_ID,
	DECODE(A.STATUS,0,'VALID','INVALID') STATUS
FROM	SYSTEM_.SYS_VIEWS_ A, SYSTEM_.SYS_TABLES_ B,
	SYSTEM_.SYS_USERS_ C
WHERE A.VIEW_ID = B.TABLE_ID AND A.USER_ID=C.USER_ID
ORDER BY VIEW_NAME;




/**

  Ÿ  

SEQ_NAME : SEQUENCE  
CURRENT_SEQ :  SEQUENCE ȣ 
START_SEQ   : SEQUENCE  ȣ 
INCREMENT_SEQ :  ȣ 
CACHE_SIZE : ĳ 
MAX_SEQ : ִ  
MIN_SEQ : ּ  
IS_CYCLE : ȯ  

**/

CREATE OR REPLACE VIEW ADM_SEQUENCE AS
SELECT	C.USER_NAME||'.'||B.TABLE_NAME SEQ_NAME,
	A.CURRENT_SEQ,
	A.START_SEQ, 
	A.INCREMENT_SEQ,
	A.CACHE_SIZE, 
	A.MAX_SEQ, 
	A.MIN_SEQ, 
	A.IS_CYCLE
FROM	V$SEQ A, SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C
WHERE	A.SEQ_OID = B.TABLE_OID AND
	B.USER_ID = C.USER_ID AND
	B.USER_ID != 1
ORDER BY SEQ_NAME;



/**

ڵ ý  ȸ 

USER_ID : User id 
USER_NAME : ڸ 
DEFAULT_TBS_ID : ⺻ ̺ ̽ ID
DEFAULT_TBS_NAME : ⺻ ̺ ̽  
GRANTOR :  ο 
PRIV_NAME : Ѹ 
**/

CREATE OR REPLACE VIEW ADM_USER_SYS_PRIV AS 
SELECT 
         Y.USER_ID, 
         Y.USER_NAME, 
         Y.DEFAULT_TBS_ID DEFAULT_TBS_ID, 
         DECODE(Y.DEFAULT_TBS_ID, 0, 'SYS_TBS_MEMORY', (SELECT NAME FROM V$TABLESPACES WHERE ID = 
Y.DEFAULT_TBS_ID)) DEFAULT_TBS, 
         (SELECT USER_NAME FROM SYSTEM_.SYS_USERS_ WHERE USER_ID = X.GRANTOR_ID) GRANTOR, 
         (SELECT PRIV_NAME FROM SYSTEM_.SYS_PRIVILEGES_ WHERE PRIV_ID = X.PRIV_ID) PRIV_NAME
FROM 
         SYSTEM_.SYS_GRANT_SYSTEM_  X INNER JOIN SYSTEM_.SYS_USERS_ Y ON X.GRANTEE_ID = Y.USER_ID 
WHERE 
	Y.USER_ID != 1
ORDER BY Y.USER_ID;


/**

޸ ̺   ȸ 

TABLE_OID : ̺ ü ̵ 
TABLE_NAME : ̺ 
SLOT_SIZE :  ũ 
ALLOC_BYTE : ش ̺ Ҵ ũ 
USED_BYTE  :   ũ  
EFFICIENCY : Ȱ 

**/

CREATE OR REPLACE VIEW ADM_MEMTBL AS 
SELECT 
	A.TABLE_OID TABLE_OID, 
	C.USER_NAME||'.'||B.TABLE_NAME TABLE_NAME, 
	A.MEM_SLOT_SIZE SLOT_SIZE,
	FIXED_ALLOC_MEM+VAR_ALLOC_MEM ALLOC_BYTE,
	FIXED_USED_MEM+VAR_USED_MEM USED_BYTE,
	ROUND( (FIXED_USED_MEM+VAR_USED_MEM)/(FIXED_ALLOC_MEM+VAR_ALLOC_MEM)*100,2) EFFICIENCY
FROM    	V$MEMTBL_INFO A ,SYSTEM_.SYS_TABLES_ B, SYSTEM_.SYS_USERS_ C
WHERE   	A.TABLE_OID = B.TABLE_OID AND B.USER_ID = C.USER_ID
AND C.USER_ID != 1
AND B.TABLE_TYPE = 'T'
ORDER BY TABLE_NAME;


/**

ø̼  ȸ


REPLICATION_NAME : Replication Name
XSN              : Restart SN
REP_GAP          : Replication Gap
SENDER_STAT      : Sender 
RECEIVER_STAT    : Reciever 

**/

CREATE OR REPLACE VIEW ADM_REPLICATION AS
SELECT A.REPLICATION_NAME,
       A.XSN,
       NVL(TO_CHAR(E.REP_GAP), 'N/A') AS REP_GAP,
       D.HOST_IP || ' (' || D.PORT_NO || '):' || DECODE(B.STATUS, 0, 'STOP', 1, 'RUN', 2, 'RETRY', 'STOP') AS SENDER_STAT,
       DECODE(C.REP_NAME, NULL, 'OFF', 'ON') AS RECEIVER_STAT
  FROM
       SYSTEM_.SYS_REPL_HOSTS_ D,
       SYSTEM_.SYS_REPLICATIONS_ A
         LEFT OUTER JOIN V$REPSENDER B   ON A.REPLICATION_NAME = B.REP_NAME
         LEFT OUTER JOIN V$REPRECEIVER C ON A.REPLICATION_NAME = C.REP_NAME
         LEFT OUTER JOIN ( SELECT REP_NAME, MAX(REP_GAP) AS REP_GAP
                             FROM V$REPGAP
                            GROUP BY REP_NAME
                         ) E             ON A.REPLICATION_NAME = E.REP_NAME
 WHERE A.REPLICATION_NAME = D.REPLICATION_NAME
   AND A.LAST_USED_HOST_NO = D.HOST_NO
 ORDER BY A.REPLICATION_NAME
;
