-- For table REGION
ALTER TABLE REGION
ADD PRIMARY KEY (R_REGIONKEY);

-- For table NATION
ALTER TABLE NATION
ADD PRIMARY KEY (N_NATIONKEY);

ALTER TABLE NATION
--ADD FOREIGN KEY NATION_FK1 (N_REGIONKEY) references REGION;
ADD CONSTRAINT NATION_FK1 FOREIGN KEY (N_REGIONKEY) REFERENCES REGION (R_REGIONKEY);

-- For table PART
ALTER TABLE PART
ADD PRIMARY KEY (P_PARTKEY);

-- For table SUPPLIER
ALTER TABLE SUPPLIER
ADD PRIMARY KEY (S_SUPPKEY);

ALTER TABLE SUPPLIER
--ADD FOREIGN KEY SUPPLIER_FK1 (S_NATIONKEY) references NATION;
ADD CONSTRAINT SUPPLIER_FK1 FOREIGN KEY (S_NATIONKEY) REFERENCES NATION (N_NATIONKEY);

-- For table PARTSUPP
ALTER TABLE PARTSUPP
ADD PRIMARY KEY (PS_PARTKEY,PS_SUPPKEY);

-- For table CUSTOMER
ALTER TABLE CUSTOMER
ADD PRIMARY KEY (C_CUSTKEY);

ALTER TABLE CUSTOMER
--ADD FOREIGN KEY CUSTOMER_FK1 (C_NATIONKEY) references NATION;
ADD CONSTRAINT CUSTOMER_FK1 FOREIGN KEY (C_NATIONKEY) REFERENCES NATION (N_NATIONKEY);

-- For table LINEITEM
ALTER TABLE LINEITEM
ADD PRIMARY KEY (L_ORDERKEY,L_LINENUMBER);

-- For table ORDERS
ALTER TABLE ORDERS
ADD PRIMARY KEY (O_ORDERKEY);

-- For table PARTSUPP
ALTER TABLE PARTSUPP
--ADD FOREIGN KEY PARTSUPP_FK1 (PS_SUPPKEY) references SUPPLIER;
ADD CONSTRAINT PARTSUPP_FK1 FOREIGN KEY (PS_SUPPKEY) REFERENCES SUPPLIER (S_SUPPKEY);

ALTER TABLE PARTSUPP
--ADD FOREIGN KEY PARTSUPP_FK2 (PS_PARTKEY) references PART;
ADD CONSTRAINT PARTSUPP_FK2 FOREIGN KEY (PS_PARTKEY) REFERENCES PART (P_PARTKEY);

-- For table ORDERS
ALTER TABLE ORDERS
--ADD FOREIGN KEY ORDERS_FK1 (O_CUSTKEY) references CUSTOMER;
ADD CONSTRAINT ORDERS_FK1 FOREIGN KEY (O_CUSTKEY) REFERENCES CUSTOMER (C_CUSTKEY);

-- For table LINEITEM
ALTER TABLE LINEITEM
--ADD FOREIGN KEY LINEITEM_FK1 (L_ORDERKEY)  references ORDERS;
ADD CONSTRAINT LINEITEM_FK1 FOREIGN KEY (L_ORDERKEY) REFERENCES ORDERS (O_ORDERKEY);

ALTER TABLE LINEITEM
--ADD FOREIGN KEY LINEITEM_FK2 (L_PARTKEY,L_SUPPKEY) references 
--        PARTSUPP;
ADD CONSTRAINT LINEITEM_FK2 FOREIGN KEY (L_PARTKEY,L_SUPPKEY) REFERENCES PARTSUPP(PS_PARTKEY, PS_SUPPKEY);

-- add date column index ( by altibase )
CREATE INDEX O_IDX_ORDERDATE ON ORDERS( O_ORDERDATE );
CREATE INDEX L_IDX_SHIPDATE ON LINEITEM( L_SHIPDATE );
CREATE INDEX L_IDX_RECEIPTDATE ON LINEITEM( L_RECEIPTDATE );
