ALTER SESSION SET EXPLAIN PLAN = ON;
ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 1;

SET TIMING ON;
SET TIMESCALE MILSEC;

SELECT L_SHIPMODE,
       SUM( CASE2 ( O_ORDERPRIORITY = '1-URGENT' OR O_ORDERPRIORITY = '2-HIGH',
                   1, 0 ) ) AS HIGH_LINE_COUNT,
       SUM ( CASE2 ( O_ORDERPRIORITY <> '1-URGENT' AND 
                    O_ORDERPRIORITY <> '2-HIGH', 1, 0 ) ) AS LOW_LINE_COUNT
FROM ORDERS,
     LINEITEM
WHERE O_ORDERKEY = L_ORDERKEY
  AND L_SHIPMODE IN ('MAIL', 'SHIP')
  AND L_COMMITDATE < L_RECEIPTDATE
  AND L_SHIPDATE < L_COMMITDATE
  AND L_RECEIPTDATE >= DATE'01-JAN-1994'
  AND L_RECEIPTDATE < ADD_MONTHS(DATE'01-JAN-1994', 12)
GROUP BY L_SHIPMODE
ORDER BY L_SHIPMODE; 

ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 0;

