ALTER SESSION SET EXPLAIN PLAN = ON;
ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 1;

SET TIMING ON;
SET TIMESCALE MILSEC;

SELECT 100.00 * SUM( CASE2 ( SUBSTRING(P_TYPE, 1, 5) = 'PROMO', 
					         L_EXTENDEDPRICE * (1 - L_DISCOUNT), 
					         0 ) ) 
			    / SUM(L_EXTENDEDPRICE * (1 - L_DISCOUNT)) AS PROMO_REVENUE
FROM
	LINEITEM,
	PART
WHERE
	L_PARTKEY = P_PARTKEY
	AND L_SHIPDATE >= DATE'01-SEP-1995'
	AND L_SHIPDATE < ADD_MONTHS(DATE'01-SEP-1995', 1);

ALTER SYSTEM SET TRCLOG_EXPLAIN_GRAPH = 0;
